# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DavisCopilotArgs', 'DavisCopilot']

@pulumi.input_type
class DavisCopilotArgs:
    def __init__(__self__, *,
                 enable_copilot: pulumi.Input[bool],
                 blocklist_entries: Optional[pulumi.Input['DavisCopilotBlocklistEntriesArgs']] = None,
                 enable_tenant_aware_data_mining: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a DavisCopilot resource.
        :param pulumi.Input[bool] enable_copilot: Please note that once enabled, you still need to [assign permissions](https://dt-url.net/rh22idn) to the relevant user groups.
        :param pulumi.Input['DavisCopilotBlocklistEntriesArgs'] blocklist_entries: You can exclude specific data buckets and tables from the Davis CoPilot semantic index. Learn more about [configuring data access](https://dt-url.net/lc62i1q).
        :param pulumi.Input[bool] enable_tenant_aware_data_mining: You can enrich Davis CoPilot with your environment data. This lets you generate more accurate queries that identify and reference relevant entities, events, spans, logs, and metrics from your environment. Once enabled, Davis CoPilot periodically scans your Grail data to create its own semantic index. Please note, it can take up to 24 hours to reflect changes. Learn more about [environment-aware queries](https://dt-url.net/4g42iu7).
        """
        pulumi.set(__self__, "enable_copilot", enable_copilot)
        if blocklist_entries is not None:
            pulumi.set(__self__, "blocklist_entries", blocklist_entries)
        if enable_tenant_aware_data_mining is not None:
            pulumi.set(__self__, "enable_tenant_aware_data_mining", enable_tenant_aware_data_mining)

    @property
    @pulumi.getter(name="enableCopilot")
    def enable_copilot(self) -> pulumi.Input[bool]:
        """
        Please note that once enabled, you still need to [assign permissions](https://dt-url.net/rh22idn) to the relevant user groups.
        """
        return pulumi.get(self, "enable_copilot")

    @enable_copilot.setter
    def enable_copilot(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enable_copilot", value)

    @property
    @pulumi.getter(name="blocklistEntries")
    def blocklist_entries(self) -> Optional[pulumi.Input['DavisCopilotBlocklistEntriesArgs']]:
        """
        You can exclude specific data buckets and tables from the Davis CoPilot semantic index. Learn more about [configuring data access](https://dt-url.net/lc62i1q).
        """
        return pulumi.get(self, "blocklist_entries")

    @blocklist_entries.setter
    def blocklist_entries(self, value: Optional[pulumi.Input['DavisCopilotBlocklistEntriesArgs']]):
        pulumi.set(self, "blocklist_entries", value)

    @property
    @pulumi.getter(name="enableTenantAwareDataMining")
    def enable_tenant_aware_data_mining(self) -> Optional[pulumi.Input[bool]]:
        """
        You can enrich Davis CoPilot with your environment data. This lets you generate more accurate queries that identify and reference relevant entities, events, spans, logs, and metrics from your environment. Once enabled, Davis CoPilot periodically scans your Grail data to create its own semantic index. Please note, it can take up to 24 hours to reflect changes. Learn more about [environment-aware queries](https://dt-url.net/4g42iu7).
        """
        return pulumi.get(self, "enable_tenant_aware_data_mining")

    @enable_tenant_aware_data_mining.setter
    def enable_tenant_aware_data_mining(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_tenant_aware_data_mining", value)


@pulumi.input_type
class _DavisCopilotState:
    def __init__(__self__, *,
                 blocklist_entries: Optional[pulumi.Input['DavisCopilotBlocklistEntriesArgs']] = None,
                 enable_copilot: Optional[pulumi.Input[bool]] = None,
                 enable_tenant_aware_data_mining: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering DavisCopilot resources.
        :param pulumi.Input['DavisCopilotBlocklistEntriesArgs'] blocklist_entries: You can exclude specific data buckets and tables from the Davis CoPilot semantic index. Learn more about [configuring data access](https://dt-url.net/lc62i1q).
        :param pulumi.Input[bool] enable_copilot: Please note that once enabled, you still need to [assign permissions](https://dt-url.net/rh22idn) to the relevant user groups.
        :param pulumi.Input[bool] enable_tenant_aware_data_mining: You can enrich Davis CoPilot with your environment data. This lets you generate more accurate queries that identify and reference relevant entities, events, spans, logs, and metrics from your environment. Once enabled, Davis CoPilot periodically scans your Grail data to create its own semantic index. Please note, it can take up to 24 hours to reflect changes. Learn more about [environment-aware queries](https://dt-url.net/4g42iu7).
        """
        if blocklist_entries is not None:
            pulumi.set(__self__, "blocklist_entries", blocklist_entries)
        if enable_copilot is not None:
            pulumi.set(__self__, "enable_copilot", enable_copilot)
        if enable_tenant_aware_data_mining is not None:
            pulumi.set(__self__, "enable_tenant_aware_data_mining", enable_tenant_aware_data_mining)

    @property
    @pulumi.getter(name="blocklistEntries")
    def blocklist_entries(self) -> Optional[pulumi.Input['DavisCopilotBlocklistEntriesArgs']]:
        """
        You can exclude specific data buckets and tables from the Davis CoPilot semantic index. Learn more about [configuring data access](https://dt-url.net/lc62i1q).
        """
        return pulumi.get(self, "blocklist_entries")

    @blocklist_entries.setter
    def blocklist_entries(self, value: Optional[pulumi.Input['DavisCopilotBlocklistEntriesArgs']]):
        pulumi.set(self, "blocklist_entries", value)

    @property
    @pulumi.getter(name="enableCopilot")
    def enable_copilot(self) -> Optional[pulumi.Input[bool]]:
        """
        Please note that once enabled, you still need to [assign permissions](https://dt-url.net/rh22idn) to the relevant user groups.
        """
        return pulumi.get(self, "enable_copilot")

    @enable_copilot.setter
    def enable_copilot(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_copilot", value)

    @property
    @pulumi.getter(name="enableTenantAwareDataMining")
    def enable_tenant_aware_data_mining(self) -> Optional[pulumi.Input[bool]]:
        """
        You can enrich Davis CoPilot with your environment data. This lets you generate more accurate queries that identify and reference relevant entities, events, spans, logs, and metrics from your environment. Once enabled, Davis CoPilot periodically scans your Grail data to create its own semantic index. Please note, it can take up to 24 hours to reflect changes. Learn more about [environment-aware queries](https://dt-url.net/4g42iu7).
        """
        return pulumi.get(self, "enable_tenant_aware_data_mining")

    @enable_tenant_aware_data_mining.setter
    def enable_tenant_aware_data_mining(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_tenant_aware_data_mining", value)


class DavisCopilot(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 blocklist_entries: Optional[pulumi.Input[Union['DavisCopilotBlocklistEntriesArgs', 'DavisCopilotBlocklistEntriesArgsDict']]] = None,
                 enable_copilot: Optional[pulumi.Input[bool]] = None,
                 enable_tenant_aware_data_mining: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        Create a DavisCopilot resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['DavisCopilotBlocklistEntriesArgs', 'DavisCopilotBlocklistEntriesArgsDict']] blocklist_entries: You can exclude specific data buckets and tables from the Davis CoPilot semantic index. Learn more about [configuring data access](https://dt-url.net/lc62i1q).
        :param pulumi.Input[bool] enable_copilot: Please note that once enabled, you still need to [assign permissions](https://dt-url.net/rh22idn) to the relevant user groups.
        :param pulumi.Input[bool] enable_tenant_aware_data_mining: You can enrich Davis CoPilot with your environment data. This lets you generate more accurate queries that identify and reference relevant entities, events, spans, logs, and metrics from your environment. Once enabled, Davis CoPilot periodically scans your Grail data to create its own semantic index. Please note, it can take up to 24 hours to reflect changes. Learn more about [environment-aware queries](https://dt-url.net/4g42iu7).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DavisCopilotArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a DavisCopilot resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param DavisCopilotArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DavisCopilotArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 blocklist_entries: Optional[pulumi.Input[Union['DavisCopilotBlocklistEntriesArgs', 'DavisCopilotBlocklistEntriesArgsDict']]] = None,
                 enable_copilot: Optional[pulumi.Input[bool]] = None,
                 enable_tenant_aware_data_mining: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DavisCopilotArgs.__new__(DavisCopilotArgs)

            __props__.__dict__["blocklist_entries"] = blocklist_entries
            if enable_copilot is None and not opts.urn:
                raise TypeError("Missing required property 'enable_copilot'")
            __props__.__dict__["enable_copilot"] = enable_copilot
            __props__.__dict__["enable_tenant_aware_data_mining"] = enable_tenant_aware_data_mining
        super(DavisCopilot, __self__).__init__(
            'dynatrace:index/davisCopilot:DavisCopilot',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            blocklist_entries: Optional[pulumi.Input[Union['DavisCopilotBlocklistEntriesArgs', 'DavisCopilotBlocklistEntriesArgsDict']]] = None,
            enable_copilot: Optional[pulumi.Input[bool]] = None,
            enable_tenant_aware_data_mining: Optional[pulumi.Input[bool]] = None) -> 'DavisCopilot':
        """
        Get an existing DavisCopilot resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['DavisCopilotBlocklistEntriesArgs', 'DavisCopilotBlocklistEntriesArgsDict']] blocklist_entries: You can exclude specific data buckets and tables from the Davis CoPilot semantic index. Learn more about [configuring data access](https://dt-url.net/lc62i1q).
        :param pulumi.Input[bool] enable_copilot: Please note that once enabled, you still need to [assign permissions](https://dt-url.net/rh22idn) to the relevant user groups.
        :param pulumi.Input[bool] enable_tenant_aware_data_mining: You can enrich Davis CoPilot with your environment data. This lets you generate more accurate queries that identify and reference relevant entities, events, spans, logs, and metrics from your environment. Once enabled, Davis CoPilot periodically scans your Grail data to create its own semantic index. Please note, it can take up to 24 hours to reflect changes. Learn more about [environment-aware queries](https://dt-url.net/4g42iu7).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DavisCopilotState.__new__(_DavisCopilotState)

        __props__.__dict__["blocklist_entries"] = blocklist_entries
        __props__.__dict__["enable_copilot"] = enable_copilot
        __props__.__dict__["enable_tenant_aware_data_mining"] = enable_tenant_aware_data_mining
        return DavisCopilot(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="blocklistEntries")
    def blocklist_entries(self) -> pulumi.Output[Optional['outputs.DavisCopilotBlocklistEntries']]:
        """
        You can exclude specific data buckets and tables from the Davis CoPilot semantic index. Learn more about [configuring data access](https://dt-url.net/lc62i1q).
        """
        return pulumi.get(self, "blocklist_entries")

    @property
    @pulumi.getter(name="enableCopilot")
    def enable_copilot(self) -> pulumi.Output[bool]:
        """
        Please note that once enabled, you still need to [assign permissions](https://dt-url.net/rh22idn) to the relevant user groups.
        """
        return pulumi.get(self, "enable_copilot")

    @property
    @pulumi.getter(name="enableTenantAwareDataMining")
    def enable_tenant_aware_data_mining(self) -> pulumi.Output[Optional[bool]]:
        """
        You can enrich Davis CoPilot with your environment data. This lets you generate more accurate queries that identify and reference relevant entities, events, spans, logs, and metrics from your environment. Once enabled, Davis CoPilot periodically scans your Grail data to create its own semantic index. Please note, it can take up to 24 hours to reflect changes. Learn more about [environment-aware queries](https://dt-url.net/4g42iu7).
        """
        return pulumi.get(self, "enable_tenant_aware_data_mining")

