# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CalculatedServiceMetricArgs', 'CalculatedServiceMetric']

@pulumi.input_type
class CalculatedServiceMetricArgs:
    def __init__(__self__, *,
                 metric_key: pulumi.Input[str],
                 unit: pulumi.Input[str],
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['CalculatedServiceMetricConditionArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dimension_definition: Optional[pulumi.Input['CalculatedServiceMetricDimensionDefinitionArgs']] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 entity_id: Optional[pulumi.Input[str]] = None,
                 ignore_muted_requests: Optional[pulumi.Input[bool]] = None,
                 management_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 metric_definition: Optional[pulumi.Input['CalculatedServiceMetricMetricDefinitionArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 unit_display_name: Optional[pulumi.Input[str]] = None,
                 unknowns: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a CalculatedServiceMetric resource.
        :param pulumi.Input[str] metric_key: The key of the calculated service metric
        :param pulumi.Input[str] unit: The unit of the metric. Possible values are `BIT`, `BIT_PER_HOUR`, `BIT_PER_MINUTE`, `BIT_PER_SECOND`, `BYTE`,
               `BYTE_PER_HOUR`, `BYTE_PER_MINUTE`, `BYTE_PER_SECOND`, `CORES`, `COUNT`, `DAY`, `DECIBEL_MILLI_WATT`, `GIBI_BYTE`,
               `GIGA`, `GIGA_BYTE`, `HOUR`, `KIBI_BYTE`, `KIBI_BYTE_PER_HOUR`, `KIBI_BYTE_PER_MINUTE`, `KIBI_BYTE_PER_SECOND`, `KILO`,
               `KILO_BYTE`, `KILO_BYTE_PER_HOUR`, `KILO_BYTE_PER_MINUTE`, `KILO_BYTE_PER_SECOND`, `MEBI_BYTE`, `MEBI_BYTE_PER_HOUR`,
               `MEBI_BYTE_PER_MINUTE`, `MEBI_BYTE_PER_SECOND`, `MEGA`, `MEGA_BYTE`, `MEGA_BYTE_PER_HOUR`, `MEGA_BYTE_PER_MINUTE`,
               `MEGA_BYTE_PER_SECOND`, `MICRO_SECOND`, `MILLI_CORES`, `MILLI_SECOND`, `MILLI_SECOND_PER_MINUTE`, `MINUTE`, `MONTH`,
               `MSU`, `NANO_SECOND`, `NANO_SECOND_PER_MINUTE`, `NOT_APPLICABLE`, `PERCENT`, `PER_HOUR`, `PER_MINUTE`, `PER_SECOND`,
               `PIXEL`, `PROMILLE`, `RATIO`, `SECOND`, `STATE`, `UNSPECIFIED`, `WEEK` and `YEAR`
        :param pulumi.Input[Sequence[pulumi.Input['CalculatedServiceMetricConditionArgs']]] conditions: The set of conditions for the metric usage. **All** the specified conditions must be fulfilled to use the metric
        :param pulumi.Input[str] description: The displayed description of the metric
        :param pulumi.Input['CalculatedServiceMetricDimensionDefinitionArgs'] dimension_definition: Parameters of a definition of a calculated service metric
        :param pulumi.Input[bool] enabled: The metric is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[str] entity_id: Restricts the metric usage to the specified service. This field is mutually exclusive with the `management_zones` field
        :param pulumi.Input[bool] ignore_muted_requests: Metric should (true) or not (false) ignore muted requests.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] management_zones: Restricts the metric usage to specified management zones. This field is mutually exclusive with the `entity_id` field
        :param pulumi.Input['CalculatedServiceMetricMetricDefinitionArgs'] metric_definition: The definition of a calculated service metric
        :param pulumi.Input[str] name: The displayed name of the metric
        :param pulumi.Input[str] unit_display_name: The display name of the metric's unit. Only applicable when the **unit** parameter is set to `UNSPECIFIED`
        :param pulumi.Input[str] unknowns: allows for configuring properties that are not explicitly supported by the current version of this provider
        """
        pulumi.set(__self__, "metric_key", metric_key)
        pulumi.set(__self__, "unit", unit)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dimension_definition is not None:
            pulumi.set(__self__, "dimension_definition", dimension_definition)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if entity_id is not None:
            pulumi.set(__self__, "entity_id", entity_id)
        if ignore_muted_requests is not None:
            pulumi.set(__self__, "ignore_muted_requests", ignore_muted_requests)
        if management_zones is not None:
            pulumi.set(__self__, "management_zones", management_zones)
        if metric_definition is not None:
            pulumi.set(__self__, "metric_definition", metric_definition)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if unit_display_name is not None:
            pulumi.set(__self__, "unit_display_name", unit_display_name)
        if unknowns is not None:
            pulumi.set(__self__, "unknowns", unknowns)

    @property
    @pulumi.getter(name="metricKey")
    def metric_key(self) -> pulumi.Input[str]:
        """
        The key of the calculated service metric
        """
        return pulumi.get(self, "metric_key")

    @metric_key.setter
    def metric_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "metric_key", value)

    @property
    @pulumi.getter
    def unit(self) -> pulumi.Input[str]:
        """
        The unit of the metric. Possible values are `BIT`, `BIT_PER_HOUR`, `BIT_PER_MINUTE`, `BIT_PER_SECOND`, `BYTE`,
        `BYTE_PER_HOUR`, `BYTE_PER_MINUTE`, `BYTE_PER_SECOND`, `CORES`, `COUNT`, `DAY`, `DECIBEL_MILLI_WATT`, `GIBI_BYTE`,
        `GIGA`, `GIGA_BYTE`, `HOUR`, `KIBI_BYTE`, `KIBI_BYTE_PER_HOUR`, `KIBI_BYTE_PER_MINUTE`, `KIBI_BYTE_PER_SECOND`, `KILO`,
        `KILO_BYTE`, `KILO_BYTE_PER_HOUR`, `KILO_BYTE_PER_MINUTE`, `KILO_BYTE_PER_SECOND`, `MEBI_BYTE`, `MEBI_BYTE_PER_HOUR`,
        `MEBI_BYTE_PER_MINUTE`, `MEBI_BYTE_PER_SECOND`, `MEGA`, `MEGA_BYTE`, `MEGA_BYTE_PER_HOUR`, `MEGA_BYTE_PER_MINUTE`,
        `MEGA_BYTE_PER_SECOND`, `MICRO_SECOND`, `MILLI_CORES`, `MILLI_SECOND`, `MILLI_SECOND_PER_MINUTE`, `MINUTE`, `MONTH`,
        `MSU`, `NANO_SECOND`, `NANO_SECOND_PER_MINUTE`, `NOT_APPLICABLE`, `PERCENT`, `PER_HOUR`, `PER_MINUTE`, `PER_SECOND`,
        `PIXEL`, `PROMILLE`, `RATIO`, `SECOND`, `STATE`, `UNSPECIFIED`, `WEEK` and `YEAR`
        """
        return pulumi.get(self, "unit")

    @unit.setter
    def unit(self, value: pulumi.Input[str]):
        pulumi.set(self, "unit", value)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CalculatedServiceMetricConditionArgs']]]]:
        """
        The set of conditions for the metric usage. **All** the specified conditions must be fulfilled to use the metric
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CalculatedServiceMetricConditionArgs']]]]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The displayed description of the metric
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="dimensionDefinition")
    def dimension_definition(self) -> Optional[pulumi.Input['CalculatedServiceMetricDimensionDefinitionArgs']]:
        """
        Parameters of a definition of a calculated service metric
        """
        return pulumi.get(self, "dimension_definition")

    @dimension_definition.setter
    def dimension_definition(self, value: Optional[pulumi.Input['CalculatedServiceMetricDimensionDefinitionArgs']]):
        pulumi.set(self, "dimension_definition", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        The metric is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="entityId")
    def entity_id(self) -> Optional[pulumi.Input[str]]:
        """
        Restricts the metric usage to the specified service. This field is mutually exclusive with the `management_zones` field
        """
        return pulumi.get(self, "entity_id")

    @entity_id.setter
    def entity_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "entity_id", value)

    @property
    @pulumi.getter(name="ignoreMutedRequests")
    def ignore_muted_requests(self) -> Optional[pulumi.Input[bool]]:
        """
        Metric should (true) or not (false) ignore muted requests.
        """
        return pulumi.get(self, "ignore_muted_requests")

    @ignore_muted_requests.setter
    def ignore_muted_requests(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ignore_muted_requests", value)

    @property
    @pulumi.getter(name="managementZones")
    def management_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Restricts the metric usage to specified management zones. This field is mutually exclusive with the `entity_id` field
        """
        return pulumi.get(self, "management_zones")

    @management_zones.setter
    def management_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "management_zones", value)

    @property
    @pulumi.getter(name="metricDefinition")
    def metric_definition(self) -> Optional[pulumi.Input['CalculatedServiceMetricMetricDefinitionArgs']]:
        """
        The definition of a calculated service metric
        """
        return pulumi.get(self, "metric_definition")

    @metric_definition.setter
    def metric_definition(self, value: Optional[pulumi.Input['CalculatedServiceMetricMetricDefinitionArgs']]):
        pulumi.set(self, "metric_definition", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The displayed name of the metric
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="unitDisplayName")
    def unit_display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The display name of the metric's unit. Only applicable when the **unit** parameter is set to `UNSPECIFIED`
        """
        return pulumi.get(self, "unit_display_name")

    @unit_display_name.setter
    def unit_display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "unit_display_name", value)

    @property
    @pulumi.getter
    def unknowns(self) -> Optional[pulumi.Input[str]]:
        """
        allows for configuring properties that are not explicitly supported by the current version of this provider
        """
        return pulumi.get(self, "unknowns")

    @unknowns.setter
    def unknowns(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "unknowns", value)


@pulumi.input_type
class _CalculatedServiceMetricState:
    def __init__(__self__, *,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['CalculatedServiceMetricConditionArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dimension_definition: Optional[pulumi.Input['CalculatedServiceMetricDimensionDefinitionArgs']] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 entity_id: Optional[pulumi.Input[str]] = None,
                 ignore_muted_requests: Optional[pulumi.Input[bool]] = None,
                 management_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 metric_definition: Optional[pulumi.Input['CalculatedServiceMetricMetricDefinitionArgs']] = None,
                 metric_key: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 unit: Optional[pulumi.Input[str]] = None,
                 unit_display_name: Optional[pulumi.Input[str]] = None,
                 unknowns: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering CalculatedServiceMetric resources.
        :param pulumi.Input[Sequence[pulumi.Input['CalculatedServiceMetricConditionArgs']]] conditions: The set of conditions for the metric usage. **All** the specified conditions must be fulfilled to use the metric
        :param pulumi.Input[str] description: The displayed description of the metric
        :param pulumi.Input['CalculatedServiceMetricDimensionDefinitionArgs'] dimension_definition: Parameters of a definition of a calculated service metric
        :param pulumi.Input[bool] enabled: The metric is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[str] entity_id: Restricts the metric usage to the specified service. This field is mutually exclusive with the `management_zones` field
        :param pulumi.Input[bool] ignore_muted_requests: Metric should (true) or not (false) ignore muted requests.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] management_zones: Restricts the metric usage to specified management zones. This field is mutually exclusive with the `entity_id` field
        :param pulumi.Input['CalculatedServiceMetricMetricDefinitionArgs'] metric_definition: The definition of a calculated service metric
        :param pulumi.Input[str] metric_key: The key of the calculated service metric
        :param pulumi.Input[str] name: The displayed name of the metric
        :param pulumi.Input[str] unit: The unit of the metric. Possible values are `BIT`, `BIT_PER_HOUR`, `BIT_PER_MINUTE`, `BIT_PER_SECOND`, `BYTE`,
               `BYTE_PER_HOUR`, `BYTE_PER_MINUTE`, `BYTE_PER_SECOND`, `CORES`, `COUNT`, `DAY`, `DECIBEL_MILLI_WATT`, `GIBI_BYTE`,
               `GIGA`, `GIGA_BYTE`, `HOUR`, `KIBI_BYTE`, `KIBI_BYTE_PER_HOUR`, `KIBI_BYTE_PER_MINUTE`, `KIBI_BYTE_PER_SECOND`, `KILO`,
               `KILO_BYTE`, `KILO_BYTE_PER_HOUR`, `KILO_BYTE_PER_MINUTE`, `KILO_BYTE_PER_SECOND`, `MEBI_BYTE`, `MEBI_BYTE_PER_HOUR`,
               `MEBI_BYTE_PER_MINUTE`, `MEBI_BYTE_PER_SECOND`, `MEGA`, `MEGA_BYTE`, `MEGA_BYTE_PER_HOUR`, `MEGA_BYTE_PER_MINUTE`,
               `MEGA_BYTE_PER_SECOND`, `MICRO_SECOND`, `MILLI_CORES`, `MILLI_SECOND`, `MILLI_SECOND_PER_MINUTE`, `MINUTE`, `MONTH`,
               `MSU`, `NANO_SECOND`, `NANO_SECOND_PER_MINUTE`, `NOT_APPLICABLE`, `PERCENT`, `PER_HOUR`, `PER_MINUTE`, `PER_SECOND`,
               `PIXEL`, `PROMILLE`, `RATIO`, `SECOND`, `STATE`, `UNSPECIFIED`, `WEEK` and `YEAR`
        :param pulumi.Input[str] unit_display_name: The display name of the metric's unit. Only applicable when the **unit** parameter is set to `UNSPECIFIED`
        :param pulumi.Input[str] unknowns: allows for configuring properties that are not explicitly supported by the current version of this provider
        """
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dimension_definition is not None:
            pulumi.set(__self__, "dimension_definition", dimension_definition)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if entity_id is not None:
            pulumi.set(__self__, "entity_id", entity_id)
        if ignore_muted_requests is not None:
            pulumi.set(__self__, "ignore_muted_requests", ignore_muted_requests)
        if management_zones is not None:
            pulumi.set(__self__, "management_zones", management_zones)
        if metric_definition is not None:
            pulumi.set(__self__, "metric_definition", metric_definition)
        if metric_key is not None:
            pulumi.set(__self__, "metric_key", metric_key)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if unit is not None:
            pulumi.set(__self__, "unit", unit)
        if unit_display_name is not None:
            pulumi.set(__self__, "unit_display_name", unit_display_name)
        if unknowns is not None:
            pulumi.set(__self__, "unknowns", unknowns)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CalculatedServiceMetricConditionArgs']]]]:
        """
        The set of conditions for the metric usage. **All** the specified conditions must be fulfilled to use the metric
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CalculatedServiceMetricConditionArgs']]]]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The displayed description of the metric
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="dimensionDefinition")
    def dimension_definition(self) -> Optional[pulumi.Input['CalculatedServiceMetricDimensionDefinitionArgs']]:
        """
        Parameters of a definition of a calculated service metric
        """
        return pulumi.get(self, "dimension_definition")

    @dimension_definition.setter
    def dimension_definition(self, value: Optional[pulumi.Input['CalculatedServiceMetricDimensionDefinitionArgs']]):
        pulumi.set(self, "dimension_definition", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        The metric is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="entityId")
    def entity_id(self) -> Optional[pulumi.Input[str]]:
        """
        Restricts the metric usage to the specified service. This field is mutually exclusive with the `management_zones` field
        """
        return pulumi.get(self, "entity_id")

    @entity_id.setter
    def entity_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "entity_id", value)

    @property
    @pulumi.getter(name="ignoreMutedRequests")
    def ignore_muted_requests(self) -> Optional[pulumi.Input[bool]]:
        """
        Metric should (true) or not (false) ignore muted requests.
        """
        return pulumi.get(self, "ignore_muted_requests")

    @ignore_muted_requests.setter
    def ignore_muted_requests(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ignore_muted_requests", value)

    @property
    @pulumi.getter(name="managementZones")
    def management_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Restricts the metric usage to specified management zones. This field is mutually exclusive with the `entity_id` field
        """
        return pulumi.get(self, "management_zones")

    @management_zones.setter
    def management_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "management_zones", value)

    @property
    @pulumi.getter(name="metricDefinition")
    def metric_definition(self) -> Optional[pulumi.Input['CalculatedServiceMetricMetricDefinitionArgs']]:
        """
        The definition of a calculated service metric
        """
        return pulumi.get(self, "metric_definition")

    @metric_definition.setter
    def metric_definition(self, value: Optional[pulumi.Input['CalculatedServiceMetricMetricDefinitionArgs']]):
        pulumi.set(self, "metric_definition", value)

    @property
    @pulumi.getter(name="metricKey")
    def metric_key(self) -> Optional[pulumi.Input[str]]:
        """
        The key of the calculated service metric
        """
        return pulumi.get(self, "metric_key")

    @metric_key.setter
    def metric_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metric_key", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The displayed name of the metric
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def unit(self) -> Optional[pulumi.Input[str]]:
        """
        The unit of the metric. Possible values are `BIT`, `BIT_PER_HOUR`, `BIT_PER_MINUTE`, `BIT_PER_SECOND`, `BYTE`,
        `BYTE_PER_HOUR`, `BYTE_PER_MINUTE`, `BYTE_PER_SECOND`, `CORES`, `COUNT`, `DAY`, `DECIBEL_MILLI_WATT`, `GIBI_BYTE`,
        `GIGA`, `GIGA_BYTE`, `HOUR`, `KIBI_BYTE`, `KIBI_BYTE_PER_HOUR`, `KIBI_BYTE_PER_MINUTE`, `KIBI_BYTE_PER_SECOND`, `KILO`,
        `KILO_BYTE`, `KILO_BYTE_PER_HOUR`, `KILO_BYTE_PER_MINUTE`, `KILO_BYTE_PER_SECOND`, `MEBI_BYTE`, `MEBI_BYTE_PER_HOUR`,
        `MEBI_BYTE_PER_MINUTE`, `MEBI_BYTE_PER_SECOND`, `MEGA`, `MEGA_BYTE`, `MEGA_BYTE_PER_HOUR`, `MEGA_BYTE_PER_MINUTE`,
        `MEGA_BYTE_PER_SECOND`, `MICRO_SECOND`, `MILLI_CORES`, `MILLI_SECOND`, `MILLI_SECOND_PER_MINUTE`, `MINUTE`, `MONTH`,
        `MSU`, `NANO_SECOND`, `NANO_SECOND_PER_MINUTE`, `NOT_APPLICABLE`, `PERCENT`, `PER_HOUR`, `PER_MINUTE`, `PER_SECOND`,
        `PIXEL`, `PROMILLE`, `RATIO`, `SECOND`, `STATE`, `UNSPECIFIED`, `WEEK` and `YEAR`
        """
        return pulumi.get(self, "unit")

    @unit.setter
    def unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "unit", value)

    @property
    @pulumi.getter(name="unitDisplayName")
    def unit_display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The display name of the metric's unit. Only applicable when the **unit** parameter is set to `UNSPECIFIED`
        """
        return pulumi.get(self, "unit_display_name")

    @unit_display_name.setter
    def unit_display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "unit_display_name", value)

    @property
    @pulumi.getter
    def unknowns(self) -> Optional[pulumi.Input[str]]:
        """
        allows for configuring properties that are not explicitly supported by the current version of this provider
        """
        return pulumi.get(self, "unknowns")

    @unknowns.setter
    def unknowns(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "unknowns", value)


class CalculatedServiceMetric(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CalculatedServiceMetricConditionArgs', 'CalculatedServiceMetricConditionArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dimension_definition: Optional[pulumi.Input[Union['CalculatedServiceMetricDimensionDefinitionArgs', 'CalculatedServiceMetricDimensionDefinitionArgsDict']]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 entity_id: Optional[pulumi.Input[str]] = None,
                 ignore_muted_requests: Optional[pulumi.Input[bool]] = None,
                 management_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 metric_definition: Optional[pulumi.Input[Union['CalculatedServiceMetricMetricDefinitionArgs', 'CalculatedServiceMetricMetricDefinitionArgsDict']]] = None,
                 metric_key: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 unit: Optional[pulumi.Input[str]] = None,
                 unit_display_name: Optional[pulumi.Input[str]] = None,
                 unknowns: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a CalculatedServiceMetric resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CalculatedServiceMetricConditionArgs', 'CalculatedServiceMetricConditionArgsDict']]]] conditions: The set of conditions for the metric usage. **All** the specified conditions must be fulfilled to use the metric
        :param pulumi.Input[str] description: The displayed description of the metric
        :param pulumi.Input[Union['CalculatedServiceMetricDimensionDefinitionArgs', 'CalculatedServiceMetricDimensionDefinitionArgsDict']] dimension_definition: Parameters of a definition of a calculated service metric
        :param pulumi.Input[bool] enabled: The metric is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[str] entity_id: Restricts the metric usage to the specified service. This field is mutually exclusive with the `management_zones` field
        :param pulumi.Input[bool] ignore_muted_requests: Metric should (true) or not (false) ignore muted requests.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] management_zones: Restricts the metric usage to specified management zones. This field is mutually exclusive with the `entity_id` field
        :param pulumi.Input[Union['CalculatedServiceMetricMetricDefinitionArgs', 'CalculatedServiceMetricMetricDefinitionArgsDict']] metric_definition: The definition of a calculated service metric
        :param pulumi.Input[str] metric_key: The key of the calculated service metric
        :param pulumi.Input[str] name: The displayed name of the metric
        :param pulumi.Input[str] unit: The unit of the metric. Possible values are `BIT`, `BIT_PER_HOUR`, `BIT_PER_MINUTE`, `BIT_PER_SECOND`, `BYTE`,
               `BYTE_PER_HOUR`, `BYTE_PER_MINUTE`, `BYTE_PER_SECOND`, `CORES`, `COUNT`, `DAY`, `DECIBEL_MILLI_WATT`, `GIBI_BYTE`,
               `GIGA`, `GIGA_BYTE`, `HOUR`, `KIBI_BYTE`, `KIBI_BYTE_PER_HOUR`, `KIBI_BYTE_PER_MINUTE`, `KIBI_BYTE_PER_SECOND`, `KILO`,
               `KILO_BYTE`, `KILO_BYTE_PER_HOUR`, `KILO_BYTE_PER_MINUTE`, `KILO_BYTE_PER_SECOND`, `MEBI_BYTE`, `MEBI_BYTE_PER_HOUR`,
               `MEBI_BYTE_PER_MINUTE`, `MEBI_BYTE_PER_SECOND`, `MEGA`, `MEGA_BYTE`, `MEGA_BYTE_PER_HOUR`, `MEGA_BYTE_PER_MINUTE`,
               `MEGA_BYTE_PER_SECOND`, `MICRO_SECOND`, `MILLI_CORES`, `MILLI_SECOND`, `MILLI_SECOND_PER_MINUTE`, `MINUTE`, `MONTH`,
               `MSU`, `NANO_SECOND`, `NANO_SECOND_PER_MINUTE`, `NOT_APPLICABLE`, `PERCENT`, `PER_HOUR`, `PER_MINUTE`, `PER_SECOND`,
               `PIXEL`, `PROMILLE`, `RATIO`, `SECOND`, `STATE`, `UNSPECIFIED`, `WEEK` and `YEAR`
        :param pulumi.Input[str] unit_display_name: The display name of the metric's unit. Only applicable when the **unit** parameter is set to `UNSPECIFIED`
        :param pulumi.Input[str] unknowns: allows for configuring properties that are not explicitly supported by the current version of this provider
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CalculatedServiceMetricArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a CalculatedServiceMetric resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param CalculatedServiceMetricArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CalculatedServiceMetricArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CalculatedServiceMetricConditionArgs', 'CalculatedServiceMetricConditionArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dimension_definition: Optional[pulumi.Input[Union['CalculatedServiceMetricDimensionDefinitionArgs', 'CalculatedServiceMetricDimensionDefinitionArgsDict']]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 entity_id: Optional[pulumi.Input[str]] = None,
                 ignore_muted_requests: Optional[pulumi.Input[bool]] = None,
                 management_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 metric_definition: Optional[pulumi.Input[Union['CalculatedServiceMetricMetricDefinitionArgs', 'CalculatedServiceMetricMetricDefinitionArgsDict']]] = None,
                 metric_key: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 unit: Optional[pulumi.Input[str]] = None,
                 unit_display_name: Optional[pulumi.Input[str]] = None,
                 unknowns: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CalculatedServiceMetricArgs.__new__(CalculatedServiceMetricArgs)

            __props__.__dict__["conditions"] = conditions
            __props__.__dict__["description"] = description
            __props__.__dict__["dimension_definition"] = dimension_definition
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["entity_id"] = entity_id
            __props__.__dict__["ignore_muted_requests"] = ignore_muted_requests
            __props__.__dict__["management_zones"] = management_zones
            __props__.__dict__["metric_definition"] = metric_definition
            if metric_key is None and not opts.urn:
                raise TypeError("Missing required property 'metric_key'")
            __props__.__dict__["metric_key"] = metric_key
            __props__.__dict__["name"] = name
            if unit is None and not opts.urn:
                raise TypeError("Missing required property 'unit'")
            __props__.__dict__["unit"] = unit
            __props__.__dict__["unit_display_name"] = unit_display_name
            __props__.__dict__["unknowns"] = unknowns
        super(CalculatedServiceMetric, __self__).__init__(
            'dynatrace:index/calculatedServiceMetric:CalculatedServiceMetric',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CalculatedServiceMetricConditionArgs', 'CalculatedServiceMetricConditionArgsDict']]]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            dimension_definition: Optional[pulumi.Input[Union['CalculatedServiceMetricDimensionDefinitionArgs', 'CalculatedServiceMetricDimensionDefinitionArgsDict']]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            entity_id: Optional[pulumi.Input[str]] = None,
            ignore_muted_requests: Optional[pulumi.Input[bool]] = None,
            management_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            metric_definition: Optional[pulumi.Input[Union['CalculatedServiceMetricMetricDefinitionArgs', 'CalculatedServiceMetricMetricDefinitionArgsDict']]] = None,
            metric_key: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            unit: Optional[pulumi.Input[str]] = None,
            unit_display_name: Optional[pulumi.Input[str]] = None,
            unknowns: Optional[pulumi.Input[str]] = None) -> 'CalculatedServiceMetric':
        """
        Get an existing CalculatedServiceMetric resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CalculatedServiceMetricConditionArgs', 'CalculatedServiceMetricConditionArgsDict']]]] conditions: The set of conditions for the metric usage. **All** the specified conditions must be fulfilled to use the metric
        :param pulumi.Input[str] description: The displayed description of the metric
        :param pulumi.Input[Union['CalculatedServiceMetricDimensionDefinitionArgs', 'CalculatedServiceMetricDimensionDefinitionArgsDict']] dimension_definition: Parameters of a definition of a calculated service metric
        :param pulumi.Input[bool] enabled: The metric is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[str] entity_id: Restricts the metric usage to the specified service. This field is mutually exclusive with the `management_zones` field
        :param pulumi.Input[bool] ignore_muted_requests: Metric should (true) or not (false) ignore muted requests.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] management_zones: Restricts the metric usage to specified management zones. This field is mutually exclusive with the `entity_id` field
        :param pulumi.Input[Union['CalculatedServiceMetricMetricDefinitionArgs', 'CalculatedServiceMetricMetricDefinitionArgsDict']] metric_definition: The definition of a calculated service metric
        :param pulumi.Input[str] metric_key: The key of the calculated service metric
        :param pulumi.Input[str] name: The displayed name of the metric
        :param pulumi.Input[str] unit: The unit of the metric. Possible values are `BIT`, `BIT_PER_HOUR`, `BIT_PER_MINUTE`, `BIT_PER_SECOND`, `BYTE`,
               `BYTE_PER_HOUR`, `BYTE_PER_MINUTE`, `BYTE_PER_SECOND`, `CORES`, `COUNT`, `DAY`, `DECIBEL_MILLI_WATT`, `GIBI_BYTE`,
               `GIGA`, `GIGA_BYTE`, `HOUR`, `KIBI_BYTE`, `KIBI_BYTE_PER_HOUR`, `KIBI_BYTE_PER_MINUTE`, `KIBI_BYTE_PER_SECOND`, `KILO`,
               `KILO_BYTE`, `KILO_BYTE_PER_HOUR`, `KILO_BYTE_PER_MINUTE`, `KILO_BYTE_PER_SECOND`, `MEBI_BYTE`, `MEBI_BYTE_PER_HOUR`,
               `MEBI_BYTE_PER_MINUTE`, `MEBI_BYTE_PER_SECOND`, `MEGA`, `MEGA_BYTE`, `MEGA_BYTE_PER_HOUR`, `MEGA_BYTE_PER_MINUTE`,
               `MEGA_BYTE_PER_SECOND`, `MICRO_SECOND`, `MILLI_CORES`, `MILLI_SECOND`, `MILLI_SECOND_PER_MINUTE`, `MINUTE`, `MONTH`,
               `MSU`, `NANO_SECOND`, `NANO_SECOND_PER_MINUTE`, `NOT_APPLICABLE`, `PERCENT`, `PER_HOUR`, `PER_MINUTE`, `PER_SECOND`,
               `PIXEL`, `PROMILLE`, `RATIO`, `SECOND`, `STATE`, `UNSPECIFIED`, `WEEK` and `YEAR`
        :param pulumi.Input[str] unit_display_name: The display name of the metric's unit. Only applicable when the **unit** parameter is set to `UNSPECIFIED`
        :param pulumi.Input[str] unknowns: allows for configuring properties that are not explicitly supported by the current version of this provider
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CalculatedServiceMetricState.__new__(_CalculatedServiceMetricState)

        __props__.__dict__["conditions"] = conditions
        __props__.__dict__["description"] = description
        __props__.__dict__["dimension_definition"] = dimension_definition
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["entity_id"] = entity_id
        __props__.__dict__["ignore_muted_requests"] = ignore_muted_requests
        __props__.__dict__["management_zones"] = management_zones
        __props__.__dict__["metric_definition"] = metric_definition
        __props__.__dict__["metric_key"] = metric_key
        __props__.__dict__["name"] = name
        __props__.__dict__["unit"] = unit
        __props__.__dict__["unit_display_name"] = unit_display_name
        __props__.__dict__["unknowns"] = unknowns
        return CalculatedServiceMetric(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def conditions(self) -> pulumi.Output[Optional[Sequence['outputs.CalculatedServiceMetricCondition']]]:
        """
        The set of conditions for the metric usage. **All** the specified conditions must be fulfilled to use the metric
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The displayed description of the metric
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="dimensionDefinition")
    def dimension_definition(self) -> pulumi.Output[Optional['outputs.CalculatedServiceMetricDimensionDefinition']]:
        """
        Parameters of a definition of a calculated service metric
        """
        return pulumi.get(self, "dimension_definition")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        The metric is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="entityId")
    def entity_id(self) -> pulumi.Output[Optional[str]]:
        """
        Restricts the metric usage to the specified service. This field is mutually exclusive with the `management_zones` field
        """
        return pulumi.get(self, "entity_id")

    @property
    @pulumi.getter(name="ignoreMutedRequests")
    def ignore_muted_requests(self) -> pulumi.Output[Optional[bool]]:
        """
        Metric should (true) or not (false) ignore muted requests.
        """
        return pulumi.get(self, "ignore_muted_requests")

    @property
    @pulumi.getter(name="managementZones")
    def management_zones(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Restricts the metric usage to specified management zones. This field is mutually exclusive with the `entity_id` field
        """
        return pulumi.get(self, "management_zones")

    @property
    @pulumi.getter(name="metricDefinition")
    def metric_definition(self) -> pulumi.Output[Optional['outputs.CalculatedServiceMetricMetricDefinition']]:
        """
        The definition of a calculated service metric
        """
        return pulumi.get(self, "metric_definition")

    @property
    @pulumi.getter(name="metricKey")
    def metric_key(self) -> pulumi.Output[str]:
        """
        The key of the calculated service metric
        """
        return pulumi.get(self, "metric_key")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The displayed name of the metric
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def unit(self) -> pulumi.Output[str]:
        """
        The unit of the metric. Possible values are `BIT`, `BIT_PER_HOUR`, `BIT_PER_MINUTE`, `BIT_PER_SECOND`, `BYTE`,
        `BYTE_PER_HOUR`, `BYTE_PER_MINUTE`, `BYTE_PER_SECOND`, `CORES`, `COUNT`, `DAY`, `DECIBEL_MILLI_WATT`, `GIBI_BYTE`,
        `GIGA`, `GIGA_BYTE`, `HOUR`, `KIBI_BYTE`, `KIBI_BYTE_PER_HOUR`, `KIBI_BYTE_PER_MINUTE`, `KIBI_BYTE_PER_SECOND`, `KILO`,
        `KILO_BYTE`, `KILO_BYTE_PER_HOUR`, `KILO_BYTE_PER_MINUTE`, `KILO_BYTE_PER_SECOND`, `MEBI_BYTE`, `MEBI_BYTE_PER_HOUR`,
        `MEBI_BYTE_PER_MINUTE`, `MEBI_BYTE_PER_SECOND`, `MEGA`, `MEGA_BYTE`, `MEGA_BYTE_PER_HOUR`, `MEGA_BYTE_PER_MINUTE`,
        `MEGA_BYTE_PER_SECOND`, `MICRO_SECOND`, `MILLI_CORES`, `MILLI_SECOND`, `MILLI_SECOND_PER_MINUTE`, `MINUTE`, `MONTH`,
        `MSU`, `NANO_SECOND`, `NANO_SECOND_PER_MINUTE`, `NOT_APPLICABLE`, `PERCENT`, `PER_HOUR`, `PER_MINUTE`, `PER_SECOND`,
        `PIXEL`, `PROMILLE`, `RATIO`, `SECOND`, `STATE`, `UNSPECIFIED`, `WEEK` and `YEAR`
        """
        return pulumi.get(self, "unit")

    @property
    @pulumi.getter(name="unitDisplayName")
    def unit_display_name(self) -> pulumi.Output[Optional[str]]:
        """
        The display name of the metric's unit. Only applicable when the **unit** parameter is set to `UNSPECIFIED`
        """
        return pulumi.get(self, "unit_display_name")

    @property
    @pulumi.getter
    def unknowns(self) -> pulumi.Output[Optional[str]]:
        """
        allows for configuring properties that are not explicitly supported by the current version of this provider
        """
        return pulumi.get(self, "unknowns")

