# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CalculatedMobileMetricArgs', 'CalculatedMobileMetric']

@pulumi.input_type
class CalculatedMobileMetricArgs:
    def __init__(__self__, *,
                 app_identifier: pulumi.Input[str],
                 enabled: pulumi.Input[bool],
                 metric_key: pulumi.Input[str],
                 metric_type: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 dimensions: Optional[pulumi.Input[Sequence[pulumi.Input['CalculatedMobileMetricDimensionArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 user_action_filter: Optional[pulumi.Input['CalculatedMobileMetricUserActionFilterArgs']] = None):
        """
        The set of arguments for constructing a CalculatedMobileMetric resource.
        :param pulumi.Input[str] app_identifier: The Dynatrace entity ID of the application to which the metric belongs.
        :param pulumi.Input[bool] enabled: The metric is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[str] metric_key: The unique key of the calculated mobile/custom app metric.
        :param pulumi.Input[str] metric_type: The type of the metric. Possible values: [ REPORTED*ERROR*COUNT, USER*ACTION*DURATION, WEB*REQUEST*COUNT, WEB*REQUEST*ERROR_COUNT ]
        :param pulumi.Input[str] description: Descriptor of a calculated mobile/custom app metric.
        :param pulumi.Input[Sequence[pulumi.Input['CalculatedMobileMetricDimensionArgs']]] dimensions: Parameters of a definition of a calculated mobile/custom app metric.
        :param pulumi.Input[str] name: The displayed name of the metric.
        :param pulumi.Input['CalculatedMobileMetricUserActionFilterArgs'] user_action_filter: Parameters of a definition of a calculated mobile/custom app metric.
        """
        pulumi.set(__self__, "app_identifier", app_identifier)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "metric_key", metric_key)
        pulumi.set(__self__, "metric_type", metric_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if user_action_filter is not None:
            pulumi.set(__self__, "user_action_filter", user_action_filter)

    @property
    @pulumi.getter(name="appIdentifier")
    def app_identifier(self) -> pulumi.Input[str]:
        """
        The Dynatrace entity ID of the application to which the metric belongs.
        """
        return pulumi.get(self, "app_identifier")

    @app_identifier.setter
    def app_identifier(self, value: pulumi.Input[str]):
        pulumi.set(self, "app_identifier", value)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        The metric is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="metricKey")
    def metric_key(self) -> pulumi.Input[str]:
        """
        The unique key of the calculated mobile/custom app metric.
        """
        return pulumi.get(self, "metric_key")

    @metric_key.setter
    def metric_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "metric_key", value)

    @property
    @pulumi.getter(name="metricType")
    def metric_type(self) -> pulumi.Input[str]:
        """
        The type of the metric. Possible values: [ REPORTED*ERROR*COUNT, USER*ACTION*DURATION, WEB*REQUEST*COUNT, WEB*REQUEST*ERROR_COUNT ]
        """
        return pulumi.get(self, "metric_type")

    @metric_type.setter
    def metric_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "metric_type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Descriptor of a calculated mobile/custom app metric.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CalculatedMobileMetricDimensionArgs']]]]:
        """
        Parameters of a definition of a calculated mobile/custom app metric.
        """
        return pulumi.get(self, "dimensions")

    @dimensions.setter
    def dimensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CalculatedMobileMetricDimensionArgs']]]]):
        pulumi.set(self, "dimensions", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The displayed name of the metric.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="userActionFilter")
    def user_action_filter(self) -> Optional[pulumi.Input['CalculatedMobileMetricUserActionFilterArgs']]:
        """
        Parameters of a definition of a calculated mobile/custom app metric.
        """
        return pulumi.get(self, "user_action_filter")

    @user_action_filter.setter
    def user_action_filter(self, value: Optional[pulumi.Input['CalculatedMobileMetricUserActionFilterArgs']]):
        pulumi.set(self, "user_action_filter", value)


@pulumi.input_type
class _CalculatedMobileMetricState:
    def __init__(__self__, *,
                 app_identifier: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dimensions: Optional[pulumi.Input[Sequence[pulumi.Input['CalculatedMobileMetricDimensionArgs']]]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 metric_key: Optional[pulumi.Input[str]] = None,
                 metric_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 user_action_filter: Optional[pulumi.Input['CalculatedMobileMetricUserActionFilterArgs']] = None):
        """
        Input properties used for looking up and filtering CalculatedMobileMetric resources.
        :param pulumi.Input[str] app_identifier: The Dynatrace entity ID of the application to which the metric belongs.
        :param pulumi.Input[str] description: Descriptor of a calculated mobile/custom app metric.
        :param pulumi.Input[Sequence[pulumi.Input['CalculatedMobileMetricDimensionArgs']]] dimensions: Parameters of a definition of a calculated mobile/custom app metric.
        :param pulumi.Input[bool] enabled: The metric is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[str] metric_key: The unique key of the calculated mobile/custom app metric.
        :param pulumi.Input[str] metric_type: The type of the metric. Possible values: [ REPORTED*ERROR*COUNT, USER*ACTION*DURATION, WEB*REQUEST*COUNT, WEB*REQUEST*ERROR_COUNT ]
        :param pulumi.Input[str] name: The displayed name of the metric.
        :param pulumi.Input['CalculatedMobileMetricUserActionFilterArgs'] user_action_filter: Parameters of a definition of a calculated mobile/custom app metric.
        """
        if app_identifier is not None:
            pulumi.set(__self__, "app_identifier", app_identifier)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if metric_key is not None:
            pulumi.set(__self__, "metric_key", metric_key)
        if metric_type is not None:
            pulumi.set(__self__, "metric_type", metric_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if user_action_filter is not None:
            pulumi.set(__self__, "user_action_filter", user_action_filter)

    @property
    @pulumi.getter(name="appIdentifier")
    def app_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        The Dynatrace entity ID of the application to which the metric belongs.
        """
        return pulumi.get(self, "app_identifier")

    @app_identifier.setter
    def app_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_identifier", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Descriptor of a calculated mobile/custom app metric.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CalculatedMobileMetricDimensionArgs']]]]:
        """
        Parameters of a definition of a calculated mobile/custom app metric.
        """
        return pulumi.get(self, "dimensions")

    @dimensions.setter
    def dimensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CalculatedMobileMetricDimensionArgs']]]]):
        pulumi.set(self, "dimensions", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        The metric is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="metricKey")
    def metric_key(self) -> Optional[pulumi.Input[str]]:
        """
        The unique key of the calculated mobile/custom app metric.
        """
        return pulumi.get(self, "metric_key")

    @metric_key.setter
    def metric_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metric_key", value)

    @property
    @pulumi.getter(name="metricType")
    def metric_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the metric. Possible values: [ REPORTED*ERROR*COUNT, USER*ACTION*DURATION, WEB*REQUEST*COUNT, WEB*REQUEST*ERROR_COUNT ]
        """
        return pulumi.get(self, "metric_type")

    @metric_type.setter
    def metric_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metric_type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The displayed name of the metric.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="userActionFilter")
    def user_action_filter(self) -> Optional[pulumi.Input['CalculatedMobileMetricUserActionFilterArgs']]:
        """
        Parameters of a definition of a calculated mobile/custom app metric.
        """
        return pulumi.get(self, "user_action_filter")

    @user_action_filter.setter
    def user_action_filter(self, value: Optional[pulumi.Input['CalculatedMobileMetricUserActionFilterArgs']]):
        pulumi.set(self, "user_action_filter", value)


class CalculatedMobileMetric(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_identifier: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dimensions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CalculatedMobileMetricDimensionArgs', 'CalculatedMobileMetricDimensionArgsDict']]]]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 metric_key: Optional[pulumi.Input[str]] = None,
                 metric_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 user_action_filter: Optional[pulumi.Input[Union['CalculatedMobileMetricUserActionFilterArgs', 'CalculatedMobileMetricUserActionFilterArgsDict']]] = None,
                 __props__=None):
        """
        Create a CalculatedMobileMetric resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] app_identifier: The Dynatrace entity ID of the application to which the metric belongs.
        :param pulumi.Input[str] description: Descriptor of a calculated mobile/custom app metric.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CalculatedMobileMetricDimensionArgs', 'CalculatedMobileMetricDimensionArgsDict']]]] dimensions: Parameters of a definition of a calculated mobile/custom app metric.
        :param pulumi.Input[bool] enabled: The metric is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[str] metric_key: The unique key of the calculated mobile/custom app metric.
        :param pulumi.Input[str] metric_type: The type of the metric. Possible values: [ REPORTED*ERROR*COUNT, USER*ACTION*DURATION, WEB*REQUEST*COUNT, WEB*REQUEST*ERROR_COUNT ]
        :param pulumi.Input[str] name: The displayed name of the metric.
        :param pulumi.Input[Union['CalculatedMobileMetricUserActionFilterArgs', 'CalculatedMobileMetricUserActionFilterArgsDict']] user_action_filter: Parameters of a definition of a calculated mobile/custom app metric.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CalculatedMobileMetricArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a CalculatedMobileMetric resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param CalculatedMobileMetricArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CalculatedMobileMetricArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_identifier: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dimensions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CalculatedMobileMetricDimensionArgs', 'CalculatedMobileMetricDimensionArgsDict']]]]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 metric_key: Optional[pulumi.Input[str]] = None,
                 metric_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 user_action_filter: Optional[pulumi.Input[Union['CalculatedMobileMetricUserActionFilterArgs', 'CalculatedMobileMetricUserActionFilterArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CalculatedMobileMetricArgs.__new__(CalculatedMobileMetricArgs)

            if app_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'app_identifier'")
            __props__.__dict__["app_identifier"] = app_identifier
            __props__.__dict__["description"] = description
            __props__.__dict__["dimensions"] = dimensions
            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            if metric_key is None and not opts.urn:
                raise TypeError("Missing required property 'metric_key'")
            __props__.__dict__["metric_key"] = metric_key
            if metric_type is None and not opts.urn:
                raise TypeError("Missing required property 'metric_type'")
            __props__.__dict__["metric_type"] = metric_type
            __props__.__dict__["name"] = name
            __props__.__dict__["user_action_filter"] = user_action_filter
        super(CalculatedMobileMetric, __self__).__init__(
            'dynatrace:index/calculatedMobileMetric:CalculatedMobileMetric',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app_identifier: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            dimensions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CalculatedMobileMetricDimensionArgs', 'CalculatedMobileMetricDimensionArgsDict']]]]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            metric_key: Optional[pulumi.Input[str]] = None,
            metric_type: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            user_action_filter: Optional[pulumi.Input[Union['CalculatedMobileMetricUserActionFilterArgs', 'CalculatedMobileMetricUserActionFilterArgsDict']]] = None) -> 'CalculatedMobileMetric':
        """
        Get an existing CalculatedMobileMetric resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] app_identifier: The Dynatrace entity ID of the application to which the metric belongs.
        :param pulumi.Input[str] description: Descriptor of a calculated mobile/custom app metric.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CalculatedMobileMetricDimensionArgs', 'CalculatedMobileMetricDimensionArgsDict']]]] dimensions: Parameters of a definition of a calculated mobile/custom app metric.
        :param pulumi.Input[bool] enabled: The metric is enabled (`true`) or disabled (`false`)
        :param pulumi.Input[str] metric_key: The unique key of the calculated mobile/custom app metric.
        :param pulumi.Input[str] metric_type: The type of the metric. Possible values: [ REPORTED*ERROR*COUNT, USER*ACTION*DURATION, WEB*REQUEST*COUNT, WEB*REQUEST*ERROR_COUNT ]
        :param pulumi.Input[str] name: The displayed name of the metric.
        :param pulumi.Input[Union['CalculatedMobileMetricUserActionFilterArgs', 'CalculatedMobileMetricUserActionFilterArgsDict']] user_action_filter: Parameters of a definition of a calculated mobile/custom app metric.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CalculatedMobileMetricState.__new__(_CalculatedMobileMetricState)

        __props__.__dict__["app_identifier"] = app_identifier
        __props__.__dict__["description"] = description
        __props__.__dict__["dimensions"] = dimensions
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["metric_key"] = metric_key
        __props__.__dict__["metric_type"] = metric_type
        __props__.__dict__["name"] = name
        __props__.__dict__["user_action_filter"] = user_action_filter
        return CalculatedMobileMetric(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="appIdentifier")
    def app_identifier(self) -> pulumi.Output[str]:
        """
        The Dynatrace entity ID of the application to which the metric belongs.
        """
        return pulumi.get(self, "app_identifier")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Descriptor of a calculated mobile/custom app metric.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def dimensions(self) -> pulumi.Output[Optional[Sequence['outputs.CalculatedMobileMetricDimension']]]:
        """
        Parameters of a definition of a calculated mobile/custom app metric.
        """
        return pulumi.get(self, "dimensions")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[bool]:
        """
        The metric is enabled (`true`) or disabled (`false`)
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="metricKey")
    def metric_key(self) -> pulumi.Output[str]:
        """
        The unique key of the calculated mobile/custom app metric.
        """
        return pulumi.get(self, "metric_key")

    @property
    @pulumi.getter(name="metricType")
    def metric_type(self) -> pulumi.Output[str]:
        """
        The type of the metric. Possible values: [ REPORTED*ERROR*COUNT, USER*ACTION*DURATION, WEB*REQUEST*COUNT, WEB*REQUEST*ERROR_COUNT ]
        """
        return pulumi.get(self, "metric_type")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The displayed name of the metric.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="userActionFilter")
    def user_action_filter(self) -> pulumi.Output[Optional['outputs.CalculatedMobileMetricUserActionFilter']]:
        """
        Parameters of a definition of a calculated mobile/custom app metric.
        """
        return pulumi.get(self, "user_action_filter")

