# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BrowserMonitorArgs', 'BrowserMonitor']

@pulumi.input_type
class BrowserMonitorArgs:
    def __init__(__self__, *,
                 frequency: pulumi.Input[int],
                 key_performance_metrics: pulumi.Input['BrowserMonitorKeyPerformanceMetricsArgs'],
                 anomaly_detection: Optional[pulumi.Input['BrowserMonitorAnomalyDetectionArgs']] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 locations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 manually_assigned_apps: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 script: Optional[pulumi.Input['BrowserMonitorScriptArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['BrowserMonitorTagArgs']]]] = None):
        """
        The set of arguments for constructing a BrowserMonitor resource.
        :param pulumi.Input[int] frequency: The frequency of the monitor, in minutes.
        :param pulumi.Input['BrowserMonitorKeyPerformanceMetricsArgs'] key_performance_metrics: The key performance metrics configuration
        :param pulumi.Input['BrowserMonitorAnomalyDetectionArgs'] anomaly_detection: The anomaly detection configuration.
        :param pulumi.Input[bool] enabled: The monitor is enabled (`true`) or disabled (`false`).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] locations: A list of locations from which the monitor is executed. To specify a location, use its entity ID.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] manually_assigned_apps: A set of manually assigned applications.
        :param pulumi.Input[str] name: The name of the monitor.
        :param pulumi.Input['BrowserMonitorScriptArgs'] script: The Browser Script
        :param pulumi.Input[Sequence[pulumi.Input['BrowserMonitorTagArgs']]] tags: A set of tags assigned to the monitor. You can specify only the value of the tag here and the `CONTEXTLESS` context and
               source 'USER' will be added automatically.
        """
        pulumi.set(__self__, "frequency", frequency)
        pulumi.set(__self__, "key_performance_metrics", key_performance_metrics)
        if anomaly_detection is not None:
            pulumi.set(__self__, "anomaly_detection", anomaly_detection)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if locations is not None:
            pulumi.set(__self__, "locations", locations)
        if manually_assigned_apps is not None:
            pulumi.set(__self__, "manually_assigned_apps", manually_assigned_apps)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if script is not None:
            pulumi.set(__self__, "script", script)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def frequency(self) -> pulumi.Input[int]:
        """
        The frequency of the monitor, in minutes.
        """
        return pulumi.get(self, "frequency")

    @frequency.setter
    def frequency(self, value: pulumi.Input[int]):
        pulumi.set(self, "frequency", value)

    @property
    @pulumi.getter(name="keyPerformanceMetrics")
    def key_performance_metrics(self) -> pulumi.Input['BrowserMonitorKeyPerformanceMetricsArgs']:
        """
        The key performance metrics configuration
        """
        return pulumi.get(self, "key_performance_metrics")

    @key_performance_metrics.setter
    def key_performance_metrics(self, value: pulumi.Input['BrowserMonitorKeyPerformanceMetricsArgs']):
        pulumi.set(self, "key_performance_metrics", value)

    @property
    @pulumi.getter(name="anomalyDetection")
    def anomaly_detection(self) -> Optional[pulumi.Input['BrowserMonitorAnomalyDetectionArgs']]:
        """
        The anomaly detection configuration.
        """
        return pulumi.get(self, "anomaly_detection")

    @anomaly_detection.setter
    def anomaly_detection(self, value: Optional[pulumi.Input['BrowserMonitorAnomalyDetectionArgs']]):
        pulumi.set(self, "anomaly_detection", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        The monitor is enabled (`true`) or disabled (`false`).
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of locations from which the monitor is executed. To specify a location, use its entity ID.
        """
        return pulumi.get(self, "locations")

    @locations.setter
    def locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "locations", value)

    @property
    @pulumi.getter(name="manuallyAssignedApps")
    def manually_assigned_apps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A set of manually assigned applications.
        """
        return pulumi.get(self, "manually_assigned_apps")

    @manually_assigned_apps.setter
    def manually_assigned_apps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "manually_assigned_apps", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the monitor.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def script(self) -> Optional[pulumi.Input['BrowserMonitorScriptArgs']]:
        """
        The Browser Script
        """
        return pulumi.get(self, "script")

    @script.setter
    def script(self, value: Optional[pulumi.Input['BrowserMonitorScriptArgs']]):
        pulumi.set(self, "script", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BrowserMonitorTagArgs']]]]:
        """
        A set of tags assigned to the monitor. You can specify only the value of the tag here and the `CONTEXTLESS` context and
        source 'USER' will be added automatically.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BrowserMonitorTagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _BrowserMonitorState:
    def __init__(__self__, *,
                 anomaly_detection: Optional[pulumi.Input['BrowserMonitorAnomalyDetectionArgs']] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 frequency: Optional[pulumi.Input[int]] = None,
                 key_performance_metrics: Optional[pulumi.Input['BrowserMonitorKeyPerformanceMetricsArgs']] = None,
                 locations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 manually_assigned_apps: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 script: Optional[pulumi.Input['BrowserMonitorScriptArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['BrowserMonitorTagArgs']]]] = None):
        """
        Input properties used for looking up and filtering BrowserMonitor resources.
        :param pulumi.Input['BrowserMonitorAnomalyDetectionArgs'] anomaly_detection: The anomaly detection configuration.
        :param pulumi.Input[bool] enabled: The monitor is enabled (`true`) or disabled (`false`).
        :param pulumi.Input[int] frequency: The frequency of the monitor, in minutes.
        :param pulumi.Input['BrowserMonitorKeyPerformanceMetricsArgs'] key_performance_metrics: The key performance metrics configuration
        :param pulumi.Input[Sequence[pulumi.Input[str]]] locations: A list of locations from which the monitor is executed. To specify a location, use its entity ID.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] manually_assigned_apps: A set of manually assigned applications.
        :param pulumi.Input[str] name: The name of the monitor.
        :param pulumi.Input['BrowserMonitorScriptArgs'] script: The Browser Script
        :param pulumi.Input[Sequence[pulumi.Input['BrowserMonitorTagArgs']]] tags: A set of tags assigned to the monitor. You can specify only the value of the tag here and the `CONTEXTLESS` context and
               source 'USER' will be added automatically.
        """
        if anomaly_detection is not None:
            pulumi.set(__self__, "anomaly_detection", anomaly_detection)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if frequency is not None:
            pulumi.set(__self__, "frequency", frequency)
        if key_performance_metrics is not None:
            pulumi.set(__self__, "key_performance_metrics", key_performance_metrics)
        if locations is not None:
            pulumi.set(__self__, "locations", locations)
        if manually_assigned_apps is not None:
            pulumi.set(__self__, "manually_assigned_apps", manually_assigned_apps)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if script is not None:
            pulumi.set(__self__, "script", script)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="anomalyDetection")
    def anomaly_detection(self) -> Optional[pulumi.Input['BrowserMonitorAnomalyDetectionArgs']]:
        """
        The anomaly detection configuration.
        """
        return pulumi.get(self, "anomaly_detection")

    @anomaly_detection.setter
    def anomaly_detection(self, value: Optional[pulumi.Input['BrowserMonitorAnomalyDetectionArgs']]):
        pulumi.set(self, "anomaly_detection", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        The monitor is enabled (`true`) or disabled (`false`).
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def frequency(self) -> Optional[pulumi.Input[int]]:
        """
        The frequency of the monitor, in minutes.
        """
        return pulumi.get(self, "frequency")

    @frequency.setter
    def frequency(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "frequency", value)

    @property
    @pulumi.getter(name="keyPerformanceMetrics")
    def key_performance_metrics(self) -> Optional[pulumi.Input['BrowserMonitorKeyPerformanceMetricsArgs']]:
        """
        The key performance metrics configuration
        """
        return pulumi.get(self, "key_performance_metrics")

    @key_performance_metrics.setter
    def key_performance_metrics(self, value: Optional[pulumi.Input['BrowserMonitorKeyPerformanceMetricsArgs']]):
        pulumi.set(self, "key_performance_metrics", value)

    @property
    @pulumi.getter
    def locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of locations from which the monitor is executed. To specify a location, use its entity ID.
        """
        return pulumi.get(self, "locations")

    @locations.setter
    def locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "locations", value)

    @property
    @pulumi.getter(name="manuallyAssignedApps")
    def manually_assigned_apps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A set of manually assigned applications.
        """
        return pulumi.get(self, "manually_assigned_apps")

    @manually_assigned_apps.setter
    def manually_assigned_apps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "manually_assigned_apps", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the monitor.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def script(self) -> Optional[pulumi.Input['BrowserMonitorScriptArgs']]:
        """
        The Browser Script
        """
        return pulumi.get(self, "script")

    @script.setter
    def script(self, value: Optional[pulumi.Input['BrowserMonitorScriptArgs']]):
        pulumi.set(self, "script", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BrowserMonitorTagArgs']]]]:
        """
        A set of tags assigned to the monitor. You can specify only the value of the tag here and the `CONTEXTLESS` context and
        source 'USER' will be added automatically.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BrowserMonitorTagArgs']]]]):
        pulumi.set(self, "tags", value)


class BrowserMonitor(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 anomaly_detection: Optional[pulumi.Input[Union['BrowserMonitorAnomalyDetectionArgs', 'BrowserMonitorAnomalyDetectionArgsDict']]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 frequency: Optional[pulumi.Input[int]] = None,
                 key_performance_metrics: Optional[pulumi.Input[Union['BrowserMonitorKeyPerformanceMetricsArgs', 'BrowserMonitorKeyPerformanceMetricsArgsDict']]] = None,
                 locations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 manually_assigned_apps: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 script: Optional[pulumi.Input[Union['BrowserMonitorScriptArgs', 'BrowserMonitorScriptArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BrowserMonitorTagArgs', 'BrowserMonitorTagArgsDict']]]]] = None,
                 __props__=None):
        """
        Create a BrowserMonitor resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['BrowserMonitorAnomalyDetectionArgs', 'BrowserMonitorAnomalyDetectionArgsDict']] anomaly_detection: The anomaly detection configuration.
        :param pulumi.Input[bool] enabled: The monitor is enabled (`true`) or disabled (`false`).
        :param pulumi.Input[int] frequency: The frequency of the monitor, in minutes.
        :param pulumi.Input[Union['BrowserMonitorKeyPerformanceMetricsArgs', 'BrowserMonitorKeyPerformanceMetricsArgsDict']] key_performance_metrics: The key performance metrics configuration
        :param pulumi.Input[Sequence[pulumi.Input[str]]] locations: A list of locations from which the monitor is executed. To specify a location, use its entity ID.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] manually_assigned_apps: A set of manually assigned applications.
        :param pulumi.Input[str] name: The name of the monitor.
        :param pulumi.Input[Union['BrowserMonitorScriptArgs', 'BrowserMonitorScriptArgsDict']] script: The Browser Script
        :param pulumi.Input[Sequence[pulumi.Input[Union['BrowserMonitorTagArgs', 'BrowserMonitorTagArgsDict']]]] tags: A set of tags assigned to the monitor. You can specify only the value of the tag here and the `CONTEXTLESS` context and
               source 'USER' will be added automatically.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BrowserMonitorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a BrowserMonitor resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param BrowserMonitorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BrowserMonitorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 anomaly_detection: Optional[pulumi.Input[Union['BrowserMonitorAnomalyDetectionArgs', 'BrowserMonitorAnomalyDetectionArgsDict']]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 frequency: Optional[pulumi.Input[int]] = None,
                 key_performance_metrics: Optional[pulumi.Input[Union['BrowserMonitorKeyPerformanceMetricsArgs', 'BrowserMonitorKeyPerformanceMetricsArgsDict']]] = None,
                 locations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 manually_assigned_apps: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 script: Optional[pulumi.Input[Union['BrowserMonitorScriptArgs', 'BrowserMonitorScriptArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BrowserMonitorTagArgs', 'BrowserMonitorTagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BrowserMonitorArgs.__new__(BrowserMonitorArgs)

            __props__.__dict__["anomaly_detection"] = anomaly_detection
            __props__.__dict__["enabled"] = enabled
            if frequency is None and not opts.urn:
                raise TypeError("Missing required property 'frequency'")
            __props__.__dict__["frequency"] = frequency
            if key_performance_metrics is None and not opts.urn:
                raise TypeError("Missing required property 'key_performance_metrics'")
            __props__.__dict__["key_performance_metrics"] = key_performance_metrics
            __props__.__dict__["locations"] = locations
            __props__.__dict__["manually_assigned_apps"] = manually_assigned_apps
            __props__.__dict__["name"] = name
            __props__.__dict__["script"] = script
            __props__.__dict__["tags"] = tags
        super(BrowserMonitor, __self__).__init__(
            'dynatrace:index/browserMonitor:BrowserMonitor',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            anomaly_detection: Optional[pulumi.Input[Union['BrowserMonitorAnomalyDetectionArgs', 'BrowserMonitorAnomalyDetectionArgsDict']]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            frequency: Optional[pulumi.Input[int]] = None,
            key_performance_metrics: Optional[pulumi.Input[Union['BrowserMonitorKeyPerformanceMetricsArgs', 'BrowserMonitorKeyPerformanceMetricsArgsDict']]] = None,
            locations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            manually_assigned_apps: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            script: Optional[pulumi.Input[Union['BrowserMonitorScriptArgs', 'BrowserMonitorScriptArgsDict']]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BrowserMonitorTagArgs', 'BrowserMonitorTagArgsDict']]]]] = None) -> 'BrowserMonitor':
        """
        Get an existing BrowserMonitor resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['BrowserMonitorAnomalyDetectionArgs', 'BrowserMonitorAnomalyDetectionArgsDict']] anomaly_detection: The anomaly detection configuration.
        :param pulumi.Input[bool] enabled: The monitor is enabled (`true`) or disabled (`false`).
        :param pulumi.Input[int] frequency: The frequency of the monitor, in minutes.
        :param pulumi.Input[Union['BrowserMonitorKeyPerformanceMetricsArgs', 'BrowserMonitorKeyPerformanceMetricsArgsDict']] key_performance_metrics: The key performance metrics configuration
        :param pulumi.Input[Sequence[pulumi.Input[str]]] locations: A list of locations from which the monitor is executed. To specify a location, use its entity ID.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] manually_assigned_apps: A set of manually assigned applications.
        :param pulumi.Input[str] name: The name of the monitor.
        :param pulumi.Input[Union['BrowserMonitorScriptArgs', 'BrowserMonitorScriptArgsDict']] script: The Browser Script
        :param pulumi.Input[Sequence[pulumi.Input[Union['BrowserMonitorTagArgs', 'BrowserMonitorTagArgsDict']]]] tags: A set of tags assigned to the monitor. You can specify only the value of the tag here and the `CONTEXTLESS` context and
               source 'USER' will be added automatically.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BrowserMonitorState.__new__(_BrowserMonitorState)

        __props__.__dict__["anomaly_detection"] = anomaly_detection
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["frequency"] = frequency
        __props__.__dict__["key_performance_metrics"] = key_performance_metrics
        __props__.__dict__["locations"] = locations
        __props__.__dict__["manually_assigned_apps"] = manually_assigned_apps
        __props__.__dict__["name"] = name
        __props__.__dict__["script"] = script
        __props__.__dict__["tags"] = tags
        return BrowserMonitor(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="anomalyDetection")
    def anomaly_detection(self) -> pulumi.Output[Optional['outputs.BrowserMonitorAnomalyDetection']]:
        """
        The anomaly detection configuration.
        """
        return pulumi.get(self, "anomaly_detection")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        The monitor is enabled (`true`) or disabled (`false`).
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def frequency(self) -> pulumi.Output[int]:
        """
        The frequency of the monitor, in minutes.
        """
        return pulumi.get(self, "frequency")

    @property
    @pulumi.getter(name="keyPerformanceMetrics")
    def key_performance_metrics(self) -> pulumi.Output['outputs.BrowserMonitorKeyPerformanceMetrics']:
        """
        The key performance metrics configuration
        """
        return pulumi.get(self, "key_performance_metrics")

    @property
    @pulumi.getter
    def locations(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of locations from which the monitor is executed. To specify a location, use its entity ID.
        """
        return pulumi.get(self, "locations")

    @property
    @pulumi.getter(name="manuallyAssignedApps")
    def manually_assigned_apps(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A set of manually assigned applications.
        """
        return pulumi.get(self, "manually_assigned_apps")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the monitor.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def script(self) -> pulumi.Output[Optional['outputs.BrowserMonitorScript']]:
        """
        The Browser Script
        """
        return pulumi.get(self, "script")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.BrowserMonitorTag']]]:
        """
        A set of tags assigned to the monitor. You can specify only the value of the tag here and the `CONTEXTLESS` context and
        source 'USER' will be added automatically.
        """
        return pulumi.get(self, "tags")

