# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AutotagRulesArgs', 'AutotagRules']

@pulumi.input_type
class AutotagRulesArgs:
    def __init__(__self__, *,
                 auto_tag_id: pulumi.Input[str],
                 current_state: Optional[pulumi.Input[str]] = None,
                 rules: Optional[pulumi.Input['AutotagRulesRulesArgs']] = None):
        """
        The set of arguments for constructing a AutotagRules resource.
        :param pulumi.Input[str] auto_tag_id: Automatically applied tag ID
        :param pulumi.Input[str] current_state: For internal use: current state of rules in JSON format
        :param pulumi.Input['AutotagRulesRulesArgs'] rules: Rules
        """
        pulumi.set(__self__, "auto_tag_id", auto_tag_id)
        if current_state is not None:
            pulumi.set(__self__, "current_state", current_state)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter(name="autoTagId")
    def auto_tag_id(self) -> pulumi.Input[str]:
        """
        Automatically applied tag ID
        """
        return pulumi.get(self, "auto_tag_id")

    @auto_tag_id.setter
    def auto_tag_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "auto_tag_id", value)

    @property
    @pulumi.getter(name="currentState")
    def current_state(self) -> Optional[pulumi.Input[str]]:
        """
        For internal use: current state of rules in JSON format
        """
        return pulumi.get(self, "current_state")

    @current_state.setter
    def current_state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "current_state", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input['AutotagRulesRulesArgs']]:
        """
        Rules
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input['AutotagRulesRulesArgs']]):
        pulumi.set(self, "rules", value)


@pulumi.input_type
class _AutotagRulesState:
    def __init__(__self__, *,
                 auto_tag_id: Optional[pulumi.Input[str]] = None,
                 current_state: Optional[pulumi.Input[str]] = None,
                 rules: Optional[pulumi.Input['AutotagRulesRulesArgs']] = None):
        """
        Input properties used for looking up and filtering AutotagRules resources.
        :param pulumi.Input[str] auto_tag_id: Automatically applied tag ID
        :param pulumi.Input[str] current_state: For internal use: current state of rules in JSON format
        :param pulumi.Input['AutotagRulesRulesArgs'] rules: Rules
        """
        if auto_tag_id is not None:
            pulumi.set(__self__, "auto_tag_id", auto_tag_id)
        if current_state is not None:
            pulumi.set(__self__, "current_state", current_state)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter(name="autoTagId")
    def auto_tag_id(self) -> Optional[pulumi.Input[str]]:
        """
        Automatically applied tag ID
        """
        return pulumi.get(self, "auto_tag_id")

    @auto_tag_id.setter
    def auto_tag_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_tag_id", value)

    @property
    @pulumi.getter(name="currentState")
    def current_state(self) -> Optional[pulumi.Input[str]]:
        """
        For internal use: current state of rules in JSON format
        """
        return pulumi.get(self, "current_state")

    @current_state.setter
    def current_state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "current_state", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input['AutotagRulesRulesArgs']]:
        """
        Rules
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input['AutotagRulesRulesArgs']]):
        pulumi.set(self, "rules", value)


class AutotagRules(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_tag_id: Optional[pulumi.Input[str]] = None,
                 current_state: Optional[pulumi.Input[str]] = None,
                 rules: Optional[pulumi.Input[Union['AutotagRulesRulesArgs', 'AutotagRulesRulesArgsDict']]] = None,
                 __props__=None):
        """
        > `AutotagV2` is the primary resource to manage auto tags. This particular resource allows you to manage a subset of tags of a given auto tag ID. The benefit of this is that it allows the flexibility of multiple users to manage the same automatically applied tag.

        > This resource requires the API token scopes **Read settings** (`settings.read`) and **Write settings** (`settings.write`)

        ## Dynatrace Documentation

        - Define and apply tags - https://www.dynatrace.com/support/help/how-to-use-dynatrace/tags-and-metadata/setup/how-to-define-tags

        - Settings API - https://www.dynatrace.com/support/help/dynatrace-api/environment-api/settings (schemaId: `builtin:tags.auto-tagging`)

        The full documentation of the export feature is available [here](https://dt-url.net/h203qmc).

        ## Resource Example Usage

        ```python
        import pulumi
        import pulumiverse_dynatrace as dynatrace

        sample_autotag_v2 = dynatrace.AutotagV2("sampleAutotagV2", rules_maintained_externally=True)
        #Be careful when maintaining `dynatrace_autotag_rules` in separate modules.
        #Do not execute `pulumi up` in parallel when several modules contain 
        #`dynatrace_autotag_rules` referring to the same `dynatrace_autotag_v2`.
        sample_autotag_rules = dynatrace.AutotagRules("sampleAutotagRules",
            auto_tag_id=sample_autotag_v2.id,
            rules={
                "rules": [{
                    "type": "SELECTOR",
                    "enabled": True,
                    "entity_selector": "type(SERVICE),tag(sample)",
                    "value_format": "disabled",
                    "value_normalization": "Leave text as-is",
                }],
            })
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] auto_tag_id: Automatically applied tag ID
        :param pulumi.Input[str] current_state: For internal use: current state of rules in JSON format
        :param pulumi.Input[Union['AutotagRulesRulesArgs', 'AutotagRulesRulesArgsDict']] rules: Rules
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AutotagRulesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        > `AutotagV2` is the primary resource to manage auto tags. This particular resource allows you to manage a subset of tags of a given auto tag ID. The benefit of this is that it allows the flexibility of multiple users to manage the same automatically applied tag.

        > This resource requires the API token scopes **Read settings** (`settings.read`) and **Write settings** (`settings.write`)

        ## Dynatrace Documentation

        - Define and apply tags - https://www.dynatrace.com/support/help/how-to-use-dynatrace/tags-and-metadata/setup/how-to-define-tags

        - Settings API - https://www.dynatrace.com/support/help/dynatrace-api/environment-api/settings (schemaId: `builtin:tags.auto-tagging`)

        The full documentation of the export feature is available [here](https://dt-url.net/h203qmc).

        ## Resource Example Usage

        ```python
        import pulumi
        import pulumiverse_dynatrace as dynatrace

        sample_autotag_v2 = dynatrace.AutotagV2("sampleAutotagV2", rules_maintained_externally=True)
        #Be careful when maintaining `dynatrace_autotag_rules` in separate modules.
        #Do not execute `pulumi up` in parallel when several modules contain 
        #`dynatrace_autotag_rules` referring to the same `dynatrace_autotag_v2`.
        sample_autotag_rules = dynatrace.AutotagRules("sampleAutotagRules",
            auto_tag_id=sample_autotag_v2.id,
            rules={
                "rules": [{
                    "type": "SELECTOR",
                    "enabled": True,
                    "entity_selector": "type(SERVICE),tag(sample)",
                    "value_format": "disabled",
                    "value_normalization": "Leave text as-is",
                }],
            })
        ```

        :param str resource_name: The name of the resource.
        :param AutotagRulesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AutotagRulesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_tag_id: Optional[pulumi.Input[str]] = None,
                 current_state: Optional[pulumi.Input[str]] = None,
                 rules: Optional[pulumi.Input[Union['AutotagRulesRulesArgs', 'AutotagRulesRulesArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AutotagRulesArgs.__new__(AutotagRulesArgs)

            if auto_tag_id is None and not opts.urn:
                raise TypeError("Missing required property 'auto_tag_id'")
            __props__.__dict__["auto_tag_id"] = auto_tag_id
            __props__.__dict__["current_state"] = current_state
            __props__.__dict__["rules"] = rules
        super(AutotagRules, __self__).__init__(
            'dynatrace:index/autotagRules:AutotagRules',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_tag_id: Optional[pulumi.Input[str]] = None,
            current_state: Optional[pulumi.Input[str]] = None,
            rules: Optional[pulumi.Input[Union['AutotagRulesRulesArgs', 'AutotagRulesRulesArgsDict']]] = None) -> 'AutotagRules':
        """
        Get an existing AutotagRules resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] auto_tag_id: Automatically applied tag ID
        :param pulumi.Input[str] current_state: For internal use: current state of rules in JSON format
        :param pulumi.Input[Union['AutotagRulesRulesArgs', 'AutotagRulesRulesArgsDict']] rules: Rules
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AutotagRulesState.__new__(_AutotagRulesState)

        __props__.__dict__["auto_tag_id"] = auto_tag_id
        __props__.__dict__["current_state"] = current_state
        __props__.__dict__["rules"] = rules
        return AutotagRules(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autoTagId")
    def auto_tag_id(self) -> pulumi.Output[str]:
        """
        Automatically applied tag ID
        """
        return pulumi.get(self, "auto_tag_id")

    @property
    @pulumi.getter(name="currentState")
    def current_state(self) -> pulumi.Output[str]:
        """
        For internal use: current state of rules in JSON format
        """
        return pulumi.get(self, "current_state")

    @property
    @pulumi.getter
    def rules(self) -> pulumi.Output[Optional['outputs.AutotagRulesRules']]:
        """
        Rules
        """
        return pulumi.get(self, "rules")

