# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['AutomationWorkflowK8sConnectionsArgs', 'AutomationWorkflowK8sConnections']

@pulumi.input_type
class AutomationWorkflowK8sConnectionsArgs:
    def __init__(__self__, *,
                 namespace: pulumi.Input[str],
                 token: pulumi.Input[str],
                 uid: pulumi.Input[str],
                 insert_after: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AutomationWorkflowK8sConnections resource.
        :param pulumi.Input[str] namespace: The namespace where EdgeConnect is deployed
        :param pulumi.Input[str] token: Token
        :param pulumi.Input[str] uid: A pseudo-ID for the cluster, set to the UID of the kube-system namespace
        :param pulumi.Input[str] insert_after: Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        :param pulumi.Input[str] name: The name of the EdgeConnect deployment
        """
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "token", token)
        pulumi.set(__self__, "uid", uid)
        if insert_after is not None:
            warnings.warn("""This resource is no longer ordered, please remove this attribute from the configuration""", DeprecationWarning)
            pulumi.log.warn("""insert_after is deprecated: This resource is no longer ordered, please remove this attribute from the configuration""")
        if insert_after is not None:
            pulumi.set(__self__, "insert_after", insert_after)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[str]:
        """
        The namespace where EdgeConnect is deployed
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[str]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def token(self) -> pulumi.Input[str]:
        """
        Token
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: pulumi.Input[str]):
        pulumi.set(self, "token", value)

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Input[str]:
        """
        A pseudo-ID for the cluster, set to the UID of the kube-system namespace
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: pulumi.Input[str]):
        pulumi.set(self, "uid", value)

    @property
    @pulumi.getter(name="insertAfter")
    @_utilities.deprecated("""This resource is no longer ordered, please remove this attribute from the configuration""")
    def insert_after(self) -> Optional[pulumi.Input[str]]:
        """
        Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        """
        return pulumi.get(self, "insert_after")

    @insert_after.setter
    def insert_after(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "insert_after", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the EdgeConnect deployment
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _AutomationWorkflowK8sConnectionsState:
    def __init__(__self__, *,
                 insert_after: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 token: Optional[pulumi.Input[str]] = None,
                 uid: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AutomationWorkflowK8sConnections resources.
        :param pulumi.Input[str] insert_after: Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        :param pulumi.Input[str] name: The name of the EdgeConnect deployment
        :param pulumi.Input[str] namespace: The namespace where EdgeConnect is deployed
        :param pulumi.Input[str] token: Token
        :param pulumi.Input[str] uid: A pseudo-ID for the cluster, set to the UID of the kube-system namespace
        """
        if insert_after is not None:
            warnings.warn("""This resource is no longer ordered, please remove this attribute from the configuration""", DeprecationWarning)
            pulumi.log.warn("""insert_after is deprecated: This resource is no longer ordered, please remove this attribute from the configuration""")
        if insert_after is not None:
            pulumi.set(__self__, "insert_after", insert_after)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if token is not None:
            pulumi.set(__self__, "token", token)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter(name="insertAfter")
    @_utilities.deprecated("""This resource is no longer ordered, please remove this attribute from the configuration""")
    def insert_after(self) -> Optional[pulumi.Input[str]]:
        """
        Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        """
        return pulumi.get(self, "insert_after")

    @insert_after.setter
    def insert_after(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "insert_after", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the EdgeConnect deployment
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace where EdgeConnect is deployed
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[str]]:
        """
        Token
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "token", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[str]]:
        """
        A pseudo-ID for the cluster, set to the UID of the kube-system namespace
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uid", value)


class AutomationWorkflowK8sConnections(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 insert_after: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 token: Optional[pulumi.Input[str]] = None,
                 uid: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a AutomationWorkflowK8sConnections resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] insert_after: Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        :param pulumi.Input[str] name: The name of the EdgeConnect deployment
        :param pulumi.Input[str] namespace: The namespace where EdgeConnect is deployed
        :param pulumi.Input[str] token: Token
        :param pulumi.Input[str] uid: A pseudo-ID for the cluster, set to the UID of the kube-system namespace
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AutomationWorkflowK8sConnectionsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a AutomationWorkflowK8sConnections resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param AutomationWorkflowK8sConnectionsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AutomationWorkflowK8sConnectionsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 insert_after: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 token: Optional[pulumi.Input[str]] = None,
                 uid: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AutomationWorkflowK8sConnectionsArgs.__new__(AutomationWorkflowK8sConnectionsArgs)

            __props__.__dict__["insert_after"] = insert_after
            __props__.__dict__["name"] = name
            if namespace is None and not opts.urn:
                raise TypeError("Missing required property 'namespace'")
            __props__.__dict__["namespace"] = namespace
            if token is None and not opts.urn:
                raise TypeError("Missing required property 'token'")
            __props__.__dict__["token"] = None if token is None else pulumi.Output.secret(token)
            if uid is None and not opts.urn:
                raise TypeError("Missing required property 'uid'")
            __props__.__dict__["uid"] = uid
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["token"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(AutomationWorkflowK8sConnections, __self__).__init__(
            'dynatrace:index/automationWorkflowK8sConnections:AutomationWorkflowK8sConnections',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            insert_after: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            namespace: Optional[pulumi.Input[str]] = None,
            token: Optional[pulumi.Input[str]] = None,
            uid: Optional[pulumi.Input[str]] = None) -> 'AutomationWorkflowK8sConnections':
        """
        Get an existing AutomationWorkflowK8sConnections resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] insert_after: Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        :param pulumi.Input[str] name: The name of the EdgeConnect deployment
        :param pulumi.Input[str] namespace: The namespace where EdgeConnect is deployed
        :param pulumi.Input[str] token: Token
        :param pulumi.Input[str] uid: A pseudo-ID for the cluster, set to the UID of the kube-system namespace
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AutomationWorkflowK8sConnectionsState.__new__(_AutomationWorkflowK8sConnectionsState)

        __props__.__dict__["insert_after"] = insert_after
        __props__.__dict__["name"] = name
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["token"] = token
        __props__.__dict__["uid"] = uid
        return AutomationWorkflowK8sConnections(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="insertAfter")
    @_utilities.deprecated("""This resource is no longer ordered, please remove this attribute from the configuration""")
    def insert_after(self) -> pulumi.Output[str]:
        """
        Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        """
        return pulumi.get(self, "insert_after")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the EdgeConnect deployment
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[str]:
        """
        The namespace where EdgeConnect is deployed
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def token(self) -> pulumi.Output[str]:
        """
        Token
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Output[str]:
        """
        A pseudo-ID for the cluster, set to the UID of the kube-system namespace
        """
        return pulumi.get(self, "uid")

