# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AutomationBusinessCalendarArgs', 'AutomationBusinessCalendar']

@pulumi.input_type
class AutomationBusinessCalendarArgs:
    def __init__(__self__, *,
                 title: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 holidays: Optional[pulumi.Input['AutomationBusinessCalendarHolidaysArgs']] = None,
                 valid_from: Optional[pulumi.Input[str]] = None,
                 valid_to: Optional[pulumi.Input[str]] = None,
                 week_days: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 week_start: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a AutomationBusinessCalendar resource.
        :param pulumi.Input[str] title: The title / name of the Business Calendar
        :param pulumi.Input[str] description: An optional description for the Business Calendar
        :param pulumi.Input['AutomationBusinessCalendarHolidaysArgs'] holidays: A list of holidays valid in this calendar
        :param pulumi.Input[str] valid_from: The date from when on this calendar is valid from. Example: `2023-07-04` for July 4th 2023
        :param pulumi.Input[str] valid_to: The date until when on this calendar is valid to. Example: `2023-07-04` for July 4th 2023
        :param pulumi.Input[Sequence[pulumi.Input[int]]] week_days: The days to be considered week days in this calendar. `1' =`Monday`,`2`=`Tuesday`,`3`=`Wednesday`,`4`=`Thursday`,`5`=`Friday`,`6`=`Saturday`,`7`=`Sunday`
        :param pulumi.Input[int] week_start: Specifies the day of the week that's considered to be the first day in the week. `1` for Monday, `7` for Sunday
        """
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if holidays is not None:
            pulumi.set(__self__, "holidays", holidays)
        if valid_from is not None:
            pulumi.set(__self__, "valid_from", valid_from)
        if valid_to is not None:
            pulumi.set(__self__, "valid_to", valid_to)
        if week_days is not None:
            pulumi.set(__self__, "week_days", week_days)
        if week_start is not None:
            pulumi.set(__self__, "week_start", week_start)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[str]:
        """
        The title / name of the Business Calendar
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description for the Business Calendar
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def holidays(self) -> Optional[pulumi.Input['AutomationBusinessCalendarHolidaysArgs']]:
        """
        A list of holidays valid in this calendar
        """
        return pulumi.get(self, "holidays")

    @holidays.setter
    def holidays(self, value: Optional[pulumi.Input['AutomationBusinessCalendarHolidaysArgs']]):
        pulumi.set(self, "holidays", value)

    @property
    @pulumi.getter(name="validFrom")
    def valid_from(self) -> Optional[pulumi.Input[str]]:
        """
        The date from when on this calendar is valid from. Example: `2023-07-04` for July 4th 2023
        """
        return pulumi.get(self, "valid_from")

    @valid_from.setter
    def valid_from(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "valid_from", value)

    @property
    @pulumi.getter(name="validTo")
    def valid_to(self) -> Optional[pulumi.Input[str]]:
        """
        The date until when on this calendar is valid to. Example: `2023-07-04` for July 4th 2023
        """
        return pulumi.get(self, "valid_to")

    @valid_to.setter
    def valid_to(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "valid_to", value)

    @property
    @pulumi.getter(name="weekDays")
    def week_days(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        The days to be considered week days in this calendar. `1' =`Monday`,`2`=`Tuesday`,`3`=`Wednesday`,`4`=`Thursday`,`5`=`Friday`,`6`=`Saturday`,`7`=`Sunday`
        """
        return pulumi.get(self, "week_days")

    @week_days.setter
    def week_days(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "week_days", value)

    @property
    @pulumi.getter(name="weekStart")
    def week_start(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the day of the week that's considered to be the first day in the week. `1` for Monday, `7` for Sunday
        """
        return pulumi.get(self, "week_start")

    @week_start.setter
    def week_start(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "week_start", value)


@pulumi.input_type
class _AutomationBusinessCalendarState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 holidays: Optional[pulumi.Input['AutomationBusinessCalendarHolidaysArgs']] = None,
                 title: Optional[pulumi.Input[str]] = None,
                 valid_from: Optional[pulumi.Input[str]] = None,
                 valid_to: Optional[pulumi.Input[str]] = None,
                 week_days: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 week_start: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering AutomationBusinessCalendar resources.
        :param pulumi.Input[str] description: An optional description for the Business Calendar
        :param pulumi.Input['AutomationBusinessCalendarHolidaysArgs'] holidays: A list of holidays valid in this calendar
        :param pulumi.Input[str] title: The title / name of the Business Calendar
        :param pulumi.Input[str] valid_from: The date from when on this calendar is valid from. Example: `2023-07-04` for July 4th 2023
        :param pulumi.Input[str] valid_to: The date until when on this calendar is valid to. Example: `2023-07-04` for July 4th 2023
        :param pulumi.Input[Sequence[pulumi.Input[int]]] week_days: The days to be considered week days in this calendar. `1' =`Monday`,`2`=`Tuesday`,`3`=`Wednesday`,`4`=`Thursday`,`5`=`Friday`,`6`=`Saturday`,`7`=`Sunday`
        :param pulumi.Input[int] week_start: Specifies the day of the week that's considered to be the first day in the week. `1` for Monday, `7` for Sunday
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if holidays is not None:
            pulumi.set(__self__, "holidays", holidays)
        if title is not None:
            pulumi.set(__self__, "title", title)
        if valid_from is not None:
            pulumi.set(__self__, "valid_from", valid_from)
        if valid_to is not None:
            pulumi.set(__self__, "valid_to", valid_to)
        if week_days is not None:
            pulumi.set(__self__, "week_days", week_days)
        if week_start is not None:
            pulumi.set(__self__, "week_start", week_start)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description for the Business Calendar
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def holidays(self) -> Optional[pulumi.Input['AutomationBusinessCalendarHolidaysArgs']]:
        """
        A list of holidays valid in this calendar
        """
        return pulumi.get(self, "holidays")

    @holidays.setter
    def holidays(self, value: Optional[pulumi.Input['AutomationBusinessCalendarHolidaysArgs']]):
        pulumi.set(self, "holidays", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        The title / name of the Business Calendar
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter(name="validFrom")
    def valid_from(self) -> Optional[pulumi.Input[str]]:
        """
        The date from when on this calendar is valid from. Example: `2023-07-04` for July 4th 2023
        """
        return pulumi.get(self, "valid_from")

    @valid_from.setter
    def valid_from(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "valid_from", value)

    @property
    @pulumi.getter(name="validTo")
    def valid_to(self) -> Optional[pulumi.Input[str]]:
        """
        The date until when on this calendar is valid to. Example: `2023-07-04` for July 4th 2023
        """
        return pulumi.get(self, "valid_to")

    @valid_to.setter
    def valid_to(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "valid_to", value)

    @property
    @pulumi.getter(name="weekDays")
    def week_days(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        The days to be considered week days in this calendar. `1' =`Monday`,`2`=`Tuesday`,`3`=`Wednesday`,`4`=`Thursday`,`5`=`Friday`,`6`=`Saturday`,`7`=`Sunday`
        """
        return pulumi.get(self, "week_days")

    @week_days.setter
    def week_days(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "week_days", value)

    @property
    @pulumi.getter(name="weekStart")
    def week_start(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the day of the week that's considered to be the first day in the week. `1` for Monday, `7` for Sunday
        """
        return pulumi.get(self, "week_start")

    @week_start.setter
    def week_start(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "week_start", value)


class AutomationBusinessCalendar(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 holidays: Optional[pulumi.Input[Union['AutomationBusinessCalendarHolidaysArgs', 'AutomationBusinessCalendarHolidaysArgsDict']]] = None,
                 title: Optional[pulumi.Input[str]] = None,
                 valid_from: Optional[pulumi.Input[str]] = None,
                 valid_to: Optional[pulumi.Input[str]] = None,
                 week_days: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 week_start: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        > **Dynatrace SaaS only**

        > To utilize this resource, please define the environment variables `DT_CLIENT_ID`, `DT_CLIENT_SECRET`, `DT_ACCOUNT_ID` with an OAuth client including the following permissions: **View calendars** (`automation:calendars:read`) and **Create and edit calendars** (`automation:calendars:write`).

        > This resource is excluded by default in the export utility, please explicitly specify the resource to retrieve existing configuration.

        ## Dynatrace Documentation

        - Dynatrace Workflows - https://www.dynatrace.com/support/help/platform-modules/cloud-automation/workflows

        ## Resource Example Usage

        ```python
        import pulumi
        import pulumiverse_dynatrace as dynatrace

        _name_ = dynatrace.AutomationBusinessCalendar("#name#",
            description="#name#",
            holidays={
                "holidays": [
                    {
                        "date": "2023-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2023-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2023-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2023-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2023-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2023-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2024-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2024-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2024-04-01",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2024-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2024-05-09",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2024-05-20",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2024-05-30",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2024-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2024-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2024-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2024-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2024-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2024-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2025-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2025-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2025-04-21",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2025-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2025-05-29",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2025-06-09",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2025-06-19",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2025-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2025-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2025-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2025-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2025-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2025-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2026-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2026-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2026-04-06",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2026-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2026-05-14",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2026-05-25",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2026-06-04",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2026-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2026-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2026-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2026-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2026-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2026-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2027-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2027-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2027-03-29",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2027-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2027-05-06",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2027-05-17",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2027-05-27",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2027-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2027-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2027-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2027-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2027-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2027-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2028-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2028-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2028-04-17",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2028-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2028-05-25",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2028-06-05",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2028-06-15",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2028-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2028-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2028-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2028-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2028-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2028-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2029-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2029-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2029-04-02",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2029-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2029-05-10",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2029-05-21",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2029-05-31",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2029-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2029-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2029-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2029-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2029-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2029-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2030-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2030-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2030-04-22",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2030-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2030-05-30",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2030-06-10",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2030-06-20",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2030-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2030-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2030-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2030-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2030-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2030-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2031-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2031-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2031-04-14",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2031-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2031-05-22",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2031-06-02",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2031-06-12",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2031-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2031-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2031-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2031-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2031-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2031-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2032-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2032-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2032-03-29",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2032-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2032-05-06",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2032-05-17",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2032-05-27",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2032-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2032-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2032-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2032-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2032-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2032-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2033-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2033-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2033-04-18",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2033-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2033-05-26",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2033-06-06",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2033-06-16",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2023-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2024-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2025-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2026-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2027-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2028-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2029-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2030-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2031-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2032-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2033-07-31",
                        "title": "Reini Day",
                    },
                ],
            },
            title="#name#",
            valid_from="2023-07-31",
            valid_to="2033-07-31",
            week_days=[
                1,
                2,
                3,
                4,
                5,
            ],
            week_start=1)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: An optional description for the Business Calendar
        :param pulumi.Input[Union['AutomationBusinessCalendarHolidaysArgs', 'AutomationBusinessCalendarHolidaysArgsDict']] holidays: A list of holidays valid in this calendar
        :param pulumi.Input[str] title: The title / name of the Business Calendar
        :param pulumi.Input[str] valid_from: The date from when on this calendar is valid from. Example: `2023-07-04` for July 4th 2023
        :param pulumi.Input[str] valid_to: The date until when on this calendar is valid to. Example: `2023-07-04` for July 4th 2023
        :param pulumi.Input[Sequence[pulumi.Input[int]]] week_days: The days to be considered week days in this calendar. `1' =`Monday`,`2`=`Tuesday`,`3`=`Wednesday`,`4`=`Thursday`,`5`=`Friday`,`6`=`Saturday`,`7`=`Sunday`
        :param pulumi.Input[int] week_start: Specifies the day of the week that's considered to be the first day in the week. `1` for Monday, `7` for Sunday
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AutomationBusinessCalendarArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        > **Dynatrace SaaS only**

        > To utilize this resource, please define the environment variables `DT_CLIENT_ID`, `DT_CLIENT_SECRET`, `DT_ACCOUNT_ID` with an OAuth client including the following permissions: **View calendars** (`automation:calendars:read`) and **Create and edit calendars** (`automation:calendars:write`).

        > This resource is excluded by default in the export utility, please explicitly specify the resource to retrieve existing configuration.

        ## Dynatrace Documentation

        - Dynatrace Workflows - https://www.dynatrace.com/support/help/platform-modules/cloud-automation/workflows

        ## Resource Example Usage

        ```python
        import pulumi
        import pulumiverse_dynatrace as dynatrace

        _name_ = dynatrace.AutomationBusinessCalendar("#name#",
            description="#name#",
            holidays={
                "holidays": [
                    {
                        "date": "2023-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2023-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2023-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2023-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2023-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2023-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2024-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2024-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2024-04-01",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2024-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2024-05-09",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2024-05-20",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2024-05-30",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2024-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2024-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2024-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2024-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2024-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2024-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2025-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2025-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2025-04-21",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2025-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2025-05-29",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2025-06-09",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2025-06-19",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2025-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2025-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2025-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2025-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2025-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2025-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2026-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2026-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2026-04-06",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2026-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2026-05-14",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2026-05-25",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2026-06-04",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2026-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2026-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2026-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2026-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2026-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2026-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2027-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2027-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2027-03-29",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2027-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2027-05-06",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2027-05-17",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2027-05-27",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2027-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2027-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2027-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2027-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2027-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2027-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2028-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2028-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2028-04-17",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2028-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2028-05-25",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2028-06-05",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2028-06-15",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2028-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2028-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2028-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2028-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2028-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2028-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2029-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2029-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2029-04-02",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2029-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2029-05-10",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2029-05-21",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2029-05-31",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2029-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2029-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2029-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2029-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2029-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2029-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2030-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2030-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2030-04-22",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2030-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2030-05-30",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2030-06-10",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2030-06-20",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2030-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2030-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2030-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2030-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2030-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2030-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2031-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2031-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2031-04-14",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2031-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2031-05-22",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2031-06-02",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2031-06-12",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2031-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2031-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2031-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2031-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2031-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2031-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2032-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2032-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2032-03-29",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2032-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2032-05-06",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2032-05-17",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2032-05-27",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2032-08-15",
                        "title": "Mariä Himmelfahrt",
                    },
                    {
                        "date": "2032-10-26",
                        "title": "Nationalfeiertag",
                    },
                    {
                        "date": "2032-11-01",
                        "title": "Allerheiligen",
                    },
                    {
                        "date": "2032-12-08",
                        "title": "Mariä Empfängnis",
                    },
                    {
                        "date": "2032-12-25",
                        "title": "Christtag",
                    },
                    {
                        "date": "2032-12-26",
                        "title": "Stefanitag",
                    },
                    {
                        "date": "2033-01-01",
                        "title": "Neujahr",
                    },
                    {
                        "date": "2033-01-06",
                        "title": "Heilige Drei Könige",
                    },
                    {
                        "date": "2033-04-18",
                        "title": "Ostermontag",
                    },
                    {
                        "date": "2033-05-01",
                        "title": "Staatsfeiertag",
                    },
                    {
                        "date": "2033-05-26",
                        "title": "Christi Himmelfahrt",
                    },
                    {
                        "date": "2033-06-06",
                        "title": "Pfingstmontag",
                    },
                    {
                        "date": "2033-06-16",
                        "title": "Fronleichnam",
                    },
                    {
                        "date": "2023-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2024-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2025-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2026-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2027-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2028-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2029-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2030-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2031-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2032-07-31",
                        "title": "Reini Day",
                    },
                    {
                        "date": "2033-07-31",
                        "title": "Reini Day",
                    },
                ],
            },
            title="#name#",
            valid_from="2023-07-31",
            valid_to="2033-07-31",
            week_days=[
                1,
                2,
                3,
                4,
                5,
            ],
            week_start=1)
        ```

        :param str resource_name: The name of the resource.
        :param AutomationBusinessCalendarArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AutomationBusinessCalendarArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 holidays: Optional[pulumi.Input[Union['AutomationBusinessCalendarHolidaysArgs', 'AutomationBusinessCalendarHolidaysArgsDict']]] = None,
                 title: Optional[pulumi.Input[str]] = None,
                 valid_from: Optional[pulumi.Input[str]] = None,
                 valid_to: Optional[pulumi.Input[str]] = None,
                 week_days: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 week_start: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AutomationBusinessCalendarArgs.__new__(AutomationBusinessCalendarArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["holidays"] = holidays
            if title is None and not opts.urn:
                raise TypeError("Missing required property 'title'")
            __props__.__dict__["title"] = title
            __props__.__dict__["valid_from"] = valid_from
            __props__.__dict__["valid_to"] = valid_to
            __props__.__dict__["week_days"] = week_days
            __props__.__dict__["week_start"] = week_start
        super(AutomationBusinessCalendar, __self__).__init__(
            'dynatrace:index/automationBusinessCalendar:AutomationBusinessCalendar',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            holidays: Optional[pulumi.Input[Union['AutomationBusinessCalendarHolidaysArgs', 'AutomationBusinessCalendarHolidaysArgsDict']]] = None,
            title: Optional[pulumi.Input[str]] = None,
            valid_from: Optional[pulumi.Input[str]] = None,
            valid_to: Optional[pulumi.Input[str]] = None,
            week_days: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
            week_start: Optional[pulumi.Input[int]] = None) -> 'AutomationBusinessCalendar':
        """
        Get an existing AutomationBusinessCalendar resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: An optional description for the Business Calendar
        :param pulumi.Input[Union['AutomationBusinessCalendarHolidaysArgs', 'AutomationBusinessCalendarHolidaysArgsDict']] holidays: A list of holidays valid in this calendar
        :param pulumi.Input[str] title: The title / name of the Business Calendar
        :param pulumi.Input[str] valid_from: The date from when on this calendar is valid from. Example: `2023-07-04` for July 4th 2023
        :param pulumi.Input[str] valid_to: The date until when on this calendar is valid to. Example: `2023-07-04` for July 4th 2023
        :param pulumi.Input[Sequence[pulumi.Input[int]]] week_days: The days to be considered week days in this calendar. `1' =`Monday`,`2`=`Tuesday`,`3`=`Wednesday`,`4`=`Thursday`,`5`=`Friday`,`6`=`Saturday`,`7`=`Sunday`
        :param pulumi.Input[int] week_start: Specifies the day of the week that's considered to be the first day in the week. `1` for Monday, `7` for Sunday
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AutomationBusinessCalendarState.__new__(_AutomationBusinessCalendarState)

        __props__.__dict__["description"] = description
        __props__.__dict__["holidays"] = holidays
        __props__.__dict__["title"] = title
        __props__.__dict__["valid_from"] = valid_from
        __props__.__dict__["valid_to"] = valid_to
        __props__.__dict__["week_days"] = week_days
        __props__.__dict__["week_start"] = week_start
        return AutomationBusinessCalendar(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        An optional description for the Business Calendar
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def holidays(self) -> pulumi.Output[Optional['outputs.AutomationBusinessCalendarHolidays']]:
        """
        A list of holidays valid in this calendar
        """
        return pulumi.get(self, "holidays")

    @property
    @pulumi.getter
    def title(self) -> pulumi.Output[str]:
        """
        The title / name of the Business Calendar
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter(name="validFrom")
    def valid_from(self) -> pulumi.Output[Optional[str]]:
        """
        The date from when on this calendar is valid from. Example: `2023-07-04` for July 4th 2023
        """
        return pulumi.get(self, "valid_from")

    @property
    @pulumi.getter(name="validTo")
    def valid_to(self) -> pulumi.Output[Optional[str]]:
        """
        The date until when on this calendar is valid to. Example: `2023-07-04` for July 4th 2023
        """
        return pulumi.get(self, "valid_to")

    @property
    @pulumi.getter(name="weekDays")
    def week_days(self) -> pulumi.Output[Optional[Sequence[int]]]:
        """
        The days to be considered week days in this calendar. `1' =`Monday`,`2`=`Tuesday`,`3`=`Wednesday`,`4`=`Thursday`,`5`=`Friday`,`6`=`Saturday`,`7`=`Sunday`
        """
        return pulumi.get(self, "week_days")

    @property
    @pulumi.getter(name="weekStart")
    def week_start(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the day of the week that's considered to be the first day in the week. `1` for Monday, `7` for Sunday
        """
        return pulumi.get(self, "week_start")

