# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ApiDetectionArgs', 'ApiDetection']

@pulumi.input_type
class ApiDetectionArgs:
    def __init__(__self__, *,
                 api_color: pulumi.Input[str],
                 api_name: pulumi.Input[str],
                 third_party_api: pulumi.Input[bool],
                 conditions: Optional[pulumi.Input['ApiDetectionConditionsArgs']] = None,
                 insert_after: Optional[pulumi.Input[str]] = None,
                 technology: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ApiDetection resource.
        :param pulumi.Input[str] api_color: This color will be used to highlight APIs when viewing code level data, such as distributed traces or method hotspots.
        :param pulumi.Input[str] api_name: API name
        :param pulumi.Input[bool] third_party_api: This API defines a third party library
        :param pulumi.Input['ApiDetectionConditionsArgs'] conditions: List of conditions
        :param pulumi.Input[str] insert_after: Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        :param pulumi.Input[str] technology: Restrict this rule to a specific technology.
        """
        pulumi.set(__self__, "api_color", api_color)
        pulumi.set(__self__, "api_name", api_name)
        pulumi.set(__self__, "third_party_api", third_party_api)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if insert_after is not None:
            pulumi.set(__self__, "insert_after", insert_after)
        if technology is not None:
            pulumi.set(__self__, "technology", technology)

    @property
    @pulumi.getter(name="apiColor")
    def api_color(self) -> pulumi.Input[str]:
        """
        This color will be used to highlight APIs when viewing code level data, such as distributed traces or method hotspots.
        """
        return pulumi.get(self, "api_color")

    @api_color.setter
    def api_color(self, value: pulumi.Input[str]):
        pulumi.set(self, "api_color", value)

    @property
    @pulumi.getter(name="apiName")
    def api_name(self) -> pulumi.Input[str]:
        """
        API name
        """
        return pulumi.get(self, "api_name")

    @api_name.setter
    def api_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "api_name", value)

    @property
    @pulumi.getter(name="thirdPartyApi")
    def third_party_api(self) -> pulumi.Input[bool]:
        """
        This API defines a third party library
        """
        return pulumi.get(self, "third_party_api")

    @third_party_api.setter
    def third_party_api(self, value: pulumi.Input[bool]):
        pulumi.set(self, "third_party_api", value)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input['ApiDetectionConditionsArgs']]:
        """
        List of conditions
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input['ApiDetectionConditionsArgs']]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter(name="insertAfter")
    def insert_after(self) -> Optional[pulumi.Input[str]]:
        """
        Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        """
        return pulumi.get(self, "insert_after")

    @insert_after.setter
    def insert_after(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "insert_after", value)

    @property
    @pulumi.getter
    def technology(self) -> Optional[pulumi.Input[str]]:
        """
        Restrict this rule to a specific technology.
        """
        return pulumi.get(self, "technology")

    @technology.setter
    def technology(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "technology", value)


@pulumi.input_type
class _ApiDetectionState:
    def __init__(__self__, *,
                 api_color: Optional[pulumi.Input[str]] = None,
                 api_name: Optional[pulumi.Input[str]] = None,
                 conditions: Optional[pulumi.Input['ApiDetectionConditionsArgs']] = None,
                 insert_after: Optional[pulumi.Input[str]] = None,
                 technology: Optional[pulumi.Input[str]] = None,
                 third_party_api: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering ApiDetection resources.
        :param pulumi.Input[str] api_color: This color will be used to highlight APIs when viewing code level data, such as distributed traces or method hotspots.
        :param pulumi.Input[str] api_name: API name
        :param pulumi.Input['ApiDetectionConditionsArgs'] conditions: List of conditions
        :param pulumi.Input[str] insert_after: Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        :param pulumi.Input[str] technology: Restrict this rule to a specific technology.
        :param pulumi.Input[bool] third_party_api: This API defines a third party library
        """
        if api_color is not None:
            pulumi.set(__self__, "api_color", api_color)
        if api_name is not None:
            pulumi.set(__self__, "api_name", api_name)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if insert_after is not None:
            pulumi.set(__self__, "insert_after", insert_after)
        if technology is not None:
            pulumi.set(__self__, "technology", technology)
        if third_party_api is not None:
            pulumi.set(__self__, "third_party_api", third_party_api)

    @property
    @pulumi.getter(name="apiColor")
    def api_color(self) -> Optional[pulumi.Input[str]]:
        """
        This color will be used to highlight APIs when viewing code level data, such as distributed traces or method hotspots.
        """
        return pulumi.get(self, "api_color")

    @api_color.setter
    def api_color(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_color", value)

    @property
    @pulumi.getter(name="apiName")
    def api_name(self) -> Optional[pulumi.Input[str]]:
        """
        API name
        """
        return pulumi.get(self, "api_name")

    @api_name.setter
    def api_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_name", value)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input['ApiDetectionConditionsArgs']]:
        """
        List of conditions
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input['ApiDetectionConditionsArgs']]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter(name="insertAfter")
    def insert_after(self) -> Optional[pulumi.Input[str]]:
        """
        Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        """
        return pulumi.get(self, "insert_after")

    @insert_after.setter
    def insert_after(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "insert_after", value)

    @property
    @pulumi.getter
    def technology(self) -> Optional[pulumi.Input[str]]:
        """
        Restrict this rule to a specific technology.
        """
        return pulumi.get(self, "technology")

    @technology.setter
    def technology(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "technology", value)

    @property
    @pulumi.getter(name="thirdPartyApi")
    def third_party_api(self) -> Optional[pulumi.Input[bool]]:
        """
        This API defines a third party library
        """
        return pulumi.get(self, "third_party_api")

    @third_party_api.setter
    def third_party_api(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "third_party_api", value)


class ApiDetection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_color: Optional[pulumi.Input[str]] = None,
                 api_name: Optional[pulumi.Input[str]] = None,
                 conditions: Optional[pulumi.Input[Union['ApiDetectionConditionsArgs', 'ApiDetectionConditionsArgsDict']]] = None,
                 insert_after: Optional[pulumi.Input[str]] = None,
                 technology: Optional[pulumi.Input[str]] = None,
                 third_party_api: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        Create a ApiDetection resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] api_color: This color will be used to highlight APIs when viewing code level data, such as distributed traces or method hotspots.
        :param pulumi.Input[str] api_name: API name
        :param pulumi.Input[Union['ApiDetectionConditionsArgs', 'ApiDetectionConditionsArgsDict']] conditions: List of conditions
        :param pulumi.Input[str] insert_after: Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        :param pulumi.Input[str] technology: Restrict this rule to a specific technology.
        :param pulumi.Input[bool] third_party_api: This API defines a third party library
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApiDetectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a ApiDetection resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param ApiDetectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApiDetectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_color: Optional[pulumi.Input[str]] = None,
                 api_name: Optional[pulumi.Input[str]] = None,
                 conditions: Optional[pulumi.Input[Union['ApiDetectionConditionsArgs', 'ApiDetectionConditionsArgsDict']]] = None,
                 insert_after: Optional[pulumi.Input[str]] = None,
                 technology: Optional[pulumi.Input[str]] = None,
                 third_party_api: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApiDetectionArgs.__new__(ApiDetectionArgs)

            if api_color is None and not opts.urn:
                raise TypeError("Missing required property 'api_color'")
            __props__.__dict__["api_color"] = api_color
            if api_name is None and not opts.urn:
                raise TypeError("Missing required property 'api_name'")
            __props__.__dict__["api_name"] = api_name
            __props__.__dict__["conditions"] = conditions
            __props__.__dict__["insert_after"] = insert_after
            __props__.__dict__["technology"] = technology
            if third_party_api is None and not opts.urn:
                raise TypeError("Missing required property 'third_party_api'")
            __props__.__dict__["third_party_api"] = third_party_api
        super(ApiDetection, __self__).__init__(
            'dynatrace:index/apiDetection:ApiDetection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_color: Optional[pulumi.Input[str]] = None,
            api_name: Optional[pulumi.Input[str]] = None,
            conditions: Optional[pulumi.Input[Union['ApiDetectionConditionsArgs', 'ApiDetectionConditionsArgsDict']]] = None,
            insert_after: Optional[pulumi.Input[str]] = None,
            technology: Optional[pulumi.Input[str]] = None,
            third_party_api: Optional[pulumi.Input[bool]] = None) -> 'ApiDetection':
        """
        Get an existing ApiDetection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] api_color: This color will be used to highlight APIs when viewing code level data, such as distributed traces or method hotspots.
        :param pulumi.Input[str] api_name: API name
        :param pulumi.Input[Union['ApiDetectionConditionsArgs', 'ApiDetectionConditionsArgsDict']] conditions: List of conditions
        :param pulumi.Input[str] insert_after: Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        :param pulumi.Input[str] technology: Restrict this rule to a specific technology.
        :param pulumi.Input[bool] third_party_api: This API defines a third party library
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApiDetectionState.__new__(_ApiDetectionState)

        __props__.__dict__["api_color"] = api_color
        __props__.__dict__["api_name"] = api_name
        __props__.__dict__["conditions"] = conditions
        __props__.__dict__["insert_after"] = insert_after
        __props__.__dict__["technology"] = technology
        __props__.__dict__["third_party_api"] = third_party_api
        return ApiDetection(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="apiColor")
    def api_color(self) -> pulumi.Output[str]:
        """
        This color will be used to highlight APIs when viewing code level data, such as distributed traces or method hotspots.
        """
        return pulumi.get(self, "api_color")

    @property
    @pulumi.getter(name="apiName")
    def api_name(self) -> pulumi.Output[str]:
        """
        API name
        """
        return pulumi.get(self, "api_name")

    @property
    @pulumi.getter
    def conditions(self) -> pulumi.Output[Optional['outputs.ApiDetectionConditions']]:
        """
        List of conditions
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter(name="insertAfter")
    def insert_after(self) -> pulumi.Output[str]:
        """
        Because this resource allows for ordering you may specify the ID of the resource instance that comes before this instance regarding order. If not specified when creating the setting will be added to the end of the list. If not specified during update the order will remain untouched
        """
        return pulumi.get(self, "insert_after")

    @property
    @pulumi.getter
    def technology(self) -> pulumi.Output[Optional[str]]:
        """
        Restrict this rule to a specific technology.
        """
        return pulumi.get(self, "technology")

    @property
    @pulumi.getter(name="thirdPartyApi")
    def third_party_api(self) -> pulumi.Output[bool]:
        """
        This API defines a third party library
        """
        return pulumi.get(self, "third_party_api")

