# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['AnsibleTowerNotificationArgs', 'AnsibleTowerNotification']

@pulumi.input_type
class AnsibleTowerNotificationArgs:
    def __init__(__self__, *,
                 custom_message: pulumi.Input[str],
                 job_template_url: pulumi.Input[str],
                 profile: pulumi.Input[str],
                 username: pulumi.Input[str],
                 active: Optional[pulumi.Input[bool]] = None,
                 insecure: Optional[pulumi.Input[bool]] = None,
                 legacy_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AnsibleTowerNotification resource.
        :param pulumi.Input[str] custom_message: The custom message of the notification. This message will be displayed in the extra variables **Message** field of your job template. You can use the following placeholders:  * `{ImpactedEntities}`: Details about the entities impacted by the problem in form of a JSON array.  * `{ImpactedEntity}`: The entity impacted by the problem or *X* impacted entities.  * `{PID}`: The ID of the reported problem.  * `{ProblemDetailsText}`: All problem event details, including root cause, as a text-formatted string.  * `{ProblemID}`: The display number of the reported problem.  * `{ProblemImpact}`: The [impact level](https://www.dynatrace.com/support/help/shortlink/impact-analysis) of the problem. Possible values are `APPLICATION`, `SERVICE`, and `INFRASTRUCTURE`.  * `{ProblemSeverity}`: The [severity level](https://www.dynatrace.com/support/help/shortlink/event-types) of the problem. Possible values are `AVAILABILITY`, `ERROR`, `PERFORMANCE`, `RESOURCE_CONTENTION`, and `CUSTOM_ALERT`.  * `{ProblemTitle}`: A short description of the problem.  * `{ProblemURL}`: The URL of the problem within Dynatrace.  * `{State}`: The state of the problem. Possible values are `OPEN` and `RESOLVED`.  * `{Tags}`: The list of tags that are defined for all impacted entities, separated by commas
        :param pulumi.Input[str] job_template_url: The URL of the target Ansible Tower job template
        :param pulumi.Input[str] profile: The ID of the associated alerting profile.
        :param pulumi.Input[str] username: The username of the Ansible Tower account
        :param pulumi.Input[bool] active: The notification is active (`true`) or inactive (`false`). Default is `false`.
        :param pulumi.Input[bool] insecure: Accept any, including self-signed and invalid, SSL certificate (`true`) or only trusted (`false`) certificates. Default is `false`.
        :param pulumi.Input[str] legacy_id: The ID of these settings when referred to from resources requiring the REST API V1 keys
        :param pulumi.Input[str] name: The display name within the Dynatrace WebUI.
        :param pulumi.Input[str] password: The password for the Ansible Tower account
        """
        pulumi.set(__self__, "custom_message", custom_message)
        pulumi.set(__self__, "job_template_url", job_template_url)
        pulumi.set(__self__, "profile", profile)
        pulumi.set(__self__, "username", username)
        if active is not None:
            pulumi.set(__self__, "active", active)
        if insecure is not None:
            pulumi.set(__self__, "insecure", insecure)
        if legacy_id is not None:
            pulumi.set(__self__, "legacy_id", legacy_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)

    @property
    @pulumi.getter(name="customMessage")
    def custom_message(self) -> pulumi.Input[str]:
        """
        The custom message of the notification. This message will be displayed in the extra variables **Message** field of your job template. You can use the following placeholders:  * `{ImpactedEntities}`: Details about the entities impacted by the problem in form of a JSON array.  * `{ImpactedEntity}`: The entity impacted by the problem or *X* impacted entities.  * `{PID}`: The ID of the reported problem.  * `{ProblemDetailsText}`: All problem event details, including root cause, as a text-formatted string.  * `{ProblemID}`: The display number of the reported problem.  * `{ProblemImpact}`: The [impact level](https://www.dynatrace.com/support/help/shortlink/impact-analysis) of the problem. Possible values are `APPLICATION`, `SERVICE`, and `INFRASTRUCTURE`.  * `{ProblemSeverity}`: The [severity level](https://www.dynatrace.com/support/help/shortlink/event-types) of the problem. Possible values are `AVAILABILITY`, `ERROR`, `PERFORMANCE`, `RESOURCE_CONTENTION`, and `CUSTOM_ALERT`.  * `{ProblemTitle}`: A short description of the problem.  * `{ProblemURL}`: The URL of the problem within Dynatrace.  * `{State}`: The state of the problem. Possible values are `OPEN` and `RESOLVED`.  * `{Tags}`: The list of tags that are defined for all impacted entities, separated by commas
        """
        return pulumi.get(self, "custom_message")

    @custom_message.setter
    def custom_message(self, value: pulumi.Input[str]):
        pulumi.set(self, "custom_message", value)

    @property
    @pulumi.getter(name="jobTemplateUrl")
    def job_template_url(self) -> pulumi.Input[str]:
        """
        The URL of the target Ansible Tower job template
        """
        return pulumi.get(self, "job_template_url")

    @job_template_url.setter
    def job_template_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "job_template_url", value)

    @property
    @pulumi.getter
    def profile(self) -> pulumi.Input[str]:
        """
        The ID of the associated alerting profile.
        """
        return pulumi.get(self, "profile")

    @profile.setter
    def profile(self, value: pulumi.Input[str]):
        pulumi.set(self, "profile", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[str]:
        """
        The username of the Ansible Tower account
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[str]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[bool]]:
        """
        The notification is active (`true`) or inactive (`false`). Default is `false`.
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "active", value)

    @property
    @pulumi.getter
    def insecure(self) -> Optional[pulumi.Input[bool]]:
        """
        Accept any, including self-signed and invalid, SSL certificate (`true`) or only trusted (`false`) certificates. Default is `false`.
        """
        return pulumi.get(self, "insecure")

    @insecure.setter
    def insecure(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "insecure", value)

    @property
    @pulumi.getter(name="legacyId")
    def legacy_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of these settings when referred to from resources requiring the REST API V1 keys
        """
        return pulumi.get(self, "legacy_id")

    @legacy_id.setter
    def legacy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "legacy_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The display name within the Dynatrace WebUI.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The password for the Ansible Tower account
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)


@pulumi.input_type
class _AnsibleTowerNotificationState:
    def __init__(__self__, *,
                 active: Optional[pulumi.Input[bool]] = None,
                 custom_message: Optional[pulumi.Input[str]] = None,
                 insecure: Optional[pulumi.Input[bool]] = None,
                 job_template_url: Optional[pulumi.Input[str]] = None,
                 legacy_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 profile: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AnsibleTowerNotification resources.
        :param pulumi.Input[bool] active: The notification is active (`true`) or inactive (`false`). Default is `false`.
        :param pulumi.Input[str] custom_message: The custom message of the notification. This message will be displayed in the extra variables **Message** field of your job template. You can use the following placeholders:  * `{ImpactedEntities}`: Details about the entities impacted by the problem in form of a JSON array.  * `{ImpactedEntity}`: The entity impacted by the problem or *X* impacted entities.  * `{PID}`: The ID of the reported problem.  * `{ProblemDetailsText}`: All problem event details, including root cause, as a text-formatted string.  * `{ProblemID}`: The display number of the reported problem.  * `{ProblemImpact}`: The [impact level](https://www.dynatrace.com/support/help/shortlink/impact-analysis) of the problem. Possible values are `APPLICATION`, `SERVICE`, and `INFRASTRUCTURE`.  * `{ProblemSeverity}`: The [severity level](https://www.dynatrace.com/support/help/shortlink/event-types) of the problem. Possible values are `AVAILABILITY`, `ERROR`, `PERFORMANCE`, `RESOURCE_CONTENTION`, and `CUSTOM_ALERT`.  * `{ProblemTitle}`: A short description of the problem.  * `{ProblemURL}`: The URL of the problem within Dynatrace.  * `{State}`: The state of the problem. Possible values are `OPEN` and `RESOLVED`.  * `{Tags}`: The list of tags that are defined for all impacted entities, separated by commas
        :param pulumi.Input[bool] insecure: Accept any, including self-signed and invalid, SSL certificate (`true`) or only trusted (`false`) certificates. Default is `false`.
        :param pulumi.Input[str] job_template_url: The URL of the target Ansible Tower job template
        :param pulumi.Input[str] legacy_id: The ID of these settings when referred to from resources requiring the REST API V1 keys
        :param pulumi.Input[str] name: The display name within the Dynatrace WebUI.
        :param pulumi.Input[str] password: The password for the Ansible Tower account
        :param pulumi.Input[str] profile: The ID of the associated alerting profile.
        :param pulumi.Input[str] username: The username of the Ansible Tower account
        """
        if active is not None:
            pulumi.set(__self__, "active", active)
        if custom_message is not None:
            pulumi.set(__self__, "custom_message", custom_message)
        if insecure is not None:
            pulumi.set(__self__, "insecure", insecure)
        if job_template_url is not None:
            pulumi.set(__self__, "job_template_url", job_template_url)
        if legacy_id is not None:
            pulumi.set(__self__, "legacy_id", legacy_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if profile is not None:
            pulumi.set(__self__, "profile", profile)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[bool]]:
        """
        The notification is active (`true`) or inactive (`false`). Default is `false`.
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "active", value)

    @property
    @pulumi.getter(name="customMessage")
    def custom_message(self) -> Optional[pulumi.Input[str]]:
        """
        The custom message of the notification. This message will be displayed in the extra variables **Message** field of your job template. You can use the following placeholders:  * `{ImpactedEntities}`: Details about the entities impacted by the problem in form of a JSON array.  * `{ImpactedEntity}`: The entity impacted by the problem or *X* impacted entities.  * `{PID}`: The ID of the reported problem.  * `{ProblemDetailsText}`: All problem event details, including root cause, as a text-formatted string.  * `{ProblemID}`: The display number of the reported problem.  * `{ProblemImpact}`: The [impact level](https://www.dynatrace.com/support/help/shortlink/impact-analysis) of the problem. Possible values are `APPLICATION`, `SERVICE`, and `INFRASTRUCTURE`.  * `{ProblemSeverity}`: The [severity level](https://www.dynatrace.com/support/help/shortlink/event-types) of the problem. Possible values are `AVAILABILITY`, `ERROR`, `PERFORMANCE`, `RESOURCE_CONTENTION`, and `CUSTOM_ALERT`.  * `{ProblemTitle}`: A short description of the problem.  * `{ProblemURL}`: The URL of the problem within Dynatrace.  * `{State}`: The state of the problem. Possible values are `OPEN` and `RESOLVED`.  * `{Tags}`: The list of tags that are defined for all impacted entities, separated by commas
        """
        return pulumi.get(self, "custom_message")

    @custom_message.setter
    def custom_message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_message", value)

    @property
    @pulumi.getter
    def insecure(self) -> Optional[pulumi.Input[bool]]:
        """
        Accept any, including self-signed and invalid, SSL certificate (`true`) or only trusted (`false`) certificates. Default is `false`.
        """
        return pulumi.get(self, "insecure")

    @insecure.setter
    def insecure(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "insecure", value)

    @property
    @pulumi.getter(name="jobTemplateUrl")
    def job_template_url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL of the target Ansible Tower job template
        """
        return pulumi.get(self, "job_template_url")

    @job_template_url.setter
    def job_template_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "job_template_url", value)

    @property
    @pulumi.getter(name="legacyId")
    def legacy_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of these settings when referred to from resources requiring the REST API V1 keys
        """
        return pulumi.get(self, "legacy_id")

    @legacy_id.setter
    def legacy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "legacy_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The display name within the Dynatrace WebUI.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The password for the Ansible Tower account
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def profile(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the associated alerting profile.
        """
        return pulumi.get(self, "profile")

    @profile.setter
    def profile(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "profile", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        The username of the Ansible Tower account
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


class AnsibleTowerNotification(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active: Optional[pulumi.Input[bool]] = None,
                 custom_message: Optional[pulumi.Input[str]] = None,
                 insecure: Optional[pulumi.Input[bool]] = None,
                 job_template_url: Optional[pulumi.Input[str]] = None,
                 legacy_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 profile: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a AnsibleTowerNotification resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] active: The notification is active (`true`) or inactive (`false`). Default is `false`.
        :param pulumi.Input[str] custom_message: The custom message of the notification. This message will be displayed in the extra variables **Message** field of your job template. You can use the following placeholders:  * `{ImpactedEntities}`: Details about the entities impacted by the problem in form of a JSON array.  * `{ImpactedEntity}`: The entity impacted by the problem or *X* impacted entities.  * `{PID}`: The ID of the reported problem.  * `{ProblemDetailsText}`: All problem event details, including root cause, as a text-formatted string.  * `{ProblemID}`: The display number of the reported problem.  * `{ProblemImpact}`: The [impact level](https://www.dynatrace.com/support/help/shortlink/impact-analysis) of the problem. Possible values are `APPLICATION`, `SERVICE`, and `INFRASTRUCTURE`.  * `{ProblemSeverity}`: The [severity level](https://www.dynatrace.com/support/help/shortlink/event-types) of the problem. Possible values are `AVAILABILITY`, `ERROR`, `PERFORMANCE`, `RESOURCE_CONTENTION`, and `CUSTOM_ALERT`.  * `{ProblemTitle}`: A short description of the problem.  * `{ProblemURL}`: The URL of the problem within Dynatrace.  * `{State}`: The state of the problem. Possible values are `OPEN` and `RESOLVED`.  * `{Tags}`: The list of tags that are defined for all impacted entities, separated by commas
        :param pulumi.Input[bool] insecure: Accept any, including self-signed and invalid, SSL certificate (`true`) or only trusted (`false`) certificates. Default is `false`.
        :param pulumi.Input[str] job_template_url: The URL of the target Ansible Tower job template
        :param pulumi.Input[str] legacy_id: The ID of these settings when referred to from resources requiring the REST API V1 keys
        :param pulumi.Input[str] name: The display name within the Dynatrace WebUI.
        :param pulumi.Input[str] password: The password for the Ansible Tower account
        :param pulumi.Input[str] profile: The ID of the associated alerting profile.
        :param pulumi.Input[str] username: The username of the Ansible Tower account
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AnsibleTowerNotificationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a AnsibleTowerNotification resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param AnsibleTowerNotificationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AnsibleTowerNotificationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active: Optional[pulumi.Input[bool]] = None,
                 custom_message: Optional[pulumi.Input[str]] = None,
                 insecure: Optional[pulumi.Input[bool]] = None,
                 job_template_url: Optional[pulumi.Input[str]] = None,
                 legacy_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 profile: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AnsibleTowerNotificationArgs.__new__(AnsibleTowerNotificationArgs)

            __props__.__dict__["active"] = active
            if custom_message is None and not opts.urn:
                raise TypeError("Missing required property 'custom_message'")
            __props__.__dict__["custom_message"] = custom_message
            __props__.__dict__["insecure"] = insecure
            if job_template_url is None and not opts.urn:
                raise TypeError("Missing required property 'job_template_url'")
            __props__.__dict__["job_template_url"] = job_template_url
            __props__.__dict__["legacy_id"] = legacy_id
            __props__.__dict__["name"] = name
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            if profile is None and not opts.urn:
                raise TypeError("Missing required property 'profile'")
            __props__.__dict__["profile"] = profile
            if username is None and not opts.urn:
                raise TypeError("Missing required property 'username'")
            __props__.__dict__["username"] = username
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(AnsibleTowerNotification, __self__).__init__(
            'dynatrace:index/ansibleTowerNotification:AnsibleTowerNotification',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            active: Optional[pulumi.Input[bool]] = None,
            custom_message: Optional[pulumi.Input[str]] = None,
            insecure: Optional[pulumi.Input[bool]] = None,
            job_template_url: Optional[pulumi.Input[str]] = None,
            legacy_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            password: Optional[pulumi.Input[str]] = None,
            profile: Optional[pulumi.Input[str]] = None,
            username: Optional[pulumi.Input[str]] = None) -> 'AnsibleTowerNotification':
        """
        Get an existing AnsibleTowerNotification resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] active: The notification is active (`true`) or inactive (`false`). Default is `false`.
        :param pulumi.Input[str] custom_message: The custom message of the notification. This message will be displayed in the extra variables **Message** field of your job template. You can use the following placeholders:  * `{ImpactedEntities}`: Details about the entities impacted by the problem in form of a JSON array.  * `{ImpactedEntity}`: The entity impacted by the problem or *X* impacted entities.  * `{PID}`: The ID of the reported problem.  * `{ProblemDetailsText}`: All problem event details, including root cause, as a text-formatted string.  * `{ProblemID}`: The display number of the reported problem.  * `{ProblemImpact}`: The [impact level](https://www.dynatrace.com/support/help/shortlink/impact-analysis) of the problem. Possible values are `APPLICATION`, `SERVICE`, and `INFRASTRUCTURE`.  * `{ProblemSeverity}`: The [severity level](https://www.dynatrace.com/support/help/shortlink/event-types) of the problem. Possible values are `AVAILABILITY`, `ERROR`, `PERFORMANCE`, `RESOURCE_CONTENTION`, and `CUSTOM_ALERT`.  * `{ProblemTitle}`: A short description of the problem.  * `{ProblemURL}`: The URL of the problem within Dynatrace.  * `{State}`: The state of the problem. Possible values are `OPEN` and `RESOLVED`.  * `{Tags}`: The list of tags that are defined for all impacted entities, separated by commas
        :param pulumi.Input[bool] insecure: Accept any, including self-signed and invalid, SSL certificate (`true`) or only trusted (`false`) certificates. Default is `false`.
        :param pulumi.Input[str] job_template_url: The URL of the target Ansible Tower job template
        :param pulumi.Input[str] legacy_id: The ID of these settings when referred to from resources requiring the REST API V1 keys
        :param pulumi.Input[str] name: The display name within the Dynatrace WebUI.
        :param pulumi.Input[str] password: The password for the Ansible Tower account
        :param pulumi.Input[str] profile: The ID of the associated alerting profile.
        :param pulumi.Input[str] username: The username of the Ansible Tower account
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AnsibleTowerNotificationState.__new__(_AnsibleTowerNotificationState)

        __props__.__dict__["active"] = active
        __props__.__dict__["custom_message"] = custom_message
        __props__.__dict__["insecure"] = insecure
        __props__.__dict__["job_template_url"] = job_template_url
        __props__.__dict__["legacy_id"] = legacy_id
        __props__.__dict__["name"] = name
        __props__.__dict__["password"] = password
        __props__.__dict__["profile"] = profile
        __props__.__dict__["username"] = username
        return AnsibleTowerNotification(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def active(self) -> pulumi.Output[Optional[bool]]:
        """
        The notification is active (`true`) or inactive (`false`). Default is `false`.
        """
        return pulumi.get(self, "active")

    @property
    @pulumi.getter(name="customMessage")
    def custom_message(self) -> pulumi.Output[str]:
        """
        The custom message of the notification. This message will be displayed in the extra variables **Message** field of your job template. You can use the following placeholders:  * `{ImpactedEntities}`: Details about the entities impacted by the problem in form of a JSON array.  * `{ImpactedEntity}`: The entity impacted by the problem or *X* impacted entities.  * `{PID}`: The ID of the reported problem.  * `{ProblemDetailsText}`: All problem event details, including root cause, as a text-formatted string.  * `{ProblemID}`: The display number of the reported problem.  * `{ProblemImpact}`: The [impact level](https://www.dynatrace.com/support/help/shortlink/impact-analysis) of the problem. Possible values are `APPLICATION`, `SERVICE`, and `INFRASTRUCTURE`.  * `{ProblemSeverity}`: The [severity level](https://www.dynatrace.com/support/help/shortlink/event-types) of the problem. Possible values are `AVAILABILITY`, `ERROR`, `PERFORMANCE`, `RESOURCE_CONTENTION`, and `CUSTOM_ALERT`.  * `{ProblemTitle}`: A short description of the problem.  * `{ProblemURL}`: The URL of the problem within Dynatrace.  * `{State}`: The state of the problem. Possible values are `OPEN` and `RESOLVED`.  * `{Tags}`: The list of tags that are defined for all impacted entities, separated by commas
        """
        return pulumi.get(self, "custom_message")

    @property
    @pulumi.getter
    def insecure(self) -> pulumi.Output[Optional[bool]]:
        """
        Accept any, including self-signed and invalid, SSL certificate (`true`) or only trusted (`false`) certificates. Default is `false`.
        """
        return pulumi.get(self, "insecure")

    @property
    @pulumi.getter(name="jobTemplateUrl")
    def job_template_url(self) -> pulumi.Output[str]:
        """
        The URL of the target Ansible Tower job template
        """
        return pulumi.get(self, "job_template_url")

    @property
    @pulumi.getter(name="legacyId")
    def legacy_id(self) -> pulumi.Output[str]:
        """
        The ID of these settings when referred to from resources requiring the REST API V1 keys
        """
        return pulumi.get(self, "legacy_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The display name within the Dynatrace WebUI.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[str]]:
        """
        The password for the Ansible Tower account
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def profile(self) -> pulumi.Output[str]:
        """
        The ID of the associated alerting profile.
        """
        return pulumi.get(self, "profile")

    @property
    @pulumi.getter
    def username(self) -> pulumi.Output[str]:
        """
        The username of the Ansible Tower account
        """
        return pulumi.get(self, "username")

