"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataFormat = exports.Encryption = exports.Machine = exports.Technology = exports.Size = exports.TechnicalAssetType = exports.TechnicalAsset = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const communication_1 = require("./communication");
const model_1 = require("./model");
const resource_1 = require("./resource");
const scope_1 = require("./scope");
class TechnicalAsset extends resource_1.Resource {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.type = props.type;
        this.usage = props.usage;
        this.humanUse = props.humanUse;
        this.internet = props.internet;
        this.scope = props.scope ?? new scope_1.InScope();
        this.size = props.size;
        this.technology = props.technology;
        this.tags = props.tags;
        this.machine = props.machine;
        this.encryption = props.encryption;
        this.owner = props.owner;
        this.ciaTriad = props.ciaTriad;
        this.multiTenant = props.multiTenant;
        this.redundant = props.redundant;
        this.customDevelopedParts = props.customDevelopedParts ?? false;
        this.dataFormatsAccepted = props.dataFormatsAccepted;
        this.dataAssetsProcessed = new Set();
        this.dataAssetsStored = new Set();
        this.communications = new Array();
        if (this.tags && this.tags.length > 0) {
            const model = model_1.Model.of(this);
            model.addTags(...this.tags);
        }
        if (props.trustBoundary) {
            props.trustBoundary.addTechnicalAssets(this);
        }
    }
    processes(...assets) {
        assets.forEach((a) => {
            this.dataAssetsProcessed.add(a.uuid);
        });
    }
    stores(...assets) {
        assets.forEach((a) => {
            this.dataAssetsStored.add(a.uuid);
        });
    }
    communicatesWith(id, target, options) {
        const communication = new communication_1.Communication(id, {
            caller: this,
            target: target,
            ...options,
        });
        this.communications.push(communication);
        return communication;
    }
    /**
     * @internal
     */
    _toThreagile() {
        const threagile = {
            [this.node.id]: {
                id: this.uuid,
                description: this.description,
                type: this.type,
                usage: this.usage,
                used_as_client_by_human: this.humanUse,
                ...this.scope?._toThreagile(),
                size: this.size,
                technology: this.technology,
                tags: Array.from(new Set(this.tags)),
                internet: this.internet,
                machine: this.machine,
                encryption: this.encryption,
                owner: this.owner,
                ...this.ciaTriad._toThreagile(),
                multitenant: this.multiTenant,
                redundant: this.redundant,
                custom_developed_parts: this.customDevelopedParts,
                data_assets_processed: Array.from(this.dataAssetsProcessed),
                data_assets_stored: Array.from(this.dataAssetsStored),
                data_formats_accepted: this.dataFormatsAccepted,
            },
        };
        threagile[this.node.id].communication_links = this.communications.reduce((prev, current) => Object.assign(prev, current._toThreagile()), {});
        return threagile;
    }
}
exports.TechnicalAsset = TechnicalAsset;
_a = JSII_RTTI_SYMBOL_1;
TechnicalAsset[_a] = { fqn: "cdktg.TechnicalAsset", version: "0.0.21" };
var TechnicalAssetType;
(function (TechnicalAssetType) {
    TechnicalAssetType["EXTERNAL_ENTITY"] = "external-entity";
    TechnicalAssetType["PROCESS"] = "process";
    TechnicalAssetType["DATASTORE"] = "datastore";
})(TechnicalAssetType = exports.TechnicalAssetType || (exports.TechnicalAssetType = {}));
var Size;
(function (Size) {
    Size["SYSTEM"] = "system";
    Size["SERVICE"] = "service";
    Size["APPLICATION"] = "application";
    Size["COMPONENT"] = "component";
})(Size = exports.Size || (exports.Size = {}));
var Technology;
(function (Technology) {
    Technology["UNKNOWN"] = "unknown-technology";
    Technology["CLIENT_SYSTEM"] = "client-system";
    Technology["BROWSER"] = "browser";
    Technology["DESKTOP"] = "desktop";
    Technology["MOBILE_APP"] = "mobile-app";
    Technology["DEVOPS_CLIENT"] = "devops-client";
    Technology["WEB_SERVER"] = "web-server";
    Technology["WEB_APPLICATION"] = "web-application";
    Technology["APPLICATION_SERVER"] = "application-server";
    Technology["DATABASE"] = "database";
    Technology["FILE_SERVER"] = "file-server";
    Technology["LOCAL_FILE_SERVER"] = "local-file-system";
    Technology["ERP"] = "erp";
    Technology["CMS"] = "cms";
    Technology["WEB_SERVICE_REST"] = "web-service-rest";
    Technology["WEB_SERVICE_SOAP"] = "web-service-soap";
    Technology["EJB"] = "ejb";
    Technology["SEARCH_INDEX"] = "search-index";
    Technology["SEARCH_ENGINE"] = "search-engine";
    Technology["SERVICE_REGISTRY"] = "service-registry";
    Technology["REVERSE_PROXY"] = "reverse-proxy";
    Technology["LOAD_BALANCER"] = "load-balancer";
    Technology["BUILD_PIPELINE"] = "build-pipeline";
    Technology["SOURCECODE_REPOSITORY"] = "sourcecode-repository";
    Technology["ARTIFACT_REGISTRY"] = "artifact-registry";
    Technology["CODE_INSPECTION_PLATFORM"] = "code-inspection-platform";
    Technology["MONITORING"] = "monitoring";
    Technology["LDAP_SERVER"] = "ldap-server";
    Technology["CONTAINER_PLATFORM"] = "container-platform";
    Technology["BATCH_PROCESSING"] = "batch-processing";
    Technology["EVENT_LISTENER"] = "event-listener";
    Technology["IDENTITIY_PROVIDER"] = "identity-provider";
    Technology["IDENTITY_STORE_LDAP"] = "identity-store-ldap";
    Technology["IDENTITY_STORE_DATABASE"] = "identity-store-database";
    Technology["TOOL"] = "tool";
    Technology["CLI"] = "cli";
    Technology["TASK"] = "task";
    Technology["FUNCTION"] = "function";
    Technology["GATEWAY"] = "gateway";
    Technology["IOT_DEVICE"] = "iot-device";
    Technology["MESSAGE_QUEUE"] = "message-queue";
    Technology["STREAM_PROCESSING"] = "stream-processing";
    Technology["SERVICE_MESH"] = "service-mesh";
    Technology["DATA_LAKE"] = "data-lake";
    Technology["REPORT_ENGINE"] = "report-engine";
    Technology["AI"] = "ai";
    Technology["MAIL_SERVER"] = "mail-server";
    Technology["VAULT"] = "vault";
    Technology["HASM"] = "hsm";
    Technology["WAF"] = "waf";
    Technology["IDS"] = "ids";
    Technology["IPS"] = "ips";
    Technology["SCHEDULER"] = "scheduler";
    Technology["MAINFRAME"] = "mainframe";
    Technology["BLOCK_STORAGE"] = "block-storage";
    Technology["LIBRARY"] = "library";
})(Technology = exports.Technology || (exports.Technology = {}));
var Machine;
(function (Machine) {
    Machine["PHYSICAL"] = "physical";
    Machine["VIRTUAL"] = "virtual";
    Machine["CONTAINER"] = "container";
    Machine["SERVERLESS"] = "serverless";
})(Machine = exports.Machine || (exports.Machine = {}));
var Encryption;
(function (Encryption) {
    Encryption["NONE"] = "none";
    Encryption["TRANSPARENT"] = "transparent";
    Encryption["SYMMETRIC_SHARED_KEY"] = "data-with-symmetric-shared-key";
    Encryption["ASYMMETRIC_SHARED_KEY"] = "data-with-asymmetric-shared-key";
    Encryption["ENDUSER_INDIVIDUAL_KEY"] = "data-with-enduser-individual-key";
})(Encryption = exports.Encryption || (exports.Encryption = {}));
var DataFormat;
(function (DataFormat) {
    DataFormat["JSON"] = "json";
    DataFormat["XML"] = "xml";
    DataFormat["SERIALIZATION"] = "serialization";
    DataFormat["FILE"] = "file";
    DataFormat["CSV"] = "csv";
})(DataFormat = exports.DataFormat || (exports.DataFormat = {}));
//# sourceMappingURL=data:application/json;base64,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