"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SharedRuntime = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const model_1 = require("./model");
const resource_1 = require("./resource");
class SharedRuntime extends resource_1.Resource {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.tags = props.tags;
        this.technicalAssetsRunning = new Set();
        if (this.tags && this.tags.length > 0) {
            const model = model_1.Model.of(this);
            model.addTags(...this.tags);
        }
    }
    runs(...assets) {
        assets.forEach((a) => {
            this.technicalAssetsRunning.add(a.uuid);
        });
    }
    /**
     * @internal
     */
    _toThreagile() {
        return {
            [this.node.id]: {
                id: this.uuid,
                description: this.description,
                tags: Array.from(new Set(this.tags)),
                technical_assets_running: Array.from(this.technicalAssetsRunning),
            },
        };
    }
}
exports.SharedRuntime = SharedRuntime;
_a = JSII_RTTI_SYMBOL_1;
SharedRuntime[_a] = { fqn: "cdktg.SharedRuntime", version: "0.0.21" };
//# sourceMappingURL=data:application/json;base64,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