"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BusinessCriticality = exports.Model = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
const data_asset_1 = require("./data-asset");
const risk_category_1 = require("./risk-category");
const rist_tracking_1 = require("./rist-tracking");
const shared_runtime_1 = require("./shared-runtime");
const synthesizer_1 = require("./synthesizer");
const technical_asset_1 = require("./technical-asset");
const trust_boundary_1 = require("./trust-boundary");
const MODEL_SYMBOL = Symbol.for("cdktg/Model");
class Model extends constructs_1.Construct {
    constructor(project, id, props) {
        super(project, id);
        this.version = props.version;
        this.title = props.title ?? id;
        this.date = props.date
            ? new Date(props.date).toISOString().split("T")[0]
            : undefined;
        this.author = props.author;
        this.managementSummary = props.managementSummary;
        this.businessCriticality = props.businessCriticality;
        this.questions = new Map();
        props.questions?.forEach((q) => {
            this.addQuestion(q.text, q.answer);
        });
        this.abuseCases = new Map();
        if (props.abuseCases && props.abuseCases.length > 0) {
            this.addAbuseCases(...props.abuseCases);
        }
        this.securityRequirements = new Map();
        if (props.securityRequirements && props.securityRequirements.length > 0) {
            this.addSecurityRequirements(...props.securityRequirements);
        }
        this.tags = new Set();
        this.riskTracking = new Map();
        this.rawOverrides = {};
        this.synthesizer = new synthesizer_1.ModelSynthesizer(this, false);
        Object.defineProperty(this, MODEL_SYMBOL, { value: true });
    }
    static isModel(x) {
        return x !== null && typeof x === "object" && MODEL_SYMBOL in x;
    }
    static of(construct) {
        return _lookup(construct);
        function _lookup(c) {
            if (Model.isModel(c)) {
                return c;
            }
            const node = c.node;
            if (!node.scope) {
                throw new Error(`No model could be identified for the construct at path '${construct.node.path}'`);
            }
            return _lookup(node.scope);
        }
    }
    addTag(tag) {
        this.addTags(tag);
    }
    addTags(...tags) {
        tags.forEach((tag) => {
            this.tags.add(tag);
        });
    }
    addQuestion(text, answer = "") {
        // "" as answer signals "unanswered"
        if (this.questions.has(text)) {
            throw new Error(`Duplicated question "${text}"`);
        }
        this.questions.set(text, answer);
    }
    addAbuseCases(...cases) {
        cases.forEach((c) => {
            if (this.abuseCases.has(c.name)) {
                throw new Error(`Duplicated abuse case "${c.name}"`);
            }
            this.abuseCases.set(c.name, c.description);
        });
    }
    addSecurityRequirements(...requirements) {
        requirements.forEach((r) => {
            if (this.abuseCases.has(r.name)) {
                throw new Error(`Duplicated security requirement "${r.name}"`);
            }
            this.securityRequirements.set(r.name, r.description);
        });
    }
    trackRisk(id, options = {}) {
        if (this.riskTracking.has(id)) {
            throw new Error(`Duplicated risk tracking "${id}"`);
        }
        this.riskTracking.set(id, new rist_tracking_1.RiskTracking(id, options));
    }
    addOverride(path, value) {
        const parts = path.split(".");
        let curr = this.rawOverrides;
        while (parts.length > 1) {
            // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
            const key = parts.shift();
            // if we can't recurse further or the previous value is not an
            // object overwrite it with an object.
            const isObject = curr[key] != null &&
                typeof curr[key] === "object" &&
                !Array.isArray(curr[key]);
            if (!isObject) {
                curr[key] = {};
            }
            curr = curr[key];
        }
        // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
        const lastKey = parts.shift();
        curr[lastKey] = value;
    }
    /**
     * @internal
     */
    _toThreagile() {
        const dataAssets = new Array();
        const technicalAssets = new Array();
        const trustBoundaries = new Array();
        const sharedRuntimes = new Array();
        const individualRiskCategories = new Array();
        this.node.findAll().map((n) => {
            if (n instanceof data_asset_1.DataAsset) {
                dataAssets.push(n);
            }
            else if (n instanceof technical_asset_1.TechnicalAsset) {
                technicalAssets.push(n);
            }
            else if (n instanceof trust_boundary_1.TrustBoundary) {
                trustBoundaries.push(n);
            }
            else if (n instanceof shared_runtime_1.SharedRuntime) {
                sharedRuntimes.push(n);
            }
            else if (n instanceof risk_category_1.RiskCategory) {
                individualRiskCategories.push(n);
            }
        });
        const threagile = {
            threagile_version: this.version,
            title: this.title,
            data: this.date,
            author: this.author._toThreagile(),
            management_summary_comment: this.managementSummary,
            business_criticality: this.businessCriticality,
            questions: Object.fromEntries(this.questions),
            abuse_cases: Object.fromEntries(this.abuseCases),
            security_requirements: Object.fromEntries(this.securityRequirements),
            tags_available: Array.from(this.tags),
        };
        threagile.data_assets = dataAssets.reduce((prev, current) => Object.assign(prev, current._toThreagile()), {});
        threagile.technical_assets = technicalAssets.reduce((prev, current) => Object.assign(prev, current._toThreagile()), {});
        threagile.trust_boundaries = trustBoundaries.reduce((prev, current) => Object.assign(prev, current._toThreagile()), {});
        threagile.shared_runtimes = sharedRuntimes.reduce((prev, current) => Object.assign(prev, current._toThreagile()), {});
        threagile.individual_risk_categories = individualRiskCategories.reduce((prev, current) => Object.assign(prev, current._toThreagile()), {});
        if (this.riskTracking.size > 0) {
            threagile.risk_tracking = Array.from(this.riskTracking.values()).reduce((prev, current) => Object.assign(prev, current._toThreagile()), {});
        }
        return {
            ...threagile,
            ...(Object.keys(this.rawOverrides).length > 0
                ? { overrides: { stack: Object.keys(this.rawOverrides) } }
                : {}),
        };
    }
}
exports.Model = Model;
_a = JSII_RTTI_SYMBOL_1;
Model[_a] = { fqn: "cdktg.Model", version: "0.0.21" };
var BusinessCriticality;
(function (BusinessCriticality) {
    BusinessCriticality["ARCHIVE"] = "archive";
    BusinessCriticality["OPERATIONAL"] = "operational";
    BusinessCriticality["IMPORTANT"] = "important";
    BusinessCriticality["CRITICAL"] = "critical";
    BusinessCriticality["MISSION_CRITICAL"] = "mission-critical";
})(BusinessCriticality = exports.BusinessCriticality || (exports.BusinessCriticality = {}));
//# sourceMappingURL=data:application/json;base64,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