"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Annotations = exports.DISABLE_STACK_TRACE_IN_METADATA = exports.AnnotationMetadataEntryType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
var AnnotationMetadataEntryType;
(function (AnnotationMetadataEntryType) {
    AnnotationMetadataEntryType["INFO"] = "@cdktg/info";
    AnnotationMetadataEntryType["WARN"] = "@cdktg/warn";
    AnnotationMetadataEntryType["ERROR"] = "@cdktg/error";
})(AnnotationMetadataEntryType = exports.AnnotationMetadataEntryType || (exports.AnnotationMetadataEntryType = {}));
exports.DISABLE_STACK_TRACE_IN_METADATA = "@cdktg/disable_stack_trace_in_metadata";
/**
 * Includes API for attaching annotations such as warning messages to constructs.
 */
class Annotations {
    constructor(scope) {
        this.scope = scope;
        const disableTrace = scope.node.tryGetContext(exports.DISABLE_STACK_TRACE_IN_METADATA) || false;
        this.stackTraces = !disableTrace;
    }
    /**
     * Returns the annotations API for a construct scope.
     * @param scope The scope
     */
    static of(scope) {
        return new Annotations(scope);
    }
    /**
     * Adds a warning metadata entry to this construct.
     *
     * The CLI will display the warning when an app is synthesized.
     * In a future release the CLI might introduce a --strict flag which
     * will then fail the synthesis if it encounters a warning.
     *
     * @param message The warning message.
     */
    addWarning(message) {
        this.addMessage(AnnotationMetadataEntryType.WARN, message);
    }
    /**
     * Adds an info metadata entry to this construct.
     *
     * The CLI will display the info message when apps are synthesized.
     *
     * @param message The info message.
     */
    addInfo(message) {
        this.addMessage(AnnotationMetadataEntryType.INFO, message);
    }
    /**
     * Adds an { "error": <message> } metadata entry to this construct.
     * The toolkit will fail synthesis when errors are reported.
     * @param message The error message.
     */
    addError(message) {
        this.addMessage(AnnotationMetadataEntryType.ERROR, message);
    }
    /**
     * Adds a message metadata entry to the construct node, to be displayed by the CDK CLI.
     * @param level The message level
     * @param message The message itself
     */
    addMessage(level, message) {
        this.scope.node.addMetadata(level, message, {
            stackTrace: this.stackTraces,
        });
    }
}
exports.Annotations = Annotations;
_a = JSII_RTTI_SYMBOL_1;
Annotations[_a] = { fqn: "cdktg.Annotations", version: "0.0.21" };
//# sourceMappingURL=data:application/json;base64,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