import typing as ty
from pydantic import BaseModel


_ReturnT = ty.TypeVar("_ReturnT")
ErrorsType = ty.Dict[Exception, ty.Union[int, ty.Tuple[int, str]]]
ResponsesType = ty.Dict[ty.Union[int, str], ty.Dict[str, ty.Any]]


class ErrorMessage(BaseModel):
    message: str
    type: str


class ErrorResponse(BaseModel):
    detail: ty.Union[str, ErrorMessage]
