from pyspark.sql.types import *
from optimus import Optimus
from optimus.helpers.json import json_enconding
from optimus.helpers.functions import deep_sort
import unittest
import numpy as np
nan = np.nan
import datetime
op = Optimus(master='local')
source_df=op.create.df({'names': 'object', 'height(ft)': 'float64', 'function': 'object', 'rank': 'float64', 'age': 'float64', 'weight(t)': 'float64', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'datetime64[ns]', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object'}, {'sample': {'columns': [{'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'rank'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}, {'title': 'Mixed'}], 'value': [["Optim'us", -28.0, 'Leader', 10.0, 4000000.0, 4.3, ['Inochi', 'Convoy'], '19.442735,-99.201111', '1980/04/10', '2016/09/10', [8.5344, 4300.0], datetime.date(2016, 9, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Leader'), None, 'male'], ['bumbl#ebéé', 17.0, 'Espionage', 7.0, 5000000.0, 2.0, ['Bumble', 'Goldback'], '10.642707,-71.612534', '1980/04/10', '2015/08/10', [5.334, 2000.0], datetime.date(2015, 8, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Espionage'), None, '1.1.1.1'], ['ironhide&', 26.0, 'Security', 7.0, 7000000.0, 4.0, ['Roadbuster'], '37.789563,-122.400356', '1980/04/10', '2014/07/10', [7.9248, 4000.0], datetime.date(2014, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Security'), None, 'http://hi-optimus.com'], ['Jazz', 13.0, 'First Lieutenant', 8.0, 5000000.0, 1.8, ['Meister'], '33.670666,-117.841553', '1980/04/10', '2013/06/10', [3.9624, 1800.0], datetime.date(2013, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'First Lieutenant'), None, '5123456789123456'], ['Megatron', nan, 'None', 10.0, 5000000.0, 5.7, ['Megatron'], None, '1980/04/10', '2012/05/10', [None, 5700.0], datetime.date(2012, 5, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'None'), None, '11529'], ['Metroplex_)^$', 300.0, 'Battle Station', 8.0, 5000000.0, nan, ['Metroflex'], None, '1980/04/10', '2011/04/10', [91.44, None], datetime.date(2011, 4, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Battle Station'), None, '3'], ['None', nan, None, nan, nan, nan, None, None, None, None, None, None, NaT, None, None, None, 'optimus']]}})
class Test_df_cols_dask(unittest.TestCase):
	maxDiff = None
	@staticmethod
	def test_cols_abs():
		actual_df =source_df.cols.abs('weight(t)')
		expected_df = op.create.df({'names': 'object', 'height(ft)': 'float64', 'function': 'object', 'rank': 'float64', 'age': 'float64', 'weight(t)': 'float64', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'datetime64[ns]', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object'}, {'sample': {'columns': [{'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'rank'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}, {'title': 'Mixed'}], 'value': [["Optim'us", -28.0, 'Leader', 10.0, 4000000.0, 4.3, ['Inochi', 'Convoy'], '19.442735,-99.201111', '1980/04/10', '2016/09/10', [8.5344, 4300.0], datetime.date(2016, 9, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Leader'), None, 'male'], ['bumbl#ebéé  ', 17.0, 'Espionage', 7.0, 5000000.0, 2.0, ['Bumble', 'Goldback'], '10.642707,-71.612534', '1980/04/10', '2015/08/10', [5.334, 2000.0], datetime.date(2015, 8, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Espionage'), None, '1.1.1.1'], ['ironhide&', 26.0, 'Security', 7.0, 7000000.0, 4.0, ['Roadbuster'], '37.789563,-122.400356', '1980/04/10', '2014/07/10', [7.9248, 4000.0], datetime.date(2014, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Security'), None, 'http://hi-optimus.com'], ['Jazz', 13.0, 'First Lieutenant', 8.0, 5000000.0, 1.8, ['Meister'], '33.670666,-117.841553', '1980/04/10', '2013/06/10', [3.9624, 1800.0], datetime.date(2013, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'First Lieutenant'), None, '5123456789123456'], ['Megatron', nan, 'None', 10.0, 5000000.0, 5.7, ['Megatron'], None, '1980/04/10', '2012/05/10', [None, 5700.0], datetime.date(2012, 5, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'None'), None, '11529'], ['Metroplex_)^$', 300.0, 'Battle Station', 8.0, 5000000.0, nan, ['Metroflex'], None, '1980/04/10', '2011/04/10', [91.44, None], datetime.date(2011, 4, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Battle Station'), None, '3'], [None, nan, None, nan, nan, nan, None, None, None, None, None, None, NaT, None, None, None, 'optimus']]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_abs_all_columns():
		actual_df =source_df.cols.abs('*')
		expected_df = op.create.df({'names': 'object', 'height(ft)': 'float64', 'function': 'object', 'rank': 'float64', 'age': 'float64', 'weight(t)': 'float64', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'datetime64[ns]', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object'}, {'sample': {'columns': [{'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'rank'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}, {'title': 'Mixed'}], 'value': [["Optim'us", -28.0, 'Leader', 10.0, 4000000.0, 4.3, ['Inochi', 'Convoy'], '19.442735,-99.201111', '1980/04/10', '2016/09/10', [8.5344, 4300.0], datetime.date(2016, 9, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Leader'), None, 'male'], ['bumbl#ebéé  ', 17.0, 'Espionage', 7.0, 5000000.0, 2.0, ['Bumble', 'Goldback'], '10.642707,-71.612534', '1980/04/10', '2015/08/10', [5.334, 2000.0], datetime.date(2015, 8, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Espionage'), None, '1.1.1.1'], ['ironhide&', 26.0, 'Security', 7.0, 7000000.0, 4.0, ['Roadbuster'], '37.789563,-122.400356', '1980/04/10', '2014/07/10', [7.9248, 4000.0], datetime.date(2014, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Security'), None, 'http://hi-optimus.com'], ['Jazz', 13.0, 'First Lieutenant', 8.0, 5000000.0, 1.8, ['Meister'], '33.670666,-117.841553', '1980/04/10', '2013/06/10', [3.9624, 1800.0], datetime.date(2013, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'First Lieutenant'), None, '5123456789123456'], ['Megatron', nan, 'None', 10.0, 5000000.0, 5.7, ['Megatron'], None, '1980/04/10', '2012/05/10', [None, 5700.0], datetime.date(2012, 5, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'None'), None, '11529'], ['Metroplex_)^$', 300.0, 'Battle Station', 8.0, 5000000.0, nan, ['Metroflex'], None, '1980/04/10', '2011/04/10', [91.44, None], datetime.date(2011, 4, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Battle Station'), None, '3'], [None, nan, None, nan, nan, nan, None, None, None, None, None, None, NaT, None, None, None, 'optimus']]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_add():
		actual_df =source_df.cols.add(['height(ft)','rank'])
		expected_df = op.create.df({'names': 'object', 'height(ft)': 'float64', 'function': 'object', 'rank': 'float64', 'age': 'float64', 'weight(t)': 'float64', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'datetime64[ns]', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object', 'sum': 'float64'}, {'sample': {'columns': [{'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'rank'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}, {'title': 'Mixed'}, {'title': 'sum'}], 'value': [["Optim'us", -28.0, 'Leader', 10.0, 4000000.0, 4.3, ['Inochi', 'Convoy'], '19.442735,-99.201111', '1980/04/10', '2016/09/10', [8.5344, 4300.0], datetime.date(2016, 9, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Leader'), None, 'male', -18.0], ['bumbl#ebéé  ', 17.0, 'Espionage', 7.0, 5000000.0, 2.0, ['Bumble', 'Goldback'], '10.642707,-71.612534', '1980/04/10', '2015/08/10', [5.334, 2000.0], datetime.date(2015, 8, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Espionage'), None, '1.1.1.1', 24.0], ['ironhide&', 26.0, 'Security', 7.0, 7000000.0, 4.0, ['Roadbuster'], '37.789563,-122.400356', '1980/04/10', '2014/07/10', [7.9248, 4000.0], datetime.date(2014, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Security'), None, 'http://hi-optimus.com', 33.0], ['Jazz', 13.0, 'First Lieutenant', 8.0, 5000000.0, 1.8, ['Meister'], '33.670666,-117.841553', '1980/04/10', '2013/06/10', [3.9624, 1800.0], datetime.date(2013, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'First Lieutenant'), None, '5123456789123456', 21.0], ['Megatron', nan, 'None', 10.0, 5000000.0, 5.7, ['Megatron'], None, '1980/04/10', '2012/05/10', [None, 5700.0], datetime.date(2012, 5, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'None'), None, '11529', nan], ['Metroplex_)^$', 300.0, 'Battle Station', 8.0, 5000000.0, nan, ['Metroflex'], None, '1980/04/10', '2011/04/10', [91.44, None], datetime.date(2011, 4, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Battle Station'), None, '3', 308.0], [None, nan, None, nan, nan, nan, None, None, None, None, None, None, NaT, None, None, None, 'optimus', nan]]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_add_all_columns():
		actual_df =source_df.cols.add('*')
		expected_df = op.create.df({'names': 'object', 'height(ft)': 'float64', 'function': 'object', 'rank': 'float64', 'age': 'float64', 'weight(t)': 'float64', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'datetime64[ns]', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object', 'sum': 'float64'}, {'sample': {'columns': [{'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'rank'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}, {'title': 'Mixed'}, {'title': 'sum'}], 'value': [["Optim'us", -28.0, 'Leader', 10.0, 4000000.0, 4.3, ['Inochi', 'Convoy'], '19.442735,-99.201111', '1980/04/10', '2016/09/10', [8.5344, 4300.0], datetime.date(2016, 9, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Leader'), None, 'male', 3999986.3], ['bumbl#ebéé  ', 17.0, 'Espionage', 7.0, 5000000.0, 2.0, ['Bumble', 'Goldback'], '10.642707,-71.612534', '1980/04/10', '2015/08/10', [5.334, 2000.0], datetime.date(2015, 8, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Espionage'), None, '1.1.1.1', 5000026.0], ['ironhide&', 26.0, 'Security', 7.0, 7000000.0, 4.0, ['Roadbuster'], '37.789563,-122.400356', '1980/04/10', '2014/07/10', [7.9248, 4000.0], datetime.date(2014, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Security'), None, 'http://hi-optimus.com', 7000037.0], ['Jazz', 13.0, 'First Lieutenant', 8.0, 5000000.0, 1.8, ['Meister'], '33.670666,-117.841553', '1980/04/10', '2013/06/10', [3.9624, 1800.0], datetime.date(2013, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'First Lieutenant'), None, '5123456789123456', 5000022.8], ['Megatron', nan, 'None', 10.0, 5000000.0, 5.7, ['Megatron'], None, '1980/04/10', '2012/05/10', [None, 5700.0], datetime.date(2012, 5, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'None'), None, '11529', nan], ['Metroplex_)^$', 300.0, 'Battle Station', 8.0, 5000000.0, nan, ['Metroflex'], None, '1980/04/10', '2011/04/10', [91.44, None], datetime.date(2011, 4, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Battle Station'), None, '3', nan], [None, nan, None, nan, nan, nan, None, None, None, None, None, None, NaT, None, None, None, 'optimus', nan]]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_cast():
		actual_df =source_df.cols.cast('function','string')
		expected_df = op.create.df({'names': 'object', 'height(ft)': 'float64', 'function': 'string', 'rank': 'float64', 'age': 'float64', 'weight(t)': 'float64', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'datetime64[ns]', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object'}, {'sample': {'columns': [{'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'rank'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}, {'title': 'Mixed'}], 'value': [["Optim'us", -28.0, 'Leader', 10.0, 4000000.0, 4.3, ['Inochi', 'Convoy'], '19.442735,-99.201111', '1980/04/10', '2016/09/10', [8.5344, 4300.0], datetime.date(2016, 9, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Leader'), None, 'male'], ['bumbl#ebéé  ', 17.0, 'Espionage', 7.0, 5000000.0, 2.0, ['Bumble', 'Goldback'], '10.642707,-71.612534', '1980/04/10', '2015/08/10', [5.334, 2000.0], datetime.date(2015, 8, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Espionage'), None, '1.1.1.1'], ['ironhide&', 26.0, 'Security', 7.0, 7000000.0, 4.0, ['Roadbuster'], '37.789563,-122.400356', '1980/04/10', '2014/07/10', [7.9248, 4000.0], datetime.date(2014, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Security'), None, 'http://hi-optimus.com'], ['Jazz', 13.0, 'First Lieutenant', 8.0, 5000000.0, 1.8, ['Meister'], '33.670666,-117.841553', '1980/04/10', '2013/06/10', [3.9624, 1800.0], datetime.date(2013, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'First Lieutenant'), None, '5123456789123456'], ['Megatron', nan, 'None', 10.0, 5000000.0, 5.7, ['Megatron'], None, '1980/04/10', '2012/05/10', [None, 5700.0], datetime.date(2012, 5, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'None'), None, '11529'], ['Metroplex_)^$', 300.0, 'Battle Station', 8.0, 5000000.0, nan, ['Metroflex'], None, '1980/04/10', '2011/04/10', [91.44, None], datetime.date(2011, 4, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Battle Station'), None, '3'], [None, nan, <NA>, nan, nan, nan, None, None, None, None, None, None, NaT, None, None, None, 'optimus']]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_cast_all_columns():
		actual_df =source_df.cols.cast('*','str')
		expected_df = op.create.df({'names': 'object', 'height(ft)': 'object', 'function': 'object', 'rank': 'object', 'age': 'object', 'weight(t)': 'object', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'object', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object'}, {'sample': {'columns': [{'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'rank'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}, {'title': 'Mixed'}], 'value': [["Optim'us", '-28.0', 'Leader', '10.0', '4000000.0', '4.3', "['Inochi', 'Convoy']", '19.442735,-99.201111', '1980/04/10', '2016/09/10', '[8.5344, 4300.0]', '2016-09-10', '2014-06-24', 'True', "bytearray(b'Leader')", 'None', 'male'], ['bumbl#ebéé  ', '17.0', 'Espionage', '7.0', '5000000.0', '2.0', "['Bumble', 'Goldback']", '10.642707,-71.612534', '1980/04/10', '2015/08/10', '[5.334, 2000.0]', '2015-08-10', '2014-06-24', 'True', "bytearray(b'Espionage')", 'None', '1.1.1.1'], ['ironhide&', '26.0', 'Security', '7.0', '7000000.0', '4.0', "['Roadbuster']", '37.789563,-122.400356', '1980/04/10', '2014/07/10', '[7.9248, 4000.0]', '2014-06-24', '2014-06-24', 'True', "bytearray(b'Security')", 'None', 'http://hi-optimus.com'], ['Jazz', '13.0', 'First Lieutenant', '8.0', '5000000.0', '1.8', "['Meister']", '33.670666,-117.841553', '1980/04/10', '2013/06/10', '[3.9624, 1800.0]', '2013-06-24', '2014-06-24', 'True', "bytearray(b'First Lieutenant')", 'None', '5123456789123456'], ['Megatron', 'nan', 'None', '10.0', '5000000.0', '5.7', "['Megatron']", 'None', '1980/04/10', '2012/05/10', '[None, 5700.0]', '2012-05-10', '2014-06-24', 'True', "bytearray(b'None')", 'None', '11529'], ['Metroplex_)^$', '300.0', 'Battle Station', '8.0', '5000000.0', 'nan', "['Metroflex']", 'None', '1980/04/10', '2011/04/10', '[91.44, None]', '2011-04-10', '2014-06-24', 'True', "bytearray(b'Battle Station')", 'None', '3'], ['None', 'nan', 'None', 'nan', 'nan', 'nan', 'None', 'None', 'None', 'None', 'None', 'None', 'NaT', 'None', 'None', 'None', 'optimus']]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_clip():
		actual_df =source_df.cols.clip('rank',3,5)
		expected_df = op.create.df({'names': 'object', 'height(ft)': 'float64', 'function': 'object', 'rank': 'float64', 'age': 'float64', 'weight(t)': 'float64', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'datetime64[ns]', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object'}, {'sample': {'columns': [{'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'rank'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}, {'title': 'Mixed'}], 'value': [["Optim'us", -28.0, 'Leader', 5.0, 4000000.0, 4.3, ['Inochi', 'Convoy'], '19.442735,-99.201111', '1980/04/10', '2016/09/10', [8.5344, 4300.0], datetime.date(2016, 9, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Leader'), None, 'male'], ['bumbl#ebéé  ', 17.0, 'Espionage', 5.0, 5000000.0, 2.0, ['Bumble', 'Goldback'], '10.642707,-71.612534', '1980/04/10', '2015/08/10', [5.334, 2000.0], datetime.date(2015, 8, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Espionage'), None, '1.1.1.1'], ['ironhide&', 26.0, 'Security', 5.0, 7000000.0, 4.0, ['Roadbuster'], '37.789563,-122.400356', '1980/04/10', '2014/07/10', [7.9248, 4000.0], datetime.date(2014, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Security'), None, 'http://hi-optimus.com'], ['Jazz', 13.0, 'First Lieutenant', 5.0, 5000000.0, 1.8, ['Meister'], '33.670666,-117.841553', '1980/04/10', '2013/06/10', [3.9624, 1800.0], datetime.date(2013, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'First Lieutenant'), None, '5123456789123456'], ['Megatron', nan, 'None', 5.0, 5000000.0, 5.7, ['Megatron'], None, '1980/04/10', '2012/05/10', [None, 5700.0], datetime.date(2012, 5, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'None'), None, '11529'], ['Metroplex_)^$', 300.0, 'Battle Station', 5.0, 5000000.0, nan, ['Metroflex'], None, '1980/04/10', '2011/04/10', [91.44, None], datetime.date(2011, 4, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Battle Station'), None, '3'], [None, nan, None, nan, nan, nan, None, None, None, None, None, None, NaT, None, None, None, 'optimus']]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_clip_all_columns():
		actual_df =source_df.cols.clip('*',3,5)
		expected_df = op.create.df({'names': 'object', 'height(ft)': 'float64', 'function': 'object', 'rank': 'float64', 'age': 'float64', 'weight(t)': 'float64', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'datetime64[ns]', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object'}, {'sample': {'columns': [{'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'rank'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}, {'title': 'Mixed'}], 'value': [["Optim'us", 3.0, 'Leader', 5.0, 5.0, 4.3, ['Inochi', 'Convoy'], '19.442735,-99.201111', '1980/04/10', '2016/09/10', [8.5344, 4300.0], datetime.date(2016, 9, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Leader'), None, 'male'], ['bumbl#ebéé  ', 5.0, 'Espionage', 5.0, 5.0, 3.0, ['Bumble', 'Goldback'], '10.642707,-71.612534', '1980/04/10', '2015/08/10', [5.334, 2000.0], datetime.date(2015, 8, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Espionage'), None, '1.1.1.1'], ['ironhide&', 5.0, 'Security', 5.0, 5.0, 4.0, ['Roadbuster'], '37.789563,-122.400356', '1980/04/10', '2014/07/10', [7.9248, 4000.0], datetime.date(2014, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Security'), None, 'http://hi-optimus.com'], ['Jazz', 5.0, 'First Lieutenant', 5.0, 5.0, 3.0, ['Meister'], '33.670666,-117.841553', '1980/04/10', '2013/06/10', [3.9624, 1800.0], datetime.date(2013, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'First Lieutenant'), None, '5123456789123456'], ['Megatron', nan, 'None', 5.0, 5.0, 5.0, ['Megatron'], None, '1980/04/10', '2012/05/10', [None, 5700.0], datetime.date(2012, 5, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'None'), None, '11529'], ['Metroplex_)^$', 5.0, 'Battle Station', 5.0, 5.0, nan, ['Metroflex'], None, '1980/04/10', '2011/04/10', [91.44, None], datetime.date(2011, 4, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Battle Station'), None, '3'], [None, nan, None, nan, nan, nan, None, None, None, None, None, None, NaT, None, None, None, 'optimus']]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_count():
		actual_df =source_df.cols.count()
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding(17)
		assert(expected_value == actual_df)
	def test_cols_count_mismatch(self):
		actual_df =mismatch_df.cols.count_mismatch({"col 1": "int"})
		expected_value ={'col 1': {'mismatch': 11, 'missing': 1, 'match': 3}}
		self.assertDictEqual(deep_sort(expected_value),  deep_sort(actual_df))
	@staticmethod
	def test_cols_count_mismatch_array():
		actual_df =source_df.cols.count_mismatch({"Mixed": "array"})
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'Mixed': {'mismatch': 0, 'missing': 0, 'match': 7}})
		assert(expected_value == actual_df)
	def test_cols_count_mismatch_array1(self):
		actual_df =mismatch_df.cols.count_mismatch({"col 1": "array"})
		expected_value ={'col 1': {'mismatch': 0, 'missing': 1, 'match': 14}}
		self.assertDictEqual(deep_sort(expected_value),  deep_sort(actual_df))
	@staticmethod
	def test_cols_count_mismatch_boolean():
		actual_df =source_df.cols.count_mismatch({"Mixed": "boolean"})
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'Mixed': {'mismatch': 7, 'missing': 0, 'match': 0}})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_count_mismatch_credit_card():
		actual_df =source_df.cols.count_mismatch({"Mixed": "credit_card_number"})
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'Mixed': {'mismatch': 6, 'missing': 0, 'match': 1}})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_count_mismatch_date():
		actual_df =source_df.cols.count_mismatch({"Mixed": "date"})
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'Mixed': {'mismatch': 7, 'missing': 0, 'match': 0}})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_count_mismatch_decimal():
		actual_df =source_df.cols.count_mismatch({"Mixed": "decimal"})
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'Mixed': {'mismatch': 7, 'missing': 0, 'match': 0}})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_count_mismatch_email():
		actual_df =source_df.cols.count_mismatch({"Mixed": "email"})
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'Mixed': {'mismatch': 7, 'missing': 0, 'match': 0}})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_count_mismatch_int():
		actual_df =source_df.cols.count_mismatch({"Mixed": "int"})
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'Mixed': {'mismatch': 4, 'missing': 0, 'match': 3}})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_count_mismatch_ip():
		actual_df =source_df.cols.count_mismatch({"Mixed": "ip"})
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'Mixed': {'mismatch': 6, 'missing': 0, 'match': 1}})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_count_mismatch_object():
		actual_df =source_df.cols.count_mismatch({"Mixed": "object"})
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'Mixed': {'mismatch': 7, 'missing': 0, 'match': 0}})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_count_mismatch_string():
		actual_df =source_df.cols.count_mismatch({"Mixed": "string"})
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'Mixed': {'mismatch': 0, 'missing': 0, 'match': 7}})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_count_mismatch_url():
		actual_df =source_df.cols.count_mismatch({"Mixed": "url"})
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'Mixed': {'mismatch': 6, 'missing': 0, 'match': 1}})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_count_mismatch_zip_code():
		actual_df =source_df.cols.count_mismatch({"Mixed": "zip_code"})
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'Mixed': {'mismatch': 6, 'missing': 0, 'match': 1}})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_count_na():
		actual_df =source_df.cols.count_na('height(ft)')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'count_na': {'height(ft)': 2}})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_count_na_all_columns():
		actual_df =source_df.cols.count_na('*')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'count_na': {'names': 1, 'height(ft)': 2, 'function': 1, 'rank': 1, 'age': 1, 'weight(t)': 2, 'japanese name': 1, 'last position seen': 3, 'date arrival': 1, 'last date seen': 1, 'attributes': 1, 'Date Type': 1, 'timestamp': 1, 'Cybertronian': 1, 'function(binary)': 1, 'NullType': 7, 'Mixed': 0}})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_count_uniques():
		actual_df =source_df.cols.count_uniques('height(ft)')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'height(ft)': {'count_uniques': 6}})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_count_uniques_all_columns():
		actual_df =source_df.cols.count_uniques('*')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'names': {'count_uniques': 7}, 'height(ft)': {'count_uniques': 6}, 'function': {'count_uniques': 6}, 'rank': {'count_uniques': 4}, 'age': {'count_uniques': 4}, 'weight(t)': {'count_uniques': 6}, 'japanese name': {'count_uniques': 7}, 'last position seen': {'count_uniques': 5}, 'date arrival': {'count_uniques': 2}, 'last date seen': {'count_uniques': 7}, 'attributes': {'count_uniques': 7}, 'Date Type': {'count_uniques': 7}, 'timestamp': {'count_uniques': 2}, 'Cybertronian': {'count_uniques': 2}, 'function(binary)': {'count_uniques': 7}, 'NullType': {'count_uniques': 1}, 'Mixed': {'count_uniques': 7}})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_count_zeros():
		actual_df =source_df.cols.count_zeros('height(ft)')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'zeros': {'height(ft)': 0}})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_count_zeros_all_columns():
		actual_df =source_df.cols.count_zeros('*')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'zeros': {'names': 0, 'height(ft)': 0, 'function': 0, 'rank': 0, 'age': 0, 'weight(t)': 0, 'japanese name': 0, 'last position seen': 0, 'date arrival': 0, 'last date seen': 0, 'attributes': 0, 'Date Type': 0, 'Cybertronian': 0, 'function(binary)': 0, 'NullType': 0, 'Mixed': 0}})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_date_format():
		actual_df =source_df.cols.date_format('date arrival','%Y/%m/%d','%d/%m/%Y')
		expected_df = op.create.df({'names': 'object', 'height(ft)': 'float64', 'function': 'object', 'rank': 'float64', 'age': 'float64', 'weight(t)': 'float64', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'datetime64[ns]', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object'}, {'sample': {'columns': [{'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'rank'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}, {'title': 'Mixed'}], 'value': [["Optim'us", -28.0, 'Leader', 10.0, 4000000.0, 4.3, ['Inochi', 'Convoy'], '19.442735,-99.201111', '10/04/1980', '2016/09/10', [8.5344, 4300.0], datetime.date(2016, 9, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Leader'), None, 'male'], ['bumbl#ebéé  ', 17.0, 'Espionage', 7.0, 5000000.0, 2.0, ['Bumble', 'Goldback'], '10.642707,-71.612534', '10/04/1980', '2015/08/10', [5.334, 2000.0], datetime.date(2015, 8, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Espionage'), None, '1.1.1.1'], ['ironhide&', 26.0, 'Security', 7.0, 7000000.0, 4.0, ['Roadbuster'], '37.789563,-122.400356', '10/04/1980', '2014/07/10', [7.9248, 4000.0], datetime.date(2014, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Security'), None, 'http://hi-optimus.com'], ['Jazz', 13.0, 'First Lieutenant', 8.0, 5000000.0, 1.8, ['Meister'], '33.670666,-117.841553', '10/04/1980', '2013/06/10', [3.9624, 1800.0], datetime.date(2013, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'First Lieutenant'), None, '5123456789123456'], ['Megatron', nan, 'None', 10.0, 5000000.0, 5.7, ['Megatron'], None, '10/04/1980', '2012/05/10', [None, 5700.0], datetime.date(2012, 5, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'None'), None, '11529'], ['Metroplex_)^$', 300.0, 'Battle Station', 8.0, 5000000.0, nan, ['Metroflex'], None, '10/04/1980', '2011/04/10', [91.44, None], datetime.date(2011, 4, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Battle Station'), None, '3'], [None, nan, None, nan, nan, nan, None, None, nan, None, None, None, NaT, None, None, None, 'optimus']]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_date_format_all_columns():
		actual_df =source_df.cols.date_format(['date arrival','last date seen'],'%Y/%m/%d','%d/%m/%Y')
		expected_df = op.create.df({'names': 'object', 'height(ft)': 'float64', 'function': 'object', 'rank': 'float64', 'age': 'float64', 'weight(t)': 'float64', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'datetime64[ns]', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object'}, {'sample': {'columns': [{'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'rank'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}, {'title': 'Mixed'}], 'value': [["Optim'us", -28.0, 'Leader', 10.0, 4000000.0, 4.3, ['Inochi', 'Convoy'], '19.442735,-99.201111', '10/04/1980', '10/09/2016', [8.5344, 4300.0], datetime.date(2016, 9, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Leader'), None, 'male'], ['bumbl#ebéé  ', 17.0, 'Espionage', 7.0, 5000000.0, 2.0, ['Bumble', 'Goldback'], '10.642707,-71.612534', '10/04/1980', '10/08/2015', [5.334, 2000.0], datetime.date(2015, 8, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Espionage'), None, '1.1.1.1'], ['ironhide&', 26.0, 'Security', 7.0, 7000000.0, 4.0, ['Roadbuster'], '37.789563,-122.400356', '10/04/1980', '10/07/2014', [7.9248, 4000.0], datetime.date(2014, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Security'), None, 'http://hi-optimus.com'], ['Jazz', 13.0, 'First Lieutenant', 8.0, 5000000.0, 1.8, ['Meister'], '33.670666,-117.841553', '10/04/1980', '10/06/2013', [3.9624, 1800.0], datetime.date(2013, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'First Lieutenant'), None, '5123456789123456'], ['Megatron', nan, 'None', 10.0, 5000000.0, 5.7, ['Megatron'], None, '10/04/1980', '10/05/2012', [None, 5700.0], datetime.date(2012, 5, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'None'), None, '11529'], ['Metroplex_)^$', 300.0, 'Battle Station', 8.0, 5000000.0, nan, ['Metroflex'], None, '10/04/1980', '10/04/2011', [91.44, None], datetime.date(2011, 4, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Battle Station'), None, '3'], [None, nan, None, nan, nan, nan, None, None, nan, nan, None, None, NaT, None, None, None, 'optimus']]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_div():
		actual_df =source_df.cols.div(['height(ft)','rank'])
		expected_df = op.create.df({'names': 'object', 'height(ft)': 'float64', 'function': 'object', 'rank': 'float64', 'age': 'float64', 'weight(t)': 'float64', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'datetime64[ns]', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object', 'div': 'float64'}, {'sample': {'columns': [{'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'rank'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}, {'title': 'Mixed'}, {'title': 'div'}], 'value': [["Optim'us", -28.0, 'Leader', 10.0, 4000000.0, 4.3, ['Inochi', 'Convoy'], '19.442735,-99.201111', '1980/04/10', '2016/09/10', [8.5344, 4300.0], datetime.date(2016, 9, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Leader'), None, 'male', -2.8], ['bumbl#ebéé  ', 17.0, 'Espionage', 7.0, 5000000.0, 2.0, ['Bumble', 'Goldback'], '10.642707,-71.612534', '1980/04/10', '2015/08/10', [5.334, 2000.0], datetime.date(2015, 8, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Espionage'), None, '1.1.1.1', 2.4285714285714284], ['ironhide&', 26.0, 'Security', 7.0, 7000000.0, 4.0, ['Roadbuster'], '37.789563,-122.400356', '1980/04/10', '2014/07/10', [7.9248, 4000.0], datetime.date(2014, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Security'), None, 'http://hi-optimus.com', 3.7142857142857144], ['Jazz', 13.0, 'First Lieutenant', 8.0, 5000000.0, 1.8, ['Meister'], '33.670666,-117.841553', '1980/04/10', '2013/06/10', [3.9624, 1800.0], datetime.date(2013, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'First Lieutenant'), None, '5123456789123456', 1.625], ['Megatron', nan, 'None', 10.0, 5000000.0, 5.7, ['Megatron'], None, '1980/04/10', '2012/05/10', [None, 5700.0], datetime.date(2012, 5, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'None'), None, '11529', nan], ['Metroplex_)^$', 300.0, 'Battle Station', 8.0, 5000000.0, nan, ['Metroflex'], None, '1980/04/10', '2011/04/10', [91.44, None], datetime.date(2011, 4, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Battle Station'), None, '3', 37.5], [None, nan, None, nan, nan, nan, None, None, None, None, None, None, NaT, None, None, None, 'optimus', nan]]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_div_all_columns():
		actual_df =source_df.cols.div('*')
		expected_df = op.create.df({'names': 'object', 'height(ft)': 'float64', 'function': 'object', 'rank': 'float64', 'age': 'float64', 'weight(t)': 'float64', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'datetime64[ns]', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object', 'div': 'float64'}, {'sample': {'columns': [{'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'rank'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}, {'title': 'Mixed'}, {'title': 'div'}], 'value': [["Optim'us", -28.0, 'Leader', 10.0, 4000000.0, 4.3, ['Inochi', 'Convoy'], '19.442735,-99.201111', '1980/04/10', '2016/09/10', [8.5344, 4300.0], datetime.date(2016, 9, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Leader'), None, 'male', -1.627906976744186e-07], ['bumbl#ebéé  ', 17.0, 'Espionage', 7.0, 5000000.0, 2.0, ['Bumble', 'Goldback'], '10.642707,-71.612534', '1980/04/10', '2015/08/10', [5.334, 2000.0], datetime.date(2015, 8, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Espionage'), None, '1.1.1.1', 2.428571428571428e-07], ['ironhide&', 26.0, 'Security', 7.0, 7000000.0, 4.0, ['Roadbuster'], '37.789563,-122.400356', '1980/04/10', '2014/07/10', [7.9248, 4000.0], datetime.date(2014, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Security'), None, 'http://hi-optimus.com', 1.326530612244898e-07], ['Jazz', 13.0, 'First Lieutenant', 8.0, 5000000.0, 1.8, ['Meister'], '33.670666,-117.841553', '1980/04/10', '2013/06/10', [3.9624, 1800.0], datetime.date(2013, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'First Lieutenant'), None, '5123456789123456', 1.8055555555555556e-07], ['Megatron', nan, 'None', 10.0, 5000000.0, 5.7, ['Megatron'], None, '1980/04/10', '2012/05/10', [None, 5700.0], datetime.date(2012, 5, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'None'), None, '11529', nan], ['Metroplex_)^$', 300.0, 'Battle Station', 8.0, 5000000.0, nan, ['Metroflex'], None, '1980/04/10', '2011/04/10', [91.44, None], datetime.date(2011, 4, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Battle Station'), None, '3', nan], [None, nan, None, nan, nan, nan, None, None, None, None, None, None, NaT, None, None, None, 'optimus', nan]]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_drop():
		actual_df =source_df.cols.drop('rank')
		expected_df = op.create.df({'names': 'object', 'height(ft)': 'float64', 'function': 'object', 'age': 'float64', 'weight(t)': 'float64', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'datetime64[ns]', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object'}, {'sample': {'columns': [{'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}, {'title': 'Mixed'}], 'value': [["Optim'us", -28.0, 'Leader', 4000000.0, 4.3, ['Inochi', 'Convoy'], '19.442735,-99.201111', '1980/04/10', '2016/09/10', [8.5344, 4300.0], datetime.date(2016, 9, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Leader'), None, 'male'], ['bumbl#ebéé  ', 17.0, 'Espionage', 5000000.0, 2.0, ['Bumble', 'Goldback'], '10.642707,-71.612534', '1980/04/10', '2015/08/10', [5.334, 2000.0], datetime.date(2015, 8, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Espionage'), None, '1.1.1.1'], ['ironhide&', 26.0, 'Security', 7000000.0, 4.0, ['Roadbuster'], '37.789563,-122.400356', '1980/04/10', '2014/07/10', [7.9248, 4000.0], datetime.date(2014, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Security'), None, 'http://hi-optimus.com'], ['Jazz', 13.0, 'First Lieutenant', 5000000.0, 1.8, ['Meister'], '33.670666,-117.841553', '1980/04/10', '2013/06/10', [3.9624, 1800.0], datetime.date(2013, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'First Lieutenant'), None, '5123456789123456'], ['Megatron', nan, 'None', 5000000.0, 5.7, ['Megatron'], None, '1980/04/10', '2012/05/10', [None, 5700.0], datetime.date(2012, 5, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'None'), None, '11529'], ['Metroplex_)^$', 300.0, 'Battle Station', 5000000.0, nan, ['Metroflex'], None, '1980/04/10', '2011/04/10', [91.44, None], datetime.date(2011, 4, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Battle Station'), None, '3'], [None, nan, None, nan, nan, None, None, None, None, None, None, NaT, None, None, None, 'optimus']]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_dtypes():
		actual_df =source_df.cols.dtypes('rank')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'rank': 'float64'})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_dtypes_all_columns():
		actual_df =source_df.cols.dtypes('*')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'names': 'object', 'height(ft)': 'float64', 'function': 'object', 'rank': 'float64', 'age': 'float64', 'weight(t)': 'float64', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'datetime64[ns]', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object'})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_fill_na():
		actual_df =source_df.cols.fill_na('Cybertronian',False)
		expected_df = op.create.df({'names': 'object', 'height(ft)': 'float64', 'function': 'object', 'rank': 'float64', 'age': 'float64', 'weight(t)': 'float64', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'datetime64[ns]', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object'}, {'sample': {'columns': [{'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'rank'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}, {'title': 'Mixed'}], 'value': [["Optim'us", -28.0, 'Leader', 10.0, 4000000.0, 4.3, ['Inochi', 'Convoy'], '19.442735,-99.201111', '1980/04/10', '2016/09/10', [8.5344, 4300.0], datetime.date(2016, 9, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Leader'), None, 'male'], ['bumbl#ebéé  ', 17.0, 'Espionage', 7.0, 5000000.0, 2.0, ['Bumble', 'Goldback'], '10.642707,-71.612534', '1980/04/10', '2015/08/10', [5.334, 2000.0], datetime.date(2015, 8, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Espionage'), None, '1.1.1.1'], ['ironhide&', 26.0, 'Security', 7.0, 7000000.0, 4.0, ['Roadbuster'], '37.789563,-122.400356', '1980/04/10', '2014/07/10', [7.9248, 4000.0], datetime.date(2014, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Security'), None, 'http://hi-optimus.com'], ['Jazz', 13.0, 'First Lieutenant', 8.0, 5000000.0, 1.8, ['Meister'], '33.670666,-117.841553', '1980/04/10', '2013/06/10', [3.9624, 1800.0], datetime.date(2013, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'First Lieutenant'), None, '5123456789123456'], ['Megatron', nan, 'None', 10.0, 5000000.0, 5.7, ['Megatron'], None, '1980/04/10', '2012/05/10', [None, 5700.0], datetime.date(2012, 5, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'None'), None, '11529'], ['Metroplex_)^$', 300.0, 'Battle Station', 8.0, 5000000.0, nan, ['Metroflex'], None, '1980/04/10', '2011/04/10', [91.44, None], datetime.date(2011, 4, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Battle Station'), None, '3'], [None, nan, None, nan, nan, nan, None, None, None, None, None, None, NaT, False, None, None, 'optimus']]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_fill_na_all_columns():
		actual_df =source_df.cols.fill_na(['names','height(ft)','function','rank','age'],'2')
		expected_df = op.create.df({'names': 'object', 'height(ft)': 'float64', 'function': 'object', 'rank': 'float64', 'age': 'float64', 'weight(t)': 'float64', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'datetime64[ns]', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object'}, {'sample': {'columns': [{'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'rank'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}, {'title': 'Mixed'}], 'value': [["Optim'us", -28.0, 'Leader', 10.0, 4000000.0, 4.3, ['Inochi', 'Convoy'], '19.442735,-99.201111', '1980/04/10', '2016/09/10', [8.5344, 4300.0], datetime.date(2016, 9, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Leader'), None, 'male'], ['bumbl#ebéé  ', 17.0, 'Espionage', 7.0, 5000000.0, 2.0, ['Bumble', 'Goldback'], '10.642707,-71.612534', '1980/04/10', '2015/08/10', [5.334, 2000.0], datetime.date(2015, 8, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Espionage'), None, '1.1.1.1'], ['ironhide&', 26.0, 'Security', 7.0, 7000000.0, 4.0, ['Roadbuster'], '37.789563,-122.400356', '1980/04/10', '2014/07/10', [7.9248, 4000.0], datetime.date(2014, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Security'), None, 'http://hi-optimus.com'], ['Jazz', 13.0, 'First Lieutenant', 8.0, 5000000.0, 1.8, ['Meister'], '33.670666,-117.841553', '1980/04/10', '2013/06/10', [3.9624, 1800.0], datetime.date(2013, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'First Lieutenant'), None, '5123456789123456'], ['Megatron', '2', 'None', 10.0, 5000000.0, 5.7, ['Megatron'], None, '1980/04/10', '2012/05/10', [None, 5700.0], datetime.date(2012, 5, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'None'), None, '11529'], ['Metroplex_)^$', 300.0, 'Battle Station', 8.0, 5000000.0, nan, ['Metroflex'], None, '1980/04/10', '2011/04/10', [91.44, None], datetime.date(2011, 4, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Battle Station'), None, '3'], ['2', '2', '2', '2', '2', nan, None, None, None, None, None, None, NaT, None, None, None, 'optimus']]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_fill_na_array():
		actual_df =source_df.cols.fill_na('japanese name',['1','2'])
		expected_df = op.create.df({"names":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"height(ft)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"function":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"rank":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"age":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"weight(t)":{"alignment":8,"byteorder":"=","descr":[["","<f8"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"f","name":"float64","ndim":0,"num":12,"str":"<f8"},"japanese name":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last position seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"date arrival":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"last date seen":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"attributes":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"Date Type":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"timestamp":{"alignment":8,"byteorder":"=","descr":[["","<M8[ns]"]],"flags":0,"isalignedstruct":false,"isnative":true,"kind":"M","name":"datetime64[ns]","ndim":0,"num":21,"str":"<M8[ns]"},"Cybertronian":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"function(binary)":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"},"NullType":{"alignment":8,"byteorder":"|","descr":[["","|O"]],"flags":63,"isalignedstruct":false,"isnative":true,"kind":"O","name":"object","ndim":0,"num":17,"str":"|O"}}, {'sample': {'columns': [{'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'rank'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}], 'value': [["Optim'us", -28.0, 'Leader', 10.0, 4000000.0, 4.3, ['Inochi', 'Convoy'], '19.442735,-99.201111', '1980/04/10', '2016/09/10', [8.5344, 4300.0], datetime.date(2016, 9, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Leader'), None], ['bumbl#ebéé  ', 17.0, 'Espionage', 7.0, 5000000.0, 2.0, ['Bumble', 'Goldback'], '10.642707,-71.612534', '1980/04/10', '2015/08/10', [5.334, 2000.0], datetime.date(2015, 8, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Espionage'), None], ['ironhide&', 26.0, 'Security', 7.0, 7000000.0, 4.0, ['Roadbuster'], '37.789563,-122.400356', '1980/04/10', '2014/07/10', [7.9248, 4000.0], datetime.date(2014, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Security'), None], ['Jazz', 13.0, 'First Lieutenant', 8.0, 5000000.0, 1.8, ['Meister'], '33.670666,-117.841553', '1980/04/10', '2013/06/10', [3.9624, 1800.0], datetime.date(2013, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'First Lieutenant'), None], ['Megatron', nan, 'None', 10.0, 5000000.0, 5.7, ['Megatron'], None, '1980/04/10', '2012/05/10', [None, 5700.0], datetime.date(2012, 5, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'None'), None], ['Metroplex_)^$', 300.0, 'Battle Station', 8.0, 5000000.0, nan, ['Metroflex'], None, '1980/04/10', '2011/04/10', [91.44, None], datetime.date(2011, 4, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Battle Station'), None], [None, nan, None, nan, nan, nan, '1', None, None, None, None, None, NaT, None, None, None]]}})
		assert (expected_df.collect() == actual_df.collect())
	def test_cols_frequency(self):
		actual_df =source_df.cols.frequency('rank',4)
		expected_value ={'rank': {'frequency': [{'value': 10.0, 'count': 2}, {'value': 8.0, 'count': 2}, {'value': 7.0, 'count': 2}]}}
		self.assertDictEqual(deep_sort(expected_value),  deep_sort(actual_df))
	def test_cols_frequency_all_columns(self):
		actual_df =source_df.cols.frequency('*',4)
		expected_value ={'names': {'frequency': [{'value': 'ironhide&', 'count': 1}, {'value': 'bumbl#ebéé  ', 'count': 1}, {'value': "Optim'us", 'count': 1}, {'value': 'None', 'count': 1}]}, 'height(ft)': {'frequency': [{'value': 300.0, 'count': 1}, {'value': 26.0, 'count': 1}, {'value': 17.0, 'count': 1}, {'value': 13.0, 'count': 1}]}, 'function': {'frequency': [{'value': 'None', 'count': 2}, {'value': 'Security', 'count': 1}, {'value': 'Leader', 'count': 1}, {'value': 'First Lieutenant', 'count': 1}]}, 'rank': {'frequency': [{'value': 10.0, 'count': 2}, {'value': 8.0, 'count': 2}, {'value': 7.0, 'count': 2}]}, 'age': {'frequency': [{'value': 5000000.0, 'count': 4}, {'value': 7000000.0, 'count': 1}, {'value': 4000000.0, 'count': 1}]}, 'weight(t)': {'frequency': [{'value': 5.7, 'count': 1}, {'value': 4.3, 'count': 1}, {'value': 4.0, 'count': 1}, {'value': 2.0, 'count': 1}]}, 'japanese name': {'frequency': [{'value': "['Roadbuster']", 'count': 1}, {'value': "['Metroflex']", 'count': 1}, {'value': "['Meister']", 'count': 1}, {'value': "['Megatron']", 'count': 1}]}, 'last position seen': {'frequency': [{'value': 'None', 'count': 3}, {'value': '37.789563,-122.400356', 'count': 1}, {'value': '33.670666,-117.841553', 'count': 1}, {'value': '19.442735,-99.201111', 'count': 1}]}, 'date arrival': {'frequency': [{'value': '1980/04/10', 'count': 6}, {'value': 'None', 'count': 1}]}, 'last date seen': {'frequency': [{'value': 'None', 'count': 1}, {'value': '2016/09/10', 'count': 1}, {'value': '2015/08/10', 'count': 1}, {'value': '2014/07/10', 'count': 1}]}, 'attributes': {'frequency': [{'value': '[None, 5700.0]', 'count': 1}, {'value': '[91.44, None]', 'count': 1}, {'value': '[8.5344, 4300.0]', 'count': 1}, {'value': '[7.9248, 4000.0]', 'count': 1}]}, 'Date Type': {'frequency': [{'value': 'None', 'count': 1}, {'value': '2016-09-10', 'count': 1}, {'value': '2015-08-10', 'count': 1}, {'value': '2014-06-24', 'count': 1}]}, 'timestamp': {'frequency': [{'value': '2014-06-24', 'count': 6}, {'value': 'NaT', 'count': 1}]}, 'Cybertronian': {'frequency': [{'value': 'True', 'count': 6}, {'value': 'None', 'count': 1}]}, 'function(binary)': {'frequency': [{'value': "bytearray(b'Security')", 'count': 1}, {'value': "bytearray(b'None')", 'count': 1}, {'value': "bytearray(b'Leader')", 'count': 1}, {'value': "bytearray(b'First Lieutenant')", 'count': 1}]}, 'NullType': {'frequency': [{'value': 'None', 'count': 7}]}, 'Mixed': {'frequency': [{'value': 'optimus', 'count': 1}, {'value': 'male', 'count': 1}, {'value': 'http://hi-optimus.com', 'count': 1}, {'value': '5123456789123456', 'count': 1}]}}
		self.assertDictEqual(deep_sort(expected_value),  deep_sort(actual_df))
	@staticmethod
	def test_cols_hist():
		actual_df =source_df.cols.hist(['height(ft)','rank'],4)
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'height(ft)': {'hist': [{'lower': -28.0, 'upper': 81.33333333333333, 'count': 4}, {'lower': 81.33333333333333, 'upper': 190.66666666666666, 'count': 0}, {'lower': 190.66666666666666, 'upper': 300.0, 'count': 1}]}, 'rank': {'hist': [{'lower': 7.0, 'upper': 8.0, 'count': 2}, {'lower': 8.0, 'upper': 9.0, 'count': 2}, {'lower': 9.0, 'upper': 10.0, 'count': 2}]}})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_hist_all_columns():
		actual_df =source_df.cols.hist('*',4)
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'height(ft)': {'hist': [{'lower': -28.0, 'upper': 81.33333333333333, 'count': 4}, {'lower': 81.33333333333333, 'upper': 190.66666666666666, 'count': 0}, {'lower': 190.66666666666666, 'upper': 300.0, 'count': 1}]}, 'rank': {'hist': [{'lower': 7.0, 'upper': 8.0, 'count': 2}, {'lower': 8.0, 'upper': 9.0, 'count': 2}, {'lower': 9.0, 'upper': 10.0, 'count': 2}]}, 'age': {'hist': [{'lower': 4000000.0, 'upper': 5000000.0, 'count': 1}, {'lower': 5000000.0, 'upper': 6000000.0, 'count': 4}, {'lower': 6000000.0, 'upper': 7000000.0, 'count': 1}]}, 'weight(t)': {'hist': [{'lower': 1.8, 'upper': 3.1, 'count': 2}, {'lower': 3.1, 'upper': 4.4, 'count': 2}, {'lower': 4.4, 'upper': 5.7, 'count': 1}]}})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_impute():
		actual_df =source_df.cols.impute('rank')
		expected_df = op.create.df({'names': 'object', 'height(ft)': 'float64', 'function': 'object', 'rank': 'float64', 'age': 'float64', 'weight(t)': 'float64', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'datetime64[ns]', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object'}, {'sample': {'columns': [{'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'rank'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}, {'title': 'Mixed'}], 'value': [["Optim'us", -28.0, 'Leader', 10.0, 4000000.0, 4.3, ['Inochi', 'Convoy'], '19.442735,-99.201111', '1980/04/10', '2016/09/10', [8.5344, 4300.0], datetime.date(2016, 9, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Leader'), None, 'male'], ['bumbl#ebéé  ', 17.0, 'Espionage', 7.0, 5000000.0, 2.0, ['Bumble', 'Goldback'], '10.642707,-71.612534', '1980/04/10', '2015/08/10', [5.334, 2000.0], datetime.date(2015, 8, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Espionage'), None, '1.1.1.1'], ['ironhide&', 26.0, 'Security', 7.0, 7000000.0, 4.0, ['Roadbuster'], '37.789563,-122.400356', '1980/04/10', '2014/07/10', [7.9248, 4000.0], datetime.date(2014, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Security'), None, 'http://hi-optimus.com'], ['Jazz', 13.0, 'First Lieutenant', 8.0, 5000000.0, 1.8, ['Meister'], '33.670666,-117.841553', '1980/04/10', '2013/06/10', [3.9624, 1800.0], datetime.date(2013, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'First Lieutenant'), None, '5123456789123456'], ['Megatron', nan, 'None', 10.0, 5000000.0, 5.7, ['Megatron'], None, '1980/04/10', '2012/05/10', [None, 5700.0], datetime.date(2012, 5, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'None'), None, '11529'], ['Metroplex_)^$', 300.0, 'Battle Station', 8.0, 5000000.0, nan, ['Metroflex'], None, '1980/04/10', '2011/04/10', [91.44, None], datetime.date(2011, 4, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Battle Station'), None, '3'], [None, nan, None, 8.333333333333334, nan, nan, None, None, None, None, None, None, NaT, None, None, None, 'optimus']]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_iqr():
		actual_df =source_df.cols.iqr(None,'height(ft)')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'height(ft)': {'iqr': 13.0, 'q1': 13.0, 'q2': 17.0, 'q3': 26.0}, 'rank': {'iqr': 2.25, 'q1': 7.25, 'q2': 8.0, 'q3': 9.5}, 'age': {'iqr': 0.0, 'q1': 5000000.0, 'q2': 5000000.0, 'q3': 5000000.0}, 'weight(t)': {'iqr': 2.3, 'q1': 2.0, 'q2': 4.0, 'q3': 4.3}})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_iqr_all_columns():
		actual_df =source_df.cols.iqr('*')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'height(ft)': 13.0, 'rank': 2.25, 'age': 0.0, 'weight(t)': 2.3})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_is_na():
		actual_df =source_df.cols.is_na('height(ft)')
		expected_df = op.create.df({'names': 'object', 'height(ft)': 'bool', 'function': 'object', 'rank': 'float64', 'age': 'float64', 'weight(t)': 'float64', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'datetime64[ns]', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object'}, {'sample': {'columns': [{'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'rank'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}, {'title': 'Mixed'}], 'value': [["Optim'us", False, 'Leader', 10.0, 4000000.0, 4.3, ['Inochi', 'Convoy'], '19.442735,-99.201111', '1980/04/10', '2016/09/10', [8.5344, 4300.0], datetime.date(2016, 9, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Leader'), None, 'male'], ['bumbl#ebéé  ', False, 'Espionage', 7.0, 5000000.0, 2.0, ['Bumble', 'Goldback'], '10.642707,-71.612534', '1980/04/10', '2015/08/10', [5.334, 2000.0], datetime.date(2015, 8, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Espionage'), None, '1.1.1.1'], ['ironhide&', False, 'Security', 7.0, 7000000.0, 4.0, ['Roadbuster'], '37.789563,-122.400356', '1980/04/10', '2014/07/10', [7.9248, 4000.0], datetime.date(2014, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Security'), None, 'http://hi-optimus.com'], ['Jazz', False, 'First Lieutenant', 8.0, 5000000.0, 1.8, ['Meister'], '33.670666,-117.841553', '1980/04/10', '2013/06/10', [3.9624, 1800.0], datetime.date(2013, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'First Lieutenant'), None, '5123456789123456'], ['Megatron', True, 'None', 10.0, 5000000.0, 5.7, ['Megatron'], None, '1980/04/10', '2012/05/10', [None, 5700.0], datetime.date(2012, 5, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'None'), None, '11529'], ['Metroplex_)^$', False, 'Battle Station', 8.0, 5000000.0, nan, ['Metroflex'], None, '1980/04/10', '2011/04/10', [91.44, None], datetime.date(2011, 4, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Battle Station'), None, '3'], [None, True, None, nan, nan, nan, None, None, None, None, None, None, NaT, None, None, None, 'optimus']]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_is_na_all_columns():
		actual_df =source_df.cols.is_na('*')
		expected_df = op.create.df({'names': 'bool', 'height(ft)': 'bool', 'function': 'bool', 'rank': 'bool', 'age': 'bool', 'weight(t)': 'bool', 'japanese name': 'bool', 'last position seen': 'bool', 'date arrival': 'bool', 'last date seen': 'bool', 'attributes': 'bool', 'Date Type': 'bool', 'timestamp': 'bool', 'Cybertronian': 'bool', 'function(binary)': 'bool', 'NullType': 'bool', 'Mixed': 'bool'}, {'sample': {'columns': [{'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'rank'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}, {'title': 'Mixed'}], 'value': [[False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, True, False], [False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, True, False], [False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, True, False], [False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, True, False], [False, True, False, False, False, False, False, True, False, False, False, False, False, False, False, True, False], [False, False, False, False, False, True, False, True, False, False, False, False, False, False, False, True, False], [True, True, True, True, True, True, True, True, True, True, True, True, True, True, True, True, False]]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_keep():
		actual_df =source_df.cols.keep('rank')
		expected_df = op.create.df({'rank': 'float64'}, {'sample': {'columns': [{'title': 'rank'}], 'value': [[10.0], [7.0], [7.0], [8.0], [10.0], [8.0], [nan]]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_kurt():
		actual_df =source_df.cols.kurt('height(ft)')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'kurtosis': {'height(ft)': nan}})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_kurt_all_columns():
		actual_df =source_df.cols.kurt('*')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'kurtosis': {'height(ft)': nan, 'rank': nan, 'age': nan, 'weight(t)': nan}})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_lower():
		actual_df =source_df.cols.lower('function')
		expected_df = op.create.df({'names': 'object', 'height(ft)': 'float64', 'function': 'object', 'rank': 'float64', 'age': 'float64', 'weight(t)': 'float64', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'datetime64[ns]', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object'}, {'sample': {'columns': [{'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'rank'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}, {'title': 'Mixed'}], 'value': [["Optim'us", -28.0, 'leader', 10.0, 4000000.0, 4.3, ['Inochi', 'Convoy'], '19.442735,-99.201111', '1980/04/10', '2016/09/10', [8.5344, 4300.0], datetime.date(2016, 9, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Leader'), None, 'male'], ['bumbl#ebéé  ', 17.0, 'espionage', 7.0, 5000000.0, 2.0, ['Bumble', 'Goldback'], '10.642707,-71.612534', '1980/04/10', '2015/08/10', [5.334, 2000.0], datetime.date(2015, 8, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Espionage'), None, '1.1.1.1'], ['ironhide&', 26.0, 'security', 7.0, 7000000.0, 4.0, ['Roadbuster'], '37.789563,-122.400356', '1980/04/10', '2014/07/10', [7.9248, 4000.0], datetime.date(2014, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Security'), None, 'http://hi-optimus.com'], ['Jazz', 13.0, 'first lieutenant', 8.0, 5000000.0, 1.8, ['Meister'], '33.670666,-117.841553', '1980/04/10', '2013/06/10', [3.9624, 1800.0], datetime.date(2013, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'First Lieutenant'), None, '5123456789123456'], ['Megatron', nan, 'none', 10.0, 5000000.0, 5.7, ['Megatron'], None, '1980/04/10', '2012/05/10', [None, 5700.0], datetime.date(2012, 5, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'None'), None, '11529'], ['Metroplex_)^$', 300.0, 'battle station', 8.0, 5000000.0, nan, ['Metroflex'], None, '1980/04/10', '2011/04/10', [91.44, None], datetime.date(2011, 4, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Battle Station'), None, '3'], [None, nan, 'none', nan, nan, nan, None, None, None, None, None, None, NaT, None, None, None, 'optimus']]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_lower_all_columns():
		actual_df =source_df.cols.lower('*')
		expected_df = op.create.df({'names': 'object', 'height(ft)': 'float64', 'function': 'object', 'rank': 'float64', 'age': 'float64', 'weight(t)': 'float64', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'datetime64[ns]', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object'}, {'sample': {'columns': [{'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'rank'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}, {'title': 'Mixed'}], 'value': [["optim'us", -28.0, 'leader', 10.0, 4000000.0, 4.3, "['inochi', 'convoy']", '19.442735,-99.201111', '1980/04/10', '2016/09/10', '[8.5344, 4300.0]', '2016-09-10', Timestamp('2014-06-24 00:00:00'), 'true', "bytearray(b'leader')", 'none', 'male'], ['bumbl#ebéé  ', 17.0, 'espionage', 7.0, 5000000.0, 2.0, "['bumble', 'goldback']", '10.642707,-71.612534', '1980/04/10', '2015/08/10', '[5.334, 2000.0]', '2015-08-10', Timestamp('2014-06-24 00:00:00'), 'true', "bytearray(b'espionage')", 'none', '1.1.1.1'], ['ironhide&', 26.0, 'security', 7.0, 7000000.0, 4.0, "['roadbuster']", '37.789563,-122.400356', '1980/04/10', '2014/07/10', '[7.9248, 4000.0]', '2014-06-24', Timestamp('2014-06-24 00:00:00'), 'true', "bytearray(b'security')", 'none', 'http://hi-optimus.com'], ['jazz', 13.0, 'first lieutenant', 8.0, 5000000.0, 1.8, "['meister']", '33.670666,-117.841553', '1980/04/10', '2013/06/10', '[3.9624, 1800.0]', '2013-06-24', Timestamp('2014-06-24 00:00:00'), 'true', "bytearray(b'first lieutenant')", 'none', '5123456789123456'], ['megatron', nan, 'none', 10.0, 5000000.0, 5.7, "['megatron']", 'none', '1980/04/10', '2012/05/10', '[none, 5700.0]', '2012-05-10', Timestamp('2014-06-24 00:00:00'), 'true', "bytearray(b'none')", 'none', '11529'], ['metroplex_)^$', 300.0, 'battle station', 8.0, 5000000.0, nan, "['metroflex']", 'none', '1980/04/10', '2011/04/10', '[91.44, none]', '2011-04-10', Timestamp('2014-06-24 00:00:00'), 'true', "bytearray(b'battle station')", 'none', '3'], ['none', nan, 'none', nan, nan, nan, 'none', 'none', 'none', 'none', 'none', 'none', NaT, 'none', 'none', 'none', 'optimus']]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_mad():
		actual_df =source_df.cols.mad('height(ft)')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'mad': {'height(ft)': 9.0}})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_mad_all_columns():
		actual_df =source_df.cols.mad('*')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'mad': {'height(ft)': 9.0, 'rank': 1.0, 'age': 0.0, 'weight(t)': 1.7000000000000002}})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_max():
		actual_df =source_df.cols.max('height(ft)')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'max': {'height(ft)': 300.0}})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_max_all_columns():
		actual_df =source_df.cols.max('*')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'max': {'Cybertronian': True, 'Mixed': 'optimus', 'NullType': nan, 'age': 7000000.0, 'height(ft)': 300.0, 'rank': 10.0, 'timestamp': Timestamp('2014-06-24 00:00:00'), 'weight(t)': 5.7}})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_mean():
		actual_df =source_df.cols.mean('height(ft)')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'mean': {'height(ft)': 65.6}})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_mean_all_columns():
		actual_df =source_df.cols.mean('*')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'mean': {'height(ft)': 65.6, 'rank': 8.333333333333334, 'age': 5166666.666666667, 'weight(t)': 3.56}})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_median():
		actual_df =source_df.cols.median('height(ft)')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'percentile': {'height(ft)': {0.5: 17.0}}})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_median_all_columns():
		actual_df =source_df.cols.median('*')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'percentile': {'height(ft)': {0.5: 17.0}, 'rank': {0.5: 8.0}, 'age': {0.5: 5000000.0}, 'weight(t)': {0.5: 4.0}}})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_min():
		actual_df =source_df.cols.min('height(ft)')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'min': {'height(ft)': -28.0}})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_min_all_columns():
		actual_df =source_df.cols.min('*')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'min': {'Cybertronian': True, 'Mixed': '1.1.1.1', 'NullType': nan, 'age': 4000000.0, 'height(ft)': -28.0, 'rank': 7.0, 'timestamp': Timestamp('2014-06-24 00:00:00'), 'weight(t)': 1.8}})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_mode():
		actual_df =source_df.cols.mode('height(ft)')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'mode': {'height(ft)': ['nan']}})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_mode_all_columns():
		actual_df =source_df.cols.mode('*')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'mode': {'names': ['1.1.1.1', '11529', '3', '5123456789123456', 'http://hi-optimus.com', 'male', 'optimus'], 'height(ft)': ['1.1.1.1', '11529', '3', '5123456789123456', 'http://hi-optimus.com', 'male', 'optimus'], 'function': ['1.1.1.1', '11529', '3', '5123456789123456', 'http://hi-optimus.com', 'male', 'optimus'], 'rank': ['1.1.1.1', '11529', '3', '5123456789123456', 'http://hi-optimus.com', 'male', 'optimus'], 'age': ['1.1.1.1', '11529', '3', '5123456789123456', 'http://hi-optimus.com', 'male', 'optimus'], 'weight(t)': ['1.1.1.1', '11529', '3', '5123456789123456', 'http://hi-optimus.com', 'male', 'optimus'], 'japanese name': ['1.1.1.1', '11529', '3', '5123456789123456', 'http://hi-optimus.com', 'male', 'optimus'], 'last position seen': ['1.1.1.1', '11529', '3', '5123456789123456', 'http://hi-optimus.com', 'male', 'optimus'], 'date arrival': ['1.1.1.1', '11529', '3', '5123456789123456', 'http://hi-optimus.com', 'male', 'optimus'], 'last date seen': ['1.1.1.1', '11529', '3', '5123456789123456', 'http://hi-optimus.com', 'male', 'optimus'], 'attributes': ['1.1.1.1', '11529', '3', '5123456789123456', 'http://hi-optimus.com', 'male', 'optimus'], 'Date Type': ['1.1.1.1', '11529', '3', '5123456789123456', 'http://hi-optimus.com', 'male', 'optimus'], 'timestamp': ['1.1.1.1', '11529', '3', '5123456789123456', 'http://hi-optimus.com', 'male', 'optimus'], 'Cybertronian': ['1.1.1.1', '11529', '3', '5123456789123456', 'http://hi-optimus.com', 'male', 'optimus'], 'function(binary)': ['1.1.1.1', '11529', '3', '5123456789123456', 'http://hi-optimus.com', 'male', 'optimus'], 'NullType': ['1.1.1.1', '11529', '3', '5123456789123456', 'http://hi-optimus.com', 'male', 'optimus'], 'Mixed': ['1.1.1.1', '11529', '3', '5123456789123456', 'http://hi-optimus.com', 'male', 'optimus']}})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_move_after():
		actual_df =source_df.cols.move('rank','after','attributes')
		expected_df = op.create.df({'names': 'object', 'height(ft)': 'float64', 'function': 'object', 'age': 'float64', 'weight(t)': 'float64', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'attributes': 'object', 'rank': 'float64', 'Date Type': 'object', 'timestamp': 'datetime64[ns]', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object'}, {'sample': {'columns': [{'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'rank'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}, {'title': 'Mixed'}], 'value': [["Optim'us", -28.0, 'Leader', 4000000.0, 4.3, ['Inochi', 'Convoy'], '19.442735,-99.201111', '1980/04/10', '2016/09/10', [8.5344, 4300.0], 10.0, datetime.date(2016, 9, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Leader'), None, 'male'], ['bumbl#ebéé  ', 17.0, 'Espionage', 5000000.0, 2.0, ['Bumble', 'Goldback'], '10.642707,-71.612534', '1980/04/10', '2015/08/10', [5.334, 2000.0], 7.0, datetime.date(2015, 8, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Espionage'), None, '1.1.1.1'], ['ironhide&', 26.0, 'Security', 7000000.0, 4.0, ['Roadbuster'], '37.789563,-122.400356', '1980/04/10', '2014/07/10', [7.9248, 4000.0], 7.0, datetime.date(2014, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Security'), None, 'http://hi-optimus.com'], ['Jazz', 13.0, 'First Lieutenant', 5000000.0, 1.8, ['Meister'], '33.670666,-117.841553', '1980/04/10', '2013/06/10', [3.9624, 1800.0], 8.0, datetime.date(2013, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'First Lieutenant'), None, '5123456789123456'], ['Megatron', nan, 'None', 5000000.0, 5.7, ['Megatron'], None, '1980/04/10', '2012/05/10', [None, 5700.0], 10.0, datetime.date(2012, 5, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'None'), None, '11529'], ['Metroplex_)^$', 300.0, 'Battle Station', 5000000.0, nan, ['Metroflex'], None, '1980/04/10', '2011/04/10', [91.44, None], 8.0, datetime.date(2011, 4, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Battle Station'), None, '3'], [None, nan, None, nan, nan, None, None, None, None, None, nan, None, NaT, None, None, None, 'optimus']]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_move_before():
		actual_df =source_df.cols.move('rank','before','attributes')
		expected_df = op.create.df({'names': 'object', 'height(ft)': 'float64', 'function': 'object', 'age': 'float64', 'weight(t)': 'float64', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'rank': 'float64', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'datetime64[ns]', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object'}, {'sample': {'columns': [{'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'rank'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}, {'title': 'Mixed'}], 'value': [["Optim'us", -28.0, 'Leader', 4000000.0, 4.3, ['Inochi', 'Convoy'], '19.442735,-99.201111', '1980/04/10', '2016/09/10', 10.0, [8.5344, 4300.0], datetime.date(2016, 9, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Leader'), None, 'male'], ['bumbl#ebéé  ', 17.0, 'Espionage', 5000000.0, 2.0, ['Bumble', 'Goldback'], '10.642707,-71.612534', '1980/04/10', '2015/08/10', 7.0, [5.334, 2000.0], datetime.date(2015, 8, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Espionage'), None, '1.1.1.1'], ['ironhide&', 26.0, 'Security', 7000000.0, 4.0, ['Roadbuster'], '37.789563,-122.400356', '1980/04/10', '2014/07/10', 7.0, [7.9248, 4000.0], datetime.date(2014, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Security'), None, 'http://hi-optimus.com'], ['Jazz', 13.0, 'First Lieutenant', 5000000.0, 1.8, ['Meister'], '33.670666,-117.841553', '1980/04/10', '2013/06/10', 8.0, [3.9624, 1800.0], datetime.date(2013, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'First Lieutenant'), None, '5123456789123456'], ['Megatron', nan, 'None', 5000000.0, 5.7, ['Megatron'], None, '1980/04/10', '2012/05/10', 10.0, [None, 5700.0], datetime.date(2012, 5, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'None'), None, '11529'], ['Metroplex_)^$', 300.0, 'Battle Station', 5000000.0, nan, ['Metroflex'], None, '1980/04/10', '2011/04/10', 8.0, [91.44, None], datetime.date(2011, 4, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Battle Station'), None, '3'], [None, nan, None, nan, nan, None, None, None, None, nan, None, None, NaT, None, None, None, 'optimus']]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_move_beginning():
		actual_df =source_df.cols.move('rank','beginning')
		expected_df = op.create.df({'rank': 'float64', 'names': 'object', 'height(ft)': 'float64', 'function': 'object', 'age': 'float64', 'weight(t)': 'float64', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'datetime64[ns]', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object'}, {'sample': {'columns': [{'title': 'rank'}, {'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}, {'title': 'Mixed'}], 'value': [[10.0, "Optim'us", -28.0, 'Leader', 4000000.0, 4.3, ['Inochi', 'Convoy'], '19.442735,-99.201111', '1980/04/10', '2016/09/10', [8.5344, 4300.0], datetime.date(2016, 9, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Leader'), None, 'male'], [7.0, 'bumbl#ebéé  ', 17.0, 'Espionage', 5000000.0, 2.0, ['Bumble', 'Goldback'], '10.642707,-71.612534', '1980/04/10', '2015/08/10', [5.334, 2000.0], datetime.date(2015, 8, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Espionage'), None, '1.1.1.1'], [7.0, 'ironhide&', 26.0, 'Security', 7000000.0, 4.0, ['Roadbuster'], '37.789563,-122.400356', '1980/04/10', '2014/07/10', [7.9248, 4000.0], datetime.date(2014, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Security'), None, 'http://hi-optimus.com'], [8.0, 'Jazz', 13.0, 'First Lieutenant', 5000000.0, 1.8, ['Meister'], '33.670666,-117.841553', '1980/04/10', '2013/06/10', [3.9624, 1800.0], datetime.date(2013, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'First Lieutenant'), None, '5123456789123456'], [10.0, 'Megatron', nan, 'None', 5000000.0, 5.7, ['Megatron'], None, '1980/04/10', '2012/05/10', [None, 5700.0], datetime.date(2012, 5, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'None'), None, '11529'], [8.0, 'Metroplex_)^$', 300.0, 'Battle Station', 5000000.0, nan, ['Metroflex'], None, '1980/04/10', '2011/04/10', [91.44, None], datetime.date(2011, 4, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Battle Station'), None, '3'], [nan, None, nan, None, nan, nan, None, None, None, None, None, None, NaT, None, None, None, 'optimus']]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_move_end():
		actual_df =source_df.cols.move('rank','end')
		expected_df = op.create.df({'names': 'object', 'height(ft)': 'float64', 'function': 'object', 'age': 'float64', 'weight(t)': 'float64', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'datetime64[ns]', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object', 'rank': 'float64'}, {'sample': {'columns': [{'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}, {'title': 'Mixed'}, {'title': 'rank'}], 'value': [["Optim'us", -28.0, 'Leader', 4000000.0, 4.3, ['Inochi', 'Convoy'], '19.442735,-99.201111', '1980/04/10', '2016/09/10', [8.5344, 4300.0], datetime.date(2016, 9, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Leader'), None, 'male', 10.0], ['bumbl#ebéé  ', 17.0, 'Espionage', 5000000.0, 2.0, ['Bumble', 'Goldback'], '10.642707,-71.612534', '1980/04/10', '2015/08/10', [5.334, 2000.0], datetime.date(2015, 8, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Espionage'), None, '1.1.1.1', 7.0], ['ironhide&', 26.0, 'Security', 7000000.0, 4.0, ['Roadbuster'], '37.789563,-122.400356', '1980/04/10', '2014/07/10', [7.9248, 4000.0], datetime.date(2014, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Security'), None, 'http://hi-optimus.com', 7.0], ['Jazz', 13.0, 'First Lieutenant', 5000000.0, 1.8, ['Meister'], '33.670666,-117.841553', '1980/04/10', '2013/06/10', [3.9624, 1800.0], datetime.date(2013, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'First Lieutenant'), None, '5123456789123456', 8.0], ['Megatron', nan, 'None', 5000000.0, 5.7, ['Megatron'], None, '1980/04/10', '2012/05/10', [None, 5700.0], datetime.date(2012, 5, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'None'), None, '11529', 10.0], ['Metroplex_)^$', 300.0, 'Battle Station', 5000000.0, nan, ['Metroflex'], None, '1980/04/10', '2011/04/10', [91.44, None], datetime.date(2011, 4, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Battle Station'), None, '3', 8.0], [None, nan, None, nan, nan, None, None, None, None, None, None, NaT, None, None, None, 'optimus', nan]]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_mul():
		actual_df =source_df.cols.mul(['height(ft)','rank'])
		expected_df = op.create.df({'names': 'object', 'height(ft)': 'float64', 'function': 'object', 'rank': 'float64', 'age': 'float64', 'weight(t)': 'float64', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'datetime64[ns]', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object', 'mul': 'float64'}, {'sample': {'columns': [{'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'rank'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}, {'title': 'Mixed'}, {'title': 'mul'}], 'value': [["Optim'us", -28.0, 'Leader', 10.0, 4000000.0, 4.3, ['Inochi', 'Convoy'], '19.442735,-99.201111', '1980/04/10', '2016/09/10', [8.5344, 4300.0], datetime.date(2016, 9, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Leader'), None, 'male', -280.0], ['bumbl#ebéé  ', 17.0, 'Espionage', 7.0, 5000000.0, 2.0, ['Bumble', 'Goldback'], '10.642707,-71.612534', '1980/04/10', '2015/08/10', [5.334, 2000.0], datetime.date(2015, 8, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Espionage'), None, '1.1.1.1', 119.0], ['ironhide&', 26.0, 'Security', 7.0, 7000000.0, 4.0, ['Roadbuster'], '37.789563,-122.400356', '1980/04/10', '2014/07/10', [7.9248, 4000.0], datetime.date(2014, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Security'), None, 'http://hi-optimus.com', 182.0], ['Jazz', 13.0, 'First Lieutenant', 8.0, 5000000.0, 1.8, ['Meister'], '33.670666,-117.841553', '1980/04/10', '2013/06/10', [3.9624, 1800.0], datetime.date(2013, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'First Lieutenant'), None, '5123456789123456', 104.0], ['Megatron', nan, 'None', 10.0, 5000000.0, 5.7, ['Megatron'], None, '1980/04/10', '2012/05/10', [None, 5700.0], datetime.date(2012, 5, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'None'), None, '11529', nan], ['Metroplex_)^$', 300.0, 'Battle Station', 8.0, 5000000.0, nan, ['Metroflex'], None, '1980/04/10', '2011/04/10', [91.44, None], datetime.date(2011, 4, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Battle Station'), None, '3', 2400.0], [None, nan, None, nan, nan, nan, None, None, None, None, None, None, NaT, None, None, None, 'optimus', nan]]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_mul_all_columns():
		actual_df =source_df.cols.mul('*')
		expected_df = op.create.df({'names': 'object', 'height(ft)': 'float64', 'function': 'object', 'rank': 'float64', 'age': 'float64', 'weight(t)': 'float64', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'datetime64[ns]', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object', 'mul': 'float64'}, {'sample': {'columns': [{'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'rank'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}, {'title': 'Mixed'}, {'title': 'mul'}], 'value': [["Optim'us", -28.0, 'Leader', 10.0, 4000000.0, 4.3, ['Inochi', 'Convoy'], '19.442735,-99.201111', '1980/04/10', '2016/09/10', [8.5344, 4300.0], datetime.date(2016, 9, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Leader'), None, 'male', -4816000000.0], ['bumbl#ebéé  ', 17.0, 'Espionage', 7.0, 5000000.0, 2.0, ['Bumble', 'Goldback'], '10.642707,-71.612534', '1980/04/10', '2015/08/10', [5.334, 2000.0], datetime.date(2015, 8, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Espionage'), None, '1.1.1.1', 1190000000.0], ['ironhide&', 26.0, 'Security', 7.0, 7000000.0, 4.0, ['Roadbuster'], '37.789563,-122.400356', '1980/04/10', '2014/07/10', [7.9248, 4000.0], datetime.date(2014, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Security'), None, 'http://hi-optimus.com', 5096000000.0], ['Jazz', 13.0, 'First Lieutenant', 8.0, 5000000.0, 1.8, ['Meister'], '33.670666,-117.841553', '1980/04/10', '2013/06/10', [3.9624, 1800.0], datetime.date(2013, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'First Lieutenant'), None, '5123456789123456', 936000000.0], ['Megatron', nan, 'None', 10.0, 5000000.0, 5.7, ['Megatron'], None, '1980/04/10', '2012/05/10', [None, 5700.0], datetime.date(2012, 5, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'None'), None, '11529', nan], ['Metroplex_)^$', 300.0, 'Battle Station', 8.0, 5000000.0, nan, ['Metroflex'], None, '1980/04/10', '2011/04/10', [91.44, None], datetime.date(2011, 4, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Battle Station'), None, '3', nan], [None, nan, None, nan, nan, nan, None, None, None, None, None, None, NaT, None, None, None, 'optimus', nan]]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_names():
		actual_df =source_df.cols.names()
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding(['names', 'height(ft)', 'function', 'rank', 'age', 'weight(t)', 'japanese name', 'last position seen', 'date arrival', 'last date seen', 'attributes', 'Date Type', 'timestamp', 'Cybertronian', 'function(binary)', 'NullType', 'Mixed'])
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_nest():
		actual_df =source_df.cols.nest(['height(ft)','rank'],separator=' ',output_col='new col')
		expected_df = op.create.df({'names': 'object', 'height(ft)': 'float64', 'function': 'object', 'rank': 'float64', 'new col': 'object', 'age': 'float64', 'weight(t)': 'float64', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'datetime64[ns]', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object'}, {'sample': {'columns': [{'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'rank'}, {'title': 'new col'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}, {'title': 'Mixed'}], 'value': [["Optim'us", -28.0, 'Leader', 10.0, '-28.0 10.0', 4000000.0, 4.3, ['Inochi', 'Convoy'], '19.442735,-99.201111', '1980/04/10', '2016/09/10', [8.5344, 4300.0], datetime.date(2016, 9, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Leader'), None, 'male'], ['bumbl#ebéé  ', 17.0, 'Espionage', 7.0, '17.0 7.0', 5000000.0, 2.0, ['Bumble', 'Goldback'], '10.642707,-71.612534', '1980/04/10', '2015/08/10', [5.334, 2000.0], datetime.date(2015, 8, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Espionage'), None, '1.1.1.1'], ['ironhide&', 26.0, 'Security', 7.0, '26.0 7.0', 7000000.0, 4.0, ['Roadbuster'], '37.789563,-122.400356', '1980/04/10', '2014/07/10', [7.9248, 4000.0], datetime.date(2014, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Security'), None, 'http://hi-optimus.com'], ['Jazz', 13.0, 'First Lieutenant', 8.0, '13.0 8.0', 5000000.0, 1.8, ['Meister'], '33.670666,-117.841553', '1980/04/10', '2013/06/10', [3.9624, 1800.0], datetime.date(2013, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'First Lieutenant'), None, '5123456789123456'], ['Megatron', nan, 'None', 10.0, 'nan 10.0', 5000000.0, 5.7, ['Megatron'], None, '1980/04/10', '2012/05/10', [None, 5700.0], datetime.date(2012, 5, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'None'), None, '11529'], ['Metroplex_)^$', 300.0, 'Battle Station', 8.0, '300.0 8.0', 5000000.0, nan, ['Metroflex'], None, '1980/04/10', '2011/04/10', [91.44, None], datetime.date(2011, 4, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Battle Station'), None, '3'], [None, nan, None, nan, 'nan nan', nan, nan, None, None, None, None, None, None, NaT, None, None, None, 'optimus']]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_nest_array():
		actual_df =source_df.cols.nest(['height(ft)','rank','rank'],shape='array',output_col='new col')
		expected_df = op.create.df({'names': 'object', 'height(ft)': 'float64', 'function': 'object', 'rank': 'float64', 'new col': 'object', 'age': 'float64', 'weight(t)': 'float64', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'datetime64[ns]', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object'}, {'sample': {'columns': [{'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'rank'}, {'title': 'new col'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}, {'title': 'Mixed'}], 'value': [["Optim'us", -28.0, 'Leader', 10.0, '[-28.0, 10.0, 10.0]', 4000000.0, 4.3, ['Inochi', 'Convoy'], '19.442735,-99.201111', '1980/04/10', '2016/09/10', [8.5344, 4300.0], datetime.date(2016, 9, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Leader'), None, 'male'], ['bumbl#ebéé  ', 17.0, 'Espionage', 7.0, '[17.0, 7.0, 7.0]', 5000000.0, 2.0, ['Bumble', 'Goldback'], '10.642707,-71.612534', '1980/04/10', '2015/08/10', [5.334, 2000.0], datetime.date(2015, 8, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Espionage'), None, '1.1.1.1'], ['ironhide&', 26.0, 'Security', 7.0, '[26.0, 7.0, 7.0]', 7000000.0, 4.0, ['Roadbuster'], '37.789563,-122.400356', '1980/04/10', '2014/07/10', [7.9248, 4000.0], datetime.date(2014, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Security'), None, 'http://hi-optimus.com'], ['Jazz', 13.0, 'First Lieutenant', 8.0, '[13.0, 8.0, 8.0]', 5000000.0, 1.8, ['Meister'], '33.670666,-117.841553', '1980/04/10', '2013/06/10', [3.9624, 1800.0], datetime.date(2013, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'First Lieutenant'), None, '5123456789123456'], ['Megatron', nan, 'None', 10.0, '[nan, 10.0, 10.0]', 5000000.0, 5.7, ['Megatron'], None, '1980/04/10', '2012/05/10', [None, 5700.0], datetime.date(2012, 5, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'None'), None, '11529'], ['Metroplex_)^$', 300.0, 'Battle Station', 8.0, '[300.0, 8.0, 8.0]', 5000000.0, nan, ['Metroflex'], None, '1980/04/10', '2011/04/10', [91.44, None], datetime.date(2011, 4, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Battle Station'), None, '3'], [None, nan, None, nan, '[nan, nan, nan]', nan, nan, None, None, None, None, None, None, NaT, None, None, None, 'optimus']]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_nest_vector():
		actual_df =df_na.cols.nest(['rank','rank'],shape='vector',output_col='new col')
		expected_df = op.create.df({'names': 'object', 'height(ft)': 'float64', 'function': 'object', 'rank': 'float64', 'new col': 'object', 'age': 'float64', 'weight(t)': 'float64', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'datetime64[ns]', 'Cybertronian': 'object', 'function(binary)': 'object', 'Mixed': 'object'}, {'sample': {'columns': [{'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'rank'}, {'title': 'new col'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'Mixed'}], 'value': [["Optim'us", -28.0, 'Leader', 10.0, '[10.0, 10.0]', 4000000.0, 4.3, ['Inochi', 'Convoy'], '19.442735,-99.201111', '1980/04/10', '2016/09/10', [8.5344, 4300.0], datetime.date(2016, 9, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Leader'), 'male'], ['bumbl#ebéé  ', 17.0, 'Espionage', 7.0, '[7.0, 7.0]', 5000000.0, 2.0, ['Bumble', 'Goldback'], '10.642707,-71.612534', '1980/04/10', '2015/08/10', [5.334, 2000.0], datetime.date(2015, 8, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Espionage'), '1.1.1.1'], ['ironhide&', 26.0, 'Security', 7.0, '[7.0, 7.0]', 7000000.0, 4.0, ['Roadbuster'], '37.789563,-122.400356', '1980/04/10', '2014/07/10', [7.9248, 4000.0], datetime.date(2014, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Security'), 'http://hi-optimus.com'], ['Jazz', 13.0, 'First Lieutenant', 8.0, '[8.0, 8.0]', 5000000.0, 1.8, ['Meister'], '33.670666,-117.841553', '1980/04/10', '2013/06/10', [3.9624, 1800.0], datetime.date(2013, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'First Lieutenant'), '5123456789123456']]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_nest_vector_all_columns():
		actual_df =df_na.cols.nest(['rank','rank'],shape='vector',output_col='new col')
		expected_df = op.create.df({'names': 'object', 'height(ft)': 'float64', 'function': 'object', 'rank': 'float64', 'new col': 'object', 'age': 'float64', 'weight(t)': 'float64', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'datetime64[ns]', 'Cybertronian': 'object', 'function(binary)': 'object', 'Mixed': 'object'}, {'sample': {'columns': [{'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'rank'}, {'title': 'new col'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'Mixed'}], 'value': [["Optim'us", -28.0, 'Leader', 10.0, '[10.0, 10.0]', 4000000.0, 4.3, ['Inochi', 'Convoy'], '19.442735,-99.201111', '1980/04/10', '2016/09/10', [8.5344, 4300.0], datetime.date(2016, 9, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Leader'), 'male'], ['bumbl#ebéé  ', 17.0, 'Espionage', 7.0, '[7.0, 7.0]', 5000000.0, 2.0, ['Bumble', 'Goldback'], '10.642707,-71.612534', '1980/04/10', '2015/08/10', [5.334, 2000.0], datetime.date(2015, 8, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Espionage'), '1.1.1.1'], ['ironhide&', 26.0, 'Security', 7.0, '[7.0, 7.0]', 7000000.0, 4.0, ['Roadbuster'], '37.789563,-122.400356', '1980/04/10', '2014/07/10', [7.9248, 4000.0], datetime.date(2014, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Security'), 'http://hi-optimus.com'], ['Jazz', 13.0, 'First Lieutenant', 8.0, '[8.0, 8.0]', 5000000.0, 1.8, ['Meister'], '33.670666,-117.841553', '1980/04/10', '2013/06/10', [3.9624, 1800.0], datetime.date(2013, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'First Lieutenant'), '5123456789123456']]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_percentile():
		actual_df =source_df.cols.percentile('height(ft)',[0.05,0.25],1)
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'percentile': {'height(ft)': {0.05: -19.8, 0.25: 13.0}}})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_percentile_all_columns():
		actual_df =source_df.cols.percentile('*',[0.05,0.25],1)
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'percentile': {'height(ft)': {0.05: -19.8, 0.25: 13.0}, 'rank': {0.05: 7.0, 0.25: 7.25}, 'age': {0.05: 4250000.0, 0.25: 5000000.0}, 'weight(t)': {0.05: 1.8400000000000003, 0.25: 2.0}}})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_range():
		actual_df =source_df.cols.range('height(ft)')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'height(ft)': {'min': -28.0, 'max': 300.0}})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_range_all_columns():
		actual_df =source_df.cols.range('*')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'Cybertronian': {'min': True, 'max': True}, 'Mixed': {'min': '1.1.1.1', 'max': 'optimus'}, 'NullType': {'min': nan, 'max': nan}, 'age': {'min': 4000000.0, 'max': 7000000.0}, 'height(ft)': {'min': -28.0, 'max': 300.0}, 'rank': {'min': 7.0, 'max': 10.0}, 'timestamp': {'min': Timestamp('2014-06-24 00:00:00'), 'max': Timestamp('2014-06-24 00:00:00')}, 'weight(t)': {'min': 1.8, 'max': 5.7}})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_remove():
		actual_df =source_df.cols.remove('function','i')
		expected_df = op.create.df({'names': 'object', 'height(ft)': 'float64', 'function': 'object', 'rank': 'float64', 'age': 'float64', 'weight(t)': 'float64', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'datetime64[ns]', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object'}, {'sample': {'columns': [{'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'rank'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}, {'title': 'Mixed'}], 'value': [["Optim'us", -28.0, 'Leader', 10.0, 4000000.0, 4.3, ['Inochi', 'Convoy'], '19.442735,-99.201111', '1980/04/10', '2016/09/10', [8.5344, 4300.0], datetime.date(2016, 9, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Leader'), None, 'male'], ['bumbl#ebéé  ', 17.0, 'Esponage', 7.0, 5000000.0, 2.0, ['Bumble', 'Goldback'], '10.642707,-71.612534', '1980/04/10', '2015/08/10', [5.334, 2000.0], datetime.date(2015, 8, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Espionage'), None, '1.1.1.1'], ['ironhide&', 26.0, 'Securty', 7.0, 7000000.0, 4.0, ['Roadbuster'], '37.789563,-122.400356', '1980/04/10', '2014/07/10', [7.9248, 4000.0], datetime.date(2014, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Security'), None, 'http://hi-optimus.com'], ['Jazz', 13.0, 'Frst Leutenant', 8.0, 5000000.0, 1.8, ['Meister'], '33.670666,-117.841553', '1980/04/10', '2013/06/10', [3.9624, 1800.0], datetime.date(2013, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'First Lieutenant'), None, '5123456789123456'], ['Megatron', nan, 'None', 10.0, 5000000.0, 5.7, ['Megatron'], None, '1980/04/10', '2012/05/10', [None, 5700.0], datetime.date(2012, 5, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'None'), None, '11529'], ['Metroplex_)^$', 300.0, 'Battle Staton', 8.0, 5000000.0, nan, ['Metroflex'], None, '1980/04/10', '2011/04/10', [91.44, None], datetime.date(2011, 4, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Battle Station'), None, '3'], [None, nan, 'None', nan, nan, nan, None, None, None, None, None, None, NaT, None, None, None, 'optimus']]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_remove_accents():
		actual_df =source_df.cols.remove_accents('function')
		expected_df = op.create.df({'names': 'object', 'height(ft)': 'float64', 'function': 'object', 'rank': 'float64', 'age': 'float64', 'weight(t)': 'float64', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'datetime64[ns]', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object'}, {'sample': {'columns': [{'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'rank'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}, {'title': 'Mixed'}], 'value': [["Optim'us", -28.0, 'Leader', 10.0, 4000000.0, 4.3, ['Inochi', 'Convoy'], '19.442735,-99.201111', '1980/04/10', '2016/09/10', [8.5344, 4300.0], datetime.date(2016, 9, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Leader'), None, 'male'], ['bumbl#ebéé  ', 17.0, 'Espionage', 7.0, 5000000.0, 2.0, ['Bumble', 'Goldback'], '10.642707,-71.612534', '1980/04/10', '2015/08/10', [5.334, 2000.0], datetime.date(2015, 8, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Espionage'), None, '1.1.1.1'], ['ironhide&', 26.0, 'Security', 7.0, 7000000.0, 4.0, ['Roadbuster'], '37.789563,-122.400356', '1980/04/10', '2014/07/10', [7.9248, 4000.0], datetime.date(2014, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Security'), None, 'http://hi-optimus.com'], ['Jazz', 13.0, 'First Lieutenant', 8.0, 5000000.0, 1.8, ['Meister'], '33.670666,-117.841553', '1980/04/10', '2013/06/10', [3.9624, 1800.0], datetime.date(2013, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'First Lieutenant'), None, '5123456789123456'], ['Megatron', nan, 'None', 10.0, 5000000.0, 5.7, ['Megatron'], None, '1980/04/10', '2012/05/10', [None, 5700.0], datetime.date(2012, 5, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'None'), None, '11529'], ['Metroplex_)^$', 300.0, 'Battle Station', 8.0, 5000000.0, nan, ['Metroflex'], None, '1980/04/10', '2011/04/10', [91.44, None], datetime.date(2011, 4, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Battle Station'), None, '3'], [None, nan, None, nan, nan, nan, None, None, None, None, None, None, NaT, None, None, None, 'optimus']]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_remove_accents_all_columns():
		actual_df =source_df.cols.remove_accents('function')
		expected_df = op.create.df({'names': 'object', 'height(ft)': 'float64', 'function': 'object', 'rank': 'float64', 'age': 'float64', 'weight(t)': 'float64', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'datetime64[ns]', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object'}, {'sample': {'columns': [{'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'rank'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}, {'title': 'Mixed'}], 'value': [["Optim'us", -28.0, 'Leader', 10.0, 4000000.0, 4.3, ['Inochi', 'Convoy'], '19.442735,-99.201111', '1980/04/10', '2016/09/10', [8.5344, 4300.0], datetime.date(2016, 9, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Leader'), None, 'male'], ['bumbl#ebéé  ', 17.0, 'Espionage', 7.0, 5000000.0, 2.0, ['Bumble', 'Goldback'], '10.642707,-71.612534', '1980/04/10', '2015/08/10', [5.334, 2000.0], datetime.date(2015, 8, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Espionage'), None, '1.1.1.1'], ['ironhide&', 26.0, 'Security', 7.0, 7000000.0, 4.0, ['Roadbuster'], '37.789563,-122.400356', '1980/04/10', '2014/07/10', [7.9248, 4000.0], datetime.date(2014, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Security'), None, 'http://hi-optimus.com'], ['Jazz', 13.0, 'First Lieutenant', 8.0, 5000000.0, 1.8, ['Meister'], '33.670666,-117.841553', '1980/04/10', '2013/06/10', [3.9624, 1800.0], datetime.date(2013, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'First Lieutenant'), None, '5123456789123456'], ['Megatron', nan, 'None', 10.0, 5000000.0, 5.7, ['Megatron'], None, '1980/04/10', '2012/05/10', [None, 5700.0], datetime.date(2012, 5, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'None'), None, '11529'], ['Metroplex_)^$', 300.0, 'Battle Station', 8.0, 5000000.0, nan, ['Metroflex'], None, '1980/04/10', '2011/04/10', [91.44, None], datetime.date(2011, 4, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Battle Station'), None, '3'], [None, nan, None, nan, nan, nan, None, None, None, None, None, None, NaT, None, None, None, 'optimus']]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_remove_list():
		actual_df =source_df.cols.remove('function',['a','i','Es'])
		expected_df = op.create.df({'names': 'object', 'height(ft)': 'float64', 'function': 'object', 'rank': 'float64', 'age': 'float64', 'weight(t)': 'float64', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'datetime64[ns]', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object'}, {'sample': {'columns': [{'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'rank'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}, {'title': 'Mixed'}], 'value': [["Optim'us", -28.0, 'Leder', 10.0, 4000000.0, 4.3, ['Inochi', 'Convoy'], '19.442735,-99.201111', '1980/04/10', '2016/09/10', [8.5344, 4300.0], datetime.date(2016, 9, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Leader'), None, 'male'], ['bumbl#ebéé  ', 17.0, 'ponge', 7.0, 5000000.0, 2.0, ['Bumble', 'Goldback'], '10.642707,-71.612534', '1980/04/10', '2015/08/10', [5.334, 2000.0], datetime.date(2015, 8, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Espionage'), None, '1.1.1.1'], ['ironhide&', 26.0, 'Securty', 7.0, 7000000.0, 4.0, ['Roadbuster'], '37.789563,-122.400356', '1980/04/10', '2014/07/10', [7.9248, 4000.0], datetime.date(2014, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Security'), None, 'http://hi-optimus.com'], ['Jazz', 13.0, 'Frst Leutennt', 8.0, 5000000.0, 1.8, ['Meister'], '33.670666,-117.841553', '1980/04/10', '2013/06/10', [3.9624, 1800.0], datetime.date(2013, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'First Lieutenant'), None, '5123456789123456'], ['Megatron', nan, 'None', 10.0, 5000000.0, 5.7, ['Megatron'], None, '1980/04/10', '2012/05/10', [None, 5700.0], datetime.date(2012, 5, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'None'), None, '11529'], ['Metroplex_)^$', 300.0, 'Bttle Stton', 8.0, 5000000.0, nan, ['Metroflex'], None, '1980/04/10', '2011/04/10', [91.44, None], datetime.date(2011, 4, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Battle Station'), None, '3'], [None, nan, 'None', nan, nan, nan, None, None, None, None, None, None, NaT, None, None, None, 'optimus']]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_remove_list_output():
		actual_df =source_df.cols.remove('function',['a','i','Es'],output_cols='function_new')
		expected_df = op.create.df({'names': 'object', 'height(ft)': 'float64', 'function': 'object', 'function_new': 'object', 'rank': 'float64', 'age': 'float64', 'weight(t)': 'float64', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'datetime64[ns]', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object'}, {'sample': {'columns': [{'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'function_new'}, {'title': 'rank'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}, {'title': 'Mixed'}], 'value': [["Optim'us", -28.0, 'Leader', 'Leder', 10.0, 4000000.0, 4.3, ['Inochi', 'Convoy'], '19.442735,-99.201111', '1980/04/10', '2016/09/10', [8.5344, 4300.0], datetime.date(2016, 9, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Leader'), None, 'male'], ['bumbl#ebéé  ', 17.0, 'Espionage', 'ponge', 7.0, 5000000.0, 2.0, ['Bumble', 'Goldback'], '10.642707,-71.612534', '1980/04/10', '2015/08/10', [5.334, 2000.0], datetime.date(2015, 8, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Espionage'), None, '1.1.1.1'], ['ironhide&', 26.0, 'Security', 'Securty', 7.0, 7000000.0, 4.0, ['Roadbuster'], '37.789563,-122.400356', '1980/04/10', '2014/07/10', [7.9248, 4000.0], datetime.date(2014, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Security'), None, 'http://hi-optimus.com'], ['Jazz', 13.0, 'First Lieutenant', 'Frst Leutennt', 8.0, 5000000.0, 1.8, ['Meister'], '33.670666,-117.841553', '1980/04/10', '2013/06/10', [3.9624, 1800.0], datetime.date(2013, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'First Lieutenant'), None, '5123456789123456'], ['Megatron', nan, 'None', 'None', 10.0, 5000000.0, 5.7, ['Megatron'], None, '1980/04/10', '2012/05/10', [None, 5700.0], datetime.date(2012, 5, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'None'), None, '11529'], ['Metroplex_)^$', 300.0, 'Battle Station', 'Bttle Stton', 8.0, 5000000.0, nan, ['Metroflex'], None, '1980/04/10', '2011/04/10', [91.44, None], datetime.date(2011, 4, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Battle Station'), None, '3'], [None, nan, None, 'None', nan, nan, nan, None, None, None, None, None, None, NaT, None, None, None, 'optimus']]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_remove_numbers():
		actual_df =source_df.cols.remove_numbers('function')
		expected_df = op.create.df({'names': 'object', 'height(ft)': 'float64', 'function': 'object', 'rank': 'float64', 'age': 'float64', 'weight(t)': 'float64', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'datetime64[ns]', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object'}, {'sample': {'columns': [{'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'rank'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}, {'title': 'Mixed'}], 'value': [["Optim'us", -28.0, 'Leader', 10.0, 4000000.0, 4.3, ['Inochi', 'Convoy'], '19.442735,-99.201111', '1980/04/10', '2016/09/10', [8.5344, 4300.0], datetime.date(2016, 9, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Leader'), None, 'male'], ['bumbl#ebéé  ', 17.0, 'Espionage', 7.0, 5000000.0, 2.0, ['Bumble', 'Goldback'], '10.642707,-71.612534', '1980/04/10', '2015/08/10', [5.334, 2000.0], datetime.date(2015, 8, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Espionage'), None, '1.1.1.1'], ['ironhide&', 26.0, 'Security', 7.0, 7000000.0, 4.0, ['Roadbuster'], '37.789563,-122.400356', '1980/04/10', '2014/07/10', [7.9248, 4000.0], datetime.date(2014, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Security'), None, 'http://hi-optimus.com'], ['Jazz', 13.0, 'First Lieutenant', 8.0, 5000000.0, 1.8, ['Meister'], '33.670666,-117.841553', '1980/04/10', '2013/06/10', [3.9624, 1800.0], datetime.date(2013, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'First Lieutenant'), None, '5123456789123456'], ['Megatron', nan, 'None', 10.0, 5000000.0, 5.7, ['Megatron'], None, '1980/04/10', '2012/05/10', [None, 5700.0], datetime.date(2012, 5, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'None'), None, '11529'], ['Metroplex_)^$', 300.0, 'Battle Station', 8.0, 5000000.0, nan, ['Metroflex'], None, '1980/04/10', '2011/04/10', [91.44, None], datetime.date(2011, 4, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Battle Station'), None, '3'], [None, nan, 'None', nan, nan, nan, None, None, None, None, None, None, NaT, None, None, None, 'optimus']]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_remove_special_chars():
		actual_df =source_df.cols.remove_special_chars('function')
		expected_df = op.create.df({'names': 'object', 'height(ft)': 'float64', 'function': 'object', 'rank': 'float64', 'age': 'float64', 'weight(t)': 'float64', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'datetime64[ns]', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object'}, {'sample': {'columns': [{'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'rank'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}, {'title': 'Mixed'}], 'value': [["Optim'us", -28.0, 'Leader', 10.0, 4000000.0, 4.3, ['Inochi', 'Convoy'], '19.442735,-99.201111', '1980/04/10', '2016/09/10', [8.5344, 4300.0], datetime.date(2016, 9, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Leader'), None, 'male'], ['bumbl#ebéé  ', 17.0, 'Espionage', 7.0, 5000000.0, 2.0, ['Bumble', 'Goldback'], '10.642707,-71.612534', '1980/04/10', '2015/08/10', [5.334, 2000.0], datetime.date(2015, 8, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Espionage'), None, '1.1.1.1'], ['ironhide&', 26.0, 'Security', 7.0, 7000000.0, 4.0, ['Roadbuster'], '37.789563,-122.400356', '1980/04/10', '2014/07/10', [7.9248, 4000.0], datetime.date(2014, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Security'), None, 'http://hi-optimus.com'], ['Jazz', 13.0, 'FirstLieutenant', 8.0, 5000000.0, 1.8, ['Meister'], '33.670666,-117.841553', '1980/04/10', '2013/06/10', [3.9624, 1800.0], datetime.date(2013, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'First Lieutenant'), None, '5123456789123456'], ['Megatron', nan, 'None', 10.0, 5000000.0, 5.7, ['Megatron'], None, '1980/04/10', '2012/05/10', [None, 5700.0], datetime.date(2012, 5, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'None'), None, '11529'], ['Metroplex_)^$', 300.0, 'BattleStation', 8.0, 5000000.0, nan, ['Metroflex'], None, '1980/04/10', '2011/04/10', [91.44, None], datetime.date(2011, 4, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Battle Station'), None, '3'], [None, nan, 'None', nan, nan, nan, None, None, None, None, None, None, NaT, None, None, None, 'optimus']]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_remove_special_chars_all_columns():
		actual_df =source_df.cols.remove_special_chars('*')
		expected_df = op.create.df({'names': 'object', 'height(ft)': 'float64', 'function': 'object', 'rank': 'float64', 'age': 'float64', 'weight(t)': 'float64', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'datetime64[ns]', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object'}, {'sample': {'columns': [{'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'rank'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}, {'title': 'Mixed'}], 'value': [['Optimus', -28.0, 'Leader', 10.0, 4000000.0, 4.3, 'InochiConvoy', '1944273599201111', '19800410', '20160910', '8534443000', '20160910', Timestamp('2014-06-24 00:00:00'), 'True', 'bytearraybLeader', 'None', 'male'], ['bumbleb', 17.0, 'Espionage', 7.0, 5000000.0, 2.0, 'BumbleGoldback', '1064270771612534', '19800410', '20150810', '533420000', '20150810', Timestamp('2014-06-24 00:00:00'), 'True', 'bytearraybEspionage', 'None', '1111'], ['ironhide', 26.0, 'Security', 7.0, 7000000.0, 4.0, 'Roadbuster', '37789563122400356', '19800410', '20140710', '7924840000', '20140624', Timestamp('2014-06-24 00:00:00'), 'True', 'bytearraybSecurity', 'None', 'httphioptimuscom'], ['Jazz', 13.0, 'FirstLieutenant', 8.0, 5000000.0, 1.8, 'Meister', '33670666117841553', '19800410', '20130610', '3962418000', '20130624', Timestamp('2014-06-24 00:00:00'), 'True', 'bytearraybFirstLieutenant', 'None', '5123456789123456'], ['Megatron', nan, 'None', 10.0, 5000000.0, 5.7, 'Megatron', 'None', '19800410', '20120510', 'None57000', '20120510', Timestamp('2014-06-24 00:00:00'), 'True', 'bytearraybNone', 'None', '11529'], ['Metroplex', 300.0, 'BattleStation', 8.0, 5000000.0, nan, 'Metroflex', 'None', '19800410', '20110410', '9144None', '20110410', Timestamp('2014-06-24 00:00:00'), 'True', 'bytearraybBattleStation', 'None', '3'], ['None', nan, 'None', nan, nan, nan, 'None', 'None', 'None', 'None', 'None', 'None', NaT, 'None', 'None', 'None', 'optimus']]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_remove_white_spaces():
		actual_df =source_df.cols.remove_white_spaces('function')
		expected_df = op.create.df({'names': 'object', 'height(ft)': 'float64', 'function': 'object', 'rank': 'float64', 'age': 'float64', 'weight(t)': 'float64', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'datetime64[ns]', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object'}, {'sample': {'columns': [{'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'rank'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}, {'title': 'Mixed'}], 'value': [["Optim'us", -28.0, 'Leader', 10.0, 4000000.0, 4.3, ['Inochi', 'Convoy'], '19.442735,-99.201111', '1980/04/10', '2016/09/10', [8.5344, 4300.0], datetime.date(2016, 9, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Leader'), None, 'male'], ['bumbl#ebéé  ', 17.0, 'Espionage', 7.0, 5000000.0, 2.0, ['Bumble', 'Goldback'], '10.642707,-71.612534', '1980/04/10', '2015/08/10', [5.334, 2000.0], datetime.date(2015, 8, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Espionage'), None, '1.1.1.1'], ['ironhide&', 26.0, 'Security', 7.0, 7000000.0, 4.0, ['Roadbuster'], '37.789563,-122.400356', '1980/04/10', '2014/07/10', [7.9248, 4000.0], datetime.date(2014, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Security'), None, 'http://hi-optimus.com'], ['Jazz', 13.0, 'FirstLieutenant', 8.0, 5000000.0, 1.8, ['Meister'], '33.670666,-117.841553', '1980/04/10', '2013/06/10', [3.9624, 1800.0], datetime.date(2013, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'First Lieutenant'), None, '5123456789123456'], ['Megatron', nan, 'None', 10.0, 5000000.0, 5.7, ['Megatron'], None, '1980/04/10', '2012/05/10', [None, 5700.0], datetime.date(2012, 5, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'None'), None, '11529'], ['Metroplex_)^$', 300.0, 'BattleStation', 8.0, 5000000.0, nan, ['Metroflex'], None, '1980/04/10', '2011/04/10', [91.44, None], datetime.date(2011, 4, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Battle Station'), None, '3'], [None, nan, 'None', nan, nan, nan, None, None, None, None, None, None, NaT, None, None, None, 'optimus']]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_remove_white_spaces_all_columns():
		actual_df =source_df.cols.remove_white_spaces('*')
		expected_df = op.create.df({'names': 'object', 'height(ft)': 'float64', 'function': 'object', 'rank': 'float64', 'age': 'float64', 'weight(t)': 'float64', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'datetime64[ns]', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object'}, {'sample': {'columns': [{'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'rank'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}, {'title': 'Mixed'}], 'value': [["Optim'us", -28.0, 'Leader', 10.0, 4000000.0, 4.3, "['Inochi','Convoy']", '19.442735,-99.201111', '1980/04/10', '2016/09/10', '[8.5344,4300.0]', '2016-09-10', Timestamp('2014-06-24 00:00:00'), 'True', "bytearray(b'Leader')", 'None', 'male'], ['bumbl#ebéé', 17.0, 'Espionage', 7.0, 5000000.0, 2.0, "['Bumble','Goldback']", '10.642707,-71.612534', '1980/04/10', '2015/08/10', '[5.334,2000.0]', '2015-08-10', Timestamp('2014-06-24 00:00:00'), 'True', "bytearray(b'Espionage')", 'None', '1.1.1.1'], ['ironhide&', 26.0, 'Security', 7.0, 7000000.0, 4.0, "['Roadbuster']", '37.789563,-122.400356', '1980/04/10', '2014/07/10', '[7.9248,4000.0]', '2014-06-24', Timestamp('2014-06-24 00:00:00'), 'True', "bytearray(b'Security')", 'None', 'http://hi-optimus.com'], ['Jazz', 13.0, 'FirstLieutenant', 8.0, 5000000.0, 1.8, "['Meister']", '33.670666,-117.841553', '1980/04/10', '2013/06/10', '[3.9624,1800.0]', '2013-06-24', Timestamp('2014-06-24 00:00:00'), 'True', "bytearray(b'FirstLieutenant')", 'None', '5123456789123456'], ['Megatron', nan, 'None', 10.0, 5000000.0, 5.7, "['Megatron']", 'None', '1980/04/10', '2012/05/10', '[None,5700.0]', '2012-05-10', Timestamp('2014-06-24 00:00:00'), 'True', "bytearray(b'None')", 'None', '11529'], ['Metroplex_)^$', 300.0, 'BattleStation', 8.0, 5000000.0, nan, "['Metroflex']", 'None', '1980/04/10', '2011/04/10', '[91.44,None]', '2011-04-10', Timestamp('2014-06-24 00:00:00'), 'True', "bytearray(b'BattleStation')", 'None', '3'], ['None', nan, 'None', nan, nan, nan, 'None', 'None', 'None', 'None', 'None', 'None', NaT, 'None', 'None', 'None', 'optimus']]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_rename():
		actual_df =source_df.cols.rename('rank','rank(old)')
		expected_df = op.create.df({'names': 'object', 'height(ft)': 'float64', 'function': 'object', 'rank(old)': 'float64', 'age': 'float64', 'weight(t)': 'float64', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'datetime64[ns]', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object'}, {'sample': {'columns': [{'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'rank(old)'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}, {'title': 'Mixed'}], 'value': [["Optim'us", -28.0, 'Leader', 10.0, 4000000.0, 4.3, ['Inochi', 'Convoy'], '19.442735,-99.201111', '1980/04/10', '2016/09/10', [8.5344, 4300.0], datetime.date(2016, 9, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Leader'), None, 'male'], ['bumbl#ebéé  ', 17.0, 'Espionage', 7.0, 5000000.0, 2.0, ['Bumble', 'Goldback'], '10.642707,-71.612534', '1980/04/10', '2015/08/10', [5.334, 2000.0], datetime.date(2015, 8, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Espionage'), None, '1.1.1.1'], ['ironhide&', 26.0, 'Security', 7.0, 7000000.0, 4.0, ['Roadbuster'], '37.789563,-122.400356', '1980/04/10', '2014/07/10', [7.9248, 4000.0], datetime.date(2014, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Security'), None, 'http://hi-optimus.com'], ['Jazz', 13.0, 'First Lieutenant', 8.0, 5000000.0, 1.8, ['Meister'], '33.670666,-117.841553', '1980/04/10', '2013/06/10', [3.9624, 1800.0], datetime.date(2013, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'First Lieutenant'), None, '5123456789123456'], ['Megatron', nan, 'None', 10.0, 5000000.0, 5.7, ['Megatron'], None, '1980/04/10', '2012/05/10', [None, 5700.0], datetime.date(2012, 5, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'None'), None, '11529'], ['Metroplex_)^$', 300.0, 'Battle Station', 8.0, 5000000.0, nan, ['Metroflex'], None, '1980/04/10', '2011/04/10', [91.44, None], datetime.date(2011, 4, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Battle Station'), None, '3'], [None, nan, None, nan, nan, nan, None, None, None, None, None, None, NaT, None, None, None, 'optimus']]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_rename_function():
		actual_df =source_df.cols.rename(str.upper)
		expected_df = op.create.df({'names': 'object', 'height(ft)': 'float64', 'function': 'object', 'rank': 'float64', 'age': 'float64', 'weight(t)': 'float64', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'datetime64[ns]', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object'}, {'sample': {'columns': [{'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'rank'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}, {'title': 'Mixed'}], 'value': [["Optim'us", -28.0, 'Leader', 10.0, 4000000.0, 4.3, ['Inochi', 'Convoy'], '19.442735,-99.201111', '1980/04/10', '2016/09/10', [8.5344, 4300.0], datetime.date(2016, 9, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Leader'), None, 'male'], ['bumbl#ebéé  ', 17.0, 'Espionage', 7.0, 5000000.0, 2.0, ['Bumble', 'Goldback'], '10.642707,-71.612534', '1980/04/10', '2015/08/10', [5.334, 2000.0], datetime.date(2015, 8, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Espionage'), None, '1.1.1.1'], ['ironhide&', 26.0, 'Security', 7.0, 7000000.0, 4.0, ['Roadbuster'], '37.789563,-122.400356', '1980/04/10', '2014/07/10', [7.9248, 4000.0], datetime.date(2014, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Security'), None, 'http://hi-optimus.com'], ['Jazz', 13.0, 'First Lieutenant', 8.0, 5000000.0, 1.8, ['Meister'], '33.670666,-117.841553', '1980/04/10', '2013/06/10', [3.9624, 1800.0], datetime.date(2013, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'First Lieutenant'), None, '5123456789123456'], ['Megatron', nan, 'None', 10.0, 5000000.0, 5.7, ['Megatron'], None, '1980/04/10', '2012/05/10', [None, 5700.0], datetime.date(2012, 5, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'None'), None, '11529'], ['Metroplex_)^$', 300.0, 'Battle Station', 8.0, 5000000.0, nan, ['Metroflex'], None, '1980/04/10', '2011/04/10', [91.44, None], datetime.date(2011, 4, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Battle Station'), None, '3'], [None, nan, None, nan, nan, nan, None, None, None, None, None, None, NaT, None, None, None, 'optimus']]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_rename_list():
		actual_df =source_df.cols.rename(['height(ft)','height(ft)(tons)','rank','rank(old)'])
		expected_df = op.create.df({'names': 'object', 'height(ft)': 'float64', 'function': 'object', 'rank': 'float64', 'age': 'float64', 'weight(t)': 'float64', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'datetime64[ns]', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object'}, {'sample': {'columns': [{'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'rank'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}, {'title': 'Mixed'}], 'value': [["Optim'us", -28.0, 'Leader', 10.0, 4000000.0, 4.3, ['Inochi', 'Convoy'], '19.442735,-99.201111', '1980/04/10', '2016/09/10', [8.5344, 4300.0], datetime.date(2016, 9, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Leader'), None, 'male'], ['bumbl#ebéé  ', 17.0, 'Espionage', 7.0, 5000000.0, 2.0, ['Bumble', 'Goldback'], '10.642707,-71.612534', '1980/04/10', '2015/08/10', [5.334, 2000.0], datetime.date(2015, 8, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Espionage'), None, '1.1.1.1'], ['ironhide&', 26.0, 'Security', 7.0, 7000000.0, 4.0, ['Roadbuster'], '37.789563,-122.400356', '1980/04/10', '2014/07/10', [7.9248, 4000.0], datetime.date(2014, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Security'), None, 'http://hi-optimus.com'], ['Jazz', 13.0, 'First Lieutenant', 8.0, 5000000.0, 1.8, ['Meister'], '33.670666,-117.841553', '1980/04/10', '2013/06/10', [3.9624, 1800.0], datetime.date(2013, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'First Lieutenant'), None, '5123456789123456'], ['Megatron', nan, 'None', 10.0, 5000000.0, 5.7, ['Megatron'], None, '1980/04/10', '2012/05/10', [None, 5700.0], datetime.date(2012, 5, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'None'), None, '11529'], ['Metroplex_)^$', 300.0, 'Battle Station', 8.0, 5000000.0, nan, ['Metroflex'], None, '1980/04/10', '2011/04/10', [91.44, None], datetime.date(2011, 4, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Battle Station'), None, '3'], [None, nan, None, nan, nan, nan, None, None, None, None, None, None, NaT, None, None, None, 'optimus']]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_replace_all_columns():
		actual_df =source_df.cols.replace('*',['Jazz','Leader'],'Match')
		expected_df = op.create.df({'names': 'object', 'height(ft)': 'object', 'function': 'object', 'rank': 'object', 'age': 'object', 'weight(t)': 'object', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'object', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object'}, {'sample': {'columns': [{'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'rank'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}, {'title': 'Mixed'}], 'value': [["Optim'us", '-28.0', 'Match', '10.0', '4000000.0', '4.3', "['Inochi', 'Convoy']", '19.442735,-99.201111', '1980/04/10', '2016/09/10', '[8.5344, 4300.0]', '2016-09-10', '2014-06-24', 'True', "bytearray(b'Match')", 'None', 'male'], ['bumbl#ebéé  ', '17.0', 'Espionage', '7.0', '5000000.0', '2.0', "['Bumble', 'Goldback']", '10.642707,-71.612534', '1980/04/10', '2015/08/10', '[5.334, 2000.0]', '2015-08-10', '2014-06-24', 'True', "bytearray(b'Espionage')", 'None', '1.1.1.1'], ['ironhide&', '26.0', 'Security', '7.0', '7000000.0', '4.0', "['Roadbuster']", '37.789563,-122.400356', '1980/04/10', '2014/07/10', '[7.9248, 4000.0]', '2014-06-24', '2014-06-24', 'True', "bytearray(b'Security')", 'None', 'http://hi-optimus.com'], ['Match', '13.0', 'First Lieutenant', '8.0', '5000000.0', '1.8', "['Meister']", '33.670666,-117.841553', '1980/04/10', '2013/06/10', '[3.9624, 1800.0]', '2013-06-24', '2014-06-24', 'True', "bytearray(b'First Lieutenant')", 'None', '5123456789123456'], ['Megatron', 'nan', 'None', '10.0', '5000000.0', '5.7', "['Megatron']", 'None', '1980/04/10', '2012/05/10', '[None, 5700.0]', '2012-05-10', '2014-06-24', 'True', "bytearray(b'None')", 'None', '11529'], ['Metroplex_)^$', '300.0', 'Battle Station', '8.0', '5000000.0', 'nan', "['Metroflex']", 'None', '1980/04/10', '2011/04/10', '[91.44, None]', '2011-04-10', '2014-06-24', 'True', "bytearray(b'Battle Station')", 'None', '3'], ['None', 'nan', 'None', 'nan', 'nan', 'nan', 'None', 'None', 'None', 'None', 'None', 'None', 'NaT', 'None', 'None', 'None', 'optimus']]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_replace_chars():
		actual_df =source_df.cols.replace('function',['F','E'],'Match',search_by='chars')
		expected_df = op.create.df({'names': 'object', 'height(ft)': 'float64', 'function': 'object', 'rank': 'float64', 'age': 'float64', 'weight(t)': 'float64', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'datetime64[ns]', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object'}, {'sample': {'columns': [{'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'rank'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}, {'title': 'Mixed'}], 'value': [["Optim'us", -28.0, 'Leader', 10.0, 4000000.0, 4.3, ['Inochi', 'Convoy'], '19.442735,-99.201111', '1980/04/10', '2016/09/10', [8.5344, 4300.0], datetime.date(2016, 9, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Leader'), None, 'male'], ['bumbl#ebéé  ', 17.0, 'Matchspionage', 7.0, 5000000.0, 2.0, ['Bumble', 'Goldback'], '10.642707,-71.612534', '1980/04/10', '2015/08/10', [5.334, 2000.0], datetime.date(2015, 8, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Espionage'), None, '1.1.1.1'], ['ironhide&', 26.0, 'Security', 7.0, 7000000.0, 4.0, ['Roadbuster'], '37.789563,-122.400356', '1980/04/10', '2014/07/10', [7.9248, 4000.0], datetime.date(2014, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Security'), None, 'http://hi-optimus.com'], ['Jazz', 13.0, 'Matchirst Lieutenant', 8.0, 5000000.0, 1.8, ['Meister'], '33.670666,-117.841553', '1980/04/10', '2013/06/10', [3.9624, 1800.0], datetime.date(2013, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'First Lieutenant'), None, '5123456789123456'], ['Megatron', nan, 'None', 10.0, 5000000.0, 5.7, ['Megatron'], None, '1980/04/10', '2012/05/10', [None, 5700.0], datetime.date(2012, 5, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'None'), None, '11529'], ['Metroplex_)^$', 300.0, 'Battle Station', 8.0, 5000000.0, nan, ['Metroflex'], None, '1980/04/10', '2011/04/10', [91.44, None], datetime.date(2011, 4, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Battle Station'), None, '3'], [None, nan, 'None', nan, nan, nan, None, None, None, None, None, None, NaT, None, None, None, 'optimus']]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_replace_full():
		actual_df =source_df.cols.replace('function',['First Lieutenant','Battle'],'Match',search_by='full')
		expected_df = op.create.df({'names': 'object', 'height(ft)': 'float64', 'function': 'object', 'rank': 'float64', 'age': 'float64', 'weight(t)': 'float64', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'datetime64[ns]', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object'}, {'sample': {'columns': [{'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'rank'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}, {'title': 'Mixed'}], 'value': [["Optim'us", -28.0, 'Leader', 10.0, 4000000.0, 4.3, ['Inochi', 'Convoy'], '19.442735,-99.201111', '1980/04/10', '2016/09/10', [8.5344, 4300.0], datetime.date(2016, 9, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Leader'), None, 'male'], ['bumbl#ebéé  ', 17.0, 'Espionage', 7.0, 5000000.0, 2.0, ['Bumble', 'Goldback'], '10.642707,-71.612534', '1980/04/10', '2015/08/10', [5.334, 2000.0], datetime.date(2015, 8, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Espionage'), None, '1.1.1.1'], ['ironhide&', 26.0, 'Security', 7.0, 7000000.0, 4.0, ['Roadbuster'], '37.789563,-122.400356', '1980/04/10', '2014/07/10', [7.9248, 4000.0], datetime.date(2014, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Security'), None, 'http://hi-optimus.com'], ['Jazz', 13.0, 'Match', 8.0, 5000000.0, 1.8, ['Meister'], '33.670666,-117.841553', '1980/04/10', '2013/06/10', [3.9624, 1800.0], datetime.date(2013, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'First Lieutenant'), None, '5123456789123456'], ['Megatron', nan, 'None', 10.0, 5000000.0, 5.7, ['Megatron'], None, '1980/04/10', '2012/05/10', [None, 5700.0], datetime.date(2012, 5, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'None'), None, '11529'], ['Metroplex_)^$', 300.0, 'Battle Station', 8.0, 5000000.0, nan, ['Metroflex'], None, '1980/04/10', '2011/04/10', [91.44, None], datetime.date(2011, 4, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Battle Station'), None, '3'], [None, nan, 'None', nan, nan, nan, None, None, None, None, None, None, NaT, None, None, None, 'optimus']]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_replace_words():
		actual_df =source_df.cols.replace('function',['Security','Leader'],'Match',search_by='words')
		expected_df = op.create.df({'names': 'object', 'height(ft)': 'float64', 'function': 'object', 'rank': 'float64', 'age': 'float64', 'weight(t)': 'float64', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'datetime64[ns]', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object'}, {'sample': {'columns': [{'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'rank'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}, {'title': 'Mixed'}], 'value': [["Optim'us", -28.0, 'Match', 10.0, 4000000.0, 4.3, ['Inochi', 'Convoy'], '19.442735,-99.201111', '1980/04/10', '2016/09/10', [8.5344, 4300.0], datetime.date(2016, 9, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Leader'), None, 'male'], ['bumbl#ebéé  ', 17.0, 'Espionage', 7.0, 5000000.0, 2.0, ['Bumble', 'Goldback'], '10.642707,-71.612534', '1980/04/10', '2015/08/10', [5.334, 2000.0], datetime.date(2015, 8, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Espionage'), None, '1.1.1.1'], ['ironhide&', 26.0, 'Match', 7.0, 7000000.0, 4.0, ['Roadbuster'], '37.789563,-122.400356', '1980/04/10', '2014/07/10', [7.9248, 4000.0], datetime.date(2014, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Security'), None, 'http://hi-optimus.com'], ['Jazz', 13.0, 'First Lieutenant', 8.0, 5000000.0, 1.8, ['Meister'], '33.670666,-117.841553', '1980/04/10', '2013/06/10', [3.9624, 1800.0], datetime.date(2013, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'First Lieutenant'), None, '5123456789123456'], ['Megatron', nan, 'None', 10.0, 5000000.0, 5.7, ['Megatron'], None, '1980/04/10', '2012/05/10', [None, 5700.0], datetime.date(2012, 5, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'None'), None, '11529'], ['Metroplex_)^$', 300.0, 'Battle Station', 8.0, 5000000.0, nan, ['Metroflex'], None, '1980/04/10', '2011/04/10', [91.44, None], datetime.date(2011, 4, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Battle Station'), None, '3'], [None, nan, 'None', nan, nan, nan, None, None, None, None, None, None, NaT, None, None, None, 'optimus']]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_reverse():
		actual_df =source_df.cols.reverse('function')
		expected_df = op.create.df({'names': 'object', 'height(ft)': 'float64', 'function': 'object', 'rank': 'float64', 'age': 'float64', 'weight(t)': 'float64', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'datetime64[ns]', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object'}, {'sample': {'columns': [{'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'rank'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}, {'title': 'Mixed'}], 'value': [["Optim'us", -28.0, 'redaeL', 10.0, 4000000.0, 4.3, ['Inochi', 'Convoy'], '19.442735,-99.201111', '1980/04/10', '2016/09/10', [8.5344, 4300.0], datetime.date(2016, 9, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Leader'), None, 'male'], ['bumbl#ebéé  ', 17.0, 'eganoipsE', 7.0, 5000000.0, 2.0, ['Bumble', 'Goldback'], '10.642707,-71.612534', '1980/04/10', '2015/08/10', [5.334, 2000.0], datetime.date(2015, 8, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Espionage'), None, '1.1.1.1'], ['ironhide&', 26.0, 'ytiruceS', 7.0, 7000000.0, 4.0, ['Roadbuster'], '37.789563,-122.400356', '1980/04/10', '2014/07/10', [7.9248, 4000.0], datetime.date(2014, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Security'), None, 'http://hi-optimus.com'], ['Jazz', 13.0, 'tnanetueiL tsriF', 8.0, 5000000.0, 1.8, ['Meister'], '33.670666,-117.841553', '1980/04/10', '2013/06/10', [3.9624, 1800.0], datetime.date(2013, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'First Lieutenant'), None, '5123456789123456'], ['Megatron', nan, 'enoN', 10.0, 5000000.0, 5.7, ['Megatron'], None, '1980/04/10', '2012/05/10', [None, 5700.0], datetime.date(2012, 5, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'None'), None, '11529'], ['Metroplex_)^$', 300.0, 'noitatS elttaB', 8.0, 5000000.0, nan, ['Metroflex'], None, '1980/04/10', '2011/04/10', [91.44, None], datetime.date(2011, 4, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Battle Station'), None, '3'], [None, nan, 'enoN', nan, nan, nan, None, None, None, None, None, None, NaT, None, None, None, 'optimus']]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_reverse_all_columns():
		actual_df =source_df.cols.reverse('*')
		expected_df = op.create.df({'names': 'object', 'height(ft)': 'float64', 'function': 'object', 'rank': 'float64', 'age': 'float64', 'weight(t)': 'float64', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'datetime64[ns]', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object'}, {'sample': {'columns': [{'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'rank'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}, {'title': 'Mixed'}], 'value': [["su'mitpO", -28.0, 'redaeL', 10.0, 4000000.0, 4.3, "]'yovnoC' ,'ihconI'[", '111102.99-,537244.91', '01/40/0891', '01/90/6102', ']0.0034 ,4435.8[', '01-90-6102', Timestamp('2014-06-24 00:00:00'), 'eurT', ")'redaeL'b(yarraetyb", 'enoN', 'elam'], ['  éébe#lbmub', 17.0, 'eganoipsE', 7.0, 5000000.0, 2.0, "]'kcabdloG' ,'elbmuB'[", '435216.17-,707246.01', '01/40/0891', '01/80/5102', ']0.0002 ,433.5[', '01-80-5102', Timestamp('2014-06-24 00:00:00'), 'eurT', ")'eganoipsE'b(yarraetyb", 'enoN', '1.1.1.1'], ['&edihnori', 26.0, 'ytiruceS', 7.0, 7000000.0, 4.0, "]'retsubdaoR'[", '653004.221-,365987.73', '01/40/0891', '01/70/4102', ']0.0004 ,8429.7[', '42-60-4102', Timestamp('2014-06-24 00:00:00'), 'eurT', ")'ytiruceS'b(yarraetyb", 'enoN', 'moc.sumitpo-ih//:ptth'], ['zzaJ', 13.0, 'tnanetueiL tsriF', 8.0, 5000000.0, 1.8, "]'retsieM'[", '355148.711-,666076.33', '01/40/0891', '01/60/3102', ']0.0081 ,4269.3[', '42-60-3102', Timestamp('2014-06-24 00:00:00'), 'eurT', ")'tnanetueiL tsriF'b(yarraetyb", 'enoN', '6543219876543215'], ['nortageM', nan, 'enoN', 10.0, 5000000.0, 5.7, "]'nortageM'[", 'enoN', '01/40/0891', '01/50/2102', ']0.0075 ,enoN[', '01-50-2102', Timestamp('2014-06-24 00:00:00'), 'eurT', ")'enoN'b(yarraetyb", 'enoN', '92511'], ['$^)_xelporteM', 300.0, 'noitatS elttaB', 8.0, 5000000.0, nan, "]'xelforteM'[", 'enoN', '01/40/0891', '01/40/1102', ']enoN ,44.19[', '01-40-1102', Timestamp('2014-06-24 00:00:00'), 'eurT', ")'noitatS elttaB'b(yarraetyb", 'enoN', '3'], ['enoN', nan, 'enoN', nan, nan, nan, 'enoN', 'enoN', 'enoN', 'enoN', 'enoN', 'enoN', NaT, 'enoN', 'enoN', 'enoN', 'sumitpo']]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_schema_dtype():
		actual_df =source_df.cols.schema_dtype('rank')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding(<class 'numpy.float64'>)
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_select():
		actual_df =source_df.cols.select(0,'height(ft)')
		expected_df = op.create.df({'names': 'object'}, {'sample': {'columns': [{'title': 'names'}], 'value': [["Optim'us"], ['bumbl#ebéé  '], ['ironhide&'], ['Jazz'], ['Megatron'], ['Metroplex_)^$'], [None]]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_select_regex():
		actual_df =source_df.cols.select('n.*',regex=True)
		expected_df = op.create.df({'names': 'object'}, {'sample': {'columns': [{'title': 'names'}], 'value': [["Optim'us"], ['bumbl#ebéé  '], ['ironhide&'], ['Jazz'], ['Megatron'], ['Metroplex_)^$'], [None]]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_skewness():
		actual_df =source_df.cols.skewness('height(ft)')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'skewness': {'height(ft)': nan}})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_skewness_all_columns():
		actual_df =source_df.cols.skewness('*')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'skewness': {'height(ft)': nan, 'rank': nan, 'age': nan, 'weight(t)': nan}})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_sort():
		actual_df =source_df.cols.sort()
		expected_df = op.create.df({'age': 'float64', 'attributes': 'object', 'Cybertronian': 'object', 'date arrival': 'object', 'Date Type': 'object', 'function': 'object', 'function(binary)': 'object', 'height(ft)': 'float64', 'japanese name': 'object', 'last date seen': 'object', 'last position seen': 'object', 'Mixed': 'object', 'names': 'object', 'NullType': 'object', 'rank': 'float64', 'timestamp': 'datetime64[ns]', 'weight(t)': 'float64'}, {'sample': {'columns': [{'title': 'age'}, {'title': 'attributes'}, {'title': 'Cybertronian'}, {'title': 'date arrival'}, {'title': 'Date Type'}, {'title': 'function'}, {'title': 'function(binary)'}, {'title': 'height(ft)'}, {'title': 'japanese name'}, {'title': 'last date seen'}, {'title': 'last position seen'}, {'title': 'Mixed'}, {'title': 'names'}, {'title': 'NullType'}, {'title': 'rank'}, {'title': 'timestamp'}, {'title': 'weight(t)'}], 'value': [[4000000.0, [8.5344, 4300.0], True, '1980/04/10', datetime.date(2016, 9, 10), 'Leader', bytearray(b'Leader'), -28.0, ['Inochi', 'Convoy'], '2016/09/10', '19.442735,-99.201111', 'male', "Optim'us", None, 10.0, Timestamp('2014-06-24 00:00:00'), 4.3], [5000000.0, [5.334, 2000.0], True, '1980/04/10', datetime.date(2015, 8, 10), 'Espionage', bytearray(b'Espionage'), 17.0, ['Bumble', 'Goldback'], '2015/08/10', '10.642707,-71.612534', '1.1.1.1', 'bumbl#ebéé  ', None, 7.0, Timestamp('2014-06-24 00:00:00'), 2.0], [7000000.0, [7.9248, 4000.0], True, '1980/04/10', datetime.date(2014, 6, 24), 'Security', bytearray(b'Security'), 26.0, ['Roadbuster'], '2014/07/10', '37.789563,-122.400356', 'http://hi-optimus.com', 'ironhide&', None, 7.0, Timestamp('2014-06-24 00:00:00'), 4.0], [5000000.0, [3.9624, 1800.0], True, '1980/04/10', datetime.date(2013, 6, 24), 'First Lieutenant', bytearray(b'First Lieutenant'), 13.0, ['Meister'], '2013/06/10', '33.670666,-117.841553', '5123456789123456', 'Jazz', None, 8.0, Timestamp('2014-06-24 00:00:00'), 1.8], [5000000.0, [None, 5700.0], True, '1980/04/10', datetime.date(2012, 5, 10), 'None', bytearray(b'None'), nan, ['Megatron'], '2012/05/10', None, '11529', 'Megatron', None, 10.0, Timestamp('2014-06-24 00:00:00'), 5.7], [5000000.0, [91.44, None], True, '1980/04/10', datetime.date(2011, 4, 10), 'Battle Station', bytearray(b'Battle Station'), 300.0, ['Metroflex'], '2011/04/10', None, '3', 'Metroplex_)^$', None, 8.0, Timestamp('2014-06-24 00:00:00'), nan], [nan, None, None, None, None, None, None, nan, None, None, None, 'optimus', None, None, nan, NaT, nan]]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_sort_asc():
		actual_df =source_df.cols.sort('asc')
		expected_df = op.create.df({'age': 'float64', 'attributes': 'object', 'Cybertronian': 'object', 'date arrival': 'object', 'Date Type': 'object', 'function': 'object', 'function(binary)': 'object', 'height(ft)': 'float64', 'japanese name': 'object', 'last date seen': 'object', 'last position seen': 'object', 'Mixed': 'object', 'names': 'object', 'NullType': 'object', 'rank': 'float64', 'timestamp': 'datetime64[ns]', 'weight(t)': 'float64'}, {'sample': {'columns': [{'title': 'age'}, {'title': 'attributes'}, {'title': 'Cybertronian'}, {'title': 'date arrival'}, {'title': 'Date Type'}, {'title': 'function'}, {'title': 'function(binary)'}, {'title': 'height(ft)'}, {'title': 'japanese name'}, {'title': 'last date seen'}, {'title': 'last position seen'}, {'title': 'Mixed'}, {'title': 'names'}, {'title': 'NullType'}, {'title': 'rank'}, {'title': 'timestamp'}, {'title': 'weight(t)'}], 'value': [[4000000.0, [8.5344, 4300.0], True, '1980/04/10', datetime.date(2016, 9, 10), 'Leader', bytearray(b'Leader'), -28.0, ['Inochi', 'Convoy'], '2016/09/10', '19.442735,-99.201111', 'male', "Optim'us", None, 10.0, Timestamp('2014-06-24 00:00:00'), 4.3], [5000000.0, [5.334, 2000.0], True, '1980/04/10', datetime.date(2015, 8, 10), 'Espionage', bytearray(b'Espionage'), 17.0, ['Bumble', 'Goldback'], '2015/08/10', '10.642707,-71.612534', '1.1.1.1', 'bumbl#ebéé  ', None, 7.0, Timestamp('2014-06-24 00:00:00'), 2.0], [7000000.0, [7.9248, 4000.0], True, '1980/04/10', datetime.date(2014, 6, 24), 'Security', bytearray(b'Security'), 26.0, ['Roadbuster'], '2014/07/10', '37.789563,-122.400356', 'http://hi-optimus.com', 'ironhide&', None, 7.0, Timestamp('2014-06-24 00:00:00'), 4.0], [5000000.0, [3.9624, 1800.0], True, '1980/04/10', datetime.date(2013, 6, 24), 'First Lieutenant', bytearray(b'First Lieutenant'), 13.0, ['Meister'], '2013/06/10', '33.670666,-117.841553', '5123456789123456', 'Jazz', None, 8.0, Timestamp('2014-06-24 00:00:00'), 1.8], [5000000.0, [None, 5700.0], True, '1980/04/10', datetime.date(2012, 5, 10), 'None', bytearray(b'None'), nan, ['Megatron'], '2012/05/10', None, '11529', 'Megatron', None, 10.0, Timestamp('2014-06-24 00:00:00'), 5.7], [5000000.0, [91.44, None], True, '1980/04/10', datetime.date(2011, 4, 10), 'Battle Station', bytearray(b'Battle Station'), 300.0, ['Metroflex'], '2011/04/10', None, '3', 'Metroplex_)^$', None, 8.0, Timestamp('2014-06-24 00:00:00'), nan], [nan, None, None, None, None, None, None, nan, None, None, None, 'optimus', None, None, nan, NaT, nan]]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_sort_desc():
		actual_df =source_df.cols.sort('desc')
		expected_df = op.create.df({'weight(t)': 'float64', 'timestamp': 'datetime64[ns]', 'rank': 'float64', 'NullType': 'object', 'names': 'object', 'Mixed': 'object', 'last position seen': 'object', 'last date seen': 'object', 'japanese name': 'object', 'height(ft)': 'float64', 'function(binary)': 'object', 'function': 'object', 'Date Type': 'object', 'date arrival': 'object', 'Cybertronian': 'object', 'attributes': 'object', 'age': 'float64'}, {'sample': {'columns': [{'title': 'weight(t)'}, {'title': 'timestamp'}, {'title': 'rank'}, {'title': 'NullType'}, {'title': 'names'}, {'title': 'Mixed'}, {'title': 'last position seen'}, {'title': 'last date seen'}, {'title': 'japanese name'}, {'title': 'height(ft)'}, {'title': 'function(binary)'}, {'title': 'function'}, {'title': 'Date Type'}, {'title': 'date arrival'}, {'title': 'Cybertronian'}, {'title': 'attributes'}, {'title': 'age'}], 'value': [[4.3, Timestamp('2014-06-24 00:00:00'), 10.0, None, "Optim'us", 'male', '19.442735,-99.201111', '2016/09/10', ['Inochi', 'Convoy'], -28.0, bytearray(b'Leader'), 'Leader', datetime.date(2016, 9, 10), '1980/04/10', True, [8.5344, 4300.0], 4000000.0], [2.0, Timestamp('2014-06-24 00:00:00'), 7.0, None, 'bumbl#ebéé  ', '1.1.1.1', '10.642707,-71.612534', '2015/08/10', ['Bumble', 'Goldback'], 17.0, bytearray(b'Espionage'), 'Espionage', datetime.date(2015, 8, 10), '1980/04/10', True, [5.334, 2000.0], 5000000.0], [4.0, Timestamp('2014-06-24 00:00:00'), 7.0, None, 'ironhide&', 'http://hi-optimus.com', '37.789563,-122.400356', '2014/07/10', ['Roadbuster'], 26.0, bytearray(b'Security'), 'Security', datetime.date(2014, 6, 24), '1980/04/10', True, [7.9248, 4000.0], 7000000.0], [1.8, Timestamp('2014-06-24 00:00:00'), 8.0, None, 'Jazz', '5123456789123456', '33.670666,-117.841553', '2013/06/10', ['Meister'], 13.0, bytearray(b'First Lieutenant'), 'First Lieutenant', datetime.date(2013, 6, 24), '1980/04/10', True, [3.9624, 1800.0], 5000000.0], [5.7, Timestamp('2014-06-24 00:00:00'), 10.0, None, 'Megatron', '11529', None, '2012/05/10', ['Megatron'], nan, bytearray(b'None'), 'None', datetime.date(2012, 5, 10), '1980/04/10', True, [None, 5700.0], 5000000.0], [nan, Timestamp('2014-06-24 00:00:00'), 8.0, None, 'Metroplex_)^$', '3', None, '2011/04/10', ['Metroflex'], 300.0, bytearray(b'Battle Station'), 'Battle Station', datetime.date(2011, 4, 10), '1980/04/10', True, [91.44, None], 5000000.0], [nan, NaT, nan, None, None, 'optimus', None, None, None, nan, None, None, None, None, None, None, nan]]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_std():
		actual_df =source_df.cols.std('height(ft)')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'stddev': {'height(ft)': 132.66612227694}})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_std_all_columns():
		actual_df =source_df.cols.std('*')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'stddev': {'height(ft)': 132.66612227694, 'rank': 1.3662601021279464, 'age': 983192.0802501752, 'weight(t)': 1.6471186963907611}})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_string_to_index():
		actual_df =source_df.cols.string_to_index('rank')
		expected_df = op.create.df({'names': 'object', 'height(ft)': 'float64', 'function': 'object', 'rank': 'int64', 'age': 'float64', 'weight(t)': 'float64', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'datetime64[ns]', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object'}, {'sample': {'columns': [{'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'rank'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}, {'title': 'Mixed'}], 'value': [["Optim'us", -28.0, 'Leader', 0, 4000000.0, 4.3, ['Inochi', 'Convoy'], '19.442735,-99.201111', '1980/04/10', '2016/09/10', [8.5344, 4300.0], datetime.date(2016, 9, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Leader'), None, 'male'], ['bumbl#ebéé  ', 17.0, 'Espionage', 1, 5000000.0, 2.0, ['Bumble', 'Goldback'], '10.642707,-71.612534', '1980/04/10', '2015/08/10', [5.334, 2000.0], datetime.date(2015, 8, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Espionage'), None, '1.1.1.1'], ['ironhide&', 26.0, 'Security', 1, 7000000.0, 4.0, ['Roadbuster'], '37.789563,-122.400356', '1980/04/10', '2014/07/10', [7.9248, 4000.0], datetime.date(2014, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Security'), None, 'http://hi-optimus.com'], ['Jazz', 13.0, 'First Lieutenant', 2, 5000000.0, 1.8, ['Meister'], '33.670666,-117.841553', '1980/04/10', '2013/06/10', [3.9624, 1800.0], datetime.date(2013, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'First Lieutenant'), None, '5123456789123456'], ['Megatron', nan, 'None', 0, 5000000.0, 5.7, ['Megatron'], None, '1980/04/10', '2012/05/10', [None, 5700.0], datetime.date(2012, 5, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'None'), None, '11529'], ['Metroplex_)^$', 300.0, 'Battle Station', 2, 5000000.0, nan, ['Metroflex'], None, '1980/04/10', '2011/04/10', [91.44, None], datetime.date(2011, 4, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Battle Station'), None, '3'], [None, nan, None, 3, nan, nan, None, None, None, None, None, None, NaT, None, None, None, 'optimus']]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_sub():
		actual_df =source_df.cols.sub(['height(ft)','rank'])
		expected_df = op.create.df({'names': 'object', 'height(ft)': 'float64', 'function': 'object', 'rank': 'float64', 'age': 'float64', 'weight(t)': 'float64', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'datetime64[ns]', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object', 'sub': 'float64'}, {'sample': {'columns': [{'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'rank'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}, {'title': 'Mixed'}, {'title': 'sub'}], 'value': [["Optim'us", -28.0, 'Leader', 10.0, 4000000.0, 4.3, ['Inochi', 'Convoy'], '19.442735,-99.201111', '1980/04/10', '2016/09/10', [8.5344, 4300.0], datetime.date(2016, 9, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Leader'), None, 'male', -38.0], ['bumbl#ebéé  ', 17.0, 'Espionage', 7.0, 5000000.0, 2.0, ['Bumble', 'Goldback'], '10.642707,-71.612534', '1980/04/10', '2015/08/10', [5.334, 2000.0], datetime.date(2015, 8, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Espionage'), None, '1.1.1.1', 10.0], ['ironhide&', 26.0, 'Security', 7.0, 7000000.0, 4.0, ['Roadbuster'], '37.789563,-122.400356', '1980/04/10', '2014/07/10', [7.9248, 4000.0], datetime.date(2014, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Security'), None, 'http://hi-optimus.com', 19.0], ['Jazz', 13.0, 'First Lieutenant', 8.0, 5000000.0, 1.8, ['Meister'], '33.670666,-117.841553', '1980/04/10', '2013/06/10', [3.9624, 1800.0], datetime.date(2013, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'First Lieutenant'), None, '5123456789123456', 5.0], ['Megatron', nan, 'None', 10.0, 5000000.0, 5.7, ['Megatron'], None, '1980/04/10', '2012/05/10', [None, 5700.0], datetime.date(2012, 5, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'None'), None, '11529', nan], ['Metroplex_)^$', 300.0, 'Battle Station', 8.0, 5000000.0, nan, ['Metroflex'], None, '1980/04/10', '2011/04/10', [91.44, None], datetime.date(2011, 4, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Battle Station'), None, '3', 292.0], [None, nan, None, nan, nan, nan, None, None, None, None, None, None, NaT, None, None, None, 'optimus', nan]]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_sub_all_columns():
		actual_df =source_df.cols.sub('*')
		expected_df = op.create.df({'names': 'object', 'height(ft)': 'float64', 'function': 'object', 'rank': 'float64', 'age': 'float64', 'weight(t)': 'float64', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'datetime64[ns]', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object', 'sub': 'float64'}, {'sample': {'columns': [{'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'rank'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}, {'title': 'Mixed'}, {'title': 'sub'}], 'value': [["Optim'us", -28.0, 'Leader', 10.0, 4000000.0, 4.3, ['Inochi', 'Convoy'], '19.442735,-99.201111', '1980/04/10', '2016/09/10', [8.5344, 4300.0], datetime.date(2016, 9, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Leader'), None, 'male', -4000042.3], ['bumbl#ebéé  ', 17.0, 'Espionage', 7.0, 5000000.0, 2.0, ['Bumble', 'Goldback'], '10.642707,-71.612534', '1980/04/10', '2015/08/10', [5.334, 2000.0], datetime.date(2015, 8, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Espionage'), None, '1.1.1.1', -4999992.0], ['ironhide&', 26.0, 'Security', 7.0, 7000000.0, 4.0, ['Roadbuster'], '37.789563,-122.400356', '1980/04/10', '2014/07/10', [7.9248, 4000.0], datetime.date(2014, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Security'), None, 'http://hi-optimus.com', -6999985.0], ['Jazz', 13.0, 'First Lieutenant', 8.0, 5000000.0, 1.8, ['Meister'], '33.670666,-117.841553', '1980/04/10', '2013/06/10', [3.9624, 1800.0], datetime.date(2013, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'First Lieutenant'), None, '5123456789123456', -4999996.8], ['Megatron', nan, 'None', 10.0, 5000000.0, 5.7, ['Megatron'], None, '1980/04/10', '2012/05/10', [None, 5700.0], datetime.date(2012, 5, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'None'), None, '11529', nan], ['Metroplex_)^$', 300.0, 'Battle Station', 8.0, 5000000.0, nan, ['Metroflex'], None, '1980/04/10', '2011/04/10', [91.44, None], datetime.date(2011, 4, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Battle Station'), None, '3', nan], [None, nan, None, nan, nan, nan, None, None, None, None, None, None, NaT, None, None, None, 'optimus', nan]]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_sum():
		actual_df =source_df.cols.sum('height(ft)')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding(328.0)
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_sum_all_columns():
		actual_df =source_df.cols.sum('*')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'height(ft)': 328.0, 'rank': 50.0, 'age': 31000000.0, 'weight(t)': 17.8})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_trim():
		actual_df =source_df.cols.trim('function')
		expected_df = op.create.df({'names': 'object', 'height(ft)': 'float64', 'function': 'object', 'rank': 'float64', 'age': 'float64', 'weight(t)': 'float64', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'datetime64[ns]', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object'}, {'sample': {'columns': [{'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'rank'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}, {'title': 'Mixed'}], 'value': [["Optim'us", -28.0, 'Leader', 10.0, 4000000.0, 4.3, ['Inochi', 'Convoy'], '19.442735,-99.201111', '1980/04/10', '2016/09/10', [8.5344, 4300.0], datetime.date(2016, 9, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Leader'), None, 'male'], ['bumbl#ebéé  ', 17.0, 'Espionage', 7.0, 5000000.0, 2.0, ['Bumble', 'Goldback'], '10.642707,-71.612534', '1980/04/10', '2015/08/10', [5.334, 2000.0], datetime.date(2015, 8, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Espionage'), None, '1.1.1.1'], ['ironhide&', 26.0, 'Security', 7.0, 7000000.0, 4.0, ['Roadbuster'], '37.789563,-122.400356', '1980/04/10', '2014/07/10', [7.9248, 4000.0], datetime.date(2014, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Security'), None, 'http://hi-optimus.com'], ['Jazz', 13.0, 'First Lieutenant', 8.0, 5000000.0, 1.8, ['Meister'], '33.670666,-117.841553', '1980/04/10', '2013/06/10', [3.9624, 1800.0], datetime.date(2013, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'First Lieutenant'), None, '5123456789123456'], ['Megatron', nan, 'None', 10.0, 5000000.0, 5.7, ['Megatron'], None, '1980/04/10', '2012/05/10', [None, 5700.0], datetime.date(2012, 5, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'None'), None, '11529'], ['Metroplex_)^$', 300.0, 'Battle Station', 8.0, 5000000.0, nan, ['Metroflex'], None, '1980/04/10', '2011/04/10', [91.44, None], datetime.date(2011, 4, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Battle Station'), None, '3'], [None, nan, 'None', nan, nan, nan, None, None, None, None, None, None, NaT, None, None, None, 'optimus']]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_trim_all_columns():
		actual_df =source_df.cols.trim('*')
		expected_df = op.create.df({'names': 'object', 'height(ft)': 'float64', 'function': 'object', 'rank': 'float64', 'age': 'float64', 'weight(t)': 'float64', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'datetime64[ns]', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object'}, {'sample': {'columns': [{'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'rank'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}, {'title': 'Mixed'}], 'value': [["Optim'us", -28.0, 'Leader', 10.0, 4000000.0, 4.3, "['Inochi', 'Convoy']", '19.442735,-99.201111', '1980/04/10', '2016/09/10', '[8.5344, 4300.0]', '2016-09-10', Timestamp('2014-06-24 00:00:00'), 'True', "bytearray(b'Leader')", 'None', 'male'], ['bumbl#ebéé', 17.0, 'Espionage', 7.0, 5000000.0, 2.0, "['Bumble', 'Goldback']", '10.642707,-71.612534', '1980/04/10', '2015/08/10', '[5.334, 2000.0]', '2015-08-10', Timestamp('2014-06-24 00:00:00'), 'True', "bytearray(b'Espionage')", 'None', '1.1.1.1'], ['ironhide&', 26.0, 'Security', 7.0, 7000000.0, 4.0, "['Roadbuster']", '37.789563,-122.400356', '1980/04/10', '2014/07/10', '[7.9248, 4000.0]', '2014-06-24', Timestamp('2014-06-24 00:00:00'), 'True', "bytearray(b'Security')", 'None', 'http://hi-optimus.com'], ['Jazz', 13.0, 'First Lieutenant', 8.0, 5000000.0, 1.8, "['Meister']", '33.670666,-117.841553', '1980/04/10', '2013/06/10', '[3.9624, 1800.0]', '2013-06-24', Timestamp('2014-06-24 00:00:00'), 'True', "bytearray(b'First Lieutenant')", 'None', '5123456789123456'], ['Megatron', nan, 'None', 10.0, 5000000.0, 5.7, "['Megatron']", 'None', '1980/04/10', '2012/05/10', '[None, 5700.0]', '2012-05-10', Timestamp('2014-06-24 00:00:00'), 'True', "bytearray(b'None')", 'None', '11529'], ['Metroplex_)^$', 300.0, 'Battle Station', 8.0, 5000000.0, nan, "['Metroflex']", 'None', '1980/04/10', '2011/04/10', '[91.44, None]', '2011-04-10', Timestamp('2014-06-24 00:00:00'), 'True', "bytearray(b'Battle Station')", 'None', '3'], ['None', nan, 'None', nan, nan, nan, 'None', 'None', 'None', 'None', 'None', 'None', NaT, 'None', 'None', 'None', 'optimus']]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_unique():
		actual_df =source_df.cols.unique('height(ft)')
		expected_df = op.create.df({'names': 'object', 'height(ft)': 'object', 'function': 'object', 'rank': 'object', 'age': 'object', 'weight(t)': 'object', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'object', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object'}, {'sample': {'columns': [{'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'rank'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}, {'title': 'Mixed'}], 'value': [["Optim'us", '-28.0', 'Leader', '10.0', '4000000.0', '4.3', "['Inochi', 'Convoy']", '19.442735,-99.201111', '1980/04/10', '2016/09/10', '[8.5344, 4300.0]', '2016-09-10', '2014-06-24', 'True', "bytearray(b'Leader')", 'None', 'male'], ['bumbl#ebéé  ', '17.0', 'Espionage', '7.0', '5000000.0', '2.0', "['Bumble', 'Goldback']", '10.642707,-71.612534', '1980/04/10', '2015/08/10', '[5.334, 2000.0]', '2015-08-10', '2014-06-24', 'True', "bytearray(b'Espionage')", 'None', '1.1.1.1'], ['ironhide&', '26.0', 'Security', '7.0', '7000000.0', '4.0', "['Roadbuster']", '37.789563,-122.400356', '1980/04/10', '2014/07/10', '[7.9248, 4000.0]', '2014-06-24', '2014-06-24', 'True', "bytearray(b'Security')", 'None', 'http://hi-optimus.com'], ['Jazz', '13.0', 'First Lieutenant', '8.0', '5000000.0', '1.8', "['Meister']", '33.670666,-117.841553', '1980/04/10', '2013/06/10', '[3.9624, 1800.0]', '2013-06-24', '2014-06-24', 'True', "bytearray(b'First Lieutenant')", 'None', '5123456789123456'], ['Megatron', 'nan', 'None', '10.0', '5000000.0', '5.7', "['Megatron']", 'None', '1980/04/10', '2012/05/10', '[None, 5700.0]', '2012-05-10', '2014-06-24', 'True', "bytearray(b'None')", 'None', '11529'], ['Metroplex_)^$', '300.0', 'Battle Station', '8.0', '5000000.0', 'nan', "['Metroflex']", 'None', '1980/04/10', '2011/04/10', '[91.44, None]', '2011-04-10', '2014-06-24', 'True', "bytearray(b'Battle Station')", 'None', '3']]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_unique_all_columns():
		actual_df =source_df.cols.unique('*')
		expected_df = op.create.df({'names': 'object', 'height(ft)': 'object', 'function': 'object', 'rank': 'object', 'age': 'object', 'weight(t)': 'object', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'object', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object'}, {'sample': {'columns': [{'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'rank'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}, {'title': 'Mixed'}], 'value': [["Optim'us", '-28.0', 'Leader', '10.0', '4000000.0', '4.3', "['Inochi', 'Convoy']", '19.442735,-99.201111', '1980/04/10', '2016/09/10', '[8.5344, 4300.0]', '2016-09-10', '2014-06-24', 'True', "bytearray(b'Leader')", 'None', 'male'], ['bumbl#ebéé  ', '17.0', 'Espionage', '7.0', '5000000.0', '2.0', "['Bumble', 'Goldback']", '10.642707,-71.612534', '1980/04/10', '2015/08/10', '[5.334, 2000.0]', '2015-08-10', '2014-06-24', 'True', "bytearray(b'Espionage')", 'None', '1.1.1.1'], ['ironhide&', '26.0', 'Security', '7.0', '7000000.0', '4.0', "['Roadbuster']", '37.789563,-122.400356', '1980/04/10', '2014/07/10', '[7.9248, 4000.0]', '2014-06-24', '2014-06-24', 'True', "bytearray(b'Security')", 'None', 'http://hi-optimus.com'], ['Jazz', '13.0', 'First Lieutenant', '8.0', '5000000.0', '1.8', "['Meister']", '33.670666,-117.841553', '1980/04/10', '2013/06/10', '[3.9624, 1800.0]', '2013-06-24', '2014-06-24', 'True', "bytearray(b'First Lieutenant')", 'None', '5123456789123456'], ['Megatron', 'nan', 'None', '10.0', '5000000.0', '5.7', "['Megatron']", 'None', '1980/04/10', '2012/05/10', '[None, 5700.0]', '2012-05-10', '2014-06-24', 'True', "bytearray(b'None')", 'None', '11529'], ['Metroplex_)^$', '300.0', 'Battle Station', '8.0', '5000000.0', 'nan', "['Metroflex']", 'None', '1980/04/10', '2011/04/10', '[91.44, None]', '2011-04-10', '2014-06-24', 'True', "bytearray(b'Battle Station')", 'None', '3'], ['None', 'nan', 'None', 'nan', 'nan', 'nan', 'None', 'None', 'None', 'None', 'None', 'None', 'NaT', 'None', 'None', 'None', 'optimus']]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_unnest_array():
		actual_df =source_df.cols.unnest('attributes',mode='array')
		expected_df = op.create.df({'attributes_0': 'object', 'attributes_1': 'object', 'names': 'object', 'height(ft)': 'float64', 'function': 'object', 'rank': 'float64', 'age': 'float64', 'weight(t)': 'float64', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'datetime64[ns]', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object'}, {'sample': {'columns': [{'title': 'attributes_0'}, {'title': 'attributes_1'}, {'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'rank'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}, {'title': 'Mixed'}], 'value': [[8.5344, 4300.0, "Optim'us", -28.0, 'Leader', 10.0, 4000000.0, 4.3, ['Inochi', 'Convoy'], '19.442735,-99.201111', '1980/04/10', '2016/09/10', [8.5344, 4300.0], datetime.date(2016, 9, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Leader'), None, 'male'], [5.334, 2000.0, 'bumbl#ebéé  ', 17.0, 'Espionage', 7.0, 5000000.0, 2.0, ['Bumble', 'Goldback'], '10.642707,-71.612534', '1980/04/10', '2015/08/10', [5.334, 2000.0], datetime.date(2015, 8, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Espionage'), None, '1.1.1.1'], [7.9248, 4000.0, 'ironhide&', 26.0, 'Security', 7.0, 7000000.0, 4.0, ['Roadbuster'], '37.789563,-122.400356', '1980/04/10', '2014/07/10', [7.9248, 4000.0], datetime.date(2014, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Security'), None, 'http://hi-optimus.com'], [3.9624, 1800.0, 'Jazz', 13.0, 'First Lieutenant', 8.0, 5000000.0, 1.8, ['Meister'], '33.670666,-117.841553', '1980/04/10', '2013/06/10', [3.9624, 1800.0], datetime.date(2013, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'First Lieutenant'), None, '5123456789123456'], [nan, 5700.0, 'Megatron', nan, 'None', 10.0, 5000000.0, 5.7, ['Megatron'], None, '1980/04/10', '2012/05/10', [None, 5700.0], datetime.date(2012, 5, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'None'), None, '11529'], [91.44, nan, 'Metroplex_)^$', 300.0, 'Battle Station', 8.0, 5000000.0, nan, ['Metroflex'], None, '1980/04/10', '2011/04/10', [91.44, None], datetime.date(2011, 4, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Battle Station'), None, '3'], [nan, nan, None, nan, None, nan, nan, nan, None, None, None, None, None, None, NaT, None, None, None, 'optimus']]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_unnest_array_all_columns():
		actual_df =source_df.cols.unnest('attributes',mode='array')
		expected_df = op.create.df({'attributes_0': 'object', 'attributes_1': 'object', 'names': 'object', 'height(ft)': 'float64', 'function': 'object', 'rank': 'float64', 'age': 'float64', 'weight(t)': 'float64', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'datetime64[ns]', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object'}, {'sample': {'columns': [{'title': 'attributes_0'}, {'title': 'attributes_1'}, {'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'rank'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}, {'title': 'Mixed'}], 'value': [[8.5344, 4300.0, "Optim'us", -28.0, 'Leader', 10.0, 4000000.0, 4.3, ['Inochi', 'Convoy'], '19.442735,-99.201111', '1980/04/10', '2016/09/10', [8.5344, 4300.0], datetime.date(2016, 9, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Leader'), None, 'male'], [5.334, 2000.0, 'bumbl#ebéé  ', 17.0, 'Espionage', 7.0, 5000000.0, 2.0, ['Bumble', 'Goldback'], '10.642707,-71.612534', '1980/04/10', '2015/08/10', [5.334, 2000.0], datetime.date(2015, 8, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Espionage'), None, '1.1.1.1'], [7.9248, 4000.0, 'ironhide&', 26.0, 'Security', 7.0, 7000000.0, 4.0, ['Roadbuster'], '37.789563,-122.400356', '1980/04/10', '2014/07/10', [7.9248, 4000.0], datetime.date(2014, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Security'), None, 'http://hi-optimus.com'], [3.9624, 1800.0, 'Jazz', 13.0, 'First Lieutenant', 8.0, 5000000.0, 1.8, ['Meister'], '33.670666,-117.841553', '1980/04/10', '2013/06/10', [3.9624, 1800.0], datetime.date(2013, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'First Lieutenant'), None, '5123456789123456'], [nan, 5700.0, 'Megatron', nan, 'None', 10.0, 5000000.0, 5.7, ['Megatron'], None, '1980/04/10', '2012/05/10', [None, 5700.0], datetime.date(2012, 5, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'None'), None, '11529'], [91.44, nan, 'Metroplex_)^$', 300.0, 'Battle Station', 8.0, 5000000.0, nan, ['Metroflex'], None, '1980/04/10', '2011/04/10', [91.44, None], datetime.date(2011, 4, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Battle Station'), None, '3'], [nan, nan, None, nan, None, nan, nan, nan, None, None, None, None, None, None, NaT, None, None, None, 'optimus']]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_unnest_array_index():
		actual_df =source_df.cols.unnest('attributes',index=1,mode='array')
		expected_df = op.create.df({'attributes_1': 'object', 'names': 'object', 'height(ft)': 'float64', 'function': 'object', 'rank': 'float64', 'age': 'float64', 'weight(t)': 'float64', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'datetime64[ns]', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object'}, {'sample': {'columns': [{'title': 'attributes_1'}, {'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'rank'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}, {'title': 'Mixed'}], 'value': [[4300.0, "Optim'us", -28.0, 'Leader', 10.0, 4000000.0, 4.3, ['Inochi', 'Convoy'], '19.442735,-99.201111', '1980/04/10', '2016/09/10', [8.5344, 4300.0], datetime.date(2016, 9, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Leader'), None, 'male'], [2000.0, 'bumbl#ebéé  ', 17.0, 'Espionage', 7.0, 5000000.0, 2.0, ['Bumble', 'Goldback'], '10.642707,-71.612534', '1980/04/10', '2015/08/10', [5.334, 2000.0], datetime.date(2015, 8, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Espionage'), None, '1.1.1.1'], [4000.0, 'ironhide&', 26.0, 'Security', 7.0, 7000000.0, 4.0, ['Roadbuster'], '37.789563,-122.400356', '1980/04/10', '2014/07/10', [7.9248, 4000.0], datetime.date(2014, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Security'), None, 'http://hi-optimus.com'], [1800.0, 'Jazz', 13.0, 'First Lieutenant', 8.0, 5000000.0, 1.8, ['Meister'], '33.670666,-117.841553', '1980/04/10', '2013/06/10', [3.9624, 1800.0], datetime.date(2013, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'First Lieutenant'), None, '5123456789123456'], [5700.0, 'Megatron', nan, 'None', 10.0, 5000000.0, 5.7, ['Megatron'], None, '1980/04/10', '2012/05/10', [None, 5700.0], datetime.date(2012, 5, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'None'), None, '11529'], [nan, 'Metroplex_)^$', 300.0, 'Battle Station', 8.0, 5000000.0, nan, ['Metroflex'], None, '1980/04/10', '2011/04/10', [91.44, None], datetime.date(2011, 4, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Battle Station'), None, '3'], [nan, None, nan, None, nan, nan, nan, None, None, None, None, None, None, NaT, None, None, None, 'optimus']]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_unnest_array_multi_index():
		actual_df =source_df.cols.unnest('attributes',index=[0, 1],mode='array')
		expected_df = op.create.df({'attributes_0': 'object', 'names': 'object', 'height(ft)': 'float64', 'function': 'object', 'rank': 'float64', 'age': 'float64', 'weight(t)': 'float64', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'datetime64[ns]', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object'}, {'sample': {'columns': [{'title': 'attributes_0'}, {'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'rank'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}, {'title': 'Mixed'}], 'value': [[8.5344, "Optim'us", -28.0, 'Leader', 10.0, 4000000.0, 4.3, ['Inochi', 'Convoy'], '19.442735,-99.201111', '1980/04/10', '2016/09/10', [8.5344, 4300.0], datetime.date(2016, 9, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Leader'), None, 'male'], [5.334, 'bumbl#ebéé  ', 17.0, 'Espionage', 7.0, 5000000.0, 2.0, ['Bumble', 'Goldback'], '10.642707,-71.612534', '1980/04/10', '2015/08/10', [5.334, 2000.0], datetime.date(2015, 8, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Espionage'), None, '1.1.1.1'], [7.9248, 'ironhide&', 26.0, 'Security', 7.0, 7000000.0, 4.0, ['Roadbuster'], '37.789563,-122.400356', '1980/04/10', '2014/07/10', [7.9248, 4000.0], datetime.date(2014, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Security'), None, 'http://hi-optimus.com'], [3.9624, 'Jazz', 13.0, 'First Lieutenant', 8.0, 5000000.0, 1.8, ['Meister'], '33.670666,-117.841553', '1980/04/10', '2013/06/10', [3.9624, 1800.0], datetime.date(2013, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'First Lieutenant'), None, '5123456789123456'], [nan, 'Megatron', nan, 'None', 10.0, 5000000.0, 5.7, ['Megatron'], None, '1980/04/10', '2012/05/10', [None, 5700.0], datetime.date(2012, 5, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'None'), None, '11529'], [91.44, 'Metroplex_)^$', 300.0, 'Battle Station', 8.0, 5000000.0, nan, ['Metroflex'], None, '1980/04/10', '2011/04/10', [91.44, None], datetime.date(2011, 4, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Battle Station'), None, '3'], [nan, None, nan, None, nan, nan, nan, None, None, None, None, None, None, NaT, None, None, None, 'optimus']]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_unnest_string_index():
		actual_df =source_df.cols.unnest('date arrival','/',splits=3)
		expected_df = op.create.df({'date arrival_0': 'object', 'date arrival_1': 'object', 'date arrival_2': 'object', 'names': 'object', 'height(ft)': 'float64', 'function': 'object', 'rank': 'float64', 'age': 'float64', 'weight(t)': 'float64', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'datetime64[ns]', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object'}, {'sample': {'columns': [{'title': 'date arrival_0'}, {'title': 'date arrival_1'}, {'title': 'date arrival_2'}, {'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'rank'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}, {'title': 'Mixed'}], 'value': [['1980', '04', '10', "Optim'us", -28.0, 'Leader', 10.0, 4000000.0, 4.3, ['Inochi', 'Convoy'], '19.442735,-99.201111', '1980/04/10', '2016/09/10', [8.5344, 4300.0], datetime.date(2016, 9, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Leader'), None, 'male'], ['1980', '04', '10', 'bumbl#ebéé  ', 17.0, 'Espionage', 7.0, 5000000.0, 2.0, ['Bumble', 'Goldback'], '10.642707,-71.612534', '1980/04/10', '2015/08/10', [5.334, 2000.0], datetime.date(2015, 8, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Espionage'), None, '1.1.1.1'], ['1980', '04', '10', 'ironhide&', 26.0, 'Security', 7.0, 7000000.0, 4.0, ['Roadbuster'], '37.789563,-122.400356', '1980/04/10', '2014/07/10', [7.9248, 4000.0], datetime.date(2014, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Security'), None, 'http://hi-optimus.com'], ['1980', '04', '10', 'Jazz', 13.0, 'First Lieutenant', 8.0, 5000000.0, 1.8, ['Meister'], '33.670666,-117.841553', '1980/04/10', '2013/06/10', [3.9624, 1800.0], datetime.date(2013, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'First Lieutenant'), None, '5123456789123456'], ['1980', '04', '10', 'Megatron', nan, 'None', 10.0, 5000000.0, 5.7, ['Megatron'], None, '1980/04/10', '2012/05/10', [None, 5700.0], datetime.date(2012, 5, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'None'), None, '11529'], ['1980', '04', '10', 'Metroplex_)^$', 300.0, 'Battle Station', 8.0, 5000000.0, nan, ['Metroflex'], None, '1980/04/10', '2011/04/10', [91.44, None], datetime.date(2011, 4, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Battle Station'), None, '3'], ['None', None, None, None, nan, None, nan, nan, nan, None, None, None, None, None, None, NaT, None, None, None, 'optimus']]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_unnest_string_infer_split():
		actual_df =source_df.cols.unnest('date arrival','/')
		expected_df = op.create.df({'date arrival_0': 'object', 'date arrival_1': 'object', 'names': 'object', 'height(ft)': 'float64', 'function': 'object', 'rank': 'float64', 'age': 'float64', 'weight(t)': 'float64', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'datetime64[ns]', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object'}, {'sample': {'columns': [{'title': 'date arrival_0'}, {'title': 'date arrival_1'}, {'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'rank'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}, {'title': 'Mixed'}], 'value': [['1980', '04/10', "Optim'us", -28.0, 'Leader', 10.0, 4000000.0, 4.3, ['Inochi', 'Convoy'], '19.442735,-99.201111', '1980/04/10', '2016/09/10', [8.5344, 4300.0], datetime.date(2016, 9, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Leader'), None, 'male'], ['1980', '04/10', 'bumbl#ebéé  ', 17.0, 'Espionage', 7.0, 5000000.0, 2.0, ['Bumble', 'Goldback'], '10.642707,-71.612534', '1980/04/10', '2015/08/10', [5.334, 2000.0], datetime.date(2015, 8, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Espionage'), None, '1.1.1.1'], ['1980', '04/10', 'ironhide&', 26.0, 'Security', 7.0, 7000000.0, 4.0, ['Roadbuster'], '37.789563,-122.400356', '1980/04/10', '2014/07/10', [7.9248, 4000.0], datetime.date(2014, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Security'), None, 'http://hi-optimus.com'], ['1980', '04/10', 'Jazz', 13.0, 'First Lieutenant', 8.0, 5000000.0, 1.8, ['Meister'], '33.670666,-117.841553', '1980/04/10', '2013/06/10', [3.9624, 1800.0], datetime.date(2013, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'First Lieutenant'), None, '5123456789123456'], ['1980', '04/10', 'Megatron', nan, 'None', 10.0, 5000000.0, 5.7, ['Megatron'], None, '1980/04/10', '2012/05/10', [None, 5700.0], datetime.date(2012, 5, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'None'), None, '11529'], ['1980', '04/10', 'Metroplex_)^$', 300.0, 'Battle Station', 8.0, 5000000.0, nan, ['Metroflex'], None, '1980/04/10', '2011/04/10', [91.44, None], datetime.date(2011, 4, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Battle Station'), None, '3'], ['None', None, None, nan, None, nan, nan, nan, None, None, None, None, None, None, NaT, None, None, None, 'optimus']]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_unnest_string_multi_colum_multi_index_multi_output():
		actual_df =source_df.cols.unnest(['date arrival','last date seen'],'/',index=[[0, 1], [0, 1]],output_cols=[('year1', 'month1'), ('year2', 'month2')])
		expected_df = op.create.df({'year2': 'object', 'month2': 'object', 'year1': 'object', 'month1': 'object', 'names': 'object', 'height(ft)': 'float64', 'function': 'object', 'rank': 'float64', 'age': 'float64', 'weight(t)': 'float64', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'datetime64[ns]', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object'}, {'sample': {'columns': [{'title': 'year2'}, {'title': 'month2'}, {'title': 'year1'}, {'title': 'month1'}, {'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'rank'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}, {'title': 'Mixed'}], 'value': [['2016', '09/10', '1980', '04/10', "Optim'us", -28.0, 'Leader', 10.0, 4000000.0, 4.3, ['Inochi', 'Convoy'], '19.442735,-99.201111', '1980/04/10', '2016/09/10', [8.5344, 4300.0], datetime.date(2016, 9, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Leader'), None, 'male'], ['2015', '08/10', '1980', '04/10', 'bumbl#ebéé  ', 17.0, 'Espionage', 7.0, 5000000.0, 2.0, ['Bumble', 'Goldback'], '10.642707,-71.612534', '1980/04/10', '2015/08/10', [5.334, 2000.0], datetime.date(2015, 8, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Espionage'), None, '1.1.1.1'], ['2014', '07/10', '1980', '04/10', 'ironhide&', 26.0, 'Security', 7.0, 7000000.0, 4.0, ['Roadbuster'], '37.789563,-122.400356', '1980/04/10', '2014/07/10', [7.9248, 4000.0], datetime.date(2014, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Security'), None, 'http://hi-optimus.com'], ['2013', '06/10', '1980', '04/10', 'Jazz', 13.0, 'First Lieutenant', 8.0, 5000000.0, 1.8, ['Meister'], '33.670666,-117.841553', '1980/04/10', '2013/06/10', [3.9624, 1800.0], datetime.date(2013, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'First Lieutenant'), None, '5123456789123456'], ['2012', '05/10', '1980', '04/10', 'Megatron', nan, 'None', 10.0, 5000000.0, 5.7, ['Megatron'], None, '1980/04/10', '2012/05/10', [None, 5700.0], datetime.date(2012, 5, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'None'), None, '11529'], ['2011', '04/10', '1980', '04/10', 'Metroplex_)^$', 300.0, 'Battle Station', 8.0, 5000000.0, nan, ['Metroflex'], None, '1980/04/10', '2011/04/10', [91.44, None], datetime.date(2011, 4, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Battle Station'), None, '3'], ['None', None, 'None', None, None, nan, None, nan, nan, nan, None, None, None, None, None, None, NaT, None, None, None, 'optimus']]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_unnest_string_multi_colum_multi_output():
		actual_df =source_df.cols.unnest(['date arrival','last date seen'],'/',output_cols=[('year1', 'month1'), ('year2', 'month2')])
		expected_df = op.create.df({'year2': 'object', 'month2': 'object', 'year1': 'object', 'month1': 'object', 'names': 'object', 'height(ft)': 'float64', 'function': 'object', 'rank': 'float64', 'age': 'float64', 'weight(t)': 'float64', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'datetime64[ns]', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object'}, {'sample': {'columns': [{'title': 'year2'}, {'title': 'month2'}, {'title': 'year1'}, {'title': 'month1'}, {'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'rank'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}, {'title': 'Mixed'}], 'value': [['2016', '09/10', '1980', '04/10', "Optim'us", -28.0, 'Leader', 10.0, 4000000.0, 4.3, ['Inochi', 'Convoy'], '19.442735,-99.201111', '1980/04/10', '2016/09/10', [8.5344, 4300.0], datetime.date(2016, 9, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Leader'), None, 'male'], ['2015', '08/10', '1980', '04/10', 'bumbl#ebéé  ', 17.0, 'Espionage', 7.0, 5000000.0, 2.0, ['Bumble', 'Goldback'], '10.642707,-71.612534', '1980/04/10', '2015/08/10', [5.334, 2000.0], datetime.date(2015, 8, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Espionage'), None, '1.1.1.1'], ['2014', '07/10', '1980', '04/10', 'ironhide&', 26.0, 'Security', 7.0, 7000000.0, 4.0, ['Roadbuster'], '37.789563,-122.400356', '1980/04/10', '2014/07/10', [7.9248, 4000.0], datetime.date(2014, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Security'), None, 'http://hi-optimus.com'], ['2013', '06/10', '1980', '04/10', 'Jazz', 13.0, 'First Lieutenant', 8.0, 5000000.0, 1.8, ['Meister'], '33.670666,-117.841553', '1980/04/10', '2013/06/10', [3.9624, 1800.0], datetime.date(2013, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'First Lieutenant'), None, '5123456789123456'], ['2012', '05/10', '1980', '04/10', 'Megatron', nan, 'None', 10.0, 5000000.0, 5.7, ['Megatron'], None, '1980/04/10', '2012/05/10', [None, 5700.0], datetime.date(2012, 5, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'None'), None, '11529'], ['2011', '04/10', '1980', '04/10', 'Metroplex_)^$', 300.0, 'Battle Station', 8.0, 5000000.0, nan, ['Metroflex'], None, '1980/04/10', '2011/04/10', [91.44, None], datetime.date(2011, 4, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Battle Station'), None, '3'], ['None', None, 'None', None, None, nan, None, nan, nan, nan, None, None, None, None, None, None, NaT, None, None, None, 'optimus']]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_unnest_string_multi_index():
		actual_df =source_df.cols.unnest('date arrival','/',splits=3,index=[1, 2])
		expected_df = op.create.df({'date arrival_1': 'object', 'date arrival_2': 'object', 'names': 'object', 'height(ft)': 'float64', 'function': 'object', 'rank': 'float64', 'age': 'float64', 'weight(t)': 'float64', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'datetime64[ns]', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object'}, {'sample': {'columns': [{'title': 'date arrival_1'}, {'title': 'date arrival_2'}, {'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'rank'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}, {'title': 'Mixed'}], 'value': [['04', '10', "Optim'us", -28.0, 'Leader', 10.0, 4000000.0, 4.3, ['Inochi', 'Convoy'], '19.442735,-99.201111', '1980/04/10', '2016/09/10', [8.5344, 4300.0], datetime.date(2016, 9, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Leader'), None, 'male'], ['04', '10', 'bumbl#ebéé  ', 17.0, 'Espionage', 7.0, 5000000.0, 2.0, ['Bumble', 'Goldback'], '10.642707,-71.612534', '1980/04/10', '2015/08/10', [5.334, 2000.0], datetime.date(2015, 8, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Espionage'), None, '1.1.1.1'], ['04', '10', 'ironhide&', 26.0, 'Security', 7.0, 7000000.0, 4.0, ['Roadbuster'], '37.789563,-122.400356', '1980/04/10', '2014/07/10', [7.9248, 4000.0], datetime.date(2014, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Security'), None, 'http://hi-optimus.com'], ['04', '10', 'Jazz', 13.0, 'First Lieutenant', 8.0, 5000000.0, 1.8, ['Meister'], '33.670666,-117.841553', '1980/04/10', '2013/06/10', [3.9624, 1800.0], datetime.date(2013, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'First Lieutenant'), None, '5123456789123456'], ['04', '10', 'Megatron', nan, 'None', 10.0, 5000000.0, 5.7, ['Megatron'], None, '1980/04/10', '2012/05/10', [None, 5700.0], datetime.date(2012, 5, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'None'), None, '11529'], ['04', '10', 'Metroplex_)^$', 300.0, 'Battle Station', 8.0, 5000000.0, nan, ['Metroflex'], None, '1980/04/10', '2011/04/10', [91.44, None], datetime.date(2011, 4, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Battle Station'), None, '3'], [None, None, None, nan, None, nan, nan, nan, None, None, None, None, None, None, NaT, None, None, None, 'optimus']]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_unnest_string_no_index():
		actual_df =source_df.cols.unnest('date arrival','/',splits=3)
		expected_df = op.create.df({'date arrival_0': 'object', 'date arrival_1': 'object', 'date arrival_2': 'object', 'names': 'object', 'height(ft)': 'float64', 'function': 'object', 'rank': 'float64', 'age': 'float64', 'weight(t)': 'float64', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'datetime64[ns]', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object'}, {'sample': {'columns': [{'title': 'date arrival_0'}, {'title': 'date arrival_1'}, {'title': 'date arrival_2'}, {'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'rank'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}, {'title': 'Mixed'}], 'value': [['1980', '04', '10', "Optim'us", -28.0, 'Leader', 10.0, 4000000.0, 4.3, ['Inochi', 'Convoy'], '19.442735,-99.201111', '1980/04/10', '2016/09/10', [8.5344, 4300.0], datetime.date(2016, 9, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Leader'), None, 'male'], ['1980', '04', '10', 'bumbl#ebéé  ', 17.0, 'Espionage', 7.0, 5000000.0, 2.0, ['Bumble', 'Goldback'], '10.642707,-71.612534', '1980/04/10', '2015/08/10', [5.334, 2000.0], datetime.date(2015, 8, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Espionage'), None, '1.1.1.1'], ['1980', '04', '10', 'ironhide&', 26.0, 'Security', 7.0, 7000000.0, 4.0, ['Roadbuster'], '37.789563,-122.400356', '1980/04/10', '2014/07/10', [7.9248, 4000.0], datetime.date(2014, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Security'), None, 'http://hi-optimus.com'], ['1980', '04', '10', 'Jazz', 13.0, 'First Lieutenant', 8.0, 5000000.0, 1.8, ['Meister'], '33.670666,-117.841553', '1980/04/10', '2013/06/10', [3.9624, 1800.0], datetime.date(2013, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'First Lieutenant'), None, '5123456789123456'], ['1980', '04', '10', 'Megatron', nan, 'None', 10.0, 5000000.0, 5.7, ['Megatron'], None, '1980/04/10', '2012/05/10', [None, 5700.0], datetime.date(2012, 5, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'None'), None, '11529'], ['1980', '04', '10', 'Metroplex_)^$', 300.0, 'Battle Station', 8.0, 5000000.0, nan, ['Metroflex'], None, '1980/04/10', '2011/04/10', [91.44, None], datetime.date(2011, 4, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Battle Station'), None, '3'], ['None', None, None, None, nan, None, nan, nan, nan, None, None, None, None, None, None, NaT, None, None, None, 'optimus']]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_unnest_string_output_columns():
		actual_df =source_df.cols.unnest('date arrival','/',splits=3,output_cols=['year', 'month', 'day'])
		expected_df = op.create.df({'year': 'object', 'month': 'object', 'day': 'object', 'names': 'object', 'height(ft)': 'float64', 'function': 'object', 'rank': 'float64', 'age': 'float64', 'weight(t)': 'float64', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'datetime64[ns]', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object'}, {'sample': {'columns': [{'title': 'year'}, {'title': 'month'}, {'title': 'day'}, {'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'rank'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}, {'title': 'Mixed'}], 'value': [['1980', '04', '10', "Optim'us", -28.0, 'Leader', 10.0, 4000000.0, 4.3, ['Inochi', 'Convoy'], '19.442735,-99.201111', '1980/04/10', '2016/09/10', [8.5344, 4300.0], datetime.date(2016, 9, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Leader'), None, 'male'], ['1980', '04', '10', 'bumbl#ebéé  ', 17.0, 'Espionage', 7.0, 5000000.0, 2.0, ['Bumble', 'Goldback'], '10.642707,-71.612534', '1980/04/10', '2015/08/10', [5.334, 2000.0], datetime.date(2015, 8, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Espionage'), None, '1.1.1.1'], ['1980', '04', '10', 'ironhide&', 26.0, 'Security', 7.0, 7000000.0, 4.0, ['Roadbuster'], '37.789563,-122.400356', '1980/04/10', '2014/07/10', [7.9248, 4000.0], datetime.date(2014, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Security'), None, 'http://hi-optimus.com'], ['1980', '04', '10', 'Jazz', 13.0, 'First Lieutenant', 8.0, 5000000.0, 1.8, ['Meister'], '33.670666,-117.841553', '1980/04/10', '2013/06/10', [3.9624, 1800.0], datetime.date(2013, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'First Lieutenant'), None, '5123456789123456'], ['1980', '04', '10', 'Megatron', nan, 'None', 10.0, 5000000.0, 5.7, ['Megatron'], None, '1980/04/10', '2012/05/10', [None, 5700.0], datetime.date(2012, 5, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'None'), None, '11529'], ['1980', '04', '10', 'Metroplex_)^$', 300.0, 'Battle Station', 8.0, 5000000.0, nan, ['Metroflex'], None, '1980/04/10', '2011/04/10', [91.44, None], datetime.date(2011, 4, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Battle Station'), None, '3'], ['None', None, None, None, nan, None, nan, nan, nan, None, None, None, None, None, None, NaT, None, None, None, 'optimus']]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_upper():
		actual_df =source_df.cols.upper('function')
		expected_df = op.create.df({'names': 'object', 'height(ft)': 'float64', 'function': 'object', 'rank': 'float64', 'age': 'float64', 'weight(t)': 'float64', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'datetime64[ns]', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object'}, {'sample': {'columns': [{'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'rank'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}, {'title': 'Mixed'}], 'value': [["Optim'us", -28.0, 'LEADER', 10.0, 4000000.0, 4.3, ['Inochi', 'Convoy'], '19.442735,-99.201111', '1980/04/10', '2016/09/10', [8.5344, 4300.0], datetime.date(2016, 9, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Leader'), None, 'male'], ['bumbl#ebéé  ', 17.0, 'ESPIONAGE', 7.0, 5000000.0, 2.0, ['Bumble', 'Goldback'], '10.642707,-71.612534', '1980/04/10', '2015/08/10', [5.334, 2000.0], datetime.date(2015, 8, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Espionage'), None, '1.1.1.1'], ['ironhide&', 26.0, 'SECURITY', 7.0, 7000000.0, 4.0, ['Roadbuster'], '37.789563,-122.400356', '1980/04/10', '2014/07/10', [7.9248, 4000.0], datetime.date(2014, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Security'), None, 'http://hi-optimus.com'], ['Jazz', 13.0, 'FIRST LIEUTENANT', 8.0, 5000000.0, 1.8, ['Meister'], '33.670666,-117.841553', '1980/04/10', '2013/06/10', [3.9624, 1800.0], datetime.date(2013, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'First Lieutenant'), None, '5123456789123456'], ['Megatron', nan, 'NONE', 10.0, 5000000.0, 5.7, ['Megatron'], None, '1980/04/10', '2012/05/10', [None, 5700.0], datetime.date(2012, 5, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'None'), None, '11529'], ['Metroplex_)^$', 300.0, 'BATTLE STATION', 8.0, 5000000.0, nan, ['Metroflex'], None, '1980/04/10', '2011/04/10', [91.44, None], datetime.date(2011, 4, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Battle Station'), None, '3'], [None, nan, 'NONE', nan, nan, nan, None, None, None, None, None, None, NaT, None, None, None, 'optimus']]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_upper_all_columns():
		actual_df =source_df.cols.upper('*')
		expected_df = op.create.df({'names': 'object', 'height(ft)': 'float64', 'function': 'object', 'rank': 'float64', 'age': 'float64', 'weight(t)': 'float64', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'datetime64[ns]', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object'}, {'sample': {'columns': [{'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'rank'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}, {'title': 'Mixed'}], 'value': [["OPTIM'US", -28.0, 'LEADER', 10.0, 4000000.0, 4.3, "['INOCHI', 'CONVOY']", '19.442735,-99.201111', '1980/04/10', '2016/09/10', '[8.5344, 4300.0]', '2016-09-10', Timestamp('2014-06-24 00:00:00'), 'TRUE', "BYTEARRAY(B'LEADER')", 'NONE', 'MALE'], ['BUMBL#EBÉÉ  ', 17.0, 'ESPIONAGE', 7.0, 5000000.0, 2.0, "['BUMBLE', 'GOLDBACK']", '10.642707,-71.612534', '1980/04/10', '2015/08/10', '[5.334, 2000.0]', '2015-08-10', Timestamp('2014-06-24 00:00:00'), 'TRUE', "BYTEARRAY(B'ESPIONAGE')", 'NONE', '1.1.1.1'], ['IRONHIDE&', 26.0, 'SECURITY', 7.0, 7000000.0, 4.0, "['ROADBUSTER']", '37.789563,-122.400356', '1980/04/10', '2014/07/10', '[7.9248, 4000.0]', '2014-06-24', Timestamp('2014-06-24 00:00:00'), 'TRUE', "BYTEARRAY(B'SECURITY')", 'NONE', 'HTTP://HI-OPTIMUS.COM'], ['JAZZ', 13.0, 'FIRST LIEUTENANT', 8.0, 5000000.0, 1.8, "['MEISTER']", '33.670666,-117.841553', '1980/04/10', '2013/06/10', '[3.9624, 1800.0]', '2013-06-24', Timestamp('2014-06-24 00:00:00'), 'TRUE', "BYTEARRAY(B'FIRST LIEUTENANT')", 'NONE', '5123456789123456'], ['MEGATRON', nan, 'NONE', 10.0, 5000000.0, 5.7, "['MEGATRON']", 'NONE', '1980/04/10', '2012/05/10', '[NONE, 5700.0]', '2012-05-10', Timestamp('2014-06-24 00:00:00'), 'TRUE', "BYTEARRAY(B'NONE')", 'NONE', '11529'], ['METROPLEX_)^$', 300.0, 'BATTLE STATION', 8.0, 5000000.0, nan, "['METROFLEX']", 'NONE', '1980/04/10', '2011/04/10', '[91.44, NONE]', '2011-04-10', Timestamp('2014-06-24 00:00:00'), 'TRUE', "BYTEARRAY(B'BATTLE STATION')", 'NONE', '3'], ['NONE', nan, 'NONE', nan, nan, nan, 'NONE', 'NONE', 'NONE', 'NONE', 'NONE', 'NONE', NaT, 'NONE', 'NONE', 'NONE', 'OPTIMUS']]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_value_counts():
		actual_df =source_df.cols.value_counts('height(ft)')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'height(ft)': {'nan': 2, '300.0': 1, '26.0': 1, '17.0': 1, '13.0': 1, '-28.0': 1}})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_value_counts_all_columns():
		actual_df =source_df.cols.value_counts('*')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding({'names': {'ironhide&': 1, 'bumbl#ebéé  ': 1, "Optim'us": 1, 'None': 1, 'Metroplex_)^$': 1, 'Megatron': 1, 'Jazz': 1}, 'height(ft)': {'nan': 2, '300.0': 1, '26.0': 1, '17.0': 1, '13.0': 1, '-28.0': 1}, 'function': {'None': 2, 'Security': 1, 'Leader': 1, 'First Lieutenant': 1, 'Espionage': 1, 'Battle Station': 1}, 'rank': {'8.0': 2, '7.0': 2, '10.0': 2, 'nan': 1}, 'age': {'5000000.0': 4, 'nan': 1, '7000000.0': 1, '4000000.0': 1}, 'weight(t)': {'nan': 2, '5.7': 1, '4.3': 1, '4.0': 1, '2.0': 1, '1.8': 1}, 'japanese name': {"['Roadbuster']": 1, "['Metroflex']": 1, "['Meister']": 1, "['Megatron']": 1, "['Inochi', 'Convoy']": 1, "['Bumble', 'Goldback']": 1, 'None': 1}, 'last position seen': {'None': 3, '37.789563,-122.400356': 1, '33.670666,-117.841553': 1, '19.442735,-99.201111': 1, '10.642707,-71.612534': 1}, 'date arrival': {'1980/04/10': 6, 'None': 1}, 'last date seen': {'None': 1, '2016/09/10': 1, '2015/08/10': 1, '2014/07/10': 1, '2013/06/10': 1, '2012/05/10': 1, '2011/04/10': 1}, 'attributes': {'[None, 5700.0]': 1, '[91.44, None]': 1, '[8.5344, 4300.0]': 1, '[7.9248, 4000.0]': 1, '[5.334, 2000.0]': 1, '[3.9624, 1800.0]': 1, 'None': 1}, 'Date Type': {'None': 1, '2016-09-10': 1, '2015-08-10': 1, '2014-06-24': 1, '2013-06-24': 1, '2012-05-10': 1, '2011-04-10': 1}, 'timestamp': {'2014-06-24': 6, 'NaT': 1}, 'Cybertronian': {'True': 6, 'None': 1}, 'function(binary)': {"bytearray(b'Security')": 1, "bytearray(b'None')": 1, "bytearray(b'Leader')": 1, "bytearray(b'First Lieutenant')": 1, "bytearray(b'Espionage')": 1, "bytearray(b'Battle Station')": 1, 'None': 1}, 'NullType': {'None': 7}, 'Mixed': {'optimus': 1, 'male': 1, 'http://hi-optimus.com': 1, '5123456789123456': 1, '3': 1, '11529': 1, '1.1.1.1': 1}})
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_variance():
		actual_df =source_df.cols.variance('height(ft)')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding(17600.3)
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_variance_all_columns():
		actual_df =source_df.cols.variance('*')
		actual_df =json_enconding(actual_df)
		expected_value =json_enconding(Dask DataFrame Structure:
                names height(ft) function     rank      age weight(t) japanese name last position seen date arrival last date seen attributes Date Type       timestamp Cybertronian function(binary) NullType   Mixed
npartitions=1                                                                                                                                                                                                         
0              object    float64   object  float64  float64   float64        object             object       object         object     object    object  datetime64[ns]       object           object   object  object
6                 ...        ...      ...      ...      ...       ...           ...                ...          ...            ...        ...       ...             ...          ...              ...      ...     ...
Dask Name: getitem, 23 tasks)
		assert(expected_value == actual_df)
	@staticmethod
	def test_cols_years_between():
		actual_df =source_df.cols.years_between('date arrival','%Y/%m/%d')
		expected_df = op.create.df({'names': 'object', 'height(ft)': 'float64', 'function': 'object', 'rank': 'float64', 'age': 'float64', 'weight(t)': 'float64', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'float64', 'last date seen': 'object', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'datetime64[ns]', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object'}, {'sample': {'columns': [{'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'rank'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}, {'title': 'Mixed'}], 'value': [["Optim'us", -28.0, 'Leader', 10.0, 4000000.0, 4.3, ['Inochi', 'Convoy'], '19.442735,-99.201111', -40.227397260273975, '2016/09/10', [8.5344, 4300.0], datetime.date(2016, 9, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Leader'), None, 'male'], ['bumbl#ebéé  ', 17.0, 'Espionage', 7.0, 5000000.0, 2.0, ['Bumble', 'Goldback'], '10.642707,-71.612534', -40.227397260273975, '2015/08/10', [5.334, 2000.0], datetime.date(2015, 8, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Espionage'), None, '1.1.1.1'], ['ironhide&', 26.0, 'Security', 7.0, 7000000.0, 4.0, ['Roadbuster'], '37.789563,-122.400356', -40.227397260273975, '2014/07/10', [7.9248, 4000.0], datetime.date(2014, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Security'), None, 'http://hi-optimus.com'], ['Jazz', 13.0, 'First Lieutenant', 8.0, 5000000.0, 1.8, ['Meister'], '33.670666,-117.841553', -40.227397260273975, '2013/06/10', [3.9624, 1800.0], datetime.date(2013, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'First Lieutenant'), None, '5123456789123456'], ['Megatron', nan, 'None', 10.0, 5000000.0, 5.7, ['Megatron'], None, -40.227397260273975, '2012/05/10', [None, 5700.0], datetime.date(2012, 5, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'None'), None, '11529'], ['Metroplex_)^$', 300.0, 'Battle Station', 8.0, 5000000.0, nan, ['Metroflex'], None, -40.227397260273975, '2011/04/10', [91.44, None], datetime.date(2011, 4, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Battle Station'), None, '3'], [None, nan, None, nan, nan, nan, None, None, nan, None, None, None, NaT, None, None, None, 'optimus']]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_years_between_multiple_columns():
		actual_df =source_df.cols.years_between(['date arrival','last date seen'],'%Y/%m/%d')
		expected_df = op.create.df({'names': 'object', 'height(ft)': 'float64', 'function': 'object', 'rank': 'float64', 'age': 'float64', 'weight(t)': 'float64', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'float64', 'last date seen': 'float64', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'datetime64[ns]', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object'}, {'sample': {'columns': [{'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'rank'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}, {'title': 'Mixed'}], 'value': [["Optim'us", -28.0, 'Leader', 10.0, 4000000.0, 4.3, ['Inochi', 'Convoy'], '19.442735,-99.201111', -40.227397260273975, -3.7835616438356166, [8.5344, 4300.0], datetime.date(2016, 9, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Leader'), None, 'male'], ['bumbl#ebéé  ', 17.0, 'Espionage', 7.0, 5000000.0, 2.0, ['Bumble', 'Goldback'], '10.642707,-71.612534', -40.227397260273975, -4.8712328767123285, [5.334, 2000.0], datetime.date(2015, 8, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Espionage'), None, '1.1.1.1'], ['ironhide&', 26.0, 'Security', 7.0, 7000000.0, 4.0, ['Roadbuster'], '37.789563,-122.400356', -40.227397260273975, -5.956164383561644, [7.9248, 4000.0], datetime.date(2014, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Security'), None, 'http://hi-optimus.com'], ['Jazz', 13.0, 'First Lieutenant', 8.0, 5000000.0, 1.8, ['Meister'], '33.670666,-117.841553', -40.227397260273975, -7.038356164383561, [3.9624, 1800.0], datetime.date(2013, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'First Lieutenant'), None, '5123456789123456'], ['Megatron', nan, 'None', 10.0, 5000000.0, 5.7, ['Megatron'], None, -40.227397260273975, -8.123287671232877, [None, 5700.0], datetime.date(2012, 5, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'None'), None, '11529'], ['Metroplex_)^$', 300.0, 'Battle Station', 8.0, 5000000.0, nan, ['Metroflex'], None, -40.227397260273975, -9.208219178082192, [91.44, None], datetime.date(2011, 4, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Battle Station'), None, '3'], [None, nan, None, nan, nan, nan, None, None, nan, nan, None, None, NaT, None, None, None, 'optimus']]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_z_score():
		actual_df =source_df.cols.z_score('height(ft)')
		expected_df = op.create.df({'names': 'object', 'height(ft)': 'float64', 'function': 'object', 'rank': 'float64', 'age': 'float64', 'weight(t)': 'float64', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'datetime64[ns]', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object'}, {'sample': {'columns': [{'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'rank'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}, {'title': 'Mixed'}], 'value': [["Optim'us", -0.7888071163227179, 'Leader', 10.0, 4000000.0, 4.3, ['Inochi', 'Convoy'], '19.442735,-99.201111', '1980/04/10', '2016/09/10', [8.5344, 4300.0], datetime.date(2016, 9, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Leader'), None, 'male'], ['bumbl#ebéé  ', -0.4095729257829497, 'Espionage', 7.0, 5000000.0, 2.0, ['Bumble', 'Goldback'], '10.642707,-71.612534', '1980/04/10', '2015/08/10', [5.334, 2000.0], datetime.date(2015, 8, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Espionage'), None, '1.1.1.1'], ['ironhide&', -0.333726087674996, 'Security', 7.0, 7000000.0, 4.0, ['Roadbuster'], '37.789563,-122.400356', '1980/04/10', '2014/07/10', [7.9248, 4000.0], datetime.date(2014, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Security'), None, 'http://hi-optimus.com'], ['Jazz', -0.44328263160870685, 'First Lieutenant', 8.0, 5000000.0, 1.8, ['Meister'], '33.670666,-117.841553', '1980/04/10', '2013/06/10', [3.9624, 1800.0], datetime.date(2013, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'First Lieutenant'), None, '5123456789123456'], ['Megatron', nan, 'None', 10.0, 5000000.0, 5.7, ['Megatron'], None, '1980/04/10', '2012/05/10', [None, 5700.0], datetime.date(2012, 5, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'None'), None, '11529'], ['Metroplex_)^$', 1.9753887613893708, 'Battle Station', 8.0, 5000000.0, nan, ['Metroflex'], None, '1980/04/10', '2011/04/10', [91.44, None], datetime.date(2011, 4, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Battle Station'), None, '3'], [None, nan, None, nan, nan, nan, None, None, None, None, None, None, NaT, None, None, None, 'optimus']]}})
		assert (expected_df.collect() == actual_df.collect())
	@staticmethod
	def test_cols_z_score_all_columns():
		actual_df =source_df.cols.z_score('*')
		expected_df = op.create.df({'names': 'object', 'height(ft)': 'float64', 'function': 'object', 'rank': 'float64', 'age': 'float64', 'weight(t)': 'float64', 'japanese name': 'object', 'last position seen': 'object', 'date arrival': 'object', 'last date seen': 'object', 'attributes': 'object', 'Date Type': 'object', 'timestamp': 'datetime64[ns]', 'Cybertronian': 'object', 'function(binary)': 'object', 'NullType': 'object', 'Mixed': 'object'}, {'sample': {'columns': [{'title': 'names'}, {'title': 'height(ft)'}, {'title': 'function'}, {'title': 'rank'}, {'title': 'age'}, {'title': 'weight(t)'}, {'title': 'japanese name'}, {'title': 'last position seen'}, {'title': 'date arrival'}, {'title': 'last date seen'}, {'title': 'attributes'}, {'title': 'Date Type'}, {'title': 'timestamp'}, {'title': 'Cybertronian'}, {'title': 'function(binary)'}, {'title': 'NullType'}, {'title': 'Mixed'}], 'value': [["Optim'us", -0.7888071163227179, 'Leader', 1.3363062095621216, -1.2998673672393632, 0.5022984399896845, ['Inochi', 'Convoy'], '19.442735,-99.201111', '1980/04/10', '2016/09/10', [8.5344, 4300.0], datetime.date(2016, 9, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Leader'), None, 'male'], ['bumbl#ebéé  ', -0.4095729257829497, 'Espionage', -1.069044967649698, -0.18569533817705217, -1.0588994140323083, ['Bumble', 'Goldback'], '10.642707,-71.612534', '1980/04/10', '2015/08/10', [5.334, 2000.0], datetime.date(2015, 8, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Espionage'), None, '1.1.1.1'], ['ironhide&', -0.333726087674996, 'Security', -1.069044967649698, 2.04264871994757, 0.2986639372911638, ['Roadbuster'], '37.789563,-122.400356', '1980/04/10', '2014/07/10', [7.9248, 4000.0], datetime.date(2014, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Security'), None, 'http://hi-optimus.com'], ['Jazz', -0.44328263160870685, 'First Lieutenant', -0.2672612419124249, -0.18569533817705217, -1.1946557491646554, ['Meister'], '33.670666,-117.841553', '1980/04/10', '2013/06/10', [3.9624, 1800.0], datetime.date(2013, 6, 24), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'First Lieutenant'), None, '5123456789123456'], ['Megatron', nan, 'None', 1.3363062095621216, -0.18569533817705217, 1.4525927859161152, ['Megatron'], None, '1980/04/10', '2012/05/10', [None, 5700.0], datetime.date(2012, 5, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'None'), None, '11529'], ['Metroplex_)^$', 1.9753887613893708, 'Battle Station', -0.2672612419124249, -0.18569533817705217, nan, ['Metroflex'], None, '1980/04/10', '2011/04/10', [91.44, None], datetime.date(2011, 4, 10), Timestamp('2014-06-24 00:00:00'), True, bytearray(b'Battle Station'), None, '3'], [None, nan, None, nan, nan, nan, None, None, None, None, None, None, NaT, None, None, None, 'optimus']]}})
		assert (expected_df.collect() == actual_df.collect())
