import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * Schema for Module Fragment of type AwsCommunity::S3::Bucket::MODULE
 *
 * @schema CfnBucketModuleProps
 */
export interface CfnBucketModuleProps {
    /**
     * @schema CfnBucketModuleProps#Parameters
     */
    readonly parameters?: CfnBucketModulePropsParameters;
    /**
     * @schema CfnBucketModuleProps#Resources
     */
    readonly resources?: CfnBucketModulePropsResources;
}
/**
 * Converts an object of type 'CfnBucketModuleProps' to JSON representation.
 */
export declare function toJson_CfnBucketModuleProps(obj: CfnBucketModuleProps | undefined): Record<string, any> | undefined;
/**
 * @schema CfnBucketModulePropsParameters
 */
export interface CfnBucketModulePropsParameters {
    /**
     * The name of the bucket
     *
     * @schema CfnBucketModulePropsParameters#BucketName
     */
    readonly bucketName?: CfnBucketModulePropsParametersBucketName;
    /**
     * The name of the log bucket
     *
     * @schema CfnBucketModulePropsParameters#LogBucketName
     */
    readonly logBucketName?: CfnBucketModulePropsParametersLogBucketName;
}
/**
 * Converts an object of type 'CfnBucketModulePropsParameters' to JSON representation.
 */
export declare function toJson_CfnBucketModulePropsParameters(obj: CfnBucketModulePropsParameters | undefined): Record<string, any> | undefined;
/**
 * @schema CfnBucketModulePropsResources
 */
export interface CfnBucketModulePropsResources {
    /**
     * @schema CfnBucketModulePropsResources#LogBucket
     */
    readonly logBucket?: CfnBucketModulePropsResourcesLogBucket;
    /**
     * @schema CfnBucketModulePropsResources#CompliantBucket
     */
    readonly compliantBucket?: CfnBucketModulePropsResourcesCompliantBucket;
}
/**
 * Converts an object of type 'CfnBucketModulePropsResources' to JSON representation.
 */
export declare function toJson_CfnBucketModulePropsResources(obj: CfnBucketModulePropsResources | undefined): Record<string, any> | undefined;
/**
 * The name of the bucket
 *
 * @schema CfnBucketModulePropsParametersBucketName
 */
export interface CfnBucketModulePropsParametersBucketName {
    /**
     * @schema CfnBucketModulePropsParametersBucketName#Type
     */
    readonly type: string;
    /**
     * @schema CfnBucketModulePropsParametersBucketName#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnBucketModulePropsParametersBucketName' to JSON representation.
 */
export declare function toJson_CfnBucketModulePropsParametersBucketName(obj: CfnBucketModulePropsParametersBucketName | undefined): Record<string, any> | undefined;
/**
 * The name of the log bucket
 *
 * @schema CfnBucketModulePropsParametersLogBucketName
 */
export interface CfnBucketModulePropsParametersLogBucketName {
    /**
     * @schema CfnBucketModulePropsParametersLogBucketName#Type
     */
    readonly type: string;
    /**
     * @schema CfnBucketModulePropsParametersLogBucketName#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnBucketModulePropsParametersLogBucketName' to JSON representation.
 */
export declare function toJson_CfnBucketModulePropsParametersLogBucketName(obj: CfnBucketModulePropsParametersLogBucketName | undefined): Record<string, any> | undefined;
/**
 * @schema CfnBucketModulePropsResourcesLogBucket
 */
export interface CfnBucketModulePropsResourcesLogBucket {
    /**
     * @schema CfnBucketModulePropsResourcesLogBucket#Type
     */
    readonly type?: string;
    /**
     * @schema CfnBucketModulePropsResourcesLogBucket#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnBucketModulePropsResourcesLogBucket' to JSON representation.
 */
export declare function toJson_CfnBucketModulePropsResourcesLogBucket(obj: CfnBucketModulePropsResourcesLogBucket | undefined): Record<string, any> | undefined;
/**
 * @schema CfnBucketModulePropsResourcesCompliantBucket
 */
export interface CfnBucketModulePropsResourcesCompliantBucket {
    /**
     * @schema CfnBucketModulePropsResourcesCompliantBucket#Type
     */
    readonly type?: string;
    /**
     * @schema CfnBucketModulePropsResourcesCompliantBucket#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnBucketModulePropsResourcesCompliantBucket' to JSON representation.
 */
export declare function toJson_CfnBucketModulePropsResourcesCompliantBucket(obj: CfnBucketModulePropsResourcesCompliantBucket | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `AwsCommunity::S3::Bucket::MODULE`
 *
 * @cloudformationResource AwsCommunity::S3::Bucket::MODULE
 * @stability external
 * @link http://unknown-url
 */
export declare class CfnBucketModule extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "AwsCommunity::S3::Bucket::MODULE";
    /**
     * Resource props.
     */
    readonly props: CfnBucketModuleProps;
    /**
     * Create a new `AwsCommunity::S3::Bucket::MODULE`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnBucketModuleProps);
}
