# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['filetreesubs']

package_data = \
{'': ['*']}

install_requires = \
['PyYAML', 'setuptools>=20.3']

extras_require = \
{':python_version >= "2.7" and python_version < "3.0"': ['doit>=0.28.0,<=0.29.0'],
 ':python_version >= "3.5" and python_version < "4.0"': ['doit>=0.28.0']}

entry_points = \
{'console_scripts': ['filetreesubs = filetreesubs.__main__:main']}

setup_kwargs = {
    'name': 'filetreesubs',
    'version': '1.1.0',
    'description': 'Synchronize a file tree with text file substitutions',
    'long_description': 'File Tree Subs\n==============\n\nAllows to synchronize a destination file tree from a source file tree\nwhile allowing certain substitutions to take place.\n\nFile Tree Subs uses `doit <http://pydoit.org/>`__ under the hood to keep\ntrack of changes, so that files are only changed if necessary.\n\nSee the following three examples for typical use cases of\n``filetreesubs``. I\'m personally using it to preprocess the output of\n`Nikola <https://getnikola.com/>`__, a static blog/site generator, to\ninsert a sidebar into all generated HTML pages, and a tag cloud into\nthe sidebar and the tag overview page.\n\nTo install, use ``pip install filetreesubs``.\n\n\nExample\n-------\n\nAssume you have the following file tree::\n\n    input/\n        index.html\n        team.html\n        products.html\n        menu.inc\n        testimonials.inc\n\nIn the ``.html`` files, you put placeholder strings ``INSERT_MENU_HERE`` for where\nthe content of ``input/menu.inc`` should be inserted, and ``INSERT_TESTIMONIALS``\nfor where the content of ``input/testimonials.inc`` should be inserted. Also, you\nwant ``COPYRIGHT_YEAR`` to be replaced by 2017. The result should be a tree like\nthis, without the ``.inc`` files::\n\n    output/\n        index.html\n        team.html\n        products.html\n\nwith the placeholder string replaced. To do this with ``filetreesubs``, create a\nconfig file ``filetreesubs-config.yaml``::\n\n    # Source directory\n    source: input\n    # Destination directory\n    destination: output\n    substitutes:\n      # The following is a regular expression to match the filenames:\n      \'.*\\.html\':\n        # The strings to replace\n        \'INSERT_MENU_HERE\':\n          # With what to replace them\n          file: menu.inc\n        \'INSERT_TESTIMONIALS\':\n          file: testimonials.inc\n        \'COPYRIGHT_YEAR\':\n          text: \'2017\'\n\nThen running ``filetreesubs`` will synchornize ``output/`` so that it contains\nthe files from ``input/``, except ``menu.inc``, and makes sure the substitutions\ntake place.\n\n\nExample: Sidebar in Nikola\n--------------------------\n\nYou can find an example site for Nikola using the `sidebar plugin <https://plugins.getnikola.com/v7/sidebar/>`__\nin `the Github repository felixfontein/filetreesubs-nikola-demo <https://github.com/felixfontein/filetreesubs-nikola-demo/>`__.\n\nA more complex, but less explicit example can be found `in my blog <https://spielwiese.fontein.de/2017/01/06/static-sidebar-and-tag-cloud/>`__,\nwhich also includes a tag cloud (rendered by the `static_tag_cloud pugin <https://plugins.getnikola.com/v7/static_tag_cloud/>`__)\ninto the sidebar.\n\n\nExample: Substitution chains\n----------------------------\n\nAssume that in the above example, you want to use ``INSERT_TESTIMONIALS`` also in\n``menu.inc`` itself. Running the above example, this substitution will not be done,\nalso if you extend the regular expression matching all HTML files to ``.*`` to\nmatch all files.\n\nTo apply substitutions to included files, you need to use substitution chains.\nAppend the following to the configuration above::\n\n    substitute_chains:\n    - template: menu.inc\n      substitutes:\n        \'INSERT_TESTIMONIALS\':\n          file: testimonials.inc\n\nThis will apply the substitution for ``INSERT_TESTIMONIALS`` also to ``menu.inc``.\n\n\nExample: Creating index files\n-----------------------------\n\nAssume that you have folder structure::\n\n    input/\n        index.html\n        images/\n            logo.jpeg\n            2017/\n                happynewyear-2017.jpeg\n\nYou want to upload the output to a web server so it is available under\n``http://example.com``, but if someone accesses ``http://example.com/images/``\nor ``http://example.com/images/2017/``, you don\'t want the persons to see a\nfile listing or some error page, but show them a nice message to check out\nthe home page. You can use ``filetreesubs`` for this. Add the following\nto the configuration::\n\n    create_index_filename: index.html\n    create_index_content: |\n      <!DOCTYPE html>\n      <html>\n        <head>\n          <title>There\'s nothing to see here.</title>\n          <meta http-equiv="refresh" content="10; url=..">\n        </head>\n        <body>\n          There\'s nothing to see here. Go <a href="..">here</a> instead.\n          You will be automatically redirected there in 10 seconds.\n        </body>\n      </html>\n\nThen in every folder not containing a file ``index.html``, a file\n``index.html`` will be created with the specified content.\n\n\nConfiguration file format\n-------------------------\n\nThe configuration file is in `YAML format <https://en.wikipedia.org/wiki/YAML>`__.\nBy default, the configuration is assumed to be in ``filetreesubs-config.yaml``\nin the current directory. If you want to specify a different configuration file\nname, you can simply specify it on the command line::\n\n    filetreesubs my-config-file.yaml\n\nThe following commented YAML file shows all available options::\n\n    # The source directory. Specify a path here.\n    source: input\n\n    # The destination directory. Specify a path here.\n    destination: output\n\n    # The substitutions to make\n    substitutes:\n      # For every substitution, you need to specify a regex pattern\n      # matching the file name. Use \'.*\' to match everything, and\n      # \'.*\\.html\' to match all files ending with \'.html\'.\n      \'.*\':\n        # Now you can specify a number of strings which shall be replaced\n        \'STRING TO REPLACE\':\n          # In this case, we want to replace the string by the contents\n          # of the file menu.inc. Note that menu.inc won\'t be copied\n          # to the destination directory anymore.\n          file: menu.inc\n        \'ANOTHER_REPLACEMENT_STRING\':\n          # In this case, we want to replace the string by another string\n          # we explicitly specify here.\n          text: \'(replacement text)\'\n      # Now we can specify more filename matching patterns ...\n      \'.*\\.html\':\n        # ... and more replacements\n        \'YET_ANOTHER_STRING\':\n          text: \'(some more)\'\n\n    # To do substitutions in files like menu.inc, we need substitution\n    # chains.\n    substitute_chains:\n    # Each substitution chain consists of the name of the file to\n    # substitute in, like menu.inc:\n    - template: menu.inc\n      # As well as a list of substitutions, using the same syntax as above:\n      substitutes:\n        # The string to replace:\n        \'INCLUDE_INCLUDE\':\n          # What to replace it with\n          file: include.inc\n        \'INCLUDE_STRING\':\n          text: \'...\'\n    # You can have as many substitution chains as you want\n    - template: include.inc\n      substitutes:\n        \'ONE_MORE\':\n          text: \'(...)\'\n\n    # To create index files (when not already existing), you must\n    # specify the name of these files:\n    create_index_filename: index.html\n\n    # This allows to specify the content of index files.\n    create_index_content: |\n      <!DOCTYPE html>\n      <html lang="en">\n        <head>\n          <title>there\'s nothing to see here.</title>\n          <meta name="robots" content="noindex">\n          <meta http-equiv="refresh" content="0; url=..">\n        </head>\n        <body style="background-color:black; color:white;">\n          <div style="position:absolute; top:0; left:0; right:0; bottom:0;">\n            <div style="width:100%; height:100%; display:table;">\n                there\'s nothing to see here. go <a href=".." style="color:#AAA;">here</a> instead.\n              </div>\n            </div>\n          </div>\n        </body>\n      </html>\n\n    # By default, filetreesubs assumes that all text files it processes\n    # are UTF-8 encoded. If that\'s not the case, you can change another\n    # encoding here.\n    encoding: utf-8\n\n    # In case you need to do so, you can insert configurations for doit\n    # directly here. See `here <http://pydoit.org/configuration.html#configuration-at-dodo-py>`__\n    # for possible configurations.\n    doit_config:\n      # The following option sets the filename for the dependency database.\n      # If you want to execute different filetreesubs commands concurrently\n      # from a folder, you need to specify different dependency database\n      # names per project config.\n      dep_file: \'.doit-myproject.db\'\n',
    'author': 'Felix Fontein',
    'author_email': 'felix@fontein.de',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/felixfontein/filetreesubs',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=2.7, !=3.0.*, !=3.1.*, !=3.2.*, !=3.3.*, !=3.4.*',
}


setup(**setup_kwargs)
