"""
Django settings for sample_project project.

Generated by 'django-admin startproject' using Django 3.1.7.

For more information on this file, see
https://docs.djangoproject.com/en/3.1/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/3.1/ref/settings/
"""

DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.sqlite3',
        'NAME': ':memory:',
    },
}

INSTALLED_APPS = (
    'adminlte2_pdq',
    'tests',
    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.staticfiles',
)

MIDDLEWARE = [
    'django.middleware.security.SecurityMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
    'adminlte2_pdq.middleware.AuthMiddleware',
]

ROOT_URLCONF = 'tests.urls'

USE_TZ = True

TIME_ZONE = 'UTC'

SECRET_KEY = 'test_secret_key'

TEMPLATES = [{
    'BACKEND': 'django.template.backends.django.DjangoTemplates',
    'APP_DIRS': True,
    'OPTIONS': {
        'context_processors': [
            'django.template.context_processors.request',
            'django.contrib.auth.context_processors.auth',
            'django.contrib.messages.context_processors.messages',
        ],
    },
}]


STATIC_URL = '/static/'


DEFAULT_AUTO_FIELD = 'django.db.models.BigAutoField'

# Make messaging work in tests that use RequestFactory.
MESSAGE_STORAGE = 'django.contrib.messages.storage.cookie.CookieStorage'


#**********************************************
# Added settings to make adminlte2_pdq work
#**********************************************
# Default Profile route does not exist. Change to Home.
LOGIN_REDIRECT_URL = 'adminlte2_pdq:home'

ADMINLTE2_ADMIN_INDEX_USE_APP_LIST = True
ADMINLTE2_INCLUDE_ADMIN_HOME_LINK = True
ADMINLTE2_INCLUDE_MAIN_NAV_ON_ADMIN_PAGES = True
ADMINLTE2_INCLUDE_ADMIN_NAV_ON_MAIN_PAGES = True

# ADMINLTE2_MENU_FIRST = []
# ADMINLTE2_MENU = []
# Admin Menu Rendered Between MENU and MENU_LAST
# ADMINLTE2_MENU_LAST = []

# WhiteList
# ADMINLTE2_USE_STRICT_POLICY = (True/False)
# ADMINLTE2_STRICT_POLICY_WHITELIST = []
