# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['scm_config']

package_data = \
{'': ['*']}

install_requires = \
['colorama>=0.4.4,<0.5.0',
 'deepdiff>=5.7.0,<6.0.0',
 'dynaconf>=3.1.5,<4.0.0',
 'ordered-set>=4.0.2,<5.0.0',
 'pytest>=7.0.1,<8.0.0',
 'typer>=0.4.1,<0.5.0',
 'wheel>=0.37.1,<0.38.0']

entry_points = \
{'console_scripts': ['scm = scm_config.main:main_cli']}

setup_kwargs = {
    'name': 'scm-config',
    'version': '0.3.2',
    'description': 'self configuration management written in Python',
    'long_description': '# SCM\nSelf Managed Configuration Management(SCM) is a simple command line app for configuration management, written in python.\n> Designed to run only on ubuntu operating system\n\nThis tool, currently supports below resources \n* service\n* directory\n* file \n* firewall\n>A resource definition in scm is directly related to the action of standard linux commands, example. service, directories, files.\n\n>pre-requisites install python3 environment on the machine\n# Usage\n```bash \npip install scm-config\n```\n\n```bash\nUsage: scm [OPTIONS] COMMAND [ARGS]...\n\nOptions:\n  -v, --version                   Display\'\'s the application version\n  --install-completion [bash|zsh|fish|powershell|pwsh]\n                                  Install completion for the specified shell.\n  --show-completion [bash|zsh|fish|powershell|pwsh]\n                                  Show completion for the specified shell, to\n                                  copy it or customize the installation.\n  --help                          Show this message and exit.\n\nCommands:\n  create\n  diff\n  info\n  init\n  push\n  remove\n  validate\n```\n\n# Commands overview \n\n| command  | command description                                                                                                                      | usage                                                               | Example                                           |   |\n|----------|------------------------------------------------------------------------------------------------------------------------------------------|---------------------------------------------------------------------|---------------------------------------------------|---|\n| init     | Used for initialization, creates necessary files and directories for the tool to store configuration.                                                                        | scm init                                                            |                                                   |   |\n| create   | Creates the receipe .toml file in the config directory based on the receipe name                                                         | scm create --receipe <name>                                         | scm create --receipe apache                       |   |\n| validate | Validates the receipe file configuration based on the standard defined resources                                                         | scm validate --receipe <name>                                       | scm validate --receipe apache                     |   |\n| info     | Lists the configurations that are defined in the receipe file                                                                            | scm info --receipe <name>                                           | scm info --receipe apache                         |   |\n| diff     | Lists the differences between the existing and the current configuration, if this is this is new receipe, outputs all the configurations | scm diff --receipe <name>                                           | scm diff --receipe apache                         |   |\n| push     | Pushes the configuration defined in the receipe file to the operating system and stores the configuration in config_hash_directory       | scm push --receipe <name>                                           | scm push --receipe apache                         |   |\n| remove   | Removes the configuration from the hash directory and also removes the receipe file from the config directory                            | scm push --receipe <name> [optional --force [optional --clean-files | scm remove --receipe apache --force --clean-files |   |\n\n\n# Resource Detailed information \n## Service \nService resource is useful for installing and managing packages from the linux repository, \n> Note that currently this tool is designed to support only on Ubuntu Operating System\n\n***Name parameter in the below section is a list format, meaning it can take multiple values and the actions and other parameters are applied to each name resource accordingly**\n### Example \n```\n[service.setup]\nname = ["apache2"] \naction= ["install", "enable"]\n```\nIn the above example, "service" is the resource and "setup" is the service identifier. \n* name  -> Name of the service that is to be installed on the ubuntu system \n* action -> Action to be done on the listed service, currently these are only supported \n> ["install", "enable", "disable"]\n\n```\n[service.ops]\nname = ["apache2"]\naction =["restart"]\n```\nIn the above example, "service" is the resource and "ops" is the service identifier. once the service is installed and service operations can be done using this tool. \n* name  -> Name of the service that is to be installed on the ubuntu system \n* action -> Action to be done on the listed service, currently these are only supported \n> ["stop", "start", "restart", "reload", "disable", "enable"]\n\n## Directory\nDirectory resource is useful for installing and managing the metadata directories on the system, \n> Note that currently this resource is tested only on Ubuntu Operating System, but can run on any Linux Operating System\n\n### Example \n```\n# Modify the directory permissions \n[directory.list]\nname = ["/etc/apache"] \nparams = {\'owner\'=\'root\',\'group\'=\'root\',\'mode\'= \'0755\'}\naction = [\'create\']\nnotifies = "@format {this.service.ops}"\n```\nIn the above example, "directory" is the resource and "list" is the service identifier. \n* name  -> Name of the directory where the metadata needs modification including creation of the directory using the action method\n* params -> parameter to support the directory operations, currently [\'owner\', \'group\' and \'mode\'] are supported in the list \n* action -> Action to be done on the listed service, currently for directories only [\'create\'] is supported\n* notifies -> Parameter to notify any other resource in the same recipe file, In example, notifies the service ops resources, that would restart the apache2 service based on the modifications \n> ["install", "enable", "disable"]\n\n### Example \n```\n# Modify the input content of the file \n[file.conf]\nname = ["/var/www/customers/public_html/index.php"]\naction = ["create"]\noverride ="true"\ncontent  = ["This is the test file"]\nparams = {\'owner\'= \'root\',\'group\'= \'root\',\'mode\' = \'0755\'}\nnotifies = "@format {this.service.ops}"\n\n```\nIn the above example, "file" is the resource and "conf" is the service identifier. \n* name  -> Name of the file where the content need to be added or appended based on the configuration requirement\n* action -> Action to be done on the listed service, currently for file only [\'create\'] is supported\n* override -> This parameter will override if there is any existing file, default it will append the content to the file \n* content -> Input content for the file provide in the form the double quotes. For simplicity ,large content is not tested with the current version of the code. \n* params -> parameter to support the file operations, currently [\'owner\', \'group\' and \'mode\'] are supported in the list \n* notifies -> Parameter to notify any other resource in the same recipe file, In example, notifies the service ops resources, that would restart the apache2 service based on the modifications \n> ["install", "enable", "disable"]\n\n# Complete overview of the example file \n\n```toml\n# Service setup for the apache instance \n[service.setup]\nname = ["apache2"] \naction= ["install", "enable"]\n\n# Service restart for the apache instance \n[service.ops]\nname = ["apache2"]\naction =["restart"]\n\n\n# Modify the directory permissions \n[directory.list]\nname = ["/etc/apache"] \nparams = {\'owner\'=\'root\',\'group\'=\'root\',\'mode\'= \'0755\'}\naction = [\'create\']\nnotifies = "@format {this.service.ops}"\n\n# Modify the input content of the file \n[file.conf]\nname = ["/var/www/customers/public_html/index.php"]\naction = ["create"]\ncontent  = ["This is the test file"]\nparams = {\'owner\'= \'root\',\'group\'= \'root\',\'mode\' = \'0755\'}\nnotifies = "@format {this.service.ops}"\n```\n# Installation and Usage # \n\n## Manual clone\n```bash\n  $ git clone https://github.com/Sai-Repalle/scm_project\n  $ cd scm_project\n  $ python3 -m venv venv \n  $ source venv/bin/activate\n  $ pip install -r requirements.txt \n```\n\n## initialization\ninit command is used for initialization and helpful to create the respective directories, also this command is useful for expanding future versions of the scm tool\n\n`init`\nInitialize the tool without any parameters, this would set the configuration files required for tool to work\n```bash\n$ scm init\n```\n### output \n```bash   \nscm init\n[INFO][04-22-2022 06:08:13]::Reading the Json configuration /root/scm/scm/settings/settings.json\n[INFO][04-22-2022 06:08:13]::creating directory CONFIG_DIR\n[INFO][04-22-2022 06:08:13]::creating directory CONFIG_HASH_DIR\n[INFO][04-22-2022 06:08:13]::creating files CONFIG_DEF_FILE\n[INFO][04-22-2022 06:08:13]::creating files CONFIG_HASH_FILE\n\n```\n## create\n`create <name>`\n```bash\n$ scm create --receipe <receipe>\n```\nBelow example, will create a receipe called "apache" and `apache.toml` file is created in the config directory located at the root directory of the scm \n### output \n```bash\nscm create --receipe apache\n[INFO][04-22-2022 06:09:56]::Reading the Json configuration /root/scm/scm/settings/settings.json\n[INFO][04-22-2022 06:09:56]::creating directory CONFIG_DIR\n[INFO][04-22-2022 06:09:56]::CONFIG_DIR directory already exists\n[INFO][04-22-2022 06:09:56]::creating directory CONFIG_HASH_DIR\n[INFO][04-22-2022 06:09:56]::CONFIG_HASH_DIR directory already exists\n[INFO][04-22-2022 06:09:56]::creating files CONFIG_DEF_FILE\n[INFO][04-22-2022 06:09:56]::creating files CONFIG_HASH_FIL\n```\n\n\n## info\n`info --receipe <name>`\n```bash\n$ scm info --receipe <receipe>\n```\nBelow example, info command is listing all the resources and its actions based on the configuration defined in the receipe file.\n### output \n```bash\nscm info --receipe apache\n[INFO][04-25-2022 02:00:37]::Reading the Json configuration /root/scm/settings.json\n[INFO][04-25-2022 02:00:37]::creating directory CONFIG_DIR\n[INFO][04-25-2022 02:00:37]::CONFIG_DIR directory already exists\n[INFO][04-25-2022 02:00:37]::creating directory CONFIG_HASH_DIR\n[INFO][04-25-2022 02:00:37]::CONFIG_HASH_DIR directory already exists\n[INFO][04-25-2022 02:00:37]::creating files CONFIG_DEF_FILE\n[INFO][04-25-2022 02:00:37]::creating files CONFIG_HASH_FILE\n[INFO][04-25-2022 02:00:37]::SERVICE.setup - {\'name\': [\'apache2\'], \'action\': [\'install\', \'enable\', \'start\']}\n[INFO][04-25-2022 02:00:37]::SERVICE.ops - {\'name\': [\'apache2\'], \'action\': [\'restart\']}\n[INFO][04-25-2022 02:00:37]::SERVICE.setup_php - {\'name\': [\'php\', \'libapache2-mod-php\'], \'action\': [\'install\']}\n[INFO][04-25-2022 02:00:37]::FIREWALL.setup - {\'name\': [\'Apache\'], \'action\': [\'allow\']}\n[INFO][04-25-2022 02:00:37]::FILE.conf - {\'name\': [\'/var/www/html/index.php\'], \'action\': [\'create\'], \'override\': \'true\', \'content\': [\'<?php\\n header("Content-Type: text/plain");\\n echo "Hello, world!\\n";\\n\'], \'params\': {\'owner\': \'root\', \'group\': \'root\', \'mode\': \'0755\'}, \'notifies\': "{\'name\': [\'apache2\'], \'action\': [\'restart\']}"}\n[INFO][04-25-2022 02:00:37]::FILE.phpindex - {\'name\': [\'/etc/apache2/mods-enabled/dir.conf\'], \'action\': [\'create\'], \'override\': \'true\', \'content\': [\'<IfModule mod_dir.c>\\n DirectoryIndex index.php index.html index.cgi index.pl index.xhtml index.htm </IfModule>\'], \'params\': {\'owner\': \'root\', \'group\': \'root\', \'mode\': \'0755\'}, \'notifies\': "{\'name\': [\'apache2\'], \'action\': [\'restart\']}"}\n```\n\n## validate\n`validate -receipe <name>`\n```bash\n$ scm validate --receipe <receipe>\n```\nBelow example, validate command is validating all the resources and its actions based on the configuration defined in the receipe file, If all the resources and its configurations are in valid state, receipe would output to do next step, if there are any issues, please refere to the documentation.\n### output  \n```bash\nscm validate --receipe apache\n[INFO][04-25-2022 02:01:47]::Reading the Json configuration /root/scm/settings.json\n[INFO][04-25-2022 02:01:47]::creating directory CONFIG_DIR\n[INFO][04-25-2022 02:01:47]::CONFIG_DIR directory already exists\n[INFO][04-25-2022 02:01:47]::creating directory CONFIG_HASH_DIR\n[INFO][04-25-2022 02:01:47]::CONFIG_HASH_DIR directory already exists\n[INFO][04-25-2022 02:01:47]::creating files CONFIG_DEF_FILE\n[INFO][04-25-2022 02:01:47]::creating files CONFIG_HASH_FILE\n[INFO][04-25-2022 02:01:47]::apache receipe file is valid for push, use `scm diff` to differences with the existing configuration\n```\n\n## diff\n`diff -receipe <name>`\n```bash\n$ scm diff --receipe <receipe>\n```\nIn the below example, if the confiugration in the receipe file is already appplied, scm would output that the configuration is update to date with the existing configuration \n```bash\n[INFO][04-25-2022 02:05:00]::Reading the Json configuration /root/scm/settings.json\n[INFO][04-25-2022 02:05:00]::Reading the Json configuration /root/scm/settings.json\n[INFO][04-25-2022 02:05:00]::creating directory CONFIG_DIR\n[INFO][04-25-2022 02:05:00]::CONFIG_DIR directory already exists\n[INFO][04-25-2022 02:05:00]::creating directory CONFIG_HASH_DIR\n[INFO][04-25-2022 02:05:00]::CONFIG_HASH_DIR directory already exists\n[INFO][04-25-2022 02:05:00]::creating files CONFIG_DEF_FILE\n[INFO][04-25-2022 02:05:00]::creating files CONFIG_HASH_FILE\n[INFO][04-25-2022 02:05:00]::apache receipe file is valid for push, use `scm diff` to differences with the existing configuration\n[INFO][04-25-2022 02:05:00]::Reading the Json configuration config_hash/hash_config_md5.json\n[INFO][04-25-2022 02:05:00]::`apache` configuration is update to date with the existing configuration\n```\nIn the below example, if the configuration in the receipe file is pushed to the operating system to install the required services \n```bash\nroot@ip-172-31-255-140:~/scm/config# scm diff --receipe apache_remove\n[INFO][04-25-2022 02:20:37]::Reading the Json configuration /root/scm/config/settings.json\n[INFO][04-25-2022 02:20:37]::Reading the Json configuration /root/scm/config/settings.json\n[INFO][04-25-2022 02:20:37]::creating directory CONFIG_DIR\n[INFO][04-25-2022 02:20:37]::CONFIG_DIR directory already exists\n[INFO][04-25-2022 02:20:37]::creating directory CONFIG_HASH_DIR\n[INFO][04-25-2022 02:20:37]::CONFIG_HASH_DIR directory already exists\n[INFO][04-25-2022 02:20:37]::creating files CONFIG_DEF_FILE\n[INFO][04-25-2022 02:20:37]::CONFIG_DEF_FILE file already exists\n[INFO][04-25-2022 02:20:37]::creating files CONFIG_HASH_FILE\n[INFO][04-25-2022 02:20:37]::apache_remove receipe file is valid for push, use `scm diff` to differences with the existing configuration\n[INFO][04-25-2022 02:20:37]::Reading the Json configuration config_hash/hash_config_md5.json\n[INFO][04-25-2022 02:20:37]::Following resources will be applied:\n[INFO][04-25-2022 02:20:37]::SERVICE.setup: [\'systemctl stop apache2\', \'systemctl disable apache2\', \'sudo apt-get update -y\', \'sudo apt-get remove apache2 -y\']\n[INFO][04-25-2022 02:20:37]::Following resources will be applied:\n[INFO][04-25-2022 02:20:37]::SERVICE.setup_php: [\'sudo apt-get update -y\', \'sudo apt-get remove php -y\', \'sudo apt-get update -y\', \'sudo apt-get remove libapache2-mod-php -y\']\n```\n## push\n`push -receipe <name>`\n```bash\n$ scm push --receipe <receipe>\n```\nIn the below example, scm push is pushing hte receipe named "apache_remove" and the subsequent commands are being run on the operating to the remove the services \n### output\n```bash\nroot@ip-172-31-255-140:~/scm/config# scm push  --receipe apache_remove\n[INFO][04-25-2022 02:21:34]::Reading the Json configuration /root/scm/config/settings.json\n[INFO][04-25-2022 02:21:34]::Reading the Json configuration /root/scm/config/settings.json\n[INFO][04-25-2022 02:21:34]::creating directory CONFIG_DIR\n[INFO][04-25-2022 02:21:34]::CONFIG_DIR directory already exists\n[INFO][04-25-2022 02:21:34]::creating directory CONFIG_HASH_DIR\n[INFO][04-25-2022 02:21:34]::CONFIG_HASH_DIR directory already exists\n[INFO][04-25-2022 02:21:34]::creating files CONFIG_DEF_FILE\n[INFO][04-25-2022 02:21:34]::CONFIG_DEF_FILE file already exists\n[INFO][04-25-2022 02:21:34]::creating files CONFIG_HASH_FILE\n[INFO][04-25-2022 02:21:34]::apache_remove receipe file is valid for push, use `scm diff` to differences with the existing configuration\n[INFO][04-25-2022 02:21:34]::Reading the Json configuration config_hash/hash_config_md5.json\n[INFO][04-25-2022 02:21:34]::Reading the Json configuration /root/scm/config/settings.json\n[INFO][04-25-2022 02:21:34]::Following resources will be applied:\n[INFO][04-25-2022 02:21:34]::SERVICE.setup: [\'systemctl stop apache2\', \'systemctl disable apache2\', \'sudo apt-get update -y\', \'sudo apt-get remove apache2 -y\']\n[INFO][04-25-2022 02:21:34]::Applying the command `systemctl stop apache2`\n[INFO][04-25-2022 02:21:35]::Applying the command `systemctl disable apache2`\nSynchronizing state of apache2.service with SysV service script with /lib/systemd/systemd-sysv-install.\nExecuting: /lib/systemd/systemd-sysv-install disable apache2\n[INFO][04-25-2022 02:21:35]::Applying the command `sudo apt-get update -y`\nHit:1 http://us-east-1.ec2.archive.ubuntu.com/ubuntu bionic InRelease\nGet:2 http://us-east-1.ec2.archive.ubuntu.com/ubuntu bionic-updates InRelease [88.7 kB]\nGet:3 http://us-east-1.ec2.archive.ubuntu.com/ubuntu bionic-backports InRelease [74.6 kB]\nGet:4 http://security.ubuntu.com/ubuntu bionic-security InRelease [88.7 kB]\nFetched 252 kB in 0s (666 kB/s)\nReading package lists... Done\n[INFO][04-25-2022 02:21:42]::Applying the command `sudo apt-get remove apache2 -y`\nReading package lists... Done\nBuilding dependency tree\nReading state information... Done\nThe following packages were automatically installed and are no longer required:\n  apache2-data apache2-utils ssl-cert\nUse \'sudo apt autoremove\' to remove them.\nThe following packages will be REMOVED:\n  apache2\n0 upgraded, 0 newly installed, 1 to remove and 2 not upgraded.\nAfter this operation, 537 kB disk space will be freed.\n(Reading database ... 94525 files and directories currently installed.)\nRemoving apache2 (2.4.29-1ubuntu4.22) ...\nProcessing triggers for man-db (2.8.3-2ubuntu0.1) ...\nProcessing triggers for ufw (0.36-0ubuntu0.18.04.2) ...\nRules updated for profile \'Apache\'\n\n```\n\n## remove\n`remove --receipe <name> --force <optional> --clean_files <optional>`\n```bash\n$ scm push --receipe <receipe>',
    'author': 'Sai Repalle',
    'author_email': 'n.repalle85@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/Sai-Repalle/scm_project',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
