/* Automatically generated file. Do not edit. 
 * Format:     ANSI C source code
 * Creator:    McStas <http://www.mcstas.org>
 * Instrument: MACS_sample_kidney_box.instr (dmtas)
 * Date:       Thu Jul 15 11:56:17 2021
 * File:       MACS_sample_kidney_box.c
 * Compile:    cc -o dmtas.out MACS_sample_kidney_box.c  -I@MCCODE_LIB@/share/
 * CFLAGS= -I@MCCODE_LIB@/share/
 */


#define MCCODE_STRING "McStas 2.7 - Nov. 27, 2020"
#define FLAVOR "mcstas"
#define FLAVOR_UPPER "MCSTAS"
#define MC_USE_DEFAULT_MAIN
#define MC_EMBEDDED_RUNTIME

#line 1 "mccode-r.h"
/*******************************************************************************
*
* McCode, neutron/xray ray-tracing package
*         Copyright (C) 1997-2009, All rights reserved
*         Risoe National Laboratory, Roskilde, Denmark
*         Institut Laue Langevin, Grenoble, France
*
* Runtime: share/mccode-r.h
*
* %Identification
* Written by: KN
* Date:    Aug 29, 1997
* Release: McStas 2.7
* Version: $Revision$
*
* Runtime system header for McStas/McXtrace.
*
* In order to use this library as an external library, the following variables
* and macros must be declared (see details in the code)
*
*   struct mcinputtable_struct mcinputtable[];
*   int mcnumipar;
*   char mcinstrument_name[], mcinstrument_source[];
*   int mctraceenabled, mcdefaultmain;
*   extern MCNUM  mccomp_storein[];
*   extern MCNUM  mcAbsorbProp[];
*   extern MCNUM  mcScattered;
*   #define MCCODE_STRING "the McStas/McXtrace version"
*
* Usage: Automatically embbeded in the c code.
*
* $Id$
*
*******************************************************************************/

#ifndef MCCODE_R_H
#define MCCODE_R_H "$Revision$"

#include <math.h>
#include <string.h>
#include <strings.h>
#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <limits.h>
#include <errno.h>
#include <time.h>
#include <float.h>
#include <inttypes.h>

/* If the runtime is embedded in the simulation program, some definitions can
   be made static. */

#ifdef MC_EMBEDDED_RUNTIME
#define mcstatic static
#else
#define mcstatic
#endif

#ifdef __dest_os
#if (__dest_os == __mac_os)
#define MAC
#endif
#endif

#ifdef __FreeBSD__
#define NEED_STAT_H
#endif

#if defined(__APPLE__) && defined(__GNUC__)
#define NEED_STAT_H
#endif

#ifdef NEED_STAT_H
#include <sys/stat.h>
#endif

#ifndef MC_PATHSEP_C
#ifdef WIN32
#define MC_PATHSEP_C '\\'
#define MC_PATHSEP_S "\\"
#else  /* !WIN32 */
#define MC_PATHSEP_C '/'
#define MC_PATHSEP_S "/"
#endif /* !WIN32 */
#endif /* MC_PATHSEP_C */

#ifndef WIN32
#ifndef _POSIX_SOURCE
#define _POSIX_SOURCE 1
#endif
#endif

/* the version string is replaced when building distribution with mkdist */
#ifndef MCCODE_STRING
#define MCCODE_STRING "McStas 2.7 - Nov. 27, 2020"
#endif

#ifndef MCCODE_DATE
#define MCCODE_DATE "Nov. 27, 2020"
#endif

#ifndef MCCODE_VERSION
#define MCCODE_VERSION "2.7"
#endif

#ifndef MCCODE_NAME
#define MCCODE_NAME "McStas"
#endif

#ifndef MCCODE_PARTICLE
#define MCCODE_PARTICLE "neutron"
#endif

#ifndef MCCODE_LIBENV
#define MCCODE_LIBENV "MCSTAS"
#endif

#ifndef FLAVOR_UPPER
#define FLAVOR_UPPER MCCODE_NAME
#endif

#ifdef MC_PORTABLE
#ifndef NOSIGNALS
#define NOSIGNALS 1
#endif
#endif

#ifdef MAC
#ifndef NOSIGNALS
#define NOSIGNALS 1
#endif
#endif

#if (USE_MPI == 0)
#undef USE_MPI
#endif

#ifdef USE_MPI  /* default is to disable signals with MPI, as MPICH uses them to communicate */
#ifndef NOSIGNALS
#define NOSIGNALS 1
#endif
#endif

#if (NOSIGNALS == 0)
#undef NOSIGNALS
#endif

/* Note: the enum instr_formal_types definition MUST be kept
   synchronized with the one in mccode.h and with the
   instr_formal_type_names array in cogen.c. */
enum instr_formal_types
  {
    instr_type_double, instr_type_int, instr_type_string
  };
struct mcinputtable_struct { /* defines instrument parameters */
  char *name; /* name of parameter */
  void *par;  /* pointer to instrument parameter (variable) */
  enum instr_formal_types type;
  char *val;  /* default value */
};

typedef double MCNUM;
typedef struct {MCNUM x, y, z;} Coords;
typedef MCNUM Rotation[3][3];

/* the following variables are defined in the McStas generated C code
   but should be defined externally in case of independent library usage */
#ifndef DANSE
extern struct mcinputtable_struct mcinputtable[]; /* list of instrument parameters */
extern int    mcnumipar;                          /* number of instrument parameters */
extern char   mcinstrument_name[], mcinstrument_source[]; /* instrument name and filename */
extern char  *mcinstrument_exe;                           /* executable path = argv[0] or NULL */
extern MCNUM  mccomp_storein[]; /* 11 coords * number of components in instrument */
extern MCNUM  mcAbsorbProp[];
extern MCNUM  mcScattered;      /* number of SCATTER calls in current component */
extern MCNUM  mcRestore;        /* Flag to indicate if neutron needs to be restored */
#ifndef MC_ANCIENT_COMPATIBILITY
extern int mctraceenabled, mcdefaultmain;
#endif
#endif


/* Useful macros ============================================================ */

/* MPI stuff */

#ifdef USE_MPI
#include "mpi.h"

#ifdef OMPI_MPI_H  /* openmpi does not use signals: we may install our sighandler */
#undef NOSIGNALS
#endif

/*
 * MPI_MASTER(i):
 * execution of i only on master node
 */
#define MPI_MASTER(statement) { \
  if(mpi_node_rank == mpi_node_root)\
  { statement; } \
}

#ifndef MPI_REDUCE_BLOCKSIZE
#define MPI_REDUCE_BLOCKSIZE 1000
#endif

int mc_MPI_Sum(double* buf, long count);
int mc_MPI_Send(void *sbuf, long count, MPI_Datatype dtype, int dest);
int mc_MPI_Recv(void *rbuf, long count, MPI_Datatype dtype, int source);

/* MPI_Finalize exits gracefully and should be preferred to MPI_Abort */
#define exit(code) do {                                   \
    MPI_Finalize();                                       \
    exit(code);                                           \
  } while(0)

#else /* !USE_MPI */
#define MPI_MASTER(instr) instr
#endif /* USE_MPI */

#ifdef USE_MPI
static int mpi_node_count;
#endif

#ifdef USE_THREADS  /* user want threads */
#error Threading (USE_THREADS) support has been removed for very poor efficiency. Use MPI/SSH grid instead.
#endif


void   mcset_ncount(unsigned long long count);    /* wrapper to get mcncount */
unsigned long long int mcget_ncount(void);            /* wrapper to set mcncount */
unsigned long long mcget_run_num(void);           /* wrapper to get mcrun_num=0:mcncount */


/* Following part is only embedded when not redundant with mccode.h ========= */

#ifndef MCCODE_H

#ifndef NOSIGNALS
#include <signal.h>
#define SIG_MESSAGE(msg) strcpy(mcsig_message, msg);
#else
#define SIG_MESSAGE(msg)
#endif /* !NOSIGNALS */

/* Useful macros and constants ============================================== */

#ifndef FLT_MAX
#define FLT_MAX         3.40282347E+38F /* max decimal value of a "float" */
#endif

#ifndef MIN
#define MIN(a, b)  (((a) < (b)) ? (a) : (b))
#endif
#ifndef MAX
#define MAX(a, b)  (((a) > (b)) ? (a) : (b))
#endif
#ifndef SQR
#define SQR(x) ( (x) * (x) )
#endif
#ifndef SIGN
#define SIGN(x) (((x)>0.0)?(1):(-1))
#endif

#ifndef PI
# ifdef M_PI
#  define PI M_PI
# else
/* When using c99 in the CFLAGS, some of these consts
   are lost... Perhaps we should in fact include everything from
   https://www.gnu.org/software/libc/manual/html_node/Mathematical-Constants.html
*/
#  define PI 3.14159265358979323846
#  define M_PI PI
#  define M_PI_2 M_PI/2.0
#  define M_PI_4 M_PI/4.0
#  define M_1_PI 1.0/M_PI
#  define M_2_PI 2*M_1_PI
#  define M_2_SQRTPI 2/sqrt(M_PI)
#  define M_SQRT2 sqrt(2)
#  define M_SQRT1_2 sqrt(1/2)
# endif
#endif

#define RAD2MIN  ((180*60)/PI)
#define MIN2RAD  (PI/(180*60))
#define DEG2RAD  (PI/180)
#define RAD2DEG  (180/PI)
#define FWHM2RMS 0.424660900144    /* Convert between full-width-half-max and */
#define RMS2FWHM 2.35482004503     /* root-mean-square (standard deviation) */
#define HBAR     1.05457168e-34    /* [Js] h bar Planck constant CODATA 2002 */
#define MNEUTRON 1.67492728e-27    /* [kg] mass of neutron CODATA 2002 */
#define GRAVITY  9.81              /* [m/s^2] gravitational acceleration */
#define NA       6.02214179e23     /* [#atoms/g .mole] Avogadro's number*/


/* wrapper to get absolute and relative position of comp */
/* mccomp_posa and mccomp_posr are defined in McStas generated C code */
#define POS_A_COMP_INDEX(index) \
    (mccomp_posa[index])
#define POS_R_COMP_INDEX(index) \
    (mccomp_posr[index])
/* number of SCATTER calls in current comp: mcScattered defined in generated C code */
#define SCATTERED mcScattered
/* Flag to indicate if neutron needs to be restored: mcRestore defined in generated C code */
#define RESTORE mcRestore


/* Retrieve component information from the kernel */
/* Name, position and orientation (both absolute and relative)  */
/* Any component: For "redundancy", see comment by KN */
#define tmp_name_comp(comp) #comp
#define NAME_COMP(comp) tmp_name_comp(comp)
#define tmp_pos_a_comp(comp) (mcposa ## comp)
#define POS_A_COMP(comp) tmp_pos_a_comp(comp)
#define tmp_pos_r_comp(comp) (mcposr ## comp)
#define POS_R_COMP(comp) tmp_pos_r_comp(comp)
#define tmp_rot_a_comp(comp) (mcrota ## comp)
#define ROT_A_COMP(comp) tmp_rot_a_comp(comp)
#define tmp_rot_r_comp(comp) (mcrotr ## comp)
#define ROT_R_COMP(comp) tmp_rot_r_comp(comp)

/* Current component name, index, position and orientation */
#define NAME_CURRENT_COMP  NAME_COMP(mccompcurname)
#define INDEX_CURRENT_COMP mccompcurindex
#define POS_A_CURRENT_COMP POS_A_COMP(mccompcurname)
#define POS_R_CURRENT_COMP POS_R_COMP(mccompcurname)
#define ROT_A_CURRENT_COMP ROT_A_COMP(mccompcurname)
#define ROT_R_CURRENT_COMP ROT_R_COMP(mccompcurname)

/* Note: The two-stage approach to MC_GETPAR is NOT redundant; without it,
* after #define C sample, MC_GETPAR(C,x) would refer to component C, not to
* component sample. Such are the joys of ANSI C.

* Anyway the usage of MCGETPAR requires that we use sometimes bare names...
*/
#define MC_GETPAR2(comp, par) (mcc ## comp ## _ ## par)
#define MC_GETPAR(comp, par) MC_GETPAR2(comp,par)

/* MCDISPLAY/trace and debugging message sent to stdout */
#ifdef MC_TRACE_ENABLED
#define DEBUG
#endif

#ifdef DEBUG
#define mcDEBUG_INSTR() if(!mcdotrace); else { printf("\nINSTRUMENT:\n"); printf("Instrument '%s' (%s)\n", mcinstrument_name, mcinstrument_source); }
#define mcDEBUG_COMPONENT(name,c,t) if(!mcdotrace); else {\
  printf("COMPONENT: \"%s\"\n" \
         "POS: %g, %g, %g, %g, %g, %g, %g, %g, %g, %g, %g, %g\n", \
         name, c.x, c.y, c.z, t[0][0], t[0][1], t[0][2], \
         t[1][0], t[1][1], t[1][2], t[2][0], t[2][1], t[2][2]); \
  mcAccumulatedILength += coords_len(coords_sub(mcLastComp,c)); \
  printf("Component %30s AT (%g,%g,%g)    %g m from origin\n", name, c.x, c.y, c.z, mcAccumulatedILength); \
  mcLastComp=c;\
  }
#define mcDEBUG_INSTR_END() if(!mcdotrace); else printf("INSTRUMENT END:\n");
#define mcDEBUG_ENTER() if(!mcdotrace); else printf("ENTER:\n");
#define mcDEBUG_COMP(c) if(!mcdotrace); else printf("COMP: \"%s\"\n", c);
#define mcDEBUG_LEAVE() if(!mcdotrace); else printf("LEAVE:\n");
#define mcDEBUG_ABSORB() if(!mcdotrace); else printf("ABSORB:\n");
#else
#define mcDEBUG_INSTR()
#define mcDEBUG_COMPONENT(name,c,t)
#define mcDEBUG_INSTR_END()
#define mcDEBUG_ENTER()
#define mcDEBUG_COMP(c)
#define mcDEBUG_LEAVE()
#define mcDEBUG_ABSORB()
#endif

// mcDEBUG_STATE and mcDEBUG_SCATTER are defined by mcstas-r.h and mcxtrace-r.h



#ifdef TEST
#define test_printf printf
#else
#define test_printf while(0) printf
#endif

/* send MCDISPLAY message to stdout to show gemoetry */
void mcdis_magnify(char *what);
void mcdis_line(double x1, double y1, double z1,
                double x2, double y2, double z2);
void mcdis_dashed_linemcdis_dashed_line(double x1, double y1, double z1,
		       double x2, double y2, double z2, int n);
void mcdis_multiline(int count, ...);
void mcdis_rectangle(char* plane, double x, double y, double z,
		     double width, double height);
void mcdis_box(double x, double y, double z,
	       double width, double height, double length);
void mcdis_circle(char *plane, double x, double y, double z, double r);
void mcdis_Circle(double x, double y, double z, double r, double nx, double ny, double nz);
void mcdis_cylinder( double x, double y, double z,
        double r, double height, int N, double nx, double ny, double nz);
void mcdis_sphere(double x, double y, double z, double r, int N);

/* selection of random number generator. default is MT */
#ifndef MC_RAND_ALG
#define MC_RAND_ALG 1
#endif

#if MC_RAND_ALG == 0
   /* Use system random() (not recommended). */
#  define MC_RAND_MAX RAND_MAX
#elif MC_RAND_ALG == 1
   /* "Mersenne Twister", by Makoto Matsumoto and Takuji Nishimura. */
#  define MC_RAND_MAX ((unsigned long)0xffffffff)
#  define random mt_random
#  define srandom mt_srandom
#elif MC_RAND_ALG == 2
   /* Algorithm used in McStas CVS-080208 and earlier (not recommended). */
#  define MC_RAND_MAX 0x7fffffff
#  define random mc_random
#  define srandom mc_srandom
#else
#  error "Bad value for random number generator choice."
#endif

typedef int mc_int32_t;
mc_int32_t mc_random(void);
void mc_srandom (unsigned int x);
unsigned long mt_random(void);
void mt_srandom (unsigned long x);

double rand01();
double randpm1();
double rand0max(double max);
double randminmax(double min, double max);

double randnorm(void);
double randtriangle(void);

#ifndef DANSE
void mcinit(void);
void mcraytrace(void);
void mcsave(FILE *);
void mcfinally(void);
void mcdisplay(void);
#endif

/* simple vector algebra ==================================================== */
#define vec_prod(x, y, z, x1, y1, z1, x2, y2, z2) \
	vec_prod_func(&x, &y, &z, x1, y1, z1, x2, y2, z2)
mcstatic void vec_prod_func(double *x, double *y, double *z,
		double x1, double y1, double z1, double x2, double y2, double z2);

mcstatic double scalar_prod(
		double x1, double y1, double z1, double x2, double y2, double z2);

#define NORM(x,y,z) \
	norm_func(&x, &y, &z)
mcstatic void norm_func(double *x, double *y, double *z) {
	double temp = (*x * *x) + (*y * *y) + (*z * *z);
	if (temp != 0) {
		temp = sqrt(temp);
		*x /= temp;
		*y /= temp;
		*z /= temp;
	}
}
#define normal_vec(nx, ny, nz, x, y, z) \
    normal_vec_func(&(nx), &(ny), &(nz), x, y, z)
mcstatic void normal_vec_func(double *nx, double *ny, double *nz,
    double x, double y, double z);

/**
 * Rotate the vector vx,vy,vz psi radians around the vector ax,ay,az
 * and put the result in x,y,z.
 */
#define rotate(x, y, z, vx, vy, vz, phi, ax, ay, az) \
  do { \
    double mcrt_tmpx = (ax), mcrt_tmpy = (ay), mcrt_tmpz = (az); \
    double mcrt_vp, mcrt_vpx, mcrt_vpy, mcrt_vpz; \
    double mcrt_vnx, mcrt_vny, mcrt_vnz, mcrt_vn1x, mcrt_vn1y, mcrt_vn1z; \
    double mcrt_bx, mcrt_by, mcrt_bz; \
    double mcrt_cos, mcrt_sin; \
    NORM(mcrt_tmpx, mcrt_tmpy, mcrt_tmpz); \
    mcrt_vp = scalar_prod((vx), (vy), (vz), mcrt_tmpx, mcrt_tmpy, mcrt_tmpz); \
    mcrt_vpx = mcrt_vp*mcrt_tmpx; \
    mcrt_vpy = mcrt_vp*mcrt_tmpy; \
    mcrt_vpz = mcrt_vp*mcrt_tmpz; \
    mcrt_vnx = (vx) - mcrt_vpx; \
    mcrt_vny = (vy) - mcrt_vpy; \
    mcrt_vnz = (vz) - mcrt_vpz; \
    vec_prod(mcrt_bx, mcrt_by, mcrt_bz, \
             mcrt_tmpx, mcrt_tmpy, mcrt_tmpz, mcrt_vnx, mcrt_vny, mcrt_vnz); \
    mcrt_cos = cos((phi)); mcrt_sin = sin((phi)); \
    mcrt_vn1x = mcrt_vnx*mcrt_cos + mcrt_bx*mcrt_sin; \
    mcrt_vn1y = mcrt_vny*mcrt_cos + mcrt_by*mcrt_sin; \
    mcrt_vn1z = mcrt_vnz*mcrt_cos + mcrt_bz*mcrt_sin; \
    (x) = mcrt_vpx + mcrt_vn1x; \
    (y) = mcrt_vpy + mcrt_vn1y; \
    (z) = mcrt_vpz + mcrt_vn1z; \
  } while(0)

/**
 * Mirror (xyz) in the plane given by the point (rx,ry,rz) and normal (nx,ny,nz)
 *
 * TODO: This define is seemingly never used...
 */
#define mirror(x,y,z,rx,ry,rz,nx,ny,nz) \
  do { \
    double mcrt_tmpx= (nx), mcrt_tmpy = (ny), mcrt_tmpz = (nz); \
    double mcrt_tmpt; \
    NORM(mcrt_tmpx, mcrt_tmpy, mcrt_tmpz); \
    mcrt_tmpt=scalar_prod((rx),(ry),(rz),mcrt_tmpx,mcrt_tmpy,mcrt_tmpz); \
    (x) = rx -2 * mcrt_tmpt*mcrt_rmpx; \
    (y) = ry -2 * mcrt_tmpt*mcrt_rmpy; \
    (z) = rz -2 * mcrt_tmpt*mcrt_rmpz; \
  } while (0)

Coords coords_set(MCNUM x, MCNUM y, MCNUM z);
Coords coords_get(Coords a, MCNUM *x, MCNUM *y, MCNUM *z);
Coords coords_add(Coords a, Coords b);
Coords coords_sub(Coords a, Coords b);
Coords coords_neg(Coords a);
Coords coords_scale(Coords b, double scale);
double coords_sp(Coords a, Coords b);
Coords coords_xp(Coords b, Coords c);
double coords_len(Coords a);
void   coords_print(Coords a);
mcstatic void coords_norm(Coords* c);

void rot_set_rotation(Rotation t, double phx, double phy, double phz);
int  rot_test_identity(Rotation t);
void rot_mul(Rotation t1, Rotation t2, Rotation t3);
void rot_copy(Rotation dest, Rotation src);
void rot_transpose(Rotation src, Rotation dst);
Coords rot_apply(Rotation t, Coords a);

void mccoordschange(Coords a, Rotation t, double *x, double *y, double *z,
    double *vx, double *vy, double *vz, double *sx, double *sy, double *sz);
void
mccoordschange_polarisation(Rotation t, double *sx, double *sy, double *sz);

double mcestimate_error(double N, double p1, double p2);
void mcreadparams(void);

/* this is now in mcstas-r.h and mcxtrace-r.h as the number of state parameters is no longer equal*/
/* void mcsetstate(double x, double y, double z, double vx, double vy, double vz,
                double t, double sx, double sy, double sz, double p);
*/
void mcgenstate(void);

/* trajectory/shape intersection routines */
int inside_rectangle(double, double, double, double);
int box_intersect(double *dt_in, double *dt_out, double x, double y, double z,
    double vx, double vy, double vz, double dx, double dy, double dz);
int cylinder_intersect(double *t0, double *t1, double x, double y, double z,
    double vx, double vy, double vz, double r, double h);
int sphere_intersect(double *t0, double *t1, double x, double y, double z,
                 double vx, double vy, double vz, double r);
/* second order equation roots */
int solve_2nd_order(double *t1, double *t2,
    double A,  double B,  double C);

/* random vector generation to shape */
void randvec_target_circle(double *xo, double *yo, double *zo,
    double *solid_angle, double xi, double yi, double zi, double radius);
#define randvec_target_sphere randvec_target_circle
void randvec_target_rect_angular(double *xo, double *yo, double *zo,
    double *solid_angle,
               double xi, double yi, double zi, double height, double width, Rotation A);
#define randvec_target_rect(p0,p1,p2,p3,p4,p5,p6,p7,p8,p9)  randvec_target_rect_real(p0,p1,p2,p3,p4,p5,p6,p7,p8,p9,0,0,0,1)
void randvec_target_rect_real(double *xo, double *yo, double *zo,
    double *solid_angle,
	       double xi, double yi, double zi, double height, double width, Rotation A,
			 double lx, double ly, double lz, int order);

/* this is the main() */
int mccode_main(int argc, char *argv[]);


#endif /* !MCCODE_H */

#ifndef MCCODE_R_IO_H
#define MCCODE_R_IO_H "$Revision$"

#if (USE_NEXUS == 0)
#undef USE_NEXUS
#endif

#ifndef CHAR_BUF_LENGTH
#define CHAR_BUF_LENGTH 1024
#endif

/* I/O section part ========================================================= */

/* ========================================================================== */

/*                               MCCODE_R_IO_C                                */

/* ========================================================================== */


/* main DETECTOR structure which stores most information to write to data files */
struct mcdetector_struct {
  char   filename[CHAR_BUF_LENGTH];   /* file name of monitor */
  char   position[CHAR_BUF_LENGTH];   /* position of detector component */
  char   component[CHAR_BUF_LENGTH];  /* component instance name */
  char   instrument[CHAR_BUF_LENGTH]; /* instrument name */
  char   type[CHAR_BUF_LENGTH];       /* data type, e.g. 0d, 1d, 2d, 3d */
  char   user[CHAR_BUF_LENGTH];       /* user name, e.g. HOME */
  char   date[CHAR_BUF_LENGTH];       /* date of simulation end/write time */
  char   title[CHAR_BUF_LENGTH];      /* title of detector */
  char   xlabel[CHAR_BUF_LENGTH];     /* X axis label */
  char   ylabel[CHAR_BUF_LENGTH];     /* Y axis label */
  char   zlabel[CHAR_BUF_LENGTH];     /* Z axis label */
  char   xvar[CHAR_BUF_LENGTH];       /* X variable name */
  char   yvar[CHAR_BUF_LENGTH];       /* Y variable name */
  char   zvar[CHAR_BUF_LENGTH];       /* Z variable name */
  char   ncount[CHAR_BUF_LENGTH];     /* number of events initially generated */
  char   limits[CHAR_BUF_LENGTH];     /* X Y Z limits, e.g. [xmin xmax ymin ymax zmin zmax] */
  char   variables[CHAR_BUF_LENGTH];  /* variables written into data block */
  char   statistics[CHAR_BUF_LENGTH]; /* center, mean and half width along axis */
  char   signal[CHAR_BUF_LENGTH];     /* min max and mean of signal (data block) */
  char   values[CHAR_BUF_LENGTH];     /* integrated values e.g. [I I_err N] */
  double xmin,xmax;                   /* min max of axes */
  double ymin,ymax;
  double zmin,zmax;
  double intensity;                   /* integrated values for data block */
  double error;
  double events;
  double min;                         /* statistics for data block */
  double max;
  double mean;
  double centerX;                     /* statistics for axes */
  double halfwidthX;
  double centerY;
  double halfwidthY;
  int    rank;                        /* dimensionaly of monitor, e.g. 0 1 2 3 */
  char   istransposed;                /* flag to transpose matrix for some formats */

  long   m,n,p;                       /* dimensions of data block and along axes */
  long   date_l;                      /* same as date, but in sec since 1970 */

  double *p0, *p1, *p2;               /* pointers to saved data, NULL when freed */
  char   format[CHAR_BUF_LENGTH];    /* format for file generation */
};

typedef struct mcdetector_struct MCDETECTOR;

static   char *mcdirname             = NULL;      /* name of output directory */
static   char *mcsiminfo_name        = "mccode";  /* default output sim file name */
char    *mcformat                    = NULL;      /* NULL (default) or a specific format */

/* file I/O definitions and function prototypes */

#ifndef MC_EMBEDDED_RUNTIME /* the mcstatic variables (from mccode-r.c) */
extern FILE * mcsiminfo_file;     /* handle to the output siminfo file */
extern int    mcgravitation;      /* flag to enable gravitation */
extern int    mcdotrace;          /* flag to print MCDISPLAY messages */
#else
mcstatic FILE *mcsiminfo_file        = NULL;
#endif

/* I/O function prototypes ================================================== */

/* output functions */
MCDETECTOR mcdetector_out_0D(char *t, double p0, double p1, double p2, char *c, Coords pos);
MCDETECTOR mcdetector_out_1D(char *t, char *xl, char *yl,
                  char *xvar, double x1, double x2, long n,
                  double *p0, double *p1, double *p2, char *f, char *c, Coords pos);
MCDETECTOR mcdetector_out_2D(char *t, char *xl, char *yl,
                  double x1, double x2, double y1, double y2, long m,
                  long n, double *p0, double *p1, double *p2, char *f,
                  char *c, Coords pos);
MCDETECTOR mcdetector_out_list(char *t, char *xl, char *yl,
                  long m, long n,
                  double *p1, char *f,
                  char *c, Coords posa);

/* wrappers to output functions, that automatically set NAME and POSITION */
#define DETECTOR_OUT(p0,p1,p2) mcdetector_out_0D(NAME_CURRENT_COMP,p0,p1,p2,NAME_CURRENT_COMP,POS_A_CURRENT_COMP)
#define DETECTOR_OUT_0D(t,p0,p1,p2) mcdetector_out_0D(t,p0,p1,p2,NAME_CURRENT_COMP,POS_A_CURRENT_COMP)
#define DETECTOR_OUT_1D(t,xl,yl,xvar,x1,x2,n,p0,p1,p2,f) \
     mcdetector_out_1D(t,xl,yl,xvar,x1,x2,n,p0,p1,p2,f,NAME_CURRENT_COMP,POS_A_CURRENT_COMP)
#define DETECTOR_OUT_2D(t,xl,yl,x1,x2,y1,y2,m,n,p0,p1,p2,f) \
     mcdetector_out_2D(t,xl,yl,x1,x2,y1,y2,m,n,p0,p1,p2,f,NAME_CURRENT_COMP,POS_A_CURRENT_COMP)

#ifdef USE_NEXUS
#include "napi.h"
NXhandle nxhandle;
#endif

#endif /* ndef MCCODE_R_IO_H */

#endif /* MCCODE_R_H */
/* End of file "mccode-r.h". */

#line 711 "MACS_sample_kidney_box.c"

#line 1 "mcstas-r.h"
/*******************************************************************************
*
* McStas, neutron ray-tracing package
*         Copyright (C) 1997-2009, All rights reserved
*         Risoe National Laboratory, Roskilde, Denmark
*         Institut Laue Langevin, Grenoble, France
*
* Runtime: share/mcstas-r.h
*
* %Identification
* Written by: KN
* Date:    Aug 29, 1997
* Release: McStas X.Y
* Version: $Revision$
*
* Runtime system header for McStas.
*
* In order to use this library as an external library, the following variables
* and macros must be declared (see details in the code)
*
*   struct mcinputtable_struct mcinputtable[];
*   int mcnumipar;
*   char mcinstrument_name[], mcinstrument_source[];
*   int mctraceenabled, mcdefaultmain;
*   extern MCNUM  mccomp_storein[];
*   extern MCNUM  mcAbsorbProp[];
*   extern MCNUM  mcScattered;
*   #define MCCODE_STRING "the McStas version"
*
* Usage: Automatically embbeded in the c code.
*
* $Id$
*
*******************************************************************************/

#ifndef MCSTAS_R_H
#define MCSTAS_R_H "$Revision$"

/* Following part is only embedded when not redundant with mcstas.h ========= */

#ifndef MCCODE_H

#define AA2MS    629.622368        /* Convert k[1/AA] to v[m/s] */
#define MS2AA    1.58825361e-3     /* Convert v[m/s] to k[1/AA] */
#define K2V      AA2MS
#define V2K      MS2AA
#define Q2V      AA2MS
#define V2Q      MS2AA
#define SE2V     437.393377        /* Convert sqrt(E)[meV] to v[m/s] */
#define VS2E     5.22703725e-6     /* Convert (v[m/s])**2 to E[meV] */

#define SCATTER do {mcDEBUG_SCATTER(mcnlx, mcnly, mcnlz, mcnlvx, mcnlvy, mcnlvz, \
        mcnlt,mcnlsx,mcnlsy,mcnlsz, mcnlp); mcScattered++;} while(0)
#define ABSORB do {mcDEBUG_STATE(mcnlx, mcnly, mcnlz, mcnlvx, mcnlvy, mcnlvz, \
        mcnlt,mcnlsx,mcnlsy,mcnlsz, mcnlp); mcDEBUG_ABSORB(); MAGNET_OFF; goto mcabsorb;} while(0)

#define STORE_NEUTRON(index, x, y, z, vx, vy, vz, t, sx, sy, sz, p) \
  mcstore_neutron(mccomp_storein,index, x, y, z, vx, vy, vz, t, sx, sy, sz, p);
#define RESTORE_NEUTRON(index, x, y, z, vx, vy, vz, t, sx, sy, sz, p) \
  mcrestore_neutron(mccomp_storein,index, &x, &y, &z, &vx, &vy, &vz, &t, &sx, &sy, &sz, &p);

#define MAGNET_ON \
  do { \
    mcMagnet = 1; \
  } while(0)

#define MAGNET_OFF \
  do { \
    mcMagnet = 0; \
  } while(0)

#define ALLOW_BACKPROP \
  do { \
    mcallowbackprop = 1; \
  } while(0)

#define DISALLOW_BACKPROP \
  do { \
    mcallowbackprop = 0; \
  } while(0)

#define PROP_MAGNET(dt) \
  do { \
  }while (0)
    /* change coordinates from local system to magnet system */
/*    Rotation rotLM, rotTemp; \
      Coords   posLM = coords_sub(POS_A_CURRENT_COMP, mcMagnetPos); \
      rot_transpose(ROT_A_CURRENT_COMP, rotTemp); \
      rot_mul(rotTemp, mcMagnetRot, rotLM); \
      mcMagnetPrecession(mcnlx, mcnly, mcnlz, mcnlt, mcnlvx, mcnlvy, mcnlvz, \
               &mcnlsx, &mcnlsy, &mcnlsz, dt, posLM, rotLM); \
      } while(0)
*/

#define mcPROP_DT(dt) \
  do { \
    if (mcMagnet && dt > 0) PROP_MAGNET(dt);\
    mcnlx += mcnlvx*(dt); \
    mcnly += mcnlvy*(dt); \
    mcnlz += mcnlvz*(dt); \
    mcnlt += (dt); \
    if (isnan(p) || isinf(p)) { mcAbsorbProp[INDEX_CURRENT_COMP]++; ABSORB; }\
  } while(0)

/* ADD: E. Farhi, Aug 6th, 2001 PROP_GRAV_DT propagation with acceleration */
#define PROP_GRAV_DT(dt, Ax, Ay, Az) \
  do { \
    if(dt < 0 && mcallowbackprop == 0) { mcAbsorbProp[INDEX_CURRENT_COMP]++; ABSORB; }\
    if (mcMagnet) printf("Spin precession gravity\n"); \
    mcnlx  += mcnlvx*(dt) + (Ax)*(dt)*(dt)/2; \
    mcnly  += mcnlvy*(dt) + (Ay)*(dt)*(dt)/2; \
    mcnlz  += mcnlvz*(dt) + (Az)*(dt)*(dt)/2; \
    mcnlvx += (Ax)*(dt); \
    mcnlvy += (Ay)*(dt); \
    mcnlvz += (Az)*(dt); \
    mcnlt  += (dt); \
    DISALLOW_BACKPROP;\
  } while(0)


#define PROP_DT(dt) \
  do { \
    if(dt < 0) { RESTORE=1; goto mcabsorbComp; }; \
    if (mcgravitation) { Coords mcLocG; double mc_gx, mc_gy, mc_gz; \
    mcLocG = rot_apply(ROT_A_CURRENT_COMP, coords_set(0,-GRAVITY,0)); \
    coords_get(mcLocG, &mc_gx, &mc_gy, &mc_gz); \
    PROP_GRAV_DT(dt, mc_gx, mc_gy, mc_gz); } \
    else mcPROP_DT(dt); \
    DISALLOW_BACKPROP;\
  } while(0)


#define PROP_Z0 \
  do { \
    if (mcgravitation) { Coords mcLocG; int mc_ret; \
    double mc_dt, mc_gx, mc_gy, mc_gz; \
    mcLocG = rot_apply(ROT_A_CURRENT_COMP, coords_set(0,-GRAVITY,0)); \
    coords_get(mcLocG, &mc_gx, &mc_gy, &mc_gz); \
    mc_ret = solve_2nd_order(&mc_dt, NULL, -mc_gz/2, -mcnlvz, -mcnlz); \
    if (mc_ret && mc_dt>=0) {PROP_GRAV_DT(mc_dt, mc_gx, mc_gy, mc_gz); mcnlz=0;}\
    else { if (mcallowbackprop ==0) {mcAbsorbProp[INDEX_CURRENT_COMP]++; ABSORB; }}; }\
    else mcPROP_Z0; \
    DISALLOW_BACKPROP;\
  } while(0)

#define mcPROP_Z0 \
  do { \
    double mc_dt; \
    if(mcnlvz == 0) { mcAbsorbProp[INDEX_CURRENT_COMP]++; ABSORB; }; \
    mc_dt = -mcnlz/mcnlvz; \
    if(mc_dt < 0 && mcallowbackprop == 0) { mcAbsorbProp[INDEX_CURRENT_COMP]++; ABSORB; }; \
    mcPROP_DT(mc_dt); \
    mcnlz = 0; \
    DISALLOW_BACKPROP;\
  } while(0)

#define PROP_X0 \
  do { \
    if (mcgravitation) { Coords mcLocG; int mc_ret; \
    double mc_dt, mc_gx, mc_gy, mc_gz; \
    mcLocG = rot_apply(ROT_A_CURRENT_COMP, coords_set(0,-GRAVITY,0)); \
    coords_get(mcLocG, &mc_gx, &mc_gy, &mc_gz); \
    mc_ret = solve_2nd_order(&mc_dt, NULL, -mc_gx/2, -mcnlvx, -mcnlx); \
    if (mc_ret && mc_dt>=0) PROP_GRAV_DT(mc_dt, mc_gx, mc_gy, mc_gz); \
    else { if (mcallowbackprop ==0) {mcAbsorbProp[INDEX_CURRENT_COMP]++; ABSORB; }}; }\
    else mcPROP_X0; \
    DISALLOW_BACKPROP;\
  } while(0)

#define mcPROP_X0 \
  do { \
    double mc_dt; \
    if(mcnlvx == 0) { mcAbsorbProp[INDEX_CURRENT_COMP]++; ABSORB; }; \
    mc_dt = -mcnlx/mcnlvx; \
    if(mc_dt < 0 && mcallowbackprop == 0) { mcAbsorbProp[INDEX_CURRENT_COMP]++; ABSORB; }; \
    mcPROP_DT(mc_dt); \
    mcnlx = 0; \
    DISALLOW_BACKPROP;\
  } while(0)

#define PROP_Y0 \
  do { \
    if (mcgravitation) { Coords mcLocG; int mc_ret; \
    double mc_dt, mc_gx, mc_gy, mc_gz; \
    mcLocG = rot_apply(ROT_A_CURRENT_COMP, coords_set(0,-GRAVITY,0)); \
    coords_get(mcLocG, &mc_gx, &mc_gy, &mc_gz); \
    mc_ret = solve_2nd_order(&mc_dt, NULL, -mc_gy/2, -mcnlvy, -mcnly); \
    if (mc_ret && mc_dt>=0) PROP_GRAV_DT(mc_dt, mc_gx, mc_gy, mc_gz); \
    else { if (mcallowbackprop ==0) {mcAbsorbProp[INDEX_CURRENT_COMP]++; ABSORB; }}; }\
    else mcPROP_Y0; \
    DISALLOW_BACKPROP;\
  } while(0)


#define mcPROP_Y0 \
  do { \
    double mc_dt; \
    if(mcnlvy == 0) { mcAbsorbProp[INDEX_CURRENT_COMP]++; ABSORB; }; \
    mc_dt = -mcnly/mcnlvy; \
    if(mc_dt < 0 && mcallowbackprop == 0) { mcAbsorbProp[INDEX_CURRENT_COMP]++; ABSORB; }; \
    mcPROP_DT(mc_dt); \
    mcnly = 0; \
    DISALLOW_BACKPROP; \
  } while(0)

/*moved from mccode-r.h*/
void mcsetstate(double x, double y, double z, double vx, double vy, double vz,
                double t, double sx, double sy, double sz, double p);

#ifdef DEBUG

#define mcDEBUG_STATE(x,y,z,vx,vy,vz,t,sx,sy,sz,p) if(!mcdotrace); else \
  printf("STATE: %g, %g, %g, %g, %g, %g, %g, %g, %g, %g, %g\n", \
         x,y,z,vx,vy,vz,t,sx,sy,sz,p);
#define mcDEBUG_SCATTER(x,y,z,vx,vy,vz,t,sx,sy,sz,p) if(!mcdotrace); else \
  printf("SCATTER: %g, %g, %g, %g, %g, %g, %g, %g, %g, %g, %g\n", \
         x,y,z,vx,vy,vz,t,sx,sy,sz,p);

#else

#define mcDEBUG_STATE(x,y,z,vx,vy,vz,t,sx,sy,sz,p)
#define mcDEBUG_SCATTER(x,y,z,vx,vy,vz,t,sx,sy,sz,p)

#endif

#endif /* !MCCODE_H */

#endif /* MCSTAS_R_H */
/* End of file "mcstas-r.h". */

#line 944 "MACS_sample_kidney_box.c"

#line 1 "mccode-r.c"
/*******************************************************************************
*
* McCode, neutron/xray ray-tracing package
*         Copyright (C) 1997-2009, All rights reserved
*         Risoe National Laboratory, Roskilde, Denmark
*         Institut Laue Langevin, Grenoble, France
*
* Runtime: share/mccode-r.c
*
* %Identification
* Written by: KN
* Date:    Aug 29, 1997
* Release: McStas X.Y/McXtrace X.Y
* Version: $Revision$
*
* Runtime system for McStas and McXtrace.
* Embedded within instrument in runtime mode.
* Contains SECTIONS:
*   MPI handling (sum, send, recv)
*   format definitions
*   I/O
*   mcdisplay support
*   random numbers
*   coordinates handling
*   vectors math (solve 2nd order, normals, randvec...)
*   parameter handling
*   signal and main handlers
*
* Usage: Automatically embbeded in the c code whenever required.
*
* $Id$
*
*******************************************************************************/

/*******************************************************************************
* The I/O format definitions and functions
*******************************************************************************/


/** Include header files to avoid implicit declarations (not allowed on LLVM) */
#include <ctype.h>
#include <sys/types.h>

// UNIX specific headers (non-Windows)
#if defined(__unix__) || defined(__APPLE__)
#include <unistd.h>
#endif

#include <sys/stat.h>

#ifdef _WIN32 
#include <direct.h>
# define  mkdir( D, M )   _mkdir( D ) 
#endif 

#ifndef DANSE
#ifdef MC_ANCIENT_COMPATIBILITY
int mctraceenabled = 0;
int mcdefaultmain  = 0;
#endif
/* else defined directly in the McCode generated C code */

static   long mcseed                 = 0; /* seed for random generator */
static   long mcstartdate            = 0; /* start simulation time */
static   int  mcdisable_output_files = 0; /* --no-output-files */
mcstatic int  mcgravitation          = 0; /* use gravitation flag, for PROP macros */
int      mcMagnet                    = 0; /* magnet stack flag */
mcstatic int  mcdotrace              = 0; /* flag for --trace and messages for DISPLAY */
int      mcallowbackprop             = 0;         /* flag to enable negative/backprop */

/* Number of particle histories to simulate. */
#ifdef NEUTRONICS
mcstatic unsigned long long int mcncount             = 1;
mcstatic unsigned long long int mcrun_num            = 0;
#else
mcstatic unsigned long long int mcncount             = 1000000;
mcstatic unsigned long long int mcrun_num            = 0;
#endif /* NEUTRONICS */

#else
#include "mcstas-globals.h"
#endif /* !DANSE */

/* SECTION: MPI handling ==================================================== */

#ifdef USE_MPI
/* MPI rank */
static int mpi_node_rank;
static int mpi_node_root = 0;


/*******************************************************************************
* mc_MPI_Reduce: Gathers arrays from MPI nodes using Reduce function.
*******************************************************************************/
int mc_MPI_Sum(double *sbuf, long count)
{
  if (!sbuf || count <= 0) return(MPI_SUCCESS); /* nothing to reduce */
  else {
    /* we must cut the buffer into blocks not exceeding the MPI max buffer size of 32000 */
    long   offset=0;
    double *rbuf=NULL;
    int    length=MPI_REDUCE_BLOCKSIZE; /* defined in mccode-r.h */
    int    i=0;
    rbuf = calloc(count, sizeof(double));
    if (!rbuf)
      exit(-fprintf(stderr, "Error: Out of memory %li (mc_MPI_Sum)\n", count*sizeof(double)));
    while (offset < count) {
      if (!length || offset+length > count-1) length=count-offset;
      else length=MPI_REDUCE_BLOCKSIZE;
      if (MPI_Reduce((double*)(sbuf+offset), (double*)(rbuf+offset),
              length, MPI_DOUBLE, MPI_SUM, 0, MPI_COMM_WORLD) != MPI_SUCCESS)
        return MPI_ERR_COUNT;
      offset += length;
    }

    for (i=0; i<count; i++) sbuf[i] = rbuf[i];
    free(rbuf);
  }
  return MPI_SUCCESS;
} /* mc_MPI_Sum */

/*******************************************************************************
* mc_MPI_Send: Send array to MPI node by blocks to avoid buffer limit
*******************************************************************************/
int mc_MPI_Send(void *sbuf,
                  long count, MPI_Datatype dtype,
                  int dest)
{
  int dsize;
  long offset=0;
  int  tag=1;
  int  length=MPI_REDUCE_BLOCKSIZE; /* defined in mccode-r.h */

  if (!sbuf || count <= 0) return(MPI_SUCCESS); /* nothing to send */
  MPI_Type_size(dtype, &dsize);

  while (offset < count) {
    if (offset+length > count-1) length=count-offset;
    else length=MPI_REDUCE_BLOCKSIZE;
    if (MPI_Send((void*)(sbuf+offset*dsize), length, dtype, dest, tag++, MPI_COMM_WORLD) != MPI_SUCCESS)
      return MPI_ERR_COUNT;
    offset += length;
  }

  return MPI_SUCCESS;
} /* mc_MPI_Send */

/*******************************************************************************
* mc_MPI_Recv: Receives arrays from MPI nodes by blocks to avoid buffer limit
*             the buffer must have been allocated previously.
*******************************************************************************/
int mc_MPI_Recv(void *sbuf,
                  long count, MPI_Datatype dtype,
                  int source)
{
  int dsize;
  long offset=0;
  int  tag=1;
  int  length=MPI_REDUCE_BLOCKSIZE; /* defined in mccode-r.h */

  if (!sbuf || count <= 0) return(MPI_SUCCESS); /* nothing to recv */
  MPI_Type_size(dtype, &dsize);

  while (offset < count) {
    if (offset+length > count-1) length=count-offset;
    else length=MPI_REDUCE_BLOCKSIZE;
    if (MPI_Recv((void*)(sbuf+offset*dsize), length, dtype, source, tag++,
            MPI_COMM_WORLD, MPI_STATUS_IGNORE) != MPI_SUCCESS)
      return MPI_ERR_COUNT;
    offset += length;
  }

  return MPI_SUCCESS;
} /* mc_MPI_Recv */

#endif /* USE_MPI */

/* SECTION: parameters handling ============================================= */

/* Instrument input parameter type handling. */
/*******************************************************************************
* mcparm_double: extract double value from 's' into 'vptr'
*******************************************************************************/
static int
mcparm_double(char *s, void *vptr)
{
  char *p;
  double *v = (double *)vptr;

  if (!s) { *v = 0; return(1); }
  *v = strtod(s, &p);
  if(*s == '\0' || (p != NULL && *p != '\0') || errno == ERANGE)
    return 0;                        /* Failed */
  else
    return 1;                        /* Success */
}

/*******************************************************************************
* mcparminfo_double: display parameter type double
*******************************************************************************/
static char *
mcparminfo_double(char *parmname)
{
  return "double";
}

/*******************************************************************************
* mcparmerror_double: display error message when failed extract double
*******************************************************************************/
static void
mcparmerror_double(char *parm, char *val)
{
  fprintf(stderr, "Error: Invalid value '%s' for floating point parameter %s (mcparmerror_double)\n",
          val, parm);
}

/*******************************************************************************
* mcparmprinter_double: convert double to string
*******************************************************************************/
static void
mcparmprinter_double(char *f, void *vptr)
{
  double *v = (double *)vptr;
  sprintf(f, "%g", *v);
}

/*******************************************************************************
* mcparm_int: extract int value from 's' into 'vptr'
*******************************************************************************/
static int
mcparm_int(char *s, void *vptr)
{
  char *p;
  int *v = (int *)vptr;
  long x;

  if (!s) { *v = 0; return(1); }
  *v = 0;
  x = strtol(s, &p, 10);
  if(x < INT_MIN || x > INT_MAX)
    return 0;                        /* Under/overflow */
  *v = x;
  if(*s == '\0' || (p != NULL && *p != '\0') || errno == ERANGE)
    return 0;                        /* Failed */
  else
    return 1;                        /* Success */
}

/*******************************************************************************
* mcparminfo_int: display parameter type int
*******************************************************************************/
static char *
mcparminfo_int(char *parmname)
{
  return "int";
}

/*******************************************************************************
* mcparmerror_int: display error message when failed extract int
*******************************************************************************/
static void
mcparmerror_int(char *parm, char *val)
{
  fprintf(stderr, "Error: Invalid value '%s' for integer parameter %s (mcparmerror_int)\n",
          val, parm);
}

/*******************************************************************************
* mcparmprinter_int: convert int to string
*******************************************************************************/
static void
mcparmprinter_int(char *f, void *vptr)
{
  int *v = (int *)vptr;
  sprintf(f, "%d", *v);
}

/*******************************************************************************
* mcparm_string: extract char* value from 's' into 'vptr' (copy)
*******************************************************************************/
static int
mcparm_string(char *s, void *vptr)
{
  char **v = (char **)vptr;
  if (!s) { *v = NULL; return(1); }
  *v = (char *)malloc(strlen(s) + 1);
  if(*v == NULL)
  {
    exit(-fprintf(stderr, "Error: Out of memory %li (mcparm_string).\n", (long)strlen(s) + 1));
  }
  strcpy(*v, s);
  return 1;                        /* Success */
}

/*******************************************************************************
* mcparminfo_string: display parameter type string
*******************************************************************************/
static char *
mcparminfo_string(char *parmname)
{
  return "string";
}

/*******************************************************************************
* mcparmerror_string: display error message when failed extract string
*******************************************************************************/
static void
mcparmerror_string(char *parm, char *val)
{
  fprintf(stderr, "Error: Invalid value '%s' for string parameter %s (mcparmerror_string)\n",
          val, parm);
}

/*******************************************************************************
* mcparmprinter_string: convert string to string (including esc chars)
*******************************************************************************/
static void
mcparmprinter_string(char *f, void *vptr)
{
  char **v = (char **)vptr;
  char *p;

  if (!*v) { *f='\0'; return; }
  strcpy(f, "");
  for(p = *v; *p != '\0'; p++)
  {
    switch(*p)
    {
      case '\n':
        strcat(f, "\\n");
        break;
      case '\r':
        strcat(f, "\\r");
        break;
      case '"':
        strcat(f, "\\\"");
        break;
      case '\\':
        strcat(f, "\\\\");
        break;
      default:
        strncat(f, p, 1);
    }
  }
  /* strcat(f, "\""); */
} /* mcparmprinter_string */

/* now we may define the parameter structure, using previous functions */
static struct
  {
    int (*getparm)(char *, void *);
    char * (*parminfo)(char *);
    void (*error)(char *, char *);
    void (*printer)(char *, void *);
} mcinputtypes[] = {
  {
    mcparm_double, mcparminfo_double, mcparmerror_double,
    mcparmprinter_double
  }, {
    mcparm_int, mcparminfo_int, mcparmerror_int,
    mcparmprinter_int
  }, {
    mcparm_string, mcparminfo_string, mcparmerror_string,
    mcparmprinter_string
  }
};

/*******************************************************************************
* mcestimate_error: compute sigma from N,p,p2 in Gaussian large numbers approx
*******************************************************************************/
double mcestimate_error(double N, double p1, double p2)
{
  double pmean, n1;
  if(N <= 1)
    return p1;
  pmean = p1 / N;
  n1 = N - 1;
  /* Note: underflow may cause p2 to become zero; the fabs() below guards
     against this. */
  return sqrt((N/n1)*fabs(p2 - pmean*pmean));
}

double (*mcestimate_error_p)
  (double V2, double psum, double p2sum)=mcestimate_error;

/* ========================================================================== */

/*                               MCCODE_R_IO_C                                */

/* ========================================================================== */

#ifndef MCCODE_R_IO_C
#define MCCODE_R_IO_C "$Revision$"

/* SECTION: file i/o handling ================================================ */

#ifndef HAVE_STRCASESTR
// from msysgit: https://code.google.com/p/msysgit/source/browse/compat/strcasestr.c
char *strcasestr(const char *haystack, const char *needle)
{
  int nlen = strlen(needle);
  int hlen = strlen(haystack) - nlen + 1;
  int i;

  for (i = 0; i < hlen; i++) {
    int j;
    for (j = 0; j < nlen; j++) {
            unsigned char c1 = haystack[i+j];
            unsigned char c2 = needle[j];
            if (toupper(c1) != toupper(c2))
                    goto next;
    }
    return (char *) haystack + i;
  next:
    ;
  }
  return NULL;
}


#endif
#ifndef HAVE_STRCASECMP
int strcasecmp( const char *s1, const char *s2 )
{
  int c1, c2;
  do {
    c1 = tolower( (unsigned char) *s1++ );
    c2 = tolower( (unsigned char) *s2++ );
  } while (c1 == c2 && c1 != 0);
  return c2 > c1 ? -1 : c1 > c2;
}
#endif

/*******************************************************************************
* mcfull_file: allocates a full file name=mcdirname+file. Catenate extension if missing.
*******************************************************************************/
char *mcfull_file(char *name, char *ext)
{
  int   dirlen=0;
  char *mem   =NULL;

  dirlen = mcdirname ? strlen(mcdirname) : 0;
  mem = (char*)malloc(dirlen + strlen(name) + CHAR_BUF_LENGTH);
  if(!mem) {
    exit(-fprintf(stderr, "Error: Out of memory %li (mcfull_file)\n", (long)(dirlen + strlen(name) + 256)));
  }
  strcpy(mem, "");

  /* prepend directory name to path if name does not contain a path */
  if (dirlen > 0 && !strchr(name, MC_PATHSEP_C)) {
    strcat(mem, mcdirname);
    strcat(mem, MC_PATHSEP_S);
  } /* dirlen */

  strcat(mem, name);
  if (!strchr(name, '.') && ext && strlen(ext))
  { /* add extension if not in file name already */
    strcat(mem, ".");
    strcat(mem, ext);
  }
  return(mem);
} /* mcfull_file */

/*******************************************************************************
* mcnew_file: opens a new file within mcdirname if non NULL
*             the file is opened in "a" (append, create if does not exist)
*             the extension 'ext' is added if the file name does not include one.
*             the last argument is set to 0 if file did not exist, else to 1.
*******************************************************************************/
FILE *mcnew_file(char *name, char *ext, int *exists)
{
  char *mem;
  FILE *file=NULL;

  if (!name || strlen(name) == 0 || mcdisable_output_files) return(NULL);
  
  mem  = mcfull_file(name, ext); /* create mcdirname/name.ext */
  
  /* check for existence */
  file = fopen(mem, "r"); /* for reading -> fails if does not exist */
  if (file) {
    fclose(file);
    *exists=1;
  } else
    *exists=0;
  
  /* open the file for writing/appending */
#ifdef USE_NEXUS
  if (mcformat && strcasestr(mcformat, "NeXus")) {
    /* NXhandle nxhandle is defined in the .h with USE_NEXUS */
    NXaccess mode = (*exists ? NXACC_CREATE5 | NXACC_RDWR : NXACC_CREATE5);
      
    if (NXopen(mem, mode, &nxhandle) != NX_OK)
      file = NULL;
    else
      file = (FILE*)&nxhandle; /* to make it non NULL */
  } else
#endif
    file = fopen(mem, "a+"); 
    
  if(!file)
    fprintf(stderr, "Warning: could not open output file '%s' for %s (mcnew_file)\n", 
      mem, *exists ? "append" : "create");
  free(mem);

  return file;
} /* mcnew_file */

/*******************************************************************************
* mcdetector_statistics: compute detector statistics, error bars, [x I I_err N] 1D
* RETURN:            updated detector structure
* Used by: mcdetector_import
*******************************************************************************/
MCDETECTOR mcdetector_statistics(
  MCDETECTOR detector)
{

  if (!detector.p1 || !detector.m)
    return(detector);
  
  /* compute statistics and update MCDETECTOR structure ===================== */
  double sum_z  = 0, min_z  = 0, max_z  = 0;
  double fmon_x =0,  smon_x = 0, fmon_y =0, smon_y=0, mean_z=0;
  double Nsum=0, P2sum=0;

  double sum_xz = 0, sum_yz = 0, sum_x = 0, sum_y = 0, sum_x2z = 0, sum_y2z = 0;
  int    i,j;
  char   hasnan=0, hasinf=0;
  char   israw = ((char*)strcasestr(detector.format,"raw") != NULL);
  double *this_p1=NULL; /* new 1D McCode array [x I E N]. Freed after writing data */

  /* if McCode/PGPLOT and rank==1 we create a new m*4 data block=[x I E N] */
  if (detector.rank == 1 && strcasestr(detector.format,"McCode")) {
    this_p1 = (double *)calloc(detector.m*detector.n*detector.p*4, sizeof(double));
    if (!this_p1)
      exit(-fprintf(stderr, "Error: Out of memory creating %li 1D " MCCODE_STRING " data set for file '%s' (mcdetector_import)\n",
        detector.m*detector.n*detector.p*4*sizeof(double*), detector.filename));
  }

  max_z = min_z = detector.p1[0];
  
  /* compute sum and moments (not for lists) */
  if (!strcasestr(detector.format,"list") && detector.m)
  for(j = 0; j < detector.n*detector.p; j++)
  {
    for(i = 0; i < detector.m; i++)
    {
      double x,y,z;
      double N, E;
      long   index= !detector.istransposed ? i*detector.n*detector.p + j : i+j*detector.m;
      char   hasnaninf=0;

      if (detector.m) 
        x = detector.xmin + (i + 0.5)/detector.m*(detector.xmax - detector.xmin); 
      else x = 0;
      if (detector.n && detector.p) 
        y = detector.ymin + (j + 0.5)/detector.n/detector.p*(detector.ymax - detector.ymin); 
      else y = 0;
      z = detector.p1[index];
      N = detector.p0 ? detector.p0[index] : 1;
      E = detector.p2 ? detector.p2[index] : 0;
      if (detector.p2 && !israw) 
        detector.p2[index] = (*mcestimate_error_p)(detector.p0[index],detector.p1[index],detector.p2[index]); /* set sigma */
      
      if (detector.rank == 1 && this_p1 && strcasestr(detector.format,"McCode")) {
        /* fill-in 1D McCode array [x I E N] */
        this_p1[index*4]   = x;
        this_p1[index*4+1] = z;
        this_p1[index*4+2] = detector.p2 ? detector.p2[index] : 0;
        this_p1[index*4+3] = N;
      }
      
      if (isnan(z) || isnan(E) || isnan(N)) hasnaninf=hasnan=1;
      if (isinf(z) || isinf(E) || isinf(N)) hasnaninf=hasinf=1;

      /* compute stats integrals */
      if (!hasnaninf) {
        sum_xz += x*z;
        sum_yz += y*z;
        sum_x  += x;
        sum_y  += y;
        sum_z  += z;
        sum_x2z += x*x*z;
        sum_y2z += y*y*z;
        if (z > max_z) max_z = z;
        if (z < min_z) min_z = z;

        Nsum += N;
        P2sum += E;
      }

    }
  } /* for j */

  /* compute 1st and 2nd moments. For lists, sum_z=0 so this is skipped. */
  if (sum_z && detector.n*detector.m*detector.p)
  {
    fmon_x = sum_xz/sum_z;
    fmon_y = sum_yz/sum_z;
    smon_x = sum_x2z/sum_z-fmon_x*fmon_x; smon_x = smon_x > 0 ? sqrt(smon_x) : 0;
    smon_y = sum_y2z/sum_z-fmon_y*fmon_y; smon_y = smon_y > 0 ? sqrt(smon_y) : 0;
    mean_z = sum_z/detector.n/detector.m/detector.p;
  }
  /* store statistics into detector */
  detector.intensity = sum_z;
  detector.error     = Nsum ? (*mcestimate_error_p)(Nsum, sum_z, P2sum) : 0;
  detector.events    = Nsum;
  detector.min       = min_z;
  detector.max       = max_z;
  detector.mean      = mean_z;
  detector.centerX   = fmon_x;
  detector.halfwidthX= smon_x;
  detector.centerY   = fmon_y;
  detector.halfwidthY= smon_y;

  /* if McCode/PGPLOT and rank==1 replace p1 with new m*4 1D McCode and clear others */
  if (detector.rank == 1 && this_p1 && strcasestr(detector.format,"McCode")) {
    
    detector.p1 = this_p1;
    detector.n  = detector.m; detector.m  = 4;
    detector.p0 = detector.p2 = NULL;
    detector.istransposed = 1;
  }

  if (detector.n*detector.m*detector.p > 1)
    snprintf(detector.signal, CHAR_BUF_LENGTH, 
      "Min=%g; Max=%g; Mean=%g;", detector.min, detector.max, detector.mean);
  else
    strcpy(detector.signal, "None");
  snprintf(detector.values, CHAR_BUF_LENGTH,
    "%g %g %g", detector.intensity, detector.error, detector.events);

  switch (detector.rank) {
    case 1:  snprintf(detector.statistics, CHAR_BUF_LENGTH, "X0=%g; dX=%g;",
      detector.centerX, detector.halfwidthX); break;
    case 2:
    case 3:  snprintf(detector.statistics, CHAR_BUF_LENGTH, "X0=%g; dX=%g; Y0=%g; dY=%g;",
      detector.centerX, detector.halfwidthX, detector.centerY, detector.halfwidthY);
      break;
    default: strcpy(detector.statistics, "None");
  }
  
  if (hasnan)
    printf("WARNING: Nan detected in component/file %s %s\n", 
      detector.component, strlen(detector.filename) ? detector.filename : "");
  if (hasinf)
    printf("WARNING: Inf detected in component/file %s %s\n", 
      detector.component, strlen(detector.filename) ? detector.filename : "");
  
  return(detector);
  
} /* mcdetector_statistics */

/*******************************************************************************
* mcdetector_import: build detector structure, merge non-lists from MPI
*                    compute basic stat, write "Detector:" line
* RETURN:            detector structure. Invalid data if detector.p1 == NULL
*                    Invalid detector sets m=0 and filename=""
*                    Simulation data  sets m=0 and filename=mcsiminfo_name
* This function is equivalent to the old 'mcdetector_out', returning a structure
*******************************************************************************/
MCDETECTOR mcdetector_import(
  char *format,
  char *component, char *title,
  long m, long n,  long p,
  char *xlabel, char *ylabel, char *zlabel,
  char *xvar, char *yvar, char *zvar,
  double x1, double x2, double y1, double y2, double z1, double z2,
  char *filename,
  double *p0, double *p1, double *p2,
  Coords position)
{
  time_t t;       /* for detector.date */
  long   date_l;  /* date as a long number */
  char   istransposed=0;
  char   c[CHAR_BUF_LENGTH]; /* temp var for signal label */

  MCDETECTOR detector;

  /* build MCDETECTOR structure ============================================= */
  /* make sure we do not have NULL for char fields */

  /* these also apply to simfile */
  strncpy (detector.filename,  filename ? filename : "",        CHAR_BUF_LENGTH);
  strncpy (detector.format,    format   ? format   : "McCode" , CHAR_BUF_LENGTH);
  /* add extension if missing */
  if (strlen(detector.filename) && !strchr(detector.filename, '.'))
  { /* add extension if not in file name already */
    strcat(detector.filename, ".dat");
  }
  strncpy (detector.component, component ? component : MCCODE_STRING " component", CHAR_BUF_LENGTH);

  snprintf(detector.instrument, CHAR_BUF_LENGTH, "%s (%s)", mcinstrument_name, mcinstrument_source);
  snprintf(detector.user, CHAR_BUF_LENGTH,      "%s on %s",
        getenv("USER") ? getenv("USER") : MCCODE_NAME,
        getenv("HOST") ? getenv("HOST") : "localhost");
  time(&t);         /* get current write time */
  date_l = (long)t; /* same but as a long */
  snprintf(detector.date, CHAR_BUF_LENGTH, "%s", ctime(&t));
  if (strlen(detector.date))   detector.date[strlen(detector.date)-1] = '\0'; /* remove last \n in date */
  detector.date_l = date_l;

  if (!mcget_run_num() || mcget_run_num() >= mcget_ncount())
    snprintf(detector.ncount, CHAR_BUF_LENGTH, "%llu", mcget_ncount()
#ifdef USE_MPI
*mpi_node_count
#endif
  );
  else
    snprintf(detector.ncount, CHAR_BUF_LENGTH, "%g/%g", (double)mcget_run_num(), (double)mcget_ncount());

  detector.p0         = p0;
  detector.p1         = p1;
  detector.p2         = p2;

  /* handle transposition (not for NeXus) */
  if (!strcasestr(detector.format, "NeXus")) {
    if (m<0 || n<0 || p<0)             istransposed = !istransposed;
    if (strcasestr(detector.format, "transpose")) istransposed = !istransposed;
    if (istransposed) { /* do the swap once for all */
      long i=m; m=n; n=i;
    }
  }

  m=labs(m); n=labs(n); p=labs(p); /* make sure dimensions are positive */
  detector.istransposed = istransposed;

  /* determine detector rank (dimensionality) */
  if (!m || !n || !p || !p1) detector.rank = 4; /* invalid: exit with m=0 filename="" */
  else if (m*n*p == 1)       detector.rank = 0; /* 0D */
  else if (n == 1 || m == 1) detector.rank = 1; /* 1D */
  else if (p == 1)           detector.rank = 2; /* 2D */
  else                       detector.rank = 3; /* 3D */

  /* from rank, set type */
  switch (detector.rank) {
    case 0:  strcpy(detector.type,  "array_0d"); m=n=p=1; break;
    case 1:  snprintf(detector.type, CHAR_BUF_LENGTH, "array_1d(%ld)", m*n*p); m *= n*p; n=p=1; break;
    case 2:  snprintf(detector.type, CHAR_BUF_LENGTH, "array_2d(%ld, %ld)", m, n*p); n *= p; p=1; break;
    case 3:  snprintf(detector.type, CHAR_BUF_LENGTH, "array_3d(%ld, %ld, %ld)", m, n, p); break;
    default: m=0; strcpy(detector.type, ""); strcpy(detector.filename, "");/* invalid */
  }

  detector.m    = m;
  detector.n    = n;
  detector.p    = p;

  /* these only apply to detector files ===================================== */

  snprintf(detector.position, CHAR_BUF_LENGTH, "%g %g %g", position.x, position.y, position.z);
  /* may also store actual detector orientation in the future */

  strncpy(detector.title,      title && strlen(title) ? title : component,       CHAR_BUF_LENGTH);
  strncpy(detector.xlabel,     xlabel && strlen(xlabel) ? xlabel : "X", CHAR_BUF_LENGTH); /* axis labels */
  strncpy(detector.ylabel,     ylabel && strlen(ylabel) ? ylabel : "Y", CHAR_BUF_LENGTH);
  strncpy(detector.zlabel,     zlabel && strlen(zlabel) ? zlabel : "Z", CHAR_BUF_LENGTH);
  strncpy(detector.xvar,       xvar && strlen(xvar) ? xvar :       "x", CHAR_BUF_LENGTH); /* axis variables */
  strncpy(detector.yvar,       yvar && strlen(yvar) ? yvar :       detector.xvar, CHAR_BUF_LENGTH);
  strncpy(detector.zvar,       zvar && strlen(zvar) ? zvar :       detector.yvar, CHAR_BUF_LENGTH);

  /* set "variables" as e.g. "I I_err N" */
  strcpy(c, "I ");
  if (strlen(detector.zvar))      strncpy(c, detector.zvar,32);
  else if (strlen(detector.yvar)) strncpy(c, detector.yvar,32);
  else if (strlen(detector.xvar)) strncpy(c, detector.xvar,32);

  if (detector.rank == 1)
    snprintf(detector.variables, CHAR_BUF_LENGTH, "%s %s %s_err N", detector.xvar, c, c);
  else
    snprintf(detector.variables, CHAR_BUF_LENGTH, "%s %s_err N", c, c);

  /* limits */
  detector.xmin = x1;
  detector.xmax = x2;
  detector.ymin = y1;
  detector.ymax = y2;
  detector.zmin = z1;
  detector.zmax = z2;
  if (abs(detector.rank) == 1)
    snprintf(detector.limits, CHAR_BUF_LENGTH, "%g %g", x1, x2);
  else if (detector.rank == 2)
    snprintf(detector.limits, CHAR_BUF_LENGTH, "%g %g %g %g", x1, x2, y1, y2);
  else
    snprintf(detector.limits, CHAR_BUF_LENGTH, "%g %g %g %g %g %g", x1, x2, y1, y2, z1, z2);

  /* if MPI and nodes_nb > 1: reduce data sets when using MPI =============== */
#ifdef USE_MPI
  if (!strcasestr(detector.format,"list") && mpi_node_count > 1 && m) {
    /* we save additive data: reduce everything into mpi_node_root */
    if (p0) mc_MPI_Sum(p0, m*n*p);
    if (p1) mc_MPI_Sum(p1, m*n*p);
    if (p2) mc_MPI_Sum(p2, m*n*p);
    if (!p0) {  /* additive signal must be then divided by the number of nodes */
      int i;
      for (i=0; i<m*n*p; i++) {
        p1[i] /= mpi_node_count;
        if (p2) p2[i] /= mpi_node_count;
      }
    }
  }
#endif /* USE_MPI */

  /* compute statistics, Nsum, intensity, Error bars */
  detector = mcdetector_statistics(detector);

#ifdef USE_MPI
  /* slaves are done */
  if(mpi_node_rank != mpi_node_root) {
    return detector;
  }
#endif

  /* output "Detector:" line ================================================ */
  /* when this is a detector written by a component (not the SAVE from instrument),
     not an event lists */
  if (!m) return(detector);
  if (!strcasestr(detector.format,"list")) {
    if (!strcmp(detector.component, mcinstrument_name)) {
      if (strlen(detector.filename))  /* we name it from its filename, or from its title */
        strncpy(c, detector.filename, CHAR_BUF_LENGTH);
      else
        snprintf(c, CHAR_BUF_LENGTH, "%s", mcinstrument_name);
    } else
      strncpy(c, detector.component, CHAR_BUF_LENGTH);  /* usual detectors written by components */

    printf("Detector: %s_I=%g %s_ERR=%g %s_N=%g",
           c, detector.intensity,
           c, detector.error,
           c, detector.events);
    printf(" \"%s\"\n", strlen(detector.filename) ? detector.filename : detector.component);
  }
  

  return(detector);
} /* mcdetector_import */

/* end MCDETECTOR import section ============================================ */

















/* ========================================================================== */

/*                               ASCII output                                 */
/*     The SIM file is YAML based, the data files have '#' headers            */

/* ========================================================================== */


/*******************************************************************************
* mcinfo_out: output instrument tags/info (only in SIM)
* Used in: mcsiminfo_init (ascii), mcinfo(stdout)
*******************************************************************************/
static void mcinfo_out(char *pre, FILE *f)
{
  char Parameters[CHAR_BUF_LENGTH] = "";
  int  i;

  if (!f || mcdisable_output_files) return;

  /* create parameter string ================================================ */
  for(i = 0; i < mcnumipar; i++)
  {
    char ThisParam[CHAR_BUF_LENGTH];
    if (strlen(mcinputtable[i].name) > CHAR_BUF_LENGTH) break;
    snprintf(ThisParam, CHAR_BUF_LENGTH, " %s(%s)", mcinputtable[i].name,
            (*mcinputtypes[mcinputtable[i].type].parminfo)
                (mcinputtable[i].name));
    strcat(Parameters, ThisParam);
    if (strlen(Parameters) >= CHAR_BUF_LENGTH-64) break;
  }

  /* output data ============================================================ */
  if (f != stdout)
    fprintf(f, "%sFile: %s%c%s\n",    pre, mcdirname, MC_PATHSEP_C, mcsiminfo_name);
  else
    fprintf(f, "%sCreator: %s\n",     pre, MCCODE_STRING);

  fprintf(f, "%sSource: %s\n",   pre, mcinstrument_source);
  fprintf(f, "%sParameters: %s\n",    pre, Parameters);
  
  fprintf(f, "%sTrace_enabled: %s\n", pre, mctraceenabled ? "yes" : "no");
  fprintf(f, "%sDefault_main: %s\n",  pre, mcdefaultmain ?  "yes" : "no");
  fprintf(f, "%sEmbedded_runtime: %s\n", pre, 
#ifdef MC_EMBEDDED_RUNTIME
         "yes"
#else
         "no"
#endif
         );

  fflush(f);
} /* mcinfo_out */

/*******************************************************************************
* mcruninfo_out_backend: output simulation tags/info (both in SIM and data files)
* Used in: mcsiminfo_init (ascii case), mcdetector_out_xD_ascii, mcinfo(stdout)
*******************************************************************************/
static void mcruninfo_out_backend(char *pre, FILE *f, int info)
{
  int i;
  char Parameters[CHAR_BUF_LENGTH];

  if (!f || mcdisable_output_files) return;

  fprintf(f, "%sFormat: %s%s\n",      pre, 
    mcformat && strlen(mcformat) ? mcformat : MCCODE_NAME,
    mcformat && strcasestr(mcformat,"McCode") ? " with text headers" : "");
  fprintf(f, "%sURL: %s\n",         pre, "http://www.mccode.org");
  fprintf(f, "%sCreator: %s\n",     pre, MCCODE_STRING);
  fprintf(f, "%sInstrument: %s\n", pre, mcinstrument_source);
  fprintf(f, "%sNcount: %llu\n",        pre, mcget_ncount());
  fprintf(f, "%sTrace: %s\n",       pre, mcdotrace ? "yes" : "no");
  fprintf(f, "%sGravitation: %s\n", pre, mcgravitation ? "yes" : "no");
  snprintf(Parameters, CHAR_BUF_LENGTH, "%ld", mcseed);
  fprintf(f, "%sSeed: %s\n",        pre, Parameters);
  fprintf(f, "%sDirectory: %s\n",        pre, mcdirname ? mcdirname : ".");
#ifdef USE_MPI
  if (mpi_node_count > 1)
    fprintf(f, "%sNodes: %i\n",        pre, mpi_node_count);
#endif

  /* output parameter string ================================================ */
  for(i = 0; i < mcnumipar; i++) {
      if (!info){
          (*mcinputtypes[mcinputtable[i].type].printer)(Parameters, mcinputtable[i].par);
          fprintf(f, "%sParam: %s=%s\n", pre, mcinputtable[i].name, Parameters);
      }else{
        /*if an info run, some variables might not have values. Flag these by "NULL"*/
	if(mcinputtable[i].val && strlen(mcinputtable[i].val)){
            /* ... those with defautl values*/
            (*mcinputtypes[mcinputtable[i].type].printer)(Parameters, mcinputtable[i].par);
            fprintf(f, "%sParam: %s=%s\n", pre, mcinputtable[i].name, Parameters);
        }else{
            /* ... and those without */
            fprintf(f, "%sParam: %s=NULL\n", pre, mcinputtable[i].name);
	}
      }
  }
} /* mcruninfo_out_backend */

/************************
* wrapper function to mcruninfo_out_backend
*  Regular runs use this whereas the single call from mcinfo is directly to the backend
*************************/
static void mcruninfo_out(char *pre, FILE *f){
    mcruninfo_out_backend(pre,f,0);
}

/*******************************************************************************
* mcsiminfo_out:    wrapper to fprintf(mcsiminfo_file)
*******************************************************************************/
void mcsiminfo_out(char *format, ...)
{
  va_list ap;

  if(mcsiminfo_file && !mcdisable_output_files)
  {
    va_start(ap, format);
    vfprintf(mcsiminfo_file, format, ap);
    va_end(ap);
  }
} /* mcsiminfo_out */


/*******************************************************************************
* mcdatainfo_out: output detector header
*   mcdatainfo_out(prefix, file_handle, detector) writes info to data file
*******************************************************************************/
static void
mcdatainfo_out(char *pre, FILE *f, MCDETECTOR detector)
{
  if (!f || !detector.m || mcdisable_output_files) return;
  
  /* output data ============================================================ */
  fprintf(f, "%sDate: %s (%li)\n",       pre, detector.date, detector.date_l);
  fprintf(f, "%stype: %s\n",       pre, detector.type);
  fprintf(f, "%sSource: %s\n",     pre, detector.instrument);
  fprintf(f, "%scomponent: %s\n",  pre, detector.component);
  fprintf(f, "%sposition: %s\n",   pre, detector.position);

  fprintf(f, "%stitle: %s\n",      pre, detector.title);
  fprintf(f, !mcget_run_num() || mcget_run_num() >= mcget_ncount() ?
             "%sNcount: %s\n" : 
             "%sratio: %s\n",  pre, detector.ncount);

  if (strlen(detector.filename)) {
    fprintf(f, "%sfilename: %s\n", pre, detector.filename);
  }

  fprintf(f, "%sstatistics: %s\n", pre, detector.statistics);
  fprintf(f, "%ssignal: %s\n",     pre, detector.signal);
  fprintf(f, "%svalues: %s\n",     pre, detector.values);

  if (detector.rank >= 1)
  {
    fprintf(f, "%sxvar: %s\n",     pre, detector.xvar);
    fprintf(f, "%syvar: %s\n",     pre, detector.yvar);
    fprintf(f, "%sxlabel: %s\n",   pre, detector.xlabel);
    fprintf(f, "%sylabel: %s\n",   pre, detector.ylabel);
    if (detector.rank > 1) {
      fprintf(f, "%szvar: %s\n",   pre, detector.zvar);
      fprintf(f, "%szlabel: %s\n", pre, detector.zlabel);
    }
  }

  fprintf(f, 
    abs(detector.rank)==1 ?
             "%sxlimits: %s\n" : 
             "%sxylimits: %s\n", pre, detector.limits);
  fprintf(f, "%svariables: %s\n", pre, 
    strcasestr(detector.format, "list") ? detector.ylabel : detector.variables);
    
  fflush(f);

} /* mcdatainfo_out */

/* mcdetector_out_array_ascii: output a single array to a file
 *   m: columns
 *   n: rows
 *   p: array
 *   f: file handle (already opened)
 */
static void mcdetector_out_array_ascii(long m, long n, double *p, FILE *f, char istransposed)
{
  if(f)
  {
    int i,j;
    for(j = 0; j < n; j++)
    {
      for(i = 0; i < m; i++)
      {
          fprintf(f, "%.10g ", p[!istransposed ? i*n + j : j*m+i]);
      }
      fprintf(f,"\n");
    }
  }
} /* mcdetector_out_array_ascii */

/*******************************************************************************
* mcdetector_out_0D_ascii: called by mcdetector_out_0D for ascii output
*******************************************************************************/
MCDETECTOR mcdetector_out_0D_ascii(MCDETECTOR detector)
{
  int exists=0;
  FILE *outfile = NULL;
  
  /* Write data set information to simulation description file. */
  MPI_MASTER(
    mcsiminfo_out("\nbegin data\n"); // detector.component
    mcdatainfo_out("  ", mcsiminfo_file, detector);
    mcsiminfo_out("end data\n");
    /* Don't write if filename is NULL: mcnew_file handles this (return NULL) */
    outfile = mcnew_file(detector.component, "dat", &exists);
    if(outfile)
    {
      /* write data file header and entry in simulation description file */
      mcruninfo_out( "# ", outfile);
      mcdatainfo_out("# ", outfile, detector);
      /* write I I_err N */
      fprintf(outfile, "%g %g %g\n", 
        detector.intensity, detector.error, detector.events);
      fclose(outfile);
    }
  ); /* MPI_MASTER */
  return(detector);
} /* mcdetector_out_0D_ascii */

/*******************************************************************************
* mcdetector_out_1D_ascii: called by mcdetector_out_1D for ascii output
*******************************************************************************/
MCDETECTOR mcdetector_out_1D_ascii(MCDETECTOR detector)
{
  int exists=0;
  FILE *outfile = NULL;

  MPI_MASTER(
    /* Write data set information to simulation description file. */
    mcsiminfo_out("\nbegin data\n"); // detector.filename
    mcdatainfo_out("  ", mcsiminfo_file, detector);
    mcsiminfo_out("end data\n");
    /* Loop over array elements, writing to file. */
    /* Don't write if filename is NULL: mcnew_file handles this (return NULL) */
    outfile = mcnew_file(detector.filename, "dat", &exists);
    if(outfile)
    {
      /* write data file header and entry in simulation description file */
      mcruninfo_out( "# ", outfile);
      mcdatainfo_out("# ", outfile, detector);
      /* output the 1D array columns */
      mcdetector_out_array_ascii(detector.m, detector.n, detector.p1, outfile, detector.istransposed);
      
      fclose(outfile);
    }
  ); /* MPI_MASTER */
  return(detector);
  
}  /* mcdetector_out_1D_ascii */

/*******************************************************************************
* mcdetector_out_2D_ascii: called by mcdetector_out_2D for ascii output
*******************************************************************************/
MCDETECTOR mcdetector_out_2D_ascii(MCDETECTOR detector)
{
  int exists=0;
  FILE *outfile = NULL;
  
  MPI_MASTER(
    /* Loop over array elements, writing to file. */
    /* Don't write if filename is NULL: mcnew_file handles this (return NULL) */
    outfile = mcnew_file(detector.filename, "dat", &exists);
    if(outfile)
    {
      /* write header only if file has just been created (not appending) */
      if (!exists) {
        /* Write data set information to simulation description file. */
        mcsiminfo_out("\nbegin data\n"); // detector.filename
        mcdatainfo_out("  ", mcsiminfo_file, detector);
        mcsiminfo_out("end data\n");
      
        mcruninfo_out( "# ", outfile);
        mcdatainfo_out("# ", outfile,   detector);
      }
      fprintf(outfile, "# Data [%s/%s] %s:\n", detector.component, detector.filename, detector.zvar);
      mcdetector_out_array_ascii(detector.m, detector.n*detector.p, detector.p1, 
        outfile, detector.istransposed);
      if (detector.p2) {
        fprintf(outfile, "# Errors [%s/%s] %s_err:\n", detector.component, detector.filename, detector.zvar);
        mcdetector_out_array_ascii(detector.m, detector.n*detector.p, detector.p2, 
          outfile, detector.istransposed);
      }
      if (detector.p0) {
        fprintf(outfile, "# Events [%s/%s] N:\n", detector.component, detector.filename);
        mcdetector_out_array_ascii(detector.m, detector.n*detector.p, detector.p0, 
          outfile, detector.istransposed);
      }
      fclose(outfile);
      
      if (!exists) {
        if (strcasestr(detector.format, "list"))
          printf("Events:   \"%s\"\n",  
            strlen(detector.filename) ? detector.filename : detector.component);
      }
    } /* if outfile */
  ); /* MPI_MASTER */
#ifdef USE_MPI
  if (strcasestr(detector.format, "list") && mpi_node_count > 1) {
    int node_i=0;
    /* loop along MPI nodes to write sequentially */
    for(node_i=0; node_i<mpi_node_count; node_i++) {
      /* MPI: slaves wait for the master to write its block, then append theirs */
      MPI_Barrier(MPI_COMM_WORLD);
      if (node_i != mpi_node_root && node_i == mpi_node_rank) {
        if(strlen(detector.filename) && !mcdisable_output_files)	/* Don't write if filename is NULL */
          outfile = mcnew_file(detector.filename, "dat", &exists);
        if (!exists)
          fprintf(stderr, "Warning: [MPI node %i] file '%s' does not exist yet, "
                          "MASTER should have opened it before.\n",
            mpi_node_rank, detector.filename);
        if(outfile) {
          mcdetector_out_array_ascii(detector.m, detector.n*detector.p, detector.p1, 
            outfile, detector.istransposed);
          fclose(outfile);
        }
      }
    }
  } /* if strcasestr list */
#endif
  return(detector);
} /* mcdetector_out_2D_ascii */

/*******************************************************************************
* strcpy_valid: makes a valid string for variable names.
*   copy 'original' into 'valid', replacing invalid characters by '_'
*   char arrays must be pre-allocated
*******************************************************************************/
static char *strcpy_valid(char *valid, char *original)
{
  long i;
  int  n=32; /* max length of valid names */

  if (original == NULL || !strlen(original)) return(NULL);

  if (n > strlen(original)) n = strlen(original);
  else original += strlen(original)-n;
  strncpy(valid, original, n);

  for (i=0; i < n; i++)
  {
    if ( (valid[i] > 122)
      || (valid[i] < 32)
      || (strchr("!\"#$%&'()*+,-.:;<=>?@[\\]^`/ \n\r\t", valid[i]) != NULL) )
    {
      if (i) valid[i] = '_'; else valid[i] = 'm';
    }
  }
  valid[i] = '\0';

  return(valid);
} /* strcpy_valid */

/* end ascii output section ================================================= */







#ifdef USE_NEXUS

/* ========================================================================== */

/*                               NeXus output                                 */

/* ========================================================================== */

#define nxprintf(...)    nxstr('d', __VA_ARGS__)
#define nxprintattr(...) nxstr('a', __VA_ARGS__)

/*******************************************************************************
* nxstr: output a tag=value data set (char) in NeXus/current group
*   when 'format' is larger that 1024 chars it is used as value for the 'tag'
*   else the value is assembled with format and following arguments.
*   type='d' -> data set
*        'a' -> attribute for current data set
*******************************************************************************/
static int nxstr(char type, NXhandle *f, char *tag, char *format, ...)
{
  va_list ap;
  char value[CHAR_BUF_LENGTH];
  int  i;
  int  ret=NX_OK;
  
  if (!tag || !format || !strlen(tag) || !strlen(format)) return(NX_OK);
  
  /* assemble the value string */
  if (strlen(format) < CHAR_BUF_LENGTH) {
    va_start(ap, format);
    ret = vsnprintf(value, CHAR_BUF_LENGTH, format, ap);
    va_end(ap);
  
    i = strlen(value);
  } else {
    i = strlen(format);
  }

  if (type == 'd') {
    /* open/put/close data set */
    if (NXmakedata (f, tag, NX_CHAR, 1, &i) != NX_OK) return(NX_ERROR);
    NXopendata (f, tag);
    if (strlen(format) < CHAR_BUF_LENGTH)
      ret = NXputdata  (f, value);
    else
      ret = NXputdata  (f, format);
    NXclosedata(f);
  } else {
    if (strlen(format) < CHAR_BUF_LENGTH)
      ret = NXputattr  (f, tag, value, strlen(value), NX_CHAR);
    else
      ret = NXputattr  (f, tag, format, strlen(format), NX_CHAR);
  }
  
  return(ret);
  
} /* nxstr */

/*******************************************************************************
* mcinfo_readfile: read a full file into a string buffer which is allocated
*   Think to free the buffer after use.
* Used in: mcinfo_out_nexus (nexus)
*******************************************************************************/
char *mcinfo_readfile(char *filename)
{
  FILE *f = fopen(filename, "rb");
  if (!f) return(NULL);
  fseek(f, 0, SEEK_END);
  long fsize = ftell(f);
  rewind(f);
  char *string = malloc(fsize + 1);
  if (string) {
    int n = fread(string, fsize, 1, f);
    fclose(f);

    string[fsize] = 0;
  }
  return(string);
}

/*******************************************************************************
* mcinfo_out: output instrument/simulation groups in NeXus file
* Used in: mcsiminfo_init (nexus)
*******************************************************************************/
static void mcinfo_out_nexus(NXhandle f)
{
  FILE  *fid;     /* for intrument source code/C/IDF */
  char  *buffer=NULL;
  time_t t     =time(NULL); /* for date */
  char   entry0[CHAR_BUF_LENGTH];
  int    count=0;
  char   name[CHAR_BUF_LENGTH];
  char   class[CHAR_BUF_LENGTH];
  
  if (!f || mcdisable_output_files) return;
  
  /* write NeXus NXroot attributes */
  /* automatically added: file_name, HDF5_Version, file_time, NeXus_version */ 
  nxprintattr(f, "creator",   "%s generated with " MCCODE_STRING, mcinstrument_name);
  
  /* count the number of existing NXentry and create the next one */
  NXgetgroupinfo(f, &count, name, class);
  sprintf(entry0, "entry%i", count+1);

  /* create the main NXentry (mandatory in NeXus) */
  if (NXmakegroup(f, entry0, "NXentry") == NX_OK) 
  if (NXopengroup(f, entry0, "NXentry") == NX_OK) {
    
    nxprintf(nxhandle, "program_name", MCCODE_STRING);
    nxprintf(f, "start_time", ctime(&t));
    nxprintf(f, "title", "%s%s%s simulation generated by instrument %s", 
      mcdirname && strlen(mcdirname) ? mcdirname : ".", MC_PATHSEP_S, mcsiminfo_name,
      mcinstrument_name);
    nxprintattr(f, "program_name", MCCODE_STRING);
    nxprintattr(f, "instrument",   mcinstrument_name);
    nxprintattr(f, "simulation",   "%s%s%s",
        mcdirname && strlen(mcdirname) ? mcdirname : ".", MC_PATHSEP_S, mcsiminfo_name);

    /* write NeXus instrument group */
    if (NXmakegroup(f, "instrument", "NXinstrument") == NX_OK)
    if (NXopengroup(f, "instrument", "NXinstrument") == NX_OK) {
      int   i;
      char *string=NULL;

      /* write NeXus parameters(types) data =================================== */
      string = (char*)malloc(CHAR_BUF_LENGTH);
      if (string) {
        strcpy(string, "");
        for(i = 0; i < mcnumipar; i++)
        {
          char ThisParam[CHAR_BUF_LENGTH];
          snprintf(ThisParam, CHAR_BUF_LENGTH, " %s(%s)", mcinputtable[i].name,
                  (*mcinputtypes[mcinputtable[i].type].parminfo)
                      (mcinputtable[i].name));
          if (strlen(string) + strlen(ThisParam) < CHAR_BUF_LENGTH)
            strcat(string, ThisParam);
        }
        nxprintattr(f, "Parameters",    string);
        free(string);
      }
        
      nxprintattr(f, "name",          mcinstrument_name);
      nxprintf   (f, "name",          mcinstrument_name);
      nxprintattr(f, "Source",        mcinstrument_source);
      
      nxprintattr(f, "Trace_enabled", mctraceenabled ? "yes" : "no");
      nxprintattr(f, "Default_main",  mcdefaultmain ?  "yes" : "no");
      nxprintattr(f, "Embedded_runtime",  
  #ifdef MC_EMBEDDED_RUNTIME
           "yes"
  #else
           "no"
  #endif
           );
           
      /* add instrument source code when available */
      buffer = mcinfo_readfile(mcinstrument_source);
      if (buffer && strlen(buffer)) {
        long length=strlen(buffer);
        nxprintf (f, "description", buffer);
        NXopendata(f,"description");
        nxprintattr(f, "file_name", mcinstrument_source);
        nxprintattr(f, "file_size", "%li", length);
        nxprintattr(f, "MCCODE_STRING", MCCODE_STRING);
        NXclosedata(f);
        nxprintf (f,"instrument_source", "%s " MCCODE_NAME " " MCCODE_PARTICLE " Monte Carlo simulation", mcinstrument_name);
        free(buffer);
      } else
        nxprintf (f, "description", "File %s not found (instrument description %s is missing)", 
          mcinstrument_source, mcinstrument_name);
      
      /* add Mantid/IDF.xml when available */
      char *IDFfile=NULL;
      IDFfile = (char*)malloc(CHAR_BUF_LENGTH);
      sprintf(IDFfile,"%s%s",mcinstrument_source,".xml");
      buffer = mcinfo_readfile(IDFfile);
      if (buffer && strlen(buffer)) {
        NXmakegroup (nxhandle, "instrument_xml", "NXnote");
        NXopengroup (nxhandle, "instrument_xml", "NXnote");
        nxprintf(f, "data", buffer);
        nxprintf(f, "description", "IDF.xml file found with instrument %s", mcinstrument_source);
        nxprintf(f, "type", "text/xml");
        NXclosegroup(f); /* instrument_xml */
        free(buffer);
      }
      free(IDFfile);
      NXclosegroup(f); /* instrument */
    } /* NXinstrument */

    /* write NeXus simulation group */
    if (NXmakegroup(f, "simulation", "NXnote") == NX_OK)
    if (NXopengroup(f, "simulation", "NXnote") == NX_OK) {

      nxprintattr(f, "name",   "%s%s%s",
        mcdirname && strlen(mcdirname) ? mcdirname : ".", MC_PATHSEP_S, mcsiminfo_name);
      
      nxprintf   (f, "name",      "%s",     mcsiminfo_name);
      nxprintattr(f, "Format",    mcformat && strlen(mcformat) ? mcformat : MCCODE_NAME);
      nxprintattr(f, "URL",       "http://www.mccode.org");
      nxprintattr(f, "program",   MCCODE_STRING);
      nxprintattr(f, "Instrument",mcinstrument_source);
      nxprintattr(f, "Trace",     mcdotrace ?     "yes" : "no");
      nxprintattr(f, "Gravitation",mcgravitation ? "yes" : "no");
      nxprintattr(f, "Seed",      "%li", mcseed);
      nxprintattr(f, "Directory", mcdirname);
    #ifdef USE_MPI
      if (mpi_node_count > 1)
        nxprintf(f, "Nodes", "%i",        mpi_node_count);
    #endif
    
      /* output parameter string ================================================ */
      if (NXmakegroup(f, "Param", "NXparameters") == NX_OK)
      if (NXopengroup(f, "Param", "NXparameters") == NX_OK) {
        int i;
        char string[CHAR_BUF_LENGTH];
        for(i = 0; i < mcnumipar; i++) {
          if (mcget_run_num() || (mcinputtable[i].val && strlen(mcinputtable[i].val))) {
            if (mcinputtable[i].par == NULL)
              strncpy(string, (mcinputtable[i].val ? mcinputtable[i].val : ""), CHAR_BUF_LENGTH);
            else
              (*mcinputtypes[mcinputtable[i].type].printer)(string, mcinputtable[i].par);

            nxprintf(f,  mcinputtable[i].name, "%s", string);
            nxprintattr(f, mcinputtable[i].name, string);
          }
        }
        NXclosegroup(f); /* Param */
      } /* NXparameters */
      
      NXclosegroup(f); /* simulation */
    } /* NXsimulation */
    
    /* create a group to hold all monitors */
    NXmakegroup(f, "data", "NXdetector");

    /* leave the NXentry opened (closed at exit) */
  } /* NXentry */
} /* mcinfo_out_nexus */

/*******************************************************************************
* mcdatainfo_out_nexus: output detector header
*   mcdatainfo_out_nexus(detector) create group and write info to NeXus data file
*   open data:NXdetector then filename:NXdata and write headers/attributes
*   requires: NXentry to be opened
*******************************************************************************/
static void
mcdatainfo_out_nexus(NXhandle f, MCDETECTOR detector)
{
  char data_name[32];
  if (!f || !detector.m || mcdisable_output_files) return;
  
  strcpy_valid(data_name, 
    detector.filename && strlen(detector.filename) ? 
      detector.filename : detector.component);

  /* the NXdetector group has been created in mcinfo_out_nexus (mcsiminfo_init) */
  if (NXopengroup(f, "data", "NXdetector") == NX_OK) {

    /* create and open the data group */
    /* this may fail when appending to list -> ignore/skip */
    NXMDisableErrorReporting(); /* unactivate NeXus error messages, as creation may fail */
    
    if (NXmakegroup(f, data_name, "NXdata") == NX_OK)
    if (NXopengroup(f, data_name, "NXdata") == NX_OK) {
    
      /* output metadata (as attributes) ======================================== */
      nxprintattr(f, "Date",       detector.date);
      nxprintattr(f, "type",       detector.type);
      nxprintattr(f, "Source",     detector.instrument);
      nxprintattr(f, "component",  detector.component);
      nxprintattr(f, "position",   detector.position);

      nxprintattr(f, "title",      detector.title);
      nxprintattr(f, !mcget_run_num() || mcget_run_num() >= mcget_ncount() ?
                 "Ncount" : 
                 "ratio",  detector.ncount);

      if (strlen(detector.filename)) {
        nxprintattr(f, "filename", detector.filename);
      }

      nxprintattr(f, "statistics", detector.statistics);
      nxprintattr(f, "signal",     detector.signal);
      nxprintattr(f, "values",     detector.values);

      if (detector.rank >= 1)
      {
        nxprintattr(f, "xvar",     detector.xvar);
        nxprintattr(f, "yvar",     detector.yvar);
        nxprintattr(f, "xlabel",   detector.xlabel);
        nxprintattr(f, "ylabel",   detector.ylabel);
        if (detector.rank > 1) {
          nxprintattr(f, "zvar",   detector.zvar);
          nxprintattr(f, "zlabel", detector.zlabel);
        }
      }

      nxprintattr(f, abs(detector.rank)==1 ?
                 "xlimits" : 
                 "xylimits", detector.limits);
      nxprintattr(f, "variables", 
        strcasestr(detector.format, "list") ? detector.ylabel : detector.variables);
      nxprintf(f, "distance", detector.position);
      nxprintf(f, "acquisition_mode",
        strcasestr(detector.format, "list") ? "event" : "summed");
        
      NXclosegroup(f);
    } /* NXdata (filename) */
    NXMEnableErrorReporting();  /* re-enable NeXus error messages */
    NXclosegroup(f);
  } /* NXdetector (data) */
  
} /* mcdatainfo_out_nexus */

/*******************************************************************************
* mcdetector_out_axis_nexus: write detector axis into current NXdata
*   requires: NXdata to be opened
*******************************************************************************/
int mcdetector_out_axis_nexus(NXhandle f, char *label, char *var, int rank, long length, double min, double max)
{
  if (!f || length <= 1 || mcdisable_output_files || max == min) return(NX_OK);
  else {
    double axis[length];
    char valid[32];
    int dim=(int)length;
    int i;
    int nprimary=1;
    /* create an axis from [min:max] */
    for(i = 0; i < length; i++)
      axis[i] = min+(max-min)*(i+0.5)/length;
    /* create the data set */
    strcpy_valid(valid, label);
    NXcompmakedata(f, valid, NX_FLOAT64, 1, &dim, NX_COMP_LZW, &dim);
    /* open it */
    if (NXopendata(f, valid) != NX_OK) {
      fprintf(stderr, "Warning: could not open axis rank %i '%s' (NeXus)\n",
        rank, valid);
      return(NX_ERROR);
    }
    /* put the axis and its attributes */
    NXputdata  (f, axis);
    nxprintattr(f, "long_name",  label);
    nxprintattr(f, "short_name", var);
    NXputattr  (f, "axis",       &rank,     1, NX_INT32);
    nxprintattr(f, "units",      var);
    NXputattr  (f, "primary",    &nprimary, 1, NX_INT32);
    NXclosedata(f);
    
    return(NX_OK);
  }
} /* mcdetector_out_axis_nexus */

/*******************************************************************************
* mcdetector_out_array_nexus: write detector array into current NXdata (1D,2D)
*   requires: NXdata to be opened
*******************************************************************************/
int mcdetector_out_array_nexus(NXhandle f, char *part, double *data, MCDETECTOR detector)
{
  
  int dims[3]={detector.m,detector.n,detector.p};  /* number of elements to write */
  int signal=1;
  int exists=0;
  int current_dims[3]={0,0,0};
  int ret=NX_OK;
  
  if (!f || !data || !detector.m || mcdisable_output_files) return(NX_OK);
  
  /* when this is a list, we set 1st dimension to NX_UNLIMITED for creation */
  if (strcasestr(detector.format, "list")) dims[0] = NX_UNLIMITED;
  
  /* create the data set in NXdata group */
  NXMDisableErrorReporting(); /* unactivate NeXus error messages, as creation may fail */
  /* NXcompmakedata fails with NX_UNLIMITED */
  if (strcasestr(detector.format, "list"))
    ret = NXmakedata(    f, part, NX_FLOAT64, detector.rank, dims);
  else
    ret = NXcompmakedata(f, part, NX_FLOAT64, detector.rank, dims, NX_COMP_LZW, dims);
  if (ret != NX_OK) {
    /* failed: data set already exists */
    int datatype=0;
    int rank=0;
    exists=1;
    /* inquire current size of data set (nb of events stored) */
    NXopendata(f, part);
    NXgetinfo(f, &rank, current_dims, &datatype);
    NXclosedata(f);
  }
  NXMEnableErrorReporting();  /* re-enable NeXus error messages */
  dims[0] = detector.m; /* restore actual dimension from data writing */
  
  /* open the data set */
  if (NXopendata(f, part) == NX_ERROR) {
    fprintf(stderr, "Warning: could not open DataSet %s '%s' (NeXus)\n",
      part, detector.title);
    return(NX_ERROR);
  }
  if (strcasestr(detector.format, "list")) {
    current_dims[1] = current_dims[2] = 0; /* set starting location for writing slab */
    NXputslab(f, data, current_dims, dims);
    if (!exists)
      printf("Events:   \"%s\"\n",  
        strlen(detector.filename) ? detector.filename : detector.component);
  } else {
    NXputdata (f, data);
  }
  
  if (strstr(part,"data") || strstr(part, "events")) {
    NXputattr(f, "signal", &signal, 1, NX_INT32);
    nxprintattr(f, "short_name", detector.filename && strlen(detector.filename) ? 
      detector.filename : detector.component);
  }
  nxprintattr(f, "long_name", "%s '%s'", part, detector.title);
  NXclosedata(f);
  
  return(NX_OK);
} /* mcdetector_out_array_nexus */

/*******************************************************************************
* mcdetector_out_data_nexus: write detector axes+data into current NXdata
*   The data:NXdetector is opened, then filename:NXdata
*   requires: NXentry to be opened
*******************************************************************************/
int mcdetector_out_data_nexus(NXhandle f, MCDETECTOR detector)
{
  char data_name[32];
  
  if (!f || !detector.m || mcdisable_output_files) return(NX_OK);
  
  strcpy_valid(data_name, 
    detector.filename && strlen(detector.filename) ? 
      detector.filename : detector.component);

  /* the NXdetector group has been created in mcinfo_out_nexus (mcsiminfo_init) */
  if (NXopengroup(f, "data", "NXdetector") == NX_OK) {

    /* the NXdata group has been created in mcdatainfo_out_nexus */
    if (NXopengroup(f, data_name, "NXdata") == NX_OK) {
  
      /* write axes, for histogram data sets, not for lists */
      if (!strcasestr(detector.format, "list")) {
        mcdetector_out_axis_nexus(f, detector.xlabel, detector.xvar, 
          1, detector.m, detector.xmin, detector.xmax);
          
        mcdetector_out_axis_nexus(f, detector.ylabel, detector.yvar, 
          2, detector.n, detector.ymin, detector.ymax);
          
        mcdetector_out_axis_nexus(f, detector.zlabel, detector.zvar, 
          3, detector.p, detector.zmin, detector.zmax);

      } /* !list */
      
      /* write the actual data (appended if already exists) */
      if (!strcasestr(detector.format, "list")) {
        mcdetector_out_array_nexus(f, "data", detector.p1, detector);
        mcdetector_out_array_nexus(f, "errors", detector.p2, detector);
        mcdetector_out_array_nexus(f, "ncount", detector.p0, detector);
      } else
        mcdetector_out_array_nexus(  f, "events", detector.p1, detector);
      
      NXclosegroup(f);
    } /* NXdata */
    NXclosegroup(f);
  } /* NXdetector */
  
  return(NX_OK);
} /* mcdetector_out_array_nexus */

#ifdef USE_MPI
/*******************************************************************************
* mcdetector_out_list_slaves: slaves send their list data to master which writes
*   requires: NXentry to be opened
* WARNING: this method has a flaw: it requires all nodes to flush the lists
*   the same number of times. In case one node is just below the buffer size
*   when finishing (e.g. monitor_nd), it may not trigger save but others may. 
*   Then the number of recv/send is not constant along nodes, and simulation stalls.  
*******************************************************************************/
MCDETECTOR mcdetector_out_list_slaves(MCDETECTOR detector)
{
  int     node_i=0;
  MPI_MASTER(
	     printf("\n** MPI master gathering slave node list data ** \n");
  );
  
  if (mpi_node_rank != mpi_node_root) {
    /* MPI slave: slaves send their data to master: 2 MPI_Send calls */
    /* m, n, p must be sent first, since all slaves do not have the same number of events */
    int mnp[3]={detector.m,detector.n,detector.p};

    if (mc_MPI_Send(mnp, 3, MPI_INT, mpi_node_root)!= MPI_SUCCESS)
      fprintf(stderr, "Warning: proc %i to master: MPI_Send mnp list error (mcdetector_out_list_slaves)\n", mpi_node_rank);
    if (!detector.p1
     || mc_MPI_Send(detector.p1, mnp[0]*mnp[1]*mnp[2], MPI_DOUBLE, mpi_node_root) != MPI_SUCCESS)
      fprintf(stderr, "Warning: proc %i to master: MPI_Send p1 list error: mnp=%i (mcdetector_out_list_slaves)\n", mpi_node_rank, abs(mnp[0]*mnp[1]*mnp[2]));
    /* slaves are done: sent mnp and p1 */
    return (detector);
  } /* end slaves */

  /* MPI master: receive data from slaves sequentially: 2 MPI_Recv calls */

  if (mpi_node_rank == mpi_node_root) {
    for(node_i=0; node_i<mpi_node_count; node_i++) {
      double *this_p1=NULL;                               /* buffer to hold the list from slaves */
      int     mnp[3]={0,0,0};  /* size of this buffer */
      if (node_i != mpi_node_root) { /* get data from slaves */
	if (mc_MPI_Recv(mnp, 3, MPI_INT, node_i) != MPI_SUCCESS)
	  fprintf(stderr, "Warning: master from proc %i: "
		  "MPI_Recv mnp list error (mcdetector_write_data)\n", node_i);
	if (mnp[0]*mnp[1]*mnp[2]) {
	  this_p1 = (double *)calloc(mnp[0]*mnp[1]*mnp[2], sizeof(double));
	  if (!this_p1 || mc_MPI_Recv(this_p1, abs(mnp[0]*mnp[1]*mnp[2]), MPI_DOUBLE, node_i)!= MPI_SUCCESS)
	    fprintf(stderr, "Warning: master from proc %i: "
		    "MPI_Recv p1 list error: mnp=%i (mcdetector_write_data)\n", node_i, mnp[0]*mnp[1]*mnp[2]);
	  else {
	    printf(". MPI master writing data for slave node %i\n",node_i);
	    detector.p1 = this_p1;
	    detector.m  = mnp[0]; detector.n  = mnp[1]; detector.p  = mnp[2];
	    
	    mcdetector_out_data_nexus(nxhandle, detector);
	  }
	}
      } /* if not master */
    } /* for */
  MPI_MASTER(
	     printf("\n** Done ** \n");
  );   
  }
}
#endif

MCDETECTOR mcdetector_out_0D_nexus(MCDETECTOR detector)
{
  /* Write data set information to NeXus file. */
  MPI_MASTER(
    mcdatainfo_out_nexus(nxhandle, detector);
  );
  
  return(detector);
} /* mcdetector_out_0D_ascii */

MCDETECTOR mcdetector_out_1D_nexus(MCDETECTOR detector_inc)
{
  MCDETECTOR detector = detector_inc;
  MPI_MASTER(
  mcdatainfo_out_nexus(nxhandle, detector);
  mcdetector_out_data_nexus(nxhandle, detector);
  );
  return(detector);
} /* mcdetector_out_1D_ascii */

MCDETECTOR mcdetector_out_2D_nexus(MCDETECTOR detector_inc)
{
  MCDETECTOR detector = detector_inc;
  MPI_MASTER(
  mcdatainfo_out_nexus(nxhandle, detector);
  mcdetector_out_data_nexus(nxhandle, detector);
  );
  
#ifdef USE_MPI // and USE_NEXUS
  /* NeXus: slave nodes have master write their lists */
  if (strcasestr(detector.format, "list") && mpi_node_count > 1) {
    mcdetector_out_list_slaves(detector);
  }
#endif /* USE_MPI */

  return(detector);
} /* mcdetector_out_2D_nexus */

#endif /* USE_NEXUS*/








/* ========================================================================== */

/*                            Main input functions                            */
/*            DETECTOR_OUT_xD function calls -> ascii or NeXus                */

/* ========================================================================== */

/*******************************************************************************
* mcsiminfo_init:   open SIM and write header
*******************************************************************************/
FILE *mcsiminfo_init(FILE *f)
{
  int exists=0;
  int index;
  
  /* check format */      
  if (!mcformat || !strlen(mcformat) 
   || !strcasecmp(mcformat, "MCSTAS") || !strcasecmp(mcformat, "MCXTRACE") 
   || !strcasecmp(mcformat, "PGPLOT") || !strcasecmp(mcformat, "GNUPLOT") || !strcasecmp(mcformat, "MCCODE")
   || !strcasecmp(mcformat, "MATLAB")) {
    mcformat="McCode";
#ifdef USE_NEXUS
  } else if (strcasestr(mcformat, "NeXus")) {
    /* Do nothing */
#endif
  } else {
    fprintf(stderr,
	    "Warning: You have requested the output format %s which is unsupported by this binary. Resetting to standard %s format.\n",mcformat ,"McCode");
    mcformat="McCode";
  }
  
  /* open the SIM file if not defined yet */
  if (mcsiminfo_file || mcdisable_output_files) 
    return (mcsiminfo_file);
    
#ifdef USE_NEXUS
  /* only master writes NeXus header: calls NXopen(nxhandle) */
  if (mcformat && strcasestr(mcformat, "NeXus")) {
	  MPI_MASTER(
	  mcsiminfo_file = mcnew_file(mcsiminfo_name, "h5", &exists);
    if(!mcsiminfo_file)
      fprintf(stderr,
	      "Warning: could not open simulation description file '%s'\n",
	      mcsiminfo_name);
	  else
	    mcinfo_out_nexus(nxhandle);
	  );
    return(mcsiminfo_file); /* points to nxhandle */
  }
#endif
  
  /* write main description file (only MASTER) */
  MPI_MASTER(

  mcsiminfo_file = mcnew_file(mcsiminfo_name, "sim", &exists);
  if(!mcsiminfo_file)
    fprintf(stderr,
	    "Warning: could not open simulation description file '%s'\n",
	    mcsiminfo_name);
  else
  {
    /* write SIM header */
    time_t t=time(NULL);
    mcsiminfo_out("%s simulation description file for %s.\n", 
      MCCODE_NAME, mcinstrument_name);
    mcsiminfo_out("Date:    %s", ctime(&t)); /* includes \n */
    mcsiminfo_out("Program: %s\n\n", MCCODE_STRING);
    
    mcsiminfo_out("begin instrument: %s\n", mcinstrument_name);
    mcinfo_out(   "  ", mcsiminfo_file);
    mcsiminfo_out("end instrument\n");

    mcsiminfo_out("\nbegin simulation: %s\n", mcdirname);
    mcruninfo_out("  ", mcsiminfo_file);
    mcsiminfo_out("end simulation\n");

  }
  return (mcsiminfo_file);
  
  ); /* MPI_MASTER */
  
} /* mcsiminfo_init */

/*******************************************************************************
*   mcsiminfo_close:  close SIM
*******************************************************************************/
void mcsiminfo_close()
{
  MPI_MASTER(
  if(mcsiminfo_file && !mcdisable_output_files) {
#ifdef USE_NEXUS
    if (mcformat && strcasestr(mcformat, "NeXus")) {
      time_t t=time(NULL);
      nxprintf(nxhandle, "end_time", ctime(&t));
      nxprintf(nxhandle, "duration", "%li", (long)t-mcstartdate);
      NXclosegroup(nxhandle); /* NXentry */
      NXclose(&nxhandle);
    } else
#endif
      fclose(mcsiminfo_file);
    );
    mcsiminfo_file = NULL;
  }
} /* mcsiminfo_close */

/*******************************************************************************
* mcdetector_out_0D: wrapper for 0D (single value).
*   Output single detector/monitor data (p0, p1, p2).
*   Title is t, component name is c.
*******************************************************************************/
MCDETECTOR mcdetector_out_0D(char *t, double p0, double p1, double p2,
                         char *c, Coords posa)
{
  /* import and perform basic detector analysis (and handle MPI reduce) */
  MCDETECTOR detector = mcdetector_import(mcformat,
    c, (t ? t : MCCODE_STRING " data"),
    1, 1, 1,
    "I", "", "",
    "I", "", "",
    0, 0, 0, 0, 0, 0, "",
    &p0, &p1, &p2, posa); /* write Detector: line */

#ifdef USE_NEXUS
  if (strcasestr(detector.format, "NeXus"))
    return(mcdetector_out_0D_nexus(detector));
  else
#endif
    return(mcdetector_out_0D_ascii(detector));
    
} /* mcdetector_out_0D */



/*******************************************************************************
* mcdetector_out_1D: wrapper for 1D.
*   Output 1d detector data (p0, p1, p2) for n bins linearly
*   distributed across the range x1..x2 (x1 is lower limit of first
*   bin, x2 is upper limit of last bin). Title is t, axis labels are xl
*   and yl. File name is f, component name is c.
*******************************************************************************/
MCDETECTOR mcdetector_out_1D(char *t, char *xl, char *yl,
        char *xvar, double x1, double x2,
        long n,
        double *p0, double *p1, double *p2, char *f,
        char *c, Coords posa)
{
  /* import and perform basic detector analysis (and handle MPI_Reduce) */
  MCDETECTOR detector = mcdetector_import(mcformat,
    c, (t ? t : MCCODE_STRING " 1D data"),
    n, 1, 1,
    xl, yl, (n > 1 ? "Signal per bin" : " Signal"),
    xvar, "(I,I_err)", "I",
    x1, x2, 0, 0, 0, 0, f,
    p0, p1, p2, posa); /* write Detector: line */
  if (!detector.p1 || !detector.m) return(detector);

#ifdef USE_NEXUS
  if (strcasestr(detector.format, "NeXus"))
    return(mcdetector_out_1D_nexus(detector));
  else
#endif
    return(mcdetector_out_1D_ascii(detector));
  
} /* mcdetector_out_1D */

/*******************************************************************************
* mcdetector_out_2D: wrapper for 2D.
*   special case for list: master creates file first, then slaves append their blocks without header
*******************************************************************************/
MCDETECTOR mcdetector_out_2D(char *t, char *xl, char *yl,
                  double x1, double x2, double y1, double y2,
                  long m, long n,
                  double *p0, double *p1, double *p2, char *f,
                  char *c, Coords posa)
{
  char xvar[CHAR_BUF_LENGTH];
  char yvar[CHAR_BUF_LENGTH];
  
  /* create short axes labels */
  if (xl && strlen(xl)) { strncpy(xvar, xl, CHAR_BUF_LENGTH); xvar[strcspn(xvar,"\n\r ")]='\0'; }
  else strcpy(xvar, "x");
  if (yl && strlen(yl)) { strncpy(yvar, yl, CHAR_BUF_LENGTH); yvar[strcspn(yvar,"\n\r ")]='\0'; }
  else strcpy(yvar, "y");

  MCDETECTOR detector;

  /* import and perform basic detector analysis (and handle MPI_Reduce) */
  if (labs(m) == 1) {/* n>1 on Y, m==1 on X: 1D, no X axis*/
    detector = mcdetector_import(mcformat,
      c, (t ? t : MCCODE_STRING " 1D data"),
      n, 1, 1,
      yl, "", "Signal per bin",
      yvar, "(I,Ierr)", "I",
      y1, y2, x1, x2, 0, 0, f,
      p0, p1, p2, posa); /* write Detector: line */
  } else if (labs(n)==1) {/* m>1 on X, n==1 on Y: 1D, no Y axis*/
    detector = mcdetector_import(mcformat,
      c, (t ? t : MCCODE_STRING " 1D data"),
      m, 1, 1,
      xl, "", "Signal per bin",
      xvar, "(I,Ierr)", "I",
      x1, x2, y1, y2, 0, 0, f,
      p0, p1, p2, posa); /* write Detector: line */
  }else {
    detector = mcdetector_import(mcformat,
      c, (t ? t : MCCODE_STRING " 2D data"),
      m, n, 1,
      xl, yl, "Signal per bin",
      xvar, yvar, "I",
      x1, x2, y1, y2, 0, 0, f,
      p0, p1, p2, posa); /* write Detector: line */
  }

  if (!detector.p1 || !detector.m) return(detector);

#ifdef USE_NEXUS
  if (strcasestr(detector.format, "NeXus"))
    return(mcdetector_out_2D_nexus(detector));
  else
#endif
    return(mcdetector_out_2D_ascii(detector));
  
} /* mcdetector_out_2D */

/*******************************************************************************
* mcdetector_out_list: wrapper for list output (calls out_2D with mcformat+"list").
*   m=number of events, n=size of each event
*******************************************************************************/
MCDETECTOR mcdetector_out_list(char *t, char *xl, char *yl,
                  long m, long n,
                  double *p1, char *f,
                  char *c, Coords posa)
{
  char       format_new[CHAR_BUF_LENGTH];
  char      *format_org;
  MCDETECTOR detector;
  
  format_org = mcformat;
  strcpy(format_new, mcformat);
  strcat(format_new, " list");
  mcformat = format_new;

  detector = mcdetector_out_2D(t, xl, yl,
                  1,labs(m),1,labs(n),
                  m,n,
                  NULL, p1, NULL, f,
                  c, posa);
  
  mcformat = format_org;
  return(detector);
}

/*******************************************************************************
 * mcuse_dir: set data/sim storage directory and create it,
 * or exit with error if exists
 ******************************************************************************/
static void
mcuse_dir(char *dir)
{
  if (!dir || !strlen(dir)) return;
#ifdef MC_PORTABLE
  fprintf(stderr, "Error: "
          "Directory output cannot be used with portable simulation (mcuse_dir)\n");
  exit(1);
#else  /* !MC_PORTABLE */
  /* handle file://directory URL type */
  if (strncmp(dir, "file://", strlen("file://")))
    mcdirname = dir;
  else
    mcdirname = dir+strlen("file://");
  
  
  
  MPI_MASTER(
    if(mkdir(mcdirname, 0777)) {
#ifndef DANSE
      fprintf(stderr, "Error: unable to create directory '%s' (mcuse_dir)\n", dir);
      fprintf(stderr, "(Maybe the directory already exists?)\n");
#endif
#ifdef USE_MPI
    MPI_Abort(MPI_COMM_WORLD, -1);
#endif
    exit(-1);
    }
  ); /* MPI_MASTER */
  
  /* remove trailing PATHSEP (if any) */
  while (strlen(mcdirname) && mcdirname[strlen(mcdirname) - 1] == MC_PATHSEP_C)
    mcdirname[strlen(mcdirname) - 1]='\0';
#endif /* !MC_PORTABLE */
} /* mcuse_dir */

/*******************************************************************************
* mcinfo: display instrument simulation info to stdout and exit
*******************************************************************************/
static void
mcinfo(void)
{
  fprintf(stdout, "begin instrument: %s\n", mcinstrument_name);
  mcinfo_out("  ", stdout);
  fprintf(stdout, "end instrument\n");
  fprintf(stdout, "begin simulation: %s\n", mcdirname ? mcdirname : ".");
  mcruninfo_out_backend("  ", stdout,1);
  fprintf(stdout, "end simulation\n");
  exit(0); /* includes MPI_Finalize in MPI mode */
} /* mcinfo */

#endif /* ndef MCCODE_R_IO_C */

/* end of the I/O section =================================================== */







/*******************************************************************************
* mcset_ncount: set total number of rays to generate
*******************************************************************************/
void mcset_ncount(unsigned long long int count)
{
  mcncount = count;
}

/* mcget_ncount: get total number of rays to generate */
unsigned long long int mcget_ncount(void)
{
  return mcncount;
}

/* mcget_run_num: get curent number of rays in TRACE */
unsigned long long int mcget_run_num(void)
{
  return mcrun_num;
}

/* mcsetn_arg: get ncount from a string argument */
static void
mcsetn_arg(char *arg)
{
  mcset_ncount((long long int) strtod(arg, NULL));
}

/* mcsetseed: set the random generator seed from a string argument */
static void
mcsetseed(char *arg)
{
  mcseed = atol(arg);
  if(mcseed) {
    srandom(mcseed);
  } else {
    fprintf(stderr, "Error: seed must not be zero (mcsetseed)\n");
    exit(1);
  }
}

/* Following part is only embedded when not redundent with mccode-r.h ========= */

#ifndef MCCODE_H

/* SECTION: MCDISPLAY support. =============================================== */

/*******************************************************************************
* Just output MCDISPLAY keywords to be caught by an external plotter client.
*******************************************************************************/

void mcdis_magnify(char *what){
  // Do nothing here, better use interactive zoom from the tools
}

void mcdis_line(double x1, double y1, double z1,
                double x2, double y2, double z2){
  printf("MCDISPLAY: multiline(2,%g,%g,%g,%g,%g,%g)\n",
         x1,y1,z1,x2,y2,z2);
}

void mcdis_dashed_line(double x1, double y1, double z1,
		       double x2, double y2, double z2, int n){
  int i;
  const double dx = (x2-x1)/(2*n+1);
  const double dy = (y2-y1)/(2*n+1);
  const double dz = (z2-z1)/(2*n+1);

  for(i = 0; i < n+1; i++)
    mcdis_line(x1 + 2*i*dx,     y1 + 2*i*dy,     z1 + 2*i*dz,
	       x1 + (2*i+1)*dx, y1 + (2*i+1)*dy, z1 + (2*i+1)*dz);
}

void mcdis_multiline(int count, ...){
  va_list ap;
  double x,y,z;

  printf("MCDISPLAY: multiline(%d", count);
  va_start(ap, count);
  while(count--)
    {
    x = va_arg(ap, double);
    y = va_arg(ap, double);
    z = va_arg(ap, double);
    printf(",%g,%g,%g", x, y, z);
    }
  va_end(ap);
  printf(")\n");
}

void mcdis_rectangle(char* plane, double x, double y, double z,
		     double width, double height){
  /* draws a rectangle in the plane           */
  /* x is ALWAYS width and y is ALWAYS height */
  if (strcmp("xy", plane)==0) {
    mcdis_multiline(5,
		    x - width/2, y - height/2, z,
		    x + width/2, y - height/2, z,
		    x + width/2, y + height/2, z,
		    x - width/2, y + height/2, z,
		    x - width/2, y - height/2, z);
  } else if (strcmp("xz", plane)==0) {
    mcdis_multiline(5,
		    x - width/2, y, z - height/2,
		    x + width/2, y, z - height/2,
		    x + width/2, y, z + height/2,
		    x - width/2, y, z + height/2,
		    x - width/2, y, z - height/2);
  } else if (strcmp("yz", plane)==0) {
    mcdis_multiline(5,
		    x, y - height/2, z - width/2,
		    x, y - height/2, z + width/2,
		    x, y + height/2, z + width/2,
		    x, y + height/2, z - width/2,
		    x, y - height/2, z - width/2);
  } else {

    fprintf(stderr, "Error: Definition of plane %s unknown\n", plane);
    exit(1);
  }
}

/*  draws a box with center at (x, y, z) and
    width (deltax), height (deltay), length (deltaz) */
void mcdis_box(double x, double y, double z,
	       double width, double height, double length){

  mcdis_rectangle("xy", x, y, z-length/2, width, height);
  mcdis_rectangle("xy", x, y, z+length/2, width, height);
  mcdis_line(x-width/2, y-height/2, z-length/2,
	     x-width/2, y-height/2, z+length/2);
  mcdis_line(x-width/2, y+height/2, z-length/2,
	     x-width/2, y+height/2, z+length/2);
  mcdis_line(x+width/2, y-height/2, z-length/2,
	     x+width/2, y-height/2, z+length/2);
  mcdis_line(x+width/2, y+height/2, z-length/2,
	     x+width/2, y+height/2, z+length/2);
}

void mcdis_circle(char *plane, double x, double y, double z, double r){
  printf("MCDISPLAY: circle('%s',%g,%g,%g,%g)\n", plane, x, y, z, r);
}

/* Draws a circle with center (x,y,z), radius (r), and in the plane
 * with normal (nx,ny,nz)*/
void mcdis_Circle(double x, double y, double z, double r, double nx, double ny, double nz){
    int i;
    if(nx==0 && ny && nz==0){
        for (i=0;i<24; i++){
            mcdis_line(x+r*sin(i*2*M_PI/24),y,z+r*cos(i*2*M_PI/24),
                    x+r*sin((i+1)*2*M_PI/24),y,z+r*cos((i+1)*2*M_PI/24));
        }
    }else{
        double mx,my,mz;
        /*generate perpendicular vector using (nx,ny,nz) and (0,1,0)*/
        vec_prod(mx,my,mz, 0,1,0, nx,ny,nz);
        NORM(mx,my,mz);
        /*draw circle*/
        for (i=0;i<24; i++){
            double ux,uy,uz;
            double wx,wy,wz;
            rotate(ux,uy,uz, mx,my,mz, i*2*M_PI/24, nx,ny,nz);
            rotate(wx,wy,wz, mx,my,mz, (i+1)*2*M_PI/24, nx,ny,nz);
            mcdis_line(x+ux*r,y+uy*r,z+uz*r,
                    x+wx*r,y+wy*r,z+wz*r);
        }
    }
}

/* Draws a cylinder with center at (x,y,z) with extent (r,height).
 * The cylinder axis is along the vector nx,ny,nz.
 * N determines how many vertical lines are drawn.*/
void mcdis_cylinder( double x, double y, double z,
        double r, double height, int N, double nx, double ny, double nz){
    int i;
    /*no lines make little sense - so trigger the default*/
    if(N<=0) N=5;

    NORM(nx,ny,nz);
    double h_2=height/2.0;
    mcdis_Circle(x+nx*h_2,y+ny*h_2,z+nz*h_2,r,nx,ny,nz);
    mcdis_Circle(x-nx*h_2,y-ny*h_2,z-nz*h_2,r,nx,ny,nz);

    double mx,my,mz;
    /*generate perpendicular vector using (nx,ny,nz) and (0,1,0)*/
    if(nx==0 && ny && nz==0){
        mx=my=0;mz=1;
    }else{
        vec_prod(mx,my,mz, 0,1,0, nx,ny,nz);
        NORM(mx,my,mz);
    }
    /*draw circle*/
    for (i=0; i<24; i++){
        double ux,uy,uz;
        rotate(ux,uy,uz, mx,my,mz, i*2*M_PI/24, nx,ny,nz);
        mcdis_line(x+nx*h_2+ux*r, y+ny*h_2+uy*r, z+nz*h_2+uz*r,
                 x-nx*h_2+ux*r, y-ny*h_2+uy*r, z-nz*h_2+uz*r);
    }
}

/* draws a sphere with center at (x,y,z) with extent (r)
 * The sphere is drawn using N longitudes and N latitudes.*/
void mcdis_sphere(double x, double y, double z, double r, int N){
    double nx,ny,nz;
    int i;
    /*no lines make little sense - so trigger the default*/
    if(N<=0) N=5;

    nx=0;ny=0;nz=1;
    mcdis_Circle(x,y,z,r,nx,ny,nz);
    for (i=1;i<N;i++){
        rotate(nx,ny,nz, nx,ny,nz, M_PI/N, 0,1,0);
        mcdis_Circle(x,y,z,r,nx,ny,nz);
    }
    /*lastly draw a great circle perpendicular to all N circles*/
    //mcdis_Circle(x,y,z,radius,1,0,0);

    for (i=1;i<=N;i++){
        double yy=-r+ 2*r*((double)i/(N+1));
        mcdis_Circle(x,y+yy ,z,  sqrt(r*r-yy*yy) ,0,1,0);
    }
}

/* SECTION: coordinates handling ============================================ */

/*******************************************************************************
* Since we use a lot of geometric calculations using Cartesian coordinates,
* we collect some useful routines here. However, it is also permissible to
* work directly on the underlying struct coords whenever that is most
* convenient (that is, the type Coords is not abstract).
*
* Coordinates are also used to store rotation angles around x/y/z axis.
*
* Since coordinates are used much like a basic type (such as double), the
* structure itself is passed and returned, rather than a pointer.
*
* At compile-time, the values of the coordinates may be unknown (for example
* a motor position). Hence coordinates are general expressions and not simple
* numbers. For this we used the type Coords_exp which has three CExp
* fields. For runtime (or calculations possible at compile time), we use
* Coords which contains three double fields.
*******************************************************************************/

/* coords_set: Assign coordinates. */
Coords
coords_set(MCNUM x, MCNUM y, MCNUM z)
{
  Coords a;

  a.x = x;
  a.y = y;
  a.z = z;
  return a;
}

/* coords_get: get coordinates. Required when 'x','y','z' are #defined as ray pars */
Coords
coords_get(Coords a, MCNUM *x, MCNUM *y, MCNUM *z)
{
  *x = a.x;
  *y = a.y;
  *z = a.z;
  return a;
}

/* coords_add: Add two coordinates. */
Coords
coords_add(Coords a, Coords b)
{
  Coords c;

  c.x = a.x + b.x;
  c.y = a.y + b.y;
  c.z = a.z + b.z;
  if (fabs(c.z) < 1e-14) c.z=0.0;
  return c;
}

/* coords_sub: Subtract two coordinates. */
Coords
coords_sub(Coords a, Coords b)
{
  Coords c;

  c.x = a.x - b.x;
  c.y = a.y - b.y;
  c.z = a.z - b.z;
  if (fabs(c.z) < 1e-14) c.z=0.0;
  return c;
}

/* coords_neg: Negate coordinates. */
Coords
coords_neg(Coords a)
{
  Coords b;

  b.x = -a.x;
  b.y = -a.y;
  b.z = -a.z;
  return b;
}

/* coords_scale: Scale a vector. */
Coords coords_scale(Coords b, double scale) {
  Coords a;

  a.x = b.x*scale;
  a.y = b.y*scale;
  a.z = b.z*scale;
  return a;
}

/* coords_sp: Scalar product: a . b */
double coords_sp(Coords a, Coords b) {
  double value;

  value = a.x*b.x + a.y*b.y + a.z*b.z;
  return value;
}

/* coords_xp: Cross product: a = b x c. */
Coords coords_xp(Coords b, Coords c) {
  Coords a;

  a.x = b.y*c.z - c.y*b.z;
  a.y = b.z*c.x - c.z*b.x;
  a.z = b.x*c.y - c.x*b.y;
  return a;
}

/* coords_len: Gives length of coords set. */
double coords_len(Coords a) {
  return sqrt(a.x*a.x + a.y*a.y + a.z*a.z);
}

/* coords_mirror: Mirror a in plane (through the origin) defined by normal n*/
Coords coords_mirror(Coords a, Coords n) {
  double t = scalar_prod(n.x, n.y, n.z, n.x, n.y, n.z);
  Coords b;
  if (t!=1) {
    t = sqrt(t);
    n.x /= t;
    n.y /= t;
    n.z /= t;
  }
  t=scalar_prod(a.x, a.y, a.z, n.x, n.y, n.z);
  b.x = a.x-2*t*n.x;
  b.y = a.y-2*t*n.y;
  b.z = a.z-2*t*n.z;
  return b;
}

/* coords_print: Print out vector values. */
void coords_print(Coords a) {

  fprintf(stdout, "(%f, %f, %f)\n", a.x, a.y, a.z);
  return;
}

mcstatic void coords_norm(Coords* c) {
	double temp = coords_sp(*c,*c);

	// Skip if we will end dividing by zero
	if (temp == 0) return;

	temp = sqrt(temp);

	c->x /= temp;
	c->y /= temp;
	c->z /= temp;
}

/*******************************************************************************
* The Rotation type implements a rotation transformation of a coordinate
* system in the form of a double[3][3] matrix.
*
* Contrary to the Coords type in coords.c, rotations are passed by
* reference. Functions that yield new rotations do so by writing to an
* explicit result parameter; rotations are not returned from functions. The
* reason for this is that arrays cannot by returned from functions (though
* structures can; thus an alternative would have been to wrap the
* double[3][3] array up in a struct). Such are the ways of C programming.
*
* A rotation represents the tranformation of the coordinates of a vector when
* changing between coordinate systems that are rotated with respect to each
* other. For example, suppose that coordinate system Q is rotated 45 degrees
* around the Z axis with respect to coordinate system P. Let T be the
* rotation transformation representing a 45 degree rotation around Z. Then to
* get the coordinates of a vector r in system Q, apply T to the coordinates
* of r in P. If r=(1,0,0) in P, it will be (sqrt(1/2),-sqrt(1/2),0) in
* Q. Thus we should be careful when interpreting the sign of rotation angles:
* they represent the rotation of the coordinate systems, not of the
* coordinates (which has opposite sign).
*******************************************************************************/

/*******************************************************************************
* rot_set_rotation: Get transformation for rotation first phx around x axis,
* then phy around y, then phz around z.
*******************************************************************************/
void
rot_set_rotation(Rotation t, double phx, double phy, double phz)
{
  if ((phx == 0) && (phy == 0) && (phz == 0)) {
    t[0][0] = 1.0;
    t[0][1] = 0.0;
    t[0][2] = 0.0;
    t[1][0] = 0.0;
    t[1][1] = 1.0;
    t[1][2] = 0.0;
    t[2][0] = 0.0;
    t[2][1] = 0.0;
    t[2][2] = 1.0;
  } else {
    double cx = cos(phx);
    double sx = sin(phx);
    double cy = cos(phy);
    double sy = sin(phy);
    double cz = cos(phz);
    double sz = sin(phz);

    t[0][0] = cy*cz;
    t[0][1] = sx*sy*cz + cx*sz;
    t[0][2] = sx*sz - cx*sy*cz;
    t[1][0] = -cy*sz;
    t[1][1] = cx*cz - sx*sy*sz;
    t[1][2] = sx*cz + cx*sy*sz;
    t[2][0] = sy;
    t[2][1] = -sx*cy;
    t[2][2] = cx*cy;
  }
}

/*******************************************************************************
* rot_test_identity: Test if rotation is identity
*******************************************************************************/
int
rot_test_identity(Rotation t)
{
  return (t[0][0] + t[1][1] + t[2][2] == 3);
}

/*******************************************************************************
* rot_mul: Matrix multiplication of transformations (this corresponds to
* combining transformations). After rot_mul(T1, T2, T3), doing T3 is
* equal to doing first T2, then T1.
* Note that T3 must not alias (use the same array as) T1 or T2.
*******************************************************************************/
void
rot_mul(Rotation t1, Rotation t2, Rotation t3)
{
  if (rot_test_identity(t1)) {
    rot_copy(t3, t2);
  } else if (rot_test_identity(t2)) {
    rot_copy(t3, t1);
  } else {
    int i,j;
    for(i = 0; i < 3; i++)
      for(j = 0; j < 3; j++)
	t3[i][j] = t1[i][0]*t2[0][j] + t1[i][1]*t2[1][j] + t1[i][2]*t2[2][j];
  }
}

/*******************************************************************************
* rot_copy: Copy a rotation transformation (arrays cannot be assigned in C).
*******************************************************************************/
void
rot_copy(Rotation dest, Rotation src)
{
  int i,j;
  for(i = 0; i < 3; i++)
    for(j = 0; j < 3; j++)
      dest[i][j] = src[i][j];
}

/*******************************************************************************
* rot_transpose: Matrix transposition, which is inversion for Rotation matrices
*******************************************************************************/
void
rot_transpose(Rotation src, Rotation dst)
{
  dst[0][0] = src[0][0];
  dst[0][1] = src[1][0];
  dst[0][2] = src[2][0];
  dst[1][0] = src[0][1];
  dst[1][1] = src[1][1];
  dst[1][2] = src[2][1];
  dst[2][0] = src[0][2];
  dst[2][1] = src[1][2];
  dst[2][2] = src[2][2];
}

/*******************************************************************************
* rot_apply: returns t*a
*******************************************************************************/
Coords
rot_apply(Rotation t, Coords a)
{
  Coords b;
  if (rot_test_identity(t)) {
    return a;
  } else {
    b.x = t[0][0]*a.x + t[0][1]*a.y + t[0][2]*a.z;
    b.y = t[1][0]*a.x + t[1][1]*a.y + t[1][2]*a.z;
    b.z = t[2][0]*a.x + t[2][1]*a.y + t[2][2]*a.z;
    return b;
  }
}

/**
 * Pretty-printing of rotation matrices.
 */
void rot_print(Rotation rot) {
	printf("[ %4.2f %4.2f %4.2f ]\n",
			rot[0][0], rot[0][1], rot[0][2]);
	printf("[ %4.2f %4.2f %4.2f ]\n",
			rot[1][0], rot[1][1], rot[1][2]);
	printf("[ %4.2f %4.2f %4.2f ]\n\n",
			rot[2][0], rot[2][1], rot[2][2]);
}

/**
 * Vector product: used by vec_prod (mccode-r.h). Use coords_xp for Coords.
 */
mcstatic void vec_prod_func(double *x, double *y, double *z,
		double x1, double y1, double z1,
		double x2, double y2, double z2) {
    *x = (y1)*(z2) - (y2)*(z1);
    *y = (z1)*(x2) - (z2)*(x1);
    *z = (x1)*(y2) - (x2)*(y1);
}

/**
 * Scalar product: use coords_sp for Coords.
 */
mcstatic double scalar_prod(
		double x1, double y1, double z1,
		double x2, double y2, double z2) {
	return ((x1 * x2) + (y1 * y2) + (z1 * z2));
}

/*******************************************************************************
* mccoordschange: applies rotation to (x y z) and (vx vy vz) and Spin (sx,sy,sz)
*******************************************************************************/
void
mccoordschange(Coords a, Rotation t, double *x, double *y, double *z,
               double *vx, double *vy, double *vz, double *sx, double *sy, double *sz)
{
  Coords b, c;

  b.x = *x;
  b.y = *y;
  b.z = *z;
  c = rot_apply(t, b);
  b = coords_add(c, a);
  *x = b.x;
  *y = b.y;
  *z = b.z;

  if ( (vz && vy  && vx) && (*vz != 0.0 || *vx != 0.0 || *vy != 0.0) ) mccoordschange_polarisation(t, vx, vy, vz);

  if ( (sz && sy  && sx) && (*sz != 0.0 || *sx != 0.0 || *sy != 0.0) ) mccoordschange_polarisation(t, sx, sy, sz);

}

/*******************************************************************************
* mccoordschange_polarisation: applies rotation to vector (sx sy sz)
*******************************************************************************/
void
mccoordschange_polarisation(Rotation t, double *sx, double *sy, double *sz)
{
  Coords b, c;

  b.x = *sx;
  b.y = *sy;
  b.z = *sz;
  c = rot_apply(t, b);
  *sx = c.x;
  *sy = c.y;
  *sz = c.z;
}

/* SECTION: vector math  ==================================================== */

/* normal_vec_func: Compute normal vector to (x,y,z). */
mcstatic void normal_vec_func(double *nx, double *ny, double *nz,
                double x, double y, double z)
{
  double ax = fabs(x);
  double ay = fabs(y);
  double az = fabs(z);
  double l;
  if(x == 0 && y == 0 && z == 0)
  {
    *nx = 0;
    *ny = 0;
    *nz = 0;
    return;
  }
  if(ax < ay)
  {
    if(ax < az)
    {                           /* Use X axis */
      l = sqrt(z*z + y*y);
      *nx = 0;
      *ny = z/l;
      *nz = -y/l;
      return;
    }
  }
  else
  {
    if(ay < az)
    {                           /* Use Y axis */
      l = sqrt(z*z + x*x);
      *nx = z/l;
      *ny = 0;
      *nz = -x/l;
      return;
    }
  }
  /* Use Z axis */
  l = sqrt(y*y + x*x);
  *nx = y/l;
  *ny = -x/l;
  *nz = 0;
} /* normal_vec */

/*******************************************************************************
 * solve_2nd_order: second order equation solve: A*t^2 + B*t + C = 0
 * solve_2nd_order(&t1, NULL, A,B,C)
 *   returns 0 if no solution was found, or set 't1' to the smallest positive
 *   solution.
 * solve_2nd_order(&t1, &t2, A,B,C)
 *   same as with &t2=NULL, but also returns the second solution.
 * EXAMPLE usage for intersection of a trajectory with a plane in gravitation
 * field (gx,gy,gz):
 * The neutron starts at point r=(x,y,z) with velocityv=(vx vy vz). The plane
 * has a normal vector n=(nx,ny,nz) and contains the point W=(wx,wy,wz).
 * The problem consists in solving the 2nd order equation:
 *      1/2.n.g.t^2 + n.v.t + n.(r-W) = 0
 * so that A = 0.5 n.g; B = n.v; C = n.(r-W);
 * Without acceleration, t=-n.(r-W)/n.v
 ******************************************************************************/
int solve_2nd_order(double *t1, double *t2,
                  double A,  double B,  double C)
{
  int ret=0;

  if (!t1) return 0;
  *t1 = 0;
  if (t2) *t2=0;

  if (fabs(A) < 1E-10) /* approximate to linear equation: A ~ 0 */
  {
    if (B) {  *t1 = -C/B; ret=1; if (t2) *t2=*t1; }
    /* else no intersection: A=B=0 ret=0 */
  }
  else
  {
    double D;
    D = B*B - 4*A*C;
    if (D >= 0) /* Delta > 0: two solutions */
    {
      double sD, dt1, dt2;
      sD = sqrt(D);
      dt1 = (-B + sD)/2/A;
      dt2 = (-B - sD)/2/A;
      /* we identify very small values with zero */
      if (fabs(dt1) < 1e-10) dt1=0.0;
      if (fabs(dt2) < 1e-10) dt2=0.0;

      /* now we choose the smallest positive solution */
      if      (dt1<=0.0 && dt2>0.0) ret=2; /* dt2 positive */
      else if (dt2<=0.0 && dt1>0.0) ret=1; /* dt1 positive */
      else if (dt1> 0.0 && dt2>0.0)
      {  if (dt1 < dt2) ret=1; else ret=2; } /* all positive: min(dt1,dt2) */
      /* else two solutions are negative. ret=-1 */
      if (ret==1) { *t1 = dt1;  if (t2) *t2=dt2; }
      else        { *t1 = dt2;  if (t2) *t2=dt1; }
      ret=2;  /* found 2 solutions and t1 is the positive one */
    } /* else Delta <0: no intersection. ret=0 */
  }
  return(ret);
} /* solve_2nd_order */

/*******************************************************************************
 * randvec_target_circle: Choose random direction towards target at (x,y,z)
 * with given radius.
 * If radius is zero, choose random direction in full 4PI, no target.
 ******************************************************************************/
void
randvec_target_circle(double *xo, double *yo, double *zo, double *solid_angle,
               double xi, double yi, double zi, double radius)
{
  double l2, phi, theta, nx, ny, nz, xt, yt, zt, xu, yu, zu;

  if(radius == 0.0)
  {
    /* No target, choose uniformly a direction in full 4PI solid angle. */
    theta = acos (1 - rand0max(2));
    phi = rand0max(2 * PI);
    if(solid_angle)
      *solid_angle = 4*PI;
    nx = 1;
    ny = 0;
    nz = 0;
    yi = sqrt(xi*xi+yi*yi+zi*zi);
    zi = 0;
    xi = 0;
  }
  else
  {
    double costheta0;
    l2 = xi*xi + yi*yi + zi*zi; /* sqr Distance to target. */
    costheta0 = sqrt(l2/(radius*radius+l2));
    if (radius < 0) costheta0 *= -1;
    if(solid_angle)
    {
      /* Compute solid angle of target as seen from origin. */
        *solid_angle = 2*PI*(1 - costheta0);
    }

    /* Now choose point uniformly on circle surface within angle theta0 */
    theta = acos (1 - rand0max(1 - costheta0)); /* radius on circle */
    phi = rand0max(2 * PI); /* rotation on circle at given radius */
    /* Now, to obtain the desired vector rotate (xi,yi,zi) angle theta around a
       perpendicular axis u=i x n and then angle phi around i. */
    if(xi == 0 && zi == 0)
    {
      nx = 1;
      ny = 0;
      nz = 0;
    }
    else
    {
      nx = -zi;
      nz = xi;
      ny = 0;
    }
  }

  /* [xyz]u = [xyz]i x n[xyz] (usually vertical) */
  vec_prod(xu,  yu,  zu, xi, yi, zi,        nx, ny, nz);
  /* [xyz]t = [xyz]i rotated theta around [xyz]u */
  rotate  (xt,  yt,  zt, xi, yi, zi, theta, xu, yu, zu);
  /* [xyz]o = [xyz]t rotated phi around n[xyz] */
  rotate (*xo, *yo, *zo, xt, yt, zt, phi, xi, yi, zi);
} /* randvec_target_circle */

/*******************************************************************************
 * randvec_target_rect_angular: Choose random direction towards target at
 * (xi,yi,zi) with given ANGULAR dimension height x width. height=phi_x=[0,PI],
 * width=phi_y=[0,2*PI] (radians)
 * If height or width is zero, choose random direction in full 4PI, no target.
 *******************************************************************************/
void
randvec_target_rect_angular(double *xo, double *yo, double *zo, double *solid_angle,
               double xi, double yi, double zi, double width, double height, Rotation A)
{
  double theta, phi, nx, ny, nz, xt, yt, zt, xu, yu, zu;
  Coords tmp;
  Rotation Ainverse;

  rot_transpose(A, Ainverse);

  if(height == 0.0 || width == 0.0)
  {
    randvec_target_circle(xo, yo, zo, solid_angle,
               xi, yi, zi, 0);
    return;
  }
  else
  {
    if(solid_angle)
    {
      /* Compute solid angle of target as seen from origin. */
      *solid_angle = 2*fabs(width*sin(height/2));
    }

    /* Go to global coordinate system */

    tmp = coords_set(xi, yi, zi);
    tmp = rot_apply(Ainverse, tmp);
    coords_get(tmp, &xi, &yi, &zi);

    /* Now choose point uniformly on the unit sphere segment with angle theta/phi */
    phi   = width*randpm1()/2.0;
    theta = asin(randpm1()*sin(height/2.0));
    /* Now, to obtain the desired vector rotate (xi,yi,zi) angle theta around
       n, and then phi around u. */
    if(xi == 0 && zi == 0)
    {
      nx = 1;
      ny = 0;
      nz = 0;
    }
    else
    {
      nx = -zi;
      nz = xi;
      ny = 0;
    }
  }

  /* [xyz]u = [xyz]i x n[xyz] (usually vertical) */
  vec_prod(xu,  yu,  zu, xi, yi, zi,        nx, ny, nz);
  /* [xyz]t = [xyz]i rotated theta around [xyz]u */
  rotate  (xt,  yt,  zt, xi, yi, zi, theta, nx, ny, nz);
  /* [xyz]o = [xyz]t rotated phi around n[xyz] */
  rotate (*xo, *yo, *zo, xt, yt, zt, phi, xu,  yu,  zu);

  /* Go back to local coordinate system */
  tmp = coords_set(*xo, *yo, *zo);
  tmp = rot_apply(A, tmp);
  coords_get(tmp, &*xo, &*yo, &*zo);

} /* randvec_target_rect_angular */

/*******************************************************************************
 * randvec_target_rect_real: Choose random direction towards target at (xi,yi,zi)
 * with given dimension height x width (in meters !).
 *
 * Local emission coordinate is taken into account and corrected for 'order' times.
 * (See remarks posted to mcstas-users by George Apostolopoulus <gapost@ipta.demokritos.gr>)
 *
 * If height or width is zero, choose random direction in full 4PI, no target.
 *
 * Traditionally, this routine had the name randvec_target_rect - this is now a
 * a define (see mcstas-r.h) pointing here. If you use the old rouine, you are NOT
 * taking the local emmission coordinate into account.
*******************************************************************************/

void
randvec_target_rect_real(double *xo, double *yo, double *zo, double *solid_angle,
               double xi, double yi, double zi,
               double width, double height, Rotation A,
               double lx, double ly, double lz, int order)
{
  double dx, dy, dist, dist_p, nx, ny, nz, mx, my, mz, n_norm, m_norm;
  double cos_theta;
  Coords tmp;
  Rotation Ainverse;

  rot_transpose(A, Ainverse);

  if(height == 0.0 || width == 0.0)
  {
    randvec_target_circle(xo, yo, zo, solid_angle,
               xi, yi, zi, 0);
    return;
  }
  else
  {

    /* Now choose point uniformly on rectangle within width x height */
    dx = width*randpm1()/2.0;
    dy = height*randpm1()/2.0;

    /* Determine distance to target plane*/
    dist = sqrt(xi*xi + yi*yi + zi*zi);
    /* Go to global coordinate system */

    tmp = coords_set(xi, yi, zi);
    tmp = rot_apply(Ainverse, tmp);
    coords_get(tmp, &xi, &yi, &zi);

    /* Determine vector normal to trajectory axis (z) and gravity [0 1 0] */
    vec_prod(nx, ny, nz, xi, yi, zi, 0, 1, 0);

    /* This now defines the x-axis, normalize: */
    n_norm=sqrt(nx*nx + ny*ny + nz*nz);
    nx = nx/n_norm;
    ny = ny/n_norm;
    nz = nz/n_norm;

    /* Now, determine our y-axis (vertical in many cases...) */
    vec_prod(mx, my, mz, xi, yi, zi, nx, ny, nz);
    m_norm=sqrt(mx*mx + my*my + mz*mz);
    mx = mx/m_norm;
    my = my/m_norm;
    mz = mz/m_norm;

    /* Our output, random vector can now be defined by linear combination: */

    *xo = xi + dx * nx + dy * mx;
    *yo = yi + dx * ny + dy * my;
    *zo = zi + dx * nz + dy * mz;

    /* Go back to local coordinate system */
    tmp = coords_set(*xo, *yo, *zo);
    tmp = rot_apply(A, tmp);
    coords_get(tmp, &*xo, &*yo, &*zo);

    /* Go back to local coordinate system */
    tmp = coords_set(xi, yi, zi);
    tmp = rot_apply(A, tmp);
    coords_get(tmp, &xi, &yi, &zi);

    if (solid_angle) {
      /* Calculate vector from local point to remote random point */
      lx = *xo - lx;
      ly = *yo - ly;
      lz = *zo - lz;
      dist_p = sqrt(lx*lx + ly*ly + lz*lz);

      /* Adjust the 'solid angle' */
      /* 1/r^2 to the chosen point times cos(\theta) between the normal */
      /* vector of the target rectangle and direction vector of the chosen point. */
      cos_theta = (xi * lx + yi * ly + zi * lz) / (dist * dist_p);
      *solid_angle = width * height / (dist_p * dist_p);
      int counter;
      for (counter = 0; counter < order; counter++) {
	*solid_angle = *solid_angle * cos_theta;
      }
    }
  }
} /* randvec_target_rect_real */

/* SECTION: random numbers ================================================== */

/*
 * Copyright (c) 1983 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

/*
 * This is derived from the Berkeley source:
 *        @(#)random.c        5.5 (Berkeley) 7/6/88
 * It was reworked for the GNU C Library by Roland McGrath.
 * Rewritten to use reentrant functions by Ulrich Drepper, 1995.
 */

/*******************************************************************************
* Modified for McStas from glibc 2.0.7pre1 stdlib/random.c and
* stdlib/random_r.c.
*
* This way random() is more than four times faster compared to calling
* standard glibc random() on ix86 Linux, probably due to multithread support,
* ELF shared library overhead, etc. It also makes McStas generated
* simulations more portable (more likely to behave identically across
* platforms, important for parrallel computations).
*******************************************************************************/


#define        TYPE_3                3
#define        BREAK_3                128
#define        DEG_3                31
#define        SEP_3                3

static mc_int32_t randtbl[DEG_3 + 1] =
  {
    TYPE_3,

    -1726662223, 379960547, 1735697613, 1040273694, 1313901226,
    1627687941, -179304937, -2073333483, 1780058412, -1989503057,
    -615974602, 344556628, 939512070, -1249116260, 1507946756,
    -812545463, 154635395, 1388815473, -1926676823, 525320961,
    -1009028674, 968117788, -123449607, 1284210865, 435012392,
    -2017506339, -911064859, -370259173, 1132637927, 1398500161,
    -205601318,
  };

static mc_int32_t *fptr = &randtbl[SEP_3 + 1];
static mc_int32_t *rptr = &randtbl[1];
static mc_int32_t *state = &randtbl[1];
#define rand_deg DEG_3
#define rand_sep SEP_3
static mc_int32_t *end_ptr = &randtbl[sizeof (randtbl) / sizeof (randtbl[0])];

mc_int32_t
mc_random (void)
{
  mc_int32_t result;

  *fptr += *rptr;
  /* Chucking least random bit.  */
  result = (*fptr >> 1) & 0x7fffffff;
  ++fptr;
  if (fptr >= end_ptr)
  {
    fptr = state;
    ++rptr;
  }
  else
  {
    ++rptr;
    if (rptr >= end_ptr)
      rptr = state;
  }
  return result;
}

void
mc_srandom (unsigned int x)
{
  /* We must make sure the seed is not 0.  Take arbitrarily 1 in this case.  */
  state[0] = x ? x : 1;
  {
    long int i;
    for (i = 1; i < rand_deg; ++i)
    {
      /* This does:
         state[i] = (16807 * state[i - 1]) % 2147483647;
         but avoids overflowing 31 bits.  */
      long int hi = state[i - 1] / 127773;
      long int lo = state[i - 1] % 127773;
      long int test = 16807 * lo - 2836 * hi;
      state[i] = test + (test < 0 ? 2147483647 : 0);
    }
    fptr = &state[rand_sep];
    rptr = &state[0];
    for (i = 0; i < 10 * rand_deg; ++i)
      random ();
  }
}

/* "Mersenne Twister", by Makoto Matsumoto and Takuji Nishimura. */
/* See http://www.math.keio.ac.jp/~matumoto/emt.html for original source. */


/*
   A C-program for MT19937, with initialization improved 2002/1/26.
   Coded by Takuji Nishimura and Makoto Matsumoto.

   Before using, initialize the state by using mt_srandom(seed)
   or init_by_array(init_key, key_length).

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


   Any feedback is very welcome.
   http://www.math.keio.ac.jp/matumoto/emt.html
   email: matumoto@math.keio.ac.jp
*/

#include <stdio.h>

/* Period parameters */
#define N 624
#define M 397
#define MATRIX_A 0x9908b0dfUL   /* constant vector a */
#define UPPER_MASK 0x80000000UL /* most significant w-r bits */
#define LOWER_MASK 0x7fffffffUL /* least significant r bits */

static unsigned long mt[N]; /* the array for the state vector  */
static int mti=N+1; /* mti==N+1 means mt[N] is not initialized */

/* initializes mt[N] with a seed */
void mt_srandom(unsigned long s)
{
    mt[0]= s & 0xffffffffUL;
    for (mti=1; mti<N; mti++) {
        mt[mti] =
            (1812433253UL * (mt[mti-1] ^ (mt[mti-1] >> 30)) + mti);
        /* See Knuth TAOCP Vol2. 3rd Ed. P.106 for multiplier. */
        /* In the previous versions, MSBs of the seed affect   */
        /* only MSBs of the array mt[].                        */
        /* 2002/01/09 modified by Makoto Matsumoto             */
        mt[mti] &= 0xffffffffUL;
        /* for >32 bit machines */
    }
}

/* initialize by an array with array-length */
/* init_key is the array for initializing keys */
/* key_length is its length */
void init_by_array(unsigned long init_key[], unsigned long key_length)
{
    int i, j, k;
    mt_srandom(19650218UL);
    i=1; j=0;
    k = (N>key_length ? N : key_length);
    for (; k; k--) {
        mt[i] = (mt[i] ^ ((mt[i-1] ^ (mt[i-1] >> 30)) * 1664525UL))
          + init_key[j] + j; /* non linear */
        mt[i] &= 0xffffffffUL; /* for WORDSIZE > 32 machines */
        i++; j++;
        if (i>=N) { mt[0] = mt[N-1]; i=1; }
        if (j>=key_length) j=0;
    }
    for (k=N-1; k; k--) {
        mt[i] = (mt[i] ^ ((mt[i-1] ^ (mt[i-1] >> 30)) * 1566083941UL))
          - i; /* non linear */
        mt[i] &= 0xffffffffUL; /* for WORDSIZE > 32 machines */
        i++;
        if (i>=N) { mt[0] = mt[N-1]; i=1; }
    }

    mt[0] = 0x80000000UL; /* MSB is 1; assuring non-zero initial array */
}

/* generates a random number on [0,0xffffffff]-interval */
unsigned long mt_random(void)
{
    unsigned long y;
    static unsigned long mag01[2]={0x0UL, MATRIX_A};
    /* mag01[x] = x * MATRIX_A  for x=0,1 */

    if (mti >= N) { /* generate N words at one time */
        int kk;

        if (mti == N+1)   /* if mt_srandom() has not been called, */
            mt_srandom(5489UL); /* a default initial seed is used */

        for (kk=0;kk<N-M;kk++) {
            y = (mt[kk]&UPPER_MASK)|(mt[kk+1]&LOWER_MASK);
            mt[kk] = mt[kk+M] ^ (y >> 1) ^ mag01[y & 0x1UL];
        }
        for (;kk<N-1;kk++) {
            y = (mt[kk]&UPPER_MASK)|(mt[kk+1]&LOWER_MASK);
            mt[kk] = mt[kk+(M-N)] ^ (y >> 1) ^ mag01[y & 0x1UL];
        }
        y = (mt[N-1]&UPPER_MASK)|(mt[0]&LOWER_MASK);
        mt[N-1] = mt[M-1] ^ (y >> 1) ^ mag01[y & 0x1UL];

        mti = 0;
    }

    y = mt[mti++];

    /* Tempering */
    y ^= (y >> 11);
    y ^= (y << 7) & 0x9d2c5680UL;
    y ^= (y << 15) & 0xefc60000UL;
    y ^= (y >> 18);

    return y;
}

#undef N
#undef M
#undef MATRIX_A
#undef UPPER_MASK
#undef LOWER_MASK

/* End of "Mersenne Twister". */

/* End of McCode random number routine. */

/* randnorm: generate a random number from normal law */
double
randnorm(void)
{
  static double v1, v2, s;
  static int phase = 0;
  double X, u1, u2;

  if(phase == 0)
  {
    do
    {
      u1 = rand01();
      u2 = rand01();
      v1 = 2*u1 - 1;
      v2 = 2*u2 - 1;
      s = v1*v1 + v2*v2;
    } while(s >= 1 || s == 0);

    X = v1*sqrt(-2*log(s)/s);
  }
  else
  {
    X = v2*sqrt(-2*log(s)/s);
  }

  phase = 1 - phase;
  return X;
}

/**
 * Generate a random number from -1 to 1 with triangle distribution
 */
double randtriangle(void) {
	double randnum = rand01();
	if (randnum>0.5) return(1-sqrt(2*(randnum-0.5)));
	else return(sqrt(2*randnum)-1);
}

/**
 * Random number between 0.0 and 1.0 (including?)
 */
double rand01() {
	double randnum;
	randnum = (double) random();
	randnum /= (double) MC_RAND_MAX + 1;
	return randnum;
}

/**
 * Return a random number between 1 and -1
 */
double randpm1() {
	double randnum;
	randnum = (double) random();
	randnum /= ((double) MC_RAND_MAX + 1) / 2;
	randnum -= 1;
	return randnum;
}

/**
 * Return a random number between 0 and max.
 */
double rand0max(double max) {
	double randnum;
	randnum = (double) random();
	randnum /= ((double) MC_RAND_MAX + 1) / max;
	return randnum;
}

/**
 * Return a random number between min and max.
 */
double randminmax(double min, double max) {
	return rand0max(max - min) + max;
}

/* SECTION: main and signal handlers ======================================== */

/*******************************************************************************
* mchelp: displays instrument executable help with possible options
*******************************************************************************/
static void
mchelp(char *pgmname)
{
  int i;

  fprintf(stderr, "%s (%s) instrument simulation, generated with " MCCODE_STRING " (" MCCODE_DATE ")\n", mcinstrument_name, mcinstrument_source);
  fprintf(stderr, "Usage: %s [options] [parm=value ...]\n", pgmname);
  fprintf(stderr,
"Options are:\n"
"  -s SEED   --seed=SEED      Set random seed (must be != 0)\n"
"  -n COUNT  --ncount=COUNT   Set number of " MCCODE_PARTICLE "s to simulate.\n"
"  -d DIR    --dir=DIR        Put all data files in directory DIR.\n"
"  -t        --trace          Enable trace of " MCCODE_PARTICLE "s through instrument.\n"
"  -g        --gravitation    Enable gravitation for all trajectories.\n"
"  --no-output-files          Do not write any data files.\n"
"  -h        --help           Show this help message.\n"
"  -i        --info           Detailed instrument information.\n"
"  --format=FORMAT            Output data files using FORMAT="
   FLAVOR_UPPER
#ifdef USE_NEXUS
   " NEXUS"
#endif
"\n\n"
);
#ifdef USE_MPI
  fprintf(stderr,
  "This instrument has been compiled with MPI support.\n  Use 'mpirun %s [options] [parm=value ...]'.\n", pgmname);
#endif
  if(mcnumipar > 0)
  {
    fprintf(stderr, "Instrument parameters are:\n");
    for(i = 0; i < mcnumipar; i++)
      if (mcinputtable[i].val && strlen(mcinputtable[i].val))
        fprintf(stderr, "  %-16s(%s) [default='%s']\n", mcinputtable[i].name,
        (*mcinputtypes[mcinputtable[i].type].parminfo)(mcinputtable[i].name),
        mcinputtable[i].val);
      else
        fprintf(stderr, "  %-16s(%s)\n", mcinputtable[i].name,
        (*mcinputtypes[mcinputtable[i].type].parminfo)(mcinputtable[i].name));
  }

#ifndef NOSIGNALS
  fprintf(stderr, "Known signals are: "
#ifdef SIGUSR1
  "USR1 (status) "
#endif
#ifdef SIGUSR2
  "USR2 (save) "
#endif
#ifdef SIGBREAK
  "BREAK (save) "
#endif
#ifdef SIGTERM
  "TERM (save and exit)"
#endif
  "\n");
#endif /* !NOSIGNALS */
} /* mchelp */


/* mcshowhelp: show help and exit with 0 */
static void
mcshowhelp(char *pgmname)
{
  mchelp(pgmname);
  exit(0);
}

/* mcusage: display usage when error in input arguments and exit with 1 */
static void
mcusage(char *pgmname)
{
  fprintf(stderr, "Error: incorrect command line arguments\n");
  mchelp(pgmname);
  exit(1);
}

/* mcenabletrace: enable trace/mcdisplay or error if requires recompile */
static void
mcenabletrace(void)
{
 if(mctraceenabled)
  mcdotrace = 1;
 else
 {
   fprintf(stderr,
           "Error: trace not enabled (mcenabletrace)\n"
           "Please re-run the " MCCODE_NAME " compiler "
                   "with the --trace option, or rerun the\n"
           "C compiler with the MC_TRACE_ENABLED macro defined.\n");
   exit(1);
 }
}

/*******************************************************************************
* mcreadparams: request parameters from the prompt (or use default)
*******************************************************************************/
void
mcreadparams(void)
{
  int i,j,status;
  static char buf[CHAR_BUF_LENGTH];
  char *p;
  int len;

  MPI_MASTER(printf("Instrument parameters for %s (%s)\n",
                    mcinstrument_name, mcinstrument_source));

  for(i = 0; mcinputtable[i].name != 0; i++)
  {
    do
    {
      MPI_MASTER(
                 if (mcinputtable[i].val && strlen(mcinputtable[i].val))
                   printf("Set value of instrument parameter %s (%s) [default='%s']:\n",
                          mcinputtable[i].name,
                          (*mcinputtypes[mcinputtable[i].type].parminfo)
                          (mcinputtable[i].name), mcinputtable[i].val);
                 else
                   printf("Set value of instrument parameter %s (%s):\n",
                          mcinputtable[i].name,
                          (*mcinputtypes[mcinputtable[i].type].parminfo)
                          (mcinputtable[i].name));
                 fflush(stdout);
                 );
#ifdef USE_MPI
      if(mpi_node_rank == mpi_node_root)
        {
          p = fgets(buf, CHAR_BUF_LENGTH, stdin);
          if(p == NULL)
            {
              fprintf(stderr, "Error: empty input for paramater %s (mcreadparams)\n", mcinputtable[i].name);
              exit(1);
            }
        }
      else
        p = buf;
      MPI_Bcast(buf, CHAR_BUF_LENGTH, MPI_CHAR, mpi_node_root, MPI_COMM_WORLD);
#else /* !USE_MPI */
      p = fgets(buf, CHAR_BUF_LENGTH, stdin);
      if(p == NULL)
        {
          fprintf(stderr, "Error: empty input for paramater %s (mcreadparams)\n", mcinputtable[i].name);
          exit(1);
        }
#endif /* USE_MPI */
      len = strlen(buf);
      if (!len || (len == 1 && (buf[0] == '\n' || buf[0] == '\r')))
      {
        if (mcinputtable[i].val && strlen(mcinputtable[i].val)) {
          strncpy(buf, mcinputtable[i].val, CHAR_BUF_LENGTH);  /* use default value */
          len = strlen(buf);
        }
      }
      for(j = 0; j < 2; j++)
      {
        if(len > 0 && (buf[len - 1] == '\n' || buf[len - 1] == '\r'))
        {
          len--;
          buf[len] = '\0';
        }
      }

      status = (*mcinputtypes[mcinputtable[i].type].getparm)
                   (buf, mcinputtable[i].par);
      if(!status)
      {
        (*mcinputtypes[mcinputtable[i].type].error)(mcinputtable[i].name, buf);
        if (!mcinputtable[i].val || strlen(mcinputtable[i].val)) {
          fprintf(stderr, "       Change %s default value in instrument definition.\n", mcinputtable[i].name);
          exit(1);
        }
      }
    } while(!status);
  }
} /* mcreadparams */

/*******************************************************************************
* mcparseoptions: parse command line arguments (options, parameters)
*******************************************************************************/
void
mcparseoptions(int argc, char *argv[])
{
  int i, j;
  char *p;
  int paramset = 0, *paramsetarray;
  char *usedir=NULL;

  /* Add one to mcnumipar to avoid allocating zero size memory block. */
  paramsetarray = (int*)malloc((mcnumipar + 1)*sizeof(*paramsetarray));
  if(paramsetarray == NULL)
  {
    fprintf(stderr, "Error: insufficient memory (mcparseoptions)\n");
    exit(1);
  }
  for(j = 0; j < mcnumipar; j++)
    {
      paramsetarray[j] = 0;
      if (mcinputtable[j].val != NULL && strlen(mcinputtable[j].val))
      {
        int  status;
        char buf[CHAR_BUF_LENGTH];
        strncpy(buf, mcinputtable[j].val, CHAR_BUF_LENGTH);
        status = (*mcinputtypes[mcinputtable[j].type].getparm)
                   (buf, mcinputtable[j].par);
        if(!status) fprintf(stderr, "Invalid '%s' default value %s in instrument definition (mcparseoptions)\n", mcinputtable[j].name, buf);
        else paramsetarray[j] = 1;
      } else {
        (*mcinputtypes[mcinputtable[j].type].getparm)
          (NULL, mcinputtable[j].par);
        paramsetarray[j] = 0;
      }
    }
  for(i = 1; i < argc; i++)
  {
    if(!strcmp("-s", argv[i]) && (i + 1) < argc)
      mcsetseed(argv[++i]);
    else if(!strncmp("-s", argv[i], 2))
      mcsetseed(&argv[i][2]);
    else if(!strcmp("--seed", argv[i]) && (i + 1) < argc)
      mcsetseed(argv[++i]);
    else if(!strncmp("--seed=", argv[i], 7))
      mcsetseed(&argv[i][7]);
    else if(!strcmp("-n", argv[i]) && (i + 1) < argc)
      mcsetn_arg(argv[++i]);
    else if(!strncmp("-n", argv[i], 2))
      mcsetn_arg(&argv[i][2]);
    else if(!strcmp("--ncount", argv[i]) && (i + 1) < argc)
      mcsetn_arg(argv[++i]);
    else if(!strncmp("--ncount=", argv[i], 9))
      mcsetn_arg(&argv[i][9]);
    else if(!strcmp("-d", argv[i]) && (i + 1) < argc)
      usedir=argv[++i];  /* will create directory after parsing all arguments (end of this function) */
    else if(!strncmp("-d", argv[i], 2))
      usedir=&argv[i][2];
    else if(!strcmp("--dir", argv[i]) && (i + 1) < argc)
      usedir=argv[++i];
    else if(!strncmp("--dir=", argv[i], 6))
      usedir=&argv[i][6];
    else if(!strcmp("-h", argv[i]))
      mcshowhelp(argv[0]);
    else if(!strcmp("--help", argv[i]))
      mcshowhelp(argv[0]);
    else if(!strcmp("-i", argv[i])) {
      mcformat=FLAVOR_UPPER;
      mcinfo();
    }
    else if(!strcmp("--info", argv[i]))
      mcinfo();
    else if(!strcmp("-t", argv[i]))
      mcenabletrace();
    else if(!strcmp("--trace", argv[i]))
      mcenabletrace();
    else if(!strcmp("--gravitation", argv[i]))
      mcgravitation = 1;
    else if(!strcmp("-g", argv[i]))
      mcgravitation = 1;
    else if(!strncmp("--format=", argv[i], 9)) {
      mcformat=&argv[i][9];
    }
    else if(!strcmp("--format", argv[i]) && (i + 1) < argc) {
      mcformat=argv[++i];
    }
    else if(!strcmp("--no-output-files", argv[i]))
      mcdisable_output_files = 1;
    else if(argv[i][0] != '-' && (p = strchr(argv[i], '=')) != NULL)
    {
      *p++ = '\0';

      for(j = 0; j < mcnumipar; j++)
        if(!strcmp(mcinputtable[j].name, argv[i]))
        {
          int status;
          status = (*mcinputtypes[mcinputtable[j].type].getparm)(p,
                        mcinputtable[j].par);
          if(!status || !strlen(p))
          {
            (*mcinputtypes[mcinputtable[j].type].error)
              (mcinputtable[j].name, p);
            exit(1);
          }
          paramsetarray[j] = 1;
          paramset = 1;
          break;
        }
      if(j == mcnumipar)
      {                                /* Unrecognized parameter name */
        fprintf(stderr, "Error: unrecognized parameter %s (mcparseoptions)\n", argv[i]);
        exit(1);
      }
    }
    else if(argv[i][0] == '-') {
      fprintf(stderr, "Error: unrecognized option argument %s (mcparseoptions). Ignored.\n", argv[i++]);
    }
    else {
      fprintf(stderr, "Error: unrecognized argument %s (mcparseoptions). Aborting.\n", argv[i]);
      mcusage(argv[0]);
    }
  }
  if(!paramset)
    mcreadparams();                /* Prompt for parameters if not specified. */
  else
  {
    for(j = 0; j < mcnumipar; j++)
      if(!paramsetarray[j])
      {
        fprintf(stderr, "Error: Instrument parameter %s left unset (mcparseoptions)\n",
                mcinputtable[j].name);
        exit(1);
      }
  }
  free(paramsetarray);
#ifdef USE_MPI
  if (mcdotrace) mpi_node_count=1; /* disable threading when in trace mode */
#endif
  if (usedir && strlen(usedir) && !mcdisable_output_files) mcuse_dir(usedir);
} /* mcparseoptions */

#ifndef NOSIGNALS
mcstatic char  mcsig_message[256];


/*******************************************************************************
* sighandler: signal handler that makes simulation stop, and save results
*******************************************************************************/
void sighandler(int sig)
{
  /* MOD: E. Farhi, Sep 20th 2001: give more info */
  time_t t1, t0;
#define SIG_SAVE 0
#define SIG_TERM 1
#define SIG_STAT 2
#define SIG_ABRT 3

  printf("\n# " MCCODE_STRING ": [pid %i] Signal %i detected", getpid(), sig);
#ifdef USE_MPI
  printf(" [proc %i]", mpi_node_rank);
#endif
#if defined(SIGUSR1) && defined(SIGUSR2) && defined(SIGKILL)
  if (!strcmp(mcsig_message, "sighandler") && (sig != SIGUSR1) && (sig != SIGUSR2))
  {
    printf("\n# Fatal : unrecoverable loop ! Suicide (naughty boy).\n");
    kill(0, SIGKILL); /* kill myself if error occurs within sighandler: loops */
  }
#endif
  switch (sig) {
#ifdef SIGINT
    case SIGINT : printf(" SIGINT (interrupt from terminal, Ctrl-C)"); sig = SIG_TERM; break;
#endif
#ifdef SIGILL
    case SIGILL  : printf(" SIGILL (Illegal instruction)"); sig = SIG_ABRT; break;
#endif
#ifdef SIGFPE
    case SIGFPE  : printf(" SIGFPE (Math Error)"); sig = SIG_ABRT; break;
#endif
#ifdef SIGSEGV
    case SIGSEGV : printf(" SIGSEGV (Mem Error)"); sig = SIG_ABRT; break;
#endif
#ifdef SIGTERM
    case SIGTERM : printf(" SIGTERM (Termination)"); sig = SIG_TERM; break;
#endif
#ifdef SIGABRT
    case SIGABRT : printf(" SIGABRT (Abort)"); sig = SIG_ABRT; break;
#endif
#ifdef SIGQUIT
    case SIGQUIT : printf(" SIGQUIT (Quit from terminal)"); sig = SIG_TERM; break;
#endif
#ifdef SIGTRAP
    case SIGTRAP : printf(" SIGTRAP (Trace trap)"); sig = SIG_ABRT; break;
#endif
#ifdef SIGPIPE
    case SIGPIPE : printf(" SIGPIPE (Broken pipe)"); sig = SIG_ABRT; break;
#endif
#ifdef SIGUSR1
    case SIGUSR1 : printf(" SIGUSR1 (Display info)"); sig = SIG_STAT; break;
#endif
#ifdef SIGUSR2
    case SIGUSR2 : printf(" SIGUSR2 (Save simulation)"); sig = SIG_SAVE; break;
#endif
#ifdef SIGHUP
    case SIGHUP  : printf(" SIGHUP (Hangup/update)"); sig = SIG_SAVE; break;
#endif
#ifdef SIGBUS
    case SIGBUS  : printf(" SIGBUS (Bus error)"); sig = SIG_ABRT; break;
#endif
#ifdef SIGURG
    case SIGURG  : printf(" SIGURG (Urgent socket condition)"); sig = SIG_ABRT; break;
#endif
#ifdef SIGBREAK
    case SIGBREAK: printf(" SIGBREAK (Break signal, Ctrl-Break)"); sig = SIG_SAVE; break;
#endif
    default : printf(" (look at signal list for signification)"); sig = SIG_ABRT; break;
  }
  printf("\n");
  printf("# Simulation: %s (%s) \n", mcinstrument_name, mcinstrument_source);
  printf("# Breakpoint: %s ", mcsig_message);
  if (strstr(mcsig_message, "Save") && (sig == SIG_SAVE))
    sig = SIG_STAT;
  SIG_MESSAGE("sighandler");
  if (mcget_ncount() == 0)
    printf("(0 %%)\n" );
  else
  {
    printf("%.2f %% (%10.1f/%10.1f)\n", 100.0*mcget_run_num()/mcget_ncount(), 1.0*mcget_run_num(), 1.0*mcget_ncount());
  }
  t0 = (time_t)mcstartdate;
  t1 = time(NULL);
  printf("# Date:      %s", ctime(&t1));
  printf("# Started:   %s", ctime(&t0));

  if (sig == SIG_STAT)
  {
    printf("# " MCCODE_STRING ": Resuming simulation (continue)\n");
    fflush(stdout);
    return;
  }
  else
  if (sig == SIG_SAVE)
  {
    printf("# " MCCODE_STRING ": Saving data and resume simulation (continue)\n");
    mcsave(NULL);
    fflush(stdout);
    return;
  }
  else
  if (sig == SIG_TERM)
  {
    printf("# " MCCODE_STRING ": Finishing simulation (save results and exit)\n");
    mcfinally();
    exit(0);
  }
  else
  {
    fflush(stdout);
    perror("# Last I/O Error");
    printf("# " MCCODE_STRING ": Simulation stop (abort).\n");
// This portion of the signal handling only works on UNIX
#if defined(__unix__) || defined(__APPLE__)
    signal(sig, SIG_DFL); /* force to use default sighandler now */
    kill(getpid(), sig);  /* and trigger it with the current signal */
#endif
    exit(-1);
  }
#undef SIG_SAVE
#undef SIG_TERM
#undef SIG_STAT
#undef SIG_ABRT

} /* sighandler */
#endif /* !NOSIGNALS */

/*******************************************************************************
* mccode_main: McCode main() function.
*******************************************************************************/
int mccode_main(int argc, char *argv[])
{
/*  double run_num = 0; */
  time_t  t;
#ifdef USE_MPI
  char mpi_node_name[MPI_MAX_PROCESSOR_NAME];
  int  mpi_node_name_len;
#endif /* USE_MPI */

#ifdef MAC
  argc = ccommand(&argv);
#endif

#ifdef USE_MPI
  MPI_Init(&argc,&argv);
  MPI_Comm_size(MPI_COMM_WORLD, &mpi_node_count); /* get number of nodes */
  MPI_Comm_rank(MPI_COMM_WORLD, &mpi_node_rank);
  MPI_Comm_set_name(MPI_COMM_WORLD, mcinstrument_name);
  MPI_Get_processor_name(mpi_node_name, &mpi_node_name_len);
#endif /* USE_MPI */

t = time(NULL);
mcseed = (long)t+(long)getpid();

#ifdef USE_MPI
/* *** print number of nodes *********************************************** */
  if (mpi_node_count > 1) {
    MPI_MASTER(
    printf("Simulation '%s' (%s): running on %i nodes (master is '%s', MPI version %i.%i).\n",
      mcinstrument_name, mcinstrument_source, mpi_node_count, mpi_node_name, MPI_VERSION, MPI_SUBVERSION);
    );
  }
#endif /* USE_MPI */
  
  mcstartdate = (long)t;  /* set start date before parsing options and creating sim file */

/* *** parse options ******************************************************* */
  SIG_MESSAGE("main (Start)");
  mcformat=getenv(FLAVOR_UPPER "_FORMAT") ?
           getenv(FLAVOR_UPPER "_FORMAT") : FLAVOR_UPPER;
  mcinstrument_exe = argv[0]; /* store the executable path */
  /* read simulation parameters and options */
  mcparseoptions(argc, argv); /* sets output dir and format */
  
#ifdef USE_MPI
  if (mpi_node_count > 1) {
    /* share the same seed, then adapt random seed for each node */
    MPI_Bcast(&mcseed, 1, MPI_LONG, 0, MPI_COMM_WORLD); /* root sends its seed to slaves */
    mcseed += mpi_node_rank; /* make sure we use different seeds per node */
  }
#endif
  srandom(mcseed);

/* *** install sig handler, but only once !! after parameters parsing ******* */
#ifndef NOSIGNALS
#ifdef SIGQUIT
  if (signal( SIGQUIT ,sighandler) == SIG_IGN)
    signal( SIGQUIT,SIG_IGN);   /* quit (ASCII FS) */
#endif
#ifdef SIGABRT
  if (signal( SIGABRT ,sighandler) == SIG_IGN)
    signal( SIGABRT,SIG_IGN);   /* used by abort, replace SIGIOT in the future */
#endif
#ifdef SIGTERM
  if (signal( SIGTERM ,sighandler) == SIG_IGN)
    signal( SIGTERM,SIG_IGN);   /* software termination signal from kill */
#endif
#ifdef SIGUSR1
  if (signal( SIGUSR1 ,sighandler) == SIG_IGN)
    signal( SIGUSR1,SIG_IGN);   /* display simulation status */
#endif
#ifdef SIGUSR2
  if (signal( SIGUSR2 ,sighandler) == SIG_IGN)
    signal( SIGUSR2,SIG_IGN);
#endif
#ifdef SIGHUP
  if (signal( SIGHUP ,sighandler) == SIG_IGN)
    signal( SIGHUP,SIG_IGN);
#endif
#ifdef SIGILL
  if (signal( SIGILL ,sighandler) == SIG_IGN)
    signal( SIGILL,SIG_IGN);    /* illegal instruction (not reset when caught) */
#endif
#ifdef SIGFPE
  if (signal( SIGFPE ,sighandler) == SIG_IGN)
    signal( SIGSEGV,SIG_IGN);    /* floating point exception */
#endif
#ifdef SIGBUS
  if (signal( SIGBUS ,sighandler) == SIG_IGN)
    signal( SIGSEGV,SIG_IGN);    /* bus error */
#endif
#ifdef SIGSEGV
  if (signal( SIGSEGV ,sighandler) == SIG_IGN)
    signal( SIGSEGV,SIG_IGN);   /* segmentation violation */
#endif
#endif /* !NOSIGNALS */
  mcsiminfo_init(NULL); /* open SIM */
  SIG_MESSAGE("main (Init)");
  mcinit();
#ifndef NOSIGNALS
#ifdef SIGINT
  if (signal( SIGINT ,sighandler) == SIG_IGN)
    signal( SIGINT,SIG_IGN);    /* interrupt (rubout) only after INIT */
#endif
#endif /* !NOSIGNALS */

/* ================ main particle generation/propagation loop ================ */
#if defined (USE_MPI)
  /* sliced Ncount on each MPI node */
  mcncount = mpi_node_count > 1 ?
    floor(mcncount / mpi_node_count) :
    mcncount; /* number of rays per node */
#endif

/* main particle event loop */
while(mcrun_num < mcncount || mcrun_num < mcget_ncount())
  {
#ifndef NEUTRONICS
    mcgenstate();
#endif
    /* old init: mcsetstate(0, 0, 0, 0, 0, 1, 0, sx=0, sy=1, sz=0, 1); */
    mcraytrace();
    mcrun_num++;
  }

#ifdef USE_MPI
 /* merge run_num from MPI nodes */
  if (mpi_node_count > 1) {
  double mcrun_num_double = (double)mcrun_num;
  mc_MPI_Sum(&mcrun_num_double, 1);
  mcrun_num = (unsigned long long)mcrun_num_double;
  }
#endif

/* save/finally executed by master node/thread */
  mcfinally();

#ifdef USE_MPI
  MPI_Finalize();
#endif /* USE_MPI */

  return 0;
} /* mccode_main */

#ifdef NEUTRONICS
/*Main neutronics function steers the McStas calls, initializes parameters etc */
/* Only called in case NEUTRONICS = TRUE */
void neutronics_main_(float *inx, float *iny, float *inz, float *invx, float *invy, float *invz, float *intime, float *insx, float *insy, float *insz, float *inw, float *outx, float *outy, float *outz, float *outvx, float *outvy, float *outvz, float *outtime, float *outsx, float *outsy, float *outsz, float *outwgt)
{

  extern double mcnx, mcny, mcnz, mcnvx, mcnvy, mcnvz;
  extern double mcnt, mcnsx, mcnsy, mcnsz, mcnp;

  /* External code governs iteration - McStas is iterated once per call to neutronics_main. I.e. below counter must be initiancated for each call to neutronics_main*/
  mcrun_num=0;

  time_t t;
  t = (time_t)mcstartdate;
  mcstartdate = t;  /* set start date before parsing options and creating sim file */
  mcinit();

  /* *** parse options *** */
  SIG_MESSAGE("main (Start)");
  mcformat=getenv(FLAVOR_UPPER "_FORMAT") ?
           getenv(FLAVOR_UPPER "_FORMAT") : FLAVOR_UPPER;

  /* Set neutron state based on input from neutronics code */
  mcsetstate(*inx,*iny,*inz,*invx,*invy,*invz,*intime,*insx,*insy,*insz,*inw);

  /* main neutron event loop - runs only one iteration */

  //mcstas_raytrace(&mcncount); /* prior to McStas 1.12 */

  mcallowbackprop = 1; //avoid absorbtion from negative dt
  int argc=1;
  char *argv[0];
  int dummy = mccode_main(argc, argv);

  *outx =  mcnx;
  *outy =  mcny;
  *outz =  mcnz;
  *outvx =  mcnvx;
  *outvy =  mcnvy;
  *outvz =  mcnvz;
  *outtime =  mcnt;
  *outsx =  mcnsx;
  *outsy =  mcnsy;
  *outsz =  mcnsz;
  *outwgt =  mcnp;

  return;
} /* neutronics_main */

#endif /*NEUTRONICS*/

#endif /* !MCCODE_H */
/* End of file "mccode-r.c". */
/* End of file "mccode-r.c". */

#line 4976 "MACS_sample_kidney_box.c"

#line 1 "mcstas-r.c"
/*******************************************************************************
*
* McStas, neutron ray-tracing package
*         Copyright (C) 1997-2009, All rights reserved
*         Risoe National Laboratory, Roskilde, Denmark
*         Institut Laue Langevin, Grenoble, France
*
* Runtime: share/mcstas-r.c
*
* %Identification
* Written by: KN
* Date:    Aug 29, 1997
* Release: McStas X.Y
* Version: $Revision$
*
* Runtime system for McStas.
* Embedded within instrument in runtime mode.
*
* Usage: Automatically embbeded in the c code whenever required.
*
* $Id$
*
*******************************************************************************/

#ifndef MCSTAS_R_H
#include "mcstas-r.h"
#endif
#ifdef DANSE
#include "mcstas-globals.h"
#endif

/*******************************************************************************
* The I/O format definitions and functions
*******************************************************************************/

/*the magnet stack*/
#ifdef MC_POL_COMPAT
void (*mcMagnetPrecession) (double, double, double, double, double, double,
    double, double*, double*, double*, double, Coords, Rotation)=NULL;
Coords   mcMagnetPos;
Rotation mcMagnetRot;
double*  mcMagnetData                = NULL;
/* mcMagneticField(x, y, z, t, Bx, By, Bz) */
int (*mcMagneticField) (double, double, double, double,
    double*, double*, double*, void *) = NULL;
#endif

#ifndef MCSTAS_H

/*******************************************************************************
* mcstore_neutron: stores neutron coodinates into global array (per component)
*******************************************************************************/
void
mcstore_neutron(MCNUM *s, int index, double x, double y, double z,
               double vx, double vy, double vz, double t,
               double sx, double sy, double sz, double p)
{
    double *dptr = &s[11*index];
    *dptr++  = x;
    *dptr++  = y ;
    *dptr++  = z ;
    *dptr++  = vx;
    *dptr++  = vy;
    *dptr++  = vz;
    *dptr++  = t ;
    *dptr++  = sx;
    *dptr++  = sy;
    *dptr++  = sz;
    *dptr    = p ;
} /* mcstore_neutron */

/*******************************************************************************
* mcrestore_neutron: restores neutron coodinates from global array
*******************************************************************************/
void
mcrestore_neutron(MCNUM *s, int index, double *x, double *y, double *z,
               double *vx, double *vy, double *vz, double *t,
               double *sx, double *sy, double *sz, double *p)
{
    double *dptr = &s[11*index];
    *x  =  *dptr++;
    *y  =  *dptr++;
    *z  =  *dptr++;
    *vx =  *dptr++;
    *vy =  *dptr++;
    *vz =  *dptr++;
    *t  =  *dptr++;
    *sx =  *dptr++;
    *sy =  *dptr++;
    *sz =  *dptr++;
    *p  =  *dptr;
} /* mcrestore_neutron */

/*******************************************************************************
* mcsetstate: transfer parameters into global McStas variables 
*******************************************************************************/
void
mcsetstate(double x, double y, double z, double vx, double vy, double vz,
           double t, double sx, double sy, double sz, double p)
{
  extern double mcnx, mcny, mcnz, mcnvx, mcnvy, mcnvz;
  extern double mcnt, mcnsx, mcnsy, mcnsz, mcnp;

  mcnx = x;
  mcny = y;
  mcnz = z;
  mcnvx = vx;
  mcnvy = vy;
  mcnvz = vz;
  mcnt = t;
  mcnsx = sx;
  mcnsy = sy;
  mcnsz = sz;
  mcnp = p;
} /* mcsetstate */

/*******************************************************************************
* mcgenstate: set default neutron parameters 
*******************************************************************************/
void
mcgenstate(void)
{
  mcsetstate(0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1);
  /* old initialisation: mcsetstate(0, 0, 0, 0, 0, 1, 0, sx=0, sy=1, sz=0, 1); */
}

/* intersection routines ==================================================== */

/*******************************************************************************
* inside_rectangle: Check if (x,y) is inside rectangle (xwidth, yheight) 
* return 0 if outside and 1 if inside 
*******************************************************************************/
int inside_rectangle(double x, double y, double xwidth, double yheight)
{
  if (x>-xwidth/2 && x<xwidth/2 && y>-yheight/2 && y<yheight/2)
    return 1;
  else
    return 0;
}

/*******************************************************************************
 * box_intersect: compute time intersection with a box
 * returns 0 when no intersection is found
 *      or 1 in case of intersection with resulting times dt_in and dt_out
 * This function written by Stine Nyborg, 1999. 
 *******************************************************************************/
int box_intersect(double *dt_in, double *dt_out,
                  double x, double y, double z,
                  double vx, double vy, double vz,
                  double dx, double dy, double dz)
{
  double x_in, y_in, z_in, tt, t[6], a, b;
  int i, count, s;

      /* Calculate intersection time for each of the six box surface planes
       *  If the box surface plane is not hit, the result is zero.*/

  if(vx != 0)
   {
    tt = -(dx/2 + x)/vx;
    y_in = y + tt*vy;
    z_in = z + tt*vz;
    if( y_in > -dy/2 && y_in < dy/2 && z_in > -dz/2 && z_in < dz/2)
      t[0] = tt;
    else
      t[0] = 0;

    tt = (dx/2 - x)/vx;
    y_in = y + tt*vy;
    z_in = z + tt*vz;
    if( y_in > -dy/2 && y_in < dy/2 && z_in > -dz/2 && z_in < dz/2)
      t[1] = tt;
    else
      t[1] = 0;
   }
  else
    t[0] = t[1] = 0;

  if(vy != 0)
   {
    tt = -(dy/2 + y)/vy;
    x_in = x + tt*vx;
    z_in = z + tt*vz;
    if( x_in > -dx/2 && x_in < dx/2 && z_in > -dz/2 && z_in < dz/2)
      t[2] = tt;
    else
      t[2] = 0;

    tt = (dy/2 - y)/vy;
    x_in = x + tt*vx;
    z_in = z + tt*vz;
    if( x_in > -dx/2 && x_in < dx/2 && z_in > -dz/2 && z_in < dz/2)
      t[3] = tt;
    else
      t[3] = 0;
   }
  else
    t[2] = t[3] = 0;

  if(vz != 0)
   {
    tt = -(dz/2 + z)/vz;
    x_in = x + tt*vx;
    y_in = y + tt*vy;
    if( x_in > -dx/2 && x_in < dx/2 && y_in > -dy/2 && y_in < dy/2)
      t[4] = tt;
    else
      t[4] = 0;

    tt = (dz/2 - z)/vz;
    x_in = x + tt*vx;
    y_in = y + tt*vy;
    if( x_in > -dx/2 && x_in < dx/2 && y_in > -dy/2 && y_in < dy/2)
      t[5] = tt;
    else
      t[5] = 0;
   }
  else
    t[4] = t[5] = 0;

  /* The intersection is evaluated and *dt_in and *dt_out are assigned */

  a = b = s = 0;
  count = 0;

  for( i = 0; i < 6; i = i + 1 )
    if( t[i] == 0 )
      s = s+1;
    else if( count == 0 )
    {
      a = t[i];
      count = 1;
    }
    else
    {
      b = t[i];
      count = 2;
    }

  if ( a == 0 && b == 0 )
    return 0;
  else if( a < b )
  {
    *dt_in = a;
    *dt_out = b;
    return 1;
  }
  else
  {
    *dt_in = b;
    *dt_out = a;
    return 1;
  }

} /* box_intersect */

/*******************************************************************************
 * cylinder_intersect: compute intersection with a cylinder
 * returns 0 when no intersection is found
 *      or 2/4/8/16 bits depending on intersection,
 *     and resulting times t0 and t1
 * Written by: EM,NB,ABA 4.2.98 
  *******************************************************************************/
int
cylinder_intersect(double *t0, double *t1, double x, double y, double z,
                   double vx, double vy, double vz, double r, double h)
{
  double D, t_in, t_out, y_in, y_out;
  int ret=1;

  D = (2*vx*x + 2*vz*z)*(2*vx*x + 2*vz*z)
    - 4*(vx*vx + vz*vz)*(x*x + z*z - r*r);

  if (D>=0)
  {
    if (vz*vz + vx*vx) {
      t_in  = (-(2*vz*z + 2*vx*x) - sqrt(D))/(2*(vz*vz + vx*vx));
      t_out = (-(2*vz*z + 2*vx*x) + sqrt(D))/(2*(vz*vz + vx*vx));
    } else if (vy) { /* trajectory parallel to cylinder axis */
      t_in = (-h/2-y)/vy;
      t_out = (h/2-y)/vy;
      if (t_in>t_out){
        double tmp=t_in;
        t_in=t_out;t_out=tmp;
      }
    } else return 0;
    y_in = vy*t_in + y;
    y_out =vy*t_out + y;

    if ( (y_in > h/2 && y_out > h/2) || (y_in < -h/2 && y_out < -h/2) )
      return 0;
    else
    {
      if (y_in > h/2)
        { t_in = ((h/2)-y)/vy; ret += 2; }
      else if (y_in < -h/2)
        { t_in = ((-h/2)-y)/vy; ret += 4; }
      if (y_out > h/2)
        { t_out = ((h/2)-y)/vy; ret += 8; }
      else if (y_out < -h/2)
        { t_out = ((-h/2)-y)/vy; ret += 16; }
    }
    *t0 = t_in;
    *t1 = t_out;
    return ret;
  }
  else
  {
    *t0 = *t1 = 0;
    return 0;
  }
} /* cylinder_intersect */


/*******************************************************************************
 * sphere_intersect: Calculate intersection between a line and a sphere.
 * returns 0 when no intersection is found
 *      or 1 in case of intersection with resulting times t0 and t1 
 *******************************************************************************/
int
sphere_intersect(double *t0, double *t1, double x, double y, double z,
                 double vx, double vy, double vz, double r)
{
  double A, B, C, D, v;

  v = sqrt(vx*vx + vy*vy + vz*vz);
  A = v*v;
  B = 2*(x*vx + y*vy + z*vz);
  C = x*x + y*y + z*z - r*r;
  D = B*B - 4*A*C;
  if(D < 0)
    return 0;
  D = sqrt(D);
  *t0 = (-B - D) / (2*A);
  *t1 = (-B + D) / (2*A);
  return 1;
} /* sphere_intersect */

/*******************************************************************************
 * plane_intersect: Calculate intersection between a plane and a line.
 * returns 0 when no intersection is found (i.e. line is parallel to the plane)
 * returns 1 or -1 when intersection time is positive and negative respectively
 *******************************************************************************/
int
plane_intersect(double *t, double x, double y, double z,
                 double vx, double vy, double vz, double nx, double ny, double nz, double wx, double wy, double wz)
{
  double s;
  if (fabs(s=scalar_prod(nx,ny,nz,vx,vy,vz))<FLT_EPSILON) return 0;
  *t = - scalar_prod(nx,ny,nz,x-wx,y-wy,z-wz)/s;
  if (*t<0) return -1;
  else return 1;
} /* plane_intersect */

#endif /* !MCSTAS_H */
/* End of file "mcstas-r.c". */

#line 5336 "MACS_sample_kidney_box.c"
#ifdef MC_TRACE_ENABLED
int mctraceenabled = 1;
#else
int mctraceenabled = 0;
#endif
#define MCSTAS "/usr/share/mcstas/2.7/"
int mcdefaultmain = 1;
char mcinstrument_name[] = "dmtas";
char mcinstrument_source[] = "MACS_sample_kidney_box.instr";
char *mcinstrument_exe=NULL; /* will be set to argv[0] in main */
int main(int argc, char *argv[]){return mccode_main(argc, argv);}
void mcinit(void);
void mcraytrace(void);
void mcsave(FILE *);
void mcfinally(void);
void mcdisplay(void);

/* Shared user declarations for all components 'Incoherent_process'. */
#line 62 "Incoherent_process.comp"
#ifndef Union
#define Union $Revision: 0.8 $

#include "Union_functions.c"
#include "Union_initialization.c"

#endif


struct Incoherent_physics_storage_struct{
    // Variables that needs to be transfered between any of the following places:
    // The initialize in this component
    // The function for calculating my
    // The function for calculating scattering
    
    double my_scattering;
    double QE_sampling_frequency;
    double lorentzian_width;
    
};

// Function for calculating my in Incoherent case
int Incoherent_physics_my(double *my,double *k_initial, union data_transfer_union data_transfer, struct focus_data_struct *focus_data) {
    *my = data_transfer.pointer_to_a_Incoherent_physics_storage_struct->my_scattering;
    return 1;
};

// Function for basic incoherent scattering event
int Incoherent_physics_scattering(double *k_final, double *k_initial, double *weight, union data_transfer_union data_transfer, struct focus_data_struct *focus_data) {

    //New version of incoherent scattering
    double k_length = sqrt(k_initial[0]*k_initial[0]+k_initial[1]*k_initial[1]+k_initial[2]*k_initial[2]);

    Coords k_out;
    // Here is the focusing system in action, get a vector
    double solid_angle;
    focus_data->focusing_function(&k_out,&solid_angle,focus_data);
    NORM(k_out.x,k_out.y,k_out.z);
    *weight *= solid_angle*0.25/PI;
    
    double v_i,v_f,E_i,dE,E_f;
    
    if (rand01() < data_transfer.pointer_to_a_Incoherent_physics_storage_struct->QE_sampling_frequency) {
      v_i = k_length * K2V;
      E_i = VS2E*v_i*v_i;
      dE = data_transfer.pointer_to_a_Incoherent_physics_storage_struct->lorentzian_width*tan(PI/2*randpm1());
      E_f = E_i + dE;
      if (E_f <= 0)
        return 0;
      v_f = SE2V*sqrt(E_f);
      k_length = v_f*V2K;
    }
    
    k_final[0] = k_out.x*k_length; k_final[1] = k_out.y*k_length; k_final[2] = k_out.z*k_length;
    return 1;
};

#line 5413 "MACS_sample_kidney_box.c"

/* Shared user declarations for all components 'Powder_process'. */
#line 57 "Powder_process.comp"
#ifndef Union
#define Union $Revision: 0.8 $

#include "Union_functions.c"
#include "Union_initialization.c"

#endif



// Share section of PowderN 8/3 2016 from McStas.org

  /* used for reading data table from file */
/*******************************************************************************
*
* McStas, neutron ray-tracing package
*         Copyright 1997-2002, All rights reserved
*         Risoe National Laboratory, Roskilde, Denmark
*         Institut Laue Langevin, Grenoble, France
*
* Library: share/read_table-lib.h
*
* %Identification
* Written by: EF
* Date: Aug 28, 2002
* Origin: ILL
* Release: McStas 1.6
* Version: $Revision$
*
* This file is to be imported by components that may read data from table files
* It handles some shared functions.
*
* This library may be used directly as an external library. It has no dependency
*
* Usage: within SHARE
* %include "read_table-lib"
*
*******************************************************************************/

#ifndef READ_TABLE_LIB_H
#define READ_TABLE_LIB_H "$Revision$"

#define READ_TABLE_STEPTOL  0.04 /* tolerancy for constant step approx */

#ifndef MC_PATHSEP_C
#ifdef WIN32
#define MC_PATHSEP_C '\\'
#define MC_PATHSEP_S "\\"
#else  /* !WIN32 */
#ifdef MAC
#define MC_PATHSEP_C ':'
#define MC_PATHSEP_S ":"
#else  /* !MAC */
#define MC_PATHSEP_C '/'
#define MC_PATHSEP_S "/"
#endif /* !MAC */
#endif /* !WIN32 */
#endif /* !MC_PATHSEP_C */

#ifndef MCSTAS
#ifdef WIN32
#define MCSTAS "C:\\mcstas\\lib"
#else  /* !WIN32 */
#ifdef MAC
#define MCSTAS ":mcstas:lib" /* ToDo: What to put here? */
#else  /* !MAC */
#define MCSTAS "/usr/local/lib/mcstas"
#endif /* !MAC */
#endif /* !WIN32 */
#endif /* !MCSTAS */

#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>

  typedef struct struct_table
  {
    char    filename[1024];
    long    filesize;
    char   *header;  /* text header, e.g. comments */
    double *data;    /* vector { x[0], y[0], ... x[n-1], y[n-1]... } */
    double  min_x;   /* min value of first column */
    double  max_x;   /* max value of first column */
    double  step_x;  /* minimal step value of first column */
    long    rows;    /* number of rows in matrix block */
    long    columns; /* number of columns in matrix block */

    long    begin;   /* start fseek index of block */
    long    end;     /* stop  fseek index of block */
    long    block_number;  /* block index. 0 is catenation of all */
    long    array_length;  /* number of elements in the t_Table array */
    char    monotonic;     /* true when 1st column/vector data is monotonic */
    char    constantstep;  /* true when 1st column/vector data has constant step */
    char    method[32];    /* interpolation method: nearest, linear */
  } t_Table;

/*maximum number of rows to rebin a table = 1M*/
enum { mcread_table_rebin_maxsize = 1000000 };

typedef struct t_Read_table_file_item {
    int ref_count;
    t_Table *table_ref;
} t_Read_table_file_item;

typedef enum enum_Read_table_file_actions {STORE,FIND,GC}  t_Read_table_file_actions;

/* read_table-lib function prototypes */
/* ========================================================================= */

/* 'public' functions */
long     Table_Read              (t_Table *Table, char *File, long block_number);
long     Table_Read_Offset       (t_Table *Table, char *File, long block_number,
                                  long *offset, long max_lines);
long     Table_Read_Offset_Binary(t_Table *Table, char *File, char *Type,
                                  long *Offset, long Rows, long Columns);
long     Table_Rebin(t_Table *Table); /* rebin table with regular 1st column and interpolate all columns 2:end */
long     Table_Info (t_Table Table);
double   Table_Index(t_Table Table,   long i, long j); /* get indexed value */
double   Table_Value(t_Table Table, double X, long j); /* search X in 1st column and return interpolated value in j-column */
t_Table *Table_Read_Array(char *File, long *blocks);
void     Table_Free_Array(t_Table *Table);
long     Table_Info_Array(t_Table *Table);
int      Table_SetElement(t_Table *Table, long i, long j, double value);
long     Table_Init(t_Table *Table, long rows, long columns); /* create a Table */
double   Table_Value2d(t_Table Table, double X, double Y);    /* same as Table_Index with non-integer indices and 2d interpolation */
MCDETECTOR Table_Write(t_Table Table, char*file, char*xl, char*yl, 
           double x1, double x2, double y1, double y2); /* write Table to disk */
void * Table_File_List_Handler(t_Read_table_file_actions action, void *item, void *item_modifier);
t_Table *Table_File_List_find(char *name, int block, int offset);
int Table_File_List_gc(t_Table *tab);
void *Table_File_List_store(t_Table *tab);

#define Table_ParseHeader(header, ...) \
  Table_ParseHeader_backend(header,__VA_ARGS__,NULL);

char **Table_ParseHeader_backend(char *header, ...);

/* private functions */
void Table_Free(t_Table *Table);
long Table_Read_Handle(t_Table *Table, FILE *fid, long block_number, long max_lines, char *name);
static void Table_Stat(t_Table *Table);
double Table_Interp1d(double x, double x1, double y1, double x2, double y2);
double Table_Interp1d_nearest(double x, double x1, double y1, double x2, double y2);
double Table_Interp2d(double x, double y, double x1, double y1, double x2, double y2,
double z11, double z12, double z21, double z22);

#endif

/* end of read_table-lib.h */
/*******************************************************************************
*
* McStas, neutron ray-tracing package
*         Copyright (C) 1997-2009, All rights reserved
*         Risoe National Laboratory, Roskilde, Denmark
*         Institut Laue Langevin, Grenoble, France
*
* Library: share/read_table-lib.c
*
* %Identification
* Written by: EF
* Date: Aug 28, 2002
* Origin: ILL
* Release: McStas CVS_090504
* Version: $Revision: 5052 $
*
* This file is to be imported by components that may read data from table files
* It handles some shared functions. Embedded within instrument in runtime mode.
*
* Usage: within SHARE
* %include "read_table-lib"
*
*******************************************************************************/

#ifndef READ_TABLE_LIB_H
#include "read_table-lib.h"
#endif


/*******************************************************************************
 * void *Table_File_List_Handler(action, item, item_modifier)
 *   ACTION: handle file entries in the read_table-lib file list. If a file is read - it is supposed to be
 *   stored in a list such that we can avoid reading the same file many times.
 *   input  action: FIND, STORE, GC. check if file exists in the list, store an item in the list, or check if it can be garbage collected.
 *   input item: depends on the action.
 *    FIND)  item is a filename, and item_modifier is the block number
 *    STORE) item is the Table to store - item_modifier is ignored
 *    GC)    item is the Table to check. If it has a ref_count >1 then this is simply decremented.
 *   return  depends on the action
 *    FIND)  return a reference to a table+ref_count item if found - NULL otherwise. I.e. NULL means the file has not been read before and must be read again.
 *    STORE) return NULL always
 *    GC)    return NULL if no garbage collection is needed, return an adress to the t_Table which should be garbage collected. 0x1 is returned if
 *           the item is not found in the list
*******************************************************************************/
void * Table_File_List_Handler(t_Read_table_file_actions action, void *item, void *item_modifier){

    /* logic here is Read_Table should include a call to FIND. If found the return value should just be used as
     * if the table had been read from disk. If not found then read the table and STORE.
     * Table_Free should include a call to GC. If this returns non-NULL then we should proceed with freeing the memory
     * associated with the table item - otherwise only decrement the reference counter since there are more references
     * that may need it.*/

    static t_Read_table_file_item read_table_file_list[1024];  
    static int read_table_file_count=0;

    t_Read_table_file_item *tr;
    switch(action){
        case FIND:
            /*interpret data item as a filename, if it is found return a pointer to the table and increment refcount.
             * if not found return the item itself*/
            tr=read_table_file_list;
            while ( tr->table_ref!=NULL ){
                int i=*((int*) item_modifier);
                int j=*( ((int*) item_modifier)+1);
                if ( !strcmp(tr->table_ref->filename,(char *) item) &&
                        tr->table_ref->block_number==i && tr->table_ref->begin==j ){
                    tr->ref_count++;
                    return (void *) tr;
                }
                tr++;
            }
            return NULL;
        case STORE:
            /*find an available slot and store references to table there*/
            tr=&(read_table_file_list[read_table_file_count++]);
            tr->table_ref = ((t_Table *) item);
            tr->ref_count++;
            return NULL;
        case GC:
            /* Should this item be garbage collected (freed) - if so scratch the entry and return the address of the item - 
             * else decrement ref_count and return NULL.
             * A non-NULL return expects the item to actually be freed afterwards.*/
            tr=read_table_file_list;
            while ( tr->table_ref!=NULL ){
                if ( tr->table_ref->data ==((t_Table *)item)->data && 
                        tr->table_ref->block_number == ((t_Table *)item)->block_number){
                    /*matching item found*/
                    if (tr->ref_count>1){
                        /*the item is found and no garbage collection needed*/
                        tr->ref_count--;
                        return NULL;
                    }else{
                        /* The item is found and the reference counter is 1.
                         * This means we should garbage collect. Move remaining list items up one slot,
                         * and return the table for garbage collection by caller*/
                        while (tr->table_ref!=NULL){
                            *tr=*(tr+1);
                            tr++;
                        }
                        read_table_file_count--;
                        return (t_Table *) item;
                    }
                }
                tr++;
            }
            /* item not found, and so should be garbage collected. This could be the case if freeing a
             * Table that has been constructed from code - not read from file. Return 0x1 to flag it for
             * collection.*/
            return (void *) 0x1 ;
    }
}

/* Access functions to the handler*/

/********************************************
 * t_Table *Table_File_List_find(char *name, int block, int offset)
 * input name: filename to search for in the file list
 * input block: data block in the file as each file may contain more than 1 data block.
 * return a ref. to a table if it is found (you may use this pointer and skip reading the file), NULL otherwise (i.e. go ahead and read the file)
*********************************************/
t_Table *Table_File_List_find(char *name, int block, int offset){
    int vars[2]={block,offset};
    t_Read_table_file_item *item = Table_File_List_Handler(FIND,name, vars);
    if (item == NULL){
        return NULL;
    }else{
        return item->table_ref;
    }
}
/********************************************
 * int Table_File_List_gc(t_Table *tab)
 * input tab: the table to check for references.
 * return 0: no garbage collection needed
 *        1: Table's data and header (at least) should be freed.
*********************************************/
int Table_File_List_gc(t_Table *tab){
    void *rval=Table_File_List_Handler(GC,tab,0);
    if (rval==NULL) return 0;
    else return 1;
}


/*****************************************************************************
 * void *Table_File_List_store(t_Table *tab)
 * input tab: pointer to table to store.
 * return None. 
*******************************************************************************/
void *Table_File_List_store(t_Table *tab){
    return Table_File_List_Handler(STORE,tab,0);
}


/*******************************************************************************
* FILE *Open_File(char *name, char *Mode, char *path)
*   ACTION: search for a file and open it. Optionally return the opened path.
*   input   name:  file name from which table should be extracted
*           mode: "r", "w", "a" or any valid fopen mode
*           path:  NULL or a pointer to at least 1024 allocated chars
*   return  initialized file handle or NULL in case of error
*******************************************************************************/

  FILE *Open_File(char *File, const char *Mode, char *Path)
  {
    char path[1024];
    FILE *hfile = NULL;
    
    if (!File || File[0]=='\0')                     return(NULL);
    if (!strcmp(File,"NULL") || !strcmp(File,"0"))  return(NULL);
    
    /* search in current or full path */
    strncpy(path, File, 1024);
    hfile = fopen(path, Mode);
    if(!hfile)
    {
      char dir[1024];

      if (!hfile && mcinstrument_source[0] != '\0' && strlen(mcinstrument_source)) /* search in instrument source location */
      {
        char *path_pos   = NULL;
        /* extract path: searches for last file separator */
        path_pos    = strrchr(mcinstrument_source, MC_PATHSEP_C);  /* last PATHSEP */
        if (path_pos) {
          long path_length = path_pos +1 - mcinstrument_source;  /* from start to path+sep */
          if (path_length) {
            strncpy(dir, mcinstrument_source, path_length);
            dir[path_length] = '\0';
            snprintf(path, 1024, "%s%c%s", dir, MC_PATHSEP_C, File);
            hfile = fopen(path, Mode);
          }
        }
      }
      if (!hfile && mcinstrument_exe[0] != '\0' && strlen(mcinstrument_exe)) /* search in PWD instrument executable location */
      {
        char *path_pos   = NULL;
        /* extract path: searches for last file separator */
        path_pos    = strrchr(mcinstrument_exe, MC_PATHSEP_C);  /* last PATHSEP */
        if (path_pos) {
          long path_length = path_pos +1 - mcinstrument_exe;  /* from start to path+sep */
          if (path_length) {
            strncpy(dir, mcinstrument_exe, path_length);
            dir[path_length] = '\0';
            snprintf(path, 1024, "%s%c%s", dir, MC_PATHSEP_C, File);
            hfile = fopen(path, Mode);
          }
        }
      }
      if (!hfile) /* search in HOME or . */
      {
        strcpy(dir, getenv("HOME") ? getenv("HOME") : ".");
        snprintf(path, 1024, "%s%c%s", dir, MC_PATHSEP_C, File);
        hfile = fopen(path, Mode);
      }
      if (!hfile) /* search in MCSTAS/data */
      {
        strcpy(dir, getenv(FLAVOR_UPPER) ? getenv(FLAVOR_UPPER) : MCSTAS);
        snprintf(path, 1024, "%s%c%s%c%s", dir, MC_PATHSEP_C, "data", MC_PATHSEP_C, File);
        hfile = fopen(path, Mode);
      }
      if (!hfile) /* search in MVCSTAS/contrib */
      {
        strcpy(dir, getenv(FLAVOR_UPPER) ? getenv(FLAVOR_UPPER) : MCSTAS);
        snprintf(path, 1024, "%s%c%s%c%s", dir, MC_PATHSEP_C, "contrib", MC_PATHSEP_C, File);
        hfile = fopen(path, Mode);
      }
      if(!hfile)
      {
        fprintf(stderr, "Error: Could not open input file '%s' (Open_File)\n", File);
        return (NULL);
      }
    }
    if (Path) strncpy(Path, path, 1024);
    return(hfile);
  } /* end Open_File */

/*******************************************************************************
* long Read_Table(t_Table *Table, char *name, int block_number)
*   ACTION: read a single Table from a text file
*   input   Table: pointer to a t_Table structure
*           name:  file name from which table should be extracted
*           block_number: if the file does contain more than one
*                 data block, then indicates which one to get (from index 1)
*                 a 0 value means append/catenate all
*   return  initialized single Table t_Table structure containing data, header, ...
*           number of read elements (-1: error, 0:header only)
* The routine stores any line starting with '#', '%' and ';' into the header
* File is opened, read and closed
* Other lines are interpreted as numerical data, and stored.
* Data block should be a rectangular matrix or vector.
* Data block may be rebinned with Table_Rebin (also sort in ascending order)
*******************************************************************************/
  long Table_Read(t_Table *Table, char *File, long block_number)
  { /* reads all or a single data block from 'file' and returns a Table structure  */
    return(Table_Read_Offset(Table, File, block_number, NULL, 0));
  } /* end Table_Read */

/*******************************************************************************
* long Table_Read_Offset(t_Table *Table, char *name, int block_number, long *offset
*                        long max_rows)
*   ACTION: read a single Table from a text file, starting at offset
*     Same as Table_Read(..) except:
*   input   offset:    pointer to an offset (*offset should be 0 at start)
*           max_rows: max number of data rows to read from file (0 means all)
*   return  initialized single Table t_Table structure containing data, header, ...
*           number of read elements (-1: error, 0:header only)
*           updated *offset position (where end of reading occured)
*******************************************************************************/
  long Table_Read_Offset(t_Table *Table, char *File,
                         long block_number, long *offset,
                         long max_rows)
  { /* reads all/a data block in 'file' and returns a Table structure  */
    FILE *hfile;
    long  nelements=0;
    long  begin=0;
    long  filesize=0;
    char  name[1024];
    char  path[1024];
    struct stat stfile;

    /*Need to be able to store the pointer*/
    if (!Table) return(-1);
    
    //if (offset && *offset) snprintf(name, 1024, "%s@%li", File, *offset);
    //else                   
    strncpy(name, File, 1024);
    if(offset && *offset){
        begin=*offset;
    }
    /* Check if the table has already been read from file.
     * If so just reuse the table, if not (this is flagged by returning NULL
     * set up a new table and read the data into it */
    t_Table *tab_p= Table_File_List_find(name,block_number,begin);
    if ( tab_p!=NULL ){
        /*table was found in the Table_File_List*/
        // printf("Reusing input file '%s' (Table_Read_Offset)\n", name);
        *Table=*tab_p;
        return Table->rows*Table->columns;
    }

    /* open the file */
    hfile = Open_File(File, "r", path);
    if (!hfile) return(-1);
    else {
      MPI_MASTER(
      printf("Opening input file '%s' (Table_Read_Offset)\n", path);
      );
    }
    
    /* read file state */
    stat(path,&stfile); filesize = stfile.st_size;
    if (offset && *offset) fseek(hfile, *offset, SEEK_SET);
    begin     = ftell(hfile);
    
    Table_Init(Table, 0, 0);

    /* read file content and set the Table */
    nelements = Table_Read_Handle(Table, hfile, block_number, max_rows, name);
    Table->begin = begin;
    Table->end   = ftell(hfile);
    Table->filesize = (filesize>0 ? filesize : 0);
    Table_Stat(Table);
    
    Table_File_List_store(Table);

    if (offset) *offset=Table->end;
    fclose(hfile);
    return(nelements);

  } /* end Table_Read_Offset */

/*******************************************************************************
* long Table_Read_Offset_Binary(t_Table *Table, char *File, char *type,
*                               long *offset, long rows, long columns)
*   ACTION: read a single Table from a binary file, starting at offset
*     Same as Table_Read_Offset(..) except that it handles binary files.
*   input   type: may be "float"/NULL or "double"
*           offset: pointer to an offset (*offset should be 0 at start)
*           rows   : number of rows (0 means read all)
*           columns: number of columns
*   return  initialized single Table t_Table structure containing data, header, ...
*           number of read elements (-1: error, 0:header only)
*           updated *offset position (where end of reading occured)
*******************************************************************************/
  long Table_Read_Offset_Binary(t_Table *Table, char *File, char *type,
                                long *offset, long rows, long columns)
  { /* reads all/a data block in binary 'file' and returns a Table structure  */
    long    nelements, sizeofelement;
    long    filesize;
    FILE   *hfile;
    char    path[1024];
    struct stat stfile;
    double *data;
    long    i;
    long    begin;

    if (!Table) return(-1);

    Table_Init(Table, 0, 0);
    
    /* open the file */
    hfile = Open_File(File, "r", path);
    if (!hfile) return(-1);
    else {
      MPI_MASTER(
      printf("Opening input file '%s' (Table_Read, Binary)\n", path);
      );
    }
    
    /* read file state */
    stat(File,&stfile);
    filesize = stfile.st_size;
    Table->filesize=filesize;
    
    /* read file content */
    if (type && !strcmp(type,"double")) sizeofelement = sizeof(double);
    else  sizeofelement = sizeof(float);
    if (offset && *offset) fseek(hfile, *offset, SEEK_SET);
    begin     = ftell(hfile);
    if (rows && filesize > sizeofelement*columns*rows)
      nelements = columns*rows;
    else nelements = (long)(filesize/sizeofelement);
    if (!nelements || filesize <= *offset) return(0);
    data    = (double*)malloc(nelements*sizeofelement);
    if (!data) {
      fprintf(stderr,"Error: allocating %ld elements for %s file '%s'. Too big (Table_Read_Offset_Binary).\n", nelements, type, File);
      exit(-1);
    }
    nelements = fread(data, sizeofelement, nelements, hfile);

    if (!data || !nelements)
    {
      fprintf(stderr,"Error: reading %ld elements from %s file '%s' (Table_Read_Offset_Binary)\n", nelements, type, File);
      exit(-1);
    }
    Table->begin   = begin;
    Table->end     = ftell(hfile);
    if (offset) *offset=Table->end;
    fclose(hfile);
    data = (double*)realloc(data, (double)nelements*sizeofelement);
    /* copy file data into Table */
    if (type && !strcmp(type,"double")) Table->data = data;
    else {
      float  *s;
      double *dataf;
      s     = (float*)data;
      dataf = (double*)malloc(sizeof(double)*nelements);
      for (i=0; i<nelements; i++)
        dataf[i]=s[i];
      free(data);
      Table->data = dataf;
    }
    strncpy(Table->filename, File, 1024);
    Table->rows    = nelements/columns;
    Table->columns = columns;
    Table->array_length = 1;
    Table->block_number = 1;

    Table_Stat(Table);

    return(nelements);
  } /* end Table_Read_Offset_Binary */

/*******************************************************************************
* long Table_Read_Handle(t_Table *Table, FILE *fid, int block_number, long max_rows, char *name)
*   ACTION: read a single Table from a text file handle (private)
*   input   Table:pointer to a t_Table structure
*           fid:  pointer to FILE handle
*           block_number: if the file does contain more than one
*                 data block, then indicates which one to get (from index 1)
*                 a 0 value means append/catenate all
*           max_rows: if non 0, only reads that number of lines
*   return  initialized single Table t_Table structure containing data, header, ...
*           modified Table t_Table structure containing data, header, ...
*           number of read elements (-1: error, 0:header only)
* The routine stores any line starting with '#', '%' and ';' into the header
* Other lines are interpreted as numerical data, and stored.
* Data block should be a rectangular matrix or vector.
* Data block may be rebined with Table_Rebin (also sort in ascending order)
*******************************************************************************/
  long Table_Read_Handle(t_Table *Table, FILE *hfile,
                         long block_number, long max_rows, char *name)
  { /* reads all/a data block from 'file' handle and returns a Table structure  */
    double *Data;
    char *Header              = NULL;
    long  malloc_size         = CHAR_BUF_LENGTH;
    long  malloc_size_h       = 4096;
    long  Rows = 0,   Columns = 0;
    long  count_in_array      = 0;
    long  count_in_header     = 0;
    long  block_Current_index = 0;
    char  flag_End_row_loop   = 0;

    if (!Table) return(-1);
    Table_Init(Table, 0, 0);
    if (name && name[0]!='\0') strncpy(Table->filename, name, 1024);

    if(!hfile) {
       fprintf(stderr, "Error: File handle is NULL (Table_Read_Handle).\n");
       return (-1);
    }
    Header = (char*)  calloc(malloc_size_h, sizeof(char));
    Data   = (double*)calloc(malloc_size,   sizeof(double));
    if ((Header == NULL) || (Data == NULL)) {
       fprintf(stderr, "Error: Could not allocate Table and Header (Table_Read_Handle).\n");
       return (-1);
    }

    int flag_In_array = 0;
    do { /* while (!flag_End_row_loop) */
      char  line[1024*CHAR_BUF_LENGTH];
      long  back_pos=0;   /* ftell start of line */

      back_pos = ftell(hfile);
      if (fgets(line, 1024*CHAR_BUF_LENGTH, hfile) != NULL) { /* analyse line */
        /* first skip blank and tabulation characters */
        int i = strspn(line, " \t");

        /* handle comments: stored in header */
        if (NULL != strchr("#%;/", line[i]))
        { /* line is a comment */
          count_in_header += strlen(line);
          if (count_in_header >= malloc_size_h) {
            /* if succeed and in array : add (and realloc if necessary) */
            malloc_size_h = count_in_header+4096;
            Header        = (char*)realloc(Header, malloc_size_h*sizeof(char));
          }
          strncat(Header, line, 4096);
          flag_In_array=0;
          /* exit line and file if passed desired block */
          if (block_number > 0 && block_number == block_Current_index) {
            flag_End_row_loop = 1;
          }

          /* Continue with next line */
          continue;
        }

        /* get the number of columns splitting line with strtok */
        char  *lexeme;
        char  flag_End_Line = 0;
        long  block_Num_Columns = 0;
        const char seps[] = " ,;\t\n\r";

        lexeme = strtok(line, seps);
        while (!flag_End_Line) {
          if ((lexeme != NULL) && (lexeme[0] != '\0')) {
            /* reading line: the token is not empty */
            double X;
            int    count=1;
            /* test if we have 'NaN','Inf' */
            if (!strncasecmp(lexeme,"NaN",3))
              X = 0;
            else if (!strncasecmp(lexeme,"Inf",3) || !strncasecmp(lexeme,"+Inf",4))
              X = FLT_MAX;
            else if (!strncasecmp(lexeme,"-Inf",4))
              X = -FLT_MAX;
            else
              count = sscanf(lexeme,"%lg",&X);
            if (count == 1) {
              /* reading line: the token is a number in the line */
              if (!flag_In_array) {
                /* reading num: not already in a block: starts a new data block */
                block_Current_index++;
                flag_In_array    = 1;
                block_Num_Columns= 0;
                if (block_number > 0) {
                  /* initialise a new data block */
                  Rows = 0;
                  count_in_array = 0;
                } /* else append */
              }
              /* reading num: all blocks or selected block */
              if (flag_In_array && (block_number == 0 ||
                  block_number == block_Current_index)) {
                /* starting block: already the desired number of rows ? */
                if (block_Num_Columns == 0 &&
                    max_rows > 0 && Rows >= max_rows) {
                  flag_End_Line      = 1;
                  flag_End_row_loop  = 1;
                  flag_In_array      = 0;
                  /* reposition to begining of line (ignore line) */
                  fseek(hfile, back_pos, SEEK_SET);
                } else { /* store into data array */
                  if (count_in_array >= malloc_size) {
                    /* realloc data buffer if necessary */
                    malloc_size = count_in_array*1.5;
                    Data = (double*) realloc(Data, malloc_size*sizeof(double));
                    if (Data == NULL) {
                      fprintf(stderr, "Error: Can not re-allocate memory %li (Table_Read_Handle).\n",
                              malloc_size*sizeof(double));
                      return (-1);
                    }
                  }
                  if (0 == block_Num_Columns) Rows++;
                  Data[count_in_array] = X;
                  count_in_array++;
                  block_Num_Columns++;
                }
              } /* reading num: end if flag_In_array */
            } /* end reading num: end if sscanf lexeme -> numerical */
            else {
              /* reading line: the token is not numerical in that line. end block */
              if (block_Current_index == block_number) {
                flag_End_Line = 1;
                flag_End_row_loop = 1;
              } else {
                flag_In_array = 0;
                flag_End_Line = 1;
              }
            }
          }
          else {
            /* no more tokens in line */
            flag_End_Line = 1;
            if (block_Num_Columns > 0) Columns = block_Num_Columns;
          }

          // parse next token
          lexeme = strtok(NULL, seps);

        } /* while (!flag_End_Line) */
      } /* end: if fgets */
      else flag_End_row_loop = 1; /* else fgets : end of file */

    } while (!flag_End_row_loop); /* end while flag_End_row_loop */

    Table->block_number = block_number;
    Table->array_length = 1;

    // shrink header to actual size (plus terminating 0-byte)
    if (count_in_header) {
      Header = (char*)realloc(Header, count_in_header*sizeof(char) + 1);
    }
    Table->header = Header;

    if (count_in_array*Rows*Columns == 0)
    {
      Table->rows         = 0;
      Table->columns      = 0;
      free(Data);
      return (0);
    }
    if (Rows * Columns != count_in_array)
    {
      fprintf(stderr, "Warning: Read_Table :%s %s Data has %li values that should be %li x %li\n",
        (Table->filename[0] != '\0' ? Table->filename : ""),
        (!block_number ? " catenated" : ""),
        count_in_array, Rows, Columns);
      Columns = count_in_array; Rows = 1;
    }
    Data     = (double*)realloc(Data, count_in_array*sizeof(double));
    Table->data         = Data;
    Table->rows         = Rows;
    Table->columns      = Columns;

    return (count_in_array);

  } /* end Table_Read_Handle */

/*******************************************************************************
* long Table_Rebin(t_Table *Table)
*   ACTION: rebin a single Table, sorting 1st column in ascending order
*   input   Table: single table containing data.
*                  The data block is reallocated in this process
*   return  updated Table with increasing, evenly spaced first column (index 0)
*           number of data elements (-1: error, 0:empty data)
*******************************************************************************/
  long Table_Rebin(t_Table *Table)
  {
    double new_step=0;
    long   i;
    /* performs linear interpolation on X axis (0-th column) */

    if (!Table) return(-1);
    if (!Table->data 
    || Table->rows*Table->columns == 0 || !Table->step_x)
      return(0);
    Table_Stat(Table); /* recompute statitstics and minimal step */
    new_step = Table->step_x; /* minimal step in 1st column */

    if (!(Table->constantstep)) /* not already evenly spaced */
    {
      long Length_Table;
      double *New_Table;

      Length_Table = ceil(fabs(Table->max_x - Table->min_x)/new_step)+1;
      /*return early if the rebinned table will become too large*/
      if (Length_Table > mcread_table_rebin_maxsize){
        fprintf(stderr,"WARNING: (Table_Rebin): Rebinning table from %s would exceed 1M rows. Skipping.\n", Table->filename); 
        return(Table->rows*Table->columns);
      }
      New_Table    = (double*)malloc(Length_Table*Table->columns*sizeof(double));

      for (i=0; i < Length_Table; i++)
      {
        long   j;
        double X;
        X = Table->min_x + i*new_step;
        New_Table[i*Table->columns] = X;
        for (j=1; j < Table->columns; j++)
          New_Table[i*Table->columns+j]
                = Table_Value(*Table, X, j);
      } /* end for i */

      Table->rows = Length_Table;
      Table->step_x = new_step;
      Table->max_x = Table->min_x + (Length_Table-1)*new_step; 
      /*max might not be the same anymore
       * Use Length_Table -1 since the first and laset rows are the limits of the defined interval.*/
      free(Table->data);
      Table->data = New_Table;
      Table->constantstep=1;
    } /* end else (!constantstep) */
    return (Table->rows*Table->columns);
  } /* end Table_Rebin */

/*******************************************************************************
* double Table_Index(t_Table Table, long i, long j)
*   ACTION: read an element [i,j] of a single Table
*   input   Table: table containing data
*           i : index of row      (0:Rows-1)
*           j : index of column   (0:Columns-1)
*   return  Value = data[i][j]
* Returns Value from the i-th row, j-th column of Table
* Tests are performed on indexes i,j to avoid errors
*******************************************************************************/

#ifndef MIN
#define MIN(a, b)  (((a) < (b)) ? (a) : (b))
#endif
#ifndef MAX
#define MAX(a, b)  (((a) > (b)) ? (a) : (b))
#endif

double Table_Index(t_Table Table, long i, long j)
{
  long AbsIndex;

  if (Table.rows == 1 || Table.columns == 1) {
    /* vector */
    j = MIN(MAX(0, i+j), Table.columns*Table.rows - 1);
    i = 0;
  } else {
    /* matrix */
    i = MIN(MAX(0, i), Table.rows - 1);
    j = MIN(MAX(0, j), Table.columns - 1);
  }

  /* handle vectors specifically */
  AbsIndex = i*(Table.columns)+j;

  if (Table.data != NULL)
    return (Table.data[AbsIndex]);
  else
    return 0;
} /* end Table_Index */

/*******************************************************************************
* void Table_SetElement(t_Table *Table, long i, long j, double value)
*   ACTION: set an element [i,j] of a single Table
*   input   Table: table containing data
*           i : index of row      (0:Rows-1)
*           j : index of column   (0:Columns-1)
*           value = data[i][j]
* Returns 0 in case of error
* Tests are performed on indexes i,j to avoid errors
*******************************************************************************/
int Table_SetElement(t_Table *Table, long i, long j,
                     double value)
{
  long AbsIndex;

  if (Table->rows == 1 || Table->columns == 1) {
    /* vector */
    j = MIN(MAX(0, i+j), Table->columns*Table->rows - 1); i=0;
  } else {
    /* matrix */
    i = MIN(MAX(0, i), Table->rows - 1);
    j = MIN(MAX(0, j), Table->columns - 1);
  }

  AbsIndex = i*(Table->columns)+j;
  if (Table->data != NULL) {
    Table->data[AbsIndex] = value;
    return 1;
  }

  return 0;
} /* end Table_SetElement */

/*******************************************************************************
* double Table_Value(t_Table Table, double X, long j)
*   ACTION: read column [j] of a single Table at row which 1st column is X
*   input   Table: table containing data.
*           X : data value in the first column (index 0)
*           j : index of column from which is extracted the Value (0:Columns-1)
*   return  Value = data[index for X][j] with linear interpolation
* Returns Value from the j-th column of Table corresponding to the
* X value for the 1st column (index 0)
* Tests are performed (within Table_Index) on indexes i,j to avoid errors
* NOTE: data should rather be monotonic, and evenly sampled.
*******************************************************************************/
double Table_Value(t_Table Table, double X, long j)
{
  long   Index = -1;
  double X1=0, Y1=0, X2=0, Y2=0;
  double ret=0;

  if (X > Table.max_x) return Table_Index(Table,Table.rows-1  ,j);
  if (X < Table.min_x) return Table_Index(Table,0  ,j);

  // Use constant-time lookup when possible
  if(Table.constantstep) {
    Index = (long)floor(
              (X - Table.min_x) / (Table.max_x - Table.min_x) * (Table.rows-1));
    X1 = Table_Index(Table,Index  ,0);
    X2 = Table_Index(Table,Index+1,0);
  }
  // Use binary search on large, monotonic tables
  else if(Table.monotonic && Table.rows > 100) {
    long left = Table.min_x;
    long right = Table.max_x;

    while (!((X1 <= X) && (X < X2)) && (right - left > 1)) {
      Index = (left + right) / 2;

      X1 = Table_Index(Table, Index-1, 0);
      X2 = Table_Index(Table, Index,   0);

      if (X < X1) {
        right = Index;
      } else {
        left  = Index;
      }
    }
  }

  // Fall back to linear search, if no-one else has set X1, X2 correctly
  if (!((X1 <= X) && (X < X2))) {
    /* look for index surrounding X in the table -> Index */
    for (Index=1; Index <= Table.rows-1; Index++) {
        X1 = Table_Index(Table, Index-1,0);
        X2 = Table_Index(Table, Index  ,0);
        if ((X1 <= X) && (X < X2)) break;
      } /* end for Index */
  }

  Y1 = Table_Index(Table,Index, j);
  Y2 = Table_Index(Table,Index+1, j);

  if (!strcmp(Table.method,"linear")) {
    ret = Table_Interp1d(X, X1,Y1, X2,Y2);
  }
  else if (!strcmp(Table.method,"nearest")) {
    ret = Table_Interp1d_nearest(X, X1,Y1, X2,Y2);
  }

  return ret;
} /* end Table_Value */

/*******************************************************************************
* double Table_Value2d(t_Table Table, double X, double Y)
*   ACTION: read element [X,Y] of a matrix Table
*   input   Table: table containing data.
*           X : row index, may be non integer
*           Y : column index, may be non integer
*   return  Value = data[index X][index Y] with bi-linear interpolation
* Returns Value for the indices [X,Y]
* Tests are performed (within Table_Index) on indexes i,j to avoid errors
* NOTE: data should rather be monotonic, and evenly sampled.
*******************************************************************************/
  double Table_Value2d(t_Table Table, double X, double Y)
  {
    long   x1,x2,y1,y2;
    double z11,z12,z21,z22;
    double ret=0;

    x1 = (long)floor(X);
    y1 = (long)floor(Y);

    if (x1 > Table.rows-1 || x1 < 0) {
      x2 = x1;
    } else {
      x2 = x1 + 1;
    }

    if (y1 > Table.columns-1 || y1 < 0) {
      y2 = y1;
    } else {
      y2 = y1 + 1;
    }

    z11 = Table_Index(Table, x1, y1);

    if (y2 != y1) z12=Table_Index(Table, x1, y2); else z12 = z11;
    if (x2 != x1) z21=Table_Index(Table, x2, y1); else z21 = z11;
    if (y2 != y1) z22=Table_Index(Table, x2, y2); else z22 = z21;

    if (!strcmp(Table.method,"linear"))
      ret = Table_Interp2d(X,Y, x1,y1,x2,y2, z11,z12,z21,z22);
    else {
      if (fabs(X-x1) < fabs(X-x2)) {
        if (fabs(Y-y1) < fabs(Y-y2)) ret = z11; else ret = z12;
      } else {
        if (fabs(Y-y1) < fabs(Y-y2)) ret = z21; else ret = z22;
      }
    }
    return ret;
  } /* end Table_Value2d */


/*******************************************************************************
* void Table_Free(t_Table *Table)
*   ACTION: free a single Table. First Call Table_File_list_gc. If this returns
*   non-zero it means there are more refernces to the table, and so the table
*   should not bee freed.
*   return: empty Table
*******************************************************************************/
  void Table_Free(t_Table *Table)
  {
    if( !Table_File_List_gc(Table) ){
       return;
    } 
    if (!Table) return;
    if (Table->data   != NULL) free(Table->data);
    if (Table->header != NULL) free(Table->header);
    Table->data   = NULL;
    Table->header = NULL;
  } /* end Table_Free */

/******************************************************************************
* void Table_Info(t_Table Table)
*    ACTION: print informations about a single Table
*******************************************************************************/
  long Table_Info(t_Table Table)
  {
    char buffer[256];
    long ret=0;

    if (!Table.block_number) strcpy(buffer, "catenated");
    else sprintf(buffer, "block %li", Table.block_number);
    printf("Table from file '%s' (%s)",
      Table.filename[0] != '\0' ? Table.filename : "", buffer);
    if ((Table.data != NULL) && (Table.rows*Table.columns))
    {
      printf(" is %li x %li ", Table.rows, Table.columns);
      if (Table.rows*Table.columns > 1)
        printf("(x=%g:%g)", Table.min_x, Table.max_x);
      else printf("(x=%g) ", Table.min_x);
      ret = Table.rows*Table.columns;
      if (Table.monotonic)    printf(", monotonic");
      if (Table.constantstep) printf(", constant step");
      printf(". interpolation: %s\n", Table.method);
    }
    else printf(" is empty.\n");

    if (Table.header && strlen(Table.header)) {
      char *header;
      int  i;
      header = malloc(80);
      if (!header) return(ret);
      for (i=0; i<80; header[i++]=0);
      strncpy(header, Table.header, 75);
      if (strlen(Table.header) > 75) {
        strcat( header, " ...");
      }
      for (i=0; i<strlen(header); i++)
        if (header[i] == '\n' || header[i] == '\r') header[i] = ';';
      printf("  '%s'\n", header);
      free(header);
    }

    return(ret);
  } /* end Table_Info */

/******************************************************************************
* long Table_Init(t_Table *Table, m, n)
*   ACTION: initialise a Table to empty m by n table
*   return: empty Table
******************************************************************************/
long Table_Init(t_Table *Table, long rows, long columns)
{
  double *data=NULL;
  long   i;

  if (!Table) return(0);

  Table->header  = NULL;
  Table->filename[0]= '\0';
  Table->filesize= 0;
  Table->min_x   = 0;
  Table->max_x   = 0;
  Table->step_x  = 0;
  Table->block_number = 0;
  Table->array_length = 0;
  Table->monotonic    = 0;
  Table->constantstep = 0;
  Table->begin   = 0;
  Table->end     = 0;
  strcpy(Table->method,"linear");

  if (rows*columns >= 1) {
    data    = (double*)malloc(rows*columns*sizeof(double));
    if (data) for (i=0; i < rows*columns; data[i++]=0);
    else {
      fprintf(stderr,"Error: allocating %ld double elements."
                     "Too big (Table_Init).\n", rows*columns);
      rows = columns = 0;
    }
  }
  Table->rows    = (rows >= 1 ? rows : 0);
  Table->columns = (columns >= 1 ? columns : 0);
  Table->data    = data;
  return(Table->rows*Table->columns);
} /* end Table_Init */

/******************************************************************************
* long Table_Write(t_Table Table, char *file, x1,x2, y1,y2)
*   ACTION: write a Table to disk (ascii).
*     when x1=x2=0 or y1=y2=0, the table default limits are used.
*   return: 0=all is fine, non-0: error
*******************************************************************************/
MCDETECTOR Table_Write(t_Table Table, char *file, char *xl, char *yl, 
  double x1, double x2, double y1, double y2)
{
  long    i =0;
  MCDETECTOR detector;

  if ((Table.data == NULL) && (Table.rows*Table.columns)) {
    detector.m = 0;
    return(detector); /* Table is empty - nothing to do */
  }
  if (!x1 && !x2) {
    x1 = Table.min_x;
    x2 = Table.max_x;
  }
  if (!y1 && !y2) {
    y1 = 1;
    y2 = Table.columns;
  }

  /* transfer content of the Table into a 2D detector */
  Coords coords = { 0, 0, 0};

  if (Table.rows == 1 || Table.columns == 1) {
    detector = mcdetector_out_1D(Table.filename,
                      xl ? xl : "", yl ? yl : "",
                      "x", x1, x2,
                      Table.rows * Table.columns,
                      NULL, Table.data, NULL,
                      file, file, coords);
  } else {
    detector = mcdetector_out_2D(Table.filename,
                      xl ? xl : "", yl ? yl : "",
                      x1, x2, y1, y2,
                      Table.rows, Table.columns,
                      NULL, Table.data, NULL,
                      file, file, coords);
  }
  return(detector);
}

/******************************************************************************
* void Table_Stat(t_Table *Table)
*   ACTION: computes min/max/mean step of 1st column for a single table (private)
*   return: updated Table
*******************************************************************************/
  static void Table_Stat(t_Table *Table)
  {
    long   i;
    double max_x, min_x;
    double row=1;
    char   monotonic=1;
    char   constantstep=1;
    double step=0;
    long n;

    if (!Table) return;
    if (!Table->rows || !Table->columns) return;
    if (Table->rows == 1) row=0; // single row
    max_x = -FLT_MAX;
    min_x =  FLT_MAX;
    n     = (row ? Table->rows : Table->columns);
    /* get min and max of first column/vector */
    for (i=0; i < n; i++)
    {
      double X;
      X = (row ? Table_Index(*Table,i  ,0)
                               : Table_Index(*Table,0, i));
      if (X < min_x) min_x = X;
      if (X > max_x) max_x = X;
    } /* for */
    
    /* test for monotonicity and constant step if the table is an XY or single vector */
    if (n > 1) {
      /* mean step */
      step = (max_x - min_x)/(n-1);
      /* now test if table is monotonic on first column, and get minimal step size */
      for (i=0; i < n-1; i++) {
        double X, diff;;
        X    = (row ? Table_Index(*Table,i  ,0)
                    : Table_Index(*Table,0,  i));
        diff = (row ? Table_Index(*Table,i+1,0)
                    : Table_Index(*Table,0,  i+1)) - X;
        if (diff && fabs(diff) < fabs(step)) step = diff;
        /* change sign ? */
        if ((max_x - min_x)*diff < 0 && monotonic)
          monotonic = 0;
      } /* end for */
      
      /* now test if steps are constant within READ_TABLE_STEPTOL */
      if(!step){
        /*means there's a disconitnuity -> not constantstep*/
        constantstep=0;
      }else if (monotonic) {
        for (i=0; i < n-1; i++) {
          double X, diff;
          X    = (row ? Table_Index(*Table,i  ,0)
              : Table_Index(*Table,0,  i));
          diff = (row ? Table_Index(*Table,i+1,0)
              : Table_Index(*Table,0,  i+1)) - X;
          if ( fabs(step)*(1+READ_TABLE_STEPTOL) < fabs(diff) ||
                fabs(diff) < fabs(step)*(1-READ_TABLE_STEPTOL) )
          { constantstep = 0; break; }
        }
      }

    }
    Table->step_x= step;
    Table->max_x = max_x;
    Table->min_x = min_x;
    Table->monotonic = monotonic;
    Table->constantstep = constantstep;
  } /* end Table_Stat */

/******************************************************************************
* t_Table *Table_Read_Array(char *File, long *blocks)
*   ACTION: read as many data blocks as available, iteratively from file
*   return: initialized t_Table array, last element is an empty Table.
*           the number of extracted blocks in non NULL pointer *blocks
*******************************************************************************/
  t_Table *Table_Read_Array(char *File, long *blocks)
  {
    t_Table *Table_Array=NULL;
    long offset=0;
    long block_number=0;
    long allocated=256;
    long nelements=1;

    /* first allocate an initial empty t_Table array */
    Table_Array = (t_Table *)malloc(allocated*sizeof(t_Table));
    if (!Table_Array) {
      fprintf(stderr, "Error: Can not allocate memory %li (Table_Read_Array).\n",
         allocated*sizeof(t_Table));
      *blocks = 0;
      return (NULL);
    }

    while (nelements > 0)
    {
      t_Table Table;

      /* if ok, set t_Table block number else exit loop */
      block_number++;
      Table.block_number = block_number;
      
      /* access file at offset and get following block. Block number is from the set offset
       * hence the hardcoded 1 - i.e. the next block counted from offset.*/
      nelements = Table_Read_Offset(&Table, File, 1, &offset,0);
      /*if the block is empty - don't store it*/
      if (nelements>0){
          /* if t_Table array is not long enough, expand and realocate */
          if (block_number >= allocated-1) {
              allocated += 256;
              Table_Array = (t_Table *)realloc(Table_Array,
                      allocated*sizeof(t_Table));
              if (!Table_Array) {
                  fprintf(stderr, "Error: Can not re-allocate memory %li (Table_Read_Array).\n",
                          allocated*sizeof(t_Table));
                  *blocks = 0;
                  return (NULL);
              }
          }
          /* store it into t_Table array */
          //snprintf(Table.filename, 1024, "%s#%li", File, block_number-1);
          Table_Array[block_number-1] = Table;
      }
      /* continues until we find an empty block */
    }
    /* send back number of extracted blocks */
    if (blocks) *blocks = block_number-1;

    /* now store total number of elements in Table array */
    for (offset=0; offset < block_number;
      Table_Array[offset++].array_length = block_number-1);

    return(Table_Array);
  } /* end Table_Read_Array */
/*******************************************************************************
* void Table_Free_Array(t_Table *Table)
*   ACTION: free a Table array
*******************************************************************************/
  void Table_Free_Array(t_Table *Table)
  {
    long index;
    if (!Table) return;
    for (index=0;index < Table[0].array_length; index++){
            Table_Free(&Table[index]);
    }
    free(Table);
  } /* end Table_Free_Array */

/******************************************************************************
* long Table_Info_Array(t_Table *Table)
*    ACTION: print informations about a Table array
*    return: number of elements in the Table array
*******************************************************************************/
  long Table_Info_Array(t_Table *Table)
  {
    long index=0;

    if (!Table) return(-1);
    while (index < Table[index].array_length
       && (Table[index].data || Table[index].header)
       && (Table[index].rows*Table[index].columns) ) {
      Table_Info(Table[index]);
      index++;
    }
    printf("This Table array contains %li elements\n", index);
    return(index);
  } /* end Table_Info_Array */

/******************************************************************************
* char **Table_ParseHeader(char *header, symbol1, symbol2, ..., NULL)
*    ACTION: search for char* symbols in header and return their value or NULL
*            the search is not case sensitive.
*            Last argument MUST be NULL
*    return: array of char* with line following each symbol, or NULL if not found
*******************************************************************************/
#ifndef MyNL_ARGMAX
#define MyNL_ARGMAX 50
#endif

char **Table_ParseHeader_backend(char *header, ...){
  va_list ap;
  char exit_flag=0;
  int counter   =0;
  char **ret    =NULL;
  if (!header || header[0]=='\0') return(NULL);

  ret = (char**)calloc(MyNL_ARGMAX, sizeof(char*));
  if (!ret) {
    printf("Table_ParseHeader: Cannot allocate %i values array for Parser (Table_ParseHeader).\n",
      MyNL_ARGMAX);
    return(NULL);
  }
  for (counter=0; counter < MyNL_ARGMAX; ret[counter++] = NULL);
  counter=0;

  va_start(ap, header);
  while(!exit_flag && counter < MyNL_ARGMAX-1)
  {
    char *arg_char=NULL;
    char *pos     =NULL;
    /* get variable argument value as a char */
    arg_char = va_arg(ap, char *);
    if (!arg_char || arg_char[0]=='\0'){
      exit_flag = 1; break;
    }
    /* search for the symbol in the header */
    pos = (char*)strcasestr(header, arg_char);
    if (pos) {
      char *eol_pos;
      eol_pos = strchr(pos+strlen(arg_char), '\n');
      if (!eol_pos)
        eol_pos = strchr(pos+strlen(arg_char), '\r');
      if (!eol_pos)
        eol_pos = pos+strlen(pos)-1;
      ret[counter] = (char*)malloc(eol_pos - pos);
      if (!ret[counter]) {
        printf("Table_ParseHeader: Cannot allocate value[%i] array for Parser searching for %s (Table_ParseHeader).\n",
          counter, arg_char);
        exit_flag = 1; break;
      }
      strncpy(ret[counter], pos+strlen(arg_char), eol_pos - pos - strlen(arg_char));
      ret[counter][eol_pos - pos - strlen(arg_char)]='\0';
    }
    counter++;
  }
  va_end(ap);
  return(ret);
} /* Table_ParseHeader */

/******************************************************************************
* double Table_Interp1d(x, x1, y1, x2, y2)
*    ACTION: interpolates linearly at x between y1=f(x1) and y2=f(x2)
*    return: y=f(x) value
*******************************************************************************/
double Table_Interp1d(double x,
  double x1, double y1,
  double x2, double y2)
{
  double slope;
  if (x2 == x1) return (y1+y2)/2;
  if (y1 == y2) return  y1;
  slope = (y2 - y1)/(x2 - x1);
  return y1+slope*(x - x1);
} /* Table_Interp1d */

/******************************************************************************
* double Table_Interp1d_nearest(x, x1, y1, x2, y2)
*    ACTION: table lookup with nearest method at x between y1=f(x1) and y2=f(x2)
*    return: y=f(x) value
*******************************************************************************/
double Table_Interp1d_nearest(double x,
  double x1, double y1,
  double x2, double y2)
{
  if (fabs(x-x1) < fabs(x-x2)) return (y1);
  else return(y2);
} /* Table_Interp1d_nearest */

/******************************************************************************
* double Table_Interp2d(x,y, x1,y1, x2,y2, z11,z12,z21,z22)
*    ACTION: interpolates bi-linearly at (x,y) between z1=f(x1,y1) and z2=f(x2,y2)
*    return: z=f(x,y) value
*    x,y |   x1   x2
*    ----------------
*     y1 |   z11  z21
*     y2 |   z12  z22
*******************************************************************************/
double Table_Interp2d(double x, double y,
  double x1, double y1,
  double x2, double y2,
  double z11, double z12, double z21, double z22)
{
  double ratio_x, ratio_y;
  if (x2 == x1) return Table_Interp1d(y, y1,z11, y2,z12);
  if (y1 == y2) return Table_Interp1d(x, x1,z11, x2,z21);

  ratio_y = (y - y1)/(y2 - y1);
  ratio_x = (x - x1)/(x2 - x1);
  return (1-ratio_x)*(1-ratio_y)*z11 + ratio_x*(1-ratio_y)*z21
    + ratio_x*ratio_y*z22         + (1-ratio_x)*ratio_y*z12;
} /* Table_Interp2d */

/* end of read_table-lib.c */

/*******************************************************************************
*
* McStas, neutron ray-tracing package
*         Copyright (C) 1997-2008, All rights reserved
*         Risoe National Laboratory, Roskilde, Denmark
*         Institut Laue Langevin, Grenoble, France
*
* Runtime: share/interoff.h
*
* %Identification
* Written by: Reynald Arnerin
* Date:    Jun 12, 2008
* Release: 
* Version: 
*
* Object File Format intersection header for McStas. Requires the qsort function.
*
* Such files may be obtained with e.g.
*   qhull < points.xyz Qx Qv Tv o > points.off
* where points.xyz has format:
*   3
*   <nb_points>
*   <x> <y> <z>
*   ...
* The resulting file should have its first line being changed from '3' into 'OFF'.
* It can then be displayed with geomview.
* A similar, but somewhat older solution is to use 'powercrust' with e.g.
*   powercrust -i points.xyz
* which will generate a 'pc.off' file to be renamed as suited.
*
*******************************************************************************/

#ifndef INTEROFF_LIB_H
#define INTEROFF_LIB_H "$Revision$"

#ifndef OFF_EPSILON
#define OFF_EPSILON 1e-13
#endif

#define OFF_INTERSECT_MAX 100

//#include <float.h>

#define N_VERTEX_DISPLAYED    200000

typedef struct intersection {
	MCNUM time;  	  //time of the intersection
	Coords v;	      //intersection point
	Coords normal;  //normal vector of the surface intersected
	short in_out;	  //1 if the ray enters the volume, -1 otherwise
	short edge;	    //1 if the intersection is on the boundary of the polygon, and error is possible
	unsigned long index; // index of the face
} intersection;

typedef struct polygon {
  MCNUM* p;       //vertices of the polygon in adjacent order, this way : x1 | y1 | z1 | x2 | y2 | z2 ...
  int npol;       //number of vertices
  Coords normal;
} polygon;

typedef struct off_struct {
    long vtxSize;
    long polySize;
    long faceSize;
    Coords* vtxArray;
    Coords* normalArray;
    unsigned long* faceArray;
    char *filename;
    int mantidflag;
    long mantidoffset;
    intersection intersects[OFF_INTERSECT_MAX]; // After a call to off_intersect_all contains the list of intersections.
    int nextintersect;                 // 'Next' intersection (first t>0) solution after call to off_intersect_all
    int numintersect;               // Number of intersections after call to off_intersect_all
} off_struct;

/*******************************************************************************
* long off_init(  char *offfile, double xwidth, double yheight, double zdepth, off_struct* data)
* ACTION: read an OFF file, optionally center object and rescale, initialize OFF data structure
* INPUT: 'offfile' OFF file to read
*        'xwidth,yheight,zdepth' if given as non-zero, apply bounding box. 
*           Specifying only one of these will also use the same ratio on all axes
*        'notcenter' center the object to the (0,0,0) position in local frame when set to zero
* RETURN: number of polyhedra and 'data' OFF structure 
*******************************************************************************/
long off_init(  char *offfile, double xwidth, double yheight, double zdepth, 
                int notcenter, off_struct* data);

/*******************************************************************************
* int off_intersect_all(double* t0, double* t3, 
     Coords *n0, Coords *n3,
     double x, double y, double z, 
     double vx, double vy, double vz, 
     off_struct *data )
* ACTION: computes intersection of neutron trajectory with an object. 
* INPUT:  x,y,z and vx,vy,vz are the position and velocity of the neutron
*         data points to the OFF data structure
* RETURN: the number of polyhedra which trajectory intersects
*         t0 and t3 are the smallest incoming and outgoing intersection times
*         n0 and n3 are the corresponding normal vectors to the surface
*         data is the full OFF structure, including a list intersection type
*******************************************************************************/
int off_intersect_all(double* t0, double* t3, 
     Coords *n0, Coords *n3,
     double x, double y, double z, 
     double vx, double vy, double vz, 
     off_struct *data );

/*******************************************************************************
* int off_intersect(double* t0, double* t3, 
     Coords *n0, Coords *n3,
     double x, double y, double z, 
     double vx, double vy, double vz, 
     off_struct data )
* ACTION: computes intersection of neutron trajectory with an object. 
* INPUT:  x,y,z and vx,vy,vz are the position and velocity of the neutron
*         data points to the OFF data structure
* RETURN: the number of polyhedra which trajectory intersects
*         t0 and t3 are the smallest incoming and outgoing intersection times
*         n0 and n3 are the corresponding normal vectors to the surface
*******************************************************************************/
int off_intersect(double* t0, double* t3, 
     Coords *n0, Coords *n3,
     double x, double y, double z, 
     double vx, double vy, double vz, 
     off_struct data );

/*****************************************************************************
* int off_intersectx(double* l0, double* l3, 
     Coords *n0, Coords *n3,
     double x, double y, double z, 
     double kx, double ky, double kz, 
     off_struct data )
* ACTION: computes intersection of an xray trajectory with an object.
* INPUT:  x,y,z and kx,ky,kz, are spatial coordinates and wavevector of the x-ray
*         respectively. data points to the OFF data structure.
* RETURN: the number of polyhedra the trajectory intersects
*         l0 and l3 are the smallest incoming and outgoing intersection lengths
*         n0 and n3 are the corresponding normal vectors to the surface
*******************************************************************************/
int off_x_intersect(double *l0,double *l3,
     Coords *n0, Coords *n3,
     double x,  double y,  double z, 
     double kx, double ky, double kz, 
     off_struct data );

/*******************************************************************************
* void off_display(off_struct data)
* ACTION: display up to N_VERTEX_DISPLAYED points from the object
*******************************************************************************/
void off_display(off_struct);

#endif

/* end of interoff-lib.h */
/*******************************************************************************
*
* McStas, neutron ray-tracing package
*         Copyright (C) 1997-2008, All rights reserved
*         Risoe National Laboratory, Roskilde, Denmark
*         Institut Laue Langevin, Grenoble, France
*
* Runtime: share/interoff-lib.c
*
* %Identification
* Written by: Reynald Arnerin
* Date:    Jun 12, 2008
* Origin: ILL
* Release: $Revision$
* Version: McStas X.Y
*
* Object File Format intersection library for McStas. Requires the qsort function.
*
* Such files may be obtained with e.g.
*   qhull < points.xyz Qx Qv Tv o > points.off
* where points.xyz has format (it supports comments):
*   3
*   <nb_points>
*   <x> <y> <z>
*   ...
* The resulting file should have its first line being changed from '3' into 'OFF'.
* It can then be displayed with geomview.
* A similar, but somewhat older solution is to use 'powercrust' with e.g.
*   powercrust -i points.xyz
* which will generate a 'pc.off' file to be renamed as suited.
*
*******************************************************************************/

#ifndef INTEROFF_LIB_H
#include "interoff-lib.h"
#endif

double off_F(double x, double y,double z,double A,double B,double C,double D) {
  return ( A*x + B*y + C*z + D );
}

char off_sign(double a) {
  if (a<0)       return(-1);
  else if (a==0) return(0);
  else           return(1);
}

// off_normal ******************************************************************
//gives the normal vector of p
void off_normal(Coords* n, polygon p)
{
  //using Newell method
  int i=0,j=0;
  n->x=0;n->y=0;n->z=0;
  for (i = 0, j = p.npol-1; i < p.npol; j = i++)
  {
    MCNUM x1=p.p[3*i],
          y1=p.p[3*i+1],
          z1=p.p[3*i+2];
    MCNUM x2=p.p[3*j],
          y2=p.p[3*j+1],
          z2=p.p[3*j+2];
    // n is the cross product of v1*v2
    n->x += (y1 - y2) * (z1 + z2);
    n->y += (z1 - z2) * (x1 + x2);
    n->z += (x1 - x2) * (y1 + y2);
  }
} /* off_normal */

// off_pnpoly ******************************************************************
//based on http://www.ecse.rpi.edu/Homepages/wrf/Research/Short_Notes/pnpoly.html
//return 0 if the vertex is out
//    1 if it is in
//   -1 if on the boundary
int off_pnpoly(polygon p, Coords v)
{
  int i=0, c = 0;
  MCNUM minx=FLT_MAX,maxx=-FLT_MAX,miny=FLT_MAX,maxy=-FLT_MAX,minz=FLT_MAX,maxz=-FLT_MAX;
  MCNUM rangex=0,rangey=0,rangez=0;

  int pol2dx=0,pol2dy=1;          //2d restriction of the poly
  MCNUM x=v.x,y=v.y;


  //take the most relevant 2D projection (prevent from instability)
  for (i=0; i<p.npol; ++i)
  {
    if (p.p[3*i]<minx)   minx=p.p[3*i];
    if (p.p[3*i]>maxx)   maxx=p.p[3*i];
    if (p.p[3*i+1]<miny) miny=p.p[3*i+1];
    if (p.p[3*i+1]>maxy) maxy=p.p[3*i+1];
    if (p.p[3*i+2]<minz) minz=p.p[3*i+2];
    if (p.p[3*i+2]>maxz) maxz=p.p[3*i+2];
  }
  rangex=maxx-minx;
  rangey=maxy-miny;
  rangez=maxz-minz;

  if (rangex<rangez)
  {
    if (rangex<rangey) {
      pol2dx=2;
      x=v.z;
    } else {
      pol2dy=2;
      y=v.z;
    }
  }
  else if (rangey<rangez) {
    pol2dy=2;
    y=v.z;
  }

  //trace rays and test number of intersection
  int j;
  for (i = 0, j = p.npol-1; i < p.npol; j = i++) {
    if (((((p.p[3*i+pol2dy])<=y) && (y<(p.p[3*j+pol2dy]))) ||
         (((p.p[3*j+pol2dy])<=y) && (y<(p.p[3*i+pol2dy])))) &&
        (x < ( (p.p[3*j+pol2dx] - p.p[3*i+pol2dx]) * (y - p.p[3*i+pol2dy])
             / (p.p[3*j+pol2dy] - p.p[3*i+pol2dy]) + p.p[3*i+pol2dx]) ))
      c = !c;

    if (((fabs(p.p[3*i+pol2dy]-y)<=OFF_EPSILON) || ((fabs(p.p[3*j+pol2dy]-y)<=OFF_EPSILON))) &&
        fabs(x -((p.p[3*j+pol2dx] - p.p[3*i+pol2dx]) * (y - p.p[3*i+pol2dy])
          / (p.p[3*j+pol2dy] - p.p[3*i+pol2dy]) + p.p[3*i+pol2dx])) < OFF_EPSILON)
    {
      //the point lies on the edge
      c=-1;
      break;
    }
  }

  return c;
} /* off_pnpoly */

// off_intersectPoly ***********************************************************
//gives the intersection vertex between ray [a,b) and polygon p and its parametric value on (a b)
//based on http://geometryalgorithms.com/Archive/algorithm_0105/algorithm_0105.htm
int off_intersectPoly(intersection *inter, Coords a, Coords b, polygon p)
{
  //direction vector of [a,b]
  Coords dir = {b.x-a.x, b.y-a.y, b.z-a.z};

  //the normal vector to the polygon
  Coords normale=p.normal;
  //off_normal(&normale, p); done at the init stage

  //direction vector from a to a vertex of the polygon
  Coords w0 = {a.x-p.p[0], a.y-p.p[1], a.z-p.p[2]};

  //scalar product
  MCNUM nw0  =-scalar_prod(normale.x,normale.y,normale.z,w0.x,w0.y,w0.z);
  MCNUM ndir = scalar_prod(normale.x,normale.y,normale.z,dir.x,dir.y,dir.z);
  inter->time = inter->edge = inter->in_out=0;
  inter->v = inter->normal = coords_set(0,0,1);

  if (fabs(ndir) < OFF_EPSILON)    // ray is parallel to polygon plane
  {
    if (nw0 == 0)              // ray lies in polygon plane (infinite number of solution)
      return 0;
    else return 0;             // ray disjoint from plane (no solution)
  }

  // get intersect point of ray with polygon plane
  inter->time = nw0 / ndir;            //parametric value the point on line (a,b)

  inter->v = coords_set(a.x + inter->time * dir.x,// intersect point of ray and plane
    a.y + inter->time * dir.y,
    a.z + inter->time * dir.z);

  int res=off_pnpoly(p,inter->v);

  inter->edge=(res==-1);
  if (ndir<0)
    inter->in_out=1;  //the negative dot product means we enter the surface
  else
    inter->in_out=-1;

  inter->normal=p.normal;

  return res;         //true if the intersection point lies inside the poly
} /* off_intersectPoly */


// off_getBlocksIndex **********************************************************
/*reads the indexes at the beginning of the off file as this :
line 1  OFF
line 2  nbVertex nbFaces nbEdges
*/
FILE *off_getBlocksIndex(char* filename, long* vtxSize, long* polySize )
{
  FILE* f = Open_File(filename,"r", NULL); /* from read_table-lib: FILE *Open_File(char *name, char *Mode, char *path) */
  if (!f) return (f);
  
  char line[CHAR_BUF_LENGTH];
  char *ret=0;
  *vtxSize = *polySize = 0;

  /* **************** start to read the file header */
  /* OFF file:
     'OFF' or '3'
   */

  ret=fgets(line,CHAR_BUF_LENGTH , f);// line 1 = "OFF"
  if (ret == NULL)
  {
    fprintf(stderr, "Error: Can not read 1st line in file %s (interoff/off_getBlocksIndex)\n", filename);
    exit(1);
  }
  if (strlen(line)>5)
  {
      fprintf(stderr,"Error: First line in %s is too long (=%lu). Possibly the line is not terminated by '\\n'.\n" 
              "       The first line is required to be exactly 'OFF', '3' or 'ply'.\n",filename,strlen(line));
      fclose(f);
      return(NULL);
  }

  if (strncmp(line,"OFF",3) && strncmp(line,"3",1) && strncmp(line,"ply",1))
  {
    fprintf(stderr, "Error: %s is probably not an OFF, NOFF or PLY file (interoff/off_getBlocksIndex).\n"
                    "       Requires first line to be 'OFF', '3' or 'ply'.\n",filename);
    fclose(f);
    return(NULL);
  }

  if (!strncmp(line,"OFF",3) || !strncmp(line,"3",1)) {
    do  /* OFF file: skip # comments which may be there */
    {
      ret=fgets(line,CHAR_BUF_LENGTH , f);
      if (ret == NULL)
      {
        fprintf(stderr, "Error: Can not read line in file %s (interoff/off_getBlocksIndex)\n", filename);
        exit(1);
      }
    } while (line[0]=='#');
    //line = nblines of vertex,faces and edges arrays
    sscanf(line,"%lu %lu",vtxSize,polySize);
  } else {
    do  /* PLY file: read all lines until find 'end_header'
           and locate 'element faces' and 'element vertex' */
    {
      ret=fgets(line,CHAR_BUF_LENGTH , f);
      if (ret == NULL)
      {
        fprintf(stderr, "Error: Can not read line in file %s (interoff/off_getBlocksIndex)\n", filename);
        exit(1);
      }
      if (!strncmp(line,"element face",12))
        sscanf(line,"element face %lu",polySize);
      else if (!strncmp(line,"element vertex",14))
        sscanf(line,"element vertex %lu",vtxSize);
      else if (!strncmp(line,"format binary",13))
        exit(fprintf(stderr,
          "Error: Can not read binary PLY file %s, only 'format ascii' (interoff/off_getBlocksIndex)\n%s\n",
          filename, line));
    } while (strncmp(line,"end_header",10));
  }
  
  /* The FILE is left opened ready to read 'vtxSize' vertices (vtxSize *3 numbers)
     and then polySize polygons (rows) */

  return(f);
} /* off_getBlocksIndex */

// off_init_planes *************************************************************
//gives the equations of 2 perpandicular planes of [ab]
void off_init_planes(Coords a, Coords b,
  MCNUM* A1, MCNUM* C1, MCNUM* D1, MCNUM *A2, MCNUM* B2, MCNUM* C2, MCNUM* D2)
{
  //direction vector of [a b]
  Coords dir={b.x-a.x, b.y-a.y, b.z-a.z};

  //the plane parallel to the 'y' is computed with the normal vector of the projection of [ab] on plane 'xz'
  *A1= dir.z;
  *C1=-dir.x;
  if(*A1!=0 || *C1!=0)
    *D1=-(a.x)*(*A1)-(a.z)*(*C1);
  else
  {
    //the plane does not support the vector, take the one parallel to 'z''
    *A1=1;
    //B1=dir.x=0
    *D1=-(a.x);
  }
  //the plane parallel to the 'x' is computed with the normal vector of the projection of [ab] on plane 'yz'
  *B2= dir.z;
  *C2=-dir.y;
  *A2= 0;
  if (*B2==0 && *C2==0)
  {
    //the plane does not support the vector, take the one parallel to 'z'
    *B2=1;
    //B1=dir.x=0
    *D2=-(a.y);
  }
  else {
    if (dir.z==0)
    {
      //the planes are the same, take the one parallel to 'z'
      *A2= dir.y;
      *B2=-dir.x;
      *D2=-(a.x)*(*A2)-(a.y)*(*B2);
    }
    else
      *D2=-(a.y)**B2-(a.z)**C2;
  }
} /* off_init_planes */

// off_clip_3D_mod *************************************************************
int off_clip_3D_mod(intersection* t, Coords a, Coords b,
  Coords* vtxArray, unsigned long vtxSize, unsigned long* faceArray,
  unsigned long faceSize, Coords* normalArray)
{
  MCNUM A1=0, C1=0, D1=0, A2=0, B2=0, C2=0, D2=0;      //perpendicular plane equations to [a,b]
  off_init_planes(a, b, &A1, &C1, &D1, &A2, &B2, &C2, &D2);

  int t_size=0;
  //unsigned long vtxSize=vtxTable.rows, faceSize=faceTable.columns;  //Size of the corresponding tables
  char sg[vtxSize];  //array telling if vertex is left or right of the plane
  MCNUM popol[3*CHAR_BUF_LENGTH];
  unsigned long i=0,indPoly=0;
  for (i=0; i < vtxSize; ++i)
  {
    sg[i]=off_sign(off_F(vtxArray[i].x,vtxArray[i].y,vtxArray[i].z,A1,0,C1,D1));
  }

  //exploring the polygons :
  i=indPoly=0;
  while (i<faceSize)
  {
    polygon pol;
    pol.npol  = faceArray[i];                //nb vertex of polygon
    pol.p     = popol;
    pol.normal= coords_set(0,0,1);
    unsigned long indVertP1=faceArray[++i];  //polygon's first vertex index in vtxTable
    int j=1;
    while (j<pol.npol)
    {
      //polygon's j-th vertex index in vtxTable
      if (sg[indVertP1]!=sg[faceArray[i+j]]) //if the plane intersect the polygon
        break;

      ++j;
    }

    if (j<pol.npol)          //ok, let's test with the second plane
    {
      char sg1=off_sign(off_F(vtxArray[indVertP1].x,vtxArray[indVertP1].y,vtxArray[indVertP1].z,A2,B2,C2,D2));//tells if vertex is left or right of the plane

      j=1;
      while (j<pol.npol)
      {
        //unsigned long indVertPi=faceArray[i+j];  //polyg's j-th vertex index in vtxTable
        Coords vertPi=vtxArray[faceArray[i+j]];
        if (sg1!=off_sign(off_F(vertPi.x,vertPi.y,vertPi.z,A2,B2,C2,D2)))//if the plane intersect the polygon
          break;
        ++j;
      }
      if (j<pol.npol)
      {
        if (t_size>CHAR_BUF_LENGTH)
        {
          fprintf(stderr, "Warning: number of intersection exceeded (%d) (interoff-lib/off_clip_3D_mod)\n", CHAR_BUF_LENGTH);
            return (t_size);
        }
        //both planes intersect the polygon, let's find the intersection point
        //our polygon :
        int k;
        for (k=0; k<pol.npol; ++k)
        {
          Coords vertPk=vtxArray[faceArray[i+k]];
          pol.p[3*k]  =vertPk.x;
          pol.p[3*k+1]=vertPk.y;
          pol.p[3*k+2]=vertPk.z;
        }
        pol.normal=normalArray[indPoly];
        intersection x;
        if (off_intersectPoly(&x, a, b, pol))
        {
          x.index = indPoly;
          t[t_size++]=x;
        }
      } /* if (j<pol.npol) */
    } /* if (j<pol.npol) */
    i += pol.npol;
    indPoly++;
  } /* while i<faceSize */
  return t_size;
} /* off_clip_3D_mod */


// off_compare *****************************************************************
int off_compare (void const *a, void const *b)
{
   intersection const *pa = a;
   intersection const *pb = b;

   return off_sign(pa->time - pb->time);
} /* off_compare */

// off_cleanDouble *************************************************************
//given an array of intersections throw those which appear several times
//returns 1 if there is a possibility of error
int off_cleanDouble(intersection* t, int* t_size)
{
  int i=1;
  intersection prev=t[0];
  while (i<*t_size)
  {
    int j=i;
    //for each intersection with the same time
    while (j<*t_size && fabs(prev.time-t[j].time)<OFF_EPSILON)
    {
      //if the intersection is the exact same erase it
      if (prev.in_out==t[j].in_out)
      {
        int k;
        for (k=j+1; k<*t_size; ++k)
        {
          t[k-1]=t[k];
        }
        *t_size-=1;
      }
      else
        ++j;
    }
    prev=t[i];
    ++i;

  }
  return 1;
} /* off_cleanDouble */

// off_cleanInOut **************************************************************
//given an array of intesections throw those which enter and exit in the same time
//Meaning the ray passes very close to the volume
//returns 1 if there is a possibility of error
int off_cleanInOut(intersection* t, int* t_size)
{
  int i=1;
  intersection prev=t[0];
  while (i<*t_size)
  {
    //if two intersection have the same time but one enters and the other exits erase both
    //(such intersections must be adjacent in the array : run off_cleanDouble before)
    if (fabs(prev.time-t[i].time)<OFF_EPSILON && prev.in_out!=t[i].in_out)
    {
      int j=0;
      for (j=i+1; j<*t_size; ++j)
      {
        t[j-2]=t[j];
      }
      *t_size-=2;
      prev=t[i-1];
    }
    else
    {
      prev=t[i];
      ++i;
    }
  }
  return (*t_size);
} /* off_cleanInOut */

/* PUBLIC functions ******************************************************** */

/*******************************************************************************
* long off_init(  char *offfile, double xwidth, double yheight, double zdepth, off_struct* data)
* ACTION: read an OFF file, optionally center object and rescale, initialize OFF data structure
* INPUT: 'offfile' OFF file to read
*        'xwidth,yheight,zdepth' if given as non-zero, apply bounding box.
*           Specifying only one of these will also use the same ratio on all axes
*        'notcenter' center the object to the (0,0,0) position in local frame when set to zero
* RETURN: number of polyhedra and 'data' OFF structure
*******************************************************************************/
long off_init(  char *offfile, double xwidth, double yheight, double zdepth,
                int notcenter, off_struct* data)
{
  // data to be initialized
  long    vtxSize =0, polySize=0, i=0, ret=0, faceSize=0;
  Coords* vtxArray        =NULL;
  Coords* normalArray     =NULL;
  unsigned long* faceArray=NULL;
  FILE*   f               =NULL; /* the FILE with vertices and polygons */
  double minx=FLT_MAX,maxx=-FLT_MAX,miny=FLT_MAX,maxy=-FLT_MAX,minz=FLT_MAX,maxz=-FLT_MAX;

  // get the indexes
  if (!data) return(0);
  
  MPI_MASTER(
  printf("Loading geometry file (OFF/PLY): %s\n", offfile);
  );
  
  f=off_getBlocksIndex(offfile,&vtxSize,&polySize);
  if (!f) return(0);
  
  // read vertex table = [x y z | x y z | ...] =================================
  // now we read the vertices as 'vtxSize*3' numbers and store it in vtxArray 
  MPI_MASTER(
  printf("  Number of vertices: %ld\n", vtxSize);
  );
  vtxArray   = malloc(vtxSize*sizeof(Coords));
  if (!vtxArray) return(0);
  i=0;
  while (i<vtxSize && ~feof(f))
  {
    double x,y,z;
    ret=fscanf(f, "%lg%lg%lg", &x,&y,&z);
    if (!ret) { 
      // invalid line: we skip it (probably a comment)
      char line[CHAR_BUF_LENGTH];
      fgets(line, CHAR_BUF_LENGTH, f);
      continue; 
    }
    if (ret != 3) {
      fprintf(stderr, "Error: can not read [xyz] coordinates for vertex %ld in file %s (interoff/off_init). Read %ld values.\n", 
        i, offfile, ret);
      exit(2);
    }
    vtxArray[i].x=x;
    vtxArray[i].y=y;
    vtxArray[i].z=z;

    //bounding box
    if (vtxArray[i].x<minx) minx=vtxArray[i].x;
    if (vtxArray[i].x>maxx) maxx=vtxArray[i].x;
    if (vtxArray[i].y<miny) miny=vtxArray[i].y;
    if (vtxArray[i].y>maxy) maxy=vtxArray[i].y;
    if (vtxArray[i].z<minz) minz=vtxArray[i].z;
    if (vtxArray[i].z>maxz) maxz=vtxArray[i].z;
    i++; // inquire next vertex
  }

  // resizing and repositioning params
  double centerx=0, centery=0, centerz=0;
  if (!notcenter) {
    centerx=(minx+maxx)*0.5;
    centery=(miny+maxy)*0.5;
    centerz=(minz+maxz)*0.5;
  }

  double rangex=-minx+maxx,
         rangey=-miny+maxy,
         rangez=-minz+maxz;

  double ratiox=1,ratioy=1,ratioz=1;

  if (xwidth && rangex)
  {
    ratiox=xwidth/rangex;
    ratioy=ratiox;
    ratioz=ratiox;
  }

  if (yheight && rangey)
  {
    ratioy=yheight/rangey;
    if(!xwidth)  ratiox=ratioy;
    ratioz=ratioy;
  }

  if (zdepth && rangez)
  {
    ratioz=zdepth/rangez;
    if(!xwidth)  ratiox=ratioz;
    if(!yheight) ratioy=ratioz;
  }

  rangex *= ratiox;
  rangey *= ratioy;
  rangez *= ratioz;

  //center and resize the object
  for (i=0; i<vtxSize; ++i)
  {
    vtxArray[i].x=(vtxArray[i].x-centerx)*ratiox+(!notcenter ? 0 : centerx);
    vtxArray[i].y=(vtxArray[i].y-centery)*ratioy+(!notcenter ? 0 : centery);
    vtxArray[i].z=(vtxArray[i].z-centerz)*ratioz+(!notcenter ? 0 : centerz);
  }
  
  // read face table = [nbvertex v1 v2 vn | nbvertex v1 v2 vn ...] =============
  MPI_MASTER(
  printf("  Number of polygons: %ld\n", polySize);
  );
  normalArray= malloc(polySize*sizeof(Coords));
  faceArray  = malloc(polySize*10*sizeof(unsigned long)); // we assume polygons have less than 9 vertices
  if (!normalArray || !faceArray) return(0);
  
  // fill faces
  faceSize=0;
  i=0;
  while (i<polySize && ~feof(f)) {
    int  nbVertex=0, j=0;
    // read the length of this polygon
    ret=fscanf(f, "%d", &nbVertex);
    if (!ret) { 
      // invalid line: we skip it (probably a comment)
      char line[CHAR_BUF_LENGTH];
      fgets(line, CHAR_BUF_LENGTH, f);
      continue; 
    }
    if (ret != 1) {
      fprintf(stderr, "Error: can not read polygon %ld length in file %s (interoff/off_init)\n", 
        i, offfile);
      exit(3);
    }
    if (faceSize > polySize*10) {
      fprintf(stderr, "Error: %li exceeded allocated polygon array[%li] in file %s (interoff/off_init)\n", 
        faceSize, polySize*10, offfile);
    }
    faceArray[faceSize++] = nbVertex; // length of the polygon/face
    // then read the vertex ID's
    for (j=0; j<nbVertex; j++) {
      double vtx=0;
      fscanf(f, "%lg", &vtx);
      faceArray[faceSize++] = vtx;   // add vertices index after length of polygon
    }
    i++;
  }

  // precomputes normals
  long indNormal=0;//index in polyArray
  i=0;    //index in faceArray
  while (i<faceSize)
  {
    int    nbVertex=faceArray[i];//nb of vertices of this polygon
    double vertices[3*nbVertex];
    int j;

    for (j=0; j<nbVertex; ++j)
    {
      unsigned long indVertPj=faceArray[i+j+1];
      vertices[3*j]  =vtxArray[indVertPj].x;
      vertices[3*j+1]=vtxArray[indVertPj].y;
      vertices[3*j+2]=vtxArray[indVertPj].z;
    }

    polygon p;
    p.p   =vertices;
    p.npol=nbVertex;
    off_normal(&(p.normal),p);

    normalArray[indNormal]=p.normal;

    i += nbVertex+1;
    indNormal++;

  }
  
  MPI_MASTER(
  if (ratiox!=ratioy || ratiox!=ratioz || ratioy!=ratioz)
    printf("Warning: Aspect ratio of the geometry %s was modified.\n"
           "         If you want to keep the original proportions, specifiy only one of the dimensions.\n",
           offfile);
  if ( xwidth==0 && yheight==0 && zdepth==0 ) {
    printf("Warning: Neither xwidth, yheight or zdepth are defined.\n"
	   "           The file-defined (non-scaled) geometry the OFF geometry %s will be applied!\n", 
           offfile);
  }
  printf("  Bounding box dimensions for geometry %s:\n", offfile);
  printf("    Length=%f (%.3f%%)\n", rangex, ratiox*100);
  printf("    Width= %f (%.3f%%)\n", rangey, ratioy*100);
  printf("    Depth= %f (%.3f%%)\n", rangez, ratioz*100);
  );

  data->vtxArray   = vtxArray;
  data->normalArray= normalArray;
  data->faceArray  = faceArray;
  data->vtxSize    = vtxSize;
  data->polySize   = polySize;
  data->faceSize   = faceSize;
  data->filename   = offfile;
  return(polySize);
} /* off_init */

/*******************************************************************************
* int off_intersect_all(double* t0, double* t3,
     Coords *n0, Coords *n3,
     double x, double y, double z,
     double vx, double vy, double vz,
     off_struct *data )
* ACTION: computes intersection of neutron trajectory with an object.
* INPUT:  x,y,z and vx,vy,vz are the position and velocity of the neutron
*         data points to the OFF data structure
* RETURN: the number of polyhedra which trajectory intersects
*         t0 and t3 are the smallest incoming and outgoing intersection times
*         n0 and n3 are the corresponding normal vectors to the surface
*         data is the full OFF structure, including a list intersection type
*******************************************************************************/
int off_intersect_all(double* t0, double* t3,
     Coords *n0, Coords *n3,
     double x,  double y,  double z,
     double vx, double vy, double vz,
     off_struct *data )
{
    Coords A={x, y, z};
    Coords B={x+vx, y+vy, z+vz};
    int t_size=off_clip_3D_mod(data->intersects, A, B,
      data->vtxArray, data->vtxSize, data->faceArray, data->faceSize, data->normalArray );
    qsort(data->intersects, t_size, sizeof(intersection),  off_compare);
    off_cleanDouble(data->intersects, &t_size);
    off_cleanInOut(data->intersects,  &t_size);

    /*find intersections "closest" to 0 (favouring positive ones)*/
    if(t_size>0){
      int i=0;
      if(t_size>1) {
        for (i=1; i < t_size-1; i++){
          if (data->intersects[i-1].time > 0 && data->intersects[i].time > 0)
            break;
        }
	
	data->nextintersect=i-1;
	data->numintersect=t_size;

        if (t0) *t0 = data->intersects[i-1].time;
        if (n0) *n0 = data->intersects[i-1].normal;
        if (t3) *t3 = data->intersects[i].time;
        if (n3) *n3 = data->intersects[i].normal;
      } else {
        if (t0) *t0 = data->intersects[0].time; 	 
	      if (n0) *n0 = data->intersects[0].normal;
      }
      /* should also return t[0].index and t[i].index as polygon ID */
      return t_size;
    }
    return 0;
} /* off_intersect */

/*******************************************************************************
* int off_intersect(double* t0, double* t3,
     Coords *n0, Coords *n3,
     double x, double y, double z,
     double vx, double vy, double vz,
     off_struct data )
* ACTION: computes intersection of neutron trajectory with an object.
* INPUT:  x,y,z and vx,vy,vz are the position and velocity of the neutron
*         data points to the OFF data structure
* RETURN: the number of polyhedra which trajectory intersects
*         t0 and t3 are the smallest incoming and outgoing intersection times
*         n0 and n3 are the corresponding normal vectors to the surface
*******************************************************************************/
int off_intersect(double* t0, double* t3,
     Coords *n0, Coords *n3,
     double x,  double y,  double z,
     double vx, double vy, double vz,
     off_struct data )
{
  return off_intersect_all(t0, t3, n0, n3, x, y, z, vx, vy, vz, &data );
} /* off_intersect */

/*****************************************************************************
* int off_x_intersect(double* l0, double* l3,
     Coords *n0, Coords *n3,
     double x, double y, double z,
     double kx, double ky, double kz,
     off_struct data )
* ACTION: computes intersection of an xray trajectory with an object.
* INPUT:  x,y,z and kx,ky,kz, are spatial coordinates and wavevector of the x-ray
*         respectively. data points to the OFF data structure.
* RETURN: the number of polyhedra the trajectory intersects
*         l0 and l3 are the smallest incoming and outgoing intersection lengths
*         n0 and n3 are the corresponding normal vectors to the surface
*******************************************************************************/
int off_x_intersect(double *l0,double *l3,
     Coords *n0, Coords *n3,
     double x,  double y,  double z,
     double kx, double ky, double kz,
     off_struct data )
{
  /*This function simply reformats and calls off_intersect (as for neutrons)
   *by normalizing the wavevector - this will yield the intersection lengths
   *in m*/
  double jx,jy,jz,invk;
  int n;
  invk=1/sqrt(scalar_prod(kx,ky,kz,kx,ky,kz));
  jx=kx*invk;jy=ky*invk;jz=kz*invk;
  n=off_intersect(l0,l3,n0,n3,x,y,z,jx,jy,jz,data);
  return n;
}


/*******************************************************************************
* void off_display(off_struct data)
* ACTION: display up to N_VERTEX_DISPLAYED polygons from the object
*******************************************************************************/
void off_display(off_struct data)
{
  unsigned int i;
  double ratio=(double)(N_VERTEX_DISPLAYED)/(double)data.faceSize;
  unsigned int pixel=0;
  for (i=0; i<data.faceSize-1; i++) {
    int j;
    int nbVertex = data.faceArray[i];
    double x0,y0,z0;
    x0 = data.vtxArray[data.faceArray[i+1]].x;
    y0 = data.vtxArray[data.faceArray[i+1]].y;
    z0 = data.vtxArray[data.faceArray[i+1]].z;
    double x1=x0,y1=y0,z1=z0;
    double cmx=0,cmy=0,cmz=0;
    
    int drawthis = rand01() < ratio;
    // First pass, calculate center of mass location...
    for (j=1; j<=nbVertex; j++) {
      cmx = cmx+data.vtxArray[data.faceArray[i+j]].x;
      cmy = cmy+data.vtxArray[data.faceArray[i+j]].y;
      cmz = cmz+data.vtxArray[data.faceArray[i+j]].z;
    }
    cmx /= nbVertex;
    cmy /= nbVertex;
    cmz /= nbVertex;
    
    char pixelinfo[1024];    
    sprintf(pixelinfo, "%lu,%lu,%lu,%i,%g,%g,%g,%g,%g,%g", data.mantidoffset+pixel, data.mantidoffset, data.mantidoffset+data.polySize-1, nbVertex, cmx, cmy, cmz, x1-cmx, y1-cmy, z1-cmz);
    for (j=2; j<=nbVertex; j++) {
      double x2,y2,z2;
      x2 = data.vtxArray[data.faceArray[i+j]].x;
      y2 = data.vtxArray[data.faceArray[i+j]].y;
      z2 = data.vtxArray[data.faceArray[i+j]].z;
      sprintf(pixelinfo, "%s,%g,%g,%g", pixelinfo, x2-cmx, y2-cmy, z2-cmz); 
      if (ratio > 1 || drawthis) {
	mcdis_line(x1,y1,z1,x2,y2,z2);
      }
      x1 = x2; y1 = y2; z1 = z2;
    }
    if (ratio > 1 || drawthis) {
	mcdis_line(x1,y1,z1,x0,y0,z0);
      }
    if (data.mantidflag) {
      printf("MANTID_PIXEL: %s\n", pixelinfo);
      pixel++;
    }
    i += nbVertex;
  }
} /* off_display */

/* end of interoff-lib.c */

/* Declare structures and functions only once in each instrument. */
#ifndef POWDERN_DECL_UNION
#define POWDERN_DECL_UNION
/* format definitions in the order {j d F2 DW Dd inv2d q F strain} */
#ifndef Crystallographica
#define Crystallographica { 4,5,7,0,0,0,0,0,0 }
#define Fullprof          { 4,0,8,0,0,5,0,0,0 }
#define Lazy              {17,6,0,0,0,0,0,13,0 }
#define Undefined         { 0,0,0,0,0,0,0,0,0 }
#endif

  struct line_data_union
    {
      double F2;                  /* Value of structure factor */
      double q;                   /* Qvector */
      int j;                      /* Multiplicity */
      double DWfactor;            /* Debye-Waller factor */
      double w;                   /* Intrinsic line width */
      double Epsilon;             /* Strain=delta_d_d/d shift in ppm */
    };

  struct line_info_struct_union
    {
      struct line_data_union *list;     /* Reflection array */
      int  count;                  /* Number of reflections */
      double Dd;
      double DWfactor;
      double V_0;
      double rho;
      double at_weight;
      double at_nb;
      double sigma_a; // should not be used
      double sigma_i; // should not be used
      char   compname[256];
      double flag_barns;
      int    shape; /* 0 cylinder, 1 box, 2 sphere, 3 OFF file */
      int    column_order[9]; /* column signification */
      int    flag_warning;
      char   type;  /* interaction type of event t=Transmit, i=Incoherent, c=Coherent */
      double dq;    /* wavevector transfer [Angs-1] */
      double Epsilon; /* global strain in ppm */
      double XsectionFactor;
      double my_s_v2_sum;
      double my_a_v;
      double my_inc;
      double *w_v,*q_v, *my_s_v2;
      double radius_i,xwidth_i,yheight_i,zdepth_i; // not to be used, but still here
      double v; /* last velocity (cached) */
      double Nq;
      int    nb_reuses, nb_refl, nb_refl_count;
      double v_min, v_max;
      double xs_Nq[CHAR_BUF_LENGTH];
      double xs_sum[CHAR_BUF_LENGTH];
      double neutron_passed;
      long   xs_compute, xs_reuse, xs_calls;
    };

  off_struct offdata_union;
  
  // PN_list_compare *****************************************************************

  int PN_list_compare_union (void const *a, void const *b)
  {
     struct line_data_union const *pa = a;
     struct line_data_union const *pb = b;
     double s = pa->q - pb->q;
     
     if (!s) return 0;
     else    return (s < 0 ? -1 : 1);
  } /* PN_list_compare */

  int read_line_data_union(char *SC_file, struct line_info_struct_union *info)
  {
    struct line_data_union *list = NULL;
    int    size = 0;
    t_Table sTable; /* sample data table structure from SC_file */
    int    i=0;
    int    mult_count  =0;
    char   flag=0;
    double q_count=0, j_count=0, F2_count=0;
    char **parsing;
    int    list_count=0;

    if (!SC_file || !strlen(SC_file) || !strcmp(SC_file, "NULL")) {
      printf("PowderN: %s: Using incoherent elastic scattering only\n",info->compname);
      info->count = 0;
      return(0);
    }
    Table_Read(&sTable, SC_file, 1); /* read 1st block data from SC_file into sTable*/

    /* parsing of header */
    parsing = Table_ParseHeader(sTable.header,
      "Vc","V_0",
      "sigma_abs","sigma_a ",
      "sigma_inc","sigma_i ",
      "column_j",
      "column_d",
      "column_F2",
      "column_DW",
      "column_Dd",
      "column_inv2d", "column_1/2d", "column_sintheta/lambda",
      "column_q", /* 14 */
      "DW", "Debye_Waller",
      "delta_d_d/d",
      "column_F ",
      "V_rho",
      "density",
      "weight",
      "nb_atoms","multiplicity", /* 23 */
      "column_ppm","column_strain",
      NULL);

    if (parsing) {
      if (parsing[0] && !info->V_0)     info->V_0    =atof(parsing[0]);
      if (parsing[1] && !info->V_0)     info->V_0    =atof(parsing[1]);
      if (parsing[2] && !info->sigma_a) info->sigma_a=atof(parsing[2]);
      if (parsing[3] && !info->sigma_a) info->sigma_a=atof(parsing[3]);
      if (parsing[4] && !info->sigma_i) info->sigma_i=atof(parsing[4]);
      if (parsing[5] && !info->sigma_i) info->sigma_i=atof(parsing[5]);
      if (parsing[6])                   info->column_order[0]=atoi(parsing[6]);
      if (parsing[7])                   info->column_order[1]=atoi(parsing[7]);
      if (parsing[8])                   info->column_order[2]=atoi(parsing[8]);
      if (parsing[9])                   info->column_order[3]=atoi(parsing[9]);
      if (parsing[10])                  info->column_order[4]=atoi(parsing[10]);
      if (parsing[11])                  info->column_order[5]=atoi(parsing[11]);
      if (parsing[12])                  info->column_order[5]=atoi(parsing[12]);
      if (parsing[13])                  info->column_order[5]=atoi(parsing[13]);
      if (parsing[14])                  info->column_order[6]=atoi(parsing[14]);
      if (parsing[15] && info->DWfactor<=0)    info->DWfactor=atof(parsing[15]);
      if (parsing[16] && info->DWfactor<=0)    info->DWfactor=atof(parsing[16]);
      if (parsing[17] && info->Dd <0)          info->Dd      =atof(parsing[17]);
      if (parsing[18])                  info->column_order[7]=atoi(parsing[18]);
      if (parsing[19] && !info->V_0)    info->V_0    =1/atof(parsing[19]);
      if (parsing[20] && !info->rho)    info->rho    =atof(parsing[20]);
      if (parsing[21] && !info->at_weight)     info->at_weight    =atof(parsing[21]);
      if (parsing[22] && info->at_nb <= 1)  info->at_nb    =atof(parsing[22]);
      if (parsing[23] && info->at_nb <= 1)  info->at_nb    =atof(parsing[23]);
      if (parsing[24])                  info->column_order[8]=atoi(parsing[24]);
      if (parsing[25])                  info->column_order[8]=atoi(parsing[25]);
      for (i=0; i<=25; i++) if (parsing[i]) free(parsing[i]);
      free(parsing);
    }

    if (!sTable.rows)
      exit(fprintf(stderr, "PowderN: %s: Error: The number of rows in %s "
       "should be at least %d\n", info->compname, SC_file, 1));
    else size = sTable.rows;
    Table_Info(sTable);
    printf("PowderN: %s: Reading %d rows from %s\n",
          info->compname, size, SC_file);

    if (info->column_order[0] == 4 && info->flag_barns !=0)
    printf("PowderN: %s: Powder file probably of type Crystallographica/Fullprof (lau)\n"
           "WARNING: but F2 unit is set to barns=1 (barns). Intensity might be 100 times too high.\n",
           info->compname);
  if (info->column_order[0] == 17 && info->flag_barns == 0)
    printf("PowderN: %s: Powder file probably of type Lazy Pulver (laz)\n"
           "WARNING: but F2 unit is set to barns=0 (fm^2). Intensity might be 100 times too low.\n",
           info->compname);
    /* allocate line_data array */
    list = (struct line_data_union*)malloc(size*sizeof(struct line_data_union));

    for (i=0; i<size; i++)
    {
      /*      printf("Reading in line %i\n",i);*/
      double j=0, d=0, w=0, q=0, DWfactor=0, F2=0, Epsilon=0;
      int index;

      if (info->Dd >= 0)      w         = info->Dd;
      if (info->DWfactor > 0) DWfactor  = info->DWfactor;
      if (info->Epsilon)      Epsilon   = info->Epsilon*1e-6;

      /* get data from table using columns {j d F2 DW Dd inv2d q F} */
      /* column indexes start at 1, thus need to substract 1 */
      if (info->column_order[0] >0)
        j = Table_Index(sTable, i, info->column_order[0]-1);
      if (info->column_order[1] >0)
        d = Table_Index(sTable, i, info->column_order[1]-1);
      if (info->column_order[2] >0)
        F2 = Table_Index(sTable, i, info->column_order[2]-1);
      if (info->column_order[3] >0)
        DWfactor = Table_Index(sTable, i, info->column_order[3]-1);
      if (info->column_order[4] >0)
        w = Table_Index(sTable, i, info->column_order[4]-1);
      if (info->column_order[5] >0)
        { d = Table_Index(sTable, i, info->column_order[5]-1);
          d = (d > 0? 1/d/2 : 0); }
      if (info->column_order[6] >0)
        { q = Table_Index(sTable, i, info->column_order[6]-1);
          d = (q > 0 ? 2*PI/q : 0); }
      if (info->column_order[7] >0  && !F2)
        { F2 = Table_Index(sTable, i, info->column_order[7]-1); F2 *= F2; }
      if (info->column_order[8] >0  && !Epsilon)
        { Epsilon = Table_Index(sTable, i, info->column_order[8]-1)*1e-6; }

      /* assign and check values */
      j        = (j > 0 ? j : 0);
      q        = (d > 0 ? 2*PI/d : 0); /* this is q */
      if (Epsilon && fabs(Epsilon) < 1e6) {
        q     -= Epsilon*q; /* dq/q = -delta_d_d/d = -Epsilon */
      }
      DWfactor = (DWfactor > 0 ? DWfactor : 1);
      w        = (w>0 ? w : 0); /* this is q and d relative spreading */
      F2       = (F2 >= 0 ? F2 : 0);
      if (j == 0 || q == 0) {
        printf("PowderN: %s: line %i has invalid definition\n"
               "         (mult=0 or q=0 or d=0)\n", info->compname, i);
        continue;
      }
      list[list_count].j = j;
      list[list_count].q = q;
      list[list_count].DWfactor = DWfactor;
      list[list_count].w = w;
      list[list_count].F2= F2;
      list[list_count].Epsilon = Epsilon;

      /* adjust multiplicity if j-column + multiple d-spacing lines */
      /* if  d = previous d, increase line duplication index */
      if (!q_count)      q_count  = q;
      if (!j_count)      j_count  = j;
      if (!F2_count)     F2_count = F2;
      if (fabs(q_count-q) < 0.0001*fabs(q)
       && fabs(F2_count-F2) < 0.0001*fabs(F2) && j_count == j) {
       mult_count++; flag=0; }
      else flag=1;
      if (i == size-1) flag=1;
      /* else if d != previous d : just passed equivalent lines */
      if (flag) {
        if (i == size-1) list_count++;
      /*   if duplication index == previous multiplicity */
      /*      set back multiplicity of previous lines to 1 */
        if ((mult_count && list_count>0)
            && (mult_count == list[list_count-1].j
                || ((list_count < size) && (i == size - 1)
                    && (mult_count == list[list_count].j))) ) {
          printf("PowderN: %s: Set multiplicity to 1 for lines [%i:%i]\n"
                  "         (d-spacing %g is duplicated %i times)\n",
            info->compname, list_count-mult_count, list_count-1, list[list_count-1].q, mult_count);
          for (index=list_count-mult_count; index<list_count; list[index++].j = 1);
          mult_count = 1;
          q_count   = q;
          j_count   = j;
          F2_count  = F2;
        }
        if (i == size-1) list_count--;
        flag=0;
      }
      list_count++;
    } /* end for */ 
    
    Table_Free(&sTable);
    
    /* sort the list with increasing q */
    qsort(list, list_count, sizeof(struct line_data_union),  PN_list_compare_union);
    
    printf("PowderN: %s: Read %i reflections from file '%s'\n", 
      info->compname, list_count, SC_file);
    
    info->list  = list;
    info->count = list_count;

    return(list_count);
  } /* read_line_data_union */


/* computes the number of possible reflections (return value), and the total xsection 'sum' */
/* this routine looks for a pre-computed value in the Nq and sum cache tables               */
/* when found, the earch starts from the corresponding lower element in the table           */
int calc_xsect_union(double v, double *qv, double *my_sv2, int count, double *sum,
  struct line_info_struct_union *line_info) {
  int    Nq = 0, line=0, line0=0;
  *sum=0;
  
  //printf("Line_info when entering cross_section calculation\n");
  //printf("v = %f, qv = %f, my_sv2 = %f, count = %d, sum = %f\n",v,*qv,*my_sv2,count,*sum);
  //printf("v = %f\n",v);
  //printf("line_info->v = %f, line_info->v_min = %f, line_info->v_max = %f, line_info->neutron_passed = %f\n",line_info->v,line_info->v_min,line_info->v_max,line_info->neutron_passed);
  //printf("line_info->xs_reuses = %d, line_info->xs_compute = %d\n",line_info->xs_reuse,line_info->xs_compute);
  
  
  /* check if a line_info element has been recorded already */
  if (v >= line_info->v_min && v <= line_info->v_max && line_info->neutron_passed >= CHAR_BUF_LENGTH) {
    line = (int)floor(v - line_info->v_min)*CHAR_BUF_LENGTH/(line_info->v_max - line_info->v_min);
    Nq    = line_info->xs_Nq[line];
    *sum  = line_info->xs_sum[line];
    if (!Nq && *sum == 0) {
      /* not yet set: we compute the sum up to the corresponding speed in the table cache */
      //printf("Nq and sum not yet set, have to do this calculation now\n");
      double line_v = line_info->v_min + line*(line_info->v_max - line_info->v_min)/CHAR_BUF_LENGTH;
      for(line0=0; line0<count; line0++) {
        if (qv[line0] <= 2*line_v) { /* q < 2*kf: restrict structural range */
          *sum += my_sv2[line0];
          if (Nq < line0+1) Nq=line0+1; /* determine maximum line index which can scatter */
        } else break;
      }
      line_info->xs_Nq[line] = Nq;
      line_info->xs_sum[line]= *sum;
      line_info->xs_compute++;
      //printf("line_info->xs_Nq[line] = %f, line_info->xs_sum[line] = %f, line_info->xs_compute = %d\n",line_info->xs_Nq[line],line_info->xs_sum[line],line_info->xs_compute);
    } else line_info->xs_reuse++;
    line0 = Nq;
  }
  
  line_info->xs_calls++;
  
  for(line=line0; line<count; line++) {
    if (qv[line] <= 2*v) { /* q < 2*kf: restrict structural range */
      *sum += my_sv2[line];
      if (Nq < line+1) Nq=line+1; /* determine maximum line index which can scatter */
    } else break;
  }
  
  //printf("cross_section function to return %d lines to scatter with, with cross section sum %f \n",Nq,*sum);
  return(Nq);
} /* calc_xsect_union */

#endif /* !POWDERN_DECL */



struct Powder_physics_storage_struct{
    // Variables that needs to be transfered between any of the following places:
    // The initialize in this component
    // The function for calculating my
    // The function for calculating scattering
    
    struct line_info_struct_union *line_info_storage;
    double my_scattering;
    double vertical_angular_limit;
};

// Obsolete: Function for initializing test_physics. Done in component instead.
int Powder_physics_initialize(union data_transfer_union data_transfer) {
      // Obsolte
      return 1;
};

// Function for calculating my in a test case.
int Powder_physics_my(double *my,double *k_initial, union data_transfer_union data_transfer, struct focus_data_struct *focus_data) {
    //*my = data_transfer.pointer_to_a_Powder_physics_storage_struct->my_scattering;
    
    
    int method_switch = 1;
    // For test
    int line_v,line0,line,count;
    
    // Should not interfer with the global variables
    double vx = k_initial[0]*K2V;
    double vy = k_initial[1]*K2V;
    double vz = k_initial[2]*K2V;
    
    // Not sure one can do this, but I do not see why not
    struct line_info_struct_union *line_info = data_transfer.pointer_to_a_Powder_physics_storage_struct->line_info_storage;
    
    double v = sqrt(vx*vx + vy*vy + vz*vz);
    //printf("Velocity = %f \n",v);
    
    //printf("line_info->v = %f, line_info->v_min = %f, line_info->v_max = %f, line_info->neutron_passed = %f\n",line_info->v,line_info->v_min,line_info->v_max,line_info->neutron_passed);
    // Here the maximum and minimum v is recorded, should this be for scattering events or cross section calculations?
    if (line_info->neutron_passed < CHAR_BUF_LENGTH) {
      if (v < line_info->v_min) line_info->v_min = v;
      if (v > line_info->v_max) line_info->v_max = v;
      line_info->neutron_passed++;
    }
    
    if (method_switch == 1) {
    // Here the cross section is calculated and stored
    if ( fabs(v - line_info->v) < 1e-6) {
        line_info->nb_reuses++;
      } else {
        //printf("calling crosssection calculation \n");
        // int calc_xsect_union(double v, double *qv, double *my_sv2, int count, double *sum, struct line_info_struct *line_info)
        line_info->Nq = calc_xsect_union(v, line_info->q_v, line_info->my_s_v2, line_info->count, &line_info->my_s_v2_sum, line_info);
        line_info->v = v;
        line_info->nb_refl += line_info->Nq;
        line_info->nb_refl_count++;
      }
    } else {
    if ( fabs(v - line_info->v) < 1e-6) {
        line_info->nb_reuses++;
      } else {
        //printf("calling crosssection calculation \n");
        if (v >= line_info->v_min && v <= line_info->v_max && line_info->neutron_passed >= CHAR_BUF_LENGTH) {
        line = (int)floor(v - line_info->v_min)*CHAR_BUF_LENGTH/(line_info->v_max - line_info->v_min);
        line_info->Nq = line_info->xs_Nq[line];
        line_info->my_s_v2_sum  = line_info->xs_sum[line];
        if (!line_info->Nq && line_info->my_s_v2_sum == 0) {
          /* not yet set: we compute the sum up to the corresponding speed in the table cache */
          //printf("Nq and sum not yet set, have to do this calculation now\n");
          double line_v = line_info->v_min + line*(line_info->v_max - line_info->v_min)/CHAR_BUF_LENGTH;
          for(line0=0; line0<count; line0++) {
            if (line_info->q_v[line0] <= 2*line_v) { /* q < 2*kf: restrict structural range */
              line_info->my_s_v2_sum += line_info->my_s_v2[line0];
              if (line_info->Nq < line0+1) line_info->Nq=line0+1; /* determine maximum line index which can scatter */
            } else break;
          }
          line_info->xs_Nq[line] = line_info->Nq;
          line_info->xs_sum[line]= line_info->my_s_v2_sum;
          line_info->xs_compute++;
          //printf("line_info->xs_Nq[line] = %f, line_info->xs_sum[line] = %f, line_info->xs_compute = %d\n",line_info->xs_Nq[line],line_info->xs_sum[line],line_info->xs_compute);
        } else line_info->xs_reuse++;
        line0 = line_info->Nq;
        }
          
        line_info->xs_calls++;
          
        for(line=line0; line<count; line++) {
          if (line_info->q_v[line] <= 2*v) { /* q < 2*kf: restrict structural range */
            line_info->my_s_v2_sum += line_info->my_s_v2[line];
            if (line_info->Nq < line+1) line_info->Nq=line+1; /* determine maximum line index which can scatter */
          } else break;
        }
        line_info->v = v;
        line_info->nb_refl += line_info->Nq;
        line_info->nb_refl_count++;
      }
    }
    
     *my = line_info->my_s_v2_sum/(v*v);
    //printf("Returned my scattering of %f \n",*my);
    //printf("compute = %d and reuse = %d \n",line_info->xs_compute,line_info->xs_reuse);
    
    return 1;
};

// Function that provides a basic nonuniform elastic scattering. Unphysical for testing purposes.
int Powder_physics_scattering(double *k_final, double *k_initial, double *weight, union data_transfer_union data_transfer, struct focus_data_struct *focus_data) {

    // This component need to write to its storage transfer for each event, is that possible with this structure?
    struct line_info_struct_union *line_info = data_transfer.pointer_to_a_Powder_physics_storage_struct->line_info_storage;
    double vertical_angular_limit = data_transfer.pointer_to_a_Powder_physics_storage_struct->vertical_angular_limit;
    
    
    // Should not interfer with the global variables
    double vx = k_initial[0]*K2V;
    double vy = k_initial[1]*K2V;
    double vz = k_initial[2]*K2V;
    
    double v = sqrt(vx*vx + vy*vy + vz*vz);
    
    int line;
    double arg;
    double theta;
    double alpha,alpha0;
    
    double vout_x,vout_y,vout_z;
    double tmp_vx,tmp_vy,tmp_vz;
    double nx,ny,nz;
    double my_s_n;
    
    // copy from PowderN component
    if (line_info->count > 0) {
          /* choose line */
          if (line_info->Nq > 1) line=floor(line_info->Nq*rand01());  /* Select between Nq powder lines */
          else line = 0;
          if (line_info->w_v[line])
            arg = line_info->q_v[line]*(1+line_info->w_v[line]*randnorm())/(2.0*v);
          else
            arg = line_info->q_v[line]/(2.0*v);
            my_s_n = line_info->my_s_v2[line]/(v*v);
          if(fabs(arg) > 1) {
            //printf("Powder scattering function returned 0, should not happen\n");
            return 0; /* No bragg scattering possible (was absorb)*/
          }
          theta = asin(arg);          /* Bragg scattering law */

          /* Choose point on Debye-Scherrer cone */
          if (vertical_angular_limit)
          { /* relate height of detector to the height on DS cone */
            arg = sin(vertical_angular_limit*DEG2RAD/2)/sin(2*theta);
            /* If full Debye-Scherrer cone is within d_phi, don't focus */
            if (arg < -1 || arg > 1) vertical_angular_limit = 0;
            /* Otherwise, determine alpha to rotate from scattering plane
               into vertical_angular_limit focusing area*/
            else alpha = 2*asin(arg);
          }
          if (vertical_angular_limit) {
            /* Focusing */
            alpha = fabs(alpha);
            /* Trick to get scattering for pos/neg theta's */
            alpha0= 2*rand01()*alpha;
            if (alpha0 > alpha) {
              alpha0=PI+(alpha0-1.5*alpha);
            } else {
              alpha0=alpha0-0.5*alpha;
            }
          }
          else
            alpha0 = PI*randpm1();

          /* now find a nearly vertical rotation axis:
           * Either
           *  (v along Z) x (X axis) -> nearly Y axis
           * Or
           *  (v along X) x (Z axis) -> nearly Y axis
           */
          if (fabs(scalar_prod(1,0,0,vx/v,vy/v,vz/v)) < fabs(scalar_prod(0,0,1,vx/v,vy/v,vz/v))) {
            nx = 1; ny = 0; nz = 0;
          } else {
            nx = 0; ny = 0; nz = 1;
          }
          vec_prod(tmp_vx,tmp_vy,tmp_vz, vx,vy,vz, nx,ny,nz);

          /* v_out = rotate 'v' by 2*theta around tmp_v: Bragg angle */
          rotate(vout_x,vout_y,vout_z, vx,vy,vz, 2*theta, tmp_vx,tmp_vy,tmp_vz);

          /* tmp_v = rotate v_out by alpha0 around 'v' (Debye-Scherrer cone) */
          rotate(tmp_vx,tmp_vy,tmp_vz, vout_x,vout_y,vout_z, alpha0, vx, vy, vz);
          vx = tmp_vx;
          vy = tmp_vy;
          vz = tmp_vz;
        
          k_final[0] = V2K*vx; k_final[1] = V2K*vy; k_final[2] = V2K*vz;
        
          //*weight *= line_info->Nq*my_s_n; I believe my_s_n is part of the correction for sampling posistion, not to be done here
          *weight *= line_info->Nq*my_s_n/line_info->my_s_v2_sum*v*v;
        
          //printf("my_s_n = %f \n",my_s_n);
        
          // What to do with my_s_n ?
          /*
          pmul  = line_info->Nq*l_full*my_s_n*exp(-(line_info->my_a_v/v+my_s)*(l+l_1))
                                  /(1-(p_inc+p_transmit));
          */
          // Correction in case of vertical_angular_limit focusing - BUT only when d_phi != 0
          if (vertical_angular_limit) *weight *= alpha/PI;
          
        
          line_info->type = 'c';
          line_info->dq = line_info->q_v[line]*V2K;
          
          
        } else {
        /* else transmit <-- No powder lines in file */
        printf("Error, need lines in the PowderN input file\n");
        }


    //printf("Powder scattering function returned 1\n");
    return 1;
};

#line 8407 "MACS_sample_kidney_box.c"

/* Shared user declarations for all components 'Union_make_material'. */
#line 57 "Union_make_material.comp"
#ifndef Union
#define Union $Revision: 0.8 $

#include "Union_functions.c"
#include "Union_initialization.c"

#endif

// This function checks if global_process_element should be included in this material when using automatic linking, returns 1 if yes, 0 if no.
int automatic_linking_materials_function(struct global_process_element_struct global_process_element, struct pointer_to_global_material_list global_material_list,int current_index) {
    // Remember this function is used before the current material is added to global_material_list
    // debug info
    //MPI_MASTER(
    //printf("Checking if process with index %d should be automatically linked to material with index %d\n",global_process_element.component_index,current_index);
    //)

    // Check if this is the first make_material, which makes the problem simpler.
    if (global_material_list.num_elements == 0) {
       if (global_process_element.component_index < current_index) return 1;
       else return 0;
    }
    // In case there are more than 1 make_material, global_material_list.elements[global_material_list.num_elements-1].component_index makes sense.
    if (global_process_element.component_index < current_index && global_process_element.component_index > global_material_list.elements[global_material_list.num_elements-1].component_index) return 1;
    else return 0;
}

void manual_linking_function_material(char *input_string, struct pointer_to_global_process_list *global_process_list, struct pointer_to_1d_int_list *accepted_processes, char *component_name) {
    // Need to check a input_string of text for an occurance of name. If it is in the inputstring, yes return 1, otherwise 0.
   char *token;
   int loop_index;
   char local_string[256];
   
   strcpy(local_string,input_string);
   // get the first token
   token = strtok(local_string,",");
   
   // walk through other tokens
   while( token != NULL ) 
   {
      //printf( " %s\n", token );
      for (loop_index=0;loop_index<global_process_list->num_elements;loop_index++) {
        if (strcmp(token,global_process_list->elements[loop_index].name) == 0) {
          add_element_to_int_list(accepted_processes,loop_index);
          break;
        }
        
        if (loop_index == global_process_list->num_elements - 1) {
          // All possible process names have been looked through, and the break was not executed.
          // Alert the user to this problem by showing the process name that was not found and the currently available processes
            printf("\n");
            printf("ERROR: The process string \"%s\" in Union material \"%s\" had an entry that did not match a specified process. \n",input_string,component_name);
            printf("       The unrecoignized process name was: \"%s\" \n",token);
            printf("       The processes available at this point (need to be defined before the material): \n");
            for (loop_index=0;loop_index<global_process_list->num_elements;loop_index++)
              printf("         %s\n",global_process_list->elements[loop_index].name);
            exit(1);
        }
      }
      
      // Updates the token
      token = strtok(NULL,",");
   }
}

// This function is needed in initialize of all geometry components
// Possible to insert these functions in make material, as they are only compiled once instead of many times
int manual_linking_function(char *name, char *input_string) {
    // Need to check a input_string of text for an occurance of name. If it is in the inputstring, yes return 1, otherwise 0.
   char *token;
   int return_integer=0;
   char local_string[124];
   
   strcpy(local_string,input_string);
   /* get the first token */
   token = strtok(local_string,",");
   
   /* walk through other tokens */
   while( token != NULL ) 
   {
      //printf( " %s\n", token );
      if (strcmp(token,name) == 0) return_integer=1;
      
      token = strtok(NULL,",");
   }
   
   return return_integer;
}



/*
int count_commas(char *string) {
  int return_value = 0;
  
  int index;
  for (index=0;index<strlen(string);index++) {
    printf("%c \n",string[index]);
    if (string[index]==',') return_value++;
  }
    
  //printf("number_of_commas = %d \n",return_value);
  return return_value;
}
*/


#line 8517 "MACS_sample_kidney_box.c"

/* Shared user declarations for all components 'Single_crystal_process'. */
#line 65 "Single_crystal_process.comp"
#ifndef Union
#define Union $Revision: 0.8 $

#include "Union_functions.c"
#include "Union_initialization.c"

#endif




#ifndef SINGLE_CRYSTAL_PROCESS_DECL
#define SINGLE_CRYSTAL_PROCESS_DECL

#ifndef Mosaic_AB_Undefined
#define Mosaic_AB_Undefined {0,0, 0,0,0, 0,0,0}
#endif

    struct hkl_data_union
    {
      int h,k,l;                  /* Indices for this reflection */
      double F2;                  /* Value of structure factor */
      double tau_x, tau_y, tau_z; /* Coordinates in reciprocal space */
      double tau;                 /* Length of (tau_x, tau_y, tau_z) */
      double u1x, u1y, u1z;       /* First axis of local coordinate system */
      double u2x, u2y, u2z;       /* Second axis of local coordinate system */
      double u3x, u3y, u3z;       /* Third axis of local coordinate system */
      double sig123;              /* The product sig1*sig2*sig3 = volume of spot */
      double m1, m2, m3;          /* Diagonal matrix representation of Gauss */
      double cutoff;              /* Cutoff value for Gaussian tails */
    };
    
  struct tau_data_union
    {
      int index;                  /* Index into reflection table */
      double refl;
      double xsect;
      /* The following vectors are in local koordinates. */
      double rho_x, rho_y, rho_z; /* The vector ki - tau */
      double rho;                 /* Length of rho vector */
      double ox, oy, oz;          /* Origin of Ewald sphere tangent plane */
      double b1x, b1y, b1z;       /* Spanning vectors of Ewald sphere tangent */
      double b2x, b2y, b2z;
      double l11, l12, l22;       /* Cholesky decomposition L of 2D Gauss */
      double y0x, y0y;            /* 2D Gauss center in tangent plane */
    };

  struct hkl_info_struct_union
    {
      struct hkl_data_union *list;      /* Reflection array */
      int count;                  /* Number of reflections */
      struct tau_data_union *tau_list;  /* Reflections close to Ewald Sphere */
      double m_delta_d_d;         /* Delta-d/d FWHM */
      double m_ax,m_ay,m_az;      /* First unit cell axis (direct space, AA) */
      double m_bx,m_by,m_bz;      /* Second unit cell axis */
      double m_cx,m_cy,m_cz;      /* Third unit cell axis */
      double asx,asy,asz;         /* First reciprocal lattice axis (1/AA) */
      double bsx,bsy,bsz;         /* Second reciprocal lattice axis */
      double csx,csy,csz;         /* Third reciprocal lattice axis */
      double m_a, m_b, m_c;       /* length of lattice parameter lengths */
      double m_aa, m_bb, m_cc;    /* lattice angles */
      double sigma_a, sigma_i;    /* abs and inc X sect */
      double rho;                 /* density */
      double at_weight;           /* atomic weight */
      double at_nb;               /* nb of atoms in a cell */
      double V0;                  /* Unit cell volume (AA**3) */
      int    column_order[5];     /* column signification [h,k,l,F,F2] */
      int    recip;               /* Flag to indicate if recip or direct cell axes given */
      int    shape;               /* 0:cylinder, 1:box, 2:sphere 3:any shape*/
      int    flag_warning;        /* number of warnings */
      char   type;                /* type of last event: t=transmit,c=coherent or i=incoherent */
      int    h,k,l;               /* last coherent scattering momentum transfer indices */
      int    tau_count;           /* Number of reflections within cutoff */
      double coh_refl, coh_xsect; /* cross section computed with last tau_list */
      double kix, kiy, kiz;       /* last incoming neutron ki */
      int    nb_reuses, nb_refl, nb_refl_count;
    };

  int SX_list_compare_union (void const *a, void const *b)
  {
     struct hkl_data_union const *pa = a;
     struct hkl_data_union const *pb = b;
     double s = pa->tau - pb->tau;
     
     if (!s) return 0;
     else    return (s < 0 ? -1 : 1);
  } /* PN_list_compare */
  
  /* ------------------------------------------------------------------------ */
  int
  read_hkl_data_union(char *SC_file, struct hkl_info_struct_union *info,
      double SC_mosaic, double SC_mosaic_a, double SC_mosaic_b, double SC_mosaic_c, double *SC_mosaic_AB)
  {
    struct hkl_data_union *list = NULL;
    int size = 0;
    t_Table sTable; /* sample data table structure from SC_file */
    int i=0;
    double tmp_x, tmp_y, tmp_z;
    char **parsing;
    char flag=0;
    double nb_atoms=1;

    if (!SC_file || !strlen(SC_file) || !strcmp(SC_file,"NULL") || !strcmp(SC_file,"0")) {
      info->count = 0;
      flag=1;
    }
    if (!flag) {
      Table_Read(&sTable, SC_file, 1); /* read 1st block data from SC_file into sTable*/
      if (sTable.columns < 4) {
        fprintf(stderr, "Single_crystal: Error: The number of columns in %s should be at least %d for [h,k,l,F2]\n", SC_file, 4);
        return(0);
      }
      if (!sTable.rows) {
        fprintf(stderr, "Single_crystal: Error: The number of rows in %s should be at least %d\n", SC_file, 1);
        return(0);
      } else size = sTable.rows;

      /* parsing of header */
      parsing = Table_ParseHeader(sTable.header,
        "sigma_abs","sigma_a ",
        "sigma_inc","sigma_i ",
        "column_h",
        "column_k",
        "column_l",
        "column_F ",
        "column_F2",
        "Delta_d/d",
        "lattice_a ",
        "lattice_b ",
        "lattice_c ",
        "lattice_aa",
        "lattice_bb",
        "lattice_cc",
        "nb_atoms","multiplicity",
        NULL);

      if (parsing) {
        if (parsing[0] && !info->sigma_a) info->sigma_a=atof(parsing[0]);
        if (parsing[1] && !info->sigma_a) info->sigma_a=atof(parsing[1]);
        if (parsing[2] && !info->sigma_i) info->sigma_i=atof(parsing[2]);
        if (parsing[3] && !info->sigma_i) info->sigma_i=atof(parsing[3]);
        if (parsing[4])                   info->column_order[0]=atoi(parsing[4]);
        if (parsing[5])                   info->column_order[1]=atoi(parsing[5]);
        if (parsing[6])                   info->column_order[2]=atoi(parsing[6]);
        if (parsing[7])                   info->column_order[3]=atoi(parsing[7]);
        if (parsing[8])                   info->column_order[4]=atoi(parsing[8]);
        if (parsing[9] && info->m_delta_d_d <0) info->m_delta_d_d=atof(parsing[9]);
        if (parsing[10] && !info->m_a)    info->m_a =atof(parsing[10]);
        if (parsing[11] && !info->m_b)    info->m_b =atof(parsing[11]);
        if (parsing[12] && !info->m_c)    info->m_c =atof(parsing[12]);
        if (parsing[13] && !info->m_aa)   info->m_aa=atof(parsing[13]);
        if (parsing[14] && !info->m_bb)   info->m_bb=atof(parsing[14]);
        if (parsing[15] && !info->m_cc)   info->m_cc=atof(parsing[15]);
        if (parsing[16])   nb_atoms=atof(parsing[16]);
        if (parsing[17])   nb_atoms=atof(parsing[17]);
        for (i=0; i<=17; i++) if (parsing[i]) free(parsing[i]);
        free(parsing);
      }
    }
    
    if (nb_atoms > 1) { info->sigma_a *= nb_atoms; info->sigma_i *= nb_atoms; }

    /* special cases for the structure definition */
    if (info->m_ax || info->m_ay || info->m_az) info->m_a=0; /* means we specify by hand the vectors */
    if (info->m_bx || info->m_by || info->m_bz) info->m_b=0;
    if (info->m_cx || info->m_cy || info->m_cz) info->m_c=0;

    /* compute the norm from vector a if missing */
    if (info->m_ax || info->m_ay || info->m_az) {
      double as=sqrt(info->m_ax*info->m_ax+info->m_ay*info->m_ay+info->m_az*info->m_az);
      if (!info->m_bx && !info->m_by && !info->m_bz) info->m_a=info->m_b=as;
      if (!info->m_cx && !info->m_cy && !info->m_cz) info->m_a=info->m_c=as;
    }
    if (info->m_a && !info->m_b) info->m_b=info->m_a;
    if (info->m_b && !info->m_c) info->m_c=info->m_b;
    
    /* compute the lattive angles if not set from data file. Not used when in vector mode. */
    if (info->m_a && !info->m_aa) info->m_aa=90;
    if (info->m_aa && !info->m_bb) info->m_bb=info->m_aa;
    if (info->m_bb && !info->m_cc) info->m_cc=info->m_bb;
    
    /* parameters consistency checks */
    if (!info->m_ax && !info->m_ay && !info->m_az && !info->m_a) {
      fprintf(stderr,
              "Single_crystal: Error: Wrong a lattice vector definition\n");
      return(0);
    }
    if (!info->m_bx && !info->m_by && !info->m_bz && !info->m_b) {
      fprintf(stderr,
              "Single_crystal: Error: Wrong b lattice vector definition\n");
      return(0);
    }
    if (!info->m_cx && !info->m_cy && !info->m_cz && !info->m_c) {
      fprintf(stderr,
              "Single_crystal: Error: Wrong c lattice vector definition\n");
      return(0);
    }
    
    if (info->m_aa && info->m_bb && info->m_cc && info->recip) {
      fprintf(stderr,
              "Single_crystal: Error: Selecting reciprocal cell and angles is unmeaningful\n");
      return(0);
    }


    /* when lengths a,b,c + angles are given (instead of vectors a,b,c) */
    if (info->m_aa && info->m_bb && info->m_cc)
    {
      double as,bs,cs;
      if (info->m_a) as = info->m_a;
      else as = sqrt(info->m_ax*info->m_ax+info->m_ay*info->m_ay+info->m_az*info->m_az);
      if (info->m_b) bs = info->m_b;
      else bs = sqrt(info->m_bx*info->m_bx+info->m_by*info->m_by+info->m_bz*info->m_bz);
      if (info->m_c) cs = info->m_c;
      else cs =  sqrt(info->m_cx*info->m_cx+info->m_cy*info->m_cy+info->m_cz*info->m_cz);

      info->m_bz = as; info->m_by = 0; info->m_bx = 0;
      info->m_az = bs*cos(info->m_cc*DEG2RAD);
      info->m_ay = bs*sin(info->m_cc*DEG2RAD);
      info->m_ax = 0;
      info->m_cz = cs*cos(info->m_bb*DEG2RAD);
      info->m_cy = cs*(cos(info->m_aa*DEG2RAD)-cos(info->m_cc*DEG2RAD)*cos(info->m_bb*DEG2RAD))
                     /sin(info->m_cc*DEG2RAD);
      info->m_cx = sqrt(cs*cs - info->m_cz*info->m_cz - info->m_cy*info->m_cy);

      printf("Single_crystal: %s structure a=%g b=%g c=%g aa=%g bb=%g cc=%g ",
        (flag ? "INC" : SC_file), as, bs, cs, info->m_aa, info->m_bb, info->m_cc);
    } else {
      if (!info->recip) {
        printf("Single_crystal: %s structure a=[%g,%g,%g] b=[%g,%g,%g] c=[%g,%g,%g] ",
	       (flag ? "INC" : SC_file), info->m_ax ,info->m_ay ,info->m_az,
	       info->m_bx ,info->m_by ,info->m_bz,
	       info->m_cx ,info->m_cy ,info->m_cz);
      } else {
        printf("Single_crystal: %s structure a*=[%g,%g,%g] b*=[%g,%g,%g] c*=[%g,%g,%g] ",
	       (flag ? "INC" : SC_file), info->m_ax ,info->m_ay ,info->m_az,
	       info->m_bx ,info->m_by ,info->m_bz,
	       info->m_cx ,info->m_cy ,info->m_cz);
      }
    }
    /* Compute reciprocal or direct lattice vectors. */
    if (!info->recip) {
      vec_prod(tmp_x, tmp_y, tmp_z,
	       info->m_bx, info->m_by, info->m_bz,
	       info->m_cx, info->m_cy, info->m_cz);
      info->V0 = fabs(scalar_prod(info->m_ax, info->m_ay, info->m_az, tmp_x, tmp_y, tmp_z));
      printf("V0=%g\n", info->V0);
      
      info->asx = 2*PI/info->V0*tmp_x;
      info->asy = 2*PI/info->V0*tmp_y;
      info->asz = 2*PI/info->V0*tmp_z;
      vec_prod(tmp_x, tmp_y, tmp_z, info->m_cx, info->m_cy, info->m_cz, info->m_ax, info->m_ay, info->m_az);
      info->bsx = 2*PI/info->V0*tmp_x;
      info->bsy = 2*PI/info->V0*tmp_y;
      info->bsz = 2*PI/info->V0*tmp_z;
      vec_prod(tmp_x, tmp_y, tmp_z, info->m_ax, info->m_ay, info->m_az, info->m_bx, info->m_by, info->m_bz);
      info->csx = 2*PI/info->V0*tmp_x;
      info->csy = 2*PI/info->V0*tmp_y;
      info->csz = 2*PI/info->V0*tmp_z;
    } else {
      info->asx = info->m_ax;
      info->asy = info->m_ay;
      info->asz = info->m_az;
      info->bsx = info->m_bx;
      info->bsy = info->m_by;
      info->bsz = info->m_bz;
      info->csx = info->m_cx;
      info->csy = info->m_cy;
      info->csz = info->m_cz;
      
      vec_prod(tmp_x, tmp_y, tmp_z,
	       info->bsx/(2*PI), info->bsy/(2*PI), info->bsz/(2*PI),
	       info->csx/(2*PI), info->csy/(2*PI), info->csz/(2*PI));
      info->V0 = 1/fabs(scalar_prod(info->asx/(2*PI), info->asy/(2*PI), info->asz/(2*PI), tmp_x, tmp_y, tmp_z));
      printf("V0=%g\n", info->V0);
      
      /*compute the direct cell parameters, ofr completeness*/ 
      info->m_ax = tmp_x*info->V0;
      info->m_ay = tmp_y*info->V0;
      info->m_az = tmp_z*info->V0;
      vec_prod(tmp_x, tmp_y, tmp_z,info->csx/(2*PI), info->csy/(2*PI), info->csz/(2*PI),info->asx/(2*PI), info->asy/(2*PI), info->asz/(2*PI));
      info->m_bx = tmp_x*info->V0;
      info->m_by = tmp_y*info->V0;
      info->m_bz = tmp_z*info->V0;
      vec_prod(tmp_x, tmp_y, tmp_z,info->asx/(2*PI), info->asy/(2*PI), info->asz/(2*PI),info->bsx/(2*PI), info->bsy/(2*PI), info->bsz/(2*PI));
      info->m_cx = tmp_x*info->V0;
      info->m_cy = tmp_y*info->V0;
      info->m_cz = tmp_z*info->V0;
    }

    if (flag) return(-1);

    if (!info->column_order[0] || !info->column_order[1] || !info->column_order[2]) {
      fprintf(stderr,
              "Single_crystal: Error: Wrong h,k,l column definition\n");
      return(0);
    }
    if (!info->column_order[3] && !info->column_order[4]) {
      fprintf(stderr,
              "Single_crystal: Error: Wrong F,F2 column definition\n");
      return(0);
    }

    /* allocate hkl_data array */
    list = (struct hkl_data_union*)malloc(size*sizeof(struct hkl_data_union));

    for (i=0; i<size; i++)
    {
      double h=0, k=0, l=0, F2=0;
      double b1[3], b2[3];
      double sig1, sig2, sig3;

      /* get data from table */
      h = Table_Index(sTable, i, info->column_order[0]-1);
      k = Table_Index(sTable, i, info->column_order[1]-1);
      l = Table_Index(sTable, i, info->column_order[2]-1);
      if (info->column_order[3])
      { F2= Table_Index(sTable, i, info->column_order[3]-1); F2 *= F2; }
      else if (info->column_order[4])
        F2= Table_Index(sTable, i, info->column_order[4]-1);

      list[i].h = h;
      list[i].k = k;
      list[i].l = l;
      list[i].F2 = F2;
      
      /* Precompute some values */
      list[i].tau_x = h*info->asx + k*info->bsx + l*info->csx;
      list[i].tau_y = h*info->asy + k*info->bsy + l*info->csy;
      list[i].tau_z = h*info->asz + k*info->bsz + l*info->csz;
      list[i].tau = sqrt(list[i].tau_x*list[i].tau_x +
                         list[i].tau_y*list[i].tau_y +
                         list[i].tau_z*list[i].tau_z);
      list[i].u1x = list[i].tau_x/list[i].tau;
      list[i].u1y = list[i].tau_y/list[i].tau;
      list[i].u1z = list[i].tau_z/list[i].tau;
      sig1 = FWHM2RMS*info->m_delta_d_d*list[i].tau;

      /* Find two arbitrary axes perpendicular to tau and each other. */
      normal_vec(b1[0], b1[1], b1[2],
                 list[i].u1x, list[i].u1y, list[i].u1z);
      vec_prod(b2[0], b2[1], b2[2],
               list[i].u1x, list[i].u1y, list[i].u1z,
               b1[0], b1[1], b1[2]);
               
      /* Find the two mosaic axes perpendicular to tau. */
      if(SC_mosaic > 0) {
        /* Use isotropic mosaic. */
        list[i].u2x = b1[0];
        list[i].u2y = b1[1];
        list[i].u2z = b1[2];
        sig2 = FWHM2RMS*list[i].tau*MIN2RAD*SC_mosaic;
        list[i].u3x = b2[0];
        list[i].u3y = b2[1];
        list[i].u3z = b2[2];
        sig3 = FWHM2RMS*list[i].tau*MIN2RAD*SC_mosaic;
      } else if(SC_mosaic_a > 0 && SC_mosaic_b > 0 && SC_mosaic_c > 0) {
        /* Use anisotropic mosaic. */
        fprintf(stderr,"Single_crystal: Warning: you are using an experimental feature:\n"
          "  anistropic mosaicity. Please examine your data carefully.\n");
        /* compute the jacobian of (tau_v,tau_n) from rotations around the unit cell vectors. */
        struct hkl_data_union *l =&(list[i]);
        double xia_x,xia_y,xia_z,xib_x,xib_y,xib_z,xic_x,xic_y,xic_z;
        /*input parameters are in arc minutes*/
        double sig_fi_a=SC_mosaic_a*MIN2RAD;
        double sig_fi_b=SC_mosaic_b*MIN2RAD;
        double sig_fi_c=SC_mosaic_c*MIN2RAD;
        if(info->m_a==0) info->m_a=sqrt(scalar_prod( info->m_ax,info->m_ay,info->m_az,info->m_ax,info->m_ay,info->m_az));
        if(info->m_b==0) info->m_b=sqrt(scalar_prod( info->m_bx,info->m_by,info->m_bz,info->m_bx,info->m_by,info->m_bz));
        if(info->m_c==0) info->m_c=sqrt(scalar_prod( info->m_cx,info->m_cy,info->m_cz,info->m_cx,info->m_cy,info->m_cz));

        l->u2x = b1[0];
        l->u2y = b1[1];
        l->u2z = b1[2];
        l->u3x = b2[0];
        l->u3y = b2[1];
        l->u3z = b2[2];
                                                                          
        xia_x=l->tau_x-(M_2_PI*h/info->m_a)*info->asx;
        xia_y=l->tau_y-(M_2_PI*h/info->m_a)*info->asy;
        xia_z=l->tau_z-(M_2_PI*h/info->m_a)*info->asz;
        xib_x=l->tau_x-(M_2_PI*h/info->m_b)*info->bsx;
        xib_y=l->tau_y-(M_2_PI*h/info->m_b)*info->bsy;
        xib_z=l->tau_z-(M_2_PI*h/info->m_b)*info->bsz;
        xic_x=l->tau_x-(M_2_PI*h/info->m_c)*info->csx;
        xic_y=l->tau_y-(M_2_PI*h/info->m_c)*info->csy;
        xic_z=l->tau_z-(M_2_PI*h/info->m_c)*info->csz;

        double xia=sqrt(xia_x*xia_x + xia_y*xia_y + xia_z*xia_z);
        double xib=sqrt(xib_x*xib_x + xib_y*xib_y + xib_z*xib_z);
        double xic=sqrt(xic_x*xic_x + xic_y*xic_y + xic_z*xic_z);

        vec_prod(tmp_x,tmp_y,tmp_z,l->tau_x,l->tau_y,l->tau_z, l->u2x,l->u2y,l->u2z);
        double J_n_fia= xia/info->m_a/l->tau*scalar_prod(info->asx,info->asy,info->asz,tmp_x,tmp_y,tmp_z);
        vec_prod(tmp_x,tmp_y,tmp_z,l->tau_x,l->tau_y,l->tau_z, l->u2x,l->u2y,l->u2z);
        double J_n_fib= xib/info->m_b/l->tau*scalar_prod(info->bsx,info->bsy,info->bsz,tmp_x,tmp_y,tmp_z);
        vec_prod(tmp_x,tmp_y,tmp_z,l->tau_x,l->tau_y,l->tau_z, l->u2x,l->u2y,l->u2z);
        double J_n_fic= xic/info->m_c/l->tau*scalar_prod(info->csx,info->csy,info->csz,tmp_x,tmp_y,tmp_z);

        vec_prod(tmp_x,tmp_y,tmp_z,l->tau_x,l->tau_y,l->tau_z, l->u3x,l->u3y,l->u3z);
        double J_v_fia= xia/info->m_a/l->tau*scalar_prod(info->asx,info->asy,info->asz,tmp_x,tmp_y,tmp_z);
        vec_prod(tmp_x,tmp_y,tmp_z,l->tau_x,l->tau_y,l->tau_z, l->u3x,l->u3y,l->u3z);
        double J_v_fib= xib/info->m_b/l->tau*scalar_prod(info->bsx,info->bsy,info->bsz,tmp_x,tmp_y,tmp_z);
        vec_prod(tmp_x,tmp_y,tmp_z,l->tau_x,l->tau_y,l->tau_z, l->u3x,l->u3y,l->u3z);
        double J_v_fic= xic/info->m_c/l->tau*scalar_prod(info->csx,info->csy,info->csz,tmp_x,tmp_y,tmp_z);

        /*with the jacobian we can compute the sigmas in terms of the orthogonal vectors u2 and u3*/
        sig2=sig_fi_a*fabs(J_v_fia) + sig_fi_b*fabs(J_v_fib) + sig_fi_c*fabs(J_v_fic);
        sig3=sig_fi_a*fabs(J_n_fia) + sig_fi_b*fabs(J_n_fib) + sig_fi_c*fabs(J_n_fic);
      } else if (SC_mosaic_AB[0]!=0 && SC_mosaic_AB[1]!=0){
        if ( (SC_mosaic_AB[2]==0 && SC_mosaic_AB[3]==0 && SC_mosaic_AB[4]==0) || (SC_mosaic_AB[5]==0 && SC_mosaic_AB[6]==0 && SC_mosaic_AB[7]==0) ){
          fprintf(stderr,"Single_crystal: Error: in-plane mosaics are specified but one (or both)\n"
              "  in-plane reciprocal vector is the zero vector\n");
          return(0);
        }
        fprintf(stderr,"Single_crystal: Warning: you are using an experimental feature: \n"
              "  \"in-plane\" anistropic mosaicity. Please examine your data carefully.\n");
 
        /*for given reflection in list - compute linear comb of tau_a and tau_b*/
        /*check for not in plane - f.i. check if (tau_a X tau_b).tau_i)==0*/
        struct hkl_data_union *l =&(list[i]);
        double det,c1,c2,sig_tau_c;
        double em_x,em_y,em_z, tmp_x,tmp_y,tmp_z;
        double tau_a[3],tau_b[3];
        /*convert Miller indices to taus*/
        if(info->m_a==0) info->m_a=sqrt(scalar_prod( info->m_ax,info->m_ay,info->m_az,info->m_ax,info->m_ay,info->m_az));
        if(info->m_b==0) info->m_b=sqrt(scalar_prod( info->m_bx,info->m_by,info->m_bz,info->m_bx,info->m_by,info->m_bz));
        if(info->m_c==0) info->m_c=sqrt(scalar_prod( info->m_cx,info->m_cy,info->m_cz,info->m_cx,info->m_cy,info->m_cz));
        tau_a[0]=M_2_PI*( (SC_mosaic_AB[2]/info->m_a)*info->asx + (SC_mosaic_AB[3]/info->m_b)*info->bsx + (SC_mosaic_AB[4]/info->m_c)*info->csx );
        tau_a[1]=M_2_PI*( (SC_mosaic_AB[2]/info->m_a)*info->asy + (SC_mosaic_AB[3]/info->m_b)*info->bsy + (SC_mosaic_AB[4]/info->m_c)*info->csy );
        tau_a[2]=M_2_PI*( (SC_mosaic_AB[2]/info->m_a)*info->asz + (SC_mosaic_AB[3]/info->m_b)*info->bsz + (SC_mosaic_AB[4]/info->m_c)*info->csz );
        tau_b[0]=M_2_PI*( (SC_mosaic_AB[5]/info->m_a)*info->asx + (SC_mosaic_AB[6]/info->m_b)*info->bsx + (SC_mosaic_AB[7]/info->m_c)*info->csx );
        tau_b[1]=M_2_PI*( (SC_mosaic_AB[5]/info->m_a)*info->asy + (SC_mosaic_AB[6]/info->m_b)*info->bsy + (SC_mosaic_AB[7]/info->m_c)*info->csy );
        tau_b[2]=M_2_PI*( (SC_mosaic_AB[5]/info->m_a)*info->asz + (SC_mosaic_AB[6]/info->m_b)*info->bsz + (SC_mosaic_AB[7]/info->m_c)*info->csz );
        
        /*check determinants to see how we should compute the linear combination of a and b (to match c)*/
        if ((det=tau_a[0]*tau_b[1]-tau_a[1]*tau_b[0])!=0){
          c1= (l->tau_x*tau_b[1] - l->tau_y*tau_b[0])/det;
          c2= (tau_a[0]*l->tau_y - tau_a[1]*l->tau_x)/det;
        }else if ((det=tau_a[1]*tau_b[2]-tau_a[2]*tau_b[1])!=0){
          c1= (l->tau_y*tau_b[2] - l->tau_z*tau_b[1])/det;
          c2= (tau_a[1]*l->tau_z - tau_a[2]*l->tau_y)/det;
        }else if ((det=tau_a[0]*tau_b[2]-tau_a[2]*tau_b[0])!=0){
          c1= (l->tau_x*tau_b[2] - l->tau_z*tau_b[0])/det;
          c2= (tau_a[0]*l->tau_z - tau_a[2]*l->tau_x)/det;
        }
        if ((c1==0) && (c2==0)){
          fprintf(stderr,"Single_crystal: Warning: reflection tau[%i]=(%g %g %g) "
          "has no component in defined mosaic plane\n", 
          i, l->tau_x,l->tau_y,l->tau_z);
        }
        /*compute linear combination => sig_tau_i = | c1*sig_tau_a + c2*sig_tau_b |  - also add in the minute to radian scaling factor*/;
        sig_tau_c = MIN2RAD*sqrt(c1*SC_mosaic_AB[0]*c1*SC_mosaic_AB[0] + c2*SC_mosaic_AB[1]*c2*SC_mosaic_AB[1]);
        l->u2x = b1[0]; l->u2y = b1[1]; l->u2z = b1[2];
        l->u3x = b2[0]; l->u3y = b2[1]; l->u3z = b2[2];

        /*so now let's compute the rotation around planenormal tau_a X tau_b*/
        /*g_bar (unit normal of rotation plane) = tau_a X tau_b / norm(tau_a X tau_b)*/
        vec_prod(tmp_x,tmp_y,tmp_z, tau_a[0],tau_a[1],tau_a[2],tau_b[0],tau_b[1],tau_b[2]);
        vec_prod(em_x,em_y,em_z, l->tau_x, l->tau_y, l->tau_z, tmp_x,tmp_y,tmp_z);
        NORM(em_x,em_y,em_z);
        sig2 = l->tau*sig_tau_c*fabs(scalar_prod(em_x,em_y,em_z, l->u2x,l->u2y,l->u2z));
        sig3 = l->tau*sig_tau_c*fabs(scalar_prod(em_x,em_y,em_z, l->u3x,l->u3y,l->u3z));
        /*protect against collapsing gaussians. These seem to be sensible values.*/
        if (sig2<1e-5) sig2=1e-5;
        if (sig3<1e-5) sig3=1e-5;
      }
      else {
        fprintf(stderr,
                "Single_crystal: Error: EITHER mosaic OR (mosaic_a, mosaic_b, mosaic_c)\n"
                "  must be given and be >0.\n");
        return(0);
      }
      list[i].sig123 = sig1*sig2*sig3;
      list[i].m1 = 1/(2*sig1*sig1);
      list[i].m2 = 1/(2*sig2*sig2);
      list[i].m3 = 1/(2*sig3*sig3);
      /* Set Gauss cutoff to 5 times the maximal sigma. */
      if(sig1 > sig2)
        if(sig1 > sig3)
          list[i].cutoff = 5*sig1;
        else
          list[i].cutoff = 5*sig3;
      else
        if(sig2 > sig3)
          list[i].cutoff = 5*sig2;
        else
          list[i].cutoff = 5*sig3;
    }
    Table_Free(&sTable);
    
    /* sort the list with increasing tau */
    qsort(list, i, sizeof(struct hkl_data_union),  SX_list_compare_union);
    
    info->list = list;
    info->count = i;
    info->tau_list = malloc(i*sizeof(*info->tau_list));
    if(!info->tau_list)
    {
      fprintf(stderr, "Single_crystal: Error: Out of memory!\n");
      return(0);
    }
    return(info->count);
  } /* read_hkl_data */

  /* ------------------------------------------------------------------------ */
  /* hkl_search
    search the HKL reflections which are on the Ewald sphere
    input:
      L,T,count,V0: constants for all calls
      kix,kiy,kiz: may be different for each call
    this function returns:
      tau_count (return), coh_refl, coh_xsect, T (updated elements in the array up to [j])
   */
  int hkl_search_union(struct hkl_data_union *L, struct tau_data_union *T, int count, double V0,
    double kix, double kiy, double kiz, double tau_max,
    double *coh_refl, double *coh_xsect)
  {
    double rho, rho_x, rho_y, rho_z;
    double diff;
    int    i,j;
    double ox,oy,oz;
    double b1x,b1y,b1z, b2x,b2y,b2z, kx, ky, kz, nx, ny, nz;
    double n11, n22, n12, det_N, inv_n11, inv_n22, inv_n12, l11, l22, l12,  det_L;
    double Bt_D_O_x, Bt_D_O_y, y0x, y0y, alpha;
    
    double ki = sqrt(kix*kix+kiy*kiy+kiz*kiz);

    /* Common factor in coherent cross-section */
    double xsect_factor = pow(2*PI, 5.0/2.0)/(V0*ki*ki);
    
    for(i = j = 0; i < count; i++)
      {
    /* Assuming reflections are sorted, stop search when max tau exceeded. */
        if(L[i].tau > tau_max)
          break;
        /* Check if this reciprocal lattice point is close enough to the
           Ewald sphere to make scattering possible. */
        rho_x = kix - L[i].tau_x;
        rho_y = kiy - L[i].tau_y;
        rho_z = kiz - L[i].tau_z;
        rho = sqrt(rho_x*rho_x + rho_y*rho_y + rho_z*rho_z);
        diff = fabs(rho - ki);

        /* Check if scattering is possible (cutoff of Gaussian tails). */
        if(diff <= L[i].cutoff)
        {
          /* Store reflection. */
          T[j].index = i;
          /* Get ki vector in local coordinates. */
          kx = kix*L[i].u1x + kiy*L[i].u1y + kiz*L[i].u1z;
          ky = kix*L[i].u2x + kiy*L[i].u2y + kiz*L[i].u2z;
          kz = kix*L[i].u3x + kiy*L[i].u3y + kiz*L[i].u3z;
          T[j].rho_x = kx - L[i].tau;
          T[j].rho_y = ky;
          T[j].rho_z = kz;
          T[j].rho = rho;
          /* Compute the tangent plane of the Ewald sphere. */
          nx = T[j].rho_x/T[j].rho;
          ny = T[j].rho_y/T[j].rho;
          nz = T[j].rho_z/T[j].rho;
          ox = (ki - T[j].rho)*nx;
          oy = (ki - T[j].rho)*ny;
          oz = (ki - T[j].rho)*nz;
          T[j].ox = ox;
          T[j].oy = oy;
          T[j].oz = oz;
          /* Compute unit vectors b1 and b2 that span the tangent plane. */
          normal_vec(b1x, b1y, b1z, nx, ny, nz);
          vec_prod(b2x, b2y, b2z, nx, ny, nz, b1x, b1y, b1z);
          T[j].b1x = b1x;
          T[j].b1y = b1y;
          T[j].b1z = b1z;
          T[j].b2x = b2x;
          T[j].b2y = b2y;
          T[j].b2z = b2z;
          /* Compute the 2D projection of the 3D Gauss of the reflection. */
          /* The symmetric 2x2 matrix N describing the 2D gauss. */
          n11 = L[i].m1*b1x*b1x + L[i].m2*b1y*b1y + L[i].m3*b1z*b1z;
          n12 = L[i].m1*b1x*b2x + L[i].m2*b1y*b2y + L[i].m3*b1z*b2z;
          n22 = L[i].m1*b2x*b2x + L[i].m2*b2y*b2y + L[i].m3*b2z*b2z;
          /* The (symmetric) inverse matrix of N. */
          det_N = n11*n22 - n12*n12;
          inv_n11 = n22/det_N;
          inv_n12 = -n12/det_N;
          inv_n22 = n11/det_N;
          /* The Cholesky decomposition of 1/2*inv_n (lower triangular L). */
          l11 = sqrt(inv_n11/2);
          l12 = inv_n12/(2*l11);
          l22 = sqrt(inv_n22/2 - l12*l12);
          T[j].l11 = l11;
          T[j].l12 = l12;
          T[j].l22 = l22;
          det_L = l11*l22;
          /* The product B^T D o. */
          Bt_D_O_x = b1x*L[i].m1*ox + b1y*L[i].m2*oy + b1z*L[i].m3*oz;
          Bt_D_O_y = b2x*L[i].m1*ox + b2y*L[i].m2*oy + b2z*L[i].m3*oz;
          /* Center of 2D Gauss in plane coordinates. */
          y0x = -(Bt_D_O_x*inv_n11 + Bt_D_O_y*inv_n12);
          y0y = -(Bt_D_O_x*inv_n12 + Bt_D_O_y*inv_n22);
          T[j].y0x = y0x;
          T[j].y0y = y0y;
          /* Factor alpha for the distance of the 2D Gauss from the origin. */
          alpha = L[i].m1*ox*ox + L[i].m2*oy*oy + L[i].m3*oz*oz -
                       (y0x*y0x*n11 + y0y*y0y*n22 + 2*y0x*y0y*n12);
          T[j].refl = xsect_factor*det_L*exp(-alpha)/L[i].sig123; /* intensity of that Bragg */
          *coh_refl += T[j].refl;                                  /* total scatterable intensity */
          T[j].xsect = T[j].refl*L[i].F2;
          *coh_xsect += T[j].xsect;
          j++;
        }
        
      } /* end for */
        return (j); // this is 'tau_count', i.e. number of reachable reflections
    } /* end hkl_search */
    
    int hkl_select_union(struct tau_data_union *T, int tau_count, double coh_refl, double *sum) {
      int j;
      double r = rand0max(coh_refl);
      *sum = 0;
      for(j = 0; j < tau_count; j++)
      {
        *sum += T[j].refl;
        if(*sum > r) break;
      }
      return j;
    }

    /* Functions for "reorientation", powder and PG modes */
    /* Powder, forward */
    void randrotate_union(double *nx, double *ny, double *nz, double a, double b) {
      double nvx, nvy, nvz;
      rotate(nvx,nvy,nvz, *nx, *ny, *nz, a, 1, 0, 0);
      rotate(*nx,*ny,*nz, nvx,nvy,nvz, b, 0, 1, 0);
    }
    /* Powder, back */
    void randderotate_union(double *nx, double *ny, double *nz, double a, double b) {
      double nvx, nvy, nvz;
      rotate(nvx,nvy,nvz,*nx,*ny,*nz, -b, 0, 1, 0);
      rotate(*nx, *ny, *nz, nvx,nvy,nvz, -a, 1, 0, 0);
    }
    /* PG, forward */
    void PGrotate_union(double *nx, double *ny, double *nz, double a, double csx, double csy, double csz) {
      /* Currently assumes c-axis along 'x', ought to be generalized... */
      double nvx, nvy, nvz;
      rotate(nvx,nvy,nvz, *nx, *ny, *nz, a, csx, csy, csz);
      *nx = nvx; *ny = nvy; *nz = nvz;
    }
    /* PG, back */
    void PGderotate_union(double *nx, double *ny, double *nz, double a, double csx, double csy, double csz) {
      /* Currently assumes c-axis along 'x', ought to be generalized... */
      double nvx, nvy, nvz;
      rotate(nvx,nvy,nvz, *nx, *ny, *nz, -a, csx, csy, csz);
      *nx = nvx; *ny = nvy; *nz = nvz;
    }


#endif /* !SINGLE_CRYSTAL_PROCESS_DECL */

// Very important to add a pointer to this struct in the Union_functions.c file
struct Single_crystal_physics_storage_struct{
    // Variables that needs to be transfered between any of the following places:
    // The initialize in this component
    // The function for calculating my
    // The function for calculating scattering
    
    // Avoid duplicates of output parameters and setting parameters in naming
    double PG_setting;     // 0 if PG mode is diabled, 1 if enabled. Values between apporximates texture?
    double powder_setting; // 0 if powder mode is disabled, 1 if enabled. Values between approximates texture?
    double Alpha;          // random angle between 0 and 2*Pi*powder
    double Beta;           // random angle between -Pi/2 and Pi/2
    
    struct hkl_info_struct_union *hkl_info_storage; // struct containing all necessary info for SC
    double pack; // packing factor
    double barns_setting; // Sets wether barns of fm^2 is used
};

// Function for calculating my, the inverse penetration depth (for only this scattering process).
// The input for this function and its order may not be changed, but the names may be updated.
int Single_crystal_physics_my(double *my, double *k_initial, union data_transfer_union data_transfer, struct focus_data_struct *focus_data) {
    // *k_initial is a pointer to a simple vector with 3 doubles, k[0], k[1], k[2] which describes the wavevector
    double kix = k_initial[0],kiy = k_initial[1],kiz = k_initial[2];
    double ki = sqrt(k_initial[0]*k_initial[0]+k_initial[1]*k_initial[1]+k_initial[2]*k_initial[2]);
    
    struct hkl_info_struct_union *hkl_info = data_transfer.pointer_to_a_Single_crystal_physics_storage_struct->hkl_info_storage;
    
    // Need the Powder/PG/curvature mode rotate added here
    
    // Taken from Single_crystal and changed hkl_info to a pointer.
    // The split optimization is less useful here than normally
    
    if (data_transfer.pointer_to_a_Single_crystal_physics_storage_struct->powder_setting) {
      //orientation of crystallite is random
	  data_transfer.pointer_to_a_Single_crystal_physics_storage_struct->Alpha = randpm1()*PI*data_transfer.pointer_to_a_Single_crystal_physics_storage_struct->powder_setting;
	  data_transfer.pointer_to_a_Single_crystal_physics_storage_struct->Beta = randpm1()*PI/2;
      
	  randrotate_union(&kix, &kiy, &kiz,
        data_transfer.pointer_to_a_Single_crystal_physics_storage_struct->Alpha,
        data_transfer.pointer_to_a_Single_crystal_physics_storage_struct->Beta);
    }
    if (data_transfer.pointer_to_a_Single_crystal_physics_storage_struct->PG_setting) {
      // orientation of crystallite is random
      data_transfer.pointer_to_a_Single_crystal_physics_storage_struct->Alpha = rand01()*2*PI*data_transfer.pointer_to_a_Single_crystal_physics_storage_struct->PG_setting;
	  PGrotate_union(&kix, &kiy, &kiz,
        data_transfer.pointer_to_a_Single_crystal_physics_storage_struct->Alpha,
        hkl_info->csx, hkl_info->csy, hkl_info->csz);
    }
    
    /* in case we use 'SPLIT' then consecutive neutrons can be identical when entering here
         and we may skip the hkl_search call */
    if ( fabs(kix - hkl_info->kix) < 1e-6
        && fabs(kiy - hkl_info->kiy) < 1e-6
        && fabs(kiz - hkl_info->kiz) < 1e-6) {
        hkl_info->nb_reuses++;
      } else {
        /* Max possible tau for this ki with 5*sigma delta-d/d cutoff. */
        double tau_max   = 2*ki/(1 - 5*hkl_info->m_delta_d_d);
        double coh_xsect = 0, coh_refl = 0;
        
        /* call hkl_search */
        hkl_info->tau_count = hkl_search_union(hkl_info->list, hkl_info->tau_list, hkl_info->count, hkl_info->V0, kix, kiy, kiz, tau_max, &coh_refl, &coh_xsect); /* CPU consuming */
          
        // This is problematic as there is no way to know if this is the first scattering in this material or not with the current structure.
        // Need to do one of the following:
        //  remove this optimization
        //  find a way to set event_counter to 0 when a neutron enters a volume with a SC process
        //  pass the number of scatterings in this volume to all my functions
        // temporary solution: all events are considered the first
        int event_counter = 0;
        
        
        /* store ki so that we can check for further SPLIT iterations */
        if (event_counter == 0 ) { /* only for incoming neutron */
          hkl_info->kix = kix;
          hkl_info->kiy = kiy;
          hkl_info->kiz = kiz;
        }
        
        hkl_info->coh_refl  = coh_refl;
        hkl_info->coh_xsect = coh_xsect;
        hkl_info->nb_refl += hkl_info->tau_count;
        hkl_info->nb_refl_count++;
        
        
      }

      /* (3). Probabilities of the different possible interactions. */
      //tot_xsect = abs_xsect + inc_xsect + hkl_info.coh_xsect;
      /* Cross-sections are in barns = 10**-28 m**2, and unit cell volumes are
         in AA**3 = 10**-30 m**2. Hence a factor of 100 is used to convert
         scattering lengths to m**-1 */
      double coh_xlen = hkl_info->coh_xsect/hkl_info->V0;
      if (data_transfer.pointer_to_a_Single_crystal_physics_storage_struct->barns_setting) {
        coh_xlen *= 100;
      }
    
      //printf("Single crystal process returned coh_xlen = %E \n",coh_xlen);
      *my = coh_xlen*data_transfer.pointer_to_a_Single_crystal_physics_storage_struct->pack;
      int iterate;
      //if (hkl_info->tau_count == 0) printf("my: ki=%f, no reflections matched \n",ki);
      for (iterate=0;iterate<hkl_info->tau_count;iterate++)
        //printf("my: ki=%f, hkl_info->coh_xsect = %f, T[%d].refl = %f, coh_xlen = %f \n",ki,hkl_info->coh_xsect,iterate,hkl_info->tau_list[iterate].refl,coh_xlen);
      // Probably need to rotate back from Powder/PG/curvature mode, as another process than this one could be selected. Would just need to send the used rotation parameters to the process to repeat that rotation.
    
    return 1;
};

// Function that provides description of a basic scattering event.
// Do not change the
int Single_crystal_physics_scattering(double *k_final, double *k_initial, double *weight, union data_transfer_union data_transfer, struct focus_data_struct *focus_data) {

    int i;                        /* Index into structure factor list */
    struct hkl_data_union *L;     /* Structure factor list */
    int j;                        /* Index into reflection list */
    struct tau_data_union *T;     /* List of reflections close to Ewald sphere */
    //double ox, oy, oz;            /* Origin of Ewald sphere tangent plane */
    //double l11, l12, l22;         /* Cholesky decomposition L of 1/2*inv(N) */
    double b1x, b1y, b1z;         /* First vector spanning tangent plane */
    double b2x, b2y, b2z;         /* Second vector spanning tangent plane */
    double z1, z2, y1, y2;        /* Temporaries to choose kf from 2D Gauss */
    double adjust, r, sum;        /* Temporaries */
    double kfx, kfy, kfz;         /* Final wave vector */

    double kix = k_initial[0],kiy = k_initial[1],kiz = k_initial[2];
    double ki = sqrt(k_initial[0]*k_initial[0]+k_initial[1]*k_initial[1]+k_initial[2]*k_initial[2]);
    
    struct hkl_info_struct_union *hkl_info = data_transfer.pointer_to_a_Single_crystal_physics_storage_struct->hkl_info_storage;
    
    L = hkl_info->list;
    T = hkl_info->tau_list;
    
    
    // Taken from Single_crystal.comp
    if(hkl_info->coh_refl <= 0){
          return 0; // Return 0 will use ABSORB in main component (as it is not allowed in a function)
    }
    sum = 0;
    j = hkl_select_union(T, hkl_info->tau_count, hkl_info->coh_refl, &sum);
    //printf("Selected j = %d with T[%d].refl = %f \n",j,j,T[j].refl);

    if(j >= hkl_info->tau_count)
    {
      if (hkl_info->flag_warning < 100)
        fprintf(stderr, "Single_crystal_process: Error: Illegal tau search "
          "(r=%g, sum=%g, j=%i, tau_count=%i).\n", r, sum, j , hkl_info->tau_count);
      hkl_info->flag_warning++;
      j = hkl_info->tau_count - 1;
    }
    i = T[j].index;
    /* (8). Pick scattered wavevector kf from 2D Gauss distribution. */
    z1 = randnorm();
    z2 = randnorm();
    y1 = T[j].l11*z1 + T[j].y0x;
    y2 = T[j].l12*z1 + T[j].l22*z2 + T[j].y0y;
    kfx = T[j].rho_x + T[j].ox + T[j].b1x*y1 + T[j].b2x*y2;
    kfy = T[j].rho_y + T[j].oy + T[j].b1y*y1 + T[j].b2y*y2;
    kfz = T[j].rho_z + T[j].oz + T[j].b1z*y1 + T[j].b2z*y2;
    /* Normalize kf to length of ki, to account for planer
      approximation of the Ewald sphere. */
    adjust = ki/sqrt(kfx*kfx + kfy*kfy + kfz*kfz);
    kfx *= adjust;
    kfy *= adjust;
    kfz *= adjust;
    /* Adjust neutron weight (see manual for explanation). */
    *weight *= T[j].xsect*hkl_info->coh_refl/(hkl_info->coh_xsect*T[j].refl);
    //printf("SCATTERING: hkl_info->coh_refl=%f, hkl_info->coh_xsect = %f, T[%d].refl = %f, hkl_info->tau.count = %d \n",hkl_info->coh_refl,hkl_info->coh_xsect,j,T[j].refl,hkl_info->tau_count);

    // These is the returned final wavevector
    k_final[0] = L[i].u1x*kfx + L[i].u2x*kfy + L[i].u3x*kfz;
    k_final[1] = L[i].u1y*kfx + L[i].u2y*kfy + L[i].u3y*kfz;
    k_final[2] = L[i].u1z*kfx + L[i].u2z*kfy + L[i].u3z*kfz;
    
    if (data_transfer.pointer_to_a_Single_crystal_physics_storage_struct->powder_setting) {
      // orientation of crystallite is no longer random
	  randderotate_union(&k_final[0], &k_final[1], &k_final[2], data_transfer.pointer_to_a_Single_crystal_physics_storage_struct->Alpha, data_transfer.pointer_to_a_Single_crystal_physics_storage_struct->Beta);
    }
    if (data_transfer.pointer_to_a_Single_crystal_physics_storage_struct->PG_setting) {
      // orientation of crystallite is longer random
	  PGderotate_union(&k_final[0], &k_final[1], &k_final[2], data_transfer.pointer_to_a_Single_crystal_physics_storage_struct->Alpha, hkl_info->csx, hkl_info->csy, hkl_info->csz);
    }

    hkl_info->type = 'c';
    hkl_info->h    = L[i].h;
    hkl_info->k    = L[i].k;
    hkl_info->l    = L[i].l;

    return 1;
};

#line 9370 "MACS_sample_kidney_box.c"

/* Shared user declarations for all components 'Virtual_input'. */
#line 74 "/usr/share/mcstas/2.7/obsolete/Virtual_input.comp"


long Virtual_input_Read_Input(char *aFile, char *aType, t_Table *aTable, long *aOffset)
  {
    long max_lines = 50000;
    long length=0;
    char bType[32];

    if (!aFile) return (0);
    if (aType) strcpy(bType, aType);
    else strcpy(bType, "???");

    Table_Free(aTable);

    /* Try to Open neutron input text filename. */
    if((aFile && aType == NULL) || !strcmp(bType,"text")) {
      Table_Read_Offset(aTable, aFile, 0, aOffset, max_lines);  /* read data from filename into rTable */
      strcpy(bType, "text");
    }
    if (!aTable->data && aType && aType[0] != 't')
      Table_Read_Offset_Binary(aTable, aFile, aType, aOffset, max_lines, 11);

    return(aTable->rows);
  }
#line 9398 "MACS_sample_kidney_box.c"

/* Shared user declarations for all components 'Union_box'. */
#line 78 "Union_box.comp"
#ifndef Union
#define Union $Revision: 0.8 $

#include "Union_functions.c"
#include "Union_initialization.c"

#endif


void mcdisplay_box_function(struct lines_to_draw *lines_to_draw_output,int index, struct geometry_struct **Geometries,int number_of_volumes) {
    // Function to call in mcdisplay section of the sample component for this volume
    // One can assume that Volumes[index] refers to a volume with the geometry described in this file
    
    double depth = Geometries[index]->geometry_parameters.p_box_storage->z_depth;
    double width1 = Geometries[index]->geometry_parameters.p_box_storage->x_width1;
    double width2 = Geometries[index]->geometry_parameters.p_box_storage->x_width2;
    double height1 = Geometries[index]->geometry_parameters.p_box_storage->y_height1;
    double height2 = Geometries[index]->geometry_parameters.p_box_storage->y_height2;
    
    Coords x_vector = Geometries[index]->geometry_parameters.p_box_storage->x_vector;
    Coords y_vector = Geometries[index]->geometry_parameters.p_box_storage->y_vector;
    Coords z_vector = Geometries[index]->geometry_parameters.p_box_storage->z_vector;
    
    Coords center = Geometries[index]->center;
    
    Coords square1[4],square2[4];
    
    square1[0] = coords_add(coords_add(coords_add(center,coords_scalar_mult(z_vector,-0.5*depth)),coords_scalar_mult(x_vector,-0.5*width1)),coords_scalar_mult(y_vector,-0.5*height1));
    
    square1[1] = coords_add(square1[0],coords_scalar_mult(x_vector,width1));
    square1[2] = coords_add(square1[1],coords_scalar_mult(y_vector,height1));
    square1[3] = coords_add(square1[0],coords_scalar_mult(y_vector,height1));
    
    square2[0] = coords_add(coords_add(coords_add(center,coords_scalar_mult(z_vector,0.5*depth)),coords_scalar_mult(x_vector,-0.5*width2)),coords_scalar_mult(y_vector,-0.5*height2));
    
    square2[1] = coords_add(square2[0],coords_scalar_mult(x_vector,width2));
    square2[2] = coords_add(square2[1],coords_scalar_mult(y_vector,height2));
    square2[3] = coords_add(square2[0],coords_scalar_mult(y_vector,height2));
    
    struct lines_to_draw lines_to_draw_temp;
    lines_to_draw_temp.number_of_lines = 0;
    
    int iterate;
    for (iterate=0;iterate<3;iterate++) {
        lines_to_draw_temp = draw_line_with_highest_priority(square1[iterate],square1[iterate+1],index,Geometries,number_of_volumes,2);
        merge_lines_to_draw(lines_to_draw_output,&lines_to_draw_temp);
    }
    lines_to_draw_temp = draw_line_with_highest_priority(square1[3],square1[0],index,Geometries,number_of_volumes,2);
    merge_lines_to_draw(lines_to_draw_output,&lines_to_draw_temp);

    for (iterate=0;iterate<3;iterate++) {
        lines_to_draw_temp = draw_line_with_highest_priority(square2[iterate],square2[iterate+1],index,Geometries,number_of_volumes,2);
        merge_lines_to_draw(lines_to_draw_output,&lines_to_draw_temp);
    }
    lines_to_draw_temp = draw_line_with_highest_priority(square2[3],square2[0],index,Geometries,number_of_volumes,2);
    merge_lines_to_draw(lines_to_draw_output,&lines_to_draw_temp);

    for (iterate=0;iterate<4;iterate++) {
        lines_to_draw_temp = draw_line_with_highest_priority(square1[iterate],square2[iterate],index,Geometries,number_of_volumes,2);
        merge_lines_to_draw(lines_to_draw_output,&lines_to_draw_temp);
    }
};

void initialize_box_geometry_from_main_component(struct geometry_struct *box) {
    // Function to be called in initialize of the main component
    // This is done as the rotation matrix needs to be relative to the main component instead of global
    // Everything done in initialize in this component file has the rotation matrix relative to global
    Coords simple_vector = coords_set(1,0,0);
    Coords rotated_vector;
    
    rotated_vector = rot_apply(box->rotation_matrix,simple_vector);
    NORM(rotated_vector.x,rotated_vector.y,rotated_vector.z);
    box->geometry_parameters.p_box_storage->x_vector = rotated_vector;
    
    simple_vector = coords_set(0,1,0);
    rotated_vector = rot_apply(box->rotation_matrix,simple_vector);
    NORM(rotated_vector.x,rotated_vector.y,rotated_vector.z);
    box->geometry_parameters.p_box_storage->y_vector = rotated_vector;
    
    simple_vector = coords_set(0,0,1);
    rotated_vector = rot_apply(box->rotation_matrix,simple_vector);
    NORM(rotated_vector.x,rotated_vector.y,rotated_vector.z);
    box->geometry_parameters.p_box_storage->z_vector = rotated_vector;
};

struct pointer_to_1d_coords_list box_shell_points(struct geometry_struct *geometry,int max_number_of_points) {
  // This function returns an array of corner positions for the box in the main coordinate system.
  // Normally one would limit it to a maximum number of points, but as there are only 8 for the box,
  //  it is hardcoded to 8. Other geometries can be approximated with a variable number of points.
  
  struct pointer_to_1d_coords_list corner_points;
  corner_points.elements = malloc(8*sizeof(Coords));
  corner_points.num_elements = 8;
  
  double depth = geometry->geometry_parameters.p_box_storage->z_depth;
  double width1 = geometry->geometry_parameters.p_box_storage->x_width1;
  double width2 = geometry->geometry_parameters.p_box_storage->x_width2;
  double height1 = geometry->geometry_parameters.p_box_storage->y_height1;
  double height2 = geometry->geometry_parameters.p_box_storage->y_height2;
    
  Coords x_vector = geometry->geometry_parameters.p_box_storage->x_vector;
  Coords y_vector = geometry->geometry_parameters.p_box_storage->y_vector;
  Coords z_vector = geometry->geometry_parameters.p_box_storage->z_vector;
    
  Coords center = geometry->center;
    
  corner_points.elements[0] = coords_add(coords_add(coords_add(center,coords_scalar_mult(z_vector,-0.5*depth)),coords_scalar_mult(x_vector,-0.5*width1)),coords_scalar_mult(y_vector,-0.5*height1));
    
  corner_points.elements[1] = coords_add(corner_points.elements[0],coords_scalar_mult(x_vector,width1));
  corner_points.elements[2] = coords_add(corner_points.elements[1],coords_scalar_mult(y_vector,height1));
  corner_points.elements[3] = coords_add(corner_points.elements[0],coords_scalar_mult(y_vector,height1));
    
  corner_points.elements[4] = coords_add(coords_add(coords_add(center,coords_scalar_mult(z_vector,0.5*depth)),coords_scalar_mult(x_vector,-0.5*width2)),coords_scalar_mult(y_vector,-0.5*height2));
    
  corner_points.elements[5] = coords_add(corner_points.elements[4],coords_scalar_mult(x_vector,width2));
  corner_points.elements[6] = coords_add(corner_points.elements[5],coords_scalar_mult(y_vector,height2));
  corner_points.elements[7] = coords_add(corner_points.elements[4],coords_scalar_mult(y_vector,height2));
  
  return corner_points;

}

#line 9524 "MACS_sample_kidney_box.c"

/* Shared user declarations for all components 'Union_cylinder'. */
#line 74 "Union_cylinder.comp"
#ifndef Union
#define Union $Revision: 0.8 $

#include "Union_functions.c"
#include "Union_initialization.c"

#endif


void mcdisplay_cylinder_function(struct lines_to_draw *lines_to_draw_output,int index, struct geometry_struct **Geometries,int number_of_volumes) {
    // Function to call in mcdisplay section of the sample component for this volume
    // One can assume that Geometries[index] refers to a geometry as described in this file
    // The 4 lines describin the cylinders side are aligned to the local frame of the cylinder,
    //   it would be nicer to have them alligned with the global frame so that they show up nicely in
    //   pgplotters on mcdisplay.
    // One could get the current global rotation and use this to counteract this effect.
    
    double height = Geometries[index]->geometry_parameters.p_cylinder_storage->height;
    double radius = Geometries[index]->geometry_parameters.p_cylinder_storage->cyl_radius;
    Coords direction = Geometries[index]->geometry_parameters.p_cylinder_storage->direction_vector;
    Coords center = Geometries[index]->center;
    
    Coords bottom_point = coords_add(center,coords_scalar_mult(direction,0.5*height));
    Coords top_point = coords_add(center,coords_scalar_mult(direction,-0.5*height));
    
    struct lines_to_draw lines_to_draw_temp;
    lines_to_draw_temp.number_of_lines = 0;
    
    lines_to_draw_temp = draw_circle_with_highest_priority(top_point,direction,radius,index,Geometries,number_of_volumes,2);
    merge_lines_to_draw(lines_to_draw_output,&lines_to_draw_temp);

    lines_to_draw_temp = draw_circle_with_highest_priority(bottom_point,direction,radius,index,Geometries,number_of_volumes,2);
    merge_lines_to_draw(lines_to_draw_output,&lines_to_draw_temp);
    
    Coords point1,point2;
    int iterate,number_of_points=4;
    
    for (iterate=0;iterate<number_of_points;iterate++) {
        point1 = point_on_circle(top_point,direction,radius,iterate,number_of_points);
        point2 = point_on_circle(bottom_point,direction,radius,iterate,number_of_points);
        lines_to_draw_temp = draw_line_with_highest_priority(point1,point2,index,Geometries,number_of_volumes,2);
        merge_lines_to_draw(lines_to_draw_output,&lines_to_draw_temp);
    }
};

void initialize_cylinder_geometry_from_main_component(struct geometry_struct *cylinder) {
    // Function to be called in initialize of the main component
    // This is done as the rotation matrix needs to be relative to the main component instead of global
    // Everything done in initialize in this component file has the rotation matrix relative to global
    
    Coords simple_vector;
    Coords cyl_vector;
    
    // Start with vector that points along the cylinder in the local frame
    simple_vector = coords_set(0,1,0);

    // Rotate the direction vector of the cylinder to the master component frame of reference
    cyl_vector = rot_apply(cylinder->rotation_matrix,simple_vector);
    NORM(cyl_vector.x,cyl_vector.y,cyl_vector.z);
    cylinder->geometry_parameters.p_cylinder_storage->direction_vector.x = cyl_vector.x;
    cylinder->geometry_parameters.p_cylinder_storage->direction_vector.y = cyl_vector.y;
    cylinder->geometry_parameters.p_cylinder_storage->direction_vector.z = cyl_vector.z;
    // if (verbal == 1) printf("Cords vector1 = (%f,%f,%f)\n",cyl_vector.x,cyl_vector.y,
}

struct pointer_to_1d_coords_list cylinder_shell_points(struct geometry_struct *geometry,int max_number_of_points) {
  // Function that returns a number (less than max) of points on the geometry surface
  // If used, remember to free the space allocated.
  int points_per_circle = floor(max_number_of_points/2.0);
  
  struct pointer_to_1d_coords_list cylinder_shell_array;
  cylinder_shell_array.elements = malloc(2*points_per_circle*sizeof(Coords));
  cylinder_shell_array.num_elements = 2*points_per_circle;
  
  Coords cyl_direction = geometry->geometry_parameters.p_cylinder_storage->direction_vector;
  Coords center = geometry->center;
  double radius = geometry->geometry_parameters.p_cylinder_storage->cyl_radius;
  double height = geometry->geometry_parameters.p_cylinder_storage->height;
  
  Coords cyl_top_point = coords_add(center,coords_scalar_mult(cyl_direction,0.5*height));
  Coords cyl_bottom_point = coords_add(center,coords_scalar_mult(cyl_direction,-0.5*height));
  
  points_on_circle(cylinder_shell_array.elements,cyl_top_point,cyl_direction,radius,points_per_circle);
  // Need to verify this pointer arithimatic works as intended
  points_on_circle(cylinder_shell_array.elements+points_per_circle,cyl_bottom_point,cyl_direction,radius,points_per_circle);
  
  return cylinder_shell_array;
}

#line 9617 "MACS_sample_kidney_box.c"

/* Shared user declarations for all components 'Union_master'. */
#line 54 "Union_master.comp"
#ifndef Union
#define Union $Revision: 0.9 $

#include "Union_functions.c"
#include "Union_initialization.c"

#endif
// TEST
struct logger_with_data_struct loggers_with_data_array;
#line 9630 "MACS_sample_kidney_box.c"

/* Shared user declarations for all components 'Res_sample'. */
#line 71 "/usr/share/mcstas/2.7/samples/Res_sample.comp"
struct Res_sample_struct
{
double ki_x,ki_y,ki_z,kf_x,kf_y,kf_z;
double rx,ry,rz,pi;
char   isrect;      /* true when sample is a box */
double aw,ah;       /* rectangular angular dimensions */
double xw,yh;       /* rectangular metrical dimensions */
double tx,ty,tz;    /* target coords */
};
#line 9643 "MACS_sample_kidney_box.c"

/* Shared user declarations for all components 'PSD_monitor'. */
#line 57 "/usr/share/mcstas/2.7/monitors/PSD_monitor.comp"

#ifndef ARRAYS_H
#define ARRAYS_H
typedef double* DArray1d;
DArray1d create_darr1d(int n);
void destroy_darr1d(DArray1d a);

typedef double** DArray2d;
DArray2d create_darr2d(int nx, int ny);
void destroy_darr2d(DArray2d a);

typedef double*** DArray3d;
DArray3d create_darr3d(int nx, int ny, int nz);
void destroy_darr3d(DArray3d a);
#endif
#ifndef ARRAYS_C
#define ARRAYS_C
#include <stdlib.h>

DArray1d create_darr1d(int n){
  DArray1d arr2d;
  arr2d = calloc(n, sizeof(double));
  return arr2d;
}
void destroy_darr1d(DArray1d a){
  free(a);
}

DArray2d create_darr2d(int nx, int ny){
  DArray2d arr2d;
  arr2d = calloc(nx, sizeof(double *));

  double *p1;
  p1 = calloc(nx*ny, sizeof(double));

  int i;
  for (i=0; i<nx; i++){
    arr2d[i] = &(p1[i*ny]);
  }
  return arr2d;
}
void destroy_darr2d(DArray2d a){
  free(a[0]);
  free(a);
}

DArray3d create_darr3d(int nx, int ny, int nz){
  DArray3d arr3d;
  int i, j;

  // 1d
  arr3d = calloc(nx, sizeof(double **));

  // d2
  double **p1;
  p1 = calloc(nx*ny, sizeof(double *));

  for (i=0; i<nx; i++){
    arr3d[i] = &(p1[i*ny]);
  }

  // 3d
  double *p2;
  p2 = calloc(nx*ny*nz, sizeof(double));
  for (i=0; i<nx; i++){
    for (j=0; j<ny; j++){
      arr3d[i][j] = &(p2[(i*ny+j)*nz]);
    }
  }
  return arr3d;
}
void destroy_darr3d(DArray3d a){
  free(a[0][0]);
  free(a[0]);
  free(a);
}
#endif

#line 9725 "MACS_sample_kidney_box.c"

/* Instrument parameters. */
MCNUM mcipA3_angle;
MCNUM mcipkidney_angle;
MCNUM mcipEM;
MCNUM mcipEF_all;
int mcipHF;
int mcipVF;
MCNUM mcipsample_diameter_d;
MCNUM mcipbeta_1;
MCNUM mcipbeta_2;
MCNUM mcipCPF;
MCNUM mcipMPL;
MCNUM mcipMPD;
MCNUM mcipAPE_h;
MCNUM mcipAPE_v;
MCNUM mcipmisalign_mono_deg;
MCNUM mcipDIRDEV;
MCNUM mcipDIVSOU;
MCNUM mcipL0_delta;
MCNUM mcipL1_delta;
MCNUM mcipmon_t;
MCNUM mcipmon_e;
MCNUM mcipmonrot_delta;
MCNUM mcipslit_h;
MCNUM mcipslit_v;
MCNUM mcipresolution_mode;
MCNUM mcipres_radius;
MCNUM mcipres_height;
int mciprepeat_count;
MCNUM mcipE0_resolution;
MCNUM mcipdE_resolution;

#define mcNUMIPAR 30
int mcnumipar = 30;
struct mcinputtable_struct mcinputtable[mcNUMIPAR+1] = {
  "A3_angle", &mcipA3_angle, instr_type_double, "0", 
  "kidney_angle", &mcipkidney_angle, instr_type_double, "0", 
  "EM", &mcipEM, instr_type_double, "3.4", 
  "EF_all", &mcipEF_all, instr_type_double, "3.4", 
  "HF", &mcipHF, instr_type_int, "1", 
  "VF", &mcipVF, instr_type_int, "1", 
  "sample_diameter_d", &mcipsample_diameter_d, instr_type_double, "0.02", 
  "beta_1", &mcipbeta_1, instr_type_double, "1", 
  "beta_2", &mcipbeta_2, instr_type_double, "1", 
  "CPF", &mcipCPF, instr_type_double, "0", 
  "MPL", &mcipMPL, instr_type_double, "6.06", 
  "MPD", &mcipMPD, instr_type_double, "0.775", 
  "APE_h", &mcipAPE_h, instr_type_double, "0.35", 
  "APE_v", &mcipAPE_v, instr_type_double, "0.35", 
  "misalign_mono_deg", &mcipmisalign_mono_deg, instr_type_double, "0.15", 
  "DIRDEV", &mcipDIRDEV, instr_type_double, "0", 
  "DIVSOU", &mcipDIVSOU, instr_type_double, "3.0", 
  "L0_delta", &mcipL0_delta, instr_type_double, "-1.06", 
  "L1_delta", &mcipL1_delta, instr_type_double, "0.0", 
  "mon_t", &mcipmon_t, instr_type_double, "0.0", 
  "mon_e", &mcipmon_e, instr_type_double, "0.0", 
  "monrot_delta", &mcipmonrot_delta, instr_type_double, "0", 
  "slit_h", &mcipslit_h, instr_type_double, "0.2", 
  "slit_v", &mcipslit_v, instr_type_double, "0.2", 
  "resolution_mode", &mcipresolution_mode, instr_type_double, "0", 
  "res_radius", &mcipres_radius, instr_type_double, "0.01", 
  "res_height", &mcipres_height, instr_type_double, "0.03", 
  "repeat_count", &mciprepeat_count, instr_type_int, "1", 
  "E0_resolution", &mcipE0_resolution, instr_type_double, "0", 
  "dE_resolution", &mcipdE_resolution, instr_type_double, "1", 
  NULL, NULL, instr_type_double, ""
};

/* User declarations from instrument definition. */
#define mccompcurname  dmtas
#define mccompcurtype  INSTRUMENT
#define mccompcurindex 0
#define mcposadmtas coords_set(0,0,0)
#define A3_angle mcipA3_angle
#define kidney_angle mcipkidney_angle
#define EM mcipEM
#define EF_all mcipEF_all
#define HF mcipHF
#define VF mcipVF
#define sample_diameter_d mcipsample_diameter_d
#define beta_1 mcipbeta_1
#define beta_2 mcipbeta_2
#define CPF mcipCPF
#define MPL mcipMPL
#define MPD mcipMPD
#define APE_h mcipAPE_h
#define APE_v mcipAPE_v
#define misalign_mono_deg mcipmisalign_mono_deg
#define DIRDEV mcipDIRDEV
#define DIVSOU mcipDIVSOU
#define L0_delta mcipL0_delta
#define L1_delta mcipL1_delta
#define mon_t mcipmon_t
#define mon_e mcipmon_e
#define monrot_delta mcipmonrot_delta
#define slit_h mcipslit_h
#define slit_v mcipslit_v
#define resolution_mode mcipresolution_mode
#define res_radius mcipres_radius
#define res_height mcipres_height
#define repeat_count mciprepeat_count
#define E0_resolution mcipE0_resolution
#define dE_resolution mcipdE_resolution
#line 53 "MACS_sample_kidney_box.instr"

  #define MAX_VOLUME_HISTORY_LENGTH 50
  #define DOUBLE_MAX_VOLUME_HISTORY_LENGTH 100
  
void splint(double xa[], double ya[], double y2a[], long n, double x, double *y)
{
	//void nrerror(char error_text[]);
	long klo,khi,k;
	double h,b,a;

	klo=1;
	khi=n;
	while (khi-klo > 1) {
		k=(khi+klo) >> 1;
		if (xa[k] > x) khi=k;
		else klo=k;
	}
	h=xa[khi]-xa[klo];
	//if (h == 0.0) nrerror("Bad xa input to routine splint");
	a=(xa[khi]-x)/h;
	b=(x-xa[klo])/h;
	*y=a*ya[klo]+b*ya[khi]+((a*a*a-a)*y2a[klo]+(b*b*b-b)*y2a[khi])*(h*h)/6.0;
}
/* (C) Copr. 1986-92 Numerical Recipes Software *1(.|a. */

/*Using the same definition of coordinate systems as in Monochromator.comp
  Counterclockwise rotation of the coordinate system is positive. */
void dmtas_rotate(double *x,double *y,double *z,double *vx,double *vy,
  double *vz,double r, double theta, double ang)
{
 double old_x=*x,old_y=*y,old_vx=*vx,old_vy=*vy,cos_t,sin_t;
 cos_t	=	cos(theta);
 sin_t	=	sin(theta);
 *x	=	r*ang+(old_x-r*ang)*cos_t-old_y*sin_t;
 *y	=	(old_x-r*ang)*sin_t+old_y*cos_t;
 *vx	=	old_vx*cos_t-old_vy*sin_t;
 *vy	=	old_vx*sin_t+old_vy*cos_t;
 /*z and vz remain the same.*/
}


void dmtas_rotate1(double *x,double *y,double *z,double *vx,double *vy,
  double *vz,double r, double theta)
{
 double old_x=*x,old_y=*y,old_vx=*vx,old_vy=*vy,cos_t,sin_t;
 cos_t	=	cos(theta);
 sin_t	=	sin(theta);
 *x	=	r+(old_x-r)*cos_t-old_y*sin_t;
 *y	=	(old_x-r)*sin_t+old_y*cos_t;
 *vx	=	old_vx*cos_t-old_vy*sin_t;
 *vy	=	old_vx*sin_t+old_vy*cos_t;
 /*z and vz remain the same.*/
}
/*A copy of the codes from monochromator.comp*/
void dmtas_analyzerblade(double div_cutoff, double zmin,double zmax,
  double ymin, double ymax, double mosaich, double mosaicv, double r0, 
  double Q, double *x, double *y, double *z, double *vx, double *vy, 
  double *vz, double *t, double *sx, double *sy, double *sz, double *p)
{
 double dphi, tmp1,tmp2,tmp3,vratio,phi,theta0,theta,v,cs,sn;
 double old_x=*x, old_y=*y,old_z=*z,old_t=*t;
 double dt;
 dt	=-(*x)/(*vx);
 if(*vx !=0.0 && dt>=0.0)
 {
	*y+=(*vy)*dt;*z+=(*vz)*dt;*t+=dt;*x=0.0;
	if(*z>zmin && *z<zmax && *y>ymin && *y<ymax)
	{
		/*First:scattering in plane*/
		theta0	=atan2(*vx,*vz); /*neutron angle to slab */
		v	=sqrt((*vx)*(*vx)+(*vy)*(*vy)+(*vz)*(*vz));
		theta	=asin(Q2V*Q/(2.0*v));	/*Bragg's law*/
		if (theta0<0) theta=-theta;
		tmp3	=	(theta-theta0)/(MIN2RAD*mosaich);
		if(tmp3>div_cutoff)
		{
			*x=old_x;
			*y=old_y;
			*z=old_z;
			*t=old_t;
		}
		else
		{
			(*p)*=r0*exp(-tmp3*tmp3*4.*log(2)); /*Use mosaics*/
			tmp1	=2*theta;
			cs	=cos(tmp1);
			sn	=sin(tmp1);
			tmp2	=cs*(*vx)-sn*(*vz);
			*vy	=*vy;
			*vz	=cs*(*vz)+sn*(*vx);
			*vx	=tmp2;
		/*Second:scattering out of plane.
		  Approximation is that Deby-Scherrer cone is a plane*/
			phi =atan2(*vy,*vz);  /*out-of plane angle */
			dphi=(MIN2RAD*mosaicv)/(2*sqrt(2*log(2)))*randnorm();
				/*MC choice*/
		/*Vertical angle of the crystallite*/
			*vy	=(*vz)*tan(phi+2*dphi*sin(theta));
			vratio	=v/sqrt((*vx)*(*vx)+(*vy)*(*vy)+(*vz)*(*vz));
			*vz	=(*vz)*vratio;
			*vy	=(*vy)*vratio;
			*vx	=(*vx)*vratio;
		}
	}
	else
	{
		*x=old_x;
		*y=old_y;
		*z=old_z;
		*t=old_t;
	}

 }
}
/*allow random direction of analyzer blade*/
void dmtas_analyzerblade1(double div_cutoff,double zmin,double zmax,
  double ymin, double ymax, double mosaich, double mosaicv, double dirdev,
  double r0, double Q, double *x, double *y, double *z, double *vx, 
  double *vy, double *vz, double *t, double *sx, double *sy, double *sz, double *p)
{
 double dphi, tmp1,tmp2,tmp3,vratio,phi,theta0,theta,v,cs,sn;
 double old_x=*x, old_y=*y,old_z=*z,old_t=*t;
 double old_vx=*vx,old_vy=*vy,old_vz=*vz;
 double dt;
 double dirdev_1=asin(sin(MIN2RAD*dirdev)*0.707107);	/*adjust dirdev*/
 double dthz=dirdev_1/(2*sqrt(2*log(2)))*randnorm();
 double dthy=dirdev_1/(2*sqrt(2*log(2)))*randnorm();
 double cdthz=cos(dthz), sdthz=sin(dthz),cdthy=cos(dthy),sdthy=sin(dthy);
/*rotate the blade to a random direction, dthz around z, then dthy around y'*/
 *x=old_x*cdthy*cdthz+old_y*cdthy*sdthz-old_z*sdthy;
 *y=-old_x*sdthz+old_y*cdthz;
 *z=old_x*sdthy*cdthz+old_y*sdthy*sdthz+old_z*cdthy;
 *vx=old_vx*cdthy*cdthz+old_vy*cdthy*sdthz-old_vz*sdthy;
 *vy=-old_vx*sdthz+old_vy*cdthz;
 *vz=old_vx*sdthy*cdthz+old_vy*sdthy*sdthz+old_vz*cdthy;

 old_x=*x;
 old_y=*y;
 old_z=*z;
 old_t=*t;

 dt	=-(*x)/(*vx);
 if(*vx !=0.0 && dt>=0.0)
 {
	*y+=(*vy)*dt;*z+=(*vz)*dt;*t+=dt;*x=0.0;
	if(*z>zmin && *z<zmax && *y>ymin && *y<ymax)
	{  
		/*First:scattering in plane*/
		theta0	=atan2(*vx,*vz); /*neutron angle to slab */
		v	=sqrt((*vx)*(*vx)+(*vy)*(*vy)+(*vz)*(*vz));
		theta	=asin(Q2V*Q/(2.0*v));	/*Bragg's law*/
		if (theta0<0) theta=-theta;
		tmp3	=	(theta-theta0)/(MIN2RAD*mosaich);
		if(tmp3>div_cutoff)
		{
			*x=old_x;
			*y=old_y;
			*z=old_z;
			*t=old_t;
		}
		else
		{
			(*p)*=r0*exp(-tmp3*tmp3*4.*log(2)); /*Use mosaics*/
			/* the reflectivity is given in r0  JAR*/
			tmp1	=2*theta;
			cs	=cos(tmp1);
			sn	=sin(tmp1);
			tmp2	=cs*(*vx)-sn*(*vz);
			*vy	=*vy;
			*vz	=cs*(*vz)+sn*(*vx);
			*vx	=tmp2;
		/*Second:scattering out of plane.
		  Approximation is that Deby-Scherrer cone is a plane*/
			phi =atan2(*vy,*vz);  /*out-of plane angle */
			dphi=(MIN2RAD*mosaicv)/(2*sqrt(2*log(2)))*randnorm();
				/*MC choice*/
		/*Vertical angle of the crystallite*/
			*vy	=(*vz)*tan(phi+2*dphi*sin(theta));
			vratio	=v/sqrt((*vx)*(*vx)+(*vy)*(*vy)+(*vz)*(*vz));
			*vz	=(*vz)*vratio;
			*vy	=(*vy)*vratio;
			*vx	=(*vx)*vratio;
		}
	}
	else
	{
		*x=old_x;
		*y=old_y;
		*z=old_z;
		*t=old_t;
	}
 }
 old_x=*x;
 old_y=*y;
 old_z=*z;
 old_vx=*vx;
 old_vy=*vy;
 old_vz=*vz;

/*rotate the blade back to its original direction*/
 *x=old_x*cdthz*cdthy+old_z*cdthz*sdthy-old_y*sdthz;
 *y=old_x*sdthz*cdthy+old_z*sdthz*sdthy+old_y*cdthz;
 *z=-old_x*sdthy+old_z*cdthy;
 *vx=old_vx*cdthz*cdthy+old_vz*cdthz*sdthy-old_vy*sdthz;
 *vy=old_vx*sdthz*cdthy+old_vz*sdthz*sdthy+old_vy*cdthz;
 *vz=-old_vx*sdthy+old_vz*cdthy;

}


/*allow random direction of analyzer blade*/
/*converted from Mosaic_anisotropic.comp  */
/*Yiming Qiu 6/29/2001			  */
#define GAUSS(x,mean,rms) \
  (exp(-((x)-(mean))*((x)-(mean))/(2*(rms)*(rms)))/(sqrt(2*PI)*(rms)))

void macs_analyzerblade_ani(double zmin,double zmax,
  double ymin, double ymax, double mosaich, double mosaicv, double dirdev,
  double r0, double Q, double *x, double *y, double *z, double *vx, 
  double *vy, double *vz, double *t, double *sx, double *sy, double *sz, double *p)
{
 double sqrt8ln2	=	sqrt(8.*log(2));

 /* Values for Gauss quadrature. Taken from Brice Carnahan, H. A. Luther and
    James O Wilkes, "Applied numerical methods", Wiley, 1996, page 103. */
 double X[] = {-0.987992518020485, 0.937273392400706, 0.848206583410427,
                0.724417731360170, 0.570972172608539, 0.394151347077563,
                0.201194093997435, 0, 0.201194093997435,
                0.394151347077563, 0.570972172608539, 0.724417731360170,
                0.848206583410427, 0.937273392400706, 0.987992518020485};
 double W[] = { 0.030753241996117, 0.070366047488108, 0.107159220467172,
                0.139570677926154, 0.166269205816994, 0.186161000115562,
                0.198431485327111, 0.202578241925561, 0.198431485327111,
                0.186161000115562, 0.166269205816994, 0.139570677926154,
                0.107159220467172, 0.070366047488108, 0.030753241996117};
 /* root-mean-square of mosaic, in radians*/
 double mos_rms_y=MIN2RAD*mosaich/sqrt8ln2; 
 double mos_rms_z=MIN2RAD*mosaicv/sqrt8ln2;
 double mos_rms_max=mos_rms_y>mos_rms_z?mos_rms_y:mos_rms_z;

 double y1,z1,t1,dt,kix,kiy,kiz,ratio,order,q0x,k,q0,theta;
 double bx,by,bz,kux,kuy,kuz,ax,ay,az,phi;
 double cos_2theta,k_sin_2theta,cos_phi,sin_phi,kfx,kfy,kfz,q_x,q_y,q_z;
 double delta,p_reflect,total,c1x,c1y,c1z,width,ds_factor;
 int i;

/*adjust the blade according to dirdev*/ 
 double old_x=*x, old_y=*y,old_z=*z,old_t=*t;
 double old_vx=*vx,old_vy=*vy,old_vz=*vz;
 double dirdev_1=asin(sin(MIN2RAD*dirdev)*0.707107);	/*adjust dirdev*/
 double dthz=dirdev_1/sqrt8ln2*randnorm();
 double dthy=dirdev_1/sqrt8ln2*randnorm();
 double cdthz=cos(dthz), sdthz=sin(dthz),cdthy=cos(dthy),sdthy=sin(dthy);
/*rotate the blade to a random direction, dthz around z, then dthy around y'*/
 *x=old_x*cdthy*cdthz+old_y*cdthy*sdthz-old_z*sdthy;
 *y=-old_x*sdthz+old_y*cdthz;
 *z=old_x*sdthy*cdthz+old_y*sdthy*sdthz+old_z*cdthy;
 *vx=old_vx*cdthy*cdthz+old_vy*cdthy*sdthz-old_vz*sdthy;
 *vy=-old_vx*sdthz+old_vy*cdthz;
 *vz=old_vx*sdthy*cdthz+old_vy*sdthy*sdthz+old_vz*cdthy;


 if(*vx != 0.0 && (dt = -(*x)/(*vx)) >= 0.0)
 { /* Moving towards crystal? */
    y1 = *y + (*vy)*dt;            /* Propagate to crystal plane */
    z1 = *z + (*vz)*dt;
    t1 = *t + dt;
    if (z1>zmin && z1<zmax && y1>ymin && y1<ymax)
    { /* Intersect the crystal? */
      kix = V2K*(*vx);             /* Initial wave vector */
      kiy = V2K*(*vy);
      kiz = V2K*(*vz);
      /* Get reflection order and corresponding nominal scattering vector q0
         of correct length and direction. Only the order with the closest
         scattering vector is considered */
      ratio = -2*kix/Q;
      order = floor(ratio + .5);
      if(order == 0.0)
        order = ratio < 0 ? -1 : 1;
      /* Order will be negative when the neutron enters from the back, in
         which case the direction of Q0 is flipped. */
      if(order < 0)
        order = -order;
      /* Make sure the order is small enough to allow Bragg scattering at the
         given neutron wavelength */
      k = sqrt(kix*kix + kiy*kiy + kiz*kiz);
      kux = kix/k;              /* Unit vector along ki */
      kuy = kiy/k;
      kuz = kiz/k;
      if(order > 2*k/Q)
        order--;
      if(order > 0)             /* Bragg scattering possible? */
      {
        q0 = order*Q;
        q0x = ratio < 0 ? -q0 : q0;
        theta = asin(q0/(2*k)); /* Actual bragg angle */
        /* Make MC choice: reflect or transmit? */
        delta = asin(fabs(kux)) - theta;
        p_reflect = r0*exp(-kiz*kiz/(kiy*kiy + kiz*kiz)*(delta*delta)/
                           (2*mos_rms_y*mos_rms_y))*
                       exp(-kiy*kiy/(kiy*kiy + kiz*kiz)*(delta*delta)/
                           (2*mos_rms_z*mos_rms_z));
        if(rand01() < p_reflect)
        {                       /* Reflect */
          cos_2theta = cos(2*theta);
          k_sin_2theta = k*sin(2*theta);
          /* Get unit normal to plane containing ki and most probable kf */
          vec_prod(bx, by, bz, kix, kiy, kiz, q0x, 0, 0);
          NORM(bx,by,bz);
          bx *= k_sin_2theta;
          by *= k_sin_2theta;
          bz *= k_sin_2theta;
          /* Get unit vector normal to ki and b */
          vec_prod(ax, ay, az, bx, by, bz, kux, kuy, kuz);
          /* Compute the total scattering probability at this ki */
          total = 0;
          /* Choose integration limits, using Gaussian tail cut-off at 5 times
	   * sigma. The radius of the Debye-Scherrer cone is smaller by a
	   * factor 1/cos(theta) than the radius of the (partial) sphere
	   * describing the possible orientations of Q due to mosaicity, so we
	   * must use an integration width 1/cos(theta) greater than 5 times
	   * the mosaic. */
          ds_factor = 1/cos(theta);
          width = 5*mos_rms_max*ds_factor;
          c1x = kix*(cos_2theta-1);
          c1y = kiy*(cos_2theta-1);
          c1z = kiz*(cos_2theta-1);
          for(i = 0; i < (sizeof(X)/sizeof(double)); i++)
          {
            phi = width*X[i];
            cos_phi = cos(phi);
            sin_phi = sin(phi);
            q_x = c1x + cos_phi*ax + sin_phi*bx;
            q_y = c1y + cos_phi*ay + sin_phi*by;
            q_z = c1z + cos_phi*az + sin_phi*bz;
            p_reflect = GAUSS((q_z/q_x),0,mos_rms_y)*
                        GAUSS((q_y/q_x),0,mos_rms_z);
            total += W[i]*p_reflect;
          }
          total *= width;
          /* Choose point on Debye-Scherrer cone. Sample from a Gaussian of
	   * width 1/cos(theta) greater than the mosaic and correct for any
	   * error by adjusting the neutron weight later. */
          phi = ds_factor*mos_rms_max*randnorm();
          /* Compute final wave vector kf and scattering vector q = ki - kf */
          cos_phi = cos(phi);
          sin_phi = sin(phi);
          q_x = c1x + cos_phi*ax + sin_phi*bx;
          q_y = c1y + cos_phi*ay + sin_phi*by;
          q_z = c1z + cos_phi*az + sin_phi*bz;
          p_reflect = GAUSS((q_z/q_x),0,mos_rms_y)*
                      GAUSS((q_y/q_x),0,mos_rms_z);
          *x = 0;
          *y = y1;
          *z = z1;
          *t = t1;
          *vx = K2V*(kix+q_x);
          *vy = K2V*(kiy+q_y);
          *vz = K2V*(kiz+q_z);
          (*p) *= p_reflect/(total*GAUSS(phi,0,ds_factor*mos_rms_max));
        } /* End MC choice to reflect or transmit neutron */
      } /* End bragg scattering possible */
    } /* End intersect the crystal */
 } /* End neutron moving towards crystal */

 old_x=*x;
 old_y=*y;
 old_z=*z;
 old_vx=*vx;
 old_vy=*vy;
 old_vz=*vz;

/*rotate the blade back to its original direction*/
 *x=old_x*cdthz*cdthy+old_z*cdthz*sdthy-old_y*sdthz;
 *y=old_x*sdthz*cdthy+old_z*sdthz*sdthy+old_y*cdthz;
 *z=-old_x*sdthy+old_z*cdthy;
 *vx=old_vx*cdthz*cdthy+old_vz*cdthz*sdthy-old_vy*sdthz;
 *vy=old_vx*sdthz*cdthy+old_vz*sdthz*sdthy+old_vy*cdthz;
 *vz=-old_vx*sdthy+old_vz*cdthy;
}





/*allow random direction of analyzer blade*/
/*converted from monochromator_flat.comp  */
/*Jose A. Rodriguez 2/12/2007*/
#define GAUSS(x,mean,rms) \
  (exp(-((x)-(mean))*((x)-(mean))/(2*(rms)*(rms)))/(sqrt(2*PI)*(rms)))

void macs_mono_flat(double zmin,double zmax,
  double ymin, double ymax, double mosaich, double mosaicv, double dirdev,
  double r0, double Q, double *x, double *y, double *z, double *vx, 
  double *vy, double *vz, double *t, double *sx, double *sy, double *sz, double *p)
{
 double sqrt8ln2	=	sqrt(8.*log(2));

 /* Values for Gauss quadrature. Taken from Brice Carnahan, H. A. Luther and
    James O Wilkes, "Applied numerical methods", Wiley, 1996, page 103. */
 double X[] = {-0.987992518020485, 0.937273392400706, 0.848206583410427,
                0.724417731360170, 0.570972172608539, 0.394151347077563,
                0.201194093997435, 0, 0.201194093997435,
                0.394151347077563, 0.570972172608539, 0.724417731360170,
                0.848206583410427, 0.937273392400706, 0.987992518020485};
 double W[] = { 0.030753241996117, 0.070366047488108, 0.107159220467172,
                0.139570677926154, 0.166269205816994, 0.186161000115562,
                0.198431485327111, 0.202578241925561, 0.198431485327111,
                0.186161000115562, 0.166269205816994, 0.139570677926154,
                0.107159220467172, 0.070366047488108, 0.030753241996117};
 /* root-mean-square of mosaic, in radians*/
 double mos_rms_y=MIN2RAD*mosaich/sqrt8ln2; 
 double mos_rms_z=MIN2RAD*mosaicv/sqrt8ln2;

 
 
 double mos_rms_max=mos_rms_y>mos_rms_z?mos_rms_y:mos_rms_z,mos_sample;

 double y1,z1,t1,dt,kix,kiy,kiz,ratio,order,q0x,k,q0,theta;
 double bx,by,bz,kux,kuy,kuz,ax,ay,az,phi;
 double cos_2theta,k_sin_2theta,cos_phi,sin_phi,kfx,kfy,kfz,q_x,q_y,q_z;
 double delta,p_reflect,total,c1x,c1y,c1z,width,ds_factor;
 int i;

/*adjust the blade according to dirdev*/ 
 double old_x=*x, old_y=*y,old_z=*z,old_t=*t;
 double old_vx=*vx,old_vy=*vy,old_vz=*vz;
 double dirdev_1=asin(sin(MIN2RAD*dirdev)*0.707107);	/*adjust dirdev*/
 double dthz=dirdev_1/sqrt8ln2*randnorm();
 double dthy=dirdev_1/sqrt8ln2*randnorm();
 double cdthz=cos(dthz), sdthz=sin(dthz),cdthy=cos(dthy),sdthy=sin(dthy);
/*rotate the blade to a random direction, dthz around z, then dthy around y'*/
 *x=old_x*cdthy*cdthz+old_y*cdthy*sdthz-old_z*sdthy;
 *y=-old_x*sdthz+old_y*cdthz;
 *z=old_x*sdthy*cdthz+old_y*sdthy*sdthz+old_z*cdthy;
 *vx=old_vx*cdthy*cdthz+old_vy*cdthy*sdthz-old_vz*sdthy;
 *vy=-old_vx*sdthz+old_vy*cdthz;
 *vz=old_vx*sdthy*cdthz+old_vy*sdthy*sdthz+old_vz*cdthy;

 if(*vx != 0.0 && (dt = -(*x)/(*vx)) >= 0.0)
  {                             /* Moving towards crystal? */
    y1 = *y + (*vy)*dt;            /* Propagate to crystal plane */
    z1 = *z + (*vz)*dt;
    t1 = *t + dt;
    if (z1>zmin && z1<zmax && y1>ymin && y1<ymax)
    {                           /* Intersect the crystal? */
      kix = V2K*(*vx);             /* Initial wave vector */
      kiy = V2K*(*vy);
      kiz = V2K*(*vz);
      /* Get reflection order and corresponding nominal scattering vector q0
         of correct length and direction. Only the order with the closest
         scattering vector is considered */
      ratio = -2*kix/Q;
      order = floor(ratio + .5);
      if(order == 0.0)
        order = ratio < 0 ? -1 : 1;
      /* Order will be negative when the neutron enters from the back, in
         which case the direction of Q0 is flipped. */
      if(order < 0)
        order = -order;
      /* Make sure the order is small enough to allow Bragg scattering at the
         given neutron wavelength */
      k = sqrt(kix*kix + kiy*kiy + kiz*kiz);
      kux = kix/k;              /* Unit vector along ki */
      kuy = kiy/k;
      kuz = kiz/k;
      if(order > 2*k/Q)
        order--;
      if(order > 0)             /* Bragg scattering possible? */
      {
        q0 = order*Q;
        q0x = ratio < 0 ? -q0 : q0;
        theta = asin(q0/(2*k)); /* Actual bragg angle */
        /* Make MC choice: reflect or transmit? */
        delta = asin(fabs(kux)) - theta;
        p_reflect = r0*exp(-kiz*kiz/(kiy*kiy + kiz*kiz)*(delta*delta)/
                           (2*mos_rms_y*mos_rms_y))*
                       exp(-kiy*kiy/(kiy*kiy + kiz*kiz)*(delta*delta)/
                           (2*mos_rms_z*mos_rms_z));
        if(rand01() < p_reflect)
        {                       /* Reflect */
          cos_2theta = cos(2*theta);
          k_sin_2theta = k*sin(2*theta);
          /* Get unit normal to plane containing ki and most probable kf */
          vec_prod(bx, by, bz, kix, kiy, kiz, q0x, 0, 0);
          NORM(bx,by,bz);
          bx *= k_sin_2theta;
          by *= k_sin_2theta;
          bz *= k_sin_2theta;
          /* Get unit vector normal to ki and b */
          vec_prod(ax, ay, az, bx, by, bz, kux, kuy, kuz);
          /* Compute the total scattering probability at this ki */
          total = 0;
          /* Choose width of Gaussian distribution to sample the angle
           * phi on the Debye-Scherrer cone for the scattered neutron.
           * The radius of the Debye-Scherrer cone is smaller by a
           * factor 1/cos(theta) than the radius of the (partial) sphere
           * describing the possible orientations of Q due to mosaicity, so we
           * start with a width 1/cos(theta) greater than the largest of
           * the two mosaics. */
          mos_sample = mos_rms_max/cos(theta);
          c1x = kix*(cos_2theta-1);
          c1y = kiy*(cos_2theta-1);
          c1z = kiz*(cos_2theta-1);
          /* Loop, repeatedly reducing the sample width until it is small
           * enough to avoid sampling scattering directions with
           * ridiculously low scattering probability.
           * Use a cut-off at 5 times the gauss width for considering
           * scattering probability as well as for integration limits
           * when integrating the sampled distribution below. */
          for(;;) {
            width = 5*mos_sample;
            cos_phi = cos(width);
            sin_phi = sin(width);
            q_x = c1x + cos_phi*ax + sin_phi*bx;
            q_y = (c1y + cos_phi*ay + sin_phi*by)/mos_rms_z;
            q_z = (c1z + cos_phi*az + sin_phi*bz)/mos_rms_y;
            /* Stop when we get near a factor of 25=5^2. */
            if(q_z*q_z + q_y*q_y < (25/(2.0/3.0))*(q_x*q_x))
              break;
            mos_sample *= (2.0/3.0);
          }
          /* Now integrate the chosen sampling distribution, using a
           * cut-off at five times sigma. */
          for(i = 0; i < (sizeof(X)/sizeof(double)); i++)
          {
            phi = width*X[i];
            cos_phi = cos(phi);
            sin_phi = sin(phi);
            q_x = c1x + cos_phi*ax + sin_phi*bx;
            q_y = c1y + cos_phi*ay + sin_phi*by;
            q_z = c1z + cos_phi*az + sin_phi*bz;
            p_reflect = GAUSS((q_z/q_x),0,mos_rms_y)*
                        GAUSS((q_y/q_x),0,mos_rms_z);
            total += W[i]*p_reflect;
          }
          total *= width;
          /* Choose point on Debye-Scherrer cone. Sample from a Gaussian of
           * width 1/cos(theta) greater than the mosaic and correct for any
           * error by adjusting the neutron weight later. */
          phi = mos_sample*randnorm();
          /* Compute final wave vector kf and scattering vector q = ki - kf */
          cos_phi = cos(phi);
          sin_phi = sin(phi);
          q_x = c1x + cos_phi*ax + sin_phi*bx;
          q_y = c1y + cos_phi*ay + sin_phi*by;
          q_z = c1z + cos_phi*az + sin_phi*bz;
          p_reflect = GAUSS((q_z/q_x),0,mos_rms_y)*
                      GAUSS((q_y/q_x),0,mos_rms_z);
          *x = 0;
          *y = y1;
          *z = z1;
          *t = t1;
          *vx = K2V*(kix+q_x);
          *vy = K2V*(kiy+q_y);
          *vz = K2V*(kiz+q_z);
          (*p) *= p_reflect/(total*GAUSS(phi,0,mos_sample));
        } /* End MC choice to reflect or transmit neutron */
      } /* End bragg scattering possible */
    } /* End intersect the crystal */
  } /* End neutron moving towards crystal */

 old_x=*x;
 old_y=*y;
 old_z=*z;
 old_vx=*vx;
 old_vy=*vy;
 old_vz=*vz;

/*rotate the blade back to its original direction*/
 *x=old_x*cdthz*cdthy+old_z*cdthz*sdthy-old_y*sdthz;
 *y=old_x*sdthz*cdthy+old_z*sdthz*sdthy+old_y*cdthz;
 *z=-old_x*sdthy+old_z*cdthy;
 *vx=old_vx*cdthz*cdthy+old_vz*cdthz*sdthy-old_vy*sdthz;
 *vy=old_vx*sdthz*cdthy+old_vz*sdthz*sdthy+old_vy*cdthz;
 *vz=-old_vx*sdthy+old_vz*cdthy;
}

  
  double dmtas_sou_radusv=0.055;  /*source (in cm)*/
  double dmtas_sou_radush=0.055;    
  
  double phi_source=0;

  double diverg;
 
  double dmtas_sou_E0, dmtas_sou_dE, MPL;
  // double mon_tras, mon_ele;
  double dist_slit1,dist_slit2;
  double xmax_slit1,xmin_slit1,ymax_slit1,ymin_slit1;
  double xmax_slit2,xmin_slit2,ymax_slit2,ymin_slit2;
  double emin, emax;
  double lambda;
   
  double dist_tub1  = 0.15;   /*tube1 Pee Wee*/
  double tub1_r1  =0.065  ;
  double tub1_r2  =0.065  ;
  double tub1_length =0.79;

  double sample_radius; 

  //Below are user defined.
  double samp_ax; //can be calculated from lattice params and u v matrix 
  double samp_ay; 
  double samp_az; 
  double samp_bx; 
  double samp_by; 
  double samp_bz; 
  double samp_cx; 
  double samp_cy; 
  double samp_cz; 
  double samp_abs_xc; 
  double samp_mosaic; 
  double samp_delta_d; 
  double samp_inc_xc; 
  double samp_cell_vol; 
  double samp_xwidth;
  double samp_ywidth;
  double samp_zwidth;
  double crystal_axis_xrot; 
  double crystal_axis_yrot; 
  double crystal_axis_zrot; 

  double plate_distance;

  double dist_tub1A = 0.95;   /*tube1A Pee Wee*/
  double tub1A_r1 =0.165  ;
  double tub1A_r2 =0.165  ;
  double tub1A_length   =1.69;

  double dist_tub2   =2.650;      /*tube2*/
  double tub2_r1     =0.1187       ;
  double tub2_r2     =0.1411       ;
  double tub2_length =0.8;

  double dist_tub3   =3.475 ;      /*tube3*/
  double tub3_r1     =0.1418       ;
  double tub3_r2     =0.1543       ;
  double tub3_length =0.45         ;
 
  double dist_tub4   =3.935 ;      /*tube4*/
  double tub4_r1     =0.1546       ;
  double tub4_r2     =0.159        ;
  double tub4_length =0.159        ;

  double apev, apeh;              /*aptertures*/
  double dist_ape_v=4.550;
  double dist_ape_h=4.655;
  double slv_xmin,slv_xmax,slv_ymin,slv_ymax;
  double slh_xmin,slh_xmax,slh_ymin,slh_ymax;

  
  double dist_collA =4.150;       /*collimatorA*/
  double dmtas_collA_R1 =4.152,dmtas_collA_R2 =4.287;
  double dmtas_collA_h =0.460;
  double dmtas_collA_n  =98;
  double dmtas_collA_w  =0.0033;

  double dist_collB =4.295;       /*collimatorB*/
  double dmtas_collB_R1 =4.295,dmtas_collB_R2 =4.503;
  double dmtas_collB_h =0.460;
  double dmtas_collB_n  =98;
  double dmtas_collB_w  =0.003415;

  double hight_at_reference,R_at_reference;
  double tan_ver,tan_hor;
  double angle_of_ver,len_of_ver;
  double dmtas_guide_w1;        /*super mirror guide*/
  double dmtas_guide_w2;
  double dmtas_guide_h1, dmtas_guide_h2;
  double dmtas_guide_len;
  double dmtas_guide_l  =1.7;     /*only use the geometry*/

// declare section for monochromator 
double mono_column_displacements[21] = {-0.210000,-0.189000,-0.168000,-0.147000,-0.126000,-0.105000,-0.084000,-0.063000,-0.042000,-0.021000,0.000000,0.021000,0.042000,0.063000,0.084000,0.105000,0.126000,0.147000,0.168000,0.189000,0.210000};
double mono_crystal_width = 0.020000;
double mono_number_of_rows = 17.000000;
double mono_q = 1.873250;
double mono_theta;
double dist_mono_L0;
double dist_mono_L0_pos;
double dist_mono_L1;
double dist_mono_L1_pos;
double R_at_reference;
double height_at_reference;
double mono_Radius_of_curvature;
double mono_total_height;
double mono_phi;
double mono_psi[21];
int mono_iterate;
double mono_mosaicity_eta_min = 14.107000;
double mono_mosaicity_eta_rad;
double mono_crystal_thickness = 20000000.000000;
double mono_g;
double mono_Ff;
double mono_b_c = 0.000066;
double mono_Vc;
double mono_Qc;
double mono_t;
double mono_xx;
double mono_r0;
double mono_mosaicity_rad;
double mono_mosaicity_min;
double mono_array0_crystal_height = 0.020000;
double mono_array0_crystal_depth = 0.002000;
int mono_array0_number_of_crystals = 17;
double mono_array0_effective_radius_of_curvature;
double mono_array0_theta_max;
double mono_array0_delta_theta;
double mono_array0_theta[17];
int mono_array0_iterate;
double mono_array0_support_arch_thickness = 0.001830;
double mono_array0_support_arch_width = 0.018800;
double mono_array0_support_arch_spacing = 0.000251;
double mono_array0_arch_outer_radius;
double mono_array0_arch_inner_radius;
double mono_array0_mask_depth;
double mono_array1_crystal_height = 0.020000;
double mono_array1_crystal_depth = 0.002000;
int mono_array1_number_of_crystals = 17;
double mono_array1_effective_radius_of_curvature;
double mono_array1_theta_max;
double mono_array1_delta_theta;
double mono_array1_theta[17];
int mono_array1_iterate;
double mono_array1_support_arch_thickness = 0.001830;
double mono_array1_support_arch_width = 0.018800;
double mono_array1_support_arch_spacing = 0.000251;
double mono_array1_arch_outer_radius;
double mono_array1_arch_inner_radius;
double mono_array1_mask_depth;
double mono_array2_crystal_height = 0.020000;
double mono_array2_crystal_depth = 0.002000;
int mono_array2_number_of_crystals = 17;
double mono_array2_effective_radius_of_curvature;
double mono_array2_theta_max;
double mono_array2_delta_theta;
double mono_array2_theta[17];
int mono_array2_iterate;
double mono_array2_support_arch_thickness = 0.001830;
double mono_array2_support_arch_width = 0.018800;
double mono_array2_support_arch_spacing = 0.000251;
double mono_array2_arch_outer_radius;
double mono_array2_arch_inner_radius;
double mono_array2_mask_depth;
double mono_array3_crystal_height = 0.020000;
double mono_array3_crystal_depth = 0.002000;
int mono_array3_number_of_crystals = 17;
double mono_array3_effective_radius_of_curvature;
double mono_array3_theta_max;
double mono_array3_delta_theta;
double mono_array3_theta[17];
int mono_array3_iterate;
double mono_array3_support_arch_thickness = 0.001830;
double mono_array3_support_arch_width = 0.018800;
double mono_array3_support_arch_spacing = 0.000251;
double mono_array3_arch_outer_radius;
double mono_array3_arch_inner_radius;
double mono_array3_mask_depth;
double mono_array4_crystal_height = 0.020000;
double mono_array4_crystal_depth = 0.002000;
int mono_array4_number_of_crystals = 17;
double mono_array4_effective_radius_of_curvature;
double mono_array4_theta_max;
double mono_array4_delta_theta;
double mono_array4_theta[17];
int mono_array4_iterate;
double mono_array4_support_arch_thickness = 0.001830;
double mono_array4_support_arch_width = 0.018800;
double mono_array4_support_arch_spacing = 0.000251;
double mono_array4_arch_outer_radius;
double mono_array4_arch_inner_radius;
double mono_array4_mask_depth;
double mono_array5_crystal_height = 0.020000;
double mono_array5_crystal_depth = 0.002000;
int mono_array5_number_of_crystals = 17;
double mono_array5_effective_radius_of_curvature;
double mono_array5_theta_max;
double mono_array5_delta_theta;
double mono_array5_theta[17];
int mono_array5_iterate;
double mono_array5_support_arch_thickness = 0.001830;
double mono_array5_support_arch_width = 0.018800;
double mono_array5_support_arch_spacing = 0.000251;
double mono_array5_arch_outer_radius;
double mono_array5_arch_inner_radius;
double mono_array5_mask_depth;
double mono_array6_crystal_height = 0.020000;
double mono_array6_crystal_depth = 0.002000;
int mono_array6_number_of_crystals = 17;
double mono_array6_effective_radius_of_curvature;
double mono_array6_theta_max;
double mono_array6_delta_theta;
double mono_array6_theta[17];
int mono_array6_iterate;
double mono_array6_support_arch_thickness = 0.001830;
double mono_array6_support_arch_width = 0.018800;
double mono_array6_support_arch_spacing = 0.000251;
double mono_array6_arch_outer_radius;
double mono_array6_arch_inner_radius;
double mono_array6_mask_depth;
double mono_array7_crystal_height = 0.020000;
double mono_array7_crystal_depth = 0.002000;
int mono_array7_number_of_crystals = 17;
double mono_array7_effective_radius_of_curvature;
double mono_array7_theta_max;
double mono_array7_delta_theta;
double mono_array7_theta[17];
int mono_array7_iterate;
double mono_array7_support_arch_thickness = 0.001830;
double mono_array7_support_arch_width = 0.018800;
double mono_array7_support_arch_spacing = 0.000251;
double mono_array7_arch_outer_radius;
double mono_array7_arch_inner_radius;
double mono_array7_mask_depth;
double mono_array8_crystal_height = 0.020000;
double mono_array8_crystal_depth = 0.002000;
int mono_array8_number_of_crystals = 17;
double mono_array8_effective_radius_of_curvature;
double mono_array8_theta_max;
double mono_array8_delta_theta;
double mono_array8_theta[17];
int mono_array8_iterate;
double mono_array8_support_arch_thickness = 0.001830;
double mono_array8_support_arch_width = 0.018800;
double mono_array8_support_arch_spacing = 0.000251;
double mono_array8_arch_outer_radius;
double mono_array8_arch_inner_radius;
double mono_array8_mask_depth;
double mono_array9_crystal_height = 0.020000;
double mono_array9_crystal_depth = 0.002000;
int mono_array9_number_of_crystals = 17;
double mono_array9_effective_radius_of_curvature;
double mono_array9_theta_max;
double mono_array9_delta_theta;
double mono_array9_theta[17];
int mono_array9_iterate;
double mono_array9_support_arch_thickness = 0.001830;
double mono_array9_support_arch_width = 0.018800;
double mono_array9_support_arch_spacing = 0.000251;
double mono_array9_arch_outer_radius;
double mono_array9_arch_inner_radius;
double mono_array9_mask_depth;
double mono_array10_crystal_height = 0.020000;
double mono_array10_crystal_depth = 0.002000;
int mono_array10_number_of_crystals = 17;
double mono_array10_effective_radius_of_curvature;
double mono_array10_theta_max;
double mono_array10_delta_theta;
double mono_array10_theta[17];
int mono_array10_iterate;
double mono_array10_support_arch_thickness = 0.001830;
double mono_array10_support_arch_width = 0.018800;
double mono_array10_support_arch_spacing = 0.000251;
double mono_array10_arch_outer_radius;
double mono_array10_arch_inner_radius;
double mono_array10_mask_depth;
double mono_array11_crystal_height = 0.020000;
double mono_array11_crystal_depth = 0.002000;
int mono_array11_number_of_crystals = 17;
double mono_array11_effective_radius_of_curvature;
double mono_array11_theta_max;
double mono_array11_delta_theta;
double mono_array11_theta[17];
int mono_array11_iterate;
double mono_array11_support_arch_thickness = 0.001830;
double mono_array11_support_arch_width = 0.018800;
double mono_array11_support_arch_spacing = 0.000251;
double mono_array11_arch_outer_radius;
double mono_array11_arch_inner_radius;
double mono_array11_mask_depth;
double mono_array12_crystal_height = 0.020000;
double mono_array12_crystal_depth = 0.002000;
int mono_array12_number_of_crystals = 17;
double mono_array12_effective_radius_of_curvature;
double mono_array12_theta_max;
double mono_array12_delta_theta;
double mono_array12_theta[17];
int mono_array12_iterate;
double mono_array12_support_arch_thickness = 0.001830;
double mono_array12_support_arch_width = 0.018800;
double mono_array12_support_arch_spacing = 0.000251;
double mono_array12_arch_outer_radius;
double mono_array12_arch_inner_radius;
double mono_array12_mask_depth;
double mono_array13_crystal_height = 0.020000;
double mono_array13_crystal_depth = 0.002000;
int mono_array13_number_of_crystals = 17;
double mono_array13_effective_radius_of_curvature;
double mono_array13_theta_max;
double mono_array13_delta_theta;
double mono_array13_theta[17];
int mono_array13_iterate;
double mono_array13_support_arch_thickness = 0.001830;
double mono_array13_support_arch_width = 0.018800;
double mono_array13_support_arch_spacing = 0.000251;
double mono_array13_arch_outer_radius;
double mono_array13_arch_inner_radius;
double mono_array13_mask_depth;
double mono_array14_crystal_height = 0.020000;
double mono_array14_crystal_depth = 0.002000;
int mono_array14_number_of_crystals = 17;
double mono_array14_effective_radius_of_curvature;
double mono_array14_theta_max;
double mono_array14_delta_theta;
double mono_array14_theta[17];
int mono_array14_iterate;
double mono_array14_support_arch_thickness = 0.001830;
double mono_array14_support_arch_width = 0.018800;
double mono_array14_support_arch_spacing = 0.000251;
double mono_array14_arch_outer_radius;
double mono_array14_arch_inner_radius;
double mono_array14_mask_depth;
double mono_array15_crystal_height = 0.020000;
double mono_array15_crystal_depth = 0.002000;
int mono_array15_number_of_crystals = 17;
double mono_array15_effective_radius_of_curvature;
double mono_array15_theta_max;
double mono_array15_delta_theta;
double mono_array15_theta[17];
int mono_array15_iterate;
double mono_array15_support_arch_thickness = 0.001830;
double mono_array15_support_arch_width = 0.018800;
double mono_array15_support_arch_spacing = 0.000251;
double mono_array15_arch_outer_radius;
double mono_array15_arch_inner_radius;
double mono_array15_mask_depth;
double mono_array16_crystal_height = 0.020000;
double mono_array16_crystal_depth = 0.002000;
int mono_array16_number_of_crystals = 17;
double mono_array16_effective_radius_of_curvature;
double mono_array16_theta_max;
double mono_array16_delta_theta;
double mono_array16_theta[17];
int mono_array16_iterate;
double mono_array16_support_arch_thickness = 0.001830;
double mono_array16_support_arch_width = 0.018800;
double mono_array16_support_arch_spacing = 0.000251;
double mono_array16_arch_outer_radius;
double mono_array16_arch_inner_radius;
double mono_array16_mask_depth;
double mono_array17_crystal_height = 0.020000;
double mono_array17_crystal_depth = 0.002000;
int mono_array17_number_of_crystals = 17;
double mono_array17_effective_radius_of_curvature;
double mono_array17_theta_max;
double mono_array17_delta_theta;
double mono_array17_theta[17];
int mono_array17_iterate;
double mono_array17_support_arch_thickness = 0.001830;
double mono_array17_support_arch_width = 0.018800;
double mono_array17_support_arch_spacing = 0.000251;
double mono_array17_arch_outer_radius;
double mono_array17_arch_inner_radius;
double mono_array17_mask_depth;
double mono_array18_crystal_height = 0.020000;
double mono_array18_crystal_depth = 0.002000;
int mono_array18_number_of_crystals = 17;
double mono_array18_effective_radius_of_curvature;
double mono_array18_theta_max;
double mono_array18_delta_theta;
double mono_array18_theta[17];
int mono_array18_iterate;
double mono_array18_support_arch_thickness = 0.001830;
double mono_array18_support_arch_width = 0.018800;
double mono_array18_support_arch_spacing = 0.000251;
double mono_array18_arch_outer_radius;
double mono_array18_arch_inner_radius;
double mono_array18_mask_depth;
double mono_array19_crystal_height = 0.020000;
double mono_array19_crystal_depth = 0.002000;
int mono_array19_number_of_crystals = 17;
double mono_array19_effective_radius_of_curvature;
double mono_array19_theta_max;
double mono_array19_delta_theta;
double mono_array19_theta[17];
int mono_array19_iterate;
double mono_array19_support_arch_thickness = 0.001830;
double mono_array19_support_arch_width = 0.018800;
double mono_array19_support_arch_spacing = 0.000251;
double mono_array19_arch_outer_radius;
double mono_array19_arch_inner_radius;
double mono_array19_mask_depth;
double mono_array20_crystal_height = 0.020000;
double mono_array20_crystal_depth = 0.002000;
int mono_array20_number_of_crystals = 17;
double mono_array20_effective_radius_of_curvature;
double mono_array20_theta_max;
double mono_array20_delta_theta;
double mono_array20_theta[17];
int mono_array20_iterate;
double mono_array20_support_arch_thickness = 0.001830;
double mono_array20_support_arch_width = 0.018800;
double mono_array20_support_arch_spacing = 0.000251;
double mono_array20_arch_outer_radius;
double mono_array20_arch_inner_radius;
double mono_array20_mask_depth;


  double dmtas_det_w    =0.02;    /*detector*/
  double dmtas_det_h  =0.04;
  double xmax_det, xmin_det, ymax_det, ymin_det;
  double tmp_dist,xx_mon;


// declare section for kidney 
int channel_selected;
double target_filter_dist = 0.350000;
double filter_width = 0.040000;
double filter_height = 0.120000;
double channel_colimator_length = 0.060000;
double channel_colimator_width = 0.034600;
double channel_colimator_height = 0.118400;
double channel_colimator_divergence_arcmin = 90.000000;
double channel_colimator_transmission = 0.900000;
double channel_colimator_target_dist = 0.400000;
double kidney_hull_radius = 1.375000;
double kidney_hull_height = 0.400000;
double kidney_hull_inner_radius = 0.685000;
double kidney_cylinder_angle = 160.000000;
double zx_log_z_min = -0.500000;
double zx_log_z_max = 1.500000;
double zx_log_x_min = -1.500000;
double zx_log_x_max = 1.500000;
int zx_log_z_pixels = 1000;
int zx_log_x_pixels = 1000;
double zy_log_z_min = -0.500000;
double zy_log_z_max = 1.500000;
double zy_log_y_min = -0.200000;
double zy_log_y_max = 0.200000;
int zy_log_z_pixels = 1000;
int zy_log_y_pixels = 300;
double kidney_cave1_width = 0.048740;
double kidney_cave1_height = 0.140000;
double kidney_cave1_depth = 0.550000;
double kidney_cave1_start_target_dist = 0.590000;
double kidney_cave1_box1_width1 = 0.048030;
double kidney_cave1_box1_width2 = 0.057166;
double kidney_cave1_box1_center_to_target;
double kidney_cave1_box1_depth = 0.260890;
double kidney_cave1_box1_height1 = 0.140000;
double kidney_cave1_box1_height2 = 0.173000;
double kidney_cave1_box2_width1 = 0.062634;
double kidney_cave1_box2_width2 = 0.067257;
double kidney_cave1_box2_center_to_target;
double kidney_cave1_box2_x_offset = -0.002764;
double kidney_cave1_box2_depth = 0.132400;
double kidney_cave1_box2_height1 = 0.206100;
double kidney_cave1_box2_height2 = 0.206100;
double kidney_cave1_box3_width1 = 0.061729;
double kidney_cave1_box3_width2 = 0.045340;
double kidney_cave1_box3_center_to_target;
double kidney_cave1_box3_depth = 0.031392;
double kidney_cave1_box3_height1 = 0.206000;
double kidney_cave1_box3_height2 = 0.206000;
double kidney_cave1_cyl1_radius = 0.024000;
double kidney_cave1_cyl1_center_to_target;
double kidney_cave1_cyl1_height = 0.250000;
double kidney_cave2_box1_y_rotation = 18.110000;
double kidney_cave2_box1_width1 = 0.063000;
double kidney_cave2_box1_depth = 0.112900;
double kidney_cave2_box1_width2;
double kidney_cave2_box1_center_to_spec_detector_z;
double kidney_cave2_box1_center_to_spec_detector_x;
double kidney_cave2_box1_height1 = 0.206000;
double kidney_cave2_box1_height2 = 0.206000;
double kidney_cave2_box2_width1 = 0.060170;
double kidney_cave2_box2_width2 = 0.057210;
double kidney_cave2_box2_center_to_detector = -0.196110;
double kidney_cave2_box2_depth = 0.049620;
double kidney_cave2_box2_height1 = 0.206100;
double kidney_cave2_box2_height2 = 0.206100;
double kidney_cave2_box3_width1 = 0.057210;
double kidney_cave2_box3_width2 = 0.047000;
double kidney_cave2_box3_center_to_detector = -0.085650;
double kidney_cave2_box3_depth = 0.171800;
double kidney_cave2_box3_height1 = 0.185000;
double kidney_cave2_box3_height2 = 0.120000;
double kidney_cave2_cyl1_radius = 0.023500;
double kidney_cave2_cyl1_height = 0.250000;
double kidney_cave2_start_target_dist = 0.960000;
double analyzer_1_center_to_sample = 0.999390;
double analyzer_seperation = 0.070000;
double analyzer_2theta_min = 40.000000;
double analyzer_2theta_max = 140.000000;
double delta_analyzer_2theta;
double analyzer_2theta[20];
double analyzer_theta[20];
int kidney_iterate;
double inter_analyzer_colimator_width = 0.000600;
double inter_analyzer_colimator_height = 0.202000;
double inter_analyzer_colimator_depth = 0.012700;
double inter_analyzer_colimator_start_pos = 0.032000;
double inter_analyzer_colimator_seperation = 0.016000;
double detector_radius = 0.018000;
double detector_height = 0.140000;
double diffraction_detector_to_sample;
double spec_detector_to_sample = 1.250000;
double spec_detector_to_analyzer_2_center;
double channel_0_analyzer_1_array_crystal_width = 0.060000;
double channel_0_analyzer_1_array_crystal_height = 0.020000;
double channel_0_analyzer_1_array_crystal_depth = 0.002000;
int channel_0_analyzer_1_array_number_of_crystals = 9;
double channel_0_analyzer_1_array_total_height = 0.180000;
double channel_0_analyzer_1_array_radius_of_curvature = 0.500000;
double channel_0_analyzer_1_array_effective_radius_of_curvature;
double channel_0_analyzer_1_array_theta_max;
double channel_0_analyzer_1_array_delta_theta;
double channel_0_analyzer_1_array_theta[9];
int channel_0_analyzer_1_array_iterate;
double channel_0_analyzer_2_array_crystal_width = 0.060000;
double channel_0_analyzer_2_array_crystal_height = 0.020000;
double channel_0_analyzer_2_array_crystal_depth = 0.002000;
int channel_0_analyzer_2_array_number_of_crystals = 9;
double channel_0_analyzer_2_array_total_height = 0.180000;
double channel_0_analyzer_2_array_radius_of_curvature = 0.500000;
double channel_0_analyzer_2_array_effective_radius_of_curvature;
double channel_0_analyzer_2_array_theta_max;
double channel_0_analyzer_2_array_delta_theta;
double channel_0_analyzer_2_array_theta[9];
int channel_0_analyzer_2_array_iterate;
double channel_1_analyzer_1_array_crystal_width = 0.060000;
double channel_1_analyzer_1_array_crystal_height = 0.020000;
double channel_1_analyzer_1_array_crystal_depth = 0.002000;
int channel_1_analyzer_1_array_number_of_crystals = 9;
double channel_1_analyzer_1_array_total_height = 0.180000;
double channel_1_analyzer_1_array_radius_of_curvature = 0.500000;
double channel_1_analyzer_1_array_effective_radius_of_curvature;
double channel_1_analyzer_1_array_theta_max;
double channel_1_analyzer_1_array_delta_theta;
double channel_1_analyzer_1_array_theta[9];
int channel_1_analyzer_1_array_iterate;
double channel_1_analyzer_2_array_crystal_width = 0.060000;
double channel_1_analyzer_2_array_crystal_height = 0.020000;
double channel_1_analyzer_2_array_crystal_depth = 0.002000;
int channel_1_analyzer_2_array_number_of_crystals = 9;
double channel_1_analyzer_2_array_total_height = 0.180000;
double channel_1_analyzer_2_array_radius_of_curvature = 0.500000;
double channel_1_analyzer_2_array_effective_radius_of_curvature;
double channel_1_analyzer_2_array_theta_max;
double channel_1_analyzer_2_array_delta_theta;
double channel_1_analyzer_2_array_theta[9];
int channel_1_analyzer_2_array_iterate;
double channel_2_analyzer_1_array_crystal_width = 0.060000;
double channel_2_analyzer_1_array_crystal_height = 0.020000;
double channel_2_analyzer_1_array_crystal_depth = 0.002000;
int channel_2_analyzer_1_array_number_of_crystals = 9;
double channel_2_analyzer_1_array_total_height = 0.180000;
double channel_2_analyzer_1_array_radius_of_curvature = 0.500000;
double channel_2_analyzer_1_array_effective_radius_of_curvature;
double channel_2_analyzer_1_array_theta_max;
double channel_2_analyzer_1_array_delta_theta;
double channel_2_analyzer_1_array_theta[9];
int channel_2_analyzer_1_array_iterate;
double channel_2_analyzer_2_array_crystal_width = 0.060000;
double channel_2_analyzer_2_array_crystal_height = 0.020000;
double channel_2_analyzer_2_array_crystal_depth = 0.002000;
int channel_2_analyzer_2_array_number_of_crystals = 9;
double channel_2_analyzer_2_array_total_height = 0.180000;
double channel_2_analyzer_2_array_radius_of_curvature = 0.500000;
double channel_2_analyzer_2_array_effective_radius_of_curvature;
double channel_2_analyzer_2_array_theta_max;
double channel_2_analyzer_2_array_delta_theta;
double channel_2_analyzer_2_array_theta[9];
int channel_2_analyzer_2_array_iterate;
double channel_3_analyzer_1_array_crystal_width = 0.060000;
double channel_3_analyzer_1_array_crystal_height = 0.020000;
double channel_3_analyzer_1_array_crystal_depth = 0.002000;
int channel_3_analyzer_1_array_number_of_crystals = 9;
double channel_3_analyzer_1_array_total_height = 0.180000;
double channel_3_analyzer_1_array_radius_of_curvature = 0.500000;
double channel_3_analyzer_1_array_effective_radius_of_curvature;
double channel_3_analyzer_1_array_theta_max;
double channel_3_analyzer_1_array_delta_theta;
double channel_3_analyzer_1_array_theta[9];
int channel_3_analyzer_1_array_iterate;
double channel_3_analyzer_2_array_crystal_width = 0.060000;
double channel_3_analyzer_2_array_crystal_height = 0.020000;
double channel_3_analyzer_2_array_crystal_depth = 0.002000;
int channel_3_analyzer_2_array_number_of_crystals = 9;
double channel_3_analyzer_2_array_total_height = 0.180000;
double channel_3_analyzer_2_array_radius_of_curvature = 0.500000;
double channel_3_analyzer_2_array_effective_radius_of_curvature;
double channel_3_analyzer_2_array_theta_max;
double channel_3_analyzer_2_array_delta_theta;
double channel_3_analyzer_2_array_theta[9];
int channel_3_analyzer_2_array_iterate;
double channel_4_analyzer_1_array_crystal_width = 0.060000;
double channel_4_analyzer_1_array_crystal_height = 0.020000;
double channel_4_analyzer_1_array_crystal_depth = 0.002000;
int channel_4_analyzer_1_array_number_of_crystals = 9;
double channel_4_analyzer_1_array_total_height = 0.180000;
double channel_4_analyzer_1_array_radius_of_curvature = 0.500000;
double channel_4_analyzer_1_array_effective_radius_of_curvature;
double channel_4_analyzer_1_array_theta_max;
double channel_4_analyzer_1_array_delta_theta;
double channel_4_analyzer_1_array_theta[9];
int channel_4_analyzer_1_array_iterate;
double channel_4_analyzer_2_array_crystal_width = 0.060000;
double channel_4_analyzer_2_array_crystal_height = 0.020000;
double channel_4_analyzer_2_array_crystal_depth = 0.002000;
int channel_4_analyzer_2_array_number_of_crystals = 9;
double channel_4_analyzer_2_array_total_height = 0.180000;
double channel_4_analyzer_2_array_radius_of_curvature = 0.500000;
double channel_4_analyzer_2_array_effective_radius_of_curvature;
double channel_4_analyzer_2_array_theta_max;
double channel_4_analyzer_2_array_delta_theta;
double channel_4_analyzer_2_array_theta[9];
int channel_4_analyzer_2_array_iterate;
double channel_5_analyzer_1_array_crystal_width = 0.060000;
double channel_5_analyzer_1_array_crystal_height = 0.020000;
double channel_5_analyzer_1_array_crystal_depth = 0.002000;
int channel_5_analyzer_1_array_number_of_crystals = 9;
double channel_5_analyzer_1_array_total_height = 0.180000;
double channel_5_analyzer_1_array_radius_of_curvature = 0.500000;
double channel_5_analyzer_1_array_effective_radius_of_curvature;
double channel_5_analyzer_1_array_theta_max;
double channel_5_analyzer_1_array_delta_theta;
double channel_5_analyzer_1_array_theta[9];
int channel_5_analyzer_1_array_iterate;
double channel_5_analyzer_2_array_crystal_width = 0.060000;
double channel_5_analyzer_2_array_crystal_height = 0.020000;
double channel_5_analyzer_2_array_crystal_depth = 0.002000;
int channel_5_analyzer_2_array_number_of_crystals = 9;
double channel_5_analyzer_2_array_total_height = 0.180000;
double channel_5_analyzer_2_array_radius_of_curvature = 0.500000;
double channel_5_analyzer_2_array_effective_radius_of_curvature;
double channel_5_analyzer_2_array_theta_max;
double channel_5_analyzer_2_array_delta_theta;
double channel_5_analyzer_2_array_theta[9];
int channel_5_analyzer_2_array_iterate;
double channel_6_analyzer_1_array_crystal_width = 0.060000;
double channel_6_analyzer_1_array_crystal_height = 0.020000;
double channel_6_analyzer_1_array_crystal_depth = 0.002000;
int channel_6_analyzer_1_array_number_of_crystals = 9;
double channel_6_analyzer_1_array_total_height = 0.180000;
double channel_6_analyzer_1_array_radius_of_curvature = 0.500000;
double channel_6_analyzer_1_array_effective_radius_of_curvature;
double channel_6_analyzer_1_array_theta_max;
double channel_6_analyzer_1_array_delta_theta;
double channel_6_analyzer_1_array_theta[9];
int channel_6_analyzer_1_array_iterate;
double channel_6_analyzer_2_array_crystal_width = 0.060000;
double channel_6_analyzer_2_array_crystal_height = 0.020000;
double channel_6_analyzer_2_array_crystal_depth = 0.002000;
int channel_6_analyzer_2_array_number_of_crystals = 9;
double channel_6_analyzer_2_array_total_height = 0.180000;
double channel_6_analyzer_2_array_radius_of_curvature = 0.500000;
double channel_6_analyzer_2_array_effective_radius_of_curvature;
double channel_6_analyzer_2_array_theta_max;
double channel_6_analyzer_2_array_delta_theta;
double channel_6_analyzer_2_array_theta[9];
int channel_6_analyzer_2_array_iterate;
double channel_7_analyzer_1_array_crystal_width = 0.060000;
double channel_7_analyzer_1_array_crystal_height = 0.020000;
double channel_7_analyzer_1_array_crystal_depth = 0.002000;
int channel_7_analyzer_1_array_number_of_crystals = 9;
double channel_7_analyzer_1_array_total_height = 0.180000;
double channel_7_analyzer_1_array_radius_of_curvature = 0.500000;
double channel_7_analyzer_1_array_effective_radius_of_curvature;
double channel_7_analyzer_1_array_theta_max;
double channel_7_analyzer_1_array_delta_theta;
double channel_7_analyzer_1_array_theta[9];
int channel_7_analyzer_1_array_iterate;
double channel_7_analyzer_2_array_crystal_width = 0.060000;
double channel_7_analyzer_2_array_crystal_height = 0.020000;
double channel_7_analyzer_2_array_crystal_depth = 0.002000;
int channel_7_analyzer_2_array_number_of_crystals = 9;
double channel_7_analyzer_2_array_total_height = 0.180000;
double channel_7_analyzer_2_array_radius_of_curvature = 0.500000;
double channel_7_analyzer_2_array_effective_radius_of_curvature;
double channel_7_analyzer_2_array_theta_max;
double channel_7_analyzer_2_array_delta_theta;
double channel_7_analyzer_2_array_theta[9];
int channel_7_analyzer_2_array_iterate;
double channel_8_analyzer_1_array_crystal_width = 0.060000;
double channel_8_analyzer_1_array_crystal_height = 0.020000;
double channel_8_analyzer_1_array_crystal_depth = 0.002000;
int channel_8_analyzer_1_array_number_of_crystals = 9;
double channel_8_analyzer_1_array_total_height = 0.180000;
double channel_8_analyzer_1_array_radius_of_curvature = 0.500000;
double channel_8_analyzer_1_array_effective_radius_of_curvature;
double channel_8_analyzer_1_array_theta_max;
double channel_8_analyzer_1_array_delta_theta;
double channel_8_analyzer_1_array_theta[9];
int channel_8_analyzer_1_array_iterate;
double channel_8_analyzer_2_array_crystal_width = 0.060000;
double channel_8_analyzer_2_array_crystal_height = 0.020000;
double channel_8_analyzer_2_array_crystal_depth = 0.002000;
int channel_8_analyzer_2_array_number_of_crystals = 9;
double channel_8_analyzer_2_array_total_height = 0.180000;
double channel_8_analyzer_2_array_radius_of_curvature = 0.500000;
double channel_8_analyzer_2_array_effective_radius_of_curvature;
double channel_8_analyzer_2_array_theta_max;
double channel_8_analyzer_2_array_delta_theta;
double channel_8_analyzer_2_array_theta[9];
int channel_8_analyzer_2_array_iterate;
double channel_9_analyzer_1_array_crystal_width = 0.060000;
double channel_9_analyzer_1_array_crystal_height = 0.020000;
double channel_9_analyzer_1_array_crystal_depth = 0.002000;
int channel_9_analyzer_1_array_number_of_crystals = 9;
double channel_9_analyzer_1_array_total_height = 0.180000;
double channel_9_analyzer_1_array_radius_of_curvature = 0.500000;
double channel_9_analyzer_1_array_effective_radius_of_curvature;
double channel_9_analyzer_1_array_theta_max;
double channel_9_analyzer_1_array_delta_theta;
double channel_9_analyzer_1_array_theta[9];
int channel_9_analyzer_1_array_iterate;
double channel_9_analyzer_2_array_crystal_width = 0.060000;
double channel_9_analyzer_2_array_crystal_height = 0.020000;
double channel_9_analyzer_2_array_crystal_depth = 0.002000;
int channel_9_analyzer_2_array_number_of_crystals = 9;
double channel_9_analyzer_2_array_total_height = 0.180000;
double channel_9_analyzer_2_array_radius_of_curvature = 0.500000;
double channel_9_analyzer_2_array_effective_radius_of_curvature;
double channel_9_analyzer_2_array_theta_max;
double channel_9_analyzer_2_array_delta_theta;
double channel_9_analyzer_2_array_theta[9];
int channel_9_analyzer_2_array_iterate;
double channel_10_analyzer_1_array_crystal_width = 0.060000;
double channel_10_analyzer_1_array_crystal_height = 0.020000;
double channel_10_analyzer_1_array_crystal_depth = 0.002000;
int channel_10_analyzer_1_array_number_of_crystals = 9;
double channel_10_analyzer_1_array_total_height = 0.180000;
double channel_10_analyzer_1_array_radius_of_curvature = 0.500000;
double channel_10_analyzer_1_array_effective_radius_of_curvature;
double channel_10_analyzer_1_array_theta_max;
double channel_10_analyzer_1_array_delta_theta;
double channel_10_analyzer_1_array_theta[9];
int channel_10_analyzer_1_array_iterate;
double channel_10_analyzer_2_array_crystal_width = 0.060000;
double channel_10_analyzer_2_array_crystal_height = 0.020000;
double channel_10_analyzer_2_array_crystal_depth = 0.002000;
int channel_10_analyzer_2_array_number_of_crystals = 9;
double channel_10_analyzer_2_array_total_height = 0.180000;
double channel_10_analyzer_2_array_radius_of_curvature = 0.500000;
double channel_10_analyzer_2_array_effective_radius_of_curvature;
double channel_10_analyzer_2_array_theta_max;
double channel_10_analyzer_2_array_delta_theta;
double channel_10_analyzer_2_array_theta[9];
int channel_10_analyzer_2_array_iterate;
double channel_11_analyzer_1_array_crystal_width = 0.060000;
double channel_11_analyzer_1_array_crystal_height = 0.020000;
double channel_11_analyzer_1_array_crystal_depth = 0.002000;
int channel_11_analyzer_1_array_number_of_crystals = 9;
double channel_11_analyzer_1_array_total_height = 0.180000;
double channel_11_analyzer_1_array_radius_of_curvature = 0.500000;
double channel_11_analyzer_1_array_effective_radius_of_curvature;
double channel_11_analyzer_1_array_theta_max;
double channel_11_analyzer_1_array_delta_theta;
double channel_11_analyzer_1_array_theta[9];
int channel_11_analyzer_1_array_iterate;
double channel_11_analyzer_2_array_crystal_width = 0.060000;
double channel_11_analyzer_2_array_crystal_height = 0.020000;
double channel_11_analyzer_2_array_crystal_depth = 0.002000;
int channel_11_analyzer_2_array_number_of_crystals = 9;
double channel_11_analyzer_2_array_total_height = 0.180000;
double channel_11_analyzer_2_array_radius_of_curvature = 0.500000;
double channel_11_analyzer_2_array_effective_radius_of_curvature;
double channel_11_analyzer_2_array_theta_max;
double channel_11_analyzer_2_array_delta_theta;
double channel_11_analyzer_2_array_theta[9];
int channel_11_analyzer_2_array_iterate;
double channel_12_analyzer_1_array_crystal_width = 0.060000;
double channel_12_analyzer_1_array_crystal_height = 0.020000;
double channel_12_analyzer_1_array_crystal_depth = 0.002000;
int channel_12_analyzer_1_array_number_of_crystals = 9;
double channel_12_analyzer_1_array_total_height = 0.180000;
double channel_12_analyzer_1_array_radius_of_curvature = 0.500000;
double channel_12_analyzer_1_array_effective_radius_of_curvature;
double channel_12_analyzer_1_array_theta_max;
double channel_12_analyzer_1_array_delta_theta;
double channel_12_analyzer_1_array_theta[9];
int channel_12_analyzer_1_array_iterate;
double channel_12_analyzer_2_array_crystal_width = 0.060000;
double channel_12_analyzer_2_array_crystal_height = 0.020000;
double channel_12_analyzer_2_array_crystal_depth = 0.002000;
int channel_12_analyzer_2_array_number_of_crystals = 9;
double channel_12_analyzer_2_array_total_height = 0.180000;
double channel_12_analyzer_2_array_radius_of_curvature = 0.500000;
double channel_12_analyzer_2_array_effective_radius_of_curvature;
double channel_12_analyzer_2_array_theta_max;
double channel_12_analyzer_2_array_delta_theta;
double channel_12_analyzer_2_array_theta[9];
int channel_12_analyzer_2_array_iterate;
double channel_13_analyzer_1_array_crystal_width = 0.060000;
double channel_13_analyzer_1_array_crystal_height = 0.020000;
double channel_13_analyzer_1_array_crystal_depth = 0.002000;
int channel_13_analyzer_1_array_number_of_crystals = 9;
double channel_13_analyzer_1_array_total_height = 0.180000;
double channel_13_analyzer_1_array_radius_of_curvature = 0.500000;
double channel_13_analyzer_1_array_effective_radius_of_curvature;
double channel_13_analyzer_1_array_theta_max;
double channel_13_analyzer_1_array_delta_theta;
double channel_13_analyzer_1_array_theta[9];
int channel_13_analyzer_1_array_iterate;
double channel_13_analyzer_2_array_crystal_width = 0.060000;
double channel_13_analyzer_2_array_crystal_height = 0.020000;
double channel_13_analyzer_2_array_crystal_depth = 0.002000;
int channel_13_analyzer_2_array_number_of_crystals = 9;
double channel_13_analyzer_2_array_total_height = 0.180000;
double channel_13_analyzer_2_array_radius_of_curvature = 0.500000;
double channel_13_analyzer_2_array_effective_radius_of_curvature;
double channel_13_analyzer_2_array_theta_max;
double channel_13_analyzer_2_array_delta_theta;
double channel_13_analyzer_2_array_theta[9];
int channel_13_analyzer_2_array_iterate;
double channel_14_analyzer_1_array_crystal_width = 0.060000;
double channel_14_analyzer_1_array_crystal_height = 0.020000;
double channel_14_analyzer_1_array_crystal_depth = 0.002000;
int channel_14_analyzer_1_array_number_of_crystals = 9;
double channel_14_analyzer_1_array_total_height = 0.180000;
double channel_14_analyzer_1_array_radius_of_curvature = 0.500000;
double channel_14_analyzer_1_array_effective_radius_of_curvature;
double channel_14_analyzer_1_array_theta_max;
double channel_14_analyzer_1_array_delta_theta;
double channel_14_analyzer_1_array_theta[9];
int channel_14_analyzer_1_array_iterate;
double channel_14_analyzer_2_array_crystal_width = 0.060000;
double channel_14_analyzer_2_array_crystal_height = 0.020000;
double channel_14_analyzer_2_array_crystal_depth = 0.002000;
int channel_14_analyzer_2_array_number_of_crystals = 9;
double channel_14_analyzer_2_array_total_height = 0.180000;
double channel_14_analyzer_2_array_radius_of_curvature = 0.500000;
double channel_14_analyzer_2_array_effective_radius_of_curvature;
double channel_14_analyzer_2_array_theta_max;
double channel_14_analyzer_2_array_delta_theta;
double channel_14_analyzer_2_array_theta[9];
int channel_14_analyzer_2_array_iterate;
double channel_15_analyzer_1_array_crystal_width = 0.060000;
double channel_15_analyzer_1_array_crystal_height = 0.020000;
double channel_15_analyzer_1_array_crystal_depth = 0.002000;
int channel_15_analyzer_1_array_number_of_crystals = 9;
double channel_15_analyzer_1_array_total_height = 0.180000;
double channel_15_analyzer_1_array_radius_of_curvature = 0.500000;
double channel_15_analyzer_1_array_effective_radius_of_curvature;
double channel_15_analyzer_1_array_theta_max;
double channel_15_analyzer_1_array_delta_theta;
double channel_15_analyzer_1_array_theta[9];
int channel_15_analyzer_1_array_iterate;
double channel_15_analyzer_2_array_crystal_width = 0.060000;
double channel_15_analyzer_2_array_crystal_height = 0.020000;
double channel_15_analyzer_2_array_crystal_depth = 0.002000;
int channel_15_analyzer_2_array_number_of_crystals = 9;
double channel_15_analyzer_2_array_total_height = 0.180000;
double channel_15_analyzer_2_array_radius_of_curvature = 0.500000;
double channel_15_analyzer_2_array_effective_radius_of_curvature;
double channel_15_analyzer_2_array_theta_max;
double channel_15_analyzer_2_array_delta_theta;
double channel_15_analyzer_2_array_theta[9];
int channel_15_analyzer_2_array_iterate;
double channel_16_analyzer_1_array_crystal_width = 0.060000;
double channel_16_analyzer_1_array_crystal_height = 0.020000;
double channel_16_analyzer_1_array_crystal_depth = 0.002000;
int channel_16_analyzer_1_array_number_of_crystals = 9;
double channel_16_analyzer_1_array_total_height = 0.180000;
double channel_16_analyzer_1_array_radius_of_curvature = 0.500000;
double channel_16_analyzer_1_array_effective_radius_of_curvature;
double channel_16_analyzer_1_array_theta_max;
double channel_16_analyzer_1_array_delta_theta;
double channel_16_analyzer_1_array_theta[9];
int channel_16_analyzer_1_array_iterate;
double channel_16_analyzer_2_array_crystal_width = 0.060000;
double channel_16_analyzer_2_array_crystal_height = 0.020000;
double channel_16_analyzer_2_array_crystal_depth = 0.002000;
int channel_16_analyzer_2_array_number_of_crystals = 9;
double channel_16_analyzer_2_array_total_height = 0.180000;
double channel_16_analyzer_2_array_radius_of_curvature = 0.500000;
double channel_16_analyzer_2_array_effective_radius_of_curvature;
double channel_16_analyzer_2_array_theta_max;
double channel_16_analyzer_2_array_delta_theta;
double channel_16_analyzer_2_array_theta[9];
int channel_16_analyzer_2_array_iterate;
double channel_17_analyzer_1_array_crystal_width = 0.060000;
double channel_17_analyzer_1_array_crystal_height = 0.020000;
double channel_17_analyzer_1_array_crystal_depth = 0.002000;
int channel_17_analyzer_1_array_number_of_crystals = 9;
double channel_17_analyzer_1_array_total_height = 0.180000;
double channel_17_analyzer_1_array_radius_of_curvature = 0.500000;
double channel_17_analyzer_1_array_effective_radius_of_curvature;
double channel_17_analyzer_1_array_theta_max;
double channel_17_analyzer_1_array_delta_theta;
double channel_17_analyzer_1_array_theta[9];
int channel_17_analyzer_1_array_iterate;
double channel_17_analyzer_2_array_crystal_width = 0.060000;
double channel_17_analyzer_2_array_crystal_height = 0.020000;
double channel_17_analyzer_2_array_crystal_depth = 0.002000;
int channel_17_analyzer_2_array_number_of_crystals = 9;
double channel_17_analyzer_2_array_total_height = 0.180000;
double channel_17_analyzer_2_array_radius_of_curvature = 0.500000;
double channel_17_analyzer_2_array_effective_radius_of_curvature;
double channel_17_analyzer_2_array_theta_max;
double channel_17_analyzer_2_array_delta_theta;
double channel_17_analyzer_2_array_theta[9];
int channel_17_analyzer_2_array_iterate;
double channel_18_analyzer_1_array_crystal_width = 0.060000;
double channel_18_analyzer_1_array_crystal_height = 0.020000;
double channel_18_analyzer_1_array_crystal_depth = 0.002000;
int channel_18_analyzer_1_array_number_of_crystals = 9;
double channel_18_analyzer_1_array_total_height = 0.180000;
double channel_18_analyzer_1_array_radius_of_curvature = 0.500000;
double channel_18_analyzer_1_array_effective_radius_of_curvature;
double channel_18_analyzer_1_array_theta_max;
double channel_18_analyzer_1_array_delta_theta;
double channel_18_analyzer_1_array_theta[9];
int channel_18_analyzer_1_array_iterate;
double channel_18_analyzer_2_array_crystal_width = 0.060000;
double channel_18_analyzer_2_array_crystal_height = 0.020000;
double channel_18_analyzer_2_array_crystal_depth = 0.002000;
int channel_18_analyzer_2_array_number_of_crystals = 9;
double channel_18_analyzer_2_array_total_height = 0.180000;
double channel_18_analyzer_2_array_radius_of_curvature = 0.500000;
double channel_18_analyzer_2_array_effective_radius_of_curvature;
double channel_18_analyzer_2_array_theta_max;
double channel_18_analyzer_2_array_delta_theta;
double channel_18_analyzer_2_array_theta[9];
int channel_18_analyzer_2_array_iterate;
double channel_19_analyzer_1_array_crystal_width = 0.060000;
double channel_19_analyzer_1_array_crystal_height = 0.020000;
double channel_19_analyzer_1_array_crystal_depth = 0.002000;
int channel_19_analyzer_1_array_number_of_crystals = 9;
double channel_19_analyzer_1_array_total_height = 0.180000;
double channel_19_analyzer_1_array_radius_of_curvature = 0.500000;
double channel_19_analyzer_1_array_effective_radius_of_curvature;
double channel_19_analyzer_1_array_theta_max;
double channel_19_analyzer_1_array_delta_theta;
double channel_19_analyzer_1_array_theta[9];
int channel_19_analyzer_1_array_iterate;
double channel_19_analyzer_2_array_crystal_width = 0.060000;
double channel_19_analyzer_2_array_crystal_height = 0.020000;
double channel_19_analyzer_2_array_crystal_depth = 0.002000;
int channel_19_analyzer_2_array_number_of_crystals = 9;
double channel_19_analyzer_2_array_total_height = 0.180000;
double channel_19_analyzer_2_array_radius_of_curvature = 0.500000;
double channel_19_analyzer_2_array_effective_radius_of_curvature;
double channel_19_analyzer_2_array_theta_max;
double channel_19_analyzer_2_array_delta_theta;
double channel_19_analyzer_2_array_theta[9];
int channel_19_analyzer_2_array_iterate;
int detector_channel_diff;
int detector_channel_spec;
int nx_detector = 5;
int ny_detector = 5;
int detector_found;
int flag_sum;
int flag_single;
int flag_sum;
int flag_single;
int flag_sum;
int flag_single;
int flag_sum;
int flag_single;
int flag_sum;
int flag_single;
int flag_sum;
int flag_single;
int flag_sum;
int flag_single;
int flag_sum;
int flag_single;
int flag_sum;
int flag_single;
int flag_sum;
int flag_single;
int flag_sum;
int flag_single;
int flag_sum;
int flag_single;
int flag_sum;
int flag_single;
int flag_sum;
int flag_single;
int flag_sum;
int flag_single;
int flag_sum;
int flag_single;
int flag_sum;
int flag_single;
int flag_sum;
int flag_single;
int flag_sum;
int flag_single;
int flag_sum;
int flag_single;


/**** Defining reflectivity vectors  ******/

/**** Virtual output/input ****/
  char virtual_file_name[2048];

/***spline calculation ***/

/* Analyzators */
int iterate;
double analyzator_theta[20];
double delta_analyzator_position[20];
double distance_between_analyzators[20];
double EF[20];

double analyzator_1_radius;
double analyzator_2_radius;
double analyzator_depth;
double number_of_analyzator_blades;
double analyzator_horizontal_mosaic;
double analyzator_vertical_mosaic;
double analyzator_dirdev;
double analyzator_r0;
double analyzator_q;
double analyzator_transverse_distance;
double sample_analyzator_channel_distance;
double detector_analyzator_center_distance;

int analyzator_flag;
int channel_number;

/* ** nD ** */

// Sample environment
double stick_displacement;

// Flags

int scatter_events_in_sample;
int scatter_events_in_sample_environment;
int only_sample_scattering;

int flag_index;
// Update 50 if we go beyond 49 volumes in sample/sample environment
int scattering_history_sample_master[MAX_VOLUME_HISTORY_LENGTH];
int number_of_volumes_sample_main;

// Resolution mode
// When resolution_mode == 1, the system
int number_of_activations_normal;
int number_of_activations_exit;
int number_of_activations_sample;

// Temp test
int E_off;
double E,vlength;


#line 11474 "MACS_sample_kidney_box.c"
#undef dE_resolution
#undef E0_resolution
#undef repeat_count
#undef res_height
#undef res_radius
#undef resolution_mode
#undef slit_v
#undef slit_h
#undef monrot_delta
#undef mon_e
#undef mon_t
#undef L1_delta
#undef L0_delta
#undef DIVSOU
#undef DIRDEV
#undef misalign_mono_deg
#undef APE_v
#undef APE_h
#undef MPD
#undef MPL
#undef CPF
#undef beta_2
#undef beta_1
#undef sample_diameter_d
#undef VF
#undef HF
#undef EF_all
#undef EM
#undef kidney_angle
#undef A3_angle
#undef mcposadmtas
#undef mccompcurindex
#undef mccompcurtype
#undef mccompcurname

/* neutron state table at each component input (local coords) */
/* [x, y, z, vx, vy, vz, t, sx, sy, sz, p] */
MCNUM mccomp_storein[11*946];
/* Components position table (absolute and relative coords) */
Coords mccomp_posa[946];
Coords mccomp_posr[946];
/* Counter for each comp to check for inactive ones */
MCNUM  mcNCounter[946];
MCNUM  mcPCounter[946];
MCNUM  mcP2Counter[946];
#define mcNUMCOMP 945 /* number of components */
/* Counter for PROP ABSORB */
MCNUM  mcAbsorbProp[946];
/* Flag true when previous component acted on the neutron (SCATTER) */
MCNUM mcScattered=0;
/* Flag true when neutron should be restored (RESTORE) */
MCNUM mcRestore=0;
/* Component group definitions (flags), equals index of scattering comp */
int mcGroupfilter_group=0;
int mcGroupdetector_group=0;
/* Declarations of component definition and setting parameters. */

/* Setting parameters for component 'Al_incoherent' [1]. */
MCNUM mccAl_incoherent_sigma;
MCNUM mccAl_incoherent_f_QE;
MCNUM mccAl_incoherent_gamma;
MCNUM mccAl_incoherent_packing_factor;
MCNUM mccAl_incoherent_unit_cell_volume;
MCNUM mccAl_incoherent_interact_fraction;

/* Definition parameters for component 'Al_powder' [2]. */
#define mccAl_powder_format Undefined
/* Setting parameters for component 'Al_powder' [2]. */
char mccAl_powder_reflections[16384];
MCNUM mccAl_powder_packing_factor;
MCNUM mccAl_powder_Vc;
MCNUM mccAl_powder_delta_d_d;
MCNUM mccAl_powder_DW;
MCNUM mccAl_powder_nb_atoms;
MCNUM mccAl_powder_d_phi;
MCNUM mccAl_powder_density;
MCNUM mccAl_powder_weight;
MCNUM mccAl_powder_barns;
MCNUM mccAl_powder_Strain;
MCNUM mccAl_powder_interact_fraction;

/* Setting parameters for component 'Al' [3]. */
char mccAl_process_string[16384];
MCNUM mccAl_my_absorption;
MCNUM mccAl_absorber;

/* Setting parameters for component 'TiO2_incoherent' [4]. */
MCNUM mccTiO2_incoherent_sigma;
MCNUM mccTiO2_incoherent_f_QE;
MCNUM mccTiO2_incoherent_gamma;
MCNUM mccTiO2_incoherent_packing_factor;
MCNUM mccTiO2_incoherent_unit_cell_volume;
MCNUM mccTiO2_incoherent_interact_fraction;

/* Definition parameters for component 'TiO2_single_crystal' [5]. */
#define mccTiO2_single_crystal_mosaic_AB Mosaic_AB_Undefined
/* Setting parameters for component 'TiO2_single_crystal' [5]. */
char mccTiO2_single_crystal_reflections[16384];
MCNUM mccTiO2_single_crystal_delta_d_d;
MCNUM mccTiO2_single_crystal_mosaic;
MCNUM mccTiO2_single_crystal_mosaic_a;
MCNUM mccTiO2_single_crystal_mosaic_b;
MCNUM mccTiO2_single_crystal_mosaic_c;
MCNUM mccTiO2_single_crystal_recip_cell;
MCNUM mccTiO2_single_crystal_barns;
MCNUM mccTiO2_single_crystal_ax;
MCNUM mccTiO2_single_crystal_ay;
MCNUM mccTiO2_single_crystal_az;
MCNUM mccTiO2_single_crystal_bx;
MCNUM mccTiO2_single_crystal_by;
MCNUM mccTiO2_single_crystal_bz;
MCNUM mccTiO2_single_crystal_cx;
MCNUM mccTiO2_single_crystal_cy;
MCNUM mccTiO2_single_crystal_cz;
MCNUM mccTiO2_single_crystal_aa;
MCNUM mccTiO2_single_crystal_bb;
MCNUM mccTiO2_single_crystal_cc;
MCNUM mccTiO2_single_crystal_order;
MCNUM mccTiO2_single_crystal_RX;
MCNUM mccTiO2_single_crystal_RY;
MCNUM mccTiO2_single_crystal_RZ;
MCNUM mccTiO2_single_crystal_powder;
MCNUM mccTiO2_single_crystal_PG;
MCNUM mccTiO2_single_crystal_interact_fraction;
MCNUM mccTiO2_single_crystal_packing_factor;

/* Setting parameters for component 'TiO2' [6]. */
char mccTiO2_process_string[16384];
MCNUM mccTiO2_my_absorption;
MCNUM mccTiO2_absorber;

/* Setting parameters for component 'TiO2_poly_incoherent' [7]. */
MCNUM mccTiO2_poly_incoherent_sigma;
MCNUM mccTiO2_poly_incoherent_f_QE;
MCNUM mccTiO2_poly_incoherent_gamma;
MCNUM mccTiO2_poly_incoherent_packing_factor;
MCNUM mccTiO2_poly_incoherent_unit_cell_volume;
MCNUM mccTiO2_poly_incoherent_interact_fraction;

/* Setting parameters for component 'TiO2_poly' [8]. */
char mccTiO2_poly_process_string[16384];
MCNUM mccTiO2_poly_my_absorption;
MCNUM mccTiO2_poly_absorber;

/* Setting parameters for component 'Al_incoherent_B' [9]. */
MCNUM mccAl_incoherent_B_sigma;
MCNUM mccAl_incoherent_B_f_QE;
MCNUM mccAl_incoherent_B_gamma;
MCNUM mccAl_incoherent_B_packing_factor;
MCNUM mccAl_incoherent_B_unit_cell_volume;
MCNUM mccAl_incoherent_B_interact_fraction;

/* Definition parameters for component 'Al_powder_B' [10]. */
#define mccAl_powder_B_format Undefined
/* Setting parameters for component 'Al_powder_B' [10]. */
char mccAl_powder_B_reflections[16384];
MCNUM mccAl_powder_B_packing_factor;
MCNUM mccAl_powder_B_Vc;
MCNUM mccAl_powder_B_delta_d_d;
MCNUM mccAl_powder_B_DW;
MCNUM mccAl_powder_B_nb_atoms;
MCNUM mccAl_powder_B_d_phi;
MCNUM mccAl_powder_B_density;
MCNUM mccAl_powder_B_weight;
MCNUM mccAl_powder_B_barns;
MCNUM mccAl_powder_B_Strain;
MCNUM mccAl_powder_B_interact_fraction;

/* Setting parameters for component 'Al_B' [11]. */
char mccAl_B_process_string[16384];
MCNUM mccAl_B_my_absorption;
MCNUM mccAl_B_absorber;

/* Setting parameters for component 'Arm0' [12]. */
char mccArm0_profile[16384];
MCNUM mccArm0_percent;
MCNUM mccArm0_flag_save;
MCNUM mccArm0_minutes;

/* Setting parameters for component 'Guide_end' [13]. */
char mccGuide_end_filename[16384];
MCNUM mccGuide_end_verbose;
MCNUM mccGuide_end_repeat_count;
MCNUM mccGuide_end_smooth;
MCNUM mccGuide_end_display;

/* Setting parameters for component 'main_slit' [14]. */
MCNUM mccmain_slit_xmin;
MCNUM mccmain_slit_xmax;
MCNUM mccmain_slit_ymin;
MCNUM mccmain_slit_ymax;
MCNUM mccmain_slit_radius;
MCNUM mccmain_slit_xwidth;
MCNUM mccmain_slit_yheight;

/* Setting parameters for component 'sample' [20]. */
char mccsample_material_string[16384];
MCNUM mccsample_priority;
MCNUM mccsample_xwidth;
MCNUM mccsample_yheight;
MCNUM mccsample_zdepth;
MCNUM mccsample_xwidth2;
MCNUM mccsample_yheight2;
MCNUM mccsample_visualize;
int mccsample_target_index;
MCNUM mccsample_target_x;
MCNUM mccsample_target_y;
MCNUM mccsample_target_z;
MCNUM mccsample_focus_aw;
MCNUM mccsample_focus_ah;
MCNUM mccsample_focus_xw;
MCNUM mccsample_focus_xh;
MCNUM mccsample_focus_r;
MCNUM mccsample_p_interact;
char mccsample_mask_string[16384];
char mccsample_mask_setting[16384];
MCNUM mccsample_number_of_activations;

/* Setting parameters for component 'sample_plate' [21]. */
char mccsample_plate_material_string[16384];
MCNUM mccsample_plate_priority;
MCNUM mccsample_plate_radius;
MCNUM mccsample_plate_yheight;
MCNUM mccsample_plate_visualize;
int mccsample_plate_target_index;
MCNUM mccsample_plate_target_x;
MCNUM mccsample_plate_target_y;
MCNUM mccsample_plate_target_z;
MCNUM mccsample_plate_focus_aw;
MCNUM mccsample_plate_focus_ah;
MCNUM mccsample_plate_focus_xw;
MCNUM mccsample_plate_focus_xh;
MCNUM mccsample_plate_focus_r;
MCNUM mccsample_plate_p_interact;
char mccsample_plate_mask_string[16384];
char mccsample_plate_mask_setting[16384];
MCNUM mccsample_plate_number_of_activations;

/* Setting parameters for component 'sample_plate_rod' [22]. */
char mccsample_plate_rod_material_string[16384];
MCNUM mccsample_plate_rod_priority;
MCNUM mccsample_plate_rod_radius;
MCNUM mccsample_plate_rod_yheight;
MCNUM mccsample_plate_rod_visualize;
int mccsample_plate_rod_target_index;
MCNUM mccsample_plate_rod_target_x;
MCNUM mccsample_plate_rod_target_y;
MCNUM mccsample_plate_rod_target_z;
MCNUM mccsample_plate_rod_focus_aw;
MCNUM mccsample_plate_rod_focus_ah;
MCNUM mccsample_plate_rod_focus_xw;
MCNUM mccsample_plate_rod_focus_xh;
MCNUM mccsample_plate_rod_focus_r;
MCNUM mccsample_plate_rod_p_interact;
char mccsample_plate_rod_mask_string[16384];
char mccsample_plate_rod_mask_setting[16384];
MCNUM mccsample_plate_rod_number_of_activations;

/* Setting parameters for component 'sample_base' [23]. */
char mccsample_base_material_string[16384];
MCNUM mccsample_base_priority;
MCNUM mccsample_base_radius;
MCNUM mccsample_base_yheight;
MCNUM mccsample_base_visualize;
int mccsample_base_target_index;
MCNUM mccsample_base_target_x;
MCNUM mccsample_base_target_y;
MCNUM mccsample_base_target_z;
MCNUM mccsample_base_focus_aw;
MCNUM mccsample_base_focus_ah;
MCNUM mccsample_base_focus_xw;
MCNUM mccsample_base_focus_xh;
MCNUM mccsample_base_focus_r;
MCNUM mccsample_base_p_interact;
char mccsample_base_mask_string[16384];
char mccsample_base_mask_setting[16384];
MCNUM mccsample_base_number_of_activations;

/* Setting parameters for component 'sample_base_gap' [24]. */
char mccsample_base_gap_material_string[16384];
MCNUM mccsample_base_gap_priority;
MCNUM mccsample_base_gap_radius;
MCNUM mccsample_base_gap_yheight;
MCNUM mccsample_base_gap_visualize;
int mccsample_base_gap_target_index;
MCNUM mccsample_base_gap_target_x;
MCNUM mccsample_base_gap_target_y;
MCNUM mccsample_base_gap_target_z;
MCNUM mccsample_base_gap_focus_aw;
MCNUM mccsample_base_gap_focus_ah;
MCNUM mccsample_base_gap_focus_xw;
MCNUM mccsample_base_gap_focus_xh;
MCNUM mccsample_base_gap_focus_r;
MCNUM mccsample_base_gap_p_interact;
char mccsample_base_gap_mask_string[16384];
char mccsample_base_gap_mask_setting[16384];
MCNUM mccsample_base_gap_number_of_activations;

/* Setting parameters for component 'cryostat_mountin_plate' [25]. */
char mcccryostat_mountin_plate_material_string[16384];
MCNUM mcccryostat_mountin_plate_priority;
MCNUM mcccryostat_mountin_plate_radius;
MCNUM mcccryostat_mountin_plate_yheight;
MCNUM mcccryostat_mountin_plate_visualize;
int mcccryostat_mountin_plate_target_index;
MCNUM mcccryostat_mountin_plate_target_x;
MCNUM mcccryostat_mountin_plate_target_y;
MCNUM mcccryostat_mountin_plate_target_z;
MCNUM mcccryostat_mountin_plate_focus_aw;
MCNUM mcccryostat_mountin_plate_focus_ah;
MCNUM mcccryostat_mountin_plate_focus_xw;
MCNUM mcccryostat_mountin_plate_focus_xh;
MCNUM mcccryostat_mountin_plate_focus_r;
MCNUM mcccryostat_mountin_plate_p_interact;
char mcccryostat_mountin_plate_mask_string[16384];
char mcccryostat_mountin_plate_mask_setting[16384];
MCNUM mcccryostat_mountin_plate_number_of_activations;

/* Setting parameters for component 'cryostat_drum_walls' [26]. */
char mcccryostat_drum_walls_material_string[16384];
MCNUM mcccryostat_drum_walls_priority;
MCNUM mcccryostat_drum_walls_radius;
MCNUM mcccryostat_drum_walls_yheight;
MCNUM mcccryostat_drum_walls_visualize;
int mcccryostat_drum_walls_target_index;
MCNUM mcccryostat_drum_walls_target_x;
MCNUM mcccryostat_drum_walls_target_y;
MCNUM mcccryostat_drum_walls_target_z;
MCNUM mcccryostat_drum_walls_focus_aw;
MCNUM mcccryostat_drum_walls_focus_ah;
MCNUM mcccryostat_drum_walls_focus_xw;
MCNUM mcccryostat_drum_walls_focus_xh;
MCNUM mcccryostat_drum_walls_focus_r;
MCNUM mcccryostat_drum_walls_p_interact;
char mcccryostat_drum_walls_mask_string[16384];
char mcccryostat_drum_walls_mask_setting[16384];
MCNUM mcccryostat_drum_walls_number_of_activations;

/* Setting parameters for component 'cryostat_drum_vacuum' [27]. */
char mcccryostat_drum_vacuum_material_string[16384];
MCNUM mcccryostat_drum_vacuum_priority;
MCNUM mcccryostat_drum_vacuum_radius;
MCNUM mcccryostat_drum_vacuum_yheight;
MCNUM mcccryostat_drum_vacuum_visualize;
int mcccryostat_drum_vacuum_target_index;
MCNUM mcccryostat_drum_vacuum_target_x;
MCNUM mcccryostat_drum_vacuum_target_y;
MCNUM mcccryostat_drum_vacuum_target_z;
MCNUM mcccryostat_drum_vacuum_focus_aw;
MCNUM mcccryostat_drum_vacuum_focus_ah;
MCNUM mcccryostat_drum_vacuum_focus_xw;
MCNUM mcccryostat_drum_vacuum_focus_xh;
MCNUM mcccryostat_drum_vacuum_focus_r;
MCNUM mcccryostat_drum_vacuum_p_interact;
char mcccryostat_drum_vacuum_mask_string[16384];
char mcccryostat_drum_vacuum_mask_setting[16384];
MCNUM mcccryostat_drum_vacuum_number_of_activations;

/* Setting parameters for component 'outer_cryostat_wall' [28]. */
char mccouter_cryostat_wall_material_string[16384];
MCNUM mccouter_cryostat_wall_priority;
MCNUM mccouter_cryostat_wall_radius;
MCNUM mccouter_cryostat_wall_yheight;
MCNUM mccouter_cryostat_wall_visualize;
int mccouter_cryostat_wall_target_index;
MCNUM mccouter_cryostat_wall_target_x;
MCNUM mccouter_cryostat_wall_target_y;
MCNUM mccouter_cryostat_wall_target_z;
MCNUM mccouter_cryostat_wall_focus_aw;
MCNUM mccouter_cryostat_wall_focus_ah;
MCNUM mccouter_cryostat_wall_focus_xw;
MCNUM mccouter_cryostat_wall_focus_xh;
MCNUM mccouter_cryostat_wall_focus_r;
MCNUM mccouter_cryostat_wall_p_interact;
char mccouter_cryostat_wall_mask_string[16384];
char mccouter_cryostat_wall_mask_setting[16384];
MCNUM mccouter_cryostat_wall_number_of_activations;

/* Setting parameters for component 'outer_cryostat_vacuum' [29]. */
char mccouter_cryostat_vacuum_material_string[16384];
MCNUM mccouter_cryostat_vacuum_priority;
MCNUM mccouter_cryostat_vacuum_radius;
MCNUM mccouter_cryostat_vacuum_yheight;
MCNUM mccouter_cryostat_vacuum_visualize;
int mccouter_cryostat_vacuum_target_index;
MCNUM mccouter_cryostat_vacuum_target_x;
MCNUM mccouter_cryostat_vacuum_target_y;
MCNUM mccouter_cryostat_vacuum_target_z;
MCNUM mccouter_cryostat_vacuum_focus_aw;
MCNUM mccouter_cryostat_vacuum_focus_ah;
MCNUM mccouter_cryostat_vacuum_focus_xw;
MCNUM mccouter_cryostat_vacuum_focus_xh;
MCNUM mccouter_cryostat_vacuum_focus_r;
MCNUM mccouter_cryostat_vacuum_p_interact;
char mccouter_cryostat_vacuum_mask_string[16384];
char mccouter_cryostat_vacuum_mask_setting[16384];
MCNUM mccouter_cryostat_vacuum_number_of_activations;

/* Setting parameters for component 'inner_cryostat_wall' [30]. */
char mccinner_cryostat_wall_material_string[16384];
MCNUM mccinner_cryostat_wall_priority;
MCNUM mccinner_cryostat_wall_radius;
MCNUM mccinner_cryostat_wall_yheight;
MCNUM mccinner_cryostat_wall_visualize;
int mccinner_cryostat_wall_target_index;
MCNUM mccinner_cryostat_wall_target_x;
MCNUM mccinner_cryostat_wall_target_y;
MCNUM mccinner_cryostat_wall_target_z;
MCNUM mccinner_cryostat_wall_focus_aw;
MCNUM mccinner_cryostat_wall_focus_ah;
MCNUM mccinner_cryostat_wall_focus_xw;
MCNUM mccinner_cryostat_wall_focus_xh;
MCNUM mccinner_cryostat_wall_focus_r;
MCNUM mccinner_cryostat_wall_p_interact;
char mccinner_cryostat_wall_mask_string[16384];
char mccinner_cryostat_wall_mask_setting[16384];
MCNUM mccinner_cryostat_wall_number_of_activations;

/* Setting parameters for component 'inner_cryostat_vacuum' [31]. */
char mccinner_cryostat_vacuum_material_string[16384];
MCNUM mccinner_cryostat_vacuum_priority;
MCNUM mccinner_cryostat_vacuum_radius;
MCNUM mccinner_cryostat_vacuum_yheight;
MCNUM mccinner_cryostat_vacuum_visualize;
int mccinner_cryostat_vacuum_target_index;
MCNUM mccinner_cryostat_vacuum_target_x;
MCNUM mccinner_cryostat_vacuum_target_y;
MCNUM mccinner_cryostat_vacuum_target_z;
MCNUM mccinner_cryostat_vacuum_focus_aw;
MCNUM mccinner_cryostat_vacuum_focus_ah;
MCNUM mccinner_cryostat_vacuum_focus_xw;
MCNUM mccinner_cryostat_vacuum_focus_xh;
MCNUM mccinner_cryostat_vacuum_focus_r;
MCNUM mccinner_cryostat_vacuum_p_interact;
char mccinner_cryostat_vacuum_mask_string[16384];
char mccinner_cryostat_vacuum_mask_setting[16384];
MCNUM mccinner_cryostat_vacuum_number_of_activations;

/* Setting parameters for component 'sample_stick_walls' [32]. */
char mccsample_stick_walls_material_string[16384];
MCNUM mccsample_stick_walls_priority;
MCNUM mccsample_stick_walls_radius;
MCNUM mccsample_stick_walls_yheight;
MCNUM mccsample_stick_walls_visualize;
int mccsample_stick_walls_target_index;
MCNUM mccsample_stick_walls_target_x;
MCNUM mccsample_stick_walls_target_y;
MCNUM mccsample_stick_walls_target_z;
MCNUM mccsample_stick_walls_focus_aw;
MCNUM mccsample_stick_walls_focus_ah;
MCNUM mccsample_stick_walls_focus_xw;
MCNUM mccsample_stick_walls_focus_xh;
MCNUM mccsample_stick_walls_focus_r;
MCNUM mccsample_stick_walls_p_interact;
char mccsample_stick_walls_mask_string[16384];
char mccsample_stick_walls_mask_setting[16384];
MCNUM mccsample_stick_walls_number_of_activations;

/* Setting parameters for component 'sample_stick_vacuum' [33]. */
char mccsample_stick_vacuum_material_string[16384];
MCNUM mccsample_stick_vacuum_priority;
MCNUM mccsample_stick_vacuum_radius;
MCNUM mccsample_stick_vacuum_yheight;
MCNUM mccsample_stick_vacuum_visualize;
int mccsample_stick_vacuum_target_index;
MCNUM mccsample_stick_vacuum_target_x;
MCNUM mccsample_stick_vacuum_target_y;
MCNUM mccsample_stick_vacuum_target_z;
MCNUM mccsample_stick_vacuum_focus_aw;
MCNUM mccsample_stick_vacuum_focus_ah;
MCNUM mccsample_stick_vacuum_focus_xw;
MCNUM mccsample_stick_vacuum_focus_xh;
MCNUM mccsample_stick_vacuum_focus_r;
MCNUM mccsample_stick_vacuum_p_interact;
char mccsample_stick_vacuum_mask_string[16384];
char mccsample_stick_vacuum_mask_setting[16384];
MCNUM mccsample_stick_vacuum_number_of_activations;

/* Setting parameters for component 'sample_rod' [35]. */
char mccsample_rod_material_string[16384];
MCNUM mccsample_rod_priority;
MCNUM mccsample_rod_radius;
MCNUM mccsample_rod_yheight;
MCNUM mccsample_rod_visualize;
int mccsample_rod_target_index;
MCNUM mccsample_rod_target_x;
MCNUM mccsample_rod_target_y;
MCNUM mccsample_rod_target_z;
MCNUM mccsample_rod_focus_aw;
MCNUM mccsample_rod_focus_ah;
MCNUM mccsample_rod_focus_xw;
MCNUM mccsample_rod_focus_xh;
MCNUM mccsample_rod_focus_r;
MCNUM mccsample_rod_p_interact;
char mccsample_rod_mask_string[16384];
char mccsample_rod_mask_setting[16384];
MCNUM mccsample_rod_number_of_activations;

/* Setting parameters for component 'sample_rod_collar_1' [36]. */
char mccsample_rod_collar_1_material_string[16384];
MCNUM mccsample_rod_collar_1_priority;
MCNUM mccsample_rod_collar_1_radius;
MCNUM mccsample_rod_collar_1_yheight;
MCNUM mccsample_rod_collar_1_visualize;
int mccsample_rod_collar_1_target_index;
MCNUM mccsample_rod_collar_1_target_x;
MCNUM mccsample_rod_collar_1_target_y;
MCNUM mccsample_rod_collar_1_target_z;
MCNUM mccsample_rod_collar_1_focus_aw;
MCNUM mccsample_rod_collar_1_focus_ah;
MCNUM mccsample_rod_collar_1_focus_xw;
MCNUM mccsample_rod_collar_1_focus_xh;
MCNUM mccsample_rod_collar_1_focus_r;
MCNUM mccsample_rod_collar_1_p_interact;
char mccsample_rod_collar_1_mask_string[16384];
char mccsample_rod_collar_1_mask_setting[16384];
MCNUM mccsample_rod_collar_1_number_of_activations;

/* Setting parameters for component 'sample_rod_collar_2' [37]. */
char mccsample_rod_collar_2_material_string[16384];
MCNUM mccsample_rod_collar_2_priority;
MCNUM mccsample_rod_collar_2_radius;
MCNUM mccsample_rod_collar_2_yheight;
MCNUM mccsample_rod_collar_2_visualize;
int mccsample_rod_collar_2_target_index;
MCNUM mccsample_rod_collar_2_target_x;
MCNUM mccsample_rod_collar_2_target_y;
MCNUM mccsample_rod_collar_2_target_z;
MCNUM mccsample_rod_collar_2_focus_aw;
MCNUM mccsample_rod_collar_2_focus_ah;
MCNUM mccsample_rod_collar_2_focus_xw;
MCNUM mccsample_rod_collar_2_focus_xh;
MCNUM mccsample_rod_collar_2_focus_r;
MCNUM mccsample_rod_collar_2_p_interact;
char mccsample_rod_collar_2_mask_string[16384];
char mccsample_rod_collar_2_mask_setting[16384];
MCNUM mccsample_rod_collar_2_number_of_activations;

/* Setting parameters for component 'sample_rod_collar_3' [38]. */
char mccsample_rod_collar_3_material_string[16384];
MCNUM mccsample_rod_collar_3_priority;
MCNUM mccsample_rod_collar_3_radius;
MCNUM mccsample_rod_collar_3_yheight;
MCNUM mccsample_rod_collar_3_visualize;
int mccsample_rod_collar_3_target_index;
MCNUM mccsample_rod_collar_3_target_x;
MCNUM mccsample_rod_collar_3_target_y;
MCNUM mccsample_rod_collar_3_target_z;
MCNUM mccsample_rod_collar_3_focus_aw;
MCNUM mccsample_rod_collar_3_focus_ah;
MCNUM mccsample_rod_collar_3_focus_xw;
MCNUM mccsample_rod_collar_3_focus_xh;
MCNUM mccsample_rod_collar_3_focus_r;
MCNUM mccsample_rod_collar_3_p_interact;
char mccsample_rod_collar_3_mask_string[16384];
char mccsample_rod_collar_3_mask_setting[16384];
MCNUM mccsample_rod_collar_3_number_of_activations;

/* Setting parameters for component 'sample_rod_collar_4' [39]. */
char mccsample_rod_collar_4_material_string[16384];
MCNUM mccsample_rod_collar_4_priority;
MCNUM mccsample_rod_collar_4_radius;
MCNUM mccsample_rod_collar_4_yheight;
MCNUM mccsample_rod_collar_4_visualize;
int mccsample_rod_collar_4_target_index;
MCNUM mccsample_rod_collar_4_target_x;
MCNUM mccsample_rod_collar_4_target_y;
MCNUM mccsample_rod_collar_4_target_z;
MCNUM mccsample_rod_collar_4_focus_aw;
MCNUM mccsample_rod_collar_4_focus_ah;
MCNUM mccsample_rod_collar_4_focus_xw;
MCNUM mccsample_rod_collar_4_focus_xh;
MCNUM mccsample_rod_collar_4_focus_r;
MCNUM mccsample_rod_collar_4_p_interact;
char mccsample_rod_collar_4_mask_string[16384];
char mccsample_rod_collar_4_mask_setting[16384];
MCNUM mccsample_rod_collar_4_number_of_activations;

/* Setting parameters for component 'sample_rod_collar_1_vacuum' [40]. */
char mccsample_rod_collar_1_vacuum_material_string[16384];
MCNUM mccsample_rod_collar_1_vacuum_priority;
MCNUM mccsample_rod_collar_1_vacuum_radius;
MCNUM mccsample_rod_collar_1_vacuum_yheight;
MCNUM mccsample_rod_collar_1_vacuum_visualize;
int mccsample_rod_collar_1_vacuum_target_index;
MCNUM mccsample_rod_collar_1_vacuum_target_x;
MCNUM mccsample_rod_collar_1_vacuum_target_y;
MCNUM mccsample_rod_collar_1_vacuum_target_z;
MCNUM mccsample_rod_collar_1_vacuum_focus_aw;
MCNUM mccsample_rod_collar_1_vacuum_focus_ah;
MCNUM mccsample_rod_collar_1_vacuum_focus_xw;
MCNUM mccsample_rod_collar_1_vacuum_focus_xh;
MCNUM mccsample_rod_collar_1_vacuum_focus_r;
MCNUM mccsample_rod_collar_1_vacuum_p_interact;
char mccsample_rod_collar_1_vacuum_mask_string[16384];
char mccsample_rod_collar_1_vacuum_mask_setting[16384];
MCNUM mccsample_rod_collar_1_vacuum_number_of_activations;

/* Setting parameters for component 'sample_rod_collar_2_vacuum' [41]. */
char mccsample_rod_collar_2_vacuum_material_string[16384];
MCNUM mccsample_rod_collar_2_vacuum_priority;
MCNUM mccsample_rod_collar_2_vacuum_radius;
MCNUM mccsample_rod_collar_2_vacuum_yheight;
MCNUM mccsample_rod_collar_2_vacuum_visualize;
int mccsample_rod_collar_2_vacuum_target_index;
MCNUM mccsample_rod_collar_2_vacuum_target_x;
MCNUM mccsample_rod_collar_2_vacuum_target_y;
MCNUM mccsample_rod_collar_2_vacuum_target_z;
MCNUM mccsample_rod_collar_2_vacuum_focus_aw;
MCNUM mccsample_rod_collar_2_vacuum_focus_ah;
MCNUM mccsample_rod_collar_2_vacuum_focus_xw;
MCNUM mccsample_rod_collar_2_vacuum_focus_xh;
MCNUM mccsample_rod_collar_2_vacuum_focus_r;
MCNUM mccsample_rod_collar_2_vacuum_p_interact;
char mccsample_rod_collar_2_vacuum_mask_string[16384];
char mccsample_rod_collar_2_vacuum_mask_setting[16384];
MCNUM mccsample_rod_collar_2_vacuum_number_of_activations;

/* Setting parameters for component 'sample_rod_collar_3_vacuum' [42]. */
char mccsample_rod_collar_3_vacuum_material_string[16384];
MCNUM mccsample_rod_collar_3_vacuum_priority;
MCNUM mccsample_rod_collar_3_vacuum_radius;
MCNUM mccsample_rod_collar_3_vacuum_yheight;
MCNUM mccsample_rod_collar_3_vacuum_visualize;
int mccsample_rod_collar_3_vacuum_target_index;
MCNUM mccsample_rod_collar_3_vacuum_target_x;
MCNUM mccsample_rod_collar_3_vacuum_target_y;
MCNUM mccsample_rod_collar_3_vacuum_target_z;
MCNUM mccsample_rod_collar_3_vacuum_focus_aw;
MCNUM mccsample_rod_collar_3_vacuum_focus_ah;
MCNUM mccsample_rod_collar_3_vacuum_focus_xw;
MCNUM mccsample_rod_collar_3_vacuum_focus_xh;
MCNUM mccsample_rod_collar_3_vacuum_focus_r;
MCNUM mccsample_rod_collar_3_vacuum_p_interact;
char mccsample_rod_collar_3_vacuum_mask_string[16384];
char mccsample_rod_collar_3_vacuum_mask_setting[16384];
MCNUM mccsample_rod_collar_3_vacuum_number_of_activations;

/* Setting parameters for component 'sample_rod_collar_4_vacuum' [43]. */
char mccsample_rod_collar_4_vacuum_material_string[16384];
MCNUM mccsample_rod_collar_4_vacuum_priority;
MCNUM mccsample_rod_collar_4_vacuum_radius;
MCNUM mccsample_rod_collar_4_vacuum_yheight;
MCNUM mccsample_rod_collar_4_vacuum_visualize;
int mccsample_rod_collar_4_vacuum_target_index;
MCNUM mccsample_rod_collar_4_vacuum_target_x;
MCNUM mccsample_rod_collar_4_vacuum_target_y;
MCNUM mccsample_rod_collar_4_vacuum_target_z;
MCNUM mccsample_rod_collar_4_vacuum_focus_aw;
MCNUM mccsample_rod_collar_4_vacuum_focus_ah;
MCNUM mccsample_rod_collar_4_vacuum_focus_xw;
MCNUM mccsample_rod_collar_4_vacuum_focus_xh;
MCNUM mccsample_rod_collar_4_vacuum_focus_r;
MCNUM mccsample_rod_collar_4_vacuum_p_interact;
char mccsample_rod_collar_4_vacuum_mask_string[16384];
char mccsample_rod_collar_4_vacuum_mask_setting[16384];
MCNUM mccsample_rod_collar_4_vacuum_number_of_activations;

/* Setting parameters for component 'resolution_sample_exit' [44]. */
char mccresolution_sample_exit_material_string[16384];
MCNUM mccresolution_sample_exit_priority;
MCNUM mccresolution_sample_exit_radius;
MCNUM mccresolution_sample_exit_yheight;
MCNUM mccresolution_sample_exit_visualize;
int mccresolution_sample_exit_target_index;
MCNUM mccresolution_sample_exit_target_x;
MCNUM mccresolution_sample_exit_target_y;
MCNUM mccresolution_sample_exit_target_z;
MCNUM mccresolution_sample_exit_focus_aw;
MCNUM mccresolution_sample_exit_focus_ah;
MCNUM mccresolution_sample_exit_focus_xw;
MCNUM mccresolution_sample_exit_focus_xh;
MCNUM mccresolution_sample_exit_focus_r;
MCNUM mccresolution_sample_exit_p_interact;
char mccresolution_sample_exit_mask_string[16384];
char mccresolution_sample_exit_mask_setting[16384];
MCNUM mccresolution_sample_exit_number_of_activations;

/* Setting parameters for component 'sample_cryostat' [45]. */
MCNUM mccsample_cryostat_allow_inside_start;
MCNUM mccsample_cryostat_history_limit;
MCNUM mccsample_cryostat_enable_conditionals;
MCNUM mccsample_cryostat_inherit_number_of_scattering_events;

/* Setting parameters for component 'Resolution_sample' [46]. */
MCNUM mccResolution_sample_thickness;
MCNUM mccResolution_sample_radius;
MCNUM mccResolution_sample_focus_r;
MCNUM mccResolution_sample_E0;
MCNUM mccResolution_sample_dE;
MCNUM mccResolution_sample_target_x;
MCNUM mccResolution_sample_target_y;
MCNUM mccResolution_sample_target_z;
MCNUM mccResolution_sample_focus_xw;
MCNUM mccResolution_sample_focus_yh;
MCNUM mccResolution_sample_focus_aw;
MCNUM mccResolution_sample_focus_ah;
MCNUM mccResolution_sample_xwidth;
MCNUM mccResolution_sample_yheight;
MCNUM mccResolution_sample_zdepth;
int mccResolution_sample_target_index;

/* Setting parameters for component 'post_sample_beamstop' [47]. */
MCNUM mccpost_sample_beamstop_xmin;
MCNUM mccpost_sample_beamstop_xmax;
MCNUM mccpost_sample_beamstop_ymin;
MCNUM mccpost_sample_beamstop_ymax;
MCNUM mccpost_sample_beamstop_xwidth;
MCNUM mccpost_sample_beamstop_yheight;
MCNUM mccpost_sample_beamstop_radius;

/* Setting parameters for component 'channel_0_filter' [69]. */
MCNUM mccchannel_0_filter_xmin;
MCNUM mccchannel_0_filter_xmax;
MCNUM mccchannel_0_filter_ymin;
MCNUM mccchannel_0_filter_ymax;
MCNUM mccchannel_0_filter_radius;
MCNUM mccchannel_0_filter_xwidth;
MCNUM mccchannel_0_filter_yheight;

/* Setting parameters for component 'channel_1_filter' [70]. */
MCNUM mccchannel_1_filter_xmin;
MCNUM mccchannel_1_filter_xmax;
MCNUM mccchannel_1_filter_ymin;
MCNUM mccchannel_1_filter_ymax;
MCNUM mccchannel_1_filter_radius;
MCNUM mccchannel_1_filter_xwidth;
MCNUM mccchannel_1_filter_yheight;

/* Setting parameters for component 'channel_2_filter' [71]. */
MCNUM mccchannel_2_filter_xmin;
MCNUM mccchannel_2_filter_xmax;
MCNUM mccchannel_2_filter_ymin;
MCNUM mccchannel_2_filter_ymax;
MCNUM mccchannel_2_filter_radius;
MCNUM mccchannel_2_filter_xwidth;
MCNUM mccchannel_2_filter_yheight;

/* Setting parameters for component 'channel_3_filter' [72]. */
MCNUM mccchannel_3_filter_xmin;
MCNUM mccchannel_3_filter_xmax;
MCNUM mccchannel_3_filter_ymin;
MCNUM mccchannel_3_filter_ymax;
MCNUM mccchannel_3_filter_radius;
MCNUM mccchannel_3_filter_xwidth;
MCNUM mccchannel_3_filter_yheight;

/* Setting parameters for component 'channel_4_filter' [73]. */
MCNUM mccchannel_4_filter_xmin;
MCNUM mccchannel_4_filter_xmax;
MCNUM mccchannel_4_filter_ymin;
MCNUM mccchannel_4_filter_ymax;
MCNUM mccchannel_4_filter_radius;
MCNUM mccchannel_4_filter_xwidth;
MCNUM mccchannel_4_filter_yheight;

/* Setting parameters for component 'channel_5_filter' [74]. */
MCNUM mccchannel_5_filter_xmin;
MCNUM mccchannel_5_filter_xmax;
MCNUM mccchannel_5_filter_ymin;
MCNUM mccchannel_5_filter_ymax;
MCNUM mccchannel_5_filter_radius;
MCNUM mccchannel_5_filter_xwidth;
MCNUM mccchannel_5_filter_yheight;

/* Setting parameters for component 'channel_6_filter' [75]. */
MCNUM mccchannel_6_filter_xmin;
MCNUM mccchannel_6_filter_xmax;
MCNUM mccchannel_6_filter_ymin;
MCNUM mccchannel_6_filter_ymax;
MCNUM mccchannel_6_filter_radius;
MCNUM mccchannel_6_filter_xwidth;
MCNUM mccchannel_6_filter_yheight;

/* Setting parameters for component 'channel_7_filter' [76]. */
MCNUM mccchannel_7_filter_xmin;
MCNUM mccchannel_7_filter_xmax;
MCNUM mccchannel_7_filter_ymin;
MCNUM mccchannel_7_filter_ymax;
MCNUM mccchannel_7_filter_radius;
MCNUM mccchannel_7_filter_xwidth;
MCNUM mccchannel_7_filter_yheight;

/* Setting parameters for component 'channel_8_filter' [77]. */
MCNUM mccchannel_8_filter_xmin;
MCNUM mccchannel_8_filter_xmax;
MCNUM mccchannel_8_filter_ymin;
MCNUM mccchannel_8_filter_ymax;
MCNUM mccchannel_8_filter_radius;
MCNUM mccchannel_8_filter_xwidth;
MCNUM mccchannel_8_filter_yheight;

/* Setting parameters for component 'channel_9_filter' [78]. */
MCNUM mccchannel_9_filter_xmin;
MCNUM mccchannel_9_filter_xmax;
MCNUM mccchannel_9_filter_ymin;
MCNUM mccchannel_9_filter_ymax;
MCNUM mccchannel_9_filter_radius;
MCNUM mccchannel_9_filter_xwidth;
MCNUM mccchannel_9_filter_yheight;

/* Setting parameters for component 'channel_10_filter' [79]. */
MCNUM mccchannel_10_filter_xmin;
MCNUM mccchannel_10_filter_xmax;
MCNUM mccchannel_10_filter_ymin;
MCNUM mccchannel_10_filter_ymax;
MCNUM mccchannel_10_filter_radius;
MCNUM mccchannel_10_filter_xwidth;
MCNUM mccchannel_10_filter_yheight;

/* Setting parameters for component 'channel_11_filter' [80]. */
MCNUM mccchannel_11_filter_xmin;
MCNUM mccchannel_11_filter_xmax;
MCNUM mccchannel_11_filter_ymin;
MCNUM mccchannel_11_filter_ymax;
MCNUM mccchannel_11_filter_radius;
MCNUM mccchannel_11_filter_xwidth;
MCNUM mccchannel_11_filter_yheight;

/* Setting parameters for component 'channel_12_filter' [81]. */
MCNUM mccchannel_12_filter_xmin;
MCNUM mccchannel_12_filter_xmax;
MCNUM mccchannel_12_filter_ymin;
MCNUM mccchannel_12_filter_ymax;
MCNUM mccchannel_12_filter_radius;
MCNUM mccchannel_12_filter_xwidth;
MCNUM mccchannel_12_filter_yheight;

/* Setting parameters for component 'channel_13_filter' [82]. */
MCNUM mccchannel_13_filter_xmin;
MCNUM mccchannel_13_filter_xmax;
MCNUM mccchannel_13_filter_ymin;
MCNUM mccchannel_13_filter_ymax;
MCNUM mccchannel_13_filter_radius;
MCNUM mccchannel_13_filter_xwidth;
MCNUM mccchannel_13_filter_yheight;

/* Setting parameters for component 'channel_14_filter' [83]. */
MCNUM mccchannel_14_filter_xmin;
MCNUM mccchannel_14_filter_xmax;
MCNUM mccchannel_14_filter_ymin;
MCNUM mccchannel_14_filter_ymax;
MCNUM mccchannel_14_filter_radius;
MCNUM mccchannel_14_filter_xwidth;
MCNUM mccchannel_14_filter_yheight;

/* Setting parameters for component 'channel_15_filter' [84]. */
MCNUM mccchannel_15_filter_xmin;
MCNUM mccchannel_15_filter_xmax;
MCNUM mccchannel_15_filter_ymin;
MCNUM mccchannel_15_filter_ymax;
MCNUM mccchannel_15_filter_radius;
MCNUM mccchannel_15_filter_xwidth;
MCNUM mccchannel_15_filter_yheight;

/* Setting parameters for component 'channel_16_filter' [85]. */
MCNUM mccchannel_16_filter_xmin;
MCNUM mccchannel_16_filter_xmax;
MCNUM mccchannel_16_filter_ymin;
MCNUM mccchannel_16_filter_ymax;
MCNUM mccchannel_16_filter_radius;
MCNUM mccchannel_16_filter_xwidth;
MCNUM mccchannel_16_filter_yheight;

/* Setting parameters for component 'channel_17_filter' [86]. */
MCNUM mccchannel_17_filter_xmin;
MCNUM mccchannel_17_filter_xmax;
MCNUM mccchannel_17_filter_ymin;
MCNUM mccchannel_17_filter_ymax;
MCNUM mccchannel_17_filter_radius;
MCNUM mccchannel_17_filter_xwidth;
MCNUM mccchannel_17_filter_yheight;

/* Setting parameters for component 'channel_18_filter' [87]. */
MCNUM mccchannel_18_filter_xmin;
MCNUM mccchannel_18_filter_xmax;
MCNUM mccchannel_18_filter_ymin;
MCNUM mccchannel_18_filter_ymax;
MCNUM mccchannel_18_filter_radius;
MCNUM mccchannel_18_filter_xwidth;
MCNUM mccchannel_18_filter_yheight;

/* Setting parameters for component 'channel_19_filter' [88]. */
MCNUM mccchannel_19_filter_xmin;
MCNUM mccchannel_19_filter_xmax;
MCNUM mccchannel_19_filter_ymin;
MCNUM mccchannel_19_filter_ymax;
MCNUM mccchannel_19_filter_radius;
MCNUM mccchannel_19_filter_xwidth;
MCNUM mccchannel_19_filter_yheight;

/* Setting parameters for component 'channel_0_colimator' [90]. */
MCNUM mccchannel_0_colimator_xmin;
MCNUM mccchannel_0_colimator_xmax;
MCNUM mccchannel_0_colimator_ymin;
MCNUM mccchannel_0_colimator_ymax;
MCNUM mccchannel_0_colimator_xwidth;
MCNUM mccchannel_0_colimator_yheight;
MCNUM mccchannel_0_colimator_length;
MCNUM mccchannel_0_colimator_divergence;
MCNUM mccchannel_0_colimator_transmission;
MCNUM mccchannel_0_colimator_divergenceV;

/* Setting parameters for component 'channel_1_colimator' [91]. */
MCNUM mccchannel_1_colimator_xmin;
MCNUM mccchannel_1_colimator_xmax;
MCNUM mccchannel_1_colimator_ymin;
MCNUM mccchannel_1_colimator_ymax;
MCNUM mccchannel_1_colimator_xwidth;
MCNUM mccchannel_1_colimator_yheight;
MCNUM mccchannel_1_colimator_length;
MCNUM mccchannel_1_colimator_divergence;
MCNUM mccchannel_1_colimator_transmission;
MCNUM mccchannel_1_colimator_divergenceV;

/* Setting parameters for component 'channel_2_colimator' [92]. */
MCNUM mccchannel_2_colimator_xmin;
MCNUM mccchannel_2_colimator_xmax;
MCNUM mccchannel_2_colimator_ymin;
MCNUM mccchannel_2_colimator_ymax;
MCNUM mccchannel_2_colimator_xwidth;
MCNUM mccchannel_2_colimator_yheight;
MCNUM mccchannel_2_colimator_length;
MCNUM mccchannel_2_colimator_divergence;
MCNUM mccchannel_2_colimator_transmission;
MCNUM mccchannel_2_colimator_divergenceV;

/* Setting parameters for component 'channel_3_colimator' [93]. */
MCNUM mccchannel_3_colimator_xmin;
MCNUM mccchannel_3_colimator_xmax;
MCNUM mccchannel_3_colimator_ymin;
MCNUM mccchannel_3_colimator_ymax;
MCNUM mccchannel_3_colimator_xwidth;
MCNUM mccchannel_3_colimator_yheight;
MCNUM mccchannel_3_colimator_length;
MCNUM mccchannel_3_colimator_divergence;
MCNUM mccchannel_3_colimator_transmission;
MCNUM mccchannel_3_colimator_divergenceV;

/* Setting parameters for component 'channel_4_colimator' [94]. */
MCNUM mccchannel_4_colimator_xmin;
MCNUM mccchannel_4_colimator_xmax;
MCNUM mccchannel_4_colimator_ymin;
MCNUM mccchannel_4_colimator_ymax;
MCNUM mccchannel_4_colimator_xwidth;
MCNUM mccchannel_4_colimator_yheight;
MCNUM mccchannel_4_colimator_length;
MCNUM mccchannel_4_colimator_divergence;
MCNUM mccchannel_4_colimator_transmission;
MCNUM mccchannel_4_colimator_divergenceV;

/* Setting parameters for component 'channel_5_colimator' [95]. */
MCNUM mccchannel_5_colimator_xmin;
MCNUM mccchannel_5_colimator_xmax;
MCNUM mccchannel_5_colimator_ymin;
MCNUM mccchannel_5_colimator_ymax;
MCNUM mccchannel_5_colimator_xwidth;
MCNUM mccchannel_5_colimator_yheight;
MCNUM mccchannel_5_colimator_length;
MCNUM mccchannel_5_colimator_divergence;
MCNUM mccchannel_5_colimator_transmission;
MCNUM mccchannel_5_colimator_divergenceV;

/* Setting parameters for component 'channel_6_colimator' [96]. */
MCNUM mccchannel_6_colimator_xmin;
MCNUM mccchannel_6_colimator_xmax;
MCNUM mccchannel_6_colimator_ymin;
MCNUM mccchannel_6_colimator_ymax;
MCNUM mccchannel_6_colimator_xwidth;
MCNUM mccchannel_6_colimator_yheight;
MCNUM mccchannel_6_colimator_length;
MCNUM mccchannel_6_colimator_divergence;
MCNUM mccchannel_6_colimator_transmission;
MCNUM mccchannel_6_colimator_divergenceV;

/* Setting parameters for component 'channel_7_colimator' [97]. */
MCNUM mccchannel_7_colimator_xmin;
MCNUM mccchannel_7_colimator_xmax;
MCNUM mccchannel_7_colimator_ymin;
MCNUM mccchannel_7_colimator_ymax;
MCNUM mccchannel_7_colimator_xwidth;
MCNUM mccchannel_7_colimator_yheight;
MCNUM mccchannel_7_colimator_length;
MCNUM mccchannel_7_colimator_divergence;
MCNUM mccchannel_7_colimator_transmission;
MCNUM mccchannel_7_colimator_divergenceV;

/* Setting parameters for component 'channel_8_colimator' [98]. */
MCNUM mccchannel_8_colimator_xmin;
MCNUM mccchannel_8_colimator_xmax;
MCNUM mccchannel_8_colimator_ymin;
MCNUM mccchannel_8_colimator_ymax;
MCNUM mccchannel_8_colimator_xwidth;
MCNUM mccchannel_8_colimator_yheight;
MCNUM mccchannel_8_colimator_length;
MCNUM mccchannel_8_colimator_divergence;
MCNUM mccchannel_8_colimator_transmission;
MCNUM mccchannel_8_colimator_divergenceV;

/* Setting parameters for component 'channel_9_colimator' [99]. */
MCNUM mccchannel_9_colimator_xmin;
MCNUM mccchannel_9_colimator_xmax;
MCNUM mccchannel_9_colimator_ymin;
MCNUM mccchannel_9_colimator_ymax;
MCNUM mccchannel_9_colimator_xwidth;
MCNUM mccchannel_9_colimator_yheight;
MCNUM mccchannel_9_colimator_length;
MCNUM mccchannel_9_colimator_divergence;
MCNUM mccchannel_9_colimator_transmission;
MCNUM mccchannel_9_colimator_divergenceV;

/* Setting parameters for component 'channel_10_colimator' [100]. */
MCNUM mccchannel_10_colimator_xmin;
MCNUM mccchannel_10_colimator_xmax;
MCNUM mccchannel_10_colimator_ymin;
MCNUM mccchannel_10_colimator_ymax;
MCNUM mccchannel_10_colimator_xwidth;
MCNUM mccchannel_10_colimator_yheight;
MCNUM mccchannel_10_colimator_length;
MCNUM mccchannel_10_colimator_divergence;
MCNUM mccchannel_10_colimator_transmission;
MCNUM mccchannel_10_colimator_divergenceV;

/* Setting parameters for component 'channel_11_colimator' [101]. */
MCNUM mccchannel_11_colimator_xmin;
MCNUM mccchannel_11_colimator_xmax;
MCNUM mccchannel_11_colimator_ymin;
MCNUM mccchannel_11_colimator_ymax;
MCNUM mccchannel_11_colimator_xwidth;
MCNUM mccchannel_11_colimator_yheight;
MCNUM mccchannel_11_colimator_length;
MCNUM mccchannel_11_colimator_divergence;
MCNUM mccchannel_11_colimator_transmission;
MCNUM mccchannel_11_colimator_divergenceV;

/* Setting parameters for component 'channel_12_colimator' [102]. */
MCNUM mccchannel_12_colimator_xmin;
MCNUM mccchannel_12_colimator_xmax;
MCNUM mccchannel_12_colimator_ymin;
MCNUM mccchannel_12_colimator_ymax;
MCNUM mccchannel_12_colimator_xwidth;
MCNUM mccchannel_12_colimator_yheight;
MCNUM mccchannel_12_colimator_length;
MCNUM mccchannel_12_colimator_divergence;
MCNUM mccchannel_12_colimator_transmission;
MCNUM mccchannel_12_colimator_divergenceV;

/* Setting parameters for component 'channel_13_colimator' [103]. */
MCNUM mccchannel_13_colimator_xmin;
MCNUM mccchannel_13_colimator_xmax;
MCNUM mccchannel_13_colimator_ymin;
MCNUM mccchannel_13_colimator_ymax;
MCNUM mccchannel_13_colimator_xwidth;
MCNUM mccchannel_13_colimator_yheight;
MCNUM mccchannel_13_colimator_length;
MCNUM mccchannel_13_colimator_divergence;
MCNUM mccchannel_13_colimator_transmission;
MCNUM mccchannel_13_colimator_divergenceV;

/* Setting parameters for component 'channel_14_colimator' [104]. */
MCNUM mccchannel_14_colimator_xmin;
MCNUM mccchannel_14_colimator_xmax;
MCNUM mccchannel_14_colimator_ymin;
MCNUM mccchannel_14_colimator_ymax;
MCNUM mccchannel_14_colimator_xwidth;
MCNUM mccchannel_14_colimator_yheight;
MCNUM mccchannel_14_colimator_length;
MCNUM mccchannel_14_colimator_divergence;
MCNUM mccchannel_14_colimator_transmission;
MCNUM mccchannel_14_colimator_divergenceV;

/* Setting parameters for component 'channel_15_colimator' [105]. */
MCNUM mccchannel_15_colimator_xmin;
MCNUM mccchannel_15_colimator_xmax;
MCNUM mccchannel_15_colimator_ymin;
MCNUM mccchannel_15_colimator_ymax;
MCNUM mccchannel_15_colimator_xwidth;
MCNUM mccchannel_15_colimator_yheight;
MCNUM mccchannel_15_colimator_length;
MCNUM mccchannel_15_colimator_divergence;
MCNUM mccchannel_15_colimator_transmission;
MCNUM mccchannel_15_colimator_divergenceV;

/* Setting parameters for component 'channel_16_colimator' [106]. */
MCNUM mccchannel_16_colimator_xmin;
MCNUM mccchannel_16_colimator_xmax;
MCNUM mccchannel_16_colimator_ymin;
MCNUM mccchannel_16_colimator_ymax;
MCNUM mccchannel_16_colimator_xwidth;
MCNUM mccchannel_16_colimator_yheight;
MCNUM mccchannel_16_colimator_length;
MCNUM mccchannel_16_colimator_divergence;
MCNUM mccchannel_16_colimator_transmission;
MCNUM mccchannel_16_colimator_divergenceV;

/* Setting parameters for component 'channel_17_colimator' [107]. */
MCNUM mccchannel_17_colimator_xmin;
MCNUM mccchannel_17_colimator_xmax;
MCNUM mccchannel_17_colimator_ymin;
MCNUM mccchannel_17_colimator_ymax;
MCNUM mccchannel_17_colimator_xwidth;
MCNUM mccchannel_17_colimator_yheight;
MCNUM mccchannel_17_colimator_length;
MCNUM mccchannel_17_colimator_divergence;
MCNUM mccchannel_17_colimator_transmission;
MCNUM mccchannel_17_colimator_divergenceV;

/* Setting parameters for component 'channel_18_colimator' [108]. */
MCNUM mccchannel_18_colimator_xmin;
MCNUM mccchannel_18_colimator_xmax;
MCNUM mccchannel_18_colimator_ymin;
MCNUM mccchannel_18_colimator_ymax;
MCNUM mccchannel_18_colimator_xwidth;
MCNUM mccchannel_18_colimator_yheight;
MCNUM mccchannel_18_colimator_length;
MCNUM mccchannel_18_colimator_divergence;
MCNUM mccchannel_18_colimator_transmission;
MCNUM mccchannel_18_colimator_divergenceV;

/* Setting parameters for component 'channel_19_colimator' [109]. */
MCNUM mccchannel_19_colimator_xmin;
MCNUM mccchannel_19_colimator_xmax;
MCNUM mccchannel_19_colimator_ymin;
MCNUM mccchannel_19_colimator_ymax;
MCNUM mccchannel_19_colimator_xwidth;
MCNUM mccchannel_19_colimator_yheight;
MCNUM mccchannel_19_colimator_length;
MCNUM mccchannel_19_colimator_divergence;
MCNUM mccchannel_19_colimator_transmission;
MCNUM mccchannel_19_colimator_divergenceV;

/* Setting parameters for component 'boron_plastic_incoherent' [110]. */
MCNUM mccboron_plastic_incoherent_sigma;
MCNUM mccboron_plastic_incoherent_f_QE;
MCNUM mccboron_plastic_incoherent_gamma;
MCNUM mccboron_plastic_incoherent_packing_factor;
MCNUM mccboron_plastic_incoherent_unit_cell_volume;
MCNUM mccboron_plastic_incoherent_interact_fraction;

/* Setting parameters for component 'boron_plastic' [111]. */
char mccboron_plastic_process_string[16384];
MCNUM mccboron_plastic_my_absorption;
MCNUM mccboron_plastic_absorber;

/* Setting parameters for component 'boron_plastic_enriched_incoherent' [112]. */
MCNUM mccboron_plastic_enriched_incoherent_sigma;
MCNUM mccboron_plastic_enriched_incoherent_f_QE;
MCNUM mccboron_plastic_enriched_incoherent_gamma;
MCNUM mccboron_plastic_enriched_incoherent_packing_factor;
MCNUM mccboron_plastic_enriched_incoherent_unit_cell_volume;
MCNUM mccboron_plastic_enriched_incoherent_interact_fraction;

/* Setting parameters for component 'boron_plastic_enriched' [113]. */
char mccboron_plastic_enriched_process_string[16384];
MCNUM mccboron_plastic_enriched_my_absorption;
MCNUM mccboron_plastic_enriched_absorber;

/* Setting parameters for component 'Collimator_gad' [114]. */
char mccCollimator_gad_process_string[16384];
MCNUM mccCollimator_gad_my_absorption;
MCNUM mccCollimator_gad_absorber;

/* Setting parameters for component 'Incoherent_PG_analyzer' [115]. */
MCNUM mccIncoherent_PG_analyzer_sigma;
MCNUM mccIncoherent_PG_analyzer_f_QE;
MCNUM mccIncoherent_PG_analyzer_gamma;
MCNUM mccIncoherent_PG_analyzer_packing_factor;
MCNUM mccIncoherent_PG_analyzer_unit_cell_volume;
MCNUM mccIncoherent_PG_analyzer_interact_fraction;

/* Definition parameters for component 'Single_crystal_PG_analyzer' [116]. */
#define mccSingle_crystal_PG_analyzer_mosaic_AB Mosaic_AB_Undefined
/* Setting parameters for component 'Single_crystal_PG_analyzer' [116]. */
char mccSingle_crystal_PG_analyzer_reflections[16384];
MCNUM mccSingle_crystal_PG_analyzer_delta_d_d;
MCNUM mccSingle_crystal_PG_analyzer_mosaic;
MCNUM mccSingle_crystal_PG_analyzer_mosaic_a;
MCNUM mccSingle_crystal_PG_analyzer_mosaic_b;
MCNUM mccSingle_crystal_PG_analyzer_mosaic_c;
MCNUM mccSingle_crystal_PG_analyzer_recip_cell;
MCNUM mccSingle_crystal_PG_analyzer_barns;
MCNUM mccSingle_crystal_PG_analyzer_ax;
MCNUM mccSingle_crystal_PG_analyzer_ay;
MCNUM mccSingle_crystal_PG_analyzer_az;
MCNUM mccSingle_crystal_PG_analyzer_bx;
MCNUM mccSingle_crystal_PG_analyzer_by;
MCNUM mccSingle_crystal_PG_analyzer_bz;
MCNUM mccSingle_crystal_PG_analyzer_cx;
MCNUM mccSingle_crystal_PG_analyzer_cy;
MCNUM mccSingle_crystal_PG_analyzer_cz;
MCNUM mccSingle_crystal_PG_analyzer_aa;
MCNUM mccSingle_crystal_PG_analyzer_bb;
MCNUM mccSingle_crystal_PG_analyzer_cc;
MCNUM mccSingle_crystal_PG_analyzer_order;
MCNUM mccSingle_crystal_PG_analyzer_RX;
MCNUM mccSingle_crystal_PG_analyzer_RY;
MCNUM mccSingle_crystal_PG_analyzer_RZ;
MCNUM mccSingle_crystal_PG_analyzer_powder;
MCNUM mccSingle_crystal_PG_analyzer_PG;
MCNUM mccSingle_crystal_PG_analyzer_interact_fraction;
MCNUM mccSingle_crystal_PG_analyzer_packing_factor;

/* Setting parameters for component 'PG_analyzer' [117]. */
char mccPG_analyzer_process_string[16384];
MCNUM mccPG_analyzer_my_absorption;
MCNUM mccPG_analyzer_absorber;

/* Setting parameters for component 'kidney_hull' [118]. */
char mcckidney_hull_material_string[16384];
MCNUM mcckidney_hull_priority;
MCNUM mcckidney_hull_radius;
MCNUM mcckidney_hull_yheight;
MCNUM mcckidney_hull_visualize;
int mcckidney_hull_target_index;
MCNUM mcckidney_hull_target_x;
MCNUM mcckidney_hull_target_y;
MCNUM mcckidney_hull_target_z;
MCNUM mcckidney_hull_focus_aw;
MCNUM mcckidney_hull_focus_ah;
MCNUM mcckidney_hull_focus_xw;
MCNUM mcckidney_hull_focus_xh;
MCNUM mcckidney_hull_focus_r;
MCNUM mcckidney_hull_p_interact;
char mcckidney_hull_mask_string[16384];
char mcckidney_hull_mask_setting[16384];
MCNUM mcckidney_hull_number_of_activations;

/* Setting parameters for component 'kidney_hull_cut' [119]. */
char mcckidney_hull_cut_material_string[16384];
MCNUM mcckidney_hull_cut_priority;
MCNUM mcckidney_hull_cut_radius;
MCNUM mcckidney_hull_cut_yheight;
MCNUM mcckidney_hull_cut_visualize;
int mcckidney_hull_cut_target_index;
MCNUM mcckidney_hull_cut_target_x;
MCNUM mcckidney_hull_cut_target_y;
MCNUM mcckidney_hull_cut_target_z;
MCNUM mcckidney_hull_cut_focus_aw;
MCNUM mcckidney_hull_cut_focus_ah;
MCNUM mcckidney_hull_cut_focus_xw;
MCNUM mcckidney_hull_cut_focus_xh;
MCNUM mcckidney_hull_cut_focus_r;
MCNUM mcckidney_hull_cut_p_interact;
char mcckidney_hull_cut_mask_string[16384];
char mcckidney_hull_cut_mask_setting[16384];
MCNUM mcckidney_hull_cut_number_of_activations;

/* Setting parameters for component 'kidney_hull_box_cut1' [121]. */
char mcckidney_hull_box_cut1_material_string[16384];
MCNUM mcckidney_hull_box_cut1_priority;
MCNUM mcckidney_hull_box_cut1_xwidth;
MCNUM mcckidney_hull_box_cut1_yheight;
MCNUM mcckidney_hull_box_cut1_zdepth;
MCNUM mcckidney_hull_box_cut1_xwidth2;
MCNUM mcckidney_hull_box_cut1_yheight2;
MCNUM mcckidney_hull_box_cut1_visualize;
int mcckidney_hull_box_cut1_target_index;
MCNUM mcckidney_hull_box_cut1_target_x;
MCNUM mcckidney_hull_box_cut1_target_y;
MCNUM mcckidney_hull_box_cut1_target_z;
MCNUM mcckidney_hull_box_cut1_focus_aw;
MCNUM mcckidney_hull_box_cut1_focus_ah;
MCNUM mcckidney_hull_box_cut1_focus_xw;
MCNUM mcckidney_hull_box_cut1_focus_xh;
MCNUM mcckidney_hull_box_cut1_focus_r;
MCNUM mcckidney_hull_box_cut1_p_interact;
char mcckidney_hull_box_cut1_mask_string[16384];
char mcckidney_hull_box_cut1_mask_setting[16384];
MCNUM mcckidney_hull_box_cut1_number_of_activations;

/* Setting parameters for component 'kidney_hull_box_cut2' [123]. */
char mcckidney_hull_box_cut2_material_string[16384];
MCNUM mcckidney_hull_box_cut2_priority;
MCNUM mcckidney_hull_box_cut2_xwidth;
MCNUM mcckidney_hull_box_cut2_yheight;
MCNUM mcckidney_hull_box_cut2_zdepth;
MCNUM mcckidney_hull_box_cut2_xwidth2;
MCNUM mcckidney_hull_box_cut2_yheight2;
MCNUM mcckidney_hull_box_cut2_visualize;
int mcckidney_hull_box_cut2_target_index;
MCNUM mcckidney_hull_box_cut2_target_x;
MCNUM mcckidney_hull_box_cut2_target_y;
MCNUM mcckidney_hull_box_cut2_target_z;
MCNUM mcckidney_hull_box_cut2_focus_aw;
MCNUM mcckidney_hull_box_cut2_focus_ah;
MCNUM mcckidney_hull_box_cut2_focus_xw;
MCNUM mcckidney_hull_box_cut2_focus_xh;
MCNUM mcckidney_hull_box_cut2_focus_r;
MCNUM mcckidney_hull_box_cut2_p_interact;
char mcckidney_hull_box_cut2_mask_string[16384];
char mcckidney_hull_box_cut2_mask_setting[16384];
MCNUM mcckidney_hull_box_cut2_number_of_activations;

/* Setting parameters for component 'channel_0_cave1_box1' [124]. */
char mccchannel_0_cave1_box1_material_string[16384];
MCNUM mccchannel_0_cave1_box1_priority;
MCNUM mccchannel_0_cave1_box1_xwidth;
MCNUM mccchannel_0_cave1_box1_yheight;
MCNUM mccchannel_0_cave1_box1_zdepth;
MCNUM mccchannel_0_cave1_box1_xwidth2;
MCNUM mccchannel_0_cave1_box1_yheight2;
MCNUM mccchannel_0_cave1_box1_visualize;
int mccchannel_0_cave1_box1_target_index;
MCNUM mccchannel_0_cave1_box1_target_x;
MCNUM mccchannel_0_cave1_box1_target_y;
MCNUM mccchannel_0_cave1_box1_target_z;
MCNUM mccchannel_0_cave1_box1_focus_aw;
MCNUM mccchannel_0_cave1_box1_focus_ah;
MCNUM mccchannel_0_cave1_box1_focus_xw;
MCNUM mccchannel_0_cave1_box1_focus_xh;
MCNUM mccchannel_0_cave1_box1_focus_r;
MCNUM mccchannel_0_cave1_box1_p_interact;
char mccchannel_0_cave1_box1_mask_string[16384];
char mccchannel_0_cave1_box1_mask_setting[16384];
MCNUM mccchannel_0_cave1_box1_number_of_activations;

/* Setting parameters for component 'channel_0_cave1_box2' [125]. */
char mccchannel_0_cave1_box2_material_string[16384];
MCNUM mccchannel_0_cave1_box2_priority;
MCNUM mccchannel_0_cave1_box2_xwidth;
MCNUM mccchannel_0_cave1_box2_yheight;
MCNUM mccchannel_0_cave1_box2_zdepth;
MCNUM mccchannel_0_cave1_box2_xwidth2;
MCNUM mccchannel_0_cave1_box2_yheight2;
MCNUM mccchannel_0_cave1_box2_visualize;
int mccchannel_0_cave1_box2_target_index;
MCNUM mccchannel_0_cave1_box2_target_x;
MCNUM mccchannel_0_cave1_box2_target_y;
MCNUM mccchannel_0_cave1_box2_target_z;
MCNUM mccchannel_0_cave1_box2_focus_aw;
MCNUM mccchannel_0_cave1_box2_focus_ah;
MCNUM mccchannel_0_cave1_box2_focus_xw;
MCNUM mccchannel_0_cave1_box2_focus_xh;
MCNUM mccchannel_0_cave1_box2_focus_r;
MCNUM mccchannel_0_cave1_box2_p_interact;
char mccchannel_0_cave1_box2_mask_string[16384];
char mccchannel_0_cave1_box2_mask_setting[16384];
MCNUM mccchannel_0_cave1_box2_number_of_activations;

/* Setting parameters for component 'channel_0_cave1_box3' [126]. */
char mccchannel_0_cave1_box3_material_string[16384];
MCNUM mccchannel_0_cave1_box3_priority;
MCNUM mccchannel_0_cave1_box3_xwidth;
MCNUM mccchannel_0_cave1_box3_yheight;
MCNUM mccchannel_0_cave1_box3_zdepth;
MCNUM mccchannel_0_cave1_box3_xwidth2;
MCNUM mccchannel_0_cave1_box3_yheight2;
MCNUM mccchannel_0_cave1_box3_visualize;
int mccchannel_0_cave1_box3_target_index;
MCNUM mccchannel_0_cave1_box3_target_x;
MCNUM mccchannel_0_cave1_box3_target_y;
MCNUM mccchannel_0_cave1_box3_target_z;
MCNUM mccchannel_0_cave1_box3_focus_aw;
MCNUM mccchannel_0_cave1_box3_focus_ah;
MCNUM mccchannel_0_cave1_box3_focus_xw;
MCNUM mccchannel_0_cave1_box3_focus_xh;
MCNUM mccchannel_0_cave1_box3_focus_r;
MCNUM mccchannel_0_cave1_box3_p_interact;
char mccchannel_0_cave1_box3_mask_string[16384];
char mccchannel_0_cave1_box3_mask_setting[16384];
MCNUM mccchannel_0_cave1_box3_number_of_activations;

/* Setting parameters for component 'channel_0_cave1_cyl1' [127]. */
char mccchannel_0_cave1_cyl1_material_string[16384];
MCNUM mccchannel_0_cave1_cyl1_priority;
MCNUM mccchannel_0_cave1_cyl1_radius;
MCNUM mccchannel_0_cave1_cyl1_yheight;
MCNUM mccchannel_0_cave1_cyl1_visualize;
int mccchannel_0_cave1_cyl1_target_index;
MCNUM mccchannel_0_cave1_cyl1_target_x;
MCNUM mccchannel_0_cave1_cyl1_target_y;
MCNUM mccchannel_0_cave1_cyl1_target_z;
MCNUM mccchannel_0_cave1_cyl1_focus_aw;
MCNUM mccchannel_0_cave1_cyl1_focus_ah;
MCNUM mccchannel_0_cave1_cyl1_focus_xw;
MCNUM mccchannel_0_cave1_cyl1_focus_xh;
MCNUM mccchannel_0_cave1_cyl1_focus_r;
MCNUM mccchannel_0_cave1_cyl1_p_interact;
char mccchannel_0_cave1_cyl1_mask_string[16384];
char mccchannel_0_cave1_cyl1_mask_setting[16384];
MCNUM mccchannel_0_cave1_cyl1_number_of_activations;

/* Setting parameters for component 'channel_0_analyzer_1_array_crystal_array_0' [130]. */
char mccchannel_0_analyzer_1_array_crystal_array_0_material_string[16384];
MCNUM mccchannel_0_analyzer_1_array_crystal_array_0_priority;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_0_xwidth;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_0_yheight;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_0_zdepth;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_0_xwidth2;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_0_yheight2;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_0_visualize;
int mccchannel_0_analyzer_1_array_crystal_array_0_target_index;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_0_target_x;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_0_target_y;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_0_target_z;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_0_focus_aw;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_0_focus_ah;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_0_focus_xw;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_0_focus_xh;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_0_focus_r;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_0_p_interact;
char mccchannel_0_analyzer_1_array_crystal_array_0_mask_string[16384];
char mccchannel_0_analyzer_1_array_crystal_array_0_mask_setting[16384];
MCNUM mccchannel_0_analyzer_1_array_crystal_array_0_number_of_activations;

/* Setting parameters for component 'channel_0_analyzer_1_array_crystal_array_1' [131]. */
char mccchannel_0_analyzer_1_array_crystal_array_1_material_string[16384];
MCNUM mccchannel_0_analyzer_1_array_crystal_array_1_priority;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_1_xwidth;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_1_yheight;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_1_zdepth;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_1_xwidth2;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_1_yheight2;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_1_visualize;
int mccchannel_0_analyzer_1_array_crystal_array_1_target_index;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_1_target_x;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_1_target_y;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_1_target_z;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_1_focus_aw;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_1_focus_ah;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_1_focus_xw;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_1_focus_xh;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_1_focus_r;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_1_p_interact;
char mccchannel_0_analyzer_1_array_crystal_array_1_mask_string[16384];
char mccchannel_0_analyzer_1_array_crystal_array_1_mask_setting[16384];
MCNUM mccchannel_0_analyzer_1_array_crystal_array_1_number_of_activations;

/* Setting parameters for component 'channel_0_analyzer_1_array_crystal_array_2' [132]. */
char mccchannel_0_analyzer_1_array_crystal_array_2_material_string[16384];
MCNUM mccchannel_0_analyzer_1_array_crystal_array_2_priority;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_2_xwidth;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_2_yheight;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_2_zdepth;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_2_xwidth2;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_2_yheight2;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_2_visualize;
int mccchannel_0_analyzer_1_array_crystal_array_2_target_index;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_2_target_x;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_2_target_y;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_2_target_z;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_2_focus_aw;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_2_focus_ah;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_2_focus_xw;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_2_focus_xh;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_2_focus_r;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_2_p_interact;
char mccchannel_0_analyzer_1_array_crystal_array_2_mask_string[16384];
char mccchannel_0_analyzer_1_array_crystal_array_2_mask_setting[16384];
MCNUM mccchannel_0_analyzer_1_array_crystal_array_2_number_of_activations;

/* Setting parameters for component 'channel_0_analyzer_1_array_crystal_array_3' [133]. */
char mccchannel_0_analyzer_1_array_crystal_array_3_material_string[16384];
MCNUM mccchannel_0_analyzer_1_array_crystal_array_3_priority;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_3_xwidth;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_3_yheight;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_3_zdepth;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_3_xwidth2;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_3_yheight2;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_3_visualize;
int mccchannel_0_analyzer_1_array_crystal_array_3_target_index;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_3_target_x;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_3_target_y;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_3_target_z;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_3_focus_aw;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_3_focus_ah;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_3_focus_xw;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_3_focus_xh;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_3_focus_r;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_3_p_interact;
char mccchannel_0_analyzer_1_array_crystal_array_3_mask_string[16384];
char mccchannel_0_analyzer_1_array_crystal_array_3_mask_setting[16384];
MCNUM mccchannel_0_analyzer_1_array_crystal_array_3_number_of_activations;

/* Setting parameters for component 'channel_0_analyzer_1_array_crystal_array_4' [134]. */
char mccchannel_0_analyzer_1_array_crystal_array_4_material_string[16384];
MCNUM mccchannel_0_analyzer_1_array_crystal_array_4_priority;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_4_xwidth;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_4_yheight;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_4_zdepth;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_4_xwidth2;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_4_yheight2;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_4_visualize;
int mccchannel_0_analyzer_1_array_crystal_array_4_target_index;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_4_target_x;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_4_target_y;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_4_target_z;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_4_focus_aw;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_4_focus_ah;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_4_focus_xw;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_4_focus_xh;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_4_focus_r;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_4_p_interact;
char mccchannel_0_analyzer_1_array_crystal_array_4_mask_string[16384];
char mccchannel_0_analyzer_1_array_crystal_array_4_mask_setting[16384];
MCNUM mccchannel_0_analyzer_1_array_crystal_array_4_number_of_activations;

/* Setting parameters for component 'channel_0_analyzer_1_array_crystal_array_5' [135]. */
char mccchannel_0_analyzer_1_array_crystal_array_5_material_string[16384];
MCNUM mccchannel_0_analyzer_1_array_crystal_array_5_priority;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_5_xwidth;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_5_yheight;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_5_zdepth;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_5_xwidth2;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_5_yheight2;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_5_visualize;
int mccchannel_0_analyzer_1_array_crystal_array_5_target_index;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_5_target_x;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_5_target_y;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_5_target_z;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_5_focus_aw;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_5_focus_ah;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_5_focus_xw;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_5_focus_xh;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_5_focus_r;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_5_p_interact;
char mccchannel_0_analyzer_1_array_crystal_array_5_mask_string[16384];
char mccchannel_0_analyzer_1_array_crystal_array_5_mask_setting[16384];
MCNUM mccchannel_0_analyzer_1_array_crystal_array_5_number_of_activations;

/* Setting parameters for component 'channel_0_analyzer_1_array_crystal_array_6' [136]. */
char mccchannel_0_analyzer_1_array_crystal_array_6_material_string[16384];
MCNUM mccchannel_0_analyzer_1_array_crystal_array_6_priority;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_6_xwidth;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_6_yheight;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_6_zdepth;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_6_xwidth2;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_6_yheight2;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_6_visualize;
int mccchannel_0_analyzer_1_array_crystal_array_6_target_index;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_6_target_x;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_6_target_y;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_6_target_z;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_6_focus_aw;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_6_focus_ah;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_6_focus_xw;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_6_focus_xh;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_6_focus_r;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_6_p_interact;
char mccchannel_0_analyzer_1_array_crystal_array_6_mask_string[16384];
char mccchannel_0_analyzer_1_array_crystal_array_6_mask_setting[16384];
MCNUM mccchannel_0_analyzer_1_array_crystal_array_6_number_of_activations;

/* Setting parameters for component 'channel_0_analyzer_1_array_crystal_array_7' [137]. */
char mccchannel_0_analyzer_1_array_crystal_array_7_material_string[16384];
MCNUM mccchannel_0_analyzer_1_array_crystal_array_7_priority;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_7_xwidth;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_7_yheight;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_7_zdepth;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_7_xwidth2;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_7_yheight2;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_7_visualize;
int mccchannel_0_analyzer_1_array_crystal_array_7_target_index;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_7_target_x;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_7_target_y;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_7_target_z;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_7_focus_aw;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_7_focus_ah;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_7_focus_xw;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_7_focus_xh;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_7_focus_r;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_7_p_interact;
char mccchannel_0_analyzer_1_array_crystal_array_7_mask_string[16384];
char mccchannel_0_analyzer_1_array_crystal_array_7_mask_setting[16384];
MCNUM mccchannel_0_analyzer_1_array_crystal_array_7_number_of_activations;

/* Setting parameters for component 'channel_0_analyzer_1_array_crystal_array_8' [138]. */
char mccchannel_0_analyzer_1_array_crystal_array_8_material_string[16384];
MCNUM mccchannel_0_analyzer_1_array_crystal_array_8_priority;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_8_xwidth;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_8_yheight;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_8_zdepth;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_8_xwidth2;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_8_yheight2;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_8_visualize;
int mccchannel_0_analyzer_1_array_crystal_array_8_target_index;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_8_target_x;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_8_target_y;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_8_target_z;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_8_focus_aw;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_8_focus_ah;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_8_focus_xw;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_8_focus_xh;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_8_focus_r;
MCNUM mccchannel_0_analyzer_1_array_crystal_array_8_p_interact;
char mccchannel_0_analyzer_1_array_crystal_array_8_mask_string[16384];
char mccchannel_0_analyzer_1_array_crystal_array_8_mask_setting[16384];
MCNUM mccchannel_0_analyzer_1_array_crystal_array_8_number_of_activations;

/* Setting parameters for component 'channel_0_analyzer_2_array_crystal_array_0' [141]. */
char mccchannel_0_analyzer_2_array_crystal_array_0_material_string[16384];
MCNUM mccchannel_0_analyzer_2_array_crystal_array_0_priority;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_0_xwidth;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_0_yheight;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_0_zdepth;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_0_xwidth2;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_0_yheight2;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_0_visualize;
int mccchannel_0_analyzer_2_array_crystal_array_0_target_index;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_0_target_x;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_0_target_y;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_0_target_z;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_0_focus_aw;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_0_focus_ah;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_0_focus_xw;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_0_focus_xh;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_0_focus_r;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_0_p_interact;
char mccchannel_0_analyzer_2_array_crystal_array_0_mask_string[16384];
char mccchannel_0_analyzer_2_array_crystal_array_0_mask_setting[16384];
MCNUM mccchannel_0_analyzer_2_array_crystal_array_0_number_of_activations;

/* Setting parameters for component 'channel_0_analyzer_2_array_crystal_array_1' [142]. */
char mccchannel_0_analyzer_2_array_crystal_array_1_material_string[16384];
MCNUM mccchannel_0_analyzer_2_array_crystal_array_1_priority;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_1_xwidth;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_1_yheight;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_1_zdepth;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_1_xwidth2;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_1_yheight2;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_1_visualize;
int mccchannel_0_analyzer_2_array_crystal_array_1_target_index;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_1_target_x;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_1_target_y;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_1_target_z;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_1_focus_aw;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_1_focus_ah;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_1_focus_xw;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_1_focus_xh;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_1_focus_r;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_1_p_interact;
char mccchannel_0_analyzer_2_array_crystal_array_1_mask_string[16384];
char mccchannel_0_analyzer_2_array_crystal_array_1_mask_setting[16384];
MCNUM mccchannel_0_analyzer_2_array_crystal_array_1_number_of_activations;

/* Setting parameters for component 'channel_0_analyzer_2_array_crystal_array_2' [143]. */
char mccchannel_0_analyzer_2_array_crystal_array_2_material_string[16384];
MCNUM mccchannel_0_analyzer_2_array_crystal_array_2_priority;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_2_xwidth;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_2_yheight;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_2_zdepth;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_2_xwidth2;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_2_yheight2;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_2_visualize;
int mccchannel_0_analyzer_2_array_crystal_array_2_target_index;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_2_target_x;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_2_target_y;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_2_target_z;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_2_focus_aw;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_2_focus_ah;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_2_focus_xw;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_2_focus_xh;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_2_focus_r;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_2_p_interact;
char mccchannel_0_analyzer_2_array_crystal_array_2_mask_string[16384];
char mccchannel_0_analyzer_2_array_crystal_array_2_mask_setting[16384];
MCNUM mccchannel_0_analyzer_2_array_crystal_array_2_number_of_activations;

/* Setting parameters for component 'channel_0_analyzer_2_array_crystal_array_3' [144]. */
char mccchannel_0_analyzer_2_array_crystal_array_3_material_string[16384];
MCNUM mccchannel_0_analyzer_2_array_crystal_array_3_priority;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_3_xwidth;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_3_yheight;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_3_zdepth;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_3_xwidth2;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_3_yheight2;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_3_visualize;
int mccchannel_0_analyzer_2_array_crystal_array_3_target_index;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_3_target_x;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_3_target_y;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_3_target_z;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_3_focus_aw;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_3_focus_ah;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_3_focus_xw;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_3_focus_xh;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_3_focus_r;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_3_p_interact;
char mccchannel_0_analyzer_2_array_crystal_array_3_mask_string[16384];
char mccchannel_0_analyzer_2_array_crystal_array_3_mask_setting[16384];
MCNUM mccchannel_0_analyzer_2_array_crystal_array_3_number_of_activations;

/* Setting parameters for component 'channel_0_analyzer_2_array_crystal_array_4' [145]. */
char mccchannel_0_analyzer_2_array_crystal_array_4_material_string[16384];
MCNUM mccchannel_0_analyzer_2_array_crystal_array_4_priority;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_4_xwidth;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_4_yheight;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_4_zdepth;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_4_xwidth2;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_4_yheight2;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_4_visualize;
int mccchannel_0_analyzer_2_array_crystal_array_4_target_index;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_4_target_x;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_4_target_y;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_4_target_z;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_4_focus_aw;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_4_focus_ah;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_4_focus_xw;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_4_focus_xh;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_4_focus_r;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_4_p_interact;
char mccchannel_0_analyzer_2_array_crystal_array_4_mask_string[16384];
char mccchannel_0_analyzer_2_array_crystal_array_4_mask_setting[16384];
MCNUM mccchannel_0_analyzer_2_array_crystal_array_4_number_of_activations;

/* Setting parameters for component 'channel_0_analyzer_2_array_crystal_array_5' [146]. */
char mccchannel_0_analyzer_2_array_crystal_array_5_material_string[16384];
MCNUM mccchannel_0_analyzer_2_array_crystal_array_5_priority;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_5_xwidth;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_5_yheight;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_5_zdepth;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_5_xwidth2;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_5_yheight2;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_5_visualize;
int mccchannel_0_analyzer_2_array_crystal_array_5_target_index;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_5_target_x;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_5_target_y;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_5_target_z;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_5_focus_aw;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_5_focus_ah;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_5_focus_xw;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_5_focus_xh;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_5_focus_r;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_5_p_interact;
char mccchannel_0_analyzer_2_array_crystal_array_5_mask_string[16384];
char mccchannel_0_analyzer_2_array_crystal_array_5_mask_setting[16384];
MCNUM mccchannel_0_analyzer_2_array_crystal_array_5_number_of_activations;

/* Setting parameters for component 'channel_0_analyzer_2_array_crystal_array_6' [147]. */
char mccchannel_0_analyzer_2_array_crystal_array_6_material_string[16384];
MCNUM mccchannel_0_analyzer_2_array_crystal_array_6_priority;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_6_xwidth;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_6_yheight;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_6_zdepth;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_6_xwidth2;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_6_yheight2;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_6_visualize;
int mccchannel_0_analyzer_2_array_crystal_array_6_target_index;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_6_target_x;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_6_target_y;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_6_target_z;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_6_focus_aw;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_6_focus_ah;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_6_focus_xw;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_6_focus_xh;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_6_focus_r;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_6_p_interact;
char mccchannel_0_analyzer_2_array_crystal_array_6_mask_string[16384];
char mccchannel_0_analyzer_2_array_crystal_array_6_mask_setting[16384];
MCNUM mccchannel_0_analyzer_2_array_crystal_array_6_number_of_activations;

/* Setting parameters for component 'channel_0_analyzer_2_array_crystal_array_7' [148]. */
char mccchannel_0_analyzer_2_array_crystal_array_7_material_string[16384];
MCNUM mccchannel_0_analyzer_2_array_crystal_array_7_priority;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_7_xwidth;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_7_yheight;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_7_zdepth;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_7_xwidth2;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_7_yheight2;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_7_visualize;
int mccchannel_0_analyzer_2_array_crystal_array_7_target_index;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_7_target_x;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_7_target_y;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_7_target_z;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_7_focus_aw;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_7_focus_ah;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_7_focus_xw;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_7_focus_xh;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_7_focus_r;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_7_p_interact;
char mccchannel_0_analyzer_2_array_crystal_array_7_mask_string[16384];
char mccchannel_0_analyzer_2_array_crystal_array_7_mask_setting[16384];
MCNUM mccchannel_0_analyzer_2_array_crystal_array_7_number_of_activations;

/* Setting parameters for component 'channel_0_analyzer_2_array_crystal_array_8' [149]. */
char mccchannel_0_analyzer_2_array_crystal_array_8_material_string[16384];
MCNUM mccchannel_0_analyzer_2_array_crystal_array_8_priority;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_8_xwidth;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_8_yheight;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_8_zdepth;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_8_xwidth2;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_8_yheight2;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_8_visualize;
int mccchannel_0_analyzer_2_array_crystal_array_8_target_index;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_8_target_x;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_8_target_y;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_8_target_z;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_8_focus_aw;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_8_focus_ah;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_8_focus_xw;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_8_focus_xh;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_8_focus_r;
MCNUM mccchannel_0_analyzer_2_array_crystal_array_8_p_interact;
char mccchannel_0_analyzer_2_array_crystal_array_8_mask_string[16384];
char mccchannel_0_analyzer_2_array_crystal_array_8_mask_setting[16384];
MCNUM mccchannel_0_analyzer_2_array_crystal_array_8_number_of_activations;

/* Setting parameters for component 'channel_0_cave2_cyl1' [150]. */
char mccchannel_0_cave2_cyl1_material_string[16384];
MCNUM mccchannel_0_cave2_cyl1_priority;
MCNUM mccchannel_0_cave2_cyl1_radius;
MCNUM mccchannel_0_cave2_cyl1_yheight;
MCNUM mccchannel_0_cave2_cyl1_visualize;
int mccchannel_0_cave2_cyl1_target_index;
MCNUM mccchannel_0_cave2_cyl1_target_x;
MCNUM mccchannel_0_cave2_cyl1_target_y;
MCNUM mccchannel_0_cave2_cyl1_target_z;
MCNUM mccchannel_0_cave2_cyl1_focus_aw;
MCNUM mccchannel_0_cave2_cyl1_focus_ah;
MCNUM mccchannel_0_cave2_cyl1_focus_xw;
MCNUM mccchannel_0_cave2_cyl1_focus_xh;
MCNUM mccchannel_0_cave2_cyl1_focus_r;
MCNUM mccchannel_0_cave2_cyl1_p_interact;
char mccchannel_0_cave2_cyl1_mask_string[16384];
char mccchannel_0_cave2_cyl1_mask_setting[16384];
MCNUM mccchannel_0_cave2_cyl1_number_of_activations;

/* Setting parameters for component 'channel_0_cave2_box1' [151]. */
char mccchannel_0_cave2_box1_material_string[16384];
MCNUM mccchannel_0_cave2_box1_priority;
MCNUM mccchannel_0_cave2_box1_xwidth;
MCNUM mccchannel_0_cave2_box1_yheight;
MCNUM mccchannel_0_cave2_box1_zdepth;
MCNUM mccchannel_0_cave2_box1_xwidth2;
MCNUM mccchannel_0_cave2_box1_yheight2;
MCNUM mccchannel_0_cave2_box1_visualize;
int mccchannel_0_cave2_box1_target_index;
MCNUM mccchannel_0_cave2_box1_target_x;
MCNUM mccchannel_0_cave2_box1_target_y;
MCNUM mccchannel_0_cave2_box1_target_z;
MCNUM mccchannel_0_cave2_box1_focus_aw;
MCNUM mccchannel_0_cave2_box1_focus_ah;
MCNUM mccchannel_0_cave2_box1_focus_xw;
MCNUM mccchannel_0_cave2_box1_focus_xh;
MCNUM mccchannel_0_cave2_box1_focus_r;
MCNUM mccchannel_0_cave2_box1_p_interact;
char mccchannel_0_cave2_box1_mask_string[16384];
char mccchannel_0_cave2_box1_mask_setting[16384];
MCNUM mccchannel_0_cave2_box1_number_of_activations;

/* Setting parameters for component 'channel_0_cave2_box2' [152]. */
char mccchannel_0_cave2_box2_material_string[16384];
MCNUM mccchannel_0_cave2_box2_priority;
MCNUM mccchannel_0_cave2_box2_xwidth;
MCNUM mccchannel_0_cave2_box2_yheight;
MCNUM mccchannel_0_cave2_box2_zdepth;
MCNUM mccchannel_0_cave2_box2_xwidth2;
MCNUM mccchannel_0_cave2_box2_yheight2;
MCNUM mccchannel_0_cave2_box2_visualize;
int mccchannel_0_cave2_box2_target_index;
MCNUM mccchannel_0_cave2_box2_target_x;
MCNUM mccchannel_0_cave2_box2_target_y;
MCNUM mccchannel_0_cave2_box2_target_z;
MCNUM mccchannel_0_cave2_box2_focus_aw;
MCNUM mccchannel_0_cave2_box2_focus_ah;
MCNUM mccchannel_0_cave2_box2_focus_xw;
MCNUM mccchannel_0_cave2_box2_focus_xh;
MCNUM mccchannel_0_cave2_box2_focus_r;
MCNUM mccchannel_0_cave2_box2_p_interact;
char mccchannel_0_cave2_box2_mask_string[16384];
char mccchannel_0_cave2_box2_mask_setting[16384];
MCNUM mccchannel_0_cave2_box2_number_of_activations;

/* Setting parameters for component 'channel_0_cave2_box3' [153]. */
char mccchannel_0_cave2_box3_material_string[16384];
MCNUM mccchannel_0_cave2_box3_priority;
MCNUM mccchannel_0_cave2_box3_xwidth;
MCNUM mccchannel_0_cave2_box3_yheight;
MCNUM mccchannel_0_cave2_box3_zdepth;
MCNUM mccchannel_0_cave2_box3_xwidth2;
MCNUM mccchannel_0_cave2_box3_yheight2;
MCNUM mccchannel_0_cave2_box3_visualize;
int mccchannel_0_cave2_box3_target_index;
MCNUM mccchannel_0_cave2_box3_target_x;
MCNUM mccchannel_0_cave2_box3_target_y;
MCNUM mccchannel_0_cave2_box3_target_z;
MCNUM mccchannel_0_cave2_box3_focus_aw;
MCNUM mccchannel_0_cave2_box3_focus_ah;
MCNUM mccchannel_0_cave2_box3_focus_xw;
MCNUM mccchannel_0_cave2_box3_focus_xh;
MCNUM mccchannel_0_cave2_box3_focus_r;
MCNUM mccchannel_0_cave2_box3_p_interact;
char mccchannel_0_cave2_box3_mask_string[16384];
char mccchannel_0_cave2_box3_mask_setting[16384];
MCNUM mccchannel_0_cave2_box3_number_of_activations;

/* Setting parameters for component 'inter_analyzer_colimator_0_blade_0' [155]. */
char mccinter_analyzer_colimator_0_blade_0_material_string[16384];
MCNUM mccinter_analyzer_colimator_0_blade_0_priority;
MCNUM mccinter_analyzer_colimator_0_blade_0_xwidth;
MCNUM mccinter_analyzer_colimator_0_blade_0_yheight;
MCNUM mccinter_analyzer_colimator_0_blade_0_zdepth;
MCNUM mccinter_analyzer_colimator_0_blade_0_xwidth2;
MCNUM mccinter_analyzer_colimator_0_blade_0_yheight2;
MCNUM mccinter_analyzer_colimator_0_blade_0_visualize;
int mccinter_analyzer_colimator_0_blade_0_target_index;
MCNUM mccinter_analyzer_colimator_0_blade_0_target_x;
MCNUM mccinter_analyzer_colimator_0_blade_0_target_y;
MCNUM mccinter_analyzer_colimator_0_blade_0_target_z;
MCNUM mccinter_analyzer_colimator_0_blade_0_focus_aw;
MCNUM mccinter_analyzer_colimator_0_blade_0_focus_ah;
MCNUM mccinter_analyzer_colimator_0_blade_0_focus_xw;
MCNUM mccinter_analyzer_colimator_0_blade_0_focus_xh;
MCNUM mccinter_analyzer_colimator_0_blade_0_focus_r;
MCNUM mccinter_analyzer_colimator_0_blade_0_p_interact;
char mccinter_analyzer_colimator_0_blade_0_mask_string[16384];
char mccinter_analyzer_colimator_0_blade_0_mask_setting[16384];
MCNUM mccinter_analyzer_colimator_0_blade_0_number_of_activations;

/* Setting parameters for component 'inter_analyzer_colimator_0_blade_1' [156]. */
char mccinter_analyzer_colimator_0_blade_1_material_string[16384];
MCNUM mccinter_analyzer_colimator_0_blade_1_priority;
MCNUM mccinter_analyzer_colimator_0_blade_1_xwidth;
MCNUM mccinter_analyzer_colimator_0_blade_1_yheight;
MCNUM mccinter_analyzer_colimator_0_blade_1_zdepth;
MCNUM mccinter_analyzer_colimator_0_blade_1_xwidth2;
MCNUM mccinter_analyzer_colimator_0_blade_1_yheight2;
MCNUM mccinter_analyzer_colimator_0_blade_1_visualize;
int mccinter_analyzer_colimator_0_blade_1_target_index;
MCNUM mccinter_analyzer_colimator_0_blade_1_target_x;
MCNUM mccinter_analyzer_colimator_0_blade_1_target_y;
MCNUM mccinter_analyzer_colimator_0_blade_1_target_z;
MCNUM mccinter_analyzer_colimator_0_blade_1_focus_aw;
MCNUM mccinter_analyzer_colimator_0_blade_1_focus_ah;
MCNUM mccinter_analyzer_colimator_0_blade_1_focus_xw;
MCNUM mccinter_analyzer_colimator_0_blade_1_focus_xh;
MCNUM mccinter_analyzer_colimator_0_blade_1_focus_r;
MCNUM mccinter_analyzer_colimator_0_blade_1_p_interact;
char mccinter_analyzer_colimator_0_blade_1_mask_string[16384];
char mccinter_analyzer_colimator_0_blade_1_mask_setting[16384];
MCNUM mccinter_analyzer_colimator_0_blade_1_number_of_activations;

/* Setting parameters for component 'inter_analyzer_colimator_0_blade_2' [157]. */
char mccinter_analyzer_colimator_0_blade_2_material_string[16384];
MCNUM mccinter_analyzer_colimator_0_blade_2_priority;
MCNUM mccinter_analyzer_colimator_0_blade_2_xwidth;
MCNUM mccinter_analyzer_colimator_0_blade_2_yheight;
MCNUM mccinter_analyzer_colimator_0_blade_2_zdepth;
MCNUM mccinter_analyzer_colimator_0_blade_2_xwidth2;
MCNUM mccinter_analyzer_colimator_0_blade_2_yheight2;
MCNUM mccinter_analyzer_colimator_0_blade_2_visualize;
int mccinter_analyzer_colimator_0_blade_2_target_index;
MCNUM mccinter_analyzer_colimator_0_blade_2_target_x;
MCNUM mccinter_analyzer_colimator_0_blade_2_target_y;
MCNUM mccinter_analyzer_colimator_0_blade_2_target_z;
MCNUM mccinter_analyzer_colimator_0_blade_2_focus_aw;
MCNUM mccinter_analyzer_colimator_0_blade_2_focus_ah;
MCNUM mccinter_analyzer_colimator_0_blade_2_focus_xw;
MCNUM mccinter_analyzer_colimator_0_blade_2_focus_xh;
MCNUM mccinter_analyzer_colimator_0_blade_2_focus_r;
MCNUM mccinter_analyzer_colimator_0_blade_2_p_interact;
char mccinter_analyzer_colimator_0_blade_2_mask_string[16384];
char mccinter_analyzer_colimator_0_blade_2_mask_setting[16384];
MCNUM mccinter_analyzer_colimator_0_blade_2_number_of_activations;

/* Setting parameters for component 'inter_analyzer_colimator_0_blade_3' [158]. */
char mccinter_analyzer_colimator_0_blade_3_material_string[16384];
MCNUM mccinter_analyzer_colimator_0_blade_3_priority;
MCNUM mccinter_analyzer_colimator_0_blade_3_xwidth;
MCNUM mccinter_analyzer_colimator_0_blade_3_yheight;
MCNUM mccinter_analyzer_colimator_0_blade_3_zdepth;
MCNUM mccinter_analyzer_colimator_0_blade_3_xwidth2;
MCNUM mccinter_analyzer_colimator_0_blade_3_yheight2;
MCNUM mccinter_analyzer_colimator_0_blade_3_visualize;
int mccinter_analyzer_colimator_0_blade_3_target_index;
MCNUM mccinter_analyzer_colimator_0_blade_3_target_x;
MCNUM mccinter_analyzer_colimator_0_blade_3_target_y;
MCNUM mccinter_analyzer_colimator_0_blade_3_target_z;
MCNUM mccinter_analyzer_colimator_0_blade_3_focus_aw;
MCNUM mccinter_analyzer_colimator_0_blade_3_focus_ah;
MCNUM mccinter_analyzer_colimator_0_blade_3_focus_xw;
MCNUM mccinter_analyzer_colimator_0_blade_3_focus_xh;
MCNUM mccinter_analyzer_colimator_0_blade_3_focus_r;
MCNUM mccinter_analyzer_colimator_0_blade_3_p_interact;
char mccinter_analyzer_colimator_0_blade_3_mask_string[16384];
char mccinter_analyzer_colimator_0_blade_3_mask_setting[16384];
MCNUM mccinter_analyzer_colimator_0_blade_3_number_of_activations;

/* Setting parameters for component 'inter_analyzer_colimator_0_blade_4' [159]. */
char mccinter_analyzer_colimator_0_blade_4_material_string[16384];
MCNUM mccinter_analyzer_colimator_0_blade_4_priority;
MCNUM mccinter_analyzer_colimator_0_blade_4_xwidth;
MCNUM mccinter_analyzer_colimator_0_blade_4_yheight;
MCNUM mccinter_analyzer_colimator_0_blade_4_zdepth;
MCNUM mccinter_analyzer_colimator_0_blade_4_xwidth2;
MCNUM mccinter_analyzer_colimator_0_blade_4_yheight2;
MCNUM mccinter_analyzer_colimator_0_blade_4_visualize;
int mccinter_analyzer_colimator_0_blade_4_target_index;
MCNUM mccinter_analyzer_colimator_0_blade_4_target_x;
MCNUM mccinter_analyzer_colimator_0_blade_4_target_y;
MCNUM mccinter_analyzer_colimator_0_blade_4_target_z;
MCNUM mccinter_analyzer_colimator_0_blade_4_focus_aw;
MCNUM mccinter_analyzer_colimator_0_blade_4_focus_ah;
MCNUM mccinter_analyzer_colimator_0_blade_4_focus_xw;
MCNUM mccinter_analyzer_colimator_0_blade_4_focus_xh;
MCNUM mccinter_analyzer_colimator_0_blade_4_focus_r;
MCNUM mccinter_analyzer_colimator_0_blade_4_p_interact;
char mccinter_analyzer_colimator_0_blade_4_mask_string[16384];
char mccinter_analyzer_colimator_0_blade_4_mask_setting[16384];
MCNUM mccinter_analyzer_colimator_0_blade_4_number_of_activations;

/* Setting parameters for component 'diffraction_detector_0_exit_volume' [160]. */
char mccdiffraction_detector_0_exit_volume_material_string[16384];
MCNUM mccdiffraction_detector_0_exit_volume_priority;
MCNUM mccdiffraction_detector_0_exit_volume_xwidth;
MCNUM mccdiffraction_detector_0_exit_volume_yheight;
MCNUM mccdiffraction_detector_0_exit_volume_zdepth;
MCNUM mccdiffraction_detector_0_exit_volume_xwidth2;
MCNUM mccdiffraction_detector_0_exit_volume_yheight2;
MCNUM mccdiffraction_detector_0_exit_volume_visualize;
int mccdiffraction_detector_0_exit_volume_target_index;
MCNUM mccdiffraction_detector_0_exit_volume_target_x;
MCNUM mccdiffraction_detector_0_exit_volume_target_y;
MCNUM mccdiffraction_detector_0_exit_volume_target_z;
MCNUM mccdiffraction_detector_0_exit_volume_focus_aw;
MCNUM mccdiffraction_detector_0_exit_volume_focus_ah;
MCNUM mccdiffraction_detector_0_exit_volume_focus_xw;
MCNUM mccdiffraction_detector_0_exit_volume_focus_xh;
MCNUM mccdiffraction_detector_0_exit_volume_focus_r;
MCNUM mccdiffraction_detector_0_exit_volume_p_interact;
char mccdiffraction_detector_0_exit_volume_mask_string[16384];
char mccdiffraction_detector_0_exit_volume_mask_setting[16384];
MCNUM mccdiffraction_detector_0_exit_volume_number_of_activations;

/* Setting parameters for component 'spec_detector_0_exit_volume' [161]. */
char mccspec_detector_0_exit_volume_material_string[16384];
MCNUM mccspec_detector_0_exit_volume_priority;
MCNUM mccspec_detector_0_exit_volume_xwidth;
MCNUM mccspec_detector_0_exit_volume_yheight;
MCNUM mccspec_detector_0_exit_volume_zdepth;
MCNUM mccspec_detector_0_exit_volume_xwidth2;
MCNUM mccspec_detector_0_exit_volume_yheight2;
MCNUM mccspec_detector_0_exit_volume_visualize;
int mccspec_detector_0_exit_volume_target_index;
MCNUM mccspec_detector_0_exit_volume_target_x;
MCNUM mccspec_detector_0_exit_volume_target_y;
MCNUM mccspec_detector_0_exit_volume_target_z;
MCNUM mccspec_detector_0_exit_volume_focus_aw;
MCNUM mccspec_detector_0_exit_volume_focus_ah;
MCNUM mccspec_detector_0_exit_volume_focus_xw;
MCNUM mccspec_detector_0_exit_volume_focus_xh;
MCNUM mccspec_detector_0_exit_volume_focus_r;
MCNUM mccspec_detector_0_exit_volume_p_interact;
char mccspec_detector_0_exit_volume_mask_string[16384];
char mccspec_detector_0_exit_volume_mask_setting[16384];
MCNUM mccspec_detector_0_exit_volume_number_of_activations;

/* Setting parameters for component 'channel_1_cave1_box1' [162]. */
char mccchannel_1_cave1_box1_material_string[16384];
MCNUM mccchannel_1_cave1_box1_priority;
MCNUM mccchannel_1_cave1_box1_xwidth;
MCNUM mccchannel_1_cave1_box1_yheight;
MCNUM mccchannel_1_cave1_box1_zdepth;
MCNUM mccchannel_1_cave1_box1_xwidth2;
MCNUM mccchannel_1_cave1_box1_yheight2;
MCNUM mccchannel_1_cave1_box1_visualize;
int mccchannel_1_cave1_box1_target_index;
MCNUM mccchannel_1_cave1_box1_target_x;
MCNUM mccchannel_1_cave1_box1_target_y;
MCNUM mccchannel_1_cave1_box1_target_z;
MCNUM mccchannel_1_cave1_box1_focus_aw;
MCNUM mccchannel_1_cave1_box1_focus_ah;
MCNUM mccchannel_1_cave1_box1_focus_xw;
MCNUM mccchannel_1_cave1_box1_focus_xh;
MCNUM mccchannel_1_cave1_box1_focus_r;
MCNUM mccchannel_1_cave1_box1_p_interact;
char mccchannel_1_cave1_box1_mask_string[16384];
char mccchannel_1_cave1_box1_mask_setting[16384];
MCNUM mccchannel_1_cave1_box1_number_of_activations;

/* Setting parameters for component 'channel_1_cave1_box2' [163]. */
char mccchannel_1_cave1_box2_material_string[16384];
MCNUM mccchannel_1_cave1_box2_priority;
MCNUM mccchannel_1_cave1_box2_xwidth;
MCNUM mccchannel_1_cave1_box2_yheight;
MCNUM mccchannel_1_cave1_box2_zdepth;
MCNUM mccchannel_1_cave1_box2_xwidth2;
MCNUM mccchannel_1_cave1_box2_yheight2;
MCNUM mccchannel_1_cave1_box2_visualize;
int mccchannel_1_cave1_box2_target_index;
MCNUM mccchannel_1_cave1_box2_target_x;
MCNUM mccchannel_1_cave1_box2_target_y;
MCNUM mccchannel_1_cave1_box2_target_z;
MCNUM mccchannel_1_cave1_box2_focus_aw;
MCNUM mccchannel_1_cave1_box2_focus_ah;
MCNUM mccchannel_1_cave1_box2_focus_xw;
MCNUM mccchannel_1_cave1_box2_focus_xh;
MCNUM mccchannel_1_cave1_box2_focus_r;
MCNUM mccchannel_1_cave1_box2_p_interact;
char mccchannel_1_cave1_box2_mask_string[16384];
char mccchannel_1_cave1_box2_mask_setting[16384];
MCNUM mccchannel_1_cave1_box2_number_of_activations;

/* Setting parameters for component 'channel_1_cave1_box3' [164]. */
char mccchannel_1_cave1_box3_material_string[16384];
MCNUM mccchannel_1_cave1_box3_priority;
MCNUM mccchannel_1_cave1_box3_xwidth;
MCNUM mccchannel_1_cave1_box3_yheight;
MCNUM mccchannel_1_cave1_box3_zdepth;
MCNUM mccchannel_1_cave1_box3_xwidth2;
MCNUM mccchannel_1_cave1_box3_yheight2;
MCNUM mccchannel_1_cave1_box3_visualize;
int mccchannel_1_cave1_box3_target_index;
MCNUM mccchannel_1_cave1_box3_target_x;
MCNUM mccchannel_1_cave1_box3_target_y;
MCNUM mccchannel_1_cave1_box3_target_z;
MCNUM mccchannel_1_cave1_box3_focus_aw;
MCNUM mccchannel_1_cave1_box3_focus_ah;
MCNUM mccchannel_1_cave1_box3_focus_xw;
MCNUM mccchannel_1_cave1_box3_focus_xh;
MCNUM mccchannel_1_cave1_box3_focus_r;
MCNUM mccchannel_1_cave1_box3_p_interact;
char mccchannel_1_cave1_box3_mask_string[16384];
char mccchannel_1_cave1_box3_mask_setting[16384];
MCNUM mccchannel_1_cave1_box3_number_of_activations;

/* Setting parameters for component 'channel_1_cave1_cyl1' [165]. */
char mccchannel_1_cave1_cyl1_material_string[16384];
MCNUM mccchannel_1_cave1_cyl1_priority;
MCNUM mccchannel_1_cave1_cyl1_radius;
MCNUM mccchannel_1_cave1_cyl1_yheight;
MCNUM mccchannel_1_cave1_cyl1_visualize;
int mccchannel_1_cave1_cyl1_target_index;
MCNUM mccchannel_1_cave1_cyl1_target_x;
MCNUM mccchannel_1_cave1_cyl1_target_y;
MCNUM mccchannel_1_cave1_cyl1_target_z;
MCNUM mccchannel_1_cave1_cyl1_focus_aw;
MCNUM mccchannel_1_cave1_cyl1_focus_ah;
MCNUM mccchannel_1_cave1_cyl1_focus_xw;
MCNUM mccchannel_1_cave1_cyl1_focus_xh;
MCNUM mccchannel_1_cave1_cyl1_focus_r;
MCNUM mccchannel_1_cave1_cyl1_p_interact;
char mccchannel_1_cave1_cyl1_mask_string[16384];
char mccchannel_1_cave1_cyl1_mask_setting[16384];
MCNUM mccchannel_1_cave1_cyl1_number_of_activations;

/* Setting parameters for component 'channel_1_analyzer_1_array_crystal_array_0' [168]. */
char mccchannel_1_analyzer_1_array_crystal_array_0_material_string[16384];
MCNUM mccchannel_1_analyzer_1_array_crystal_array_0_priority;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_0_xwidth;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_0_yheight;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_0_zdepth;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_0_xwidth2;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_0_yheight2;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_0_visualize;
int mccchannel_1_analyzer_1_array_crystal_array_0_target_index;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_0_target_x;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_0_target_y;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_0_target_z;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_0_focus_aw;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_0_focus_ah;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_0_focus_xw;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_0_focus_xh;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_0_focus_r;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_0_p_interact;
char mccchannel_1_analyzer_1_array_crystal_array_0_mask_string[16384];
char mccchannel_1_analyzer_1_array_crystal_array_0_mask_setting[16384];
MCNUM mccchannel_1_analyzer_1_array_crystal_array_0_number_of_activations;

/* Setting parameters for component 'channel_1_analyzer_1_array_crystal_array_1' [169]. */
char mccchannel_1_analyzer_1_array_crystal_array_1_material_string[16384];
MCNUM mccchannel_1_analyzer_1_array_crystal_array_1_priority;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_1_xwidth;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_1_yheight;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_1_zdepth;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_1_xwidth2;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_1_yheight2;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_1_visualize;
int mccchannel_1_analyzer_1_array_crystal_array_1_target_index;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_1_target_x;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_1_target_y;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_1_target_z;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_1_focus_aw;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_1_focus_ah;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_1_focus_xw;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_1_focus_xh;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_1_focus_r;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_1_p_interact;
char mccchannel_1_analyzer_1_array_crystal_array_1_mask_string[16384];
char mccchannel_1_analyzer_1_array_crystal_array_1_mask_setting[16384];
MCNUM mccchannel_1_analyzer_1_array_crystal_array_1_number_of_activations;

/* Setting parameters for component 'channel_1_analyzer_1_array_crystal_array_2' [170]. */
char mccchannel_1_analyzer_1_array_crystal_array_2_material_string[16384];
MCNUM mccchannel_1_analyzer_1_array_crystal_array_2_priority;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_2_xwidth;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_2_yheight;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_2_zdepth;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_2_xwidth2;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_2_yheight2;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_2_visualize;
int mccchannel_1_analyzer_1_array_crystal_array_2_target_index;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_2_target_x;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_2_target_y;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_2_target_z;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_2_focus_aw;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_2_focus_ah;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_2_focus_xw;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_2_focus_xh;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_2_focus_r;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_2_p_interact;
char mccchannel_1_analyzer_1_array_crystal_array_2_mask_string[16384];
char mccchannel_1_analyzer_1_array_crystal_array_2_mask_setting[16384];
MCNUM mccchannel_1_analyzer_1_array_crystal_array_2_number_of_activations;

/* Setting parameters for component 'channel_1_analyzer_1_array_crystal_array_3' [171]. */
char mccchannel_1_analyzer_1_array_crystal_array_3_material_string[16384];
MCNUM mccchannel_1_analyzer_1_array_crystal_array_3_priority;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_3_xwidth;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_3_yheight;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_3_zdepth;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_3_xwidth2;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_3_yheight2;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_3_visualize;
int mccchannel_1_analyzer_1_array_crystal_array_3_target_index;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_3_target_x;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_3_target_y;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_3_target_z;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_3_focus_aw;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_3_focus_ah;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_3_focus_xw;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_3_focus_xh;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_3_focus_r;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_3_p_interact;
char mccchannel_1_analyzer_1_array_crystal_array_3_mask_string[16384];
char mccchannel_1_analyzer_1_array_crystal_array_3_mask_setting[16384];
MCNUM mccchannel_1_analyzer_1_array_crystal_array_3_number_of_activations;

/* Setting parameters for component 'channel_1_analyzer_1_array_crystal_array_4' [172]. */
char mccchannel_1_analyzer_1_array_crystal_array_4_material_string[16384];
MCNUM mccchannel_1_analyzer_1_array_crystal_array_4_priority;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_4_xwidth;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_4_yheight;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_4_zdepth;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_4_xwidth2;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_4_yheight2;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_4_visualize;
int mccchannel_1_analyzer_1_array_crystal_array_4_target_index;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_4_target_x;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_4_target_y;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_4_target_z;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_4_focus_aw;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_4_focus_ah;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_4_focus_xw;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_4_focus_xh;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_4_focus_r;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_4_p_interact;
char mccchannel_1_analyzer_1_array_crystal_array_4_mask_string[16384];
char mccchannel_1_analyzer_1_array_crystal_array_4_mask_setting[16384];
MCNUM mccchannel_1_analyzer_1_array_crystal_array_4_number_of_activations;

/* Setting parameters for component 'channel_1_analyzer_1_array_crystal_array_5' [173]. */
char mccchannel_1_analyzer_1_array_crystal_array_5_material_string[16384];
MCNUM mccchannel_1_analyzer_1_array_crystal_array_5_priority;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_5_xwidth;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_5_yheight;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_5_zdepth;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_5_xwidth2;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_5_yheight2;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_5_visualize;
int mccchannel_1_analyzer_1_array_crystal_array_5_target_index;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_5_target_x;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_5_target_y;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_5_target_z;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_5_focus_aw;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_5_focus_ah;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_5_focus_xw;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_5_focus_xh;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_5_focus_r;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_5_p_interact;
char mccchannel_1_analyzer_1_array_crystal_array_5_mask_string[16384];
char mccchannel_1_analyzer_1_array_crystal_array_5_mask_setting[16384];
MCNUM mccchannel_1_analyzer_1_array_crystal_array_5_number_of_activations;

/* Setting parameters for component 'channel_1_analyzer_1_array_crystal_array_6' [174]. */
char mccchannel_1_analyzer_1_array_crystal_array_6_material_string[16384];
MCNUM mccchannel_1_analyzer_1_array_crystal_array_6_priority;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_6_xwidth;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_6_yheight;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_6_zdepth;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_6_xwidth2;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_6_yheight2;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_6_visualize;
int mccchannel_1_analyzer_1_array_crystal_array_6_target_index;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_6_target_x;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_6_target_y;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_6_target_z;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_6_focus_aw;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_6_focus_ah;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_6_focus_xw;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_6_focus_xh;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_6_focus_r;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_6_p_interact;
char mccchannel_1_analyzer_1_array_crystal_array_6_mask_string[16384];
char mccchannel_1_analyzer_1_array_crystal_array_6_mask_setting[16384];
MCNUM mccchannel_1_analyzer_1_array_crystal_array_6_number_of_activations;

/* Setting parameters for component 'channel_1_analyzer_1_array_crystal_array_7' [175]. */
char mccchannel_1_analyzer_1_array_crystal_array_7_material_string[16384];
MCNUM mccchannel_1_analyzer_1_array_crystal_array_7_priority;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_7_xwidth;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_7_yheight;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_7_zdepth;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_7_xwidth2;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_7_yheight2;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_7_visualize;
int mccchannel_1_analyzer_1_array_crystal_array_7_target_index;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_7_target_x;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_7_target_y;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_7_target_z;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_7_focus_aw;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_7_focus_ah;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_7_focus_xw;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_7_focus_xh;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_7_focus_r;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_7_p_interact;
char mccchannel_1_analyzer_1_array_crystal_array_7_mask_string[16384];
char mccchannel_1_analyzer_1_array_crystal_array_7_mask_setting[16384];
MCNUM mccchannel_1_analyzer_1_array_crystal_array_7_number_of_activations;

/* Setting parameters for component 'channel_1_analyzer_1_array_crystal_array_8' [176]. */
char mccchannel_1_analyzer_1_array_crystal_array_8_material_string[16384];
MCNUM mccchannel_1_analyzer_1_array_crystal_array_8_priority;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_8_xwidth;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_8_yheight;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_8_zdepth;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_8_xwidth2;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_8_yheight2;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_8_visualize;
int mccchannel_1_analyzer_1_array_crystal_array_8_target_index;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_8_target_x;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_8_target_y;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_8_target_z;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_8_focus_aw;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_8_focus_ah;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_8_focus_xw;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_8_focus_xh;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_8_focus_r;
MCNUM mccchannel_1_analyzer_1_array_crystal_array_8_p_interact;
char mccchannel_1_analyzer_1_array_crystal_array_8_mask_string[16384];
char mccchannel_1_analyzer_1_array_crystal_array_8_mask_setting[16384];
MCNUM mccchannel_1_analyzer_1_array_crystal_array_8_number_of_activations;

/* Setting parameters for component 'channel_1_analyzer_2_array_crystal_array_0' [179]. */
char mccchannel_1_analyzer_2_array_crystal_array_0_material_string[16384];
MCNUM mccchannel_1_analyzer_2_array_crystal_array_0_priority;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_0_xwidth;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_0_yheight;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_0_zdepth;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_0_xwidth2;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_0_yheight2;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_0_visualize;
int mccchannel_1_analyzer_2_array_crystal_array_0_target_index;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_0_target_x;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_0_target_y;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_0_target_z;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_0_focus_aw;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_0_focus_ah;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_0_focus_xw;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_0_focus_xh;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_0_focus_r;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_0_p_interact;
char mccchannel_1_analyzer_2_array_crystal_array_0_mask_string[16384];
char mccchannel_1_analyzer_2_array_crystal_array_0_mask_setting[16384];
MCNUM mccchannel_1_analyzer_2_array_crystal_array_0_number_of_activations;

/* Setting parameters for component 'channel_1_analyzer_2_array_crystal_array_1' [180]. */
char mccchannel_1_analyzer_2_array_crystal_array_1_material_string[16384];
MCNUM mccchannel_1_analyzer_2_array_crystal_array_1_priority;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_1_xwidth;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_1_yheight;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_1_zdepth;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_1_xwidth2;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_1_yheight2;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_1_visualize;
int mccchannel_1_analyzer_2_array_crystal_array_1_target_index;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_1_target_x;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_1_target_y;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_1_target_z;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_1_focus_aw;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_1_focus_ah;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_1_focus_xw;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_1_focus_xh;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_1_focus_r;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_1_p_interact;
char mccchannel_1_analyzer_2_array_crystal_array_1_mask_string[16384];
char mccchannel_1_analyzer_2_array_crystal_array_1_mask_setting[16384];
MCNUM mccchannel_1_analyzer_2_array_crystal_array_1_number_of_activations;

/* Setting parameters for component 'channel_1_analyzer_2_array_crystal_array_2' [181]. */
char mccchannel_1_analyzer_2_array_crystal_array_2_material_string[16384];
MCNUM mccchannel_1_analyzer_2_array_crystal_array_2_priority;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_2_xwidth;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_2_yheight;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_2_zdepth;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_2_xwidth2;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_2_yheight2;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_2_visualize;
int mccchannel_1_analyzer_2_array_crystal_array_2_target_index;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_2_target_x;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_2_target_y;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_2_target_z;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_2_focus_aw;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_2_focus_ah;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_2_focus_xw;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_2_focus_xh;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_2_focus_r;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_2_p_interact;
char mccchannel_1_analyzer_2_array_crystal_array_2_mask_string[16384];
char mccchannel_1_analyzer_2_array_crystal_array_2_mask_setting[16384];
MCNUM mccchannel_1_analyzer_2_array_crystal_array_2_number_of_activations;

/* Setting parameters for component 'channel_1_analyzer_2_array_crystal_array_3' [182]. */
char mccchannel_1_analyzer_2_array_crystal_array_3_material_string[16384];
MCNUM mccchannel_1_analyzer_2_array_crystal_array_3_priority;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_3_xwidth;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_3_yheight;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_3_zdepth;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_3_xwidth2;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_3_yheight2;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_3_visualize;
int mccchannel_1_analyzer_2_array_crystal_array_3_target_index;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_3_target_x;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_3_target_y;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_3_target_z;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_3_focus_aw;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_3_focus_ah;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_3_focus_xw;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_3_focus_xh;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_3_focus_r;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_3_p_interact;
char mccchannel_1_analyzer_2_array_crystal_array_3_mask_string[16384];
char mccchannel_1_analyzer_2_array_crystal_array_3_mask_setting[16384];
MCNUM mccchannel_1_analyzer_2_array_crystal_array_3_number_of_activations;

/* Setting parameters for component 'channel_1_analyzer_2_array_crystal_array_4' [183]. */
char mccchannel_1_analyzer_2_array_crystal_array_4_material_string[16384];
MCNUM mccchannel_1_analyzer_2_array_crystal_array_4_priority;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_4_xwidth;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_4_yheight;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_4_zdepth;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_4_xwidth2;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_4_yheight2;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_4_visualize;
int mccchannel_1_analyzer_2_array_crystal_array_4_target_index;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_4_target_x;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_4_target_y;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_4_target_z;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_4_focus_aw;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_4_focus_ah;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_4_focus_xw;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_4_focus_xh;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_4_focus_r;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_4_p_interact;
char mccchannel_1_analyzer_2_array_crystal_array_4_mask_string[16384];
char mccchannel_1_analyzer_2_array_crystal_array_4_mask_setting[16384];
MCNUM mccchannel_1_analyzer_2_array_crystal_array_4_number_of_activations;

/* Setting parameters for component 'channel_1_analyzer_2_array_crystal_array_5' [184]. */
char mccchannel_1_analyzer_2_array_crystal_array_5_material_string[16384];
MCNUM mccchannel_1_analyzer_2_array_crystal_array_5_priority;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_5_xwidth;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_5_yheight;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_5_zdepth;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_5_xwidth2;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_5_yheight2;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_5_visualize;
int mccchannel_1_analyzer_2_array_crystal_array_5_target_index;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_5_target_x;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_5_target_y;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_5_target_z;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_5_focus_aw;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_5_focus_ah;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_5_focus_xw;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_5_focus_xh;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_5_focus_r;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_5_p_interact;
char mccchannel_1_analyzer_2_array_crystal_array_5_mask_string[16384];
char mccchannel_1_analyzer_2_array_crystal_array_5_mask_setting[16384];
MCNUM mccchannel_1_analyzer_2_array_crystal_array_5_number_of_activations;

/* Setting parameters for component 'channel_1_analyzer_2_array_crystal_array_6' [185]. */
char mccchannel_1_analyzer_2_array_crystal_array_6_material_string[16384];
MCNUM mccchannel_1_analyzer_2_array_crystal_array_6_priority;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_6_xwidth;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_6_yheight;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_6_zdepth;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_6_xwidth2;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_6_yheight2;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_6_visualize;
int mccchannel_1_analyzer_2_array_crystal_array_6_target_index;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_6_target_x;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_6_target_y;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_6_target_z;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_6_focus_aw;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_6_focus_ah;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_6_focus_xw;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_6_focus_xh;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_6_focus_r;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_6_p_interact;
char mccchannel_1_analyzer_2_array_crystal_array_6_mask_string[16384];
char mccchannel_1_analyzer_2_array_crystal_array_6_mask_setting[16384];
MCNUM mccchannel_1_analyzer_2_array_crystal_array_6_number_of_activations;

/* Setting parameters for component 'channel_1_analyzer_2_array_crystal_array_7' [186]. */
char mccchannel_1_analyzer_2_array_crystal_array_7_material_string[16384];
MCNUM mccchannel_1_analyzer_2_array_crystal_array_7_priority;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_7_xwidth;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_7_yheight;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_7_zdepth;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_7_xwidth2;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_7_yheight2;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_7_visualize;
int mccchannel_1_analyzer_2_array_crystal_array_7_target_index;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_7_target_x;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_7_target_y;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_7_target_z;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_7_focus_aw;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_7_focus_ah;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_7_focus_xw;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_7_focus_xh;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_7_focus_r;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_7_p_interact;
char mccchannel_1_analyzer_2_array_crystal_array_7_mask_string[16384];
char mccchannel_1_analyzer_2_array_crystal_array_7_mask_setting[16384];
MCNUM mccchannel_1_analyzer_2_array_crystal_array_7_number_of_activations;

/* Setting parameters for component 'channel_1_analyzer_2_array_crystal_array_8' [187]. */
char mccchannel_1_analyzer_2_array_crystal_array_8_material_string[16384];
MCNUM mccchannel_1_analyzer_2_array_crystal_array_8_priority;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_8_xwidth;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_8_yheight;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_8_zdepth;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_8_xwidth2;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_8_yheight2;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_8_visualize;
int mccchannel_1_analyzer_2_array_crystal_array_8_target_index;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_8_target_x;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_8_target_y;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_8_target_z;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_8_focus_aw;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_8_focus_ah;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_8_focus_xw;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_8_focus_xh;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_8_focus_r;
MCNUM mccchannel_1_analyzer_2_array_crystal_array_8_p_interact;
char mccchannel_1_analyzer_2_array_crystal_array_8_mask_string[16384];
char mccchannel_1_analyzer_2_array_crystal_array_8_mask_setting[16384];
MCNUM mccchannel_1_analyzer_2_array_crystal_array_8_number_of_activations;

/* Setting parameters for component 'channel_1_cave2_cyl1' [188]. */
char mccchannel_1_cave2_cyl1_material_string[16384];
MCNUM mccchannel_1_cave2_cyl1_priority;
MCNUM mccchannel_1_cave2_cyl1_radius;
MCNUM mccchannel_1_cave2_cyl1_yheight;
MCNUM mccchannel_1_cave2_cyl1_visualize;
int mccchannel_1_cave2_cyl1_target_index;
MCNUM mccchannel_1_cave2_cyl1_target_x;
MCNUM mccchannel_1_cave2_cyl1_target_y;
MCNUM mccchannel_1_cave2_cyl1_target_z;
MCNUM mccchannel_1_cave2_cyl1_focus_aw;
MCNUM mccchannel_1_cave2_cyl1_focus_ah;
MCNUM mccchannel_1_cave2_cyl1_focus_xw;
MCNUM mccchannel_1_cave2_cyl1_focus_xh;
MCNUM mccchannel_1_cave2_cyl1_focus_r;
MCNUM mccchannel_1_cave2_cyl1_p_interact;
char mccchannel_1_cave2_cyl1_mask_string[16384];
char mccchannel_1_cave2_cyl1_mask_setting[16384];
MCNUM mccchannel_1_cave2_cyl1_number_of_activations;

/* Setting parameters for component 'channel_1_cave2_box1' [189]. */
char mccchannel_1_cave2_box1_material_string[16384];
MCNUM mccchannel_1_cave2_box1_priority;
MCNUM mccchannel_1_cave2_box1_xwidth;
MCNUM mccchannel_1_cave2_box1_yheight;
MCNUM mccchannel_1_cave2_box1_zdepth;
MCNUM mccchannel_1_cave2_box1_xwidth2;
MCNUM mccchannel_1_cave2_box1_yheight2;
MCNUM mccchannel_1_cave2_box1_visualize;
int mccchannel_1_cave2_box1_target_index;
MCNUM mccchannel_1_cave2_box1_target_x;
MCNUM mccchannel_1_cave2_box1_target_y;
MCNUM mccchannel_1_cave2_box1_target_z;
MCNUM mccchannel_1_cave2_box1_focus_aw;
MCNUM mccchannel_1_cave2_box1_focus_ah;
MCNUM mccchannel_1_cave2_box1_focus_xw;
MCNUM mccchannel_1_cave2_box1_focus_xh;
MCNUM mccchannel_1_cave2_box1_focus_r;
MCNUM mccchannel_1_cave2_box1_p_interact;
char mccchannel_1_cave2_box1_mask_string[16384];
char mccchannel_1_cave2_box1_mask_setting[16384];
MCNUM mccchannel_1_cave2_box1_number_of_activations;

/* Setting parameters for component 'channel_1_cave2_box2' [190]. */
char mccchannel_1_cave2_box2_material_string[16384];
MCNUM mccchannel_1_cave2_box2_priority;
MCNUM mccchannel_1_cave2_box2_xwidth;
MCNUM mccchannel_1_cave2_box2_yheight;
MCNUM mccchannel_1_cave2_box2_zdepth;
MCNUM mccchannel_1_cave2_box2_xwidth2;
MCNUM mccchannel_1_cave2_box2_yheight2;
MCNUM mccchannel_1_cave2_box2_visualize;
int mccchannel_1_cave2_box2_target_index;
MCNUM mccchannel_1_cave2_box2_target_x;
MCNUM mccchannel_1_cave2_box2_target_y;
MCNUM mccchannel_1_cave2_box2_target_z;
MCNUM mccchannel_1_cave2_box2_focus_aw;
MCNUM mccchannel_1_cave2_box2_focus_ah;
MCNUM mccchannel_1_cave2_box2_focus_xw;
MCNUM mccchannel_1_cave2_box2_focus_xh;
MCNUM mccchannel_1_cave2_box2_focus_r;
MCNUM mccchannel_1_cave2_box2_p_interact;
char mccchannel_1_cave2_box2_mask_string[16384];
char mccchannel_1_cave2_box2_mask_setting[16384];
MCNUM mccchannel_1_cave2_box2_number_of_activations;

/* Setting parameters for component 'channel_1_cave2_box3' [191]. */
char mccchannel_1_cave2_box3_material_string[16384];
MCNUM mccchannel_1_cave2_box3_priority;
MCNUM mccchannel_1_cave2_box3_xwidth;
MCNUM mccchannel_1_cave2_box3_yheight;
MCNUM mccchannel_1_cave2_box3_zdepth;
MCNUM mccchannel_1_cave2_box3_xwidth2;
MCNUM mccchannel_1_cave2_box3_yheight2;
MCNUM mccchannel_1_cave2_box3_visualize;
int mccchannel_1_cave2_box3_target_index;
MCNUM mccchannel_1_cave2_box3_target_x;
MCNUM mccchannel_1_cave2_box3_target_y;
MCNUM mccchannel_1_cave2_box3_target_z;
MCNUM mccchannel_1_cave2_box3_focus_aw;
MCNUM mccchannel_1_cave2_box3_focus_ah;
MCNUM mccchannel_1_cave2_box3_focus_xw;
MCNUM mccchannel_1_cave2_box3_focus_xh;
MCNUM mccchannel_1_cave2_box3_focus_r;
MCNUM mccchannel_1_cave2_box3_p_interact;
char mccchannel_1_cave2_box3_mask_string[16384];
char mccchannel_1_cave2_box3_mask_setting[16384];
MCNUM mccchannel_1_cave2_box3_number_of_activations;

/* Setting parameters for component 'inter_analyzer_colimator_1_blade_0' [193]. */
char mccinter_analyzer_colimator_1_blade_0_material_string[16384];
MCNUM mccinter_analyzer_colimator_1_blade_0_priority;
MCNUM mccinter_analyzer_colimator_1_blade_0_xwidth;
MCNUM mccinter_analyzer_colimator_1_blade_0_yheight;
MCNUM mccinter_analyzer_colimator_1_blade_0_zdepth;
MCNUM mccinter_analyzer_colimator_1_blade_0_xwidth2;
MCNUM mccinter_analyzer_colimator_1_blade_0_yheight2;
MCNUM mccinter_analyzer_colimator_1_blade_0_visualize;
int mccinter_analyzer_colimator_1_blade_0_target_index;
MCNUM mccinter_analyzer_colimator_1_blade_0_target_x;
MCNUM mccinter_analyzer_colimator_1_blade_0_target_y;
MCNUM mccinter_analyzer_colimator_1_blade_0_target_z;
MCNUM mccinter_analyzer_colimator_1_blade_0_focus_aw;
MCNUM mccinter_analyzer_colimator_1_blade_0_focus_ah;
MCNUM mccinter_analyzer_colimator_1_blade_0_focus_xw;
MCNUM mccinter_analyzer_colimator_1_blade_0_focus_xh;
MCNUM mccinter_analyzer_colimator_1_blade_0_focus_r;
MCNUM mccinter_analyzer_colimator_1_blade_0_p_interact;
char mccinter_analyzer_colimator_1_blade_0_mask_string[16384];
char mccinter_analyzer_colimator_1_blade_0_mask_setting[16384];
MCNUM mccinter_analyzer_colimator_1_blade_0_number_of_activations;

/* Setting parameters for component 'inter_analyzer_colimator_1_blade_1' [194]. */
char mccinter_analyzer_colimator_1_blade_1_material_string[16384];
MCNUM mccinter_analyzer_colimator_1_blade_1_priority;
MCNUM mccinter_analyzer_colimator_1_blade_1_xwidth;
MCNUM mccinter_analyzer_colimator_1_blade_1_yheight;
MCNUM mccinter_analyzer_colimator_1_blade_1_zdepth;
MCNUM mccinter_analyzer_colimator_1_blade_1_xwidth2;
MCNUM mccinter_analyzer_colimator_1_blade_1_yheight2;
MCNUM mccinter_analyzer_colimator_1_blade_1_visualize;
int mccinter_analyzer_colimator_1_blade_1_target_index;
MCNUM mccinter_analyzer_colimator_1_blade_1_target_x;
MCNUM mccinter_analyzer_colimator_1_blade_1_target_y;
MCNUM mccinter_analyzer_colimator_1_blade_1_target_z;
MCNUM mccinter_analyzer_colimator_1_blade_1_focus_aw;
MCNUM mccinter_analyzer_colimator_1_blade_1_focus_ah;
MCNUM mccinter_analyzer_colimator_1_blade_1_focus_xw;
MCNUM mccinter_analyzer_colimator_1_blade_1_focus_xh;
MCNUM mccinter_analyzer_colimator_1_blade_1_focus_r;
MCNUM mccinter_analyzer_colimator_1_blade_1_p_interact;
char mccinter_analyzer_colimator_1_blade_1_mask_string[16384];
char mccinter_analyzer_colimator_1_blade_1_mask_setting[16384];
MCNUM mccinter_analyzer_colimator_1_blade_1_number_of_activations;

/* Setting parameters for component 'inter_analyzer_colimator_1_blade_2' [195]. */
char mccinter_analyzer_colimator_1_blade_2_material_string[16384];
MCNUM mccinter_analyzer_colimator_1_blade_2_priority;
MCNUM mccinter_analyzer_colimator_1_blade_2_xwidth;
MCNUM mccinter_analyzer_colimator_1_blade_2_yheight;
MCNUM mccinter_analyzer_colimator_1_blade_2_zdepth;
MCNUM mccinter_analyzer_colimator_1_blade_2_xwidth2;
MCNUM mccinter_analyzer_colimator_1_blade_2_yheight2;
MCNUM mccinter_analyzer_colimator_1_blade_2_visualize;
int mccinter_analyzer_colimator_1_blade_2_target_index;
MCNUM mccinter_analyzer_colimator_1_blade_2_target_x;
MCNUM mccinter_analyzer_colimator_1_blade_2_target_y;
MCNUM mccinter_analyzer_colimator_1_blade_2_target_z;
MCNUM mccinter_analyzer_colimator_1_blade_2_focus_aw;
MCNUM mccinter_analyzer_colimator_1_blade_2_focus_ah;
MCNUM mccinter_analyzer_colimator_1_blade_2_focus_xw;
MCNUM mccinter_analyzer_colimator_1_blade_2_focus_xh;
MCNUM mccinter_analyzer_colimator_1_blade_2_focus_r;
MCNUM mccinter_analyzer_colimator_1_blade_2_p_interact;
char mccinter_analyzer_colimator_1_blade_2_mask_string[16384];
char mccinter_analyzer_colimator_1_blade_2_mask_setting[16384];
MCNUM mccinter_analyzer_colimator_1_blade_2_number_of_activations;

/* Setting parameters for component 'inter_analyzer_colimator_1_blade_3' [196]. */
char mccinter_analyzer_colimator_1_blade_3_material_string[16384];
MCNUM mccinter_analyzer_colimator_1_blade_3_priority;
MCNUM mccinter_analyzer_colimator_1_blade_3_xwidth;
MCNUM mccinter_analyzer_colimator_1_blade_3_yheight;
MCNUM mccinter_analyzer_colimator_1_blade_3_zdepth;
MCNUM mccinter_analyzer_colimator_1_blade_3_xwidth2;
MCNUM mccinter_analyzer_colimator_1_blade_3_yheight2;
MCNUM mccinter_analyzer_colimator_1_blade_3_visualize;
int mccinter_analyzer_colimator_1_blade_3_target_index;
MCNUM mccinter_analyzer_colimator_1_blade_3_target_x;
MCNUM mccinter_analyzer_colimator_1_blade_3_target_y;
MCNUM mccinter_analyzer_colimator_1_blade_3_target_z;
MCNUM mccinter_analyzer_colimator_1_blade_3_focus_aw;
MCNUM mccinter_analyzer_colimator_1_blade_3_focus_ah;
MCNUM mccinter_analyzer_colimator_1_blade_3_focus_xw;
MCNUM mccinter_analyzer_colimator_1_blade_3_focus_xh;
MCNUM mccinter_analyzer_colimator_1_blade_3_focus_r;
MCNUM mccinter_analyzer_colimator_1_blade_3_p_interact;
char mccinter_analyzer_colimator_1_blade_3_mask_string[16384];
char mccinter_analyzer_colimator_1_blade_3_mask_setting[16384];
MCNUM mccinter_analyzer_colimator_1_blade_3_number_of_activations;

/* Setting parameters for component 'inter_analyzer_colimator_1_blade_4' [197]. */
char mccinter_analyzer_colimator_1_blade_4_material_string[16384];
MCNUM mccinter_analyzer_colimator_1_blade_4_priority;
MCNUM mccinter_analyzer_colimator_1_blade_4_xwidth;
MCNUM mccinter_analyzer_colimator_1_blade_4_yheight;
MCNUM mccinter_analyzer_colimator_1_blade_4_zdepth;
MCNUM mccinter_analyzer_colimator_1_blade_4_xwidth2;
MCNUM mccinter_analyzer_colimator_1_blade_4_yheight2;
MCNUM mccinter_analyzer_colimator_1_blade_4_visualize;
int mccinter_analyzer_colimator_1_blade_4_target_index;
MCNUM mccinter_analyzer_colimator_1_blade_4_target_x;
MCNUM mccinter_analyzer_colimator_1_blade_4_target_y;
MCNUM mccinter_analyzer_colimator_1_blade_4_target_z;
MCNUM mccinter_analyzer_colimator_1_blade_4_focus_aw;
MCNUM mccinter_analyzer_colimator_1_blade_4_focus_ah;
MCNUM mccinter_analyzer_colimator_1_blade_4_focus_xw;
MCNUM mccinter_analyzer_colimator_1_blade_4_focus_xh;
MCNUM mccinter_analyzer_colimator_1_blade_4_focus_r;
MCNUM mccinter_analyzer_colimator_1_blade_4_p_interact;
char mccinter_analyzer_colimator_1_blade_4_mask_string[16384];
char mccinter_analyzer_colimator_1_blade_4_mask_setting[16384];
MCNUM mccinter_analyzer_colimator_1_blade_4_number_of_activations;

/* Setting parameters for component 'diffraction_detector_1_exit_volume' [198]. */
char mccdiffraction_detector_1_exit_volume_material_string[16384];
MCNUM mccdiffraction_detector_1_exit_volume_priority;
MCNUM mccdiffraction_detector_1_exit_volume_xwidth;
MCNUM mccdiffraction_detector_1_exit_volume_yheight;
MCNUM mccdiffraction_detector_1_exit_volume_zdepth;
MCNUM mccdiffraction_detector_1_exit_volume_xwidth2;
MCNUM mccdiffraction_detector_1_exit_volume_yheight2;
MCNUM mccdiffraction_detector_1_exit_volume_visualize;
int mccdiffraction_detector_1_exit_volume_target_index;
MCNUM mccdiffraction_detector_1_exit_volume_target_x;
MCNUM mccdiffraction_detector_1_exit_volume_target_y;
MCNUM mccdiffraction_detector_1_exit_volume_target_z;
MCNUM mccdiffraction_detector_1_exit_volume_focus_aw;
MCNUM mccdiffraction_detector_1_exit_volume_focus_ah;
MCNUM mccdiffraction_detector_1_exit_volume_focus_xw;
MCNUM mccdiffraction_detector_1_exit_volume_focus_xh;
MCNUM mccdiffraction_detector_1_exit_volume_focus_r;
MCNUM mccdiffraction_detector_1_exit_volume_p_interact;
char mccdiffraction_detector_1_exit_volume_mask_string[16384];
char mccdiffraction_detector_1_exit_volume_mask_setting[16384];
MCNUM mccdiffraction_detector_1_exit_volume_number_of_activations;

/* Setting parameters for component 'spec_detector_1_exit_volume' [199]. */
char mccspec_detector_1_exit_volume_material_string[16384];
MCNUM mccspec_detector_1_exit_volume_priority;
MCNUM mccspec_detector_1_exit_volume_xwidth;
MCNUM mccspec_detector_1_exit_volume_yheight;
MCNUM mccspec_detector_1_exit_volume_zdepth;
MCNUM mccspec_detector_1_exit_volume_xwidth2;
MCNUM mccspec_detector_1_exit_volume_yheight2;
MCNUM mccspec_detector_1_exit_volume_visualize;
int mccspec_detector_1_exit_volume_target_index;
MCNUM mccspec_detector_1_exit_volume_target_x;
MCNUM mccspec_detector_1_exit_volume_target_y;
MCNUM mccspec_detector_1_exit_volume_target_z;
MCNUM mccspec_detector_1_exit_volume_focus_aw;
MCNUM mccspec_detector_1_exit_volume_focus_ah;
MCNUM mccspec_detector_1_exit_volume_focus_xw;
MCNUM mccspec_detector_1_exit_volume_focus_xh;
MCNUM mccspec_detector_1_exit_volume_focus_r;
MCNUM mccspec_detector_1_exit_volume_p_interact;
char mccspec_detector_1_exit_volume_mask_string[16384];
char mccspec_detector_1_exit_volume_mask_setting[16384];
MCNUM mccspec_detector_1_exit_volume_number_of_activations;

/* Setting parameters for component 'channel_2_cave1_box1' [200]. */
char mccchannel_2_cave1_box1_material_string[16384];
MCNUM mccchannel_2_cave1_box1_priority;
MCNUM mccchannel_2_cave1_box1_xwidth;
MCNUM mccchannel_2_cave1_box1_yheight;
MCNUM mccchannel_2_cave1_box1_zdepth;
MCNUM mccchannel_2_cave1_box1_xwidth2;
MCNUM mccchannel_2_cave1_box1_yheight2;
MCNUM mccchannel_2_cave1_box1_visualize;
int mccchannel_2_cave1_box1_target_index;
MCNUM mccchannel_2_cave1_box1_target_x;
MCNUM mccchannel_2_cave1_box1_target_y;
MCNUM mccchannel_2_cave1_box1_target_z;
MCNUM mccchannel_2_cave1_box1_focus_aw;
MCNUM mccchannel_2_cave1_box1_focus_ah;
MCNUM mccchannel_2_cave1_box1_focus_xw;
MCNUM mccchannel_2_cave1_box1_focus_xh;
MCNUM mccchannel_2_cave1_box1_focus_r;
MCNUM mccchannel_2_cave1_box1_p_interact;
char mccchannel_2_cave1_box1_mask_string[16384];
char mccchannel_2_cave1_box1_mask_setting[16384];
MCNUM mccchannel_2_cave1_box1_number_of_activations;

/* Setting parameters for component 'channel_2_cave1_box2' [201]. */
char mccchannel_2_cave1_box2_material_string[16384];
MCNUM mccchannel_2_cave1_box2_priority;
MCNUM mccchannel_2_cave1_box2_xwidth;
MCNUM mccchannel_2_cave1_box2_yheight;
MCNUM mccchannel_2_cave1_box2_zdepth;
MCNUM mccchannel_2_cave1_box2_xwidth2;
MCNUM mccchannel_2_cave1_box2_yheight2;
MCNUM mccchannel_2_cave1_box2_visualize;
int mccchannel_2_cave1_box2_target_index;
MCNUM mccchannel_2_cave1_box2_target_x;
MCNUM mccchannel_2_cave1_box2_target_y;
MCNUM mccchannel_2_cave1_box2_target_z;
MCNUM mccchannel_2_cave1_box2_focus_aw;
MCNUM mccchannel_2_cave1_box2_focus_ah;
MCNUM mccchannel_2_cave1_box2_focus_xw;
MCNUM mccchannel_2_cave1_box2_focus_xh;
MCNUM mccchannel_2_cave1_box2_focus_r;
MCNUM mccchannel_2_cave1_box2_p_interact;
char mccchannel_2_cave1_box2_mask_string[16384];
char mccchannel_2_cave1_box2_mask_setting[16384];
MCNUM mccchannel_2_cave1_box2_number_of_activations;

/* Setting parameters for component 'channel_2_cave1_box3' [202]. */
char mccchannel_2_cave1_box3_material_string[16384];
MCNUM mccchannel_2_cave1_box3_priority;
MCNUM mccchannel_2_cave1_box3_xwidth;
MCNUM mccchannel_2_cave1_box3_yheight;
MCNUM mccchannel_2_cave1_box3_zdepth;
MCNUM mccchannel_2_cave1_box3_xwidth2;
MCNUM mccchannel_2_cave1_box3_yheight2;
MCNUM mccchannel_2_cave1_box3_visualize;
int mccchannel_2_cave1_box3_target_index;
MCNUM mccchannel_2_cave1_box3_target_x;
MCNUM mccchannel_2_cave1_box3_target_y;
MCNUM mccchannel_2_cave1_box3_target_z;
MCNUM mccchannel_2_cave1_box3_focus_aw;
MCNUM mccchannel_2_cave1_box3_focus_ah;
MCNUM mccchannel_2_cave1_box3_focus_xw;
MCNUM mccchannel_2_cave1_box3_focus_xh;
MCNUM mccchannel_2_cave1_box3_focus_r;
MCNUM mccchannel_2_cave1_box3_p_interact;
char mccchannel_2_cave1_box3_mask_string[16384];
char mccchannel_2_cave1_box3_mask_setting[16384];
MCNUM mccchannel_2_cave1_box3_number_of_activations;

/* Setting parameters for component 'channel_2_cave1_cyl1' [203]. */
char mccchannel_2_cave1_cyl1_material_string[16384];
MCNUM mccchannel_2_cave1_cyl1_priority;
MCNUM mccchannel_2_cave1_cyl1_radius;
MCNUM mccchannel_2_cave1_cyl1_yheight;
MCNUM mccchannel_2_cave1_cyl1_visualize;
int mccchannel_2_cave1_cyl1_target_index;
MCNUM mccchannel_2_cave1_cyl1_target_x;
MCNUM mccchannel_2_cave1_cyl1_target_y;
MCNUM mccchannel_2_cave1_cyl1_target_z;
MCNUM mccchannel_2_cave1_cyl1_focus_aw;
MCNUM mccchannel_2_cave1_cyl1_focus_ah;
MCNUM mccchannel_2_cave1_cyl1_focus_xw;
MCNUM mccchannel_2_cave1_cyl1_focus_xh;
MCNUM mccchannel_2_cave1_cyl1_focus_r;
MCNUM mccchannel_2_cave1_cyl1_p_interact;
char mccchannel_2_cave1_cyl1_mask_string[16384];
char mccchannel_2_cave1_cyl1_mask_setting[16384];
MCNUM mccchannel_2_cave1_cyl1_number_of_activations;

/* Setting parameters for component 'channel_2_analyzer_1_array_crystal_array_0' [206]. */
char mccchannel_2_analyzer_1_array_crystal_array_0_material_string[16384];
MCNUM mccchannel_2_analyzer_1_array_crystal_array_0_priority;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_0_xwidth;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_0_yheight;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_0_zdepth;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_0_xwidth2;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_0_yheight2;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_0_visualize;
int mccchannel_2_analyzer_1_array_crystal_array_0_target_index;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_0_target_x;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_0_target_y;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_0_target_z;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_0_focus_aw;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_0_focus_ah;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_0_focus_xw;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_0_focus_xh;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_0_focus_r;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_0_p_interact;
char mccchannel_2_analyzer_1_array_crystal_array_0_mask_string[16384];
char mccchannel_2_analyzer_1_array_crystal_array_0_mask_setting[16384];
MCNUM mccchannel_2_analyzer_1_array_crystal_array_0_number_of_activations;

/* Setting parameters for component 'channel_2_analyzer_1_array_crystal_array_1' [207]. */
char mccchannel_2_analyzer_1_array_crystal_array_1_material_string[16384];
MCNUM mccchannel_2_analyzer_1_array_crystal_array_1_priority;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_1_xwidth;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_1_yheight;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_1_zdepth;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_1_xwidth2;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_1_yheight2;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_1_visualize;
int mccchannel_2_analyzer_1_array_crystal_array_1_target_index;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_1_target_x;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_1_target_y;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_1_target_z;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_1_focus_aw;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_1_focus_ah;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_1_focus_xw;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_1_focus_xh;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_1_focus_r;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_1_p_interact;
char mccchannel_2_analyzer_1_array_crystal_array_1_mask_string[16384];
char mccchannel_2_analyzer_1_array_crystal_array_1_mask_setting[16384];
MCNUM mccchannel_2_analyzer_1_array_crystal_array_1_number_of_activations;

/* Setting parameters for component 'channel_2_analyzer_1_array_crystal_array_2' [208]. */
char mccchannel_2_analyzer_1_array_crystal_array_2_material_string[16384];
MCNUM mccchannel_2_analyzer_1_array_crystal_array_2_priority;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_2_xwidth;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_2_yheight;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_2_zdepth;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_2_xwidth2;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_2_yheight2;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_2_visualize;
int mccchannel_2_analyzer_1_array_crystal_array_2_target_index;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_2_target_x;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_2_target_y;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_2_target_z;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_2_focus_aw;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_2_focus_ah;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_2_focus_xw;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_2_focus_xh;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_2_focus_r;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_2_p_interact;
char mccchannel_2_analyzer_1_array_crystal_array_2_mask_string[16384];
char mccchannel_2_analyzer_1_array_crystal_array_2_mask_setting[16384];
MCNUM mccchannel_2_analyzer_1_array_crystal_array_2_number_of_activations;

/* Setting parameters for component 'channel_2_analyzer_1_array_crystal_array_3' [209]. */
char mccchannel_2_analyzer_1_array_crystal_array_3_material_string[16384];
MCNUM mccchannel_2_analyzer_1_array_crystal_array_3_priority;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_3_xwidth;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_3_yheight;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_3_zdepth;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_3_xwidth2;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_3_yheight2;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_3_visualize;
int mccchannel_2_analyzer_1_array_crystal_array_3_target_index;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_3_target_x;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_3_target_y;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_3_target_z;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_3_focus_aw;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_3_focus_ah;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_3_focus_xw;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_3_focus_xh;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_3_focus_r;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_3_p_interact;
char mccchannel_2_analyzer_1_array_crystal_array_3_mask_string[16384];
char mccchannel_2_analyzer_1_array_crystal_array_3_mask_setting[16384];
MCNUM mccchannel_2_analyzer_1_array_crystal_array_3_number_of_activations;

/* Setting parameters for component 'channel_2_analyzer_1_array_crystal_array_4' [210]. */
char mccchannel_2_analyzer_1_array_crystal_array_4_material_string[16384];
MCNUM mccchannel_2_analyzer_1_array_crystal_array_4_priority;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_4_xwidth;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_4_yheight;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_4_zdepth;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_4_xwidth2;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_4_yheight2;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_4_visualize;
int mccchannel_2_analyzer_1_array_crystal_array_4_target_index;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_4_target_x;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_4_target_y;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_4_target_z;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_4_focus_aw;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_4_focus_ah;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_4_focus_xw;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_4_focus_xh;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_4_focus_r;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_4_p_interact;
char mccchannel_2_analyzer_1_array_crystal_array_4_mask_string[16384];
char mccchannel_2_analyzer_1_array_crystal_array_4_mask_setting[16384];
MCNUM mccchannel_2_analyzer_1_array_crystal_array_4_number_of_activations;

/* Setting parameters for component 'channel_2_analyzer_1_array_crystal_array_5' [211]. */
char mccchannel_2_analyzer_1_array_crystal_array_5_material_string[16384];
MCNUM mccchannel_2_analyzer_1_array_crystal_array_5_priority;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_5_xwidth;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_5_yheight;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_5_zdepth;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_5_xwidth2;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_5_yheight2;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_5_visualize;
int mccchannel_2_analyzer_1_array_crystal_array_5_target_index;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_5_target_x;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_5_target_y;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_5_target_z;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_5_focus_aw;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_5_focus_ah;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_5_focus_xw;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_5_focus_xh;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_5_focus_r;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_5_p_interact;
char mccchannel_2_analyzer_1_array_crystal_array_5_mask_string[16384];
char mccchannel_2_analyzer_1_array_crystal_array_5_mask_setting[16384];
MCNUM mccchannel_2_analyzer_1_array_crystal_array_5_number_of_activations;

/* Setting parameters for component 'channel_2_analyzer_1_array_crystal_array_6' [212]. */
char mccchannel_2_analyzer_1_array_crystal_array_6_material_string[16384];
MCNUM mccchannel_2_analyzer_1_array_crystal_array_6_priority;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_6_xwidth;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_6_yheight;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_6_zdepth;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_6_xwidth2;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_6_yheight2;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_6_visualize;
int mccchannel_2_analyzer_1_array_crystal_array_6_target_index;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_6_target_x;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_6_target_y;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_6_target_z;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_6_focus_aw;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_6_focus_ah;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_6_focus_xw;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_6_focus_xh;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_6_focus_r;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_6_p_interact;
char mccchannel_2_analyzer_1_array_crystal_array_6_mask_string[16384];
char mccchannel_2_analyzer_1_array_crystal_array_6_mask_setting[16384];
MCNUM mccchannel_2_analyzer_1_array_crystal_array_6_number_of_activations;

/* Setting parameters for component 'channel_2_analyzer_1_array_crystal_array_7' [213]. */
char mccchannel_2_analyzer_1_array_crystal_array_7_material_string[16384];
MCNUM mccchannel_2_analyzer_1_array_crystal_array_7_priority;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_7_xwidth;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_7_yheight;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_7_zdepth;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_7_xwidth2;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_7_yheight2;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_7_visualize;
int mccchannel_2_analyzer_1_array_crystal_array_7_target_index;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_7_target_x;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_7_target_y;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_7_target_z;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_7_focus_aw;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_7_focus_ah;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_7_focus_xw;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_7_focus_xh;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_7_focus_r;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_7_p_interact;
char mccchannel_2_analyzer_1_array_crystal_array_7_mask_string[16384];
char mccchannel_2_analyzer_1_array_crystal_array_7_mask_setting[16384];
MCNUM mccchannel_2_analyzer_1_array_crystal_array_7_number_of_activations;

/* Setting parameters for component 'channel_2_analyzer_1_array_crystal_array_8' [214]. */
char mccchannel_2_analyzer_1_array_crystal_array_8_material_string[16384];
MCNUM mccchannel_2_analyzer_1_array_crystal_array_8_priority;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_8_xwidth;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_8_yheight;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_8_zdepth;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_8_xwidth2;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_8_yheight2;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_8_visualize;
int mccchannel_2_analyzer_1_array_crystal_array_8_target_index;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_8_target_x;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_8_target_y;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_8_target_z;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_8_focus_aw;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_8_focus_ah;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_8_focus_xw;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_8_focus_xh;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_8_focus_r;
MCNUM mccchannel_2_analyzer_1_array_crystal_array_8_p_interact;
char mccchannel_2_analyzer_1_array_crystal_array_8_mask_string[16384];
char mccchannel_2_analyzer_1_array_crystal_array_8_mask_setting[16384];
MCNUM mccchannel_2_analyzer_1_array_crystal_array_8_number_of_activations;

/* Setting parameters for component 'channel_2_analyzer_2_array_crystal_array_0' [217]. */
char mccchannel_2_analyzer_2_array_crystal_array_0_material_string[16384];
MCNUM mccchannel_2_analyzer_2_array_crystal_array_0_priority;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_0_xwidth;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_0_yheight;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_0_zdepth;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_0_xwidth2;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_0_yheight2;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_0_visualize;
int mccchannel_2_analyzer_2_array_crystal_array_0_target_index;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_0_target_x;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_0_target_y;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_0_target_z;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_0_focus_aw;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_0_focus_ah;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_0_focus_xw;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_0_focus_xh;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_0_focus_r;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_0_p_interact;
char mccchannel_2_analyzer_2_array_crystal_array_0_mask_string[16384];
char mccchannel_2_analyzer_2_array_crystal_array_0_mask_setting[16384];
MCNUM mccchannel_2_analyzer_2_array_crystal_array_0_number_of_activations;

/* Setting parameters for component 'channel_2_analyzer_2_array_crystal_array_1' [218]. */
char mccchannel_2_analyzer_2_array_crystal_array_1_material_string[16384];
MCNUM mccchannel_2_analyzer_2_array_crystal_array_1_priority;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_1_xwidth;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_1_yheight;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_1_zdepth;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_1_xwidth2;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_1_yheight2;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_1_visualize;
int mccchannel_2_analyzer_2_array_crystal_array_1_target_index;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_1_target_x;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_1_target_y;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_1_target_z;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_1_focus_aw;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_1_focus_ah;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_1_focus_xw;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_1_focus_xh;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_1_focus_r;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_1_p_interact;
char mccchannel_2_analyzer_2_array_crystal_array_1_mask_string[16384];
char mccchannel_2_analyzer_2_array_crystal_array_1_mask_setting[16384];
MCNUM mccchannel_2_analyzer_2_array_crystal_array_1_number_of_activations;

/* Setting parameters for component 'channel_2_analyzer_2_array_crystal_array_2' [219]. */
char mccchannel_2_analyzer_2_array_crystal_array_2_material_string[16384];
MCNUM mccchannel_2_analyzer_2_array_crystal_array_2_priority;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_2_xwidth;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_2_yheight;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_2_zdepth;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_2_xwidth2;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_2_yheight2;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_2_visualize;
int mccchannel_2_analyzer_2_array_crystal_array_2_target_index;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_2_target_x;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_2_target_y;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_2_target_z;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_2_focus_aw;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_2_focus_ah;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_2_focus_xw;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_2_focus_xh;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_2_focus_r;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_2_p_interact;
char mccchannel_2_analyzer_2_array_crystal_array_2_mask_string[16384];
char mccchannel_2_analyzer_2_array_crystal_array_2_mask_setting[16384];
MCNUM mccchannel_2_analyzer_2_array_crystal_array_2_number_of_activations;

/* Setting parameters for component 'channel_2_analyzer_2_array_crystal_array_3' [220]. */
char mccchannel_2_analyzer_2_array_crystal_array_3_material_string[16384];
MCNUM mccchannel_2_analyzer_2_array_crystal_array_3_priority;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_3_xwidth;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_3_yheight;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_3_zdepth;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_3_xwidth2;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_3_yheight2;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_3_visualize;
int mccchannel_2_analyzer_2_array_crystal_array_3_target_index;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_3_target_x;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_3_target_y;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_3_target_z;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_3_focus_aw;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_3_focus_ah;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_3_focus_xw;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_3_focus_xh;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_3_focus_r;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_3_p_interact;
char mccchannel_2_analyzer_2_array_crystal_array_3_mask_string[16384];
char mccchannel_2_analyzer_2_array_crystal_array_3_mask_setting[16384];
MCNUM mccchannel_2_analyzer_2_array_crystal_array_3_number_of_activations;

/* Setting parameters for component 'channel_2_analyzer_2_array_crystal_array_4' [221]. */
char mccchannel_2_analyzer_2_array_crystal_array_4_material_string[16384];
MCNUM mccchannel_2_analyzer_2_array_crystal_array_4_priority;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_4_xwidth;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_4_yheight;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_4_zdepth;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_4_xwidth2;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_4_yheight2;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_4_visualize;
int mccchannel_2_analyzer_2_array_crystal_array_4_target_index;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_4_target_x;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_4_target_y;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_4_target_z;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_4_focus_aw;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_4_focus_ah;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_4_focus_xw;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_4_focus_xh;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_4_focus_r;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_4_p_interact;
char mccchannel_2_analyzer_2_array_crystal_array_4_mask_string[16384];
char mccchannel_2_analyzer_2_array_crystal_array_4_mask_setting[16384];
MCNUM mccchannel_2_analyzer_2_array_crystal_array_4_number_of_activations;

/* Setting parameters for component 'channel_2_analyzer_2_array_crystal_array_5' [222]. */
char mccchannel_2_analyzer_2_array_crystal_array_5_material_string[16384];
MCNUM mccchannel_2_analyzer_2_array_crystal_array_5_priority;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_5_xwidth;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_5_yheight;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_5_zdepth;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_5_xwidth2;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_5_yheight2;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_5_visualize;
int mccchannel_2_analyzer_2_array_crystal_array_5_target_index;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_5_target_x;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_5_target_y;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_5_target_z;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_5_focus_aw;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_5_focus_ah;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_5_focus_xw;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_5_focus_xh;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_5_focus_r;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_5_p_interact;
char mccchannel_2_analyzer_2_array_crystal_array_5_mask_string[16384];
char mccchannel_2_analyzer_2_array_crystal_array_5_mask_setting[16384];
MCNUM mccchannel_2_analyzer_2_array_crystal_array_5_number_of_activations;

/* Setting parameters for component 'channel_2_analyzer_2_array_crystal_array_6' [223]. */
char mccchannel_2_analyzer_2_array_crystal_array_6_material_string[16384];
MCNUM mccchannel_2_analyzer_2_array_crystal_array_6_priority;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_6_xwidth;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_6_yheight;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_6_zdepth;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_6_xwidth2;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_6_yheight2;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_6_visualize;
int mccchannel_2_analyzer_2_array_crystal_array_6_target_index;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_6_target_x;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_6_target_y;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_6_target_z;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_6_focus_aw;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_6_focus_ah;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_6_focus_xw;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_6_focus_xh;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_6_focus_r;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_6_p_interact;
char mccchannel_2_analyzer_2_array_crystal_array_6_mask_string[16384];
char mccchannel_2_analyzer_2_array_crystal_array_6_mask_setting[16384];
MCNUM mccchannel_2_analyzer_2_array_crystal_array_6_number_of_activations;

/* Setting parameters for component 'channel_2_analyzer_2_array_crystal_array_7' [224]. */
char mccchannel_2_analyzer_2_array_crystal_array_7_material_string[16384];
MCNUM mccchannel_2_analyzer_2_array_crystal_array_7_priority;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_7_xwidth;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_7_yheight;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_7_zdepth;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_7_xwidth2;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_7_yheight2;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_7_visualize;
int mccchannel_2_analyzer_2_array_crystal_array_7_target_index;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_7_target_x;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_7_target_y;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_7_target_z;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_7_focus_aw;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_7_focus_ah;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_7_focus_xw;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_7_focus_xh;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_7_focus_r;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_7_p_interact;
char mccchannel_2_analyzer_2_array_crystal_array_7_mask_string[16384];
char mccchannel_2_analyzer_2_array_crystal_array_7_mask_setting[16384];
MCNUM mccchannel_2_analyzer_2_array_crystal_array_7_number_of_activations;

/* Setting parameters for component 'channel_2_analyzer_2_array_crystal_array_8' [225]. */
char mccchannel_2_analyzer_2_array_crystal_array_8_material_string[16384];
MCNUM mccchannel_2_analyzer_2_array_crystal_array_8_priority;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_8_xwidth;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_8_yheight;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_8_zdepth;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_8_xwidth2;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_8_yheight2;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_8_visualize;
int mccchannel_2_analyzer_2_array_crystal_array_8_target_index;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_8_target_x;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_8_target_y;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_8_target_z;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_8_focus_aw;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_8_focus_ah;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_8_focus_xw;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_8_focus_xh;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_8_focus_r;
MCNUM mccchannel_2_analyzer_2_array_crystal_array_8_p_interact;
char mccchannel_2_analyzer_2_array_crystal_array_8_mask_string[16384];
char mccchannel_2_analyzer_2_array_crystal_array_8_mask_setting[16384];
MCNUM mccchannel_2_analyzer_2_array_crystal_array_8_number_of_activations;

/* Setting parameters for component 'channel_2_cave2_cyl1' [226]. */
char mccchannel_2_cave2_cyl1_material_string[16384];
MCNUM mccchannel_2_cave2_cyl1_priority;
MCNUM mccchannel_2_cave2_cyl1_radius;
MCNUM mccchannel_2_cave2_cyl1_yheight;
MCNUM mccchannel_2_cave2_cyl1_visualize;
int mccchannel_2_cave2_cyl1_target_index;
MCNUM mccchannel_2_cave2_cyl1_target_x;
MCNUM mccchannel_2_cave2_cyl1_target_y;
MCNUM mccchannel_2_cave2_cyl1_target_z;
MCNUM mccchannel_2_cave2_cyl1_focus_aw;
MCNUM mccchannel_2_cave2_cyl1_focus_ah;
MCNUM mccchannel_2_cave2_cyl1_focus_xw;
MCNUM mccchannel_2_cave2_cyl1_focus_xh;
MCNUM mccchannel_2_cave2_cyl1_focus_r;
MCNUM mccchannel_2_cave2_cyl1_p_interact;
char mccchannel_2_cave2_cyl1_mask_string[16384];
char mccchannel_2_cave2_cyl1_mask_setting[16384];
MCNUM mccchannel_2_cave2_cyl1_number_of_activations;

/* Setting parameters for component 'channel_2_cave2_box1' [227]. */
char mccchannel_2_cave2_box1_material_string[16384];
MCNUM mccchannel_2_cave2_box1_priority;
MCNUM mccchannel_2_cave2_box1_xwidth;
MCNUM mccchannel_2_cave2_box1_yheight;
MCNUM mccchannel_2_cave2_box1_zdepth;
MCNUM mccchannel_2_cave2_box1_xwidth2;
MCNUM mccchannel_2_cave2_box1_yheight2;
MCNUM mccchannel_2_cave2_box1_visualize;
int mccchannel_2_cave2_box1_target_index;
MCNUM mccchannel_2_cave2_box1_target_x;
MCNUM mccchannel_2_cave2_box1_target_y;
MCNUM mccchannel_2_cave2_box1_target_z;
MCNUM mccchannel_2_cave2_box1_focus_aw;
MCNUM mccchannel_2_cave2_box1_focus_ah;
MCNUM mccchannel_2_cave2_box1_focus_xw;
MCNUM mccchannel_2_cave2_box1_focus_xh;
MCNUM mccchannel_2_cave2_box1_focus_r;
MCNUM mccchannel_2_cave2_box1_p_interact;
char mccchannel_2_cave2_box1_mask_string[16384];
char mccchannel_2_cave2_box1_mask_setting[16384];
MCNUM mccchannel_2_cave2_box1_number_of_activations;

/* Setting parameters for component 'channel_2_cave2_box2' [228]. */
char mccchannel_2_cave2_box2_material_string[16384];
MCNUM mccchannel_2_cave2_box2_priority;
MCNUM mccchannel_2_cave2_box2_xwidth;
MCNUM mccchannel_2_cave2_box2_yheight;
MCNUM mccchannel_2_cave2_box2_zdepth;
MCNUM mccchannel_2_cave2_box2_xwidth2;
MCNUM mccchannel_2_cave2_box2_yheight2;
MCNUM mccchannel_2_cave2_box2_visualize;
int mccchannel_2_cave2_box2_target_index;
MCNUM mccchannel_2_cave2_box2_target_x;
MCNUM mccchannel_2_cave2_box2_target_y;
MCNUM mccchannel_2_cave2_box2_target_z;
MCNUM mccchannel_2_cave2_box2_focus_aw;
MCNUM mccchannel_2_cave2_box2_focus_ah;
MCNUM mccchannel_2_cave2_box2_focus_xw;
MCNUM mccchannel_2_cave2_box2_focus_xh;
MCNUM mccchannel_2_cave2_box2_focus_r;
MCNUM mccchannel_2_cave2_box2_p_interact;
char mccchannel_2_cave2_box2_mask_string[16384];
char mccchannel_2_cave2_box2_mask_setting[16384];
MCNUM mccchannel_2_cave2_box2_number_of_activations;

/* Setting parameters for component 'channel_2_cave2_box3' [229]. */
char mccchannel_2_cave2_box3_material_string[16384];
MCNUM mccchannel_2_cave2_box3_priority;
MCNUM mccchannel_2_cave2_box3_xwidth;
MCNUM mccchannel_2_cave2_box3_yheight;
MCNUM mccchannel_2_cave2_box3_zdepth;
MCNUM mccchannel_2_cave2_box3_xwidth2;
MCNUM mccchannel_2_cave2_box3_yheight2;
MCNUM mccchannel_2_cave2_box3_visualize;
int mccchannel_2_cave2_box3_target_index;
MCNUM mccchannel_2_cave2_box3_target_x;
MCNUM mccchannel_2_cave2_box3_target_y;
MCNUM mccchannel_2_cave2_box3_target_z;
MCNUM mccchannel_2_cave2_box3_focus_aw;
MCNUM mccchannel_2_cave2_box3_focus_ah;
MCNUM mccchannel_2_cave2_box3_focus_xw;
MCNUM mccchannel_2_cave2_box3_focus_xh;
MCNUM mccchannel_2_cave2_box3_focus_r;
MCNUM mccchannel_2_cave2_box3_p_interact;
char mccchannel_2_cave2_box3_mask_string[16384];
char mccchannel_2_cave2_box3_mask_setting[16384];
MCNUM mccchannel_2_cave2_box3_number_of_activations;

/* Setting parameters for component 'inter_analyzer_colimator_2_blade_0' [231]. */
char mccinter_analyzer_colimator_2_blade_0_material_string[16384];
MCNUM mccinter_analyzer_colimator_2_blade_0_priority;
MCNUM mccinter_analyzer_colimator_2_blade_0_xwidth;
MCNUM mccinter_analyzer_colimator_2_blade_0_yheight;
MCNUM mccinter_analyzer_colimator_2_blade_0_zdepth;
MCNUM mccinter_analyzer_colimator_2_blade_0_xwidth2;
MCNUM mccinter_analyzer_colimator_2_blade_0_yheight2;
MCNUM mccinter_analyzer_colimator_2_blade_0_visualize;
int mccinter_analyzer_colimator_2_blade_0_target_index;
MCNUM mccinter_analyzer_colimator_2_blade_0_target_x;
MCNUM mccinter_analyzer_colimator_2_blade_0_target_y;
MCNUM mccinter_analyzer_colimator_2_blade_0_target_z;
MCNUM mccinter_analyzer_colimator_2_blade_0_focus_aw;
MCNUM mccinter_analyzer_colimator_2_blade_0_focus_ah;
MCNUM mccinter_analyzer_colimator_2_blade_0_focus_xw;
MCNUM mccinter_analyzer_colimator_2_blade_0_focus_xh;
MCNUM mccinter_analyzer_colimator_2_blade_0_focus_r;
MCNUM mccinter_analyzer_colimator_2_blade_0_p_interact;
char mccinter_analyzer_colimator_2_blade_0_mask_string[16384];
char mccinter_analyzer_colimator_2_blade_0_mask_setting[16384];
MCNUM mccinter_analyzer_colimator_2_blade_0_number_of_activations;

/* Setting parameters for component 'inter_analyzer_colimator_2_blade_1' [232]. */
char mccinter_analyzer_colimator_2_blade_1_material_string[16384];
MCNUM mccinter_analyzer_colimator_2_blade_1_priority;
MCNUM mccinter_analyzer_colimator_2_blade_1_xwidth;
MCNUM mccinter_analyzer_colimator_2_blade_1_yheight;
MCNUM mccinter_analyzer_colimator_2_blade_1_zdepth;
MCNUM mccinter_analyzer_colimator_2_blade_1_xwidth2;
MCNUM mccinter_analyzer_colimator_2_blade_1_yheight2;
MCNUM mccinter_analyzer_colimator_2_blade_1_visualize;
int mccinter_analyzer_colimator_2_blade_1_target_index;
MCNUM mccinter_analyzer_colimator_2_blade_1_target_x;
MCNUM mccinter_analyzer_colimator_2_blade_1_target_y;
MCNUM mccinter_analyzer_colimator_2_blade_1_target_z;
MCNUM mccinter_analyzer_colimator_2_blade_1_focus_aw;
MCNUM mccinter_analyzer_colimator_2_blade_1_focus_ah;
MCNUM mccinter_analyzer_colimator_2_blade_1_focus_xw;
MCNUM mccinter_analyzer_colimator_2_blade_1_focus_xh;
MCNUM mccinter_analyzer_colimator_2_blade_1_focus_r;
MCNUM mccinter_analyzer_colimator_2_blade_1_p_interact;
char mccinter_analyzer_colimator_2_blade_1_mask_string[16384];
char mccinter_analyzer_colimator_2_blade_1_mask_setting[16384];
MCNUM mccinter_analyzer_colimator_2_blade_1_number_of_activations;

/* Setting parameters for component 'inter_analyzer_colimator_2_blade_2' [233]. */
char mccinter_analyzer_colimator_2_blade_2_material_string[16384];
MCNUM mccinter_analyzer_colimator_2_blade_2_priority;
MCNUM mccinter_analyzer_colimator_2_blade_2_xwidth;
MCNUM mccinter_analyzer_colimator_2_blade_2_yheight;
MCNUM mccinter_analyzer_colimator_2_blade_2_zdepth;
MCNUM mccinter_analyzer_colimator_2_blade_2_xwidth2;
MCNUM mccinter_analyzer_colimator_2_blade_2_yheight2;
MCNUM mccinter_analyzer_colimator_2_blade_2_visualize;
int mccinter_analyzer_colimator_2_blade_2_target_index;
MCNUM mccinter_analyzer_colimator_2_blade_2_target_x;
MCNUM mccinter_analyzer_colimator_2_blade_2_target_y;
MCNUM mccinter_analyzer_colimator_2_blade_2_target_z;
MCNUM mccinter_analyzer_colimator_2_blade_2_focus_aw;
MCNUM mccinter_analyzer_colimator_2_blade_2_focus_ah;
MCNUM mccinter_analyzer_colimator_2_blade_2_focus_xw;
MCNUM mccinter_analyzer_colimator_2_blade_2_focus_xh;
MCNUM mccinter_analyzer_colimator_2_blade_2_focus_r;
MCNUM mccinter_analyzer_colimator_2_blade_2_p_interact;
char mccinter_analyzer_colimator_2_blade_2_mask_string[16384];
char mccinter_analyzer_colimator_2_blade_2_mask_setting[16384];
MCNUM mccinter_analyzer_colimator_2_blade_2_number_of_activations;

/* Setting parameters for component 'inter_analyzer_colimator_2_blade_3' [234]. */
char mccinter_analyzer_colimator_2_blade_3_material_string[16384];
MCNUM mccinter_analyzer_colimator_2_blade_3_priority;
MCNUM mccinter_analyzer_colimator_2_blade_3_xwidth;
MCNUM mccinter_analyzer_colimator_2_blade_3_yheight;
MCNUM mccinter_analyzer_colimator_2_blade_3_zdepth;
MCNUM mccinter_analyzer_colimator_2_blade_3_xwidth2;
MCNUM mccinter_analyzer_colimator_2_blade_3_yheight2;
MCNUM mccinter_analyzer_colimator_2_blade_3_visualize;
int mccinter_analyzer_colimator_2_blade_3_target_index;
MCNUM mccinter_analyzer_colimator_2_blade_3_target_x;
MCNUM mccinter_analyzer_colimator_2_blade_3_target_y;
MCNUM mccinter_analyzer_colimator_2_blade_3_target_z;
MCNUM mccinter_analyzer_colimator_2_blade_3_focus_aw;
MCNUM mccinter_analyzer_colimator_2_blade_3_focus_ah;
MCNUM mccinter_analyzer_colimator_2_blade_3_focus_xw;
MCNUM mccinter_analyzer_colimator_2_blade_3_focus_xh;
MCNUM mccinter_analyzer_colimator_2_blade_3_focus_r;
MCNUM mccinter_analyzer_colimator_2_blade_3_p_interact;
char mccinter_analyzer_colimator_2_blade_3_mask_string[16384];
char mccinter_analyzer_colimator_2_blade_3_mask_setting[16384];
MCNUM mccinter_analyzer_colimator_2_blade_3_number_of_activations;

/* Setting parameters for component 'inter_analyzer_colimator_2_blade_4' [235]. */
char mccinter_analyzer_colimator_2_blade_4_material_string[16384];
MCNUM mccinter_analyzer_colimator_2_blade_4_priority;
MCNUM mccinter_analyzer_colimator_2_blade_4_xwidth;
MCNUM mccinter_analyzer_colimator_2_blade_4_yheight;
MCNUM mccinter_analyzer_colimator_2_blade_4_zdepth;
MCNUM mccinter_analyzer_colimator_2_blade_4_xwidth2;
MCNUM mccinter_analyzer_colimator_2_blade_4_yheight2;
MCNUM mccinter_analyzer_colimator_2_blade_4_visualize;
int mccinter_analyzer_colimator_2_blade_4_target_index;
MCNUM mccinter_analyzer_colimator_2_blade_4_target_x;
MCNUM mccinter_analyzer_colimator_2_blade_4_target_y;
MCNUM mccinter_analyzer_colimator_2_blade_4_target_z;
MCNUM mccinter_analyzer_colimator_2_blade_4_focus_aw;
MCNUM mccinter_analyzer_colimator_2_blade_4_focus_ah;
MCNUM mccinter_analyzer_colimator_2_blade_4_focus_xw;
MCNUM mccinter_analyzer_colimator_2_blade_4_focus_xh;
MCNUM mccinter_analyzer_colimator_2_blade_4_focus_r;
MCNUM mccinter_analyzer_colimator_2_blade_4_p_interact;
char mccinter_analyzer_colimator_2_blade_4_mask_string[16384];
char mccinter_analyzer_colimator_2_blade_4_mask_setting[16384];
MCNUM mccinter_analyzer_colimator_2_blade_4_number_of_activations;

/* Setting parameters for component 'diffraction_detector_2_exit_volume' [236]. */
char mccdiffraction_detector_2_exit_volume_material_string[16384];
MCNUM mccdiffraction_detector_2_exit_volume_priority;
MCNUM mccdiffraction_detector_2_exit_volume_xwidth;
MCNUM mccdiffraction_detector_2_exit_volume_yheight;
MCNUM mccdiffraction_detector_2_exit_volume_zdepth;
MCNUM mccdiffraction_detector_2_exit_volume_xwidth2;
MCNUM mccdiffraction_detector_2_exit_volume_yheight2;
MCNUM mccdiffraction_detector_2_exit_volume_visualize;
int mccdiffraction_detector_2_exit_volume_target_index;
MCNUM mccdiffraction_detector_2_exit_volume_target_x;
MCNUM mccdiffraction_detector_2_exit_volume_target_y;
MCNUM mccdiffraction_detector_2_exit_volume_target_z;
MCNUM mccdiffraction_detector_2_exit_volume_focus_aw;
MCNUM mccdiffraction_detector_2_exit_volume_focus_ah;
MCNUM mccdiffraction_detector_2_exit_volume_focus_xw;
MCNUM mccdiffraction_detector_2_exit_volume_focus_xh;
MCNUM mccdiffraction_detector_2_exit_volume_focus_r;
MCNUM mccdiffraction_detector_2_exit_volume_p_interact;
char mccdiffraction_detector_2_exit_volume_mask_string[16384];
char mccdiffraction_detector_2_exit_volume_mask_setting[16384];
MCNUM mccdiffraction_detector_2_exit_volume_number_of_activations;

/* Setting parameters for component 'spec_detector_2_exit_volume' [237]. */
char mccspec_detector_2_exit_volume_material_string[16384];
MCNUM mccspec_detector_2_exit_volume_priority;
MCNUM mccspec_detector_2_exit_volume_xwidth;
MCNUM mccspec_detector_2_exit_volume_yheight;
MCNUM mccspec_detector_2_exit_volume_zdepth;
MCNUM mccspec_detector_2_exit_volume_xwidth2;
MCNUM mccspec_detector_2_exit_volume_yheight2;
MCNUM mccspec_detector_2_exit_volume_visualize;
int mccspec_detector_2_exit_volume_target_index;
MCNUM mccspec_detector_2_exit_volume_target_x;
MCNUM mccspec_detector_2_exit_volume_target_y;
MCNUM mccspec_detector_2_exit_volume_target_z;
MCNUM mccspec_detector_2_exit_volume_focus_aw;
MCNUM mccspec_detector_2_exit_volume_focus_ah;
MCNUM mccspec_detector_2_exit_volume_focus_xw;
MCNUM mccspec_detector_2_exit_volume_focus_xh;
MCNUM mccspec_detector_2_exit_volume_focus_r;
MCNUM mccspec_detector_2_exit_volume_p_interact;
char mccspec_detector_2_exit_volume_mask_string[16384];
char mccspec_detector_2_exit_volume_mask_setting[16384];
MCNUM mccspec_detector_2_exit_volume_number_of_activations;

/* Setting parameters for component 'channel_3_cave1_box1' [238]. */
char mccchannel_3_cave1_box1_material_string[16384];
MCNUM mccchannel_3_cave1_box1_priority;
MCNUM mccchannel_3_cave1_box1_xwidth;
MCNUM mccchannel_3_cave1_box1_yheight;
MCNUM mccchannel_3_cave1_box1_zdepth;
MCNUM mccchannel_3_cave1_box1_xwidth2;
MCNUM mccchannel_3_cave1_box1_yheight2;
MCNUM mccchannel_3_cave1_box1_visualize;
int mccchannel_3_cave1_box1_target_index;
MCNUM mccchannel_3_cave1_box1_target_x;
MCNUM mccchannel_3_cave1_box1_target_y;
MCNUM mccchannel_3_cave1_box1_target_z;
MCNUM mccchannel_3_cave1_box1_focus_aw;
MCNUM mccchannel_3_cave1_box1_focus_ah;
MCNUM mccchannel_3_cave1_box1_focus_xw;
MCNUM mccchannel_3_cave1_box1_focus_xh;
MCNUM mccchannel_3_cave1_box1_focus_r;
MCNUM mccchannel_3_cave1_box1_p_interact;
char mccchannel_3_cave1_box1_mask_string[16384];
char mccchannel_3_cave1_box1_mask_setting[16384];
MCNUM mccchannel_3_cave1_box1_number_of_activations;

/* Setting parameters for component 'channel_3_cave1_box2' [239]. */
char mccchannel_3_cave1_box2_material_string[16384];
MCNUM mccchannel_3_cave1_box2_priority;
MCNUM mccchannel_3_cave1_box2_xwidth;
MCNUM mccchannel_3_cave1_box2_yheight;
MCNUM mccchannel_3_cave1_box2_zdepth;
MCNUM mccchannel_3_cave1_box2_xwidth2;
MCNUM mccchannel_3_cave1_box2_yheight2;
MCNUM mccchannel_3_cave1_box2_visualize;
int mccchannel_3_cave1_box2_target_index;
MCNUM mccchannel_3_cave1_box2_target_x;
MCNUM mccchannel_3_cave1_box2_target_y;
MCNUM mccchannel_3_cave1_box2_target_z;
MCNUM mccchannel_3_cave1_box2_focus_aw;
MCNUM mccchannel_3_cave1_box2_focus_ah;
MCNUM mccchannel_3_cave1_box2_focus_xw;
MCNUM mccchannel_3_cave1_box2_focus_xh;
MCNUM mccchannel_3_cave1_box2_focus_r;
MCNUM mccchannel_3_cave1_box2_p_interact;
char mccchannel_3_cave1_box2_mask_string[16384];
char mccchannel_3_cave1_box2_mask_setting[16384];
MCNUM mccchannel_3_cave1_box2_number_of_activations;

/* Setting parameters for component 'channel_3_cave1_box3' [240]. */
char mccchannel_3_cave1_box3_material_string[16384];
MCNUM mccchannel_3_cave1_box3_priority;
MCNUM mccchannel_3_cave1_box3_xwidth;
MCNUM mccchannel_3_cave1_box3_yheight;
MCNUM mccchannel_3_cave1_box3_zdepth;
MCNUM mccchannel_3_cave1_box3_xwidth2;
MCNUM mccchannel_3_cave1_box3_yheight2;
MCNUM mccchannel_3_cave1_box3_visualize;
int mccchannel_3_cave1_box3_target_index;
MCNUM mccchannel_3_cave1_box3_target_x;
MCNUM mccchannel_3_cave1_box3_target_y;
MCNUM mccchannel_3_cave1_box3_target_z;
MCNUM mccchannel_3_cave1_box3_focus_aw;
MCNUM mccchannel_3_cave1_box3_focus_ah;
MCNUM mccchannel_3_cave1_box3_focus_xw;
MCNUM mccchannel_3_cave1_box3_focus_xh;
MCNUM mccchannel_3_cave1_box3_focus_r;
MCNUM mccchannel_3_cave1_box3_p_interact;
char mccchannel_3_cave1_box3_mask_string[16384];
char mccchannel_3_cave1_box3_mask_setting[16384];
MCNUM mccchannel_3_cave1_box3_number_of_activations;

/* Setting parameters for component 'channel_3_cave1_cyl1' [241]. */
char mccchannel_3_cave1_cyl1_material_string[16384];
MCNUM mccchannel_3_cave1_cyl1_priority;
MCNUM mccchannel_3_cave1_cyl1_radius;
MCNUM mccchannel_3_cave1_cyl1_yheight;
MCNUM mccchannel_3_cave1_cyl1_visualize;
int mccchannel_3_cave1_cyl1_target_index;
MCNUM mccchannel_3_cave1_cyl1_target_x;
MCNUM mccchannel_3_cave1_cyl1_target_y;
MCNUM mccchannel_3_cave1_cyl1_target_z;
MCNUM mccchannel_3_cave1_cyl1_focus_aw;
MCNUM mccchannel_3_cave1_cyl1_focus_ah;
MCNUM mccchannel_3_cave1_cyl1_focus_xw;
MCNUM mccchannel_3_cave1_cyl1_focus_xh;
MCNUM mccchannel_3_cave1_cyl1_focus_r;
MCNUM mccchannel_3_cave1_cyl1_p_interact;
char mccchannel_3_cave1_cyl1_mask_string[16384];
char mccchannel_3_cave1_cyl1_mask_setting[16384];
MCNUM mccchannel_3_cave1_cyl1_number_of_activations;

/* Setting parameters for component 'channel_3_analyzer_1_array_crystal_array_0' [244]. */
char mccchannel_3_analyzer_1_array_crystal_array_0_material_string[16384];
MCNUM mccchannel_3_analyzer_1_array_crystal_array_0_priority;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_0_xwidth;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_0_yheight;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_0_zdepth;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_0_xwidth2;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_0_yheight2;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_0_visualize;
int mccchannel_3_analyzer_1_array_crystal_array_0_target_index;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_0_target_x;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_0_target_y;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_0_target_z;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_0_focus_aw;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_0_focus_ah;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_0_focus_xw;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_0_focus_xh;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_0_focus_r;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_0_p_interact;
char mccchannel_3_analyzer_1_array_crystal_array_0_mask_string[16384];
char mccchannel_3_analyzer_1_array_crystal_array_0_mask_setting[16384];
MCNUM mccchannel_3_analyzer_1_array_crystal_array_0_number_of_activations;

/* Setting parameters for component 'channel_3_analyzer_1_array_crystal_array_1' [245]. */
char mccchannel_3_analyzer_1_array_crystal_array_1_material_string[16384];
MCNUM mccchannel_3_analyzer_1_array_crystal_array_1_priority;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_1_xwidth;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_1_yheight;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_1_zdepth;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_1_xwidth2;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_1_yheight2;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_1_visualize;
int mccchannel_3_analyzer_1_array_crystal_array_1_target_index;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_1_target_x;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_1_target_y;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_1_target_z;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_1_focus_aw;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_1_focus_ah;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_1_focus_xw;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_1_focus_xh;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_1_focus_r;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_1_p_interact;
char mccchannel_3_analyzer_1_array_crystal_array_1_mask_string[16384];
char mccchannel_3_analyzer_1_array_crystal_array_1_mask_setting[16384];
MCNUM mccchannel_3_analyzer_1_array_crystal_array_1_number_of_activations;

/* Setting parameters for component 'channel_3_analyzer_1_array_crystal_array_2' [246]. */
char mccchannel_3_analyzer_1_array_crystal_array_2_material_string[16384];
MCNUM mccchannel_3_analyzer_1_array_crystal_array_2_priority;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_2_xwidth;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_2_yheight;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_2_zdepth;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_2_xwidth2;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_2_yheight2;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_2_visualize;
int mccchannel_3_analyzer_1_array_crystal_array_2_target_index;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_2_target_x;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_2_target_y;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_2_target_z;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_2_focus_aw;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_2_focus_ah;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_2_focus_xw;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_2_focus_xh;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_2_focus_r;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_2_p_interact;
char mccchannel_3_analyzer_1_array_crystal_array_2_mask_string[16384];
char mccchannel_3_analyzer_1_array_crystal_array_2_mask_setting[16384];
MCNUM mccchannel_3_analyzer_1_array_crystal_array_2_number_of_activations;

/* Setting parameters for component 'channel_3_analyzer_1_array_crystal_array_3' [247]. */
char mccchannel_3_analyzer_1_array_crystal_array_3_material_string[16384];
MCNUM mccchannel_3_analyzer_1_array_crystal_array_3_priority;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_3_xwidth;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_3_yheight;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_3_zdepth;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_3_xwidth2;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_3_yheight2;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_3_visualize;
int mccchannel_3_analyzer_1_array_crystal_array_3_target_index;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_3_target_x;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_3_target_y;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_3_target_z;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_3_focus_aw;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_3_focus_ah;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_3_focus_xw;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_3_focus_xh;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_3_focus_r;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_3_p_interact;
char mccchannel_3_analyzer_1_array_crystal_array_3_mask_string[16384];
char mccchannel_3_analyzer_1_array_crystal_array_3_mask_setting[16384];
MCNUM mccchannel_3_analyzer_1_array_crystal_array_3_number_of_activations;

/* Setting parameters for component 'channel_3_analyzer_1_array_crystal_array_4' [248]. */
char mccchannel_3_analyzer_1_array_crystal_array_4_material_string[16384];
MCNUM mccchannel_3_analyzer_1_array_crystal_array_4_priority;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_4_xwidth;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_4_yheight;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_4_zdepth;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_4_xwidth2;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_4_yheight2;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_4_visualize;
int mccchannel_3_analyzer_1_array_crystal_array_4_target_index;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_4_target_x;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_4_target_y;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_4_target_z;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_4_focus_aw;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_4_focus_ah;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_4_focus_xw;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_4_focus_xh;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_4_focus_r;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_4_p_interact;
char mccchannel_3_analyzer_1_array_crystal_array_4_mask_string[16384];
char mccchannel_3_analyzer_1_array_crystal_array_4_mask_setting[16384];
MCNUM mccchannel_3_analyzer_1_array_crystal_array_4_number_of_activations;

/* Setting parameters for component 'channel_3_analyzer_1_array_crystal_array_5' [249]. */
char mccchannel_3_analyzer_1_array_crystal_array_5_material_string[16384];
MCNUM mccchannel_3_analyzer_1_array_crystal_array_5_priority;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_5_xwidth;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_5_yheight;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_5_zdepth;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_5_xwidth2;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_5_yheight2;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_5_visualize;
int mccchannel_3_analyzer_1_array_crystal_array_5_target_index;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_5_target_x;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_5_target_y;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_5_target_z;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_5_focus_aw;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_5_focus_ah;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_5_focus_xw;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_5_focus_xh;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_5_focus_r;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_5_p_interact;
char mccchannel_3_analyzer_1_array_crystal_array_5_mask_string[16384];
char mccchannel_3_analyzer_1_array_crystal_array_5_mask_setting[16384];
MCNUM mccchannel_3_analyzer_1_array_crystal_array_5_number_of_activations;

/* Setting parameters for component 'channel_3_analyzer_1_array_crystal_array_6' [250]. */
char mccchannel_3_analyzer_1_array_crystal_array_6_material_string[16384];
MCNUM mccchannel_3_analyzer_1_array_crystal_array_6_priority;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_6_xwidth;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_6_yheight;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_6_zdepth;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_6_xwidth2;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_6_yheight2;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_6_visualize;
int mccchannel_3_analyzer_1_array_crystal_array_6_target_index;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_6_target_x;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_6_target_y;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_6_target_z;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_6_focus_aw;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_6_focus_ah;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_6_focus_xw;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_6_focus_xh;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_6_focus_r;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_6_p_interact;
char mccchannel_3_analyzer_1_array_crystal_array_6_mask_string[16384];
char mccchannel_3_analyzer_1_array_crystal_array_6_mask_setting[16384];
MCNUM mccchannel_3_analyzer_1_array_crystal_array_6_number_of_activations;

/* Setting parameters for component 'channel_3_analyzer_1_array_crystal_array_7' [251]. */
char mccchannel_3_analyzer_1_array_crystal_array_7_material_string[16384];
MCNUM mccchannel_3_analyzer_1_array_crystal_array_7_priority;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_7_xwidth;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_7_yheight;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_7_zdepth;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_7_xwidth2;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_7_yheight2;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_7_visualize;
int mccchannel_3_analyzer_1_array_crystal_array_7_target_index;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_7_target_x;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_7_target_y;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_7_target_z;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_7_focus_aw;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_7_focus_ah;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_7_focus_xw;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_7_focus_xh;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_7_focus_r;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_7_p_interact;
char mccchannel_3_analyzer_1_array_crystal_array_7_mask_string[16384];
char mccchannel_3_analyzer_1_array_crystal_array_7_mask_setting[16384];
MCNUM mccchannel_3_analyzer_1_array_crystal_array_7_number_of_activations;

/* Setting parameters for component 'channel_3_analyzer_1_array_crystal_array_8' [252]. */
char mccchannel_3_analyzer_1_array_crystal_array_8_material_string[16384];
MCNUM mccchannel_3_analyzer_1_array_crystal_array_8_priority;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_8_xwidth;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_8_yheight;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_8_zdepth;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_8_xwidth2;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_8_yheight2;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_8_visualize;
int mccchannel_3_analyzer_1_array_crystal_array_8_target_index;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_8_target_x;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_8_target_y;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_8_target_z;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_8_focus_aw;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_8_focus_ah;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_8_focus_xw;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_8_focus_xh;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_8_focus_r;
MCNUM mccchannel_3_analyzer_1_array_crystal_array_8_p_interact;
char mccchannel_3_analyzer_1_array_crystal_array_8_mask_string[16384];
char mccchannel_3_analyzer_1_array_crystal_array_8_mask_setting[16384];
MCNUM mccchannel_3_analyzer_1_array_crystal_array_8_number_of_activations;

/* Setting parameters for component 'channel_3_analyzer_2_array_crystal_array_0' [255]. */
char mccchannel_3_analyzer_2_array_crystal_array_0_material_string[16384];
MCNUM mccchannel_3_analyzer_2_array_crystal_array_0_priority;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_0_xwidth;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_0_yheight;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_0_zdepth;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_0_xwidth2;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_0_yheight2;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_0_visualize;
int mccchannel_3_analyzer_2_array_crystal_array_0_target_index;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_0_target_x;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_0_target_y;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_0_target_z;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_0_focus_aw;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_0_focus_ah;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_0_focus_xw;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_0_focus_xh;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_0_focus_r;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_0_p_interact;
char mccchannel_3_analyzer_2_array_crystal_array_0_mask_string[16384];
char mccchannel_3_analyzer_2_array_crystal_array_0_mask_setting[16384];
MCNUM mccchannel_3_analyzer_2_array_crystal_array_0_number_of_activations;

/* Setting parameters for component 'channel_3_analyzer_2_array_crystal_array_1' [256]. */
char mccchannel_3_analyzer_2_array_crystal_array_1_material_string[16384];
MCNUM mccchannel_3_analyzer_2_array_crystal_array_1_priority;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_1_xwidth;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_1_yheight;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_1_zdepth;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_1_xwidth2;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_1_yheight2;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_1_visualize;
int mccchannel_3_analyzer_2_array_crystal_array_1_target_index;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_1_target_x;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_1_target_y;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_1_target_z;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_1_focus_aw;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_1_focus_ah;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_1_focus_xw;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_1_focus_xh;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_1_focus_r;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_1_p_interact;
char mccchannel_3_analyzer_2_array_crystal_array_1_mask_string[16384];
char mccchannel_3_analyzer_2_array_crystal_array_1_mask_setting[16384];
MCNUM mccchannel_3_analyzer_2_array_crystal_array_1_number_of_activations;

/* Setting parameters for component 'channel_3_analyzer_2_array_crystal_array_2' [257]. */
char mccchannel_3_analyzer_2_array_crystal_array_2_material_string[16384];
MCNUM mccchannel_3_analyzer_2_array_crystal_array_2_priority;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_2_xwidth;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_2_yheight;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_2_zdepth;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_2_xwidth2;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_2_yheight2;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_2_visualize;
int mccchannel_3_analyzer_2_array_crystal_array_2_target_index;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_2_target_x;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_2_target_y;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_2_target_z;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_2_focus_aw;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_2_focus_ah;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_2_focus_xw;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_2_focus_xh;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_2_focus_r;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_2_p_interact;
char mccchannel_3_analyzer_2_array_crystal_array_2_mask_string[16384];
char mccchannel_3_analyzer_2_array_crystal_array_2_mask_setting[16384];
MCNUM mccchannel_3_analyzer_2_array_crystal_array_2_number_of_activations;

/* Setting parameters for component 'channel_3_analyzer_2_array_crystal_array_3' [258]. */
char mccchannel_3_analyzer_2_array_crystal_array_3_material_string[16384];
MCNUM mccchannel_3_analyzer_2_array_crystal_array_3_priority;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_3_xwidth;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_3_yheight;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_3_zdepth;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_3_xwidth2;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_3_yheight2;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_3_visualize;
int mccchannel_3_analyzer_2_array_crystal_array_3_target_index;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_3_target_x;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_3_target_y;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_3_target_z;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_3_focus_aw;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_3_focus_ah;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_3_focus_xw;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_3_focus_xh;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_3_focus_r;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_3_p_interact;
char mccchannel_3_analyzer_2_array_crystal_array_3_mask_string[16384];
char mccchannel_3_analyzer_2_array_crystal_array_3_mask_setting[16384];
MCNUM mccchannel_3_analyzer_2_array_crystal_array_3_number_of_activations;

/* Setting parameters for component 'channel_3_analyzer_2_array_crystal_array_4' [259]. */
char mccchannel_3_analyzer_2_array_crystal_array_4_material_string[16384];
MCNUM mccchannel_3_analyzer_2_array_crystal_array_4_priority;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_4_xwidth;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_4_yheight;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_4_zdepth;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_4_xwidth2;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_4_yheight2;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_4_visualize;
int mccchannel_3_analyzer_2_array_crystal_array_4_target_index;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_4_target_x;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_4_target_y;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_4_target_z;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_4_focus_aw;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_4_focus_ah;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_4_focus_xw;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_4_focus_xh;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_4_focus_r;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_4_p_interact;
char mccchannel_3_analyzer_2_array_crystal_array_4_mask_string[16384];
char mccchannel_3_analyzer_2_array_crystal_array_4_mask_setting[16384];
MCNUM mccchannel_3_analyzer_2_array_crystal_array_4_number_of_activations;

/* Setting parameters for component 'channel_3_analyzer_2_array_crystal_array_5' [260]. */
char mccchannel_3_analyzer_2_array_crystal_array_5_material_string[16384];
MCNUM mccchannel_3_analyzer_2_array_crystal_array_5_priority;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_5_xwidth;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_5_yheight;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_5_zdepth;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_5_xwidth2;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_5_yheight2;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_5_visualize;
int mccchannel_3_analyzer_2_array_crystal_array_5_target_index;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_5_target_x;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_5_target_y;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_5_target_z;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_5_focus_aw;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_5_focus_ah;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_5_focus_xw;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_5_focus_xh;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_5_focus_r;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_5_p_interact;
char mccchannel_3_analyzer_2_array_crystal_array_5_mask_string[16384];
char mccchannel_3_analyzer_2_array_crystal_array_5_mask_setting[16384];
MCNUM mccchannel_3_analyzer_2_array_crystal_array_5_number_of_activations;

/* Setting parameters for component 'channel_3_analyzer_2_array_crystal_array_6' [261]. */
char mccchannel_3_analyzer_2_array_crystal_array_6_material_string[16384];
MCNUM mccchannel_3_analyzer_2_array_crystal_array_6_priority;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_6_xwidth;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_6_yheight;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_6_zdepth;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_6_xwidth2;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_6_yheight2;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_6_visualize;
int mccchannel_3_analyzer_2_array_crystal_array_6_target_index;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_6_target_x;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_6_target_y;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_6_target_z;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_6_focus_aw;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_6_focus_ah;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_6_focus_xw;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_6_focus_xh;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_6_focus_r;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_6_p_interact;
char mccchannel_3_analyzer_2_array_crystal_array_6_mask_string[16384];
char mccchannel_3_analyzer_2_array_crystal_array_6_mask_setting[16384];
MCNUM mccchannel_3_analyzer_2_array_crystal_array_6_number_of_activations;

/* Setting parameters for component 'channel_3_analyzer_2_array_crystal_array_7' [262]. */
char mccchannel_3_analyzer_2_array_crystal_array_7_material_string[16384];
MCNUM mccchannel_3_analyzer_2_array_crystal_array_7_priority;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_7_xwidth;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_7_yheight;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_7_zdepth;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_7_xwidth2;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_7_yheight2;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_7_visualize;
int mccchannel_3_analyzer_2_array_crystal_array_7_target_index;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_7_target_x;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_7_target_y;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_7_target_z;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_7_focus_aw;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_7_focus_ah;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_7_focus_xw;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_7_focus_xh;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_7_focus_r;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_7_p_interact;
char mccchannel_3_analyzer_2_array_crystal_array_7_mask_string[16384];
char mccchannel_3_analyzer_2_array_crystal_array_7_mask_setting[16384];
MCNUM mccchannel_3_analyzer_2_array_crystal_array_7_number_of_activations;

/* Setting parameters for component 'channel_3_analyzer_2_array_crystal_array_8' [263]. */
char mccchannel_3_analyzer_2_array_crystal_array_8_material_string[16384];
MCNUM mccchannel_3_analyzer_2_array_crystal_array_8_priority;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_8_xwidth;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_8_yheight;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_8_zdepth;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_8_xwidth2;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_8_yheight2;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_8_visualize;
int mccchannel_3_analyzer_2_array_crystal_array_8_target_index;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_8_target_x;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_8_target_y;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_8_target_z;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_8_focus_aw;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_8_focus_ah;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_8_focus_xw;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_8_focus_xh;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_8_focus_r;
MCNUM mccchannel_3_analyzer_2_array_crystal_array_8_p_interact;
char mccchannel_3_analyzer_2_array_crystal_array_8_mask_string[16384];
char mccchannel_3_analyzer_2_array_crystal_array_8_mask_setting[16384];
MCNUM mccchannel_3_analyzer_2_array_crystal_array_8_number_of_activations;

/* Setting parameters for component 'channel_3_cave2_cyl1' [264]. */
char mccchannel_3_cave2_cyl1_material_string[16384];
MCNUM mccchannel_3_cave2_cyl1_priority;
MCNUM mccchannel_3_cave2_cyl1_radius;
MCNUM mccchannel_3_cave2_cyl1_yheight;
MCNUM mccchannel_3_cave2_cyl1_visualize;
int mccchannel_3_cave2_cyl1_target_index;
MCNUM mccchannel_3_cave2_cyl1_target_x;
MCNUM mccchannel_3_cave2_cyl1_target_y;
MCNUM mccchannel_3_cave2_cyl1_target_z;
MCNUM mccchannel_3_cave2_cyl1_focus_aw;
MCNUM mccchannel_3_cave2_cyl1_focus_ah;
MCNUM mccchannel_3_cave2_cyl1_focus_xw;
MCNUM mccchannel_3_cave2_cyl1_focus_xh;
MCNUM mccchannel_3_cave2_cyl1_focus_r;
MCNUM mccchannel_3_cave2_cyl1_p_interact;
char mccchannel_3_cave2_cyl1_mask_string[16384];
char mccchannel_3_cave2_cyl1_mask_setting[16384];
MCNUM mccchannel_3_cave2_cyl1_number_of_activations;

/* Setting parameters for component 'channel_3_cave2_box1' [265]. */
char mccchannel_3_cave2_box1_material_string[16384];
MCNUM mccchannel_3_cave2_box1_priority;
MCNUM mccchannel_3_cave2_box1_xwidth;
MCNUM mccchannel_3_cave2_box1_yheight;
MCNUM mccchannel_3_cave2_box1_zdepth;
MCNUM mccchannel_3_cave2_box1_xwidth2;
MCNUM mccchannel_3_cave2_box1_yheight2;
MCNUM mccchannel_3_cave2_box1_visualize;
int mccchannel_3_cave2_box1_target_index;
MCNUM mccchannel_3_cave2_box1_target_x;
MCNUM mccchannel_3_cave2_box1_target_y;
MCNUM mccchannel_3_cave2_box1_target_z;
MCNUM mccchannel_3_cave2_box1_focus_aw;
MCNUM mccchannel_3_cave2_box1_focus_ah;
MCNUM mccchannel_3_cave2_box1_focus_xw;
MCNUM mccchannel_3_cave2_box1_focus_xh;
MCNUM mccchannel_3_cave2_box1_focus_r;
MCNUM mccchannel_3_cave2_box1_p_interact;
char mccchannel_3_cave2_box1_mask_string[16384];
char mccchannel_3_cave2_box1_mask_setting[16384];
MCNUM mccchannel_3_cave2_box1_number_of_activations;

/* Setting parameters for component 'channel_3_cave2_box2' [266]. */
char mccchannel_3_cave2_box2_material_string[16384];
MCNUM mccchannel_3_cave2_box2_priority;
MCNUM mccchannel_3_cave2_box2_xwidth;
MCNUM mccchannel_3_cave2_box2_yheight;
MCNUM mccchannel_3_cave2_box2_zdepth;
MCNUM mccchannel_3_cave2_box2_xwidth2;
MCNUM mccchannel_3_cave2_box2_yheight2;
MCNUM mccchannel_3_cave2_box2_visualize;
int mccchannel_3_cave2_box2_target_index;
MCNUM mccchannel_3_cave2_box2_target_x;
MCNUM mccchannel_3_cave2_box2_target_y;
MCNUM mccchannel_3_cave2_box2_target_z;
MCNUM mccchannel_3_cave2_box2_focus_aw;
MCNUM mccchannel_3_cave2_box2_focus_ah;
MCNUM mccchannel_3_cave2_box2_focus_xw;
MCNUM mccchannel_3_cave2_box2_focus_xh;
MCNUM mccchannel_3_cave2_box2_focus_r;
MCNUM mccchannel_3_cave2_box2_p_interact;
char mccchannel_3_cave2_box2_mask_string[16384];
char mccchannel_3_cave2_box2_mask_setting[16384];
MCNUM mccchannel_3_cave2_box2_number_of_activations;

/* Setting parameters for component 'channel_3_cave2_box3' [267]. */
char mccchannel_3_cave2_box3_material_string[16384];
MCNUM mccchannel_3_cave2_box3_priority;
MCNUM mccchannel_3_cave2_box3_xwidth;
MCNUM mccchannel_3_cave2_box3_yheight;
MCNUM mccchannel_3_cave2_box3_zdepth;
MCNUM mccchannel_3_cave2_box3_xwidth2;
MCNUM mccchannel_3_cave2_box3_yheight2;
MCNUM mccchannel_3_cave2_box3_visualize;
int mccchannel_3_cave2_box3_target_index;
MCNUM mccchannel_3_cave2_box3_target_x;
MCNUM mccchannel_3_cave2_box3_target_y;
MCNUM mccchannel_3_cave2_box3_target_z;
MCNUM mccchannel_3_cave2_box3_focus_aw;
MCNUM mccchannel_3_cave2_box3_focus_ah;
MCNUM mccchannel_3_cave2_box3_focus_xw;
MCNUM mccchannel_3_cave2_box3_focus_xh;
MCNUM mccchannel_3_cave2_box3_focus_r;
MCNUM mccchannel_3_cave2_box3_p_interact;
char mccchannel_3_cave2_box3_mask_string[16384];
char mccchannel_3_cave2_box3_mask_setting[16384];
MCNUM mccchannel_3_cave2_box3_number_of_activations;

/* Setting parameters for component 'inter_analyzer_colimator_3_blade_0' [269]. */
char mccinter_analyzer_colimator_3_blade_0_material_string[16384];
MCNUM mccinter_analyzer_colimator_3_blade_0_priority;
MCNUM mccinter_analyzer_colimator_3_blade_0_xwidth;
MCNUM mccinter_analyzer_colimator_3_blade_0_yheight;
MCNUM mccinter_analyzer_colimator_3_blade_0_zdepth;
MCNUM mccinter_analyzer_colimator_3_blade_0_xwidth2;
MCNUM mccinter_analyzer_colimator_3_blade_0_yheight2;
MCNUM mccinter_analyzer_colimator_3_blade_0_visualize;
int mccinter_analyzer_colimator_3_blade_0_target_index;
MCNUM mccinter_analyzer_colimator_3_blade_0_target_x;
MCNUM mccinter_analyzer_colimator_3_blade_0_target_y;
MCNUM mccinter_analyzer_colimator_3_blade_0_target_z;
MCNUM mccinter_analyzer_colimator_3_blade_0_focus_aw;
MCNUM mccinter_analyzer_colimator_3_blade_0_focus_ah;
MCNUM mccinter_analyzer_colimator_3_blade_0_focus_xw;
MCNUM mccinter_analyzer_colimator_3_blade_0_focus_xh;
MCNUM mccinter_analyzer_colimator_3_blade_0_focus_r;
MCNUM mccinter_analyzer_colimator_3_blade_0_p_interact;
char mccinter_analyzer_colimator_3_blade_0_mask_string[16384];
char mccinter_analyzer_colimator_3_blade_0_mask_setting[16384];
MCNUM mccinter_analyzer_colimator_3_blade_0_number_of_activations;

/* Setting parameters for component 'inter_analyzer_colimator_3_blade_1' [270]. */
char mccinter_analyzer_colimator_3_blade_1_material_string[16384];
MCNUM mccinter_analyzer_colimator_3_blade_1_priority;
MCNUM mccinter_analyzer_colimator_3_blade_1_xwidth;
MCNUM mccinter_analyzer_colimator_3_blade_1_yheight;
MCNUM mccinter_analyzer_colimator_3_blade_1_zdepth;
MCNUM mccinter_analyzer_colimator_3_blade_1_xwidth2;
MCNUM mccinter_analyzer_colimator_3_blade_1_yheight2;
MCNUM mccinter_analyzer_colimator_3_blade_1_visualize;
int mccinter_analyzer_colimator_3_blade_1_target_index;
MCNUM mccinter_analyzer_colimator_3_blade_1_target_x;
MCNUM mccinter_analyzer_colimator_3_blade_1_target_y;
MCNUM mccinter_analyzer_colimator_3_blade_1_target_z;
MCNUM mccinter_analyzer_colimator_3_blade_1_focus_aw;
MCNUM mccinter_analyzer_colimator_3_blade_1_focus_ah;
MCNUM mccinter_analyzer_colimator_3_blade_1_focus_xw;
MCNUM mccinter_analyzer_colimator_3_blade_1_focus_xh;
MCNUM mccinter_analyzer_colimator_3_blade_1_focus_r;
MCNUM mccinter_analyzer_colimator_3_blade_1_p_interact;
char mccinter_analyzer_colimator_3_blade_1_mask_string[16384];
char mccinter_analyzer_colimator_3_blade_1_mask_setting[16384];
MCNUM mccinter_analyzer_colimator_3_blade_1_number_of_activations;

/* Setting parameters for component 'inter_analyzer_colimator_3_blade_2' [271]. */
char mccinter_analyzer_colimator_3_blade_2_material_string[16384];
MCNUM mccinter_analyzer_colimator_3_blade_2_priority;
MCNUM mccinter_analyzer_colimator_3_blade_2_xwidth;
MCNUM mccinter_analyzer_colimator_3_blade_2_yheight;
MCNUM mccinter_analyzer_colimator_3_blade_2_zdepth;
MCNUM mccinter_analyzer_colimator_3_blade_2_xwidth2;
MCNUM mccinter_analyzer_colimator_3_blade_2_yheight2;
MCNUM mccinter_analyzer_colimator_3_blade_2_visualize;
int mccinter_analyzer_colimator_3_blade_2_target_index;
MCNUM mccinter_analyzer_colimator_3_blade_2_target_x;
MCNUM mccinter_analyzer_colimator_3_blade_2_target_y;
MCNUM mccinter_analyzer_colimator_3_blade_2_target_z;
MCNUM mccinter_analyzer_colimator_3_blade_2_focus_aw;
MCNUM mccinter_analyzer_colimator_3_blade_2_focus_ah;
MCNUM mccinter_analyzer_colimator_3_blade_2_focus_xw;
MCNUM mccinter_analyzer_colimator_3_blade_2_focus_xh;
MCNUM mccinter_analyzer_colimator_3_blade_2_focus_r;
MCNUM mccinter_analyzer_colimator_3_blade_2_p_interact;
char mccinter_analyzer_colimator_3_blade_2_mask_string[16384];
char mccinter_analyzer_colimator_3_blade_2_mask_setting[16384];
MCNUM mccinter_analyzer_colimator_3_blade_2_number_of_activations;

/* Setting parameters for component 'inter_analyzer_colimator_3_blade_3' [272]. */
char mccinter_analyzer_colimator_3_blade_3_material_string[16384];
MCNUM mccinter_analyzer_colimator_3_blade_3_priority;
MCNUM mccinter_analyzer_colimator_3_blade_3_xwidth;
MCNUM mccinter_analyzer_colimator_3_blade_3_yheight;
MCNUM mccinter_analyzer_colimator_3_blade_3_zdepth;
MCNUM mccinter_analyzer_colimator_3_blade_3_xwidth2;
MCNUM mccinter_analyzer_colimator_3_blade_3_yheight2;
MCNUM mccinter_analyzer_colimator_3_blade_3_visualize;
int mccinter_analyzer_colimator_3_blade_3_target_index;
MCNUM mccinter_analyzer_colimator_3_blade_3_target_x;
MCNUM mccinter_analyzer_colimator_3_blade_3_target_y;
MCNUM mccinter_analyzer_colimator_3_blade_3_target_z;
MCNUM mccinter_analyzer_colimator_3_blade_3_focus_aw;
MCNUM mccinter_analyzer_colimator_3_blade_3_focus_ah;
MCNUM mccinter_analyzer_colimator_3_blade_3_focus_xw;
MCNUM mccinter_analyzer_colimator_3_blade_3_focus_xh;
MCNUM mccinter_analyzer_colimator_3_blade_3_focus_r;
MCNUM mccinter_analyzer_colimator_3_blade_3_p_interact;
char mccinter_analyzer_colimator_3_blade_3_mask_string[16384];
char mccinter_analyzer_colimator_3_blade_3_mask_setting[16384];
MCNUM mccinter_analyzer_colimator_3_blade_3_number_of_activations;

/* Setting parameters for component 'inter_analyzer_colimator_3_blade_4' [273]. */
char mccinter_analyzer_colimator_3_blade_4_material_string[16384];
MCNUM mccinter_analyzer_colimator_3_blade_4_priority;
MCNUM mccinter_analyzer_colimator_3_blade_4_xwidth;
MCNUM mccinter_analyzer_colimator_3_blade_4_yheight;
MCNUM mccinter_analyzer_colimator_3_blade_4_zdepth;
MCNUM mccinter_analyzer_colimator_3_blade_4_xwidth2;
MCNUM mccinter_analyzer_colimator_3_blade_4_yheight2;
MCNUM mccinter_analyzer_colimator_3_blade_4_visualize;
int mccinter_analyzer_colimator_3_blade_4_target_index;
MCNUM mccinter_analyzer_colimator_3_blade_4_target_x;
MCNUM mccinter_analyzer_colimator_3_blade_4_target_y;
MCNUM mccinter_analyzer_colimator_3_blade_4_target_z;
MCNUM mccinter_analyzer_colimator_3_blade_4_focus_aw;
MCNUM mccinter_analyzer_colimator_3_blade_4_focus_ah;
MCNUM mccinter_analyzer_colimator_3_blade_4_focus_xw;
MCNUM mccinter_analyzer_colimator_3_blade_4_focus_xh;
MCNUM mccinter_analyzer_colimator_3_blade_4_focus_r;
MCNUM mccinter_analyzer_colimator_3_blade_4_p_interact;
char mccinter_analyzer_colimator_3_blade_4_mask_string[16384];
char mccinter_analyzer_colimator_3_blade_4_mask_setting[16384];
MCNUM mccinter_analyzer_colimator_3_blade_4_number_of_activations;

/* Setting parameters for component 'diffraction_detector_3_exit_volume' [274]. */
char mccdiffraction_detector_3_exit_volume_material_string[16384];
MCNUM mccdiffraction_detector_3_exit_volume_priority;
MCNUM mccdiffraction_detector_3_exit_volume_xwidth;
MCNUM mccdiffraction_detector_3_exit_volume_yheight;
MCNUM mccdiffraction_detector_3_exit_volume_zdepth;
MCNUM mccdiffraction_detector_3_exit_volume_xwidth2;
MCNUM mccdiffraction_detector_3_exit_volume_yheight2;
MCNUM mccdiffraction_detector_3_exit_volume_visualize;
int mccdiffraction_detector_3_exit_volume_target_index;
MCNUM mccdiffraction_detector_3_exit_volume_target_x;
MCNUM mccdiffraction_detector_3_exit_volume_target_y;
MCNUM mccdiffraction_detector_3_exit_volume_target_z;
MCNUM mccdiffraction_detector_3_exit_volume_focus_aw;
MCNUM mccdiffraction_detector_3_exit_volume_focus_ah;
MCNUM mccdiffraction_detector_3_exit_volume_focus_xw;
MCNUM mccdiffraction_detector_3_exit_volume_focus_xh;
MCNUM mccdiffraction_detector_3_exit_volume_focus_r;
MCNUM mccdiffraction_detector_3_exit_volume_p_interact;
char mccdiffraction_detector_3_exit_volume_mask_string[16384];
char mccdiffraction_detector_3_exit_volume_mask_setting[16384];
MCNUM mccdiffraction_detector_3_exit_volume_number_of_activations;

/* Setting parameters for component 'spec_detector_3_exit_volume' [275]. */
char mccspec_detector_3_exit_volume_material_string[16384];
MCNUM mccspec_detector_3_exit_volume_priority;
MCNUM mccspec_detector_3_exit_volume_xwidth;
MCNUM mccspec_detector_3_exit_volume_yheight;
MCNUM mccspec_detector_3_exit_volume_zdepth;
MCNUM mccspec_detector_3_exit_volume_xwidth2;
MCNUM mccspec_detector_3_exit_volume_yheight2;
MCNUM mccspec_detector_3_exit_volume_visualize;
int mccspec_detector_3_exit_volume_target_index;
MCNUM mccspec_detector_3_exit_volume_target_x;
MCNUM mccspec_detector_3_exit_volume_target_y;
MCNUM mccspec_detector_3_exit_volume_target_z;
MCNUM mccspec_detector_3_exit_volume_focus_aw;
MCNUM mccspec_detector_3_exit_volume_focus_ah;
MCNUM mccspec_detector_3_exit_volume_focus_xw;
MCNUM mccspec_detector_3_exit_volume_focus_xh;
MCNUM mccspec_detector_3_exit_volume_focus_r;
MCNUM mccspec_detector_3_exit_volume_p_interact;
char mccspec_detector_3_exit_volume_mask_string[16384];
char mccspec_detector_3_exit_volume_mask_setting[16384];
MCNUM mccspec_detector_3_exit_volume_number_of_activations;

/* Setting parameters for component 'channel_4_cave1_box1' [276]. */
char mccchannel_4_cave1_box1_material_string[16384];
MCNUM mccchannel_4_cave1_box1_priority;
MCNUM mccchannel_4_cave1_box1_xwidth;
MCNUM mccchannel_4_cave1_box1_yheight;
MCNUM mccchannel_4_cave1_box1_zdepth;
MCNUM mccchannel_4_cave1_box1_xwidth2;
MCNUM mccchannel_4_cave1_box1_yheight2;
MCNUM mccchannel_4_cave1_box1_visualize;
int mccchannel_4_cave1_box1_target_index;
MCNUM mccchannel_4_cave1_box1_target_x;
MCNUM mccchannel_4_cave1_box1_target_y;
MCNUM mccchannel_4_cave1_box1_target_z;
MCNUM mccchannel_4_cave1_box1_focus_aw;
MCNUM mccchannel_4_cave1_box1_focus_ah;
MCNUM mccchannel_4_cave1_box1_focus_xw;
MCNUM mccchannel_4_cave1_box1_focus_xh;
MCNUM mccchannel_4_cave1_box1_focus_r;
MCNUM mccchannel_4_cave1_box1_p_interact;
char mccchannel_4_cave1_box1_mask_string[16384];
char mccchannel_4_cave1_box1_mask_setting[16384];
MCNUM mccchannel_4_cave1_box1_number_of_activations;

/* Setting parameters for component 'channel_4_cave1_box2' [277]. */
char mccchannel_4_cave1_box2_material_string[16384];
MCNUM mccchannel_4_cave1_box2_priority;
MCNUM mccchannel_4_cave1_box2_xwidth;
MCNUM mccchannel_4_cave1_box2_yheight;
MCNUM mccchannel_4_cave1_box2_zdepth;
MCNUM mccchannel_4_cave1_box2_xwidth2;
MCNUM mccchannel_4_cave1_box2_yheight2;
MCNUM mccchannel_4_cave1_box2_visualize;
int mccchannel_4_cave1_box2_target_index;
MCNUM mccchannel_4_cave1_box2_target_x;
MCNUM mccchannel_4_cave1_box2_target_y;
MCNUM mccchannel_4_cave1_box2_target_z;
MCNUM mccchannel_4_cave1_box2_focus_aw;
MCNUM mccchannel_4_cave1_box2_focus_ah;
MCNUM mccchannel_4_cave1_box2_focus_xw;
MCNUM mccchannel_4_cave1_box2_focus_xh;
MCNUM mccchannel_4_cave1_box2_focus_r;
MCNUM mccchannel_4_cave1_box2_p_interact;
char mccchannel_4_cave1_box2_mask_string[16384];
char mccchannel_4_cave1_box2_mask_setting[16384];
MCNUM mccchannel_4_cave1_box2_number_of_activations;

/* Setting parameters for component 'channel_4_cave1_box3' [278]. */
char mccchannel_4_cave1_box3_material_string[16384];
MCNUM mccchannel_4_cave1_box3_priority;
MCNUM mccchannel_4_cave1_box3_xwidth;
MCNUM mccchannel_4_cave1_box3_yheight;
MCNUM mccchannel_4_cave1_box3_zdepth;
MCNUM mccchannel_4_cave1_box3_xwidth2;
MCNUM mccchannel_4_cave1_box3_yheight2;
MCNUM mccchannel_4_cave1_box3_visualize;
int mccchannel_4_cave1_box3_target_index;
MCNUM mccchannel_4_cave1_box3_target_x;
MCNUM mccchannel_4_cave1_box3_target_y;
MCNUM mccchannel_4_cave1_box3_target_z;
MCNUM mccchannel_4_cave1_box3_focus_aw;
MCNUM mccchannel_4_cave1_box3_focus_ah;
MCNUM mccchannel_4_cave1_box3_focus_xw;
MCNUM mccchannel_4_cave1_box3_focus_xh;
MCNUM mccchannel_4_cave1_box3_focus_r;
MCNUM mccchannel_4_cave1_box3_p_interact;
char mccchannel_4_cave1_box3_mask_string[16384];
char mccchannel_4_cave1_box3_mask_setting[16384];
MCNUM mccchannel_4_cave1_box3_number_of_activations;

/* Setting parameters for component 'channel_4_cave1_cyl1' [279]. */
char mccchannel_4_cave1_cyl1_material_string[16384];
MCNUM mccchannel_4_cave1_cyl1_priority;
MCNUM mccchannel_4_cave1_cyl1_radius;
MCNUM mccchannel_4_cave1_cyl1_yheight;
MCNUM mccchannel_4_cave1_cyl1_visualize;
int mccchannel_4_cave1_cyl1_target_index;
MCNUM mccchannel_4_cave1_cyl1_target_x;
MCNUM mccchannel_4_cave1_cyl1_target_y;
MCNUM mccchannel_4_cave1_cyl1_target_z;
MCNUM mccchannel_4_cave1_cyl1_focus_aw;
MCNUM mccchannel_4_cave1_cyl1_focus_ah;
MCNUM mccchannel_4_cave1_cyl1_focus_xw;
MCNUM mccchannel_4_cave1_cyl1_focus_xh;
MCNUM mccchannel_4_cave1_cyl1_focus_r;
MCNUM mccchannel_4_cave1_cyl1_p_interact;
char mccchannel_4_cave1_cyl1_mask_string[16384];
char mccchannel_4_cave1_cyl1_mask_setting[16384];
MCNUM mccchannel_4_cave1_cyl1_number_of_activations;

/* Setting parameters for component 'channel_4_analyzer_1_array_crystal_array_0' [282]. */
char mccchannel_4_analyzer_1_array_crystal_array_0_material_string[16384];
MCNUM mccchannel_4_analyzer_1_array_crystal_array_0_priority;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_0_xwidth;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_0_yheight;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_0_zdepth;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_0_xwidth2;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_0_yheight2;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_0_visualize;
int mccchannel_4_analyzer_1_array_crystal_array_0_target_index;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_0_target_x;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_0_target_y;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_0_target_z;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_0_focus_aw;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_0_focus_ah;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_0_focus_xw;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_0_focus_xh;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_0_focus_r;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_0_p_interact;
char mccchannel_4_analyzer_1_array_crystal_array_0_mask_string[16384];
char mccchannel_4_analyzer_1_array_crystal_array_0_mask_setting[16384];
MCNUM mccchannel_4_analyzer_1_array_crystal_array_0_number_of_activations;

/* Setting parameters for component 'channel_4_analyzer_1_array_crystal_array_1' [283]. */
char mccchannel_4_analyzer_1_array_crystal_array_1_material_string[16384];
MCNUM mccchannel_4_analyzer_1_array_crystal_array_1_priority;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_1_xwidth;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_1_yheight;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_1_zdepth;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_1_xwidth2;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_1_yheight2;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_1_visualize;
int mccchannel_4_analyzer_1_array_crystal_array_1_target_index;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_1_target_x;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_1_target_y;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_1_target_z;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_1_focus_aw;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_1_focus_ah;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_1_focus_xw;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_1_focus_xh;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_1_focus_r;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_1_p_interact;
char mccchannel_4_analyzer_1_array_crystal_array_1_mask_string[16384];
char mccchannel_4_analyzer_1_array_crystal_array_1_mask_setting[16384];
MCNUM mccchannel_4_analyzer_1_array_crystal_array_1_number_of_activations;

/* Setting parameters for component 'channel_4_analyzer_1_array_crystal_array_2' [284]. */
char mccchannel_4_analyzer_1_array_crystal_array_2_material_string[16384];
MCNUM mccchannel_4_analyzer_1_array_crystal_array_2_priority;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_2_xwidth;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_2_yheight;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_2_zdepth;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_2_xwidth2;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_2_yheight2;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_2_visualize;
int mccchannel_4_analyzer_1_array_crystal_array_2_target_index;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_2_target_x;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_2_target_y;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_2_target_z;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_2_focus_aw;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_2_focus_ah;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_2_focus_xw;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_2_focus_xh;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_2_focus_r;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_2_p_interact;
char mccchannel_4_analyzer_1_array_crystal_array_2_mask_string[16384];
char mccchannel_4_analyzer_1_array_crystal_array_2_mask_setting[16384];
MCNUM mccchannel_4_analyzer_1_array_crystal_array_2_number_of_activations;

/* Setting parameters for component 'channel_4_analyzer_1_array_crystal_array_3' [285]. */
char mccchannel_4_analyzer_1_array_crystal_array_3_material_string[16384];
MCNUM mccchannel_4_analyzer_1_array_crystal_array_3_priority;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_3_xwidth;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_3_yheight;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_3_zdepth;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_3_xwidth2;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_3_yheight2;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_3_visualize;
int mccchannel_4_analyzer_1_array_crystal_array_3_target_index;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_3_target_x;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_3_target_y;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_3_target_z;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_3_focus_aw;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_3_focus_ah;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_3_focus_xw;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_3_focus_xh;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_3_focus_r;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_3_p_interact;
char mccchannel_4_analyzer_1_array_crystal_array_3_mask_string[16384];
char mccchannel_4_analyzer_1_array_crystal_array_3_mask_setting[16384];
MCNUM mccchannel_4_analyzer_1_array_crystal_array_3_number_of_activations;

/* Setting parameters for component 'channel_4_analyzer_1_array_crystal_array_4' [286]. */
char mccchannel_4_analyzer_1_array_crystal_array_4_material_string[16384];
MCNUM mccchannel_4_analyzer_1_array_crystal_array_4_priority;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_4_xwidth;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_4_yheight;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_4_zdepth;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_4_xwidth2;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_4_yheight2;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_4_visualize;
int mccchannel_4_analyzer_1_array_crystal_array_4_target_index;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_4_target_x;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_4_target_y;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_4_target_z;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_4_focus_aw;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_4_focus_ah;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_4_focus_xw;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_4_focus_xh;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_4_focus_r;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_4_p_interact;
char mccchannel_4_analyzer_1_array_crystal_array_4_mask_string[16384];
char mccchannel_4_analyzer_1_array_crystal_array_4_mask_setting[16384];
MCNUM mccchannel_4_analyzer_1_array_crystal_array_4_number_of_activations;

/* Setting parameters for component 'channel_4_analyzer_1_array_crystal_array_5' [287]. */
char mccchannel_4_analyzer_1_array_crystal_array_5_material_string[16384];
MCNUM mccchannel_4_analyzer_1_array_crystal_array_5_priority;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_5_xwidth;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_5_yheight;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_5_zdepth;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_5_xwidth2;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_5_yheight2;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_5_visualize;
int mccchannel_4_analyzer_1_array_crystal_array_5_target_index;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_5_target_x;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_5_target_y;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_5_target_z;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_5_focus_aw;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_5_focus_ah;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_5_focus_xw;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_5_focus_xh;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_5_focus_r;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_5_p_interact;
char mccchannel_4_analyzer_1_array_crystal_array_5_mask_string[16384];
char mccchannel_4_analyzer_1_array_crystal_array_5_mask_setting[16384];
MCNUM mccchannel_4_analyzer_1_array_crystal_array_5_number_of_activations;

/* Setting parameters for component 'channel_4_analyzer_1_array_crystal_array_6' [288]. */
char mccchannel_4_analyzer_1_array_crystal_array_6_material_string[16384];
MCNUM mccchannel_4_analyzer_1_array_crystal_array_6_priority;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_6_xwidth;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_6_yheight;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_6_zdepth;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_6_xwidth2;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_6_yheight2;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_6_visualize;
int mccchannel_4_analyzer_1_array_crystal_array_6_target_index;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_6_target_x;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_6_target_y;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_6_target_z;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_6_focus_aw;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_6_focus_ah;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_6_focus_xw;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_6_focus_xh;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_6_focus_r;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_6_p_interact;
char mccchannel_4_analyzer_1_array_crystal_array_6_mask_string[16384];
char mccchannel_4_analyzer_1_array_crystal_array_6_mask_setting[16384];
MCNUM mccchannel_4_analyzer_1_array_crystal_array_6_number_of_activations;

/* Setting parameters for component 'channel_4_analyzer_1_array_crystal_array_7' [289]. */
char mccchannel_4_analyzer_1_array_crystal_array_7_material_string[16384];
MCNUM mccchannel_4_analyzer_1_array_crystal_array_7_priority;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_7_xwidth;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_7_yheight;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_7_zdepth;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_7_xwidth2;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_7_yheight2;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_7_visualize;
int mccchannel_4_analyzer_1_array_crystal_array_7_target_index;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_7_target_x;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_7_target_y;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_7_target_z;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_7_focus_aw;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_7_focus_ah;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_7_focus_xw;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_7_focus_xh;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_7_focus_r;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_7_p_interact;
char mccchannel_4_analyzer_1_array_crystal_array_7_mask_string[16384];
char mccchannel_4_analyzer_1_array_crystal_array_7_mask_setting[16384];
MCNUM mccchannel_4_analyzer_1_array_crystal_array_7_number_of_activations;

/* Setting parameters for component 'channel_4_analyzer_1_array_crystal_array_8' [290]. */
char mccchannel_4_analyzer_1_array_crystal_array_8_material_string[16384];
MCNUM mccchannel_4_analyzer_1_array_crystal_array_8_priority;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_8_xwidth;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_8_yheight;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_8_zdepth;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_8_xwidth2;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_8_yheight2;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_8_visualize;
int mccchannel_4_analyzer_1_array_crystal_array_8_target_index;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_8_target_x;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_8_target_y;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_8_target_z;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_8_focus_aw;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_8_focus_ah;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_8_focus_xw;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_8_focus_xh;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_8_focus_r;
MCNUM mccchannel_4_analyzer_1_array_crystal_array_8_p_interact;
char mccchannel_4_analyzer_1_array_crystal_array_8_mask_string[16384];
char mccchannel_4_analyzer_1_array_crystal_array_8_mask_setting[16384];
MCNUM mccchannel_4_analyzer_1_array_crystal_array_8_number_of_activations;

/* Setting parameters for component 'channel_4_analyzer_2_array_crystal_array_0' [293]. */
char mccchannel_4_analyzer_2_array_crystal_array_0_material_string[16384];
MCNUM mccchannel_4_analyzer_2_array_crystal_array_0_priority;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_0_xwidth;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_0_yheight;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_0_zdepth;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_0_xwidth2;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_0_yheight2;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_0_visualize;
int mccchannel_4_analyzer_2_array_crystal_array_0_target_index;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_0_target_x;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_0_target_y;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_0_target_z;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_0_focus_aw;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_0_focus_ah;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_0_focus_xw;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_0_focus_xh;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_0_focus_r;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_0_p_interact;
char mccchannel_4_analyzer_2_array_crystal_array_0_mask_string[16384];
char mccchannel_4_analyzer_2_array_crystal_array_0_mask_setting[16384];
MCNUM mccchannel_4_analyzer_2_array_crystal_array_0_number_of_activations;

/* Setting parameters for component 'channel_4_analyzer_2_array_crystal_array_1' [294]. */
char mccchannel_4_analyzer_2_array_crystal_array_1_material_string[16384];
MCNUM mccchannel_4_analyzer_2_array_crystal_array_1_priority;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_1_xwidth;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_1_yheight;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_1_zdepth;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_1_xwidth2;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_1_yheight2;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_1_visualize;
int mccchannel_4_analyzer_2_array_crystal_array_1_target_index;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_1_target_x;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_1_target_y;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_1_target_z;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_1_focus_aw;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_1_focus_ah;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_1_focus_xw;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_1_focus_xh;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_1_focus_r;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_1_p_interact;
char mccchannel_4_analyzer_2_array_crystal_array_1_mask_string[16384];
char mccchannel_4_analyzer_2_array_crystal_array_1_mask_setting[16384];
MCNUM mccchannel_4_analyzer_2_array_crystal_array_1_number_of_activations;

/* Setting parameters for component 'channel_4_analyzer_2_array_crystal_array_2' [295]. */
char mccchannel_4_analyzer_2_array_crystal_array_2_material_string[16384];
MCNUM mccchannel_4_analyzer_2_array_crystal_array_2_priority;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_2_xwidth;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_2_yheight;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_2_zdepth;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_2_xwidth2;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_2_yheight2;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_2_visualize;
int mccchannel_4_analyzer_2_array_crystal_array_2_target_index;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_2_target_x;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_2_target_y;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_2_target_z;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_2_focus_aw;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_2_focus_ah;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_2_focus_xw;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_2_focus_xh;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_2_focus_r;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_2_p_interact;
char mccchannel_4_analyzer_2_array_crystal_array_2_mask_string[16384];
char mccchannel_4_analyzer_2_array_crystal_array_2_mask_setting[16384];
MCNUM mccchannel_4_analyzer_2_array_crystal_array_2_number_of_activations;

/* Setting parameters for component 'channel_4_analyzer_2_array_crystal_array_3' [296]. */
char mccchannel_4_analyzer_2_array_crystal_array_3_material_string[16384];
MCNUM mccchannel_4_analyzer_2_array_crystal_array_3_priority;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_3_xwidth;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_3_yheight;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_3_zdepth;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_3_xwidth2;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_3_yheight2;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_3_visualize;
int mccchannel_4_analyzer_2_array_crystal_array_3_target_index;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_3_target_x;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_3_target_y;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_3_target_z;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_3_focus_aw;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_3_focus_ah;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_3_focus_xw;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_3_focus_xh;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_3_focus_r;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_3_p_interact;
char mccchannel_4_analyzer_2_array_crystal_array_3_mask_string[16384];
char mccchannel_4_analyzer_2_array_crystal_array_3_mask_setting[16384];
MCNUM mccchannel_4_analyzer_2_array_crystal_array_3_number_of_activations;

/* Setting parameters for component 'channel_4_analyzer_2_array_crystal_array_4' [297]. */
char mccchannel_4_analyzer_2_array_crystal_array_4_material_string[16384];
MCNUM mccchannel_4_analyzer_2_array_crystal_array_4_priority;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_4_xwidth;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_4_yheight;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_4_zdepth;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_4_xwidth2;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_4_yheight2;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_4_visualize;
int mccchannel_4_analyzer_2_array_crystal_array_4_target_index;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_4_target_x;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_4_target_y;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_4_target_z;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_4_focus_aw;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_4_focus_ah;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_4_focus_xw;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_4_focus_xh;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_4_focus_r;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_4_p_interact;
char mccchannel_4_analyzer_2_array_crystal_array_4_mask_string[16384];
char mccchannel_4_analyzer_2_array_crystal_array_4_mask_setting[16384];
MCNUM mccchannel_4_analyzer_2_array_crystal_array_4_number_of_activations;

/* Setting parameters for component 'channel_4_analyzer_2_array_crystal_array_5' [298]. */
char mccchannel_4_analyzer_2_array_crystal_array_5_material_string[16384];
MCNUM mccchannel_4_analyzer_2_array_crystal_array_5_priority;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_5_xwidth;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_5_yheight;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_5_zdepth;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_5_xwidth2;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_5_yheight2;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_5_visualize;
int mccchannel_4_analyzer_2_array_crystal_array_5_target_index;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_5_target_x;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_5_target_y;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_5_target_z;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_5_focus_aw;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_5_focus_ah;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_5_focus_xw;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_5_focus_xh;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_5_focus_r;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_5_p_interact;
char mccchannel_4_analyzer_2_array_crystal_array_5_mask_string[16384];
char mccchannel_4_analyzer_2_array_crystal_array_5_mask_setting[16384];
MCNUM mccchannel_4_analyzer_2_array_crystal_array_5_number_of_activations;

/* Setting parameters for component 'channel_4_analyzer_2_array_crystal_array_6' [299]. */
char mccchannel_4_analyzer_2_array_crystal_array_6_material_string[16384];
MCNUM mccchannel_4_analyzer_2_array_crystal_array_6_priority;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_6_xwidth;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_6_yheight;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_6_zdepth;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_6_xwidth2;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_6_yheight2;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_6_visualize;
int mccchannel_4_analyzer_2_array_crystal_array_6_target_index;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_6_target_x;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_6_target_y;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_6_target_z;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_6_focus_aw;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_6_focus_ah;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_6_focus_xw;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_6_focus_xh;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_6_focus_r;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_6_p_interact;
char mccchannel_4_analyzer_2_array_crystal_array_6_mask_string[16384];
char mccchannel_4_analyzer_2_array_crystal_array_6_mask_setting[16384];
MCNUM mccchannel_4_analyzer_2_array_crystal_array_6_number_of_activations;

/* Setting parameters for component 'channel_4_analyzer_2_array_crystal_array_7' [300]. */
char mccchannel_4_analyzer_2_array_crystal_array_7_material_string[16384];
MCNUM mccchannel_4_analyzer_2_array_crystal_array_7_priority;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_7_xwidth;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_7_yheight;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_7_zdepth;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_7_xwidth2;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_7_yheight2;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_7_visualize;
int mccchannel_4_analyzer_2_array_crystal_array_7_target_index;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_7_target_x;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_7_target_y;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_7_target_z;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_7_focus_aw;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_7_focus_ah;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_7_focus_xw;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_7_focus_xh;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_7_focus_r;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_7_p_interact;
char mccchannel_4_analyzer_2_array_crystal_array_7_mask_string[16384];
char mccchannel_4_analyzer_2_array_crystal_array_7_mask_setting[16384];
MCNUM mccchannel_4_analyzer_2_array_crystal_array_7_number_of_activations;

/* Setting parameters for component 'channel_4_analyzer_2_array_crystal_array_8' [301]. */
char mccchannel_4_analyzer_2_array_crystal_array_8_material_string[16384];
MCNUM mccchannel_4_analyzer_2_array_crystal_array_8_priority;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_8_xwidth;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_8_yheight;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_8_zdepth;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_8_xwidth2;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_8_yheight2;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_8_visualize;
int mccchannel_4_analyzer_2_array_crystal_array_8_target_index;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_8_target_x;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_8_target_y;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_8_target_z;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_8_focus_aw;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_8_focus_ah;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_8_focus_xw;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_8_focus_xh;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_8_focus_r;
MCNUM mccchannel_4_analyzer_2_array_crystal_array_8_p_interact;
char mccchannel_4_analyzer_2_array_crystal_array_8_mask_string[16384];
char mccchannel_4_analyzer_2_array_crystal_array_8_mask_setting[16384];
MCNUM mccchannel_4_analyzer_2_array_crystal_array_8_number_of_activations;

/* Setting parameters for component 'channel_4_cave2_cyl1' [302]. */
char mccchannel_4_cave2_cyl1_material_string[16384];
MCNUM mccchannel_4_cave2_cyl1_priority;
MCNUM mccchannel_4_cave2_cyl1_radius;
MCNUM mccchannel_4_cave2_cyl1_yheight;
MCNUM mccchannel_4_cave2_cyl1_visualize;
int mccchannel_4_cave2_cyl1_target_index;
MCNUM mccchannel_4_cave2_cyl1_target_x;
MCNUM mccchannel_4_cave2_cyl1_target_y;
MCNUM mccchannel_4_cave2_cyl1_target_z;
MCNUM mccchannel_4_cave2_cyl1_focus_aw;
MCNUM mccchannel_4_cave2_cyl1_focus_ah;
MCNUM mccchannel_4_cave2_cyl1_focus_xw;
MCNUM mccchannel_4_cave2_cyl1_focus_xh;
MCNUM mccchannel_4_cave2_cyl1_focus_r;
MCNUM mccchannel_4_cave2_cyl1_p_interact;
char mccchannel_4_cave2_cyl1_mask_string[16384];
char mccchannel_4_cave2_cyl1_mask_setting[16384];
MCNUM mccchannel_4_cave2_cyl1_number_of_activations;

/* Setting parameters for component 'channel_4_cave2_box1' [303]. */
char mccchannel_4_cave2_box1_material_string[16384];
MCNUM mccchannel_4_cave2_box1_priority;
MCNUM mccchannel_4_cave2_box1_xwidth;
MCNUM mccchannel_4_cave2_box1_yheight;
MCNUM mccchannel_4_cave2_box1_zdepth;
MCNUM mccchannel_4_cave2_box1_xwidth2;
MCNUM mccchannel_4_cave2_box1_yheight2;
MCNUM mccchannel_4_cave2_box1_visualize;
int mccchannel_4_cave2_box1_target_index;
MCNUM mccchannel_4_cave2_box1_target_x;
MCNUM mccchannel_4_cave2_box1_target_y;
MCNUM mccchannel_4_cave2_box1_target_z;
MCNUM mccchannel_4_cave2_box1_focus_aw;
MCNUM mccchannel_4_cave2_box1_focus_ah;
MCNUM mccchannel_4_cave2_box1_focus_xw;
MCNUM mccchannel_4_cave2_box1_focus_xh;
MCNUM mccchannel_4_cave2_box1_focus_r;
MCNUM mccchannel_4_cave2_box1_p_interact;
char mccchannel_4_cave2_box1_mask_string[16384];
char mccchannel_4_cave2_box1_mask_setting[16384];
MCNUM mccchannel_4_cave2_box1_number_of_activations;

/* Setting parameters for component 'channel_4_cave2_box2' [304]. */
char mccchannel_4_cave2_box2_material_string[16384];
MCNUM mccchannel_4_cave2_box2_priority;
MCNUM mccchannel_4_cave2_box2_xwidth;
MCNUM mccchannel_4_cave2_box2_yheight;
MCNUM mccchannel_4_cave2_box2_zdepth;
MCNUM mccchannel_4_cave2_box2_xwidth2;
MCNUM mccchannel_4_cave2_box2_yheight2;
MCNUM mccchannel_4_cave2_box2_visualize;
int mccchannel_4_cave2_box2_target_index;
MCNUM mccchannel_4_cave2_box2_target_x;
MCNUM mccchannel_4_cave2_box2_target_y;
MCNUM mccchannel_4_cave2_box2_target_z;
MCNUM mccchannel_4_cave2_box2_focus_aw;
MCNUM mccchannel_4_cave2_box2_focus_ah;
MCNUM mccchannel_4_cave2_box2_focus_xw;
MCNUM mccchannel_4_cave2_box2_focus_xh;
MCNUM mccchannel_4_cave2_box2_focus_r;
MCNUM mccchannel_4_cave2_box2_p_interact;
char mccchannel_4_cave2_box2_mask_string[16384];
char mccchannel_4_cave2_box2_mask_setting[16384];
MCNUM mccchannel_4_cave2_box2_number_of_activations;

/* Setting parameters for component 'channel_4_cave2_box3' [305]. */
char mccchannel_4_cave2_box3_material_string[16384];
MCNUM mccchannel_4_cave2_box3_priority;
MCNUM mccchannel_4_cave2_box3_xwidth;
MCNUM mccchannel_4_cave2_box3_yheight;
MCNUM mccchannel_4_cave2_box3_zdepth;
MCNUM mccchannel_4_cave2_box3_xwidth2;
MCNUM mccchannel_4_cave2_box3_yheight2;
MCNUM mccchannel_4_cave2_box3_visualize;
int mccchannel_4_cave2_box3_target_index;
MCNUM mccchannel_4_cave2_box3_target_x;
MCNUM mccchannel_4_cave2_box3_target_y;
MCNUM mccchannel_4_cave2_box3_target_z;
MCNUM mccchannel_4_cave2_box3_focus_aw;
MCNUM mccchannel_4_cave2_box3_focus_ah;
MCNUM mccchannel_4_cave2_box3_focus_xw;
MCNUM mccchannel_4_cave2_box3_focus_xh;
MCNUM mccchannel_4_cave2_box3_focus_r;
MCNUM mccchannel_4_cave2_box3_p_interact;
char mccchannel_4_cave2_box3_mask_string[16384];
char mccchannel_4_cave2_box3_mask_setting[16384];
MCNUM mccchannel_4_cave2_box3_number_of_activations;

/* Setting parameters for component 'inter_analyzer_colimator_4_blade_0' [307]. */
char mccinter_analyzer_colimator_4_blade_0_material_string[16384];
MCNUM mccinter_analyzer_colimator_4_blade_0_priority;
MCNUM mccinter_analyzer_colimator_4_blade_0_xwidth;
MCNUM mccinter_analyzer_colimator_4_blade_0_yheight;
MCNUM mccinter_analyzer_colimator_4_blade_0_zdepth;
MCNUM mccinter_analyzer_colimator_4_blade_0_xwidth2;
MCNUM mccinter_analyzer_colimator_4_blade_0_yheight2;
MCNUM mccinter_analyzer_colimator_4_blade_0_visualize;
int mccinter_analyzer_colimator_4_blade_0_target_index;
MCNUM mccinter_analyzer_colimator_4_blade_0_target_x;
MCNUM mccinter_analyzer_colimator_4_blade_0_target_y;
MCNUM mccinter_analyzer_colimator_4_blade_0_target_z;
MCNUM mccinter_analyzer_colimator_4_blade_0_focus_aw;
MCNUM mccinter_analyzer_colimator_4_blade_0_focus_ah;
MCNUM mccinter_analyzer_colimator_4_blade_0_focus_xw;
MCNUM mccinter_analyzer_colimator_4_blade_0_focus_xh;
MCNUM mccinter_analyzer_colimator_4_blade_0_focus_r;
MCNUM mccinter_analyzer_colimator_4_blade_0_p_interact;
char mccinter_analyzer_colimator_4_blade_0_mask_string[16384];
char mccinter_analyzer_colimator_4_blade_0_mask_setting[16384];
MCNUM mccinter_analyzer_colimator_4_blade_0_number_of_activations;

/* Setting parameters for component 'inter_analyzer_colimator_4_blade_1' [308]. */
char mccinter_analyzer_colimator_4_blade_1_material_string[16384];
MCNUM mccinter_analyzer_colimator_4_blade_1_priority;
MCNUM mccinter_analyzer_colimator_4_blade_1_xwidth;
MCNUM mccinter_analyzer_colimator_4_blade_1_yheight;
MCNUM mccinter_analyzer_colimator_4_blade_1_zdepth;
MCNUM mccinter_analyzer_colimator_4_blade_1_xwidth2;
MCNUM mccinter_analyzer_colimator_4_blade_1_yheight2;
MCNUM mccinter_analyzer_colimator_4_blade_1_visualize;
int mccinter_analyzer_colimator_4_blade_1_target_index;
MCNUM mccinter_analyzer_colimator_4_blade_1_target_x;
MCNUM mccinter_analyzer_colimator_4_blade_1_target_y;
MCNUM mccinter_analyzer_colimator_4_blade_1_target_z;
MCNUM mccinter_analyzer_colimator_4_blade_1_focus_aw;
MCNUM mccinter_analyzer_colimator_4_blade_1_focus_ah;
MCNUM mccinter_analyzer_colimator_4_blade_1_focus_xw;
MCNUM mccinter_analyzer_colimator_4_blade_1_focus_xh;
MCNUM mccinter_analyzer_colimator_4_blade_1_focus_r;
MCNUM mccinter_analyzer_colimator_4_blade_1_p_interact;
char mccinter_analyzer_colimator_4_blade_1_mask_string[16384];
char mccinter_analyzer_colimator_4_blade_1_mask_setting[16384];
MCNUM mccinter_analyzer_colimator_4_blade_1_number_of_activations;

/* Setting parameters for component 'inter_analyzer_colimator_4_blade_2' [309]. */
char mccinter_analyzer_colimator_4_blade_2_material_string[16384];
MCNUM mccinter_analyzer_colimator_4_blade_2_priority;
MCNUM mccinter_analyzer_colimator_4_blade_2_xwidth;
MCNUM mccinter_analyzer_colimator_4_blade_2_yheight;
MCNUM mccinter_analyzer_colimator_4_blade_2_zdepth;
MCNUM mccinter_analyzer_colimator_4_blade_2_xwidth2;
MCNUM mccinter_analyzer_colimator_4_blade_2_yheight2;
MCNUM mccinter_analyzer_colimator_4_blade_2_visualize;
int mccinter_analyzer_colimator_4_blade_2_target_index;
MCNUM mccinter_analyzer_colimator_4_blade_2_target_x;
MCNUM mccinter_analyzer_colimator_4_blade_2_target_y;
MCNUM mccinter_analyzer_colimator_4_blade_2_target_z;
MCNUM mccinter_analyzer_colimator_4_blade_2_focus_aw;
MCNUM mccinter_analyzer_colimator_4_blade_2_focus_ah;
MCNUM mccinter_analyzer_colimator_4_blade_2_focus_xw;
MCNUM mccinter_analyzer_colimator_4_blade_2_focus_xh;
MCNUM mccinter_analyzer_colimator_4_blade_2_focus_r;
MCNUM mccinter_analyzer_colimator_4_blade_2_p_interact;
char mccinter_analyzer_colimator_4_blade_2_mask_string[16384];
char mccinter_analyzer_colimator_4_blade_2_mask_setting[16384];
MCNUM mccinter_analyzer_colimator_4_blade_2_number_of_activations;

/* Setting parameters for component 'inter_analyzer_colimator_4_blade_3' [310]. */
char mccinter_analyzer_colimator_4_blade_3_material_string[16384];
MCNUM mccinter_analyzer_colimator_4_blade_3_priority;
MCNUM mccinter_analyzer_colimator_4_blade_3_xwidth;
MCNUM mccinter_analyzer_colimator_4_blade_3_yheight;
MCNUM mccinter_analyzer_colimator_4_blade_3_zdepth;
MCNUM mccinter_analyzer_colimator_4_blade_3_xwidth2;
MCNUM mccinter_analyzer_colimator_4_blade_3_yheight2;
MCNUM mccinter_analyzer_colimator_4_blade_3_visualize;
int mccinter_analyzer_colimator_4_blade_3_target_index;
MCNUM mccinter_analyzer_colimator_4_blade_3_target_x;
MCNUM mccinter_analyzer_colimator_4_blade_3_target_y;
MCNUM mccinter_analyzer_colimator_4_blade_3_target_z;
MCNUM mccinter_analyzer_colimator_4_blade_3_focus_aw;
MCNUM mccinter_analyzer_colimator_4_blade_3_focus_ah;
MCNUM mccinter_analyzer_colimator_4_blade_3_focus_xw;
MCNUM mccinter_analyzer_colimator_4_blade_3_focus_xh;
MCNUM mccinter_analyzer_colimator_4_blade_3_focus_r;
MCNUM mccinter_analyzer_colimator_4_blade_3_p_interact;
char mccinter_analyzer_colimator_4_blade_3_mask_string[16384];
char mccinter_analyzer_colimator_4_blade_3_mask_setting[16384];
MCNUM mccinter_analyzer_colimator_4_blade_3_number_of_activations;

/* Setting parameters for component 'inter_analyzer_colimator_4_blade_4' [311]. */
char mccinter_analyzer_colimator_4_blade_4_material_string[16384];
MCNUM mccinter_analyzer_colimator_4_blade_4_priority;
MCNUM mccinter_analyzer_colimator_4_blade_4_xwidth;
MCNUM mccinter_analyzer_colimator_4_blade_4_yheight;
MCNUM mccinter_analyzer_colimator_4_blade_4_zdepth;
MCNUM mccinter_analyzer_colimator_4_blade_4_xwidth2;
MCNUM mccinter_analyzer_colimator_4_blade_4_yheight2;
MCNUM mccinter_analyzer_colimator_4_blade_4_visualize;
int mccinter_analyzer_colimator_4_blade_4_target_index;
MCNUM mccinter_analyzer_colimator_4_blade_4_target_x;
MCNUM mccinter_analyzer_colimator_4_blade_4_target_y;
MCNUM mccinter_analyzer_colimator_4_blade_4_target_z;
MCNUM mccinter_analyzer_colimator_4_blade_4_focus_aw;
MCNUM mccinter_analyzer_colimator_4_blade_4_focus_ah;
MCNUM mccinter_analyzer_colimator_4_blade_4_focus_xw;
MCNUM mccinter_analyzer_colimator_4_blade_4_focus_xh;
MCNUM mccinter_analyzer_colimator_4_blade_4_focus_r;
MCNUM mccinter_analyzer_colimator_4_blade_4_p_interact;
char mccinter_analyzer_colimator_4_blade_4_mask_string[16384];
char mccinter_analyzer_colimator_4_blade_4_mask_setting[16384];
MCNUM mccinter_analyzer_colimator_4_blade_4_number_of_activations;

/* Setting parameters for component 'diffraction_detector_4_exit_volume' [312]. */
char mccdiffraction_detector_4_exit_volume_material_string[16384];
MCNUM mccdiffraction_detector_4_exit_volume_priority;
MCNUM mccdiffraction_detector_4_exit_volume_xwidth;
MCNUM mccdiffraction_detector_4_exit_volume_yheight;
MCNUM mccdiffraction_detector_4_exit_volume_zdepth;
MCNUM mccdiffraction_detector_4_exit_volume_xwidth2;
MCNUM mccdiffraction_detector_4_exit_volume_yheight2;
MCNUM mccdiffraction_detector_4_exit_volume_visualize;
int mccdiffraction_detector_4_exit_volume_target_index;
MCNUM mccdiffraction_detector_4_exit_volume_target_x;
MCNUM mccdiffraction_detector_4_exit_volume_target_y;
MCNUM mccdiffraction_detector_4_exit_volume_target_z;
MCNUM mccdiffraction_detector_4_exit_volume_focus_aw;
MCNUM mccdiffraction_detector_4_exit_volume_focus_ah;
MCNUM mccdiffraction_detector_4_exit_volume_focus_xw;
MCNUM mccdiffraction_detector_4_exit_volume_focus_xh;
MCNUM mccdiffraction_detector_4_exit_volume_focus_r;
MCNUM mccdiffraction_detector_4_exit_volume_p_interact;
char mccdiffraction_detector_4_exit_volume_mask_string[16384];
char mccdiffraction_detector_4_exit_volume_mask_setting[16384];
MCNUM mccdiffraction_detector_4_exit_volume_number_of_activations;

/* Setting parameters for component 'spec_detector_4_exit_volume' [313]. */
char mccspec_detector_4_exit_volume_material_string[16384];
MCNUM mccspec_detector_4_exit_volume_priority;
MCNUM mccspec_detector_4_exit_volume_xwidth;
MCNUM mccspec_detector_4_exit_volume_yheight;
MCNUM mccspec_detector_4_exit_volume_zdepth;
MCNUM mccspec_detector_4_exit_volume_xwidth2;
MCNUM mccspec_detector_4_exit_volume_yheight2;
MCNUM mccspec_detector_4_exit_volume_visualize;
int mccspec_detector_4_exit_volume_target_index;
MCNUM mccspec_detector_4_exit_volume_target_x;
MCNUM mccspec_detector_4_exit_volume_target_y;
MCNUM mccspec_detector_4_exit_volume_target_z;
MCNUM mccspec_detector_4_exit_volume_focus_aw;
MCNUM mccspec_detector_4_exit_volume_focus_ah;
MCNUM mccspec_detector_4_exit_volume_focus_xw;
MCNUM mccspec_detector_4_exit_volume_focus_xh;
MCNUM mccspec_detector_4_exit_volume_focus_r;
MCNUM mccspec_detector_4_exit_volume_p_interact;
char mccspec_detector_4_exit_volume_mask_string[16384];
char mccspec_detector_4_exit_volume_mask_setting[16384];
MCNUM mccspec_detector_4_exit_volume_number_of_activations;

/* Setting parameters for component 'channel_5_cave1_box1' [314]. */
char mccchannel_5_cave1_box1_material_string[16384];
MCNUM mccchannel_5_cave1_box1_priority;
MCNUM mccchannel_5_cave1_box1_xwidth;
MCNUM mccchannel_5_cave1_box1_yheight;
MCNUM mccchannel_5_cave1_box1_zdepth;
MCNUM mccchannel_5_cave1_box1_xwidth2;
MCNUM mccchannel_5_cave1_box1_yheight2;
MCNUM mccchannel_5_cave1_box1_visualize;
int mccchannel_5_cave1_box1_target_index;
MCNUM mccchannel_5_cave1_box1_target_x;
MCNUM mccchannel_5_cave1_box1_target_y;
MCNUM mccchannel_5_cave1_box1_target_z;
MCNUM mccchannel_5_cave1_box1_focus_aw;
MCNUM mccchannel_5_cave1_box1_focus_ah;
MCNUM mccchannel_5_cave1_box1_focus_xw;
MCNUM mccchannel_5_cave1_box1_focus_xh;
MCNUM mccchannel_5_cave1_box1_focus_r;
MCNUM mccchannel_5_cave1_box1_p_interact;
char mccchannel_5_cave1_box1_mask_string[16384];
char mccchannel_5_cave1_box1_mask_setting[16384];
MCNUM mccchannel_5_cave1_box1_number_of_activations;

/* Setting parameters for component 'channel_5_cave1_box2' [315]. */
char mccchannel_5_cave1_box2_material_string[16384];
MCNUM mccchannel_5_cave1_box2_priority;
MCNUM mccchannel_5_cave1_box2_xwidth;
MCNUM mccchannel_5_cave1_box2_yheight;
MCNUM mccchannel_5_cave1_box2_zdepth;
MCNUM mccchannel_5_cave1_box2_xwidth2;
MCNUM mccchannel_5_cave1_box2_yheight2;
MCNUM mccchannel_5_cave1_box2_visualize;
int mccchannel_5_cave1_box2_target_index;
MCNUM mccchannel_5_cave1_box2_target_x;
MCNUM mccchannel_5_cave1_box2_target_y;
MCNUM mccchannel_5_cave1_box2_target_z;
MCNUM mccchannel_5_cave1_box2_focus_aw;
MCNUM mccchannel_5_cave1_box2_focus_ah;
MCNUM mccchannel_5_cave1_box2_focus_xw;
MCNUM mccchannel_5_cave1_box2_focus_xh;
MCNUM mccchannel_5_cave1_box2_focus_r;
MCNUM mccchannel_5_cave1_box2_p_interact;
char mccchannel_5_cave1_box2_mask_string[16384];
char mccchannel_5_cave1_box2_mask_setting[16384];
MCNUM mccchannel_5_cave1_box2_number_of_activations;

/* Setting parameters for component 'channel_5_cave1_box3' [316]. */
char mccchannel_5_cave1_box3_material_string[16384];
MCNUM mccchannel_5_cave1_box3_priority;
MCNUM mccchannel_5_cave1_box3_xwidth;
MCNUM mccchannel_5_cave1_box3_yheight;
MCNUM mccchannel_5_cave1_box3_zdepth;
MCNUM mccchannel_5_cave1_box3_xwidth2;
MCNUM mccchannel_5_cave1_box3_yheight2;
MCNUM mccchannel_5_cave1_box3_visualize;
int mccchannel_5_cave1_box3_target_index;
MCNUM mccchannel_5_cave1_box3_target_x;
MCNUM mccchannel_5_cave1_box3_target_y;
MCNUM mccchannel_5_cave1_box3_target_z;
MCNUM mccchannel_5_cave1_box3_focus_aw;
MCNUM mccchannel_5_cave1_box3_focus_ah;
MCNUM mccchannel_5_cave1_box3_focus_xw;
MCNUM mccchannel_5_cave1_box3_focus_xh;
MCNUM mccchannel_5_cave1_box3_focus_r;
MCNUM mccchannel_5_cave1_box3_p_interact;
char mccchannel_5_cave1_box3_mask_string[16384];
char mccchannel_5_cave1_box3_mask_setting[16384];
MCNUM mccchannel_5_cave1_box3_number_of_activations;

/* Setting parameters for component 'channel_5_cave1_cyl1' [317]. */
char mccchannel_5_cave1_cyl1_material_string[16384];
MCNUM mccchannel_5_cave1_cyl1_priority;
MCNUM mccchannel_5_cave1_cyl1_radius;
MCNUM mccchannel_5_cave1_cyl1_yheight;
MCNUM mccchannel_5_cave1_cyl1_visualize;
int mccchannel_5_cave1_cyl1_target_index;
MCNUM mccchannel_5_cave1_cyl1_target_x;
MCNUM mccchannel_5_cave1_cyl1_target_y;
MCNUM mccchannel_5_cave1_cyl1_target_z;
MCNUM mccchannel_5_cave1_cyl1_focus_aw;
MCNUM mccchannel_5_cave1_cyl1_focus_ah;
MCNUM mccchannel_5_cave1_cyl1_focus_xw;
MCNUM mccchannel_5_cave1_cyl1_focus_xh;
MCNUM mccchannel_5_cave1_cyl1_focus_r;
MCNUM mccchannel_5_cave1_cyl1_p_interact;
char mccchannel_5_cave1_cyl1_mask_string[16384];
char mccchannel_5_cave1_cyl1_mask_setting[16384];
MCNUM mccchannel_5_cave1_cyl1_number_of_activations;

/* Setting parameters for component 'channel_5_analyzer_1_array_crystal_array_0' [320]. */
char mccchannel_5_analyzer_1_array_crystal_array_0_material_string[16384];
MCNUM mccchannel_5_analyzer_1_array_crystal_array_0_priority;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_0_xwidth;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_0_yheight;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_0_zdepth;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_0_xwidth2;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_0_yheight2;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_0_visualize;
int mccchannel_5_analyzer_1_array_crystal_array_0_target_index;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_0_target_x;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_0_target_y;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_0_target_z;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_0_focus_aw;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_0_focus_ah;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_0_focus_xw;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_0_focus_xh;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_0_focus_r;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_0_p_interact;
char mccchannel_5_analyzer_1_array_crystal_array_0_mask_string[16384];
char mccchannel_5_analyzer_1_array_crystal_array_0_mask_setting[16384];
MCNUM mccchannel_5_analyzer_1_array_crystal_array_0_number_of_activations;

/* Setting parameters for component 'channel_5_analyzer_1_array_crystal_array_1' [321]. */
char mccchannel_5_analyzer_1_array_crystal_array_1_material_string[16384];
MCNUM mccchannel_5_analyzer_1_array_crystal_array_1_priority;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_1_xwidth;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_1_yheight;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_1_zdepth;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_1_xwidth2;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_1_yheight2;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_1_visualize;
int mccchannel_5_analyzer_1_array_crystal_array_1_target_index;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_1_target_x;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_1_target_y;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_1_target_z;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_1_focus_aw;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_1_focus_ah;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_1_focus_xw;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_1_focus_xh;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_1_focus_r;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_1_p_interact;
char mccchannel_5_analyzer_1_array_crystal_array_1_mask_string[16384];
char mccchannel_5_analyzer_1_array_crystal_array_1_mask_setting[16384];
MCNUM mccchannel_5_analyzer_1_array_crystal_array_1_number_of_activations;

/* Setting parameters for component 'channel_5_analyzer_1_array_crystal_array_2' [322]. */
char mccchannel_5_analyzer_1_array_crystal_array_2_material_string[16384];
MCNUM mccchannel_5_analyzer_1_array_crystal_array_2_priority;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_2_xwidth;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_2_yheight;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_2_zdepth;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_2_xwidth2;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_2_yheight2;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_2_visualize;
int mccchannel_5_analyzer_1_array_crystal_array_2_target_index;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_2_target_x;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_2_target_y;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_2_target_z;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_2_focus_aw;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_2_focus_ah;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_2_focus_xw;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_2_focus_xh;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_2_focus_r;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_2_p_interact;
char mccchannel_5_analyzer_1_array_crystal_array_2_mask_string[16384];
char mccchannel_5_analyzer_1_array_crystal_array_2_mask_setting[16384];
MCNUM mccchannel_5_analyzer_1_array_crystal_array_2_number_of_activations;

/* Setting parameters for component 'channel_5_analyzer_1_array_crystal_array_3' [323]. */
char mccchannel_5_analyzer_1_array_crystal_array_3_material_string[16384];
MCNUM mccchannel_5_analyzer_1_array_crystal_array_3_priority;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_3_xwidth;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_3_yheight;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_3_zdepth;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_3_xwidth2;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_3_yheight2;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_3_visualize;
int mccchannel_5_analyzer_1_array_crystal_array_3_target_index;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_3_target_x;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_3_target_y;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_3_target_z;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_3_focus_aw;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_3_focus_ah;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_3_focus_xw;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_3_focus_xh;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_3_focus_r;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_3_p_interact;
char mccchannel_5_analyzer_1_array_crystal_array_3_mask_string[16384];
char mccchannel_5_analyzer_1_array_crystal_array_3_mask_setting[16384];
MCNUM mccchannel_5_analyzer_1_array_crystal_array_3_number_of_activations;

/* Setting parameters for component 'channel_5_analyzer_1_array_crystal_array_4' [324]. */
char mccchannel_5_analyzer_1_array_crystal_array_4_material_string[16384];
MCNUM mccchannel_5_analyzer_1_array_crystal_array_4_priority;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_4_xwidth;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_4_yheight;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_4_zdepth;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_4_xwidth2;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_4_yheight2;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_4_visualize;
int mccchannel_5_analyzer_1_array_crystal_array_4_target_index;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_4_target_x;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_4_target_y;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_4_target_z;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_4_focus_aw;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_4_focus_ah;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_4_focus_xw;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_4_focus_xh;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_4_focus_r;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_4_p_interact;
char mccchannel_5_analyzer_1_array_crystal_array_4_mask_string[16384];
char mccchannel_5_analyzer_1_array_crystal_array_4_mask_setting[16384];
MCNUM mccchannel_5_analyzer_1_array_crystal_array_4_number_of_activations;

/* Setting parameters for component 'channel_5_analyzer_1_array_crystal_array_5' [325]. */
char mccchannel_5_analyzer_1_array_crystal_array_5_material_string[16384];
MCNUM mccchannel_5_analyzer_1_array_crystal_array_5_priority;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_5_xwidth;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_5_yheight;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_5_zdepth;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_5_xwidth2;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_5_yheight2;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_5_visualize;
int mccchannel_5_analyzer_1_array_crystal_array_5_target_index;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_5_target_x;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_5_target_y;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_5_target_z;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_5_focus_aw;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_5_focus_ah;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_5_focus_xw;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_5_focus_xh;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_5_focus_r;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_5_p_interact;
char mccchannel_5_analyzer_1_array_crystal_array_5_mask_string[16384];
char mccchannel_5_analyzer_1_array_crystal_array_5_mask_setting[16384];
MCNUM mccchannel_5_analyzer_1_array_crystal_array_5_number_of_activations;

/* Setting parameters for component 'channel_5_analyzer_1_array_crystal_array_6' [326]. */
char mccchannel_5_analyzer_1_array_crystal_array_6_material_string[16384];
MCNUM mccchannel_5_analyzer_1_array_crystal_array_6_priority;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_6_xwidth;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_6_yheight;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_6_zdepth;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_6_xwidth2;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_6_yheight2;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_6_visualize;
int mccchannel_5_analyzer_1_array_crystal_array_6_target_index;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_6_target_x;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_6_target_y;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_6_target_z;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_6_focus_aw;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_6_focus_ah;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_6_focus_xw;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_6_focus_xh;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_6_focus_r;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_6_p_interact;
char mccchannel_5_analyzer_1_array_crystal_array_6_mask_string[16384];
char mccchannel_5_analyzer_1_array_crystal_array_6_mask_setting[16384];
MCNUM mccchannel_5_analyzer_1_array_crystal_array_6_number_of_activations;

/* Setting parameters for component 'channel_5_analyzer_1_array_crystal_array_7' [327]. */
char mccchannel_5_analyzer_1_array_crystal_array_7_material_string[16384];
MCNUM mccchannel_5_analyzer_1_array_crystal_array_7_priority;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_7_xwidth;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_7_yheight;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_7_zdepth;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_7_xwidth2;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_7_yheight2;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_7_visualize;
int mccchannel_5_analyzer_1_array_crystal_array_7_target_index;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_7_target_x;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_7_target_y;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_7_target_z;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_7_focus_aw;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_7_focus_ah;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_7_focus_xw;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_7_focus_xh;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_7_focus_r;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_7_p_interact;
char mccchannel_5_analyzer_1_array_crystal_array_7_mask_string[16384];
char mccchannel_5_analyzer_1_array_crystal_array_7_mask_setting[16384];
MCNUM mccchannel_5_analyzer_1_array_crystal_array_7_number_of_activations;

/* Setting parameters for component 'channel_5_analyzer_1_array_crystal_array_8' [328]. */
char mccchannel_5_analyzer_1_array_crystal_array_8_material_string[16384];
MCNUM mccchannel_5_analyzer_1_array_crystal_array_8_priority;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_8_xwidth;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_8_yheight;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_8_zdepth;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_8_xwidth2;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_8_yheight2;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_8_visualize;
int mccchannel_5_analyzer_1_array_crystal_array_8_target_index;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_8_target_x;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_8_target_y;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_8_target_z;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_8_focus_aw;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_8_focus_ah;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_8_focus_xw;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_8_focus_xh;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_8_focus_r;
MCNUM mccchannel_5_analyzer_1_array_crystal_array_8_p_interact;
char mccchannel_5_analyzer_1_array_crystal_array_8_mask_string[16384];
char mccchannel_5_analyzer_1_array_crystal_array_8_mask_setting[16384];
MCNUM mccchannel_5_analyzer_1_array_crystal_array_8_number_of_activations;

/* Setting parameters for component 'channel_5_analyzer_2_array_crystal_array_0' [331]. */
char mccchannel_5_analyzer_2_array_crystal_array_0_material_string[16384];
MCNUM mccchannel_5_analyzer_2_array_crystal_array_0_priority;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_0_xwidth;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_0_yheight;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_0_zdepth;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_0_xwidth2;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_0_yheight2;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_0_visualize;
int mccchannel_5_analyzer_2_array_crystal_array_0_target_index;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_0_target_x;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_0_target_y;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_0_target_z;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_0_focus_aw;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_0_focus_ah;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_0_focus_xw;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_0_focus_xh;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_0_focus_r;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_0_p_interact;
char mccchannel_5_analyzer_2_array_crystal_array_0_mask_string[16384];
char mccchannel_5_analyzer_2_array_crystal_array_0_mask_setting[16384];
MCNUM mccchannel_5_analyzer_2_array_crystal_array_0_number_of_activations;

/* Setting parameters for component 'channel_5_analyzer_2_array_crystal_array_1' [332]. */
char mccchannel_5_analyzer_2_array_crystal_array_1_material_string[16384];
MCNUM mccchannel_5_analyzer_2_array_crystal_array_1_priority;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_1_xwidth;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_1_yheight;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_1_zdepth;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_1_xwidth2;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_1_yheight2;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_1_visualize;
int mccchannel_5_analyzer_2_array_crystal_array_1_target_index;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_1_target_x;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_1_target_y;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_1_target_z;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_1_focus_aw;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_1_focus_ah;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_1_focus_xw;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_1_focus_xh;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_1_focus_r;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_1_p_interact;
char mccchannel_5_analyzer_2_array_crystal_array_1_mask_string[16384];
char mccchannel_5_analyzer_2_array_crystal_array_1_mask_setting[16384];
MCNUM mccchannel_5_analyzer_2_array_crystal_array_1_number_of_activations;

/* Setting parameters for component 'channel_5_analyzer_2_array_crystal_array_2' [333]. */
char mccchannel_5_analyzer_2_array_crystal_array_2_material_string[16384];
MCNUM mccchannel_5_analyzer_2_array_crystal_array_2_priority;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_2_xwidth;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_2_yheight;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_2_zdepth;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_2_xwidth2;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_2_yheight2;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_2_visualize;
int mccchannel_5_analyzer_2_array_crystal_array_2_target_index;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_2_target_x;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_2_target_y;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_2_target_z;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_2_focus_aw;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_2_focus_ah;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_2_focus_xw;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_2_focus_xh;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_2_focus_r;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_2_p_interact;
char mccchannel_5_analyzer_2_array_crystal_array_2_mask_string[16384];
char mccchannel_5_analyzer_2_array_crystal_array_2_mask_setting[16384];
MCNUM mccchannel_5_analyzer_2_array_crystal_array_2_number_of_activations;

/* Setting parameters for component 'channel_5_analyzer_2_array_crystal_array_3' [334]. */
char mccchannel_5_analyzer_2_array_crystal_array_3_material_string[16384];
MCNUM mccchannel_5_analyzer_2_array_crystal_array_3_priority;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_3_xwidth;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_3_yheight;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_3_zdepth;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_3_xwidth2;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_3_yheight2;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_3_visualize;
int mccchannel_5_analyzer_2_array_crystal_array_3_target_index;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_3_target_x;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_3_target_y;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_3_target_z;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_3_focus_aw;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_3_focus_ah;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_3_focus_xw;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_3_focus_xh;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_3_focus_r;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_3_p_interact;
char mccchannel_5_analyzer_2_array_crystal_array_3_mask_string[16384];
char mccchannel_5_analyzer_2_array_crystal_array_3_mask_setting[16384];
MCNUM mccchannel_5_analyzer_2_array_crystal_array_3_number_of_activations;

/* Setting parameters for component 'channel_5_analyzer_2_array_crystal_array_4' [335]. */
char mccchannel_5_analyzer_2_array_crystal_array_4_material_string[16384];
MCNUM mccchannel_5_analyzer_2_array_crystal_array_4_priority;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_4_xwidth;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_4_yheight;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_4_zdepth;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_4_xwidth2;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_4_yheight2;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_4_visualize;
int mccchannel_5_analyzer_2_array_crystal_array_4_target_index;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_4_target_x;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_4_target_y;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_4_target_z;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_4_focus_aw;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_4_focus_ah;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_4_focus_xw;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_4_focus_xh;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_4_focus_r;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_4_p_interact;
char mccchannel_5_analyzer_2_array_crystal_array_4_mask_string[16384];
char mccchannel_5_analyzer_2_array_crystal_array_4_mask_setting[16384];
MCNUM mccchannel_5_analyzer_2_array_crystal_array_4_number_of_activations;

/* Setting parameters for component 'channel_5_analyzer_2_array_crystal_array_5' [336]. */
char mccchannel_5_analyzer_2_array_crystal_array_5_material_string[16384];
MCNUM mccchannel_5_analyzer_2_array_crystal_array_5_priority;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_5_xwidth;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_5_yheight;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_5_zdepth;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_5_xwidth2;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_5_yheight2;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_5_visualize;
int mccchannel_5_analyzer_2_array_crystal_array_5_target_index;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_5_target_x;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_5_target_y;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_5_target_z;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_5_focus_aw;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_5_focus_ah;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_5_focus_xw;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_5_focus_xh;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_5_focus_r;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_5_p_interact;
char mccchannel_5_analyzer_2_array_crystal_array_5_mask_string[16384];
char mccchannel_5_analyzer_2_array_crystal_array_5_mask_setting[16384];
MCNUM mccchannel_5_analyzer_2_array_crystal_array_5_number_of_activations;

/* Setting parameters for component 'channel_5_analyzer_2_array_crystal_array_6' [337]. */
char mccchannel_5_analyzer_2_array_crystal_array_6_material_string[16384];
MCNUM mccchannel_5_analyzer_2_array_crystal_array_6_priority;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_6_xwidth;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_6_yheight;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_6_zdepth;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_6_xwidth2;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_6_yheight2;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_6_visualize;
int mccchannel_5_analyzer_2_array_crystal_array_6_target_index;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_6_target_x;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_6_target_y;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_6_target_z;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_6_focus_aw;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_6_focus_ah;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_6_focus_xw;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_6_focus_xh;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_6_focus_r;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_6_p_interact;
char mccchannel_5_analyzer_2_array_crystal_array_6_mask_string[16384];
char mccchannel_5_analyzer_2_array_crystal_array_6_mask_setting[16384];
MCNUM mccchannel_5_analyzer_2_array_crystal_array_6_number_of_activations;

/* Setting parameters for component 'channel_5_analyzer_2_array_crystal_array_7' [338]. */
char mccchannel_5_analyzer_2_array_crystal_array_7_material_string[16384];
MCNUM mccchannel_5_analyzer_2_array_crystal_array_7_priority;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_7_xwidth;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_7_yheight;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_7_zdepth;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_7_xwidth2;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_7_yheight2;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_7_visualize;
int mccchannel_5_analyzer_2_array_crystal_array_7_target_index;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_7_target_x;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_7_target_y;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_7_target_z;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_7_focus_aw;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_7_focus_ah;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_7_focus_xw;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_7_focus_xh;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_7_focus_r;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_7_p_interact;
char mccchannel_5_analyzer_2_array_crystal_array_7_mask_string[16384];
char mccchannel_5_analyzer_2_array_crystal_array_7_mask_setting[16384];
MCNUM mccchannel_5_analyzer_2_array_crystal_array_7_number_of_activations;

/* Setting parameters for component 'channel_5_analyzer_2_array_crystal_array_8' [339]. */
char mccchannel_5_analyzer_2_array_crystal_array_8_material_string[16384];
MCNUM mccchannel_5_analyzer_2_array_crystal_array_8_priority;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_8_xwidth;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_8_yheight;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_8_zdepth;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_8_xwidth2;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_8_yheight2;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_8_visualize;
int mccchannel_5_analyzer_2_array_crystal_array_8_target_index;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_8_target_x;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_8_target_y;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_8_target_z;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_8_focus_aw;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_8_focus_ah;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_8_focus_xw;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_8_focus_xh;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_8_focus_r;
MCNUM mccchannel_5_analyzer_2_array_crystal_array_8_p_interact;
char mccchannel_5_analyzer_2_array_crystal_array_8_mask_string[16384];
char mccchannel_5_analyzer_2_array_crystal_array_8_mask_setting[16384];
MCNUM mccchannel_5_analyzer_2_array_crystal_array_8_number_of_activations;

/* Setting parameters for component 'channel_5_cave2_cyl1' [340]. */
char mccchannel_5_cave2_cyl1_material_string[16384];
MCNUM mccchannel_5_cave2_cyl1_priority;
MCNUM mccchannel_5_cave2_cyl1_radius;
MCNUM mccchannel_5_cave2_cyl1_yheight;
MCNUM mccchannel_5_cave2_cyl1_visualize;
int mccchannel_5_cave2_cyl1_target_index;
MCNUM mccchannel_5_cave2_cyl1_target_x;
MCNUM mccchannel_5_cave2_cyl1_target_y;
MCNUM mccchannel_5_cave2_cyl1_target_z;
MCNUM mccchannel_5_cave2_cyl1_focus_aw;
MCNUM mccchannel_5_cave2_cyl1_focus_ah;
MCNUM mccchannel_5_cave2_cyl1_focus_xw;
MCNUM mccchannel_5_cave2_cyl1_focus_xh;
MCNUM mccchannel_5_cave2_cyl1_focus_r;
MCNUM mccchannel_5_cave2_cyl1_p_interact;
char mccchannel_5_cave2_cyl1_mask_string[16384];
char mccchannel_5_cave2_cyl1_mask_setting[16384];
MCNUM mccchannel_5_cave2_cyl1_number_of_activations;

/* Setting parameters for component 'channel_5_cave2_box1' [341]. */
char mccchannel_5_cave2_box1_material_string[16384];
MCNUM mccchannel_5_cave2_box1_priority;
MCNUM mccchannel_5_cave2_box1_xwidth;
MCNUM mccchannel_5_cave2_box1_yheight;
MCNUM mccchannel_5_cave2_box1_zdepth;
MCNUM mccchannel_5_cave2_box1_xwidth2;
MCNUM mccchannel_5_cave2_box1_yheight2;
MCNUM mccchannel_5_cave2_box1_visualize;
int mccchannel_5_cave2_box1_target_index;
MCNUM mccchannel_5_cave2_box1_target_x;
MCNUM mccchannel_5_cave2_box1_target_y;
MCNUM mccchannel_5_cave2_box1_target_z;
MCNUM mccchannel_5_cave2_box1_focus_aw;
MCNUM mccchannel_5_cave2_box1_focus_ah;
MCNUM mccchannel_5_cave2_box1_focus_xw;
MCNUM mccchannel_5_cave2_box1_focus_xh;
MCNUM mccchannel_5_cave2_box1_focus_r;
MCNUM mccchannel_5_cave2_box1_p_interact;
char mccchannel_5_cave2_box1_mask_string[16384];
char mccchannel_5_cave2_box1_mask_setting[16384];
MCNUM mccchannel_5_cave2_box1_number_of_activations;

/* Setting parameters for component 'channel_5_cave2_box2' [342]. */
char mccchannel_5_cave2_box2_material_string[16384];
MCNUM mccchannel_5_cave2_box2_priority;
MCNUM mccchannel_5_cave2_box2_xwidth;
MCNUM mccchannel_5_cave2_box2_yheight;
MCNUM mccchannel_5_cave2_box2_zdepth;
MCNUM mccchannel_5_cave2_box2_xwidth2;
MCNUM mccchannel_5_cave2_box2_yheight2;
MCNUM mccchannel_5_cave2_box2_visualize;
int mccchannel_5_cave2_box2_target_index;
MCNUM mccchannel_5_cave2_box2_target_x;
MCNUM mccchannel_5_cave2_box2_target_y;
MCNUM mccchannel_5_cave2_box2_target_z;
MCNUM mccchannel_5_cave2_box2_focus_aw;
MCNUM mccchannel_5_cave2_box2_focus_ah;
MCNUM mccchannel_5_cave2_box2_focus_xw;
MCNUM mccchannel_5_cave2_box2_focus_xh;
MCNUM mccchannel_5_cave2_box2_focus_r;
MCNUM mccchannel_5_cave2_box2_p_interact;
char mccchannel_5_cave2_box2_mask_string[16384];
char mccchannel_5_cave2_box2_mask_setting[16384];
MCNUM mccchannel_5_cave2_box2_number_of_activations;

/* Setting parameters for component 'channel_5_cave2_box3' [343]. */
char mccchannel_5_cave2_box3_material_string[16384];
MCNUM mccchannel_5_cave2_box3_priority;
MCNUM mccchannel_5_cave2_box3_xwidth;
MCNUM mccchannel_5_cave2_box3_yheight;
MCNUM mccchannel_5_cave2_box3_zdepth;
MCNUM mccchannel_5_cave2_box3_xwidth2;
MCNUM mccchannel_5_cave2_box3_yheight2;
MCNUM mccchannel_5_cave2_box3_visualize;
int mccchannel_5_cave2_box3_target_index;
MCNUM mccchannel_5_cave2_box3_target_x;
MCNUM mccchannel_5_cave2_box3_target_y;
MCNUM mccchannel_5_cave2_box3_target_z;
MCNUM mccchannel_5_cave2_box3_focus_aw;
MCNUM mccchannel_5_cave2_box3_focus_ah;
MCNUM mccchannel_5_cave2_box3_focus_xw;
MCNUM mccchannel_5_cave2_box3_focus_xh;
MCNUM mccchannel_5_cave2_box3_focus_r;
MCNUM mccchannel_5_cave2_box3_p_interact;
char mccchannel_5_cave2_box3_mask_string[16384];
char mccchannel_5_cave2_box3_mask_setting[16384];
MCNUM mccchannel_5_cave2_box3_number_of_activations;

/* Setting parameters for component 'inter_analyzer_colimator_5_blade_0' [345]. */
char mccinter_analyzer_colimator_5_blade_0_material_string[16384];
MCNUM mccinter_analyzer_colimator_5_blade_0_priority;
MCNUM mccinter_analyzer_colimator_5_blade_0_xwidth;
MCNUM mccinter_analyzer_colimator_5_blade_0_yheight;
MCNUM mccinter_analyzer_colimator_5_blade_0_zdepth;
MCNUM mccinter_analyzer_colimator_5_blade_0_xwidth2;
MCNUM mccinter_analyzer_colimator_5_blade_0_yheight2;
MCNUM mccinter_analyzer_colimator_5_blade_0_visualize;
int mccinter_analyzer_colimator_5_blade_0_target_index;
MCNUM mccinter_analyzer_colimator_5_blade_0_target_x;
MCNUM mccinter_analyzer_colimator_5_blade_0_target_y;
MCNUM mccinter_analyzer_colimator_5_blade_0_target_z;
MCNUM mccinter_analyzer_colimator_5_blade_0_focus_aw;
MCNUM mccinter_analyzer_colimator_5_blade_0_focus_ah;
MCNUM mccinter_analyzer_colimator_5_blade_0_focus_xw;
MCNUM mccinter_analyzer_colimator_5_blade_0_focus_xh;
MCNUM mccinter_analyzer_colimator_5_blade_0_focus_r;
MCNUM mccinter_analyzer_colimator_5_blade_0_p_interact;
char mccinter_analyzer_colimator_5_blade_0_mask_string[16384];
char mccinter_analyzer_colimator_5_blade_0_mask_setting[16384];
MCNUM mccinter_analyzer_colimator_5_blade_0_number_of_activations;

/* Setting parameters for component 'inter_analyzer_colimator_5_blade_1' [346]. */
char mccinter_analyzer_colimator_5_blade_1_material_string[16384];
MCNUM mccinter_analyzer_colimator_5_blade_1_priority;
MCNUM mccinter_analyzer_colimator_5_blade_1_xwidth;
MCNUM mccinter_analyzer_colimator_5_blade_1_yheight;
MCNUM mccinter_analyzer_colimator_5_blade_1_zdepth;
MCNUM mccinter_analyzer_colimator_5_blade_1_xwidth2;
MCNUM mccinter_analyzer_colimator_5_blade_1_yheight2;
MCNUM mccinter_analyzer_colimator_5_blade_1_visualize;
int mccinter_analyzer_colimator_5_blade_1_target_index;
MCNUM mccinter_analyzer_colimator_5_blade_1_target_x;
MCNUM mccinter_analyzer_colimator_5_blade_1_target_y;
MCNUM mccinter_analyzer_colimator_5_blade_1_target_z;
MCNUM mccinter_analyzer_colimator_5_blade_1_focus_aw;
MCNUM mccinter_analyzer_colimator_5_blade_1_focus_ah;
MCNUM mccinter_analyzer_colimator_5_blade_1_focus_xw;
MCNUM mccinter_analyzer_colimator_5_blade_1_focus_xh;
MCNUM mccinter_analyzer_colimator_5_blade_1_focus_r;
MCNUM mccinter_analyzer_colimator_5_blade_1_p_interact;
char mccinter_analyzer_colimator_5_blade_1_mask_string[16384];
char mccinter_analyzer_colimator_5_blade_1_mask_setting[16384];
MCNUM mccinter_analyzer_colimator_5_blade_1_number_of_activations;

/* Setting parameters for component 'inter_analyzer_colimator_5_blade_2' [347]. */
char mccinter_analyzer_colimator_5_blade_2_material_string[16384];
MCNUM mccinter_analyzer_colimator_5_blade_2_priority;
MCNUM mccinter_analyzer_colimator_5_blade_2_xwidth;
MCNUM mccinter_analyzer_colimator_5_blade_2_yheight;
MCNUM mccinter_analyzer_colimator_5_blade_2_zdepth;
MCNUM mccinter_analyzer_colimator_5_blade_2_xwidth2;
MCNUM mccinter_analyzer_colimator_5_blade_2_yheight2;
MCNUM mccinter_analyzer_colimator_5_blade_2_visualize;
int mccinter_analyzer_colimator_5_blade_2_target_index;
MCNUM mccinter_analyzer_colimator_5_blade_2_target_x;
MCNUM mccinter_analyzer_colimator_5_blade_2_target_y;
MCNUM mccinter_analyzer_colimator_5_blade_2_target_z;
MCNUM mccinter_analyzer_colimator_5_blade_2_focus_aw;
MCNUM mccinter_analyzer_colimator_5_blade_2_focus_ah;
MCNUM mccinter_analyzer_colimator_5_blade_2_focus_xw;
MCNUM mccinter_analyzer_colimator_5_blade_2_focus_xh;
MCNUM mccinter_analyzer_colimator_5_blade_2_focus_r;
MCNUM mccinter_analyzer_colimator_5_blade_2_p_interact;
char mccinter_analyzer_colimator_5_blade_2_mask_string[16384];
char mccinter_analyzer_colimator_5_blade_2_mask_setting[16384];
MCNUM mccinter_analyzer_colimator_5_blade_2_number_of_activations;

/* Setting parameters for component 'inter_analyzer_colimator_5_blade_3' [348]. */
char mccinter_analyzer_colimator_5_blade_3_material_string[16384];
MCNUM mccinter_analyzer_colimator_5_blade_3_priority;
MCNUM mccinter_analyzer_colimator_5_blade_3_xwidth;
MCNUM mccinter_analyzer_colimator_5_blade_3_yheight;
MCNUM mccinter_analyzer_colimator_5_blade_3_zdepth;
MCNUM mccinter_analyzer_colimator_5_blade_3_xwidth2;
MCNUM mccinter_analyzer_colimator_5_blade_3_yheight2;
MCNUM mccinter_analyzer_colimator_5_blade_3_visualize;
int mccinter_analyzer_colimator_5_blade_3_target_index;
MCNUM mccinter_analyzer_colimator_5_blade_3_target_x;
MCNUM mccinter_analyzer_colimator_5_blade_3_target_y;
MCNUM mccinter_analyzer_colimator_5_blade_3_target_z;
MCNUM mccinter_analyzer_colimator_5_blade_3_focus_aw;
MCNUM mccinter_analyzer_colimator_5_blade_3_focus_ah;
MCNUM mccinter_analyzer_colimator_5_blade_3_focus_xw;
MCNUM mccinter_analyzer_colimator_5_blade_3_focus_xh;
MCNUM mccinter_analyzer_colimator_5_blade_3_focus_r;
MCNUM mccinter_analyzer_colimator_5_blade_3_p_interact;
char mccinter_analyzer_colimator_5_blade_3_mask_string[16384];
char mccinter_analyzer_colimator_5_blade_3_mask_setting[16384];
MCNUM mccinter_analyzer_colimator_5_blade_3_number_of_activations;

/* Setting parameters for component 'inter_analyzer_colimator_5_blade_4' [349]. */
char mccinter_analyzer_colimator_5_blade_4_material_string[16384];
MCNUM mccinter_analyzer_colimator_5_blade_4_priority;
MCNUM mccinter_analyzer_colimator_5_blade_4_xwidth;
MCNUM mccinter_analyzer_colimator_5_blade_4_yheight;
MCNUM mccinter_analyzer_colimator_5_blade_4_zdepth;
MCNUM mccinter_analyzer_colimator_5_blade_4_xwidth2;
MCNUM mccinter_analyzer_colimator_5_blade_4_yheight2;
MCNUM mccinter_analyzer_colimator_5_blade_4_visualize;
int mccinter_analyzer_colimator_5_blade_4_target_index;
MCNUM mccinter_analyzer_colimator_5_blade_4_target_x;
MCNUM mccinter_analyzer_colimator_5_blade_4_target_y;
MCNUM mccinter_analyzer_colimator_5_blade_4_target_z;
MCNUM mccinter_analyzer_colimator_5_blade_4_focus_aw;
MCNUM mccinter_analyzer_colimator_5_blade_4_focus_ah;
MCNUM mccinter_analyzer_colimator_5_blade_4_focus_xw;
MCNUM mccinter_analyzer_colimator_5_blade_4_focus_xh;
MCNUM mccinter_analyzer_colimator_5_blade_4_focus_r;
MCNUM mccinter_analyzer_colimator_5_blade_4_p_interact;
char mccinter_analyzer_colimator_5_blade_4_mask_string[16384];
char mccinter_analyzer_colimator_5_blade_4_mask_setting[16384];
MCNUM mccinter_analyzer_colimator_5_blade_4_number_of_activations;

/* Setting parameters for component 'diffraction_detector_5_exit_volume' [350]. */
char mccdiffraction_detector_5_exit_volume_material_string[16384];
MCNUM mccdiffraction_detector_5_exit_volume_priority;
MCNUM mccdiffraction_detector_5_exit_volume_xwidth;
MCNUM mccdiffraction_detector_5_exit_volume_yheight;
MCNUM mccdiffraction_detector_5_exit_volume_zdepth;
MCNUM mccdiffraction_detector_5_exit_volume_xwidth2;
MCNUM mccdiffraction_detector_5_exit_volume_yheight2;
MCNUM mccdiffraction_detector_5_exit_volume_visualize;
int mccdiffraction_detector_5_exit_volume_target_index;
MCNUM mccdiffraction_detector_5_exit_volume_target_x;
MCNUM mccdiffraction_detector_5_exit_volume_target_y;
MCNUM mccdiffraction_detector_5_exit_volume_target_z;
MCNUM mccdiffraction_detector_5_exit_volume_focus_aw;
MCNUM mccdiffraction_detector_5_exit_volume_focus_ah;
MCNUM mccdiffraction_detector_5_exit_volume_focus_xw;
MCNUM mccdiffraction_detector_5_exit_volume_focus_xh;
MCNUM mccdiffraction_detector_5_exit_volume_focus_r;
MCNUM mccdiffraction_detector_5_exit_volume_p_interact;
char mccdiffraction_detector_5_exit_volume_mask_string[16384];
char mccdiffraction_detector_5_exit_volume_mask_setting[16384];
MCNUM mccdiffraction_detector_5_exit_volume_number_of_activations;

/* Setting parameters for component 'spec_detector_5_exit_volume' [351]. */
char mccspec_detector_5_exit_volume_material_string[16384];
MCNUM mccspec_detector_5_exit_volume_priority;
MCNUM mccspec_detector_5_exit_volume_xwidth;
MCNUM mccspec_detector_5_exit_volume_yheight;
MCNUM mccspec_detector_5_exit_volume_zdepth;
MCNUM mccspec_detector_5_exit_volume_xwidth2;
MCNUM mccspec_detector_5_exit_volume_yheight2;
MCNUM mccspec_detector_5_exit_volume_visualize;
int mccspec_detector_5_exit_volume_target_index;
MCNUM mccspec_detector_5_exit_volume_target_x;
MCNUM mccspec_detector_5_exit_volume_target_y;
MCNUM mccspec_detector_5_exit_volume_target_z;
MCNUM mccspec_detector_5_exit_volume_focus_aw;
MCNUM mccspec_detector_5_exit_volume_focus_ah;
MCNUM mccspec_detector_5_exit_volume_focus_xw;
MCNUM mccspec_detector_5_exit_volume_focus_xh;
MCNUM mccspec_detector_5_exit_volume_focus_r;
MCNUM mccspec_detector_5_exit_volume_p_interact;
char mccspec_detector_5_exit_volume_mask_string[16384];
char mccspec_detector_5_exit_volume_mask_setting[16384];
MCNUM mccspec_detector_5_exit_volume_number_of_activations;

/* Setting parameters for component 'channel_6_cave1_box1' [352]. */
char mccchannel_6_cave1_box1_material_string[16384];
MCNUM mccchannel_6_cave1_box1_priority;
MCNUM mccchannel_6_cave1_box1_xwidth;
MCNUM mccchannel_6_cave1_box1_yheight;
MCNUM mccchannel_6_cave1_box1_zdepth;
MCNUM mccchannel_6_cave1_box1_xwidth2;
MCNUM mccchannel_6_cave1_box1_yheight2;
MCNUM mccchannel_6_cave1_box1_visualize;
int mccchannel_6_cave1_box1_target_index;
MCNUM mccchannel_6_cave1_box1_target_x;
MCNUM mccchannel_6_cave1_box1_target_y;
MCNUM mccchannel_6_cave1_box1_target_z;
MCNUM mccchannel_6_cave1_box1_focus_aw;
MCNUM mccchannel_6_cave1_box1_focus_ah;
MCNUM mccchannel_6_cave1_box1_focus_xw;
MCNUM mccchannel_6_cave1_box1_focus_xh;
MCNUM mccchannel_6_cave1_box1_focus_r;
MCNUM mccchannel_6_cave1_box1_p_interact;
char mccchannel_6_cave1_box1_mask_string[16384];
char mccchannel_6_cave1_box1_mask_setting[16384];
MCNUM mccchannel_6_cave1_box1_number_of_activations;

/* Setting parameters for component 'channel_6_cave1_box2' [353]. */
char mccchannel_6_cave1_box2_material_string[16384];
MCNUM mccchannel_6_cave1_box2_priority;
MCNUM mccchannel_6_cave1_box2_xwidth;
MCNUM mccchannel_6_cave1_box2_yheight;
MCNUM mccchannel_6_cave1_box2_zdepth;
MCNUM mccchannel_6_cave1_box2_xwidth2;
MCNUM mccchannel_6_cave1_box2_yheight2;
MCNUM mccchannel_6_cave1_box2_visualize;
int mccchannel_6_cave1_box2_target_index;
MCNUM mccchannel_6_cave1_box2_target_x;
MCNUM mccchannel_6_cave1_box2_target_y;
MCNUM mccchannel_6_cave1_box2_target_z;
MCNUM mccchannel_6_cave1_box2_focus_aw;
MCNUM mccchannel_6_cave1_box2_focus_ah;
MCNUM mccchannel_6_cave1_box2_focus_xw;
MCNUM mccchannel_6_cave1_box2_focus_xh;
MCNUM mccchannel_6_cave1_box2_focus_r;
MCNUM mccchannel_6_cave1_box2_p_interact;
char mccchannel_6_cave1_box2_mask_string[16384];
char mccchannel_6_cave1_box2_mask_setting[16384];
MCNUM mccchannel_6_cave1_box2_number_of_activations;

/* Setting parameters for component 'channel_6_cave1_box3' [354]. */
char mccchannel_6_cave1_box3_material_string[16384];
MCNUM mccchannel_6_cave1_box3_priority;
MCNUM mccchannel_6_cave1_box3_xwidth;
MCNUM mccchannel_6_cave1_box3_yheight;
MCNUM mccchannel_6_cave1_box3_zdepth;
MCNUM mccchannel_6_cave1_box3_xwidth2;
MCNUM mccchannel_6_cave1_box3_yheight2;
MCNUM mccchannel_6_cave1_box3_visualize;
int mccchannel_6_cave1_box3_target_index;
MCNUM mccchannel_6_cave1_box3_target_x;
MCNUM mccchannel_6_cave1_box3_target_y;
MCNUM mccchannel_6_cave1_box3_target_z;
MCNUM mccchannel_6_cave1_box3_focus_aw;
MCNUM mccchannel_6_cave1_box3_focus_ah;
MCNUM mccchannel_6_cave1_box3_focus_xw;
MCNUM mccchannel_6_cave1_box3_focus_xh;
MCNUM mccchannel_6_cave1_box3_focus_r;
MCNUM mccchannel_6_cave1_box3_p_interact;
char mccchannel_6_cave1_box3_mask_string[16384];
char mccchannel_6_cave1_box3_mask_setting[16384];
MCNUM mccchannel_6_cave1_box3_number_of_activations;

/* Setting parameters for component 'channel_6_cave1_cyl1' [355]. */
char mccchannel_6_cave1_cyl1_material_string[16384];
MCNUM mccchannel_6_cave1_cyl1_priority;
MCNUM mccchannel_6_cave1_cyl1_radius;
MCNUM mccchannel_6_cave1_cyl1_yheight;
MCNUM mccchannel_6_cave1_cyl1_visualize;
int mccchannel_6_cave1_cyl1_target_index;
MCNUM mccchannel_6_cave1_cyl1_target_x;
MCNUM mccchannel_6_cave1_cyl1_target_y;
MCNUM mccchannel_6_cave1_cyl1_target_z;
MCNUM mccchannel_6_cave1_cyl1_focus_aw;
MCNUM mccchannel_6_cave1_cyl1_focus_ah;
MCNUM mccchannel_6_cave1_cyl1_focus_xw;
MCNUM mccchannel_6_cave1_cyl1_focus_xh;
MCNUM mccchannel_6_cave1_cyl1_focus_r;
MCNUM mccchannel_6_cave1_cyl1_p_interact;
char mccchannel_6_cave1_cyl1_mask_string[16384];
char mccchannel_6_cave1_cyl1_mask_setting[16384];
MCNUM mccchannel_6_cave1_cyl1_number_of_activations;

/* Setting parameters for component 'channel_6_analyzer_1_array_crystal_array_0' [358]. */
char mccchannel_6_analyzer_1_array_crystal_array_0_material_string[16384];
MCNUM mccchannel_6_analyzer_1_array_crystal_array_0_priority;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_0_xwidth;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_0_yheight;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_0_zdepth;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_0_xwidth2;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_0_yheight2;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_0_visualize;
int mccchannel_6_analyzer_1_array_crystal_array_0_target_index;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_0_target_x;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_0_target_y;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_0_target_z;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_0_focus_aw;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_0_focus_ah;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_0_focus_xw;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_0_focus_xh;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_0_focus_r;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_0_p_interact;
char mccchannel_6_analyzer_1_array_crystal_array_0_mask_string[16384];
char mccchannel_6_analyzer_1_array_crystal_array_0_mask_setting[16384];
MCNUM mccchannel_6_analyzer_1_array_crystal_array_0_number_of_activations;

/* Setting parameters for component 'channel_6_analyzer_1_array_crystal_array_1' [359]. */
char mccchannel_6_analyzer_1_array_crystal_array_1_material_string[16384];
MCNUM mccchannel_6_analyzer_1_array_crystal_array_1_priority;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_1_xwidth;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_1_yheight;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_1_zdepth;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_1_xwidth2;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_1_yheight2;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_1_visualize;
int mccchannel_6_analyzer_1_array_crystal_array_1_target_index;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_1_target_x;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_1_target_y;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_1_target_z;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_1_focus_aw;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_1_focus_ah;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_1_focus_xw;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_1_focus_xh;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_1_focus_r;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_1_p_interact;
char mccchannel_6_analyzer_1_array_crystal_array_1_mask_string[16384];
char mccchannel_6_analyzer_1_array_crystal_array_1_mask_setting[16384];
MCNUM mccchannel_6_analyzer_1_array_crystal_array_1_number_of_activations;

/* Setting parameters for component 'channel_6_analyzer_1_array_crystal_array_2' [360]. */
char mccchannel_6_analyzer_1_array_crystal_array_2_material_string[16384];
MCNUM mccchannel_6_analyzer_1_array_crystal_array_2_priority;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_2_xwidth;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_2_yheight;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_2_zdepth;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_2_xwidth2;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_2_yheight2;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_2_visualize;
int mccchannel_6_analyzer_1_array_crystal_array_2_target_index;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_2_target_x;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_2_target_y;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_2_target_z;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_2_focus_aw;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_2_focus_ah;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_2_focus_xw;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_2_focus_xh;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_2_focus_r;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_2_p_interact;
char mccchannel_6_analyzer_1_array_crystal_array_2_mask_string[16384];
char mccchannel_6_analyzer_1_array_crystal_array_2_mask_setting[16384];
MCNUM mccchannel_6_analyzer_1_array_crystal_array_2_number_of_activations;

/* Setting parameters for component 'channel_6_analyzer_1_array_crystal_array_3' [361]. */
char mccchannel_6_analyzer_1_array_crystal_array_3_material_string[16384];
MCNUM mccchannel_6_analyzer_1_array_crystal_array_3_priority;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_3_xwidth;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_3_yheight;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_3_zdepth;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_3_xwidth2;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_3_yheight2;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_3_visualize;
int mccchannel_6_analyzer_1_array_crystal_array_3_target_index;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_3_target_x;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_3_target_y;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_3_target_z;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_3_focus_aw;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_3_focus_ah;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_3_focus_xw;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_3_focus_xh;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_3_focus_r;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_3_p_interact;
char mccchannel_6_analyzer_1_array_crystal_array_3_mask_string[16384];
char mccchannel_6_analyzer_1_array_crystal_array_3_mask_setting[16384];
MCNUM mccchannel_6_analyzer_1_array_crystal_array_3_number_of_activations;

/* Setting parameters for component 'channel_6_analyzer_1_array_crystal_array_4' [362]. */
char mccchannel_6_analyzer_1_array_crystal_array_4_material_string[16384];
MCNUM mccchannel_6_analyzer_1_array_crystal_array_4_priority;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_4_xwidth;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_4_yheight;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_4_zdepth;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_4_xwidth2;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_4_yheight2;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_4_visualize;
int mccchannel_6_analyzer_1_array_crystal_array_4_target_index;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_4_target_x;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_4_target_y;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_4_target_z;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_4_focus_aw;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_4_focus_ah;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_4_focus_xw;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_4_focus_xh;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_4_focus_r;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_4_p_interact;
char mccchannel_6_analyzer_1_array_crystal_array_4_mask_string[16384];
char mccchannel_6_analyzer_1_array_crystal_array_4_mask_setting[16384];
MCNUM mccchannel_6_analyzer_1_array_crystal_array_4_number_of_activations;

/* Setting parameters for component 'channel_6_analyzer_1_array_crystal_array_5' [363]. */
char mccchannel_6_analyzer_1_array_crystal_array_5_material_string[16384];
MCNUM mccchannel_6_analyzer_1_array_crystal_array_5_priority;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_5_xwidth;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_5_yheight;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_5_zdepth;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_5_xwidth2;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_5_yheight2;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_5_visualize;
int mccchannel_6_analyzer_1_array_crystal_array_5_target_index;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_5_target_x;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_5_target_y;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_5_target_z;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_5_focus_aw;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_5_focus_ah;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_5_focus_xw;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_5_focus_xh;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_5_focus_r;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_5_p_interact;
char mccchannel_6_analyzer_1_array_crystal_array_5_mask_string[16384];
char mccchannel_6_analyzer_1_array_crystal_array_5_mask_setting[16384];
MCNUM mccchannel_6_analyzer_1_array_crystal_array_5_number_of_activations;

/* Setting parameters for component 'channel_6_analyzer_1_array_crystal_array_6' [364]. */
char mccchannel_6_analyzer_1_array_crystal_array_6_material_string[16384];
MCNUM mccchannel_6_analyzer_1_array_crystal_array_6_priority;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_6_xwidth;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_6_yheight;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_6_zdepth;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_6_xwidth2;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_6_yheight2;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_6_visualize;
int mccchannel_6_analyzer_1_array_crystal_array_6_target_index;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_6_target_x;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_6_target_y;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_6_target_z;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_6_focus_aw;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_6_focus_ah;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_6_focus_xw;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_6_focus_xh;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_6_focus_r;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_6_p_interact;
char mccchannel_6_analyzer_1_array_crystal_array_6_mask_string[16384];
char mccchannel_6_analyzer_1_array_crystal_array_6_mask_setting[16384];
MCNUM mccchannel_6_analyzer_1_array_crystal_array_6_number_of_activations;

/* Setting parameters for component 'channel_6_analyzer_1_array_crystal_array_7' [365]. */
char mccchannel_6_analyzer_1_array_crystal_array_7_material_string[16384];
MCNUM mccchannel_6_analyzer_1_array_crystal_array_7_priority;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_7_xwidth;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_7_yheight;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_7_zdepth;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_7_xwidth2;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_7_yheight2;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_7_visualize;
int mccchannel_6_analyzer_1_array_crystal_array_7_target_index;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_7_target_x;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_7_target_y;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_7_target_z;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_7_focus_aw;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_7_focus_ah;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_7_focus_xw;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_7_focus_xh;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_7_focus_r;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_7_p_interact;
char mccchannel_6_analyzer_1_array_crystal_array_7_mask_string[16384];
char mccchannel_6_analyzer_1_array_crystal_array_7_mask_setting[16384];
MCNUM mccchannel_6_analyzer_1_array_crystal_array_7_number_of_activations;

/* Setting parameters for component 'channel_6_analyzer_1_array_crystal_array_8' [366]. */
char mccchannel_6_analyzer_1_array_crystal_array_8_material_string[16384];
MCNUM mccchannel_6_analyzer_1_array_crystal_array_8_priority;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_8_xwidth;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_8_yheight;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_8_zdepth;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_8_xwidth2;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_8_yheight2;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_8_visualize;
int mccchannel_6_analyzer_1_array_crystal_array_8_target_index;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_8_target_x;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_8_target_y;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_8_target_z;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_8_focus_aw;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_8_focus_ah;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_8_focus_xw;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_8_focus_xh;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_8_focus_r;
MCNUM mccchannel_6_analyzer_1_array_crystal_array_8_p_interact;
char mccchannel_6_analyzer_1_array_crystal_array_8_mask_string[16384];
char mccchannel_6_analyzer_1_array_crystal_array_8_mask_setting[16384];
MCNUM mccchannel_6_analyzer_1_array_crystal_array_8_number_of_activations;

/* Setting parameters for component 'channel_6_analyzer_2_array_crystal_array_0' [369]. */
char mccchannel_6_analyzer_2_array_crystal_array_0_material_string[16384];
MCNUM mccchannel_6_analyzer_2_array_crystal_array_0_priority;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_0_xwidth;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_0_yheight;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_0_zdepth;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_0_xwidth2;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_0_yheight2;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_0_visualize;
int mccchannel_6_analyzer_2_array_crystal_array_0_target_index;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_0_target_x;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_0_target_y;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_0_target_z;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_0_focus_aw;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_0_focus_ah;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_0_focus_xw;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_0_focus_xh;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_0_focus_r;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_0_p_interact;
char mccchannel_6_analyzer_2_array_crystal_array_0_mask_string[16384];
char mccchannel_6_analyzer_2_array_crystal_array_0_mask_setting[16384];
MCNUM mccchannel_6_analyzer_2_array_crystal_array_0_number_of_activations;

/* Setting parameters for component 'channel_6_analyzer_2_array_crystal_array_1' [370]. */
char mccchannel_6_analyzer_2_array_crystal_array_1_material_string[16384];
MCNUM mccchannel_6_analyzer_2_array_crystal_array_1_priority;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_1_xwidth;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_1_yheight;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_1_zdepth;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_1_xwidth2;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_1_yheight2;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_1_visualize;
int mccchannel_6_analyzer_2_array_crystal_array_1_target_index;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_1_target_x;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_1_target_y;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_1_target_z;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_1_focus_aw;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_1_focus_ah;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_1_focus_xw;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_1_focus_xh;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_1_focus_r;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_1_p_interact;
char mccchannel_6_analyzer_2_array_crystal_array_1_mask_string[16384];
char mccchannel_6_analyzer_2_array_crystal_array_1_mask_setting[16384];
MCNUM mccchannel_6_analyzer_2_array_crystal_array_1_number_of_activations;

/* Setting parameters for component 'channel_6_analyzer_2_array_crystal_array_2' [371]. */
char mccchannel_6_analyzer_2_array_crystal_array_2_material_string[16384];
MCNUM mccchannel_6_analyzer_2_array_crystal_array_2_priority;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_2_xwidth;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_2_yheight;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_2_zdepth;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_2_xwidth2;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_2_yheight2;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_2_visualize;
int mccchannel_6_analyzer_2_array_crystal_array_2_target_index;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_2_target_x;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_2_target_y;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_2_target_z;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_2_focus_aw;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_2_focus_ah;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_2_focus_xw;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_2_focus_xh;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_2_focus_r;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_2_p_interact;
char mccchannel_6_analyzer_2_array_crystal_array_2_mask_string[16384];
char mccchannel_6_analyzer_2_array_crystal_array_2_mask_setting[16384];
MCNUM mccchannel_6_analyzer_2_array_crystal_array_2_number_of_activations;

/* Setting parameters for component 'channel_6_analyzer_2_array_crystal_array_3' [372]. */
char mccchannel_6_analyzer_2_array_crystal_array_3_material_string[16384];
MCNUM mccchannel_6_analyzer_2_array_crystal_array_3_priority;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_3_xwidth;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_3_yheight;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_3_zdepth;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_3_xwidth2;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_3_yheight2;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_3_visualize;
int mccchannel_6_analyzer_2_array_crystal_array_3_target_index;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_3_target_x;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_3_target_y;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_3_target_z;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_3_focus_aw;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_3_focus_ah;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_3_focus_xw;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_3_focus_xh;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_3_focus_r;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_3_p_interact;
char mccchannel_6_analyzer_2_array_crystal_array_3_mask_string[16384];
char mccchannel_6_analyzer_2_array_crystal_array_3_mask_setting[16384];
MCNUM mccchannel_6_analyzer_2_array_crystal_array_3_number_of_activations;

/* Setting parameters for component 'channel_6_analyzer_2_array_crystal_array_4' [373]. */
char mccchannel_6_analyzer_2_array_crystal_array_4_material_string[16384];
MCNUM mccchannel_6_analyzer_2_array_crystal_array_4_priority;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_4_xwidth;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_4_yheight;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_4_zdepth;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_4_xwidth2;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_4_yheight2;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_4_visualize;
int mccchannel_6_analyzer_2_array_crystal_array_4_target_index;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_4_target_x;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_4_target_y;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_4_target_z;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_4_focus_aw;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_4_focus_ah;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_4_focus_xw;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_4_focus_xh;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_4_focus_r;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_4_p_interact;
char mccchannel_6_analyzer_2_array_crystal_array_4_mask_string[16384];
char mccchannel_6_analyzer_2_array_crystal_array_4_mask_setting[16384];
MCNUM mccchannel_6_analyzer_2_array_crystal_array_4_number_of_activations;

/* Setting parameters for component 'channel_6_analyzer_2_array_crystal_array_5' [374]. */
char mccchannel_6_analyzer_2_array_crystal_array_5_material_string[16384];
MCNUM mccchannel_6_analyzer_2_array_crystal_array_5_priority;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_5_xwidth;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_5_yheight;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_5_zdepth;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_5_xwidth2;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_5_yheight2;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_5_visualize;
int mccchannel_6_analyzer_2_array_crystal_array_5_target_index;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_5_target_x;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_5_target_y;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_5_target_z;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_5_focus_aw;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_5_focus_ah;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_5_focus_xw;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_5_focus_xh;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_5_focus_r;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_5_p_interact;
char mccchannel_6_analyzer_2_array_crystal_array_5_mask_string[16384];
char mccchannel_6_analyzer_2_array_crystal_array_5_mask_setting[16384];
MCNUM mccchannel_6_analyzer_2_array_crystal_array_5_number_of_activations;

/* Setting parameters for component 'channel_6_analyzer_2_array_crystal_array_6' [375]. */
char mccchannel_6_analyzer_2_array_crystal_array_6_material_string[16384];
MCNUM mccchannel_6_analyzer_2_array_crystal_array_6_priority;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_6_xwidth;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_6_yheight;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_6_zdepth;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_6_xwidth2;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_6_yheight2;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_6_visualize;
int mccchannel_6_analyzer_2_array_crystal_array_6_target_index;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_6_target_x;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_6_target_y;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_6_target_z;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_6_focus_aw;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_6_focus_ah;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_6_focus_xw;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_6_focus_xh;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_6_focus_r;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_6_p_interact;
char mccchannel_6_analyzer_2_array_crystal_array_6_mask_string[16384];
char mccchannel_6_analyzer_2_array_crystal_array_6_mask_setting[16384];
MCNUM mccchannel_6_analyzer_2_array_crystal_array_6_number_of_activations;

/* Setting parameters for component 'channel_6_analyzer_2_array_crystal_array_7' [376]. */
char mccchannel_6_analyzer_2_array_crystal_array_7_material_string[16384];
MCNUM mccchannel_6_analyzer_2_array_crystal_array_7_priority;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_7_xwidth;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_7_yheight;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_7_zdepth;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_7_xwidth2;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_7_yheight2;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_7_visualize;
int mccchannel_6_analyzer_2_array_crystal_array_7_target_index;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_7_target_x;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_7_target_y;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_7_target_z;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_7_focus_aw;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_7_focus_ah;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_7_focus_xw;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_7_focus_xh;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_7_focus_r;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_7_p_interact;
char mccchannel_6_analyzer_2_array_crystal_array_7_mask_string[16384];
char mccchannel_6_analyzer_2_array_crystal_array_7_mask_setting[16384];
MCNUM mccchannel_6_analyzer_2_array_crystal_array_7_number_of_activations;

/* Setting parameters for component 'channel_6_analyzer_2_array_crystal_array_8' [377]. */
char mccchannel_6_analyzer_2_array_crystal_array_8_material_string[16384];
MCNUM mccchannel_6_analyzer_2_array_crystal_array_8_priority;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_8_xwidth;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_8_yheight;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_8_zdepth;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_8_xwidth2;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_8_yheight2;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_8_visualize;
int mccchannel_6_analyzer_2_array_crystal_array_8_target_index;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_8_target_x;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_8_target_y;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_8_target_z;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_8_focus_aw;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_8_focus_ah;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_8_focus_xw;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_8_focus_xh;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_8_focus_r;
MCNUM mccchannel_6_analyzer_2_array_crystal_array_8_p_interact;
char mccchannel_6_analyzer_2_array_crystal_array_8_mask_string[16384];
char mccchannel_6_analyzer_2_array_crystal_array_8_mask_setting[16384];
MCNUM mccchannel_6_analyzer_2_array_crystal_array_8_number_of_activations;

/* Setting parameters for component 'channel_6_cave2_cyl1' [378]. */
char mccchannel_6_cave2_cyl1_material_string[16384];
MCNUM mccchannel_6_cave2_cyl1_priority;
MCNUM mccchannel_6_cave2_cyl1_radius;
MCNUM mccchannel_6_cave2_cyl1_yheight;
MCNUM mccchannel_6_cave2_cyl1_visualize;
int mccchannel_6_cave2_cyl1_target_index;
MCNUM mccchannel_6_cave2_cyl1_target_x;
MCNUM mccchannel_6_cave2_cyl1_target_y;
MCNUM mccchannel_6_cave2_cyl1_target_z;
MCNUM mccchannel_6_cave2_cyl1_focus_aw;
MCNUM mccchannel_6_cave2_cyl1_focus_ah;
MCNUM mccchannel_6_cave2_cyl1_focus_xw;
MCNUM mccchannel_6_cave2_cyl1_focus_xh;
MCNUM mccchannel_6_cave2_cyl1_focus_r;
MCNUM mccchannel_6_cave2_cyl1_p_interact;
char mccchannel_6_cave2_cyl1_mask_string[16384];
char mccchannel_6_cave2_cyl1_mask_setting[16384];
MCNUM mccchannel_6_cave2_cyl1_number_of_activations;

/* Setting parameters for component 'channel_6_cave2_box1' [379]. */
char mccchannel_6_cave2_box1_material_string[16384];
MCNUM mccchannel_6_cave2_box1_priority;
MCNUM mccchannel_6_cave2_box1_xwidth;
MCNUM mccchannel_6_cave2_box1_yheight;
MCNUM mccchannel_6_cave2_box1_zdepth;
MCNUM mccchannel_6_cave2_box1_xwidth2;
MCNUM mccchannel_6_cave2_box1_yheight2;
MCNUM mccchannel_6_cave2_box1_visualize;
int mccchannel_6_cave2_box1_target_index;
MCNUM mccchannel_6_cave2_box1_target_x;
MCNUM mccchannel_6_cave2_box1_target_y;
MCNUM mccchannel_6_cave2_box1_target_z;
MCNUM mccchannel_6_cave2_box1_focus_aw;
MCNUM mccchannel_6_cave2_box1_focus_ah;
MCNUM mccchannel_6_cave2_box1_focus_xw;
MCNUM mccchannel_6_cave2_box1_focus_xh;
MCNUM mccchannel_6_cave2_box1_focus_r;
MCNUM mccchannel_6_cave2_box1_p_interact;
char mccchannel_6_cave2_box1_mask_string[16384];
char mccchannel_6_cave2_box1_mask_setting[16384];
MCNUM mccchannel_6_cave2_box1_number_of_activations;

/* Setting parameters for component 'channel_6_cave2_box2' [380]. */
char mccchannel_6_cave2_box2_material_string[16384];
MCNUM mccchannel_6_cave2_box2_priority;
MCNUM mccchannel_6_cave2_box2_xwidth;
MCNUM mccchannel_6_cave2_box2_yheight;
MCNUM mccchannel_6_cave2_box2_zdepth;
MCNUM mccchannel_6_cave2_box2_xwidth2;
MCNUM mccchannel_6_cave2_box2_yheight2;
MCNUM mccchannel_6_cave2_box2_visualize;
int mccchannel_6_cave2_box2_target_index;
MCNUM mccchannel_6_cave2_box2_target_x;
MCNUM mccchannel_6_cave2_box2_target_y;
MCNUM mccchannel_6_cave2_box2_target_z;
MCNUM mccchannel_6_cave2_box2_focus_aw;
MCNUM mccchannel_6_cave2_box2_focus_ah;
MCNUM mccchannel_6_cave2_box2_focus_xw;
MCNUM mccchannel_6_cave2_box2_focus_xh;
MCNUM mccchannel_6_cave2_box2_focus_r;
MCNUM mccchannel_6_cave2_box2_p_interact;
char mccchannel_6_cave2_box2_mask_string[16384];
char mccchannel_6_cave2_box2_mask_setting[16384];
MCNUM mccchannel_6_cave2_box2_number_of_activations;

/* Setting parameters for component 'channel_6_cave2_box3' [381]. */
char mccchannel_6_cave2_box3_material_string[16384];
MCNUM mccchannel_6_cave2_box3_priority;
MCNUM mccchannel_6_cave2_box3_xwidth;
MCNUM mccchannel_6_cave2_box3_yheight;
MCNUM mccchannel_6_cave2_box3_zdepth;
MCNUM mccchannel_6_cave2_box3_xwidth2;
MCNUM mccchannel_6_cave2_box3_yheight2;
MCNUM mccchannel_6_cave2_box3_visualize;
int mccchannel_6_cave2_box3_target_index;
MCNUM mccchannel_6_cave2_box3_target_x;
MCNUM mccchannel_6_cave2_box3_target_y;
MCNUM mccchannel_6_cave2_box3_target_z;
MCNUM mccchannel_6_cave2_box3_focus_aw;
MCNUM mccchannel_6_cave2_box3_focus_ah;
MCNUM mccchannel_6_cave2_box3_focus_xw;
MCNUM mccchannel_6_cave2_box3_focus_xh;
MCNUM mccchannel_6_cave2_box3_focus_r;
MCNUM mccchannel_6_cave2_box3_p_interact;
char mccchannel_6_cave2_box3_mask_string[16384];
char mccchannel_6_cave2_box3_mask_setting[16384];
MCNUM mccchannel_6_cave2_box3_number_of_activations;

/* Setting parameters for component 'inter_analyzer_colimator_6_blade_0' [383]. */
char mccinter_analyzer_colimator_6_blade_0_material_string[16384];
MCNUM mccinter_analyzer_colimator_6_blade_0_priority;
MCNUM mccinter_analyzer_colimator_6_blade_0_xwidth;
MCNUM mccinter_analyzer_colimator_6_blade_0_yheight;
MCNUM mccinter_analyzer_colimator_6_blade_0_zdepth;
MCNUM mccinter_analyzer_colimator_6_blade_0_xwidth2;
MCNUM mccinter_analyzer_colimator_6_blade_0_yheight2;
MCNUM mccinter_analyzer_colimator_6_blade_0_visualize;
int mccinter_analyzer_colimator_6_blade_0_target_index;
MCNUM mccinter_analyzer_colimator_6_blade_0_target_x;
MCNUM mccinter_analyzer_colimator_6_blade_0_target_y;
MCNUM mccinter_analyzer_colimator_6_blade_0_target_z;
MCNUM mccinter_analyzer_colimator_6_blade_0_focus_aw;
MCNUM mccinter_analyzer_colimator_6_blade_0_focus_ah;
MCNUM mccinter_analyzer_colimator_6_blade_0_focus_xw;
MCNUM mccinter_analyzer_colimator_6_blade_0_focus_xh;
MCNUM mccinter_analyzer_colimator_6_blade_0_focus_r;
MCNUM mccinter_analyzer_colimator_6_blade_0_p_interact;
char mccinter_analyzer_colimator_6_blade_0_mask_string[16384];
char mccinter_analyzer_colimator_6_blade_0_mask_setting[16384];
MCNUM mccinter_analyzer_colimator_6_blade_0_number_of_activations;

/* Setting parameters for component 'inter_analyzer_colimator_6_blade_1' [384]. */
char mccinter_analyzer_colimator_6_blade_1_material_string[16384];
MCNUM mccinter_analyzer_colimator_6_blade_1_priority;
MCNUM mccinter_analyzer_colimator_6_blade_1_xwidth;
MCNUM mccinter_analyzer_colimator_6_blade_1_yheight;
MCNUM mccinter_analyzer_colimator_6_blade_1_zdepth;
MCNUM mccinter_analyzer_colimator_6_blade_1_xwidth2;
MCNUM mccinter_analyzer_colimator_6_blade_1_yheight2;
MCNUM mccinter_analyzer_colimator_6_blade_1_visualize;
int mccinter_analyzer_colimator_6_blade_1_target_index;
MCNUM mccinter_analyzer_colimator_6_blade_1_target_x;
MCNUM mccinter_analyzer_colimator_6_blade_1_target_y;
MCNUM mccinter_analyzer_colimator_6_blade_1_target_z;
MCNUM mccinter_analyzer_colimator_6_blade_1_focus_aw;
MCNUM mccinter_analyzer_colimator_6_blade_1_focus_ah;
MCNUM mccinter_analyzer_colimator_6_blade_1_focus_xw;
MCNUM mccinter_analyzer_colimator_6_blade_1_focus_xh;
MCNUM mccinter_analyzer_colimator_6_blade_1_focus_r;
MCNUM mccinter_analyzer_colimator_6_blade_1_p_interact;
char mccinter_analyzer_colimator_6_blade_1_mask_string[16384];
char mccinter_analyzer_colimator_6_blade_1_mask_setting[16384];
MCNUM mccinter_analyzer_colimator_6_blade_1_number_of_activations;

/* Setting parameters for component 'inter_analyzer_colimator_6_blade_2' [385]. */
char mccinter_analyzer_colimator_6_blade_2_material_string[16384];
MCNUM mccinter_analyzer_colimator_6_blade_2_priority;
MCNUM mccinter_analyzer_colimator_6_blade_2_xwidth;
MCNUM mccinter_analyzer_colimator_6_blade_2_yheight;
MCNUM mccinter_analyzer_colimator_6_blade_2_zdepth;
MCNUM mccinter_analyzer_colimator_6_blade_2_xwidth2;
MCNUM mccinter_analyzer_colimator_6_blade_2_yheight2;
MCNUM mccinter_analyzer_colimator_6_blade_2_visualize;
int mccinter_analyzer_colimator_6_blade_2_target_index;
MCNUM mccinter_analyzer_colimator_6_blade_2_target_x;
MCNUM mccinter_analyzer_colimator_6_blade_2_target_y;
MCNUM mccinter_analyzer_colimator_6_blade_2_target_z;
MCNUM mccinter_analyzer_colimator_6_blade_2_focus_aw;
MCNUM mccinter_analyzer_colimator_6_blade_2_focus_ah;
MCNUM mccinter_analyzer_colimator_6_blade_2_focus_xw;
MCNUM mccinter_analyzer_colimator_6_blade_2_focus_xh;
MCNUM mccinter_analyzer_colimator_6_blade_2_focus_r;
MCNUM mccinter_analyzer_colimator_6_blade_2_p_interact;
char mccinter_analyzer_colimator_6_blade_2_mask_string[16384];
char mccinter_analyzer_colimator_6_blade_2_mask_setting[16384];
MCNUM mccinter_analyzer_colimator_6_blade_2_number_of_activations;

/* Setting parameters for component 'inter_analyzer_colimator_6_blade_3' [386]. */
char mccinter_analyzer_colimator_6_blade_3_material_string[16384];
MCNUM mccinter_analyzer_colimator_6_blade_3_priority;
MCNUM mccinter_analyzer_colimator_6_blade_3_xwidth;
MCNUM mccinter_analyzer_colimator_6_blade_3_yheight;
MCNUM mccinter_analyzer_colimator_6_blade_3_zdepth;
MCNUM mccinter_analyzer_colimator_6_blade_3_xwidth2;
MCNUM mccinter_analyzer_colimator_6_blade_3_yheight2;
MCNUM mccinter_analyzer_colimator_6_blade_3_visualize;
int mccinter_analyzer_colimator_6_blade_3_target_index;
MCNUM mccinter_analyzer_colimator_6_blade_3_target_x;
MCNUM mccinter_analyzer_colimator_6_blade_3_target_y;
MCNUM mccinter_analyzer_colimator_6_blade_3_target_z;
MCNUM mccinter_analyzer_colimator_6_blade_3_focus_aw;
MCNUM mccinter_analyzer_colimator_6_blade_3_focus_ah;
MCNUM mccinter_analyzer_colimator_6_blade_3_focus_xw;
MCNUM mccinter_analyzer_colimator_6_blade_3_focus_xh;
MCNUM mccinter_analyzer_colimator_6_blade_3_focus_r;
MCNUM mccinter_analyzer_colimator_6_blade_3_p_interact;
char mccinter_analyzer_colimator_6_blade_3_mask_string[16384];
char mccinter_analyzer_colimator_6_blade_3_mask_setting[16384];
MCNUM mccinter_analyzer_colimator_6_blade_3_number_of_activations;

/* Setting parameters for component 'inter_analyzer_colimator_6_blade_4' [387]. */
char mccinter_analyzer_colimator_6_blade_4_material_string[16384];
MCNUM mccinter_analyzer_colimator_6_blade_4_priority;
MCNUM mccinter_analyzer_colimator_6_blade_4_xwidth;
MCNUM mccinter_analyzer_colimator_6_blade_4_yheight;
MCNUM mccinter_analyzer_colimator_6_blade_4_zdepth;
MCNUM mccinter_analyzer_colimator_6_blade_4_xwidth2;
MCNUM mccinter_analyzer_colimator_6_blade_4_yheight2;
MCNUM mccinter_analyzer_colimator_6_blade_4_visualize;
int mccinter_analyzer_colimator_6_blade_4_target_index;
MCNUM mccinter_analyzer_colimator_6_blade_4_target_x;
MCNUM mccinter_analyzer_colimator_6_blade_4_target_y;
MCNUM mccinter_analyzer_colimator_6_blade_4_target_z;
MCNUM mccinter_analyzer_colimator_6_blade_4_focus_aw;
MCNUM mccinter_analyzer_colimator_6_blade_4_focus_ah;
MCNUM mccinter_analyzer_colimator_6_blade_4_focus_xw;
MCNUM mccinter_analyzer_colimator_6_blade_4_focus_xh;
MCNUM mccinter_analyzer_colimator_6_blade_4_focus_r;
MCNUM mccinter_analyzer_colimator_6_blade_4_p_interact;
char mccinter_analyzer_colimator_6_blade_4_mask_string[16384];
char mccinter_analyzer_colimator_6_blade_4_mask_setting[16384];
MCNUM mccinter_analyzer_colimator_6_blade_4_number_of_activations;

/* Setting parameters for component 'diffraction_detector_6_exit_volume' [388]. */
char mccdiffraction_detector_6_exit_volume_material_string[16384];
MCNUM mccdiffraction_detector_6_exit_volume_priority;
MCNUM mccdiffraction_detector_6_exit_volume_xwidth;
MCNUM mccdiffraction_detector_6_exit_volume_yheight;
MCNUM mccdiffraction_detector_6_exit_volume_zdepth;
MCNUM mccdiffraction_detector_6_exit_volume_xwidth2;
MCNUM mccdiffraction_detector_6_exit_volume_yheight2;
MCNUM mccdiffraction_detector_6_exit_volume_visualize;
int mccdiffraction_detector_6_exit_volume_target_index;
MCNUM mccdiffraction_detector_6_exit_volume_target_x;
MCNUM mccdiffraction_detector_6_exit_volume_target_y;
MCNUM mccdiffraction_detector_6_exit_volume_target_z;
MCNUM mccdiffraction_detector_6_exit_volume_focus_aw;
MCNUM mccdiffraction_detector_6_exit_volume_focus_ah;
MCNUM mccdiffraction_detector_6_exit_volume_focus_xw;
MCNUM mccdiffraction_detector_6_exit_volume_focus_xh;
MCNUM mccdiffraction_detector_6_exit_volume_focus_r;
MCNUM mccdiffraction_detector_6_exit_volume_p_interact;
char mccdiffraction_detector_6_exit_volume_mask_string[16384];
char mccdiffraction_detector_6_exit_volume_mask_setting[16384];
MCNUM mccdiffraction_detector_6_exit_volume_number_of_activations;

/* Setting parameters for component 'spec_detector_6_exit_volume' [389]. */
char mccspec_detector_6_exit_volume_material_string[16384];
MCNUM mccspec_detector_6_exit_volume_priority;
MCNUM mccspec_detector_6_exit_volume_xwidth;
MCNUM mccspec_detector_6_exit_volume_yheight;
MCNUM mccspec_detector_6_exit_volume_zdepth;
MCNUM mccspec_detector_6_exit_volume_xwidth2;
MCNUM mccspec_detector_6_exit_volume_yheight2;
MCNUM mccspec_detector_6_exit_volume_visualize;
int mccspec_detector_6_exit_volume_target_index;
MCNUM mccspec_detector_6_exit_volume_target_x;
MCNUM mccspec_detector_6_exit_volume_target_y;
MCNUM mccspec_detector_6_exit_volume_target_z;
MCNUM mccspec_detector_6_exit_volume_focus_aw;
MCNUM mccspec_detector_6_exit_volume_focus_ah;
MCNUM mccspec_detector_6_exit_volume_focus_xw;
MCNUM mccspec_detector_6_exit_volume_focus_xh;
MCNUM mccspec_detector_6_exit_volume_focus_r;
MCNUM mccspec_detector_6_exit_volume_p_interact;
char mccspec_detector_6_exit_volume_mask_string[16384];
char mccspec_detector_6_exit_volume_mask_setting[16384];
MCNUM mccspec_detector_6_exit_volume_number_of_activations;

/* Setting parameters for component 'channel_7_cave1_box1' [390]. */
char mccchannel_7_cave1_box1_material_string[16384];
MCNUM mccchannel_7_cave1_box1_priority;
MCNUM mccchannel_7_cave1_box1_xwidth;
MCNUM mccchannel_7_cave1_box1_yheight;
MCNUM mccchannel_7_cave1_box1_zdepth;
MCNUM mccchannel_7_cave1_box1_xwidth2;
MCNUM mccchannel_7_cave1_box1_yheight2;
MCNUM mccchannel_7_cave1_box1_visualize;
int mccchannel_7_cave1_box1_target_index;
MCNUM mccchannel_7_cave1_box1_target_x;
MCNUM mccchannel_7_cave1_box1_target_y;
MCNUM mccchannel_7_cave1_box1_target_z;
MCNUM mccchannel_7_cave1_box1_focus_aw;
MCNUM mccchannel_7_cave1_box1_focus_ah;
MCNUM mccchannel_7_cave1_box1_focus_xw;
MCNUM mccchannel_7_cave1_box1_focus_xh;
MCNUM mccchannel_7_cave1_box1_focus_r;
MCNUM mccchannel_7_cave1_box1_p_interact;
char mccchannel_7_cave1_box1_mask_string[16384];
char mccchannel_7_cave1_box1_mask_setting[16384];
MCNUM mccchannel_7_cave1_box1_number_of_activations;

/* Setting parameters for component 'channel_7_cave1_box2' [391]. */
char mccchannel_7_cave1_box2_material_string[16384];
MCNUM mccchannel_7_cave1_box2_priority;
MCNUM mccchannel_7_cave1_box2_xwidth;
MCNUM mccchannel_7_cave1_box2_yheight;
MCNUM mccchannel_7_cave1_box2_zdepth;
MCNUM mccchannel_7_cave1_box2_xwidth2;
MCNUM mccchannel_7_cave1_box2_yheight2;
MCNUM mccchannel_7_cave1_box2_visualize;
int mccchannel_7_cave1_box2_target_index;
MCNUM mccchannel_7_cave1_box2_target_x;
MCNUM mccchannel_7_cave1_box2_target_y;
MCNUM mccchannel_7_cave1_box2_target_z;
MCNUM mccchannel_7_cave1_box2_focus_aw;
MCNUM mccchannel_7_cave1_box2_focus_ah;
MCNUM mccchannel_7_cave1_box2_focus_xw;
MCNUM mccchannel_7_cave1_box2_focus_xh;
MCNUM mccchannel_7_cave1_box2_focus_r;
MCNUM mccchannel_7_cave1_box2_p_interact;
char mccchannel_7_cave1_box2_mask_string[16384];
char mccchannel_7_cave1_box2_mask_setting[16384];
MCNUM mccchannel_7_cave1_box2_number_of_activations;

/* Setting parameters for component 'channel_7_cave1_box3' [392]. */
char mccchannel_7_cave1_box3_material_string[16384];
MCNUM mccchannel_7_cave1_box3_priority;
MCNUM mccchannel_7_cave1_box3_xwidth;
MCNUM mccchannel_7_cave1_box3_yheight;
MCNUM mccchannel_7_cave1_box3_zdepth;
MCNUM mccchannel_7_cave1_box3_xwidth2;
MCNUM mccchannel_7_cave1_box3_yheight2;
MCNUM mccchannel_7_cave1_box3_visualize;
int mccchannel_7_cave1_box3_target_index;
MCNUM mccchannel_7_cave1_box3_target_x;
MCNUM mccchannel_7_cave1_box3_target_y;
MCNUM mccchannel_7_cave1_box3_target_z;
MCNUM mccchannel_7_cave1_box3_focus_aw;
MCNUM mccchannel_7_cave1_box3_focus_ah;
MCNUM mccchannel_7_cave1_box3_focus_xw;
MCNUM mccchannel_7_cave1_box3_focus_xh;
MCNUM mccchannel_7_cave1_box3_focus_r;
MCNUM mccchannel_7_cave1_box3_p_interact;
char mccchannel_7_cave1_box3_mask_string[16384];
char mccchannel_7_cave1_box3_mask_setting[16384];
MCNUM mccchannel_7_cave1_box3_number_of_activations;

/* Setting parameters for component 'channel_7_cave1_cyl1' [393]. */
char mccchannel_7_cave1_cyl1_material_string[16384];
MCNUM mccchannel_7_cave1_cyl1_priority;
MCNUM mccchannel_7_cave1_cyl1_radius;
MCNUM mccchannel_7_cave1_cyl1_yheight;
MCNUM mccchannel_7_cave1_cyl1_visualize;
int mccchannel_7_cave1_cyl1_target_index;
MCNUM mccchannel_7_cave1_cyl1_target_x;
MCNUM mccchannel_7_cave1_cyl1_target_y;
MCNUM mccchannel_7_cave1_cyl1_target_z;
MCNUM mccchannel_7_cave1_cyl1_focus_aw;
MCNUM mccchannel_7_cave1_cyl1_focus_ah;
MCNUM mccchannel_7_cave1_cyl1_focus_xw;
MCNUM mccchannel_7_cave1_cyl1_focus_xh;
MCNUM mccchannel_7_cave1_cyl1_focus_r;
MCNUM mccchannel_7_cave1_cyl1_p_interact;
char mccchannel_7_cave1_cyl1_mask_string[16384];
char mccchannel_7_cave1_cyl1_mask_setting[16384];
MCNUM mccchannel_7_cave1_cyl1_number_of_activations;

/* Setting parameters for component 'channel_7_analyzer_1_array_crystal_array_0' [396]. */
char mccchannel_7_analyzer_1_array_crystal_array_0_material_string[16384];
MCNUM mccchannel_7_analyzer_1_array_crystal_array_0_priority;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_0_xwidth;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_0_yheight;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_0_zdepth;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_0_xwidth2;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_0_yheight2;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_0_visualize;
int mccchannel_7_analyzer_1_array_crystal_array_0_target_index;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_0_target_x;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_0_target_y;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_0_target_z;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_0_focus_aw;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_0_focus_ah;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_0_focus_xw;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_0_focus_xh;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_0_focus_r;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_0_p_interact;
char mccchannel_7_analyzer_1_array_crystal_array_0_mask_string[16384];
char mccchannel_7_analyzer_1_array_crystal_array_0_mask_setting[16384];
MCNUM mccchannel_7_analyzer_1_array_crystal_array_0_number_of_activations;

/* Setting parameters for component 'channel_7_analyzer_1_array_crystal_array_1' [397]. */
char mccchannel_7_analyzer_1_array_crystal_array_1_material_string[16384];
MCNUM mccchannel_7_analyzer_1_array_crystal_array_1_priority;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_1_xwidth;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_1_yheight;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_1_zdepth;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_1_xwidth2;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_1_yheight2;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_1_visualize;
int mccchannel_7_analyzer_1_array_crystal_array_1_target_index;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_1_target_x;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_1_target_y;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_1_target_z;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_1_focus_aw;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_1_focus_ah;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_1_focus_xw;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_1_focus_xh;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_1_focus_r;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_1_p_interact;
char mccchannel_7_analyzer_1_array_crystal_array_1_mask_string[16384];
char mccchannel_7_analyzer_1_array_crystal_array_1_mask_setting[16384];
MCNUM mccchannel_7_analyzer_1_array_crystal_array_1_number_of_activations;

/* Setting parameters for component 'channel_7_analyzer_1_array_crystal_array_2' [398]. */
char mccchannel_7_analyzer_1_array_crystal_array_2_material_string[16384];
MCNUM mccchannel_7_analyzer_1_array_crystal_array_2_priority;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_2_xwidth;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_2_yheight;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_2_zdepth;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_2_xwidth2;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_2_yheight2;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_2_visualize;
int mccchannel_7_analyzer_1_array_crystal_array_2_target_index;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_2_target_x;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_2_target_y;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_2_target_z;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_2_focus_aw;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_2_focus_ah;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_2_focus_xw;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_2_focus_xh;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_2_focus_r;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_2_p_interact;
char mccchannel_7_analyzer_1_array_crystal_array_2_mask_string[16384];
char mccchannel_7_analyzer_1_array_crystal_array_2_mask_setting[16384];
MCNUM mccchannel_7_analyzer_1_array_crystal_array_2_number_of_activations;

/* Setting parameters for component 'channel_7_analyzer_1_array_crystal_array_3' [399]. */
char mccchannel_7_analyzer_1_array_crystal_array_3_material_string[16384];
MCNUM mccchannel_7_analyzer_1_array_crystal_array_3_priority;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_3_xwidth;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_3_yheight;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_3_zdepth;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_3_xwidth2;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_3_yheight2;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_3_visualize;
int mccchannel_7_analyzer_1_array_crystal_array_3_target_index;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_3_target_x;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_3_target_y;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_3_target_z;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_3_focus_aw;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_3_focus_ah;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_3_focus_xw;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_3_focus_xh;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_3_focus_r;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_3_p_interact;
char mccchannel_7_analyzer_1_array_crystal_array_3_mask_string[16384];
char mccchannel_7_analyzer_1_array_crystal_array_3_mask_setting[16384];
MCNUM mccchannel_7_analyzer_1_array_crystal_array_3_number_of_activations;

/* Setting parameters for component 'channel_7_analyzer_1_array_crystal_array_4' [400]. */
char mccchannel_7_analyzer_1_array_crystal_array_4_material_string[16384];
MCNUM mccchannel_7_analyzer_1_array_crystal_array_4_priority;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_4_xwidth;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_4_yheight;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_4_zdepth;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_4_xwidth2;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_4_yheight2;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_4_visualize;
int mccchannel_7_analyzer_1_array_crystal_array_4_target_index;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_4_target_x;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_4_target_y;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_4_target_z;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_4_focus_aw;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_4_focus_ah;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_4_focus_xw;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_4_focus_xh;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_4_focus_r;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_4_p_interact;
char mccchannel_7_analyzer_1_array_crystal_array_4_mask_string[16384];
char mccchannel_7_analyzer_1_array_crystal_array_4_mask_setting[16384];
MCNUM mccchannel_7_analyzer_1_array_crystal_array_4_number_of_activations;

/* Setting parameters for component 'channel_7_analyzer_1_array_crystal_array_5' [401]. */
char mccchannel_7_analyzer_1_array_crystal_array_5_material_string[16384];
MCNUM mccchannel_7_analyzer_1_array_crystal_array_5_priority;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_5_xwidth;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_5_yheight;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_5_zdepth;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_5_xwidth2;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_5_yheight2;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_5_visualize;
int mccchannel_7_analyzer_1_array_crystal_array_5_target_index;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_5_target_x;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_5_target_y;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_5_target_z;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_5_focus_aw;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_5_focus_ah;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_5_focus_xw;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_5_focus_xh;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_5_focus_r;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_5_p_interact;
char mccchannel_7_analyzer_1_array_crystal_array_5_mask_string[16384];
char mccchannel_7_analyzer_1_array_crystal_array_5_mask_setting[16384];
MCNUM mccchannel_7_analyzer_1_array_crystal_array_5_number_of_activations;

/* Setting parameters for component 'channel_7_analyzer_1_array_crystal_array_6' [402]. */
char mccchannel_7_analyzer_1_array_crystal_array_6_material_string[16384];
MCNUM mccchannel_7_analyzer_1_array_crystal_array_6_priority;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_6_xwidth;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_6_yheight;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_6_zdepth;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_6_xwidth2;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_6_yheight2;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_6_visualize;
int mccchannel_7_analyzer_1_array_crystal_array_6_target_index;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_6_target_x;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_6_target_y;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_6_target_z;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_6_focus_aw;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_6_focus_ah;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_6_focus_xw;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_6_focus_xh;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_6_focus_r;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_6_p_interact;
char mccchannel_7_analyzer_1_array_crystal_array_6_mask_string[16384];
char mccchannel_7_analyzer_1_array_crystal_array_6_mask_setting[16384];
MCNUM mccchannel_7_analyzer_1_array_crystal_array_6_number_of_activations;

/* Setting parameters for component 'channel_7_analyzer_1_array_crystal_array_7' [403]. */
char mccchannel_7_analyzer_1_array_crystal_array_7_material_string[16384];
MCNUM mccchannel_7_analyzer_1_array_crystal_array_7_priority;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_7_xwidth;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_7_yheight;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_7_zdepth;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_7_xwidth2;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_7_yheight2;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_7_visualize;
int mccchannel_7_analyzer_1_array_crystal_array_7_target_index;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_7_target_x;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_7_target_y;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_7_target_z;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_7_focus_aw;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_7_focus_ah;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_7_focus_xw;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_7_focus_xh;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_7_focus_r;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_7_p_interact;
char mccchannel_7_analyzer_1_array_crystal_array_7_mask_string[16384];
char mccchannel_7_analyzer_1_array_crystal_array_7_mask_setting[16384];
MCNUM mccchannel_7_analyzer_1_array_crystal_array_7_number_of_activations;

/* Setting parameters for component 'channel_7_analyzer_1_array_crystal_array_8' [404]. */
char mccchannel_7_analyzer_1_array_crystal_array_8_material_string[16384];
MCNUM mccchannel_7_analyzer_1_array_crystal_array_8_priority;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_8_xwidth;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_8_yheight;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_8_zdepth;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_8_xwidth2;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_8_yheight2;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_8_visualize;
int mccchannel_7_analyzer_1_array_crystal_array_8_target_index;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_8_target_x;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_8_target_y;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_8_target_z;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_8_focus_aw;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_8_focus_ah;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_8_focus_xw;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_8_focus_xh;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_8_focus_r;
MCNUM mccchannel_7_analyzer_1_array_crystal_array_8_p_interact;
char mccchannel_7_analyzer_1_array_crystal_array_8_mask_string[16384];
char mccchannel_7_analyzer_1_array_crystal_array_8_mask_setting[16384];
MCNUM mccchannel_7_analyzer_1_array_crystal_array_8_number_of_activations;

/* Setting parameters for component 'channel_7_analyzer_2_array_crystal_array_0' [407]. */
char mccchannel_7_analyzer_2_array_crystal_array_0_material_string[16384];
MCNUM mccchannel_7_analyzer_2_array_crystal_array_0_priority;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_0_xwidth;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_0_yheight;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_0_zdepth;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_0_xwidth2;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_0_yheight2;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_0_visualize;
int mccchannel_7_analyzer_2_array_crystal_array_0_target_index;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_0_target_x;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_0_target_y;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_0_target_z;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_0_focus_aw;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_0_focus_ah;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_0_focus_xw;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_0_focus_xh;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_0_focus_r;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_0_p_interact;
char mccchannel_7_analyzer_2_array_crystal_array_0_mask_string[16384];
char mccchannel_7_analyzer_2_array_crystal_array_0_mask_setting[16384];
MCNUM mccchannel_7_analyzer_2_array_crystal_array_0_number_of_activations;

/* Setting parameters for component 'channel_7_analyzer_2_array_crystal_array_1' [408]. */
char mccchannel_7_analyzer_2_array_crystal_array_1_material_string[16384];
MCNUM mccchannel_7_analyzer_2_array_crystal_array_1_priority;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_1_xwidth;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_1_yheight;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_1_zdepth;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_1_xwidth2;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_1_yheight2;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_1_visualize;
int mccchannel_7_analyzer_2_array_crystal_array_1_target_index;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_1_target_x;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_1_target_y;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_1_target_z;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_1_focus_aw;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_1_focus_ah;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_1_focus_xw;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_1_focus_xh;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_1_focus_r;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_1_p_interact;
char mccchannel_7_analyzer_2_array_crystal_array_1_mask_string[16384];
char mccchannel_7_analyzer_2_array_crystal_array_1_mask_setting[16384];
MCNUM mccchannel_7_analyzer_2_array_crystal_array_1_number_of_activations;

/* Setting parameters for component 'channel_7_analyzer_2_array_crystal_array_2' [409]. */
char mccchannel_7_analyzer_2_array_crystal_array_2_material_string[16384];
MCNUM mccchannel_7_analyzer_2_array_crystal_array_2_priority;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_2_xwidth;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_2_yheight;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_2_zdepth;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_2_xwidth2;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_2_yheight2;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_2_visualize;
int mccchannel_7_analyzer_2_array_crystal_array_2_target_index;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_2_target_x;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_2_target_y;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_2_target_z;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_2_focus_aw;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_2_focus_ah;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_2_focus_xw;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_2_focus_xh;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_2_focus_r;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_2_p_interact;
char mccchannel_7_analyzer_2_array_crystal_array_2_mask_string[16384];
char mccchannel_7_analyzer_2_array_crystal_array_2_mask_setting[16384];
MCNUM mccchannel_7_analyzer_2_array_crystal_array_2_number_of_activations;

/* Setting parameters for component 'channel_7_analyzer_2_array_crystal_array_3' [410]. */
char mccchannel_7_analyzer_2_array_crystal_array_3_material_string[16384];
MCNUM mccchannel_7_analyzer_2_array_crystal_array_3_priority;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_3_xwidth;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_3_yheight;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_3_zdepth;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_3_xwidth2;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_3_yheight2;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_3_visualize;
int mccchannel_7_analyzer_2_array_crystal_array_3_target_index;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_3_target_x;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_3_target_y;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_3_target_z;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_3_focus_aw;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_3_focus_ah;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_3_focus_xw;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_3_focus_xh;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_3_focus_r;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_3_p_interact;
char mccchannel_7_analyzer_2_array_crystal_array_3_mask_string[16384];
char mccchannel_7_analyzer_2_array_crystal_array_3_mask_setting[16384];
MCNUM mccchannel_7_analyzer_2_array_crystal_array_3_number_of_activations;

/* Setting parameters for component 'channel_7_analyzer_2_array_crystal_array_4' [411]. */
char mccchannel_7_analyzer_2_array_crystal_array_4_material_string[16384];
MCNUM mccchannel_7_analyzer_2_array_crystal_array_4_priority;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_4_xwidth;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_4_yheight;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_4_zdepth;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_4_xwidth2;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_4_yheight2;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_4_visualize;
int mccchannel_7_analyzer_2_array_crystal_array_4_target_index;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_4_target_x;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_4_target_y;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_4_target_z;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_4_focus_aw;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_4_focus_ah;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_4_focus_xw;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_4_focus_xh;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_4_focus_r;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_4_p_interact;
char mccchannel_7_analyzer_2_array_crystal_array_4_mask_string[16384];
char mccchannel_7_analyzer_2_array_crystal_array_4_mask_setting[16384];
MCNUM mccchannel_7_analyzer_2_array_crystal_array_4_number_of_activations;

/* Setting parameters for component 'channel_7_analyzer_2_array_crystal_array_5' [412]. */
char mccchannel_7_analyzer_2_array_crystal_array_5_material_string[16384];
MCNUM mccchannel_7_analyzer_2_array_crystal_array_5_priority;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_5_xwidth;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_5_yheight;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_5_zdepth;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_5_xwidth2;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_5_yheight2;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_5_visualize;
int mccchannel_7_analyzer_2_array_crystal_array_5_target_index;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_5_target_x;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_5_target_y;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_5_target_z;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_5_focus_aw;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_5_focus_ah;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_5_focus_xw;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_5_focus_xh;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_5_focus_r;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_5_p_interact;
char mccchannel_7_analyzer_2_array_crystal_array_5_mask_string[16384];
char mccchannel_7_analyzer_2_array_crystal_array_5_mask_setting[16384];
MCNUM mccchannel_7_analyzer_2_array_crystal_array_5_number_of_activations;

/* Setting parameters for component 'channel_7_analyzer_2_array_crystal_array_6' [413]. */
char mccchannel_7_analyzer_2_array_crystal_array_6_material_string[16384];
MCNUM mccchannel_7_analyzer_2_array_crystal_array_6_priority;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_6_xwidth;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_6_yheight;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_6_zdepth;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_6_xwidth2;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_6_yheight2;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_6_visualize;
int mccchannel_7_analyzer_2_array_crystal_array_6_target_index;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_6_target_x;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_6_target_y;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_6_target_z;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_6_focus_aw;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_6_focus_ah;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_6_focus_xw;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_6_focus_xh;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_6_focus_r;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_6_p_interact;
char mccchannel_7_analyzer_2_array_crystal_array_6_mask_string[16384];
char mccchannel_7_analyzer_2_array_crystal_array_6_mask_setting[16384];
MCNUM mccchannel_7_analyzer_2_array_crystal_array_6_number_of_activations;

/* Setting parameters for component 'channel_7_analyzer_2_array_crystal_array_7' [414]. */
char mccchannel_7_analyzer_2_array_crystal_array_7_material_string[16384];
MCNUM mccchannel_7_analyzer_2_array_crystal_array_7_priority;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_7_xwidth;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_7_yheight;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_7_zdepth;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_7_xwidth2;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_7_yheight2;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_7_visualize;
int mccchannel_7_analyzer_2_array_crystal_array_7_target_index;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_7_target_x;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_7_target_y;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_7_target_z;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_7_focus_aw;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_7_focus_ah;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_7_focus_xw;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_7_focus_xh;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_7_focus_r;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_7_p_interact;
char mccchannel_7_analyzer_2_array_crystal_array_7_mask_string[16384];
char mccchannel_7_analyzer_2_array_crystal_array_7_mask_setting[16384];
MCNUM mccchannel_7_analyzer_2_array_crystal_array_7_number_of_activations;

/* Setting parameters for component 'channel_7_analyzer_2_array_crystal_array_8' [415]. */
char mccchannel_7_analyzer_2_array_crystal_array_8_material_string[16384];
MCNUM mccchannel_7_analyzer_2_array_crystal_array_8_priority;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_8_xwidth;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_8_yheight;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_8_zdepth;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_8_xwidth2;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_8_yheight2;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_8_visualize;
int mccchannel_7_analyzer_2_array_crystal_array_8_target_index;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_8_target_x;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_8_target_y;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_8_target_z;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_8_focus_aw;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_8_focus_ah;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_8_focus_xw;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_8_focus_xh;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_8_focus_r;
MCNUM mccchannel_7_analyzer_2_array_crystal_array_8_p_interact;
char mccchannel_7_analyzer_2_array_crystal_array_8_mask_string[16384];
char mccchannel_7_analyzer_2_array_crystal_array_8_mask_setting[16384];
MCNUM mccchannel_7_analyzer_2_array_crystal_array_8_number_of_activations;

/* Setting parameters for component 'channel_7_cave2_cyl1' [416]. */
char mccchannel_7_cave2_cyl1_material_string[16384];
MCNUM mccchannel_7_cave2_cyl1_priority;
MCNUM mccchannel_7_cave2_cyl1_radius;
MCNUM mccchannel_7_cave2_cyl1_yheight;
MCNUM mccchannel_7_cave2_cyl1_visualize;
int mccchannel_7_cave2_cyl1_target_index;
MCNUM mccchannel_7_cave2_cyl1_target_x;
MCNUM mccchannel_7_cave2_cyl1_target_y;
MCNUM mccchannel_7_cave2_cyl1_target_z;
MCNUM mccchannel_7_cave2_cyl1_focus_aw;
MCNUM mccchannel_7_cave2_cyl1_focus_ah;
MCNUM mccchannel_7_cave2_cyl1_focus_xw;
MCNUM mccchannel_7_cave2_cyl1_focus_xh;
MCNUM mccchannel_7_cave2_cyl1_focus_r;
MCNUM mccchannel_7_cave2_cyl1_p_interact;
char mccchannel_7_cave2_cyl1_mask_string[16384];
char mccchannel_7_cave2_cyl1_mask_setting[16384];
MCNUM mccchannel_7_cave2_cyl1_number_of_activations;

/* Setting parameters for component 'channel_7_cave2_box1' [417]. */
char mccchannel_7_cave2_box1_material_string[16384];
MCNUM mccchannel_7_cave2_box1_priority;
MCNUM mccchannel_7_cave2_box1_xwidth;
MCNUM mccchannel_7_cave2_box1_yheight;
MCNUM mccchannel_7_cave2_box1_zdepth;
MCNUM mccchannel_7_cave2_box1_xwidth2;
MCNUM mccchannel_7_cave2_box1_yheight2;
MCNUM mccchannel_7_cave2_box1_visualize;
int mccchannel_7_cave2_box1_target_index;
MCNUM mccchannel_7_cave2_box1_target_x;
MCNUM mccchannel_7_cave2_box1_target_y;
MCNUM mccchannel_7_cave2_box1_target_z;
MCNUM mccchannel_7_cave2_box1_focus_aw;
MCNUM mccchannel_7_cave2_box1_focus_ah;
MCNUM mccchannel_7_cave2_box1_focus_xw;
MCNUM mccchannel_7_cave2_box1_focus_xh;
MCNUM mccchannel_7_cave2_box1_focus_r;
MCNUM mccchannel_7_cave2_box1_p_interact;
char mccchannel_7_cave2_box1_mask_string[16384];
char mccchannel_7_cave2_box1_mask_setting[16384];
MCNUM mccchannel_7_cave2_box1_number_of_activations;

/* Setting parameters for component 'channel_7_cave2_box2' [418]. */
char mccchannel_7_cave2_box2_material_string[16384];
MCNUM mccchannel_7_cave2_box2_priority;
MCNUM mccchannel_7_cave2_box2_xwidth;
MCNUM mccchannel_7_cave2_box2_yheight;
MCNUM mccchannel_7_cave2_box2_zdepth;
MCNUM mccchannel_7_cave2_box2_xwidth2;
MCNUM mccchannel_7_cave2_box2_yheight2;
MCNUM mccchannel_7_cave2_box2_visualize;
int mccchannel_7_cave2_box2_target_index;
MCNUM mccchannel_7_cave2_box2_target_x;
MCNUM mccchannel_7_cave2_box2_target_y;
MCNUM mccchannel_7_cave2_box2_target_z;
MCNUM mccchannel_7_cave2_box2_focus_aw;
MCNUM mccchannel_7_cave2_box2_focus_ah;
MCNUM mccchannel_7_cave2_box2_focus_xw;
MCNUM mccchannel_7_cave2_box2_focus_xh;
MCNUM mccchannel_7_cave2_box2_focus_r;
MCNUM mccchannel_7_cave2_box2_p_interact;
char mccchannel_7_cave2_box2_mask_string[16384];
char mccchannel_7_cave2_box2_mask_setting[16384];
MCNUM mccchannel_7_cave2_box2_number_of_activations;

/* Setting parameters for component 'channel_7_cave2_box3' [419]. */
char mccchannel_7_cave2_box3_material_string[16384];
MCNUM mccchannel_7_cave2_box3_priority;
MCNUM mccchannel_7_cave2_box3_xwidth;
MCNUM mccchannel_7_cave2_box3_yheight;
MCNUM mccchannel_7_cave2_box3_zdepth;
MCNUM mccchannel_7_cave2_box3_xwidth2;
MCNUM mccchannel_7_cave2_box3_yheight2;
MCNUM mccchannel_7_cave2_box3_visualize;
int mccchannel_7_cave2_box3_target_index;
MCNUM mccchannel_7_cave2_box3_target_x;
MCNUM mccchannel_7_cave2_box3_target_y;
MCNUM mccchannel_7_cave2_box3_target_z;
MCNUM mccchannel_7_cave2_box3_focus_aw;
MCNUM mccchannel_7_cave2_box3_focus_ah;
MCNUM mccchannel_7_cave2_box3_focus_xw;
MCNUM mccchannel_7_cave2_box3_focus_xh;
MCNUM mccchannel_7_cave2_box3_focus_r;
MCNUM mccchannel_7_cave2_box3_p_interact;
char mccchannel_7_cave2_box3_mask_string[16384];
char mccchannel_7_cave2_box3_mask_setting[16384];
MCNUM mccchannel_7_cave2_box3_number_of_activations;

/* Setting parameters for component 'inter_analyzer_colimator_7_blade_0' [421]. */
char mccinter_analyzer_colimator_7_blade_0_material_string[16384];
MCNUM mccinter_analyzer_colimator_7_blade_0_priority;
MCNUM mccinter_analyzer_colimator_7_blade_0_xwidth;
MCNUM mccinter_analyzer_colimator_7_blade_0_yheight;
MCNUM mccinter_analyzer_colimator_7_blade_0_zdepth;
MCNUM mccinter_analyzer_colimator_7_blade_0_xwidth2;
MCNUM mccinter_analyzer_colimator_7_blade_0_yheight2;
MCNUM mccinter_analyzer_colimator_7_blade_0_visualize;
int mccinter_analyzer_colimator_7_blade_0_target_index;
MCNUM mccinter_analyzer_colimator_7_blade_0_target_x;
MCNUM mccinter_analyzer_colimator_7_blade_0_target_y;
MCNUM mccinter_analyzer_colimator_7_blade_0_target_z;
MCNUM mccinter_analyzer_colimator_7_blade_0_focus_aw;
MCNUM mccinter_analyzer_colimator_7_blade_0_focus_ah;
MCNUM mccinter_analyzer_colimator_7_blade_0_focus_xw;
MCNUM mccinter_analyzer_colimator_7_blade_0_focus_xh;
MCNUM mccinter_analyzer_colimator_7_blade_0_focus_r;
MCNUM mccinter_analyzer_colimator_7_blade_0_p_interact;
char mccinter_analyzer_colimator_7_blade_0_mask_string[16384];
char mccinter_analyzer_colimator_7_blade_0_mask_setting[16384];
MCNUM mccinter_analyzer_colimator_7_blade_0_number_of_activations;

/* Setting parameters for component 'inter_analyzer_colimator_7_blade_1' [422]. */
char mccinter_analyzer_colimator_7_blade_1_material_string[16384];
MCNUM mccinter_analyzer_colimator_7_blade_1_priority;
MCNUM mccinter_analyzer_colimator_7_blade_1_xwidth;
MCNUM mccinter_analyzer_colimator_7_blade_1_yheight;
MCNUM mccinter_analyzer_colimator_7_blade_1_zdepth;
MCNUM mccinter_analyzer_colimator_7_blade_1_xwidth2;
MCNUM mccinter_analyzer_colimator_7_blade_1_yheight2;
MCNUM mccinter_analyzer_colimator_7_blade_1_visualize;
int mccinter_analyzer_colimator_7_blade_1_target_index;
MCNUM mccinter_analyzer_colimator_7_blade_1_target_x;
MCNUM mccinter_analyzer_colimator_7_blade_1_target_y;
MCNUM mccinter_analyzer_colimator_7_blade_1_target_z;
MCNUM mccinter_analyzer_colimator_7_blade_1_focus_aw;
MCNUM mccinter_analyzer_colimator_7_blade_1_focus_ah;
MCNUM mccinter_analyzer_colimator_7_blade_1_focus_xw;
MCNUM mccinter_analyzer_colimator_7_blade_1_focus_xh;
MCNUM mccinter_analyzer_colimator_7_blade_1_focus_r;
MCNUM mccinter_analyzer_colimator_7_blade_1_p_interact;
char mccinter_analyzer_colimator_7_blade_1_mask_string[16384];
char mccinter_analyzer_colimator_7_blade_1_mask_setting[16384];
MCNUM mccinter_analyzer_colimator_7_blade_1_number_of_activations;

/* Setting parameters for component 'inter_analyzer_colimator_7_blade_2' [423]. */
char mccinter_analyzer_colimator_7_blade_2_material_string[16384];
MCNUM mccinter_analyzer_colimator_7_blade_2_priority;
MCNUM mccinter_analyzer_colimator_7_blade_2_xwidth;
MCNUM mccinter_analyzer_colimator_7_blade_2_yheight;
MCNUM mccinter_analyzer_colimator_7_blade_2_zdepth;
MCNUM mccinter_analyzer_colimator_7_blade_2_xwidth2;
MCNUM mccinter_analyzer_colimator_7_blade_2_yheight2;
MCNUM mccinter_analyzer_colimator_7_blade_2_visualize;
int mccinter_analyzer_colimator_7_blade_2_target_index;
MCNUM mccinter_analyzer_colimator_7_blade_2_target_x;
MCNUM mccinter_analyzer_colimator_7_blade_2_target_y;
MCNUM mccinter_analyzer_colimator_7_blade_2_target_z;
MCNUM mccinter_analyzer_colimator_7_blade_2_focus_aw;
MCNUM mccinter_analyzer_colimator_7_blade_2_focus_ah;
MCNUM mccinter_analyzer_colimator_7_blade_2_focus_xw;
MCNUM mccinter_analyzer_colimator_7_blade_2_focus_xh;
MCNUM mccinter_analyzer_colimator_7_blade_2_focus_r;
MCNUM mccinter_analyzer_colimator_7_blade_2_p_interact;
char mccinter_analyzer_colimator_7_blade_2_mask_string[16384];
char mccinter_analyzer_colimator_7_blade_2_mask_setting[16384];
MCNUM mccinter_analyzer_colimator_7_blade_2_number_of_activations;

/* Setting parameters for component 'inter_analyzer_colimator_7_blade_3' [424]. */
char mccinter_analyzer_colimator_7_blade_3_material_string[16384];
MCNUM mccinter_analyzer_colimator_7_blade_3_priority;
MCNUM mccinter_analyzer_colimator_7_blade_3_xwidth;
MCNUM mccinter_analyzer_colimator_7_blade_3_yheight;
MCNUM mccinter_analyzer_colimator_7_blade_3_zdepth;
MCNUM mccinter_analyzer_colimator_7_blade_3_xwidth2;
MCNUM mccinter_analyzer_colimator_7_blade_3_yheight2;
MCNUM mccinter_analyzer_colimator_7_blade_3_visualize;
int mccinter_analyzer_colimator_7_blade_3_target_index;
MCNUM mccinter_analyzer_colimator_7_blade_3_target_x;
MCNUM mccinter_analyzer_colimator_7_blade_3_target_y;
MCNUM mccinter_analyzer_colimator_7_blade_3_target_z;
MCNUM mccinter_analyzer_colimator_7_blade_3_focus_aw;
MCNUM mccinter_analyzer_colimator_7_blade_3_focus_ah;
MCNUM mccinter_analyzer_colimator_7_blade_3_focus_xw;
MCNUM mccinter_analyzer_colimator_7_blade_3_focus_xh;
MCNUM mccinter_analyzer_colimator_7_blade_3_focus_r;
MCNUM mccinter_analyzer_colimator_7_blade_3_p_interact;
char mccinter_analyzer_colimator_7_blade_3_mask_string[16384];
char mccinter_analyzer_colimator_7_blade_3_mask_setting[16384];
MCNUM mccinter_analyzer_colimator_7_blade_3_number_of_activations;

/* Setting parameters for component 'inter_analyzer_colimator_7_blade_4' [425]. */
char mccinter_analyzer_colimator_7_blade_4_material_string[16384];
MCNUM mccinter_analyzer_colimator_7_blade_4_priority;
MCNUM mccinter_analyzer_colimator_7_blade_4_xwidth;
MCNUM mccinter_analyzer_colimator_7_blade_4_yheight;
MCNUM mccinter_analyzer_colimator_7_blade_4_zdepth;
MCNUM mccinter_analyzer_colimator_7_blade_4_xwidth2;
MCNUM mccinter_analyzer_colimator_7_blade_4_yheight2;
MCNUM mccinter_analyzer_colimator_7_blade_4_visualize;
int mccinter_analyzer_colimator_7_blade_4_target_index;
MCNUM mccinter_analyzer_colimator_7_blade_4_target_x;
MCNUM mccinter_analyzer_colimator_7_blade_4_target_y;
MCNUM mccinter_analyzer_colimator_7_blade_4_target_z;
MCNUM mccinter_analyzer_colimator_7_blade_4_focus_aw;
MCNUM mccinter_analyzer_colimator_7_blade_4_focus_ah;
MCNUM mccinter_analyzer_colimator_7_blade_4_focus_xw;
MCNUM mccinter_analyzer_colimator_7_blade_4_focus_xh;
MCNUM mccinter_analyzer_colimator_7_blade_4_focus_r;
MCNUM mccinter_analyzer_colimator_7_blade_4_p_interact;
char mccinter_analyzer_colimator_7_blade_4_mask_string[16384];
char mccinter_analyzer_colimator_7_blade_4_mask_setting[16384];
MCNUM mccinter_analyzer_colimator_7_blade_4_number_of_activations;

/* Setting parameters for component 'diffraction_detector_7_exit_volume' [426]. */
char mccdiffraction_detector_7_exit_volume_material_string[16384];
MCNUM mccdiffraction_detector_7_exit_volume_priority;
MCNUM mccdiffraction_detector_7_exit_volume_xwidth;
MCNUM mccdiffraction_detector_7_exit_volume_yheight;
MCNUM mccdiffraction_detector_7_exit_volume_zdepth;
MCNUM mccdiffraction_detector_7_exit_volume_xwidth2;
MCNUM mccdiffraction_detector_7_exit_volume_yheight2;
MCNUM mccdiffraction_detector_7_exit_volume_visualize;
int mccdiffraction_detector_7_exit_volume_target_index;
MCNUM mccdiffraction_detector_7_exit_volume_target_x;
MCNUM mccdiffraction_detector_7_exit_volume_target_y;
MCNUM mccdiffraction_detector_7_exit_volume_target_z;
MCNUM mccdiffraction_detector_7_exit_volume_focus_aw;
MCNUM mccdiffraction_detector_7_exit_volume_focus_ah;
MCNUM mccdiffraction_detector_7_exit_volume_focus_xw;
MCNUM mccdiffraction_detector_7_exit_volume_focus_xh;
MCNUM mccdiffraction_detector_7_exit_volume_focus_r;
MCNUM mccdiffraction_detector_7_exit_volume_p_interact;
char mccdiffraction_detector_7_exit_volume_mask_string[16384];
char mccdiffraction_detector_7_exit_volume_mask_setting[16384];
MCNUM mccdiffraction_detector_7_exit_volume_number_of_activations;

/* Setting parameters for component 'spec_detector_7_exit_volume' [427]. */
char mccspec_detector_7_exit_volume_material_string[16384];
MCNUM mccspec_detector_7_exit_volume_priority;
MCNUM mccspec_detector_7_exit_volume_xwidth;
MCNUM mccspec_detector_7_exit_volume_yheight;
MCNUM mccspec_detector_7_exit_volume_zdepth;
MCNUM mccspec_detector_7_exit_volume_xwidth2;
MCNUM mccspec_detector_7_exit_volume_yheight2;
MCNUM mccspec_detector_7_exit_volume_visualize;
int mccspec_detector_7_exit_volume_target_index;
MCNUM mccspec_detector_7_exit_volume_target_x;
MCNUM mccspec_detector_7_exit_volume_target_y;
MCNUM mccspec_detector_7_exit_volume_target_z;
MCNUM mccspec_detector_7_exit_volume_focus_aw;
MCNUM mccspec_detector_7_exit_volume_focus_ah;
MCNUM mccspec_detector_7_exit_volume_focus_xw;
MCNUM mccspec_detector_7_exit_volume_focus_xh;
MCNUM mccspec_detector_7_exit_volume_focus_r;
MCNUM mccspec_detector_7_exit_volume_p_interact;
char mccspec_detector_7_exit_volume_mask_string[16384];
char mccspec_detector_7_exit_volume_mask_setting[16384];
MCNUM mccspec_detector_7_exit_volume_number_of_activations;

/* Setting parameters for component 'channel_8_cave1_box1' [428]. */
char mccchannel_8_cave1_box1_material_string[16384];
MCNUM mccchannel_8_cave1_box1_priority;
MCNUM mccchannel_8_cave1_box1_xwidth;
MCNUM mccchannel_8_cave1_box1_yheight;
MCNUM mccchannel_8_cave1_box1_zdepth;
MCNUM mccchannel_8_cave1_box1_xwidth2;
MCNUM mccchannel_8_cave1_box1_yheight2;
MCNUM mccchannel_8_cave1_box1_visualize;
int mccchannel_8_cave1_box1_target_index;
MCNUM mccchannel_8_cave1_box1_target_x;
MCNUM mccchannel_8_cave1_box1_target_y;
MCNUM mccchannel_8_cave1_box1_target_z;
MCNUM mccchannel_8_cave1_box1_focus_aw;
MCNUM mccchannel_8_cave1_box1_focus_ah;
MCNUM mccchannel_8_cave1_box1_focus_xw;
MCNUM mccchannel_8_cave1_box1_focus_xh;
MCNUM mccchannel_8_cave1_box1_focus_r;
MCNUM mccchannel_8_cave1_box1_p_interact;
char mccchannel_8_cave1_box1_mask_string[16384];
char mccchannel_8_cave1_box1_mask_setting[16384];
MCNUM mccchannel_8_cave1_box1_number_of_activations;

/* Setting parameters for component 'channel_8_cave1_box2' [429]. */
char mccchannel_8_cave1_box2_material_string[16384];
MCNUM mccchannel_8_cave1_box2_priority;
MCNUM mccchannel_8_cave1_box2_xwidth;
MCNUM mccchannel_8_cave1_box2_yheight;
MCNUM mccchannel_8_cave1_box2_zdepth;
MCNUM mccchannel_8_cave1_box2_xwidth2;
MCNUM mccchannel_8_cave1_box2_yheight2;
MCNUM mccchannel_8_cave1_box2_visualize;
int mccchannel_8_cave1_box2_target_index;
MCNUM mccchannel_8_cave1_box2_target_x;
MCNUM mccchannel_8_cave1_box2_target_y;
MCNUM mccchannel_8_cave1_box2_target_z;
MCNUM mccchannel_8_cave1_box2_focus_aw;
MCNUM mccchannel_8_cave1_box2_focus_ah;
MCNUM mccchannel_8_cave1_box2_focus_xw;
MCNUM mccchannel_8_cave1_box2_focus_xh;
MCNUM mccchannel_8_cave1_box2_focus_r;
MCNUM mccchannel_8_cave1_box2_p_interact;
char mccchannel_8_cave1_box2_mask_string[16384];
char mccchannel_8_cave1_box2_mask_setting[16384];
MCNUM mccchannel_8_cave1_box2_number_of_activations;

/* Setting parameters for component 'channel_8_cave1_box3' [430]. */
char mccchannel_8_cave1_box3_material_string[16384];
MCNUM mccchannel_8_cave1_box3_priority;
MCNUM mccchannel_8_cave1_box3_xwidth;
MCNUM mccchannel_8_cave1_box3_yheight;
MCNUM mccchannel_8_cave1_box3_zdepth;
MCNUM mccchannel_8_cave1_box3_xwidth2;
MCNUM mccchannel_8_cave1_box3_yheight2;
MCNUM mccchannel_8_cave1_box3_visualize;
int mccchannel_8_cave1_box3_target_index;
MCNUM mccchannel_8_cave1_box3_target_x;
MCNUM mccchannel_8_cave1_box3_target_y;
MCNUM mccchannel_8_cave1_box3_target_z;
MCNUM mccchannel_8_cave1_box3_focus_aw;
MCNUM mccchannel_8_cave1_box3_focus_ah;
MCNUM mccchannel_8_cave1_box3_focus_xw;
MCNUM mccchannel_8_cave1_box3_focus_xh;
MCNUM mccchannel_8_cave1_box3_focus_r;
MCNUM mccchannel_8_cave1_box3_p_interact;
char mccchannel_8_cave1_box3_mask_string[16384];
char mccchannel_8_cave1_box3_mask_setting[16384];
MCNUM mccchannel_8_cave1_box3_number_of_activations;

/* Setting parameters for component 'channel_8_cave1_cyl1' [431]. */
char mccchannel_8_cave1_cyl1_material_string[16384];
MCNUM mccchannel_8_cave1_cyl1_priority;
MCNUM mccchannel_8_cave1_cyl1_radius;
MCNUM mccchannel_8_cave1_cyl1_yheight;
MCNUM mccchannel_8_cave1_cyl1_visualize;
int mccchannel_8_cave1_cyl1_target_index;
MCNUM mccchannel_8_cave1_cyl1_target_x;
MCNUM mccchannel_8_cave1_cyl1_target_y;
MCNUM mccchannel_8_cave1_cyl1_target_z;
MCNUM mccchannel_8_cave1_cyl1_focus_aw;
MCNUM mccchannel_8_cave1_cyl1_focus_ah;
MCNUM mccchannel_8_cave1_cyl1_focus_xw;
MCNUM mccchannel_8_cave1_cyl1_focus_xh;
MCNUM mccchannel_8_cave1_cyl1_focus_r;
MCNUM mccchannel_8_cave1_cyl1_p_interact;
char mccchannel_8_cave1_cyl1_mask_string[16384];
char mccchannel_8_cave1_cyl1_mask_setting[16384];
MCNUM mccchannel_8_cave1_cyl1_number_of_activations;

/* Setting parameters for component 'channel_8_analyzer_1_array_crystal_array_0' [434]. */
char mccchannel_8_analyzer_1_array_crystal_array_0_material_string[16384];
MCNUM mccchannel_8_analyzer_1_array_crystal_array_0_priority;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_0_xwidth;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_0_yheight;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_0_zdepth;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_0_xwidth2;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_0_yheight2;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_0_visualize;
int mccchannel_8_analyzer_1_array_crystal_array_0_target_index;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_0_target_x;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_0_target_y;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_0_target_z;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_0_focus_aw;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_0_focus_ah;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_0_focus_xw;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_0_focus_xh;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_0_focus_r;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_0_p_interact;
char mccchannel_8_analyzer_1_array_crystal_array_0_mask_string[16384];
char mccchannel_8_analyzer_1_array_crystal_array_0_mask_setting[16384];
MCNUM mccchannel_8_analyzer_1_array_crystal_array_0_number_of_activations;

/* Setting parameters for component 'channel_8_analyzer_1_array_crystal_array_1' [435]. */
char mccchannel_8_analyzer_1_array_crystal_array_1_material_string[16384];
MCNUM mccchannel_8_analyzer_1_array_crystal_array_1_priority;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_1_xwidth;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_1_yheight;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_1_zdepth;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_1_xwidth2;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_1_yheight2;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_1_visualize;
int mccchannel_8_analyzer_1_array_crystal_array_1_target_index;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_1_target_x;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_1_target_y;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_1_target_z;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_1_focus_aw;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_1_focus_ah;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_1_focus_xw;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_1_focus_xh;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_1_focus_r;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_1_p_interact;
char mccchannel_8_analyzer_1_array_crystal_array_1_mask_string[16384];
char mccchannel_8_analyzer_1_array_crystal_array_1_mask_setting[16384];
MCNUM mccchannel_8_analyzer_1_array_crystal_array_1_number_of_activations;

/* Setting parameters for component 'channel_8_analyzer_1_array_crystal_array_2' [436]. */
char mccchannel_8_analyzer_1_array_crystal_array_2_material_string[16384];
MCNUM mccchannel_8_analyzer_1_array_crystal_array_2_priority;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_2_xwidth;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_2_yheight;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_2_zdepth;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_2_xwidth2;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_2_yheight2;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_2_visualize;
int mccchannel_8_analyzer_1_array_crystal_array_2_target_index;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_2_target_x;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_2_target_y;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_2_target_z;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_2_focus_aw;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_2_focus_ah;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_2_focus_xw;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_2_focus_xh;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_2_focus_r;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_2_p_interact;
char mccchannel_8_analyzer_1_array_crystal_array_2_mask_string[16384];
char mccchannel_8_analyzer_1_array_crystal_array_2_mask_setting[16384];
MCNUM mccchannel_8_analyzer_1_array_crystal_array_2_number_of_activations;

/* Setting parameters for component 'channel_8_analyzer_1_array_crystal_array_3' [437]. */
char mccchannel_8_analyzer_1_array_crystal_array_3_material_string[16384];
MCNUM mccchannel_8_analyzer_1_array_crystal_array_3_priority;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_3_xwidth;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_3_yheight;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_3_zdepth;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_3_xwidth2;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_3_yheight2;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_3_visualize;
int mccchannel_8_analyzer_1_array_crystal_array_3_target_index;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_3_target_x;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_3_target_y;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_3_target_z;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_3_focus_aw;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_3_focus_ah;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_3_focus_xw;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_3_focus_xh;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_3_focus_r;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_3_p_interact;
char mccchannel_8_analyzer_1_array_crystal_array_3_mask_string[16384];
char mccchannel_8_analyzer_1_array_crystal_array_3_mask_setting[16384];
MCNUM mccchannel_8_analyzer_1_array_crystal_array_3_number_of_activations;

/* Setting parameters for component 'channel_8_analyzer_1_array_crystal_array_4' [438]. */
char mccchannel_8_analyzer_1_array_crystal_array_4_material_string[16384];
MCNUM mccchannel_8_analyzer_1_array_crystal_array_4_priority;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_4_xwidth;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_4_yheight;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_4_zdepth;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_4_xwidth2;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_4_yheight2;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_4_visualize;
int mccchannel_8_analyzer_1_array_crystal_array_4_target_index;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_4_target_x;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_4_target_y;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_4_target_z;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_4_focus_aw;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_4_focus_ah;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_4_focus_xw;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_4_focus_xh;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_4_focus_r;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_4_p_interact;
char mccchannel_8_analyzer_1_array_crystal_array_4_mask_string[16384];
char mccchannel_8_analyzer_1_array_crystal_array_4_mask_setting[16384];
MCNUM mccchannel_8_analyzer_1_array_crystal_array_4_number_of_activations;

/* Setting parameters for component 'channel_8_analyzer_1_array_crystal_array_5' [439]. */
char mccchannel_8_analyzer_1_array_crystal_array_5_material_string[16384];
MCNUM mccchannel_8_analyzer_1_array_crystal_array_5_priority;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_5_xwidth;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_5_yheight;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_5_zdepth;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_5_xwidth2;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_5_yheight2;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_5_visualize;
int mccchannel_8_analyzer_1_array_crystal_array_5_target_index;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_5_target_x;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_5_target_y;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_5_target_z;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_5_focus_aw;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_5_focus_ah;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_5_focus_xw;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_5_focus_xh;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_5_focus_r;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_5_p_interact;
char mccchannel_8_analyzer_1_array_crystal_array_5_mask_string[16384];
char mccchannel_8_analyzer_1_array_crystal_array_5_mask_setting[16384];
MCNUM mccchannel_8_analyzer_1_array_crystal_array_5_number_of_activations;

/* Setting parameters for component 'channel_8_analyzer_1_array_crystal_array_6' [440]. */
char mccchannel_8_analyzer_1_array_crystal_array_6_material_string[16384];
MCNUM mccchannel_8_analyzer_1_array_crystal_array_6_priority;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_6_xwidth;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_6_yheight;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_6_zdepth;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_6_xwidth2;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_6_yheight2;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_6_visualize;
int mccchannel_8_analyzer_1_array_crystal_array_6_target_index;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_6_target_x;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_6_target_y;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_6_target_z;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_6_focus_aw;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_6_focus_ah;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_6_focus_xw;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_6_focus_xh;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_6_focus_r;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_6_p_interact;
char mccchannel_8_analyzer_1_array_crystal_array_6_mask_string[16384];
char mccchannel_8_analyzer_1_array_crystal_array_6_mask_setting[16384];
MCNUM mccchannel_8_analyzer_1_array_crystal_array_6_number_of_activations;

/* Setting parameters for component 'channel_8_analyzer_1_array_crystal_array_7' [441]. */
char mccchannel_8_analyzer_1_array_crystal_array_7_material_string[16384];
MCNUM mccchannel_8_analyzer_1_array_crystal_array_7_priority;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_7_xwidth;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_7_yheight;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_7_zdepth;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_7_xwidth2;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_7_yheight2;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_7_visualize;
int mccchannel_8_analyzer_1_array_crystal_array_7_target_index;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_7_target_x;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_7_target_y;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_7_target_z;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_7_focus_aw;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_7_focus_ah;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_7_focus_xw;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_7_focus_xh;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_7_focus_r;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_7_p_interact;
char mccchannel_8_analyzer_1_array_crystal_array_7_mask_string[16384];
char mccchannel_8_analyzer_1_array_crystal_array_7_mask_setting[16384];
MCNUM mccchannel_8_analyzer_1_array_crystal_array_7_number_of_activations;

/* Setting parameters for component 'channel_8_analyzer_1_array_crystal_array_8' [442]. */
char mccchannel_8_analyzer_1_array_crystal_array_8_material_string[16384];
MCNUM mccchannel_8_analyzer_1_array_crystal_array_8_priority;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_8_xwidth;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_8_yheight;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_8_zdepth;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_8_xwidth2;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_8_yheight2;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_8_visualize;
int mccchannel_8_analyzer_1_array_crystal_array_8_target_index;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_8_target_x;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_8_target_y;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_8_target_z;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_8_focus_aw;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_8_focus_ah;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_8_focus_xw;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_8_focus_xh;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_8_focus_r;
MCNUM mccchannel_8_analyzer_1_array_crystal_array_8_p_interact;
char mccchannel_8_analyzer_1_array_crystal_array_8_mask_string[16384];
char mccchannel_8_analyzer_1_array_crystal_array_8_mask_setting[16384];
MCNUM mccchannel_8_analyzer_1_array_crystal_array_8_number_of_activations;

/* Setting parameters for component 'channel_8_analyzer_2_array_crystal_array_0' [445]. */
char mccchannel_8_analyzer_2_array_crystal_array_0_material_string[16384];
MCNUM mccchannel_8_analyzer_2_array_crystal_array_0_priority;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_0_xwidth;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_0_yheight;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_0_zdepth;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_0_xwidth2;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_0_yheight2;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_0_visualize;
int mccchannel_8_analyzer_2_array_crystal_array_0_target_index;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_0_target_x;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_0_target_y;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_0_target_z;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_0_focus_aw;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_0_focus_ah;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_0_focus_xw;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_0_focus_xh;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_0_focus_r;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_0_p_interact;
char mccchannel_8_analyzer_2_array_crystal_array_0_mask_string[16384];
char mccchannel_8_analyzer_2_array_crystal_array_0_mask_setting[16384];
MCNUM mccchannel_8_analyzer_2_array_crystal_array_0_number_of_activations;

/* Setting parameters for component 'channel_8_analyzer_2_array_crystal_array_1' [446]. */
char mccchannel_8_analyzer_2_array_crystal_array_1_material_string[16384];
MCNUM mccchannel_8_analyzer_2_array_crystal_array_1_priority;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_1_xwidth;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_1_yheight;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_1_zdepth;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_1_xwidth2;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_1_yheight2;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_1_visualize;
int mccchannel_8_analyzer_2_array_crystal_array_1_target_index;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_1_target_x;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_1_target_y;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_1_target_z;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_1_focus_aw;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_1_focus_ah;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_1_focus_xw;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_1_focus_xh;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_1_focus_r;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_1_p_interact;
char mccchannel_8_analyzer_2_array_crystal_array_1_mask_string[16384];
char mccchannel_8_analyzer_2_array_crystal_array_1_mask_setting[16384];
MCNUM mccchannel_8_analyzer_2_array_crystal_array_1_number_of_activations;

/* Setting parameters for component 'channel_8_analyzer_2_array_crystal_array_2' [447]. */
char mccchannel_8_analyzer_2_array_crystal_array_2_material_string[16384];
MCNUM mccchannel_8_analyzer_2_array_crystal_array_2_priority;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_2_xwidth;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_2_yheight;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_2_zdepth;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_2_xwidth2;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_2_yheight2;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_2_visualize;
int mccchannel_8_analyzer_2_array_crystal_array_2_target_index;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_2_target_x;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_2_target_y;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_2_target_z;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_2_focus_aw;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_2_focus_ah;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_2_focus_xw;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_2_focus_xh;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_2_focus_r;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_2_p_interact;
char mccchannel_8_analyzer_2_array_crystal_array_2_mask_string[16384];
char mccchannel_8_analyzer_2_array_crystal_array_2_mask_setting[16384];
MCNUM mccchannel_8_analyzer_2_array_crystal_array_2_number_of_activations;

/* Setting parameters for component 'channel_8_analyzer_2_array_crystal_array_3' [448]. */
char mccchannel_8_analyzer_2_array_crystal_array_3_material_string[16384];
MCNUM mccchannel_8_analyzer_2_array_crystal_array_3_priority;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_3_xwidth;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_3_yheight;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_3_zdepth;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_3_xwidth2;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_3_yheight2;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_3_visualize;
int mccchannel_8_analyzer_2_array_crystal_array_3_target_index;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_3_target_x;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_3_target_y;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_3_target_z;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_3_focus_aw;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_3_focus_ah;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_3_focus_xw;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_3_focus_xh;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_3_focus_r;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_3_p_interact;
char mccchannel_8_analyzer_2_array_crystal_array_3_mask_string[16384];
char mccchannel_8_analyzer_2_array_crystal_array_3_mask_setting[16384];
MCNUM mccchannel_8_analyzer_2_array_crystal_array_3_number_of_activations;

/* Setting parameters for component 'channel_8_analyzer_2_array_crystal_array_4' [449]. */
char mccchannel_8_analyzer_2_array_crystal_array_4_material_string[16384];
MCNUM mccchannel_8_analyzer_2_array_crystal_array_4_priority;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_4_xwidth;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_4_yheight;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_4_zdepth;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_4_xwidth2;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_4_yheight2;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_4_visualize;
int mccchannel_8_analyzer_2_array_crystal_array_4_target_index;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_4_target_x;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_4_target_y;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_4_target_z;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_4_focus_aw;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_4_focus_ah;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_4_focus_xw;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_4_focus_xh;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_4_focus_r;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_4_p_interact;
char mccchannel_8_analyzer_2_array_crystal_array_4_mask_string[16384];
char mccchannel_8_analyzer_2_array_crystal_array_4_mask_setting[16384];
MCNUM mccchannel_8_analyzer_2_array_crystal_array_4_number_of_activations;

/* Setting parameters for component 'channel_8_analyzer_2_array_crystal_array_5' [450]. */
char mccchannel_8_analyzer_2_array_crystal_array_5_material_string[16384];
MCNUM mccchannel_8_analyzer_2_array_crystal_array_5_priority;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_5_xwidth;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_5_yheight;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_5_zdepth;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_5_xwidth2;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_5_yheight2;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_5_visualize;
int mccchannel_8_analyzer_2_array_crystal_array_5_target_index;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_5_target_x;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_5_target_y;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_5_target_z;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_5_focus_aw;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_5_focus_ah;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_5_focus_xw;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_5_focus_xh;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_5_focus_r;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_5_p_interact;
char mccchannel_8_analyzer_2_array_crystal_array_5_mask_string[16384];
char mccchannel_8_analyzer_2_array_crystal_array_5_mask_setting[16384];
MCNUM mccchannel_8_analyzer_2_array_crystal_array_5_number_of_activations;

/* Setting parameters for component 'channel_8_analyzer_2_array_crystal_array_6' [451]. */
char mccchannel_8_analyzer_2_array_crystal_array_6_material_string[16384];
MCNUM mccchannel_8_analyzer_2_array_crystal_array_6_priority;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_6_xwidth;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_6_yheight;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_6_zdepth;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_6_xwidth2;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_6_yheight2;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_6_visualize;
int mccchannel_8_analyzer_2_array_crystal_array_6_target_index;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_6_target_x;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_6_target_y;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_6_target_z;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_6_focus_aw;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_6_focus_ah;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_6_focus_xw;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_6_focus_xh;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_6_focus_r;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_6_p_interact;
char mccchannel_8_analyzer_2_array_crystal_array_6_mask_string[16384];
char mccchannel_8_analyzer_2_array_crystal_array_6_mask_setting[16384];
MCNUM mccchannel_8_analyzer_2_array_crystal_array_6_number_of_activations;

/* Setting parameters for component 'channel_8_analyzer_2_array_crystal_array_7' [452]. */
char mccchannel_8_analyzer_2_array_crystal_array_7_material_string[16384];
MCNUM mccchannel_8_analyzer_2_array_crystal_array_7_priority;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_7_xwidth;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_7_yheight;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_7_zdepth;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_7_xwidth2;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_7_yheight2;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_7_visualize;
int mccchannel_8_analyzer_2_array_crystal_array_7_target_index;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_7_target_x;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_7_target_y;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_7_target_z;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_7_focus_aw;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_7_focus_ah;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_7_focus_xw;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_7_focus_xh;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_7_focus_r;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_7_p_interact;
char mccchannel_8_analyzer_2_array_crystal_array_7_mask_string[16384];
char mccchannel_8_analyzer_2_array_crystal_array_7_mask_setting[16384];
MCNUM mccchannel_8_analyzer_2_array_crystal_array_7_number_of_activations;

/* Setting parameters for component 'channel_8_analyzer_2_array_crystal_array_8' [453]. */
char mccchannel_8_analyzer_2_array_crystal_array_8_material_string[16384];
MCNUM mccchannel_8_analyzer_2_array_crystal_array_8_priority;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_8_xwidth;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_8_yheight;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_8_zdepth;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_8_xwidth2;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_8_yheight2;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_8_visualize;
int mccchannel_8_analyzer_2_array_crystal_array_8_target_index;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_8_target_x;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_8_target_y;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_8_target_z;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_8_focus_aw;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_8_focus_ah;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_8_focus_xw;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_8_focus_xh;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_8_focus_r;
MCNUM mccchannel_8_analyzer_2_array_crystal_array_8_p_interact;
char mccchannel_8_analyzer_2_array_crystal_array_8_mask_string[16384];
char mccchannel_8_analyzer_2_array_crystal_array_8_mask_setting[16384];
MCNUM mccchannel_8_analyzer_2_array_crystal_array_8_number_of_activations;

/* Setting parameters for component 'channel_8_cave2_cyl1' [454]. */
char mccchannel_8_cave2_cyl1_material_string[16384];
MCNUM mccchannel_8_cave2_cyl1_priority;
MCNUM mccchannel_8_cave2_cyl1_radius;
MCNUM mccchannel_8_cave2_cyl1_yheight;
MCNUM mccchannel_8_cave2_cyl1_visualize;
int mccchannel_8_cave2_cyl1_target_index;
MCNUM mccchannel_8_cave2_cyl1_target_x;
MCNUM mccchannel_8_cave2_cyl1_target_y;
MCNUM mccchannel_8_cave2_cyl1_target_z;
MCNUM mccchannel_8_cave2_cyl1_focus_aw;
MCNUM mccchannel_8_cave2_cyl1_focus_ah;
MCNUM mccchannel_8_cave2_cyl1_focus_xw;
MCNUM mccchannel_8_cave2_cyl1_focus_xh;
MCNUM mccchannel_8_cave2_cyl1_focus_r;
MCNUM mccchannel_8_cave2_cyl1_p_interact;
char mccchannel_8_cave2_cyl1_mask_string[16384];
char mccchannel_8_cave2_cyl1_mask_setting[16384];
MCNUM mccchannel_8_cave2_cyl1_number_of_activations;

/* Setting parameters for component 'channel_8_cave2_box1' [455]. */
char mccchannel_8_cave2_box1_material_string[16384];
MCNUM mccchannel_8_cave2_box1_priority;
MCNUM mccchannel_8_cave2_box1_xwidth;
MCNUM mccchannel_8_cave2_box1_yheight;
MCNUM mccchannel_8_cave2_box1_zdepth;
MCNUM mccchannel_8_cave2_box1_xwidth2;
MCNUM mccchannel_8_cave2_box1_yheight2;
MCNUM mccchannel_8_cave2_box1_visualize;
int mccchannel_8_cave2_box1_target_index;
MCNUM mccchannel_8_cave2_box1_target_x;
MCNUM mccchannel_8_cave2_box1_target_y;
MCNUM mccchannel_8_cave2_box1_target_z;
MCNUM mccchannel_8_cave2_box1_focus_aw;
MCNUM mccchannel_8_cave2_box1_focus_ah;
MCNUM mccchannel_8_cave2_box1_focus_xw;
MCNUM mccchannel_8_cave2_box1_focus_xh;
MCNUM mccchannel_8_cave2_box1_focus_r;
MCNUM mccchannel_8_cave2_box1_p_interact;
char mccchannel_8_cave2_box1_mask_string[16384];
char mccchannel_8_cave2_box1_mask_setting[16384];
MCNUM mccchannel_8_cave2_box1_number_of_activations;

/* Setting parameters for component 'channel_8_cave2_box2' [456]. */
char mccchannel_8_cave2_box2_material_string[16384];
MCNUM mccchannel_8_cave2_box2_priority;
MCNUM mccchannel_8_cave2_box2_xwidth;
MCNUM mccchannel_8_cave2_box2_yheight;
MCNUM mccchannel_8_cave2_box2_zdepth;
MCNUM mccchannel_8_cave2_box2_xwidth2;
MCNUM mccchannel_8_cave2_box2_yheight2;
MCNUM mccchannel_8_cave2_box2_visualize;
int mccchannel_8_cave2_box2_target_index;
MCNUM mccchannel_8_cave2_box2_target_x;
MCNUM mccchannel_8_cave2_box2_target_y;
MCNUM mccchannel_8_cave2_box2_target_z;
MCNUM mccchannel_8_cave2_box2_focus_aw;
MCNUM mccchannel_8_cave2_box2_focus_ah;
MCNUM mccchannel_8_cave2_box2_focus_xw;
MCNUM mccchannel_8_cave2_box2_focus_xh;
MCNUM mccchannel_8_cave2_box2_focus_r;
MCNUM mccchannel_8_cave2_box2_p_interact;
char mccchannel_8_cave2_box2_mask_string[16384];
char mccchannel_8_cave2_box2_mask_setting[16384];
MCNUM mccchannel_8_cave2_box2_number_of_activations;

/* Setting parameters for component 'channel_8_cave2_box3' [457]. */
char mccchannel_8_cave2_box3_material_string[16384];
MCNUM mccchannel_8_cave2_box3_priority;
MCNUM mccchannel_8_cave2_box3_xwidth;
MCNUM mccchannel_8_cave2_box3_yheight;
MCNUM mccchannel_8_cave2_box3_zdepth;
MCNUM mccchannel_8_cave2_box3_xwidth2;
MCNUM mccchannel_8_cave2_box3_yheight2;
MCNUM mccchannel_8_cave2_box3_visualize;
int mccchannel_8_cave2_box3_target_index;
MCNUM mccchannel_8_cave2_box3_target_x;
MCNUM mccchannel_8_cave2_box3_target_y;
MCNUM mccchannel_8_cave2_box3_target_z;
MCNUM mccchannel_8_cave2_box3_focus_aw;
MCNUM mccchannel_8_cave2_box3_focus_ah;
MCNUM mccchannel_8_cave2_box3_focus_xw;
MCNUM mccchannel_8_cave2_box3_focus_xh;
MCNUM mccchannel_8_cave2_box3_focus_r;
MCNUM mccchannel_8_cave2_box3_p_interact;
char mccchannel_8_cave2_box3_mask_string[16384];
char mccchannel_8_cave2_box3_mask_setting[16384];
MCNUM mccchannel_8_cave2_box3_number_of_activations;

/* Setting parameters for component 'inter_analyzer_colimator_8_blade_0' [459]. */
char mccinter_analyzer_colimator_8_blade_0_material_string[16384];
MCNUM mccinter_analyzer_colimator_8_blade_0_priority;
MCNUM mccinter_analyzer_colimator_8_blade_0_xwidth;
MCNUM mccinter_analyzer_colimator_8_blade_0_yheight;
MCNUM mccinter_analyzer_colimator_8_blade_0_zdepth;
MCNUM mccinter_analyzer_colimator_8_blade_0_xwidth2;
MCNUM mccinter_analyzer_colimator_8_blade_0_yheight2;
MCNUM mccinter_analyzer_colimator_8_blade_0_visualize;
int mccinter_analyzer_colimator_8_blade_0_target_index;
MCNUM mccinter_analyzer_colimator_8_blade_0_target_x;
MCNUM mccinter_analyzer_colimator_8_blade_0_target_y;
MCNUM mccinter_analyzer_colimator_8_blade_0_target_z;
MCNUM mccinter_analyzer_colimator_8_blade_0_focus_aw;
MCNUM mccinter_analyzer_colimator_8_blade_0_focus_ah;
MCNUM mccinter_analyzer_colimator_8_blade_0_focus_xw;
MCNUM mccinter_analyzer_colimator_8_blade_0_focus_xh;
MCNUM mccinter_analyzer_colimator_8_blade_0_focus_r;
MCNUM mccinter_analyzer_colimator_8_blade_0_p_interact;
char mccinter_analyzer_colimator_8_blade_0_mask_string[16384];
char mccinter_analyzer_colimator_8_blade_0_mask_setting[16384];
MCNUM mccinter_analyzer_colimator_8_blade_0_number_of_activations;

/* Setting parameters for component 'inter_analyzer_colimator_8_blade_1' [460]. */
char mccinter_analyzer_colimator_8_blade_1_material_string[16384];
MCNUM mccinter_analyzer_colimator_8_blade_1_priority;
MCNUM mccinter_analyzer_colimator_8_blade_1_xwidth;
MCNUM mccinter_analyzer_colimator_8_blade_1_yheight;
MCNUM mccinter_analyzer_colimator_8_blade_1_zdepth;
MCNUM mccinter_analyzer_colimator_8_blade_1_xwidth2;
MCNUM mccinter_analyzer_colimator_8_blade_1_yheight2;
MCNUM mccinter_analyzer_colimator_8_blade_1_visualize;
int mccinter_analyzer_colimator_8_blade_1_target_index;
MCNUM mccinter_analyzer_colimator_8_blade_1_target_x;
MCNUM mccinter_analyzer_colimator_8_blade_1_target_y;
MCNUM mccinter_analyzer_colimator_8_blade_1_target_z;
MCNUM mccinter_analyzer_colimator_8_blade_1_focus_aw;
MCNUM mccinter_analyzer_colimator_8_blade_1_focus_ah;
MCNUM mccinter_analyzer_colimator_8_blade_1_focus_xw;
MCNUM mccinter_analyzer_colimator_8_blade_1_focus_xh;
MCNUM mccinter_analyzer_colimator_8_blade_1_focus_r;
MCNUM mccinter_analyzer_colimator_8_blade_1_p_interact;
char mccinter_analyzer_colimator_8_blade_1_mask_string[16384];
char mccinter_analyzer_colimator_8_blade_1_mask_setting[16384];
MCNUM mccinter_analyzer_colimator_8_blade_1_number_of_activations;

/* Setting parameters for component 'inter_analyzer_colimator_8_blade_2' [461]. */
char mccinter_analyzer_colimator_8_blade_2_material_string[16384];
MCNUM mccinter_analyzer_colimator_8_blade_2_priority;
MCNUM mccinter_analyzer_colimator_8_blade_2_xwidth;
MCNUM mccinter_analyzer_colimator_8_blade_2_yheight;
MCNUM mccinter_analyzer_colimator_8_blade_2_zdepth;
MCNUM mccinter_analyzer_colimator_8_blade_2_xwidth2;
MCNUM mccinter_analyzer_colimator_8_blade_2_yheight2;
MCNUM mccinter_analyzer_colimator_8_blade_2_visualize;
int mccinter_analyzer_colimator_8_blade_2_target_index;
MCNUM mccinter_analyzer_colimator_8_blade_2_target_x;
MCNUM mccinter_analyzer_colimator_8_blade_2_target_y;
MCNUM mccinter_analyzer_colimator_8_blade_2_target_z;
MCNUM mccinter_analyzer_colimator_8_blade_2_focus_aw;
MCNUM mccinter_analyzer_colimator_8_blade_2_focus_ah;
MCNUM mccinter_analyzer_colimator_8_blade_2_focus_xw;
MCNUM mccinter_analyzer_colimator_8_blade_2_focus_xh;
MCNUM mccinter_analyzer_colimator_8_blade_2_focus_r;
MCNUM mccinter_analyzer_colimator_8_blade_2_p_interact;
char mccinter_analyzer_colimator_8_blade_2_mask_string[16384];
char mccinter_analyzer_colimator_8_blade_2_mask_setting[16384];
MCNUM mccinter_analyzer_colimator_8_blade_2_number_of_activations;

/* Setting parameters for component 'inter_analyzer_colimator_8_blade_3' [462]. */
char mccinter_analyzer_colimator_8_blade_3_material_string[16384];
MCNUM mccinter_analyzer_colimator_8_blade_3_priority;
MCNUM mccinter_analyzer_colimator_8_blade_3_xwidth;
MCNUM mccinter_analyzer_colimator_8_blade_3_yheight;
MCNUM mccinter_analyzer_colimator_8_blade_3_zdepth;
MCNUM mccinter_analyzer_colimator_8_blade_3_xwidth2;
MCNUM mccinter_analyzer_colimator_8_blade_3_yheight2;
MCNUM mccinter_analyzer_colimator_8_blade_3_visualize;
int mccinter_analyzer_colimator_8_blade_3_target_index;
MCNUM mccinter_analyzer_colimator_8_blade_3_target_x;
MCNUM mccinter_analyzer_colimator_8_blade_3_target_y;
MCNUM mccinter_analyzer_colimator_8_blade_3_target_z;
MCNUM mccinter_analyzer_colimator_8_blade_3_focus_aw;
MCNUM mccinter_analyzer_colimator_8_blade_3_focus_ah;
MCNUM mccinter_analyzer_colimator_8_blade_3_focus_xw;
MCNUM mccinter_analyzer_colimator_8_blade_3_focus_xh;
MCNUM mccinter_analyzer_colimator_8_blade_3_focus_r;
MCNUM mccinter_analyzer_colimator_8_blade_3_p_interact;
char mccinter_analyzer_colimator_8_blade_3_mask_string[16384];
char mccinter_analyzer_colimator_8_blade_3_mask_setting[16384];
MCNUM mccinter_analyzer_colimator_8_blade_3_number_of_activations;

/* Setting parameters for component 'inter_analyzer_colimator_8_blade_4' [463]. */
char mccinter_analyzer_colimator_8_blade_4_material_string[16384];
MCNUM mccinter_analyzer_colimator_8_blade_4_priority;
MCNUM mccinter_analyzer_colimator_8_blade_4_xwidth;
MCNUM mccinter_analyzer_colimator_8_blade_4_yheight;
MCNUM mccinter_analyzer_colimator_8_blade_4_zdepth;
MCNUM mccinter_analyzer_colimator_8_blade_4_xwidth2;
MCNUM mccinter_analyzer_colimator_8_blade_4_yheight2;
MCNUM mccinter_analyzer_colimator_8_blade_4_visualize;
int mccinter_analyzer_colimator_8_blade_4_target_index;
MCNUM mccinter_analyzer_colimator_8_blade_4_target_x;
MCNUM mccinter_analyzer_colimator_8_blade_4_target_y;
MCNUM mccinter_analyzer_colimator_8_blade_4_target_z;
MCNUM mccinter_analyzer_colimator_8_blade_4_focus_aw;
MCNUM mccinter_analyzer_colimator_8_blade_4_focus_ah;
MCNUM mccinter_analyzer_colimator_8_blade_4_focus_xw;
MCNUM mccinter_analyzer_colimator_8_blade_4_focus_xh;
MCNUM mccinter_analyzer_colimator_8_blade_4_focus_r;
MCNUM mccinter_analyzer_colimator_8_blade_4_p_interact;
char mccinter_analyzer_colimator_8_blade_4_mask_string[16384];
char mccinter_analyzer_colimator_8_blade_4_mask_setting[16384];
MCNUM mccinter_analyzer_colimator_8_blade_4_number_of_activations;

/* Setting parameters for component 'diffraction_detector_8_exit_volume' [464]. */
char mccdiffraction_detector_8_exit_volume_material_string[16384];
MCNUM mccdiffraction_detector_8_exit_volume_priority;
MCNUM mccdiffraction_detector_8_exit_volume_xwidth;
MCNUM mccdiffraction_detector_8_exit_volume_yheight;
MCNUM mccdiffraction_detector_8_exit_volume_zdepth;
MCNUM mccdiffraction_detector_8_exit_volume_xwidth2;
MCNUM mccdiffraction_detector_8_exit_volume_yheight2;
MCNUM mccdiffraction_detector_8_exit_volume_visualize;
int mccdiffraction_detector_8_exit_volume_target_index;
MCNUM mccdiffraction_detector_8_exit_volume_target_x;
MCNUM mccdiffraction_detector_8_exit_volume_target_y;
MCNUM mccdiffraction_detector_8_exit_volume_target_z;
MCNUM mccdiffraction_detector_8_exit_volume_focus_aw;
MCNUM mccdiffraction_detector_8_exit_volume_focus_ah;
MCNUM mccdiffraction_detector_8_exit_volume_focus_xw;
MCNUM mccdiffraction_detector_8_exit_volume_focus_xh;
MCNUM mccdiffraction_detector_8_exit_volume_focus_r;
MCNUM mccdiffraction_detector_8_exit_volume_p_interact;
char mccdiffraction_detector_8_exit_volume_mask_string[16384];
char mccdiffraction_detector_8_exit_volume_mask_setting[16384];
MCNUM mccdiffraction_detector_8_exit_volume_number_of_activations;

/* Setting parameters for component 'spec_detector_8_exit_volume' [465]. */
char mccspec_detector_8_exit_volume_material_string[16384];
MCNUM mccspec_detector_8_exit_volume_priority;
MCNUM mccspec_detector_8_exit_volume_xwidth;
MCNUM mccspec_detector_8_exit_volume_yheight;
MCNUM mccspec_detector_8_exit_volume_zdepth;
MCNUM mccspec_detector_8_exit_volume_xwidth2;
MCNUM mccspec_detector_8_exit_volume_yheight2;
MCNUM mccspec_detector_8_exit_volume_visualize;
int mccspec_detector_8_exit_volume_target_index;
MCNUM mccspec_detector_8_exit_volume_target_x;
MCNUM mccspec_detector_8_exit_volume_target_y;
MCNUM mccspec_detector_8_exit_volume_target_z;
MCNUM mccspec_detector_8_exit_volume_focus_aw;
MCNUM mccspec_detector_8_exit_volume_focus_ah;
MCNUM mccspec_detector_8_exit_volume_focus_xw;
MCNUM mccspec_detector_8_exit_volume_focus_xh;
MCNUM mccspec_detector_8_exit_volume_focus_r;
MCNUM mccspec_detector_8_exit_volume_p_interact;
char mccspec_detector_8_exit_volume_mask_string[16384];
char mccspec_detector_8_exit_volume_mask_setting[16384];
MCNUM mccspec_detector_8_exit_volume_number_of_activations;

/* Setting parameters for component 'channel_9_cave1_box1' [466]. */
char mccchannel_9_cave1_box1_material_string[16384];
MCNUM mccchannel_9_cave1_box1_priority;
MCNUM mccchannel_9_cave1_box1_xwidth;
MCNUM mccchannel_9_cave1_box1_yheight;
MCNUM mccchannel_9_cave1_box1_zdepth;
MCNUM mccchannel_9_cave1_box1_xwidth2;
MCNUM mccchannel_9_cave1_box1_yheight2;
MCNUM mccchannel_9_cave1_box1_visualize;
int mccchannel_9_cave1_box1_target_index;
MCNUM mccchannel_9_cave1_box1_target_x;
MCNUM mccchannel_9_cave1_box1_target_y;
MCNUM mccchannel_9_cave1_box1_target_z;
MCNUM mccchannel_9_cave1_box1_focus_aw;
MCNUM mccchannel_9_cave1_box1_focus_ah;
MCNUM mccchannel_9_cave1_box1_focus_xw;
MCNUM mccchannel_9_cave1_box1_focus_xh;
MCNUM mccchannel_9_cave1_box1_focus_r;
MCNUM mccchannel_9_cave1_box1_p_interact;
char mccchannel_9_cave1_box1_mask_string[16384];
char mccchannel_9_cave1_box1_mask_setting[16384];
MCNUM mccchannel_9_cave1_box1_number_of_activations;

/* Setting parameters for component 'channel_9_cave1_box2' [467]. */
char mccchannel_9_cave1_box2_material_string[16384];
MCNUM mccchannel_9_cave1_box2_priority;
MCNUM mccchannel_9_cave1_box2_xwidth;
MCNUM mccchannel_9_cave1_box2_yheight;
MCNUM mccchannel_9_cave1_box2_zdepth;
MCNUM mccchannel_9_cave1_box2_xwidth2;
MCNUM mccchannel_9_cave1_box2_yheight2;
MCNUM mccchannel_9_cave1_box2_visualize;
int mccchannel_9_cave1_box2_target_index;
MCNUM mccchannel_9_cave1_box2_target_x;
MCNUM mccchannel_9_cave1_box2_target_y;
MCNUM mccchannel_9_cave1_box2_target_z;
MCNUM mccchannel_9_cave1_box2_focus_aw;
MCNUM mccchannel_9_cave1_box2_focus_ah;
MCNUM mccchannel_9_cave1_box2_focus_xw;
MCNUM mccchannel_9_cave1_box2_focus_xh;
MCNUM mccchannel_9_cave1_box2_focus_r;
MCNUM mccchannel_9_cave1_box2_p_interact;
char mccchannel_9_cave1_box2_mask_string[16384];
char mccchannel_9_cave1_box2_mask_setting[16384];
MCNUM mccchannel_9_cave1_box2_number_of_activations;

/* Setting parameters for component 'channel_9_cave1_box3' [468]. */
char mccchannel_9_cave1_box3_material_string[16384];
MCNUM mccchannel_9_cave1_box3_priority;
MCNUM mccchannel_9_cave1_box3_xwidth;
MCNUM mccchannel_9_cave1_box3_yheight;
MCNUM mccchannel_9_cave1_box3_zdepth;
MCNUM mccchannel_9_cave1_box3_xwidth2;
MCNUM mccchannel_9_cave1_box3_yheight2;
MCNUM mccchannel_9_cave1_box3_visualize;
int mccchannel_9_cave1_box3_target_index;
MCNUM mccchannel_9_cave1_box3_target_x;
MCNUM mccchannel_9_cave1_box3_target_y;
MCNUM mccchannel_9_cave1_box3_target_z;
MCNUM mccchannel_9_cave1_box3_focus_aw;
MCNUM mccchannel_9_cave1_box3_focus_ah;
MCNUM mccchannel_9_cave1_box3_focus_xw;
MCNUM mccchannel_9_cave1_box3_focus_xh;
MCNUM mccchannel_9_cave1_box3_focus_r;
MCNUM mccchannel_9_cave1_box3_p_interact;
char mccchannel_9_cave1_box3_mask_string[16384];
char mccchannel_9_cave1_box3_mask_setting[16384];
MCNUM mccchannel_9_cave1_box3_number_of_activations;

/* Setting parameters for component 'channel_9_cave1_cyl1' [469]. */
char mccchannel_9_cave1_cyl1_material_string[16384];
MCNUM mccchannel_9_cave1_cyl1_priority;
MCNUM mccchannel_9_cave1_cyl1_radius;
MCNUM mccchannel_9_cave1_cyl1_yheight;
MCNUM mccchannel_9_cave1_cyl1_visualize;
int mccchannel_9_cave1_cyl1_target_index;
MCNUM mccchannel_9_cave1_cyl1_target_x;
MCNUM mccchannel_9_cave1_cyl1_target_y;
MCNUM mccchannel_9_cave1_cyl1_target_z;
MCNUM mccchannel_9_cave1_cyl1_focus_aw;
MCNUM mccchannel_9_cave1_cyl1_focus_ah;
MCNUM mccchannel_9_cave1_cyl1_focus_xw;
MCNUM mccchannel_9_cave1_cyl1_focus_xh;
MCNUM mccchannel_9_cave1_cyl1_focus_r;
MCNUM mccchannel_9_cave1_cyl1_p_interact;
char mccchannel_9_cave1_cyl1_mask_string[16384];
char mccchannel_9_cave1_cyl1_mask_setting[16384];
MCNUM mccchannel_9_cave1_cyl1_number_of_activations;

/* Setting parameters for component 'channel_9_analyzer_1_array_crystal_array_0' [472]. */
char mccchannel_9_analyzer_1_array_crystal_array_0_material_string[16384];
MCNUM mccchannel_9_analyzer_1_array_crystal_array_0_priority;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_0_xwidth;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_0_yheight;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_0_zdepth;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_0_xwidth2;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_0_yheight2;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_0_visualize;
int mccchannel_9_analyzer_1_array_crystal_array_0_target_index;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_0_target_x;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_0_target_y;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_0_target_z;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_0_focus_aw;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_0_focus_ah;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_0_focus_xw;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_0_focus_xh;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_0_focus_r;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_0_p_interact;
char mccchannel_9_analyzer_1_array_crystal_array_0_mask_string[16384];
char mccchannel_9_analyzer_1_array_crystal_array_0_mask_setting[16384];
MCNUM mccchannel_9_analyzer_1_array_crystal_array_0_number_of_activations;

/* Setting parameters for component 'channel_9_analyzer_1_array_crystal_array_1' [473]. */
char mccchannel_9_analyzer_1_array_crystal_array_1_material_string[16384];
MCNUM mccchannel_9_analyzer_1_array_crystal_array_1_priority;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_1_xwidth;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_1_yheight;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_1_zdepth;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_1_xwidth2;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_1_yheight2;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_1_visualize;
int mccchannel_9_analyzer_1_array_crystal_array_1_target_index;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_1_target_x;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_1_target_y;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_1_target_z;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_1_focus_aw;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_1_focus_ah;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_1_focus_xw;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_1_focus_xh;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_1_focus_r;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_1_p_interact;
char mccchannel_9_analyzer_1_array_crystal_array_1_mask_string[16384];
char mccchannel_9_analyzer_1_array_crystal_array_1_mask_setting[16384];
MCNUM mccchannel_9_analyzer_1_array_crystal_array_1_number_of_activations;

/* Setting parameters for component 'channel_9_analyzer_1_array_crystal_array_2' [474]. */
char mccchannel_9_analyzer_1_array_crystal_array_2_material_string[16384];
MCNUM mccchannel_9_analyzer_1_array_crystal_array_2_priority;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_2_xwidth;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_2_yheight;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_2_zdepth;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_2_xwidth2;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_2_yheight2;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_2_visualize;
int mccchannel_9_analyzer_1_array_crystal_array_2_target_index;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_2_target_x;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_2_target_y;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_2_target_z;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_2_focus_aw;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_2_focus_ah;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_2_focus_xw;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_2_focus_xh;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_2_focus_r;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_2_p_interact;
char mccchannel_9_analyzer_1_array_crystal_array_2_mask_string[16384];
char mccchannel_9_analyzer_1_array_crystal_array_2_mask_setting[16384];
MCNUM mccchannel_9_analyzer_1_array_crystal_array_2_number_of_activations;

/* Setting parameters for component 'channel_9_analyzer_1_array_crystal_array_3' [475]. */
char mccchannel_9_analyzer_1_array_crystal_array_3_material_string[16384];
MCNUM mccchannel_9_analyzer_1_array_crystal_array_3_priority;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_3_xwidth;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_3_yheight;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_3_zdepth;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_3_xwidth2;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_3_yheight2;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_3_visualize;
int mccchannel_9_analyzer_1_array_crystal_array_3_target_index;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_3_target_x;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_3_target_y;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_3_target_z;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_3_focus_aw;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_3_focus_ah;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_3_focus_xw;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_3_focus_xh;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_3_focus_r;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_3_p_interact;
char mccchannel_9_analyzer_1_array_crystal_array_3_mask_string[16384];
char mccchannel_9_analyzer_1_array_crystal_array_3_mask_setting[16384];
MCNUM mccchannel_9_analyzer_1_array_crystal_array_3_number_of_activations;

/* Setting parameters for component 'channel_9_analyzer_1_array_crystal_array_4' [476]. */
char mccchannel_9_analyzer_1_array_crystal_array_4_material_string[16384];
MCNUM mccchannel_9_analyzer_1_array_crystal_array_4_priority;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_4_xwidth;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_4_yheight;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_4_zdepth;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_4_xwidth2;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_4_yheight2;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_4_visualize;
int mccchannel_9_analyzer_1_array_crystal_array_4_target_index;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_4_target_x;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_4_target_y;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_4_target_z;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_4_focus_aw;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_4_focus_ah;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_4_focus_xw;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_4_focus_xh;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_4_focus_r;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_4_p_interact;
char mccchannel_9_analyzer_1_array_crystal_array_4_mask_string[16384];
char mccchannel_9_analyzer_1_array_crystal_array_4_mask_setting[16384];
MCNUM mccchannel_9_analyzer_1_array_crystal_array_4_number_of_activations;

/* Setting parameters for component 'channel_9_analyzer_1_array_crystal_array_5' [477]. */
char mccchannel_9_analyzer_1_array_crystal_array_5_material_string[16384];
MCNUM mccchannel_9_analyzer_1_array_crystal_array_5_priority;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_5_xwidth;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_5_yheight;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_5_zdepth;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_5_xwidth2;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_5_yheight2;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_5_visualize;
int mccchannel_9_analyzer_1_array_crystal_array_5_target_index;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_5_target_x;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_5_target_y;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_5_target_z;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_5_focus_aw;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_5_focus_ah;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_5_focus_xw;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_5_focus_xh;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_5_focus_r;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_5_p_interact;
char mccchannel_9_analyzer_1_array_crystal_array_5_mask_string[16384];
char mccchannel_9_analyzer_1_array_crystal_array_5_mask_setting[16384];
MCNUM mccchannel_9_analyzer_1_array_crystal_array_5_number_of_activations;

/* Setting parameters for component 'channel_9_analyzer_1_array_crystal_array_6' [478]. */
char mccchannel_9_analyzer_1_array_crystal_array_6_material_string[16384];
MCNUM mccchannel_9_analyzer_1_array_crystal_array_6_priority;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_6_xwidth;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_6_yheight;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_6_zdepth;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_6_xwidth2;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_6_yheight2;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_6_visualize;
int mccchannel_9_analyzer_1_array_crystal_array_6_target_index;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_6_target_x;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_6_target_y;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_6_target_z;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_6_focus_aw;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_6_focus_ah;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_6_focus_xw;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_6_focus_xh;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_6_focus_r;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_6_p_interact;
char mccchannel_9_analyzer_1_array_crystal_array_6_mask_string[16384];
char mccchannel_9_analyzer_1_array_crystal_array_6_mask_setting[16384];
MCNUM mccchannel_9_analyzer_1_array_crystal_array_6_number_of_activations;

/* Setting parameters for component 'channel_9_analyzer_1_array_crystal_array_7' [479]. */
char mccchannel_9_analyzer_1_array_crystal_array_7_material_string[16384];
MCNUM mccchannel_9_analyzer_1_array_crystal_array_7_priority;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_7_xwidth;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_7_yheight;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_7_zdepth;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_7_xwidth2;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_7_yheight2;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_7_visualize;
int mccchannel_9_analyzer_1_array_crystal_array_7_target_index;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_7_target_x;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_7_target_y;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_7_target_z;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_7_focus_aw;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_7_focus_ah;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_7_focus_xw;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_7_focus_xh;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_7_focus_r;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_7_p_interact;
char mccchannel_9_analyzer_1_array_crystal_array_7_mask_string[16384];
char mccchannel_9_analyzer_1_array_crystal_array_7_mask_setting[16384];
MCNUM mccchannel_9_analyzer_1_array_crystal_array_7_number_of_activations;

/* Setting parameters for component 'channel_9_analyzer_1_array_crystal_array_8' [480]. */
char mccchannel_9_analyzer_1_array_crystal_array_8_material_string[16384];
MCNUM mccchannel_9_analyzer_1_array_crystal_array_8_priority;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_8_xwidth;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_8_yheight;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_8_zdepth;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_8_xwidth2;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_8_yheight2;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_8_visualize;
int mccchannel_9_analyzer_1_array_crystal_array_8_target_index;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_8_target_x;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_8_target_y;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_8_target_z;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_8_focus_aw;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_8_focus_ah;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_8_focus_xw;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_8_focus_xh;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_8_focus_r;
MCNUM mccchannel_9_analyzer_1_array_crystal_array_8_p_interact;
char mccchannel_9_analyzer_1_array_crystal_array_8_mask_string[16384];
char mccchannel_9_analyzer_1_array_crystal_array_8_mask_setting[16384];
MCNUM mccchannel_9_analyzer_1_array_crystal_array_8_number_of_activations;

/* Setting parameters for component 'channel_9_analyzer_2_array_crystal_array_0' [483]. */
char mccchannel_9_analyzer_2_array_crystal_array_0_material_string[16384];
MCNUM mccchannel_9_analyzer_2_array_crystal_array_0_priority;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_0_xwidth;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_0_yheight;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_0_zdepth;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_0_xwidth2;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_0_yheight2;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_0_visualize;
int mccchannel_9_analyzer_2_array_crystal_array_0_target_index;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_0_target_x;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_0_target_y;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_0_target_z;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_0_focus_aw;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_0_focus_ah;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_0_focus_xw;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_0_focus_xh;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_0_focus_r;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_0_p_interact;
char mccchannel_9_analyzer_2_array_crystal_array_0_mask_string[16384];
char mccchannel_9_analyzer_2_array_crystal_array_0_mask_setting[16384];
MCNUM mccchannel_9_analyzer_2_array_crystal_array_0_number_of_activations;

/* Setting parameters for component 'channel_9_analyzer_2_array_crystal_array_1' [484]. */
char mccchannel_9_analyzer_2_array_crystal_array_1_material_string[16384];
MCNUM mccchannel_9_analyzer_2_array_crystal_array_1_priority;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_1_xwidth;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_1_yheight;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_1_zdepth;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_1_xwidth2;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_1_yheight2;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_1_visualize;
int mccchannel_9_analyzer_2_array_crystal_array_1_target_index;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_1_target_x;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_1_target_y;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_1_target_z;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_1_focus_aw;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_1_focus_ah;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_1_focus_xw;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_1_focus_xh;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_1_focus_r;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_1_p_interact;
char mccchannel_9_analyzer_2_array_crystal_array_1_mask_string[16384];
char mccchannel_9_analyzer_2_array_crystal_array_1_mask_setting[16384];
MCNUM mccchannel_9_analyzer_2_array_crystal_array_1_number_of_activations;

/* Setting parameters for component 'channel_9_analyzer_2_array_crystal_array_2' [485]. */
char mccchannel_9_analyzer_2_array_crystal_array_2_material_string[16384];
MCNUM mccchannel_9_analyzer_2_array_crystal_array_2_priority;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_2_xwidth;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_2_yheight;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_2_zdepth;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_2_xwidth2;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_2_yheight2;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_2_visualize;
int mccchannel_9_analyzer_2_array_crystal_array_2_target_index;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_2_target_x;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_2_target_y;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_2_target_z;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_2_focus_aw;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_2_focus_ah;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_2_focus_xw;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_2_focus_xh;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_2_focus_r;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_2_p_interact;
char mccchannel_9_analyzer_2_array_crystal_array_2_mask_string[16384];
char mccchannel_9_analyzer_2_array_crystal_array_2_mask_setting[16384];
MCNUM mccchannel_9_analyzer_2_array_crystal_array_2_number_of_activations;

/* Setting parameters for component 'channel_9_analyzer_2_array_crystal_array_3' [486]. */
char mccchannel_9_analyzer_2_array_crystal_array_3_material_string[16384];
MCNUM mccchannel_9_analyzer_2_array_crystal_array_3_priority;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_3_xwidth;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_3_yheight;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_3_zdepth;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_3_xwidth2;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_3_yheight2;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_3_visualize;
int mccchannel_9_analyzer_2_array_crystal_array_3_target_index;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_3_target_x;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_3_target_y;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_3_target_z;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_3_focus_aw;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_3_focus_ah;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_3_focus_xw;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_3_focus_xh;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_3_focus_r;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_3_p_interact;
char mccchannel_9_analyzer_2_array_crystal_array_3_mask_string[16384];
char mccchannel_9_analyzer_2_array_crystal_array_3_mask_setting[16384];
MCNUM mccchannel_9_analyzer_2_array_crystal_array_3_number_of_activations;

/* Setting parameters for component 'channel_9_analyzer_2_array_crystal_array_4' [487]. */
char mccchannel_9_analyzer_2_array_crystal_array_4_material_string[16384];
MCNUM mccchannel_9_analyzer_2_array_crystal_array_4_priority;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_4_xwidth;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_4_yheight;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_4_zdepth;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_4_xwidth2;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_4_yheight2;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_4_visualize;
int mccchannel_9_analyzer_2_array_crystal_array_4_target_index;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_4_target_x;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_4_target_y;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_4_target_z;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_4_focus_aw;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_4_focus_ah;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_4_focus_xw;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_4_focus_xh;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_4_focus_r;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_4_p_interact;
char mccchannel_9_analyzer_2_array_crystal_array_4_mask_string[16384];
char mccchannel_9_analyzer_2_array_crystal_array_4_mask_setting[16384];
MCNUM mccchannel_9_analyzer_2_array_crystal_array_4_number_of_activations;

/* Setting parameters for component 'channel_9_analyzer_2_array_crystal_array_5' [488]. */
char mccchannel_9_analyzer_2_array_crystal_array_5_material_string[16384];
MCNUM mccchannel_9_analyzer_2_array_crystal_array_5_priority;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_5_xwidth;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_5_yheight;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_5_zdepth;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_5_xwidth2;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_5_yheight2;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_5_visualize;
int mccchannel_9_analyzer_2_array_crystal_array_5_target_index;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_5_target_x;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_5_target_y;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_5_target_z;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_5_focus_aw;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_5_focus_ah;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_5_focus_xw;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_5_focus_xh;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_5_focus_r;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_5_p_interact;
char mccchannel_9_analyzer_2_array_crystal_array_5_mask_string[16384];
char mccchannel_9_analyzer_2_array_crystal_array_5_mask_setting[16384];
MCNUM mccchannel_9_analyzer_2_array_crystal_array_5_number_of_activations;

/* Setting parameters for component 'channel_9_analyzer_2_array_crystal_array_6' [489]. */
char mccchannel_9_analyzer_2_array_crystal_array_6_material_string[16384];
MCNUM mccchannel_9_analyzer_2_array_crystal_array_6_priority;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_6_xwidth;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_6_yheight;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_6_zdepth;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_6_xwidth2;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_6_yheight2;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_6_visualize;
int mccchannel_9_analyzer_2_array_crystal_array_6_target_index;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_6_target_x;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_6_target_y;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_6_target_z;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_6_focus_aw;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_6_focus_ah;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_6_focus_xw;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_6_focus_xh;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_6_focus_r;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_6_p_interact;
char mccchannel_9_analyzer_2_array_crystal_array_6_mask_string[16384];
char mccchannel_9_analyzer_2_array_crystal_array_6_mask_setting[16384];
MCNUM mccchannel_9_analyzer_2_array_crystal_array_6_number_of_activations;

/* Setting parameters for component 'channel_9_analyzer_2_array_crystal_array_7' [490]. */
char mccchannel_9_analyzer_2_array_crystal_array_7_material_string[16384];
MCNUM mccchannel_9_analyzer_2_array_crystal_array_7_priority;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_7_xwidth;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_7_yheight;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_7_zdepth;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_7_xwidth2;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_7_yheight2;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_7_visualize;
int mccchannel_9_analyzer_2_array_crystal_array_7_target_index;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_7_target_x;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_7_target_y;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_7_target_z;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_7_focus_aw;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_7_focus_ah;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_7_focus_xw;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_7_focus_xh;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_7_focus_r;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_7_p_interact;
char mccchannel_9_analyzer_2_array_crystal_array_7_mask_string[16384];
char mccchannel_9_analyzer_2_array_crystal_array_7_mask_setting[16384];
MCNUM mccchannel_9_analyzer_2_array_crystal_array_7_number_of_activations;

/* Setting parameters for component 'channel_9_analyzer_2_array_crystal_array_8' [491]. */
char mccchannel_9_analyzer_2_array_crystal_array_8_material_string[16384];
MCNUM mccchannel_9_analyzer_2_array_crystal_array_8_priority;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_8_xwidth;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_8_yheight;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_8_zdepth;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_8_xwidth2;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_8_yheight2;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_8_visualize;
int mccchannel_9_analyzer_2_array_crystal_array_8_target_index;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_8_target_x;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_8_target_y;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_8_target_z;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_8_focus_aw;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_8_focus_ah;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_8_focus_xw;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_8_focus_xh;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_8_focus_r;
MCNUM mccchannel_9_analyzer_2_array_crystal_array_8_p_interact;
char mccchannel_9_analyzer_2_array_crystal_array_8_mask_string[16384];
char mccchannel_9_analyzer_2_array_crystal_array_8_mask_setting[16384];
MCNUM mccchannel_9_analyzer_2_array_crystal_array_8_number_of_activations;

/* Setting parameters for component 'channel_9_cave2_cyl1' [492]. */
char mccchannel_9_cave2_cyl1_material_string[16384];
MCNUM mccchannel_9_cave2_cyl1_priority;
MCNUM mccchannel_9_cave2_cyl1_radius;
MCNUM mccchannel_9_cave2_cyl1_yheight;
MCNUM mccchannel_9_cave2_cyl1_visualize;
int mccchannel_9_cave2_cyl1_target_index;
MCNUM mccchannel_9_cave2_cyl1_target_x;
MCNUM mccchannel_9_cave2_cyl1_target_y;
MCNUM mccchannel_9_cave2_cyl1_target_z;
MCNUM mccchannel_9_cave2_cyl1_focus_aw;
MCNUM mccchannel_9_cave2_cyl1_focus_ah;
MCNUM mccchannel_9_cave2_cyl1_focus_xw;
MCNUM mccchannel_9_cave2_cyl1_focus_xh;
MCNUM mccchannel_9_cave2_cyl1_focus_r;
MCNUM mccchannel_9_cave2_cyl1_p_interact;
char mccchannel_9_cave2_cyl1_mask_string[16384];
char mccchannel_9_cave2_cyl1_mask_setting[16384];
MCNUM mccchannel_9_cave2_cyl1_number_of_activations;

/* Setting parameters for component 'channel_9_cave2_box1' [493]. */
char mccchannel_9_cave2_box1_material_string[16384];
MCNUM mccchannel_9_cave2_box1_priority;
MCNUM mccchannel_9_cave2_box1_xwidth;
MCNUM mccchannel_9_cave2_box1_yheight;
MCNUM mccchannel_9_cave2_box1_zdepth;
MCNUM mccchannel_9_cave2_box1_xwidth2;
MCNUM mccchannel_9_cave2_box1_yheight2;
MCNUM mccchannel_9_cave2_box1_visualize;
int mccchannel_9_cave2_box1_target_index;
MCNUM mccchannel_9_cave2_box1_target_x;
MCNUM mccchannel_9_cave2_box1_target_y;
MCNUM mccchannel_9_cave2_box1_target_z;
MCNUM mccchannel_9_cave2_box1_focus_aw;
MCNUM mccchannel_9_cave2_box1_focus_ah;
MCNUM mccchannel_9_cave2_box1_focus_xw;
MCNUM mccchannel_9_cave2_box1_focus_xh;
MCNUM mccchannel_9_cave2_box1_focus_r;
MCNUM mccchannel_9_cave2_box1_p_interact;
char mccchannel_9_cave2_box1_mask_string[16384];
char mccchannel_9_cave2_box1_mask_setting[16384];
MCNUM mccchannel_9_cave2_box1_number_of_activations;

/* Setting parameters for component 'channel_9_cave2_box2' [494]. */
char mccchannel_9_cave2_box2_material_string[16384];
MCNUM mccchannel_9_cave2_box2_priority;
MCNUM mccchannel_9_cave2_box2_xwidth;
MCNUM mccchannel_9_cave2_box2_yheight;
MCNUM mccchannel_9_cave2_box2_zdepth;
MCNUM mccchannel_9_cave2_box2_xwidth2;
MCNUM mccchannel_9_cave2_box2_yheight2;
MCNUM mccchannel_9_cave2_box2_visualize;
int mccchannel_9_cave2_box2_target_index;
MCNUM mccchannel_9_cave2_box2_target_x;
MCNUM mccchannel_9_cave2_box2_target_y;
MCNUM mccchannel_9_cave2_box2_target_z;
MCNUM mccchannel_9_cave2_box2_focus_aw;
MCNUM mccchannel_9_cave2_box2_focus_ah;
MCNUM mccchannel_9_cave2_box2_focus_xw;
MCNUM mccchannel_9_cave2_box2_focus_xh;
MCNUM mccchannel_9_cave2_box2_focus_r;
MCNUM mccchannel_9_cave2_box2_p_interact;
char mccchannel_9_cave2_box2_mask_string[16384];
char mccchannel_9_cave2_box2_mask_setting[16384];
MCNUM mccchannel_9_cave2_box2_number_of_activations;

/* Setting parameters for component 'channel_9_cave2_box3' [495]. */
char mccchannel_9_cave2_box3_material_string[16384];
MCNUM mccchannel_9_cave2_box3_priority;
MCNUM mccchannel_9_cave2_box3_xwidth;
MCNUM mccchannel_9_cave2_box3_yheight;
MCNUM mccchannel_9_cave2_box3_zdepth;
MCNUM mccchannel_9_cave2_box3_xwidth2;
MCNUM mccchannel_9_cave2_box3_yheight2;
MCNUM mccchannel_9_cave2_box3_visualize;
int mccchannel_9_cave2_box3_target_index;
MCNUM mccchannel_9_cave2_box3_target_x;
MCNUM mccchannel_9_cave2_box3_target_y;
MCNUM mccchannel_9_cave2_box3_target_z;
MCNUM mccchannel_9_cave2_box3_focus_aw;
MCNUM mccchannel_9_cave2_box3_focus_ah;
MCNUM mccchannel_9_cave2_box3_focus_xw;
MCNUM mccchannel_9_cave2_box3_focus_xh;
MCNUM mccchannel_9_cave2_box3_focus_r;
MCNUM mccchannel_9_cave2_box3_p_interact;
char mccchannel_9_cave2_box3_mask_string[16384];
char mccchannel_9_cave2_box3_mask_setting[16384];
MCNUM mccchannel_9_cave2_box3_number_of_activations;

/* Setting parameters for component 'inter_analyzer_colimator_9_blade_0' [497]. */
char mccinter_analyzer_colimator_9_blade_0_material_string[16384];
MCNUM mccinter_analyzer_colimator_9_blade_0_priority;
MCNUM mccinter_analyzer_colimator_9_blade_0_xwidth;
MCNUM mccinter_analyzer_colimator_9_blade_0_yheight;
MCNUM mccinter_analyzer_colimator_9_blade_0_zdepth;
MCNUM mccinter_analyzer_colimator_9_blade_0_xwidth2;
MCNUM mccinter_analyzer_colimator_9_blade_0_yheight2;
MCNUM mccinter_analyzer_colimator_9_blade_0_visualize;
int mccinter_analyzer_colimator_9_blade_0_target_index;
MCNUM mccinter_analyzer_colimator_9_blade_0_target_x;
MCNUM mccinter_analyzer_colimator_9_blade_0_target_y;
MCNUM mccinter_analyzer_colimator_9_blade_0_target_z;
MCNUM mccinter_analyzer_colimator_9_blade_0_focus_aw;
MCNUM mccinter_analyzer_colimator_9_blade_0_focus_ah;
MCNUM mccinter_analyzer_colimator_9_blade_0_focus_xw;
MCNUM mccinter_analyzer_colimator_9_blade_0_focus_xh;
MCNUM mccinter_analyzer_colimator_9_blade_0_focus_r;
MCNUM mccinter_analyzer_colimator_9_blade_0_p_interact;
char mccinter_analyzer_colimator_9_blade_0_mask_string[16384];
char mccinter_analyzer_colimator_9_blade_0_mask_setting[16384];
MCNUM mccinter_analyzer_colimator_9_blade_0_number_of_activations;

/* Setting parameters for component 'inter_analyzer_colimator_9_blade_1' [498]. */
char mccinter_analyzer_colimator_9_blade_1_material_string[16384];
MCNUM mccinter_analyzer_colimator_9_blade_1_priority;
MCNUM mccinter_analyzer_colimator_9_blade_1_xwidth;
MCNUM mccinter_analyzer_colimator_9_blade_1_yheight;
MCNUM mccinter_analyzer_colimator_9_blade_1_zdepth;
MCNUM mccinter_analyzer_colimator_9_blade_1_xwidth2;
MCNUM mccinter_analyzer_colimator_9_blade_1_yheight2;
MCNUM mccinter_analyzer_colimator_9_blade_1_visualize;
int mccinter_analyzer_colimator_9_blade_1_target_index;
MCNUM mccinter_analyzer_colimator_9_blade_1_target_x;
MCNUM mccinter_analyzer_colimator_9_blade_1_target_y;
MCNUM mccinter_analyzer_colimator_9_blade_1_target_z;
MCNUM mccinter_analyzer_colimator_9_blade_1_focus_aw;
MCNUM mccinter_analyzer_colimator_9_blade_1_focus_ah;
MCNUM mccinter_analyzer_colimator_9_blade_1_focus_xw;
MCNUM mccinter_analyzer_colimator_9_blade_1_focus_xh;
MCNUM mccinter_analyzer_colimator_9_blade_1_focus_r;
MCNUM mccinter_analyzer_colimator_9_blade_1_p_interact;
char mccinter_analyzer_colimator_9_blade_1_mask_string[16384];
char mccinter_analyzer_colimator_9_blade_1_mask_setting[16384];
MCNUM mccinter_analyzer_colimator_9_blade_1_number_of_activations;

/* Setting parameters for component 'inter_analyzer_colimator_9_blade_2' [499]. */
char mccinter_analyzer_colimator_9_blade_2_material_string[16384];
MCNUM mccinter_analyzer_colimator_9_blade_2_priority;
MCNUM mccinter_analyzer_colimator_9_blade_2_xwidth;
MCNUM mccinter_analyzer_colimator_9_blade_2_yheight;
MCNUM mccinter_analyzer_colimator_9_blade_2_zdepth;
MCNUM mccinter_analyzer_colimator_9_blade_2_xwidth2;
MCNUM mccinter_analyzer_colimator_9_blade_2_yheight2;
MCNUM mccinter_analyzer_colimator_9_blade_2_visualize;
int mccinter_analyzer_colimator_9_blade_2_target_index;
MCNUM mccinter_analyzer_colimator_9_blade_2_target_x;
MCNUM mccinter_analyzer_colimator_9_blade_2_target_y;
MCNUM mccinter_analyzer_colimator_9_blade_2_target_z;
MCNUM mccinter_analyzer_colimator_9_blade_2_focus_aw;
MCNUM mccinter_analyzer_colimator_9_blade_2_focus_ah;
MCNUM mccinter_analyzer_colimator_9_blade_2_focus_xw;
MCNUM mccinter_analyzer_colimator_9_blade_2_focus_xh;
MCNUM mccinter_analyzer_colimator_9_blade_2_focus_r;
MCNUM mccinter_analyzer_colimator_9_blade_2_p_interact;
char mccinter_analyzer_colimator_9_blade_2_mask_string[16384];
char mccinter_analyzer_colimator_9_blade_2_mask_setting[16384];
MCNUM mccinter_analyzer_colimator_9_blade_2_number_of_activations;

/* Setting parameters for component 'inter_analyzer_colimator_9_blade_3' [500]. */
char mccinter_analyzer_colimator_9_blade_3_material_string[16384];
MCNUM mccinter_analyzer_colimator_9_blade_3_priority;
MCNUM mccinter_analyzer_colimator_9_blade_3_xwidth;
MCNUM mccinter_analyzer_colimator_9_blade_3_yheight;
MCNUM mccinter_analyzer_colimator_9_blade_3_zdepth;
MCNUM mccinter_analyzer_colimator_9_blade_3_xwidth2;
MCNUM mccinter_analyzer_colimator_9_blade_3_yheight2;
MCNUM mccinter_analyzer_colimator_9_blade_3_visualize;
int mccinter_analyzer_colimator_9_blade_3_target_index;
MCNUM mccinter_analyzer_colimator_9_blade_3_target_x;
MCNUM mccinter_analyzer_colimator_9_blade_3_target_y;
MCNUM mccinter_analyzer_colimator_9_blade_3_target_z;
MCNUM mccinter_analyzer_colimator_9_blade_3_focus_aw;
MCNUM mccinter_analyzer_colimator_9_blade_3_focus_ah;
MCNUM mccinter_analyzer_colimator_9_blade_3_focus_xw;
MCNUM mccinter_analyzer_colimator_9_blade_3_focus_xh;
MCNUM mccinter_analyzer_colimator_9_blade_3_focus_r;
MCNUM mccinter_analyzer_colimator_9_blade_3_p_interact;
char mccinter_analyzer_colimator_9_blade_3_mask_string[16384];
char mccinter_analyzer_colimator_9_blade_3_mask_setting[16384];
MCNUM mccinter_analyzer_colimator_9_blade_3_number_of_activations;

/* Setting parameters for component 'inter_analyzer_colimator_9_blade_4' [501]. */
char mccinter_analyzer_colimator_9_blade_4_material_string[16384];
MCNUM mccinter_analyzer_colimator_9_blade_4_priority;
MCNUM mccinter_analyzer_colimator_9_blade_4_xwidth;
MCNUM mccinter_analyzer_colimator_9_blade_4_yheight;
MCNUM mccinter_analyzer_colimator_9_blade_4_zdepth;
MCNUM mccinter_analyzer_colimator_9_blade_4_xwidth2;
MCNUM mccinter_analyzer_colimator_9_blade_4_yheight2;
MCNUM mccinter_analyzer_colimator_9_blade_4_visualize;
int mccinter_analyzer_colimator_9_blade_4_target_index;
MCNUM mccinter_analyzer_colimator_9_blade_4_target_x;
MCNUM mccinter_analyzer_colimator_9_blade_4_target_y;
MCNUM mccinter_analyzer_colimator_9_blade_4_target_z;
MCNUM mccinter_analyzer_colimator_9_blade_4_focus_aw;
MCNUM mccinter_analyzer_colimator_9_blade_4_focus_ah;
MCNUM mccinter_analyzer_colimator_9_blade_4_focus_xw;
MCNUM mccinter_analyzer_colimator_9_blade_4_focus_xh;
MCNUM mccinter_analyzer_colimator_9_blade_4_focus_r;
MCNUM mccinter_analyzer_colimator_9_blade_4_p_interact;
char mccinter_analyzer_colimator_9_blade_4_mask_string[16384];
char mccinter_analyzer_colimator_9_blade_4_mask_setting[16384];
MCNUM mccinter_analyzer_colimator_9_blade_4_number_of_activations;

/* Setting parameters for component 'diffraction_detector_9_exit_volume' [502]. */
char mccdiffraction_detector_9_exit_volume_material_string[16384];
MCNUM mccdiffraction_detector_9_exit_volume_priority;
MCNUM mccdiffraction_detector_9_exit_volume_xwidth;
MCNUM mccdiffraction_detector_9_exit_volume_yheight;
MCNUM mccdiffraction_detector_9_exit_volume_zdepth;
MCNUM mccdiffraction_detector_9_exit_volume_xwidth2;
MCNUM mccdiffraction_detector_9_exit_volume_yheight2;
MCNUM mccdiffraction_detector_9_exit_volume_visualize;
int mccdiffraction_detector_9_exit_volume_target_index;
MCNUM mccdiffraction_detector_9_exit_volume_target_x;
MCNUM mccdiffraction_detector_9_exit_volume_target_y;
MCNUM mccdiffraction_detector_9_exit_volume_target_z;
MCNUM mccdiffraction_detector_9_exit_volume_focus_aw;
MCNUM mccdiffraction_detector_9_exit_volume_focus_ah;
MCNUM mccdiffraction_detector_9_exit_volume_focus_xw;
MCNUM mccdiffraction_detector_9_exit_volume_focus_xh;
MCNUM mccdiffraction_detector_9_exit_volume_focus_r;
MCNUM mccdiffraction_detector_9_exit_volume_p_interact;
char mccdiffraction_detector_9_exit_volume_mask_string[16384];
char mccdiffraction_detector_9_exit_volume_mask_setting[16384];
MCNUM mccdiffraction_detector_9_exit_volume_number_of_activations;

/* Setting parameters for component 'spec_detector_9_exit_volume' [503]. */
char mccspec_detector_9_exit_volume_material_string[16384];
MCNUM mccspec_detector_9_exit_volume_priority;
MCNUM mccspec_detector_9_exit_volume_xwidth;
MCNUM mccspec_detector_9_exit_volume_yheight;
MCNUM mccspec_detector_9_exit_volume_zdepth;
MCNUM mccspec_detector_9_exit_volume_xwidth2;
MCNUM mccspec_detector_9_exit_volume_yheight2;
MCNUM mccspec_detector_9_exit_volume_visualize;
int mccspec_detector_9_exit_volume_target_index;
MCNUM mccspec_detector_9_exit_volume_target_x;
MCNUM mccspec_detector_9_exit_volume_target_y;
MCNUM mccspec_detector_9_exit_volume_target_z;
MCNUM mccspec_detector_9_exit_volume_focus_aw;
MCNUM mccspec_detector_9_exit_volume_focus_ah;
MCNUM mccspec_detector_9_exit_volume_focus_xw;
MCNUM mccspec_detector_9_exit_volume_focus_xh;
MCNUM mccspec_detector_9_exit_volume_focus_r;
MCNUM mccspec_detector_9_exit_volume_p_interact;
char mccspec_detector_9_exit_volume_mask_string[16384];
char mccspec_detector_9_exit_volume_mask_setting[16384];
MCNUM mccspec_detector_9_exit_volume_number_of_activations;

/* Setting parameters for component 'channel_10_cave1_box1' [504]. */
char mccchannel_10_cave1_box1_material_string[16384];
MCNUM mccchannel_10_cave1_box1_priority;
MCNUM mccchannel_10_cave1_box1_xwidth;
MCNUM mccchannel_10_cave1_box1_yheight;
MCNUM mccchannel_10_cave1_box1_zdepth;
MCNUM mccchannel_10_cave1_box1_xwidth2;
MCNUM mccchannel_10_cave1_box1_yheight2;
MCNUM mccchannel_10_cave1_box1_visualize;
int mccchannel_10_cave1_box1_target_index;
MCNUM mccchannel_10_cave1_box1_target_x;
MCNUM mccchannel_10_cave1_box1_target_y;
MCNUM mccchannel_10_cave1_box1_target_z;
MCNUM mccchannel_10_cave1_box1_focus_aw;
MCNUM mccchannel_10_cave1_box1_focus_ah;
MCNUM mccchannel_10_cave1_box1_focus_xw;
MCNUM mccchannel_10_cave1_box1_focus_xh;
MCNUM mccchannel_10_cave1_box1_focus_r;
MCNUM mccchannel_10_cave1_box1_p_interact;
char mccchannel_10_cave1_box1_mask_string[16384];
char mccchannel_10_cave1_box1_mask_setting[16384];
MCNUM mccchannel_10_cave1_box1_number_of_activations;

/* Setting parameters for component 'channel_10_cave1_box2' [505]. */
char mccchannel_10_cave1_box2_material_string[16384];
MCNUM mccchannel_10_cave1_box2_priority;
MCNUM mccchannel_10_cave1_box2_xwidth;
MCNUM mccchannel_10_cave1_box2_yheight;
MCNUM mccchannel_10_cave1_box2_zdepth;
MCNUM mccchannel_10_cave1_box2_xwidth2;
MCNUM mccchannel_10_cave1_box2_yheight2;
MCNUM mccchannel_10_cave1_box2_visualize;
int mccchannel_10_cave1_box2_target_index;
MCNUM mccchannel_10_cave1_box2_target_x;
MCNUM mccchannel_10_cave1_box2_target_y;
MCNUM mccchannel_10_cave1_box2_target_z;
MCNUM mccchannel_10_cave1_box2_focus_aw;
MCNUM mccchannel_10_cave1_box2_focus_ah;
MCNUM mccchannel_10_cave1_box2_focus_xw;
MCNUM mccchannel_10_cave1_box2_focus_xh;
MCNUM mccchannel_10_cave1_box2_focus_r;
MCNUM mccchannel_10_cave1_box2_p_interact;
char mccchannel_10_cave1_box2_mask_string[16384];
char mccchannel_10_cave1_box2_mask_setting[16384];
MCNUM mccchannel_10_cave1_box2_number_of_activations;

/* Setting parameters for component 'channel_10_cave1_box3' [506]. */
char mccchannel_10_cave1_box3_material_string[16384];
MCNUM mccchannel_10_cave1_box3_priority;
MCNUM mccchannel_10_cave1_box3_xwidth;
MCNUM mccchannel_10_cave1_box3_yheight;
MCNUM mccchannel_10_cave1_box3_zdepth;
MCNUM mccchannel_10_cave1_box3_xwidth2;
MCNUM mccchannel_10_cave1_box3_yheight2;
MCNUM mccchannel_10_cave1_box3_visualize;
int mccchannel_10_cave1_box3_target_index;
MCNUM mccchannel_10_cave1_box3_target_x;
MCNUM mccchannel_10_cave1_box3_target_y;
MCNUM mccchannel_10_cave1_box3_target_z;
MCNUM mccchannel_10_cave1_box3_focus_aw;
MCNUM mccchannel_10_cave1_box3_focus_ah;
MCNUM mccchannel_10_cave1_box3_focus_xw;
MCNUM mccchannel_10_cave1_box3_focus_xh;
MCNUM mccchannel_10_cave1_box3_focus_r;
MCNUM mccchannel_10_cave1_box3_p_interact;
char mccchannel_10_cave1_box3_mask_string[16384];
char mccchannel_10_cave1_box3_mask_setting[16384];
MCNUM mccchannel_10_cave1_box3_number_of_activations;

/* Setting parameters for component 'channel_10_cave1_cyl1' [507]. */
char mccchannel_10_cave1_cyl1_material_string[16384];
MCNUM mccchannel_10_cave1_cyl1_priority;
MCNUM mccchannel_10_cave1_cyl1_radius;
MCNUM mccchannel_10_cave1_cyl1_yheight;
MCNUM mccchannel_10_cave1_cyl1_visualize;
int mccchannel_10_cave1_cyl1_target_index;
MCNUM mccchannel_10_cave1_cyl1_target_x;
MCNUM mccchannel_10_cave1_cyl1_target_y;
MCNUM mccchannel_10_cave1_cyl1_target_z;
MCNUM mccchannel_10_cave1_cyl1_focus_aw;
MCNUM mccchannel_10_cave1_cyl1_focus_ah;
MCNUM mccchannel_10_cave1_cyl1_focus_xw;
MCNUM mccchannel_10_cave1_cyl1_focus_xh;
MCNUM mccchannel_10_cave1_cyl1_focus_r;
MCNUM mccchannel_10_cave1_cyl1_p_interact;
char mccchannel_10_cave1_cyl1_mask_string[16384];
char mccchannel_10_cave1_cyl1_mask_setting[16384];
MCNUM mccchannel_10_cave1_cyl1_number_of_activations;

/* Setting parameters for component 'channel_10_analyzer_1_array_crystal_array_0' [510]. */
char mccchannel_10_analyzer_1_array_crystal_array_0_material_string[16384];
MCNUM mccchannel_10_analyzer_1_array_crystal_array_0_priority;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_0_xwidth;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_0_yheight;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_0_zdepth;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_0_xwidth2;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_0_yheight2;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_0_visualize;
int mccchannel_10_analyzer_1_array_crystal_array_0_target_index;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_0_target_x;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_0_target_y;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_0_target_z;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_0_focus_aw;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_0_focus_ah;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_0_focus_xw;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_0_focus_xh;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_0_focus_r;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_0_p_interact;
char mccchannel_10_analyzer_1_array_crystal_array_0_mask_string[16384];
char mccchannel_10_analyzer_1_array_crystal_array_0_mask_setting[16384];
MCNUM mccchannel_10_analyzer_1_array_crystal_array_0_number_of_activations;

/* Setting parameters for component 'channel_10_analyzer_1_array_crystal_array_1' [511]. */
char mccchannel_10_analyzer_1_array_crystal_array_1_material_string[16384];
MCNUM mccchannel_10_analyzer_1_array_crystal_array_1_priority;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_1_xwidth;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_1_yheight;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_1_zdepth;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_1_xwidth2;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_1_yheight2;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_1_visualize;
int mccchannel_10_analyzer_1_array_crystal_array_1_target_index;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_1_target_x;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_1_target_y;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_1_target_z;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_1_focus_aw;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_1_focus_ah;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_1_focus_xw;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_1_focus_xh;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_1_focus_r;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_1_p_interact;
char mccchannel_10_analyzer_1_array_crystal_array_1_mask_string[16384];
char mccchannel_10_analyzer_1_array_crystal_array_1_mask_setting[16384];
MCNUM mccchannel_10_analyzer_1_array_crystal_array_1_number_of_activations;

/* Setting parameters for component 'channel_10_analyzer_1_array_crystal_array_2' [512]. */
char mccchannel_10_analyzer_1_array_crystal_array_2_material_string[16384];
MCNUM mccchannel_10_analyzer_1_array_crystal_array_2_priority;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_2_xwidth;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_2_yheight;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_2_zdepth;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_2_xwidth2;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_2_yheight2;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_2_visualize;
int mccchannel_10_analyzer_1_array_crystal_array_2_target_index;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_2_target_x;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_2_target_y;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_2_target_z;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_2_focus_aw;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_2_focus_ah;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_2_focus_xw;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_2_focus_xh;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_2_focus_r;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_2_p_interact;
char mccchannel_10_analyzer_1_array_crystal_array_2_mask_string[16384];
char mccchannel_10_analyzer_1_array_crystal_array_2_mask_setting[16384];
MCNUM mccchannel_10_analyzer_1_array_crystal_array_2_number_of_activations;

/* Setting parameters for component 'channel_10_analyzer_1_array_crystal_array_3' [513]. */
char mccchannel_10_analyzer_1_array_crystal_array_3_material_string[16384];
MCNUM mccchannel_10_analyzer_1_array_crystal_array_3_priority;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_3_xwidth;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_3_yheight;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_3_zdepth;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_3_xwidth2;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_3_yheight2;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_3_visualize;
int mccchannel_10_analyzer_1_array_crystal_array_3_target_index;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_3_target_x;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_3_target_y;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_3_target_z;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_3_focus_aw;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_3_focus_ah;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_3_focus_xw;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_3_focus_xh;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_3_focus_r;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_3_p_interact;
char mccchannel_10_analyzer_1_array_crystal_array_3_mask_string[16384];
char mccchannel_10_analyzer_1_array_crystal_array_3_mask_setting[16384];
MCNUM mccchannel_10_analyzer_1_array_crystal_array_3_number_of_activations;

/* Setting parameters for component 'channel_10_analyzer_1_array_crystal_array_4' [514]. */
char mccchannel_10_analyzer_1_array_crystal_array_4_material_string[16384];
MCNUM mccchannel_10_analyzer_1_array_crystal_array_4_priority;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_4_xwidth;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_4_yheight;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_4_zdepth;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_4_xwidth2;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_4_yheight2;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_4_visualize;
int mccchannel_10_analyzer_1_array_crystal_array_4_target_index;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_4_target_x;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_4_target_y;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_4_target_z;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_4_focus_aw;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_4_focus_ah;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_4_focus_xw;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_4_focus_xh;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_4_focus_r;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_4_p_interact;
char mccchannel_10_analyzer_1_array_crystal_array_4_mask_string[16384];
char mccchannel_10_analyzer_1_array_crystal_array_4_mask_setting[16384];
MCNUM mccchannel_10_analyzer_1_array_crystal_array_4_number_of_activations;

/* Setting parameters for component 'channel_10_analyzer_1_array_crystal_array_5' [515]. */
char mccchannel_10_analyzer_1_array_crystal_array_5_material_string[16384];
MCNUM mccchannel_10_analyzer_1_array_crystal_array_5_priority;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_5_xwidth;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_5_yheight;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_5_zdepth;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_5_xwidth2;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_5_yheight2;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_5_visualize;
int mccchannel_10_analyzer_1_array_crystal_array_5_target_index;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_5_target_x;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_5_target_y;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_5_target_z;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_5_focus_aw;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_5_focus_ah;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_5_focus_xw;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_5_focus_xh;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_5_focus_r;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_5_p_interact;
char mccchannel_10_analyzer_1_array_crystal_array_5_mask_string[16384];
char mccchannel_10_analyzer_1_array_crystal_array_5_mask_setting[16384];
MCNUM mccchannel_10_analyzer_1_array_crystal_array_5_number_of_activations;

/* Setting parameters for component 'channel_10_analyzer_1_array_crystal_array_6' [516]. */
char mccchannel_10_analyzer_1_array_crystal_array_6_material_string[16384];
MCNUM mccchannel_10_analyzer_1_array_crystal_array_6_priority;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_6_xwidth;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_6_yheight;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_6_zdepth;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_6_xwidth2;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_6_yheight2;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_6_visualize;
int mccchannel_10_analyzer_1_array_crystal_array_6_target_index;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_6_target_x;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_6_target_y;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_6_target_z;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_6_focus_aw;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_6_focus_ah;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_6_focus_xw;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_6_focus_xh;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_6_focus_r;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_6_p_interact;
char mccchannel_10_analyzer_1_array_crystal_array_6_mask_string[16384];
char mccchannel_10_analyzer_1_array_crystal_array_6_mask_setting[16384];
MCNUM mccchannel_10_analyzer_1_array_crystal_array_6_number_of_activations;

/* Setting parameters for component 'channel_10_analyzer_1_array_crystal_array_7' [517]. */
char mccchannel_10_analyzer_1_array_crystal_array_7_material_string[16384];
MCNUM mccchannel_10_analyzer_1_array_crystal_array_7_priority;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_7_xwidth;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_7_yheight;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_7_zdepth;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_7_xwidth2;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_7_yheight2;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_7_visualize;
int mccchannel_10_analyzer_1_array_crystal_array_7_target_index;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_7_target_x;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_7_target_y;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_7_target_z;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_7_focus_aw;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_7_focus_ah;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_7_focus_xw;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_7_focus_xh;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_7_focus_r;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_7_p_interact;
char mccchannel_10_analyzer_1_array_crystal_array_7_mask_string[16384];
char mccchannel_10_analyzer_1_array_crystal_array_7_mask_setting[16384];
MCNUM mccchannel_10_analyzer_1_array_crystal_array_7_number_of_activations;

/* Setting parameters for component 'channel_10_analyzer_1_array_crystal_array_8' [518]. */
char mccchannel_10_analyzer_1_array_crystal_array_8_material_string[16384];
MCNUM mccchannel_10_analyzer_1_array_crystal_array_8_priority;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_8_xwidth;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_8_yheight;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_8_zdepth;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_8_xwidth2;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_8_yheight2;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_8_visualize;
int mccchannel_10_analyzer_1_array_crystal_array_8_target_index;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_8_target_x;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_8_target_y;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_8_target_z;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_8_focus_aw;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_8_focus_ah;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_8_focus_xw;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_8_focus_xh;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_8_focus_r;
MCNUM mccchannel_10_analyzer_1_array_crystal_array_8_p_interact;
char mccchannel_10_analyzer_1_array_crystal_array_8_mask_string[16384];
char mccchannel_10_analyzer_1_array_crystal_array_8_mask_setting[16384];
MCNUM mccchannel_10_analyzer_1_array_crystal_array_8_number_of_activations;

/* Setting parameters for component 'channel_10_analyzer_2_array_crystal_array_0' [521]. */
char mccchannel_10_analyzer_2_array_crystal_array_0_material_string[16384];
MCNUM mccchannel_10_analyzer_2_array_crystal_array_0_priority;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_0_xwidth;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_0_yheight;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_0_zdepth;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_0_xwidth2;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_0_yheight2;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_0_visualize;
int mccchannel_10_analyzer_2_array_crystal_array_0_target_index;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_0_target_x;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_0_target_y;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_0_target_z;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_0_focus_aw;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_0_focus_ah;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_0_focus_xw;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_0_focus_xh;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_0_focus_r;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_0_p_interact;
char mccchannel_10_analyzer_2_array_crystal_array_0_mask_string[16384];
char mccchannel_10_analyzer_2_array_crystal_array_0_mask_setting[16384];
MCNUM mccchannel_10_analyzer_2_array_crystal_array_0_number_of_activations;

/* Setting parameters for component 'channel_10_analyzer_2_array_crystal_array_1' [522]. */
char mccchannel_10_analyzer_2_array_crystal_array_1_material_string[16384];
MCNUM mccchannel_10_analyzer_2_array_crystal_array_1_priority;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_1_xwidth;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_1_yheight;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_1_zdepth;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_1_xwidth2;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_1_yheight2;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_1_visualize;
int mccchannel_10_analyzer_2_array_crystal_array_1_target_index;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_1_target_x;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_1_target_y;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_1_target_z;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_1_focus_aw;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_1_focus_ah;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_1_focus_xw;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_1_focus_xh;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_1_focus_r;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_1_p_interact;
char mccchannel_10_analyzer_2_array_crystal_array_1_mask_string[16384];
char mccchannel_10_analyzer_2_array_crystal_array_1_mask_setting[16384];
MCNUM mccchannel_10_analyzer_2_array_crystal_array_1_number_of_activations;

/* Setting parameters for component 'channel_10_analyzer_2_array_crystal_array_2' [523]. */
char mccchannel_10_analyzer_2_array_crystal_array_2_material_string[16384];
MCNUM mccchannel_10_analyzer_2_array_crystal_array_2_priority;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_2_xwidth;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_2_yheight;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_2_zdepth;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_2_xwidth2;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_2_yheight2;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_2_visualize;
int mccchannel_10_analyzer_2_array_crystal_array_2_target_index;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_2_target_x;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_2_target_y;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_2_target_z;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_2_focus_aw;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_2_focus_ah;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_2_focus_xw;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_2_focus_xh;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_2_focus_r;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_2_p_interact;
char mccchannel_10_analyzer_2_array_crystal_array_2_mask_string[16384];
char mccchannel_10_analyzer_2_array_crystal_array_2_mask_setting[16384];
MCNUM mccchannel_10_analyzer_2_array_crystal_array_2_number_of_activations;

/* Setting parameters for component 'channel_10_analyzer_2_array_crystal_array_3' [524]. */
char mccchannel_10_analyzer_2_array_crystal_array_3_material_string[16384];
MCNUM mccchannel_10_analyzer_2_array_crystal_array_3_priority;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_3_xwidth;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_3_yheight;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_3_zdepth;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_3_xwidth2;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_3_yheight2;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_3_visualize;
int mccchannel_10_analyzer_2_array_crystal_array_3_target_index;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_3_target_x;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_3_target_y;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_3_target_z;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_3_focus_aw;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_3_focus_ah;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_3_focus_xw;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_3_focus_xh;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_3_focus_r;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_3_p_interact;
char mccchannel_10_analyzer_2_array_crystal_array_3_mask_string[16384];
char mccchannel_10_analyzer_2_array_crystal_array_3_mask_setting[16384];
MCNUM mccchannel_10_analyzer_2_array_crystal_array_3_number_of_activations;

/* Setting parameters for component 'channel_10_analyzer_2_array_crystal_array_4' [525]. */
char mccchannel_10_analyzer_2_array_crystal_array_4_material_string[16384];
MCNUM mccchannel_10_analyzer_2_array_crystal_array_4_priority;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_4_xwidth;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_4_yheight;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_4_zdepth;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_4_xwidth2;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_4_yheight2;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_4_visualize;
int mccchannel_10_analyzer_2_array_crystal_array_4_target_index;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_4_target_x;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_4_target_y;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_4_target_z;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_4_focus_aw;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_4_focus_ah;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_4_focus_xw;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_4_focus_xh;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_4_focus_r;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_4_p_interact;
char mccchannel_10_analyzer_2_array_crystal_array_4_mask_string[16384];
char mccchannel_10_analyzer_2_array_crystal_array_4_mask_setting[16384];
MCNUM mccchannel_10_analyzer_2_array_crystal_array_4_number_of_activations;

/* Setting parameters for component 'channel_10_analyzer_2_array_crystal_array_5' [526]. */
char mccchannel_10_analyzer_2_array_crystal_array_5_material_string[16384];
MCNUM mccchannel_10_analyzer_2_array_crystal_array_5_priority;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_5_xwidth;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_5_yheight;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_5_zdepth;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_5_xwidth2;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_5_yheight2;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_5_visualize;
int mccchannel_10_analyzer_2_array_crystal_array_5_target_index;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_5_target_x;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_5_target_y;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_5_target_z;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_5_focus_aw;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_5_focus_ah;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_5_focus_xw;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_5_focus_xh;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_5_focus_r;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_5_p_interact;
char mccchannel_10_analyzer_2_array_crystal_array_5_mask_string[16384];
char mccchannel_10_analyzer_2_array_crystal_array_5_mask_setting[16384];
MCNUM mccchannel_10_analyzer_2_array_crystal_array_5_number_of_activations;

/* Setting parameters for component 'channel_10_analyzer_2_array_crystal_array_6' [527]. */
char mccchannel_10_analyzer_2_array_crystal_array_6_material_string[16384];
MCNUM mccchannel_10_analyzer_2_array_crystal_array_6_priority;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_6_xwidth;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_6_yheight;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_6_zdepth;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_6_xwidth2;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_6_yheight2;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_6_visualize;
int mccchannel_10_analyzer_2_array_crystal_array_6_target_index;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_6_target_x;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_6_target_y;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_6_target_z;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_6_focus_aw;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_6_focus_ah;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_6_focus_xw;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_6_focus_xh;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_6_focus_r;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_6_p_interact;
char mccchannel_10_analyzer_2_array_crystal_array_6_mask_string[16384];
char mccchannel_10_analyzer_2_array_crystal_array_6_mask_setting[16384];
MCNUM mccchannel_10_analyzer_2_array_crystal_array_6_number_of_activations;

/* Setting parameters for component 'channel_10_analyzer_2_array_crystal_array_7' [528]. */
char mccchannel_10_analyzer_2_array_crystal_array_7_material_string[16384];
MCNUM mccchannel_10_analyzer_2_array_crystal_array_7_priority;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_7_xwidth;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_7_yheight;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_7_zdepth;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_7_xwidth2;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_7_yheight2;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_7_visualize;
int mccchannel_10_analyzer_2_array_crystal_array_7_target_index;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_7_target_x;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_7_target_y;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_7_target_z;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_7_focus_aw;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_7_focus_ah;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_7_focus_xw;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_7_focus_xh;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_7_focus_r;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_7_p_interact;
char mccchannel_10_analyzer_2_array_crystal_array_7_mask_string[16384];
char mccchannel_10_analyzer_2_array_crystal_array_7_mask_setting[16384];
MCNUM mccchannel_10_analyzer_2_array_crystal_array_7_number_of_activations;

/* Setting parameters for component 'channel_10_analyzer_2_array_crystal_array_8' [529]. */
char mccchannel_10_analyzer_2_array_crystal_array_8_material_string[16384];
MCNUM mccchannel_10_analyzer_2_array_crystal_array_8_priority;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_8_xwidth;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_8_yheight;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_8_zdepth;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_8_xwidth2;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_8_yheight2;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_8_visualize;
int mccchannel_10_analyzer_2_array_crystal_array_8_target_index;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_8_target_x;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_8_target_y;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_8_target_z;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_8_focus_aw;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_8_focus_ah;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_8_focus_xw;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_8_focus_xh;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_8_focus_r;
MCNUM mccchannel_10_analyzer_2_array_crystal_array_8_p_interact;
char mccchannel_10_analyzer_2_array_crystal_array_8_mask_string[16384];
char mccchannel_10_analyzer_2_array_crystal_array_8_mask_setting[16384];
MCNUM mccchannel_10_analyzer_2_array_crystal_array_8_number_of_activations;

/* Setting parameters for component 'channel_10_cave2_cyl1' [530]. */
char mccchannel_10_cave2_cyl1_material_string[16384];
MCNUM mccchannel_10_cave2_cyl1_priority;
MCNUM mccchannel_10_cave2_cyl1_radius;
MCNUM mccchannel_10_cave2_cyl1_yheight;
MCNUM mccchannel_10_cave2_cyl1_visualize;
int mccchannel_10_cave2_cyl1_target_index;
MCNUM mccchannel_10_cave2_cyl1_target_x;
MCNUM mccchannel_10_cave2_cyl1_target_y;
MCNUM mccchannel_10_cave2_cyl1_target_z;
MCNUM mccchannel_10_cave2_cyl1_focus_aw;
MCNUM mccchannel_10_cave2_cyl1_focus_ah;
MCNUM mccchannel_10_cave2_cyl1_focus_xw;
MCNUM mccchannel_10_cave2_cyl1_focus_xh;
MCNUM mccchannel_10_cave2_cyl1_focus_r;
MCNUM mccchannel_10_cave2_cyl1_p_interact;
char mccchannel_10_cave2_cyl1_mask_string[16384];
char mccchannel_10_cave2_cyl1_mask_setting[16384];
MCNUM mccchannel_10_cave2_cyl1_number_of_activations;

/* Setting parameters for component 'channel_10_cave2_box1' [531]. */
char mccchannel_10_cave2_box1_material_string[16384];
MCNUM mccchannel_10_cave2_box1_priority;
MCNUM mccchannel_10_cave2_box1_xwidth;
MCNUM mccchannel_10_cave2_box1_yheight;
MCNUM mccchannel_10_cave2_box1_zdepth;
MCNUM mccchannel_10_cave2_box1_xwidth2;
MCNUM mccchannel_10_cave2_box1_yheight2;
MCNUM mccchannel_10_cave2_box1_visualize;
int mccchannel_10_cave2_box1_target_index;
MCNUM mccchannel_10_cave2_box1_target_x;
MCNUM mccchannel_10_cave2_box1_target_y;
MCNUM mccchannel_10_cave2_box1_target_z;
MCNUM mccchannel_10_cave2_box1_focus_aw;
MCNUM mccchannel_10_cave2_box1_focus_ah;
MCNUM mccchannel_10_cave2_box1_focus_xw;
MCNUM mccchannel_10_cave2_box1_focus_xh;
MCNUM mccchannel_10_cave2_box1_focus_r;
MCNUM mccchannel_10_cave2_box1_p_interact;
char mccchannel_10_cave2_box1_mask_string[16384];
char mccchannel_10_cave2_box1_mask_setting[16384];
MCNUM mccchannel_10_cave2_box1_number_of_activations;

/* Setting parameters for component 'channel_10_cave2_box2' [532]. */
char mccchannel_10_cave2_box2_material_string[16384];
MCNUM mccchannel_10_cave2_box2_priority;
MCNUM mccchannel_10_cave2_box2_xwidth;
MCNUM mccchannel_10_cave2_box2_yheight;
MCNUM mccchannel_10_cave2_box2_zdepth;
MCNUM mccchannel_10_cave2_box2_xwidth2;
MCNUM mccchannel_10_cave2_box2_yheight2;
MCNUM mccchannel_10_cave2_box2_visualize;
int mccchannel_10_cave2_box2_target_index;
MCNUM mccchannel_10_cave2_box2_target_x;
MCNUM mccchannel_10_cave2_box2_target_y;
MCNUM mccchannel_10_cave2_box2_target_z;
MCNUM mccchannel_10_cave2_box2_focus_aw;
MCNUM mccchannel_10_cave2_box2_focus_ah;
MCNUM mccchannel_10_cave2_box2_focus_xw;
MCNUM mccchannel_10_cave2_box2_focus_xh;
MCNUM mccchannel_10_cave2_box2_focus_r;
MCNUM mccchannel_10_cave2_box2_p_interact;
char mccchannel_10_cave2_box2_mask_string[16384];
char mccchannel_10_cave2_box2_mask_setting[16384];
MCNUM mccchannel_10_cave2_box2_number_of_activations;

/* Setting parameters for component 'channel_10_cave2_box3' [533]. */
char mccchannel_10_cave2_box3_material_string[16384];
MCNUM mccchannel_10_cave2_box3_priority;
MCNUM mccchannel_10_cave2_box3_xwidth;
MCNUM mccchannel_10_cave2_box3_yheight;
MCNUM mccchannel_10_cave2_box3_zdepth;
MCNUM mccchannel_10_cave2_box3_xwidth2;
MCNUM mccchannel_10_cave2_box3_yheight2;
MCNUM mccchannel_10_cave2_box3_visualize;
int mccchannel_10_cave2_box3_target_index;
MCNUM mccchannel_10_cave2_box3_target_x;
MCNUM mccchannel_10_cave2_box3_target_y;
MCNUM mccchannel_10_cave2_box3_target_z;
MCNUM mccchannel_10_cave2_box3_focus_aw;
MCNUM mccchannel_10_cave2_box3_focus_ah;
MCNUM mccchannel_10_cave2_box3_focus_xw;
MCNUM mccchannel_10_cave2_box3_focus_xh;
MCNUM mccchannel_10_cave2_box3_focus_r;
MCNUM mccchannel_10_cave2_box3_p_interact;
char mccchannel_10_cave2_box3_mask_string[16384];
char mccchannel_10_cave2_box3_mask_setting[16384];
MCNUM mccchannel_10_cave2_box3_number_of_activations;

/* Setting parameters for component 'inter_analyzer_colimator_10_blade_0' [535]. */
char mccinter_analyzer_colimator_10_blade_0_material_string[16384];
MCNUM mccinter_analyzer_colimator_10_blade_0_priority;
MCNUM mccinter_analyzer_colimator_10_blade_0_xwidth;
MCNUM mccinter_analyzer_colimator_10_blade_0_yheight;
MCNUM mccinter_analyzer_colimator_10_blade_0_zdepth;
MCNUM mccinter_analyzer_colimator_10_blade_0_xwidth2;
MCNUM mccinter_analyzer_colimator_10_blade_0_yheight2;
MCNUM mccinter_analyzer_colimator_10_blade_0_visualize;
int mccinter_analyzer_colimator_10_blade_0_target_index;
MCNUM mccinter_analyzer_colimator_10_blade_0_target_x;
MCNUM mccinter_analyzer_colimator_10_blade_0_target_y;
MCNUM mccinter_analyzer_colimator_10_blade_0_target_z;
MCNUM mccinter_analyzer_colimator_10_blade_0_focus_aw;
MCNUM mccinter_analyzer_colimator_10_blade_0_focus_ah;
MCNUM mccinter_analyzer_colimator_10_blade_0_focus_xw;
MCNUM mccinter_analyzer_colimator_10_blade_0_focus_xh;
MCNUM mccinter_analyzer_colimator_10_blade_0_focus_r;
MCNUM mccinter_analyzer_colimator_10_blade_0_p_interact;
char mccinter_analyzer_colimator_10_blade_0_mask_string[16384];
char mccinter_analyzer_colimator_10_blade_0_mask_setting[16384];
MCNUM mccinter_analyzer_colimator_10_blade_0_number_of_activations;

/* Setting parameters for component 'inter_analyzer_colimator_10_blade_1' [536]. */
char mccinter_analyzer_colimator_10_blade_1_material_string[16384];
MCNUM mccinter_analyzer_colimator_10_blade_1_priority;
MCNUM mccinter_analyzer_colimator_10_blade_1_xwidth;
MCNUM mccinter_analyzer_colimator_10_blade_1_yheight;
MCNUM mccinter_analyzer_colimator_10_blade_1_zdepth;
MCNUM mccinter_analyzer_colimator_10_blade_1_xwidth2;
MCNUM mccinter_analyzer_colimator_10_blade_1_yheight2;
MCNUM mccinter_analyzer_colimator_10_blade_1_visualize;
int mccinter_analyzer_colimator_10_blade_1_target_index;
MCNUM mccinter_analyzer_colimator_10_blade_1_target_x;
MCNUM mccinter_analyzer_colimator_10_blade_1_target_y;
MCNUM mccinter_analyzer_colimator_10_blade_1_target_z;
MCNUM mccinter_analyzer_colimator_10_blade_1_focus_aw;
MCNUM mccinter_analyzer_colimator_10_blade_1_focus_ah;
MCNUM mccinter_analyzer_colimator_10_blade_1_focus_xw;
MCNUM mccinter_analyzer_colimator_10_blade_1_focus_xh;
MCNUM mccinter_analyzer_colimator_10_blade_1_focus_r;
MCNUM mccinter_analyzer_colimator_10_blade_1_p_interact;
char mccinter_analyzer_colimator_10_blade_1_mask_string[16384];
char mccinter_analyzer_colimator_10_blade_1_mask_setting[16384];
MCNUM mccinter_analyzer_colimator_10_blade_1_number_of_activations;

/* Setting parameters for component 'inter_analyzer_colimator_10_blade_2' [537]. */
char mccinter_analyzer_colimator_10_blade_2_material_string[16384];
MCNUM mccinter_analyzer_colimator_10_blade_2_priority;
MCNUM mccinter_analyzer_colimator_10_blade_2_xwidth;
MCNUM mccinter_analyzer_colimator_10_blade_2_yheight;
MCNUM mccinter_analyzer_colimator_10_blade_2_zdepth;
MCNUM mccinter_analyzer_colimator_10_blade_2_xwidth2;
MCNUM mccinter_analyzer_colimator_10_blade_2_yheight2;
MCNUM mccinter_analyzer_colimator_10_blade_2_visualize;
int mccinter_analyzer_colimator_10_blade_2_target_index;
MCNUM mccinter_analyzer_colimator_10_blade_2_target_x;
MCNUM mccinter_analyzer_colimator_10_blade_2_target_y;
MCNUM mccinter_analyzer_colimator_10_blade_2_target_z;
MCNUM mccinter_analyzer_colimator_10_blade_2_focus_aw;
MCNUM mccinter_analyzer_colimator_10_blade_2_focus_ah;
MCNUM mccinter_analyzer_colimator_10_blade_2_focus_xw;
MCNUM mccinter_analyzer_colimator_10_blade_2_focus_xh;
MCNUM mccinter_analyzer_colimator_10_blade_2_focus_r;
MCNUM mccinter_analyzer_colimator_10_blade_2_p_interact;
char mccinter_analyzer_colimator_10_blade_2_mask_string[16384];
char mccinter_analyzer_colimator_10_blade_2_mask_setting[16384];
MCNUM mccinter_analyzer_colimator_10_blade_2_number_of_activations;

/* Setting parameters for component 'inter_analyzer_colimator_10_blade_3' [538]. */
char mccinter_analyzer_colimator_10_blade_3_material_string[16384];
MCNUM mccinter_analyzer_colimator_10_blade_3_priority;
MCNUM mccinter_analyzer_colimator_10_blade_3_xwidth;
MCNUM mccinter_analyzer_colimator_10_blade_3_yheight;
MCNUM mccinter_analyzer_colimator_10_blade_3_zdepth;
MCNUM mccinter_analyzer_colimator_10_blade_3_xwidth2;
MCNUM mccinter_analyzer_colimator_10_blade_3_yheight2;
MCNUM mccinter_analyzer_colimator_10_blade_3_visualize;
int mccinter_analyzer_colimator_10_blade_3_target_index;
MCNUM mccinter_analyzer_colimator_10_blade_3_target_x;
MCNUM mccinter_analyzer_colimator_10_blade_3_target_y;
MCNUM mccinter_analyzer_colimator_10_blade_3_target_z;
MCNUM mccinter_analyzer_colimator_10_blade_3_focus_aw;
MCNUM mccinter_analyzer_colimator_10_blade_3_focus_ah;
MCNUM mccinter_analyzer_colimator_10_blade_3_focus_xw;
MCNUM mccinter_analyzer_colimator_10_blade_3_focus_xh;
MCNUM mccinter_analyzer_colimator_10_blade_3_focus_r;
MCNUM mccinter_analyzer_colimator_10_blade_3_p_interact;
char mccinter_analyzer_colimator_10_blade_3_mask_string[16384];
char mccinter_analyzer_colimator_10_blade_3_mask_setting[16384];
MCNUM mccinter_analyzer_colimator_10_blade_3_number_of_activations;

/* Setting parameters for component 'inter_analyzer_colimator_10_blade_4' [539]. */
char mccinter_analyzer_colimator_10_blade_4_material_string[16384];
MCNUM mccinter_analyzer_colimator_10_blade_4_priority;
MCNUM mccinter_analyzer_colimator_10_blade_4_xwidth;
MCNUM mccinter_analyzer_colimator_10_blade_4_yheight;
MCNUM mccinter_analyzer_colimator_10_blade_4_zdepth;
MCNUM mccinter_analyzer_colimator_10_blade_4_xwidth2;
MCNUM mccinter_analyzer_colimator_10_blade_4_yheight2;
MCNUM mccinter_analyzer_colimator_10_blade_4_visualize;
int mccinter_analyzer_colimator_10_blade_4_target_index;
MCNUM mccinter_analyzer_colimator_10_blade_4_target_x;
MCNUM mccinter_analyzer_colimator_10_blade_4_target_y;
MCNUM mccinter_analyzer_colimator_10_blade_4_target_z;
MCNUM mccinter_analyzer_colimator_10_blade_4_focus_aw;
MCNUM mccinter_analyzer_colimator_10_blade_4_focus_ah;
MCNUM mccinter_analyzer_colimator_10_blade_4_focus_xw;
MCNUM mccinter_analyzer_colimator_10_blade_4_focus_xh;
MCNUM mccinter_analyzer_colimator_10_blade_4_focus_r;
MCNUM mccinter_analyzer_colimator_10_blade_4_p_interact;
char mccinter_analyzer_colimator_10_blade_4_mask_string[16384];
char mccinter_analyzer_colimator_10_blade_4_mask_setting[16384];
MCNUM mccinter_analyzer_colimator_10_blade_4_number_of_activations;

/* Setting parameters for component 'diffraction_detector_10_exit_volume' [540]. */
char mccdiffraction_detector_10_exit_volume_material_string[16384];
MCNUM mccdiffraction_detector_10_exit_volume_priority;
MCNUM mccdiffraction_detector_10_exit_volume_xwidth;
MCNUM mccdiffraction_detector_10_exit_volume_yheight;
MCNUM mccdiffraction_detector_10_exit_volume_zdepth;
MCNUM mccdiffraction_detector_10_exit_volume_xwidth2;
MCNUM mccdiffraction_detector_10_exit_volume_yheight2;
MCNUM mccdiffraction_detector_10_exit_volume_visualize;
int mccdiffraction_detector_10_exit_volume_target_index;
MCNUM mccdiffraction_detector_10_exit_volume_target_x;
MCNUM mccdiffraction_detector_10_exit_volume_target_y;
MCNUM mccdiffraction_detector_10_exit_volume_target_z;
MCNUM mccdiffraction_detector_10_exit_volume_focus_aw;
MCNUM mccdiffraction_detector_10_exit_volume_focus_ah;
MCNUM mccdiffraction_detector_10_exit_volume_focus_xw;
MCNUM mccdiffraction_detector_10_exit_volume_focus_xh;
MCNUM mccdiffraction_detector_10_exit_volume_focus_r;
MCNUM mccdiffraction_detector_10_exit_volume_p_interact;
char mccdiffraction_detector_10_exit_volume_mask_string[16384];
char mccdiffraction_detector_10_exit_volume_mask_setting[16384];
MCNUM mccdiffraction_detector_10_exit_volume_number_of_activations;

/* Setting parameters for component 'spec_detector_10_exit_volume' [541]. */
char mccspec_detector_10_exit_volume_material_string[16384];
MCNUM mccspec_detector_10_exit_volume_priority;
MCNUM mccspec_detector_10_exit_volume_xwidth;
MCNUM mccspec_detector_10_exit_volume_yheight;
MCNUM mccspec_detector_10_exit_volume_zdepth;
MCNUM mccspec_detector_10_exit_volume_xwidth2;
MCNUM mccspec_detector_10_exit_volume_yheight2;
MCNUM mccspec_detector_10_exit_volume_visualize;
int mccspec_detector_10_exit_volume_target_index;
MCNUM mccspec_detector_10_exit_volume_target_x;
MCNUM mccspec_detector_10_exit_volume_target_y;
MCNUM mccspec_detector_10_exit_volume_target_z;
MCNUM mccspec_detector_10_exit_volume_focus_aw;
MCNUM mccspec_detector_10_exit_volume_focus_ah;
MCNUM mccspec_detector_10_exit_volume_focus_xw;
MCNUM mccspec_detector_10_exit_volume_focus_xh;
MCNUM mccspec_detector_10_exit_volume_focus_r;
MCNUM mccspec_detector_10_exit_volume_p_interact;
char mccspec_detector_10_exit_volume_mask_string[16384];
char mccspec_detector_10_exit_volume_mask_setting[16384];
MCNUM mccspec_detector_10_exit_volume_number_of_activations;

/* Setting parameters for component 'channel_11_cave1_box1' [542]. */
char mccchannel_11_cave1_box1_material_string[16384];
MCNUM mccchannel_11_cave1_box1_priority;
MCNUM mccchannel_11_cave1_box1_xwidth;
MCNUM mccchannel_11_cave1_box1_yheight;
MCNUM mccchannel_11_cave1_box1_zdepth;
MCNUM mccchannel_11_cave1_box1_xwidth2;
MCNUM mccchannel_11_cave1_box1_yheight2;
MCNUM mccchannel_11_cave1_box1_visualize;
int mccchannel_11_cave1_box1_target_index;
MCNUM mccchannel_11_cave1_box1_target_x;
MCNUM mccchannel_11_cave1_box1_target_y;
MCNUM mccchannel_11_cave1_box1_target_z;
MCNUM mccchannel_11_cave1_box1_focus_aw;
MCNUM mccchannel_11_cave1_box1_focus_ah;
MCNUM mccchannel_11_cave1_box1_focus_xw;
MCNUM mccchannel_11_cave1_box1_focus_xh;
MCNUM mccchannel_11_cave1_box1_focus_r;
MCNUM mccchannel_11_cave1_box1_p_interact;
char mccchannel_11_cave1_box1_mask_string[16384];
char mccchannel_11_cave1_box1_mask_setting[16384];
MCNUM mccchannel_11_cave1_box1_number_of_activations;

/* Setting parameters for component 'channel_11_cave1_box2' [543]. */
char mccchannel_11_cave1_box2_material_string[16384];
MCNUM mccchannel_11_cave1_box2_priority;
MCNUM mccchannel_11_cave1_box2_xwidth;
MCNUM mccchannel_11_cave1_box2_yheight;
MCNUM mccchannel_11_cave1_box2_zdepth;
MCNUM mccchannel_11_cave1_box2_xwidth2;
MCNUM mccchannel_11_cave1_box2_yheight2;
MCNUM mccchannel_11_cave1_box2_visualize;
int mccchannel_11_cave1_box2_target_index;
MCNUM mccchannel_11_cave1_box2_target_x;
MCNUM mccchannel_11_cave1_box2_target_y;
MCNUM mccchannel_11_cave1_box2_target_z;
MCNUM mccchannel_11_cave1_box2_focus_aw;
MCNUM mccchannel_11_cave1_box2_focus_ah;
MCNUM mccchannel_11_cave1_box2_focus_xw;
MCNUM mccchannel_11_cave1_box2_focus_xh;
MCNUM mccchannel_11_cave1_box2_focus_r;
MCNUM mccchannel_11_cave1_box2_p_interact;
char mccchannel_11_cave1_box2_mask_string[16384];
char mccchannel_11_cave1_box2_mask_setting[16384];
MCNUM mccchannel_11_cave1_box2_number_of_activations;

/* Setting parameters for component 'channel_11_cave1_box3' [544]. */
char mccchannel_11_cave1_box3_material_string[16384];
MCNUM mccchannel_11_cave1_box3_priority;
MCNUM mccchannel_11_cave1_box3_xwidth;
MCNUM mccchannel_11_cave1_box3_yheight;
MCNUM mccchannel_11_cave1_box3_zdepth;
MCNUM mccchannel_11_cave1_box3_xwidth2;
MCNUM mccchannel_11_cave1_box3_yheight2;
MCNUM mccchannel_11_cave1_box3_visualize;
int mccchannel_11_cave1_box3_target_index;
MCNUM mccchannel_11_cave1_box3_target_x;
MCNUM mccchannel_11_cave1_box3_target_y;
MCNUM mccchannel_11_cave1_box3_target_z;
MCNUM mccchannel_11_cave1_box3_focus_aw;
MCNUM mccchannel_11_cave1_box3_focus_ah;
MCNUM mccchannel_11_cave1_box3_focus_xw;
MCNUM mccchannel_11_cave1_box3_focus_xh;
MCNUM mccchannel_11_cave1_box3_focus_r;
MCNUM mccchannel_11_cave1_box3_p_interact;
char mccchannel_11_cave1_box3_mask_string[16384];
char mccchannel_11_cave1_box3_mask_setting[16384];
MCNUM mccchannel_11_cave1_box3_number_of_activations;

/* Setting parameters for component 'channel_11_cave1_cyl1' [545]. */
char mccchannel_11_cave1_cyl1_material_string[16384];
MCNUM mccchannel_11_cave1_cyl1_priority;
MCNUM mccchannel_11_cave1_cyl1_radius;
MCNUM mccchannel_11_cave1_cyl1_yheight;
MCNUM mccchannel_11_cave1_cyl1_visualize;
int mccchannel_11_cave1_cyl1_target_index;
MCNUM mccchannel_11_cave1_cyl1_target_x;
MCNUM mccchannel_11_cave1_cyl1_target_y;
MCNUM mccchannel_11_cave1_cyl1_target_z;
MCNUM mccchannel_11_cave1_cyl1_focus_aw;
MCNUM mccchannel_11_cave1_cyl1_focus_ah;
MCNUM mccchannel_11_cave1_cyl1_focus_xw;
MCNUM mccchannel_11_cave1_cyl1_focus_xh;
MCNUM mccchannel_11_cave1_cyl1_focus_r;
MCNUM mccchannel_11_cave1_cyl1_p_interact;
char mccchannel_11_cave1_cyl1_mask_string[16384];
char mccchannel_11_cave1_cyl1_mask_setting[16384];
MCNUM mccchannel_11_cave1_cyl1_number_of_activations;

/* Setting parameters for component 'channel_11_analyzer_1_array_crystal_array_0' [548]. */
char mccchannel_11_analyzer_1_array_crystal_array_0_material_string[16384];
MCNUM mccchannel_11_analyzer_1_array_crystal_array_0_priority;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_0_xwidth;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_0_yheight;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_0_zdepth;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_0_xwidth2;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_0_yheight2;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_0_visualize;
int mccchannel_11_analyzer_1_array_crystal_array_0_target_index;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_0_target_x;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_0_target_y;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_0_target_z;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_0_focus_aw;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_0_focus_ah;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_0_focus_xw;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_0_focus_xh;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_0_focus_r;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_0_p_interact;
char mccchannel_11_analyzer_1_array_crystal_array_0_mask_string[16384];
char mccchannel_11_analyzer_1_array_crystal_array_0_mask_setting[16384];
MCNUM mccchannel_11_analyzer_1_array_crystal_array_0_number_of_activations;

/* Setting parameters for component 'channel_11_analyzer_1_array_crystal_array_1' [549]. */
char mccchannel_11_analyzer_1_array_crystal_array_1_material_string[16384];
MCNUM mccchannel_11_analyzer_1_array_crystal_array_1_priority;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_1_xwidth;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_1_yheight;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_1_zdepth;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_1_xwidth2;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_1_yheight2;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_1_visualize;
int mccchannel_11_analyzer_1_array_crystal_array_1_target_index;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_1_target_x;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_1_target_y;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_1_target_z;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_1_focus_aw;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_1_focus_ah;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_1_focus_xw;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_1_focus_xh;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_1_focus_r;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_1_p_interact;
char mccchannel_11_analyzer_1_array_crystal_array_1_mask_string[16384];
char mccchannel_11_analyzer_1_array_crystal_array_1_mask_setting[16384];
MCNUM mccchannel_11_analyzer_1_array_crystal_array_1_number_of_activations;

/* Setting parameters for component 'channel_11_analyzer_1_array_crystal_array_2' [550]. */
char mccchannel_11_analyzer_1_array_crystal_array_2_material_string[16384];
MCNUM mccchannel_11_analyzer_1_array_crystal_array_2_priority;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_2_xwidth;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_2_yheight;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_2_zdepth;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_2_xwidth2;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_2_yheight2;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_2_visualize;
int mccchannel_11_analyzer_1_array_crystal_array_2_target_index;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_2_target_x;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_2_target_y;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_2_target_z;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_2_focus_aw;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_2_focus_ah;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_2_focus_xw;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_2_focus_xh;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_2_focus_r;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_2_p_interact;
char mccchannel_11_analyzer_1_array_crystal_array_2_mask_string[16384];
char mccchannel_11_analyzer_1_array_crystal_array_2_mask_setting[16384];
MCNUM mccchannel_11_analyzer_1_array_crystal_array_2_number_of_activations;

/* Setting parameters for component 'channel_11_analyzer_1_array_crystal_array_3' [551]. */
char mccchannel_11_analyzer_1_array_crystal_array_3_material_string[16384];
MCNUM mccchannel_11_analyzer_1_array_crystal_array_3_priority;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_3_xwidth;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_3_yheight;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_3_zdepth;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_3_xwidth2;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_3_yheight2;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_3_visualize;
int mccchannel_11_analyzer_1_array_crystal_array_3_target_index;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_3_target_x;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_3_target_y;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_3_target_z;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_3_focus_aw;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_3_focus_ah;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_3_focus_xw;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_3_focus_xh;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_3_focus_r;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_3_p_interact;
char mccchannel_11_analyzer_1_array_crystal_array_3_mask_string[16384];
char mccchannel_11_analyzer_1_array_crystal_array_3_mask_setting[16384];
MCNUM mccchannel_11_analyzer_1_array_crystal_array_3_number_of_activations;

/* Setting parameters for component 'channel_11_analyzer_1_array_crystal_array_4' [552]. */
char mccchannel_11_analyzer_1_array_crystal_array_4_material_string[16384];
MCNUM mccchannel_11_analyzer_1_array_crystal_array_4_priority;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_4_xwidth;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_4_yheight;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_4_zdepth;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_4_xwidth2;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_4_yheight2;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_4_visualize;
int mccchannel_11_analyzer_1_array_crystal_array_4_target_index;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_4_target_x;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_4_target_y;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_4_target_z;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_4_focus_aw;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_4_focus_ah;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_4_focus_xw;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_4_focus_xh;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_4_focus_r;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_4_p_interact;
char mccchannel_11_analyzer_1_array_crystal_array_4_mask_string[16384];
char mccchannel_11_analyzer_1_array_crystal_array_4_mask_setting[16384];
MCNUM mccchannel_11_analyzer_1_array_crystal_array_4_number_of_activations;

/* Setting parameters for component 'channel_11_analyzer_1_array_crystal_array_5' [553]. */
char mccchannel_11_analyzer_1_array_crystal_array_5_material_string[16384];
MCNUM mccchannel_11_analyzer_1_array_crystal_array_5_priority;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_5_xwidth;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_5_yheight;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_5_zdepth;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_5_xwidth2;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_5_yheight2;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_5_visualize;
int mccchannel_11_analyzer_1_array_crystal_array_5_target_index;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_5_target_x;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_5_target_y;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_5_target_z;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_5_focus_aw;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_5_focus_ah;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_5_focus_xw;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_5_focus_xh;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_5_focus_r;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_5_p_interact;
char mccchannel_11_analyzer_1_array_crystal_array_5_mask_string[16384];
char mccchannel_11_analyzer_1_array_crystal_array_5_mask_setting[16384];
MCNUM mccchannel_11_analyzer_1_array_crystal_array_5_number_of_activations;

/* Setting parameters for component 'channel_11_analyzer_1_array_crystal_array_6' [554]. */
char mccchannel_11_analyzer_1_array_crystal_array_6_material_string[16384];
MCNUM mccchannel_11_analyzer_1_array_crystal_array_6_priority;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_6_xwidth;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_6_yheight;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_6_zdepth;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_6_xwidth2;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_6_yheight2;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_6_visualize;
int mccchannel_11_analyzer_1_array_crystal_array_6_target_index;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_6_target_x;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_6_target_y;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_6_target_z;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_6_focus_aw;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_6_focus_ah;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_6_focus_xw;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_6_focus_xh;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_6_focus_r;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_6_p_interact;
char mccchannel_11_analyzer_1_array_crystal_array_6_mask_string[16384];
char mccchannel_11_analyzer_1_array_crystal_array_6_mask_setting[16384];
MCNUM mccchannel_11_analyzer_1_array_crystal_array_6_number_of_activations;

/* Setting parameters for component 'channel_11_analyzer_1_array_crystal_array_7' [555]. */
char mccchannel_11_analyzer_1_array_crystal_array_7_material_string[16384];
MCNUM mccchannel_11_analyzer_1_array_crystal_array_7_priority;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_7_xwidth;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_7_yheight;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_7_zdepth;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_7_xwidth2;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_7_yheight2;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_7_visualize;
int mccchannel_11_analyzer_1_array_crystal_array_7_target_index;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_7_target_x;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_7_target_y;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_7_target_z;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_7_focus_aw;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_7_focus_ah;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_7_focus_xw;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_7_focus_xh;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_7_focus_r;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_7_p_interact;
char mccchannel_11_analyzer_1_array_crystal_array_7_mask_string[16384];
char mccchannel_11_analyzer_1_array_crystal_array_7_mask_setting[16384];
MCNUM mccchannel_11_analyzer_1_array_crystal_array_7_number_of_activations;

/* Setting parameters for component 'channel_11_analyzer_1_array_crystal_array_8' [556]. */
char mccchannel_11_analyzer_1_array_crystal_array_8_material_string[16384];
MCNUM mccchannel_11_analyzer_1_array_crystal_array_8_priority;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_8_xwidth;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_8_yheight;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_8_zdepth;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_8_xwidth2;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_8_yheight2;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_8_visualize;
int mccchannel_11_analyzer_1_array_crystal_array_8_target_index;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_8_target_x;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_8_target_y;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_8_target_z;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_8_focus_aw;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_8_focus_ah;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_8_focus_xw;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_8_focus_xh;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_8_focus_r;
MCNUM mccchannel_11_analyzer_1_array_crystal_array_8_p_interact;
char mccchannel_11_analyzer_1_array_crystal_array_8_mask_string[16384];
char mccchannel_11_analyzer_1_array_crystal_array_8_mask_setting[16384];
MCNUM mccchannel_11_analyzer_1_array_crystal_array_8_number_of_activations;

/* Setting parameters for component 'channel_11_analyzer_2_array_crystal_array_0' [559]. */
char mccchannel_11_analyzer_2_array_crystal_array_0_material_string[16384];
MCNUM mccchannel_11_analyzer_2_array_crystal_array_0_priority;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_0_xwidth;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_0_yheight;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_0_zdepth;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_0_xwidth2;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_0_yheight2;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_0_visualize;
int mccchannel_11_analyzer_2_array_crystal_array_0_target_index;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_0_target_x;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_0_target_y;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_0_target_z;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_0_focus_aw;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_0_focus_ah;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_0_focus_xw;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_0_focus_xh;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_0_focus_r;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_0_p_interact;
char mccchannel_11_analyzer_2_array_crystal_array_0_mask_string[16384];
char mccchannel_11_analyzer_2_array_crystal_array_0_mask_setting[16384];
MCNUM mccchannel_11_analyzer_2_array_crystal_array_0_number_of_activations;

/* Setting parameters for component 'channel_11_analyzer_2_array_crystal_array_1' [560]. */
char mccchannel_11_analyzer_2_array_crystal_array_1_material_string[16384];
MCNUM mccchannel_11_analyzer_2_array_crystal_array_1_priority;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_1_xwidth;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_1_yheight;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_1_zdepth;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_1_xwidth2;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_1_yheight2;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_1_visualize;
int mccchannel_11_analyzer_2_array_crystal_array_1_target_index;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_1_target_x;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_1_target_y;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_1_target_z;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_1_focus_aw;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_1_focus_ah;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_1_focus_xw;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_1_focus_xh;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_1_focus_r;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_1_p_interact;
char mccchannel_11_analyzer_2_array_crystal_array_1_mask_string[16384];
char mccchannel_11_analyzer_2_array_crystal_array_1_mask_setting[16384];
MCNUM mccchannel_11_analyzer_2_array_crystal_array_1_number_of_activations;

/* Setting parameters for component 'channel_11_analyzer_2_array_crystal_array_2' [561]. */
char mccchannel_11_analyzer_2_array_crystal_array_2_material_string[16384];
MCNUM mccchannel_11_analyzer_2_array_crystal_array_2_priority;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_2_xwidth;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_2_yheight;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_2_zdepth;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_2_xwidth2;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_2_yheight2;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_2_visualize;
int mccchannel_11_analyzer_2_array_crystal_array_2_target_index;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_2_target_x;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_2_target_y;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_2_target_z;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_2_focus_aw;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_2_focus_ah;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_2_focus_xw;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_2_focus_xh;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_2_focus_r;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_2_p_interact;
char mccchannel_11_analyzer_2_array_crystal_array_2_mask_string[16384];
char mccchannel_11_analyzer_2_array_crystal_array_2_mask_setting[16384];
MCNUM mccchannel_11_analyzer_2_array_crystal_array_2_number_of_activations;

/* Setting parameters for component 'channel_11_analyzer_2_array_crystal_array_3' [562]. */
char mccchannel_11_analyzer_2_array_crystal_array_3_material_string[16384];
MCNUM mccchannel_11_analyzer_2_array_crystal_array_3_priority;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_3_xwidth;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_3_yheight;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_3_zdepth;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_3_xwidth2;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_3_yheight2;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_3_visualize;
int mccchannel_11_analyzer_2_array_crystal_array_3_target_index;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_3_target_x;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_3_target_y;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_3_target_z;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_3_focus_aw;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_3_focus_ah;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_3_focus_xw;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_3_focus_xh;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_3_focus_r;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_3_p_interact;
char mccchannel_11_analyzer_2_array_crystal_array_3_mask_string[16384];
char mccchannel_11_analyzer_2_array_crystal_array_3_mask_setting[16384];
MCNUM mccchannel_11_analyzer_2_array_crystal_array_3_number_of_activations;

/* Setting parameters for component 'channel_11_analyzer_2_array_crystal_array_4' [563]. */
char mccchannel_11_analyzer_2_array_crystal_array_4_material_string[16384];
MCNUM mccchannel_11_analyzer_2_array_crystal_array_4_priority;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_4_xwidth;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_4_yheight;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_4_zdepth;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_4_xwidth2;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_4_yheight2;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_4_visualize;
int mccchannel_11_analyzer_2_array_crystal_array_4_target_index;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_4_target_x;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_4_target_y;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_4_target_z;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_4_focus_aw;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_4_focus_ah;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_4_focus_xw;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_4_focus_xh;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_4_focus_r;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_4_p_interact;
char mccchannel_11_analyzer_2_array_crystal_array_4_mask_string[16384];
char mccchannel_11_analyzer_2_array_crystal_array_4_mask_setting[16384];
MCNUM mccchannel_11_analyzer_2_array_crystal_array_4_number_of_activations;

/* Setting parameters for component 'channel_11_analyzer_2_array_crystal_array_5' [564]. */
char mccchannel_11_analyzer_2_array_crystal_array_5_material_string[16384];
MCNUM mccchannel_11_analyzer_2_array_crystal_array_5_priority;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_5_xwidth;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_5_yheight;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_5_zdepth;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_5_xwidth2;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_5_yheight2;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_5_visualize;
int mccchannel_11_analyzer_2_array_crystal_array_5_target_index;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_5_target_x;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_5_target_y;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_5_target_z;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_5_focus_aw;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_5_focus_ah;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_5_focus_xw;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_5_focus_xh;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_5_focus_r;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_5_p_interact;
char mccchannel_11_analyzer_2_array_crystal_array_5_mask_string[16384];
char mccchannel_11_analyzer_2_array_crystal_array_5_mask_setting[16384];
MCNUM mccchannel_11_analyzer_2_array_crystal_array_5_number_of_activations;

/* Setting parameters for component 'channel_11_analyzer_2_array_crystal_array_6' [565]. */
char mccchannel_11_analyzer_2_array_crystal_array_6_material_string[16384];
MCNUM mccchannel_11_analyzer_2_array_crystal_array_6_priority;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_6_xwidth;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_6_yheight;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_6_zdepth;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_6_xwidth2;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_6_yheight2;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_6_visualize;
int mccchannel_11_analyzer_2_array_crystal_array_6_target_index;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_6_target_x;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_6_target_y;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_6_target_z;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_6_focus_aw;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_6_focus_ah;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_6_focus_xw;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_6_focus_xh;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_6_focus_r;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_6_p_interact;
char mccchannel_11_analyzer_2_array_crystal_array_6_mask_string[16384];
char mccchannel_11_analyzer_2_array_crystal_array_6_mask_setting[16384];
MCNUM mccchannel_11_analyzer_2_array_crystal_array_6_number_of_activations;

/* Setting parameters for component 'channel_11_analyzer_2_array_crystal_array_7' [566]. */
char mccchannel_11_analyzer_2_array_crystal_array_7_material_string[16384];
MCNUM mccchannel_11_analyzer_2_array_crystal_array_7_priority;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_7_xwidth;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_7_yheight;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_7_zdepth;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_7_xwidth2;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_7_yheight2;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_7_visualize;
int mccchannel_11_analyzer_2_array_crystal_array_7_target_index;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_7_target_x;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_7_target_y;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_7_target_z;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_7_focus_aw;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_7_focus_ah;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_7_focus_xw;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_7_focus_xh;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_7_focus_r;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_7_p_interact;
char mccchannel_11_analyzer_2_array_crystal_array_7_mask_string[16384];
char mccchannel_11_analyzer_2_array_crystal_array_7_mask_setting[16384];
MCNUM mccchannel_11_analyzer_2_array_crystal_array_7_number_of_activations;

/* Setting parameters for component 'channel_11_analyzer_2_array_crystal_array_8' [567]. */
char mccchannel_11_analyzer_2_array_crystal_array_8_material_string[16384];
MCNUM mccchannel_11_analyzer_2_array_crystal_array_8_priority;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_8_xwidth;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_8_yheight;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_8_zdepth;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_8_xwidth2;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_8_yheight2;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_8_visualize;
int mccchannel_11_analyzer_2_array_crystal_array_8_target_index;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_8_target_x;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_8_target_y;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_8_target_z;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_8_focus_aw;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_8_focus_ah;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_8_focus_xw;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_8_focus_xh;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_8_focus_r;
MCNUM mccchannel_11_analyzer_2_array_crystal_array_8_p_interact;
char mccchannel_11_analyzer_2_array_crystal_array_8_mask_string[16384];
char mccchannel_11_analyzer_2_array_crystal_array_8_mask_setting[16384];
MCNUM mccchannel_11_analyzer_2_array_crystal_array_8_number_of_activations;

/* Setting parameters for component 'channel_11_cave2_cyl1' [568]. */
char mccchannel_11_cave2_cyl1_material_string[16384];
MCNUM mccchannel_11_cave2_cyl1_priority;
MCNUM mccchannel_11_cave2_cyl1_radius;
MCNUM mccchannel_11_cave2_cyl1_yheight;
MCNUM mccchannel_11_cave2_cyl1_visualize;
int mccchannel_11_cave2_cyl1_target_index;
MCNUM mccchannel_11_cave2_cyl1_target_x;
MCNUM mccchannel_11_cave2_cyl1_target_y;
MCNUM mccchannel_11_cave2_cyl1_target_z;
MCNUM mccchannel_11_cave2_cyl1_focus_aw;
MCNUM mccchannel_11_cave2_cyl1_focus_ah;
MCNUM mccchannel_11_cave2_cyl1_focus_xw;
MCNUM mccchannel_11_cave2_cyl1_focus_xh;
MCNUM mccchannel_11_cave2_cyl1_focus_r;
MCNUM mccchannel_11_cave2_cyl1_p_interact;
char mccchannel_11_cave2_cyl1_mask_string[16384];
char mccchannel_11_cave2_cyl1_mask_setting[16384];
MCNUM mccchannel_11_cave2_cyl1_number_of_activations;

/* Setting parameters for component 'channel_11_cave2_box1' [569]. */
char mccchannel_11_cave2_box1_material_string[16384];
MCNUM mccchannel_11_cave2_box1_priority;
MCNUM mccchannel_11_cave2_box1_xwidth;
MCNUM mccchannel_11_cave2_box1_yheight;
MCNUM mccchannel_11_cave2_box1_zdepth;
MCNUM mccchannel_11_cave2_box1_xwidth2;
MCNUM mccchannel_11_cave2_box1_yheight2;
MCNUM mccchannel_11_cave2_box1_visualize;
int mccchannel_11_cave2_box1_target_index;
MCNUM mccchannel_11_cave2_box1_target_x;
MCNUM mccchannel_11_cave2_box1_target_y;
MCNUM mccchannel_11_cave2_box1_target_z;
MCNUM mccchannel_11_cave2_box1_focus_aw;
MCNUM mccchannel_11_cave2_box1_focus_ah;
MCNUM mccchannel_11_cave2_box1_focus_xw;
MCNUM mccchannel_11_cave2_box1_focus_xh;
MCNUM mccchannel_11_cave2_box1_focus_r;
MCNUM mccchannel_11_cave2_box1_p_interact;
char mccchannel_11_cave2_box1_mask_string[16384];
char mccchannel_11_cave2_box1_mask_setting[16384];
MCNUM mccchannel_11_cave2_box1_number_of_activations;

/* Setting parameters for component 'channel_11_cave2_box2' [570]. */
char mccchannel_11_cave2_box2_material_string[16384];
MCNUM mccchannel_11_cave2_box2_priority;
MCNUM mccchannel_11_cave2_box2_xwidth;
MCNUM mccchannel_11_cave2_box2_yheight;
MCNUM mccchannel_11_cave2_box2_zdepth;
MCNUM mccchannel_11_cave2_box2_xwidth2;
MCNUM mccchannel_11_cave2_box2_yheight2;
MCNUM mccchannel_11_cave2_box2_visualize;
int mccchannel_11_cave2_box2_target_index;
MCNUM mccchannel_11_cave2_box2_target_x;
MCNUM mccchannel_11_cave2_box2_target_y;
MCNUM mccchannel_11_cave2_box2_target_z;
MCNUM mccchannel_11_cave2_box2_focus_aw;
MCNUM mccchannel_11_cave2_box2_focus_ah;
MCNUM mccchannel_11_cave2_box2_focus_xw;
MCNUM mccchannel_11_cave2_box2_focus_xh;
MCNUM mccchannel_11_cave2_box2_focus_r;
MCNUM mccchannel_11_cave2_box2_p_interact;
char mccchannel_11_cave2_box2_mask_string[16384];
char mccchannel_11_cave2_box2_mask_setting[16384];
MCNUM mccchannel_11_cave2_box2_number_of_activations;

/* Setting parameters for component 'channel_11_cave2_box3' [571]. */
char mccchannel_11_cave2_box3_material_string[16384];
MCNUM mccchannel_11_cave2_box3_priority;
MCNUM mccchannel_11_cave2_box3_xwidth;
MCNUM mccchannel_11_cave2_box3_yheight;
MCNUM mccchannel_11_cave2_box3_zdepth;
MCNUM mccchannel_11_cave2_box3_xwidth2;
MCNUM mccchannel_11_cave2_box3_yheight2;
MCNUM mccchannel_11_cave2_box3_visualize;
int mccchannel_11_cave2_box3_target_index;
MCNUM mccchannel_11_cave2_box3_target_x;
MCNUM mccchannel_11_cave2_box3_target_y;
MCNUM mccchannel_11_cave2_box3_target_z;
MCNUM mccchannel_11_cave2_box3_focus_aw;
MCNUM mccchannel_11_cave2_box3_focus_ah;
MCNUM mccchannel_11_cave2_box3_focus_xw;
MCNUM mccchannel_11_cave2_box3_focus_xh;
MCNUM mccchannel_11_cave2_box3_focus_r;
MCNUM mccchannel_11_cave2_box3_p_interact;
char mccchannel_11_cave2_box3_mask_string[16384];
char mccchannel_11_cave2_box3_mask_setting[16384];
MCNUM mccchannel_11_cave2_box3_number_of_activations;

/* Setting parameters for component 'inter_analyzer_colimator_11_blade_0' [573]. */
char mccinter_analyzer_colimator_11_blade_0_material_string[16384];
MCNUM mccinter_analyzer_colimator_11_blade_0_priority;
MCNUM mccinter_analyzer_colimator_11_blade_0_xwidth;
MCNUM mccinter_analyzer_colimator_11_blade_0_yheight;
MCNUM mccinter_analyzer_colimator_11_blade_0_zdepth;
MCNUM mccinter_analyzer_colimator_11_blade_0_xwidth2;
MCNUM mccinter_analyzer_colimator_11_blade_0_yheight2;
MCNUM mccinter_analyzer_colimator_11_blade_0_visualize;
int mccinter_analyzer_colimator_11_blade_0_target_index;
MCNUM mccinter_analyzer_colimator_11_blade_0_target_x;
MCNUM mccinter_analyzer_colimator_11_blade_0_target_y;
MCNUM mccinter_analyzer_colimator_11_blade_0_target_z;
MCNUM mccinter_analyzer_colimator_11_blade_0_focus_aw;
MCNUM mccinter_analyzer_colimator_11_blade_0_focus_ah;
MCNUM mccinter_analyzer_colimator_11_blade_0_focus_xw;
MCNUM mccinter_analyzer_colimator_11_blade_0_focus_xh;
MCNUM mccinter_analyzer_colimator_11_blade_0_focus_r;
MCNUM mccinter_analyzer_colimator_11_blade_0_p_interact;
char mccinter_analyzer_colimator_11_blade_0_mask_string[16384];
char mccinter_analyzer_colimator_11_blade_0_mask_setting[16384];
MCNUM mccinter_analyzer_colimator_11_blade_0_number_of_activations;

/* Setting parameters for component 'inter_analyzer_colimator_11_blade_1' [574]. */
char mccinter_analyzer_colimator_11_blade_1_material_string[16384];
MCNUM mccinter_analyzer_colimator_11_blade_1_priority;
MCNUM mccinter_analyzer_colimator_11_blade_1_xwidth;
MCNUM mccinter_analyzer_colimator_11_blade_1_yheight;
MCNUM mccinter_analyzer_colimator_11_blade_1_zdepth;
MCNUM mccinter_analyzer_colimator_11_blade_1_xwidth2;
MCNUM mccinter_analyzer_colimator_11_blade_1_yheight2;
MCNUM mccinter_analyzer_colimator_11_blade_1_visualize;
int mccinter_analyzer_colimator_11_blade_1_target_index;
MCNUM mccinter_analyzer_colimator_11_blade_1_target_x;
MCNUM mccinter_analyzer_colimator_11_blade_1_target_y;
MCNUM mccinter_analyzer_colimator_11_blade_1_target_z;
MCNUM mccinter_analyzer_colimator_11_blade_1_focus_aw;
MCNUM mccinter_analyzer_colimator_11_blade_1_focus_ah;
MCNUM mccinter_analyzer_colimator_11_blade_1_focus_xw;
MCNUM mccinter_analyzer_colimator_11_blade_1_focus_xh;
MCNUM mccinter_analyzer_colimator_11_blade_1_focus_r;
MCNUM mccinter_analyzer_colimator_11_blade_1_p_interact;
char mccinter_analyzer_colimator_11_blade_1_mask_string[16384];
char mccinter_analyzer_colimator_11_blade_1_mask_setting[16384];
MCNUM mccinter_analyzer_colimator_11_blade_1_number_of_activations;

/* Setting parameters for component 'inter_analyzer_colimator_11_blade_2' [575]. */
char mccinter_analyzer_colimator_11_blade_2_material_string[16384];
MCNUM mccinter_analyzer_colimator_11_blade_2_priority;
MCNUM mccinter_analyzer_colimator_11_blade_2_xwidth;
MCNUM mccinter_analyzer_colimator_11_blade_2_yheight;
MCNUM mccinter_analyzer_colimator_11_blade_2_zdepth;
MCNUM mccinter_analyzer_colimator_11_blade_2_xwidth2;
MCNUM mccinter_analyzer_colimator_11_blade_2_yheight2;
MCNUM mccinter_analyzer_colimator_11_blade_2_visualize;
int mccinter_analyzer_colimator_11_blade_2_target_index;
MCNUM mccinter_analyzer_colimator_11_blade_2_target_x;
MCNUM mccinter_analyzer_colimator_11_blade_2_target_y;
MCNUM mccinter_analyzer_colimator_11_blade_2_target_z;
MCNUM mccinter_analyzer_colimator_11_blade_2_focus_aw;
MCNUM mccinter_analyzer_colimator_11_blade_2_focus_ah;
MCNUM mccinter_analyzer_colimator_11_blade_2_focus_xw;
MCNUM mccinter_analyzer_colimator_11_blade_2_focus_xh;
MCNUM mccinter_analyzer_colimator_11_blade_2_focus_r;
MCNUM mccinter_analyzer_colimator_11_blade_2_p_interact;
char mccinter_analyzer_colimator_11_blade_2_mask_string[16384];
char mccinter_analyzer_colimator_11_blade_2_mask_setting[16384];
MCNUM mccinter_analyzer_colimator_11_blade_2_number_of_activations;

/* Setting parameters for component 'inter_analyzer_colimator_11_blade_3' [576]. */
char mccinter_analyzer_colimator_11_blade_3_material_string[16384];
MCNUM mccinter_analyzer_colimator_11_blade_3_priority;
MCNUM mccinter_analyzer_colimator_11_blade_3_xwidth;
MCNUM mccinter_analyzer_colimator_11_blade_3_yheight;
MCNUM mccinter_analyzer_colimator_11_blade_3_zdepth;
MCNUM mccinter_analyzer_colimator_11_blade_3_xwidth2;
MCNUM mccinter_analyzer_colimator_11_blade_3_yheight2;
MCNUM mccinter_analyzer_colimator_11_blade_3_visualize;
int mccinter_analyzer_colimator_11_blade_3_target_index;
MCNUM mccinter_analyzer_colimator_11_blade_3_target_x;
MCNUM mccinter_analyzer_colimator_11_blade_3_target_y;
MCNUM mccinter_analyzer_colimator_11_blade_3_target_z;
MCNUM mccinter_analyzer_colimator_11_blade_3_focus_aw;
MCNUM mccinter_analyzer_colimator_11_blade_3_focus_ah;
MCNUM mccinter_analyzer_colimator_11_blade_3_focus_xw;
MCNUM mccinter_analyzer_colimator_11_blade_3_focus_xh;
MCNUM mccinter_analyzer_colimator_11_blade_3_focus_r;
MCNUM mccinter_analyzer_colimator_11_blade_3_p_interact;
char mccinter_analyzer_colimator_11_blade_3_mask_string[16384];
char mccinter_analyzer_colimator_11_blade_3_mask_setting[16384];
MCNUM mccinter_analyzer_colimator_11_blade_3_number_of_activations;

/* Setting parameters for component 'inter_analyzer_colimator_11_blade_4' [577]. */
char mccinter_analyzer_colimator_11_blade_4_material_string[16384];
MCNUM mccinter_analyzer_colimator_11_blade_4_priority;
MCNUM mccinter_analyzer_colimator_11_blade_4_xwidth;
MCNUM mccinter_analyzer_colimator_11_blade_4_yheight;
MCNUM mccinter_analyzer_colimator_11_blade_4_zdepth;
MCNUM mccinter_analyzer_colimator_11_blade_4_xwidth2;
MCNUM mccinter_analyzer_colimator_11_blade_4_yheight2;
MCNUM mccinter_analyzer_colimator_11_blade_4_visualize;
int mccinter_analyzer_colimator_11_blade_4_target_index;
MCNUM mccinter_analyzer_colimator_11_blade_4_target_x;
MCNUM mccinter_analyzer_colimator_11_blade_4_target_y;
MCNUM mccinter_analyzer_colimator_11_blade_4_target_z;
MCNUM mccinter_analyzer_colimator_11_blade_4_focus_aw;
MCNUM mccinter_analyzer_colimator_11_blade_4_focus_ah;
MCNUM mccinter_analyzer_colimator_11_blade_4_focus_xw;
MCNUM mccinter_analyzer_colimator_11_blade_4_focus_xh;
MCNUM mccinter_analyzer_colimator_11_blade_4_focus_r;
MCNUM mccinter_analyzer_colimator_11_blade_4_p_interact;
char mccinter_analyzer_colimator_11_blade_4_mask_string[16384];
char mccinter_analyzer_colimator_11_blade_4_mask_setting[16384];
MCNUM mccinter_analyzer_colimator_11_blade_4_number_of_activations;

/* Setting parameters for component 'diffraction_detector_11_exit_volume' [578]. */
char mccdiffraction_detector_11_exit_volume_material_string[16384];
MCNUM mccdiffraction_detector_11_exit_volume_priority;
MCNUM mccdiffraction_detector_11_exit_volume_xwidth;
MCNUM mccdiffraction_detector_11_exit_volume_yheight;
MCNUM mccdiffraction_detector_11_exit_volume_zdepth;
MCNUM mccdiffraction_detector_11_exit_volume_xwidth2;
MCNUM mccdiffraction_detector_11_exit_volume_yheight2;
MCNUM mccdiffraction_detector_11_exit_volume_visualize;
int mccdiffraction_detector_11_exit_volume_target_index;
MCNUM mccdiffraction_detector_11_exit_volume_target_x;
MCNUM mccdiffraction_detector_11_exit_volume_target_y;
MCNUM mccdiffraction_detector_11_exit_volume_target_z;
MCNUM mccdiffraction_detector_11_exit_volume_focus_aw;
MCNUM mccdiffraction_detector_11_exit_volume_focus_ah;
MCNUM mccdiffraction_detector_11_exit_volume_focus_xw;
MCNUM mccdiffraction_detector_11_exit_volume_focus_xh;
MCNUM mccdiffraction_detector_11_exit_volume_focus_r;
MCNUM mccdiffraction_detector_11_exit_volume_p_interact;
char mccdiffraction_detector_11_exit_volume_mask_string[16384];
char mccdiffraction_detector_11_exit_volume_mask_setting[16384];
MCNUM mccdiffraction_detector_11_exit_volume_number_of_activations;

/* Setting parameters for component 'spec_detector_11_exit_volume' [579]. */
char mccspec_detector_11_exit_volume_material_string[16384];
MCNUM mccspec_detector_11_exit_volume_priority;
MCNUM mccspec_detector_11_exit_volume_xwidth;
MCNUM mccspec_detector_11_exit_volume_yheight;
MCNUM mccspec_detector_11_exit_volume_zdepth;
MCNUM mccspec_detector_11_exit_volume_xwidth2;
MCNUM mccspec_detector_11_exit_volume_yheight2;
MCNUM mccspec_detector_11_exit_volume_visualize;
int mccspec_detector_11_exit_volume_target_index;
MCNUM mccspec_detector_11_exit_volume_target_x;
MCNUM mccspec_detector_11_exit_volume_target_y;
MCNUM mccspec_detector_11_exit_volume_target_z;
MCNUM mccspec_detector_11_exit_volume_focus_aw;
MCNUM mccspec_detector_11_exit_volume_focus_ah;
MCNUM mccspec_detector_11_exit_volume_focus_xw;
MCNUM mccspec_detector_11_exit_volume_focus_xh;
MCNUM mccspec_detector_11_exit_volume_focus_r;
MCNUM mccspec_detector_11_exit_volume_p_interact;
char mccspec_detector_11_exit_volume_mask_string[16384];
char mccspec_detector_11_exit_volume_mask_setting[16384];
MCNUM mccspec_detector_11_exit_volume_number_of_activations;

/* Setting parameters for component 'channel_12_cave1_box1' [580]. */
char mccchannel_12_cave1_box1_material_string[16384];
MCNUM mccchannel_12_cave1_box1_priority;
MCNUM mccchannel_12_cave1_box1_xwidth;
MCNUM mccchannel_12_cave1_box1_yheight;
MCNUM mccchannel_12_cave1_box1_zdepth;
MCNUM mccchannel_12_cave1_box1_xwidth2;
MCNUM mccchannel_12_cave1_box1_yheight2;
MCNUM mccchannel_12_cave1_box1_visualize;
int mccchannel_12_cave1_box1_target_index;
MCNUM mccchannel_12_cave1_box1_target_x;
MCNUM mccchannel_12_cave1_box1_target_y;
MCNUM mccchannel_12_cave1_box1_target_z;
MCNUM mccchannel_12_cave1_box1_focus_aw;
MCNUM mccchannel_12_cave1_box1_focus_ah;
MCNUM mccchannel_12_cave1_box1_focus_xw;
MCNUM mccchannel_12_cave1_box1_focus_xh;
MCNUM mccchannel_12_cave1_box1_focus_r;
MCNUM mccchannel_12_cave1_box1_p_interact;
char mccchannel_12_cave1_box1_mask_string[16384];
char mccchannel_12_cave1_box1_mask_setting[16384];
MCNUM mccchannel_12_cave1_box1_number_of_activations;

/* Setting parameters for component 'channel_12_cave1_box2' [581]. */
char mccchannel_12_cave1_box2_material_string[16384];
MCNUM mccchannel_12_cave1_box2_priority;
MCNUM mccchannel_12_cave1_box2_xwidth;
MCNUM mccchannel_12_cave1_box2_yheight;
MCNUM mccchannel_12_cave1_box2_zdepth;
MCNUM mccchannel_12_cave1_box2_xwidth2;
MCNUM mccchannel_12_cave1_box2_yheight2;
MCNUM mccchannel_12_cave1_box2_visualize;
int mccchannel_12_cave1_box2_target_index;
MCNUM mccchannel_12_cave1_box2_target_x;
MCNUM mccchannel_12_cave1_box2_target_y;
MCNUM mccchannel_12_cave1_box2_target_z;
MCNUM mccchannel_12_cave1_box2_focus_aw;
MCNUM mccchannel_12_cave1_box2_focus_ah;
MCNUM mccchannel_12_cave1_box2_focus_xw;
MCNUM mccchannel_12_cave1_box2_focus_xh;
MCNUM mccchannel_12_cave1_box2_focus_r;
MCNUM mccchannel_12_cave1_box2_p_interact;
char mccchannel_12_cave1_box2_mask_string[16384];
char mccchannel_12_cave1_box2_mask_setting[16384];
MCNUM mccchannel_12_cave1_box2_number_of_activations;

/* Setting parameters for component 'channel_12_cave1_box3' [582]. */
char mccchannel_12_cave1_box3_material_string[16384];
MCNUM mccchannel_12_cave1_box3_priority;
MCNUM mccchannel_12_cave1_box3_xwidth;
MCNUM mccchannel_12_cave1_box3_yheight;
MCNUM mccchannel_12_cave1_box3_zdepth;
MCNUM mccchannel_12_cave1_box3_xwidth2;
MCNUM mccchannel_12_cave1_box3_yheight2;
MCNUM mccchannel_12_cave1_box3_visualize;
int mccchannel_12_cave1_box3_target_index;
MCNUM mccchannel_12_cave1_box3_target_x;
MCNUM mccchannel_12_cave1_box3_target_y;
MCNUM mccchannel_12_cave1_box3_target_z;
MCNUM mccchannel_12_cave1_box3_focus_aw;
MCNUM mccchannel_12_cave1_box3_focus_ah;
MCNUM mccchannel_12_cave1_box3_focus_xw;
MCNUM mccchannel_12_cave1_box3_focus_xh;
MCNUM mccchannel_12_cave1_box3_focus_r;
MCNUM mccchannel_12_cave1_box3_p_interact;
char mccchannel_12_cave1_box3_mask_string[16384];
char mccchannel_12_cave1_box3_mask_setting[16384];
MCNUM mccchannel_12_cave1_box3_number_of_activations;

/* Setting parameters for component 'channel_12_cave1_cyl1' [583]. */
char mccchannel_12_cave1_cyl1_material_string[16384];
MCNUM mccchannel_12_cave1_cyl1_priority;
MCNUM mccchannel_12_cave1_cyl1_radius;
MCNUM mccchannel_12_cave1_cyl1_yheight;
MCNUM mccchannel_12_cave1_cyl1_visualize;
int mccchannel_12_cave1_cyl1_target_index;
MCNUM mccchannel_12_cave1_cyl1_target_x;
MCNUM mccchannel_12_cave1_cyl1_target_y;
MCNUM mccchannel_12_cave1_cyl1_target_z;
MCNUM mccchannel_12_cave1_cyl1_focus_aw;
MCNUM mccchannel_12_cave1_cyl1_focus_ah;
MCNUM mccchannel_12_cave1_cyl1_focus_xw;
MCNUM mccchannel_12_cave1_cyl1_focus_xh;
MCNUM mccchannel_12_cave1_cyl1_focus_r;
MCNUM mccchannel_12_cave1_cyl1_p_interact;
char mccchannel_12_cave1_cyl1_mask_string[16384];
char mccchannel_12_cave1_cyl1_mask_setting[16384];
MCNUM mccchannel_12_cave1_cyl1_number_of_activations;

/* Setting parameters for component 'channel_12_analyzer_1_array_crystal_array_0' [586]. */
char mccchannel_12_analyzer_1_array_crystal_array_0_material_string[16384];
MCNUM mccchannel_12_analyzer_1_array_crystal_array_0_priority;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_0_xwidth;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_0_yheight;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_0_zdepth;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_0_xwidth2;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_0_yheight2;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_0_visualize;
int mccchannel_12_analyzer_1_array_crystal_array_0_target_index;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_0_target_x;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_0_target_y;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_0_target_z;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_0_focus_aw;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_0_focus_ah;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_0_focus_xw;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_0_focus_xh;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_0_focus_r;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_0_p_interact;
char mccchannel_12_analyzer_1_array_crystal_array_0_mask_string[16384];
char mccchannel_12_analyzer_1_array_crystal_array_0_mask_setting[16384];
MCNUM mccchannel_12_analyzer_1_array_crystal_array_0_number_of_activations;

/* Setting parameters for component 'channel_12_analyzer_1_array_crystal_array_1' [587]. */
char mccchannel_12_analyzer_1_array_crystal_array_1_material_string[16384];
MCNUM mccchannel_12_analyzer_1_array_crystal_array_1_priority;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_1_xwidth;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_1_yheight;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_1_zdepth;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_1_xwidth2;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_1_yheight2;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_1_visualize;
int mccchannel_12_analyzer_1_array_crystal_array_1_target_index;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_1_target_x;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_1_target_y;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_1_target_z;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_1_focus_aw;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_1_focus_ah;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_1_focus_xw;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_1_focus_xh;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_1_focus_r;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_1_p_interact;
char mccchannel_12_analyzer_1_array_crystal_array_1_mask_string[16384];
char mccchannel_12_analyzer_1_array_crystal_array_1_mask_setting[16384];
MCNUM mccchannel_12_analyzer_1_array_crystal_array_1_number_of_activations;

/* Setting parameters for component 'channel_12_analyzer_1_array_crystal_array_2' [588]. */
char mccchannel_12_analyzer_1_array_crystal_array_2_material_string[16384];
MCNUM mccchannel_12_analyzer_1_array_crystal_array_2_priority;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_2_xwidth;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_2_yheight;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_2_zdepth;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_2_xwidth2;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_2_yheight2;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_2_visualize;
int mccchannel_12_analyzer_1_array_crystal_array_2_target_index;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_2_target_x;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_2_target_y;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_2_target_z;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_2_focus_aw;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_2_focus_ah;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_2_focus_xw;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_2_focus_xh;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_2_focus_r;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_2_p_interact;
char mccchannel_12_analyzer_1_array_crystal_array_2_mask_string[16384];
char mccchannel_12_analyzer_1_array_crystal_array_2_mask_setting[16384];
MCNUM mccchannel_12_analyzer_1_array_crystal_array_2_number_of_activations;

/* Setting parameters for component 'channel_12_analyzer_1_array_crystal_array_3' [589]. */
char mccchannel_12_analyzer_1_array_crystal_array_3_material_string[16384];
MCNUM mccchannel_12_analyzer_1_array_crystal_array_3_priority;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_3_xwidth;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_3_yheight;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_3_zdepth;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_3_xwidth2;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_3_yheight2;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_3_visualize;
int mccchannel_12_analyzer_1_array_crystal_array_3_target_index;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_3_target_x;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_3_target_y;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_3_target_z;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_3_focus_aw;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_3_focus_ah;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_3_focus_xw;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_3_focus_xh;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_3_focus_r;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_3_p_interact;
char mccchannel_12_analyzer_1_array_crystal_array_3_mask_string[16384];
char mccchannel_12_analyzer_1_array_crystal_array_3_mask_setting[16384];
MCNUM mccchannel_12_analyzer_1_array_crystal_array_3_number_of_activations;

/* Setting parameters for component 'channel_12_analyzer_1_array_crystal_array_4' [590]. */
char mccchannel_12_analyzer_1_array_crystal_array_4_material_string[16384];
MCNUM mccchannel_12_analyzer_1_array_crystal_array_4_priority;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_4_xwidth;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_4_yheight;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_4_zdepth;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_4_xwidth2;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_4_yheight2;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_4_visualize;
int mccchannel_12_analyzer_1_array_crystal_array_4_target_index;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_4_target_x;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_4_target_y;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_4_target_z;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_4_focus_aw;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_4_focus_ah;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_4_focus_xw;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_4_focus_xh;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_4_focus_r;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_4_p_interact;
char mccchannel_12_analyzer_1_array_crystal_array_4_mask_string[16384];
char mccchannel_12_analyzer_1_array_crystal_array_4_mask_setting[16384];
MCNUM mccchannel_12_analyzer_1_array_crystal_array_4_number_of_activations;

/* Setting parameters for component 'channel_12_analyzer_1_array_crystal_array_5' [591]. */
char mccchannel_12_analyzer_1_array_crystal_array_5_material_string[16384];
MCNUM mccchannel_12_analyzer_1_array_crystal_array_5_priority;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_5_xwidth;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_5_yheight;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_5_zdepth;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_5_xwidth2;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_5_yheight2;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_5_visualize;
int mccchannel_12_analyzer_1_array_crystal_array_5_target_index;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_5_target_x;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_5_target_y;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_5_target_z;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_5_focus_aw;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_5_focus_ah;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_5_focus_xw;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_5_focus_xh;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_5_focus_r;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_5_p_interact;
char mccchannel_12_analyzer_1_array_crystal_array_5_mask_string[16384];
char mccchannel_12_analyzer_1_array_crystal_array_5_mask_setting[16384];
MCNUM mccchannel_12_analyzer_1_array_crystal_array_5_number_of_activations;

/* Setting parameters for component 'channel_12_analyzer_1_array_crystal_array_6' [592]. */
char mccchannel_12_analyzer_1_array_crystal_array_6_material_string[16384];
MCNUM mccchannel_12_analyzer_1_array_crystal_array_6_priority;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_6_xwidth;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_6_yheight;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_6_zdepth;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_6_xwidth2;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_6_yheight2;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_6_visualize;
int mccchannel_12_analyzer_1_array_crystal_array_6_target_index;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_6_target_x;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_6_target_y;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_6_target_z;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_6_focus_aw;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_6_focus_ah;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_6_focus_xw;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_6_focus_xh;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_6_focus_r;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_6_p_interact;
char mccchannel_12_analyzer_1_array_crystal_array_6_mask_string[16384];
char mccchannel_12_analyzer_1_array_crystal_array_6_mask_setting[16384];
MCNUM mccchannel_12_analyzer_1_array_crystal_array_6_number_of_activations;

/* Setting parameters for component 'channel_12_analyzer_1_array_crystal_array_7' [593]. */
char mccchannel_12_analyzer_1_array_crystal_array_7_material_string[16384];
MCNUM mccchannel_12_analyzer_1_array_crystal_array_7_priority;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_7_xwidth;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_7_yheight;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_7_zdepth;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_7_xwidth2;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_7_yheight2;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_7_visualize;
int mccchannel_12_analyzer_1_array_crystal_array_7_target_index;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_7_target_x;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_7_target_y;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_7_target_z;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_7_focus_aw;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_7_focus_ah;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_7_focus_xw;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_7_focus_xh;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_7_focus_r;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_7_p_interact;
char mccchannel_12_analyzer_1_array_crystal_array_7_mask_string[16384];
char mccchannel_12_analyzer_1_array_crystal_array_7_mask_setting[16384];
MCNUM mccchannel_12_analyzer_1_array_crystal_array_7_number_of_activations;

/* Setting parameters for component 'channel_12_analyzer_1_array_crystal_array_8' [594]. */
char mccchannel_12_analyzer_1_array_crystal_array_8_material_string[16384];
MCNUM mccchannel_12_analyzer_1_array_crystal_array_8_priority;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_8_xwidth;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_8_yheight;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_8_zdepth;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_8_xwidth2;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_8_yheight2;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_8_visualize;
int mccchannel_12_analyzer_1_array_crystal_array_8_target_index;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_8_target_x;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_8_target_y;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_8_target_z;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_8_focus_aw;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_8_focus_ah;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_8_focus_xw;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_8_focus_xh;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_8_focus_r;
MCNUM mccchannel_12_analyzer_1_array_crystal_array_8_p_interact;
char mccchannel_12_analyzer_1_array_crystal_array_8_mask_string[16384];
char mccchannel_12_analyzer_1_array_crystal_array_8_mask_setting[16384];
MCNUM mccchannel_12_analyzer_1_array_crystal_array_8_number_of_activations;

/* Setting parameters for component 'channel_12_analyzer_2_array_crystal_array_0' [597]. */
char mccchannel_12_analyzer_2_array_crystal_array_0_material_string[16384];
MCNUM mccchannel_12_analyzer_2_array_crystal_array_0_priority;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_0_xwidth;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_0_yheight;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_0_zdepth;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_0_xwidth2;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_0_yheight2;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_0_visualize;
int mccchannel_12_analyzer_2_array_crystal_array_0_target_index;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_0_target_x;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_0_target_y;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_0_target_z;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_0_focus_aw;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_0_focus_ah;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_0_focus_xw;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_0_focus_xh;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_0_focus_r;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_0_p_interact;
char mccchannel_12_analyzer_2_array_crystal_array_0_mask_string[16384];
char mccchannel_12_analyzer_2_array_crystal_array_0_mask_setting[16384];
MCNUM mccchannel_12_analyzer_2_array_crystal_array_0_number_of_activations;

/* Setting parameters for component 'channel_12_analyzer_2_array_crystal_array_1' [598]. */
char mccchannel_12_analyzer_2_array_crystal_array_1_material_string[16384];
MCNUM mccchannel_12_analyzer_2_array_crystal_array_1_priority;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_1_xwidth;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_1_yheight;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_1_zdepth;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_1_xwidth2;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_1_yheight2;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_1_visualize;
int mccchannel_12_analyzer_2_array_crystal_array_1_target_index;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_1_target_x;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_1_target_y;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_1_target_z;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_1_focus_aw;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_1_focus_ah;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_1_focus_xw;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_1_focus_xh;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_1_focus_r;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_1_p_interact;
char mccchannel_12_analyzer_2_array_crystal_array_1_mask_string[16384];
char mccchannel_12_analyzer_2_array_crystal_array_1_mask_setting[16384];
MCNUM mccchannel_12_analyzer_2_array_crystal_array_1_number_of_activations;

/* Setting parameters for component 'channel_12_analyzer_2_array_crystal_array_2' [599]. */
char mccchannel_12_analyzer_2_array_crystal_array_2_material_string[16384];
MCNUM mccchannel_12_analyzer_2_array_crystal_array_2_priority;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_2_xwidth;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_2_yheight;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_2_zdepth;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_2_xwidth2;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_2_yheight2;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_2_visualize;
int mccchannel_12_analyzer_2_array_crystal_array_2_target_index;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_2_target_x;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_2_target_y;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_2_target_z;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_2_focus_aw;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_2_focus_ah;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_2_focus_xw;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_2_focus_xh;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_2_focus_r;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_2_p_interact;
char mccchannel_12_analyzer_2_array_crystal_array_2_mask_string[16384];
char mccchannel_12_analyzer_2_array_crystal_array_2_mask_setting[16384];
MCNUM mccchannel_12_analyzer_2_array_crystal_array_2_number_of_activations;

/* Setting parameters for component 'channel_12_analyzer_2_array_crystal_array_3' [600]. */
char mccchannel_12_analyzer_2_array_crystal_array_3_material_string[16384];
MCNUM mccchannel_12_analyzer_2_array_crystal_array_3_priority;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_3_xwidth;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_3_yheight;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_3_zdepth;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_3_xwidth2;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_3_yheight2;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_3_visualize;
int mccchannel_12_analyzer_2_array_crystal_array_3_target_index;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_3_target_x;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_3_target_y;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_3_target_z;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_3_focus_aw;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_3_focus_ah;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_3_focus_xw;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_3_focus_xh;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_3_focus_r;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_3_p_interact;
char mccchannel_12_analyzer_2_array_crystal_array_3_mask_string[16384];
char mccchannel_12_analyzer_2_array_crystal_array_3_mask_setting[16384];
MCNUM mccchannel_12_analyzer_2_array_crystal_array_3_number_of_activations;

/* Setting parameters for component 'channel_12_analyzer_2_array_crystal_array_4' [601]. */
char mccchannel_12_analyzer_2_array_crystal_array_4_material_string[16384];
MCNUM mccchannel_12_analyzer_2_array_crystal_array_4_priority;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_4_xwidth;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_4_yheight;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_4_zdepth;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_4_xwidth2;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_4_yheight2;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_4_visualize;
int mccchannel_12_analyzer_2_array_crystal_array_4_target_index;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_4_target_x;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_4_target_y;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_4_target_z;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_4_focus_aw;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_4_focus_ah;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_4_focus_xw;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_4_focus_xh;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_4_focus_r;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_4_p_interact;
char mccchannel_12_analyzer_2_array_crystal_array_4_mask_string[16384];
char mccchannel_12_analyzer_2_array_crystal_array_4_mask_setting[16384];
MCNUM mccchannel_12_analyzer_2_array_crystal_array_4_number_of_activations;

/* Setting parameters for component 'channel_12_analyzer_2_array_crystal_array_5' [602]. */
char mccchannel_12_analyzer_2_array_crystal_array_5_material_string[16384];
MCNUM mccchannel_12_analyzer_2_array_crystal_array_5_priority;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_5_xwidth;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_5_yheight;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_5_zdepth;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_5_xwidth2;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_5_yheight2;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_5_visualize;
int mccchannel_12_analyzer_2_array_crystal_array_5_target_index;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_5_target_x;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_5_target_y;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_5_target_z;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_5_focus_aw;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_5_focus_ah;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_5_focus_xw;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_5_focus_xh;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_5_focus_r;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_5_p_interact;
char mccchannel_12_analyzer_2_array_crystal_array_5_mask_string[16384];
char mccchannel_12_analyzer_2_array_crystal_array_5_mask_setting[16384];
MCNUM mccchannel_12_analyzer_2_array_crystal_array_5_number_of_activations;

/* Setting parameters for component 'channel_12_analyzer_2_array_crystal_array_6' [603]. */
char mccchannel_12_analyzer_2_array_crystal_array_6_material_string[16384];
MCNUM mccchannel_12_analyzer_2_array_crystal_array_6_priority;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_6_xwidth;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_6_yheight;
MCNUM mccchannel_12_analyzer_2_array_crystal_array_6_zdepth;
MCNUM mccchannel_12_an