
# Copyright 2013 Cisco Systems, Inc.
# 
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
# 
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""
This is an auto-generated module.
It contains independent classes for all Managed Objects and its respective attributes.
"""

from UcsBase import ManagedObject

class MacpoolPool(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"MacpoolPool")

	@staticmethod
	def ClassId():
		return "macpoolPool"

	ASSIGNED = "Assigned"
	ASSIGNMENT_ORDER = "AssignmentOrder"
	DESCR = "Descr"
	DN = "Dn"
	NAME = "Name"
	POLICY_LEVEL = "PolicyLevel"
	POLICY_OWNER = "PolicyOwner"
	RN = "Rn"
	SIZE = "Size"
	STATUS = "Status"

	CONST_ASSIGNMENT_ORDER_DEFAULT = "default"
	CONST_ASSIGNMENT_ORDER_SEQUENTIAL = "sequential"
	CONST_INT_ID_NONE = "none"
	CONST_POLICY_OWNER_LOCAL = "local"
	CONST_POLICY_OWNER_PENDING_POLICY = "pending-policy"
	CONST_POLICY_OWNER_POLICY = "policy"

class SwFcMon(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"SwFcMon")

	@staticmethod
	def ClassId():
		return "swFcMon"

	ADMIN_STATE = "AdminState"
	DN = "Dn"
	HAS_LAST_DEST = "HasLastDest"
	LIFE_CYCLE = "LifeCycle"
	NAME = "Name"
	PEER_DN = "PeerDn"
	RN = "Rn"
	SESSION = "Session"
	STATUS = "Status"
	SWITCH_ID = "SwitchId"
	TRANSPORT = "Transport"
	TYPE = "Type"

	CONST_ADMIN_STATE_DISABLED = "disabled"
	CONST_ADMIN_STATE_ENABLED = "enabled"
	CONST_FSM_PREV_DEPLOY_BEGIN = "DeployBegin"
	CONST_FSM_PREV_DEPLOY_FAIL = "DeployFail"
	CONST_FSM_PREV_DEPLOY_SUCCESS = "DeploySuccess"
	CONST_FSM_PREV_DEPLOY_UPDATE_FC_MON = "DeployUpdateFcMon"
	CONST_FSM_PREV_NOP = "nop"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_2FA_AUTH_RETRY = "ERR-2fa-auth-retry"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_ACTIVATE_FAILED = "ERR-ACTIVATE-failed"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_ACTIVATE_IN_PROGRESS = "ERR-ACTIVATE-in-progress"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_ACTIVATE_RETRY = "ERR-ACTIVATE-retry"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_BIOS_TOKENS_OLD_BIOS = "ERR-BIOS-TOKENS-OLD-BIOS"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_BIOS_TOKENS_OLD_CIMC = "ERR-BIOS-TOKENS-OLD-CIMC"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_BIOS_NETWORK_BOOT_ORDER_NOT_FOUND = "ERR-BIOS-network-boot-order-not-found"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_BOARDCTRLUPDATE_IGNORE = "ERR-BOARDCTRLUPDATE-ignore"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DIAG_CANCELLED = "ERR-DIAG-cancelled"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DIAG_FSM_RESTARTED = "ERR-DIAG-fsm-restarted"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DIAG_TEST_FAILED = "ERR-DIAG-test-failed"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DNLD_AUTHENTICATION_FAILURE = "ERR-DNLD-authentication-failure"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DNLD_HOSTKEY_MISMATCH = "ERR-DNLD-hostkey-mismatch"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DNLD_INVALID_IMAGE = "ERR-DNLD-invalid-image"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DNLD_NO_FILE = "ERR-DNLD-no-file"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DNLD_NO_SPACE = "ERR-DNLD-no-space"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DNS_DELETE_ERROR = "ERR-DNS-delete-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DNS_GET_ERROR = "ERR-DNS-get-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DNS_SET_ERROR = "ERR-DNS-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DIAGNOSTICS_IN_PROGRESS = "ERR-Diagnostics-in-progress"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DIAGNOSTICS_MEMTEST_IN_PROGRESS = "ERR-Diagnostics-memtest-in-progress"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DIAGNOSTICS_NETWORK_IN_PROGRESS = "ERR-Diagnostics-network-in-progress"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_FILTER_ILLEGAL_FORMAT = "ERR-FILTER-illegal-format"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_FSM_NO_SUCH_STATE = "ERR-FSM-no-such-state"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_HOST_FRU_IDENTITY_MISMATCH = "ERR-HOST-fru-identity-mismatch"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_HTTP_SET_ERROR = "ERR-HTTP-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_HTTPS_SET_ERROR = "ERR-HTTPS-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_IBMC_ANALYZE_RESULTS = "ERR-IBMC-analyze-results"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_IBMC_CONNECT_ERROR = "ERR-IBMC-connect-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_IBMC_FRU_RETRIEVAL_ERROR = "ERR-IBMC-fru-retrieval-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_IBMC_INVALID_END_POINT_CONFIG = "ERR-IBMC-invalid-end-point-config"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_IBMC_RESULTS_NOT_READY = "ERR-IBMC-results-not-ready"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MAX_SUBSCRIPTIONS_ALLOWED_ERROR = "ERR-MAX-subscriptions-allowed-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_CONFIG_CHILD_OBJECT_CANT_BE_CONFIGURED = "ERR-MO-CONFIG-child-object-cant-be-configured"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_META_NO_SUCH_OBJECT_CLASS = "ERR-MO-META-no-such-object-class"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_PROPERTY_NO_SUCH_PROPERTY = "ERR-MO-PROPERTY-no-such-property"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_PROPERTY_VALUE_OUT_OF_RANGE = "ERR-MO-PROPERTY-value-out-of-range"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_ACCESS_DENIED = "ERR-MO-access-denied"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_DELETION_RULE_VIOLATION = "ERR-MO-deletion-rule-violation"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_DUPLICATE_OBJECT = "ERR-MO-duplicate-object"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_ILLEGAL_CONTAINMENT = "ERR-MO-illegal-containment"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_ILLEGAL_CREATION = "ERR-MO-illegal-creation"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_ILLEGAL_ITERATOR_STATE = "ERR-MO-illegal-iterator-state"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_ILLEGAL_OBJECT_LIFECYCLE_TRANSITION = "ERR-MO-illegal-object-lifecycle-transition"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_NAMING_RULE_VIOLATION = "ERR-MO-naming-rule-violation"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_OBJECT_NOT_FOUND = "ERR-MO-object-not-found"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_RESOURCE_ALLOCATION = "ERR-MO-resource-allocation"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_NTP_DELETE_ERROR = "ERR-NTP-delete-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_NTP_GET_ERROR = "ERR-NTP-get-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_NTP_SET_ERROR = "ERR-NTP-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_POWER_CAP_UNSUPPORTED = "ERR-POWER-CAP-UNSUPPORTED"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_SERVER_MIS_CONNECT = "ERR-SERVER-mis-connect"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_SWITCH_INVALID_IF_CONFIG = "ERR-SWITCH-invalid-if-config"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_TOKEN_REQUEST_DENIED = "ERR-TOKEN-request-denied"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_UNABLE_TO_FETCH_BIOS_SETTINGS = "ERR-UNABLE-TO-FETCH-BIOS-SETTINGS"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_UPDATE_FAILED = "ERR-UPDATE-failed"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_UPDATE_IN_PROGRESS = "ERR-UPDATE-in-progress"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_UPDATE_RETRY = "ERR-UPDATE-retry"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_AAA_CONFIG_MODIFY_ERROR = "ERR-aaa-config-modify-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_ACCT_REALM_SET_ERROR = "ERR-acct-realm-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_ADMIN_PASSWD_SET = "ERR-admin-passwd-set"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_AUTH_ISSUE = "ERR-auth-issue"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_AUTH_REALM_GET_ERROR = "ERR-auth-realm-get-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_AUTH_REALM_SET_ERROR = "ERR-auth-realm-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_AUTHENTICATION = "ERR-authentication"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_AUTHORIZATION_REQUIRED = "ERR-authorization-required"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_CLI_SESSION_LIMIT_REACHED = "ERR-cli-session-limit-reached"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_CREATE_KEYRING = "ERR-create-keyring"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_CREATE_LOCALE = "ERR-create-locale"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_CREATE_ROLE = "ERR-create-role"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_CREATE_USER = "ERR-create-user"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DELETE_LOCALE = "ERR-delete-locale"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DELETE_ROLE = "ERR-delete-role"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DELETE_SESSION = "ERR-delete-session"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DELETE_USER = "ERR-delete-user"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_EFI_DIAGNOSTICS_IN_PROGRESS = "ERR-efi-Diagnostics--in-progress"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_ENABLE_MGMT_CONN = "ERR-enable-mgmt-conn"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_EP_SET_ERROR = "ERR-ep-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_GET_MAX_HTTP_USER_SESSIONS = "ERR-get-max-http-user-sessions"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_HTTP_INITIALIZING = "ERR-http-initializing"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_INSUFFICIENTLY_EQUIPPED = "ERR-insufficiently-equipped"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_INTERNAL_ERROR = "ERR-internal-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_LDAP_DELETE_ERROR = "ERR-ldap-delete-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_LDAP_GET_ERROR = "ERR-ldap-get-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_LDAP_GROUP_MODIFY_ERROR = "ERR-ldap-group-modify-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_LDAP_GROUP_SET_ERROR = "ERR-ldap-group-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_LDAP_SET_ERROR = "ERR-ldap-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_LOCALE_SET_ERROR = "ERR-locale-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MAX_USERID_SESSIONS_REACHED = "ERR-max-userid-sessions-reached"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MISSING_METHOD = "ERR-missing-method"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MODIFY_LOCALE = "ERR-modify-locale"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MODIFY_ROLE = "ERR-modify-role"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MODIFY_USER = "ERR-modify-user"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MODIFY_USER_LOCALE = "ERR-modify-user-locale"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MODIFY_USER_ROLE = "ERR-modify-user-role"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_PROVIDER_GROUP_MODIFY_ERROR = "ERR-provider-group-modify-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_PROVIDER_GROUP_SET_ERROR = "ERR-provider-group-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_RADIUS_GET_ERROR = "ERR-radius-get-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_RADIUS_GLOBAL_SET_ERROR = "ERR-radius-global-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_RADIUS_GROUP_SET_ERROR = "ERR-radius-group-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_RADIUS_SET_ERROR = "ERR-radius-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_REQUEST_TIMEOUT = "ERR-request-timeout"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_RESET_ADAPTER = "ERR-reset-adapter"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_ROLE_SET_ERROR = "ERR-role-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_SECONDARY_NODE = "ERR-secondary-node"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_SERVICE_NOT_READY = "ERR-service-not-ready"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_SESSION_CACHE_FULL = "ERR-session-cache-full"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_SESSION_NOT_FOUND = "ERR-session-not-found"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_SET_NETWORK = "ERR-set-network"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_SET_PASSWORD_STRENGTH_CHECK = "ERR-set-password-strength-check"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_SET_PORT_CHANNEL = "ERR-set-port-channel"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_STORE_PRE_LOGIN_BANNER_MSG = "ERR-store-pre-login-banner-msg"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_TACACS_ENABLE_ERROR = "ERR-tacacs-enable-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_TACACS_GLOBAL_SET_ERROR = "ERR-tacacs-global-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_TACACS_GROUP_SET_ERROR = "ERR-tacacs-group-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_TACACS_PLUS_GET_ERROR = "ERR-tacacs-plus-get-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_TACACS_SET_ERROR = "ERR-tacacs-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_TEST_ERROR_1 = "ERR-test-error-1"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_TEST_ERROR_2 = "ERR-test-error-2"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_TIMEZONE_SET_ERROR = "ERR-timezone-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_USER_ACCOUNT_EXPIRED = "ERR-user-account-expired"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_USER_SET_ERROR = "ERR-user-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_XML_PARSE_ERROR = "ERR-xml-parse-error"
	CONST_FSM_RMT_INV_ERR_CODE_NONE = "none"
	CONST_FSM_STAMP_NEVER = "never"
	CONST_FSM_STATUS_DEPLOY_BEGIN = "DeployBegin"
	CONST_FSM_STATUS_DEPLOY_FAIL = "DeployFail"
	CONST_FSM_STATUS_DEPLOY_SUCCESS = "DeploySuccess"
	CONST_FSM_STATUS_DEPLOY_UPDATE_FC_MON = "DeployUpdateFcMon"
	CONST_FSM_STATUS_NOP = "nop"
	CONST_HAS_LAST_DEST_FALSE = "false"
	CONST_HAS_LAST_DEST_NO = "no"
	CONST_HAS_LAST_DEST_TRUE = "true"
	CONST_HAS_LAST_DEST_YES = "yes"
	CONST_LIFE_CYCLE_DELETED = "deleted"
	CONST_LIFE_CYCLE_NEW = "new"
	CONST_LIFE_CYCLE_NORMAL = "normal"
	CONST_SWITCH_ID_A = "A"
	CONST_SWITCH_ID_B = "B"
	CONST_SWITCH_ID_NONE = "NONE"

class EquipmentFanStatsHist(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"EquipmentFanStatsHist")

	@staticmethod
	def ClassId():
		return "equipmentFanStatsHist"

	DN = "Dn"
	ID = "Id"
	MOST_RECENT = "MostRecent"
	RN = "Rn"
	SPEED = "Speed"
	SPEED_AVG = "SpeedAvg"
	SPEED_MAX = "SpeedMax"
	SPEED_MIN = "SpeedMin"
	STATUS = "Status"
	SUSPECT = "Suspect"
	THRESHOLDED = "Thresholded"
	TIME_COLLECTED = "TimeCollected"

	CONST_MOST_RECENT_FALSE = "false"
	CONST_MOST_RECENT_NO = "no"
	CONST_MOST_RECENT_TRUE = "true"
	CONST_MOST_RECENT_YES = "yes"
	CONST_SUSPECT_FALSE = "false"
	CONST_SUSPECT_NO = "no"
	CONST_SUSPECT_TRUE = "true"
	CONST_SUSPECT_YES = "yes"

class EquipmentBeaconLed(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"EquipmentBeaconLed")

	@staticmethod
	def ClassId():
		return "equipmentBeaconLed"

	ADMIN_STATE = "AdminState"
	COLOR = "Color"
	DN = "Dn"
	ID = "Id"
	NAME = "Name"
	OPER_STATE = "OperState"
	RN = "Rn"
	STATUS = "Status"

	CONST_ADMIN_STATE_BLINKING = "blinking"
	CONST_ADMIN_STATE_ETH = "eth"
	CONST_ADMIN_STATE_FC = "fc"
	CONST_ADMIN_STATE_OFF = "off"
	CONST_ADMIN_STATE_ON = "on"
	CONST_COLOR_AMBER = "amber"
	CONST_COLOR_BLUE = "blue"
	CONST_COLOR_GREEN = "green"
	CONST_COLOR_RED = "red"
	CONST_COLOR_UNKNOWN = "unknown"
	CONST_FSM_PREV_ILLUMINATE_BEGIN = "IlluminateBegin"
	CONST_FSM_PREV_ILLUMINATE_EXECUTE_A = "IlluminateExecuteA"
	CONST_FSM_PREV_ILLUMINATE_EXECUTE_B = "IlluminateExecuteB"
	CONST_FSM_PREV_ILLUMINATE_FAIL = "IlluminateFail"
	CONST_FSM_PREV_ILLUMINATE_SUCCESS = "IlluminateSuccess"
	CONST_FSM_PREV_NOP = "nop"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_2FA_AUTH_RETRY = "ERR-2fa-auth-retry"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_ACTIVATE_FAILED = "ERR-ACTIVATE-failed"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_ACTIVATE_IN_PROGRESS = "ERR-ACTIVATE-in-progress"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_ACTIVATE_RETRY = "ERR-ACTIVATE-retry"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_BIOS_TOKENS_OLD_BIOS = "ERR-BIOS-TOKENS-OLD-BIOS"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_BIOS_TOKENS_OLD_CIMC = "ERR-BIOS-TOKENS-OLD-CIMC"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_BIOS_NETWORK_BOOT_ORDER_NOT_FOUND = "ERR-BIOS-network-boot-order-not-found"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_BOARDCTRLUPDATE_IGNORE = "ERR-BOARDCTRLUPDATE-ignore"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DIAG_CANCELLED = "ERR-DIAG-cancelled"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DIAG_FSM_RESTARTED = "ERR-DIAG-fsm-restarted"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DIAG_TEST_FAILED = "ERR-DIAG-test-failed"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DNLD_AUTHENTICATION_FAILURE = "ERR-DNLD-authentication-failure"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DNLD_HOSTKEY_MISMATCH = "ERR-DNLD-hostkey-mismatch"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DNLD_INVALID_IMAGE = "ERR-DNLD-invalid-image"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DNLD_NO_FILE = "ERR-DNLD-no-file"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DNLD_NO_SPACE = "ERR-DNLD-no-space"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DNS_DELETE_ERROR = "ERR-DNS-delete-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DNS_GET_ERROR = "ERR-DNS-get-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DNS_SET_ERROR = "ERR-DNS-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DIAGNOSTICS_IN_PROGRESS = "ERR-Diagnostics-in-progress"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DIAGNOSTICS_MEMTEST_IN_PROGRESS = "ERR-Diagnostics-memtest-in-progress"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DIAGNOSTICS_NETWORK_IN_PROGRESS = "ERR-Diagnostics-network-in-progress"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_FILTER_ILLEGAL_FORMAT = "ERR-FILTER-illegal-format"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_FSM_NO_SUCH_STATE = "ERR-FSM-no-such-state"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_HOST_FRU_IDENTITY_MISMATCH = "ERR-HOST-fru-identity-mismatch"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_HTTP_SET_ERROR = "ERR-HTTP-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_HTTPS_SET_ERROR = "ERR-HTTPS-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_IBMC_ANALYZE_RESULTS = "ERR-IBMC-analyze-results"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_IBMC_CONNECT_ERROR = "ERR-IBMC-connect-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_IBMC_FRU_RETRIEVAL_ERROR = "ERR-IBMC-fru-retrieval-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_IBMC_INVALID_END_POINT_CONFIG = "ERR-IBMC-invalid-end-point-config"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_IBMC_RESULTS_NOT_READY = "ERR-IBMC-results-not-ready"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MAX_SUBSCRIPTIONS_ALLOWED_ERROR = "ERR-MAX-subscriptions-allowed-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_CONFIG_CHILD_OBJECT_CANT_BE_CONFIGURED = "ERR-MO-CONFIG-child-object-cant-be-configured"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_META_NO_SUCH_OBJECT_CLASS = "ERR-MO-META-no-such-object-class"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_PROPERTY_NO_SUCH_PROPERTY = "ERR-MO-PROPERTY-no-such-property"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_PROPERTY_VALUE_OUT_OF_RANGE = "ERR-MO-PROPERTY-value-out-of-range"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_ACCESS_DENIED = "ERR-MO-access-denied"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_DELETION_RULE_VIOLATION = "ERR-MO-deletion-rule-violation"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_DUPLICATE_OBJECT = "ERR-MO-duplicate-object"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_ILLEGAL_CONTAINMENT = "ERR-MO-illegal-containment"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_ILLEGAL_CREATION = "ERR-MO-illegal-creation"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_ILLEGAL_ITERATOR_STATE = "ERR-MO-illegal-iterator-state"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_ILLEGAL_OBJECT_LIFECYCLE_TRANSITION = "ERR-MO-illegal-object-lifecycle-transition"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_NAMING_RULE_VIOLATION = "ERR-MO-naming-rule-violation"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_OBJECT_NOT_FOUND = "ERR-MO-object-not-found"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_RESOURCE_ALLOCATION = "ERR-MO-resource-allocation"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_NTP_DELETE_ERROR = "ERR-NTP-delete-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_NTP_GET_ERROR = "ERR-NTP-get-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_NTP_SET_ERROR = "ERR-NTP-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_POWER_CAP_UNSUPPORTED = "ERR-POWER-CAP-UNSUPPORTED"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_SERVER_MIS_CONNECT = "ERR-SERVER-mis-connect"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_SWITCH_INVALID_IF_CONFIG = "ERR-SWITCH-invalid-if-config"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_TOKEN_REQUEST_DENIED = "ERR-TOKEN-request-denied"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_UNABLE_TO_FETCH_BIOS_SETTINGS = "ERR-UNABLE-TO-FETCH-BIOS-SETTINGS"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_UPDATE_FAILED = "ERR-UPDATE-failed"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_UPDATE_IN_PROGRESS = "ERR-UPDATE-in-progress"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_UPDATE_RETRY = "ERR-UPDATE-retry"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_AAA_CONFIG_MODIFY_ERROR = "ERR-aaa-config-modify-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_ACCT_REALM_SET_ERROR = "ERR-acct-realm-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_ADMIN_PASSWD_SET = "ERR-admin-passwd-set"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_AUTH_ISSUE = "ERR-auth-issue"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_AUTH_REALM_GET_ERROR = "ERR-auth-realm-get-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_AUTH_REALM_SET_ERROR = "ERR-auth-realm-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_AUTHENTICATION = "ERR-authentication"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_AUTHORIZATION_REQUIRED = "ERR-authorization-required"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_CLI_SESSION_LIMIT_REACHED = "ERR-cli-session-limit-reached"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_CREATE_KEYRING = "ERR-create-keyring"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_CREATE_LOCALE = "ERR-create-locale"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_CREATE_ROLE = "ERR-create-role"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_CREATE_USER = "ERR-create-user"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DELETE_LOCALE = "ERR-delete-locale"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DELETE_ROLE = "ERR-delete-role"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DELETE_SESSION = "ERR-delete-session"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DELETE_USER = "ERR-delete-user"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_EFI_DIAGNOSTICS_IN_PROGRESS = "ERR-efi-Diagnostics--in-progress"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_ENABLE_MGMT_CONN = "ERR-enable-mgmt-conn"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_EP_SET_ERROR = "ERR-ep-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_GET_MAX_HTTP_USER_SESSIONS = "ERR-get-max-http-user-sessions"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_HTTP_INITIALIZING = "ERR-http-initializing"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_INSUFFICIENTLY_EQUIPPED = "ERR-insufficiently-equipped"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_INTERNAL_ERROR = "ERR-internal-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_LDAP_DELETE_ERROR = "ERR-ldap-delete-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_LDAP_GET_ERROR = "ERR-ldap-get-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_LDAP_GROUP_MODIFY_ERROR = "ERR-ldap-group-modify-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_LDAP_GROUP_SET_ERROR = "ERR-ldap-group-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_LDAP_SET_ERROR = "ERR-ldap-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_LOCALE_SET_ERROR = "ERR-locale-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MAX_USERID_SESSIONS_REACHED = "ERR-max-userid-sessions-reached"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MISSING_METHOD = "ERR-missing-method"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MODIFY_LOCALE = "ERR-modify-locale"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MODIFY_ROLE = "ERR-modify-role"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MODIFY_USER = "ERR-modify-user"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MODIFY_USER_LOCALE = "ERR-modify-user-locale"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MODIFY_USER_ROLE = "ERR-modify-user-role"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_PROVIDER_GROUP_MODIFY_ERROR = "ERR-provider-group-modify-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_PROVIDER_GROUP_SET_ERROR = "ERR-provider-group-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_RADIUS_GET_ERROR = "ERR-radius-get-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_RADIUS_GLOBAL_SET_ERROR = "ERR-radius-global-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_RADIUS_GROUP_SET_ERROR = "ERR-radius-group-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_RADIUS_SET_ERROR = "ERR-radius-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_REQUEST_TIMEOUT = "ERR-request-timeout"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_RESET_ADAPTER = "ERR-reset-adapter"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_ROLE_SET_ERROR = "ERR-role-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_SECONDARY_NODE = "ERR-secondary-node"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_SERVICE_NOT_READY = "ERR-service-not-ready"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_SESSION_CACHE_FULL = "ERR-session-cache-full"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_SESSION_NOT_FOUND = "ERR-session-not-found"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_SET_NETWORK = "ERR-set-network"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_SET_PASSWORD_STRENGTH_CHECK = "ERR-set-password-strength-check"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_SET_PORT_CHANNEL = "ERR-set-port-channel"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_STORE_PRE_LOGIN_BANNER_MSG = "ERR-store-pre-login-banner-msg"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_TACACS_ENABLE_ERROR = "ERR-tacacs-enable-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_TACACS_GLOBAL_SET_ERROR = "ERR-tacacs-global-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_TACACS_GROUP_SET_ERROR = "ERR-tacacs-group-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_TACACS_PLUS_GET_ERROR = "ERR-tacacs-plus-get-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_TACACS_SET_ERROR = "ERR-tacacs-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_TEST_ERROR_1 = "ERR-test-error-1"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_TEST_ERROR_2 = "ERR-test-error-2"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_TIMEZONE_SET_ERROR = "ERR-timezone-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_USER_ACCOUNT_EXPIRED = "ERR-user-account-expired"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_USER_SET_ERROR = "ERR-user-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_XML_PARSE_ERROR = "ERR-xml-parse-error"
	CONST_FSM_RMT_INV_ERR_CODE_NONE = "none"
	CONST_FSM_STAMP_NEVER = "never"
	CONST_FSM_STATUS_ILLUMINATE_BEGIN = "IlluminateBegin"
	CONST_FSM_STATUS_ILLUMINATE_EXECUTE_A = "IlluminateExecuteA"
	CONST_FSM_STATUS_ILLUMINATE_EXECUTE_B = "IlluminateExecuteB"
	CONST_FSM_STATUS_ILLUMINATE_FAIL = "IlluminateFail"
	CONST_FSM_STATUS_ILLUMINATE_SUCCESS = "IlluminateSuccess"
	CONST_FSM_STATUS_NOP = "nop"
	CONST_OPER_STATE_BLINKING = "blinking"
	CONST_OPER_STATE_ETH = "eth"
	CONST_OPER_STATE_FC = "fc"
	CONST_OPER_STATE_OFF = "off"
	CONST_OPER_STATE_ON = "on"
	CONST_OPER_STATE_UNKNOWN = "unknown"

class SwFcMonFsmTask(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"SwFcMonFsmTask")

	@staticmethod
	def ClassId():
		return "swFcMonFsmTask"

	COMPLETION = "Completion"
	DN = "Dn"
	FLAGS = "Flags"
	ITEM = "Item"
	RN = "Rn"
	SEQ_ID = "SeqId"
	STATUS = "Status"

	CONST_COMPLETION_CANCELLED = "cancelled"
	CONST_COMPLETION_COMPLETED = "completed"
	CONST_COMPLETION_PROCESSING = "processing"
	CONST_COMPLETION_SCHEDULED = "scheduled"
	CONST_ITEM_DEPLOY = "Deploy"
	CONST_ITEM_NOP = "nop"

class DomainServerFeatureCont(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"DomainServerFeatureCont")

	@staticmethod
	def ClassId():
		return "domainServerFeatureCont"

	DN = "Dn"
	RN = "Rn"
	STATUS = "Status"


class VnicIPv4If(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"VnicIPv4If")

	@staticmethod
	def ClassId():
		return "vnicIPv4If"

	ADDR = "Addr"
	CONFIG_QUALIFIER = "ConfigQualifier"
	DN = "Dn"
	NAME = "Name"
	OPER_STATE = "OperState"
	OPER_VNET_DN = "OperVnetDn"
	OPER_VNET_NAME = "OperVnetName"
	OWNER = "Owner"
	RN = "Rn"
	STATUS = "Status"
	SWITCH_ID = "SwitchId"
	TYPE = "Type"
	VNET = "Vnet"

	CONST_OPER_STATE_DOWN = "down"
	CONST_OPER_STATE_FAILED = "failed"
	CONST_OPER_STATE_INDETERMINATE = "indeterminate"
	CONST_OPER_STATE_UP = "up"
	CONST_OWNER_CONN_POLICY = "conn_policy"
	CONST_OWNER_LOGICAL = "logical"
	CONST_OWNER_PHYSICAL = "physical"
	CONST_OWNER_POLICY = "policy"
	CONST_OWNER_UNKNOWN = "unknown"
	CONST_SWITCH_ID_A = "A"
	CONST_SWITCH_ID_B = "B"
	CONST_SWITCH_ID_NONE = "NONE"
	CONST_TYPE_ETHER = "ether"
	CONST_TYPE_FC = "fc"
	CONST_TYPE_IPC = "ipc"
	CONST_TYPE_SCSI = "scsi"
	CONST_TYPE_UNKNOWN = "unknown"

class SwatTrigger(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"SwatTrigger")

	@staticmethod
	def ClassId():
		return "swatTrigger"

	DN = "Dn"
	NAME = "Name"
	RN = "Rn"
	STATUS = "Status"
	TYPE = "Type"

	CONST_TYPE_AND = "AND"
	CONST_TYPE_OR = "OR"

class AdaptorCapSpec(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"AdaptorCapSpec")

	@staticmethod
	def ClassId():
		return "adaptorCapSpec"

	DN = "Dn"
	FW_VERSION_HI = "FwVersionHi"
	FW_VERSION_LO = "FwVersionLo"
	FW_VERSION_OPR = "FwVersionOpr"
	MAXIMUM = "Maximum"
	RN = "Rn"
	STATUS = "Status"
	TYPE = "Type"

	CONST_FW_VERSION_OPR_GT = "gt"
	CONST_FW_VERSION_OPR_LT = "lt"
	CONST_FW_VERSION_OPR_NONE = "none"
	CONST_FW_VERSION_OPR_RANGE = "range"
	CONST_MAXIMUM_UNSPECIFIED = "unspecified"
	CONST_TYPE_ETH_FLOW_MONITORING_NETFLOW = "eth-flow-monitoring-netflow"
	CONST_TYPE_FCOE = "fcoe"
	CONST_TYPE_NON_VIRTUALIZED_ETH_IF = "non-virtualized-eth-if"
	CONST_TYPE_NON_VIRTUALIZED_FC_IF = "non-virtualized-fc-if"
	CONST_TYPE_PATH_ENCAP_CONSOLIDATED = "path-encap-consolidated"
	CONST_TYPE_PATH_ENCAP_VIRTUAL = "path-encap-virtual"
	CONST_TYPE_PROTECTED_ETH_IF = "protected-eth-if"
	CONST_TYPE_PROTECTED_FC_IF = "protected-fc-if"
	CONST_TYPE_PROTECTED_FCOE = "protected-fcoe"
	CONST_TYPE_UPLINK_AGGREGATION = "uplink-aggregation"
	CONST_TYPE_VIRTUALIZED_ETH_IF = "virtualized-eth-if"
	CONST_TYPE_VIRTUALIZED_ETH_SRIOV = "virtualized-eth-sriov"
	CONST_TYPE_VIRTUALIZED_ETH_SRIOV_USNIC = "virtualized-eth-sriov-usnic"
	CONST_TYPE_VIRTUALIZED_ETH_VMQ = "virtualized-eth-vmq"
	CONST_TYPE_VIRTUALIZED_FC_IF = "virtualized-fc-if"
	CONST_TYPE_VIRTUALIZED_FC_SRIOV = "virtualized-fc-sriov"
	CONST_TYPE_VIRTUALIZED_SCSI_IF = "virtualized-scsi-if"

class FabricFlowMonExporterProfile(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"FabricFlowMonExporterProfile")

	@staticmethod
	def ClassId():
		return "fabricFlowMonExporterProfile"

	DESCR = "Descr"
	DN = "Dn"
	NAME = "Name"
	POLICY_LEVEL = "PolicyLevel"
	POLICY_OWNER = "PolicyOwner"
	RN = "Rn"
	STATUS = "Status"

	CONST_INT_ID_NONE = "none"
	CONST_POLICY_OWNER_LOCAL = "local"
	CONST_POLICY_OWNER_PENDING_POLICY = "pending-policy"
	CONST_POLICY_OWNER_POLICY = "policy"

class FabricEp(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"FabricEp")

	@staticmethod
	def ClassId():
		return "fabricEp"

	DN = "Dn"
	RN = "Rn"
	STATUS = "Status"


class OrgOrg(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"OrgOrg")

	@staticmethod
	def ClassId():
		return "orgOrg"

	DESCR = "Descr"
	DN = "Dn"
	LEVEL = "Level"
	NAME = "Name"
	PERM_ACCESS = "PermAccess"
	RN = "Rn"
	STATUS = "Status"

	CONST_LEVEL_1 = "1"
	CONST_LEVEL_2 = "2"
	CONST_LEVEL_3 = "3"
	CONST_LEVEL_4 = "4"
	CONST_LEVEL_5 = "5"
	CONST_LEVEL_ROOT = "root"
	CONST_PERM_ACCESS_FALSE = "false"
	CONST_PERM_ACCESS_NO = "no"
	CONST_PERM_ACCESS_TRUE = "true"
	CONST_PERM_ACCESS_YES = "yes"

class FabricSanPinGroup(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"FabricSanPinGroup")

	@staticmethod
	def ClassId():
		return "fabricSanPinGroup"

	DESCR = "Descr"
	DN = "Dn"
	NAME = "Name"
	POLICY_LEVEL = "PolicyLevel"
	POLICY_OWNER = "PolicyOwner"
	RN = "Rn"
	SIZE = "Size"
	STATUS = "Status"

	CONST_INT_ID_NONE = "none"
	CONST_POLICY_OWNER_LOCAL = "local"
	CONST_POLICY_OWNER_PENDING_POLICY = "pending-policy"
	CONST_POLICY_OWNER_POLICY = "policy"

class EquipmentFexEnvStats(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"EquipmentFexEnvStats")

	@staticmethod
	def ClassId():
		return "equipmentFexEnvStats"

	DIE1 = "Die1"
	DIE1_AVG = "Die1Avg"
	DIE1_MAX = "Die1Max"
	DIE1_MIN = "Die1Min"
	DN = "Dn"
	INLET = "Inlet"
	INLET1 = "Inlet1"
	INLET1_AVG = "Inlet1Avg"
	INLET1_MAX = "Inlet1Max"
	INLET1_MIN = "Inlet1Min"
	INLET_AVG = "InletAvg"
	INLET_MAX = "InletMax"
	INLET_MIN = "InletMin"
	INPUT_STATUS = "InputStatus"
	INTERVALS = "Intervals"
	OUTLET1 = "Outlet1"
	OUTLET1_AVG = "Outlet1Avg"
	OUTLET1_MAX = "Outlet1Max"
	OUTLET1_MIN = "Outlet1Min"
	OUTLET2 = "Outlet2"
	OUTLET2_AVG = "Outlet2Avg"
	OUTLET2_MAX = "Outlet2Max"
	OUTLET2_MIN = "Outlet2Min"
	RN = "Rn"
	STATUS = "Status"
	SUSPECT = "Suspect"
	THRESHOLDED = "Thresholded"
	TIME_COLLECTED = "TimeCollected"
	UPDATE = "Update"

	CONST_DIE1_N_A = "N/A"
	CONST_DIE1_AVG_N_A = "N/A"
	CONST_DIE1_MAX_N_A = "N/A"
	CONST_DIE1_MIN_N_A = "N/A"
	CONST_INLET_N_A = "N/A"
	CONST_INLET1_N_A = "N/A"
	CONST_INLET1_AVG_N_A = "N/A"
	CONST_INLET1_MAX_N_A = "N/A"
	CONST_INLET1_MIN_N_A = "N/A"
	CONST_INLET_AVG_N_A = "N/A"
	CONST_INLET_MAX_N_A = "N/A"
	CONST_INLET_MIN_N_A = "N/A"
	CONST_OUTLET1_N_A = "N/A"
	CONST_OUTLET1_AVG_N_A = "N/A"
	CONST_OUTLET1_MAX_N_A = "N/A"
	CONST_OUTLET1_MIN_N_A = "N/A"
	CONST_OUTLET2_N_A = "N/A"
	CONST_OUTLET2_AVG_N_A = "N/A"
	CONST_OUTLET2_MAX_N_A = "N/A"
	CONST_OUTLET2_MIN_N_A = "N/A"
	CONST_SUSPECT_FALSE = "false"
	CONST_SUSPECT_NO = "no"
	CONST_SUSPECT_TRUE = "true"
	CONST_SUSPECT_YES = "yes"

class BiosVfDirectCacheAccess(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"BiosVfDirectCacheAccess")

	@staticmethod
	def ClassId():
		return "biosVfDirectCacheAccess"

	DN = "Dn"
	RN = "Rn"
	STATUS = "Status"
	VP_DIRECT_CACHE_ACCESS = "VpDirectCacheAccess"

	CONST_VP_DIRECT_CACHE_ACCESS_DISABLED = "disabled"
	CONST_VP_DIRECT_CACHE_ACCESS_ENABLED = "enabled"
	CONST_VP_DIRECT_CACHE_ACCESS_PLATFORM_DEFAULT = "platform-default"
	CONST_VP_DIRECT_CACHE_ACCESS_PLATFORM_RECOMMENDED = "platform-recommended"

class DhcpAcquired(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"DhcpAcquired")

	@staticmethod
	def ClassId():
		return "dhcpAcquired"

	ACQTS = "Acqts"
	COOKIE = "Cookie"
	DN = "Dn"
	ENDS = "Ends"
	IP = "Ip"
	MAC = "Mac"
	RN = "Rn"
	STATUS = "Status"
	SYS_ID = "SysId"


class ApeSANBoot(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"ApeSANBoot")

	@staticmethod
	def ClassId():
		return "apeSANBoot"

	DN = "Dn"
	HOSTNAME = "Hostname"
	IS_HOST_AGENT_PRESENT = "IsHostAgentPresent"
	KERNEL_NAME = "KernelName"
	KERNEL_RELEASE = "KernelRelease"
	KERNEL_VERSION = "KernelVersion"
	NAME = "Name"
	RN = "Rn"
	STATUS = "Status"
	TARGET_LUN = "TargetLun"
	TARGET_WWN = "TargetWWN"
	TYPE = "Type"

	CONST_IS_HOST_AGENT_PRESENT_FALSE = "false"
	CONST_IS_HOST_AGENT_PRESENT_NO = "no"
	CONST_IS_HOST_AGENT_PRESENT_TRUE = "true"
	CONST_IS_HOST_AGENT_PRESENT_YES = "yes"
	CONST_TYPE_LINUX = "Linux"
	CONST_TYPE_PNU_OS = "PnuOS"
	CONST_TYPE_SOLARIS = "Solaris"
	CONST_TYPE_VMWARE_ESX = "VMWareESX"
	CONST_TYPE_WINDOWS = "Windows"
	CONST_TYPE_UNSPECIFIED = "unspecified"

class AdaptorEthOffloadProfile(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"AdaptorEthOffloadProfile")

	@staticmethod
	def ClassId():
		return "adaptorEthOffloadProfile"

	DN = "Dn"
	LARGE_RECEIVE = "LargeReceive"
	RN = "Rn"
	STATUS = "Status"
	TCP_RX_CHECKSUM = "TcpRxChecksum"
	TCP_SEGMENT = "TcpSegment"
	TCP_TX_CHECKSUM = "TcpTxChecksum"

	CONST_LARGE_RECEIVE_DISABLED = "disabled"
	CONST_LARGE_RECEIVE_ENABLED = "enabled"
	CONST_TCP_RX_CHECKSUM_DISABLED = "disabled"
	CONST_TCP_RX_CHECKSUM_ENABLED = "enabled"
	CONST_TCP_SEGMENT_DISABLED = "disabled"
	CONST_TCP_SEGMENT_ENABLED = "enabled"
	CONST_TCP_TX_CHECKSUM_DISABLED = "disabled"
	CONST_TCP_TX_CHECKSUM_ENABLED = "enabled"

class ComputePool(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"ComputePool")

	@staticmethod
	def ClassId():
		return "computePool"

	ASSIGNED = "Assigned"
	ASSIGNMENT_ORDER = "AssignmentOrder"
	DESCR = "Descr"
	DN = "Dn"
	NAME = "Name"
	POLICY_LEVEL = "PolicyLevel"
	POLICY_OWNER = "PolicyOwner"
	RN = "Rn"
	SIZE = "Size"
	STATUS = "Status"

	CONST_ASSIGNMENT_ORDER_DEFAULT = "default"
	CONST_ASSIGNMENT_ORDER_SEQUENTIAL = "sequential"
	CONST_INT_ID_NONE = "none"
	CONST_POLICY_OWNER_LOCAL = "local"
	CONST_POLICY_OWNER_PENDING_POLICY = "pending-policy"
	CONST_POLICY_OWNER_POLICY = "policy"

class ExtmgmtMiiStatus(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"ExtmgmtMiiStatus")

	@staticmethod
	def ClassId():
		return "extmgmtMiiStatus"

	DN = "Dn"
	MAX_RETRY_COUNT = "MaxRetryCount"
	RETRY_INTERVAL = "RetryInterval"
	RN = "Rn"
	STATUS = "Status"


class IppoolPooled(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"IppoolPooled")

	@staticmethod
	def ClassId():
		return "ippoolPooled"

	ASSIGNED = "Assigned"
	ASSIGNED_TO_DN = "AssignedToDn"
	DEF_GW = "DefGw"
	DN = "Dn"
	ID = "Id"
	POOLABLE_DN = "PoolableDn"
	PREV_ASSIGNED_TO_DN = "PrevAssignedToDn"
	PRIM_DNS = "PrimDns"
	RN = "Rn"
	SEC_DNS = "SecDns"
	STATUS = "Status"
	SUBNET = "Subnet"

	CONST_ASSIGNED_FALSE = "false"
	CONST_ASSIGNED_NO = "no"
	CONST_ASSIGNED_TRUE = "true"
	CONST_ASSIGNED_YES = "yes"

class FirmwareImageFsmStage(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"FirmwareImageFsmStage")

	@staticmethod
	def ClassId():
		return "firmwareImageFsmStage"

	DESCR = "Descr"
	DN = "Dn"
	LAST_UPDATE_TIME = "LastUpdateTime"
	NAME = "Name"
	ORDER = "Order"
	RETRY = "Retry"
	RN = "Rn"
	STAGE_STATUS = "StageStatus"
	STATUS = "Status"

	CONST_LAST_UPDATE_TIME_ = ""
	CONST_NAME_DELETE_BEGIN = "DeleteBegin"
	CONST_NAME_DELETE_FAIL = "DeleteFail"
	CONST_NAME_DELETE_LOCAL = "DeleteLocal"
	CONST_NAME_DELETE_REMOTE = "DeleteRemote"
	CONST_NAME_DELETE_SUCCESS = "DeleteSuccess"
	CONST_NAME_NOP = "nop"
	CONST_STAGE_STATUS_FAIL = "fail"
	CONST_STAGE_STATUS_IN_PROGRESS = "inProgress"
	CONST_STAGE_STATUS_NOP = "nop"
	CONST_STAGE_STATUS_PENDING = "pending"
	CONST_STAGE_STATUS_SKIP = "skip"
	CONST_STAGE_STATUS_SUCCESS = "success"
	CONST_STAGE_STATUS_THROTTLED = "throttled"

class EquipmentChassisStatsHist(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"EquipmentChassisStatsHist")

	@staticmethod
	def ClassId():
		return "equipmentChassisStatsHist"

	DN = "Dn"
	ID = "Id"
	INPUT_POWER = "InputPower"
	INPUT_POWER_AVG = "InputPowerAvg"
	INPUT_POWER_MAX = "InputPowerMax"
	INPUT_POWER_MIN = "InputPowerMin"
	MOST_RECENT = "MostRecent"
	OUTPUT_POWER = "OutputPower"
	OUTPUT_POWER_AVG = "OutputPowerAvg"
	OUTPUT_POWER_MAX = "OutputPowerMax"
	OUTPUT_POWER_MIN = "OutputPowerMin"
	RN = "Rn"
	STATUS = "Status"
	SUSPECT = "Suspect"
	THRESHOLDED = "Thresholded"
	TIME_COLLECTED = "TimeCollected"

	CONST_MOST_RECENT_FALSE = "false"
	CONST_MOST_RECENT_NO = "no"
	CONST_MOST_RECENT_TRUE = "true"
	CONST_MOST_RECENT_YES = "yes"
	CONST_SUSPECT_FALSE = "false"
	CONST_SUSPECT_NO = "no"
	CONST_SUSPECT_TRUE = "true"
	CONST_SUSPECT_YES = "yes"

class ComputeServerDiscPolicy(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"ComputeServerDiscPolicy")

	@staticmethod
	def ClassId():
		return "computeServerDiscPolicy"

	ACTION = "Action"
	DESCR = "Descr"
	DN = "Dn"
	NAME = "Name"
	POLICY_LEVEL = "PolicyLevel"
	POLICY_OWNER = "PolicyOwner"
	QUALIFIER = "Qualifier"
	RN = "Rn"
	SCRUB_POLICY_NAME = "ScrubPolicyName"
	STATUS = "Status"

	CONST_ACTION_DIAG = "diag"
	CONST_ACTION_IMMEDIATE = "immediate"
	CONST_ACTION_USER_ACKNOWLEDGED = "user-acknowledged"
	CONST_FSM_PREV_RESOLVE_SCRUB_POLICY_BEGIN = "ResolveScrubPolicyBegin"
	CONST_FSM_PREV_RESOLVE_SCRUB_POLICY_FAIL = "ResolveScrubPolicyFail"
	CONST_FSM_PREV_RESOLVE_SCRUB_POLICY_RESOLVE = "ResolveScrubPolicyResolve"
	CONST_FSM_PREV_RESOLVE_SCRUB_POLICY_SUCCESS = "ResolveScrubPolicySuccess"
	CONST_FSM_PREV_NOP = "nop"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_2FA_AUTH_RETRY = "ERR-2fa-auth-retry"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_ACTIVATE_FAILED = "ERR-ACTIVATE-failed"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_ACTIVATE_IN_PROGRESS = "ERR-ACTIVATE-in-progress"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_ACTIVATE_RETRY = "ERR-ACTIVATE-retry"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_BIOS_TOKENS_OLD_BIOS = "ERR-BIOS-TOKENS-OLD-BIOS"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_BIOS_TOKENS_OLD_CIMC = "ERR-BIOS-TOKENS-OLD-CIMC"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_BIOS_NETWORK_BOOT_ORDER_NOT_FOUND = "ERR-BIOS-network-boot-order-not-found"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_BOARDCTRLUPDATE_IGNORE = "ERR-BOARDCTRLUPDATE-ignore"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DIAG_CANCELLED = "ERR-DIAG-cancelled"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DIAG_FSM_RESTARTED = "ERR-DIAG-fsm-restarted"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DIAG_TEST_FAILED = "ERR-DIAG-test-failed"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DNLD_AUTHENTICATION_FAILURE = "ERR-DNLD-authentication-failure"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DNLD_HOSTKEY_MISMATCH = "ERR-DNLD-hostkey-mismatch"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DNLD_INVALID_IMAGE = "ERR-DNLD-invalid-image"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DNLD_NO_FILE = "ERR-DNLD-no-file"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DNLD_NO_SPACE = "ERR-DNLD-no-space"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DNS_DELETE_ERROR = "ERR-DNS-delete-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DNS_GET_ERROR = "ERR-DNS-get-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DNS_SET_ERROR = "ERR-DNS-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DIAGNOSTICS_IN_PROGRESS = "ERR-Diagnostics-in-progress"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DIAGNOSTICS_MEMTEST_IN_PROGRESS = "ERR-Diagnostics-memtest-in-progress"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DIAGNOSTICS_NETWORK_IN_PROGRESS = "ERR-Diagnostics-network-in-progress"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_FILTER_ILLEGAL_FORMAT = "ERR-FILTER-illegal-format"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_FSM_NO_SUCH_STATE = "ERR-FSM-no-such-state"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_HOST_FRU_IDENTITY_MISMATCH = "ERR-HOST-fru-identity-mismatch"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_HTTP_SET_ERROR = "ERR-HTTP-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_HTTPS_SET_ERROR = "ERR-HTTPS-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_IBMC_ANALYZE_RESULTS = "ERR-IBMC-analyze-results"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_IBMC_CONNECT_ERROR = "ERR-IBMC-connect-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_IBMC_FRU_RETRIEVAL_ERROR = "ERR-IBMC-fru-retrieval-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_IBMC_INVALID_END_POINT_CONFIG = "ERR-IBMC-invalid-end-point-config"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_IBMC_RESULTS_NOT_READY = "ERR-IBMC-results-not-ready"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MAX_SUBSCRIPTIONS_ALLOWED_ERROR = "ERR-MAX-subscriptions-allowed-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_CONFIG_CHILD_OBJECT_CANT_BE_CONFIGURED = "ERR-MO-CONFIG-child-object-cant-be-configured"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_META_NO_SUCH_OBJECT_CLASS = "ERR-MO-META-no-such-object-class"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_PROPERTY_NO_SUCH_PROPERTY = "ERR-MO-PROPERTY-no-such-property"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_PROPERTY_VALUE_OUT_OF_RANGE = "ERR-MO-PROPERTY-value-out-of-range"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_ACCESS_DENIED = "ERR-MO-access-denied"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_DELETION_RULE_VIOLATION = "ERR-MO-deletion-rule-violation"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_DUPLICATE_OBJECT = "ERR-MO-duplicate-object"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_ILLEGAL_CONTAINMENT = "ERR-MO-illegal-containment"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_ILLEGAL_CREATION = "ERR-MO-illegal-creation"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_ILLEGAL_ITERATOR_STATE = "ERR-MO-illegal-iterator-state"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_ILLEGAL_OBJECT_LIFECYCLE_TRANSITION = "ERR-MO-illegal-object-lifecycle-transition"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_NAMING_RULE_VIOLATION = "ERR-MO-naming-rule-violation"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_OBJECT_NOT_FOUND = "ERR-MO-object-not-found"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_RESOURCE_ALLOCATION = "ERR-MO-resource-allocation"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_NTP_DELETE_ERROR = "ERR-NTP-delete-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_NTP_GET_ERROR = "ERR-NTP-get-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_NTP_SET_ERROR = "ERR-NTP-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_POWER_CAP_UNSUPPORTED = "ERR-POWER-CAP-UNSUPPORTED"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_SERVER_MIS_CONNECT = "ERR-SERVER-mis-connect"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_SWITCH_INVALID_IF_CONFIG = "ERR-SWITCH-invalid-if-config"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_TOKEN_REQUEST_DENIED = "ERR-TOKEN-request-denied"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_UNABLE_TO_FETCH_BIOS_SETTINGS = "ERR-UNABLE-TO-FETCH-BIOS-SETTINGS"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_UPDATE_FAILED = "ERR-UPDATE-failed"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_UPDATE_IN_PROGRESS = "ERR-UPDATE-in-progress"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_UPDATE_RETRY = "ERR-UPDATE-retry"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_AAA_CONFIG_MODIFY_ERROR = "ERR-aaa-config-modify-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_ACCT_REALM_SET_ERROR = "ERR-acct-realm-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_ADMIN_PASSWD_SET = "ERR-admin-passwd-set"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_AUTH_ISSUE = "ERR-auth-issue"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_AUTH_REALM_GET_ERROR = "ERR-auth-realm-get-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_AUTH_REALM_SET_ERROR = "ERR-auth-realm-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_AUTHENTICATION = "ERR-authentication"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_AUTHORIZATION_REQUIRED = "ERR-authorization-required"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_CLI_SESSION_LIMIT_REACHED = "ERR-cli-session-limit-reached"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_CREATE_KEYRING = "ERR-create-keyring"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_CREATE_LOCALE = "ERR-create-locale"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_CREATE_ROLE = "ERR-create-role"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_CREATE_USER = "ERR-create-user"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DELETE_LOCALE = "ERR-delete-locale"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DELETE_ROLE = "ERR-delete-role"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DELETE_SESSION = "ERR-delete-session"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DELETE_USER = "ERR-delete-user"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_EFI_DIAGNOSTICS_IN_PROGRESS = "ERR-efi-Diagnostics--in-progress"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_ENABLE_MGMT_CONN = "ERR-enable-mgmt-conn"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_EP_SET_ERROR = "ERR-ep-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_GET_MAX_HTTP_USER_SESSIONS = "ERR-get-max-http-user-sessions"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_HTTP_INITIALIZING = "ERR-http-initializing"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_INSUFFICIENTLY_EQUIPPED = "ERR-insufficiently-equipped"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_INTERNAL_ERROR = "ERR-internal-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_LDAP_DELETE_ERROR = "ERR-ldap-delete-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_LDAP_GET_ERROR = "ERR-ldap-get-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_LDAP_GROUP_MODIFY_ERROR = "ERR-ldap-group-modify-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_LDAP_GROUP_SET_ERROR = "ERR-ldap-group-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_LDAP_SET_ERROR = "ERR-ldap-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_LOCALE_SET_ERROR = "ERR-locale-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MAX_USERID_SESSIONS_REACHED = "ERR-max-userid-sessions-reached"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MISSING_METHOD = "ERR-missing-method"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MODIFY_LOCALE = "ERR-modify-locale"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MODIFY_ROLE = "ERR-modify-role"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MODIFY_USER = "ERR-modify-user"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MODIFY_USER_LOCALE = "ERR-modify-user-locale"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MODIFY_USER_ROLE = "ERR-modify-user-role"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_PROVIDER_GROUP_MODIFY_ERROR = "ERR-provider-group-modify-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_PROVIDER_GROUP_SET_ERROR = "ERR-provider-group-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_RADIUS_GET_ERROR = "ERR-radius-get-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_RADIUS_GLOBAL_SET_ERROR = "ERR-radius-global-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_RADIUS_GROUP_SET_ERROR = "ERR-radius-group-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_RADIUS_SET_ERROR = "ERR-radius-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_REQUEST_TIMEOUT = "ERR-request-timeout"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_RESET_ADAPTER = "ERR-reset-adapter"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_ROLE_SET_ERROR = "ERR-role-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_SECONDARY_NODE = "ERR-secondary-node"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_SERVICE_NOT_READY = "ERR-service-not-ready"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_SESSION_CACHE_FULL = "ERR-session-cache-full"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_SESSION_NOT_FOUND = "ERR-session-not-found"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_SET_NETWORK = "ERR-set-network"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_SET_PASSWORD_STRENGTH_CHECK = "ERR-set-password-strength-check"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_SET_PORT_CHANNEL = "ERR-set-port-channel"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_STORE_PRE_LOGIN_BANNER_MSG = "ERR-store-pre-login-banner-msg"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_TACACS_ENABLE_ERROR = "ERR-tacacs-enable-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_TACACS_GLOBAL_SET_ERROR = "ERR-tacacs-global-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_TACACS_GROUP_SET_ERROR = "ERR-tacacs-group-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_TACACS_PLUS_GET_ERROR = "ERR-tacacs-plus-get-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_TACACS_SET_ERROR = "ERR-tacacs-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_TEST_ERROR_1 = "ERR-test-error-1"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_TEST_ERROR_2 = "ERR-test-error-2"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_TIMEZONE_SET_ERROR = "ERR-timezone-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_USER_ACCOUNT_EXPIRED = "ERR-user-account-expired"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_USER_SET_ERROR = "ERR-user-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_XML_PARSE_ERROR = "ERR-xml-parse-error"
	CONST_FSM_RMT_INV_ERR_CODE_NONE = "none"
	CONST_FSM_STAMP_NEVER = "never"
	CONST_FSM_STATUS_RESOLVE_SCRUB_POLICY_BEGIN = "ResolveScrubPolicyBegin"
	CONST_FSM_STATUS_RESOLVE_SCRUB_POLICY_FAIL = "ResolveScrubPolicyFail"
	CONST_FSM_STATUS_RESOLVE_SCRUB_POLICY_RESOLVE = "ResolveScrubPolicyResolve"
	CONST_FSM_STATUS_RESOLVE_SCRUB_POLICY_SUCCESS = "ResolveScrubPolicySuccess"
	CONST_FSM_STATUS_NOP = "nop"
	CONST_INT_ID_NONE = "none"
	CONST_POLICY_OWNER_LOCAL = "local"
	CONST_POLICY_OWNER_PENDING_POLICY = "pending-policy"
	CONST_POLICY_OWNER_POLICY = "policy"

class IdentIdentCtx(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"IdentIdentCtx")

	@staticmethod
	def ClassId():
		return "identIdentCtx"

	ASSIGNED = "Assigned"
	CONS_DN = "ConsDn"
	CONS_TYPE = "ConsType"
	DEFINED_IN_IDM = "DefinedInIdm"
	DN = "Dn"
	IDENT_POOL_NAME = "IdentPoolName"
	IDENT_TYPE = "IdentType"
	INTENT = "Intent"
	POOL_DN = "PoolDn"
	POOL_ORG_DN = "PoolOrgDn"
	POOLED_ID = "PooledId"
	RET_STATUS = "RetStatus"
	RN = "Rn"
	SEQ_NUM = "SeqNum"
	STATUS = "Status"
	SUPPL_ID1 = "SupplId1"
	SUPPL_ID2 = "SupplId2"
	SUPPL_ID3 = "SupplId3"
	SUPPL_ID4 = "SupplId4"

	CONST_CONS_TYPE_CHASSIS = "chassis"
	CONST_CONS_TYPE_SERVER = "server"
	CONST_CONS_TYPE_VHBA = "vhba"
	CONST_CONS_TYPE_VM = "vm"
	CONST_CONS_TYPE_VMNIC = "vmnic"
	CONST_CONS_TYPE_VNIC = "vnic"
	CONST_DEFINED_IN_IDM_NO = "no"
	CONST_DEFINED_IN_IDM_YES = "yes"
	CONST_IDENT_TYPE_IP_V4 = "ipV4"
	CONST_IDENT_TYPE_IP_V6 = "ipV6"
	CONST_IDENT_TYPE_IQN = "iqn"
	CONST_IDENT_TYPE_MAC = "mac"
	CONST_IDENT_TYPE_UUID = "uuid"
	CONST_IDENT_TYPE_VLAN = "vlan"
	CONST_IDENT_TYPE_WWNN = "wwnn"
	CONST_IDENT_TYPE_WWPN = "wwpn"
	CONST_INTENT_ADD_POOLED = "add-pooled"
	CONST_INTENT_ASSIGN = "assign"
	CONST_INTENT_DELETE_POOLED = "delete-pooled"
	CONST_INTENT_REQUISITION = "requisition"
	CONST_INTENT_UNASSIGN = "unassign"
	CONST_RET_STATUS_ASSIGNED_BY_OTHER = "assigned-by-other"
	CONST_RET_STATUS_FAILED = "failed"
	CONST_RET_STATUS_OUT_OF_SYNC = "out-of-sync"
	CONST_RET_STATUS_SUCCEEDED = "succeeded"
	CONST_RET_STATUS_SYNCED = "synced"

class FabricSanCloud(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"FabricSanCloud")

	@staticmethod
	def ClassId():
		return "fabricSanCloud"

	DN = "Dn"
	MODE = "Mode"
	RN = "Rn"
	STATUS = "Status"

	CONST_FSM_PREV_SWITCH_MODE_BEGIN = "SwitchModeBegin"
	CONST_FSM_PREV_SWITCH_MODE_FAIL = "SwitchModeFail"
	CONST_FSM_PREV_SWITCH_MODE_SUCCESS = "SwitchModeSuccess"
	CONST_FSM_PREV_SWITCH_MODE_SW_CONFIG_LOCAL = "SwitchModeSwConfigLocal"
	CONST_FSM_PREV_SWITCH_MODE_SW_CONFIG_PEER = "SwitchModeSwConfigPeer"
	CONST_FSM_PREV_NOP = "nop"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_2FA_AUTH_RETRY = "ERR-2fa-auth-retry"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_ACTIVATE_FAILED = "ERR-ACTIVATE-failed"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_ACTIVATE_IN_PROGRESS = "ERR-ACTIVATE-in-progress"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_ACTIVATE_RETRY = "ERR-ACTIVATE-retry"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_BIOS_TOKENS_OLD_BIOS = "ERR-BIOS-TOKENS-OLD-BIOS"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_BIOS_TOKENS_OLD_CIMC = "ERR-BIOS-TOKENS-OLD-CIMC"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_BIOS_NETWORK_BOOT_ORDER_NOT_FOUND = "ERR-BIOS-network-boot-order-not-found"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_BOARDCTRLUPDATE_IGNORE = "ERR-BOARDCTRLUPDATE-ignore"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DIAG_CANCELLED = "ERR-DIAG-cancelled"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DIAG_FSM_RESTARTED = "ERR-DIAG-fsm-restarted"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DIAG_TEST_FAILED = "ERR-DIAG-test-failed"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DNLD_AUTHENTICATION_FAILURE = "ERR-DNLD-authentication-failure"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DNLD_HOSTKEY_MISMATCH = "ERR-DNLD-hostkey-mismatch"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DNLD_INVALID_IMAGE = "ERR-DNLD-invalid-image"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DNLD_NO_FILE = "ERR-DNLD-no-file"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DNLD_NO_SPACE = "ERR-DNLD-no-space"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DNS_DELETE_ERROR = "ERR-DNS-delete-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DNS_GET_ERROR = "ERR-DNS-get-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DNS_SET_ERROR = "ERR-DNS-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DIAGNOSTICS_IN_PROGRESS = "ERR-Diagnostics-in-progress"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DIAGNOSTICS_MEMTEST_IN_PROGRESS = "ERR-Diagnostics-memtest-in-progress"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DIAGNOSTICS_NETWORK_IN_PROGRESS = "ERR-Diagnostics-network-in-progress"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_FILTER_ILLEGAL_FORMAT = "ERR-FILTER-illegal-format"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_FSM_NO_SUCH_STATE = "ERR-FSM-no-such-state"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_HOST_FRU_IDENTITY_MISMATCH = "ERR-HOST-fru-identity-mismatch"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_HTTP_SET_ERROR = "ERR-HTTP-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_HTTPS_SET_ERROR = "ERR-HTTPS-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_IBMC_ANALYZE_RESULTS = "ERR-IBMC-analyze-results"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_IBMC_CONNECT_ERROR = "ERR-IBMC-connect-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_IBMC_FRU_RETRIEVAL_ERROR = "ERR-IBMC-fru-retrieval-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_IBMC_INVALID_END_POINT_CONFIG = "ERR-IBMC-invalid-end-point-config"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_IBMC_RESULTS_NOT_READY = "ERR-IBMC-results-not-ready"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MAX_SUBSCRIPTIONS_ALLOWED_ERROR = "ERR-MAX-subscriptions-allowed-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_CONFIG_CHILD_OBJECT_CANT_BE_CONFIGURED = "ERR-MO-CONFIG-child-object-cant-be-configured"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_META_NO_SUCH_OBJECT_CLASS = "ERR-MO-META-no-such-object-class"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_PROPERTY_NO_SUCH_PROPERTY = "ERR-MO-PROPERTY-no-such-property"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_PROPERTY_VALUE_OUT_OF_RANGE = "ERR-MO-PROPERTY-value-out-of-range"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_ACCESS_DENIED = "ERR-MO-access-denied"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_DELETION_RULE_VIOLATION = "ERR-MO-deletion-rule-violation"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_DUPLICATE_OBJECT = "ERR-MO-duplicate-object"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_ILLEGAL_CONTAINMENT = "ERR-MO-illegal-containment"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_ILLEGAL_CREATION = "ERR-MO-illegal-creation"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_ILLEGAL_ITERATOR_STATE = "ERR-MO-illegal-iterator-state"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_ILLEGAL_OBJECT_LIFECYCLE_TRANSITION = "ERR-MO-illegal-object-lifecycle-transition"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_NAMING_RULE_VIOLATION = "ERR-MO-naming-rule-violation"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_OBJECT_NOT_FOUND = "ERR-MO-object-not-found"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_RESOURCE_ALLOCATION = "ERR-MO-resource-allocation"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_NTP_DELETE_ERROR = "ERR-NTP-delete-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_NTP_GET_ERROR = "ERR-NTP-get-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_NTP_SET_ERROR = "ERR-NTP-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_POWER_CAP_UNSUPPORTED = "ERR-POWER-CAP-UNSUPPORTED"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_SERVER_MIS_CONNECT = "ERR-SERVER-mis-connect"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_SWITCH_INVALID_IF_CONFIG = "ERR-SWITCH-invalid-if-config"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_TOKEN_REQUEST_DENIED = "ERR-TOKEN-request-denied"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_UNABLE_TO_FETCH_BIOS_SETTINGS = "ERR-UNABLE-TO-FETCH-BIOS-SETTINGS"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_UPDATE_FAILED = "ERR-UPDATE-failed"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_UPDATE_IN_PROGRESS = "ERR-UPDATE-in-progress"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_UPDATE_RETRY = "ERR-UPDATE-retry"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_AAA_CONFIG_MODIFY_ERROR = "ERR-aaa-config-modify-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_ACCT_REALM_SET_ERROR = "ERR-acct-realm-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_ADMIN_PASSWD_SET = "ERR-admin-passwd-set"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_AUTH_ISSUE = "ERR-auth-issue"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_AUTH_REALM_GET_ERROR = "ERR-auth-realm-get-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_AUTH_REALM_SET_ERROR = "ERR-auth-realm-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_AUTHENTICATION = "ERR-authentication"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_AUTHORIZATION_REQUIRED = "ERR-authorization-required"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_CLI_SESSION_LIMIT_REACHED = "ERR-cli-session-limit-reached"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_CREATE_KEYRING = "ERR-create-keyring"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_CREATE_LOCALE = "ERR-create-locale"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_CREATE_ROLE = "ERR-create-role"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_CREATE_USER = "ERR-create-user"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DELETE_LOCALE = "ERR-delete-locale"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DELETE_ROLE = "ERR-delete-role"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DELETE_SESSION = "ERR-delete-session"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DELETE_USER = "ERR-delete-user"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_EFI_DIAGNOSTICS_IN_PROGRESS = "ERR-efi-Diagnostics--in-progress"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_ENABLE_MGMT_CONN = "ERR-enable-mgmt-conn"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_EP_SET_ERROR = "ERR-ep-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_GET_MAX_HTTP_USER_SESSIONS = "ERR-get-max-http-user-sessions"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_HTTP_INITIALIZING = "ERR-http-initializing"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_INSUFFICIENTLY_EQUIPPED = "ERR-insufficiently-equipped"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_INTERNAL_ERROR = "ERR-internal-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_LDAP_DELETE_ERROR = "ERR-ldap-delete-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_LDAP_GET_ERROR = "ERR-ldap-get-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_LDAP_GROUP_MODIFY_ERROR = "ERR-ldap-group-modify-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_LDAP_GROUP_SET_ERROR = "ERR-ldap-group-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_LDAP_SET_ERROR = "ERR-ldap-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_LOCALE_SET_ERROR = "ERR-locale-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MAX_USERID_SESSIONS_REACHED = "ERR-max-userid-sessions-reached"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MISSING_METHOD = "ERR-missing-method"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MODIFY_LOCALE = "ERR-modify-locale"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MODIFY_ROLE = "ERR-modify-role"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MODIFY_USER = "ERR-modify-user"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MODIFY_USER_LOCALE = "ERR-modify-user-locale"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MODIFY_USER_ROLE = "ERR-modify-user-role"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_PROVIDER_GROUP_MODIFY_ERROR = "ERR-provider-group-modify-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_PROVIDER_GROUP_SET_ERROR = "ERR-provider-group-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_RADIUS_GET_ERROR = "ERR-radius-get-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_RADIUS_GLOBAL_SET_ERROR = "ERR-radius-global-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_RADIUS_GROUP_SET_ERROR = "ERR-radius-group-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_RADIUS_SET_ERROR = "ERR-radius-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_REQUEST_TIMEOUT = "ERR-request-timeout"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_RESET_ADAPTER = "ERR-reset-adapter"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_ROLE_SET_ERROR = "ERR-role-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_SECONDARY_NODE = "ERR-secondary-node"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_SERVICE_NOT_READY = "ERR-service-not-ready"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_SESSION_CACHE_FULL = "ERR-session-cache-full"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_SESSION_NOT_FOUND = "ERR-session-not-found"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_SET_NETWORK = "ERR-set-network"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_SET_PASSWORD_STRENGTH_CHECK = "ERR-set-password-strength-check"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_SET_PORT_CHANNEL = "ERR-set-port-channel"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_STORE_PRE_LOGIN_BANNER_MSG = "ERR-store-pre-login-banner-msg"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_TACACS_ENABLE_ERROR = "ERR-tacacs-enable-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_TACACS_GLOBAL_SET_ERROR = "ERR-tacacs-global-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_TACACS_GROUP_SET_ERROR = "ERR-tacacs-group-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_TACACS_PLUS_GET_ERROR = "ERR-tacacs-plus-get-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_TACACS_SET_ERROR = "ERR-tacacs-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_TEST_ERROR_1 = "ERR-test-error-1"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_TEST_ERROR_2 = "ERR-test-error-2"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_TIMEZONE_SET_ERROR = "ERR-timezone-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_USER_ACCOUNT_EXPIRED = "ERR-user-account-expired"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_USER_SET_ERROR = "ERR-user-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_XML_PARSE_ERROR = "ERR-xml-parse-error"
	CONST_FSM_RMT_INV_ERR_CODE_NONE = "none"
	CONST_FSM_STAMP_NEVER = "never"
	CONST_FSM_STATUS_SWITCH_MODE_BEGIN = "SwitchModeBegin"
	CONST_FSM_STATUS_SWITCH_MODE_FAIL = "SwitchModeFail"
	CONST_FSM_STATUS_SWITCH_MODE_SUCCESS = "SwitchModeSuccess"
	CONST_FSM_STATUS_SWITCH_MODE_SW_CONFIG_LOCAL = "SwitchModeSwConfigLocal"
	CONST_FSM_STATUS_SWITCH_MODE_SW_CONFIG_PEER = "SwitchModeSwConfigPeer"
	CONST_FSM_STATUS_NOP = "nop"
	CONST_MODE_END_HOST = "end-host"
	CONST_MODE_SWITCH = "switch"

class ExtpolClientCont(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"ExtpolClientCont")

	@staticmethod
	def ClassId():
		return "extpolClientCont"

	DN = "Dn"
	GEN_NUM = "GenNum"
	RN = "Rn"
	STATUS = "Status"


class FabricEthEstcCloud(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"FabricEthEstcCloud")

	@staticmethod
	def ClassId():
		return "fabricEthEstcCloud"

	DN = "Dn"
	RN = "Rn"
	STATUS = "Status"


class ComputePoolPolicyRef(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"ComputePoolPolicyRef")

	@staticmethod
	def ClassId():
		return "computePoolPolicyRef"

	DN = "Dn"
	ID = "Id"
	POLICY_DN = "PolicyDn"
	RN = "Rn"
	STATUS = "Status"


class VnicScsi(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"VnicScsi")

	@staticmethod
	def ClassId():
		return "vnicScsi"

	ADAPTOR_PROFILE_NAME = "AdaptorProfileName"
	ADMIN_VCON = "AdminVcon"
	BOOT_DEV = "BootDev"
	CONFIG_QUALIFIER = "ConfigQualifier"
	CONFIG_STATE = "ConfigState"
	DN = "Dn"
	EQUIPMENT_DN = "EquipmentDn"
	IDENT_POOL_NAME = "IdentPoolName"
	INST_TYPE = "InstType"
	NAME = "Name"
	NW_TEMPL_NAME = "NwTemplName"
	OPER_ORDER = "OperOrder"
	OPER_SPEED = "OperSpeed"
	OPER_STATS_POLICY_NAME = "OperStatsPolicyName"
	OPER_VCON = "OperVcon"
	ORDER = "Order"
	OWNER = "Owner"
	PIN_TO_GROUP_NAME = "PinToGroupName"
	QOS_POLICY_NAME = "QosPolicyName"
	RN = "Rn"
	STATS_POLICY_NAME = "StatsPolicyName"
	STATUS = "Status"
	SWITCH_ID = "SwitchId"
	TYPE = "Type"

	CONST_ADMIN_VCON_1 = "1"
	CONST_ADMIN_VCON_2 = "2"
	CONST_ADMIN_VCON_3 = "3"
	CONST_ADMIN_VCON_4 = "4"
	CONST_ADMIN_VCON_ANY = "any"
	CONST_BOOT_DEV_DISABLED = "disabled"
	CONST_BOOT_DEV_ENABLED = "enabled"
	CONST_CONFIG_STATE_APPLIED = "applied"
	CONST_CONFIG_STATE_APPLYING = "applying"
	CONST_CONFIG_STATE_FAILED_TO_APPLY = "failed-to-apply"
	CONST_CONFIG_STATE_NOT_APPLIED = "not-applied"
	CONST_INST_TYPE_DEFAULT = "default"
	CONST_INST_TYPE_DYNAMIC = "dynamic"
	CONST_INST_TYPE_DYNAMIC_VF = "dynamic-vf"
	CONST_INST_TYPE_MANUAL = "manual"
	CONST_OPER_ORDER_UNSPECIFIED = "unspecified"
	CONST_OPER_SPEED_LINE_RATE = "line-rate"
	CONST_OPER_VCON_1 = "1"
	CONST_OPER_VCON_2 = "2"
	CONST_OPER_VCON_3 = "3"
	CONST_OPER_VCON_4 = "4"
	CONST_OPER_VCON_ANY = "any"
	CONST_ORDER_UNSPECIFIED = "unspecified"
	CONST_OWNER_CONN_POLICY = "conn_policy"
	CONST_OWNER_LOGICAL = "logical"
	CONST_OWNER_PHYSICAL = "physical"
	CONST_OWNER_POLICY = "policy"
	CONST_OWNER_UNKNOWN = "unknown"
	CONST_SWITCH_ID_A = "A"
	CONST_SWITCH_ID_B = "B"
	CONST_SWITCH_ID_NONE = "NONE"
	CONST_TYPE_ETHER = "ether"
	CONST_TYPE_FC = "fc"
	CONST_TYPE_IPC = "ipc"
	CONST_TYPE_SCSI = "scsi"
	CONST_TYPE_UNKNOWN = "unknown"

class TopSystem(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"TopSystem")

	@staticmethod
	def ClassId():
		return "topSystem"

	ADDRESS = "Address"
	CURRENT_TIME = "CurrentTime"
	DESCR = "Descr"
	DN = "Dn"
	IPV6_ADDR = "Ipv6Addr"
	MODE = "Mode"
	NAME = "Name"
	OWNER = "Owner"
	RN = "Rn"
	SITE = "Site"
	STATUS = "Status"
	SYSTEM_UP_TIME = "SystemUpTime"

	CONST_MODE_CLUSTER = "cluster"
	CONST_MODE_STAND_ALONE = "stand-alone"
	CONST_MODE_UNSPECIFIED = "unspecified"

class MgmtController(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"MgmtController")

	@staticmethod
	def ClassId():
		return "mgmtController"

	DIMM_BLACKLISTING_OPER_STATE = "DimmBlacklistingOperState"
	DN = "Dn"
	GUID = "Guid"
	MODEL = "Model"
	OPER_CONN = "OperConn"
	REVISION = "Revision"
	RN = "Rn"
	SERIAL = "Serial"
	STATUS = "Status"
	STORAGE_OOB_INTERFACE_SUPPORTED = "StorageOobInterfaceSupported"
	STORAGE_SUBSYSTEM_STATE = "StorageSubsystemState"
	SUBJECT = "Subject"
	VENDOR = "Vendor"

	CONST_DIMM_BLACKLISTING_OPER_STATE_DISABLED = "disabled"
	CONST_DIMM_BLACKLISTING_OPER_STATE_ENABLED = "enabled"
	CONST_DIMM_BLACKLISTING_OPER_STATE_UNKNOWN = "unknown"
	CONST_DIMM_BLACKLISTING_OPER_STATE_UNSUPPORTED = "unsupported"
	CONST_FSM_PREV_ACTIVATE_BMCACTIVATE = "ActivateBMCActivate"
	CONST_FSM_PREV_ACTIVATE_BMCBEGIN = "ActivateBMCBegin"
	CONST_FSM_PREV_ACTIVATE_BMCFAIL = "ActivateBMCFail"
	CONST_FSM_PREV_ACTIVATE_BMCRESET = "ActivateBMCReset"
	CONST_FSM_PREV_ACTIVATE_BMCSUCCESS = "ActivateBMCSuccess"
	CONST_FSM_PREV_ACTIVATE_IOMACTIVATE = "ActivateIOMActivate"
	CONST_FSM_PREV_ACTIVATE_IOMBEGIN = "ActivateIOMBegin"
	CONST_FSM_PREV_ACTIVATE_IOMFAIL = "ActivateIOMFail"
	CONST_FSM_PREV_ACTIVATE_IOMRESET = "ActivateIOMReset"
	CONST_FSM_PREV_ACTIVATE_IOMSUCCESS = "ActivateIOMSuccess"
	CONST_FSM_PREV_EXT_MGMT_IF_CONFIG_BEGIN = "ExtMgmtIfConfigBegin"
	CONST_FSM_PREV_EXT_MGMT_IF_CONFIG_FAIL = "ExtMgmtIfConfigFail"
	CONST_FSM_PREV_EXT_MGMT_IF_CONFIG_PRIMARY = "ExtMgmtIfConfigPrimary"
	CONST_FSM_PREV_EXT_MGMT_IF_CONFIG_SECONDARY = "ExtMgmtIfConfigSecondary"
	CONST_FSM_PREV_EXT_MGMT_IF_CONFIG_SUCCESS = "ExtMgmtIfConfigSuccess"
	CONST_FSM_PREV_EXT_MGMT_INTERFACE_CONFIG_ACTIVE = "ExtMgmtInterfaceConfigActive"
	CONST_FSM_PREV_EXT_MGMT_INTERFACE_CONFIG_BEGIN = "ExtMgmtInterfaceConfigBegin"
	CONST_FSM_PREV_EXT_MGMT_INTERFACE_CONFIG_CIMCVLAN_CFG_LOCAL = "ExtMgmtInterfaceConfigCIMCVlanCfgLocal"
	CONST_FSM_PREV_EXT_MGMT_INTERFACE_CONFIG_CIMCVLAN_CFG_PEER = "ExtMgmtInterfaceConfigCIMCVlanCfgPeer"
	CONST_FSM_PREV_EXT_MGMT_INTERFACE_CONFIG_CMCVLAN_CFG = "ExtMgmtInterfaceConfigCMCVlanCfg"
	CONST_FSM_PREV_EXT_MGMT_INTERFACE_CONFIG_CMCVLAN_CFG_PEER = "ExtMgmtInterfaceConfigCMCVlanCfgPeer"
	CONST_FSM_PREV_EXT_MGMT_INTERFACE_CONFIG_FAIL = "ExtMgmtInterfaceConfigFail"
	CONST_FSM_PREV_EXT_MGMT_INTERFACE_CONFIG_SUCCESS = "ExtMgmtInterfaceConfigSuccess"
	CONST_FSM_PREV_ONLINE_BEGIN = "OnlineBegin"
	CONST_FSM_PREV_ONLINE_BMC_CONFIGURE_CONN_LOCAL = "OnlineBmcConfigureConnLocal"
	CONST_FSM_PREV_ONLINE_BMC_CONFIGURE_CONN_PEER = "OnlineBmcConfigureConnPeer"
	CONST_FSM_PREV_ONLINE_FAIL = "OnlineFail"
	CONST_FSM_PREV_ONLINE_SUCCESS = "OnlineSuccess"
	CONST_FSM_PREV_ONLINE_SW_CONFIGURE_CONN_LOCAL = "OnlineSwConfigureConnLocal"
	CONST_FSM_PREV_ONLINE_SW_CONFIGURE_CONN_PEER = "OnlineSwConfigureConnPeer"
	CONST_FSM_PREV_REGISTRY_CONFIG_BEGIN = "RegistryConfigBegin"
	CONST_FSM_PREV_REGISTRY_CONFIG_FAIL = "RegistryConfigFail"
	CONST_FSM_PREV_REGISTRY_CONFIG_REMOVE = "RegistryConfigRemove"
	CONST_FSM_PREV_REGISTRY_CONFIG_SUCCESS = "RegistryConfigSuccess"
	CONST_FSM_PREV_SYS_CONFIG_BEGIN = "SysConfigBegin"
	CONST_FSM_PREV_SYS_CONFIG_FAIL = "SysConfigFail"
	CONST_FSM_PREV_SYS_CONFIG_PRIMARY = "SysConfigPrimary"
	CONST_FSM_PREV_SYS_CONFIG_SECONDARY = "SysConfigSecondary"
	CONST_FSM_PREV_SYS_CONFIG_SUCCESS = "SysConfigSuccess"
	CONST_FSM_PREV_UPDATE_BMCBEGIN = "UpdateBMCBegin"
	CONST_FSM_PREV_UPDATE_BMCFAIL = "UpdateBMCFail"
	CONST_FSM_PREV_UPDATE_BMCPOLL_UPDATE_STATUS = "UpdateBMCPollUpdateStatus"
	CONST_FSM_PREV_UPDATE_BMCSUCCESS = "UpdateBMCSuccess"
	CONST_FSM_PREV_UPDATE_BMCUPDATE_REQUEST = "UpdateBMCUpdateRequest"
	CONST_FSM_PREV_UPDATE_IOMBEGIN = "UpdateIOMBegin"
	CONST_FSM_PREV_UPDATE_IOMFAIL = "UpdateIOMFail"
	CONST_FSM_PREV_UPDATE_IOMPOLL_UPDATE_STATUS = "UpdateIOMPollUpdateStatus"
	CONST_FSM_PREV_UPDATE_IOMSUCCESS = "UpdateIOMSuccess"
	CONST_FSM_PREV_UPDATE_IOMUPDATE_REQUEST = "UpdateIOMUpdateRequest"
	CONST_FSM_PREV_UPDATE_SWITCH_BEGIN = "UpdateSwitchBegin"
	CONST_FSM_PREV_UPDATE_SWITCH_COPY_TO_LOCAL = "UpdateSwitchCopyToLocal"
	CONST_FSM_PREV_UPDATE_SWITCH_COPY_TO_PEER = "UpdateSwitchCopyToPeer"
	CONST_FSM_PREV_UPDATE_SWITCH_FAIL = "UpdateSwitchFail"
	CONST_FSM_PREV_UPDATE_SWITCH_RESET_LOCAL = "UpdateSwitchResetLocal"
	CONST_FSM_PREV_UPDATE_SWITCH_RESET_REMOTE = "UpdateSwitchResetRemote"
	CONST_FSM_PREV_UPDATE_SWITCH_SUCCESS = "UpdateSwitchSuccess"
	CONST_FSM_PREV_UPDATE_SWITCH_UPDATE_LOCAL = "UpdateSwitchUpdateLocal"
	CONST_FSM_PREV_UPDATE_SWITCH_UPDATE_REMOTE = "UpdateSwitchUpdateRemote"
	CONST_FSM_PREV_UPDATE_SWITCH_VERIFY_LOCAL = "UpdateSwitchVerifyLocal"
	CONST_FSM_PREV_UPDATE_SWITCH_VERIFY_REMOTE = "UpdateSwitchVerifyRemote"
	CONST_FSM_PREV_UPDATE_UCSMANAGER_BEGIN = "UpdateUCSManagerBegin"
	CONST_FSM_PREV_UPDATE_UCSMANAGER_COPY_EXT_TO_LOCAL = "UpdateUCSManagerCopyExtToLocal"
	CONST_FSM_PREV_UPDATE_UCSMANAGER_COPY_EXT_TO_PEER = "UpdateUCSManagerCopyExtToPeer"
	CONST_FSM_PREV_UPDATE_UCSMANAGER_EXECUTE = "UpdateUCSManagerExecute"
	CONST_FSM_PREV_UPDATE_UCSMANAGER_FAIL = "UpdateUCSManagerFail"
	CONST_FSM_PREV_UPDATE_UCSMANAGER_START = "UpdateUCSManagerStart"
	CONST_FSM_PREV_UPDATE_UCSMANAGER_SUCCESS = "UpdateUCSManagerSuccess"
	CONST_FSM_PREV_NOP = "nop"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_2FA_AUTH_RETRY = "ERR-2fa-auth-retry"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_ACTIVATE_FAILED = "ERR-ACTIVATE-failed"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_ACTIVATE_IN_PROGRESS = "ERR-ACTIVATE-in-progress"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_ACTIVATE_RETRY = "ERR-ACTIVATE-retry"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_BIOS_TOKENS_OLD_BIOS = "ERR-BIOS-TOKENS-OLD-BIOS"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_BIOS_TOKENS_OLD_CIMC = "ERR-BIOS-TOKENS-OLD-CIMC"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_BIOS_NETWORK_BOOT_ORDER_NOT_FOUND = "ERR-BIOS-network-boot-order-not-found"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_BOARDCTRLUPDATE_IGNORE = "ERR-BOARDCTRLUPDATE-ignore"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DIAG_CANCELLED = "ERR-DIAG-cancelled"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DIAG_FSM_RESTARTED = "ERR-DIAG-fsm-restarted"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DIAG_TEST_FAILED = "ERR-DIAG-test-failed"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DNLD_AUTHENTICATION_FAILURE = "ERR-DNLD-authentication-failure"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DNLD_HOSTKEY_MISMATCH = "ERR-DNLD-hostkey-mismatch"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DNLD_INVALID_IMAGE = "ERR-DNLD-invalid-image"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DNLD_NO_FILE = "ERR-DNLD-no-file"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DNLD_NO_SPACE = "ERR-DNLD-no-space"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DNS_DELETE_ERROR = "ERR-DNS-delete-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DNS_GET_ERROR = "ERR-DNS-get-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DNS_SET_ERROR = "ERR-DNS-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DIAGNOSTICS_IN_PROGRESS = "ERR-Diagnostics-in-progress"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DIAGNOSTICS_MEMTEST_IN_PROGRESS = "ERR-Diagnostics-memtest-in-progress"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DIAGNOSTICS_NETWORK_IN_PROGRESS = "ERR-Diagnostics-network-in-progress"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_FILTER_ILLEGAL_FORMAT = "ERR-FILTER-illegal-format"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_FSM_NO_SUCH_STATE = "ERR-FSM-no-such-state"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_HOST_FRU_IDENTITY_MISMATCH = "ERR-HOST-fru-identity-mismatch"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_HTTP_SET_ERROR = "ERR-HTTP-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_HTTPS_SET_ERROR = "ERR-HTTPS-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_IBMC_ANALYZE_RESULTS = "ERR-IBMC-analyze-results"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_IBMC_CONNECT_ERROR = "ERR-IBMC-connect-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_IBMC_FRU_RETRIEVAL_ERROR = "ERR-IBMC-fru-retrieval-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_IBMC_INVALID_END_POINT_CONFIG = "ERR-IBMC-invalid-end-point-config"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_IBMC_RESULTS_NOT_READY = "ERR-IBMC-results-not-ready"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MAX_SUBSCRIPTIONS_ALLOWED_ERROR = "ERR-MAX-subscriptions-allowed-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_CONFIG_CHILD_OBJECT_CANT_BE_CONFIGURED = "ERR-MO-CONFIG-child-object-cant-be-configured"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_META_NO_SUCH_OBJECT_CLASS = "ERR-MO-META-no-such-object-class"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_PROPERTY_NO_SUCH_PROPERTY = "ERR-MO-PROPERTY-no-such-property"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_PROPERTY_VALUE_OUT_OF_RANGE = "ERR-MO-PROPERTY-value-out-of-range"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_ACCESS_DENIED = "ERR-MO-access-denied"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_DELETION_RULE_VIOLATION = "ERR-MO-deletion-rule-violation"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_DUPLICATE_OBJECT = "ERR-MO-duplicate-object"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_ILLEGAL_CONTAINMENT = "ERR-MO-illegal-containment"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_ILLEGAL_CREATION = "ERR-MO-illegal-creation"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_ILLEGAL_ITERATOR_STATE = "ERR-MO-illegal-iterator-state"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_ILLEGAL_OBJECT_LIFECYCLE_TRANSITION = "ERR-MO-illegal-object-lifecycle-transition"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_NAMING_RULE_VIOLATION = "ERR-MO-naming-rule-violation"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_OBJECT_NOT_FOUND = "ERR-MO-object-not-found"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_RESOURCE_ALLOCATION = "ERR-MO-resource-allocation"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_NTP_DELETE_ERROR = "ERR-NTP-delete-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_NTP_GET_ERROR = "ERR-NTP-get-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_NTP_SET_ERROR = "ERR-NTP-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_POWER_CAP_UNSUPPORTED = "ERR-POWER-CAP-UNSUPPORTED"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_SERVER_MIS_CONNECT = "ERR-SERVER-mis-connect"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_SWITCH_INVALID_IF_CONFIG = "ERR-SWITCH-invalid-if-config"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_TOKEN_REQUEST_DENIED = "ERR-TOKEN-request-denied"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_UNABLE_TO_FETCH_BIOS_SETTINGS = "ERR-UNABLE-TO-FETCH-BIOS-SETTINGS"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_UPDATE_FAILED = "ERR-UPDATE-failed"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_UPDATE_IN_PROGRESS = "ERR-UPDATE-in-progress"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_UPDATE_RETRY = "ERR-UPDATE-retry"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_AAA_CONFIG_MODIFY_ERROR = "ERR-aaa-config-modify-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_ACCT_REALM_SET_ERROR = "ERR-acct-realm-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_ADMIN_PASSWD_SET = "ERR-admin-passwd-set"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_AUTH_ISSUE = "ERR-auth-issue"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_AUTH_REALM_GET_ERROR = "ERR-auth-realm-get-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_AUTH_REALM_SET_ERROR = "ERR-auth-realm-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_AUTHENTICATION = "ERR-authentication"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_AUTHORIZATION_REQUIRED = "ERR-authorization-required"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_CLI_SESSION_LIMIT_REACHED = "ERR-cli-session-limit-reached"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_CREATE_KEYRING = "ERR-create-keyring"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_CREATE_LOCALE = "ERR-create-locale"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_CREATE_ROLE = "ERR-create-role"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_CREATE_USER = "ERR-create-user"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DELETE_LOCALE = "ERR-delete-locale"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DELETE_ROLE = "ERR-delete-role"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DELETE_SESSION = "ERR-delete-session"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DELETE_USER = "ERR-delete-user"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_EFI_DIAGNOSTICS_IN_PROGRESS = "ERR-efi-Diagnostics--in-progress"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_ENABLE_MGMT_CONN = "ERR-enable-mgmt-conn"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_EP_SET_ERROR = "ERR-ep-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_GET_MAX_HTTP_USER_SESSIONS = "ERR-get-max-http-user-sessions"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_HTTP_INITIALIZING = "ERR-http-initializing"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_INSUFFICIENTLY_EQUIPPED = "ERR-insufficiently-equipped"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_INTERNAL_ERROR = "ERR-internal-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_LDAP_DELETE_ERROR = "ERR-ldap-delete-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_LDAP_GET_ERROR = "ERR-ldap-get-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_LDAP_GROUP_MODIFY_ERROR = "ERR-ldap-group-modify-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_LDAP_GROUP_SET_ERROR = "ERR-ldap-group-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_LDAP_SET_ERROR = "ERR-ldap-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_LOCALE_SET_ERROR = "ERR-locale-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MAX_USERID_SESSIONS_REACHED = "ERR-max-userid-sessions-reached"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MISSING_METHOD = "ERR-missing-method"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MODIFY_LOCALE = "ERR-modify-locale"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MODIFY_ROLE = "ERR-modify-role"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MODIFY_USER = "ERR-modify-user"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MODIFY_USER_LOCALE = "ERR-modify-user-locale"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MODIFY_USER_ROLE = "ERR-modify-user-role"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_PROVIDER_GROUP_MODIFY_ERROR = "ERR-provider-group-modify-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_PROVIDER_GROUP_SET_ERROR = "ERR-provider-group-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_RADIUS_GET_ERROR = "ERR-radius-get-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_RADIUS_GLOBAL_SET_ERROR = "ERR-radius-global-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_RADIUS_GROUP_SET_ERROR = "ERR-radius-group-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_RADIUS_SET_ERROR = "ERR-radius-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_REQUEST_TIMEOUT = "ERR-request-timeout"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_RESET_ADAPTER = "ERR-reset-adapter"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_ROLE_SET_ERROR = "ERR-role-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_SECONDARY_NODE = "ERR-secondary-node"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_SERVICE_NOT_READY = "ERR-service-not-ready"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_SESSION_CACHE_FULL = "ERR-session-cache-full"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_SESSION_NOT_FOUND = "ERR-session-not-found"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_SET_NETWORK = "ERR-set-network"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_SET_PASSWORD_STRENGTH_CHECK = "ERR-set-password-strength-check"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_SET_PORT_CHANNEL = "ERR-set-port-channel"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_STORE_PRE_LOGIN_BANNER_MSG = "ERR-store-pre-login-banner-msg"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_TACACS_ENABLE_ERROR = "ERR-tacacs-enable-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_TACACS_GLOBAL_SET_ERROR = "ERR-tacacs-global-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_TACACS_GROUP_SET_ERROR = "ERR-tacacs-group-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_TACACS_PLUS_GET_ERROR = "ERR-tacacs-plus-get-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_TACACS_SET_ERROR = "ERR-tacacs-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_TEST_ERROR_1 = "ERR-test-error-1"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_TEST_ERROR_2 = "ERR-test-error-2"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_TIMEZONE_SET_ERROR = "ERR-timezone-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_USER_ACCOUNT_EXPIRED = "ERR-user-account-expired"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_USER_SET_ERROR = "ERR-user-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_XML_PARSE_ERROR = "ERR-xml-parse-error"
	CONST_FSM_RMT_INV_ERR_CODE_NONE = "none"
	CONST_FSM_STAMP_NEVER = "never"
	CONST_FSM_STATUS_ACTIVATE_BMCACTIVATE = "ActivateBMCActivate"
	CONST_FSM_STATUS_ACTIVATE_BMCBEGIN = "ActivateBMCBegin"
	CONST_FSM_STATUS_ACTIVATE_BMCFAIL = "ActivateBMCFail"
	CONST_FSM_STATUS_ACTIVATE_BMCRESET = "ActivateBMCReset"
	CONST_FSM_STATUS_ACTIVATE_BMCSUCCESS = "ActivateBMCSuccess"
	CONST_FSM_STATUS_ACTIVATE_IOMACTIVATE = "ActivateIOMActivate"
	CONST_FSM_STATUS_ACTIVATE_IOMBEGIN = "ActivateIOMBegin"
	CONST_FSM_STATUS_ACTIVATE_IOMFAIL = "ActivateIOMFail"
	CONST_FSM_STATUS_ACTIVATE_IOMRESET = "ActivateIOMReset"
	CONST_FSM_STATUS_ACTIVATE_IOMSUCCESS = "ActivateIOMSuccess"
	CONST_FSM_STATUS_EXT_MGMT_IF_CONFIG_BEGIN = "ExtMgmtIfConfigBegin"
	CONST_FSM_STATUS_EXT_MGMT_IF_CONFIG_FAIL = "ExtMgmtIfConfigFail"
	CONST_FSM_STATUS_EXT_MGMT_IF_CONFIG_PRIMARY = "ExtMgmtIfConfigPrimary"
	CONST_FSM_STATUS_EXT_MGMT_IF_CONFIG_SECONDARY = "ExtMgmtIfConfigSecondary"
	CONST_FSM_STATUS_EXT_MGMT_IF_CONFIG_SUCCESS = "ExtMgmtIfConfigSuccess"
	CONST_FSM_STATUS_EXT_MGMT_INTERFACE_CONFIG_ACTIVE = "ExtMgmtInterfaceConfigActive"
	CONST_FSM_STATUS_EXT_MGMT_INTERFACE_CONFIG_BEGIN = "ExtMgmtInterfaceConfigBegin"
	CONST_FSM_STATUS_EXT_MGMT_INTERFACE_CONFIG_CIMCVLAN_CFG_LOCAL = "ExtMgmtInterfaceConfigCIMCVlanCfgLocal"
	CONST_FSM_STATUS_EXT_MGMT_INTERFACE_CONFIG_CIMCVLAN_CFG_PEER = "ExtMgmtInterfaceConfigCIMCVlanCfgPeer"
	CONST_FSM_STATUS_EXT_MGMT_INTERFACE_CONFIG_CMCVLAN_CFG = "ExtMgmtInterfaceConfigCMCVlanCfg"
	CONST_FSM_STATUS_EXT_MGMT_INTERFACE_CONFIG_CMCVLAN_CFG_PEER = "ExtMgmtInterfaceConfigCMCVlanCfgPeer"
	CONST_FSM_STATUS_EXT_MGMT_INTERFACE_CONFIG_FAIL = "ExtMgmtInterfaceConfigFail"
	CONST_FSM_STATUS_EXT_MGMT_INTERFACE_CONFIG_SUCCESS = "ExtMgmtInterfaceConfigSuccess"
	CONST_FSM_STATUS_ONLINE_BEGIN = "OnlineBegin"
	CONST_FSM_STATUS_ONLINE_BMC_CONFIGURE_CONN_LOCAL = "OnlineBmcConfigureConnLocal"
	CONST_FSM_STATUS_ONLINE_BMC_CONFIGURE_CONN_PEER = "OnlineBmcConfigureConnPeer"
	CONST_FSM_STATUS_ONLINE_FAIL = "OnlineFail"
	CONST_FSM_STATUS_ONLINE_SUCCESS = "OnlineSuccess"
	CONST_FSM_STATUS_ONLINE_SW_CONFIGURE_CONN_LOCAL = "OnlineSwConfigureConnLocal"
	CONST_FSM_STATUS_ONLINE_SW_CONFIGURE_CONN_PEER = "OnlineSwConfigureConnPeer"
	CONST_FSM_STATUS_REGISTRY_CONFIG_BEGIN = "RegistryConfigBegin"
	CONST_FSM_STATUS_REGISTRY_CONFIG_FAIL = "RegistryConfigFail"
	CONST_FSM_STATUS_REGISTRY_CONFIG_REMOVE = "RegistryConfigRemove"
	CONST_FSM_STATUS_REGISTRY_CONFIG_SUCCESS = "RegistryConfigSuccess"
	CONST_FSM_STATUS_SYS_CONFIG_BEGIN = "SysConfigBegin"
	CONST_FSM_STATUS_SYS_CONFIG_FAIL = "SysConfigFail"
	CONST_FSM_STATUS_SYS_CONFIG_PRIMARY = "SysConfigPrimary"
	CONST_FSM_STATUS_SYS_CONFIG_SECONDARY = "SysConfigSecondary"
	CONST_FSM_STATUS_SYS_CONFIG_SUCCESS = "SysConfigSuccess"
	CONST_FSM_STATUS_UPDATE_BMCBEGIN = "UpdateBMCBegin"
	CONST_FSM_STATUS_UPDATE_BMCFAIL = "UpdateBMCFail"
	CONST_FSM_STATUS_UPDATE_BMCPOLL_UPDATE_STATUS = "UpdateBMCPollUpdateStatus"
	CONST_FSM_STATUS_UPDATE_BMCSUCCESS = "UpdateBMCSuccess"
	CONST_FSM_STATUS_UPDATE_BMCUPDATE_REQUEST = "UpdateBMCUpdateRequest"
	CONST_FSM_STATUS_UPDATE_IOMBEGIN = "UpdateIOMBegin"
	CONST_FSM_STATUS_UPDATE_IOMFAIL = "UpdateIOMFail"
	CONST_FSM_STATUS_UPDATE_IOMPOLL_UPDATE_STATUS = "UpdateIOMPollUpdateStatus"
	CONST_FSM_STATUS_UPDATE_IOMSUCCESS = "UpdateIOMSuccess"
	CONST_FSM_STATUS_UPDATE_IOMUPDATE_REQUEST = "UpdateIOMUpdateRequest"
	CONST_FSM_STATUS_UPDATE_SWITCH_BEGIN = "UpdateSwitchBegin"
	CONST_FSM_STATUS_UPDATE_SWITCH_COPY_TO_LOCAL = "UpdateSwitchCopyToLocal"
	CONST_FSM_STATUS_UPDATE_SWITCH_COPY_TO_PEER = "UpdateSwitchCopyToPeer"
	CONST_FSM_STATUS_UPDATE_SWITCH_FAIL = "UpdateSwitchFail"
	CONST_FSM_STATUS_UPDATE_SWITCH_RESET_LOCAL = "UpdateSwitchResetLocal"
	CONST_FSM_STATUS_UPDATE_SWITCH_RESET_REMOTE = "UpdateSwitchResetRemote"
	CONST_FSM_STATUS_UPDATE_SWITCH_SUCCESS = "UpdateSwitchSuccess"
	CONST_FSM_STATUS_UPDATE_SWITCH_UPDATE_LOCAL = "UpdateSwitchUpdateLocal"
	CONST_FSM_STATUS_UPDATE_SWITCH_UPDATE_REMOTE = "UpdateSwitchUpdateRemote"
	CONST_FSM_STATUS_UPDATE_SWITCH_VERIFY_LOCAL = "UpdateSwitchVerifyLocal"
	CONST_FSM_STATUS_UPDATE_SWITCH_VERIFY_REMOTE = "UpdateSwitchVerifyRemote"
	CONST_FSM_STATUS_UPDATE_UCSMANAGER_BEGIN = "UpdateUCSManagerBegin"
	CONST_FSM_STATUS_UPDATE_UCSMANAGER_COPY_EXT_TO_LOCAL = "UpdateUCSManagerCopyExtToLocal"
	CONST_FSM_STATUS_UPDATE_UCSMANAGER_COPY_EXT_TO_PEER = "UpdateUCSManagerCopyExtToPeer"
	CONST_FSM_STATUS_UPDATE_UCSMANAGER_EXECUTE = "UpdateUCSManagerExecute"
	CONST_FSM_STATUS_UPDATE_UCSMANAGER_FAIL = "UpdateUCSManagerFail"
	CONST_FSM_STATUS_UPDATE_UCSMANAGER_START = "UpdateUCSManagerStart"
	CONST_FSM_STATUS_UPDATE_UCSMANAGER_SUCCESS = "UpdateUCSManagerSuccess"
	CONST_FSM_STATUS_NOP = "nop"
	CONST_STORAGE_OOB_INTERFACE_SUPPORTED_FALSE = "false"
	CONST_STORAGE_OOB_INTERFACE_SUPPORTED_NO = "no"
	CONST_STORAGE_OOB_INTERFACE_SUPPORTED_TRUE = "true"
	CONST_STORAGE_OOB_INTERFACE_SUPPORTED_YES = "yes"
	CONST_STORAGE_SUBSYSTEM_STATE_INITIALIZED = "initialized"
	CONST_STORAGE_SUBSYSTEM_STATE_INITIALIZING = "initializing"
	CONST_STORAGE_SUBSYSTEM_STATE_UNINITIALIZED = "uninitialized"
	CONST_STORAGE_SUBSYSTEM_STATE_UNKNOWN = "unknown"
	CONST_STORAGE_SUBSYSTEM_STATE_UNSUPPORTED = "unsupported"
	CONST_SUBJECT_ADAPTOR = "adaptor"
	CONST_SUBJECT_BLADE = "blade"
	CONST_SUBJECT_BOARD_CONTROLLER = "board-controller"
	CONST_SUBJECT_CHASSIS = "chassis"
	CONST_SUBJECT_IOCARD = "iocard"
	CONST_SUBJECT_SWITCH = "switch"
	CONST_SUBJECT_SYSTEM = "system"
	CONST_SUBJECT_UNKNOWN = "unknown"

class AaaRole(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"AaaRole")

	@staticmethod
	def ClassId():
		return "aaaRole"

	CONFIG_STATE = "ConfigState"
	CONFIG_STATUS_MESSAGE = "ConfigStatusMessage"
	DESCR = "Descr"
	DN = "Dn"
	NAME = "Name"
	POLICY_LEVEL = "PolicyLevel"
	POLICY_OWNER = "PolicyOwner"
	PRIV = "Priv"
	RN = "Rn"
	STATUS = "Status"

	CONST_CONFIG_STATE_NOT_APPLIED = "not-applied"
	CONST_CONFIG_STATE_OK = "ok"
	CONST_INT_ID_NONE = "none"
	CONST_POLICY_OWNER_LOCAL = "local"
	CONST_POLICY_OWNER_PENDING_POLICY = "pending-policy"
	CONST_POLICY_OWNER_POLICY = "policy"

class AdaptorEthPortOutsizedStatsHist(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"AdaptorEthPortOutsizedStatsHist")

	@staticmethod
	def ClassId():
		return "adaptorEthPortOutsizedStatsHist"

	DN = "Dn"
	ID = "Id"
	MOST_RECENT = "MostRecent"
	OVERSIZED_BAD_CRC_PACKETS = "OversizedBadCrcPackets"
	OVERSIZED_BAD_CRC_PACKETS_DELTA = "OversizedBadCrcPacketsDelta"
	OVERSIZED_BAD_CRC_PACKETS_DELTA_AVG = "OversizedBadCrcPacketsDeltaAvg"
	OVERSIZED_BAD_CRC_PACKETS_DELTA_MAX = "OversizedBadCrcPacketsDeltaMax"
	OVERSIZED_BAD_CRC_PACKETS_DELTA_MIN = "OversizedBadCrcPacketsDeltaMin"
	OVERSIZED_GOOD_CRC_PACKETS = "OversizedGoodCrcPackets"
	OVERSIZED_GOOD_CRC_PACKETS_DELTA = "OversizedGoodCrcPacketsDelta"
	OVERSIZED_GOOD_CRC_PACKETS_DELTA_AVG = "OversizedGoodCrcPacketsDeltaAvg"
	OVERSIZED_GOOD_CRC_PACKETS_DELTA_MAX = "OversizedGoodCrcPacketsDeltaMax"
	OVERSIZED_GOOD_CRC_PACKETS_DELTA_MIN = "OversizedGoodCrcPacketsDeltaMin"
	OVERSIZED_PACKETS = "OversizedPackets"
	OVERSIZED_PACKETS_DELTA = "OversizedPacketsDelta"
	OVERSIZED_PACKETS_DELTA_AVG = "OversizedPacketsDeltaAvg"
	OVERSIZED_PACKETS_DELTA_MAX = "OversizedPacketsDeltaMax"
	OVERSIZED_PACKETS_DELTA_MIN = "OversizedPacketsDeltaMin"
	RN = "Rn"
	STATUS = "Status"
	SUSPECT = "Suspect"
	THRESHOLDED = "Thresholded"
	TIME_COLLECTED = "TimeCollected"
	UNDERSIZED_BAD_CRC_PACKETS = "UndersizedBadCrcPackets"
	UNDERSIZED_BAD_CRC_PACKETS_DELTA = "UndersizedBadCrcPacketsDelta"
	UNDERSIZED_BAD_CRC_PACKETS_DELTA_AVG = "UndersizedBadCrcPacketsDeltaAvg"
	UNDERSIZED_BAD_CRC_PACKETS_DELTA_MAX = "UndersizedBadCrcPacketsDeltaMax"
	UNDERSIZED_BAD_CRC_PACKETS_DELTA_MIN = "UndersizedBadCrcPacketsDeltaMin"
	UNDERSIZED_GOOD_CRC_PACKETS = "UndersizedGoodCrcPackets"
	UNDERSIZED_GOOD_CRC_PACKETS_DELTA = "UndersizedGoodCrcPacketsDelta"
	UNDERSIZED_GOOD_CRC_PACKETS_DELTA_AVG = "UndersizedGoodCrcPacketsDeltaAvg"
	UNDERSIZED_GOOD_CRC_PACKETS_DELTA_MAX = "UndersizedGoodCrcPacketsDeltaMax"
	UNDERSIZED_GOOD_CRC_PACKETS_DELTA_MIN = "UndersizedGoodCrcPacketsDeltaMin"

	CONST_MOST_RECENT_FALSE = "false"
	CONST_MOST_RECENT_NO = "no"
	CONST_MOST_RECENT_TRUE = "true"
	CONST_MOST_RECENT_YES = "yes"
	CONST_SUSPECT_FALSE = "false"
	CONST_SUSPECT_NO = "no"
	CONST_SUSPECT_TRUE = "true"
	CONST_SUSPECT_YES = "yes"

class StorageInitiator(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"StorageInitiator")

	@staticmethod
	def ClassId():
		return "storageInitiator"

	DESCR = "Descr"
	DN = "Dn"
	DUPLICATE_TARGET = "DuplicateTarget"
	NAME = "Name"
	OPER_STATE = "OperState"
	POLICY_LEVEL = "PolicyLevel"
	POLICY_OWNER = "PolicyOwner"
	RN = "Rn"
	STATUS = "Status"

	CONST_INT_ID_NONE = "none"
	CONST_OPER_STATE_MISCONFIGURED = "misconfigured"
	CONST_OPER_STATE_OK = "ok"
	CONST_POLICY_OWNER_LOCAL = "local"
	CONST_POLICY_OWNER_PENDING_POLICY = "pending-policy"
	CONST_POLICY_OWNER_POLICY = "policy"

class EquipmentSlotArrayRef(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"EquipmentSlotArrayRef")

	@staticmethod
	def ClassId():
		return "equipmentSlotArrayRef"

	DESCR = "Descr"
	DN = "Dn"
	NAME = "Name"
	NUMBER_OF_SLOTS_SPANNED = "NumberOfSlotsSpanned"
	POLICY_LEVEL = "PolicyLevel"
	POLICY_OWNER = "PolicyOwner"
	RN = "Rn"
	SLOT_SPAN_ORIENTATION = "SlotSpanOrientation"
	STATUS = "Status"
	TARGET_DN = "TargetDn"

	CONST_INT_ID_NONE = "none"
	CONST_POLICY_OWNER_LOCAL = "local"
	CONST_POLICY_OWNER_PENDING_POLICY = "pending-policy"
	CONST_POLICY_OWNER_POLICY = "policy"
	CONST_SLOT_SPAN_ORIENTATION_INLINE = "inline"
	CONST_SLOT_SPAN_ORIENTATION_TRANSVERSE = "transverse"
	CONST_SLOT_SPAN_ORIENTATION_UNKNOWN = "unknown"

class FirmwarePackItem(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"FirmwarePackItem")

	@staticmethod
	def ClassId():
		return "firmwarePackItem"

	DN = "Dn"
	HW_MODEL = "HwModel"
	HW_VENDOR = "HwVendor"
	PRESENCE = "Presence"
	RN = "Rn"
	STATUS = "Status"
	TYPE = "Type"
	VERSION = "Version"

	CONST_PRESENCE_MISSING = "missing"
	CONST_PRESENCE_PRESENT = "present"
	CONST_PRESENCE_UNKNOWN = "unknown"
	CONST_TYPE_ADAPTOR = "adaptor"
	CONST_TYPE_BLADE_BIOS = "blade-bios"
	CONST_TYPE_BLADE_CONTROLLER = "blade-controller"
	CONST_TYPE_BOARD_CONTROLLER = "board-controller"
	CONST_TYPE_FLEXFLASH_CONTROLLER = "flexflash-controller"
	CONST_TYPE_HOST_HBA = "host-hba"
	CONST_TYPE_HOST_HBA_OPTIONROM = "host-hba-optionrom"
	CONST_TYPE_HOST_NIC = "host-nic"
	CONST_TYPE_HOST_NIC_OPTIONROM = "host-nic-optionrom"
	CONST_TYPE_IOCARD = "iocard"
	CONST_TYPE_LOCAL_DISK = "local-disk"
	CONST_TYPE_STORAGE_CONTROLLER = "storage-controller"
	CONST_TYPE_SWITCH_KERNEL = "switch-kernel"
	CONST_TYPE_SWITCH_SOFTWARE = "switch-software"
	CONST_TYPE_SYSTEM = "system"
	CONST_TYPE_UNSPECIFIED = "unspecified"

class AdaptorEthPortBySizeLargeStatsHist(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"AdaptorEthPortBySizeLargeStatsHist")

	@staticmethod
	def ClassId():
		return "adaptorEthPortBySizeLargeStatsHist"

	DN = "Dn"
	GREATER_THAN_OR_EQUAL_TO9216 = "GreaterThanOrEqualTo9216"
	GREATER_THAN_OR_EQUAL_TO9216_DELTA = "GreaterThanOrEqualTo9216Delta"
	GREATER_THAN_OR_EQUAL_TO9216_DELTA_AVG = "GreaterThanOrEqualTo9216DeltaAvg"
	GREATER_THAN_OR_EQUAL_TO9216_DELTA_MAX = "GreaterThanOrEqualTo9216DeltaMax"
	GREATER_THAN_OR_EQUAL_TO9216_DELTA_MIN = "GreaterThanOrEqualTo9216DeltaMin"
	ID = "Id"
	LESS_THAN2048 = "LessThan2048"
	LESS_THAN2048_DELTA = "LessThan2048Delta"
	LESS_THAN2048_DELTA_AVG = "LessThan2048DeltaAvg"
	LESS_THAN2048_DELTA_MAX = "LessThan2048DeltaMax"
	LESS_THAN2048_DELTA_MIN = "LessThan2048DeltaMin"
	LESS_THAN4096 = "LessThan4096"
	LESS_THAN4096_DELTA = "LessThan4096Delta"
	LESS_THAN4096_DELTA_AVG = "LessThan4096DeltaAvg"
	LESS_THAN4096_DELTA_MAX = "LessThan4096DeltaMax"
	LESS_THAN4096_DELTA_MIN = "LessThan4096DeltaMin"
	LESS_THAN8192 = "LessThan8192"
	LESS_THAN8192_DELTA = "LessThan8192Delta"
	LESS_THAN8192_DELTA_AVG = "LessThan8192DeltaAvg"
	LESS_THAN8192_DELTA_MAX = "LessThan8192DeltaMax"
	LESS_THAN8192_DELTA_MIN = "LessThan8192DeltaMin"
	LESS_THAN9216 = "LessThan9216"
	LESS_THAN9216_DELTA = "LessThan9216Delta"
	LESS_THAN9216_DELTA_AVG = "LessThan9216DeltaAvg"
	LESS_THAN9216_DELTA_MAX = "LessThan9216DeltaMax"
	LESS_THAN9216_DELTA_MIN = "LessThan9216DeltaMin"
	LESS_THAN_OR_EQUAL_TO1518 = "LessThanOrEqualTo1518"
	LESS_THAN_OR_EQUAL_TO1518_DELTA = "LessThanOrEqualTo1518Delta"
	LESS_THAN_OR_EQUAL_TO1518_DELTA_AVG = "LessThanOrEqualTo1518DeltaAvg"
	LESS_THAN_OR_EQUAL_TO1518_DELTA_MAX = "LessThanOrEqualTo1518DeltaMax"
	LESS_THAN_OR_EQUAL_TO1518_DELTA_MIN = "LessThanOrEqualTo1518DeltaMin"
	MOST_RECENT = "MostRecent"
	NO_BREAKDOWN_GREATER_THAN1518 = "NoBreakdownGreaterThan1518"
	NO_BREAKDOWN_GREATER_THAN1518_DELTA = "NoBreakdownGreaterThan1518Delta"
	NO_BREAKDOWN_GREATER_THAN1518_DELTA_AVG = "NoBreakdownGreaterThan1518DeltaAvg"
	NO_BREAKDOWN_GREATER_THAN1518_DELTA_MAX = "NoBreakdownGreaterThan1518DeltaMax"
	NO_BREAKDOWN_GREATER_THAN1518_DELTA_MIN = "NoBreakdownGreaterThan1518DeltaMin"
	RN = "Rn"
	STATUS = "Status"
	SUSPECT = "Suspect"
	THRESHOLDED = "Thresholded"
	TIME_COLLECTED = "TimeCollected"

	CONST_MOST_RECENT_FALSE = "false"
	CONST_MOST_RECENT_NO = "no"
	CONST_MOST_RECENT_TRUE = "true"
	CONST_MOST_RECENT_YES = "yes"
	CONST_SUSPECT_FALSE = "false"
	CONST_SUSPECT_NO = "no"
	CONST_SUSPECT_TRUE = "true"
	CONST_SUSPECT_YES = "yes"

class SwFcSanMon(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"SwFcSanMon")

	@staticmethod
	def ClassId():
		return "swFcSanMon"

	DN = "Dn"
	LOCALE = "Locale"
	NAME = "Name"
	RN = "Rn"
	STATUS = "Status"
	SWITCH_ID = "SwitchId"
	TRANSPORT = "Transport"
	TYPE = "Type"

	CONST_SWITCH_ID_A = "A"
	CONST_SWITCH_ID_B = "B"
	CONST_SWITCH_ID_NONE = "NONE"

class QosclassFc(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"QosclassFc")

	@staticmethod
	def ClassId():
		return "qosclassFc"

	ADMIN_STATE = "AdminState"
	BW_PERCENT = "BwPercent"
	COS = "Cos"
	DN = "Dn"
	DROP = "Drop"
	MTU = "Mtu"
	NAME = "Name"
	PRIORITY = "Priority"
	RN = "Rn"
	STATUS = "Status"
	WEIGHT = "Weight"

	CONST_ADMIN_STATE_DISABLED = "disabled"
	CONST_ADMIN_STATE_ENABLED = "enabled"
	CONST_BW_PERCENT_NOT_APPLICABLE = "not-applicable"
	CONST_COS_ANY = "any"
	CONST_DROP_DROP = "drop"
	CONST_DROP_NO_DROP = "no-drop"
	CONST_MTU_FC = "fc"
	CONST_MTU_NORMAL = "normal"
	CONST_PRIORITY_BEST_EFFORT = "best-effort"
	CONST_PRIORITY_BRONZE = "bronze"
	CONST_PRIORITY_FC = "fc"
	CONST_PRIORITY_GOLD = "gold"
	CONST_PRIORITY_PLATINUM = "platinum"
	CONST_PRIORITY_SILVER = "silver"
	CONST_WEIGHT_BEST_EFFORT = "best-effort"
	CONST_WEIGHT_NONE = "none"

class EquipmentFanModuleStats(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"EquipmentFanModuleStats")

	@staticmethod
	def ClassId():
		return "equipmentFanModuleStats"

	AMBIENT_TEMP = "AmbientTemp"
	AMBIENT_TEMP_AVG = "AmbientTempAvg"
	AMBIENT_TEMP_MAX = "AmbientTempMax"
	AMBIENT_TEMP_MIN = "AmbientTempMin"
	DN = "Dn"
	INTERVALS = "Intervals"
	RN = "Rn"
	STATUS = "Status"
	SUSPECT = "Suspect"
	THRESHOLDED = "Thresholded"
	TIME_COLLECTED = "TimeCollected"
	UPDATE = "Update"

	CONST_AMBIENT_TEMP_NOT_APPLICABLE = "not-applicable"
	CONST_AMBIENT_TEMP_AVG_NOT_APPLICABLE = "not-applicable"
	CONST_AMBIENT_TEMP_MAX_NOT_APPLICABLE = "not-applicable"
	CONST_AMBIENT_TEMP_MIN_NOT_APPLICABLE = "not-applicable"
	CONST_SUSPECT_FALSE = "false"
	CONST_SUSPECT_NO = "no"
	CONST_SUSPECT_TRUE = "true"
	CONST_SUSPECT_YES = "yes"

class StatsThrFloatDefinition(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"StatsThrFloatDefinition")

	@staticmethod
	def ClassId():
		return "statsThrFloatDefinition"

	DESCR = "Descr"
	DN = "Dn"
	NAME = "Name"
	NORMAL_VALUE = "NormalValue"
	POLICY_LEVEL = "PolicyLevel"
	POLICY_OWNER = "PolicyOwner"
	PROP_ID = "PropId"
	PROP_TYPE = "PropType"
	RN = "Rn"
	STATUS = "Status"

	CONST_INT_ID_NONE = "none"
	CONST_POLICY_OWNER_LOCAL = "local"
	CONST_POLICY_OWNER_PENDING_POLICY = "pending-policy"
	CONST_POLICY_OWNER_POLICY = "policy"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATSGREATER_THAN_OR_EQUAL_TO9216_DELTA = "adaptorEthPortBySizeLargeStatsgreaterThanOrEqualTo9216Delta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATSGREATER_THAN_OR_EQUAL_TO9216_DELTA_AVG = "adaptorEthPortBySizeLargeStatsgreaterThanOrEqualTo9216DeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATSGREATER_THAN_OR_EQUAL_TO9216_DELTA_MAX = "adaptorEthPortBySizeLargeStatsgreaterThanOrEqualTo9216DeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATSGREATER_THAN_OR_EQUAL_TO9216_DELTA_MIN = "adaptorEthPortBySizeLargeStatsgreaterThanOrEqualTo9216DeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATSLESS_THAN2048_DELTA = "adaptorEthPortBySizeLargeStatslessThan2048Delta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATSLESS_THAN2048_DELTA_AVG = "adaptorEthPortBySizeLargeStatslessThan2048DeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATSLESS_THAN2048_DELTA_MAX = "adaptorEthPortBySizeLargeStatslessThan2048DeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATSLESS_THAN2048_DELTA_MIN = "adaptorEthPortBySizeLargeStatslessThan2048DeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATSLESS_THAN4096_DELTA = "adaptorEthPortBySizeLargeStatslessThan4096Delta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATSLESS_THAN4096_DELTA_AVG = "adaptorEthPortBySizeLargeStatslessThan4096DeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATSLESS_THAN4096_DELTA_MAX = "adaptorEthPortBySizeLargeStatslessThan4096DeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATSLESS_THAN4096_DELTA_MIN = "adaptorEthPortBySizeLargeStatslessThan4096DeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATSLESS_THAN8192_DELTA = "adaptorEthPortBySizeLargeStatslessThan8192Delta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATSLESS_THAN8192_DELTA_AVG = "adaptorEthPortBySizeLargeStatslessThan8192DeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATSLESS_THAN8192_DELTA_MAX = "adaptorEthPortBySizeLargeStatslessThan8192DeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATSLESS_THAN8192_DELTA_MIN = "adaptorEthPortBySizeLargeStatslessThan8192DeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATSLESS_THAN9216_DELTA = "adaptorEthPortBySizeLargeStatslessThan9216Delta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATSLESS_THAN9216_DELTA_AVG = "adaptorEthPortBySizeLargeStatslessThan9216DeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATSLESS_THAN9216_DELTA_MAX = "adaptorEthPortBySizeLargeStatslessThan9216DeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATSLESS_THAN9216_DELTA_MIN = "adaptorEthPortBySizeLargeStatslessThan9216DeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATSLESS_THAN_OR_EQUAL_TO1518_DELTA = "adaptorEthPortBySizeLargeStatslessThanOrEqualTo1518Delta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATSLESS_THAN_OR_EQUAL_TO1518_DELTA_AVG = "adaptorEthPortBySizeLargeStatslessThanOrEqualTo1518DeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATSLESS_THAN_OR_EQUAL_TO1518_DELTA_MAX = "adaptorEthPortBySizeLargeStatslessThanOrEqualTo1518DeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATSLESS_THAN_OR_EQUAL_TO1518_DELTA_MIN = "adaptorEthPortBySizeLargeStatslessThanOrEqualTo1518DeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATSNO_BREAKDOWN_GREATER_THAN1518_DELTA = "adaptorEthPortBySizeLargeStatsnoBreakdownGreaterThan1518Delta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATSNO_BREAKDOWN_GREATER_THAN1518_DELTA_AVG = "adaptorEthPortBySizeLargeStatsnoBreakdownGreaterThan1518DeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATSNO_BREAKDOWN_GREATER_THAN1518_DELTA_MAX = "adaptorEthPortBySizeLargeStatsnoBreakdownGreaterThan1518DeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATSNO_BREAKDOWN_GREATER_THAN1518_DELTA_MIN = "adaptorEthPortBySizeLargeStatsnoBreakdownGreaterThan1518DeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATSEQUALS64_DELTA = "adaptorEthPortBySizeSmallStatsequals64Delta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATSEQUALS64_DELTA_AVG = "adaptorEthPortBySizeSmallStatsequals64DeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATSEQUALS64_DELTA_MAX = "adaptorEthPortBySizeSmallStatsequals64DeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATSEQUALS64_DELTA_MIN = "adaptorEthPortBySizeSmallStatsequals64DeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATSLESS_THAN1024_DELTA = "adaptorEthPortBySizeSmallStatslessThan1024Delta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATSLESS_THAN1024_DELTA_AVG = "adaptorEthPortBySizeSmallStatslessThan1024DeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATSLESS_THAN1024_DELTA_MAX = "adaptorEthPortBySizeSmallStatslessThan1024DeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATSLESS_THAN1024_DELTA_MIN = "adaptorEthPortBySizeSmallStatslessThan1024DeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATSLESS_THAN128_DELTA = "adaptorEthPortBySizeSmallStatslessThan128Delta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATSLESS_THAN128_DELTA_AVG = "adaptorEthPortBySizeSmallStatslessThan128DeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATSLESS_THAN128_DELTA_MAX = "adaptorEthPortBySizeSmallStatslessThan128DeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATSLESS_THAN128_DELTA_MIN = "adaptorEthPortBySizeSmallStatslessThan128DeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATSLESS_THAN256_DELTA = "adaptorEthPortBySizeSmallStatslessThan256Delta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATSLESS_THAN256_DELTA_AVG = "adaptorEthPortBySizeSmallStatslessThan256DeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATSLESS_THAN256_DELTA_MAX = "adaptorEthPortBySizeSmallStatslessThan256DeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATSLESS_THAN256_DELTA_MIN = "adaptorEthPortBySizeSmallStatslessThan256DeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATSLESS_THAN512_DELTA = "adaptorEthPortBySizeSmallStatslessThan512Delta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATSLESS_THAN512_DELTA_AVG = "adaptorEthPortBySizeSmallStatslessThan512DeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATSLESS_THAN512_DELTA_MAX = "adaptorEthPortBySizeSmallStatslessThan512DeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATSLESS_THAN512_DELTA_MIN = "adaptorEthPortBySizeSmallStatslessThan512DeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATSLESS_THAN64_DELTA = "adaptorEthPortBySizeSmallStatslessThan64Delta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATSLESS_THAN64_DELTA_AVG = "adaptorEthPortBySizeSmallStatslessThan64DeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATSLESS_THAN64_DELTA_MAX = "adaptorEthPortBySizeSmallStatslessThan64DeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATSLESS_THAN64_DELTA_MIN = "adaptorEthPortBySizeSmallStatslessThan64DeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_ERR_STATSBAD_CRC_PACKETS_DELTA = "adaptorEthPortErrStatsbadCrcPacketsDelta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_ERR_STATSBAD_CRC_PACKETS_DELTA_AVG = "adaptorEthPortErrStatsbadCrcPacketsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_ERR_STATSBAD_CRC_PACKETS_DELTA_MAX = "adaptorEthPortErrStatsbadCrcPacketsDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_ERR_STATSBAD_CRC_PACKETS_DELTA_MIN = "adaptorEthPortErrStatsbadCrcPacketsDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_ERR_STATSBAD_LENGTH_PACKETS_DELTA = "adaptorEthPortErrStatsbadLengthPacketsDelta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_ERR_STATSBAD_LENGTH_PACKETS_DELTA_AVG = "adaptorEthPortErrStatsbadLengthPacketsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_ERR_STATSBAD_LENGTH_PACKETS_DELTA_MAX = "adaptorEthPortErrStatsbadLengthPacketsDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_ERR_STATSBAD_LENGTH_PACKETS_DELTA_MIN = "adaptorEthPortErrStatsbadLengthPacketsDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_ERR_STATSMAC_DISCARDED_PACKETS_DELTA = "adaptorEthPortErrStatsmacDiscardedPacketsDelta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_ERR_STATSMAC_DISCARDED_PACKETS_DELTA_AVG = "adaptorEthPortErrStatsmacDiscardedPacketsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_ERR_STATSMAC_DISCARDED_PACKETS_DELTA_MAX = "adaptorEthPortErrStatsmacDiscardedPacketsDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_ERR_STATSMAC_DISCARDED_PACKETS_DELTA_MIN = "adaptorEthPortErrStatsmacDiscardedPacketsDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_MCAST_STATSBROADCAST_PACKETS_DELTA = "adaptorEthPortMcastStatsbroadcastPacketsDelta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_MCAST_STATSBROADCAST_PACKETS_DELTA_AVG = "adaptorEthPortMcastStatsbroadcastPacketsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_MCAST_STATSBROADCAST_PACKETS_DELTA_MAX = "adaptorEthPortMcastStatsbroadcastPacketsDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_MCAST_STATSBROADCAST_PACKETS_DELTA_MIN = "adaptorEthPortMcastStatsbroadcastPacketsDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_MCAST_STATSMULTICAST_PACKETS_DELTA = "adaptorEthPortMcastStatsmulticastPacketsDelta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_MCAST_STATSMULTICAST_PACKETS_DELTA_AVG = "adaptorEthPortMcastStatsmulticastPacketsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_MCAST_STATSMULTICAST_PACKETS_DELTA_MAX = "adaptorEthPortMcastStatsmulticastPacketsDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_MCAST_STATSMULTICAST_PACKETS_DELTA_MIN = "adaptorEthPortMcastStatsmulticastPacketsDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_MCAST_STATSUNICAST_PACKETS_DELTA = "adaptorEthPortMcastStatsunicastPacketsDelta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_MCAST_STATSUNICAST_PACKETS_DELTA_AVG = "adaptorEthPortMcastStatsunicastPacketsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_MCAST_STATSUNICAST_PACKETS_DELTA_MAX = "adaptorEthPortMcastStatsunicastPacketsDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_MCAST_STATSUNICAST_PACKETS_DELTA_MIN = "adaptorEthPortMcastStatsunicastPacketsDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATSOVERSIZED_BAD_CRC_PACKETS_DELTA = "adaptorEthPortOutsizedStatsoversizedBadCrcPacketsDelta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATSOVERSIZED_BAD_CRC_PACKETS_DELTA_AVG = "adaptorEthPortOutsizedStatsoversizedBadCrcPacketsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATSOVERSIZED_BAD_CRC_PACKETS_DELTA_MAX = "adaptorEthPortOutsizedStatsoversizedBadCrcPacketsDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATSOVERSIZED_BAD_CRC_PACKETS_DELTA_MIN = "adaptorEthPortOutsizedStatsoversizedBadCrcPacketsDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATSOVERSIZED_GOOD_CRC_PACKETS_DELTA = "adaptorEthPortOutsizedStatsoversizedGoodCrcPacketsDelta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATSOVERSIZED_GOOD_CRC_PACKETS_DELTA_AVG = "adaptorEthPortOutsizedStatsoversizedGoodCrcPacketsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATSOVERSIZED_GOOD_CRC_PACKETS_DELTA_MAX = "adaptorEthPortOutsizedStatsoversizedGoodCrcPacketsDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATSOVERSIZED_GOOD_CRC_PACKETS_DELTA_MIN = "adaptorEthPortOutsizedStatsoversizedGoodCrcPacketsDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATSOVERSIZED_PACKETS_DELTA = "adaptorEthPortOutsizedStatsoversizedPacketsDelta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATSOVERSIZED_PACKETS_DELTA_AVG = "adaptorEthPortOutsizedStatsoversizedPacketsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATSOVERSIZED_PACKETS_DELTA_MAX = "adaptorEthPortOutsizedStatsoversizedPacketsDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATSOVERSIZED_PACKETS_DELTA_MIN = "adaptorEthPortOutsizedStatsoversizedPacketsDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATSUNDERSIZED_BAD_CRC_PACKETS_DELTA = "adaptorEthPortOutsizedStatsundersizedBadCrcPacketsDelta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATSUNDERSIZED_BAD_CRC_PACKETS_DELTA_AVG = "adaptorEthPortOutsizedStatsundersizedBadCrcPacketsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATSUNDERSIZED_BAD_CRC_PACKETS_DELTA_MAX = "adaptorEthPortOutsizedStatsundersizedBadCrcPacketsDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATSUNDERSIZED_BAD_CRC_PACKETS_DELTA_MIN = "adaptorEthPortOutsizedStatsundersizedBadCrcPacketsDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATSUNDERSIZED_GOOD_CRC_PACKETS_DELTA = "adaptorEthPortOutsizedStatsundersizedGoodCrcPacketsDelta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATSUNDERSIZED_GOOD_CRC_PACKETS_DELTA_AVG = "adaptorEthPortOutsizedStatsundersizedGoodCrcPacketsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATSUNDERSIZED_GOOD_CRC_PACKETS_DELTA_MAX = "adaptorEthPortOutsizedStatsundersizedGoodCrcPacketsDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATSUNDERSIZED_GOOD_CRC_PACKETS_DELTA_MIN = "adaptorEthPortOutsizedStatsundersizedGoodCrcPacketsDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATSGOOD_PACKETS_DELTA = "adaptorEthPortStatsgoodPacketsDelta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATSGOOD_PACKETS_DELTA_AVG = "adaptorEthPortStatsgoodPacketsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATSGOOD_PACKETS_DELTA_MAX = "adaptorEthPortStatsgoodPacketsDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATSGOOD_PACKETS_DELTA_MIN = "adaptorEthPortStatsgoodPacketsDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATSPAUSE_PACKETS_DELTA = "adaptorEthPortStatspausePacketsDelta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATSPAUSE_PACKETS_DELTA_AVG = "adaptorEthPortStatspausePacketsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATSPAUSE_PACKETS_DELTA_MAX = "adaptorEthPortStatspausePacketsDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATSPAUSE_PACKETS_DELTA_MIN = "adaptorEthPortStatspausePacketsDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATSPER_PRIORITY_PAUSE_PACKETS_DELTA = "adaptorEthPortStatsperPriorityPausePacketsDelta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATSPER_PRIORITY_PAUSE_PACKETS_DELTA_AVG = "adaptorEthPortStatsperPriorityPausePacketsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATSPER_PRIORITY_PAUSE_PACKETS_DELTA_MAX = "adaptorEthPortStatsperPriorityPausePacketsDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATSPER_PRIORITY_PAUSE_PACKETS_DELTA_MIN = "adaptorEthPortStatsperPriorityPausePacketsDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATSPPP_PACKETS_DELTA = "adaptorEthPortStatspppPacketsDelta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATSPPP_PACKETS_DELTA_AVG = "adaptorEthPortStatspppPacketsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATSPPP_PACKETS_DELTA_MAX = "adaptorEthPortStatspppPacketsDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATSPPP_PACKETS_DELTA_MIN = "adaptorEthPortStatspppPacketsDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATSTOTAL_PACKETS_DELTA = "adaptorEthPortStatstotalPacketsDelta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATSTOTAL_PACKETS_DELTA_AVG = "adaptorEthPortStatstotalPacketsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATSTOTAL_PACKETS_DELTA_MAX = "adaptorEthPortStatstotalPacketsDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATSTOTAL_PACKETS_DELTA_MIN = "adaptorEthPortStatstotalPacketsDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATSVLAN_PACKETS_DELTA = "adaptorEthPortStatsvlanPacketsDelta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATSVLAN_PACKETS_DELTA_AVG = "adaptorEthPortStatsvlanPacketsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATSVLAN_PACKETS_DELTA_MAX = "adaptorEthPortStatsvlanPacketsDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATSVLAN_PACKETS_DELTA_MIN = "adaptorEthPortStatsvlanPacketsDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATSRX_BYTES_DELTA = "adaptorEtherIfStatsrxBytesDelta"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATSRX_BYTES_DELTA_AVG = "adaptorEtherIfStatsrxBytesDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATSRX_BYTES_DELTA_MAX = "adaptorEtherIfStatsrxBytesDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATSRX_BYTES_DELTA_MIN = "adaptorEtherIfStatsrxBytesDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATSRX_DROPPED_DELTA = "adaptorEtherIfStatsrxDroppedDelta"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATSRX_DROPPED_DELTA_AVG = "adaptorEtherIfStatsrxDroppedDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATSRX_DROPPED_DELTA_MAX = "adaptorEtherIfStatsrxDroppedDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATSRX_DROPPED_DELTA_MIN = "adaptorEtherIfStatsrxDroppedDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATSRX_ERRORS_DELTA = "adaptorEtherIfStatsrxErrorsDelta"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATSRX_ERRORS_DELTA_AVG = "adaptorEtherIfStatsrxErrorsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATSRX_ERRORS_DELTA_MAX = "adaptorEtherIfStatsrxErrorsDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATSRX_ERRORS_DELTA_MIN = "adaptorEtherIfStatsrxErrorsDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATSRX_PACKETS_DELTA = "adaptorEtherIfStatsrxPacketsDelta"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATSRX_PACKETS_DELTA_AVG = "adaptorEtherIfStatsrxPacketsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATSRX_PACKETS_DELTA_MAX = "adaptorEtherIfStatsrxPacketsDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATSRX_PACKETS_DELTA_MIN = "adaptorEtherIfStatsrxPacketsDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATSTX_BYTES_DELTA = "adaptorEtherIfStatstxBytesDelta"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATSTX_BYTES_DELTA_AVG = "adaptorEtherIfStatstxBytesDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATSTX_BYTES_DELTA_MAX = "adaptorEtherIfStatstxBytesDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATSTX_BYTES_DELTA_MIN = "adaptorEtherIfStatstxBytesDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATSTX_DROPPED_DELTA = "adaptorEtherIfStatstxDroppedDelta"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATSTX_DROPPED_DELTA_AVG = "adaptorEtherIfStatstxDroppedDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATSTX_DROPPED_DELTA_MAX = "adaptorEtherIfStatstxDroppedDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATSTX_DROPPED_DELTA_MIN = "adaptorEtherIfStatstxDroppedDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATSTX_ERRORS_DELTA = "adaptorEtherIfStatstxErrorsDelta"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATSTX_ERRORS_DELTA_AVG = "adaptorEtherIfStatstxErrorsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATSTX_ERRORS_DELTA_MAX = "adaptorEtherIfStatstxErrorsDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATSTX_ERRORS_DELTA_MIN = "adaptorEtherIfStatstxErrorsDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATSTX_PACKETS_DELTA = "adaptorEtherIfStatstxPacketsDelta"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATSTX_PACKETS_DELTA_AVG = "adaptorEtherIfStatstxPacketsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATSTX_PACKETS_DELTA_MAX = "adaptorEtherIfStatstxPacketsDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATSTX_PACKETS_DELTA_MIN = "adaptorEtherIfStatstxPacketsDeltaMin"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATSINVALID_CRCCOUNT_DELTA = "adaptorFcIfEventStatsinvalidCRCCountDelta"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATSINVALID_CRCCOUNT_DELTA_AVG = "adaptorFcIfEventStatsinvalidCRCCountDeltaAvg"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATSINVALID_CRCCOUNT_DELTA_MAX = "adaptorFcIfEventStatsinvalidCRCCountDeltaMax"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATSINVALID_CRCCOUNT_DELTA_MIN = "adaptorFcIfEventStatsinvalidCRCCountDeltaMin"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATSLINK_FAILURE_COUNT_DELTA = "adaptorFcIfEventStatslinkFailureCountDelta"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATSLINK_FAILURE_COUNT_DELTA_AVG = "adaptorFcIfEventStatslinkFailureCountDeltaAvg"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATSLINK_FAILURE_COUNT_DELTA_MAX = "adaptorFcIfEventStatslinkFailureCountDeltaMax"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATSLINK_FAILURE_COUNT_DELTA_MIN = "adaptorFcIfEventStatslinkFailureCountDeltaMin"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATSLIP_COUNT_DELTA = "adaptorFcIfEventStatslipCountDelta"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATSLIP_COUNT_DELTA_AVG = "adaptorFcIfEventStatslipCountDeltaAvg"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATSLIP_COUNT_DELTA_MAX = "adaptorFcIfEventStatslipCountDeltaMax"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATSLIP_COUNT_DELTA_MIN = "adaptorFcIfEventStatslipCountDeltaMin"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATSLOSS_OF_SIGNAL_COUNT_DELTA = "adaptorFcIfEventStatslossOfSignalCountDelta"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATSLOSS_OF_SIGNAL_COUNT_DELTA_AVG = "adaptorFcIfEventStatslossOfSignalCountDeltaAvg"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATSLOSS_OF_SIGNAL_COUNT_DELTA_MAX = "adaptorFcIfEventStatslossOfSignalCountDeltaMax"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATSLOSS_OF_SIGNAL_COUNT_DELTA_MIN = "adaptorFcIfEventStatslossOfSignalCountDeltaMin"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATSLOSS_OF_SYNC_COUNT_DELTA = "adaptorFcIfEventStatslossOfSyncCountDelta"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATSLOSS_OF_SYNC_COUNT_DELTA_AVG = "adaptorFcIfEventStatslossOfSyncCountDeltaAvg"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATSLOSS_OF_SYNC_COUNT_DELTA_MAX = "adaptorFcIfEventStatslossOfSyncCountDeltaMax"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATSLOSS_OF_SYNC_COUNT_DELTA_MIN = "adaptorFcIfEventStatslossOfSyncCountDeltaMin"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATSN_OSCOUNT_DELTA = "adaptorFcIfEventStatsnOSCountDelta"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATSN_OSCOUNT_DELTA_AVG = "adaptorFcIfEventStatsnOSCountDeltaAvg"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATSN_OSCOUNT_DELTA_MAX = "adaptorFcIfEventStatsnOSCountDeltaMax"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATSN_OSCOUNT_DELTA_MIN = "adaptorFcIfEventStatsnOSCountDeltaMin"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATSSECONDS_SINCE_LAST_RESET_DELTA = "adaptorFcIfEventStatssecondsSinceLastResetDelta"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATSSECONDS_SINCE_LAST_RESET_DELTA_AVG = "adaptorFcIfEventStatssecondsSinceLastResetDeltaAvg"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATSSECONDS_SINCE_LAST_RESET_DELTA_MAX = "adaptorFcIfEventStatssecondsSinceLastResetDeltaMax"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATSSECONDS_SINCE_LAST_RESET_DELTA_MIN = "adaptorFcIfEventStatssecondsSinceLastResetDeltaMin"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATSSEQ_PROTOCOL_ERR_COUNT_DELTA = "adaptorFcIfEventStatsseqProtocolErrCountDelta"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATSSEQ_PROTOCOL_ERR_COUNT_DELTA_AVG = "adaptorFcIfEventStatsseqProtocolErrCountDeltaAvg"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATSSEQ_PROTOCOL_ERR_COUNT_DELTA_MAX = "adaptorFcIfEventStatsseqProtocolErrCountDeltaMax"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATSSEQ_PROTOCOL_ERR_COUNT_DELTA_MIN = "adaptorFcIfEventStatsseqProtocolErrCountDeltaMin"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATSCONTROL_REQUESTS_DELTA = "adaptorFcIfFC4StatscontrolRequestsDelta"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATSCONTROL_REQUESTS_DELTA_AVG = "adaptorFcIfFC4StatscontrolRequestsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATSCONTROL_REQUESTS_DELTA_MAX = "adaptorFcIfFC4StatscontrolRequestsDeltaMax"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATSCONTROL_REQUESTS_DELTA_MIN = "adaptorFcIfFC4StatscontrolRequestsDeltaMin"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATSINPUT_MEGABYTES_DELTA = "adaptorFcIfFC4StatsinputMegabytesDelta"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATSINPUT_MEGABYTES_DELTA_AVG = "adaptorFcIfFC4StatsinputMegabytesDeltaAvg"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATSINPUT_MEGABYTES_DELTA_MAX = "adaptorFcIfFC4StatsinputMegabytesDeltaMax"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATSINPUT_MEGABYTES_DELTA_MIN = "adaptorFcIfFC4StatsinputMegabytesDeltaMin"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATSINPUT_REQUESTS_DELTA = "adaptorFcIfFC4StatsinputRequestsDelta"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATSINPUT_REQUESTS_DELTA_AVG = "adaptorFcIfFC4StatsinputRequestsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATSINPUT_REQUESTS_DELTA_MAX = "adaptorFcIfFC4StatsinputRequestsDeltaMax"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATSINPUT_REQUESTS_DELTA_MIN = "adaptorFcIfFC4StatsinputRequestsDeltaMin"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATSOUTPUT_MEGABYTES_DELTA = "adaptorFcIfFC4StatsoutputMegabytesDelta"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATSOUTPUT_MEGABYTES_DELTA_AVG = "adaptorFcIfFC4StatsoutputMegabytesDeltaAvg"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATSOUTPUT_MEGABYTES_DELTA_MAX = "adaptorFcIfFC4StatsoutputMegabytesDeltaMax"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATSOUTPUT_MEGABYTES_DELTA_MIN = "adaptorFcIfFC4StatsoutputMegabytesDeltaMin"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATSOUTPUT_REQUESTS_DELTA = "adaptorFcIfFC4StatsoutputRequestsDelta"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATSOUTPUT_REQUESTS_DELTA_AVG = "adaptorFcIfFC4StatsoutputRequestsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATSOUTPUT_REQUESTS_DELTA_MAX = "adaptorFcIfFC4StatsoutputRequestsDeltaMax"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATSOUTPUT_REQUESTS_DELTA_MIN = "adaptorFcIfFC4StatsoutputRequestsDeltaMin"
	CONST_PROP_ID_ADAPTOR_FC_IF_FRAME_STATSDUMPED_FRAMES_DELTA = "adaptorFcIfFrameStatsdumpedFramesDelta"
	CONST_PROP_ID_ADAPTOR_FC_IF_FRAME_STATSDUMPED_FRAMES_DELTA_AVG = "adaptorFcIfFrameStatsdumpedFramesDeltaAvg"
	CONST_PROP_ID_ADAPTOR_FC_IF_FRAME_STATSDUMPED_FRAMES_DELTA_MAX = "adaptorFcIfFrameStatsdumpedFramesDeltaMax"
	CONST_PROP_ID_ADAPTOR_FC_IF_FRAME_STATSDUMPED_FRAMES_DELTA_MIN = "adaptorFcIfFrameStatsdumpedFramesDeltaMin"
	CONST_PROP_ID_ADAPTOR_FC_IF_FRAME_STATSERROR_FRAMES_DELTA = "adaptorFcIfFrameStatserrorFramesDelta"
	CONST_PROP_ID_ADAPTOR_FC_IF_FRAME_STATSERROR_FRAMES_DELTA_AVG = "adaptorFcIfFrameStatserrorFramesDeltaAvg"
	CONST_PROP_ID_ADAPTOR_FC_IF_FRAME_STATSERROR_FRAMES_DELTA_MAX = "adaptorFcIfFrameStatserrorFramesDeltaMax"
	CONST_PROP_ID_ADAPTOR_FC_IF_FRAME_STATSERROR_FRAMES_DELTA_MIN = "adaptorFcIfFrameStatserrorFramesDeltaMin"
	CONST_PROP_ID_ADAPTOR_FC_IF_FRAME_STATSRX_FRAMES_DELTA = "adaptorFcIfFrameStatsrxFramesDelta"
	CONST_PROP_ID_ADAPTOR_FC_IF_FRAME_STATSRX_FRAMES_DELTA_AVG = "adaptorFcIfFrameStatsrxFramesDeltaAvg"
	CONST_PROP_ID_ADAPTOR_FC_IF_FRAME_STATSRX_FRAMES_DELTA_MAX = "adaptorFcIfFrameStatsrxFramesDeltaMax"
	CONST_PROP_ID_ADAPTOR_FC_IF_FRAME_STATSRX_FRAMES_DELTA_MIN = "adaptorFcIfFrameStatsrxFramesDeltaMin"
	CONST_PROP_ID_ADAPTOR_FC_IF_FRAME_STATSTX_FRAMES_DELTA = "adaptorFcIfFrameStatstxFramesDelta"
	CONST_PROP_ID_ADAPTOR_FC_IF_FRAME_STATSTX_FRAMES_DELTA_AVG = "adaptorFcIfFrameStatstxFramesDeltaAvg"
	CONST_PROP_ID_ADAPTOR_FC_IF_FRAME_STATSTX_FRAMES_DELTA_MAX = "adaptorFcIfFrameStatstxFramesDeltaMax"
	CONST_PROP_ID_ADAPTOR_FC_IF_FRAME_STATSTX_FRAMES_DELTA_MIN = "adaptorFcIfFrameStatstxFramesDeltaMin"
	CONST_PROP_ID_ADAPTOR_FC_PORT_STATSRX_BAD_FRAMES_DELTA = "adaptorFcPortStatsrxBadFramesDelta"
	CONST_PROP_ID_ADAPTOR_FC_PORT_STATSRX_BAD_FRAMES_DELTA_AVG = "adaptorFcPortStatsrxBadFramesDeltaAvg"
	CONST_PROP_ID_ADAPTOR_FC_PORT_STATSRX_BAD_FRAMES_DELTA_MAX = "adaptorFcPortStatsrxBadFramesDeltaMax"
	CONST_PROP_ID_ADAPTOR_FC_PORT_STATSRX_BAD_FRAMES_DELTA_MIN = "adaptorFcPortStatsrxBadFramesDeltaMin"
	CONST_PROP_ID_ADAPTOR_FC_PORT_STATSRX_FRAMES_DELTA = "adaptorFcPortStatsrxFramesDelta"
	CONST_PROP_ID_ADAPTOR_FC_PORT_STATSRX_FRAMES_DELTA_AVG = "adaptorFcPortStatsrxFramesDeltaAvg"
	CONST_PROP_ID_ADAPTOR_FC_PORT_STATSRX_FRAMES_DELTA_MAX = "adaptorFcPortStatsrxFramesDeltaMax"
	CONST_PROP_ID_ADAPTOR_FC_PORT_STATSRX_FRAMES_DELTA_MIN = "adaptorFcPortStatsrxFramesDeltaMin"
	CONST_PROP_ID_ADAPTOR_FC_PORT_STATSTX_BAD_FRAMES_DELTA = "adaptorFcPortStatstxBadFramesDelta"
	CONST_PROP_ID_ADAPTOR_FC_PORT_STATSTX_BAD_FRAMES_DELTA_AVG = "adaptorFcPortStatstxBadFramesDeltaAvg"
	CONST_PROP_ID_ADAPTOR_FC_PORT_STATSTX_BAD_FRAMES_DELTA_MAX = "adaptorFcPortStatstxBadFramesDeltaMax"
	CONST_PROP_ID_ADAPTOR_FC_PORT_STATSTX_BAD_FRAMES_DELTA_MIN = "adaptorFcPortStatstxBadFramesDeltaMin"
	CONST_PROP_ID_ADAPTOR_FC_PORT_STATSTX_FRAMES_DELTA = "adaptorFcPortStatstxFramesDelta"
	CONST_PROP_ID_ADAPTOR_FC_PORT_STATSTX_FRAMES_DELTA_AVG = "adaptorFcPortStatstxFramesDeltaAvg"
	CONST_PROP_ID_ADAPTOR_FC_PORT_STATSTX_FRAMES_DELTA_MAX = "adaptorFcPortStatstxFramesDeltaMax"
	CONST_PROP_ID_ADAPTOR_FC_PORT_STATSTX_FRAMES_DELTA_MIN = "adaptorFcPortStatstxFramesDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_BASE_ERROR_STATSCORRECTABLE_ERRORS_DELTA = "adaptorMenloBaseErrorStatscorrectableErrorsDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_BASE_ERROR_STATSCORRECTABLE_ERRORS_DELTA_AVG = "adaptorMenloBaseErrorStatscorrectableErrorsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_BASE_ERROR_STATSCORRECTABLE_ERRORS_DELTA_MAX = "adaptorMenloBaseErrorStatscorrectableErrorsDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_BASE_ERROR_STATSCORRECTABLE_ERRORS_DELTA_MIN = "adaptorMenloBaseErrorStatscorrectableErrorsDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_BASE_ERROR_STATSUNCORRECTABLE_ERRORS_DELTA = "adaptorMenloBaseErrorStatsuncorrectableErrorsDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_BASE_ERROR_STATSUNCORRECTABLE_ERRORS_DELTA_AVG = "adaptorMenloBaseErrorStatsuncorrectableErrorsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_BASE_ERROR_STATSUNCORRECTABLE_ERRORS_DELTA_MAX = "adaptorMenloBaseErrorStatsuncorrectableErrorsDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_BASE_ERROR_STATSUNCORRECTABLE_ERRORS_DELTA_MIN = "adaptorMenloBaseErrorStatsuncorrectableErrorsDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATSRX_PAUSE_CFCDELTA = "adaptorMenloDcePortStatsrxPauseCFCDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATSRX_PAUSE_CFCDELTA_AVG = "adaptorMenloDcePortStatsrxPauseCFCDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATSRX_PAUSE_CFCDELTA_MAX = "adaptorMenloDcePortStatsrxPauseCFCDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATSRX_PAUSE_CFCDELTA_MIN = "adaptorMenloDcePortStatsrxPauseCFCDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATSRX_PAUSE_PFCDELTA = "adaptorMenloDcePortStatsrxPausePFCDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATSRX_PAUSE_PFCDELTA_AVG = "adaptorMenloDcePortStatsrxPausePFCDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATSRX_PAUSE_PFCDELTA_MAX = "adaptorMenloDcePortStatsrxPausePFCDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATSRX_PAUSE_PFCDELTA_MIN = "adaptorMenloDcePortStatsrxPausePFCDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATSTX_PAUSE_CFCDELTA = "adaptorMenloDcePortStatstxPauseCFCDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATSTX_PAUSE_CFCDELTA_AVG = "adaptorMenloDcePortStatstxPauseCFCDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATSTX_PAUSE_CFCDELTA_MAX = "adaptorMenloDcePortStatstxPauseCFCDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATSTX_PAUSE_CFCDELTA_MIN = "adaptorMenloDcePortStatstxPauseCFCDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATSTX_PAUSE_PFCDELTA = "adaptorMenloDcePortStatstxPausePFCDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATSTX_PAUSE_PFCDELTA_AVG = "adaptorMenloDcePortStatstxPausePFCDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATSTX_PAUSE_PFCDELTA_MAX = "adaptorMenloDcePortStatstxPausePFCDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATSTX_PAUSE_PFCDELTA_MIN = "adaptorMenloDcePortStatstxPausePFCDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATSCORRECTABLE_ERRORS_DELTA = "adaptorMenloEthErrorStatscorrectableErrorsDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATSCORRECTABLE_ERRORS_DELTA_AVG = "adaptorMenloEthErrorStatscorrectableErrorsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATSCORRECTABLE_ERRORS_DELTA_MAX = "adaptorMenloEthErrorStatscorrectableErrorsDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATSCORRECTABLE_ERRORS_DELTA_MIN = "adaptorMenloEthErrorStatscorrectableErrorsDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATSDROP_ACL_DELTA = "adaptorMenloEthErrorStatsdropAclDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATSDROP_ACL_DELTA_AVG = "adaptorMenloEthErrorStatsdropAclDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATSDROP_ACL_DELTA_MAX = "adaptorMenloEthErrorStatsdropAclDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATSDROP_ACL_DELTA_MIN = "adaptorMenloEthErrorStatsdropAclDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATSPOP_ERRORS_DELTA = "adaptorMenloEthErrorStatspopErrorsDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATSPOP_ERRORS_DELTA_AVG = "adaptorMenloEthErrorStatspopErrorsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATSPOP_ERRORS_DELTA_MAX = "adaptorMenloEthErrorStatspopErrorsDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATSPOP_ERRORS_DELTA_MIN = "adaptorMenloEthErrorStatspopErrorsDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATSPUSH_ERRORS_DELTA = "adaptorMenloEthErrorStatspushErrorsDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATSPUSH_ERRORS_DELTA_AVG = "adaptorMenloEthErrorStatspushErrorsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATSPUSH_ERRORS_DELTA_MAX = "adaptorMenloEthErrorStatspushErrorsDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATSPUSH_ERRORS_DELTA_MIN = "adaptorMenloEthErrorStatspushErrorsDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATSUNCORRECTABLE_ERRORS_DELTA = "adaptorMenloEthErrorStatsuncorrectableErrorsDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATSUNCORRECTABLE_ERRORS_DELTA_AVG = "adaptorMenloEthErrorStatsuncorrectableErrorsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATSUNCORRECTABLE_ERRORS_DELTA_MAX = "adaptorMenloEthErrorStatsuncorrectableErrorsDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATSUNCORRECTABLE_ERRORS_DELTA_MIN = "adaptorMenloEthErrorStatsuncorrectableErrorsDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_STATSDROP_OVERRUN_DELTA = "adaptorMenloEthStatsdropOverrunDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_STATSDROP_OVERRUN_DELTA_AVG = "adaptorMenloEthStatsdropOverrunDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_STATSDROP_OVERRUN_DELTA_MAX = "adaptorMenloEthStatsdropOverrunDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_STATSDROP_OVERRUN_DELTA_MIN = "adaptorMenloEthStatsdropOverrunDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_STATSDROP_RUNT_DELTA = "adaptorMenloEthStatsdropRuntDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_STATSDROP_RUNT_DELTA_AVG = "adaptorMenloEthStatsdropRuntDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_STATSDROP_RUNT_DELTA_MAX = "adaptorMenloEthStatsdropRuntDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_STATSDROP_RUNT_DELTA_MIN = "adaptorMenloEthStatsdropRuntDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_STATSTRUNCATE_OVERRUN_DELTA = "adaptorMenloEthStatstruncateOverrunDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_STATSTRUNCATE_OVERRUN_DELTA_AVG = "adaptorMenloEthStatstruncateOverrunDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_STATSTRUNCATE_OVERRUN_DELTA_MAX = "adaptorMenloEthStatstruncateOverrunDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_STATSTRUNCATE_OVERRUN_DELTA_MIN = "adaptorMenloEthStatstruncateOverrunDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATSCORRECTABLE_ERRORS_DELTA = "adaptorMenloFcErrorStatscorrectableErrorsDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATSCORRECTABLE_ERRORS_DELTA_AVG = "adaptorMenloFcErrorStatscorrectableErrorsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATSCORRECTABLE_ERRORS_DELTA_MAX = "adaptorMenloFcErrorStatscorrectableErrorsDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATSCORRECTABLE_ERRORS_DELTA_MIN = "adaptorMenloFcErrorStatscorrectableErrorsDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATSPOP_ERRORS_DELTA = "adaptorMenloFcErrorStatspopErrorsDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATSPOP_ERRORS_DELTA_AVG = "adaptorMenloFcErrorStatspopErrorsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATSPOP_ERRORS_DELTA_MAX = "adaptorMenloFcErrorStatspopErrorsDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATSPOP_ERRORS_DELTA_MIN = "adaptorMenloFcErrorStatspopErrorsDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATSPUSH_ERRORS_DELTA = "adaptorMenloFcErrorStatspushErrorsDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATSPUSH_ERRORS_DELTA_AVG = "adaptorMenloFcErrorStatspushErrorsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATSPUSH_ERRORS_DELTA_MAX = "adaptorMenloFcErrorStatspushErrorsDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATSPUSH_ERRORS_DELTA_MIN = "adaptorMenloFcErrorStatspushErrorsDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATSUNCORRECTABLE_ERRORS_DELTA = "adaptorMenloFcErrorStatsuncorrectableErrorsDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATSUNCORRECTABLE_ERRORS_DELTA_AVG = "adaptorMenloFcErrorStatsuncorrectableErrorsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATSUNCORRECTABLE_ERRORS_DELTA_MAX = "adaptorMenloFcErrorStatsuncorrectableErrorsDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATSUNCORRECTABLE_ERRORS_DELTA_MIN = "adaptorMenloFcErrorStatsuncorrectableErrorsDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_STATSDROP_ACL_DELTA = "adaptorMenloFcStatsdropAclDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_STATSDROP_ACL_DELTA_AVG = "adaptorMenloFcStatsdropAclDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_STATSDROP_ACL_DELTA_MAX = "adaptorMenloFcStatsdropAclDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_STATSDROP_ACL_DELTA_MIN = "adaptorMenloFcStatsdropAclDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_STATSDROP_OVERRUN_DELTA = "adaptorMenloFcStatsdropOverrunDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_STATSDROP_OVERRUN_DELTA_AVG = "adaptorMenloFcStatsdropOverrunDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_STATSDROP_OVERRUN_DELTA_MAX = "adaptorMenloFcStatsdropOverrunDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_STATSDROP_OVERRUN_DELTA_MIN = "adaptorMenloFcStatsdropOverrunDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_STATSDROP_RUNT_DELTA = "adaptorMenloFcStatsdropRuntDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_STATSDROP_RUNT_DELTA_AVG = "adaptorMenloFcStatsdropRuntDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_STATSDROP_RUNT_DELTA_MAX = "adaptorMenloFcStatsdropRuntDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_STATSDROP_RUNT_DELTA_MIN = "adaptorMenloFcStatsdropRuntDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_STATSTRUNCATE_OVERRUN_DELTA = "adaptorMenloFcStatstruncateOverrunDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_STATSTRUNCATE_OVERRUN_DELTA_AVG = "adaptorMenloFcStatstruncateOverrunDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_STATSTRUNCATE_OVERRUN_DELTA_MAX = "adaptorMenloFcStatstruncateOverrunDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_STATSTRUNCATE_OVERRUN_DELTA_MIN = "adaptorMenloFcStatstruncateOverrunDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATSRX_PAUSE_CFCDELTA = "adaptorMenloHostPortStatsrxPauseCFCDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATSRX_PAUSE_CFCDELTA_AVG = "adaptorMenloHostPortStatsrxPauseCFCDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATSRX_PAUSE_CFCDELTA_MAX = "adaptorMenloHostPortStatsrxPauseCFCDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATSRX_PAUSE_CFCDELTA_MIN = "adaptorMenloHostPortStatsrxPauseCFCDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATSRX_PAUSE_PFCDELTA = "adaptorMenloHostPortStatsrxPausePFCDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATSRX_PAUSE_PFCDELTA_AVG = "adaptorMenloHostPortStatsrxPausePFCDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATSRX_PAUSE_PFCDELTA_MAX = "adaptorMenloHostPortStatsrxPausePFCDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATSRX_PAUSE_PFCDELTA_MIN = "adaptorMenloHostPortStatsrxPausePFCDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATSTX_PAUSE_CFCDELTA = "adaptorMenloHostPortStatstxPauseCFCDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATSTX_PAUSE_CFCDELTA_AVG = "adaptorMenloHostPortStatstxPauseCFCDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATSTX_PAUSE_CFCDELTA_MAX = "adaptorMenloHostPortStatstxPauseCFCDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATSTX_PAUSE_CFCDELTA_MIN = "adaptorMenloHostPortStatstxPauseCFCDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATSTX_PAUSE_PFCDELTA = "adaptorMenloHostPortStatstxPausePFCDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATSTX_PAUSE_PFCDELTA_AVG = "adaptorMenloHostPortStatstxPausePFCDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATSTX_PAUSE_PFCDELTA_MAX = "adaptorMenloHostPortStatstxPausePFCDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATSTX_PAUSE_PFCDELTA_MIN = "adaptorMenloHostPortStatstxPausePFCDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATSCORRECTABLE_ERRORS_DELTA = "adaptorMenloMcpuErrorStatscorrectableErrorsDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATSCORRECTABLE_ERRORS_DELTA_AVG = "adaptorMenloMcpuErrorStatscorrectableErrorsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATSCORRECTABLE_ERRORS_DELTA_MAX = "adaptorMenloMcpuErrorStatscorrectableErrorsDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATSCORRECTABLE_ERRORS_DELTA_MIN = "adaptorMenloMcpuErrorStatscorrectableErrorsDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATSPOP_ERRORS_DELTA = "adaptorMenloMcpuErrorStatspopErrorsDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATSPOP_ERRORS_DELTA_AVG = "adaptorMenloMcpuErrorStatspopErrorsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATSPOP_ERRORS_DELTA_MAX = "adaptorMenloMcpuErrorStatspopErrorsDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATSPOP_ERRORS_DELTA_MIN = "adaptorMenloMcpuErrorStatspopErrorsDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATSPUSH_ERRORS_DELTA = "adaptorMenloMcpuErrorStatspushErrorsDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATSPUSH_ERRORS_DELTA_AVG = "adaptorMenloMcpuErrorStatspushErrorsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATSPUSH_ERRORS_DELTA_MAX = "adaptorMenloMcpuErrorStatspushErrorsDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATSPUSH_ERRORS_DELTA_MIN = "adaptorMenloMcpuErrorStatspushErrorsDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATSUNCORRECTABLE_ERRORS_DELTA = "adaptorMenloMcpuErrorStatsuncorrectableErrorsDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATSUNCORRECTABLE_ERRORS_DELTA_AVG = "adaptorMenloMcpuErrorStatsuncorrectableErrorsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATSUNCORRECTABLE_ERRORS_DELTA_MAX = "adaptorMenloMcpuErrorStatsuncorrectableErrorsDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATSUNCORRECTABLE_ERRORS_DELTA_MIN = "adaptorMenloMcpuErrorStatsuncorrectableErrorsDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_STATSDROP_ACL_DELTA = "adaptorMenloMcpuStatsdropAclDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_STATSDROP_ACL_DELTA_AVG = "adaptorMenloMcpuStatsdropAclDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_STATSDROP_ACL_DELTA_MAX = "adaptorMenloMcpuStatsdropAclDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_STATSDROP_ACL_DELTA_MIN = "adaptorMenloMcpuStatsdropAclDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_STATSDROP_OVERRUN_DELTA = "adaptorMenloMcpuStatsdropOverrunDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_STATSDROP_OVERRUN_DELTA_AVG = "adaptorMenloMcpuStatsdropOverrunDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_STATSDROP_OVERRUN_DELTA_MAX = "adaptorMenloMcpuStatsdropOverrunDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_STATSDROP_OVERRUN_DELTA_MIN = "adaptorMenloMcpuStatsdropOverrunDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_STATSDROP_RUNT_DELTA = "adaptorMenloMcpuStatsdropRuntDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_STATSDROP_RUNT_DELTA_AVG = "adaptorMenloMcpuStatsdropRuntDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_STATSDROP_RUNT_DELTA_MAX = "adaptorMenloMcpuStatsdropRuntDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_STATSDROP_RUNT_DELTA_MIN = "adaptorMenloMcpuStatsdropRuntDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_STATSTRUNCATE_OVERRUN_DELTA = "adaptorMenloMcpuStatstruncateOverrunDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_STATSTRUNCATE_OVERRUN_DELTA_AVG = "adaptorMenloMcpuStatstruncateOverrunDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_STATSTRUNCATE_OVERRUN_DELTA_MAX = "adaptorMenloMcpuStatstruncateOverrunDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_STATSTRUNCATE_OVERRUN_DELTA_MIN = "adaptorMenloMcpuStatstruncateOverrunDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATSDROP_CMD_DELTA = "adaptorMenloNetEgStatsdropCmdDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATSDROP_CMD_DELTA_AVG = "adaptorMenloNetEgStatsdropCmdDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATSDROP_CMD_DELTA_MAX = "adaptorMenloNetEgStatsdropCmdDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATSDROP_CMD_DELTA_MIN = "adaptorMenloNetEgStatsdropCmdDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATSDROP_LIF_CFG_INVALID_DELTA = "adaptorMenloNetEgStatsdropLifCfgInvalidDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATSDROP_LIF_CFG_INVALID_DELTA_AVG = "adaptorMenloNetEgStatsdropLifCfgInvalidDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATSDROP_LIF_CFG_INVALID_DELTA_MAX = "adaptorMenloNetEgStatsdropLifCfgInvalidDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATSDROP_LIF_CFG_INVALID_DELTA_MIN = "adaptorMenloNetEgStatsdropLifCfgInvalidDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATSDROP_LIF_MAP_NO_HIT_DELTA = "adaptorMenloNetEgStatsdropLifMapNoHitDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATSDROP_LIF_MAP_NO_HIT_DELTA_AVG = "adaptorMenloNetEgStatsdropLifMapNoHitDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATSDROP_LIF_MAP_NO_HIT_DELTA_MAX = "adaptorMenloNetEgStatsdropLifMapNoHitDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATSDROP_LIF_MAP_NO_HIT_DELTA_MIN = "adaptorMenloNetEgStatsdropLifMapNoHitDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATSDROP_SRC_BIND_DELTA = "adaptorMenloNetEgStatsdropSrcBindDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATSDROP_SRC_BIND_DELTA_AVG = "adaptorMenloNetEgStatsdropSrcBindDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATSDROP_SRC_BIND_DELTA_MAX = "adaptorMenloNetEgStatsdropSrcBindDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATSDROP_SRC_BIND_DELTA_MIN = "adaptorMenloNetEgStatsdropSrcBindDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATSLEARN_REQ_DROP_DELTA = "adaptorMenloNetEgStatslearnReqDropDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATSLEARN_REQ_DROP_DELTA_AVG = "adaptorMenloNetEgStatslearnReqDropDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATSLEARN_REQ_DROP_DELTA_MAX = "adaptorMenloNetEgStatslearnReqDropDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATSLEARN_REQ_DROP_DELTA_MIN = "adaptorMenloNetEgStatslearnReqDropDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_IN_STATSDROP_FC_LIF_INVALID_DELTA = "adaptorMenloNetInStatsdropFcLifInvalidDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_IN_STATSDROP_FC_LIF_INVALID_DELTA_AVG = "adaptorMenloNetInStatsdropFcLifInvalidDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_IN_STATSDROP_FC_LIF_INVALID_DELTA_MAX = "adaptorMenloNetInStatsdropFcLifInvalidDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_IN_STATSDROP_FC_LIF_INVALID_DELTA_MIN = "adaptorMenloNetInStatsdropFcLifInvalidDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_IN_STATSDROP_FC_MULTICAST_DELTA = "adaptorMenloNetInStatsdropFcMulticastDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_IN_STATSDROP_FC_MULTICAST_DELTA_AVG = "adaptorMenloNetInStatsdropFcMulticastDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_IN_STATSDROP_FC_MULTICAST_DELTA_MAX = "adaptorMenloNetInStatsdropFcMulticastDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_IN_STATSDROP_FC_MULTICAST_DELTA_MIN = "adaptorMenloNetInStatsdropFcMulticastDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_IN_STATSDROP_NULL_PIF_DELTA = "adaptorMenloNetInStatsdropNullPifDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_IN_STATSDROP_NULL_PIF_DELTA_AVG = "adaptorMenloNetInStatsdropNullPifDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_IN_STATSDROP_NULL_PIF_DELTA_MAX = "adaptorMenloNetInStatsdropNullPifDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_IN_STATSDROP_NULL_PIF_DELTA_MIN = "adaptorMenloNetInStatsdropNullPifDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_IN_STATSFWD_LOOKUP_NO_HIT_DELTA = "adaptorMenloNetInStatsfwdLookupNoHitDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_IN_STATSFWD_LOOKUP_NO_HIT_DELTA_AVG = "adaptorMenloNetInStatsfwdLookupNoHitDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_IN_STATSFWD_LOOKUP_NO_HIT_DELTA_MAX = "adaptorMenloNetInStatsfwdLookupNoHitDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_IN_STATSFWD_LOOKUP_NO_HIT_DELTA_MIN = "adaptorMenloNetInStatsfwdLookupNoHitDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_QERROR_STATSCORRECTABLE_ERRORS_DELTA = "adaptorMenloQErrorStatscorrectableErrorsDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_QERROR_STATSCORRECTABLE_ERRORS_DELTA_AVG = "adaptorMenloQErrorStatscorrectableErrorsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_QERROR_STATSCORRECTABLE_ERRORS_DELTA_MAX = "adaptorMenloQErrorStatscorrectableErrorsDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_QERROR_STATSCORRECTABLE_ERRORS_DELTA_MIN = "adaptorMenloQErrorStatscorrectableErrorsDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_QERROR_STATSPOP_ERRORS_DELTA = "adaptorMenloQErrorStatspopErrorsDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_QERROR_STATSPOP_ERRORS_DELTA_AVG = "adaptorMenloQErrorStatspopErrorsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_QERROR_STATSPOP_ERRORS_DELTA_MAX = "adaptorMenloQErrorStatspopErrorsDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_QERROR_STATSPOP_ERRORS_DELTA_MIN = "adaptorMenloQErrorStatspopErrorsDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_QERROR_STATSPUSH_ERRORS_DELTA = "adaptorMenloQErrorStatspushErrorsDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_QERROR_STATSPUSH_ERRORS_DELTA_AVG = "adaptorMenloQErrorStatspushErrorsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_QERROR_STATSPUSH_ERRORS_DELTA_MAX = "adaptorMenloQErrorStatspushErrorsDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_QERROR_STATSPUSH_ERRORS_DELTA_MIN = "adaptorMenloQErrorStatspushErrorsDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_QERROR_STATSUNCORRECTABLE_ERRORS_DELTA = "adaptorMenloQErrorStatsuncorrectableErrorsDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_QERROR_STATSUNCORRECTABLE_ERRORS_DELTA_AVG = "adaptorMenloQErrorStatsuncorrectableErrorsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_QERROR_STATSUNCORRECTABLE_ERRORS_DELTA_MAX = "adaptorMenloQErrorStatsuncorrectableErrorsDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_QERROR_STATSUNCORRECTABLE_ERRORS_DELTA_MIN = "adaptorMenloQErrorStatsuncorrectableErrorsDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_QSTATSDROP_OVERRUN_N0_DELTA = "adaptorMenloQStatsdropOverrunN0Delta"
	CONST_PROP_ID_ADAPTOR_MENLO_QSTATSDROP_OVERRUN_N0_DELTA_AVG = "adaptorMenloQStatsdropOverrunN0DeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_QSTATSDROP_OVERRUN_N0_DELTA_MAX = "adaptorMenloQStatsdropOverrunN0DeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_QSTATSDROP_OVERRUN_N0_DELTA_MIN = "adaptorMenloQStatsdropOverrunN0DeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_QSTATSDROP_OVERRUN_N1_DELTA = "adaptorMenloQStatsdropOverrunN1Delta"
	CONST_PROP_ID_ADAPTOR_MENLO_QSTATSDROP_OVERRUN_N1_DELTA_AVG = "adaptorMenloQStatsdropOverrunN1DeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_QSTATSDROP_OVERRUN_N1_DELTA_MAX = "adaptorMenloQStatsdropOverrunN1DeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_QSTATSDROP_OVERRUN_N1_DELTA_MIN = "adaptorMenloQStatsdropOverrunN1DeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_QSTATSTRUNCATE_OVERRUN_N0_DELTA = "adaptorMenloQStatstruncateOverrunN0Delta"
	CONST_PROP_ID_ADAPTOR_MENLO_QSTATSTRUNCATE_OVERRUN_N0_DELTA_AVG = "adaptorMenloQStatstruncateOverrunN0DeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_QSTATSTRUNCATE_OVERRUN_N0_DELTA_MAX = "adaptorMenloQStatstruncateOverrunN0DeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_QSTATSTRUNCATE_OVERRUN_N0_DELTA_MIN = "adaptorMenloQStatstruncateOverrunN0DeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_QSTATSTRUNCATE_OVERRUN_N1_DELTA = "adaptorMenloQStatstruncateOverrunN1Delta"
	CONST_PROP_ID_ADAPTOR_MENLO_QSTATSTRUNCATE_OVERRUN_N1_DELTA_AVG = "adaptorMenloQStatstruncateOverrunN1DeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_QSTATSTRUNCATE_OVERRUN_N1_DELTA_MAX = "adaptorMenloQStatstruncateOverrunN1DeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_QSTATSTRUNCATE_OVERRUN_N1_DELTA_MIN = "adaptorMenloQStatstruncateOverrunN1DeltaMin"
	CONST_PROP_ID_ADAPTOR_VNIC_STATSBYTES_RX_DELTA = "adaptorVnicStatsbytesRxDelta"
	CONST_PROP_ID_ADAPTOR_VNIC_STATSBYTES_RX_DELTA_AVG = "adaptorVnicStatsbytesRxDeltaAvg"
	CONST_PROP_ID_ADAPTOR_VNIC_STATSBYTES_RX_DELTA_MAX = "adaptorVnicStatsbytesRxDeltaMax"
	CONST_PROP_ID_ADAPTOR_VNIC_STATSBYTES_RX_DELTA_MIN = "adaptorVnicStatsbytesRxDeltaMin"
	CONST_PROP_ID_ADAPTOR_VNIC_STATSBYTES_TX_DELTA = "adaptorVnicStatsbytesTxDelta"
	CONST_PROP_ID_ADAPTOR_VNIC_STATSBYTES_TX_DELTA_AVG = "adaptorVnicStatsbytesTxDeltaAvg"
	CONST_PROP_ID_ADAPTOR_VNIC_STATSBYTES_TX_DELTA_MAX = "adaptorVnicStatsbytesTxDeltaMax"
	CONST_PROP_ID_ADAPTOR_VNIC_STATSBYTES_TX_DELTA_MIN = "adaptorVnicStatsbytesTxDeltaMin"
	CONST_PROP_ID_ADAPTOR_VNIC_STATSDROPPED_RX_DELTA = "adaptorVnicStatsdroppedRxDelta"
	CONST_PROP_ID_ADAPTOR_VNIC_STATSDROPPED_RX_DELTA_AVG = "adaptorVnicStatsdroppedRxDeltaAvg"
	CONST_PROP_ID_ADAPTOR_VNIC_STATSDROPPED_RX_DELTA_MAX = "adaptorVnicStatsdroppedRxDeltaMax"
	CONST_PROP_ID_ADAPTOR_VNIC_STATSDROPPED_RX_DELTA_MIN = "adaptorVnicStatsdroppedRxDeltaMin"
	CONST_PROP_ID_ADAPTOR_VNIC_STATSDROPPED_TX_DELTA = "adaptorVnicStatsdroppedTxDelta"
	CONST_PROP_ID_ADAPTOR_VNIC_STATSDROPPED_TX_DELTA_AVG = "adaptorVnicStatsdroppedTxDeltaAvg"
	CONST_PROP_ID_ADAPTOR_VNIC_STATSDROPPED_TX_DELTA_MAX = "adaptorVnicStatsdroppedTxDeltaMax"
	CONST_PROP_ID_ADAPTOR_VNIC_STATSDROPPED_TX_DELTA_MIN = "adaptorVnicStatsdroppedTxDeltaMin"
	CONST_PROP_ID_ADAPTOR_VNIC_STATSERRORS_RX_DELTA = "adaptorVnicStatserrorsRxDelta"
	CONST_PROP_ID_ADAPTOR_VNIC_STATSERRORS_RX_DELTA_AVG = "adaptorVnicStatserrorsRxDeltaAvg"
	CONST_PROP_ID_ADAPTOR_VNIC_STATSERRORS_RX_DELTA_MAX = "adaptorVnicStatserrorsRxDeltaMax"
	CONST_PROP_ID_ADAPTOR_VNIC_STATSERRORS_RX_DELTA_MIN = "adaptorVnicStatserrorsRxDeltaMin"
	CONST_PROP_ID_ADAPTOR_VNIC_STATSERRORS_TX_DELTA = "adaptorVnicStatserrorsTxDelta"
	CONST_PROP_ID_ADAPTOR_VNIC_STATSERRORS_TX_DELTA_AVG = "adaptorVnicStatserrorsTxDeltaAvg"
	CONST_PROP_ID_ADAPTOR_VNIC_STATSERRORS_TX_DELTA_MAX = "adaptorVnicStatserrorsTxDeltaMax"
	CONST_PROP_ID_ADAPTOR_VNIC_STATSERRORS_TX_DELTA_MIN = "adaptorVnicStatserrorsTxDeltaMin"
	CONST_PROP_ID_ADAPTOR_VNIC_STATSPACKETS_RX_DELTA = "adaptorVnicStatspacketsRxDelta"
	CONST_PROP_ID_ADAPTOR_VNIC_STATSPACKETS_RX_DELTA_AVG = "adaptorVnicStatspacketsRxDeltaAvg"
	CONST_PROP_ID_ADAPTOR_VNIC_STATSPACKETS_RX_DELTA_MAX = "adaptorVnicStatspacketsRxDeltaMax"
	CONST_PROP_ID_ADAPTOR_VNIC_STATSPACKETS_RX_DELTA_MIN = "adaptorVnicStatspacketsRxDeltaMin"
	CONST_PROP_ID_ADAPTOR_VNIC_STATSPACKETS_TX_DELTA = "adaptorVnicStatspacketsTxDelta"
	CONST_PROP_ID_ADAPTOR_VNIC_STATSPACKETS_TX_DELTA_AVG = "adaptorVnicStatspacketsTxDeltaAvg"
	CONST_PROP_ID_ADAPTOR_VNIC_STATSPACKETS_TX_DELTA_MAX = "adaptorVnicStatspacketsTxDeltaMax"
	CONST_PROP_ID_ADAPTOR_VNIC_STATSPACKETS_TX_DELTA_MIN = "adaptorVnicStatspacketsTxDeltaMin"
	CONST_PROP_ID_COMPUTE_IOHUB_ENV_STATSTEMPERATURE = "computeIOHubEnvStatstemperature"
	CONST_PROP_ID_COMPUTE_IOHUB_ENV_STATSTEMPERATURE_AVG = "computeIOHubEnvStatstemperatureAvg"
	CONST_PROP_ID_COMPUTE_IOHUB_ENV_STATSTEMPERATURE_MAX = "computeIOHubEnvStatstemperatureMax"
	CONST_PROP_ID_COMPUTE_IOHUB_ENV_STATSTEMPERATURE_MIN = "computeIOHubEnvStatstemperatureMin"
	CONST_PROP_ID_COMPUTE_MB_POWER_STATSCONSUMED_POWER = "computeMbPowerStatsconsumedPower"
	CONST_PROP_ID_COMPUTE_MB_POWER_STATSCONSUMED_POWER_AVG = "computeMbPowerStatsconsumedPowerAvg"
	CONST_PROP_ID_COMPUTE_MB_POWER_STATSCONSUMED_POWER_MAX = "computeMbPowerStatsconsumedPowerMax"
	CONST_PROP_ID_COMPUTE_MB_POWER_STATSCONSUMED_POWER_MIN = "computeMbPowerStatsconsumedPowerMin"
	CONST_PROP_ID_COMPUTE_MB_POWER_STATSINPUT_CURRENT = "computeMbPowerStatsinputCurrent"
	CONST_PROP_ID_COMPUTE_MB_POWER_STATSINPUT_CURRENT_AVG = "computeMbPowerStatsinputCurrentAvg"
	CONST_PROP_ID_COMPUTE_MB_POWER_STATSINPUT_CURRENT_MAX = "computeMbPowerStatsinputCurrentMax"
	CONST_PROP_ID_COMPUTE_MB_POWER_STATSINPUT_CURRENT_MIN = "computeMbPowerStatsinputCurrentMin"
	CONST_PROP_ID_COMPUTE_MB_POWER_STATSINPUT_VOLTAGE = "computeMbPowerStatsinputVoltage"
	CONST_PROP_ID_COMPUTE_MB_POWER_STATSINPUT_VOLTAGE_AVG = "computeMbPowerStatsinputVoltageAvg"
	CONST_PROP_ID_COMPUTE_MB_POWER_STATSINPUT_VOLTAGE_MAX = "computeMbPowerStatsinputVoltageMax"
	CONST_PROP_ID_COMPUTE_MB_POWER_STATSINPUT_VOLTAGE_MIN = "computeMbPowerStatsinputVoltageMin"
	CONST_PROP_ID_COMPUTE_MB_TEMP_STATSFM_TEMP_SEN_IO = "computeMbTempStatsfmTempSenIo"
	CONST_PROP_ID_COMPUTE_MB_TEMP_STATSFM_TEMP_SEN_IO_AVG = "computeMbTempStatsfmTempSenIoAvg"
	CONST_PROP_ID_COMPUTE_MB_TEMP_STATSFM_TEMP_SEN_IO_MAX = "computeMbTempStatsfmTempSenIoMax"
	CONST_PROP_ID_COMPUTE_MB_TEMP_STATSFM_TEMP_SEN_IO_MIN = "computeMbTempStatsfmTempSenIoMin"
	CONST_PROP_ID_COMPUTE_MB_TEMP_STATSFM_TEMP_SEN_REAR = "computeMbTempStatsfmTempSenRear"
	CONST_PROP_ID_COMPUTE_MB_TEMP_STATSFM_TEMP_SEN_REAR_AVG = "computeMbTempStatsfmTempSenRearAvg"
	CONST_PROP_ID_COMPUTE_MB_TEMP_STATSFM_TEMP_SEN_REAR_L = "computeMbTempStatsfmTempSenRearL"
	CONST_PROP_ID_COMPUTE_MB_TEMP_STATSFM_TEMP_SEN_REAR_LAVG = "computeMbTempStatsfmTempSenRearLAvg"
	CONST_PROP_ID_COMPUTE_MB_TEMP_STATSFM_TEMP_SEN_REAR_LMAX = "computeMbTempStatsfmTempSenRearLMax"
	CONST_PROP_ID_COMPUTE_MB_TEMP_STATSFM_TEMP_SEN_REAR_LMIN = "computeMbTempStatsfmTempSenRearLMin"
	CONST_PROP_ID_COMPUTE_MB_TEMP_STATSFM_TEMP_SEN_REAR_MAX = "computeMbTempStatsfmTempSenRearMax"
	CONST_PROP_ID_COMPUTE_MB_TEMP_STATSFM_TEMP_SEN_REAR_MIN = "computeMbTempStatsfmTempSenRearMin"
	CONST_PROP_ID_COMPUTE_MB_TEMP_STATSFM_TEMP_SEN_REAR_R = "computeMbTempStatsfmTempSenRearR"
	CONST_PROP_ID_COMPUTE_MB_TEMP_STATSFM_TEMP_SEN_REAR_RAVG = "computeMbTempStatsfmTempSenRearRAvg"
	CONST_PROP_ID_COMPUTE_MB_TEMP_STATSFM_TEMP_SEN_REAR_RMAX = "computeMbTempStatsfmTempSenRearRMax"
	CONST_PROP_ID_COMPUTE_MB_TEMP_STATSFM_TEMP_SEN_REAR_RMIN = "computeMbTempStatsfmTempSenRearRMin"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_COMPLETION_STATS_ABORT_ERRORS = "computePCIeFatalCompletionStatsAbortErrors"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_COMPLETION_STATS_TIMEOUT_ERRORS = "computePCIeFatalCompletionStatsTimeoutErrors"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_COMPLETION_STATSUNEXPECTED_ERRORS = "computePCIeFatalCompletionStatsunexpectedErrors"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_PROTOCOL_STATSDLLP_ERRORS = "computePCIeFatalProtocolStatsdllpErrors"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_PROTOCOL_STATSFLOW_CONTROL_ERRORS = "computePCIeFatalProtocolStatsflowControlErrors"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_RECEIVE_STATSBUFFER_OVERFLOW_ERRORS = "computePCIeFatalReceiveStatsbufferOverflowErrors"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_RECEIVE_STATSERR_FATAL_ERRORS = "computePCIeFatalReceiveStatserrFatalErrors"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_RECEIVE_STATSERR_NON_FATAL_ERRORS = "computePCIeFatalReceiveStatserrNonFatalErrors"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_RECEIVE_STATSUNSUPPORTED_REQUEST_ERRORS = "computePCIeFatalReceiveStatsunsupportedRequestErrors"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_STATSACS_VIOLATION_ERRORS = "computePCIeFatalStatsacsViolationErrors"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_STATSMALFORMED_TLPERRORS = "computePCIeFatalStatsmalformedTLPErrors"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_STATSPOISONED_TLPERRORS = "computePCIeFatalStatspoisonedTLPErrors"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_STATSSURPRISE_LINK_DOWN_ERRORS = "computePCIeFatalStatssurpriseLinkDownErrors"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATSAMBIENT_TEMP = "computeRackUnitMbTempStatsambientTemp"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATSAMBIENT_TEMP_AVG = "computeRackUnitMbTempStatsambientTempAvg"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATSAMBIENT_TEMP_MAX = "computeRackUnitMbTempStatsambientTempMax"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATSAMBIENT_TEMP_MIN = "computeRackUnitMbTempStatsambientTempMin"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATSFRONT_TEMP = "computeRackUnitMbTempStatsfrontTemp"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATSFRONT_TEMP_AVG = "computeRackUnitMbTempStatsfrontTempAvg"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATSFRONT_TEMP_MAX = "computeRackUnitMbTempStatsfrontTempMax"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATSFRONT_TEMP_MIN = "computeRackUnitMbTempStatsfrontTempMin"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATSIOH1_TEMP = "computeRackUnitMbTempStatsioh1Temp"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATSIOH1_TEMP_AVG = "computeRackUnitMbTempStatsioh1TempAvg"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATSIOH1_TEMP_MAX = "computeRackUnitMbTempStatsioh1TempMax"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATSIOH1_TEMP_MIN = "computeRackUnitMbTempStatsioh1TempMin"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATSIOH2_TEMP = "computeRackUnitMbTempStatsioh2Temp"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATSIOH2_TEMP_AVG = "computeRackUnitMbTempStatsioh2TempAvg"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATSIOH2_TEMP_MAX = "computeRackUnitMbTempStatsioh2TempMax"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATSIOH2_TEMP_MIN = "computeRackUnitMbTempStatsioh2TempMin"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATSREAR_TEMP = "computeRackUnitMbTempStatsrearTemp"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATSREAR_TEMP_AVG = "computeRackUnitMbTempStatsrearTempAvg"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATSREAR_TEMP_MAX = "computeRackUnitMbTempStatsrearTempMax"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATSREAR_TEMP_MIN = "computeRackUnitMbTempStatsrearTempMin"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_STATSINPUT_POWER = "equipmentChassisStatsinputPower"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_STATSINPUT_POWER_AVG = "equipmentChassisStatsinputPowerAvg"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_STATSINPUT_POWER_MAX = "equipmentChassisStatsinputPowerMax"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_STATSINPUT_POWER_MIN = "equipmentChassisStatsinputPowerMin"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_STATSOUTPUT_POWER = "equipmentChassisStatsoutputPower"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_STATSOUTPUT_POWER_AVG = "equipmentChassisStatsoutputPowerAvg"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_STATSOUTPUT_POWER_MAX = "equipmentChassisStatsoutputPowerMax"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_STATSOUTPUT_POWER_MIN = "equipmentChassisStatsoutputPowerMin"
	CONST_PROP_ID_EQUIPMENT_FAN_MODULE_STATSAMBIENT_TEMP = "equipmentFanModuleStatsambientTemp"
	CONST_PROP_ID_EQUIPMENT_FAN_MODULE_STATSAMBIENT_TEMP_AVG = "equipmentFanModuleStatsambientTempAvg"
	CONST_PROP_ID_EQUIPMENT_FAN_MODULE_STATSAMBIENT_TEMP_MAX = "equipmentFanModuleStatsambientTempMax"
	CONST_PROP_ID_EQUIPMENT_FAN_MODULE_STATSAMBIENT_TEMP_MIN = "equipmentFanModuleStatsambientTempMin"
	CONST_PROP_ID_EQUIPMENT_FAN_STATSSPEED = "equipmentFanStatsspeed"
	CONST_PROP_ID_EQUIPMENT_FAN_STATSSPEED_AVG = "equipmentFanStatsspeedAvg"
	CONST_PROP_ID_EQUIPMENT_FAN_STATSSPEED_MAX = "equipmentFanStatsspeedMax"
	CONST_PROP_ID_EQUIPMENT_FAN_STATSSPEED_MIN = "equipmentFanStatsspeedMin"
	CONST_PROP_ID_EQUIPMENT_FEX_ENV_STATSDIE1 = "equipmentFexEnvStatsdie1"
	CONST_PROP_ID_EQUIPMENT_FEX_ENV_STATSDIE1_AVG = "equipmentFexEnvStatsdie1Avg"
	CONST_PROP_ID_EQUIPMENT_FEX_ENV_STATSDIE1_MAX = "equipmentFexEnvStatsdie1Max"
	CONST_PROP_ID_EQUIPMENT_FEX_ENV_STATSDIE1_MIN = "equipmentFexEnvStatsdie1Min"
	CONST_PROP_ID_EQUIPMENT_FEX_ENV_STATSINLET = "equipmentFexEnvStatsinlet"
	CONST_PROP_ID_EQUIPMENT_FEX_ENV_STATSINLET1 = "equipmentFexEnvStatsinlet1"
	CONST_PROP_ID_EQUIPMENT_FEX_ENV_STATSINLET1_AVG = "equipmentFexEnvStatsinlet1Avg"
	CONST_PROP_ID_EQUIPMENT_FEX_ENV_STATSINLET1_MAX = "equipmentFexEnvStatsinlet1Max"
	CONST_PROP_ID_EQUIPMENT_FEX_ENV_STATSINLET1_MIN = "equipmentFexEnvStatsinlet1Min"
	CONST_PROP_ID_EQUIPMENT_FEX_ENV_STATSINLET_AVG = "equipmentFexEnvStatsinletAvg"
	CONST_PROP_ID_EQUIPMENT_FEX_ENV_STATSINLET_MAX = "equipmentFexEnvStatsinletMax"
	CONST_PROP_ID_EQUIPMENT_FEX_ENV_STATSINLET_MIN = "equipmentFexEnvStatsinletMin"
	CONST_PROP_ID_EQUIPMENT_FEX_ENV_STATSOUTLET1 = "equipmentFexEnvStatsoutlet1"
	CONST_PROP_ID_EQUIPMENT_FEX_ENV_STATSOUTLET1_AVG = "equipmentFexEnvStatsoutlet1Avg"
	CONST_PROP_ID_EQUIPMENT_FEX_ENV_STATSOUTLET1_MAX = "equipmentFexEnvStatsoutlet1Max"
	CONST_PROP_ID_EQUIPMENT_FEX_ENV_STATSOUTLET1_MIN = "equipmentFexEnvStatsoutlet1Min"
	CONST_PROP_ID_EQUIPMENT_FEX_ENV_STATSOUTLET2 = "equipmentFexEnvStatsoutlet2"
	CONST_PROP_ID_EQUIPMENT_FEX_ENV_STATSOUTLET2_AVG = "equipmentFexEnvStatsoutlet2Avg"
	CONST_PROP_ID_EQUIPMENT_FEX_ENV_STATSOUTLET2_MAX = "equipmentFexEnvStatsoutlet2Max"
	CONST_PROP_ID_EQUIPMENT_FEX_ENV_STATSOUTLET2_MIN = "equipmentFexEnvStatsoutlet2Min"
	CONST_PROP_ID_EQUIPMENT_FEX_POWER_SUMMARY_MODULE_POWER = "equipmentFexPowerSummaryModulePower"
	CONST_PROP_ID_EQUIPMENT_FEX_POWER_SUMMARY_MODULE_POWER_AVG = "equipmentFexPowerSummaryModulePowerAvg"
	CONST_PROP_ID_EQUIPMENT_FEX_POWER_SUMMARY_MODULE_POWER_MAX = "equipmentFexPowerSummaryModulePowerMax"
	CONST_PROP_ID_EQUIPMENT_FEX_POWER_SUMMARY_MODULE_POWER_MIN = "equipmentFexPowerSummaryModulePowerMin"
	CONST_PROP_ID_EQUIPMENT_FEX_POWER_SUMMARYAVAILABLE_POWER = "equipmentFexPowerSummaryavailablePower"
	CONST_PROP_ID_EQUIPMENT_FEX_POWER_SUMMARYAVAILABLE_POWER_AVG = "equipmentFexPowerSummaryavailablePowerAvg"
	CONST_PROP_ID_EQUIPMENT_FEX_POWER_SUMMARYAVAILABLE_POWER_MAX = "equipmentFexPowerSummaryavailablePowerMax"
	CONST_PROP_ID_EQUIPMENT_FEX_POWER_SUMMARYAVAILABLE_POWER_MIN = "equipmentFexPowerSummaryavailablePowerMin"
	CONST_PROP_ID_EQUIPMENT_FEX_POWER_SUMMARYRESERVED_POWER = "equipmentFexPowerSummaryreservedPower"
	CONST_PROP_ID_EQUIPMENT_FEX_POWER_SUMMARYRESERVED_POWER_AVG = "equipmentFexPowerSummaryreservedPowerAvg"
	CONST_PROP_ID_EQUIPMENT_FEX_POWER_SUMMARYRESERVED_POWER_MAX = "equipmentFexPowerSummaryreservedPowerMax"
	CONST_PROP_ID_EQUIPMENT_FEX_POWER_SUMMARYRESERVED_POWER_MIN = "equipmentFexPowerSummaryreservedPowerMin"
	CONST_PROP_ID_EQUIPMENT_FEX_POWER_SUMMARYTOTAL_POWER = "equipmentFexPowerSummarytotalPower"
	CONST_PROP_ID_EQUIPMENT_FEX_POWER_SUMMARYTOTAL_POWER_AVG = "equipmentFexPowerSummarytotalPowerAvg"
	CONST_PROP_ID_EQUIPMENT_FEX_POWER_SUMMARYTOTAL_POWER_MAX = "equipmentFexPowerSummarytotalPowerMax"
	CONST_PROP_ID_EQUIPMENT_FEX_POWER_SUMMARYTOTAL_POWER_MIN = "equipmentFexPowerSummarytotalPowerMin"
	CONST_PROP_ID_EQUIPMENT_FEX_PSU_INPUT_STATSCURRENT = "equipmentFexPsuInputStatscurrent"
	CONST_PROP_ID_EQUIPMENT_FEX_PSU_INPUT_STATSCURRENT_AVG = "equipmentFexPsuInputStatscurrentAvg"
	CONST_PROP_ID_EQUIPMENT_FEX_PSU_INPUT_STATSCURRENT_MAX = "equipmentFexPsuInputStatscurrentMax"
	CONST_PROP_ID_EQUIPMENT_FEX_PSU_INPUT_STATSCURRENT_MIN = "equipmentFexPsuInputStatscurrentMin"
	CONST_PROP_ID_EQUIPMENT_FEX_PSU_INPUT_STATSPOWER = "equipmentFexPsuInputStatspower"
	CONST_PROP_ID_EQUIPMENT_FEX_PSU_INPUT_STATSPOWER_AVG = "equipmentFexPsuInputStatspowerAvg"
	CONST_PROP_ID_EQUIPMENT_FEX_PSU_INPUT_STATSPOWER_MAX = "equipmentFexPsuInputStatspowerMax"
	CONST_PROP_ID_EQUIPMENT_FEX_PSU_INPUT_STATSPOWER_MIN = "equipmentFexPsuInputStatspowerMin"
	CONST_PROP_ID_EQUIPMENT_FEX_PSU_INPUT_STATSVOLTAGE = "equipmentFexPsuInputStatsvoltage"
	CONST_PROP_ID_EQUIPMENT_FEX_PSU_INPUT_STATSVOLTAGE_AVG = "equipmentFexPsuInputStatsvoltageAvg"
	CONST_PROP_ID_EQUIPMENT_FEX_PSU_INPUT_STATSVOLTAGE_MAX = "equipmentFexPsuInputStatsvoltageMax"
	CONST_PROP_ID_EQUIPMENT_FEX_PSU_INPUT_STATSVOLTAGE_MIN = "equipmentFexPsuInputStatsvoltageMin"
	CONST_PROP_ID_EQUIPMENT_IOCARD_STATSAMBIENT_TEMP = "equipmentIOCardStatsambientTemp"
	CONST_PROP_ID_EQUIPMENT_IOCARD_STATSAMBIENT_TEMP_AVG = "equipmentIOCardStatsambientTempAvg"
	CONST_PROP_ID_EQUIPMENT_IOCARD_STATSAMBIENT_TEMP_MAX = "equipmentIOCardStatsambientTempMax"
	CONST_PROP_ID_EQUIPMENT_IOCARD_STATSAMBIENT_TEMP_MIN = "equipmentIOCardStatsambientTempMin"
	CONST_PROP_ID_EQUIPMENT_IOCARD_STATSTEMP = "equipmentIOCardStatstemp"
	CONST_PROP_ID_EQUIPMENT_IOCARD_STATSTEMP_AVG = "equipmentIOCardStatstempAvg"
	CONST_PROP_ID_EQUIPMENT_IOCARD_STATSTEMP_MAX = "equipmentIOCardStatstempMax"
	CONST_PROP_ID_EQUIPMENT_IOCARD_STATSTEMP_MIN = "equipmentIOCardStatstempMin"
	CONST_PROP_ID_EQUIPMENT_NETWORK_ELEMENT_FAN_STATSDRIVE_PERCENTAGE = "equipmentNetworkElementFanStatsdrivePercentage"
	CONST_PROP_ID_EQUIPMENT_NETWORK_ELEMENT_FAN_STATSDRIVE_PERCENTAGE_AVG = "equipmentNetworkElementFanStatsdrivePercentageAvg"
	CONST_PROP_ID_EQUIPMENT_NETWORK_ELEMENT_FAN_STATSDRIVE_PERCENTAGE_MAX = "equipmentNetworkElementFanStatsdrivePercentageMax"
	CONST_PROP_ID_EQUIPMENT_NETWORK_ELEMENT_FAN_STATSDRIVE_PERCENTAGE_MIN = "equipmentNetworkElementFanStatsdrivePercentageMin"
	CONST_PROP_ID_EQUIPMENT_NETWORK_ELEMENT_FAN_STATSSPEED = "equipmentNetworkElementFanStatsspeed"
	CONST_PROP_ID_EQUIPMENT_NETWORK_ELEMENT_FAN_STATSSPEED_AVG = "equipmentNetworkElementFanStatsspeedAvg"
	CONST_PROP_ID_EQUIPMENT_NETWORK_ELEMENT_FAN_STATSSPEED_MAX = "equipmentNetworkElementFanStatsspeedMax"
	CONST_PROP_ID_EQUIPMENT_NETWORK_ELEMENT_FAN_STATSSPEED_MIN = "equipmentNetworkElementFanStatsspeedMin"
	CONST_PROP_ID_EQUIPMENT_PSU_INPUT_STATSCURRENT = "equipmentPsuInputStatscurrent"
	CONST_PROP_ID_EQUIPMENT_PSU_INPUT_STATSCURRENT_AVG = "equipmentPsuInputStatscurrentAvg"
	CONST_PROP_ID_EQUIPMENT_PSU_INPUT_STATSCURRENT_MAX = "equipmentPsuInputStatscurrentMax"
	CONST_PROP_ID_EQUIPMENT_PSU_INPUT_STATSCURRENT_MIN = "equipmentPsuInputStatscurrentMin"
	CONST_PROP_ID_EQUIPMENT_PSU_INPUT_STATSPOWER = "equipmentPsuInputStatspower"
	CONST_PROP_ID_EQUIPMENT_PSU_INPUT_STATSPOWER_AVG = "equipmentPsuInputStatspowerAvg"
	CONST_PROP_ID_EQUIPMENT_PSU_INPUT_STATSPOWER_MAX = "equipmentPsuInputStatspowerMax"
	CONST_PROP_ID_EQUIPMENT_PSU_INPUT_STATSPOWER_MIN = "equipmentPsuInputStatspowerMin"
	CONST_PROP_ID_EQUIPMENT_PSU_INPUT_STATSVOLTAGE = "equipmentPsuInputStatsvoltage"
	CONST_PROP_ID_EQUIPMENT_PSU_INPUT_STATSVOLTAGE_AVG = "equipmentPsuInputStatsvoltageAvg"
	CONST_PROP_ID_EQUIPMENT_PSU_INPUT_STATSVOLTAGE_MAX = "equipmentPsuInputStatsvoltageMax"
	CONST_PROP_ID_EQUIPMENT_PSU_INPUT_STATSVOLTAGE_MIN = "equipmentPsuInputStatsvoltageMin"
	CONST_PROP_ID_EQUIPMENT_PSU_OUTPUT_STATSCURRENT = "equipmentPsuOutputStatscurrent"
	CONST_PROP_ID_EQUIPMENT_PSU_OUTPUT_STATSCURRENT_AVG = "equipmentPsuOutputStatscurrentAvg"
	CONST_PROP_ID_EQUIPMENT_PSU_OUTPUT_STATSCURRENT_MAX = "equipmentPsuOutputStatscurrentMax"
	CONST_PROP_ID_EQUIPMENT_PSU_OUTPUT_STATSCURRENT_MIN = "equipmentPsuOutputStatscurrentMin"
	CONST_PROP_ID_EQUIPMENT_PSU_OUTPUT_STATSPOWER = "equipmentPsuOutputStatspower"
	CONST_PROP_ID_EQUIPMENT_PSU_OUTPUT_STATSPOWER_AVG = "equipmentPsuOutputStatspowerAvg"
	CONST_PROP_ID_EQUIPMENT_PSU_OUTPUT_STATSPOWER_MAX = "equipmentPsuOutputStatspowerMax"
	CONST_PROP_ID_EQUIPMENT_PSU_OUTPUT_STATSPOWER_MIN = "equipmentPsuOutputStatspowerMin"
	CONST_PROP_ID_EQUIPMENT_PSU_OUTPUT_STATSVOLTAGE = "equipmentPsuOutputStatsvoltage"
	CONST_PROP_ID_EQUIPMENT_PSU_OUTPUT_STATSVOLTAGE_AVG = "equipmentPsuOutputStatsvoltageAvg"
	CONST_PROP_ID_EQUIPMENT_PSU_OUTPUT_STATSVOLTAGE_MAX = "equipmentPsuOutputStatsvoltageMax"
	CONST_PROP_ID_EQUIPMENT_PSU_OUTPUT_STATSVOLTAGE_MIN = "equipmentPsuOutputStatsvoltageMin"
	CONST_PROP_ID_EQUIPMENT_PSU_STATSAMBIENT_TEMP = "equipmentPsuStatsambientTemp"
	CONST_PROP_ID_EQUIPMENT_PSU_STATSAMBIENT_TEMP_AVG = "equipmentPsuStatsambientTempAvg"
	CONST_PROP_ID_EQUIPMENT_PSU_STATSAMBIENT_TEMP_MAX = "equipmentPsuStatsambientTempMax"
	CONST_PROP_ID_EQUIPMENT_PSU_STATSAMBIENT_TEMP_MIN = "equipmentPsuStatsambientTempMin"
	CONST_PROP_ID_EQUIPMENT_PSU_STATSINPUT210V = "equipmentPsuStatsinput210v"
	CONST_PROP_ID_EQUIPMENT_PSU_STATSINPUT210V_AVG = "equipmentPsuStatsinput210vAvg"
	CONST_PROP_ID_EQUIPMENT_PSU_STATSINPUT210V_MAX = "equipmentPsuStatsinput210vMax"
	CONST_PROP_ID_EQUIPMENT_PSU_STATSINPUT210V_MIN = "equipmentPsuStatsinput210vMin"
	CONST_PROP_ID_EQUIPMENT_PSU_STATSOUTPUT12V = "equipmentPsuStatsoutput12v"
	CONST_PROP_ID_EQUIPMENT_PSU_STATSOUTPUT12V_AVG = "equipmentPsuStatsoutput12vAvg"
	CONST_PROP_ID_EQUIPMENT_PSU_STATSOUTPUT12V_MAX = "equipmentPsuStatsoutput12vMax"
	CONST_PROP_ID_EQUIPMENT_PSU_STATSOUTPUT12V_MIN = "equipmentPsuStatsoutput12vMin"
	CONST_PROP_ID_EQUIPMENT_PSU_STATSOUTPUT3V3 = "equipmentPsuStatsoutput3v3"
	CONST_PROP_ID_EQUIPMENT_PSU_STATSOUTPUT3V3_AVG = "equipmentPsuStatsoutput3v3Avg"
	CONST_PROP_ID_EQUIPMENT_PSU_STATSOUTPUT3V3_MAX = "equipmentPsuStatsoutput3v3Max"
	CONST_PROP_ID_EQUIPMENT_PSU_STATSOUTPUT3V3_MIN = "equipmentPsuStatsoutput3v3Min"
	CONST_PROP_ID_EQUIPMENT_PSU_STATSOUTPUT_CURRENT = "equipmentPsuStatsoutputCurrent"
	CONST_PROP_ID_EQUIPMENT_PSU_STATSOUTPUT_CURRENT_AVG = "equipmentPsuStatsoutputCurrentAvg"
	CONST_PROP_ID_EQUIPMENT_PSU_STATSOUTPUT_CURRENT_MAX = "equipmentPsuStatsoutputCurrentMax"
	CONST_PROP_ID_EQUIPMENT_PSU_STATSOUTPUT_CURRENT_MIN = "equipmentPsuStatsoutputCurrentMin"
	CONST_PROP_ID_EQUIPMENT_PSU_STATSOUTPUT_POWER = "equipmentPsuStatsoutputPower"
	CONST_PROP_ID_EQUIPMENT_PSU_STATSOUTPUT_POWER_AVG = "equipmentPsuStatsoutputPowerAvg"
	CONST_PROP_ID_EQUIPMENT_PSU_STATSOUTPUT_POWER_MAX = "equipmentPsuStatsoutputPowerMax"
	CONST_PROP_ID_EQUIPMENT_PSU_STATSOUTPUT_POWER_MIN = "equipmentPsuStatsoutputPowerMin"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_FAN_STATSSPEED = "equipmentRackUnitFanStatsspeed"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_FAN_STATSSPEED_AVG = "equipmentRackUnitFanStatsspeedAvg"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_FAN_STATSSPEED_MAX = "equipmentRackUnitFanStatsspeedMax"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_FAN_STATSSPEED_MIN = "equipmentRackUnitFanStatsspeedMin"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATSAMBIENT_TEMP = "equipmentRackUnitPsuStatsambientTemp"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATSAMBIENT_TEMP_AVG = "equipmentRackUnitPsuStatsambientTempAvg"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATSAMBIENT_TEMP_MAX = "equipmentRackUnitPsuStatsambientTempMax"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATSAMBIENT_TEMP_MIN = "equipmentRackUnitPsuStatsambientTempMin"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATSINPUT_POWER = "equipmentRackUnitPsuStatsinputPower"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATSINPUT_POWER_AVG = "equipmentRackUnitPsuStatsinputPowerAvg"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATSINPUT_POWER_MAX = "equipmentRackUnitPsuStatsinputPowerMax"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATSINPUT_POWER_MIN = "equipmentRackUnitPsuStatsinputPowerMin"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATSINPUT_VOLTAGE = "equipmentRackUnitPsuStatsinputVoltage"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATSINPUT_VOLTAGE_AVG = "equipmentRackUnitPsuStatsinputVoltageAvg"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATSINPUT_VOLTAGE_MAX = "equipmentRackUnitPsuStatsinputVoltageMax"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATSINPUT_VOLTAGE_MIN = "equipmentRackUnitPsuStatsinputVoltageMin"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATSOUTPUT_CURRENT = "equipmentRackUnitPsuStatsoutputCurrent"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATSOUTPUT_CURRENT_AVG = "equipmentRackUnitPsuStatsoutputCurrentAvg"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATSOUTPUT_CURRENT_MAX = "equipmentRackUnitPsuStatsoutputCurrentMax"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATSOUTPUT_CURRENT_MIN = "equipmentRackUnitPsuStatsoutputCurrentMin"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATSOUTPUT_POWER = "equipmentRackUnitPsuStatsoutputPower"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATSOUTPUT_POWER_AVG = "equipmentRackUnitPsuStatsoutputPowerAvg"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATSOUTPUT_POWER_MAX = "equipmentRackUnitPsuStatsoutputPowerMax"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATSOUTPUT_POWER_MIN = "equipmentRackUnitPsuStatsoutputPowerMin"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATSOUTPUT_VOLTAGE = "equipmentRackUnitPsuStatsoutputVoltage"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATSOUTPUT_VOLTAGE_AVG = "equipmentRackUnitPsuStatsoutputVoltageAvg"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATSOUTPUT_VOLTAGE_MAX = "equipmentRackUnitPsuStatsoutputVoltageMax"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATSOUTPUT_VOLTAGE_MIN = "equipmentRackUnitPsuStatsoutputVoltageMin"
	CONST_PROP_ID_ETHER_ERR_STATSALIGN_DELTA = "etherErrStatsalignDelta"
	CONST_PROP_ID_ETHER_ERR_STATSALIGN_DELTA_AVG = "etherErrStatsalignDeltaAvg"
	CONST_PROP_ID_ETHER_ERR_STATSALIGN_DELTA_MAX = "etherErrStatsalignDeltaMax"
	CONST_PROP_ID_ETHER_ERR_STATSALIGN_DELTA_MIN = "etherErrStatsalignDeltaMin"
	CONST_PROP_ID_ETHER_ERR_STATSDEFERRED_TX_DELTA = "etherErrStatsdeferredTxDelta"
	CONST_PROP_ID_ETHER_ERR_STATSDEFERRED_TX_DELTA_AVG = "etherErrStatsdeferredTxDeltaAvg"
	CONST_PROP_ID_ETHER_ERR_STATSDEFERRED_TX_DELTA_MAX = "etherErrStatsdeferredTxDeltaMax"
	CONST_PROP_ID_ETHER_ERR_STATSDEFERRED_TX_DELTA_MIN = "etherErrStatsdeferredTxDeltaMin"
	CONST_PROP_ID_ETHER_ERR_STATSFCS_DELTA = "etherErrStatsfcsDelta"
	CONST_PROP_ID_ETHER_ERR_STATSFCS_DELTA_AVG = "etherErrStatsfcsDeltaAvg"
	CONST_PROP_ID_ETHER_ERR_STATSFCS_DELTA_MAX = "etherErrStatsfcsDeltaMax"
	CONST_PROP_ID_ETHER_ERR_STATSFCS_DELTA_MIN = "etherErrStatsfcsDeltaMin"
	CONST_PROP_ID_ETHER_ERR_STATSINT_MAC_RX_DELTA = "etherErrStatsintMacRxDelta"
	CONST_PROP_ID_ETHER_ERR_STATSINT_MAC_RX_DELTA_AVG = "etherErrStatsintMacRxDeltaAvg"
	CONST_PROP_ID_ETHER_ERR_STATSINT_MAC_RX_DELTA_MAX = "etherErrStatsintMacRxDeltaMax"
	CONST_PROP_ID_ETHER_ERR_STATSINT_MAC_RX_DELTA_MIN = "etherErrStatsintMacRxDeltaMin"
	CONST_PROP_ID_ETHER_ERR_STATSINT_MAC_TX_DELTA = "etherErrStatsintMacTxDelta"
	CONST_PROP_ID_ETHER_ERR_STATSINT_MAC_TX_DELTA_AVG = "etherErrStatsintMacTxDeltaAvg"
	CONST_PROP_ID_ETHER_ERR_STATSINT_MAC_TX_DELTA_MAX = "etherErrStatsintMacTxDeltaMax"
	CONST_PROP_ID_ETHER_ERR_STATSINT_MAC_TX_DELTA_MIN = "etherErrStatsintMacTxDeltaMin"
	CONST_PROP_ID_ETHER_ERR_STATSOUT_DISCARD_DELTA = "etherErrStatsoutDiscardDelta"
	CONST_PROP_ID_ETHER_ERR_STATSOUT_DISCARD_DELTA_AVG = "etherErrStatsoutDiscardDeltaAvg"
	CONST_PROP_ID_ETHER_ERR_STATSOUT_DISCARD_DELTA_MAX = "etherErrStatsoutDiscardDeltaMax"
	CONST_PROP_ID_ETHER_ERR_STATSOUT_DISCARD_DELTA_MIN = "etherErrStatsoutDiscardDeltaMin"
	CONST_PROP_ID_ETHER_ERR_STATSRCV_DELTA = "etherErrStatsrcvDelta"
	CONST_PROP_ID_ETHER_ERR_STATSRCV_DELTA_AVG = "etherErrStatsrcvDeltaAvg"
	CONST_PROP_ID_ETHER_ERR_STATSRCV_DELTA_MAX = "etherErrStatsrcvDeltaMax"
	CONST_PROP_ID_ETHER_ERR_STATSRCV_DELTA_MIN = "etherErrStatsrcvDeltaMin"
	CONST_PROP_ID_ETHER_ERR_STATSUNDER_SIZE_DELTA = "etherErrStatsunderSizeDelta"
	CONST_PROP_ID_ETHER_ERR_STATSUNDER_SIZE_DELTA_AVG = "etherErrStatsunderSizeDeltaAvg"
	CONST_PROP_ID_ETHER_ERR_STATSUNDER_SIZE_DELTA_MAX = "etherErrStatsunderSizeDeltaMax"
	CONST_PROP_ID_ETHER_ERR_STATSUNDER_SIZE_DELTA_MIN = "etherErrStatsunderSizeDeltaMin"
	CONST_PROP_ID_ETHER_ERR_STATSXMIT_DELTA = "etherErrStatsxmitDelta"
	CONST_PROP_ID_ETHER_ERR_STATSXMIT_DELTA_AVG = "etherErrStatsxmitDeltaAvg"
	CONST_PROP_ID_ETHER_ERR_STATSXMIT_DELTA_MAX = "etherErrStatsxmitDeltaMax"
	CONST_PROP_ID_ETHER_ERR_STATSXMIT_DELTA_MIN = "etherErrStatsxmitDeltaMin"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATSBYTES_RX_DELTA = "etherFcoeInterfaceStatsbytesRxDelta"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATSBYTES_RX_DELTA_AVG = "etherFcoeInterfaceStatsbytesRxDeltaAvg"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATSBYTES_RX_DELTA_MAX = "etherFcoeInterfaceStatsbytesRxDeltaMax"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATSBYTES_RX_DELTA_MIN = "etherFcoeInterfaceStatsbytesRxDeltaMin"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATSBYTES_TX_DELTA = "etherFcoeInterfaceStatsbytesTxDelta"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATSBYTES_TX_DELTA_AVG = "etherFcoeInterfaceStatsbytesTxDeltaAvg"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATSBYTES_TX_DELTA_MAX = "etherFcoeInterfaceStatsbytesTxDeltaMax"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATSBYTES_TX_DELTA_MIN = "etherFcoeInterfaceStatsbytesTxDeltaMin"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATSDROPPED_RX_DELTA = "etherFcoeInterfaceStatsdroppedRxDelta"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATSDROPPED_RX_DELTA_AVG = "etherFcoeInterfaceStatsdroppedRxDeltaAvg"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATSDROPPED_RX_DELTA_MAX = "etherFcoeInterfaceStatsdroppedRxDeltaMax"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATSDROPPED_RX_DELTA_MIN = "etherFcoeInterfaceStatsdroppedRxDeltaMin"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATSDROPPED_TX_DELTA = "etherFcoeInterfaceStatsdroppedTxDelta"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATSDROPPED_TX_DELTA_AVG = "etherFcoeInterfaceStatsdroppedTxDeltaAvg"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATSDROPPED_TX_DELTA_MAX = "etherFcoeInterfaceStatsdroppedTxDeltaMax"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATSDROPPED_TX_DELTA_MIN = "etherFcoeInterfaceStatsdroppedTxDeltaMin"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATSERRORS_RX_DELTA = "etherFcoeInterfaceStatserrorsRxDelta"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATSERRORS_RX_DELTA_AVG = "etherFcoeInterfaceStatserrorsRxDeltaAvg"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATSERRORS_RX_DELTA_MAX = "etherFcoeInterfaceStatserrorsRxDeltaMax"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATSERRORS_RX_DELTA_MIN = "etherFcoeInterfaceStatserrorsRxDeltaMin"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATSERRORS_TX_DELTA = "etherFcoeInterfaceStatserrorsTxDelta"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATSERRORS_TX_DELTA_AVG = "etherFcoeInterfaceStatserrorsTxDeltaAvg"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATSERRORS_TX_DELTA_MAX = "etherFcoeInterfaceStatserrorsTxDeltaMax"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATSERRORS_TX_DELTA_MIN = "etherFcoeInterfaceStatserrorsTxDeltaMin"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATSPACKETS_RX_DELTA = "etherFcoeInterfaceStatspacketsRxDelta"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATSPACKETS_RX_DELTA_AVG = "etherFcoeInterfaceStatspacketsRxDeltaAvg"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATSPACKETS_RX_DELTA_MAX = "etherFcoeInterfaceStatspacketsRxDeltaMax"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATSPACKETS_RX_DELTA_MIN = "etherFcoeInterfaceStatspacketsRxDeltaMin"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATSPACKETS_TX_DELTA = "etherFcoeInterfaceStatspacketsTxDelta"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATSPACKETS_TX_DELTA_AVG = "etherFcoeInterfaceStatspacketsTxDeltaAvg"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATSPACKETS_TX_DELTA_MAX = "etherFcoeInterfaceStatspacketsTxDeltaMax"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATSPACKETS_TX_DELTA_MIN = "etherFcoeInterfaceStatspacketsTxDeltaMin"
	CONST_PROP_ID_ETHER_LOSS_STATS_SQETEST_DELTA = "etherLossStatsSQETestDelta"
	CONST_PROP_ID_ETHER_LOSS_STATS_SQETEST_DELTA_AVG = "etherLossStatsSQETestDeltaAvg"
	CONST_PROP_ID_ETHER_LOSS_STATS_SQETEST_DELTA_MAX = "etherLossStatsSQETestDeltaMax"
	CONST_PROP_ID_ETHER_LOSS_STATS_SQETEST_DELTA_MIN = "etherLossStatsSQETestDeltaMin"
	CONST_PROP_ID_ETHER_LOSS_STATSCARRIER_SENSE_DELTA = "etherLossStatscarrierSenseDelta"
	CONST_PROP_ID_ETHER_LOSS_STATSCARRIER_SENSE_DELTA_AVG = "etherLossStatscarrierSenseDeltaAvg"
	CONST_PROP_ID_ETHER_LOSS_STATSCARRIER_SENSE_DELTA_MAX = "etherLossStatscarrierSenseDeltaMax"
	CONST_PROP_ID_ETHER_LOSS_STATSCARRIER_SENSE_DELTA_MIN = "etherLossStatscarrierSenseDeltaMin"
	CONST_PROP_ID_ETHER_LOSS_STATSEXCESS_COLLISION_DELTA = "etherLossStatsexcessCollisionDelta"
	CONST_PROP_ID_ETHER_LOSS_STATSEXCESS_COLLISION_DELTA_AVG = "etherLossStatsexcessCollisionDeltaAvg"
	CONST_PROP_ID_ETHER_LOSS_STATSEXCESS_COLLISION_DELTA_MAX = "etherLossStatsexcessCollisionDeltaMax"
	CONST_PROP_ID_ETHER_LOSS_STATSEXCESS_COLLISION_DELTA_MIN = "etherLossStatsexcessCollisionDeltaMin"
	CONST_PROP_ID_ETHER_LOSS_STATSGIANTS_DELTA = "etherLossStatsgiantsDelta"
	CONST_PROP_ID_ETHER_LOSS_STATSGIANTS_DELTA_AVG = "etherLossStatsgiantsDeltaAvg"
	CONST_PROP_ID_ETHER_LOSS_STATSGIANTS_DELTA_MAX = "etherLossStatsgiantsDeltaMax"
	CONST_PROP_ID_ETHER_LOSS_STATSGIANTS_DELTA_MIN = "etherLossStatsgiantsDeltaMin"
	CONST_PROP_ID_ETHER_LOSS_STATSLATE_COLLISION_DELTA = "etherLossStatslateCollisionDelta"
	CONST_PROP_ID_ETHER_LOSS_STATSLATE_COLLISION_DELTA_AVG = "etherLossStatslateCollisionDeltaAvg"
	CONST_PROP_ID_ETHER_LOSS_STATSLATE_COLLISION_DELTA_MAX = "etherLossStatslateCollisionDeltaMax"
	CONST_PROP_ID_ETHER_LOSS_STATSLATE_COLLISION_DELTA_MIN = "etherLossStatslateCollisionDeltaMin"
	CONST_PROP_ID_ETHER_LOSS_STATSMULTI_COLLISION_DELTA = "etherLossStatsmultiCollisionDelta"
	CONST_PROP_ID_ETHER_LOSS_STATSMULTI_COLLISION_DELTA_AVG = "etherLossStatsmultiCollisionDeltaAvg"
	CONST_PROP_ID_ETHER_LOSS_STATSMULTI_COLLISION_DELTA_MAX = "etherLossStatsmultiCollisionDeltaMax"
	CONST_PROP_ID_ETHER_LOSS_STATSMULTI_COLLISION_DELTA_MIN = "etherLossStatsmultiCollisionDeltaMin"
	CONST_PROP_ID_ETHER_LOSS_STATSSINGLE_COLLISION_DELTA = "etherLossStatssingleCollisionDelta"
	CONST_PROP_ID_ETHER_LOSS_STATSSINGLE_COLLISION_DELTA_AVG = "etherLossStatssingleCollisionDeltaAvg"
	CONST_PROP_ID_ETHER_LOSS_STATSSINGLE_COLLISION_DELTA_MAX = "etherLossStatssingleCollisionDeltaMax"
	CONST_PROP_ID_ETHER_LOSS_STATSSINGLE_COLLISION_DELTA_MIN = "etherLossStatssingleCollisionDeltaMin"
	CONST_PROP_ID_ETHER_LOSS_STATSSYMBOL_DELTA = "etherLossStatssymbolDelta"
	CONST_PROP_ID_ETHER_LOSS_STATSSYMBOL_DELTA_AVG = "etherLossStatssymbolDeltaAvg"
	CONST_PROP_ID_ETHER_LOSS_STATSSYMBOL_DELTA_MAX = "etherLossStatssymbolDeltaMax"
	CONST_PROP_ID_ETHER_LOSS_STATSSYMBOL_DELTA_MIN = "etherLossStatssymbolDeltaMin"
	CONST_PROP_ID_ETHER_PAUSE_STATSRECV_PAUSE_DELTA = "etherPauseStatsrecvPauseDelta"
	CONST_PROP_ID_ETHER_PAUSE_STATSRECV_PAUSE_DELTA_AVG = "etherPauseStatsrecvPauseDeltaAvg"
	CONST_PROP_ID_ETHER_PAUSE_STATSRECV_PAUSE_DELTA_MAX = "etherPauseStatsrecvPauseDeltaMax"
	CONST_PROP_ID_ETHER_PAUSE_STATSRECV_PAUSE_DELTA_MIN = "etherPauseStatsrecvPauseDeltaMin"
	CONST_PROP_ID_ETHER_PAUSE_STATSRESETS_DELTA = "etherPauseStatsresetsDelta"
	CONST_PROP_ID_ETHER_PAUSE_STATSRESETS_DELTA_AVG = "etherPauseStatsresetsDeltaAvg"
	CONST_PROP_ID_ETHER_PAUSE_STATSRESETS_DELTA_MAX = "etherPauseStatsresetsDeltaMax"
	CONST_PROP_ID_ETHER_PAUSE_STATSRESETS_DELTA_MIN = "etherPauseStatsresetsDeltaMin"
	CONST_PROP_ID_ETHER_PAUSE_STATSXMIT_PAUSE_DELTA = "etherPauseStatsxmitPauseDelta"
	CONST_PROP_ID_ETHER_PAUSE_STATSXMIT_PAUSE_DELTA_AVG = "etherPauseStatsxmitPauseDeltaAvg"
	CONST_PROP_ID_ETHER_PAUSE_STATSXMIT_PAUSE_DELTA_MAX = "etherPauseStatsxmitPauseDeltaMax"
	CONST_PROP_ID_ETHER_PAUSE_STATSXMIT_PAUSE_DELTA_MIN = "etherPauseStatsxmitPauseDeltaMin"
	CONST_PROP_ID_ETHER_RX_STATSBROADCAST_PACKETS_DELTA = "etherRxStatsbroadcastPacketsDelta"
	CONST_PROP_ID_ETHER_RX_STATSBROADCAST_PACKETS_DELTA_AVG = "etherRxStatsbroadcastPacketsDeltaAvg"
	CONST_PROP_ID_ETHER_RX_STATSBROADCAST_PACKETS_DELTA_MAX = "etherRxStatsbroadcastPacketsDeltaMax"
	CONST_PROP_ID_ETHER_RX_STATSBROADCAST_PACKETS_DELTA_MIN = "etherRxStatsbroadcastPacketsDeltaMin"
	CONST_PROP_ID_ETHER_RX_STATSJUMBO_PACKETS_DELTA = "etherRxStatsjumboPacketsDelta"
	CONST_PROP_ID_ETHER_RX_STATSJUMBO_PACKETS_DELTA_AVG = "etherRxStatsjumboPacketsDeltaAvg"
	CONST_PROP_ID_ETHER_RX_STATSJUMBO_PACKETS_DELTA_MAX = "etherRxStatsjumboPacketsDeltaMax"
	CONST_PROP_ID_ETHER_RX_STATSJUMBO_PACKETS_DELTA_MIN = "etherRxStatsjumboPacketsDeltaMin"
	CONST_PROP_ID_ETHER_RX_STATSMULTICAST_PACKETS_DELTA = "etherRxStatsmulticastPacketsDelta"
	CONST_PROP_ID_ETHER_RX_STATSMULTICAST_PACKETS_DELTA_AVG = "etherRxStatsmulticastPacketsDeltaAvg"
	CONST_PROP_ID_ETHER_RX_STATSMULTICAST_PACKETS_DELTA_MAX = "etherRxStatsmulticastPacketsDeltaMax"
	CONST_PROP_ID_ETHER_RX_STATSMULTICAST_PACKETS_DELTA_MIN = "etherRxStatsmulticastPacketsDeltaMin"
	CONST_PROP_ID_ETHER_RX_STATSTOTAL_BYTES_DELTA = "etherRxStatstotalBytesDelta"
	CONST_PROP_ID_ETHER_RX_STATSTOTAL_BYTES_DELTA_AVG = "etherRxStatstotalBytesDeltaAvg"
	CONST_PROP_ID_ETHER_RX_STATSTOTAL_BYTES_DELTA_MAX = "etherRxStatstotalBytesDeltaMax"
	CONST_PROP_ID_ETHER_RX_STATSTOTAL_BYTES_DELTA_MIN = "etherRxStatstotalBytesDeltaMin"
	CONST_PROP_ID_ETHER_RX_STATSTOTAL_PACKETS_DELTA = "etherRxStatstotalPacketsDelta"
	CONST_PROP_ID_ETHER_RX_STATSTOTAL_PACKETS_DELTA_AVG = "etherRxStatstotalPacketsDeltaAvg"
	CONST_PROP_ID_ETHER_RX_STATSTOTAL_PACKETS_DELTA_MAX = "etherRxStatstotalPacketsDeltaMax"
	CONST_PROP_ID_ETHER_RX_STATSTOTAL_PACKETS_DELTA_MIN = "etherRxStatstotalPacketsDeltaMin"
	CONST_PROP_ID_ETHER_RX_STATSUNICAST_PACKETS_DELTA = "etherRxStatsunicastPacketsDelta"
	CONST_PROP_ID_ETHER_RX_STATSUNICAST_PACKETS_DELTA_AVG = "etherRxStatsunicastPacketsDeltaAvg"
	CONST_PROP_ID_ETHER_RX_STATSUNICAST_PACKETS_DELTA_MAX = "etherRxStatsunicastPacketsDeltaMax"
	CONST_PROP_ID_ETHER_RX_STATSUNICAST_PACKETS_DELTA_MIN = "etherRxStatsunicastPacketsDeltaMin"
	CONST_PROP_ID_ETHER_TX_STATSBROADCAST_PACKETS_DELTA = "etherTxStatsbroadcastPacketsDelta"
	CONST_PROP_ID_ETHER_TX_STATSBROADCAST_PACKETS_DELTA_AVG = "etherTxStatsbroadcastPacketsDeltaAvg"
	CONST_PROP_ID_ETHER_TX_STATSBROADCAST_PACKETS_DELTA_MAX = "etherTxStatsbroadcastPacketsDeltaMax"
	CONST_PROP_ID_ETHER_TX_STATSBROADCAST_PACKETS_DELTA_MIN = "etherTxStatsbroadcastPacketsDeltaMin"
	CONST_PROP_ID_ETHER_TX_STATSJUMBO_PACKETS_DELTA = "etherTxStatsjumboPacketsDelta"
	CONST_PROP_ID_ETHER_TX_STATSJUMBO_PACKETS_DELTA_AVG = "etherTxStatsjumboPacketsDeltaAvg"
	CONST_PROP_ID_ETHER_TX_STATSJUMBO_PACKETS_DELTA_MAX = "etherTxStatsjumboPacketsDeltaMax"
	CONST_PROP_ID_ETHER_TX_STATSJUMBO_PACKETS_DELTA_MIN = "etherTxStatsjumboPacketsDeltaMin"
	CONST_PROP_ID_ETHER_TX_STATSMULTICAST_PACKETS_DELTA = "etherTxStatsmulticastPacketsDelta"
	CONST_PROP_ID_ETHER_TX_STATSMULTICAST_PACKETS_DELTA_AVG = "etherTxStatsmulticastPacketsDeltaAvg"
	CONST_PROP_ID_ETHER_TX_STATSMULTICAST_PACKETS_DELTA_MAX = "etherTxStatsmulticastPacketsDeltaMax"
	CONST_PROP_ID_ETHER_TX_STATSMULTICAST_PACKETS_DELTA_MIN = "etherTxStatsmulticastPacketsDeltaMin"
	CONST_PROP_ID_ETHER_TX_STATSTOTAL_BYTES_DELTA = "etherTxStatstotalBytesDelta"
	CONST_PROP_ID_ETHER_TX_STATSTOTAL_BYTES_DELTA_AVG = "etherTxStatstotalBytesDeltaAvg"
	CONST_PROP_ID_ETHER_TX_STATSTOTAL_BYTES_DELTA_MAX = "etherTxStatstotalBytesDeltaMax"
	CONST_PROP_ID_ETHER_TX_STATSTOTAL_BYTES_DELTA_MIN = "etherTxStatstotalBytesDeltaMin"
	CONST_PROP_ID_ETHER_TX_STATSTOTAL_PACKETS_DELTA = "etherTxStatstotalPacketsDelta"
	CONST_PROP_ID_ETHER_TX_STATSTOTAL_PACKETS_DELTA_AVG = "etherTxStatstotalPacketsDeltaAvg"
	CONST_PROP_ID_ETHER_TX_STATSTOTAL_PACKETS_DELTA_MAX = "etherTxStatstotalPacketsDeltaMax"
	CONST_PROP_ID_ETHER_TX_STATSTOTAL_PACKETS_DELTA_MIN = "etherTxStatstotalPacketsDeltaMin"
	CONST_PROP_ID_ETHER_TX_STATSUNICAST_PACKETS_DELTA = "etherTxStatsunicastPacketsDelta"
	CONST_PROP_ID_ETHER_TX_STATSUNICAST_PACKETS_DELTA_AVG = "etherTxStatsunicastPacketsDeltaAvg"
	CONST_PROP_ID_ETHER_TX_STATSUNICAST_PACKETS_DELTA_MAX = "etherTxStatsunicastPacketsDeltaMax"
	CONST_PROP_ID_ETHER_TX_STATSUNICAST_PACKETS_DELTA_MIN = "etherTxStatsunicastPacketsDeltaMin"
	CONST_PROP_ID_FC_ERR_STATSCRC_RX_DELTA = "fcErrStatscrcRxDelta"
	CONST_PROP_ID_FC_ERR_STATSCRC_RX_DELTA_AVG = "fcErrStatscrcRxDeltaAvg"
	CONST_PROP_ID_FC_ERR_STATSCRC_RX_DELTA_MAX = "fcErrStatscrcRxDeltaMax"
	CONST_PROP_ID_FC_ERR_STATSCRC_RX_DELTA_MIN = "fcErrStatscrcRxDeltaMin"
	CONST_PROP_ID_FC_ERR_STATSDISCARD_RX_DELTA = "fcErrStatsdiscardRxDelta"
	CONST_PROP_ID_FC_ERR_STATSDISCARD_RX_DELTA_AVG = "fcErrStatsdiscardRxDeltaAvg"
	CONST_PROP_ID_FC_ERR_STATSDISCARD_RX_DELTA_MAX = "fcErrStatsdiscardRxDeltaMax"
	CONST_PROP_ID_FC_ERR_STATSDISCARD_RX_DELTA_MIN = "fcErrStatsdiscardRxDeltaMin"
	CONST_PROP_ID_FC_ERR_STATSDISCARD_TX_DELTA = "fcErrStatsdiscardTxDelta"
	CONST_PROP_ID_FC_ERR_STATSDISCARD_TX_DELTA_AVG = "fcErrStatsdiscardTxDeltaAvg"
	CONST_PROP_ID_FC_ERR_STATSDISCARD_TX_DELTA_MAX = "fcErrStatsdiscardTxDeltaMax"
	CONST_PROP_ID_FC_ERR_STATSDISCARD_TX_DELTA_MIN = "fcErrStatsdiscardTxDeltaMin"
	CONST_PROP_ID_FC_ERR_STATSLINK_FAILURES_DELTA = "fcErrStatslinkFailuresDelta"
	CONST_PROP_ID_FC_ERR_STATSLINK_FAILURES_DELTA_AVG = "fcErrStatslinkFailuresDeltaAvg"
	CONST_PROP_ID_FC_ERR_STATSLINK_FAILURES_DELTA_MAX = "fcErrStatslinkFailuresDeltaMax"
	CONST_PROP_ID_FC_ERR_STATSLINK_FAILURES_DELTA_MIN = "fcErrStatslinkFailuresDeltaMin"
	CONST_PROP_ID_FC_ERR_STATSRX_DELTA = "fcErrStatsrxDelta"
	CONST_PROP_ID_FC_ERR_STATSRX_DELTA_AVG = "fcErrStatsrxDeltaAvg"
	CONST_PROP_ID_FC_ERR_STATSRX_DELTA_MAX = "fcErrStatsrxDeltaMax"
	CONST_PROP_ID_FC_ERR_STATSRX_DELTA_MIN = "fcErrStatsrxDeltaMin"
	CONST_PROP_ID_FC_ERR_STATSSIGNAL_LOSSES_DELTA = "fcErrStatssignalLossesDelta"
	CONST_PROP_ID_FC_ERR_STATSSIGNAL_LOSSES_DELTA_AVG = "fcErrStatssignalLossesDeltaAvg"
	CONST_PROP_ID_FC_ERR_STATSSIGNAL_LOSSES_DELTA_MAX = "fcErrStatssignalLossesDeltaMax"
	CONST_PROP_ID_FC_ERR_STATSSIGNAL_LOSSES_DELTA_MIN = "fcErrStatssignalLossesDeltaMin"
	CONST_PROP_ID_FC_ERR_STATSSYNC_LOSSES_DELTA = "fcErrStatssyncLossesDelta"
	CONST_PROP_ID_FC_ERR_STATSSYNC_LOSSES_DELTA_AVG = "fcErrStatssyncLossesDeltaAvg"
	CONST_PROP_ID_FC_ERR_STATSSYNC_LOSSES_DELTA_MAX = "fcErrStatssyncLossesDeltaMax"
	CONST_PROP_ID_FC_ERR_STATSSYNC_LOSSES_DELTA_MIN = "fcErrStatssyncLossesDeltaMin"
	CONST_PROP_ID_FC_ERR_STATSTOO_LONG_RX_DELTA = "fcErrStatstooLongRxDelta"
	CONST_PROP_ID_FC_ERR_STATSTOO_LONG_RX_DELTA_AVG = "fcErrStatstooLongRxDeltaAvg"
	CONST_PROP_ID_FC_ERR_STATSTOO_LONG_RX_DELTA_MAX = "fcErrStatstooLongRxDeltaMax"
	CONST_PROP_ID_FC_ERR_STATSTOO_LONG_RX_DELTA_MIN = "fcErrStatstooLongRxDeltaMin"
	CONST_PROP_ID_FC_ERR_STATSTOO_SHORT_RX_DELTA = "fcErrStatstooShortRxDelta"
	CONST_PROP_ID_FC_ERR_STATSTOO_SHORT_RX_DELTA_AVG = "fcErrStatstooShortRxDeltaAvg"
	CONST_PROP_ID_FC_ERR_STATSTOO_SHORT_RX_DELTA_MAX = "fcErrStatstooShortRxDeltaMax"
	CONST_PROP_ID_FC_ERR_STATSTOO_SHORT_RX_DELTA_MIN = "fcErrStatstooShortRxDeltaMin"
	CONST_PROP_ID_FC_ERR_STATSTX_DELTA = "fcErrStatstxDelta"
	CONST_PROP_ID_FC_ERR_STATSTX_DELTA_AVG = "fcErrStatstxDeltaAvg"
	CONST_PROP_ID_FC_ERR_STATSTX_DELTA_MAX = "fcErrStatstxDeltaMax"
	CONST_PROP_ID_FC_ERR_STATSTX_DELTA_MIN = "fcErrStatstxDeltaMin"
	CONST_PROP_ID_FC_STATSBYTES_RX_DELTA = "fcStatsbytesRxDelta"
	CONST_PROP_ID_FC_STATSBYTES_RX_DELTA_AVG = "fcStatsbytesRxDeltaAvg"
	CONST_PROP_ID_FC_STATSBYTES_RX_DELTA_MAX = "fcStatsbytesRxDeltaMax"
	CONST_PROP_ID_FC_STATSBYTES_RX_DELTA_MIN = "fcStatsbytesRxDeltaMin"
	CONST_PROP_ID_FC_STATSBYTES_TX_DELTA = "fcStatsbytesTxDelta"
	CONST_PROP_ID_FC_STATSBYTES_TX_DELTA_AVG = "fcStatsbytesTxDeltaAvg"
	CONST_PROP_ID_FC_STATSBYTES_TX_DELTA_MAX = "fcStatsbytesTxDeltaMax"
	CONST_PROP_ID_FC_STATSBYTES_TX_DELTA_MIN = "fcStatsbytesTxDeltaMin"
	CONST_PROP_ID_FC_STATSPACKETS_RX_DELTA = "fcStatspacketsRxDelta"
	CONST_PROP_ID_FC_STATSPACKETS_RX_DELTA_AVG = "fcStatspacketsRxDeltaAvg"
	CONST_PROP_ID_FC_STATSPACKETS_RX_DELTA_MAX = "fcStatspacketsRxDeltaMax"
	CONST_PROP_ID_FC_STATSPACKETS_RX_DELTA_MIN = "fcStatspacketsRxDeltaMin"
	CONST_PROP_ID_FC_STATSPACKETS_TX_DELTA = "fcStatspacketsTxDelta"
	CONST_PROP_ID_FC_STATSPACKETS_TX_DELTA_AVG = "fcStatspacketsTxDeltaAvg"
	CONST_PROP_ID_FC_STATSPACKETS_TX_DELTA_MAX = "fcStatspacketsTxDeltaMax"
	CONST_PROP_ID_FC_STATSPACKETS_TX_DELTA_MIN = "fcStatspacketsTxDeltaMin"
	CONST_PROP_ID_MEMORY_ARRAY_ENV_STATSINPUT_CURRENT = "memoryArrayEnvStatsinputCurrent"
	CONST_PROP_ID_MEMORY_ARRAY_ENV_STATSINPUT_CURRENT_AVG = "memoryArrayEnvStatsinputCurrentAvg"
	CONST_PROP_ID_MEMORY_ARRAY_ENV_STATSINPUT_CURRENT_MAX = "memoryArrayEnvStatsinputCurrentMax"
	CONST_PROP_ID_MEMORY_ARRAY_ENV_STATSINPUT_CURRENT_MIN = "memoryArrayEnvStatsinputCurrentMin"
	CONST_PROP_ID_MEMORY_BUFFER_UNIT_ENV_STATSTEMPERATURE = "memoryBufferUnitEnvStatstemperature"
	CONST_PROP_ID_MEMORY_BUFFER_UNIT_ENV_STATSTEMPERATURE_AVG = "memoryBufferUnitEnvStatstemperatureAvg"
	CONST_PROP_ID_MEMORY_BUFFER_UNIT_ENV_STATSTEMPERATURE_MAX = "memoryBufferUnitEnvStatstemperatureMax"
	CONST_PROP_ID_MEMORY_BUFFER_UNIT_ENV_STATSTEMPERATURE_MIN = "memoryBufferUnitEnvStatstemperatureMin"
	CONST_PROP_ID_MEMORY_ERROR_STATSADDRESS_PARITY_ERRORS = "memoryErrorStatsaddressParityErrors"
	CONST_PROP_ID_MEMORY_ERROR_STATSECC_MULTIBIT_ERRORS = "memoryErrorStatseccMultibitErrors"
	CONST_PROP_ID_MEMORY_ERROR_STATSECC_SINGLEBIT_ERRORS = "memoryErrorStatseccSinglebitErrors"
	CONST_PROP_ID_MEMORY_ERROR_STATSMISMATCH_ERRORS = "memoryErrorStatsmismatchErrors"
	CONST_PROP_ID_MEMORY_RUNTIMEAVAILABLE = "memoryRuntimeavailable"
	CONST_PROP_ID_MEMORY_RUNTIMEAVAILABLE_AVG = "memoryRuntimeavailableAvg"
	CONST_PROP_ID_MEMORY_RUNTIMEAVAILABLE_MAX = "memoryRuntimeavailableMax"
	CONST_PROP_ID_MEMORY_RUNTIMEAVAILABLE_MIN = "memoryRuntimeavailableMin"
	CONST_PROP_ID_MEMORY_RUNTIMECACHED = "memoryRuntimecached"
	CONST_PROP_ID_MEMORY_RUNTIMECACHED_AVG = "memoryRuntimecachedAvg"
	CONST_PROP_ID_MEMORY_RUNTIMECACHED_MAX = "memoryRuntimecachedMax"
	CONST_PROP_ID_MEMORY_RUNTIMECACHED_MIN = "memoryRuntimecachedMin"
	CONST_PROP_ID_MEMORY_RUNTIMETOTAL = "memoryRuntimetotal"
	CONST_PROP_ID_MEMORY_RUNTIMETOTAL_AVG = "memoryRuntimetotalAvg"
	CONST_PROP_ID_MEMORY_RUNTIMETOTAL_MAX = "memoryRuntimetotalMax"
	CONST_PROP_ID_MEMORY_RUNTIMETOTAL_MIN = "memoryRuntimetotalMin"
	CONST_PROP_ID_MEMORY_UNIT_ENV_STATSTEMPERATURE = "memoryUnitEnvStatstemperature"
	CONST_PROP_ID_MEMORY_UNIT_ENV_STATSTEMPERATURE_AVG = "memoryUnitEnvStatstemperatureAvg"
	CONST_PROP_ID_MEMORY_UNIT_ENV_STATSTEMPERATURE_MAX = "memoryUnitEnvStatstemperatureMax"
	CONST_PROP_ID_MEMORY_UNIT_ENV_STATSTEMPERATURE_MIN = "memoryUnitEnvStatstemperatureMin"
	CONST_PROP_ID_POWER_GROUP_STATSPOWER = "powerGroupStatspower"
	CONST_PROP_ID_POWER_GROUP_STATSPOWER_AVG = "powerGroupStatspowerAvg"
	CONST_PROP_ID_POWER_GROUP_STATSPOWER_MAX = "powerGroupStatspowerMax"
	CONST_PROP_ID_POWER_GROUP_STATSPOWER_MIN = "powerGroupStatspowerMin"
	CONST_PROP_ID_PROCESSOR_ENV_STATSINPUT_CURRENT = "processorEnvStatsinputCurrent"
	CONST_PROP_ID_PROCESSOR_ENV_STATSINPUT_CURRENT_AVG = "processorEnvStatsinputCurrentAvg"
	CONST_PROP_ID_PROCESSOR_ENV_STATSINPUT_CURRENT_MAX = "processorEnvStatsinputCurrentMax"
	CONST_PROP_ID_PROCESSOR_ENV_STATSINPUT_CURRENT_MIN = "processorEnvStatsinputCurrentMin"
	CONST_PROP_ID_PROCESSOR_ENV_STATSTEMPERATURE = "processorEnvStatstemperature"
	CONST_PROP_ID_PROCESSOR_ENV_STATSTEMPERATURE_AVG = "processorEnvStatstemperatureAvg"
	CONST_PROP_ID_PROCESSOR_ENV_STATSTEMPERATURE_MAX = "processorEnvStatstemperatureMax"
	CONST_PROP_ID_PROCESSOR_ENV_STATSTEMPERATURE_MIN = "processorEnvStatstemperatureMin"
	CONST_PROP_ID_PROCESSOR_ERROR_STATSMIRRORING_INTER_SOCK_ERRORS = "processorErrorStatsmirroringInterSockErrors"
	CONST_PROP_ID_PROCESSOR_ERROR_STATSMIRRORING_INTRA_SOCK_ERRORS = "processorErrorStatsmirroringIntraSockErrors"
	CONST_PROP_ID_PROCESSOR_ERROR_STATSSMI_LINK_CORR_ERRORS = "processorErrorStatssmiLinkCorrErrors"
	CONST_PROP_ID_PROCESSOR_ERROR_STATSSMI_LINK_UNCORR_ERRORS = "processorErrorStatssmiLinkUncorrErrors"
	CONST_PROP_ID_PROCESSOR_ERROR_STATSSPARING_ERRORS = "processorErrorStatssparingErrors"
	CONST_PROP_ID_PROCESSOR_RUNTIMELOAD = "processorRuntimeload"
	CONST_PROP_ID_PROCESSOR_RUNTIMELOAD_AVG = "processorRuntimeloadAvg"
	CONST_PROP_ID_PROCESSOR_RUNTIMELOAD_MAX = "processorRuntimeloadMax"
	CONST_PROP_ID_PROCESSOR_RUNTIMELOAD_MIN = "processorRuntimeloadMin"
	CONST_PROP_ID_SW_CARD_ENV_STATS_SLOT_OUTLET1 = "swCardEnvStatsSlotOutlet1"
	CONST_PROP_ID_SW_CARD_ENV_STATS_SLOT_OUTLET1_AVG = "swCardEnvStatsSlotOutlet1Avg"
	CONST_PROP_ID_SW_CARD_ENV_STATS_SLOT_OUTLET1_MAX = "swCardEnvStatsSlotOutlet1Max"
	CONST_PROP_ID_SW_CARD_ENV_STATS_SLOT_OUTLET1_MIN = "swCardEnvStatsSlotOutlet1Min"
	CONST_PROP_ID_SW_CARD_ENV_STATS_SLOT_OUTLET2 = "swCardEnvStatsSlotOutlet2"
	CONST_PROP_ID_SW_CARD_ENV_STATS_SLOT_OUTLET2_AVG = "swCardEnvStatsSlotOutlet2Avg"
	CONST_PROP_ID_SW_CARD_ENV_STATS_SLOT_OUTLET2_MAX = "swCardEnvStatsSlotOutlet2Max"
	CONST_PROP_ID_SW_CARD_ENV_STATS_SLOT_OUTLET2_MIN = "swCardEnvStatsSlotOutlet2Min"
	CONST_PROP_ID_SW_CARD_ENV_STATS_SLOT_OUTLET3 = "swCardEnvStatsSlotOutlet3"
	CONST_PROP_ID_SW_CARD_ENV_STATS_SLOT_OUTLET3_AVG = "swCardEnvStatsSlotOutlet3Avg"
	CONST_PROP_ID_SW_CARD_ENV_STATS_SLOT_OUTLET3_MAX = "swCardEnvStatsSlotOutlet3Max"
	CONST_PROP_ID_SW_CARD_ENV_STATS_SLOT_OUTLET3_MIN = "swCardEnvStatsSlotOutlet3Min"
	CONST_PROP_ID_SW_ENV_STATSFAN_CTRLR_INLET1 = "swEnvStatsfanCtrlrInlet1"
	CONST_PROP_ID_SW_ENV_STATSFAN_CTRLR_INLET1_AVG = "swEnvStatsfanCtrlrInlet1Avg"
	CONST_PROP_ID_SW_ENV_STATSFAN_CTRLR_INLET1_MAX = "swEnvStatsfanCtrlrInlet1Max"
	CONST_PROP_ID_SW_ENV_STATSFAN_CTRLR_INLET1_MIN = "swEnvStatsfanCtrlrInlet1Min"
	CONST_PROP_ID_SW_ENV_STATSFAN_CTRLR_INLET2 = "swEnvStatsfanCtrlrInlet2"
	CONST_PROP_ID_SW_ENV_STATSFAN_CTRLR_INLET2_AVG = "swEnvStatsfanCtrlrInlet2Avg"
	CONST_PROP_ID_SW_ENV_STATSFAN_CTRLR_INLET2_MAX = "swEnvStatsfanCtrlrInlet2Max"
	CONST_PROP_ID_SW_ENV_STATSFAN_CTRLR_INLET2_MIN = "swEnvStatsfanCtrlrInlet2Min"
	CONST_PROP_ID_SW_ENV_STATSFAN_CTRLR_INLET3 = "swEnvStatsfanCtrlrInlet3"
	CONST_PROP_ID_SW_ENV_STATSFAN_CTRLR_INLET3_AVG = "swEnvStatsfanCtrlrInlet3Avg"
	CONST_PROP_ID_SW_ENV_STATSFAN_CTRLR_INLET3_MAX = "swEnvStatsfanCtrlrInlet3Max"
	CONST_PROP_ID_SW_ENV_STATSFAN_CTRLR_INLET3_MIN = "swEnvStatsfanCtrlrInlet3Min"
	CONST_PROP_ID_SW_ENV_STATSFAN_CTRLR_INLET4 = "swEnvStatsfanCtrlrInlet4"
	CONST_PROP_ID_SW_ENV_STATSFAN_CTRLR_INLET4_AVG = "swEnvStatsfanCtrlrInlet4Avg"
	CONST_PROP_ID_SW_ENV_STATSFAN_CTRLR_INLET4_MAX = "swEnvStatsfanCtrlrInlet4Max"
	CONST_PROP_ID_SW_ENV_STATSFAN_CTRLR_INLET4_MIN = "swEnvStatsfanCtrlrInlet4Min"
	CONST_PROP_ID_SW_ENV_STATSMAIN_BOARD_OUTLET1 = "swEnvStatsmainBoardOutlet1"
	CONST_PROP_ID_SW_ENV_STATSMAIN_BOARD_OUTLET1_AVG = "swEnvStatsmainBoardOutlet1Avg"
	CONST_PROP_ID_SW_ENV_STATSMAIN_BOARD_OUTLET1_MAX = "swEnvStatsmainBoardOutlet1Max"
	CONST_PROP_ID_SW_ENV_STATSMAIN_BOARD_OUTLET1_MIN = "swEnvStatsmainBoardOutlet1Min"
	CONST_PROP_ID_SW_ENV_STATSMAIN_BOARD_OUTLET2 = "swEnvStatsmainBoardOutlet2"
	CONST_PROP_ID_SW_ENV_STATSMAIN_BOARD_OUTLET2_AVG = "swEnvStatsmainBoardOutlet2Avg"
	CONST_PROP_ID_SW_ENV_STATSMAIN_BOARD_OUTLET2_MAX = "swEnvStatsmainBoardOutlet2Max"
	CONST_PROP_ID_SW_ENV_STATSMAIN_BOARD_OUTLET2_MIN = "swEnvStatsmainBoardOutlet2Min"
	CONST_PROP_ID_SW_ENV_STATSPSU_CTRLR_INLET1 = "swEnvStatspsuCtrlrInlet1"
	CONST_PROP_ID_SW_ENV_STATSPSU_CTRLR_INLET1_AVG = "swEnvStatspsuCtrlrInlet1Avg"
	CONST_PROP_ID_SW_ENV_STATSPSU_CTRLR_INLET1_MAX = "swEnvStatspsuCtrlrInlet1Max"
	CONST_PROP_ID_SW_ENV_STATSPSU_CTRLR_INLET1_MIN = "swEnvStatspsuCtrlrInlet1Min"
	CONST_PROP_ID_SW_ENV_STATSPSU_CTRLR_INLET2 = "swEnvStatspsuCtrlrInlet2"
	CONST_PROP_ID_SW_ENV_STATSPSU_CTRLR_INLET2_AVG = "swEnvStatspsuCtrlrInlet2Avg"
	CONST_PROP_ID_SW_ENV_STATSPSU_CTRLR_INLET2_MAX = "swEnvStatspsuCtrlrInlet2Max"
	CONST_PROP_ID_SW_ENV_STATSPSU_CTRLR_INLET2_MIN = "swEnvStatspsuCtrlrInlet2Min"
	CONST_PROP_ID_SW_SYSTEM_STATSLOAD = "swSystemStatsload"
	CONST_PROP_ID_SW_SYSTEM_STATSLOAD_AVG = "swSystemStatsloadAvg"
	CONST_PROP_ID_SW_SYSTEM_STATSLOAD_MAX = "swSystemStatsloadMax"
	CONST_PROP_ID_SW_SYSTEM_STATSLOAD_MIN = "swSystemStatsloadMin"
	CONST_PROP_ID_SW_SYSTEM_STATSMEM_AVAILABLE = "swSystemStatsmemAvailable"
	CONST_PROP_ID_SW_SYSTEM_STATSMEM_AVAILABLE_AVG = "swSystemStatsmemAvailableAvg"
	CONST_PROP_ID_SW_SYSTEM_STATSMEM_AVAILABLE_MAX = "swSystemStatsmemAvailableMax"
	CONST_PROP_ID_SW_SYSTEM_STATSMEM_AVAILABLE_MIN = "swSystemStatsmemAvailableMin"
	CONST_PROP_ID_SW_SYSTEM_STATSMEM_CACHED = "swSystemStatsmemCached"
	CONST_PROP_ID_SW_SYSTEM_STATSMEM_CACHED_AVG = "swSystemStatsmemCachedAvg"
	CONST_PROP_ID_SW_SYSTEM_STATSMEM_CACHED_MAX = "swSystemStatsmemCachedMax"
	CONST_PROP_ID_SW_SYSTEM_STATSMEM_CACHED_MIN = "swSystemStatsmemCachedMin"
	CONST_PROP_ID_UNSPECIFIED = "unspecified"
	CONST_PROP_TYPE_FLOAT = "float"
	CONST_PROP_TYPE_UINT32 = "uint32"
	CONST_PROP_TYPE_UINT64 = "uint64"

class VnicProfileAlias(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"VnicProfileAlias")

	@staticmethod
	def ClassId():
		return "vnicProfileAlias"

	ALIAS = "Alias"
	DN = "Dn"
	RN = "Rn"
	STATUS = "Status"
	SW_UUID = "SwUuid"


class NetworkIfStats(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"NetworkIfStats")

	@staticmethod
	def ClassId():
		return "networkIfStats"

	DN = "Dn"
	IN = "In"
	OUT = "Out"
	RN = "Rn"
	STATUS = "Status"
	TYPE = "Type"
	UNITS = "Units"

	CONST_TYPE_BROADCAST = "broadcast"
	CONST_TYPE_GENERIC = "generic"
	CONST_TYPE_MULTICAST = "multicast"
	CONST_TYPE_TOTAL = "total"
	CONST_TYPE_UNICAST = "unicast"
	CONST_UNITS_OCTETS = "octets"
	CONST_UNITS_PACKETS = "packets"
	CONST_UNITS_RAW = "raw"

class CommHttps(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"CommHttps")

	@staticmethod
	def ClassId():
		return "commHttps"

	ADMIN_STATE = "AdminState"
	CIPHER_SUITE = "CipherSuite"
	CIPHER_SUITE_MODE = "CipherSuiteMode"
	DESCR = "Descr"
	DN = "Dn"
	KEY_RING = "KeyRing"
	NAME = "Name"
	OPER_PORT = "OperPort"
	POLICY_LEVEL = "PolicyLevel"
	POLICY_OWNER = "PolicyOwner"
	PORT = "Port"
	PROTO = "Proto"
	RN = "Rn"
	STATUS = "Status"

	CONST_ADMIN_STATE_DISABLED = "disabled"
	CONST_ADMIN_STATE_ENABLED = "enabled"
	CONST_CIPHER_SUITE_MODE_CUSTOM = "custom"
	CONST_CIPHER_SUITE_MODE_HIGH_STRENGTH = "high-strength"
	CONST_CIPHER_SUITE_MODE_LOW_STRENGTH = "low-strength"
	CONST_CIPHER_SUITE_MODE_MEDIUM_STRENGTH = "medium-strength"
	CONST_INT_ID_NONE = "none"
	CONST_POLICY_OWNER_LOCAL = "local"
	CONST_POLICY_OWNER_PENDING_POLICY = "pending-policy"
	CONST_POLICY_OWNER_POLICY = "policy"
	CONST_PROTO_ALL = "all"
	CONST_PROTO_NONE = "none"
	CONST_PROTO_TCP = "tcp"
	CONST_PROTO_UDP = "udp"

class FabricEthLanPc(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"FabricEthLanPc")

	@staticmethod
	def ClassId():
		return "fabricEthLanPc"

	ADMIN_SPEED = "AdminSpeed"
	ADMIN_STATE = "AdminState"
	BANDWIDTH = "Bandwidth"
	DESCR = "Descr"
	DN = "Dn"
	EP_DN = "EpDn"
	FLOW_CTRL_POLICY = "FlowCtrlPolicy"
	IF_ROLE = "IfRole"
	IF_TYPE = "IfType"
	LOCALE = "Locale"
	NAME = "Name"
	OPER_SPEED = "OperSpeed"
	OPER_STATE = "OperState"
	OVERLAPPING_VLANS = "OverlappingVlans"
	PEER_DN = "PeerDn"
	PORT_ID = "PortId"
	RN = "Rn"
	STATE_QUAL = "StateQual"
	STATUS = "Status"
	SWITCH_ID = "SwitchId"
	TRANSPORT = "Transport"
	TYPE = "Type"
	VLAN_STATUS = "VlanStatus"
	WARNINGS = "Warnings"

	CONST_ADMIN_SPEED_10GBPS = "10gbps"
	CONST_ADMIN_SPEED_1GBPS = "1gbps"
	CONST_ADMIN_SPEED_20GBPS = "20gbps"
	CONST_ADMIN_SPEED_40GBPS = "40gbps"
	CONST_ADMIN_SPEED_INDETERMINATE = "indeterminate"
	CONST_ADMIN_STATE_DISABLED = "disabled"
	CONST_ADMIN_STATE_ENABLED = "enabled"
	CONST_IF_ROLE_DIAG = "diag"
	CONST_IF_ROLE_FCOE_NAS_STORAGE = "fcoe-nas-storage"
	CONST_IF_ROLE_FCOE_STORAGE = "fcoe-storage"
	CONST_IF_ROLE_FCOE_UPLINK = "fcoe-uplink"
	CONST_IF_ROLE_MGMT = "mgmt"
	CONST_IF_ROLE_MONITOR = "monitor"
	CONST_IF_ROLE_NAS_STORAGE = "nas-storage"
	CONST_IF_ROLE_NETWORK = "network"
	CONST_IF_ROLE_NETWORK_FCOE_UPLINK = "network-fcoe-uplink"
	CONST_IF_ROLE_SERVER = "server"
	CONST_IF_ROLE_SERVICE = "service"
	CONST_IF_ROLE_STORAGE = "storage"
	CONST_IF_ROLE_UNKNOWN = "unknown"
	CONST_IF_TYPE_AGGREGATION = "aggregation"
	CONST_IF_TYPE_PHYSICAL = "physical"
	CONST_IF_TYPE_UNKNOWN = "unknown"
	CONST_IF_TYPE_VIRTUAL = "virtual"
	CONST_OPER_SPEED_10GBPS = "10gbps"
	CONST_OPER_SPEED_1GBPS = "1gbps"
	CONST_OPER_SPEED_20GBPS = "20gbps"
	CONST_OPER_SPEED_40GBPS = "40gbps"
	CONST_OPER_SPEED_INDETERMINATE = "indeterminate"
	CONST_OPER_STATE_ADMIN_DOWN = "admin-down"
	CONST_OPER_STATE_ERROR_DISABLED = "error-disabled"
	CONST_OPER_STATE_FAILED = "failed"
	CONST_OPER_STATE_HARDWARE_FAILURE = "hardware-failure"
	CONST_OPER_STATE_INDETERMINATE = "indeterminate"
	CONST_OPER_STATE_LINK_DOWN = "link-down"
	CONST_OPER_STATE_LINK_UP = "link-up"
	CONST_OPER_STATE_NO_LICENSE = "no-license"
	CONST_OPER_STATE_SFP_NOT_PRESENT = "sfp-not-present"
	CONST_OPER_STATE_SOFTWARE_FAILURE = "software-failure"
	CONST_OPER_STATE_UDLD_AGGR_DOWN = "udld-aggr-down"
	CONST_OPER_STATE_UP = "up"
	CONST_SWITCH_ID_A = "A"
	CONST_SWITCH_ID_B = "B"
	CONST_SWITCH_ID_NONE = "NONE"
	CONST_VLAN_STATUS_MISSING_PRIMARY = "missing-primary"
	CONST_VLAN_STATUS_OK = "ok"

class LsbootUsbInternalImage(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"LsbootUsbInternalImage")

	@staticmethod
	def ClassId():
		return "lsbootUsbInternalImage"

	DN = "Dn"
	ORDER = "Order"
	RN = "Rn"
	STATUS = "Status"
	TYPE = "Type"

	CONST_TYPE_LOCAL_ANY = "local-any"
	CONST_TYPE_LOCAL_HDD = "local-hdd"
	CONST_TYPE_SD_CARD = "sd-card"
	CONST_TYPE_USB_EXTERN = "usb-extern"
	CONST_TYPE_USB_INTERN = "usb-intern"

class EquipmentPicture(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"EquipmentPicture")

	@staticmethod
	def ClassId():
		return "equipmentPicture"

	DN = "Dn"
	FILE_NAME = "FileName"
	RN = "Rn"
	STATUS = "Status"
	TYPE = "Type"

	CONST_TYPE_BACK = "back"
	CONST_TYPE_BOTTOM = "bottom"
	CONST_TYPE_FRONT = "front"
	CONST_TYPE_LEFT = "left"
	CONST_TYPE_RIGHT = "right"
	CONST_TYPE_TOP = "top"
	CONST_TYPE_UNKNOWN = "unknown"

class FabricVlan(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"FabricVlan")

	@staticmethod
	def ClassId():
		return "fabricVlan"

	CLOUD = "Cloud"
	COMPRESSION_TYPE = "CompressionType"
	CONFIG_ISSUES = "ConfigIssues"
	DEFAULT_NET = "DefaultNet"
	DN = "Dn"
	EP_DN = "EpDn"
	GLOBAL = "Global"
	ID = "Id"
	IF_ROLE = "IfRole"
	IF_TYPE = "IfType"
	LOCAL = "Local"
	LOCALE = "Locale"
	MCAST_POLICY_NAME = "McastPolicyName"
	NAME = "Name"
	OPER_MCAST_POLICY_NAME = "OperMcastPolicyName"
	OPER_STATE = "OperState"
	PEER_DN = "PeerDn"
	POLICY_OWNER = "PolicyOwner"
	PUB_NW_DN = "PubNwDn"
	PUB_NW_ID = "PubNwId"
	PUB_NW_NAME = "PubNwName"
	RN = "Rn"
	SHARING = "Sharing"
	STATUS = "Status"
	SWITCH_ID = "SwitchId"
	TRANSPORT = "Transport"
	TYPE = "Type"

	CONST_COMPRESSION_TYPE_EXCLUDED = "excluded"
	CONST_COMPRESSION_TYPE_INCLUDED = "included"
	CONST_DEFAULT_NET_FALSE = "false"
	CONST_DEFAULT_NET_NO = "no"
	CONST_DEFAULT_NET_TRUE = "true"
	CONST_DEFAULT_NET_YES = "yes"
	CONST_IF_ROLE_DIAG = "diag"
	CONST_IF_ROLE_FCOE_NAS_STORAGE = "fcoe-nas-storage"
	CONST_IF_ROLE_FCOE_STORAGE = "fcoe-storage"
	CONST_IF_ROLE_FCOE_UPLINK = "fcoe-uplink"
	CONST_IF_ROLE_MGMT = "mgmt"
	CONST_IF_ROLE_MONITOR = "monitor"
	CONST_IF_ROLE_NAS_STORAGE = "nas-storage"
	CONST_IF_ROLE_NETWORK = "network"
	CONST_IF_ROLE_NETWORK_FCOE_UPLINK = "network-fcoe-uplink"
	CONST_IF_ROLE_SERVER = "server"
	CONST_IF_ROLE_SERVICE = "service"
	CONST_IF_ROLE_STORAGE = "storage"
	CONST_IF_ROLE_UNKNOWN = "unknown"
	CONST_IF_TYPE_AGGREGATION = "aggregation"
	CONST_IF_TYPE_PHYSICAL = "physical"
	CONST_IF_TYPE_UNKNOWN = "unknown"
	CONST_IF_TYPE_VIRTUAL = "virtual"
	CONST_OPER_STATE_ERROR_MISCONFIGURED = "error-misconfigured"
	CONST_OPER_STATE_OK = "ok"
	CONST_POLICY_OWNER_LOCAL = "local"
	CONST_POLICY_OWNER_PENDING_POLICY = "pending-policy"
	CONST_POLICY_OWNER_POLICY = "policy"
	CONST_SHARING_ISOLATED = "isolated"
	CONST_SHARING_NONE = "none"
	CONST_SHARING_PRIMARY = "primary"
	CONST_SWITCH_ID_A = "A"
	CONST_SWITCH_ID_B = "B"
	CONST_SWITCH_ID_NONE = "NONE"
	CONST_SWITCH_ID_DUAL = "dual"

class FabricComputePhEp(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"FabricComputePhEp")

	@staticmethod
	def ClassId():
		return "fabricComputePhEp"

	ADMIN_STATE = "AdminState"
	CHASSIS_ID = "ChassisId"
	CHECKPOINT_TRIG_TS = "CheckpointTrigTs"
	DEEP_CHECKPOINT_TRIG_TS = "DeepCheckpointTrigTs"
	DISC_TRIG_TS = "DiscTrigTs"
	DN = "Dn"
	EP_DN = "EpDn"
	EQ_TYPE = "EqType"
	IF_ROLE = "IfRole"
	IF_TYPE = "IfType"
	LC = "Lc"
	LIC_GP = "LicGP"
	LIC_STATE = "LicState"
	LOCALE = "Locale"
	MODEL = "Model"
	NAME = "Name"
	OPER_STATE = "OperState"
	OPER_STATE_REASON = "OperStateReason"
	PEER_CHASSIS_ID = "PeerChassisId"
	PEER_DN = "PeerDn"
	PEER_PORT_ID = "PeerPortId"
	PEER_SLOT_ID = "PeerSlotId"
	PORT_ID = "PortId"
	PROFILE_DN = "ProfileDn"
	REVISION = "Revision"
	RN = "Rn"
	SERIAL = "Serial"
	SLOT_ID = "SlotId"
	STATUS = "Status"
	SWITCH_ID = "SwitchId"
	TRANSPORT = "Transport"
	TYPE = "Type"
	VENDOR = "Vendor"

	CONST_ADMIN_STATE_DISABLED = "disabled"
	CONST_ADMIN_STATE_ENABLED = "enabled"
	CONST_ADMIN_STATE_REMOVE = "remove"
	CONST_CHASSIS_ID_N_A = "N/A"
	CONST_CHECKPOINT_TRIG_TS_NEVER = "never"
	CONST_DEEP_CHECKPOINT_TRIG_TS_NEVER = "never"
	CONST_DISC_TRIG_TS_NEVER = "never"
	CONST_EQ_TYPE_BLADE = "blade"
	CONST_EQ_TYPE_CHASSIS = "chassis"
	CONST_EQ_TYPE_FEX = "fex"
	CONST_EQ_TYPE_RACK_UNIT = "rack-unit"
	CONST_EQ_TYPE_UNKNOWN = "unknown"
	CONST_IF_ROLE_DIAG = "diag"
	CONST_IF_ROLE_FCOE_NAS_STORAGE = "fcoe-nas-storage"
	CONST_IF_ROLE_FCOE_STORAGE = "fcoe-storage"
	CONST_IF_ROLE_FCOE_UPLINK = "fcoe-uplink"
	CONST_IF_ROLE_MGMT = "mgmt"
	CONST_IF_ROLE_MONITOR = "monitor"
	CONST_IF_ROLE_NAS_STORAGE = "nas-storage"
	CONST_IF_ROLE_NETWORK = "network"
	CONST_IF_ROLE_NETWORK_FCOE_UPLINK = "network-fcoe-uplink"
	CONST_IF_ROLE_SERVER = "server"
	CONST_IF_ROLE_SERVICE = "service"
	CONST_IF_ROLE_STORAGE = "storage"
	CONST_IF_ROLE_UNKNOWN = "unknown"
	CONST_IF_TYPE_AGGREGATION = "aggregation"
	CONST_IF_TYPE_PHYSICAL = "physical"
	CONST_IF_TYPE_UNKNOWN = "unknown"
	CONST_IF_TYPE_VIRTUAL = "virtual"
	CONST_LC_IN_SERVICE = "in-service"
	CONST_LC_MIGRATE = "migrate"
	CONST_LC_OUT_OF_SERVICE = "out-of-service"
	CONST_LIC_STATE_LICENSE_EXPIRED = "license-expired"
	CONST_LIC_STATE_LICENSE_GRACEPERIOD = "license-graceperiod"
	CONST_LIC_STATE_LICENSE_INSUFFICIENT = "license-insufficient"
	CONST_LIC_STATE_LICENSE_OK = "license-ok"
	CONST_LIC_STATE_NOT_APPLICABLE = "not-applicable"
	CONST_LIC_STATE_UNKNOWN = "unknown"
	CONST_OPER_STATE_DOWN = "down"
	CONST_OPER_STATE_ERROR_MISCONFIGURED = "error-misconfigured"
	CONST_OPER_STATE_UNKNOWN = "unknown"
	CONST_OPER_STATE_UP = "up"
	CONST_PEER_CHASSIS_ID_N_A = "N/A"
	CONST_SWITCH_ID_A = "A"
	CONST_SWITCH_ID_B = "B"
	CONST_SWITCH_ID_NONE = "NONE"

class VmVsan(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"VmVsan")

	@staticmethod
	def ClassId():
		return "vmVsan"

	DN = "Dn"
	EP_DN = "EpDn"
	FCOE_VLAN = "FcoeVlan"
	ID = "Id"
	IF_ROLE = "IfRole"
	IF_TYPE = "IfType"
	LOCALE = "Locale"
	NAME = "Name"
	OPER_STATE = "OperState"
	PEER_DN = "PeerDn"
	POLICY_OWNER = "PolicyOwner"
	RN = "Rn"
	STATUS = "Status"
	SWITCH_ID = "SwitchId"
	TRANSPORT = "Transport"
	TYPE = "Type"
	ZONING_STATE = "ZoningState"

	CONST_IF_ROLE_DIAG = "diag"
	CONST_IF_ROLE_FCOE_NAS_STORAGE = "fcoe-nas-storage"
	CONST_IF_ROLE_FCOE_STORAGE = "fcoe-storage"
	CONST_IF_ROLE_FCOE_UPLINK = "fcoe-uplink"
	CONST_IF_ROLE_MGMT = "mgmt"
	CONST_IF_ROLE_MONITOR = "monitor"
	CONST_IF_ROLE_NAS_STORAGE = "nas-storage"
	CONST_IF_ROLE_NETWORK = "network"
	CONST_IF_ROLE_NETWORK_FCOE_UPLINK = "network-fcoe-uplink"
	CONST_IF_ROLE_SERVER = "server"
	CONST_IF_ROLE_SERVICE = "service"
	CONST_IF_ROLE_STORAGE = "storage"
	CONST_IF_ROLE_UNKNOWN = "unknown"
	CONST_IF_TYPE_AGGREGATION = "aggregation"
	CONST_IF_TYPE_PHYSICAL = "physical"
	CONST_IF_TYPE_UNKNOWN = "unknown"
	CONST_IF_TYPE_VIRTUAL = "virtual"
	CONST_OPER_STATE_ERROR_MISCONFIGURED = "error-misconfigured"
	CONST_OPER_STATE_ERROR_RESERVED = "error-reserved"
	CONST_OPER_STATE_OK = "ok"
	CONST_POLICY_OWNER_LOCAL = "local"
	CONST_POLICY_OWNER_PENDING_POLICY = "pending-policy"
	CONST_POLICY_OWNER_POLICY = "policy"
	CONST_SWITCH_ID_A = "A"
	CONST_SWITCH_ID_B = "B"
	CONST_SWITCH_ID_NONE = "NONE"
	CONST_ZONING_STATE_DISABLED = "disabled"
	CONST_ZONING_STATE_ENABLED = "enabled"

class ExtvmmFabricNetwork(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"ExtvmmFabricNetwork")

	@staticmethod
	def ClassId():
		return "extvmmFabricNetwork"

	DESCR = "Descr"
	DN = "Dn"
	GUID = "Guid"
	NAME = "Name"
	NETWORK_TYPE = "NetworkType"
	POLICY_LEVEL = "PolicyLevel"
	POLICY_OWNER = "PolicyOwner"
	REF_OPER_STATE = "RefOperState"
	RN = "Rn"
	STATUS = "Status"

	CONST_INT_ID_NONE = "none"
	CONST_NETWORK_TYPE_CONNECTED = "connected"
	CONST_NETWORK_TYPE_NOT_CONNECTED = "not-connected"
	CONST_NETWORK_TYPE_NOT_CONNECTED_PVLANS = "not-connected-pvlans"
	CONST_POLICY_OWNER_LOCAL = "local"
	CONST_POLICY_OWNER_PENDING_POLICY = "pending-policy"
	CONST_POLICY_OWNER_POLICY = "policy"
	CONST_REF_OPER_STATE_INVALID_REFERENCE = "invalid-reference"
	CONST_REF_OPER_STATE_UP = "up"

class PolicyPolicyEp(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"PolicyPolicyEp")

	@staticmethod
	def ClassId():
		return "policyPolicyEp"

	DN = "Dn"
	RN = "Rn"
	STATUS = "Status"


class NfsMountInstFsmStage(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"NfsMountInstFsmStage")

	@staticmethod
	def ClassId():
		return "nfsMountInstFsmStage"

	DESCR = "Descr"
	DN = "Dn"
	LAST_UPDATE_TIME = "LastUpdateTime"
	NAME = "Name"
	ORDER = "Order"
	RETRY = "Retry"
	RN = "Rn"
	STAGE_STATUS = "StageStatus"
	STATUS = "Status"

	CONST_LAST_UPDATE_TIME_ = ""
	CONST_NAME_MOUNT_BEGIN = "MountBegin"
	CONST_NAME_MOUNT_FAIL = "MountFail"
	CONST_NAME_MOUNT_MOUNT_LOCAL = "MountMountLocal"
	CONST_NAME_MOUNT_MOUNT_PEER = "MountMountPeer"
	CONST_NAME_MOUNT_REGISTER_CLIENT = "MountRegisterClient"
	CONST_NAME_MOUNT_SUCCESS = "MountSuccess"
	CONST_NAME_MOUNT_VERIFY_REGISTRATION = "MountVerifyRegistration"
	CONST_NAME_UNMOUNT_BEGIN = "UnmountBegin"
	CONST_NAME_UNMOUNT_FAIL = "UnmountFail"
	CONST_NAME_UNMOUNT_SUCCESS = "UnmountSuccess"
	CONST_NAME_UNMOUNT_UNMOUNT_LOCAL = "UnmountUnmountLocal"
	CONST_NAME_UNMOUNT_UNMOUNT_PEER = "UnmountUnmountPeer"
	CONST_NAME_NOP = "nop"
	CONST_STAGE_STATUS_FAIL = "fail"
	CONST_STAGE_STATUS_IN_PROGRESS = "inProgress"
	CONST_STAGE_STATUS_NOP = "nop"
	CONST_STAGE_STATUS_PENDING = "pending"
	CONST_STAGE_STATUS_SKIP = "skip"
	CONST_STAGE_STATUS_SUCCESS = "success"
	CONST_STAGE_STATUS_THROTTLED = "throttled"

class EtherPIoFsm(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"EtherPIoFsm")

	@staticmethod
	def ClassId():
		return "etherPIoFsm"

	COMPLETION_TIME = "CompletionTime"
	CURRENT_FSM = "CurrentFsm"
	DESCR = "Descr"
	DN = "Dn"
	INSTANCE_ID = "InstanceId"
	PROGRESS = "Progress"
	RMT_ERR_CODE = "RmtErrCode"
	RMT_ERR_DESCR = "RmtErrDescr"
	RMT_RSLT = "RmtRslt"
	RN = "Rn"
	STATUS = "Status"

	CONST_COMPLETION_TIME_ = ""
	CONST_CURRENT_FSM_IN_COMPAT_SFP_PRESENCE = "InCompatSfpPresence"
	CONST_CURRENT_FSM_IN_COMPAT_SFP_REPLACED = "InCompatSfpReplaced"
	CONST_CURRENT_FSM_NOP = "nop"
	CONST_FSM_STATUS_FAIL = "fail"
	CONST_FSM_STATUS_IN_PROGRESS = "inProgress"
	CONST_FSM_STATUS_NOP = "nop"
	CONST_FSM_STATUS_PENDING = "pending"
	CONST_FSM_STATUS_SKIP = "skip"
	CONST_FSM_STATUS_SUCCESS = "success"
	CONST_FSM_STATUS_THROTTLED = "throttled"
	CONST_RMT_ERR_CODE_ERR_2FA_AUTH_RETRY = "ERR-2fa-auth-retry"
	CONST_RMT_ERR_CODE_ERR_ACTIVATE_FAILED = "ERR-ACTIVATE-failed"
	CONST_RMT_ERR_CODE_ERR_ACTIVATE_IN_PROGRESS = "ERR-ACTIVATE-in-progress"
	CONST_RMT_ERR_CODE_ERR_ACTIVATE_RETRY = "ERR-ACTIVATE-retry"
	CONST_RMT_ERR_CODE_ERR_BIOS_TOKENS_OLD_BIOS = "ERR-BIOS-TOKENS-OLD-BIOS"
	CONST_RMT_ERR_CODE_ERR_BIOS_TOKENS_OLD_CIMC = "ERR-BIOS-TOKENS-OLD-CIMC"
	CONST_RMT_ERR_CODE_ERR_BIOS_NETWORK_BOOT_ORDER_NOT_FOUND = "ERR-BIOS-network-boot-order-not-found"
	CONST_RMT_ERR_CODE_ERR_BOARDCTRLUPDATE_IGNORE = "ERR-BOARDCTRLUPDATE-ignore"
	CONST_RMT_ERR_CODE_ERR_DIAG_CANCELLED = "ERR-DIAG-cancelled"
	CONST_RMT_ERR_CODE_ERR_DIAG_FSM_RESTARTED = "ERR-DIAG-fsm-restarted"
	CONST_RMT_ERR_CODE_ERR_DIAG_TEST_FAILED = "ERR-DIAG-test-failed"
	CONST_RMT_ERR_CODE_ERR_DNLD_AUTHENTICATION_FAILURE = "ERR-DNLD-authentication-failure"
	CONST_RMT_ERR_CODE_ERR_DNLD_HOSTKEY_MISMATCH = "ERR-DNLD-hostkey-mismatch"
	CONST_RMT_ERR_CODE_ERR_DNLD_INVALID_IMAGE = "ERR-DNLD-invalid-image"
	CONST_RMT_ERR_CODE_ERR_DNLD_NO_FILE = "ERR-DNLD-no-file"
	CONST_RMT_ERR_CODE_ERR_DNLD_NO_SPACE = "ERR-DNLD-no-space"
	CONST_RMT_ERR_CODE_ERR_DNS_DELETE_ERROR = "ERR-DNS-delete-error"
	CONST_RMT_ERR_CODE_ERR_DNS_GET_ERROR = "ERR-DNS-get-error"
	CONST_RMT_ERR_CODE_ERR_DNS_SET_ERROR = "ERR-DNS-set-error"
	CONST_RMT_ERR_CODE_ERR_DIAGNOSTICS_IN_PROGRESS = "ERR-Diagnostics-in-progress"
	CONST_RMT_ERR_CODE_ERR_DIAGNOSTICS_MEMTEST_IN_PROGRESS = "ERR-Diagnostics-memtest-in-progress"
	CONST_RMT_ERR_CODE_ERR_DIAGNOSTICS_NETWORK_IN_PROGRESS = "ERR-Diagnostics-network-in-progress"
	CONST_RMT_ERR_CODE_ERR_FILTER_ILLEGAL_FORMAT = "ERR-FILTER-illegal-format"
	CONST_RMT_ERR_CODE_ERR_FSM_NO_SUCH_STATE = "ERR-FSM-no-such-state"
	CONST_RMT_ERR_CODE_ERR_HOST_FRU_IDENTITY_MISMATCH = "ERR-HOST-fru-identity-mismatch"
	CONST_RMT_ERR_CODE_ERR_HTTP_SET_ERROR = "ERR-HTTP-set-error"
	CONST_RMT_ERR_CODE_ERR_HTTPS_SET_ERROR = "ERR-HTTPS-set-error"
	CONST_RMT_ERR_CODE_ERR_IBMC_ANALYZE_RESULTS = "ERR-IBMC-analyze-results"
	CONST_RMT_ERR_CODE_ERR_IBMC_CONNECT_ERROR = "ERR-IBMC-connect-error"
	CONST_RMT_ERR_CODE_ERR_IBMC_FRU_RETRIEVAL_ERROR = "ERR-IBMC-fru-retrieval-error"
	CONST_RMT_ERR_CODE_ERR_IBMC_INVALID_END_POINT_CONFIG = "ERR-IBMC-invalid-end-point-config"
	CONST_RMT_ERR_CODE_ERR_IBMC_RESULTS_NOT_READY = "ERR-IBMC-results-not-ready"
	CONST_RMT_ERR_CODE_ERR_MAX_SUBSCRIPTIONS_ALLOWED_ERROR = "ERR-MAX-subscriptions-allowed-error"
	CONST_RMT_ERR_CODE_ERR_MO_CONFIG_CHILD_OBJECT_CANT_BE_CONFIGURED = "ERR-MO-CONFIG-child-object-cant-be-configured"
	CONST_RMT_ERR_CODE_ERR_MO_META_NO_SUCH_OBJECT_CLASS = "ERR-MO-META-no-such-object-class"
	CONST_RMT_ERR_CODE_ERR_MO_PROPERTY_NO_SUCH_PROPERTY = "ERR-MO-PROPERTY-no-such-property"
	CONST_RMT_ERR_CODE_ERR_MO_PROPERTY_VALUE_OUT_OF_RANGE = "ERR-MO-PROPERTY-value-out-of-range"
	CONST_RMT_ERR_CODE_ERR_MO_ACCESS_DENIED = "ERR-MO-access-denied"
	CONST_RMT_ERR_CODE_ERR_MO_DELETION_RULE_VIOLATION = "ERR-MO-deletion-rule-violation"
	CONST_RMT_ERR_CODE_ERR_MO_DUPLICATE_OBJECT = "ERR-MO-duplicate-object"
	CONST_RMT_ERR_CODE_ERR_MO_ILLEGAL_CONTAINMENT = "ERR-MO-illegal-containment"
	CONST_RMT_ERR_CODE_ERR_MO_ILLEGAL_CREATION = "ERR-MO-illegal-creation"
	CONST_RMT_ERR_CODE_ERR_MO_ILLEGAL_ITERATOR_STATE = "ERR-MO-illegal-iterator-state"
	CONST_RMT_ERR_CODE_ERR_MO_ILLEGAL_OBJECT_LIFECYCLE_TRANSITION = "ERR-MO-illegal-object-lifecycle-transition"
	CONST_RMT_ERR_CODE_ERR_MO_NAMING_RULE_VIOLATION = "ERR-MO-naming-rule-violation"
	CONST_RMT_ERR_CODE_ERR_MO_OBJECT_NOT_FOUND = "ERR-MO-object-not-found"
	CONST_RMT_ERR_CODE_ERR_MO_RESOURCE_ALLOCATION = "ERR-MO-resource-allocation"
	CONST_RMT_ERR_CODE_ERR_NTP_DELETE_ERROR = "ERR-NTP-delete-error"
	CONST_RMT_ERR_CODE_ERR_NTP_GET_ERROR = "ERR-NTP-get-error"
	CONST_RMT_ERR_CODE_ERR_NTP_SET_ERROR = "ERR-NTP-set-error"
	CONST_RMT_ERR_CODE_ERR_POWER_CAP_UNSUPPORTED = "ERR-POWER-CAP-UNSUPPORTED"
	CONST_RMT_ERR_CODE_ERR_SERVER_MIS_CONNECT = "ERR-SERVER-mis-connect"
	CONST_RMT_ERR_CODE_ERR_SWITCH_INVALID_IF_CONFIG = "ERR-SWITCH-invalid-if-config"
	CONST_RMT_ERR_CODE_ERR_TOKEN_REQUEST_DENIED = "ERR-TOKEN-request-denied"
	CONST_RMT_ERR_CODE_ERR_UNABLE_TO_FETCH_BIOS_SETTINGS = "ERR-UNABLE-TO-FETCH-BIOS-SETTINGS"
	CONST_RMT_ERR_CODE_ERR_UPDATE_FAILED = "ERR-UPDATE-failed"
	CONST_RMT_ERR_CODE_ERR_UPDATE_IN_PROGRESS = "ERR-UPDATE-in-progress"
	CONST_RMT_ERR_CODE_ERR_UPDATE_RETRY = "ERR-UPDATE-retry"
	CONST_RMT_ERR_CODE_ERR_AAA_CONFIG_MODIFY_ERROR = "ERR-aaa-config-modify-error"
	CONST_RMT_ERR_CODE_ERR_ACCT_REALM_SET_ERROR = "ERR-acct-realm-set-error"
	CONST_RMT_ERR_CODE_ERR_ADMIN_PASSWD_SET = "ERR-admin-passwd-set"
	CONST_RMT_ERR_CODE_ERR_AUTH_ISSUE = "ERR-auth-issue"
	CONST_RMT_ERR_CODE_ERR_AUTH_REALM_GET_ERROR = "ERR-auth-realm-get-error"
	CONST_RMT_ERR_CODE_ERR_AUTH_REALM_SET_ERROR = "ERR-auth-realm-set-error"
	CONST_RMT_ERR_CODE_ERR_AUTHENTICATION = "ERR-authentication"
	CONST_RMT_ERR_CODE_ERR_AUTHORIZATION_REQUIRED = "ERR-authorization-required"
	CONST_RMT_ERR_CODE_ERR_CLI_SESSION_LIMIT_REACHED = "ERR-cli-session-limit-reached"
	CONST_RMT_ERR_CODE_ERR_CREATE_KEYRING = "ERR-create-keyring"
	CONST_RMT_ERR_CODE_ERR_CREATE_LOCALE = "ERR-create-locale"
	CONST_RMT_ERR_CODE_ERR_CREATE_ROLE = "ERR-create-role"
	CONST_RMT_ERR_CODE_ERR_CREATE_USER = "ERR-create-user"
	CONST_RMT_ERR_CODE_ERR_DELETE_LOCALE = "ERR-delete-locale"
	CONST_RMT_ERR_CODE_ERR_DELETE_ROLE = "ERR-delete-role"
	CONST_RMT_ERR_CODE_ERR_DELETE_SESSION = "ERR-delete-session"
	CONST_RMT_ERR_CODE_ERR_DELETE_USER = "ERR-delete-user"
	CONST_RMT_ERR_CODE_ERR_EFI_DIAGNOSTICS_IN_PROGRESS = "ERR-efi-Diagnostics--in-progress"
	CONST_RMT_ERR_CODE_ERR_ENABLE_MGMT_CONN = "ERR-enable-mgmt-conn"
	CONST_RMT_ERR_CODE_ERR_EP_SET_ERROR = "ERR-ep-set-error"
	CONST_RMT_ERR_CODE_ERR_GET_MAX_HTTP_USER_SESSIONS = "ERR-get-max-http-user-sessions"
	CONST_RMT_ERR_CODE_ERR_HTTP_INITIALIZING = "ERR-http-initializing"
	CONST_RMT_ERR_CODE_ERR_INSUFFICIENTLY_EQUIPPED = "ERR-insufficiently-equipped"
	CONST_RMT_ERR_CODE_ERR_INTERNAL_ERROR = "ERR-internal-error"
	CONST_RMT_ERR_CODE_ERR_LDAP_DELETE_ERROR = "ERR-ldap-delete-error"
	CONST_RMT_ERR_CODE_ERR_LDAP_GET_ERROR = "ERR-ldap-get-error"
	CONST_RMT_ERR_CODE_ERR_LDAP_GROUP_MODIFY_ERROR = "ERR-ldap-group-modify-error"
	CONST_RMT_ERR_CODE_ERR_LDAP_GROUP_SET_ERROR = "ERR-ldap-group-set-error"
	CONST_RMT_ERR_CODE_ERR_LDAP_SET_ERROR = "ERR-ldap-set-error"
	CONST_RMT_ERR_CODE_ERR_LOCALE_SET_ERROR = "ERR-locale-set-error"
	CONST_RMT_ERR_CODE_ERR_MAX_USERID_SESSIONS_REACHED = "ERR-max-userid-sessions-reached"
	CONST_RMT_ERR_CODE_ERR_MISSING_METHOD = "ERR-missing-method"
	CONST_RMT_ERR_CODE_ERR_MODIFY_LOCALE = "ERR-modify-locale"
	CONST_RMT_ERR_CODE_ERR_MODIFY_ROLE = "ERR-modify-role"
	CONST_RMT_ERR_CODE_ERR_MODIFY_USER = "ERR-modify-user"
	CONST_RMT_ERR_CODE_ERR_MODIFY_USER_LOCALE = "ERR-modify-user-locale"
	CONST_RMT_ERR_CODE_ERR_MODIFY_USER_ROLE = "ERR-modify-user-role"
	CONST_RMT_ERR_CODE_ERR_PROVIDER_GROUP_MODIFY_ERROR = "ERR-provider-group-modify-error"
	CONST_RMT_ERR_CODE_ERR_PROVIDER_GROUP_SET_ERROR = "ERR-provider-group-set-error"
	CONST_RMT_ERR_CODE_ERR_RADIUS_GET_ERROR = "ERR-radius-get-error"
	CONST_RMT_ERR_CODE_ERR_RADIUS_GLOBAL_SET_ERROR = "ERR-radius-global-set-error"
	CONST_RMT_ERR_CODE_ERR_RADIUS_GROUP_SET_ERROR = "ERR-radius-group-set-error"
	CONST_RMT_ERR_CODE_ERR_RADIUS_SET_ERROR = "ERR-radius-set-error"
	CONST_RMT_ERR_CODE_ERR_REQUEST_TIMEOUT = "ERR-request-timeout"
	CONST_RMT_ERR_CODE_ERR_RESET_ADAPTER = "ERR-reset-adapter"
	CONST_RMT_ERR_CODE_ERR_ROLE_SET_ERROR = "ERR-role-set-error"
	CONST_RMT_ERR_CODE_ERR_SECONDARY_NODE = "ERR-secondary-node"
	CONST_RMT_ERR_CODE_ERR_SERVICE_NOT_READY = "ERR-service-not-ready"
	CONST_RMT_ERR_CODE_ERR_SESSION_CACHE_FULL = "ERR-session-cache-full"
	CONST_RMT_ERR_CODE_ERR_SESSION_NOT_FOUND = "ERR-session-not-found"
	CONST_RMT_ERR_CODE_ERR_SET_NETWORK = "ERR-set-network"
	CONST_RMT_ERR_CODE_ERR_SET_PASSWORD_STRENGTH_CHECK = "ERR-set-password-strength-check"
	CONST_RMT_ERR_CODE_ERR_SET_PORT_CHANNEL = "ERR-set-port-channel"
	CONST_RMT_ERR_CODE_ERR_STORE_PRE_LOGIN_BANNER_MSG = "ERR-store-pre-login-banner-msg"
	CONST_RMT_ERR_CODE_ERR_TACACS_ENABLE_ERROR = "ERR-tacacs-enable-error"
	CONST_RMT_ERR_CODE_ERR_TACACS_GLOBAL_SET_ERROR = "ERR-tacacs-global-set-error"
	CONST_RMT_ERR_CODE_ERR_TACACS_GROUP_SET_ERROR = "ERR-tacacs-group-set-error"
	CONST_RMT_ERR_CODE_ERR_TACACS_PLUS_GET_ERROR = "ERR-tacacs-plus-get-error"
	CONST_RMT_ERR_CODE_ERR_TACACS_SET_ERROR = "ERR-tacacs-set-error"
	CONST_RMT_ERR_CODE_ERR_TEST_ERROR_1 = "ERR-test-error-1"
	CONST_RMT_ERR_CODE_ERR_TEST_ERROR_2 = "ERR-test-error-2"
	CONST_RMT_ERR_CODE_ERR_TIMEZONE_SET_ERROR = "ERR-timezone-set-error"
	CONST_RMT_ERR_CODE_ERR_USER_ACCOUNT_EXPIRED = "ERR-user-account-expired"
	CONST_RMT_ERR_CODE_ERR_USER_SET_ERROR = "ERR-user-set-error"
	CONST_RMT_ERR_CODE_ERR_XML_PARSE_ERROR = "ERR-xml-parse-error"
	CONST_RMT_ERR_CODE_NONE = "none"

class CallhomePeriodicSystemInventory(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"CallhomePeriodicSystemInventory")

	@staticmethod
	def ClassId():
		return "callhomePeriodicSystemInventory"

	ADMIN_STATE = "AdminState"
	DN = "Dn"
	INTERVAL_DAYS = "IntervalDays"
	LAST_DEADLINE = "LastDeadline"
	MAXIMUM_RETRY_COUNT = "MaximumRetryCount"
	MINIMUM_SEND_NOW_INTERVAL_SECONDS = "MinimumSendNowIntervalSeconds"
	NEXT_DEADLINE = "NextDeadline"
	POLL_INTERVAL_SECONDS = "PollIntervalSeconds"
	RETRY_COUNT = "RetryCount"
	RETRY_DELAY_MINUTES = "RetryDelayMinutes"
	RN = "Rn"
	SEND_NOW = "SendNow"
	STATUS = "Status"
	TIME_OF_DAY_HOUR = "TimeOfDayHour"
	TIME_OF_DAY_MINUTE = "TimeOfDayMinute"
	TIME_OF_LAST_ATTEMPT = "TimeOfLastAttempt"
	TIME_OF_LAST_SUCCESS = "TimeOfLastSuccess"

	CONST_ADMIN_STATE_OFF = "off"
	CONST_ADMIN_STATE_ON = "on"
	CONST_NEXT_DEADLINE_NEVER = "never"
	CONST_SEND_NOW_FALSE = "false"
	CONST_SEND_NOW_NO = "no"
	CONST_SEND_NOW_TRUE = "true"
	CONST_SEND_NOW_YES = "yes"
	CONST_TIME_OF_LAST_SUCCESS_NEVER = "never"

class StatsThresholdPolicy(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"StatsThresholdPolicy")

	@staticmethod
	def ClassId():
		return "statsThresholdPolicy"

	DESCR = "Descr"
	DN = "Dn"
	NAME = "Name"
	POLICY_LEVEL = "PolicyLevel"
	POLICY_OWNER = "PolicyOwner"
	RN = "Rn"
	STATUS = "Status"

	CONST_INT_ID_NONE = "none"
	CONST_POLICY_OWNER_LOCAL = "local"
	CONST_POLICY_OWNER_PENDING_POLICY = "pending-policy"
	CONST_POLICY_OWNER_POLICY = "policy"

class EquipmentPOSTCodeReporter(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"EquipmentPOSTCodeReporter")

	@staticmethod
	def ClassId():
		return "equipmentPOSTCodeReporter"

	BASE_CONTAINER = "BaseContainer"
	DN = "Dn"
	MODEL = "Model"
	NAME = "Name"
	REVISION = "Revision"
	RN = "Rn"
	SERIAL = "Serial"
	STATUS = "Status"
	TYPE = "Type"
	VENDOR = "Vendor"


class SwNetflowExporter(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"SwNetflowExporter")

	@staticmethod
	def ClassId():
		return "swNetflowExporter"

	DESTINATION_IP_ADDRESS = "DestinationIpAddress"
	DESTINATION_PORT = "DestinationPort"
	DN = "Dn"
	DSCP = "Dscp"
	EXPORT_INTERNAL = "ExportInternal"
	EXPORTER_STATS_TIMEOUT = "ExporterStatsTimeout"
	INTERFACE_TABLE_TIMEOUT = "InterfaceTableTimeout"
	IS_VALID_CONFIG = "IsValidConfig"
	LIFE_CYCLE = "LifeCycle"
	NAME = "Name"
	PEER_DN = "PeerDn"
	PROTOCOL = "Protocol"
	RN = "Rn"
	SOURCE_VLAN = "SourceVlan"
	STATUS = "Status"
	SWITCH_ID = "SwitchId"
	TEMPLATE_DATA_TIMEOUT = "TemplateDataTimeout"
	TRANSPORT = "Transport"
	TRANSPORT_PROTOCOL = "TransportProtocol"
	TYPE = "Type"
	VERSION = "Version"

	CONST_IS_VALID_CONFIG_INCOMPLETE = "incomplete"
	CONST_IS_VALID_CONFIG_OK = "ok"
	CONST_LIFE_CYCLE_DELETED = "deleted"
	CONST_LIFE_CYCLE_NEW = "new"
	CONST_LIFE_CYCLE_NORMAL = "normal"
	CONST_PROTOCOL_NETFLOW = "netflow"
	CONST_SWITCH_ID_A = "A"
	CONST_SWITCH_ID_B = "B"
	CONST_SWITCH_ID_NONE = "NONE"
	CONST_TRANSPORT_PROTOCOL_SCTP = "sctp"
	CONST_TRANSPORT_PROTOCOL_UDP = "udp"
	CONST_VERSION_IPFIX = "ipfix"
	CONST_VERSION_V9 = "v9"

class SwFcSanBorderFsm(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"SwFcSanBorderFsm")

	@staticmethod
	def ClassId():
		return "swFcSanBorderFsm"

	COMPLETION_TIME = "CompletionTime"
	CURRENT_FSM = "CurrentFsm"
	DESCR = "Descr"
	DN = "Dn"
	INSTANCE_ID = "InstanceId"
	PROGRESS = "Progress"
	RMT_ERR_CODE = "RmtErrCode"
	RMT_ERR_DESCR = "RmtErrDescr"
	RMT_RSLT = "RmtRslt"
	RN = "Rn"
	STATUS = "Status"

	CONST_COMPLETION_TIME_ = ""
	CONST_CURRENT_FSM_ACTIVATE_ZONE_SET = "ActivateZoneSet"
	CONST_CURRENT_FSM_DEPLOY = "Deploy"
	CONST_CURRENT_FSM_NOP = "nop"
	CONST_FSM_STATUS_FAIL = "fail"
	CONST_FSM_STATUS_IN_PROGRESS = "inProgress"
	CONST_FSM_STATUS_NOP = "nop"
	CONST_FSM_STATUS_PENDING = "pending"
	CONST_FSM_STATUS_SKIP = "skip"
	CONST_FSM_STATUS_SUCCESS = "success"
	CONST_FSM_STATUS_THROTTLED = "throttled"
	CONST_RMT_ERR_CODE_ERR_2FA_AUTH_RETRY = "ERR-2fa-auth-retry"
	CONST_RMT_ERR_CODE_ERR_ACTIVATE_FAILED = "ERR-ACTIVATE-failed"
	CONST_RMT_ERR_CODE_ERR_ACTIVATE_IN_PROGRESS = "ERR-ACTIVATE-in-progress"
	CONST_RMT_ERR_CODE_ERR_ACTIVATE_RETRY = "ERR-ACTIVATE-retry"
	CONST_RMT_ERR_CODE_ERR_BIOS_TOKENS_OLD_BIOS = "ERR-BIOS-TOKENS-OLD-BIOS"
	CONST_RMT_ERR_CODE_ERR_BIOS_TOKENS_OLD_CIMC = "ERR-BIOS-TOKENS-OLD-CIMC"
	CONST_RMT_ERR_CODE_ERR_BIOS_NETWORK_BOOT_ORDER_NOT_FOUND = "ERR-BIOS-network-boot-order-not-found"
	CONST_RMT_ERR_CODE_ERR_BOARDCTRLUPDATE_IGNORE = "ERR-BOARDCTRLUPDATE-ignore"
	CONST_RMT_ERR_CODE_ERR_DIAG_CANCELLED = "ERR-DIAG-cancelled"
	CONST_RMT_ERR_CODE_ERR_DIAG_FSM_RESTARTED = "ERR-DIAG-fsm-restarted"
	CONST_RMT_ERR_CODE_ERR_DIAG_TEST_FAILED = "ERR-DIAG-test-failed"
	CONST_RMT_ERR_CODE_ERR_DNLD_AUTHENTICATION_FAILURE = "ERR-DNLD-authentication-failure"
	CONST_RMT_ERR_CODE_ERR_DNLD_HOSTKEY_MISMATCH = "ERR-DNLD-hostkey-mismatch"
	CONST_RMT_ERR_CODE_ERR_DNLD_INVALID_IMAGE = "ERR-DNLD-invalid-image"
	CONST_RMT_ERR_CODE_ERR_DNLD_NO_FILE = "ERR-DNLD-no-file"
	CONST_RMT_ERR_CODE_ERR_DNLD_NO_SPACE = "ERR-DNLD-no-space"
	CONST_RMT_ERR_CODE_ERR_DNS_DELETE_ERROR = "ERR-DNS-delete-error"
	CONST_RMT_ERR_CODE_ERR_DNS_GET_ERROR = "ERR-DNS-get-error"
	CONST_RMT_ERR_CODE_ERR_DNS_SET_ERROR = "ERR-DNS-set-error"
	CONST_RMT_ERR_CODE_ERR_DIAGNOSTICS_IN_PROGRESS = "ERR-Diagnostics-in-progress"
	CONST_RMT_ERR_CODE_ERR_DIAGNOSTICS_MEMTEST_IN_PROGRESS = "ERR-Diagnostics-memtest-in-progress"
	CONST_RMT_ERR_CODE_ERR_DIAGNOSTICS_NETWORK_IN_PROGRESS = "ERR-Diagnostics-network-in-progress"
	CONST_RMT_ERR_CODE_ERR_FILTER_ILLEGAL_FORMAT = "ERR-FILTER-illegal-format"
	CONST_RMT_ERR_CODE_ERR_FSM_NO_SUCH_STATE = "ERR-FSM-no-such-state"
	CONST_RMT_ERR_CODE_ERR_HOST_FRU_IDENTITY_MISMATCH = "ERR-HOST-fru-identity-mismatch"
	CONST_RMT_ERR_CODE_ERR_HTTP_SET_ERROR = "ERR-HTTP-set-error"
	CONST_RMT_ERR_CODE_ERR_HTTPS_SET_ERROR = "ERR-HTTPS-set-error"
	CONST_RMT_ERR_CODE_ERR_IBMC_ANALYZE_RESULTS = "ERR-IBMC-analyze-results"
	CONST_RMT_ERR_CODE_ERR_IBMC_CONNECT_ERROR = "ERR-IBMC-connect-error"
	CONST_RMT_ERR_CODE_ERR_IBMC_FRU_RETRIEVAL_ERROR = "ERR-IBMC-fru-retrieval-error"
	CONST_RMT_ERR_CODE_ERR_IBMC_INVALID_END_POINT_CONFIG = "ERR-IBMC-invalid-end-point-config"
	CONST_RMT_ERR_CODE_ERR_IBMC_RESULTS_NOT_READY = "ERR-IBMC-results-not-ready"
	CONST_RMT_ERR_CODE_ERR_MAX_SUBSCRIPTIONS_ALLOWED_ERROR = "ERR-MAX-subscriptions-allowed-error"
	CONST_RMT_ERR_CODE_ERR_MO_CONFIG_CHILD_OBJECT_CANT_BE_CONFIGURED = "ERR-MO-CONFIG-child-object-cant-be-configured"
	CONST_RMT_ERR_CODE_ERR_MO_META_NO_SUCH_OBJECT_CLASS = "ERR-MO-META-no-such-object-class"
	CONST_RMT_ERR_CODE_ERR_MO_PROPERTY_NO_SUCH_PROPERTY = "ERR-MO-PROPERTY-no-such-property"
	CONST_RMT_ERR_CODE_ERR_MO_PROPERTY_VALUE_OUT_OF_RANGE = "ERR-MO-PROPERTY-value-out-of-range"
	CONST_RMT_ERR_CODE_ERR_MO_ACCESS_DENIED = "ERR-MO-access-denied"
	CONST_RMT_ERR_CODE_ERR_MO_DELETION_RULE_VIOLATION = "ERR-MO-deletion-rule-violation"
	CONST_RMT_ERR_CODE_ERR_MO_DUPLICATE_OBJECT = "ERR-MO-duplicate-object"
	CONST_RMT_ERR_CODE_ERR_MO_ILLEGAL_CONTAINMENT = "ERR-MO-illegal-containment"
	CONST_RMT_ERR_CODE_ERR_MO_ILLEGAL_CREATION = "ERR-MO-illegal-creation"
	CONST_RMT_ERR_CODE_ERR_MO_ILLEGAL_ITERATOR_STATE = "ERR-MO-illegal-iterator-state"
	CONST_RMT_ERR_CODE_ERR_MO_ILLEGAL_OBJECT_LIFECYCLE_TRANSITION = "ERR-MO-illegal-object-lifecycle-transition"
	CONST_RMT_ERR_CODE_ERR_MO_NAMING_RULE_VIOLATION = "ERR-MO-naming-rule-violation"
	CONST_RMT_ERR_CODE_ERR_MO_OBJECT_NOT_FOUND = "ERR-MO-object-not-found"
	CONST_RMT_ERR_CODE_ERR_MO_RESOURCE_ALLOCATION = "ERR-MO-resource-allocation"
	CONST_RMT_ERR_CODE_ERR_NTP_DELETE_ERROR = "ERR-NTP-delete-error"
	CONST_RMT_ERR_CODE_ERR_NTP_GET_ERROR = "ERR-NTP-get-error"
	CONST_RMT_ERR_CODE_ERR_NTP_SET_ERROR = "ERR-NTP-set-error"
	CONST_RMT_ERR_CODE_ERR_POWER_CAP_UNSUPPORTED = "ERR-POWER-CAP-UNSUPPORTED"
	CONST_RMT_ERR_CODE_ERR_SERVER_MIS_CONNECT = "ERR-SERVER-mis-connect"
	CONST_RMT_ERR_CODE_ERR_SWITCH_INVALID_IF_CONFIG = "ERR-SWITCH-invalid-if-config"
	CONST_RMT_ERR_CODE_ERR_TOKEN_REQUEST_DENIED = "ERR-TOKEN-request-denied"
	CONST_RMT_ERR_CODE_ERR_UNABLE_TO_FETCH_BIOS_SETTINGS = "ERR-UNABLE-TO-FETCH-BIOS-SETTINGS"
	CONST_RMT_ERR_CODE_ERR_UPDATE_FAILED = "ERR-UPDATE-failed"
	CONST_RMT_ERR_CODE_ERR_UPDATE_IN_PROGRESS = "ERR-UPDATE-in-progress"
	CONST_RMT_ERR_CODE_ERR_UPDATE_RETRY = "ERR-UPDATE-retry"
	CONST_RMT_ERR_CODE_ERR_AAA_CONFIG_MODIFY_ERROR = "ERR-aaa-config-modify-error"
	CONST_RMT_ERR_CODE_ERR_ACCT_REALM_SET_ERROR = "ERR-acct-realm-set-error"
	CONST_RMT_ERR_CODE_ERR_ADMIN_PASSWD_SET = "ERR-admin-passwd-set"
	CONST_RMT_ERR_CODE_ERR_AUTH_ISSUE = "ERR-auth-issue"
	CONST_RMT_ERR_CODE_ERR_AUTH_REALM_GET_ERROR = "ERR-auth-realm-get-error"
	CONST_RMT_ERR_CODE_ERR_AUTH_REALM_SET_ERROR = "ERR-auth-realm-set-error"
	CONST_RMT_ERR_CODE_ERR_AUTHENTICATION = "ERR-authentication"
	CONST_RMT_ERR_CODE_ERR_AUTHORIZATION_REQUIRED = "ERR-authorization-required"
	CONST_RMT_ERR_CODE_ERR_CLI_SESSION_LIMIT_REACHED = "ERR-cli-session-limit-reached"
	CONST_RMT_ERR_CODE_ERR_CREATE_KEYRING = "ERR-create-keyring"
	CONST_RMT_ERR_CODE_ERR_CREATE_LOCALE = "ERR-create-locale"
	CONST_RMT_ERR_CODE_ERR_CREATE_ROLE = "ERR-create-role"
	CONST_RMT_ERR_CODE_ERR_CREATE_USER = "ERR-create-user"
	CONST_RMT_ERR_CODE_ERR_DELETE_LOCALE = "ERR-delete-locale"
	CONST_RMT_ERR_CODE_ERR_DELETE_ROLE = "ERR-delete-role"
	CONST_RMT_ERR_CODE_ERR_DELETE_SESSION = "ERR-delete-session"
	CONST_RMT_ERR_CODE_ERR_DELETE_USER = "ERR-delete-user"
	CONST_RMT_ERR_CODE_ERR_EFI_DIAGNOSTICS_IN_PROGRESS = "ERR-efi-Diagnostics--in-progress"
	CONST_RMT_ERR_CODE_ERR_ENABLE_MGMT_CONN = "ERR-enable-mgmt-conn"
	CONST_RMT_ERR_CODE_ERR_EP_SET_ERROR = "ERR-ep-set-error"
	CONST_RMT_ERR_CODE_ERR_GET_MAX_HTTP_USER_SESSIONS = "ERR-get-max-http-user-sessions"
	CONST_RMT_ERR_CODE_ERR_HTTP_INITIALIZING = "ERR-http-initializing"
	CONST_RMT_ERR_CODE_ERR_INSUFFICIENTLY_EQUIPPED = "ERR-insufficiently-equipped"
	CONST_RMT_ERR_CODE_ERR_INTERNAL_ERROR = "ERR-internal-error"
	CONST_RMT_ERR_CODE_ERR_LDAP_DELETE_ERROR = "ERR-ldap-delete-error"
	CONST_RMT_ERR_CODE_ERR_LDAP_GET_ERROR = "ERR-ldap-get-error"
	CONST_RMT_ERR_CODE_ERR_LDAP_GROUP_MODIFY_ERROR = "ERR-ldap-group-modify-error"
	CONST_RMT_ERR_CODE_ERR_LDAP_GROUP_SET_ERROR = "ERR-ldap-group-set-error"
	CONST_RMT_ERR_CODE_ERR_LDAP_SET_ERROR = "ERR-ldap-set-error"
	CONST_RMT_ERR_CODE_ERR_LOCALE_SET_ERROR = "ERR-locale-set-error"
	CONST_RMT_ERR_CODE_ERR_MAX_USERID_SESSIONS_REACHED = "ERR-max-userid-sessions-reached"
	CONST_RMT_ERR_CODE_ERR_MISSING_METHOD = "ERR-missing-method"
	CONST_RMT_ERR_CODE_ERR_MODIFY_LOCALE = "ERR-modify-locale"
	CONST_RMT_ERR_CODE_ERR_MODIFY_ROLE = "ERR-modify-role"
	CONST_RMT_ERR_CODE_ERR_MODIFY_USER = "ERR-modify-user"
	CONST_RMT_ERR_CODE_ERR_MODIFY_USER_LOCALE = "ERR-modify-user-locale"
	CONST_RMT_ERR_CODE_ERR_MODIFY_USER_ROLE = "ERR-modify-user-role"
	CONST_RMT_ERR_CODE_ERR_PROVIDER_GROUP_MODIFY_ERROR = "ERR-provider-group-modify-error"
	CONST_RMT_ERR_CODE_ERR_PROVIDER_GROUP_SET_ERROR = "ERR-provider-group-set-error"
	CONST_RMT_ERR_CODE_ERR_RADIUS_GET_ERROR = "ERR-radius-get-error"
	CONST_RMT_ERR_CODE_ERR_RADIUS_GLOBAL_SET_ERROR = "ERR-radius-global-set-error"
	CONST_RMT_ERR_CODE_ERR_RADIUS_GROUP_SET_ERROR = "ERR-radius-group-set-error"
	CONST_RMT_ERR_CODE_ERR_RADIUS_SET_ERROR = "ERR-radius-set-error"
	CONST_RMT_ERR_CODE_ERR_REQUEST_TIMEOUT = "ERR-request-timeout"
	CONST_RMT_ERR_CODE_ERR_RESET_ADAPTER = "ERR-reset-adapter"
	CONST_RMT_ERR_CODE_ERR_ROLE_SET_ERROR = "ERR-role-set-error"
	CONST_RMT_ERR_CODE_ERR_SECONDARY_NODE = "ERR-secondary-node"
	CONST_RMT_ERR_CODE_ERR_SERVICE_NOT_READY = "ERR-service-not-ready"
	CONST_RMT_ERR_CODE_ERR_SESSION_CACHE_FULL = "ERR-session-cache-full"
	CONST_RMT_ERR_CODE_ERR_SESSION_NOT_FOUND = "ERR-session-not-found"
	CONST_RMT_ERR_CODE_ERR_SET_NETWORK = "ERR-set-network"
	CONST_RMT_ERR_CODE_ERR_SET_PASSWORD_STRENGTH_CHECK = "ERR-set-password-strength-check"
	CONST_RMT_ERR_CODE_ERR_SET_PORT_CHANNEL = "ERR-set-port-channel"
	CONST_RMT_ERR_CODE_ERR_STORE_PRE_LOGIN_BANNER_MSG = "ERR-store-pre-login-banner-msg"
	CONST_RMT_ERR_CODE_ERR_TACACS_ENABLE_ERROR = "ERR-tacacs-enable-error"
	CONST_RMT_ERR_CODE_ERR_TACACS_GLOBAL_SET_ERROR = "ERR-tacacs-global-set-error"
	CONST_RMT_ERR_CODE_ERR_TACACS_GROUP_SET_ERROR = "ERR-tacacs-group-set-error"
	CONST_RMT_ERR_CODE_ERR_TACACS_PLUS_GET_ERROR = "ERR-tacacs-plus-get-error"
	CONST_RMT_ERR_CODE_ERR_TACACS_SET_ERROR = "ERR-tacacs-set-error"
	CONST_RMT_ERR_CODE_ERR_TEST_ERROR_1 = "ERR-test-error-1"
	CONST_RMT_ERR_CODE_ERR_TEST_ERROR_2 = "ERR-test-error-2"
	CONST_RMT_ERR_CODE_ERR_TIMEZONE_SET_ERROR = "ERR-timezone-set-error"
	CONST_RMT_ERR_CODE_ERR_USER_ACCOUNT_EXPIRED = "ERR-user-account-expired"
	CONST_RMT_ERR_CODE_ERR_USER_SET_ERROR = "ERR-user-set-error"
	CONST_RMT_ERR_CODE_ERR_XML_PARSE_ERROR = "ERR-xml-parse-error"
	CONST_RMT_ERR_CODE_NONE = "none"

class IdentIdentRequestFsmTask(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"IdentIdentRequestFsmTask")

	@staticmethod
	def ClassId():
		return "identIdentRequestFsmTask"

	COMPLETION = "Completion"
	DN = "Dn"
	FLAGS = "Flags"
	ITEM = "Item"
	RN = "Rn"
	SEQ_ID = "SeqId"
	STATUS = "Status"

	CONST_COMPLETION_CANCELLED = "cancelled"
	CONST_COMPLETION_COMPLETED = "completed"
	CONST_COMPLETION_PROCESSING = "processing"
	CONST_COMPLETION_SCHEDULED = "scheduled"
	CONST_ITEM_NOP = "nop"
	CONST_ITEM_UPDATE_IDENT = "updateIdent"

class PortPIoFsm(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"PortPIoFsm")

	@staticmethod
	def ClassId():
		return "portPIoFsm"

	COMPLETION_TIME = "CompletionTime"
	CURRENT_FSM = "CurrentFsm"
	DESCR = "Descr"
	DN = "Dn"
	INSTANCE_ID = "InstanceId"
	PROGRESS = "Progress"
	RMT_ERR_CODE = "RmtErrCode"
	RMT_ERR_DESCR = "RmtErrDescr"
	RMT_RSLT = "RmtRslt"
	RN = "Rn"
	STATUS = "Status"

	CONST_COMPLETION_TIME_ = ""
	CONST_CURRENT_FSM_IN_COMPAT_SFP_PRESENCE = "InCompatSfpPresence"
	CONST_CURRENT_FSM_IN_COMPAT_SFP_REPLACED = "InCompatSfpReplaced"
	CONST_CURRENT_FSM_NOP = "nop"
	CONST_FSM_STATUS_FAIL = "fail"
	CONST_FSM_STATUS_IN_PROGRESS = "inProgress"
	CONST_FSM_STATUS_NOP = "nop"
	CONST_FSM_STATUS_PENDING = "pending"
	CONST_FSM_STATUS_SKIP = "skip"
	CONST_FSM_STATUS_SUCCESS = "success"
	CONST_FSM_STATUS_THROTTLED = "throttled"
	CONST_RMT_ERR_CODE_ERR_2FA_AUTH_RETRY = "ERR-2fa-auth-retry"
	CONST_RMT_ERR_CODE_ERR_ACTIVATE_FAILED = "ERR-ACTIVATE-failed"
	CONST_RMT_ERR_CODE_ERR_ACTIVATE_IN_PROGRESS = "ERR-ACTIVATE-in-progress"
	CONST_RMT_ERR_CODE_ERR_ACTIVATE_RETRY = "ERR-ACTIVATE-retry"
	CONST_RMT_ERR_CODE_ERR_BIOS_TOKENS_OLD_BIOS = "ERR-BIOS-TOKENS-OLD-BIOS"
	CONST_RMT_ERR_CODE_ERR_BIOS_TOKENS_OLD_CIMC = "ERR-BIOS-TOKENS-OLD-CIMC"
	CONST_RMT_ERR_CODE_ERR_BIOS_NETWORK_BOOT_ORDER_NOT_FOUND = "ERR-BIOS-network-boot-order-not-found"
	CONST_RMT_ERR_CODE_ERR_BOARDCTRLUPDATE_IGNORE = "ERR-BOARDCTRLUPDATE-ignore"
	CONST_RMT_ERR_CODE_ERR_DIAG_CANCELLED = "ERR-DIAG-cancelled"
	CONST_RMT_ERR_CODE_ERR_DIAG_FSM_RESTARTED = "ERR-DIAG-fsm-restarted"
	CONST_RMT_ERR_CODE_ERR_DIAG_TEST_FAILED = "ERR-DIAG-test-failed"
	CONST_RMT_ERR_CODE_ERR_DNLD_AUTHENTICATION_FAILURE = "ERR-DNLD-authentication-failure"
	CONST_RMT_ERR_CODE_ERR_DNLD_HOSTKEY_MISMATCH = "ERR-DNLD-hostkey-mismatch"
	CONST_RMT_ERR_CODE_ERR_DNLD_INVALID_IMAGE = "ERR-DNLD-invalid-image"
	CONST_RMT_ERR_CODE_ERR_DNLD_NO_FILE = "ERR-DNLD-no-file"
	CONST_RMT_ERR_CODE_ERR_DNLD_NO_SPACE = "ERR-DNLD-no-space"
	CONST_RMT_ERR_CODE_ERR_DNS_DELETE_ERROR = "ERR-DNS-delete-error"
	CONST_RMT_ERR_CODE_ERR_DNS_GET_ERROR = "ERR-DNS-get-error"
	CONST_RMT_ERR_CODE_ERR_DNS_SET_ERROR = "ERR-DNS-set-error"
	CONST_RMT_ERR_CODE_ERR_DIAGNOSTICS_IN_PROGRESS = "ERR-Diagnostics-in-progress"
	CONST_RMT_ERR_CODE_ERR_DIAGNOSTICS_MEMTEST_IN_PROGRESS = "ERR-Diagnostics-memtest-in-progress"
	CONST_RMT_ERR_CODE_ERR_DIAGNOSTICS_NETWORK_IN_PROGRESS = "ERR-Diagnostics-network-in-progress"
	CONST_RMT_ERR_CODE_ERR_FILTER_ILLEGAL_FORMAT = "ERR-FILTER-illegal-format"
	CONST_RMT_ERR_CODE_ERR_FSM_NO_SUCH_STATE = "ERR-FSM-no-such-state"
	CONST_RMT_ERR_CODE_ERR_HOST_FRU_IDENTITY_MISMATCH = "ERR-HOST-fru-identity-mismatch"
	CONST_RMT_ERR_CODE_ERR_HTTP_SET_ERROR = "ERR-HTTP-set-error"
	CONST_RMT_ERR_CODE_ERR_HTTPS_SET_ERROR = "ERR-HTTPS-set-error"
	CONST_RMT_ERR_CODE_ERR_IBMC_ANALYZE_RESULTS = "ERR-IBMC-analyze-results"
	CONST_RMT_ERR_CODE_ERR_IBMC_CONNECT_ERROR = "ERR-IBMC-connect-error"
	CONST_RMT_ERR_CODE_ERR_IBMC_FRU_RETRIEVAL_ERROR = "ERR-IBMC-fru-retrieval-error"
	CONST_RMT_ERR_CODE_ERR_IBMC_INVALID_END_POINT_CONFIG = "ERR-IBMC-invalid-end-point-config"
	CONST_RMT_ERR_CODE_ERR_IBMC_RESULTS_NOT_READY = "ERR-IBMC-results-not-ready"
	CONST_RMT_ERR_CODE_ERR_MAX_SUBSCRIPTIONS_ALLOWED_ERROR = "ERR-MAX-subscriptions-allowed-error"
	CONST_RMT_ERR_CODE_ERR_MO_CONFIG_CHILD_OBJECT_CANT_BE_CONFIGURED = "ERR-MO-CONFIG-child-object-cant-be-configured"
	CONST_RMT_ERR_CODE_ERR_MO_META_NO_SUCH_OBJECT_CLASS = "ERR-MO-META-no-such-object-class"
	CONST_RMT_ERR_CODE_ERR_MO_PROPERTY_NO_SUCH_PROPERTY = "ERR-MO-PROPERTY-no-such-property"
	CONST_RMT_ERR_CODE_ERR_MO_PROPERTY_VALUE_OUT_OF_RANGE = "ERR-MO-PROPERTY-value-out-of-range"
	CONST_RMT_ERR_CODE_ERR_MO_ACCESS_DENIED = "ERR-MO-access-denied"
	CONST_RMT_ERR_CODE_ERR_MO_DELETION_RULE_VIOLATION = "ERR-MO-deletion-rule-violation"
	CONST_RMT_ERR_CODE_ERR_MO_DUPLICATE_OBJECT = "ERR-MO-duplicate-object"
	CONST_RMT_ERR_CODE_ERR_MO_ILLEGAL_CONTAINMENT = "ERR-MO-illegal-containment"
	CONST_RMT_ERR_CODE_ERR_MO_ILLEGAL_CREATION = "ERR-MO-illegal-creation"
	CONST_RMT_ERR_CODE_ERR_MO_ILLEGAL_ITERATOR_STATE = "ERR-MO-illegal-iterator-state"
	CONST_RMT_ERR_CODE_ERR_MO_ILLEGAL_OBJECT_LIFECYCLE_TRANSITION = "ERR-MO-illegal-object-lifecycle-transition"
	CONST_RMT_ERR_CODE_ERR_MO_NAMING_RULE_VIOLATION = "ERR-MO-naming-rule-violation"
	CONST_RMT_ERR_CODE_ERR_MO_OBJECT_NOT_FOUND = "ERR-MO-object-not-found"
	CONST_RMT_ERR_CODE_ERR_MO_RESOURCE_ALLOCATION = "ERR-MO-resource-allocation"
	CONST_RMT_ERR_CODE_ERR_NTP_DELETE_ERROR = "ERR-NTP-delete-error"
	CONST_RMT_ERR_CODE_ERR_NTP_GET_ERROR = "ERR-NTP-get-error"
	CONST_RMT_ERR_CODE_ERR_NTP_SET_ERROR = "ERR-NTP-set-error"
	CONST_RMT_ERR_CODE_ERR_POWER_CAP_UNSUPPORTED = "ERR-POWER-CAP-UNSUPPORTED"
	CONST_RMT_ERR_CODE_ERR_SERVER_MIS_CONNECT = "ERR-SERVER-mis-connect"
	CONST_RMT_ERR_CODE_ERR_SWITCH_INVALID_IF_CONFIG = "ERR-SWITCH-invalid-if-config"
	CONST_RMT_ERR_CODE_ERR_TOKEN_REQUEST_DENIED = "ERR-TOKEN-request-denied"
	CONST_RMT_ERR_CODE_ERR_UNABLE_TO_FETCH_BIOS_SETTINGS = "ERR-UNABLE-TO-FETCH-BIOS-SETTINGS"
	CONST_RMT_ERR_CODE_ERR_UPDATE_FAILED = "ERR-UPDATE-failed"
	CONST_RMT_ERR_CODE_ERR_UPDATE_IN_PROGRESS = "ERR-UPDATE-in-progress"
	CONST_RMT_ERR_CODE_ERR_UPDATE_RETRY = "ERR-UPDATE-retry"
	CONST_RMT_ERR_CODE_ERR_AAA_CONFIG_MODIFY_ERROR = "ERR-aaa-config-modify-error"
	CONST_RMT_ERR_CODE_ERR_ACCT_REALM_SET_ERROR = "ERR-acct-realm-set-error"
	CONST_RMT_ERR_CODE_ERR_ADMIN_PASSWD_SET = "ERR-admin-passwd-set"
	CONST_RMT_ERR_CODE_ERR_AUTH_ISSUE = "ERR-auth-issue"
	CONST_RMT_ERR_CODE_ERR_AUTH_REALM_GET_ERROR = "ERR-auth-realm-get-error"
	CONST_RMT_ERR_CODE_ERR_AUTH_REALM_SET_ERROR = "ERR-auth-realm-set-error"
	CONST_RMT_ERR_CODE_ERR_AUTHENTICATION = "ERR-authentication"
	CONST_RMT_ERR_CODE_ERR_AUTHORIZATION_REQUIRED = "ERR-authorization-required"
	CONST_RMT_ERR_CODE_ERR_CLI_SESSION_LIMIT_REACHED = "ERR-cli-session-limit-reached"
	CONST_RMT_ERR_CODE_ERR_CREATE_KEYRING = "ERR-create-keyring"
	CONST_RMT_ERR_CODE_ERR_CREATE_LOCALE = "ERR-create-locale"
	CONST_RMT_ERR_CODE_ERR_CREATE_ROLE = "ERR-create-role"
	CONST_RMT_ERR_CODE_ERR_CREATE_USER = "ERR-create-user"
	CONST_RMT_ERR_CODE_ERR_DELETE_LOCALE = "ERR-delete-locale"
	CONST_RMT_ERR_CODE_ERR_DELETE_ROLE = "ERR-delete-role"
	CONST_RMT_ERR_CODE_ERR_DELETE_SESSION = "ERR-delete-session"
	CONST_RMT_ERR_CODE_ERR_DELETE_USER = "ERR-delete-user"
	CONST_RMT_ERR_CODE_ERR_EFI_DIAGNOSTICS_IN_PROGRESS = "ERR-efi-Diagnostics--in-progress"
	CONST_RMT_ERR_CODE_ERR_ENABLE_MGMT_CONN = "ERR-enable-mgmt-conn"
	CONST_RMT_ERR_CODE_ERR_EP_SET_ERROR = "ERR-ep-set-error"
	CONST_RMT_ERR_CODE_ERR_GET_MAX_HTTP_USER_SESSIONS = "ERR-get-max-http-user-sessions"
	CONST_RMT_ERR_CODE_ERR_HTTP_INITIALIZING = "ERR-http-initializing"
	CONST_RMT_ERR_CODE_ERR_INSUFFICIENTLY_EQUIPPED = "ERR-insufficiently-equipped"
	CONST_RMT_ERR_CODE_ERR_INTERNAL_ERROR = "ERR-internal-error"
	CONST_RMT_ERR_CODE_ERR_LDAP_DELETE_ERROR = "ERR-ldap-delete-error"
	CONST_RMT_ERR_CODE_ERR_LDAP_GET_ERROR = "ERR-ldap-get-error"
	CONST_RMT_ERR_CODE_ERR_LDAP_GROUP_MODIFY_ERROR = "ERR-ldap-group-modify-error"
	CONST_RMT_ERR_CODE_ERR_LDAP_GROUP_SET_ERROR = "ERR-ldap-group-set-error"
	CONST_RMT_ERR_CODE_ERR_LDAP_SET_ERROR = "ERR-ldap-set-error"
	CONST_RMT_ERR_CODE_ERR_LOCALE_SET_ERROR = "ERR-locale-set-error"
	CONST_RMT_ERR_CODE_ERR_MAX_USERID_SESSIONS_REACHED = "ERR-max-userid-sessions-reached"
	CONST_RMT_ERR_CODE_ERR_MISSING_METHOD = "ERR-missing-method"
	CONST_RMT_ERR_CODE_ERR_MODIFY_LOCALE = "ERR-modify-locale"
	CONST_RMT_ERR_CODE_ERR_MODIFY_ROLE = "ERR-modify-role"
	CONST_RMT_ERR_CODE_ERR_MODIFY_USER = "ERR-modify-user"
	CONST_RMT_ERR_CODE_ERR_MODIFY_USER_LOCALE = "ERR-modify-user-locale"
	CONST_RMT_ERR_CODE_ERR_MODIFY_USER_ROLE = "ERR-modify-user-role"
	CONST_RMT_ERR_CODE_ERR_PROVIDER_GROUP_MODIFY_ERROR = "ERR-provider-group-modify-error"
	CONST_RMT_ERR_CODE_ERR_PROVIDER_GROUP_SET_ERROR = "ERR-provider-group-set-error"
	CONST_RMT_ERR_CODE_ERR_RADIUS_GET_ERROR = "ERR-radius-get-error"
	CONST_RMT_ERR_CODE_ERR_RADIUS_GLOBAL_SET_ERROR = "ERR-radius-global-set-error"
	CONST_RMT_ERR_CODE_ERR_RADIUS_GROUP_SET_ERROR = "ERR-radius-group-set-error"
	CONST_RMT_ERR_CODE_ERR_RADIUS_SET_ERROR = "ERR-radius-set-error"
	CONST_RMT_ERR_CODE_ERR_REQUEST_TIMEOUT = "ERR-request-timeout"
	CONST_RMT_ERR_CODE_ERR_RESET_ADAPTER = "ERR-reset-adapter"
	CONST_RMT_ERR_CODE_ERR_ROLE_SET_ERROR = "ERR-role-set-error"
	CONST_RMT_ERR_CODE_ERR_SECONDARY_NODE = "ERR-secondary-node"
	CONST_RMT_ERR_CODE_ERR_SERVICE_NOT_READY = "ERR-service-not-ready"
	CONST_RMT_ERR_CODE_ERR_SESSION_CACHE_FULL = "ERR-session-cache-full"
	CONST_RMT_ERR_CODE_ERR_SESSION_NOT_FOUND = "ERR-session-not-found"
	CONST_RMT_ERR_CODE_ERR_SET_NETWORK = "ERR-set-network"
	CONST_RMT_ERR_CODE_ERR_SET_PASSWORD_STRENGTH_CHECK = "ERR-set-password-strength-check"
	CONST_RMT_ERR_CODE_ERR_SET_PORT_CHANNEL = "ERR-set-port-channel"
	CONST_RMT_ERR_CODE_ERR_STORE_PRE_LOGIN_BANNER_MSG = "ERR-store-pre-login-banner-msg"
	CONST_RMT_ERR_CODE_ERR_TACACS_ENABLE_ERROR = "ERR-tacacs-enable-error"
	CONST_RMT_ERR_CODE_ERR_TACACS_GLOBAL_SET_ERROR = "ERR-tacacs-global-set-error"
	CONST_RMT_ERR_CODE_ERR_TACACS_GROUP_SET_ERROR = "ERR-tacacs-group-set-error"
	CONST_RMT_ERR_CODE_ERR_TACACS_PLUS_GET_ERROR = "ERR-tacacs-plus-get-error"
	CONST_RMT_ERR_CODE_ERR_TACACS_SET_ERROR = "ERR-tacacs-set-error"
	CONST_RMT_ERR_CODE_ERR_TEST_ERROR_1 = "ERR-test-error-1"
	CONST_RMT_ERR_CODE_ERR_TEST_ERROR_2 = "ERR-test-error-2"
	CONST_RMT_ERR_CODE_ERR_TIMEZONE_SET_ERROR = "ERR-timezone-set-error"
	CONST_RMT_ERR_CODE_ERR_USER_ACCOUNT_EXPIRED = "ERR-user-account-expired"
	CONST_RMT_ERR_CODE_ERR_USER_SET_ERROR = "ERR-user-set-error"
	CONST_RMT_ERR_CODE_ERR_XML_PARSE_ERROR = "ERR-xml-parse-error"
	CONST_RMT_ERR_CODE_NONE = "none"

class SwNetflowRecordDef(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"SwNetflowRecordDef")

	@staticmethod
	def ClassId():
		return "swNetflowRecordDef"

	DN = "Dn"
	IPV4KEYS = "Ipv4keys"
	IPV6KEYS = "Ipv6keys"
	KEY_TYPE = "KeyType"
	L2KEYS = "L2keys"
	LIFE_CYCLE = "LifeCycle"
	NAME = "Name"
	NONKEYS = "Nonkeys"
	PEER_DN = "PeerDn"
	PROTOCOL = "Protocol"
	RN = "Rn"
	STATUS = "Status"
	SWITCH_ID = "SwitchId"
	TRANSPORT = "Transport"
	TYPE = "Type"

	CONST_KEY_TYPE_IPV4KEYS = "ipv4keys"
	CONST_KEY_TYPE_IPV6KEYS = "ipv6keys"
	CONST_KEY_TYPE_L2KEYS = "l2keys"
	CONST_LIFE_CYCLE_DELETED = "deleted"
	CONST_LIFE_CYCLE_NEW = "new"
	CONST_LIFE_CYCLE_NORMAL = "normal"
	CONST_PROTOCOL_NETFLOW = "netflow"
	CONST_SWITCH_ID_A = "A"
	CONST_SWITCH_ID_B = "B"
	CONST_SWITCH_ID_NONE = "NONE"

class EquipmentGraphicsCardCapRef(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"EquipmentGraphicsCardCapRef")

	@staticmethod
	def ClassId():
		return "equipmentGraphicsCardCapRef"

	DN = "Dn"
	MODEL = "Model"
	REVISION = "Revision"
	RN = "Rn"
	STATUS = "Status"
	VENDOR = "Vendor"


class SysdebugAutoCoreFileExportTargetFsmTask(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"SysdebugAutoCoreFileExportTargetFsmTask")

	@staticmethod
	def ClassId():
		return "sysdebugAutoCoreFileExportTargetFsmTask"

	COMPLETION = "Completion"
	DN = "Dn"
	FLAGS = "Flags"
	ITEM = "Item"
	RN = "Rn"
	SEQ_ID = "SeqId"
	STATUS = "Status"

	CONST_COMPLETION_CANCELLED = "cancelled"
	CONST_COMPLETION_COMPLETED = "completed"
	CONST_COMPLETION_PROCESSING = "processing"
	CONST_COMPLETION_SCHEDULED = "scheduled"
	CONST_ITEM_CONFIGURE = "Configure"
	CONST_ITEM_NOP = "nop"

class CallhomePolicy(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"CallhomePolicy")

	@staticmethod
	def ClassId():
		return "callhomePolicy"

	ADMIN_STATE = "AdminState"
	CAUSE = "Cause"
	DESCR = "Descr"
	DN = "Dn"
	NAME = "Name"
	RN = "Rn"
	STATUS = "Status"

	CONST_ADMIN_STATE_DISABLED = "disabled"
	CONST_ADMIN_STATE_ENABLED = "enabled"
	CONST_CAUSE_ARP_TARGETS_CONFIG_ERROR = "arp-targets-config-error"
	CONST_CAUSE_ASSOCIATION_FAILED = "association-failed"
	CONST_CAUSE_CONFIGURATION_FAILURE = "configuration-failure"
	CONST_CAUSE_CONNECTIVITY_PROBLEM = "connectivity-problem"
	CONST_CAUSE_ELECTION_FAILURE = "election-failure"
	CONST_CAUSE_EQUIPMENT_DEGRADED = "equipment-degraded"
	CONST_CAUSE_EQUIPMENT_DISABLED = "equipment-disabled"
	CONST_CAUSE_EQUIPMENT_INACCESSIBLE = "equipment-inaccessible"
	CONST_CAUSE_EQUIPMENT_INOPERABLE = "equipment-inoperable"
	CONST_CAUSE_EQUIPMENT_OFFLINE = "equipment-offline"
	CONST_CAUSE_EQUIPMENT_PROBLEM = "equipment-problem"
	CONST_CAUSE_FRU_PROBLEM = "fru-problem"
	CONST_CAUSE_IDENTITY_UNESTABLISHABLE = "identity-unestablishable"
	CONST_CAUSE_INVENTORY_FAILED = "inventory-failed"
	CONST_CAUSE_LICENSE_GRACEPERIOD_EXPIRED = "license-graceperiod-expired"
	CONST_CAUSE_LIMIT_REACHED = "limit-reached"
	CONST_CAUSE_LINK_DOWN = "link-down"
	CONST_CAUSE_MANAGEMENT_SERVICES_FAILURE = "management-services-failure"
	CONST_CAUSE_MANAGEMENT_SERVICES_UNRESPONSIVE = "management-services-unresponsive"
	CONST_CAUSE_MGMTIF_DOWN = "mgmtif-down"
	CONST_CAUSE_NDISC_TARGETS_CONFIG_ERROR = "ndisc-targets-config-error"
	CONST_CAUSE_PORT_FAILED = "port-failed"
	CONST_CAUSE_POWER_PROBLEM = "power-problem"
	CONST_CAUSE_THERMAL_PROBLEM = "thermal-problem"
	CONST_CAUSE_UNSPECIFIED = "unspecified"
	CONST_CAUSE_VERSION_INCOMPATIBLE = "version-incompatible"
	CONST_CAUSE_VIF_IDS_MISMATCH = "vif-ids-mismatch"
	CONST_CAUSE_VOLTAGE_PROBLEM = "voltage-problem"

class EquipmentGemPortCap(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"EquipmentGemPortCap")

	@staticmethod
	def ClassId():
		return "equipmentGemPortCap"

	DESCR = "Descr"
	DN = "Dn"
	MAX_FC_SPEED = "MaxFcSpeed"
	NAME = "Name"
	POLICY_LEVEL = "PolicyLevel"
	POLICY_OWNER = "PolicyOwner"
	PORT_NUMBER = "PortNumber"
	RN = "Rn"
	STATUS = "Status"

	CONST_INT_ID_NONE = "none"
	CONST_MAX_FC_SPEED_1GBPS = "1gbps"
	CONST_MAX_FC_SPEED_2GBPS = "2gbps"
	CONST_MAX_FC_SPEED_4GBPS = "4gbps"
	CONST_MAX_FC_SPEED_8GBPS = "8gbps"
	CONST_MAX_FC_SPEED_AUTO = "auto"
	CONST_MAX_FC_SPEED_INDETERMINATE = "indeterminate"
	CONST_POLICY_OWNER_LOCAL = "local"
	CONST_POLICY_OWNER_PENDING_POLICY = "pending-policy"
	CONST_POLICY_OWNER_POLICY = "policy"

class ComputeChassisQual(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"ComputeChassisQual")

	@staticmethod
	def ClassId():
		return "computeChassisQual"

	DN = "Dn"
	MAX_ID = "MaxId"
	MIN_ID = "MinId"
	RN = "Rn"
	STATUS = "Status"


class VnicDynamicCon(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"VnicDynamicCon")

	@staticmethod
	def ClassId():
		return "vnicDynamicCon"

	ADAPTOR_PROFILE_NAME = "AdaptorProfileName"
	DESCR = "Descr"
	DN = "Dn"
	DYNAMIC_ETH = "DynamicEth"
	MTU = "Mtu"
	NAME = "Name"
	NAMING_PREFIX = "NamingPrefix"
	POLICY_LEVEL = "PolicyLevel"
	POLICY_OWNER = "PolicyOwner"
	PROTECTION = "Protection"
	RN = "Rn"
	STATUS = "Status"

	CONST_DYNAMIC_ETH_OFF = "off"
	CONST_INT_ID_NONE = "none"
	CONST_POLICY_OWNER_LOCAL = "local"
	CONST_POLICY_OWNER_PENDING_POLICY = "pending-policy"
	CONST_POLICY_OWNER_POLICY = "policy"
	CONST_PROTECTION_NONE = "none"
	CONST_PROTECTION_PROTECTED = "protected"
	CONST_PROTECTION_PROTECTED_PREF_A = "protected-pref-a"
	CONST_PROTECTION_PROTECTED_PREF_B = "protected-pref-b"

class CommSnmpTrap(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"CommSnmpTrap")

	@staticmethod
	def ClassId():
		return "commSnmpTrap"

	COMMUNITY = "Community"
	DN = "Dn"
	HOSTNAME = "Hostname"
	NOTIFICATION_TYPE = "NotificationType"
	PORT = "Port"
	RN = "Rn"
	STATUS = "Status"
	V3_PRIVILEGE = "V3Privilege"
	VERSION = "Version"

	CONST_NOTIFICATION_TYPE_INFORMS = "informs"
	CONST_NOTIFICATION_TYPE_TRAPS = "traps"
	CONST_V3_PRIVILEGE_AUTH = "auth"
	CONST_V3_PRIVILEGE_NOAUTH = "noauth"
	CONST_V3_PRIVILEGE_PRIV = "priv"
	CONST_VERSION_V1 = "v1"
	CONST_VERSION_V2C = "v2c"
	CONST_VERSION_V3 = "v3"

class AdaptorIscsiTargetIf(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"AdaptorIscsiTargetIf")

	@staticmethod
	def ClassId():
		return "adaptorIscsiTargetIf"

	DHCP_VENDOR_ID = "DhcpVendorId"
	DN = "Dn"
	IP_ADDRESS = "IpAddress"
	LUN = "Lun"
	NAME = "Name"
	PORT_NUMBER = "PortNumber"
	PRIORITY = "Priority"
	RN = "Rn"
	STATUS = "Status"


class EquipmentPortGroupDef(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"EquipmentPortGroupDef")

	@staticmethod
	def ClassId():
		return "equipmentPortGroupDef"

	DESCR = "Descr"
	DN = "Dn"
	NAME = "Name"
	NUMBER_OF_PORTS = "NumberOfPorts"
	POLICY_LEVEL = "PolicyLevel"
	POLICY_OWNER = "PolicyOwner"
	RN = "Rn"
	STATUS = "Status"
	TYPE = "Type"

	CONST_INT_ID_NONE = "none"
	CONST_POLICY_OWNER_LOCAL = "local"
	CONST_POLICY_OWNER_PENDING_POLICY = "pending-policy"
	CONST_POLICY_OWNER_POLICY = "policy"
	CONST_TYPE_ADAPTOR_EXT = "adaptor-ext"
	CONST_TYPE_ADAPTOR_PC = "adaptor-pc"
	CONST_TYPE_FABRIC = "fabric"
	CONST_TYPE_FABRIC_PC = "fabric-pc"
	CONST_TYPE_HOST = "host"
	CONST_TYPE_HOST_PC = "host-pc"
	CONST_TYPE_SERVER_PC = "server-pc"
	CONST_TYPE_SWITCH_ETHER = "switch-ether"
	CONST_TYPE_SWITCH_FC = "switch-fc"

class GraphicsCard(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"GraphicsCard")

	@staticmethod
	def ClassId():
		return "graphicsCard"

	DEVICE_ID = "DeviceId"
	DN = "Dn"
	ID = "Id"
	IS_SUPPORTED = "IsSupported"
	LC = "Lc"
	MODEL = "Model"
	OPER_QUALIFIER_REASON = "OperQualifierReason"
	OPER_STATE = "OperState"
	OPERABILITY = "Operability"
	PCI_ADDR = "PciAddr"
	PCI_SLOT = "PciSlot"
	PERF = "Perf"
	POWER = "Power"
	PRESENCE = "Presence"
	REVISION = "Revision"
	RN = "Rn"
	SERIAL = "Serial"
	STATUS = "Status"
	SUB_DEVICE_ID = "SubDeviceId"
	SUB_VENDOR_ID = "SubVendorId"
	THERMAL = "Thermal"
	VENDOR = "Vendor"
	VENDOR_ID = "VendorId"
	VOLTAGE = "Voltage"

	CONST_IS_SUPPORTED_FALSE = "false"
	CONST_IS_SUPPORTED_NO = "no"
	CONST_IS_SUPPORTED_TRUE = "true"
	CONST_IS_SUPPORTED_YES = "yes"
	CONST_LC_ALLOCATED = "allocated"
	CONST_LC_AVAILABLE = "available"
	CONST_LC_DEALLOCATED = "deallocated"
	CONST_LC_REPURPOSED = "repurposed"
	CONST_OPER_STATE_ACCESSIBILITY_PROBLEM = "accessibility-problem"
	CONST_OPER_STATE_AUTO_UPGRADE = "auto-upgrade"
	CONST_OPER_STATE_BIOS_POST_TIMEOUT = "bios-post-timeout"
	CONST_OPER_STATE_CHASSIS_LIMIT_EXCEEDED = "chassis-limit-exceeded"
	CONST_OPER_STATE_CONFIG = "config"
	CONST_OPER_STATE_DECOMISSIONING = "decomissioning"
	CONST_OPER_STATE_DEGRADED = "degraded"
	CONST_OPER_STATE_DISABLED = "disabled"
	CONST_OPER_STATE_DISCOVERY = "discovery"
	CONST_OPER_STATE_DISCOVERY_FAILED = "discovery-failed"
	CONST_OPER_STATE_EQUIPMENT_PROBLEM = "equipment-problem"
	CONST_OPER_STATE_FABRIC_CONN_PROBLEM = "fabric-conn-problem"
	CONST_OPER_STATE_FABRIC_UNSUPPORTED_CONN = "fabric-unsupported-conn"
	CONST_OPER_STATE_IDENTIFY = "identify"
	CONST_OPER_STATE_IDENTITY_UNESTABLISHABLE = "identity-unestablishable"
	CONST_OPER_STATE_INOPERABLE = "inoperable"
	CONST_OPER_STATE_LINK_ACTIVATE_BLOCKED = "link-activate-blocked"
	CONST_OPER_STATE_MALFORMED_FRU = "malformed-fru"
	CONST_OPER_STATE_NOT_SUPPORTED = "not-supported"
	CONST_OPER_STATE_OPERABLE = "operable"
	CONST_OPER_STATE_PEER_COMM_PROBLEM = "peer-comm-problem"
	CONST_OPER_STATE_PERFORMANCE_PROBLEM = "performance-problem"
	CONST_OPER_STATE_POST_FAILURE = "post-failure"
	CONST_OPER_STATE_POWER_PROBLEM = "power-problem"
	CONST_OPER_STATE_POWERED_OFF = "powered-off"
	CONST_OPER_STATE_REMOVED = "removed"
	CONST_OPER_STATE_THERMAL_PROBLEM = "thermal-problem"
	CONST_OPER_STATE_UNKNOWN = "unknown"
	CONST_OPER_STATE_UPGRADE_PROBLEM = "upgrade-problem"
	CONST_OPER_STATE_VOLTAGE_PROBLEM = "voltage-problem"
	CONST_OPERABILITY_ACCESSIBILITY_PROBLEM = "accessibility-problem"
	CONST_OPERABILITY_AUTO_UPGRADE = "auto-upgrade"
	CONST_OPERABILITY_BIOS_POST_TIMEOUT = "bios-post-timeout"
	CONST_OPERABILITY_CHASSIS_LIMIT_EXCEEDED = "chassis-limit-exceeded"
	CONST_OPERABILITY_CONFIG = "config"
	CONST_OPERABILITY_DECOMISSIONING = "decomissioning"
	CONST_OPERABILITY_DEGRADED = "degraded"
	CONST_OPERABILITY_DISABLED = "disabled"
	CONST_OPERABILITY_DISCOVERY = "discovery"
	CONST_OPERABILITY_DISCOVERY_FAILED = "discovery-failed"
	CONST_OPERABILITY_EQUIPMENT_PROBLEM = "equipment-problem"
	CONST_OPERABILITY_FABRIC_CONN_PROBLEM = "fabric-conn-problem"
	CONST_OPERABILITY_FABRIC_UNSUPPORTED_CONN = "fabric-unsupported-conn"
	CONST_OPERABILITY_IDENTIFY = "identify"
	CONST_OPERABILITY_IDENTITY_UNESTABLISHABLE = "identity-unestablishable"
	CONST_OPERABILITY_INOPERABLE = "inoperable"
	CONST_OPERABILITY_LINK_ACTIVATE_BLOCKED = "link-activate-blocked"
	CONST_OPERABILITY_MALFORMED_FRU = "malformed-fru"
	CONST_OPERABILITY_NOT_SUPPORTED = "not-supported"
	CONST_OPERABILITY_OPERABLE = "operable"
	CONST_OPERABILITY_PEER_COMM_PROBLEM = "peer-comm-problem"
	CONST_OPERABILITY_PERFORMANCE_PROBLEM = "performance-problem"
	CONST_OPERABILITY_POST_FAILURE = "post-failure"
	CONST_OPERABILITY_POWER_PROBLEM = "power-problem"
	CONST_OPERABILITY_POWERED_OFF = "powered-off"
	CONST_OPERABILITY_REMOVED = "removed"
	CONST_OPERABILITY_THERMAL_PROBLEM = "thermal-problem"
	CONST_OPERABILITY_UNKNOWN = "unknown"
	CONST_OPERABILITY_UPGRADE_PROBLEM = "upgrade-problem"
	CONST_OPERABILITY_VOLTAGE_PROBLEM = "voltage-problem"
	CONST_PERF_LOWER_CRITICAL = "lower-critical"
	CONST_PERF_LOWER_NON_CRITICAL = "lower-non-critical"
	CONST_PERF_LOWER_NON_RECOVERABLE = "lower-non-recoverable"
	CONST_PERF_NOT_SUPPORTED = "not-supported"
	CONST_PERF_OK = "ok"
	CONST_PERF_UNKNOWN = "unknown"
	CONST_PERF_UPPER_CRITICAL = "upper-critical"
	CONST_PERF_UPPER_NON_CRITICAL = "upper-non-critical"
	CONST_PERF_UPPER_NON_RECOVERABLE = "upper-non-recoverable"
	CONST_POWER_DEGRADED = "degraded"
	CONST_POWER_ERROR = "error"
	CONST_POWER_FAILED = "failed"
	CONST_POWER_NOT_SUPPORTED = "not-supported"
	CONST_POWER_OFF = "off"
	CONST_POWER_OFFDUTY = "offduty"
	CONST_POWER_OFFLINE = "offline"
	CONST_POWER_OK = "ok"
	CONST_POWER_ON = "on"
	CONST_POWER_ONLINE = "online"
	CONST_POWER_POWER_SAVE = "power-save"
	CONST_POWER_TEST = "test"
	CONST_POWER_UNKNOWN = "unknown"
	CONST_PRESENCE_EMPTY = "empty"
	CONST_PRESENCE_EQUIPPED = "equipped"
	CONST_PRESENCE_EQUIPPED_IDENTITY_UNESTABLISHABLE = "equipped-identity-unestablishable"
	CONST_PRESENCE_EQUIPPED_NOT_PRIMARY = "equipped-not-primary"
	CONST_PRESENCE_EQUIPPED_WITH_MALFORMED_FRU = "equipped-with-malformed-fru"
	CONST_PRESENCE_INACCESSIBLE = "inaccessible"
	CONST_PRESENCE_MISMATCH = "mismatch"
	CONST_PRESENCE_MISMATCH_IDENTITY_UNESTABLISHABLE = "mismatch-identity-unestablishable"
	CONST_PRESENCE_MISSING = "missing"
	CONST_PRESENCE_NOT_SUPPORTED = "not-supported"
	CONST_PRESENCE_UNAUTHORIZED = "unauthorized"
	CONST_PRESENCE_UNKNOWN = "unknown"
	CONST_THERMAL_LOWER_CRITICAL = "lower-critical"
	CONST_THERMAL_LOWER_NON_CRITICAL = "lower-non-critical"
	CONST_THERMAL_LOWER_NON_RECOVERABLE = "lower-non-recoverable"
	CONST_THERMAL_NOT_SUPPORTED = "not-supported"
	CONST_THERMAL_OK = "ok"
	CONST_THERMAL_UNKNOWN = "unknown"
	CONST_THERMAL_UPPER_CRITICAL = "upper-critical"
	CONST_THERMAL_UPPER_NON_CRITICAL = "upper-non-critical"
	CONST_THERMAL_UPPER_NON_RECOVERABLE = "upper-non-recoverable"
	CONST_VOLTAGE_LOWER_CRITICAL = "lower-critical"
	CONST_VOLTAGE_LOWER_NON_CRITICAL = "lower-non-critical"
	CONST_VOLTAGE_LOWER_NON_RECOVERABLE = "lower-non-recoverable"
	CONST_VOLTAGE_NOT_SUPPORTED = "not-supported"
	CONST_VOLTAGE_OK = "ok"
	CONST_VOLTAGE_UNKNOWN = "unknown"
	CONST_VOLTAGE_UPPER_CRITICAL = "upper-critical"
	CONST_VOLTAGE_UPPER_NON_CRITICAL = "upper-non-critical"
	CONST_VOLTAGE_UPPER_NON_RECOVERABLE = "upper-non-recoverable"

class QosclassEthClassified(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"QosclassEthClassified")

	@staticmethod
	def ClassId():
		return "qosclassEthClassified"

	ADMIN_STATE = "AdminState"
	BW_PERCENT = "BwPercent"
	COS = "Cos"
	DN = "Dn"
	DROP = "Drop"
	MTU = "Mtu"
	MULTICAST_OPTIMIZE = "MulticastOptimize"
	NAME = "Name"
	PRIORITY = "Priority"
	RN = "Rn"
	STATUS = "Status"
	WEIGHT = "Weight"

	CONST_ADMIN_STATE_DISABLED = "disabled"
	CONST_ADMIN_STATE_ENABLED = "enabled"
	CONST_BW_PERCENT_NOT_APPLICABLE = "not-applicable"
	CONST_COS_ANY = "any"
	CONST_DROP_DROP = "drop"
	CONST_DROP_NO_DROP = "no-drop"
	CONST_MTU_FC = "fc"
	CONST_MTU_NORMAL = "normal"
	CONST_MULTICAST_OPTIMIZE_FALSE = "false"
	CONST_MULTICAST_OPTIMIZE_NO = "no"
	CONST_MULTICAST_OPTIMIZE_TRUE = "true"
	CONST_MULTICAST_OPTIMIZE_YES = "yes"
	CONST_PRIORITY_BEST_EFFORT = "best-effort"
	CONST_PRIORITY_BRONZE = "bronze"
	CONST_PRIORITY_FC = "fc"
	CONST_PRIORITY_GOLD = "gold"
	CONST_PRIORITY_PLATINUM = "platinum"
	CONST_PRIORITY_SILVER = "silver"
	CONST_WEIGHT_BEST_EFFORT = "best-effort"
	CONST_WEIGHT_NONE = "none"

class DomainNetworkFeatureCont(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"DomainNetworkFeatureCont")

	@staticmethod
	def ClassId():
		return "domainNetworkFeatureCont"

	DN = "Dn"
	RN = "Rn"
	STATUS = "Status"


class MgmtIf(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"MgmtIf")

	@staticmethod
	def ClassId():
		return "mgmtIf"

	ACCESS = "Access"
	ADMIN_STATE = "AdminState"
	CHASSIS_ID = "ChassisId"
	DISCOVERY = "Discovery"
	DN = "Dn"
	EP_DN = "EpDn"
	EXT_BROADCAST = "ExtBroadcast"
	EXT_GW = "ExtGw"
	EXT_IP = "ExtIp"
	EXT_MASK = "ExtMask"
	ID = "Id"
	IF_ROLE = "IfRole"
	IF_TYPE = "IfType"
	IP = "Ip"
	LOCALE = "Locale"
	MAC = "Mac"
	MASK = "Mask"
	NAME = "Name"
	PEER_CHASSIS_ID = "PeerChassisId"
	PEER_DN = "PeerDn"
	PEER_PORT_ID = "PeerPortId"
	PEER_SLOT_ID = "PeerSlotId"
	PORT_ID = "PortId"
	RN = "Rn"
	SLOT_ID = "SlotId"
	STATE_QUAL = "StateQual"
	STATUS = "Status"
	SUBJECT = "Subject"
	SWITCH_ID = "SwitchId"
	TRANSPORT = "Transport"
	TYPE = "Type"
	VNET = "Vnet"

	CONST_ACCESS_IN_BAND = "in-band"
	CONST_ACCESS_INTERNAL = "internal"
	CONST_ACCESS_OUT_OF_BAND = "out-of-band"
	CONST_ACCESS_UNSPECIFIED = "unspecified"
	CONST_ACCESS_VIRTUAL = "virtual"
	CONST_ADMIN_STATE_DISABLE = "disable"
	CONST_ADMIN_STATE_ENABLE = "enable"
	CONST_CHASSIS_ID_N_A = "N/A"
	CONST_DISCOVERY_ABSENT = "absent"
	CONST_DISCOVERY_MIS_CONNECT = "mis-connect"
	CONST_DISCOVERY_MISSING = "missing"
	CONST_DISCOVERY_NEW = "new"
	CONST_DISCOVERY_PRESENT = "present"
	CONST_FSM_PREV_DISABLE_VIP_BEGIN = "DisableVipBegin"
	CONST_FSM_PREV_DISABLE_VIP_FAIL = "DisableVipFail"
	CONST_FSM_PREV_DISABLE_VIP_PEER = "DisableVipPeer"
	CONST_FSM_PREV_DISABLE_VIP_SUCCESS = "DisableVipSuccess"
	CONST_FSM_PREV_ENABLE_HABEGIN = "EnableHABegin"
	CONST_FSM_PREV_ENABLE_HAFAIL = "EnableHAFail"
	CONST_FSM_PREV_ENABLE_HALOCAL = "EnableHALocal"
	CONST_FSM_PREV_ENABLE_HASUCCESS = "EnableHASuccess"
	CONST_FSM_PREV_ENABLE_VIP_BEGIN = "EnableVipBegin"
	CONST_FSM_PREV_ENABLE_VIP_FAIL = "EnableVipFail"
	CONST_FSM_PREV_ENABLE_VIP_LOCAL = "EnableVipLocal"
	CONST_FSM_PREV_ENABLE_VIP_SUCCESS = "EnableVipSuccess"
	CONST_FSM_PREV_SW_MGMT_INBAND_IF_CONFIG_BEGIN = "SwMgmtInbandIfConfigBegin"
	CONST_FSM_PREV_SW_MGMT_INBAND_IF_CONFIG_FAIL = "SwMgmtInbandIfConfigFail"
	CONST_FSM_PREV_SW_MGMT_INBAND_IF_CONFIG_SUCCESS = "SwMgmtInbandIfConfigSuccess"
	CONST_FSM_PREV_SW_MGMT_INBAND_IF_CONFIG_SWITCH = "SwMgmtInbandIfConfigSwitch"
	CONST_FSM_PREV_SW_MGMT_OOB_IF_CONFIG_BEGIN = "SwMgmtOobIfConfigBegin"
	CONST_FSM_PREV_SW_MGMT_OOB_IF_CONFIG_FAIL = "SwMgmtOobIfConfigFail"
	CONST_FSM_PREV_SW_MGMT_OOB_IF_CONFIG_SUCCESS = "SwMgmtOobIfConfigSuccess"
	CONST_FSM_PREV_SW_MGMT_OOB_IF_CONFIG_SWITCH = "SwMgmtOobIfConfigSwitch"
	CONST_FSM_PREV_VIRTUAL_IF_CONFIG_BEGIN = "VirtualIfConfigBegin"
	CONST_FSM_PREV_VIRTUAL_IF_CONFIG_FAIL = "VirtualIfConfigFail"
	CONST_FSM_PREV_VIRTUAL_IF_CONFIG_LOCAL = "VirtualIfConfigLocal"
	CONST_FSM_PREV_VIRTUAL_IF_CONFIG_REMOTE = "VirtualIfConfigRemote"
	CONST_FSM_PREV_VIRTUAL_IF_CONFIG_SUCCESS = "VirtualIfConfigSuccess"
	CONST_FSM_PREV_NOP = "nop"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_2FA_AUTH_RETRY = "ERR-2fa-auth-retry"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_ACTIVATE_FAILED = "ERR-ACTIVATE-failed"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_ACTIVATE_IN_PROGRESS = "ERR-ACTIVATE-in-progress"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_ACTIVATE_RETRY = "ERR-ACTIVATE-retry"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_BIOS_TOKENS_OLD_BIOS = "ERR-BIOS-TOKENS-OLD-BIOS"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_BIOS_TOKENS_OLD_CIMC = "ERR-BIOS-TOKENS-OLD-CIMC"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_BIOS_NETWORK_BOOT_ORDER_NOT_FOUND = "ERR-BIOS-network-boot-order-not-found"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_BOARDCTRLUPDATE_IGNORE = "ERR-BOARDCTRLUPDATE-ignore"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DIAG_CANCELLED = "ERR-DIAG-cancelled"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DIAG_FSM_RESTARTED = "ERR-DIAG-fsm-restarted"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DIAG_TEST_FAILED = "ERR-DIAG-test-failed"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DNLD_AUTHENTICATION_FAILURE = "ERR-DNLD-authentication-failure"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DNLD_HOSTKEY_MISMATCH = "ERR-DNLD-hostkey-mismatch"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DNLD_INVALID_IMAGE = "ERR-DNLD-invalid-image"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DNLD_NO_FILE = "ERR-DNLD-no-file"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DNLD_NO_SPACE = "ERR-DNLD-no-space"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DNS_DELETE_ERROR = "ERR-DNS-delete-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DNS_GET_ERROR = "ERR-DNS-get-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DNS_SET_ERROR = "ERR-DNS-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DIAGNOSTICS_IN_PROGRESS = "ERR-Diagnostics-in-progress"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DIAGNOSTICS_MEMTEST_IN_PROGRESS = "ERR-Diagnostics-memtest-in-progress"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DIAGNOSTICS_NETWORK_IN_PROGRESS = "ERR-Diagnostics-network-in-progress"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_FILTER_ILLEGAL_FORMAT = "ERR-FILTER-illegal-format"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_FSM_NO_SUCH_STATE = "ERR-FSM-no-such-state"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_HOST_FRU_IDENTITY_MISMATCH = "ERR-HOST-fru-identity-mismatch"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_HTTP_SET_ERROR = "ERR-HTTP-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_HTTPS_SET_ERROR = "ERR-HTTPS-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_IBMC_ANALYZE_RESULTS = "ERR-IBMC-analyze-results"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_IBMC_CONNECT_ERROR = "ERR-IBMC-connect-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_IBMC_FRU_RETRIEVAL_ERROR = "ERR-IBMC-fru-retrieval-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_IBMC_INVALID_END_POINT_CONFIG = "ERR-IBMC-invalid-end-point-config"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_IBMC_RESULTS_NOT_READY = "ERR-IBMC-results-not-ready"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MAX_SUBSCRIPTIONS_ALLOWED_ERROR = "ERR-MAX-subscriptions-allowed-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_CONFIG_CHILD_OBJECT_CANT_BE_CONFIGURED = "ERR-MO-CONFIG-child-object-cant-be-configured"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_META_NO_SUCH_OBJECT_CLASS = "ERR-MO-META-no-such-object-class"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_PROPERTY_NO_SUCH_PROPERTY = "ERR-MO-PROPERTY-no-such-property"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_PROPERTY_VALUE_OUT_OF_RANGE = "ERR-MO-PROPERTY-value-out-of-range"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_ACCESS_DENIED = "ERR-MO-access-denied"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_DELETION_RULE_VIOLATION = "ERR-MO-deletion-rule-violation"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_DUPLICATE_OBJECT = "ERR-MO-duplicate-object"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_ILLEGAL_CONTAINMENT = "ERR-MO-illegal-containment"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_ILLEGAL_CREATION = "ERR-MO-illegal-creation"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_ILLEGAL_ITERATOR_STATE = "ERR-MO-illegal-iterator-state"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_ILLEGAL_OBJECT_LIFECYCLE_TRANSITION = "ERR-MO-illegal-object-lifecycle-transition"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_NAMING_RULE_VIOLATION = "ERR-MO-naming-rule-violation"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_OBJECT_NOT_FOUND = "ERR-MO-object-not-found"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MO_RESOURCE_ALLOCATION = "ERR-MO-resource-allocation"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_NTP_DELETE_ERROR = "ERR-NTP-delete-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_NTP_GET_ERROR = "ERR-NTP-get-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_NTP_SET_ERROR = "ERR-NTP-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_POWER_CAP_UNSUPPORTED = "ERR-POWER-CAP-UNSUPPORTED"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_SERVER_MIS_CONNECT = "ERR-SERVER-mis-connect"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_SWITCH_INVALID_IF_CONFIG = "ERR-SWITCH-invalid-if-config"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_TOKEN_REQUEST_DENIED = "ERR-TOKEN-request-denied"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_UNABLE_TO_FETCH_BIOS_SETTINGS = "ERR-UNABLE-TO-FETCH-BIOS-SETTINGS"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_UPDATE_FAILED = "ERR-UPDATE-failed"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_UPDATE_IN_PROGRESS = "ERR-UPDATE-in-progress"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_UPDATE_RETRY = "ERR-UPDATE-retry"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_AAA_CONFIG_MODIFY_ERROR = "ERR-aaa-config-modify-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_ACCT_REALM_SET_ERROR = "ERR-acct-realm-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_ADMIN_PASSWD_SET = "ERR-admin-passwd-set"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_AUTH_ISSUE = "ERR-auth-issue"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_AUTH_REALM_GET_ERROR = "ERR-auth-realm-get-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_AUTH_REALM_SET_ERROR = "ERR-auth-realm-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_AUTHENTICATION = "ERR-authentication"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_AUTHORIZATION_REQUIRED = "ERR-authorization-required"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_CLI_SESSION_LIMIT_REACHED = "ERR-cli-session-limit-reached"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_CREATE_KEYRING = "ERR-create-keyring"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_CREATE_LOCALE = "ERR-create-locale"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_CREATE_ROLE = "ERR-create-role"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_CREATE_USER = "ERR-create-user"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DELETE_LOCALE = "ERR-delete-locale"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DELETE_ROLE = "ERR-delete-role"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DELETE_SESSION = "ERR-delete-session"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_DELETE_USER = "ERR-delete-user"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_EFI_DIAGNOSTICS_IN_PROGRESS = "ERR-efi-Diagnostics--in-progress"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_ENABLE_MGMT_CONN = "ERR-enable-mgmt-conn"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_EP_SET_ERROR = "ERR-ep-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_GET_MAX_HTTP_USER_SESSIONS = "ERR-get-max-http-user-sessions"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_HTTP_INITIALIZING = "ERR-http-initializing"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_INSUFFICIENTLY_EQUIPPED = "ERR-insufficiently-equipped"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_INTERNAL_ERROR = "ERR-internal-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_LDAP_DELETE_ERROR = "ERR-ldap-delete-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_LDAP_GET_ERROR = "ERR-ldap-get-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_LDAP_GROUP_MODIFY_ERROR = "ERR-ldap-group-modify-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_LDAP_GROUP_SET_ERROR = "ERR-ldap-group-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_LDAP_SET_ERROR = "ERR-ldap-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_LOCALE_SET_ERROR = "ERR-locale-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MAX_USERID_SESSIONS_REACHED = "ERR-max-userid-sessions-reached"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MISSING_METHOD = "ERR-missing-method"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MODIFY_LOCALE = "ERR-modify-locale"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MODIFY_ROLE = "ERR-modify-role"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MODIFY_USER = "ERR-modify-user"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MODIFY_USER_LOCALE = "ERR-modify-user-locale"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_MODIFY_USER_ROLE = "ERR-modify-user-role"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_PROVIDER_GROUP_MODIFY_ERROR = "ERR-provider-group-modify-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_PROVIDER_GROUP_SET_ERROR = "ERR-provider-group-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_RADIUS_GET_ERROR = "ERR-radius-get-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_RADIUS_GLOBAL_SET_ERROR = "ERR-radius-global-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_RADIUS_GROUP_SET_ERROR = "ERR-radius-group-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_RADIUS_SET_ERROR = "ERR-radius-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_REQUEST_TIMEOUT = "ERR-request-timeout"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_RESET_ADAPTER = "ERR-reset-adapter"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_ROLE_SET_ERROR = "ERR-role-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_SECONDARY_NODE = "ERR-secondary-node"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_SERVICE_NOT_READY = "ERR-service-not-ready"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_SESSION_CACHE_FULL = "ERR-session-cache-full"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_SESSION_NOT_FOUND = "ERR-session-not-found"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_SET_NETWORK = "ERR-set-network"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_SET_PASSWORD_STRENGTH_CHECK = "ERR-set-password-strength-check"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_SET_PORT_CHANNEL = "ERR-set-port-channel"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_STORE_PRE_LOGIN_BANNER_MSG = "ERR-store-pre-login-banner-msg"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_TACACS_ENABLE_ERROR = "ERR-tacacs-enable-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_TACACS_GLOBAL_SET_ERROR = "ERR-tacacs-global-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_TACACS_GROUP_SET_ERROR = "ERR-tacacs-group-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_TACACS_PLUS_GET_ERROR = "ERR-tacacs-plus-get-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_TACACS_SET_ERROR = "ERR-tacacs-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_TEST_ERROR_1 = "ERR-test-error-1"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_TEST_ERROR_2 = "ERR-test-error-2"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_TIMEZONE_SET_ERROR = "ERR-timezone-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_USER_ACCOUNT_EXPIRED = "ERR-user-account-expired"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_USER_SET_ERROR = "ERR-user-set-error"
	CONST_FSM_RMT_INV_ERR_CODE_ERR_XML_PARSE_ERROR = "ERR-xml-parse-error"
	CONST_FSM_RMT_INV_ERR_CODE_NONE = "none"
	CONST_FSM_STAMP_NEVER = "never"
	CONST_FSM_STATUS_DISABLE_VIP_BEGIN = "DisableVipBegin"
	CONST_FSM_STATUS_DISABLE_VIP_FAIL = "DisableVipFail"
	CONST_FSM_STATUS_DISABLE_VIP_PEER = "DisableVipPeer"
	CONST_FSM_STATUS_DISABLE_VIP_SUCCESS = "DisableVipSuccess"
	CONST_FSM_STATUS_ENABLE_HABEGIN = "EnableHABegin"
	CONST_FSM_STATUS_ENABLE_HAFAIL = "EnableHAFail"
	CONST_FSM_STATUS_ENABLE_HALOCAL = "EnableHALocal"
	CONST_FSM_STATUS_ENABLE_HASUCCESS = "EnableHASuccess"
	CONST_FSM_STATUS_ENABLE_VIP_BEGIN = "EnableVipBegin"
	CONST_FSM_STATUS_ENABLE_VIP_FAIL = "EnableVipFail"
	CONST_FSM_STATUS_ENABLE_VIP_LOCAL = "EnableVipLocal"
	CONST_FSM_STATUS_ENABLE_VIP_SUCCESS = "EnableVipSuccess"
	CONST_FSM_STATUS_SW_MGMT_INBAND_IF_CONFIG_BEGIN = "SwMgmtInbandIfConfigBegin"
	CONST_FSM_STATUS_SW_MGMT_INBAND_IF_CONFIG_FAIL = "SwMgmtInbandIfConfigFail"
	CONST_FSM_STATUS_SW_MGMT_INBAND_IF_CONFIG_SUCCESS = "SwMgmtInbandIfConfigSuccess"
	CONST_FSM_STATUS_SW_MGMT_INBAND_IF_CONFIG_SWITCH = "SwMgmtInbandIfConfigSwitch"
	CONST_FSM_STATUS_SW_MGMT_OOB_IF_CONFIG_BEGIN = "SwMgmtOobIfConfigBegin"
	CONST_FSM_STATUS_SW_MGMT_OOB_IF_CONFIG_FAIL = "SwMgmtOobIfConfigFail"
	CONST_FSM_STATUS_SW_MGMT_OOB_IF_CONFIG_SUCCESS = "SwMgmtOobIfConfigSuccess"
	CONST_FSM_STATUS_SW_MGMT_OOB_IF_CONFIG_SWITCH = "SwMgmtOobIfConfigSwitch"
	CONST_FSM_STATUS_VIRTUAL_IF_CONFIG_BEGIN = "VirtualIfConfigBegin"
	CONST_FSM_STATUS_VIRTUAL_IF_CONFIG_FAIL = "VirtualIfConfigFail"
	CONST_FSM_STATUS_VIRTUAL_IF_CONFIG_LOCAL = "VirtualIfConfigLocal"
	CONST_FSM_STATUS_VIRTUAL_IF_CONFIG_REMOTE = "VirtualIfConfigRemote"
	CONST_FSM_STATUS_VIRTUAL_IF_CONFIG_SUCCESS = "VirtualIfConfigSuccess"
	CONST_FSM_STATUS_NOP = "nop"
	CONST_IF_ROLE_DIAG = "diag"
	CONST_IF_ROLE_FCOE_NAS_STORAGE = "fcoe-nas-storage"
	CONST_IF_ROLE_FCOE_STORAGE = "fcoe-storage"
	CONST_IF_ROLE_FCOE_UPLINK = "fcoe-uplink"
	CONST_IF_ROLE_MGMT = "mgmt"
	CONST_IF_ROLE_MONITOR = "monitor"
	CONST_IF_ROLE_NAS_STORAGE = "nas-storage"
	CONST_IF_ROLE_NETWORK = "network"
	CONST_IF_ROLE_NETWORK_FCOE_UPLINK = "network-fcoe-uplink"
	CONST_IF_ROLE_SERVER = "server"
	CONST_IF_ROLE_SERVICE = "service"
	CONST_IF_ROLE_STORAGE = "storage"
	CONST_IF_ROLE_UNKNOWN = "unknown"
	CONST_IF_TYPE_AGGREGATION = "aggregation"
	CONST_IF_TYPE_PHYSICAL = "physical"
	CONST_IF_TYPE_UNKNOWN = "unknown"
	CONST_IF_TYPE_VIRTUAL = "virtual"
	CONST_PEER_CHASSIS_ID_N_A = "N/A"
	CONST_STATE_QUAL_MISCONNECTED = "misconnected"
	CONST_STATE_QUAL_UNSPECIFIED = "unspecified"
	CONST_STATE_QUAL_VALID = "valid"
	CONST_SUBJECT_ADAPTOR = "adaptor"
	CONST_SUBJECT_BLADE = "blade"
	CONST_SUBJECT_BOARD_CONTROLLER = "board-controller"
	CONST_SUBJECT_CHASSIS = "chassis"
	CONST_SUBJECT_IOCARD = "iocard"
	CONST_SUBJECT_SWITCH = "switch"
	CONST_SUBJECT_SYSTEM = "system"
	CONST_SUBJECT_UNKNOWN = "unknown"
	CONST_SWITCH_ID_A = "A"
	CONST_SWITCH_ID_B = "B"
	CONST_SWITCH_ID_NONE = "NONE"

class PortDomainEp(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"PortDomainEp")

	@staticmethod
	def ClassId():
		return "portDomainEp"

	DN = "Dn"
	EP_DN = "EpDn"
	IF_ROLE = "IfRole"
	IF_TYPE = "IfType"
	LOCALE = "Locale"
	NAME = "Name"
	PEER_DN = "PeerDn"
	RN = "Rn"
	STATUS = "Status"
	TRANSPORT = "Transport"
	TYPE = "Type"

	CONST_IF_ROLE_DIAG = "diag"
	CONST_IF_ROLE_FCOE_NAS_STORAGE = "fcoe-nas-storage"
	CONST_IF_ROLE_FCOE_STORAGE = "fcoe-storage"
	CONST_IF_ROLE_FCOE_UPLINK = "fcoe-uplink"
	CONST_IF_ROLE_MGMT = "mgmt"
	CONST_IF_ROLE_MONITOR = "monitor"
	CONST_IF_ROLE_NAS_STORAGE = "nas-storage"
	CONST_IF_ROLE_NETWORK = "network"
	CONST_IF_ROLE_NETWORK_FCOE_UPLINK = "network-fcoe-uplink"
	CONST_IF_ROLE_SERVER = "server"
	CONST_IF_ROLE_SERVICE = "service"
	CONST_IF_ROLE_STORAGE = "storage"
	CONST_IF_ROLE_UNKNOWN = "unknown"
	CONST_IF_TYPE_AGGREGATION = "aggregation"
	CONST_IF_TYPE_PHYSICAL = "physical"
	CONST_IF_TYPE_UNKNOWN = "unknown"
	CONST_IF_TYPE_VIRTUAL = "virtual"

class FirmwareBootUnit(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"FirmwareBootUnit")

	@staticmethod
	def ClassId():
		return "firmwareBootUnit"

	ADMIN_STATE = "AdminState"
	DN = "Dn"
	IGNORE_COMP_CHECK = "IgnoreCompCheck"
	IMAGE = "Image"
	OPER_STATE = "OperState"
	PREV_VERSION = "PrevVersion"
	RESET_ON_ACTIVATE = "ResetOnActivate"
	RN = "Rn"
	SKIP_VALIDATION = "SkipValidation"
	STATUS = "Status"
	TYPE = "Type"
	VERSION = "Version"

	CONST_ADMIN_STATE_TRIGGER = "trigger"
	CONST_ADMIN_STATE_TRIGGERED = "triggered"
	CONST_IGNORE_COMP_CHECK_FALSE = "false"
	CONST_IGNORE_COMP_CHECK_NO = "no"
	CONST_IGNORE_COMP_CHECK_TRUE = "true"
	CONST_IGNORE_COMP_CHECK_YES = "yes"
	CONST_IMAGE_BACKUP = "backup"
	CONST_IMAGE_RUNNING = "running"
	CONST_OPER_STATE_ACTIVATING = "activating"
	CONST_OPER_STATE_AUTO_ACTIVATING = "auto-activating"
	CONST_OPER_STATE_AUTO_UPDATING = "auto-updating"
	CONST_OPER_STATE_BAD_IMAGE = "bad-image"
	CONST_OPER_STATE_FAILED = "failed"
	CONST_OPER_STATE_PENDING_NEXT_BOOT = "pending-next-boot"
	CONST_OPER_STATE_PENDING_POWER_CYCLE = "pending-power-cycle"
	CONST_OPER_STATE_READY = "ready"
	CONST_OPER_STATE_REBOOTING = "rebooting"
	CONST_OPER_STATE_SCHEDULED = "scheduled"
	CONST_OPER_STATE_SET_STARTUP = "set-startup"
	CONST_OPER_STATE_THROTTLED = "throttled"
	CONST_OPER_STATE_UPDATING = "updating"
	CONST_OPER_STATE_UPGRADING = "upgrading"
	CONST_RESET_ON_ACTIVATE_FALSE = "false"
	CONST_RESET_ON_ACTIVATE_NO = "no"
	CONST_RESET_ON_ACTIVATE_TRUE = "true"
	CONST_RESET_ON_ACTIVATE_YES = "yes"
	CONST_SKIP_VALIDATION_FALSE = "false"
	CONST_SKIP_VALIDATION_NO = "no"
	CONST_SKIP_VALIDATION_TRUE = "true"
	CONST_SKIP_VALIDATION_YES = "yes"

class StorageSystemFsmTask(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"StorageSystemFsmTask")

	@staticmethod
	def ClassId():
		return "storageSystemFsmTask"

	COMPLETION = "Completion"
	DN = "Dn"
	FLAGS = "Flags"
	ITEM = "Item"
	RN = "Rn"
	SEQ_ID = "SeqId"
	STATUS = "Status"

	CONST_COMPLETION_CANCELLED = "cancelled"
	CONST_COMPLETION_COMPLETED = "completed"
	CONST_COMPLETION_PROCESSING = "processing"
	CONST_COMPLETION_SCHEDULED = "scheduled"
	CONST_ITEM_SYNC = "Sync"
	CONST_ITEM_NOP = "nop"

class PowerGroup(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"PowerGroup")

	@staticmethod
	def ClassId():
		return "powerGroup"

	ADMIN_COMMITTED = "AdminCommitted"
	ADMIN_PEAK = "AdminPeak"
	CUR_REQ_POWER = "CurReqPower"
	CURRENT_POWER = "CurrentPower"
	DESCR = "Descr"
	DN = "Dn"
	MIN_REQ_POWER = "MinReqPower"
	NAME = "Name"
	OPER_COMMITTED = "OperCommitted"
	OPER_PEAK = "OperPeak"
	OPER_STATE = "OperState"
	POLICY_LEVEL = "PolicyLevel"
	POLICY_OWNER = "PolicyOwner"
	QUALIFIER = "Qualifier"
	REALLOC = "Realloc"
	RN = "Rn"
	STATUS = "Status"

	CONST_ADMIN_COMMITTED_UNBOUNDED = "unbounded"
	CONST_ADMIN_PEAK_UNBOUNDED = "unbounded"
	CONST_CUR_REQ_POWER_UNBOUNDED = "unbounded"
	CONST_CURRENT_POWER_UNBOUNDED = "unbounded"
	CONST_INT_ID_NONE = "none"
	CONST_MIN_REQ_POWER_UNBOUNDED = "unbounded"
	CONST_OPER_COMMITTED_UNBOUNDED = "unbounded"
	CONST_OPER_PEAK_UNBOUNDED = "unbounded"
	CONST_POLICY_OWNER_LOCAL = "local"
	CONST_POLICY_OWNER_PENDING_POLICY = "pending-policy"
	CONST_POLICY_OWNER_POLICY = "policy"
	CONST_REALLOC_CHASSIS = "chassis"
	CONST_REALLOC_NONE = "none"

class FabricNetflowMonExporter(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"FabricNetflowMonExporter")

	@staticmethod
	def ClassId():
		return "fabricNetflowMonExporter"

	DESCR = "Descr"
	DN = "Dn"
	DSCP = "Dscp"
	EXPORT_INTERNAL = "ExportInternal"
	EXPORTER_STATS_TIMEOUT = "ExporterStatsTimeout"
	FLOW_EXP_PROFILE = "FlowExpProfile"
	FLOW_MON_COLLECTOR = "FlowMonCollector"
	INTERFACE_TABLE_TIMEOUT = "InterfaceTableTimeout"
	NAME = "Name"
	OPER_FLOW_EXP_PROFILE = "OperFlowExpProfile"
	POLICY_LEVEL = "PolicyLevel"
	POLICY_OWNER = "PolicyOwner"
	PROTOCOL = "Protocol"
	RN = "Rn"
	STATUS = "Status"
	TEMPLATE_DATA_TIMEOUT = "TemplateDataTimeout"
	TRANSPORT = "Transport"
	TRANSPORT_PROTOCOL = "TransportProtocol"
	TYPE = "Type"
	VERSION = "Version"

	CONST_INT_ID_NONE = "none"
	CONST_POLICY_OWNER_LOCAL = "local"
	CONST_POLICY_OWNER_PENDING_POLICY = "pending-policy"
	CONST_POLICY_OWNER_POLICY = "policy"
	CONST_PROTOCOL_NETFLOW = "netflow"
	CONST_TRANSPORT_PROTOCOL_SCTP = "sctp"
	CONST_TRANSPORT_PROTOCOL_UDP = "udp"
	CONST_VERSION_IPFIX = "ipfix"
	CONST_VERSION_V9 = "v9"

class VnicIPv4Dns(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"VnicIPv4Dns")

	@staticmethod
	def ClassId():
		return "vnicIPv4Dns"

	ADDR = "Addr"
	DEF_GW = "DefGw"
	DN = "Dn"
	PREF = "Pref"
	RN = "Rn"
	STATUS = "Status"
	SUBNET = "Subnet"

	CONST_PREF_ALTERNATE = "alternate"
	CONST_PREF_PREFERRED = "preferred"

class ComputePhysicalFsmStage(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"ComputePhysicalFsmStage")

	@staticmethod
	def ClassId():
		return "computePhysicalFsmStage"

	DESCR = "Descr"
	DN = "Dn"
	LAST_UPDATE_TIME = "LastUpdateTime"
	NAME = "Name"
	ORDER = "Order"
	RETRY = "Retry"
	RN = "Rn"
	STAGE_STATUS = "StageStatus"
	STATUS = "Status"

	CONST_LAST_UPDATE_TIME_ = ""
	CONST_NAME_ACTIVATE_ADAPTOR_ACTIVATE_LOCAL = "ActivateAdaptorActivateLocal"
	CONST_NAME_ACTIVATE_ADAPTOR_ACTIVATE_PEER = "ActivateAdaptorActivatePeer"
	CONST_NAME_ACTIVATE_ADAPTOR_BEGIN = "ActivateAdaptorBegin"
	CONST_NAME_ACTIVATE_ADAPTOR_DEASSERT_RESET_BYPASS = "ActivateAdaptorDeassertResetBypass"
	CONST_NAME_ACTIVATE_ADAPTOR_FAIL = "ActivateAdaptorFail"
	CONST_NAME_ACTIVATE_ADAPTOR_POWER_ON = "ActivateAdaptorPowerOn"
	CONST_NAME_ACTIVATE_ADAPTOR_RESET = "ActivateAdaptorReset"
	CONST_NAME_ACTIVATE_ADAPTOR_SUCCESS = "ActivateAdaptorSuccess"
	CONST_NAME_ACTIVATE_BIOSACTIVATE = "ActivateBIOSActivate"
	CONST_NAME_ACTIVATE_BIOSBEGIN = "ActivateBIOSBegin"
	CONST_NAME_ACTIVATE_BIOSCLEAR = "ActivateBIOSClear"
	CONST_NAME_ACTIVATE_BIOSFAIL = "ActivateBIOSFail"
	CONST_NAME_ACTIVATE_BIOSPOLL_ACTIVATE_STATUS = "ActivateBIOSPollActivateStatus"
	CONST_NAME_ACTIVATE_BIOSPOLL_CLEAR_STATUS = "ActivateBIOSPollClearStatus"
	CONST_NAME_ACTIVATE_BIOSPOWER_OFF = "ActivateBIOSPowerOff"
	CONST_NAME_ACTIVATE_BIOSPOWER_ON = "ActivateBIOSPowerOn"
	CONST_NAME_ACTIVATE_BIOSSUCCESS = "ActivateBIOSSuccess"
	CONST_NAME_ACTIVATE_BIOSUPDATE_TOKENS = "ActivateBIOSUpdateTokens"
	CONST_NAME_ASSOCIATE_ACTIVATE_ADAPTOR_NW_FW_LOCAL = "AssociateActivateAdaptorNwFwLocal"
	CONST_NAME_ASSOCIATE_ACTIVATE_ADAPTOR_NW_FW_PEER = "AssociateActivateAdaptorNwFwPeer"
	CONST_NAME_ASSOCIATE_ACTIVATE_BIOS = "AssociateActivateBios"
	CONST_NAME_ASSOCIATE_ACTIVATE_IBMCFW = "AssociateActivateIBMCFw"
	CONST_NAME_ASSOCIATE_BEGIN = "AssociateBegin"
	CONST_NAME_ASSOCIATE_BIOS_IMG_UPDATE = "AssociateBiosImgUpdate"
	CONST_NAME_ASSOCIATE_BIOS_POST_COMPLETION = "AssociateBiosPostCompletion"
	CONST_NAME_ASSOCIATE_BLADE_POWER_OFF = "AssociateBladePowerOff"
	CONST_NAME_ASSOCIATE_BMC_CONFIG_PNU_OS = "AssociateBmcConfigPnuOS"
	CONST_NAME_ASSOCIATE_BMC_PRECONFIG_PNU_OSLOCAL = "AssociateBmcPreconfigPnuOSLocal"
	CONST_NAME_ASSOCIATE_BMC_PRECONFIG_PNU_OSPEER = "AssociateBmcPreconfigPnuOSPeer"
	CONST_NAME_ASSOCIATE_BMC_UNCONFIG_PNU_OS = "AssociateBmcUnconfigPnuOS"
	CONST_NAME_ASSOCIATE_BOOT_HOST = "AssociateBootHost"
	CONST_NAME_ASSOCIATE_BOOT_PNUOS = "AssociateBootPnuos"
	CONST_NAME_ASSOCIATE_BOOT_WAIT = "AssociateBootWait"
	CONST_NAME_ASSOCIATE_CLEAR_BIOS_UPDATE = "AssociateClearBiosUpdate"
	CONST_NAME_ASSOCIATE_CONFIG_FLEX_FLASH = "AssociateConfigFlexFlash"
	CONST_NAME_ASSOCIATE_CONFIG_SO_L = "AssociateConfigSoL"
	CONST_NAME_ASSOCIATE_CONFIG_USER_ACCESS = "AssociateConfigUserAccess"
	CONST_NAME_ASSOCIATE_CONFIG_UUID = "AssociateConfigUuid"
	CONST_NAME_ASSOCIATE_DEASSERT_RESET_BYPASS = "AssociateDeassertResetBypass"
	CONST_NAME_ASSOCIATE_FAIL = "AssociateFail"
	CONST_NAME_ASSOCIATE_HAG_HOST_OSCONNECT = "AssociateHagHostOSConnect"
	CONST_NAME_ASSOCIATE_HAG_PNU_OSCONNECT = "AssociateHagPnuOSConnect"
	CONST_NAME_ASSOCIATE_HAG_PNU_OSDISCONNECT = "AssociateHagPnuOSDisconnect"
	CONST_NAME_ASSOCIATE_HBA_IMG_UPDATE = "AssociateHbaImgUpdate"
	CONST_NAME_ASSOCIATE_HOST_OSCONFIG = "AssociateHostOSConfig"
	CONST_NAME_ASSOCIATE_HOST_OSIDENT = "AssociateHostOSIdent"
	CONST_NAME_ASSOCIATE_HOST_OSPOLICY = "AssociateHostOSPolicy"
	CONST_NAME_ASSOCIATE_HOST_OSVALIDATE = "AssociateHostOSValidate"
	CONST_NAME_ASSOCIATE_LOCAL_DISK_FW_UPDATE = "AssociateLocalDiskFwUpdate"
	CONST_NAME_ASSOCIATE_MARK_ADAPTER_FOR_REBOOT = "AssociateMarkAdapterForReboot"
	CONST_NAME_ASSOCIATE_NIC_CONFIG_HOST_OSLOCAL = "AssociateNicConfigHostOSLocal"
	CONST_NAME_ASSOCIATE_NIC_CONFIG_HOST_OSPEER = "AssociateNicConfigHostOSPeer"
	CONST_NAME_ASSOCIATE_NIC_CONFIG_PNU_OSLOCAL = "AssociateNicConfigPnuOSLocal"
	CONST_NAME_ASSOCIATE_NIC_CONFIG_PNU_OSPEER = "AssociateNicConfigPnuOSPeer"
	CONST_NAME_ASSOCIATE_NIC_CONFIG_SERVICE_INFRA_LOCAL = "AssociateNicConfigServiceInfraLocal"
	CONST_NAME_ASSOCIATE_NIC_CONFIG_SERVICE_INFRA_PEER = "AssociateNicConfigServiceInfraPeer"
	CONST_NAME_ASSOCIATE_NIC_IMG_UPDATE = "AssociateNicImgUpdate"
	CONST_NAME_ASSOCIATE_NIC_UNCONFIG_PNU_OSLOCAL = "AssociateNicUnconfigPnuOSLocal"
	CONST_NAME_ASSOCIATE_NIC_UNCONFIG_PNU_OSPEER = "AssociateNicUnconfigPnuOSPeer"
	CONST_NAME_ASSOCIATE_OOB_STORAGE_INVENTORY = "AssociateOobStorageInventory"
	CONST_NAME_ASSOCIATE_PNU_OSCATALOG = "AssociatePnuOSCatalog"
	CONST_NAME_ASSOCIATE_PNU_OSCONFIG = "AssociatePnuOSConfig"
	CONST_NAME_ASSOCIATE_PNU_OSIDENT = "AssociatePnuOSIdent"
	CONST_NAME_ASSOCIATE_PNU_OSINVENTORY = "AssociatePnuOSInventory"
	CONST_NAME_ASSOCIATE_PNU_OSLOCAL_DISK_CONFIG = "AssociatePnuOSLocalDiskConfig"
	CONST_NAME_ASSOCIATE_PNU_OSPOLICY = "AssociatePnuOSPolicy"
	CONST_NAME_ASSOCIATE_PNU_OSSELF_TEST = "AssociatePnuOSSelfTest"
	CONST_NAME_ASSOCIATE_PNU_OSUNLOAD_DRIVERS = "AssociatePnuOSUnloadDrivers"
	CONST_NAME_ASSOCIATE_PNU_OSVALIDATE = "AssociatePnuOSValidate"
	CONST_NAME_ASSOCIATE_POLL_BIOS_ACTIVATE_STATUS = "AssociatePollBiosActivateStatus"
	CONST_NAME_ASSOCIATE_POLL_BIOS_UPDATE_STATUS = "AssociatePollBiosUpdateStatus"
	CONST_NAME_ASSOCIATE_POLL_BOARD_CTRL_UPDATE_STATUS = "AssociatePollBoardCtrlUpdateStatus"
	CONST_NAME_ASSOCIATE_POLL_CLEAR_BIOS_UPDATE_STATUS = "AssociatePollClearBiosUpdateStatus"
	CONST_NAME_ASSOCIATE_POWER_ON = "AssociatePowerOn"
	CONST_NAME_ASSOCIATE_POWER_ON_PRE_CONFIG = "AssociatePowerOnPreConfig"
	CONST_NAME_ASSOCIATE_PRE_SANITIZE = "AssociatePreSanitize"
	CONST_NAME_ASSOCIATE_PREPARE_FOR_BOOT = "AssociatePrepareForBoot"
	CONST_NAME_ASSOCIATE_RESET_IBMC = "AssociateResetIBMC"
	CONST_NAME_ASSOCIATE_SANITIZE = "AssociateSanitize"
	CONST_NAME_ASSOCIATE_SERIAL_DEBUG_PNU_OSCONNECT = "AssociateSerialDebugPnuOSConnect"
	CONST_NAME_ASSOCIATE_SERIAL_DEBUG_PNU_OSDISCONNECT = "AssociateSerialDebugPnuOSDisconnect"
	CONST_NAME_ASSOCIATE_SOL_REDIRECT_DISABLE = "AssociateSolRedirectDisable"
	CONST_NAME_ASSOCIATE_SOL_REDIRECT_ENABLE = "AssociateSolRedirectEnable"
	CONST_NAME_ASSOCIATE_STORAGE_CTLR_IMG_UPDATE = "AssociateStorageCtlrImgUpdate"
	CONST_NAME_ASSOCIATE_SUCCESS = "AssociateSuccess"
	CONST_NAME_ASSOCIATE_SW_CONFIG_HOST_OSLOCAL = "AssociateSwConfigHostOSLocal"
	CONST_NAME_ASSOCIATE_SW_CONFIG_HOST_OSPEER = "AssociateSwConfigHostOSPeer"
	CONST_NAME_ASSOCIATE_SW_CONFIG_PNU_OSLOCAL = "AssociateSwConfigPnuOSLocal"
	CONST_NAME_ASSOCIATE_SW_CONFIG_PNU_OSPEER = "AssociateSwConfigPnuOSPeer"
	CONST_NAME_ASSOCIATE_SW_CONFIG_PORT_NIV_LOCAL = "AssociateSwConfigPortNivLocal"
	CONST_NAME_ASSOCIATE_SW_CONFIG_PORT_NIV_PEER = "AssociateSwConfigPortNivPeer"
	CONST_NAME_ASSOCIATE_SW_CONFIG_SERVICE_INFRA_LOCAL = "AssociateSwConfigServiceInfraLocal"
	CONST_NAME_ASSOCIATE_SW_CONFIG_SERVICE_INFRA_PEER = "AssociateSwConfigServiceInfraPeer"
	CONST_NAME_ASSOCIATE_SW_UNCONFIG_PNU_OSLOCAL = "AssociateSwUnconfigPnuOSLocal"
	CONST_NAME_ASSOCIATE_SW_UNCONFIG_PNU_OSPEER = "AssociateSwUnconfigPnuOSPeer"
	CONST_NAME_ASSOCIATE_SYNC_POWER_STATE = "AssociateSyncPowerState"
	CONST_NAME_ASSOCIATE_UPDATE_ADAPTOR_NW_FW_LOCAL = "AssociateUpdateAdaptorNwFwLocal"
	CONST_NAME_ASSOCIATE_UPDATE_ADAPTOR_NW_FW_PEER = "AssociateUpdateAdaptorNwFwPeer"
	CONST_NAME_ASSOCIATE_UPDATE_BIOS_REQUEST = "AssociateUpdateBiosRequest"
	CONST_NAME_ASSOCIATE_UPDATE_BOARD_CTRL_REQUEST = "AssociateUpdateBoardCtrlRequest"
	CONST_NAME_ASSOCIATE_UPDATE_IBMCFW = "AssociateUpdateIBMCFw"
	CONST_NAME_ASSOCIATE_VERIFY_FC_ZONE_CONFIG = "AssociateVerifyFcZoneConfig"
	CONST_NAME_ASSOCIATE_WAIT_FOR_ADAPTOR_NW_FW_UPDATE_LOCAL = "AssociateWaitForAdaptorNwFwUpdateLocal"
	CONST_NAME_ASSOCIATE_WAIT_FOR_ADAPTOR_NW_FW_UPDATE_PEER = "AssociateWaitForAdaptorNwFwUpdatePeer"
	CONST_NAME_ASSOCIATE_WAIT_FOR_IBMCFW_UPDATE = "AssociateWaitForIBMCFwUpdate"
	CONST_NAME_BIOS_RECOVERY_BEGIN = "BiosRecoveryBegin"
	CONST_NAME_BIOS_RECOVERY_CLEANUP = "BiosRecoveryCleanup"
	CONST_NAME_BIOS_RECOVERY_FAIL = "BiosRecoveryFail"
	CONST_NAME_BIOS_RECOVERY_PRE_SANITIZE = "BiosRecoveryPreSanitize"
	CONST_NAME_BIOS_RECOVERY_RESET = "BiosRecoveryReset"
	CONST_NAME_BIOS_RECOVERY_SANITIZE = "BiosRecoverySanitize"
	CONST_NAME_BIOS_RECOVERY_SETUP_VMEDIA_LOCAL = "BiosRecoverySetupVmediaLocal"
	CONST_NAME_BIOS_RECOVERY_SETUP_VMEDIA_PEER = "BiosRecoverySetupVmediaPeer"
	CONST_NAME_BIOS_RECOVERY_SHUTDOWN = "BiosRecoveryShutdown"
	CONST_NAME_BIOS_RECOVERY_START = "BiosRecoveryStart"
	CONST_NAME_BIOS_RECOVERY_STOP_VMEDIA_LOCAL = "BiosRecoveryStopVMediaLocal"
	CONST_NAME_BIOS_RECOVERY_STOP_VMEDIA_PEER = "BiosRecoveryStopVMediaPeer"
	CONST_NAME_BIOS_RECOVERY_SUCCESS = "BiosRecoverySuccess"
	CONST_NAME_BIOS_RECOVERY_TEARDOWN_VMEDIA_LOCAL = "BiosRecoveryTeardownVmediaLocal"
	CONST_NAME_BIOS_RECOVERY_TEARDOWN_VMEDIA_PEER = "BiosRecoveryTeardownVmediaPeer"
	CONST_NAME_BIOS_RECOVERY_WAIT = "BiosRecoveryWait"
	CONST_NAME_CIMC_SESSION_DELETE_BEGIN = "CimcSessionDeleteBegin"
	CONST_NAME_CIMC_SESSION_DELETE_EXECUTE = "CimcSessionDeleteExecute"
	CONST_NAME_CIMC_SESSION_DELETE_FAIL = "CimcSessionDeleteFail"
	CONST_NAME_CIMC_SESSION_DELETE_SUCCESS = "CimcSessionDeleteSuccess"
	CONST_NAME_CMOS_RESET_BEGIN = "CmosResetBegin"
	CONST_NAME_CMOS_RESET_BLADE_POWER_ON = "CmosResetBladePowerOn"
	CONST_NAME_CMOS_RESET_EXECUTE = "CmosResetExecute"
	CONST_NAME_CMOS_RESET_FAIL = "CmosResetFail"
	CONST_NAME_CMOS_RESET_PRE_SANITIZE = "CmosResetPreSanitize"
	CONST_NAME_CMOS_RESET_RECONFIG_BIOS = "CmosResetReconfigBios"
	CONST_NAME_CMOS_RESET_RECONFIG_UUID = "CmosResetReconfigUuid"
	CONST_NAME_CMOS_RESET_SANITIZE = "CmosResetSanitize"
	CONST_NAME_CMOS_RESET_SUCCESS = "CmosResetSuccess"
	CONST_NAME_CONFIG_BOARD_BEGIN = "ConfigBoardBegin"
	CONST_NAME_CONFIG_BOARD_CONFIG_MEMORY_POLICY = "ConfigBoardConfigMemoryPolicy"
	CONST_NAME_CONFIG_BOARD_FAIL = "ConfigBoardFail"
	CONST_NAME_CONFIG_BOARD_SUCCESS = "ConfigBoardSuccess"
	CONST_NAME_CONFIG_SO_LBEGIN = "ConfigSoLBegin"
	CONST_NAME_CONFIG_SO_LEXECUTE = "ConfigSoLExecute"
	CONST_NAME_CONFIG_SO_LFAIL = "ConfigSoLFail"
	CONST_NAME_CONFIG_SO_LSUCCESS = "ConfigSoLSuccess"
	CONST_NAME_DECOMMISSION_BEGIN = "DecommissionBegin"
	CONST_NAME_DECOMMISSION_CLEANUP_CIMC = "DecommissionCleanupCIMC"
	CONST_NAME_DECOMMISSION_CLEANUP_PORT_CONFIG_LOCAL = "DecommissionCleanupPortConfigLocal"
	CONST_NAME_DECOMMISSION_CLEANUP_PORT_CONFIG_PEER = "DecommissionCleanupPortConfigPeer"
	CONST_NAME_DECOMMISSION_EXECUTE = "DecommissionExecute"
	CONST_NAME_DECOMMISSION_FAIL = "DecommissionFail"
	CONST_NAME_DECOMMISSION_STOP_VMEDIA_LOCAL = "DecommissionStopVMediaLocal"
	CONST_NAME_DECOMMISSION_STOP_VMEDIA_PEER = "DecommissionStopVMediaPeer"
	CONST_NAME_DECOMMISSION_SUCCESS = "DecommissionSuccess"
	CONST_NAME_DIAGNOSTIC_INTERRUPT_BEGIN = "DiagnosticInterruptBegin"
	CONST_NAME_DIAGNOSTIC_INTERRUPT_EXECUTE = "DiagnosticInterruptExecute"
	CONST_NAME_DIAGNOSTIC_INTERRUPT_FAIL = "DiagnosticInterruptFail"
	CONST_NAME_DIAGNOSTIC_INTERRUPT_SUCCESS = "DiagnosticInterruptSuccess"
	CONST_NAME_DISASSOCIATE_BEGIN = "DisassociateBegin"
	CONST_NAME_DISASSOCIATE_BIOS_POST_COMPLETION = "DisassociateBiosPostCompletion"
	CONST_NAME_DISASSOCIATE_BMC_CONFIG_PNU_OS = "DisassociateBmcConfigPnuOS"
	CONST_NAME_DISASSOCIATE_BMC_PRECONFIG_PNU_OSLOCAL = "DisassociateBmcPreconfigPnuOSLocal"
	CONST_NAME_DISASSOCIATE_BMC_PRECONFIG_PNU_OSPEER = "DisassociateBmcPreconfigPnuOSPeer"
	CONST_NAME_DISASSOCIATE_BMC_UNCONFIG_PNU_OS = "DisassociateBmcUnconfigPnuOS"
	CONST_NAME_DISASSOCIATE_BOOT_PNUOS = "DisassociateBootPnuos"
	CONST_NAME_DISASSOCIATE_BOOT_WAIT = "DisassociateBootWait"
	CONST_NAME_DISASSOCIATE_CONFIG_BIOS = "DisassociateConfigBios"
	CONST_NAME_DISASSOCIATE_CONFIG_FLEX_FLASH_SCRUB = "DisassociateConfigFlexFlashScrub"
	CONST_NAME_DISASSOCIATE_CONFIG_USER_ACCESS = "DisassociateConfigUserAccess"
	CONST_NAME_DISASSOCIATE_DEASSERT_RESET_BYPASS = "DisassociateDeassertResetBypass"
	CONST_NAME_DISASSOCIATE_FAIL = "DisassociateFail"
	CONST_NAME_DISASSOCIATE_HAG_PNU_OSCONNECT = "DisassociateHagPnuOSConnect"
	CONST_NAME_DISASSOCIATE_HAG_PNU_OSDISCONNECT = "DisassociateHagPnuOSDisconnect"
	CONST_NAME_DISASSOCIATE_HANDLE_POOLING = "DisassociateHandlePooling"
	CONST_NAME_DISASSOCIATE_NIC_CONFIG_PNU_OSLOCAL = "DisassociateNicConfigPnuOSLocal"
	CONST_NAME_DISASSOCIATE_NIC_CONFIG_PNU_OSPEER = "DisassociateNicConfigPnuOSPeer"
	CONST_NAME_DISASSOCIATE_NIC_UNCONFIG_HOST_OSLOCAL = "DisassociateNicUnconfigHostOSLocal"
	CONST_NAME_DISASSOCIATE_NIC_UNCONFIG_HOST_OSPEER = "DisassociateNicUnconfigHostOSPeer"
	CONST_NAME_DISASSOCIATE_NIC_UNCONFIG_PNU_OSLOCAL = "DisassociateNicUnconfigPnuOSLocal"
	CONST_NAME_DISASSOCIATE_NIC_UNCONFIG_PNU_OSPEER = "DisassociateNicUnconfigPnuOSPeer"
	CONST_NAME_DISASSOCIATE_NIC_UNCONFIG_SERVICE_INFRA_LOCAL = "DisassociateNicUnconfigServiceInfraLocal"
	CONST_NAME_DISASSOCIATE_NIC_UNCONFIG_SERVICE_INFRA_PEER = "DisassociateNicUnconfigServiceInfraPeer"
	CONST_NAME_DISASSOCIATE_PNU_OSCATALOG = "DisassociatePnuOSCatalog"
	CONST_NAME_DISASSOCIATE_PNU_OSIDENT = "DisassociatePnuOSIdent"
	CONST_NAME_DISASSOCIATE_PNU_OSPOLICY = "DisassociatePnuOSPolicy"
	CONST_NAME_DISASSOCIATE_PNU_OSSCRUB = "DisassociatePnuOSScrub"
	CONST_NAME_DISASSOCIATE_PNU_OSSELF_TEST = "DisassociatePnuOSSelfTest"
	CONST_NAME_DISASSOCIATE_PNU_OSUNCONFIG = "DisassociatePnuOSUnconfig"
	CONST_NAME_DISASSOCIATE_PNU_OSVALIDATE = "DisassociatePnuOSValidate"
	CONST_NAME_DISASSOCIATE_POWER_ON = "DisassociatePowerOn"
	CONST_NAME_DISASSOCIATE_PRE_SANITIZE = "DisassociatePreSanitize"
	CONST_NAME_DISASSOCIATE_RESET_SECURE_BOOT_CONFIG = "DisassociateResetSecureBootConfig"
	CONST_NAME_DISASSOCIATE_SANITIZE = "DisassociateSanitize"
	CONST_NAME_DISASSOCIATE_SERIAL_DEBUG_PNU_OSCONNECT = "DisassociateSerialDebugPnuOSConnect"
	CONST_NAME_DISASSOCIATE_SERIAL_DEBUG_PNU_OSDISCONNECT = "DisassociateSerialDebugPnuOSDisconnect"
	CONST_NAME_DISASSOCIATE_SHUTDOWN = "DisassociateShutdown"
	CONST_NAME_DISASSOCIATE_SOL_REDIRECT_DISABLE = "DisassociateSolRedirectDisable"
	CONST_NAME_DISASSOCIATE_SOL_REDIRECT_ENABLE = "DisassociateSolRedirectEnable"
	CONST_NAME_DISASSOCIATE_SUCCESS = "DisassociateSuccess"
	CONST_NAME_DISASSOCIATE_SW_CONFIG_PNU_OSLOCAL = "DisassociateSwConfigPnuOSLocal"
	CONST_NAME_DISASSOCIATE_SW_CONFIG_PNU_OSPEER = "DisassociateSwConfigPnuOSPeer"
	CONST_NAME_DISASSOCIATE_SW_CONFIG_PORT_NIV_LOCAL = "DisassociateSwConfigPortNivLocal"
	CONST_NAME_DISASSOCIATE_SW_CONFIG_PORT_NIV_PEER = "DisassociateSwConfigPortNivPeer"
	CONST_NAME_DISASSOCIATE_SW_UNCONFIG_HOST_OSLOCAL = "DisassociateSwUnconfigHostOSLocal"
	CONST_NAME_DISASSOCIATE_SW_UNCONFIG_HOST_OSPEER = "DisassociateSwUnconfigHostOSPeer"
	CONST_NAME_DISASSOCIATE_SW_UNCONFIG_PNU_OSLOCAL = "DisassociateSwUnconfigPnuOSLocal"
	CONST_NAME_DISASSOCIATE_SW_UNCONFIG_PNU_OSPEER = "DisassociateSwUnconfigPnuOSPeer"
	CONST_NAME_DISASSOCIATE_UNCONFIG_BIOS = "DisassociateUnconfigBios"
	CONST_NAME_DISASSOCIATE_UNCONFIG_FLEX_FLASH = "DisassociateUnconfigFlexFlash"
	CONST_NAME_DISASSOCIATE_UNCONFIG_SO_L = "DisassociateUnconfigSoL"
	CONST_NAME_DISASSOCIATE_UNCONFIG_UUID = "DisassociateUnconfigUuid"
	CONST_NAME_DISASSOCIATE_VERIFY_FC_ZONE_CONFIG = "DisassociateVerifyFcZoneConfig"
	CONST_NAME_FW_UPGRADE_ACTIVATE_ADAPTOR_NW_FW_LOCAL = "FwUpgradeActivateAdaptorNwFwLocal"
	CONST_NAME_FW_UPGRADE_ACTIVATE_ADAPTOR_NW_FW_PEER = "FwUpgradeActivateAdaptorNwFwPeer"
	CONST_NAME_FW_UPGRADE_ACTIVATE_BIOS = "FwUpgradeActivateBios"
	CONST_NAME_FW_UPGRADE_ACTIVATE_IBMCFW = "FwUpgradeActivateIBMCFw"
	CONST_NAME_FW_UPGRADE_BEGIN = "FwUpgradeBegin"
	CONST_NAME_FW_UPGRADE_BIOS_IMG_UPDATE = "FwUpgradeBiosImgUpdate"
	CONST_NAME_FW_UPGRADE_BIOS_POST_COMPLETION = "FwUpgradeBiosPostCompletion"
	CONST_NAME_FW_UPGRADE_BLADE_POWER_OFF = "FwUpgradeBladePowerOff"
	CONST_NAME_FW_UPGRADE_BMC_CONFIG_PNU_OS = "FwUpgradeBmcConfigPnuOS"
	CONST_NAME_FW_UPGRADE_BMC_PRECONFIG_PNU_OSLOCAL = "FwUpgradeBmcPreconfigPnuOSLocal"
	CONST_NAME_FW_UPGRADE_BMC_PRECONFIG_PNU_OSPEER = "FwUpgradeBmcPreconfigPnuOSPeer"
	CONST_NAME_FW_UPGRADE_BMC_UNCONFIG_PNU_OS = "FwUpgradeBmcUnconfigPnuOS"
	CONST_NAME_FW_UPGRADE_BOOT_PNUOS = "FwUpgradeBootPnuos"
	CONST_NAME_FW_UPGRADE_BOOT_WAIT = "FwUpgradeBootWait"
	CONST_NAME_FW_UPGRADE_CLEAR_BIOS_UPDATE = "FwUpgradeClearBiosUpdate"
	CONST_NAME_FW_UPGRADE_DEASSERT_RESET_BYPASS = "FwUpgradeDeassertResetBypass"
	CONST_NAME_FW_UPGRADE_FAIL = "FwUpgradeFail"
	CONST_NAME_FW_UPGRADE_HAG_PNU_OSCONNECT = "FwUpgradeHagPnuOSConnect"
	CONST_NAME_FW_UPGRADE_HAG_PNU_OSDISCONNECT = "FwUpgradeHagPnuOSDisconnect"
	CONST_NAME_FW_UPGRADE_HBA_IMG_UPDATE = "FwUpgradeHbaImgUpdate"
	CONST_NAME_FW_UPGRADE_LOCAL_DISK_FW_UPDATE = "FwUpgradeLocalDiskFwUpdate"
	CONST_NAME_FW_UPGRADE_NIC_CONFIG_PNU_OSLOCAL = "FwUpgradeNicConfigPnuOSLocal"
	CONST_NAME_FW_UPGRADE_NIC_CONFIG_PNU_OSPEER = "FwUpgradeNicConfigPnuOSPeer"
	CONST_NAME_FW_UPGRADE_NIC_IMG_UPDATE = "FwUpgradeNicImgUpdate"
	CONST_NAME_FW_UPGRADE_NIC_UNCONFIG_PNU_OSLOCAL = "FwUpgradeNicUnconfigPnuOSLocal"
	CONST_NAME_FW_UPGRADE_NIC_UNCONFIG_PNU_OSPEER = "FwUpgradeNicUnconfigPnuOSPeer"
	CONST_NAME_FW_UPGRADE_PNU_OSCATALOG = "FwUpgradePnuOSCatalog"
	CONST_NAME_FW_UPGRADE_PNU_OSCONFIG = "FwUpgradePnuOSConfig"
	CONST_NAME_FW_UPGRADE_PNU_OSIDENT = "FwUpgradePnuOSIdent"
	CONST_NAME_FW_UPGRADE_PNU_OSINVENTORY = "FwUpgradePnuOSInventory"
	CONST_NAME_FW_UPGRADE_PNU_OSPOLICY = "FwUpgradePnuOSPolicy"
	CONST_NAME_FW_UPGRADE_PNU_OSSELF_TEST = "FwUpgradePnuOSSelfTest"
	CONST_NAME_FW_UPGRADE_PNU_OSUNLOAD_DRIVERS = "FwUpgradePnuOSUnloadDrivers"
	CONST_NAME_FW_UPGRADE_PNU_OSVALIDATE = "FwUpgradePnuOSValidate"
	CONST_NAME_FW_UPGRADE_POLL_BIOS_ACTIVATE_STATUS = "FwUpgradePollBiosActivateStatus"
	CONST_NAME_FW_UPGRADE_POLL_BIOS_UPDATE_STATUS = "FwUpgradePollBiosUpdateStatus"
	CONST_NAME_FW_UPGRADE_POLL_BOARD_CTRL_UPDATE_STATUS = "FwUpgradePollBoardCtrlUpdateStatus"
	CONST_NAME_FW_UPGRADE_POLL_CLEAR_BIOS_UPDATE_STATUS = "FwUpgradePollClearBiosUpdateStatus"
	CONST_NAME_FW_UPGRADE_POWER_ON = "FwUpgradePowerOn"
	CONST_NAME_FW_UPGRADE_PRE_SANITIZE = "FwUpgradePreSanitize"
	CONST_NAME_FW_UPGRADE_RESET_IBMC = "FwUpgradeResetIBMC"
	CONST_NAME_FW_UPGRADE_SANITIZE = "FwUpgradeSanitize"
	CONST_NAME_FW_UPGRADE_SERIAL_DEBUG_PNU_OSCONNECT = "FwUpgradeSerialDebugPnuOSConnect"
	CONST_NAME_FW_UPGRADE_SERIAL_DEBUG_PNU_OSDISCONNECT = "FwUpgradeSerialDebugPnuOSDisconnect"
	CONST_NAME_FW_UPGRADE_SHUTDOWN = "FwUpgradeShutdown"
	CONST_NAME_FW_UPGRADE_SOL_REDIRECT_DISABLE = "FwUpgradeSolRedirectDisable"
	CONST_NAME_FW_UPGRADE_SOL_REDIRECT_ENABLE = "FwUpgradeSolRedirectEnable"
	CONST_NAME_FW_UPGRADE_STORAGE_CTLR_IMG_UPDATE = "FwUpgradeStorageCtlrImgUpdate"
	CONST_NAME_FW_UPGRADE_SUCCESS = "FwUpgradeSuccess"
	CONST_NAME_FW_UPGRADE_SW_CONFIG_PNU_OSLOCAL = "FwUpgradeSwConfigPnuOSLocal"
	CONST_NAME_FW_UPGRADE_SW_CONFIG_PNU_OSPEER = "FwUpgradeSwConfigPnuOSPeer"
	CONST_NAME_FW_UPGRADE_SW_CONFIG_PORT_NIV_LOCAL = "FwUpgradeSwConfigPortNivLocal"
	CONST_NAME_FW_UPGRADE_SW_CONFIG_PORT_NIV_PEER = "FwUpgradeSwConfigPortNivPeer"
	CONST_NAME_FW_UPGRADE_SW_UNCONFIG_PNU_OSLOCAL = "FwUpgradeSwUnconfigPnuOSLocal"
	CONST_NAME_FW_UPGRADE_SW_UNCONFIG_PNU_OSPEER = "FwUpgradeSwUnconfigPnuOSPeer"
	CONST_NAME_FW_UPGRADE_UPDATE_ADAPTOR_NW_FW_LOCAL = "FwUpgradeUpdateAdaptorNwFwLocal"
	CONST_NAME_FW_UPGRADE_UPDATE_ADAPTOR_NW_FW_PEER = "FwUpgradeUpdateAdaptorNwFwPeer"
	CONST_NAME_FW_UPGRADE_UPDATE_BIOS_REQUEST = "FwUpgradeUpdateBiosRequest"
	CONST_NAME_FW_UPGRADE_UPDATE_BOARD_CTRL_REQUEST = "FwUpgradeUpdateBoardCtrlRequest"
	CONST_NAME_FW_UPGRADE_UPDATE_IBMCFW = "FwUpgradeUpdateIBMCFw"
	CONST_NAME_FW_UPGRADE_WAIT_FOR_ADAPTOR_NW_FW_UPDATE_LOCAL = "FwUpgradeWaitForAdaptorNwFwUpdateLocal"
	CONST_NAME_FW_UPGRADE_WAIT_FOR_ADAPTOR_NW_FW_UPDATE_PEER = "FwUpgradeWaitForAdaptorNwFwUpdatePeer"
	CONST_NAME_FW_UPGRADE_WAIT_FOR_IBMCFW_UPDATE = "FwUpgradeWaitForIBMCFwUpdate"
	CONST_NAME_HARD_SHUTDOWN_BEGIN = "HardShutdownBegin"
	CONST_NAME_HARD_SHUTDOWN_EXECUTE = "HardShutdownExecute"
	CONST_NAME_HARD_SHUTDOWN_FAIL = "HardShutdownFail"
	CONST_NAME_HARD_SHUTDOWN_SUCCESS = "HardShutdownSuccess"
	CONST_NAME_HARDRESET_BEGIN = "HardresetBegin"
	CONST_NAME_HARDRESET_EXECUTE = "HardresetExecute"
	CONST_NAME_HARDRESET_FAIL = "HardresetFail"
	CONST_NAME_HARDRESET_PRE_SANITIZE = "HardresetPreSanitize"
	CONST_NAME_HARDRESET_SANITIZE = "HardresetSanitize"
	CONST_NAME_HARDRESET_SUCCESS = "HardresetSuccess"
	CONST_NAME_POWER_CAP_BEGIN = "PowerCapBegin"
	CONST_NAME_POWER_CAP_CONFIG = "PowerCapConfig"
	CONST_NAME_POWER_CAP_FAIL = "PowerCapFail"
	CONST_NAME_POWER_CAP_SUCCESS = "PowerCapSuccess"
	CONST_NAME_POWERCYCLE_BEGIN = "PowercycleBegin"
	CONST_NAME_POWERCYCLE_EXECUTE = "PowercycleExecute"
	CONST_NAME_POWERCYCLE_FAIL = "PowercycleFail"
	CONST_NAME_POWERCYCLE_PRE_SANITIZE = "PowercyclePreSanitize"
	CONST_NAME_POWERCYCLE_SANITIZE = "PowercycleSanitize"
	CONST_NAME_POWERCYCLE_SUCCESS = "PowercycleSuccess"
	CONST_NAME_RESET_BMC_BEGIN = "ResetBmcBegin"
	CONST_NAME_RESET_BMC_EXECUTE = "ResetBmcExecute"
	CONST_NAME_RESET_BMC_FAIL = "ResetBmcFail"
	CONST_NAME_RESET_BMC_SUCCESS = "ResetBmcSuccess"
	CONST_NAME_RESET_IPMI_BEGIN = "ResetIpmiBegin"
	CONST_NAME_RESET_IPMI_EXECUTE = "ResetIpmiExecute"
	CONST_NAME_RESET_IPMI_FAIL = "ResetIpmiFail"
	CONST_NAME_RESET_IPMI_SUCCESS = "ResetIpmiSuccess"
	CONST_NAME_RESET_KVM_BEGIN = "ResetKvmBegin"
	CONST_NAME_RESET_KVM_EXECUTE = "ResetKvmExecute"
	CONST_NAME_RESET_KVM_FAIL = "ResetKvmFail"
	CONST_NAME_RESET_KVM_SUCCESS = "ResetKvmSuccess"
	CONST_NAME_RESET_MEMORY_ERRORS_BEGIN = "ResetMemoryErrorsBegin"
	CONST_NAME_RESET_MEMORY_ERRORS_EXECUTE = "ResetMemoryErrorsExecute"
	CONST_NAME_RESET_MEMORY_ERRORS_FAIL = "ResetMemoryErrorsFail"
	CONST_NAME_RESET_MEMORY_ERRORS_SUCCESS = "ResetMemoryErrorsSuccess"
	CONST_NAME_SERVICE_INFRA_DEPLOY_BEGIN = "ServiceInfraDeployBegin"
	CONST_NAME_SERVICE_INFRA_DEPLOY_FAIL = "ServiceInfraDeployFail"
	CONST_NAME_SERVICE_INFRA_DEPLOY_NIC_CONFIG_LOCAL = "ServiceInfraDeployNicConfigLocal"
	CONST_NAME_SERVICE_INFRA_DEPLOY_NIC_CONFIG_PEER = "ServiceInfraDeployNicConfigPeer"
	CONST_NAME_SERVICE_INFRA_DEPLOY_SUCCESS = "ServiceInfraDeploySuccess"
	CONST_NAME_SERVICE_INFRA_DEPLOY_SW_CONFIG_LOCAL = "ServiceInfraDeploySwConfigLocal"
	CONST_NAME_SERVICE_INFRA_DEPLOY_SW_CONFIG_PEER = "ServiceInfraDeploySwConfigPeer"
	CONST_NAME_SERVICE_INFRA_WITHDRAW_BEGIN = "ServiceInfraWithdrawBegin"
	CONST_NAME_SERVICE_INFRA_WITHDRAW_FAIL = "ServiceInfraWithdrawFail"
	CONST_NAME_SERVICE_INFRA_WITHDRAW_NIC_UN_CONFIG_LOCAL = "ServiceInfraWithdrawNicUnConfigLocal"
	CONST_NAME_SERVICE_INFRA_WITHDRAW_NIC_UN_CONFIG_PEER = "ServiceInfraWithdrawNicUnConfigPeer"
	CONST_NAME_SERVICE_INFRA_WITHDRAW_SUCCESS = "ServiceInfraWithdrawSuccess"
	CONST_NAME_SERVICE_INFRA_WITHDRAW_SW_UN_CONFIG_LOCAL = "ServiceInfraWithdrawSwUnConfigLocal"
	CONST_NAME_SERVICE_INFRA_WITHDRAW_SW_UN_CONFIG_PEER = "ServiceInfraWithdrawSwUnConfigPeer"
	CONST_NAME_SOFT_SHUTDOWN_BEGIN = "SoftShutdownBegin"
	CONST_NAME_SOFT_SHUTDOWN_EXECUTE = "SoftShutdownExecute"
	CONST_NAME_SOFT_SHUTDOWN_FAIL = "SoftShutdownFail"
	CONST_NAME_SOFT_SHUTDOWN_SUCCESS = "SoftShutdownSuccess"
	CONST_NAME_SOFTRESET_BEGIN = "SoftresetBegin"
	CONST_NAME_SOFTRESET_EXECUTE = "SoftresetExecute"
	CONST_NAME_SOFTRESET_FAIL = "SoftresetFail"
	CONST_NAME_SOFTRESET_PRE_SANITIZE = "SoftresetPreSanitize"
	CONST_NAME_SOFTRESET_SANITIZE = "SoftresetSanitize"
	CONST_NAME_SOFTRESET_SUCCESS = "SoftresetSuccess"
	CONST_NAME_SW_CONN_UPD_A = "SwConnUpdA"
	CONST_NAME_SW_CONN_UPD_B = "SwConnUpdB"
	CONST_NAME_SW_CONN_UPD_BEGIN = "SwConnUpdBegin"
	CONST_NAME_SW_CONN_UPD_FAIL = "SwConnUpdFail"
	CONST_NAME_SW_CONN_UPD_SUCCESS = "SwConnUpdSuccess"
	CONST_NAME_TURNUP_BEGIN = "TurnupBegin"
	CONST_NAME_TURNUP_EXECUTE = "TurnupExecute"
	CONST_NAME_TURNUP_FAIL = "TurnupFail"
	CONST_NAME_TURNUP_SUCCESS = "TurnupSuccess"
	CONST_NAME_UNCONFIG_SO_LBEGIN = "UnconfigSoLBegin"
	CONST_NAME_UNCONFIG_SO_LEXECUTE = "UnconfigSoLExecute"
	CONST_NAME_UNCONFIG_SO_LFAIL = "UnconfigSoLFail"
	CONST_NAME_UNCONFIG_SO_LSUCCESS = "UnconfigSoLSuccess"
	CONST_NAME_UPDATE_ADAPTOR_BEGIN = "UpdateAdaptorBegin"
	CONST_NAME_UPDATE_ADAPTOR_FAIL = "UpdateAdaptorFail"
	CONST_NAME_UPDATE_ADAPTOR_POLL_UPDATE_STATUS_LOCAL = "UpdateAdaptorPollUpdateStatusLocal"
	CONST_NAME_UPDATE_ADAPTOR_POLL_UPDATE_STATUS_PEER = "UpdateAdaptorPollUpdateStatusPeer"
	CONST_NAME_UPDATE_ADAPTOR_POWER_OFF = "UpdateAdaptorPowerOff"
	CONST_NAME_UPDATE_ADAPTOR_POWER_ON = "UpdateAdaptorPowerOn"
	CONST_NAME_UPDATE_ADAPTOR_SUCCESS = "UpdateAdaptorSuccess"
	CONST_NAME_UPDATE_ADAPTOR_UPDATE_REQUEST_LOCAL = "UpdateAdaptorUpdateRequestLocal"
	CONST_NAME_UPDATE_ADAPTOR_UPDATE_REQUEST_PEER = "UpdateAdaptorUpdateRequestPeer"
	CONST_NAME_UPDATE_BIOSBEGIN = "UpdateBIOSBegin"
	CONST_NAME_UPDATE_BIOSCLEAR = "UpdateBIOSClear"
	CONST_NAME_UPDATE_BIOSFAIL = "UpdateBIOSFail"
	CONST_NAME_UPDATE_BIOSPOLL_CLEAR_STATUS = "UpdateBIOSPollClearStatus"
	CONST_NAME_UPDATE_BIOSPOLL_UPDATE_STATUS = "UpdateBIOSPollUpdateStatus"
	CONST_NAME_UPDATE_BIOSSUCCESS = "UpdateBIOSSuccess"
	CONST_NAME_UPDATE_BIOSUPDATE_REQUEST = "UpdateBIOSUpdateRequest"
	CONST_NAME_UPDATE_BOARD_CONTROLLER_BEGIN = "UpdateBoardControllerBegin"
	CONST_NAME_UPDATE_BOARD_CONTROLLER_FAIL = "UpdateBoardControllerFail"
	CONST_NAME_UPDATE_BOARD_CONTROLLER_POLL_UPDATE_STATUS = "UpdateBoardControllerPollUpdateStatus"
	CONST_NAME_UPDATE_BOARD_CONTROLLER_PREPARE_FOR_UPDATE = "UpdateBoardControllerPrepareForUpdate"
	CONST_NAME_UPDATE_BOARD_CONTROLLER_SERVER_POWER_OFF = "UpdateBoardControllerServerPowerOff"
	CONST_NAME_UPDATE_BOARD_CONTROLLER_SERVER_POWER_ON = "UpdateBoardControllerServerPowerOn"
	CONST_NAME_UPDATE_BOARD_CONTROLLER_SUCCESS = "UpdateBoardControllerSuccess"
	CONST_NAME_UPDATE_BOARD_CONTROLLER_UPDATE_REQUEST = "UpdateBoardControllerUpdateRequest"
	CONST_NAME_NOP = "nop"
	CONST_NAME_UPDATE_EXT_USERS_BEGIN = "updateExtUsersBegin"
	CONST_NAME_UPDATE_EXT_USERS_DEPLOY = "updateExtUsersDeploy"
	CONST_NAME_UPDATE_EXT_USERS_FAIL = "updateExtUsersFail"
	CONST_NAME_UPDATE_EXT_USERS_SUCCESS = "updateExtUsersSuccess"
	CONST_STAGE_STATUS_FAIL = "fail"
	CONST_STAGE_STATUS_IN_PROGRESS = "inProgress"
	CONST_STAGE_STATUS_NOP = "nop"
	CONST_STAGE_STATUS_PENDING = "pending"
	CONST_STAGE_STATUS_SKIP = "skip"
	CONST_STAGE_STATUS_SUCCESS = "success"
	CONST_STAGE_STATUS_THROTTLED = "throttled"

class StorageLocalDisk(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"StorageLocalDisk")

	@staticmethod
	def ClassId():
		return "storageLocalDisk"

	BLOCK_SIZE = "BlockSize"
	CONNECTION_PROTOCOL = "ConnectionProtocol"
	DEVICE_TYPE = "DeviceType"
	DISK_STATE = "DiskState"
	DN = "Dn"
	ID = "Id"
	LC = "Lc"
	LINK_SPEED = "LinkSpeed"
	MODEL = "Model"
	NUMBER_OF_BLOCKS = "NumberOfBlocks"
	OPER_QUALIFIER_REASON = "OperQualifierReason"
	OPERABILITY = "Operability"
	POWER_STATE = "PowerState"
	PRESENCE = "Presence"
	REVISION = "Revision"
	RN = "Rn"
	SERIAL = "Serial"
	SIZE = "Size"
	STATUS = "Status"
	VENDOR = "Vendor"

	CONST_BLOCK_SIZE_UNKNOWN = "unknown"
	CONST_CONNECTION_PROTOCOL_SAS = "SAS"
	CONST_CONNECTION_PROTOCOL_SATA = "SATA"
	CONST_CONNECTION_PROTOCOL_UNSPECIFIED = "unspecified"
	CONST_DEVICE_TYPE_HDD = "HDD"
	CONST_DEVICE_TYPE_SSD = "SSD"
	CONST_DEVICE_TYPE_UNSPECIFIED = "unspecified"
	CONST_DISK_STATE_COPYBACK = "copyback"
	CONST_DISK_STATE_DEDICATED_HOT_SPARE = "dedicated-hot-spare"
	CONST_DISK_STATE_DISABLED_FOR_REMOVAL = "disabled-for-removal"
	CONST_DISK_STATE_FAILED = "failed"
	CONST_DISK_STATE_FOREIGN_CONFIGURATION = "foreign-configuration"
	CONST_DISK_STATE_GLOBAL_HOT_SPARE = "global-hot-spare"
	CONST_DISK_STATE_JBOD = "jbod"
	CONST_DISK_STATE_OFFLINE = "offline"
	CONST_DISK_STATE_ONLINE = "online"
	CONST_DISK_STATE_PREDICTIVE_FAILURE = "predictive-failure"
	CONST_DISK_STATE_REBUILDING = "rebuilding"
	CONST_DISK_STATE_UNCONFIGURED_BAD = "unconfigured-bad"
	CONST_DISK_STATE_UNCONFIGURED_GOOD = "unconfigured-good"
	CONST_DISK_STATE_UNKNOWN = "unknown"
	CONST_LC_ALLOCATED = "allocated"
	CONST_LC_AVAILABLE = "available"
	CONST_LC_DEALLOCATED = "deallocated"
	CONST_LC_REPURPOSED = "repurposed"
	CONST_LINK_SPEED_1_5_GBPS = "1-5-gbps"
	CONST_LINK_SPEED_12_GBPS = "12-gbps"
	CONST_LINK_SPEED_3_GBPS = "3-gbps"
	CONST_LINK_SPEED_6_GBPS = "6-gbps"
	CONST_LINK_SPEED_UNKNOWN = "unknown"
	CONST_NUMBER_OF_BLOCKS_UNKNOWN = "unknown"
	CONST_OPERABILITY_ACCESSIBILITY_PROBLEM = "accessibility-problem"
	CONST_OPERABILITY_AUTO_UPGRADE = "auto-upgrade"
	CONST_OPERABILITY_BIOS_POST_TIMEOUT = "bios-post-timeout"
	CONST_OPERABILITY_CHASSIS_LIMIT_EXCEEDED = "chassis-limit-exceeded"
	CONST_OPERABILITY_CONFIG = "config"
	CONST_OPERABILITY_DECOMISSIONING = "decomissioning"
	CONST_OPERABILITY_DEGRADED = "degraded"
	CONST_OPERABILITY_DISABLED = "disabled"
	CONST_OPERABILITY_DISCOVERY = "discovery"
	CONST_OPERABILITY_DISCOVERY_FAILED = "discovery-failed"
	CONST_OPERABILITY_EQUIPMENT_PROBLEM = "equipment-problem"
	CONST_OPERABILITY_FABRIC_CONN_PROBLEM = "fabric-conn-problem"
	CONST_OPERABILITY_FABRIC_UNSUPPORTED_CONN = "fabric-unsupported-conn"
	CONST_OPERABILITY_IDENTIFY = "identify"
	CONST_OPERABILITY_IDENTITY_UNESTABLISHABLE = "identity-unestablishable"
	CONST_OPERABILITY_INOPERABLE = "inoperable"
	CONST_OPERABILITY_LINK_ACTIVATE_BLOCKED = "link-activate-blocked"
	CONST_OPERABILITY_MALFORMED_FRU = "malformed-fru"
	CONST_OPERABILITY_NOT_SUPPORTED = "not-supported"
	CONST_OPERABILITY_OPERABLE = "operable"
	CONST_OPERABILITY_PEER_COMM_PROBLEM = "peer-comm-problem"
	CONST_OPERABILITY_PERFORMANCE_PROBLEM = "performance-problem"
	CONST_OPERABILITY_POST_FAILURE = "post-failure"
	CONST_OPERABILITY_POWER_PROBLEM = "power-problem"
	CONST_OPERABILITY_POWERED_OFF = "powered-off"
	CONST_OPERABILITY_REMOVED = "removed"
	CONST_OPERABILITY_THERMAL_PROBLEM = "thermal-problem"
	CONST_OPERABILITY_UNKNOWN = "unknown"
	CONST_OPERABILITY_UPGRADE_PROBLEM = "upgrade-problem"
	CONST_OPERABILITY_VOLTAGE_PROBLEM = "voltage-problem"
	CONST_POWER_STATE_ACTIVE = "active"
	CONST_POWER_STATE_POWERSAVE = "powersave"
	CONST_POWER_STATE_TRANSITIONING = "transitioning"
	CONST_POWER_STATE_UNKNOWN = "unknown"
	CONST_PRESENCE_EMPTY = "empty"
	CONST_PRESENCE_EQUIPPED = "equipped"
	CONST_PRESENCE_EQUIPPED_IDENTITY_UNESTABLISHABLE = "equipped-identity-unestablishable"
	CONST_PRESENCE_EQUIPPED_NOT_PRIMARY = "equipped-not-primary"
	CONST_PRESENCE_EQUIPPED_WITH_MALFORMED_FRU = "equipped-with-malformed-fru"
	CONST_PRESENCE_INACCESSIBLE = "inaccessible"
	CONST_PRESENCE_MISMATCH = "mismatch"
	CONST_PRESENCE_MISMATCH_IDENTITY_UNESTABLISHABLE = "mismatch-identity-unestablishable"
	CONST_PRESENCE_MISSING = "missing"
	CONST_PRESENCE_NOT_SUPPORTED = "not-supported"
	CONST_PRESENCE_UNAUTHORIZED = "unauthorized"
	CONST_PRESENCE_UNKNOWN = "unknown"
	CONST_SIZE_UNKNOWN = "unknown"

class VmHv(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"VmHv")

	@staticmethod
	def ClassId():
		return "vmHv"

	CL_INST_TYPE = "ClInstType"
	DESCR = "Descr"
	DN = "Dn"
	DVS_DN = "DvsDn"
	DVS_NAME = "DvsName"
	HV_TYPE = "HvType"
	LS_DN = "LsDn"
	MODEL = "Model"
	NAME = "Name"
	PN_DN = "PnDn"
	POLICY_LEVEL = "PolicyLevel"
	POLICY_OWNER = "PolicyOwner"
	RN = "Rn"
	STATUS = "Status"
	STATUS_CHANGE_TS = "StatusChangeTs"
	UUID = "Uuid"
	V_STATUS = "VStatus"
	VENDOR = "Vendor"

	CONST_CL_INST_TYPE_COMPUTE_EP = "compute-ep"
	CONST_CL_INST_TYPE_HV = "hv"
	CONST_CL_INST_TYPE_VM = "vm"
	CONST_HV_TYPE_ESX = "esx"
	CONST_HV_TYPE_HYPERV = "hyperv"
	CONST_HV_TYPE_KVM = "kvm"
	CONST_HV_TYPE_UNSPECIFIED = "unspecified"
	CONST_HV_TYPE_XEN = "xen"
	CONST_INT_ID_NONE = "none"
	CONST_MODEL_LINUX = "Linux"
	CONST_MODEL_PNU_OS = "PnuOS"
	CONST_MODEL_SOLARIS = "Solaris"
	CONST_MODEL_VMWARE_ESX = "VMWareESX"
	CONST_MODEL_WINDOWS = "Windows"
	CONST_MODEL_UNSPECIFIED = "unspecified"
	CONST_POLICY_OWNER_LOCAL = "local"
	CONST_POLICY_OWNER_PENDING_POLICY = "pending-policy"
	CONST_POLICY_OWNER_POLICY = "policy"
	CONST_V_STATUS_OFFLINE = "offline"
	CONST_V_STATUS_ONLINE = "online"
	CONST_V_STATUS_UNKNOWN = "unknown"
	CONST_VENDOR_CITRIX = "citrix"
	CONST_VENDOR_MICROSOFT = "microsoft"
	CONST_VENDOR_NOVELL = "novell"
	CONST_VENDOR_ORACLE = "oracle"
	CONST_VENDOR_REDHAT = "redhat"
	CONST_VENDOR_UNSPECIFIED = "unspecified"
	CONST_VENDOR_VMWARE = "vmware"

class StorageLocalDiskPartition(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"StorageLocalDiskPartition")

	@staticmethod
	def ClassId():
		return "storageLocalDiskPartition"

	DESCR = "Descr"
	DN = "Dn"
	NAME = "Name"
	ORDER = "Order"
	POLICY_LEVEL = "PolicyLevel"
	POLICY_OWNER = "PolicyOwner"
	RN = "Rn"
	SIZE = "Size"
	STATUS = "Status"
	TYPE = "Type"

	CONST_INT_ID_NONE = "none"
	CONST_ORDER_UNSPECIFIED = "unspecified"
	CONST_POLICY_OWNER_LOCAL = "local"
	CONST_POLICY_OWNER_PENDING_POLICY = "pending-policy"
	CONST_POLICY_OWNER_POLICY = "policy"
	CONST_SIZE_UNKNOWN = "unknown"
	CONST_TYPE_EXT2 = "ext2"
	CONST_TYPE_EXT3 = "ext3"
	CONST_TYPE_FAT32 = "fat32"
	CONST_TYPE_NONE = "none"
	CONST_TYPE_NTFS = "ntfs"
	CONST_TYPE_SWAP = "swap"

class MemoryBufferUnit(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"MemoryBufferUnit")

	@staticmethod
	def ClassId():
		return "memoryBufferUnit"

	DN = "Dn"
	ID = "Id"
	MODEL = "Model"
	OPER_QUALIFIER_REASON = "OperQualifierReason"
	OPER_STATE = "OperState"
	OPERABILITY = "Operability"
	PERF = "Perf"
	POWER = "Power"
	PRESENCE = "Presence"
	REVISION = "Revision"
	RN = "Rn"
	SERIAL = "Serial"
	STATUS = "Status"
	THERMAL = "Thermal"
	VENDOR = "Vendor"
	VOLTAGE = "Voltage"

	CONST_OPER_STATE_ACCESSIBILITY_PROBLEM = "accessibility-problem"
	CONST_OPER_STATE_AUTO_UPGRADE = "auto-upgrade"
	CONST_OPER_STATE_BIOS_POST_TIMEOUT = "bios-post-timeout"
	CONST_OPER_STATE_CHASSIS_LIMIT_EXCEEDED = "chassis-limit-exceeded"
	CONST_OPER_STATE_CONFIG = "config"
	CONST_OPER_STATE_DECOMISSIONING = "decomissioning"
	CONST_OPER_STATE_DEGRADED = "degraded"
	CONST_OPER_STATE_DISABLED = "disabled"
	CONST_OPER_STATE_DISCOVERY = "discovery"
	CONST_OPER_STATE_DISCOVERY_FAILED = "discovery-failed"
	CONST_OPER_STATE_EQUIPMENT_PROBLEM = "equipment-problem"
	CONST_OPER_STATE_FABRIC_CONN_PROBLEM = "fabric-conn-problem"
	CONST_OPER_STATE_FABRIC_UNSUPPORTED_CONN = "fabric-unsupported-conn"
	CONST_OPER_STATE_IDENTIFY = "identify"
	CONST_OPER_STATE_IDENTITY_UNESTABLISHABLE = "identity-unestablishable"
	CONST_OPER_STATE_INOPERABLE = "inoperable"
	CONST_OPER_STATE_LINK_ACTIVATE_BLOCKED = "link-activate-blocked"
	CONST_OPER_STATE_MALFORMED_FRU = "malformed-fru"
	CONST_OPER_STATE_NOT_SUPPORTED = "not-supported"
	CONST_OPER_STATE_OPERABLE = "operable"
	CONST_OPER_STATE_PEER_COMM_PROBLEM = "peer-comm-problem"
	CONST_OPER_STATE_PERFORMANCE_PROBLEM = "performance-problem"
	CONST_OPER_STATE_POST_FAILURE = "post-failure"
	CONST_OPER_STATE_POWER_PROBLEM = "power-problem"
	CONST_OPER_STATE_POWERED_OFF = "powered-off"
	CONST_OPER_STATE_REMOVED = "removed"
	CONST_OPER_STATE_THERMAL_PROBLEM = "thermal-problem"
	CONST_OPER_STATE_UNKNOWN = "unknown"
	CONST_OPER_STATE_UPGRADE_PROBLEM = "upgrade-problem"
	CONST_OPER_STATE_VOLTAGE_PROBLEM = "voltage-problem"
	CONST_OPERABILITY_ACCESSIBILITY_PROBLEM = "accessibility-problem"
	CONST_OPERABILITY_AUTO_UPGRADE = "auto-upgrade"
	CONST_OPERABILITY_BIOS_POST_TIMEOUT = "bios-post-timeout"
	CONST_OPERABILITY_CHASSIS_LIMIT_EXCEEDED = "chassis-limit-exceeded"
	CONST_OPERABILITY_CONFIG = "config"
	CONST_OPERABILITY_DECOMISSIONING = "decomissioning"
	CONST_OPERABILITY_DEGRADED = "degraded"
	CONST_OPERABILITY_DISABLED = "disabled"
	CONST_OPERABILITY_DISCOVERY = "discovery"
	CONST_OPERABILITY_DISCOVERY_FAILED = "discovery-failed"
	CONST_OPERABILITY_EQUIPMENT_PROBLEM = "equipment-problem"
	CONST_OPERABILITY_FABRIC_CONN_PROBLEM = "fabric-conn-problem"
	CONST_OPERABILITY_FABRIC_UNSUPPORTED_CONN = "fabric-unsupported-conn"
	CONST_OPERABILITY_IDENTIFY = "identify"
	CONST_OPERABILITY_IDENTITY_UNESTABLISHABLE = "identity-unestablishable"
	CONST_OPERABILITY_INOPERABLE = "inoperable"
	CONST_OPERABILITY_LINK_ACTIVATE_BLOCKED = "link-activate-blocked"
	CONST_OPERABILITY_MALFORMED_FRU = "malformed-fru"
	CONST_OPERABILITY_NOT_SUPPORTED = "not-supported"
	CONST_OPERABILITY_OPERABLE = "operable"
	CONST_OPERABILITY_PEER_COMM_PROBLEM = "peer-comm-problem"
	CONST_OPERABILITY_PERFORMANCE_PROBLEM = "performance-problem"
	CONST_OPERABILITY_POST_FAILURE = "post-failure"
	CONST_OPERABILITY_POWER_PROBLEM = "power-problem"
	CONST_OPERABILITY_POWERED_OFF = "powered-off"
	CONST_OPERABILITY_REMOVED = "removed"
	CONST_OPERABILITY_THERMAL_PROBLEM = "thermal-problem"
	CONST_OPERABILITY_UNKNOWN = "unknown"
	CONST_OPERABILITY_UPGRADE_PROBLEM = "upgrade-problem"
	CONST_OPERABILITY_VOLTAGE_PROBLEM = "voltage-problem"
	CONST_PERF_LOWER_CRITICAL = "lower-critical"
	CONST_PERF_LOWER_NON_CRITICAL = "lower-non-critical"
	CONST_PERF_LOWER_NON_RECOVERABLE = "lower-non-recoverable"
	CONST_PERF_NOT_SUPPORTED = "not-supported"
	CONST_PERF_OK = "ok"
	CONST_PERF_UNKNOWN = "unknown"
	CONST_PERF_UPPER_CRITICAL = "upper-critical"
	CONST_PERF_UPPER_NON_CRITICAL = "upper-non-critical"
	CONST_PERF_UPPER_NON_RECOVERABLE = "upper-non-recoverable"
	CONST_POWER_DEGRADED = "degraded"
	CONST_POWER_ERROR = "error"
	CONST_POWER_FAILED = "failed"
	CONST_POWER_NOT_SUPPORTED = "not-supported"
	CONST_POWER_OFF = "off"
	CONST_POWER_OFFDUTY = "offduty"
	CONST_POWER_OFFLINE = "offline"
	CONST_POWER_OK = "ok"
	CONST_POWER_ON = "on"
	CONST_POWER_ONLINE = "online"
	CONST_POWER_POWER_SAVE = "power-save"
	CONST_POWER_TEST = "test"
	CONST_POWER_UNKNOWN = "unknown"
	CONST_PRESENCE_EMPTY = "empty"
	CONST_PRESENCE_EQUIPPED = "equipped"
	CONST_PRESENCE_EQUIPPED_IDENTITY_UNESTABLISHABLE = "equipped-identity-unestablishable"
	CONST_PRESENCE_EQUIPPED_NOT_PRIMARY = "equipped-not-primary"
	CONST_PRESENCE_EQUIPPED_WITH_MALFORMED_FRU = "equipped-with-malformed-fru"
	CONST_PRESENCE_INACCESSIBLE = "inaccessible"
	CONST_PRESENCE_MISMATCH = "mismatch"
	CONST_PRESENCE_MISMATCH_IDENTITY_UNESTABLISHABLE = "mismatch-identity-unestablishable"
	CONST_PRESENCE_MISSING = "missing"
	CONST_PRESENCE_NOT_SUPPORTED = "not-supported"
	CONST_PRESENCE_UNAUTHORIZED = "unauthorized"
	CONST_PRESENCE_UNKNOWN = "unknown"
	CONST_THERMAL_LOWER_CRITICAL = "lower-critical"
	CONST_THERMAL_LOWER_NON_CRITICAL = "lower-non-critical"
	CONST_THERMAL_LOWER_NON_RECOVERABLE = "lower-non-recoverable"
	CONST_THERMAL_NOT_SUPPORTED = "not-supported"
	CONST_THERMAL_OK = "ok"
	CONST_THERMAL_UNKNOWN = "unknown"
	CONST_THERMAL_UPPER_CRITICAL = "upper-critical"
	CONST_THERMAL_UPPER_NON_CRITICAL = "upper-non-critical"
	CONST_THERMAL_UPPER_NON_RECOVERABLE = "upper-non-recoverable"
	CONST_VOLTAGE_LOWER_CRITICAL = "lower-critical"
	CONST_VOLTAGE_LOWER_NON_CRITICAL = "lower-non-critical"
	CONST_VOLTAGE_LOWER_NON_RECOVERABLE = "lower-non-recoverable"
	CONST_VOLTAGE_NOT_SUPPORTED = "not-supported"
	CONST_VOLTAGE_OK = "ok"
	CONST_VOLTAGE_UNKNOWN = "unknown"
	CONST_VOLTAGE_UPPER_CRITICAL = "upper-critical"
	CONST_VOLTAGE_UPPER_NON_CRITICAL = "upper-non-critical"
	CONST_VOLTAGE_UPPER_NON_RECOVERABLE = "upper-non-recoverable"

class MgmtAccessPolicyItem(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"MgmtAccessPolicyItem")

	@staticmethod
	def ClassId():
		return "mgmtAccessPolicyItem"

	DESCR = "Descr"
	DN = "Dn"
	IP_POOL_NAME = "IpPoolName"
	NAME = "Name"
	POLICY_LEVEL = "PolicyLevel"
	POLICY_OWNER = "PolicyOwner"
	RN = "Rn"
	STATUS = "Status"
	SUBJECT = "Subject"

	CONST_INT_ID_NONE = "none"
	CONST_POLICY_OWNER_LOCAL = "local"
	CONST_POLICY_OWNER_PENDING_POLICY = "pending-policy"
	CONST_POLICY_OWNER_POLICY = "policy"
	CONST_SUBJECT_ADAPTOR = "adaptor"
	CONST_SUBJECT_BLADE = "blade"
	CONST_SUBJECT_BOARD_CONTROLLER = "board-controller"
	CONST_SUBJECT_CHASSIS = "chassis"
	CONST_SUBJECT_IOCARD = "iocard"
	CONST_SUBJECT_SWITCH = "switch"
	CONST_SUBJECT_SYSTEM = "system"
	CONST_SUBJECT_UNKNOWN = "unknown"

class BiosVfAssertNMIOnSERR(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"BiosVfAssertNMIOnSERR")

	@staticmethod
	def ClassId():
		return "biosVfAssertNMIOnSERR"

	DN = "Dn"
	RN = "Rn"
	STATUS = "Status"
	VP_ASSERT_NMION_SERR = "VpAssertNMIOnSERR"

	CONST_VP_ASSERT_NMION_SERR_DISABLED = "disabled"
	CONST_VP_ASSERT_NMION_SERR_ENABLED = "enabled"
	CONST_VP_ASSERT_NMION_SERR_PLATFORM_DEFAULT = "platform-default"
	CONST_VP_ASSERT_NMION_SERR_PLATFORM_RECOMMENDED = "platform-recommended"

class ComputeBoard(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"ComputeBoard")

	@staticmethod
	def ClassId():
		return "computeBoard"

	CMOS_VOLTAGE = "CmosVoltage"
	DN = "Dn"
	ID = "Id"
	MODEL = "Model"
	OPER_POWER = "OperPower"
	OPER_QUALIFIER_REASON = "OperQualifierReason"
	OPER_STATE = "OperState"
	OPERABILITY = "Operability"
	PERF = "Perf"
	POWER = "Power"
	POWER_USAGE = "PowerUsage"
	PRESENCE = "Presence"
	REVISION = "Revision"
	RN = "Rn"
	SERIAL = "Serial"
	STATUS = "Status"
	THERMAL = "Thermal"
	VENDOR = "Vendor"
	VOLTAGE = "Voltage"

	CONST_CMOS_VOLTAGE_LOWER_CRITICAL = "lower-critical"
	CONST_CMOS_VOLTAGE_LOWER_NON_CRITICAL = "lower-non-critical"
	CONST_CMOS_VOLTAGE_LOWER_NON_RECOVERABLE = "lower-non-recoverable"
	CONST_CMOS_VOLTAGE_NOT_SUPPORTED = "not-supported"
	CONST_CMOS_VOLTAGE_OK = "ok"
	CONST_CMOS_VOLTAGE_UNKNOWN = "unknown"
	CONST_CMOS_VOLTAGE_UPPER_CRITICAL = "upper-critical"
	CONST_CMOS_VOLTAGE_UPPER_NON_CRITICAL = "upper-non-critical"
	CONST_CMOS_VOLTAGE_UPPER_NON_RECOVERABLE = "upper-non-recoverable"
	CONST_OPER_POWER_DEGRADED = "degraded"
	CONST_OPER_POWER_ERROR = "error"
	CONST_OPER_POWER_FAILED = "failed"
	CONST_OPER_POWER_NOT_SUPPORTED = "not-supported"
	CONST_OPER_POWER_OFF = "off"
	CONST_OPER_POWER_OFFDUTY = "offduty"
	CONST_OPER_POWER_OFFLINE = "offline"
	CONST_OPER_POWER_OK = "ok"
	CONST_OPER_POWER_ON = "on"
	CONST_OPER_POWER_ONLINE = "online"
	CONST_OPER_POWER_POWER_SAVE = "power-save"
	CONST_OPER_POWER_TEST = "test"
	CONST_OPER_POWER_UNKNOWN = "unknown"
	CONST_OPER_STATE_ACCESSIBILITY_PROBLEM = "accessibility-problem"
	CONST_OPER_STATE_AUTO_UPGRADE = "auto-upgrade"
	CONST_OPER_STATE_BIOS_POST_TIMEOUT = "bios-post-timeout"
	CONST_OPER_STATE_CHASSIS_LIMIT_EXCEEDED = "chassis-limit-exceeded"
	CONST_OPER_STATE_CONFIG = "config"
	CONST_OPER_STATE_DECOMISSIONING = "decomissioning"
	CONST_OPER_STATE_DEGRADED = "degraded"
	CONST_OPER_STATE_DISABLED = "disabled"
	CONST_OPER_STATE_DISCOVERY = "discovery"
	CONST_OPER_STATE_DISCOVERY_FAILED = "discovery-failed"
	CONST_OPER_STATE_EQUIPMENT_PROBLEM = "equipment-problem"
	CONST_OPER_STATE_FABRIC_CONN_PROBLEM = "fabric-conn-problem"
	CONST_OPER_STATE_FABRIC_UNSUPPORTED_CONN = "fabric-unsupported-conn"
	CONST_OPER_STATE_IDENTIFY = "identify"
	CONST_OPER_STATE_IDENTITY_UNESTABLISHABLE = "identity-unestablishable"
	CONST_OPER_STATE_INOPERABLE = "inoperable"
	CONST_OPER_STATE_LINK_ACTIVATE_BLOCKED = "link-activate-blocked"
	CONST_OPER_STATE_MALFORMED_FRU = "malformed-fru"
	CONST_OPER_STATE_NOT_SUPPORTED = "not-supported"
	CONST_OPER_STATE_OPERABLE = "operable"
	CONST_OPER_STATE_PEER_COMM_PROBLEM = "peer-comm-problem"
	CONST_OPER_STATE_PERFORMANCE_PROBLEM = "performance-problem"
	CONST_OPER_STATE_POST_FAILURE = "post-failure"
	CONST_OPER_STATE_POWER_PROBLEM = "power-problem"
	CONST_OPER_STATE_POWERED_OFF = "powered-off"
	CONST_OPER_STATE_REMOVED = "removed"
	CONST_OPER_STATE_THERMAL_PROBLEM = "thermal-problem"
	CONST_OPER_STATE_UNKNOWN = "unknown"
	CONST_OPER_STATE_UPGRADE_PROBLEM = "upgrade-problem"
	CONST_OPER_STATE_VOLTAGE_PROBLEM = "voltage-problem"
	CONST_OPERABILITY_ACCESSIBILITY_PROBLEM = "accessibility-problem"
	CONST_OPERABILITY_AUTO_UPGRADE = "auto-upgrade"
	CONST_OPERABILITY_BIOS_POST_TIMEOUT = "bios-post-timeout"
	CONST_OPERABILITY_CHASSIS_LIMIT_EXCEEDED = "chassis-limit-exceeded"
	CONST_OPERABILITY_CONFIG = "config"
	CONST_OPERABILITY_DECOMISSIONING = "decomissioning"
	CONST_OPERABILITY_DEGRADED = "degraded"
	CONST_OPERABILITY_DISABLED = "disabled"
	CONST_OPERABILITY_DISCOVERY = "discovery"
	CONST_OPERABILITY_DISCOVERY_FAILED = "discovery-failed"
	CONST_OPERABILITY_EQUIPMENT_PROBLEM = "equipment-problem"
	CONST_OPERABILITY_FABRIC_CONN_PROBLEM = "fabric-conn-problem"
	CONST_OPERABILITY_FABRIC_UNSUPPORTED_CONN = "fabric-unsupported-conn"
	CONST_OPERABILITY_IDENTIFY = "identify"
	CONST_OPERABILITY_IDENTITY_UNESTABLISHABLE = "identity-unestablishable"
	CONST_OPERABILITY_INOPERABLE = "inoperable"
	CONST_OPERABILITY_LINK_ACTIVATE_BLOCKED = "link-activate-blocked"
	CONST_OPERABILITY_MALFORMED_FRU = "malformed-fru"
	CONST_OPERABILITY_NOT_SUPPORTED = "not-supported"
	CONST_OPERABILITY_OPERABLE = "operable"
	CONST_OPERABILITY_PEER_COMM_PROBLEM = "peer-comm-problem"
	CONST_OPERABILITY_PERFORMANCE_PROBLEM = "performance-problem"
	CONST_OPERABILITY_POST_FAILURE = "post-failure"
	CONST_OPERABILITY_POWER_PROBLEM = "power-problem"
	CONST_OPERABILITY_POWERED_OFF = "powered-off"
	CONST_OPERABILITY_REMOVED = "removed"
	CONST_OPERABILITY_THERMAL_PROBLEM = "thermal-problem"
	CONST_OPERABILITY_UNKNOWN = "unknown"
	CONST_OPERABILITY_UPGRADE_PROBLEM = "upgrade-problem"
	CONST_OPERABILITY_VOLTAGE_PROBLEM = "voltage-problem"
	CONST_PERF_LOWER_CRITICAL = "lower-critical"
	CONST_PERF_LOWER_NON_CRITICAL = "lower-non-critical"
	CONST_PERF_LOWER_NON_RECOVERABLE = "lower-non-recoverable"
	CONST_PERF_NOT_SUPPORTED = "not-supported"
	CONST_PERF_OK = "ok"
	CONST_PERF_UNKNOWN = "unknown"
	CONST_PERF_UPPER_CRITICAL = "upper-critical"
	CONST_PERF_UPPER_NON_CRITICAL = "upper-non-critical"
	CONST_PERF_UPPER_NON_RECOVERABLE = "upper-non-recoverable"
	CONST_POWER_DEGRADED = "degraded"
	CONST_POWER_ERROR = "error"
	CONST_POWER_FAILED = "failed"
	CONST_POWER_NOT_SUPPORTED = "not-supported"
	CONST_POWER_OFF = "off"
	CONST_POWER_OFFDUTY = "offduty"
	CONST_POWER_OFFLINE = "offline"
	CONST_POWER_OK = "ok"
	CONST_POWER_ON = "on"
	CONST_POWER_ONLINE = "online"
	CONST_POWER_POWER_SAVE = "power-save"
	CONST_POWER_TEST = "test"
	CONST_POWER_UNKNOWN = "unknown"
	CONST_POWER_USAGE_LOWER_CRITICAL = "lower-critical"
	CONST_POWER_USAGE_LOWER_NON_CRITICAL = "lower-non-critical"
	CONST_POWER_USAGE_LOWER_NON_RECOVERABLE = "lower-non-recoverable"
	CONST_POWER_USAGE_NOT_SUPPORTED = "not-supported"
	CONST_POWER_USAGE_OK = "ok"
	CONST_POWER_USAGE_UNKNOWN = "unknown"
	CONST_POWER_USAGE_UPPER_CRITICAL = "upper-critical"
	CONST_POWER_USAGE_UPPER_NON_CRITICAL = "upper-non-critical"
	CONST_POWER_USAGE_UPPER_NON_RECOVERABLE = "upper-non-recoverable"
	CONST_PRESENCE_EMPTY = "empty"
	CONST_PRESENCE_EQUIPPED = "equipped"
	CONST_PRESENCE_EQUIPPED_IDENTITY_UNESTABLISHABLE = "equipped-identity-unestablishable"
	CONST_PRESENCE_EQUIPPED_NOT_PRIMARY = "equipped-not-primary"
	CONST_PRESENCE_EQUIPPED_WITH_MALFORMED_FRU = "equipped-with-malformed-fru"
	CONST_PRESENCE_INACCESSIBLE = "inaccessible"
	CONST_PRESENCE_MISMATCH = "mismatch"
	CONST_PRESENCE_MISMATCH_IDENTITY_UNESTABLISHABLE = "mismatch-identity-unestablishable"
	CONST_PRESENCE_MISSING = "missing"
	CONST_PRESENCE_NOT_SUPPORTED = "not-supported"
	CONST_PRESENCE_UNAUTHORIZED = "unauthorized"
	CONST_PRESENCE_UNKNOWN = "unknown"
	CONST_THERMAL_LOWER_CRITICAL = "lower-critical"
	CONST_THERMAL_LOWER_NON_CRITICAL = "lower-non-critical"
	CONST_THERMAL_LOWER_NON_RECOVERABLE = "lower-non-recoverable"
	CONST_THERMAL_NOT_SUPPORTED = "not-supported"
	CONST_THERMAL_OK = "ok"
	CONST_THERMAL_UNKNOWN = "unknown"
	CONST_THERMAL_UPPER_CRITICAL = "upper-critical"
	CONST_THERMAL_UPPER_NON_CRITICAL = "upper-non-critical"
	CONST_THERMAL_UPPER_NON_RECOVERABLE = "upper-non-recoverable"
	CONST_VOLTAGE_LOWER_CRITICAL = "lower-critical"
	CONST_VOLTAGE_LOWER_NON_CRITICAL = "lower-non-critical"
	CONST_VOLTAGE_LOWER_NON_RECOVERABLE = "lower-non-recoverable"
	CONST_VOLTAGE_NOT_SUPPORTED = "not-supported"
	CONST_VOLTAGE_OK = "ok"
	CONST_VOLTAGE_UNKNOWN = "unknown"
	CONST_VOLTAGE_UPPER_CRITICAL = "upper-critical"
	CONST_VOLTAGE_UPPER_NON_CRITICAL = "upper-non-critical"
	CONST_VOLTAGE_UPPER_NON_RECOVERABLE = "upper-non-recoverable"

class VnicMacHistory(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"VnicMacHistory")

	@staticmethod
	def ClassId():
		return "vnicMacHistory"

	DN = "Dn"
	OLDADDR = "Oldaddr"
	RN = "Rn"
	STATUS = "Status"


class ComputePhysicalFsm(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"ComputePhysicalFsm")

	@staticmethod
	def ClassId():
		return "computePhysicalFsm"

	COMPLETION_TIME = "CompletionTime"
	CURRENT_FSM = "CurrentFsm"
	DESCR = "Descr"
	DN = "Dn"
	INSTANCE_ID = "InstanceId"
	PROGRESS = "Progress"
	RMT_ERR_CODE = "RmtErrCode"
	RMT_ERR_DESCR = "RmtErrDescr"
	RMT_RSLT = "RmtRslt"
	RN = "Rn"
	STATUS = "Status"

	CONST_COMPLETION_TIME_ = ""
	CONST_CURRENT_FSM_ACTIVATE_ADAPTOR = "ActivateAdaptor"
	CONST_CURRENT_FSM_ACTIVATE_BIOS = "ActivateBIOS"
	CONST_CURRENT_FSM_ASSOCIATE = "Associate"
	CONST_CURRENT_FSM_BIOS_RECOVERY = "BiosRecovery"
	CONST_CURRENT_FSM_CIMC_SESSION_DELETE = "CimcSessionDelete"
	CONST_CURRENT_FSM_CMOS_RESET = "CmosReset"
	CONST_CURRENT_FSM_CONFIG_BOARD = "ConfigBoard"
	CONST_CURRENT_FSM_CONFIG_SO_L = "ConfigSoL"
	CONST_CURRENT_FSM_DECOMMISSION = "Decommission"
	CONST_CURRENT_FSM_DIAGNOSTIC_INTERRUPT = "DiagnosticInterrupt"
	CONST_CURRENT_FSM_DISASSOCIATE = "Disassociate"
	CONST_CURRENT_FSM_FW_UPGRADE = "FwUpgrade"
	CONST_CURRENT_FSM_HARD_SHUTDOWN = "HardShutdown"
	CONST_CURRENT_FSM_HARDRESET = "Hardreset"
	CONST_CURRENT_FSM_POWER_CAP = "PowerCap"
	CONST_CURRENT_FSM_POWERCYCLE = "Powercycle"
	CONST_CURRENT_FSM_RESET_BMC = "ResetBmc"
	CONST_CURRENT_FSM_RESET_IPMI = "ResetIpmi"
	CONST_CURRENT_FSM_RESET_KVM = "ResetKvm"
	CONST_CURRENT_FSM_RESET_MEMORY_ERRORS = "ResetMemoryErrors"
	CONST_CURRENT_FSM_SERVICE_INFRA_DEPLOY = "ServiceInfraDeploy"
	CONST_CURRENT_FSM_SERVICE_INFRA_WITHDRAW = "ServiceInfraWithdraw"
	CONST_CURRENT_FSM_SOFT_SHUTDOWN = "SoftShutdown"
	CONST_CURRENT_FSM_SOFTRESET = "Softreset"
	CONST_CURRENT_FSM_SW_CONN_UPD = "SwConnUpd"
	CONST_CURRENT_FSM_TURNUP = "Turnup"
	CONST_CURRENT_FSM_UNCONFIG_SO_L = "UnconfigSoL"
	CONST_CURRENT_FSM_UPDATE_ADAPTOR = "UpdateAdaptor"
	CONST_CURRENT_FSM_UPDATE_BIOS = "UpdateBIOS"
	CONST_CURRENT_FSM_UPDATE_BOARD_CONTROLLER = "UpdateBoardController"
	CONST_CURRENT_FSM_NOP = "nop"
	CONST_CURRENT_FSM_UPDATE_EXT_USERS = "updateExtUsers"
	CONST_FSM_STATUS_FAIL = "fail"
	CONST_FSM_STATUS_IN_PROGRESS = "inProgress"
	CONST_FSM_STATUS_NOP = "nop"
	CONST_FSM_STATUS_PENDING = "pending"
	CONST_FSM_STATUS_SKIP = "skip"
	CONST_FSM_STATUS_SUCCESS = "success"
	CONST_FSM_STATUS_THROTTLED = "throttled"
	CONST_RMT_ERR_CODE_ERR_2FA_AUTH_RETRY = "ERR-2fa-auth-retry"
	CONST_RMT_ERR_CODE_ERR_ACTIVATE_FAILED = "ERR-ACTIVATE-failed"
	CONST_RMT_ERR_CODE_ERR_ACTIVATE_IN_PROGRESS = "ERR-ACTIVATE-in-progress"
	CONST_RMT_ERR_CODE_ERR_ACTIVATE_RETRY = "ERR-ACTIVATE-retry"
	CONST_RMT_ERR_CODE_ERR_BIOS_TOKENS_OLD_BIOS = "ERR-BIOS-TOKENS-OLD-BIOS"
	CONST_RMT_ERR_CODE_ERR_BIOS_TOKENS_OLD_CIMC = "ERR-BIOS-TOKENS-OLD-CIMC"
	CONST_RMT_ERR_CODE_ERR_BIOS_NETWORK_BOOT_ORDER_NOT_FOUND = "ERR-BIOS-network-boot-order-not-found"
	CONST_RMT_ERR_CODE_ERR_BOARDCTRLUPDATE_IGNORE = "ERR-BOARDCTRLUPDATE-ignore"
	CONST_RMT_ERR_CODE_ERR_DIAG_CANCELLED = "ERR-DIAG-cancelled"
	CONST_RMT_ERR_CODE_ERR_DIAG_FSM_RESTARTED = "ERR-DIAG-fsm-restarted"
	CONST_RMT_ERR_CODE_ERR_DIAG_TEST_FAILED = "ERR-DIAG-test-failed"
	CONST_RMT_ERR_CODE_ERR_DNLD_AUTHENTICATION_FAILURE = "ERR-DNLD-authentication-failure"
	CONST_RMT_ERR_CODE_ERR_DNLD_HOSTKEY_MISMATCH = "ERR-DNLD-hostkey-mismatch"
	CONST_RMT_ERR_CODE_ERR_DNLD_INVALID_IMAGE = "ERR-DNLD-invalid-image"
	CONST_RMT_ERR_CODE_ERR_DNLD_NO_FILE = "ERR-DNLD-no-file"
	CONST_RMT_ERR_CODE_ERR_DNLD_NO_SPACE = "ERR-DNLD-no-space"
	CONST_RMT_ERR_CODE_ERR_DNS_DELETE_ERROR = "ERR-DNS-delete-error"
	CONST_RMT_ERR_CODE_ERR_DNS_GET_ERROR = "ERR-DNS-get-error"
	CONST_RMT_ERR_CODE_ERR_DNS_SET_ERROR = "ERR-DNS-set-error"
	CONST_RMT_ERR_CODE_ERR_DIAGNOSTICS_IN_PROGRESS = "ERR-Diagnostics-in-progress"
	CONST_RMT_ERR_CODE_ERR_DIAGNOSTICS_MEMTEST_IN_PROGRESS = "ERR-Diagnostics-memtest-in-progress"
	CONST_RMT_ERR_CODE_ERR_DIAGNOSTICS_NETWORK_IN_PROGRESS = "ERR-Diagnostics-network-in-progress"
	CONST_RMT_ERR_CODE_ERR_FILTER_ILLEGAL_FORMAT = "ERR-FILTER-illegal-format"
	CONST_RMT_ERR_CODE_ERR_FSM_NO_SUCH_STATE = "ERR-FSM-no-such-state"
	CONST_RMT_ERR_CODE_ERR_HOST_FRU_IDENTITY_MISMATCH = "ERR-HOST-fru-identity-mismatch"
	CONST_RMT_ERR_CODE_ERR_HTTP_SET_ERROR = "ERR-HTTP-set-error"
	CONST_RMT_ERR_CODE_ERR_HTTPS_SET_ERROR = "ERR-HTTPS-set-error"
	CONST_RMT_ERR_CODE_ERR_IBMC_ANALYZE_RESULTS = "ERR-IBMC-analyze-results"
	CONST_RMT_ERR_CODE_ERR_IBMC_CONNECT_ERROR = "ERR-IBMC-connect-error"
	CONST_RMT_ERR_CODE_ERR_IBMC_FRU_RETRIEVAL_ERROR = "ERR-IBMC-fru-retrieval-error"
	CONST_RMT_ERR_CODE_ERR_IBMC_INVALID_END_POINT_CONFIG = "ERR-IBMC-invalid-end-point-config"
	CONST_RMT_ERR_CODE_ERR_IBMC_RESULTS_NOT_READY = "ERR-IBMC-results-not-ready"
	CONST_RMT_ERR_CODE_ERR_MAX_SUBSCRIPTIONS_ALLOWED_ERROR = "ERR-MAX-subscriptions-allowed-error"
	CONST_RMT_ERR_CODE_ERR_MO_CONFIG_CHILD_OBJECT_CANT_BE_CONFIGURED = "ERR-MO-CONFIG-child-object-cant-be-configured"
	CONST_RMT_ERR_CODE_ERR_MO_META_NO_SUCH_OBJECT_CLASS = "ERR-MO-META-no-such-object-class"
	CONST_RMT_ERR_CODE_ERR_MO_PROPERTY_NO_SUCH_PROPERTY = "ERR-MO-PROPERTY-no-such-property"
	CONST_RMT_ERR_CODE_ERR_MO_PROPERTY_VALUE_OUT_OF_RANGE = "ERR-MO-PROPERTY-value-out-of-range"
	CONST_RMT_ERR_CODE_ERR_MO_ACCESS_DENIED = "ERR-MO-access-denied"
	CONST_RMT_ERR_CODE_ERR_MO_DELETION_RULE_VIOLATION = "ERR-MO-deletion-rule-violation"
	CONST_RMT_ERR_CODE_ERR_MO_DUPLICATE_OBJECT = "ERR-MO-duplicate-object"
	CONST_RMT_ERR_CODE_ERR_MO_ILLEGAL_CONTAINMENT = "ERR-MO-illegal-containment"
	CONST_RMT_ERR_CODE_ERR_MO_ILLEGAL_CREATION = "ERR-MO-illegal-creation"
	CONST_RMT_ERR_CODE_ERR_MO_ILLEGAL_ITERATOR_STATE = "ERR-MO-illegal-iterator-state"
	CONST_RMT_ERR_CODE_ERR_MO_ILLEGAL_OBJECT_LIFECYCLE_TRANSITION = "ERR-MO-illegal-object-lifecycle-transition"
	CONST_RMT_ERR_CODE_ERR_MO_NAMING_RULE_VIOLATION = "ERR-MO-naming-rule-violation"
	CONST_RMT_ERR_CODE_ERR_MO_OBJECT_NOT_FOUND = "ERR-MO-object-not-found"
	CONST_RMT_ERR_CODE_ERR_MO_RESOURCE_ALLOCATION = "ERR-MO-resource-allocation"
	CONST_RMT_ERR_CODE_ERR_NTP_DELETE_ERROR = "ERR-NTP-delete-error"
	CONST_RMT_ERR_CODE_ERR_NTP_GET_ERROR = "ERR-NTP-get-error"
	CONST_RMT_ERR_CODE_ERR_NTP_SET_ERROR = "ERR-NTP-set-error"
	CONST_RMT_ERR_CODE_ERR_POWER_CAP_UNSUPPORTED = "ERR-POWER-CAP-UNSUPPORTED"
	CONST_RMT_ERR_CODE_ERR_SERVER_MIS_CONNECT = "ERR-SERVER-mis-connect"
	CONST_RMT_ERR_CODE_ERR_SWITCH_INVALID_IF_CONFIG = "ERR-SWITCH-invalid-if-config"
	CONST_RMT_ERR_CODE_ERR_TOKEN_REQUEST_DENIED = "ERR-TOKEN-request-denied"
	CONST_RMT_ERR_CODE_ERR_UNABLE_TO_FETCH_BIOS_SETTINGS = "ERR-UNABLE-TO-FETCH-BIOS-SETTINGS"
	CONST_RMT_ERR_CODE_ERR_UPDATE_FAILED = "ERR-UPDATE-failed"
	CONST_RMT_ERR_CODE_ERR_UPDATE_IN_PROGRESS = "ERR-UPDATE-in-progress"
	CONST_RMT_ERR_CODE_ERR_UPDATE_RETRY = "ERR-UPDATE-retry"
	CONST_RMT_ERR_CODE_ERR_AAA_CONFIG_MODIFY_ERROR = "ERR-aaa-config-modify-error"
	CONST_RMT_ERR_CODE_ERR_ACCT_REALM_SET_ERROR = "ERR-acct-realm-set-error"
	CONST_RMT_ERR_CODE_ERR_ADMIN_PASSWD_SET = "ERR-admin-passwd-set"
	CONST_RMT_ERR_CODE_ERR_AUTH_ISSUE = "ERR-auth-issue"
	CONST_RMT_ERR_CODE_ERR_AUTH_REALM_GET_ERROR = "ERR-auth-realm-get-error"
	CONST_RMT_ERR_CODE_ERR_AUTH_REALM_SET_ERROR = "ERR-auth-realm-set-error"
	CONST_RMT_ERR_CODE_ERR_AUTHENTICATION = "ERR-authentication"
	CONST_RMT_ERR_CODE_ERR_AUTHORIZATION_REQUIRED = "ERR-authorization-required"
	CONST_RMT_ERR_CODE_ERR_CLI_SESSION_LIMIT_REACHED = "ERR-cli-session-limit-reached"
	CONST_RMT_ERR_CODE_ERR_CREATE_KEYRING = "ERR-create-keyring"
	CONST_RMT_ERR_CODE_ERR_CREATE_LOCALE = "ERR-create-locale"
	CONST_RMT_ERR_CODE_ERR_CREATE_ROLE = "ERR-create-role"
	CONST_RMT_ERR_CODE_ERR_CREATE_USER = "ERR-create-user"
	CONST_RMT_ERR_CODE_ERR_DELETE_LOCALE = "ERR-delete-locale"
	CONST_RMT_ERR_CODE_ERR_DELETE_ROLE = "ERR-delete-role"
	CONST_RMT_ERR_CODE_ERR_DELETE_SESSION = "ERR-delete-session"
	CONST_RMT_ERR_CODE_ERR_DELETE_USER = "ERR-delete-user"
	CONST_RMT_ERR_CODE_ERR_EFI_DIAGNOSTICS_IN_PROGRESS = "ERR-efi-Diagnostics--in-progress"
	CONST_RMT_ERR_CODE_ERR_ENABLE_MGMT_CONN = "ERR-enable-mgmt-conn"
	CONST_RMT_ERR_CODE_ERR_EP_SET_ERROR = "ERR-ep-set-error"
	CONST_RMT_ERR_CODE_ERR_GET_MAX_HTTP_USER_SESSIONS = "ERR-get-max-http-user-sessions"
	CONST_RMT_ERR_CODE_ERR_HTTP_INITIALIZING = "ERR-http-initializing"
	CONST_RMT_ERR_CODE_ERR_INSUFFICIENTLY_EQUIPPED = "ERR-insufficiently-equipped"
	CONST_RMT_ERR_CODE_ERR_INTERNAL_ERROR = "ERR-internal-error"
	CONST_RMT_ERR_CODE_ERR_LDAP_DELETE_ERROR = "ERR-ldap-delete-error"
	CONST_RMT_ERR_CODE_ERR_LDAP_GET_ERROR = "ERR-ldap-get-error"
	CONST_RMT_ERR_CODE_ERR_LDAP_GROUP_MODIFY_ERROR = "ERR-ldap-group-modify-error"
	CONST_RMT_ERR_CODE_ERR_LDAP_GROUP_SET_ERROR = "ERR-ldap-group-set-error"
	CONST_RMT_ERR_CODE_ERR_LDAP_SET_ERROR = "ERR-ldap-set-error"
	CONST_RMT_ERR_CODE_ERR_LOCALE_SET_ERROR = "ERR-locale-set-error"
	CONST_RMT_ERR_CODE_ERR_MAX_USERID_SESSIONS_REACHED = "ERR-max-userid-sessions-reached"
	CONST_RMT_ERR_CODE_ERR_MISSING_METHOD = "ERR-missing-method"
	CONST_RMT_ERR_CODE_ERR_MODIFY_LOCALE = "ERR-modify-locale"
	CONST_RMT_ERR_CODE_ERR_MODIFY_ROLE = "ERR-modify-role"
	CONST_RMT_ERR_CODE_ERR_MODIFY_USER = "ERR-modify-user"
	CONST_RMT_ERR_CODE_ERR_MODIFY_USER_LOCALE = "ERR-modify-user-locale"
	CONST_RMT_ERR_CODE_ERR_MODIFY_USER_ROLE = "ERR-modify-user-role"
	CONST_RMT_ERR_CODE_ERR_PROVIDER_GROUP_MODIFY_ERROR = "ERR-provider-group-modify-error"
	CONST_RMT_ERR_CODE_ERR_PROVIDER_GROUP_SET_ERROR = "ERR-provider-group-set-error"
	CONST_RMT_ERR_CODE_ERR_RADIUS_GET_ERROR = "ERR-radius-get-error"
	CONST_RMT_ERR_CODE_ERR_RADIUS_GLOBAL_SET_ERROR = "ERR-radius-global-set-error"
	CONST_RMT_ERR_CODE_ERR_RADIUS_GROUP_SET_ERROR = "ERR-radius-group-set-error"
	CONST_RMT_ERR_CODE_ERR_RADIUS_SET_ERROR = "ERR-radius-set-error"
	CONST_RMT_ERR_CODE_ERR_REQUEST_TIMEOUT = "ERR-request-timeout"
	CONST_RMT_ERR_CODE_ERR_RESET_ADAPTER = "ERR-reset-adapter"
	CONST_RMT_ERR_CODE_ERR_ROLE_SET_ERROR = "ERR-role-set-error"
	CONST_RMT_ERR_CODE_ERR_SECONDARY_NODE = "ERR-secondary-node"
	CONST_RMT_ERR_CODE_ERR_SERVICE_NOT_READY = "ERR-service-not-ready"
	CONST_RMT_ERR_CODE_ERR_SESSION_CACHE_FULL = "ERR-session-cache-full"
	CONST_RMT_ERR_CODE_ERR_SESSION_NOT_FOUND = "ERR-session-not-found"
	CONST_RMT_ERR_CODE_ERR_SET_NETWORK = "ERR-set-network"
	CONST_RMT_ERR_CODE_ERR_SET_PASSWORD_STRENGTH_CHECK = "ERR-set-password-strength-check"
	CONST_RMT_ERR_CODE_ERR_SET_PORT_CHANNEL = "ERR-set-port-channel"
	CONST_RMT_ERR_CODE_ERR_STORE_PRE_LOGIN_BANNER_MSG = "ERR-store-pre-login-banner-msg"
	CONST_RMT_ERR_CODE_ERR_TACACS_ENABLE_ERROR = "ERR-tacacs-enable-error"
	CONST_RMT_ERR_CODE_ERR_TACACS_GLOBAL_SET_ERROR = "ERR-tacacs-global-set-error"
	CONST_RMT_ERR_CODE_ERR_TACACS_GROUP_SET_ERROR = "ERR-tacacs-group-set-error"
	CONST_RMT_ERR_CODE_ERR_TACACS_PLUS_GET_ERROR = "ERR-tacacs-plus-get-error"
	CONST_RMT_ERR_CODE_ERR_TACACS_SET_ERROR = "ERR-tacacs-set-error"
	CONST_RMT_ERR_CODE_ERR_TEST_ERROR_1 = "ERR-test-error-1"
	CONST_RMT_ERR_CODE_ERR_TEST_ERROR_2 = "ERR-test-error-2"
	CONST_RMT_ERR_CODE_ERR_TIMEZONE_SET_ERROR = "ERR-timezone-set-error"
	CONST_RMT_ERR_CODE_ERR_USER_ACCOUNT_EXPIRED = "ERR-user-account-expired"
	CONST_RMT_ERR_CODE_ERR_USER_SET_ERROR = "ERR-user-set-error"
	CONST_RMT_ERR_CODE_ERR_XML_PARSE_ERROR = "ERR-xml-parse-error"
	CONST_RMT_ERR_CODE_NONE = "none"

class MgmtExportPolicyFsm(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"MgmtExportPolicyFsm")

	@staticmethod
	def ClassId():
		return "mgmtExportPolicyFsm"

	COMPLETION_TIME = "CompletionTime"
	CURRENT_FSM = "CurrentFsm"
	DESCR = "Descr"
	DN = "Dn"
	INSTANCE_ID = "InstanceId"
	PROGRESS = "Progress"
	RMT_ERR_CODE = "RmtErrCode"
	RMT_ERR_DESCR = "RmtErrDescr"
	RMT_RSLT = "RmtRslt"
	RN = "Rn"
	STATUS = "Status"

	CONST_COMPLETION_TIME_ = ""
	CONST_CURRENT_FSM_REPORT_CONFIG_COPY = "ReportConfigCopy"
	CONST_CURRENT_FSM_NOP = "nop"
	CONST_FSM_STATUS_FAIL = "fail"
	CONST_FSM_STATUS_IN_PROGRESS = "inProgress"
	CONST_FSM_STATUS_NOP = "nop"
	CONST_FSM_STATUS_PENDING = "pending"
	CONST_FSM_STATUS_SKIP = "skip"
	CONST_FSM_STATUS_SUCCESS = "success"
	CONST_FSM_STATUS_THROTTLED = "throttled"
	CONST_RMT_ERR_CODE_ERR_2FA_AUTH_RETRY = "ERR-2fa-auth-retry"
	CONST_RMT_ERR_CODE_ERR_ACTIVATE_FAILED = "ERR-ACTIVATE-failed"
	CONST_RMT_ERR_CODE_ERR_ACTIVATE_IN_PROGRESS = "ERR-ACTIVATE-in-progress"
	CONST_RMT_ERR_CODE_ERR_ACTIVATE_RETRY = "ERR-ACTIVATE-retry"
	CONST_RMT_ERR_CODE_ERR_BIOS_TOKENS_OLD_BIOS = "ERR-BIOS-TOKENS-OLD-BIOS"
	CONST_RMT_ERR_CODE_ERR_BIOS_TOKENS_OLD_CIMC = "ERR-BIOS-TOKENS-OLD-CIMC"
	CONST_RMT_ERR_CODE_ERR_BIOS_NETWORK_BOOT_ORDER_NOT_FOUND = "ERR-BIOS-network-boot-order-not-found"
	CONST_RMT_ERR_CODE_ERR_BOARDCTRLUPDATE_IGNORE = "ERR-BOARDCTRLUPDATE-ignore"
	CONST_RMT_ERR_CODE_ERR_DIAG_CANCELLED = "ERR-DIAG-cancelled"
	CONST_RMT_ERR_CODE_ERR_DIAG_FSM_RESTARTED = "ERR-DIAG-fsm-restarted"
	CONST_RMT_ERR_CODE_ERR_DIAG_TEST_FAILED = "ERR-DIAG-test-failed"
	CONST_RMT_ERR_CODE_ERR_DNLD_AUTHENTICATION_FAILURE = "ERR-DNLD-authentication-failure"
	CONST_RMT_ERR_CODE_ERR_DNLD_HOSTKEY_MISMATCH = "ERR-DNLD-hostkey-mismatch"
	CONST_RMT_ERR_CODE_ERR_DNLD_INVALID_IMAGE = "ERR-DNLD-invalid-image"
	CONST_RMT_ERR_CODE_ERR_DNLD_NO_FILE = "ERR-DNLD-no-file"
	CONST_RMT_ERR_CODE_ERR_DNLD_NO_SPACE = "ERR-DNLD-no-space"
	CONST_RMT_ERR_CODE_ERR_DNS_DELETE_ERROR = "ERR-DNS-delete-error"
	CONST_RMT_ERR_CODE_ERR_DNS_GET_ERROR = "ERR-DNS-get-error"
	CONST_RMT_ERR_CODE_ERR_DNS_SET_ERROR = "ERR-DNS-set-error"
	CONST_RMT_ERR_CODE_ERR_DIAGNOSTICS_IN_PROGRESS = "ERR-Diagnostics-in-progress"
	CONST_RMT_ERR_CODE_ERR_DIAGNOSTICS_MEMTEST_IN_PROGRESS = "ERR-Diagnostics-memtest-in-progress"
	CONST_RMT_ERR_CODE_ERR_DIAGNOSTICS_NETWORK_IN_PROGRESS = "ERR-Diagnostics-network-in-progress"
	CONST_RMT_ERR_CODE_ERR_FILTER_ILLEGAL_FORMAT = "ERR-FILTER-illegal-format"
	CONST_RMT_ERR_CODE_ERR_FSM_NO_SUCH_STATE = "ERR-FSM-no-such-state"
	CONST_RMT_ERR_CODE_ERR_HOST_FRU_IDENTITY_MISMATCH = "ERR-HOST-fru-identity-mismatch"
	CONST_RMT_ERR_CODE_ERR_HTTP_SET_ERROR = "ERR-HTTP-set-error"
	CONST_RMT_ERR_CODE_ERR_HTTPS_SET_ERROR = "ERR-HTTPS-set-error"
	CONST_RMT_ERR_CODE_ERR_IBMC_ANALYZE_RESULTS = "ERR-IBMC-analyze-results"
	CONST_RMT_ERR_CODE_ERR_IBMC_CONNECT_ERROR = "ERR-IBMC-connect-error"
	CONST_RMT_ERR_CODE_ERR_IBMC_FRU_RETRIEVAL_ERROR = "ERR-IBMC-fru-retrieval-error"
	CONST_RMT_ERR_CODE_ERR_IBMC_INVALID_END_POINT_CONFIG = "ERR-IBMC-invalid-end-point-config"
	CONST_RMT_ERR_CODE_ERR_IBMC_RESULTS_NOT_READY = "ERR-IBMC-results-not-ready"
	CONST_RMT_ERR_CODE_ERR_MAX_SUBSCRIPTIONS_ALLOWED_ERROR = "ERR-MAX-subscriptions-allowed-error"
	CONST_RMT_ERR_CODE_ERR_MO_CONFIG_CHILD_OBJECT_CANT_BE_CONFIGURED = "ERR-MO-CONFIG-child-object-cant-be-configured"
	CONST_RMT_ERR_CODE_ERR_MO_META_NO_SUCH_OBJECT_CLASS = "ERR-MO-META-no-such-object-class"
	CONST_RMT_ERR_CODE_ERR_MO_PROPERTY_NO_SUCH_PROPERTY = "ERR-MO-PROPERTY-no-such-property"
	CONST_RMT_ERR_CODE_ERR_MO_PROPERTY_VALUE_OUT_OF_RANGE = "ERR-MO-PROPERTY-value-out-of-range"
	CONST_RMT_ERR_CODE_ERR_MO_ACCESS_DENIED = "ERR-MO-access-denied"
	CONST_RMT_ERR_CODE_ERR_MO_DELETION_RULE_VIOLATION = "ERR-MO-deletion-rule-violation"
	CONST_RMT_ERR_CODE_ERR_MO_DUPLICATE_OBJECT = "ERR-MO-duplicate-object"
	CONST_RMT_ERR_CODE_ERR_MO_ILLEGAL_CONTAINMENT = "ERR-MO-illegal-containment"
	CONST_RMT_ERR_CODE_ERR_MO_ILLEGAL_CREATION = "ERR-MO-illegal-creation"
	CONST_RMT_ERR_CODE_ERR_MO_ILLEGAL_ITERATOR_STATE = "ERR-MO-illegal-iterator-state"
	CONST_RMT_ERR_CODE_ERR_MO_ILLEGAL_OBJECT_LIFECYCLE_TRANSITION = "ERR-MO-illegal-object-lifecycle-transition"
	CONST_RMT_ERR_CODE_ERR_MO_NAMING_RULE_VIOLATION = "ERR-MO-naming-rule-violation"
	CONST_RMT_ERR_CODE_ERR_MO_OBJECT_NOT_FOUND = "ERR-MO-object-not-found"
	CONST_RMT_ERR_CODE_ERR_MO_RESOURCE_ALLOCATION = "ERR-MO-resource-allocation"
	CONST_RMT_ERR_CODE_ERR_NTP_DELETE_ERROR = "ERR-NTP-delete-error"
	CONST_RMT_ERR_CODE_ERR_NTP_GET_ERROR = "ERR-NTP-get-error"
	CONST_RMT_ERR_CODE_ERR_NTP_SET_ERROR = "ERR-NTP-set-error"
	CONST_RMT_ERR_CODE_ERR_POWER_CAP_UNSUPPORTED = "ERR-POWER-CAP-UNSUPPORTED"
	CONST_RMT_ERR_CODE_ERR_SERVER_MIS_CONNECT = "ERR-SERVER-mis-connect"
	CONST_RMT_ERR_CODE_ERR_SWITCH_INVALID_IF_CONFIG = "ERR-SWITCH-invalid-if-config"
	CONST_RMT_ERR_CODE_ERR_TOKEN_REQUEST_DENIED = "ERR-TOKEN-request-denied"
	CONST_RMT_ERR_CODE_ERR_UNABLE_TO_FETCH_BIOS_SETTINGS = "ERR-UNABLE-TO-FETCH-BIOS-SETTINGS"
	CONST_RMT_ERR_CODE_ERR_UPDATE_FAILED = "ERR-UPDATE-failed"
	CONST_RMT_ERR_CODE_ERR_UPDATE_IN_PROGRESS = "ERR-UPDATE-in-progress"
	CONST_RMT_ERR_CODE_ERR_UPDATE_RETRY = "ERR-UPDATE-retry"
	CONST_RMT_ERR_CODE_ERR_AAA_CONFIG_MODIFY_ERROR = "ERR-aaa-config-modify-error"
	CONST_RMT_ERR_CODE_ERR_ACCT_REALM_SET_ERROR = "ERR-acct-realm-set-error"
	CONST_RMT_ERR_CODE_ERR_ADMIN_PASSWD_SET = "ERR-admin-passwd-set"
	CONST_RMT_ERR_CODE_ERR_AUTH_ISSUE = "ERR-auth-issue"
	CONST_RMT_ERR_CODE_ERR_AUTH_REALM_GET_ERROR = "ERR-auth-realm-get-error"
	CONST_RMT_ERR_CODE_ERR_AUTH_REALM_SET_ERROR = "ERR-auth-realm-set-error"
	CONST_RMT_ERR_CODE_ERR_AUTHENTICATION = "ERR-authentication"
	CONST_RMT_ERR_CODE_ERR_AUTHORIZATION_REQUIRED = "ERR-authorization-required"
	CONST_RMT_ERR_CODE_ERR_CLI_SESSION_LIMIT_REACHED = "ERR-cli-session-limit-reached"
	CONST_RMT_ERR_CODE_ERR_CREATE_KEYRING = "ERR-create-keyring"
	CONST_RMT_ERR_CODE_ERR_CREATE_LOCALE = "ERR-create-locale"
	CONST_RMT_ERR_CODE_ERR_CREATE_ROLE = "ERR-create-role"
	CONST_RMT_ERR_CODE_ERR_CREATE_USER = "ERR-create-user"
	CONST_RMT_ERR_CODE_ERR_DELETE_LOCALE = "ERR-delete-locale"
	CONST_RMT_ERR_CODE_ERR_DELETE_ROLE = "ERR-delete-role"
	CONST_RMT_ERR_CODE_ERR_DELETE_SESSION = "ERR-delete-session"
	CONST_RMT_ERR_CODE_ERR_DELETE_USER = "ERR-delete-user"
	CONST_RMT_ERR_CODE_ERR_EFI_DIAGNOSTICS_IN_PROGRESS = "ERR-efi-Diagnostics--in-progress"
	CONST_RMT_ERR_CODE_ERR_ENABLE_MGMT_CONN = "ERR-enable-mgmt-conn"
	CONST_RMT_ERR_CODE_ERR_EP_SET_ERROR = "ERR-ep-set-error"
	CONST_RMT_ERR_CODE_ERR_GET_MAX_HTTP_USER_SESSIONS = "ERR-get-max-http-user-sessions"
	CONST_RMT_ERR_CODE_ERR_HTTP_INITIALIZING = "ERR-http-initializing"
	CONST_RMT_ERR_CODE_ERR_INSUFFICIENTLY_EQUIPPED = "ERR-insufficiently-equipped"
	CONST_RMT_ERR_CODE_ERR_INTERNAL_ERROR = "ERR-internal-error"
	CONST_RMT_ERR_CODE_ERR_LDAP_DELETE_ERROR = "ERR-ldap-delete-error"
	CONST_RMT_ERR_CODE_ERR_LDAP_GET_ERROR = "ERR-ldap-get-error"
	CONST_RMT_ERR_CODE_ERR_LDAP_GROUP_MODIFY_ERROR = "ERR-ldap-group-modify-error"
	CONST_RMT_ERR_CODE_ERR_LDAP_GROUP_SET_ERROR = "ERR-ldap-group-set-error"
	CONST_RMT_ERR_CODE_ERR_LDAP_SET_ERROR = "ERR-ldap-set-error"
	CONST_RMT_ERR_CODE_ERR_LOCALE_SET_ERROR = "ERR-locale-set-error"
	CONST_RMT_ERR_CODE_ERR_MAX_USERID_SESSIONS_REACHED = "ERR-max-userid-sessions-reached"
	CONST_RMT_ERR_CODE_ERR_MISSING_METHOD = "ERR-missing-method"
	CONST_RMT_ERR_CODE_ERR_MODIFY_LOCALE = "ERR-modify-locale"
	CONST_RMT_ERR_CODE_ERR_MODIFY_ROLE = "ERR-modify-role"
	CONST_RMT_ERR_CODE_ERR_MODIFY_USER = "ERR-modify-user"
	CONST_RMT_ERR_CODE_ERR_MODIFY_USER_LOCALE = "ERR-modify-user-locale"
	CONST_RMT_ERR_CODE_ERR_MODIFY_USER_ROLE = "ERR-modify-user-role"
	CONST_RMT_ERR_CODE_ERR_PROVIDER_GROUP_MODIFY_ERROR = "ERR-provider-group-modify-error"
	CONST_RMT_ERR_CODE_ERR_PROVIDER_GROUP_SET_ERROR = "ERR-provider-group-set-error"
	CONST_RMT_ERR_CODE_ERR_RADIUS_GET_ERROR = "ERR-radius-get-error"
	CONST_RMT_ERR_CODE_ERR_RADIUS_GLOBAL_SET_ERROR = "ERR-radius-global-set-error"
	CONST_RMT_ERR_CODE_ERR_RADIUS_GROUP_SET_ERROR = "ERR-radius-group-set-error"
	CONST_RMT_ERR_CODE_ERR_RADIUS_SET_ERROR = "ERR-radius-set-error"
	CONST_RMT_ERR_CODE_ERR_REQUEST_TIMEOUT = "ERR-request-timeout"
	CONST_RMT_ERR_CODE_ERR_RESET_ADAPTER = "ERR-reset-adapter"
	CONST_RMT_ERR_CODE_ERR_ROLE_SET_ERROR = "ERR-role-set-error"
	CONST_RMT_ERR_CODE_ERR_SECONDARY_NODE = "ERR-secondary-node"
	CONST_RMT_ERR_CODE_ERR_SERVICE_NOT_READY = "ERR-service-not-ready"
	CONST_RMT_ERR_CODE_ERR_SESSION_CACHE_FULL = "ERR-session-cache-full"
	CONST_RMT_ERR_CODE_ERR_SESSION_NOT_FOUND = "ERR-session-not-found"
	CONST_RMT_ERR_CODE_ERR_SET_NETWORK = "ERR-set-network"
	CONST_RMT_ERR_CODE_ERR_SET_PASSWORD_STRENGTH_CHECK = "ERR-set-password-strength-check"
	CONST_RMT_ERR_CODE_ERR_SET_PORT_CHANNEL = "ERR-set-port-channel"
	CONST_RMT_ERR_CODE_ERR_STORE_PRE_LOGIN_BANNER_MSG = "ERR-store-pre-login-banner-msg"
	CONST_RMT_ERR_CODE_ERR_TACACS_ENABLE_ERROR = "ERR-tacacs-enable-error"
	CONST_RMT_ERR_CODE_ERR_TACACS_GLOBAL_SET_ERROR = "ERR-tacacs-global-set-error"
	CONST_RMT_ERR_CODE_ERR_TACACS_GROUP_SET_ERROR = "ERR-tacacs-group-set-error"
	CONST_RMT_ERR_CODE_ERR_TACACS_PLUS_GET_ERROR = "ERR-tacacs-plus-get-error"
	CONST_RMT_ERR_CODE_ERR_TACACS_SET_ERROR = "ERR-tacacs-set-error"
	CONST_RMT_ERR_CODE_ERR_TEST_ERROR_1 = "ERR-test-error-1"
	CONST_RMT_ERR_CODE_ERR_TEST_ERROR_2 = "ERR-test-error-2"
	CONST_RMT_ERR_CODE_ERR_TIMEZONE_SET_ERROR = "ERR-timezone-set-error"
	CONST_RMT_ERR_CODE_ERR_USER_ACCOUNT_EXPIRED = "ERR-user-account-expired"
	CONST_RMT_ERR_CODE_ERR_USER_SET_ERROR = "ERR-user-set-error"
	CONST_RMT_ERR_CODE_ERR_XML_PARSE_ERROR = "ERR-xml-parse-error"
	CONST_RMT_ERR_CODE_NONE = "none"

class AdaptorFcPortProfile(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"AdaptorFcPortProfile")

	@staticmethod
	def ClassId():
		return "adaptorFcPortProfile"

	DN = "Dn"
	IO_THROTTLE_COUNT = "IoThrottleCount"
	LUNS_PER_TARGET = "LunsPerTarget"
	RN = "Rn"
	STATUS = "Status"


class EtherPortChanIdUniverse(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"EtherPortChanIdUniverse")

	@staticmethod
	def ClassId():
		return "etherPortChanIdUniverse"

	DN = "Dn"
	RN = "Rn"
	STATUS = "Status"


class FirmwareDistributableFsmStage(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"FirmwareDistributableFsmStage")

	@staticmethod
	def ClassId():
		return "firmwareDistributableFsmStage"

	DESCR = "Descr"
	DN = "Dn"
	LAST_UPDATE_TIME = "LastUpdateTime"
	NAME = "Name"
	ORDER = "Order"
	RETRY = "Retry"
	RN = "Rn"
	STAGE_STATUS = "StageStatus"
	STATUS = "Status"

	CONST_LAST_UPDATE_TIME_ = ""
	CONST_NAME_DELETE_BEGIN = "DeleteBegin"
	CONST_NAME_DELETE_FAIL = "DeleteFail"
	CONST_NAME_DELETE_LOCAL = "DeleteLocal"
	CONST_NAME_DELETE_REMOTE = "DeleteRemote"
	CONST_NAME_DELETE_SUCCESS = "DeleteSuccess"
	CONST_NAME_NOP = "nop"
	CONST_STAGE_STATUS_FAIL = "fail"
	CONST_STAGE_STATUS_IN_PROGRESS = "inProgress"
	CONST_STAGE_STATUS_NOP = "nop"
	CONST_STAGE_STATUS_PENDING = "pending"
	CONST_STAGE_STATUS_SKIP = "skip"
	CONST_STAGE_STATUS_SUCCESS = "success"
	CONST_STAGE_STATUS_THROTTLED = "throttled"

class OsAgent(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"OsAgent")

	@staticmethod
	def ClassId():
		return "osAgent"

	DN = "Dn"
	LAST_CMD = "LastCmd"
	LAST_EVT = "LastEvt"
	LAST_EVT_TS = "LastEvtTs"
	PREV_CMD = "PrevCmd"
	PREV_EVT = "PrevEvt"
	RN = "Rn"
	STATUS = "Status"
	TYPE = "Type"
	VENDOR = "Vendor"
	VERSION = "Version"

	CONST_LAST_CMD_NONE = "none"
	CONST_LAST_EVT_NONE = "none"
	CONST_PREV_CMD_NONE = "none"
	CONST_PREV_EVT_NONE = "none"
	CONST_TYPE_HOST_AGENT = "hostAgent"
	CONST_TYPE_INDETERMINATE = "indeterminate"
	CONST_TYPE_PNUOS_AGENT = "pnuosAgent"

class EquipmentPortGroupAggregationDef(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"EquipmentPortGroupAggregationDef")

	@staticmethod
	def ClassId():
		return "equipmentPortGroupAggregationDef"

	AGGREGATION_CAP = "AggregationCap"
	DESCR = "Descr"
	DN = "Dn"
	NAME = "Name"
	POLICY_LEVEL = "PolicyLevel"
	POLICY_OWNER = "PolicyOwner"
	RN = "Rn"
	STATUS = "Status"
	TYPE = "Type"

	CONST_INT_ID_NONE = "none"
	CONST_POLICY_OWNER_LOCAL = "local"
	CONST_POLICY_OWNER_PENDING_POLICY = "pending-policy"
	CONST_POLICY_OWNER_POLICY = "policy"
	CONST_TYPE_ADAPTOR_EXT = "adaptor-ext"
	CONST_TYPE_ADAPTOR_PC = "adaptor-pc"
	CONST_TYPE_FABRIC = "fabric"
	CONST_TYPE_FABRIC_PC = "fabric-pc"
	CONST_TYPE_HOST = "host"
	CONST_TYPE_HOST_PC = "host-pc"
	CONST_TYPE_SERVER_PC = "server-pc"
	CONST_TYPE_SWITCH_ETHER = "switch-ether"
	CONST_TYPE_SWITCH_FC = "switch-fc"

class VnicIpV6MgmtPooledAddr(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"VnicIpV6MgmtPooledAddr")

	@staticmethod
	def ClassId():
		return "vnicIpV6MgmtPooledAddr"

	ADDR = "Addr"
	DEF_GW = "DefGw"
	DN = "Dn"
	NAME = "Name"
	OPER_NAME = "OperName"
	PREFIX = "Prefix"
	RN = "Rn"
	STATUS = "Status"


class SysdebugLogControlDestinationSyslog(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"SysdebugLogControlDestinationSyslog")

	@staticmethod
	def ClassId():
		return "sysdebugLogControlDestinationSyslog"

	DEFAULT_LEVEL = "DefaultLevel"
	DN = "Dn"
	LEVEL = "Level"
	RN = "Rn"
	STATUS = "Status"

	CONST_DEFAULT_LEVEL_CRIT = "crit"
	CONST_DEFAULT_LEVEL_DEBUG0 = "debug0"
	CONST_DEFAULT_LEVEL_DEBUG1 = "debug1"
	CONST_DEFAULT_LEVEL_DEBUG2 = "debug2"
	CONST_DEFAULT_LEVEL_DEBUG3 = "debug3"
	CONST_DEFAULT_LEVEL_DEBUG4 = "debug4"
	CONST_DEFAULT_LEVEL_INFO = "info"
	CONST_DEFAULT_LEVEL_MAJOR = "major"
	CONST_DEFAULT_LEVEL_MINOR = "minor"
	CONST_DEFAULT_LEVEL_WARN = "warn"
	CONST_LEVEL_CRIT = "crit"
	CONST_LEVEL_DEBUG0 = "debug0"
	CONST_LEVEL_DEBUG1 = "debug1"
	CONST_LEVEL_DEBUG2 = "debug2"
	CONST_LEVEL_DEBUG3 = "debug3"
	CONST_LEVEL_DEBUG4 = "debug4"
	CONST_LEVEL_INFO = "info"
	CONST_LEVEL_MAJOR = "major"
	CONST_LEVEL_MINOR = "minor"
	CONST_LEVEL_WARN = "warn"

class VnicRackServerDiscoveryProfile(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"VnicRackServerDiscoveryProfile")

	@staticmethod
	def ClassId():
		return "vnicRackServerDiscoveryProfile"

	DESCR = "Descr"
	DN = "Dn"
	MAX_PORTS = "MaxPorts"
	NAME = "Name"
	POLICY_LEVEL = "PolicyLevel"
	POLICY_OWNER = "PolicyOwner"
	RN = "Rn"
	STATUS = "Status"

	CONST_INT_ID_NONE = "none"
	CONST_POLICY_OWNER_LOCAL = "local"
	CONST_POLICY_OWNER_PENDING_POLICY = "pending-policy"
	CONST_POLICY_OWNER_POLICY = "policy"

class BiosVfPOSTErrorPause(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"BiosVfPOSTErrorPause")

	@staticmethod
	def ClassId():
		return "biosVfPOSTErrorPause"

	DN = "Dn"
	RN = "Rn"
	STATUS = "Status"
	VP_POSTERROR_PAUSE = "VpPOSTErrorPause"

	CONST_VP_POSTERROR_PAUSE_DISABLED = "disabled"
	CONST_VP_POSTERROR_PAUSE_ENABLED = "enabled"
	CONST_VP_POSTERROR_PAUSE_PLATFORM_DEFAULT = "platform-default"
	CONST_VP_POSTERROR_PAUSE_PLATFORM_RECOMMENDED = "platform-recommended"

class FabricPooledVlan(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"FabricPooledVlan")

	@staticmethod
	def ClassId():
		return "fabricPooledVlan"

	ASSIGNED = "Assigned"
	ASSIGNED_TO_DN = "AssignedToDn"
	CONFIG_ISSUES = "ConfigIssues"
	DN = "Dn"
	NAME = "Name"
	PEER_DN = "PeerDn"
	POOLABLE_DN = "PoolableDn"
	PREV_ASSIGNED_TO_DN = "PrevAssignedToDn"
	RN = "Rn"
	STATUS = "Status"

	CONST_ASSIGNED_FALSE = "false"
	CONST_ASSIGNED_NO = "no"
	CONST_ASSIGNED_TRUE = "true"
	CONST_ASSIGNED_YES = "yes"

class GmetaProp(ManagedObject):
	def __init__(self):
		ManagedObject.__init__(self,"GmetaProp")

	@staticmethod
	def ClassId():
		return "gmetaProp"

	DN = "Dn"
	NAME = "Name"
	ORDER = "Order"
	PROP_ID = "PropId"
	RN = "Rn"
	STATUS = "Status"

	CONST_PROP_ID_AAA_AUTH_METHOD_DESCR = "aaa_AuthMethod_descr"
	CONST_PROP_ID_AAA_AUTH_METHOD_NAME = "aaa_AuthMethod_name"
	CONST_PROP_ID_AAA_AUTH_METHOD_OPER_PROVIDER_GROUP = "aaa_AuthMethod_operProviderGroup"
	CONST_PROP_ID_AAA_AUTH_METHOD_OPER_REALM = "aaa_AuthMethod_operRealm"
	CONST_PROP_ID_AAA_AUTH_METHOD_PROVIDER_GROUP = "aaa_AuthMethod_providerGroup"
	CONST_PROP_ID_AAA_AUTH_METHOD_REALM = "aaa_AuthMethod_realm"
	CONST_PROP_ID_AAA_AUTH_METHOD_USE2_FACTOR = "aaa_AuthMethod_use2Factor"
	CONST_PROP_ID_AAA_AUTH_REALM_FSM_STAGE_DESCR = "aaa_AuthRealmFsmStage_descr"
	CONST_PROP_ID_AAA_AUTH_REALM_FSM_STAGE_LAST_UPDATE_TIME = "aaa_AuthRealmFsmStage_lastUpdateTime"
	CONST_PROP_ID_AAA_AUTH_REALM_FSM_STAGE_NAME = "aaa_AuthRealmFsmStage_name"
	CONST_PROP_ID_AAA_AUTH_REALM_FSM_STAGE_ORDER = "aaa_AuthRealmFsmStage_order"
	CONST_PROP_ID_AAA_AUTH_REALM_FSM_STAGE_RETRY = "aaa_AuthRealmFsmStage_retry"
	CONST_PROP_ID_AAA_AUTH_REALM_FSM_STAGE_STAGE_STATUS = "aaa_AuthRealmFsmStage_stageStatus"
	CONST_PROP_ID_AAA_AUTH_REALM_FSM_COMPLETION_TIME = "aaa_AuthRealmFsm_completionTime"
	CONST_PROP_ID_AAA_AUTH_REALM_FSM_CURRENT_FSM = "aaa_AuthRealmFsm_currentFsm"
	CONST_PROP_ID_AAA_AUTH_REALM_FSM_DESCR = "aaa_AuthRealmFsm_descr"
	CONST_PROP_ID_AAA_AUTH_REALM_FSM_FSM_STATUS = "aaa_AuthRealmFsm_fsmStatus"
	CONST_PROP_ID_AAA_AUTH_REALM_FSM_INSTANCE_ID = "aaa_AuthRealmFsm_instanceId"
	CONST_PROP_ID_AAA_AUTH_REALM_FSM_PROGRESS = "aaa_AuthRealmFsm_progress"
	CONST_PROP_ID_AAA_AUTH_REALM_FSM_RMT_ERR_CODE = "aaa_AuthRealmFsm_rmtErrCode"
	CONST_PROP_ID_AAA_AUTH_REALM_FSM_RMT_ERR_DESCR = "aaa_AuthRealmFsm_rmtErrDescr"
	CONST_PROP_ID_AAA_AUTH_REALM_FSM_RMT_RSLT = "aaa_AuthRealmFsm_rmtRslt"
	CONST_PROP_ID_AAA_AUTH_REALM_CON_LOGIN = "aaa_AuthRealm_conLogin"
	CONST_PROP_ID_AAA_AUTH_REALM_DEF_LOGIN = "aaa_AuthRealm_defLogin"
	CONST_PROP_ID_AAA_AUTH_REALM_DEF_ROLE_POLICY = "aaa_AuthRealm_defRolePolicy"
	CONST_PROP_ID_AAA_AUTH_REALM_DESCR = "aaa_AuthRealm_descr"
	CONST_PROP_ID_AAA_AUTH_REALM_FSM_DESCR = "aaa_AuthRealm_fsmDescr"
	CONST_PROP_ID_AAA_AUTH_REALM_FSM_PREV = "aaa_AuthRealm_fsmPrev"
	CONST_PROP_ID_AAA_AUTH_REALM_FSM_PROGR = "aaa_AuthRealm_fsmProgr"
	CONST_PROP_ID_AAA_AUTH_REALM_FSM_RMT_INV_ERR_CODE = "aaa_AuthRealm_fsmRmtInvErrCode"
	CONST_PROP_ID_AAA_AUTH_REALM_FSM_RMT_INV_ERR_DESCR = "aaa_AuthRealm_fsmRmtInvErrDescr"
	CONST_PROP_ID_AAA_AUTH_REALM_FSM_RMT_INV_RSLT = "aaa_AuthRealm_fsmRmtInvRslt"
	CONST_PROP_ID_AAA_AUTH_REALM_FSM_STAGE_DESCR = "aaa_AuthRealm_fsmStageDescr"
	CONST_PROP_ID_AAA_AUTH_REALM_FSM_STAMP = "aaa_AuthRealm_fsmStamp"
	CONST_PROP_ID_AAA_AUTH_REALM_FSM_STATUS = "aaa_AuthRealm_fsmStatus"
	CONST_PROP_ID_AAA_AUTH_REALM_FSM_TRY = "aaa_AuthRealm_fsmTry"
	CONST_PROP_ID_AAA_AUTH_REALM_INT_ID = "aaa_AuthRealm_intId"
	CONST_PROP_ID_AAA_AUTH_REALM_NAME = "aaa_AuthRealm_name"
	CONST_PROP_ID_AAA_AUTH_REALM_POLICY_LEVEL = "aaa_AuthRealm_policyLevel"
	CONST_PROP_ID_AAA_AUTH_REALM_POLICY_OWNER = "aaa_AuthRealm_policyOwner"
	CONST_PROP_ID_AAA_BANNER_DESCR = "aaa_Banner_descr"
	CONST_PROP_ID_AAA_BANNER_INT_ID = "aaa_Banner_intId"
	CONST_PROP_ID_AAA_BANNER_MESSAGE = "aaa_Banner_message"
	CONST_PROP_ID_AAA_BANNER_NAME = "aaa_Banner_name"
	CONST_PROP_ID_AAA_BANNER_POLICY_LEVEL = "aaa_Banner_policyLevel"
	CONST_PROP_ID_AAA_BANNER_POLICY_OWNER = "aaa_Banner_policyOwner"
	CONST_PROP_ID_AAA_CIMC_SESSION_ADMIN_STATE = "aaa_CimcSession_adminState"
	CONST_PROP_ID_AAA_CIMC_SESSION_CIMC_ADDR = "aaa_CimcSession_cimcAddr"
	CONST_PROP_ID_AAA_CIMC_SESSION_ID = "aaa_CimcSession_id"
	CONST_PROP_ID_AAA_CIMC_SESSION_INT_DEL = "aaa_CimcSession_intDel"
	CONST_PROP_ID_AAA_CIMC_SESSION_IS_DELETE = "aaa_CimcSession_isDelete"
	CONST_PROP_ID_AAA_CIMC_SESSION_LAST_UPDATED_TIME = "aaa_CimcSession_lastUpdatedTime"
	CONST_PROP_ID_AAA_CIMC_SESSION_LOGIN_TIME = "aaa_CimcSession_loginTime"
	CONST_PROP_ID_AAA_CIMC_SESSION_LS_DN = "aaa_CimcSession_lsDn"
	CONST_PROP_ID_AAA_CIMC_SESSION_PID = "aaa_CimcSession_pid"
	CONST_PROP_ID_AAA_CIMC_SESSION_PN_DN = "aaa_CimcSession_pnDn"
	CONST_PROP_ID_AAA_CIMC_SESSION_PRIV = "aaa_CimcSession_priv"
	CONST_PROP_ID_AAA_CIMC_SESSION_SOURCE_ADDR = "aaa_CimcSession_sourceAddr"
	CONST_PROP_ID_AAA_CIMC_SESSION_TYPE = "aaa_CimcSession_type"
	CONST_PROP_ID_AAA_CIMC_SESSION_USER = "aaa_CimcSession_user"
	CONST_PROP_ID_AAA_CONFIG_DESCR = "aaa_Config_descr"
	CONST_PROP_ID_AAA_CONFIG_NAME = "aaa_Config_name"
	CONST_PROP_ID_AAA_CONFIG_OPER_PROVIDER_GROUP = "aaa_Config_operProviderGroup"
	CONST_PROP_ID_AAA_CONFIG_OPER_REALM = "aaa_Config_operRealm"
	CONST_PROP_ID_AAA_CONFIG_PROVIDER_GROUP = "aaa_Config_providerGroup"
	CONST_PROP_ID_AAA_CONFIG_REALM = "aaa_Config_realm"
	CONST_PROP_ID_AAA_CONFIG_USE2_FACTOR = "aaa_Config_use2Factor"
	CONST_PROP_ID_AAA_CONSOLE_AUTH_DESCR = "aaa_ConsoleAuth_descr"
	CONST_PROP_ID_AAA_CONSOLE_AUTH_NAME = "aaa_ConsoleAuth_name"
	CONST_PROP_ID_AAA_CONSOLE_AUTH_OPER_PROVIDER_GROUP = "aaa_ConsoleAuth_operProviderGroup"
	CONST_PROP_ID_AAA_CONSOLE_AUTH_OPER_REALM = "aaa_ConsoleAuth_operRealm"
	CONST_PROP_ID_AAA_CONSOLE_AUTH_PROVIDER_GROUP = "aaa_ConsoleAuth_providerGroup"
	CONST_PROP_ID_AAA_CONSOLE_AUTH_REALM = "aaa_ConsoleAuth_realm"
	CONST_PROP_ID_AAA_CONSOLE_AUTH_USE2_FACTOR = "aaa_ConsoleAuth_use2Factor"
	CONST_PROP_ID_AAA_DEFAULT_AUTH_DESCR = "aaa_DefaultAuth_descr"
	CONST_PROP_ID_AAA_DEFAULT_AUTH_NAME = "aaa_DefaultAuth_name"
	CONST_PROP_ID_AAA_DEFAULT_AUTH_OPER_PROVIDER_GROUP = "aaa_DefaultAuth_operProviderGroup"
	CONST_PROP_ID_AAA_DEFAULT_AUTH_OPER_REALM = "aaa_DefaultAuth_operRealm"
	CONST_PROP_ID_AAA_DEFAULT_AUTH_PROVIDER_GROUP = "aaa_DefaultAuth_providerGroup"
	CONST_PROP_ID_AAA_DEFAULT_AUTH_REALM = "aaa_DefaultAuth_realm"
	CONST_PROP_ID_AAA_DEFAULT_AUTH_REFRESH_PERIOD = "aaa_DefaultAuth_refreshPeriod"
	CONST_PROP_ID_AAA_DEFAULT_AUTH_SESSION_TIMEOUT = "aaa_DefaultAuth_sessionTimeout"
	CONST_PROP_ID_AAA_DEFAULT_AUTH_USE2_FACTOR = "aaa_DefaultAuth_use2Factor"
	CONST_PROP_ID_AAA_DEFINITION_DESCR = "aaa_Definition_descr"
	CONST_PROP_ID_AAA_DEFINITION_INT_ID = "aaa_Definition_intId"
	CONST_PROP_ID_AAA_DEFINITION_NAME = "aaa_Definition_name"
	CONST_PROP_ID_AAA_DEFINITION_POLICY_LEVEL = "aaa_Definition_policyLevel"
	CONST_PROP_ID_AAA_DEFINITION_POLICY_OWNER = "aaa_Definition_policyOwner"
	CONST_PROP_ID_AAA_DOMAIN_AUTH_DESCR = "aaa_DomainAuth_descr"
	CONST_PROP_ID_AAA_DOMAIN_AUTH_NAME = "aaa_DomainAuth_name"
	CONST_PROP_ID_AAA_DOMAIN_AUTH_OPER_PROVIDER_GROUP = "aaa_DomainAuth_operProviderGroup"
	CONST_PROP_ID_AAA_DOMAIN_AUTH_OPER_REALM = "aaa_DomainAuth_operRealm"
	CONST_PROP_ID_AAA_DOMAIN_AUTH_PROVIDER_GROUP = "aaa_DomainAuth_providerGroup"
	CONST_PROP_ID_AAA_DOMAIN_AUTH_REALM = "aaa_DomainAuth_realm"
	CONST_PROP_ID_AAA_DOMAIN_AUTH_USE2_FACTOR = "aaa_DomainAuth_use2Factor"
	CONST_PROP_ID_AAA_DOMAIN_DESCR = "aaa_Domain_descr"
	CONST_PROP_ID_AAA_DOMAIN_NAME = "aaa_Domain_name"
	CONST_PROP_ID_AAA_DOMAIN_REFRESH_PERIOD = "aaa_Domain_refreshPeriod"
	CONST_PROP_ID_AAA_DOMAIN_SESSION_TIMEOUT = "aaa_Domain_sessionTimeout"
	CONST_PROP_ID_AAA_EP_AUTH_PROFILE_DESCR = "aaa_EpAuthProfile_descr"
	CONST_PROP_ID_AAA_EP_AUTH_PROFILE_INT_ID = "aaa_EpAuthProfile_intId"
	CONST_PROP_ID_AAA_EP_AUTH_PROFILE_NAME = "aaa_EpAuthProfile_name"
	CONST_PROP_ID_AAA_EP_AUTH_PROFILE_POLICY_LEVEL = "aaa_EpAuthProfile_policyLevel"
	CONST_PROP_ID_AAA_EP_AUTH_PROFILE_POLICY_OWNER = "aaa_EpAuthProfile_policyOwner"
	CONST_PROP_ID_AAA_EP_FSM_STAGE_DESCR = "aaa_EpFsmStage_descr"
	CONST_PROP_ID_AAA_EP_FSM_STAGE_LAST_UPDATE_TIME = "aaa_EpFsmStage_lastUpdateTime"
	CONST_PROP_ID_AAA_EP_FSM_STAGE_NAME = "aaa_EpFsmStage_name"
	CONST_PROP_ID_AAA_EP_FSM_STAGE_ORDER = "aaa_EpFsmStage_order"
	CONST_PROP_ID_AAA_EP_FSM_STAGE_RETRY = "aaa_EpFsmStage_retry"
	CONST_PROP_ID_AAA_EP_FSM_STAGE_STAGE_STATUS = "aaa_EpFsmStage_stageStatus"
	CONST_PROP_ID_AAA_EP_FSM_TASK_COMPLETION = "aaa_EpFsmTask_completion"
	CONST_PROP_ID_AAA_EP_FSM_TASK_FLAGS = "aaa_EpFsmTask_flags"
	CONST_PROP_ID_AAA_EP_FSM_TASK_ITEM = "aaa_EpFsmTask_item"
	CONST_PROP_ID_AAA_EP_FSM_TASK_SEQ_ID = "aaa_EpFsmTask_seqId"
	CONST_PROP_ID_AAA_EP_FSM_COMPLETION_TIME = "aaa_EpFsm_completionTime"
	CONST_PROP_ID_AAA_EP_FSM_CURRENT_FSM = "aaa_EpFsm_currentFsm"
	CONST_PROP_ID_AAA_EP_FSM_DESCR = "aaa_EpFsm_descr"
	CONST_PROP_ID_AAA_EP_FSM_FSM_STATUS = "aaa_EpFsm_fsmStatus"
	CONST_PROP_ID_AAA_EP_FSM_INSTANCE_ID = "aaa_EpFsm_instanceId"
	CONST_PROP_ID_AAA_EP_FSM_PROGRESS = "aaa_EpFsm_progress"
	CONST_PROP_ID_AAA_EP_FSM_RMT_ERR_CODE = "aaa_EpFsm_rmtErrCode"
	CONST_PROP_ID_AAA_EP_FSM_RMT_ERR_DESCR = "aaa_EpFsm_rmtErrDescr"
	CONST_PROP_ID_AAA_EP_FSM_RMT_RSLT = "aaa_EpFsm_rmtRslt"
	CONST_PROP_ID_AAA_EP_LOGIN_DESCR = "aaa_EpLogin_descr"
	CONST_PROP_ID_AAA_EP_LOGIN_ID = "aaa_EpLogin_id"
	CONST_PROP_ID_AAA_EP_LOGIN_INT_ID = "aaa_EpLogin_intId"
	CONST_PROP_ID_AAA_EP_LOGIN_LOCAL_HOST = "aaa_EpLogin_localHost"
	CONST_PROP_ID_AAA_EP_LOGIN_NAME = "aaa_EpLogin_name"
	CONST_PROP_ID_AAA_EP_LOGIN_POLICY_LEVEL = "aaa_EpLogin_policyLevel"
	CONST_PROP_ID_AAA_EP_LOGIN_POLICY_OWNER = "aaa_EpLogin_policyOwner"
	CONST_PROP_ID_AAA_EP_LOGIN_REMOTE_HOST = "aaa_EpLogin_remoteHost"
	CONST_PROP_ID_AAA_EP_LOGIN_SESSION = "aaa_EpLogin_session"
	CONST_PROP_ID_AAA_EP_LOGIN_SWITCH_ID = "aaa_EpLogin_switchId"
	CONST_PROP_ID_AAA_EP_USER_CONFIG_STATE = "aaa_EpUser_configState"
	CONST_PROP_ID_AAA_EP_USER_CONFIG_STATUS_MESSAGE = "aaa_EpUser_configStatusMessage"
	CONST_PROP_ID_AAA_EP_USER_DESCR = "aaa_EpUser_descr"
	CONST_PROP_ID_AAA_EP_USER_NAME = "aaa_EpUser_name"
	CONST_PROP_ID_AAA_EP_USER_PRIV = "aaa_EpUser_priv"
	CONST_PROP_ID_AAA_EP_USER_PWD = "aaa_EpUser_pwd"
	CONST_PROP_ID_AAA_EP_USER_PWD_SET = "aaa_EpUser_pwdSet"
	CONST_PROP_ID_AAA_EP_DESCR = "aaa_Ep_descr"
	CONST_PROP_ID_AAA_EP_FSM_DESCR = "aaa_Ep_fsmDescr"
	CONST_PROP_ID_AAA_EP_FSM_PREV = "aaa_Ep_fsmPrev"
	CONST_PROP_ID_AAA_EP_FSM_PROGR = "aaa_Ep_fsmProgr"
	CONST_PROP_ID_AAA_EP_FSM_RMT_INV_ERR_CODE = "aaa_Ep_fsmRmtInvErrCode"
	CONST_PROP_ID_AAA_EP_FSM_RMT_INV_ERR_DESCR = "aaa_Ep_fsmRmtInvErrDescr"
	CONST_PROP_ID_AAA_EP_FSM_RMT_INV_RSLT = "aaa_Ep_fsmRmtInvRslt"
	CONST_PROP_ID_AAA_EP_FSM_STAGE_DESCR = "aaa_Ep_fsmStageDescr"
	CONST_PROP_ID_AAA_EP_FSM_STAMP = "aaa_Ep_fsmStamp"
	CONST_PROP_ID_AAA_EP_FSM_STATUS = "aaa_Ep_fsmStatus"
	CONST_PROP_ID_AAA_EP_FSM_TRY = "aaa_Ep_fsmTry"
	CONST_PROP_ID_AAA_EP_INT_ID = "aaa_Ep_intId"
	CONST_PROP_ID_AAA_EP_NAME = "aaa_Ep_name"
	CONST_PROP_ID_AAA_EP_POLICY_LEVEL = "aaa_Ep_policyLevel"
	CONST_PROP_ID_AAA_EP_POLICY_OWNER = "aaa_Ep_policyOwner"
	CONST_PROP_ID_AAA_EP_RETRIES = "aaa_Ep_retries"
	CONST_PROP_ID_AAA_EP_TIMEOUT = "aaa_Ep_timeout"
	CONST_PROP_ID_AAA_EXT_MGMT_CUT_THRU_TKN_AUTH_DOMAIN = "aaa_ExtMgmtCutThruTkn_authDomain"
	CONST_PROP_ID_AAA_EXT_MGMT_CUT_THRU_TKN_AUTH_USER = "aaa_ExtMgmtCutThruTkn_authUser"
	CONST_PROP_ID_AAA_EXT_MGMT_CUT_THRU_TKN_CREATION_TIME = "aaa_ExtMgmtCutThruTkn_creationTime"
	CONST_PROP_ID_AAA_EXT_MGMT_CUT_THRU_TKN_DESCR = "aaa_ExtMgmtCutThruTkn_descr"
	CONST_PROP_ID_AAA_EXT_MGMT_CUT_THRU_TKN_INT_ID = "aaa_ExtMgmtCutThruTkn_intId"
	CONST_PROP_ID_AAA_EXT_MGMT_CUT_THRU_TKN_LOCALES = "aaa_ExtMgmtCutThruTkn_locales"
	CONST_PROP_ID_AAA_EXT_MGMT_CUT_THRU_TKN_NAME = "aaa_ExtMgmtCutThruTkn_name"
	CONST_PROP_ID_AAA_EXT_MGMT_CUT_THRU_TKN_PN_DN = "aaa_ExtMgmtCutThruTkn_pnDn"
	CONST_PROP_ID_AAA_EXT_MGMT_CUT_THRU_TKN_POLICY_LEVEL = "aaa_ExtMgmtCutThruTkn_policyLevel"
	CONST_PROP_ID_AAA_EXT_MGMT_CUT_THRU_TKN_POLICY_OWNER = "aaa_ExtMgmtCutThruTkn_policyOwner"
	CONST_PROP_ID_AAA_EXT_MGMT_CUT_THRU_TKN_PRIV = "aaa_ExtMgmtCutThruTkn_priv"
	CONST_PROP_ID_AAA_EXT_MGMT_CUT_THRU_TKN_REMOTE = "aaa_ExtMgmtCutThruTkn_remote"
	CONST_PROP_ID_AAA_EXT_MGMT_CUT_THRU_TKN_TOKEN = "aaa_ExtMgmtCutThruTkn_token"
	CONST_PROP_ID_AAA_EXT_MGMT_CUT_THRU_TKN_TYPE = "aaa_ExtMgmtCutThruTkn_type"
	CONST_PROP_ID_AAA_EXT_MGMT_CUT_THRU_TKN_USER = "aaa_ExtMgmtCutThruTkn_user"
	CONST_PROP_ID_AAA_ITEM_DESCR = "aaa_Item_descr"
	CONST_PROP_ID_AAA_ITEM_NAME = "aaa_Item_name"
	CONST_PROP_ID_AAA_LDAP_EP_FSM_STAGE_DESCR = "aaa_LdapEpFsmStage_descr"
	CONST_PROP_ID_AAA_LDAP_EP_FSM_STAGE_LAST_UPDATE_TIME = "aaa_LdapEpFsmStage_lastUpdateTime"
	CONST_PROP_ID_AAA_LDAP_EP_FSM_STAGE_NAME = "aaa_LdapEpFsmStage_name"
	CONST_PROP_ID_AAA_LDAP_EP_FSM_STAGE_ORDER = "aaa_LdapEpFsmStage_order"
	CONST_PROP_ID_AAA_LDAP_EP_FSM_STAGE_RETRY = "aaa_LdapEpFsmStage_retry"
	CONST_PROP_ID_AAA_LDAP_EP_FSM_STAGE_STAGE_STATUS = "aaa_LdapEpFsmStage_stageStatus"
	CONST_PROP_ID_AAA_LDAP_EP_FSM_COMPLETION_TIME = "aaa_LdapEpFsm_completionTime"
	CONST_PROP_ID_AAA_LDAP_EP_FSM_CURRENT_FSM = "aaa_LdapEpFsm_currentFsm"
	CONST_PROP_ID_AAA_LDAP_EP_FSM_DESCR = "aaa_LdapEpFsm_descr"
	CONST_PROP_ID_AAA_LDAP_EP_FSM_FSM_STATUS = "aaa_LdapEpFsm_fsmStatus"
	CONST_PROP_ID_AAA_LDAP_EP_FSM_INSTANCE_ID = "aaa_LdapEpFsm_instanceId"
	CONST_PROP_ID_AAA_LDAP_EP_FSM_PROGRESS = "aaa_LdapEpFsm_progress"
	CONST_PROP_ID_AAA_LDAP_EP_FSM_RMT_ERR_CODE = "aaa_LdapEpFsm_rmtErrCode"
	CONST_PROP_ID_AAA_LDAP_EP_FSM_RMT_ERR_DESCR = "aaa_LdapEpFsm_rmtErrDescr"
	CONST_PROP_ID_AAA_LDAP_EP_FSM_RMT_RSLT = "aaa_LdapEpFsm_rmtRslt"
	CONST_PROP_ID_AAA_LDAP_EP_ATTRIBUTE = "aaa_LdapEp_attribute"
	CONST_PROP_ID_AAA_LDAP_EP_BASEDN = "aaa_LdapEp_basedn"
	CONST_PROP_ID_AAA_LDAP_EP_DESCR = "aaa_LdapEp_descr"
	CONST_PROP_ID_AAA_LDAP_EP_FILTER = "aaa_LdapEp_filter"
	CONST_PROP_ID_AAA_LDAP_EP_FSM_DESCR = "aaa_LdapEp_fsmDescr"
	CONST_PROP_ID_AAA_LDAP_EP_FSM_PREV = "aaa_LdapEp_fsmPrev"
	CONST_PROP_ID_AAA_LDAP_EP_FSM_PROGR = "aaa_LdapEp_fsmProgr"
	CONST_PROP_ID_AAA_LDAP_EP_FSM_RMT_INV_ERR_CODE = "aaa_LdapEp_fsmRmtInvErrCode"
	CONST_PROP_ID_AAA_LDAP_EP_FSM_RMT_INV_ERR_DESCR = "aaa_LdapEp_fsmRmtInvErrDescr"
	CONST_PROP_ID_AAA_LDAP_EP_FSM_RMT_INV_RSLT = "aaa_LdapEp_fsmRmtInvRslt"
	CONST_PROP_ID_AAA_LDAP_EP_FSM_STAGE_DESCR = "aaa_LdapEp_fsmStageDescr"
	CONST_PROP_ID_AAA_LDAP_EP_FSM_STAMP = "aaa_LdapEp_fsmStamp"
	CONST_PROP_ID_AAA_LDAP_EP_FSM_STATUS = "aaa_LdapEp_fsmStatus"
	CONST_PROP_ID_AAA_LDAP_EP_FSM_TRY = "aaa_LdapEp_fsmTry"
	CONST_PROP_ID_AAA_LDAP_EP_INT_ID = "aaa_LdapEp_intId"
	CONST_PROP_ID_AAA_LDAP_EP_NAME = "aaa_LdapEp_name"
	CONST_PROP_ID_AAA_LDAP_EP_POLICY_LEVEL = "aaa_LdapEp_policyLevel"
	CONST_PROP_ID_AAA_LDAP_EP_POLICY_OWNER = "aaa_LdapEp_policyOwner"
	CONST_PROP_ID_AAA_LDAP_EP_RETRIES = "aaa_LdapEp_retries"
	CONST_PROP_ID_AAA_LDAP_EP_TIMEOUT = "aaa_LdapEp_timeout"
	CONST_PROP_ID_AAA_LDAP_GROUP_RULE_AUTHORIZATION = "aaa_LdapGroupRule_authorization"
	CONST_PROP_ID_AAA_LDAP_GROUP_RULE_DESCR = "aaa_LdapGroupRule_descr"
	CONST_PROP_ID_AAA_LDAP_GROUP_RULE_NAME = "aaa_LdapGroupRule_name"
	CONST_PROP_ID_AAA_LDAP_GROUP_RULE_TARGET_ATTR = "aaa_LdapGroupRule_targetAttr"
	CONST_PROP_ID_AAA_LDAP_GROUP_RULE_TRAVERSAL = "aaa_LdapGroupRule_traversal"
	CONST_PROP_ID_AAA_LDAP_GROUP_RULE_USE_PRIMARY_GROUP = "aaa_LdapGroupRule_usePrimaryGroup"
	CONST_PROP_ID_AAA_LDAP_GROUP_DESCR = "aaa_LdapGroup_descr"
	CONST_PROP_ID_AAA_LDAP_GROUP_NAME = "aaa_LdapGroup_name"
	CONST_PROP_ID_AAA_LDAP_PROVIDER_ATTRIBUTE = "aaa_LdapProvider_attribute"
	CONST_PROP_ID_AAA_LDAP_PROVIDER_BASEDN = "aaa_LdapProvider_basedn"
	CONST_PROP_ID_AAA_LDAP_PROVIDER_DESCR = "aaa_LdapProvider_descr"
	CONST_PROP_ID_AAA_LDAP_PROVIDER_ENABLE_SSL = "aaa_LdapProvider_enableSSL"
	CONST_PROP_ID_AAA_LDAP_PROVIDER_ENC_KEY = "aaa_LdapProvider_encKey"
	CONST_PROP_ID_AAA_LDAP_PROVIDER_FILTER = "aaa_LdapProvider_filter"
	CONST_PROP_ID_AAA_LDAP_PROVIDER_KEY = "aaa_LdapProvider_key"
	CONST_PROP_ID_AAA_LDAP_PROVIDER_KEY_SET = "aaa_LdapProvider_keySet"
	CONST_PROP_ID_AAA_LDAP_PROVIDER_NAME = "aaa_LdapProvider_name"
	CONST_PROP_ID_AAA_LDAP_PROVIDER_ORDER = "aaa_LdapProvider_order"
	CONST_PROP_ID_AAA_LDAP_PROVIDER_PORT = "aaa_LdapProvider_port"
	CONST_PROP_ID_AAA_LDAP_PROVIDER_RETRIES = "aaa_LdapProvider_retries"
	CONST_PROP_ID_AAA_LDAP_PROVIDER_ROOTDN = "aaa_LdapProvider_rootdn"
	CONST_PROP_ID_AAA_LDAP_PROVIDER_TIMEOUT = "aaa_LdapProvider_timeout"
	CONST_PROP_ID_AAA_LDAP_PROVIDER_VENDOR = "aaa_LdapProvider_vendor"
	CONST_PROP_ID_AAA_LOCALE_CONFIG_STATE = "aaa_Locale_configState"
	CONST_PROP_ID_AAA_LOCALE_CONFIG_STATUS_MESSAGE = "aaa_Locale_configStatusMessage"
	CONST_PROP_ID_AAA_LOCALE_DESCR = "aaa_Locale_descr"
	CONST_PROP_ID_AAA_LOCALE_INT_ID = "aaa_Locale_intId"
	CONST_PROP_ID_AAA_LOCALE_NAME = "aaa_Locale_name"
	CONST_PROP_ID_AAA_LOCALE_POLICY_LEVEL = "aaa_Locale_policyLevel"
	CONST_PROP_ID_AAA_LOCALE_POLICY_OWNER = "aaa_Locale_policyOwner"
	CONST_PROP_ID_AAA_LOG_MAX_SIZE = "aaa_Log_maxSize"
	CONST_PROP_ID_AAA_LOG_PURGE_WINDOW = "aaa_Log_purgeWindow"
	CONST_PROP_ID_AAA_LOG_SIZE = "aaa_Log_size"
	CONST_PROP_ID_AAA_MOD_LR_AFFECTED = "aaa_ModLR_affected"
	CONST_PROP_ID_AAA_MOD_LR_CAUSE = "aaa_ModLR_cause"
	CONST_PROP_ID_AAA_MOD_LR_CHANGE_SET = "aaa_ModLR_changeSet"
	CONST_PROP_ID_AAA_MOD_LR_CODE = "aaa_ModLR_code"
	CONST_PROP_ID_AAA_MOD_LR_CREATED = "aaa_ModLR_created"
	CONST_PROP_ID_AAA_MOD_LR_DESCR = "aaa_ModLR_descr"
	CONST_PROP_ID_AAA_MOD_LR_ID = "aaa_ModLR_id"
	CONST_PROP_ID_AAA_MOD_LR_IND = "aaa_ModLR_ind"
	CONST_PROP_ID_AAA_MOD_LR_SESSION_ID = "aaa_ModLR_sessionId"
	CONST_PROP_ID_AAA_MOD_LR_SEVERITY = "aaa_ModLR_severity"
	CONST_PROP_ID_AAA_MOD_LR_TRIG = "aaa_ModLR_trig"
	CONST_PROP_ID_AAA_MOD_LR_TX_ID = "aaa_ModLR_txId"
	CONST_PROP_ID_AAA_MOD_LR_USER = "aaa_ModLR_user"
	CONST_PROP_ID_AAA_ORG_CONFIG_STATE = "aaa_Org_configState"
	CONST_PROP_ID_AAA_ORG_CONFIG_STATUS_MESSAGE = "aaa_Org_configStatusMessage"
	CONST_PROP_ID_AAA_ORG_DESCR = "aaa_Org_descr"
	CONST_PROP_ID_AAA_ORG_NAME = "aaa_Org_name"
	CONST_PROP_ID_AAA_ORG_ORG_DN = "aaa_Org_orgDn"
	CONST_PROP_ID_AAA_PRE_LOGIN_BANNER_DESCR = "aaa_PreLoginBanner_descr"
	CONST_PROP_ID_AAA_PRE_LOGIN_BANNER_INT_ID = "aaa_PreLoginBanner_intId"
	CONST_PROP_ID_AAA_PRE_LOGIN_BANNER_MESSAGE = "aaa_PreLoginBanner_message"
	CONST_PROP_ID_AAA_PRE_LOGIN_BANNER_NAME = "aaa_PreLoginBanner_name"
	CONST_PROP_ID_AAA_PRE_LOGIN_BANNER_POLICY_LEVEL = "aaa_PreLoginBanner_policyLevel"
	CONST_PROP_ID_AAA_PRE_LOGIN_BANNER_POLICY_OWNER = "aaa_PreLoginBanner_policyOwner"
	CONST_PROP_ID_AAA_PROVIDER_GROUP_CONFIG_STATE = "aaa_ProviderGroup_configState"
	CONST_PROP_ID_AAA_PROVIDER_GROUP_DESCR = "aaa_ProviderGroup_descr"
	CONST_PROP_ID_AAA_PROVIDER_GROUP_NAME = "aaa_ProviderGroup_name"
	CONST_PROP_ID_AAA_PROVIDER_GROUP_SIZE = "aaa_ProviderGroup_size"
	CONST_PROP_ID_AAA_PROVIDER_REF_DESCR = "aaa_ProviderRef_descr"
	CONST_PROP_ID_AAA_PROVIDER_REF_NAME = "aaa_ProviderRef_name"
	CONST_PROP_ID_AAA_PROVIDER_REF_ORDER = "aaa_ProviderRef_order"
	CONST_PROP_ID_AAA_PROVIDER_DESCR = "aaa_Provider_descr"
	CONST_PROP_ID_AAA_PROVIDER_ENC_KEY = "aaa_Provider_encKey"
	CONST_PROP_ID_AAA_PROVIDER_KEY = "aaa_Provider_key"
	CONST_PROP_ID_AAA_PROVIDER_KEY_SET = "aaa_Provider_keySet"
	CONST_PROP_ID_AAA_PROVIDER_NAME = "aaa_Provider_name"
	CONST_PROP_ID_AAA_PROVIDER_ORDER = "aaa_Provider_order"
	CONST_PROP_ID_AAA_PROVIDER_RETRIES = "aaa_Provider_retries"
	CONST_PROP_ID_AAA_PROVIDER_TIMEOUT = "aaa_Provider_timeout"
	CONST_PROP_ID_AAA_PWD_PROFILE_CHANGE_COUNT = "aaa_PwdProfile_changeCount"
	CONST_PROP_ID_AAA_PWD_PROFILE_CHANGE_DURING_INTERVAL = "aaa_PwdProfile_changeDuringInterval"
	CONST_PROP_ID_AAA_PWD_PROFILE_CHANGE_INTERVAL = "aaa_PwdProfile_changeInterval"
	CONST_PROP_ID_AAA_PWD_PROFILE_DESCR = "aaa_PwdProfile_descr"
	CONST_PROP_ID_AAA_PWD_PROFILE_EXPIRATION_WARN_TIME = "aaa_PwdProfile_expirationWarnTime"
	CONST_PROP_ID_AAA_PWD_PROFILE_HISTORY_COUNT = "aaa_PwdProfile_historyCount"
	CONST_PROP_ID_AAA_PWD_PROFILE_INT_ID = "aaa_PwdProfile_intId"
	CONST_PROP_ID_AAA_PWD_PROFILE_NAME = "aaa_PwdProfile_name"
	CONST_PROP_ID_AAA_PWD_PROFILE_NO_CHANGE_INTERVAL = "aaa_PwdProfile_noChangeInterval"
	CONST_PROP_ID_AAA_PWD_PROFILE_POLICY_LEVEL = "aaa_PwdProfile_policyLevel"
	CONST_PROP_ID_AAA_PWD_PROFILE_POLICY_OWNER = "aaa_PwdProfile_policyOwner"
	CONST_PROP_ID_AAA_RADIUS_EP_FSM_STAGE_DESCR = "aaa_RadiusEpFsmStage_descr"
	CONST_PROP_ID_AAA_RADIUS_EP_FSM_STAGE_LAST_UPDATE_TIME = "aaa_RadiusEpFsmStage_lastUpdateTime"
	CONST_PROP_ID_AAA_RADIUS_EP_FSM_STAGE_NAME = "aaa_RadiusEpFsmStage_name"
	CONST_PROP_ID_AAA_RADIUS_EP_FSM_STAGE_ORDER = "aaa_RadiusEpFsmStage_order"
	CONST_PROP_ID_AAA_RADIUS_EP_FSM_STAGE_RETRY = "aaa_RadiusEpFsmStage_retry"
	CONST_PROP_ID_AAA_RADIUS_EP_FSM_STAGE_STAGE_STATUS = "aaa_RadiusEpFsmStage_stageStatus"
	CONST_PROP_ID_AAA_RADIUS_EP_FSM_COMPLETION_TIME = "aaa_RadiusEpFsm_completionTime"
	CONST_PROP_ID_AAA_RADIUS_EP_FSM_CURRENT_FSM = "aaa_RadiusEpFsm_currentFsm"
	CONST_PROP_ID_AAA_RADIUS_EP_FSM_DESCR = "aaa_RadiusEpFsm_descr"
	CONST_PROP_ID_AAA_RADIUS_EP_FSM_FSM_STATUS = "aaa_RadiusEpFsm_fsmStatus"
	CONST_PROP_ID_AAA_RADIUS_EP_FSM_INSTANCE_ID = "aaa_RadiusEpFsm_instanceId"
	CONST_PROP_ID_AAA_RADIUS_EP_FSM_PROGRESS = "aaa_RadiusEpFsm_progress"
	CONST_PROP_ID_AAA_RADIUS_EP_FSM_RMT_ERR_CODE = "aaa_RadiusEpFsm_rmtErrCode"
	CONST_PROP_ID_AAA_RADIUS_EP_FSM_RMT_ERR_DESCR = "aaa_RadiusEpFsm_rmtErrDescr"
	CONST_PROP_ID_AAA_RADIUS_EP_FSM_RMT_RSLT = "aaa_RadiusEpFsm_rmtRslt"
	CONST_PROP_ID_AAA_RADIUS_EP_DESCR = "aaa_RadiusEp_descr"
	CONST_PROP_ID_AAA_RADIUS_EP_FSM_DESCR = "aaa_RadiusEp_fsmDescr"
	CONST_PROP_ID_AAA_RADIUS_EP_FSM_PREV = "aaa_RadiusEp_fsmPrev"
	CONST_PROP_ID_AAA_RADIUS_EP_FSM_PROGR = "aaa_RadiusEp_fsmProgr"
	CONST_PROP_ID_AAA_RADIUS_EP_FSM_RMT_INV_ERR_CODE = "aaa_RadiusEp_fsmRmtInvErrCode"
	CONST_PROP_ID_AAA_RADIUS_EP_FSM_RMT_INV_ERR_DESCR = "aaa_RadiusEp_fsmRmtInvErrDescr"
	CONST_PROP_ID_AAA_RADIUS_EP_FSM_RMT_INV_RSLT = "aaa_RadiusEp_fsmRmtInvRslt"
	CONST_PROP_ID_AAA_RADIUS_EP_FSM_STAGE_DESCR = "aaa_RadiusEp_fsmStageDescr"
	CONST_PROP_ID_AAA_RADIUS_EP_FSM_STAMP = "aaa_RadiusEp_fsmStamp"
	CONST_PROP_ID_AAA_RADIUS_EP_FSM_STATUS = "aaa_RadiusEp_fsmStatus"
	CONST_PROP_ID_AAA_RADIUS_EP_FSM_TRY = "aaa_RadiusEp_fsmTry"
	CONST_PROP_ID_AAA_RADIUS_EP_INT_ID = "aaa_RadiusEp_intId"
	CONST_PROP_ID_AAA_RADIUS_EP_NAME = "aaa_RadiusEp_name"
	CONST_PROP_ID_AAA_RADIUS_EP_POLICY_LEVEL = "aaa_RadiusEp_policyLevel"
	CONST_PROP_ID_AAA_RADIUS_EP_POLICY_OWNER = "aaa_RadiusEp_policyOwner"
	CONST_PROP_ID_AAA_RADIUS_EP_RETRIES = "aaa_RadiusEp_retries"
	CONST_PROP_ID_AAA_RADIUS_EP_TIMEOUT = "aaa_RadiusEp_timeout"
	CONST_PROP_ID_AAA_RADIUS_PROVIDER_AUTH_PORT = "aaa_RadiusProvider_authPort"
	CONST_PROP_ID_AAA_RADIUS_PROVIDER_DESCR = "aaa_RadiusProvider_descr"
	CONST_PROP_ID_AAA_RADIUS_PROVIDER_ENC_KEY = "aaa_RadiusProvider_encKey"
	CONST_PROP_ID_AAA_RADIUS_PROVIDER_KEY = "aaa_RadiusProvider_key"
	CONST_PROP_ID_AAA_RADIUS_PROVIDER_KEY_SET = "aaa_RadiusProvider_keySet"
	CONST_PROP_ID_AAA_RADIUS_PROVIDER_NAME = "aaa_RadiusProvider_name"
	CONST_PROP_ID_AAA_RADIUS_PROVIDER_ORDER = "aaa_RadiusProvider_order"
	CONST_PROP_ID_AAA_RADIUS_PROVIDER_RETRIES = "aaa_RadiusProvider_retries"
	CONST_PROP_ID_AAA_RADIUS_PROVIDER_SERVICE = "aaa_RadiusProvider_service"
	CONST_PROP_ID_AAA_RADIUS_PROVIDER_TIMEOUT = "aaa_RadiusProvider_timeout"
	CONST_PROP_ID_AAA_REALM_FSM_STAGE_DESCR = "aaa_RealmFsmStage_descr"
	CONST_PROP_ID_AAA_REALM_FSM_STAGE_LAST_UPDATE_TIME = "aaa_RealmFsmStage_lastUpdateTime"
	CONST_PROP_ID_AAA_REALM_FSM_STAGE_NAME = "aaa_RealmFsmStage_name"
	CONST_PROP_ID_AAA_REALM_FSM_STAGE_ORDER = "aaa_RealmFsmStage_order"
	CONST_PROP_ID_AAA_REALM_FSM_STAGE_RETRY = "aaa_RealmFsmStage_retry"
	CONST_PROP_ID_AAA_REALM_FSM_STAGE_STAGE_STATUS = "aaa_RealmFsmStage_stageStatus"
	CONST_PROP_ID_AAA_REALM_FSM_TASK_COMPLETION = "aaa_RealmFsmTask_completion"
	CONST_PROP_ID_AAA_REALM_FSM_TASK_FLAGS = "aaa_RealmFsmTask_flags"
	CONST_PROP_ID_AAA_REALM_FSM_TASK_ITEM = "aaa_RealmFsmTask_item"
	CONST_PROP_ID_AAA_REALM_FSM_TASK_SEQ_ID = "aaa_RealmFsmTask_seqId"
	CONST_PROP_ID_AAA_REALM_FSM_COMPLETION_TIME = "aaa_RealmFsm_completionTime"
	CONST_PROP_ID_AAA_REALM_FSM_CURRENT_FSM = "aaa_RealmFsm_currentFsm"
	CONST_PROP_ID_AAA_REALM_FSM_DESCR = "aaa_RealmFsm_descr"
	CONST_PROP_ID_AAA_REALM_FSM_FSM_STATUS = "aaa_RealmFsm_fsmStatus"
	CONST_PROP_ID_AAA_REALM_FSM_INSTANCE_ID = "aaa_RealmFsm_instanceId"
	CONST_PROP_ID_AAA_REALM_FSM_PROGRESS = "aaa_RealmFsm_progress"
	CONST_PROP_ID_AAA_REALM_FSM_RMT_ERR_CODE = "aaa_RealmFsm_rmtErrCode"
	CONST_PROP_ID_AAA_REALM_FSM_RMT_ERR_DESCR = "aaa_RealmFsm_rmtErrDescr"
	CONST_PROP_ID_AAA_REALM_FSM_RMT_RSLT = "aaa_RealmFsm_rmtRslt"
	CONST_PROP_ID_AAA_REALM_DESCR = "aaa_Realm_descr"
	CONST_PROP_ID_AAA_REALM_FSM_DESCR = "aaa_Realm_fsmDescr"
	CONST_PROP_ID_AAA_REALM_FSM_PREV = "aaa_Realm_fsmPrev"
	CONST_PROP_ID_AAA_REALM_FSM_PROGR = "aaa_Realm_fsmProgr"
	CONST_PROP_ID_AAA_REALM_FSM_RMT_INV_ERR_CODE = "aaa_Realm_fsmRmtInvErrCode"
	CONST_PROP_ID_AAA_REALM_FSM_RMT_INV_ERR_DESCR = "aaa_Realm_fsmRmtInvErrDescr"
	CONST_PROP_ID_AAA_REALM_FSM_RMT_INV_RSLT = "aaa_Realm_fsmRmtInvRslt"
	CONST_PROP_ID_AAA_REALM_FSM_STAGE_DESCR = "aaa_Realm_fsmStageDescr"
	CONST_PROP_ID_AAA_REALM_FSM_STAMP = "aaa_Realm_fsmStamp"
	CONST_PROP_ID_AAA_REALM_FSM_STATUS = "aaa_Realm_fsmStatus"
	CONST_PROP_ID_AAA_REALM_FSM_TRY = "aaa_Realm_fsmTry"
	CONST_PROP_ID_AAA_REALM_INT_ID = "aaa_Realm_intId"
	CONST_PROP_ID_AAA_REALM_NAME = "aaa_Realm_name"
	CONST_PROP_ID_AAA_REALM_POLICY_LEVEL = "aaa_Realm_policyLevel"
	CONST_PROP_ID_AAA_REALM_POLICY_OWNER = "aaa_Realm_policyOwner"
	CONST_PROP_ID_AAA_REMOTE_USER_CONFIG_STATE = "aaa_RemoteUser_configState"
	CONST_PROP_ID_AAA_REMOTE_USER_CONFIG_STATUS_MESSAGE = "aaa_RemoteUser_configStatusMessage"
	CONST_PROP_ID_AAA_REMOTE_USER_DESCR = "aaa_RemoteUser_descr"
	CONST_PROP_ID_AAA_REMOTE_USER_NAME = "aaa_RemoteUser_name"
	CONST_PROP_ID_AAA_REMOTE_USER_PWD = "aaa_RemoteUser_pwd"
	CONST_PROP_ID_AAA_REMOTE_USER_PWD_SET = "aaa_RemoteUser_pwdSet"
	CONST_PROP_ID_AAA_ROLE_CONFIG_STATE = "aaa_Role_configState"
	CONST_PROP_ID_AAA_ROLE_CONFIG_STATUS_MESSAGE = "aaa_Role_configStatusMessage"
	CONST_PROP_ID_AAA_ROLE_DESCR = "aaa_Role_descr"
	CONST_PROP_ID_AAA_ROLE_INT_ID = "aaa_Role_intId"
	CONST_PROP_ID_AAA_ROLE_NAME = "aaa_Role_name"
	CONST_PROP_ID_AAA_ROLE_POLICY_LEVEL = "aaa_Role_policyLevel"
	CONST_PROP_ID_AAA_ROLE_POLICY_OWNER = "aaa_Role_policyOwner"
	CONST_PROP_ID_AAA_ROLE_PRIV = "aaa_Role_priv"
	CONST_PROP_ID_AAA_SESSION_INFO_ADDRESS = "aaa_SessionInfo_address"
	CONST_PROP_ID_AAA_SESSION_INFO_DEST_IP = "aaa_SessionInfo_destIp"
	CONST_PROP_ID_AAA_SESSION_INFO_ETIME = "aaa_SessionInfo_etime"
	CONST_PROP_ID_AAA_SESSION_INFO_ID = "aaa_SessionInfo_id"
	CONST_PROP_ID_AAA_SESSION_INFO_PRIV = "aaa_SessionInfo_priv"
	CONST_PROP_ID_AAA_SESSION_INFO_TYPE = "aaa_SessionInfo_type"
	CONST_PROP_ID_AAA_SESSION_INFO_USER = "aaa_SessionInfo_user"
	CONST_PROP_ID_AAA_SESSION_INFO_USER_TYPE = "aaa_SessionInfo_userType"
	CONST_PROP_ID_AAA_SESSION_LR_AFFECTED = "aaa_SessionLR_affected"
	CONST_PROP_ID_AAA_SESSION_LR_CAUSE = "aaa_SessionLR_cause"
	CONST_PROP_ID_AAA_SESSION_LR_CHANGE_SET = "aaa_SessionLR_changeSet"
	CONST_PROP_ID_AAA_SESSION_LR_CODE = "aaa_SessionLR_code"
	CONST_PROP_ID_AAA_SESSION_LR_CREATED = "aaa_SessionLR_created"
	CONST_PROP_ID_AAA_SESSION_LR_DESCR = "aaa_SessionLR_descr"
	CONST_PROP_ID_AAA_SESSION_LR_ID = "aaa_SessionLR_id"
	CONST_PROP_ID_AAA_SESSION_LR_IND = "aaa_SessionLR_ind"
	CONST_PROP_ID_AAA_SESSION_LR_SESSION_ID = "aaa_SessionLR_sessionId"
	CONST_PROP_ID_AAA_SESSION_LR_SEVERITY = "aaa_SessionLR_severity"
	CONST_PROP_ID_AAA_SESSION_LR_TRIG = "aaa_SessionLR_trig"
	CONST_PROP_ID_AAA_SESSION_LR_TX_ID = "aaa_SessionLR_txId"
	CONST_PROP_ID_AAA_SESSION_LR_USER = "aaa_SessionLR_user"
	CONST_PROP_ID_AAA_SESSION_HOST = "aaa_Session_host"
	CONST_PROP_ID_AAA_SESSION_ID = "aaa_Session_id"
	CONST_PROP_ID_AAA_SESSION_INT_DEL = "aaa_Session_intDel"
	CONST_PROP_ID_AAA_SESSION_LOGIN_TIME = "aaa_Session_loginTime"
	CONST_PROP_ID_AAA_SESSION_PID = "aaa_Session_pid"
	CONST_PROP_ID_AAA_SESSION_REFRESH_PERIOD = "aaa_Session_refreshPeriod"
	CONST_PROP_ID_AAA_SESSION_SESSION_TIMEOUT = "aaa_Session_sessionTimeout"
	CONST_PROP_ID_AAA_SESSION_SWITCH_ID = "aaa_Session_switchId"
	CONST_PROP_ID_AAA_SESSION_TERM = "aaa_Session_term"
	CONST_PROP_ID_AAA_SESSION_UI = "aaa_Session_ui"
	CONST_PROP_ID_AAA_SESSION_USER = "aaa_Session_user"
	CONST_PROP_ID_AAA_SHELL_LOGIN_DESCR = "aaa_ShellLogin_descr"
	CONST_PROP_ID_AAA_SHELL_LOGIN_ID = "aaa_ShellLogin_id"
	CONST_PROP_ID_AAA_SHELL_LOGIN_INT_ID = "aaa_ShellLogin_intId"
	CONST_PROP_ID_AAA_SHELL_LOGIN_LOCAL_HOST = "aaa_ShellLogin_localHost"
	CONST_PROP_ID_AAA_SHELL_LOGIN_NAME = "aaa_ShellLogin_name"
	CONST_PROP_ID_AAA_SHELL_LOGIN_POLICY_LEVEL = "aaa_ShellLogin_policyLevel"
	CONST_PROP_ID_AAA_SHELL_LOGIN_POLICY_OWNER = "aaa_ShellLogin_policyOwner"
	CONST_PROP_ID_AAA_SHELL_LOGIN_REMOTE_HOST = "aaa_ShellLogin_remoteHost"
	CONST_PROP_ID_AAA_SHELL_LOGIN_SESSION = "aaa_ShellLogin_session"
	CONST_PROP_ID_AAA_SHELL_LOGIN_SWITCH_ID = "aaa_ShellLogin_switchId"
	CONST_PROP_ID_AAA_SSH_AUTH_DATA = "aaa_SshAuth_data"
	CONST_PROP_ID_AAA_SSH_AUTH_OLD_STR_TYPE = "aaa_SshAuth_oldStrType"
	CONST_PROP_ID_AAA_SSH_AUTH_STR_TYPE = "aaa_SshAuth_strType"
	CONST_PROP_ID_AAA_SYSTEM_USER_CONFIG_STATE = "aaa_SystemUser_configState"
	CONST_PROP_ID_AAA_SYSTEM_USER_CONFIG_STATUS_MESSAGE = "aaa_SystemUser_configStatusMessage"
	CONST_PROP_ID_AAA_SYSTEM_USER_DESCR = "aaa_SystemUser_descr"
	CONST_PROP_ID_AAA_SYSTEM_USER_NAME = "aaa_SystemUser_name"
	CONST_PROP_ID_AAA_SYSTEM_USER_PWD = "aaa_SystemUser_pwd"
	CONST_PROP_ID_AAA_SYSTEM_USER_PWD_SET = "aaa_SystemUser_pwdSet"
	CONST_PROP_ID_AAA_TACACS_PLUS_EP_FSM_STAGE_DESCR = "aaa_TacacsPlusEpFsmStage_descr"
	CONST_PROP_ID_AAA_TACACS_PLUS_EP_FSM_STAGE_LAST_UPDATE_TIME = "aaa_TacacsPlusEpFsmStage_lastUpdateTime"
	CONST_PROP_ID_AAA_TACACS_PLUS_EP_FSM_STAGE_NAME = "aaa_TacacsPlusEpFsmStage_name"
	CONST_PROP_ID_AAA_TACACS_PLUS_EP_FSM_STAGE_ORDER = "aaa_TacacsPlusEpFsmStage_order"
	CONST_PROP_ID_AAA_TACACS_PLUS_EP_FSM_STAGE_RETRY = "aaa_TacacsPlusEpFsmStage_retry"
	CONST_PROP_ID_AAA_TACACS_PLUS_EP_FSM_STAGE_STAGE_STATUS = "aaa_TacacsPlusEpFsmStage_stageStatus"
	CONST_PROP_ID_AAA_TACACS_PLUS_EP_FSM_COMPLETION_TIME = "aaa_TacacsPlusEpFsm_completionTime"
	CONST_PROP_ID_AAA_TACACS_PLUS_EP_FSM_CURRENT_FSM = "aaa_TacacsPlusEpFsm_currentFsm"
	CONST_PROP_ID_AAA_TACACS_PLUS_EP_FSM_DESCR = "aaa_TacacsPlusEpFsm_descr"
	CONST_PROP_ID_AAA_TACACS_PLUS_EP_FSM_FSM_STATUS = "aaa_TacacsPlusEpFsm_fsmStatus"
	CONST_PROP_ID_AAA_TACACS_PLUS_EP_FSM_INSTANCE_ID = "aaa_TacacsPlusEpFsm_instanceId"
	CONST_PROP_ID_AAA_TACACS_PLUS_EP_FSM_PROGRESS = "aaa_TacacsPlusEpFsm_progress"
	CONST_PROP_ID_AAA_TACACS_PLUS_EP_FSM_RMT_ERR_CODE = "aaa_TacacsPlusEpFsm_rmtErrCode"
	CONST_PROP_ID_AAA_TACACS_PLUS_EP_FSM_RMT_ERR_DESCR = "aaa_TacacsPlusEpFsm_rmtErrDescr"
	CONST_PROP_ID_AAA_TACACS_PLUS_EP_FSM_RMT_RSLT = "aaa_TacacsPlusEpFsm_rmtRslt"
	CONST_PROP_ID_AAA_TACACS_PLUS_EP_DESCR = "aaa_TacacsPlusEp_descr"
	CONST_PROP_ID_AAA_TACACS_PLUS_EP_FSM_DESCR = "aaa_TacacsPlusEp_fsmDescr"
	CONST_PROP_ID_AAA_TACACS_PLUS_EP_FSM_PREV = "aaa_TacacsPlusEp_fsmPrev"
	CONST_PROP_ID_AAA_TACACS_PLUS_EP_FSM_PROGR = "aaa_TacacsPlusEp_fsmProgr"
	CONST_PROP_ID_AAA_TACACS_PLUS_EP_FSM_RMT_INV_ERR_CODE = "aaa_TacacsPlusEp_fsmRmtInvErrCode"
	CONST_PROP_ID_AAA_TACACS_PLUS_EP_FSM_RMT_INV_ERR_DESCR = "aaa_TacacsPlusEp_fsmRmtInvErrDescr"
	CONST_PROP_ID_AAA_TACACS_PLUS_EP_FSM_RMT_INV_RSLT = "aaa_TacacsPlusEp_fsmRmtInvRslt"
	CONST_PROP_ID_AAA_TACACS_PLUS_EP_FSM_STAGE_DESCR = "aaa_TacacsPlusEp_fsmStageDescr"
	CONST_PROP_ID_AAA_TACACS_PLUS_EP_FSM_STAMP = "aaa_TacacsPlusEp_fsmStamp"
	CONST_PROP_ID_AAA_TACACS_PLUS_EP_FSM_STATUS = "aaa_TacacsPlusEp_fsmStatus"
	CONST_PROP_ID_AAA_TACACS_PLUS_EP_FSM_TRY = "aaa_TacacsPlusEp_fsmTry"
	CONST_PROP_ID_AAA_TACACS_PLUS_EP_INT_ID = "aaa_TacacsPlusEp_intId"
	CONST_PROP_ID_AAA_TACACS_PLUS_EP_NAME = "aaa_TacacsPlusEp_name"
	CONST_PROP_ID_AAA_TACACS_PLUS_EP_POLICY_LEVEL = "aaa_TacacsPlusEp_policyLevel"
	CONST_PROP_ID_AAA_TACACS_PLUS_EP_POLICY_OWNER = "aaa_TacacsPlusEp_policyOwner"
	CONST_PROP_ID_AAA_TACACS_PLUS_EP_RETRIES = "aaa_TacacsPlusEp_retries"
	CONST_PROP_ID_AAA_TACACS_PLUS_EP_TIMEOUT = "aaa_TacacsPlusEp_timeout"
	CONST_PROP_ID_AAA_TACACS_PLUS_PROVIDER_DESCR = "aaa_TacacsPlusProvider_descr"
	CONST_PROP_ID_AAA_TACACS_PLUS_PROVIDER_ENC_KEY = "aaa_TacacsPlusProvider_encKey"
	CONST_PROP_ID_AAA_TACACS_PLUS_PROVIDER_KEY = "aaa_TacacsPlusProvider_key"
	CONST_PROP_ID_AAA_TACACS_PLUS_PROVIDER_KEY_SET = "aaa_TacacsPlusProvider_keySet"
	CONST_PROP_ID_AAA_TACACS_PLUS_PROVIDER_NAME = "aaa_TacacsPlusProvider_name"
	CONST_PROP_ID_AAA_TACACS_PLUS_PROVIDER_ORDER = "aaa_TacacsPlusProvider_order"
	CONST_PROP_ID_AAA_TACACS_PLUS_PROVIDER_PORT = "aaa_TacacsPlusProvider_port"
	CONST_PROP_ID_AAA_TACACS_PLUS_PROVIDER_RETRIES = "aaa_TacacsPlusProvider_retries"
	CONST_PROP_ID_AAA_TACACS_PLUS_PROVIDER_TIMEOUT = "aaa_TacacsPlusProvider_timeout"
	CONST_PROP_ID_AAA_USER_ACTION_AFFECTED = "aaa_UserAction_affected"
	CONST_PROP_ID_AAA_USER_ACTION_CAUSE = "aaa_UserAction_cause"
	CONST_PROP_ID_AAA_USER_ACTION_CHANGE_SET = "aaa_UserAction_changeSet"
	CONST_PROP_ID_AAA_USER_ACTION_CODE = "aaa_UserAction_code"
	CONST_PROP_ID_AAA_USER_ACTION_CREATED = "aaa_UserAction_created"
	CONST_PROP_ID_AAA_USER_ACTION_DESCR = "aaa_UserAction_descr"
	CONST_PROP_ID_AAA_USER_ACTION_ID = "aaa_UserAction_id"
	CONST_PROP_ID_AAA_USER_ACTION_IND = "aaa_UserAction_ind"
	CONST_PROP_ID_AAA_USER_ACTION_SESSION_ID = "aaa_UserAction_sessionId"
	CONST_PROP_ID_AAA_USER_ACTION_SEVERITY = "aaa_UserAction_severity"
	CONST_PROP_ID_AAA_USER_ACTION_TRIG = "aaa_UserAction_trig"
	CONST_PROP_ID_AAA_USER_ACTION_TX_ID = "aaa_UserAction_txId"
	CONST_PROP_ID_AAA_USER_ACTION_USER = "aaa_UserAction_user"
	CONST_PROP_ID_AAA_USER_DATA_DESCR = "aaa_UserData_descr"
	CONST_PROP_ID_AAA_USER_DATA_INT_ID = "aaa_UserData_intId"
	CONST_PROP_ID_AAA_USER_DATA_NAME = "aaa_UserData_name"
	CONST_PROP_ID_AAA_USER_DATA_POLICY_LEVEL = "aaa_UserData_policyLevel"
	CONST_PROP_ID_AAA_USER_DATA_POLICY_OWNER = "aaa_UserData_policyOwner"
	CONST_PROP_ID_AAA_USER_DATA_PWD_CHANGE_COUNT = "aaa_UserData_pwdChangeCount"
	CONST_PROP_ID_AAA_USER_DATA_PWD_CHANGE_INTERVAL_BEGIN = "aaa_UserData_pwdChangeIntervalBegin"
	CONST_PROP_ID_AAA_USER_DATA_PWD_CHANGED_DATE = "aaa_UserData_pwdChangedDate"
	CONST_PROP_ID_AAA_USER_DATA_PWD_HISTORY = "aaa_UserData_pwdHistory"
	CONST_PROP_ID_AAA_USER_EP_FSM_STAGE_DESCR = "aaa_UserEpFsmStage_descr"
	CONST_PROP_ID_AAA_USER_EP_FSM_STAGE_LAST_UPDATE_TIME = "aaa_UserEpFsmStage_lastUpdateTime"
	CONST_PROP_ID_AAA_USER_EP_FSM_STAGE_NAME = "aaa_UserEpFsmStage_name"
	CONST_PROP_ID_AAA_USER_EP_FSM_STAGE_ORDER = "aaa_UserEpFsmStage_order"
	CONST_PROP_ID_AAA_USER_EP_FSM_STAGE_RETRY = "aaa_UserEpFsmStage_retry"
	CONST_PROP_ID_AAA_USER_EP_FSM_STAGE_STAGE_STATUS = "aaa_UserEpFsmStage_stageStatus"
	CONST_PROP_ID_AAA_USER_EP_FSM_TASK_COMPLETION = "aaa_UserEpFsmTask_completion"
	CONST_PROP_ID_AAA_USER_EP_FSM_TASK_FLAGS = "aaa_UserEpFsmTask_flags"
	CONST_PROP_ID_AAA_USER_EP_FSM_TASK_ITEM = "aaa_UserEpFsmTask_item"
	CONST_PROP_ID_AAA_USER_EP_FSM_TASK_SEQ_ID = "aaa_UserEpFsmTask_seqId"
	CONST_PROP_ID_AAA_USER_EP_FSM_COMPLETION_TIME = "aaa_UserEpFsm_completionTime"
	CONST_PROP_ID_AAA_USER_EP_FSM_CURRENT_FSM = "aaa_UserEpFsm_currentFsm"
	CONST_PROP_ID_AAA_USER_EP_FSM_DESCR = "aaa_UserEpFsm_descr"
	CONST_PROP_ID_AAA_USER_EP_FSM_FSM_STATUS = "aaa_UserEpFsm_fsmStatus"
	CONST_PROP_ID_AAA_USER_EP_FSM_INSTANCE_ID = "aaa_UserEpFsm_instanceId"
	CONST_PROP_ID_AAA_USER_EP_FSM_PROGRESS = "aaa_UserEpFsm_progress"
	CONST_PROP_ID_AAA_USER_EP_FSM_RMT_ERR_CODE = "aaa_UserEpFsm_rmtErrCode"
	CONST_PROP_ID_AAA_USER_EP_FSM_RMT_ERR_DESCR = "aaa_UserEpFsm_rmtErrDescr"
	CONST_PROP_ID_AAA_USER_EP_FSM_RMT_RSLT = "aaa_UserEpFsm_rmtRslt"
	CONST_PROP_ID_AAA_USER_EP_DESCR = "aaa_UserEp_descr"
	CONST_PROP_ID_AAA_USER_EP_FSM_DESCR = "aaa_UserEp_fsmDescr"
	CONST_PROP_ID_AAA_USER_EP_FSM_PREV = "aaa_UserEp_fsmPrev"
	CONST_PROP_ID_AAA_USER_EP_FSM_PROGR = "aaa_UserEp_fsmProgr"
	CONST_PROP_ID_AAA_USER_EP_FSM_RMT_INV_ERR_CODE = "aaa_UserEp_fsmRmtInvErrCode"
	CONST_PROP_ID_AAA_USER_EP_FSM_RMT_INV_ERR_DESCR = "aaa_UserEp_fsmRmtInvErrDescr"
	CONST_PROP_ID_AAA_USER_EP_FSM_RMT_INV_RSLT = "aaa_UserEp_fsmRmtInvRslt"
	CONST_PROP_ID_AAA_USER_EP_FSM_STAGE_DESCR = "aaa_UserEp_fsmStageDescr"
	CONST_PROP_ID_AAA_USER_EP_FSM_STAMP = "aaa_UserEp_fsmStamp"
	CONST_PROP_ID_AAA_USER_EP_FSM_STATUS = "aaa_UserEp_fsmStatus"
	CONST_PROP_ID_AAA_USER_EP_FSM_TRY = "aaa_UserEp_fsmTry"
	CONST_PROP_ID_AAA_USER_EP_INT_ID = "aaa_UserEp_intId"
	CONST_PROP_ID_AAA_USER_EP_NAME = "aaa_UserEp_name"
	CONST_PROP_ID_AAA_USER_EP_POLICY_LEVEL = "aaa_UserEp_policyLevel"
	CONST_PROP_ID_AAA_USER_EP_POLICY_OWNER = "aaa_UserEp_policyOwner"
	CONST_PROP_ID_AAA_USER_EP_PWD_STRENGTH_CHECK = "aaa_UserEp_pwdStrengthCheck"
	CONST_PROP_ID_AAA_USER_GROUP_DESCR = "aaa_UserGroup_descr"
	CONST_PROP_ID_AAA_USER_GROUP_NAME = "aaa_UserGroup_name"
	CONST_PROP_ID_AAA_USER_LOCALE_CONFIG_STATE = "aaa_UserLocale_configState"
	CONST_PROP_ID_AAA_USER_LOCALE_CONFIG_STATUS_MESSAGE = "aaa_UserLocale_configStatusMessage"
	CONST_PROP_ID_AAA_USER_LOCALE_DESCR = "aaa_UserLocale_descr"
	CONST_PROP_ID_AAA_USER_LOCALE_NAME = "aaa_UserLocale_name"
	CONST_PROP_ID_AAA_USER_LOGIN_DESCR = "aaa_UserLogin_descr"
	CONST_PROP_ID_AAA_USER_LOGIN_ID = "aaa_UserLogin_id"
	CONST_PROP_ID_AAA_USER_LOGIN_INT_ID = "aaa_UserLogin_intId"
	CONST_PROP_ID_AAA_USER_LOGIN_LOCAL_HOST = "aaa_UserLogin_localHost"
	CONST_PROP_ID_AAA_USER_LOGIN_NAME = "aaa_UserLogin_name"
	CONST_PROP_ID_AAA_USER_LOGIN_POLICY_LEVEL = "aaa_UserLogin_policyLevel"
	CONST_PROP_ID_AAA_USER_LOGIN_POLICY_OWNER = "aaa_UserLogin_policyOwner"
	CONST_PROP_ID_AAA_USER_LOGIN_REMOTE_HOST = "aaa_UserLogin_remoteHost"
	CONST_PROP_ID_AAA_USER_LOGIN_SESSION = "aaa_UserLogin_session"
	CONST_PROP_ID_AAA_USER_LOGIN_SWITCH_ID = "aaa_UserLogin_switchId"
	CONST_PROP_ID_AAA_USER_ROLE_CONFIG_STATE = "aaa_UserRole_configState"
	CONST_PROP_ID_AAA_USER_ROLE_CONFIG_STATUS_MESSAGE = "aaa_UserRole_configStatusMessage"
	CONST_PROP_ID_AAA_USER_ROLE_DESCR = "aaa_UserRole_descr"
	CONST_PROP_ID_AAA_USER_ROLE_NAME = "aaa_UserRole_name"
	CONST_PROP_ID_AAA_USER_ACCOUNT_STATUS = "aaa_User_accountStatus"
	CONST_PROP_ID_AAA_USER_CLEAR_PWD_HISTORY = "aaa_User_clearPwdHistory"
	CONST_PROP_ID_AAA_USER_CONFIG_STATE = "aaa_User_configState"
	CONST_PROP_ID_AAA_USER_CONFIG_STATUS_MESSAGE = "aaa_User_configStatusMessage"
	CONST_PROP_ID_AAA_USER_DESCR = "aaa_User_descr"
	CONST_PROP_ID_AAA_USER_EMAIL = "aaa_User_email"
	CONST_PROP_ID_AAA_USER_ENC_PWD = "aaa_User_encPwd"
	CONST_PROP_ID_AAA_USER_ENC_PWD_SET = "aaa_User_encPwdSet"
	CONST_PROP_ID_AAA_USER_EXPIRATION = "aaa_User_expiration"
	CONST_PROP_ID_AAA_USER_EXPIRES = "aaa_User_expires"
	CONST_PROP_ID_AAA_USER_FIRST_NAME = "aaa_User_firstName"
	CONST_PROP_ID_AAA_USER_LAST_NAME = "aaa_User_lastName"
	CONST_PROP_ID_AAA_USER_NAME = "aaa_User_name"
	CONST_PROP_ID_AAA_USER_PHONE = "aaa_User_phone"
	CONST_PROP_ID_AAA_USER_PRIV = "aaa_User_priv"
	CONST_PROP_ID_AAA_USER_PWD = "aaa_User_pwd"
	CONST_PROP_ID_AAA_USER_PWD_LIFE_TIME = "aaa_User_pwdLifeTime"
	CONST_PROP_ID_AAA_USER_PWD_SET = "aaa_User_pwdSet"
	CONST_PROP_ID_AAA_WEB_LOGIN_DESCR = "aaa_WebLogin_descr"
	CONST_PROP_ID_AAA_WEB_LOGIN_ID = "aaa_WebLogin_id"
	CONST_PROP_ID_AAA_WEB_LOGIN_INT_ID = "aaa_WebLogin_intId"
	CONST_PROP_ID_AAA_WEB_LOGIN_LOCAL_HOST = "aaa_WebLogin_localHost"
	CONST_PROP_ID_AAA_WEB_LOGIN_NAME = "aaa_WebLogin_name"
	CONST_PROP_ID_AAA_WEB_LOGIN_POLICY_LEVEL = "aaa_WebLogin_policyLevel"
	CONST_PROP_ID_AAA_WEB_LOGIN_POLICY_OWNER = "aaa_WebLogin_policyOwner"
	CONST_PROP_ID_AAA_WEB_LOGIN_REMOTE_HOST = "aaa_WebLogin_remoteHost"
	CONST_PROP_ID_AAA_WEB_LOGIN_SESSION = "aaa_WebLogin_session"
	CONST_PROP_ID_AAA_WEB_LOGIN_SWITCH_ID = "aaa_WebLogin_switchId"
	CONST_PROP_ID_ADAPTOR_CIO_EP_EP_DN = "adaptor_CIoEp_epDn"
	CONST_PROP_ID_ADAPTOR_CIO_EP_IF_ROLE = "adaptor_CIoEp_ifRole"
	CONST_PROP_ID_ADAPTOR_CIO_EP_IF_TYPE = "adaptor_CIoEp_ifType"
	CONST_PROP_ID_ADAPTOR_CIO_EP_LOCALE = "adaptor_CIoEp_locale"
	CONST_PROP_ID_ADAPTOR_CIO_EP_NAME = "adaptor_CIoEp_name"
	CONST_PROP_ID_ADAPTOR_CIO_EP_PEER_DN = "adaptor_CIoEp_peerDn"
	CONST_PROP_ID_ADAPTOR_CIO_EP_PORT_ID = "adaptor_CIoEp_portId"
	CONST_PROP_ID_ADAPTOR_CIO_EP_SWITCH_ID = "adaptor_CIoEp_switchId"
	CONST_PROP_ID_ADAPTOR_CIO_EP_TRANSPORT = "adaptor_CIoEp_transport"
	CONST_PROP_ID_ADAPTOR_CIO_EP_TYPE = "adaptor_CIoEp_type"
	CONST_PROP_ID_ADAPTOR_CAP_DEF_FW_VERSION_HI = "adaptor_CapDef_fwVersionHi"
	CONST_PROP_ID_ADAPTOR_CAP_DEF_FW_VERSION_LO = "adaptor_CapDef_fwVersionLo"
	CONST_PROP_ID_ADAPTOR_CAP_DEF_FW_VERSION_OPR = "adaptor_CapDef_fwVersionOpr"
	CONST_PROP_ID_ADAPTOR_CAP_DEF_MAXIMUM = "adaptor_CapDef_maximum"
	CONST_PROP_ID_ADAPTOR_CAP_DEF_TYPE = "adaptor_CapDef_type"
	CONST_PROP_ID_ADAPTOR_CAP_QUAL_FW_VERSION_HI = "adaptor_CapQual_fwVersionHi"
	CONST_PROP_ID_ADAPTOR_CAP_QUAL_FW_VERSION_LO = "adaptor_CapQual_fwVersionLo"
	CONST_PROP_ID_ADAPTOR_CAP_QUAL_FW_VERSION_OPR = "adaptor_CapQual_fwVersionOpr"
	CONST_PROP_ID_ADAPTOR_CAP_QUAL_MAXIMUM = "adaptor_CapQual_maximum"
	CONST_PROP_ID_ADAPTOR_CAP_QUAL_MODEL = "adaptor_CapQual_model"
	CONST_PROP_ID_ADAPTOR_CAP_QUAL_TYPE = "adaptor_CapQual_type"
	CONST_PROP_ID_ADAPTOR_CAP_SPEC_FW_VERSION_HI = "adaptor_CapSpec_fwVersionHi"
	CONST_PROP_ID_ADAPTOR_CAP_SPEC_FW_VERSION_LO = "adaptor_CapSpec_fwVersionLo"
	CONST_PROP_ID_ADAPTOR_CAP_SPEC_FW_VERSION_OPR = "adaptor_CapSpec_fwVersionOpr"
	CONST_PROP_ID_ADAPTOR_CAP_SPEC_MAXIMUM = "adaptor_CapSpec_maximum"
	CONST_PROP_ID_ADAPTOR_CAP_SPEC_TYPE = "adaptor_CapSpec_type"
	CONST_PROP_ID_ADAPTOR_DIAG_CAP_ENABLE_LLDP_TRANSMIT = "adaptor_DiagCap_enableLldpTransmit"
	CONST_PROP_ID_ADAPTOR_ETH_COMP_QUEUE_PROFILE_COUNT = "adaptor_EthCompQueueProfile_count"
	CONST_PROP_ID_ADAPTOR_ETH_COMP_QUEUE_PROFILE_RING_SIZE = "adaptor_EthCompQueueProfile_ringSize"
	CONST_PROP_ID_ADAPTOR_ETH_FAILOVER_PROFILE_TIMEOUT = "adaptor_EthFailoverProfile_timeout"
	CONST_PROP_ID_ADAPTOR_ETH_INTERRUPT_PROFILE_COALESCING_TIME = "adaptor_EthInterruptProfile_coalescingTime"
	CONST_PROP_ID_ADAPTOR_ETH_INTERRUPT_PROFILE_COALESCING_TYPE = "adaptor_EthInterruptProfile_coalescingType"
	CONST_PROP_ID_ADAPTOR_ETH_INTERRUPT_PROFILE_COUNT = "adaptor_EthInterruptProfile_count"
	CONST_PROP_ID_ADAPTOR_ETH_INTERRUPT_PROFILE_MODE = "adaptor_EthInterruptProfile_mode"
	CONST_PROP_ID_ADAPTOR_ETH_OFFLOAD_PROFILE_LARGE_RECEIVE = "adaptor_EthOffloadProfile_largeReceive"
	CONST_PROP_ID_ADAPTOR_ETH_OFFLOAD_PROFILE_TCP_RX_CHECKSUM = "adaptor_EthOffloadProfile_tcpRxChecksum"
	CONST_PROP_ID_ADAPTOR_ETH_OFFLOAD_PROFILE_TCP_SEGMENT = "adaptor_EthOffloadProfile_tcpSegment"
	CONST_PROP_ID_ADAPTOR_ETH_OFFLOAD_PROFILE_TCP_TX_CHECKSUM = "adaptor_EthOffloadProfile_tcpTxChecksum"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_GREATER_THAN_OR_EQUAL_TO9216 = "adaptor_EthPortBySizeLargeStatsHist_greaterThanOrEqualTo9216"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_GREATER_THAN_OR_EQUAL_TO9216_DELTA = "adaptor_EthPortBySizeLargeStatsHist_greaterThanOrEqualTo9216Delta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_GREATER_THAN_OR_EQUAL_TO9216_DELTA_AVG = "adaptor_EthPortBySizeLargeStatsHist_greaterThanOrEqualTo9216DeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_GREATER_THAN_OR_EQUAL_TO9216_DELTA_MAX = "adaptor_EthPortBySizeLargeStatsHist_greaterThanOrEqualTo9216DeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_GREATER_THAN_OR_EQUAL_TO9216_DELTA_MIN = "adaptor_EthPortBySizeLargeStatsHist_greaterThanOrEqualTo9216DeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_ID = "adaptor_EthPortBySizeLargeStatsHist_id"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN2048 = "adaptor_EthPortBySizeLargeStatsHist_lessThan2048"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN2048_DELTA = "adaptor_EthPortBySizeLargeStatsHist_lessThan2048Delta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN2048_DELTA_AVG = "adaptor_EthPortBySizeLargeStatsHist_lessThan2048DeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN2048_DELTA_MAX = "adaptor_EthPortBySizeLargeStatsHist_lessThan2048DeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN2048_DELTA_MIN = "adaptor_EthPortBySizeLargeStatsHist_lessThan2048DeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN4096 = "adaptor_EthPortBySizeLargeStatsHist_lessThan4096"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN4096_DELTA = "adaptor_EthPortBySizeLargeStatsHist_lessThan4096Delta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN4096_DELTA_AVG = "adaptor_EthPortBySizeLargeStatsHist_lessThan4096DeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN4096_DELTA_MAX = "adaptor_EthPortBySizeLargeStatsHist_lessThan4096DeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN4096_DELTA_MIN = "adaptor_EthPortBySizeLargeStatsHist_lessThan4096DeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN8192 = "adaptor_EthPortBySizeLargeStatsHist_lessThan8192"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN8192_DELTA = "adaptor_EthPortBySizeLargeStatsHist_lessThan8192Delta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN8192_DELTA_AVG = "adaptor_EthPortBySizeLargeStatsHist_lessThan8192DeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN8192_DELTA_MAX = "adaptor_EthPortBySizeLargeStatsHist_lessThan8192DeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN8192_DELTA_MIN = "adaptor_EthPortBySizeLargeStatsHist_lessThan8192DeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN9216 = "adaptor_EthPortBySizeLargeStatsHist_lessThan9216"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN9216_DELTA = "adaptor_EthPortBySizeLargeStatsHist_lessThan9216Delta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN9216_DELTA_AVG = "adaptor_EthPortBySizeLargeStatsHist_lessThan9216DeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN9216_DELTA_MAX = "adaptor_EthPortBySizeLargeStatsHist_lessThan9216DeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN9216_DELTA_MIN = "adaptor_EthPortBySizeLargeStatsHist_lessThan9216DeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN_OR_EQUAL_TO1518 = "adaptor_EthPortBySizeLargeStatsHist_lessThanOrEqualTo1518"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN_OR_EQUAL_TO1518_DELTA = "adaptor_EthPortBySizeLargeStatsHist_lessThanOrEqualTo1518Delta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN_OR_EQUAL_TO1518_DELTA_AVG = "adaptor_EthPortBySizeLargeStatsHist_lessThanOrEqualTo1518DeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN_OR_EQUAL_TO1518_DELTA_MAX = "adaptor_EthPortBySizeLargeStatsHist_lessThanOrEqualTo1518DeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN_OR_EQUAL_TO1518_DELTA_MIN = "adaptor_EthPortBySizeLargeStatsHist_lessThanOrEqualTo1518DeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_MOST_RECENT = "adaptor_EthPortBySizeLargeStatsHist_mostRecent"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_NO_BREAKDOWN_GREATER_THAN1518 = "adaptor_EthPortBySizeLargeStatsHist_noBreakdownGreaterThan1518"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_NO_BREAKDOWN_GREATER_THAN1518_DELTA = "adaptor_EthPortBySizeLargeStatsHist_noBreakdownGreaterThan1518Delta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_NO_BREAKDOWN_GREATER_THAN1518_DELTA_AVG = "adaptor_EthPortBySizeLargeStatsHist_noBreakdownGreaterThan1518DeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_NO_BREAKDOWN_GREATER_THAN1518_DELTA_MAX = "adaptor_EthPortBySizeLargeStatsHist_noBreakdownGreaterThan1518DeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_NO_BREAKDOWN_GREATER_THAN1518_DELTA_MIN = "adaptor_EthPortBySizeLargeStatsHist_noBreakdownGreaterThan1518DeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_SUSPECT = "adaptor_EthPortBySizeLargeStatsHist_suspect"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_THRESHOLDED = "adaptor_EthPortBySizeLargeStatsHist_thresholded"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_TIME_COLLECTED = "adaptor_EthPortBySizeLargeStatsHist_timeCollected"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_GREATER_THAN_OR_EQUAL_TO9216 = "adaptor_EthPortBySizeLargeStats_greaterThanOrEqualTo9216"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_GREATER_THAN_OR_EQUAL_TO9216_DELTA = "adaptor_EthPortBySizeLargeStats_greaterThanOrEqualTo9216Delta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_GREATER_THAN_OR_EQUAL_TO9216_DELTA_AVG = "adaptor_EthPortBySizeLargeStats_greaterThanOrEqualTo9216DeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_GREATER_THAN_OR_EQUAL_TO9216_DELTA_MAX = "adaptor_EthPortBySizeLargeStats_greaterThanOrEqualTo9216DeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_GREATER_THAN_OR_EQUAL_TO9216_DELTA_MIN = "adaptor_EthPortBySizeLargeStats_greaterThanOrEqualTo9216DeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_INTERVALS = "adaptor_EthPortBySizeLargeStats_intervals"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN2048 = "adaptor_EthPortBySizeLargeStats_lessThan2048"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN2048_DELTA = "adaptor_EthPortBySizeLargeStats_lessThan2048Delta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN2048_DELTA_AVG = "adaptor_EthPortBySizeLargeStats_lessThan2048DeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN2048_DELTA_MAX = "adaptor_EthPortBySizeLargeStats_lessThan2048DeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN2048_DELTA_MIN = "adaptor_EthPortBySizeLargeStats_lessThan2048DeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN4096 = "adaptor_EthPortBySizeLargeStats_lessThan4096"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN4096_DELTA = "adaptor_EthPortBySizeLargeStats_lessThan4096Delta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN4096_DELTA_AVG = "adaptor_EthPortBySizeLargeStats_lessThan4096DeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN4096_DELTA_MAX = "adaptor_EthPortBySizeLargeStats_lessThan4096DeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN4096_DELTA_MIN = "adaptor_EthPortBySizeLargeStats_lessThan4096DeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN8192 = "adaptor_EthPortBySizeLargeStats_lessThan8192"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN8192_DELTA = "adaptor_EthPortBySizeLargeStats_lessThan8192Delta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN8192_DELTA_AVG = "adaptor_EthPortBySizeLargeStats_lessThan8192DeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN8192_DELTA_MAX = "adaptor_EthPortBySizeLargeStats_lessThan8192DeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN8192_DELTA_MIN = "adaptor_EthPortBySizeLargeStats_lessThan8192DeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN9216 = "adaptor_EthPortBySizeLargeStats_lessThan9216"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN9216_DELTA = "adaptor_EthPortBySizeLargeStats_lessThan9216Delta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN9216_DELTA_AVG = "adaptor_EthPortBySizeLargeStats_lessThan9216DeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN9216_DELTA_MAX = "adaptor_EthPortBySizeLargeStats_lessThan9216DeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN9216_DELTA_MIN = "adaptor_EthPortBySizeLargeStats_lessThan9216DeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN_OR_EQUAL_TO1518 = "adaptor_EthPortBySizeLargeStats_lessThanOrEqualTo1518"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN_OR_EQUAL_TO1518_DELTA = "adaptor_EthPortBySizeLargeStats_lessThanOrEqualTo1518Delta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN_OR_EQUAL_TO1518_DELTA_AVG = "adaptor_EthPortBySizeLargeStats_lessThanOrEqualTo1518DeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN_OR_EQUAL_TO1518_DELTA_MAX = "adaptor_EthPortBySizeLargeStats_lessThanOrEqualTo1518DeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN_OR_EQUAL_TO1518_DELTA_MIN = "adaptor_EthPortBySizeLargeStats_lessThanOrEqualTo1518DeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_NO_BREAKDOWN_GREATER_THAN1518 = "adaptor_EthPortBySizeLargeStats_noBreakdownGreaterThan1518"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_NO_BREAKDOWN_GREATER_THAN1518_DELTA = "adaptor_EthPortBySizeLargeStats_noBreakdownGreaterThan1518Delta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_NO_BREAKDOWN_GREATER_THAN1518_DELTA_AVG = "adaptor_EthPortBySizeLargeStats_noBreakdownGreaterThan1518DeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_NO_BREAKDOWN_GREATER_THAN1518_DELTA_MAX = "adaptor_EthPortBySizeLargeStats_noBreakdownGreaterThan1518DeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_NO_BREAKDOWN_GREATER_THAN1518_DELTA_MIN = "adaptor_EthPortBySizeLargeStats_noBreakdownGreaterThan1518DeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_SUSPECT = "adaptor_EthPortBySizeLargeStats_suspect"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_THRESHOLDED = "adaptor_EthPortBySizeLargeStats_thresholded"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_TIME_COLLECTED = "adaptor_EthPortBySizeLargeStats_timeCollected"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_TRAFFIC_DIRECTION = "adaptor_EthPortBySizeLargeStats_trafficDirection"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_UPDATE = "adaptor_EthPortBySizeLargeStats_update"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_EQUALS64 = "adaptor_EthPortBySizeSmallStatsHist_equals64"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_EQUALS64_DELTA = "adaptor_EthPortBySizeSmallStatsHist_equals64Delta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_EQUALS64_DELTA_AVG = "adaptor_EthPortBySizeSmallStatsHist_equals64DeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_EQUALS64_DELTA_MAX = "adaptor_EthPortBySizeSmallStatsHist_equals64DeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_EQUALS64_DELTA_MIN = "adaptor_EthPortBySizeSmallStatsHist_equals64DeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_ID = "adaptor_EthPortBySizeSmallStatsHist_id"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN1024 = "adaptor_EthPortBySizeSmallStatsHist_lessThan1024"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN1024_DELTA = "adaptor_EthPortBySizeSmallStatsHist_lessThan1024Delta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN1024_DELTA_AVG = "adaptor_EthPortBySizeSmallStatsHist_lessThan1024DeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN1024_DELTA_MAX = "adaptor_EthPortBySizeSmallStatsHist_lessThan1024DeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN1024_DELTA_MIN = "adaptor_EthPortBySizeSmallStatsHist_lessThan1024DeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN128 = "adaptor_EthPortBySizeSmallStatsHist_lessThan128"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN128_DELTA = "adaptor_EthPortBySizeSmallStatsHist_lessThan128Delta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN128_DELTA_AVG = "adaptor_EthPortBySizeSmallStatsHist_lessThan128DeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN128_DELTA_MAX = "adaptor_EthPortBySizeSmallStatsHist_lessThan128DeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN128_DELTA_MIN = "adaptor_EthPortBySizeSmallStatsHist_lessThan128DeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN256 = "adaptor_EthPortBySizeSmallStatsHist_lessThan256"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN256_DELTA = "adaptor_EthPortBySizeSmallStatsHist_lessThan256Delta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN256_DELTA_AVG = "adaptor_EthPortBySizeSmallStatsHist_lessThan256DeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN256_DELTA_MAX = "adaptor_EthPortBySizeSmallStatsHist_lessThan256DeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN256_DELTA_MIN = "adaptor_EthPortBySizeSmallStatsHist_lessThan256DeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN512 = "adaptor_EthPortBySizeSmallStatsHist_lessThan512"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN512_DELTA = "adaptor_EthPortBySizeSmallStatsHist_lessThan512Delta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN512_DELTA_AVG = "adaptor_EthPortBySizeSmallStatsHist_lessThan512DeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN512_DELTA_MAX = "adaptor_EthPortBySizeSmallStatsHist_lessThan512DeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN512_DELTA_MIN = "adaptor_EthPortBySizeSmallStatsHist_lessThan512DeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN64 = "adaptor_EthPortBySizeSmallStatsHist_lessThan64"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN64_DELTA = "adaptor_EthPortBySizeSmallStatsHist_lessThan64Delta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN64_DELTA_AVG = "adaptor_EthPortBySizeSmallStatsHist_lessThan64DeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN64_DELTA_MAX = "adaptor_EthPortBySizeSmallStatsHist_lessThan64DeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN64_DELTA_MIN = "adaptor_EthPortBySizeSmallStatsHist_lessThan64DeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_MOST_RECENT = "adaptor_EthPortBySizeSmallStatsHist_mostRecent"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_SUSPECT = "adaptor_EthPortBySizeSmallStatsHist_suspect"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_THRESHOLDED = "adaptor_EthPortBySizeSmallStatsHist_thresholded"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_TIME_COLLECTED = "adaptor_EthPortBySizeSmallStatsHist_timeCollected"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_EQUALS64 = "adaptor_EthPortBySizeSmallStats_equals64"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_EQUALS64_DELTA = "adaptor_EthPortBySizeSmallStats_equals64Delta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_EQUALS64_DELTA_AVG = "adaptor_EthPortBySizeSmallStats_equals64DeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_EQUALS64_DELTA_MAX = "adaptor_EthPortBySizeSmallStats_equals64DeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_EQUALS64_DELTA_MIN = "adaptor_EthPortBySizeSmallStats_equals64DeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_INTERVALS = "adaptor_EthPortBySizeSmallStats_intervals"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN1024 = "adaptor_EthPortBySizeSmallStats_lessThan1024"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN1024_DELTA = "adaptor_EthPortBySizeSmallStats_lessThan1024Delta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN1024_DELTA_AVG = "adaptor_EthPortBySizeSmallStats_lessThan1024DeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN1024_DELTA_MAX = "adaptor_EthPortBySizeSmallStats_lessThan1024DeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN1024_DELTA_MIN = "adaptor_EthPortBySizeSmallStats_lessThan1024DeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN128 = "adaptor_EthPortBySizeSmallStats_lessThan128"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN128_DELTA = "adaptor_EthPortBySizeSmallStats_lessThan128Delta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN128_DELTA_AVG = "adaptor_EthPortBySizeSmallStats_lessThan128DeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN128_DELTA_MAX = "adaptor_EthPortBySizeSmallStats_lessThan128DeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN128_DELTA_MIN = "adaptor_EthPortBySizeSmallStats_lessThan128DeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN256 = "adaptor_EthPortBySizeSmallStats_lessThan256"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN256_DELTA = "adaptor_EthPortBySizeSmallStats_lessThan256Delta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN256_DELTA_AVG = "adaptor_EthPortBySizeSmallStats_lessThan256DeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN256_DELTA_MAX = "adaptor_EthPortBySizeSmallStats_lessThan256DeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN256_DELTA_MIN = "adaptor_EthPortBySizeSmallStats_lessThan256DeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN512 = "adaptor_EthPortBySizeSmallStats_lessThan512"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN512_DELTA = "adaptor_EthPortBySizeSmallStats_lessThan512Delta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN512_DELTA_AVG = "adaptor_EthPortBySizeSmallStats_lessThan512DeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN512_DELTA_MAX = "adaptor_EthPortBySizeSmallStats_lessThan512DeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN512_DELTA_MIN = "adaptor_EthPortBySizeSmallStats_lessThan512DeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN64 = "adaptor_EthPortBySizeSmallStats_lessThan64"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN64_DELTA = "adaptor_EthPortBySizeSmallStats_lessThan64Delta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN64_DELTA_AVG = "adaptor_EthPortBySizeSmallStats_lessThan64DeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN64_DELTA_MAX = "adaptor_EthPortBySizeSmallStats_lessThan64DeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN64_DELTA_MIN = "adaptor_EthPortBySizeSmallStats_lessThan64DeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_SUSPECT = "adaptor_EthPortBySizeSmallStats_suspect"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_THRESHOLDED = "adaptor_EthPortBySizeSmallStats_thresholded"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_TIME_COLLECTED = "adaptor_EthPortBySizeSmallStats_timeCollected"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_TRAFFIC_DIRECTION = "adaptor_EthPortBySizeSmallStats_trafficDirection"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_UPDATE = "adaptor_EthPortBySizeSmallStats_update"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_ERR_STATS_HIST_BAD_CRC_PACKETS = "adaptor_EthPortErrStatsHist_badCrcPackets"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_ERR_STATS_HIST_BAD_CRC_PACKETS_DELTA = "adaptor_EthPortErrStatsHist_badCrcPacketsDelta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_ERR_STATS_HIST_BAD_CRC_PACKETS_DELTA_AVG = "adaptor_EthPortErrStatsHist_badCrcPacketsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_ERR_STATS_HIST_BAD_CRC_PACKETS_DELTA_MAX = "adaptor_EthPortErrStatsHist_badCrcPacketsDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_ERR_STATS_HIST_BAD_CRC_PACKETS_DELTA_MIN = "adaptor_EthPortErrStatsHist_badCrcPacketsDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_ERR_STATS_HIST_BAD_LENGTH_PACKETS = "adaptor_EthPortErrStatsHist_badLengthPackets"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_ERR_STATS_HIST_BAD_LENGTH_PACKETS_DELTA = "adaptor_EthPortErrStatsHist_badLengthPacketsDelta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_ERR_STATS_HIST_BAD_LENGTH_PACKETS_DELTA_AVG = "adaptor_EthPortErrStatsHist_badLengthPacketsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_ERR_STATS_HIST_BAD_LENGTH_PACKETS_DELTA_MAX = "adaptor_EthPortErrStatsHist_badLengthPacketsDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_ERR_STATS_HIST_BAD_LENGTH_PACKETS_DELTA_MIN = "adaptor_EthPortErrStatsHist_badLengthPacketsDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_ERR_STATS_HIST_ID = "adaptor_EthPortErrStatsHist_id"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_ERR_STATS_HIST_MAC_DISCARDED_PACKETS = "adaptor_EthPortErrStatsHist_macDiscardedPackets"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_ERR_STATS_HIST_MAC_DISCARDED_PACKETS_DELTA = "adaptor_EthPortErrStatsHist_macDiscardedPacketsDelta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_ERR_STATS_HIST_MAC_DISCARDED_PACKETS_DELTA_AVG = "adaptor_EthPortErrStatsHist_macDiscardedPacketsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_ERR_STATS_HIST_MAC_DISCARDED_PACKETS_DELTA_MAX = "adaptor_EthPortErrStatsHist_macDiscardedPacketsDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_ERR_STATS_HIST_MAC_DISCARDED_PACKETS_DELTA_MIN = "adaptor_EthPortErrStatsHist_macDiscardedPacketsDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_ERR_STATS_HIST_MOST_RECENT = "adaptor_EthPortErrStatsHist_mostRecent"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_ERR_STATS_HIST_SUSPECT = "adaptor_EthPortErrStatsHist_suspect"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_ERR_STATS_HIST_THRESHOLDED = "adaptor_EthPortErrStatsHist_thresholded"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_ERR_STATS_HIST_TIME_COLLECTED = "adaptor_EthPortErrStatsHist_timeCollected"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_ERR_STATS_BAD_CRC_PACKETS = "adaptor_EthPortErrStats_badCrcPackets"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_ERR_STATS_BAD_CRC_PACKETS_DELTA = "adaptor_EthPortErrStats_badCrcPacketsDelta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_ERR_STATS_BAD_CRC_PACKETS_DELTA_AVG = "adaptor_EthPortErrStats_badCrcPacketsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_ERR_STATS_BAD_CRC_PACKETS_DELTA_MAX = "adaptor_EthPortErrStats_badCrcPacketsDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_ERR_STATS_BAD_CRC_PACKETS_DELTA_MIN = "adaptor_EthPortErrStats_badCrcPacketsDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_ERR_STATS_BAD_LENGTH_PACKETS = "adaptor_EthPortErrStats_badLengthPackets"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_ERR_STATS_BAD_LENGTH_PACKETS_DELTA = "adaptor_EthPortErrStats_badLengthPacketsDelta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_ERR_STATS_BAD_LENGTH_PACKETS_DELTA_AVG = "adaptor_EthPortErrStats_badLengthPacketsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_ERR_STATS_BAD_LENGTH_PACKETS_DELTA_MAX = "adaptor_EthPortErrStats_badLengthPacketsDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_ERR_STATS_BAD_LENGTH_PACKETS_DELTA_MIN = "adaptor_EthPortErrStats_badLengthPacketsDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_ERR_STATS_INTERVALS = "adaptor_EthPortErrStats_intervals"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_ERR_STATS_MAC_DISCARDED_PACKETS = "adaptor_EthPortErrStats_macDiscardedPackets"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_ERR_STATS_MAC_DISCARDED_PACKETS_DELTA = "adaptor_EthPortErrStats_macDiscardedPacketsDelta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_ERR_STATS_MAC_DISCARDED_PACKETS_DELTA_AVG = "adaptor_EthPortErrStats_macDiscardedPacketsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_ERR_STATS_MAC_DISCARDED_PACKETS_DELTA_MAX = "adaptor_EthPortErrStats_macDiscardedPacketsDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_ERR_STATS_MAC_DISCARDED_PACKETS_DELTA_MIN = "adaptor_EthPortErrStats_macDiscardedPacketsDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_ERR_STATS_SUSPECT = "adaptor_EthPortErrStats_suspect"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_ERR_STATS_THRESHOLDED = "adaptor_EthPortErrStats_thresholded"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_ERR_STATS_TIME_COLLECTED = "adaptor_EthPortErrStats_timeCollected"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_ERR_STATS_TRAFFIC_DIRECTION = "adaptor_EthPortErrStats_trafficDirection"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_ERR_STATS_UPDATE = "adaptor_EthPortErrStats_update"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_MCAST_STATS_HIST_BROADCAST_PACKETS = "adaptor_EthPortMcastStatsHist_broadcastPackets"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_MCAST_STATS_HIST_BROADCAST_PACKETS_DELTA = "adaptor_EthPortMcastStatsHist_broadcastPacketsDelta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_MCAST_STATS_HIST_BROADCAST_PACKETS_DELTA_AVG = "adaptor_EthPortMcastStatsHist_broadcastPacketsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_MCAST_STATS_HIST_BROADCAST_PACKETS_DELTA_MAX = "adaptor_EthPortMcastStatsHist_broadcastPacketsDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_MCAST_STATS_HIST_BROADCAST_PACKETS_DELTA_MIN = "adaptor_EthPortMcastStatsHist_broadcastPacketsDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_MCAST_STATS_HIST_ID = "adaptor_EthPortMcastStatsHist_id"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_MCAST_STATS_HIST_MOST_RECENT = "adaptor_EthPortMcastStatsHist_mostRecent"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_MCAST_STATS_HIST_MULTICAST_PACKETS = "adaptor_EthPortMcastStatsHist_multicastPackets"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_MCAST_STATS_HIST_MULTICAST_PACKETS_DELTA = "adaptor_EthPortMcastStatsHist_multicastPacketsDelta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_MCAST_STATS_HIST_MULTICAST_PACKETS_DELTA_AVG = "adaptor_EthPortMcastStatsHist_multicastPacketsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_MCAST_STATS_HIST_MULTICAST_PACKETS_DELTA_MAX = "adaptor_EthPortMcastStatsHist_multicastPacketsDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_MCAST_STATS_HIST_MULTICAST_PACKETS_DELTA_MIN = "adaptor_EthPortMcastStatsHist_multicastPacketsDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_MCAST_STATS_HIST_SUSPECT = "adaptor_EthPortMcastStatsHist_suspect"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_MCAST_STATS_HIST_THRESHOLDED = "adaptor_EthPortMcastStatsHist_thresholded"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_MCAST_STATS_HIST_TIME_COLLECTED = "adaptor_EthPortMcastStatsHist_timeCollected"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_MCAST_STATS_HIST_UNICAST_PACKETS = "adaptor_EthPortMcastStatsHist_unicastPackets"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_MCAST_STATS_HIST_UNICAST_PACKETS_DELTA = "adaptor_EthPortMcastStatsHist_unicastPacketsDelta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_MCAST_STATS_HIST_UNICAST_PACKETS_DELTA_AVG = "adaptor_EthPortMcastStatsHist_unicastPacketsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_MCAST_STATS_HIST_UNICAST_PACKETS_DELTA_MAX = "adaptor_EthPortMcastStatsHist_unicastPacketsDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_MCAST_STATS_HIST_UNICAST_PACKETS_DELTA_MIN = "adaptor_EthPortMcastStatsHist_unicastPacketsDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_MCAST_STATS_BROADCAST_PACKETS = "adaptor_EthPortMcastStats_broadcastPackets"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_MCAST_STATS_BROADCAST_PACKETS_DELTA = "adaptor_EthPortMcastStats_broadcastPacketsDelta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_MCAST_STATS_BROADCAST_PACKETS_DELTA_AVG = "adaptor_EthPortMcastStats_broadcastPacketsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_MCAST_STATS_BROADCAST_PACKETS_DELTA_MAX = "adaptor_EthPortMcastStats_broadcastPacketsDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_MCAST_STATS_BROADCAST_PACKETS_DELTA_MIN = "adaptor_EthPortMcastStats_broadcastPacketsDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_MCAST_STATS_INTERVALS = "adaptor_EthPortMcastStats_intervals"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_MCAST_STATS_MULTICAST_PACKETS = "adaptor_EthPortMcastStats_multicastPackets"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_MCAST_STATS_MULTICAST_PACKETS_DELTA = "adaptor_EthPortMcastStats_multicastPacketsDelta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_MCAST_STATS_MULTICAST_PACKETS_DELTA_AVG = "adaptor_EthPortMcastStats_multicastPacketsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_MCAST_STATS_MULTICAST_PACKETS_DELTA_MAX = "adaptor_EthPortMcastStats_multicastPacketsDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_MCAST_STATS_MULTICAST_PACKETS_DELTA_MIN = "adaptor_EthPortMcastStats_multicastPacketsDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_MCAST_STATS_SUSPECT = "adaptor_EthPortMcastStats_suspect"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_MCAST_STATS_THRESHOLDED = "adaptor_EthPortMcastStats_thresholded"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_MCAST_STATS_TIME_COLLECTED = "adaptor_EthPortMcastStats_timeCollected"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_MCAST_STATS_TRAFFIC_DIRECTION = "adaptor_EthPortMcastStats_trafficDirection"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_MCAST_STATS_UNICAST_PACKETS = "adaptor_EthPortMcastStats_unicastPackets"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_MCAST_STATS_UNICAST_PACKETS_DELTA = "adaptor_EthPortMcastStats_unicastPacketsDelta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_MCAST_STATS_UNICAST_PACKETS_DELTA_AVG = "adaptor_EthPortMcastStats_unicastPacketsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_MCAST_STATS_UNICAST_PACKETS_DELTA_MAX = "adaptor_EthPortMcastStats_unicastPacketsDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_MCAST_STATS_UNICAST_PACKETS_DELTA_MIN = "adaptor_EthPortMcastStats_unicastPacketsDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_MCAST_STATS_UPDATE = "adaptor_EthPortMcastStats_update"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_ID = "adaptor_EthPortOutsizedStatsHist_id"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_MOST_RECENT = "adaptor_EthPortOutsizedStatsHist_mostRecent"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_OVERSIZED_BAD_CRC_PACKETS = "adaptor_EthPortOutsizedStatsHist_oversizedBadCrcPackets"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_OVERSIZED_BAD_CRC_PACKETS_DELTA = "adaptor_EthPortOutsizedStatsHist_oversizedBadCrcPacketsDelta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_OVERSIZED_BAD_CRC_PACKETS_DELTA_AVG = "adaptor_EthPortOutsizedStatsHist_oversizedBadCrcPacketsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_OVERSIZED_BAD_CRC_PACKETS_DELTA_MAX = "adaptor_EthPortOutsizedStatsHist_oversizedBadCrcPacketsDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_OVERSIZED_BAD_CRC_PACKETS_DELTA_MIN = "adaptor_EthPortOutsizedStatsHist_oversizedBadCrcPacketsDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_OVERSIZED_GOOD_CRC_PACKETS = "adaptor_EthPortOutsizedStatsHist_oversizedGoodCrcPackets"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_OVERSIZED_GOOD_CRC_PACKETS_DELTA = "adaptor_EthPortOutsizedStatsHist_oversizedGoodCrcPacketsDelta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_OVERSIZED_GOOD_CRC_PACKETS_DELTA_AVG = "adaptor_EthPortOutsizedStatsHist_oversizedGoodCrcPacketsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_OVERSIZED_GOOD_CRC_PACKETS_DELTA_MAX = "adaptor_EthPortOutsizedStatsHist_oversizedGoodCrcPacketsDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_OVERSIZED_GOOD_CRC_PACKETS_DELTA_MIN = "adaptor_EthPortOutsizedStatsHist_oversizedGoodCrcPacketsDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_OVERSIZED_PACKETS = "adaptor_EthPortOutsizedStatsHist_oversizedPackets"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_OVERSIZED_PACKETS_DELTA = "adaptor_EthPortOutsizedStatsHist_oversizedPacketsDelta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_OVERSIZED_PACKETS_DELTA_AVG = "adaptor_EthPortOutsizedStatsHist_oversizedPacketsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_OVERSIZED_PACKETS_DELTA_MAX = "adaptor_EthPortOutsizedStatsHist_oversizedPacketsDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_OVERSIZED_PACKETS_DELTA_MIN = "adaptor_EthPortOutsizedStatsHist_oversizedPacketsDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_SUSPECT = "adaptor_EthPortOutsizedStatsHist_suspect"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_THRESHOLDED = "adaptor_EthPortOutsizedStatsHist_thresholded"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_TIME_COLLECTED = "adaptor_EthPortOutsizedStatsHist_timeCollected"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_UNDERSIZED_BAD_CRC_PACKETS = "adaptor_EthPortOutsizedStatsHist_undersizedBadCrcPackets"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_UNDERSIZED_BAD_CRC_PACKETS_DELTA = "adaptor_EthPortOutsizedStatsHist_undersizedBadCrcPacketsDelta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_UNDERSIZED_BAD_CRC_PACKETS_DELTA_AVG = "adaptor_EthPortOutsizedStatsHist_undersizedBadCrcPacketsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_UNDERSIZED_BAD_CRC_PACKETS_DELTA_MAX = "adaptor_EthPortOutsizedStatsHist_undersizedBadCrcPacketsDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_UNDERSIZED_BAD_CRC_PACKETS_DELTA_MIN = "adaptor_EthPortOutsizedStatsHist_undersizedBadCrcPacketsDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_UNDERSIZED_GOOD_CRC_PACKETS = "adaptor_EthPortOutsizedStatsHist_undersizedGoodCrcPackets"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_UNDERSIZED_GOOD_CRC_PACKETS_DELTA = "adaptor_EthPortOutsizedStatsHist_undersizedGoodCrcPacketsDelta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_UNDERSIZED_GOOD_CRC_PACKETS_DELTA_AVG = "adaptor_EthPortOutsizedStatsHist_undersizedGoodCrcPacketsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_UNDERSIZED_GOOD_CRC_PACKETS_DELTA_MAX = "adaptor_EthPortOutsizedStatsHist_undersizedGoodCrcPacketsDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_UNDERSIZED_GOOD_CRC_PACKETS_DELTA_MIN = "adaptor_EthPortOutsizedStatsHist_undersizedGoodCrcPacketsDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATS_INTERVALS = "adaptor_EthPortOutsizedStats_intervals"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATS_OVERSIZED_BAD_CRC_PACKETS = "adaptor_EthPortOutsizedStats_oversizedBadCrcPackets"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATS_OVERSIZED_BAD_CRC_PACKETS_DELTA = "adaptor_EthPortOutsizedStats_oversizedBadCrcPacketsDelta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATS_OVERSIZED_BAD_CRC_PACKETS_DELTA_AVG = "adaptor_EthPortOutsizedStats_oversizedBadCrcPacketsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATS_OVERSIZED_BAD_CRC_PACKETS_DELTA_MAX = "adaptor_EthPortOutsizedStats_oversizedBadCrcPacketsDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATS_OVERSIZED_BAD_CRC_PACKETS_DELTA_MIN = "adaptor_EthPortOutsizedStats_oversizedBadCrcPacketsDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATS_OVERSIZED_GOOD_CRC_PACKETS = "adaptor_EthPortOutsizedStats_oversizedGoodCrcPackets"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATS_OVERSIZED_GOOD_CRC_PACKETS_DELTA = "adaptor_EthPortOutsizedStats_oversizedGoodCrcPacketsDelta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATS_OVERSIZED_GOOD_CRC_PACKETS_DELTA_AVG = "adaptor_EthPortOutsizedStats_oversizedGoodCrcPacketsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATS_OVERSIZED_GOOD_CRC_PACKETS_DELTA_MAX = "adaptor_EthPortOutsizedStats_oversizedGoodCrcPacketsDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATS_OVERSIZED_GOOD_CRC_PACKETS_DELTA_MIN = "adaptor_EthPortOutsizedStats_oversizedGoodCrcPacketsDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATS_OVERSIZED_PACKETS = "adaptor_EthPortOutsizedStats_oversizedPackets"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATS_OVERSIZED_PACKETS_DELTA = "adaptor_EthPortOutsizedStats_oversizedPacketsDelta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATS_OVERSIZED_PACKETS_DELTA_AVG = "adaptor_EthPortOutsizedStats_oversizedPacketsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATS_OVERSIZED_PACKETS_DELTA_MAX = "adaptor_EthPortOutsizedStats_oversizedPacketsDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATS_OVERSIZED_PACKETS_DELTA_MIN = "adaptor_EthPortOutsizedStats_oversizedPacketsDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATS_SUSPECT = "adaptor_EthPortOutsizedStats_suspect"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATS_THRESHOLDED = "adaptor_EthPortOutsizedStats_thresholded"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATS_TIME_COLLECTED = "adaptor_EthPortOutsizedStats_timeCollected"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATS_TRAFFIC_DIRECTION = "adaptor_EthPortOutsizedStats_trafficDirection"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATS_UNDERSIZED_BAD_CRC_PACKETS = "adaptor_EthPortOutsizedStats_undersizedBadCrcPackets"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATS_UNDERSIZED_BAD_CRC_PACKETS_DELTA = "adaptor_EthPortOutsizedStats_undersizedBadCrcPacketsDelta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATS_UNDERSIZED_BAD_CRC_PACKETS_DELTA_AVG = "adaptor_EthPortOutsizedStats_undersizedBadCrcPacketsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATS_UNDERSIZED_BAD_CRC_PACKETS_DELTA_MAX = "adaptor_EthPortOutsizedStats_undersizedBadCrcPacketsDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATS_UNDERSIZED_BAD_CRC_PACKETS_DELTA_MIN = "adaptor_EthPortOutsizedStats_undersizedBadCrcPacketsDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATS_UNDERSIZED_GOOD_CRC_PACKETS = "adaptor_EthPortOutsizedStats_undersizedGoodCrcPackets"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATS_UNDERSIZED_GOOD_CRC_PACKETS_DELTA = "adaptor_EthPortOutsizedStats_undersizedGoodCrcPacketsDelta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATS_UNDERSIZED_GOOD_CRC_PACKETS_DELTA_AVG = "adaptor_EthPortOutsizedStats_undersizedGoodCrcPacketsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATS_UNDERSIZED_GOOD_CRC_PACKETS_DELTA_MAX = "adaptor_EthPortOutsizedStats_undersizedGoodCrcPacketsDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATS_UNDERSIZED_GOOD_CRC_PACKETS_DELTA_MIN = "adaptor_EthPortOutsizedStats_undersizedGoodCrcPacketsDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATS_UPDATE = "adaptor_EthPortOutsizedStats_update"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATS_HIST_GOOD_PACKETS = "adaptor_EthPortStatsHist_goodPackets"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATS_HIST_GOOD_PACKETS_DELTA = "adaptor_EthPortStatsHist_goodPacketsDelta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATS_HIST_GOOD_PACKETS_DELTA_AVG = "adaptor_EthPortStatsHist_goodPacketsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATS_HIST_GOOD_PACKETS_DELTA_MAX = "adaptor_EthPortStatsHist_goodPacketsDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATS_HIST_GOOD_PACKETS_DELTA_MIN = "adaptor_EthPortStatsHist_goodPacketsDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATS_HIST_ID = "adaptor_EthPortStatsHist_id"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATS_HIST_MOST_RECENT = "adaptor_EthPortStatsHist_mostRecent"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATS_HIST_PAUSE_PACKETS = "adaptor_EthPortStatsHist_pausePackets"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATS_HIST_PAUSE_PACKETS_DELTA = "adaptor_EthPortStatsHist_pausePacketsDelta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATS_HIST_PAUSE_PACKETS_DELTA_AVG = "adaptor_EthPortStatsHist_pausePacketsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATS_HIST_PAUSE_PACKETS_DELTA_MAX = "adaptor_EthPortStatsHist_pausePacketsDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATS_HIST_PAUSE_PACKETS_DELTA_MIN = "adaptor_EthPortStatsHist_pausePacketsDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATS_HIST_PER_PRIORITY_PAUSE_PACKETS = "adaptor_EthPortStatsHist_perPriorityPausePackets"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATS_HIST_PER_PRIORITY_PAUSE_PACKETS_DELTA = "adaptor_EthPortStatsHist_perPriorityPausePacketsDelta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATS_HIST_PER_PRIORITY_PAUSE_PACKETS_DELTA_AVG = "adaptor_EthPortStatsHist_perPriorityPausePacketsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATS_HIST_PER_PRIORITY_PAUSE_PACKETS_DELTA_MAX = "adaptor_EthPortStatsHist_perPriorityPausePacketsDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATS_HIST_PER_PRIORITY_PAUSE_PACKETS_DELTA_MIN = "adaptor_EthPortStatsHist_perPriorityPausePacketsDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATS_HIST_PPP_PACKETS = "adaptor_EthPortStatsHist_pppPackets"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATS_HIST_PPP_PACKETS_DELTA = "adaptor_EthPortStatsHist_pppPacketsDelta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATS_HIST_PPP_PACKETS_DELTA_AVG = "adaptor_EthPortStatsHist_pppPacketsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATS_HIST_PPP_PACKETS_DELTA_MAX = "adaptor_EthPortStatsHist_pppPacketsDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATS_HIST_PPP_PACKETS_DELTA_MIN = "adaptor_EthPortStatsHist_pppPacketsDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATS_HIST_SUSPECT = "adaptor_EthPortStatsHist_suspect"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATS_HIST_THRESHOLDED = "adaptor_EthPortStatsHist_thresholded"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATS_HIST_TIME_COLLECTED = "adaptor_EthPortStatsHist_timeCollected"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATS_HIST_TOTAL_PACKETS = "adaptor_EthPortStatsHist_totalPackets"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATS_HIST_TOTAL_PACKETS_DELTA = "adaptor_EthPortStatsHist_totalPacketsDelta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATS_HIST_TOTAL_PACKETS_DELTA_AVG = "adaptor_EthPortStatsHist_totalPacketsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATS_HIST_TOTAL_PACKETS_DELTA_MAX = "adaptor_EthPortStatsHist_totalPacketsDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATS_HIST_TOTAL_PACKETS_DELTA_MIN = "adaptor_EthPortStatsHist_totalPacketsDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATS_HIST_VLAN_PACKETS = "adaptor_EthPortStatsHist_vlanPackets"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATS_HIST_VLAN_PACKETS_DELTA = "adaptor_EthPortStatsHist_vlanPacketsDelta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATS_HIST_VLAN_PACKETS_DELTA_AVG = "adaptor_EthPortStatsHist_vlanPacketsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATS_HIST_VLAN_PACKETS_DELTA_MAX = "adaptor_EthPortStatsHist_vlanPacketsDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATS_HIST_VLAN_PACKETS_DELTA_MIN = "adaptor_EthPortStatsHist_vlanPacketsDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATS_GOOD_PACKETS = "adaptor_EthPortStats_goodPackets"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATS_GOOD_PACKETS_DELTA = "adaptor_EthPortStats_goodPacketsDelta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATS_GOOD_PACKETS_DELTA_AVG = "adaptor_EthPortStats_goodPacketsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATS_GOOD_PACKETS_DELTA_MAX = "adaptor_EthPortStats_goodPacketsDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATS_GOOD_PACKETS_DELTA_MIN = "adaptor_EthPortStats_goodPacketsDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATS_INTERVALS = "adaptor_EthPortStats_intervals"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATS_PAUSE_PACKETS = "adaptor_EthPortStats_pausePackets"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATS_PAUSE_PACKETS_DELTA = "adaptor_EthPortStats_pausePacketsDelta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATS_PAUSE_PACKETS_DELTA_AVG = "adaptor_EthPortStats_pausePacketsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATS_PAUSE_PACKETS_DELTA_MAX = "adaptor_EthPortStats_pausePacketsDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATS_PAUSE_PACKETS_DELTA_MIN = "adaptor_EthPortStats_pausePacketsDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATS_PER_PRIORITY_PAUSE_PACKETS = "adaptor_EthPortStats_perPriorityPausePackets"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATS_PER_PRIORITY_PAUSE_PACKETS_DELTA = "adaptor_EthPortStats_perPriorityPausePacketsDelta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATS_PER_PRIORITY_PAUSE_PACKETS_DELTA_AVG = "adaptor_EthPortStats_perPriorityPausePacketsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATS_PER_PRIORITY_PAUSE_PACKETS_DELTA_MAX = "adaptor_EthPortStats_perPriorityPausePacketsDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATS_PER_PRIORITY_PAUSE_PACKETS_DELTA_MIN = "adaptor_EthPortStats_perPriorityPausePacketsDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATS_PPP_PACKETS = "adaptor_EthPortStats_pppPackets"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATS_PPP_PACKETS_DELTA = "adaptor_EthPortStats_pppPacketsDelta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATS_PPP_PACKETS_DELTA_AVG = "adaptor_EthPortStats_pppPacketsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATS_PPP_PACKETS_DELTA_MAX = "adaptor_EthPortStats_pppPacketsDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATS_PPP_PACKETS_DELTA_MIN = "adaptor_EthPortStats_pppPacketsDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATS_SUSPECT = "adaptor_EthPortStats_suspect"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATS_THRESHOLDED = "adaptor_EthPortStats_thresholded"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATS_TIME_COLLECTED = "adaptor_EthPortStats_timeCollected"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATS_TOTAL_PACKETS = "adaptor_EthPortStats_totalPackets"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATS_TOTAL_PACKETS_DELTA = "adaptor_EthPortStats_totalPacketsDelta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATS_TOTAL_PACKETS_DELTA_AVG = "adaptor_EthPortStats_totalPacketsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATS_TOTAL_PACKETS_DELTA_MAX = "adaptor_EthPortStats_totalPacketsDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATS_TOTAL_PACKETS_DELTA_MIN = "adaptor_EthPortStats_totalPacketsDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATS_TRAFFIC_DIRECTION = "adaptor_EthPortStats_trafficDirection"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATS_UPDATE = "adaptor_EthPortStats_update"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATS_VLAN_PACKETS = "adaptor_EthPortStats_vlanPackets"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATS_VLAN_PACKETS_DELTA = "adaptor_EthPortStats_vlanPacketsDelta"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATS_VLAN_PACKETS_DELTA_AVG = "adaptor_EthPortStats_vlanPacketsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATS_VLAN_PACKETS_DELTA_MAX = "adaptor_EthPortStats_vlanPacketsDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETH_PORT_STATS_VLAN_PACKETS_DELTA_MIN = "adaptor_EthPortStats_vlanPacketsDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETH_QUEUE_PROFILE_COUNT = "adaptor_EthQueueProfile_count"
	CONST_PROP_ID_ADAPTOR_ETH_QUEUE_PROFILE_RING_SIZE = "adaptor_EthQueueProfile_ringSize"
	CONST_PROP_ID_ADAPTOR_ETH_RECV_QUEUE_PROFILE_COUNT = "adaptor_EthRecvQueueProfile_count"
	CONST_PROP_ID_ADAPTOR_ETH_RECV_QUEUE_PROFILE_RING_SIZE = "adaptor_EthRecvQueueProfile_ringSize"
	CONST_PROP_ID_ADAPTOR_ETH_WORK_QUEUE_PROFILE_COUNT = "adaptor_EthWorkQueueProfile_count"
	CONST_PROP_ID_ADAPTOR_ETH_WORK_QUEUE_PROFILE_RING_SIZE = "adaptor_EthWorkQueueProfile_ringSize"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_HIST_ID = "adaptor_EtherIfStatsHist_id"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_HIST_MOST_RECENT = "adaptor_EtherIfStatsHist_mostRecent"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_HIST_RX_BYTES = "adaptor_EtherIfStatsHist_rxBytes"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_HIST_RX_BYTES_DELTA = "adaptor_EtherIfStatsHist_rxBytesDelta"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_HIST_RX_BYTES_DELTA_AVG = "adaptor_EtherIfStatsHist_rxBytesDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_HIST_RX_BYTES_DELTA_MAX = "adaptor_EtherIfStatsHist_rxBytesDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_HIST_RX_BYTES_DELTA_MIN = "adaptor_EtherIfStatsHist_rxBytesDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_HIST_RX_DROPPED = "adaptor_EtherIfStatsHist_rxDropped"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_HIST_RX_DROPPED_DELTA = "adaptor_EtherIfStatsHist_rxDroppedDelta"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_HIST_RX_DROPPED_DELTA_AVG = "adaptor_EtherIfStatsHist_rxDroppedDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_HIST_RX_DROPPED_DELTA_MAX = "adaptor_EtherIfStatsHist_rxDroppedDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_HIST_RX_DROPPED_DELTA_MIN = "adaptor_EtherIfStatsHist_rxDroppedDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_HIST_RX_ERRORS = "adaptor_EtherIfStatsHist_rxErrors"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_HIST_RX_ERRORS_DELTA = "adaptor_EtherIfStatsHist_rxErrorsDelta"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_HIST_RX_ERRORS_DELTA_AVG = "adaptor_EtherIfStatsHist_rxErrorsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_HIST_RX_ERRORS_DELTA_MAX = "adaptor_EtherIfStatsHist_rxErrorsDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_HIST_RX_ERRORS_DELTA_MIN = "adaptor_EtherIfStatsHist_rxErrorsDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_HIST_RX_PACKETS = "adaptor_EtherIfStatsHist_rxPackets"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_HIST_RX_PACKETS_DELTA = "adaptor_EtherIfStatsHist_rxPacketsDelta"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_HIST_RX_PACKETS_DELTA_AVG = "adaptor_EtherIfStatsHist_rxPacketsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_HIST_RX_PACKETS_DELTA_MAX = "adaptor_EtherIfStatsHist_rxPacketsDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_HIST_RX_PACKETS_DELTA_MIN = "adaptor_EtherIfStatsHist_rxPacketsDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_HIST_SUSPECT = "adaptor_EtherIfStatsHist_suspect"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_HIST_THRESHOLDED = "adaptor_EtherIfStatsHist_thresholded"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_HIST_TIME_COLLECTED = "adaptor_EtherIfStatsHist_timeCollected"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_HIST_TX_BYTES = "adaptor_EtherIfStatsHist_txBytes"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_HIST_TX_BYTES_DELTA = "adaptor_EtherIfStatsHist_txBytesDelta"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_HIST_TX_BYTES_DELTA_AVG = "adaptor_EtherIfStatsHist_txBytesDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_HIST_TX_BYTES_DELTA_MAX = "adaptor_EtherIfStatsHist_txBytesDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_HIST_TX_BYTES_DELTA_MIN = "adaptor_EtherIfStatsHist_txBytesDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_HIST_TX_DROPPED = "adaptor_EtherIfStatsHist_txDropped"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_HIST_TX_DROPPED_DELTA = "adaptor_EtherIfStatsHist_txDroppedDelta"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_HIST_TX_DROPPED_DELTA_AVG = "adaptor_EtherIfStatsHist_txDroppedDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_HIST_TX_DROPPED_DELTA_MAX = "adaptor_EtherIfStatsHist_txDroppedDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_HIST_TX_DROPPED_DELTA_MIN = "adaptor_EtherIfStatsHist_txDroppedDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_HIST_TX_ERRORS = "adaptor_EtherIfStatsHist_txErrors"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_HIST_TX_ERRORS_DELTA = "adaptor_EtherIfStatsHist_txErrorsDelta"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_HIST_TX_ERRORS_DELTA_AVG = "adaptor_EtherIfStatsHist_txErrorsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_HIST_TX_ERRORS_DELTA_MAX = "adaptor_EtherIfStatsHist_txErrorsDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_HIST_TX_ERRORS_DELTA_MIN = "adaptor_EtherIfStatsHist_txErrorsDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_HIST_TX_PACKETS = "adaptor_EtherIfStatsHist_txPackets"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_HIST_TX_PACKETS_DELTA = "adaptor_EtherIfStatsHist_txPacketsDelta"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_HIST_TX_PACKETS_DELTA_AVG = "adaptor_EtherIfStatsHist_txPacketsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_HIST_TX_PACKETS_DELTA_MAX = "adaptor_EtherIfStatsHist_txPacketsDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_HIST_TX_PACKETS_DELTA_MIN = "adaptor_EtherIfStatsHist_txPacketsDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_INTERVALS = "adaptor_EtherIfStats_intervals"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_RX_BYTES = "adaptor_EtherIfStats_rxBytes"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_RX_BYTES_DELTA = "adaptor_EtherIfStats_rxBytesDelta"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_RX_BYTES_DELTA_AVG = "adaptor_EtherIfStats_rxBytesDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_RX_BYTES_DELTA_MAX = "adaptor_EtherIfStats_rxBytesDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_RX_BYTES_DELTA_MIN = "adaptor_EtherIfStats_rxBytesDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_RX_DROPPED = "adaptor_EtherIfStats_rxDropped"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_RX_DROPPED_DELTA = "adaptor_EtherIfStats_rxDroppedDelta"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_RX_DROPPED_DELTA_AVG = "adaptor_EtherIfStats_rxDroppedDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_RX_DROPPED_DELTA_MAX = "adaptor_EtherIfStats_rxDroppedDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_RX_DROPPED_DELTA_MIN = "adaptor_EtherIfStats_rxDroppedDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_RX_ERRORS = "adaptor_EtherIfStats_rxErrors"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_RX_ERRORS_DELTA = "adaptor_EtherIfStats_rxErrorsDelta"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_RX_ERRORS_DELTA_AVG = "adaptor_EtherIfStats_rxErrorsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_RX_ERRORS_DELTA_MAX = "adaptor_EtherIfStats_rxErrorsDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_RX_ERRORS_DELTA_MIN = "adaptor_EtherIfStats_rxErrorsDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_RX_PACKETS = "adaptor_EtherIfStats_rxPackets"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_RX_PACKETS_DELTA = "adaptor_EtherIfStats_rxPacketsDelta"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_RX_PACKETS_DELTA_AVG = "adaptor_EtherIfStats_rxPacketsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_RX_PACKETS_DELTA_MAX = "adaptor_EtherIfStats_rxPacketsDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_RX_PACKETS_DELTA_MIN = "adaptor_EtherIfStats_rxPacketsDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_SUSPECT = "adaptor_EtherIfStats_suspect"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_THRESHOLDED = "adaptor_EtherIfStats_thresholded"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_TIME_COLLECTED = "adaptor_EtherIfStats_timeCollected"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_TX_BYTES = "adaptor_EtherIfStats_txBytes"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_TX_BYTES_DELTA = "adaptor_EtherIfStats_txBytesDelta"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_TX_BYTES_DELTA_AVG = "adaptor_EtherIfStats_txBytesDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_TX_BYTES_DELTA_MAX = "adaptor_EtherIfStats_txBytesDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_TX_BYTES_DELTA_MIN = "adaptor_EtherIfStats_txBytesDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_TX_DROPPED = "adaptor_EtherIfStats_txDropped"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_TX_DROPPED_DELTA = "adaptor_EtherIfStats_txDroppedDelta"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_TX_DROPPED_DELTA_AVG = "adaptor_EtherIfStats_txDroppedDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_TX_DROPPED_DELTA_MAX = "adaptor_EtherIfStats_txDroppedDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_TX_DROPPED_DELTA_MIN = "adaptor_EtherIfStats_txDroppedDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_TX_ERRORS = "adaptor_EtherIfStats_txErrors"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_TX_ERRORS_DELTA = "adaptor_EtherIfStats_txErrorsDelta"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_TX_ERRORS_DELTA_AVG = "adaptor_EtherIfStats_txErrorsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_TX_ERRORS_DELTA_MAX = "adaptor_EtherIfStats_txErrorsDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_TX_ERRORS_DELTA_MIN = "adaptor_EtherIfStats_txErrorsDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_TX_PACKETS = "adaptor_EtherIfStats_txPackets"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_TX_PACKETS_DELTA = "adaptor_EtherIfStats_txPacketsDelta"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_TX_PACKETS_DELTA_AVG = "adaptor_EtherIfStats_txPacketsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_TX_PACKETS_DELTA_MAX = "adaptor_EtherIfStats_txPacketsDeltaMax"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_TX_PACKETS_DELTA_MIN = "adaptor_EtherIfStats_txPacketsDeltaMin"
	CONST_PROP_ID_ADAPTOR_ETHER_IF_STATS_UPDATE = "adaptor_EtherIfStats_update"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_FSM_STAGE_DESCR = "adaptor_ExtEthIfFsmStage_descr"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_FSM_STAGE_LAST_UPDATE_TIME = "adaptor_ExtEthIfFsmStage_lastUpdateTime"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_FSM_STAGE_NAME = "adaptor_ExtEthIfFsmStage_name"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_FSM_STAGE_ORDER = "adaptor_ExtEthIfFsmStage_order"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_FSM_STAGE_RETRY = "adaptor_ExtEthIfFsmStage_retry"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_FSM_STAGE_STAGE_STATUS = "adaptor_ExtEthIfFsmStage_stageStatus"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_FSM_TASK_COMPLETION = "adaptor_ExtEthIfFsmTask_completion"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_FSM_TASK_FLAGS = "adaptor_ExtEthIfFsmTask_flags"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_FSM_TASK_ITEM = "adaptor_ExtEthIfFsmTask_item"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_FSM_TASK_SEQ_ID = "adaptor_ExtEthIfFsmTask_seqId"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_FSM_COMPLETION_TIME = "adaptor_ExtEthIfFsm_completionTime"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_FSM_CURRENT_FSM = "adaptor_ExtEthIfFsm_currentFsm"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_FSM_DESCR = "adaptor_ExtEthIfFsm_descr"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_FSM_FSM_STATUS = "adaptor_ExtEthIfFsm_fsmStatus"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_FSM_INSTANCE_ID = "adaptor_ExtEthIfFsm_instanceId"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_FSM_PROGRESS = "adaptor_ExtEthIfFsm_progress"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_FSM_RMT_ERR_CODE = "adaptor_ExtEthIfFsm_rmtErrCode"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_FSM_RMT_ERR_DESCR = "adaptor_ExtEthIfFsm_rmtErrDescr"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_FSM_RMT_RSLT = "adaptor_ExtEthIfFsm_rmtRslt"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_PC_EP_CHASSIS_ID = "adaptor_ExtEthIfPcEp_chassisId"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_PC_EP_EP_DN = "adaptor_ExtEthIfPcEp_epDn"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_PC_EP_IF_ROLE = "adaptor_ExtEthIfPcEp_ifRole"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_PC_EP_IF_TYPE = "adaptor_ExtEthIfPcEp_ifType"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_PC_EP_LOCALE = "adaptor_ExtEthIfPcEp_locale"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_PC_EP_MEMBERSHIP = "adaptor_ExtEthIfPcEp_membership"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_PC_EP_NAME = "adaptor_ExtEthIfPcEp_name"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_PC_EP_PEER_CHASSIS_ID = "adaptor_ExtEthIfPcEp_peerChassisId"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_PC_EP_PEER_DN = "adaptor_ExtEthIfPcEp_peerDn"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_PC_EP_PEER_PORT_ID = "adaptor_ExtEthIfPcEp_peerPortId"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_PC_EP_PEER_SLOT_ID = "adaptor_ExtEthIfPcEp_peerSlotId"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_PC_EP_PORT_ID = "adaptor_ExtEthIfPcEp_portId"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_PC_EP_SLOT_ID = "adaptor_ExtEthIfPcEp_slotId"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_PC_EP_SWITCH_ID = "adaptor_ExtEthIfPcEp_switchId"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_PC_EP_TRANSPORT = "adaptor_ExtEthIfPcEp_transport"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_PC_EP_TYPE = "adaptor_ExtEthIfPcEp_type"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_PC_EP_DN = "adaptor_ExtEthIfPc_epDn"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_PC_FLT_AGGR = "adaptor_ExtEthIfPc_fltAggr"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_PC_IF_ROLE = "adaptor_ExtEthIfPc_ifRole"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_PC_IF_TYPE = "adaptor_ExtEthIfPc_ifType"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_PC_LOCALE = "adaptor_ExtEthIfPc_locale"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_PC_MAC = "adaptor_ExtEthIfPc_mac"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_PC_NAME = "adaptor_ExtEthIfPc_name"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_PC_OPER_SPEED = "adaptor_ExtEthIfPc_operSpeed"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_PC_OPER_STATE = "adaptor_ExtEthIfPc_operState"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_PC_PEER_DN = "adaptor_ExtEthIfPc_peerDn"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_PC_PORT_ID = "adaptor_ExtEthIfPc_portId"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_PC_STATE_QUAL = "adaptor_ExtEthIfPc_stateQual"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_PC_SWITCH_ID = "adaptor_ExtEthIfPc_switchId"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_PC_TRANSPORT = "adaptor_ExtEthIfPc_transport"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_PC_TYPE = "adaptor_ExtEthIfPc_type"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_ADAPTER_ID = "adaptor_ExtEthIf_adapterId"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_ADMIN_STATE = "adaptor_ExtEthIf_adminState"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_CHASSIS_ID = "adaptor_ExtEthIf_chassisId"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_DISCOVERY = "adaptor_ExtEthIf_discovery"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_EP_DN = "adaptor_ExtEthIf_epDn"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_FSM_DESCR = "adaptor_ExtEthIf_fsmDescr"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_FSM_PREV = "adaptor_ExtEthIf_fsmPrev"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_FSM_PROGR = "adaptor_ExtEthIf_fsmProgr"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_FSM_RMT_INV_ERR_CODE = "adaptor_ExtEthIf_fsmRmtInvErrCode"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_FSM_RMT_INV_ERR_DESCR = "adaptor_ExtEthIf_fsmRmtInvErrDescr"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_FSM_RMT_INV_RSLT = "adaptor_ExtEthIf_fsmRmtInvRslt"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_FSM_STAGE_DESCR = "adaptor_ExtEthIf_fsmStageDescr"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_FSM_STAMP = "adaptor_ExtEthIf_fsmStamp"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_FSM_STATUS = "adaptor_ExtEthIf_fsmStatus"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_FSM_TRY = "adaptor_ExtEthIf_fsmTry"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_ID = "adaptor_ExtEthIf_id"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_IF_ROLE = "adaptor_ExtEthIf_ifRole"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_IF_TYPE = "adaptor_ExtEthIf_ifType"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_LINK_STATE = "adaptor_ExtEthIf_linkState"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_LLDP_MAC = "adaptor_ExtEthIf_lldpMac"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_LOCALE = "adaptor_ExtEthIf_locale"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_MAC = "adaptor_ExtEthIf_mac"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_MAC_ADDR_TYPE = "adaptor_ExtEthIf_macAddrType"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_NAME = "adaptor_ExtEthIf_name"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_OPER_STATE = "adaptor_ExtEthIf_operState"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_OPER_STATE_DESC = "adaptor_ExtEthIf_operStateDesc"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_PEER_CHASSIS_ID = "adaptor_ExtEthIf_peerChassisId"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_PEER_DN = "adaptor_ExtEthIf_peerDn"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_PEER_PORT_ID = "adaptor_ExtEthIf_peerPortId"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_PEER_SLOT_ID = "adaptor_ExtEthIf_peerSlotId"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_PHYS_EP_DN = "adaptor_ExtEthIf_physEpDn"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_PORT_ID = "adaptor_ExtEthIf_portId"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_PURPOSE = "adaptor_ExtEthIf_purpose"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_SIDE = "adaptor_ExtEthIf_side"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_SLOT_ID = "adaptor_ExtEthIf_slotId"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_SWITCH_ID = "adaptor_ExtEthIf_switchId"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_TRANSPORT = "adaptor_ExtEthIf_transport"
	CONST_PROP_ID_ADAPTOR_EXT_ETH_IF_TYPE = "adaptor_ExtEthIf_type"
	CONST_PROP_ID_ADAPTOR_EXT_IF_EP_CHASSIS_ID = "adaptor_ExtIfEp_chassisId"
	CONST_PROP_ID_ADAPTOR_EXT_IF_EP_EP_DN = "adaptor_ExtIfEp_epDn"
	CONST_PROP_ID_ADAPTOR_EXT_IF_EP_IF_ROLE = "adaptor_ExtIfEp_ifRole"
	CONST_PROP_ID_ADAPTOR_EXT_IF_EP_IF_TYPE = "adaptor_ExtIfEp_ifType"
	CONST_PROP_ID_ADAPTOR_EXT_IF_EP_LOCALE = "adaptor_ExtIfEp_locale"
	CONST_PROP_ID_ADAPTOR_EXT_IF_EP_NAME = "adaptor_ExtIfEp_name"
	CONST_PROP_ID_ADAPTOR_EXT_IF_EP_PEER_CHASSIS_ID = "adaptor_ExtIfEp_peerChassisId"
	CONST_PROP_ID_ADAPTOR_EXT_IF_EP_PEER_DN = "adaptor_ExtIfEp_peerDn"
	CONST_PROP_ID_ADAPTOR_EXT_IF_EP_PEER_PORT_ID = "adaptor_ExtIfEp_peerPortId"
	CONST_PROP_ID_ADAPTOR_EXT_IF_EP_PEER_SLOT_ID = "adaptor_ExtIfEp_peerSlotId"
	CONST_PROP_ID_ADAPTOR_EXT_IF_EP_PORT_ID = "adaptor_ExtIfEp_portId"
	CONST_PROP_ID_ADAPTOR_EXT_IF_EP_SLOT_ID = "adaptor_ExtIfEp_slotId"
	CONST_PROP_ID_ADAPTOR_EXT_IF_EP_SWITCH_ID = "adaptor_ExtIfEp_switchId"
	CONST_PROP_ID_ADAPTOR_EXT_IF_EP_TRANSPORT = "adaptor_ExtIfEp_transport"
	CONST_PROP_ID_ADAPTOR_EXT_IF_EP_TYPE = "adaptor_ExtIfEp_type"
	CONST_PROP_ID_ADAPTOR_EXT_IF_PC_EP_DN = "adaptor_ExtIfPc_epDn"
	CONST_PROP_ID_ADAPTOR_EXT_IF_PC_FLT_AGGR = "adaptor_ExtIfPc_fltAggr"
	CONST_PROP_ID_ADAPTOR_EXT_IF_PC_IF_ROLE = "adaptor_ExtIfPc_ifRole"
	CONST_PROP_ID_ADAPTOR_EXT_IF_PC_IF_TYPE = "adaptor_ExtIfPc_ifType"
	CONST_PROP_ID_ADAPTOR_EXT_IF_PC_LOCALE = "adaptor_ExtIfPc_locale"
	CONST_PROP_ID_ADAPTOR_EXT_IF_PC_NAME = "adaptor_ExtIfPc_name"
	CONST_PROP_ID_ADAPTOR_EXT_IF_PC_OPER_SPEED = "adaptor_ExtIfPc_operSpeed"
	CONST_PROP_ID_ADAPTOR_EXT_IF_PC_OPER_STATE = "adaptor_ExtIfPc_operState"
	CONST_PROP_ID_ADAPTOR_EXT_IF_PC_PEER_DN = "adaptor_ExtIfPc_peerDn"
	CONST_PROP_ID_ADAPTOR_EXT_IF_PC_PORT_ID = "adaptor_ExtIfPc_portId"
	CONST_PROP_ID_ADAPTOR_EXT_IF_PC_STATE_QUAL = "adaptor_ExtIfPc_stateQual"
	CONST_PROP_ID_ADAPTOR_EXT_IF_PC_SWITCH_ID = "adaptor_ExtIfPc_switchId"
	CONST_PROP_ID_ADAPTOR_EXT_IF_PC_TRANSPORT = "adaptor_ExtIfPc_transport"
	CONST_PROP_ID_ADAPTOR_EXT_IF_PC_TYPE = "adaptor_ExtIfPc_type"
	CONST_PROP_ID_ADAPTOR_EXT_IF_ADAPTER_ID = "adaptor_ExtIf_adapterId"
	CONST_PROP_ID_ADAPTOR_EXT_IF_ADMIN_STATE = "adaptor_ExtIf_adminState"
	CONST_PROP_ID_ADAPTOR_EXT_IF_CHASSIS_ID = "adaptor_ExtIf_chassisId"
	CONST_PROP_ID_ADAPTOR_EXT_IF_DISCOVERY = "adaptor_ExtIf_discovery"
	CONST_PROP_ID_ADAPTOR_EXT_IF_EP_DN = "adaptor_ExtIf_epDn"
	CONST_PROP_ID_ADAPTOR_EXT_IF_ID = "adaptor_ExtIf_id"
	CONST_PROP_ID_ADAPTOR_EXT_IF_IF_ROLE = "adaptor_ExtIf_ifRole"
	CONST_PROP_ID_ADAPTOR_EXT_IF_IF_TYPE = "adaptor_ExtIf_ifType"
	CONST_PROP_ID_ADAPTOR_EXT_IF_LINK_STATE = "adaptor_ExtIf_linkState"
	CONST_PROP_ID_ADAPTOR_EXT_IF_LLDP_MAC = "adaptor_ExtIf_lldpMac"
	CONST_PROP_ID_ADAPTOR_EXT_IF_LOCALE = "adaptor_ExtIf_locale"
	CONST_PROP_ID_ADAPTOR_EXT_IF_MAC = "adaptor_ExtIf_mac"
	CONST_PROP_ID_ADAPTOR_EXT_IF_NAME = "adaptor_ExtIf_name"
	CONST_PROP_ID_ADAPTOR_EXT_IF_OPER_STATE = "adaptor_ExtIf_operState"
	CONST_PROP_ID_ADAPTOR_EXT_IF_OPER_STATE_DESC = "adaptor_ExtIf_operStateDesc"
	CONST_PROP_ID_ADAPTOR_EXT_IF_PEER_CHASSIS_ID = "adaptor_ExtIf_peerChassisId"
	CONST_PROP_ID_ADAPTOR_EXT_IF_PEER_DN = "adaptor_ExtIf_peerDn"
	CONST_PROP_ID_ADAPTOR_EXT_IF_PEER_PORT_ID = "adaptor_ExtIf_peerPortId"
	CONST_PROP_ID_ADAPTOR_EXT_IF_PEER_SLOT_ID = "adaptor_ExtIf_peerSlotId"
	CONST_PROP_ID_ADAPTOR_EXT_IF_PHYS_EP_DN = "adaptor_ExtIf_physEpDn"
	CONST_PROP_ID_ADAPTOR_EXT_IF_PORT_ID = "adaptor_ExtIf_portId"
	CONST_PROP_ID_ADAPTOR_EXT_IF_PURPOSE = "adaptor_ExtIf_purpose"
	CONST_PROP_ID_ADAPTOR_EXT_IF_SIDE = "adaptor_ExtIf_side"
	CONST_PROP_ID_ADAPTOR_EXT_IF_SLOT_ID = "adaptor_ExtIf_slotId"
	CONST_PROP_ID_ADAPTOR_EXT_IF_SWITCH_ID = "adaptor_ExtIf_switchId"
	CONST_PROP_ID_ADAPTOR_EXT_IF_TRANSPORT = "adaptor_ExtIf_transport"
	CONST_PROP_ID_ADAPTOR_EXT_IF_TYPE = "adaptor_ExtIf_type"
	CONST_PROP_ID_ADAPTOR_EXT_IP_V6_RSS_HASH_PROFILE_IP_HASH = "adaptor_ExtIpV6RssHashProfile_ipHash"
	CONST_PROP_ID_ADAPTOR_EXT_IP_V6_RSS_HASH_PROFILE_TCP_HASH = "adaptor_ExtIpV6RssHashProfile_tcpHash"
	CONST_PROP_ID_ADAPTOR_EXTERNAL_EP_CHASSIS_ID = "adaptor_ExternalEp_chassisId"
	CONST_PROP_ID_ADAPTOR_EXTERNAL_EP_EP_DN = "adaptor_ExternalEp_epDn"
	CONST_PROP_ID_ADAPTOR_EXTERNAL_EP_IF_ROLE = "adaptor_ExternalEp_ifRole"
	CONST_PROP_ID_ADAPTOR_EXTERNAL_EP_IF_TYPE = "adaptor_ExternalEp_ifType"
	CONST_PROP_ID_ADAPTOR_EXTERNAL_EP_LOCALE = "adaptor_ExternalEp_locale"
	CONST_PROP_ID_ADAPTOR_EXTERNAL_EP_NAME = "adaptor_ExternalEp_name"
	CONST_PROP_ID_ADAPTOR_EXTERNAL_EP_PEER_CHASSIS_ID = "adaptor_ExternalEp_peerChassisId"
	CONST_PROP_ID_ADAPTOR_EXTERNAL_EP_PEER_DN = "adaptor_ExternalEp_peerDn"
	CONST_PROP_ID_ADAPTOR_EXTERNAL_EP_PEER_PORT_ID = "adaptor_ExternalEp_peerPortId"
	CONST_PROP_ID_ADAPTOR_EXTERNAL_EP_PEER_SLOT_ID = "adaptor_ExternalEp_peerSlotId"
	CONST_PROP_ID_ADAPTOR_EXTERNAL_EP_PORT_ID = "adaptor_ExternalEp_portId"
	CONST_PROP_ID_ADAPTOR_EXTERNAL_EP_SLOT_ID = "adaptor_ExternalEp_slotId"
	CONST_PROP_ID_ADAPTOR_EXTERNAL_EP_SWITCH_ID = "adaptor_ExternalEp_switchId"
	CONST_PROP_ID_ADAPTOR_EXTERNAL_EP_TRANSPORT = "adaptor_ExternalEp_transport"
	CONST_PROP_ID_ADAPTOR_EXTERNAL_EP_TYPE = "adaptor_ExternalEp_type"
	CONST_PROP_ID_ADAPTOR_EXTERNAL_PC_EP_DN = "adaptor_ExternalPc_epDn"
	CONST_PROP_ID_ADAPTOR_EXTERNAL_PC_IF_ROLE = "adaptor_ExternalPc_ifRole"
	CONST_PROP_ID_ADAPTOR_EXTERNAL_PC_IF_TYPE = "adaptor_ExternalPc_ifType"
	CONST_PROP_ID_ADAPTOR_EXTERNAL_PC_LOCALE = "adaptor_ExternalPc_locale"
	CONST_PROP_ID_ADAPTOR_EXTERNAL_PC_NAME = "adaptor_ExternalPc_name"
	CONST_PROP_ID_ADAPTOR_EXTERNAL_PC_OPER_STATE = "adaptor_ExternalPc_operState"
	CONST_PROP_ID_ADAPTOR_EXTERNAL_PC_PEER_DN = "adaptor_ExternalPc_peerDn"
	CONST_PROP_ID_ADAPTOR_EXTERNAL_PC_PORT_ID = "adaptor_ExternalPc_portId"
	CONST_PROP_ID_ADAPTOR_EXTERNAL_PC_STATE_QUAL = "adaptor_ExternalPc_stateQual"
	CONST_PROP_ID_ADAPTOR_EXTERNAL_PC_SWITCH_ID = "adaptor_ExternalPc_switchId"
	CONST_PROP_ID_ADAPTOR_EXTERNAL_PC_TRANSPORT = "adaptor_ExternalPc_transport"
	CONST_PROP_ID_ADAPTOR_EXTERNAL_PC_TYPE = "adaptor_ExternalPc_type"
	CONST_PROP_ID_ADAPTOR_FAMILY_TYPE_DEF_IS_PASSTHROUGH = "adaptor_FamilyTypeDef_isPassthrough"
	CONST_PROP_ID_ADAPTOR_FAMILY_TYPE_DEF_NUM_DCE_PORTS = "adaptor_FamilyTypeDef_numDcePorts"
	CONST_PROP_ID_ADAPTOR_FAMILY_TYPE_DEF_PORT_FAMILY = "adaptor_FamilyTypeDef_portFamily"
	CONST_PROP_ID_ADAPTOR_FAMILY_TYPE_DEF_TYPE = "adaptor_FamilyTypeDef_type"
	CONST_PROP_ID_ADAPTOR_FC_CDB_WORK_QUEUE_PROFILE_COUNT = "adaptor_FcCdbWorkQueueProfile_count"
	CONST_PROP_ID_ADAPTOR_FC_CDB_WORK_QUEUE_PROFILE_RING_SIZE = "adaptor_FcCdbWorkQueueProfile_ringSize"
	CONST_PROP_ID_ADAPTOR_FC_ERROR_RECOVERY_PROFILE_ERROR_DETECT_TIMEOUT = "adaptor_FcErrorRecoveryProfile_errorDetectTimeout"
	CONST_PROP_ID_ADAPTOR_FC_ERROR_RECOVERY_PROFILE_FCP_ERROR_RECOVERY = "adaptor_FcErrorRecoveryProfile_fcpErrorRecovery"
	CONST_PROP_ID_ADAPTOR_FC_ERROR_RECOVERY_PROFILE_LINK_DOWN_TIMEOUT = "adaptor_FcErrorRecoveryProfile_linkDownTimeout"
	CONST_PROP_ID_ADAPTOR_FC_ERROR_RECOVERY_PROFILE_PORT_DOWN_IO_RETRY_COUNT = "adaptor_FcErrorRecoveryProfile_portDownIoRetryCount"
	CONST_PROP_ID_ADAPTOR_FC_ERROR_RECOVERY_PROFILE_PORT_DOWN_TIMEOUT = "adaptor_FcErrorRecoveryProfile_portDownTimeout"
	CONST_PROP_ID_ADAPTOR_FC_ERROR_RECOVERY_PROFILE_RESOURCE_ALLOCATION_TIMEOUT = "adaptor_FcErrorRecoveryProfile_resourceAllocationTimeout"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_HIST_ID = "adaptor_FcIfEventStatsHist_id"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_HIST_INVALID_CRCCOUNT = "adaptor_FcIfEventStatsHist_invalidCRCCount"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_HIST_INVALID_CRCCOUNT_DELTA = "adaptor_FcIfEventStatsHist_invalidCRCCountDelta"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_HIST_INVALID_CRCCOUNT_DELTA_AVG = "adaptor_FcIfEventStatsHist_invalidCRCCountDeltaAvg"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_HIST_INVALID_CRCCOUNT_DELTA_MAX = "adaptor_FcIfEventStatsHist_invalidCRCCountDeltaMax"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_HIST_INVALID_CRCCOUNT_DELTA_MIN = "adaptor_FcIfEventStatsHist_invalidCRCCountDeltaMin"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_HIST_LINK_FAILURE_COUNT = "adaptor_FcIfEventStatsHist_linkFailureCount"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_HIST_LINK_FAILURE_COUNT_DELTA = "adaptor_FcIfEventStatsHist_linkFailureCountDelta"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_HIST_LINK_FAILURE_COUNT_DELTA_AVG = "adaptor_FcIfEventStatsHist_linkFailureCountDeltaAvg"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_HIST_LINK_FAILURE_COUNT_DELTA_MAX = "adaptor_FcIfEventStatsHist_linkFailureCountDeltaMax"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_HIST_LINK_FAILURE_COUNT_DELTA_MIN = "adaptor_FcIfEventStatsHist_linkFailureCountDeltaMin"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_HIST_LIP_COUNT = "adaptor_FcIfEventStatsHist_lipCount"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_HIST_LIP_COUNT_DELTA = "adaptor_FcIfEventStatsHist_lipCountDelta"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_HIST_LIP_COUNT_DELTA_AVG = "adaptor_FcIfEventStatsHist_lipCountDeltaAvg"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_HIST_LIP_COUNT_DELTA_MAX = "adaptor_FcIfEventStatsHist_lipCountDeltaMax"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_HIST_LIP_COUNT_DELTA_MIN = "adaptor_FcIfEventStatsHist_lipCountDeltaMin"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_HIST_LOSS_OF_SIGNAL_COUNT = "adaptor_FcIfEventStatsHist_lossOfSignalCount"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_HIST_LOSS_OF_SIGNAL_COUNT_DELTA = "adaptor_FcIfEventStatsHist_lossOfSignalCountDelta"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_HIST_LOSS_OF_SIGNAL_COUNT_DELTA_AVG = "adaptor_FcIfEventStatsHist_lossOfSignalCountDeltaAvg"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_HIST_LOSS_OF_SIGNAL_COUNT_DELTA_MAX = "adaptor_FcIfEventStatsHist_lossOfSignalCountDeltaMax"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_HIST_LOSS_OF_SIGNAL_COUNT_DELTA_MIN = "adaptor_FcIfEventStatsHist_lossOfSignalCountDeltaMin"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_HIST_LOSS_OF_SYNC_COUNT = "adaptor_FcIfEventStatsHist_lossOfSyncCount"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_HIST_LOSS_OF_SYNC_COUNT_DELTA = "adaptor_FcIfEventStatsHist_lossOfSyncCountDelta"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_HIST_LOSS_OF_SYNC_COUNT_DELTA_AVG = "adaptor_FcIfEventStatsHist_lossOfSyncCountDeltaAvg"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_HIST_LOSS_OF_SYNC_COUNT_DELTA_MAX = "adaptor_FcIfEventStatsHist_lossOfSyncCountDeltaMax"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_HIST_LOSS_OF_SYNC_COUNT_DELTA_MIN = "adaptor_FcIfEventStatsHist_lossOfSyncCountDeltaMin"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_HIST_MOST_RECENT = "adaptor_FcIfEventStatsHist_mostRecent"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_HIST_N_OSCOUNT = "adaptor_FcIfEventStatsHist_nOSCount"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_HIST_N_OSCOUNT_DELTA = "adaptor_FcIfEventStatsHist_nOSCountDelta"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_HIST_N_OSCOUNT_DELTA_AVG = "adaptor_FcIfEventStatsHist_nOSCountDeltaAvg"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_HIST_N_OSCOUNT_DELTA_MAX = "adaptor_FcIfEventStatsHist_nOSCountDeltaMax"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_HIST_N_OSCOUNT_DELTA_MIN = "adaptor_FcIfEventStatsHist_nOSCountDeltaMin"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_HIST_SECONDS_SINCE_LAST_RESET = "adaptor_FcIfEventStatsHist_secondsSinceLastReset"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_HIST_SECONDS_SINCE_LAST_RESET_DELTA = "adaptor_FcIfEventStatsHist_secondsSinceLastResetDelta"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_HIST_SECONDS_SINCE_LAST_RESET_DELTA_AVG = "adaptor_FcIfEventStatsHist_secondsSinceLastResetDeltaAvg"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_HIST_SECONDS_SINCE_LAST_RESET_DELTA_MAX = "adaptor_FcIfEventStatsHist_secondsSinceLastResetDeltaMax"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_HIST_SECONDS_SINCE_LAST_RESET_DELTA_MIN = "adaptor_FcIfEventStatsHist_secondsSinceLastResetDeltaMin"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_HIST_SEQ_PROTOCOL_ERR_COUNT = "adaptor_FcIfEventStatsHist_seqProtocolErrCount"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_HIST_SEQ_PROTOCOL_ERR_COUNT_DELTA = "adaptor_FcIfEventStatsHist_seqProtocolErrCountDelta"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_HIST_SEQ_PROTOCOL_ERR_COUNT_DELTA_AVG = "adaptor_FcIfEventStatsHist_seqProtocolErrCountDeltaAvg"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_HIST_SEQ_PROTOCOL_ERR_COUNT_DELTA_MAX = "adaptor_FcIfEventStatsHist_seqProtocolErrCountDeltaMax"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_HIST_SEQ_PROTOCOL_ERR_COUNT_DELTA_MIN = "adaptor_FcIfEventStatsHist_seqProtocolErrCountDeltaMin"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_HIST_SUSPECT = "adaptor_FcIfEventStatsHist_suspect"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_HIST_THRESHOLDED = "adaptor_FcIfEventStatsHist_thresholded"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_HIST_TIME_COLLECTED = "adaptor_FcIfEventStatsHist_timeCollected"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_INTERVALS = "adaptor_FcIfEventStats_intervals"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_INVALID_CRCCOUNT = "adaptor_FcIfEventStats_invalidCRCCount"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_INVALID_CRCCOUNT_DELTA = "adaptor_FcIfEventStats_invalidCRCCountDelta"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_INVALID_CRCCOUNT_DELTA_AVG = "adaptor_FcIfEventStats_invalidCRCCountDeltaAvg"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_INVALID_CRCCOUNT_DELTA_MAX = "adaptor_FcIfEventStats_invalidCRCCountDeltaMax"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_INVALID_CRCCOUNT_DELTA_MIN = "adaptor_FcIfEventStats_invalidCRCCountDeltaMin"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_LINK_FAILURE_COUNT = "adaptor_FcIfEventStats_linkFailureCount"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_LINK_FAILURE_COUNT_DELTA = "adaptor_FcIfEventStats_linkFailureCountDelta"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_LINK_FAILURE_COUNT_DELTA_AVG = "adaptor_FcIfEventStats_linkFailureCountDeltaAvg"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_LINK_FAILURE_COUNT_DELTA_MAX = "adaptor_FcIfEventStats_linkFailureCountDeltaMax"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_LINK_FAILURE_COUNT_DELTA_MIN = "adaptor_FcIfEventStats_linkFailureCountDeltaMin"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_LIP_COUNT = "adaptor_FcIfEventStats_lipCount"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_LIP_COUNT_DELTA = "adaptor_FcIfEventStats_lipCountDelta"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_LIP_COUNT_DELTA_AVG = "adaptor_FcIfEventStats_lipCountDeltaAvg"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_LIP_COUNT_DELTA_MAX = "adaptor_FcIfEventStats_lipCountDeltaMax"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_LIP_COUNT_DELTA_MIN = "adaptor_FcIfEventStats_lipCountDeltaMin"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_LOSS_OF_SIGNAL_COUNT = "adaptor_FcIfEventStats_lossOfSignalCount"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_LOSS_OF_SIGNAL_COUNT_DELTA = "adaptor_FcIfEventStats_lossOfSignalCountDelta"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_LOSS_OF_SIGNAL_COUNT_DELTA_AVG = "adaptor_FcIfEventStats_lossOfSignalCountDeltaAvg"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_LOSS_OF_SIGNAL_COUNT_DELTA_MAX = "adaptor_FcIfEventStats_lossOfSignalCountDeltaMax"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_LOSS_OF_SIGNAL_COUNT_DELTA_MIN = "adaptor_FcIfEventStats_lossOfSignalCountDeltaMin"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_LOSS_OF_SYNC_COUNT = "adaptor_FcIfEventStats_lossOfSyncCount"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_LOSS_OF_SYNC_COUNT_DELTA = "adaptor_FcIfEventStats_lossOfSyncCountDelta"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_LOSS_OF_SYNC_COUNT_DELTA_AVG = "adaptor_FcIfEventStats_lossOfSyncCountDeltaAvg"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_LOSS_OF_SYNC_COUNT_DELTA_MAX = "adaptor_FcIfEventStats_lossOfSyncCountDeltaMax"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_LOSS_OF_SYNC_COUNT_DELTA_MIN = "adaptor_FcIfEventStats_lossOfSyncCountDeltaMin"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_N_OSCOUNT = "adaptor_FcIfEventStats_nOSCount"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_N_OSCOUNT_DELTA = "adaptor_FcIfEventStats_nOSCountDelta"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_N_OSCOUNT_DELTA_AVG = "adaptor_FcIfEventStats_nOSCountDeltaAvg"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_N_OSCOUNT_DELTA_MAX = "adaptor_FcIfEventStats_nOSCountDeltaMax"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_N_OSCOUNT_DELTA_MIN = "adaptor_FcIfEventStats_nOSCountDeltaMin"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_SECONDS_SINCE_LAST_RESET = "adaptor_FcIfEventStats_secondsSinceLastReset"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_SECONDS_SINCE_LAST_RESET_DELTA = "adaptor_FcIfEventStats_secondsSinceLastResetDelta"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_SECONDS_SINCE_LAST_RESET_DELTA_AVG = "adaptor_FcIfEventStats_secondsSinceLastResetDeltaAvg"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_SECONDS_SINCE_LAST_RESET_DELTA_MAX = "adaptor_FcIfEventStats_secondsSinceLastResetDeltaMax"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_SECONDS_SINCE_LAST_RESET_DELTA_MIN = "adaptor_FcIfEventStats_secondsSinceLastResetDeltaMin"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_SEQ_PROTOCOL_ERR_COUNT = "adaptor_FcIfEventStats_seqProtocolErrCount"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_SEQ_PROTOCOL_ERR_COUNT_DELTA = "adaptor_FcIfEventStats_seqProtocolErrCountDelta"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_SEQ_PROTOCOL_ERR_COUNT_DELTA_AVG = "adaptor_FcIfEventStats_seqProtocolErrCountDeltaAvg"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_SEQ_PROTOCOL_ERR_COUNT_DELTA_MAX = "adaptor_FcIfEventStats_seqProtocolErrCountDeltaMax"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_SEQ_PROTOCOL_ERR_COUNT_DELTA_MIN = "adaptor_FcIfEventStats_seqProtocolErrCountDeltaMin"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_SUSPECT = "adaptor_FcIfEventStats_suspect"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_THRESHOLDED = "adaptor_FcIfEventStats_thresholded"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_TIME_COLLECTED = "adaptor_FcIfEventStats_timeCollected"
	CONST_PROP_ID_ADAPTOR_FC_IF_EVENT_STATS_UPDATE = "adaptor_FcIfEventStats_update"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATS_HIST_CONTROL_REQUESTS = "adaptor_FcIfFC4StatsHist_controlRequests"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATS_HIST_CONTROL_REQUESTS_DELTA = "adaptor_FcIfFC4StatsHist_controlRequestsDelta"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATS_HIST_CONTROL_REQUESTS_DELTA_AVG = "adaptor_FcIfFC4StatsHist_controlRequestsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATS_HIST_CONTROL_REQUESTS_DELTA_MAX = "adaptor_FcIfFC4StatsHist_controlRequestsDeltaMax"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATS_HIST_CONTROL_REQUESTS_DELTA_MIN = "adaptor_FcIfFC4StatsHist_controlRequestsDeltaMin"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATS_HIST_ID = "adaptor_FcIfFC4StatsHist_id"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATS_HIST_INPUT_MEGABYTES = "adaptor_FcIfFC4StatsHist_inputMegabytes"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATS_HIST_INPUT_MEGABYTES_DELTA = "adaptor_FcIfFC4StatsHist_inputMegabytesDelta"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATS_HIST_INPUT_MEGABYTES_DELTA_AVG = "adaptor_FcIfFC4StatsHist_inputMegabytesDeltaAvg"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATS_HIST_INPUT_MEGABYTES_DELTA_MAX = "adaptor_FcIfFC4StatsHist_inputMegabytesDeltaMax"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATS_HIST_INPUT_MEGABYTES_DELTA_MIN = "adaptor_FcIfFC4StatsHist_inputMegabytesDeltaMin"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATS_HIST_INPUT_REQUESTS = "adaptor_FcIfFC4StatsHist_inputRequests"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATS_HIST_INPUT_REQUESTS_DELTA = "adaptor_FcIfFC4StatsHist_inputRequestsDelta"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATS_HIST_INPUT_REQUESTS_DELTA_AVG = "adaptor_FcIfFC4StatsHist_inputRequestsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATS_HIST_INPUT_REQUESTS_DELTA_MAX = "adaptor_FcIfFC4StatsHist_inputRequestsDeltaMax"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATS_HIST_INPUT_REQUESTS_DELTA_MIN = "adaptor_FcIfFC4StatsHist_inputRequestsDeltaMin"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATS_HIST_MOST_RECENT = "adaptor_FcIfFC4StatsHist_mostRecent"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATS_HIST_OUTPUT_MEGABYTES = "adaptor_FcIfFC4StatsHist_outputMegabytes"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATS_HIST_OUTPUT_MEGABYTES_DELTA = "adaptor_FcIfFC4StatsHist_outputMegabytesDelta"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATS_HIST_OUTPUT_MEGABYTES_DELTA_AVG = "adaptor_FcIfFC4StatsHist_outputMegabytesDeltaAvg"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATS_HIST_OUTPUT_MEGABYTES_DELTA_MAX = "adaptor_FcIfFC4StatsHist_outputMegabytesDeltaMax"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATS_HIST_OUTPUT_MEGABYTES_DELTA_MIN = "adaptor_FcIfFC4StatsHist_outputMegabytesDeltaMin"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATS_HIST_OUTPUT_REQUESTS = "adaptor_FcIfFC4StatsHist_outputRequests"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATS_HIST_OUTPUT_REQUESTS_DELTA = "adaptor_FcIfFC4StatsHist_outputRequestsDelta"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATS_HIST_OUTPUT_REQUESTS_DELTA_AVG = "adaptor_FcIfFC4StatsHist_outputRequestsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATS_HIST_OUTPUT_REQUESTS_DELTA_MAX = "adaptor_FcIfFC4StatsHist_outputRequestsDeltaMax"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATS_HIST_OUTPUT_REQUESTS_DELTA_MIN = "adaptor_FcIfFC4StatsHist_outputRequestsDeltaMin"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATS_HIST_SUSPECT = "adaptor_FcIfFC4StatsHist_suspect"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATS_HIST_THRESHOLDED = "adaptor_FcIfFC4StatsHist_thresholded"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATS_HIST_TIME_COLLECTED = "adaptor_FcIfFC4StatsHist_timeCollected"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATS_CONTROL_REQUESTS = "adaptor_FcIfFC4Stats_controlRequests"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATS_CONTROL_REQUESTS_DELTA = "adaptor_FcIfFC4Stats_controlRequestsDelta"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATS_CONTROL_REQUESTS_DELTA_AVG = "adaptor_FcIfFC4Stats_controlRequestsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATS_CONTROL_REQUESTS_DELTA_MAX = "adaptor_FcIfFC4Stats_controlRequestsDeltaMax"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATS_CONTROL_REQUESTS_DELTA_MIN = "adaptor_FcIfFC4Stats_controlRequestsDeltaMin"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATS_INPUT_MEGABYTES = "adaptor_FcIfFC4Stats_inputMegabytes"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATS_INPUT_MEGABYTES_DELTA = "adaptor_FcIfFC4Stats_inputMegabytesDelta"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATS_INPUT_MEGABYTES_DELTA_AVG = "adaptor_FcIfFC4Stats_inputMegabytesDeltaAvg"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATS_INPUT_MEGABYTES_DELTA_MAX = "adaptor_FcIfFC4Stats_inputMegabytesDeltaMax"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATS_INPUT_MEGABYTES_DELTA_MIN = "adaptor_FcIfFC4Stats_inputMegabytesDeltaMin"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATS_INPUT_REQUESTS = "adaptor_FcIfFC4Stats_inputRequests"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATS_INPUT_REQUESTS_DELTA = "adaptor_FcIfFC4Stats_inputRequestsDelta"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATS_INPUT_REQUESTS_DELTA_AVG = "adaptor_FcIfFC4Stats_inputRequestsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATS_INPUT_REQUESTS_DELTA_MAX = "adaptor_FcIfFC4Stats_inputRequestsDeltaMax"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATS_INPUT_REQUESTS_DELTA_MIN = "adaptor_FcIfFC4Stats_inputRequestsDeltaMin"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATS_INTERVALS = "adaptor_FcIfFC4Stats_intervals"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATS_OUTPUT_MEGABYTES = "adaptor_FcIfFC4Stats_outputMegabytes"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATS_OUTPUT_MEGABYTES_DELTA = "adaptor_FcIfFC4Stats_outputMegabytesDelta"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATS_OUTPUT_MEGABYTES_DELTA_AVG = "adaptor_FcIfFC4Stats_outputMegabytesDeltaAvg"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATS_OUTPUT_MEGABYTES_DELTA_MAX = "adaptor_FcIfFC4Stats_outputMegabytesDeltaMax"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATS_OUTPUT_MEGABYTES_DELTA_MIN = "adaptor_FcIfFC4Stats_outputMegabytesDeltaMin"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATS_OUTPUT_REQUESTS = "adaptor_FcIfFC4Stats_outputRequests"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATS_OUTPUT_REQUESTS_DELTA = "adaptor_FcIfFC4Stats_outputRequestsDelta"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATS_OUTPUT_REQUESTS_DELTA_AVG = "adaptor_FcIfFC4Stats_outputRequestsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATS_OUTPUT_REQUESTS_DELTA_MAX = "adaptor_FcIfFC4Stats_outputRequestsDeltaMax"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATS_OUTPUT_REQUESTS_DELTA_MIN = "adaptor_FcIfFC4Stats_outputRequestsDeltaMin"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATS_SUSPECT = "adaptor_FcIfFC4Stats_suspect"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATS_THRESHOLDED = "adaptor_FcIfFC4Stats_thresholded"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATS_TIME_COLLECTED = "adaptor_FcIfFC4Stats_timeCollected"
	CONST_PROP_ID_ADAPTOR_FC_IF_FC4_STATS_UPDATE = "adaptor_FcIfFC4Stats_update"
	CONST_PROP_ID_ADAPTOR_FC_IF_FRAME_STATS_HIST_DUMPED_FRAMES = "adaptor_FcIfFrameStatsHist_dumpedFrames"
	CONST_PROP_ID_ADAPTOR_FC_IF_FRAME_STATS_HIST_DUMPED_FRAMES_DELTA = "adaptor_FcIfFrameStatsHist_dumpedFramesDelta"
	CONST_PROP_ID_ADAPTOR_FC_IF_FRAME_STATS_HIST_DUMPED_FRAMES_DELTA_AVG = "adaptor_FcIfFrameStatsHist_dumpedFramesDeltaAvg"
	CONST_PROP_ID_ADAPTOR_FC_IF_FRAME_STATS_HIST_DUMPED_FRAMES_DELTA_MAX = "adaptor_FcIfFrameStatsHist_dumpedFramesDeltaMax"
	CONST_PROP_ID_ADAPTOR_FC_IF_FRAME_STATS_HIST_DUMPED_FRAMES_DELTA_MIN = "adaptor_FcIfFrameStatsHist_dumpedFramesDeltaMin"
	CONST_PROP_ID_ADAPTOR_FC_IF_FRAME_STATS_HIST_ERROR_FRAMES = "adaptor_FcIfFrameStatsHist_errorFrames"
	CONST_PROP_ID_ADAPTOR_FC_IF_FRAME_STATS_HIST_ERROR_FRAMES_DELTA = "adaptor_FcIfFrameStatsHist_errorFramesDelta"
	CONST_PROP_ID_ADAPTOR_FC_IF_FRAME_STATS_HIST_ERROR_FRAMES_DELTA_AVG = "adaptor_FcIfFrameStatsHist_errorFramesDeltaAvg"
	CONST_PROP_ID_ADAPTOR_FC_IF_FRAME_STATS_HIST_ERROR_FRAMES_DELTA_MAX = "adaptor_FcIfFrameStatsHist_errorFramesDeltaMax"
	CONST_PROP_ID_ADAPTOR_FC_IF_FRAME_STATS_HIST_ERROR_FRAMES_DELTA_MIN = "adaptor_FcIfFrameStatsHist_errorFramesDeltaMin"
	CONST_PROP_ID_ADAPTOR_FC_IF_FRAME_STATS_HIST_ID = "adaptor_FcIfFrameStatsHist_id"
	CONST_PROP_ID_ADAPTOR_FC_IF_FRAME_STATS_HIST_MOST_RECENT = "adaptor_FcIfFrameStatsHist_mostRecent"
	CONST_PROP_ID_ADAPTOR_FC_IF_FRAME_STATS_HIST_RX_FRAMES = "adaptor_FcIfFrameStatsHist_rxFrames"
	CONST_PROP_ID_ADAPTOR_FC_IF_FRAME_STATS_HIST_RX_FRAMES_DELTA = "adaptor_FcIfFrameStatsHist_rxFramesDelta"
	CONST_PROP_ID_ADAPTOR_FC_IF_FRAME_STATS_HIST_RX_FRAMES_DELTA_AVG = "adaptor_FcIfFrameStatsHist_rxFramesDeltaAvg"
	CONST_PROP_ID_ADAPTOR_FC_IF_FRAME_STATS_HIST_RX_FRAMES_DELTA_MAX = "adaptor_FcIfFrameStatsHist_rxFramesDeltaMax"
	CONST_PROP_ID_ADAPTOR_FC_IF_FRAME_STATS_HIST_RX_FRAMES_DELTA_MIN = "adaptor_FcIfFrameStatsHist_rxFramesDeltaMin"
	CONST_PROP_ID_ADAPTOR_FC_IF_FRAME_STATS_HIST_SUSPECT = "adaptor_FcIfFrameStatsHist_suspect"
	CONST_PROP_ID_ADAPTOR_FC_IF_FRAME_STATS_HIST_THRESHOLDED = "adaptor_FcIfFrameStatsHist_thresholded"
	CONST_PROP_ID_ADAPTOR_FC_IF_FRAME_STATS_HIST_TIME_COLLECTED = "adaptor_FcIfFrameStatsHist_timeCollected"
	CONST_PROP_ID_ADAPTOR_FC_IF_FRAME_STATS_HIST_TX_FRAMES = "adaptor_FcIfFrameStatsHist_txFrames"
	CONST_PROP_ID_ADAPTOR_FC_IF_FRAME_STATS_HIST_TX_FRAMES_DELTA = "adaptor_FcIfFrameStatsHist_txFramesDelta"
	CONST_PROP_ID_ADAPTOR_FC_IF_FRAME_STATS_HIST_TX_FRAMES_DELTA_AVG = "adaptor_FcIfFrameStatsHist_txFramesDeltaAvg"
	CONST_PROP_ID_ADAPTOR_FC_IF_FRAME_STATS_HIST_TX_FRAMES_DELTA_MAX = "adaptor_FcIfFrameStatsHist_txFramesDeltaMax"
	CONST_PROP_ID_ADAPTOR_FC_IF_FRAME_STATS_HIST_TX_FRAMES_DELTA_MIN = "adaptor_FcIfFrameStatsHist_txFramesDeltaMin"
	CONST_PROP_ID_ADAPTOR_FC_IF_FRAME_STATS_DUMPED_FRAMES = "adaptor_FcIfFrameStats_dumpedFrames"
	CONST_PROP_ID_ADAPTOR_FC_IF_FRAME_STATS_DUMPED_FRAMES_DELTA = "adaptor_FcIfFrameStats_dumpedFramesDelta"
	CONST_PROP_ID_ADAPTOR_FC_IF_FRAME_STATS_DUMPED_FRAMES_DELTA_AVG = "adaptor_FcIfFrameStats_dumpedFramesDeltaAvg"
	CONST_PROP_ID_ADAPTOR_FC_IF_FRAME_STATS_DUMPED_FRAMES_DELTA_MAX = "adaptor_FcIfFrameStats_dumpedFramesDeltaMax"
	CONST_PROP_ID_ADAPTOR_FC_IF_FRAME_STATS_DUMPED_FRAMES_DELTA_MIN = "adaptor_FcIfFrameStats_dumpedFramesDeltaMin"
	CONST_PROP_ID_ADAPTOR_FC_IF_FRAME_STATS_ERROR_FRAMES = "adaptor_FcIfFrameStats_errorFrames"
	CONST_PROP_ID_ADAPTOR_FC_IF_FRAME_STATS_ERROR_FRAMES_DELTA = "adaptor_FcIfFrameStats_errorFramesDelta"
	CONST_PROP_ID_ADAPTOR_FC_IF_FRAME_STATS_ERROR_FRAMES_DELTA_AVG = "adaptor_FcIfFrameStats_errorFramesDeltaAvg"
	CONST_PROP_ID_ADAPTOR_FC_IF_FRAME_STATS_ERROR_FRAMES_DELTA_MAX = "adaptor_FcIfFrameStats_errorFramesDeltaMax"
	CONST_PROP_ID_ADAPTOR_FC_IF_FRAME_STATS_ERROR_FRAMES_DELTA_MIN = "adaptor_FcIfFrameStats_errorFramesDeltaMin"
	CONST_PROP_ID_ADAPTOR_FC_IF_FRAME_STATS_INTERVALS = "adaptor_FcIfFrameStats_intervals"
	CONST_PROP_ID_ADAPTOR_FC_IF_FRAME_STATS_RX_FRAMES = "adaptor_FcIfFrameStats_rxFrames"
	CONST_PROP_ID_ADAPTOR_FC_IF_FRAME_STATS_RX_FRAMES_DELTA = "adaptor_FcIfFrameStats_rxFramesDelta"
	CONST_PROP_ID_ADAPTOR_FC_IF_FRAME_STATS_RX_FRAMES_DELTA_AVG = "adaptor_FcIfFrameStats_rxFramesDeltaAvg"
	CONST_PROP_ID_ADAPTOR_FC_IF_FRAME_STATS_RX_FRAMES_DELTA_MAX = "adaptor_FcIfFrameStats_rxFramesDeltaMax"
	CONST_PROP_ID_ADAPTOR_FC_IF_FRAME_STATS_RX_FRAMES_DELTA_MIN = "adaptor_FcIfFrameStats_rxFramesDeltaMin"
	CONST_PROP_ID_ADAPTOR_FC_IF_FRAME_STATS_SUSPECT = "adaptor_FcIfFrameStats_suspect"
	CONST_PROP_ID_ADAPTOR_FC_IF_FRAME_STATS_THRESHOLDED = "adaptor_FcIfFrameStats_thresholded"
	CONST_PROP_ID_ADAPTOR_FC_IF_FRAME_STATS_TIME_COLLECTED = "adaptor_FcIfFrameStats_timeCollected"
	CONST_PROP_ID_ADAPTOR_FC_IF_FRAME_STATS_TX_FRAMES = "adaptor_FcIfFrameStats_txFrames"
	CONST_PROP_ID_ADAPTOR_FC_IF_FRAME_STATS_TX_FRAMES_DELTA = "adaptor_FcIfFrameStats_txFramesDelta"
	CONST_PROP_ID_ADAPTOR_FC_IF_FRAME_STATS_TX_FRAMES_DELTA_AVG = "adaptor_FcIfFrameStats_txFramesDeltaAvg"
	CONST_PROP_ID_ADAPTOR_FC_IF_FRAME_STATS_TX_FRAMES_DELTA_MAX = "adaptor_FcIfFrameStats_txFramesDeltaMax"
	CONST_PROP_ID_ADAPTOR_FC_IF_FRAME_STATS_TX_FRAMES_DELTA_MIN = "adaptor_FcIfFrameStats_txFramesDeltaMin"
	CONST_PROP_ID_ADAPTOR_FC_IF_FRAME_STATS_UPDATE = "adaptor_FcIfFrameStats_update"
	CONST_PROP_ID_ADAPTOR_FC_INTERRUPT_PROFILE_MODE = "adaptor_FcInterruptProfile_mode"
	CONST_PROP_ID_ADAPTOR_FC_LOGI_PROFILE_RETRIES = "adaptor_FcLogiProfile_retries"
	CONST_PROP_ID_ADAPTOR_FC_LOGI_PROFILE_TIMEOUT = "adaptor_FcLogiProfile_timeout"
	CONST_PROP_ID_ADAPTOR_FC_OEIF_EP_DN = "adaptor_FcOEIf_epDn"
	CONST_PROP_ID_ADAPTOR_FC_OEIF_FCOE_VLAN = "adaptor_FcOEIf_fcoeVlan"
	CONST_PROP_ID_ADAPTOR_FC_OEIF_ID = "adaptor_FcOEIf_id"
	CONST_PROP_ID_ADAPTOR_FC_OEIF_IF_ROLE = "adaptor_FcOEIf_ifRole"
	CONST_PROP_ID_ADAPTOR_FC_OEIF_IF_TYPE = "adaptor_FcOEIf_ifType"
	CONST_PROP_ID_ADAPTOR_FC_OEIF_LC = "adaptor_FcOEIf_lc"
	CONST_PROP_ID_ADAPTOR_FC_OEIF_LOCALE = "adaptor_FcOEIf_locale"
	CONST_PROP_ID_ADAPTOR_FC_OEIF_MAC = "adaptor_FcOEIf_mac"
	CONST_PROP_ID_ADAPTOR_FC_OEIF_NAME = "adaptor_FcOEIf_name"
	CONST_PROP_ID_ADAPTOR_FC_OEIF_OPER_STATE = "adaptor_FcOEIf_operState"
	CONST_PROP_ID_ADAPTOR_FC_OEIF_PEER_DN = "adaptor_FcOEIf_peerDn"
	CONST_PROP_ID_ADAPTOR_FC_OEIF_POLICY_OWNER = "adaptor_FcOEIf_policyOwner"
	CONST_PROP_ID_ADAPTOR_FC_OEIF_SWITCH_ID = "adaptor_FcOEIf_switchId"
	CONST_PROP_ID_ADAPTOR_FC_OEIF_TRANSPORT = "adaptor_FcOEIf_transport"
	CONST_PROP_ID_ADAPTOR_FC_OEIF_TYPE = "adaptor_FcOEIf_type"
	CONST_PROP_ID_ADAPTOR_FC_OEIF_ZONING_STATE = "adaptor_FcOEIf_zoningState"
	CONST_PROP_ID_ADAPTOR_FC_PORT_FLOGI_PROFILE_RETRIES = "adaptor_FcPortFLogiProfile_retries"
	CONST_PROP_ID_ADAPTOR_FC_PORT_FLOGI_PROFILE_TIMEOUT = "adaptor_FcPortFLogiProfile_timeout"
	CONST_PROP_ID_ADAPTOR_FC_PORT_PLOGI_PROFILE_RETRIES = "adaptor_FcPortPLogiProfile_retries"
	CONST_PROP_ID_ADAPTOR_FC_PORT_PLOGI_PROFILE_TIMEOUT = "adaptor_FcPortPLogiProfile_timeout"
	CONST_PROP_ID_ADAPTOR_FC_PORT_PROFILE_IO_THROTTLE_COUNT = "adaptor_FcPortProfile_ioThrottleCount"
	CONST_PROP_ID_ADAPTOR_FC_PORT_PROFILE_LUNS_PER_TARGET = "adaptor_FcPortProfile_lunsPerTarget"
	CONST_PROP_ID_ADAPTOR_FC_PORT_STATS_HIST_ID = "adaptor_FcPortStatsHist_id"
	CONST_PROP_ID_ADAPTOR_FC_PORT_STATS_HIST_MOST_RECENT = "adaptor_FcPortStatsHist_mostRecent"
	CONST_PROP_ID_ADAPTOR_FC_PORT_STATS_HIST_RX_BAD_FRAMES = "adaptor_FcPortStatsHist_rxBadFrames"
	CONST_PROP_ID_ADAPTOR_FC_PORT_STATS_HIST_RX_BAD_FRAMES_DELTA = "adaptor_FcPortStatsHist_rxBadFramesDelta"
	CONST_PROP_ID_ADAPTOR_FC_PORT_STATS_HIST_RX_BAD_FRAMES_DELTA_AVG = "adaptor_FcPortStatsHist_rxBadFramesDeltaAvg"
	CONST_PROP_ID_ADAPTOR_FC_PORT_STATS_HIST_RX_BAD_FRAMES_DELTA_MAX = "adaptor_FcPortStatsHist_rxBadFramesDeltaMax"
	CONST_PROP_ID_ADAPTOR_FC_PORT_STATS_HIST_RX_BAD_FRAMES_DELTA_MIN = "adaptor_FcPortStatsHist_rxBadFramesDeltaMin"
	CONST_PROP_ID_ADAPTOR_FC_PORT_STATS_HIST_RX_FRAMES = "adaptor_FcPortStatsHist_rxFrames"
	CONST_PROP_ID_ADAPTOR_FC_PORT_STATS_HIST_RX_FRAMES_DELTA = "adaptor_FcPortStatsHist_rxFramesDelta"
	CONST_PROP_ID_ADAPTOR_FC_PORT_STATS_HIST_RX_FRAMES_DELTA_AVG = "adaptor_FcPortStatsHist_rxFramesDeltaAvg"
	CONST_PROP_ID_ADAPTOR_FC_PORT_STATS_HIST_RX_FRAMES_DELTA_MAX = "adaptor_FcPortStatsHist_rxFramesDeltaMax"
	CONST_PROP_ID_ADAPTOR_FC_PORT_STATS_HIST_RX_FRAMES_DELTA_MIN = "adaptor_FcPortStatsHist_rxFramesDeltaMin"
	CONST_PROP_ID_ADAPTOR_FC_PORT_STATS_HIST_SUSPECT = "adaptor_FcPortStatsHist_suspect"
	CONST_PROP_ID_ADAPTOR_FC_PORT_STATS_HIST_THRESHOLDED = "adaptor_FcPortStatsHist_thresholded"
	CONST_PROP_ID_ADAPTOR_FC_PORT_STATS_HIST_TIME_COLLECTED = "adaptor_FcPortStatsHist_timeCollected"
	CONST_PROP_ID_ADAPTOR_FC_PORT_STATS_HIST_TX_BAD_FRAMES = "adaptor_FcPortStatsHist_txBadFrames"
	CONST_PROP_ID_ADAPTOR_FC_PORT_STATS_HIST_TX_BAD_FRAMES_DELTA = "adaptor_FcPortStatsHist_txBadFramesDelta"
	CONST_PROP_ID_ADAPTOR_FC_PORT_STATS_HIST_TX_BAD_FRAMES_DELTA_AVG = "adaptor_FcPortStatsHist_txBadFramesDeltaAvg"
	CONST_PROP_ID_ADAPTOR_FC_PORT_STATS_HIST_TX_BAD_FRAMES_DELTA_MAX = "adaptor_FcPortStatsHist_txBadFramesDeltaMax"
	CONST_PROP_ID_ADAPTOR_FC_PORT_STATS_HIST_TX_BAD_FRAMES_DELTA_MIN = "adaptor_FcPortStatsHist_txBadFramesDeltaMin"
	CONST_PROP_ID_ADAPTOR_FC_PORT_STATS_HIST_TX_FRAMES = "adaptor_FcPortStatsHist_txFrames"
	CONST_PROP_ID_ADAPTOR_FC_PORT_STATS_HIST_TX_FRAMES_DELTA = "adaptor_FcPortStatsHist_txFramesDelta"
	CONST_PROP_ID_ADAPTOR_FC_PORT_STATS_HIST_TX_FRAMES_DELTA_AVG = "adaptor_FcPortStatsHist_txFramesDeltaAvg"
	CONST_PROP_ID_ADAPTOR_FC_PORT_STATS_HIST_TX_FRAMES_DELTA_MAX = "adaptor_FcPortStatsHist_txFramesDeltaMax"
	CONST_PROP_ID_ADAPTOR_FC_PORT_STATS_HIST_TX_FRAMES_DELTA_MIN = "adaptor_FcPortStatsHist_txFramesDeltaMin"
	CONST_PROP_ID_ADAPTOR_FC_PORT_STATS_INTERVALS = "adaptor_FcPortStats_intervals"
	CONST_PROP_ID_ADAPTOR_FC_PORT_STATS_RX_BAD_FRAMES = "adaptor_FcPortStats_rxBadFrames"
	CONST_PROP_ID_ADAPTOR_FC_PORT_STATS_RX_BAD_FRAMES_DELTA = "adaptor_FcPortStats_rxBadFramesDelta"
	CONST_PROP_ID_ADAPTOR_FC_PORT_STATS_RX_BAD_FRAMES_DELTA_AVG = "adaptor_FcPortStats_rxBadFramesDeltaAvg"
	CONST_PROP_ID_ADAPTOR_FC_PORT_STATS_RX_BAD_FRAMES_DELTA_MAX = "adaptor_FcPortStats_rxBadFramesDeltaMax"
	CONST_PROP_ID_ADAPTOR_FC_PORT_STATS_RX_BAD_FRAMES_DELTA_MIN = "adaptor_FcPortStats_rxBadFramesDeltaMin"
	CONST_PROP_ID_ADAPTOR_FC_PORT_STATS_RX_FRAMES = "adaptor_FcPortStats_rxFrames"
	CONST_PROP_ID_ADAPTOR_FC_PORT_STATS_RX_FRAMES_DELTA = "adaptor_FcPortStats_rxFramesDelta"
	CONST_PROP_ID_ADAPTOR_FC_PORT_STATS_RX_FRAMES_DELTA_AVG = "adaptor_FcPortStats_rxFramesDeltaAvg"
	CONST_PROP_ID_ADAPTOR_FC_PORT_STATS_RX_FRAMES_DELTA_MAX = "adaptor_FcPortStats_rxFramesDeltaMax"
	CONST_PROP_ID_ADAPTOR_FC_PORT_STATS_RX_FRAMES_DELTA_MIN = "adaptor_FcPortStats_rxFramesDeltaMin"
	CONST_PROP_ID_ADAPTOR_FC_PORT_STATS_SUSPECT = "adaptor_FcPortStats_suspect"
	CONST_PROP_ID_ADAPTOR_FC_PORT_STATS_THRESHOLDED = "adaptor_FcPortStats_thresholded"
	CONST_PROP_ID_ADAPTOR_FC_PORT_STATS_TIME_COLLECTED = "adaptor_FcPortStats_timeCollected"
	CONST_PROP_ID_ADAPTOR_FC_PORT_STATS_TX_BAD_FRAMES = "adaptor_FcPortStats_txBadFrames"
	CONST_PROP_ID_ADAPTOR_FC_PORT_STATS_TX_BAD_FRAMES_DELTA = "adaptor_FcPortStats_txBadFramesDelta"
	CONST_PROP_ID_ADAPTOR_FC_PORT_STATS_TX_BAD_FRAMES_DELTA_AVG = "adaptor_FcPortStats_txBadFramesDeltaAvg"
	CONST_PROP_ID_ADAPTOR_FC_PORT_STATS_TX_BAD_FRAMES_DELTA_MAX = "adaptor_FcPortStats_txBadFramesDeltaMax"
	CONST_PROP_ID_ADAPTOR_FC_PORT_STATS_TX_BAD_FRAMES_DELTA_MIN = "adaptor_FcPortStats_txBadFramesDeltaMin"
	CONST_PROP_ID_ADAPTOR_FC_PORT_STATS_TX_FRAMES = "adaptor_FcPortStats_txFrames"
	CONST_PROP_ID_ADAPTOR_FC_PORT_STATS_TX_FRAMES_DELTA = "adaptor_FcPortStats_txFramesDelta"
	CONST_PROP_ID_ADAPTOR_FC_PORT_STATS_TX_FRAMES_DELTA_AVG = "adaptor_FcPortStats_txFramesDeltaAvg"
	CONST_PROP_ID_ADAPTOR_FC_PORT_STATS_TX_FRAMES_DELTA_MAX = "adaptor_FcPortStats_txFramesDeltaMax"
	CONST_PROP_ID_ADAPTOR_FC_PORT_STATS_TX_FRAMES_DELTA_MIN = "adaptor_FcPortStats_txFramesDeltaMin"
	CONST_PROP_ID_ADAPTOR_FC_PORT_STATS_UPDATE = "adaptor_FcPortStats_update"
	CONST_PROP_ID_ADAPTOR_FC_QUEUE_PROFILE_COUNT = "adaptor_FcQueueProfile_count"
	CONST_PROP_ID_ADAPTOR_FC_QUEUE_PROFILE_RING_SIZE = "adaptor_FcQueueProfile_ringSize"
	CONST_PROP_ID_ADAPTOR_FC_RECV_QUEUE_PROFILE_COUNT = "adaptor_FcRecvQueueProfile_count"
	CONST_PROP_ID_ADAPTOR_FC_RECV_QUEUE_PROFILE_RING_SIZE = "adaptor_FcRecvQueueProfile_ringSize"
	CONST_PROP_ID_ADAPTOR_FC_WORK_QUEUE_PROFILE_COUNT = "adaptor_FcWorkQueueProfile_count"
	CONST_PROP_ID_ADAPTOR_FC_WORK_QUEUE_PROFILE_RING_SIZE = "adaptor_FcWorkQueueProfile_ringSize"
	CONST_PROP_ID_ADAPTOR_FRU_CAP_PROVIDER_DELETED = "adaptor_FruCapProvider_deleted"
	CONST_PROP_ID_ADAPTOR_FRU_CAP_PROVIDER_DEPRECATED = "adaptor_FruCapProvider_deprecated"
	CONST_PROP_ID_ADAPTOR_FRU_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "adaptor_FruCapProvider_elementLoadFailures"
	CONST_PROP_ID_ADAPTOR_FRU_CAP_PROVIDER_ELEMENTS_LOADED = "adaptor_FruCapProvider_elementsLoaded"
	CONST_PROP_ID_ADAPTOR_FRU_CAP_PROVIDER_GENCOUNT = "adaptor_FruCapProvider_gencount"
	CONST_PROP_ID_ADAPTOR_FRU_CAP_PROVIDER_LOAD_ERRORS = "adaptor_FruCapProvider_loadErrors"
	CONST_PROP_ID_ADAPTOR_FRU_CAP_PROVIDER_LOAD_WARNINGS = "adaptor_FruCapProvider_loadWarnings"
	CONST_PROP_ID_ADAPTOR_FRU_CAP_PROVIDER_MGMT_PLANE_VER = "adaptor_FruCapProvider_mgmtPlaneVer"
	CONST_PROP_ID_ADAPTOR_FRU_CAP_PROVIDER_MODEL = "adaptor_FruCapProvider_model"
	CONST_PROP_ID_ADAPTOR_FRU_CAP_PROVIDER_PROM_CARD_TYPE = "adaptor_FruCapProvider_promCardType"
	CONST_PROP_ID_ADAPTOR_FRU_CAP_PROVIDER_REVISION = "adaptor_FruCapProvider_revision"
	CONST_PROP_ID_ADAPTOR_FRU_CAP_PROVIDER_VENDOR = "adaptor_FruCapProvider_vendor"
	CONST_PROP_ID_ADAPTOR_FRU_CAP_REF_IS_SUPPORTED = "adaptor_FruCapRef_isSupported"
	CONST_PROP_ID_ADAPTOR_FRU_CAP_REF_MODEL = "adaptor_FruCapRef_model"
	CONST_PROP_ID_ADAPTOR_FRU_CAP_REF_REVISION = "adaptor_FruCapRef_revision"
	CONST_PROP_ID_ADAPTOR_FRU_CAP_REF_VENDOR = "adaptor_FruCapRef_vendor"
	CONST_PROP_ID_ADAPTOR_FW_CAP_PROVIDER_DELETED = "adaptor_FwCapProvider_deleted"
	CONST_PROP_ID_ADAPTOR_FW_CAP_PROVIDER_DEPRECATED = "adaptor_FwCapProvider_deprecated"
	CONST_PROP_ID_ADAPTOR_FW_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "adaptor_FwCapProvider_elementLoadFailures"
	CONST_PROP_ID_ADAPTOR_FW_CAP_PROVIDER_ELEMENTS_LOADED = "adaptor_FwCapProvider_elementsLoaded"
	CONST_PROP_ID_ADAPTOR_FW_CAP_PROVIDER_GENCOUNT = "adaptor_FwCapProvider_gencount"
	CONST_PROP_ID_ADAPTOR_FW_CAP_PROVIDER_LOAD_ERRORS = "adaptor_FwCapProvider_loadErrors"
	CONST_PROP_ID_ADAPTOR_FW_CAP_PROVIDER_LOAD_WARNINGS = "adaptor_FwCapProvider_loadWarnings"
	CONST_PROP_ID_ADAPTOR_FW_CAP_PROVIDER_MGMT_PLANE_VER = "adaptor_FwCapProvider_mgmtPlaneVer"
	CONST_PROP_ID_ADAPTOR_FW_CAP_PROVIDER_MODEL = "adaptor_FwCapProvider_model"
	CONST_PROP_ID_ADAPTOR_FW_CAP_PROVIDER_VENDOR = "adaptor_FwCapProvider_vendor"
	CONST_PROP_ID_ADAPTOR_FW_CAP_PROVIDER_VERSION = "adaptor_FwCapProvider_version"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_FSM_STAGE_DESCR = "adaptor_HostEthIfFsmStage_descr"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_FSM_STAGE_LAST_UPDATE_TIME = "adaptor_HostEthIfFsmStage_lastUpdateTime"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_FSM_STAGE_NAME = "adaptor_HostEthIfFsmStage_name"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_FSM_STAGE_ORDER = "adaptor_HostEthIfFsmStage_order"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_FSM_STAGE_RETRY = "adaptor_HostEthIfFsmStage_retry"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_FSM_STAGE_STAGE_STATUS = "adaptor_HostEthIfFsmStage_stageStatus"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_FSM_TASK_COMPLETION = "adaptor_HostEthIfFsmTask_completion"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_FSM_TASK_FLAGS = "adaptor_HostEthIfFsmTask_flags"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_FSM_TASK_ITEM = "adaptor_HostEthIfFsmTask_item"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_FSM_TASK_SEQ_ID = "adaptor_HostEthIfFsmTask_seqId"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_FSM_COMPLETION_TIME = "adaptor_HostEthIfFsm_completionTime"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_FSM_CURRENT_FSM = "adaptor_HostEthIfFsm_currentFsm"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_FSM_DESCR = "adaptor_HostEthIfFsm_descr"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_FSM_FSM_STATUS = "adaptor_HostEthIfFsm_fsmStatus"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_FSM_INSTANCE_ID = "adaptor_HostEthIfFsm_instanceId"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_FSM_PROGRESS = "adaptor_HostEthIfFsm_progress"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_FSM_RMT_ERR_CODE = "adaptor_HostEthIfFsm_rmtErrCode"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_FSM_RMT_ERR_DESCR = "adaptor_HostEthIfFsm_rmtErrDescr"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_FSM_RMT_RSLT = "adaptor_HostEthIfFsm_rmtRslt"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_PROFILE_DESCR = "adaptor_HostEthIfProfile_descr"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_PROFILE_INT_ID = "adaptor_HostEthIfProfile_intId"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_PROFILE_NAME = "adaptor_HostEthIfProfile_name"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_PROFILE_POLICY_LEVEL = "adaptor_HostEthIfProfile_policyLevel"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_PROFILE_POLICY_OWNER = "adaptor_HostEthIfProfile_policyOwner"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_ADMIN_STATE = "adaptor_HostEthIf_adminState"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_BOOT_DEV = "adaptor_HostEthIf_bootDev"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_CHASSIS_ID = "adaptor_HostEthIf_chassisId"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_DISCOVERY = "adaptor_HostEthIf_discovery"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_EP_DN = "adaptor_HostEthIf_epDn"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_FSM_DESCR = "adaptor_HostEthIf_fsmDescr"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_FSM_PREV = "adaptor_HostEthIf_fsmPrev"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_FSM_PROGR = "adaptor_HostEthIf_fsmProgr"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_FSM_RMT_INV_ERR_CODE = "adaptor_HostEthIf_fsmRmtInvErrCode"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_FSM_RMT_INV_ERR_DESCR = "adaptor_HostEthIf_fsmRmtInvErrDescr"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_FSM_RMT_INV_RSLT = "adaptor_HostEthIf_fsmRmtInvRslt"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_FSM_STAGE_DESCR = "adaptor_HostEthIf_fsmStageDescr"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_FSM_STAMP = "adaptor_HostEthIf_fsmStamp"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_FSM_STATUS = "adaptor_HostEthIf_fsmStatus"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_FSM_TRY = "adaptor_HostEthIf_fsmTry"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_ID = "adaptor_HostEthIf_id"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_IF_ROLE = "adaptor_HostEthIf_ifRole"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_IF_TYPE = "adaptor_HostEthIf_ifType"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_LC = "adaptor_HostEthIf_lc"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_LINK_STATE = "adaptor_HostEthIf_linkState"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_LOCALE = "adaptor_HostEthIf_locale"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_MAC = "adaptor_HostEthIf_mac"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_MODEL = "adaptor_HostEthIf_model"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_MTU = "adaptor_HostEthIf_mtu"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_NAME = "adaptor_HostEthIf_name"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_OPER_QUALIFIER_REASON = "adaptor_HostEthIf_operQualifierReason"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_OPER_STATE = "adaptor_HostEthIf_operState"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_OPERABILITY = "adaptor_HostEthIf_operability"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_ORDER = "adaptor_HostEthIf_order"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_ORIGINAL_MAC = "adaptor_HostEthIf_originalMac"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_PCI_ADDR = "adaptor_HostEthIf_pciAddr"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_PCI_FUNC = "adaptor_HostEthIf_pciFunc"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_PCI_SLOT = "adaptor_HostEthIf_pciSlot"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_PEER_CHASSIS_ID = "adaptor_HostEthIf_peerChassisId"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_PEER_DN = "adaptor_HostEthIf_peerDn"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_PEER_PORT_ID = "adaptor_HostEthIf_peerPortId"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_PEER_SLOT_ID = "adaptor_HostEthIf_peerSlotId"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_PERF = "adaptor_HostEthIf_perf"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_PF_DN = "adaptor_HostEthIf_pfDn"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_PORT_ID = "adaptor_HostEthIf_portId"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_POWER = "adaptor_HostEthIf_power"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_PRESENCE = "adaptor_HostEthIf_presence"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_PURPOSE = "adaptor_HostEthIf_purpose"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_REVISION = "adaptor_HostEthIf_revision"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_SERIAL = "adaptor_HostEthIf_serial"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_SIDE = "adaptor_HostEthIf_side"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_SLOT_ID = "adaptor_HostEthIf_slotId"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_SWITCH_ID = "adaptor_HostEthIf_switchId"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_THERMAL = "adaptor_HostEthIf_thermal"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_TRANSPORT = "adaptor_HostEthIf_transport"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_TYPE = "adaptor_HostEthIf_type"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_VENDOR = "adaptor_HostEthIf_vendor"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_VIRTUALIZATION_PREFERENCE = "adaptor_HostEthIf_virtualizationPreference"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_VNIC_DN = "adaptor_HostEthIf_vnicDn"
	CONST_PROP_ID_ADAPTOR_HOST_ETH_IF_VOLTAGE = "adaptor_HostEthIf_voltage"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_FSM_STAGE_DESCR = "adaptor_HostFcIfFsmStage_descr"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_FSM_STAGE_LAST_UPDATE_TIME = "adaptor_HostFcIfFsmStage_lastUpdateTime"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_FSM_STAGE_NAME = "adaptor_HostFcIfFsmStage_name"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_FSM_STAGE_ORDER = "adaptor_HostFcIfFsmStage_order"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_FSM_STAGE_RETRY = "adaptor_HostFcIfFsmStage_retry"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_FSM_STAGE_STAGE_STATUS = "adaptor_HostFcIfFsmStage_stageStatus"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_FSM_TASK_COMPLETION = "adaptor_HostFcIfFsmTask_completion"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_FSM_TASK_FLAGS = "adaptor_HostFcIfFsmTask_flags"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_FSM_TASK_ITEM = "adaptor_HostFcIfFsmTask_item"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_FSM_TASK_SEQ_ID = "adaptor_HostFcIfFsmTask_seqId"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_FSM_COMPLETION_TIME = "adaptor_HostFcIfFsm_completionTime"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_FSM_CURRENT_FSM = "adaptor_HostFcIfFsm_currentFsm"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_FSM_DESCR = "adaptor_HostFcIfFsm_descr"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_FSM_FSM_STATUS = "adaptor_HostFcIfFsm_fsmStatus"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_FSM_INSTANCE_ID = "adaptor_HostFcIfFsm_instanceId"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_FSM_PROGRESS = "adaptor_HostFcIfFsm_progress"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_FSM_RMT_ERR_CODE = "adaptor_HostFcIfFsm_rmtErrCode"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_FSM_RMT_ERR_DESCR = "adaptor_HostFcIfFsm_rmtErrDescr"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_FSM_RMT_RSLT = "adaptor_HostFcIfFsm_rmtRslt"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_PROFILE_DESCR = "adaptor_HostFcIfProfile_descr"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_PROFILE_INT_ID = "adaptor_HostFcIfProfile_intId"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_PROFILE_NAME = "adaptor_HostFcIfProfile_name"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_PROFILE_POLICY_LEVEL = "adaptor_HostFcIfProfile_policyLevel"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_PROFILE_POLICY_OWNER = "adaptor_HostFcIfProfile_policyOwner"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_ADMIN_STATE = "adaptor_HostFcIf_adminState"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_BOOT_DEV = "adaptor_HostFcIf_bootDev"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_CHASSIS_ID = "adaptor_HostFcIf_chassisId"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_DISCOVERY = "adaptor_HostFcIf_discovery"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_EP_DN = "adaptor_HostFcIf_epDn"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_FSM_DESCR = "adaptor_HostFcIf_fsmDescr"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_FSM_PREV = "adaptor_HostFcIf_fsmPrev"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_FSM_PROGR = "adaptor_HostFcIf_fsmProgr"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_FSM_RMT_INV_ERR_CODE = "adaptor_HostFcIf_fsmRmtInvErrCode"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_FSM_RMT_INV_ERR_DESCR = "adaptor_HostFcIf_fsmRmtInvErrDescr"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_FSM_RMT_INV_RSLT = "adaptor_HostFcIf_fsmRmtInvRslt"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_FSM_STAGE_DESCR = "adaptor_HostFcIf_fsmStageDescr"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_FSM_STAMP = "adaptor_HostFcIf_fsmStamp"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_FSM_STATUS = "adaptor_HostFcIf_fsmStatus"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_FSM_TRY = "adaptor_HostFcIf_fsmTry"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_ID = "adaptor_HostFcIf_id"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_IF_ROLE = "adaptor_HostFcIf_ifRole"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_IF_TYPE = "adaptor_HostFcIf_ifType"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_LC = "adaptor_HostFcIf_lc"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_LINK_STATE = "adaptor_HostFcIf_linkState"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_LOCALE = "adaptor_HostFcIf_locale"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_MAX_DATA_FIELD_SIZE = "adaptor_HostFcIf_maxDataFieldSize"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_MODEL = "adaptor_HostFcIf_model"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_NAME = "adaptor_HostFcIf_name"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_NODE_WWN = "adaptor_HostFcIf_nodeWwn"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_OPER_QUALIFIER_REASON = "adaptor_HostFcIf_operQualifierReason"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_OPER_STATE = "adaptor_HostFcIf_operState"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_OPERABILITY = "adaptor_HostFcIf_operability"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_ORDER = "adaptor_HostFcIf_order"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_ORIGINAL_NODE_WWN = "adaptor_HostFcIf_originalNodeWwn"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_ORIGINAL_WWN = "adaptor_HostFcIf_originalWwn"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_PCI_ADDR = "adaptor_HostFcIf_pciAddr"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_PCI_FUNC = "adaptor_HostFcIf_pciFunc"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_PCI_SLOT = "adaptor_HostFcIf_pciSlot"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_PEER_CHASSIS_ID = "adaptor_HostFcIf_peerChassisId"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_PEER_DN = "adaptor_HostFcIf_peerDn"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_PEER_PORT_ID = "adaptor_HostFcIf_peerPortId"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_PEER_SLOT_ID = "adaptor_HostFcIf_peerSlotId"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_PERF = "adaptor_HostFcIf_perf"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_PERS_BIND = "adaptor_HostFcIf_persBind"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_PORT_ID = "adaptor_HostFcIf_portId"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_POWER = "adaptor_HostFcIf_power"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_PRESENCE = "adaptor_HostFcIf_presence"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_PURPOSE = "adaptor_HostFcIf_purpose"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_REVISION = "adaptor_HostFcIf_revision"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_SERIAL = "adaptor_HostFcIf_serial"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_SIDE = "adaptor_HostFcIf_side"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_SLOT_ID = "adaptor_HostFcIf_slotId"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_SWITCH_ID = "adaptor_HostFcIf_switchId"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_THERMAL = "adaptor_HostFcIf_thermal"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_TRANSPORT = "adaptor_HostFcIf_transport"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_TYPE = "adaptor_HostFcIf_type"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_VENDOR = "adaptor_HostFcIf_vendor"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_VNIC_DN = "adaptor_HostFcIf_vnicDn"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_VOLTAGE = "adaptor_HostFcIf_voltage"
	CONST_PROP_ID_ADAPTOR_HOST_FC_IF_WWN = "adaptor_HostFcIf_wwn"
	CONST_PROP_ID_ADAPTOR_HOST_IF_CONN_DEF_CON_POLICY_NAME = "adaptor_HostIfConnDef_conPolicyName"
	CONST_PROP_ID_ADAPTOR_HOST_IF_PROFILE_DESCR = "adaptor_HostIfProfile_descr"
	CONST_PROP_ID_ADAPTOR_HOST_IF_PROFILE_INT_ID = "adaptor_HostIfProfile_intId"
	CONST_PROP_ID_ADAPTOR_HOST_IF_PROFILE_NAME = "adaptor_HostIfProfile_name"
	CONST_PROP_ID_ADAPTOR_HOST_IF_PROFILE_POLICY_LEVEL = "adaptor_HostIfProfile_policyLevel"
	CONST_PROP_ID_ADAPTOR_HOST_IF_PROFILE_POLICY_OWNER = "adaptor_HostIfProfile_policyOwner"
	CONST_PROP_ID_ADAPTOR_HOST_IF_ADMIN_STATE = "adaptor_HostIf_adminState"
	CONST_PROP_ID_ADAPTOR_HOST_IF_BOOT_DEV = "adaptor_HostIf_bootDev"
	CONST_PROP_ID_ADAPTOR_HOST_IF_CHASSIS_ID = "adaptor_HostIf_chassisId"
	CONST_PROP_ID_ADAPTOR_HOST_IF_DISCOVERY = "adaptor_HostIf_discovery"
	CONST_PROP_ID_ADAPTOR_HOST_IF_EP_DN = "adaptor_HostIf_epDn"
	CONST_PROP_ID_ADAPTOR_HOST_IF_ID = "adaptor_HostIf_id"
	CONST_PROP_ID_ADAPTOR_HOST_IF_IF_ROLE = "adaptor_HostIf_ifRole"
	CONST_PROP_ID_ADAPTOR_HOST_IF_IF_TYPE = "adaptor_HostIf_ifType"
	CONST_PROP_ID_ADAPTOR_HOST_IF_LC = "adaptor_HostIf_lc"
	CONST_PROP_ID_ADAPTOR_HOST_IF_LINK_STATE = "adaptor_HostIf_linkState"
	CONST_PROP_ID_ADAPTOR_HOST_IF_LOCALE = "adaptor_HostIf_locale"
	CONST_PROP_ID_ADAPTOR_HOST_IF_MODEL = "adaptor_HostIf_model"
	CONST_PROP_ID_ADAPTOR_HOST_IF_NAME = "adaptor_HostIf_name"
	CONST_PROP_ID_ADAPTOR_HOST_IF_OPER_QUALIFIER_REASON = "adaptor_HostIf_operQualifierReason"
	CONST_PROP_ID_ADAPTOR_HOST_IF_OPER_STATE = "adaptor_HostIf_operState"
	CONST_PROP_ID_ADAPTOR_HOST_IF_OPERABILITY = "adaptor_HostIf_operability"
	CONST_PROP_ID_ADAPTOR_HOST_IF_ORDER = "adaptor_HostIf_order"
	CONST_PROP_ID_ADAPTOR_HOST_IF_PCI_ADDR = "adaptor_HostIf_pciAddr"
	CONST_PROP_ID_ADAPTOR_HOST_IF_PCI_FUNC = "adaptor_HostIf_pciFunc"
	CONST_PROP_ID_ADAPTOR_HOST_IF_PCI_SLOT = "adaptor_HostIf_pciSlot"
	CONST_PROP_ID_ADAPTOR_HOST_IF_PEER_CHASSIS_ID = "adaptor_HostIf_peerChassisId"
	CONST_PROP_ID_ADAPTOR_HOST_IF_PEER_DN = "adaptor_HostIf_peerDn"
	CONST_PROP_ID_ADAPTOR_HOST_IF_PEER_PORT_ID = "adaptor_HostIf_peerPortId"
	CONST_PROP_ID_ADAPTOR_HOST_IF_PEER_SLOT_ID = "adaptor_HostIf_peerSlotId"
	CONST_PROP_ID_ADAPTOR_HOST_IF_PERF = "adaptor_HostIf_perf"
	CONST_PROP_ID_ADAPTOR_HOST_IF_PORT_ID = "adaptor_HostIf_portId"
	CONST_PROP_ID_ADAPTOR_HOST_IF_POWER = "adaptor_HostIf_power"
	CONST_PROP_ID_ADAPTOR_HOST_IF_PRESENCE = "adaptor_HostIf_presence"
	CONST_PROP_ID_ADAPTOR_HOST_IF_PURPOSE = "adaptor_HostIf_purpose"
	CONST_PROP_ID_ADAPTOR_HOST_IF_REVISION = "adaptor_HostIf_revision"
	CONST_PROP_ID_ADAPTOR_HOST_IF_SERIAL = "adaptor_HostIf_serial"
	CONST_PROP_ID_ADAPTOR_HOST_IF_SIDE = "adaptor_HostIf_side"
	CONST_PROP_ID_ADAPTOR_HOST_IF_SLOT_ID = "adaptor_HostIf_slotId"
	CONST_PROP_ID_ADAPTOR_HOST_IF_SWITCH_ID = "adaptor_HostIf_switchId"
	CONST_PROP_ID_ADAPTOR_HOST_IF_THERMAL = "adaptor_HostIf_thermal"
	CONST_PROP_ID_ADAPTOR_HOST_IF_TRANSPORT = "adaptor_HostIf_transport"
	CONST_PROP_ID_ADAPTOR_HOST_IF_TYPE = "adaptor_HostIf_type"
	CONST_PROP_ID_ADAPTOR_HOST_IF_VENDOR = "adaptor_HostIf_vendor"
	CONST_PROP_ID_ADAPTOR_HOST_IF_VNIC_DN = "adaptor_HostIf_vnicDn"
	CONST_PROP_ID_ADAPTOR_HOST_IF_VOLTAGE = "adaptor_HostIf_voltage"
	CONST_PROP_ID_ADAPTOR_HOST_ISCSI_IF_PROFILE_DESCR = "adaptor_HostIscsiIfProfile_descr"
	CONST_PROP_ID_ADAPTOR_HOST_ISCSI_IF_PROFILE_INT_ID = "adaptor_HostIscsiIfProfile_intId"
	CONST_PROP_ID_ADAPTOR_HOST_ISCSI_IF_PROFILE_NAME = "adaptor_HostIscsiIfProfile_name"
	CONST_PROP_ID_ADAPTOR_HOST_ISCSI_IF_PROFILE_POLICY_LEVEL = "adaptor_HostIscsiIfProfile_policyLevel"
	CONST_PROP_ID_ADAPTOR_HOST_ISCSI_IF_PROFILE_POLICY_OWNER = "adaptor_HostIscsiIfProfile_policyOwner"
	CONST_PROP_ID_ADAPTOR_HOST_ISCSI_IF_ADMIN_STATE = "adaptor_HostIscsiIf_adminState"
	CONST_PROP_ID_ADAPTOR_HOST_ISCSI_IF_BOOT_DEV = "adaptor_HostIscsiIf_bootDev"
	CONST_PROP_ID_ADAPTOR_HOST_ISCSI_IF_CHASSIS_ID = "adaptor_HostIscsiIf_chassisId"
	CONST_PROP_ID_ADAPTOR_HOST_ISCSI_IF_DISCOVERY = "adaptor_HostIscsiIf_discovery"
	CONST_PROP_ID_ADAPTOR_HOST_ISCSI_IF_EP_DN = "adaptor_HostIscsiIf_epDn"
	CONST_PROP_ID_ADAPTOR_HOST_ISCSI_IF_ETH_EP_DN = "adaptor_HostIscsiIf_ethEpDn"
	CONST_PROP_ID_ADAPTOR_HOST_ISCSI_IF_HOST_VISIBLE = "adaptor_HostIscsiIf_hostVisible"
	CONST_PROP_ID_ADAPTOR_HOST_ISCSI_IF_ID = "adaptor_HostIscsiIf_id"
	CONST_PROP_ID_ADAPTOR_HOST_ISCSI_IF_IF_ROLE = "adaptor_HostIscsiIf_ifRole"
	CONST_PROP_ID_ADAPTOR_HOST_ISCSI_IF_IF_TYPE = "adaptor_HostIscsiIf_ifType"
	CONST_PROP_ID_ADAPTOR_HOST_ISCSI_IF_INITIATOR_NAME = "adaptor_HostIscsiIf_initiatorName"
	CONST_PROP_ID_ADAPTOR_HOST_ISCSI_IF_LC = "adaptor_HostIscsiIf_lc"
	CONST_PROP_ID_ADAPTOR_HOST_ISCSI_IF_LINK_STATE = "adaptor_HostIscsiIf_linkState"
	CONST_PROP_ID_ADAPTOR_HOST_ISCSI_IF_LOCALE = "adaptor_HostIscsiIf_locale"
	CONST_PROP_ID_ADAPTOR_HOST_ISCSI_IF_MAC = "adaptor_HostIscsiIf_mac"
	CONST_PROP_ID_ADAPTOR_HOST_ISCSI_IF_MODEL = "adaptor_HostIscsiIf_model"
	CONST_PROP_ID_ADAPTOR_HOST_ISCSI_IF_NAME = "adaptor_HostIscsiIf_name"
	CONST_PROP_ID_ADAPTOR_HOST_ISCSI_IF_OPER_QUALIFIER_REASON = "adaptor_HostIscsiIf_operQualifierReason"
	CONST_PROP_ID_ADAPTOR_HOST_ISCSI_IF_OPER_STATE = "adaptor_HostIscsiIf_operState"
	CONST_PROP_ID_ADAPTOR_HOST_ISCSI_IF_OPERABILITY = "adaptor_HostIscsiIf_operability"
	CONST_PROP_ID_ADAPTOR_HOST_ISCSI_IF_ORDER = "adaptor_HostIscsiIf_order"
	CONST_PROP_ID_ADAPTOR_HOST_ISCSI_IF_ORIGINAL_MAC = "adaptor_HostIscsiIf_originalMac"
	CONST_PROP_ID_ADAPTOR_HOST_ISCSI_IF_PCI_ADDR = "adaptor_HostIscsiIf_pciAddr"
	CONST_PROP_ID_ADAPTOR_HOST_ISCSI_IF_PCI_FUNC = "adaptor_HostIscsiIf_pciFunc"
	CONST_PROP_ID_ADAPTOR_HOST_ISCSI_IF_PCI_SLOT = "adaptor_HostIscsiIf_pciSlot"
	CONST_PROP_ID_ADAPTOR_HOST_ISCSI_IF_PEER_CHASSIS_ID = "adaptor_HostIscsiIf_peerChassisId"
	CONST_PROP_ID_ADAPTOR_HOST_ISCSI_IF_PEER_DN = "adaptor_HostIscsiIf_peerDn"
	CONST_PROP_ID_ADAPTOR_HOST_ISCSI_IF_PEER_PORT_ID = "adaptor_HostIscsiIf_peerPortId"
	CONST_PROP_ID_ADAPTOR_HOST_ISCSI_IF_PEER_SLOT_ID = "adaptor_HostIscsiIf_peerSlotId"
	CONST_PROP_ID_ADAPTOR_HOST_ISCSI_IF_PERF = "adaptor_HostIscsiIf_perf"
	CONST_PROP_ID_ADAPTOR_HOST_ISCSI_IF_PORT_ID = "adaptor_HostIscsiIf_portId"
	CONST_PROP_ID_ADAPTOR_HOST_ISCSI_IF_POWER = "adaptor_HostIscsiIf_power"
	CONST_PROP_ID_ADAPTOR_HOST_ISCSI_IF_PRESENCE = "adaptor_HostIscsiIf_presence"
	CONST_PROP_ID_ADAPTOR_HOST_ISCSI_IF_PURPOSE = "adaptor_HostIscsiIf_purpose"
	CONST_PROP_ID_ADAPTOR_HOST_ISCSI_IF_REVISION = "adaptor_HostIscsiIf_revision"
	CONST_PROP_ID_ADAPTOR_HOST_ISCSI_IF_SERIAL = "adaptor_HostIscsiIf_serial"
	CONST_PROP_ID_ADAPTOR_HOST_ISCSI_IF_SIDE = "adaptor_HostIscsiIf_side"
	CONST_PROP_ID_ADAPTOR_HOST_ISCSI_IF_SLOT_ID = "adaptor_HostIscsiIf_slotId"
	CONST_PROP_ID_ADAPTOR_HOST_ISCSI_IF_SWITCH_ID = "adaptor_HostIscsiIf_switchId"
	CONST_PROP_ID_ADAPTOR_HOST_ISCSI_IF_THERMAL = "adaptor_HostIscsiIf_thermal"
	CONST_PROP_ID_ADAPTOR_HOST_ISCSI_IF_TRANSPORT = "adaptor_HostIscsiIf_transport"
	CONST_PROP_ID_ADAPTOR_HOST_ISCSI_IF_TYPE = "adaptor_HostIscsiIf_type"
	CONST_PROP_ID_ADAPTOR_HOST_ISCSI_IF_VENDOR = "adaptor_HostIscsiIf_vendor"
	CONST_PROP_ID_ADAPTOR_HOST_ISCSI_IF_VNIC_DN = "adaptor_HostIscsiIf_vnicDn"
	CONST_PROP_ID_ADAPTOR_HOST_ISCSI_IF_VNIC_NAME = "adaptor_HostIscsiIf_vnicName"
	CONST_PROP_ID_ADAPTOR_HOST_ISCSI_IF_VOLTAGE = "adaptor_HostIscsiIf_voltage"
	CONST_PROP_ID_ADAPTOR_HOST_MGMT_CAP_MODE = "adaptor_HostMgmtCap_mode"
	CONST_PROP_ID_ADAPTOR_HOST_MGMT_CAP_OPER_POWER_REQUIREMENT = "adaptor_HostMgmtCap_operPowerRequirement"
	CONST_PROP_ID_ADAPTOR_HOST_MGMT_CAP_PREBOOT = "adaptor_HostMgmtCap_preboot"
	CONST_PROP_ID_ADAPTOR_HOST_MGMT_CAP_PRESENCE = "adaptor_HostMgmtCap_presence"
	CONST_PROP_ID_ADAPTOR_HOST_MGMT_CAP_REBOOT_ACTION_ON_DESTRUCTIVE = "adaptor_HostMgmtCap_rebootActionOnDestructive"
	CONST_PROP_ID_ADAPTOR_HOST_SERVICE_ETH_IF_ADMIN_STATE = "adaptor_HostServiceEthIf_adminState"
	CONST_PROP_ID_ADAPTOR_HOST_SERVICE_ETH_IF_BOOT_DEV = "adaptor_HostServiceEthIf_bootDev"
	CONST_PROP_ID_ADAPTOR_HOST_SERVICE_ETH_IF_CHASSIS_ID = "adaptor_HostServiceEthIf_chassisId"
	CONST_PROP_ID_ADAPTOR_HOST_SERVICE_ETH_IF_DISCOVERY = "adaptor_HostServiceEthIf_discovery"
	CONST_PROP_ID_ADAPTOR_HOST_SERVICE_ETH_IF_EP_DN = "adaptor_HostServiceEthIf_epDn"
	CONST_PROP_ID_ADAPTOR_HOST_SERVICE_ETH_IF_ID = "adaptor_HostServiceEthIf_id"
	CONST_PROP_ID_ADAPTOR_HOST_SERVICE_ETH_IF_IF_ROLE = "adaptor_HostServiceEthIf_ifRole"
	CONST_PROP_ID_ADAPTOR_HOST_SERVICE_ETH_IF_IF_TYPE = "adaptor_HostServiceEthIf_ifType"
	CONST_PROP_ID_ADAPTOR_HOST_SERVICE_ETH_IF_LC = "adaptor_HostServiceEthIf_lc"
	CONST_PROP_ID_ADAPTOR_HOST_SERVICE_ETH_IF_LINK_STATE = "adaptor_HostServiceEthIf_linkState"
	CONST_PROP_ID_ADAPTOR_HOST_SERVICE_ETH_IF_LOCALE = "adaptor_HostServiceEthIf_locale"
	CONST_PROP_ID_ADAPTOR_HOST_SERVICE_ETH_IF_MAC = "adaptor_HostServiceEthIf_mac"
	CONST_PROP_ID_ADAPTOR_HOST_SERVICE_ETH_IF_MODEL = "adaptor_HostServiceEthIf_model"
	CONST_PROP_ID_ADAPTOR_HOST_SERVICE_ETH_IF_MTU = "adaptor_HostServiceEthIf_mtu"
	CONST_PROP_ID_ADAPTOR_HOST_SERVICE_ETH_IF_NAME = "adaptor_HostServiceEthIf_name"
	CONST_PROP_ID_ADAPTOR_HOST_SERVICE_ETH_IF_OPER_QUALIFIER_REASON = "adaptor_HostServiceEthIf_operQualifierReason"
	CONST_PROP_ID_ADAPTOR_HOST_SERVICE_ETH_IF_OPER_STATE = "adaptor_HostServiceEthIf_operState"
	CONST_PROP_ID_ADAPTOR_HOST_SERVICE_ETH_IF_OPERABILITY = "adaptor_HostServiceEthIf_operability"
	CONST_PROP_ID_ADAPTOR_HOST_SERVICE_ETH_IF_ORDER = "adaptor_HostServiceEthIf_order"
	CONST_PROP_ID_ADAPTOR_HOST_SERVICE_ETH_IF_ORIGINAL_MAC = "adaptor_HostServiceEthIf_originalMac"
	CONST_PROP_ID_ADAPTOR_HOST_SERVICE_ETH_IF_PCI_ADDR = "adaptor_HostServiceEthIf_pciAddr"
	CONST_PROP_ID_ADAPTOR_HOST_SERVICE_ETH_IF_PCI_FUNC = "adaptor_HostServiceEthIf_pciFunc"
	CONST_PROP_ID_ADAPTOR_HOST_SERVICE_ETH_IF_PCI_SLOT = "adaptor_HostServiceEthIf_pciSlot"
	CONST_PROP_ID_ADAPTOR_HOST_SERVICE_ETH_IF_PEER_CHASSIS_ID = "adaptor_HostServiceEthIf_peerChassisId"
	CONST_PROP_ID_ADAPTOR_HOST_SERVICE_ETH_IF_PEER_DN = "adaptor_HostServiceEthIf_peerDn"
	CONST_PROP_ID_ADAPTOR_HOST_SERVICE_ETH_IF_PEER_PORT_ID = "adaptor_HostServiceEthIf_peerPortId"
	CONST_PROP_ID_ADAPTOR_HOST_SERVICE_ETH_IF_PEER_SLOT_ID = "adaptor_HostServiceEthIf_peerSlotId"
	CONST_PROP_ID_ADAPTOR_HOST_SERVICE_ETH_IF_PERF = "adaptor_HostServiceEthIf_perf"
	CONST_PROP_ID_ADAPTOR_HOST_SERVICE_ETH_IF_PORT_ID = "adaptor_HostServiceEthIf_portId"
	CONST_PROP_ID_ADAPTOR_HOST_SERVICE_ETH_IF_POWER = "adaptor_HostServiceEthIf_power"
	CONST_PROP_ID_ADAPTOR_HOST_SERVICE_ETH_IF_PRESENCE = "adaptor_HostServiceEthIf_presence"
	CONST_PROP_ID_ADAPTOR_HOST_SERVICE_ETH_IF_PURPOSE = "adaptor_HostServiceEthIf_purpose"
	CONST_PROP_ID_ADAPTOR_HOST_SERVICE_ETH_IF_REVISION = "adaptor_HostServiceEthIf_revision"
	CONST_PROP_ID_ADAPTOR_HOST_SERVICE_ETH_IF_SERIAL = "adaptor_HostServiceEthIf_serial"
	CONST_PROP_ID_ADAPTOR_HOST_SERVICE_ETH_IF_SIDE = "adaptor_HostServiceEthIf_side"
	CONST_PROP_ID_ADAPTOR_HOST_SERVICE_ETH_IF_SLOT_ID = "adaptor_HostServiceEthIf_slotId"
	CONST_PROP_ID_ADAPTOR_HOST_SERVICE_ETH_IF_SWITCH_ID = "adaptor_HostServiceEthIf_switchId"
	CONST_PROP_ID_ADAPTOR_HOST_SERVICE_ETH_IF_THERMAL = "adaptor_HostServiceEthIf_thermal"
	CONST_PROP_ID_ADAPTOR_HOST_SERVICE_ETH_IF_TRANSPORT = "adaptor_HostServiceEthIf_transport"
	CONST_PROP_ID_ADAPTOR_HOST_SERVICE_ETH_IF_TYPE = "adaptor_HostServiceEthIf_type"
	CONST_PROP_ID_ADAPTOR_HOST_SERVICE_ETH_IF_VENDOR = "adaptor_HostServiceEthIf_vendor"
	CONST_PROP_ID_ADAPTOR_HOST_SERVICE_ETH_IF_VNIC_DN = "adaptor_HostServiceEthIf_vnicDn"
	CONST_PROP_ID_ADAPTOR_HOST_SERVICE_ETH_IF_VOLTAGE = "adaptor_HostServiceEthIf_voltage"
	CONST_PROP_ID_ADAPTOR_HOSTETH_HW_ADDR_CAP_MAC_OFFSET1 = "adaptor_HostethHwAddrCap_macOffset1"
	CONST_PROP_ID_ADAPTOR_HOSTETH_HW_ADDR_CAP_MAC_OFFSET2 = "adaptor_HostethHwAddrCap_macOffset2"
	CONST_PROP_ID_ADAPTOR_HOSTFC_HW_ADDR_CAP_MAC_OFFSET1 = "adaptor_HostfcHwAddrCap_macOffset1"
	CONST_PROP_ID_ADAPTOR_HOSTFC_HW_ADDR_CAP_MAC_OFFSET2 = "adaptor_HostfcHwAddrCap_macOffset2"
	CONST_PROP_ID_ADAPTOR_HOSTFC_HW_ADDR_CAP_WWN_REVERSE_MASK_A = "adaptor_HostfcHwAddrCap_wwnReverseMaskA"
	CONST_PROP_ID_ADAPTOR_HOSTFC_HW_ADDR_CAP_WWN_REVERSE_MASK_B = "adaptor_HostfcHwAddrCap_wwnReverseMaskB"
	CONST_PROP_ID_ADAPTOR_HOSTFC_HW_ADDR_CAP_WWNN_REVERSE_MASK_A = "adaptor_HostfcHwAddrCap_wwnnReverseMaskA"
	CONST_PROP_ID_ADAPTOR_HOSTFC_HW_ADDR_CAP_WWNN_REVERSE_MASK_B = "adaptor_HostfcHwAddrCap_wwnnReverseMaskB"
	CONST_PROP_ID_ADAPTOR_HW_ADDR_CAP_MAC_OFFSET1 = "adaptor_HwAddrCap_macOffset1"
	CONST_PROP_ID_ADAPTOR_HW_ADDR_CAP_MAC_OFFSET2 = "adaptor_HwAddrCap_macOffset2"
	CONST_PROP_ID_ADAPTOR_ISCSI_CAP_BOOT_ORDER_TYPE = "adaptor_IScsiCap_bootOrderType"
	CONST_PROP_ID_ADAPTOR_ISCSI_CAP_MAC_OFFSET1 = "adaptor_IScsiCap_macOffset1"
	CONST_PROP_ID_ADAPTOR_ISCSI_CAP_MAC_OFFSET2 = "adaptor_IScsiCap_macOffset2"
	CONST_PROP_ID_ADAPTOR_ISCSI_CAP_OFFLOAD_SUPPORT = "adaptor_IScsiCap_offloadSupport"
	CONST_PROP_ID_ADAPTOR_ISCSI_CAP_OFFLOAD_TYPE = "adaptor_IScsiCap_offloadType"
	CONST_PROP_ID_ADAPTOR_ISCSI_CAP_VLAN_FOR_BOOT = "adaptor_IScsiCap_vlanForBoot"
	CONST_PROP_ID_ADAPTOR_IP_V4_RSS_HASH_PROFILE_IP_HASH = "adaptor_IpV4RssHashProfile_ipHash"
	CONST_PROP_ID_ADAPTOR_IP_V4_RSS_HASH_PROFILE_TCP_HASH = "adaptor_IpV4RssHashProfile_tcpHash"
	CONST_PROP_ID_ADAPTOR_IP_V6_RSS_HASH_PROFILE_IP_HASH = "adaptor_IpV6RssHashProfile_ipHash"
	CONST_PROP_ID_ADAPTOR_IP_V6_RSS_HASH_PROFILE_TCP_HASH = "adaptor_IpV6RssHashProfile_tcpHash"
	CONST_PROP_ID_ADAPTOR_ISCSI_AUTH_PASSWORD = "adaptor_IscsiAuth_password"
	CONST_PROP_ID_ADAPTOR_ISCSI_AUTH_USER_ID = "adaptor_IscsiAuth_userId"
	CONST_PROP_ID_ADAPTOR_ISCSI_PROT_CONNECTION_TIME_OUT = "adaptor_IscsiProt_connectionTimeOut"
	CONST_PROP_ID_ADAPTOR_ISCSI_PROT_DHCP_TIME_OUT = "adaptor_IscsiProt_dhcpTimeOut"
	CONST_PROP_ID_ADAPTOR_ISCSI_PROT_INITIATOR_NAME = "adaptor_IscsiProt_initiatorName"
	CONST_PROP_ID_ADAPTOR_ISCSI_PROT_LUN_BUSY_RETRY_COUNT = "adaptor_IscsiProt_lunBusyRetryCount"
	CONST_PROP_ID_ADAPTOR_ISCSI_PROT_TCP_TIME_STAMP = "adaptor_IscsiProt_tcpTimeStamp"
	CONST_PROP_ID_ADAPTOR_ISCSI_TARGET_IF_DHCP_VENDOR_ID = "adaptor_IscsiTargetIf_dhcpVendorId"
	CONST_PROP_ID_ADAPTOR_ISCSI_TARGET_IF_IP_ADDRESS = "adaptor_IscsiTargetIf_ipAddress"
	CONST_PROP_ID_ADAPTOR_ISCSI_TARGET_IF_LUN = "adaptor_IscsiTargetIf_lun"
	CONST_PROP_ID_ADAPTOR_ISCSI_TARGET_IF_NAME = "adaptor_IscsiTargetIf_name"
	CONST_PROP_ID_ADAPTOR_ISCSI_TARGET_IF_PORT_NUMBER = "adaptor_IscsiTargetIf_portNumber"
	CONST_PROP_ID_ADAPTOR_ISCSI_TARGET_IF_PRIORITY = "adaptor_IscsiTargetIf_priority"
	CONST_PROP_ID_ADAPTOR_LAN_CAP_DEFAULT_VLAN = "adaptor_LanCap_defaultVlan"
	CONST_PROP_ID_ADAPTOR_LINK_STATE_HOLDER_LINK_STATE = "adaptor_LinkStateHolder_linkState"
	CONST_PROP_ID_ADAPTOR_LLDP_CAP_SUPPORT = "adaptor_LldpCap_support"
	CONST_PROP_ID_ADAPTOR_MENLO_BASE_ERROR_STATS_HIST_CORRECTABLE_ERRORS = "adaptor_MenloBaseErrorStatsHist_correctableErrors"
	CONST_PROP_ID_ADAPTOR_MENLO_BASE_ERROR_STATS_HIST_CORRECTABLE_ERRORS_DELTA = "adaptor_MenloBaseErrorStatsHist_correctableErrorsDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_BASE_ERROR_STATS_HIST_CORRECTABLE_ERRORS_DELTA_AVG = "adaptor_MenloBaseErrorStatsHist_correctableErrorsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_BASE_ERROR_STATS_HIST_CORRECTABLE_ERRORS_DELTA_MAX = "adaptor_MenloBaseErrorStatsHist_correctableErrorsDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_BASE_ERROR_STATS_HIST_CORRECTABLE_ERRORS_DELTA_MIN = "adaptor_MenloBaseErrorStatsHist_correctableErrorsDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_BASE_ERROR_STATS_HIST_ID = "adaptor_MenloBaseErrorStatsHist_id"
	CONST_PROP_ID_ADAPTOR_MENLO_BASE_ERROR_STATS_HIST_MOST_RECENT = "adaptor_MenloBaseErrorStatsHist_mostRecent"
	CONST_PROP_ID_ADAPTOR_MENLO_BASE_ERROR_STATS_HIST_SUSPECT = "adaptor_MenloBaseErrorStatsHist_suspect"
	CONST_PROP_ID_ADAPTOR_MENLO_BASE_ERROR_STATS_HIST_THRESHOLDED = "adaptor_MenloBaseErrorStatsHist_thresholded"
	CONST_PROP_ID_ADAPTOR_MENLO_BASE_ERROR_STATS_HIST_TIME_COLLECTED = "adaptor_MenloBaseErrorStatsHist_timeCollected"
	CONST_PROP_ID_ADAPTOR_MENLO_BASE_ERROR_STATS_HIST_UNCORRECTABLE_ERRORS = "adaptor_MenloBaseErrorStatsHist_uncorrectableErrors"
	CONST_PROP_ID_ADAPTOR_MENLO_BASE_ERROR_STATS_HIST_UNCORRECTABLE_ERRORS_DELTA = "adaptor_MenloBaseErrorStatsHist_uncorrectableErrorsDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_BASE_ERROR_STATS_HIST_UNCORRECTABLE_ERRORS_DELTA_AVG = "adaptor_MenloBaseErrorStatsHist_uncorrectableErrorsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_BASE_ERROR_STATS_HIST_UNCORRECTABLE_ERRORS_DELTA_MAX = "adaptor_MenloBaseErrorStatsHist_uncorrectableErrorsDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_BASE_ERROR_STATS_HIST_UNCORRECTABLE_ERRORS_DELTA_MIN = "adaptor_MenloBaseErrorStatsHist_uncorrectableErrorsDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_BASE_ERROR_STATS_CORRECTABLE_ERRORS = "adaptor_MenloBaseErrorStats_correctableErrors"
	CONST_PROP_ID_ADAPTOR_MENLO_BASE_ERROR_STATS_CORRECTABLE_ERRORS_DELTA = "adaptor_MenloBaseErrorStats_correctableErrorsDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_BASE_ERROR_STATS_CORRECTABLE_ERRORS_DELTA_AVG = "adaptor_MenloBaseErrorStats_correctableErrorsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_BASE_ERROR_STATS_CORRECTABLE_ERRORS_DELTA_MAX = "adaptor_MenloBaseErrorStats_correctableErrorsDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_BASE_ERROR_STATS_CORRECTABLE_ERRORS_DELTA_MIN = "adaptor_MenloBaseErrorStats_correctableErrorsDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_BASE_ERROR_STATS_INTERVALS = "adaptor_MenloBaseErrorStats_intervals"
	CONST_PROP_ID_ADAPTOR_MENLO_BASE_ERROR_STATS_SUSPECT = "adaptor_MenloBaseErrorStats_suspect"
	CONST_PROP_ID_ADAPTOR_MENLO_BASE_ERROR_STATS_THRESHOLDED = "adaptor_MenloBaseErrorStats_thresholded"
	CONST_PROP_ID_ADAPTOR_MENLO_BASE_ERROR_STATS_TIME_COLLECTED = "adaptor_MenloBaseErrorStats_timeCollected"
	CONST_PROP_ID_ADAPTOR_MENLO_BASE_ERROR_STATS_UNCORRECTABLE_ERRORS = "adaptor_MenloBaseErrorStats_uncorrectableErrors"
	CONST_PROP_ID_ADAPTOR_MENLO_BASE_ERROR_STATS_UNCORRECTABLE_ERRORS_DELTA = "adaptor_MenloBaseErrorStats_uncorrectableErrorsDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_BASE_ERROR_STATS_UNCORRECTABLE_ERRORS_DELTA_AVG = "adaptor_MenloBaseErrorStats_uncorrectableErrorsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_BASE_ERROR_STATS_UNCORRECTABLE_ERRORS_DELTA_MAX = "adaptor_MenloBaseErrorStats_uncorrectableErrorsDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_BASE_ERROR_STATS_UNCORRECTABLE_ERRORS_DELTA_MIN = "adaptor_MenloBaseErrorStats_uncorrectableErrorsDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_BASE_ERROR_STATS_UPDATE = "adaptor_MenloBaseErrorStats_update"
	CONST_PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_ID = "adaptor_MenloDcePortStatsHist_id"
	CONST_PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_MOST_RECENT = "adaptor_MenloDcePortStatsHist_mostRecent"
	CONST_PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_RX_PAUSE_CFC = "adaptor_MenloDcePortStatsHist_rxPauseCFC"
	CONST_PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_RX_PAUSE_CFCDELTA = "adaptor_MenloDcePortStatsHist_rxPauseCFCDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_RX_PAUSE_CFCDELTA_AVG = "adaptor_MenloDcePortStatsHist_rxPauseCFCDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_RX_PAUSE_CFCDELTA_MAX = "adaptor_MenloDcePortStatsHist_rxPauseCFCDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_RX_PAUSE_CFCDELTA_MIN = "adaptor_MenloDcePortStatsHist_rxPauseCFCDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_RX_PAUSE_PFC = "adaptor_MenloDcePortStatsHist_rxPausePFC"
	CONST_PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_RX_PAUSE_PFCDELTA = "adaptor_MenloDcePortStatsHist_rxPausePFCDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_RX_PAUSE_PFCDELTA_AVG = "adaptor_MenloDcePortStatsHist_rxPausePFCDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_RX_PAUSE_PFCDELTA_MAX = "adaptor_MenloDcePortStatsHist_rxPausePFCDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_RX_PAUSE_PFCDELTA_MIN = "adaptor_MenloDcePortStatsHist_rxPausePFCDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_SUSPECT = "adaptor_MenloDcePortStatsHist_suspect"
	CONST_PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_THRESHOLDED = "adaptor_MenloDcePortStatsHist_thresholded"
	CONST_PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_TIME_COLLECTED = "adaptor_MenloDcePortStatsHist_timeCollected"
	CONST_PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_TX_PAUSE_CFC = "adaptor_MenloDcePortStatsHist_txPauseCFC"
	CONST_PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_TX_PAUSE_CFCDELTA = "adaptor_MenloDcePortStatsHist_txPauseCFCDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_TX_PAUSE_CFCDELTA_AVG = "adaptor_MenloDcePortStatsHist_txPauseCFCDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_TX_PAUSE_CFCDELTA_MAX = "adaptor_MenloDcePortStatsHist_txPauseCFCDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_TX_PAUSE_CFCDELTA_MIN = "adaptor_MenloDcePortStatsHist_txPauseCFCDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_TX_PAUSE_PFC = "adaptor_MenloDcePortStatsHist_txPausePFC"
	CONST_PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_TX_PAUSE_PFCDELTA = "adaptor_MenloDcePortStatsHist_txPausePFCDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_TX_PAUSE_PFCDELTA_AVG = "adaptor_MenloDcePortStatsHist_txPausePFCDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_TX_PAUSE_PFCDELTA_MAX = "adaptor_MenloDcePortStatsHist_txPausePFCDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_TX_PAUSE_PFCDELTA_MIN = "adaptor_MenloDcePortStatsHist_txPausePFCDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATS_INTERVALS = "adaptor_MenloDcePortStats_intervals"
	CONST_PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATS_MENLO_PORT_INDEX = "adaptor_MenloDcePortStats_menloPortIndex"
	CONST_PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATS_RX_PAUSE_CFC = "adaptor_MenloDcePortStats_rxPauseCFC"
	CONST_PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATS_RX_PAUSE_CFCDELTA = "adaptor_MenloDcePortStats_rxPauseCFCDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATS_RX_PAUSE_CFCDELTA_AVG = "adaptor_MenloDcePortStats_rxPauseCFCDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATS_RX_PAUSE_CFCDELTA_MAX = "adaptor_MenloDcePortStats_rxPauseCFCDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATS_RX_PAUSE_CFCDELTA_MIN = "adaptor_MenloDcePortStats_rxPauseCFCDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATS_RX_PAUSE_PFC = "adaptor_MenloDcePortStats_rxPausePFC"
	CONST_PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATS_RX_PAUSE_PFCDELTA = "adaptor_MenloDcePortStats_rxPausePFCDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATS_RX_PAUSE_PFCDELTA_AVG = "adaptor_MenloDcePortStats_rxPausePFCDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATS_RX_PAUSE_PFCDELTA_MAX = "adaptor_MenloDcePortStats_rxPausePFCDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATS_RX_PAUSE_PFCDELTA_MIN = "adaptor_MenloDcePortStats_rxPausePFCDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATS_SUSPECT = "adaptor_MenloDcePortStats_suspect"
	CONST_PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATS_THRESHOLDED = "adaptor_MenloDcePortStats_thresholded"
	CONST_PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATS_TIME_COLLECTED = "adaptor_MenloDcePortStats_timeCollected"
	CONST_PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATS_TX_PAUSE_CFC = "adaptor_MenloDcePortStats_txPauseCFC"
	CONST_PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATS_TX_PAUSE_CFCDELTA = "adaptor_MenloDcePortStats_txPauseCFCDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATS_TX_PAUSE_CFCDELTA_AVG = "adaptor_MenloDcePortStats_txPauseCFCDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATS_TX_PAUSE_CFCDELTA_MAX = "adaptor_MenloDcePortStats_txPauseCFCDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATS_TX_PAUSE_CFCDELTA_MIN = "adaptor_MenloDcePortStats_txPauseCFCDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATS_TX_PAUSE_PFC = "adaptor_MenloDcePortStats_txPausePFC"
	CONST_PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATS_TX_PAUSE_PFCDELTA = "adaptor_MenloDcePortStats_txPausePFCDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATS_TX_PAUSE_PFCDELTA_AVG = "adaptor_MenloDcePortStats_txPausePFCDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATS_TX_PAUSE_PFCDELTA_MAX = "adaptor_MenloDcePortStats_txPausePFCDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATS_TX_PAUSE_PFCDELTA_MIN = "adaptor_MenloDcePortStats_txPausePFCDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_DCE_PORT_STATS_UPDATE = "adaptor_MenloDcePortStats_update"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_CORRECTABLE_ERRORS = "adaptor_MenloEthErrorStatsHist_correctableErrors"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_CORRECTABLE_ERRORS_DELTA = "adaptor_MenloEthErrorStatsHist_correctableErrorsDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_CORRECTABLE_ERRORS_DELTA_AVG = "adaptor_MenloEthErrorStatsHist_correctableErrorsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_CORRECTABLE_ERRORS_DELTA_MAX = "adaptor_MenloEthErrorStatsHist_correctableErrorsDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_CORRECTABLE_ERRORS_DELTA_MIN = "adaptor_MenloEthErrorStatsHist_correctableErrorsDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_DROP_ACL = "adaptor_MenloEthErrorStatsHist_dropAcl"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_DROP_ACL_DELTA = "adaptor_MenloEthErrorStatsHist_dropAclDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_DROP_ACL_DELTA_AVG = "adaptor_MenloEthErrorStatsHist_dropAclDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_DROP_ACL_DELTA_MAX = "adaptor_MenloEthErrorStatsHist_dropAclDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_DROP_ACL_DELTA_MIN = "adaptor_MenloEthErrorStatsHist_dropAclDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_ID = "adaptor_MenloEthErrorStatsHist_id"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_MOST_RECENT = "adaptor_MenloEthErrorStatsHist_mostRecent"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_POP_ERRORS = "adaptor_MenloEthErrorStatsHist_popErrors"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_POP_ERRORS_DELTA = "adaptor_MenloEthErrorStatsHist_popErrorsDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_POP_ERRORS_DELTA_AVG = "adaptor_MenloEthErrorStatsHist_popErrorsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_POP_ERRORS_DELTA_MAX = "adaptor_MenloEthErrorStatsHist_popErrorsDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_POP_ERRORS_DELTA_MIN = "adaptor_MenloEthErrorStatsHist_popErrorsDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_PUSH_ERRORS = "adaptor_MenloEthErrorStatsHist_pushErrors"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_PUSH_ERRORS_DELTA = "adaptor_MenloEthErrorStatsHist_pushErrorsDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_PUSH_ERRORS_DELTA_AVG = "adaptor_MenloEthErrorStatsHist_pushErrorsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_PUSH_ERRORS_DELTA_MAX = "adaptor_MenloEthErrorStatsHist_pushErrorsDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_PUSH_ERRORS_DELTA_MIN = "adaptor_MenloEthErrorStatsHist_pushErrorsDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_SUSPECT = "adaptor_MenloEthErrorStatsHist_suspect"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_THRESHOLDED = "adaptor_MenloEthErrorStatsHist_thresholded"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_TIME_COLLECTED = "adaptor_MenloEthErrorStatsHist_timeCollected"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_UNCORRECTABLE_ERRORS = "adaptor_MenloEthErrorStatsHist_uncorrectableErrors"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_UNCORRECTABLE_ERRORS_DELTA = "adaptor_MenloEthErrorStatsHist_uncorrectableErrorsDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_UNCORRECTABLE_ERRORS_DELTA_AVG = "adaptor_MenloEthErrorStatsHist_uncorrectableErrorsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_UNCORRECTABLE_ERRORS_DELTA_MAX = "adaptor_MenloEthErrorStatsHist_uncorrectableErrorsDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_UNCORRECTABLE_ERRORS_DELTA_MIN = "adaptor_MenloEthErrorStatsHist_uncorrectableErrorsDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATS_CORRECTABLE_ERRORS = "adaptor_MenloEthErrorStats_correctableErrors"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATS_CORRECTABLE_ERRORS_DELTA = "adaptor_MenloEthErrorStats_correctableErrorsDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATS_CORRECTABLE_ERRORS_DELTA_AVG = "adaptor_MenloEthErrorStats_correctableErrorsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATS_CORRECTABLE_ERRORS_DELTA_MAX = "adaptor_MenloEthErrorStats_correctableErrorsDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATS_CORRECTABLE_ERRORS_DELTA_MIN = "adaptor_MenloEthErrorStats_correctableErrorsDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATS_DROP_ACL = "adaptor_MenloEthErrorStats_dropAcl"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATS_DROP_ACL_DELTA = "adaptor_MenloEthErrorStats_dropAclDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATS_DROP_ACL_DELTA_AVG = "adaptor_MenloEthErrorStats_dropAclDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATS_DROP_ACL_DELTA_MAX = "adaptor_MenloEthErrorStats_dropAclDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATS_DROP_ACL_DELTA_MIN = "adaptor_MenloEthErrorStats_dropAclDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATS_INTERVALS = "adaptor_MenloEthErrorStats_intervals"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATS_MENLO_ETH_INDEX = "adaptor_MenloEthErrorStats_menloEthIndex"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATS_POP_ERRORS = "adaptor_MenloEthErrorStats_popErrors"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATS_POP_ERRORS_DELTA = "adaptor_MenloEthErrorStats_popErrorsDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATS_POP_ERRORS_DELTA_AVG = "adaptor_MenloEthErrorStats_popErrorsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATS_POP_ERRORS_DELTA_MAX = "adaptor_MenloEthErrorStats_popErrorsDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATS_POP_ERRORS_DELTA_MIN = "adaptor_MenloEthErrorStats_popErrorsDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATS_PUSH_ERRORS = "adaptor_MenloEthErrorStats_pushErrors"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATS_PUSH_ERRORS_DELTA = "adaptor_MenloEthErrorStats_pushErrorsDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATS_PUSH_ERRORS_DELTA_AVG = "adaptor_MenloEthErrorStats_pushErrorsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATS_PUSH_ERRORS_DELTA_MAX = "adaptor_MenloEthErrorStats_pushErrorsDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATS_PUSH_ERRORS_DELTA_MIN = "adaptor_MenloEthErrorStats_pushErrorsDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATS_SUSPECT = "adaptor_MenloEthErrorStats_suspect"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATS_THRESHOLDED = "adaptor_MenloEthErrorStats_thresholded"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATS_TIME_COLLECTED = "adaptor_MenloEthErrorStats_timeCollected"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATS_UNCORRECTABLE_ERRORS = "adaptor_MenloEthErrorStats_uncorrectableErrors"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATS_UNCORRECTABLE_ERRORS_DELTA = "adaptor_MenloEthErrorStats_uncorrectableErrorsDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATS_UNCORRECTABLE_ERRORS_DELTA_AVG = "adaptor_MenloEthErrorStats_uncorrectableErrorsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATS_UNCORRECTABLE_ERRORS_DELTA_MAX = "adaptor_MenloEthErrorStats_uncorrectableErrorsDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATS_UNCORRECTABLE_ERRORS_DELTA_MIN = "adaptor_MenloEthErrorStats_uncorrectableErrorsDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_ERROR_STATS_UPDATE = "adaptor_MenloEthErrorStats_update"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_STATS_HIST_DROP_OVERRUN = "adaptor_MenloEthStatsHist_dropOverrun"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_STATS_HIST_DROP_OVERRUN_DELTA = "adaptor_MenloEthStatsHist_dropOverrunDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_STATS_HIST_DROP_OVERRUN_DELTA_AVG = "adaptor_MenloEthStatsHist_dropOverrunDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_STATS_HIST_DROP_OVERRUN_DELTA_MAX = "adaptor_MenloEthStatsHist_dropOverrunDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_STATS_HIST_DROP_OVERRUN_DELTA_MIN = "adaptor_MenloEthStatsHist_dropOverrunDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_STATS_HIST_DROP_RUNT = "adaptor_MenloEthStatsHist_dropRunt"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_STATS_HIST_DROP_RUNT_DELTA = "adaptor_MenloEthStatsHist_dropRuntDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_STATS_HIST_DROP_RUNT_DELTA_AVG = "adaptor_MenloEthStatsHist_dropRuntDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_STATS_HIST_DROP_RUNT_DELTA_MAX = "adaptor_MenloEthStatsHist_dropRuntDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_STATS_HIST_DROP_RUNT_DELTA_MIN = "adaptor_MenloEthStatsHist_dropRuntDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_STATS_HIST_ID = "adaptor_MenloEthStatsHist_id"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_STATS_HIST_MOST_RECENT = "adaptor_MenloEthStatsHist_mostRecent"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_STATS_HIST_SUSPECT = "adaptor_MenloEthStatsHist_suspect"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_STATS_HIST_THRESHOLDED = "adaptor_MenloEthStatsHist_thresholded"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_STATS_HIST_TIME_COLLECTED = "adaptor_MenloEthStatsHist_timeCollected"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_STATS_HIST_TRUNCATE_OVERRUN = "adaptor_MenloEthStatsHist_truncateOverrun"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_STATS_HIST_TRUNCATE_OVERRUN_DELTA = "adaptor_MenloEthStatsHist_truncateOverrunDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_STATS_HIST_TRUNCATE_OVERRUN_DELTA_AVG = "adaptor_MenloEthStatsHist_truncateOverrunDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_STATS_HIST_TRUNCATE_OVERRUN_DELTA_MAX = "adaptor_MenloEthStatsHist_truncateOverrunDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_STATS_HIST_TRUNCATE_OVERRUN_DELTA_MIN = "adaptor_MenloEthStatsHist_truncateOverrunDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_STATS_DROP_OVERRUN = "adaptor_MenloEthStats_dropOverrun"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_STATS_DROP_OVERRUN_DELTA = "adaptor_MenloEthStats_dropOverrunDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_STATS_DROP_OVERRUN_DELTA_AVG = "adaptor_MenloEthStats_dropOverrunDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_STATS_DROP_OVERRUN_DELTA_MAX = "adaptor_MenloEthStats_dropOverrunDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_STATS_DROP_OVERRUN_DELTA_MIN = "adaptor_MenloEthStats_dropOverrunDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_STATS_DROP_RUNT = "adaptor_MenloEthStats_dropRunt"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_STATS_DROP_RUNT_DELTA = "adaptor_MenloEthStats_dropRuntDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_STATS_DROP_RUNT_DELTA_AVG = "adaptor_MenloEthStats_dropRuntDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_STATS_DROP_RUNT_DELTA_MAX = "adaptor_MenloEthStats_dropRuntDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_STATS_DROP_RUNT_DELTA_MIN = "adaptor_MenloEthStats_dropRuntDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_STATS_INTERVALS = "adaptor_MenloEthStats_intervals"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_STATS_MENLO_ETH_INDEX = "adaptor_MenloEthStats_menloEthIndex"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_STATS_SUSPECT = "adaptor_MenloEthStats_suspect"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_STATS_THRESHOLDED = "adaptor_MenloEthStats_thresholded"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_STATS_TIME_COLLECTED = "adaptor_MenloEthStats_timeCollected"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_STATS_TRUNCATE_OVERRUN = "adaptor_MenloEthStats_truncateOverrun"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_STATS_TRUNCATE_OVERRUN_DELTA = "adaptor_MenloEthStats_truncateOverrunDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_STATS_TRUNCATE_OVERRUN_DELTA_AVG = "adaptor_MenloEthStats_truncateOverrunDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_STATS_TRUNCATE_OVERRUN_DELTA_MAX = "adaptor_MenloEthStats_truncateOverrunDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_STATS_TRUNCATE_OVERRUN_DELTA_MIN = "adaptor_MenloEthStats_truncateOverrunDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_ETH_STATS_UPDATE = "adaptor_MenloEthStats_update"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_CORRECTABLE_ERRORS = "adaptor_MenloFcErrorStatsHist_correctableErrors"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_CORRECTABLE_ERRORS_DELTA = "adaptor_MenloFcErrorStatsHist_correctableErrorsDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_CORRECTABLE_ERRORS_DELTA_AVG = "adaptor_MenloFcErrorStatsHist_correctableErrorsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_CORRECTABLE_ERRORS_DELTA_MAX = "adaptor_MenloFcErrorStatsHist_correctableErrorsDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_CORRECTABLE_ERRORS_DELTA_MIN = "adaptor_MenloFcErrorStatsHist_correctableErrorsDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_ID = "adaptor_MenloFcErrorStatsHist_id"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_MOST_RECENT = "adaptor_MenloFcErrorStatsHist_mostRecent"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_POP_ERRORS = "adaptor_MenloFcErrorStatsHist_popErrors"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_POP_ERRORS_DELTA = "adaptor_MenloFcErrorStatsHist_popErrorsDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_POP_ERRORS_DELTA_AVG = "adaptor_MenloFcErrorStatsHist_popErrorsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_POP_ERRORS_DELTA_MAX = "adaptor_MenloFcErrorStatsHist_popErrorsDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_POP_ERRORS_DELTA_MIN = "adaptor_MenloFcErrorStatsHist_popErrorsDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_PUSH_ERRORS = "adaptor_MenloFcErrorStatsHist_pushErrors"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_PUSH_ERRORS_DELTA = "adaptor_MenloFcErrorStatsHist_pushErrorsDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_PUSH_ERRORS_DELTA_AVG = "adaptor_MenloFcErrorStatsHist_pushErrorsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_PUSH_ERRORS_DELTA_MAX = "adaptor_MenloFcErrorStatsHist_pushErrorsDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_PUSH_ERRORS_DELTA_MIN = "adaptor_MenloFcErrorStatsHist_pushErrorsDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_SUSPECT = "adaptor_MenloFcErrorStatsHist_suspect"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_THRESHOLDED = "adaptor_MenloFcErrorStatsHist_thresholded"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_TIME_COLLECTED = "adaptor_MenloFcErrorStatsHist_timeCollected"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_UNCORRECTABLE_ERRORS = "adaptor_MenloFcErrorStatsHist_uncorrectableErrors"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_UNCORRECTABLE_ERRORS_DELTA = "adaptor_MenloFcErrorStatsHist_uncorrectableErrorsDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_UNCORRECTABLE_ERRORS_DELTA_AVG = "adaptor_MenloFcErrorStatsHist_uncorrectableErrorsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_UNCORRECTABLE_ERRORS_DELTA_MAX = "adaptor_MenloFcErrorStatsHist_uncorrectableErrorsDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_UNCORRECTABLE_ERRORS_DELTA_MIN = "adaptor_MenloFcErrorStatsHist_uncorrectableErrorsDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATS_CORRECTABLE_ERRORS = "adaptor_MenloFcErrorStats_correctableErrors"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATS_CORRECTABLE_ERRORS_DELTA = "adaptor_MenloFcErrorStats_correctableErrorsDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATS_CORRECTABLE_ERRORS_DELTA_AVG = "adaptor_MenloFcErrorStats_correctableErrorsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATS_CORRECTABLE_ERRORS_DELTA_MAX = "adaptor_MenloFcErrorStats_correctableErrorsDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATS_CORRECTABLE_ERRORS_DELTA_MIN = "adaptor_MenloFcErrorStats_correctableErrorsDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATS_INTERVALS = "adaptor_MenloFcErrorStats_intervals"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATS_MENLO_FC_INDEX = "adaptor_MenloFcErrorStats_menloFcIndex"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATS_POP_ERRORS = "adaptor_MenloFcErrorStats_popErrors"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATS_POP_ERRORS_DELTA = "adaptor_MenloFcErrorStats_popErrorsDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATS_POP_ERRORS_DELTA_AVG = "adaptor_MenloFcErrorStats_popErrorsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATS_POP_ERRORS_DELTA_MAX = "adaptor_MenloFcErrorStats_popErrorsDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATS_POP_ERRORS_DELTA_MIN = "adaptor_MenloFcErrorStats_popErrorsDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATS_PUSH_ERRORS = "adaptor_MenloFcErrorStats_pushErrors"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATS_PUSH_ERRORS_DELTA = "adaptor_MenloFcErrorStats_pushErrorsDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATS_PUSH_ERRORS_DELTA_AVG = "adaptor_MenloFcErrorStats_pushErrorsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATS_PUSH_ERRORS_DELTA_MAX = "adaptor_MenloFcErrorStats_pushErrorsDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATS_PUSH_ERRORS_DELTA_MIN = "adaptor_MenloFcErrorStats_pushErrorsDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATS_SUSPECT = "adaptor_MenloFcErrorStats_suspect"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATS_THRESHOLDED = "adaptor_MenloFcErrorStats_thresholded"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATS_TIME_COLLECTED = "adaptor_MenloFcErrorStats_timeCollected"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATS_UNCORRECTABLE_ERRORS = "adaptor_MenloFcErrorStats_uncorrectableErrors"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATS_UNCORRECTABLE_ERRORS_DELTA = "adaptor_MenloFcErrorStats_uncorrectableErrorsDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATS_UNCORRECTABLE_ERRORS_DELTA_AVG = "adaptor_MenloFcErrorStats_uncorrectableErrorsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATS_UNCORRECTABLE_ERRORS_DELTA_MAX = "adaptor_MenloFcErrorStats_uncorrectableErrorsDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATS_UNCORRECTABLE_ERRORS_DELTA_MIN = "adaptor_MenloFcErrorStats_uncorrectableErrorsDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_ERROR_STATS_UPDATE = "adaptor_MenloFcErrorStats_update"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_STATS_HIST_DROP_ACL = "adaptor_MenloFcStatsHist_dropAcl"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_STATS_HIST_DROP_ACL_DELTA = "adaptor_MenloFcStatsHist_dropAclDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_STATS_HIST_DROP_ACL_DELTA_AVG = "adaptor_MenloFcStatsHist_dropAclDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_STATS_HIST_DROP_ACL_DELTA_MAX = "adaptor_MenloFcStatsHist_dropAclDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_STATS_HIST_DROP_ACL_DELTA_MIN = "adaptor_MenloFcStatsHist_dropAclDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_STATS_HIST_DROP_OVERRUN = "adaptor_MenloFcStatsHist_dropOverrun"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_STATS_HIST_DROP_OVERRUN_DELTA = "adaptor_MenloFcStatsHist_dropOverrunDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_STATS_HIST_DROP_OVERRUN_DELTA_AVG = "adaptor_MenloFcStatsHist_dropOverrunDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_STATS_HIST_DROP_OVERRUN_DELTA_MAX = "adaptor_MenloFcStatsHist_dropOverrunDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_STATS_HIST_DROP_OVERRUN_DELTA_MIN = "adaptor_MenloFcStatsHist_dropOverrunDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_STATS_HIST_DROP_RUNT = "adaptor_MenloFcStatsHist_dropRunt"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_STATS_HIST_DROP_RUNT_DELTA = "adaptor_MenloFcStatsHist_dropRuntDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_STATS_HIST_DROP_RUNT_DELTA_AVG = "adaptor_MenloFcStatsHist_dropRuntDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_STATS_HIST_DROP_RUNT_DELTA_MAX = "adaptor_MenloFcStatsHist_dropRuntDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_STATS_HIST_DROP_RUNT_DELTA_MIN = "adaptor_MenloFcStatsHist_dropRuntDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_STATS_HIST_ID = "adaptor_MenloFcStatsHist_id"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_STATS_HIST_MOST_RECENT = "adaptor_MenloFcStatsHist_mostRecent"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_STATS_HIST_SUSPECT = "adaptor_MenloFcStatsHist_suspect"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_STATS_HIST_THRESHOLDED = "adaptor_MenloFcStatsHist_thresholded"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_STATS_HIST_TIME_COLLECTED = "adaptor_MenloFcStatsHist_timeCollected"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_STATS_HIST_TRUNCATE_OVERRUN = "adaptor_MenloFcStatsHist_truncateOverrun"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_STATS_HIST_TRUNCATE_OVERRUN_DELTA = "adaptor_MenloFcStatsHist_truncateOverrunDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_STATS_HIST_TRUNCATE_OVERRUN_DELTA_AVG = "adaptor_MenloFcStatsHist_truncateOverrunDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_STATS_HIST_TRUNCATE_OVERRUN_DELTA_MAX = "adaptor_MenloFcStatsHist_truncateOverrunDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_STATS_HIST_TRUNCATE_OVERRUN_DELTA_MIN = "adaptor_MenloFcStatsHist_truncateOverrunDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_STATS_DROP_ACL = "adaptor_MenloFcStats_dropAcl"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_STATS_DROP_ACL_DELTA = "adaptor_MenloFcStats_dropAclDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_STATS_DROP_ACL_DELTA_AVG = "adaptor_MenloFcStats_dropAclDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_STATS_DROP_ACL_DELTA_MAX = "adaptor_MenloFcStats_dropAclDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_STATS_DROP_ACL_DELTA_MIN = "adaptor_MenloFcStats_dropAclDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_STATS_DROP_OVERRUN = "adaptor_MenloFcStats_dropOverrun"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_STATS_DROP_OVERRUN_DELTA = "adaptor_MenloFcStats_dropOverrunDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_STATS_DROP_OVERRUN_DELTA_AVG = "adaptor_MenloFcStats_dropOverrunDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_STATS_DROP_OVERRUN_DELTA_MAX = "adaptor_MenloFcStats_dropOverrunDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_STATS_DROP_OVERRUN_DELTA_MIN = "adaptor_MenloFcStats_dropOverrunDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_STATS_DROP_RUNT = "adaptor_MenloFcStats_dropRunt"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_STATS_DROP_RUNT_DELTA = "adaptor_MenloFcStats_dropRuntDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_STATS_DROP_RUNT_DELTA_AVG = "adaptor_MenloFcStats_dropRuntDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_STATS_DROP_RUNT_DELTA_MAX = "adaptor_MenloFcStats_dropRuntDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_STATS_DROP_RUNT_DELTA_MIN = "adaptor_MenloFcStats_dropRuntDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_STATS_INTERVALS = "adaptor_MenloFcStats_intervals"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_STATS_MENLO_FC_INDEX = "adaptor_MenloFcStats_menloFcIndex"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_STATS_SUSPECT = "adaptor_MenloFcStats_suspect"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_STATS_THRESHOLDED = "adaptor_MenloFcStats_thresholded"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_STATS_TIME_COLLECTED = "adaptor_MenloFcStats_timeCollected"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_STATS_TRUNCATE_OVERRUN = "adaptor_MenloFcStats_truncateOverrun"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_STATS_TRUNCATE_OVERRUN_DELTA = "adaptor_MenloFcStats_truncateOverrunDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_STATS_TRUNCATE_OVERRUN_DELTA_AVG = "adaptor_MenloFcStats_truncateOverrunDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_STATS_TRUNCATE_OVERRUN_DELTA_MAX = "adaptor_MenloFcStats_truncateOverrunDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_STATS_TRUNCATE_OVERRUN_DELTA_MIN = "adaptor_MenloFcStats_truncateOverrunDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_FC_STATS_UPDATE = "adaptor_MenloFcStats_update"
	CONST_PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_ID = "adaptor_MenloHostPortStatsHist_id"
	CONST_PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_MOST_RECENT = "adaptor_MenloHostPortStatsHist_mostRecent"
	CONST_PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_RX_PAUSE_CFC = "adaptor_MenloHostPortStatsHist_rxPauseCFC"
	CONST_PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_RX_PAUSE_CFCDELTA = "adaptor_MenloHostPortStatsHist_rxPauseCFCDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_RX_PAUSE_CFCDELTA_AVG = "adaptor_MenloHostPortStatsHist_rxPauseCFCDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_RX_PAUSE_CFCDELTA_MAX = "adaptor_MenloHostPortStatsHist_rxPauseCFCDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_RX_PAUSE_CFCDELTA_MIN = "adaptor_MenloHostPortStatsHist_rxPauseCFCDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_RX_PAUSE_PFC = "adaptor_MenloHostPortStatsHist_rxPausePFC"
	CONST_PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_RX_PAUSE_PFCDELTA = "adaptor_MenloHostPortStatsHist_rxPausePFCDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_RX_PAUSE_PFCDELTA_AVG = "adaptor_MenloHostPortStatsHist_rxPausePFCDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_RX_PAUSE_PFCDELTA_MAX = "adaptor_MenloHostPortStatsHist_rxPausePFCDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_RX_PAUSE_PFCDELTA_MIN = "adaptor_MenloHostPortStatsHist_rxPausePFCDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_SUSPECT = "adaptor_MenloHostPortStatsHist_suspect"
	CONST_PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_THRESHOLDED = "adaptor_MenloHostPortStatsHist_thresholded"
	CONST_PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_TIME_COLLECTED = "adaptor_MenloHostPortStatsHist_timeCollected"
	CONST_PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_TX_PAUSE_CFC = "adaptor_MenloHostPortStatsHist_txPauseCFC"
	CONST_PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_TX_PAUSE_CFCDELTA = "adaptor_MenloHostPortStatsHist_txPauseCFCDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_TX_PAUSE_CFCDELTA_AVG = "adaptor_MenloHostPortStatsHist_txPauseCFCDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_TX_PAUSE_CFCDELTA_MAX = "adaptor_MenloHostPortStatsHist_txPauseCFCDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_TX_PAUSE_CFCDELTA_MIN = "adaptor_MenloHostPortStatsHist_txPauseCFCDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_TX_PAUSE_PFC = "adaptor_MenloHostPortStatsHist_txPausePFC"
	CONST_PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_TX_PAUSE_PFCDELTA = "adaptor_MenloHostPortStatsHist_txPausePFCDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_TX_PAUSE_PFCDELTA_AVG = "adaptor_MenloHostPortStatsHist_txPausePFCDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_TX_PAUSE_PFCDELTA_MAX = "adaptor_MenloHostPortStatsHist_txPausePFCDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_TX_PAUSE_PFCDELTA_MIN = "adaptor_MenloHostPortStatsHist_txPausePFCDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATS_INTERVALS = "adaptor_MenloHostPortStats_intervals"
	CONST_PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATS_MENLO_PORT_INDEX = "adaptor_MenloHostPortStats_menloPortIndex"
	CONST_PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATS_RX_PAUSE_CFC = "adaptor_MenloHostPortStats_rxPauseCFC"
	CONST_PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATS_RX_PAUSE_CFCDELTA = "adaptor_MenloHostPortStats_rxPauseCFCDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATS_RX_PAUSE_CFCDELTA_AVG = "adaptor_MenloHostPortStats_rxPauseCFCDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATS_RX_PAUSE_CFCDELTA_MAX = "adaptor_MenloHostPortStats_rxPauseCFCDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATS_RX_PAUSE_CFCDELTA_MIN = "adaptor_MenloHostPortStats_rxPauseCFCDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATS_RX_PAUSE_PFC = "adaptor_MenloHostPortStats_rxPausePFC"
	CONST_PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATS_RX_PAUSE_PFCDELTA = "adaptor_MenloHostPortStats_rxPausePFCDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATS_RX_PAUSE_PFCDELTA_AVG = "adaptor_MenloHostPortStats_rxPausePFCDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATS_RX_PAUSE_PFCDELTA_MAX = "adaptor_MenloHostPortStats_rxPausePFCDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATS_RX_PAUSE_PFCDELTA_MIN = "adaptor_MenloHostPortStats_rxPausePFCDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATS_SUSPECT = "adaptor_MenloHostPortStats_suspect"
	CONST_PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATS_THRESHOLDED = "adaptor_MenloHostPortStats_thresholded"
	CONST_PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATS_TIME_COLLECTED = "adaptor_MenloHostPortStats_timeCollected"
	CONST_PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATS_TX_PAUSE_CFC = "adaptor_MenloHostPortStats_txPauseCFC"
	CONST_PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATS_TX_PAUSE_CFCDELTA = "adaptor_MenloHostPortStats_txPauseCFCDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATS_TX_PAUSE_CFCDELTA_AVG = "adaptor_MenloHostPortStats_txPauseCFCDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATS_TX_PAUSE_CFCDELTA_MAX = "adaptor_MenloHostPortStats_txPauseCFCDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATS_TX_PAUSE_CFCDELTA_MIN = "adaptor_MenloHostPortStats_txPauseCFCDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATS_TX_PAUSE_PFC = "adaptor_MenloHostPortStats_txPausePFC"
	CONST_PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATS_TX_PAUSE_PFCDELTA = "adaptor_MenloHostPortStats_txPausePFCDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATS_TX_PAUSE_PFCDELTA_AVG = "adaptor_MenloHostPortStats_txPausePFCDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATS_TX_PAUSE_PFCDELTA_MAX = "adaptor_MenloHostPortStats_txPausePFCDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATS_TX_PAUSE_PFCDELTA_MIN = "adaptor_MenloHostPortStats_txPausePFCDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_HOST_PORT_STATS_UPDATE = "adaptor_MenloHostPortStats_update"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_CORRECTABLE_ERRORS = "adaptor_MenloMcpuErrorStatsHist_correctableErrors"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_CORRECTABLE_ERRORS_DELTA = "adaptor_MenloMcpuErrorStatsHist_correctableErrorsDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_CORRECTABLE_ERRORS_DELTA_AVG = "adaptor_MenloMcpuErrorStatsHist_correctableErrorsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_CORRECTABLE_ERRORS_DELTA_MAX = "adaptor_MenloMcpuErrorStatsHist_correctableErrorsDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_CORRECTABLE_ERRORS_DELTA_MIN = "adaptor_MenloMcpuErrorStatsHist_correctableErrorsDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_ID = "adaptor_MenloMcpuErrorStatsHist_id"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_MOST_RECENT = "adaptor_MenloMcpuErrorStatsHist_mostRecent"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_POP_ERRORS = "adaptor_MenloMcpuErrorStatsHist_popErrors"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_POP_ERRORS_DELTA = "adaptor_MenloMcpuErrorStatsHist_popErrorsDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_POP_ERRORS_DELTA_AVG = "adaptor_MenloMcpuErrorStatsHist_popErrorsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_POP_ERRORS_DELTA_MAX = "adaptor_MenloMcpuErrorStatsHist_popErrorsDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_POP_ERRORS_DELTA_MIN = "adaptor_MenloMcpuErrorStatsHist_popErrorsDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_PUSH_ERRORS = "adaptor_MenloMcpuErrorStatsHist_pushErrors"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_PUSH_ERRORS_DELTA = "adaptor_MenloMcpuErrorStatsHist_pushErrorsDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_PUSH_ERRORS_DELTA_AVG = "adaptor_MenloMcpuErrorStatsHist_pushErrorsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_PUSH_ERRORS_DELTA_MAX = "adaptor_MenloMcpuErrorStatsHist_pushErrorsDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_PUSH_ERRORS_DELTA_MIN = "adaptor_MenloMcpuErrorStatsHist_pushErrorsDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_SUSPECT = "adaptor_MenloMcpuErrorStatsHist_suspect"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_THRESHOLDED = "adaptor_MenloMcpuErrorStatsHist_thresholded"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_TIME_COLLECTED = "adaptor_MenloMcpuErrorStatsHist_timeCollected"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_UNCORRECTABLE_ERRORS = "adaptor_MenloMcpuErrorStatsHist_uncorrectableErrors"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_UNCORRECTABLE_ERRORS_DELTA = "adaptor_MenloMcpuErrorStatsHist_uncorrectableErrorsDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_UNCORRECTABLE_ERRORS_DELTA_AVG = "adaptor_MenloMcpuErrorStatsHist_uncorrectableErrorsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_UNCORRECTABLE_ERRORS_DELTA_MAX = "adaptor_MenloMcpuErrorStatsHist_uncorrectableErrorsDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_UNCORRECTABLE_ERRORS_DELTA_MIN = "adaptor_MenloMcpuErrorStatsHist_uncorrectableErrorsDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATS_CORRECTABLE_ERRORS = "adaptor_MenloMcpuErrorStats_correctableErrors"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATS_CORRECTABLE_ERRORS_DELTA = "adaptor_MenloMcpuErrorStats_correctableErrorsDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATS_CORRECTABLE_ERRORS_DELTA_AVG = "adaptor_MenloMcpuErrorStats_correctableErrorsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATS_CORRECTABLE_ERRORS_DELTA_MAX = "adaptor_MenloMcpuErrorStats_correctableErrorsDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATS_CORRECTABLE_ERRORS_DELTA_MIN = "adaptor_MenloMcpuErrorStats_correctableErrorsDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATS_INTERVALS = "adaptor_MenloMcpuErrorStats_intervals"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATS_MENLO_MCPU_INDEX = "adaptor_MenloMcpuErrorStats_menloMcpuIndex"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATS_POP_ERRORS = "adaptor_MenloMcpuErrorStats_popErrors"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATS_POP_ERRORS_DELTA = "adaptor_MenloMcpuErrorStats_popErrorsDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATS_POP_ERRORS_DELTA_AVG = "adaptor_MenloMcpuErrorStats_popErrorsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATS_POP_ERRORS_DELTA_MAX = "adaptor_MenloMcpuErrorStats_popErrorsDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATS_POP_ERRORS_DELTA_MIN = "adaptor_MenloMcpuErrorStats_popErrorsDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATS_PUSH_ERRORS = "adaptor_MenloMcpuErrorStats_pushErrors"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATS_PUSH_ERRORS_DELTA = "adaptor_MenloMcpuErrorStats_pushErrorsDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATS_PUSH_ERRORS_DELTA_AVG = "adaptor_MenloMcpuErrorStats_pushErrorsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATS_PUSH_ERRORS_DELTA_MAX = "adaptor_MenloMcpuErrorStats_pushErrorsDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATS_PUSH_ERRORS_DELTA_MIN = "adaptor_MenloMcpuErrorStats_pushErrorsDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATS_SUSPECT = "adaptor_MenloMcpuErrorStats_suspect"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATS_THRESHOLDED = "adaptor_MenloMcpuErrorStats_thresholded"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATS_TIME_COLLECTED = "adaptor_MenloMcpuErrorStats_timeCollected"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATS_UNCORRECTABLE_ERRORS = "adaptor_MenloMcpuErrorStats_uncorrectableErrors"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATS_UNCORRECTABLE_ERRORS_DELTA = "adaptor_MenloMcpuErrorStats_uncorrectableErrorsDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATS_UNCORRECTABLE_ERRORS_DELTA_AVG = "adaptor_MenloMcpuErrorStats_uncorrectableErrorsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATS_UNCORRECTABLE_ERRORS_DELTA_MAX = "adaptor_MenloMcpuErrorStats_uncorrectableErrorsDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATS_UNCORRECTABLE_ERRORS_DELTA_MIN = "adaptor_MenloMcpuErrorStats_uncorrectableErrorsDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_ERROR_STATS_UPDATE = "adaptor_MenloMcpuErrorStats_update"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_STATS_HIST_DROP_ACL = "adaptor_MenloMcpuStatsHist_dropAcl"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_STATS_HIST_DROP_ACL_DELTA = "adaptor_MenloMcpuStatsHist_dropAclDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_STATS_HIST_DROP_ACL_DELTA_AVG = "adaptor_MenloMcpuStatsHist_dropAclDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_STATS_HIST_DROP_ACL_DELTA_MAX = "adaptor_MenloMcpuStatsHist_dropAclDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_STATS_HIST_DROP_ACL_DELTA_MIN = "adaptor_MenloMcpuStatsHist_dropAclDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_STATS_HIST_DROP_OVERRUN = "adaptor_MenloMcpuStatsHist_dropOverrun"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_STATS_HIST_DROP_OVERRUN_DELTA = "adaptor_MenloMcpuStatsHist_dropOverrunDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_STATS_HIST_DROP_OVERRUN_DELTA_AVG = "adaptor_MenloMcpuStatsHist_dropOverrunDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_STATS_HIST_DROP_OVERRUN_DELTA_MAX = "adaptor_MenloMcpuStatsHist_dropOverrunDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_STATS_HIST_DROP_OVERRUN_DELTA_MIN = "adaptor_MenloMcpuStatsHist_dropOverrunDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_STATS_HIST_DROP_RUNT = "adaptor_MenloMcpuStatsHist_dropRunt"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_STATS_HIST_DROP_RUNT_DELTA = "adaptor_MenloMcpuStatsHist_dropRuntDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_STATS_HIST_DROP_RUNT_DELTA_AVG = "adaptor_MenloMcpuStatsHist_dropRuntDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_STATS_HIST_DROP_RUNT_DELTA_MAX = "adaptor_MenloMcpuStatsHist_dropRuntDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_STATS_HIST_DROP_RUNT_DELTA_MIN = "adaptor_MenloMcpuStatsHist_dropRuntDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_STATS_HIST_ID = "adaptor_MenloMcpuStatsHist_id"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_STATS_HIST_MOST_RECENT = "adaptor_MenloMcpuStatsHist_mostRecent"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_STATS_HIST_SUSPECT = "adaptor_MenloMcpuStatsHist_suspect"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_STATS_HIST_THRESHOLDED = "adaptor_MenloMcpuStatsHist_thresholded"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_STATS_HIST_TIME_COLLECTED = "adaptor_MenloMcpuStatsHist_timeCollected"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_STATS_HIST_TRUNCATE_OVERRUN = "adaptor_MenloMcpuStatsHist_truncateOverrun"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_STATS_HIST_TRUNCATE_OVERRUN_DELTA = "adaptor_MenloMcpuStatsHist_truncateOverrunDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_STATS_HIST_TRUNCATE_OVERRUN_DELTA_AVG = "adaptor_MenloMcpuStatsHist_truncateOverrunDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_STATS_HIST_TRUNCATE_OVERRUN_DELTA_MAX = "adaptor_MenloMcpuStatsHist_truncateOverrunDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_STATS_HIST_TRUNCATE_OVERRUN_DELTA_MIN = "adaptor_MenloMcpuStatsHist_truncateOverrunDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_STATS_DROP_ACL = "adaptor_MenloMcpuStats_dropAcl"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_STATS_DROP_ACL_DELTA = "adaptor_MenloMcpuStats_dropAclDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_STATS_DROP_ACL_DELTA_AVG = "adaptor_MenloMcpuStats_dropAclDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_STATS_DROP_ACL_DELTA_MAX = "adaptor_MenloMcpuStats_dropAclDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_STATS_DROP_ACL_DELTA_MIN = "adaptor_MenloMcpuStats_dropAclDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_STATS_DROP_OVERRUN = "adaptor_MenloMcpuStats_dropOverrun"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_STATS_DROP_OVERRUN_DELTA = "adaptor_MenloMcpuStats_dropOverrunDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_STATS_DROP_OVERRUN_DELTA_AVG = "adaptor_MenloMcpuStats_dropOverrunDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_STATS_DROP_OVERRUN_DELTA_MAX = "adaptor_MenloMcpuStats_dropOverrunDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_STATS_DROP_OVERRUN_DELTA_MIN = "adaptor_MenloMcpuStats_dropOverrunDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_STATS_DROP_RUNT = "adaptor_MenloMcpuStats_dropRunt"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_STATS_DROP_RUNT_DELTA = "adaptor_MenloMcpuStats_dropRuntDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_STATS_DROP_RUNT_DELTA_AVG = "adaptor_MenloMcpuStats_dropRuntDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_STATS_DROP_RUNT_DELTA_MAX = "adaptor_MenloMcpuStats_dropRuntDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_STATS_DROP_RUNT_DELTA_MIN = "adaptor_MenloMcpuStats_dropRuntDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_STATS_INTERVALS = "adaptor_MenloMcpuStats_intervals"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_STATS_MENLO_MCPU_INDEX = "adaptor_MenloMcpuStats_menloMcpuIndex"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_STATS_SUSPECT = "adaptor_MenloMcpuStats_suspect"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_STATS_THRESHOLDED = "adaptor_MenloMcpuStats_thresholded"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_STATS_TIME_COLLECTED = "adaptor_MenloMcpuStats_timeCollected"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_STATS_TRUNCATE_OVERRUN = "adaptor_MenloMcpuStats_truncateOverrun"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_STATS_TRUNCATE_OVERRUN_DELTA = "adaptor_MenloMcpuStats_truncateOverrunDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_STATS_TRUNCATE_OVERRUN_DELTA_AVG = "adaptor_MenloMcpuStats_truncateOverrunDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_STATS_TRUNCATE_OVERRUN_DELTA_MAX = "adaptor_MenloMcpuStats_truncateOverrunDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_STATS_TRUNCATE_OVERRUN_DELTA_MIN = "adaptor_MenloMcpuStats_truncateOverrunDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_MCPU_STATS_UPDATE = "adaptor_MenloMcpuStats_update"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATS_HIST_DROP_CMD = "adaptor_MenloNetEgStatsHist_dropCmd"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATS_HIST_DROP_CMD_DELTA = "adaptor_MenloNetEgStatsHist_dropCmdDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATS_HIST_DROP_CMD_DELTA_AVG = "adaptor_MenloNetEgStatsHist_dropCmdDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATS_HIST_DROP_CMD_DELTA_MAX = "adaptor_MenloNetEgStatsHist_dropCmdDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATS_HIST_DROP_CMD_DELTA_MIN = "adaptor_MenloNetEgStatsHist_dropCmdDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATS_HIST_DROP_LIF_CFG_INVALID = "adaptor_MenloNetEgStatsHist_dropLifCfgInvalid"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATS_HIST_DROP_LIF_CFG_INVALID_DELTA = "adaptor_MenloNetEgStatsHist_dropLifCfgInvalidDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATS_HIST_DROP_LIF_CFG_INVALID_DELTA_AVG = "adaptor_MenloNetEgStatsHist_dropLifCfgInvalidDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATS_HIST_DROP_LIF_CFG_INVALID_DELTA_MAX = "adaptor_MenloNetEgStatsHist_dropLifCfgInvalidDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATS_HIST_DROP_LIF_CFG_INVALID_DELTA_MIN = "adaptor_MenloNetEgStatsHist_dropLifCfgInvalidDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATS_HIST_DROP_LIF_MAP_NO_HIT = "adaptor_MenloNetEgStatsHist_dropLifMapNoHit"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATS_HIST_DROP_LIF_MAP_NO_HIT_DELTA = "adaptor_MenloNetEgStatsHist_dropLifMapNoHitDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATS_HIST_DROP_LIF_MAP_NO_HIT_DELTA_AVG = "adaptor_MenloNetEgStatsHist_dropLifMapNoHitDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATS_HIST_DROP_LIF_MAP_NO_HIT_DELTA_MAX = "adaptor_MenloNetEgStatsHist_dropLifMapNoHitDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATS_HIST_DROP_LIF_MAP_NO_HIT_DELTA_MIN = "adaptor_MenloNetEgStatsHist_dropLifMapNoHitDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATS_HIST_DROP_SRC_BIND = "adaptor_MenloNetEgStatsHist_dropSrcBind"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATS_HIST_DROP_SRC_BIND_DELTA = "adaptor_MenloNetEgStatsHist_dropSrcBindDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATS_HIST_DROP_SRC_BIND_DELTA_AVG = "adaptor_MenloNetEgStatsHist_dropSrcBindDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATS_HIST_DROP_SRC_BIND_DELTA_MAX = "adaptor_MenloNetEgStatsHist_dropSrcBindDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATS_HIST_DROP_SRC_BIND_DELTA_MIN = "adaptor_MenloNetEgStatsHist_dropSrcBindDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATS_HIST_ID = "adaptor_MenloNetEgStatsHist_id"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATS_HIST_LEARN_REQ_DROP = "adaptor_MenloNetEgStatsHist_learnReqDrop"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATS_HIST_LEARN_REQ_DROP_DELTA = "adaptor_MenloNetEgStatsHist_learnReqDropDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATS_HIST_LEARN_REQ_DROP_DELTA_AVG = "adaptor_MenloNetEgStatsHist_learnReqDropDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATS_HIST_LEARN_REQ_DROP_DELTA_MAX = "adaptor_MenloNetEgStatsHist_learnReqDropDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATS_HIST_LEARN_REQ_DROP_DELTA_MIN = "adaptor_MenloNetEgStatsHist_learnReqDropDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATS_HIST_MOST_RECENT = "adaptor_MenloNetEgStatsHist_mostRecent"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATS_HIST_SUSPECT = "adaptor_MenloNetEgStatsHist_suspect"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATS_HIST_THRESHOLDED = "adaptor_MenloNetEgStatsHist_thresholded"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATS_HIST_TIME_COLLECTED = "adaptor_MenloNetEgStatsHist_timeCollected"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATS_DROP_CMD = "adaptor_MenloNetEgStats_dropCmd"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATS_DROP_CMD_DELTA = "adaptor_MenloNetEgStats_dropCmdDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATS_DROP_CMD_DELTA_AVG = "adaptor_MenloNetEgStats_dropCmdDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATS_DROP_CMD_DELTA_MAX = "adaptor_MenloNetEgStats_dropCmdDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATS_DROP_CMD_DELTA_MIN = "adaptor_MenloNetEgStats_dropCmdDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATS_DROP_LIF_CFG_INVALID = "adaptor_MenloNetEgStats_dropLifCfgInvalid"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATS_DROP_LIF_CFG_INVALID_DELTA = "adaptor_MenloNetEgStats_dropLifCfgInvalidDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATS_DROP_LIF_CFG_INVALID_DELTA_AVG = "adaptor_MenloNetEgStats_dropLifCfgInvalidDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATS_DROP_LIF_CFG_INVALID_DELTA_MAX = "adaptor_MenloNetEgStats_dropLifCfgInvalidDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATS_DROP_LIF_CFG_INVALID_DELTA_MIN = "adaptor_MenloNetEgStats_dropLifCfgInvalidDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATS_DROP_LIF_MAP_NO_HIT = "adaptor_MenloNetEgStats_dropLifMapNoHit"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATS_DROP_LIF_MAP_NO_HIT_DELTA = "adaptor_MenloNetEgStats_dropLifMapNoHitDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATS_DROP_LIF_MAP_NO_HIT_DELTA_AVG = "adaptor_MenloNetEgStats_dropLifMapNoHitDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATS_DROP_LIF_MAP_NO_HIT_DELTA_MAX = "adaptor_MenloNetEgStats_dropLifMapNoHitDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATS_DROP_LIF_MAP_NO_HIT_DELTA_MIN = "adaptor_MenloNetEgStats_dropLifMapNoHitDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATS_DROP_SRC_BIND = "adaptor_MenloNetEgStats_dropSrcBind"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATS_DROP_SRC_BIND_DELTA = "adaptor_MenloNetEgStats_dropSrcBindDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATS_DROP_SRC_BIND_DELTA_AVG = "adaptor_MenloNetEgStats_dropSrcBindDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATS_DROP_SRC_BIND_DELTA_MAX = "adaptor_MenloNetEgStats_dropSrcBindDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATS_DROP_SRC_BIND_DELTA_MIN = "adaptor_MenloNetEgStats_dropSrcBindDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATS_INTERVALS = "adaptor_MenloNetEgStats_intervals"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATS_LEARN_REQ_DROP = "adaptor_MenloNetEgStats_learnReqDrop"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATS_LEARN_REQ_DROP_DELTA = "adaptor_MenloNetEgStats_learnReqDropDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATS_LEARN_REQ_DROP_DELTA_AVG = "adaptor_MenloNetEgStats_learnReqDropDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATS_LEARN_REQ_DROP_DELTA_MAX = "adaptor_MenloNetEgStats_learnReqDropDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATS_LEARN_REQ_DROP_DELTA_MIN = "adaptor_MenloNetEgStats_learnReqDropDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATS_MENLO_NET_INDEX = "adaptor_MenloNetEgStats_menloNetIndex"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATS_SUSPECT = "adaptor_MenloNetEgStats_suspect"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATS_THRESHOLDED = "adaptor_MenloNetEgStats_thresholded"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATS_TIME_COLLECTED = "adaptor_MenloNetEgStats_timeCollected"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_EG_STATS_UPDATE = "adaptor_MenloNetEgStats_update"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_IN_STATS_HIST_DROP_FC_LIF_INVALID = "adaptor_MenloNetInStatsHist_dropFcLifInvalid"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_IN_STATS_HIST_DROP_FC_LIF_INVALID_DELTA = "adaptor_MenloNetInStatsHist_dropFcLifInvalidDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_IN_STATS_HIST_DROP_FC_LIF_INVALID_DELTA_AVG = "adaptor_MenloNetInStatsHist_dropFcLifInvalidDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_IN_STATS_HIST_DROP_FC_LIF_INVALID_DELTA_MAX = "adaptor_MenloNetInStatsHist_dropFcLifInvalidDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_IN_STATS_HIST_DROP_FC_LIF_INVALID_DELTA_MIN = "adaptor_MenloNetInStatsHist_dropFcLifInvalidDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_IN_STATS_HIST_DROP_FC_MULTICAST = "adaptor_MenloNetInStatsHist_dropFcMulticast"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_IN_STATS_HIST_DROP_FC_MULTICAST_DELTA = "adaptor_MenloNetInStatsHist_dropFcMulticastDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_IN_STATS_HIST_DROP_FC_MULTICAST_DELTA_AVG = "adaptor_MenloNetInStatsHist_dropFcMulticastDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_IN_STATS_HIST_DROP_FC_MULTICAST_DELTA_MAX = "adaptor_MenloNetInStatsHist_dropFcMulticastDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_IN_STATS_HIST_DROP_FC_MULTICAST_DELTA_MIN = "adaptor_MenloNetInStatsHist_dropFcMulticastDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_IN_STATS_HIST_DROP_NULL_PIF = "adaptor_MenloNetInStatsHist_dropNullPif"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_IN_STATS_HIST_DROP_NULL_PIF_DELTA = "adaptor_MenloNetInStatsHist_dropNullPifDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_IN_STATS_HIST_DROP_NULL_PIF_DELTA_AVG = "adaptor_MenloNetInStatsHist_dropNullPifDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_IN_STATS_HIST_DROP_NULL_PIF_DELTA_MAX = "adaptor_MenloNetInStatsHist_dropNullPifDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_IN_STATS_HIST_DROP_NULL_PIF_DELTA_MIN = "adaptor_MenloNetInStatsHist_dropNullPifDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_IN_STATS_HIST_FWD_LOOKUP_NO_HIT = "adaptor_MenloNetInStatsHist_fwdLookupNoHit"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_IN_STATS_HIST_FWD_LOOKUP_NO_HIT_DELTA = "adaptor_MenloNetInStatsHist_fwdLookupNoHitDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_IN_STATS_HIST_FWD_LOOKUP_NO_HIT_DELTA_AVG = "adaptor_MenloNetInStatsHist_fwdLookupNoHitDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_IN_STATS_HIST_FWD_LOOKUP_NO_HIT_DELTA_MAX = "adaptor_MenloNetInStatsHist_fwdLookupNoHitDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_IN_STATS_HIST_FWD_LOOKUP_NO_HIT_DELTA_MIN = "adaptor_MenloNetInStatsHist_fwdLookupNoHitDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_IN_STATS_HIST_ID = "adaptor_MenloNetInStatsHist_id"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_IN_STATS_HIST_MOST_RECENT = "adaptor_MenloNetInStatsHist_mostRecent"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_IN_STATS_HIST_SUSPECT = "adaptor_MenloNetInStatsHist_suspect"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_IN_STATS_HIST_THRESHOLDED = "adaptor_MenloNetInStatsHist_thresholded"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_IN_STATS_HIST_TIME_COLLECTED = "adaptor_MenloNetInStatsHist_timeCollected"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_IN_STATS_DROP_FC_LIF_INVALID = "adaptor_MenloNetInStats_dropFcLifInvalid"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_IN_STATS_DROP_FC_LIF_INVALID_DELTA = "adaptor_MenloNetInStats_dropFcLifInvalidDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_IN_STATS_DROP_FC_LIF_INVALID_DELTA_AVG = "adaptor_MenloNetInStats_dropFcLifInvalidDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_IN_STATS_DROP_FC_LIF_INVALID_DELTA_MAX = "adaptor_MenloNetInStats_dropFcLifInvalidDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_IN_STATS_DROP_FC_LIF_INVALID_DELTA_MIN = "adaptor_MenloNetInStats_dropFcLifInvalidDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_IN_STATS_DROP_FC_MULTICAST = "adaptor_MenloNetInStats_dropFcMulticast"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_IN_STATS_DROP_FC_MULTICAST_DELTA = "adaptor_MenloNetInStats_dropFcMulticastDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_IN_STATS_DROP_FC_MULTICAST_DELTA_AVG = "adaptor_MenloNetInStats_dropFcMulticastDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_IN_STATS_DROP_FC_MULTICAST_DELTA_MAX = "adaptor_MenloNetInStats_dropFcMulticastDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_IN_STATS_DROP_FC_MULTICAST_DELTA_MIN = "adaptor_MenloNetInStats_dropFcMulticastDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_IN_STATS_DROP_NULL_PIF = "adaptor_MenloNetInStats_dropNullPif"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_IN_STATS_DROP_NULL_PIF_DELTA = "adaptor_MenloNetInStats_dropNullPifDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_IN_STATS_DROP_NULL_PIF_DELTA_AVG = "adaptor_MenloNetInStats_dropNullPifDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_IN_STATS_DROP_NULL_PIF_DELTA_MAX = "adaptor_MenloNetInStats_dropNullPifDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_IN_STATS_DROP_NULL_PIF_DELTA_MIN = "adaptor_MenloNetInStats_dropNullPifDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_IN_STATS_FWD_LOOKUP_NO_HIT = "adaptor_MenloNetInStats_fwdLookupNoHit"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_IN_STATS_FWD_LOOKUP_NO_HIT_DELTA = "adaptor_MenloNetInStats_fwdLookupNoHitDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_IN_STATS_FWD_LOOKUP_NO_HIT_DELTA_AVG = "adaptor_MenloNetInStats_fwdLookupNoHitDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_IN_STATS_FWD_LOOKUP_NO_HIT_DELTA_MAX = "adaptor_MenloNetInStats_fwdLookupNoHitDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_IN_STATS_FWD_LOOKUP_NO_HIT_DELTA_MIN = "adaptor_MenloNetInStats_fwdLookupNoHitDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_IN_STATS_INTERVALS = "adaptor_MenloNetInStats_intervals"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_IN_STATS_MENLO_NET_INDEX = "adaptor_MenloNetInStats_menloNetIndex"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_IN_STATS_SUSPECT = "adaptor_MenloNetInStats_suspect"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_IN_STATS_THRESHOLDED = "adaptor_MenloNetInStats_thresholded"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_IN_STATS_TIME_COLLECTED = "adaptor_MenloNetInStats_timeCollected"
	CONST_PROP_ID_ADAPTOR_MENLO_NET_IN_STATS_UPDATE = "adaptor_MenloNetInStats_update"
	CONST_PROP_ID_ADAPTOR_MENLO_QERROR_STATS_HIST_CORRECTABLE_ERRORS = "adaptor_MenloQErrorStatsHist_correctableErrors"
	CONST_PROP_ID_ADAPTOR_MENLO_QERROR_STATS_HIST_CORRECTABLE_ERRORS_DELTA = "adaptor_MenloQErrorStatsHist_correctableErrorsDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_QERROR_STATS_HIST_CORRECTABLE_ERRORS_DELTA_AVG = "adaptor_MenloQErrorStatsHist_correctableErrorsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_QERROR_STATS_HIST_CORRECTABLE_ERRORS_DELTA_MAX = "adaptor_MenloQErrorStatsHist_correctableErrorsDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_QERROR_STATS_HIST_CORRECTABLE_ERRORS_DELTA_MIN = "adaptor_MenloQErrorStatsHist_correctableErrorsDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_QERROR_STATS_HIST_ID = "adaptor_MenloQErrorStatsHist_id"
	CONST_PROP_ID_ADAPTOR_MENLO_QERROR_STATS_HIST_MOST_RECENT = "adaptor_MenloQErrorStatsHist_mostRecent"
	CONST_PROP_ID_ADAPTOR_MENLO_QERROR_STATS_HIST_POP_ERRORS = "adaptor_MenloQErrorStatsHist_popErrors"
	CONST_PROP_ID_ADAPTOR_MENLO_QERROR_STATS_HIST_POP_ERRORS_DELTA = "adaptor_MenloQErrorStatsHist_popErrorsDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_QERROR_STATS_HIST_POP_ERRORS_DELTA_AVG = "adaptor_MenloQErrorStatsHist_popErrorsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_QERROR_STATS_HIST_POP_ERRORS_DELTA_MAX = "adaptor_MenloQErrorStatsHist_popErrorsDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_QERROR_STATS_HIST_POP_ERRORS_DELTA_MIN = "adaptor_MenloQErrorStatsHist_popErrorsDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_QERROR_STATS_HIST_PUSH_ERRORS = "adaptor_MenloQErrorStatsHist_pushErrors"
	CONST_PROP_ID_ADAPTOR_MENLO_QERROR_STATS_HIST_PUSH_ERRORS_DELTA = "adaptor_MenloQErrorStatsHist_pushErrorsDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_QERROR_STATS_HIST_PUSH_ERRORS_DELTA_AVG = "adaptor_MenloQErrorStatsHist_pushErrorsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_QERROR_STATS_HIST_PUSH_ERRORS_DELTA_MAX = "adaptor_MenloQErrorStatsHist_pushErrorsDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_QERROR_STATS_HIST_PUSH_ERRORS_DELTA_MIN = "adaptor_MenloQErrorStatsHist_pushErrorsDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_QERROR_STATS_HIST_SUSPECT = "adaptor_MenloQErrorStatsHist_suspect"
	CONST_PROP_ID_ADAPTOR_MENLO_QERROR_STATS_HIST_THRESHOLDED = "adaptor_MenloQErrorStatsHist_thresholded"
	CONST_PROP_ID_ADAPTOR_MENLO_QERROR_STATS_HIST_TIME_COLLECTED = "adaptor_MenloQErrorStatsHist_timeCollected"
	CONST_PROP_ID_ADAPTOR_MENLO_QERROR_STATS_HIST_UNCORRECTABLE_ERRORS = "adaptor_MenloQErrorStatsHist_uncorrectableErrors"
	CONST_PROP_ID_ADAPTOR_MENLO_QERROR_STATS_HIST_UNCORRECTABLE_ERRORS_DELTA = "adaptor_MenloQErrorStatsHist_uncorrectableErrorsDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_QERROR_STATS_HIST_UNCORRECTABLE_ERRORS_DELTA_AVG = "adaptor_MenloQErrorStatsHist_uncorrectableErrorsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_QERROR_STATS_HIST_UNCORRECTABLE_ERRORS_DELTA_MAX = "adaptor_MenloQErrorStatsHist_uncorrectableErrorsDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_QERROR_STATS_HIST_UNCORRECTABLE_ERRORS_DELTA_MIN = "adaptor_MenloQErrorStatsHist_uncorrectableErrorsDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_QERROR_STATS_CORRECTABLE_ERRORS = "adaptor_MenloQErrorStats_correctableErrors"
	CONST_PROP_ID_ADAPTOR_MENLO_QERROR_STATS_CORRECTABLE_ERRORS_DELTA = "adaptor_MenloQErrorStats_correctableErrorsDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_QERROR_STATS_CORRECTABLE_ERRORS_DELTA_AVG = "adaptor_MenloQErrorStats_correctableErrorsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_QERROR_STATS_CORRECTABLE_ERRORS_DELTA_MAX = "adaptor_MenloQErrorStats_correctableErrorsDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_QERROR_STATS_CORRECTABLE_ERRORS_DELTA_MIN = "adaptor_MenloQErrorStats_correctableErrorsDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_QERROR_STATS_INTERVALS = "adaptor_MenloQErrorStats_intervals"
	CONST_PROP_ID_ADAPTOR_MENLO_QERROR_STATS_MENLO_QUEUE_COMPONENT = "adaptor_MenloQErrorStats_menloQueueComponent"
	CONST_PROP_ID_ADAPTOR_MENLO_QERROR_STATS_MENLO_QUEUE_INDEX = "adaptor_MenloQErrorStats_menloQueueIndex"
	CONST_PROP_ID_ADAPTOR_MENLO_QERROR_STATS_POP_ERRORS = "adaptor_MenloQErrorStats_popErrors"
	CONST_PROP_ID_ADAPTOR_MENLO_QERROR_STATS_POP_ERRORS_DELTA = "adaptor_MenloQErrorStats_popErrorsDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_QERROR_STATS_POP_ERRORS_DELTA_AVG = "adaptor_MenloQErrorStats_popErrorsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_QERROR_STATS_POP_ERRORS_DELTA_MAX = "adaptor_MenloQErrorStats_popErrorsDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_QERROR_STATS_POP_ERRORS_DELTA_MIN = "adaptor_MenloQErrorStats_popErrorsDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_QERROR_STATS_PUSH_ERRORS = "adaptor_MenloQErrorStats_pushErrors"
	CONST_PROP_ID_ADAPTOR_MENLO_QERROR_STATS_PUSH_ERRORS_DELTA = "adaptor_MenloQErrorStats_pushErrorsDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_QERROR_STATS_PUSH_ERRORS_DELTA_AVG = "adaptor_MenloQErrorStats_pushErrorsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_QERROR_STATS_PUSH_ERRORS_DELTA_MAX = "adaptor_MenloQErrorStats_pushErrorsDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_QERROR_STATS_PUSH_ERRORS_DELTA_MIN = "adaptor_MenloQErrorStats_pushErrorsDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_QERROR_STATS_SUSPECT = "adaptor_MenloQErrorStats_suspect"
	CONST_PROP_ID_ADAPTOR_MENLO_QERROR_STATS_THRESHOLDED = "adaptor_MenloQErrorStats_thresholded"
	CONST_PROP_ID_ADAPTOR_MENLO_QERROR_STATS_TIME_COLLECTED = "adaptor_MenloQErrorStats_timeCollected"
	CONST_PROP_ID_ADAPTOR_MENLO_QERROR_STATS_UNCORRECTABLE_ERRORS = "adaptor_MenloQErrorStats_uncorrectableErrors"
	CONST_PROP_ID_ADAPTOR_MENLO_QERROR_STATS_UNCORRECTABLE_ERRORS_DELTA = "adaptor_MenloQErrorStats_uncorrectableErrorsDelta"
	CONST_PROP_ID_ADAPTOR_MENLO_QERROR_STATS_UNCORRECTABLE_ERRORS_DELTA_AVG = "adaptor_MenloQErrorStats_uncorrectableErrorsDeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_QERROR_STATS_UNCORRECTABLE_ERRORS_DELTA_MAX = "adaptor_MenloQErrorStats_uncorrectableErrorsDeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_QERROR_STATS_UNCORRECTABLE_ERRORS_DELTA_MIN = "adaptor_MenloQErrorStats_uncorrectableErrorsDeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_QERROR_STATS_UPDATE = "adaptor_MenloQErrorStats_update"
	CONST_PROP_ID_ADAPTOR_MENLO_QSTATS_HIST_DROP_OVERRUN_N0 = "adaptor_MenloQStatsHist_dropOverrunN0"
	CONST_PROP_ID_ADAPTOR_MENLO_QSTATS_HIST_DROP_OVERRUN_N0_DELTA = "adaptor_MenloQStatsHist_dropOverrunN0Delta"
	CONST_PROP_ID_ADAPTOR_MENLO_QSTATS_HIST_DROP_OVERRUN_N0_DELTA_AVG = "adaptor_MenloQStatsHist_dropOverrunN0DeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_QSTATS_HIST_DROP_OVERRUN_N0_DELTA_MAX = "adaptor_MenloQStatsHist_dropOverrunN0DeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_QSTATS_HIST_DROP_OVERRUN_N0_DELTA_MIN = "adaptor_MenloQStatsHist_dropOverrunN0DeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_QSTATS_HIST_DROP_OVERRUN_N1 = "adaptor_MenloQStatsHist_dropOverrunN1"
	CONST_PROP_ID_ADAPTOR_MENLO_QSTATS_HIST_DROP_OVERRUN_N1_DELTA = "adaptor_MenloQStatsHist_dropOverrunN1Delta"
	CONST_PROP_ID_ADAPTOR_MENLO_QSTATS_HIST_DROP_OVERRUN_N1_DELTA_AVG = "adaptor_MenloQStatsHist_dropOverrunN1DeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_QSTATS_HIST_DROP_OVERRUN_N1_DELTA_MAX = "adaptor_MenloQStatsHist_dropOverrunN1DeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_QSTATS_HIST_DROP_OVERRUN_N1_DELTA_MIN = "adaptor_MenloQStatsHist_dropOverrunN1DeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_QSTATS_HIST_ID = "adaptor_MenloQStatsHist_id"
	CONST_PROP_ID_ADAPTOR_MENLO_QSTATS_HIST_MOST_RECENT = "adaptor_MenloQStatsHist_mostRecent"
	CONST_PROP_ID_ADAPTOR_MENLO_QSTATS_HIST_SUSPECT = "adaptor_MenloQStatsHist_suspect"
	CONST_PROP_ID_ADAPTOR_MENLO_QSTATS_HIST_THRESHOLDED = "adaptor_MenloQStatsHist_thresholded"
	CONST_PROP_ID_ADAPTOR_MENLO_QSTATS_HIST_TIME_COLLECTED = "adaptor_MenloQStatsHist_timeCollected"
	CONST_PROP_ID_ADAPTOR_MENLO_QSTATS_HIST_TRUNCATE_OVERRUN_N0 = "adaptor_MenloQStatsHist_truncateOverrunN0"
	CONST_PROP_ID_ADAPTOR_MENLO_QSTATS_HIST_TRUNCATE_OVERRUN_N0_DELTA = "adaptor_MenloQStatsHist_truncateOverrunN0Delta"
	CONST_PROP_ID_ADAPTOR_MENLO_QSTATS_HIST_TRUNCATE_OVERRUN_N0_DELTA_AVG = "adaptor_MenloQStatsHist_truncateOverrunN0DeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_QSTATS_HIST_TRUNCATE_OVERRUN_N0_DELTA_MAX = "adaptor_MenloQStatsHist_truncateOverrunN0DeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_QSTATS_HIST_TRUNCATE_OVERRUN_N0_DELTA_MIN = "adaptor_MenloQStatsHist_truncateOverrunN0DeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_QSTATS_HIST_TRUNCATE_OVERRUN_N1 = "adaptor_MenloQStatsHist_truncateOverrunN1"
	CONST_PROP_ID_ADAPTOR_MENLO_QSTATS_HIST_TRUNCATE_OVERRUN_N1_DELTA = "adaptor_MenloQStatsHist_truncateOverrunN1Delta"
	CONST_PROP_ID_ADAPTOR_MENLO_QSTATS_HIST_TRUNCATE_OVERRUN_N1_DELTA_AVG = "adaptor_MenloQStatsHist_truncateOverrunN1DeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_QSTATS_HIST_TRUNCATE_OVERRUN_N1_DELTA_MAX = "adaptor_MenloQStatsHist_truncateOverrunN1DeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_QSTATS_HIST_TRUNCATE_OVERRUN_N1_DELTA_MIN = "adaptor_MenloQStatsHist_truncateOverrunN1DeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_QSTATS_DROP_OVERRUN_N0 = "adaptor_MenloQStats_dropOverrunN0"
	CONST_PROP_ID_ADAPTOR_MENLO_QSTATS_DROP_OVERRUN_N0_DELTA = "adaptor_MenloQStats_dropOverrunN0Delta"
	CONST_PROP_ID_ADAPTOR_MENLO_QSTATS_DROP_OVERRUN_N0_DELTA_AVG = "adaptor_MenloQStats_dropOverrunN0DeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_QSTATS_DROP_OVERRUN_N0_DELTA_MAX = "adaptor_MenloQStats_dropOverrunN0DeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_QSTATS_DROP_OVERRUN_N0_DELTA_MIN = "adaptor_MenloQStats_dropOverrunN0DeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_QSTATS_DROP_OVERRUN_N1 = "adaptor_MenloQStats_dropOverrunN1"
	CONST_PROP_ID_ADAPTOR_MENLO_QSTATS_DROP_OVERRUN_N1_DELTA = "adaptor_MenloQStats_dropOverrunN1Delta"
	CONST_PROP_ID_ADAPTOR_MENLO_QSTATS_DROP_OVERRUN_N1_DELTA_AVG = "adaptor_MenloQStats_dropOverrunN1DeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_QSTATS_DROP_OVERRUN_N1_DELTA_MAX = "adaptor_MenloQStats_dropOverrunN1DeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_QSTATS_DROP_OVERRUN_N1_DELTA_MIN = "adaptor_MenloQStats_dropOverrunN1DeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_QSTATS_INTERVALS = "adaptor_MenloQStats_intervals"
	CONST_PROP_ID_ADAPTOR_MENLO_QSTATS_MENLO_QUEUE_COMPONENT = "adaptor_MenloQStats_menloQueueComponent"
	CONST_PROP_ID_ADAPTOR_MENLO_QSTATS_MENLO_QUEUE_INDEX = "adaptor_MenloQStats_menloQueueIndex"
	CONST_PROP_ID_ADAPTOR_MENLO_QSTATS_SUSPECT = "adaptor_MenloQStats_suspect"
	CONST_PROP_ID_ADAPTOR_MENLO_QSTATS_THRESHOLDED = "adaptor_MenloQStats_thresholded"
	CONST_PROP_ID_ADAPTOR_MENLO_QSTATS_TIME_COLLECTED = "adaptor_MenloQStats_timeCollected"
	CONST_PROP_ID_ADAPTOR_MENLO_QSTATS_TRUNCATE_OVERRUN_N0 = "adaptor_MenloQStats_truncateOverrunN0"
	CONST_PROP_ID_ADAPTOR_MENLO_QSTATS_TRUNCATE_OVERRUN_N0_DELTA = "adaptor_MenloQStats_truncateOverrunN0Delta"
	CONST_PROP_ID_ADAPTOR_MENLO_QSTATS_TRUNCATE_OVERRUN_N0_DELTA_AVG = "adaptor_MenloQStats_truncateOverrunN0DeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_QSTATS_TRUNCATE_OVERRUN_N0_DELTA_MAX = "adaptor_MenloQStats_truncateOverrunN0DeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_QSTATS_TRUNCATE_OVERRUN_N0_DELTA_MIN = "adaptor_MenloQStats_truncateOverrunN0DeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_QSTATS_TRUNCATE_OVERRUN_N1 = "adaptor_MenloQStats_truncateOverrunN1"
	CONST_PROP_ID_ADAPTOR_MENLO_QSTATS_TRUNCATE_OVERRUN_N1_DELTA = "adaptor_MenloQStats_truncateOverrunN1Delta"
	CONST_PROP_ID_ADAPTOR_MENLO_QSTATS_TRUNCATE_OVERRUN_N1_DELTA_AVG = "adaptor_MenloQStats_truncateOverrunN1DeltaAvg"
	CONST_PROP_ID_ADAPTOR_MENLO_QSTATS_TRUNCATE_OVERRUN_N1_DELTA_MAX = "adaptor_MenloQStats_truncateOverrunN1DeltaMax"
	CONST_PROP_ID_ADAPTOR_MENLO_QSTATS_TRUNCATE_OVERRUN_N1_DELTA_MIN = "adaptor_MenloQStats_truncateOverrunN1DeltaMin"
	CONST_PROP_ID_ADAPTOR_MENLO_QSTATS_UPDATE = "adaptor_MenloQStats_update"
	CONST_PROP_ID_ADAPTOR_MGMT_CAP_MODE = "adaptor_MgmtCap_mode"
	CONST_PROP_ID_ADAPTOR_MGMT_CAP_OPER_POWER_REQUIREMENT = "adaptor_MgmtCap_operPowerRequirement"
	CONST_PROP_ID_ADAPTOR_MGMT_CAP_REBOOT_ACTION_ON_DESTRUCTIVE = "adaptor_MgmtCap_rebootActionOnDestructive"
	CONST_PROP_ID_ADAPTOR_NW_MGMT_CAP_API = "adaptor_NwMgmtCap_api"
	CONST_PROP_ID_ADAPTOR_NW_MGMT_CAP_MGMT_TRANSPORT = "adaptor_NwMgmtCap_mgmtTransport"
	CONST_PROP_ID_ADAPTOR_NW_MGMT_CAP_MODE = "adaptor_NwMgmtCap_mode"
	CONST_PROP_ID_ADAPTOR_NW_MGMT_CAP_OPER_POWER_REQUIREMENT = "adaptor_NwMgmtCap_operPowerRequirement"
	CONST_PROP_ID_ADAPTOR_NW_MGMT_CAP_REBOOT_ACTION_ON_DESTRUCTIVE = "adaptor_NwMgmtCap_rebootActionOnDestructive"
	CONST_PROP_ID_ADAPTOR_PIO_EP_CHASSIS_ID = "adaptor_PIoEp_chassisId"
	CONST_PROP_ID_ADAPTOR_PIO_EP_EP_DN = "adaptor_PIoEp_epDn"
	CONST_PROP_ID_ADAPTOR_PIO_EP_IF_ROLE = "adaptor_PIoEp_ifRole"
	CONST_PROP_ID_ADAPTOR_PIO_EP_IF_TYPE = "adaptor_PIoEp_ifType"
	CONST_PROP_ID_ADAPTOR_PIO_EP_LOCALE = "adaptor_PIoEp_locale"
	CONST_PROP_ID_ADAPTOR_PIO_EP_NAME = "adaptor_PIoEp_name"
	CONST_PROP_ID_ADAPTOR_PIO_EP_PEER_CHASSIS_ID = "adaptor_PIoEp_peerChassisId"
	CONST_PROP_ID_ADAPTOR_PIO_EP_PEER_DN = "adaptor_PIoEp_peerDn"
	CONST_PROP_ID_ADAPTOR_PIO_EP_PEER_PORT_ID = "adaptor_PIoEp_peerPortId"
	CONST_PROP_ID_ADAPTOR_PIO_EP_PEER_SLOT_ID = "adaptor_PIoEp_peerSlotId"
	CONST_PROP_ID_ADAPTOR_PIO_EP_PORT_ID = "adaptor_PIoEp_portId"
	CONST_PROP_ID_ADAPTOR_PIO_EP_SLOT_ID = "adaptor_PIoEp_slotId"
	CONST_PROP_ID_ADAPTOR_PIO_EP_SWITCH_ID = "adaptor_PIoEp_switchId"
	CONST_PROP_ID_ADAPTOR_PIO_EP_TRANSPORT = "adaptor_PIoEp_transport"
	CONST_PROP_ID_ADAPTOR_PIO_EP_TYPE = "adaptor_PIoEp_type"
	CONST_PROP_ID_ADAPTOR_PROTOCOL_PROFILE_BOOT_TO_TARGET = "adaptor_ProtocolProfile_bootToTarget"
	CONST_PROP_ID_ADAPTOR_PROTOCOL_PROFILE_CONNECTION_TIME_OUT = "adaptor_ProtocolProfile_connectionTimeOut"
	CONST_PROP_ID_ADAPTOR_PROTOCOL_PROFILE_DHCP_TIME_OUT = "adaptor_ProtocolProfile_dhcpTimeOut"
	CONST_PROP_ID_ADAPTOR_PROTOCOL_PROFILE_HBA_MODE = "adaptor_ProtocolProfile_hbaMode"
	CONST_PROP_ID_ADAPTOR_PROTOCOL_PROFILE_LUN_BUSY_RETRY_COUNT = "adaptor_ProtocolProfile_lunBusyRetryCount"
	CONST_PROP_ID_ADAPTOR_PROTOCOL_PROFILE_TCP_TIME_STAMP = "adaptor_ProtocolProfile_tcpTimeStamp"
	CONST_PROP_ID_ADAPTOR_QUEUE_PROFILE_COUNT = "adaptor_QueueProfile_count"
	CONST_PROP_ID_ADAPTOR_QUEUE_PROFILE_RING_SIZE = "adaptor_QueueProfile_ringSize"
	CONST_PROP_ID_ADAPTOR_RSS_PROFILE_RECEIVE_SIDE_SCALING = "adaptor_RssProfile_receiveSideScaling"
	CONST_PROP_ID_ADAPTOR_SAN_CAP_HOST_NVRAM = "adaptor_SanCap_hostNvram"
	CONST_PROP_ID_ADAPTOR_TCP_IP_RSS_HASH_PROFILE_IP_HASH = "adaptor_TcpIpRssHashProfile_ipHash"
	CONST_PROP_ID_ADAPTOR_TCP_IP_RSS_HASH_PROFILE_TCP_HASH = "adaptor_TcpIpRssHashProfile_tcpHash"
	CONST_PROP_ID_ADAPTOR_UNIT_ASSOC_CTX_FRU_CAP_DN = "adaptor_UnitAssocCtx_fruCapDn"
	CONST_PROP_ID_ADAPTOR_UNIT_ASSOC_CTX_ID = "adaptor_UnitAssocCtx_id"
	CONST_PROP_ID_ADAPTOR_UNIT_ASSOC_CTX_PCI_ADDR = "adaptor_UnitAssocCtx_pciAddr"
	CONST_PROP_ID_ADAPTOR_UNIT_EXTN_ADAPTOR_ID = "adaptor_UnitExtn_adaptorId"
	CONST_PROP_ID_ADAPTOR_UNIT_EXTN_BLADE_ID = "adaptor_UnitExtn_bladeId"
	CONST_PROP_ID_ADAPTOR_UNIT_EXTN_CHASSIS_ID = "adaptor_UnitExtn_chassisId"
	CONST_PROP_ID_ADAPTOR_UNIT_EXTN_ID = "adaptor_UnitExtn_id"
	CONST_PROP_ID_ADAPTOR_UNIT_EXTN_MODEL = "adaptor_UnitExtn_model"
	CONST_PROP_ID_ADAPTOR_UNIT_EXTN_OPER_QUALIFIER_REASON = "adaptor_UnitExtn_operQualifierReason"
	CONST_PROP_ID_ADAPTOR_UNIT_EXTN_OPER_STATE = "adaptor_UnitExtn_operState"
	CONST_PROP_ID_ADAPTOR_UNIT_EXTN_OPERABILITY = "adaptor_UnitExtn_operability"
	CONST_PROP_ID_ADAPTOR_UNIT_EXTN_PART_NUMBER = "adaptor_UnitExtn_partNumber"
	CONST_PROP_ID_ADAPTOR_UNIT_EXTN_PERF = "adaptor_UnitExtn_perf"
	CONST_PROP_ID_ADAPTOR_UNIT_EXTN_POWER = "adaptor_UnitExtn_power"
	CONST_PROP_ID_ADAPTOR_UNIT_EXTN_PRESENCE = "adaptor_UnitExtn_presence"
	CONST_PROP_ID_ADAPTOR_UNIT_EXTN_REVISION = "adaptor_UnitExtn_revision"
	CONST_PROP_ID_ADAPTOR_UNIT_EXTN_SERIAL = "adaptor_UnitExtn_serial"
	CONST_PROP_ID_ADAPTOR_UNIT_EXTN_THERMAL = "adaptor_UnitExtn_thermal"
	CONST_PROP_ID_ADAPTOR_UNIT_EXTN_VENDOR = "adaptor_UnitExtn_vendor"
	CONST_PROP_ID_ADAPTOR_UNIT_EXTN_VOLTAGE = "adaptor_UnitExtn_voltage"
	CONST_PROP_ID_ADAPTOR_UNIT_ADMIN_POWER_STATE = "adaptor_Unit_adminPowerState"
	CONST_PROP_ID_ADAPTOR_UNIT_BASE_MAC = "adaptor_Unit_baseMac"
	CONST_PROP_ID_ADAPTOR_UNIT_BLADE_ID = "adaptor_Unit_bladeId"
	CONST_PROP_ID_ADAPTOR_UNIT_CHASSIS_ID = "adaptor_Unit_chassisId"
	CONST_PROP_ID_ADAPTOR_UNIT_CONN_PATH = "adaptor_Unit_connPath"
	CONST_PROP_ID_ADAPTOR_UNIT_CONN_STATUS = "adaptor_Unit_connStatus"
	CONST_PROP_ID_ADAPTOR_UNIT_ID = "adaptor_Unit_id"
	CONST_PROP_ID_ADAPTOR_UNIT_INTEGRATED = "adaptor_Unit_integrated"
	CONST_PROP_ID_ADAPTOR_UNIT_MANAGING_INST = "adaptor_Unit_managingInst"
	CONST_PROP_ID_ADAPTOR_UNIT_MFG_TIME = "adaptor_Unit_mfgTime"
	CONST_PROP_ID_ADAPTOR_UNIT_MODEL = "adaptor_Unit_model"
	CONST_PROP_ID_ADAPTOR_UNIT_OPER_QUALIFIER_REASON = "adaptor_Unit_operQualifierReason"
	CONST_PROP_ID_ADAPTOR_UNIT_OPER_STATE = "adaptor_Unit_operState"
	CONST_PROP_ID_ADAPTOR_UNIT_OPERABILITY = "adaptor_Unit_operability"
	CONST_PROP_ID_ADAPTOR_UNIT_PART_NUMBER = "adaptor_Unit_partNumber"
	CONST_PROP_ID_ADAPTOR_UNIT_PCI_ADDR = "adaptor_Unit_pciAddr"
	CONST_PROP_ID_ADAPTOR_UNIT_PCI_SLOT = "adaptor_Unit_pciSlot"
	CONST_PROP_ID_ADAPTOR_UNIT_PERF = "adaptor_Unit_perf"
	CONST_PROP_ID_ADAPTOR_UNIT_POWER = "adaptor_Unit_power"
	CONST_PROP_ID_ADAPTOR_UNIT_PRESENCE = "adaptor_Unit_presence"
	CONST_PROP_ID_ADAPTOR_UNIT_REACHABILITY = "adaptor_Unit_reachability"
	CONST_PROP_ID_ADAPTOR_UNIT_REVISION = "adaptor_Unit_revision"
	CONST_PROP_ID_ADAPTOR_UNIT_SERIAL = "adaptor_Unit_serial"
	CONST_PROP_ID_ADAPTOR_UNIT_THERMAL = "adaptor_Unit_thermal"
	CONST_PROP_ID_ADAPTOR_UNIT_VENDOR = "adaptor_Unit_vendor"
	CONST_PROP_ID_ADAPTOR_UNIT_VOLTAGE = "adaptor_Unit_voltage"
	CONST_PROP_ID_ADAPTOR_UPLINK_HW_ADDR_CAP_LLDP_MAC_OFFSET1 = "adaptor_UplinkHwAddrCap_lldpMacOffset1"
	CONST_PROP_ID_ADAPTOR_UPLINK_HW_ADDR_CAP_LLDP_MAC_OFFSET2 = "adaptor_UplinkHwAddrCap_lldpMacOffset2"
	CONST_PROP_ID_ADAPTOR_UPLINK_HW_ADDR_CAP_MAC_OFFSET1 = "adaptor_UplinkHwAddrCap_macOffset1"
	CONST_PROP_ID_ADAPTOR_UPLINK_HW_ADDR_CAP_MAC_OFFSET2 = "adaptor_UplinkHwAddrCap_macOffset2"
	CONST_PROP_ID_ADAPTOR_UPLINK_HW_ADDR_CAP_MAC_OFFSET_SUB00 = "adaptor_UplinkHwAddrCap_macOffsetSub00"
	CONST_PROP_ID_ADAPTOR_UPLINK_HW_ADDR_CAP_MAC_OFFSET_SUB01 = "adaptor_UplinkHwAddrCap_macOffsetSub01"
	CONST_PROP_ID_ADAPTOR_UPLINK_HW_ADDR_CAP_MAC_OFFSET_SUB02 = "adaptor_UplinkHwAddrCap_macOffsetSub02"
	CONST_PROP_ID_ADAPTOR_UPLINK_HW_ADDR_CAP_MAC_OFFSET_SUB03 = "adaptor_UplinkHwAddrCap_macOffsetSub03"
	CONST_PROP_ID_ADAPTOR_UPLINK_HW_ADDR_CAP_MAC_OFFSET_SUB10 = "adaptor_UplinkHwAddrCap_macOffsetSub10"
	CONST_PROP_ID_ADAPTOR_UPLINK_HW_ADDR_CAP_MAC_OFFSET_SUB11 = "adaptor_UplinkHwAddrCap_macOffsetSub11"
	CONST_PROP_ID_ADAPTOR_UPLINK_HW_ADDR_CAP_MAC_OFFSET_SUB12 = "adaptor_UplinkHwAddrCap_macOffsetSub12"
	CONST_PROP_ID_ADAPTOR_UPLINK_HW_ADDR_CAP_MAC_OFFSET_SUB13 = "adaptor_UplinkHwAddrCap_macOffsetSub13"
	CONST_PROP_ID_ADAPTOR_USNIC_CONN_DEF_CON_POLICY_NAME = "adaptor_UsnicConnDef_conPolicyName"
	CONST_PROP_ID_ADAPTOR_USNIC_CONN_DEF_USNIC_COUNT = "adaptor_UsnicConnDef_usnicCount"
	CONST_PROP_ID_ADAPTOR_VLAN_EP_DN = "adaptor_Vlan_epDn"
	CONST_PROP_ID_ADAPTOR_VLAN_ID = "adaptor_Vlan_id"
	CONST_PROP_ID_ADAPTOR_VLAN_IF_ROLE = "adaptor_Vlan_ifRole"
	CONST_PROP_ID_ADAPTOR_VLAN_IF_TYPE = "adaptor_Vlan_ifType"
	CONST_PROP_ID_ADAPTOR_VLAN_LC = "adaptor_Vlan_lc"
	CONST_PROP_ID_ADAPTOR_VLAN_LOCALE = "adaptor_Vlan_locale"
	CONST_PROP_ID_ADAPTOR_VLAN_NAME = "adaptor_Vlan_name"
	CONST_PROP_ID_ADAPTOR_VLAN_OPER_STATE = "adaptor_Vlan_operState"
	CONST_PROP_ID_ADAPTOR_VLAN_PEER_DN = "adaptor_Vlan_peerDn"
	CONST_PROP_ID_ADAPTOR_VLAN_POLICY_OWNER = "adaptor_Vlan_policyOwner"
	CONST_PROP_ID_ADAPTOR_VLAN_PUB_NW_DN = "adaptor_Vlan_pubNwDn"
	CONST_PROP_ID_ADAPTOR_VLAN_PUB_NW_ID = "adaptor_Vlan_pubNwId"
	CONST_PROP_ID_ADAPTOR_VLAN_PUB_NW_NAME = "adaptor_Vlan_pubNwName"
	CONST_PROP_ID_ADAPTOR_VLAN_SHARING = "adaptor_Vlan_sharing"
	CONST_PROP_ID_ADAPTOR_VLAN_SWITCH_ID = "adaptor_Vlan_switchId"
	CONST_PROP_ID_ADAPTOR_VLAN_TRANSPORT = "adaptor_Vlan_transport"
	CONST_PROP_ID_ADAPTOR_VLAN_TYPE = "adaptor_Vlan_type"
	CONST_PROP_ID_ADAPTOR_VLAN_VLAN_TYPE = "adaptor_Vlan_vlanType"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_HIST_BYTES_RX = "adaptor_VnicStatsHist_bytesRx"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_HIST_BYTES_RX_DELTA = "adaptor_VnicStatsHist_bytesRxDelta"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_HIST_BYTES_RX_DELTA_AVG = "adaptor_VnicStatsHist_bytesRxDeltaAvg"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_HIST_BYTES_RX_DELTA_MAX = "adaptor_VnicStatsHist_bytesRxDeltaMax"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_HIST_BYTES_RX_DELTA_MIN = "adaptor_VnicStatsHist_bytesRxDeltaMin"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_HIST_BYTES_TX = "adaptor_VnicStatsHist_bytesTx"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_HIST_BYTES_TX_DELTA = "adaptor_VnicStatsHist_bytesTxDelta"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_HIST_BYTES_TX_DELTA_AVG = "adaptor_VnicStatsHist_bytesTxDeltaAvg"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_HIST_BYTES_TX_DELTA_MAX = "adaptor_VnicStatsHist_bytesTxDeltaMax"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_HIST_BYTES_TX_DELTA_MIN = "adaptor_VnicStatsHist_bytesTxDeltaMin"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_HIST_DROPPED_RX = "adaptor_VnicStatsHist_droppedRx"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_HIST_DROPPED_RX_DELTA = "adaptor_VnicStatsHist_droppedRxDelta"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_HIST_DROPPED_RX_DELTA_AVG = "adaptor_VnicStatsHist_droppedRxDeltaAvg"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_HIST_DROPPED_RX_DELTA_MAX = "adaptor_VnicStatsHist_droppedRxDeltaMax"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_HIST_DROPPED_RX_DELTA_MIN = "adaptor_VnicStatsHist_droppedRxDeltaMin"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_HIST_DROPPED_TX = "adaptor_VnicStatsHist_droppedTx"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_HIST_DROPPED_TX_DELTA = "adaptor_VnicStatsHist_droppedTxDelta"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_HIST_DROPPED_TX_DELTA_AVG = "adaptor_VnicStatsHist_droppedTxDeltaAvg"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_HIST_DROPPED_TX_DELTA_MAX = "adaptor_VnicStatsHist_droppedTxDeltaMax"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_HIST_DROPPED_TX_DELTA_MIN = "adaptor_VnicStatsHist_droppedTxDeltaMin"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_HIST_ERRORS_RX = "adaptor_VnicStatsHist_errorsRx"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_HIST_ERRORS_RX_DELTA = "adaptor_VnicStatsHist_errorsRxDelta"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_HIST_ERRORS_RX_DELTA_AVG = "adaptor_VnicStatsHist_errorsRxDeltaAvg"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_HIST_ERRORS_RX_DELTA_MAX = "adaptor_VnicStatsHist_errorsRxDeltaMax"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_HIST_ERRORS_RX_DELTA_MIN = "adaptor_VnicStatsHist_errorsRxDeltaMin"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_HIST_ERRORS_TX = "adaptor_VnicStatsHist_errorsTx"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_HIST_ERRORS_TX_DELTA = "adaptor_VnicStatsHist_errorsTxDelta"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_HIST_ERRORS_TX_DELTA_AVG = "adaptor_VnicStatsHist_errorsTxDeltaAvg"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_HIST_ERRORS_TX_DELTA_MAX = "adaptor_VnicStatsHist_errorsTxDeltaMax"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_HIST_ERRORS_TX_DELTA_MIN = "adaptor_VnicStatsHist_errorsTxDeltaMin"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_HIST_ID = "adaptor_VnicStatsHist_id"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_HIST_MOST_RECENT = "adaptor_VnicStatsHist_mostRecent"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_HIST_PACKETS_RX = "adaptor_VnicStatsHist_packetsRx"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_HIST_PACKETS_RX_DELTA = "adaptor_VnicStatsHist_packetsRxDelta"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_HIST_PACKETS_RX_DELTA_AVG = "adaptor_VnicStatsHist_packetsRxDeltaAvg"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_HIST_PACKETS_RX_DELTA_MAX = "adaptor_VnicStatsHist_packetsRxDeltaMax"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_HIST_PACKETS_RX_DELTA_MIN = "adaptor_VnicStatsHist_packetsRxDeltaMin"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_HIST_PACKETS_TX = "adaptor_VnicStatsHist_packetsTx"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_HIST_PACKETS_TX_DELTA = "adaptor_VnicStatsHist_packetsTxDelta"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_HIST_PACKETS_TX_DELTA_AVG = "adaptor_VnicStatsHist_packetsTxDeltaAvg"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_HIST_PACKETS_TX_DELTA_MAX = "adaptor_VnicStatsHist_packetsTxDeltaMax"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_HIST_PACKETS_TX_DELTA_MIN = "adaptor_VnicStatsHist_packetsTxDeltaMin"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_HIST_SUSPECT = "adaptor_VnicStatsHist_suspect"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_HIST_THRESHOLDED = "adaptor_VnicStatsHist_thresholded"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_HIST_TIME_COLLECTED = "adaptor_VnicStatsHist_timeCollected"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_BYTES_RX = "adaptor_VnicStats_bytesRx"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_BYTES_RX_DELTA = "adaptor_VnicStats_bytesRxDelta"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_BYTES_RX_DELTA_AVG = "adaptor_VnicStats_bytesRxDeltaAvg"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_BYTES_RX_DELTA_MAX = "adaptor_VnicStats_bytesRxDeltaMax"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_BYTES_RX_DELTA_MIN = "adaptor_VnicStats_bytesRxDeltaMin"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_BYTES_TX = "adaptor_VnicStats_bytesTx"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_BYTES_TX_DELTA = "adaptor_VnicStats_bytesTxDelta"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_BYTES_TX_DELTA_AVG = "adaptor_VnicStats_bytesTxDeltaAvg"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_BYTES_TX_DELTA_MAX = "adaptor_VnicStats_bytesTxDeltaMax"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_BYTES_TX_DELTA_MIN = "adaptor_VnicStats_bytesTxDeltaMin"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_DROPPED_RX = "adaptor_VnicStats_droppedRx"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_DROPPED_RX_DELTA = "adaptor_VnicStats_droppedRxDelta"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_DROPPED_RX_DELTA_AVG = "adaptor_VnicStats_droppedRxDeltaAvg"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_DROPPED_RX_DELTA_MAX = "adaptor_VnicStats_droppedRxDeltaMax"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_DROPPED_RX_DELTA_MIN = "adaptor_VnicStats_droppedRxDeltaMin"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_DROPPED_TX = "adaptor_VnicStats_droppedTx"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_DROPPED_TX_DELTA = "adaptor_VnicStats_droppedTxDelta"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_DROPPED_TX_DELTA_AVG = "adaptor_VnicStats_droppedTxDeltaAvg"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_DROPPED_TX_DELTA_MAX = "adaptor_VnicStats_droppedTxDeltaMax"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_DROPPED_TX_DELTA_MIN = "adaptor_VnicStats_droppedTxDeltaMin"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_ERRORS_RX = "adaptor_VnicStats_errorsRx"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_ERRORS_RX_DELTA = "adaptor_VnicStats_errorsRxDelta"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_ERRORS_RX_DELTA_AVG = "adaptor_VnicStats_errorsRxDeltaAvg"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_ERRORS_RX_DELTA_MAX = "adaptor_VnicStats_errorsRxDeltaMax"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_ERRORS_RX_DELTA_MIN = "adaptor_VnicStats_errorsRxDeltaMin"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_ERRORS_TX = "adaptor_VnicStats_errorsTx"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_ERRORS_TX_DELTA = "adaptor_VnicStats_errorsTxDelta"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_ERRORS_TX_DELTA_AVG = "adaptor_VnicStats_errorsTxDeltaAvg"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_ERRORS_TX_DELTA_MAX = "adaptor_VnicStats_errorsTxDeltaMax"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_ERRORS_TX_DELTA_MIN = "adaptor_VnicStats_errorsTxDeltaMin"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_INTERVALS = "adaptor_VnicStats_intervals"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_PACKETS_RX = "adaptor_VnicStats_packetsRx"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_PACKETS_RX_DELTA = "adaptor_VnicStats_packetsRxDelta"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_PACKETS_RX_DELTA_AVG = "adaptor_VnicStats_packetsRxDeltaAvg"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_PACKETS_RX_DELTA_MAX = "adaptor_VnicStats_packetsRxDeltaMax"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_PACKETS_RX_DELTA_MIN = "adaptor_VnicStats_packetsRxDeltaMin"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_PACKETS_TX = "adaptor_VnicStats_packetsTx"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_PACKETS_TX_DELTA = "adaptor_VnicStats_packetsTxDelta"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_PACKETS_TX_DELTA_AVG = "adaptor_VnicStats_packetsTxDeltaAvg"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_PACKETS_TX_DELTA_MAX = "adaptor_VnicStats_packetsTxDeltaMax"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_PACKETS_TX_DELTA_MIN = "adaptor_VnicStats_packetsTxDeltaMin"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_SUSPECT = "adaptor_VnicStats_suspect"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_THRESHOLDED = "adaptor_VnicStats_thresholded"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_TIME_COLLECTED = "adaptor_VnicStats_timeCollected"
	CONST_PROP_ID_ADAPTOR_VNIC_STATS_UPDATE = "adaptor_VnicStats_update"
	CONST_PROP_ID_ADAPTOR_VSAN_EP_DN = "adaptor_Vsan_epDn"
	CONST_PROP_ID_ADAPTOR_VSAN_FCOE_VLAN = "adaptor_Vsan_fcoeVlan"
	CONST_PROP_ID_ADAPTOR_VSAN_ID = "adaptor_Vsan_id"
	CONST_PROP_ID_ADAPTOR_VSAN_IF_ROLE = "adaptor_Vsan_ifRole"
	CONST_PROP_ID_ADAPTOR_VSAN_IF_TYPE = "adaptor_Vsan_ifType"
	CONST_PROP_ID_ADAPTOR_VSAN_LC = "adaptor_Vsan_lc"
	CONST_PROP_ID_ADAPTOR_VSAN_LOCALE = "adaptor_Vsan_locale"
	CONST_PROP_ID_ADAPTOR_VSAN_NAME = "adaptor_Vsan_name"
	CONST_PROP_ID_ADAPTOR_VSAN_OPER_STATE = "adaptor_Vsan_operState"
	CONST_PROP_ID_ADAPTOR_VSAN_PEER_DN = "adaptor_Vsan_peerDn"
	CONST_PROP_ID_ADAPTOR_VSAN_POLICY_OWNER = "adaptor_Vsan_policyOwner"
	CONST_PROP_ID_ADAPTOR_VSAN_SWITCH_ID = "adaptor_Vsan_switchId"
	CONST_PROP_ID_ADAPTOR_VSAN_TRANSPORT = "adaptor_Vsan_transport"
	CONST_PROP_ID_ADAPTOR_VSAN_TYPE = "adaptor_Vsan_type"
	CONST_PROP_ID_ADAPTOR_VSAN_ZONING_STATE = "adaptor_Vsan_zoningState"
	CONST_PROP_ID_APE_ADAPTER_VNIC_COOKIE = "ape_AdapterVnic_cookie"
	CONST_PROP_ID_APE_ADAPTER_VNIC_COS = "ape_AdapterVnic_cos"
	CONST_PROP_ID_APE_ADAPTER_VNIC_MAC = "ape_AdapterVnic_mac"
	CONST_PROP_ID_APE_ADAPTER_VNIC_NAME = "ape_AdapterVnic_name"
	CONST_PROP_ID_APE_ADAPTER_VNIC_NIC_DN = "ape_AdapterVnic_nicDn"
	CONST_PROP_ID_APE_ADAPTER_VNIC_STATE = "ape_AdapterVnic_state"
	CONST_PROP_ID_APE_ADAPTER_VNIC_TYPE = "ape_AdapterVnic_type"
	CONST_PROP_ID_APE_ADAPTER_VNIC_UPLINK_PORT_ID = "ape_AdapterVnic_uplinkPortId"
	CONST_PROP_ID_APE_ADAPTER_VNIC_VIF_ID = "ape_AdapterVnic_vifId"
	CONST_PROP_ID_APE_ADAPTER_VNIC_VIF_TYPE = "ape_AdapterVnic_vifType"
	CONST_PROP_ID_APE_ADAPTER_VNIC_VLAN_ID = "ape_AdapterVnic_vlanId"
	CONST_PROP_ID_APE_ADAPTER_VNIC_VNTAG = "ape_AdapterVnic_vntag"
	CONST_PROP_ID_APE_ADAPTER_VNIC_WWNN = "ape_AdapterVnic_wwnn"
	CONST_PROP_ID_APE_ADAPTER_DESCRIPTION = "ape_Adapter_description"
	CONST_PROP_ID_APE_ADAPTER_FRU_ID = "ape_Adapter_fruId"
	CONST_PROP_ID_APE_ADAPTER_HW_VERSION = "ape_Adapter_hwVersion"
	CONST_PROP_ID_APE_ADAPTER_MAC1 = "ape_Adapter_mac1"
	CONST_PROP_ID_APE_ADAPTER_MAC2 = "ape_Adapter_mac2"
	CONST_PROP_ID_APE_ADAPTER_NAME = "ape_Adapter_name"
	CONST_PROP_ID_APE_ADAPTER_SERIAL = "ape_Adapter_serial"
	CONST_PROP_ID_APE_ADAPTER_START_EVENT = "ape_Adapter_startEvent"
	CONST_PROP_ID_APE_ADAPTER_SW_BACKUP_VERSION = "ape_Adapter_swBackupVersion"
	CONST_PROP_ID_APE_ADAPTER_SW_STARTUP_VERSION = "ape_Adapter_swStartupVersion"
	CONST_PROP_ID_APE_ADAPTER_SW_VERSION = "ape_Adapter_swVersion"
	CONST_PROP_ID_APE_ADAPTER_TYPE = "ape_Adapter_type"
	CONST_PROP_ID_APE_BOOT_METHOD_HOSTNAME = "ape_BootMethod_hostname"
	CONST_PROP_ID_APE_BOOT_METHOD_IS_HOST_AGENT_PRESENT = "ape_BootMethod_isHostAgentPresent"
	CONST_PROP_ID_APE_BOOT_METHOD_KERNEL_NAME = "ape_BootMethod_kernelName"
	CONST_PROP_ID_APE_BOOT_METHOD_KERNEL_RELEASE = "ape_BootMethod_kernelRelease"
	CONST_PROP_ID_APE_BOOT_METHOD_KERNEL_VERSION = "ape_BootMethod_kernelVersion"
	CONST_PROP_ID_APE_BOOT_METHOD_NAME = "ape_BootMethod_name"
	CONST_PROP_ID_APE_BOOT_METHOD_TYPE = "ape_BootMethod_type"
	CONST_PROP_ID_APE_CONTROLLER_CHASSIS_INDEX = "ape_ControllerChassis_index"
	CONST_PROP_ID_APE_CONTROLLER_EEPROM_DATABASE_VERSION = "ape_ControllerEeprom_databaseVersion"
	CONST_PROP_ID_APE_CONTROLLER_EEPROM_HEARTBEAT_REQUEST = "ape_ControllerEeprom_heartbeatRequest"
	CONST_PROP_ID_APE_CONTROLLER_EEPROM_HEARTBEAT_RESPONSE = "ape_ControllerEeprom_heartbeatResponse"
	CONST_PROP_ID_APE_CONTROLLER_EEPROM_SIDE = "ape_ControllerEeprom_side"
	CONST_PROP_ID_APE_FRU_BOARD_MANUFACTURER = "ape_Fru_boardManufacturer"
	CONST_PROP_ID_APE_FRU_BOARD_MFG_TIME = "ape_Fru_boardMfgTime"
	CONST_PROP_ID_APE_FRU_BOARD_PART_NO = "ape_Fru_boardPartNo"
	CONST_PROP_ID_APE_FRU_BOARD_PRODUCT_NAME = "ape_Fru_boardProductName"
	CONST_PROP_ID_APE_FRU_BOARD_SERIAL_NO = "ape_Fru_boardSerialNo"
	CONST_PROP_ID_APE_FRU_BOARD_VID = "ape_Fru_boardVid"
	CONST_PROP_ID_APE_FRU_CHASSIS_PART_NO = "ape_Fru_chassisPartNo"
	CONST_PROP_ID_APE_FRU_CHASSIS_SERIAL_NO = "ape_Fru_chassisSerialNo"
	CONST_PROP_ID_APE_FRU_CONTROL_PLANE_MAC1 = "ape_Fru_controlPlaneMac1"
	CONST_PROP_ID_APE_FRU_CONTROL_PLANE_MAC2 = "ape_Fru_controlPlaneMac2"
	CONST_PROP_ID_APE_FRU_DATA_PLANE_MAC1 = "ape_Fru_dataPlaneMac1"
	CONST_PROP_ID_APE_FRU_DATA_PLANE_MAC2 = "ape_Fru_dataPlaneMac2"
	CONST_PROP_ID_APE_FRU_DATA_PLANE_WWN1 = "ape_Fru_dataPlaneWwn1"
	CONST_PROP_ID_APE_FRU_DATA_PLANE_WWN2 = "ape_Fru_dataPlaneWwn2"
	CONST_PROP_ID_APE_FRU_ENTITY_TYPE = "ape_Fru_entityType"
	CONST_PROP_ID_APE_FRU_ID = "ape_Fru_id"
	CONST_PROP_ID_APE_FRU_INSTANCE = "ape_Fru_instance"
	CONST_PROP_ID_APE_FRU_PRODUCT_ASSET_TAG = "ape_Fru_productAssetTag"
	CONST_PROP_ID_APE_FRU_PRODUCT_MANUFACTURER = "ape_Fru_productManufacturer"
	CONST_PROP_ID_APE_FRU_PRODUCT_NAME = "ape_Fru_productName"
	CONST_PROP_ID_APE_FRU_PRODUCT_PART_NO = "ape_Fru_productPartNo"
	CONST_PROP_ID_APE_FRU_PRODUCT_SERIAL_NO = "ape_Fru_productSerialNo"
	CONST_PROP_ID_APE_FRU_PRODUCT_VERSION_NO = "ape_Fru_productVersionNo"
	CONST_PROP_ID_APE_FRU_TYPE = "ape_Fru_type"
	CONST_PROP_ID_APE_HOST_AGENT_CHASSIS_ID = "ape_HostAgent_chassisId"
	CONST_PROP_ID_APE_HOST_AGENT_SERVER_ID = "ape_HostAgent_serverId"
	CONST_PROP_ID_APE_HOST_AGENT_SLOT_ID = "ape_HostAgent_slotId"
	CONST_PROP_ID_APE_HOST_AGENT_STATE = "ape_HostAgent_state"
	CONST_PROP_ID_APE_LANBOOT_HOSTNAME = "ape_LANBoot_hostname"
	CONST_PROP_ID_APE_LANBOOT_IS_HOST_AGENT_PRESENT = "ape_LANBoot_isHostAgentPresent"
	CONST_PROP_ID_APE_LANBOOT_KERNEL_NAME = "ape_LANBoot_kernelName"
	CONST_PROP_ID_APE_LANBOOT_KERNEL_RELEASE = "ape_LANBoot_kernelRelease"
	CONST_PROP_ID_APE_LANBOOT_KERNEL_VERSION = "ape_LANBoot_kernelVersion"
	CONST_PROP_ID_APE_LANBOOT_NAME = "ape_LANBoot_name"
	CONST_PROP_ID_APE_LANBOOT_TYPE = "ape_LANBoot_type"
	CONST_PROP_ID_APE_LANBOOT_VNIC_NAME = "ape_LANBoot_vnicName"
	CONST_PROP_ID_APE_LOCAL_DISK_BOOT_CHASSIS_ID = "ape_LocalDiskBoot_chassisId"
	CONST_PROP_ID_APE_LOCAL_DISK_BOOT_HOSTNAME = "ape_LocalDiskBoot_hostname"
	CONST_PROP_ID_APE_LOCAL_DISK_BOOT_IS_HOST_AGENT_PRESENT = "ape_LocalDiskBoot_isHostAgentPresent"
	CONST_PROP_ID_APE_LOCAL_DISK_BOOT_KERNEL_NAME = "ape_LocalDiskBoot_kernelName"
	CONST_PROP_ID_APE_LOCAL_DISK_BOOT_KERNEL_RELEASE = "ape_LocalDiskBoot_kernelRelease"
	CONST_PROP_ID_APE_LOCAL_DISK_BOOT_KERNEL_VERSION = "ape_LocalDiskBoot_kernelVersion"
	CONST_PROP_ID_APE_LOCAL_DISK_BOOT_NAME = "ape_LocalDiskBoot_name"
	CONST_PROP_ID_APE_LOCAL_DISK_BOOT_SLOT_ID = "ape_LocalDiskBoot_slotId"
	CONST_PROP_ID_APE_LOCAL_DISK_BOOT_TARGET_LUN = "ape_LocalDiskBoot_targetLun"
	CONST_PROP_ID_APE_LOCAL_DISK_BOOT_TYPE = "ape_LocalDiskBoot_type"
	CONST_PROP_ID_APE_MANAGER_STATS_UPDATE_ID = "ape_Manager_statsUpdateId"
	CONST_PROP_ID_APE_MC_TABLE_ID = "ape_McTable_id"
	CONST_PROP_ID_APE_MC_TABLE_NAME = "ape_McTable_name"
	CONST_PROP_ID_APE_MC_IP = "ape_Mc_ip"
	CONST_PROP_ID_APE_MC_TYPE = "ape_Mc_type"
	CONST_PROP_ID_APE_MC_UPDATE_TYPE = "ape_Mc_updateType"
	CONST_PROP_ID_APE_MENLO_VNIC_STATS_BYTES_EG = "ape_MenloVnicStats_bytes_eg"
	CONST_PROP_ID_APE_MENLO_VNIC_STATS_BYTES_IN = "ape_MenloVnicStats_bytes_in"
	CONST_PROP_ID_APE_MENLO_VNIC_STATS_DROPPED_PKTS_EG = "ape_MenloVnicStats_dropped_pkts_eg"
	CONST_PROP_ID_APE_MENLO_VNIC_STATS_DROPPED_PKTS_IN = "ape_MenloVnicStats_dropped_pkts_in"
	CONST_PROP_ID_APE_MENLO_VNIC_STATS_ERRORS_EG = "ape_MenloVnicStats_errors_eg"
	CONST_PROP_ID_APE_MENLO_VNIC_STATS_ERRORS_IN = "ape_MenloVnicStats_errors_in"
	CONST_PROP_ID_APE_MENLO_VNIC_STATS_PKTS_EG = "ape_MenloVnicStats_pkts_eg"
	CONST_PROP_ID_APE_MENLO_VNIC_STATS_PKTS_IN = "ape_MenloVnicStats_pkts_in"
	CONST_PROP_ID_APE_MENLO_VNIC_COOKIE = "ape_MenloVnic_cookie"
	CONST_PROP_ID_APE_MENLO_VNIC_COS = "ape_MenloVnic_cos"
	CONST_PROP_ID_APE_MENLO_VNIC_MAC = "ape_MenloVnic_mac"
	CONST_PROP_ID_APE_MENLO_VNIC_NAME = "ape_MenloVnic_name"
	CONST_PROP_ID_APE_MENLO_VNIC_NIC_DN = "ape_MenloVnic_nicDn"
	CONST_PROP_ID_APE_MENLO_VNIC_PIF_ID = "ape_MenloVnic_pifId"
	CONST_PROP_ID_APE_MENLO_VNIC_STATE = "ape_MenloVnic_state"
	CONST_PROP_ID_APE_MENLO_VNIC_TYPE = "ape_MenloVnic_type"
	CONST_PROP_ID_APE_MENLO_VNIC_UPLINK_PORT_ID = "ape_MenloVnic_uplinkPortId"
	CONST_PROP_ID_APE_MENLO_VNIC_VIF_ID = "ape_MenloVnic_vifId"
	CONST_PROP_ID_APE_MENLO_VNIC_VIF_TYPE = "ape_MenloVnic_vifType"
	CONST_PROP_ID_APE_MENLO_VNIC_VLAN_ID = "ape_MenloVnic_vlanId"
	CONST_PROP_ID_APE_MENLO_VNIC_VNTAG = "ape_MenloVnic_vntag"
	CONST_PROP_ID_APE_MENLO_VNIC_WWNN = "ape_MenloVnic_wwnn"
	CONST_PROP_ID_APE_MENLO_VNIC_WWPN = "ape_MenloVnic_wwpn"
	CONST_PROP_ID_APE_MENLO_DESCRIPTION = "ape_Menlo_description"
	CONST_PROP_ID_APE_MENLO_FRU_ID = "ape_Menlo_fruId"
	CONST_PROP_ID_APE_MENLO_FW_UPDATE_TIMEOUT = "ape_Menlo_fwUpdateTimeout"
	CONST_PROP_ID_APE_MENLO_HW_VERSION = "ape_Menlo_hwVersion"
	CONST_PROP_ID_APE_MENLO_MAC1 = "ape_Menlo_mac1"
	CONST_PROP_ID_APE_MENLO_MAC2 = "ape_Menlo_mac2"
	CONST_PROP_ID_APE_MENLO_NAME = "ape_Menlo_name"
	CONST_PROP_ID_APE_MENLO_OPERATION_TIMEOUT = "ape_Menlo_operationTimeout"
	CONST_PROP_ID_APE_MENLO_SERIAL = "ape_Menlo_serial"
	CONST_PROP_ID_APE_MENLO_START_EVENT = "ape_Menlo_startEvent"
	CONST_PROP_ID_APE_MENLO_SW_BACKUP_VERSION = "ape_Menlo_swBackupVersion"
	CONST_PROP_ID_APE_MENLO_SW_STARTUP_VERSION = "ape_Menlo_swStartupVersion"
	CONST_PROP_ID_APE_MENLO_SW_VERSION = "ape_Menlo_swVersion"
	CONST_PROP_ID_APE_MENLO_TYPE = "ape_Menlo_type"
	CONST_PROP_ID_APE_MENLO_UPLINK_PORT_TYPE = "ape_Menlo_uplinkPortType"
	CONST_PROP_ID_APE_PALO_VNIC_STATS_BYTES_EG = "ape_PaloVnicStats_bytes_eg"
	CONST_PROP_ID_APE_PALO_VNIC_STATS_BYTES_IN = "ape_PaloVnicStats_bytes_in"
	CONST_PROP_ID_APE_PALO_VNIC_STATS_DROPPED_PKTS_EG = "ape_PaloVnicStats_dropped_pkts_eg"
	CONST_PROP_ID_APE_PALO_VNIC_STATS_DROPPED_PKTS_IN = "ape_PaloVnicStats_dropped_pkts_in"
	CONST_PROP_ID_APE_PALO_VNIC_STATS_ERRORS_EG = "ape_PaloVnicStats_errors_eg"
	CONST_PROP_ID_APE_PALO_VNIC_STATS_ERRORS_IN = "ape_PaloVnicStats_errors_in"
	CONST_PROP_ID_APE_PALO_VNIC_STATS_PKTS_EG = "ape_PaloVnicStats_pkts_eg"
	CONST_PROP_ID_APE_PALO_VNIC_STATS_PKTS_IN = "ape_PaloVnicStats_pkts_in"
	CONST_PROP_ID_APE_PALO_VNIC_COOKIE = "ape_PaloVnic_cookie"
	CONST_PROP_ID_APE_PALO_VNIC_COS = "ape_PaloVnic_cos"
	CONST_PROP_ID_APE_PALO_VNIC_FAILOVER = "ape_PaloVnic_failover"
	CONST_PROP_ID_APE_PALO_VNIC_MAC = "ape_PaloVnic_mac"
	CONST_PROP_ID_APE_PALO_VNIC_MTU = "ape_PaloVnic_mtu"
	CONST_PROP_ID_APE_PALO_VNIC_NAME = "ape_PaloVnic_name"
	CONST_PROP_ID_APE_PALO_VNIC_NIC_DN = "ape_PaloVnic_nicDn"
	CONST_PROP_ID_APE_PALO_VNIC_PASS_THRU = "ape_PaloVnic_passThru"
	CONST_PROP_ID_APE_PALO_VNIC_STATE = "ape_PaloVnic_state"
	CONST_PROP_ID_APE_PALO_VNIC_STDBY_VIF_ID = "ape_PaloVnic_stdbyVifId"
	CONST_PROP_ID_APE_PALO_VNIC_TYPE = "ape_PaloVnic_type"
	CONST_PROP_ID_APE_PALO_VNIC_UPLINK_PORT_ID = "ape_PaloVnic_uplinkPortId"
	CONST_PROP_ID_APE_PALO_VNIC_VIF_ID = "ape_PaloVnic_vifId"
	CONST_PROP_ID_APE_PALO_VNIC_VIF_TYPE = "ape_PaloVnic_vifType"
	CONST_PROP_ID_APE_PALO_VNIC_VLAN_ID = "ape_PaloVnic_vlanId"
	CONST_PROP_ID_APE_PALO_VNIC_VM_WARE = "ape_PaloVnic_vmWare"
	CONST_PROP_ID_APE_PALO_VNIC_VNTAG = "ape_PaloVnic_vntag"
	CONST_PROP_ID_APE_PALO_VNIC_WWNN = "ape_PaloVnic_wwnn"
	CONST_PROP_ID_APE_PALO_DESCRIPTION = "ape_Palo_description"
	CONST_PROP_ID_APE_PALO_FRU_ID = "ape_Palo_fruId"
	CONST_PROP_ID_APE_PALO_HW_VERSION = "ape_Palo_hwVersion"
	CONST_PROP_ID_APE_PALO_MAC1 = "ape_Palo_mac1"
	CONST_PROP_ID_APE_PALO_MAC2 = "ape_Palo_mac2"
	CONST_PROP_ID_APE_PALO_NAME = "ape_Palo_name"
	CONST_PROP_ID_APE_PALO_SERIAL = "ape_Palo_serial"
	CONST_PROP_ID_APE_PALO_START_EVENT = "ape_Palo_startEvent"
	CONST_PROP_ID_APE_PALO_SW_BACKUP_VERSION = "ape_Palo_swBackupVersion"
	CONST_PROP_ID_APE_PALO_SW_STARTUP_VERSION = "ape_Palo_swStartupVersion"
	CONST_PROP_ID_APE_PALO_SW_VERSION = "ape_Palo_swVersion"
	CONST_PROP_ID_APE_PALO_TYPE = "ape_Palo_type"
	CONST_PROP_ID_APE_PARAM_KEY = "ape_Param_key"
	CONST_PROP_ID_APE_PARAM_VALUE = "ape_Param_value"
	CONST_PROP_ID_APE_READING_ID = "ape_Reading_id"
	CONST_PROP_ID_APE_READING_STATE = "ape_Reading_state"
	CONST_PROP_ID_APE_READING_VALUE = "ape_Reading_value"
	CONST_PROP_ID_APE_SANBOOT_HOSTNAME = "ape_SANBoot_hostname"
	CONST_PROP_ID_APE_SANBOOT_IS_HOST_AGENT_PRESENT = "ape_SANBoot_isHostAgentPresent"
	CONST_PROP_ID_APE_SANBOOT_KERNEL_NAME = "ape_SANBoot_kernelName"
	CONST_PROP_ID_APE_SANBOOT_KERNEL_RELEASE = "ape_SANBoot_kernelRelease"
	CONST_PROP_ID_APE_SANBOOT_KERNEL_VERSION = "ape_SANBoot_kernelVersion"
	CONST_PROP_ID_APE_SANBOOT_NAME = "ape_SANBoot_name"
	CONST_PROP_ID_APE_SANBOOT_TARGET_LUN = "ape_SANBoot_targetLun"
	CONST_PROP_ID_APE_SANBOOT_TARGET_WWN = "ape_SANBoot_targetWWN"
	CONST_PROP_ID_APE_SANBOOT_TYPE = "ape_SANBoot_type"
	CONST_PROP_ID_APE_SDR_ENTITY_TYPE = "ape_Sdr_entityType"
	CONST_PROP_ID_APE_SDR_EVENT_READING_TYPE = "ape_Sdr_eventReadingType"
	CONST_PROP_ID_APE_SDR_HYSTERISIS_DOWN = "ape_Sdr_hysterisisDown"
	CONST_PROP_ID_APE_SDR_HYSTERISIS_UP = "ape_Sdr_hysterisisUp"
	CONST_PROP_ID_APE_SDR_ID = "ape_Sdr_id"
	CONST_PROP_ID_APE_SDR_INSTANCE = "ape_Sdr_instance"
	CONST_PROP_ID_APE_SDR_NAME = "ape_Sdr_name"
	CONST_PROP_ID_APE_SDR_SENSOR_ID = "ape_Sdr_sensorId"
	CONST_PROP_ID_APE_SDR_SENSOR_TYPE = "ape_Sdr_sensorType"
	CONST_PROP_ID_APE_SDR_THRESHOLD_LC = "ape_Sdr_thresholdLc"
	CONST_PROP_ID_APE_SDR_THRESHOLD_LNC = "ape_Sdr_thresholdLnc"
	CONST_PROP_ID_APE_SDR_THRESHOLD_LNR = "ape_Sdr_thresholdLnr"
	CONST_PROP_ID_APE_SDR_THRESHOLD_UC = "ape_Sdr_thresholdUc"
	CONST_PROP_ID_APE_SDR_THRESHOLD_UNC = "ape_Sdr_thresholdUnc"
	CONST_PROP_ID_APE_SDR_THRESHOLD_UNR = "ape_Sdr_thresholdUnr"
	CONST_PROP_ID_APE_SDR_TYPE = "ape_Sdr_type"
	CONST_PROP_ID_APE_SDR_UNITS = "ape_Sdr_units"
	CONST_PROP_ID_APE_SWITCH_FIRMWARE_INV_BIOS_VERSION = "ape_SwitchFirmwareInv_biosVersion"
	CONST_PROP_ID_APE_SWITCH_FIRMWARE_INV_FABRIC = "ape_SwitchFirmwareInv_fabric"
	CONST_PROP_ID_APE_SWITCH_FIRMWARE_INV_KS_STARTUP_VERSION = "ape_SwitchFirmwareInv_ksStartupVersion"
	CONST_PROP_ID_APE_SWITCH_FIRMWARE_INV_KS_VERSION = "ape_SwitchFirmwareInv_ksVersion"
	CONST_PROP_ID_APE_SWITCH_FIRMWARE_INV_NAME = "ape_SwitchFirmwareInv_name"
	CONST_PROP_ID_APE_SWITCH_FIRMWARE_INV_SYS_STARTUP_VERSION = "ape_SwitchFirmwareInv_sysStartupVersion"
	CONST_PROP_ID_APE_SWITCH_FIRMWARE_INV_SYS_VERSION = "ape_SwitchFirmwareInv_sysVersion"
	CONST_PROP_ID_APE_VIRTUAL_MEDIA_BOOT_CHASSIS_ID = "ape_VirtualMediaBoot_chassisId"
	CONST_PROP_ID_APE_VIRTUAL_MEDIA_BOOT_HOSTNAME = "ape_VirtualMediaBoot_hostname"
	CONST_PROP_ID_APE_VIRTUAL_MEDIA_BOOT_IS_HOST_AGENT_PRESENT = "ape_VirtualMediaBoot_isHostAgentPresent"
	CONST_PROP_ID_APE_VIRTUAL_MEDIA_BOOT_KERNEL_NAME = "ape_VirtualMediaBoot_kernelName"
	CONST_PROP_ID_APE_VIRTUAL_MEDIA_BOOT_KERNEL_RELEASE = "ape_VirtualMediaBoot_kernelRelease"
	CONST_PROP_ID_APE_VIRTUAL_MEDIA_BOOT_KERNEL_VERSION = "ape_VirtualMediaBoot_kernelVersion"
	CONST_PROP_ID_APE_VIRTUAL_MEDIA_BOOT_NAME = "ape_VirtualMediaBoot_name"
	CONST_PROP_ID_APE_VIRTUAL_MEDIA_BOOT_SLOT_ID = "ape_VirtualMediaBoot_slotId"
	CONST_PROP_ID_APE_VIRTUAL_MEDIA_BOOT_TYPE = "ape_VirtualMediaBoot_type"
	CONST_PROP_ID_APE_VNIC_STATS_BYTES_EG = "ape_VnicStats_bytes_eg"
	CONST_PROP_ID_APE_VNIC_STATS_BYTES_IN = "ape_VnicStats_bytes_in"
	CONST_PROP_ID_APE_VNIC_STATS_DROPPED_PKTS_EG = "ape_VnicStats_dropped_pkts_eg"
	CONST_PROP_ID_APE_VNIC_STATS_DROPPED_PKTS_IN = "ape_VnicStats_dropped_pkts_in"
	CONST_PROP_ID_APE_VNIC_STATS_ERRORS_EG = "ape_VnicStats_errors_eg"
	CONST_PROP_ID_APE_VNIC_STATS_ERRORS_IN = "ape_VnicStats_errors_in"
	CONST_PROP_ID_APE_VNIC_STATS_PKTS_EG = "ape_VnicStats_pkts_eg"
	CONST_PROP_ID_APE_VNIC_STATS_PKTS_IN = "ape_VnicStats_pkts_in"
	CONST_PROP_ID_BIOS_AREF_IS_SUPPORTED = "bios_ARef_isSupported"
	CONST_PROP_ID_BIOS_AREF_NAME = "bios_ARef_name"
	CONST_PROP_ID_BIOS_BOT_LAST_UPDATE = "bios_BOT_lastUpdate"
	CONST_PROP_ID_BIOS_BOOT_DEV_GRP_DESCR = "bios_BootDevGrp_descr"
	CONST_PROP_ID_BIOS_BOOT_DEV_GRP_DEVICE_NAME = "bios_BootDevGrp_deviceName"
	CONST_PROP_ID_BIOS_BOOT_DEV_GRP_ERR_VAL = "bios_BootDevGrp_errVal"
	CONST_PROP_ID_BIOS_BOOT_DEV_GRP_ORDER = "bios_BootDevGrp_order"
	CONST_PROP_ID_BIOS_BOOT_DEV_GRP_TYPE = "bios_BootDevGrp_type"
	CONST_PROP_ID_BIOS_BOOT_DEV_DESCR = "bios_BootDev_descr"
	CONST_PROP_ID_BIOS_BOOT_DEV_DEVICE_NAME = "bios_BootDev_deviceName"
	CONST_PROP_ID_BIOS_BOOT_DEV_ERR_VALUE = "bios_BootDev_errValue"
	CONST_PROP_ID_BIOS_BOOT_DEV_ORDER = "bios_BootDev_order"
	CONST_PROP_ID_BIOS_FEATURE_REF_FTR_MO_CLASS_NAME = "bios_FeatureRef_ftrMoClassName"
	CONST_PROP_ID_BIOS_FEATURE_REF_IS_SUPPORTED = "bios_FeatureRef_isSupported"
	CONST_PROP_ID_BIOS_FEATURE_REF_NAME = "bios_FeatureRef_name"
	CONST_PROP_ID_BIOS_PARAMETER_REF_IS_SUPPORTED = "bios_ParameterRef_isSupported"
	CONST_PROP_ID_BIOS_PARAMETER_REF_NAME = "bios_ParameterRef_name"
	CONST_PROP_ID_BIOS_PARAMETER_REF_PROPERTY_NAME = "bios_ParameterRef_propertyName"
	CONST_PROP_ID_BIOS_REF_IS_SUPPORTED = "bios_Ref_isSupported"
	CONST_PROP_ID_BIOS_SETTING_REF_CONSTANT_NAME = "bios_SettingRef_constantName"
	CONST_PROP_ID_BIOS_SETTING_REF_IS_DEFAULT = "bios_SettingRef_isDefault"
	CONST_PROP_ID_BIOS_SETTING_REF_IS_SUPPORTED = "bios_SettingRef_isSupported"
	CONST_PROP_ID_BIOS_SETTING_REF_NAME = "bios_SettingRef_name"
	CONST_PROP_ID_BIOS_UNIT_INIT_SEQ = "bios_Unit_initSeq"
	CONST_PROP_ID_BIOS_UNIT_INIT_TS = "bios_Unit_initTs"
	CONST_PROP_ID_BIOS_UNIT_MODEL = "bios_Unit_model"
	CONST_PROP_ID_BIOS_UNIT_REVISION = "bios_Unit_revision"
	CONST_PROP_ID_BIOS_UNIT_SERIAL = "bios_Unit_serial"
	CONST_PROP_ID_BIOS_UNIT_VENDOR = "bios_Unit_vendor"
	CONST_PROP_ID_BIOS_VIDENTITY_PARAMS_LS_SERVER_NAME = "bios_VIdentityParams_lsServerName"
	CONST_PROP_ID_BIOS_VIDENTITY_PARAMS_LS_SERVER_TMPL_NAME = "bios_VIdentityParams_lsServerTmplName"
	CONST_PROP_ID_BIOS_VIDENTITY_PARAMS_SYS_NAME = "bios_VIdentityParams_sysName"
	CONST_PROP_ID_BIOS_VPROFILE_DESCR = "bios_VProfile_descr"
	CONST_PROP_ID_BIOS_VPROFILE_INT_ID = "bios_VProfile_intId"
	CONST_PROP_ID_BIOS_VPROFILE_NAME = "bios_VProfile_name"
	CONST_PROP_ID_BIOS_VPROFILE_POLICY_LEVEL = "bios_VProfile_policyLevel"
	CONST_PROP_ID_BIOS_VPROFILE_POLICY_OWNER = "bios_VProfile_policyOwner"
	CONST_PROP_ID_BIOS_VPROFILE_REBOOT_ON_UPDATE = "bios_VProfile_rebootOnUpdate"
	CONST_PROP_ID_BIOS_VF_ACPI10_SUPPORT_VP_ACPI10_SUPPORT = "bios_VfACPI10Support_vpACPI10Support"
	CONST_PROP_ID_BIOS_VF_ASSERT_NMION_PERR_VP_ASSERT_NMION_PERR = "bios_VfAssertNMIOnPERR_vpAssertNMIOnPERR"
	CONST_PROP_ID_BIOS_VF_ASSERT_NMION_SERR_VP_ASSERT_NMION_SERR = "bios_VfAssertNMIOnSERR_vpAssertNMIOnSERR"
	CONST_PROP_ID_BIOS_VF_BOOT_OPTION_RETRY_VP_BOOT_OPTION_RETRY = "bios_VfBootOptionRetry_vpBootOptionRetry"
	CONST_PROP_ID_BIOS_VF_CPUPERFORMANCE_VP_CPUPERFORMANCE = "bios_VfCPUPerformance_vpCPUPerformance"
	CONST_PROP_ID_BIOS_VF_CONSOLE_REDIRECTION_VP_BAUD_RATE = "bios_VfConsoleRedirection_vpBaudRate"
	CONST_PROP_ID_BIOS_VF_CONSOLE_REDIRECTION_VP_CONSOLE_REDIRECTION = "bios_VfConsoleRedirection_vpConsoleRedirection"
	CONST_PROP_ID_BIOS_VF_CONSOLE_REDIRECTION_VP_FLOW_CONTROL = "bios_VfConsoleRedirection_vpFlowControl"
	CONST_PROP_ID_BIOS_VF_CONSOLE_REDIRECTION_VP_LEGACY_OSREDIRECTION = "bios_VfConsoleRedirection_vpLegacyOSRedirection"
	CONST_PROP_ID_BIOS_VF_CONSOLE_REDIRECTION_VP_TERMINAL_TYPE = "bios_VfConsoleRedirection_vpTerminalType"
	CONST_PROP_ID_BIOS_VF_CORE_MULTI_PROCESSING_VP_CORE_MULTI_PROCESSING = "bios_VfCoreMultiProcessing_vpCoreMultiProcessing"
	CONST_PROP_ID_BIOS_VF_DIRECT_CACHE_ACCESS_VP_DIRECT_CACHE_ACCESS = "bios_VfDirectCacheAccess_vpDirectCacheAccess"
	CONST_PROP_ID_BIOS_VF_DRAM_REFRESH_RATE_VP_DRAM_REFRESH_RATE = "bios_VfDramRefreshRate_vpDramRefreshRate"
	CONST_PROP_ID_BIOS_VF_ENHANCED_INTEL_SPEED_STEP_TECH_VP_ENHANCED_INTEL_SPEED_STEP_TECH = "bios_VfEnhancedIntelSpeedStepTech_vpEnhancedIntelSpeedStepTech"
	CONST_PROP_ID_BIOS_VF_EXECUTE_DISABLE_BIT_VP_EXECUTE_DISABLE_BIT = "bios_VfExecuteDisableBit_vpExecuteDisableBit"
	CONST_PROP_ID_BIOS_VF_FRONT_PANEL_LOCKOUT_VP_FRONT_PANEL_LOCKOUT = "bios_VfFrontPanelLockout_vpFrontPanelLockout"
	CONST_PROP_ID_BIOS_VF_INTEL_ENTRY_SASRAIDMODULE_VP_SASRAID = "bios_VfIntelEntrySASRAIDModule_vpSASRAID"
	CONST_PROP_ID_BIOS_VF_INTEL_ENTRY_SASRAIDMODULE_VP_SASRAIDMODULE = "bios_VfIntelEntrySASRAIDModule_vpSASRAIDModule"
	CONST_PROP_ID_BIOS_VF_INTEL_HYPER_THREADING_TECH_VP_INTEL_HYPER_THREADING_TECH = "bios_VfIntelHyperThreadingTech_vpIntelHyperThreadingTech"
	CONST_PROP_ID_BIOS_VF_INTEL_TURBO_BOOST_TECH_VP_INTEL_TURBO_BOOST_TECH = "bios_VfIntelTurboBoostTech_vpIntelTurboBoostTech"
	CONST_PROP_ID_BIOS_VF_INTEL_VTFOR_DIRECTED_IO_VP_INTEL_VTDATSSUPPORT = "bios_VfIntelVTForDirectedIO_vpIntelVTDATSSupport"
	CONST_PROP_ID_BIOS_VF_INTEL_VTFOR_DIRECTED_IO_VP_INTEL_VTDCOHERENCY_SUPPORT = "bios_VfIntelVTForDirectedIO_vpIntelVTDCoherencySupport"
	CONST_PROP_ID_BIOS_VF_INTEL_VTFOR_DIRECTED_IO_VP_INTEL_VTDINTERRUPT_REMAPPING = "bios_VfIntelVTForDirectedIO_vpIntelVTDInterruptRemapping"
	CONST_PROP_ID_BIOS_VF_INTEL_VTFOR_DIRECTED_IO_VP_INTEL_VTDPASS_THROUGH_DMASUPPORT = "bios_VfIntelVTForDirectedIO_vpIntelVTDPassThroughDMASupport"
	CONST_PROP_ID_BIOS_VF_INTEL_VTFOR_DIRECTED_IO_VP_INTEL_VTFOR_DIRECTED_IO = "bios_VfIntelVTForDirectedIO_vpIntelVTForDirectedIO"
	CONST_PROP_ID_BIOS_VF_INTEL_VIRTUALIZATION_TECHNOLOGY_VP_INTEL_VIRTUALIZATION_TECHNOLOGY = "bios_VfIntelVirtualizationTechnology_vpIntelVirtualizationTechnology"
	CONST_PROP_ID_BIOS_VF_LOCAL_X2_APIC_VP_LOCAL_X2_APIC = "bios_VfLocalX2Apic_vpLocalX2Apic"
	CONST_PROP_ID_BIOS_VF_LV_DIMMSUPPORT_VP_LV_DDRMODE = "bios_VfLvDIMMSupport_vpLvDDRMode"
	CONST_PROP_ID_BIOS_VF_MAX_VARIABLE_MTRRSETTING_VP_PROCESSOR_MTRR = "bios_VfMaxVariableMTRRSetting_vpProcessorMtrr"
	CONST_PROP_ID_BIOS_VF_MAXIMUM_MEMORY_BELOW4_GB_VP_MAXIMUM_MEMORY_BELOW4_GB = "bios_VfMaximumMemoryBelow4GB_vpMaximumMemoryBelow4GB"
	CONST_PROP_ID_BIOS_VF_MEMORY_MAPPED_IOABOVE4_GB_VP_MEMORY_MAPPED_IOABOVE4_GB = "bios_VfMemoryMappedIOAbove4GB_vpMemoryMappedIOAbove4GB"
	CONST_PROP_ID_BIOS_VF_MIRRORING_MODE_VP_MIRRORING_MODE = "bios_VfMirroringMode_vpMirroringMode"
	CONST_PROP_ID_BIOS_VF_NUMAOPTIMIZED_VP_NUMAOPTIMIZED = "bios_VfNUMAOptimized_vpNUMAOptimized"
	CONST_PROP_ID_BIOS_VF_OSBOOT_WATCHDOG_TIMER_POLICY_VP_OSBOOT_WATCHDOG_TIMER_POLICY = "bios_VfOSBootWatchdogTimerPolicy_vpOSBootWatchdogTimerPolicy"
	CONST_PROP_ID_BIOS_VF_OSBOOT_WATCHDOG_TIMER_TIMEOUT_VP_OSBOOT_WATCHDOG_TIMER_TIMEOUT = "bios_VfOSBootWatchdogTimerTimeout_vpOSBootWatchdogTimerTimeout"
	CONST_PROP_ID_BIOS_VF_OSBOOT_WATCHDOG_TIMER_VP_OSBOOT_WATCHDOG_TIMER = "bios_VfOSBootWatchdogTimer_vpOSBootWatchdogTimer"
	CONST_PROP_ID_BIOS_VF_ONBOARD_SATACONTROLLER_VP_ONBOARD_SATACONTROLLER = "bios_VfOnboardSATAController_vpOnboardSATAController"
	CONST_PROP_ID_BIOS_VF_ONBOARD_SATACONTROLLER_VP_SATAMODE = "bios_VfOnboardSATAController_vpSATAMode"
	CONST_PROP_ID_BIOS_VF_ONBOARD_STORAGE_VP_ONBOARD_SCUSTORAGE_SUPPORT = "bios_VfOnboardStorage_vpOnboardSCUStorageSupport"
	CONST_PROP_ID_BIOS_VF_OPTION_ROMENABLE_VP_STATE = "bios_VfOptionROMEnable_vpState"
	CONST_PROP_ID_BIOS_VF_OPTION_ROMLOAD_VP_LOAD = "bios_VfOptionROMLoad_vpLoad"
	CONST_PROP_ID_BIOS_VF_PCISLOT_OPTION_ROMENABLE_VP_SLOT1_STATE = "bios_VfPCISlotOptionROMEnable_vpSlot1State"
	CONST_PROP_ID_BIOS_VF_PCISLOT_OPTION_ROMENABLE_VP_SLOT2_STATE = "bios_VfPCISlotOptionROMEnable_vpSlot2State"
	CONST_PROP_ID_BIOS_VF_PCISLOT_OPTION_ROMENABLE_VP_SLOT3_STATE = "bios_VfPCISlotOptionROMEnable_vpSlot3State"
	CONST_PROP_ID_BIOS_VF_PCISLOT_OPTION_ROMENABLE_VP_SLOT4_STATE = "bios_VfPCISlotOptionROMEnable_vpSlot4State"
	CONST_PROP_ID_BIOS_VF_PCISLOT_OPTION_ROMENABLE_VP_SLOT5_STATE = "bios_VfPCISlotOptionROMEnable_vpSlot5State"
	CONST_PROP_ID_BIOS_VF_PCISLOT_OPTION_ROMENABLE_VP_SLOT6_STATE = "bios_VfPCISlotOptionROMEnable_vpSlot6State"
	CONST_PROP_ID_BIOS_VF_PCISLOT_OPTION_ROMENABLE_VP_SLOT7_STATE = "bios_VfPCISlotOptionROMEnable_vpSlot7State"
	CONST_PROP_ID_BIOS_VF_PCISLOT_OPTION_ROMENABLE_VP_SLOT_MEZZ_STATE = "bios_VfPCISlotOptionROMEnable_vpSlotMezzState"
	CONST_PROP_ID_BIOS_VF_POSTERROR_PAUSE_VP_POSTERROR_PAUSE = "bios_VfPOSTErrorPause_vpPOSTErrorPause"
	CONST_PROP_ID_BIOS_VF_PACKAGE_CSTATE_LIMIT_VP_PACKAGE_CSTATE_LIMIT = "bios_VfPackageCStateLimit_vpPackageCStateLimit"
	CONST_PROP_ID_BIOS_VF_PROCESSOR_C1_E_VP_PROCESSOR_C1_E = "bios_VfProcessorC1E_vpProcessorC1E"
	CONST_PROP_ID_BIOS_VF_PROCESSOR_C3_REPORT_VP_PROCESSOR_C3_REPORT = "bios_VfProcessorC3Report_vpProcessorC3Report"
	CONST_PROP_ID_BIOS_VF_PROCESSOR_C6_REPORT_VP_PROCESSOR_C6_REPORT = "bios_VfProcessorC6Report_vpProcessorC6Report"
	CONST_PROP_ID_BIOS_VF_PROCESSOR_C7_REPORT_VP_PROCESSOR_C7_REPORT = "bios_VfProcessorC7Report_vpProcessorC7Report"
	CONST_PROP_ID_BIOS_VF_PROCESSOR_CSTATE_VP_PROCESSOR_CSTATE = "bios_VfProcessorCState_vpProcessorCState"
	CONST_PROP_ID_BIOS_VF_QUIET_BOOT_VP_QUIET_BOOT = "bios_VfQuietBoot_vpQuietBoot"
	CONST_PROP_ID_BIOS_VF_RESUME_ON_ACPOWER_LOSS_VP_RESUME_ON_ACPOWER_LOSS = "bios_VfResumeOnACPowerLoss_vpResumeOnACPowerLoss"
	CONST_PROP_ID_BIOS_VF_SELECT_MEMORY_RASCONFIGURATION_VP_SELECT_MEMORY_RASCONFIGURATION = "bios_VfSelectMemoryRASConfiguration_vpSelectMemoryRASConfiguration"
	CONST_PROP_ID_BIOS_VF_SERIAL_PORT_AENABLE_VP_SERIAL_PORT_AENABLE = "bios_VfSerialPortAEnable_vpSerialPortAEnable"
	CONST_PROP_ID_BIOS_VF_SPARING_MODE_VP_SPARING_MODE = "bios_VfSparingMode_vpSparingMode"
	CONST_PROP_ID_BIOS_VF_SRIOV_CONFIG_VP_SRIOV = "bios_VfSriovConfig_vpSriov"
	CONST_PROP_ID_BIOS_VF_UCSMBOOT_MODE_CONTROL_VP_UEFIBOOT_MODE = "bios_VfUCSMBootModeControl_vpUEFIBootMode"
	CONST_PROP_ID_BIOS_VF_UCSMBOOT_ORDER_RULE_CONTROL_VP_UCSMBOOT_ORDER_RULE = "bios_VfUCSMBootOrderRuleControl_vpUCSMBootOrderRule"
	CONST_PROP_ID_BIOS_VF_UEFIOSUSE_LEGACY_VIDEO_VP_UEFIOSUSE_LEGACY_VIDEO = "bios_VfUEFIOSUseLegacyVideo_vpUEFIOSUseLegacyVideo"
	CONST_PROP_ID_BIOS_VF_USBBOOT_CONFIG_VP_LEGACY_USBSUPPORT = "bios_VfUSBBootConfig_vpLegacyUSBSupport"
	CONST_PROP_ID_BIOS_VF_USBBOOT_CONFIG_VP_MAKE_DEVICE_NON_BOOTABLE = "bios_VfUSBBootConfig_vpMakeDeviceNonBootable"
	CONST_PROP_ID_BIOS_VF_USBFRONT_PANEL_ACCESS_LOCK_VP_USBFRONT_PANEL_LOCK = "bios_VfUSBFrontPanelAccessLock_vpUSBFrontPanelLock"
	CONST_PROP_ID_BIOS_VF_USBSYSTEM_IDLE_POWER_OPTIMIZING_SETTING_VP_USBIDLE_POWER_OPTIMIZING = "bios_VfUSBSystemIdlePowerOptimizingSetting_vpUSBIdlePowerOptimizing"
	CONST_PROP_ID_BMC_SELCOUNTER_BITMASK = "bmc_SELCounter_bitmask"
	CONST_PROP_ID_BMC_SELCOUNTER_COLL_INTERVAL = "bmc_SELCounter_collInterval"
	CONST_PROP_ID_BMC_SELCOUNTER_CONT_CLASS_ID = "bmc_SELCounter_contClassId"
	CONST_PROP_ID_BMC_SELCOUNTER_CONT_INST_ID = "bmc_SELCounter_contInstId"
	CONST_PROP_ID_BMC_SELCOUNTER_CONT_INST_ID_PROP_ID = "bmc_SELCounter_contInstIdPropId"
	CONST_PROP_ID_BMC_SELCOUNTER_EQPT_CLASS_ID = "bmc_SELCounter_eqptClassId"
	CONST_PROP_ID_BMC_SELCOUNTER_EQPT_INST_ID = "bmc_SELCounter_eqptInstId"
	CONST_PROP_ID_BMC_SELCOUNTER_EQPT_INST_ID_PROP_ID = "bmc_SELCounter_eqptInstIdPropId"
	CONST_PROP_ID_BMC_SELCOUNTER_GLOBAL_ID = "bmc_SELCounter_globalId"
	CONST_PROP_ID_BMC_SELCOUNTER_LOCAL_ID = "bmc_SELCounter_localId"
	CONST_PROP_ID_BMC_SELCOUNTER_PC_GLOBAL_ID = "bmc_SELCounter_pcGlobalId"
	CONST_PROP_ID_BMC_SELCOUNTER_PC_LOCAL_ID = "bmc_SELCounter_pcLocalId"
	CONST_PROP_ID_BMC_SELCOUNTER_STATS_CLASS_ID = "bmc_SELCounter_statsClassId"
	CONST_PROP_ID_BMC_SELCOUNTER_STATS_PROP_ID = "bmc_SELCounter_statsPropId"
	CONST_PROP_ID_BMC_SELCOUNTER_THRESHOLD = "bmc_SELCounter_threshold"
	CONST_PROP_ID_BMC_SELCOUNTER_VALUE = "bmc_SELCounter_value"
	CONST_PROP_ID_CALLHOME_DEST_EMAIL = "callhome_Dest_email"
	CONST_PROP_ID_CALLHOME_EP_FSM_STAGE_DESCR = "callhome_EpFsmStage_descr"
	CONST_PROP_ID_CALLHOME_EP_FSM_STAGE_LAST_UPDATE_TIME = "callhome_EpFsmStage_lastUpdateTime"
	CONST_PROP_ID_CALLHOME_EP_FSM_STAGE_NAME = "callhome_EpFsmStage_name"
	CONST_PROP_ID_CALLHOME_EP_FSM_STAGE_ORDER = "callhome_EpFsmStage_order"
	CONST_PROP_ID_CALLHOME_EP_FSM_STAGE_RETRY = "callhome_EpFsmStage_retry"
	CONST_PROP_ID_CALLHOME_EP_FSM_STAGE_STAGE_STATUS = "callhome_EpFsmStage_stageStatus"
	CONST_PROP_ID_CALLHOME_EP_FSM_TASK_COMPLETION = "callhome_EpFsmTask_completion"
	CONST_PROP_ID_CALLHOME_EP_FSM_TASK_FLAGS = "callhome_EpFsmTask_flags"
	CONST_PROP_ID_CALLHOME_EP_FSM_TASK_ITEM = "callhome_EpFsmTask_item"
	CONST_PROP_ID_CALLHOME_EP_FSM_TASK_SEQ_ID = "callhome_EpFsmTask_seqId"
	CONST_PROP_ID_CALLHOME_EP_FSM_COMPLETION_TIME = "callhome_EpFsm_completionTime"
	CONST_PROP_ID_CALLHOME_EP_FSM_CURRENT_FSM = "callhome_EpFsm_currentFsm"
	CONST_PROP_ID_CALLHOME_EP_FSM_DESCR = "callhome_EpFsm_descr"
	CONST_PROP_ID_CALLHOME_EP_FSM_FSM_STATUS = "callhome_EpFsm_fsmStatus"
	CONST_PROP_ID_CALLHOME_EP_FSM_INSTANCE_ID = "callhome_EpFsm_instanceId"
	CONST_PROP_ID_CALLHOME_EP_FSM_PROGRESS = "callhome_EpFsm_progress"
	CONST_PROP_ID_CALLHOME_EP_FSM_RMT_ERR_CODE = "callhome_EpFsm_rmtErrCode"
	CONST_PROP_ID_CALLHOME_EP_FSM_RMT_ERR_DESCR = "callhome_EpFsm_rmtErrDescr"
	CONST_PROP_ID_CALLHOME_EP_FSM_RMT_RSLT = "callhome_EpFsm_rmtRslt"
	CONST_PROP_ID_CALLHOME_EP_ADMIN_STATE = "callhome_Ep_adminState"
	CONST_PROP_ID_CALLHOME_EP_ALERT_THROTTLING_ADMIN_STATE = "callhome_Ep_alertThrottlingAdminState"
	CONST_PROP_ID_CALLHOME_EP_CONFIG_STATE = "callhome_Ep_configState"
	CONST_PROP_ID_CALLHOME_EP_DESCR = "callhome_Ep_descr"
	CONST_PROP_ID_CALLHOME_EP_FSM_DESCR = "callhome_Ep_fsmDescr"
	CONST_PROP_ID_CALLHOME_EP_FSM_PREV = "callhome_Ep_fsmPrev"
	CONST_PROP_ID_CALLHOME_EP_FSM_PROGR = "callhome_Ep_fsmProgr"
	CONST_PROP_ID_CALLHOME_EP_FSM_RMT_INV_ERR_CODE = "callhome_Ep_fsmRmtInvErrCode"
	CONST_PROP_ID_CALLHOME_EP_FSM_RMT_INV_ERR_DESCR = "callhome_Ep_fsmRmtInvErrDescr"
	CONST_PROP_ID_CALLHOME_EP_FSM_RMT_INV_RSLT = "callhome_Ep_fsmRmtInvRslt"
	CONST_PROP_ID_CALLHOME_EP_FSM_STAGE_DESCR = "callhome_Ep_fsmStageDescr"
	CONST_PROP_ID_CALLHOME_EP_FSM_STAMP = "callhome_Ep_fsmStamp"
	CONST_PROP_ID_CALLHOME_EP_FSM_STATUS = "callhome_Ep_fsmStatus"
	CONST_PROP_ID_CALLHOME_EP_FSM_TRY = "callhome_Ep_fsmTry"
	CONST_PROP_ID_CALLHOME_EP_INT_ID = "callhome_Ep_intId"
	CONST_PROP_ID_CALLHOME_EP_NAME = "callhome_Ep_name"
	CONST_PROP_ID_CALLHOME_EP_POLICY_LEVEL = "callhome_Ep_policyLevel"
	CONST_PROP_ID_CALLHOME_EP_POLICY_OWNER = "callhome_Ep_policyOwner"
	CONST_PROP_ID_CALLHOME_ITEM_DESCR = "callhome_Item_descr"
	CONST_PROP_ID_CALLHOME_ITEM_NAME = "callhome_Item_name"
	CONST_PROP_ID_CALLHOME_PERIODIC_SYSTEM_INVENTORY_ADMIN_STATE = "callhome_PeriodicSystemInventory_adminState"
	CONST_PROP_ID_CALLHOME_PERIODIC_SYSTEM_INVENTORY_INTERVAL_DAYS = "callhome_PeriodicSystemInventory_intervalDays"
	CONST_PROP_ID_CALLHOME_PERIODIC_SYSTEM_INVENTORY_LAST_DEADLINE = "callhome_PeriodicSystemInventory_lastDeadline"
	CONST_PROP_ID_CALLHOME_PERIODIC_SYSTEM_INVENTORY_MAXIMUM_RETRY_COUNT = "callhome_PeriodicSystemInventory_maximumRetryCount"
	CONST_PROP_ID_CALLHOME_PERIODIC_SYSTEM_INVENTORY_MINIMUM_SEND_NOW_INTERVAL_SECONDS = "callhome_PeriodicSystemInventory_minimumSendNowIntervalSeconds"
	CONST_PROP_ID_CALLHOME_PERIODIC_SYSTEM_INVENTORY_NEXT_DEADLINE = "callhome_PeriodicSystemInventory_nextDeadline"
	CONST_PROP_ID_CALLHOME_PERIODIC_SYSTEM_INVENTORY_POLL_INTERVAL_SECONDS = "callhome_PeriodicSystemInventory_pollIntervalSeconds"
	CONST_PROP_ID_CALLHOME_PERIODIC_SYSTEM_INVENTORY_RETRY_COUNT = "callhome_PeriodicSystemInventory_retryCount"
	CONST_PROP_ID_CALLHOME_PERIODIC_SYSTEM_INVENTORY_RETRY_DELAY_MINUTES = "callhome_PeriodicSystemInventory_retryDelayMinutes"
	CONST_PROP_ID_CALLHOME_PERIODIC_SYSTEM_INVENTORY_SEND_NOW = "callhome_PeriodicSystemInventory_sendNow"
	CONST_PROP_ID_CALLHOME_PERIODIC_SYSTEM_INVENTORY_TIME_OF_DAY_HOUR = "callhome_PeriodicSystemInventory_timeOfDayHour"
	CONST_PROP_ID_CALLHOME_PERIODIC_SYSTEM_INVENTORY_TIME_OF_DAY_MINUTE = "callhome_PeriodicSystemInventory_timeOfDayMinute"
	CONST_PROP_ID_CALLHOME_PERIODIC_SYSTEM_INVENTORY_TIME_OF_LAST_ATTEMPT = "callhome_PeriodicSystemInventory_timeOfLastAttempt"
	CONST_PROP_ID_CALLHOME_PERIODIC_SYSTEM_INVENTORY_TIME_OF_LAST_SUCCESS = "callhome_PeriodicSystemInventory_timeOfLastSuccess"
	CONST_PROP_ID_CALLHOME_POLICY_ADMIN_STATE = "callhome_Policy_adminState"
	CONST_PROP_ID_CALLHOME_POLICY_CAUSE = "callhome_Policy_cause"
	CONST_PROP_ID_CALLHOME_POLICY_DESCR = "callhome_Policy_descr"
	CONST_PROP_ID_CALLHOME_POLICY_NAME = "callhome_Policy_name"
	CONST_PROP_ID_CALLHOME_PROFILE_ALERT_GROUPS = "callhome_Profile_alertGroups"
	CONST_PROP_ID_CALLHOME_PROFILE_DESCR = "callhome_Profile_descr"
	CONST_PROP_ID_CALLHOME_PROFILE_FORMAT = "callhome_Profile_format"
	CONST_PROP_ID_CALLHOME_PROFILE_LEVEL = "callhome_Profile_level"
	CONST_PROP_ID_CALLHOME_PROFILE_MAX_SIZE = "callhome_Profile_maxSize"
	CONST_PROP_ID_CALLHOME_PROFILE_NAME = "callhome_Profile_name"
	CONST_PROP_ID_CALLHOME_SMTP_HOST = "callhome_Smtp_host"
	CONST_PROP_ID_CALLHOME_SMTP_PORT = "callhome_Smtp_port"
	CONST_PROP_ID_CALLHOME_SOURCE_ADDR = "callhome_Source_addr"
	CONST_PROP_ID_CALLHOME_SOURCE_CONTACT = "callhome_Source_contact"
	CONST_PROP_ID_CALLHOME_SOURCE_CONTRACT = "callhome_Source_contract"
	CONST_PROP_ID_CALLHOME_SOURCE_CUSTOMER = "callhome_Source_customer"
	CONST_PROP_ID_CALLHOME_SOURCE_EMAIL = "callhome_Source_email"
	CONST_PROP_ID_CALLHOME_SOURCE_FROM = "callhome_Source_from"
	CONST_PROP_ID_CALLHOME_SOURCE_PHONE = "callhome_Source_phone"
	CONST_PROP_ID_CALLHOME_SOURCE_REPLY_TO = "callhome_Source_replyTo"
	CONST_PROP_ID_CALLHOME_SOURCE_SITE = "callhome_Source_site"
	CONST_PROP_ID_CALLHOME_SOURCE_URGENCY = "callhome_Source_urgency"
	CONST_PROP_ID_CALLHOME_TEST_ALERT_DESCRIPTION = "callhome_TestAlert_description"
	CONST_PROP_ID_CALLHOME_TEST_ALERT_GROUP = "callhome_TestAlert_group"
	CONST_PROP_ID_CALLHOME_TEST_ALERT_LEVEL = "callhome_TestAlert_level"
	CONST_PROP_ID_CALLHOME_TEST_ALERT_MESSAGE_SUBTYPE = "callhome_TestAlert_messageSubtype"
	CONST_PROP_ID_CALLHOME_TEST_ALERT_MESSAGE_TYPE = "callhome_TestAlert_messageType"
	CONST_PROP_ID_CALLHOME_TEST_ALERT_SEND_NOW = "callhome_TestAlert_sendNow"
	CONST_PROP_ID_CAPABILITY_CATALOGUE_FSM_STAGE_DESCR = "capability_CatalogueFsmStage_descr"
	CONST_PROP_ID_CAPABILITY_CATALOGUE_FSM_STAGE_LAST_UPDATE_TIME = "capability_CatalogueFsmStage_lastUpdateTime"
	CONST_PROP_ID_CAPABILITY_CATALOGUE_FSM_STAGE_NAME = "capability_CatalogueFsmStage_name"
	CONST_PROP_ID_CAPABILITY_CATALOGUE_FSM_STAGE_ORDER = "capability_CatalogueFsmStage_order"
	CONST_PROP_ID_CAPABILITY_CATALOGUE_FSM_STAGE_RETRY = "capability_CatalogueFsmStage_retry"
	CONST_PROP_ID_CAPABILITY_CATALOGUE_FSM_STAGE_STAGE_STATUS = "capability_CatalogueFsmStage_stageStatus"
	CONST_PROP_ID_CAPABILITY_CATALOGUE_FSM_TASK_COMPLETION = "capability_CatalogueFsmTask_completion"
	CONST_PROP_ID_CAPABILITY_CATALOGUE_FSM_TASK_FLAGS = "capability_CatalogueFsmTask_flags"
	CONST_PROP_ID_CAPABILITY_CATALOGUE_FSM_TASK_ITEM = "capability_CatalogueFsmTask_item"
	CONST_PROP_ID_CAPABILITY_CATALOGUE_FSM_TASK_SEQ_ID = "capability_CatalogueFsmTask_seqId"
	CONST_PROP_ID_CAPABILITY_CATALOGUE_FSM_COMPLETION_TIME = "capability_CatalogueFsm_completionTime"
	CONST_PROP_ID_CAPABILITY_CATALOGUE_FSM_CURRENT_FSM = "capability_CatalogueFsm_currentFsm"
	CONST_PROP_ID_CAPABILITY_CATALOGUE_FSM_DESCR = "capability_CatalogueFsm_descr"
	CONST_PROP_ID_CAPABILITY_CATALOGUE_FSM_FSM_STATUS = "capability_CatalogueFsm_fsmStatus"
	CONST_PROP_ID_CAPABILITY_CATALOGUE_FSM_INSTANCE_ID = "capability_CatalogueFsm_instanceId"
	CONST_PROP_ID_CAPABILITY_CATALOGUE_FSM_PROGRESS = "capability_CatalogueFsm_progress"
	CONST_PROP_ID_CAPABILITY_CATALOGUE_FSM_RMT_ERR_CODE = "capability_CatalogueFsm_rmtErrCode"
	CONST_PROP_ID_CAPABILITY_CATALOGUE_FSM_RMT_ERR_DESCR = "capability_CatalogueFsm_rmtErrDescr"
	CONST_PROP_ID_CAPABILITY_CATALOGUE_FSM_RMT_RSLT = "capability_CatalogueFsm_rmtRslt"
	CONST_PROP_ID_CAPABILITY_CATALOGUE_LOAD_STATS_FILE_PARSE_FAILURES = "capability_CatalogueLoadStats_fileParseFailures"
	CONST_PROP_ID_CAPABILITY_CATALOGUE_LOAD_STATS_FILES_PARSED = "capability_CatalogueLoadStats_filesParsed"
	CONST_PROP_ID_CAPABILITY_CATALOGUE_LOAD_STATS_PROVIDER_LOAD_FAILURES = "capability_CatalogueLoadStats_providerLoadFailures"
	CONST_PROP_ID_CAPABILITY_CATALOGUE_LOAD_STATS_PROVIDERS_LOADED = "capability_CatalogueLoadStats_providersLoaded"
	CONST_PROP_ID_CAPABILITY_CATALOGUE_FILE_PARSE_FAILURES = "capability_Catalogue_fileParseFailures"
	CONST_PROP_ID_CAPABILITY_CATALOGUE_FILES_PARSED = "capability_Catalogue_filesParsed"
	CONST_PROP_ID_CAPABILITY_CATALOGUE_FSM_DESCR = "capability_Catalogue_fsmDescr"
	CONST_PROP_ID_CAPABILITY_CATALOGUE_FSM_PREV = "capability_Catalogue_fsmPrev"
	CONST_PROP_ID_CAPABILITY_CATALOGUE_FSM_PROGR = "capability_Catalogue_fsmProgr"
	CONST_PROP_ID_CAPABILITY_CATALOGUE_FSM_RMT_INV_ERR_CODE = "capability_Catalogue_fsmRmtInvErrCode"
	CONST_PROP_ID_CAPABILITY_CATALOGUE_FSM_RMT_INV_ERR_DESCR = "capability_Catalogue_fsmRmtInvErrDescr"
	CONST_PROP_ID_CAPABILITY_CATALOGUE_FSM_RMT_INV_RSLT = "capability_Catalogue_fsmRmtInvRslt"
	CONST_PROP_ID_CAPABILITY_CATALOGUE_FSM_STAGE_DESCR = "capability_Catalogue_fsmStageDescr"
	CONST_PROP_ID_CAPABILITY_CATALOGUE_FSM_STAMP = "capability_Catalogue_fsmStamp"
	CONST_PROP_ID_CAPABILITY_CATALOGUE_FSM_STATUS = "capability_Catalogue_fsmStatus"
	CONST_PROP_ID_CAPABILITY_CATALOGUE_FSM_TRY = "capability_Catalogue_fsmTry"
	CONST_PROP_ID_CAPABILITY_CATALOGUE_LOAD_ERRORS = "capability_Catalogue_loadErrors"
	CONST_PROP_ID_CAPABILITY_CATALOGUE_LOAD_WARNINGS = "capability_Catalogue_loadWarnings"
	CONST_PROP_ID_CAPABILITY_CATALOGUE_PROVIDER_LOAD_FAILURES = "capability_Catalogue_providerLoadFailures"
	CONST_PROP_ID_CAPABILITY_CATALOGUE_PROVIDERS_LOADED = "capability_Catalogue_providersLoaded"
	CONST_PROP_ID_CAPABILITY_CATALOGUE_VERSION = "capability_Catalogue_version"
	CONST_PROP_ID_CAPABILITY_DEF_DESCR = "capability_Def_descr"
	CONST_PROP_ID_CAPABILITY_DEF_INT_ID = "capability_Def_intId"
	CONST_PROP_ID_CAPABILITY_DEF_NAME = "capability_Def_name"
	CONST_PROP_ID_CAPABILITY_DEF_POLICY_LEVEL = "capability_Def_policyLevel"
	CONST_PROP_ID_CAPABILITY_DEF_POLICY_OWNER = "capability_Def_policyOwner"
	CONST_PROP_ID_CAPABILITY_FEATURE_LIMITS_DESCR = "capability_FeatureLimits_descr"
	CONST_PROP_ID_CAPABILITY_FEATURE_LIMITS_FEATURE_STATUS = "capability_FeatureLimits_featureStatus"
	CONST_PROP_ID_CAPABILITY_FEATURE_LIMITS_LIMIT = "capability_FeatureLimits_limit"
	CONST_PROP_ID_CAPABILITY_FEATURE_LIMITS_NAME = "capability_FeatureLimits_name"
	CONST_PROP_ID_CAPABILITY_FEATURE_LIMITS_PLATFORM = "capability_FeatureLimits_platform"
	CONST_PROP_ID_CAPABILITY_LOAD_STATS_LOAD_ERRORS = "capability_LoadStats_loadErrors"
	CONST_PROP_ID_CAPABILITY_LOAD_STATS_LOAD_WARNINGS = "capability_LoadStats_loadWarnings"
	CONST_PROP_ID_CAPABILITY_MGMT_EXTENSION_FSM_STAGE_DESCR = "capability_MgmtExtensionFsmStage_descr"
	CONST_PROP_ID_CAPABILITY_MGMT_EXTENSION_FSM_STAGE_LAST_UPDATE_TIME = "capability_MgmtExtensionFsmStage_lastUpdateTime"
	CONST_PROP_ID_CAPABILITY_MGMT_EXTENSION_FSM_STAGE_NAME = "capability_MgmtExtensionFsmStage_name"
	CONST_PROP_ID_CAPABILITY_MGMT_EXTENSION_FSM_STAGE_ORDER = "capability_MgmtExtensionFsmStage_order"
	CONST_PROP_ID_CAPABILITY_MGMT_EXTENSION_FSM_STAGE_RETRY = "capability_MgmtExtensionFsmStage_retry"
	CONST_PROP_ID_CAPABILITY_MGMT_EXTENSION_FSM_STAGE_STAGE_STATUS = "capability_MgmtExtensionFsmStage_stageStatus"
	CONST_PROP_ID_CAPABILITY_MGMT_EXTENSION_FSM_TASK_COMPLETION = "capability_MgmtExtensionFsmTask_completion"
	CONST_PROP_ID_CAPABILITY_MGMT_EXTENSION_FSM_TASK_FLAGS = "capability_MgmtExtensionFsmTask_flags"
	CONST_PROP_ID_CAPABILITY_MGMT_EXTENSION_FSM_TASK_ITEM = "capability_MgmtExtensionFsmTask_item"
	CONST_PROP_ID_CAPABILITY_MGMT_EXTENSION_FSM_TASK_SEQ_ID = "capability_MgmtExtensionFsmTask_seqId"
	CONST_PROP_ID_CAPABILITY_MGMT_EXTENSION_FSM_COMPLETION_TIME = "capability_MgmtExtensionFsm_completionTime"
	CONST_PROP_ID_CAPABILITY_MGMT_EXTENSION_FSM_CURRENT_FSM = "capability_MgmtExtensionFsm_currentFsm"
	CONST_PROP_ID_CAPABILITY_MGMT_EXTENSION_FSM_DESCR = "capability_MgmtExtensionFsm_descr"
	CONST_PROP_ID_CAPABILITY_MGMT_EXTENSION_FSM_FSM_STATUS = "capability_MgmtExtensionFsm_fsmStatus"
	CONST_PROP_ID_CAPABILITY_MGMT_EXTENSION_FSM_INSTANCE_ID = "capability_MgmtExtensionFsm_instanceId"
	CONST_PROP_ID_CAPABILITY_MGMT_EXTENSION_FSM_PROGRESS = "capability_MgmtExtensionFsm_progress"
	CONST_PROP_ID_CAPABILITY_MGMT_EXTENSION_FSM_RMT_ERR_CODE = "capability_MgmtExtensionFsm_rmtErrCode"
	CONST_PROP_ID_CAPABILITY_MGMT_EXTENSION_FSM_RMT_ERR_DESCR = "capability_MgmtExtensionFsm_rmtErrDescr"
	CONST_PROP_ID_CAPABILITY_MGMT_EXTENSION_FSM_RMT_RSLT = "capability_MgmtExtensionFsm_rmtRslt"
	CONST_PROP_ID_CAPABILITY_MGMT_EXTENSION_FSM_DESCR = "capability_MgmtExtension_fsmDescr"
	CONST_PROP_ID_CAPABILITY_MGMT_EXTENSION_FSM_PREV = "capability_MgmtExtension_fsmPrev"
	CONST_PROP_ID_CAPABILITY_MGMT_EXTENSION_FSM_PROGR = "capability_MgmtExtension_fsmProgr"
	CONST_PROP_ID_CAPABILITY_MGMT_EXTENSION_FSM_RMT_INV_ERR_CODE = "capability_MgmtExtension_fsmRmtInvErrCode"
	CONST_PROP_ID_CAPABILITY_MGMT_EXTENSION_FSM_RMT_INV_ERR_DESCR = "capability_MgmtExtension_fsmRmtInvErrDescr"
	CONST_PROP_ID_CAPABILITY_MGMT_EXTENSION_FSM_RMT_INV_RSLT = "capability_MgmtExtension_fsmRmtInvRslt"
	CONST_PROP_ID_CAPABILITY_MGMT_EXTENSION_FSM_STAGE_DESCR = "capability_MgmtExtension_fsmStageDescr"
	CONST_PROP_ID_CAPABILITY_MGMT_EXTENSION_FSM_STAMP = "capability_MgmtExtension_fsmStamp"
	CONST_PROP_ID_CAPABILITY_MGMT_EXTENSION_FSM_STATUS = "capability_MgmtExtension_fsmStatus"
	CONST_PROP_ID_CAPABILITY_MGMT_EXTENSION_FSM_TRY = "capability_MgmtExtension_fsmTry"
	CONST_PROP_ID_CAPABILITY_PROVIDER_LOAD_STATS_ELEMENT_LOAD_FAILURES = "capability_ProviderLoadStats_elementLoadFailures"
	CONST_PROP_ID_CAPABILITY_PROVIDER_LOAD_STATS_ELEMENTS_LOADED = "capability_ProviderLoadStats_elementsLoaded"
	CONST_PROP_ID_CAPABILITY_PROVIDER_DELETED = "capability_Provider_deleted"
	CONST_PROP_ID_CAPABILITY_PROVIDER_DEPRECATED = "capability_Provider_deprecated"
	CONST_PROP_ID_CAPABILITY_PROVIDER_ELEMENT_LOAD_FAILURES = "capability_Provider_elementLoadFailures"
	CONST_PROP_ID_CAPABILITY_PROVIDER_ELEMENTS_LOADED = "capability_Provider_elementsLoaded"
	CONST_PROP_ID_CAPABILITY_PROVIDER_GENCOUNT = "capability_Provider_gencount"
	CONST_PROP_ID_CAPABILITY_PROVIDER_LOAD_ERRORS = "capability_Provider_loadErrors"
	CONST_PROP_ID_CAPABILITY_PROVIDER_LOAD_WARNINGS = "capability_Provider_loadWarnings"
	CONST_PROP_ID_CAPABILITY_PROVIDER_MGMT_PLANE_VER = "capability_Provider_mgmtPlaneVer"
	CONST_PROP_ID_CAPABILITY_PROVIDER_MODEL = "capability_Provider_model"
	CONST_PROP_ID_CAPABILITY_PROVIDER_VENDOR = "capability_Provider_vendor"
	CONST_PROP_ID_CAPABILITY_UPDATE_IMAGE_NAME = "capability_Update_imageName"
	CONST_PROP_ID_CAPABILITY_UPDATE_UPDATE_TS = "capability_Update_updateTs"
	CONST_PROP_ID_CAPABILITY_UPDATE_VERSION = "capability_Update_version"
	CONST_PROP_ID_CAPABILITY_UPDATER_FSM_STAGE_DESCR = "capability_UpdaterFsmStage_descr"
	CONST_PROP_ID_CAPABILITY_UPDATER_FSM_STAGE_LAST_UPDATE_TIME = "capability_UpdaterFsmStage_lastUpdateTime"
	CONST_PROP_ID_CAPABILITY_UPDATER_FSM_STAGE_NAME = "capability_UpdaterFsmStage_name"
	CONST_PROP_ID_CAPABILITY_UPDATER_FSM_STAGE_ORDER = "capability_UpdaterFsmStage_order"
	CONST_PROP_ID_CAPABILITY_UPDATER_FSM_STAGE_RETRY = "capability_UpdaterFsmStage_retry"
	CONST_PROP_ID_CAPABILITY_UPDATER_FSM_STAGE_STAGE_STATUS = "capability_UpdaterFsmStage_stageStatus"
	CONST_PROP_ID_CAPABILITY_UPDATER_FSM_TASK_COMPLETION = "capability_UpdaterFsmTask_completion"
	CONST_PROP_ID_CAPABILITY_UPDATER_FSM_TASK_FLAGS = "capability_UpdaterFsmTask_flags"
	CONST_PROP_ID_CAPABILITY_UPDATER_FSM_TASK_ITEM = "capability_UpdaterFsmTask_item"
	CONST_PROP_ID_CAPABILITY_UPDATER_FSM_TASK_SEQ_ID = "capability_UpdaterFsmTask_seqId"
	CONST_PROP_ID_CAPABILITY_UPDATER_FSM_COMPLETION_TIME = "capability_UpdaterFsm_completionTime"
	CONST_PROP_ID_CAPABILITY_UPDATER_FSM_CURRENT_FSM = "capability_UpdaterFsm_currentFsm"
	CONST_PROP_ID_CAPABILITY_UPDATER_FSM_DESCR = "capability_UpdaterFsm_descr"
	CONST_PROP_ID_CAPABILITY_UPDATER_FSM_FSM_STATUS = "capability_UpdaterFsm_fsmStatus"
	CONST_PROP_ID_CAPABILITY_UPDATER_FSM_INSTANCE_ID = "capability_UpdaterFsm_instanceId"
	CONST_PROP_ID_CAPABILITY_UPDATER_FSM_PROGRESS = "capability_UpdaterFsm_progress"
	CONST_PROP_ID_CAPABILITY_UPDATER_FSM_RMT_ERR_CODE = "capability_UpdaterFsm_rmtErrCode"
	CONST_PROP_ID_CAPABILITY_UPDATER_FSM_RMT_ERR_DESCR = "capability_UpdaterFsm_rmtErrDescr"
	CONST_PROP_ID_CAPABILITY_UPDATER_FSM_RMT_RSLT = "capability_UpdaterFsm_rmtRslt"
	CONST_PROP_ID_CAPABILITY_UPDATER_ADMIN_STATE = "capability_Updater_adminState"
	CONST_PROP_ID_CAPABILITY_UPDATER_FILE_NAME = "capability_Updater_fileName"
	CONST_PROP_ID_CAPABILITY_UPDATER_FSM_DESCR = "capability_Updater_fsmDescr"
	CONST_PROP_ID_CAPABILITY_UPDATER_FSM_PREV = "capability_Updater_fsmPrev"
	CONST_PROP_ID_CAPABILITY_UPDATER_FSM_PROGR = "capability_Updater_fsmProgr"
	CONST_PROP_ID_CAPABILITY_UPDATER_FSM_RMT_INV_ERR_CODE = "capability_Updater_fsmRmtInvErrCode"
	CONST_PROP_ID_CAPABILITY_UPDATER_FSM_RMT_INV_ERR_DESCR = "capability_Updater_fsmRmtInvErrDescr"
	CONST_PROP_ID_CAPABILITY_UPDATER_FSM_RMT_INV_RSLT = "capability_Updater_fsmRmtInvRslt"
	CONST_PROP_ID_CAPABILITY_UPDATER_FSM_STAGE_DESCR = "capability_Updater_fsmStageDescr"
	CONST_PROP_ID_CAPABILITY_UPDATER_FSM_STAMP = "capability_Updater_fsmStamp"
	CONST_PROP_ID_CAPABILITY_UPDATER_FSM_STATUS = "capability_Updater_fsmStatus"
	CONST_PROP_ID_CAPABILITY_UPDATER_FSM_TRY = "capability_Updater_fsmTry"
	CONST_PROP_ID_CAPABILITY_UPDATER_IMAGE_NAME = "capability_Updater_imageName"
	CONST_PROP_ID_CAPABILITY_UPDATER_OPER_STATE = "capability_Updater_operState"
	CONST_PROP_ID_CAPABILITY_UPDATER_PROTOCOL = "capability_Updater_protocol"
	CONST_PROP_ID_CAPABILITY_UPDATER_PWD = "capability_Updater_pwd"
	CONST_PROP_ID_CAPABILITY_UPDATER_REMOTE_PATH = "capability_Updater_remotePath"
	CONST_PROP_ID_CAPABILITY_UPDATER_SERVER = "capability_Updater_server"
	CONST_PROP_ID_CAPABILITY_UPDATER_USER = "capability_Updater_user"
	CONST_PROP_ID_CAPABILITY_UPDATER_VERSION = "capability_Updater_version"
	CONST_PROP_ID_CHANGE_CHANGED_OBJECT_REF_CENTRALE_MO_DN = "change_ChangedObjectRef_centraleMoDn"
	CONST_PROP_ID_CHANGE_CHANGED_OBJECT_REF_CHANGED_MO_CLASS_ID = "change_ChangedObjectRef_changedMoClassId"
	CONST_PROP_ID_CHANGE_CHANGED_OBJECT_REF_GUID = "change_ChangedObjectRef_guid"
	CONST_PROP_ID_CHANGE_CHANGED_OBJECT_REF_ID = "change_ChangedObjectRef_id"
	CONST_PROP_ID_CHANGE_CHANGED_OBJECT_REF_OLD_CENTRALE_MO_DN = "change_ChangedObjectRef_oldCentraleMoDn"
	CONST_PROP_ID_CHANGE_CHANGED_OBJECT_REF_REF_OBJ_STATUS = "change_ChangedObjectRef_refObjStatus"
	CONST_PROP_ID_CHANGE_CHANGED_OBJECT_REF_UCSM_MO_DN = "change_ChangedObjectRef_ucsmMoDn"
	CONST_PROP_ID_CLITEST_TYPE_TEST2_A_PARTIAL_ENUM = "clitest_TypeTest2_aPartialEnum"
	CONST_PROP_ID_CLITEST_TYPE_TEST2_ABITMASK = "clitest_TypeTest2_abitmask"
	CONST_PROP_ID_CLITEST_TYPE_TEST2_ACHARBUF = "clitest_TypeTest2_acharbuf"
	CONST_PROP_ID_CLITEST_TYPE_TEST2_FILE_DIR = "clitest_TypeTest2_fileDir"
	CONST_PROP_ID_CLITEST_TYPE_TEST2_FILE_HOST = "clitest_TypeTest2_fileHost"
	CONST_PROP_ID_CLITEST_TYPE_TEST2_FILE_NAME = "clitest_TypeTest2_fileName"
	CONST_PROP_ID_CLITEST_TYPE_TEST2_FILE_PASSWD = "clitest_TypeTest2_filePasswd"
	CONST_PROP_ID_CLITEST_TYPE_TEST2_FILE_PATH = "clitest_TypeTest2_filePath"
	CONST_PROP_ID_CLITEST_TYPE_TEST2_FILE_PORT = "clitest_TypeTest2_filePort"
	CONST_PROP_ID_CLITEST_TYPE_TEST2_FILE_PROTO = "clitest_TypeTest2_fileProto"
	CONST_PROP_ID_CLITEST_TYPE_TEST2_FILE_USER = "clitest_TypeTest2_fileUser"
	CONST_PROP_ID_CLITEST_TYPE_TEST_CHILD_ASTRING = "clitest_TypeTestChild_astring"
	CONST_PROP_ID_CLITEST_TYPE_TEST_CHILD_DESCR = "clitest_TypeTestChild_descr"
	CONST_PROP_ID_CLITEST_TYPE_TEST_CHILD_INT_ID = "clitest_TypeTestChild_intId"
	CONST_PROP_ID_CLITEST_TYPE_TEST_CHILD_NAME = "clitest_TypeTestChild_name"
	CONST_PROP_ID_CLITEST_TYPE_TEST_CHILD_POLICY_LEVEL = "clitest_TypeTestChild_policyLevel"
	CONST_PROP_ID_CLITEST_TYPE_TEST_CHILD_POLICY_OWNER = "clitest_TypeTestChild_policyOwner"
	CONST_PROP_ID_CLITEST_TYPE_TEST_PARENT_ASTRING = "clitest_TypeTestParent_astring"
	CONST_PROP_ID_CLITEST_TYPE_TEST_PARENT_DESCR = "clitest_TypeTestParent_descr"
	CONST_PROP_ID_CLITEST_TYPE_TEST_PARENT_INT_ID = "clitest_TypeTestParent_intId"
	CONST_PROP_ID_CLITEST_TYPE_TEST_PARENT_NAME = "clitest_TypeTestParent_name"
	CONST_PROP_ID_CLITEST_TYPE_TEST_PARENT_POLICY_LEVEL = "clitest_TypeTestParent_policyLevel"
	CONST_PROP_ID_CLITEST_TYPE_TEST_PARENT_POLICY_OWNER = "clitest_TypeTestParent_policyOwner"
	CONST_PROP_ID_CLITEST_TYPE_TEST_ACHAR = "clitest_TypeTest_achar"
	CONST_PROP_ID_CLITEST_TYPE_TEST_ADATE = "clitest_TypeTest_adate"
	CONST_PROP_ID_CLITEST_TYPE_TEST_ADATETIME = "clitest_TypeTest_adatetime"
	CONST_PROP_ID_CLITEST_TYPE_TEST_AFLOAT = "clitest_TypeTest_afloat"
	CONST_PROP_ID_CLITEST_TYPE_TEST_AMAC = "clitest_TypeTest_amac"
	CONST_PROP_ID_CLITEST_TYPE_TEST_ANENUM = "clitest_TypeTest_anenum"
	CONST_PROP_ID_CLITEST_TYPE_TEST_ANIPV4 = "clitest_TypeTest_anipv4"
	CONST_PROP_ID_CLITEST_TYPE_TEST_ANIPV6 = "clitest_TypeTest_anipv6"
	CONST_PROP_ID_CLITEST_TYPE_TEST_ANSBYTE = "clitest_TypeTest_ansbyte"
	CONST_PROP_ID_CLITEST_TYPE_TEST_ANSINT16 = "clitest_TypeTest_ansint16"
	CONST_PROP_ID_CLITEST_TYPE_TEST_ANSINT32 = "clitest_TypeTest_ansint32"
	CONST_PROP_ID_CLITEST_TYPE_TEST_ANSINT64 = "clitest_TypeTest_ansint64"
	CONST_PROP_ID_CLITEST_TYPE_TEST_APASSWORD = "clitest_TypeTest_apassword"
	CONST_PROP_ID_CLITEST_TYPE_TEST_ARANGE = "clitest_TypeTest_arange"
	CONST_PROP_ID_CLITEST_TYPE_TEST_ARCSTRING = "clitest_TypeTest_arcstring"
	CONST_PROP_ID_CLITEST_TYPE_TEST_ARXSTRING = "clitest_TypeTest_arxstring"
	CONST_PROP_ID_CLITEST_TYPE_TEST_ASTRING = "clitest_TypeTest_astring"
	CONST_PROP_ID_CLITEST_TYPE_TEST_ATIME = "clitest_TypeTest_atime"
	CONST_PROP_ID_CLITEST_TYPE_TEST_AUBYTE = "clitest_TypeTest_aubyte"
	CONST_PROP_ID_CLITEST_TYPE_TEST_AUINT16 = "clitest_TypeTest_auint16"
	CONST_PROP_ID_CLITEST_TYPE_TEST_AUINT32 = "clitest_TypeTest_auint32"
	CONST_PROP_ID_CLITEST_TYPE_TEST_AUINT64 = "clitest_TypeTest_auint64"
	CONST_PROP_ID_CLITEST_TYPE_TEST_AWWN = "clitest_TypeTest_awwn"
	CONST_PROP_ID_COMM_CIMC_WEB_SERVICE_ADMIN_STATE = "comm_CimcWebService_adminState"
	CONST_PROP_ID_COMM_CIMC_WEB_SERVICE_DESCR = "comm_CimcWebService_descr"
	CONST_PROP_ID_COMM_CIMC_WEB_SERVICE_INT_ID = "comm_CimcWebService_intId"
	CONST_PROP_ID_COMM_CIMC_WEB_SERVICE_NAME = "comm_CimcWebService_name"
	CONST_PROP_ID_COMM_CIMC_WEB_SERVICE_OPER_PORT = "comm_CimcWebService_operPort"
	CONST_PROP_ID_COMM_CIMC_WEB_SERVICE_POLICY_LEVEL = "comm_CimcWebService_policyLevel"
	CONST_PROP_ID_COMM_CIMC_WEB_SERVICE_POLICY_OWNER = "comm_CimcWebService_policyOwner"
	CONST_PROP_ID_COMM_CIMC_WEB_SERVICE_PORT = "comm_CimcWebService_port"
	CONST_PROP_ID_COMM_CIMC_WEB_SERVICE_PROTO = "comm_CimcWebService_proto"
	CONST_PROP_ID_COMM_CIMXML_ADMIN_STATE = "comm_Cimxml_adminState"
	CONST_PROP_ID_COMM_CIMXML_DESCR = "comm_Cimxml_descr"
	CONST_PROP_ID_COMM_CIMXML_INT_ID = "comm_Cimxml_intId"
	CONST_PROP_ID_COMM_CIMXML_NAME = "comm_Cimxml_name"
	CONST_PROP_ID_COMM_CIMXML_OPER_PORT = "comm_Cimxml_operPort"
	CONST_PROP_ID_COMM_CIMXML_POLICY_LEVEL = "comm_Cimxml_policyLevel"
	CONST_PROP_ID_COMM_CIMXML_POLICY_OWNER = "comm_Cimxml_policyOwner"
	CONST_PROP_ID_COMM_CIMXML_PORT = "comm_Cimxml_port"
	CONST_PROP_ID_COMM_CIMXML_PROTO = "comm_Cimxml_proto"
	CONST_PROP_ID_COMM_CLIENT_ITEM_ADMIN_STATE = "comm_ClientItem_adminState"
	CONST_PROP_ID_COMM_CLIENT_ITEM_DESCR = "comm_ClientItem_descr"
	CONST_PROP_ID_COMM_CLIENT_ITEM_HOSTNAME = "comm_ClientItem_hostname"
	CONST_PROP_ID_COMM_CLIENT_ITEM_NAME = "comm_ClientItem_name"
	CONST_PROP_ID_COMM_CLIENT_ADMIN_STATE = "comm_Client_adminState"
	CONST_PROP_ID_COMM_CLIENT_DESCR = "comm_Client_descr"
	CONST_PROP_ID_COMM_CLIENT_HOSTNAME = "comm_Client_hostname"
	CONST_PROP_ID_COMM_CLIENT_INT_ID = "comm_Client_intId"
	CONST_PROP_ID_COMM_CLIENT_NAME = "comm_Client_name"
	CONST_PROP_ID_COMM_CLIENT_POLICY_LEVEL = "comm_Client_policyLevel"
	CONST_PROP_ID_COMM_CLIENT_POLICY_OWNER = "comm_Client_policyOwner"
	CONST_PROP_ID_COMM_DATE_TIME_ADMIN_STATE = "comm_DateTime_adminState"
	CONST_PROP_ID_COMM_DATE_TIME_CONFIG_STATE = "comm_DateTime_configState"
	CONST_PROP_ID_COMM_DATE_TIME_DATE = "comm_DateTime_date"
	CONST_PROP_ID_COMM_DATE_TIME_DESCR = "comm_DateTime_descr"
	CONST_PROP_ID_COMM_DATE_TIME_INT_ID = "comm_DateTime_intId"
	CONST_PROP_ID_COMM_DATE_TIME_NAME = "comm_DateTime_name"
	CONST_PROP_ID_COMM_DATE_TIME_OPER_PORT = "comm_DateTime_operPort"
	CONST_PROP_ID_COMM_DATE_TIME_OPER_TIMEZONE = "comm_DateTime_operTimezone"
	CONST_PROP_ID_COMM_DATE_TIME_POLICY_LEVEL = "comm_DateTime_policyLevel"
	CONST_PROP_ID_COMM_DATE_TIME_POLICY_OWNER = "comm_DateTime_policyOwner"
	CONST_PROP_ID_COMM_DATE_TIME_PORT = "comm_DateTime_port"
	CONST_PROP_ID_COMM_DATE_TIME_PROTO = "comm_DateTime_proto"
	CONST_PROP_ID_COMM_DATE_TIME_TIMEZONE = "comm_DateTime_timezone"
	CONST_PROP_ID_COMM_DEFINITION_DESCR = "comm_Definition_descr"
	CONST_PROP_ID_COMM_DEFINITION_INT_ID = "comm_Definition_intId"
	CONST_PROP_ID_COMM_DEFINITION_NAME = "comm_Definition_name"
	CONST_PROP_ID_COMM_DEFINITION_POLICY_LEVEL = "comm_Definition_policyLevel"
	CONST_PROP_ID_COMM_DEFINITION_POLICY_OWNER = "comm_Definition_policyOwner"
	CONST_PROP_ID_COMM_DNS_PROVIDER_ADMIN_STATE = "comm_DnsProvider_adminState"
	CONST_PROP_ID_COMM_DNS_PROVIDER_DESCR = "comm_DnsProvider_descr"
	CONST_PROP_ID_COMM_DNS_PROVIDER_HOSTNAME = "comm_DnsProvider_hostname"
	CONST_PROP_ID_COMM_DNS_PROVIDER_NAME = "comm_DnsProvider_name"
	CONST_PROP_ID_COMM_DNS_ADMIN_STATE = "comm_Dns_adminState"
	CONST_PROP_ID_COMM_DNS_DESCR = "comm_Dns_descr"
	CONST_PROP_ID_COMM_DNS_DOMAIN = "comm_Dns_domain"
	CONST_PROP_ID_COMM_DNS_INT_ID = "comm_Dns_intId"
	CONST_PROP_ID_COMM_DNS_NAME = "comm_Dns_name"
	CONST_PROP_ID_COMM_DNS_OPER_PORT = "comm_Dns_operPort"
	CONST_PROP_ID_COMM_DNS_POLICY_LEVEL = "comm_Dns_policyLevel"
	CONST_PROP_ID_COMM_DNS_POLICY_OWNER = "comm_Dns_policyOwner"
	CONST_PROP_ID_COMM_DNS_PORT = "comm_Dns_port"
	CONST_PROP_ID_COMM_DNS_PROTO = "comm_Dns_proto"
	CONST_PROP_ID_COMM_EVT_CHANNEL_CHANNEL_STATE = "comm_EvtChannel_channelState"
	CONST_PROP_ID_COMM_EVT_CHANNEL_DESCR = "comm_EvtChannel_descr"
	CONST_PROP_ID_COMM_EVT_CHANNEL_INT_ID = "comm_EvtChannel_intId"
	CONST_PROP_ID_COMM_EVT_CHANNEL_NAME = "comm_EvtChannel_name"
	CONST_PROP_ID_COMM_EVT_CHANNEL_POLICY_LEVEL = "comm_EvtChannel_policyLevel"
	CONST_PROP_ID_COMM_EVT_CHANNEL_POLICY_OWNER = "comm_EvtChannel_policyOwner"
	CONST_PROP_ID_COMM_HTTP_ADMIN_STATE = "comm_Http_adminState"
	CONST_PROP_ID_COMM_HTTP_DESCR = "comm_Http_descr"
	CONST_PROP_ID_COMM_HTTP_INT_ID = "comm_Http_intId"
	CONST_PROP_ID_COMM_HTTP_NAME = "comm_Http_name"
	CONST_PROP_ID_COMM_HTTP_OPER_PORT = "comm_Http_operPort"
	CONST_PROP_ID_COMM_HTTP_POLICY_LEVEL = "comm_Http_policyLevel"
	CONST_PROP_ID_COMM_HTTP_POLICY_OWNER = "comm_Http_policyOwner"
	CONST_PROP_ID_COMM_HTTP_PORT = "comm_Http_port"
	CONST_PROP_ID_COMM_HTTP_PROTO = "comm_Http_proto"
	CONST_PROP_ID_COMM_HTTP_REDIRECT_STATE = "comm_Http_redirectState"
	CONST_PROP_ID_COMM_HTTPS_ADMIN_STATE = "comm_Https_adminState"
	CONST_PROP_ID_COMM_HTTPS_CIPHER_SUITE = "comm_Https_cipherSuite"
	CONST_PROP_ID_COMM_HTTPS_CIPHER_SUITE_MODE = "comm_Https_cipherSuiteMode"
	CONST_PROP_ID_COMM_HTTPS_DESCR = "comm_Https_descr"
	CONST_PROP_ID_COMM_HTTPS_INT_ID = "comm_Https_intId"
	CONST_PROP_ID_COMM_HTTPS_KEY_RING = "comm_Https_keyRing"
	CONST_PROP_ID_COMM_HTTPS_NAME = "comm_Https_name"
	CONST_PROP_ID_COMM_HTTPS_OPER_PORT = "comm_Https_operPort"
	CONST_PROP_ID_COMM_HTTPS_POLICY_LEVEL = "comm_Https_policyLevel"
	CONST_PROP_ID_COMM_HTTPS_POLICY_OWNER = "comm_Https_policyOwner"
	CONST_PROP_ID_COMM_HTTPS_PORT = "comm_Https_port"
	CONST_PROP_ID_COMM_HTTPS_PROTO = "comm_Https_proto"
	CONST_PROP_ID_COMM_ITEM_DESCR = "comm_Item_descr"
	CONST_PROP_ID_COMM_ITEM_NAME = "comm_Item_name"
	CONST_PROP_ID_COMM_NTP_PROVIDER_ADMIN_STATE = "comm_NtpProvider_adminState"
	CONST_PROP_ID_COMM_NTP_PROVIDER_DESCR = "comm_NtpProvider_descr"
	CONST_PROP_ID_COMM_NTP_PROVIDER_HOSTNAME = "comm_NtpProvider_hostname"
	CONST_PROP_ID_COMM_NTP_PROVIDER_NAME = "comm_NtpProvider_name"
	CONST_PROP_ID_COMM_SHELL_SVC_LIMITS_DESCR = "comm_ShellSvcLimits_descr"
	CONST_PROP_ID_COMM_SHELL_SVC_LIMITS_INT_ID = "comm_ShellSvcLimits_intId"
	CONST_PROP_ID_COMM_SHELL_SVC_LIMITS_NAME = "comm_ShellSvcLimits_name"
	CONST_PROP_ID_COMM_SHELL_SVC_LIMITS_POLICY_LEVEL = "comm_ShellSvcLimits_policyLevel"
	CONST_PROP_ID_COMM_SHELL_SVC_LIMITS_POLICY_OWNER = "comm_ShellSvcLimits_policyOwner"
	CONST_PROP_ID_COMM_SHELL_SVC_LIMITS_SESSIONS_PER_USER = "comm_ShellSvcLimits_sessionsPerUser"
	CONST_PROP_ID_COMM_SHELL_SVC_LIMITS_TOTAL_SESSIONS = "comm_ShellSvcLimits_totalSessions"
	CONST_PROP_ID_COMM_SHELL_ADMIN_STATE = "comm_Shell_adminState"
	CONST_PROP_ID_COMM_SHELL_DESCR = "comm_Shell_descr"
	CONST_PROP_ID_COMM_SHELL_INT_ID = "comm_Shell_intId"
	CONST_PROP_ID_COMM_SHELL_NAME = "comm_Shell_name"
	CONST_PROP_ID_COMM_SHELL_OPER_PORT = "comm_Shell_operPort"
	CONST_PROP_ID_COMM_SHELL_POLICY_LEVEL = "comm_Shell_policyLevel"
	CONST_PROP_ID_COMM_SHELL_POLICY_OWNER = "comm_Shell_policyOwner"
	CONST_PROP_ID_COMM_SHELL_PORT = "comm_Shell_port"
	CONST_PROP_ID_COMM_SHELL_PROTO = "comm_Shell_proto"
	CONST_PROP_ID_COMM_SMASH_CLP_ADMIN_STATE = "comm_SmashCLP_adminState"
	CONST_PROP_ID_COMM_SMASH_CLP_DESCR = "comm_SmashCLP_descr"
	CONST_PROP_ID_COMM_SMASH_CLP_INT_ID = "comm_SmashCLP_intId"
	CONST_PROP_ID_COMM_SMASH_CLP_NAME = "comm_SmashCLP_name"
	CONST_PROP_ID_COMM_SMASH_CLP_OPER_PORT = "comm_SmashCLP_operPort"
	CONST_PROP_ID_COMM_SMASH_CLP_POLICY_LEVEL = "comm_SmashCLP_policyLevel"
	CONST_PROP_ID_COMM_SMASH_CLP_POLICY_OWNER = "comm_SmashCLP_policyOwner"
	CONST_PROP_ID_COMM_SMASH_CLP_PORT = "comm_SmashCLP_port"
	CONST_PROP_ID_COMM_SMASH_CLP_PROTO = "comm_SmashCLP_proto"
	CONST_PROP_ID_COMM_SNMP_TRAP_COMMUNITY = "comm_SnmpTrap_community"
	CONST_PROP_ID_COMM_SNMP_TRAP_HOSTNAME = "comm_SnmpTrap_hostname"
	CONST_PROP_ID_COMM_SNMP_TRAP_NOTIFICATION_TYPE = "comm_SnmpTrap_notificationType"
	CONST_PROP_ID_COMM_SNMP_TRAP_PORT = "comm_SnmpTrap_port"
	CONST_PROP_ID_COMM_SNMP_TRAP_V3_PRIVILEGE = "comm_SnmpTrap_v3Privilege"
	CONST_PROP_ID_COMM_SNMP_TRAP_VERSION = "comm_SnmpTrap_version"
	CONST_PROP_ID_COMM_SNMP_USER_AUTH = "comm_SnmpUser_auth"
	CONST_PROP_ID_COMM_SNMP_USER_CONFIG_STATE = "comm_SnmpUser_configState"
	CONST_PROP_ID_COMM_SNMP_USER_CONFIG_STATUS_MESSAGE = "comm_SnmpUser_configStatusMessage"
	CONST_PROP_ID_COMM_SNMP_USER_DESCR = "comm_SnmpUser_descr"
	CONST_PROP_ID_COMM_SNMP_USER_NAME = "comm_SnmpUser_name"
	CONST_PROP_ID_COMM_SNMP_USER_PRIV_PWD_SET = "comm_SnmpUser_privPwdSet"
	CONST_PROP_ID_COMM_SNMP_USER_PRIVPWD = "comm_SnmpUser_privpwd"
	CONST_PROP_ID_COMM_SNMP_USER_PWD = "comm_SnmpUser_pwd"
	CONST_PROP_ID_COMM_SNMP_USER_PWD_SET = "comm_SnmpUser_pwdSet"
	CONST_PROP_ID_COMM_SNMP_USER_USE_AES = "comm_SnmpUser_useAes"
	CONST_PROP_ID_COMM_SNMP_ADMIN_STATE = "comm_Snmp_adminState"
	CONST_PROP_ID_COMM_SNMP_COMMUNITY = "comm_Snmp_community"
	CONST_PROP_ID_COMM_SNMP_CONFIG_STATE = "comm_Snmp_configState"
	CONST_PROP_ID_COMM_SNMP_DESCR = "comm_Snmp_descr"
	CONST_PROP_ID_COMM_SNMP_INT_ID = "comm_Snmp_intId"
	CONST_PROP_ID_COMM_SNMP_IS_SET_SNMP_SECURE = "comm_Snmp_isSetSnmpSecure"
	CONST_PROP_ID_COMM_SNMP_NAME = "comm_Snmp_name"
	CONST_PROP_ID_COMM_SNMP_OPER_PORT = "comm_Snmp_operPort"
	CONST_PROP_ID_COMM_SNMP_POLICY_LEVEL = "comm_Snmp_policyLevel"
	CONST_PROP_ID_COMM_SNMP_POLICY_OWNER = "comm_Snmp_policyOwner"
	CONST_PROP_ID_COMM_SNMP_PORT = "comm_Snmp_port"
	CONST_PROP_ID_COMM_SNMP_PROTO = "comm_Snmp_proto"
	CONST_PROP_ID_COMM_SNMP_SYS_CONTACT = "comm_Snmp_sysContact"
	CONST_PROP_ID_COMM_SNMP_SYS_LOCATION = "comm_Snmp_sysLocation"
	CONST_PROP_ID_COMM_SSH_ADMIN_STATE = "comm_Ssh_adminState"
	CONST_PROP_ID_COMM_SSH_DESCR = "comm_Ssh_descr"
	CONST_PROP_ID_COMM_SSH_INT_ID = "comm_Ssh_intId"
	CONST_PROP_ID_COMM_SSH_NAME = "comm_Ssh_name"
	CONST_PROP_ID_COMM_SSH_OPER_PORT = "comm_Ssh_operPort"
	CONST_PROP_ID_COMM_SSH_POLICY_LEVEL = "comm_Ssh_policyLevel"
	CONST_PROP_ID_COMM_SSH_POLICY_OWNER = "comm_Ssh_policyOwner"
	CONST_PROP_ID_COMM_SSH_PORT = "comm_Ssh_port"
	CONST_PROP_ID_COMM_SSH_PROTO = "comm_Ssh_proto"
	CONST_PROP_ID_COMM_SVC_CHANNEL_CHANNEL_STATE = "comm_SvcChannel_channelState"
	CONST_PROP_ID_COMM_SVC_CHANNEL_DESCR = "comm_SvcChannel_descr"
	CONST_PROP_ID_COMM_SVC_CHANNEL_INT_ID = "comm_SvcChannel_intId"
	CONST_PROP_ID_COMM_SVC_CHANNEL_NAME = "comm_SvcChannel_name"
	CONST_PROP_ID_COMM_SVC_CHANNEL_POLICY_LEVEL = "comm_SvcChannel_policyLevel"
	CONST_PROP_ID_COMM_SVC_CHANNEL_POLICY_OWNER = "comm_SvcChannel_policyOwner"
	CONST_PROP_ID_COMM_SVC_EP_FSM_STAGE_DESCR = "comm_SvcEpFsmStage_descr"
	CONST_PROP_ID_COMM_SVC_EP_FSM_STAGE_LAST_UPDATE_TIME = "comm_SvcEpFsmStage_lastUpdateTime"
	CONST_PROP_ID_COMM_SVC_EP_FSM_STAGE_NAME = "comm_SvcEpFsmStage_name"
	CONST_PROP_ID_COMM_SVC_EP_FSM_STAGE_ORDER = "comm_SvcEpFsmStage_order"
	CONST_PROP_ID_COMM_SVC_EP_FSM_STAGE_RETRY = "comm_SvcEpFsmStage_retry"
	CONST_PROP_ID_COMM_SVC_EP_FSM_STAGE_STAGE_STATUS = "comm_SvcEpFsmStage_stageStatus"
	CONST_PROP_ID_COMM_SVC_EP_FSM_TASK_COMPLETION = "comm_SvcEpFsmTask_completion"
	CONST_PROP_ID_COMM_SVC_EP_FSM_TASK_FLAGS = "comm_SvcEpFsmTask_flags"
	CONST_PROP_ID_COMM_SVC_EP_FSM_TASK_ITEM = "comm_SvcEpFsmTask_item"
	CONST_PROP_ID_COMM_SVC_EP_FSM_TASK_SEQ_ID = "comm_SvcEpFsmTask_seqId"
	CONST_PROP_ID_COMM_SVC_EP_FSM_COMPLETION_TIME = "comm_SvcEpFsm_completionTime"
	CONST_PROP_ID_COMM_SVC_EP_FSM_CURRENT_FSM = "comm_SvcEpFsm_currentFsm"
	CONST_PROP_ID_COMM_SVC_EP_FSM_DESCR = "comm_SvcEpFsm_descr"
	CONST_PROP_ID_COMM_SVC_EP_FSM_FSM_STATUS = "comm_SvcEpFsm_fsmStatus"
	CONST_PROP_ID_COMM_SVC_EP_FSM_INSTANCE_ID = "comm_SvcEpFsm_instanceId"
	CONST_PROP_ID_COMM_SVC_EP_FSM_PROGRESS = "comm_SvcEpFsm_progress"
	CONST_PROP_ID_COMM_SVC_EP_FSM_RMT_ERR_CODE = "comm_SvcEpFsm_rmtErrCode"
	CONST_PROP_ID_COMM_SVC_EP_FSM_RMT_ERR_DESCR = "comm_SvcEpFsm_rmtErrDescr"
	CONST_PROP_ID_COMM_SVC_EP_FSM_RMT_RSLT = "comm_SvcEpFsm_rmtRslt"
	CONST_PROP_ID_COMM_SVC_EP_CONFIG_STATE = "comm_SvcEp_configState"
	CONST_PROP_ID_COMM_SVC_EP_CONFIG_STATUS_MESSAGE = "comm_SvcEp_configStatusMessage"
	CONST_PROP_ID_COMM_SVC_EP_DESCR = "comm_SvcEp_descr"
	CONST_PROP_ID_COMM_SVC_EP_FSM_DESCR = "comm_SvcEp_fsmDescr"
	CONST_PROP_ID_COMM_SVC_EP_FSM_FLAGS = "comm_SvcEp_fsmFlags"
	CONST_PROP_ID_COMM_SVC_EP_FSM_PREV = "comm_SvcEp_fsmPrev"
	CONST_PROP_ID_COMM_SVC_EP_FSM_PROGR = "comm_SvcEp_fsmProgr"
	CONST_PROP_ID_COMM_SVC_EP_FSM_RMT_INV_ERR_CODE = "comm_SvcEp_fsmRmtInvErrCode"
	CONST_PROP_ID_COMM_SVC_EP_FSM_RMT_INV_ERR_DESCR = "comm_SvcEp_fsmRmtInvErrDescr"
	CONST_PROP_ID_COMM_SVC_EP_FSM_RMT_INV_RSLT = "comm_SvcEp_fsmRmtInvRslt"
	CONST_PROP_ID_COMM_SVC_EP_FSM_STAGE_DESCR = "comm_SvcEp_fsmStageDescr"
	CONST_PROP_ID_COMM_SVC_EP_FSM_STAMP = "comm_SvcEp_fsmStamp"
	CONST_PROP_ID_COMM_SVC_EP_FSM_STATUS = "comm_SvcEp_fsmStatus"
	CONST_PROP_ID_COMM_SVC_EP_FSM_TRY = "comm_SvcEp_fsmTry"
	CONST_PROP_ID_COMM_SVC_EP_INT_ID = "comm_SvcEp_intId"
	CONST_PROP_ID_COMM_SVC_EP_NAME = "comm_SvcEp_name"
	CONST_PROP_ID_COMM_SVC_EP_POLICY_LEVEL = "comm_SvcEp_policyLevel"
	CONST_PROP_ID_COMM_SVC_EP_POLICY_OWNER = "comm_SvcEp_policyOwner"
	CONST_PROP_ID_COMM_SVC_LIMITS_DESCR = "comm_SvcLimits_descr"
	CONST_PROP_ID_COMM_SVC_LIMITS_INT_ID = "comm_SvcLimits_intId"
	CONST_PROP_ID_COMM_SVC_LIMITS_NAME = "comm_SvcLimits_name"
	CONST_PROP_ID_COMM_SVC_LIMITS_POLICY_LEVEL = "comm_SvcLimits_policyLevel"
	CONST_PROP_ID_COMM_SVC_LIMITS_POLICY_OWNER = "comm_SvcLimits_policyOwner"
	CONST_PROP_ID_COMM_SVC_LIMITS_SESSIONS_PER_USER = "comm_SvcLimits_sessionsPerUser"
	CONST_PROP_ID_COMM_SVC_LIMITS_TOTAL_SESSIONS = "comm_SvcLimits_totalSessions"
	CONST_PROP_ID_COMM_SVC_ADMIN_STATE = "comm_Svc_adminState"
	CONST_PROP_ID_COMM_SVC_DESCR = "comm_Svc_descr"
	CONST_PROP_ID_COMM_SVC_INT_ID = "comm_Svc_intId"
	CONST_PROP_ID_COMM_SVC_NAME = "comm_Svc_name"
	CONST_PROP_ID_COMM_SVC_OPER_PORT = "comm_Svc_operPort"
	CONST_PROP_ID_COMM_SVC_POLICY_LEVEL = "comm_Svc_policyLevel"
	CONST_PROP_ID_COMM_SVC_POLICY_OWNER = "comm_Svc_policyOwner"
	CONST_PROP_ID_COMM_SVC_PORT = "comm_Svc_port"
	CONST_PROP_ID_COMM_SVC_PROTO = "comm_Svc_proto"
	CONST_PROP_ID_COMM_SYSLOG_CLIENT_ADMIN_STATE = "comm_SyslogClient_adminState"
	CONST_PROP_ID_COMM_SYSLOG_CLIENT_FORWARDING_FACILITY = "comm_SyslogClient_forwardingFacility"
	CONST_PROP_ID_COMM_SYSLOG_CLIENT_HOSTNAME = "comm_SyslogClient_hostname"
	CONST_PROP_ID_COMM_SYSLOG_CLIENT_NAME = "comm_SyslogClient_name"
	CONST_PROP_ID_COMM_SYSLOG_CLIENT_SEVERITY = "comm_SyslogClient_severity"
	CONST_PROP_ID_COMM_SYSLOG_CONSOLE_ADMIN_STATE = "comm_SyslogConsole_adminState"
	CONST_PROP_ID_COMM_SYSLOG_CONSOLE_DESCR = "comm_SyslogConsole_descr"
	CONST_PROP_ID_COMM_SYSLOG_CONSOLE_NAME = "comm_SyslogConsole_name"
	CONST_PROP_ID_COMM_SYSLOG_CONSOLE_SEVERITY = "comm_SyslogConsole_severity"
	CONST_PROP_ID_COMM_SYSLOG_FILE_ADMIN_STATE = "comm_SyslogFile_adminState"
	CONST_PROP_ID_COMM_SYSLOG_FILE_DESCR = "comm_SyslogFile_descr"
	CONST_PROP_ID_COMM_SYSLOG_FILE_NAME = "comm_SyslogFile_name"
	CONST_PROP_ID_COMM_SYSLOG_FILE_SEVERITY = "comm_SyslogFile_severity"
	CONST_PROP_ID_COMM_SYSLOG_FILE_SIZE = "comm_SyslogFile_size"
	CONST_PROP_ID_COMM_SYSLOG_MONITOR_ADMIN_STATE = "comm_SyslogMonitor_adminState"
	CONST_PROP_ID_COMM_SYSLOG_MONITOR_DESCR = "comm_SyslogMonitor_descr"
	CONST_PROP_ID_COMM_SYSLOG_MONITOR_NAME = "comm_SyslogMonitor_name"
	CONST_PROP_ID_COMM_SYSLOG_MONITOR_SEVERITY = "comm_SyslogMonitor_severity"
	CONST_PROP_ID_COMM_SYSLOG_SOURCE_AUDITS = "comm_SyslogSource_audits"
	CONST_PROP_ID_COMM_SYSLOG_SOURCE_DESCR = "comm_SyslogSource_descr"
	CONST_PROP_ID_COMM_SYSLOG_SOURCE_EVENTS = "comm_SyslogSource_events"
	CONST_PROP_ID_COMM_SYSLOG_SOURCE_FAULTS = "comm_SyslogSource_faults"
	CONST_PROP_ID_COMM_SYSLOG_SOURCE_NAME = "comm_SyslogSource_name"
	CONST_PROP_ID_COMM_SYSLOG_ADMIN_STATE = "comm_Syslog_adminState"
	CONST_PROP_ID_COMM_SYSLOG_DESCR = "comm_Syslog_descr"
	CONST_PROP_ID_COMM_SYSLOG_INT_ID = "comm_Syslog_intId"
	CONST_PROP_ID_COMM_SYSLOG_NAME = "comm_Syslog_name"
	CONST_PROP_ID_COMM_SYSLOG_OPER_PORT = "comm_Syslog_operPort"
	CONST_PROP_ID_COMM_SYSLOG_POLICY_LEVEL = "comm_Syslog_policyLevel"
	CONST_PROP_ID_COMM_SYSLOG_POLICY_OWNER = "comm_Syslog_policyOwner"
	CONST_PROP_ID_COMM_SYSLOG_PORT = "comm_Syslog_port"
	CONST_PROP_ID_COMM_SYSLOG_PROTO = "comm_Syslog_proto"
	CONST_PROP_ID_COMM_SYSLOG_SEVERITY = "comm_Syslog_severity"
	CONST_PROP_ID_COMM_TELNET_ADMIN_STATE = "comm_Telnet_adminState"
	CONST_PROP_ID_COMM_TELNET_DESCR = "comm_Telnet_descr"
	CONST_PROP_ID_COMM_TELNET_INT_ID = "comm_Telnet_intId"
	CONST_PROP_ID_COMM_TELNET_NAME = "comm_Telnet_name"
	CONST_PROP_ID_COMM_TELNET_OPER_PORT = "comm_Telnet_operPort"
	CONST_PROP_ID_COMM_TELNET_POLICY_LEVEL = "comm_Telnet_policyLevel"
	CONST_PROP_ID_COMM_TELNET_POLICY_OWNER = "comm_Telnet_policyOwner"
	CONST_PROP_ID_COMM_TELNET_PORT = "comm_Telnet_port"
	CONST_PROP_ID_COMM_TELNET_PROTO = "comm_Telnet_proto"
	CONST_PROP_ID_COMM_WEB_CHANNEL_CHANNEL_STATE = "comm_WebChannel_channelState"
	CONST_PROP_ID_COMM_WEB_CHANNEL_DESCR = "comm_WebChannel_descr"
	CONST_PROP_ID_COMM_WEB_CHANNEL_INT_ID = "comm_WebChannel_intId"
	CONST_PROP_ID_COMM_WEB_CHANNEL_NAME = "comm_WebChannel_name"
	CONST_PROP_ID_COMM_WEB_CHANNEL_POLICY_LEVEL = "comm_WebChannel_policyLevel"
	CONST_PROP_ID_COMM_WEB_CHANNEL_POLICY_OWNER = "comm_WebChannel_policyOwner"
	CONST_PROP_ID_COMM_WEB_SVC_LIMITS_DESCR = "comm_WebSvcLimits_descr"
	CONST_PROP_ID_COMM_WEB_SVC_LIMITS_INT_ID = "comm_WebSvcLimits_intId"
	CONST_PROP_ID_COMM_WEB_SVC_LIMITS_NAME = "comm_WebSvcLimits_name"
	CONST_PROP_ID_COMM_WEB_SVC_LIMITS_POLICY_LEVEL = "comm_WebSvcLimits_policyLevel"
	CONST_PROP_ID_COMM_WEB_SVC_LIMITS_POLICY_OWNER = "comm_WebSvcLimits_policyOwner"
	CONST_PROP_ID_COMM_WEB_SVC_LIMITS_SESSIONS_PER_USER = "comm_WebSvcLimits_sessionsPerUser"
	CONST_PROP_ID_COMM_WEB_SVC_LIMITS_TOTAL_SESSIONS = "comm_WebSvcLimits_totalSessions"
	CONST_PROP_ID_COMM_WEB_ADMIN_STATE = "comm_Web_adminState"
	CONST_PROP_ID_COMM_WEB_DESCR = "comm_Web_descr"
	CONST_PROP_ID_COMM_WEB_INT_ID = "comm_Web_intId"
	CONST_PROP_ID_COMM_WEB_NAME = "comm_Web_name"
	CONST_PROP_ID_COMM_WEB_OPER_PORT = "comm_Web_operPort"
	CONST_PROP_ID_COMM_WEB_POLICY_LEVEL = "comm_Web_policyLevel"
	CONST_PROP_ID_COMM_WEB_POLICY_OWNER = "comm_Web_policyOwner"
	CONST_PROP_ID_COMM_WEB_PORT = "comm_Web_port"
	CONST_PROP_ID_COMM_WEB_PROTO = "comm_Web_proto"
	CONST_PROP_ID_COMM_WSMAN_ADMIN_STATE = "comm_Wsman_adminState"
	CONST_PROP_ID_COMM_WSMAN_DESCR = "comm_Wsman_descr"
	CONST_PROP_ID_COMM_WSMAN_INT_ID = "comm_Wsman_intId"
	CONST_PROP_ID_COMM_WSMAN_NAME = "comm_Wsman_name"
	CONST_PROP_ID_COMM_WSMAN_OPER_PORT = "comm_Wsman_operPort"
	CONST_PROP_ID_COMM_WSMAN_POLICY_LEVEL = "comm_Wsman_policyLevel"
	CONST_PROP_ID_COMM_WSMAN_POLICY_OWNER = "comm_Wsman_policyOwner"
	CONST_PROP_ID_COMM_WSMAN_PORT = "comm_Wsman_port"
	CONST_PROP_ID_COMM_WSMAN_PROTO = "comm_Wsman_proto"
	CONST_PROP_ID_COMM_XML_CL_CONN_POLICY_ADMIN_STATE = "comm_XmlClConnPolicy_adminState"
	CONST_PROP_ID_COMM_XML_CL_CONN_POLICY_CLIENT_TYPE = "comm_XmlClConnPolicy_clientType"
	CONST_PROP_ID_COMM_XML_CL_CONN_POLICY_DESCR = "comm_XmlClConnPolicy_descr"
	CONST_PROP_ID_COMM_XML_CL_CONN_POLICY_INT_ID = "comm_XmlClConnPolicy_intId"
	CONST_PROP_ID_COMM_XML_CL_CONN_POLICY_NAME = "comm_XmlClConnPolicy_name"
	CONST_PROP_ID_COMM_XML_CL_CONN_POLICY_OPER_PORT = "comm_XmlClConnPolicy_operPort"
	CONST_PROP_ID_COMM_XML_CL_CONN_POLICY_POLICY_LEVEL = "comm_XmlClConnPolicy_policyLevel"
	CONST_PROP_ID_COMM_XML_CL_CONN_POLICY_POLICY_OWNER = "comm_XmlClConnPolicy_policyOwner"
	CONST_PROP_ID_COMM_XML_CL_CONN_POLICY_PORT = "comm_XmlClConnPolicy_port"
	CONST_PROP_ID_COMM_XML_CL_CONN_POLICY_PROTO = "comm_XmlClConnPolicy_proto"
	CONST_PROP_ID_COMPUTE_ACHASSIS_DISC_POLICY_ACTION = "compute_AChassisDiscPolicy_action"
	CONST_PROP_ID_COMPUTE_ACHASSIS_DISC_POLICY_DESCR = "compute_AChassisDiscPolicy_descr"
	CONST_PROP_ID_COMPUTE_ACHASSIS_DISC_POLICY_INT_ID = "compute_AChassisDiscPolicy_intId"
	CONST_PROP_ID_COMPUTE_ACHASSIS_DISC_POLICY_LINK_AGGREGATION_PREF = "compute_AChassisDiscPolicy_linkAggregationPref"
	CONST_PROP_ID_COMPUTE_ACHASSIS_DISC_POLICY_NAME = "compute_AChassisDiscPolicy_name"
	CONST_PROP_ID_COMPUTE_ACHASSIS_DISC_POLICY_POLICY_LEVEL = "compute_AChassisDiscPolicy_policyLevel"
	CONST_PROP_ID_COMPUTE_ACHASSIS_DISC_POLICY_POLICY_OWNER = "compute_AChassisDiscPolicy_policyOwner"
	CONST_PROP_ID_COMPUTE_ACHASSIS_DISC_POLICY_QUALIFIER = "compute_AChassisDiscPolicy_qualifier"
	CONST_PROP_ID_COMPUTE_AUTOCONFIG_POLICY_DESCR = "compute_AutoconfigPolicy_descr"
	CONST_PROP_ID_COMPUTE_AUTOCONFIG_POLICY_DST_DN = "compute_AutoconfigPolicy_dstDn"
	CONST_PROP_ID_COMPUTE_AUTOCONFIG_POLICY_INT_ID = "compute_AutoconfigPolicy_intId"
	CONST_PROP_ID_COMPUTE_AUTOCONFIG_POLICY_NAME = "compute_AutoconfigPolicy_name"
	CONST_PROP_ID_COMPUTE_AUTOCONFIG_POLICY_POLICY_LEVEL = "compute_AutoconfigPolicy_policyLevel"
	CONST_PROP_ID_COMPUTE_AUTOCONFIG_POLICY_POLICY_OWNER = "compute_AutoconfigPolicy_policyOwner"
	CONST_PROP_ID_COMPUTE_AUTOCONFIG_POLICY_QUALIFIER = "compute_AutoconfigPolicy_qualifier"
	CONST_PROP_ID_COMPUTE_AUTOCONFIG_POLICY_SRC_TEMPL_NAME = "compute_AutoconfigPolicy_srcTemplName"
	CONST_PROP_ID_COMPUTE_BLADE_DISC_POLICY_ACTION = "compute_BladeDiscPolicy_action"
	CONST_PROP_ID_COMPUTE_BLADE_DISC_POLICY_DESCR = "compute_BladeDiscPolicy_descr"
	CONST_PROP_ID_COMPUTE_BLADE_DISC_POLICY_INT_ID = "compute_BladeDiscPolicy_intId"
	CONST_PROP_ID_COMPUTE_BLADE_DISC_POLICY_NAME = "compute_BladeDiscPolicy_name"
	CONST_PROP_ID_COMPUTE_BLADE_DISC_POLICY_POLICY_LEVEL = "compute_BladeDiscPolicy_policyLevel"
	CONST_PROP_ID_COMPUTE_BLADE_DISC_POLICY_POLICY_OWNER = "compute_BladeDiscPolicy_policyOwner"
	CONST_PROP_ID_COMPUTE_BLADE_DISC_POLICY_QUALIFIER = "compute_BladeDiscPolicy_qualifier"
	CONST_PROP_ID_COMPUTE_BLADE_DISC_POLICY_SCRUB_POLICY_NAME = "compute_BladeDiscPolicy_scrubPolicyName"
	CONST_PROP_ID_COMPUTE_BLADE_FSM_STAGE_DESCR = "compute_BladeFsmStage_descr"
	CONST_PROP_ID_COMPUTE_BLADE_FSM_STAGE_LAST_UPDATE_TIME = "compute_BladeFsmStage_lastUpdateTime"
	CONST_PROP_ID_COMPUTE_BLADE_FSM_STAGE_NAME = "compute_BladeFsmStage_name"
	CONST_PROP_ID_COMPUTE_BLADE_FSM_STAGE_ORDER = "compute_BladeFsmStage_order"
	CONST_PROP_ID_COMPUTE_BLADE_FSM_STAGE_RETRY = "compute_BladeFsmStage_retry"
	CONST_PROP_ID_COMPUTE_BLADE_FSM_STAGE_STAGE_STATUS = "compute_BladeFsmStage_stageStatus"
	CONST_PROP_ID_COMPUTE_BLADE_FSM_TASK_COMPLETION = "compute_BladeFsmTask_completion"
	CONST_PROP_ID_COMPUTE_BLADE_FSM_TASK_FLAGS = "compute_BladeFsmTask_flags"
	CONST_PROP_ID_COMPUTE_BLADE_FSM_TASK_ITEM = "compute_BladeFsmTask_item"
	CONST_PROP_ID_COMPUTE_BLADE_FSM_TASK_SEQ_ID = "compute_BladeFsmTask_seqId"
	CONST_PROP_ID_COMPUTE_BLADE_FSM_COMPLETION_TIME = "compute_BladeFsm_completionTime"
	CONST_PROP_ID_COMPUTE_BLADE_FSM_CURRENT_FSM = "compute_BladeFsm_currentFsm"
	CONST_PROP_ID_COMPUTE_BLADE_FSM_DESCR = "compute_BladeFsm_descr"
	CONST_PROP_ID_COMPUTE_BLADE_FSM_FSM_STATUS = "compute_BladeFsm_fsmStatus"
	CONST_PROP_ID_COMPUTE_BLADE_FSM_INSTANCE_ID = "compute_BladeFsm_instanceId"
	CONST_PROP_ID_COMPUTE_BLADE_FSM_PROGRESS = "compute_BladeFsm_progress"
	CONST_PROP_ID_COMPUTE_BLADE_FSM_RMT_ERR_CODE = "compute_BladeFsm_rmtErrCode"
	CONST_PROP_ID_COMPUTE_BLADE_FSM_RMT_ERR_DESCR = "compute_BladeFsm_rmtErrDescr"
	CONST_PROP_ID_COMPUTE_BLADE_FSM_RMT_RSLT = "compute_BladeFsm_rmtRslt"
	CONST_PROP_ID_COMPUTE_BLADE_INHERIT_POLICY_DESCR = "compute_BladeInheritPolicy_descr"
	CONST_PROP_ID_COMPUTE_BLADE_INHERIT_POLICY_DST_DN = "compute_BladeInheritPolicy_dstDn"
	CONST_PROP_ID_COMPUTE_BLADE_INHERIT_POLICY_INT_ID = "compute_BladeInheritPolicy_intId"
	CONST_PROP_ID_COMPUTE_BLADE_INHERIT_POLICY_NAME = "compute_BladeInheritPolicy_name"
	CONST_PROP_ID_COMPUTE_BLADE_INHERIT_POLICY_POLICY_LEVEL = "compute_BladeInheritPolicy_policyLevel"
	CONST_PROP_ID_COMPUTE_BLADE_INHERIT_POLICY_POLICY_OWNER = "compute_BladeInheritPolicy_policyOwner"
	CONST_PROP_ID_COMPUTE_BLADE_INHERIT_POLICY_QUALIFIER = "compute_BladeInheritPolicy_qualifier"
	CONST_PROP_ID_COMPUTE_BLADE_POS_QUAL_MAX_ID = "compute_BladePosQual_maxId"
	CONST_PROP_ID_COMPUTE_BLADE_POS_QUAL_MIN_ID = "compute_BladePosQual_minId"
	CONST_PROP_ID_COMPUTE_BLADE_ADMIN_POWER = "compute_Blade_adminPower"
	CONST_PROP_ID_COMPUTE_BLADE_ADMIN_STATE = "compute_Blade_adminState"
	CONST_PROP_ID_COMPUTE_BLADE_ASSIGNED_TO_DN = "compute_Blade_assignedToDn"
	CONST_PROP_ID_COMPUTE_BLADE_ASSOCIATION = "compute_Blade_association"
	CONST_PROP_ID_COMPUTE_BLADE_AVAILABILITY = "compute_Blade_availability"
	CONST_PROP_ID_COMPUTE_BLADE_AVAILABLE_MEMORY = "compute_Blade_availableMemory"
	CONST_PROP_ID_COMPUTE_BLADE_CHASSIS_ID = "compute_Blade_chassisId"
	CONST_PROP_ID_COMPUTE_BLADE_CHECK_POINT = "compute_Blade_checkPoint"
	CONST_PROP_ID_COMPUTE_BLADE_CONN_PATH = "compute_Blade_connPath"
	CONST_PROP_ID_COMPUTE_BLADE_CONN_STATUS = "compute_Blade_connStatus"
	CONST_PROP_ID_COMPUTE_BLADE_DESCR = "compute_Blade_descr"
	CONST_PROP_ID_COMPUTE_BLADE_DISCOVERY = "compute_Blade_discovery"
	CONST_PROP_ID_COMPUTE_BLADE_FLT_AGGR = "compute_Blade_fltAggr"
	CONST_PROP_ID_COMPUTE_BLADE_FSM_DESCR = "compute_Blade_fsmDescr"
	CONST_PROP_ID_COMPUTE_BLADE_FSM_FLAGS = "compute_Blade_fsmFlags"
	CONST_PROP_ID_COMPUTE_BLADE_FSM_PREV = "compute_Blade_fsmPrev"
	CONST_PROP_ID_COMPUTE_BLADE_FSM_PROGR = "compute_Blade_fsmProgr"
	CONST_PROP_ID_COMPUTE_BLADE_FSM_RMT_INV_ERR_CODE = "compute_Blade_fsmRmtInvErrCode"
	CONST_PROP_ID_COMPUTE_BLADE_FSM_RMT_INV_ERR_DESCR = "compute_Blade_fsmRmtInvErrDescr"
	CONST_PROP_ID_COMPUTE_BLADE_FSM_RMT_INV_RSLT = "compute_Blade_fsmRmtInvRslt"
	CONST_PROP_ID_COMPUTE_BLADE_FSM_STAGE_DESCR = "compute_Blade_fsmStageDescr"
	CONST_PROP_ID_COMPUTE_BLADE_FSM_STAMP = "compute_Blade_fsmStamp"
	CONST_PROP_ID_COMPUTE_BLADE_FSM_STATUS = "compute_Blade_fsmStatus"
	CONST_PROP_ID_COMPUTE_BLADE_FSM_TRY = "compute_Blade_fsmTry"
	CONST_PROP_ID_COMPUTE_BLADE_INT_ID = "compute_Blade_intId"
	CONST_PROP_ID_COMPUTE_BLADE_LC = "compute_Blade_lc"
	CONST_PROP_ID_COMPUTE_BLADE_LC_TS = "compute_Blade_lcTs"
	CONST_PROP_ID_COMPUTE_BLADE_LOCAL_ID = "compute_Blade_localId"
	CONST_PROP_ID_COMPUTE_BLADE_LOW_VOLTAGE_MEMORY = "compute_Blade_lowVoltageMemory"
	CONST_PROP_ID_COMPUTE_BLADE_MANAGING_INST = "compute_Blade_managingInst"
	CONST_PROP_ID_COMPUTE_BLADE_MEMORY_SPEED = "compute_Blade_memorySpeed"
	CONST_PROP_ID_COMPUTE_BLADE_MFG_TIME = "compute_Blade_mfgTime"
	CONST_PROP_ID_COMPUTE_BLADE_MODEL = "compute_Blade_model"
	CONST_PROP_ID_COMPUTE_BLADE_NAME = "compute_Blade_name"
	CONST_PROP_ID_COMPUTE_BLADE_NUM_OF_ADAPTORS = "compute_Blade_numOfAdaptors"
	CONST_PROP_ID_COMPUTE_BLADE_NUM_OF_CORES = "compute_Blade_numOfCores"
	CONST_PROP_ID_COMPUTE_BLADE_NUM_OF_CORES_ENABLED = "compute_Blade_numOfCoresEnabled"
	CONST_PROP_ID_COMPUTE_BLADE_NUM_OF_CPUS = "compute_Blade_numOfCpus"
	CONST_PROP_ID_COMPUTE_BLADE_NUM_OF_ETH_HOST_IFS = "compute_Blade_numOfEthHostIfs"
	CONST_PROP_ID_COMPUTE_BLADE_NUM_OF_FC_HOST_IFS = "compute_Blade_numOfFcHostIfs"
	CONST_PROP_ID_COMPUTE_BLADE_NUM_OF_THREADS = "compute_Blade_numOfThreads"
	CONST_PROP_ID_COMPUTE_BLADE_OPER_POWER = "compute_Blade_operPower"
	CONST_PROP_ID_COMPUTE_BLADE_OPER_QUALIFIER = "compute_Blade_operQualifier"
	CONST_PROP_ID_COMPUTE_BLADE_OPER_STATE = "compute_Blade_operState"
	CONST_PROP_ID_COMPUTE_BLADE_OPERABILITY = "compute_Blade_operability"
	CONST_PROP_ID_COMPUTE_BLADE_ORIGINAL_UUID = "compute_Blade_originalUuid"
	CONST_PROP_ID_COMPUTE_BLADE_PART_NUMBER = "compute_Blade_partNumber"
	CONST_PROP_ID_COMPUTE_BLADE_POLICY_LEVEL = "compute_Blade_policyLevel"
	CONST_PROP_ID_COMPUTE_BLADE_POLICY_OWNER = "compute_Blade_policyOwner"
	CONST_PROP_ID_COMPUTE_BLADE_PRESENCE = "compute_Blade_presence"
	CONST_PROP_ID_COMPUTE_BLADE_REVISION = "compute_Blade_revision"
	CONST_PROP_ID_COMPUTE_BLADE_SERIAL = "compute_Blade_serial"
	CONST_PROP_ID_COMPUTE_BLADE_SERVER_ID = "compute_Blade_serverId"
	CONST_PROP_ID_COMPUTE_BLADE_SLOT_ID = "compute_Blade_slotId"
	CONST_PROP_ID_COMPUTE_BLADE_TOTAL_MEMORY = "compute_Blade_totalMemory"
	CONST_PROP_ID_COMPUTE_BLADE_USR_LBL = "compute_Blade_usrLbl"
	CONST_PROP_ID_COMPUTE_BLADE_UUID = "compute_Blade_uuid"
	CONST_PROP_ID_COMPUTE_BLADE_VENDOR = "compute_Blade_vendor"
	CONST_PROP_ID_COMPUTE_BLADE_VID = "compute_Blade_vid"
	CONST_PROP_ID_COMPUTE_BOARD_CONTROLLER_ID = "compute_BoardController_id"
	CONST_PROP_ID_COMPUTE_BOARD_CONTROLLER_MODEL = "compute_BoardController_model"
	CONST_PROP_ID_COMPUTE_BOARD_CONTROLLER_OPER_QUALIFIER_REASON = "compute_BoardController_operQualifierReason"
	CONST_PROP_ID_COMPUTE_BOARD_CONTROLLER_OPER_STATE = "compute_BoardController_operState"
	CONST_PROP_ID_COMPUTE_BOARD_CONTROLLER_OPERABILITY = "compute_BoardController_operability"
	CONST_PROP_ID_COMPUTE_BOARD_CONTROLLER_PERF = "compute_BoardController_perf"
	CONST_PROP_ID_COMPUTE_BOARD_CONTROLLER_POWER = "compute_BoardController_power"
	CONST_PROP_ID_COMPUTE_BOARD_CONTROLLER_PRESENCE = "compute_BoardController_presence"
	CONST_PROP_ID_COMPUTE_BOARD_CONTROLLER_REVISION = "compute_BoardController_revision"
	CONST_PROP_ID_COMPUTE_BOARD_CONTROLLER_SERIAL = "compute_BoardController_serial"
	CONST_PROP_ID_COMPUTE_BOARD_CONTROLLER_THERMAL = "compute_BoardController_thermal"
	CONST_PROP_ID_COMPUTE_BOARD_CONTROLLER_VENDOR = "compute_BoardController_vendor"
	CONST_PROP_ID_COMPUTE_BOARD_CONTROLLER_VOLTAGE = "compute_BoardController_voltage"
	CONST_PROP_ID_COMPUTE_BOARD_CMOS_VOLTAGE = "compute_Board_cmosVoltage"
	CONST_PROP_ID_COMPUTE_BOARD_ID = "compute_Board_id"
	CONST_PROP_ID_COMPUTE_BOARD_MODEL = "compute_Board_model"
	CONST_PROP_ID_COMPUTE_BOARD_OPER_POWER = "compute_Board_operPower"
	CONST_PROP_ID_COMPUTE_BOARD_OPER_QUALIFIER_REASON = "compute_Board_operQualifierReason"
	CONST_PROP_ID_COMPUTE_BOARD_OPER_STATE = "compute_Board_operState"
	CONST_PROP_ID_COMPUTE_BOARD_OPERABILITY = "compute_Board_operability"
	CONST_PROP_ID_COMPUTE_BOARD_PERF = "compute_Board_perf"
	CONST_PROP_ID_COMPUTE_BOARD_POWER = "compute_Board_power"
	CONST_PROP_ID_COMPUTE_BOARD_POWER_USAGE = "compute_Board_powerUsage"
	CONST_PROP_ID_COMPUTE_BOARD_PRESENCE = "compute_Board_presence"
	CONST_PROP_ID_COMPUTE_BOARD_REVISION = "compute_Board_revision"
	CONST_PROP_ID_COMPUTE_BOARD_SERIAL = "compute_Board_serial"
	CONST_PROP_ID_COMPUTE_BOARD_THERMAL = "compute_Board_thermal"
	CONST_PROP_ID_COMPUTE_BOARD_VENDOR = "compute_Board_vendor"
	CONST_PROP_ID_COMPUTE_BOARD_VOLTAGE = "compute_Board_voltage"
	CONST_PROP_ID_COMPUTE_CHASSIS_CONN_POLICY_ADMIN_STATE = "compute_ChassisConnPolicy_adminState"
	CONST_PROP_ID_COMPUTE_CHASSIS_CONN_POLICY_CHASSIS_ID = "compute_ChassisConnPolicy_chassisId"
	CONST_PROP_ID_COMPUTE_CHASSIS_CONN_POLICY_DESCR = "compute_ChassisConnPolicy_descr"
	CONST_PROP_ID_COMPUTE_CHASSIS_CONN_POLICY_INT_ID = "compute_ChassisConnPolicy_intId"
	CONST_PROP_ID_COMPUTE_CHASSIS_CONN_POLICY_NAME = "compute_ChassisConnPolicy_name"
	CONST_PROP_ID_COMPUTE_CHASSIS_CONN_POLICY_POLICY_LEVEL = "compute_ChassisConnPolicy_policyLevel"
	CONST_PROP_ID_COMPUTE_CHASSIS_CONN_POLICY_POLICY_OWNER = "compute_ChassisConnPolicy_policyOwner"
	CONST_PROP_ID_COMPUTE_CHASSIS_CONN_POLICY_QUALIFIER = "compute_ChassisConnPolicy_qualifier"
	CONST_PROP_ID_COMPUTE_CHASSIS_CONN_POLICY_SWITCH_ID = "compute_ChassisConnPolicy_switchId"
	CONST_PROP_ID_COMPUTE_CHASSIS_DISC_POLICY_ACTION = "compute_ChassisDiscPolicy_action"
	CONST_PROP_ID_COMPUTE_CHASSIS_DISC_POLICY_DESCR = "compute_ChassisDiscPolicy_descr"
	CONST_PROP_ID_COMPUTE_CHASSIS_DISC_POLICY_INT_ID = "compute_ChassisDiscPolicy_intId"
	CONST_PROP_ID_COMPUTE_CHASSIS_DISC_POLICY_LINK_AGGREGATION_PREF = "compute_ChassisDiscPolicy_linkAggregationPref"
	CONST_PROP_ID_COMPUTE_CHASSIS_DISC_POLICY_NAME = "compute_ChassisDiscPolicy_name"
	CONST_PROP_ID_COMPUTE_CHASSIS_DISC_POLICY_POLICY_LEVEL = "compute_ChassisDiscPolicy_policyLevel"
	CONST_PROP_ID_COMPUTE_CHASSIS_DISC_POLICY_POLICY_OWNER = "compute_ChassisDiscPolicy_policyOwner"
	CONST_PROP_ID_COMPUTE_CHASSIS_DISC_POLICY_QUALIFIER = "compute_ChassisDiscPolicy_qualifier"
	CONST_PROP_ID_COMPUTE_CHASSIS_DISC_POLICY_REBALANCE = "compute_ChassisDiscPolicy_rebalance"
	CONST_PROP_ID_COMPUTE_CHASSIS_QUAL_MAX_ID = "compute_ChassisQual_maxId"
	CONST_PROP_ID_COMPUTE_CHASSIS_QUAL_MIN_ID = "compute_ChassisQual_minId"
	CONST_PROP_ID_COMPUTE_COMPUTE_DISC_POLICY_ACTION = "compute_ComputeDiscPolicy_action"
	CONST_PROP_ID_COMPUTE_COMPUTE_DISC_POLICY_DESCR = "compute_ComputeDiscPolicy_descr"
	CONST_PROP_ID_COMPUTE_COMPUTE_DISC_POLICY_INT_ID = "compute_ComputeDiscPolicy_intId"
	CONST_PROP_ID_COMPUTE_COMPUTE_DISC_POLICY_NAME = "compute_ComputeDiscPolicy_name"
	CONST_PROP_ID_COMPUTE_COMPUTE_DISC_POLICY_POLICY_LEVEL = "compute_ComputeDiscPolicy_policyLevel"
	CONST_PROP_ID_COMPUTE_COMPUTE_DISC_POLICY_POLICY_OWNER = "compute_ComputeDiscPolicy_policyOwner"
	CONST_PROP_ID_COMPUTE_COMPUTE_DISC_POLICY_QUALIFIER = "compute_ComputeDiscPolicy_qualifier"
	CONST_PROP_ID_COMPUTE_COMPUTE_DISC_POLICY_SCRUB_POLICY_NAME = "compute_ComputeDiscPolicy_scrubPolicyName"
	CONST_PROP_ID_COMPUTE_CONFIG_POLICY_DESCR = "compute_ConfigPolicy_descr"
	CONST_PROP_ID_COMPUTE_CONFIG_POLICY_INT_ID = "compute_ConfigPolicy_intId"
	CONST_PROP_ID_COMPUTE_CONFIG_POLICY_NAME = "compute_ConfigPolicy_name"
	CONST_PROP_ID_COMPUTE_CONFIG_POLICY_POLICY_LEVEL = "compute_ConfigPolicy_policyLevel"
	CONST_PROP_ID_COMPUTE_CONFIG_POLICY_POLICY_OWNER = "compute_ConfigPolicy_policyOwner"
	CONST_PROP_ID_COMPUTE_CONFIG_POLICY_QUALIFIER = "compute_ConfigPolicy_qualifier"
	CONST_PROP_ID_COMPUTE_CONTAINER_DESCR = "compute_Container_descr"
	CONST_PROP_ID_COMPUTE_CONTAINER_INT_ID = "compute_Container_intId"
	CONST_PROP_ID_COMPUTE_CONTAINER_NAME = "compute_Container_name"
	CONST_PROP_ID_COMPUTE_CONTAINER_POLICY_LEVEL = "compute_Container_policyLevel"
	CONST_PROP_ID_COMPUTE_CONTAINER_POLICY_OWNER = "compute_Container_policyOwner"
	CONST_PROP_ID_COMPUTE_CONTAINER_UUID = "compute_Container_uuid"
	CONST_PROP_ID_COMPUTE_DISC_POLICY_DESCR = "compute_DiscPolicy_descr"
	CONST_PROP_ID_COMPUTE_DISC_POLICY_INT_ID = "compute_DiscPolicy_intId"
	CONST_PROP_ID_COMPUTE_DISC_POLICY_NAME = "compute_DiscPolicy_name"
	CONST_PROP_ID_COMPUTE_DISC_POLICY_POLICY_LEVEL = "compute_DiscPolicy_policyLevel"
	CONST_PROP_ID_COMPUTE_DISC_POLICY_POLICY_OWNER = "compute_DiscPolicy_policyOwner"
	CONST_PROP_ID_COMPUTE_DISC_POLICY_QUALIFIER = "compute_DiscPolicy_qualifier"
	CONST_PROP_ID_COMPUTE_FW_SYNC_ACK_ACKED = "compute_FwSyncAck_acked"
	CONST_PROP_ID_COMPUTE_FW_SYNC_ACK_ACKED_BY = "compute_FwSyncAck_ackedBy"
	CONST_PROP_ID_COMPUTE_FW_SYNC_ACK_ADMIN_STATE = "compute_FwSyncAck_adminState"
	CONST_PROP_ID_COMPUTE_FW_SYNC_ACK_AUTO_DELETE = "compute_FwSyncAck_autoDelete"
	CONST_PROP_ID_COMPUTE_FW_SYNC_ACK_CHANGE_BY = "compute_FwSyncAck_changeBy"
	CONST_PROP_ID_COMPUTE_FW_SYNC_ACK_CHANGE_DETAILS = "compute_FwSyncAck_changeDetails"
	CONST_PROP_ID_COMPUTE_FW_SYNC_ACK_CHANGES = "compute_FwSyncAck_changes"
	CONST_PROP_ID_COMPUTE_FW_SYNC_ACK_DESCR = "compute_FwSyncAck_descr"
	CONST_PROP_ID_COMPUTE_FW_SYNC_ACK_DISR = "compute_FwSyncAck_disr"
	CONST_PROP_ID_COMPUTE_FW_SYNC_ACK_IGNORE_CAP = "compute_FwSyncAck_ignoreCap"
	CONST_PROP_ID_COMPUTE_FW_SYNC_ACK_INT_ID = "compute_FwSyncAck_intId"
	CONST_PROP_ID_COMPUTE_FW_SYNC_ACK_MODIFIED = "compute_FwSyncAck_modified"
	CONST_PROP_ID_COMPUTE_FW_SYNC_ACK_NAME = "compute_FwSyncAck_name"
	CONST_PROP_ID_COMPUTE_FW_SYNC_ACK_OPER_SCHEDULER = "compute_FwSyncAck_operScheduler"
	CONST_PROP_ID_COMPUTE_FW_SYNC_ACK_OPER_STATE = "compute_FwSyncAck_operState"
	CONST_PROP_ID_COMPUTE_FW_SYNC_ACK_POLICY_LEVEL = "compute_FwSyncAck_policyLevel"
	CONST_PROP_ID_COMPUTE_FW_SYNC_ACK_POLICY_OWNER = "compute_FwSyncAck_policyOwner"
	CONST_PROP_ID_COMPUTE_FW_SYNC_ACK_PREV_OPER_STATE = "compute_FwSyncAck_prevOperState"
	CONST_PROP_ID_COMPUTE_FW_SYNC_ACK_SCHEDULER = "compute_FwSyncAck_scheduler"
	CONST_PROP_ID_COMPUTE_HEALTH_LED_SENSOR_ALARM_ALARM_DESC = "compute_HealthLedSensorAlarm_alarmDesc"
	CONST_PROP_ID_COMPUTE_HEALTH_LED_SENSOR_ALARM_ALARM_SEVERITY = "compute_HealthLedSensorAlarm_alarmSeverity"
	CONST_PROP_ID_COMPUTE_HEALTH_LED_SENSOR_ALARM_SENSOR_ID = "compute_HealthLedSensorAlarm_sensorId"
	CONST_PROP_ID_COMPUTE_HEALTH_LED_SENSOR_ALARM_SENSOR_NAME = "compute_HealthLedSensorAlarm_sensorName"
	CONST_PROP_ID_COMPUTE_IOHUB_ENV_STATS_HIST_ID = "compute_IOHubEnvStatsHist_id"
	CONST_PROP_ID_COMPUTE_IOHUB_ENV_STATS_HIST_MOST_RECENT = "compute_IOHubEnvStatsHist_mostRecent"
	CONST_PROP_ID_COMPUTE_IOHUB_ENV_STATS_HIST_SUSPECT = "compute_IOHubEnvStatsHist_suspect"
	CONST_PROP_ID_COMPUTE_IOHUB_ENV_STATS_HIST_TEMPERATURE = "compute_IOHubEnvStatsHist_temperature"
	CONST_PROP_ID_COMPUTE_IOHUB_ENV_STATS_HIST_TEMPERATURE_AVG = "compute_IOHubEnvStatsHist_temperatureAvg"
	CONST_PROP_ID_COMPUTE_IOHUB_ENV_STATS_HIST_TEMPERATURE_MAX = "compute_IOHubEnvStatsHist_temperatureMax"
	CONST_PROP_ID_COMPUTE_IOHUB_ENV_STATS_HIST_TEMPERATURE_MIN = "compute_IOHubEnvStatsHist_temperatureMin"
	CONST_PROP_ID_COMPUTE_IOHUB_ENV_STATS_HIST_THRESHOLDED = "compute_IOHubEnvStatsHist_thresholded"
	CONST_PROP_ID_COMPUTE_IOHUB_ENV_STATS_HIST_TIME_COLLECTED = "compute_IOHubEnvStatsHist_timeCollected"
	CONST_PROP_ID_COMPUTE_IOHUB_ENV_STATS_INTERVALS = "compute_IOHubEnvStats_intervals"
	CONST_PROP_ID_COMPUTE_IOHUB_ENV_STATS_SUSPECT = "compute_IOHubEnvStats_suspect"
	CONST_PROP_ID_COMPUTE_IOHUB_ENV_STATS_TEMPERATURE = "compute_IOHubEnvStats_temperature"
	CONST_PROP_ID_COMPUTE_IOHUB_ENV_STATS_TEMPERATURE_AVG = "compute_IOHubEnvStats_temperatureAvg"
	CONST_PROP_ID_COMPUTE_IOHUB_ENV_STATS_TEMPERATURE_MAX = "compute_IOHubEnvStats_temperatureMax"
	CONST_PROP_ID_COMPUTE_IOHUB_ENV_STATS_TEMPERATURE_MIN = "compute_IOHubEnvStats_temperatureMin"
	CONST_PROP_ID_COMPUTE_IOHUB_ENV_STATS_THRESHOLDED = "compute_IOHubEnvStats_thresholded"
	CONST_PROP_ID_COMPUTE_IOHUB_ENV_STATS_TIME_COLLECTED = "compute_IOHubEnvStats_timeCollected"
	CONST_PROP_ID_COMPUTE_IOHUB_ENV_STATS_UPDATE = "compute_IOHubEnvStats_update"
	CONST_PROP_ID_COMPUTE_IOHUB_ID = "compute_IOHub_id"
	CONST_PROP_ID_COMPUTE_IOHUB_MODEL = "compute_IOHub_model"
	CONST_PROP_ID_COMPUTE_IOHUB_OPER_QUALIFIER_REASON = "compute_IOHub_operQualifierReason"
	CONST_PROP_ID_COMPUTE_IOHUB_OPER_STATE = "compute_IOHub_operState"
	CONST_PROP_ID_COMPUTE_IOHUB_OPERABILITY = "compute_IOHub_operability"
	CONST_PROP_ID_COMPUTE_IOHUB_PERF = "compute_IOHub_perf"
	CONST_PROP_ID_COMPUTE_IOHUB_POWER = "compute_IOHub_power"
	CONST_PROP_ID_COMPUTE_IOHUB_PRESENCE = "compute_IOHub_presence"
	CONST_PROP_ID_COMPUTE_IOHUB_REVISION = "compute_IOHub_revision"
	CONST_PROP_ID_COMPUTE_IOHUB_SERIAL = "compute_IOHub_serial"
	CONST_PROP_ID_COMPUTE_IOHUB_THERMAL = "compute_IOHub_thermal"
	CONST_PROP_ID_COMPUTE_IOHUB_VENDOR = "compute_IOHub_vendor"
	CONST_PROP_ID_COMPUTE_IOHUB_VOLTAGE = "compute_IOHub_voltage"
	CONST_PROP_ID_COMPUTE_INIT_CONFIG_POLICY_DESCR = "compute_InitConfigPolicy_descr"
	CONST_PROP_ID_COMPUTE_INIT_CONFIG_POLICY_DST_DN = "compute_InitConfigPolicy_dstDn"
	CONST_PROP_ID_COMPUTE_INIT_CONFIG_POLICY_INT_ID = "compute_InitConfigPolicy_intId"
	CONST_PROP_ID_COMPUTE_INIT_CONFIG_POLICY_NAME = "compute_InitConfigPolicy_name"
	CONST_PROP_ID_COMPUTE_INIT_CONFIG_POLICY_POLICY_LEVEL = "compute_InitConfigPolicy_policyLevel"
	CONST_PROP_ID_COMPUTE_INIT_CONFIG_POLICY_POLICY_OWNER = "compute_InitConfigPolicy_policyOwner"
	CONST_PROP_ID_COMPUTE_INIT_CONFIG_POLICY_QUALIFIER = "compute_InitConfigPolicy_qualifier"
	CONST_PROP_ID_COMPUTE_ITEM_ADMIN_STATE = "compute_Item_adminState"
	CONST_PROP_ID_COMPUTE_ITEM_ASSIGNED_TO_DN = "compute_Item_assignedToDn"
	CONST_PROP_ID_COMPUTE_ITEM_ASSOCIATION = "compute_Item_association"
	CONST_PROP_ID_COMPUTE_ITEM_AVAILABILITY = "compute_Item_availability"
	CONST_PROP_ID_COMPUTE_ITEM_DESCR = "compute_Item_descr"
	CONST_PROP_ID_COMPUTE_ITEM_DISCOVERY = "compute_Item_discovery"
	CONST_PROP_ID_COMPUTE_ITEM_INT_ID = "compute_Item_intId"
	CONST_PROP_ID_COMPUTE_ITEM_NAME = "compute_Item_name"
	CONST_PROP_ID_COMPUTE_ITEM_OPER_STATE = "compute_Item_operState"
	CONST_PROP_ID_COMPUTE_ITEM_POLICY_LEVEL = "compute_Item_policyLevel"
	CONST_PROP_ID_COMPUTE_ITEM_POLICY_OWNER = "compute_Item_policyOwner"
	CONST_PROP_ID_COMPUTE_ITEM_UUID = "compute_Item_uuid"
	CONST_PROP_ID_COMPUTE_LOGICAL_DESCR = "compute_Logical_descr"
	CONST_PROP_ID_COMPUTE_LOGICAL_INT_ID = "compute_Logical_intId"
	CONST_PROP_ID_COMPUTE_LOGICAL_NAME = "compute_Logical_name"
	CONST_PROP_ID_COMPUTE_LOGICAL_PN_DN = "compute_Logical_pnDn"
	CONST_PROP_ID_COMPUTE_LOGICAL_POLICY_LEVEL = "compute_Logical_policyLevel"
	CONST_PROP_ID_COMPUTE_LOGICAL_POLICY_OWNER = "compute_Logical_policyOwner"
	CONST_PROP_ID_COMPUTE_LOGICAL_UUID = "compute_Logical_uuid"
	CONST_PROP_ID_COMPUTE_MB_POWER_STATS_HIST_CONSUMED_POWER = "compute_MbPowerStatsHist_consumedPower"
	CONST_PROP_ID_COMPUTE_MB_POWER_STATS_HIST_CONSUMED_POWER_AVG = "compute_MbPowerStatsHist_consumedPowerAvg"
	CONST_PROP_ID_COMPUTE_MB_POWER_STATS_HIST_CONSUMED_POWER_MAX = "compute_MbPowerStatsHist_consumedPowerMax"
	CONST_PROP_ID_COMPUTE_MB_POWER_STATS_HIST_CONSUMED_POWER_MIN = "compute_MbPowerStatsHist_consumedPowerMin"
	CONST_PROP_ID_COMPUTE_MB_POWER_STATS_HIST_ID = "compute_MbPowerStatsHist_id"
	CONST_PROP_ID_COMPUTE_MB_POWER_STATS_HIST_INPUT_CURRENT = "compute_MbPowerStatsHist_inputCurrent"
	CONST_PROP_ID_COMPUTE_MB_POWER_STATS_HIST_INPUT_CURRENT_AVG = "compute_MbPowerStatsHist_inputCurrentAvg"
	CONST_PROP_ID_COMPUTE_MB_POWER_STATS_HIST_INPUT_CURRENT_MAX = "compute_MbPowerStatsHist_inputCurrentMax"
	CONST_PROP_ID_COMPUTE_MB_POWER_STATS_HIST_INPUT_CURRENT_MIN = "compute_MbPowerStatsHist_inputCurrentMin"
	CONST_PROP_ID_COMPUTE_MB_POWER_STATS_HIST_INPUT_VOLTAGE = "compute_MbPowerStatsHist_inputVoltage"
	CONST_PROP_ID_COMPUTE_MB_POWER_STATS_HIST_INPUT_VOLTAGE_AVG = "compute_MbPowerStatsHist_inputVoltageAvg"
	CONST_PROP_ID_COMPUTE_MB_POWER_STATS_HIST_INPUT_VOLTAGE_MAX = "compute_MbPowerStatsHist_inputVoltageMax"
	CONST_PROP_ID_COMPUTE_MB_POWER_STATS_HIST_INPUT_VOLTAGE_MIN = "compute_MbPowerStatsHist_inputVoltageMin"
	CONST_PROP_ID_COMPUTE_MB_POWER_STATS_HIST_MOST_RECENT = "compute_MbPowerStatsHist_mostRecent"
	CONST_PROP_ID_COMPUTE_MB_POWER_STATS_HIST_SUSPECT = "compute_MbPowerStatsHist_suspect"
	CONST_PROP_ID_COMPUTE_MB_POWER_STATS_HIST_THRESHOLDED = "compute_MbPowerStatsHist_thresholded"
	CONST_PROP_ID_COMPUTE_MB_POWER_STATS_HIST_TIME_COLLECTED = "compute_MbPowerStatsHist_timeCollected"
	CONST_PROP_ID_COMPUTE_MB_POWER_STATS_CONSUMED_POWER = "compute_MbPowerStats_consumedPower"
	CONST_PROP_ID_COMPUTE_MB_POWER_STATS_CONSUMED_POWER_AVG = "compute_MbPowerStats_consumedPowerAvg"
	CONST_PROP_ID_COMPUTE_MB_POWER_STATS_CONSUMED_POWER_MAX = "compute_MbPowerStats_consumedPowerMax"
	CONST_PROP_ID_COMPUTE_MB_POWER_STATS_CONSUMED_POWER_MIN = "compute_MbPowerStats_consumedPowerMin"
	CONST_PROP_ID_COMPUTE_MB_POWER_STATS_INPUT_CURRENT = "compute_MbPowerStats_inputCurrent"
	CONST_PROP_ID_COMPUTE_MB_POWER_STATS_INPUT_CURRENT_AVG = "compute_MbPowerStats_inputCurrentAvg"
	CONST_PROP_ID_COMPUTE_MB_POWER_STATS_INPUT_CURRENT_MAX = "compute_MbPowerStats_inputCurrentMax"
	CONST_PROP_ID_COMPUTE_MB_POWER_STATS_INPUT_CURRENT_MIN = "compute_MbPowerStats_inputCurrentMin"
	CONST_PROP_ID_COMPUTE_MB_POWER_STATS_INPUT_VOLTAGE = "compute_MbPowerStats_inputVoltage"
	CONST_PROP_ID_COMPUTE_MB_POWER_STATS_INPUT_VOLTAGE_AVG = "compute_MbPowerStats_inputVoltageAvg"
	CONST_PROP_ID_COMPUTE_MB_POWER_STATS_INPUT_VOLTAGE_MAX = "compute_MbPowerStats_inputVoltageMax"
	CONST_PROP_ID_COMPUTE_MB_POWER_STATS_INPUT_VOLTAGE_MIN = "compute_MbPowerStats_inputVoltageMin"
	CONST_PROP_ID_COMPUTE_MB_POWER_STATS_INTERVALS = "compute_MbPowerStats_intervals"
	CONST_PROP_ID_COMPUTE_MB_POWER_STATS_SUSPECT = "compute_MbPowerStats_suspect"
	CONST_PROP_ID_COMPUTE_MB_POWER_STATS_THRESHOLDED = "compute_MbPowerStats_thresholded"
	CONST_PROP_ID_COMPUTE_MB_POWER_STATS_TIME_COLLECTED = "compute_MbPowerStats_timeCollected"
	CONST_PROP_ID_COMPUTE_MB_POWER_STATS_UPDATE = "compute_MbPowerStats_update"
	CONST_PROP_ID_COMPUTE_MB_TEMP_STATS_HIST_FM_TEMP_SEN_IO = "compute_MbTempStatsHist_fmTempSenIo"
	CONST_PROP_ID_COMPUTE_MB_TEMP_STATS_HIST_FM_TEMP_SEN_IO_AVG = "compute_MbTempStatsHist_fmTempSenIoAvg"
	CONST_PROP_ID_COMPUTE_MB_TEMP_STATS_HIST_FM_TEMP_SEN_IO_MAX = "compute_MbTempStatsHist_fmTempSenIoMax"
	CONST_PROP_ID_COMPUTE_MB_TEMP_STATS_HIST_FM_TEMP_SEN_IO_MIN = "compute_MbTempStatsHist_fmTempSenIoMin"
	CONST_PROP_ID_COMPUTE_MB_TEMP_STATS_HIST_FM_TEMP_SEN_REAR = "compute_MbTempStatsHist_fmTempSenRear"
	CONST_PROP_ID_COMPUTE_MB_TEMP_STATS_HIST_FM_TEMP_SEN_REAR_AVG = "compute_MbTempStatsHist_fmTempSenRearAvg"
	CONST_PROP_ID_COMPUTE_MB_TEMP_STATS_HIST_FM_TEMP_SEN_REAR_L = "compute_MbTempStatsHist_fmTempSenRearL"
	CONST_PROP_ID_COMPUTE_MB_TEMP_STATS_HIST_FM_TEMP_SEN_REAR_LAVG = "compute_MbTempStatsHist_fmTempSenRearLAvg"
	CONST_PROP_ID_COMPUTE_MB_TEMP_STATS_HIST_FM_TEMP_SEN_REAR_LMAX = "compute_MbTempStatsHist_fmTempSenRearLMax"
	CONST_PROP_ID_COMPUTE_MB_TEMP_STATS_HIST_FM_TEMP_SEN_REAR_LMIN = "compute_MbTempStatsHist_fmTempSenRearLMin"
	CONST_PROP_ID_COMPUTE_MB_TEMP_STATS_HIST_FM_TEMP_SEN_REAR_MAX = "compute_MbTempStatsHist_fmTempSenRearMax"
	CONST_PROP_ID_COMPUTE_MB_TEMP_STATS_HIST_FM_TEMP_SEN_REAR_MIN = "compute_MbTempStatsHist_fmTempSenRearMin"
	CONST_PROP_ID_COMPUTE_MB_TEMP_STATS_HIST_FM_TEMP_SEN_REAR_R = "compute_MbTempStatsHist_fmTempSenRearR"
	CONST_PROP_ID_COMPUTE_MB_TEMP_STATS_HIST_FM_TEMP_SEN_REAR_RAVG = "compute_MbTempStatsHist_fmTempSenRearRAvg"
	CONST_PROP_ID_COMPUTE_MB_TEMP_STATS_HIST_FM_TEMP_SEN_REAR_RMAX = "compute_MbTempStatsHist_fmTempSenRearRMax"
	CONST_PROP_ID_COMPUTE_MB_TEMP_STATS_HIST_FM_TEMP_SEN_REAR_RMIN = "compute_MbTempStatsHist_fmTempSenRearRMin"
	CONST_PROP_ID_COMPUTE_MB_TEMP_STATS_HIST_ID = "compute_MbTempStatsHist_id"
	CONST_PROP_ID_COMPUTE_MB_TEMP_STATS_HIST_MOST_RECENT = "compute_MbTempStatsHist_mostRecent"
	CONST_PROP_ID_COMPUTE_MB_TEMP_STATS_HIST_SUSPECT = "compute_MbTempStatsHist_suspect"
	CONST_PROP_ID_COMPUTE_MB_TEMP_STATS_HIST_THRESHOLDED = "compute_MbTempStatsHist_thresholded"
	CONST_PROP_ID_COMPUTE_MB_TEMP_STATS_HIST_TIME_COLLECTED = "compute_MbTempStatsHist_timeCollected"
	CONST_PROP_ID_COMPUTE_MB_TEMP_STATS_FM_TEMP_SEN_IO = "compute_MbTempStats_fmTempSenIo"
	CONST_PROP_ID_COMPUTE_MB_TEMP_STATS_FM_TEMP_SEN_IO_AVG = "compute_MbTempStats_fmTempSenIoAvg"
	CONST_PROP_ID_COMPUTE_MB_TEMP_STATS_FM_TEMP_SEN_IO_MAX = "compute_MbTempStats_fmTempSenIoMax"
	CONST_PROP_ID_COMPUTE_MB_TEMP_STATS_FM_TEMP_SEN_IO_MIN = "compute_MbTempStats_fmTempSenIoMin"
	CONST_PROP_ID_COMPUTE_MB_TEMP_STATS_FM_TEMP_SEN_REAR = "compute_MbTempStats_fmTempSenRear"
	CONST_PROP_ID_COMPUTE_MB_TEMP_STATS_FM_TEMP_SEN_REAR_AVG = "compute_MbTempStats_fmTempSenRearAvg"
	CONST_PROP_ID_COMPUTE_MB_TEMP_STATS_FM_TEMP_SEN_REAR_L = "compute_MbTempStats_fmTempSenRearL"
	CONST_PROP_ID_COMPUTE_MB_TEMP_STATS_FM_TEMP_SEN_REAR_LAVG = "compute_MbTempStats_fmTempSenRearLAvg"
	CONST_PROP_ID_COMPUTE_MB_TEMP_STATS_FM_TEMP_SEN_REAR_LMAX = "compute_MbTempStats_fmTempSenRearLMax"
	CONST_PROP_ID_COMPUTE_MB_TEMP_STATS_FM_TEMP_SEN_REAR_LMIN = "compute_MbTempStats_fmTempSenRearLMin"
	CONST_PROP_ID_COMPUTE_MB_TEMP_STATS_FM_TEMP_SEN_REAR_MAX = "compute_MbTempStats_fmTempSenRearMax"
	CONST_PROP_ID_COMPUTE_MB_TEMP_STATS_FM_TEMP_SEN_REAR_MIN = "compute_MbTempStats_fmTempSenRearMin"
	CONST_PROP_ID_COMPUTE_MB_TEMP_STATS_FM_TEMP_SEN_REAR_R = "compute_MbTempStats_fmTempSenRearR"
	CONST_PROP_ID_COMPUTE_MB_TEMP_STATS_FM_TEMP_SEN_REAR_RAVG = "compute_MbTempStats_fmTempSenRearRAvg"
	CONST_PROP_ID_COMPUTE_MB_TEMP_STATS_FM_TEMP_SEN_REAR_RMAX = "compute_MbTempStats_fmTempSenRearRMax"
	CONST_PROP_ID_COMPUTE_MB_TEMP_STATS_FM_TEMP_SEN_REAR_RMIN = "compute_MbTempStats_fmTempSenRearRMin"
	CONST_PROP_ID_COMPUTE_MB_TEMP_STATS_INTERVALS = "compute_MbTempStats_intervals"
	CONST_PROP_ID_COMPUTE_MB_TEMP_STATS_SUSPECT = "compute_MbTempStats_suspect"
	CONST_PROP_ID_COMPUTE_MB_TEMP_STATS_THRESHOLDED = "compute_MbTempStats_thresholded"
	CONST_PROP_ID_COMPUTE_MB_TEMP_STATS_TIME_COLLECTED = "compute_MbTempStats_timeCollected"
	CONST_PROP_ID_COMPUTE_MB_TEMP_STATS_UPDATE = "compute_MbTempStats_update"
	CONST_PROP_ID_COMPUTE_MEMORY_CONFIG_POLICY_BLACK_LISTING = "compute_MemoryConfigPolicy_blackListing"
	CONST_PROP_ID_COMPUTE_MEMORY_CONFIG_POLICY_DESCR = "compute_MemoryConfigPolicy_descr"
	CONST_PROP_ID_COMPUTE_MEMORY_CONFIG_POLICY_INT_ID = "compute_MemoryConfigPolicy_intId"
	CONST_PROP_ID_COMPUTE_MEMORY_CONFIG_POLICY_NAME = "compute_MemoryConfigPolicy_name"
	CONST_PROP_ID_COMPUTE_MEMORY_CONFIG_POLICY_POLICY_LEVEL = "compute_MemoryConfigPolicy_policyLevel"
	CONST_PROP_ID_COMPUTE_MEMORY_CONFIG_POLICY_POLICY_OWNER = "compute_MemoryConfigPolicy_policyOwner"
	CONST_PROP_ID_COMPUTE_MEMORY_CONFIGURATION_ADMIN_MEMORY_STATE = "compute_MemoryConfiguration_adminMemoryState"
	CONST_PROP_ID_COMPUTE_MEMORY_CONFIGURATION_BLACK_LISTING = "compute_MemoryConfiguration_blackListing"
	CONST_PROP_ID_COMPUTE_MEMORY_UNIT_CONSTRAINT_DEF_DESCR = "compute_MemoryUnitConstraintDef_descr"
	CONST_PROP_ID_COMPUTE_MEMORY_UNIT_CONSTRAINT_DEF_INT_ID = "compute_MemoryUnitConstraintDef_intId"
	CONST_PROP_ID_COMPUTE_MEMORY_UNIT_CONSTRAINT_DEF_NAME = "compute_MemoryUnitConstraintDef_name"
	CONST_PROP_ID_COMPUTE_MEMORY_UNIT_CONSTRAINT_DEF_POLICY_LEVEL = "compute_MemoryUnitConstraintDef_policyLevel"
	CONST_PROP_ID_COMPUTE_MEMORY_UNIT_CONSTRAINT_DEF_POLICY_OWNER = "compute_MemoryUnitConstraintDef_policyOwner"
	CONST_PROP_ID_COMPUTE_MEMORY_UNIT_CONSTRAINT_DEF_REVISION_MODIFIER = "compute_MemoryUnitConstraintDef_revisionModifier"
	CONST_PROP_ID_COMPUTE_MEMORY_UNIT_CONSTRAINT_DEF_TYPE = "compute_MemoryUnitConstraintDef_type"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_COMPLETION_STATS_ABORT_ERRORS = "compute_PCIeFatalCompletionStats_AbortErrors"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_COMPLETION_STATS_ABORT_ERRORS15_MIN = "compute_PCIeFatalCompletionStats_AbortErrors15Min"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_COMPLETION_STATS_ABORT_ERRORS15_MIN_H = "compute_PCIeFatalCompletionStats_AbortErrors15MinH"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_COMPLETION_STATS_ABORT_ERRORS1_DAY = "compute_PCIeFatalCompletionStats_AbortErrors1Day"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_COMPLETION_STATS_ABORT_ERRORS1_DAY_H = "compute_PCIeFatalCompletionStats_AbortErrors1DayH"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_COMPLETION_STATS_ABORT_ERRORS1_HOUR = "compute_PCIeFatalCompletionStats_AbortErrors1Hour"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_COMPLETION_STATS_ABORT_ERRORS1_HOUR_H = "compute_PCIeFatalCompletionStats_AbortErrors1HourH"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_COMPLETION_STATS_ABORT_ERRORS1_WEEK = "compute_PCIeFatalCompletionStats_AbortErrors1Week"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_COMPLETION_STATS_ABORT_ERRORS1_WEEK_H = "compute_PCIeFatalCompletionStats_AbortErrors1WeekH"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_COMPLETION_STATS_ABORT_ERRORS2_WEEKS = "compute_PCIeFatalCompletionStats_AbortErrors2Weeks"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_COMPLETION_STATS_ABORT_ERRORS2_WEEKS_H = "compute_PCIeFatalCompletionStats_AbortErrors2WeeksH"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_COMPLETION_STATS_TIMEOUT_ERRORS = "compute_PCIeFatalCompletionStats_TimeoutErrors"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_COMPLETION_STATS_TIMEOUT_ERRORS15_MIN = "compute_PCIeFatalCompletionStats_TimeoutErrors15Min"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_COMPLETION_STATS_TIMEOUT_ERRORS15_MIN_H = "compute_PCIeFatalCompletionStats_TimeoutErrors15MinH"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_COMPLETION_STATS_TIMEOUT_ERRORS1_DAY = "compute_PCIeFatalCompletionStats_TimeoutErrors1Day"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_COMPLETION_STATS_TIMEOUT_ERRORS1_DAY_H = "compute_PCIeFatalCompletionStats_TimeoutErrors1DayH"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_COMPLETION_STATS_TIMEOUT_ERRORS1_HOUR = "compute_PCIeFatalCompletionStats_TimeoutErrors1Hour"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_COMPLETION_STATS_TIMEOUT_ERRORS1_HOUR_H = "compute_PCIeFatalCompletionStats_TimeoutErrors1HourH"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_COMPLETION_STATS_TIMEOUT_ERRORS1_WEEK = "compute_PCIeFatalCompletionStats_TimeoutErrors1Week"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_COMPLETION_STATS_TIMEOUT_ERRORS1_WEEK_H = "compute_PCIeFatalCompletionStats_TimeoutErrors1WeekH"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_COMPLETION_STATS_TIMEOUT_ERRORS2_WEEKS = "compute_PCIeFatalCompletionStats_TimeoutErrors2Weeks"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_COMPLETION_STATS_TIMEOUT_ERRORS2_WEEKS_H = "compute_PCIeFatalCompletionStats_TimeoutErrors2WeeksH"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_COMPLETION_STATS_INTERVALS = "compute_PCIeFatalCompletionStats_intervals"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_COMPLETION_STATS_SUSPECT = "compute_PCIeFatalCompletionStats_suspect"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_COMPLETION_STATS_THRESHOLDED = "compute_PCIeFatalCompletionStats_thresholded"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_COMPLETION_STATS_TIME_COLLECTED = "compute_PCIeFatalCompletionStats_timeCollected"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_COMPLETION_STATS_UNEXPECTED_ERRORS = "compute_PCIeFatalCompletionStats_unexpectedErrors"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_COMPLETION_STATS_UNEXPECTED_ERRORS15_MIN = "compute_PCIeFatalCompletionStats_unexpectedErrors15Min"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_COMPLETION_STATS_UNEXPECTED_ERRORS15_MIN_H = "compute_PCIeFatalCompletionStats_unexpectedErrors15MinH"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_COMPLETION_STATS_UNEXPECTED_ERRORS1_DAY = "compute_PCIeFatalCompletionStats_unexpectedErrors1Day"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_COMPLETION_STATS_UNEXPECTED_ERRORS1_DAY_H = "compute_PCIeFatalCompletionStats_unexpectedErrors1DayH"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_COMPLETION_STATS_UNEXPECTED_ERRORS1_HOUR = "compute_PCIeFatalCompletionStats_unexpectedErrors1Hour"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_COMPLETION_STATS_UNEXPECTED_ERRORS1_HOUR_H = "compute_PCIeFatalCompletionStats_unexpectedErrors1HourH"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_COMPLETION_STATS_UNEXPECTED_ERRORS1_WEEK = "compute_PCIeFatalCompletionStats_unexpectedErrors1Week"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_COMPLETION_STATS_UNEXPECTED_ERRORS1_WEEK_H = "compute_PCIeFatalCompletionStats_unexpectedErrors1WeekH"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_COMPLETION_STATS_UNEXPECTED_ERRORS2_WEEKS = "compute_PCIeFatalCompletionStats_unexpectedErrors2Weeks"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_COMPLETION_STATS_UNEXPECTED_ERRORS2_WEEKS_H = "compute_PCIeFatalCompletionStats_unexpectedErrors2WeeksH"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_COMPLETION_STATS_UPDATE = "compute_PCIeFatalCompletionStats_update"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_DLLP_ERRORS = "compute_PCIeFatalProtocolStats_dllpErrors"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_DLLP_ERRORS15_MIN = "compute_PCIeFatalProtocolStats_dllpErrors15Min"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_DLLP_ERRORS15_MIN_H = "compute_PCIeFatalProtocolStats_dllpErrors15MinH"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_DLLP_ERRORS1_DAY = "compute_PCIeFatalProtocolStats_dllpErrors1Day"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_DLLP_ERRORS1_DAY_H = "compute_PCIeFatalProtocolStats_dllpErrors1DayH"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_DLLP_ERRORS1_HOUR = "compute_PCIeFatalProtocolStats_dllpErrors1Hour"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_DLLP_ERRORS1_HOUR_H = "compute_PCIeFatalProtocolStats_dllpErrors1HourH"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_DLLP_ERRORS1_WEEK = "compute_PCIeFatalProtocolStats_dllpErrors1Week"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_DLLP_ERRORS1_WEEK_H = "compute_PCIeFatalProtocolStats_dllpErrors1WeekH"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_DLLP_ERRORS2_WEEKS = "compute_PCIeFatalProtocolStats_dllpErrors2Weeks"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_DLLP_ERRORS2_WEEKS_H = "compute_PCIeFatalProtocolStats_dllpErrors2WeeksH"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_FLOW_CONTROL_ERRORS = "compute_PCIeFatalProtocolStats_flowControlErrors"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_FLOW_CONTROL_ERRORS15_MIN = "compute_PCIeFatalProtocolStats_flowControlErrors15Min"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_FLOW_CONTROL_ERRORS15_MIN_H = "compute_PCIeFatalProtocolStats_flowControlErrors15MinH"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_FLOW_CONTROL_ERRORS1_DAY = "compute_PCIeFatalProtocolStats_flowControlErrors1Day"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_FLOW_CONTROL_ERRORS1_DAY_H = "compute_PCIeFatalProtocolStats_flowControlErrors1DayH"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_FLOW_CONTROL_ERRORS1_HOUR = "compute_PCIeFatalProtocolStats_flowControlErrors1Hour"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_FLOW_CONTROL_ERRORS1_HOUR_H = "compute_PCIeFatalProtocolStats_flowControlErrors1HourH"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_FLOW_CONTROL_ERRORS1_WEEK = "compute_PCIeFatalProtocolStats_flowControlErrors1Week"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_FLOW_CONTROL_ERRORS1_WEEK_H = "compute_PCIeFatalProtocolStats_flowControlErrors1WeekH"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_FLOW_CONTROL_ERRORS2_WEEKS = "compute_PCIeFatalProtocolStats_flowControlErrors2Weeks"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_FLOW_CONTROL_ERRORS2_WEEKS_H = "compute_PCIeFatalProtocolStats_flowControlErrors2WeeksH"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_INTERVALS = "compute_PCIeFatalProtocolStats_intervals"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_SUSPECT = "compute_PCIeFatalProtocolStats_suspect"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_THRESHOLDED = "compute_PCIeFatalProtocolStats_thresholded"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_TIME_COLLECTED = "compute_PCIeFatalProtocolStats_timeCollected"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_UPDATE = "compute_PCIeFatalProtocolStats_update"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_RECEIVE_STATS_BUFFER_OVERFLOW_ERRORS = "compute_PCIeFatalReceiveStats_bufferOverflowErrors"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_RECEIVE_STATS_BUFFER_OVERFLOW_ERRORS15_MIN = "compute_PCIeFatalReceiveStats_bufferOverflowErrors15Min"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_RECEIVE_STATS_BUFFER_OVERFLOW_ERRORS15_MIN_H = "compute_PCIeFatalReceiveStats_bufferOverflowErrors15MinH"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_RECEIVE_STATS_BUFFER_OVERFLOW_ERRORS1_DAY = "compute_PCIeFatalReceiveStats_bufferOverflowErrors1Day"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_RECEIVE_STATS_BUFFER_OVERFLOW_ERRORS1_DAY_H = "compute_PCIeFatalReceiveStats_bufferOverflowErrors1DayH"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_RECEIVE_STATS_BUFFER_OVERFLOW_ERRORS1_HOUR = "compute_PCIeFatalReceiveStats_bufferOverflowErrors1Hour"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_RECEIVE_STATS_BUFFER_OVERFLOW_ERRORS1_HOUR_H = "compute_PCIeFatalReceiveStats_bufferOverflowErrors1HourH"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_RECEIVE_STATS_BUFFER_OVERFLOW_ERRORS1_WEEK = "compute_PCIeFatalReceiveStats_bufferOverflowErrors1Week"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_RECEIVE_STATS_BUFFER_OVERFLOW_ERRORS1_WEEK_H = "compute_PCIeFatalReceiveStats_bufferOverflowErrors1WeekH"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_RECEIVE_STATS_BUFFER_OVERFLOW_ERRORS2_WEEKS = "compute_PCIeFatalReceiveStats_bufferOverflowErrors2Weeks"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_RECEIVE_STATS_BUFFER_OVERFLOW_ERRORS2_WEEKS_H = "compute_PCIeFatalReceiveStats_bufferOverflowErrors2WeeksH"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_RECEIVE_STATS_ERR_FATAL_ERRORS = "compute_PCIeFatalReceiveStats_errFatalErrors"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_RECEIVE_STATS_ERR_FATAL_ERRORS15_MIN = "compute_PCIeFatalReceiveStats_errFatalErrors15Min"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_RECEIVE_STATS_ERR_FATAL_ERRORS15_MIN_H = "compute_PCIeFatalReceiveStats_errFatalErrors15MinH"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_RECEIVE_STATS_ERR_FATAL_ERRORS1_DAY = "compute_PCIeFatalReceiveStats_errFatalErrors1Day"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_RECEIVE_STATS_ERR_FATAL_ERRORS1_DAY_H = "compute_PCIeFatalReceiveStats_errFatalErrors1DayH"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_RECEIVE_STATS_ERR_FATAL_ERRORS1_HOUR = "compute_PCIeFatalReceiveStats_errFatalErrors1Hour"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_RECEIVE_STATS_ERR_FATAL_ERRORS1_HOUR_H = "compute_PCIeFatalReceiveStats_errFatalErrors1HourH"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_RECEIVE_STATS_ERR_FATAL_ERRORS1_WEEK = "compute_PCIeFatalReceiveStats_errFatalErrors1Week"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_RECEIVE_STATS_ERR_FATAL_ERRORS1_WEEK_H = "compute_PCIeFatalReceiveStats_errFatalErrors1WeekH"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_RECEIVE_STATS_ERR_FATAL_ERRORS2_WEEKS = "compute_PCIeFatalReceiveStats_errFatalErrors2Weeks"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_RECEIVE_STATS_ERR_FATAL_ERRORS2_WEEKS_H = "compute_PCIeFatalReceiveStats_errFatalErrors2WeeksH"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_RECEIVE_STATS_ERR_NON_FATAL_ERRORS = "compute_PCIeFatalReceiveStats_errNonFatalErrors"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_RECEIVE_STATS_ERR_NON_FATAL_ERRORS15_MIN = "compute_PCIeFatalReceiveStats_errNonFatalErrors15Min"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_RECEIVE_STATS_ERR_NON_FATAL_ERRORS15_MIN_H = "compute_PCIeFatalReceiveStats_errNonFatalErrors15MinH"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_RECEIVE_STATS_ERR_NON_FATAL_ERRORS1_DAY = "compute_PCIeFatalReceiveStats_errNonFatalErrors1Day"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_RECEIVE_STATS_ERR_NON_FATAL_ERRORS1_DAY_H = "compute_PCIeFatalReceiveStats_errNonFatalErrors1DayH"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_RECEIVE_STATS_ERR_NON_FATAL_ERRORS1_HOUR = "compute_PCIeFatalReceiveStats_errNonFatalErrors1Hour"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_RECEIVE_STATS_ERR_NON_FATAL_ERRORS1_HOUR_H = "compute_PCIeFatalReceiveStats_errNonFatalErrors1HourH"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_RECEIVE_STATS_ERR_NON_FATAL_ERRORS1_WEEK = "compute_PCIeFatalReceiveStats_errNonFatalErrors1Week"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_RECEIVE_STATS_ERR_NON_FATAL_ERRORS1_WEEK_H = "compute_PCIeFatalReceiveStats_errNonFatalErrors1WeekH"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_RECEIVE_STATS_ERR_NON_FATAL_ERRORS2_WEEKS = "compute_PCIeFatalReceiveStats_errNonFatalErrors2Weeks"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_RECEIVE_STATS_ERR_NON_FATAL_ERRORS2_WEEKS_H = "compute_PCIeFatalReceiveStats_errNonFatalErrors2WeeksH"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_RECEIVE_STATS_INTERVALS = "compute_PCIeFatalReceiveStats_intervals"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_RECEIVE_STATS_SUSPECT = "compute_PCIeFatalReceiveStats_suspect"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_RECEIVE_STATS_THRESHOLDED = "compute_PCIeFatalReceiveStats_thresholded"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_RECEIVE_STATS_TIME_COLLECTED = "compute_PCIeFatalReceiveStats_timeCollected"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_RECEIVE_STATS_UNSUPPORTED_REQUEST_ERRORS = "compute_PCIeFatalReceiveStats_unsupportedRequestErrors"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_RECEIVE_STATS_UNSUPPORTED_REQUEST_ERRORS15_MIN = "compute_PCIeFatalReceiveStats_unsupportedRequestErrors15Min"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_RECEIVE_STATS_UNSUPPORTED_REQUEST_ERRORS15_MIN_H = "compute_PCIeFatalReceiveStats_unsupportedRequestErrors15MinH"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_RECEIVE_STATS_UNSUPPORTED_REQUEST_ERRORS1_DAY = "compute_PCIeFatalReceiveStats_unsupportedRequestErrors1Day"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_RECEIVE_STATS_UNSUPPORTED_REQUEST_ERRORS1_DAY_H = "compute_PCIeFatalReceiveStats_unsupportedRequestErrors1DayH"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_RECEIVE_STATS_UNSUPPORTED_REQUEST_ERRORS1_HOUR = "compute_PCIeFatalReceiveStats_unsupportedRequestErrors1Hour"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_RECEIVE_STATS_UNSUPPORTED_REQUEST_ERRORS1_HOUR_H = "compute_PCIeFatalReceiveStats_unsupportedRequestErrors1HourH"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_RECEIVE_STATS_UNSUPPORTED_REQUEST_ERRORS1_WEEK = "compute_PCIeFatalReceiveStats_unsupportedRequestErrors1Week"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_RECEIVE_STATS_UNSUPPORTED_REQUEST_ERRORS1_WEEK_H = "compute_PCIeFatalReceiveStats_unsupportedRequestErrors1WeekH"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_RECEIVE_STATS_UNSUPPORTED_REQUEST_ERRORS2_WEEKS = "compute_PCIeFatalReceiveStats_unsupportedRequestErrors2Weeks"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_RECEIVE_STATS_UNSUPPORTED_REQUEST_ERRORS2_WEEKS_H = "compute_PCIeFatalReceiveStats_unsupportedRequestErrors2WeeksH"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_RECEIVE_STATS_UPDATE = "compute_PCIeFatalReceiveStats_update"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_STATS_ACS_VIOLATION_ERRORS = "compute_PCIeFatalStats_acsViolationErrors"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_STATS_ACS_VIOLATION_ERRORS15_MIN = "compute_PCIeFatalStats_acsViolationErrors15Min"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_STATS_ACS_VIOLATION_ERRORS15_MIN_H = "compute_PCIeFatalStats_acsViolationErrors15MinH"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_STATS_ACS_VIOLATION_ERRORS1_DAY = "compute_PCIeFatalStats_acsViolationErrors1Day"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_STATS_ACS_VIOLATION_ERRORS1_DAY_H = "compute_PCIeFatalStats_acsViolationErrors1DayH"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_STATS_ACS_VIOLATION_ERRORS1_HOUR = "compute_PCIeFatalStats_acsViolationErrors1Hour"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_STATS_ACS_VIOLATION_ERRORS1_HOUR_H = "compute_PCIeFatalStats_acsViolationErrors1HourH"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_STATS_ACS_VIOLATION_ERRORS1_WEEK = "compute_PCIeFatalStats_acsViolationErrors1Week"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_STATS_ACS_VIOLATION_ERRORS1_WEEK_H = "compute_PCIeFatalStats_acsViolationErrors1WeekH"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_STATS_ACS_VIOLATION_ERRORS2_WEEKS = "compute_PCIeFatalStats_acsViolationErrors2Weeks"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_STATS_ACS_VIOLATION_ERRORS2_WEEKS_H = "compute_PCIeFatalStats_acsViolationErrors2WeeksH"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_STATS_INTERVALS = "compute_PCIeFatalStats_intervals"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_STATS_MALFORMED_TLPERRORS = "compute_PCIeFatalStats_malformedTLPErrors"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_STATS_MALFORMED_TLPERRORS15_MIN = "compute_PCIeFatalStats_malformedTLPErrors15Min"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_STATS_MALFORMED_TLPERRORS15_MIN_H = "compute_PCIeFatalStats_malformedTLPErrors15MinH"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_STATS_MALFORMED_TLPERRORS1_DAY = "compute_PCIeFatalStats_malformedTLPErrors1Day"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_STATS_MALFORMED_TLPERRORS1_DAY_H = "compute_PCIeFatalStats_malformedTLPErrors1DayH"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_STATS_MALFORMED_TLPERRORS1_HOUR = "compute_PCIeFatalStats_malformedTLPErrors1Hour"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_STATS_MALFORMED_TLPERRORS1_HOUR_H = "compute_PCIeFatalStats_malformedTLPErrors1HourH"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_STATS_MALFORMED_TLPERRORS1_WEEK = "compute_PCIeFatalStats_malformedTLPErrors1Week"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_STATS_MALFORMED_TLPERRORS1_WEEK_H = "compute_PCIeFatalStats_malformedTLPErrors1WeekH"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_STATS_MALFORMED_TLPERRORS2_WEEKS = "compute_PCIeFatalStats_malformedTLPErrors2Weeks"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_STATS_MALFORMED_TLPERRORS2_WEEKS_H = "compute_PCIeFatalStats_malformedTLPErrors2WeeksH"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_STATS_POISONED_TLPERRORS = "compute_PCIeFatalStats_poisonedTLPErrors"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_STATS_POISONED_TLPERRORS15_MIN = "compute_PCIeFatalStats_poisonedTLPErrors15Min"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_STATS_POISONED_TLPERRORS15_MIN_H = "compute_PCIeFatalStats_poisonedTLPErrors15MinH"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_STATS_POISONED_TLPERRORS1_DAY = "compute_PCIeFatalStats_poisonedTLPErrors1Day"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_STATS_POISONED_TLPERRORS1_DAY_H = "compute_PCIeFatalStats_poisonedTLPErrors1DayH"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_STATS_POISONED_TLPERRORS1_HOUR = "compute_PCIeFatalStats_poisonedTLPErrors1Hour"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_STATS_POISONED_TLPERRORS1_HOUR_H = "compute_PCIeFatalStats_poisonedTLPErrors1HourH"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_STATS_POISONED_TLPERRORS1_WEEK = "compute_PCIeFatalStats_poisonedTLPErrors1Week"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_STATS_POISONED_TLPERRORS1_WEEK_H = "compute_PCIeFatalStats_poisonedTLPErrors1WeekH"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_STATS_POISONED_TLPERRORS2_WEEKS = "compute_PCIeFatalStats_poisonedTLPErrors2Weeks"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_STATS_POISONED_TLPERRORS2_WEEKS_H = "compute_PCIeFatalStats_poisonedTLPErrors2WeeksH"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_STATS_SURPRISE_LINK_DOWN_ERRORS = "compute_PCIeFatalStats_surpriseLinkDownErrors"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_STATS_SURPRISE_LINK_DOWN_ERRORS15_MIN = "compute_PCIeFatalStats_surpriseLinkDownErrors15Min"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_STATS_SURPRISE_LINK_DOWN_ERRORS15_MIN_H = "compute_PCIeFatalStats_surpriseLinkDownErrors15MinH"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_STATS_SURPRISE_LINK_DOWN_ERRORS1_DAY = "compute_PCIeFatalStats_surpriseLinkDownErrors1Day"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_STATS_SURPRISE_LINK_DOWN_ERRORS1_DAY_H = "compute_PCIeFatalStats_surpriseLinkDownErrors1DayH"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_STATS_SURPRISE_LINK_DOWN_ERRORS1_HOUR = "compute_PCIeFatalStats_surpriseLinkDownErrors1Hour"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_STATS_SURPRISE_LINK_DOWN_ERRORS1_HOUR_H = "compute_PCIeFatalStats_surpriseLinkDownErrors1HourH"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_STATS_SURPRISE_LINK_DOWN_ERRORS1_WEEK = "compute_PCIeFatalStats_surpriseLinkDownErrors1Week"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_STATS_SURPRISE_LINK_DOWN_ERRORS1_WEEK_H = "compute_PCIeFatalStats_surpriseLinkDownErrors1WeekH"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_STATS_SURPRISE_LINK_DOWN_ERRORS2_WEEKS = "compute_PCIeFatalStats_surpriseLinkDownErrors2Weeks"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_STATS_SURPRISE_LINK_DOWN_ERRORS2_WEEKS_H = "compute_PCIeFatalStats_surpriseLinkDownErrors2WeeksH"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_STATS_SUSPECT = "compute_PCIeFatalStats_suspect"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_STATS_THRESHOLDED = "compute_PCIeFatalStats_thresholded"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_STATS_TIME_COLLECTED = "compute_PCIeFatalStats_timeCollected"
	CONST_PROP_ID_COMPUTE_PCIE_FATAL_STATS_UPDATE = "compute_PCIeFatalStats_update"
	CONST_PROP_ID_COMPUTE_PARTITION_DESCR = "compute_Partition_descr"
	CONST_PROP_ID_COMPUTE_PARTITION_INT_ID = "compute_Partition_intId"
	CONST_PROP_ID_COMPUTE_PARTITION_LS_DN = "compute_Partition_lsDn"
	CONST_PROP_ID_COMPUTE_PARTITION_NAME = "compute_Partition_name"
	CONST_PROP_ID_COMPUTE_PARTITION_PN_DN = "compute_Partition_pnDn"
	CONST_PROP_ID_COMPUTE_PARTITION_POLICY_LEVEL = "compute_Partition_policyLevel"
	CONST_PROP_ID_COMPUTE_PARTITION_POLICY_OWNER = "compute_Partition_policyOwner"
	CONST_PROP_ID_COMPUTE_PARTITION_UUID = "compute_Partition_uuid"
	CONST_PROP_ID_COMPUTE_PCI_CAP_MAX_BUS_ID_PER_SLOT = "compute_PciCap_maxBusIdPerSlot"
	CONST_PROP_ID_COMPUTE_PCI_CAP_NUM_OF_PHYS_SLOTS = "compute_PciCap_numOfPhysSlots"
	CONST_PROP_ID_COMPUTE_PCI_CAP_ORDER = "compute_PciCap_order"
	CONST_PROP_ID_COMPUTE_PCI_CAP_STARTS_WITH = "compute_PciCap_startsWith"
	CONST_PROP_ID_COMPUTE_PCI_SLOT_SCAN_DEF_DESCR = "compute_PciSlotScanDef_descr"
	CONST_PROP_ID_COMPUTE_PCI_SLOT_SCAN_DEF_INT_ID = "compute_PciSlotScanDef_intId"
	CONST_PROP_ID_COMPUTE_PCI_SLOT_SCAN_DEF_NAME = "compute_PciSlotScanDef_name"
	CONST_PROP_ID_COMPUTE_PCI_SLOT_SCAN_DEF_POLICY_LEVEL = "compute_PciSlotScanDef_policyLevel"
	CONST_PROP_ID_COMPUTE_PCI_SLOT_SCAN_DEF_POLICY_OWNER = "compute_PciSlotScanDef_policyOwner"
	CONST_PROP_ID_COMPUTE_PCI_SLOT_SCAN_DEF_SCAN_ORDER = "compute_PciSlotScanDef_scanOrder"
	CONST_PROP_ID_COMPUTE_PCI_SLOT_SCAN_DEF_SLOT_ID = "compute_PciSlotScanDef_slotId"
	CONST_PROP_ID_COMPUTE_PHYSICAL_ASSOC_CTX_FRU_CAP_DN = "compute_PhysicalAssocCtx_fruCapDn"
	CONST_PROP_ID_COMPUTE_PHYSICAL_FSM_STAGE_DESCR = "compute_PhysicalFsmStage_descr"
	CONST_PROP_ID_COMPUTE_PHYSICAL_FSM_STAGE_LAST_UPDATE_TIME = "compute_PhysicalFsmStage_lastUpdateTime"
	CONST_PROP_ID_COMPUTE_PHYSICAL_FSM_STAGE_NAME = "compute_PhysicalFsmStage_name"
	CONST_PROP_ID_COMPUTE_PHYSICAL_FSM_STAGE_ORDER = "compute_PhysicalFsmStage_order"
	CONST_PROP_ID_COMPUTE_PHYSICAL_FSM_STAGE_RETRY = "compute_PhysicalFsmStage_retry"
	CONST_PROP_ID_COMPUTE_PHYSICAL_FSM_STAGE_STAGE_STATUS = "compute_PhysicalFsmStage_stageStatus"
	CONST_PROP_ID_COMPUTE_PHYSICAL_FSM_TASK_COMPLETION = "compute_PhysicalFsmTask_completion"
	CONST_PROP_ID_COMPUTE_PHYSICAL_FSM_TASK_FLAGS = "compute_PhysicalFsmTask_flags"
	CONST_PROP_ID_COMPUTE_PHYSICAL_FSM_TASK_ITEM = "compute_PhysicalFsmTask_item"
	CONST_PROP_ID_COMPUTE_PHYSICAL_FSM_TASK_SEQ_ID = "compute_PhysicalFsmTask_seqId"
	CONST_PROP_ID_COMPUTE_PHYSICAL_FSM_COMPLETION_TIME = "compute_PhysicalFsm_completionTime"
	CONST_PROP_ID_COMPUTE_PHYSICAL_FSM_CURRENT_FSM = "compute_PhysicalFsm_currentFsm"
	CONST_PROP_ID_COMPUTE_PHYSICAL_FSM_DESCR = "compute_PhysicalFsm_descr"
	CONST_PROP_ID_COMPUTE_PHYSICAL_FSM_FSM_STATUS = "compute_PhysicalFsm_fsmStatus"
	CONST_PROP_ID_COMPUTE_PHYSICAL_FSM_INSTANCE_ID = "compute_PhysicalFsm_instanceId"
	CONST_PROP_ID_COMPUTE_PHYSICAL_FSM_PROGRESS = "compute_PhysicalFsm_progress"
	CONST_PROP_ID_COMPUTE_PHYSICAL_FSM_RMT_ERR_CODE = "compute_PhysicalFsm_rmtErrCode"
	CONST_PROP_ID_COMPUTE_PHYSICAL_FSM_RMT_ERR_DESCR = "compute_PhysicalFsm_rmtErrDescr"
	CONST_PROP_ID_COMPUTE_PHYSICAL_FSM_RMT_RSLT = "compute_PhysicalFsm_rmtRslt"
	CONST_PROP_ID_COMPUTE_PHYSICAL_QUAL_MODEL = "compute_PhysicalQual_model"
	CONST_PROP_ID_COMPUTE_PHYSICAL_ADMIN_POWER = "compute_Physical_adminPower"
	CONST_PROP_ID_COMPUTE_PHYSICAL_ADMIN_STATE = "compute_Physical_adminState"
	CONST_PROP_ID_COMPUTE_PHYSICAL_ASSIGNED_TO_DN = "compute_Physical_assignedToDn"
	CONST_PROP_ID_COMPUTE_PHYSICAL_ASSOCIATION = "compute_Physical_association"
	CONST_PROP_ID_COMPUTE_PHYSICAL_AVAILABILITY = "compute_Physical_availability"
	CONST_PROP_ID_COMPUTE_PHYSICAL_AVAILABLE_MEMORY = "compute_Physical_availableMemory"
	CONST_PROP_ID_COMPUTE_PHYSICAL_CHECK_POINT = "compute_Physical_checkPoint"
	CONST_PROP_ID_COMPUTE_PHYSICAL_CONN_PATH = "compute_Physical_connPath"
	CONST_PROP_ID_COMPUTE_PHYSICAL_CONN_STATUS = "compute_Physical_connStatus"
	CONST_PROP_ID_COMPUTE_PHYSICAL_DESCR = "compute_Physical_descr"
	CONST_PROP_ID_COMPUTE_PHYSICAL_DISCOVERY = "compute_Physical_discovery"
	CONST_PROP_ID_COMPUTE_PHYSICAL_FSM_DESCR = "compute_Physical_fsmDescr"
	CONST_PROP_ID_COMPUTE_PHYSICAL_FSM_FLAGS = "compute_Physical_fsmFlags"
	CONST_PROP_ID_COMPUTE_PHYSICAL_FSM_PREV = "compute_Physical_fsmPrev"
	CONST_PROP_ID_COMPUTE_PHYSICAL_FSM_PROGR = "compute_Physical_fsmProgr"
	CONST_PROP_ID_COMPUTE_PHYSICAL_FSM_RMT_INV_ERR_CODE = "compute_Physical_fsmRmtInvErrCode"
	CONST_PROP_ID_COMPUTE_PHYSICAL_FSM_RMT_INV_ERR_DESCR = "compute_Physical_fsmRmtInvErrDescr"
	CONST_PROP_ID_COMPUTE_PHYSICAL_FSM_RMT_INV_RSLT = "compute_Physical_fsmRmtInvRslt"
	CONST_PROP_ID_COMPUTE_PHYSICAL_FSM_STAGE_DESCR = "compute_Physical_fsmStageDescr"
	CONST_PROP_ID_COMPUTE_PHYSICAL_FSM_STAMP = "compute_Physical_fsmStamp"
	CONST_PROP_ID_COMPUTE_PHYSICAL_FSM_STATUS = "compute_Physical_fsmStatus"
	CONST_PROP_ID_COMPUTE_PHYSICAL_FSM_TRY = "compute_Physical_fsmTry"
	CONST_PROP_ID_COMPUTE_PHYSICAL_INT_ID = "compute_Physical_intId"
	CONST_PROP_ID_COMPUTE_PHYSICAL_LC = "compute_Physical_lc"
	CONST_PROP_ID_COMPUTE_PHYSICAL_LC_TS = "compute_Physical_lcTs"
	CONST_PROP_ID_COMPUTE_PHYSICAL_LOCAL_ID = "compute_Physical_localId"
	CONST_PROP_ID_COMPUTE_PHYSICAL_LOW_VOLTAGE_MEMORY = "compute_Physical_lowVoltageMemory"
	CONST_PROP_ID_COMPUTE_PHYSICAL_MANAGING_INST = "compute_Physical_managingInst"
	CONST_PROP_ID_COMPUTE_PHYSICAL_MEMORY_SPEED = "compute_Physical_memorySpeed"
	CONST_PROP_ID_COMPUTE_PHYSICAL_MFG_TIME = "compute_Physical_mfgTime"
	CONST_PROP_ID_COMPUTE_PHYSICAL_MODEL = "compute_Physical_model"
	CONST_PROP_ID_COMPUTE_PHYSICAL_NAME = "compute_Physical_name"
	CONST_PROP_ID_COMPUTE_PHYSICAL_NUM_OF_ADAPTORS = "compute_Physical_numOfAdaptors"
	CONST_PROP_ID_COMPUTE_PHYSICAL_NUM_OF_CORES = "compute_Physical_numOfCores"
	CONST_PROP_ID_COMPUTE_PHYSICAL_NUM_OF_CORES_ENABLED = "compute_Physical_numOfCoresEnabled"
	CONST_PROP_ID_COMPUTE_PHYSICAL_NUM_OF_CPUS = "compute_Physical_numOfCpus"
	CONST_PROP_ID_COMPUTE_PHYSICAL_NUM_OF_ETH_HOST_IFS = "compute_Physical_numOfEthHostIfs"
	CONST_PROP_ID_COMPUTE_PHYSICAL_NUM_OF_FC_HOST_IFS = "compute_Physical_numOfFcHostIfs"
	CONST_PROP_ID_COMPUTE_PHYSICAL_NUM_OF_THREADS = "compute_Physical_numOfThreads"
	CONST_PROP_ID_COMPUTE_PHYSICAL_OPER_POWER = "compute_Physical_operPower"
	CONST_PROP_ID_COMPUTE_PHYSICAL_OPER_QUALIFIER = "compute_Physical_operQualifier"
	CONST_PROP_ID_COMPUTE_PHYSICAL_OPER_STATE = "compute_Physical_operState"
	CONST_PROP_ID_COMPUTE_PHYSICAL_OPERABILITY = "compute_Physical_operability"
	CONST_PROP_ID_COMPUTE_PHYSICAL_ORIGINAL_UUID = "compute_Physical_originalUuid"
	CONST_PROP_ID_COMPUTE_PHYSICAL_PART_NUMBER = "compute_Physical_partNumber"
	CONST_PROP_ID_COMPUTE_PHYSICAL_POLICY_LEVEL = "compute_Physical_policyLevel"
	CONST_PROP_ID_COMPUTE_PHYSICAL_POLICY_OWNER = "compute_Physical_policyOwner"
	CONST_PROP_ID_COMPUTE_PHYSICAL_PRESENCE = "compute_Physical_presence"
	CONST_PROP_ID_COMPUTE_PHYSICAL_REVISION = "compute_Physical_revision"
	CONST_PROP_ID_COMPUTE_PHYSICAL_SERIAL = "compute_Physical_serial"
	CONST_PROP_ID_COMPUTE_PHYSICAL_SERVER_ID = "compute_Physical_serverId"
	CONST_PROP_ID_COMPUTE_PHYSICAL_TOTAL_MEMORY = "compute_Physical_totalMemory"
	CONST_PROP_ID_COMPUTE_PHYSICAL_USR_LBL = "compute_Physical_usrLbl"
	CONST_PROP_ID_COMPUTE_PHYSICAL_UUID = "compute_Physical_uuid"
	CONST_PROP_ID_COMPUTE_PHYSICAL_VENDOR = "compute_Physical_vendor"
	CONST_PROP_ID_COMPUTE_PHYSICAL_VID = "compute_Physical_vid"
	CONST_PROP_ID_COMPUTE_PLATFORM_MODEL = "compute_Platform_model"
	CONST_PROP_ID_COMPUTE_PLATFORM_PRODUCT_NAME = "compute_Platform_productName"
	CONST_PROP_ID_COMPUTE_PLATFORM_REVISION = "compute_Platform_revision"
	CONST_PROP_ID_COMPUTE_PLATFORM_VENDOR = "compute_Platform_vendor"
	CONST_PROP_ID_COMPUTE_PNU_OSIMAGE_IMG_LOC = "compute_PnuOSImage_imgLoc"
	CONST_PROP_ID_COMPUTE_PNU_OSIMAGE_IMG_NAME = "compute_PnuOSImage_imgName"
	CONST_PROP_ID_COMPUTE_POOL_POLICY_REF_ID = "compute_PoolPolicyRef_id"
	CONST_PROP_ID_COMPUTE_POOL_POLICY_REF_POLICY_DN = "compute_PoolPolicyRef_policyDn"
	CONST_PROP_ID_COMPUTE_POOL_ASSIGNED = "compute_Pool_assigned"
	CONST_PROP_ID_COMPUTE_POOL_ASSIGNMENT_ORDER = "compute_Pool_assignmentOrder"
	CONST_PROP_ID_COMPUTE_POOL_DESCR = "compute_Pool_descr"
	CONST_PROP_ID_COMPUTE_POOL_INT_ID = "compute_Pool_intId"
	CONST_PROP_ID_COMPUTE_POOL_NAME = "compute_Pool_name"
	CONST_PROP_ID_COMPUTE_POOL_POLICY_LEVEL = "compute_Pool_policyLevel"
	CONST_PROP_ID_COMPUTE_POOL_POLICY_OWNER = "compute_Pool_policyOwner"
	CONST_PROP_ID_COMPUTE_POOL_SIZE = "compute_Pool_size"
	CONST_PROP_ID_COMPUTE_POOLABLE_ID = "compute_Poolable_id"
	CONST_PROP_ID_COMPUTE_POOLABLE_POOL_DN = "compute_Poolable_poolDn"
	CONST_PROP_ID_COMPUTE_POOLED_PHYSICAL_ASSIGNED = "compute_PooledPhysical_assigned"
	CONST_PROP_ID_COMPUTE_POOLED_PHYSICAL_ASSIGNED_TO_DN = "compute_PooledPhysical_assignedToDn"
	CONST_PROP_ID_COMPUTE_POOLED_PHYSICAL_OWNER = "compute_PooledPhysical_owner"
	CONST_PROP_ID_COMPUTE_POOLED_PHYSICAL_POOLABLE_DN = "compute_PooledPhysical_poolableDn"
	CONST_PROP_ID_COMPUTE_POOLED_PHYSICAL_PREV_ASSIGNED_TO_DN = "compute_PooledPhysical_prevAssignedToDn"
	CONST_PROP_ID_COMPUTE_POOLED_RACK_UNIT_ASSIGNED = "compute_PooledRackUnit_assigned"
	CONST_PROP_ID_COMPUTE_POOLED_RACK_UNIT_ASSIGNED_TO_DN = "compute_PooledRackUnit_assignedToDn"
	CONST_PROP_ID_COMPUTE_POOLED_RACK_UNIT_ID = "compute_PooledRackUnit_id"
	CONST_PROP_ID_COMPUTE_POOLED_RACK_UNIT_OWNER = "compute_PooledRackUnit_owner"
	CONST_PROP_ID_COMPUTE_POOLED_RACK_UNIT_POOLABLE_DN = "compute_PooledRackUnit_poolableDn"
	CONST_PROP_ID_COMPUTE_POOLED_RACK_UNIT_PREV_ASSIGNED_TO_DN = "compute_PooledRackUnit_prevAssignedToDn"
	CONST_PROP_ID_COMPUTE_POOLED_SLOT_ASSIGNED = "compute_PooledSlot_assigned"
	CONST_PROP_ID_COMPUTE_POOLED_SLOT_ASSIGNED_TO_DN = "compute_PooledSlot_assignedToDn"
	CONST_PROP_ID_COMPUTE_POOLED_SLOT_CHASSIS_ID = "compute_PooledSlot_chassisId"
	CONST_PROP_ID_COMPUTE_POOLED_SLOT_OWNER = "compute_PooledSlot_owner"
	CONST_PROP_ID_COMPUTE_POOLED_SLOT_POOLABLE_DN = "compute_PooledSlot_poolableDn"
	CONST_PROP_ID_COMPUTE_POOLED_SLOT_PREV_ASSIGNED_TO_DN = "compute_PooledSlot_prevAssignedToDn"
	CONST_PROP_ID_COMPUTE_POOLED_SLOT_SLOT_ID = "compute_PooledSlot_slotId"
	CONST_PROP_ID_COMPUTE_POOLED_ASSIGNED = "compute_Pooled_assigned"
	CONST_PROP_ID_COMPUTE_POOLED_ASSIGNED_TO_DN = "compute_Pooled_assignedToDn"
	CONST_PROP_ID_COMPUTE_POOLED_OWNER = "compute_Pooled_owner"
	CONST_PROP_ID_COMPUTE_POOLED_POOLABLE_DN = "compute_Pooled_poolableDn"
	CONST_PROP_ID_COMPUTE_POOLED_PREV_ASSIGNED_TO_DN = "compute_Pooled_prevAssignedToDn"
	CONST_PROP_ID_COMPUTE_POOLING_POLICY_DESCR = "compute_PoolingPolicy_descr"
	CONST_PROP_ID_COMPUTE_POOLING_POLICY_INT_ID = "compute_PoolingPolicy_intId"
	CONST_PROP_ID_COMPUTE_POOLING_POLICY_NAME = "compute_PoolingPolicy_name"
	CONST_PROP_ID_COMPUTE_POOLING_POLICY_POLICY_LEVEL = "compute_PoolingPolicy_policyLevel"
	CONST_PROP_ID_COMPUTE_POOLING_POLICY_POLICY_OWNER = "compute_PoolingPolicy_policyOwner"
	CONST_PROP_ID_COMPUTE_POOLING_POLICY_POOL_DN = "compute_PoolingPolicy_poolDn"
	CONST_PROP_ID_COMPUTE_POOLING_POLICY_QUALIFIER = "compute_PoolingPolicy_qualifier"
	CONST_PROP_ID_COMPUTE_PSU_CONTROL_CLUSTER_STATE = "compute_PsuControl_clusterState"
	CONST_PROP_ID_COMPUTE_PSU_CONTROL_DESCR = "compute_PsuControl_descr"
	CONST_PROP_ID_COMPUTE_PSU_CONTROL_INPUT_POWER_STATE = "compute_PsuControl_inputPowerState"
	CONST_PROP_ID_COMPUTE_PSU_CONTROL_INT_ID = "compute_PsuControl_intId"
	CONST_PROP_ID_COMPUTE_PSU_CONTROL_NAME = "compute_PsuControl_name"
	CONST_PROP_ID_COMPUTE_PSU_CONTROL_OPER_QUALIFIER = "compute_PsuControl_operQualifier"
	CONST_PROP_ID_COMPUTE_PSU_CONTROL_OPER_STATE = "compute_PsuControl_operState"
	CONST_PROP_ID_COMPUTE_PSU_CONTROL_OUTPUT_POWER_STATE = "compute_PsuControl_outputPowerState"
	CONST_PROP_ID_COMPUTE_PSU_CONTROL_POLICY_LEVEL = "compute_PsuControl_policyLevel"
	CONST_PROP_ID_COMPUTE_PSU_CONTROL_POLICY_OWNER = "compute_PsuControl_policyOwner"
	CONST_PROP_ID_COMPUTE_PSU_CONTROL_REDUNDANCY = "compute_PsuControl_redundancy"
	CONST_PROP_ID_COMPUTE_PSU_DEF_DESCR = "compute_PsuDef_descr"
	CONST_PROP_ID_COMPUTE_PSU_DEF_INT_ID = "compute_PsuDef_intId"
	CONST_PROP_ID_COMPUTE_PSU_DEF_NAME = "compute_PsuDef_name"
	CONST_PROP_ID_COMPUTE_PSU_DEF_POLICY_LEVEL = "compute_PsuDef_policyLevel"
	CONST_PROP_ID_COMPUTE_PSU_DEF_POLICY_OWNER = "compute_PsuDef_policyOwner"
	CONST_PROP_ID_COMPUTE_PSU_DEF_REDUNDANCY = "compute_PsuDef_redundancy"
	CONST_PROP_ID_COMPUTE_PSU_POLICY_DESCR = "compute_PsuPolicy_descr"
	CONST_PROP_ID_COMPUTE_PSU_POLICY_INT_ID = "compute_PsuPolicy_intId"
	CONST_PROP_ID_COMPUTE_PSU_POLICY_NAME = "compute_PsuPolicy_name"
	CONST_PROP_ID_COMPUTE_PSU_POLICY_POLICY_LEVEL = "compute_PsuPolicy_policyLevel"
	CONST_PROP_ID_COMPUTE_PSU_POLICY_POLICY_OWNER = "compute_PsuPolicy_policyOwner"
	CONST_PROP_ID_COMPUTE_PSU_POLICY_REDUNDANCY = "compute_PsuPolicy_redundancy"
	CONST_PROP_ID_COMPUTE_QUAL_DESCR = "compute_Qual_descr"
	CONST_PROP_ID_COMPUTE_QUAL_INT_ID = "compute_Qual_intId"
	CONST_PROP_ID_COMPUTE_QUAL_NAME = "compute_Qual_name"
	CONST_PROP_ID_COMPUTE_QUAL_POLICY_LEVEL = "compute_Qual_policyLevel"
	CONST_PROP_ID_COMPUTE_QUAL_POLICY_OWNER = "compute_Qual_policyOwner"
	CONST_PROP_ID_COMPUTE_QUALIFIED_POLICY_DESCR = "compute_QualifiedPolicy_descr"
	CONST_PROP_ID_COMPUTE_QUALIFIED_POLICY_INT_ID = "compute_QualifiedPolicy_intId"
	CONST_PROP_ID_COMPUTE_QUALIFIED_POLICY_NAME = "compute_QualifiedPolicy_name"
	CONST_PROP_ID_COMPUTE_QUALIFIED_POLICY_POLICY_LEVEL = "compute_QualifiedPolicy_policyLevel"
	CONST_PROP_ID_COMPUTE_QUALIFIED_POLICY_POLICY_OWNER = "compute_QualifiedPolicy_policyOwner"
	CONST_PROP_ID_COMPUTE_QUALIFIED_POLICY_QUALIFIER = "compute_QualifiedPolicy_qualifier"
	CONST_PROP_ID_COMPUTE_RACK_POS_QUAL_MAX_ID = "compute_RackPosQual_maxId"
	CONST_PROP_ID_COMPUTE_RACK_POS_QUAL_MIN_ID = "compute_RackPosQual_minId"
	CONST_PROP_ID_COMPUTE_RACK_QUAL_MAX_ID = "compute_RackQual_maxId"
	CONST_PROP_ID_COMPUTE_RACK_QUAL_MIN_ID = "compute_RackQual_minId"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_FSM_STAGE_DESCR = "compute_RackUnitFsmStage_descr"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_FSM_STAGE_LAST_UPDATE_TIME = "compute_RackUnitFsmStage_lastUpdateTime"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_FSM_STAGE_NAME = "compute_RackUnitFsmStage_name"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_FSM_STAGE_ORDER = "compute_RackUnitFsmStage_order"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_FSM_STAGE_RETRY = "compute_RackUnitFsmStage_retry"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_FSM_STAGE_STAGE_STATUS = "compute_RackUnitFsmStage_stageStatus"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_FSM_TASK_COMPLETION = "compute_RackUnitFsmTask_completion"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_FSM_TASK_FLAGS = "compute_RackUnitFsmTask_flags"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_FSM_TASK_ITEM = "compute_RackUnitFsmTask_item"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_FSM_TASK_SEQ_ID = "compute_RackUnitFsmTask_seqId"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_FSM_COMPLETION_TIME = "compute_RackUnitFsm_completionTime"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_FSM_CURRENT_FSM = "compute_RackUnitFsm_currentFsm"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_FSM_DESCR = "compute_RackUnitFsm_descr"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_FSM_FSM_STATUS = "compute_RackUnitFsm_fsmStatus"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_FSM_INSTANCE_ID = "compute_RackUnitFsm_instanceId"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_FSM_PROGRESS = "compute_RackUnitFsm_progress"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_FSM_RMT_ERR_CODE = "compute_RackUnitFsm_rmtErrCode"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_FSM_RMT_ERR_DESCR = "compute_RackUnitFsm_rmtErrDescr"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_FSM_RMT_RSLT = "compute_RackUnitFsm_rmtRslt"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_AMBIENT_TEMP = "compute_RackUnitMbTempStatsHist_ambientTemp"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_AMBIENT_TEMP_AVG = "compute_RackUnitMbTempStatsHist_ambientTempAvg"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_AMBIENT_TEMP_MAX = "compute_RackUnitMbTempStatsHist_ambientTempMax"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_AMBIENT_TEMP_MIN = "compute_RackUnitMbTempStatsHist_ambientTempMin"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_FRONT_TEMP = "compute_RackUnitMbTempStatsHist_frontTemp"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_FRONT_TEMP_AVG = "compute_RackUnitMbTempStatsHist_frontTempAvg"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_FRONT_TEMP_MAX = "compute_RackUnitMbTempStatsHist_frontTempMax"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_FRONT_TEMP_MIN = "compute_RackUnitMbTempStatsHist_frontTempMin"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_ID = "compute_RackUnitMbTempStatsHist_id"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_IOH1_TEMP = "compute_RackUnitMbTempStatsHist_ioh1Temp"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_IOH1_TEMP_AVG = "compute_RackUnitMbTempStatsHist_ioh1TempAvg"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_IOH1_TEMP_MAX = "compute_RackUnitMbTempStatsHist_ioh1TempMax"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_IOH1_TEMP_MIN = "compute_RackUnitMbTempStatsHist_ioh1TempMin"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_IOH2_TEMP = "compute_RackUnitMbTempStatsHist_ioh2Temp"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_IOH2_TEMP_AVG = "compute_RackUnitMbTempStatsHist_ioh2TempAvg"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_IOH2_TEMP_MAX = "compute_RackUnitMbTempStatsHist_ioh2TempMax"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_IOH2_TEMP_MIN = "compute_RackUnitMbTempStatsHist_ioh2TempMin"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_MOST_RECENT = "compute_RackUnitMbTempStatsHist_mostRecent"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_REAR_TEMP = "compute_RackUnitMbTempStatsHist_rearTemp"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_REAR_TEMP_AVG = "compute_RackUnitMbTempStatsHist_rearTempAvg"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_REAR_TEMP_MAX = "compute_RackUnitMbTempStatsHist_rearTempMax"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_REAR_TEMP_MIN = "compute_RackUnitMbTempStatsHist_rearTempMin"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_SUSPECT = "compute_RackUnitMbTempStatsHist_suspect"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_THRESHOLDED = "compute_RackUnitMbTempStatsHist_thresholded"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_TIME_COLLECTED = "compute_RackUnitMbTempStatsHist_timeCollected"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATS_AMBIENT_TEMP = "compute_RackUnitMbTempStats_ambientTemp"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATS_AMBIENT_TEMP_AVG = "compute_RackUnitMbTempStats_ambientTempAvg"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATS_AMBIENT_TEMP_MAX = "compute_RackUnitMbTempStats_ambientTempMax"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATS_AMBIENT_TEMP_MIN = "compute_RackUnitMbTempStats_ambientTempMin"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATS_FRONT_TEMP = "compute_RackUnitMbTempStats_frontTemp"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATS_FRONT_TEMP_AVG = "compute_RackUnitMbTempStats_frontTempAvg"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATS_FRONT_TEMP_MAX = "compute_RackUnitMbTempStats_frontTempMax"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATS_FRONT_TEMP_MIN = "compute_RackUnitMbTempStats_frontTempMin"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATS_INTERVALS = "compute_RackUnitMbTempStats_intervals"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATS_IOH1_TEMP = "compute_RackUnitMbTempStats_ioh1Temp"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATS_IOH1_TEMP_AVG = "compute_RackUnitMbTempStats_ioh1TempAvg"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATS_IOH1_TEMP_MAX = "compute_RackUnitMbTempStats_ioh1TempMax"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATS_IOH1_TEMP_MIN = "compute_RackUnitMbTempStats_ioh1TempMin"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATS_IOH2_TEMP = "compute_RackUnitMbTempStats_ioh2Temp"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATS_IOH2_TEMP_AVG = "compute_RackUnitMbTempStats_ioh2TempAvg"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATS_IOH2_TEMP_MAX = "compute_RackUnitMbTempStats_ioh2TempMax"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATS_IOH2_TEMP_MIN = "compute_RackUnitMbTempStats_ioh2TempMin"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATS_REAR_TEMP = "compute_RackUnitMbTempStats_rearTemp"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATS_REAR_TEMP_AVG = "compute_RackUnitMbTempStats_rearTempAvg"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATS_REAR_TEMP_MAX = "compute_RackUnitMbTempStats_rearTempMax"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATS_REAR_TEMP_MIN = "compute_RackUnitMbTempStats_rearTempMin"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATS_SUSPECT = "compute_RackUnitMbTempStats_suspect"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATS_THRESHOLDED = "compute_RackUnitMbTempStats_thresholded"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATS_TIME_COLLECTED = "compute_RackUnitMbTempStats_timeCollected"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATS_UPDATE = "compute_RackUnitMbTempStats_update"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_ADMIN_POWER = "compute_RackUnit_adminPower"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_ADMIN_STATE = "compute_RackUnit_adminState"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_ASSIGNED_TO_DN = "compute_RackUnit_assignedToDn"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_ASSOCIATION = "compute_RackUnit_association"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_AVAILABILITY = "compute_RackUnit_availability"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_AVAILABLE_MEMORY = "compute_RackUnit_availableMemory"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_CHECK_POINT = "compute_RackUnit_checkPoint"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_CONN_PATH = "compute_RackUnit_connPath"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_CONN_STATUS = "compute_RackUnit_connStatus"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_DESCR = "compute_RackUnit_descr"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_DISCOVERY = "compute_RackUnit_discovery"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_FLT_AGGR = "compute_RackUnit_fltAggr"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_FSM_DESCR = "compute_RackUnit_fsmDescr"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_FSM_FLAGS = "compute_RackUnit_fsmFlags"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_FSM_PREV = "compute_RackUnit_fsmPrev"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_FSM_PROGR = "compute_RackUnit_fsmProgr"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_FSM_RMT_INV_ERR_CODE = "compute_RackUnit_fsmRmtInvErrCode"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_FSM_RMT_INV_ERR_DESCR = "compute_RackUnit_fsmRmtInvErrDescr"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_FSM_RMT_INV_RSLT = "compute_RackUnit_fsmRmtInvRslt"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_FSM_STAGE_DESCR = "compute_RackUnit_fsmStageDescr"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_FSM_STAMP = "compute_RackUnit_fsmStamp"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_FSM_STATUS = "compute_RackUnit_fsmStatus"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_FSM_TRY = "compute_RackUnit_fsmTry"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_ID = "compute_RackUnit_id"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_INT_ID = "compute_RackUnit_intId"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_LC = "compute_RackUnit_lc"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_LC_TS = "compute_RackUnit_lcTs"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_LOCAL_ID = "compute_RackUnit_localId"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_LOW_VOLTAGE_MEMORY = "compute_RackUnit_lowVoltageMemory"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MANAGING_INST = "compute_RackUnit_managingInst"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MEMORY_SPEED = "compute_RackUnit_memorySpeed"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MFG_TIME = "compute_RackUnit_mfgTime"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_MODEL = "compute_RackUnit_model"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_NAME = "compute_RackUnit_name"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_NUM_OF_ADAPTORS = "compute_RackUnit_numOfAdaptors"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_NUM_OF_CORES = "compute_RackUnit_numOfCores"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_NUM_OF_CORES_ENABLED = "compute_RackUnit_numOfCoresEnabled"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_NUM_OF_CPUS = "compute_RackUnit_numOfCpus"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_NUM_OF_ETH_HOST_IFS = "compute_RackUnit_numOfEthHostIfs"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_NUM_OF_FC_HOST_IFS = "compute_RackUnit_numOfFcHostIfs"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_NUM_OF_THREADS = "compute_RackUnit_numOfThreads"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_OPER_POWER = "compute_RackUnit_operPower"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_OPER_QUALIFIER = "compute_RackUnit_operQualifier"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_OPER_STATE = "compute_RackUnit_operState"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_OPERABILITY = "compute_RackUnit_operability"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_ORIGINAL_UUID = "compute_RackUnit_originalUuid"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_PART_NUMBER = "compute_RackUnit_partNumber"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_POLICY_LEVEL = "compute_RackUnit_policyLevel"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_POLICY_OWNER = "compute_RackUnit_policyOwner"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_PRESENCE = "compute_RackUnit_presence"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_REVISION = "compute_RackUnit_revision"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_SERIAL = "compute_RackUnit_serial"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_SERVER_ID = "compute_RackUnit_serverId"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_TOTAL_MEMORY = "compute_RackUnit_totalMemory"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_USR_LBL = "compute_RackUnit_usrLbl"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_UUID = "compute_RackUnit_uuid"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_VENDOR = "compute_RackUnit_vendor"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_VERSION_HOLDER = "compute_RackUnit_versionHolder"
	CONST_PROP_ID_COMPUTE_RACK_UNIT_VID = "compute_RackUnit_vid"
	CONST_PROP_ID_COMPUTE_RTC_BATTERY_ID = "compute_RtcBattery_id"
	CONST_PROP_ID_COMPUTE_RTC_BATTERY_MODEL = "compute_RtcBattery_model"
	CONST_PROP_ID_COMPUTE_RTC_BATTERY_OPER_QUALIFIER_REASON = "compute_RtcBattery_operQualifierReason"
	CONST_PROP_ID_COMPUTE_RTC_BATTERY_OPER_STATE = "compute_RtcBattery_operState"
	CONST_PROP_ID_COMPUTE_RTC_BATTERY_OPERABILITY = "compute_RtcBattery_operability"
	CONST_PROP_ID_COMPUTE_RTC_BATTERY_PERF = "compute_RtcBattery_perf"
	CONST_PROP_ID_COMPUTE_RTC_BATTERY_POWER = "compute_RtcBattery_power"
	CONST_PROP_ID_COMPUTE_RTC_BATTERY_PRESENCE = "compute_RtcBattery_presence"
	CONST_PROP_ID_COMPUTE_RTC_BATTERY_REVISION = "compute_RtcBattery_revision"
	CONST_PROP_ID_COMPUTE_RTC_BATTERY_SERIAL = "compute_RtcBattery_serial"
	CONST_PROP_ID_COMPUTE_RTC_BATTERY_THERMAL = "compute_RtcBattery_thermal"
	CONST_PROP_ID_COMPUTE_RTC_BATTERY_VENDOR = "compute_RtcBattery_vendor"
	CONST_PROP_ID_COMPUTE_RTC_BATTERY_VOLTAGE = "compute_RtcBattery_voltage"
	CONST_PROP_ID_COMPUTE_SCRUB_POLICY_BIOS_SETTINGS_SCRUB = "compute_ScrubPolicy_biosSettingsScrub"
	CONST_PROP_ID_COMPUTE_SCRUB_POLICY_DESCR = "compute_ScrubPolicy_descr"
	CONST_PROP_ID_COMPUTE_SCRUB_POLICY_DISK_SCRUB = "compute_ScrubPolicy_diskScrub"
	CONST_PROP_ID_COMPUTE_SCRUB_POLICY_FLEX_FLASH_SCRUB = "compute_ScrubPolicy_flexFlashScrub"
	CONST_PROP_ID_COMPUTE_SCRUB_POLICY_INT_ID = "compute_ScrubPolicy_intId"
	CONST_PROP_ID_COMPUTE_SCRUB_POLICY_NAME = "compute_ScrubPolicy_name"
	CONST_PROP_ID_COMPUTE_SCRUB_POLICY_POLICY_LEVEL = "compute_ScrubPolicy_policyLevel"
	CONST_PROP_ID_COMPUTE_SCRUB_POLICY_POLICY_OWNER = "compute_ScrubPolicy_policyOwner"
	CONST_PROP_ID_COMPUTE_SERVER_DISC_POLICY_FSM_STAGE_DESCR = "compute_ServerDiscPolicyFsmStage_descr"
	CONST_PROP_ID_COMPUTE_SERVER_DISC_POLICY_FSM_STAGE_LAST_UPDATE_TIME = "compute_ServerDiscPolicyFsmStage_lastUpdateTime"
	CONST_PROP_ID_COMPUTE_SERVER_DISC_POLICY_FSM_STAGE_NAME = "compute_ServerDiscPolicyFsmStage_name"
	CONST_PROP_ID_COMPUTE_SERVER_DISC_POLICY_FSM_STAGE_ORDER = "compute_ServerDiscPolicyFsmStage_order"
	CONST_PROP_ID_COMPUTE_SERVER_DISC_POLICY_FSM_STAGE_RETRY = "compute_ServerDiscPolicyFsmStage_retry"
	CONST_PROP_ID_COMPUTE_SERVER_DISC_POLICY_FSM_STAGE_STAGE_STATUS = "compute_ServerDiscPolicyFsmStage_stageStatus"
	CONST_PROP_ID_COMPUTE_SERVER_DISC_POLICY_FSM_TASK_COMPLETION = "compute_ServerDiscPolicyFsmTask_completion"
	CONST_PROP_ID_COMPUTE_SERVER_DISC_POLICY_FSM_TASK_FLAGS = "compute_ServerDiscPolicyFsmTask_flags"
	CONST_PROP_ID_COMPUTE_SERVER_DISC_POLICY_FSM_TASK_ITEM = "compute_ServerDiscPolicyFsmTask_item"
	CONST_PROP_ID_COMPUTE_SERVER_DISC_POLICY_FSM_TASK_SEQ_ID = "compute_ServerDiscPolicyFsmTask_seqId"
	CONST_PROP_ID_COMPUTE_SERVER_DISC_POLICY_FSM_COMPLETION_TIME = "compute_ServerDiscPolicyFsm_completionTime"
	CONST_PROP_ID_COMPUTE_SERVER_DISC_POLICY_FSM_CURRENT_FSM = "compute_ServerDiscPolicyFsm_currentFsm"
	CONST_PROP_ID_COMPUTE_SERVER_DISC_POLICY_FSM_DESCR = "compute_ServerDiscPolicyFsm_descr"
	CONST_PROP_ID_COMPUTE_SERVER_DISC_POLICY_FSM_FSM_STATUS = "compute_ServerDiscPolicyFsm_fsmStatus"
	CONST_PROP_ID_COMPUTE_SERVER_DISC_POLICY_FSM_INSTANCE_ID = "compute_ServerDiscPolicyFsm_instanceId"
	CONST_PROP_ID_COMPUTE_SERVER_DISC_POLICY_FSM_PROGRESS = "compute_ServerDiscPolicyFsm_progress"
	CONST_PROP_ID_COMPUTE_SERVER_DISC_POLICY_FSM_RMT_ERR_CODE = "compute_ServerDiscPolicyFsm_rmtErrCode"
	CONST_PROP_ID_COMPUTE_SERVER_DISC_POLICY_FSM_RMT_ERR_DESCR = "compute_ServerDiscPolicyFsm_rmtErrDescr"
	CONST_PROP_ID_COMPUTE_SERVER_DISC_POLICY_FSM_RMT_RSLT = "compute_ServerDiscPolicyFsm_rmtRslt"
	CONST_PROP_ID_COMPUTE_SERVER_DISC_POLICY_ACTION = "compute_ServerDiscPolicy_action"
	CONST_PROP_ID_COMPUTE_SERVER_DISC_POLICY_DESCR = "compute_ServerDiscPolicy_descr"
	CONST_PROP_ID_COMPUTE_SERVER_DISC_POLICY_FSM_DESCR = "compute_ServerDiscPolicy_fsmDescr"
	CONST_PROP_ID_COMPUTE_SERVER_DISC_POLICY_FSM_PREV = "compute_ServerDiscPolicy_fsmPrev"
	CONST_PROP_ID_COMPUTE_SERVER_DISC_POLICY_FSM_PROGR = "compute_ServerDiscPolicy_fsmProgr"
	CONST_PROP_ID_COMPUTE_SERVER_DISC_POLICY_FSM_RMT_INV_ERR_CODE = "compute_ServerDiscPolicy_fsmRmtInvErrCode"
	CONST_PROP_ID_COMPUTE_SERVER_DISC_POLICY_FSM_RMT_INV_ERR_DESCR = "compute_ServerDiscPolicy_fsmRmtInvErrDescr"
	CONST_PROP_ID_COMPUTE_SERVER_DISC_POLICY_FSM_RMT_INV_RSLT = "compute_ServerDiscPolicy_fsmRmtInvRslt"
	CONST_PROP_ID_COMPUTE_SERVER_DISC_POLICY_FSM_STAGE_DESCR = "compute_ServerDiscPolicy_fsmStageDescr"
	CONST_PROP_ID_COMPUTE_SERVER_DISC_POLICY_FSM_STAMP = "compute_ServerDiscPolicy_fsmStamp"
	CONST_PROP_ID_COMPUTE_SERVER_DISC_POLICY_FSM_STATUS = "compute_ServerDiscPolicy_fsmStatus"
	CONST_PROP_ID_COMPUTE_SERVER_DISC_POLICY_FSM_TRY = "compute_ServerDiscPolicy_fsmTry"
	CONST_PROP_ID_COMPUTE_SERVER_DISC_POLICY_INT_ID = "compute_ServerDiscPolicy_intId"
	CONST_PROP_ID_COMPUTE_SERVER_DISC_POLICY_NAME = "compute_ServerDiscPolicy_name"
	CONST_PROP_ID_COMPUTE_SERVER_DISC_POLICY_POLICY_LEVEL = "compute_ServerDiscPolicy_policyLevel"
	CONST_PROP_ID_COMPUTE_SERVER_DISC_POLICY_POLICY_OWNER = "compute_ServerDiscPolicy_policyOwner"
	CONST_PROP_ID_COMPUTE_SERVER_DISC_POLICY_QUALIFIER = "compute_ServerDiscPolicy_qualifier"
	CONST_PROP_ID_COMPUTE_SERVER_DISC_POLICY_SCRUB_POLICY_NAME = "compute_ServerDiscPolicy_scrubPolicyName"
	CONST_PROP_ID_COMPUTE_SERVER_MGMT_POLICY_ACTION = "compute_ServerMgmtPolicy_action"
	CONST_PROP_ID_COMPUTE_SERVER_MGMT_POLICY_DESCR = "compute_ServerMgmtPolicy_descr"
	CONST_PROP_ID_COMPUTE_SERVER_MGMT_POLICY_INT_ID = "compute_ServerMgmtPolicy_intId"
	CONST_PROP_ID_COMPUTE_SERVER_MGMT_POLICY_NAME = "compute_ServerMgmtPolicy_name"
	CONST_PROP_ID_COMPUTE_SERVER_MGMT_POLICY_POLICY_LEVEL = "compute_ServerMgmtPolicy_policyLevel"
	CONST_PROP_ID_COMPUTE_SERVER_MGMT_POLICY_POLICY_OWNER = "compute_ServerMgmtPolicy_policyOwner"
	CONST_PROP_ID_COMPUTE_SERVER_MGMT_POLICY_QUALIFIER = "compute_ServerMgmtPolicy_qualifier"
	CONST_PROP_ID_COMPUTE_SLOT_QUAL_MAX_ID = "compute_SlotQual_maxId"
	CONST_PROP_ID_COMPUTE_SLOT_QUAL_MIN_ID = "compute_SlotQual_minId"
	CONST_PROP_ID_COMPUTE_VIRTUAL_CONTAINER_DESCR = "compute_VirtualContainer_descr"
	CONST_PROP_ID_COMPUTE_VIRTUAL_CONTAINER_INT_ID = "compute_VirtualContainer_intId"
	CONST_PROP_ID_COMPUTE_VIRTUAL_CONTAINER_LS_DN = "compute_VirtualContainer_lsDn"
	CONST_PROP_ID_COMPUTE_VIRTUAL_CONTAINER_NAME = "compute_VirtualContainer_name"
	CONST_PROP_ID_COMPUTE_VIRTUAL_CONTAINER_PN_DN = "compute_VirtualContainer_pnDn"
	CONST_PROP_ID_COMPUTE_VIRTUAL_CONTAINER_POLICY_LEVEL = "compute_VirtualContainer_policyLevel"
	CONST_PROP_ID_COMPUTE_VIRTUAL_CONTAINER_POLICY_OWNER = "compute_VirtualContainer_policyOwner"
	CONST_PROP_ID_COMPUTE_VIRTUAL_CONTAINER_UUID = "compute_VirtualContainer_uuid"
	CONST_PROP_ID_COMPUTE_VIRTUAL_DESCR = "compute_Virtual_descr"
	CONST_PROP_ID_COMPUTE_VIRTUAL_INT_ID = "compute_Virtual_intId"
	CONST_PROP_ID_COMPUTE_VIRTUAL_LS_DN = "compute_Virtual_lsDn"
	CONST_PROP_ID_COMPUTE_VIRTUAL_NAME = "compute_Virtual_name"
	CONST_PROP_ID_COMPUTE_VIRTUAL_PN_DN = "compute_Virtual_pnDn"
	CONST_PROP_ID_COMPUTE_VIRTUAL_POLICY_LEVEL = "compute_Virtual_policyLevel"
	CONST_PROP_ID_COMPUTE_VIRTUAL_POLICY_OWNER = "compute_Virtual_policyOwner"
	CONST_PROP_ID_COMPUTE_VIRTUAL_UUID = "compute_Virtual_uuid"
	CONST_PROP_ID_CONDITION_IMMUTABLE_CAUSE = "condition_Immutable_cause"
	CONST_PROP_ID_CONDITION_IMMUTABLE_CHANGE_SET = "condition_Immutable_changeSet"
	CONST_PROP_ID_CONDITION_IMMUTABLE_CODE = "condition_Immutable_code"
	CONST_PROP_ID_CONDITION_IMMUTABLE_CREATED = "condition_Immutable_created"
	CONST_PROP_ID_CONDITION_IMMUTABLE_DESCR = "condition_Immutable_descr"
	CONST_PROP_ID_CONDITION_IMMUTABLE_ID = "condition_Immutable_id"
	CONST_PROP_ID_CONDITION_IMMUTABLE_RULE = "condition_Immutable_rule"
	CONST_PROP_ID_CONDITION_IMMUTABLE_SEVERITY = "condition_Immutable_severity"
	CONST_PROP_ID_CONDITION_IMMUTABLE_TAGS = "condition_Immutable_tags"
	CONST_PROP_ID_CONDITION_IMMUTABLE_TYPE = "condition_Immutable_type"
	CONST_PROP_ID_CONDITION_INFO_CAUSE = "condition_Info_cause"
	CONST_PROP_ID_CONDITION_INFO_CHANGE_SET = "condition_Info_changeSet"
	CONST_PROP_ID_CONDITION_INFO_CODE = "condition_Info_code"
	CONST_PROP_ID_CONDITION_INFO_CREATED = "condition_Info_created"
	CONST_PROP_ID_CONDITION_INFO_DESCR = "condition_Info_descr"
	CONST_PROP_ID_CONDITION_INFO_SEVERITY = "condition_Info_severity"
	CONST_PROP_ID_CONDITION_LOG_MAX_SIZE = "condition_Log_maxSize"
	CONST_PROP_ID_CONDITION_LOG_PURGE_WINDOW = "condition_Log_purgeWindow"
	CONST_PROP_ID_CONDITION_LOG_SIZE = "condition_Log_size"
	CONST_PROP_ID_CONDITION_LOGGABLE_AFFECTED = "condition_Loggable_affected"
	CONST_PROP_ID_CONDITION_LOGGABLE_CAUSE = "condition_Loggable_cause"
	CONST_PROP_ID_CONDITION_LOGGABLE_CHANGE_SET = "condition_Loggable_changeSet"
	CONST_PROP_ID_CONDITION_LOGGABLE_CODE = "condition_Loggable_code"
	CONST_PROP_ID_CONDITION_LOGGABLE_CREATED = "condition_Loggable_created"
	CONST_PROP_ID_CONDITION_LOGGABLE_DESCR = "condition_Loggable_descr"
	CONST_PROP_ID_CONDITION_LOGGABLE_ID = "condition_Loggable_id"
	CONST_PROP_ID_CONDITION_LOGGABLE_IND = "condition_Loggable_ind"
	CONST_PROP_ID_CONDITION_LOGGABLE_SESSION_ID = "condition_Loggable_sessionId"
	CONST_PROP_ID_CONDITION_LOGGABLE_SEVERITY = "condition_Loggable_severity"
	CONST_PROP_ID_CONDITION_LOGGABLE_TRIG = "condition_Loggable_trig"
	CONST_PROP_ID_CONDITION_LOGGABLE_TX_ID = "condition_Loggable_txId"
	CONST_PROP_ID_CONDITION_LOGGABLE_USER = "condition_Loggable_user"
	CONST_PROP_ID_CONDITION_MULTI_INSTANCE_IMMUTABLE_CAUSE = "condition_MultiInstanceImmutable_cause"
	CONST_PROP_ID_CONDITION_MULTI_INSTANCE_IMMUTABLE_CHANGE_SET = "condition_MultiInstanceImmutable_changeSet"
	CONST_PROP_ID_CONDITION_MULTI_INSTANCE_IMMUTABLE_CODE = "condition_MultiInstanceImmutable_code"
	CONST_PROP_ID_CONDITION_MULTI_INSTANCE_IMMUTABLE_CREATED = "condition_MultiInstanceImmutable_created"
	CONST_PROP_ID_CONDITION_MULTI_INSTANCE_IMMUTABLE_DESCR = "condition_MultiInstanceImmutable_descr"
	CONST_PROP_ID_CONDITION_MULTI_INSTANCE_IMMUTABLE_ID = "condition_MultiInstanceImmutable_id"
	CONST_PROP_ID_CONDITION_MULTI_INSTANCE_IMMUTABLE_RULE = "condition_MultiInstanceImmutable_rule"
	CONST_PROP_ID_CONDITION_MULTI_INSTANCE_IMMUTABLE_SEVERITY = "condition_MultiInstanceImmutable_severity"
	CONST_PROP_ID_CONDITION_MULTI_INSTANCE_IMMUTABLE_TAGS = "condition_MultiInstanceImmutable_tags"
	CONST_PROP_ID_CONDITION_MULTI_INSTANCE_IMMUTABLE_TYPE = "condition_MultiInstanceImmutable_type"
	CONST_PROP_ID_CONDITION_MUTABLE_CAUSE = "condition_Mutable_cause"
	CONST_PROP_ID_CONDITION_MUTABLE_CHANGE_SET = "condition_Mutable_changeSet"
	CONST_PROP_ID_CONDITION_MUTABLE_CODE = "condition_Mutable_code"
	CONST_PROP_ID_CONDITION_MUTABLE_CREATED = "condition_Mutable_created"
	CONST_PROP_ID_CONDITION_MUTABLE_DESCR = "condition_Mutable_descr"
	CONST_PROP_ID_CONDITION_MUTABLE_HIGHEST_SEVERITY = "condition_Mutable_highestSeverity"
	CONST_PROP_ID_CONDITION_MUTABLE_ID = "condition_Mutable_id"
	CONST_PROP_ID_CONDITION_MUTABLE_LAST_TRANSITION = "condition_Mutable_lastTransition"
	CONST_PROP_ID_CONDITION_MUTABLE_ORIG_SEVERITY = "condition_Mutable_origSeverity"
	CONST_PROP_ID_CONDITION_MUTABLE_PREV_SEVERITY = "condition_Mutable_prevSeverity"
	CONST_PROP_ID_CONDITION_MUTABLE_RULE = "condition_Mutable_rule"
	CONST_PROP_ID_CONDITION_MUTABLE_SEVERITY = "condition_Mutable_severity"
	CONST_PROP_ID_CONDITION_MUTABLE_TAGS = "condition_Mutable_tags"
	CONST_PROP_ID_CONDITION_MUTABLE_TYPE = "condition_Mutable_type"
	CONST_PROP_ID_CONDITION_POLICY_DESCR = "condition_Policy_descr"
	CONST_PROP_ID_CONDITION_POLICY_INT_ID = "condition_Policy_intId"
	CONST_PROP_ID_CONDITION_POLICY_NAME = "condition_Policy_name"
	CONST_PROP_ID_CONDITION_POLICY_POLICY_LEVEL = "condition_Policy_policyLevel"
	CONST_PROP_ID_CONDITION_POLICY_POLICY_OWNER = "condition_Policy_policyOwner"
	CONST_PROP_ID_CONDITION_POLICY_RETENTION_INTERVAL = "condition_Policy_retentionInterval"
	CONST_PROP_ID_CONDITION_POLICY_SIZE_LIMIT = "condition_Policy_sizeLimit"
	CONST_PROP_ID_CONDITION_REPORTABLE_CAUSE = "condition_Reportable_cause"
	CONST_PROP_ID_CONDITION_REPORTABLE_CHANGE_SET = "condition_Reportable_changeSet"
	CONST_PROP_ID_CONDITION_REPORTABLE_CODE = "condition_Reportable_code"
	CONST_PROP_ID_CONDITION_REPORTABLE_CREATED = "condition_Reportable_created"
	CONST_PROP_ID_CONDITION_REPORTABLE_DESCR = "condition_Reportable_descr"
	CONST_PROP_ID_CONDITION_REPORTABLE_ID = "condition_Reportable_id"
	CONST_PROP_ID_CONDITION_REPORTABLE_RULE = "condition_Reportable_rule"
	CONST_PROP_ID_CONDITION_REPORTABLE_SEVERITY = "condition_Reportable_severity"
	CONST_PROP_ID_CONDITION_REPORTABLE_TAGS = "condition_Reportable_tags"
	CONST_PROP_ID_CONDITION_REPORTABLE_TYPE = "condition_Reportable_type"
	CONST_PROP_ID_CONFIG_IMPACT_RESPONSE_APP_CONNECTOR_ID = "config_ImpactResponse_appConnectorId"
	CONST_PROP_ID_CONFIG_IMPACT_RESPONSE_IMPACT_ANALYZER_ID = "config_ImpactResponse_impactAnalyzerId"
	CONST_PROP_ID_CONFIG_IMPACT_RESPONSE_SOURCE_CONNECTOR_ID = "config_ImpactResponse_sourceConnectorId"
	CONST_PROP_ID_CONFIG_IMPACT_RESPONSE_STATE = "config_ImpactResponse_state"
	CONST_PROP_ID_CONFIG_IMPACT_AFFECTED_OBJ = "config_Impact_affectedObj"
	CONST_PROP_ID_CONFIG_IMPACT_AFFECTED_SERVER = "config_Impact_affectedServer"
	CONST_PROP_ID_CONFIG_IMPACT_CHANGES = "config_Impact_changes"
	CONST_PROP_ID_CONFIG_IMPACT_CONFIG_ISSUES = "config_Impact_configIssues"
	CONST_PROP_ID_CONFIG_IMPACT_CONFIG_QUALIFIER = "config_Impact_configQualifier"
	CONST_PROP_ID_CONFIG_IMPACT_CONFIG_STATE = "config_Impact_configState"
	CONST_PROP_ID_CONFIG_IMPACT_DEPLOYMENT_MODE = "config_Impact_deploymentMode"
	CONST_PROP_ID_CONFIG_IMPACT_NAME = "config_Impact_name"
	CONST_PROP_ID_CONFIG_IMPACT_REBOOT_REQUIRED = "config_Impact_rebootRequired"
	CONST_PROP_ID_CONFIG_MANAGED_EP_IMPACT_RESPONSE_AFFECTED_SERVERS = "config_ManagedEpImpactResponse_affectedServers"
	CONST_PROP_ID_CONFIG_MANAGED_EP_IMPACT_RESPONSE_APP_CONNECTOR_ID = "config_ManagedEpImpactResponse_appConnectorId"
	CONST_PROP_ID_CONFIG_MANAGED_EP_IMPACT_RESPONSE_EP_NAME = "config_ManagedEpImpactResponse_epName"
	CONST_PROP_ID_CONFIG_MANAGED_EP_IMPACT_RESPONSE_IMPACT_ANALYZER_ID = "config_ManagedEpImpactResponse_impactAnalyzerId"
	CONST_PROP_ID_CONFIG_MANAGED_EP_IMPACT_RESPONSE_REBOOT_REQUIRED = "config_ManagedEpImpactResponse_rebootRequired"
	CONST_PROP_ID_CONFIG_MANAGED_EP_IMPACT_RESPONSE_SOURCE_CONNECTOR_ID = "config_ManagedEpImpactResponse_sourceConnectorId"
	CONST_PROP_ID_CONFIG_MANAGED_EP_IMPACT_RESPONSE_STATE = "config_ManagedEpImpactResponse_state"
	CONST_PROP_ID_CONFIG_SORTER_DIRECTION = "config_Sorter_direction"
	CONST_PROP_ID_CONFIG_SORTER_SORT_CLASS = "config_Sorter_sortClass"
	CONST_PROP_ID_CONFIG_SORTER_SORT_PROP = "config_Sorter_sortProp"
	CONST_PROP_ID_DCX_NS_ALLOC_STATUS = "dcx_Ns_allocStatus"
	CONST_PROP_ID_DCX_NS_SIDE = "dcx_Ns_side"
	CONST_PROP_ID_DCX_NS_SIZE = "dcx_Ns_size"
	CONST_PROP_ID_DCX_NS_SWITCH_ID = "dcx_Ns_switchId"
	CONST_PROP_ID_DCX_NS_USED = "dcx_Ns_used"
	CONST_PROP_ID_DCX_PATH_PROTECTION_PROT_PEER_ID = "dcx_PathProtection_protPeerId"
	CONST_PROP_ID_DCX_PATH_PROTECTION_PROT_ROLE = "dcx_PathProtection_protRole"
	CONST_PROP_ID_DCX_STATEFUL_END_POINT_ADMIN_STATE = "dcx_StatefulEndPoint_adminState"
	CONST_PROP_ID_DCX_VIF_ADMIN_STATE = "dcx_VIf_adminState"
	CONST_PROP_ID_DCX_VIF_COOKIE = "dcx_VIf_cookie"
	CONST_PROP_ID_DCX_VIF_EP_DN = "dcx_VIf_epDn"
	CONST_PROP_ID_DCX_VIF_ID = "dcx_VIf_id"
	CONST_PROP_ID_DCX_VIF_IF_ROLE = "dcx_VIf_ifRole"
	CONST_PROP_ID_DCX_VIF_IF_TYPE = "dcx_VIf_ifType"
	CONST_PROP_ID_DCX_VIF_INST_TYPE = "dcx_VIf_instType"
	CONST_PROP_ID_DCX_VIF_LC = "dcx_VIf_lc"
	CONST_PROP_ID_DCX_VIF_LINK_STATE = "dcx_VIf_linkState"
	CONST_PROP_ID_DCX_VIF_LOCALE = "dcx_VIf_locale"
	CONST_PROP_ID_DCX_VIF_NAME = "dcx_VIf_name"
	CONST_PROP_ID_DCX_VIF_OPER_STATE = "dcx_VIf_operState"
	CONST_PROP_ID_DCX_VIF_PEER_DN = "dcx_VIf_peerDn"
	CONST_PROP_ID_DCX_VIF_PROT_PEER_ID = "dcx_VIf_protPeerId"
	CONST_PROP_ID_DCX_VIF_PROT_ROLE = "dcx_VIf_protRole"
	CONST_PROP_ID_DCX_VIF_PROT_STATE = "dcx_VIf_protState"
	CONST_PROP_ID_DCX_VIF_QOS_CONTROL = "dcx_VIf_qosControl"
	CONST_PROP_ID_DCX_VIF_STATE = "dcx_VIf_state"
	CONST_PROP_ID_DCX_VIF_SWITCH_ID = "dcx_VIf_switchId"
	CONST_PROP_ID_DCX_VIF_TAG = "dcx_VIf_tag"
	CONST_PROP_ID_DCX_VIF_TRANSPORT = "dcx_VIf_transport"
	CONST_PROP_ID_DCX_VIF_TYPE = "dcx_VIf_type"
	CONST_PROP_ID_DCX_VC_ADMIN_STATE = "dcx_Vc_adminState"
	CONST_PROP_ID_DCX_VC_BORDER_PORT_ID = "dcx_Vc_borderPortId"
	CONST_PROP_ID_DCX_VC_BORDER_SLOT_ID = "dcx_Vc_borderSlotId"
	CONST_PROP_ID_DCX_VC_BORDER_VFC_ID = "dcx_Vc_borderVfcId"
	CONST_PROP_ID_DCX_VC_CDP = "dcx_Vc_cdp"
	CONST_PROP_ID_DCX_VC_COOKIE = "dcx_Vc_cookie"
	CONST_PROP_ID_DCX_VC_COS = "dcx_Vc_cos"
	CONST_PROP_ID_DCX_VC_DERIVED_FROM_ID = "dcx_Vc_derivedFromId"
	CONST_PROP_ID_DCX_VC_ENCAP = "dcx_Vc_encap"
	CONST_PROP_ID_DCX_VC_FCOE_ID = "dcx_Vc_fcoeId"
	CONST_PROP_ID_DCX_VC_FORGE_MAC = "dcx_Vc_forgeMac"
	CONST_PROP_ID_DCX_VC_ID = "dcx_Vc_id"
	CONST_PROP_ID_DCX_VC_INST_TYPE = "dcx_Vc_instType"
	CONST_PROP_ID_DCX_VC_LC = "dcx_Vc_lc"
	CONST_PROP_ID_DCX_VC_LINK_STATE = "dcx_Vc_linkState"
	CONST_PROP_ID_DCX_VC_LOCALE = "dcx_Vc_locale"
	CONST_PROP_ID_DCX_VC_MAC_REGISTER_MODE = "dcx_Vc_macRegisterMode"
	CONST_PROP_ID_DCX_VC_MON_TRAF_DIR = "dcx_Vc_monTrafDir"
	CONST_PROP_ID_DCX_VC_NAME = "dcx_Vc_name"
	CONST_PROP_ID_DCX_VC_OPER_BORDER_PORT_ID = "dcx_Vc_operBorderPortId"
	CONST_PROP_ID_DCX_VC_OPER_BORDER_SLOT_ID = "dcx_Vc_operBorderSlotId"
	CONST_PROP_ID_DCX_VC_OPER_STATE = "dcx_Vc_operState"
	CONST_PROP_ID_DCX_VC_PEER_ID = "dcx_Vc_peerId"
	CONST_PROP_ID_DCX_VC_PROT_STATE = "dcx_Vc_protState"
	CONST_PROP_ID_DCX_VC_QOS_POLICY_DN = "dcx_Vc_qosPolicyDn"
	CONST_PROP_ID_DCX_VC_QOS_POLICY_ID = "dcx_Vc_qosPolicyId"
	CONST_PROP_ID_DCX_VC_ROLE = "dcx_Vc_role"
	CONST_PROP_ID_DCX_VC_STATE = "dcx_Vc_state"
	CONST_PROP_ID_DCX_VC_STATE_QUAL = "dcx_Vc_stateQual"
	CONST_PROP_ID_DCX_VC_SWITCH_ID = "dcx_Vc_switchId"
	CONST_PROP_ID_DCX_VC_TAG = "dcx_Vc_tag"
	CONST_PROP_ID_DCX_VC_TRANSPORT = "dcx_Vc_transport"
	CONST_PROP_ID_DCX_VC_TYPE = "dcx_Vc_type"
	CONST_PROP_ID_DCX_VC_UPLINK_FAIL_ACTION = "dcx_Vc_uplinkFailAction"
	CONST_PROP_ID_DCX_VC_VNIC = "dcx_Vc_vnic"
	CONST_PROP_ID_DCX_VIF_EP_ID = "dcx_VifEp_id"
	CONST_PROP_ID_DHCP_ACQUIRED_ACQTS = "dhcp_Acquired_acqts"
	CONST_PROP_ID_DHCP_ACQUIRED_COOKIE = "dhcp_Acquired_cookie"
	CONST_PROP_ID_DHCP_ACQUIRED_ENDS = "dhcp_Acquired_ends"
	CONST_PROP_ID_DHCP_ACQUIRED_IP = "dhcp_Acquired_ip"
	CONST_PROP_ID_DHCP_ACQUIRED_MAC = "dhcp_Acquired_mac"
	CONST_PROP_ID_DHCP_ACQUIRED_SYS_ID = "dhcp_Acquired_sysId"
	CONST_PROP_ID_DHCP_LEASE_CLI_ID = "dhcp_Lease_cliId"
	CONST_PROP_ID_DHCP_LEASE_COOKIE = "dhcp_Lease_cookie"
	CONST_PROP_ID_DHCP_LEASE_ENDS = "dhcp_Lease_ends"
	CONST_PROP_ID_DHCP_LEASE_HOSTNAME = "dhcp_Lease_hostname"
	CONST_PROP_ID_DHCP_LEASE_INTF = "dhcp_Lease_intf"
	CONST_PROP_ID_DHCP_LEASE_IP = "dhcp_Lease_ip"
	CONST_PROP_ID_DHCP_LEASE_MAC = "dhcp_Lease_mac"
	CONST_PROP_ID_DHCP_LEASE_STARTS = "dhcp_Lease_starts"
	CONST_PROP_ID_DIAG_BLADE_TEST_LENGTH = "diag_BladeTest_length"
	CONST_PROP_ID_DIAG_BLADE_TEST_ORDER = "diag_BladeTest_order"
	CONST_PROP_ID_DIAG_BLADE_TEST_TYPE = "diag_BladeTest_type"
	CONST_PROP_ID_DIAG_CTRL_ADMIN_STATE = "diag_Ctrl_adminState"
	CONST_PROP_ID_DIAG_CTRL_END_TS = "diag_Ctrl_endTs"
	CONST_PROP_ID_DIAG_CTRL_END_TS_M = "diag_Ctrl_endTsM"
	CONST_PROP_ID_DIAG_CTRL_ERROR_DESCR = "diag_Ctrl_errorDescr"
	CONST_PROP_ID_DIAG_CTRL_OPER_QUALIFIER = "diag_Ctrl_operQualifier"
	CONST_PROP_ID_DIAG_CTRL_OPER_STATE = "diag_Ctrl_operState"
	CONST_PROP_ID_DIAG_CTRL_START_TS = "diag_Ctrl_startTs"
	CONST_PROP_ID_DIAG_CTRL_START_TS_M = "diag_Ctrl_startTsM"
	CONST_PROP_ID_DIAG_CTRL_TYPE = "diag_Ctrl_type"
	CONST_PROP_ID_DIAG_NETWORK_TEST_LENGTH = "diag_NetworkTest_length"
	CONST_PROP_ID_DIAG_NETWORK_TEST_ORDER = "diag_NetworkTest_order"
	CONST_PROP_ID_DIAG_NETWORK_TEST_SWITCH_ID = "diag_NetworkTest_switchId"
	CONST_PROP_ID_DIAG_NETWORK_TEST_TYPE = "diag_NetworkTest_type"
	CONST_PROP_ID_DIAG_RSLT_DESCR = "diag_Rslt_descr"
	CONST_PROP_ID_DIAG_RSLT_END_TS = "diag_Rslt_endTs"
	CONST_PROP_ID_DIAG_RSLT_ID = "diag_Rslt_id"
	CONST_PROP_ID_DIAG_RSLT_RESULT = "diag_Rslt_result"
	CONST_PROP_ID_DIAG_RSLT_RSLT_STATUS = "diag_Rslt_rsltStatus"
	CONST_PROP_ID_DIAG_RSLT_START_TS = "diag_Rslt_startTs"
	CONST_PROP_ID_DIAG_RUN_POLICY_DESCR = "diag_RunPolicy_descr"
	CONST_PROP_ID_DIAG_RUN_POLICY_FAILURE_ACTION = "diag_RunPolicy_failureAction"
	CONST_PROP_ID_DIAG_RUN_POLICY_INT_ID = "diag_RunPolicy_intId"
	CONST_PROP_ID_DIAG_RUN_POLICY_NAME = "diag_RunPolicy_name"
	CONST_PROP_ID_DIAG_RUN_POLICY_POLICY_LEVEL = "diag_RunPolicy_policyLevel"
	CONST_PROP_ID_DIAG_RUN_POLICY_POLICY_OWNER = "diag_RunPolicy_policyOwner"
	CONST_PROP_ID_DIAG_RUN_POLICY_SUCCESS_ACTION = "diag_RunPolicy_successAction"
	CONST_PROP_ID_DIAG_SRV_CAP_PROVIDER_DELETED = "diag_SrvCapProvider_deleted"
	CONST_PROP_ID_DIAG_SRV_CAP_PROVIDER_DEPRECATED = "diag_SrvCapProvider_deprecated"
	CONST_PROP_ID_DIAG_SRV_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "diag_SrvCapProvider_elementLoadFailures"
	CONST_PROP_ID_DIAG_SRV_CAP_PROVIDER_ELEMENTS_LOADED = "diag_SrvCapProvider_elementsLoaded"
	CONST_PROP_ID_DIAG_SRV_CAP_PROVIDER_GENCOUNT = "diag_SrvCapProvider_gencount"
	CONST_PROP_ID_DIAG_SRV_CAP_PROVIDER_LOAD_ERRORS = "diag_SrvCapProvider_loadErrors"
	CONST_PROP_ID_DIAG_SRV_CAP_PROVIDER_LOAD_WARNINGS = "diag_SrvCapProvider_loadWarnings"
	CONST_PROP_ID_DIAG_SRV_CAP_PROVIDER_MGMT_PLANE_VER = "diag_SrvCapProvider_mgmtPlaneVer"
	CONST_PROP_ID_DIAG_SRV_CAP_PROVIDER_MODEL = "diag_SrvCapProvider_model"
	CONST_PROP_ID_DIAG_SRV_CAP_PROVIDER_PROM_CARD_TYPE = "diag_SrvCapProvider_promCardType"
	CONST_PROP_ID_DIAG_SRV_CAP_PROVIDER_REVISION = "diag_SrvCapProvider_revision"
	CONST_PROP_ID_DIAG_SRV_CAP_PROVIDER_VENDOR = "diag_SrvCapProvider_vendor"
	CONST_PROP_ID_DIAG_SRV_CTRL_ADMIN_STATE = "diag_SrvCtrl_adminState"
	CONST_PROP_ID_DIAG_SRV_CTRL_END_TS = "diag_SrvCtrl_endTs"
	CONST_PROP_ID_DIAG_SRV_CTRL_END_TS_M = "diag_SrvCtrl_endTsM"
	CONST_PROP_ID_DIAG_SRV_CTRL_ERROR_DESCR = "diag_SrvCtrl_errorDescr"
	CONST_PROP_ID_DIAG_SRV_CTRL_IMG_LOC = "diag_SrvCtrl_imgLoc"
	CONST_PROP_ID_DIAG_SRV_CTRL_IMG_NAME = "diag_SrvCtrl_imgName"
	CONST_PROP_ID_DIAG_SRV_CTRL_OPER_QUALIFIER = "diag_SrvCtrl_operQualifier"
	CONST_PROP_ID_DIAG_SRV_CTRL_OPER_STATE = "diag_SrvCtrl_operState"
	CONST_PROP_ID_DIAG_SRV_CTRL_RUN_POLICY_NAME = "diag_SrvCtrl_runPolicyName"
	CONST_PROP_ID_DIAG_SRV_CTRL_START_TS = "diag_SrvCtrl_startTs"
	CONST_PROP_ID_DIAG_SRV_CTRL_START_TS_M = "diag_SrvCtrl_startTsM"
	CONST_PROP_ID_DIAG_SRV_CTRL_TYPE = "diag_SrvCtrl_type"
	CONST_PROP_ID_DIAG_TEST_ORDER = "diag_Test_order"
	CONST_PROP_ID_DOMAIN_ENVIRONMENT_FEATURE_FUNCTIONAL_STATE = "domain_EnvironmentFeature_functionalState"
	CONST_PROP_ID_DOMAIN_ENVIRONMENT_FEATURE_NAME = "domain_EnvironmentFeature_name"
	CONST_PROP_ID_DOMAIN_ENVIRONMENT_FEATURE_TYPE = "domain_EnvironmentFeature_type"
	CONST_PROP_ID_DOMAIN_ENVIRONMENT_PARAM_NAME = "domain_EnvironmentParam_name"
	CONST_PROP_ID_DOMAIN_ENVIRONMENT_PARAM_VALUE = "domain_EnvironmentParam_value"
	CONST_PROP_ID_DOMAIN_FEATURE_FUNCTIONAL_STATE = "domain_Feature_functionalState"
	CONST_PROP_ID_DOMAIN_FEATURE_NAME = "domain_Feature_name"
	CONST_PROP_ID_DOMAIN_FEATURE_TYPE = "domain_Feature_type"
	CONST_PROP_ID_DOMAIN_NETWORK_FEATURE_FUNCTIONAL_STATE = "domain_NetworkFeature_functionalState"
	CONST_PROP_ID_DOMAIN_NETWORK_FEATURE_NAME = "domain_NetworkFeature_name"
	CONST_PROP_ID_DOMAIN_NETWORK_FEATURE_TYPE = "domain_NetworkFeature_type"
	CONST_PROP_ID_DOMAIN_NETWORK_PARAM_NAME = "domain_NetworkParam_name"
	CONST_PROP_ID_DOMAIN_NETWORK_PARAM_VALUE = "domain_NetworkParam_value"
	CONST_PROP_ID_DOMAIN_PARAMETER_NAME = "domain_Parameter_name"
	CONST_PROP_ID_DOMAIN_PARAMETER_VALUE = "domain_Parameter_value"
	CONST_PROP_ID_DOMAIN_SERVER_FEATURE_FUNCTIONAL_STATE = "domain_ServerFeature_functionalState"
	CONST_PROP_ID_DOMAIN_SERVER_FEATURE_NAME = "domain_ServerFeature_name"
	CONST_PROP_ID_DOMAIN_SERVER_FEATURE_TYPE = "domain_ServerFeature_type"
	CONST_PROP_ID_DOMAIN_SERVER_PARAM_NAME = "domain_ServerParam_name"
	CONST_PROP_ID_DOMAIN_SERVER_PARAM_VALUE = "domain_ServerParam_value"
	CONST_PROP_ID_DOMAIN_STORAGE_FEATURE_FUNCTIONAL_STATE = "domain_StorageFeature_functionalState"
	CONST_PROP_ID_DOMAIN_STORAGE_FEATURE_NAME = "domain_StorageFeature_name"
	CONST_PROP_ID_DOMAIN_STORAGE_FEATURE_TYPE = "domain_StorageFeature_type"
	CONST_PROP_ID_DOMAIN_STORAGE_PARAM_NAME = "domain_StorageParam_name"
	CONST_PROP_ID_DOMAIN_STORAGE_PARAM_VALUE = "domain_StorageParam_value"
	CONST_PROP_ID_DPSEC_MAC_DESCR = "dpsec_Mac_descr"
	CONST_PROP_ID_DPSEC_MAC_FORGE = "dpsec_Mac_forge"
	CONST_PROP_ID_DPSEC_MAC_INT_ID = "dpsec_Mac_intId"
	CONST_PROP_ID_DPSEC_MAC_NAME = "dpsec_Mac_name"
	CONST_PROP_ID_DPSEC_MAC_POLICY_LEVEL = "dpsec_Mac_policyLevel"
	CONST_PROP_ID_DPSEC_MAC_POLICY_OWNER = "dpsec_Mac_policyOwner"
	CONST_PROP_ID_EPQOS_CONF_COS = "epqos_Conf_cos"
	CONST_PROP_ID_EPQOS_CONF_QOS_POLICY_DN = "epqos_Conf_qosPolicyDn"
	CONST_PROP_ID_EPQOS_CONF_QOS_POLICY_ID = "epqos_Conf_qosPolicyId"
	CONST_PROP_ID_EPQOS_DEFINITION_DEL_TASK_FSM_STAGE_DESCR = "epqos_DefinitionDelTaskFsmStage_descr"
	CONST_PROP_ID_EPQOS_DEFINITION_DEL_TASK_FSM_STAGE_LAST_UPDATE_TIME = "epqos_DefinitionDelTaskFsmStage_lastUpdateTime"
	CONST_PROP_ID_EPQOS_DEFINITION_DEL_TASK_FSM_STAGE_NAME = "epqos_DefinitionDelTaskFsmStage_name"
	CONST_PROP_ID_EPQOS_DEFINITION_DEL_TASK_FSM_STAGE_ORDER = "epqos_DefinitionDelTaskFsmStage_order"
	CONST_PROP_ID_EPQOS_DEFINITION_DEL_TASK_FSM_STAGE_RETRY = "epqos_DefinitionDelTaskFsmStage_retry"
	CONST_PROP_ID_EPQOS_DEFINITION_DEL_TASK_FSM_STAGE_STAGE_STATUS = "epqos_DefinitionDelTaskFsmStage_stageStatus"
	CONST_PROP_ID_EPQOS_DEFINITION_DEL_TASK_FSM_TASK_COMPLETION = "epqos_DefinitionDelTaskFsmTask_completion"
	CONST_PROP_ID_EPQOS_DEFINITION_DEL_TASK_FSM_TASK_FLAGS = "epqos_DefinitionDelTaskFsmTask_flags"
	CONST_PROP_ID_EPQOS_DEFINITION_DEL_TASK_FSM_TASK_ITEM = "epqos_DefinitionDelTaskFsmTask_item"
	CONST_PROP_ID_EPQOS_DEFINITION_DEL_TASK_FSM_TASK_SEQ_ID = "epqos_DefinitionDelTaskFsmTask_seqId"
	CONST_PROP_ID_EPQOS_DEFINITION_DEL_TASK_FSM_COMPLETION_TIME = "epqos_DefinitionDelTaskFsm_completionTime"
	CONST_PROP_ID_EPQOS_DEFINITION_DEL_TASK_FSM_CURRENT_FSM = "epqos_DefinitionDelTaskFsm_currentFsm"
	CONST_PROP_ID_EPQOS_DEFINITION_DEL_TASK_FSM_DESCR = "epqos_DefinitionDelTaskFsm_descr"
	CONST_PROP_ID_EPQOS_DEFINITION_DEL_TASK_FSM_FSM_STATUS = "epqos_DefinitionDelTaskFsm_fsmStatus"
	CONST_PROP_ID_EPQOS_DEFINITION_DEL_TASK_FSM_INSTANCE_ID = "epqos_DefinitionDelTaskFsm_instanceId"
	CONST_PROP_ID_EPQOS_DEFINITION_DEL_TASK_FSM_PROGRESS = "epqos_DefinitionDelTaskFsm_progress"
	CONST_PROP_ID_EPQOS_DEFINITION_DEL_TASK_FSM_RMT_ERR_CODE = "epqos_DefinitionDelTaskFsm_rmtErrCode"
	CONST_PROP_ID_EPQOS_DEFINITION_DEL_TASK_FSM_RMT_ERR_DESCR = "epqos_DefinitionDelTaskFsm_rmtErrDescr"
	CONST_PROP_ID_EPQOS_DEFINITION_DEL_TASK_FSM_RMT_RSLT = "epqos_DefinitionDelTaskFsm_rmtRslt"
	CONST_PROP_ID_EPQOS_DEFINITION_DEL_TASK_DEF_DN = "epqos_DefinitionDelTask_defDn"
	CONST_PROP_ID_EPQOS_DEFINITION_DEL_TASK_DEF_INT_ID = "epqos_DefinitionDelTask_defIntId"
	CONST_PROP_ID_EPQOS_DEFINITION_DEL_TASK_DESCR = "epqos_DefinitionDelTask_descr"
	CONST_PROP_ID_EPQOS_DEFINITION_DEL_TASK_FSM_DESCR = "epqos_DefinitionDelTask_fsmDescr"
	CONST_PROP_ID_EPQOS_DEFINITION_DEL_TASK_FSM_PREV = "epqos_DefinitionDelTask_fsmPrev"
	CONST_PROP_ID_EPQOS_DEFINITION_DEL_TASK_FSM_PROGR = "epqos_DefinitionDelTask_fsmProgr"
	CONST_PROP_ID_EPQOS_DEFINITION_DEL_TASK_FSM_RMT_INV_ERR_CODE = "epqos_DefinitionDelTask_fsmRmtInvErrCode"
	CONST_PROP_ID_EPQOS_DEFINITION_DEL_TASK_FSM_RMT_INV_ERR_DESCR = "epqos_DefinitionDelTask_fsmRmtInvErrDescr"
	CONST_PROP_ID_EPQOS_DEFINITION_DEL_TASK_FSM_RMT_INV_RSLT = "epqos_DefinitionDelTask_fsmRmtInvRslt"
	CONST_PROP_ID_EPQOS_DEFINITION_DEL_TASK_FSM_STAGE_DESCR = "epqos_DefinitionDelTask_fsmStageDescr"
	CONST_PROP_ID_EPQOS_DEFINITION_DEL_TASK_FSM_STAMP = "epqos_DefinitionDelTask_fsmStamp"
	CONST_PROP_ID_EPQOS_DEFINITION_DEL_TASK_FSM_STATUS = "epqos_DefinitionDelTask_fsmStatus"
	CONST_PROP_ID_EPQOS_DEFINITION_DEL_TASK_FSM_TRY = "epqos_DefinitionDelTask_fsmTry"
	CONST_PROP_ID_EPQOS_DEFINITION_DEL_TASK_INT_ID = "epqos_DefinitionDelTask_intId"
	CONST_PROP_ID_EPQOS_DEFINITION_DEL_TASK_NAME = "epqos_DefinitionDelTask_name"
	CONST_PROP_ID_EPQOS_DEFINITION_DEL_TASK_POLICY_LEVEL = "epqos_DefinitionDelTask_policyLevel"
	CONST_PROP_ID_EPQOS_DEFINITION_DEL_TASK_POLICY_OWNER = "epqos_DefinitionDelTask_policyOwner"
	CONST_PROP_ID_EPQOS_DEFINITION_FSM_STAGE_DESCR = "epqos_DefinitionFsmStage_descr"
	CONST_PROP_ID_EPQOS_DEFINITION_FSM_STAGE_LAST_UPDATE_TIME = "epqos_DefinitionFsmStage_lastUpdateTime"
	CONST_PROP_ID_EPQOS_DEFINITION_FSM_STAGE_NAME = "epqos_DefinitionFsmStage_name"
	CONST_PROP_ID_EPQOS_DEFINITION_FSM_STAGE_ORDER = "epqos_DefinitionFsmStage_order"
	CONST_PROP_ID_EPQOS_DEFINITION_FSM_STAGE_RETRY = "epqos_DefinitionFsmStage_retry"
	CONST_PROP_ID_EPQOS_DEFINITION_FSM_STAGE_STAGE_STATUS = "epqos_DefinitionFsmStage_stageStatus"
	CONST_PROP_ID_EPQOS_DEFINITION_FSM_TASK_COMPLETION = "epqos_DefinitionFsmTask_completion"
	CONST_PROP_ID_EPQOS_DEFINITION_FSM_TASK_FLAGS = "epqos_DefinitionFsmTask_flags"
	CONST_PROP_ID_EPQOS_DEFINITION_FSM_TASK_ITEM = "epqos_DefinitionFsmTask_item"
	CONST_PROP_ID_EPQOS_DEFINITION_FSM_TASK_SEQ_ID = "epqos_DefinitionFsmTask_seqId"
	CONST_PROP_ID_EPQOS_DEFINITION_FSM_COMPLETION_TIME = "epqos_DefinitionFsm_completionTime"
	CONST_PROP_ID_EPQOS_DEFINITION_FSM_CURRENT_FSM = "epqos_DefinitionFsm_currentFsm"
	CONST_PROP_ID_EPQOS_DEFINITION_FSM_DESCR = "epqos_DefinitionFsm_descr"
	CONST_PROP_ID_EPQOS_DEFINITION_FSM_FSM_STATUS = "epqos_DefinitionFsm_fsmStatus"
	CONST_PROP_ID_EPQOS_DEFINITION_FSM_INSTANCE_ID = "epqos_DefinitionFsm_instanceId"
	CONST_PROP_ID_EPQOS_DEFINITION_FSM_PROGRESS = "epqos_DefinitionFsm_progress"
	CONST_PROP_ID_EPQOS_DEFINITION_FSM_RMT_ERR_CODE = "epqos_DefinitionFsm_rmtErrCode"
	CONST_PROP_ID_EPQOS_DEFINITION_FSM_RMT_ERR_DESCR = "epqos_DefinitionFsm_rmtErrDescr"
	CONST_PROP_ID_EPQOS_DEFINITION_FSM_RMT_RSLT = "epqos_DefinitionFsm_rmtRslt"
	CONST_PROP_ID_EPQOS_DEFINITION_DESCR = "epqos_Definition_descr"
	CONST_PROP_ID_EPQOS_DEFINITION_FSM_DESCR = "epqos_Definition_fsmDescr"
	CONST_PROP_ID_EPQOS_DEFINITION_FSM_PREV = "epqos_Definition_fsmPrev"
	CONST_PROP_ID_EPQOS_DEFINITION_FSM_PROGR = "epqos_Definition_fsmProgr"
	CONST_PROP_ID_EPQOS_DEFINITION_FSM_RMT_INV_ERR_CODE = "epqos_Definition_fsmRmtInvErrCode"
	CONST_PROP_ID_EPQOS_DEFINITION_FSM_RMT_INV_ERR_DESCR = "epqos_Definition_fsmRmtInvErrDescr"
	CONST_PROP_ID_EPQOS_DEFINITION_FSM_RMT_INV_RSLT = "epqos_Definition_fsmRmtInvRslt"
	CONST_PROP_ID_EPQOS_DEFINITION_FSM_STAGE_DESCR = "epqos_Definition_fsmStageDescr"
	CONST_PROP_ID_EPQOS_DEFINITION_FSM_STAMP = "epqos_Definition_fsmStamp"
	CONST_PROP_ID_EPQOS_DEFINITION_FSM_STATUS = "epqos_Definition_fsmStatus"
	CONST_PROP_ID_EPQOS_DEFINITION_FSM_TRY = "epqos_Definition_fsmTry"
	CONST_PROP_ID_EPQOS_DEFINITION_INT_ID = "epqos_Definition_intId"
	CONST_PROP_ID_EPQOS_DEFINITION_NAME = "epqos_Definition_name"
	CONST_PROP_ID_EPQOS_DEFINITION_POLICY_LEVEL = "epqos_Definition_policyLevel"
	CONST_PROP_ID_EPQOS_DEFINITION_POLICY_OWNER = "epqos_Definition_policyOwner"
	CONST_PROP_ID_EPQOS_EGRESS_BURST = "epqos_Egress_burst"
	CONST_PROP_ID_EPQOS_EGRESS_HOST_CONTROL = "epqos_Egress_hostControl"
	CONST_PROP_ID_EPQOS_EGRESS_NAME = "epqos_Egress_name"
	CONST_PROP_ID_EPQOS_EGRESS_OPER_PRIO = "epqos_Egress_operPrio"
	CONST_PROP_ID_EPQOS_EGRESS_PRIO = "epqos_Egress_prio"
	CONST_PROP_ID_EPQOS_EGRESS_RATE = "epqos_Egress_rate"
	CONST_PROP_ID_EPQOS_ITEM_NAME = "epqos_Item_name"
	CONST_PROP_ID_EQUIPMENT_ADAPTOR_CONN_DEF_ADAPTOR_EP = "equipment_AdaptorConnDef_adaptorEp"
	CONST_PROP_ID_EQUIPMENT_ADAPTOR_CONN_DEF_DESCR = "equipment_AdaptorConnDef_descr"
	CONST_PROP_ID_EQUIPMENT_ADAPTOR_CONN_DEF_INT_ID = "equipment_AdaptorConnDef_intId"
	CONST_PROP_ID_EQUIPMENT_ADAPTOR_CONN_DEF_IOM_EP = "equipment_AdaptorConnDef_iomEp"
	CONST_PROP_ID_EQUIPMENT_ADAPTOR_CONN_DEF_NAME = "equipment_AdaptorConnDef_name"
	CONST_PROP_ID_EQUIPMENT_ADAPTOR_CONN_DEF_POLICY_LEVEL = "equipment_AdaptorConnDef_policyLevel"
	CONST_PROP_ID_EQUIPMENT_ADAPTOR_CONN_DEF_POLICY_OWNER = "equipment_AdaptorConnDef_policyOwner"
	CONST_PROP_ID_EQUIPMENT_ADAPTOR_DEF_DESCR = "equipment_AdaptorDef_descr"
	CONST_PROP_ID_EQUIPMENT_ADAPTOR_DEF_ETHERNET_PORT_SPEED = "equipment_AdaptorDef_ethernetPortSpeed"
	CONST_PROP_ID_EQUIPMENT_ADAPTOR_DEF_FIBRE_CHANNEL_PORT_SPEED = "equipment_AdaptorDef_fibreChannelPortSpeed"
	CONST_PROP_ID_EQUIPMENT_ADAPTOR_DEF_INT_ID = "equipment_AdaptorDef_intId"
	CONST_PROP_ID_EQUIPMENT_ADAPTOR_DEF_NAME = "equipment_AdaptorDef_name"
	CONST_PROP_ID_EQUIPMENT_ADAPTOR_DEF_POLICY_LEVEL = "equipment_AdaptorDef_policyLevel"
	CONST_PROP_ID_EQUIPMENT_ADAPTOR_DEF_POLICY_OWNER = "equipment_AdaptorDef_policyOwner"
	CONST_PROP_ID_EQUIPMENT_ADVANCED_BOOT_ORDER_IS_SUPPORTED = "equipment_AdvancedBootOrder_isSupported"
	CONST_PROP_ID_EQUIPMENT_ADVANCED_BOOT_ORDER_MIN_BIOS_VERSION = "equipment_AdvancedBootOrder_minBiosVersion"
	CONST_PROP_ID_EQUIPMENT_ADVANCED_BOOT_ORDER_MIN_CIMC_VERSION = "equipment_AdvancedBootOrder_minCimcVersion"
	CONST_PROP_ID_EQUIPMENT_ASSOC_CTX_FRU_CAP_DN = "equipment_AssocCtx_fruCapDn"
	CONST_PROP_ID_EQUIPMENT_BASE_BOARD_CAP_PROVIDER_DELETED = "equipment_BaseBoardCapProvider_deleted"
	CONST_PROP_ID_EQUIPMENT_BASE_BOARD_CAP_PROVIDER_DEPRECATED = "equipment_BaseBoardCapProvider_deprecated"
	CONST_PROP_ID_EQUIPMENT_BASE_BOARD_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "equipment_BaseBoardCapProvider_elementLoadFailures"
	CONST_PROP_ID_EQUIPMENT_BASE_BOARD_CAP_PROVIDER_ELEMENTS_LOADED = "equipment_BaseBoardCapProvider_elementsLoaded"
	CONST_PROP_ID_EQUIPMENT_BASE_BOARD_CAP_PROVIDER_GENCOUNT = "equipment_BaseBoardCapProvider_gencount"
	CONST_PROP_ID_EQUIPMENT_BASE_BOARD_CAP_PROVIDER_LOAD_ERRORS = "equipment_BaseBoardCapProvider_loadErrors"
	CONST_PROP_ID_EQUIPMENT_BASE_BOARD_CAP_PROVIDER_LOAD_WARNINGS = "equipment_BaseBoardCapProvider_loadWarnings"
	CONST_PROP_ID_EQUIPMENT_BASE_BOARD_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_BaseBoardCapProvider_mgmtPlaneVer"
	CONST_PROP_ID_EQUIPMENT_BASE_BOARD_CAP_PROVIDER_MODEL = "equipment_BaseBoardCapProvider_model"
	CONST_PROP_ID_EQUIPMENT_BASE_BOARD_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_BaseBoardCapProvider_promCardType"
	CONST_PROP_ID_EQUIPMENT_BASE_BOARD_CAP_PROVIDER_REVISION = "equipment_BaseBoardCapProvider_revision"
	CONST_PROP_ID_EQUIPMENT_BASE_BOARD_CAP_PROVIDER_VENDOR = "equipment_BaseBoardCapProvider_vendor"
	CONST_PROP_ID_EQUIPMENT_BEACON_CAP_PROVIDER_DESCR = "equipment_BeaconCapProvider_descr"
	CONST_PROP_ID_EQUIPMENT_BEACON_CAP_PROVIDER_INT_ID = "equipment_BeaconCapProvider_intId"
	CONST_PROP_ID_EQUIPMENT_BEACON_CAP_PROVIDER_NAME = "equipment_BeaconCapProvider_name"
	CONST_PROP_ID_EQUIPMENT_BEACON_CAP_PROVIDER_POLICY_LEVEL = "equipment_BeaconCapProvider_policyLevel"
	CONST_PROP_ID_EQUIPMENT_BEACON_CAP_PROVIDER_POLICY_OWNER = "equipment_BeaconCapProvider_policyOwner"
	CONST_PROP_ID_EQUIPMENT_BEACON_CAP_PROVIDER_PORT_MODE_BEACON = "equipment_BeaconCapProvider_portModeBeacon"
	CONST_PROP_ID_EQUIPMENT_BEACON_LED_FSM_STAGE_DESCR = "equipment_BeaconLedFsmStage_descr"
	CONST_PROP_ID_EQUIPMENT_BEACON_LED_FSM_STAGE_LAST_UPDATE_TIME = "equipment_BeaconLedFsmStage_lastUpdateTime"
	CONST_PROP_ID_EQUIPMENT_BEACON_LED_FSM_STAGE_NAME = "equipment_BeaconLedFsmStage_name"
	CONST_PROP_ID_EQUIPMENT_BEACON_LED_FSM_STAGE_ORDER = "equipment_BeaconLedFsmStage_order"
	CONST_PROP_ID_EQUIPMENT_BEACON_LED_FSM_STAGE_RETRY = "equipment_BeaconLedFsmStage_retry"
	CONST_PROP_ID_EQUIPMENT_BEACON_LED_FSM_STAGE_STAGE_STATUS = "equipment_BeaconLedFsmStage_stageStatus"
	CONST_PROP_ID_EQUIPMENT_BEACON_LED_FSM_TASK_COMPLETION = "equipment_BeaconLedFsmTask_completion"
	CONST_PROP_ID_EQUIPMENT_BEACON_LED_FSM_TASK_FLAGS = "equipment_BeaconLedFsmTask_flags"
	CONST_PROP_ID_EQUIPMENT_BEACON_LED_FSM_TASK_ITEM = "equipment_BeaconLedFsmTask_item"
	CONST_PROP_ID_EQUIPMENT_BEACON_LED_FSM_TASK_SEQ_ID = "equipment_BeaconLedFsmTask_seqId"
	CONST_PROP_ID_EQUIPMENT_BEACON_LED_FSM_COMPLETION_TIME = "equipment_BeaconLedFsm_completionTime"
	CONST_PROP_ID_EQUIPMENT_BEACON_LED_FSM_CURRENT_FSM = "equipment_BeaconLedFsm_currentFsm"
	CONST_PROP_ID_EQUIPMENT_BEACON_LED_FSM_DESCR = "equipment_BeaconLedFsm_descr"
	CONST_PROP_ID_EQUIPMENT_BEACON_LED_FSM_FSM_STATUS = "equipment_BeaconLedFsm_fsmStatus"
	CONST_PROP_ID_EQUIPMENT_BEACON_LED_FSM_INSTANCE_ID = "equipment_BeaconLedFsm_instanceId"
	CONST_PROP_ID_EQUIPMENT_BEACON_LED_FSM_PROGRESS = "equipment_BeaconLedFsm_progress"
	CONST_PROP_ID_EQUIPMENT_BEACON_LED_FSM_RMT_ERR_CODE = "equipment_BeaconLedFsm_rmtErrCode"
	CONST_PROP_ID_EQUIPMENT_BEACON_LED_FSM_RMT_ERR_DESCR = "equipment_BeaconLedFsm_rmtErrDescr"
	CONST_PROP_ID_EQUIPMENT_BEACON_LED_FSM_RMT_RSLT = "equipment_BeaconLedFsm_rmtRslt"
	CONST_PROP_ID_EQUIPMENT_BEACON_LED_ADMIN_STATE = "equipment_BeaconLed_adminState"
	CONST_PROP_ID_EQUIPMENT_BEACON_LED_COLOR = "equipment_BeaconLed_color"
	CONST_PROP_ID_EQUIPMENT_BEACON_LED_FSM_DESCR = "equipment_BeaconLed_fsmDescr"
	CONST_PROP_ID_EQUIPMENT_BEACON_LED_FSM_PREV = "equipment_BeaconLed_fsmPrev"
	CONST_PROP_ID_EQUIPMENT_BEACON_LED_FSM_PROGR = "equipment_BeaconLed_fsmProgr"
	CONST_PROP_ID_EQUIPMENT_BEACON_LED_FSM_RMT_INV_ERR_CODE = "equipment_BeaconLed_fsmRmtInvErrCode"
	CONST_PROP_ID_EQUIPMENT_BEACON_LED_FSM_RMT_INV_ERR_DESCR = "equipment_BeaconLed_fsmRmtInvErrDescr"
	CONST_PROP_ID_EQUIPMENT_BEACON_LED_FSM_RMT_INV_RSLT = "equipment_BeaconLed_fsmRmtInvRslt"
	CONST_PROP_ID_EQUIPMENT_BEACON_LED_FSM_STAGE_DESCR = "equipment_BeaconLed_fsmStageDescr"
	CONST_PROP_ID_EQUIPMENT_BEACON_LED_FSM_STAMP = "equipment_BeaconLed_fsmStamp"
	CONST_PROP_ID_EQUIPMENT_BEACON_LED_FSM_STATUS = "equipment_BeaconLed_fsmStatus"
	CONST_PROP_ID_EQUIPMENT_BEACON_LED_FSM_TRY = "equipment_BeaconLed_fsmTry"
	CONST_PROP_ID_EQUIPMENT_BEACON_LED_ID = "equipment_BeaconLed_id"
	CONST_PROP_ID_EQUIPMENT_BEACON_LED_NAME = "equipment_BeaconLed_name"
	CONST_PROP_ID_EQUIPMENT_BEACON_LED_OPER_STATE = "equipment_BeaconLed_operState"
	CONST_PROP_ID_EQUIPMENT_BIOS_DEF_DESCR = "equipment_BiosDef_descr"
	CONST_PROP_ID_EQUIPMENT_BIOS_DEF_INT_ID = "equipment_BiosDef_intId"
	CONST_PROP_ID_EQUIPMENT_BIOS_DEF_NAME = "equipment_BiosDef_name"
	CONST_PROP_ID_EQUIPMENT_BIOS_DEF_POLICY_LEVEL = "equipment_BiosDef_policyLevel"
	CONST_PROP_ID_EQUIPMENT_BIOS_DEF_POLICY_OWNER = "equipment_BiosDef_policyOwner"
	CONST_PROP_ID_EQUIPMENT_BIOS_DEF_RESET_ON = "equipment_BiosDef_resetOn"
	CONST_PROP_ID_EQUIPMENT_BIOS_DEF_SECURE_BIOS = "equipment_BiosDef_secureBios"
	CONST_PROP_ID_EQUIPMENT_BIOS_DEF_STORAGE_METHOD = "equipment_BiosDef_storageMethod"
	CONST_PROP_ID_EQUIPMENT_BIOS_DEF_UPDATE_METHOD = "equipment_BiosDef_updateMethod"
	CONST_PROP_ID_EQUIPMENT_BLADE_AGLIBRARY_DESCR = "equipment_BladeAGLibrary_descr"
	CONST_PROP_ID_EQUIPMENT_BLADE_AGLIBRARY_INT_ID = "equipment_BladeAGLibrary_intId"
	CONST_PROP_ID_EQUIPMENT_BLADE_AGLIBRARY_NAME = "equipment_BladeAGLibrary_name"
	CONST_PROP_ID_EQUIPMENT_BLADE_AGLIBRARY_POLICY_LEVEL = "equipment_BladeAGLibrary_policyLevel"
	CONST_PROP_ID_EQUIPMENT_BLADE_AGLIBRARY_POLICY_OWNER = "equipment_BladeAGLibrary_policyOwner"
	CONST_PROP_ID_EQUIPMENT_BLADE_BIOS_CAP_PROVIDER_DELETED = "equipment_BladeBiosCapProvider_deleted"
	CONST_PROP_ID_EQUIPMENT_BLADE_BIOS_CAP_PROVIDER_DEPRECATED = "equipment_BladeBiosCapProvider_deprecated"
	CONST_PROP_ID_EQUIPMENT_BLADE_BIOS_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "equipment_BladeBiosCapProvider_elementLoadFailures"
	CONST_PROP_ID_EQUIPMENT_BLADE_BIOS_CAP_PROVIDER_ELEMENTS_LOADED = "equipment_BladeBiosCapProvider_elementsLoaded"
	CONST_PROP_ID_EQUIPMENT_BLADE_BIOS_CAP_PROVIDER_GENCOUNT = "equipment_BladeBiosCapProvider_gencount"
	CONST_PROP_ID_EQUIPMENT_BLADE_BIOS_CAP_PROVIDER_LOAD_ERRORS = "equipment_BladeBiosCapProvider_loadErrors"
	CONST_PROP_ID_EQUIPMENT_BLADE_BIOS_CAP_PROVIDER_LOAD_WARNINGS = "equipment_BladeBiosCapProvider_loadWarnings"
	CONST_PROP_ID_EQUIPMENT_BLADE_BIOS_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_BladeBiosCapProvider_mgmtPlaneVer"
	CONST_PROP_ID_EQUIPMENT_BLADE_BIOS_CAP_PROVIDER_MODEL = "equipment_BladeBiosCapProvider_model"
	CONST_PROP_ID_EQUIPMENT_BLADE_BIOS_CAP_PROVIDER_PRODUCT_NAME = "equipment_BladeBiosCapProvider_productName"
	CONST_PROP_ID_EQUIPMENT_BLADE_BIOS_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_BladeBiosCapProvider_promCardType"
	CONST_PROP_ID_EQUIPMENT_BLADE_BIOS_CAP_PROVIDER_REVISION = "equipment_BladeBiosCapProvider_revision"
	CONST_PROP_ID_EQUIPMENT_BLADE_BIOS_CAP_PROVIDER_VENDOR = "equipment_BladeBiosCapProvider_vendor"
	CONST_PROP_ID_EQUIPMENT_BLADE_CAP_PROVIDER_DELETED = "equipment_BladeCapProvider_deleted"
	CONST_PROP_ID_EQUIPMENT_BLADE_CAP_PROVIDER_DEPRECATED = "equipment_BladeCapProvider_deprecated"
	CONST_PROP_ID_EQUIPMENT_BLADE_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "equipment_BladeCapProvider_elementLoadFailures"
	CONST_PROP_ID_EQUIPMENT_BLADE_CAP_PROVIDER_ELEMENTS_LOADED = "equipment_BladeCapProvider_elementsLoaded"
	CONST_PROP_ID_EQUIPMENT_BLADE_CAP_PROVIDER_GENCOUNT = "equipment_BladeCapProvider_gencount"
	CONST_PROP_ID_EQUIPMENT_BLADE_CAP_PROVIDER_LOAD_ERRORS = "equipment_BladeCapProvider_loadErrors"
	CONST_PROP_ID_EQUIPMENT_BLADE_CAP_PROVIDER_LOAD_WARNINGS = "equipment_BladeCapProvider_loadWarnings"
	CONST_PROP_ID_EQUIPMENT_BLADE_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_BladeCapProvider_mgmtPlaneVer"
	CONST_PROP_ID_EQUIPMENT_BLADE_CAP_PROVIDER_MODEL = "equipment_BladeCapProvider_model"
	CONST_PROP_ID_EQUIPMENT_BLADE_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_BladeCapProvider_promCardType"
	CONST_PROP_ID_EQUIPMENT_BLADE_CAP_PROVIDER_REVISION = "equipment_BladeCapProvider_revision"
	CONST_PROP_ID_EQUIPMENT_BLADE_CAP_PROVIDER_VENDOR = "equipment_BladeCapProvider_vendor"
	CONST_PROP_ID_EQUIPMENT_BLADE_CONN_DEF_ADAPTOR_FAMILY = "equipment_BladeConnDef_adaptorFamily"
	CONST_PROP_ID_EQUIPMENT_BLADE_CONN_DEF_ADAPTOR_SLOT_NUMBER = "equipment_BladeConnDef_adaptorSlotNumber"
	CONST_PROP_ID_EQUIPMENT_BLADE_CONN_DEF_ADAPTOR_SLOT_SPAN = "equipment_BladeConnDef_adaptorSlotSpan"
	CONST_PROP_ID_EQUIPMENT_BLADE_CONN_DEF_ADAPTOR_TYPE = "equipment_BladeConnDef_adaptorType"
	CONST_PROP_ID_EQUIPMENT_BLADE_CONN_DEF_DESCR = "equipment_BladeConnDef_descr"
	CONST_PROP_ID_EQUIPMENT_BLADE_CONN_DEF_INT_ID = "equipment_BladeConnDef_intId"
	CONST_PROP_ID_EQUIPMENT_BLADE_CONN_DEF_NAME = "equipment_BladeConnDef_name"
	CONST_PROP_ID_EQUIPMENT_BLADE_CONN_DEF_PARENT_ADAPTOR_SLOT_NUM = "equipment_BladeConnDef_parentAdaptorSlotNum"
	CONST_PROP_ID_EQUIPMENT_BLADE_CONN_DEF_POLICY_LEVEL = "equipment_BladeConnDef_policyLevel"
	CONST_PROP_ID_EQUIPMENT_BLADE_CONN_DEF_POLICY_OWNER = "equipment_BladeConnDef_policyOwner"
	CONST_PROP_ID_EQUIPMENT_BLADE_CONN_DEF_SWITCH_PORT_MUX_OFFSET = "equipment_BladeConnDef_switchPortMuxOffset"
	CONST_PROP_ID_EQUIPMENT_BLADE_IOMCONN_DEF_DESCR = "equipment_BladeIOMConnDef_descr"
	CONST_PROP_ID_EQUIPMENT_BLADE_IOMCONN_DEF_INT_ID = "equipment_BladeIOMConnDef_intId"
	CONST_PROP_ID_EQUIPMENT_BLADE_IOMCONN_DEF_IOCARD_TYPE = "equipment_BladeIOMConnDef_iocardType"
	CONST_PROP_ID_EQUIPMENT_BLADE_IOMCONN_DEF_NAME = "equipment_BladeIOMConnDef_name"
	CONST_PROP_ID_EQUIPMENT_BLADE_IOMCONN_DEF_POLICY_LEVEL = "equipment_BladeIOMConnDef_policyLevel"
	CONST_PROP_ID_EQUIPMENT_BLADE_IOMCONN_DEF_POLICY_OWNER = "equipment_BladeIOMConnDef_policyOwner"
	CONST_PROP_ID_EQUIPMENT_BLADE_IOMCONN_DEF_PORT_BANDWIDTH = "equipment_BladeIOMConnDef_portBandwidth"
	CONST_PROP_ID_EQUIPMENT_BOARD_CONTROLLER_DEF_DESCR = "equipment_BoardControllerDef_descr"
	CONST_PROP_ID_EQUIPMENT_BOARD_CONTROLLER_DEF_INT_ID = "equipment_BoardControllerDef_intId"
	CONST_PROP_ID_EQUIPMENT_BOARD_CONTROLLER_DEF_NAME = "equipment_BoardControllerDef_name"
	CONST_PROP_ID_EQUIPMENT_BOARD_CONTROLLER_DEF_POLICY_LEVEL = "equipment_BoardControllerDef_policyLevel"
	CONST_PROP_ID_EQUIPMENT_BOARD_CONTROLLER_DEF_POLICY_OWNER = "equipment_BoardControllerDef_policyOwner"
	CONST_PROP_ID_EQUIPMENT_CARD_ID = "equipment_Card_id"
	CONST_PROP_ID_EQUIPMENT_CARD_MODEL = "equipment_Card_model"
	CONST_PROP_ID_EQUIPMENT_CARD_OPER_QUALIFIER_REASON = "equipment_Card_operQualifierReason"
	CONST_PROP_ID_EQUIPMENT_CARD_OPER_STATE = "equipment_Card_operState"
	CONST_PROP_ID_EQUIPMENT_CARD_OPERABILITY = "equipment_Card_operability"
	CONST_PROP_ID_EQUIPMENT_CARD_PERF = "equipment_Card_perf"
	CONST_PROP_ID_EQUIPMENT_CARD_POWER = "equipment_Card_power"
	CONST_PROP_ID_EQUIPMENT_CARD_PRESENCE = "equipment_Card_presence"
	CONST_PROP_ID_EQUIPMENT_CARD_REVISION = "equipment_Card_revision"
	CONST_PROP_ID_EQUIPMENT_CARD_SERIAL = "equipment_Card_serial"
	CONST_PROP_ID_EQUIPMENT_CARD_THERMAL = "equipment_Card_thermal"
	CONST_PROP_ID_EQUIPMENT_CARD_VENDOR = "equipment_Card_vendor"
	CONST_PROP_ID_EQUIPMENT_CARD_VOLTAGE = "equipment_Card_voltage"
	CONST_PROP_ID_EQUIPMENT_CATALOG_CAP_PROVIDER_DELETED = "equipment_CatalogCapProvider_deleted"
	CONST_PROP_ID_EQUIPMENT_CATALOG_CAP_PROVIDER_DEPRECATED = "equipment_CatalogCapProvider_deprecated"
	CONST_PROP_ID_EQUIPMENT_CATALOG_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "equipment_CatalogCapProvider_elementLoadFailures"
	CONST_PROP_ID_EQUIPMENT_CATALOG_CAP_PROVIDER_ELEMENTS_LOADED = "equipment_CatalogCapProvider_elementsLoaded"
	CONST_PROP_ID_EQUIPMENT_CATALOG_CAP_PROVIDER_GENCOUNT = "equipment_CatalogCapProvider_gencount"
	CONST_PROP_ID_EQUIPMENT_CATALOG_CAP_PROVIDER_LOAD_ERRORS = "equipment_CatalogCapProvider_loadErrors"
	CONST_PROP_ID_EQUIPMENT_CATALOG_CAP_PROVIDER_LOAD_WARNINGS = "equipment_CatalogCapProvider_loadWarnings"
	CONST_PROP_ID_EQUIPMENT_CATALOG_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_CatalogCapProvider_mgmtPlaneVer"
	CONST_PROP_ID_EQUIPMENT_CATALOG_CAP_PROVIDER_MODEL = "equipment_CatalogCapProvider_model"
	CONST_PROP_ID_EQUIPMENT_CATALOG_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_CatalogCapProvider_promCardType"
	CONST_PROP_ID_EQUIPMENT_CATALOG_CAP_PROVIDER_REVISION = "equipment_CatalogCapProvider_revision"
	CONST_PROP_ID_EQUIPMENT_CATALOG_CAP_PROVIDER_VENDOR = "equipment_CatalogCapProvider_vendor"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_CAP_PROVIDER_DELETED = "equipment_ChassisCapProvider_deleted"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_CAP_PROVIDER_DEPRECATED = "equipment_ChassisCapProvider_deprecated"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "equipment_ChassisCapProvider_elementLoadFailures"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_CAP_PROVIDER_ELEMENTS_LOADED = "equipment_ChassisCapProvider_elementsLoaded"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_CAP_PROVIDER_GENCOUNT = "equipment_ChassisCapProvider_gencount"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_CAP_PROVIDER_LOAD_ERRORS = "equipment_ChassisCapProvider_loadErrors"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_CAP_PROVIDER_LOAD_WARNINGS = "equipment_ChassisCapProvider_loadWarnings"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_ChassisCapProvider_mgmtPlaneVer"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_CAP_PROVIDER_MODEL = "equipment_ChassisCapProvider_model"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_ChassisCapProvider_promCardType"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_CAP_PROVIDER_REVISION = "equipment_ChassisCapProvider_revision"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_CAP_PROVIDER_VENDOR = "equipment_ChassisCapProvider_vendor"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_COMPONENT_CHASSIS_ID = "equipment_ChassisComponent_chassisId"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_COMPONENT_SLOT_ID = "equipment_ChassisComponent_slotId"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_FSM_STAGE_DESCR = "equipment_ChassisFsmStage_descr"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_FSM_STAGE_LAST_UPDATE_TIME = "equipment_ChassisFsmStage_lastUpdateTime"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_FSM_STAGE_NAME = "equipment_ChassisFsmStage_name"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_FSM_STAGE_ORDER = "equipment_ChassisFsmStage_order"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_FSM_STAGE_RETRY = "equipment_ChassisFsmStage_retry"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_FSM_STAGE_STAGE_STATUS = "equipment_ChassisFsmStage_stageStatus"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_FSM_TASK_COMPLETION = "equipment_ChassisFsmTask_completion"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_FSM_TASK_FLAGS = "equipment_ChassisFsmTask_flags"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_FSM_TASK_ITEM = "equipment_ChassisFsmTask_item"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_FSM_TASK_SEQ_ID = "equipment_ChassisFsmTask_seqId"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_FSM_COMPLETION_TIME = "equipment_ChassisFsm_completionTime"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_FSM_CURRENT_FSM = "equipment_ChassisFsm_currentFsm"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_FSM_DESCR = "equipment_ChassisFsm_descr"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_FSM_FSM_STATUS = "equipment_ChassisFsm_fsmStatus"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_FSM_INSTANCE_ID = "equipment_ChassisFsm_instanceId"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_FSM_PROGRESS = "equipment_ChassisFsm_progress"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_FSM_RMT_ERR_CODE = "equipment_ChassisFsm_rmtErrCode"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_FSM_RMT_ERR_DESCR = "equipment_ChassisFsm_rmtErrDescr"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_FSM_RMT_RSLT = "equipment_ChassisFsm_rmtRslt"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_STATS_HIST_ID = "equipment_ChassisStatsHist_id"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_STATS_HIST_INPUT_POWER = "equipment_ChassisStatsHist_inputPower"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_STATS_HIST_INPUT_POWER_AVG = "equipment_ChassisStatsHist_inputPowerAvg"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_STATS_HIST_INPUT_POWER_MAX = "equipment_ChassisStatsHist_inputPowerMax"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_STATS_HIST_INPUT_POWER_MIN = "equipment_ChassisStatsHist_inputPowerMin"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_STATS_HIST_MOST_RECENT = "equipment_ChassisStatsHist_mostRecent"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_STATS_HIST_OUTPUT_POWER = "equipment_ChassisStatsHist_outputPower"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_STATS_HIST_OUTPUT_POWER_AVG = "equipment_ChassisStatsHist_outputPowerAvg"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_STATS_HIST_OUTPUT_POWER_MAX = "equipment_ChassisStatsHist_outputPowerMax"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_STATS_HIST_OUTPUT_POWER_MIN = "equipment_ChassisStatsHist_outputPowerMin"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_STATS_HIST_SUSPECT = "equipment_ChassisStatsHist_suspect"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_STATS_HIST_THRESHOLDED = "equipment_ChassisStatsHist_thresholded"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_STATS_HIST_TIME_COLLECTED = "equipment_ChassisStatsHist_timeCollected"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_STATS_INPUT_POWER = "equipment_ChassisStats_inputPower"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_STATS_INPUT_POWER_AVG = "equipment_ChassisStats_inputPowerAvg"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_STATS_INPUT_POWER_MAX = "equipment_ChassisStats_inputPowerMax"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_STATS_INPUT_POWER_MIN = "equipment_ChassisStats_inputPowerMin"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_STATS_INTERVALS = "equipment_ChassisStats_intervals"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_STATS_OUTPUT_POWER = "equipment_ChassisStats_outputPower"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_STATS_OUTPUT_POWER_AVG = "equipment_ChassisStats_outputPowerAvg"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_STATS_OUTPUT_POWER_MAX = "equipment_ChassisStats_outputPowerMax"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_STATS_OUTPUT_POWER_MIN = "equipment_ChassisStats_outputPowerMin"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_STATS_SUSPECT = "equipment_ChassisStats_suspect"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_STATS_THRESHOLDED = "equipment_ChassisStats_thresholded"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_STATS_TIME_COLLECTED = "equipment_ChassisStats_timeCollected"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_STATS_UPDATE = "equipment_ChassisStats_update"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_ACK_PROGRESS_INDICATOR = "equipment_Chassis_ackProgressIndicator"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_ADMIN_STATE = "equipment_Chassis_adminState"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_CONFIG_STATE = "equipment_Chassis_configState"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_CONN_PATH = "equipment_Chassis_connPath"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_CONN_STATUS = "equipment_Chassis_connStatus"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_FABRIC_EP_DN = "equipment_Chassis_fabricEpDn"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_FSM_DESCR = "equipment_Chassis_fsmDescr"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_FSM_PREV = "equipment_Chassis_fsmPrev"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_FSM_PROGR = "equipment_Chassis_fsmProgr"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_FSM_RMT_INV_ERR_CODE = "equipment_Chassis_fsmRmtInvErrCode"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_FSM_RMT_INV_ERR_DESCR = "equipment_Chassis_fsmRmtInvErrDescr"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_FSM_RMT_INV_RSLT = "equipment_Chassis_fsmRmtInvRslt"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_FSM_STAGE_DESCR = "equipment_Chassis_fsmStageDescr"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_FSM_STAMP = "equipment_Chassis_fsmStamp"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_FSM_STATUS = "equipment_Chassis_fsmStatus"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_FSM_TRY = "equipment_Chassis_fsmTry"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_ID = "equipment_Chassis_id"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_LC_TS = "equipment_Chassis_lcTs"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_LIC_GP = "equipment_Chassis_licGP"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_LIC_STATE = "equipment_Chassis_licState"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_MANAGING_INST = "equipment_Chassis_managingInst"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_MFG_TIME = "equipment_Chassis_mfgTime"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_MODEL = "equipment_Chassis_model"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_OPER_QUALIFIER = "equipment_Chassis_operQualifier"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_OPER_QUALIFIER_REASON = "equipment_Chassis_operQualifierReason"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_OPER_STATE = "equipment_Chassis_operState"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_OPERABILITY = "equipment_Chassis_operability"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_PART_NUMBER = "equipment_Chassis_partNumber"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_POWER = "equipment_Chassis_power"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_PRESENCE = "equipment_Chassis_presence"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_REVISION = "equipment_Chassis_revision"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_SEEPROM_OPER_STATE = "equipment_Chassis_seepromOperState"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_SERIAL = "equipment_Chassis_serial"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_THERMAL = "equipment_Chassis_thermal"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_THERMAL_STATE_QUALIFIER = "equipment_Chassis_thermalStateQualifier"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_USR_LBL = "equipment_Chassis_usrLbl"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_VENDOR = "equipment_Chassis_vendor"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_VERSION_HOLDER = "equipment_Chassis_versionHolder"
	CONST_PROP_ID_EQUIPMENT_CHASSIS_VID = "equipment_Chassis_vid"
	CONST_PROP_ID_EQUIPMENT_CONNECTIVITY_CONN_PATH = "equipment_Connectivity_connPath"
	CONST_PROP_ID_EQUIPMENT_CONNECTIVITY_CONN_STATUS = "equipment_Connectivity_connStatus"
	CONST_PROP_ID_EQUIPMENT_CONNECTIVITY_MANAGING_INST = "equipment_Connectivity_managingInst"
	CONST_PROP_ID_EQUIPMENT_DBG_PLUGIN_CAP_PROVIDER_DELETED = "equipment_DbgPluginCapProvider_deleted"
	CONST_PROP_ID_EQUIPMENT_DBG_PLUGIN_CAP_PROVIDER_DEPRECATED = "equipment_DbgPluginCapProvider_deprecated"
	CONST_PROP_ID_EQUIPMENT_DBG_PLUGIN_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "equipment_DbgPluginCapProvider_elementLoadFailures"
	CONST_PROP_ID_EQUIPMENT_DBG_PLUGIN_CAP_PROVIDER_ELEMENTS_LOADED = "equipment_DbgPluginCapProvider_elementsLoaded"
	CONST_PROP_ID_EQUIPMENT_DBG_PLUGIN_CAP_PROVIDER_GENCOUNT = "equipment_DbgPluginCapProvider_gencount"
	CONST_PROP_ID_EQUIPMENT_DBG_PLUGIN_CAP_PROVIDER_LOAD_ERRORS = "equipment_DbgPluginCapProvider_loadErrors"
	CONST_PROP_ID_EQUIPMENT_DBG_PLUGIN_CAP_PROVIDER_LOAD_WARNINGS = "equipment_DbgPluginCapProvider_loadWarnings"
	CONST_PROP_ID_EQUIPMENT_DBG_PLUGIN_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_DbgPluginCapProvider_mgmtPlaneVer"
	CONST_PROP_ID_EQUIPMENT_DBG_PLUGIN_CAP_PROVIDER_MODEL = "equipment_DbgPluginCapProvider_model"
	CONST_PROP_ID_EQUIPMENT_DBG_PLUGIN_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_DbgPluginCapProvider_promCardType"
	CONST_PROP_ID_EQUIPMENT_DBG_PLUGIN_CAP_PROVIDER_REVISION = "equipment_DbgPluginCapProvider_revision"
	CONST_PROP_ID_EQUIPMENT_DBG_PLUGIN_CAP_PROVIDER_VENDOR = "equipment_DbgPluginCapProvider_vendor"
	CONST_PROP_ID_EQUIPMENT_DIMM_ENTRY_ID = "equipment_DimmEntry_id"
	CONST_PROP_ID_EQUIPMENT_DIMM_ENTRY_SMBIOSNAME = "equipment_DimmEntry_smbiosname"
	CONST_PROP_ID_EQUIPMENT_DIMM_MAPPING_DESCR = "equipment_DimmMapping_descr"
	CONST_PROP_ID_EQUIPMENT_DIMM_MAPPING_INT_ID = "equipment_DimmMapping_intId"
	CONST_PROP_ID_EQUIPMENT_DIMM_MAPPING_NAME = "equipment_DimmMapping_name"
	CONST_PROP_ID_EQUIPMENT_DIMM_MAPPING_POLICY_LEVEL = "equipment_DimmMapping_policyLevel"
	CONST_PROP_ID_EQUIPMENT_DIMM_MAPPING_POLICY_OWNER = "equipment_DimmMapping_policyOwner"
	CONST_PROP_ID_EQUIPMENT_DISCOVERY_CAP_OPER_POWER_REQUIREMENT = "equipment_DiscoveryCap_operPowerRequirement"
	CONST_PROP_ID_EQUIPMENT_DOWNGRADE_CONSTRAINT_MIN_VER = "equipment_DowngradeConstraint_minVer"
	CONST_PROP_ID_EQUIPMENT_ENV_SENSOR_NAME = "equipment_EnvSensor_name"
	CONST_PROP_ID_EQUIPMENT_ENV_SENSOR_TYPE = "equipment_EnvSensor_type"
	CONST_PROP_ID_EQUIPMENT_ENV_SENSOR_VALUE = "equipment_EnvSensor_value"
	CONST_PROP_ID_EQUIPMENT_FAN_MODULE_CAP_PROVIDER_DELETED = "equipment_FanModuleCapProvider_deleted"
	CONST_PROP_ID_EQUIPMENT_FAN_MODULE_CAP_PROVIDER_DEPRECATED = "equipment_FanModuleCapProvider_deprecated"
	CONST_PROP_ID_EQUIPMENT_FAN_MODULE_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "equipment_FanModuleCapProvider_elementLoadFailures"
	CONST_PROP_ID_EQUIPMENT_FAN_MODULE_CAP_PROVIDER_ELEMENTS_LOADED = "equipment_FanModuleCapProvider_elementsLoaded"
	CONST_PROP_ID_EQUIPMENT_FAN_MODULE_CAP_PROVIDER_GENCOUNT = "equipment_FanModuleCapProvider_gencount"
	CONST_PROP_ID_EQUIPMENT_FAN_MODULE_CAP_PROVIDER_LOAD_ERRORS = "equipment_FanModuleCapProvider_loadErrors"
	CONST_PROP_ID_EQUIPMENT_FAN_MODULE_CAP_PROVIDER_LOAD_WARNINGS = "equipment_FanModuleCapProvider_loadWarnings"
	CONST_PROP_ID_EQUIPMENT_FAN_MODULE_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_FanModuleCapProvider_mgmtPlaneVer"
	CONST_PROP_ID_EQUIPMENT_FAN_MODULE_CAP_PROVIDER_MODEL = "equipment_FanModuleCapProvider_model"
	CONST_PROP_ID_EQUIPMENT_FAN_MODULE_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_FanModuleCapProvider_promCardType"
	CONST_PROP_ID_EQUIPMENT_FAN_MODULE_CAP_PROVIDER_REVISION = "equipment_FanModuleCapProvider_revision"
	CONST_PROP_ID_EQUIPMENT_FAN_MODULE_CAP_PROVIDER_VENDOR = "equipment_FanModuleCapProvider_vendor"
	CONST_PROP_ID_EQUIPMENT_FAN_MODULE_DEF_DESCR = "equipment_FanModuleDef_descr"
	CONST_PROP_ID_EQUIPMENT_FAN_MODULE_DEF_FAN_CAPACITY = "equipment_FanModuleDef_fanCapacity"
	CONST_PROP_ID_EQUIPMENT_FAN_MODULE_DEF_INT_ID = "equipment_FanModuleDef_intId"
	CONST_PROP_ID_EQUIPMENT_FAN_MODULE_DEF_NAME = "equipment_FanModuleDef_name"
	CONST_PROP_ID_EQUIPMENT_FAN_MODULE_DEF_POLICY_LEVEL = "equipment_FanModuleDef_policyLevel"
	CONST_PROP_ID_EQUIPMENT_FAN_MODULE_DEF_POLICY_OWNER = "equipment_FanModuleDef_policyOwner"
	CONST_PROP_ID_EQUIPMENT_FAN_MODULE_STATS_HIST_AMBIENT_TEMP = "equipment_FanModuleStatsHist_ambientTemp"
	CONST_PROP_ID_EQUIPMENT_FAN_MODULE_STATS_HIST_AMBIENT_TEMP_AVG = "equipment_FanModuleStatsHist_ambientTempAvg"
	CONST_PROP_ID_EQUIPMENT_FAN_MODULE_STATS_HIST_AMBIENT_TEMP_MAX = "equipment_FanModuleStatsHist_ambientTempMax"
	CONST_PROP_ID_EQUIPMENT_FAN_MODULE_STATS_HIST_AMBIENT_TEMP_MIN = "equipment_FanModuleStatsHist_ambientTempMin"
	CONST_PROP_ID_EQUIPMENT_FAN_MODULE_STATS_HIST_ID = "equipment_FanModuleStatsHist_id"
	CONST_PROP_ID_EQUIPMENT_FAN_MODULE_STATS_HIST_MOST_RECENT = "equipment_FanModuleStatsHist_mostRecent"
	CONST_PROP_ID_EQUIPMENT_FAN_MODULE_STATS_HIST_SUSPECT = "equipment_FanModuleStatsHist_suspect"
	CONST_PROP_ID_EQUIPMENT_FAN_MODULE_STATS_HIST_THRESHOLDED = "equipment_FanModuleStatsHist_thresholded"
	CONST_PROP_ID_EQUIPMENT_FAN_MODULE_STATS_HIST_TIME_COLLECTED = "equipment_FanModuleStatsHist_timeCollected"
	CONST_PROP_ID_EQUIPMENT_FAN_MODULE_STATS_AMBIENT_TEMP = "equipment_FanModuleStats_ambientTemp"
	CONST_PROP_ID_EQUIPMENT_FAN_MODULE_STATS_AMBIENT_TEMP_AVG = "equipment_FanModuleStats_ambientTempAvg"
	CONST_PROP_ID_EQUIPMENT_FAN_MODULE_STATS_AMBIENT_TEMP_MAX = "equipment_FanModuleStats_ambientTempMax"
	CONST_PROP_ID_EQUIPMENT_FAN_MODULE_STATS_AMBIENT_TEMP_MIN = "equipment_FanModuleStats_ambientTempMin"
	CONST_PROP_ID_EQUIPMENT_FAN_MODULE_STATS_INTERVALS = "equipment_FanModuleStats_intervals"
	CONST_PROP_ID_EQUIPMENT_FAN_MODULE_STATS_SUSPECT = "equipment_FanModuleStats_suspect"
	CONST_PROP_ID_EQUIPMENT_FAN_MODULE_STATS_THRESHOLDED = "equipment_FanModuleStats_thresholded"
	CONST_PROP_ID_EQUIPMENT_FAN_MODULE_STATS_TIME_COLLECTED = "equipment_FanModuleStats_timeCollected"
	CONST_PROP_ID_EQUIPMENT_FAN_MODULE_STATS_UPDATE = "equipment_FanModuleStats_update"
	CONST_PROP_ID_EQUIPMENT_FAN_MODULE_ID = "equipment_FanModule_id"
	CONST_PROP_ID_EQUIPMENT_FAN_MODULE_MFG_TIME = "equipment_FanModule_mfgTime"
	CONST_PROP_ID_EQUIPMENT_FAN_MODULE_MODEL = "equipment_FanModule_model"
	CONST_PROP_ID_EQUIPMENT_FAN_MODULE_OPER_QUALIFIER_REASON = "equipment_FanModule_operQualifierReason"
	CONST_PROP_ID_EQUIPMENT_FAN_MODULE_OPER_STATE = "equipment_FanModule_operState"
	CONST_PROP_ID_EQUIPMENT_FAN_MODULE_OPERABILITY = "equipment_FanModule_operability"
	CONST_PROP_ID_EQUIPMENT_FAN_MODULE_PART_NUMBER = "equipment_FanModule_partNumber"
	CONST_PROP_ID_EQUIPMENT_FAN_MODULE_PERF = "equipment_FanModule_perf"
	CONST_PROP_ID_EQUIPMENT_FAN_MODULE_POWER = "equipment_FanModule_power"
	CONST_PROP_ID_EQUIPMENT_FAN_MODULE_PRESENCE = "equipment_FanModule_presence"
	CONST_PROP_ID_EQUIPMENT_FAN_MODULE_REVISION = "equipment_FanModule_revision"
	CONST_PROP_ID_EQUIPMENT_FAN_MODULE_SERIAL = "equipment_FanModule_serial"
	CONST_PROP_ID_EQUIPMENT_FAN_MODULE_THERMAL = "equipment_FanModule_thermal"
	CONST_PROP_ID_EQUIPMENT_FAN_MODULE_TRAY = "equipment_FanModule_tray"
	CONST_PROP_ID_EQUIPMENT_FAN_MODULE_VENDOR = "equipment_FanModule_vendor"
	CONST_PROP_ID_EQUIPMENT_FAN_MODULE_VID = "equipment_FanModule_vid"
	CONST_PROP_ID_EQUIPMENT_FAN_MODULE_VOLTAGE = "equipment_FanModule_voltage"
	CONST_PROP_ID_EQUIPMENT_FAN_STATS_HIST_ID = "equipment_FanStatsHist_id"
	CONST_PROP_ID_EQUIPMENT_FAN_STATS_HIST_MOST_RECENT = "equipment_FanStatsHist_mostRecent"
	CONST_PROP_ID_EQUIPMENT_FAN_STATS_HIST_SPEED = "equipment_FanStatsHist_speed"
	CONST_PROP_ID_EQUIPMENT_FAN_STATS_HIST_SPEED_AVG = "equipment_FanStatsHist_speedAvg"
	CONST_PROP_ID_EQUIPMENT_FAN_STATS_HIST_SPEED_MAX = "equipment_FanStatsHist_speedMax"
	CONST_PROP_ID_EQUIPMENT_FAN_STATS_HIST_SPEED_MIN = "equipment_FanStatsHist_speedMin"
	CONST_PROP_ID_EQUIPMENT_FAN_STATS_HIST_SUSPECT = "equipment_FanStatsHist_suspect"
	CONST_PROP_ID_EQUIPMENT_FAN_STATS_HIST_THRESHOLDED = "equipment_FanStatsHist_thresholded"
	CONST_PROP_ID_EQUIPMENT_FAN_STATS_HIST_TIME_COLLECTED = "equipment_FanStatsHist_timeCollected"
	CONST_PROP_ID_EQUIPMENT_FAN_STATS_INTERVALS = "equipment_FanStats_intervals"
	CONST_PROP_ID_EQUIPMENT_FAN_STATS_SPEED = "equipment_FanStats_speed"
	CONST_PROP_ID_EQUIPMENT_FAN_STATS_SPEED_AVG = "equipment_FanStats_speedAvg"
	CONST_PROP_ID_EQUIPMENT_FAN_STATS_SPEED_MAX = "equipment_FanStats_speedMax"
	CONST_PROP_ID_EQUIPMENT_FAN_STATS_SPEED_MIN = "equipment_FanStats_speedMin"
	CONST_PROP_ID_EQUIPMENT_FAN_STATS_SUSPECT = "equipment_FanStats_suspect"
	CONST_PROP_ID_EQUIPMENT_FAN_STATS_THRESHOLDED = "equipment_FanStats_thresholded"
	CONST_PROP_ID_EQUIPMENT_FAN_STATS_TIME_COLLECTED = "equipment_FanStats_timeCollected"
	CONST_PROP_ID_EQUIPMENT_FAN_STATS_UPDATE = "equipment_FanStats_update"
	CONST_PROP_ID_EQUIPMENT_FAN_ID = "equipment_Fan_id"
	CONST_PROP_ID_EQUIPMENT_FAN_INT_TYPE = "equipment_Fan_intType"
	CONST_PROP_ID_EQUIPMENT_FAN_MODEL = "equipment_Fan_model"
	CONST_PROP_ID_EQUIPMENT_FAN_MODULE = "equipment_Fan_module"
	CONST_PROP_ID_EQUIPMENT_FAN_OPER_QUALIFIER_REASON = "equipment_Fan_operQualifierReason"
	CONST_PROP_ID_EQUIPMENT_FAN_OPER_STATE = "equipment_Fan_operState"
	CONST_PROP_ID_EQUIPMENT_FAN_OPERABILITY = "equipment_Fan_operability"
	CONST_PROP_ID_EQUIPMENT_FAN_PERF = "equipment_Fan_perf"
	CONST_PROP_ID_EQUIPMENT_FAN_POWER = "equipment_Fan_power"
	CONST_PROP_ID_EQUIPMENT_FAN_PRESENCE = "equipment_Fan_presence"
	CONST_PROP_ID_EQUIPMENT_FAN_REVISION = "equipment_Fan_revision"
	CONST_PROP_ID_EQUIPMENT_FAN_SERIAL = "equipment_Fan_serial"
	CONST_PROP_ID_EQUIPMENT_FAN_THERMAL = "equipment_Fan_thermal"
	CONST_PROP_ID_EQUIPMENT_FAN_TRAY = "equipment_Fan_tray"
	CONST_PROP_ID_EQUIPMENT_FAN_VENDOR = "equipment_Fan_vendor"
	CONST_PROP_ID_EQUIPMENT_FAN_VOLTAGE = "equipment_Fan_voltage"
	CONST_PROP_ID_EQUIPMENT_FEX_CAP_PROVIDER_DELETED = "equipment_FexCapProvider_deleted"
	CONST_PROP_ID_EQUIPMENT_FEX_CAP_PROVIDER_DEPRECATED = "equipment_FexCapProvider_deprecated"
	CONST_PROP_ID_EQUIPMENT_FEX_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "equipment_FexCapProvider_elementLoadFailures"
	CONST_PROP_ID_EQUIPMENT_FEX_CAP_PROVIDER_ELEMENTS_LOADED = "equipment_FexCapProvider_elementsLoaded"
	CONST_PROP_ID_EQUIPMENT_FEX_CAP_PROVIDER_GENCOUNT = "equipment_FexCapProvider_gencount"
	CONST_PROP_ID_EQUIPMENT_FEX_CAP_PROVIDER_LOAD_ERRORS = "equipment_FexCapProvider_loadErrors"
	CONST_PROP_ID_EQUIPMENT_FEX_CAP_PROVIDER_LOAD_WARNINGS = "equipment_FexCapProvider_loadWarnings"
	CONST_PROP_ID_EQUIPMENT_FEX_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_FexCapProvider_mgmtPlaneVer"
	CONST_PROP_ID_EQUIPMENT_FEX_CAP_PROVIDER_MODEL = "equipment_FexCapProvider_model"
	CONST_PROP_ID_EQUIPMENT_FEX_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_FexCapProvider_promCardType"
	CONST_PROP_ID_EQUIPMENT_FEX_CAP_PROVIDER_REVISION = "equipment_FexCapProvider_revision"
	CONST_PROP_ID_EQUIPMENT_FEX_CAP_PROVIDER_ROLE = "equipment_FexCapProvider_role"
	CONST_PROP_ID_EQUIPMENT_FEX_CAP_PROVIDER_VENDOR = "equipment_FexCapProvider_vendor"
	CONST_PROP_ID_EQUIPMENT_FEX_ENV_STATS_HIST_DIE1 = "equipment_FexEnvStatsHist_die1"
	CONST_PROP_ID_EQUIPMENT_FEX_ENV_STATS_HIST_DIE1_AVG = "equipment_FexEnvStatsHist_die1Avg"
	CONST_PROP_ID_EQUIPMENT_FEX_ENV_STATS_HIST_DIE1_MAX = "equipment_FexEnvStatsHist_die1Max"
	CONST_PROP_ID_EQUIPMENT_FEX_ENV_STATS_HIST_DIE1_MIN = "equipment_FexEnvStatsHist_die1Min"
	CONST_PROP_ID_EQUIPMENT_FEX_ENV_STATS_HIST_ID = "equipment_FexEnvStatsHist_id"
	CONST_PROP_ID_EQUIPMENT_FEX_ENV_STATS_HIST_INLET = "equipment_FexEnvStatsHist_inlet"
	CONST_PROP_ID_EQUIPMENT_FEX_ENV_STATS_HIST_INLET1 = "equipment_FexEnvStatsHist_inlet1"
	CONST_PROP_ID_EQUIPMENT_FEX_ENV_STATS_HIST_INLET1_AVG = "equipment_FexEnvStatsHist_inlet1Avg"
	CONST_PROP_ID_EQUIPMENT_FEX_ENV_STATS_HIST_INLET1_MAX = "equipment_FexEnvStatsHist_inlet1Max"
	CONST_PROP_ID_EQUIPMENT_FEX_ENV_STATS_HIST_INLET1_MIN = "equipment_FexEnvStatsHist_inlet1Min"
	CONST_PROP_ID_EQUIPMENT_FEX_ENV_STATS_HIST_INLET_AVG = "equipment_FexEnvStatsHist_inletAvg"
	CONST_PROP_ID_EQUIPMENT_FEX_ENV_STATS_HIST_INLET_MAX = "equipment_FexEnvStatsHist_inletMax"
	CONST_PROP_ID_EQUIPMENT_FEX_ENV_STATS_HIST_INLET_MIN = "equipment_FexEnvStatsHist_inletMin"
	CONST_PROP_ID_EQUIPMENT_FEX_ENV_STATS_HIST_MOST_RECENT = "equipment_FexEnvStatsHist_mostRecent"
	CONST_PROP_ID_EQUIPMENT_FEX_ENV_STATS_HIST_OUTLET1 = "equipment_FexEnvStatsHist_outlet1"
	CONST_PROP_ID_EQUIPMENT_FEX_ENV_STATS_HIST_OUTLET1_AVG = "equipment_FexEnvStatsHist_outlet1Avg"
	CONST_PROP_ID_EQUIPMENT_FEX_ENV_STATS_HIST_OUTLET1_MAX = "equipment_FexEnvStatsHist_outlet1Max"
	CONST_PROP_ID_EQUIPMENT_FEX_ENV_STATS_HIST_OUTLET1_MIN = "equipment_FexEnvStatsHist_outlet1Min"
	CONST_PROP_ID_EQUIPMENT_FEX_ENV_STATS_HIST_OUTLET2 = "equipment_FexEnvStatsHist_outlet2"
	CONST_PROP_ID_EQUIPMENT_FEX_ENV_STATS_HIST_OUTLET2_AVG = "equipment_FexEnvStatsHist_outlet2Avg"
	CONST_PROP_ID_EQUIPMENT_FEX_ENV_STATS_HIST_OUTLET2_MAX = "equipment_FexEnvStatsHist_outlet2Max"
	CONST_PROP_ID_EQUIPMENT_FEX_ENV_STATS_HIST_OUTLET2_MIN = "equipment_FexEnvStatsHist_outlet2Min"
	CONST_PROP_ID_EQUIPMENT_FEX_ENV_STATS_HIST_SUSPECT = "equipment_FexEnvStatsHist_suspect"
	CONST_PROP_ID_EQUIPMENT_FEX_ENV_STATS_HIST_THRESHOLDED = "equipment_FexEnvStatsHist_thresholded"
	CONST_PROP_ID_EQUIPMENT_FEX_ENV_STATS_HIST_TIME_COLLECTED = "equipment_FexEnvStatsHist_timeCollected"
	CONST_PROP_ID_EQUIPMENT_FEX_ENV_STATS_DIE1 = "equipment_FexEnvStats_die1"
	CONST_PROP_ID_EQUIPMENT_FEX_ENV_STATS_DIE1_AVG = "equipment_FexEnvStats_die1Avg"
	CONST_PROP_ID_EQUIPMENT_FEX_ENV_STATS_DIE1_MAX = "equipment_FexEnvStats_die1Max"
	CONST_PROP_ID_EQUIPMENT_FEX_ENV_STATS_DIE1_MIN = "equipment_FexEnvStats_die1Min"
	CONST_PROP_ID_EQUIPMENT_FEX_ENV_STATS_INLET = "equipment_FexEnvStats_inlet"
	CONST_PROP_ID_EQUIPMENT_FEX_ENV_STATS_INLET1 = "equipment_FexEnvStats_inlet1"
	CONST_PROP_ID_EQUIPMENT_FEX_ENV_STATS_INLET1_AVG = "equipment_FexEnvStats_inlet1Avg"
	CONST_PROP_ID_EQUIPMENT_FEX_ENV_STATS_INLET1_MAX = "equipment_FexEnvStats_inlet1Max"
	CONST_PROP_ID_EQUIPMENT_FEX_ENV_STATS_INLET1_MIN = "equipment_FexEnvStats_inlet1Min"
	CONST_PROP_ID_EQUIPMENT_FEX_ENV_STATS_INLET_AVG = "equipment_FexEnvStats_inletAvg"
	CONST_PROP_ID_EQUIPMENT_FEX_ENV_STATS_INLET_MAX = "equipment_FexEnvStats_inletMax"
	CONST_PROP_ID_EQUIPMENT_FEX_ENV_STATS_INLET_MIN = "equipment_FexEnvStats_inletMin"
	CONST_PROP_ID_EQUIPMENT_FEX_ENV_STATS_INPUT_STATUS = "equipment_FexEnvStats_inputStatus"
	CONST_PROP_ID_EQUIPMENT_FEX_ENV_STATS_INTERVALS = "equipment_FexEnvStats_intervals"
	CONST_PROP_ID_EQUIPMENT_FEX_ENV_STATS_OUTLET1 = "equipment_FexEnvStats_outlet1"
	CONST_PROP_ID_EQUIPMENT_FEX_ENV_STATS_OUTLET1_AVG = "equipment_FexEnvStats_outlet1Avg"
	CONST_PROP_ID_EQUIPMENT_FEX_ENV_STATS_OUTLET1_MAX = "equipment_FexEnvStats_outlet1Max"
	CONST_PROP_ID_EQUIPMENT_FEX_ENV_STATS_OUTLET1_MIN = "equipment_FexEnvStats_outlet1Min"
	CONST_PROP_ID_EQUIPMENT_FEX_ENV_STATS_OUTLET2 = "equipment_FexEnvStats_outlet2"
	CONST_PROP_ID_EQUIPMENT_FEX_ENV_STATS_OUTLET2_AVG = "equipment_FexEnvStats_outlet2Avg"
	CONST_PROP_ID_EQUIPMENT_FEX_ENV_STATS_OUTLET2_MAX = "equipment_FexEnvStats_outlet2Max"
	CONST_PROP_ID_EQUIPMENT_FEX_ENV_STATS_OUTLET2_MIN = "equipment_FexEnvStats_outlet2Min"
	CONST_PROP_ID_EQUIPMENT_FEX_ENV_STATS_SUSPECT = "equipment_FexEnvStats_suspect"
	CONST_PROP_ID_EQUIPMENT_FEX_ENV_STATS_THRESHOLDED = "equipment_FexEnvStats_thresholded"
	CONST_PROP_ID_EQUIPMENT_FEX_ENV_STATS_TIME_COLLECTED = "equipment_FexEnvStats_timeCollected"
	CONST_PROP_ID_EQUIPMENT_FEX_ENV_STATS_UPDATE = "equipment_FexEnvStats_update"
	CONST_PROP_ID_EQUIPMENT_FEX_FSM_STAGE_DESCR = "equipment_FexFsmStage_descr"
	CONST_PROP_ID_EQUIPMENT_FEX_FSM_STAGE_LAST_UPDATE_TIME = "equipment_FexFsmStage_lastUpdateTime"
	CONST_PROP_ID_EQUIPMENT_FEX_FSM_STAGE_NAME = "equipment_FexFsmStage_name"
	CONST_PROP_ID_EQUIPMENT_FEX_FSM_STAGE_ORDER = "equipment_FexFsmStage_order"
	CONST_PROP_ID_EQUIPMENT_FEX_FSM_STAGE_RETRY = "equipment_FexFsmStage_retry"
	CONST_PROP_ID_EQUIPMENT_FEX_FSM_STAGE_STAGE_STATUS = "equipment_FexFsmStage_stageStatus"
	CONST_PROP_ID_EQUIPMENT_FEX_FSM_TASK_COMPLETION = "equipment_FexFsmTask_completion"
	CONST_PROP_ID_EQUIPMENT_FEX_FSM_TASK_FLAGS = "equipment_FexFsmTask_flags"
	CONST_PROP_ID_EQUIPMENT_FEX_FSM_TASK_ITEM = "equipment_FexFsmTask_item"
	CONST_PROP_ID_EQUIPMENT_FEX_FSM_TASK_SEQ_ID = "equipment_FexFsmTask_seqId"
	CONST_PROP_ID_EQUIPMENT_FEX_FSM_COMPLETION_TIME = "equipment_FexFsm_completionTime"
	CONST_PROP_ID_EQUIPMENT_FEX_FSM_CURRENT_FSM = "equipment_FexFsm_currentFsm"
	CONST_PROP_ID_EQUIPMENT_FEX_FSM_DESCR = "equipment_FexFsm_descr"
	CONST_PROP_ID_EQUIPMENT_FEX_FSM_FSM_STATUS = "equipment_FexFsm_fsmStatus"
	CONST_PROP_ID_EQUIPMENT_FEX_FSM_INSTANCE_ID = "equipment_FexFsm_instanceId"
	CONST_PROP_ID_EQUIPMENT_FEX_FSM_PROGRESS = "equipment_FexFsm_progress"
	CONST_PROP_ID_EQUIPMENT_FEX_FSM_RMT_ERR_CODE = "equipment_FexFsm_rmtErrCode"
	CONST_PROP_ID_EQUIPMENT_FEX_FSM_RMT_ERR_DESCR = "equipment_FexFsm_rmtErrDescr"
	CONST_PROP_ID_EQUIPMENT_FEX_FSM_RMT_RSLT = "equipment_FexFsm_rmtRslt"
	CONST_PROP_ID_EQUIPMENT_FEX_POWER_SUMMARY_HIST_MODULE_POWER = "equipment_FexPowerSummaryHist_ModulePower"
	CONST_PROP_ID_EQUIPMENT_FEX_POWER_SUMMARY_HIST_MODULE_POWER_AVG = "equipment_FexPowerSummaryHist_ModulePowerAvg"
	CONST_PROP_ID_EQUIPMENT_FEX_POWER_SUMMARY_HIST_MODULE_POWER_MAX = "equipment_FexPowerSummaryHist_ModulePowerMax"
	CONST_PROP_ID_EQUIPMENT_FEX_POWER_SUMMARY_HIST_MODULE_POWER_MIN = "equipment_FexPowerSummaryHist_ModulePowerMin"
	CONST_PROP_ID_EQUIPMENT_FEX_POWER_SUMMARY_HIST_AVAILABLE_POWER = "equipment_FexPowerSummaryHist_availablePower"
	CONST_PROP_ID_EQUIPMENT_FEX_POWER_SUMMARY_HIST_AVAILABLE_POWER_AVG = "equipment_FexPowerSummaryHist_availablePowerAvg"
	CONST_PROP_ID_EQUIPMENT_FEX_POWER_SUMMARY_HIST_AVAILABLE_POWER_MAX = "equipment_FexPowerSummaryHist_availablePowerMax"
	CONST_PROP_ID_EQUIPMENT_FEX_POWER_SUMMARY_HIST_AVAILABLE_POWER_MIN = "equipment_FexPowerSummaryHist_availablePowerMin"
	CONST_PROP_ID_EQUIPMENT_FEX_POWER_SUMMARY_HIST_ID = "equipment_FexPowerSummaryHist_id"
	CONST_PROP_ID_EQUIPMENT_FEX_POWER_SUMMARY_HIST_MOST_RECENT = "equipment_FexPowerSummaryHist_mostRecent"
	CONST_PROP_ID_EQUIPMENT_FEX_POWER_SUMMARY_HIST_RESERVED_POWER = "equipment_FexPowerSummaryHist_reservedPower"
	CONST_PROP_ID_EQUIPMENT_FEX_POWER_SUMMARY_HIST_RESERVED_POWER_AVG = "equipment_FexPowerSummaryHist_reservedPowerAvg"
	CONST_PROP_ID_EQUIPMENT_FEX_POWER_SUMMARY_HIST_RESERVED_POWER_MAX = "equipment_FexPowerSummaryHist_reservedPowerMax"
	CONST_PROP_ID_EQUIPMENT_FEX_POWER_SUMMARY_HIST_RESERVED_POWER_MIN = "equipment_FexPowerSummaryHist_reservedPowerMin"
	CONST_PROP_ID_EQUIPMENT_FEX_POWER_SUMMARY_HIST_SUSPECT = "equipment_FexPowerSummaryHist_suspect"
	CONST_PROP_ID_EQUIPMENT_FEX_POWER_SUMMARY_HIST_THRESHOLDED = "equipment_FexPowerSummaryHist_thresholded"
	CONST_PROP_ID_EQUIPMENT_FEX_POWER_SUMMARY_HIST_TIME_COLLECTED = "equipment_FexPowerSummaryHist_timeCollected"
	CONST_PROP_ID_EQUIPMENT_FEX_POWER_SUMMARY_HIST_TOTAL_POWER = "equipment_FexPowerSummaryHist_totalPower"
	CONST_PROP_ID_EQUIPMENT_FEX_POWER_SUMMARY_HIST_TOTAL_POWER_AVG = "equipment_FexPowerSummaryHist_totalPowerAvg"
	CONST_PROP_ID_EQUIPMENT_FEX_POWER_SUMMARY_HIST_TOTAL_POWER_MAX = "equipment_FexPowerSummaryHist_totalPowerMax"
	CONST_PROP_ID_EQUIPMENT_FEX_POWER_SUMMARY_HIST_TOTAL_POWER_MIN = "equipment_FexPowerSummaryHist_totalPowerMin"
	CONST_PROP_ID_EQUIPMENT_FEX_POWER_SUMMARY_MODULE_POWER = "equipment_FexPowerSummary_ModulePower"
	CONST_PROP_ID_EQUIPMENT_FEX_POWER_SUMMARY_MODULE_POWER_AVG = "equipment_FexPowerSummary_ModulePowerAvg"
	CONST_PROP_ID_EQUIPMENT_FEX_POWER_SUMMARY_MODULE_POWER_MAX = "equipment_FexPowerSummary_ModulePowerMax"
	CONST_PROP_ID_EQUIPMENT_FEX_POWER_SUMMARY_MODULE_POWER_MIN = "equipment_FexPowerSummary_ModulePowerMin"
	CONST_PROP_ID_EQUIPMENT_FEX_POWER_SUMMARY_AVAILABLE_POWER = "equipment_FexPowerSummary_availablePower"
	CONST_PROP_ID_EQUIPMENT_FEX_POWER_SUMMARY_AVAILABLE_POWER_AVG = "equipment_FexPowerSummary_availablePowerAvg"
	CONST_PROP_ID_EQUIPMENT_FEX_POWER_SUMMARY_AVAILABLE_POWER_MAX = "equipment_FexPowerSummary_availablePowerMax"
	CONST_PROP_ID_EQUIPMENT_FEX_POWER_SUMMARY_AVAILABLE_POWER_MIN = "equipment_FexPowerSummary_availablePowerMin"
	CONST_PROP_ID_EQUIPMENT_FEX_POWER_SUMMARY_INTERVALS = "equipment_FexPowerSummary_intervals"
	CONST_PROP_ID_EQUIPMENT_FEX_POWER_SUMMARY_RESERVED_POWER = "equipment_FexPowerSummary_reservedPower"
	CONST_PROP_ID_EQUIPMENT_FEX_POWER_SUMMARY_RESERVED_POWER_AVG = "equipment_FexPowerSummary_reservedPowerAvg"
	CONST_PROP_ID_EQUIPMENT_FEX_POWER_SUMMARY_RESERVED_POWER_MAX = "equipment_FexPowerSummary_reservedPowerMax"
	CONST_PROP_ID_EQUIPMENT_FEX_POWER_SUMMARY_RESERVED_POWER_MIN = "equipment_FexPowerSummary_reservedPowerMin"
	CONST_PROP_ID_EQUIPMENT_FEX_POWER_SUMMARY_SUSPECT = "equipment_FexPowerSummary_suspect"
	CONST_PROP_ID_EQUIPMENT_FEX_POWER_SUMMARY_THRESHOLDED = "equipment_FexPowerSummary_thresholded"
	CONST_PROP_ID_EQUIPMENT_FEX_POWER_SUMMARY_TIME_COLLECTED = "equipment_FexPowerSummary_timeCollected"
	CONST_PROP_ID_EQUIPMENT_FEX_POWER_SUMMARY_TOTAL_POWER = "equipment_FexPowerSummary_totalPower"
	CONST_PROP_ID_EQUIPMENT_FEX_POWER_SUMMARY_TOTAL_POWER_AVG = "equipment_FexPowerSummary_totalPowerAvg"
	CONST_PROP_ID_EQUIPMENT_FEX_POWER_SUMMARY_TOTAL_POWER_MAX = "equipment_FexPowerSummary_totalPowerMax"
	CONST_PROP_ID_EQUIPMENT_FEX_POWER_SUMMARY_TOTAL_POWER_MIN = "equipment_FexPowerSummary_totalPowerMin"
	CONST_PROP_ID_EQUIPMENT_FEX_POWER_SUMMARY_UPDATE = "equipment_FexPowerSummary_update"
	CONST_PROP_ID_EQUIPMENT_FEX_PSU_INPUT_STATS_HIST_CURRENT = "equipment_FexPsuInputStatsHist_current"
	CONST_PROP_ID_EQUIPMENT_FEX_PSU_INPUT_STATS_HIST_CURRENT_AVG = "equipment_FexPsuInputStatsHist_currentAvg"
	CONST_PROP_ID_EQUIPMENT_FEX_PSU_INPUT_STATS_HIST_CURRENT_MAX = "equipment_FexPsuInputStatsHist_currentMax"
	CONST_PROP_ID_EQUIPMENT_FEX_PSU_INPUT_STATS_HIST_CURRENT_MIN = "equipment_FexPsuInputStatsHist_currentMin"
	CONST_PROP_ID_EQUIPMENT_FEX_PSU_INPUT_STATS_HIST_ID = "equipment_FexPsuInputStatsHist_id"
	CONST_PROP_ID_EQUIPMENT_FEX_PSU_INPUT_STATS_HIST_MOST_RECENT = "equipment_FexPsuInputStatsHist_mostRecent"
	CONST_PROP_ID_EQUIPMENT_FEX_PSU_INPUT_STATS_HIST_POWER = "equipment_FexPsuInputStatsHist_power"
	CONST_PROP_ID_EQUIPMENT_FEX_PSU_INPUT_STATS_HIST_POWER_AVG = "equipment_FexPsuInputStatsHist_powerAvg"
	CONST_PROP_ID_EQUIPMENT_FEX_PSU_INPUT_STATS_HIST_POWER_MAX = "equipment_FexPsuInputStatsHist_powerMax"
	CONST_PROP_ID_EQUIPMENT_FEX_PSU_INPUT_STATS_HIST_POWER_MIN = "equipment_FexPsuInputStatsHist_powerMin"
	CONST_PROP_ID_EQUIPMENT_FEX_PSU_INPUT_STATS_HIST_SUSPECT = "equipment_FexPsuInputStatsHist_suspect"
	CONST_PROP_ID_EQUIPMENT_FEX_PSU_INPUT_STATS_HIST_THRESHOLDED = "equipment_FexPsuInputStatsHist_thresholded"
	CONST_PROP_ID_EQUIPMENT_FEX_PSU_INPUT_STATS_HIST_TIME_COLLECTED = "equipment_FexPsuInputStatsHist_timeCollected"
	CONST_PROP_ID_EQUIPMENT_FEX_PSU_INPUT_STATS_HIST_VOLTAGE = "equipment_FexPsuInputStatsHist_voltage"
	CONST_PROP_ID_EQUIPMENT_FEX_PSU_INPUT_STATS_HIST_VOLTAGE_AVG = "equipment_FexPsuInputStatsHist_voltageAvg"
	CONST_PROP_ID_EQUIPMENT_FEX_PSU_INPUT_STATS_HIST_VOLTAGE_MAX = "equipment_FexPsuInputStatsHist_voltageMax"
	CONST_PROP_ID_EQUIPMENT_FEX_PSU_INPUT_STATS_HIST_VOLTAGE_MIN = "equipment_FexPsuInputStatsHist_voltageMin"
	CONST_PROP_ID_EQUIPMENT_FEX_PSU_INPUT_STATS_CURRENT = "equipment_FexPsuInputStats_current"
	CONST_PROP_ID_EQUIPMENT_FEX_PSU_INPUT_STATS_CURRENT_AVG = "equipment_FexPsuInputStats_currentAvg"
	CONST_PROP_ID_EQUIPMENT_FEX_PSU_INPUT_STATS_CURRENT_MAX = "equipment_FexPsuInputStats_currentMax"
	CONST_PROP_ID_EQUIPMENT_FEX_PSU_INPUT_STATS_CURRENT_MIN = "equipment_FexPsuInputStats_currentMin"
	CONST_PROP_ID_EQUIPMENT_FEX_PSU_INPUT_STATS_INPUT_STATUS = "equipment_FexPsuInputStats_inputStatus"
	CONST_PROP_ID_EQUIPMENT_FEX_PSU_INPUT_STATS_INTERVALS = "equipment_FexPsuInputStats_intervals"
	CONST_PROP_ID_EQUIPMENT_FEX_PSU_INPUT_STATS_POWER = "equipment_FexPsuInputStats_power"
	CONST_PROP_ID_EQUIPMENT_FEX_PSU_INPUT_STATS_POWER_AVG = "equipment_FexPsuInputStats_powerAvg"
	CONST_PROP_ID_EQUIPMENT_FEX_PSU_INPUT_STATS_POWER_MAX = "equipment_FexPsuInputStats_powerMax"
	CONST_PROP_ID_EQUIPMENT_FEX_PSU_INPUT_STATS_POWER_MIN = "equipment_FexPsuInputStats_powerMin"
	CONST_PROP_ID_EQUIPMENT_FEX_PSU_INPUT_STATS_SUSPECT = "equipment_FexPsuInputStats_suspect"
	CONST_PROP_ID_EQUIPMENT_FEX_PSU_INPUT_STATS_THRESHOLDED = "equipment_FexPsuInputStats_thresholded"
	CONST_PROP_ID_EQUIPMENT_FEX_PSU_INPUT_STATS_TIME_COLLECTED = "equipment_FexPsuInputStats_timeCollected"
	CONST_PROP_ID_EQUIPMENT_FEX_PSU_INPUT_STATS_UPDATE = "equipment_FexPsuInputStats_update"
	CONST_PROP_ID_EQUIPMENT_FEX_PSU_INPUT_STATS_VOLTAGE = "equipment_FexPsuInputStats_voltage"
	CONST_PROP_ID_EQUIPMENT_FEX_PSU_INPUT_STATS_VOLTAGE_AVG = "equipment_FexPsuInputStats_voltageAvg"
	CONST_PROP_ID_EQUIPMENT_FEX_PSU_INPUT_STATS_VOLTAGE_MAX = "equipment_FexPsuInputStats_voltageMax"
	CONST_PROP_ID_EQUIPMENT_FEX_PSU_INPUT_STATS_VOLTAGE_MIN = "equipment_FexPsuInputStats_voltageMin"
	CONST_PROP_ID_EQUIPMENT_FEX_ADMIN_POWER_STATE = "equipment_Fex_adminPowerState"
	CONST_PROP_ID_EQUIPMENT_FEX_ADMIN_STATE = "equipment_Fex_adminState"
	CONST_PROP_ID_EQUIPMENT_FEX_CONFIG_STATE = "equipment_Fex_configState"
	CONST_PROP_ID_EQUIPMENT_FEX_FSM_DESCR = "equipment_Fex_fsmDescr"
	CONST_PROP_ID_EQUIPMENT_FEX_FSM_PREV = "equipment_Fex_fsmPrev"
	CONST_PROP_ID_EQUIPMENT_FEX_FSM_PROGR = "equipment_Fex_fsmProgr"
	CONST_PROP_ID_EQUIPMENT_FEX_FSM_RMT_INV_ERR_CODE = "equipment_Fex_fsmRmtInvErrCode"
	CONST_PROP_ID_EQUIPMENT_FEX_FSM_RMT_INV_ERR_DESCR = "equipment_Fex_fsmRmtInvErrDescr"
	CONST_PROP_ID_EQUIPMENT_FEX_FSM_RMT_INV_RSLT = "equipment_Fex_fsmRmtInvRslt"
	CONST_PROP_ID_EQUIPMENT_FEX_FSM_STAGE_DESCR = "equipment_Fex_fsmStageDescr"
	CONST_PROP_ID_EQUIPMENT_FEX_FSM_STAMP = "equipment_Fex_fsmStamp"
	CONST_PROP_ID_EQUIPMENT_FEX_FSM_STATUS = "equipment_Fex_fsmStatus"
	CONST_PROP_ID_EQUIPMENT_FEX_FSM_TRY = "equipment_Fex_fsmTry"
	CONST_PROP_ID_EQUIPMENT_FEX_ID = "equipment_Fex_id"
	CONST_PROP_ID_EQUIPMENT_FEX_LIC_GP = "equipment_Fex_licGP"
	CONST_PROP_ID_EQUIPMENT_FEX_LIC_STATE = "equipment_Fex_licState"
	CONST_PROP_ID_EQUIPMENT_FEX_MODEL = "equipment_Fex_model"
	CONST_PROP_ID_EQUIPMENT_FEX_OPER_QUALIFIER = "equipment_Fex_operQualifier"
	CONST_PROP_ID_EQUIPMENT_FEX_OPER_QUALIFIER_REASON = "equipment_Fex_operQualifierReason"
	CONST_PROP_ID_EQUIPMENT_FEX_OPER_STATE = "equipment_Fex_operState"
	CONST_PROP_ID_EQUIPMENT_FEX_OPERABILITY = "equipment_Fex_operability"
	CONST_PROP_ID_EQUIPMENT_FEX_POWER = "equipment_Fex_power"
	CONST_PROP_ID_EQUIPMENT_FEX_PRESENCE = "equipment_Fex_presence"
	CONST_PROP_ID_EQUIPMENT_FEX_REVISION = "equipment_Fex_revision"
	CONST_PROP_ID_EQUIPMENT_FEX_SERIAL = "equipment_Fex_serial"
	CONST_PROP_ID_EQUIPMENT_FEX_SWITCH_ID = "equipment_Fex_switchId"
	CONST_PROP_ID_EQUIPMENT_FEX_THERMAL = "equipment_Fex_thermal"
	CONST_PROP_ID_EQUIPMENT_FEX_USR_LBL = "equipment_Fex_usrLbl"
	CONST_PROP_ID_EQUIPMENT_FEX_VENDOR = "equipment_Fex_vendor"
	CONST_PROP_ID_EQUIPMENT_FEX_VOLTAGE = "equipment_Fex_voltage"
	CONST_PROP_ID_EQUIPMENT_FIRMWARE_CONSTRAINT_MIN_VER1 = "equipment_FirmwareConstraint_minVer1"
	CONST_PROP_ID_EQUIPMENT_FIRMWARE_CONSTRAINT_MIN_VER2 = "equipment_FirmwareConstraint_minVer2"
	CONST_PROP_ID_EQUIPMENT_FRU_CAP_PROVIDER_DELETED = "equipment_FruCapProvider_deleted"
	CONST_PROP_ID_EQUIPMENT_FRU_CAP_PROVIDER_DEPRECATED = "equipment_FruCapProvider_deprecated"
	CONST_PROP_ID_EQUIPMENT_FRU_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "equipment_FruCapProvider_elementLoadFailures"
	CONST_PROP_ID_EQUIPMENT_FRU_CAP_PROVIDER_ELEMENTS_LOADED = "equipment_FruCapProvider_elementsLoaded"
	CONST_PROP_ID_EQUIPMENT_FRU_CAP_PROVIDER_GENCOUNT = "equipment_FruCapProvider_gencount"
	CONST_PROP_ID_EQUIPMENT_FRU_CAP_PROVIDER_LOAD_ERRORS = "equipment_FruCapProvider_loadErrors"
	CONST_PROP_ID_EQUIPMENT_FRU_CAP_PROVIDER_LOAD_WARNINGS = "equipment_FruCapProvider_loadWarnings"
	CONST_PROP_ID_EQUIPMENT_FRU_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_FruCapProvider_mgmtPlaneVer"
	CONST_PROP_ID_EQUIPMENT_FRU_CAP_PROVIDER_MODEL = "equipment_FruCapProvider_model"
	CONST_PROP_ID_EQUIPMENT_FRU_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_FruCapProvider_promCardType"
	CONST_PROP_ID_EQUIPMENT_FRU_CAP_PROVIDER_REVISION = "equipment_FruCapProvider_revision"
	CONST_PROP_ID_EQUIPMENT_FRU_CAP_PROVIDER_VENDOR = "equipment_FruCapProvider_vendor"
	CONST_PROP_ID_EQUIPMENT_FRUID_INFO_PART_NUMBER = "equipment_FruidInfo_partNumber"
	CONST_PROP_ID_EQUIPMENT_FRUID_INFO_VID = "equipment_FruidInfo_vid"
	CONST_PROP_ID_EQUIPMENT_GEM_CAP_PROVIDER_DELETED = "equipment_GemCapProvider_deleted"
	CONST_PROP_ID_EQUIPMENT_GEM_CAP_PROVIDER_DEPRECATED = "equipment_GemCapProvider_deprecated"
	CONST_PROP_ID_EQUIPMENT_GEM_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "equipment_GemCapProvider_elementLoadFailures"
	CONST_PROP_ID_EQUIPMENT_GEM_CAP_PROVIDER_ELEMENTS_LOADED = "equipment_GemCapProvider_elementsLoaded"
	CONST_PROP_ID_EQUIPMENT_GEM_CAP_PROVIDER_GENCOUNT = "equipment_GemCapProvider_gencount"
	CONST_PROP_ID_EQUIPMENT_GEM_CAP_PROVIDER_LOAD_ERRORS = "equipment_GemCapProvider_loadErrors"
	CONST_PROP_ID_EQUIPMENT_GEM_CAP_PROVIDER_LOAD_WARNINGS = "equipment_GemCapProvider_loadWarnings"
	CONST_PROP_ID_EQUIPMENT_GEM_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_GemCapProvider_mgmtPlaneVer"
	CONST_PROP_ID_EQUIPMENT_GEM_CAP_PROVIDER_MODEL = "equipment_GemCapProvider_model"
	CONST_PROP_ID_EQUIPMENT_GEM_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_GemCapProvider_promCardType"
	CONST_PROP_ID_EQUIPMENT_GEM_CAP_PROVIDER_REVISION = "equipment_GemCapProvider_revision"
	CONST_PROP_ID_EQUIPMENT_GEM_CAP_PROVIDER_VENDOR = "equipment_GemCapProvider_vendor"
	CONST_PROP_ID_EQUIPMENT_GEM_PORT_CAP_DESCR = "equipment_GemPortCap_descr"
	CONST_PROP_ID_EQUIPMENT_GEM_PORT_CAP_INT_ID = "equipment_GemPortCap_intId"
	CONST_PROP_ID_EQUIPMENT_GEM_PORT_CAP_MAX_FC_SPEED = "equipment_GemPortCap_maxFcSpeed"
	CONST_PROP_ID_EQUIPMENT_GEM_PORT_CAP_NAME = "equipment_GemPortCap_name"
	CONST_PROP_ID_EQUIPMENT_GEM_PORT_CAP_POLICY_LEVEL = "equipment_GemPortCap_policyLevel"
	CONST_PROP_ID_EQUIPMENT_GEM_PORT_CAP_POLICY_OWNER = "equipment_GemPortCap_policyOwner"
	CONST_PROP_ID_EQUIPMENT_GEM_PORT_CAP_PORT_NUMBER = "equipment_GemPortCap_portNumber"
	CONST_PROP_ID_EQUIPMENT_GRAPHICS_CARD_CAP_PROVIDER_DELETED = "equipment_GraphicsCardCapProvider_deleted"
	CONST_PROP_ID_EQUIPMENT_GRAPHICS_CARD_CAP_PROVIDER_DEPRECATED = "equipment_GraphicsCardCapProvider_deprecated"
	CONST_PROP_ID_EQUIPMENT_GRAPHICS_CARD_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "equipment_GraphicsCardCapProvider_elementLoadFailures"
	CONST_PROP_ID_EQUIPMENT_GRAPHICS_CARD_CAP_PROVIDER_ELEMENTS_LOADED = "equipment_GraphicsCardCapProvider_elementsLoaded"
	CONST_PROP_ID_EQUIPMENT_GRAPHICS_CARD_CAP_PROVIDER_GENCOUNT = "equipment_GraphicsCardCapProvider_gencount"
	CONST_PROP_ID_EQUIPMENT_GRAPHICS_CARD_CAP_PROVIDER_LOAD_ERRORS = "equipment_GraphicsCardCapProvider_loadErrors"
	CONST_PROP_ID_EQUIPMENT_GRAPHICS_CARD_CAP_PROVIDER_LOAD_WARNINGS = "equipment_GraphicsCardCapProvider_loadWarnings"
	CONST_PROP_ID_EQUIPMENT_GRAPHICS_CARD_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_GraphicsCardCapProvider_mgmtPlaneVer"
	CONST_PROP_ID_EQUIPMENT_GRAPHICS_CARD_CAP_PROVIDER_MODEL = "equipment_GraphicsCardCapProvider_model"
	CONST_PROP_ID_EQUIPMENT_GRAPHICS_CARD_CAP_PROVIDER_NUM_GPU = "equipment_GraphicsCardCapProvider_numGpu"
	CONST_PROP_ID_EQUIPMENT_GRAPHICS_CARD_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_GraphicsCardCapProvider_promCardType"
	CONST_PROP_ID_EQUIPMENT_GRAPHICS_CARD_CAP_PROVIDER_REVISION = "equipment_GraphicsCardCapProvider_revision"
	CONST_PROP_ID_EQUIPMENT_GRAPHICS_CARD_CAP_PROVIDER_VENDOR = "equipment_GraphicsCardCapProvider_vendor"
	CONST_PROP_ID_EQUIPMENT_GRAPHICS_CARD_CAP_REF_MODEL = "equipment_GraphicsCardCapRef_model"
	CONST_PROP_ID_EQUIPMENT_GRAPHICS_CARD_CAP_REF_REVISION = "equipment_GraphicsCardCapRef_revision"
	CONST_PROP_ID_EQUIPMENT_GRAPHICS_CARD_CAP_REF_VENDOR = "equipment_GraphicsCardCapRef_vendor"
	CONST_PROP_ID_EQUIPMENT_HDDFAULT_MON_DEF_CONTROLLER_FW_VERSION = "equipment_HDDFaultMonDef_ControllerFwVersion"
	CONST_PROP_ID_EQUIPMENT_HDDFAULT_MON_DEF_CONTROLLER_MODEL = "equipment_HDDFaultMonDef_ControllerModel"
	CONST_PROP_ID_EQUIPMENT_HDDFAULT_MON_DEF_HDDMON_SUPPORT = "equipment_HDDFaultMonDef_HDDMonSupport"
	CONST_PROP_ID_EQUIPMENT_HDDFAULT_MON_DEF_DESCR = "equipment_HDDFaultMonDef_descr"
	CONST_PROP_ID_EQUIPMENT_HDDFAULT_MON_DEF_INT_ID = "equipment_HDDFaultMonDef_intId"
	CONST_PROP_ID_EQUIPMENT_HDDFAULT_MON_DEF_NAME = "equipment_HDDFaultMonDef_name"
	CONST_PROP_ID_EQUIPMENT_HDDFAULT_MON_DEF_POLICY_LEVEL = "equipment_HDDFaultMonDef_policyLevel"
	CONST_PROP_ID_EQUIPMENT_HDDFAULT_MON_DEF_POLICY_OWNER = "equipment_HDDFaultMonDef_policyOwner"
	CONST_PROP_ID_EQUIPMENT_HEALTH_LED_COLOR = "equipment_HealthLed_color"
	CONST_PROP_ID_EQUIPMENT_HEALTH_LED_HEALTH_LED_STATE = "equipment_HealthLed_healthLedState"
	CONST_PROP_ID_EQUIPMENT_HEALTH_LED_HEALTH_LED_STATE_QUALIFIER = "equipment_HealthLed_healthLedStateQualifier"
	CONST_PROP_ID_EQUIPMENT_HEALTH_LED_ID = "equipment_HealthLed_id"
	CONST_PROP_ID_EQUIPMENT_HEALTH_LED_NAME = "equipment_HealthLed_name"
	CONST_PROP_ID_EQUIPMENT_HEALTH_LED_OPER_STATE = "equipment_HealthLed_operState"
	CONST_PROP_ID_EQUIPMENT_HOLDER_CAP_PROVIDER_DELETED = "equipment_HolderCapProvider_deleted"
	CONST_PROP_ID_EQUIPMENT_HOLDER_CAP_PROVIDER_DEPRECATED = "equipment_HolderCapProvider_deprecated"
	CONST_PROP_ID_EQUIPMENT_HOLDER_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "equipment_HolderCapProvider_elementLoadFailures"
	CONST_PROP_ID_EQUIPMENT_HOLDER_CAP_PROVIDER_ELEMENTS_LOADED = "equipment_HolderCapProvider_elementsLoaded"
	CONST_PROP_ID_EQUIPMENT_HOLDER_CAP_PROVIDER_GENCOUNT = "equipment_HolderCapProvider_gencount"
	CONST_PROP_ID_EQUIPMENT_HOLDER_CAP_PROVIDER_LOAD_ERRORS = "equipment_HolderCapProvider_loadErrors"
	CONST_PROP_ID_EQUIPMENT_HOLDER_CAP_PROVIDER_LOAD_WARNINGS = "equipment_HolderCapProvider_loadWarnings"
	CONST_PROP_ID_EQUIPMENT_HOLDER_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_HolderCapProvider_mgmtPlaneVer"
	CONST_PROP_ID_EQUIPMENT_HOLDER_CAP_PROVIDER_MODEL = "equipment_HolderCapProvider_model"
	CONST_PROP_ID_EQUIPMENT_HOLDER_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_HolderCapProvider_promCardType"
	CONST_PROP_ID_EQUIPMENT_HOLDER_CAP_PROVIDER_REVISION = "equipment_HolderCapProvider_revision"
	CONST_PROP_ID_EQUIPMENT_HOLDER_CAP_PROVIDER_VENDOR = "equipment_HolderCapProvider_vendor"
	CONST_PROP_ID_EQUIPMENT_HOLDER_ID = "equipment_Holder_id"
	CONST_PROP_ID_EQUIPMENT_HOLDER_MODEL = "equipment_Holder_model"
	CONST_PROP_ID_EQUIPMENT_HOLDER_OPER_QUALIFIER_REASON = "equipment_Holder_operQualifierReason"
	CONST_PROP_ID_EQUIPMENT_HOLDER_OPERABILITY = "equipment_Holder_operability"
	CONST_PROP_ID_EQUIPMENT_HOLDER_PRESENCE = "equipment_Holder_presence"
	CONST_PROP_ID_EQUIPMENT_HOLDER_REVISION = "equipment_Holder_revision"
	CONST_PROP_ID_EQUIPMENT_HOLDER_SERIAL = "equipment_Holder_serial"
	CONST_PROP_ID_EQUIPMENT_HOLDER_VENDOR = "equipment_Holder_vendor"
	CONST_PROP_ID_EQUIPMENT_HOST_IF_CAP_PROVIDER_DELETED = "equipment_HostIfCapProvider_deleted"
	CONST_PROP_ID_EQUIPMENT_HOST_IF_CAP_PROVIDER_DEPRECATED = "equipment_HostIfCapProvider_deprecated"
	CONST_PROP_ID_EQUIPMENT_HOST_IF_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "equipment_HostIfCapProvider_elementLoadFailures"
	CONST_PROP_ID_EQUIPMENT_HOST_IF_CAP_PROVIDER_ELEMENTS_LOADED = "equipment_HostIfCapProvider_elementsLoaded"
	CONST_PROP_ID_EQUIPMENT_HOST_IF_CAP_PROVIDER_GENCOUNT = "equipment_HostIfCapProvider_gencount"
	CONST_PROP_ID_EQUIPMENT_HOST_IF_CAP_PROVIDER_LOAD_ERRORS = "equipment_HostIfCapProvider_loadErrors"
	CONST_PROP_ID_EQUIPMENT_HOST_IF_CAP_PROVIDER_LOAD_WARNINGS = "equipment_HostIfCapProvider_loadWarnings"
	CONST_PROP_ID_EQUIPMENT_HOST_IF_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_HostIfCapProvider_mgmtPlaneVer"
	CONST_PROP_ID_EQUIPMENT_HOST_IF_CAP_PROVIDER_MODEL = "equipment_HostIfCapProvider_model"
	CONST_PROP_ID_EQUIPMENT_HOST_IF_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_HostIfCapProvider_promCardType"
	CONST_PROP_ID_EQUIPMENT_HOST_IF_CAP_PROVIDER_REVISION = "equipment_HostIfCapProvider_revision"
	CONST_PROP_ID_EQUIPMENT_HOST_IF_CAP_PROVIDER_VENDOR = "equipment_HostIfCapProvider_vendor"
	CONST_PROP_ID_EQUIPMENT_HW_CAP_PROVIDER_DELETED = "equipment_HwCapProvider_deleted"
	CONST_PROP_ID_EQUIPMENT_HW_CAP_PROVIDER_DEPRECATED = "equipment_HwCapProvider_deprecated"
	CONST_PROP_ID_EQUIPMENT_HW_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "equipment_HwCapProvider_elementLoadFailures"
	CONST_PROP_ID_EQUIPMENT_HW_CAP_PROVIDER_ELEMENTS_LOADED = "equipment_HwCapProvider_elementsLoaded"
	CONST_PROP_ID_EQUIPMENT_HW_CAP_PROVIDER_GENCOUNT = "equipment_HwCapProvider_gencount"
	CONST_PROP_ID_EQUIPMENT_HW_CAP_PROVIDER_LOAD_ERRORS = "equipment_HwCapProvider_loadErrors"
	CONST_PROP_ID_EQUIPMENT_HW_CAP_PROVIDER_LOAD_WARNINGS = "equipment_HwCapProvider_loadWarnings"
	CONST_PROP_ID_EQUIPMENT_HW_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_HwCapProvider_mgmtPlaneVer"
	CONST_PROP_ID_EQUIPMENT_HW_CAP_PROVIDER_MODEL = "equipment_HwCapProvider_model"
	CONST_PROP_ID_EQUIPMENT_HW_CAP_PROVIDER_REVISION = "equipment_HwCapProvider_revision"
	CONST_PROP_ID_EQUIPMENT_HW_CAP_PROVIDER_VENDOR = "equipment_HwCapProvider_vendor"
	CONST_PROP_ID_EQUIPMENT_IOCARD_CAP_PROVIDER_DELETED = "equipment_IOCardCapProvider_deleted"
	CONST_PROP_ID_EQUIPMENT_IOCARD_CAP_PROVIDER_DEPRECATED = "equipment_IOCardCapProvider_deprecated"
	CONST_PROP_ID_EQUIPMENT_IOCARD_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "equipment_IOCardCapProvider_elementLoadFailures"
	CONST_PROP_ID_EQUIPMENT_IOCARD_CAP_PROVIDER_ELEMENTS_LOADED = "equipment_IOCardCapProvider_elementsLoaded"
	CONST_PROP_ID_EQUIPMENT_IOCARD_CAP_PROVIDER_GENCOUNT = "equipment_IOCardCapProvider_gencount"
	CONST_PROP_ID_EQUIPMENT_IOCARD_CAP_PROVIDER_LOAD_ERRORS = "equipment_IOCardCapProvider_loadErrors"
	CONST_PROP_ID_EQUIPMENT_IOCARD_CAP_PROVIDER_LOAD_WARNINGS = "equipment_IOCardCapProvider_loadWarnings"
	CONST_PROP_ID_EQUIPMENT_IOCARD_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_IOCardCapProvider_mgmtPlaneVer"
	CONST_PROP_ID_EQUIPMENT_IOCARD_CAP_PROVIDER_MODEL = "equipment_IOCardCapProvider_model"
	CONST_PROP_ID_EQUIPMENT_IOCARD_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_IOCardCapProvider_promCardType"
	CONST_PROP_ID_EQUIPMENT_IOCARD_CAP_PROVIDER_REVISION = "equipment_IOCardCapProvider_revision"
	CONST_PROP_ID_EQUIPMENT_IOCARD_CAP_PROVIDER_VENDOR = "equipment_IOCardCapProvider_vendor"
	CONST_PROP_ID_EQUIPMENT_IOCARD_FSM_STAGE_DESCR = "equipment_IOCardFsmStage_descr"
	CONST_PROP_ID_EQUIPMENT_IOCARD_FSM_STAGE_LAST_UPDATE_TIME = "equipment_IOCardFsmStage_lastUpdateTime"
	CONST_PROP_ID_EQUIPMENT_IOCARD_FSM_STAGE_NAME = "equipment_IOCardFsmStage_name"
	CONST_PROP_ID_EQUIPMENT_IOCARD_FSM_STAGE_ORDER = "equipment_IOCardFsmStage_order"
	CONST_PROP_ID_EQUIPMENT_IOCARD_FSM_STAGE_RETRY = "equipment_IOCardFsmStage_retry"
	CONST_PROP_ID_EQUIPMENT_IOCARD_FSM_STAGE_STAGE_STATUS = "equipment_IOCardFsmStage_stageStatus"
	CONST_PROP_ID_EQUIPMENT_IOCARD_FSM_TASK_COMPLETION = "equipment_IOCardFsmTask_completion"
	CONST_PROP_ID_EQUIPMENT_IOCARD_FSM_TASK_FLAGS = "equipment_IOCardFsmTask_flags"
	CONST_PROP_ID_EQUIPMENT_IOCARD_FSM_TASK_ITEM = "equipment_IOCardFsmTask_item"
	CONST_PROP_ID_EQUIPMENT_IOCARD_FSM_TASK_SEQ_ID = "equipment_IOCardFsmTask_seqId"
	CONST_PROP_ID_EQUIPMENT_IOCARD_FSM_COMPLETION_TIME = "equipment_IOCardFsm_completionTime"
	CONST_PROP_ID_EQUIPMENT_IOCARD_FSM_CURRENT_FSM = "equipment_IOCardFsm_currentFsm"
	CONST_PROP_ID_EQUIPMENT_IOCARD_FSM_DESCR = "equipment_IOCardFsm_descr"
	CONST_PROP_ID_EQUIPMENT_IOCARD_FSM_FSM_STATUS = "equipment_IOCardFsm_fsmStatus"
	CONST_PROP_ID_EQUIPMENT_IOCARD_FSM_INSTANCE_ID = "equipment_IOCardFsm_instanceId"
	CONST_PROP_ID_EQUIPMENT_IOCARD_FSM_PROGRESS = "equipment_IOCardFsm_progress"
	CONST_PROP_ID_EQUIPMENT_IOCARD_FSM_RMT_ERR_CODE = "equipment_IOCardFsm_rmtErrCode"
	CONST_PROP_ID_EQUIPMENT_IOCARD_FSM_RMT_ERR_DESCR = "equipment_IOCardFsm_rmtErrDescr"
	CONST_PROP_ID_EQUIPMENT_IOCARD_FSM_RMT_RSLT = "equipment_IOCardFsm_rmtRslt"
	CONST_PROP_ID_EQUIPMENT_IOCARD_STATS_HIST_AMBIENT_TEMP = "equipment_IOCardStatsHist_ambientTemp"
	CONST_PROP_ID_EQUIPMENT_IOCARD_STATS_HIST_AMBIENT_TEMP_AVG = "equipment_IOCardStatsHist_ambientTempAvg"
	CONST_PROP_ID_EQUIPMENT_IOCARD_STATS_HIST_AMBIENT_TEMP_MAX = "equipment_IOCardStatsHist_ambientTempMax"
	CONST_PROP_ID_EQUIPMENT_IOCARD_STATS_HIST_AMBIENT_TEMP_MIN = "equipment_IOCardStatsHist_ambientTempMin"
	CONST_PROP_ID_EQUIPMENT_IOCARD_STATS_HIST_ID = "equipment_IOCardStatsHist_id"
	CONST_PROP_ID_EQUIPMENT_IOCARD_STATS_HIST_MOST_RECENT = "equipment_IOCardStatsHist_mostRecent"
	CONST_PROP_ID_EQUIPMENT_IOCARD_STATS_HIST_SUSPECT = "equipment_IOCardStatsHist_suspect"
	CONST_PROP_ID_EQUIPMENT_IOCARD_STATS_HIST_TEMP = "equipment_IOCardStatsHist_temp"
	CONST_PROP_ID_EQUIPMENT_IOCARD_STATS_HIST_TEMP_AVG = "equipment_IOCardStatsHist_tempAvg"
	CONST_PROP_ID_EQUIPMENT_IOCARD_STATS_HIST_TEMP_MAX = "equipment_IOCardStatsHist_tempMax"
	CONST_PROP_ID_EQUIPMENT_IOCARD_STATS_HIST_TEMP_MIN = "equipment_IOCardStatsHist_tempMin"
	CONST_PROP_ID_EQUIPMENT_IOCARD_STATS_HIST_THRESHOLDED = "equipment_IOCardStatsHist_thresholded"
	CONST_PROP_ID_EQUIPMENT_IOCARD_STATS_HIST_TIME_COLLECTED = "equipment_IOCardStatsHist_timeCollected"
	CONST_PROP_ID_EQUIPMENT_IOCARD_STATS_AMBIENT_TEMP = "equipment_IOCardStats_ambientTemp"
	CONST_PROP_ID_EQUIPMENT_IOCARD_STATS_AMBIENT_TEMP_AVG = "equipment_IOCardStats_ambientTempAvg"
	CONST_PROP_ID_EQUIPMENT_IOCARD_STATS_AMBIENT_TEMP_MAX = "equipment_IOCardStats_ambientTempMax"
	CONST_PROP_ID_EQUIPMENT_IOCARD_STATS_AMBIENT_TEMP_MIN = "equipment_IOCardStats_ambientTempMin"
	CONST_PROP_ID_EQUIPMENT_IOCARD_STATS_INTERVALS = "equipment_IOCardStats_intervals"
	CONST_PROP_ID_EQUIPMENT_IOCARD_STATS_SUSPECT = "equipment_IOCardStats_suspect"
	CONST_PROP_ID_EQUIPMENT_IOCARD_STATS_TEMP = "equipment_IOCardStats_temp"
	CONST_PROP_ID_EQUIPMENT_IOCARD_STATS_TEMP_AVG = "equipment_IOCardStats_tempAvg"
	CONST_PROP_ID_EQUIPMENT_IOCARD_STATS_TEMP_MAX = "equipment_IOCardStats_tempMax"
	CONST_PROP_ID_EQUIPMENT_IOCARD_STATS_TEMP_MIN = "equipment_IOCardStats_tempMin"
	CONST_PROP_ID_EQUIPMENT_IOCARD_STATS_THRESHOLDED = "equipment_IOCardStats_thresholded"
	CONST_PROP_ID_EQUIPMENT_IOCARD_STATS_TIME_COLLECTED = "equipment_IOCardStats_timeCollected"
	CONST_PROP_ID_EQUIPMENT_IOCARD_STATS_UPDATE = "equipment_IOCardStats_update"
	CONST_PROP_ID_EQUIPMENT_IOCARD_TYPE_DEF_DESCR = "equipment_IOCardTypeDef_descr"
	CONST_PROP_ID_EQUIPMENT_IOCARD_TYPE_DEF_INT_ID = "equipment_IOCardTypeDef_intId"
	CONST_PROP_ID_EQUIPMENT_IOCARD_TYPE_DEF_NAME = "equipment_IOCardTypeDef_name"
	CONST_PROP_ID_EQUIPMENT_IOCARD_TYPE_DEF_POLICY_LEVEL = "equipment_IOCardTypeDef_policyLevel"
	CONST_PROP_ID_EQUIPMENT_IOCARD_TYPE_DEF_POLICY_OWNER = "equipment_IOCardTypeDef_policyOwner"
	CONST_PROP_ID_EQUIPMENT_IOCARD_TYPE_DEF_TYPE = "equipment_IOCardTypeDef_type"
	CONST_PROP_ID_EQUIPMENT_IOCARD_ADMIN_POWER_STATE = "equipment_IOCard_adminPowerState"
	CONST_PROP_ID_EQUIPMENT_IOCARD_BASE_ADDR = "equipment_IOCard_baseAddr"
	CONST_PROP_ID_EQUIPMENT_IOCARD_CHASSIS_ID = "equipment_IOCard_chassisId"
	CONST_PROP_ID_EQUIPMENT_IOCARD_CONFIG_STATE = "equipment_IOCard_configState"
	CONST_PROP_ID_EQUIPMENT_IOCARD_DISCOVERY = "equipment_IOCard_discovery"
	CONST_PROP_ID_EQUIPMENT_IOCARD_FE_OFFLINE_TS = "equipment_IOCard_feOfflineTs"
	CONST_PROP_ID_EQUIPMENT_IOCARD_FE_READY_TS = "equipment_IOCard_feReadyTs"
	CONST_PROP_ID_EQUIPMENT_IOCARD_FLT_AGGR = "equipment_IOCard_fltAggr"
	CONST_PROP_ID_EQUIPMENT_IOCARD_FSM_DESCR = "equipment_IOCard_fsmDescr"
	CONST_PROP_ID_EQUIPMENT_IOCARD_FSM_PREV = "equipment_IOCard_fsmPrev"
	CONST_PROP_ID_EQUIPMENT_IOCARD_FSM_PROGR = "equipment_IOCard_fsmProgr"
	CONST_PROP_ID_EQUIPMENT_IOCARD_FSM_RMT_INV_ERR_CODE = "equipment_IOCard_fsmRmtInvErrCode"
	CONST_PROP_ID_EQUIPMENT_IOCARD_FSM_RMT_INV_ERR_DESCR = "equipment_IOCard_fsmRmtInvErrDescr"
	CONST_PROP_ID_EQUIPMENT_IOCARD_FSM_RMT_INV_RSLT = "equipment_IOCard_fsmRmtInvRslt"
	CONST_PROP_ID_EQUIPMENT_IOCARD_FSM_STAGE_DESCR = "equipment_IOCard_fsmStageDescr"
	CONST_PROP_ID_EQUIPMENT_IOCARD_FSM_STAMP = "equipment_IOCard_fsmStamp"
	CONST_PROP_ID_EQUIPMENT_IOCARD_FSM_STATUS = "equipment_IOCard_fsmStatus"
	CONST_PROP_ID_EQUIPMENT_IOCARD_FSM_TRY = "equipment_IOCard_fsmTry"
	CONST_PROP_ID_EQUIPMENT_IOCARD_ID = "equipment_IOCard_id"
	CONST_PROP_ID_EQUIPMENT_IOCARD_LC_NAME = "equipment_IOCard_lcName"
	CONST_PROP_ID_EQUIPMENT_IOCARD_LC_TS = "equipment_IOCard_lcTs"
	CONST_PROP_ID_EQUIPMENT_IOCARD_MFG_TIME = "equipment_IOCard_mfgTime"
	CONST_PROP_ID_EQUIPMENT_IOCARD_MODEL = "equipment_IOCard_model"
	CONST_PROP_ID_EQUIPMENT_IOCARD_OPER_QUALIFIER = "equipment_IOCard_operQualifier"
	CONST_PROP_ID_EQUIPMENT_IOCARD_OPER_QUALIFIER_REASON = "equipment_IOCard_operQualifierReason"
	CONST_PROP_ID_EQUIPMENT_IOCARD_OPER_STATE = "equipment_IOCard_operState"
	CONST_PROP_ID_EQUIPMENT_IOCARD_OPERABILITY = "equipment_IOCard_operability"
	CONST_PROP_ID_EQUIPMENT_IOCARD_PART_NUMBER = "equipment_IOCard_partNumber"
	CONST_PROP_ID_EQUIPMENT_IOCARD_PEER_COMM_STATUS = "equipment_IOCard_peerCommStatus"
	CONST_PROP_ID_EQUIPMENT_IOCARD_PEER_DN = "equipment_IOCard_peerDn"
	CONST_PROP_ID_EQUIPMENT_IOCARD_PERF = "equipment_IOCard_perf"
	CONST_PROP_ID_EQUIPMENT_IOCARD_POWER = "equipment_IOCard_power"
	CONST_PROP_ID_EQUIPMENT_IOCARD_PRESENCE = "equipment_IOCard_presence"
	CONST_PROP_ID_EQUIPMENT_IOCARD_REVISION = "equipment_IOCard_revision"
	CONST_PROP_ID_EQUIPMENT_IOCARD_SERIAL = "equipment_IOCard_serial"
	CONST_PROP_ID_EQUIPMENT_IOCARD_SIDE = "equipment_IOCard_side"
	CONST_PROP_ID_EQUIPMENT_IOCARD_SWITCH_ID = "equipment_IOCard_switchId"
	CONST_PROP_ID_EQUIPMENT_IOCARD_THERMAL = "equipment_IOCard_thermal"
	CONST_PROP_ID_EQUIPMENT_IOCARD_UPGRADE_STATUS = "equipment_IOCard_upgradeStatus"
	CONST_PROP_ID_EQUIPMENT_IOCARD_USR_LBL = "equipment_IOCard_usrLbl"
	CONST_PROP_ID_EQUIPMENT_IOCARD_VENDOR = "equipment_IOCard_vendor"
	CONST_PROP_ID_EQUIPMENT_IOCARD_VID = "equipment_IOCard_vid"
	CONST_PROP_ID_EQUIPMENT_IOCARD_VOLTAGE = "equipment_IOCard_voltage"
	CONST_PROP_ID_EQUIPMENT_INBAND_MGMT_CAP_IS_SUPPORTED = "equipment_InbandMgmtCap_isSupported"
	CONST_PROP_ID_EQUIPMENT_INBAND_MGMT_CAP_MIN_CIMC_VERSION = "equipment_InbandMgmtCap_minCimcVersion"
	CONST_PROP_ID_EQUIPMENT_INBAND_MGMT_CAP_MIN_CMC_VERSION = "equipment_InbandMgmtCap_minCmcVersion"
	CONST_PROP_ID_EQUIPMENT_INDICATOR_LED_COLOR = "equipment_IndicatorLed_color"
	CONST_PROP_ID_EQUIPMENT_INDICATOR_LED_ID = "equipment_IndicatorLed_id"
	CONST_PROP_ID_EQUIPMENT_INDICATOR_LED_NAME = "equipment_IndicatorLed_name"
	CONST_PROP_ID_EQUIPMENT_INDICATOR_LED_OPER_STATE = "equipment_IndicatorLed_operState"
	CONST_PROP_ID_EQUIPMENT_INFO_MODEL = "equipment_Info_model"
	CONST_PROP_ID_EQUIPMENT_INFO_REVISION = "equipment_Info_revision"
	CONST_PROP_ID_EQUIPMENT_INFO_SERIAL = "equipment_Info_serial"
	CONST_PROP_ID_EQUIPMENT_INFO_VENDOR = "equipment_Info_vendor"
	CONST_PROP_ID_EQUIPMENT_INTEGRATED_COMPONENT_CAP_PROVIDER_DELETED = "equipment_IntegratedComponentCapProvider_deleted"
	CONST_PROP_ID_EQUIPMENT_INTEGRATED_COMPONENT_CAP_PROVIDER_DEPRECATED = "equipment_IntegratedComponentCapProvider_deprecated"
	CONST_PROP_ID_EQUIPMENT_INTEGRATED_COMPONENT_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "equipment_IntegratedComponentCapProvider_elementLoadFailures"
	CONST_PROP_ID_EQUIPMENT_INTEGRATED_COMPONENT_CAP_PROVIDER_ELEMENTS_LOADED = "equipment_IntegratedComponentCapProvider_elementsLoaded"
	CONST_PROP_ID_EQUIPMENT_INTEGRATED_COMPONENT_CAP_PROVIDER_GENCOUNT = "equipment_IntegratedComponentCapProvider_gencount"
	CONST_PROP_ID_EQUIPMENT_INTEGRATED_COMPONENT_CAP_PROVIDER_LOAD_ERRORS = "equipment_IntegratedComponentCapProvider_loadErrors"
	CONST_PROP_ID_EQUIPMENT_INTEGRATED_COMPONENT_CAP_PROVIDER_LOAD_WARNINGS = "equipment_IntegratedComponentCapProvider_loadWarnings"
	CONST_PROP_ID_EQUIPMENT_INTEGRATED_COMPONENT_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_IntegratedComponentCapProvider_mgmtPlaneVer"
	CONST_PROP_ID_EQUIPMENT_INTEGRATED_COMPONENT_CAP_PROVIDER_MODEL = "equipment_IntegratedComponentCapProvider_model"
	CONST_PROP_ID_EQUIPMENT_INTEGRATED_COMPONENT_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_IntegratedComponentCapProvider_promCardType"
	CONST_PROP_ID_EQUIPMENT_INTEGRATED_COMPONENT_CAP_PROVIDER_REVISION = "equipment_IntegratedComponentCapProvider_revision"
	CONST_PROP_ID_EQUIPMENT_INTEGRATED_COMPONENT_CAP_PROVIDER_VENDOR = "equipment_IntegratedComponentCapProvider_vendor"
	CONST_PROP_ID_EQUIPMENT_ITEM_IF_ID = "equipment_ItemIf_id"
	CONST_PROP_ID_EQUIPMENT_ITEM_ID = "equipment_Item_id"
	CONST_PROP_ID_EQUIPMENT_ITEM_MODEL = "equipment_Item_model"
	CONST_PROP_ID_EQUIPMENT_ITEM_REVISION = "equipment_Item_revision"
	CONST_PROP_ID_EQUIPMENT_ITEM_SERIAL = "equipment_Item_serial"
	CONST_PROP_ID_EQUIPMENT_ITEM_VENDOR = "equipment_Item_vendor"
	CONST_PROP_ID_EQUIPMENT_LED_COLOR = "equipment_Led_color"
	CONST_PROP_ID_EQUIPMENT_LED_ID = "equipment_Led_id"
	CONST_PROP_ID_EQUIPMENT_LED_NAME = "equipment_Led_name"
	CONST_PROP_ID_EQUIPMENT_LED_OPER_STATE = "equipment_Led_operState"
	CONST_PROP_ID_EQUIPMENT_LOCAL_DISK_CAP_PROVIDER_DELETED = "equipment_LocalDiskCapProvider_deleted"
	CONST_PROP_ID_EQUIPMENT_LOCAL_DISK_CAP_PROVIDER_DEPRECATED = "equipment_LocalDiskCapProvider_deprecated"
	CONST_PROP_ID_EQUIPMENT_LOCAL_DISK_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "equipment_LocalDiskCapProvider_elementLoadFailures"
	CONST_PROP_ID_EQUIPMENT_LOCAL_DISK_CAP_PROVIDER_ELEMENTS_LOADED = "equipment_LocalDiskCapProvider_elementsLoaded"
	CONST_PROP_ID_EQUIPMENT_LOCAL_DISK_CAP_PROVIDER_GENCOUNT = "equipment_LocalDiskCapProvider_gencount"
	CONST_PROP_ID_EQUIPMENT_LOCAL_DISK_CAP_PROVIDER_LOAD_ERRORS = "equipment_LocalDiskCapProvider_loadErrors"
	CONST_PROP_ID_EQUIPMENT_LOCAL_DISK_CAP_PROVIDER_LOAD_WARNINGS = "equipment_LocalDiskCapProvider_loadWarnings"
	CONST_PROP_ID_EQUIPMENT_LOCAL_DISK_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_LocalDiskCapProvider_mgmtPlaneVer"
	CONST_PROP_ID_EQUIPMENT_LOCAL_DISK_CAP_PROVIDER_MODEL = "equipment_LocalDiskCapProvider_model"
	CONST_PROP_ID_EQUIPMENT_LOCAL_DISK_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_LocalDiskCapProvider_promCardType"
	CONST_PROP_ID_EQUIPMENT_LOCAL_DISK_CAP_PROVIDER_REVISION = "equipment_LocalDiskCapProvider_revision"
	CONST_PROP_ID_EQUIPMENT_LOCAL_DISK_CAP_PROVIDER_VENDOR = "equipment_LocalDiskCapProvider_vendor"
	CONST_PROP_ID_EQUIPMENT_LOCAL_DISK_CONTROLLER_CAP_PROVIDER_CARD_TYPE = "equipment_LocalDiskControllerCapProvider_cardType"
	CONST_PROP_ID_EQUIPMENT_LOCAL_DISK_CONTROLLER_CAP_PROVIDER_DELETED = "equipment_LocalDiskControllerCapProvider_deleted"
	CONST_PROP_ID_EQUIPMENT_LOCAL_DISK_CONTROLLER_CAP_PROVIDER_DEPRECATED = "equipment_LocalDiskControllerCapProvider_deprecated"
	CONST_PROP_ID_EQUIPMENT_LOCAL_DISK_CONTROLLER_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "equipment_LocalDiskControllerCapProvider_elementLoadFailures"
	CONST_PROP_ID_EQUIPMENT_LOCAL_DISK_CONTROLLER_CAP_PROVIDER_ELEMENTS_LOADED = "equipment_LocalDiskControllerCapProvider_elementsLoaded"
	CONST_PROP_ID_EQUIPMENT_LOCAL_DISK_CONTROLLER_CAP_PROVIDER_FORM = "equipment_LocalDiskControllerCapProvider_form"
	CONST_PROP_ID_EQUIPMENT_LOCAL_DISK_CONTROLLER_CAP_PROVIDER_GENCOUNT = "equipment_LocalDiskControllerCapProvider_gencount"
	CONST_PROP_ID_EQUIPMENT_LOCAL_DISK_CONTROLLER_CAP_PROVIDER_INTERNALPORTS = "equipment_LocalDiskControllerCapProvider_internalports"
	CONST_PROP_ID_EQUIPMENT_LOCAL_DISK_CONTROLLER_CAP_PROVIDER_LOAD_ERRORS = "equipment_LocalDiskControllerCapProvider_loadErrors"
	CONST_PROP_ID_EQUIPMENT_LOCAL_DISK_CONTROLLER_CAP_PROVIDER_LOAD_WARNINGS = "equipment_LocalDiskControllerCapProvider_loadWarnings"
	CONST_PROP_ID_EQUIPMENT_LOCAL_DISK_CONTROLLER_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_LocalDiskControllerCapProvider_mgmtPlaneVer"
	CONST_PROP_ID_EQUIPMENT_LOCAL_DISK_CONTROLLER_CAP_PROVIDER_MODEL = "equipment_LocalDiskControllerCapProvider_model"
	CONST_PROP_ID_EQUIPMENT_LOCAL_DISK_CONTROLLER_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_LocalDiskControllerCapProvider_promCardType"
	CONST_PROP_ID_EQUIPMENT_LOCAL_DISK_CONTROLLER_CAP_PROVIDER_REVISION = "equipment_LocalDiskControllerCapProvider_revision"
	CONST_PROP_ID_EQUIPMENT_LOCAL_DISK_CONTROLLER_CAP_PROVIDER_VENDOR = "equipment_LocalDiskControllerCapProvider_vendor"
	CONST_PROP_ID_EQUIPMENT_LOCAL_DISK_CONTROLLER_CAP_REF_IS_SUPPORTED = "equipment_LocalDiskControllerCapRef_isSupported"
	CONST_PROP_ID_EQUIPMENT_LOCAL_DISK_CONTROLLER_CAP_REF_MODEL = "equipment_LocalDiskControllerCapRef_model"
	CONST_PROP_ID_EQUIPMENT_LOCAL_DISK_CONTROLLER_CAP_REF_REVISION = "equipment_LocalDiskControllerCapRef_revision"
	CONST_PROP_ID_EQUIPMENT_LOCAL_DISK_CONTROLLER_CAP_REF_VENDOR = "equipment_LocalDiskControllerCapRef_vendor"
	CONST_PROP_ID_EQUIPMENT_LOCAL_DISK_CONTROLLER_DEF_DESCR = "equipment_LocalDiskControllerDef_descr"
	CONST_PROP_ID_EQUIPMENT_LOCAL_DISK_CONTROLLER_DEF_FORCE_UPDATE_VERSION = "equipment_LocalDiskControllerDef_forceUpdateVersion"
	CONST_PROP_ID_EQUIPMENT_LOCAL_DISK_CONTROLLER_DEF_INT_ID = "equipment_LocalDiskControllerDef_intId"
	CONST_PROP_ID_EQUIPMENT_LOCAL_DISK_CONTROLLER_DEF_NAME = "equipment_LocalDiskControllerDef_name"
	CONST_PROP_ID_EQUIPMENT_LOCAL_DISK_CONTROLLER_DEF_POLICY_LEVEL = "equipment_LocalDiskControllerDef_policyLevel"
	CONST_PROP_ID_EQUIPMENT_LOCAL_DISK_CONTROLLER_DEF_POLICY_OWNER = "equipment_LocalDiskControllerDef_policyOwner"
	CONST_PROP_ID_EQUIPMENT_LOCAL_DISK_DEF_BLOCK_SIZE = "equipment_LocalDiskDef_blockSize"
	CONST_PROP_ID_EQUIPMENT_LOCAL_DISK_DEF_CACHE_SIZE = "equipment_LocalDiskDef_cacheSize"
	CONST_PROP_ID_EQUIPMENT_LOCAL_DISK_DEF_DESCR = "equipment_LocalDiskDef_descr"
	CONST_PROP_ID_EQUIPMENT_LOCAL_DISK_DEF_FORCE_UPDATE_VERSION = "equipment_LocalDiskDef_forceUpdateVersion"
	CONST_PROP_ID_EQUIPMENT_LOCAL_DISK_DEF_INT_ID = "equipment_LocalDiskDef_intId"
	CONST_PROP_ID_EQUIPMENT_LOCAL_DISK_DEF_NAME = "equipment_LocalDiskDef_name"
	CONST_PROP_ID_EQUIPMENT_LOCAL_DISK_DEF_NUMBER_OF_BLOCKS = "equipment_LocalDiskDef_numberOfBlocks"
	CONST_PROP_ID_EQUIPMENT_LOCAL_DISK_DEF_POLICY_LEVEL = "equipment_LocalDiskDef_policyLevel"
	CONST_PROP_ID_EQUIPMENT_LOCAL_DISK_DEF_POLICY_OWNER = "equipment_LocalDiskDef_policyOwner"
	CONST_PROP_ID_EQUIPMENT_LOCAL_DISK_DEF_ROTATIONAL_SPEED = "equipment_LocalDiskDef_rotationalSpeed"
	CONST_PROP_ID_EQUIPMENT_LOCAL_DISK_DEF_SEEK_AVERAGE_READ_WRITE = "equipment_LocalDiskDef_seekAverageReadWrite"
	CONST_PROP_ID_EQUIPMENT_LOCAL_DISK_DEF_SEEK_TRACK_TO_TRACK_READ_WRITE = "equipment_LocalDiskDef_seekTrackToTrackReadWrite"
	CONST_PROP_ID_EQUIPMENT_LOCAL_DISK_DEF_TECHNOLOGY = "equipment_LocalDiskDef_technology"
	CONST_PROP_ID_EQUIPMENT_LOCATOR_LED_FSM_STAGE_DESCR = "equipment_LocatorLedFsmStage_descr"
	CONST_PROP_ID_EQUIPMENT_LOCATOR_LED_FSM_STAGE_LAST_UPDATE_TIME = "equipment_LocatorLedFsmStage_lastUpdateTime"
	CONST_PROP_ID_EQUIPMENT_LOCATOR_LED_FSM_STAGE_NAME = "equipment_LocatorLedFsmStage_name"
	CONST_PROP_ID_EQUIPMENT_LOCATOR_LED_FSM_STAGE_ORDER = "equipment_LocatorLedFsmStage_order"
	CONST_PROP_ID_EQUIPMENT_LOCATOR_LED_FSM_STAGE_RETRY = "equipment_LocatorLedFsmStage_retry"
	CONST_PROP_ID_EQUIPMENT_LOCATOR_LED_FSM_STAGE_STAGE_STATUS = "equipment_LocatorLedFsmStage_stageStatus"
	CONST_PROP_ID_EQUIPMENT_LOCATOR_LED_FSM_TASK_COMPLETION = "equipment_LocatorLedFsmTask_completion"
	CONST_PROP_ID_EQUIPMENT_LOCATOR_LED_FSM_TASK_FLAGS = "equipment_LocatorLedFsmTask_flags"
	CONST_PROP_ID_EQUIPMENT_LOCATOR_LED_FSM_TASK_ITEM = "equipment_LocatorLedFsmTask_item"
	CONST_PROP_ID_EQUIPMENT_LOCATOR_LED_FSM_TASK_SEQ_ID = "equipment_LocatorLedFsmTask_seqId"
	CONST_PROP_ID_EQUIPMENT_LOCATOR_LED_FSM_COMPLETION_TIME = "equipment_LocatorLedFsm_completionTime"
	CONST_PROP_ID_EQUIPMENT_LOCATOR_LED_FSM_CURRENT_FSM = "equipment_LocatorLedFsm_currentFsm"
	CONST_PROP_ID_EQUIPMENT_LOCATOR_LED_FSM_DESCR = "equipment_LocatorLedFsm_descr"
	CONST_PROP_ID_EQUIPMENT_LOCATOR_LED_FSM_FSM_STATUS = "equipment_LocatorLedFsm_fsmStatus"
	CONST_PROP_ID_EQUIPMENT_LOCATOR_LED_FSM_INSTANCE_ID = "equipment_LocatorLedFsm_instanceId"
	CONST_PROP_ID_EQUIPMENT_LOCATOR_LED_FSM_PROGRESS = "equipment_LocatorLedFsm_progress"
	CONST_PROP_ID_EQUIPMENT_LOCATOR_LED_FSM_RMT_ERR_CODE = "equipment_LocatorLedFsm_rmtErrCode"
	CONST_PROP_ID_EQUIPMENT_LOCATOR_LED_FSM_RMT_ERR_DESCR = "equipment_LocatorLedFsm_rmtErrDescr"
	CONST_PROP_ID_EQUIPMENT_LOCATOR_LED_FSM_RMT_RSLT = "equipment_LocatorLedFsm_rmtRslt"
	CONST_PROP_ID_EQUIPMENT_LOCATOR_LED_ADMIN_STATE = "equipment_LocatorLed_adminState"
	CONST_PROP_ID_EQUIPMENT_LOCATOR_LED_COLOR = "equipment_LocatorLed_color"
	CONST_PROP_ID_EQUIPMENT_LOCATOR_LED_FSM_DESCR = "equipment_LocatorLed_fsmDescr"
	CONST_PROP_ID_EQUIPMENT_LOCATOR_LED_FSM_PREV = "equipment_LocatorLed_fsmPrev"
	CONST_PROP_ID_EQUIPMENT_LOCATOR_LED_FSM_PROGR = "equipment_LocatorLed_fsmProgr"
	CONST_PROP_ID_EQUIPMENT_LOCATOR_LED_FSM_RMT_INV_ERR_CODE = "equipment_LocatorLed_fsmRmtInvErrCode"
	CONST_PROP_ID_EQUIPMENT_LOCATOR_LED_FSM_RMT_INV_ERR_DESCR = "equipment_LocatorLed_fsmRmtInvErrDescr"
	CONST_PROP_ID_EQUIPMENT_LOCATOR_LED_FSM_RMT_INV_RSLT = "equipment_LocatorLed_fsmRmtInvRslt"
	CONST_PROP_ID_EQUIPMENT_LOCATOR_LED_FSM_STAGE_DESCR = "equipment_LocatorLed_fsmStageDescr"
	CONST_PROP_ID_EQUIPMENT_LOCATOR_LED_FSM_STAMP = "equipment_LocatorLed_fsmStamp"
	CONST_PROP_ID_EQUIPMENT_LOCATOR_LED_FSM_STATUS = "equipment_LocatorLed_fsmStatus"
	CONST_PROP_ID_EQUIPMENT_LOCATOR_LED_FSM_TRY = "equipment_LocatorLed_fsmTry"
	CONST_PROP_ID_EQUIPMENT_LOCATOR_LED_ID = "equipment_LocatorLed_id"
	CONST_PROP_ID_EQUIPMENT_LOCATOR_LED_NAME = "equipment_LocatorLed_name"
	CONST_PROP_ID_EQUIPMENT_LOCATOR_LED_OPER_STATE = "equipment_LocatorLed_operState"
	CONST_PROP_ID_EQUIPMENT_MANUFACTURING_DEF_CAPTION = "equipment_ManufacturingDef_caption"
	CONST_PROP_ID_EQUIPMENT_MANUFACTURING_DEF_CLEI = "equipment_ManufacturingDef_clei"
	CONST_PROP_ID_EQUIPMENT_MANUFACTURING_DEF_DESCR = "equipment_ManufacturingDef_descr"
	CONST_PROP_ID_EQUIPMENT_MANUFACTURING_DEF_DESCRIPTION = "equipment_ManufacturingDef_description"
	CONST_PROP_ID_EQUIPMENT_MANUFACTURING_DEF_FRU_MAJOR_TYPE = "equipment_ManufacturingDef_fruMajorType"
	CONST_PROP_ID_EQUIPMENT_MANUFACTURING_DEF_FRU_MINOR_TYPE = "equipment_ManufacturingDef_fruMinorType"
	CONST_PROP_ID_EQUIPMENT_MANUFACTURING_DEF_INT_ID = "equipment_ManufacturingDef_intId"
	CONST_PROP_ID_EQUIPMENT_MANUFACTURING_DEF_NAME = "equipment_ManufacturingDef_name"
	CONST_PROP_ID_EQUIPMENT_MANUFACTURING_DEF_OEM_NAME = "equipment_ManufacturingDef_oemName"
	CONST_PROP_ID_EQUIPMENT_MANUFACTURING_DEF_OEM_PART_NUMBER = "equipment_ManufacturingDef_oemPartNumber"
	CONST_PROP_ID_EQUIPMENT_MANUFACTURING_DEF_PART_NUMBER = "equipment_ManufacturingDef_partNumber"
	CONST_PROP_ID_EQUIPMENT_MANUFACTURING_DEF_PID = "equipment_ManufacturingDef_pid"
	CONST_PROP_ID_EQUIPMENT_MANUFACTURING_DEF_POLICY_LEVEL = "equipment_ManufacturingDef_policyLevel"
	CONST_PROP_ID_EQUIPMENT_MANUFACTURING_DEF_POLICY_OWNER = "equipment_ManufacturingDef_policyOwner"
	CONST_PROP_ID_EQUIPMENT_MANUFACTURING_DEF_SERIES = "equipment_ManufacturingDef_series"
	CONST_PROP_ID_EQUIPMENT_MANUFACTURING_DEF_SKU = "equipment_ManufacturingDef_sku"
	CONST_PROP_ID_EQUIPMENT_MANUFACTURING_DEF_VENDOR_EQUIPMENT_TYPE = "equipment_ManufacturingDef_vendorEquipmentType"
	CONST_PROP_ID_EQUIPMENT_MANUFACTURING_DEF_VID = "equipment_ManufacturingDef_vid"
	CONST_PROP_ID_EQUIPMENT_MEMORY_UNIT_CAP_PROVIDER_DELETED = "equipment_MemoryUnitCapProvider_deleted"
	CONST_PROP_ID_EQUIPMENT_MEMORY_UNIT_CAP_PROVIDER_DEPRECATED = "equipment_MemoryUnitCapProvider_deprecated"
	CONST_PROP_ID_EQUIPMENT_MEMORY_UNIT_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "equipment_MemoryUnitCapProvider_elementLoadFailures"
	CONST_PROP_ID_EQUIPMENT_MEMORY_UNIT_CAP_PROVIDER_ELEMENTS_LOADED = "equipment_MemoryUnitCapProvider_elementsLoaded"
	CONST_PROP_ID_EQUIPMENT_MEMORY_UNIT_CAP_PROVIDER_GENCOUNT = "equipment_MemoryUnitCapProvider_gencount"
	CONST_PROP_ID_EQUIPMENT_MEMORY_UNIT_CAP_PROVIDER_LOAD_ERRORS = "equipment_MemoryUnitCapProvider_loadErrors"
	CONST_PROP_ID_EQUIPMENT_MEMORY_UNIT_CAP_PROVIDER_LOAD_WARNINGS = "equipment_MemoryUnitCapProvider_loadWarnings"
	CONST_PROP_ID_EQUIPMENT_MEMORY_UNIT_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_MemoryUnitCapProvider_mgmtPlaneVer"
	CONST_PROP_ID_EQUIPMENT_MEMORY_UNIT_CAP_PROVIDER_MODEL = "equipment_MemoryUnitCapProvider_model"
	CONST_PROP_ID_EQUIPMENT_MEMORY_UNIT_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_MemoryUnitCapProvider_promCardType"
	CONST_PROP_ID_EQUIPMENT_MEMORY_UNIT_CAP_PROVIDER_REVISION = "equipment_MemoryUnitCapProvider_revision"
	CONST_PROP_ID_EQUIPMENT_MEMORY_UNIT_CAP_PROVIDER_VENDOR = "equipment_MemoryUnitCapProvider_vendor"
	CONST_PROP_ID_EQUIPMENT_MEMORY_UNIT_DISCOVERY_MODIFIER_DEF_ACTION = "equipment_MemoryUnitDiscoveryModifierDef_action"
	CONST_PROP_ID_EQUIPMENT_MEMORY_UNIT_DISCOVERY_MODIFIER_DEF_CONSTRAINT_TYPE = "equipment_MemoryUnitDiscoveryModifierDef_constraintType"
	CONST_PROP_ID_EQUIPMENT_MEMORY_UNIT_DISCOVERY_MODIFIER_DEF_DESCR = "equipment_MemoryUnitDiscoveryModifierDef_descr"
	CONST_PROP_ID_EQUIPMENT_MEMORY_UNIT_DISCOVERY_MODIFIER_DEF_INT_ID = "equipment_MemoryUnitDiscoveryModifierDef_intId"
	CONST_PROP_ID_EQUIPMENT_MEMORY_UNIT_DISCOVERY_MODIFIER_DEF_NAME = "equipment_MemoryUnitDiscoveryModifierDef_name"
	CONST_PROP_ID_EQUIPMENT_MEMORY_UNIT_DISCOVERY_MODIFIER_DEF_POLICY_LEVEL = "equipment_MemoryUnitDiscoveryModifierDef_policyLevel"
	CONST_PROP_ID_EQUIPMENT_MEMORY_UNIT_DISCOVERY_MODIFIER_DEF_POLICY_OWNER = "equipment_MemoryUnitDiscoveryModifierDef_policyOwner"
	CONST_PROP_ID_EQUIPMENT_MFG_INFO_MFG_TIME = "equipment_MfgInfo_mfgTime"
	CONST_PROP_ID_EQUIPMENT_MGMT_CAP_PROVIDER_DELETED = "equipment_MgmtCapProvider_deleted"
	CONST_PROP_ID_EQUIPMENT_MGMT_CAP_PROVIDER_DEPRECATED = "equipment_MgmtCapProvider_deprecated"
	CONST_PROP_ID_EQUIPMENT_MGMT_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "equipment_MgmtCapProvider_elementLoadFailures"
	CONST_PROP_ID_EQUIPMENT_MGMT_CAP_PROVIDER_ELEMENTS_LOADED = "equipment_MgmtCapProvider_elementsLoaded"
	CONST_PROP_ID_EQUIPMENT_MGMT_CAP_PROVIDER_GENCOUNT = "equipment_MgmtCapProvider_gencount"
	CONST_PROP_ID_EQUIPMENT_MGMT_CAP_PROVIDER_LOAD_ERRORS = "equipment_MgmtCapProvider_loadErrors"
	CONST_PROP_ID_EQUIPMENT_MGMT_CAP_PROVIDER_LOAD_WARNINGS = "equipment_MgmtCapProvider_loadWarnings"
	CONST_PROP_ID_EQUIPMENT_MGMT_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_MgmtCapProvider_mgmtPlaneVer"
	CONST_PROP_ID_EQUIPMENT_MGMT_CAP_PROVIDER_MODEL = "equipment_MgmtCapProvider_model"
	CONST_PROP_ID_EQUIPMENT_MGMT_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_MgmtCapProvider_promCardType"
	CONST_PROP_ID_EQUIPMENT_MGMT_CAP_PROVIDER_REVISION = "equipment_MgmtCapProvider_revision"
	CONST_PROP_ID_EQUIPMENT_MGMT_CAP_PROVIDER_VENDOR = "equipment_MgmtCapProvider_vendor"
	CONST_PROP_ID_EQUIPMENT_MGMT_EXT_CAP_PROVIDER_DELETED = "equipment_MgmtExtCapProvider_deleted"
	CONST_PROP_ID_EQUIPMENT_MGMT_EXT_CAP_PROVIDER_DEPRECATED = "equipment_MgmtExtCapProvider_deprecated"
	CONST_PROP_ID_EQUIPMENT_MGMT_EXT_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "equipment_MgmtExtCapProvider_elementLoadFailures"
	CONST_PROP_ID_EQUIPMENT_MGMT_EXT_CAP_PROVIDER_ELEMENTS_LOADED = "equipment_MgmtExtCapProvider_elementsLoaded"
	CONST_PROP_ID_EQUIPMENT_MGMT_EXT_CAP_PROVIDER_GENCOUNT = "equipment_MgmtExtCapProvider_gencount"
	CONST_PROP_ID_EQUIPMENT_MGMT_EXT_CAP_PROVIDER_LOAD_ERRORS = "equipment_MgmtExtCapProvider_loadErrors"
	CONST_PROP_ID_EQUIPMENT_MGMT_EXT_CAP_PROVIDER_LOAD_WARNINGS = "equipment_MgmtExtCapProvider_loadWarnings"
	CONST_PROP_ID_EQUIPMENT_MGMT_EXT_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_MgmtExtCapProvider_mgmtPlaneVer"
	CONST_PROP_ID_EQUIPMENT_MGMT_EXT_CAP_PROVIDER_MODEL = "equipment_MgmtExtCapProvider_model"
	CONST_PROP_ID_EQUIPMENT_MGMT_EXT_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_MgmtExtCapProvider_promCardType"
	CONST_PROP_ID_EQUIPMENT_MGMT_EXT_CAP_PROVIDER_REVISION = "equipment_MgmtExtCapProvider_revision"
	CONST_PROP_ID_EQUIPMENT_MGMT_EXT_CAP_PROVIDER_VENDOR = "equipment_MgmtExtCapProvider_vendor"
	CONST_PROP_ID_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_HIST_DRIVE_PERCENTAGE = "equipment_NetworkElementFanStatsHist_drivePercentage"
	CONST_PROP_ID_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_HIST_DRIVE_PERCENTAGE_AVG = "equipment_NetworkElementFanStatsHist_drivePercentageAvg"
	CONST_PROP_ID_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_HIST_DRIVE_PERCENTAGE_MAX = "equipment_NetworkElementFanStatsHist_drivePercentageMax"
	CONST_PROP_ID_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_HIST_DRIVE_PERCENTAGE_MIN = "equipment_NetworkElementFanStatsHist_drivePercentageMin"
	CONST_PROP_ID_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_HIST_ID = "equipment_NetworkElementFanStatsHist_id"
	CONST_PROP_ID_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_HIST_MOST_RECENT = "equipment_NetworkElementFanStatsHist_mostRecent"
	CONST_PROP_ID_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_HIST_SPEED = "equipment_NetworkElementFanStatsHist_speed"
	CONST_PROP_ID_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_HIST_SPEED_AVG = "equipment_NetworkElementFanStatsHist_speedAvg"
	CONST_PROP_ID_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_HIST_SPEED_MAX = "equipment_NetworkElementFanStatsHist_speedMax"
	CONST_PROP_ID_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_HIST_SPEED_MIN = "equipment_NetworkElementFanStatsHist_speedMin"
	CONST_PROP_ID_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_HIST_SUSPECT = "equipment_NetworkElementFanStatsHist_suspect"
	CONST_PROP_ID_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_HIST_THRESHOLDED = "equipment_NetworkElementFanStatsHist_thresholded"
	CONST_PROP_ID_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_HIST_TIME_COLLECTED = "equipment_NetworkElementFanStatsHist_timeCollected"
	CONST_PROP_ID_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_AIRFLOW_DIRECTION = "equipment_NetworkElementFanStats_airflowDirection"
	CONST_PROP_ID_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_DRIVE_PERCENTAGE = "equipment_NetworkElementFanStats_drivePercentage"
	CONST_PROP_ID_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_DRIVE_PERCENTAGE_AVG = "equipment_NetworkElementFanStats_drivePercentageAvg"
	CONST_PROP_ID_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_DRIVE_PERCENTAGE_MAX = "equipment_NetworkElementFanStats_drivePercentageMax"
	CONST_PROP_ID_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_DRIVE_PERCENTAGE_MIN = "equipment_NetworkElementFanStats_drivePercentageMin"
	CONST_PROP_ID_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_INTERVALS = "equipment_NetworkElementFanStats_intervals"
	CONST_PROP_ID_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_SPEED = "equipment_NetworkElementFanStats_speed"
	CONST_PROP_ID_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_SPEED_AVG = "equipment_NetworkElementFanStats_speedAvg"
	CONST_PROP_ID_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_SPEED_MAX = "equipment_NetworkElementFanStats_speedMax"
	CONST_PROP_ID_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_SPEED_MIN = "equipment_NetworkElementFanStats_speedMin"
	CONST_PROP_ID_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_SUSPECT = "equipment_NetworkElementFanStats_suspect"
	CONST_PROP_ID_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_THRESHOLDED = "equipment_NetworkElementFanStats_thresholded"
	CONST_PROP_ID_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_TIME_COLLECTED = "equipment_NetworkElementFanStats_timeCollected"
	CONST_PROP_ID_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_UPDATE = "equipment_NetworkElementFanStats_update"
	CONST_PROP_ID_EQUIPMENT_POSTCODE_CONTAINER_BASE_CONTAINER = "equipment_POSTCodeContainer_baseContainer"
	CONST_PROP_ID_EQUIPMENT_POSTCODE_CONTAINER_NAME = "equipment_POSTCodeContainer_name"
	CONST_PROP_ID_EQUIPMENT_POSTCODE_DATA_CODE = "equipment_POSTCodeData_code"
	CONST_PROP_ID_EQUIPMENT_POSTCODE_DATA_DESCR = "equipment_POSTCodeData_descr"
	CONST_PROP_ID_EQUIPMENT_POSTCODE_DATA_GLOBAL_ID = "equipment_POSTCodeData_globalId"
	CONST_PROP_ID_EQUIPMENT_POSTCODE_DATA_LOCAL_ID = "equipment_POSTCodeData_localId"
	CONST_PROP_ID_EQUIPMENT_POSTCODE_DATA_METHOD = "equipment_POSTCodeData_method"
	CONST_PROP_ID_EQUIPMENT_POSTCODE_DATA_NAME = "equipment_POSTCodeData_name"
	CONST_PROP_ID_EQUIPMENT_POSTCODE_DATA_RECOVERABLE = "equipment_POSTCodeData_recoverable"
	CONST_PROP_ID_EQUIPMENT_POSTCODE_DATA_RECOVERY_ACTION = "equipment_POSTCodeData_recoveryAction"
	CONST_PROP_ID_EQUIPMENT_POSTCODE_DATA_SEVERITY = "equipment_POSTCodeData_severity"
	CONST_PROP_ID_EQUIPMENT_POSTCODE_REPORTER_BASE_CONTAINER = "equipment_POSTCodeReporter_baseContainer"
	CONST_PROP_ID_EQUIPMENT_POSTCODE_REPORTER_MODEL = "equipment_POSTCodeReporter_model"
	CONST_PROP_ID_EQUIPMENT_POSTCODE_REPORTER_NAME = "equipment_POSTCodeReporter_name"
	CONST_PROP_ID_EQUIPMENT_POSTCODE_REPORTER_REVISION = "equipment_POSTCodeReporter_revision"
	CONST_PROP_ID_EQUIPMENT_POSTCODE_REPORTER_SERIAL = "equipment_POSTCodeReporter_serial"
	CONST_PROP_ID_EQUIPMENT_POSTCODE_REPORTER_TYPE = "equipment_POSTCodeReporter_type"
	CONST_PROP_ID_EQUIPMENT_POSTCODE_REPORTER_VENDOR = "equipment_POSTCodeReporter_vendor"
	CONST_PROP_ID_EQUIPMENT_POSTCODE_TEMPLATE_BASE_CONTAINER = "equipment_POSTCodeTemplate_baseContainer"
	CONST_PROP_ID_EQUIPMENT_POSTCODE_TEMPLATE_NAME = "equipment_POSTCodeTemplate_name"
	CONST_PROP_ID_EQUIPMENT_POSTCODE_CODE = "equipment_POSTCode_code"
	CONST_PROP_ID_EQUIPMENT_POSTCODE_DESCR = "equipment_POSTCode_descr"
	CONST_PROP_ID_EQUIPMENT_POSTCODE_GLOBAL_ID = "equipment_POSTCode_globalId"
	CONST_PROP_ID_EQUIPMENT_POSTCODE_LOCAL_ID = "equipment_POSTCode_localId"
	CONST_PROP_ID_EQUIPMENT_POSTCODE_METHOD = "equipment_POSTCode_method"
	CONST_PROP_ID_EQUIPMENT_POSTCODE_NAME = "equipment_POSTCode_name"
	CONST_PROP_ID_EQUIPMENT_POSTCODE_RECOVERABLE = "equipment_POSTCode_recoverable"
	CONST_PROP_ID_EQUIPMENT_POSTCODE_RECOVERY_ACTION = "equipment_POSTCode_recoveryAction"
	CONST_PROP_ID_EQUIPMENT_POSTCODE_SEVERITY = "equipment_POSTCode_severity"
	CONST_PROP_ID_EQUIPMENT_POST_CODE = "equipment_POST_code"
	CONST_PROP_ID_EQUIPMENT_POST_CREATED = "equipment_POST_created"
	CONST_PROP_ID_EQUIPMENT_POST_DESCR = "equipment_POST_descr"
	CONST_PROP_ID_EQUIPMENT_POST_GLOBAL_ID = "equipment_POST_globalId"
	CONST_PROP_ID_EQUIPMENT_POST_LOCAL_ID = "equipment_POST_localId"
	CONST_PROP_ID_EQUIPMENT_POST_METHOD = "equipment_POST_method"
	CONST_PROP_ID_EQUIPMENT_POST_NAME = "equipment_POST_name"
	CONST_PROP_ID_EQUIPMENT_POST_RECOVERABLE = "equipment_POST_recoverable"
	CONST_PROP_ID_EQUIPMENT_POST_RECOVERY_ACTION = "equipment_POST_recoveryAction"
	CONST_PROP_ID_EQUIPMENT_POST_SEVERITY = "equipment_POST_severity"
	CONST_PROP_ID_EQUIPMENT_POST_TYPE = "equipment_POST_type"
	CONST_PROP_ID_EQUIPMENT_POST_VALUE = "equipment_POST_value"
	CONST_PROP_ID_EQUIPMENT_PCI_DEF_DESCR = "equipment_PciDef_descr"
	CONST_PROP_ID_EQUIPMENT_PCI_DEF_DEVICE = "equipment_PciDef_device"
	CONST_PROP_ID_EQUIPMENT_PCI_DEF_INT_ID = "equipment_PciDef_intId"
	CONST_PROP_ID_EQUIPMENT_PCI_DEF_NAME = "equipment_PciDef_name"
	CONST_PROP_ID_EQUIPMENT_PCI_DEF_POLICY_LEVEL = "equipment_PciDef_policyLevel"
	CONST_PROP_ID_EQUIPMENT_PCI_DEF_POLICY_OWNER = "equipment_PciDef_policyOwner"
	CONST_PROP_ID_EQUIPMENT_PCI_DEF_SUBDEVICE = "equipment_PciDef_subdevice"
	CONST_PROP_ID_EQUIPMENT_PCI_DEF_SUBVENDOR = "equipment_PciDef_subvendor"
	CONST_PROP_ID_EQUIPMENT_PCI_DEF_VENDOR = "equipment_PciDef_vendor"
	CONST_PROP_ID_EQUIPMENT_PHYSICAL_DEF_DEPTH = "equipment_PhysicalDef_depth"
	CONST_PROP_ID_EQUIPMENT_PHYSICAL_DEF_DESCR = "equipment_PhysicalDef_descr"
	CONST_PROP_ID_EQUIPMENT_PHYSICAL_DEF_HEIGHT = "equipment_PhysicalDef_height"
	CONST_PROP_ID_EQUIPMENT_PHYSICAL_DEF_INT_ID = "equipment_PhysicalDef_intId"
	CONST_PROP_ID_EQUIPMENT_PHYSICAL_DEF_MAXIMUM_POWER = "equipment_PhysicalDef_maximumPower"
	CONST_PROP_ID_EQUIPMENT_PHYSICAL_DEF_MAXIMUM_TEMPERATURE = "equipment_PhysicalDef_maximumTemperature"
	CONST_PROP_ID_EQUIPMENT_PHYSICAL_DEF_MINIMUM_POWER = "equipment_PhysicalDef_minimumPower"
	CONST_PROP_ID_EQUIPMENT_PHYSICAL_DEF_MINIMUM_TEMPERATURE = "equipment_PhysicalDef_minimumTemperature"
	CONST_PROP_ID_EQUIPMENT_PHYSICAL_DEF_NAME = "equipment_PhysicalDef_name"
	CONST_PROP_ID_EQUIPMENT_PHYSICAL_DEF_NOMINAL_POWER = "equipment_PhysicalDef_nominalPower"
	CONST_PROP_ID_EQUIPMENT_PHYSICAL_DEF_NOMINAL_TEMPERATURE = "equipment_PhysicalDef_nominalTemperature"
	CONST_PROP_ID_EQUIPMENT_PHYSICAL_DEF_OPERATING_VOLTAGES = "equipment_PhysicalDef_operatingVoltages"
	CONST_PROP_ID_EQUIPMENT_PHYSICAL_DEF_POLICY_LEVEL = "equipment_PhysicalDef_policyLevel"
	CONST_PROP_ID_EQUIPMENT_PHYSICAL_DEF_POLICY_OWNER = "equipment_PhysicalDef_policyOwner"
	CONST_PROP_ID_EQUIPMENT_PHYSICAL_DEF_WEIGHT = "equipment_PhysicalDef_weight"
	CONST_PROP_ID_EQUIPMENT_PHYSICAL_DEF_WIDTH = "equipment_PhysicalDef_width"
	CONST_PROP_ID_EQUIPMENT_PICTURE_FILE_NAME = "equipment_Picture_fileName"
	CONST_PROP_ID_EQUIPMENT_PICTURE_TYPE = "equipment_Picture_type"
	CONST_PROP_ID_EQUIPMENT_PORT_GROUP_AGGREGATION_DEF_AGGREGATION_CAP = "equipment_PortGroupAggregationDef_aggregationCap"
	CONST_PROP_ID_EQUIPMENT_PORT_GROUP_AGGREGATION_DEF_DESCR = "equipment_PortGroupAggregationDef_descr"
	CONST_PROP_ID_EQUIPMENT_PORT_GROUP_AGGREGATION_DEF_INT_ID = "equipment_PortGroupAggregationDef_intId"
	CONST_PROP_ID_EQUIPMENT_PORT_GROUP_AGGREGATION_DEF_NAME = "equipment_PortGroupAggregationDef_name"
	CONST_PROP_ID_EQUIPMENT_PORT_GROUP_AGGREGATION_DEF_POLICY_LEVEL = "equipment_PortGroupAggregationDef_policyLevel"
	CONST_PROP_ID_EQUIPMENT_PORT_GROUP_AGGREGATION_DEF_POLICY_OWNER = "equipment_PortGroupAggregationDef_policyOwner"
	CONST_PROP_ID_EQUIPMENT_PORT_GROUP_AGGREGATION_DEF_TYPE = "equipment_PortGroupAggregationDef_type"
	CONST_PROP_ID_EQUIPMENT_PORT_GROUP_DEF_DESCR = "equipment_PortGroupDef_descr"
	CONST_PROP_ID_EQUIPMENT_PORT_GROUP_DEF_INT_ID = "equipment_PortGroupDef_intId"
	CONST_PROP_ID_EQUIPMENT_PORT_GROUP_DEF_NAME = "equipment_PortGroupDef_name"
	CONST_PROP_ID_EQUIPMENT_PORT_GROUP_DEF_NUMBER_OF_PORTS = "equipment_PortGroupDef_numberOfPorts"
	CONST_PROP_ID_EQUIPMENT_PORT_GROUP_DEF_POLICY_LEVEL = "equipment_PortGroupDef_policyLevel"
	CONST_PROP_ID_EQUIPMENT_PORT_GROUP_DEF_POLICY_OWNER = "equipment_PortGroupDef_policyOwner"
	CONST_PROP_ID_EQUIPMENT_PORT_GROUP_DEF_TYPE = "equipment_PortGroupDef_type"
	CONST_PROP_ID_EQUIPMENT_PORT_GROUP_SW_COMPLEX_DEF_ASIC = "equipment_PortGroupSwComplexDef_asic"
	CONST_PROP_ID_EQUIPMENT_PORT_GROUP_SW_COMPLEX_DEF_DESCR = "equipment_PortGroupSwComplexDef_descr"
	CONST_PROP_ID_EQUIPMENT_PORT_GROUP_SW_COMPLEX_DEF_INT_ID = "equipment_PortGroupSwComplexDef_intId"
	CONST_PROP_ID_EQUIPMENT_PORT_GROUP_SW_COMPLEX_DEF_NAME = "equipment_PortGroupSwComplexDef_name"
	CONST_PROP_ID_EQUIPMENT_PORT_GROUP_SW_COMPLEX_DEF_POLICY_LEVEL = "equipment_PortGroupSwComplexDef_policyLevel"
	CONST_PROP_ID_EQUIPMENT_PORT_GROUP_SW_COMPLEX_DEF_POLICY_OWNER = "equipment_PortGroupSwComplexDef_policyOwner"
	CONST_PROP_ID_EQUIPMENT_PORT_GROUP_SW_COMPLEX_DEF_PORT_CAPACITY = "equipment_PortGroupSwComplexDef_portCapacity"
	CONST_PROP_ID_EQUIPMENT_PORT_GROUP_SW_COMPLEX_DEF_SW_COMPLEX_CAPACITY = "equipment_PortGroupSwComplexDef_swComplexCapacity"
	CONST_PROP_ID_EQUIPMENT_PORT_GROUP_SW_COMPLEX_DEF_VIF_CAPACITY = "equipment_PortGroupSwComplexDef_vifCapacity"
	CONST_PROP_ID_EQUIPMENT_PORT_SW_COMPLEX_REF_DESCR = "equipment_PortSwComplexRef_descr"
	CONST_PROP_ID_EQUIPMENT_PORT_SW_COMPLEX_REF_INT_ID = "equipment_PortSwComplexRef_intId"
	CONST_PROP_ID_EQUIPMENT_PORT_SW_COMPLEX_REF_MAX_PORT_ID = "equipment_PortSwComplexRef_maxPortId"
	CONST_PROP_ID_EQUIPMENT_PORT_SW_COMPLEX_REF_MIN_PORT_ID = "equipment_PortSwComplexRef_minPortId"
	CONST_PROP_ID_EQUIPMENT_PORT_SW_COMPLEX_REF_NAME = "equipment_PortSwComplexRef_name"
	CONST_PROP_ID_EQUIPMENT_PORT_SW_COMPLEX_REF_POLICY_LEVEL = "equipment_PortSwComplexRef_policyLevel"
	CONST_PROP_ID_EQUIPMENT_PORT_SW_COMPLEX_REF_POLICY_OWNER = "equipment_PortSwComplexRef_policyOwner"
	CONST_PROP_ID_EQUIPMENT_PORT_SW_COMPLEX_REF_SLOT_ID = "equipment_PortSwComplexRef_slotId"
	CONST_PROP_ID_EQUIPMENT_PORT_SW_COMPLEX_REF_SW_COMPLEX_ID = "equipment_PortSwComplexRef_swComplexId"
	CONST_PROP_ID_EQUIPMENT_PROCESSOR_UNIT_CAP_PROVIDER_DELETED = "equipment_ProcessorUnitCapProvider_deleted"
	CONST_PROP_ID_EQUIPMENT_PROCESSOR_UNIT_CAP_PROVIDER_DEPRECATED = "equipment_ProcessorUnitCapProvider_deprecated"
	CONST_PROP_ID_EQUIPMENT_PROCESSOR_UNIT_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "equipment_ProcessorUnitCapProvider_elementLoadFailures"
	CONST_PROP_ID_EQUIPMENT_PROCESSOR_UNIT_CAP_PROVIDER_ELEMENTS_LOADED = "equipment_ProcessorUnitCapProvider_elementsLoaded"
	CONST_PROP_ID_EQUIPMENT_PROCESSOR_UNIT_CAP_PROVIDER_GENCOUNT = "equipment_ProcessorUnitCapProvider_gencount"
	CONST_PROP_ID_EQUIPMENT_PROCESSOR_UNIT_CAP_PROVIDER_LOAD_ERRORS = "equipment_ProcessorUnitCapProvider_loadErrors"
	CONST_PROP_ID_EQUIPMENT_PROCESSOR_UNIT_CAP_PROVIDER_LOAD_WARNINGS = "equipment_ProcessorUnitCapProvider_loadWarnings"
	CONST_PROP_ID_EQUIPMENT_PROCESSOR_UNIT_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_ProcessorUnitCapProvider_mgmtPlaneVer"
	CONST_PROP_ID_EQUIPMENT_PROCESSOR_UNIT_CAP_PROVIDER_MODEL = "equipment_ProcessorUnitCapProvider_model"
	CONST_PROP_ID_EQUIPMENT_PROCESSOR_UNIT_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_ProcessorUnitCapProvider_promCardType"
	CONST_PROP_ID_EQUIPMENT_PROCESSOR_UNIT_CAP_PROVIDER_REVISION = "equipment_ProcessorUnitCapProvider_revision"
	CONST_PROP_ID_EQUIPMENT_PROCESSOR_UNIT_CAP_PROVIDER_VENDOR = "equipment_ProcessorUnitCapProvider_vendor"
	CONST_PROP_ID_EQUIPMENT_PROCESSOR_UNIT_DEF_ADDRESS_WIDTH = "equipment_ProcessorUnitDef_addressWidth"
	CONST_PROP_ID_EQUIPMENT_PROCESSOR_UNIT_DEF_DATA_WIDTH = "equipment_ProcessorUnitDef_dataWidth"
	CONST_PROP_ID_EQUIPMENT_PROCESSOR_UNIT_DEF_DESCR = "equipment_ProcessorUnitDef_descr"
	CONST_PROP_ID_EQUIPMENT_PROCESSOR_UNIT_DEF_INT_ID = "equipment_ProcessorUnitDef_intId"
	CONST_PROP_ID_EQUIPMENT_PROCESSOR_UNIT_DEF_MAX_SPEED = "equipment_ProcessorUnitDef_maxSpeed"
	CONST_PROP_ID_EQUIPMENT_PROCESSOR_UNIT_DEF_NAME = "equipment_ProcessorUnitDef_name"
	CONST_PROP_ID_EQUIPMENT_PROCESSOR_UNIT_DEF_POLICY_LEVEL = "equipment_ProcessorUnitDef_policyLevel"
	CONST_PROP_ID_EQUIPMENT_PROCESSOR_UNIT_DEF_POLICY_OWNER = "equipment_ProcessorUnitDef_policyOwner"
	CONST_PROP_ID_EQUIPMENT_PSU_CAP_PROVIDER_DELETED = "equipment_PsuCapProvider_deleted"
	CONST_PROP_ID_EQUIPMENT_PSU_CAP_PROVIDER_DEPRECATED = "equipment_PsuCapProvider_deprecated"
	CONST_PROP_ID_EQUIPMENT_PSU_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "equipment_PsuCapProvider_elementLoadFailures"
	CONST_PROP_ID_EQUIPMENT_PSU_CAP_PROVIDER_ELEMENTS_LOADED = "equipment_PsuCapProvider_elementsLoaded"
	CONST_PROP_ID_EQUIPMENT_PSU_CAP_PROVIDER_GENCOUNT = "equipment_PsuCapProvider_gencount"
	CONST_PROP_ID_EQUIPMENT_PSU_CAP_PROVIDER_LOAD_ERRORS = "equipment_PsuCapProvider_loadErrors"
	CONST_PROP_ID_EQUIPMENT_PSU_CAP_PROVIDER_LOAD_WARNINGS = "equipment_PsuCapProvider_loadWarnings"
	CONST_PROP_ID_EQUIPMENT_PSU_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_PsuCapProvider_mgmtPlaneVer"
	CONST_PROP_ID_EQUIPMENT_PSU_CAP_PROVIDER_MODEL = "equipment_PsuCapProvider_model"
	CONST_PROP_ID_EQUIPMENT_PSU_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_PsuCapProvider_promCardType"
	CONST_PROP_ID_EQUIPMENT_PSU_CAP_PROVIDER_REVISION = "equipment_PsuCapProvider_revision"
	CONST_PROP_ID_EQUIPMENT_PSU_CAP_PROVIDER_VENDOR = "equipment_PsuCapProvider_vendor"
	CONST_PROP_ID_EQUIPMENT_PSU_DEF_PSU_TYPE = "equipment_PsuDef_PsuType"
	CONST_PROP_ID_EQUIPMENT_PSU_DEF_DESCR = "equipment_PsuDef_descr"
	CONST_PROP_ID_EQUIPMENT_PSU_DEF_INT_ID = "equipment_PsuDef_intId"
	CONST_PROP_ID_EQUIPMENT_PSU_DEF_NAME = "equipment_PsuDef_name"
	CONST_PROP_ID_EQUIPMENT_PSU_DEF_POLICY_LEVEL = "equipment_PsuDef_policyLevel"
	CONST_PROP_ID_EQUIPMENT_PSU_DEF_POLICY_OWNER = "equipment_PsuDef_policyOwner"
	CONST_PROP_ID_EQUIPMENT_PSU_INPUT_STATS_HIST_CURRENT = "equipment_PsuInputStatsHist_current"
	CONST_PROP_ID_EQUIPMENT_PSU_INPUT_STATS_HIST_CURRENT_AVG = "equipment_PsuInputStatsHist_currentAvg"
	CONST_PROP_ID_EQUIPMENT_PSU_INPUT_STATS_HIST_CURRENT_MAX = "equipment_PsuInputStatsHist_currentMax"
	CONST_PROP_ID_EQUIPMENT_PSU_INPUT_STATS_HIST_CURRENT_MIN = "equipment_PsuInputStatsHist_currentMin"
	CONST_PROP_ID_EQUIPMENT_PSU_INPUT_STATS_HIST_ID = "equipment_PsuInputStatsHist_id"
	CONST_PROP_ID_EQUIPMENT_PSU_INPUT_STATS_HIST_MOST_RECENT = "equipment_PsuInputStatsHist_mostRecent"
	CONST_PROP_ID_EQUIPMENT_PSU_INPUT_STATS_HIST_POWER = "equipment_PsuInputStatsHist_power"
	CONST_PROP_ID_EQUIPMENT_PSU_INPUT_STATS_HIST_POWER_AVG = "equipment_PsuInputStatsHist_powerAvg"
	CONST_PROP_ID_EQUIPMENT_PSU_INPUT_STATS_HIST_POWER_MAX = "equipment_PsuInputStatsHist_powerMax"
	CONST_PROP_ID_EQUIPMENT_PSU_INPUT_STATS_HIST_POWER_MIN = "equipment_PsuInputStatsHist_powerMin"
	CONST_PROP_ID_EQUIPMENT_PSU_INPUT_STATS_HIST_SUSPECT = "equipment_PsuInputStatsHist_suspect"
	CONST_PROP_ID_EQUIPMENT_PSU_INPUT_STATS_HIST_THRESHOLDED = "equipment_PsuInputStatsHist_thresholded"
	CONST_PROP_ID_EQUIPMENT_PSU_INPUT_STATS_HIST_TIME_COLLECTED = "equipment_PsuInputStatsHist_timeCollected"
	CONST_PROP_ID_EQUIPMENT_PSU_INPUT_STATS_HIST_VOLTAGE = "equipment_PsuInputStatsHist_voltage"
	CONST_PROP_ID_EQUIPMENT_PSU_INPUT_STATS_HIST_VOLTAGE_AVG = "equipment_PsuInputStatsHist_voltageAvg"
	CONST_PROP_ID_EQUIPMENT_PSU_INPUT_STATS_HIST_VOLTAGE_MAX = "equipment_PsuInputStatsHist_voltageMax"
	CONST_PROP_ID_EQUIPMENT_PSU_INPUT_STATS_HIST_VOLTAGE_MIN = "equipment_PsuInputStatsHist_voltageMin"
	CONST_PROP_ID_EQUIPMENT_PSU_INPUT_STATS_CURRENT = "equipment_PsuInputStats_current"
	CONST_PROP_ID_EQUIPMENT_PSU_INPUT_STATS_CURRENT_AVG = "equipment_PsuInputStats_currentAvg"
	CONST_PROP_ID_EQUIPMENT_PSU_INPUT_STATS_CURRENT_MAX = "equipment_PsuInputStats_currentMax"
	CONST_PROP_ID_EQUIPMENT_PSU_INPUT_STATS_CURRENT_MIN = "equipment_PsuInputStats_currentMin"
	CONST_PROP_ID_EQUIPMENT_PSU_INPUT_STATS_INPUT_STATUS = "equipment_PsuInputStats_inputStatus"
	CONST_PROP_ID_EQUIPMENT_PSU_INPUT_STATS_INTERVALS = "equipment_PsuInputStats_intervals"
	CONST_PROP_ID_EQUIPMENT_PSU_INPUT_STATS_POWER = "equipment_PsuInputStats_power"
	CONST_PROP_ID_EQUIPMENT_PSU_INPUT_STATS_POWER_AVG = "equipment_PsuInputStats_powerAvg"
	CONST_PROP_ID_EQUIPMENT_PSU_INPUT_STATS_POWER_MAX = "equipment_PsuInputStats_powerMax"
	CONST_PROP_ID_EQUIPMENT_PSU_INPUT_STATS_POWER_MIN = "equipment_PsuInputStats_powerMin"
	CONST_PROP_ID_EQUIPMENT_PSU_INPUT_STATS_SUSPECT = "equipment_PsuInputStats_suspect"
	CONST_PROP_ID_EQUIPMENT_PSU_INPUT_STATS_THRESHOLDED = "equipment_PsuInputStats_thresholded"
	CONST_PROP_ID_EQUIPMENT_PSU_INPUT_STATS_TIME_COLLECTED = "equipment_PsuInputStats_timeCollected"
	CONST_PROP_ID_EQUIPMENT_PSU_INPUT_STATS_UPDATE = "equipment_PsuInputStats_update"
	CONST_PROP_ID_EQUIPMENT_PSU_INPUT_STATS_VOLTAGE = "equipment_PsuInputStats_voltage"
	CONST_PROP_ID_EQUIPMENT_PSU_INPUT_STATS_VOLTAGE_AVG = "equipment_PsuInputStats_voltageAvg"
	CONST_PROP_ID_EQUIPMENT_PSU_INPUT_STATS_VOLTAGE_MAX = "equipment_PsuInputStats_voltageMax"
	CONST_PROP_ID_EQUIPMENT_PSU_INPUT_STATS_VOLTAGE_MIN = "equipment_PsuInputStats_voltageMin"
	CONST_PROP_ID_EQUIPMENT_PSU_OUTPUT_STATS_HIST_CURRENT = "equipment_PsuOutputStatsHist_current"
	CONST_PROP_ID_EQUIPMENT_PSU_OUTPUT_STATS_HIST_CURRENT_AVG = "equipment_PsuOutputStatsHist_currentAvg"
	CONST_PROP_ID_EQUIPMENT_PSU_OUTPUT_STATS_HIST_CURRENT_MAX = "equipment_PsuOutputStatsHist_currentMax"
	CONST_PROP_ID_EQUIPMENT_PSU_OUTPUT_STATS_HIST_CURRENT_MIN = "equipment_PsuOutputStatsHist_currentMin"
	CONST_PROP_ID_EQUIPMENT_PSU_OUTPUT_STATS_HIST_ID = "equipment_PsuOutputStatsHist_id"
	CONST_PROP_ID_EQUIPMENT_PSU_OUTPUT_STATS_HIST_MOST_RECENT = "equipment_PsuOutputStatsHist_mostRecent"
	CONST_PROP_ID_EQUIPMENT_PSU_OUTPUT_STATS_HIST_POWER = "equipment_PsuOutputStatsHist_power"
	CONST_PROP_ID_EQUIPMENT_PSU_OUTPUT_STATS_HIST_POWER_AVG = "equipment_PsuOutputStatsHist_powerAvg"
	CONST_PROP_ID_EQUIPMENT_PSU_OUTPUT_STATS_HIST_POWER_MAX = "equipment_PsuOutputStatsHist_powerMax"
	CONST_PROP_ID_EQUIPMENT_PSU_OUTPUT_STATS_HIST_POWER_MIN = "equipment_PsuOutputStatsHist_powerMin"
	CONST_PROP_ID_EQUIPMENT_PSU_OUTPUT_STATS_HIST_SUSPECT = "equipment_PsuOutputStatsHist_suspect"
	CONST_PROP_ID_EQUIPMENT_PSU_OUTPUT_STATS_HIST_THRESHOLDED = "equipment_PsuOutputStatsHist_thresholded"
	CONST_PROP_ID_EQUIPMENT_PSU_OUTPUT_STATS_HIST_TIME_COLLECTED = "equipment_PsuOutputStatsHist_timeCollected"
	CONST_PROP_ID_EQUIPMENT_PSU_OUTPUT_STATS_HIST_VOLTAGE = "equipment_PsuOutputStatsHist_voltage"
	CONST_PROP_ID_EQUIPMENT_PSU_OUTPUT_STATS_HIST_VOLTAGE_AVG = "equipment_PsuOutputStatsHist_voltageAvg"
	CONST_PROP_ID_EQUIPMENT_PSU_OUTPUT_STATS_HIST_VOLTAGE_MAX = "equipment_PsuOutputStatsHist_voltageMax"
	CONST_PROP_ID_EQUIPMENT_PSU_OUTPUT_STATS_HIST_VOLTAGE_MIN = "equipment_PsuOutputStatsHist_voltageMin"
	CONST_PROP_ID_EQUIPMENT_PSU_OUTPUT_STATS_CURRENT = "equipment_PsuOutputStats_current"
	CONST_PROP_ID_EQUIPMENT_PSU_OUTPUT_STATS_CURRENT_AVG = "equipment_PsuOutputStats_currentAvg"
	CONST_PROP_ID_EQUIPMENT_PSU_OUTPUT_STATS_CURRENT_MAX = "equipment_PsuOutputStats_currentMax"
	CONST_PROP_ID_EQUIPMENT_PSU_OUTPUT_STATS_CURRENT_MIN = "equipment_PsuOutputStats_currentMin"
	CONST_PROP_ID_EQUIPMENT_PSU_OUTPUT_STATS_INTERVALS = "equipment_PsuOutputStats_intervals"
	CONST_PROP_ID_EQUIPMENT_PSU_OUTPUT_STATS_OUTPUT_STATUS = "equipment_PsuOutputStats_outputStatus"
	CONST_PROP_ID_EQUIPMENT_PSU_OUTPUT_STATS_POWER = "equipment_PsuOutputStats_power"
	CONST_PROP_ID_EQUIPMENT_PSU_OUTPUT_STATS_POWER_AVG = "equipment_PsuOutputStats_powerAvg"
	CONST_PROP_ID_EQUIPMENT_PSU_OUTPUT_STATS_POWER_MAX = "equipment_PsuOutputStats_powerMax"
	CONST_PROP_ID_EQUIPMENT_PSU_OUTPUT_STATS_POWER_MIN = "equipment_PsuOutputStats_powerMin"
	CONST_PROP_ID_EQUIPMENT_PSU_OUTPUT_STATS_SUSPECT = "equipment_PsuOutputStats_suspect"
	CONST_PROP_ID_EQUIPMENT_PSU_OUTPUT_STATS_THRESHOLDED = "equipment_PsuOutputStats_thresholded"
	CONST_PROP_ID_EQUIPMENT_PSU_OUTPUT_STATS_TIME_COLLECTED = "equipment_PsuOutputStats_timeCollected"
	CONST_PROP_ID_EQUIPMENT_PSU_OUTPUT_STATS_UPDATE = "equipment_PsuOutputStats_update"
	CONST_PROP_ID_EQUIPMENT_PSU_OUTPUT_STATS_VOLTAGE = "equipment_PsuOutputStats_voltage"
	CONST_PROP_ID_EQUIPMENT_PSU_OUTPUT_STATS_VOLTAGE_AVG = "equipment_PsuOutputStats_voltageAvg"
	CONST_PROP_ID_EQUIPMENT_PSU_OUTPUT_STATS_VOLTAGE_MAX = "equipment_PsuOutputStats_voltageMax"
	CONST_PROP_ID_EQUIPMENT_PSU_OUTPUT_STATS_VOLTAGE_MIN = "equipment_PsuOutputStats_voltageMin"
	CONST_PROP_ID_EQUIPMENT_PSU_STATS_HIST_AMBIENT_TEMP = "equipment_PsuStatsHist_ambientTemp"
	CONST_PROP_ID_EQUIPMENT_PSU_STATS_HIST_AMBIENT_TEMP_AVG = "equipment_PsuStatsHist_ambientTempAvg"
	CONST_PROP_ID_EQUIPMENT_PSU_STATS_HIST_AMBIENT_TEMP_MAX = "equipment_PsuStatsHist_ambientTempMax"
	CONST_PROP_ID_EQUIPMENT_PSU_STATS_HIST_AMBIENT_TEMP_MIN = "equipment_PsuStatsHist_ambientTempMin"
	CONST_PROP_ID_EQUIPMENT_PSU_STATS_HIST_ID = "equipment_PsuStatsHist_id"
	CONST_PROP_ID_EQUIPMENT_PSU_STATS_HIST_INPUT210V = "equipment_PsuStatsHist_input210v"
	CONST_PROP_ID_EQUIPMENT_PSU_STATS_HIST_INPUT210V_AVG = "equipment_PsuStatsHist_input210vAvg"
	CONST_PROP_ID_EQUIPMENT_PSU_STATS_HIST_INPUT210V_MAX = "equipment_PsuStatsHist_input210vMax"
	CONST_PROP_ID_EQUIPMENT_PSU_STATS_HIST_INPUT210V_MIN = "equipment_PsuStatsHist_input210vMin"
	CONST_PROP_ID_EQUIPMENT_PSU_STATS_HIST_MOST_RECENT = "equipment_PsuStatsHist_mostRecent"
	CONST_PROP_ID_EQUIPMENT_PSU_STATS_HIST_OUTPUT12V = "equipment_PsuStatsHist_output12v"
	CONST_PROP_ID_EQUIPMENT_PSU_STATS_HIST_OUTPUT12V_AVG = "equipment_PsuStatsHist_output12vAvg"
	CONST_PROP_ID_EQUIPMENT_PSU_STATS_HIST_OUTPUT12V_MAX = "equipment_PsuStatsHist_output12vMax"
	CONST_PROP_ID_EQUIPMENT_PSU_STATS_HIST_OUTPUT12V_MIN = "equipment_PsuStatsHist_output12vMin"
	CONST_PROP_ID_EQUIPMENT_PSU_STATS_HIST_OUTPUT3V3 = "equipment_PsuStatsHist_output3v3"
	CONST_PROP_ID_EQUIPMENT_PSU_STATS_HIST_OUTPUT3V3_AVG = "equipment_PsuStatsHist_output3v3Avg"
	CONST_PROP_ID_EQUIPMENT_PSU_STATS_HIST_OUTPUT3V3_MAX = "equipment_PsuStatsHist_output3v3Max"
	CONST_PROP_ID_EQUIPMENT_PSU_STATS_HIST_OUTPUT3V3_MIN = "equipment_PsuStatsHist_output3v3Min"
	CONST_PROP_ID_EQUIPMENT_PSU_STATS_HIST_OUTPUT_CURRENT = "equipment_PsuStatsHist_outputCurrent"
	CONST_PROP_ID_EQUIPMENT_PSU_STATS_HIST_OUTPUT_CURRENT_AVG = "equipment_PsuStatsHist_outputCurrentAvg"
	CONST_PROP_ID_EQUIPMENT_PSU_STATS_HIST_OUTPUT_CURRENT_MAX = "equipment_PsuStatsHist_outputCurrentMax"
	CONST_PROP_ID_EQUIPMENT_PSU_STATS_HIST_OUTPUT_CURRENT_MIN = "equipment_PsuStatsHist_outputCurrentMin"
	CONST_PROP_ID_EQUIPMENT_PSU_STATS_HIST_OUTPUT_POWER = "equipment_PsuStatsHist_outputPower"
	CONST_PROP_ID_EQUIPMENT_PSU_STATS_HIST_OUTPUT_POWER_AVG = "equipment_PsuStatsHist_outputPowerAvg"
	CONST_PROP_ID_EQUIPMENT_PSU_STATS_HIST_OUTPUT_POWER_MAX = "equipment_PsuStatsHist_outputPowerMax"
	CONST_PROP_ID_EQUIPMENT_PSU_STATS_HIST_OUTPUT_POWER_MIN = "equipment_PsuStatsHist_outputPowerMin"
	CONST_PROP_ID_EQUIPMENT_PSU_STATS_HIST_SUSPECT = "equipment_PsuStatsHist_suspect"
	CONST_PROP_ID_EQUIPMENT_PSU_STATS_HIST_THRESHOLDED = "equipment_PsuStatsHist_thresholded"
	CONST_PROP_ID_EQUIPMENT_PSU_STATS_HIST_TIME_COLLECTED = "equipment_PsuStatsHist_timeCollected"
	CONST_PROP_ID_EQUIPMENT_PSU_STATS_AMBIENT_TEMP = "equipment_PsuStats_ambientTemp"
	CONST_PROP_ID_EQUIPMENT_PSU_STATS_AMBIENT_TEMP_AVG = "equipment_PsuStats_ambientTempAvg"
	CONST_PROP_ID_EQUIPMENT_PSU_STATS_AMBIENT_TEMP_MAX = "equipment_PsuStats_ambientTempMax"
	CONST_PROP_ID_EQUIPMENT_PSU_STATS_AMBIENT_TEMP_MIN = "equipment_PsuStats_ambientTempMin"
	CONST_PROP_ID_EQUIPMENT_PSU_STATS_INPUT210V = "equipment_PsuStats_input210v"
	CONST_PROP_ID_EQUIPMENT_PSU_STATS_INPUT210V_AVG = "equipment_PsuStats_input210vAvg"
	CONST_PROP_ID_EQUIPMENT_PSU_STATS_INPUT210V_MAX = "equipment_PsuStats_input210vMax"
	CONST_PROP_ID_EQUIPMENT_PSU_STATS_INPUT210V_MIN = "equipment_PsuStats_input210vMin"
	CONST_PROP_ID_EQUIPMENT_PSU_STATS_INTERVALS = "equipment_PsuStats_intervals"
	CONST_PROP_ID_EQUIPMENT_PSU_STATS_OUTPUT12V = "equipment_PsuStats_output12v"
	CONST_PROP_ID_EQUIPMENT_PSU_STATS_OUTPUT12V_AVG = "equipment_PsuStats_output12vAvg"
	CONST_PROP_ID_EQUIPMENT_PSU_STATS_OUTPUT12V_MAX = "equipment_PsuStats_output12vMax"
	CONST_PROP_ID_EQUIPMENT_PSU_STATS_OUTPUT12V_MIN = "equipment_PsuStats_output12vMin"
	CONST_PROP_ID_EQUIPMENT_PSU_STATS_OUTPUT3V3 = "equipment_PsuStats_output3v3"
	CONST_PROP_ID_EQUIPMENT_PSU_STATS_OUTPUT3V3_AVG = "equipment_PsuStats_output3v3Avg"
	CONST_PROP_ID_EQUIPMENT_PSU_STATS_OUTPUT3V3_MAX = "equipment_PsuStats_output3v3Max"
	CONST_PROP_ID_EQUIPMENT_PSU_STATS_OUTPUT3V3_MIN = "equipment_PsuStats_output3v3Min"
	CONST_PROP_ID_EQUIPMENT_PSU_STATS_OUTPUT_CURRENT = "equipment_PsuStats_outputCurrent"
	CONST_PROP_ID_EQUIPMENT_PSU_STATS_OUTPUT_CURRENT_AVG = "equipment_PsuStats_outputCurrentAvg"
	CONST_PROP_ID_EQUIPMENT_PSU_STATS_OUTPUT_CURRENT_MAX = "equipment_PsuStats_outputCurrentMax"
	CONST_PROP_ID_EQUIPMENT_PSU_STATS_OUTPUT_CURRENT_MIN = "equipment_PsuStats_outputCurrentMin"
	CONST_PROP_ID_EQUIPMENT_PSU_STATS_OUTPUT_POWER = "equipment_PsuStats_outputPower"
	CONST_PROP_ID_EQUIPMENT_PSU_STATS_OUTPUT_POWER_AVG = "equipment_PsuStats_outputPowerAvg"
	CONST_PROP_ID_EQUIPMENT_PSU_STATS_OUTPUT_POWER_MAX = "equipment_PsuStats_outputPowerMax"
	CONST_PROP_ID_EQUIPMENT_PSU_STATS_OUTPUT_POWER_MIN = "equipment_PsuStats_outputPowerMin"
	CONST_PROP_ID_EQUIPMENT_PSU_STATS_PSU_TEMP1 = "equipment_PsuStats_psuTemp1"
	CONST_PROP_ID_EQUIPMENT_PSU_STATS_PSU_TEMP2 = "equipment_PsuStats_psuTemp2"
	CONST_PROP_ID_EQUIPMENT_PSU_STATS_SUSPECT = "equipment_PsuStats_suspect"
	CONST_PROP_ID_EQUIPMENT_PSU_STATS_THRESHOLDED = "equipment_PsuStats_thresholded"
	CONST_PROP_ID_EQUIPMENT_PSU_STATS_TIME_COLLECTED = "equipment_PsuStats_timeCollected"
	CONST_PROP_ID_EQUIPMENT_PSU_STATS_UPDATE = "equipment_PsuStats_update"
	CONST_PROP_ID_EQUIPMENT_PSU_TYPE = "equipment_Psu_Type"
	CONST_PROP_ID_EQUIPMENT_PSU_ID = "equipment_Psu_id"
	CONST_PROP_ID_EQUIPMENT_PSU_MODEL = "equipment_Psu_model"
	CONST_PROP_ID_EQUIPMENT_PSU_OPER_QUALIFIER_REASON = "equipment_Psu_operQualifierReason"
	CONST_PROP_ID_EQUIPMENT_PSU_OPER_STATE = "equipment_Psu_operState"
	CONST_PROP_ID_EQUIPMENT_PSU_OPERABILITY = "equipment_Psu_operability"
	CONST_PROP_ID_EQUIPMENT_PSU_PART_NUMBER = "equipment_Psu_partNumber"
	CONST_PROP_ID_EQUIPMENT_PSU_PERF = "equipment_Psu_perf"
	CONST_PROP_ID_EQUIPMENT_PSU_POWER = "equipment_Psu_power"
	CONST_PROP_ID_EQUIPMENT_PSU_POWER_STATE_QUALIFIER = "equipment_Psu_powerStateQualifier"
	CONST_PROP_ID_EQUIPMENT_PSU_PRESENCE = "equipment_Psu_presence"
	CONST_PROP_ID_EQUIPMENT_PSU_PSU_FIRMWARE_VERSION = "equipment_Psu_psuFirmwareVersion"
	CONST_PROP_ID_EQUIPMENT_PSU_REVISION = "equipment_Psu_revision"
	CONST_PROP_ID_EQUIPMENT_PSU_SERIAL = "equipment_Psu_serial"
	CONST_PROP_ID_EQUIPMENT_PSU_THERMAL = "equipment_Psu_thermal"
	CONST_PROP_ID_EQUIPMENT_PSU_VENDOR = "equipment_Psu_vendor"
	CONST_PROP_ID_EQUIPMENT_PSU_VID = "equipment_Psu_vid"
	CONST_PROP_ID_EQUIPMENT_PSU_VOLTAGE = "equipment_Psu_voltage"
	CONST_PROP_ID_EQUIPMENT_RACK_FAN_MODULE_DEF_DESCR = "equipment_RackFanModuleDef_descr"
	CONST_PROP_ID_EQUIPMENT_RACK_FAN_MODULE_DEF_FAN_CAPACITY = "equipment_RackFanModuleDef_fanCapacity"
	CONST_PROP_ID_EQUIPMENT_RACK_FAN_MODULE_DEF_INT_ID = "equipment_RackFanModuleDef_intId"
	CONST_PROP_ID_EQUIPMENT_RACK_FAN_MODULE_DEF_NAME = "equipment_RackFanModuleDef_name"
	CONST_PROP_ID_EQUIPMENT_RACK_FAN_MODULE_DEF_POLICY_LEVEL = "equipment_RackFanModuleDef_policyLevel"
	CONST_PROP_ID_EQUIPMENT_RACK_FAN_MODULE_DEF_POLICY_OWNER = "equipment_RackFanModuleDef_policyOwner"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_CAP_PROVIDER_DELETED = "equipment_RackUnitCapProvider_deleted"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_CAP_PROVIDER_DEPRECATED = "equipment_RackUnitCapProvider_deprecated"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "equipment_RackUnitCapProvider_elementLoadFailures"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_CAP_PROVIDER_ELEMENTS_LOADED = "equipment_RackUnitCapProvider_elementsLoaded"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_CAP_PROVIDER_GENCOUNT = "equipment_RackUnitCapProvider_gencount"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_CAP_PROVIDER_LOAD_ERRORS = "equipment_RackUnitCapProvider_loadErrors"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_CAP_PROVIDER_LOAD_WARNINGS = "equipment_RackUnitCapProvider_loadWarnings"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_CAP_PROVIDER_MAX_LOCAL_DISKS = "equipment_RackUnitCapProvider_maxLocalDisks"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_RackUnitCapProvider_mgmtPlaneVer"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_CAP_PROVIDER_MODEL = "equipment_RackUnitCapProvider_model"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_RackUnitCapProvider_promCardType"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_CAP_PROVIDER_REVISION = "equipment_RackUnitCapProvider_revision"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_CAP_PROVIDER_VENDOR = "equipment_RackUnitCapProvider_vendor"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_FAN_STATS_HIST_ID = "equipment_RackUnitFanStatsHist_id"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_FAN_STATS_HIST_MOST_RECENT = "equipment_RackUnitFanStatsHist_mostRecent"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_FAN_STATS_HIST_SPEED = "equipment_RackUnitFanStatsHist_speed"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_FAN_STATS_HIST_SPEED_AVG = "equipment_RackUnitFanStatsHist_speedAvg"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_FAN_STATS_HIST_SPEED_MAX = "equipment_RackUnitFanStatsHist_speedMax"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_FAN_STATS_HIST_SPEED_MIN = "equipment_RackUnitFanStatsHist_speedMin"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_FAN_STATS_HIST_SUSPECT = "equipment_RackUnitFanStatsHist_suspect"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_FAN_STATS_HIST_THRESHOLDED = "equipment_RackUnitFanStatsHist_thresholded"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_FAN_STATS_HIST_TIME_COLLECTED = "equipment_RackUnitFanStatsHist_timeCollected"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_FAN_STATS_INTERVALS = "equipment_RackUnitFanStats_intervals"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_FAN_STATS_SPEED = "equipment_RackUnitFanStats_speed"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_FAN_STATS_SPEED_AVG = "equipment_RackUnitFanStats_speedAvg"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_FAN_STATS_SPEED_MAX = "equipment_RackUnitFanStats_speedMax"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_FAN_STATS_SPEED_MIN = "equipment_RackUnitFanStats_speedMin"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_FAN_STATS_SUSPECT = "equipment_RackUnitFanStats_suspect"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_FAN_STATS_THRESHOLDED = "equipment_RackUnitFanStats_thresholded"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_FAN_STATS_TIME_COLLECTED = "equipment_RackUnitFanStats_timeCollected"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_FAN_STATS_UPDATE = "equipment_RackUnitFanStats_update"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_AMBIENT_TEMP = "equipment_RackUnitPsuStatsHist_ambientTemp"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_AMBIENT_TEMP_AVG = "equipment_RackUnitPsuStatsHist_ambientTempAvg"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_AMBIENT_TEMP_MAX = "equipment_RackUnitPsuStatsHist_ambientTempMax"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_AMBIENT_TEMP_MIN = "equipment_RackUnitPsuStatsHist_ambientTempMin"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_ID = "equipment_RackUnitPsuStatsHist_id"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_INPUT_POWER = "equipment_RackUnitPsuStatsHist_inputPower"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_INPUT_POWER_AVG = "equipment_RackUnitPsuStatsHist_inputPowerAvg"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_INPUT_POWER_MAX = "equipment_RackUnitPsuStatsHist_inputPowerMax"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_INPUT_POWER_MIN = "equipment_RackUnitPsuStatsHist_inputPowerMin"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_INPUT_VOLTAGE = "equipment_RackUnitPsuStatsHist_inputVoltage"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_INPUT_VOLTAGE_AVG = "equipment_RackUnitPsuStatsHist_inputVoltageAvg"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_INPUT_VOLTAGE_MAX = "equipment_RackUnitPsuStatsHist_inputVoltageMax"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_INPUT_VOLTAGE_MIN = "equipment_RackUnitPsuStatsHist_inputVoltageMin"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_MOST_RECENT = "equipment_RackUnitPsuStatsHist_mostRecent"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_OUTPUT_CURRENT = "equipment_RackUnitPsuStatsHist_outputCurrent"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_OUTPUT_CURRENT_AVG = "equipment_RackUnitPsuStatsHist_outputCurrentAvg"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_OUTPUT_CURRENT_MAX = "equipment_RackUnitPsuStatsHist_outputCurrentMax"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_OUTPUT_CURRENT_MIN = "equipment_RackUnitPsuStatsHist_outputCurrentMin"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_OUTPUT_POWER = "equipment_RackUnitPsuStatsHist_outputPower"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_OUTPUT_POWER_AVG = "equipment_RackUnitPsuStatsHist_outputPowerAvg"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_OUTPUT_POWER_MAX = "equipment_RackUnitPsuStatsHist_outputPowerMax"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_OUTPUT_POWER_MIN = "equipment_RackUnitPsuStatsHist_outputPowerMin"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_OUTPUT_VOLTAGE = "equipment_RackUnitPsuStatsHist_outputVoltage"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_OUTPUT_VOLTAGE_AVG = "equipment_RackUnitPsuStatsHist_outputVoltageAvg"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_OUTPUT_VOLTAGE_MAX = "equipment_RackUnitPsuStatsHist_outputVoltageMax"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_OUTPUT_VOLTAGE_MIN = "equipment_RackUnitPsuStatsHist_outputVoltageMin"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_SUSPECT = "equipment_RackUnitPsuStatsHist_suspect"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_THRESHOLDED = "equipment_RackUnitPsuStatsHist_thresholded"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_TIME_COLLECTED = "equipment_RackUnitPsuStatsHist_timeCollected"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATS_AMBIENT_TEMP = "equipment_RackUnitPsuStats_ambientTemp"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATS_AMBIENT_TEMP_AVG = "equipment_RackUnitPsuStats_ambientTempAvg"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATS_AMBIENT_TEMP_MAX = "equipment_RackUnitPsuStats_ambientTempMax"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATS_AMBIENT_TEMP_MIN = "equipment_RackUnitPsuStats_ambientTempMin"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATS_INPUT_POWER = "equipment_RackUnitPsuStats_inputPower"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATS_INPUT_POWER_AVG = "equipment_RackUnitPsuStats_inputPowerAvg"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATS_INPUT_POWER_MAX = "equipment_RackUnitPsuStats_inputPowerMax"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATS_INPUT_POWER_MIN = "equipment_RackUnitPsuStats_inputPowerMin"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATS_INPUT_VOLTAGE = "equipment_RackUnitPsuStats_inputVoltage"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATS_INPUT_VOLTAGE_AVG = "equipment_RackUnitPsuStats_inputVoltageAvg"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATS_INPUT_VOLTAGE_MAX = "equipment_RackUnitPsuStats_inputVoltageMax"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATS_INPUT_VOLTAGE_MIN = "equipment_RackUnitPsuStats_inputVoltageMin"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATS_INTERVALS = "equipment_RackUnitPsuStats_intervals"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATS_OUTPUT_CURRENT = "equipment_RackUnitPsuStats_outputCurrent"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATS_OUTPUT_CURRENT_AVG = "equipment_RackUnitPsuStats_outputCurrentAvg"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATS_OUTPUT_CURRENT_MAX = "equipment_RackUnitPsuStats_outputCurrentMax"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATS_OUTPUT_CURRENT_MIN = "equipment_RackUnitPsuStats_outputCurrentMin"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATS_OUTPUT_POWER = "equipment_RackUnitPsuStats_outputPower"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATS_OUTPUT_POWER_AVG = "equipment_RackUnitPsuStats_outputPowerAvg"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATS_OUTPUT_POWER_MAX = "equipment_RackUnitPsuStats_outputPowerMax"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATS_OUTPUT_POWER_MIN = "equipment_RackUnitPsuStats_outputPowerMin"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATS_OUTPUT_VOLTAGE = "equipment_RackUnitPsuStats_outputVoltage"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATS_OUTPUT_VOLTAGE_AVG = "equipment_RackUnitPsuStats_outputVoltageAvg"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATS_OUTPUT_VOLTAGE_MAX = "equipment_RackUnitPsuStats_outputVoltageMax"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATS_OUTPUT_VOLTAGE_MIN = "equipment_RackUnitPsuStats_outputVoltageMin"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATS_SUSPECT = "equipment_RackUnitPsuStats_suspect"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATS_THRESHOLDED = "equipment_RackUnitPsuStats_thresholded"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATS_TIME_COLLECTED = "equipment_RackUnitPsuStats_timeCollected"
	CONST_PROP_ID_EQUIPMENT_RACK_UNIT_PSU_STATS_UPDATE = "equipment_RackUnitPsuStats_update"
	CONST_PROP_ID_EQUIPMENT_RAID_DEF_DESCR = "equipment_RaidDef_descr"
	CONST_PROP_ID_EQUIPMENT_RAID_DEF_INT_ID = "equipment_RaidDef_intId"
	CONST_PROP_ID_EQUIPMENT_RAID_DEF_LEVEL = "equipment_RaidDef_level"
	CONST_PROP_ID_EQUIPMENT_RAID_DEF_NAME = "equipment_RaidDef_name"
	CONST_PROP_ID_EQUIPMENT_RAID_DEF_POLICY_LEVEL = "equipment_RaidDef_policyLevel"
	CONST_PROP_ID_EQUIPMENT_RAID_DEF_POLICY_OWNER = "equipment_RaidDef_policyOwner"
	CONST_PROP_ID_EQUIPMENT_SECURE_BOOT_MIN_BIOS_VERSION = "equipment_SecureBoot_minBiosVersion"
	CONST_PROP_ID_EQUIPMENT_SECURE_BOOT_MIN_CIMC_VERSION = "equipment_SecureBoot_minCimcVersion"
	CONST_PROP_ID_EQUIPMENT_SECURE_CONTROLLER_ID = "equipment_SecureController_id"
	CONST_PROP_ID_EQUIPMENT_SECURE_CONTROLLER_MODEL = "equipment_SecureController_model"
	CONST_PROP_ID_EQUIPMENT_SECURE_CONTROLLER_REVISION = "equipment_SecureController_revision"
	CONST_PROP_ID_EQUIPMENT_SECURE_CONTROLLER_SERIAL = "equipment_SecureController_serial"
	CONST_PROP_ID_EQUIPMENT_SECURE_CONTROLLER_VENDOR = "equipment_SecureController_vendor"
	CONST_PROP_ID_EQUIPMENT_SERVER_FEATURE_CAP_CMOS_RESET_SUPPORTED = "equipment_ServerFeatureCap_cmosResetSupported"
	CONST_PROP_ID_EQUIPMENT_SERVICE_DEF_CAN_BE_FRUED = "equipment_ServiceDef_canBeFRUed"
	CONST_PROP_ID_EQUIPMENT_SERVICE_DEF_DESCR = "equipment_ServiceDef_descr"
	CONST_PROP_ID_EQUIPMENT_SERVICE_DEF_INT_ID = "equipment_ServiceDef_intId"
	CONST_PROP_ID_EQUIPMENT_SERVICE_DEF_NAME = "equipment_ServiceDef_name"
	CONST_PROP_ID_EQUIPMENT_SERVICE_DEF_POLICY_LEVEL = "equipment_ServiceDef_policyLevel"
	CONST_PROP_ID_EQUIPMENT_SERVICE_DEF_POLICY_OWNER = "equipment_ServiceDef_policyOwner"
	CONST_PROP_ID_EQUIPMENT_SERVICE_DEF_REMOVAL_CONDITIONS = "equipment_ServiceDef_removalConditions"
	CONST_PROP_ID_EQUIPMENT_SERVICE_DEF_SERVICE_PHILOSOPHY = "equipment_ServiceDef_servicePhilosophy"
	CONST_PROP_ID_EQUIPMENT_SLOT_ARRAY_REF_DESCR = "equipment_SlotArrayRef_descr"
	CONST_PROP_ID_EQUIPMENT_SLOT_ARRAY_REF_INT_ID = "equipment_SlotArrayRef_intId"
	CONST_PROP_ID_EQUIPMENT_SLOT_ARRAY_REF_NAME = "equipment_SlotArrayRef_name"
	CONST_PROP_ID_EQUIPMENT_SLOT_ARRAY_REF_NUMBER_OF_SLOTS_SPANNED = "equipment_SlotArrayRef_numberOfSlotsSpanned"
	CONST_PROP_ID_EQUIPMENT_SLOT_ARRAY_REF_POLICY_LEVEL = "equipment_SlotArrayRef_policyLevel"
	CONST_PROP_ID_EQUIPMENT_SLOT_ARRAY_REF_POLICY_OWNER = "equipment_SlotArrayRef_policyOwner"
	CONST_PROP_ID_EQUIPMENT_SLOT_ARRAY_REF_SLOT_SPAN_ORIENTATION = "equipment_SlotArrayRef_slotSpanOrientation"
	CONST_PROP_ID_EQUIPMENT_SLOT_ARRAY_REF_TARGET_DN = "equipment_SlotArrayRef_targetDn"
	CONST_PROP_ID_EQUIPMENT_SLOT_ARRAY_DESCR = "equipment_SlotArray_descr"
	CONST_PROP_ID_EQUIPMENT_SLOT_ARRAY_FIRST_INDEX = "equipment_SlotArray_firstIndex"
	CONST_PROP_ID_EQUIPMENT_SLOT_ARRAY_HEIGHT = "equipment_SlotArray_height"
	CONST_PROP_ID_EQUIPMENT_SLOT_ARRAY_HORIZONTAL_START_OFFSET = "equipment_SlotArray_horizontalStartOffset"
	CONST_PROP_ID_EQUIPMENT_SLOT_ARRAY_INLINE_GROUP_SEPARATION = "equipment_SlotArray_inlineGroupSeparation"
	CONST_PROP_ID_EQUIPMENT_SLOT_ARRAY_INLINE_GROUP_SIZE = "equipment_SlotArray_inlineGroupSize"
	CONST_PROP_ID_EQUIPMENT_SLOT_ARRAY_INLINE_OFFSET = "equipment_SlotArray_inlineOffset"
	CONST_PROP_ID_EQUIPMENT_SLOT_ARRAY_INT_ID = "equipment_SlotArray_intId"
	CONST_PROP_ID_EQUIPMENT_SLOT_ARRAY_LOCATION = "equipment_SlotArray_location"
	CONST_PROP_ID_EQUIPMENT_SLOT_ARRAY_NAME = "equipment_SlotArray_name"
	CONST_PROP_ID_EQUIPMENT_SLOT_ARRAY_NUMBER_OF_SLOTS = "equipment_SlotArray_numberOfSlots"
	CONST_PROP_ID_EQUIPMENT_SLOT_ARRAY_ORIENTATION = "equipment_SlotArray_orientation"
	CONST_PROP_ID_EQUIPMENT_SLOT_ARRAY_POLICY_LEVEL = "equipment_SlotArray_policyLevel"
	CONST_PROP_ID_EQUIPMENT_SLOT_ARRAY_POLICY_OWNER = "equipment_SlotArray_policyOwner"
	CONST_PROP_ID_EQUIPMENT_SLOT_ARRAY_SELECTOR = "equipment_SlotArray_selector"
	CONST_PROP_ID_EQUIPMENT_SLOT_ARRAY_SLOTS_PER_LINE = "equipment_SlotArray_slotsPerLine"
	CONST_PROP_ID_EQUIPMENT_SLOT_ARRAY_TRANSVERSE_GROUP_SEPARATION = "equipment_SlotArray_transverseGroupSeparation"
	CONST_PROP_ID_EQUIPMENT_SLOT_ARRAY_TRANSVERSE_GROUP_SIZE = "equipment_SlotArray_transverseGroupSize"
	CONST_PROP_ID_EQUIPMENT_SLOT_ARRAY_TRANSVERSE_OFFSET = "equipment_SlotArray_transverseOffset"
	CONST_PROP_ID_EQUIPMENT_SLOT_ARRAY_VERTICAL_START_OFFSET = "equipment_SlotArray_verticalStartOffset"
	CONST_PROP_ID_EQUIPMENT_SLOT_ARRAY_WIDTH = "equipment_SlotArray_width"
	CONST_PROP_ID_EQUIPMENT_STATEFUL_BLADE_COMP_IF_OPER_QUALIFIER_REASON = "equipment_StatefulBladeCompIf_operQualifierReason"
	CONST_PROP_ID_EQUIPMENT_STATEFUL_BLADE_COMP_IF_OPER_STATE = "equipment_StatefulBladeCompIf_operState"
	CONST_PROP_ID_EQUIPMENT_STATEFUL_BLADE_COMP_IF_OPERABILITY = "equipment_StatefulBladeCompIf_operability"
	CONST_PROP_ID_EQUIPMENT_STATEFUL_BLADE_COMP_IF_PERF = "equipment_StatefulBladeCompIf_perf"
	CONST_PROP_ID_EQUIPMENT_STATEFUL_BLADE_COMP_IF_POWER = "equipment_StatefulBladeCompIf_power"
	CONST_PROP_ID_EQUIPMENT_STATEFUL_BLADE_COMP_IF_PRESENCE = "equipment_StatefulBladeCompIf_presence"
	CONST_PROP_ID_EQUIPMENT_STATEFUL_BLADE_COMP_IF_THERMAL = "equipment_StatefulBladeCompIf_thermal"
	CONST_PROP_ID_EQUIPMENT_STATEFUL_BLADE_COMP_IF_VOLTAGE = "equipment_StatefulBladeCompIf_voltage"
	CONST_PROP_ID_EQUIPMENT_STATEFUL_BLADE_COMP_ID = "equipment_StatefulBladeComp_id"
	CONST_PROP_ID_EQUIPMENT_STATEFUL_BLADE_COMP_MODEL = "equipment_StatefulBladeComp_model"
	CONST_PROP_ID_EQUIPMENT_STATEFUL_BLADE_COMP_OPER_QUALIFIER_REASON = "equipment_StatefulBladeComp_operQualifierReason"
	CONST_PROP_ID_EQUIPMENT_STATEFUL_BLADE_COMP_OPER_STATE = "equipment_StatefulBladeComp_operState"
	CONST_PROP_ID_EQUIPMENT_STATEFUL_BLADE_COMP_OPERABILITY = "equipment_StatefulBladeComp_operability"
	CONST_PROP_ID_EQUIPMENT_STATEFUL_BLADE_COMP_PERF = "equipment_StatefulBladeComp_perf"
	CONST_PROP_ID_EQUIPMENT_STATEFUL_BLADE_COMP_POWER = "equipment_StatefulBladeComp_power"
	CONST_PROP_ID_EQUIPMENT_STATEFUL_BLADE_COMP_PRESENCE = "equipment_StatefulBladeComp_presence"
	CONST_PROP_ID_EQUIPMENT_STATEFUL_BLADE_COMP_REVISION = "equipment_StatefulBladeComp_revision"
	CONST_PROP_ID_EQUIPMENT_STATEFUL_BLADE_COMP_SERIAL = "equipment_StatefulBladeComp_serial"
	CONST_PROP_ID_EQUIPMENT_STATEFUL_BLADE_COMP_THERMAL = "equipment_StatefulBladeComp_thermal"
	CONST_PROP_ID_EQUIPMENT_STATEFUL_BLADE_COMP_VENDOR = "equipment_StatefulBladeComp_vendor"
	CONST_PROP_ID_EQUIPMENT_STATEFUL_BLADE_COMP_VOLTAGE = "equipment_StatefulBladeComp_voltage"
	CONST_PROP_ID_EQUIPMENT_STATEFUL_CH_COMP_IF_OPER_QUALIFIER_REASON = "equipment_StatefulChCompIf_operQualifierReason"
	CONST_PROP_ID_EQUIPMENT_STATEFUL_CH_COMP_IF_OPER_STATE = "equipment_StatefulChCompIf_operState"
	CONST_PROP_ID_EQUIPMENT_STATEFUL_CH_COMP_IF_OPERABILITY = "equipment_StatefulChCompIf_operability"
	CONST_PROP_ID_EQUIPMENT_STATEFUL_CH_COMP_IF_PERF = "equipment_StatefulChCompIf_perf"
	CONST_PROP_ID_EQUIPMENT_STATEFUL_CH_COMP_IF_POWER = "equipment_StatefulChCompIf_power"
	CONST_PROP_ID_EQUIPMENT_STATEFUL_CH_COMP_IF_PRESENCE = "equipment_StatefulChCompIf_presence"
	CONST_PROP_ID_EQUIPMENT_STATEFUL_CH_COMP_IF_THERMAL = "equipment_StatefulChCompIf_thermal"
	CONST_PROP_ID_EQUIPMENT_STATEFUL_CH_COMP_IF_VOLTAGE = "equipment_StatefulChCompIf_voltage"
	CONST_PROP_ID_EQUIPMENT_STATEFUL_CH_COMP_ID = "equipment_StatefulChComp_id"
	CONST_PROP_ID_EQUIPMENT_STATEFUL_CH_COMP_MODEL = "equipment_StatefulChComp_model"
	CONST_PROP_ID_EQUIPMENT_STATEFUL_CH_COMP_OPER_QUALIFIER_REASON = "equipment_StatefulChComp_operQualifierReason"
	CONST_PROP_ID_EQUIPMENT_STATEFUL_CH_COMP_OPER_STATE = "equipment_StatefulChComp_operState"
	CONST_PROP_ID_EQUIPMENT_STATEFUL_CH_COMP_OPERABILITY = "equipment_StatefulChComp_operability"
	CONST_PROP_ID_EQUIPMENT_STATEFUL_CH_COMP_PERF = "equipment_StatefulChComp_perf"
	CONST_PROP_ID_EQUIPMENT_STATEFUL_CH_COMP_POWER = "equipment_StatefulChComp_power"
	CONST_PROP_ID_EQUIPMENT_STATEFUL_CH_COMP_PRESENCE = "equipment_StatefulChComp_presence"
	CONST_PROP_ID_EQUIPMENT_STATEFUL_CH_COMP_REVISION = "equipment_StatefulChComp_revision"
	CONST_PROP_ID_EQUIPMENT_STATEFUL_CH_COMP_SERIAL = "equipment_StatefulChComp_serial"
	CONST_PROP_ID_EQUIPMENT_STATEFUL_CH_COMP_THERMAL = "equipment_StatefulChComp_thermal"
	CONST_PROP_ID_EQUIPMENT_STATEFUL_CH_COMP_VENDOR = "equipment_StatefulChComp_vendor"
	CONST_PROP_ID_EQUIPMENT_STATEFUL_CH_COMP_VOLTAGE = "equipment_StatefulChComp_voltage"
	CONST_PROP_ID_EQUIPMENT_STATEFUL_IF_OPER_QUALIFIER_REASON = "equipment_StatefulIf_operQualifierReason"
	CONST_PROP_ID_EQUIPMENT_STATEFUL_IF_OPERABILITY = "equipment_StatefulIf_operability"
	CONST_PROP_ID_EQUIPMENT_STATEFUL_IF_PRESENCE = "equipment_StatefulIf_presence"
	CONST_PROP_ID_EQUIPMENT_STATEFUL_ID = "equipment_Stateful_id"
	CONST_PROP_ID_EQUIPMENT_STATEFUL_MODEL = "equipment_Stateful_model"
	CONST_PROP_ID_EQUIPMENT_STATEFUL_OPER_QUALIFIER_REASON = "equipment_Stateful_operQualifierReason"
	CONST_PROP_ID_EQUIPMENT_STATEFUL_OPERABILITY = "equipment_Stateful_operability"
	CONST_PROP_ID_EQUIPMENT_STATEFUL_PRESENCE = "equipment_Stateful_presence"
	CONST_PROP_ID_EQUIPMENT_STATEFUL_REVISION = "equipment_Stateful_revision"
	CONST_PROP_ID_EQUIPMENT_STATEFUL_SERIAL = "equipment_Stateful_serial"
	CONST_PROP_ID_EQUIPMENT_STATEFUL_VENDOR = "equipment_Stateful_vendor"
	CONST_PROP_ID_EQUIPMENT_SWITCH_CAP_PROVIDER_DELETED = "equipment_SwitchCapProvider_deleted"
	CONST_PROP_ID_EQUIPMENT_SWITCH_CAP_PROVIDER_DEPRECATED = "equipment_SwitchCapProvider_deprecated"
	CONST_PROP_ID_EQUIPMENT_SWITCH_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "equipment_SwitchCapProvider_elementLoadFailures"
	CONST_PROP_ID_EQUIPMENT_SWITCH_CAP_PROVIDER_ELEMENTS_LOADED = "equipment_SwitchCapProvider_elementsLoaded"
	CONST_PROP_ID_EQUIPMENT_SWITCH_CAP_PROVIDER_GENCOUNT = "equipment_SwitchCapProvider_gencount"
	CONST_PROP_ID_EQUIPMENT_SWITCH_CAP_PROVIDER_LOAD_ERRORS = "equipment_SwitchCapProvider_loadErrors"
	CONST_PROP_ID_EQUIPMENT_SWITCH_CAP_PROVIDER_LOAD_WARNINGS = "equipment_SwitchCapProvider_loadWarnings"
	CONST_PROP_ID_EQUIPMENT_SWITCH_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_SwitchCapProvider_mgmtPlaneVer"
	CONST_PROP_ID_EQUIPMENT_SWITCH_CAP_PROVIDER_MODEL = "equipment_SwitchCapProvider_model"
	CONST_PROP_ID_EQUIPMENT_SWITCH_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_SwitchCapProvider_promCardType"
	CONST_PROP_ID_EQUIPMENT_SWITCH_CAP_PROVIDER_REVISION = "equipment_SwitchCapProvider_revision"
	CONST_PROP_ID_EQUIPMENT_SWITCH_CAP_PROVIDER_VENDOR = "equipment_SwitchCapProvider_vendor"
	CONST_PROP_ID_EQUIPMENT_SWITCH_CAP_DESCR = "equipment_SwitchCap_descr"
	CONST_PROP_ID_EQUIPMENT_SWITCH_CAP_FAN_MODULES_SUPPORTED = "equipment_SwitchCap_fanModulesSupported"
	CONST_PROP_ID_EQUIPMENT_SWITCH_CAP_INT_ID = "equipment_SwitchCap_intId"
	CONST_PROP_ID_EQUIPMENT_SWITCH_CAP_LOCATOR_BEACON_SUPPORTED = "equipment_SwitchCap_locatorBeaconSupported"
	CONST_PROP_ID_EQUIPMENT_SWITCH_CAP_MAX_ACTIVE_SPAN_SESSION_COUNT = "equipment_SwitchCap_maxActiveSpanSessionCount"
	CONST_PROP_ID_EQUIPMENT_SWITCH_CAP_MAX_ETH1G_PORT = "equipment_SwitchCap_maxEth1gPort"
	CONST_PROP_ID_EQUIPMENT_SWITCH_CAP_MAX_ETH1G_SLOT = "equipment_SwitchCap_maxEth1gSlot"
	CONST_PROP_ID_EQUIPMENT_SWITCH_CAP_MAX_ETH_PC_MEMBERS = "equipment_SwitchCap_maxEthPcMembers"
	CONST_PROP_ID_EQUIPMENT_SWITCH_CAP_MAX_ETH_PCS = "equipment_SwitchCap_maxEthPcs"
	CONST_PROP_ID_EQUIPMENT_SWITCH_CAP_MAX_FCOE_PC_MEMBERS = "equipment_SwitchCap_maxFcoePcMembers"
	CONST_PROP_ID_EQUIPMENT_SWITCH_CAP_MAX_UPLINK_PORTS = "equipment_SwitchCap_maxUplinkPorts"
	CONST_PROP_ID_EQUIPMENT_SWITCH_CAP_MGMT_DAUGHTER_CARD_SLOT_ID = "equipment_SwitchCap_mgmtDaughterCardSlotId"
	CONST_PROP_ID_EQUIPMENT_SWITCH_CAP_NAME = "equipment_SwitchCap_name"
	CONST_PROP_ID_EQUIPMENT_SWITCH_CAP_POLICY_LEVEL = "equipment_SwitchCap_policyLevel"
	CONST_PROP_ID_EQUIPMENT_SWITCH_CAP_POLICY_OWNER = "equipment_SwitchCap_policyOwner"
	CONST_PROP_ID_EQUIPMENT_SWITCH_CAP_SERENO_NETFLOW_SUPPORTED = "equipment_SwitchCap_serenoNetflowSupported"
	CONST_PROP_ID_EQUIPMENT_SWITCH_CARD_DESCR = "equipment_SwitchCard_descr"
	CONST_PROP_ID_EQUIPMENT_SWITCH_CARD_FLT_AGGR = "equipment_SwitchCard_fltAggr"
	CONST_PROP_ID_EQUIPMENT_SWITCH_CARD_ID = "equipment_SwitchCard_id"
	CONST_PROP_ID_EQUIPMENT_SWITCH_CARD_MODEL = "equipment_SwitchCard_model"
	CONST_PROP_ID_EQUIPMENT_SWITCH_CARD_NUM_PORTS = "equipment_SwitchCard_numPorts"
	CONST_PROP_ID_EQUIPMENT_SWITCH_CARD_OPER_QUALIFIER_REASON = "equipment_SwitchCard_operQualifierReason"
	CONST_PROP_ID_EQUIPMENT_SWITCH_CARD_OPER_STATE = "equipment_SwitchCard_operState"
	CONST_PROP_ID_EQUIPMENT_SWITCH_CARD_OPERABILITY = "equipment_SwitchCard_operability"
	CONST_PROP_ID_EQUIPMENT_SWITCH_CARD_PERF = "equipment_SwitchCard_perf"
	CONST_PROP_ID_EQUIPMENT_SWITCH_CARD_POWER = "equipment_SwitchCard_power"
	CONST_PROP_ID_EQUIPMENT_SWITCH_CARD_PRESENCE = "equipment_SwitchCard_presence"
	CONST_PROP_ID_EQUIPMENT_SWITCH_CARD_REVISION = "equipment_SwitchCard_revision"
	CONST_PROP_ID_EQUIPMENT_SWITCH_CARD_SERIAL = "equipment_SwitchCard_serial"
	CONST_PROP_ID_EQUIPMENT_SWITCH_CARD_STATE = "equipment_SwitchCard_state"
	CONST_PROP_ID_EQUIPMENT_SWITCH_CARD_THERMAL = "equipment_SwitchCard_thermal"
	CONST_PROP_ID_EQUIPMENT_SWITCH_CARD_TS = "equipment_SwitchCard_ts"
	CONST_PROP_ID_EQUIPMENT_SWITCH_CARD_VENDOR = "equipment_SwitchCard_vendor"
	CONST_PROP_ID_EQUIPMENT_SWITCH_CARD_VOLTAGE = "equipment_SwitchCard_voltage"
	CONST_PROP_ID_EQUIPMENT_TPM_CAP_PROVIDER_DELETED = "equipment_TpmCapProvider_deleted"
	CONST_PROP_ID_EQUIPMENT_TPM_CAP_PROVIDER_DEPRECATED = "equipment_TpmCapProvider_deprecated"
	CONST_PROP_ID_EQUIPMENT_TPM_CAP_PROVIDER_ELEMENT_LOAD_FAILURES = "equipment_TpmCapProvider_elementLoadFailures"
	CONST_PROP_ID_EQUIPMENT_TPM_CAP_PROVIDER_ELEMENTS_LOADED = "equipment_TpmCapProvider_elementsLoaded"
	CONST_PROP_ID_EQUIPMENT_TPM_CAP_PROVIDER_GENCOUNT = "equipment_TpmCapProvider_gencount"
	CONST_PROP_ID_EQUIPMENT_TPM_CAP_PROVIDER_LOAD_ERRORS = "equipment_TpmCapProvider_loadErrors"
	CONST_PROP_ID_EQUIPMENT_TPM_CAP_PROVIDER_LOAD_WARNINGS = "equipment_TpmCapProvider_loadWarnings"
	CONST_PROP_ID_EQUIPMENT_TPM_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_TpmCapProvider_mgmtPlaneVer"
	CONST_PROP_ID_EQUIPMENT_TPM_CAP_PROVIDER_MODEL = "equipment_TpmCapProvider_model"
	CONST_PROP_ID_EQUIPMENT_TPM_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_TpmCapProvider_promCardType"
	CONST_PROP_ID_EQUIPMENT_TPM_CAP_PROVIDER_REVISION = "equipment_TpmCapProvider_revision"
	CONST_PROP_ID_EQUIPMENT_TPM_CAP_PROVIDER_VENDOR = "equipment_TpmCapProvider_vendor"
	CONST_PROP_ID_EQUIPMENT_TPM_ACTIVE_STATUS = "equipment_Tpm_activeStatus"
	CONST_PROP_ID_EQUIPMENT_TPM_ENABLED_STATUS = "equipment_Tpm_enabledStatus"
	CONST_PROP_ID_EQUIPMENT_TPM_ID = "equipment_Tpm_id"
	CONST_PROP_ID_EQUIPMENT_TPM_MODEL = "equipment_Tpm_model"
	CONST_PROP_ID_EQUIPMENT_TPM_OWNERSHIP = "equipment_Tpm_ownership"
	CONST_PROP_ID_EQUIPMENT_TPM_PASSWORD_STATE = "equipment_Tpm_passwordState"
	CONST_PROP_ID_EQUIPMENT_TPM_PRESENCE = "equipment_Tpm_presence"
	CONST_PROP_ID_EQUIPMENT_TPM_REVISION = "equipment_Tpm_revision"
	CONST_PROP_ID_EQUIPMENT_TPM_SERIAL = "equipment_Tpm_serial"
	CONST_PROP_ID_EQUIPMENT_TPM_TPM_REVISION = "equipment_Tpm_tpmRevision"
	CONST_PROP_ID_EQUIPMENT_TPM_TYPE = "equipment_Tpm_type"
	CONST_PROP_ID_EQUIPMENT_TPM_VENDOR = "equipment_Tpm_vendor"
	CONST_PROP_ID_EQUIPMENT_UNIFIED_PORT_CAP_PROVIDER_DESCR = "equipment_UnifiedPortCapProvider_descr"
	CONST_PROP_ID_EQUIPMENT_UNIFIED_PORT_CAP_PROVIDER_INT_ID = "equipment_UnifiedPortCapProvider_intId"
	CONST_PROP_ID_EQUIPMENT_UNIFIED_PORT_CAP_PROVIDER_NAME = "equipment_UnifiedPortCapProvider_name"
	CONST_PROP_ID_EQUIPMENT_UNIFIED_PORT_CAP_PROVIDER_POLICY_LEVEL = "equipment_UnifiedPortCapProvider_policyLevel"
	CONST_PROP_ID_EQUIPMENT_UNIFIED_PORT_CAP_PROVIDER_POLICY_OWNER = "equipment_UnifiedPortCapProvider_policyOwner"
	CONST_PROP_ID_EQUIPMENT_UNIFIED_PORT_CAP_PROVIDER_SUPPORTED_ALGORITHM = "equipment_UnifiedPortCapProvider_supportedAlgorithm"
	CONST_PROP_ID_EQUIPMENT_VERSION_CONSTRAINT_MIN_VER1 = "equipment_VersionConstraint_minVer1"
	CONST_PROP_ID_EQUIPMENT_XCVR_ID = "equipment_Xcvr_id"
	CONST_PROP_ID_EQUIPMENT_XCVR_MODEL = "equipment_Xcvr_model"
	CONST_PROP_ID_EQUIPMENT_XCVR_REVISION = "equipment_Xcvr_revision"
	CONST_PROP_ID_EQUIPMENT_XCVR_SERIAL = "equipment_Xcvr_serial"
	CONST_PROP_ID_EQUIPMENT_XCVR_TS = "equipment_Xcvr_ts"
	CONST_PROP_ID_EQUIPMENT_XCVR_TYPE = "equipment_Xcvr_type"
	CONST_PROP_ID_EQUIPMENT_XCVR_VENDOR = "equipment_Xcvr_vendor"
	CONST_PROP_ID_ETHER_CIO_EP_EP_DN = "ether_CIoEp_epDn"
	CONST_PROP_ID_ETHER_CIO_EP_IF_ROLE = "ether_CIoEp_ifRole"
	CONST_PROP_ID_ETHER_CIO_EP_IF_TYPE = "ether_CIoEp_ifType"
	CONST_PROP_ID_ETHER_CIO_EP_LOCALE = "ether_CIoEp_locale"
	CONST_PROP_ID_ETHER_CIO_EP_NAME = "ether_CIoEp_name"
	CONST_PROP_ID_ETHER_CIO_EP_PEER_DN = "ether_CIoEp_peerDn"
	CONST_PROP_ID_ETHER_CIO_EP_PORT_ID = "ether_CIoEp_portId"
	CONST_PROP_ID_ETHER_CIO_EP_SWITCH_ID = "ether_CIoEp_switchId"
	CONST_PROP_ID_ETHER_CIO_EP_TRANSPORT = "ether_CIoEp_transport"
	CONST_PROP_ID_ETHER_CIO_EP_TYPE = "ether_CIoEp_type"
	CONST_PROP_ID_ETHER_ERR_STATS_HIST_ALIGN = "ether_ErrStatsHist_align"
	CONST_PROP_ID_ETHER_ERR_STATS_HIST_ALIGN_DELTA = "ether_ErrStatsHist_alignDelta"
	CONST_PROP_ID_ETHER_ERR_STATS_HIST_ALIGN_DELTA_AVG = "ether_ErrStatsHist_alignDeltaAvg"
	CONST_PROP_ID_ETHER_ERR_STATS_HIST_ALIGN_DELTA_MAX = "ether_ErrStatsHist_alignDeltaMax"
	CONST_PROP_ID_ETHER_ERR_STATS_HIST_ALIGN_DELTA_MIN = "ether_ErrStatsHist_alignDeltaMin"
	CONST_PROP_ID_ETHER_ERR_STATS_HIST_DEFERRED_TX = "ether_ErrStatsHist_deferredTx"
	CONST_PROP_ID_ETHER_ERR_STATS_HIST_DEFERRED_TX_DELTA = "ether_ErrStatsHist_deferredTxDelta"
	CONST_PROP_ID_ETHER_ERR_STATS_HIST_DEFERRED_TX_DELTA_AVG = "ether_ErrStatsHist_deferredTxDeltaAvg"
	CONST_PROP_ID_ETHER_ERR_STATS_HIST_DEFERRED_TX_DELTA_MAX = "ether_ErrStatsHist_deferredTxDeltaMax"
	CONST_PROP_ID_ETHER_ERR_STATS_HIST_DEFERRED_TX_DELTA_MIN = "ether_ErrStatsHist_deferredTxDeltaMin"
	CONST_PROP_ID_ETHER_ERR_STATS_HIST_FCS = "ether_ErrStatsHist_fcs"
	CONST_PROP_ID_ETHER_ERR_STATS_HIST_FCS_DELTA = "ether_ErrStatsHist_fcsDelta"
	CONST_PROP_ID_ETHER_ERR_STATS_HIST_FCS_DELTA_AVG = "ether_ErrStatsHist_fcsDeltaAvg"
	CONST_PROP_ID_ETHER_ERR_STATS_HIST_FCS_DELTA_MAX = "ether_ErrStatsHist_fcsDeltaMax"
	CONST_PROP_ID_ETHER_ERR_STATS_HIST_FCS_DELTA_MIN = "ether_ErrStatsHist_fcsDeltaMin"
	CONST_PROP_ID_ETHER_ERR_STATS_HIST_ID = "ether_ErrStatsHist_id"
	CONST_PROP_ID_ETHER_ERR_STATS_HIST_INT_MAC_RX = "ether_ErrStatsHist_intMacRx"
	CONST_PROP_ID_ETHER_ERR_STATS_HIST_INT_MAC_RX_DELTA = "ether_ErrStatsHist_intMacRxDelta"
	CONST_PROP_ID_ETHER_ERR_STATS_HIST_INT_MAC_RX_DELTA_AVG = "ether_ErrStatsHist_intMacRxDeltaAvg"
	CONST_PROP_ID_ETHER_ERR_STATS_HIST_INT_MAC_RX_DELTA_MAX = "ether_ErrStatsHist_intMacRxDeltaMax"
	CONST_PROP_ID_ETHER_ERR_STATS_HIST_INT_MAC_RX_DELTA_MIN = "ether_ErrStatsHist_intMacRxDeltaMin"
	CONST_PROP_ID_ETHER_ERR_STATS_HIST_INT_MAC_TX = "ether_ErrStatsHist_intMacTx"
	CONST_PROP_ID_ETHER_ERR_STATS_HIST_INT_MAC_TX_DELTA = "ether_ErrStatsHist_intMacTxDelta"
	CONST_PROP_ID_ETHER_ERR_STATS_HIST_INT_MAC_TX_DELTA_AVG = "ether_ErrStatsHist_intMacTxDeltaAvg"
	CONST_PROP_ID_ETHER_ERR_STATS_HIST_INT_MAC_TX_DELTA_MAX = "ether_ErrStatsHist_intMacTxDeltaMax"
	CONST_PROP_ID_ETHER_ERR_STATS_HIST_INT_MAC_TX_DELTA_MIN = "ether_ErrStatsHist_intMacTxDeltaMin"
	CONST_PROP_ID_ETHER_ERR_STATS_HIST_MOST_RECENT = "ether_ErrStatsHist_mostRecent"
	CONST_PROP_ID_ETHER_ERR_STATS_HIST_OUT_DISCARD = "ether_ErrStatsHist_outDiscard"
	CONST_PROP_ID_ETHER_ERR_STATS_HIST_OUT_DISCARD_DELTA = "ether_ErrStatsHist_outDiscardDelta"
	CONST_PROP_ID_ETHER_ERR_STATS_HIST_OUT_DISCARD_DELTA_AVG = "ether_ErrStatsHist_outDiscardDeltaAvg"
	CONST_PROP_ID_ETHER_ERR_STATS_HIST_OUT_DISCARD_DELTA_MAX = "ether_ErrStatsHist_outDiscardDeltaMax"
	CONST_PROP_ID_ETHER_ERR_STATS_HIST_OUT_DISCARD_DELTA_MIN = "ether_ErrStatsHist_outDiscardDeltaMin"
	CONST_PROP_ID_ETHER_ERR_STATS_HIST_RCV = "ether_ErrStatsHist_rcv"
	CONST_PROP_ID_ETHER_ERR_STATS_HIST_RCV_DELTA = "ether_ErrStatsHist_rcvDelta"
	CONST_PROP_ID_ETHER_ERR_STATS_HIST_RCV_DELTA_AVG = "ether_ErrStatsHist_rcvDeltaAvg"
	CONST_PROP_ID_ETHER_ERR_STATS_HIST_RCV_DELTA_MAX = "ether_ErrStatsHist_rcvDeltaMax"
	CONST_PROP_ID_ETHER_ERR_STATS_HIST_RCV_DELTA_MIN = "ether_ErrStatsHist_rcvDeltaMin"
	CONST_PROP_ID_ETHER_ERR_STATS_HIST_SUSPECT = "ether_ErrStatsHist_suspect"
	CONST_PROP_ID_ETHER_ERR_STATS_HIST_THRESHOLDED = "ether_ErrStatsHist_thresholded"
	CONST_PROP_ID_ETHER_ERR_STATS_HIST_TIME_COLLECTED = "ether_ErrStatsHist_timeCollected"
	CONST_PROP_ID_ETHER_ERR_STATS_HIST_UNDER_SIZE = "ether_ErrStatsHist_underSize"
	CONST_PROP_ID_ETHER_ERR_STATS_HIST_UNDER_SIZE_DELTA = "ether_ErrStatsHist_underSizeDelta"
	CONST_PROP_ID_ETHER_ERR_STATS_HIST_UNDER_SIZE_DELTA_AVG = "ether_ErrStatsHist_underSizeDeltaAvg"
	CONST_PROP_ID_ETHER_ERR_STATS_HIST_UNDER_SIZE_DELTA_MAX = "ether_ErrStatsHist_underSizeDeltaMax"
	CONST_PROP_ID_ETHER_ERR_STATS_HIST_UNDER_SIZE_DELTA_MIN = "ether_ErrStatsHist_underSizeDeltaMin"
	CONST_PROP_ID_ETHER_ERR_STATS_HIST_XMIT = "ether_ErrStatsHist_xmit"
	CONST_PROP_ID_ETHER_ERR_STATS_HIST_XMIT_DELTA = "ether_ErrStatsHist_xmitDelta"
	CONST_PROP_ID_ETHER_ERR_STATS_HIST_XMIT_DELTA_AVG = "ether_ErrStatsHist_xmitDeltaAvg"
	CONST_PROP_ID_ETHER_ERR_STATS_HIST_XMIT_DELTA_MAX = "ether_ErrStatsHist_xmitDeltaMax"
	CONST_PROP_ID_ETHER_ERR_STATS_HIST_XMIT_DELTA_MIN = "ether_ErrStatsHist_xmitDeltaMin"
	CONST_PROP_ID_ETHER_ERR_STATS_ALIGN = "ether_ErrStats_align"
	CONST_PROP_ID_ETHER_ERR_STATS_ALIGN_DELTA = "ether_ErrStats_alignDelta"
	CONST_PROP_ID_ETHER_ERR_STATS_ALIGN_DELTA_AVG = "ether_ErrStats_alignDeltaAvg"
	CONST_PROP_ID_ETHER_ERR_STATS_ALIGN_DELTA_MAX = "ether_ErrStats_alignDeltaMax"
	CONST_PROP_ID_ETHER_ERR_STATS_ALIGN_DELTA_MIN = "ether_ErrStats_alignDeltaMin"
	CONST_PROP_ID_ETHER_ERR_STATS_DEFERRED_TX = "ether_ErrStats_deferredTx"
	CONST_PROP_ID_ETHER_ERR_STATS_DEFERRED_TX_DELTA = "ether_ErrStats_deferredTxDelta"
	CONST_PROP_ID_ETHER_ERR_STATS_DEFERRED_TX_DELTA_AVG = "ether_ErrStats_deferredTxDeltaAvg"
	CONST_PROP_ID_ETHER_ERR_STATS_DEFERRED_TX_DELTA_MAX = "ether_ErrStats_deferredTxDeltaMax"
	CONST_PROP_ID_ETHER_ERR_STATS_DEFERRED_TX_DELTA_MIN = "ether_ErrStats_deferredTxDeltaMin"
	CONST_PROP_ID_ETHER_ERR_STATS_FCS = "ether_ErrStats_fcs"
	CONST_PROP_ID_ETHER_ERR_STATS_FCS_DELTA = "ether_ErrStats_fcsDelta"
	CONST_PROP_ID_ETHER_ERR_STATS_FCS_DELTA_AVG = "ether_ErrStats_fcsDeltaAvg"
	CONST_PROP_ID_ETHER_ERR_STATS_FCS_DELTA_MAX = "ether_ErrStats_fcsDeltaMax"
	CONST_PROP_ID_ETHER_ERR_STATS_FCS_DELTA_MIN = "ether_ErrStats_fcsDeltaMin"
	CONST_PROP_ID_ETHER_ERR_STATS_INT_MAC_RX = "ether_ErrStats_intMacRx"
	CONST_PROP_ID_ETHER_ERR_STATS_INT_MAC_RX_DELTA = "ether_ErrStats_intMacRxDelta"
	CONST_PROP_ID_ETHER_ERR_STATS_INT_MAC_RX_DELTA_AVG = "ether_ErrStats_intMacRxDeltaAvg"
	CONST_PROP_ID_ETHER_ERR_STATS_INT_MAC_RX_DELTA_MAX = "ether_ErrStats_intMacRxDeltaMax"
	CONST_PROP_ID_ETHER_ERR_STATS_INT_MAC_RX_DELTA_MIN = "ether_ErrStats_intMacRxDeltaMin"
	CONST_PROP_ID_ETHER_ERR_STATS_INT_MAC_TX = "ether_ErrStats_intMacTx"
	CONST_PROP_ID_ETHER_ERR_STATS_INT_MAC_TX_DELTA = "ether_ErrStats_intMacTxDelta"
	CONST_PROP_ID_ETHER_ERR_STATS_INT_MAC_TX_DELTA_AVG = "ether_ErrStats_intMacTxDeltaAvg"
	CONST_PROP_ID_ETHER_ERR_STATS_INT_MAC_TX_DELTA_MAX = "ether_ErrStats_intMacTxDeltaMax"
	CONST_PROP_ID_ETHER_ERR_STATS_INT_MAC_TX_DELTA_MIN = "ether_ErrStats_intMacTxDeltaMin"
	CONST_PROP_ID_ETHER_ERR_STATS_INTERVALS = "ether_ErrStats_intervals"
	CONST_PROP_ID_ETHER_ERR_STATS_OUT_DISCARD = "ether_ErrStats_outDiscard"
	CONST_PROP_ID_ETHER_ERR_STATS_OUT_DISCARD_DELTA = "ether_ErrStats_outDiscardDelta"
	CONST_PROP_ID_ETHER_ERR_STATS_OUT_DISCARD_DELTA_AVG = "ether_ErrStats_outDiscardDeltaAvg"
	CONST_PROP_ID_ETHER_ERR_STATS_OUT_DISCARD_DELTA_MAX = "ether_ErrStats_outDiscardDeltaMax"
	CONST_PROP_ID_ETHER_ERR_STATS_OUT_DISCARD_DELTA_MIN = "ether_ErrStats_outDiscardDeltaMin"
	CONST_PROP_ID_ETHER_ERR_STATS_RCV = "ether_ErrStats_rcv"
	CONST_PROP_ID_ETHER_ERR_STATS_RCV_DELTA = "ether_ErrStats_rcvDelta"
	CONST_PROP_ID_ETHER_ERR_STATS_RCV_DELTA_AVG = "ether_ErrStats_rcvDeltaAvg"
	CONST_PROP_ID_ETHER_ERR_STATS_RCV_DELTA_MAX = "ether_ErrStats_rcvDeltaMax"
	CONST_PROP_ID_ETHER_ERR_STATS_RCV_DELTA_MIN = "ether_ErrStats_rcvDeltaMin"
	CONST_PROP_ID_ETHER_ERR_STATS_SUSPECT = "ether_ErrStats_suspect"
	CONST_PROP_ID_ETHER_ERR_STATS_THRESHOLDED = "ether_ErrStats_thresholded"
	CONST_PROP_ID_ETHER_ERR_STATS_TIME_COLLECTED = "ether_ErrStats_timeCollected"
	CONST_PROP_ID_ETHER_ERR_STATS_UNDER_SIZE = "ether_ErrStats_underSize"
	CONST_PROP_ID_ETHER_ERR_STATS_UNDER_SIZE_DELTA = "ether_ErrStats_underSizeDelta"
	CONST_PROP_ID_ETHER_ERR_STATS_UNDER_SIZE_DELTA_AVG = "ether_ErrStats_underSizeDeltaAvg"
	CONST_PROP_ID_ETHER_ERR_STATS_UNDER_SIZE_DELTA_MAX = "ether_ErrStats_underSizeDeltaMax"
	CONST_PROP_ID_ETHER_ERR_STATS_UNDER_SIZE_DELTA_MIN = "ether_ErrStats_underSizeDeltaMin"
	CONST_PROP_ID_ETHER_ERR_STATS_UPDATE = "ether_ErrStats_update"
	CONST_PROP_ID_ETHER_ERR_STATS_XMIT = "ether_ErrStats_xmit"
	CONST_PROP_ID_ETHER_ERR_STATS_XMIT_DELTA = "ether_ErrStats_xmitDelta"
	CONST_PROP_ID_ETHER_ERR_STATS_XMIT_DELTA_AVG = "ether_ErrStats_xmitDeltaAvg"
	CONST_PROP_ID_ETHER_ERR_STATS_XMIT_DELTA_MAX = "ether_ErrStats_xmitDeltaMax"
	CONST_PROP_ID_ETHER_ERR_STATS_XMIT_DELTA_MIN = "ether_ErrStats_xmitDeltaMin"
	CONST_PROP_ID_ETHER_EXTERNAL_EP_ADMIN_STATE = "ether_ExternalEp_adminState"
	CONST_PROP_ID_ETHER_EXTERNAL_EP_CHASSIS_ID = "ether_ExternalEp_chassisId"
	CONST_PROP_ID_ETHER_EXTERNAL_EP_EP_DN = "ether_ExternalEp_epDn"
	CONST_PROP_ID_ETHER_EXTERNAL_EP_IF_ROLE = "ether_ExternalEp_ifRole"
	CONST_PROP_ID_ETHER_EXTERNAL_EP_IF_TYPE = "ether_ExternalEp_ifType"
	CONST_PROP_ID_ETHER_EXTERNAL_EP_LOCALE = "ether_ExternalEp_locale"
	CONST_PROP_ID_ETHER_EXTERNAL_EP_NAME = "ether_ExternalEp_name"
	CONST_PROP_ID_ETHER_EXTERNAL_EP_PEER_CHASSIS_ID = "ether_ExternalEp_peerChassisId"
	CONST_PROP_ID_ETHER_EXTERNAL_EP_PEER_DN = "ether_ExternalEp_peerDn"
	CONST_PROP_ID_ETHER_EXTERNAL_EP_PEER_PORT_ID = "ether_ExternalEp_peerPortId"
	CONST_PROP_ID_ETHER_EXTERNAL_EP_PEER_SLOT_ID = "ether_ExternalEp_peerSlotId"
	CONST_PROP_ID_ETHER_EXTERNAL_EP_PORT_ID = "ether_ExternalEp_portId"
	CONST_PROP_ID_ETHER_EXTERNAL_EP_SLOT_ID = "ether_ExternalEp_slotId"
	CONST_PROP_ID_ETHER_EXTERNAL_EP_SWITCH_ID = "ether_ExternalEp_switchId"
	CONST_PROP_ID_ETHER_EXTERNAL_EP_TRANSPORT = "ether_ExternalEp_transport"
	CONST_PROP_ID_ETHER_EXTERNAL_EP_TYPE = "ether_ExternalEp_type"
	CONST_PROP_ID_ETHER_EXTERNAL_PC_ADMIN_STATE = "ether_ExternalPc_adminState"
	CONST_PROP_ID_ETHER_EXTERNAL_PC_EP_DN = "ether_ExternalPc_epDn"
	CONST_PROP_ID_ETHER_EXTERNAL_PC_FLT_AGGR = "ether_ExternalPc_fltAggr"
	CONST_PROP_ID_ETHER_EXTERNAL_PC_IF_ROLE = "ether_ExternalPc_ifRole"
	CONST_PROP_ID_ETHER_EXTERNAL_PC_IF_TYPE = "ether_ExternalPc_ifType"
	CONST_PROP_ID_ETHER_EXTERNAL_PC_LOCALE = "ether_ExternalPc_locale"
	CONST_PROP_ID_ETHER_EXTERNAL_PC_NAME = "ether_ExternalPc_name"
	CONST_PROP_ID_ETHER_EXTERNAL_PC_OPER_STATE = "ether_ExternalPc_operState"
	CONST_PROP_ID_ETHER_EXTERNAL_PC_PEER_DN = "ether_ExternalPc_peerDn"
	CONST_PROP_ID_ETHER_EXTERNAL_PC_PORT_ID = "ether_ExternalPc_portId"
	CONST_PROP_ID_ETHER_EXTERNAL_PC_STATE_QUAL = "ether_ExternalPc_stateQual"
	CONST_PROP_ID_ETHER_EXTERNAL_PC_SWITCH_ID = "ether_ExternalPc_switchId"
	CONST_PROP_ID_ETHER_EXTERNAL_PC_TRANSPORT = "ether_ExternalPc_transport"
	CONST_PROP_ID_ETHER_EXTERNAL_PC_TYPE = "ether_ExternalPc_type"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_HIST_BYTES_RX = "ether_FcoeInterfaceStatsHist_bytesRx"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_HIST_BYTES_RX_DELTA = "ether_FcoeInterfaceStatsHist_bytesRxDelta"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_HIST_BYTES_RX_DELTA_AVG = "ether_FcoeInterfaceStatsHist_bytesRxDeltaAvg"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_HIST_BYTES_RX_DELTA_MAX = "ether_FcoeInterfaceStatsHist_bytesRxDeltaMax"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_HIST_BYTES_RX_DELTA_MIN = "ether_FcoeInterfaceStatsHist_bytesRxDeltaMin"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_HIST_BYTES_TX = "ether_FcoeInterfaceStatsHist_bytesTx"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_HIST_BYTES_TX_DELTA = "ether_FcoeInterfaceStatsHist_bytesTxDelta"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_HIST_BYTES_TX_DELTA_AVG = "ether_FcoeInterfaceStatsHist_bytesTxDeltaAvg"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_HIST_BYTES_TX_DELTA_MAX = "ether_FcoeInterfaceStatsHist_bytesTxDeltaMax"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_HIST_BYTES_TX_DELTA_MIN = "ether_FcoeInterfaceStatsHist_bytesTxDeltaMin"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_HIST_DROPPED_RX = "ether_FcoeInterfaceStatsHist_droppedRx"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_HIST_DROPPED_RX_DELTA = "ether_FcoeInterfaceStatsHist_droppedRxDelta"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_HIST_DROPPED_RX_DELTA_AVG = "ether_FcoeInterfaceStatsHist_droppedRxDeltaAvg"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_HIST_DROPPED_RX_DELTA_MAX = "ether_FcoeInterfaceStatsHist_droppedRxDeltaMax"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_HIST_DROPPED_RX_DELTA_MIN = "ether_FcoeInterfaceStatsHist_droppedRxDeltaMin"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_HIST_DROPPED_TX = "ether_FcoeInterfaceStatsHist_droppedTx"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_HIST_DROPPED_TX_DELTA = "ether_FcoeInterfaceStatsHist_droppedTxDelta"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_HIST_DROPPED_TX_DELTA_AVG = "ether_FcoeInterfaceStatsHist_droppedTxDeltaAvg"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_HIST_DROPPED_TX_DELTA_MAX = "ether_FcoeInterfaceStatsHist_droppedTxDeltaMax"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_HIST_DROPPED_TX_DELTA_MIN = "ether_FcoeInterfaceStatsHist_droppedTxDeltaMin"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_HIST_ERRORS_RX = "ether_FcoeInterfaceStatsHist_errorsRx"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_HIST_ERRORS_RX_DELTA = "ether_FcoeInterfaceStatsHist_errorsRxDelta"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_HIST_ERRORS_RX_DELTA_AVG = "ether_FcoeInterfaceStatsHist_errorsRxDeltaAvg"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_HIST_ERRORS_RX_DELTA_MAX = "ether_FcoeInterfaceStatsHist_errorsRxDeltaMax"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_HIST_ERRORS_RX_DELTA_MIN = "ether_FcoeInterfaceStatsHist_errorsRxDeltaMin"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_HIST_ERRORS_TX = "ether_FcoeInterfaceStatsHist_errorsTx"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_HIST_ERRORS_TX_DELTA = "ether_FcoeInterfaceStatsHist_errorsTxDelta"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_HIST_ERRORS_TX_DELTA_AVG = "ether_FcoeInterfaceStatsHist_errorsTxDeltaAvg"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_HIST_ERRORS_TX_DELTA_MAX = "ether_FcoeInterfaceStatsHist_errorsTxDeltaMax"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_HIST_ERRORS_TX_DELTA_MIN = "ether_FcoeInterfaceStatsHist_errorsTxDeltaMin"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_HIST_ID = "ether_FcoeInterfaceStatsHist_id"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_HIST_MOST_RECENT = "ether_FcoeInterfaceStatsHist_mostRecent"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_HIST_PACKETS_RX = "ether_FcoeInterfaceStatsHist_packetsRx"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_HIST_PACKETS_RX_DELTA = "ether_FcoeInterfaceStatsHist_packetsRxDelta"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_HIST_PACKETS_RX_DELTA_AVG = "ether_FcoeInterfaceStatsHist_packetsRxDeltaAvg"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_HIST_PACKETS_RX_DELTA_MAX = "ether_FcoeInterfaceStatsHist_packetsRxDeltaMax"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_HIST_PACKETS_RX_DELTA_MIN = "ether_FcoeInterfaceStatsHist_packetsRxDeltaMin"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_HIST_PACKETS_TX = "ether_FcoeInterfaceStatsHist_packetsTx"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_HIST_PACKETS_TX_DELTA = "ether_FcoeInterfaceStatsHist_packetsTxDelta"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_HIST_PACKETS_TX_DELTA_AVG = "ether_FcoeInterfaceStatsHist_packetsTxDeltaAvg"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_HIST_PACKETS_TX_DELTA_MAX = "ether_FcoeInterfaceStatsHist_packetsTxDeltaMax"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_HIST_PACKETS_TX_DELTA_MIN = "ether_FcoeInterfaceStatsHist_packetsTxDeltaMin"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_HIST_SUSPECT = "ether_FcoeInterfaceStatsHist_suspect"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_HIST_THRESHOLDED = "ether_FcoeInterfaceStatsHist_thresholded"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_HIST_TIME_COLLECTED = "ether_FcoeInterfaceStatsHist_timeCollected"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_BYTES_RX = "ether_FcoeInterfaceStats_bytesRx"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_BYTES_RX_DELTA = "ether_FcoeInterfaceStats_bytesRxDelta"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_BYTES_RX_DELTA_AVG = "ether_FcoeInterfaceStats_bytesRxDeltaAvg"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_BYTES_RX_DELTA_MAX = "ether_FcoeInterfaceStats_bytesRxDeltaMax"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_BYTES_RX_DELTA_MIN = "ether_FcoeInterfaceStats_bytesRxDeltaMin"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_BYTES_TX = "ether_FcoeInterfaceStats_bytesTx"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_BYTES_TX_DELTA = "ether_FcoeInterfaceStats_bytesTxDelta"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_BYTES_TX_DELTA_AVG = "ether_FcoeInterfaceStats_bytesTxDeltaAvg"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_BYTES_TX_DELTA_MAX = "ether_FcoeInterfaceStats_bytesTxDeltaMax"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_BYTES_TX_DELTA_MIN = "ether_FcoeInterfaceStats_bytesTxDeltaMin"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_DROPPED_RX = "ether_FcoeInterfaceStats_droppedRx"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_DROPPED_RX_DELTA = "ether_FcoeInterfaceStats_droppedRxDelta"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_DROPPED_RX_DELTA_AVG = "ether_FcoeInterfaceStats_droppedRxDeltaAvg"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_DROPPED_RX_DELTA_MAX = "ether_FcoeInterfaceStats_droppedRxDeltaMax"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_DROPPED_RX_DELTA_MIN = "ether_FcoeInterfaceStats_droppedRxDeltaMin"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_DROPPED_TX = "ether_FcoeInterfaceStats_droppedTx"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_DROPPED_TX_DELTA = "ether_FcoeInterfaceStats_droppedTxDelta"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_DROPPED_TX_DELTA_AVG = "ether_FcoeInterfaceStats_droppedTxDeltaAvg"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_DROPPED_TX_DELTA_MAX = "ether_FcoeInterfaceStats_droppedTxDeltaMax"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_DROPPED_TX_DELTA_MIN = "ether_FcoeInterfaceStats_droppedTxDeltaMin"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_ERRORS_RX = "ether_FcoeInterfaceStats_errorsRx"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_ERRORS_RX_DELTA = "ether_FcoeInterfaceStats_errorsRxDelta"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_ERRORS_RX_DELTA_AVG = "ether_FcoeInterfaceStats_errorsRxDeltaAvg"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_ERRORS_RX_DELTA_MAX = "ether_FcoeInterfaceStats_errorsRxDeltaMax"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_ERRORS_RX_DELTA_MIN = "ether_FcoeInterfaceStats_errorsRxDeltaMin"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_ERRORS_TX = "ether_FcoeInterfaceStats_errorsTx"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_ERRORS_TX_DELTA = "ether_FcoeInterfaceStats_errorsTxDelta"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_ERRORS_TX_DELTA_AVG = "ether_FcoeInterfaceStats_errorsTxDeltaAvg"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_ERRORS_TX_DELTA_MAX = "ether_FcoeInterfaceStats_errorsTxDeltaMax"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_ERRORS_TX_DELTA_MIN = "ether_FcoeInterfaceStats_errorsTxDeltaMin"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_INTERVALS = "ether_FcoeInterfaceStats_intervals"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_PACKETS_RX = "ether_FcoeInterfaceStats_packetsRx"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_PACKETS_RX_DELTA = "ether_FcoeInterfaceStats_packetsRxDelta"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_PACKETS_RX_DELTA_AVG = "ether_FcoeInterfaceStats_packetsRxDeltaAvg"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_PACKETS_RX_DELTA_MAX = "ether_FcoeInterfaceStats_packetsRxDeltaMax"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_PACKETS_RX_DELTA_MIN = "ether_FcoeInterfaceStats_packetsRxDeltaMin"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_PACKETS_TX = "ether_FcoeInterfaceStats_packetsTx"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_PACKETS_TX_DELTA = "ether_FcoeInterfaceStats_packetsTxDelta"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_PACKETS_TX_DELTA_AVG = "ether_FcoeInterfaceStats_packetsTxDeltaAvg"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_PACKETS_TX_DELTA_MAX = "ether_FcoeInterfaceStats_packetsTxDeltaMax"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_PACKETS_TX_DELTA_MIN = "ether_FcoeInterfaceStats_packetsTxDeltaMin"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_SUSPECT = "ether_FcoeInterfaceStats_suspect"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_THRESHOLDED = "ether_FcoeInterfaceStats_thresholded"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_TIME_COLLECTED = "ether_FcoeInterfaceStats_timeCollected"
	CONST_PROP_ID_ETHER_FCOE_INTERFACE_STATS_UPDATE = "ether_FcoeInterfaceStats_update"
	CONST_PROP_ID_ETHER_INT_FIO_EP_ADMIN_STATE = "ether_IntFIoEp_adminState"
	CONST_PROP_ID_ETHER_INT_FIO_EP_CHASSIS_ID = "ether_IntFIoEp_chassisId"
	CONST_PROP_ID_ETHER_INT_FIO_EP_EP_DN = "ether_IntFIoEp_epDn"
	CONST_PROP_ID_ETHER_INT_FIO_EP_IF_ROLE = "ether_IntFIoEp_ifRole"
	CONST_PROP_ID_ETHER_INT_FIO_EP_IF_TYPE = "ether_IntFIoEp_ifType"
	CONST_PROP_ID_ETHER_INT_FIO_EP_LOCALE = "ether_IntFIoEp_locale"
	CONST_PROP_ID_ETHER_INT_FIO_EP_NAME = "ether_IntFIoEp_name"
	CONST_PROP_ID_ETHER_INT_FIO_EP_PEER_CHASSIS_ID = "ether_IntFIoEp_peerChassisId"
	CONST_PROP_ID_ETHER_INT_FIO_EP_PEER_DN = "ether_IntFIoEp_peerDn"
	CONST_PROP_ID_ETHER_INT_FIO_EP_PEER_PORT_ID = "ether_IntFIoEp_peerPortId"
	CONST_PROP_ID_ETHER_INT_FIO_EP_PEER_SLOT_ID = "ether_IntFIoEp_peerSlotId"
	CONST_PROP_ID_ETHER_INT_FIO_EP_PORT_ID = "ether_IntFIoEp_portId"
	CONST_PROP_ID_ETHER_INT_FIO_EP_SLOT_ID = "ether_IntFIoEp_slotId"
	CONST_PROP_ID_ETHER_INT_FIO_EP_SWITCH_ID = "ether_IntFIoEp_switchId"
	CONST_PROP_ID_ETHER_INT_FIO_EP_TRANSPORT = "ether_IntFIoEp_transport"
	CONST_PROP_ID_ETHER_INT_FIO_EP_TYPE = "ether_IntFIoEp_type"
	CONST_PROP_ID_ETHER_INTERNAL_PC_EP_DN = "ether_InternalPc_epDn"
	CONST_PROP_ID_ETHER_INTERNAL_PC_FLT_AGGR = "ether_InternalPc_fltAggr"
	CONST_PROP_ID_ETHER_INTERNAL_PC_IF_ROLE = "ether_InternalPc_ifRole"
	CONST_PROP_ID_ETHER_INTERNAL_PC_IF_TYPE = "ether_InternalPc_ifType"
	CONST_PROP_ID_ETHER_INTERNAL_PC_LOCALE = "ether_InternalPc_locale"
	CONST_PROP_ID_ETHER_INTERNAL_PC_NAME = "ether_InternalPc_name"
	CONST_PROP_ID_ETHER_INTERNAL_PC_OPER_STATE = "ether_InternalPc_operState"
	CONST_PROP_ID_ETHER_INTERNAL_PC_PEER_DN = "ether_InternalPc_peerDn"
	CONST_PROP_ID_ETHER_INTERNAL_PC_PORT_ID = "ether_InternalPc_portId"
	CONST_PROP_ID_ETHER_INTERNAL_PC_STATE_QUAL = "ether_InternalPc_stateQual"
	CONST_PROP_ID_ETHER_INTERNAL_PC_SWITCH_ID = "ether_InternalPc_switchId"
	CONST_PROP_ID_ETHER_INTERNAL_PC_TRANSPORT = "ether_InternalPc_transport"
	CONST_PROP_ID_ETHER_INTERNAL_PC_TYPE = "ether_InternalPc_type"
	CONST_PROP_ID_ETHER_LOSS_STATS_HIST_SQETEST = "ether_LossStatsHist_SQETest"
	CONST_PROP_ID_ETHER_LOSS_STATS_HIST_SQETEST_DELTA = "ether_LossStatsHist_SQETestDelta"
	CONST_PROP_ID_ETHER_LOSS_STATS_HIST_SQETEST_DELTA_AVG = "ether_LossStatsHist_SQETestDeltaAvg"
	CONST_PROP_ID_ETHER_LOSS_STATS_HIST_SQETEST_DELTA_MAX = "ether_LossStatsHist_SQETestDeltaMax"
	CONST_PROP_ID_ETHER_LOSS_STATS_HIST_SQETEST_DELTA_MIN = "ether_LossStatsHist_SQETestDeltaMin"
	CONST_PROP_ID_ETHER_LOSS_STATS_HIST_CARRIER_SENSE = "ether_LossStatsHist_carrierSense"
	CONST_PROP_ID_ETHER_LOSS_STATS_HIST_CARRIER_SENSE_DELTA = "ether_LossStatsHist_carrierSenseDelta"
	CONST_PROP_ID_ETHER_LOSS_STATS_HIST_CARRIER_SENSE_DELTA_AVG = "ether_LossStatsHist_carrierSenseDeltaAvg"
	CONST_PROP_ID_ETHER_LOSS_STATS_HIST_CARRIER_SENSE_DELTA_MAX = "ether_LossStatsHist_carrierSenseDeltaMax"
	CONST_PROP_ID_ETHER_LOSS_STATS_HIST_CARRIER_SENSE_DELTA_MIN = "ether_LossStatsHist_carrierSenseDeltaMin"
	CONST_PROP_ID_ETHER_LOSS_STATS_HIST_EXCESS_COLLISION = "ether_LossStatsHist_excessCollision"
	CONST_PROP_ID_ETHER_LOSS_STATS_HIST_EXCESS_COLLISION_DELTA = "ether_LossStatsHist_excessCollisionDelta"
	CONST_PROP_ID_ETHER_LOSS_STATS_HIST_EXCESS_COLLISION_DELTA_AVG = "ether_LossStatsHist_excessCollisionDeltaAvg"
	CONST_PROP_ID_ETHER_LOSS_STATS_HIST_EXCESS_COLLISION_DELTA_MAX = "ether_LossStatsHist_excessCollisionDeltaMax"
	CONST_PROP_ID_ETHER_LOSS_STATS_HIST_EXCESS_COLLISION_DELTA_MIN = "ether_LossStatsHist_excessCollisionDeltaMin"
	CONST_PROP_ID_ETHER_LOSS_STATS_HIST_GIANTS = "ether_LossStatsHist_giants"
	CONST_PROP_ID_ETHER_LOSS_STATS_HIST_GIANTS_DELTA = "ether_LossStatsHist_giantsDelta"
	CONST_PROP_ID_ETHER_LOSS_STATS_HIST_GIANTS_DELTA_AVG = "ether_LossStatsHist_giantsDeltaAvg"
	CONST_PROP_ID_ETHER_LOSS_STATS_HIST_GIANTS_DELTA_MAX = "ether_LossStatsHist_giantsDeltaMax"
	CONST_PROP_ID_ETHER_LOSS_STATS_HIST_GIANTS_DELTA_MIN = "ether_LossStatsHist_giantsDeltaMin"
	CONST_PROP_ID_ETHER_LOSS_STATS_HIST_ID = "ether_LossStatsHist_id"
	CONST_PROP_ID_ETHER_LOSS_STATS_HIST_LATE_COLLISION = "ether_LossStatsHist_lateCollision"
	CONST_PROP_ID_ETHER_LOSS_STATS_HIST_LATE_COLLISION_DELTA = "ether_LossStatsHist_lateCollisionDelta"
	CONST_PROP_ID_ETHER_LOSS_STATS_HIST_LATE_COLLISION_DELTA_AVG = "ether_LossStatsHist_lateCollisionDeltaAvg"
	CONST_PROP_ID_ETHER_LOSS_STATS_HIST_LATE_COLLISION_DELTA_MAX = "ether_LossStatsHist_lateCollisionDeltaMax"
	CONST_PROP_ID_ETHER_LOSS_STATS_HIST_LATE_COLLISION_DELTA_MIN = "ether_LossStatsHist_lateCollisionDeltaMin"
	CONST_PROP_ID_ETHER_LOSS_STATS_HIST_MOST_RECENT = "ether_LossStatsHist_mostRecent"
	CONST_PROP_ID_ETHER_LOSS_STATS_HIST_MULTI_COLLISION = "ether_LossStatsHist_multiCollision"
	CONST_PROP_ID_ETHER_LOSS_STATS_HIST_MULTI_COLLISION_DELTA = "ether_LossStatsHist_multiCollisionDelta"
	CONST_PROP_ID_ETHER_LOSS_STATS_HIST_MULTI_COLLISION_DELTA_AVG = "ether_LossStatsHist_multiCollisionDeltaAvg"
	CONST_PROP_ID_ETHER_LOSS_STATS_HIST_MULTI_COLLISION_DELTA_MAX = "ether_LossStatsHist_multiCollisionDeltaMax"
	CONST_PROP_ID_ETHER_LOSS_STATS_HIST_MULTI_COLLISION_DELTA_MIN = "ether_LossStatsHist_multiCollisionDeltaMin"
	CONST_PROP_ID_ETHER_LOSS_STATS_HIST_SINGLE_COLLISION = "ether_LossStatsHist_singleCollision"
	CONST_PROP_ID_ETHER_LOSS_STATS_HIST_SINGLE_COLLISION_DELTA = "ether_LossStatsHist_singleCollisionDelta"
	CONST_PROP_ID_ETHER_LOSS_STATS_HIST_SINGLE_COLLISION_DELTA_AVG = "ether_LossStatsHist_singleCollisionDeltaAvg"
	CONST_PROP_ID_ETHER_LOSS_STATS_HIST_SINGLE_COLLISION_DELTA_MAX = "ether_LossStatsHist_singleCollisionDeltaMax"
	CONST_PROP_ID_ETHER_LOSS_STATS_HIST_SINGLE_COLLISION_DELTA_MIN = "ether_LossStatsHist_singleCollisionDeltaMin"
	CONST_PROP_ID_ETHER_LOSS_STATS_HIST_SUSPECT = "ether_LossStatsHist_suspect"
	CONST_PROP_ID_ETHER_LOSS_STATS_HIST_SYMBOL = "ether_LossStatsHist_symbol"
	CONST_PROP_ID_ETHER_LOSS_STATS_HIST_SYMBOL_DELTA = "ether_LossStatsHist_symbolDelta"
	CONST_PROP_ID_ETHER_LOSS_STATS_HIST_SYMBOL_DELTA_AVG = "ether_LossStatsHist_symbolDeltaAvg"
	CONST_PROP_ID_ETHER_LOSS_STATS_HIST_SYMBOL_DELTA_MAX = "ether_LossStatsHist_symbolDeltaMax"
	CONST_PROP_ID_ETHER_LOSS_STATS_HIST_SYMBOL_DELTA_MIN = "ether_LossStatsHist_symbolDeltaMin"
	CONST_PROP_ID_ETHER_LOSS_STATS_HIST_THRESHOLDED = "ether_LossStatsHist_thresholded"
	CONST_PROP_ID_ETHER_LOSS_STATS_HIST_TIME_COLLECTED = "ether_LossStatsHist_timeCollected"
	CONST_PROP_ID_ETHER_LOSS_STATS_SQETEST = "ether_LossStats_SQETest"
	CONST_PROP_ID_ETHER_LOSS_STATS_SQETEST_DELTA = "ether_LossStats_SQETestDelta"
	CONST_PROP_ID_ETHER_LOSS_STATS_SQETEST_DELTA_AVG = "ether_LossStats_SQETestDeltaAvg"
	CONST_PROP_ID_ETHER_LOSS_STATS_SQETEST_DELTA_MAX = "ether_LossStats_SQETestDeltaMax"
	CONST_PROP_ID_ETHER_LOSS_STATS_SQETEST_DELTA_MIN = "ether_LossStats_SQETestDeltaMin"
	CONST_PROP_ID_ETHER_LOSS_STATS_CARRIER_SENSE = "ether_LossStats_carrierSense"
	CONST_PROP_ID_ETHER_LOSS_STATS_CARRIER_SENSE_DELTA = "ether_LossStats_carrierSenseDelta"
	CONST_PROP_ID_ETHER_LOSS_STATS_CARRIER_SENSE_DELTA_AVG = "ether_LossStats_carrierSenseDeltaAvg"
	CONST_PROP_ID_ETHER_LOSS_STATS_CARRIER_SENSE_DELTA_MAX = "ether_LossStats_carrierSenseDeltaMax"
	CONST_PROP_ID_ETHER_LOSS_STATS_CARRIER_SENSE_DELTA_MIN = "ether_LossStats_carrierSenseDeltaMin"
	CONST_PROP_ID_ETHER_LOSS_STATS_EXCESS_COLLISION = "ether_LossStats_excessCollision"
	CONST_PROP_ID_ETHER_LOSS_STATS_EXCESS_COLLISION_DELTA = "ether_LossStats_excessCollisionDelta"
	CONST_PROP_ID_ETHER_LOSS_STATS_EXCESS_COLLISION_DELTA_AVG = "ether_LossStats_excessCollisionDeltaAvg"
	CONST_PROP_ID_ETHER_LOSS_STATS_EXCESS_COLLISION_DELTA_MAX = "ether_LossStats_excessCollisionDeltaMax"
	CONST_PROP_ID_ETHER_LOSS_STATS_EXCESS_COLLISION_DELTA_MIN = "ether_LossStats_excessCollisionDeltaMin"
	CONST_PROP_ID_ETHER_LOSS_STATS_GIANTS = "ether_LossStats_giants"
	CONST_PROP_ID_ETHER_LOSS_STATS_GIANTS_DELTA = "ether_LossStats_giantsDelta"
	CONST_PROP_ID_ETHER_LOSS_STATS_GIANTS_DELTA_AVG = "ether_LossStats_giantsDeltaAvg"
	CONST_PROP_ID_ETHER_LOSS_STATS_GIANTS_DELTA_MAX = "ether_LossStats_giantsDeltaMax"
	CONST_PROP_ID_ETHER_LOSS_STATS_GIANTS_DELTA_MIN = "ether_LossStats_giantsDeltaMin"
	CONST_PROP_ID_ETHER_LOSS_STATS_INTERVALS = "ether_LossStats_intervals"
	CONST_PROP_ID_ETHER_LOSS_STATS_LATE_COLLISION = "ether_LossStats_lateCollision"
	CONST_PROP_ID_ETHER_LOSS_STATS_LATE_COLLISION_DELTA = "ether_LossStats_lateCollisionDelta"
	CONST_PROP_ID_ETHER_LOSS_STATS_LATE_COLLISION_DELTA_AVG = "ether_LossStats_lateCollisionDeltaAvg"
	CONST_PROP_ID_ETHER_LOSS_STATS_LATE_COLLISION_DELTA_MAX = "ether_LossStats_lateCollisionDeltaMax"
	CONST_PROP_ID_ETHER_LOSS_STATS_LATE_COLLISION_DELTA_MIN = "ether_LossStats_lateCollisionDeltaMin"
	CONST_PROP_ID_ETHER_LOSS_STATS_MULTI_COLLISION = "ether_LossStats_multiCollision"
	CONST_PROP_ID_ETHER_LOSS_STATS_MULTI_COLLISION_DELTA = "ether_LossStats_multiCollisionDelta"
	CONST_PROP_ID_ETHER_LOSS_STATS_MULTI_COLLISION_DELTA_AVG = "ether_LossStats_multiCollisionDeltaAvg"
	CONST_PROP_ID_ETHER_LOSS_STATS_MULTI_COLLISION_DELTA_MAX = "ether_LossStats_multiCollisionDeltaMax"
	CONST_PROP_ID_ETHER_LOSS_STATS_MULTI_COLLISION_DELTA_MIN = "ether_LossStats_multiCollisionDeltaMin"
	CONST_PROP_ID_ETHER_LOSS_STATS_SINGLE_COLLISION = "ether_LossStats_singleCollision"
	CONST_PROP_ID_ETHER_LOSS_STATS_SINGLE_COLLISION_DELTA = "ether_LossStats_singleCollisionDelta"
	CONST_PROP_ID_ETHER_LOSS_STATS_SINGLE_COLLISION_DELTA_AVG = "ether_LossStats_singleCollisionDeltaAvg"
	CONST_PROP_ID_ETHER_LOSS_STATS_SINGLE_COLLISION_DELTA_MAX = "ether_LossStats_singleCollisionDeltaMax"
	CONST_PROP_ID_ETHER_LOSS_STATS_SINGLE_COLLISION_DELTA_MIN = "ether_LossStats_singleCollisionDeltaMin"
	CONST_PROP_ID_ETHER_LOSS_STATS_SUSPECT = "ether_LossStats_suspect"
	CONST_PROP_ID_ETHER_LOSS_STATS_SYMBOL = "ether_LossStats_symbol"
	CONST_PROP_ID_ETHER_LOSS_STATS_SYMBOL_DELTA = "ether_LossStats_symbolDelta"
	CONST_PROP_ID_ETHER_LOSS_STATS_SYMBOL_DELTA_AVG = "ether_LossStats_symbolDeltaAvg"
	CONST_PROP_ID_ETHER_LOSS_STATS_SYMBOL_DELTA_MAX = "ether_LossStats_symbolDeltaMax"
	CONST_PROP_ID_ETHER_LOSS_STATS_SYMBOL_DELTA_MIN = "ether_LossStats_symbolDeltaMin"
	CONST_PROP_ID_ETHER_LOSS_STATS_THRESHOLDED = "ether_LossStats_thresholded"
	CONST_PROP_ID_ETHER_LOSS_STATS_TIME_COLLECTED = "ether_LossStats_timeCollected"
	CONST_PROP_ID_ETHER_LOSS_STATS_UPDATE = "ether_LossStats_update"
	CONST_PROP_ID_ETHER_PIO_END_POINT_END_POINT_DN = "ether_PIoEndPoint_EndPointDn"
	CONST_PROP_ID_ETHER_PIO_END_POINT_EP_CLOUD_TYPE = "ether_PIoEndPoint_epCloudType"
	CONST_PROP_ID_ETHER_PIO_END_POINT_USR_LBL = "ether_PIoEndPoint_usrLbl"
	CONST_PROP_ID_ETHER_PIO_EP_CHASSIS_ID = "ether_PIoEp_chassisId"
	CONST_PROP_ID_ETHER_PIO_EP_EP_DN = "ether_PIoEp_epDn"
	CONST_PROP_ID_ETHER_PIO_EP_IF_ROLE = "ether_PIoEp_ifRole"
	CONST_PROP_ID_ETHER_PIO_EP_IF_TYPE = "ether_PIoEp_ifType"
	CONST_PROP_ID_ETHER_PIO_EP_LOCALE = "ether_PIoEp_locale"
	CONST_PROP_ID_ETHER_PIO_EP_NAME = "ether_PIoEp_name"
	CONST_PROP_ID_ETHER_PIO_EP_PEER_CHASSIS_ID = "ether_PIoEp_peerChassisId"
	CONST_PROP_ID_ETHER_PIO_EP_PEER_DN = "ether_PIoEp_peerDn"
	CONST_PROP_ID_ETHER_PIO_EP_PEER_PORT_ID = "ether_PIoEp_peerPortId"
	CONST_PROP_ID_ETHER_PIO_EP_PEER_SLOT_ID = "ether_PIoEp_peerSlotId"
	CONST_PROP_ID_ETHER_PIO_EP_PORT_ID = "ether_PIoEp_portId"
	CONST_PROP_ID_ETHER_PIO_EP_SLOT_ID = "ether_PIoEp_slotId"
	CONST_PROP_ID_ETHER_PIO_EP_SWITCH_ID = "ether_PIoEp_switchId"
	CONST_PROP_ID_ETHER_PIO_EP_TRANSPORT = "ether_PIoEp_transport"
	CONST_PROP_ID_ETHER_PIO_EP_TYPE = "ether_PIoEp_type"
	CONST_PROP_ID_ETHER_PIO_FSM_STAGE_DESCR = "ether_PIoFsmStage_descr"
	CONST_PROP_ID_ETHER_PIO_FSM_STAGE_LAST_UPDATE_TIME = "ether_PIoFsmStage_lastUpdateTime"
	CONST_PROP_ID_ETHER_PIO_FSM_STAGE_NAME = "ether_PIoFsmStage_name"
	CONST_PROP_ID_ETHER_PIO_FSM_STAGE_ORDER = "ether_PIoFsmStage_order"
	CONST_PROP_ID_ETHER_PIO_FSM_STAGE_RETRY = "ether_PIoFsmStage_retry"
	CONST_PROP_ID_ETHER_PIO_FSM_STAGE_STAGE_STATUS = "ether_PIoFsmStage_stageStatus"
	CONST_PROP_ID_ETHER_PIO_FSM_COMPLETION_TIME = "ether_PIoFsm_completionTime"
	CONST_PROP_ID_ETHER_PIO_FSM_CURRENT_FSM = "ether_PIoFsm_currentFsm"
	CONST_PROP_ID_ETHER_PIO_FSM_DESCR = "ether_PIoFsm_descr"
	CONST_PROP_ID_ETHER_PIO_FSM_FSM_STATUS = "ether_PIoFsm_fsmStatus"
	CONST_PROP_ID_ETHER_PIO_FSM_INSTANCE_ID = "ether_PIoFsm_instanceId"
	CONST_PROP_ID_ETHER_PIO_FSM_PROGRESS = "ether_PIoFsm_progress"
	CONST_PROP_ID_ETHER_PIO_FSM_RMT_ERR_CODE = "ether_PIoFsm_rmtErrCode"
	CONST_PROP_ID_ETHER_PIO_FSM_RMT_ERR_DESCR = "ether_PIoFsm_rmtErrDescr"
	CONST_PROP_ID_ETHER_PIO_FSM_RMT_RSLT = "ether_PIoFsm_rmtRslt"
	CONST_PROP_ID_ETHER_PIO_ADMIN_STATE = "ether_PIo_adminState"
	CONST_PROP_ID_ETHER_PIO_ADMIN_TRANSPORT = "ether_PIo_adminTransport"
	CONST_PROP_ID_ETHER_PIO_CHASSIS_ID = "ether_PIo_chassisId"
	CONST_PROP_ID_ETHER_PIO_ENCAP = "ether_PIo_encap"
	CONST_PROP_ID_ETHER_PIO_EP_DN = "ether_PIo_epDn"
	CONST_PROP_ID_ETHER_PIO_FSM_DESCR = "ether_PIo_fsmDescr"
	CONST_PROP_ID_ETHER_PIO_FSM_PREV = "ether_PIo_fsmPrev"
	CONST_PROP_ID_ETHER_PIO_FSM_PROGR = "ether_PIo_fsmProgr"
	CONST_PROP_ID_ETHER_PIO_FSM_RMT_INV_ERR_CODE = "ether_PIo_fsmRmtInvErrCode"
	CONST_PROP_ID_ETHER_PIO_FSM_RMT_INV_ERR_DESCR = "ether_PIo_fsmRmtInvErrDescr"
	CONST_PROP_ID_ETHER_PIO_FSM_RMT_INV_RSLT = "ether_PIo_fsmRmtInvRslt"
	CONST_PROP_ID_ETHER_PIO_FSM_STAGE_DESCR = "ether_PIo_fsmStageDescr"
	CONST_PROP_ID_ETHER_PIO_FSM_STAMP = "ether_PIo_fsmStamp"
	CONST_PROP_ID_ETHER_PIO_FSM_STATUS = "ether_PIo_fsmStatus"
	CONST_PROP_ID_ETHER_PIO_FSM_TRY = "ether_PIo_fsmTry"
	CONST_PROP_ID_ETHER_PIO_IF_ROLE = "ether_PIo_ifRole"
	CONST_PROP_ID_ETHER_PIO_IF_TYPE = "ether_PIo_ifType"
	CONST_PROP_ID_ETHER_PIO_IS_PORT_CHANNEL_MEMBER = "ether_PIo_isPortChannelMember"
	CONST_PROP_ID_ETHER_PIO_LC = "ether_PIo_lc"
	CONST_PROP_ID_ETHER_PIO_LIC_GP = "ether_PIo_licGP"
	CONST_PROP_ID_ETHER_PIO_LIC_STATE = "ether_PIo_licState"
	CONST_PROP_ID_ETHER_PIO_LOCALE = "ether_PIo_locale"
	CONST_PROP_ID_ETHER_PIO_MAC = "ether_PIo_mac"
	CONST_PROP_ID_ETHER_PIO_MODE = "ether_PIo_mode"
	CONST_PROP_ID_ETHER_PIO_MODEL = "ether_PIo_model"
	CONST_PROP_ID_ETHER_PIO_NAME = "ether_PIo_name"
	CONST_PROP_ID_ETHER_PIO_OPER_SPEED = "ether_PIo_operSpeed"
	CONST_PROP_ID_ETHER_PIO_OPER_STATE = "ether_PIo_operState"
	CONST_PROP_ID_ETHER_PIO_PEER_CHASSIS_ID = "ether_PIo_peerChassisId"
	CONST_PROP_ID_ETHER_PIO_PEER_DN = "ether_PIo_peerDn"
	CONST_PROP_ID_ETHER_PIO_PEER_PORT_ID = "ether_PIo_peerPortId"
	CONST_PROP_ID_ETHER_PIO_PEER_SLOT_ID = "ether_PIo_peerSlotId"
	CONST_PROP_ID_ETHER_PIO_PORT_ID = "ether_PIo_portId"
	CONST_PROP_ID_ETHER_PIO_REVISION = "ether_PIo_revision"
	CONST_PROP_ID_ETHER_PIO_SERIAL = "ether_PIo_serial"
	CONST_PROP_ID_ETHER_PIO_SLOT_ID = "ether_PIo_slotId"
	CONST_PROP_ID_ETHER_PIO_STATE_QUAL = "ether_PIo_stateQual"
	CONST_PROP_ID_ETHER_PIO_SWITCH_ID = "ether_PIo_switchId"
	CONST_PROP_ID_ETHER_PIO_TRANSPORT = "ether_PIo_transport"
	CONST_PROP_ID_ETHER_PIO_TS = "ether_PIo_ts"
	CONST_PROP_ID_ETHER_PIO_TYPE = "ether_PIo_type"
	CONST_PROP_ID_ETHER_PIO_UNIFIED_PORT = "ether_PIo_unifiedPort"
	CONST_PROP_ID_ETHER_PIO_USR_LBL = "ether_PIo_usrLbl"
	CONST_PROP_ID_ETHER_PIO_VENDOR = "ether_PIo_vendor"
	CONST_PROP_ID_ETHER_PIO_XCVR_TYPE = "ether_PIo_xcvrType"
	CONST_PROP_ID_ETHER_PAUSE_STATS_HIST_ID = "ether_PauseStatsHist_id"
	CONST_PROP_ID_ETHER_PAUSE_STATS_HIST_MOST_RECENT = "ether_PauseStatsHist_mostRecent"
	CONST_PROP_ID_ETHER_PAUSE_STATS_HIST_RECV_PAUSE = "ether_PauseStatsHist_recvPause"
	CONST_PROP_ID_ETHER_PAUSE_STATS_HIST_RECV_PAUSE_DELTA = "ether_PauseStatsHist_recvPauseDelta"
	CONST_PROP_ID_ETHER_PAUSE_STATS_HIST_RECV_PAUSE_DELTA_AVG = "ether_PauseStatsHist_recvPauseDeltaAvg"
	CONST_PROP_ID_ETHER_PAUSE_STATS_HIST_RECV_PAUSE_DELTA_MAX = "ether_PauseStatsHist_recvPauseDeltaMax"
	CONST_PROP_ID_ETHER_PAUSE_STATS_HIST_RECV_PAUSE_DELTA_MIN = "ether_PauseStatsHist_recvPauseDeltaMin"
	CONST_PROP_ID_ETHER_PAUSE_STATS_HIST_RESETS = "ether_PauseStatsHist_resets"
	CONST_PROP_ID_ETHER_PAUSE_STATS_HIST_RESETS_DELTA = "ether_PauseStatsHist_resetsDelta"
	CONST_PROP_ID_ETHER_PAUSE_STATS_HIST_RESETS_DELTA_AVG = "ether_PauseStatsHist_resetsDeltaAvg"
	CONST_PROP_ID_ETHER_PAUSE_STATS_HIST_RESETS_DELTA_MAX = "ether_PauseStatsHist_resetsDeltaMax"
	CONST_PROP_ID_ETHER_PAUSE_STATS_HIST_RESETS_DELTA_MIN = "ether_PauseStatsHist_resetsDeltaMin"
	CONST_PROP_ID_ETHER_PAUSE_STATS_HIST_SUSPECT = "ether_PauseStatsHist_suspect"
	CONST_PROP_ID_ETHER_PAUSE_STATS_HIST_THRESHOLDED = "ether_PauseStatsHist_thresholded"
	CONST_PROP_ID_ETHER_PAUSE_STATS_HIST_TIME_COLLECTED = "ether_PauseStatsHist_timeCollected"
	CONST_PROP_ID_ETHER_PAUSE_STATS_HIST_XMIT_PAUSE = "ether_PauseStatsHist_xmitPause"
	CONST_PROP_ID_ETHER_PAUSE_STATS_HIST_XMIT_PAUSE_DELTA = "ether_PauseStatsHist_xmitPauseDelta"
	CONST_PROP_ID_ETHER_PAUSE_STATS_HIST_XMIT_PAUSE_DELTA_AVG = "ether_PauseStatsHist_xmitPauseDeltaAvg"
	CONST_PROP_ID_ETHER_PAUSE_STATS_HIST_XMIT_PAUSE_DELTA_MAX = "ether_PauseStatsHist_xmitPauseDeltaMax"
	CONST_PROP_ID_ETHER_PAUSE_STATS_HIST_XMIT_PAUSE_DELTA_MIN = "ether_PauseStatsHist_xmitPauseDeltaMin"
	CONST_PROP_ID_ETHER_PAUSE_STATS_INTERVALS = "ether_PauseStats_intervals"
	CONST_PROP_ID_ETHER_PAUSE_STATS_RECV_PAUSE = "ether_PauseStats_recvPause"
	CONST_PROP_ID_ETHER_PAUSE_STATS_RECV_PAUSE_DELTA = "ether_PauseStats_recvPauseDelta"
	CONST_PROP_ID_ETHER_PAUSE_STATS_RECV_PAUSE_DELTA_AVG = "ether_PauseStats_recvPauseDeltaAvg"
	CONST_PROP_ID_ETHER_PAUSE_STATS_RECV_PAUSE_DELTA_MAX = "ether_PauseStats_recvPauseDeltaMax"
	CONST_PROP_ID_ETHER_PAUSE_STATS_RECV_PAUSE_DELTA_MIN = "ether_PauseStats_recvPauseDeltaMin"
	CONST_PROP_ID_ETHER_PAUSE_STATS_RESETS = "ether_PauseStats_resets"
	CONST_PROP_ID_ETHER_PAUSE_STATS_RESETS_DELTA = "ether_PauseStats_resetsDelta"
	CONST_PROP_ID_ETHER_PAUSE_STATS_RESETS_DELTA_AVG = "ether_PauseStats_resetsDeltaAvg"
	CONST_PROP_ID_ETHER_PAUSE_STATS_RESETS_DELTA_MAX = "ether_PauseStats_resetsDeltaMax"
	CONST_PROP_ID_ETHER_PAUSE_STATS_RESETS_DELTA_MIN = "ether_PauseStats_resetsDeltaMin"
	CONST_PROP_ID_ETHER_PAUSE_STATS_SUSPECT = "ether_PauseStats_suspect"
	CONST_PROP_ID_ETHER_PAUSE_STATS_THRESHOLDED = "ether_PauseStats_thresholded"
	CONST_PROP_ID_ETHER_PAUSE_STATS_TIME_COLLECTED = "ether_PauseStats_timeCollected"
	CONST_PROP_ID_ETHER_PAUSE_STATS_UPDATE = "ether_PauseStats_update"
	CONST_PROP_ID_ETHER_PAUSE_STATS_XMIT_PAUSE = "ether_PauseStats_xmitPause"
	CONST_PROP_ID_ETHER_PAUSE_STATS_XMIT_PAUSE_DELTA = "ether_PauseStats_xmitPauseDelta"
	CONST_PROP_ID_ETHER_PAUSE_STATS_XMIT_PAUSE_DELTA_AVG = "ether_PauseStats_xmitPauseDeltaAvg"
	CONST_PROP_ID_ETHER_PAUSE_STATS_XMIT_PAUSE_DELTA_MAX = "ether_PauseStats_xmitPauseDeltaMax"
	CONST_PROP_ID_ETHER_PAUSE_STATS_XMIT_PAUSE_DELTA_MIN = "ether_PauseStats_xmitPauseDeltaMin"
	CONST_PROP_ID_ETHER_PC_EP_DN = "ether_Pc_epDn"
	CONST_PROP_ID_ETHER_PC_IF_ROLE = "ether_Pc_ifRole"
	CONST_PROP_ID_ETHER_PC_IF_TYPE = "ether_Pc_ifType"
	CONST_PROP_ID_ETHER_PC_LOCALE = "ether_Pc_locale"
	CONST_PROP_ID_ETHER_PC_NAME = "ether_Pc_name"
	CONST_PROP_ID_ETHER_PC_OPER_STATE = "ether_Pc_operState"
	CONST_PROP_ID_ETHER_PC_PEER_DN = "ether_Pc_peerDn"
	CONST_PROP_ID_ETHER_PC_PORT_ID = "ether_Pc_portId"
	CONST_PROP_ID_ETHER_PC_STATE_QUAL = "ether_Pc_stateQual"
	CONST_PROP_ID_ETHER_PC_SWITCH_ID = "ether_Pc_switchId"
	CONST_PROP_ID_ETHER_PC_TRANSPORT = "ether_Pc_transport"
	CONST_PROP_ID_ETHER_PC_TYPE = "ether_Pc_type"
	CONST_PROP_ID_ETHER_PORT_CHAN_ID_ELEM_ID = "ether_PortChanIdElem_id"
	CONST_PROP_ID_ETHER_RX_STATS_HIST_BROADCAST_PACKETS = "ether_RxStatsHist_broadcastPackets"
	CONST_PROP_ID_ETHER_RX_STATS_HIST_BROADCAST_PACKETS_DELTA = "ether_RxStatsHist_broadcastPacketsDelta"
	CONST_PROP_ID_ETHER_RX_STATS_HIST_BROADCAST_PACKETS_DELTA_AVG = "ether_RxStatsHist_broadcastPacketsDeltaAvg"
	CONST_PROP_ID_ETHER_RX_STATS_HIST_BROADCAST_PACKETS_DELTA_MAX = "ether_RxStatsHist_broadcastPacketsDeltaMax"
	CONST_PROP_ID_ETHER_RX_STATS_HIST_BROADCAST_PACKETS_DELTA_MIN = "ether_RxStatsHist_broadcastPacketsDeltaMin"
	CONST_PROP_ID_ETHER_RX_STATS_HIST_ID = "ether_RxStatsHist_id"
	CONST_PROP_ID_ETHER_RX_STATS_HIST_JUMBO_PACKETS = "ether_RxStatsHist_jumboPackets"
	CONST_PROP_ID_ETHER_RX_STATS_HIST_JUMBO_PACKETS_DELTA = "ether_RxStatsHist_jumboPacketsDelta"
	CONST_PROP_ID_ETHER_RX_STATS_HIST_JUMBO_PACKETS_DELTA_AVG = "ether_RxStatsHist_jumboPacketsDeltaAvg"
	CONST_PROP_ID_ETHER_RX_STATS_HIST_JUMBO_PACKETS_DELTA_MAX = "ether_RxStatsHist_jumboPacketsDeltaMax"
	CONST_PROP_ID_ETHER_RX_STATS_HIST_JUMBO_PACKETS_DELTA_MIN = "ether_RxStatsHist_jumboPacketsDeltaMin"
	CONST_PROP_ID_ETHER_RX_STATS_HIST_MOST_RECENT = "ether_RxStatsHist_mostRecent"
	CONST_PROP_ID_ETHER_RX_STATS_HIST_MULTICAST_PACKETS = "ether_RxStatsHist_multicastPackets"
	CONST_PROP_ID_ETHER_RX_STATS_HIST_MULTICAST_PACKETS_DELTA = "ether_RxStatsHist_multicastPacketsDelta"
	CONST_PROP_ID_ETHER_RX_STATS_HIST_MULTICAST_PACKETS_DELTA_AVG = "ether_RxStatsHist_multicastPacketsDeltaAvg"
	CONST_PROP_ID_ETHER_RX_STATS_HIST_MULTICAST_PACKETS_DELTA_MAX = "ether_RxStatsHist_multicastPacketsDeltaMax"
	CONST_PROP_ID_ETHER_RX_STATS_HIST_MULTICAST_PACKETS_DELTA_MIN = "ether_RxStatsHist_multicastPacketsDeltaMin"
	CONST_PROP_ID_ETHER_RX_STATS_HIST_SUSPECT = "ether_RxStatsHist_suspect"
	CONST_PROP_ID_ETHER_RX_STATS_HIST_THRESHOLDED = "ether_RxStatsHist_thresholded"
	CONST_PROP_ID_ETHER_RX_STATS_HIST_TIME_COLLECTED = "ether_RxStatsHist_timeCollected"
	CONST_PROP_ID_ETHER_RX_STATS_HIST_TOTAL_BYTES = "ether_RxStatsHist_totalBytes"
	CONST_PROP_ID_ETHER_RX_STATS_HIST_TOTAL_BYTES_DELTA = "ether_RxStatsHist_totalBytesDelta"
	CONST_PROP_ID_ETHER_RX_STATS_HIST_TOTAL_BYTES_DELTA_AVG = "ether_RxStatsHist_totalBytesDeltaAvg"
	CONST_PROP_ID_ETHER_RX_STATS_HIST_TOTAL_BYTES_DELTA_MAX = "ether_RxStatsHist_totalBytesDeltaMax"
	CONST_PROP_ID_ETHER_RX_STATS_HIST_TOTAL_BYTES_DELTA_MIN = "ether_RxStatsHist_totalBytesDeltaMin"
	CONST_PROP_ID_ETHER_RX_STATS_HIST_TOTAL_PACKETS = "ether_RxStatsHist_totalPackets"
	CONST_PROP_ID_ETHER_RX_STATS_HIST_TOTAL_PACKETS_DELTA = "ether_RxStatsHist_totalPacketsDelta"
	CONST_PROP_ID_ETHER_RX_STATS_HIST_TOTAL_PACKETS_DELTA_AVG = "ether_RxStatsHist_totalPacketsDeltaAvg"
	CONST_PROP_ID_ETHER_RX_STATS_HIST_TOTAL_PACKETS_DELTA_MAX = "ether_RxStatsHist_totalPacketsDeltaMax"
	CONST_PROP_ID_ETHER_RX_STATS_HIST_TOTAL_PACKETS_DELTA_MIN = "ether_RxStatsHist_totalPacketsDeltaMin"
	CONST_PROP_ID_ETHER_RX_STATS_HIST_UNICAST_PACKETS = "ether_RxStatsHist_unicastPackets"
	CONST_PROP_ID_ETHER_RX_STATS_HIST_UNICAST_PACKETS_DELTA = "ether_RxStatsHist_unicastPacketsDelta"
	CONST_PROP_ID_ETHER_RX_STATS_HIST_UNICAST_PACKETS_DELTA_AVG = "ether_RxStatsHist_unicastPacketsDeltaAvg"
	CONST_PROP_ID_ETHER_RX_STATS_HIST_UNICAST_PACKETS_DELTA_MAX = "ether_RxStatsHist_unicastPacketsDeltaMax"
	CONST_PROP_ID_ETHER_RX_STATS_HIST_UNICAST_PACKETS_DELTA_MIN = "ether_RxStatsHist_unicastPacketsDeltaMin"
	CONST_PROP_ID_ETHER_RX_STATS_BROADCAST_PACKETS = "ether_RxStats_broadcastPackets"
	CONST_PROP_ID_ETHER_RX_STATS_BROADCAST_PACKETS_DELTA = "ether_RxStats_broadcastPacketsDelta"
	CONST_PROP_ID_ETHER_RX_STATS_BROADCAST_PACKETS_DELTA_AVG = "ether_RxStats_broadcastPacketsDeltaAvg"
	CONST_PROP_ID_ETHER_RX_STATS_BROADCAST_PACKETS_DELTA_MAX = "ether_RxStats_broadcastPacketsDeltaMax"
	CONST_PROP_ID_ETHER_RX_STATS_BROADCAST_PACKETS_DELTA_MIN = "ether_RxStats_broadcastPacketsDeltaMin"
	CONST_PROP_ID_ETHER_RX_STATS_INTERVALS = "ether_RxStats_intervals"
	CONST_PROP_ID_ETHER_RX_STATS_JUMBO_PACKETS = "ether_RxStats_jumboPackets"
	CONST_PROP_ID_ETHER_RX_STATS_JUMBO_PACKETS_DELTA = "ether_RxStats_jumboPacketsDelta"
	CONST_PROP_ID_ETHER_RX_STATS_JUMBO_PACKETS_DELTA_AVG = "ether_RxStats_jumboPacketsDeltaAvg"
	CONST_PROP_ID_ETHER_RX_STATS_JUMBO_PACKETS_DELTA_MAX = "ether_RxStats_jumboPacketsDeltaMax"
	CONST_PROP_ID_ETHER_RX_STATS_JUMBO_PACKETS_DELTA_MIN = "ether_RxStats_jumboPacketsDeltaMin"
	CONST_PROP_ID_ETHER_RX_STATS_MULTICAST_PACKETS = "ether_RxStats_multicastPackets"
	CONST_PROP_ID_ETHER_RX_STATS_MULTICAST_PACKETS_DELTA = "ether_RxStats_multicastPacketsDelta"
	CONST_PROP_ID_ETHER_RX_STATS_MULTICAST_PACKETS_DELTA_AVG = "ether_RxStats_multicastPacketsDeltaAvg"
	CONST_PROP_ID_ETHER_RX_STATS_MULTICAST_PACKETS_DELTA_MAX = "ether_RxStats_multicastPacketsDeltaMax"
	CONST_PROP_ID_ETHER_RX_STATS_MULTICAST_PACKETS_DELTA_MIN = "ether_RxStats_multicastPacketsDeltaMin"
	CONST_PROP_ID_ETHER_RX_STATS_SUSPECT = "ether_RxStats_suspect"
	CONST_PROP_ID_ETHER_RX_STATS_THRESHOLDED = "ether_RxStats_thresholded"
	CONST_PROP_ID_ETHER_RX_STATS_TIME_COLLECTED = "ether_RxStats_timeCollected"
	CONST_PROP_ID_ETHER_RX_STATS_TOTAL_BYTES = "ether_RxStats_totalBytes"
	CONST_PROP_ID_ETHER_RX_STATS_TOTAL_BYTES_DELTA = "ether_RxStats_totalBytesDelta"
	CONST_PROP_ID_ETHER_RX_STATS_TOTAL_BYTES_DELTA_AVG = "ether_RxStats_totalBytesDeltaAvg"
	CONST_PROP_ID_ETHER_RX_STATS_TOTAL_BYTES_DELTA_MAX = "ether_RxStats_totalBytesDeltaMax"
	CONST_PROP_ID_ETHER_RX_STATS_TOTAL_BYTES_DELTA_MIN = "ether_RxStats_totalBytesDeltaMin"
	CONST_PROP_ID_ETHER_RX_STATS_TOTAL_PACKETS = "ether_RxStats_totalPackets"
	CONST_PROP_ID_ETHER_RX_STATS_TOTAL_PACKETS_DELTA = "ether_RxStats_totalPacketsDelta"
	CONST_PROP_ID_ETHER_RX_STATS_TOTAL_PACKETS_DELTA_AVG = "ether_RxStats_totalPacketsDeltaAvg"
	CONST_PROP_ID_ETHER_RX_STATS_TOTAL_PACKETS_DELTA_MAX = "ether_RxStats_totalPacketsDeltaMax"
	CONST_PROP_ID_ETHER_RX_STATS_TOTAL_PACKETS_DELTA_MIN = "ether_RxStats_totalPacketsDeltaMin"
	CONST_PROP_ID_ETHER_RX_STATS_UNICAST_PACKETS = "ether_RxStats_unicastPackets"
	CONST_PROP_ID_ETHER_RX_STATS_UNICAST_PACKETS_DELTA = "ether_RxStats_unicastPacketsDelta"
	CONST_PROP_ID_ETHER_RX_STATS_UNICAST_PACKETS_DELTA_AVG = "ether_RxStats_unicastPacketsDeltaAvg"
	CONST_PROP_ID_ETHER_RX_STATS_UNICAST_PACKETS_DELTA_MAX = "ether_RxStats_unicastPacketsDeltaMax"
	CONST_PROP_ID_ETHER_RX_STATS_UNICAST_PACKETS_DELTA_MIN = "ether_RxStats_unicastPacketsDeltaMin"
	CONST_PROP_ID_ETHER_RX_STATS_UPDATE = "ether_RxStats_update"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_FSM_STAGE_DESCR = "ether_ServerIntFIoFsmStage_descr"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_FSM_STAGE_LAST_UPDATE_TIME = "ether_ServerIntFIoFsmStage_lastUpdateTime"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_FSM_STAGE_NAME = "ether_ServerIntFIoFsmStage_name"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_FSM_STAGE_ORDER = "ether_ServerIntFIoFsmStage_order"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_FSM_STAGE_RETRY = "ether_ServerIntFIoFsmStage_retry"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_FSM_STAGE_STAGE_STATUS = "ether_ServerIntFIoFsmStage_stageStatus"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_FSM_TASK_COMPLETION = "ether_ServerIntFIoFsmTask_completion"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_FSM_TASK_FLAGS = "ether_ServerIntFIoFsmTask_flags"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_FSM_TASK_ITEM = "ether_ServerIntFIoFsmTask_item"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_FSM_TASK_SEQ_ID = "ether_ServerIntFIoFsmTask_seqId"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_FSM_COMPLETION_TIME = "ether_ServerIntFIoFsm_completionTime"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_FSM_CURRENT_FSM = "ether_ServerIntFIoFsm_currentFsm"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_FSM_DESCR = "ether_ServerIntFIoFsm_descr"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_FSM_FSM_STATUS = "ether_ServerIntFIoFsm_fsmStatus"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_FSM_INSTANCE_ID = "ether_ServerIntFIoFsm_instanceId"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_FSM_PROGRESS = "ether_ServerIntFIoFsm_progress"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_FSM_RMT_ERR_CODE = "ether_ServerIntFIoFsm_rmtErrCode"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_FSM_RMT_ERR_DESCR = "ether_ServerIntFIoFsm_rmtErrDescr"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_FSM_RMT_RSLT = "ether_ServerIntFIoFsm_rmtRslt"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_PC_EP_ADMIN_STATE = "ether_ServerIntFIoPcEp_adminState"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_PC_EP_CHASSIS_ID = "ether_ServerIntFIoPcEp_chassisId"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_PC_EP_EP_DN = "ether_ServerIntFIoPcEp_epDn"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_PC_EP_IF_ROLE = "ether_ServerIntFIoPcEp_ifRole"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_PC_EP_IF_TYPE = "ether_ServerIntFIoPcEp_ifType"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_PC_EP_LOCALE = "ether_ServerIntFIoPcEp_locale"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_PC_EP_MEMBERSHIP = "ether_ServerIntFIoPcEp_membership"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_PC_EP_NAME = "ether_ServerIntFIoPcEp_name"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_PC_EP_PEER_CHASSIS_ID = "ether_ServerIntFIoPcEp_peerChassisId"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_PC_EP_PEER_DN = "ether_ServerIntFIoPcEp_peerDn"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_PC_EP_PEER_PORT_ID = "ether_ServerIntFIoPcEp_peerPortId"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_PC_EP_PEER_SLOT_ID = "ether_ServerIntFIoPcEp_peerSlotId"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_PC_EP_PORT_ID = "ether_ServerIntFIoPcEp_portId"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_PC_EP_SLOT_ID = "ether_ServerIntFIoPcEp_slotId"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_PC_EP_SWITCH_ID = "ether_ServerIntFIoPcEp_switchId"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_PC_EP_TRANSPORT = "ether_ServerIntFIoPcEp_transport"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_PC_EP_TYPE = "ether_ServerIntFIoPcEp_type"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_PC_CHASSIS_ID = "ether_ServerIntFIoPc_chassisId"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_PC_EP_DN = "ether_ServerIntFIoPc_epDn"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_PC_FLT_AGGR = "ether_ServerIntFIoPc_fltAggr"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_PC_IF_ROLE = "ether_ServerIntFIoPc_ifRole"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_PC_IF_TYPE = "ether_ServerIntFIoPc_ifType"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_PC_LOCALE = "ether_ServerIntFIoPc_locale"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_PC_NAME = "ether_ServerIntFIoPc_name"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_PC_OPER_SPEED = "ether_ServerIntFIoPc_operSpeed"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_PC_OPER_STATE = "ether_ServerIntFIoPc_operState"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_PC_PEER_DN = "ether_ServerIntFIoPc_peerDn"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_PC_PORT_ID = "ether_ServerIntFIoPc_portId"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_PC_STATE_QUAL = "ether_ServerIntFIoPc_stateQual"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_PC_SWITCH_ID = "ether_ServerIntFIoPc_switchId"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_PC_TRANSPORT = "ether_ServerIntFIoPc_transport"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_PC_TYPE = "ether_ServerIntFIoPc_type"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_ADMIN_SPEED = "ether_ServerIntFIo_adminSpeed"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_ADMIN_STATE = "ether_ServerIntFIo_adminState"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_CHASSIS_ID = "ether_ServerIntFIo_chassisId"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_ENCAP = "ether_ServerIntFIo_encap"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_EP_DN = "ether_ServerIntFIo_epDn"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_FSM_DESCR = "ether_ServerIntFIo_fsmDescr"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_FSM_PREV = "ether_ServerIntFIo_fsmPrev"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_FSM_PROGR = "ether_ServerIntFIo_fsmProgr"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_FSM_RMT_INV_ERR_CODE = "ether_ServerIntFIo_fsmRmtInvErrCode"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_FSM_RMT_INV_ERR_DESCR = "ether_ServerIntFIo_fsmRmtInvErrDescr"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_FSM_RMT_INV_RSLT = "ether_ServerIntFIo_fsmRmtInvRslt"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_FSM_STAGE_DESCR = "ether_ServerIntFIo_fsmStageDescr"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_FSM_STAMP = "ether_ServerIntFIo_fsmStamp"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_FSM_STATUS = "ether_ServerIntFIo_fsmStatus"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_FSM_TRY = "ether_ServerIntFIo_fsmTry"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_IF_ROLE = "ether_ServerIntFIo_ifRole"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_IF_TYPE = "ether_ServerIntFIo_ifType"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_LOCALE = "ether_ServerIntFIo_locale"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_MAC = "ether_ServerIntFIo_mac"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_MODE = "ether_ServerIntFIo_mode"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_MODEL = "ether_ServerIntFIo_model"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_NAME = "ether_ServerIntFIo_name"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_NS_SIZE = "ether_ServerIntFIo_nsSize"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_OPER_BORDER_PORT_ID = "ether_ServerIntFIo_operBorderPortId"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_OPER_BORDER_SLOT_ID = "ether_ServerIntFIo_operBorderSlotId"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_OPER_STATE = "ether_ServerIntFIo_operState"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_PEER_CHASSIS_ID = "ether_ServerIntFIo_peerChassisId"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_PEER_DN = "ether_ServerIntFIo_peerDn"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_PEER_ENCAP = "ether_ServerIntFIo_peerEncap"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_PEER_PORT_ID = "ether_ServerIntFIo_peerPortId"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_PEER_SLOT_ID = "ether_ServerIntFIo_peerSlotId"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_PORT_ID = "ether_ServerIntFIo_portId"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_REVISION = "ether_ServerIntFIo_revision"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_SERIAL = "ether_ServerIntFIo_serial"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_SLOT_ID = "ether_ServerIntFIo_slotId"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_STATE_QUAL = "ether_ServerIntFIo_stateQual"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_SWITCH_ID = "ether_ServerIntFIo_switchId"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_TRANSPORT = "ether_ServerIntFIo_transport"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_TS = "ether_ServerIntFIo_ts"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_TYPE = "ether_ServerIntFIo_type"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_VENDOR = "ether_ServerIntFIo_vendor"
	CONST_PROP_ID_ETHER_SERVER_INT_FIO_XCVR_TYPE = "ether_ServerIntFIo_xcvrType"
	CONST_PROP_ID_ETHER_SWITCH_INT_FIO_PC_EP_ACK_STATE = "ether_SwitchIntFIoPcEp_ackState"
	CONST_PROP_ID_ETHER_SWITCH_INT_FIO_PC_EP_ADMIN_STATE = "ether_SwitchIntFIoPcEp_adminState"
	CONST_PROP_ID_ETHER_SWITCH_INT_FIO_PC_EP_CHASSIS_ID = "ether_SwitchIntFIoPcEp_chassisId"
	CONST_PROP_ID_ETHER_SWITCH_INT_FIO_PC_EP_EP_DN = "ether_SwitchIntFIoPcEp_epDn"
	CONST_PROP_ID_ETHER_SWITCH_INT_FIO_PC_EP_IF_ROLE = "ether_SwitchIntFIoPcEp_ifRole"
	CONST_PROP_ID_ETHER_SWITCH_INT_FIO_PC_EP_IF_TYPE = "ether_SwitchIntFIoPcEp_ifType"
	CONST_PROP_ID_ETHER_SWITCH_INT_FIO_PC_EP_LOCALE = "ether_SwitchIntFIoPcEp_locale"
	CONST_PROP_ID_ETHER_SWITCH_INT_FIO_PC_EP_MEMBERSHIP = "ether_SwitchIntFIoPcEp_membership"
	CONST_PROP_ID_ETHER_SWITCH_INT_FIO_PC_EP_NAME = "ether_SwitchIntFIoPcEp_name"
	CONST_PROP_ID_ETHER_SWITCH_INT_FIO_PC_EP_PEER_CHASSIS_ID = "ether_SwitchIntFIoPcEp_peerChassisId"
	CONST_PROP_ID_ETHER_SWITCH_INT_FIO_PC_EP_PEER_DN = "ether_SwitchIntFIoPcEp_peerDn"
	CONST_PROP_ID_ETHER_SWITCH_INT_FIO_PC_EP_PEER_PORT_ID = "ether_SwitchIntFIoPcEp_peerPortId"
	CONST_PROP_ID_ETHER_SWITCH_INT_FIO_PC_EP_PEER_SLOT_ID = "ether_SwitchIntFIoPcEp_peerSlotId"
	CONST_PROP_ID_ETHER_SWITCH_INT_FIO_PC_EP_PORT_ID = "ether_SwitchIntFIoPcEp_portId"
	CONST_PROP_ID_ETHER_SWITCH_INT_FIO_PC_EP_SLOT_ID = "ether_SwitchIntFIoPcEp_slotId"
	CONST_PROP_ID_ETHER_SWITCH_INT_FIO_PC_EP_STATUS_CHANGE_TS = "ether_SwitchIntFIoPcEp_statusChangeTs"
	CONST_PROP_ID_ETHER_SWITCH_INT_FIO_PC_EP_SWITCH_ID = "ether_SwitchIntFIoPcEp_switchId"
	CONST_PROP_ID_ETHER_SWITCH_INT_FIO_PC_EP_TRANSPORT = "ether_SwitchIntFIoPcEp_transport"
	CONST_PROP_ID_ETHER_SWITCH_INT_FIO_PC_EP_TYPE = "ether_SwitchIntFIoPcEp_type"
	CONST_PROP_ID_ETHER_SWITCH_INT_FIO_PC_ADMIN_STATE = "ether_SwitchIntFIoPc_adminState"
	CONST_PROP_ID_ETHER_SWITCH_INT_FIO_PC_CHASSIS_ID = "ether_SwitchIntFIoPc_chassisId"
	CONST_PROP_ID_ETHER_SWITCH_INT_FIO_PC_EP_DN = "ether_SwitchIntFIoPc_epDn"
	CONST_PROP_ID_ETHER_SWITCH_INT_FIO_PC_FLT_AGGR = "ether_SwitchIntFIoPc_fltAggr"
	CONST_PROP_ID_ETHER_SWITCH_INT_FIO_PC_IF_ROLE = "ether_SwitchIntFIoPc_ifRole"
	CONST_PROP_ID_ETHER_SWITCH_INT_FIO_PC_IF_TYPE = "ether_SwitchIntFIoPc_ifType"
	CONST_PROP_ID_ETHER_SWITCH_INT_FIO_PC_LOCALE = "ether_SwitchIntFIoPc_locale"
	CONST_PROP_ID_ETHER_SWITCH_INT_FIO_PC_NAME = "ether_SwitchIntFIoPc_name"
	CONST_PROP_ID_ETHER_SWITCH_INT_FIO_PC_OPER_SPEED = "ether_SwitchIntFIoPc_operSpeed"
	CONST_PROP_ID_ETHER_SWITCH_INT_FIO_PC_OPER_STATE = "ether_SwitchIntFIoPc_operState"
	CONST_PROP_ID_ETHER_SWITCH_INT_FIO_PC_PEER_DN = "ether_SwitchIntFIoPc_peerDn"
	CONST_PROP_ID_ETHER_SWITCH_INT_FIO_PC_PORT_ID = "ether_SwitchIntFIoPc_portId"
	CONST_PROP_ID_ETHER_SWITCH_INT_FIO_PC_STATE_QUAL = "ether_SwitchIntFIoPc_stateQual"
	CONST_PROP_ID_ETHER_SWITCH_INT_FIO_PC_SWITCH_ID = "ether_SwitchIntFIoPc_switchId"
	CONST_PROP_ID_ETHER_SWITCH_INT_FIO_PC_TRANSPORT = "ether_SwitchIntFIoPc_transport"
	CONST_PROP_ID_ETHER_SWITCH_INT_FIO_PC_TYPE = "ether_SwitchIntFIoPc_type"
	CONST_PROP_ID_ETHER_SWITCH_INT_FIO_ACK = "ether_SwitchIntFIo_ack"
	CONST_PROP_ID_ETHER_SWITCH_INT_FIO_ADMIN_STATE = "ether_SwitchIntFIo_adminState"
	CONST_PROP_ID_ETHER_SWITCH_INT_FIO_CHASSIS_ID = "ether_SwitchIntFIo_chassisId"
	CONST_PROP_ID_ETHER_SWITCH_INT_FIO_DEL_FE_TS = "ether_SwitchIntFIo_delFeTs"
	CONST_PROP_ID_ETHER_SWITCH_INT_FIO_DISCOVERY = "ether_SwitchIntFIo_discovery"
	CONST_PROP_ID_ETHER_SWITCH_INT_FIO_ENCAP = "ether_SwitchIntFIo_encap"
	CONST_PROP_ID_ETHER_SWITCH_INT_FIO_EP_DN = "ether_SwitchIntFIo_epDn"
	CONST_PROP_ID_ETHER_SWITCH_INT_FIO_IF_ROLE = "ether_SwitchIntFIo_ifRole"
	CONST_PROP_ID_ETHER_SWITCH_INT_FIO_IF_TYPE = "ether_SwitchIntFIo_ifType"
	CONST_PROP_ID_ETHER_SWITCH_INT_FIO_LOCALE = "ether_SwitchIntFIo_locale"
	CONST_PROP_ID_ETHER_SWITCH_INT_FIO_MODE = "ether_SwitchIntFIo_mode"
	CONST_PROP_ID_ETHER_SWITCH_INT_FIO_MODEL = "ether_SwitchIntFIo_model"
	CONST_PROP_ID_ETHER_SWITCH_INT_FIO_NAME = "ether_SwitchIntFIo_name"
	CONST_PROP_ID_ETHER_SWITCH_INT_FIO_NEW_FE_TS = "ether_SwitchIntFIo_newFeTs"
	CONST_PROP_ID_ETHER_SWITCH_INT_FIO_OPER_STATE = "ether_SwitchIntFIo_operState"
	CONST_PROP_ID_ETHER_SWITCH_INT_FIO_PEER_CHASSIS_ID = "ether_SwitchIntFIo_peerChassisId"
	CONST_PROP_ID_ETHER_SWITCH_INT_FIO_PEER_DN = "ether_SwitchIntFIo_peerDn"
	CONST_PROP_ID_ETHER_SWITCH_INT_FIO_PEER_PORT_ID = "ether_SwitchIntFIo_peerPortId"
	CONST_PROP_ID_ETHER_SWITCH_INT_FIO_PEER_SLOT_ID = "ether_SwitchIntFIo_peerSlotId"
	CONST_PROP_ID_ETHER_SWITCH_INT_FIO_PORT_ID = "ether_SwitchIntFIo_portId"
	CONST_PROP_ID_ETHER_SWITCH_INT_FIO_REVISION = "ether_SwitchIntFIo_revision"
	CONST_PROP_ID_ETHER_SWITCH_INT_FIO_SERIAL = "ether_SwitchIntFIo_serial"
	CONST_PROP_ID_ETHER_SWITCH_INT_FIO_SLOT_ID = "ether_SwitchIntFIo_slotId"
	CONST_PROP_ID_ETHER_SWITCH_INT_FIO_STATE_QUAL = "ether_SwitchIntFIo_stateQual"
	CONST_PROP_ID_ETHER_SWITCH_INT_FIO_SWITCH_ID = "ether_SwitchIntFIo_switchId"
	CONST_PROP_ID_ETHER_SWITCH_INT_FIO_TRANSPORT = "ether_SwitchIntFIo_transport"
	CONST_PROP_ID_ETHER_SWITCH_INT_FIO_TS = "ether_SwitchIntFIo_ts"
	CONST_PROP_ID_ETHER_SWITCH_INT_FIO_TYPE = "ether_SwitchIntFIo_type"
	CONST_PROP_ID_ETHER_SWITCH_INT_FIO_VENDOR = "ether_SwitchIntFIo_vendor"
	CONST_PROP_ID_ETHER_SWITCH_INT_FIO_XCVR_TYPE = "ether_SwitchIntFIo_xcvrType"
	CONST_PROP_ID_ETHER_TX_STATS_HIST_BROADCAST_PACKETS = "ether_TxStatsHist_broadcastPackets"
	CONST_PROP_ID_ETHER_TX_STATS_HIST_BROADCAST_PACKETS_DELTA = "ether_TxStatsHist_broadcastPacketsDelta"
	CONST_PROP_ID_ETHER_TX_STATS_HIST_BROADCAST_PACKETS_DELTA_AVG = "ether_TxStatsHist_broadcastPacketsDeltaAvg"
	CONST_PROP_ID_ETHER_TX_STATS_HIST_BROADCAST_PACKETS_DELTA_MAX = "ether_TxStatsHist_broadcastPacketsDeltaMax"
	CONST_PROP_ID_ETHER_TX_STATS_HIST_BROADCAST_PACKETS_DELTA_MIN = "ether_TxStatsHist_broadcastPacketsDeltaMin"
	CONST_PROP_ID_ETHER_TX_STATS_HIST_ID = "ether_TxStatsHist_id"
	CONST_PROP_ID_ETHER_TX_STATS_HIST_JUMBO_PACKETS = "ether_TxStatsHist_jumboPackets"
	CONST_PROP_ID_ETHER_TX_STATS_HIST_JUMBO_PACKETS_DELTA = "ether_TxStatsHist_jumboPacketsDelta"
	CONST_PROP_ID_ETHER_TX_STATS_HIST_JUMBO_PACKETS_DELTA_AVG = "ether_TxStatsHist_jumboPacketsDeltaAvg"
	CONST_PROP_ID_ETHER_TX_STATS_HIST_JUMBO_PACKETS_DELTA_MAX = "ether_TxStatsHist_jumboPacketsDeltaMax"
	CONST_PROP_ID_ETHER_TX_STATS_HIST_JUMBO_PACKETS_DELTA_MIN = "ether_TxStatsHist_jumboPacketsDeltaMin"
	CONST_PROP_ID_ETHER_TX_STATS_HIST_MOST_RECENT = "ether_TxStatsHist_mostRecent"
	CONST_PROP_ID_ETHER_TX_STATS_HIST_MULTICAST_PACKETS = "ether_TxStatsHist_multicastPackets"
	CONST_PROP_ID_ETHER_TX_STATS_HIST_MULTICAST_PACKETS_DELTA = "ether_TxStatsHist_multicastPacketsDelta"
	CONST_PROP_ID_ETHER_TX_STATS_HIST_MULTICAST_PACKETS_DELTA_AVG = "ether_TxStatsHist_multicastPacketsDeltaAvg"
	CONST_PROP_ID_ETHER_TX_STATS_HIST_MULTICAST_PACKETS_DELTA_MAX = "ether_TxStatsHist_multicastPacketsDeltaMax"
	CONST_PROP_ID_ETHER_TX_STATS_HIST_MULTICAST_PACKETS_DELTA_MIN = "ether_TxStatsHist_multicastPacketsDeltaMin"
	CONST_PROP_ID_ETHER_TX_STATS_HIST_SUSPECT = "ether_TxStatsHist_suspect"
	CONST_PROP_ID_ETHER_TX_STATS_HIST_THRESHOLDED = "ether_TxStatsHist_thresholded"
	CONST_PROP_ID_ETHER_TX_STATS_HIST_TIME_COLLECTED = "ether_TxStatsHist_timeCollected"
	CONST_PROP_ID_ETHER_TX_STATS_HIST_TOTAL_BYTES = "ether_TxStatsHist_totalBytes"
	CONST_PROP_ID_ETHER_TX_STATS_HIST_TOTAL_BYTES_DELTA = "ether_TxStatsHist_totalBytesDelta"
	CONST_PROP_ID_ETHER_TX_STATS_HIST_TOTAL_BYTES_DELTA_AVG = "ether_TxStatsHist_totalBytesDeltaAvg"
	CONST_PROP_ID_ETHER_TX_STATS_HIST_TOTAL_BYTES_DELTA_MAX = "ether_TxStatsHist_totalBytesDeltaMax"
	CONST_PROP_ID_ETHER_TX_STATS_HIST_TOTAL_BYTES_DELTA_MIN = "ether_TxStatsHist_totalBytesDeltaMin"
	CONST_PROP_ID_ETHER_TX_STATS_HIST_TOTAL_PACKETS = "ether_TxStatsHist_totalPackets"
	CONST_PROP_ID_ETHER_TX_STATS_HIST_TOTAL_PACKETS_DELTA = "ether_TxStatsHist_totalPacketsDelta"
	CONST_PROP_ID_ETHER_TX_STATS_HIST_TOTAL_PACKETS_DELTA_AVG = "ether_TxStatsHist_totalPacketsDeltaAvg"
	CONST_PROP_ID_ETHER_TX_STATS_HIST_TOTAL_PACKETS_DELTA_MAX = "ether_TxStatsHist_totalPacketsDeltaMax"
	CONST_PROP_ID_ETHER_TX_STATS_HIST_TOTAL_PACKETS_DELTA_MIN = "ether_TxStatsHist_totalPacketsDeltaMin"
	CONST_PROP_ID_ETHER_TX_STATS_HIST_UNICAST_PACKETS = "ether_TxStatsHist_unicastPackets"
	CONST_PROP_ID_ETHER_TX_STATS_HIST_UNICAST_PACKETS_DELTA = "ether_TxStatsHist_unicastPacketsDelta"
	CONST_PROP_ID_ETHER_TX_STATS_HIST_UNICAST_PACKETS_DELTA_AVG = "ether_TxStatsHist_unicastPacketsDeltaAvg"
	CONST_PROP_ID_ETHER_TX_STATS_HIST_UNICAST_PACKETS_DELTA_MAX = "ether_TxStatsHist_unicastPacketsDeltaMax"
	CONST_PROP_ID_ETHER_TX_STATS_HIST_UNICAST_PACKETS_DELTA_MIN = "ether_TxStatsHist_unicastPacketsDeltaMin"
	CONST_PROP_ID_ETHER_TX_STATS_BROADCAST_PACKETS = "ether_TxStats_broadcastPackets"
	CONST_PROP_ID_ETHER_TX_STATS_BROADCAST_PACKETS_DELTA = "ether_TxStats_broadcastPacketsDelta"
	CONST_PROP_ID_ETHER_TX_STATS_BROADCAST_PACKETS_DELTA_AVG = "ether_TxStats_broadcastPacketsDeltaAvg"
	CONST_PROP_ID_ETHER_TX_STATS_BROADCAST_PACKETS_DELTA_MAX = "ether_TxStats_broadcastPacketsDeltaMax"
	CONST_PROP_ID_ETHER_TX_STATS_BROADCAST_PACKETS_DELTA_MIN = "ether_TxStats_broadcastPacketsDeltaMin"
	CONST_PROP_ID_ETHER_TX_STATS_INTERVALS = "ether_TxStats_intervals"
	CONST_PROP_ID_ETHER_TX_STATS_JUMBO_PACKETS = "ether_TxStats_jumboPackets"
	CONST_PROP_ID_ETHER_TX_STATS_JUMBO_PACKETS_DELTA = "ether_TxStats_jumboPacketsDelta"
	CONST_PROP_ID_ETHER_TX_STATS_JUMBO_PACKETS_DELTA_AVG = "ether_TxStats_jumboPacketsDeltaAvg"
	CONST_PROP_ID_ETHER_TX_STATS_JUMBO_PACKETS_DELTA_MAX = "ether_TxStats_jumboPacketsDeltaMax"
	CONST_PROP_ID_ETHER_TX_STATS_JUMBO_PACKETS_DELTA_MIN = "ether_TxStats_jumboPacketsDeltaMin"
	CONST_PROP_ID_ETHER_TX_STATS_MULTICAST_PACKETS = "ether_TxStats_multicastPackets"
	CONST_PROP_ID_ETHER_TX_STATS_MULTICAST_PACKETS_DELTA = "ether_TxStats_multicastPacketsDelta"
	CONST_PROP_ID_ETHER_TX_STATS_MULTICAST_PACKETS_DELTA_AVG = "ether_TxStats_multicastPacketsDeltaAvg"
	CONST_PROP_ID_ETHER_TX_STATS_MULTICAST_PACKETS_DELTA_MAX = "ether_TxStats_multicastPacketsDeltaMax"
	CONST_PROP_ID_ETHER_TX_STATS_MULTICAST_PACKETS_DELTA_MIN = "ether_TxStats_multicastPacketsDeltaMin"
	CONST_PROP_ID_ETHER_TX_STATS_SUSPECT = "ether_TxStats_suspect"
	CONST_PROP_ID_ETHER_TX_STATS_THRESHOLDED = "ether_TxStats_thresholded"
	CONST_PROP_ID_ETHER_TX_STATS_TIME_COLLECTED = "ether_TxStats_timeCollected"
	CONST_PROP_ID_ETHER_TX_STATS_TOTAL_BYTES = "ether_TxStats_totalBytes"
	CONST_PROP_ID_ETHER_TX_STATS_TOTAL_BYTES_DELTA = "ether_TxStats_totalBytesDelta"
	CONST_PROP_ID_ETHER_TX_STATS_TOTAL_BYTES_DELTA_AVG = "ether_TxStats_totalBytesDeltaAvg"
	CONST_PROP_ID_ETHER_TX_STATS_TOTAL_BYTES_DELTA_MAX = "ether_TxStats_totalBytesDeltaMax"
	CONST_PROP_ID_ETHER_TX_STATS_TOTAL_BYTES_DELTA_MIN = "ether_TxStats_totalBytesDeltaMin"
	CONST_PROP_ID_ETHER_TX_STATS_TOTAL_PACKETS = "ether_TxStats_totalPackets"
	CONST_PROP_ID_ETHER_TX_STATS_TOTAL_PACKETS_DELTA = "ether_TxStats_totalPacketsDelta"
	CONST_PROP_ID_ETHER_TX_STATS_TOTAL_PACKETS_DELTA_AVG = "ether_TxStats_totalPacketsDeltaAvg"
	CONST_PROP_ID_ETHER_TX_STATS_TOTAL_PACKETS_DELTA_MAX = "ether_TxStats_totalPacketsDeltaMax"
	CONST_PROP_ID_ETHER_TX_STATS_TOTAL_PACKETS_DELTA_MIN = "ether_TxStats_totalPacketsDeltaMin"
	CONST_PROP_ID_ETHER_TX_STATS_UNICAST_PACKETS = "ether_TxStats_unicastPackets"
	CONST_PROP_ID_ETHER_TX_STATS_UNICAST_PACKETS_DELTA = "ether_TxStats_unicastPacketsDelta"
	CONST_PROP_ID_ETHER_TX_STATS_UNICAST_PACKETS_DELTA_AVG = "ether_TxStats_unicastPacketsDeltaAvg"
	CONST_PROP_ID_ETHER_TX_STATS_UNICAST_PACKETS_DELTA_MAX = "ether_TxStats_unicastPacketsDeltaMax"
	CONST_PROP_ID_ETHER_TX_STATS_UNICAST_PACKETS_DELTA_MIN = "ether_TxStats_unicastPacketsDeltaMin"
	CONST_PROP_ID_ETHER_TX_STATS_UPDATE = "ether_TxStats_update"
	CONST_PROP_ID_EVENT_EP_CTRL_LEVEL = "event_EpCtrl_level"
	CONST_PROP_ID_EVENT_EP_CTRL_REVERT_TIMEOUT = "event_EpCtrl_revertTimeout"
	CONST_PROP_ID_EVENT_HOLDER_NAME = "event_Holder_name"
	CONST_PROP_ID_EVENT_INST_CAUSE = "event_Inst_cause"
	CONST_PROP_ID_EVENT_INST_CHANGE_SET = "event_Inst_changeSet"
	CONST_PROP_ID_EVENT_INST_CODE = "event_Inst_code"
	CONST_PROP_ID_EVENT_INST_CREATED = "event_Inst_created"
	CONST_PROP_ID_EVENT_INST_DESCR = "event_Inst_descr"
	CONST_PROP_ID_EVENT_INST_ID = "event_Inst_id"
	CONST_PROP_ID_EVENT_INST_RULE = "event_Inst_rule"
	CONST_PROP_ID_EVENT_INST_SEVERITY = "event_Inst_severity"
	CONST_PROP_ID_EVENT_INST_TAGS = "event_Inst_tags"
	CONST_PROP_ID_EVENT_INST_TYPE = "event_Inst_type"
	CONST_PROP_ID_EVENT_LOG_MAX_SIZE = "event_Log_maxSize"
	CONST_PROP_ID_EVENT_LOG_PURGE_WINDOW = "event_Log_purgeWindow"
	CONST_PROP_ID_EVENT_LOG_SIZE = "event_Log_size"
	CONST_PROP_ID_EVENT_POLICY_DESCR = "event_Policy_descr"
	CONST_PROP_ID_EVENT_POLICY_INT_ID = "event_Policy_intId"
	CONST_PROP_ID_EVENT_POLICY_NAME = "event_Policy_name"
	CONST_PROP_ID_EVENT_POLICY_POLICY_LEVEL = "event_Policy_policyLevel"
	CONST_PROP_ID_EVENT_POLICY_POLICY_OWNER = "event_Policy_policyOwner"
	CONST_PROP_ID_EVENT_POLICY_RETENTION_INTERVAL = "event_Policy_retentionInterval"
	CONST_PROP_ID_EVENT_POLICY_SIZE_LIMIT = "event_Policy_sizeLimit"
	CONST_PROP_ID_EVENT_RECORD_AFFECTED = "event_Record_affected"
	CONST_PROP_ID_EVENT_RECORD_CAUSE = "event_Record_ca