
# Copyright 2013 Cisco Systems, Inc.
# 
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
# 
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

""" This is an auto-generated module containing ManagedObject Meta information. """

from UcsHandle import *

class _VersionMeta:
	Version101e = UcsVersion("1.0(1e)")
	Version102d = UcsVersion("1.0(2d)")
	Version102e = UcsVersion("1.0(2e)")
	Version102h = UcsVersion("1.0(2h)")
	Version102j = UcsVersion("1.0(2j)")
	Version102k = UcsVersion("1.0(2k)")
	Version102l = UcsVersion("1.0(2l)")
	Version111j = UcsVersion("1.1(1j)")
	Version111l = UcsVersion("1.1(1l)")
	Version111m = UcsVersion("1.1(1m)")
	Version121b = UcsVersion("1.2(1b)")
	Version121d = UcsVersion("1.2(1d)")
	Version131c = UcsVersion("1.3(1c)")
	Version131i = UcsVersion("1.3(1i)")
	Version131m = UcsVersion("1.3(1m)")
	Version131n = UcsVersion("1.3(1n)")
	Version131o = UcsVersion("1.3(1o)")
	Version131p = UcsVersion("1.3(1p)")
	Version131q = UcsVersion("1.3(1q)")
	Version131t = UcsVersion("1.3(1t)")
	Version131w = UcsVersion("1.3(1w)")
	Version131y = UcsVersion("1.3(1y)")
	Version141i = UcsVersion("1.4(1i)")
	Version141j = UcsVersion("1.4(1j)")
	Version141k = UcsVersion("1.4(1k)")
	Version141m = UcsVersion("1.4(1m)")
	Version142b = UcsVersion("1.4(2b)")
	Version143i = UcsVersion("1.4(3i)")
	Version143l = UcsVersion("1.4(3l)")
	Version143m = UcsVersion("1.4(3m)")
	Version143q = UcsVersion("1.4(3q)")
	Version143s = UcsVersion("1.4(3s)")
	Version143u = UcsVersion("1.4(3u)")
	Version143y = UcsVersion("1.4(3y)")
	Version144f = UcsVersion("1.4(4f)")
	Version144g = UcsVersion("1.4(4g)")
	Version144i = UcsVersion("1.4(4i)")
	Version201m = UcsVersion("2.0(1m)")
	Version201q = UcsVersion("2.0(1q)")
	Version201s = UcsVersion("2.0(1s)")
	Version201t = UcsVersion("2.0(1t)")
	Version201w = UcsVersion("2.0(1w)")
	Version201x = UcsVersion("2.0(1x)")
	Version202m = UcsVersion("2.0(2m)")
	Version202q = UcsVersion("2.0(2q)")
	Version202r = UcsVersion("2.0(2r)")
	Version203a = UcsVersion("2.0(3a)")
	Version204b = UcsVersion("2.0(4b)")
	Version211a = UcsVersion("2.1(1a)")
	Version212a = UcsVersion("2.1(2a)")
	Version213a = UcsVersion("2.1(3a)")
	Version221b = UcsVersion("2.2(1b)")

_ManagedObjectMeta = {

		"MacpoolPool": {
			"Assigned":UcsPropertyMeta("Assigned", "assigned", "uint", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"AssignmentOrder":UcsPropertyMeta("AssignmentOrder", "assignmentOrder", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadWrite, 0x1L, None, None, None, ["default", "sequential"], ["0-4294967295"]),
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, 0x2L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Descr":UcsPropertyMeta("Descr", "descr", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x4L, None, None, """[ !#$%&\(\)\*\+,\-\./:;\?@\[\]_\{\|\}~a-zA-Z0-9]{0,256}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x8L, 0, 256, None, [], ["0-4294967295"]),
			"IntId":UcsPropertyMeta("IntId", "intId", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, None, None, None, None, ["none"], ["0-4294967295"]),
			"Name":UcsPropertyMeta("Name", "name", "string", _VersionMeta.Version101e, UcsPropertyMeta.Naming, 0x10L, None, None, """[\-\.:_a-zA-Z0-9]{1,32}""", [], ["0-4294967295"]),
			"PolicyLevel":UcsPropertyMeta("PolicyLevel", "policyLevel", "uint", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"PolicyOwner":UcsPropertyMeta("PolicyOwner", "policyOwner", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadWrite, 0x20L, None, None, None, ["local", "pending-policy", "policy"], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x40L, 0, 256, None, [], ["0-4294967295"]),
			"Size":UcsPropertyMeta("Size", "size", "uint", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x80L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Meta":UcsMoMeta("MacpoolPool", "macpoolPool", "mac-pool-[Name]", _VersionMeta.Version101e, "InputOutput", 0xffL, [], [u'faultInst', u'macpoolBlock', u'macpoolPooled'], ["Add", "Get", "Remove", "Set"], ["admin", "ls-network-policy"]),
			},

		"SwFcMon": {
			"AdminState":UcsPropertyMeta("AdminState", "adminState", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadWrite, 0x1L, None, None, None, ["disabled", "enabled"], ["0-4294967295"]),
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version141i, UcsPropertyMeta.Internal, 0x2L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, 0x4L, 0, 256, None, [], ["0-4294967295"]),
			"FsmDescr":UcsPropertyMeta("FsmDescr", "fsmDescr", "string", _VersionMeta.Version141i, UcsPropertyMeta.Internal, None, None, None, None, [], ["0-4294967295"]),
			"FsmPrev":UcsPropertyMeta("FsmPrev", "fsmPrev", "string", _VersionMeta.Version141i, UcsPropertyMeta.Internal, None, None, None, None, ["DeployBegin", "DeployFail", "DeploySuccess", "DeployUpdateFcMon", "nop"], ["0-4294967295"]),
			"FsmProgr":UcsPropertyMeta("FsmProgr", "fsmProgr", "byte", _VersionMeta.Version141i, UcsPropertyMeta.Internal, None, None, None, None, [], ["0-100"]),
			"FsmRmtInvErrCode":UcsPropertyMeta("FsmRmtInvErrCode", "fsmRmtInvErrCode", "string", _VersionMeta.Version141i, UcsPropertyMeta.Internal, None, None, None, None, ["ERR-2fa-auth-retry", "ERR-ACTIVATE-failed", "ERR-ACTIVATE-in-progress", "ERR-ACTIVATE-retry", "ERR-BIOS-TOKENS-OLD-BIOS", "ERR-BIOS-TOKENS-OLD-CIMC", "ERR-BIOS-network-boot-order-not-found", "ERR-BOARDCTRLUPDATE-ignore", "ERR-DIAG-cancelled", "ERR-DIAG-fsm-restarted", "ERR-DIAG-test-failed", "ERR-DNLD-authentication-failure", "ERR-DNLD-hostkey-mismatch", "ERR-DNLD-invalid-image", "ERR-DNLD-no-file", "ERR-DNLD-no-space", "ERR-DNS-delete-error", "ERR-DNS-get-error", "ERR-DNS-set-error", "ERR-Diagnostics-in-progress", "ERR-Diagnostics-memtest-in-progress", "ERR-Diagnostics-network-in-progress", "ERR-FILTER-illegal-format", "ERR-FSM-no-such-state", "ERR-HOST-fru-identity-mismatch", "ERR-HTTP-set-error", "ERR-HTTPS-set-error", "ERR-IBMC-analyze-results", "ERR-IBMC-connect-error", "ERR-IBMC-fru-retrieval-error", "ERR-IBMC-invalid-end-point-config", "ERR-IBMC-results-not-ready", "ERR-MAX-subscriptions-allowed-error", "ERR-MO-CONFIG-child-object-cant-be-configured", "ERR-MO-META-no-such-object-class", "ERR-MO-PROPERTY-no-such-property", "ERR-MO-PROPERTY-value-out-of-range", "ERR-MO-access-denied", "ERR-MO-deletion-rule-violation", "ERR-MO-duplicate-object", "ERR-MO-illegal-containment", "ERR-MO-illegal-creation", "ERR-MO-illegal-iterator-state", "ERR-MO-illegal-object-lifecycle-transition", "ERR-MO-naming-rule-violation", "ERR-MO-object-not-found", "ERR-MO-resource-allocation", "ERR-NTP-delete-error", "ERR-NTP-get-error", "ERR-NTP-set-error", "ERR-POWER-CAP-UNSUPPORTED", "ERR-SERVER-mis-connect", "ERR-SWITCH-invalid-if-config", "ERR-TOKEN-request-denied", "ERR-UNABLE-TO-FETCH-BIOS-SETTINGS", "ERR-UPDATE-failed", "ERR-UPDATE-in-progress", "ERR-UPDATE-retry", "ERR-aaa-config-modify-error", "ERR-acct-realm-set-error", "ERR-admin-passwd-set", "ERR-auth-issue", "ERR-auth-realm-get-error", "ERR-auth-realm-set-error", "ERR-authentication", "ERR-authorization-required", "ERR-cli-session-limit-reached", "ERR-create-keyring", "ERR-create-locale", "ERR-create-role", "ERR-create-user", "ERR-delete-locale", "ERR-delete-role", "ERR-delete-session", "ERR-delete-user", "ERR-efi-Diagnostics--in-progress", "ERR-enable-mgmt-conn", "ERR-ep-set-error", "ERR-get-max-http-user-sessions", "ERR-http-initializing", "ERR-insufficiently-equipped", "ERR-internal-error", "ERR-ldap-delete-error", "ERR-ldap-get-error", "ERR-ldap-group-modify-error", "ERR-ldap-group-set-error", "ERR-ldap-set-error", "ERR-locale-set-error", "ERR-max-userid-sessions-reached", "ERR-missing-method", "ERR-modify-locale", "ERR-modify-role", "ERR-modify-user", "ERR-modify-user-locale", "ERR-modify-user-role", "ERR-provider-group-modify-error", "ERR-provider-group-set-error", "ERR-radius-get-error", "ERR-radius-global-set-error", "ERR-radius-group-set-error", "ERR-radius-set-error", "ERR-request-timeout", "ERR-reset-adapter", "ERR-role-set-error", "ERR-secondary-node", "ERR-service-not-ready", "ERR-session-cache-full", "ERR-session-not-found", "ERR-set-network", "ERR-set-password-strength-check", "ERR-set-port-channel", "ERR-store-pre-login-banner-msg", "ERR-tacacs-enable-error", "ERR-tacacs-global-set-error", "ERR-tacacs-group-set-error", "ERR-tacacs-plus-get-error", "ERR-tacacs-set-error", "ERR-test-error-1", "ERR-test-error-2", "ERR-timezone-set-error", "ERR-user-account-expired", "ERR-user-set-error", "ERR-xml-parse-error", "none"], ["0-4294967295"]),
			"FsmRmtInvErrDescr":UcsPropertyMeta("FsmRmtInvErrDescr", "fsmRmtInvErrDescr", "string", _VersionMeta.Version141i, UcsPropertyMeta.Internal, None, 0, 510, None, [], ["0-4294967295"]),
			"FsmRmtInvRslt":UcsPropertyMeta("FsmRmtInvRslt", "fsmRmtInvRslt", "string", _VersionMeta.Version141i, UcsPropertyMeta.Internal, None, None, None, """((defaultValue|not-applicable|resource-unavailable|service-unavailable|intermittent-error|sw-defect|service-not-implemented-ignore|extend-timeout|capability-not-implemented-failure|illegal-fru|end-point-unavailable|failure|resource-capacity-exceeded|service-protocol-error|fw-defect|service-not-implemented-fail|task-reset|unidentified-fail|capability-not-supported|end-point-failed|fru-state-indeterminate|resource-dependency|fru-identity-indeterminate|internal-error|hw-defect|service-not-supported|fru-not-supported|end-point-protocol-error|capability-unavailable|fru-not-ready|capability-not-implemented-ignore|fru-info-malformed|timeout),){0,32}(defaultValue|not-applicable|resource-unavailable|service-unavailable|intermittent-error|sw-defect|service-not-implemented-ignore|extend-timeout|capability-not-implemented-failure|illegal-fru|end-point-unavailable|failure|resource-capacity-exceeded|service-protocol-error|fw-defect|service-not-implemented-fail|task-reset|unidentified-fail|capability-not-supported|end-point-failed|fru-state-indeterminate|resource-dependency|fru-identity-indeterminate|internal-error|hw-defect|service-not-supported|fru-not-supported|end-point-protocol-error|capability-unavailable|fru-not-ready|capability-not-implemented-ignore|fru-info-malformed|timeout){0,1}""", [], ["0-4294967295"]),
			"FsmStageDescr":UcsPropertyMeta("FsmStageDescr", "fsmStageDescr", "string", _VersionMeta.Version141i, UcsPropertyMeta.Internal, None, None, None, None, [], ["0-4294967295"]),
			"FsmStamp":UcsPropertyMeta("FsmStamp", "fsmStamp", "string", _VersionMeta.Version141i, UcsPropertyMeta.Internal, None, None, None, """([0-9]){4}-([0-9]){2}-([0-9]){2}T([0-9]){2}:([0-9]){2}:([0-9]){2}((\.([0-9]){3})){0,1}""", ["never"], ["0-4294967295"]),
			"FsmStatus":UcsPropertyMeta("FsmStatus", "fsmStatus", "string", _VersionMeta.Version141i, UcsPropertyMeta.Internal, None, None, None, None, ["DeployBegin", "DeployFail", "DeploySuccess", "DeployUpdateFcMon", "nop"], ["0-4294967295"]),
			"FsmTry":UcsPropertyMeta("FsmTry", "fsmTry", "byte", _VersionMeta.Version141i, UcsPropertyMeta.Internal, None, None, None, None, [], ["0-4294967295"]),
			"HasLastDest":UcsPropertyMeta("HasLastDest", "hasLastDest", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, None, None, None, None, ["false", "no", "true", "yes"], ["0-4294967295"]),
			"LifeCycle":UcsPropertyMeta("LifeCycle", "lifeCycle", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, None, None, None, None, ["deleted", "new", "normal"], ["0-4294967295"]),
			"Name":UcsPropertyMeta("Name", "name", "string", _VersionMeta.Version141i, UcsPropertyMeta.Naming, 0x8L, None, None, """[\-\.:_a-zA-Z0-9]{1,16}""", [], ["0-4294967295"]),
			"PeerDn":UcsPropertyMeta("PeerDn", "peerDn", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, 0x10L, 0, 256, None, [], ["0-4294967295"]),
			"Session":UcsPropertyMeta("Session", "session", "uint", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["1-255"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadWrite, 0x20L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"SwitchId":UcsPropertyMeta("SwitchId", "switchId", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadWrite, 0x40L, None, None, None, ["A", "B", "NONE"], ["0-4294967295"]),
			"Transport":UcsPropertyMeta("Transport", "transport", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, None, None, None, """((defaultValue|unknown|ether|dce|fc),){0,4}(defaultValue|unknown|ether|dce|fc){0,1}""", [], ["0-4294967295"]),
			"Type":UcsPropertyMeta("Type", "type", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, None, None, None, """((defaultValue|unknown|lan|san|ipc),){0,4}(defaultValue|unknown|lan|san|ipc){0,1}""", [], ["0-4294967295"]),
			"Meta":UcsMoMeta("SwFcMon", "swFcMon", "mon-[Name]", _VersionMeta.Version141i, "InputOutput", 0x7fL, [], [u'dcxVc', u'eventInst', u'faultInst', u'swFcMonDestEp', u'swFcMonFsm', u'swFcMonFsmTask', u'swFcMonSrcEp', u'swFcSanPc', u'swFcoeSanPc', u'swVsan'], ["Get"], ["read-only"]),
			},

		"EquipmentFanStatsHist": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version111j, UcsPropertyMeta.Internal, None, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"Id":UcsPropertyMeta("Id", "id", "ulong", _VersionMeta.Version111j, UcsPropertyMeta.Naming, None, None, None, None, [], ["0-4294967295"]),
			"MostRecent":UcsPropertyMeta("MostRecent", "mostRecent", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, ["false", "no", "true", "yes"], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"Speed":UcsPropertyMeta("Speed", "speed", "uint", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"SpeedAvg":UcsPropertyMeta("SpeedAvg", "speedAvg", "uint", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"SpeedMax":UcsPropertyMeta("SpeedMax", "speedMax", "uint", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"SpeedMin":UcsPropertyMeta("SpeedMin", "speedMin", "uint", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadWrite, None, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Suspect":UcsPropertyMeta("Suspect", "suspect", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, ["false", "no", "true", "yes"], ["0-4294967295"]),
			"Thresholded":UcsPropertyMeta("Thresholded", "thresholded", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"TimeCollected":UcsPropertyMeta("TimeCollected", "timeCollected", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, """([0-9]){4}-([0-9]){2}-([0-9]){2}T([0-9]){2}:([0-9]){2}:([0-9]){2}((\.([0-9]){3})){0,1}""", [], ["0-4294967295"]),
			"Meta":UcsMoMeta("EquipmentFanStatsHist", "equipmentFanStatsHist", "[Id]", _VersionMeta.Version111j, "OutputOnly", 0x0L, [], [], ["Get"], ["read-only"]),
			},

		"EquipmentBeaconLed": {
			"AdminState":UcsPropertyMeta("AdminState", "adminState", "string", _VersionMeta.Version201m, UcsPropertyMeta.ReadWrite, 0x1L, None, None, None, ["blinking", "eth", "fc", "off", "on"], ["0-4294967295"]),
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version201m, UcsPropertyMeta.Internal, 0x2L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Color":UcsPropertyMeta("Color", "color", "string", _VersionMeta.Version201m, UcsPropertyMeta.ReadOnly, None, None, None, None, ["amber", "blue", "green", "red", "unknown"], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version201m, UcsPropertyMeta.ReadOnly, 0x4L, 0, 256, None, [], ["0-4294967295"]),
			"FsmDescr":UcsPropertyMeta("FsmDescr", "fsmDescr", "string", _VersionMeta.Version201m, UcsPropertyMeta.Internal, None, None, None, None, [], ["0-4294967295"]),
			"FsmPrev":UcsPropertyMeta("FsmPrev", "fsmPrev", "string", _VersionMeta.Version201m, UcsPropertyMeta.Internal, None, None, None, None, ["IlluminateBegin", "IlluminateExecuteA", "IlluminateExecuteB", "IlluminateFail", "IlluminateSuccess", "nop"], ["0-4294967295"]),
			"FsmProgr":UcsPropertyMeta("FsmProgr", "fsmProgr", "byte", _VersionMeta.Version201m, UcsPropertyMeta.Internal, None, None, None, None, [], ["0-100"]),
			"FsmRmtInvErrCode":UcsPropertyMeta("FsmRmtInvErrCode", "fsmRmtInvErrCode", "string", _VersionMeta.Version201m, UcsPropertyMeta.Internal, None, None, None, None, ["ERR-2fa-auth-retry", "ERR-ACTIVATE-failed", "ERR-ACTIVATE-in-progress", "ERR-ACTIVATE-retry", "ERR-BIOS-TOKENS-OLD-BIOS", "ERR-BIOS-TOKENS-OLD-CIMC", "ERR-BIOS-network-boot-order-not-found", "ERR-BOARDCTRLUPDATE-ignore", "ERR-DIAG-cancelled", "ERR-DIAG-fsm-restarted", "ERR-DIAG-test-failed", "ERR-DNLD-authentication-failure", "ERR-DNLD-hostkey-mismatch", "ERR-DNLD-invalid-image", "ERR-DNLD-no-file", "ERR-DNLD-no-space", "ERR-DNS-delete-error", "ERR-DNS-get-error", "ERR-DNS-set-error", "ERR-Diagnostics-in-progress", "ERR-Diagnostics-memtest-in-progress", "ERR-Diagnostics-network-in-progress", "ERR-FILTER-illegal-format", "ERR-FSM-no-such-state", "ERR-HOST-fru-identity-mismatch", "ERR-HTTP-set-error", "ERR-HTTPS-set-error", "ERR-IBMC-analyze-results", "ERR-IBMC-connect-error", "ERR-IBMC-fru-retrieval-error", "ERR-IBMC-invalid-end-point-config", "ERR-IBMC-results-not-ready", "ERR-MAX-subscriptions-allowed-error", "ERR-MO-CONFIG-child-object-cant-be-configured", "ERR-MO-META-no-such-object-class", "ERR-MO-PROPERTY-no-such-property", "ERR-MO-PROPERTY-value-out-of-range", "ERR-MO-access-denied", "ERR-MO-deletion-rule-violation", "ERR-MO-duplicate-object", "ERR-MO-illegal-containment", "ERR-MO-illegal-creation", "ERR-MO-illegal-iterator-state", "ERR-MO-illegal-object-lifecycle-transition", "ERR-MO-naming-rule-violation", "ERR-MO-object-not-found", "ERR-MO-resource-allocation", "ERR-NTP-delete-error", "ERR-NTP-get-error", "ERR-NTP-set-error", "ERR-POWER-CAP-UNSUPPORTED", "ERR-SERVER-mis-connect", "ERR-SWITCH-invalid-if-config", "ERR-TOKEN-request-denied", "ERR-UNABLE-TO-FETCH-BIOS-SETTINGS", "ERR-UPDATE-failed", "ERR-UPDATE-in-progress", "ERR-UPDATE-retry", "ERR-aaa-config-modify-error", "ERR-acct-realm-set-error", "ERR-admin-passwd-set", "ERR-auth-issue", "ERR-auth-realm-get-error", "ERR-auth-realm-set-error", "ERR-authentication", "ERR-authorization-required", "ERR-cli-session-limit-reached", "ERR-create-keyring", "ERR-create-locale", "ERR-create-role", "ERR-create-user", "ERR-delete-locale", "ERR-delete-role", "ERR-delete-session", "ERR-delete-user", "ERR-efi-Diagnostics--in-progress", "ERR-enable-mgmt-conn", "ERR-ep-set-error", "ERR-get-max-http-user-sessions", "ERR-http-initializing", "ERR-insufficiently-equipped", "ERR-internal-error", "ERR-ldap-delete-error", "ERR-ldap-get-error", "ERR-ldap-group-modify-error", "ERR-ldap-group-set-error", "ERR-ldap-set-error", "ERR-locale-set-error", "ERR-max-userid-sessions-reached", "ERR-missing-method", "ERR-modify-locale", "ERR-modify-role", "ERR-modify-user", "ERR-modify-user-locale", "ERR-modify-user-role", "ERR-provider-group-modify-error", "ERR-provider-group-set-error", "ERR-radius-get-error", "ERR-radius-global-set-error", "ERR-radius-group-set-error", "ERR-radius-set-error", "ERR-request-timeout", "ERR-reset-adapter", "ERR-role-set-error", "ERR-secondary-node", "ERR-service-not-ready", "ERR-session-cache-full", "ERR-session-not-found", "ERR-set-network", "ERR-set-password-strength-check", "ERR-set-port-channel", "ERR-store-pre-login-banner-msg", "ERR-tacacs-enable-error", "ERR-tacacs-global-set-error", "ERR-tacacs-group-set-error", "ERR-tacacs-plus-get-error", "ERR-tacacs-set-error", "ERR-test-error-1", "ERR-test-error-2", "ERR-timezone-set-error", "ERR-user-account-expired", "ERR-user-set-error", "ERR-xml-parse-error", "none"], ["0-4294967295"]),
			"FsmRmtInvErrDescr":UcsPropertyMeta("FsmRmtInvErrDescr", "fsmRmtInvErrDescr", "string", _VersionMeta.Version201m, UcsPropertyMeta.Internal, None, 0, 510, None, [], ["0-4294967295"]),
			"FsmRmtInvRslt":UcsPropertyMeta("FsmRmtInvRslt", "fsmRmtInvRslt", "string", _VersionMeta.Version201m, UcsPropertyMeta.Internal, None, None, None, """((defaultValue|not-applicable|resource-unavailable|service-unavailable|intermittent-error|sw-defect|service-not-implemented-ignore|extend-timeout|capability-not-implemented-failure|illegal-fru|end-point-unavailable|failure|resource-capacity-exceeded|service-protocol-error|fw-defect|service-not-implemented-fail|task-reset|unidentified-fail|capability-not-supported|end-point-failed|fru-state-indeterminate|resource-dependency|fru-identity-indeterminate|internal-error|hw-defect|service-not-supported|fru-not-supported|end-point-protocol-error|capability-unavailable|fru-not-ready|capability-not-implemented-ignore|fru-info-malformed|timeout),){0,32}(defaultValue|not-applicable|resource-unavailable|service-unavailable|intermittent-error|sw-defect|service-not-implemented-ignore|extend-timeout|capability-not-implemented-failure|illegal-fru|end-point-unavailable|failure|resource-capacity-exceeded|service-protocol-error|fw-defect|service-not-implemented-fail|task-reset|unidentified-fail|capability-not-supported|end-point-failed|fru-state-indeterminate|resource-dependency|fru-identity-indeterminate|internal-error|hw-defect|service-not-supported|fru-not-supported|end-point-protocol-error|capability-unavailable|fru-not-ready|capability-not-implemented-ignore|fru-info-malformed|timeout){0,1}""", [], ["0-4294967295"]),
			"FsmStageDescr":UcsPropertyMeta("FsmStageDescr", "fsmStageDescr", "string", _VersionMeta.Version201m, UcsPropertyMeta.Internal, None, None, None, None, [], ["0-4294967295"]),
			"FsmStamp":UcsPropertyMeta("FsmStamp", "fsmStamp", "string", _VersionMeta.Version201m, UcsPropertyMeta.Internal, None, None, None, """([0-9]){4}-([0-9]){2}-([0-9]){2}T([0-9]){2}:([0-9]){2}:([0-9]){2}((\.([0-9]){3})){0,1}""", ["never"], ["0-4294967295"]),
			"FsmStatus":UcsPropertyMeta("FsmStatus", "fsmStatus", "string", _VersionMeta.Version201m, UcsPropertyMeta.Internal, None, None, None, None, ["IlluminateBegin", "IlluminateExecuteA", "IlluminateExecuteB", "IlluminateFail", "IlluminateSuccess", "nop"], ["0-4294967295"]),
			"FsmTry":UcsPropertyMeta("FsmTry", "fsmTry", "byte", _VersionMeta.Version201m, UcsPropertyMeta.Internal, None, None, None, None, [], ["0-4294967295"]),
			"Id":UcsPropertyMeta("Id", "id", "uint", _VersionMeta.Version201m, UcsPropertyMeta.ReadWrite, 0x8L, None, None, None, [], ["0-4294967295"]),
			"Name":UcsPropertyMeta("Name", "name", "string", _VersionMeta.Version201m, UcsPropertyMeta.ReadWrite, 0x10L, None, None, """[\-\.:_a-zA-Z0-9]{0,16}""", [], ["0-4294967295"]),
			"OperState":UcsPropertyMeta("OperState", "operState", "string", _VersionMeta.Version201m, UcsPropertyMeta.ReadOnly, None, None, None, None, ["blinking", "eth", "fc", "off", "on", "unknown"], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version201m, UcsPropertyMeta.ReadOnly, 0x20L, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version201m, UcsPropertyMeta.ReadWrite, 0x40L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Meta":UcsMoMeta("EquipmentBeaconLed", "equipmentBeaconLed", "beacon", _VersionMeta.Version201m, "InputOutput", 0x7fL, [], [u'equipmentBeaconLedFsm', u'equipmentBeaconLedFsmTask', u'eventInst', u'faultInst'], ["Get"], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"]),
			},

		"SwFcMonFsmTask": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version141i, UcsPropertyMeta.Internal, None, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Completion":UcsPropertyMeta("Completion", "completion", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, None, None, None, None, ["cancelled", "completed", "processing", "scheduled"], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"Flags":UcsPropertyMeta("Flags", "flags", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, None, None, None, """(defaultValue){0,1}""", [], ["0-4294967295"]),
			"Item":UcsPropertyMeta("Item", "item", "string", _VersionMeta.Version141i, UcsPropertyMeta.Naming, None, None, None, None, ["Deploy", "nop"], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"SeqId":UcsPropertyMeta("SeqId", "seqId", "uint", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadWrite, None, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Meta":UcsMoMeta("SwFcMonFsmTask", "swFcMonFsmTask", "task-[Item]", _VersionMeta.Version141i, "OutputOnly", 0x0L, [], [], [None], [""]),
			},

		"DomainServerFeatureCont": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version221b, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadOnly, 0x2L, 0, 256, None, [], ["0-4294967295"]),
			"FltAggr":UcsPropertyMeta("FltAggr", "fltAggr", "ulong", _VersionMeta.Version221b, UcsPropertyMeta.Internal, None, None, None, None, [], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadOnly, 0x4L, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadWrite, 0x8L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Meta":UcsMoMeta("DomainServerFeatureCont", "domainServerFeatureCont", "server-feature-cont", _VersionMeta.Version221b, "InputOutput", 0xfL, [], [u'domainEnvironmentFeature', u'domainNetworkFeature', u'domainServerFeature', u'domainStorageFeature'], [None], ["admin", "read-only"]),
			},

		"VnicIPv4If": {
			"Addr":UcsPropertyMeta("Addr", "addr", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, 0, 256, """((([0-9]){1,3}\.){3}[0-9]{1,3})""", [], ["0-4294967295"]),
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"ConfigQualifier":UcsPropertyMeta("ConfigQualifier", "configQualifier", "string", _VersionMeta.Version212a, UcsPropertyMeta.ReadOnly, None, None, None, """((defaultValue|not-applicable|adaptor-protected-eth-capability|vif-resources-overprovisioned|unresolved-remote-vlan-name|invalid-wwn|service-profile-virtualization-conflict|fcoe-capacity|wwpn-derivation-virtualized-port|unresolved-vlan-name|pinning-vlan-mismatch|adaptor-requirement|vnic-not-ha-ready|unresolved-remote-vsan-name|mac-derivation-virtualized-port|vnic-virtualization-conflict|vnic-vlan-assignment-error|insufficient-vhba-capacity|inaccessible-vlan|unable-to-update-ucsm|connection-placement|vnic-vcon-provisioning-change|missing-primary-vlan|adaptor-fcoe-capability|vfc-vnic-pvlan-conflict|virtualization-not-supported|unresolved-vsan-name|insufficient-vnic-capacity|unassociated-vlan|dynamic-vf-vnic|wwpn-assignment|pinned-target-misconfig),){0,31}(defaultValue|not-applicable|adaptor-protected-eth-capability|vif-resources-overprovisioned|unresolved-remote-vlan-name|invalid-wwn|service-profile-virtualization-conflict|fcoe-capacity|wwpn-derivation-virtualized-port|unresolved-vlan-name|pinning-vlan-mismatch|adaptor-requirement|vnic-not-ha-ready|unresolved-remote-vsan-name|mac-derivation-virtualized-port|vnic-virtualization-conflict|vnic-vlan-assignment-error|insufficient-vhba-capacity|inaccessible-vlan|unable-to-update-ucsm|connection-placement|vnic-vcon-provisioning-change|missing-primary-vlan|adaptor-fcoe-capability|vfc-vnic-pvlan-conflict|virtualization-not-supported|unresolved-vsan-name|insufficient-vnic-capacity|unassociated-vlan|dynamic-vf-vnic|wwpn-assignment|pinned-target-misconfig){0,1}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x2L, 0, 256, None, [], ["0-4294967295"]),
			"Name":UcsPropertyMeta("Name", "name", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x4L, None, None, """[\-\.:_a-zA-Z0-9]{0,16}""", [], ["0-4294967295"]),
			"OperState":UcsPropertyMeta("OperState", "operState", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, ["down", "failed", "indeterminate", "up"], ["0-4294967295"]),
			"OperVnetDn":UcsPropertyMeta("OperVnetDn", "operVnetDn", "string", _VersionMeta.Version212a, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"OperVnetName":UcsPropertyMeta("OperVnetName", "operVnetName", "string", _VersionMeta.Version212a, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"Owner":UcsPropertyMeta("Owner", "owner", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, ["conn_policy", "logical", "physical", "policy", "unknown"], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x8L, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x10L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"SwitchId":UcsPropertyMeta("SwitchId", "switchId", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, ["A", "B", "NONE"], ["0-4294967295"]),
			"Type":UcsPropertyMeta("Type", "type", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, ["ether", "fc", "ipc", "scsi", "unknown"], ["0-4294967295"]),
			"Vnet":UcsPropertyMeta("Vnet", "vnet", "uint", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["1-4093"]),
			"Meta":UcsMoMeta("VnicIPv4If", "vnicIPv4If", "ipv4", _VersionMeta.Version101e, "InputOutput", 0x1fL, [], [u'fabricNetflowIPv4Addr', u'vnicIPv4Dhcp', u'vnicIPv4Dns', u'vnicIPv4IscsiAddr', u'vnicIPv4PooledIscsiAddr', u'vnicIPv4StaticRoute', u'vnicIpV4MgmtPooledAddr', u'vnicIpV4PooledAddr', u'vnicIpV4ProfDerivedAddr', u'vnicIpV4StaticAddr'], ["Add", "Get"], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server", "ls-storage"]),
			},

		"SwatTrigger": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x2L, 0, 256, None, [], ["0-4294967295"]),
			"Name":UcsPropertyMeta("Name", "name", "string", _VersionMeta.Version101e, UcsPropertyMeta.Naming, 0x4L, None, None, """[\-\.:_a-zA-Z0-9]{1,16}""", [], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x8L, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x10L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Type":UcsPropertyMeta("Type", "type", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x20L, None, None, None, ["AND", "OR"], ["0-4294967295"]),
			"Meta":UcsMoMeta("SwatTrigger", "swatTrigger", "trigger-[Name]", _VersionMeta.Version101e, "InputOutput", 0x3fL, [], [u'swatCondition', u'swatTrigger'], ["Get"], ["admin"]),
			},

		"AdaptorCapSpec": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x2L, 0, 256, None, [], ["0-4294967295"]),
			"FwVersionHi":UcsPropertyMeta("FwVersionHi", "fwVersionHi", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, 0, 510, None, [], ["0-4294967295"]),
			"FwVersionLo":UcsPropertyMeta("FwVersionLo", "fwVersionLo", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, 0, 510, None, [], ["0-4294967295"]),
			"FwVersionOpr":UcsPropertyMeta("FwVersionOpr", "fwVersionOpr", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, ["gt", "lt", "none", "range"], ["0-4294967295"]),
			"Maximum":UcsPropertyMeta("Maximum", "maximum", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, ["unspecified"], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x4L, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x8L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Type":UcsPropertyMeta("Type", "type", "string", _VersionMeta.Version101e, UcsPropertyMeta.Naming, 0x10L, None, None, None, ["eth-flow-monitoring-netflow", "fcoe", "non-virtualized-eth-if", "non-virtualized-fc-if", "path-encap-consolidated", "path-encap-virtual", "protected-eth-if", "protected-fc-if", "protected-fcoe", "uplink-aggregation", "virtualized-eth-if", "virtualized-eth-sriov", "virtualized-eth-sriov-usnic", "virtualized-eth-vmq", "virtualized-fc-if", "virtualized-fc-sriov", "virtualized-scsi-if"], ["0-4294967295"]),
			"Meta":UcsMoMeta("AdaptorCapSpec", "adaptorCapSpec", "cap-[Type]", _VersionMeta.Version101e, "InputOutput", 0x1fL, [], [], ["Get"], ["admin", "pn-policy"]),
			},

		"FabricFlowMonExporterProfile": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version221b, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Descr":UcsPropertyMeta("Descr", "descr", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadWrite, 0x2L, None, None, """[ !#$%&\(\)\*\+,\-\./:;\?@\[\]_\{\|\}~a-zA-Z0-9]{0,256}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadOnly, 0x4L, 0, 256, None, [], ["0-4294967295"]),
			"IntId":UcsPropertyMeta("IntId", "intId", "string", _VersionMeta.Version221b, UcsPropertyMeta.Internal, None, None, None, None, ["none"], ["0-4294967295"]),
			"Name":UcsPropertyMeta("Name", "name", "string", _VersionMeta.Version221b, UcsPropertyMeta.Naming, 0x8L, None, None, """[\-\.:_a-zA-Z0-9]{1,16}""", [], ["0-4294967295"]),
			"PolicyLevel":UcsPropertyMeta("PolicyLevel", "policyLevel", "uint", _VersionMeta.Version221b, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"PolicyOwner":UcsPropertyMeta("PolicyOwner", "policyOwner", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadWrite, 0x10L, None, None, None, ["local", "pending-policy", "policy"], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadOnly, 0x20L, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadWrite, 0x40L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Meta":UcsMoMeta("FabricFlowMonExporterProfile", "fabricFlowMonExporterProfile", "flow-exporter-profile-[Name]", _VersionMeta.Version221b, "InputOutput", 0x7fL, [], [u'vnicEtherIf'], [None], ["admin", "ext-lan-config", "ext-lan-policy"]),
			},

		"FabricEp": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x2L, 0, 256, None, [], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x4L, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x8L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Meta":UcsMoMeta("FabricEp", "fabricEp", "fabric", _VersionMeta.Version101e, "InputOutput", 0xfL, [], [u'dcxUniverse', u'etherPortChanIdUniverse', u'fabricDceSrv', u'fabricEpMgr', u'fabricEthEstcCloud', u'fabricFcEstcCloud', u'fabricLanAccessMgr', u'fabricLanCloud', u'fabricLanMonCloud', u'fabricSanCloud', u'fabricSanMonCloud', u'fabricZoneIdUniverse'], ["Get"], ["admin"]),
			},

		"OrgOrg": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Descr":UcsPropertyMeta("Descr", "descr", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadWrite, 0x2L, None, None, """[ !#$%&\(\)\*\+,\-\./:;\?@\[\]_\{\|\}~a-zA-Z0-9]{0,256}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x4L, 0, 256, None, [], ["0-4294967295"]),
			"FltAggr":UcsPropertyMeta("FltAggr", "fltAggr", "ulong", _VersionMeta.Version101e, UcsPropertyMeta.Internal, None, None, None, None, [], ["0-4294967295"]),
			"Level":UcsPropertyMeta("Level", "level", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, ["1", "2", "3", "4", "5", "root"], ["0-4294967295"]),
			"Name":UcsPropertyMeta("Name", "name", "string", _VersionMeta.Version101e, UcsPropertyMeta.Naming, 0x8L, None, None, """[\-\.:_a-zA-Z0-9]{1,16}""", [], ["0-4294967295"]),
			"PermAccess":UcsPropertyMeta("PermAccess", "permAccess", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, ["false", "no", "true", "yes"], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x10L, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x20L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Meta":UcsMoMeta("OrgOrg", "orgOrg", "org-[Name]", _VersionMeta.Version101e, "InputOutput", 0x3fL, [], [u'aaaEpAuthProfile', u'adaptorHostEthIfProfile', u'adaptorHostFcIfProfile', u'adaptorHostIscsiIfProfile', u'biosVProfile', u'computeAutoconfigPolicy', u'computeBladeDiscPolicy', u'computeBladeInheritPolicy', u'computeChassisConnPolicy', u'computeChassisDiscPolicy', u'computeMemoryConfigPolicy', u'computePool', u'computePoolingPolicy', u'computePsuPolicy', u'computeQual', u'computeScrubPolicy', u'computeServerDiscPolicy', u'computeServerMgmtPolicy', u'diagRunPolicy', u'epqosDefinition', u'epqosDefinitionDelTask', u'fabricMulticastPolicy', u'fabricOrgVlanPolicy', u'fabricUdldPolicy', u'fabricVConProfile', u'fabricVlanGroupReq', u'fabricVlanPermit', u'fabricVlanReq', u'faultSuppressTask', u'fcpoolInitiators', u'firmwareAutoSyncPolicy', u'firmwareCatalogPack', u'firmwareComputeHostPack', u'firmwareComputeMgmtPack', u'firmwareInfraPack', u'hostimgPolicy', u'imgprovPolicy', u'imgsecPolicy', u'ippoolPool', u'iqnpoolPool', u'iscsiAuthProfile', u'lsAgentPolicy', u'lsServer', u'lsTier', u'lsbootPolicy', u'lsmaintMaintPolicy', u'macpoolPool', u'mgmtBackupPolicy', u'mgmtCfgExportPolicy', u'nwctrlDefinition', u'orgOrg', u'orgSourceMask', u'powerGroupAdditionPolicy', u'powerMgmtPolicy', u'powerPlacement', u'powerPolicy', u'solPolicy', u'statsThresholdPolicy', u'storageConnectionPolicy', u'storageLocalDiskConfigPolicy', u'sysdebugMEpLogPolicy', u'trigTest', u'uuidpoolPool', u'vmLifeCyclePolicy', u'vnicDynamicConPolicy', u'vnicFcGroupTempl', u'vnicLanConnPolicy', u'vnicLanConnTempl', u'vnicSanConnPolicy', u'vnicSanConnTempl', u'vnicUsnicConPolicy', u'vnicVhbaBehPolicy', u'vnicVmqConPolicy', u'vnicVnicBehPolicy'], ["Add", "Get", "Remove", "Set"], ["admin", "org-management"]),
			},

		"FabricSanPinGroup": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Descr":UcsPropertyMeta("Descr", "descr", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x2L, None, None, """[ !#$%&\(\)\*\+,\-\./:;\?@\[\]_\{\|\}~a-zA-Z0-9]{0,256}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x4L, 0, 256, None, [], ["0-4294967295"]),
			"IntId":UcsPropertyMeta("IntId", "intId", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, None, None, None, None, ["none"], ["0-4294967295"]),
			"Name":UcsPropertyMeta("Name", "name", "string", _VersionMeta.Version101e, UcsPropertyMeta.Naming, 0x8L, None, None, """[\-\.:_a-zA-Z0-9]{1,16}""", [], ["0-4294967295"]),
			"PolicyLevel":UcsPropertyMeta("PolicyLevel", "policyLevel", "uint", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"PolicyOwner":UcsPropertyMeta("PolicyOwner", "policyOwner", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadWrite, 0x10L, None, None, None, ["local", "pending-policy", "policy"], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x20L, 0, 256, None, [], ["0-4294967295"]),
			"Size":UcsPropertyMeta("Size", "size", "uint", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x40L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Meta":UcsMoMeta("FabricSanPinGroup", "fabricSanPinGroup", "san-pin-group-[Name]", _VersionMeta.Version101e, "InputOutput", 0x7fL, [], [u'fabricSanPinTarget', u'faultInst'], ["Add", "Get", "Remove", "Set"], ["admin", "ext-san-config", "ext-san-policy"]),
			},

		"EquipmentFexEnvStats": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version141i, UcsPropertyMeta.Internal, None, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Die1":UcsPropertyMeta("Die1", "die1", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, None, None, None, None, ["N/A"], ["0-4294967295"]),
			"Die1Avg":UcsPropertyMeta("Die1Avg", "die1Avg", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, None, None, None, None, ["N/A"], ["0-4294967295"]),
			"Die1Max":UcsPropertyMeta("Die1Max", "die1Max", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, None, None, None, None, ["N/A"], ["0-4294967295"]),
			"Die1Min":UcsPropertyMeta("Die1Min", "die1Min", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, None, None, None, None, ["N/A"], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"Inlet":UcsPropertyMeta("Inlet", "inlet", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, None, None, None, None, ["N/A"], ["0-4294967295"]),
			"Inlet1":UcsPropertyMeta("Inlet1", "inlet1", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, None, None, None, None, ["N/A"], ["0-4294967295"]),
			"Inlet1Avg":UcsPropertyMeta("Inlet1Avg", "inlet1Avg", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, None, None, None, None, ["N/A"], ["0-4294967295"]),
			"Inlet1Max":UcsPropertyMeta("Inlet1Max", "inlet1Max", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, None, None, None, None, ["N/A"], ["0-4294967295"]),
			"Inlet1Min":UcsPropertyMeta("Inlet1Min", "inlet1Min", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, None, None, None, None, ["N/A"], ["0-4294967295"]),
			"InletAvg":UcsPropertyMeta("InletAvg", "inletAvg", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, None, None, None, None, ["N/A"], ["0-4294967295"]),
			"InletMax":UcsPropertyMeta("InletMax", "inletMax", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, None, None, None, None, ["N/A"], ["0-4294967295"]),
			"InletMin":UcsPropertyMeta("InletMin", "inletMin", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, None, None, None, None, ["N/A"], ["0-4294967295"]),
			"InputStatus":UcsPropertyMeta("InputStatus", "inputStatus", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, None, 0, 510, None, [], ["0-4294967295"]),
			"Intervals":UcsPropertyMeta("Intervals", "intervals", "uint", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"Outlet1":UcsPropertyMeta("Outlet1", "outlet1", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, None, None, None, None, ["N/A"], ["0-4294967295"]),
			"Outlet1Avg":UcsPropertyMeta("Outlet1Avg", "outlet1Avg", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, None, None, None, None, ["N/A"], ["0-4294967295"]),
			"Outlet1Max":UcsPropertyMeta("Outlet1Max", "outlet1Max", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, None, None, None, None, ["N/A"], ["0-4294967295"]),
			"Outlet1Min":UcsPropertyMeta("Outlet1Min", "outlet1Min", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, None, None, None, None, ["N/A"], ["0-4294967295"]),
			"Outlet2":UcsPropertyMeta("Outlet2", "outlet2", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, None, None, None, None, ["N/A"], ["0-4294967295"]),
			"Outlet2Avg":UcsPropertyMeta("Outlet2Avg", "outlet2Avg", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, None, None, None, None, ["N/A"], ["0-4294967295"]),
			"Outlet2Max":UcsPropertyMeta("Outlet2Max", "outlet2Max", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, None, None, None, None, ["N/A"], ["0-4294967295"]),
			"Outlet2Min":UcsPropertyMeta("Outlet2Min", "outlet2Min", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, None, None, None, None, ["N/A"], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadWrite, None, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Suspect":UcsPropertyMeta("Suspect", "suspect", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, None, None, None, None, ["false", "no", "true", "yes"], ["0-4294967295"]),
			"Thresholded":UcsPropertyMeta("Thresholded", "thresholded", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"TimeCollected":UcsPropertyMeta("TimeCollected", "timeCollected", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, None, None, None, """([0-9]){4}-([0-9]){2}-([0-9]){2}T([0-9]){2}:([0-9]){2}:([0-9]){2}((\.([0-9]){3})){0,1}""", [], ["0-4294967295"]),
			"Update":UcsPropertyMeta("Update", "update", "uint", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"Meta":UcsMoMeta("EquipmentFexEnvStats", "equipmentFexEnvStats", "env-stats", _VersionMeta.Version141i, "OutputOnly", 0x0L, [], [u'equipmentFexEnvStatsHist'], ["Get"], ["admin", "operations", "read-only"]),
			},

		"BiosVfDirectCacheAccess": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version111j, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, 0x2L, 0, 256, None, [], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, 0x4L, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadWrite, 0x8L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"VpDirectCacheAccess":UcsPropertyMeta("VpDirectCacheAccess", "vpDirectCacheAccess", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadWrite, 0x10L, None, None, None, ["disabled", "enabled", "platform-default", "platform-recommended"], ["0-4294967295"]),
			"Meta":UcsMoMeta("BiosVfDirectCacheAccess", "biosVfDirectCacheAccess", "Direct-Cache-Access", _VersionMeta.Version111j, "InputOutput", 0x1fL, [], [], ["Get", "Set"], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"]),
			},

		"DhcpAcquired": {
			"Acqts":UcsPropertyMeta("Acqts", "acqts", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, None, None, None, """([0-9]){4}-([0-9]){2}-([0-9]){2}T([0-9]){2}:([0-9]){2}:([0-9]){2}((\.([0-9]){3})){0,1}""", [], ["0-4294967295"]),
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version141i, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Cookie":UcsPropertyMeta("Cookie", "cookie", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, None, 0, 510, None, [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, 0x2L, 0, 256, None, [], ["0-4294967295"]),
			"Ends":UcsPropertyMeta("Ends", "ends", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, None, None, None, """([0-9]){4}-([0-9]){2}-([0-9]){2}T([0-9]){2}:([0-9]){2}:([0-9]){2}((\.([0-9]){3})){0,1}""", [], ["0-4294967295"]),
			"Ip":UcsPropertyMeta("Ip", "ip", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, None, 0, 256, """((([0-9]){1,3}\.){3}[0-9]{1,3})""", [], ["0-4294967295"]),
			"Mac":UcsPropertyMeta("Mac", "mac", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, None, None, None, """(([0-9a-fA-F][0-9a-fA-F]:){5}([0-9a-fA-F][0-9a-fA-F]))|0""", [], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, 0x4L, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadWrite, 0x8L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"SysId":UcsPropertyMeta("SysId", "sysId", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, None, 0, 510, None, [], ["0-4294967295"]),
			"Meta":UcsMoMeta("DhcpAcquired", "dhcpAcquired", "lease", _VersionMeta.Version141i, "InputOutput", 0xfL, [], [], ["Get"], ["read-only"]),
			},

		"ApeSANBoot": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x2L, 0, 256, None, [], ["0-4294967295"]),
			"Hostname":UcsPropertyMeta("Hostname", "hostname", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"IsHostAgentPresent":UcsPropertyMeta("IsHostAgentPresent", "isHostAgentPresent", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, ["false", "no", "true", "yes"], ["0-4294967295"]),
			"KernelName":UcsPropertyMeta("KernelName", "kernelName", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"KernelRelease":UcsPropertyMeta("KernelRelease", "kernelRelease", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"KernelVersion":UcsPropertyMeta("KernelVersion", "kernelVersion", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"Name":UcsPropertyMeta("Name", "name", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x4L, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x8L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"TargetLun":UcsPropertyMeta("TargetLun", "targetLun", "uint", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x10L, None, None, None, [], ["0-4294967295"]),
			"TargetWWN":UcsPropertyMeta("TargetWWN", "targetWWN", "string", _VersionMeta.Version101e, UcsPropertyMeta.Naming, 0x20L, 0, 256, """(([A-Fa-f0-9][A-Fa-f0-9]:){7}[A-Fa-f0-9][A-Fa-f0-9])|0""", [], ["0-4294967295"]),
			"Type":UcsPropertyMeta("Type", "type", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, ["Linux", "PnuOS", "Solaris", "VMWareESX", "Windows", "unspecified"], ["0-4294967295"]),
			"Meta":UcsMoMeta("ApeSANBoot", "apeSANBoot", "sanboot-[TargetWWN]", _VersionMeta.Version101e, "InputOutput", 0x3fL, [], [], [None], ["admin"]),
			},

		"AdaptorEthOffloadProfile": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x2L, 0, 256, None, [], ["0-4294967295"]),
			"LargeReceive":UcsPropertyMeta("LargeReceive", "largeReceive", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x4L, None, None, None, ["disabled", "enabled"], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x8L, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x10L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"TcpRxChecksum":UcsPropertyMeta("TcpRxChecksum", "tcpRxChecksum", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x20L, None, None, None, ["disabled", "enabled"], ["0-4294967295"]),
			"TcpSegment":UcsPropertyMeta("TcpSegment", "tcpSegment", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x40L, None, None, None, ["disabled", "enabled"], ["0-4294967295"]),
			"TcpTxChecksum":UcsPropertyMeta("TcpTxChecksum", "tcpTxChecksum", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x80L, None, None, None, ["disabled", "enabled"], ["0-4294967295"]),
			"Meta":UcsMoMeta("AdaptorEthOffloadProfile", "adaptorEthOffloadProfile", "eth-offload", _VersionMeta.Version101e, "InputOutput", 0xffL, [], [], ["Get", "Set"], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"]),
			},

		"ComputePool": {
			"Assigned":UcsPropertyMeta("Assigned", "assigned", "uint", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"AssignmentOrder":UcsPropertyMeta("AssignmentOrder", "assignmentOrder", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, ["default", "sequential"], ["0-4294967295"]),
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Descr":UcsPropertyMeta("Descr", "descr", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x2L, None, None, """[ !#$%&\(\)\*\+,\-\./:;\?@\[\]_\{\|\}~a-zA-Z0-9]{0,256}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x4L, 0, 256, None, [], ["0-4294967295"]),
			"IntId":UcsPropertyMeta("IntId", "intId", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, None, None, None, None, ["none"], ["0-4294967295"]),
			"Name":UcsPropertyMeta("Name", "name", "string", _VersionMeta.Version101e, UcsPropertyMeta.Naming, 0x8L, None, None, """[\-\.:_a-zA-Z0-9]{1,32}""", [], ["0-4294967295"]),
			"PolicyLevel":UcsPropertyMeta("PolicyLevel", "policyLevel", "uint", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"PolicyOwner":UcsPropertyMeta("PolicyOwner", "policyOwner", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadWrite, 0x10L, None, None, None, ["local", "pending-policy", "policy"], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x20L, 0, 256, None, [], ["0-4294967295"]),
			"Size":UcsPropertyMeta("Size", "size", "uint", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x40L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Meta":UcsMoMeta("ComputePool", "computePool", "compute-pool-[Name]", _VersionMeta.Version101e, "InputOutput", 0x7fL, [], [u'computePooledRackUnit', u'computePooledSlot', u'faultInst'], ["Add", "Get", "Remove", "Set"], ["admin", "pn-policy"]),
			},

		"ExtmgmtMiiStatus": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version141i, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, 0x2L, 0, 256, None, [], ["0-4294967295"]),
			"MaxRetryCount":UcsPropertyMeta("MaxRetryCount", "maxRetryCount", "uint", _VersionMeta.Version141i, UcsPropertyMeta.ReadWrite, 0x4L, None, None, None, [], ["1-3"]),
			"RetryInterval":UcsPropertyMeta("RetryInterval", "retryInterval", "uint", _VersionMeta.Version141i, UcsPropertyMeta.ReadWrite, 0x8L, None, None, None, [], ["3-10"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, 0x10L, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadWrite, 0x20L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Meta":UcsMoMeta("ExtmgmtMiiStatus", "extmgmtMiiStatus", "mii-status-policy", _VersionMeta.Version141i, "InputOutput", 0x3fL, [], [], ["Get", "Set"], ["admin", "ext-lan-config"]),
			},

		"IppoolPooled": {
			"Assigned":UcsPropertyMeta("Assigned", "assigned", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, ["false", "no", "true", "yes"], ["0-4294967295"]),
			"AssignedToDn":UcsPropertyMeta("AssignedToDn", "assignedToDn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"DefGw":UcsPropertyMeta("DefGw", "defGw", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, 0, 256, """((([0-9]){1,3}\.){3}[0-9]{1,3})""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x2L, 0, 256, None, [], ["0-4294967295"]),
			"Id":UcsPropertyMeta("Id", "id", "string", _VersionMeta.Version101e, UcsPropertyMeta.Naming, 0x4L, 0, 256, """((([0-9]){1,3}\.){3}[0-9]{1,3})""", [], ["0-4294967295"]),
			"PoolableDn":UcsPropertyMeta("PoolableDn", "poolableDn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"PrevAssignedToDn":UcsPropertyMeta("PrevAssignedToDn", "prevAssignedToDn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"PrimDns":UcsPropertyMeta("PrimDns", "primDns", "string", _VersionMeta.Version201m, UcsPropertyMeta.ReadOnly, None, 0, 256, """((([0-9]){1,3}\.){3}[0-9]{1,3})""", [], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x8L, 0, 256, None, [], ["0-4294967295"]),
			"SecDns":UcsPropertyMeta("SecDns", "secDns", "string", _VersionMeta.Version201m, UcsPropertyMeta.ReadOnly, None, 0, 256, """((([0-9]){1,3}\.){3}[0-9]{1,3})""", [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x10L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Subnet":UcsPropertyMeta("Subnet", "subnet", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, 0, 256, """((([0-9]){1,3}\.){3}[0-9]{1,3})""", [], ["0-4294967295"]),
			"Meta":UcsMoMeta("IppoolPooled", "ippoolPooled", "[Id]", _VersionMeta.Version101e, "InputOutput", 0x1fL, [], [], ["Get"], ["read-only"]),
			},

		"FirmwareImageFsmStage": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version211a, UcsPropertyMeta.Internal, None, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Descr":UcsPropertyMeta("Descr", "descr", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, """[ !#$%&\(\)\*\+,\-\./:;\?@\[\]_\{\|\}~a-zA-Z0-9]{0,256}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"LastUpdateTime":UcsPropertyMeta("LastUpdateTime", "lastUpdateTime", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, """([0-9]){4}-([0-9]){2}-([0-9]){2}T([0-9]){2}:([0-9]){2}:([0-9]){2}((\.([0-9]){3})){0,1}""", [""], ["0-4294967295"]),
			"Name":UcsPropertyMeta("Name", "name", "string", _VersionMeta.Version211a, UcsPropertyMeta.Naming, None, None, None, None, ["DeleteBegin", "DeleteFail", "DeleteLocal", "DeleteRemote", "DeleteSuccess", "nop"], ["0-4294967295"]),
			"Order":UcsPropertyMeta("Order", "order", "ushort", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"Retry":UcsPropertyMeta("Retry", "retry", "byte", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"StageStatus":UcsPropertyMeta("StageStatus", "stageStatus", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, ["fail", "inProgress", "nop", "pending", "skip", "success", "throttled"], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadWrite, None, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Meta":UcsMoMeta("FirmwareImageFsmStage", "firmwareImageFsmStage", "stage-[Name]", _VersionMeta.Version211a, "OutputOnly", 0x0L, [], [], [None], [""]),
			},

		"EquipmentChassisStatsHist": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version111j, UcsPropertyMeta.Internal, None, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"Id":UcsPropertyMeta("Id", "id", "ulong", _VersionMeta.Version111j, UcsPropertyMeta.Naming, None, None, None, None, [], ["0-4294967295"]),
			"InputPower":UcsPropertyMeta("InputPower", "inputPower", "float", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"InputPowerAvg":UcsPropertyMeta("InputPowerAvg", "inputPowerAvg", "float", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"InputPowerMax":UcsPropertyMeta("InputPowerMax", "inputPowerMax", "float", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"InputPowerMin":UcsPropertyMeta("InputPowerMin", "inputPowerMin", "float", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"MostRecent":UcsPropertyMeta("MostRecent", "mostRecent", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, ["false", "no", "true", "yes"], ["0-4294967295"]),
			"OutputPower":UcsPropertyMeta("OutputPower", "outputPower", "float", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"OutputPowerAvg":UcsPropertyMeta("OutputPowerAvg", "outputPowerAvg", "float", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"OutputPowerMax":UcsPropertyMeta("OutputPowerMax", "outputPowerMax", "float", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"OutputPowerMin":UcsPropertyMeta("OutputPowerMin", "outputPowerMin", "float", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadWrite, None, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Suspect":UcsPropertyMeta("Suspect", "suspect", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, ["false", "no", "true", "yes"], ["0-4294967295"]),
			"Thresholded":UcsPropertyMeta("Thresholded", "thresholded", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"TimeCollected":UcsPropertyMeta("TimeCollected", "timeCollected", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, """([0-9]){4}-([0-9]){2}-([0-9]){2}T([0-9]){2}:([0-9]){2}:([0-9]){2}((\.([0-9]){3})){0,1}""", [], ["0-4294967295"]),
			"Meta":UcsMoMeta("EquipmentChassisStatsHist", "equipmentChassisStatsHist", "[Id]", _VersionMeta.Version111j, "OutputOnly", 0x0L, [], [], ["Get"], ["read-only"]),
			},

		"ComputeServerDiscPolicy": {
			"Action":UcsPropertyMeta("Action", "action", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadWrite, 0x1L, None, None, None, ["diag", "immediate", "user-acknowledged"], ["0-4294967295"]),
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version141i, UcsPropertyMeta.Internal, 0x2L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Descr":UcsPropertyMeta("Descr", "descr", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadWrite, 0x4L, None, None, """[ !#$%&\(\)\*\+,\-\./:;\?@\[\]_\{\|\}~a-zA-Z0-9]{0,256}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, 0x8L, 0, 256, None, [], ["0-4294967295"]),
			"FsmDescr":UcsPropertyMeta("FsmDescr", "fsmDescr", "string", _VersionMeta.Version211a, UcsPropertyMeta.Internal, None, None, None, None, [], ["0-4294967295"]),
			"FsmPrev":UcsPropertyMeta("FsmPrev", "fsmPrev", "string", _VersionMeta.Version211a, UcsPropertyMeta.Internal, None, None, None, None, ["ResolveScrubPolicyBegin", "ResolveScrubPolicyFail", "ResolveScrubPolicyResolve", "ResolveScrubPolicySuccess", "nop"], ["0-4294967295"]),
			"FsmProgr":UcsPropertyMeta("FsmProgr", "fsmProgr", "byte", _VersionMeta.Version211a, UcsPropertyMeta.Internal, None, None, None, None, [], ["0-100"]),
			"FsmRmtInvErrCode":UcsPropertyMeta("FsmRmtInvErrCode", "fsmRmtInvErrCode", "string", _VersionMeta.Version211a, UcsPropertyMeta.Internal, None, None, None, None, ["ERR-2fa-auth-retry", "ERR-ACTIVATE-failed", "ERR-ACTIVATE-in-progress", "ERR-ACTIVATE-retry", "ERR-BIOS-TOKENS-OLD-BIOS", "ERR-BIOS-TOKENS-OLD-CIMC", "ERR-BIOS-network-boot-order-not-found", "ERR-BOARDCTRLUPDATE-ignore", "ERR-DIAG-cancelled", "ERR-DIAG-fsm-restarted", "ERR-DIAG-test-failed", "ERR-DNLD-authentication-failure", "ERR-DNLD-hostkey-mismatch", "ERR-DNLD-invalid-image", "ERR-DNLD-no-file", "ERR-DNLD-no-space", "ERR-DNS-delete-error", "ERR-DNS-get-error", "ERR-DNS-set-error", "ERR-Diagnostics-in-progress", "ERR-Diagnostics-memtest-in-progress", "ERR-Diagnostics-network-in-progress", "ERR-FILTER-illegal-format", "ERR-FSM-no-such-state", "ERR-HOST-fru-identity-mismatch", "ERR-HTTP-set-error", "ERR-HTTPS-set-error", "ERR-IBMC-analyze-results", "ERR-IBMC-connect-error", "ERR-IBMC-fru-retrieval-error", "ERR-IBMC-invalid-end-point-config", "ERR-IBMC-results-not-ready", "ERR-MAX-subscriptions-allowed-error", "ERR-MO-CONFIG-child-object-cant-be-configured", "ERR-MO-META-no-such-object-class", "ERR-MO-PROPERTY-no-such-property", "ERR-MO-PROPERTY-value-out-of-range", "ERR-MO-access-denied", "ERR-MO-deletion-rule-violation", "ERR-MO-duplicate-object", "ERR-MO-illegal-containment", "ERR-MO-illegal-creation", "ERR-MO-illegal-iterator-state", "ERR-MO-illegal-object-lifecycle-transition", "ERR-MO-naming-rule-violation", "ERR-MO-object-not-found", "ERR-MO-resource-allocation", "ERR-NTP-delete-error", "ERR-NTP-get-error", "ERR-NTP-set-error", "ERR-POWER-CAP-UNSUPPORTED", "ERR-SERVER-mis-connect", "ERR-SWITCH-invalid-if-config", "ERR-TOKEN-request-denied", "ERR-UNABLE-TO-FETCH-BIOS-SETTINGS", "ERR-UPDATE-failed", "ERR-UPDATE-in-progress", "ERR-UPDATE-retry", "ERR-aaa-config-modify-error", "ERR-acct-realm-set-error", "ERR-admin-passwd-set", "ERR-auth-issue", "ERR-auth-realm-get-error", "ERR-auth-realm-set-error", "ERR-authentication", "ERR-authorization-required", "ERR-cli-session-limit-reached", "ERR-create-keyring", "ERR-create-locale", "ERR-create-role", "ERR-create-user", "ERR-delete-locale", "ERR-delete-role", "ERR-delete-session", "ERR-delete-user", "ERR-efi-Diagnostics--in-progress", "ERR-enable-mgmt-conn", "ERR-ep-set-error", "ERR-get-max-http-user-sessions", "ERR-http-initializing", "ERR-insufficiently-equipped", "ERR-internal-error", "ERR-ldap-delete-error", "ERR-ldap-get-error", "ERR-ldap-group-modify-error", "ERR-ldap-group-set-error", "ERR-ldap-set-error", "ERR-locale-set-error", "ERR-max-userid-sessions-reached", "ERR-missing-method", "ERR-modify-locale", "ERR-modify-role", "ERR-modify-user", "ERR-modify-user-locale", "ERR-modify-user-role", "ERR-provider-group-modify-error", "ERR-provider-group-set-error", "ERR-radius-get-error", "ERR-radius-global-set-error", "ERR-radius-group-set-error", "ERR-radius-set-error", "ERR-request-timeout", "ERR-reset-adapter", "ERR-role-set-error", "ERR-secondary-node", "ERR-service-not-ready", "ERR-session-cache-full", "ERR-session-not-found", "ERR-set-network", "ERR-set-password-strength-check", "ERR-set-port-channel", "ERR-store-pre-login-banner-msg", "ERR-tacacs-enable-error", "ERR-tacacs-global-set-error", "ERR-tacacs-group-set-error", "ERR-tacacs-plus-get-error", "ERR-tacacs-set-error", "ERR-test-error-1", "ERR-test-error-2", "ERR-timezone-set-error", "ERR-user-account-expired", "ERR-user-set-error", "ERR-xml-parse-error", "none"], ["0-4294967295"]),
			"FsmRmtInvErrDescr":UcsPropertyMeta("FsmRmtInvErrDescr", "fsmRmtInvErrDescr", "string", _VersionMeta.Version211a, UcsPropertyMeta.Internal, None, 0, 510, None, [], ["0-4294967295"]),
			"FsmRmtInvRslt":UcsPropertyMeta("FsmRmtInvRslt", "fsmRmtInvRslt", "string", _VersionMeta.Version211a, UcsPropertyMeta.Internal, None, None, None, """((defaultValue|not-applicable|resource-unavailable|service-unavailable|intermittent-error|sw-defect|service-not-implemented-ignore|extend-timeout|capability-not-implemented-failure|illegal-fru|end-point-unavailable|failure|resource-capacity-exceeded|service-protocol-error|fw-defect|service-not-implemented-fail|task-reset|unidentified-fail|capability-not-supported|end-point-failed|fru-state-indeterminate|resource-dependency|fru-identity-indeterminate|internal-error|hw-defect|service-not-supported|fru-not-supported|end-point-protocol-error|capability-unavailable|fru-not-ready|capability-not-implemented-ignore|fru-info-malformed|timeout),){0,32}(defaultValue|not-applicable|resource-unavailable|service-unavailable|intermittent-error|sw-defect|service-not-implemented-ignore|extend-timeout|capability-not-implemented-failure|illegal-fru|end-point-unavailable|failure|resource-capacity-exceeded|service-protocol-error|fw-defect|service-not-implemented-fail|task-reset|unidentified-fail|capability-not-supported|end-point-failed|fru-state-indeterminate|resource-dependency|fru-identity-indeterminate|internal-error|hw-defect|service-not-supported|fru-not-supported|end-point-protocol-error|capability-unavailable|fru-not-ready|capability-not-implemented-ignore|fru-info-malformed|timeout){0,1}""", [], ["0-4294967295"]),
			"FsmStageDescr":UcsPropertyMeta("FsmStageDescr", "fsmStageDescr", "string", _VersionMeta.Version211a, UcsPropertyMeta.Internal, None, None, None, None, [], ["0-4294967295"]),
			"FsmStamp":UcsPropertyMeta("FsmStamp", "fsmStamp", "string", _VersionMeta.Version211a, UcsPropertyMeta.Internal, None, None, None, """([0-9]){4}-([0-9]){2}-([0-9]){2}T([0-9]){2}:([0-9]){2}:([0-9]){2}((\.([0-9]){3})){0,1}""", ["never"], ["0-4294967295"]),
			"FsmStatus":UcsPropertyMeta("FsmStatus", "fsmStatus", "string", _VersionMeta.Version211a, UcsPropertyMeta.Internal, None, None, None, None, ["ResolveScrubPolicyBegin", "ResolveScrubPolicyFail", "ResolveScrubPolicyResolve", "ResolveScrubPolicySuccess", "nop"], ["0-4294967295"]),
			"FsmTry":UcsPropertyMeta("FsmTry", "fsmTry", "byte", _VersionMeta.Version211a, UcsPropertyMeta.Internal, None, None, None, None, [], ["0-4294967295"]),
			"IntId":UcsPropertyMeta("IntId", "intId", "string", _VersionMeta.Version141i, UcsPropertyMeta.Internal, None, None, None, None, ["none"], ["0-4294967295"]),
			"Name":UcsPropertyMeta("Name", "name", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadWrite, 0x10L, None, None, """[\-\.:_a-zA-Z0-9]{0,16}""", [], ["0-4294967295"]),
			"PolicyLevel":UcsPropertyMeta("PolicyLevel", "policyLevel", "uint", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"PolicyOwner":UcsPropertyMeta("PolicyOwner", "policyOwner", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadWrite, 0x20L, None, None, None, ["local", "pending-policy", "policy"], ["0-4294967295"]),
			"Qualifier":UcsPropertyMeta("Qualifier", "qualifier", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadWrite, 0x40L, None, None, """[\-\.:_a-zA-Z0-9]{0,16}""", [], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, 0x80L, 0, 256, None, [], ["0-4294967295"]),
			"ScrubPolicyName":UcsPropertyMeta("ScrubPolicyName", "scrubPolicyName", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadWrite, 0x100L, None, None, """[\-\.:_a-zA-Z0-9]{0,16}""", [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadWrite, 0x200L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Meta":UcsMoMeta("ComputeServerDiscPolicy", "computeServerDiscPolicy", "server-discovery", _VersionMeta.Version141i, "InputOutput", 0x3ffL, [], [u'computeServerDiscPolicyFsm', u'computeServerDiscPolicyFsmTask', u'eventInst', u'faultInst'], ["Get", "Set"], ["admin", "pn-policy"]),
			},

		"IdentIdentCtx": {
			"Assigned":UcsPropertyMeta("Assigned", "assigned", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, 0, 510, None, [], ["0-4294967295"]),
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version211a, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"ConsDn":UcsPropertyMeta("ConsDn", "consDn", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"ConsType":UcsPropertyMeta("ConsType", "consType", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, ["chassis", "server", "vhba", "vm", "vmnic", "vnic"], ["0-4294967295"]),
			"DefinedInIdm":UcsPropertyMeta("DefinedInIdm", "definedInIdm", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, ["no", "yes"], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, 0x2L, 0, 256, None, [], ["0-4294967295"]),
			"IdentPoolName":UcsPropertyMeta("IdentPoolName", "identPoolName", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, """[\-\.:_a-zA-Z0-9]{0,16}""", [], ["0-4294967295"]),
			"IdentType":UcsPropertyMeta("IdentType", "identType", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, ["ipV4", "ipV6", "iqn", "mac", "uuid", "vlan", "wwnn", "wwpn"], ["0-4294967295"]),
			"Intent":UcsPropertyMeta("Intent", "intent", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, ["add-pooled", "assign", "delete-pooled", "requisition", "unassign"], ["0-4294967295"]),
			"PoolDn":UcsPropertyMeta("PoolDn", "poolDn", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"PoolOrgDn":UcsPropertyMeta("PoolOrgDn", "poolOrgDn", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"PooledId":UcsPropertyMeta("PooledId", "pooledId", "uint", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"RetStatus":UcsPropertyMeta("RetStatus", "retStatus", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, ["assigned-by-other", "failed", "out-of-sync", "succeeded", "synced"], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, 0x4L, 0, 256, None, [], ["0-4294967295"]),
			"SeqNum":UcsPropertyMeta("SeqNum", "seqNum", "uint", _VersionMeta.Version211a, UcsPropertyMeta.Naming, 0x8L, None, None, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadWrite, 0x10L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"SupplId1":UcsPropertyMeta("SupplId1", "supplId1", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, 0, 510, None, [], ["0-4294967295"]),
			"SupplId2":UcsPropertyMeta("SupplId2", "supplId2", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, 0, 510, None, [], ["0-4294967295"]),
			"SupplId3":UcsPropertyMeta("SupplId3", "supplId3", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, 0, 510, None, [], ["0-4294967295"]),
			"SupplId4":UcsPropertyMeta("SupplId4", "supplId4", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, 0, 510, None, [], ["0-4294967295"]),
			"Meta":UcsMoMeta("IdentIdentCtx", "identIdentCtx", "IdCtx-[SeqNum]", _VersionMeta.Version211a, "InputOutput", 0x1fL, [], [], [None], ["read-only"]),
			},

		"FabricSanCloud": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x2L, 0, 256, None, [], ["0-4294967295"]),
			"FsmDescr":UcsPropertyMeta("FsmDescr", "fsmDescr", "string", _VersionMeta.Version141i, UcsPropertyMeta.Internal, None, None, None, None, [], ["0-4294967295"]),
			"FsmPrev":UcsPropertyMeta("FsmPrev", "fsmPrev", "string", _VersionMeta.Version141i, UcsPropertyMeta.Internal, None, None, None, None, ["SwitchModeBegin", "SwitchModeFail", "SwitchModeSuccess", "SwitchModeSwConfigLocal", "SwitchModeSwConfigPeer", "nop"], ["0-4294967295"]),
			"FsmProgr":UcsPropertyMeta("FsmProgr", "fsmProgr", "byte", _VersionMeta.Version141i, UcsPropertyMeta.Internal, None, None, None, None, [], ["0-100"]),
			"FsmRmtInvErrCode":UcsPropertyMeta("FsmRmtInvErrCode", "fsmRmtInvErrCode", "string", _VersionMeta.Version141i, UcsPropertyMeta.Internal, None, None, None, None, ["ERR-2fa-auth-retry", "ERR-ACTIVATE-failed", "ERR-ACTIVATE-in-progress", "ERR-ACTIVATE-retry", "ERR-BIOS-TOKENS-OLD-BIOS", "ERR-BIOS-TOKENS-OLD-CIMC", "ERR-BIOS-network-boot-order-not-found", "ERR-BOARDCTRLUPDATE-ignore", "ERR-DIAG-cancelled", "ERR-DIAG-fsm-restarted", "ERR-DIAG-test-failed", "ERR-DNLD-authentication-failure", "ERR-DNLD-hostkey-mismatch", "ERR-DNLD-invalid-image", "ERR-DNLD-no-file", "ERR-DNLD-no-space", "ERR-DNS-delete-error", "ERR-DNS-get-error", "ERR-DNS-set-error", "ERR-Diagnostics-in-progress", "ERR-Diagnostics-memtest-in-progress", "ERR-Diagnostics-network-in-progress", "ERR-FILTER-illegal-format", "ERR-FSM-no-such-state", "ERR-HOST-fru-identity-mismatch", "ERR-HTTP-set-error", "ERR-HTTPS-set-error", "ERR-IBMC-analyze-results", "ERR-IBMC-connect-error", "ERR-IBMC-fru-retrieval-error", "ERR-IBMC-invalid-end-point-config", "ERR-IBMC-results-not-ready", "ERR-MAX-subscriptions-allowed-error", "ERR-MO-CONFIG-child-object-cant-be-configured", "ERR-MO-META-no-such-object-class", "ERR-MO-PROPERTY-no-such-property", "ERR-MO-PROPERTY-value-out-of-range", "ERR-MO-access-denied", "ERR-MO-deletion-rule-violation", "ERR-MO-duplicate-object", "ERR-MO-illegal-containment", "ERR-MO-illegal-creation", "ERR-MO-illegal-iterator-state", "ERR-MO-illegal-object-lifecycle-transition", "ERR-MO-naming-rule-violation", "ERR-MO-object-not-found", "ERR-MO-resource-allocation", "ERR-NTP-delete-error", "ERR-NTP-get-error", "ERR-NTP-set-error", "ERR-POWER-CAP-UNSUPPORTED", "ERR-SERVER-mis-connect", "ERR-SWITCH-invalid-if-config", "ERR-TOKEN-request-denied", "ERR-UNABLE-TO-FETCH-BIOS-SETTINGS", "ERR-UPDATE-failed", "ERR-UPDATE-in-progress", "ERR-UPDATE-retry", "ERR-aaa-config-modify-error", "ERR-acct-realm-set-error", "ERR-admin-passwd-set", "ERR-auth-issue", "ERR-auth-realm-get-error", "ERR-auth-realm-set-error", "ERR-authentication", "ERR-authorization-required", "ERR-cli-session-limit-reached", "ERR-create-keyring", "ERR-create-locale", "ERR-create-role", "ERR-create-user", "ERR-delete-locale", "ERR-delete-role", "ERR-delete-session", "ERR-delete-user", "ERR-efi-Diagnostics--in-progress", "ERR-enable-mgmt-conn", "ERR-ep-set-error", "ERR-get-max-http-user-sessions", "ERR-http-initializing", "ERR-insufficiently-equipped", "ERR-internal-error", "ERR-ldap-delete-error", "ERR-ldap-get-error", "ERR-ldap-group-modify-error", "ERR-ldap-group-set-error", "ERR-ldap-set-error", "ERR-locale-set-error", "ERR-max-userid-sessions-reached", "ERR-missing-method", "ERR-modify-locale", "ERR-modify-role", "ERR-modify-user", "ERR-modify-user-locale", "ERR-modify-user-role", "ERR-provider-group-modify-error", "ERR-provider-group-set-error", "ERR-radius-get-error", "ERR-radius-global-set-error", "ERR-radius-group-set-error", "ERR-radius-set-error", "ERR-request-timeout", "ERR-reset-adapter", "ERR-role-set-error", "ERR-secondary-node", "ERR-service-not-ready", "ERR-session-cache-full", "ERR-session-not-found", "ERR-set-network", "ERR-set-password-strength-check", "ERR-set-port-channel", "ERR-store-pre-login-banner-msg", "ERR-tacacs-enable-error", "ERR-tacacs-global-set-error", "ERR-tacacs-group-set-error", "ERR-tacacs-plus-get-error", "ERR-tacacs-set-error", "ERR-test-error-1", "ERR-test-error-2", "ERR-timezone-set-error", "ERR-user-account-expired", "ERR-user-set-error", "ERR-xml-parse-error", "none"], ["0-4294967295"]),
			"FsmRmtInvErrDescr":UcsPropertyMeta("FsmRmtInvErrDescr", "fsmRmtInvErrDescr", "string", _VersionMeta.Version141i, UcsPropertyMeta.Internal, None, 0, 510, None, [], ["0-4294967295"]),
			"FsmRmtInvRslt":UcsPropertyMeta("FsmRmtInvRslt", "fsmRmtInvRslt", "string", _VersionMeta.Version141i, UcsPropertyMeta.Internal, None, None, None, """((defaultValue|not-applicable|resource-unavailable|service-unavailable|intermittent-error|sw-defect|service-not-implemented-ignore|extend-timeout|capability-not-implemented-failure|illegal-fru|end-point-unavailable|failure|resource-capacity-exceeded|service-protocol-error|fw-defect|service-not-implemented-fail|task-reset|unidentified-fail|capability-not-supported|end-point-failed|fru-state-indeterminate|resource-dependency|fru-identity-indeterminate|internal-error|hw-defect|service-not-supported|fru-not-supported|end-point-protocol-error|capability-unavailable|fru-not-ready|capability-not-implemented-ignore|fru-info-malformed|timeout),){0,32}(defaultValue|not-applicable|resource-unavailable|service-unavailable|intermittent-error|sw-defect|service-not-implemented-ignore|extend-timeout|capability-not-implemented-failure|illegal-fru|end-point-unavailable|failure|resource-capacity-exceeded|service-protocol-error|fw-defect|service-not-implemented-fail|task-reset|unidentified-fail|capability-not-supported|end-point-failed|fru-state-indeterminate|resource-dependency|fru-identity-indeterminate|internal-error|hw-defect|service-not-supported|fru-not-supported|end-point-protocol-error|capability-unavailable|fru-not-ready|capability-not-implemented-ignore|fru-info-malformed|timeout){0,1}""", [], ["0-4294967295"]),
			"FsmStageDescr":UcsPropertyMeta("FsmStageDescr", "fsmStageDescr", "string", _VersionMeta.Version141i, UcsPropertyMeta.Internal, None, None, None, None, [], ["0-4294967295"]),
			"FsmStamp":UcsPropertyMeta("FsmStamp", "fsmStamp", "string", _VersionMeta.Version141i, UcsPropertyMeta.Internal, None, None, None, """([0-9]){4}-([0-9]){2}-([0-9]){2}T([0-9]){2}:([0-9]){2}:([0-9]){2}((\.([0-9]){3})){0,1}""", ["never"], ["0-4294967295"]),
			"FsmStatus":UcsPropertyMeta("FsmStatus", "fsmStatus", "string", _VersionMeta.Version141i, UcsPropertyMeta.Internal, None, None, None, None, ["SwitchModeBegin", "SwitchModeFail", "SwitchModeSuccess", "SwitchModeSwConfigLocal", "SwitchModeSwConfigPeer", "nop"], ["0-4294967295"]),
			"FsmTry":UcsPropertyMeta("FsmTry", "fsmTry", "byte", _VersionMeta.Version141i, UcsPropertyMeta.Internal, None, None, None, None, [], ["0-4294967295"]),
			"Mode":UcsPropertyMeta("Mode", "mode", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadWrite, 0x4L, None, None, None, ["end-host", "switch"], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x8L, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x10L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Meta":UcsMoMeta("FabricSanCloud", "fabricSanCloud", "san", _VersionMeta.Version101e, "InputOutput", 0x1fL, [], [u'eventInst', u'fabricFcSan', u'fabricSanCloudFsm', u'fabricSanCloudFsmTask', u'fabricSanPinGroup', u'fabricVsan', u'faultInst', u'statsThresholdPolicy'], ["Get", "Set"], ["admin", "ext-san-config", "ext-san-policy"]),
			},

		"ExtpolClientCont": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version211a, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, 0x2L, 0, 256, None, [], ["0-4294967295"]),
			"GenNum":UcsPropertyMeta("GenNum", "genNum", "uint", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, 0x4L, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadWrite, 0x8L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Meta":UcsMoMeta("ExtpolClientCont", "extpolClientCont", "clients", _VersionMeta.Version211a, "InputOutput", 0xfL, [], [u'extpolClient'], ["Get"], ["admin"]),
			},

		"FabricEthEstcCloud": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version141i, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, 0x2L, 0, 256, None, [], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, 0x4L, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadWrite, 0x8L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Meta":UcsMoMeta("FabricEthEstcCloud", "fabricEthEstcCloud", "eth-estc", _VersionMeta.Version141i, "InputOutput", 0xfL, [], [u'fabricEthEstc', u'fabricVlan', u'nwctrlDefinition', u'statsThresholdPolicy'], ["Get"], ["admin", "ext-lan-config", "ext-lan-policy"]),
			},

		"ComputePoolPolicyRef": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version141i, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, 0x2L, 0, 256, None, [], ["0-4294967295"]),
			"Id":UcsPropertyMeta("Id", "id", "ulong", _VersionMeta.Version141i, UcsPropertyMeta.Naming, 0x4L, None, None, None, [], ["0-4294967295"]),
			"PolicyDn":UcsPropertyMeta("PolicyDn", "policyDn", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, 0x8L, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadWrite, 0x10L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Meta":UcsMoMeta("ComputePoolPolicyRef", "computePoolPolicyRef", "poolref-[Id]", _VersionMeta.Version141i, "InputOutput", 0x1fL, [], [], ["Get"], ["read-only"]),
			},

		"VnicScsi": {
			"AdaptorProfileName":UcsPropertyMeta("AdaptorProfileName", "adaptorProfileName", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x1L, None, None, """[\-\.:_a-zA-Z0-9]{0,16}""", [], ["0-4294967295"]),
			"AdminVcon":UcsPropertyMeta("AdminVcon", "adminVcon", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadWrite, 0x2L, None, None, None, ["1", "2", "3", "4", "any"], ["0-4294967295"]),
			"BootDev":UcsPropertyMeta("BootDev", "bootDev", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, ["disabled", "enabled"], ["0-4294967295"]),
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, 0x4L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"ConfigQualifier":UcsPropertyMeta("ConfigQualifier", "configQualifier", "string", _VersionMeta.Version201m, UcsPropertyMeta.ReadOnly, None, None, None, """((defaultValue|not-applicable|adaptor-protected-eth-capability|vif-resources-overprovisioned|unresolved-remote-vlan-name|invalid-wwn|service-profile-virtualization-conflict|fcoe-capacity|wwpn-derivation-virtualized-port|unresolved-vlan-name|pinning-vlan-mismatch|adaptor-requirement|vnic-not-ha-ready|unresolved-remote-vsan-name|mac-derivation-virtualized-port|vnic-virtualization-conflict|vnic-vlan-assignment-error|insufficient-vhba-capacity|inaccessible-vlan|unable-to-update-ucsm|connection-placement|vnic-vcon-provisioning-change|missing-primary-vlan|adaptor-fcoe-capability|vfc-vnic-pvlan-conflict|virtualization-not-supported|unresolved-vsan-name|insufficient-vnic-capacity|unassociated-vlan|dynamic-vf-vnic|wwpn-assignment|pinned-target-misconfig),){0,31}(defaultValue|not-applicable|adaptor-protected-eth-capability|vif-resources-overprovisioned|unresolved-remote-vlan-name|invalid-wwn|service-profile-virtualization-conflict|fcoe-capacity|wwpn-derivation-virtualized-port|unresolved-vlan-name|pinning-vlan-mismatch|adaptor-requirement|vnic-not-ha-ready|unresolved-remote-vsan-name|mac-derivation-virtualized-port|vnic-virtualization-conflict|vnic-vlan-assignment-error|insufficient-vhba-capacity|inaccessible-vlan|unable-to-update-ucsm|connection-placement|vnic-vcon-provisioning-change|missing-primary-vlan|adaptor-fcoe-capability|vfc-vnic-pvlan-conflict|virtualization-not-supported|unresolved-vsan-name|insufficient-vnic-capacity|unassociated-vlan|dynamic-vf-vnic|wwpn-assignment|pinned-target-misconfig){0,1}""", [], ["0-4294967295"]),
			"ConfigState":UcsPropertyMeta("ConfigState", "configState", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, ["applied", "applying", "failed-to-apply", "not-applied"], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x8L, 0, 256, None, [], ["0-4294967295"]),
			"EquipmentDn":UcsPropertyMeta("EquipmentDn", "equipmentDn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"IdentPoolName":UcsPropertyMeta("IdentPoolName", "identPoolName", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x10L, None, None, None, [], ["0-4294967295"]),
			"InstType":UcsPropertyMeta("InstType", "instType", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, ["default", "dynamic", "dynamic-vf", "manual"], ["0-4294967295"]),
			"Name":UcsPropertyMeta("Name", "name", "string", _VersionMeta.Version101e, UcsPropertyMeta.Naming, 0x20L, None, None, """[\-\.:_a-zA-Z0-9]{1,16}""", [], ["0-4294967295"]),
			"NwTemplName":UcsPropertyMeta("NwTemplName", "nwTemplName", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x40L, None, None, """[\-\.:_a-zA-Z0-9]{0,16}""", [], ["0-4294967295"]),
			"OperOrder":UcsPropertyMeta("OperOrder", "operOrder", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, ["unspecified"], ["0-4294967295"]),
			"OperSpeed":UcsPropertyMeta("OperSpeed", "operSpeed", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, ["line-rate"], ["8-40000000"]),
			"OperStatsPolicyName":UcsPropertyMeta("OperStatsPolicyName", "operStatsPolicyName", "string", _VersionMeta.Version131c, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"OperVcon":UcsPropertyMeta("OperVcon", "operVcon", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, ["1", "2", "3", "4", "any"], ["0-4294967295"]),
			"Order":UcsPropertyMeta("Order", "order", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x80L, None, None, None, ["unspecified"], ["0-256"]),
			"Owner":UcsPropertyMeta("Owner", "owner", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, ["conn_policy", "logical", "physical", "policy", "unknown"], ["0-4294967295"]),
			"PinToGroupName":UcsPropertyMeta("PinToGroupName", "pinToGroupName", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x100L, None, None, """[\-\.:_a-zA-Z0-9]{0,16}""", [], ["0-4294967295"]),
			"QosPolicyName":UcsPropertyMeta("QosPolicyName", "qosPolicyName", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadWrite, 0x200L, None, None, """[\-\.:_a-zA-Z0-9]{0,16}""", [], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x400L, 0, 256, None, [], ["0-4294967295"]),
			"StatsPolicyName":UcsPropertyMeta("StatsPolicyName", "statsPolicyName", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x800L, None, None, """[\-\.:_a-zA-Z0-9]{0,16}""", [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x1000L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"SwitchId":UcsPropertyMeta("SwitchId", "switchId", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x2000L, None, None, None, ["A", "B", "NONE"], ["0-4294967295"]),
			"Type":UcsPropertyMeta("Type", "type", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, ["ether", "fc", "ipc", "scsi", "unknown"], ["0-4294967295"]),
			"Meta":UcsMoMeta("VnicScsi", "vnicScsi", "scsi-[Name]", _VersionMeta.Version101e, "InputOutput", 0x3fffL, [], [u'fabricEthMonSrcEp', u'fabricFcMonSrcEp', u'fabricNetflowMonSrcEp', u'faultInst'], ["Get"], ["admin", "ls-config", "ls-server", "ls-storage"]),
			},

		"TopSystem": {
			"Address":UcsPropertyMeta("Address", "address", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x1L, 0, 256, """((([0-9]){1,3}\.){3}[0-9]{1,3})""", [], ["0-4294967295"]),
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, 0x2L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"CurrentTime":UcsPropertyMeta("CurrentTime", "currentTime", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, """([0-9]){4}-([0-9]){2}-([0-9]){2}T([0-9]){2}:([0-9]){2}:([0-9]){2}((\.([0-9]){3})){0,1}""", [], ["0-4294967295"]),
			"Descr":UcsPropertyMeta("Descr", "descr", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadWrite, 0x4L, None, None, """[ !#$%&\(\)\*\+,\-\./:;\?@\[\]_\{\|\}~a-zA-Z0-9]{0,256}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x8L, 0, 256, None, [], ["0-4294967295"]),
			"Ipv6Addr":UcsPropertyMeta("Ipv6Addr", "ipv6Addr", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadWrite, 0x10L, 0, 256, None, [], ["0-4294967295"]),
			"Mode":UcsPropertyMeta("Mode", "mode", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, ["cluster", "stand-alone", "unspecified"], ["0-4294967295"]),
			"Name":UcsPropertyMeta("Name", "name", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x20L, None, None, """[a-zA-Z][a-zA-Z0-9-]{0,29}""", [], ["0-4294967295"]),
			"Owner":UcsPropertyMeta("Owner", "owner", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadWrite, 0x40L, None, None, """[ !#$%&\(\)\*\+,\-\./:;\?@\[\]_\{\|\}~a-zA-Z0-9]{0,32}""", [], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x80L, 0, 256, None, [], ["0-4294967295"]),
			"Site":UcsPropertyMeta("Site", "site", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadWrite, 0x100L, None, None, """[ !#$%&\(\)\*\+,\-\./:;\?@\[\]_\{\|\}~a-zA-Z0-9]{0,32}""", [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x200L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"SystemUpTime":UcsPropertyMeta("SystemUpTime", "systemUpTime", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, """(([1-9]*[0-9]{2}:)|)([0-1][0-9]||[2][0-3]):([0-5][0-9]):([0-5][0-9])||(([0-5][0-9]):|)([0-5][0-9])""", [], ["0-4294967295"]),
			"Meta":UcsMoMeta("TopSystem", "topSystem", "sys", _VersionMeta.Version101e, "InputOutput", 0x3ffL, [], [u'aaaAuthRealm', u'aaaLdapEp', u'aaaRadiusEp', u'aaaSessionInfoTable', u'aaaTacacsPlusEp', u'aaaUserEp', u'commSvcEp', u'computeRackUnit', u'domainEnvironmentFeatureCont', u'domainNetworkFeatureCont', u'domainServerFeatureCont', u'domainStorageFeatureCont', u'equipmentChassis', u'equipmentFex', u'extmgmtIfMonPolicy', u'extvmmEp', u'firmwareCatalogue', u'firmwareStatus', u'firmwareSystem', u'firmwareUpgradeInfo', u'fsmStatus', u'initiatorRequestorEp', u'initiatorRequestorGrpEp', u'licenseEp', u'mgmtAccessPolicy', u'mgmtBackup', u'mgmtController', u'mgmtEntity', u'mgmtImporter', u'mgmtIntAuthPolicy', u'networkElement', u'pkiEp', u'policyControlEp', u'powerEp', u'swatInjection', u'syntheticDirectory', u'syntheticFsObj', u'sysdebugCoreFileRepository', u'sysdebugEp', u'sysdebugTechSupFileRepository', u'trigLocalSched', u'trigMeta', u'trigSched', u'versionEp'], ["Get", "Set"], ["admin", "ext-lan-config"]),
			},

		"MgmtController": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"DimmBlacklistingOperState":UcsPropertyMeta("DimmBlacklistingOperState", "dimmBlacklistingOperState", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadOnly, None, None, None, None, ["disabled", "enabled", "unknown", "unsupported"], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x2L, 0, 256, None, [], ["0-4294967295"]),
			"FsmDescr":UcsPropertyMeta("FsmDescr", "fsmDescr", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, None, None, None, None, [], ["0-4294967295"]),
			"FsmFlags":UcsPropertyMeta("FsmFlags", "fsmFlags", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, None, None, None, None, [], ["0-4294967295"]),
			"FsmPrev":UcsPropertyMeta("FsmPrev", "fsmPrev", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, None, None, None, None, ["ActivateBMCActivate", "ActivateBMCBegin", "ActivateBMCFail", "ActivateBMCReset", "ActivateBMCSuccess", "ActivateIOMActivate", "ActivateIOMBegin", "ActivateIOMFail", "ActivateIOMReset", "ActivateIOMSuccess", "ExtMgmtIfConfigBegin", "ExtMgmtIfConfigFail", "ExtMgmtIfConfigPrimary", "ExtMgmtIfConfigSecondary", "ExtMgmtIfConfigSuccess", "ExtMgmtInterfaceConfigActive", "ExtMgmtInterfaceConfigBegin", "ExtMgmtInterfaceConfigCIMCVlanCfgLocal", "ExtMgmtInterfaceConfigCIMCVlanCfgPeer", "ExtMgmtInterfaceConfigCMCVlanCfg", "ExtMgmtInterfaceConfigCMCVlanCfgPeer", "ExtMgmtInterfaceConfigFail", "ExtMgmtInterfaceConfigSuccess", "OnlineBegin", "OnlineBmcConfigureConnLocal", "OnlineBmcConfigureConnPeer", "OnlineFail", "OnlineSuccess", "OnlineSwConfigureConnLocal", "OnlineSwConfigureConnPeer", "RegistryConfigBegin", "RegistryConfigFail", "RegistryConfigRemove", "RegistryConfigSuccess", "SysConfigBegin", "SysConfigFail", "SysConfigPrimary", "SysConfigSecondary", "SysConfigSuccess", "UpdateBMCBegin", "UpdateBMCFail", "UpdateBMCPollUpdateStatus", "UpdateBMCSuccess", "UpdateBMCUpdateRequest", "UpdateIOMBegin", "UpdateIOMFail", "UpdateIOMPollUpdateStatus", "UpdateIOMSuccess", "UpdateIOMUpdateRequest", "UpdateSwitchBegin", "UpdateSwitchCopyToLocal", "UpdateSwitchCopyToPeer", "UpdateSwitchFail", "UpdateSwitchResetLocal", "UpdateSwitchResetRemote", "UpdateSwitchSuccess", "UpdateSwitchUpdateLocal", "UpdateSwitchUpdateRemote", "UpdateSwitchVerifyLocal", "UpdateSwitchVerifyRemote", "UpdateUCSManagerBegin", "UpdateUCSManagerCopyExtToLocal", "UpdateUCSManagerCopyExtToPeer", "UpdateUCSManagerExecute", "UpdateUCSManagerFail", "UpdateUCSManagerStart", "UpdateUCSManagerSuccess", "nop"], ["0-4294967295"]),
			"FsmProgr":UcsPropertyMeta("FsmProgr", "fsmProgr", "byte", _VersionMeta.Version101e, UcsPropertyMeta.Internal, None, None, None, None, [], ["0-100"]),
			"FsmRmtInvErrCode":UcsPropertyMeta("FsmRmtInvErrCode", "fsmRmtInvErrCode", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, None, None, None, None, ["ERR-2fa-auth-retry", "ERR-ACTIVATE-failed", "ERR-ACTIVATE-in-progress", "ERR-ACTIVATE-retry", "ERR-BIOS-TOKENS-OLD-BIOS", "ERR-BIOS-TOKENS-OLD-CIMC", "ERR-BIOS-network-boot-order-not-found", "ERR-BOARDCTRLUPDATE-ignore", "ERR-DIAG-cancelled", "ERR-DIAG-fsm-restarted", "ERR-DIAG-test-failed", "ERR-DNLD-authentication-failure", "ERR-DNLD-hostkey-mismatch", "ERR-DNLD-invalid-image", "ERR-DNLD-no-file", "ERR-DNLD-no-space", "ERR-DNS-delete-error", "ERR-DNS-get-error", "ERR-DNS-set-error", "ERR-Diagnostics-in-progress", "ERR-Diagnostics-memtest-in-progress", "ERR-Diagnostics-network-in-progress", "ERR-FILTER-illegal-format", "ERR-FSM-no-such-state", "ERR-HOST-fru-identity-mismatch", "ERR-HTTP-set-error", "ERR-HTTPS-set-error", "ERR-IBMC-analyze-results", "ERR-IBMC-connect-error", "ERR-IBMC-fru-retrieval-error", "ERR-IBMC-invalid-end-point-config", "ERR-IBMC-results-not-ready", "ERR-MAX-subscriptions-allowed-error", "ERR-MO-CONFIG-child-object-cant-be-configured", "ERR-MO-META-no-such-object-class", "ERR-MO-PROPERTY-no-such-property", "ERR-MO-PROPERTY-value-out-of-range", "ERR-MO-access-denied", "ERR-MO-deletion-rule-violation", "ERR-MO-duplicate-object", "ERR-MO-illegal-containment", "ERR-MO-illegal-creation", "ERR-MO-illegal-iterator-state", "ERR-MO-illegal-object-lifecycle-transition", "ERR-MO-naming-rule-violation", "ERR-MO-object-not-found", "ERR-MO-resource-allocation", "ERR-NTP-delete-error", "ERR-NTP-get-error", "ERR-NTP-set-error", "ERR-POWER-CAP-UNSUPPORTED", "ERR-SERVER-mis-connect", "ERR-SWITCH-invalid-if-config", "ERR-TOKEN-request-denied", "ERR-UNABLE-TO-FETCH-BIOS-SETTINGS", "ERR-UPDATE-failed", "ERR-UPDATE-in-progress", "ERR-UPDATE-retry", "ERR-aaa-config-modify-error", "ERR-acct-realm-set-error", "ERR-admin-passwd-set", "ERR-auth-issue", "ERR-auth-realm-get-error", "ERR-auth-realm-set-error", "ERR-authentication", "ERR-authorization-required", "ERR-cli-session-limit-reached", "ERR-create-keyring", "ERR-create-locale", "ERR-create-role", "ERR-create-user", "ERR-delete-locale", "ERR-delete-role", "ERR-delete-session", "ERR-delete-user", "ERR-efi-Diagnostics--in-progress", "ERR-enable-mgmt-conn", "ERR-ep-set-error", "ERR-get-max-http-user-sessions", "ERR-http-initializing", "ERR-insufficiently-equipped", "ERR-internal-error", "ERR-ldap-delete-error", "ERR-ldap-get-error", "ERR-ldap-group-modify-error", "ERR-ldap-group-set-error", "ERR-ldap-set-error", "ERR-locale-set-error", "ERR-max-userid-sessions-reached", "ERR-missing-method", "ERR-modify-locale", "ERR-modify-role", "ERR-modify-user", "ERR-modify-user-locale", "ERR-modify-user-role", "ERR-provider-group-modify-error", "ERR-provider-group-set-error", "ERR-radius-get-error", "ERR-radius-global-set-error", "ERR-radius-group-set-error", "ERR-radius-set-error", "ERR-request-timeout", "ERR-reset-adapter", "ERR-role-set-error", "ERR-secondary-node", "ERR-service-not-ready", "ERR-session-cache-full", "ERR-session-not-found", "ERR-set-network", "ERR-set-password-strength-check", "ERR-set-port-channel", "ERR-store-pre-login-banner-msg", "ERR-tacacs-enable-error", "ERR-tacacs-global-set-error", "ERR-tacacs-group-set-error", "ERR-tacacs-plus-get-error", "ERR-tacacs-set-error", "ERR-test-error-1", "ERR-test-error-2", "ERR-timezone-set-error", "ERR-user-account-expired", "ERR-user-set-error", "ERR-xml-parse-error", "none"], ["0-4294967295"]),
			"FsmRmtInvErrDescr":UcsPropertyMeta("FsmRmtInvErrDescr", "fsmRmtInvErrDescr", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, None, 0, 510, None, [], ["0-4294967295"]),
			"FsmRmtInvRslt":UcsPropertyMeta("FsmRmtInvRslt", "fsmRmtInvRslt", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, None, None, None, """((defaultValue|not-applicable|resource-unavailable|service-unavailable|intermittent-error|sw-defect|service-not-implemented-ignore|extend-timeout|capability-not-implemented-failure|illegal-fru|end-point-unavailable|failure|resource-capacity-exceeded|service-protocol-error|fw-defect|service-not-implemented-fail|task-reset|unidentified-fail|capability-not-supported|end-point-failed|fru-state-indeterminate|resource-dependency|fru-identity-indeterminate|internal-error|hw-defect|service-not-supported|fru-not-supported|end-point-protocol-error|capability-unavailable|fru-not-ready|capability-not-implemented-ignore|fru-info-malformed|timeout),){0,32}(defaultValue|not-applicable|resource-unavailable|service-unavailable|intermittent-error|sw-defect|service-not-implemented-ignore|extend-timeout|capability-not-implemented-failure|illegal-fru|end-point-unavailable|failure|resource-capacity-exceeded|service-protocol-error|fw-defect|service-not-implemented-fail|task-reset|unidentified-fail|capability-not-supported|end-point-failed|fru-state-indeterminate|resource-dependency|fru-identity-indeterminate|internal-error|hw-defect|service-not-supported|fru-not-supported|end-point-protocol-error|capability-unavailable|fru-not-ready|capability-not-implemented-ignore|fru-info-malformed|timeout){0,1}""", [], ["0-4294967295"]),
			"FsmStageDescr":UcsPropertyMeta("FsmStageDescr", "fsmStageDescr", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, None, None, None, None, [], ["0-4294967295"]),
			"FsmStamp":UcsPropertyMeta("FsmStamp", "fsmStamp", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, None, None, None, """([0-9]){4}-([0-9]){2}-([0-9]){2}T([0-9]){2}:([0-9]){2}:([0-9]){2}((\.([0-9]){3})){0,1}""", ["never"], ["0-4294967295"]),
			"FsmStatus":UcsPropertyMeta("FsmStatus", "fsmStatus", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, None, None, None, None, ["ActivateBMCActivate", "ActivateBMCBegin", "ActivateBMCFail", "ActivateBMCReset", "ActivateBMCSuccess", "ActivateIOMActivate", "ActivateIOMBegin", "ActivateIOMFail", "ActivateIOMReset", "ActivateIOMSuccess", "ExtMgmtIfConfigBegin", "ExtMgmtIfConfigFail", "ExtMgmtIfConfigPrimary", "ExtMgmtIfConfigSecondary", "ExtMgmtIfConfigSuccess", "ExtMgmtInterfaceConfigActive", "ExtMgmtInterfaceConfigBegin", "ExtMgmtInterfaceConfigCIMCVlanCfgLocal", "ExtMgmtInterfaceConfigCIMCVlanCfgPeer", "ExtMgmtInterfaceConfigCMCVlanCfg", "ExtMgmtInterfaceConfigCMCVlanCfgPeer", "ExtMgmtInterfaceConfigFail", "ExtMgmtInterfaceConfigSuccess", "OnlineBegin", "OnlineBmcConfigureConnLocal", "OnlineBmcConfigureConnPeer", "OnlineFail", "OnlineSuccess", "OnlineSwConfigureConnLocal", "OnlineSwConfigureConnPeer", "RegistryConfigBegin", "RegistryConfigFail", "RegistryConfigRemove", "RegistryConfigSuccess", "SysConfigBegin", "SysConfigFail", "SysConfigPrimary", "SysConfigSecondary", "SysConfigSuccess", "UpdateBMCBegin", "UpdateBMCFail", "UpdateBMCPollUpdateStatus", "UpdateBMCSuccess", "UpdateBMCUpdateRequest", "UpdateIOMBegin", "UpdateIOMFail", "UpdateIOMPollUpdateStatus", "UpdateIOMSuccess", "UpdateIOMUpdateRequest", "UpdateSwitchBegin", "UpdateSwitchCopyToLocal", "UpdateSwitchCopyToPeer", "UpdateSwitchFail", "UpdateSwitchResetLocal", "UpdateSwitchResetRemote", "UpdateSwitchSuccess", "UpdateSwitchUpdateLocal", "UpdateSwitchUpdateRemote", "UpdateSwitchVerifyLocal", "UpdateSwitchVerifyRemote", "UpdateUCSManagerBegin", "UpdateUCSManagerCopyExtToLocal", "UpdateUCSManagerCopyExtToPeer", "UpdateUCSManagerExecute", "UpdateUCSManagerFail", "UpdateUCSManagerStart", "UpdateUCSManagerSuccess", "nop"], ["0-4294967295"]),
			"FsmTry":UcsPropertyMeta("FsmTry", "fsmTry", "byte", _VersionMeta.Version101e, UcsPropertyMeta.Internal, None, None, None, None, [], ["0-4294967295"]),
			"Guid":UcsPropertyMeta("Guid", "guid", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, 0, 510, None, [], ["0-4294967295"]),
			"Model":UcsPropertyMeta("Model", "model", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, 0, 510, None, [], ["0-4294967295"]),
			"OperConn":UcsPropertyMeta("OperConn", "operConn", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"Revision":UcsPropertyMeta("Revision", "revision", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, 0, 510, None, [], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x4L, 0, 256, None, [], ["0-4294967295"]),
			"Serial":UcsPropertyMeta("Serial", "serial", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, 0, 510, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x8L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"StorageOobInterfaceSupported":UcsPropertyMeta("StorageOobInterfaceSupported", "storageOobInterfaceSupported", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadOnly, None, None, None, None, ["false", "no", "true", "yes"], ["0-4294967295"]),
			"StorageSubsystemState":UcsPropertyMeta("StorageSubsystemState", "storageSubsystemState", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadOnly, None, None, None, None, ["initialized", "initializing", "uninitialized", "unknown", "unsupported"], ["0-4294967295"]),
			"Subject":UcsPropertyMeta("Subject", "subject", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x10L, None, None, None, ["adaptor", "blade", "board-controller", "chassis", "iocard", "switch", "system", "unknown"], ["0-4294967295"]),
			"Vendor":UcsPropertyMeta("Vendor", "vendor", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, 0, 510, None, [], ["0-4294967295"]),
			"Meta":UcsMoMeta("MgmtController", "mgmtController", "mgmt", _VersionMeta.Version101e, "InputOutput", 0x1fL, [], [u'eventInst', u'fabricLocale', u'faultInst', u'firmwareBootDefinition', u'firmwareRunning', u'firmwareUpdatable', u'mgmtConnection', u'mgmtControllerFsm', u'mgmtControllerFsmTask', u'mgmtIf', u'mgmtInterface', u'mgmtProfDerivedInterface', u'sysdebugMEpLog', u'vnicIpV4MgmtPooledAddr', u'vnicIpV4PooledAddr', u'vnicIpV4ProfDerivedAddr', u'vnicIpV4StaticAddr'], ["Get"], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server"]),
			},

		"AaaRole": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"ConfigState":UcsPropertyMeta("ConfigState", "configState", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, ["not-applied", "ok"], ["0-4294967295"]),
			"ConfigStatusMessage":UcsPropertyMeta("ConfigStatusMessage", "configStatusMessage", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, 0, 510, None, [], ["0-4294967295"]),
			"Descr":UcsPropertyMeta("Descr", "descr", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x2L, None, None, """[ !#$%&\(\)\*\+,\-\./:;\?@\[\]_\{\|\}~a-zA-Z0-9]{0,256}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x4L, 0, 256, None, [], ["0-4294967295"]),
			"IntId":UcsPropertyMeta("IntId", "intId", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, None, None, None, None, ["none"], ["0-4294967295"]),
			"Name":UcsPropertyMeta("Name", "name", "string", _VersionMeta.Version101e, UcsPropertyMeta.Naming, 0x8L, None, None, """[\-\.:_a-zA-Z0-9]{1,16}""", [], ["0-4294967295"]),
			"PolicyLevel":UcsPropertyMeta("PolicyLevel", "policyLevel", "uint", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"PolicyOwner":UcsPropertyMeta("PolicyOwner", "policyOwner", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadWrite, 0x10L, None, None, None, ["local", "pending-policy", "policy"], ["0-4294967295"]),
			"Priv":UcsPropertyMeta("Priv", "priv", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x20L, None, None, """((ext-lan-policy|pn-maintenance|ls-security-policy|pod-security|pn-equipment|ls-config-policy|ls-compute|ext-san-policy|ls-security|aaa|power-mgmt|read-only|ext-lan-security|ls-config|ls-server-policy|pod-qos|pn-policy|ls-storage-policy|org-management|admin|ext-san-security|pod-config|ls-server|ext-lan-qos|ls-storage|ls-qos-policy|operations|ext-lan-config|pn-security|ls-network-policy|pod-policy|ext-san-qos|ls-qos|ls-server-oper|ext-san-config|ls-network|ls-ext-access|fault),){0,37}(ext-lan-policy|pn-maintenance|ls-security-policy|pod-security|pn-equipment|ls-config-policy|ls-compute|ext-san-policy|ls-security|aaa|power-mgmt|read-only|ext-lan-security|ls-config|ls-server-policy|pod-qos|pn-policy|ls-storage-policy|org-management|admin|ext-san-security|pod-config|ls-server|ext-lan-qos|ls-storage|ls-qos-policy|operations|ext-lan-config|pn-security|ls-network-policy|pod-policy|ext-san-qos|ls-qos|ls-server-oper|ext-san-config|ls-network|ls-ext-access|fault){0,1}""", [], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x40L, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x80L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Meta":UcsMoMeta("AaaRole", "aaaRole", "role-[Name]", _VersionMeta.Version101e, "InputOutput", 0xffL, [], [u'faultInst'], ["Add", "Get", "Remove", "Set"], ["aaa", "admin"]),
			},

		"AdaptorEthPortOutsizedStatsHist": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version111j, UcsPropertyMeta.Internal, None, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"Id":UcsPropertyMeta("Id", "id", "ulong", _VersionMeta.Version111j, UcsPropertyMeta.Naming, None, None, None, None, [], ["0-4294967295"]),
			"MostRecent":UcsPropertyMeta("MostRecent", "mostRecent", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, ["false", "no", "true", "yes"], ["0-4294967295"]),
			"OversizedBadCrcPackets":UcsPropertyMeta("OversizedBadCrcPackets", "oversizedBadCrcPackets", "ulong", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"OversizedBadCrcPacketsDelta":UcsPropertyMeta("OversizedBadCrcPacketsDelta", "oversizedBadCrcPacketsDelta", "ulong", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"OversizedBadCrcPacketsDeltaAvg":UcsPropertyMeta("OversizedBadCrcPacketsDeltaAvg", "oversizedBadCrcPacketsDeltaAvg", "ulong", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"OversizedBadCrcPacketsDeltaMax":UcsPropertyMeta("OversizedBadCrcPacketsDeltaMax", "oversizedBadCrcPacketsDeltaMax", "ulong", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"OversizedBadCrcPacketsDeltaMin":UcsPropertyMeta("OversizedBadCrcPacketsDeltaMin", "oversizedBadCrcPacketsDeltaMin", "ulong", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"OversizedGoodCrcPackets":UcsPropertyMeta("OversizedGoodCrcPackets", "oversizedGoodCrcPackets", "ulong", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"OversizedGoodCrcPacketsDelta":UcsPropertyMeta("OversizedGoodCrcPacketsDelta", "oversizedGoodCrcPacketsDelta", "ulong", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"OversizedGoodCrcPacketsDeltaAvg":UcsPropertyMeta("OversizedGoodCrcPacketsDeltaAvg", "oversizedGoodCrcPacketsDeltaAvg", "ulong", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"OversizedGoodCrcPacketsDeltaMax":UcsPropertyMeta("OversizedGoodCrcPacketsDeltaMax", "oversizedGoodCrcPacketsDeltaMax", "ulong", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"OversizedGoodCrcPacketsDeltaMin":UcsPropertyMeta("OversizedGoodCrcPacketsDeltaMin", "oversizedGoodCrcPacketsDeltaMin", "ulong", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"OversizedPackets":UcsPropertyMeta("OversizedPackets", "oversizedPackets", "ulong", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"OversizedPacketsDelta":UcsPropertyMeta("OversizedPacketsDelta", "oversizedPacketsDelta", "ulong", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"OversizedPacketsDeltaAvg":UcsPropertyMeta("OversizedPacketsDeltaAvg", "oversizedPacketsDeltaAvg", "ulong", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"OversizedPacketsDeltaMax":UcsPropertyMeta("OversizedPacketsDeltaMax", "oversizedPacketsDeltaMax", "ulong", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"OversizedPacketsDeltaMin":UcsPropertyMeta("OversizedPacketsDeltaMin", "oversizedPacketsDeltaMin", "ulong", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadWrite, None, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Suspect":UcsPropertyMeta("Suspect", "suspect", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, ["false", "no", "true", "yes"], ["0-4294967295"]),
			"Thresholded":UcsPropertyMeta("Thresholded", "thresholded", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"TimeCollected":UcsPropertyMeta("TimeCollected", "timeCollected", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, """([0-9]){4}-([0-9]){2}-([0-9]){2}T([0-9]){2}:([0-9]){2}:([0-9]){2}((\.([0-9]){3})){0,1}""", [], ["0-4294967295"]),
			"UndersizedBadCrcPackets":UcsPropertyMeta("UndersizedBadCrcPackets", "undersizedBadCrcPackets", "ulong", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"UndersizedBadCrcPacketsDelta":UcsPropertyMeta("UndersizedBadCrcPacketsDelta", "undersizedBadCrcPacketsDelta", "ulong", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"UndersizedBadCrcPacketsDeltaAvg":UcsPropertyMeta("UndersizedBadCrcPacketsDeltaAvg", "undersizedBadCrcPacketsDeltaAvg", "ulong", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"UndersizedBadCrcPacketsDeltaMax":UcsPropertyMeta("UndersizedBadCrcPacketsDeltaMax", "undersizedBadCrcPacketsDeltaMax", "ulong", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"UndersizedBadCrcPacketsDeltaMin":UcsPropertyMeta("UndersizedBadCrcPacketsDeltaMin", "undersizedBadCrcPacketsDeltaMin", "ulong", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"UndersizedGoodCrcPackets":UcsPropertyMeta("UndersizedGoodCrcPackets", "undersizedGoodCrcPackets", "ulong", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"UndersizedGoodCrcPacketsDelta":UcsPropertyMeta("UndersizedGoodCrcPacketsDelta", "undersizedGoodCrcPacketsDelta", "ulong", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"UndersizedGoodCrcPacketsDeltaAvg":UcsPropertyMeta("UndersizedGoodCrcPacketsDeltaAvg", "undersizedGoodCrcPacketsDeltaAvg", "ulong", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"UndersizedGoodCrcPacketsDeltaMax":UcsPropertyMeta("UndersizedGoodCrcPacketsDeltaMax", "undersizedGoodCrcPacketsDeltaMax", "ulong", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"UndersizedGoodCrcPacketsDeltaMin":UcsPropertyMeta("UndersizedGoodCrcPacketsDeltaMin", "undersizedGoodCrcPacketsDeltaMin", "ulong", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"Meta":UcsMoMeta("AdaptorEthPortOutsizedStatsHist", "adaptorEthPortOutsizedStatsHist", "[Id]", _VersionMeta.Version111j, "OutputOnly", 0x0L, [], [], ["Get"], ["read-only"]),
			},

		"StorageInitiator": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version211a, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Descr":UcsPropertyMeta("Descr", "descr", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadWrite, 0x2L, None, None, """[ !#$%&\(\)\*\+,\-\./:;\?@\[\]_\{\|\}~a-zA-Z0-9]{0,256}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, 0x4L, 0, 256, None, [], ["0-4294967295"]),
			"DuplicateTarget":UcsPropertyMeta("DuplicateTarget", "duplicateTarget", "string", _VersionMeta.Version212a, UcsPropertyMeta.ReadOnly, None, 0, 256, """(([A-Fa-f0-9][A-Fa-f0-9]:){7}[A-Fa-f0-9][A-Fa-f0-9])|0""", [], ["0-4294967295"]),
			"IntId":UcsPropertyMeta("IntId", "intId", "string", _VersionMeta.Version211a, UcsPropertyMeta.Internal, None, None, None, None, ["none"], ["0-4294967295"]),
			"Name":UcsPropertyMeta("Name", "name", "string", _VersionMeta.Version211a, UcsPropertyMeta.Naming, 0x8L, None, None, """[\-\.:_a-zA-Z0-9]{1,16}""", [], ["0-4294967295"]),
			"OperState":UcsPropertyMeta("OperState", "operState", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, ["misconfigured", "ok"], ["0-4294967295"]),
			"PolicyLevel":UcsPropertyMeta("PolicyLevel", "policyLevel", "uint", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"PolicyOwner":UcsPropertyMeta("PolicyOwner", "policyOwner", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadWrite, 0x10L, None, None, None, ["local", "pending-policy", "policy"], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, 0x20L, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadWrite, 0x40L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Meta":UcsMoMeta("StorageInitiator", "storageInitiator", "ini-[Name]", _VersionMeta.Version211a, "InputOutput", 0x7fL, [], [u'faultInst'], ["Add", "Get", "Remove"], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage"]),
			},

		"EquipmentSlotArrayRef": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Descr":UcsPropertyMeta("Descr", "descr", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x2L, None, None, """[ !#$%&\(\)\*\+,\-\./:;\?@\[\]_\{\|\}~a-zA-Z0-9]{0,256}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x4L, 0, 256, None, [], ["0-4294967295"]),
			"IntId":UcsPropertyMeta("IntId", "intId", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, None, None, None, None, ["none"], ["0-4294967295"]),
			"Name":UcsPropertyMeta("Name", "name", "string", _VersionMeta.Version101e, UcsPropertyMeta.Naming, 0x8L, 1, 512, None, [], ["0-4294967295"]),
			"NumberOfSlotsSpanned":UcsPropertyMeta("NumberOfSlotsSpanned", "numberOfSlotsSpanned", "ushort", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"PolicyLevel":UcsPropertyMeta("PolicyLevel", "policyLevel", "uint", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"PolicyOwner":UcsPropertyMeta("PolicyOwner", "policyOwner", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadWrite, 0x10L, None, None, None, ["local", "pending-policy", "policy"], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x20L, 0, 256, None, [], ["0-4294967295"]),
			"SlotSpanOrientation":UcsPropertyMeta("SlotSpanOrientation", "slotSpanOrientation", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, ["inline", "transverse", "unknown"], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x40L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"TargetDn":UcsPropertyMeta("TargetDn", "targetDn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"Meta":UcsMoMeta("EquipmentSlotArrayRef", "equipmentSlotArrayRef", "ref-[Name]", _VersionMeta.Version101e, "InputOutput", 0x7fL, [], [], ["Get"], ["read-only"]),
			},

		"FirmwarePackItem": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x2L, 0, 256, None, [], ["0-4294967295"]),
			"HwModel":UcsPropertyMeta("HwModel", "hwModel", "string", _VersionMeta.Version101e, UcsPropertyMeta.Naming, 0x4L, 1, 510, None, [], ["0-4294967295"]),
			"HwVendor":UcsPropertyMeta("HwVendor", "hwVendor", "string", _VersionMeta.Version101e, UcsPropertyMeta.Naming, 0x8L, 1, 510, None, [], ["0-4294967295"]),
			"Presence":UcsPropertyMeta("Presence", "presence", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, ["missing", "present", "unknown"], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x10L, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x20L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Type":UcsPropertyMeta("Type", "type", "string", _VersionMeta.Version101e, UcsPropertyMeta.Naming, 0x40L, None, None, None, ["adaptor", "blade-bios", "blade-controller", "board-controller", "flexflash-controller", "host-hba", "host-hba-optionrom", "host-nic", "host-nic-optionrom", "iocard", "local-disk", "storage-controller", "switch-kernel", "switch-software", "system", "unspecified"], ["0-4294967295"]),
			"Version":UcsPropertyMeta("Version", "version", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x80L, 0, 510, None, [], ["0-4294967295"]),
			"Meta":UcsMoMeta("FirmwarePackItem", "firmwarePackItem", "pack-image-[HwVendor]|[HwModel]|[Type]", _VersionMeta.Version101e, "InputOutput", 0xffL, [], [u'faultInst'], ["Add", "Get", "Remove", "Set"], ["admin", "ls-compute", "ls-config-policy", "ls-server-policy"]),
			},

		"AdaptorEthPortBySizeLargeStatsHist": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version111j, UcsPropertyMeta.Internal, None, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"GreaterThanOrEqualTo9216":UcsPropertyMeta("GreaterThanOrEqualTo9216", "greaterThanOrEqualTo9216", "ulong", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"GreaterThanOrEqualTo9216Delta":UcsPropertyMeta("GreaterThanOrEqualTo9216Delta", "greaterThanOrEqualTo9216Delta", "ulong", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"GreaterThanOrEqualTo9216DeltaAvg":UcsPropertyMeta("GreaterThanOrEqualTo9216DeltaAvg", "greaterThanOrEqualTo9216DeltaAvg", "ulong", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"GreaterThanOrEqualTo9216DeltaMax":UcsPropertyMeta("GreaterThanOrEqualTo9216DeltaMax", "greaterThanOrEqualTo9216DeltaMax", "ulong", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"GreaterThanOrEqualTo9216DeltaMin":UcsPropertyMeta("GreaterThanOrEqualTo9216DeltaMin", "greaterThanOrEqualTo9216DeltaMin", "ulong", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"Id":UcsPropertyMeta("Id", "id", "ulong", _VersionMeta.Version111j, UcsPropertyMeta.Naming, None, None, None, None, [], ["0-4294967295"]),
			"LessThan2048":UcsPropertyMeta("LessThan2048", "lessThan2048", "ulong", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"LessThan2048Delta":UcsPropertyMeta("LessThan2048Delta", "lessThan2048Delta", "ulong", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"LessThan2048DeltaAvg":UcsPropertyMeta("LessThan2048DeltaAvg", "lessThan2048DeltaAvg", "ulong", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"LessThan2048DeltaMax":UcsPropertyMeta("LessThan2048DeltaMax", "lessThan2048DeltaMax", "ulong", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"LessThan2048DeltaMin":UcsPropertyMeta("LessThan2048DeltaMin", "lessThan2048DeltaMin", "ulong", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"LessThan4096":UcsPropertyMeta("LessThan4096", "lessThan4096", "ulong", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"LessThan4096Delta":UcsPropertyMeta("LessThan4096Delta", "lessThan4096Delta", "ulong", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"LessThan4096DeltaAvg":UcsPropertyMeta("LessThan4096DeltaAvg", "lessThan4096DeltaAvg", "ulong", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"LessThan4096DeltaMax":UcsPropertyMeta("LessThan4096DeltaMax", "lessThan4096DeltaMax", "ulong", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"LessThan4096DeltaMin":UcsPropertyMeta("LessThan4096DeltaMin", "lessThan4096DeltaMin", "ulong", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"LessThan8192":UcsPropertyMeta("LessThan8192", "lessThan8192", "ulong", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"LessThan8192Delta":UcsPropertyMeta("LessThan8192Delta", "lessThan8192Delta", "ulong", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"LessThan8192DeltaAvg":UcsPropertyMeta("LessThan8192DeltaAvg", "lessThan8192DeltaAvg", "ulong", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"LessThan8192DeltaMax":UcsPropertyMeta("LessThan8192DeltaMax", "lessThan8192DeltaMax", "ulong", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"LessThan8192DeltaMin":UcsPropertyMeta("LessThan8192DeltaMin", "lessThan8192DeltaMin", "ulong", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"LessThan9216":UcsPropertyMeta("LessThan9216", "lessThan9216", "ulong", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"LessThan9216Delta":UcsPropertyMeta("LessThan9216Delta", "lessThan9216Delta", "ulong", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"LessThan9216DeltaAvg":UcsPropertyMeta("LessThan9216DeltaAvg", "lessThan9216DeltaAvg", "ulong", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"LessThan9216DeltaMax":UcsPropertyMeta("LessThan9216DeltaMax", "lessThan9216DeltaMax", "ulong", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"LessThan9216DeltaMin":UcsPropertyMeta("LessThan9216DeltaMin", "lessThan9216DeltaMin", "ulong", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"LessThanOrEqualTo1518":UcsPropertyMeta("LessThanOrEqualTo1518", "lessThanOrEqualTo1518", "ulong", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"LessThanOrEqualTo1518Delta":UcsPropertyMeta("LessThanOrEqualTo1518Delta", "lessThanOrEqualTo1518Delta", "ulong", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"LessThanOrEqualTo1518DeltaAvg":UcsPropertyMeta("LessThanOrEqualTo1518DeltaAvg", "lessThanOrEqualTo1518DeltaAvg", "ulong", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"LessThanOrEqualTo1518DeltaMax":UcsPropertyMeta("LessThanOrEqualTo1518DeltaMax", "lessThanOrEqualTo1518DeltaMax", "ulong", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"LessThanOrEqualTo1518DeltaMin":UcsPropertyMeta("LessThanOrEqualTo1518DeltaMin", "lessThanOrEqualTo1518DeltaMin", "ulong", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"MostRecent":UcsPropertyMeta("MostRecent", "mostRecent", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, ["false", "no", "true", "yes"], ["0-4294967295"]),
			"NoBreakdownGreaterThan1518":UcsPropertyMeta("NoBreakdownGreaterThan1518", "noBreakdownGreaterThan1518", "ulong", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"NoBreakdownGreaterThan1518Delta":UcsPropertyMeta("NoBreakdownGreaterThan1518Delta", "noBreakdownGreaterThan1518Delta", "ulong", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"NoBreakdownGreaterThan1518DeltaAvg":UcsPropertyMeta("NoBreakdownGreaterThan1518DeltaAvg", "noBreakdownGreaterThan1518DeltaAvg", "ulong", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"NoBreakdownGreaterThan1518DeltaMax":UcsPropertyMeta("NoBreakdownGreaterThan1518DeltaMax", "noBreakdownGreaterThan1518DeltaMax", "ulong", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"NoBreakdownGreaterThan1518DeltaMin":UcsPropertyMeta("NoBreakdownGreaterThan1518DeltaMin", "noBreakdownGreaterThan1518DeltaMin", "ulong", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadWrite, None, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Suspect":UcsPropertyMeta("Suspect", "suspect", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, ["false", "no", "true", "yes"], ["0-4294967295"]),
			"Thresholded":UcsPropertyMeta("Thresholded", "thresholded", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"TimeCollected":UcsPropertyMeta("TimeCollected", "timeCollected", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, """([0-9]){4}-([0-9]){2}-([0-9]){2}T([0-9]){2}:([0-9]){2}:([0-9]){2}((\.([0-9]){3})){0,1}""", [], ["0-4294967295"]),
			"Meta":UcsMoMeta("AdaptorEthPortBySizeLargeStatsHist", "adaptorEthPortBySizeLargeStatsHist", "[Id]", _VersionMeta.Version111j, "OutputOnly", 0x0L, [], [], ["Get"], ["read-only"]),
			},

		"SwFcSanMon": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version141i, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, 0x2L, 0, 256, None, [], ["0-4294967295"]),
			"Locale":UcsPropertyMeta("Locale", "locale", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, None, None, None, """((defaultValue|unknown|server|chassis|internal|external),){0,5}(defaultValue|unknown|server|chassis|internal|external){0,1}""", [], ["0-4294967295"]),
			"Name":UcsPropertyMeta("Name", "name", "string", _VersionMeta.Version141i, UcsPropertyMeta.CreateOnly, 0x4L, None, None, """[\-\.:_a-zA-Z0-9]{0,16}""", [], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, 0x8L, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadWrite, 0x10L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"SwitchId":UcsPropertyMeta("SwitchId", "switchId", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadWrite, 0x20L, None, None, None, ["A", "B", "NONE"], ["0-4294967295"]),
			"Transport":UcsPropertyMeta("Transport", "transport", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, None, None, None, """((defaultValue|unknown|ether|dce|fc),){0,4}(defaultValue|unknown|ether|dce|fc){0,1}""", [], ["0-4294967295"]),
			"Type":UcsPropertyMeta("Type", "type", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, None, None, None, """((defaultValue|unknown|lan|san|ipc),){0,4}(defaultValue|unknown|lan|san|ipc){0,1}""", [], ["0-4294967295"]),
			"Meta":UcsMoMeta("SwFcSanMon", "swFcSanMon", "sanmon-fc", _VersionMeta.Version141i, "InputOutput", 0x3fL, [], [u'swFcMon'], ["Get"], ["read-only"]),
			},

		"QosclassFc": {
			"AdminState":UcsPropertyMeta("AdminState", "adminState", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, ["disabled", "enabled"], ["0-4294967295"]),
			"BwPercent":UcsPropertyMeta("BwPercent", "bwPercent", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, ["not-applicable"], ["0-100"]),
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Cos":UcsPropertyMeta("Cos", "cos", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x2L, None, None, None, ["any"], ["0-6", "255-255"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x4L, 0, 256, None, [], ["0-4294967295"]),
			"Drop":UcsPropertyMeta("Drop", "drop", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, ["drop", "no-drop"], ["0-4294967295"]),
			"Mtu":UcsPropertyMeta("Mtu", "mtu", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, ["fc", "normal"], ["0-4294967295"]),
			"Name":UcsPropertyMeta("Name", "name", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x8L, None, None, """[\-\.:_a-zA-Z0-9]{0,16}""", [], ["0-4294967295"]),
			"Priority":UcsPropertyMeta("Priority", "priority", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, ["best-effort", "bronze", "fc", "gold", "platinum", "silver"], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x10L, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x20L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Weight":UcsPropertyMeta("Weight", "weight", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x40L, None, None, None, ["best-effort", "none"], ["0-10"]),
			"Meta":UcsMoMeta("QosclassFc", "qosclassFc", "class-fc", _VersionMeta.Version101e, "InputOutput", 0x7fL, [], [], ["Get", "Set"], ["admin", "ext-lan-qos", "ext-san-qos", "ls-network", "ls-network-policy", "ls-qos-policy"]),
			},

		"EquipmentFanModuleStats": {
			"AmbientTemp":UcsPropertyMeta("AmbientTemp", "ambientTemp", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, ["not-applicable"], ["0-4294967295"]),
			"AmbientTempAvg":UcsPropertyMeta("AmbientTempAvg", "ambientTempAvg", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, ["not-applicable"], ["0-4294967295"]),
			"AmbientTempMax":UcsPropertyMeta("AmbientTempMax", "ambientTempMax", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, ["not-applicable"], ["0-4294967295"]),
			"AmbientTempMin":UcsPropertyMeta("AmbientTempMin", "ambientTempMin", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, ["not-applicable"], ["0-4294967295"]),
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version111j, UcsPropertyMeta.Internal, None, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"Intervals":UcsPropertyMeta("Intervals", "intervals", "uint", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadWrite, None, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Suspect":UcsPropertyMeta("Suspect", "suspect", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, ["false", "no", "true", "yes"], ["0-4294967295"]),
			"Thresholded":UcsPropertyMeta("Thresholded", "thresholded", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"TimeCollected":UcsPropertyMeta("TimeCollected", "timeCollected", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, """([0-9]){4}-([0-9]){2}-([0-9]){2}T([0-9]){2}:([0-9]){2}:([0-9]){2}((\.([0-9]){3})){0,1}""", [], ["0-4294967295"]),
			"Update":UcsPropertyMeta("Update", "update", "uint", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"Meta":UcsMoMeta("EquipmentFanModuleStats", "equipmentFanModuleStats", "stats", _VersionMeta.Version111j, "OutputOnly", 0x0L, [], [u'equipmentFanModuleStatsHist'], ["Get"], ["admin", "operations", "read-only"]),
			},

		"StatsThrFloatDefinition": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Descr":UcsPropertyMeta("Descr", "descr", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x2L, None, None, """[ !#$%&\(\)\*\+,\-\./:;\?@\[\]_\{\|\}~a-zA-Z0-9]{0,256}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x4L, 0, 256, None, [], ["0-4294967295"]),
			"IntId":UcsPropertyMeta("IntId", "intId", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, None, None, None, None, ["none"], ["0-4294967295"]),
			"Name":UcsPropertyMeta("Name", "name", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x8L, None, None, """[\-\.:_a-zA-Z0-9]{0,16}""", [], ["0-4294967295"]),
			"NormalValue":UcsPropertyMeta("NormalValue", "normalValue", "float", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x10L, None, None, None, [], ["0-4294967295"]),
			"PolicyLevel":UcsPropertyMeta("PolicyLevel", "policyLevel", "uint", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"PolicyOwner":UcsPropertyMeta("PolicyOwner", "policyOwner", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadWrite, 0x20L, None, None, None, ["local", "pending-policy", "policy"], ["0-4294967295"]),
			"PropId":UcsPropertyMeta("PropId", "propId", "string", _VersionMeta.Version101e, UcsPropertyMeta.Naming, 0x40L, None, None, None, ["adaptorEthPortBySizeLargeStatsgreaterThanOrEqualTo9216Delta", "adaptorEthPortBySizeLargeStatsgreaterThanOrEqualTo9216DeltaAvg", "adaptorEthPortBySizeLargeStatsgreaterThanOrEqualTo9216DeltaMax", "adaptorEthPortBySizeLargeStatsgreaterThanOrEqualTo9216DeltaMin", "adaptorEthPortBySizeLargeStatslessThan2048Delta", "adaptorEthPortBySizeLargeStatslessThan2048DeltaAvg", "adaptorEthPortBySizeLargeStatslessThan2048DeltaMax", "adaptorEthPortBySizeLargeStatslessThan2048DeltaMin", "adaptorEthPortBySizeLargeStatslessThan4096Delta", "adaptorEthPortBySizeLargeStatslessThan4096DeltaAvg", "adaptorEthPortBySizeLargeStatslessThan4096DeltaMax", "adaptorEthPortBySizeLargeStatslessThan4096DeltaMin", "adaptorEthPortBySizeLargeStatslessThan8192Delta", "adaptorEthPortBySizeLargeStatslessThan8192DeltaAvg", "adaptorEthPortBySizeLargeStatslessThan8192DeltaMax", "adaptorEthPortBySizeLargeStatslessThan8192DeltaMin", "adaptorEthPortBySizeLargeStatslessThan9216Delta", "adaptorEthPortBySizeLargeStatslessThan9216DeltaAvg", "adaptorEthPortBySizeLargeStatslessThan9216DeltaMax", "adaptorEthPortBySizeLargeStatslessThan9216DeltaMin", "adaptorEthPortBySizeLargeStatslessThanOrEqualTo1518Delta", "adaptorEthPortBySizeLargeStatslessThanOrEqualTo1518DeltaAvg", "adaptorEthPortBySizeLargeStatslessThanOrEqualTo1518DeltaMax", "adaptorEthPortBySizeLargeStatslessThanOrEqualTo1518DeltaMin", "adaptorEthPortBySizeLargeStatsnoBreakdownGreaterThan1518Delta", "adaptorEthPortBySizeLargeStatsnoBreakdownGreaterThan1518DeltaAvg", "adaptorEthPortBySizeLargeStatsnoBreakdownGreaterThan1518DeltaMax", "adaptorEthPortBySizeLargeStatsnoBreakdownGreaterThan1518DeltaMin", "adaptorEthPortBySizeSmallStatsequals64Delta", "adaptorEthPortBySizeSmallStatsequals64DeltaAvg", "adaptorEthPortBySizeSmallStatsequals64DeltaMax", "adaptorEthPortBySizeSmallStatsequals64DeltaMin", "adaptorEthPortBySizeSmallStatslessThan1024Delta", "adaptorEthPortBySizeSmallStatslessThan1024DeltaAvg", "adaptorEthPortBySizeSmallStatslessThan1024DeltaMax", "adaptorEthPortBySizeSmallStatslessThan1024DeltaMin", "adaptorEthPortBySizeSmallStatslessThan128Delta", "adaptorEthPortBySizeSmallStatslessThan128DeltaAvg", "adaptorEthPortBySizeSmallStatslessThan128DeltaMax", "adaptorEthPortBySizeSmallStatslessThan128DeltaMin", "adaptorEthPortBySizeSmallStatslessThan256Delta", "adaptorEthPortBySizeSmallStatslessThan256DeltaAvg", "adaptorEthPortBySizeSmallStatslessThan256DeltaMax", "adaptorEthPortBySizeSmallStatslessThan256DeltaMin", "adaptorEthPortBySizeSmallStatslessThan512Delta", "adaptorEthPortBySizeSmallStatslessThan512DeltaAvg", "adaptorEthPortBySizeSmallStatslessThan512DeltaMax", "adaptorEthPortBySizeSmallStatslessThan512DeltaMin", "adaptorEthPortBySizeSmallStatslessThan64Delta", "adaptorEthPortBySizeSmallStatslessThan64DeltaAvg", "adaptorEthPortBySizeSmallStatslessThan64DeltaMax", "adaptorEthPortBySizeSmallStatslessThan64DeltaMin", "adaptorEthPortErrStatsbadCrcPacketsDelta", "adaptorEthPortErrStatsbadCrcPacketsDeltaAvg", "adaptorEthPortErrStatsbadCrcPacketsDeltaMax", "adaptorEthPortErrStatsbadCrcPacketsDeltaMin", "adaptorEthPortErrStatsbadLengthPacketsDelta", "adaptorEthPortErrStatsbadLengthPacketsDeltaAvg", "adaptorEthPortErrStatsbadLengthPacketsDeltaMax", "adaptorEthPortErrStatsbadLengthPacketsDeltaMin", "adaptorEthPortErrStatsmacDiscardedPacketsDelta", "adaptorEthPortErrStatsmacDiscardedPacketsDeltaAvg", "adaptorEthPortErrStatsmacDiscardedPacketsDeltaMax", "adaptorEthPortErrStatsmacDiscardedPacketsDeltaMin", "adaptorEthPortMcastStatsbroadcastPacketsDelta", "adaptorEthPortMcastStatsbroadcastPacketsDeltaAvg", "adaptorEthPortMcastStatsbroadcastPacketsDeltaMax", "adaptorEthPortMcastStatsbroadcastPacketsDeltaMin", "adaptorEthPortMcastStatsmulticastPacketsDelta", "adaptorEthPortMcastStatsmulticastPacketsDeltaAvg", "adaptorEthPortMcastStatsmulticastPacketsDeltaMax", "adaptorEthPortMcastStatsmulticastPacketsDeltaMin", "adaptorEthPortMcastStatsunicastPacketsDelta", "adaptorEthPortMcastStatsunicastPacketsDeltaAvg", "adaptorEthPortMcastStatsunicastPacketsDeltaMax", "adaptorEthPortMcastStatsunicastPacketsDeltaMin", "adaptorEthPortOutsizedStatsoversizedBadCrcPacketsDelta", "adaptorEthPortOutsizedStatsoversizedBadCrcPacketsDeltaAvg", "adaptorEthPortOutsizedStatsoversizedBadCrcPacketsDeltaMax", "adaptorEthPortOutsizedStatsoversizedBadCrcPacketsDeltaMin", "adaptorEthPortOutsizedStatsoversizedGoodCrcPacketsDelta", "adaptorEthPortOutsizedStatsoversizedGoodCrcPacketsDeltaAvg", "adaptorEthPortOutsizedStatsoversizedGoodCrcPacketsDeltaMax", "adaptorEthPortOutsizedStatsoversizedGoodCrcPacketsDeltaMin", "adaptorEthPortOutsizedStatsoversizedPacketsDelta", "adaptorEthPortOutsizedStatsoversizedPacketsDeltaAvg", "adaptorEthPortOutsizedStatsoversizedPacketsDeltaMax", "adaptorEthPortOutsizedStatsoversizedPacketsDeltaMin", "adaptorEthPortOutsizedStatsundersizedBadCrcPacketsDelta", "adaptorEthPortOutsizedStatsundersizedBadCrcPacketsDeltaAvg", "adaptorEthPortOutsizedStatsundersizedBadCrcPacketsDeltaMax", "adaptorEthPortOutsizedStatsundersizedBadCrcPacketsDeltaMin", "adaptorEthPortOutsizedStatsundersizedGoodCrcPacketsDelta", "adaptorEthPortOutsizedStatsundersizedGoodCrcPacketsDeltaAvg", "adaptorEthPortOutsizedStatsundersizedGoodCrcPacketsDeltaMax", "adaptorEthPortOutsizedStatsundersizedGoodCrcPacketsDeltaMin", "adaptorEthPortStatsgoodPacketsDelta", "adaptorEthPortStatsgoodPacketsDeltaAvg", "adaptorEthPortStatsgoodPacketsDeltaMax", "adaptorEthPortStatsgoodPacketsDeltaMin", "adaptorEthPortStatspausePacketsDelta", "adaptorEthPortStatspausePacketsDeltaAvg", "adaptorEthPortStatspausePacketsDeltaMax", "adaptorEthPortStatspausePacketsDeltaMin", "adaptorEthPortStatsperPriorityPausePacketsDelta", "adaptorEthPortStatsperPriorityPausePacketsDeltaAvg", "adaptorEthPortStatsperPriorityPausePacketsDeltaMax", "adaptorEthPortStatsperPriorityPausePacketsDeltaMin", "adaptorEthPortStatspppPacketsDelta", "adaptorEthPortStatspppPacketsDeltaAvg", "adaptorEthPortStatspppPacketsDeltaMax", "adaptorEthPortStatspppPacketsDeltaMin", "adaptorEthPortStatstotalPacketsDelta", "adaptorEthPortStatstotalPacketsDeltaAvg", "adaptorEthPortStatstotalPacketsDeltaMax", "adaptorEthPortStatstotalPacketsDeltaMin", "adaptorEthPortStatsvlanPacketsDelta", "adaptorEthPortStatsvlanPacketsDeltaAvg", "adaptorEthPortStatsvlanPacketsDeltaMax", "adaptorEthPortStatsvlanPacketsDeltaMin", "adaptorEtherIfStatsrxBytesDelta", "adaptorEtherIfStatsrxBytesDeltaAvg", "adaptorEtherIfStatsrxBytesDeltaMax", "adaptorEtherIfStatsrxBytesDeltaMin", "adaptorEtherIfStatsrxDroppedDelta", "adaptorEtherIfStatsrxDroppedDeltaAvg", "adaptorEtherIfStatsrxDroppedDeltaMax", "adaptorEtherIfStatsrxDroppedDeltaMin", "adaptorEtherIfStatsrxErrorsDelta", "adaptorEtherIfStatsrxErrorsDeltaAvg", "adaptorEtherIfStatsrxErrorsDeltaMax", "adaptorEtherIfStatsrxErrorsDeltaMin", "adaptorEtherIfStatsrxPacketsDelta", "adaptorEtherIfStatsrxPacketsDeltaAvg", "adaptorEtherIfStatsrxPacketsDeltaMax", "adaptorEtherIfStatsrxPacketsDeltaMin", "adaptorEtherIfStatstxBytesDelta", "adaptorEtherIfStatstxBytesDeltaAvg", "adaptorEtherIfStatstxBytesDeltaMax", "adaptorEtherIfStatstxBytesDeltaMin", "adaptorEtherIfStatstxDroppedDelta", "adaptorEtherIfStatstxDroppedDeltaAvg", "adaptorEtherIfStatstxDroppedDeltaMax", "adaptorEtherIfStatstxDroppedDeltaMin", "adaptorEtherIfStatstxErrorsDelta", "adaptorEtherIfStatstxErrorsDeltaAvg", "adaptorEtherIfStatstxErrorsDeltaMax", "adaptorEtherIfStatstxErrorsDeltaMin", "adaptorEtherIfStatstxPacketsDelta", "adaptorEtherIfStatstxPacketsDeltaAvg", "adaptorEtherIfStatstxPacketsDeltaMax", "adaptorEtherIfStatstxPacketsDeltaMin", "adaptorFcIfEventStatsinvalidCRCCountDelta", "adaptorFcIfEventStatsinvalidCRCCountDeltaAvg", "adaptorFcIfEventStatsinvalidCRCCountDeltaMax", "adaptorFcIfEventStatsinvalidCRCCountDeltaMin", "adaptorFcIfEventStatslinkFailureCountDelta", "adaptorFcIfEventStatslinkFailureCountDeltaAvg", "adaptorFcIfEventStatslinkFailureCountDeltaMax", "adaptorFcIfEventStatslinkFailureCountDeltaMin", "adaptorFcIfEventStatslipCountDelta", "adaptorFcIfEventStatslipCountDeltaAvg", "adaptorFcIfEventStatslipCountDeltaMax", "adaptorFcIfEventStatslipCountDeltaMin", "adaptorFcIfEventStatslossOfSignalCountDelta", "adaptorFcIfEventStatslossOfSignalCountDeltaAvg", "adaptorFcIfEventStatslossOfSignalCountDeltaMax", "adaptorFcIfEventStatslossOfSignalCountDeltaMin", "adaptorFcIfEventStatslossOfSyncCountDelta", "adaptorFcIfEventStatslossOfSyncCountDeltaAvg", "adaptorFcIfEventStatslossOfSyncCountDeltaMax", "adaptorFcIfEventStatslossOfSyncCountDeltaMin", "adaptorFcIfEventStatsnOSCountDelta", "adaptorFcIfEventStatsnOSCountDeltaAvg", "adaptorFcIfEventStatsnOSCountDeltaMax", "adaptorFcIfEventStatsnOSCountDeltaMin", "adaptorFcIfEventStatssecondsSinceLastResetDelta", "adaptorFcIfEventStatssecondsSinceLastResetDeltaAvg", "adaptorFcIfEventStatssecondsSinceLastResetDeltaMax", "adaptorFcIfEventStatssecondsSinceLastResetDeltaMin", "adaptorFcIfEventStatsseqProtocolErrCountDelta", "adaptorFcIfEventStatsseqProtocolErrCountDeltaAvg", "adaptorFcIfEventStatsseqProtocolErrCountDeltaMax", "adaptorFcIfEventStatsseqProtocolErrCountDeltaMin", "adaptorFcIfFC4StatscontrolRequestsDelta", "adaptorFcIfFC4StatscontrolRequestsDeltaAvg", "adaptorFcIfFC4StatscontrolRequestsDeltaMax", "adaptorFcIfFC4StatscontrolRequestsDeltaMin", "adaptorFcIfFC4StatsinputMegabytesDelta", "adaptorFcIfFC4StatsinputMegabytesDeltaAvg", "adaptorFcIfFC4StatsinputMegabytesDeltaMax", "adaptorFcIfFC4StatsinputMegabytesDeltaMin", "adaptorFcIfFC4StatsinputRequestsDelta", "adaptorFcIfFC4StatsinputRequestsDeltaAvg", "adaptorFcIfFC4StatsinputRequestsDeltaMax", "adaptorFcIfFC4StatsinputRequestsDeltaMin", "adaptorFcIfFC4StatsoutputMegabytesDelta", "adaptorFcIfFC4StatsoutputMegabytesDeltaAvg", "adaptorFcIfFC4StatsoutputMegabytesDeltaMax", "adaptorFcIfFC4StatsoutputMegabytesDeltaMin", "adaptorFcIfFC4StatsoutputRequestsDelta", "adaptorFcIfFC4StatsoutputRequestsDeltaAvg", "adaptorFcIfFC4StatsoutputRequestsDeltaMax", "adaptorFcIfFC4StatsoutputRequestsDeltaMin", "adaptorFcIfFrameStatsdumpedFramesDelta", "adaptorFcIfFrameStatsdumpedFramesDeltaAvg", "adaptorFcIfFrameStatsdumpedFramesDeltaMax", "adaptorFcIfFrameStatsdumpedFramesDeltaMin", "adaptorFcIfFrameStatserrorFramesDelta", "adaptorFcIfFrameStatserrorFramesDeltaAvg", "adaptorFcIfFrameStatserrorFramesDeltaMax", "adaptorFcIfFrameStatserrorFramesDeltaMin", "adaptorFcIfFrameStatsrxFramesDelta", "adaptorFcIfFrameStatsrxFramesDeltaAvg", "adaptorFcIfFrameStatsrxFramesDeltaMax", "adaptorFcIfFrameStatsrxFramesDeltaMin", "adaptorFcIfFrameStatstxFramesDelta", "adaptorFcIfFrameStatstxFramesDeltaAvg", "adaptorFcIfFrameStatstxFramesDeltaMax", "adaptorFcIfFrameStatstxFramesDeltaMin", "adaptorFcPortStatsrxBadFramesDelta", "adaptorFcPortStatsrxBadFramesDeltaAvg", "adaptorFcPortStatsrxBadFramesDeltaMax", "adaptorFcPortStatsrxBadFramesDeltaMin", "adaptorFcPortStatsrxFramesDelta", "adaptorFcPortStatsrxFramesDeltaAvg", "adaptorFcPortStatsrxFramesDeltaMax", "adaptorFcPortStatsrxFramesDeltaMin", "adaptorFcPortStatstxBadFramesDelta", "adaptorFcPortStatstxBadFramesDeltaAvg", "adaptorFcPortStatstxBadFramesDeltaMax", "adaptorFcPortStatstxBadFramesDeltaMin", "adaptorFcPortStatstxFramesDelta", "adaptorFcPortStatstxFramesDeltaAvg", "adaptorFcPortStatstxFramesDeltaMax", "adaptorFcPortStatstxFramesDeltaMin", "adaptorMenloBaseErrorStatscorrectableErrorsDelta", "adaptorMenloBaseErrorStatscorrectableErrorsDeltaAvg", "adaptorMenloBaseErrorStatscorrectableErrorsDeltaMax", "adaptorMenloBaseErrorStatscorrectableErrorsDeltaMin", "adaptorMenloBaseErrorStatsuncorrectableErrorsDelta", "adaptorMenloBaseErrorStatsuncorrectableErrorsDeltaAvg", "adaptorMenloBaseErrorStatsuncorrectableErrorsDeltaMax", "adaptorMenloBaseErrorStatsuncorrectableErrorsDeltaMin", "adaptorMenloDcePortStatsrxPauseCFCDelta", "adaptorMenloDcePortStatsrxPauseCFCDeltaAvg", "adaptorMenloDcePortStatsrxPauseCFCDeltaMax", "adaptorMenloDcePortStatsrxPauseCFCDeltaMin", "adaptorMenloDcePortStatsrxPausePFCDelta", "adaptorMenloDcePortStatsrxPausePFCDeltaAvg", "adaptorMenloDcePortStatsrxPausePFCDeltaMax", "adaptorMenloDcePortStatsrxPausePFCDeltaMin", "adaptorMenloDcePortStatstxPauseCFCDelta", "adaptorMenloDcePortStatstxPauseCFCDeltaAvg", "adaptorMenloDcePortStatstxPauseCFCDeltaMax", "adaptorMenloDcePortStatstxPauseCFCDeltaMin", "adaptorMenloDcePortStatstxPausePFCDelta", "adaptorMenloDcePortStatstxPausePFCDeltaAvg", "adaptorMenloDcePortStatstxPausePFCDeltaMax", "adaptorMenloDcePortStatstxPausePFCDeltaMin", "adaptorMenloEthErrorStatscorrectableErrorsDelta", "adaptorMenloEthErrorStatscorrectableErrorsDeltaAvg", "adaptorMenloEthErrorStatscorrectableErrorsDeltaMax", "adaptorMenloEthErrorStatscorrectableErrorsDeltaMin", "adaptorMenloEthErrorStatsdropAclDelta", "adaptorMenloEthErrorStatsdropAclDeltaAvg", "adaptorMenloEthErrorStatsdropAclDeltaMax", "adaptorMenloEthErrorStatsdropAclDeltaMin", "adaptorMenloEthErrorStatspopErrorsDelta", "adaptorMenloEthErrorStatspopErrorsDeltaAvg", "adaptorMenloEthErrorStatspopErrorsDeltaMax", "adaptorMenloEthErrorStatspopErrorsDeltaMin", "adaptorMenloEthErrorStatspushErrorsDelta", "adaptorMenloEthErrorStatspushErrorsDeltaAvg", "adaptorMenloEthErrorStatspushErrorsDeltaMax", "adaptorMenloEthErrorStatspushErrorsDeltaMin", "adaptorMenloEthErrorStatsuncorrectableErrorsDelta", "adaptorMenloEthErrorStatsuncorrectableErrorsDeltaAvg", "adaptorMenloEthErrorStatsuncorrectableErrorsDeltaMax", "adaptorMenloEthErrorStatsuncorrectableErrorsDeltaMin", "adaptorMenloEthStatsdropOverrunDelta", "adaptorMenloEthStatsdropOverrunDeltaAvg", "adaptorMenloEthStatsdropOverrunDeltaMax", "adaptorMenloEthStatsdropOverrunDeltaMin", "adaptorMenloEthStatsdropRuntDelta", "adaptorMenloEthStatsdropRuntDeltaAvg", "adaptorMenloEthStatsdropRuntDeltaMax", "adaptorMenloEthStatsdropRuntDeltaMin", "adaptorMenloEthStatstruncateOverrunDelta", "adaptorMenloEthStatstruncateOverrunDeltaAvg", "adaptorMenloEthStatstruncateOverrunDeltaMax", "adaptorMenloEthStatstruncateOverrunDeltaMin", "adaptorMenloFcErrorStatscorrectableErrorsDelta", "adaptorMenloFcErrorStatscorrectableErrorsDeltaAvg", "adaptorMenloFcErrorStatscorrectableErrorsDeltaMax", "adaptorMenloFcErrorStatscorrectableErrorsDeltaMin", "adaptorMenloFcErrorStatspopErrorsDelta", "adaptorMenloFcErrorStatspopErrorsDeltaAvg", "adaptorMenloFcErrorStatspopErrorsDeltaMax", "adaptorMenloFcErrorStatspopErrorsDeltaMin", "adaptorMenloFcErrorStatspushErrorsDelta", "adaptorMenloFcErrorStatspushErrorsDeltaAvg", "adaptorMenloFcErrorStatspushErrorsDeltaMax", "adaptorMenloFcErrorStatspushErrorsDeltaMin", "adaptorMenloFcErrorStatsuncorrectableErrorsDelta", "adaptorMenloFcErrorStatsuncorrectableErrorsDeltaAvg", "adaptorMenloFcErrorStatsuncorrectableErrorsDeltaMax", "adaptorMenloFcErrorStatsuncorrectableErrorsDeltaMin", "adaptorMenloFcStatsdropAclDelta", "adaptorMenloFcStatsdropAclDeltaAvg", "adaptorMenloFcStatsdropAclDeltaMax", "adaptorMenloFcStatsdropAclDeltaMin", "adaptorMenloFcStatsdropOverrunDelta", "adaptorMenloFcStatsdropOverrunDeltaAvg", "adaptorMenloFcStatsdropOverrunDeltaMax", "adaptorMenloFcStatsdropOverrunDeltaMin", "adaptorMenloFcStatsdropRuntDelta", "adaptorMenloFcStatsdropRuntDeltaAvg", "adaptorMenloFcStatsdropRuntDeltaMax", "adaptorMenloFcStatsdropRuntDeltaMin", "adaptorMenloFcStatstruncateOverrunDelta", "adaptorMenloFcStatstruncateOverrunDeltaAvg", "adaptorMenloFcStatstruncateOverrunDeltaMax", "adaptorMenloFcStatstruncateOverrunDeltaMin", "adaptorMenloHostPortStatsrxPauseCFCDelta", "adaptorMenloHostPortStatsrxPauseCFCDeltaAvg", "adaptorMenloHostPortStatsrxPauseCFCDeltaMax", "adaptorMenloHostPortStatsrxPauseCFCDeltaMin", "adaptorMenloHostPortStatsrxPausePFCDelta", "adaptorMenloHostPortStatsrxPausePFCDeltaAvg", "adaptorMenloHostPortStatsrxPausePFCDeltaMax", "adaptorMenloHostPortStatsrxPausePFCDeltaMin", "adaptorMenloHostPortStatstxPauseCFCDelta", "adaptorMenloHostPortStatstxPauseCFCDeltaAvg", "adaptorMenloHostPortStatstxPauseCFCDeltaMax", "adaptorMenloHostPortStatstxPauseCFCDeltaMin", "adaptorMenloHostPortStatstxPausePFCDelta", "adaptorMenloHostPortStatstxPausePFCDeltaAvg", "adaptorMenloHostPortStatstxPausePFCDeltaMax", "adaptorMenloHostPortStatstxPausePFCDeltaMin", "adaptorMenloMcpuErrorStatscorrectableErrorsDelta", "adaptorMenloMcpuErrorStatscorrectableErrorsDeltaAvg", "adaptorMenloMcpuErrorStatscorrectableErrorsDeltaMax", "adaptorMenloMcpuErrorStatscorrectableErrorsDeltaMin", "adaptorMenloMcpuErrorStatspopErrorsDelta", "adaptorMenloMcpuErrorStatspopErrorsDeltaAvg", "adaptorMenloMcpuErrorStatspopErrorsDeltaMax", "adaptorMenloMcpuErrorStatspopErrorsDeltaMin", "adaptorMenloMcpuErrorStatspushErrorsDelta", "adaptorMenloMcpuErrorStatspushErrorsDeltaAvg", "adaptorMenloMcpuErrorStatspushErrorsDeltaMax", "adaptorMenloMcpuErrorStatspushErrorsDeltaMin", "adaptorMenloMcpuErrorStatsuncorrectableErrorsDelta", "adaptorMenloMcpuErrorStatsuncorrectableErrorsDeltaAvg", "adaptorMenloMcpuErrorStatsuncorrectableErrorsDeltaMax", "adaptorMenloMcpuErrorStatsuncorrectableErrorsDeltaMin", "adaptorMenloMcpuStatsdropAclDelta", "adaptorMenloMcpuStatsdropAclDeltaAvg", "adaptorMenloMcpuStatsdropAclDeltaMax", "adaptorMenloMcpuStatsdropAclDeltaMin", "adaptorMenloMcpuStatsdropOverrunDelta", "adaptorMenloMcpuStatsdropOverrunDeltaAvg", "adaptorMenloMcpuStatsdropOverrunDeltaMax", "adaptorMenloMcpuStatsdropOverrunDeltaMin", "adaptorMenloMcpuStatsdropRuntDelta", "adaptorMenloMcpuStatsdropRuntDeltaAvg", "adaptorMenloMcpuStatsdropRuntDeltaMax", "adaptorMenloMcpuStatsdropRuntDeltaMin", "adaptorMenloMcpuStatstruncateOverrunDelta", "adaptorMenloMcpuStatstruncateOverrunDeltaAvg", "adaptorMenloMcpuStatstruncateOverrunDeltaMax", "adaptorMenloMcpuStatstruncateOverrunDeltaMin", "adaptorMenloNetEgStatsdropCmdDelta", "adaptorMenloNetEgStatsdropCmdDeltaAvg", "adaptorMenloNetEgStatsdropCmdDeltaMax", "adaptorMenloNetEgStatsdropCmdDeltaMin", "adaptorMenloNetEgStatsdropLifCfgInvalidDelta", "adaptorMenloNetEgStatsdropLifCfgInvalidDeltaAvg", "adaptorMenloNetEgStatsdropLifCfgInvalidDeltaMax", "adaptorMenloNetEgStatsdropLifCfgInvalidDeltaMin", "adaptorMenloNetEgStatsdropLifMapNoHitDelta", "adaptorMenloNetEgStatsdropLifMapNoHitDeltaAvg", "adaptorMenloNetEgStatsdropLifMapNoHitDeltaMax", "adaptorMenloNetEgStatsdropLifMapNoHitDeltaMin", "adaptorMenloNetEgStatsdropSrcBindDelta", "adaptorMenloNetEgStatsdropSrcBindDeltaAvg", "adaptorMenloNetEgStatsdropSrcBindDeltaMax", "adaptorMenloNetEgStatsdropSrcBindDeltaMin", "adaptorMenloNetEgStatslearnReqDropDelta", "adaptorMenloNetEgStatslearnReqDropDeltaAvg", "adaptorMenloNetEgStatslearnReqDropDeltaMax", "adaptorMenloNetEgStatslearnReqDropDeltaMin", "adaptorMenloNetInStatsdropFcLifInvalidDelta", "adaptorMenloNetInStatsdropFcLifInvalidDeltaAvg", "adaptorMenloNetInStatsdropFcLifInvalidDeltaMax", "adaptorMenloNetInStatsdropFcLifInvalidDeltaMin", "adaptorMenloNetInStatsdropFcMulticastDelta", "adaptorMenloNetInStatsdropFcMulticastDeltaAvg", "adaptorMenloNetInStatsdropFcMulticastDeltaMax", "adaptorMenloNetInStatsdropFcMulticastDeltaMin", "adaptorMenloNetInStatsdropNullPifDelta", "adaptorMenloNetInStatsdropNullPifDeltaAvg", "adaptorMenloNetInStatsdropNullPifDeltaMax", "adaptorMenloNetInStatsdropNullPifDeltaMin", "adaptorMenloNetInStatsfwdLookupNoHitDelta", "adaptorMenloNetInStatsfwdLookupNoHitDeltaAvg", "adaptorMenloNetInStatsfwdLookupNoHitDeltaMax", "adaptorMenloNetInStatsfwdLookupNoHitDeltaMin", "adaptorMenloQErrorStatscorrectableErrorsDelta", "adaptorMenloQErrorStatscorrectableErrorsDeltaAvg", "adaptorMenloQErrorStatscorrectableErrorsDeltaMax", "adaptorMenloQErrorStatscorrectableErrorsDeltaMin", "adaptorMenloQErrorStatspopErrorsDelta", "adaptorMenloQErrorStatspopErrorsDeltaAvg", "adaptorMenloQErrorStatspopErrorsDeltaMax", "adaptorMenloQErrorStatspopErrorsDeltaMin", "adaptorMenloQErrorStatspushErrorsDelta", "adaptorMenloQErrorStatspushErrorsDeltaAvg", "adaptorMenloQErrorStatspushErrorsDeltaMax", "adaptorMenloQErrorStatspushErrorsDeltaMin", "adaptorMenloQErrorStatsuncorrectableErrorsDelta", "adaptorMenloQErrorStatsuncorrectableErrorsDeltaAvg", "adaptorMenloQErrorStatsuncorrectableErrorsDeltaMax", "adaptorMenloQErrorStatsuncorrectableErrorsDeltaMin", "adaptorMenloQStatsdropOverrunN0Delta", "adaptorMenloQStatsdropOverrunN0DeltaAvg", "adaptorMenloQStatsdropOverrunN0DeltaMax", "adaptorMenloQStatsdropOverrunN0DeltaMin", "adaptorMenloQStatsdropOverrunN1Delta", "adaptorMenloQStatsdropOverrunN1DeltaAvg", "adaptorMenloQStatsdropOverrunN1DeltaMax", "adaptorMenloQStatsdropOverrunN1DeltaMin", "adaptorMenloQStatstruncateOverrunN0Delta", "adaptorMenloQStatstruncateOverrunN0DeltaAvg", "adaptorMenloQStatstruncateOverrunN0DeltaMax", "adaptorMenloQStatstruncateOverrunN0DeltaMin", "adaptorMenloQStatstruncateOverrunN1Delta", "adaptorMenloQStatstruncateOverrunN1DeltaAvg", "adaptorMenloQStatstruncateOverrunN1DeltaMax", "adaptorMenloQStatstruncateOverrunN1DeltaMin", "adaptorVnicStatsbytesRxDelta", "adaptorVnicStatsbytesRxDeltaAvg", "adaptorVnicStatsbytesRxDeltaMax", "adaptorVnicStatsbytesRxDeltaMin", "adaptorVnicStatsbytesTxDelta", "adaptorVnicStatsbytesTxDeltaAvg", "adaptorVnicStatsbytesTxDeltaMax", "adaptorVnicStatsbytesTxDeltaMin", "adaptorVnicStatsdroppedRxDelta", "adaptorVnicStatsdroppedRxDeltaAvg", "adaptorVnicStatsdroppedRxDeltaMax", "adaptorVnicStatsdroppedRxDeltaMin", "adaptorVnicStatsdroppedTxDelta", "adaptorVnicStatsdroppedTxDeltaAvg", "adaptorVnicStatsdroppedTxDeltaMax", "adaptorVnicStatsdroppedTxDeltaMin", "adaptorVnicStatserrorsRxDelta", "adaptorVnicStatserrorsRxDeltaAvg", "adaptorVnicStatserrorsRxDeltaMax", "adaptorVnicStatserrorsRxDeltaMin", "adaptorVnicStatserrorsTxDelta", "adaptorVnicStatserrorsTxDeltaAvg", "adaptorVnicStatserrorsTxDeltaMax", "adaptorVnicStatserrorsTxDeltaMin", "adaptorVnicStatspacketsRxDelta", "adaptorVnicStatspacketsRxDeltaAvg", "adaptorVnicStatspacketsRxDeltaMax", "adaptorVnicStatspacketsRxDeltaMin", "adaptorVnicStatspacketsTxDelta", "adaptorVnicStatspacketsTxDeltaAvg", "adaptorVnicStatspacketsTxDeltaMax", "adaptorVnicStatspacketsTxDeltaMin", "computeIOHubEnvStatstemperature", "computeIOHubEnvStatstemperatureAvg", "computeIOHubEnvStatstemperatureMax", "computeIOHubEnvStatstemperatureMin", "computeMbPowerStatsconsumedPower", "computeMbPowerStatsconsumedPowerAvg", "computeMbPowerStatsconsumedPowerMax", "computeMbPowerStatsconsumedPowerMin", "computeMbPowerStatsinputCurrent", "computeMbPowerStatsinputCurrentAvg", "computeMbPowerStatsinputCurrentMax", "computeMbPowerStatsinputCurrentMin", "computeMbPowerStatsinputVoltage", "computeMbPowerStatsinputVoltageAvg", "computeMbPowerStatsinputVoltageMax", "computeMbPowerStatsinputVoltageMin", "computeMbTempStatsfmTempSenIo", "computeMbTempStatsfmTempSenIoAvg", "computeMbTempStatsfmTempSenIoMax", "computeMbTempStatsfmTempSenIoMin", "computeMbTempStatsfmTempSenRear", "computeMbTempStatsfmTempSenRearAvg", "computeMbTempStatsfmTempSenRearL", "computeMbTempStatsfmTempSenRearLAvg", "computeMbTempStatsfmTempSenRearLMax", "computeMbTempStatsfmTempSenRearLMin", "computeMbTempStatsfmTempSenRearMax", "computeMbTempStatsfmTempSenRearMin", "computeMbTempStatsfmTempSenRearR", "computeMbTempStatsfmTempSenRearRAvg", "computeMbTempStatsfmTempSenRearRMax", "computeMbTempStatsfmTempSenRearRMin", "computePCIeFatalCompletionStatsAbortErrors", "computePCIeFatalCompletionStatsTimeoutErrors", "computePCIeFatalCompletionStatsunexpectedErrors", "computePCIeFatalProtocolStatsdllpErrors", "computePCIeFatalProtocolStatsflowControlErrors", "computePCIeFatalReceiveStatsbufferOverflowErrors", "computePCIeFatalReceiveStatserrFatalErrors", "computePCIeFatalReceiveStatserrNonFatalErrors", "computePCIeFatalReceiveStatsunsupportedRequestErrors", "computePCIeFatalStatsacsViolationErrors", "computePCIeFatalStatsmalformedTLPErrors", "computePCIeFatalStatspoisonedTLPErrors", "computePCIeFatalStatssurpriseLinkDownErrors", "computeRackUnitMbTempStatsambientTemp", "computeRackUnitMbTempStatsambientTempAvg", "computeRackUnitMbTempStatsambientTempMax", "computeRackUnitMbTempStatsambientTempMin", "computeRackUnitMbTempStatsfrontTemp", "computeRackUnitMbTempStatsfrontTempAvg", "computeRackUnitMbTempStatsfrontTempMax", "computeRackUnitMbTempStatsfrontTempMin", "computeRackUnitMbTempStatsioh1Temp", "computeRackUnitMbTempStatsioh1TempAvg", "computeRackUnitMbTempStatsioh1TempMax", "computeRackUnitMbTempStatsioh1TempMin", "computeRackUnitMbTempStatsioh2Temp", "computeRackUnitMbTempStatsioh2TempAvg", "computeRackUnitMbTempStatsioh2TempMax", "computeRackUnitMbTempStatsioh2TempMin", "computeRackUnitMbTempStatsrearTemp", "computeRackUnitMbTempStatsrearTempAvg", "computeRackUnitMbTempStatsrearTempMax", "computeRackUnitMbTempStatsrearTempMin", "equipmentChassisStatsinputPower", "equipmentChassisStatsinputPowerAvg", "equipmentChassisStatsinputPowerMax", "equipmentChassisStatsinputPowerMin", "equipmentChassisStatsoutputPower", "equipmentChassisStatsoutputPowerAvg", "equipmentChassisStatsoutputPowerMax", "equipmentChassisStatsoutputPowerMin", "equipmentFanModuleStatsambientTemp", "equipmentFanModuleStatsambientTempAvg", "equipmentFanModuleStatsambientTempMax", "equipmentFanModuleStatsambientTempMin", "equipmentFanStatsspeed", "equipmentFanStatsspeedAvg", "equipmentFanStatsspeedMax", "equipmentFanStatsspeedMin", "equipmentFexEnvStatsdie1", "equipmentFexEnvStatsdie1Avg", "equipmentFexEnvStatsdie1Max", "equipmentFexEnvStatsdie1Min", "equipmentFexEnvStatsinlet", "equipmentFexEnvStatsinlet1", "equipmentFexEnvStatsinlet1Avg", "equipmentFexEnvStatsinlet1Max", "equipmentFexEnvStatsinlet1Min", "equipmentFexEnvStatsinletAvg", "equipmentFexEnvStatsinletMax", "equipmentFexEnvStatsinletMin", "equipmentFexEnvStatsoutlet1", "equipmentFexEnvStatsoutlet1Avg", "equipmentFexEnvStatsoutlet1Max", "equipmentFexEnvStatsoutlet1Min", "equipmentFexEnvStatsoutlet2", "equipmentFexEnvStatsoutlet2Avg", "equipmentFexEnvStatsoutlet2Max", "equipmentFexEnvStatsoutlet2Min", "equipmentFexPowerSummaryModulePower", "equipmentFexPowerSummaryModulePowerAvg", "equipmentFexPowerSummaryModulePowerMax", "equipmentFexPowerSummaryModulePowerMin", "equipmentFexPowerSummaryavailablePower", "equipmentFexPowerSummaryavailablePowerAvg", "equipmentFexPowerSummaryavailablePowerMax", "equipmentFexPowerSummaryavailablePowerMin", "equipmentFexPowerSummaryreservedPower", "equipmentFexPowerSummaryreservedPowerAvg", "equipmentFexPowerSummaryreservedPowerMax", "equipmentFexPowerSummaryreservedPowerMin", "equipmentFexPowerSummarytotalPower", "equipmentFexPowerSummarytotalPowerAvg", "equipmentFexPowerSummarytotalPowerMax", "equipmentFexPowerSummarytotalPowerMin", "equipmentFexPsuInputStatscurrent", "equipmentFexPsuInputStatscurrentAvg", "equipmentFexPsuInputStatscurrentMax", "equipmentFexPsuInputStatscurrentMin", "equipmentFexPsuInputStatspower", "equipmentFexPsuInputStatspowerAvg", "equipmentFexPsuInputStatspowerMax", "equipmentFexPsuInputStatspowerMin", "equipmentFexPsuInputStatsvoltage", "equipmentFexPsuInputStatsvoltageAvg", "equipmentFexPsuInputStatsvoltageMax", "equipmentFexPsuInputStatsvoltageMin", "equipmentIOCardStatsambientTemp", "equipmentIOCardStatsambientTempAvg", "equipmentIOCardStatsambientTempMax", "equipmentIOCardStatsambientTempMin", "equipmentIOCardStatstemp", "equipmentIOCardStatstempAvg", "equipmentIOCardStatstempMax", "equipmentIOCardStatstempMin", "equipmentNetworkElementFanStatsdrivePercentage", "equipmentNetworkElementFanStatsdrivePercentageAvg", "equipmentNetworkElementFanStatsdrivePercentageMax", "equipmentNetworkElementFanStatsdrivePercentageMin", "equipmentNetworkElementFanStatsspeed", "equipmentNetworkElementFanStatsspeedAvg", "equipmentNetworkElementFanStatsspeedMax", "equipmentNetworkElementFanStatsspeedMin", "equipmentPsuInputStatscurrent", "equipmentPsuInputStatscurrentAvg", "equipmentPsuInputStatscurrentMax", "equipmentPsuInputStatscurrentMin", "equipmentPsuInputStatspower", "equipmentPsuInputStatspowerAvg", "equipmentPsuInputStatspowerMax", "equipmentPsuInputStatspowerMin", "equipmentPsuInputStatsvoltage", "equipmentPsuInputStatsvoltageAvg", "equipmentPsuInputStatsvoltageMax", "equipmentPsuInputStatsvoltageMin", "equipmentPsuOutputStatscurrent", "equipmentPsuOutputStatscurrentAvg", "equipmentPsuOutputStatscurrentMax", "equipmentPsuOutputStatscurrentMin", "equipmentPsuOutputStatspower", "equipmentPsuOutputStatspowerAvg", "equipmentPsuOutputStatspowerMax", "equipmentPsuOutputStatspowerMin", "equipmentPsuOutputStatsvoltage", "equipmentPsuOutputStatsvoltageAvg", "equipmentPsuOutputStatsvoltageMax", "equipmentPsuOutputStatsvoltageMin", "equipmentPsuStatsambientTemp", "equipmentPsuStatsambientTempAvg", "equipmentPsuStatsambientTempMax", "equipmentPsuStatsambientTempMin", "equipmentPsuStatsinput210v", "equipmentPsuStatsinput210vAvg", "equipmentPsuStatsinput210vMax", "equipmentPsuStatsinput210vMin", "equipmentPsuStatsoutput12v", "equipmentPsuStatsoutput12vAvg", "equipmentPsuStatsoutput12vMax", "equipmentPsuStatsoutput12vMin", "equipmentPsuStatsoutput3v3", "equipmentPsuStatsoutput3v3Avg", "equipmentPsuStatsoutput3v3Max", "equipmentPsuStatsoutput3v3Min", "equipmentPsuStatsoutputCurrent", "equipmentPsuStatsoutputCurrentAvg", "equipmentPsuStatsoutputCurrentMax", "equipmentPsuStatsoutputCurrentMin", "equipmentPsuStatsoutputPower", "equipmentPsuStatsoutputPowerAvg", "equipmentPsuStatsoutputPowerMax", "equipmentPsuStatsoutputPowerMin", "equipmentRackUnitFanStatsspeed", "equipmentRackUnitFanStatsspeedAvg", "equipmentRackUnitFanStatsspeedMax", "equipmentRackUnitFanStatsspeedMin", "equipmentRackUnitPsuStatsambientTemp", "equipmentRackUnitPsuStatsambientTempAvg", "equipmentRackUnitPsuStatsambientTempMax", "equipmentRackUnitPsuStatsambientTempMin", "equipmentRackUnitPsuStatsinputPower", "equipmentRackUnitPsuStatsinputPowerAvg", "equipmentRackUnitPsuStatsinputPowerMax", "equipmentRackUnitPsuStatsinputPowerMin", "equipmentRackUnitPsuStatsinputVoltage", "equipmentRackUnitPsuStatsinputVoltageAvg", "equipmentRackUnitPsuStatsinputVoltageMax", "equipmentRackUnitPsuStatsinputVoltageMin", "equipmentRackUnitPsuStatsoutputCurrent", "equipmentRackUnitPsuStatsoutputCurrentAvg", "equipmentRackUnitPsuStatsoutputCurrentMax", "equipmentRackUnitPsuStatsoutputCurrentMin", "equipmentRackUnitPsuStatsoutputPower", "equipmentRackUnitPsuStatsoutputPowerAvg", "equipmentRackUnitPsuStatsoutputPowerMax", "equipmentRackUnitPsuStatsoutputPowerMin", "equipmentRackUnitPsuStatsoutputVoltage", "equipmentRackUnitPsuStatsoutputVoltageAvg", "equipmentRackUnitPsuStatsoutputVoltageMax", "equipmentRackUnitPsuStatsoutputVoltageMin", "etherErrStatsalignDelta", "etherErrStatsalignDeltaAvg", "etherErrStatsalignDeltaMax", "etherErrStatsalignDeltaMin", "etherErrStatsdeferredTxDelta", "etherErrStatsdeferredTxDeltaAvg", "etherErrStatsdeferredTxDeltaMax", "etherErrStatsdeferredTxDeltaMin", "etherErrStatsfcsDelta", "etherErrStatsfcsDeltaAvg", "etherErrStatsfcsDeltaMax", "etherErrStatsfcsDeltaMin", "etherErrStatsintMacRxDelta", "etherErrStatsintMacRxDeltaAvg", "etherErrStatsintMacRxDeltaMax", "etherErrStatsintMacRxDeltaMin", "etherErrStatsintMacTxDelta", "etherErrStatsintMacTxDeltaAvg", "etherErrStatsintMacTxDeltaMax", "etherErrStatsintMacTxDeltaMin", "etherErrStatsoutDiscardDelta", "etherErrStatsoutDiscardDeltaAvg", "etherErrStatsoutDiscardDeltaMax", "etherErrStatsoutDiscardDeltaMin", "etherErrStatsrcvDelta", "etherErrStatsrcvDeltaAvg", "etherErrStatsrcvDeltaMax", "etherErrStatsrcvDeltaMin", "etherErrStatsunderSizeDelta", "etherErrStatsunderSizeDeltaAvg", "etherErrStatsunderSizeDeltaMax", "etherErrStatsunderSizeDeltaMin", "etherErrStatsxmitDelta", "etherErrStatsxmitDeltaAvg", "etherErrStatsxmitDeltaMax", "etherErrStatsxmitDeltaMin", "etherFcoeInterfaceStatsbytesRxDelta", "etherFcoeInterfaceStatsbytesRxDeltaAvg", "etherFcoeInterfaceStatsbytesRxDeltaMax", "etherFcoeInterfaceStatsbytesRxDeltaMin", "etherFcoeInterfaceStatsbytesTxDelta", "etherFcoeInterfaceStatsbytesTxDeltaAvg", "etherFcoeInterfaceStatsbytesTxDeltaMax", "etherFcoeInterfaceStatsbytesTxDeltaMin", "etherFcoeInterfaceStatsdroppedRxDelta", "etherFcoeInterfaceStatsdroppedRxDeltaAvg", "etherFcoeInterfaceStatsdroppedRxDeltaMax", "etherFcoeInterfaceStatsdroppedRxDeltaMin", "etherFcoeInterfaceStatsdroppedTxDelta", "etherFcoeInterfaceStatsdroppedTxDeltaAvg", "etherFcoeInterfaceStatsdroppedTxDeltaMax", "etherFcoeInterfaceStatsdroppedTxDeltaMin", "etherFcoeInterfaceStatserrorsRxDelta", "etherFcoeInterfaceStatserrorsRxDeltaAvg", "etherFcoeInterfaceStatserrorsRxDeltaMax", "etherFcoeInterfaceStatserrorsRxDeltaMin", "etherFcoeInterfaceStatserrorsTxDelta", "etherFcoeInterfaceStatserrorsTxDeltaAvg", "etherFcoeInterfaceStatserrorsTxDeltaMax", "etherFcoeInterfaceStatserrorsTxDeltaMin", "etherFcoeInterfaceStatspacketsRxDelta", "etherFcoeInterfaceStatspacketsRxDeltaAvg", "etherFcoeInterfaceStatspacketsRxDeltaMax", "etherFcoeInterfaceStatspacketsRxDeltaMin", "etherFcoeInterfaceStatspacketsTxDelta", "etherFcoeInterfaceStatspacketsTxDeltaAvg", "etherFcoeInterfaceStatspacketsTxDeltaMax", "etherFcoeInterfaceStatspacketsTxDeltaMin", "etherLossStatsSQETestDelta", "etherLossStatsSQETestDeltaAvg", "etherLossStatsSQETestDeltaMax", "etherLossStatsSQETestDeltaMin", "etherLossStatscarrierSenseDelta", "etherLossStatscarrierSenseDeltaAvg", "etherLossStatscarrierSenseDeltaMax", "etherLossStatscarrierSenseDeltaMin", "etherLossStatsexcessCollisionDelta", "etherLossStatsexcessCollisionDeltaAvg", "etherLossStatsexcessCollisionDeltaMax", "etherLossStatsexcessCollisionDeltaMin", "etherLossStatsgiantsDelta", "etherLossStatsgiantsDeltaAvg", "etherLossStatsgiantsDeltaMax", "etherLossStatsgiantsDeltaMin", "etherLossStatslateCollisionDelta", "etherLossStatslateCollisionDeltaAvg", "etherLossStatslateCollisionDeltaMax", "etherLossStatslateCollisionDeltaMin", "etherLossStatsmultiCollisionDelta", "etherLossStatsmultiCollisionDeltaAvg", "etherLossStatsmultiCollisionDeltaMax", "etherLossStatsmultiCollisionDeltaMin", "etherLossStatssingleCollisionDelta", "etherLossStatssingleCollisionDeltaAvg", "etherLossStatssingleCollisionDeltaMax", "etherLossStatssingleCollisionDeltaMin", "etherLossStatssymbolDelta", "etherLossStatssymbolDeltaAvg", "etherLossStatssymbolDeltaMax", "etherLossStatssymbolDeltaMin", "etherPauseStatsrecvPauseDelta", "etherPauseStatsrecvPauseDeltaAvg", "etherPauseStatsrecvPauseDeltaMax", "etherPauseStatsrecvPauseDeltaMin", "etherPauseStatsresetsDelta", "etherPauseStatsresetsDeltaAvg", "etherPauseStatsresetsDeltaMax", "etherPauseStatsresetsDeltaMin", "etherPauseStatsxmitPauseDelta", "etherPauseStatsxmitPauseDeltaAvg", "etherPauseStatsxmitPauseDeltaMax", "etherPauseStatsxmitPauseDeltaMin", "etherRxStatsbroadcastPacketsDelta", "etherRxStatsbroadcastPacketsDeltaAvg", "etherRxStatsbroadcastPacketsDeltaMax", "etherRxStatsbroadcastPacketsDeltaMin", "etherRxStatsjumboPacketsDelta", "etherRxStatsjumboPacketsDeltaAvg", "etherRxStatsjumboPacketsDeltaMax", "etherRxStatsjumboPacketsDeltaMin", "etherRxStatsmulticastPacketsDelta", "etherRxStatsmulticastPacketsDeltaAvg", "etherRxStatsmulticastPacketsDeltaMax", "etherRxStatsmulticastPacketsDeltaMin", "etherRxStatstotalBytesDelta", "etherRxStatstotalBytesDeltaAvg", "etherRxStatstotalBytesDeltaMax", "etherRxStatstotalBytesDeltaMin", "etherRxStatstotalPacketsDelta", "etherRxStatstotalPacketsDeltaAvg", "etherRxStatstotalPacketsDeltaMax", "etherRxStatstotalPacketsDeltaMin", "etherRxStatsunicastPacketsDelta", "etherRxStatsunicastPacketsDeltaAvg", "etherRxStatsunicastPacketsDeltaMax", "etherRxStatsunicastPacketsDeltaMin", "etherTxStatsbroadcastPacketsDelta", "etherTxStatsbroadcastPacketsDeltaAvg", "etherTxStatsbroadcastPacketsDeltaMax", "etherTxStatsbroadcastPacketsDeltaMin", "etherTxStatsjumboPacketsDelta", "etherTxStatsjumboPacketsDeltaAvg", "etherTxStatsjumboPacketsDeltaMax", "etherTxStatsjumboPacketsDeltaMin", "etherTxStatsmulticastPacketsDelta", "etherTxStatsmulticastPacketsDeltaAvg", "etherTxStatsmulticastPacketsDeltaMax", "etherTxStatsmulticastPacketsDeltaMin", "etherTxStatstotalBytesDelta", "etherTxStatstotalBytesDeltaAvg", "etherTxStatstotalBytesDeltaMax", "etherTxStatstotalBytesDeltaMin", "etherTxStatstotalPacketsDelta", "etherTxStatstotalPacketsDeltaAvg", "etherTxStatstotalPacketsDeltaMax", "etherTxStatstotalPacketsDeltaMin", "etherTxStatsunicastPacketsDelta", "etherTxStatsunicastPacketsDeltaAvg", "etherTxStatsunicastPacketsDeltaMax", "etherTxStatsunicastPacketsDeltaMin", "fcErrStatscrcRxDelta", "fcErrStatscrcRxDeltaAvg", "fcErrStatscrcRxDeltaMax", "fcErrStatscrcRxDeltaMin", "fcErrStatsdiscardRxDelta", "fcErrStatsdiscardRxDeltaAvg", "fcErrStatsdiscardRxDeltaMax", "fcErrStatsdiscardRxDeltaMin", "fcErrStatsdiscardTxDelta", "fcErrStatsdiscardTxDeltaAvg", "fcErrStatsdiscardTxDeltaMax", "fcErrStatsdiscardTxDeltaMin", "fcErrStatslinkFailuresDelta", "fcErrStatslinkFailuresDeltaAvg", "fcErrStatslinkFailuresDeltaMax", "fcErrStatslinkFailuresDeltaMin", "fcErrStatsrxDelta", "fcErrStatsrxDeltaAvg", "fcErrStatsrxDeltaMax", "fcErrStatsrxDeltaMin", "fcErrStatssignalLossesDelta", "fcErrStatssignalLossesDeltaAvg", "fcErrStatssignalLossesDeltaMax", "fcErrStatssignalLossesDeltaMin", "fcErrStatssyncLossesDelta", "fcErrStatssyncLossesDeltaAvg", "fcErrStatssyncLossesDeltaMax", "fcErrStatssyncLossesDeltaMin", "fcErrStatstooLongRxDelta", "fcErrStatstooLongRxDeltaAvg", "fcErrStatstooLongRxDeltaMax", "fcErrStatstooLongRxDeltaMin", "fcErrStatstooShortRxDelta", "fcErrStatstooShortRxDeltaAvg", "fcErrStatstooShortRxDeltaMax", "fcErrStatstooShortRxDeltaMin", "fcErrStatstxDelta", "fcErrStatstxDeltaAvg", "fcErrStatstxDeltaMax", "fcErrStatstxDeltaMin", "fcStatsbytesRxDelta", "fcStatsbytesRxDeltaAvg", "fcStatsbytesRxDeltaMax", "fcStatsbytesRxDeltaMin", "fcStatsbytesTxDelta", "fcStatsbytesTxDeltaAvg", "fcStatsbytesTxDeltaMax", "fcStatsbytesTxDeltaMin", "fcStatspacketsRxDelta", "fcStatspacketsRxDeltaAvg", "fcStatspacketsRxDeltaMax", "fcStatspacketsRxDeltaMin", "fcStatspacketsTxDelta", "fcStatspacketsTxDeltaAvg", "fcStatspacketsTxDeltaMax", "fcStatspacketsTxDeltaMin", "memoryArrayEnvStatsinputCurrent", "memoryArrayEnvStatsinputCurrentAvg", "memoryArrayEnvStatsinputCurrentMax", "memoryArrayEnvStatsinputCurrentMin", "memoryBufferUnitEnvStatstemperature", "memoryBufferUnitEnvStatstemperatureAvg", "memoryBufferUnitEnvStatstemperatureMax", "memoryBufferUnitEnvStatstemperatureMin", "memoryErrorStatsaddressParityErrors", "memoryErrorStatseccMultibitErrors", "memoryErrorStatseccSinglebitErrors", "memoryErrorStatsmismatchErrors", "memoryRuntimeavailable", "memoryRuntimeavailableAvg", "memoryRuntimeavailableMax", "memoryRuntimeavailableMin", "memoryRuntimecached", "memoryRuntimecachedAvg", "memoryRuntimecachedMax", "memoryRuntimecachedMin", "memoryRuntimetotal", "memoryRuntimetotalAvg", "memoryRuntimetotalMax", "memoryRuntimetotalMin", "memoryUnitEnvStatstemperature", "memoryUnitEnvStatstemperatureAvg", "memoryUnitEnvStatstemperatureMax", "memoryUnitEnvStatstemperatureMin", "powerGroupStatspower", "powerGroupStatspowerAvg", "powerGroupStatspowerMax", "powerGroupStatspowerMin", "processorEnvStatsinputCurrent", "processorEnvStatsinputCurrentAvg", "processorEnvStatsinputCurrentMax", "processorEnvStatsinputCurrentMin", "processorEnvStatstemperature", "processorEnvStatstemperatureAvg", "processorEnvStatstemperatureMax", "processorEnvStatstemperatureMin", "processorErrorStatsmirroringInterSockErrors", "processorErrorStatsmirroringIntraSockErrors", "processorErrorStatssmiLinkCorrErrors", "processorErrorStatssmiLinkUncorrErrors", "processorErrorStatssparingErrors", "processorRuntimeload", "processorRuntimeloadAvg", "processorRuntimeloadMax", "processorRuntimeloadMin", "swCardEnvStatsSlotOutlet1", "swCardEnvStatsSlotOutlet1Avg", "swCardEnvStatsSlotOutlet1Max", "swCardEnvStatsSlotOutlet1Min", "swCardEnvStatsSlotOutlet2", "swCardEnvStatsSlotOutlet2Avg", "swCardEnvStatsSlotOutlet2Max", "swCardEnvStatsSlotOutlet2Min", "swCardEnvStatsSlotOutlet3", "swCardEnvStatsSlotOutlet3Avg", "swCardEnvStatsSlotOutlet3Max", "swCardEnvStatsSlotOutlet3Min", "swEnvStatsfanCtrlrInlet1", "swEnvStatsfanCtrlrInlet1Avg", "swEnvStatsfanCtrlrInlet1Max", "swEnvStatsfanCtrlrInlet1Min", "swEnvStatsfanCtrlrInlet2", "swEnvStatsfanCtrlrInlet2Avg", "swEnvStatsfanCtrlrInlet2Max", "swEnvStatsfanCtrlrInlet2Min", "swEnvStatsfanCtrlrInlet3", "swEnvStatsfanCtrlrInlet3Avg", "swEnvStatsfanCtrlrInlet3Max", "swEnvStatsfanCtrlrInlet3Min", "swEnvStatsfanCtrlrInlet4", "swEnvStatsfanCtrlrInlet4Avg", "swEnvStatsfanCtrlrInlet4Max", "swEnvStatsfanCtrlrInlet4Min", "swEnvStatsmainBoardOutlet1", "swEnvStatsmainBoardOutlet1Avg", "swEnvStatsmainBoardOutlet1Max", "swEnvStatsmainBoardOutlet1Min", "swEnvStatsmainBoardOutlet2", "swEnvStatsmainBoardOutlet2Avg", "swEnvStatsmainBoardOutlet2Max", "swEnvStatsmainBoardOutlet2Min", "swEnvStatspsuCtrlrInlet1", "swEnvStatspsuCtrlrInlet1Avg", "swEnvStatspsuCtrlrInlet1Max", "swEnvStatspsuCtrlrInlet1Min", "swEnvStatspsuCtrlrInlet2", "swEnvStatspsuCtrlrInlet2Avg", "swEnvStatspsuCtrlrInlet2Max", "swEnvStatspsuCtrlrInlet2Min", "swSystemStatsload", "swSystemStatsloadAvg", "swSystemStatsloadMax", "swSystemStatsloadMin", "swSystemStatsmemAvailable", "swSystemStatsmemAvailableAvg", "swSystemStatsmemAvailableMax", "swSystemStatsmemAvailableMin", "swSystemStatsmemCached", "swSystemStatsmemCachedAvg", "swSystemStatsmemCachedMax", "swSystemStatsmemCachedMin", "unspecified"], ["0-4294967295"]),
			"PropType":UcsPropertyMeta("PropType", "propType", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, ["float", "uint32", "uint64"], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x80L, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x100L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Meta":UcsMoMeta("StatsThrFloatDefinition", "statsThrFloatDefinition", "[PropId]", _VersionMeta.Version101e, "InputOutput", 0x1ffL, [], [u'statsThr32Value', u'statsThr64Value', u'statsThrFloatValue'], ["Get"], ["admin", "operations"]),
			},

		"VnicProfileAlias": {
			"Alias":UcsPropertyMeta("Alias", "alias", "string", _VersionMeta.Version101e, UcsPropertyMeta.Naming, 0x1L, 1, 510, None, [], ["0-4294967295"]),
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, 0x2L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x4L, 0, 256, None, [], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x8L, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x10L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"SwUuid":UcsPropertyMeta("SwUuid", "swUuid", "string", _VersionMeta.Version111j, UcsPropertyMeta.Naming, 0x20L, None, None, """(([0-9a-fA-F]){8}\-([0-9a-fA-F]){4}\-([0-9a-fA-F]){4}\-([0-9a-fA-F]){4}\-([0-9a-fA-F]){12})|0""", [], ["0-4294967295"]),
			"Meta":UcsMoMeta("VnicProfileAlias", "vnicProfileAlias", "uuid-[SwUuid]alias-[Alias]", _VersionMeta.Version101e, "InputOutput", 0x3fL, [], [], ["Get"], ["read-only"]),
			},

		"NetworkIfStats": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x2L, 0, 256, None, [], ["0-4294967295"]),
			"In":UcsPropertyMeta("In", "in", "ulong", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"Out":UcsPropertyMeta("Out", "out", "ulong", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x4L, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x8L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Type":UcsPropertyMeta("Type", "type", "string", _VersionMeta.Version101e, UcsPropertyMeta.Naming, 0x10L, None, None, None, ["broadcast", "generic", "multicast", "total", "unicast"], ["0-4294967295"]),
			"Units":UcsPropertyMeta("Units", "units", "string", _VersionMeta.Version101e, UcsPropertyMeta.Naming, 0x20L, None, None, None, ["octets", "packets", "raw"], ["0-4294967295"]),
			"Meta":UcsMoMeta("NetworkIfStats", "networkIfStats", "if-stat-[Type]-[Units]", _VersionMeta.Version101e, "InputOutput", 0x3fL, [], [], ["Get"], ["read-only"]),
			},

		"CommHttps": {
			"AdminState":UcsPropertyMeta("AdminState", "adminState", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x1L, None, None, None, ["disabled", "enabled"], ["0-4294967295"]),
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, 0x2L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"CipherSuite":UcsPropertyMeta("CipherSuite", "cipherSuite", "string", _VersionMeta.Version203a, UcsPropertyMeta.ReadWrite, 0x4L, None, None, """[!\+,\-\./:;<=>\?@\[\\a-zA-Z0-9]{0,256}""", [], ["0-4294967295"]),
			"CipherSuiteMode":UcsPropertyMeta("CipherSuiteMode", "cipherSuiteMode", "string", _VersionMeta.Version203a, UcsPropertyMeta.ReadWrite, 0x8L, None, None, None, ["custom", "high-strength", "low-strength", "medium-strength"], ["0-4294967295"]),
			"Descr":UcsPropertyMeta("Descr", "descr", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x10L, None, None, """[ !#$%&\(\)\*\+,\-\./:;\?@\[\]_\{\|\}~a-zA-Z0-9]{0,256}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x20L, 0, 256, None, [], ["0-4294967295"]),
			"IntId":UcsPropertyMeta("IntId", "intId", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, None, None, None, None, ["none"], ["0-4294967295"]),
			"KeyRing":UcsPropertyMeta("KeyRing", "keyRing", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x40L, None, None, """[\-\.:_a-zA-Z0-9]{0,16}""", [], ["0-4294967295"]),
			"Name":UcsPropertyMeta("Name", "name", "string", _VersionMeta.Version101e, UcsPropertyMeta.CreateOnly, 0x80L, None, None, """[\-\.:_a-zA-Z0-9]{0,16}""", [], ["0-4294967295"]),
			"OperPort":UcsPropertyMeta("OperPort", "operPort", "uint", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-65535"]),
			"PolicyLevel":UcsPropertyMeta("PolicyLevel", "policyLevel", "uint", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"PolicyOwner":UcsPropertyMeta("PolicyOwner", "policyOwner", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadWrite, 0x100L, None, None, None, ["local", "pending-policy", "policy"], ["0-4294967295"]),
			"Port":UcsPropertyMeta("Port", "port", "uint", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x200L, None, None, None, [], ["1-65535"]),
			"Proto":UcsPropertyMeta("Proto", "proto", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, ["all", "none", "tcp", "udp"], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x400L, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x800L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Meta":UcsMoMeta("CommHttps", "commHttps", "https-svc", _VersionMeta.Version101e, "InputOutput", 0xfffL, [], [], ["Get", "Set"], ["aaa", "admin"]),
			},

		"FabricEthLanPc": {
			"AdminSpeed":UcsPropertyMeta("AdminSpeed", "adminSpeed", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadWrite, 0x1L, None, None, None, ["10gbps", "1gbps", "20gbps", "40gbps", "indeterminate"], ["0-4294967295"]),
			"AdminState":UcsPropertyMeta("AdminState", "adminState", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x2L, None, None, None, ["disabled", "enabled"], ["0-4294967295"]),
			"Bandwidth":UcsPropertyMeta("Bandwidth", "bandwidth", "uint", _VersionMeta.Version212a, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, 0x4L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Descr":UcsPropertyMeta("Descr", "descr", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadWrite, 0x8L, None, None, """[ !#$%&\(\)\*\+,\-\./:;\?@\[\]_\{\|\}~a-zA-Z0-9]{0,256}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x10L, 0, 256, None, [], ["0-4294967295"]),
			"EpDn":UcsPropertyMeta("EpDn", "epDn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"FlowCtrlPolicy":UcsPropertyMeta("FlowCtrlPolicy", "flowCtrlPolicy", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x20L, None, None, """[\-\.:_a-zA-Z0-9]{0,16}""", [], ["0-4294967295"]),
			"FltAggr":UcsPropertyMeta("FltAggr", "fltAggr", "ulong", _VersionMeta.Version101e, UcsPropertyMeta.Internal, None, None, None, None, [], ["0-4294967295"]),
			"IfRole":UcsPropertyMeta("IfRole", "ifRole", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, ["diag", "fcoe-nas-storage", "fcoe-storage", "fcoe-uplink", "mgmt", "monitor", "nas-storage", "network", "network-fcoe-uplink", "server", "service", "storage", "unknown"], ["0-4294967295"]),
			"IfType":UcsPropertyMeta("IfType", "ifType", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, ["aggregation", "physical", "unknown", "virtual"], ["0-4294967295"]),
			"Locale":UcsPropertyMeta("Locale", "locale", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, """((defaultValue|unknown|server|chassis|internal|external),){0,5}(defaultValue|unknown|server|chassis|internal|external){0,1}""", [], ["0-4294967295"]),
			"Name":UcsPropertyMeta("Name", "name", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x40L, None, None, """[\-\.:_a-zA-Z0-9]{0,16}""", [], ["0-4294967295"]),
			"OperSpeed":UcsPropertyMeta("OperSpeed", "operSpeed", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadWrite, 0x80L, None, None, None, ["10gbps", "1gbps", "20gbps", "40gbps", "indeterminate"], ["0-4294967295"]),
			"OperState":UcsPropertyMeta("OperState", "operState", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, ["admin-down", "error-disabled", "failed", "hardware-failure", "indeterminate", "link-down", "link-up", "no-license", "sfp-not-present", "software-failure", "udld-aggr-down", "up"], ["0-4294967295"]),
			"OverlappingVlans":UcsPropertyMeta("OverlappingVlans", "overlappingVlans", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, 0, 510, None, [], ["0-4294967295"]),
			"PeerDn":UcsPropertyMeta("PeerDn", "peerDn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"PortId":UcsPropertyMeta("PortId", "portId", "uint", _VersionMeta.Version101e, UcsPropertyMeta.Naming, 0x100L, None, None, None, [], ["1-256"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x200L, 0, 256, None, [], ["0-4294967295"]),
			"StateQual":UcsPropertyMeta("StateQual", "stateQual", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, 0, 510, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x400L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"SwitchId":UcsPropertyMeta("SwitchId", "switchId", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, ["A", "B", "NONE"], ["0-4294967295"]),
			"Transport":UcsPropertyMeta("Transport", "transport", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, """((defaultValue|unknown|ether|dce|fc),){0,4}(defaultValue|unknown|ether|dce|fc){0,1}""", [], ["0-4294967295"]),
			"Type":UcsPropertyMeta("Type", "type", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, """((defaultValue|unknown|lan|san|ipc),){0,4}(defaultValue|unknown|lan|san|ipc){0,1}""", [], ["0-4294967295"]),
			"VlanStatus":UcsPropertyMeta("VlanStatus", "vlanStatus", "string", _VersionMeta.Version201m, UcsPropertyMeta.ReadOnly, None, None, None, None, ["missing-primary", "ok"], ["0-4294967295"]),
			"Warnings":UcsPropertyMeta("Warnings", "warnings", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, """((defaultValue|none|fc-zoning-enabled|configuration-error),){0,3}(defaultValue|none|fc-zoning-enabled|configuration-error){0,1}""", [], ["0-4294967295"]),
			"Meta":UcsMoMeta("FabricEthLanPc", "fabricEthLanPc", "pc-[PortId]", _VersionMeta.Version101e, "InputOutput", 0x7ffL, [], [u'etherErrStats', u'etherLossStats', u'etherPauseStats', u'etherRxStats', u'etherTxStats', u'fabricEthLanPcEp', u'fabricEthMonSrcEp', u'faultInst'], ["Add", "Get", "Remove", "Set"], ["admin", "ext-lan-config", "ext-lan-policy"]),
			},

		"LsbootUsbInternalImage": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version221b, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadOnly, 0x2L, 0, 256, None, [], ["0-4294967295"]),
			"Order":UcsPropertyMeta("Order", "order", "ushort", _VersionMeta.Version221b, UcsPropertyMeta.ReadWrite, 0x4L, None, None, None, [], ["1-16"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadOnly, 0x8L, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadWrite, 0x10L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Type":UcsPropertyMeta("Type", "type", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadOnly, None, None, None, None, ["local-any", "local-hdd", "sd-card", "usb-extern", "usb-intern"], ["0-4294967295"]),
			"Meta":UcsMoMeta("LsbootUsbInternalImage", "lsbootUsbInternalImage", "usb-intern", _VersionMeta.Version221b, "InputOutput", 0x1fL, [], [], ["Add", "Get", "Remove", "Set"], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"]),
			},

		"EquipmentPicture": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version141i, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, 0x2L, 0, 256, None, [], ["0-4294967295"]),
			"FileName":UcsPropertyMeta("FileName", "fileName", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, 0x4L, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadWrite, 0x8L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Type":UcsPropertyMeta("Type", "type", "string", _VersionMeta.Version141i, UcsPropertyMeta.Naming, 0x10L, None, None, None, ["back", "bottom", "front", "left", "right", "top", "unknown"], ["0-4294967295"]),
			"Meta":UcsMoMeta("EquipmentPicture", "equipmentPicture", "picture-[Type]", _VersionMeta.Version141i, "InputOutput", 0x1fL, [], [], ["Get"], [""]),
			},

		"FabricVlan": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Cloud":UcsPropertyMeta("Cloud", "cloud", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, """((defaultValue|unknown|fcsanmon|ethlan|ethestclan|fcestc|ethlanmon|fcsan),){0,7}(defaultValue|unknown|fcsanmon|ethlan|ethestclan|fcestc|ethlanmon|fcsan){0,1}""", [], ["0-4294967295"]),
			"CompressionType":UcsPropertyMeta("CompressionType", "compressionType", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadWrite, 0x2L, None, None, None, ["excluded", "included"], ["0-4294967295"]),
			"ConfigIssues":UcsPropertyMeta("ConfigIssues", "configIssues", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, """((defaultValue|not-applicable|conflicting-vlan-access|unsupported-multicast-policy),){0,3}(defaultValue|not-applicable|conflicting-vlan-access|unsupported-multicast-policy){0,1}""", [], ["0-4294967295"]),
			"DefaultNet":UcsPropertyMeta("DefaultNet", "defaultNet", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x4L, None, None, None, ["false", "no", "true", "yes"], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x8L, 0, 256, None, [], ["0-4294967295"]),
			"EpDn":UcsPropertyMeta("EpDn", "epDn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"FltAggr":UcsPropertyMeta("FltAggr", "fltAggr", "ulong", _VersionMeta.Version211a, UcsPropertyMeta.Internal, None, None, None, None, [], ["0-4294967295"]),
			"Global":UcsPropertyMeta("Global", "global", "ulong", _VersionMeta.Version212a, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"Id":UcsPropertyMeta("Id", "id", "uint", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x10L, None, None, None, [], ["1-3967", "4048-4093"]),
			"IfRole":UcsPropertyMeta("IfRole", "ifRole", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, ["diag", "fcoe-nas-storage", "fcoe-storage", "fcoe-uplink", "mgmt", "monitor", "nas-storage", "network", "network-fcoe-uplink", "server", "service", "storage", "unknown"], ["0-4294967295"]),
			"IfType":UcsPropertyMeta("IfType", "ifType", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, ["aggregation", "physical", "unknown", "virtual"], ["0-4294967295"]),
			"Local":UcsPropertyMeta("Local", "local", "ulong", _VersionMeta.Version212a, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"Locale":UcsPropertyMeta("Locale", "locale", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, """((defaultValue|unknown|server|chassis|internal|external),){0,5}(defaultValue|unknown|server|chassis|internal|external){0,1}""", [], ["0-4294967295"]),
			"McastPolicyName":UcsPropertyMeta("McastPolicyName", "mcastPolicyName", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadWrite, 0x20L, None, None, """[\-\.:_a-zA-Z0-9]{0,16}""", [], ["0-4294967295"]),
			"Name":UcsPropertyMeta("Name", "name", "string", _VersionMeta.Version101e, UcsPropertyMeta.Naming, 0x40L, None, None, """[\-\.:_a-zA-Z0-9]{1,32}""", [], ["0-4294967295"]),
			"OperMcastPolicyName":UcsPropertyMeta("OperMcastPolicyName", "operMcastPolicyName", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"OperState":UcsPropertyMeta("OperState", "operState", "string", _VersionMeta.Version201m, UcsPropertyMeta.ReadOnly, None, None, None, None, ["error-misconfigured", "ok"], ["0-4294967295"]),
			"PeerDn":UcsPropertyMeta("PeerDn", "peerDn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"PolicyOwner":UcsPropertyMeta("PolicyOwner", "policyOwner", "string", _VersionMeta.Version212a, UcsPropertyMeta.ReadWrite, 0x80L, None, None, None, ["local", "pending-policy", "policy"], ["0-4294967295"]),
			"PubNwDn":UcsPropertyMeta("PubNwDn", "pubNwDn", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"PubNwId":UcsPropertyMeta("PubNwId", "pubNwId", "uint", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"PubNwName":UcsPropertyMeta("PubNwName", "pubNwName", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadWrite, 0x100L, 0, 510, None, [], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x200L, 0, 256, None, [], ["0-4294967295"]),
			"Sharing":UcsPropertyMeta("Sharing", "sharing", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadWrite, 0x400L, None, None, None, ["isolated", "none", "primary"], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x800L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"SwitchId":UcsPropertyMeta("SwitchId", "switchId", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, ["A", "B", "NONE", "dual"], ["0-4294967295"]),
			"Transport":UcsPropertyMeta("Transport", "transport", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, """((defaultValue|unknown|ether|dce|fc),){0,4}(defaultValue|unknown|ether|dce|fc){0,1}""", [], ["0-4294967295"]),
			"Type":UcsPropertyMeta("Type", "type", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, """((defaultValue|unknown|lan|san|ipc),){0,4}(defaultValue|unknown|lan|san|ipc){0,1}""", [], ["0-4294967295"]),
			"Meta":UcsMoMeta("FabricVlan", "fabricVlan", "net-[Name]", _VersionMeta.Version101e, "InputOutput", 0xfffL, [], [u'fabricEthMonFiltEp', u'fabricEthMonSrcEp', u'fabricEthVlanPc', u'fabricEthVlanPortEp', u'fabricPoolableVlan', u'faultInst'], ["Add", "Get", "Remove", "Set"], ["admin", "ext-lan-config", "ext-lan-policy"]),
			},

		"FabricComputePhEp": {
			"AdminState":UcsPropertyMeta("AdminState", "adminState", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x1L, None, None, None, ["disabled", "enabled", "remove"], ["0-4294967295"]),
			"ChassisId":UcsPropertyMeta("ChassisId", "chassisId", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x2L, None, None, None, ["N/A"], ["1-255"]),
			"CheckpointTrigTs":UcsPropertyMeta("CheckpointTrigTs", "checkpointTrigTs", "string", _VersionMeta.Version201m, UcsPropertyMeta.ReadOnly, None, None, None, None, ["never"], ["0-4294967295"]),
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, 0x4L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"DeepCheckpointTrigTs":UcsPropertyMeta("DeepCheckpointTrigTs", "deepCheckpointTrigTs", "string", _VersionMeta.Version201m, UcsPropertyMeta.ReadOnly, None, None, None, None, ["never"], ["0-4294967295"]),
			"DiscTrigTs":UcsPropertyMeta("DiscTrigTs", "discTrigTs", "string", _VersionMeta.Version201m, UcsPropertyMeta.ReadOnly, None, None, None, None, ["never"], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x8L, 0, 256, None, [], ["0-4294967295"]),
			"EpDn":UcsPropertyMeta("EpDn", "epDn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"EqType":UcsPropertyMeta("EqType", "eqType", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, None, None, None, None, ["blade", "chassis", "fex", "rack-unit", "unknown"], ["0-4294967295"]),
			"FltAggr":UcsPropertyMeta("FltAggr", "fltAggr", "ulong", _VersionMeta.Version201m, UcsPropertyMeta.Internal, None, None, None, None, [], ["0-4294967295"]),
			"IfRole":UcsPropertyMeta("IfRole", "ifRole", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, ["diag", "fcoe-nas-storage", "fcoe-storage", "fcoe-uplink", "mgmt", "monitor", "nas-storage", "network", "network-fcoe-uplink", "server", "service", "storage", "unknown"], ["0-4294967295"]),
			"IfType":UcsPropertyMeta("IfType", "ifType", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, ["aggregation", "physical", "unknown", "virtual"], ["0-4294967295"]),
			"Lc":UcsPropertyMeta("Lc", "lc", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, ["in-service", "migrate", "out-of-service"], ["0-4294967295"]),
			"LicGP":UcsPropertyMeta("LicGP", "licGP", "ulong", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"LicState":UcsPropertyMeta("LicState", "licState", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, None, None, None, None, ["license-expired", "license-graceperiod", "license-insufficient", "license-ok", "not-applicable", "unknown"], ["0-4294967295"]),
			"Locale":UcsPropertyMeta("Locale", "locale", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, """((defaultValue|unknown|server|chassis|internal|external),){0,5}(defaultValue|unknown|server|chassis|internal|external){0,1}""", [], ["0-4294967295"]),
			"Model":UcsPropertyMeta("Model", "model", "string", _VersionMeta.Version101e, UcsPropertyMeta.Naming, 0x10L, 1, 510, None, [], ["0-4294967295"]),
			"Name":UcsPropertyMeta("Name", "name", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x20L, None, None, """[\-\.:_a-zA-Z0-9]{0,16}""", [], ["0-4294967295"]),
			"OperState":UcsPropertyMeta("OperState", "operState", "string", _VersionMeta.Version201m, UcsPropertyMeta.ReadOnly, None, None, None, None, ["down", "error-misconfigured", "unknown", "up"], ["0-4294967295"]),
			"OperStateReason":UcsPropertyMeta("OperStateReason", "operStateReason", "string", _VersionMeta.Version201m, UcsPropertyMeta.ReadOnly, None, 0, 510, None, [], ["0-4294967295"]),
			"PeerChassisId":UcsPropertyMeta("PeerChassisId", "peerChassisId", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, None, None, None, None, ["N/A"], ["0-255"]),
			"PeerDn":UcsPropertyMeta("PeerDn", "peerDn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"PeerPortId":UcsPropertyMeta("PeerPortId", "peerPortId", "uint", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"PeerSlotId":UcsPropertyMeta("PeerSlotId", "peerSlotId", "uint", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"PortId":UcsPropertyMeta("PortId", "portId", "uint", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-48"]),
			"ProfileDn":UcsPropertyMeta("ProfileDn", "profileDn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"Revision":UcsPropertyMeta("Revision", "revision", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, 0, 510, None, [], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x40L, 0, 256, None, [], ["0-4294967295"]),
			"Serial":UcsPropertyMeta("Serial", "serial", "string", _VersionMeta.Version101e, UcsPropertyMeta.Naming, 0x80L, 1, 510, None, [], ["0-4294967295"]),
			"SlotId":UcsPropertyMeta("SlotId", "slotId", "uint", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x100L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"SwitchId":UcsPropertyMeta("SwitchId", "switchId", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, ["A", "B", "NONE"], ["0-4294967295"]),
			"Transport":UcsPropertyMeta("Transport", "transport", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, """((defaultValue|unknown|ether|dce|fc),){0,4}(defaultValue|unknown|ether|dce|fc){0,1}""", [], ["0-4294967295"]),
			"Type":UcsPropertyMeta("Type", "type", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, """((defaultValue|unknown|lan|san|ipc),){0,4}(defaultValue|unknown|lan|san|ipc){0,1}""", [], ["0-4294967295"]),
			"Vendor":UcsPropertyMeta("Vendor", "vendor", "string", _VersionMeta.Version101e, UcsPropertyMeta.Naming, 0x200L, 1, 510, None, [], ["0-4294967295"]),
			"Meta":UcsMoMeta("FabricComputePhEp", "fabricComputePhEp", "compute-ep-ven-[Vendor]-mod-[Model]-ser-[Serial]", _VersionMeta.Version101e, "InputOutput", 0x3ffL, [], [u'fabricLastAckedSlot', u'faultInst'], ["Get", "Set"], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"]),
			},

		"VmVsan": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x2L, 0, 256, None, [], ["0-4294967295"]),
			"EpDn":UcsPropertyMeta("EpDn", "epDn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"FcoeVlan":UcsPropertyMeta("FcoeVlan", "fcoeVlan", "uint", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["1-3967", "4048-4093"]),
			"Id":UcsPropertyMeta("Id", "id", "uint", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x4L, None, None, None, [], ["1-4093"]),
			"IfRole":UcsPropertyMeta("IfRole", "ifRole", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, ["diag", "fcoe-nas-storage", "fcoe-storage", "fcoe-uplink", "mgmt", "monitor", "nas-storage", "network", "network-fcoe-uplink", "server", "service", "storage", "unknown"], ["0-4294967295"]),
			"IfType":UcsPropertyMeta("IfType", "ifType", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, ["aggregation", "physical", "unknown", "virtual"], ["0-4294967295"]),
			"Locale":UcsPropertyMeta("Locale", "locale", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, """((defaultValue|unknown|server|chassis|internal|external),){0,5}(defaultValue|unknown|server|chassis|internal|external){0,1}""", [], ["0-4294967295"]),
			"Name":UcsPropertyMeta("Name", "name", "string", _VersionMeta.Version101e, UcsPropertyMeta.Naming, 0x8L, None, None, """[\-\.:_a-zA-Z0-9]{1,32}""", [], ["0-4294967295"]),
			"OperState":UcsPropertyMeta("OperState", "operState", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, None, None, None, None, ["error-misconfigured", "error-reserved", "ok"], ["0-4294967295"]),
			"PeerDn":UcsPropertyMeta("PeerDn", "peerDn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"PolicyOwner":UcsPropertyMeta("PolicyOwner", "policyOwner", "string", _VersionMeta.Version212a, UcsPropertyMeta.ReadWrite, 0x10L, None, None, None, ["local", "pending-policy", "policy"], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x20L, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x40L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"SwitchId":UcsPropertyMeta("SwitchId", "switchId", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, ["A", "B", "NONE"], ["0-4294967295"]),
			"Transport":UcsPropertyMeta("Transport", "transport", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, """((defaultValue|unknown|ether|dce|fc),){0,4}(defaultValue|unknown|ether|dce|fc){0,1}""", [], ["0-4294967295"]),
			"Type":UcsPropertyMeta("Type", "type", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, """((defaultValue|unknown|lan|san|ipc),){0,4}(defaultValue|unknown|lan|san|ipc){0,1}""", [], ["0-4294967295"]),
			"ZoningState":UcsPropertyMeta("ZoningState", "zoningState", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadWrite, 0x80L, None, None, None, ["disabled", "enabled"], ["0-4294967295"]),
			"Meta":UcsMoMeta("VmVsan", "vmVsan", "net-[Name]", _VersionMeta.Version101e, "InputOutput", 0xffL, [], [], ["Get"], ["read-only"]),
			},

		"ExtvmmFabricNetwork": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version221b, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Descr":UcsPropertyMeta("Descr", "descr", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadWrite, 0x2L, None, None, """[ !#$%&\(\)\*\+,\-\./:;\?@\[\]_\{\|\}~a-zA-Z0-9]{0,256}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadOnly, 0x4L, 0, 256, None, [], ["0-4294967295"]),
			"Guid":UcsPropertyMeta("Guid", "guid", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadWrite, 0x8L, None, None, """(([0-9a-fA-F]){8}\-([0-9a-fA-F]){4}\-([0-9a-fA-F]){4}\-([0-9a-fA-F]){4}\-([0-9a-fA-F]){12})|0""", [], ["0-4294967295"]),
			"IntId":UcsPropertyMeta("IntId", "intId", "string", _VersionMeta.Version221b, UcsPropertyMeta.Internal, None, None, None, None, ["none"], ["0-4294967295"]),
			"Name":UcsPropertyMeta("Name", "name", "string", _VersionMeta.Version221b, UcsPropertyMeta.Naming, 0x10L, None, None, """[\-\.:_a-zA-Z0-9]{1,16}""", [], ["0-4294967295"]),
			"NetworkType":UcsPropertyMeta("NetworkType", "networkType", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadWrite, 0x20L, None, None, None, ["connected", "not-connected", "not-connected-pvlans"], ["0-4294967295"]),
			"PolicyLevel":UcsPropertyMeta("PolicyLevel", "policyLevel", "uint", _VersionMeta.Version221b, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"PolicyOwner":UcsPropertyMeta("PolicyOwner", "policyOwner", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadWrite, 0x40L, None, None, None, ["local", "pending-policy", "policy"], ["0-4294967295"]),
			"RefOperState":UcsPropertyMeta("RefOperState", "refOperState", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadOnly, None, None, None, None, ["invalid-reference", "up"], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadOnly, 0x80L, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadWrite, 0x100L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Meta":UcsMoMeta("ExtvmmFabricNetwork", "extvmmFabricNetwork", "fabric-network-[Name]", _VersionMeta.Version221b, "InputOutput", 0x1ffL, [], [u'extvmmFabricNetworkDefinition'], ["Add", "Get", "Remove", "Set"], ["admin", "ls-network", "ls-network-policy"]),
			},

		"PolicyPolicyEp": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version211a, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, 0x2L, 0, 256, None, [], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, 0x4L, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadWrite, 0x8L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Meta":UcsMoMeta("PolicyPolicyEp", "policyPolicyEp", "policy-ep", _VersionMeta.Version211a, "InputOutput", 0xfL, [], [u'policyLocalMap', u'policyPolicyScopeCont'], [None], ["admin"]),
			},

		"NfsMountInstFsmStage": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version211a, UcsPropertyMeta.Internal, None, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Descr":UcsPropertyMeta("Descr", "descr", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, """[ !#$%&\(\)\*\+,\-\./:;\?@\[\]_\{\|\}~a-zA-Z0-9]{0,256}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"LastUpdateTime":UcsPropertyMeta("LastUpdateTime", "lastUpdateTime", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, """([0-9]){4}-([0-9]){2}-([0-9]){2}T([0-9]){2}:([0-9]){2}:([0-9]){2}((\.([0-9]){3})){0,1}""", [""], ["0-4294967295"]),
			"Name":UcsPropertyMeta("Name", "name", "string", _VersionMeta.Version211a, UcsPropertyMeta.Naming, None, None, None, None, ["MountBegin", "MountFail", "MountMountLocal", "MountMountPeer", "MountRegisterClient", "MountSuccess", "MountVerifyRegistration", "UnmountBegin", "UnmountFail", "UnmountSuccess", "UnmountUnmountLocal", "UnmountUnmountPeer", "nop"], ["0-4294967295"]),
			"Order":UcsPropertyMeta("Order", "order", "ushort", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"Retry":UcsPropertyMeta("Retry", "retry", "byte", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"StageStatus":UcsPropertyMeta("StageStatus", "stageStatus", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, ["fail", "inProgress", "nop", "pending", "skip", "success", "throttled"], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadWrite, None, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Meta":UcsMoMeta("NfsMountInstFsmStage", "nfsMountInstFsmStage", "stage-[Name]", _VersionMeta.Version211a, "OutputOnly", 0x0L, [], [], [None], [""]),
			},

		"EtherPIoFsm": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version211a, UcsPropertyMeta.Internal, None, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"CompletionTime":UcsPropertyMeta("CompletionTime", "completionTime", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, """([0-9]){4}-([0-9]){2}-([0-9]){2}T([0-9]){2}:([0-9]){2}:([0-9]){2}((\.([0-9]){3})){0,1}""", [""], ["0-4294967295"]),
			"CurrentFsm":UcsPropertyMeta("CurrentFsm", "currentFsm", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, ["InCompatSfpPresence", "InCompatSfpReplaced", "nop"], ["0-4294967295"]),
			"Descr":UcsPropertyMeta("Descr", "descr", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, """[ !#$%&\(\)\*\+,\-\./:;\?@\[\]_\{\|\}~a-zA-Z0-9]{0,256}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"FsmStatus":UcsPropertyMeta("FsmStatus", "fsmStatus", "string", _VersionMeta.Version211a, UcsPropertyMeta.Internal, None, None, None, None, ["fail", "inProgress", "nop", "pending", "skip", "success", "throttled"], ["0-4294967295"]),
			"InstanceId":UcsPropertyMeta("InstanceId", "instanceId", "uint", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"Progress":UcsPropertyMeta("Progress", "progress", "byte", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-100"]),
			"RmtErrCode":UcsPropertyMeta("RmtErrCode", "rmtErrCode", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, ["ERR-2fa-auth-retry", "ERR-ACTIVATE-failed", "ERR-ACTIVATE-in-progress", "ERR-ACTIVATE-retry", "ERR-BIOS-TOKENS-OLD-BIOS", "ERR-BIOS-TOKENS-OLD-CIMC", "ERR-BIOS-network-boot-order-not-found", "ERR-BOARDCTRLUPDATE-ignore", "ERR-DIAG-cancelled", "ERR-DIAG-fsm-restarted", "ERR-DIAG-test-failed", "ERR-DNLD-authentication-failure", "ERR-DNLD-hostkey-mismatch", "ERR-DNLD-invalid-image", "ERR-DNLD-no-file", "ERR-DNLD-no-space", "ERR-DNS-delete-error", "ERR-DNS-get-error", "ERR-DNS-set-error", "ERR-Diagnostics-in-progress", "ERR-Diagnostics-memtest-in-progress", "ERR-Diagnostics-network-in-progress", "ERR-FILTER-illegal-format", "ERR-FSM-no-such-state", "ERR-HOST-fru-identity-mismatch", "ERR-HTTP-set-error", "ERR-HTTPS-set-error", "ERR-IBMC-analyze-results", "ERR-IBMC-connect-error", "ERR-IBMC-fru-retrieval-error", "ERR-IBMC-invalid-end-point-config", "ERR-IBMC-results-not-ready", "ERR-MAX-subscriptions-allowed-error", "ERR-MO-CONFIG-child-object-cant-be-configured", "ERR-MO-META-no-such-object-class", "ERR-MO-PROPERTY-no-such-property", "ERR-MO-PROPERTY-value-out-of-range", "ERR-MO-access-denied", "ERR-MO-deletion-rule-violation", "ERR-MO-duplicate-object", "ERR-MO-illegal-containment", "ERR-MO-illegal-creation", "ERR-MO-illegal-iterator-state", "ERR-MO-illegal-object-lifecycle-transition", "ERR-MO-naming-rule-violation", "ERR-MO-object-not-found", "ERR-MO-resource-allocation", "ERR-NTP-delete-error", "ERR-NTP-get-error", "ERR-NTP-set-error", "ERR-POWER-CAP-UNSUPPORTED", "ERR-SERVER-mis-connect", "ERR-SWITCH-invalid-if-config", "ERR-TOKEN-request-denied", "ERR-UNABLE-TO-FETCH-BIOS-SETTINGS", "ERR-UPDATE-failed", "ERR-UPDATE-in-progress", "ERR-UPDATE-retry", "ERR-aaa-config-modify-error", "ERR-acct-realm-set-error", "ERR-admin-passwd-set", "ERR-auth-issue", "ERR-auth-realm-get-error", "ERR-auth-realm-set-error", "ERR-authentication", "ERR-authorization-required", "ERR-cli-session-limit-reached", "ERR-create-keyring", "ERR-create-locale", "ERR-create-role", "ERR-create-user", "ERR-delete-locale", "ERR-delete-role", "ERR-delete-session", "ERR-delete-user", "ERR-efi-Diagnostics--in-progress", "ERR-enable-mgmt-conn", "ERR-ep-set-error", "ERR-get-max-http-user-sessions", "ERR-http-initializing", "ERR-insufficiently-equipped", "ERR-internal-error", "ERR-ldap-delete-error", "ERR-ldap-get-error", "ERR-ldap-group-modify-error", "ERR-ldap-group-set-error", "ERR-ldap-set-error", "ERR-locale-set-error", "ERR-max-userid-sessions-reached", "ERR-missing-method", "ERR-modify-locale", "ERR-modify-role", "ERR-modify-user", "ERR-modify-user-locale", "ERR-modify-user-role", "ERR-provider-group-modify-error", "ERR-provider-group-set-error", "ERR-radius-get-error", "ERR-radius-global-set-error", "ERR-radius-group-set-error", "ERR-radius-set-error", "ERR-request-timeout", "ERR-reset-adapter", "ERR-role-set-error", "ERR-secondary-node", "ERR-service-not-ready", "ERR-session-cache-full", "ERR-session-not-found", "ERR-set-network", "ERR-set-password-strength-check", "ERR-set-port-channel", "ERR-store-pre-login-banner-msg", "ERR-tacacs-enable-error", "ERR-tacacs-global-set-error", "ERR-tacacs-group-set-error", "ERR-tacacs-plus-get-error", "ERR-tacacs-set-error", "ERR-test-error-1", "ERR-test-error-2", "ERR-timezone-set-error", "ERR-user-account-expired", "ERR-user-set-error", "ERR-xml-parse-error", "none"], ["0-4294967295"]),
			"RmtErrDescr":UcsPropertyMeta("RmtErrDescr", "rmtErrDescr", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, 0, 510, None, [], ["0-4294967295"]),
			"RmtRslt":UcsPropertyMeta("RmtRslt", "rmtRslt", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, """((defaultValue|not-applicable|resource-unavailable|service-unavailable|intermittent-error|sw-defect|service-not-implemented-ignore|extend-timeout|capability-not-implemented-failure|illegal-fru|end-point-unavailable|failure|resource-capacity-exceeded|service-protocol-error|fw-defect|service-not-implemented-fail|task-reset|unidentified-fail|capability-not-supported|end-point-failed|fru-state-indeterminate|resource-dependency|fru-identity-indeterminate|internal-error|hw-defect|service-not-supported|fru-not-supported|end-point-protocol-error|capability-unavailable|fru-not-ready|capability-not-implemented-ignore|fru-info-malformed|timeout),){0,32}(defaultValue|not-applicable|resource-unavailable|service-unavailable|intermittent-error|sw-defect|service-not-implemented-ignore|extend-timeout|capability-not-implemented-failure|illegal-fru|end-point-unavailable|failure|resource-capacity-exceeded|service-protocol-error|fw-defect|service-not-implemented-fail|task-reset|unidentified-fail|capability-not-supported|end-point-failed|fru-state-indeterminate|resource-dependency|fru-identity-indeterminate|internal-error|hw-defect|service-not-supported|fru-not-supported|end-point-protocol-error|capability-unavailable|fru-not-ready|capability-not-implemented-ignore|fru-info-malformed|timeout){0,1}""", [], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadWrite, None, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Meta":UcsMoMeta("EtherPIoFsm", "etherPIoFsm", "fsm", _VersionMeta.Version211a, "OutputOnly", 0x0L, [], [u'etherPIoFsmStage'], [None], [""]),
			},

		"CallhomePeriodicSystemInventory": {
			"AdminState":UcsPropertyMeta("AdminState", "adminState", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x1L, None, None, None, ["off", "on"], ["0-4294967295"]),
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, 0x2L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x4L, 0, 256, None, [], ["0-4294967295"]),
			"IntervalDays":UcsPropertyMeta("IntervalDays", "intervalDays", "uint", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x8L, None, None, None, [], ["1-30"]),
			"LastDeadline":UcsPropertyMeta("LastDeadline", "lastDeadline", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, """([0-9]){4}-([0-9]){2}-([0-9]){2}T([0-9]){2}:([0-9]){2}:([0-9]){2}((\.([0-9]){3})){0,1}""", [], ["0-4294967295"]),
			"MaximumRetryCount":UcsPropertyMeta("MaximumRetryCount", "maximumRetryCount", "uint", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x10L, None, None, None, [], ["0-5"]),
			"MinimumSendNowIntervalSeconds":UcsPropertyMeta("MinimumSendNowIntervalSeconds", "minimumSendNowIntervalSeconds", "uint", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x20L, None, None, None, [], ["1-2000000000"]),
			"NextDeadline":UcsPropertyMeta("NextDeadline", "nextDeadline", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, """([0-9]){4}-([0-9]){2}-([0-9]){2}T([0-9]){2}:([0-9]){2}:([0-9]){2}((\.([0-9]){3})){0,1}""", ["never"], ["0-4294967295"]),
			"PollIntervalSeconds":UcsPropertyMeta("PollIntervalSeconds", "pollIntervalSeconds", "uint", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x40L, None, None, None, [], ["10-3600"]),
			"RetryCount":UcsPropertyMeta("RetryCount", "retryCount", "uint", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"RetryDelayMinutes":UcsPropertyMeta("RetryDelayMinutes", "retryDelayMinutes", "uint", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x80L, None, None, None, [], ["0-60"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x100L, 0, 256, None, [], ["0-4294967295"]),
			"SendNow":UcsPropertyMeta("SendNow", "sendNow", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x200L, None, None, None, ["false", "no", "true", "yes"], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x400L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"TimeOfDayHour":UcsPropertyMeta("TimeOfDayHour", "timeOfDayHour", "uint", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x800L, None, None, None, [], ["0-23"]),
			"TimeOfDayMinute":UcsPropertyMeta("TimeOfDayMinute", "timeOfDayMinute", "uint", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x1000L, None, None, None, [], ["0-59"]),
			"TimeOfLastAttempt":UcsPropertyMeta("TimeOfLastAttempt", "timeOfLastAttempt", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, """([0-9]){4}-([0-9]){2}-([0-9]){2}T([0-9]){2}:([0-9]){2}:([0-9]){2}((\.([0-9]){3})){0,1}""", [], ["0-4294967295"]),
			"TimeOfLastSuccess":UcsPropertyMeta("TimeOfLastSuccess", "timeOfLastSuccess", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, """([0-9]){4}-([0-9]){2}-([0-9]){2}T([0-9]){2}:([0-9]){2}:([0-9]){2}((\.([0-9]){3})){0,1}""", ["never"], ["0-4294967295"]),
			"Meta":UcsMoMeta("CallhomePeriodicSystemInventory", "callhomePeriodicSystemInventory", "periodicsysteminventory", _VersionMeta.Version101e, "InputOutput", 0x1fffL, [], [], ["Get", "Set"], ["admin", "operations"]),
			},

		"StatsThresholdPolicy": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version102d, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Descr":UcsPropertyMeta("Descr", "descr", "string", _VersionMeta.Version102d, UcsPropertyMeta.ReadWrite, 0x2L, None, None, """[ !#$%&\(\)\*\+,\-\./:;\?@\[\]_\{\|\}~a-zA-Z0-9]{0,256}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version102d, UcsPropertyMeta.ReadOnly, 0x4L, 0, 256, None, [], ["0-4294967295"]),
			"IntId":UcsPropertyMeta("IntId", "intId", "string", _VersionMeta.Version102d, UcsPropertyMeta.Internal, None, None, None, None, ["none"], ["0-4294967295"]),
			"Name":UcsPropertyMeta("Name", "name", "string", _VersionMeta.Version102d, UcsPropertyMeta.Naming, 0x8L, None, None, """[\-\.:_a-zA-Z0-9]{1,16}""", [], ["0-4294967295"]),
			"PolicyLevel":UcsPropertyMeta("PolicyLevel", "policyLevel", "uint", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"PolicyOwner":UcsPropertyMeta("PolicyOwner", "policyOwner", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadWrite, 0x10L, None, None, None, ["local", "pending-policy", "policy"], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version102d, UcsPropertyMeta.ReadOnly, 0x20L, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version102d, UcsPropertyMeta.ReadWrite, 0x40L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Meta":UcsMoMeta("StatsThresholdPolicy", "statsThresholdPolicy", "thr-policy-[Name]", _VersionMeta.Version102d, "InputOutput", 0x7fL, [], [u'statsThresholdClass'], ["Add", "Get", "Remove", "Set"], ["admin", "operations"]),
			},

		"EquipmentPOSTCodeReporter": {
			"BaseContainer":UcsPropertyMeta("BaseContainer", "baseContainer", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x2L, 0, 256, None, [], ["0-4294967295"]),
			"Model":UcsPropertyMeta("Model", "model", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, 0, 510, None, [], ["0-4294967295"]),
			"Name":UcsPropertyMeta("Name", "name", "string", _VersionMeta.Version141i, UcsPropertyMeta.Naming, 0x4L, None, None, """[ !#$%&\(\)\*\+,\-\.:;=\?@\[\]_\{\|\}~a-zA-Z0-9]{1,64}""", [], ["0-4294967295"]),
			"Revision":UcsPropertyMeta("Revision", "revision", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, 0, 510, None, [], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x8L, 0, 256, None, [], ["0-4294967295"]),
			"Serial":UcsPropertyMeta("Serial", "serial", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, 0, 510, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x10L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Type":UcsPropertyMeta("Type", "type", "string", _VersionMeta.Version101e, UcsPropertyMeta.CreateOnly, 0x20L, 0, 510, None, [], ["0-4294967295"]),
			"Vendor":UcsPropertyMeta("Vendor", "vendor", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, 0, 510, None, [], ["0-4294967295"]),
			"Meta":UcsMoMeta("EquipmentPOSTCodeReporter", "equipmentPOSTCodeReporter", "POST-[Name]", _VersionMeta.Version101e, "InputOutput", 0x3fL, [], [u'bmcSELCounter', u'equipmentPOSTCode'], ["Get"], ["read-only"]),
			},

		"SwNetflowExporter": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version221b, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"DestinationIpAddress":UcsPropertyMeta("DestinationIpAddress", "destinationIpAddress", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadOnly, None, 0, 256, """((([0-9]){1,3}\.){3}[0-9]{1,3})""", [], ["0-4294967295"]),
			"DestinationPort":UcsPropertyMeta("DestinationPort", "destinationPort", "ushort", _VersionMeta.Version221b, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadOnly, 0x2L, 0, 256, None, [], ["0-4294967295"]),
			"Dscp":UcsPropertyMeta("Dscp", "dscp", "ushort", _VersionMeta.Version221b, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"ExportInternal":UcsPropertyMeta("ExportInternal", "exportInternal", "uint", _VersionMeta.Version221b, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"ExporterStatsTimeout":UcsPropertyMeta("ExporterStatsTimeout", "exporterStatsTimeout", "uint", _VersionMeta.Version221b, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"InterfaceTableTimeout":UcsPropertyMeta("InterfaceTableTimeout", "interfaceTableTimeout", "uint", _VersionMeta.Version221b, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"IsValidConfig":UcsPropertyMeta("IsValidConfig", "isValidConfig", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadOnly, None, None, None, None, ["incomplete", "ok"], ["0-4294967295"]),
			"LifeCycle":UcsPropertyMeta("LifeCycle", "lifeCycle", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadOnly, None, None, None, None, ["deleted", "new", "normal"], ["0-4294967295"]),
			"Name":UcsPropertyMeta("Name", "name", "string", _VersionMeta.Version221b, UcsPropertyMeta.Naming, 0x4L, None, None, """[\-\.:_a-zA-Z0-9]{1,16}""", [], ["0-4294967295"]),
			"PeerDn":UcsPropertyMeta("PeerDn", "peerDn", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"Protocol":UcsPropertyMeta("Protocol", "protocol", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadOnly, None, None, None, None, ["netflow"], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadOnly, 0x8L, 0, 256, None, [], ["0-4294967295"]),
			"SourceVlan":UcsPropertyMeta("SourceVlan", "sourceVlan", "uint", _VersionMeta.Version221b, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["1-4093"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadWrite, 0x10L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"SwitchId":UcsPropertyMeta("SwitchId", "switchId", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadOnly, None, None, None, None, ["A", "B", "NONE"], ["0-4294967295"]),
			"TemplateDataTimeout":UcsPropertyMeta("TemplateDataTimeout", "templateDataTimeout", "uint", _VersionMeta.Version221b, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"Transport":UcsPropertyMeta("Transport", "transport", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadOnly, None, None, None, """((defaultValue|unknown|ether|dce|fc),){0,4}(defaultValue|unknown|ether|dce|fc){0,1}""", [], ["0-4294967295"]),
			"TransportProtocol":UcsPropertyMeta("TransportProtocol", "transportProtocol", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadOnly, None, None, None, None, ["sctp", "udp"], ["0-4294967295"]),
			"Type":UcsPropertyMeta("Type", "type", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadOnly, None, None, None, """((defaultValue|unknown|lan|san|ipc),){0,4}(defaultValue|unknown|lan|san|ipc){0,1}""", [], ["0-4294967295"]),
			"Version":UcsPropertyMeta("Version", "version", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadOnly, None, None, None, None, ["ipfix", "v9"], ["0-4294967295"]),
			"Meta":UcsMoMeta("SwNetflowExporter", "swNetflowExporter", "flowexporter-netflow-[Name]", _VersionMeta.Version221b, "InputOutput", 0x1fL, [], [u'swVlan'], [None], ["read-only"]),
			},

		"SwFcSanBorderFsm": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version211a, UcsPropertyMeta.Internal, None, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"CompletionTime":UcsPropertyMeta("CompletionTime", "completionTime", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, """([0-9]){4}-([0-9]){2}-([0-9]){2}T([0-9]){2}:([0-9]){2}:([0-9]){2}((\.([0-9]){3})){0,1}""", [""], ["0-4294967295"]),
			"CurrentFsm":UcsPropertyMeta("CurrentFsm", "currentFsm", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, ["ActivateZoneSet", "Deploy", "nop"], ["0-4294967295"]),
			"Descr":UcsPropertyMeta("Descr", "descr", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, """[ !#$%&\(\)\*\+,\-\./:;\?@\[\]_\{\|\}~a-zA-Z0-9]{0,256}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"FsmStatus":UcsPropertyMeta("FsmStatus", "fsmStatus", "string", _VersionMeta.Version211a, UcsPropertyMeta.Internal, None, None, None, None, ["fail", "inProgress", "nop", "pending", "skip", "success", "throttled"], ["0-4294967295"]),
			"InstanceId":UcsPropertyMeta("InstanceId", "instanceId", "uint", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"Progress":UcsPropertyMeta("Progress", "progress", "byte", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-100"]),
			"RmtErrCode":UcsPropertyMeta("RmtErrCode", "rmtErrCode", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, ["ERR-2fa-auth-retry", "ERR-ACTIVATE-failed", "ERR-ACTIVATE-in-progress", "ERR-ACTIVATE-retry", "ERR-BIOS-TOKENS-OLD-BIOS", "ERR-BIOS-TOKENS-OLD-CIMC", "ERR-BIOS-network-boot-order-not-found", "ERR-BOARDCTRLUPDATE-ignore", "ERR-DIAG-cancelled", "ERR-DIAG-fsm-restarted", "ERR-DIAG-test-failed", "ERR-DNLD-authentication-failure", "ERR-DNLD-hostkey-mismatch", "ERR-DNLD-invalid-image", "ERR-DNLD-no-file", "ERR-DNLD-no-space", "ERR-DNS-delete-error", "ERR-DNS-get-error", "ERR-DNS-set-error", "ERR-Diagnostics-in-progress", "ERR-Diagnostics-memtest-in-progress", "ERR-Diagnostics-network-in-progress", "ERR-FILTER-illegal-format", "ERR-FSM-no-such-state", "ERR-HOST-fru-identity-mismatch", "ERR-HTTP-set-error", "ERR-HTTPS-set-error", "ERR-IBMC-analyze-results", "ERR-IBMC-connect-error", "ERR-IBMC-fru-retrieval-error", "ERR-IBMC-invalid-end-point-config", "ERR-IBMC-results-not-ready", "ERR-MAX-subscriptions-allowed-error", "ERR-MO-CONFIG-child-object-cant-be-configured", "ERR-MO-META-no-such-object-class", "ERR-MO-PROPERTY-no-such-property", "ERR-MO-PROPERTY-value-out-of-range", "ERR-MO-access-denied", "ERR-MO-deletion-rule-violation", "ERR-MO-duplicate-object", "ERR-MO-illegal-containment", "ERR-MO-illegal-creation", "ERR-MO-illegal-iterator-state", "ERR-MO-illegal-object-lifecycle-transition", "ERR-MO-naming-rule-violation", "ERR-MO-object-not-found", "ERR-MO-resource-allocation", "ERR-NTP-delete-error", "ERR-NTP-get-error", "ERR-NTP-set-error", "ERR-POWER-CAP-UNSUPPORTED", "ERR-SERVER-mis-connect", "ERR-SWITCH-invalid-if-config", "ERR-TOKEN-request-denied", "ERR-UNABLE-TO-FETCH-BIOS-SETTINGS", "ERR-UPDATE-failed", "ERR-UPDATE-in-progress", "ERR-UPDATE-retry", "ERR-aaa-config-modify-error", "ERR-acct-realm-set-error", "ERR-admin-passwd-set", "ERR-auth-issue", "ERR-auth-realm-get-error", "ERR-auth-realm-set-error", "ERR-authentication", "ERR-authorization-required", "ERR-cli-session-limit-reached", "ERR-create-keyring", "ERR-create-locale", "ERR-create-role", "ERR-create-user", "ERR-delete-locale", "ERR-delete-role", "ERR-delete-session", "ERR-delete-user", "ERR-efi-Diagnostics--in-progress", "ERR-enable-mgmt-conn", "ERR-ep-set-error", "ERR-get-max-http-user-sessions", "ERR-http-initializing", "ERR-insufficiently-equipped", "ERR-internal-error", "ERR-ldap-delete-error", "ERR-ldap-get-error", "ERR-ldap-group-modify-error", "ERR-ldap-group-set-error", "ERR-ldap-set-error", "ERR-locale-set-error", "ERR-max-userid-sessions-reached", "ERR-missing-method", "ERR-modify-locale", "ERR-modify-role", "ERR-modify-user", "ERR-modify-user-locale", "ERR-modify-user-role", "ERR-provider-group-modify-error", "ERR-provider-group-set-error", "ERR-radius-get-error", "ERR-radius-global-set-error", "ERR-radius-group-set-error", "ERR-radius-set-error", "ERR-request-timeout", "ERR-reset-adapter", "ERR-role-set-error", "ERR-secondary-node", "ERR-service-not-ready", "ERR-session-cache-full", "ERR-session-not-found", "ERR-set-network", "ERR-set-password-strength-check", "ERR-set-port-channel", "ERR-store-pre-login-banner-msg", "ERR-tacacs-enable-error", "ERR-tacacs-global-set-error", "ERR-tacacs-group-set-error", "ERR-tacacs-plus-get-error", "ERR-tacacs-set-error", "ERR-test-error-1", "ERR-test-error-2", "ERR-timezone-set-error", "ERR-user-account-expired", "ERR-user-set-error", "ERR-xml-parse-error", "none"], ["0-4294967295"]),
			"RmtErrDescr":UcsPropertyMeta("RmtErrDescr", "rmtErrDescr", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, 0, 510, None, [], ["0-4294967295"]),
			"RmtRslt":UcsPropertyMeta("RmtRslt", "rmtRslt", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, """((defaultValue|not-applicable|resource-unavailable|service-unavailable|intermittent-error|sw-defect|service-not-implemented-ignore|extend-timeout|capability-not-implemented-failure|illegal-fru|end-point-unavailable|failure|resource-capacity-exceeded|service-protocol-error|fw-defect|service-not-implemented-fail|task-reset|unidentified-fail|capability-not-supported|end-point-failed|fru-state-indeterminate|resource-dependency|fru-identity-indeterminate|internal-error|hw-defect|service-not-supported|fru-not-supported|end-point-protocol-error|capability-unavailable|fru-not-ready|capability-not-implemented-ignore|fru-info-malformed|timeout),){0,32}(defaultValue|not-applicable|resource-unavailable|service-unavailable|intermittent-error|sw-defect|service-not-implemented-ignore|extend-timeout|capability-not-implemented-failure|illegal-fru|end-point-unavailable|failure|resource-capacity-exceeded|service-protocol-error|fw-defect|service-not-implemented-fail|task-reset|unidentified-fail|capability-not-supported|end-point-failed|fru-state-indeterminate|resource-dependency|fru-identity-indeterminate|internal-error|hw-defect|service-not-supported|fru-not-supported|end-point-protocol-error|capability-unavailable|fru-not-ready|capability-not-implemented-ignore|fru-info-malformed|timeout){0,1}""", [], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadWrite, None, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Meta":UcsMoMeta("SwFcSanBorderFsm", "swFcSanBorderFsm", "fsm", _VersionMeta.Version211a, "OutputOnly", 0x0L, [], [u'swFcSanBorderFsmStage'], [None], [""]),
			},

		"IdentIdentRequestFsmTask": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version211a, UcsPropertyMeta.Internal, None, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Completion":UcsPropertyMeta("Completion", "completion", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, ["cancelled", "completed", "processing", "scheduled"], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"Flags":UcsPropertyMeta("Flags", "flags", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, """(defaultValue){0,1}""", [], ["0-4294967295"]),
			"Item":UcsPropertyMeta("Item", "item", "string", _VersionMeta.Version211a, UcsPropertyMeta.Naming, None, None, None, None, ["nop", "updateIdent"], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"SeqId":UcsPropertyMeta("SeqId", "seqId", "uint", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadWrite, None, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Meta":UcsMoMeta("IdentIdentRequestFsmTask", "identIdentRequestFsmTask", "task-[Item]", _VersionMeta.Version211a, "OutputOnly", 0x0L, [], [], [None], [""]),
			},

		"PortPIoFsm": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version211a, UcsPropertyMeta.Internal, None, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"CompletionTime":UcsPropertyMeta("CompletionTime", "completionTime", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, """([0-9]){4}-([0-9]){2}-([0-9]){2}T([0-9]){2}:([0-9]){2}:([0-9]){2}((\.([0-9]){3})){0,1}""", [""], ["0-4294967295"]),
			"CurrentFsm":UcsPropertyMeta("CurrentFsm", "currentFsm", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, ["InCompatSfpPresence", "InCompatSfpReplaced", "nop"], ["0-4294967295"]),
			"Descr":UcsPropertyMeta("Descr", "descr", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, """[ !#$%&\(\)\*\+,\-\./:;\?@\[\]_\{\|\}~a-zA-Z0-9]{0,256}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"FsmStatus":UcsPropertyMeta("FsmStatus", "fsmStatus", "string", _VersionMeta.Version211a, UcsPropertyMeta.Internal, None, None, None, None, ["fail", "inProgress", "nop", "pending", "skip", "success", "throttled"], ["0-4294967295"]),
			"InstanceId":UcsPropertyMeta("InstanceId", "instanceId", "uint", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"Progress":UcsPropertyMeta("Progress", "progress", "byte", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-100"]),
			"RmtErrCode":UcsPropertyMeta("RmtErrCode", "rmtErrCode", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, ["ERR-2fa-auth-retry", "ERR-ACTIVATE-failed", "ERR-ACTIVATE-in-progress", "ERR-ACTIVATE-retry", "ERR-BIOS-TOKENS-OLD-BIOS", "ERR-BIOS-TOKENS-OLD-CIMC", "ERR-BIOS-network-boot-order-not-found", "ERR-BOARDCTRLUPDATE-ignore", "ERR-DIAG-cancelled", "ERR-DIAG-fsm-restarted", "ERR-DIAG-test-failed", "ERR-DNLD-authentication-failure", "ERR-DNLD-hostkey-mismatch", "ERR-DNLD-invalid-image", "ERR-DNLD-no-file", "ERR-DNLD-no-space", "ERR-DNS-delete-error", "ERR-DNS-get-error", "ERR-DNS-set-error", "ERR-Diagnostics-in-progress", "ERR-Diagnostics-memtest-in-progress", "ERR-Diagnostics-network-in-progress", "ERR-FILTER-illegal-format", "ERR-FSM-no-such-state", "ERR-HOST-fru-identity-mismatch", "ERR-HTTP-set-error", "ERR-HTTPS-set-error", "ERR-IBMC-analyze-results", "ERR-IBMC-connect-error", "ERR-IBMC-fru-retrieval-error", "ERR-IBMC-invalid-end-point-config", "ERR-IBMC-results-not-ready", "ERR-MAX-subscriptions-allowed-error", "ERR-MO-CONFIG-child-object-cant-be-configured", "ERR-MO-META-no-such-object-class", "ERR-MO-PROPERTY-no-such-property", "ERR-MO-PROPERTY-value-out-of-range", "ERR-MO-access-denied", "ERR-MO-deletion-rule-violation", "ERR-MO-duplicate-object", "ERR-MO-illegal-containment", "ERR-MO-illegal-creation", "ERR-MO-illegal-iterator-state", "ERR-MO-illegal-object-lifecycle-transition", "ERR-MO-naming-rule-violation", "ERR-MO-object-not-found", "ERR-MO-resource-allocation", "ERR-NTP-delete-error", "ERR-NTP-get-error", "ERR-NTP-set-error", "ERR-POWER-CAP-UNSUPPORTED", "ERR-SERVER-mis-connect", "ERR-SWITCH-invalid-if-config", "ERR-TOKEN-request-denied", "ERR-UNABLE-TO-FETCH-BIOS-SETTINGS", "ERR-UPDATE-failed", "ERR-UPDATE-in-progress", "ERR-UPDATE-retry", "ERR-aaa-config-modify-error", "ERR-acct-realm-set-error", "ERR-admin-passwd-set", "ERR-auth-issue", "ERR-auth-realm-get-error", "ERR-auth-realm-set-error", "ERR-authentication", "ERR-authorization-required", "ERR-cli-session-limit-reached", "ERR-create-keyring", "ERR-create-locale", "ERR-create-role", "ERR-create-user", "ERR-delete-locale", "ERR-delete-role", "ERR-delete-session", "ERR-delete-user", "ERR-efi-Diagnostics--in-progress", "ERR-enable-mgmt-conn", "ERR-ep-set-error", "ERR-get-max-http-user-sessions", "ERR-http-initializing", "ERR-insufficiently-equipped", "ERR-internal-error", "ERR-ldap-delete-error", "ERR-ldap-get-error", "ERR-ldap-group-modify-error", "ERR-ldap-group-set-error", "ERR-ldap-set-error", "ERR-locale-set-error", "ERR-max-userid-sessions-reached", "ERR-missing-method", "ERR-modify-locale", "ERR-modify-role", "ERR-modify-user", "ERR-modify-user-locale", "ERR-modify-user-role", "ERR-provider-group-modify-error", "ERR-provider-group-set-error", "ERR-radius-get-error", "ERR-radius-global-set-error", "ERR-radius-group-set-error", "ERR-radius-set-error", "ERR-request-timeout", "ERR-reset-adapter", "ERR-role-set-error", "ERR-secondary-node", "ERR-service-not-ready", "ERR-session-cache-full", "ERR-session-not-found", "ERR-set-network", "ERR-set-password-strength-check", "ERR-set-port-channel", "ERR-store-pre-login-banner-msg", "ERR-tacacs-enable-error", "ERR-tacacs-global-set-error", "ERR-tacacs-group-set-error", "ERR-tacacs-plus-get-error", "ERR-tacacs-set-error", "ERR-test-error-1", "ERR-test-error-2", "ERR-timezone-set-error", "ERR-user-account-expired", "ERR-user-set-error", "ERR-xml-parse-error", "none"], ["0-4294967295"]),
			"RmtErrDescr":UcsPropertyMeta("RmtErrDescr", "rmtErrDescr", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, 0, 510, None, [], ["0-4294967295"]),
			"RmtRslt":UcsPropertyMeta("RmtRslt", "rmtRslt", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, """((defaultValue|not-applicable|resource-unavailable|service-unavailable|intermittent-error|sw-defect|service-not-implemented-ignore|extend-timeout|capability-not-implemented-failure|illegal-fru|end-point-unavailable|failure|resource-capacity-exceeded|service-protocol-error|fw-defect|service-not-implemented-fail|task-reset|unidentified-fail|capability-not-supported|end-point-failed|fru-state-indeterminate|resource-dependency|fru-identity-indeterminate|internal-error|hw-defect|service-not-supported|fru-not-supported|end-point-protocol-error|capability-unavailable|fru-not-ready|capability-not-implemented-ignore|fru-info-malformed|timeout),){0,32}(defaultValue|not-applicable|resource-unavailable|service-unavailable|intermittent-error|sw-defect|service-not-implemented-ignore|extend-timeout|capability-not-implemented-failure|illegal-fru|end-point-unavailable|failure|resource-capacity-exceeded|service-protocol-error|fw-defect|service-not-implemented-fail|task-reset|unidentified-fail|capability-not-supported|end-point-failed|fru-state-indeterminate|resource-dependency|fru-identity-indeterminate|internal-error|hw-defect|service-not-supported|fru-not-supported|end-point-protocol-error|capability-unavailable|fru-not-ready|capability-not-implemented-ignore|fru-info-malformed|timeout){0,1}""", [], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadWrite, None, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Meta":UcsMoMeta("PortPIoFsm", "portPIoFsm", "fsm", _VersionMeta.Version211a, "OutputOnly", 0x0L, [], [u'portPIoFsmStage'], [None], [""]),
			},

		"SwNetflowRecordDef": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version221b, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadOnly, 0x2L, 0, 256, None, [], ["0-4294967295"]),
			"Ipv4keys":UcsPropertyMeta("Ipv4keys", "ipv4keys", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadOnly, None, None, None, """((defaultValue|none|src-port|ipv4-src-address|ipv4-dest-address|dest-port|ip-protocol|ip-tos),){0,7}(defaultValue|none|src-port|ipv4-src-address|ipv4-dest-address|dest-port|ip-protocol|ip-tos){0,1}""", [], ["0-4294967295"]),
			"Ipv6keys":UcsPropertyMeta("Ipv6keys", "ipv6keys", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadOnly, None, None, None, """((defaultValue|none|src-port|ipv6-src-address|ipv6-dest-address|dest-port|ip-protocol),){0,6}(defaultValue|none|src-port|ipv6-src-address|ipv6-dest-address|dest-port|ip-protocol){0,1}""", [], ["0-4294967295"]),
			"KeyType":UcsPropertyMeta("KeyType", "keyType", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadOnly, None, None, None, None, ["ipv4keys", "ipv6keys", "l2keys"], ["0-4294967295"]),
			"L2keys":UcsPropertyMeta("L2keys", "l2keys", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadOnly, None, None, None, """((defaultValue|none|ethertype|dest-mac-address|src-mac-address),){0,4}(defaultValue|none|ethertype|dest-mac-address|src-mac-address){0,1}""", [], ["0-4294967295"]),
			"LifeCycle":UcsPropertyMeta("LifeCycle", "lifeCycle", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadOnly, None, None, None, None, ["deleted", "new", "normal"], ["0-4294967295"]),
			"Name":UcsPropertyMeta("Name", "name", "string", _VersionMeta.Version221b, UcsPropertyMeta.Naming, 0x4L, None, None, """[\-\.:_a-zA-Z0-9]{1,16}""", [], ["0-4294967295"]),
			"Nonkeys":UcsPropertyMeta("Nonkeys", "nonkeys", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadOnly, None, None, None, """((defaultValue|none|counter-packets-long|counter-bytes-long|sys-uptime-first|sys-uptime-last),){0,5}(defaultValue|none|counter-packets-long|counter-bytes-long|sys-uptime-first|sys-uptime-last){0,1}""", [], ["0-4294967295"]),
			"PeerDn":UcsPropertyMeta("PeerDn", "peerDn", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"Protocol":UcsPropertyMeta("Protocol", "protocol", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadOnly, None, None, None, None, ["netflow"], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadOnly, 0x8L, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadWrite, 0x10L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"SwitchId":UcsPropertyMeta("SwitchId", "switchId", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadOnly, None, None, None, None, ["A", "B", "NONE"], ["0-4294967295"]),
			"Transport":UcsPropertyMeta("Transport", "transport", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadOnly, None, None, None, """((defaultValue|unknown|ether|dce|fc),){0,4}(defaultValue|unknown|ether|dce|fc){0,1}""", [], ["0-4294967295"]),
			"Type":UcsPropertyMeta("Type", "type", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadOnly, None, None, None, """((defaultValue|unknown|lan|san|ipc),){0,4}(defaultValue|unknown|lan|san|ipc){0,1}""", [], ["0-4294967295"]),
			"Meta":UcsMoMeta("SwNetflowRecordDef", "swNetflowRecordDef", "flowrecord-netflow-[Name]", _VersionMeta.Version221b, "InputOutput", 0x1fL, [], [], [None], ["read-only"]),
			},

		"EquipmentGraphicsCardCapRef": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version213a, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version213a, UcsPropertyMeta.ReadOnly, 0x2L, 0, 256, None, [], ["0-4294967295"]),
			"Model":UcsPropertyMeta("Model", "model", "string", _VersionMeta.Version213a, UcsPropertyMeta.Naming, 0x4L, 1, 510, None, [], ["0-4294967295"]),
			"Revision":UcsPropertyMeta("Revision", "revision", "string", _VersionMeta.Version213a, UcsPropertyMeta.Naming, 0x8L, 1, 510, None, [], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version213a, UcsPropertyMeta.ReadOnly, 0x10L, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version213a, UcsPropertyMeta.ReadWrite, 0x20L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Vendor":UcsPropertyMeta("Vendor", "vendor", "string", _VersionMeta.Version213a, UcsPropertyMeta.Naming, 0x40L, 1, 510, None, [], ["0-4294967295"]),
			"Meta":UcsMoMeta("EquipmentGraphicsCardCapRef", "equipmentGraphicsCardCapRef", "manufacturer-[Vendor]-model-[Model]-revision-[Revision]", _VersionMeta.Version213a, "InputOutput", 0x7fL, [], [], ["Get"], [""]),
			},

		"SysdebugAutoCoreFileExportTargetFsmTask": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version111j, UcsPropertyMeta.Internal, None, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Completion":UcsPropertyMeta("Completion", "completion", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, ["cancelled", "completed", "processing", "scheduled"], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"Flags":UcsPropertyMeta("Flags", "flags", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, """(defaultValue){0,1}""", [], ["0-4294967295"]),
			"Item":UcsPropertyMeta("Item", "item", "string", _VersionMeta.Version111j, UcsPropertyMeta.Naming, None, None, None, None, ["Configure", "nop"], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"SeqId":UcsPropertyMeta("SeqId", "seqId", "uint", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadWrite, None, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Meta":UcsMoMeta("SysdebugAutoCoreFileExportTargetFsmTask", "sysdebugAutoCoreFileExportTargetFsmTask", "task-[Item]", _VersionMeta.Version111j, "OutputOnly", 0x0L, [], [], [None], [""]),
			},

		"CallhomePolicy": {
			"AdminState":UcsPropertyMeta("AdminState", "adminState", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x1L, None, None, None, ["disabled", "enabled"], ["0-4294967295"]),
			"Cause":UcsPropertyMeta("Cause", "cause", "string", _VersionMeta.Version101e, UcsPropertyMeta.Naming, 0x2L, None, None, None, ["arp-targets-config-error", "association-failed", "configuration-failure", "connectivity-problem", "election-failure", "equipment-degraded", "equipment-disabled", "equipment-inaccessible", "equipment-inoperable", "equipment-offline", "equipment-problem", "fru-problem", "identity-unestablishable", "inventory-failed", "license-graceperiod-expired", "limit-reached", "link-down", "management-services-failure", "management-services-unresponsive", "mgmtif-down", "ndisc-targets-config-error", "port-failed", "power-problem", "thermal-problem", "unspecified", "version-incompatible", "vif-ids-mismatch", "voltage-problem"], ["0-4294967295"]),
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, 0x4L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Descr":UcsPropertyMeta("Descr", "descr", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x8L, None, None, """[ !#$%&\(\)\*\+,\-\./:;\?@\[\]_\{\|\}~a-zA-Z0-9]{0,256}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x10L, 0, 256, None, [], ["0-4294967295"]),
			"Name":UcsPropertyMeta("Name", "name", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x20L, None, None, """[\-\.:_a-zA-Z0-9]{0,16}""", [], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x40L, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x80L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Meta":UcsMoMeta("CallhomePolicy", "callhomePolicy", "policy-[Cause]", _VersionMeta.Version101e, "InputOutput", 0xffL, [], [], ["Add", "Get", "Remove", "Set"], ["admin", "fault"]),
			},

		"EquipmentGemPortCap": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version141i, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Descr":UcsPropertyMeta("Descr", "descr", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadWrite, 0x2L, None, None, """[ !#$%&\(\)\*\+,\-\./:;\?@\[\]_\{\|\}~a-zA-Z0-9]{0,256}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, 0x4L, 0, 256, None, [], ["0-4294967295"]),
			"IntId":UcsPropertyMeta("IntId", "intId", "string", _VersionMeta.Version141i, UcsPropertyMeta.Internal, None, None, None, None, ["none"], ["0-4294967295"]),
			"MaxFcSpeed":UcsPropertyMeta("MaxFcSpeed", "maxFcSpeed", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, None, None, None, None, ["1gbps", "2gbps", "4gbps", "8gbps", "auto", "indeterminate"], ["0-4294967295"]),
			"Name":UcsPropertyMeta("Name", "name", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadWrite, 0x8L, None, None, """[\-\.:_a-zA-Z0-9]{0,16}""", [], ["0-4294967295"]),
			"PolicyLevel":UcsPropertyMeta("PolicyLevel", "policyLevel", "uint", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"PolicyOwner":UcsPropertyMeta("PolicyOwner", "policyOwner", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadWrite, 0x10L, None, None, None, ["local", "pending-policy", "policy"], ["0-4294967295"]),
			"PortNumber":UcsPropertyMeta("PortNumber", "portNumber", "uint", _VersionMeta.Version141i, UcsPropertyMeta.Naming, 0x20L, None, None, None, [], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, 0x40L, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadWrite, 0x80L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Meta":UcsMoMeta("EquipmentGemPortCap", "equipmentGemPortCap", "gem-port-cap-[PortNumber]", _VersionMeta.Version141i, "InputOutput", 0xffL, [], [], ["Get"], [""]),
			},

		"ComputeChassisQual": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x2L, 0, 256, None, [], ["0-4294967295"]),
			"MaxId":UcsPropertyMeta("MaxId", "maxId", "uint", _VersionMeta.Version101e, UcsPropertyMeta.Naming, 0x4L, None, None, None, [], ["1-255"]),
			"MinId":UcsPropertyMeta("MinId", "minId", "uint", _VersionMeta.Version101e, UcsPropertyMeta.Naming, 0x8L, None, None, None, [], ["1-255"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x10L, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x20L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Meta":UcsMoMeta("ComputeChassisQual", "computeChassisQual", "chassis-from-[MinId]-to-[MaxId]", _VersionMeta.Version101e, "InputOutput", 0x3fL, [], [u'computeSlotQual'], ["Add", "Get", "Remove"], ["admin", "pn-policy"]),
			},

		"VnicDynamicCon": {
			"AdaptorProfileName":UcsPropertyMeta("AdaptorProfileName", "adaptorProfileName", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x1L, None, None, """[\-\.:_a-zA-Z0-9]{0,16}""", [], ["0-4294967295"]),
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, 0x2L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Descr":UcsPropertyMeta("Descr", "descr", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x4L, None, None, """[ !#$%&\(\)\*\+,\-\./:;\?@\[\]_\{\|\}~a-zA-Z0-9]{0,256}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x8L, 0, 256, None, [], ["0-4294967295"]),
			"DynamicEth":UcsPropertyMeta("DynamicEth", "dynamicEth", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x10L, None, None, None, ["off"], ["0-256"]),
			"IntId":UcsPropertyMeta("IntId", "intId", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, None, None, None, None, ["none"], ["0-4294967295"]),
			"Mtu":UcsPropertyMeta("Mtu", "mtu", "uint", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["1500-9000"]),
			"Name":UcsPropertyMeta("Name", "name", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x20L, None, None, """[\-\.:_a-zA-Z0-9]{0,16}""", [], ["0-4294967295"]),
			"NamingPrefix":UcsPropertyMeta("NamingPrefix", "namingPrefix", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, 0, 16, None, [], ["0-4294967295"]),
			"PolicyLevel":UcsPropertyMeta("PolicyLevel", "policyLevel", "uint", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"PolicyOwner":UcsPropertyMeta("PolicyOwner", "policyOwner", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadWrite, 0x40L, None, None, None, ["local", "pending-policy", "policy"], ["0-4294967295"]),
			"Protection":UcsPropertyMeta("Protection", "protection", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x80L, None, None, None, ["none", "protected", "protected-pref-a", "protected-pref-b"], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x100L, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x200L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Meta":UcsMoMeta("VnicDynamicCon", "vnicDynamicCon", "dynamic-con", _VersionMeta.Version101e, "InputOutput", 0x3ffL, [], [], ["Get", "Set"], ["admin", "ls-compute", "ls-config", "ls-network", "ls-network-policy", "ls-server"]),
			},

		"CommSnmpTrap": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Community":UcsPropertyMeta("Community", "community", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x2L, None, None, """[!#$%\)\*\+,\-\./:<=\[\]\^_\{\}~a-zA-Z0-9]{0,32}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x4L, 0, 256, None, [], ["0-4294967295"]),
			"Hostname":UcsPropertyMeta("Hostname", "hostname", "string", _VersionMeta.Version101e, UcsPropertyMeta.Naming, 0x8L, None, None, """^[a-zA-Z0-9][a-zA-Z0-9_.-]{0,63}$|^([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}$|^([0-9a-fA-F]{1,4}:){1,7}:$|^([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}$|^([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}$|^([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}$|^([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}$|^([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}$|^[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})$|^:((:[0-9a-fA-F]{1,4}){1,7}|:)$""", [], ["0-4294967295"]),
			"NotificationType":UcsPropertyMeta("NotificationType", "notificationType", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadWrite, 0x10L, None, None, None, ["informs", "traps"], ["0-4294967295"]),
			"Port":UcsPropertyMeta("Port", "port", "uint", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x20L, None, None, None, [], ["1-65535"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x40L, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x80L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"V3Privilege":UcsPropertyMeta("V3Privilege", "v3Privilege", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadWrite, 0x100L, None, None, None, ["auth", "noauth", "priv"], ["0-4294967295"]),
			"Version":UcsPropertyMeta("Version", "version", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadWrite, 0x200L, None, None, None, ["v1", "v2c", "v3"], ["0-4294967295"]),
			"Meta":UcsMoMeta("CommSnmpTrap", "commSnmpTrap", "snmp-trap[Hostname]", _VersionMeta.Version101e, "InputOutput", 0x3ffL, [], [], ["Add", "Get", "Remove", "Set"], ["aaa", "admin"]),
			},

		"AdaptorIscsiTargetIf": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version201m, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"DhcpVendorId":UcsPropertyMeta("DhcpVendorId", "dhcpVendorId", "string", _VersionMeta.Version201m, UcsPropertyMeta.ReadOnly, None, 0, 510, None, [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version201m, UcsPropertyMeta.ReadOnly, 0x2L, 0, 256, None, [], ["0-4294967295"]),
			"FltAggr":UcsPropertyMeta("FltAggr", "fltAggr", "ulong", _VersionMeta.Version201m, UcsPropertyMeta.Internal, None, None, None, None, [], ["0-4294967295"]),
			"IpAddress":UcsPropertyMeta("IpAddress", "ipAddress", "string", _VersionMeta.Version201m, UcsPropertyMeta.ReadOnly, None, 0, 256, """((([0-9]){1,3}\.){3}[0-9]{1,3})""", [], ["0-4294967295"]),
			"Lun":UcsPropertyMeta("Lun", "lun", "ushort", _VersionMeta.Version201m, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"Name":UcsPropertyMeta("Name", "name", "string", _VersionMeta.Version201m, UcsPropertyMeta.ReadOnly, None, 0, 510, None, [], ["0-4294967295"]),
			"PortNumber":UcsPropertyMeta("PortNumber", "portNumber", "uint", _VersionMeta.Version201m, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"Priority":UcsPropertyMeta("Priority", "priority", "ushort", _VersionMeta.Version201m, UcsPropertyMeta.Naming, 0x4L, None, None, None, [], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version201m, UcsPropertyMeta.ReadOnly, 0x8L, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version201m, UcsPropertyMeta.ReadWrite, 0x10L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Meta":UcsMoMeta("AdaptorIscsiTargetIf", "adaptorIscsiTargetIf", "iscsi-target[Priority]", _VersionMeta.Version201m, "InputOutput", 0x1fL, [], [], [None], ["read-only"]),
			},

		"EquipmentPortGroupDef": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version141i, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Descr":UcsPropertyMeta("Descr", "descr", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadWrite, 0x2L, None, None, """[ !#$%&\(\)\*\+,\-\./:;\?@\[\]_\{\|\}~a-zA-Z0-9]{0,256}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, 0x4L, 0, 256, None, [], ["0-4294967295"]),
			"IntId":UcsPropertyMeta("IntId", "intId", "string", _VersionMeta.Version141i, UcsPropertyMeta.Internal, None, None, None, None, ["none"], ["0-4294967295"]),
			"Name":UcsPropertyMeta("Name", "name", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadWrite, 0x8L, None, None, """[\-\.:_a-zA-Z0-9]{0,16}""", [], ["0-4294967295"]),
			"NumberOfPorts":UcsPropertyMeta("NumberOfPorts", "numberOfPorts", "uint", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"PolicyLevel":UcsPropertyMeta("PolicyLevel", "policyLevel", "uint", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"PolicyOwner":UcsPropertyMeta("PolicyOwner", "policyOwner", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadWrite, 0x10L, None, None, None, ["local", "pending-policy", "policy"], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, 0x20L, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadWrite, 0x40L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Type":UcsPropertyMeta("Type", "type", "string", _VersionMeta.Version141i, UcsPropertyMeta.Naming, 0x80L, None, None, None, ["adaptor-ext", "adaptor-pc", "fabric", "fabric-pc", "host", "host-pc", "server-pc", "switch-ether", "switch-fc"], ["0-4294967295"]),
			"Meta":UcsMoMeta("EquipmentPortGroupDef", "equipmentPortGroupDef", "port-group-def[Type]", _VersionMeta.Version141i, "InputOutput", 0xffL, [], [], ["Get"], [""]),
			},

		"GraphicsCard": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version213a, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"DeviceId":UcsPropertyMeta("DeviceId", "deviceId", "uint", _VersionMeta.Version213a, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version213a, UcsPropertyMeta.ReadOnly, 0x2L, 0, 256, None, [], ["0-4294967295"]),
			"Id":UcsPropertyMeta("Id", "id", "uint", _VersionMeta.Version213a, UcsPropertyMeta.Naming, 0x4L, None, None, None, [], ["0-4294967295"]),
			"IsSupported":UcsPropertyMeta("IsSupported", "isSupported", "string", _VersionMeta.Version213a, UcsPropertyMeta.ReadOnly, None, None, None, None, ["false", "no", "true", "yes"], ["0-4294967295"]),
			"Lc":UcsPropertyMeta("Lc", "lc", "string", _VersionMeta.Version213a, UcsPropertyMeta.ReadOnly, None, None, None, None, ["allocated", "available", "deallocated", "repurposed"], ["0-4294967295"]),
			"Model":UcsPropertyMeta("Model", "model", "string", _VersionMeta.Version213a, UcsPropertyMeta.ReadOnly, None, 0, 510, None, [], ["0-4294967295"]),
			"OperQualifierReason":UcsPropertyMeta("OperQualifierReason", "operQualifierReason", "string", _VersionMeta.Version213a, UcsPropertyMeta.ReadOnly, None, None, None, """[ !#$%&\(\)\*\+,\-\./:;\?@\[\]_\{\|\}~a-zA-Z0-9]{0,256}""", [], ["0-4294967295"]),
			"OperState":UcsPropertyMeta("OperState", "operState", "string", _VersionMeta.Version213a, UcsPropertyMeta.ReadOnly, None, None, None, None, ["accessibility-problem", "auto-upgrade", "bios-post-timeout", "chassis-limit-exceeded", "config", "decomissioning", "degraded", "disabled", "discovery", "discovery-failed", "equipment-problem", "fabric-conn-problem", "fabric-unsupported-conn", "identify", "identity-unestablishable", "inoperable", "link-activate-blocked", "malformed-fru", "not-supported", "operable", "peer-comm-problem", "performance-problem", "post-failure", "power-problem", "powered-off", "removed", "thermal-problem", "unknown", "upgrade-problem", "voltage-problem"], ["0-4294967295"]),
			"Operability":UcsPropertyMeta("Operability", "operability", "string", _VersionMeta.Version213a, UcsPropertyMeta.ReadOnly, None, None, None, None, ["accessibility-problem", "auto-upgrade", "bios-post-timeout", "chassis-limit-exceeded", "config", "decomissioning", "degraded", "disabled", "discovery", "discovery-failed", "equipment-problem", "fabric-conn-problem", "fabric-unsupported-conn", "identify", "identity-unestablishable", "inoperable", "link-activate-blocked", "malformed-fru", "not-supported", "operable", "peer-comm-problem", "performance-problem", "post-failure", "power-problem", "powered-off", "removed", "thermal-problem", "unknown", "upgrade-problem", "voltage-problem"], ["0-4294967295"]),
			"PciAddr":UcsPropertyMeta("PciAddr", "pciAddr", "string", _VersionMeta.Version213a, UcsPropertyMeta.ReadOnly, None, 0, 510, None, [], ["0-4294967295"]),
			"PciSlot":UcsPropertyMeta("PciSlot", "pciSlot", "string", _VersionMeta.Version213a, UcsPropertyMeta.ReadOnly, None, 0, 510, None, [], ["0-4294967295"]),
			"Perf":UcsPropertyMeta("Perf", "perf", "string", _VersionMeta.Version213a, UcsPropertyMeta.ReadOnly, None, None, None, None, ["lower-critical", "lower-non-critical", "lower-non-recoverable", "not-supported", "ok", "unknown", "upper-critical", "upper-non-critical", "upper-non-recoverable"], ["0-4294967295"]),
			"Power":UcsPropertyMeta("Power", "power", "string", _VersionMeta.Version213a, UcsPropertyMeta.ReadOnly, None, None, None, None, ["degraded", "error", "failed", "not-supported", "off", "offduty", "offline", "ok", "on", "online", "power-save", "test", "unknown"], ["0-4294967295"]),
			"Presence":UcsPropertyMeta("Presence", "presence", "string", _VersionMeta.Version213a, UcsPropertyMeta.ReadOnly, None, None, None, None, ["empty", "equipped", "equipped-identity-unestablishable", "equipped-not-primary", "equipped-with-malformed-fru", "inaccessible", "mismatch", "mismatch-identity-unestablishable", "missing", "not-supported", "unauthorized", "unknown"], ["0-4294967295"]),
			"Revision":UcsPropertyMeta("Revision", "revision", "string", _VersionMeta.Version213a, UcsPropertyMeta.ReadOnly, None, 0, 510, None, [], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version213a, UcsPropertyMeta.ReadOnly, 0x8L, 0, 256, None, [], ["0-4294967295"]),
			"Serial":UcsPropertyMeta("Serial", "serial", "string", _VersionMeta.Version213a, UcsPropertyMeta.ReadOnly, None, 0, 510, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version213a, UcsPropertyMeta.ReadWrite, 0x10L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"SubDeviceId":UcsPropertyMeta("SubDeviceId", "subDeviceId", "uint", _VersionMeta.Version213a, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"SubVendorId":UcsPropertyMeta("SubVendorId", "subVendorId", "uint", _VersionMeta.Version213a, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"Thermal":UcsPropertyMeta("Thermal", "thermal", "string", _VersionMeta.Version213a, UcsPropertyMeta.ReadOnly, None, None, None, None, ["lower-critical", "lower-non-critical", "lower-non-recoverable", "not-supported", "ok", "unknown", "upper-critical", "upper-non-critical", "upper-non-recoverable"], ["0-4294967295"]),
			"Vendor":UcsPropertyMeta("Vendor", "vendor", "string", _VersionMeta.Version213a, UcsPropertyMeta.ReadOnly, None, 0, 510, None, [], ["0-4294967295"]),
			"VendorId":UcsPropertyMeta("VendorId", "vendorId", "uint", _VersionMeta.Version213a, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"Voltage":UcsPropertyMeta("Voltage", "voltage", "string", _VersionMeta.Version213a, UcsPropertyMeta.ReadOnly, None, None, None, None, ["lower-critical", "lower-non-critical", "lower-non-recoverable", "not-supported", "ok", "unknown", "upper-critical", "upper-non-critical", "upper-non-recoverable"], ["0-4294967295"]),
			"Meta":UcsMoMeta("GraphicsCard", "graphicsCard", "graphics-card-[Id]", _VersionMeta.Version213a, "InputOutput", 0x1fL, [], [u'graphicsController'], ["Get"], ["read-only"]),
			},

		"QosclassEthClassified": {
			"AdminState":UcsPropertyMeta("AdminState", "adminState", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x1L, None, None, None, ["disabled", "enabled"], ["0-4294967295"]),
			"BwPercent":UcsPropertyMeta("BwPercent", "bwPercent", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, ["not-applicable"], ["0-100"]),
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, 0x2L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Cos":UcsPropertyMeta("Cos", "cos", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x4L, None, None, None, ["any"], ["0-6", "255-255"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x8L, 0, 256, None, [], ["0-4294967295"]),
			"Drop":UcsPropertyMeta("Drop", "drop", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x10L, None, None, None, ["drop", "no-drop"], ["0-4294967295"]),
			"Mtu":UcsPropertyMeta("Mtu", "mtu", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x20L, None, None, None, ["fc", "normal"], ["0-4294967295"]),
			"MulticastOptimize":UcsPropertyMeta("MulticastOptimize", "multicastOptimize", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x40L, None, None, None, ["false", "no", "true", "yes"], ["0-4294967295"]),
			"Name":UcsPropertyMeta("Name", "name", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x80L, None, None, """[\-\.:_a-zA-Z0-9]{0,16}""", [], ["0-4294967295"]),
			"Priority":UcsPropertyMeta("Priority", "priority", "string", _VersionMeta.Version101e, UcsPropertyMeta.Naming, 0x100L, None, None, None, ["best-effort", "bronze", "fc", "gold", "platinum", "silver"], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x200L, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x400L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Weight":UcsPropertyMeta("Weight", "weight", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x800L, None, None, None, ["best-effort", "none"], ["0-10"]),
			"Meta":UcsMoMeta("QosclassEthClassified", "qosclassEthClassified", "class-[Priority]", _VersionMeta.Version101e, "InputOutput", 0xfffL, [], [], ["Get", "Set"], ["admin", "ext-lan-qos", "ext-san-qos", "ls-network", "ls-network-policy", "ls-qos-policy"]),
			},

		"DomainNetworkFeatureCont": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version221b, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadOnly, 0x2L, 0, 256, None, [], ["0-4294967295"]),
			"FltAggr":UcsPropertyMeta("FltAggr", "fltAggr", "ulong", _VersionMeta.Version221b, UcsPropertyMeta.Internal, None, None, None, None, [], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadOnly, 0x4L, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadWrite, 0x8L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Meta":UcsMoMeta("DomainNetworkFeatureCont", "domainNetworkFeatureCont", "network-feature-cont", _VersionMeta.Version221b, "InputOutput", 0xfL, [], [u'domainEnvironmentFeature', u'domainNetworkFeature', u'domainServerFeature', u'domainStorageFeature'], [None], ["admin", "read-only"]),
			},

		"MgmtIf": {
			"Access":UcsPropertyMeta("Access", "access", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, ["in-band", "internal", "out-of-band", "unspecified", "virtual"], ["0-4294967295"]),
			"AdminState":UcsPropertyMeta("AdminState", "adminState", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, ["disable", "enable"], ["0-4294967295"]),
			"ChassisId":UcsPropertyMeta("ChassisId", "chassisId", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, ["N/A"], ["0-255"]),
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Discovery":UcsPropertyMeta("Discovery", "discovery", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, None, None, None, None, ["absent", "mis-connect", "missing", "new", "present"], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x2L, 0, 256, None, [], ["0-4294967295"]),
			"EpDn":UcsPropertyMeta("EpDn", "epDn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"ExtBroadcast":UcsPropertyMeta("ExtBroadcast", "extBroadcast", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, 0, 256, """((([0-9]){1,3}\.){3}[0-9]{1,3})""", [], ["0-4294967295"]),
			"ExtGw":UcsPropertyMeta("ExtGw", "extGw", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, 0, 256, """((([0-9]){1,3}\.){3}[0-9]{1,3})""", [], ["0-4294967295"]),
			"ExtIp":UcsPropertyMeta("ExtIp", "extIp", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, 0, 256, """((([0-9]){1,3}\.){3}[0-9]{1,3})""", [], ["0-4294967295"]),
			"ExtMask":UcsPropertyMeta("ExtMask", "extMask", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, 0, 256, """((([0-9]){1,3}\.){3}[0-9]{1,3})""", [], ["0-4294967295"]),
			"FsmDescr":UcsPropertyMeta("FsmDescr", "fsmDescr", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, None, None, None, None, [], ["0-4294967295"]),
			"FsmPrev":UcsPropertyMeta("FsmPrev", "fsmPrev", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, None, None, None, None, ["DisableVipBegin", "DisableVipFail", "DisableVipPeer", "DisableVipSuccess", "EnableHABegin", "EnableHAFail", "EnableHALocal", "EnableHASuccess", "EnableVipBegin", "EnableVipFail", "EnableVipLocal", "EnableVipSuccess", "SwMgmtInbandIfConfigBegin", "SwMgmtInbandIfConfigFail", "SwMgmtInbandIfConfigSuccess", "SwMgmtInbandIfConfigSwitch", "SwMgmtOobIfConfigBegin", "SwMgmtOobIfConfigFail", "SwMgmtOobIfConfigSuccess", "SwMgmtOobIfConfigSwitch", "VirtualIfConfigBegin", "VirtualIfConfigFail", "VirtualIfConfigLocal", "VirtualIfConfigRemote", "VirtualIfConfigSuccess", "nop"], ["0-4294967295"]),
			"FsmProgr":UcsPropertyMeta("FsmProgr", "fsmProgr", "byte", _VersionMeta.Version101e, UcsPropertyMeta.Internal, None, None, None, None, [], ["0-100"]),
			"FsmRmtInvErrCode":UcsPropertyMeta("FsmRmtInvErrCode", "fsmRmtInvErrCode", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, None, None, None, None, ["ERR-2fa-auth-retry", "ERR-ACTIVATE-failed", "ERR-ACTIVATE-in-progress", "ERR-ACTIVATE-retry", "ERR-BIOS-TOKENS-OLD-BIOS", "ERR-BIOS-TOKENS-OLD-CIMC", "ERR-BIOS-network-boot-order-not-found", "ERR-BOARDCTRLUPDATE-ignore", "ERR-DIAG-cancelled", "ERR-DIAG-fsm-restarted", "ERR-DIAG-test-failed", "ERR-DNLD-authentication-failure", "ERR-DNLD-hostkey-mismatch", "ERR-DNLD-invalid-image", "ERR-DNLD-no-file", "ERR-DNLD-no-space", "ERR-DNS-delete-error", "ERR-DNS-get-error", "ERR-DNS-set-error", "ERR-Diagnostics-in-progress", "ERR-Diagnostics-memtest-in-progress", "ERR-Diagnostics-network-in-progress", "ERR-FILTER-illegal-format", "ERR-FSM-no-such-state", "ERR-HOST-fru-identity-mismatch", "ERR-HTTP-set-error", "ERR-HTTPS-set-error", "ERR-IBMC-analyze-results", "ERR-IBMC-connect-error", "ERR-IBMC-fru-retrieval-error", "ERR-IBMC-invalid-end-point-config", "ERR-IBMC-results-not-ready", "ERR-MAX-subscriptions-allowed-error", "ERR-MO-CONFIG-child-object-cant-be-configured", "ERR-MO-META-no-such-object-class", "ERR-MO-PROPERTY-no-such-property", "ERR-MO-PROPERTY-value-out-of-range", "ERR-MO-access-denied", "ERR-MO-deletion-rule-violation", "ERR-MO-duplicate-object", "ERR-MO-illegal-containment", "ERR-MO-illegal-creation", "ERR-MO-illegal-iterator-state", "ERR-MO-illegal-object-lifecycle-transition", "ERR-MO-naming-rule-violation", "ERR-MO-object-not-found", "ERR-MO-resource-allocation", "ERR-NTP-delete-error", "ERR-NTP-get-error", "ERR-NTP-set-error", "ERR-POWER-CAP-UNSUPPORTED", "ERR-SERVER-mis-connect", "ERR-SWITCH-invalid-if-config", "ERR-TOKEN-request-denied", "ERR-UNABLE-TO-FETCH-BIOS-SETTINGS", "ERR-UPDATE-failed", "ERR-UPDATE-in-progress", "ERR-UPDATE-retry", "ERR-aaa-config-modify-error", "ERR-acct-realm-set-error", "ERR-admin-passwd-set", "ERR-auth-issue", "ERR-auth-realm-get-error", "ERR-auth-realm-set-error", "ERR-authentication", "ERR-authorization-required", "ERR-cli-session-limit-reached", "ERR-create-keyring", "ERR-create-locale", "ERR-create-role", "ERR-create-user", "ERR-delete-locale", "ERR-delete-role", "ERR-delete-session", "ERR-delete-user", "ERR-efi-Diagnostics--in-progress", "ERR-enable-mgmt-conn", "ERR-ep-set-error", "ERR-get-max-http-user-sessions", "ERR-http-initializing", "ERR-insufficiently-equipped", "ERR-internal-error", "ERR-ldap-delete-error", "ERR-ldap-get-error", "ERR-ldap-group-modify-error", "ERR-ldap-group-set-error", "ERR-ldap-set-error", "ERR-locale-set-error", "ERR-max-userid-sessions-reached", "ERR-missing-method", "ERR-modify-locale", "ERR-modify-role", "ERR-modify-user", "ERR-modify-user-locale", "ERR-modify-user-role", "ERR-provider-group-modify-error", "ERR-provider-group-set-error", "ERR-radius-get-error", "ERR-radius-global-set-error", "ERR-radius-group-set-error", "ERR-radius-set-error", "ERR-request-timeout", "ERR-reset-adapter", "ERR-role-set-error", "ERR-secondary-node", "ERR-service-not-ready", "ERR-session-cache-full", "ERR-session-not-found", "ERR-set-network", "ERR-set-password-strength-check", "ERR-set-port-channel", "ERR-store-pre-login-banner-msg", "ERR-tacacs-enable-error", "ERR-tacacs-global-set-error", "ERR-tacacs-group-set-error", "ERR-tacacs-plus-get-error", "ERR-tacacs-set-error", "ERR-test-error-1", "ERR-test-error-2", "ERR-timezone-set-error", "ERR-user-account-expired", "ERR-user-set-error", "ERR-xml-parse-error", "none"], ["0-4294967295"]),
			"FsmRmtInvErrDescr":UcsPropertyMeta("FsmRmtInvErrDescr", "fsmRmtInvErrDescr", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, None, 0, 510, None, [], ["0-4294967295"]),
			"FsmRmtInvRslt":UcsPropertyMeta("FsmRmtInvRslt", "fsmRmtInvRslt", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, None, None, None, """((defaultValue|not-applicable|resource-unavailable|service-unavailable|intermittent-error|sw-defect|service-not-implemented-ignore|extend-timeout|capability-not-implemented-failure|illegal-fru|end-point-unavailable|failure|resource-capacity-exceeded|service-protocol-error|fw-defect|service-not-implemented-fail|task-reset|unidentified-fail|capability-not-supported|end-point-failed|fru-state-indeterminate|resource-dependency|fru-identity-indeterminate|internal-error|hw-defect|service-not-supported|fru-not-supported|end-point-protocol-error|capability-unavailable|fru-not-ready|capability-not-implemented-ignore|fru-info-malformed|timeout),){0,32}(defaultValue|not-applicable|resource-unavailable|service-unavailable|intermittent-error|sw-defect|service-not-implemented-ignore|extend-timeout|capability-not-implemented-failure|illegal-fru|end-point-unavailable|failure|resource-capacity-exceeded|service-protocol-error|fw-defect|service-not-implemented-fail|task-reset|unidentified-fail|capability-not-supported|end-point-failed|fru-state-indeterminate|resource-dependency|fru-identity-indeterminate|internal-error|hw-defect|service-not-supported|fru-not-supported|end-point-protocol-error|capability-unavailable|fru-not-ready|capability-not-implemented-ignore|fru-info-malformed|timeout){0,1}""", [], ["0-4294967295"]),
			"FsmStageDescr":UcsPropertyMeta("FsmStageDescr", "fsmStageDescr", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, None, None, None, None, [], ["0-4294967295"]),
			"FsmStamp":UcsPropertyMeta("FsmStamp", "fsmStamp", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, None, None, None, """([0-9]){4}-([0-9]){2}-([0-9]){2}T([0-9]){2}:([0-9]){2}:([0-9]){2}((\.([0-9]){3})){0,1}""", ["never"], ["0-4294967295"]),
			"FsmStatus":UcsPropertyMeta("FsmStatus", "fsmStatus", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, None, None, None, None, ["DisableVipBegin", "DisableVipFail", "DisableVipPeer", "DisableVipSuccess", "EnableHABegin", "EnableHAFail", "EnableHALocal", "EnableHASuccess", "EnableVipBegin", "EnableVipFail", "EnableVipLocal", "EnableVipSuccess", "SwMgmtInbandIfConfigBegin", "SwMgmtInbandIfConfigFail", "SwMgmtInbandIfConfigSuccess", "SwMgmtInbandIfConfigSwitch", "SwMgmtOobIfConfigBegin", "SwMgmtOobIfConfigFail", "SwMgmtOobIfConfigSuccess", "SwMgmtOobIfConfigSwitch", "VirtualIfConfigBegin", "VirtualIfConfigFail", "VirtualIfConfigLocal", "VirtualIfConfigRemote", "VirtualIfConfigSuccess", "nop"], ["0-4294967295"]),
			"FsmTry":UcsPropertyMeta("FsmTry", "fsmTry", "byte", _VersionMeta.Version101e, UcsPropertyMeta.Internal, None, None, None, None, [], ["0-4294967295"]),
			"Id":UcsPropertyMeta("Id", "id", "uint", _VersionMeta.Version101e, UcsPropertyMeta.Naming, 0x4L, None, None, None, [], ["0-4294967295"]),
			"IfRole":UcsPropertyMeta("IfRole", "ifRole", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, ["diag", "fcoe-nas-storage", "fcoe-storage", "fcoe-uplink", "mgmt", "monitor", "nas-storage", "network", "network-fcoe-uplink", "server", "service", "storage", "unknown"], ["0-4294967295"]),
			"IfType":UcsPropertyMeta("IfType", "ifType", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, ["aggregation", "physical", "unknown", "virtual"], ["0-4294967295"]),
			"Ip":UcsPropertyMeta("Ip", "ip", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, 0, 256, """((([0-9]){1,3}\.){3}[0-9]{1,3})""", [], ["0-4294967295"]),
			"Locale":UcsPropertyMeta("Locale", "locale", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, """((defaultValue|unknown|server|chassis|internal|external),){0,5}(defaultValue|unknown|server|chassis|internal|external){0,1}""", [], ["0-4294967295"]),
			"Mac":UcsPropertyMeta("Mac", "mac", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, """(([0-9a-fA-F][0-9a-fA-F]:){5}([0-9a-fA-F][0-9a-fA-F]))|0""", [], ["0-4294967295"]),
			"Mask":UcsPropertyMeta("Mask", "mask", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, 0, 256, """((([0-9]){1,3}\.){3}[0-9]{1,3})""", [], ["0-4294967295"]),
			"Name":UcsPropertyMeta("Name", "name", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x8L, None, None, """[\-\.:_a-zA-Z0-9]{0,16}""", [], ["0-4294967295"]),
			"PeerChassisId":UcsPropertyMeta("PeerChassisId", "peerChassisId", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, None, None, None, None, ["N/A"], ["0-255"]),
			"PeerDn":UcsPropertyMeta("PeerDn", "peerDn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"PeerPortId":UcsPropertyMeta("PeerPortId", "peerPortId", "uint", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"PeerSlotId":UcsPropertyMeta("PeerSlotId", "peerSlotId", "uint", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"PortId":UcsPropertyMeta("PortId", "portId", "uint", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x10L, 0, 256, None, [], ["0-4294967295"]),
			"SlotId":UcsPropertyMeta("SlotId", "slotId", "uint", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"StateQual":UcsPropertyMeta("StateQual", "stateQual", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, None, None, None, None, ["misconnected", "unspecified", "valid"], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x20L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Subject":UcsPropertyMeta("Subject", "subject", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, ["adaptor", "blade", "board-controller", "chassis", "iocard", "switch", "system", "unknown"], ["0-4294967295"]),
			"SwitchId":UcsPropertyMeta("SwitchId", "switchId", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, ["A", "B", "NONE"], ["0-4294967295"]),
			"Transport":UcsPropertyMeta("Transport", "transport", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, """((defaultValue|unknown|ether|dce|fc),){0,4}(defaultValue|unknown|ether|dce|fc){0,1}""", [], ["0-4294967295"]),
			"Type":UcsPropertyMeta("Type", "type", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, """((defaultValue|unknown|lan|san|ipc),){0,4}(defaultValue|unknown|lan|san|ipc){0,1}""", [], ["0-4294967295"]),
			"Vnet":UcsPropertyMeta("Vnet", "vnet", "uint", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4090"]),
			"Meta":UcsMoMeta("MgmtIf", "mgmtIf", "if-[Id]", _VersionMeta.Version101e, "InputOutput", 0x3fL, [], [u'dhcpAcquired', u'eventInst', u'faultInst', u'mgmtIPv6IfConfig', u'mgmtIfFsm', u'mgmtIfFsmTask'], ["Get"], ["admin"]),
			},

		"PortDomainEp": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x2L, 0, 256, None, [], ["0-4294967295"]),
			"EpDn":UcsPropertyMeta("EpDn", "epDn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"IfRole":UcsPropertyMeta("IfRole", "ifRole", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, ["diag", "fcoe-nas-storage", "fcoe-storage", "fcoe-uplink", "mgmt", "monitor", "nas-storage", "network", "network-fcoe-uplink", "server", "service", "storage", "unknown"], ["0-4294967295"]),
			"IfType":UcsPropertyMeta("IfType", "ifType", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, ["aggregation", "physical", "unknown", "virtual"], ["0-4294967295"]),
			"Locale":UcsPropertyMeta("Locale", "locale", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, """((defaultValue|unknown|server|chassis|internal|external),){0,5}(defaultValue|unknown|server|chassis|internal|external){0,1}""", [], ["0-4294967295"]),
			"Name":UcsPropertyMeta("Name", "name", "string", _VersionMeta.Version101e, UcsPropertyMeta.Naming, 0x4L, None, None, """[\-\.:_a-zA-Z0-9]{1,16}""", [], ["0-4294967295"]),
			"PeerDn":UcsPropertyMeta("PeerDn", "peerDn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x8L, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x10L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Transport":UcsPropertyMeta("Transport", "transport", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, """((defaultValue|unknown|ether|dce|fc),){0,4}(defaultValue|unknown|ether|dce|fc){0,1}""", [], ["0-4294967295"]),
			"Type":UcsPropertyMeta("Type", "type", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, """((defaultValue|unknown|lan|san|ipc),){0,4}(defaultValue|unknown|lan|san|ipc){0,1}""", [], ["0-4294967295"]),
			"Meta":UcsMoMeta("PortDomainEp", "portDomainEp", "domain-[Name]", _VersionMeta.Version101e, "InputOutput", 0x1fL, [], [], ["Get"], ["read-only"]),
			},

		"FirmwareBootUnit": {
			"AdminState":UcsPropertyMeta("AdminState", "adminState", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x1L, None, None, None, ["trigger", "triggered"], ["0-4294967295"]),
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, 0x2L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x4L, 0, 256, None, [], ["0-4294967295"]),
			"IgnoreCompCheck":UcsPropertyMeta("IgnoreCompCheck", "ignoreCompCheck", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x8L, None, None, None, ["false", "no", "true", "yes"], ["0-4294967295"]),
			"Image":UcsPropertyMeta("Image", "image", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, ["backup", "running"], ["0-4294967295"]),
			"OperState":UcsPropertyMeta("OperState", "operState", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, ["activating", "auto-activating", "auto-updating", "bad-image", "failed", "pending-next-boot", "pending-power-cycle", "ready", "rebooting", "scheduled", "set-startup", "throttled", "updating", "upgrading"], ["0-4294967295"]),
			"PrevVersion":UcsPropertyMeta("PrevVersion", "prevVersion", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, 0, 510, None, [], ["0-4294967295"]),
			"ResetOnActivate":UcsPropertyMeta("ResetOnActivate", "resetOnActivate", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x10L, None, None, None, ["false", "no", "true", "yes"], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x20L, 0, 256, None, [], ["0-4294967295"]),
			"SkipValidation":UcsPropertyMeta("SkipValidation", "skipValidation", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadWrite, 0x40L, None, None, None, ["false", "no", "true", "yes"], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x80L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Type":UcsPropertyMeta("Type", "type", "string", _VersionMeta.Version101e, UcsPropertyMeta.Naming, 0x100L, None, None, """((kernel|system|combined|boot-loader),){0,3}(kernel|system|combined|boot-loader){0,1}""", [], ["0-4294967295"]),
			"Version":UcsPropertyMeta("Version", "version", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x200L, 0, 510, None, [], ["0-4294967295"]),
			"Meta":UcsMoMeta("FirmwareBootUnit", "firmwareBootUnit", "bootunit-[Type]", _VersionMeta.Version101e, "InputOutput", 0x3ffL, [], [u'faultInst', u'firmwareInstallable'], ["Get", "Set"], ["admin"]),
			},

		"StorageSystemFsmTask": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version211a, UcsPropertyMeta.Internal, None, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Completion":UcsPropertyMeta("Completion", "completion", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, ["cancelled", "completed", "processing", "scheduled"], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"Flags":UcsPropertyMeta("Flags", "flags", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, """(defaultValue){0,1}""", [], ["0-4294967295"]),
			"Item":UcsPropertyMeta("Item", "item", "string", _VersionMeta.Version211a, UcsPropertyMeta.Naming, None, None, None, None, ["Sync", "nop"], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"SeqId":UcsPropertyMeta("SeqId", "seqId", "uint", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadWrite, None, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Meta":UcsMoMeta("StorageSystemFsmTask", "storageSystemFsmTask", "task-[Item]", _VersionMeta.Version211a, "OutputOnly", 0x0L, [], [], [None], [""]),
			},

		"PowerGroup": {
			"AdminCommitted":UcsPropertyMeta("AdminCommitted", "adminCommitted", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadWrite, 0x1L, None, None, None, ["unbounded"], ["0-10000000", "4294967295-4294967295"]),
			"AdminPeak":UcsPropertyMeta("AdminPeak", "adminPeak", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadWrite, 0x2L, None, None, None, ["unbounded"], ["0-10000000", "4294967295-4294967295"]),
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version111j, UcsPropertyMeta.Internal, 0x4L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"CurReqPower":UcsPropertyMeta("CurReqPower", "curReqPower", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, None, None, None, None, ["unbounded"], ["0-10000000", "4294967295-4294967295"]),
			"CurrentPower":UcsPropertyMeta("CurrentPower", "currentPower", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, None, None, None, None, ["unbounded"], ["0-10000000", "4294967295-4294967295"]),
			"Descr":UcsPropertyMeta("Descr", "descr", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadWrite, 0x8L, None, None, """[ !#$%&\(\)\*\+,\-\./:;\?@\[\]_\{\|\}~a-zA-Z0-9]{0,256}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, 0x10L, 0, 256, None, [], ["0-4294967295"]),
			"FltAggr":UcsPropertyMeta("FltAggr", "fltAggr", "ulong", _VersionMeta.Version141i, UcsPropertyMeta.Internal, None, None, None, None, [], ["0-4294967295"]),
			"IntId":UcsPropertyMeta("IntId", "intId", "string", _VersionMeta.Version111j, UcsPropertyMeta.Internal, None, None, None, None, ["none"], ["0-4294967295"]),
			"MinReqPower":UcsPropertyMeta("MinReqPower", "minReqPower", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, None, None, None, None, ["unbounded"], ["0-10000000", "4294967295-4294967295"]),
			"Name":UcsPropertyMeta("Name", "name", "string", _VersionMeta.Version111j, UcsPropertyMeta.Naming, 0x20L, None, None, """[\-\.:_a-zA-Z0-9]{1,16}""", [], ["0-4294967295"]),
			"OperCommitted":UcsPropertyMeta("OperCommitted", "operCommitted", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, None, None, None, None, ["unbounded"], ["0-10000000", "4294967295-4294967295"]),
			"OperPeak":UcsPropertyMeta("OperPeak", "operPeak", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, None, None, None, None, ["unbounded"], ["0-10000000", "4294967295-4294967295"]),
			"OperState":UcsPropertyMeta("OperState", "operState", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, None, None, None, """((cap-ok|defaultValue|cap-insufficient|cap-mismatch),){0,3}(cap-ok|defaultValue|cap-insufficient|cap-mismatch){0,1}""", [], ["0-4294967295"]),
			"PolicyLevel":UcsPropertyMeta("PolicyLevel", "policyLevel", "uint", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"PolicyOwner":UcsPropertyMeta("PolicyOwner", "policyOwner", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadWrite, 0x40L, None, None, None, ["local", "pending-policy", "policy"], ["0-4294967295"]),
			"Qualifier":UcsPropertyMeta("Qualifier", "qualifier", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadWrite, 0x80L, None, None, """[\-\.:_a-zA-Z0-9]{0,16}""", [], ["0-4294967295"]),
			"Realloc":UcsPropertyMeta("Realloc", "realloc", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadWrite, 0x100L, None, None, None, ["chassis", "none"], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, 0x200L, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadWrite, 0x400L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Meta":UcsMoMeta("PowerGroup", "powerGroup", "group-[Name]", _VersionMeta.Version111j, "InputOutput", 0x7ffL, [], [u'faultInst', u'powerChassisMember', u'powerRackUnitMember'], ["Add", "Get", "Remove", "Set"], ["admin", "power-mgmt"]),
			},

		"FabricNetflowMonExporter": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version221b, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Descr":UcsPropertyMeta("Descr", "descr", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadWrite, 0x2L, None, None, """[ !#$%&\(\)\*\+,\-\./:;\?@\[\]_\{\|\}~a-zA-Z0-9]{0,256}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadOnly, 0x4L, 0, 256, None, [], ["0-4294967295"]),
			"Dscp":UcsPropertyMeta("Dscp", "dscp", "ushort", _VersionMeta.Version221b, UcsPropertyMeta.ReadWrite, 0x8L, None, None, None, [], ["0-63"]),
			"ExportInternal":UcsPropertyMeta("ExportInternal", "exportInternal", "uint", _VersionMeta.Version221b, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"ExporterStatsTimeout":UcsPropertyMeta("ExporterStatsTimeout", "exporterStatsTimeout", "uint", _VersionMeta.Version221b, UcsPropertyMeta.ReadWrite, 0x10L, None, None, None, [], ["1-86400"]),
			"FlowExpProfile":UcsPropertyMeta("FlowExpProfile", "flowExpProfile", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadWrite, 0x20L, None, None, """[\-\.:_a-zA-Z0-9]{0,16}""", [], ["0-4294967295"]),
			"FlowMonCollector":UcsPropertyMeta("FlowMonCollector", "flowMonCollector", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadWrite, 0x40L, None, None, """[\-\.:_a-zA-Z0-9]{0,16}""", [], ["0-4294967295"]),
			"IntId":UcsPropertyMeta("IntId", "intId", "string", _VersionMeta.Version221b, UcsPropertyMeta.Internal, None, None, None, None, ["none"], ["0-4294967295"]),
			"InterfaceTableTimeout":UcsPropertyMeta("InterfaceTableTimeout", "interfaceTableTimeout", "uint", _VersionMeta.Version221b, UcsPropertyMeta.ReadWrite, 0x80L, None, None, None, [], ["1-86400"]),
			"Name":UcsPropertyMeta("Name", "name", "string", _VersionMeta.Version221b, UcsPropertyMeta.Naming, 0x100L, None, None, """[\-\.:_a-zA-Z0-9]{1,16}""", [], ["0-4294967295"]),
			"OperFlowExpProfile":UcsPropertyMeta("OperFlowExpProfile", "operFlowExpProfile", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"PolicyLevel":UcsPropertyMeta("PolicyLevel", "policyLevel", "uint", _VersionMeta.Version221b, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"PolicyOwner":UcsPropertyMeta("PolicyOwner", "policyOwner", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadWrite, 0x200L, None, None, None, ["local", "pending-policy", "policy"], ["0-4294967295"]),
			"Protocol":UcsPropertyMeta("Protocol", "protocol", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadOnly, None, None, None, None, ["netflow"], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadOnly, 0x400L, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadWrite, 0x800L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"TemplateDataTimeout":UcsPropertyMeta("TemplateDataTimeout", "templateDataTimeout", "uint", _VersionMeta.Version221b, UcsPropertyMeta.ReadWrite, 0x1000L, None, None, None, [], ["1-86400"]),
			"Transport":UcsPropertyMeta("Transport", "transport", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadOnly, None, None, None, """((defaultValue|unknown|ether|dce|fc),){0,4}(defaultValue|unknown|ether|dce|fc){0,1}""", [], ["0-4294967295"]),
			"TransportProtocol":UcsPropertyMeta("TransportProtocol", "transportProtocol", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadOnly, None, None, None, None, ["sctp", "udp"], ["0-4294967295"]),
			"Type":UcsPropertyMeta("Type", "type", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadOnly, None, None, None, """((defaultValue|unknown|lan|san|ipc),){0,4}(defaultValue|unknown|lan|san|ipc){0,1}""", [], ["0-4294967295"]),
			"Version":UcsPropertyMeta("Version", "version", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadOnly, None, None, None, None, ["ipfix", "v9"], ["0-4294967295"]),
			"Meta":UcsMoMeta("FabricNetflowMonExporter", "fabricNetflowMonExporter", "lanFlowMonExporter-eth-netflow-[Name]", _VersionMeta.Version221b, "InputOutput", 0x1fffL, [], [u'faultInst'], [None], ["admin", "ext-lan-config", "ext-lan-policy"]),
			},

		"VnicIPv4Dns": {
			"Addr":UcsPropertyMeta("Addr", "addr", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x1L, 0, 256, """((([0-9]){1,3}\.){3}[0-9]{1,3})""", [], ["0-4294967295"]),
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, 0x2L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"DefGw":UcsPropertyMeta("DefGw", "defGw", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, 0, 256, """((([0-9]){1,3}\.){3}[0-9]{1,3})""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x4L, 0, 256, None, [], ["0-4294967295"]),
			"Pref":UcsPropertyMeta("Pref", "pref", "string", _VersionMeta.Version101e, UcsPropertyMeta.Naming, 0x8L, None, None, None, ["alternate", "preferred"], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x10L, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x20L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Subnet":UcsPropertyMeta("Subnet", "subnet", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, 0, 256, """((([0-9]){1,3}\.){3}[0-9]{1,3})""", [], ["0-4294967295"]),
			"Meta":UcsMoMeta("VnicIPv4Dns", "vnicIPv4Dns", "ipv4-dns-[Pref]", _VersionMeta.Version101e, "InputOutput", 0x3fL, [], [], ["Get"], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server"]),
			},

		"ComputePhysicalFsmStage": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version211a, UcsPropertyMeta.Internal, None, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Descr":UcsPropertyMeta("Descr", "descr", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, """[ !#$%&\(\)\*\+,\-\./:;\?@\[\]_\{\|\}~a-zA-Z0-9]{0,256}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"LastUpdateTime":UcsPropertyMeta("LastUpdateTime", "lastUpdateTime", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, """([0-9]){4}-([0-9]){2}-([0-9]){2}T([0-9]){2}:([0-9]){2}:([0-9]){2}((\.([0-9]){3})){0,1}""", [""], ["0-4294967295"]),
			"Name":UcsPropertyMeta("Name", "name", "string", _VersionMeta.Version211a, UcsPropertyMeta.Naming, None, None, None, None, ["ActivateAdaptorActivateLocal", "ActivateAdaptorActivatePeer", "ActivateAdaptorBegin", "ActivateAdaptorDeassertResetBypass", "ActivateAdaptorFail", "ActivateAdaptorPowerOn", "ActivateAdaptorReset", "ActivateAdaptorSuccess", "ActivateBIOSActivate", "ActivateBIOSBegin", "ActivateBIOSClear", "ActivateBIOSFail", "ActivateBIOSPollActivateStatus", "ActivateBIOSPollClearStatus", "ActivateBIOSPowerOff", "ActivateBIOSPowerOn", "ActivateBIOSSuccess", "ActivateBIOSUpdateTokens", "AssociateActivateAdaptorNwFwLocal", "AssociateActivateAdaptorNwFwPeer", "AssociateActivateBios", "AssociateActivateIBMCFw", "AssociateBegin", "AssociateBiosImgUpdate", "AssociateBiosPostCompletion", "AssociateBladePowerOff", "AssociateBmcConfigPnuOS", "AssociateBmcPreconfigPnuOSLocal", "AssociateBmcPreconfigPnuOSPeer", "AssociateBmcUnconfigPnuOS", "AssociateBootHost", "AssociateBootPnuos", "AssociateBootWait", "AssociateClearBiosUpdate", "AssociateConfigFlexFlash", "AssociateConfigSoL", "AssociateConfigUserAccess", "AssociateConfigUuid", "AssociateDeassertResetBypass", "AssociateFail", "AssociateHagHostOSConnect", "AssociateHagPnuOSConnect", "AssociateHagPnuOSDisconnect", "AssociateHbaImgUpdate", "AssociateHostOSConfig", "AssociateHostOSIdent", "AssociateHostOSPolicy", "AssociateHostOSValidate", "AssociateLocalDiskFwUpdate", "AssociateMarkAdapterForReboot", "AssociateNicConfigHostOSLocal", "AssociateNicConfigHostOSPeer", "AssociateNicConfigPnuOSLocal", "AssociateNicConfigPnuOSPeer", "AssociateNicConfigServiceInfraLocal", "AssociateNicConfigServiceInfraPeer", "AssociateNicImgUpdate", "AssociateNicUnconfigPnuOSLocal", "AssociateNicUnconfigPnuOSPeer", "AssociateOobStorageInventory", "AssociatePnuOSCatalog", "AssociatePnuOSConfig", "AssociatePnuOSIdent", "AssociatePnuOSInventory", "AssociatePnuOSLocalDiskConfig", "AssociatePnuOSPolicy", "AssociatePnuOSSelfTest", "AssociatePnuOSUnloadDrivers", "AssociatePnuOSValidate", "AssociatePollBiosActivateStatus", "AssociatePollBiosUpdateStatus", "AssociatePollBoardCtrlUpdateStatus", "AssociatePollClearBiosUpdateStatus", "AssociatePowerOn", "AssociatePowerOnPreConfig", "AssociatePreSanitize", "AssociatePrepareForBoot", "AssociateResetIBMC", "AssociateSanitize", "AssociateSerialDebugPnuOSConnect", "AssociateSerialDebugPnuOSDisconnect", "AssociateSolRedirectDisable", "AssociateSolRedirectEnable", "AssociateStorageCtlrImgUpdate", "AssociateSuccess", "AssociateSwConfigHostOSLocal", "AssociateSwConfigHostOSPeer", "AssociateSwConfigPnuOSLocal", "AssociateSwConfigPnuOSPeer", "AssociateSwConfigPortNivLocal", "AssociateSwConfigPortNivPeer", "AssociateSwConfigServiceInfraLocal", "AssociateSwConfigServiceInfraPeer", "AssociateSwUnconfigPnuOSLocal", "AssociateSwUnconfigPnuOSPeer", "AssociateSyncPowerState", "AssociateUpdateAdaptorNwFwLocal", "AssociateUpdateAdaptorNwFwPeer", "AssociateUpdateBiosRequest", "AssociateUpdateBoardCtrlRequest", "AssociateUpdateIBMCFw", "AssociateVerifyFcZoneConfig", "AssociateWaitForAdaptorNwFwUpdateLocal", "AssociateWaitForAdaptorNwFwUpdatePeer", "AssociateWaitForIBMCFwUpdate", "BiosRecoveryBegin", "BiosRecoveryCleanup", "BiosRecoveryFail", "BiosRecoveryPreSanitize", "BiosRecoveryReset", "BiosRecoverySanitize", "BiosRecoverySetupVmediaLocal", "BiosRecoverySetupVmediaPeer", "BiosRecoveryShutdown", "BiosRecoveryStart", "BiosRecoveryStopVMediaLocal", "BiosRecoveryStopVMediaPeer", "BiosRecoverySuccess", "BiosRecoveryTeardownVmediaLocal", "BiosRecoveryTeardownVmediaPeer", "BiosRecoveryWait", "CimcSessionDeleteBegin", "CimcSessionDeleteExecute", "CimcSessionDeleteFail", "CimcSessionDeleteSuccess", "CmosResetBegin", "CmosResetBladePowerOn", "CmosResetExecute", "CmosResetFail", "CmosResetPreSanitize", "CmosResetReconfigBios", "CmosResetReconfigUuid", "CmosResetSanitize", "CmosResetSuccess", "ConfigBoardBegin", "ConfigBoardConfigMemoryPolicy", "ConfigBoardFail", "ConfigBoardSuccess", "ConfigSoLBegin", "ConfigSoLExecute", "ConfigSoLFail", "ConfigSoLSuccess", "DecommissionBegin", "DecommissionCleanupCIMC", "DecommissionCleanupPortConfigLocal", "DecommissionCleanupPortConfigPeer", "DecommissionExecute", "DecommissionFail", "DecommissionStopVMediaLocal", "DecommissionStopVMediaPeer", "DecommissionSuccess", "DiagnosticInterruptBegin", "DiagnosticInterruptExecute", "DiagnosticInterruptFail", "DiagnosticInterruptSuccess", "DisassociateBegin", "DisassociateBiosPostCompletion", "DisassociateBmcConfigPnuOS", "DisassociateBmcPreconfigPnuOSLocal", "DisassociateBmcPreconfigPnuOSPeer", "DisassociateBmcUnconfigPnuOS", "DisassociateBootPnuos", "DisassociateBootWait", "DisassociateConfigBios", "DisassociateConfigFlexFlashScrub", "DisassociateConfigUserAccess", "DisassociateDeassertResetBypass", "DisassociateFail", "DisassociateHagPnuOSConnect", "DisassociateHagPnuOSDisconnect", "DisassociateHandlePooling", "DisassociateNicConfigPnuOSLocal", "DisassociateNicConfigPnuOSPeer", "DisassociateNicUnconfigHostOSLocal", "DisassociateNicUnconfigHostOSPeer", "DisassociateNicUnconfigPnuOSLocal", "DisassociateNicUnconfigPnuOSPeer", "DisassociateNicUnconfigServiceInfraLocal", "DisassociateNicUnconfigServiceInfraPeer", "DisassociatePnuOSCatalog", "DisassociatePnuOSIdent", "DisassociatePnuOSPolicy", "DisassociatePnuOSScrub", "DisassociatePnuOSSelfTest", "DisassociatePnuOSUnconfig", "DisassociatePnuOSValidate", "DisassociatePowerOn", "DisassociatePreSanitize", "DisassociateResetSecureBootConfig", "DisassociateSanitize", "DisassociateSerialDebugPnuOSConnect", "DisassociateSerialDebugPnuOSDisconnect", "DisassociateShutdown", "DisassociateSolRedirectDisable", "DisassociateSolRedirectEnable", "DisassociateSuccess", "DisassociateSwConfigPnuOSLocal", "DisassociateSwConfigPnuOSPeer", "DisassociateSwConfigPortNivLocal", "DisassociateSwConfigPortNivPeer", "DisassociateSwUnconfigHostOSLocal", "DisassociateSwUnconfigHostOSPeer", "DisassociateSwUnconfigPnuOSLocal", "DisassociateSwUnconfigPnuOSPeer", "DisassociateUnconfigBios", "DisassociateUnconfigFlexFlash", "DisassociateUnconfigSoL", "DisassociateUnconfigUuid", "DisassociateVerifyFcZoneConfig", "FwUpgradeActivateAdaptorNwFwLocal", "FwUpgradeActivateAdaptorNwFwPeer", "FwUpgradeActivateBios", "FwUpgradeActivateIBMCFw", "FwUpgradeBegin", "FwUpgradeBiosImgUpdate", "FwUpgradeBiosPostCompletion", "FwUpgradeBladePowerOff", "FwUpgradeBmcConfigPnuOS", "FwUpgradeBmcPreconfigPnuOSLocal", "FwUpgradeBmcPreconfigPnuOSPeer", "FwUpgradeBmcUnconfigPnuOS", "FwUpgradeBootPnuos", "FwUpgradeBootWait", "FwUpgradeClearBiosUpdate", "FwUpgradeDeassertResetBypass", "FwUpgradeFail", "FwUpgradeHagPnuOSConnect", "FwUpgradeHagPnuOSDisconnect", "FwUpgradeHbaImgUpdate", "FwUpgradeLocalDiskFwUpdate", "FwUpgradeNicConfigPnuOSLocal", "FwUpgradeNicConfigPnuOSPeer", "FwUpgradeNicImgUpdate", "FwUpgradeNicUnconfigPnuOSLocal", "FwUpgradeNicUnconfigPnuOSPeer", "FwUpgradePnuOSCatalog", "FwUpgradePnuOSConfig", "FwUpgradePnuOSIdent", "FwUpgradePnuOSInventory", "FwUpgradePnuOSPolicy", "FwUpgradePnuOSSelfTest", "FwUpgradePnuOSUnloadDrivers", "FwUpgradePnuOSValidate", "FwUpgradePollBiosActivateStatus", "FwUpgradePollBiosUpdateStatus", "FwUpgradePollBoardCtrlUpdateStatus", "FwUpgradePollClearBiosUpdateStatus", "FwUpgradePowerOn", "FwUpgradePreSanitize", "FwUpgradeResetIBMC", "FwUpgradeSanitize", "FwUpgradeSerialDebugPnuOSConnect", "FwUpgradeSerialDebugPnuOSDisconnect", "FwUpgradeShutdown", "FwUpgradeSolRedirectDisable", "FwUpgradeSolRedirectEnable", "FwUpgradeStorageCtlrImgUpdate", "FwUpgradeSuccess", "FwUpgradeSwConfigPnuOSLocal", "FwUpgradeSwConfigPnuOSPeer", "FwUpgradeSwConfigPortNivLocal", "FwUpgradeSwConfigPortNivPeer", "FwUpgradeSwUnconfigPnuOSLocal", "FwUpgradeSwUnconfigPnuOSPeer", "FwUpgradeUpdateAdaptorNwFwLocal", "FwUpgradeUpdateAdaptorNwFwPeer", "FwUpgradeUpdateBiosRequest", "FwUpgradeUpdateBoardCtrlRequest", "FwUpgradeUpdateIBMCFw", "FwUpgradeWaitForAdaptorNwFwUpdateLocal", "FwUpgradeWaitForAdaptorNwFwUpdatePeer", "FwUpgradeWaitForIBMCFwUpdate", "HardShutdownBegin", "HardShutdownExecute", "HardShutdownFail", "HardShutdownSuccess", "HardresetBegin", "HardresetExecute", "HardresetFail", "HardresetPreSanitize", "HardresetSanitize", "HardresetSuccess", "PowerCapBegin", "PowerCapConfig", "PowerCapFail", "PowerCapSuccess", "PowercycleBegin", "PowercycleExecute", "PowercycleFail", "PowercyclePreSanitize", "PowercycleSanitize", "PowercycleSuccess", "ResetBmcBegin", "ResetBmcExecute", "ResetBmcFail", "ResetBmcSuccess", "ResetIpmiBegin", "ResetIpmiExecute", "ResetIpmiFail", "ResetIpmiSuccess", "ResetKvmBegin", "ResetKvmExecute", "ResetKvmFail", "ResetKvmSuccess", "ResetMemoryErrorsBegin", "ResetMemoryErrorsExecute", "ResetMemoryErrorsFail", "ResetMemoryErrorsSuccess", "ServiceInfraDeployBegin", "ServiceInfraDeployFail", "ServiceInfraDeployNicConfigLocal", "ServiceInfraDeployNicConfigPeer", "ServiceInfraDeploySuccess", "ServiceInfraDeploySwConfigLocal", "ServiceInfraDeploySwConfigPeer", "ServiceInfraWithdrawBegin", "ServiceInfraWithdrawFail", "ServiceInfraWithdrawNicUnConfigLocal", "ServiceInfraWithdrawNicUnConfigPeer", "ServiceInfraWithdrawSuccess", "ServiceInfraWithdrawSwUnConfigLocal", "ServiceInfraWithdrawSwUnConfigPeer", "SoftShutdownBegin", "SoftShutdownExecute", "SoftShutdownFail", "SoftShutdownSuccess", "SoftresetBegin", "SoftresetExecute", "SoftresetFail", "SoftresetPreSanitize", "SoftresetSanitize", "SoftresetSuccess", "SwConnUpdA", "SwConnUpdB", "SwConnUpdBegin", "SwConnUpdFail", "SwConnUpdSuccess", "TurnupBegin", "TurnupExecute", "TurnupFail", "TurnupSuccess", "UnconfigSoLBegin", "UnconfigSoLExecute", "UnconfigSoLFail", "UnconfigSoLSuccess", "UpdateAdaptorBegin", "UpdateAdaptorFail", "UpdateAdaptorPollUpdateStatusLocal", "UpdateAdaptorPollUpdateStatusPeer", "UpdateAdaptorPowerOff", "UpdateAdaptorPowerOn", "UpdateAdaptorSuccess", "UpdateAdaptorUpdateRequestLocal", "UpdateAdaptorUpdateRequestPeer", "UpdateBIOSBegin", "UpdateBIOSClear", "UpdateBIOSFail", "UpdateBIOSPollClearStatus", "UpdateBIOSPollUpdateStatus", "UpdateBIOSSuccess", "UpdateBIOSUpdateRequest", "UpdateBoardControllerBegin", "UpdateBoardControllerFail", "UpdateBoardControllerPollUpdateStatus", "UpdateBoardControllerPrepareForUpdate", "UpdateBoardControllerServerPowerOff", "UpdateBoardControllerServerPowerOn", "UpdateBoardControllerSuccess", "UpdateBoardControllerUpdateRequest", "nop", "updateExtUsersBegin", "updateExtUsersDeploy", "updateExtUsersFail", "updateExtUsersSuccess"], ["0-4294967295"]),
			"Order":UcsPropertyMeta("Order", "order", "ushort", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"Retry":UcsPropertyMeta("Retry", "retry", "byte", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"StageStatus":UcsPropertyMeta("StageStatus", "stageStatus", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, ["fail", "inProgress", "nop", "pending", "skip", "success", "throttled"], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadWrite, None, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Meta":UcsMoMeta("ComputePhysicalFsmStage", "computePhysicalFsmStage", "stage-[Name]", _VersionMeta.Version211a, "OutputOnly", 0x0L, [], [], [None], [""]),
			},

		"StorageLocalDisk": {
			"BlockSize":UcsPropertyMeta("BlockSize", "blockSize", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, ["unknown"], ["0-4294967295"]),
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"ConnectionProtocol":UcsPropertyMeta("ConnectionProtocol", "connectionProtocol", "string", _VersionMeta.Version131c, UcsPropertyMeta.ReadOnly, None, None, None, None, ["SAS", "SATA", "unspecified"], ["0-4294967295"]),
			"DeviceType":UcsPropertyMeta("DeviceType", "deviceType", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadOnly, None, None, None, None, ["HDD", "SSD", "unspecified"], ["0-4294967295"]),
			"DiskState":UcsPropertyMeta("DiskState", "diskState", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadOnly, None, None, None, None, ["copyback", "dedicated-hot-spare", "disabled-for-removal", "failed", "foreign-configuration", "global-hot-spare", "jbod", "offline", "online", "predictive-failure", "rebuilding", "unconfigured-bad", "unconfigured-good", "unknown"], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x2L, 0, 256, None, [], ["0-4294967295"]),
			"Id":UcsPropertyMeta("Id", "id", "uint", _VersionMeta.Version101e, UcsPropertyMeta.Naming, 0x4L, None, None, None, [], ["0-4294967295"]),
			"Lc":UcsPropertyMeta("Lc", "lc", "string", _VersionMeta.Version202m, UcsPropertyMeta.ReadOnly, None, None, None, None, ["allocated", "available", "deallocated", "repurposed"], ["0-4294967295"]),
			"LinkSpeed":UcsPropertyMeta("LinkSpeed", "linkSpeed", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadOnly, None, None, None, None, ["1-5-gbps", "12-gbps", "3-gbps", "6-gbps", "unknown"], ["0-4294967295"]),
			"Model":UcsPropertyMeta("Model", "model", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, 0, 510, None, [], ["0-4294967295"]),
			"NumberOfBlocks":UcsPropertyMeta("NumberOfBlocks", "numberOfBlocks", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, ["unknown"], ["0-4294967295"]),
			"OperQualifierReason":UcsPropertyMeta("OperQualifierReason", "operQualifierReason", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, """[ !#$%&\(\)\*\+,\-\./:;\?@\[\]_\{\|\}~a-zA-Z0-9]{0,256}""", [], ["0-4294967295"]),
			"Operability":UcsPropertyMeta("Operability", "operability", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, ["accessibility-problem", "auto-upgrade", "bios-post-timeout", "chassis-limit-exceeded", "config", "decomissioning", "degraded", "disabled", "discovery", "discovery-failed", "equipment-problem", "fabric-conn-problem", "fabric-unsupported-conn", "identify", "identity-unestablishable", "inoperable", "link-activate-blocked", "malformed-fru", "not-supported", "operable", "peer-comm-problem", "performance-problem", "post-failure", "power-problem", "powered-off", "removed", "thermal-problem", "unknown", "upgrade-problem", "voltage-problem"], ["0-4294967295"]),
			"PowerState":UcsPropertyMeta("PowerState", "powerState", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadOnly, None, None, None, None, ["active", "powersave", "transitioning", "unknown"], ["0-4294967295"]),
			"Presence":UcsPropertyMeta("Presence", "presence", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, ["empty", "equipped", "equipped-identity-unestablishable", "equipped-not-primary", "equipped-with-malformed-fru", "inaccessible", "mismatch", "mismatch-identity-unestablishable", "missing", "not-supported", "unauthorized", "unknown"], ["0-4294967295"]),
			"Revision":UcsPropertyMeta("Revision", "revision", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, 0, 510, None, [], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x8L, 0, 256, None, [], ["0-4294967295"]),
			"Serial":UcsPropertyMeta("Serial", "serial", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, 0, 510, None, [], ["0-4294967295"]),
			"Size":UcsPropertyMeta("Size", "size", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, ["unknown"], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x10L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Vendor":UcsPropertyMeta("Vendor", "vendor", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, 0, 510, None, [], ["0-4294967295"]),
			"Meta":UcsMoMeta("StorageLocalDisk", "storageLocalDisk", "disk-[Id]", _VersionMeta.Version101e, "InputOutput", 0x1fL, [], [u'faultInst', u'firmwareBootDefinition', u'firmwareRunning', u'storageOperation'], ["Get"], ["read-only"]),
			},

		"VmHv": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version111j, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"ClInstType":UcsPropertyMeta("ClInstType", "clInstType", "string", _VersionMeta.Version201m, UcsPropertyMeta.ReadOnly, None, None, None, None, ["compute-ep", "hv", "vm"], ["0-4294967295"]),
			"Descr":UcsPropertyMeta("Descr", "descr", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadWrite, 0x2L, None, None, """[ !#$%&\(\)\*\+,\-\./:;\?@\[\]_\{\|\}~a-zA-Z0-9]{0,256}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, 0x4L, 0, 256, None, [], ["0-4294967295"]),
			"DvsDn":UcsPropertyMeta("DvsDn", "dvsDn", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"DvsName":UcsPropertyMeta("DvsName", "dvsName", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, """[\-\.:_a-zA-Z0-9]{0,16}""", [], ["0-4294967295"]),
			"FltAggr":UcsPropertyMeta("FltAggr", "fltAggr", "ulong", _VersionMeta.Version111j, UcsPropertyMeta.Internal, None, None, None, None, [], ["0-4294967295"]),
			"HvType":UcsPropertyMeta("HvType", "hvType", "string", _VersionMeta.Version201m, UcsPropertyMeta.ReadOnly, None, None, None, None, ["esx", "hyperv", "kvm", "unspecified", "xen"], ["0-4294967295"]),
			"IntId":UcsPropertyMeta("IntId", "intId", "string", _VersionMeta.Version111j, UcsPropertyMeta.Internal, None, None, None, None, ["none"], ["0-4294967295"]),
			"LsDn":UcsPropertyMeta("LsDn", "lsDn", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"Model":UcsPropertyMeta("Model", "model", "string", _VersionMeta.Version201m, UcsPropertyMeta.ReadOnly, None, None, None, None, ["Linux", "PnuOS", "Solaris", "VMWareESX", "Windows", "unspecified"], ["0-4294967295"]),
			"Name":UcsPropertyMeta("Name", "name", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, """[\-\.:_a-zA-Z0-9]{0,16}""", [], ["0-4294967295"]),
			"PnDn":UcsPropertyMeta("PnDn", "pnDn", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"PolicyLevel":UcsPropertyMeta("PolicyLevel", "policyLevel", "uint", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"PolicyOwner":UcsPropertyMeta("PolicyOwner", "policyOwner", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadWrite, 0x8L, None, None, None, ["local", "pending-policy", "policy"], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, 0x10L, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadWrite, 0x20L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"StatusChangeTs":UcsPropertyMeta("StatusChangeTs", "statusChangeTs", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, """([0-9]){4}-([0-9]){2}-([0-9]){2}T([0-9]){2}:([0-9]){2}:([0-9]){2}((\.([0-9]){3})){0,1}""", [], ["0-4294967295"]),
			"Uuid":UcsPropertyMeta("Uuid", "uuid", "string", _VersionMeta.Version111j, UcsPropertyMeta.Naming, 0x40L, None, None, """(([0-9a-fA-F]){8}\-([0-9a-fA-F]){4}\-([0-9a-fA-F]){4}\-([0-9a-fA-F]){4}\-([0-9a-fA-F]){12})|0""", [], ["0-4294967295"]),
			"VStatus":UcsPropertyMeta("VStatus", "vStatus", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, ["offline", "online", "unknown"], ["0-4294967295"]),
			"Vendor":UcsPropertyMeta("Vendor", "vendor", "string", _VersionMeta.Version201m, UcsPropertyMeta.ReadOnly, None, None, None, None, ["citrix", "microsoft", "novell", "oracle", "redhat", "unspecified", "vmware"], ["0-4294967295"]),
			"Meta":UcsMoMeta("VmHv", "vmHv", "hv-[Uuid]", _VersionMeta.Version111j, "InputOutput", 0x7fL, [], [u'vmHba', u'vmNic'], ["Get"], ["admin", "read-only"]),
			},

		"StorageLocalDiskPartition": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Descr":UcsPropertyMeta("Descr", "descr", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x2L, None, None, """[ !#$%&\(\)\*\+,\-\./:;\?@\[\]_\{\|\}~a-zA-Z0-9]{0,256}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x4L, 0, 256, None, [], ["0-4294967295"]),
			"IntId":UcsPropertyMeta("IntId", "intId", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, None, None, None, None, ["none"], ["0-4294967295"]),
			"Name":UcsPropertyMeta("Name", "name", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x8L, None, None, """[\-\.:_a-zA-Z0-9]{0,16}""", [], ["0-4294967295"]),
			"Order":UcsPropertyMeta("Order", "order", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, ["unspecified"], ["0-4294967295"]),
			"PolicyLevel":UcsPropertyMeta("PolicyLevel", "policyLevel", "uint", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"PolicyOwner":UcsPropertyMeta("PolicyOwner", "policyOwner", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadWrite, 0x10L, None, None, None, ["local", "pending-policy", "policy"], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x20L, 0, 256, None, [], ["0-4294967295"]),
			"Size":UcsPropertyMeta("Size", "size", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x40L, None, None, None, ["unknown"], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x80L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Type":UcsPropertyMeta("Type", "type", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x100L, None, None, None, ["ext2", "ext3", "fat32", "none", "ntfs", "swap"], ["0-4294967295"]),
			"Meta":UcsMoMeta("StorageLocalDiskPartition", "storageLocalDiskPartition", "partition", _VersionMeta.Version101e, "InputOutput", 0x1ffL, [], [], ["Get"], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-storage", "ls-storage-policy"]),
			},

		"MemoryBufferUnit": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version131c, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version131c, UcsPropertyMeta.ReadOnly, 0x2L, 0, 256, None, [], ["0-4294967295"]),
			"Id":UcsPropertyMeta("Id", "id", "uint", _VersionMeta.Version131c, UcsPropertyMeta.Naming, 0x4L, None, None, None, [], ["1-16"]),
			"Model":UcsPropertyMeta("Model", "model", "string", _VersionMeta.Version131c, UcsPropertyMeta.ReadOnly, None, 0, 510, None, [], ["0-4294967295"]),
			"OperQualifierReason":UcsPropertyMeta("OperQualifierReason", "operQualifierReason", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, """[ !#$%&\(\)\*\+,\-\./:;\?@\[\]_\{\|\}~a-zA-Z0-9]{0,256}""", [], ["0-4294967295"]),
			"OperState":UcsPropertyMeta("OperState", "operState", "string", _VersionMeta.Version131c, UcsPropertyMeta.ReadOnly, None, None, None, None, ["accessibility-problem", "auto-upgrade", "bios-post-timeout", "chassis-limit-exceeded", "config", "decomissioning", "degraded", "disabled", "discovery", "discovery-failed", "equipment-problem", "fabric-conn-problem", "fabric-unsupported-conn", "identify", "identity-unestablishable", "inoperable", "link-activate-blocked", "malformed-fru", "not-supported", "operable", "peer-comm-problem", "performance-problem", "post-failure", "power-problem", "powered-off", "removed", "thermal-problem", "unknown", "upgrade-problem", "voltage-problem"], ["0-4294967295"]),
			"Operability":UcsPropertyMeta("Operability", "operability", "string", _VersionMeta.Version131c, UcsPropertyMeta.ReadOnly, None, None, None, None, ["accessibility-problem", "auto-upgrade", "bios-post-timeout", "chassis-limit-exceeded", "config", "decomissioning", "degraded", "disabled", "discovery", "discovery-failed", "equipment-problem", "fabric-conn-problem", "fabric-unsupported-conn", "identify", "identity-unestablishable", "inoperable", "link-activate-blocked", "malformed-fru", "not-supported", "operable", "peer-comm-problem", "performance-problem", "post-failure", "power-problem", "powered-off", "removed", "thermal-problem", "unknown", "upgrade-problem", "voltage-problem"], ["0-4294967295"]),
			"Perf":UcsPropertyMeta("Perf", "perf", "string", _VersionMeta.Version131c, UcsPropertyMeta.ReadOnly, None, None, None, None, ["lower-critical", "lower-non-critical", "lower-non-recoverable", "not-supported", "ok", "unknown", "upper-critical", "upper-non-critical", "upper-non-recoverable"], ["0-4294967295"]),
			"Power":UcsPropertyMeta("Power", "power", "string", _VersionMeta.Version131c, UcsPropertyMeta.ReadOnly, None, None, None, None, ["degraded", "error", "failed", "not-supported", "off", "offduty", "offline", "ok", "on", "online", "power-save", "test", "unknown"], ["0-4294967295"]),
			"Presence":UcsPropertyMeta("Presence", "presence", "string", _VersionMeta.Version131c, UcsPropertyMeta.ReadOnly, None, None, None, None, ["empty", "equipped", "equipped-identity-unestablishable", "equipped-not-primary", "equipped-with-malformed-fru", "inaccessible", "mismatch", "mismatch-identity-unestablishable", "missing", "not-supported", "unauthorized", "unknown"], ["0-4294967295"]),
			"Revision":UcsPropertyMeta("Revision", "revision", "string", _VersionMeta.Version131c, UcsPropertyMeta.ReadOnly, None, 0, 510, None, [], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version131c, UcsPropertyMeta.ReadOnly, 0x8L, 0, 256, None, [], ["0-4294967295"]),
			"Serial":UcsPropertyMeta("Serial", "serial", "string", _VersionMeta.Version131c, UcsPropertyMeta.ReadOnly, None, 0, 510, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version131c, UcsPropertyMeta.ReadWrite, 0x10L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Thermal":UcsPropertyMeta("Thermal", "thermal", "string", _VersionMeta.Version131c, UcsPropertyMeta.ReadOnly, None, None, None, None, ["lower-critical", "lower-non-critical", "lower-non-recoverable", "not-supported", "ok", "unknown", "upper-critical", "upper-non-critical", "upper-non-recoverable"], ["0-4294967295"]),
			"Vendor":UcsPropertyMeta("Vendor", "vendor", "string", _VersionMeta.Version131c, UcsPropertyMeta.ReadOnly, None, 0, 510, None, [], ["0-4294967295"]),
			"Voltage":UcsPropertyMeta("Voltage", "voltage", "string", _VersionMeta.Version131c, UcsPropertyMeta.ReadOnly, None, None, None, None, ["lower-critical", "lower-non-critical", "lower-non-recoverable", "not-supported", "ok", "unknown", "upper-critical", "upper-non-critical", "upper-non-recoverable"], ["0-4294967295"]),
			"Meta":UcsMoMeta("MemoryBufferUnit", "memoryBufferUnit", "sensor-unit-[Id]", _VersionMeta.Version131c, "InputOutput", 0x1fL, [], [u'faultInst', u'memoryBufferUnitEnvStats'], ["Get"], ["read-only"]),
			},

		"MgmtAccessPolicyItem": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Descr":UcsPropertyMeta("Descr", "descr", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x2L, None, None, """[ !#$%&\(\)\*\+,\-\./:;\?@\[\]_\{\|\}~a-zA-Z0-9]{0,256}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x4L, 0, 256, None, [], ["0-4294967295"]),
			"IntId":UcsPropertyMeta("IntId", "intId", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, None, None, None, None, ["none"], ["0-4294967295"]),
			"IpPoolName":UcsPropertyMeta("IpPoolName", "ipPoolName", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, """[\-\.:_a-zA-Z0-9]{0,16}""", [], ["0-4294967295"]),
			"Name":UcsPropertyMeta("Name", "name", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x8L, None, None, """[\-\.:_a-zA-Z0-9]{0,16}""", [], ["0-4294967295"]),
			"PolicyLevel":UcsPropertyMeta("PolicyLevel", "policyLevel", "uint", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"PolicyOwner":UcsPropertyMeta("PolicyOwner", "policyOwner", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadWrite, 0x10L, None, None, None, ["local", "pending-policy", "policy"], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x20L, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x40L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Subject":UcsPropertyMeta("Subject", "subject", "string", _VersionMeta.Version101e, UcsPropertyMeta.Naming, 0x80L, None, None, None, ["adaptor", "blade", "board-controller", "chassis", "iocard", "switch", "system", "unknown"], ["0-4294967295"]),
			"Meta":UcsMoMeta("MgmtAccessPolicyItem", "mgmtAccessPolicyItem", "item-[Subject]", _VersionMeta.Version101e, "InputOutput", 0xffL, [], [u'mgmtAccessPort'], ["Get"], ["read-only"]),
			},

		"BiosVfAssertNMIOnSERR": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version111j, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, 0x2L, 0, 256, None, [], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, 0x4L, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadWrite, 0x8L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"VpAssertNMIOnSERR":UcsPropertyMeta("VpAssertNMIOnSERR", "vpAssertNMIOnSERR", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadWrite, 0x10L, None, None, None, ["disabled", "enabled", "platform-default", "platform-recommended"], ["0-4294967295"]),
			"Meta":UcsMoMeta("BiosVfAssertNMIOnSERR", "biosVfAssertNMIOnSERR", "Assert-NMI-on-SERR", _VersionMeta.Version111j, "InputOutput", 0x1fL, [], [], ["Get", "Set"], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"]),
			},

		"ComputeBoard": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"CmosVoltage":UcsPropertyMeta("CmosVoltage", "cmosVoltage", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, ["lower-critical", "lower-non-critical", "lower-non-recoverable", "not-supported", "ok", "unknown", "upper-critical", "upper-non-critical", "upper-non-recoverable"], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x2L, 0, 256, None, [], ["0-4294967295"]),
			"Id":UcsPropertyMeta("Id", "id", "uint", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"Model":UcsPropertyMeta("Model", "model", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, 0, 510, None, [], ["0-4294967295"]),
			"OperPower":UcsPropertyMeta("OperPower", "operPower", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, ["degraded", "error", "failed", "not-supported", "off", "offduty", "offline", "ok", "on", "online", "power-save", "test", "unknown"], ["0-4294967295"]),
			"OperQualifierReason":UcsPropertyMeta("OperQualifierReason", "operQualifierReason", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, """[ !#$%&\(\)\*\+,\-\./:;\?@\[\]_\{\|\}~a-zA-Z0-9]{0,256}""", [], ["0-4294967295"]),
			"OperState":UcsPropertyMeta("OperState", "operState", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, ["accessibility-problem", "auto-upgrade", "bios-post-timeout", "chassis-limit-exceeded", "config", "decomissioning", "degraded", "disabled", "discovery", "discovery-failed", "equipment-problem", "fabric-conn-problem", "fabric-unsupported-conn", "identify", "identity-unestablishable", "inoperable", "link-activate-blocked", "malformed-fru", "not-supported", "operable", "peer-comm-problem", "performance-problem", "post-failure", "power-problem", "powered-off", "removed", "thermal-problem", "unknown", "upgrade-problem", "voltage-problem"], ["0-4294967295"]),
			"Operability":UcsPropertyMeta("Operability", "operability", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, ["accessibility-problem", "auto-upgrade", "bios-post-timeout", "chassis-limit-exceeded", "config", "decomissioning", "degraded", "disabled", "discovery", "discovery-failed", "equipment-problem", "fabric-conn-problem", "fabric-unsupported-conn", "identify", "identity-unestablishable", "inoperable", "link-activate-blocked", "malformed-fru", "not-supported", "operable", "peer-comm-problem", "performance-problem", "post-failure", "power-problem", "powered-off", "removed", "thermal-problem", "unknown", "upgrade-problem", "voltage-problem"], ["0-4294967295"]),
			"Perf":UcsPropertyMeta("Perf", "perf", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, ["lower-critical", "lower-non-critical", "lower-non-recoverable", "not-supported", "ok", "unknown", "upper-critical", "upper-non-critical", "upper-non-recoverable"], ["0-4294967295"]),
			"Power":UcsPropertyMeta("Power", "power", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, ["degraded", "error", "failed", "not-supported", "off", "offduty", "offline", "ok", "on", "online", "power-save", "test", "unknown"], ["0-4294967295"]),
			"PowerUsage":UcsPropertyMeta("PowerUsage", "powerUsage", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, ["lower-critical", "lower-non-critical", "lower-non-recoverable", "not-supported", "ok", "unknown", "upper-critical", "upper-non-critical", "upper-non-recoverable"], ["0-4294967295"]),
			"Presence":UcsPropertyMeta("Presence", "presence", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, ["empty", "equipped", "equipped-identity-unestablishable", "equipped-not-primary", "equipped-with-malformed-fru", "inaccessible", "mismatch", "mismatch-identity-unestablishable", "missing", "not-supported", "unauthorized", "unknown"], ["0-4294967295"]),
			"Revision":UcsPropertyMeta("Revision", "revision", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, 0, 510, None, [], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x4L, 0, 256, None, [], ["0-4294967295"]),
			"Serial":UcsPropertyMeta("Serial", "serial", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, 0, 510, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x8L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Thermal":UcsPropertyMeta("Thermal", "thermal", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, ["lower-critical", "lower-non-critical", "lower-non-recoverable", "not-supported", "ok", "unknown", "upper-critical", "upper-non-critical", "upper-non-recoverable"], ["0-4294967295"]),
			"Vendor":UcsPropertyMeta("Vendor", "vendor", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, 0, 510, None, [], ["0-4294967295"]),
			"Voltage":UcsPropertyMeta("Voltage", "voltage", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, ["lower-critical", "lower-non-critical", "lower-non-recoverable", "not-supported", "ok", "unknown", "upper-critical", "upper-non-critical", "upper-non-recoverable"], ["0-4294967295"]),
			"Meta":UcsMoMeta("ComputeBoard", "computeBoard", "board", _VersionMeta.Version101e, "InputOutput", 0xfL, [], [u'computeIOHub', u'computeMbPowerStats', u'computeMbTempStats', u'computePCIeFatalCompletionStats', u'computePCIeFatalProtocolStats', u'computePCIeFatalReceiveStats', u'computePCIeFatalStats', u'computeRackUnitMbTempStats', u'computeRtcBattery', u'equipmentTpm', u'faultInst', u'graphicsCard', u'memoryArray', u'memoryBufferUnit', u'processorUnit', u'storageController', u'storageFlexFlashController', u'storageLocalDiskSlotEp'], ["Get"], ["read-only"]),
			},

		"VnicMacHistory": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version212a, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version212a, UcsPropertyMeta.ReadOnly, 0x2L, 0, 256, None, [], ["0-4294967295"]),
			"Oldaddr":UcsPropertyMeta("Oldaddr", "oldaddr", "string", _VersionMeta.Version212a, UcsPropertyMeta.ReadOnly, None, None, None, """(([0-9a-fA-F][0-9a-fA-F]:){5}([0-9a-fA-F][0-9a-fA-F]))|0""", [], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version212a, UcsPropertyMeta.ReadOnly, 0x4L, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version212a, UcsPropertyMeta.ReadWrite, 0x8L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Meta":UcsMoMeta("VnicMacHistory", "vnicMacHistory", "mac-history", _VersionMeta.Version212a, "InputOutput", 0xfL, [], [], [None], ["read-only"]),
			},

		"ComputePhysicalFsm": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version211a, UcsPropertyMeta.Internal, None, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"CompletionTime":UcsPropertyMeta("CompletionTime", "completionTime", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, """([0-9]){4}-([0-9]){2}-([0-9]){2}T([0-9]){2}:([0-9]){2}:([0-9]){2}((\.([0-9]){3})){0,1}""", [""], ["0-4294967295"]),
			"CurrentFsm":UcsPropertyMeta("CurrentFsm", "currentFsm", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, ["ActivateAdaptor", "ActivateBIOS", "Associate", "BiosRecovery", "CimcSessionDelete", "CmosReset", "ConfigBoard", "ConfigSoL", "Decommission", "DiagnosticInterrupt", "Disassociate", "FwUpgrade", "HardShutdown", "Hardreset", "PowerCap", "Powercycle", "ResetBmc", "ResetIpmi", "ResetKvm", "ResetMemoryErrors", "ServiceInfraDeploy", "ServiceInfraWithdraw", "SoftShutdown", "Softreset", "SwConnUpd", "Turnup", "UnconfigSoL", "UpdateAdaptor", "UpdateBIOS", "UpdateBoardController", "nop", "updateExtUsers"], ["0-4294967295"]),
			"Descr":UcsPropertyMeta("Descr", "descr", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, """[ !#$%&\(\)\*\+,\-\./:;\?@\[\]_\{\|\}~a-zA-Z0-9]{0,256}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"FsmStatus":UcsPropertyMeta("FsmStatus", "fsmStatus", "string", _VersionMeta.Version211a, UcsPropertyMeta.Internal, None, None, None, None, ["fail", "inProgress", "nop", "pending", "skip", "success", "throttled"], ["0-4294967295"]),
			"InstanceId":UcsPropertyMeta("InstanceId", "instanceId", "uint", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"Progress":UcsPropertyMeta("Progress", "progress", "byte", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-100"]),
			"RmtErrCode":UcsPropertyMeta("RmtErrCode", "rmtErrCode", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, ["ERR-2fa-auth-retry", "ERR-ACTIVATE-failed", "ERR-ACTIVATE-in-progress", "ERR-ACTIVATE-retry", "ERR-BIOS-TOKENS-OLD-BIOS", "ERR-BIOS-TOKENS-OLD-CIMC", "ERR-BIOS-network-boot-order-not-found", "ERR-BOARDCTRLUPDATE-ignore", "ERR-DIAG-cancelled", "ERR-DIAG-fsm-restarted", "ERR-DIAG-test-failed", "ERR-DNLD-authentication-failure", "ERR-DNLD-hostkey-mismatch", "ERR-DNLD-invalid-image", "ERR-DNLD-no-file", "ERR-DNLD-no-space", "ERR-DNS-delete-error", "ERR-DNS-get-error", "ERR-DNS-set-error", "ERR-Diagnostics-in-progress", "ERR-Diagnostics-memtest-in-progress", "ERR-Diagnostics-network-in-progress", "ERR-FILTER-illegal-format", "ERR-FSM-no-such-state", "ERR-HOST-fru-identity-mismatch", "ERR-HTTP-set-error", "ERR-HTTPS-set-error", "ERR-IBMC-analyze-results", "ERR-IBMC-connect-error", "ERR-IBMC-fru-retrieval-error", "ERR-IBMC-invalid-end-point-config", "ERR-IBMC-results-not-ready", "ERR-MAX-subscriptions-allowed-error", "ERR-MO-CONFIG-child-object-cant-be-configured", "ERR-MO-META-no-such-object-class", "ERR-MO-PROPERTY-no-such-property", "ERR-MO-PROPERTY-value-out-of-range", "ERR-MO-access-denied", "ERR-MO-deletion-rule-violation", "ERR-MO-duplicate-object", "ERR-MO-illegal-containment", "ERR-MO-illegal-creation", "ERR-MO-illegal-iterator-state", "ERR-MO-illegal-object-lifecycle-transition", "ERR-MO-naming-rule-violation", "ERR-MO-object-not-found", "ERR-MO-resource-allocation", "ERR-NTP-delete-error", "ERR-NTP-get-error", "ERR-NTP-set-error", "ERR-POWER-CAP-UNSUPPORTED", "ERR-SERVER-mis-connect", "ERR-SWITCH-invalid-if-config", "ERR-TOKEN-request-denied", "ERR-UNABLE-TO-FETCH-BIOS-SETTINGS", "ERR-UPDATE-failed", "ERR-UPDATE-in-progress", "ERR-UPDATE-retry", "ERR-aaa-config-modify-error", "ERR-acct-realm-set-error", "ERR-admin-passwd-set", "ERR-auth-issue", "ERR-auth-realm-get-error", "ERR-auth-realm-set-error", "ERR-authentication", "ERR-authorization-required", "ERR-cli-session-limit-reached", "ERR-create-keyring", "ERR-create-locale", "ERR-create-role", "ERR-create-user", "ERR-delete-locale", "ERR-delete-role", "ERR-delete-session", "ERR-delete-user", "ERR-efi-Diagnostics--in-progress", "ERR-enable-mgmt-conn", "ERR-ep-set-error", "ERR-get-max-http-user-sessions", "ERR-http-initializing", "ERR-insufficiently-equipped", "ERR-internal-error", "ERR-ldap-delete-error", "ERR-ldap-get-error", "ERR-ldap-group-modify-error", "ERR-ldap-group-set-error", "ERR-ldap-set-error", "ERR-locale-set-error", "ERR-max-userid-sessions-reached", "ERR-missing-method", "ERR-modify-locale", "ERR-modify-role", "ERR-modify-user", "ERR-modify-user-locale", "ERR-modify-user-role", "ERR-provider-group-modify-error", "ERR-provider-group-set-error", "ERR-radius-get-error", "ERR-radius-global-set-error", "ERR-radius-group-set-error", "ERR-radius-set-error", "ERR-request-timeout", "ERR-reset-adapter", "ERR-role-set-error", "ERR-secondary-node", "ERR-service-not-ready", "ERR-session-cache-full", "ERR-session-not-found", "ERR-set-network", "ERR-set-password-strength-check", "ERR-set-port-channel", "ERR-store-pre-login-banner-msg", "ERR-tacacs-enable-error", "ERR-tacacs-global-set-error", "ERR-tacacs-group-set-error", "ERR-tacacs-plus-get-error", "ERR-tacacs-set-error", "ERR-test-error-1", "ERR-test-error-2", "ERR-timezone-set-error", "ERR-user-account-expired", "ERR-user-set-error", "ERR-xml-parse-error", "none"], ["0-4294967295"]),
			"RmtErrDescr":UcsPropertyMeta("RmtErrDescr", "rmtErrDescr", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, 0, 510, None, [], ["0-4294967295"]),
			"RmtRslt":UcsPropertyMeta("RmtRslt", "rmtRslt", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, """((defaultValue|not-applicable|resource-unavailable|service-unavailable|intermittent-error|sw-defect|service-not-implemented-ignore|extend-timeout|capability-not-implemented-failure|illegal-fru|end-point-unavailable|failure|resource-capacity-exceeded|service-protocol-error|fw-defect|service-not-implemented-fail|task-reset|unidentified-fail|capability-not-supported|end-point-failed|fru-state-indeterminate|resource-dependency|fru-identity-indeterminate|internal-error|hw-defect|service-not-supported|fru-not-supported|end-point-protocol-error|capability-unavailable|fru-not-ready|capability-not-implemented-ignore|fru-info-malformed|timeout),){0,32}(defaultValue|not-applicable|resource-unavailable|service-unavailable|intermittent-error|sw-defect|service-not-implemented-ignore|extend-timeout|capability-not-implemented-failure|illegal-fru|end-point-unavailable|failure|resource-capacity-exceeded|service-protocol-error|fw-defect|service-not-implemented-fail|task-reset|unidentified-fail|capability-not-supported|end-point-failed|fru-state-indeterminate|resource-dependency|fru-identity-indeterminate|internal-error|hw-defect|service-not-supported|fru-not-supported|end-point-protocol-error|capability-unavailable|fru-not-ready|capability-not-implemented-ignore|fru-info-malformed|timeout){0,1}""", [], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadWrite, None, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Meta":UcsMoMeta("ComputePhysicalFsm", "computePhysicalFsm", "fsm", _VersionMeta.Version211a, "OutputOnly", 0x0L, [], [u'computePhysicalFsmStage'], [None], [""]),
			},

		"MgmtExportPolicyFsm": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version211a, UcsPropertyMeta.Internal, None, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"CompletionTime":UcsPropertyMeta("CompletionTime", "completionTime", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, """([0-9]){4}-([0-9]){2}-([0-9]){2}T([0-9]){2}:([0-9]){2}:([0-9]){2}((\.([0-9]){3})){0,1}""", [""], ["0-4294967295"]),
			"CurrentFsm":UcsPropertyMeta("CurrentFsm", "currentFsm", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, ["ReportConfigCopy", "nop"], ["0-4294967295"]),
			"Descr":UcsPropertyMeta("Descr", "descr", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, """[ !#$%&\(\)\*\+,\-\./:;\?@\[\]_\{\|\}~a-zA-Z0-9]{0,256}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"FsmStatus":UcsPropertyMeta("FsmStatus", "fsmStatus", "string", _VersionMeta.Version211a, UcsPropertyMeta.Internal, None, None, None, None, ["fail", "inProgress", "nop", "pending", "skip", "success", "throttled"], ["0-4294967295"]),
			"InstanceId":UcsPropertyMeta("InstanceId", "instanceId", "uint", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"Progress":UcsPropertyMeta("Progress", "progress", "byte", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-100"]),
			"RmtErrCode":UcsPropertyMeta("RmtErrCode", "rmtErrCode", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, ["ERR-2fa-auth-retry", "ERR-ACTIVATE-failed", "ERR-ACTIVATE-in-progress", "ERR-ACTIVATE-retry", "ERR-BIOS-TOKENS-OLD-BIOS", "ERR-BIOS-TOKENS-OLD-CIMC", "ERR-BIOS-network-boot-order-not-found", "ERR-BOARDCTRLUPDATE-ignore", "ERR-DIAG-cancelled", "ERR-DIAG-fsm-restarted", "ERR-DIAG-test-failed", "ERR-DNLD-authentication-failure", "ERR-DNLD-hostkey-mismatch", "ERR-DNLD-invalid-image", "ERR-DNLD-no-file", "ERR-DNLD-no-space", "ERR-DNS-delete-error", "ERR-DNS-get-error", "ERR-DNS-set-error", "ERR-Diagnostics-in-progress", "ERR-Diagnostics-memtest-in-progress", "ERR-Diagnostics-network-in-progress", "ERR-FILTER-illegal-format", "ERR-FSM-no-such-state", "ERR-HOST-fru-identity-mismatch", "ERR-HTTP-set-error", "ERR-HTTPS-set-error", "ERR-IBMC-analyze-results", "ERR-IBMC-connect-error", "ERR-IBMC-fru-retrieval-error", "ERR-IBMC-invalid-end-point-config", "ERR-IBMC-results-not-ready", "ERR-MAX-subscriptions-allowed-error", "ERR-MO-CONFIG-child-object-cant-be-configured", "ERR-MO-META-no-such-object-class", "ERR-MO-PROPERTY-no-such-property", "ERR-MO-PROPERTY-value-out-of-range", "ERR-MO-access-denied", "ERR-MO-deletion-rule-violation", "ERR-MO-duplicate-object", "ERR-MO-illegal-containment", "ERR-MO-illegal-creation", "ERR-MO-illegal-iterator-state", "ERR-MO-illegal-object-lifecycle-transition", "ERR-MO-naming-rule-violation", "ERR-MO-object-not-found", "ERR-MO-resource-allocation", "ERR-NTP-delete-error", "ERR-NTP-get-error", "ERR-NTP-set-error", "ERR-POWER-CAP-UNSUPPORTED", "ERR-SERVER-mis-connect", "ERR-SWITCH-invalid-if-config", "ERR-TOKEN-request-denied", "ERR-UNABLE-TO-FETCH-BIOS-SETTINGS", "ERR-UPDATE-failed", "ERR-UPDATE-in-progress", "ERR-UPDATE-retry", "ERR-aaa-config-modify-error", "ERR-acct-realm-set-error", "ERR-admin-passwd-set", "ERR-auth-issue", "ERR-auth-realm-get-error", "ERR-auth-realm-set-error", "ERR-authentication", "ERR-authorization-required", "ERR-cli-session-limit-reached", "ERR-create-keyring", "ERR-create-locale", "ERR-create-role", "ERR-create-user", "ERR-delete-locale", "ERR-delete-role", "ERR-delete-session", "ERR-delete-user", "ERR-efi-Diagnostics--in-progress", "ERR-enable-mgmt-conn", "ERR-ep-set-error", "ERR-get-max-http-user-sessions", "ERR-http-initializing", "ERR-insufficiently-equipped", "ERR-internal-error", "ERR-ldap-delete-error", "ERR-ldap-get-error", "ERR-ldap-group-modify-error", "ERR-ldap-group-set-error", "ERR-ldap-set-error", "ERR-locale-set-error", "ERR-max-userid-sessions-reached", "ERR-missing-method", "ERR-modify-locale", "ERR-modify-role", "ERR-modify-user", "ERR-modify-user-locale", "ERR-modify-user-role", "ERR-provider-group-modify-error", "ERR-provider-group-set-error", "ERR-radius-get-error", "ERR-radius-global-set-error", "ERR-radius-group-set-error", "ERR-radius-set-error", "ERR-request-timeout", "ERR-reset-adapter", "ERR-role-set-error", "ERR-secondary-node", "ERR-service-not-ready", "ERR-session-cache-full", "ERR-session-not-found", "ERR-set-network", "ERR-set-password-strength-check", "ERR-set-port-channel", "ERR-store-pre-login-banner-msg", "ERR-tacacs-enable-error", "ERR-tacacs-global-set-error", "ERR-tacacs-group-set-error", "ERR-tacacs-plus-get-error", "ERR-tacacs-set-error", "ERR-test-error-1", "ERR-test-error-2", "ERR-timezone-set-error", "ERR-user-account-expired", "ERR-user-set-error", "ERR-xml-parse-error", "none"], ["0-4294967295"]),
			"RmtErrDescr":UcsPropertyMeta("RmtErrDescr", "rmtErrDescr", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, 0, 510, None, [], ["0-4294967295"]),
			"RmtRslt":UcsPropertyMeta("RmtRslt", "rmtRslt", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, """((defaultValue|not-applicable|resource-unavailable|service-unavailable|intermittent-error|sw-defect|service-not-implemented-ignore|extend-timeout|capability-not-implemented-failure|illegal-fru|end-point-unavailable|failure|resource-capacity-exceeded|service-protocol-error|fw-defect|service-not-implemented-fail|task-reset|unidentified-fail|capability-not-supported|end-point-failed|fru-state-indeterminate|resource-dependency|fru-identity-indeterminate|internal-error|hw-defect|service-not-supported|fru-not-supported|end-point-protocol-error|capability-unavailable|fru-not-ready|capability-not-implemented-ignore|fru-info-malformed|timeout),){0,32}(defaultValue|not-applicable|resource-unavailable|service-unavailable|intermittent-error|sw-defect|service-not-implemented-ignore|extend-timeout|capability-not-implemented-failure|illegal-fru|end-point-unavailable|failure|resource-capacity-exceeded|service-protocol-error|fw-defect|service-not-implemented-fail|task-reset|unidentified-fail|capability-not-supported|end-point-failed|fru-state-indeterminate|resource-dependency|fru-identity-indeterminate|internal-error|hw-defect|service-not-supported|fru-not-supported|end-point-protocol-error|capability-unavailable|fru-not-ready|capability-not-implemented-ignore|fru-info-malformed|timeout){0,1}""", [], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadWrite, None, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Meta":UcsMoMeta("MgmtExportPolicyFsm", "mgmtExportPolicyFsm", "fsm", _VersionMeta.Version211a, "OutputOnly", 0x0L, [], [u'mgmtExportPolicyFsmStage'], [None], [""]),
			},

		"AdaptorFcPortProfile": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x2L, 0, 256, None, [], ["0-4294967295"]),
			"IoThrottleCount":UcsPropertyMeta("IoThrottleCount", "ioThrottleCount", "uint", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x4L, None, None, None, [], ["1-1024"]),
			"LunsPerTarget":UcsPropertyMeta("LunsPerTarget", "lunsPerTarget", "uint", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x8L, None, None, None, [], ["1-1024"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x10L, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x20L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Meta":UcsMoMeta("AdaptorFcPortProfile", "adaptorFcPortProfile", "fc-port", _VersionMeta.Version101e, "InputOutput", 0x3fL, [], [], ["Get", "Set"], ["admin", "ls-config-policy", "ls-server-policy", "ls-storage"]),
			},

		"EtherPortChanIdUniverse": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version201m, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version201m, UcsPropertyMeta.ReadOnly, 0x2L, 0, 256, None, [], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version201m, UcsPropertyMeta.ReadOnly, 0x4L, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version201m, UcsPropertyMeta.ReadWrite, 0x8L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Meta":UcsMoMeta("EtherPortChanIdUniverse", "etherPortChanIdUniverse", "pchanid-universe", _VersionMeta.Version201m, "InputOutput", 0xfL, [], [u'etherPortChanIdElem'], ["Get"], ["read-only"]),
			},

		"FirmwareDistributableFsmStage": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version211a, UcsPropertyMeta.Internal, None, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Descr":UcsPropertyMeta("Descr", "descr", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, """[ !#$%&\(\)\*\+,\-\./:;\?@\[\]_\{\|\}~a-zA-Z0-9]{0,256}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"LastUpdateTime":UcsPropertyMeta("LastUpdateTime", "lastUpdateTime", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, """([0-9]){4}-([0-9]){2}-([0-9]){2}T([0-9]){2}:([0-9]){2}:([0-9]){2}((\.([0-9]){3})){0,1}""", [""], ["0-4294967295"]),
			"Name":UcsPropertyMeta("Name", "name", "string", _VersionMeta.Version211a, UcsPropertyMeta.Naming, None, None, None, None, ["DeleteBegin", "DeleteFail", "DeleteLocal", "DeleteRemote", "DeleteSuccess", "nop"], ["0-4294967295"]),
			"Order":UcsPropertyMeta("Order", "order", "ushort", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"Retry":UcsPropertyMeta("Retry", "retry", "byte", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"StageStatus":UcsPropertyMeta("StageStatus", "stageStatus", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, ["fail", "inProgress", "nop", "pending", "skip", "success", "throttled"], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadWrite, None, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Meta":UcsMoMeta("FirmwareDistributableFsmStage", "firmwareDistributableFsmStage", "stage-[Name]", _VersionMeta.Version211a, "OutputOnly", 0x0L, [], [], [None], [""]),
			},

		"OsAgent": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x2L, 0, 256, None, [], ["0-4294967295"]),
			"LastCmd":UcsPropertyMeta("LastCmd", "lastCmd", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, ["none"], ["0-4294967295"]),
			"LastEvt":UcsPropertyMeta("LastEvt", "lastEvt", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, ["none"], ["0-4294967295"]),
			"LastEvtTs":UcsPropertyMeta("LastEvtTs", "lastEvtTs", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, """([0-9]){4}-([0-9]){2}-([0-9]){2}T([0-9]){2}:([0-9]){2}:([0-9]){2}((\.([0-9]){3})){0,1}""", [], ["0-4294967295"]),
			"PrevCmd":UcsPropertyMeta("PrevCmd", "prevCmd", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, ["none"], ["0-4294967295"]),
			"PrevEvt":UcsPropertyMeta("PrevEvt", "prevEvt", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, ["none"], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x4L, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x8L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Type":UcsPropertyMeta("Type", "type", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, ["hostAgent", "indeterminate", "pnuosAgent"], ["0-4294967295"]),
			"Vendor":UcsPropertyMeta("Vendor", "vendor", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, 0, 510, None, [], ["0-4294967295"]),
			"Version":UcsPropertyMeta("Version", "version", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, 0, 510, None, [], ["0-4294967295"]),
			"Meta":UcsMoMeta("OsAgent", "osAgent", "agent", _VersionMeta.Version101e, "InputOutput", 0xfL, [], [], ["Get"], ["read-only"]),
			},

		"EquipmentPortGroupAggregationDef": {
			"AggregationCap":UcsPropertyMeta("AggregationCap", "aggregationCap", "string", _VersionMeta.Version201m, UcsPropertyMeta.ReadOnly, None, None, None, """((defaultValue|none|port-channel),){0,2}(defaultValue|none|port-channel){0,1}""", [], ["0-4294967295"]),
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version201m, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Descr":UcsPropertyMeta("Descr", "descr", "string", _VersionMeta.Version201m, UcsPropertyMeta.ReadWrite, 0x2L, None, None, """[ !#$%&\(\)\*\+,\-\./:;\?@\[\]_\{\|\}~a-zA-Z0-9]{0,256}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version201m, UcsPropertyMeta.ReadOnly, 0x4L, 0, 256, None, [], ["0-4294967295"]),
			"IntId":UcsPropertyMeta("IntId", "intId", "string", _VersionMeta.Version201m, UcsPropertyMeta.Internal, None, None, None, None, ["none"], ["0-4294967295"]),
			"Name":UcsPropertyMeta("Name", "name", "string", _VersionMeta.Version201m, UcsPropertyMeta.ReadWrite, 0x8L, None, None, """[\-\.:_a-zA-Z0-9]{0,16}""", [], ["0-4294967295"]),
			"PolicyLevel":UcsPropertyMeta("PolicyLevel", "policyLevel", "uint", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"PolicyOwner":UcsPropertyMeta("PolicyOwner", "policyOwner", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadWrite, 0x10L, None, None, None, ["local", "pending-policy", "policy"], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version201m, UcsPropertyMeta.ReadOnly, 0x20L, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version201m, UcsPropertyMeta.ReadWrite, 0x40L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Type":UcsPropertyMeta("Type", "type", "string", _VersionMeta.Version201m, UcsPropertyMeta.Naming, 0x80L, None, None, None, ["adaptor-ext", "adaptor-pc", "fabric", "fabric-pc", "host", "host-pc", "server-pc", "switch-ether", "switch-fc"], ["0-4294967295"]),
			"Meta":UcsMoMeta("EquipmentPortGroupAggregationDef", "equipmentPortGroupAggregationDef", "port-group-aggr-def-[Type]", _VersionMeta.Version201m, "InputOutput", 0xffL, [], [], ["Get"], [""]),
			},

		"VnicIpV6MgmtPooledAddr": {
			"Addr":UcsPropertyMeta("Addr", "addr", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version221b, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"DefGw":UcsPropertyMeta("DefGw", "defGw", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadOnly, 0x2L, 0, 256, None, [], ["0-4294967295"]),
			"Name":UcsPropertyMeta("Name", "name", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadWrite, 0x4L, None, None, None, [], ["0-4294967295"]),
			"OperName":UcsPropertyMeta("OperName", "operName", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"Prefix":UcsPropertyMeta("Prefix", "prefix", "byte", _VersionMeta.Version221b, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["1-127"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadOnly, 0x8L, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadWrite, 0x10L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Meta":UcsMoMeta("VnicIpV6MgmtPooledAddr", "vnicIpV6MgmtPooledAddr", "ipv6-pooled-addr", _VersionMeta.Version221b, "InputOutput", 0x1fL, [], [u'faultInst', u'vnicIpV6History'], ["Add", "Get", "Remove", "Set"], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server"]),
			},

		"SysdebugLogControlDestinationSyslog": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"DefaultLevel":UcsPropertyMeta("DefaultLevel", "defaultLevel", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x2L, None, None, None, ["crit", "debug0", "debug1", "debug2", "debug3", "debug4", "info", "major", "minor", "warn"], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x4L, 0, 256, None, [], ["0-4294967295"]),
			"Level":UcsPropertyMeta("Level", "level", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x8L, None, None, None, ["crit", "debug0", "debug1", "debug2", "debug3", "debug4", "info", "major", "minor", "warn"], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x10L, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x20L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Meta":UcsMoMeta("SysdebugLogControlDestinationSyslog", "sysdebugLogControlDestinationSyslog", "syslog", _VersionMeta.Version101e, "InputOutput", 0x3fL, [], [], ["Get"], ["admin", "operations"]),
			},

		"VnicRackServerDiscoveryProfile": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version211a, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Descr":UcsPropertyMeta("Descr", "descr", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadWrite, 0x2L, None, None, """[ !#$%&\(\)\*\+,\-\./:;\?@\[\]_\{\|\}~a-zA-Z0-9]{0,256}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, 0x4L, 0, 256, None, [], ["0-4294967295"]),
			"IntId":UcsPropertyMeta("IntId", "intId", "string", _VersionMeta.Version211a, UcsPropertyMeta.Internal, None, None, None, None, ["none"], ["0-4294967295"]),
			"MaxPorts":UcsPropertyMeta("MaxPorts", "maxPorts", "ushort", _VersionMeta.Version211a, UcsPropertyMeta.ReadWrite, 0x8L, None, None, None, [], ["1-4096"]),
			"Name":UcsPropertyMeta("Name", "name", "string", _VersionMeta.Version211a, UcsPropertyMeta.Naming, 0x10L, None, None, """[\-\.:_a-zA-Z0-9]{1,80}""", [], ["0-4294967295"]),
			"PolicyLevel":UcsPropertyMeta("PolicyLevel", "policyLevel", "uint", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"PolicyOwner":UcsPropertyMeta("PolicyOwner", "policyOwner", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadWrite, 0x20L, None, None, None, ["local", "pending-policy", "policy"], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, 0x40L, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadWrite, 0x80L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Meta":UcsMoMeta("VnicRackServerDiscoveryProfile", "vnicRackServerDiscoveryProfile", "vnic-[Name]", _VersionMeta.Version211a, "InputOutput", 0xffL, [], [u'swVlan'], [None], ["read-only"]),
			},

		"BiosVfPOSTErrorPause": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version111j, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, 0x2L, 0, 256, None, [], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, 0x4L, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadWrite, 0x8L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"VpPOSTErrorPause":UcsPropertyMeta("VpPOSTErrorPause", "vpPOSTErrorPause", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadWrite, 0x10L, None, None, None, ["disabled", "enabled", "platform-default", "platform-recommended"], ["0-4294967295"]),
			"Meta":UcsMoMeta("BiosVfPOSTErrorPause", "biosVfPOSTErrorPause", "POST-error-pause", _VersionMeta.Version111j, "InputOutput", 0x1fL, [], [], ["Get", "Set"], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"]),
			},

		"FabricPooledVlan": {
			"Assigned":UcsPropertyMeta("Assigned", "assigned", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, ["false", "no", "true", "yes"], ["0-4294967295"]),
			"AssignedToDn":UcsPropertyMeta("AssignedToDn", "assignedToDn", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version211a, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"ConfigIssues":UcsPropertyMeta("ConfigIssues", "configIssues", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadOnly, None, None, None, """((defaultValue|not-applicable|named-vlan-unresolved),){0,2}(defaultValue|not-applicable|named-vlan-unresolved){0,1}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, 0x2L, 0, 256, None, [], ["0-4294967295"]),
			"Name":UcsPropertyMeta("Name", "name", "string", _VersionMeta.Version211a, UcsPropertyMeta.Naming, 0x4L, 1, 510, None, [], ["0-4294967295"]),
			"PeerDn":UcsPropertyMeta("PeerDn", "peerDn", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"PoolableDn":UcsPropertyMeta("PoolableDn", "poolableDn", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"PrevAssignedToDn":UcsPropertyMeta("PrevAssignedToDn", "prevAssignedToDn", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, 0x8L, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadWrite, 0x10L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Meta":UcsMoMeta("FabricPooledVlan", "fabricPooledVlan", "net-[Name]", _VersionMeta.Version211a, "InputOutput", 0x1fL, [], [u'faultInst'], ["Add", "Get", "Remove"], ["admin", "ext-lan-config", "ext-lan-policy"]),
			},

		"GmetaProp": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version212a, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version212a, UcsPropertyMeta.ReadOnly, 0x2L, 0, 256, None, [], ["0-4294967295"]),
			"Name":UcsPropertyMeta("Name", "name", "string", _VersionMeta.Version212a, UcsPropertyMeta.CreateOnly, 0x4L, 0, 510, None, [], ["0-4294967295"]),
			"Order":UcsPropertyMeta("Order", "order", "byte", _VersionMeta.Version212a, UcsPropertyMeta.Naming, 0x8L, None, None, None, [], ["0-4294967295"]),
			"PropId":UcsPropertyMeta("PropId", "propId", "string", _VersionMeta.Version212a, UcsPropertyMeta.ReadOnly, None, None, None, None, ["aaa_AuthMethod_descr", "aaa_AuthMethod_name", "aaa_AuthMethod_operProviderGroup", "aaa_AuthMethod_operRealm", "aaa_AuthMethod_providerGroup", "aaa_AuthMethod_realm", "aaa_AuthMethod_use2Factor", "aaa_AuthRealmFsmStage_descr", "aaa_AuthRealmFsmStage_lastUpdateTime", "aaa_AuthRealmFsmStage_name", "aaa_AuthRealmFsmStage_order", "aaa_AuthRealmFsmStage_retry", "aaa_AuthRealmFsmStage_stageStatus", "aaa_AuthRealmFsm_completionTime", "aaa_AuthRealmFsm_currentFsm", "aaa_AuthRealmFsm_descr", "aaa_AuthRealmFsm_fsmStatus", "aaa_AuthRealmFsm_instanceId", "aaa_AuthRealmFsm_progress", "aaa_AuthRealmFsm_rmtErrCode", "aaa_AuthRealmFsm_rmtErrDescr", "aaa_AuthRealmFsm_rmtRslt", "aaa_AuthRealm_conLogin", "aaa_AuthRealm_defLogin", "aaa_AuthRealm_defRolePolicy", "aaa_AuthRealm_descr", "aaa_AuthRealm_fsmDescr", "aaa_AuthRealm_fsmPrev", "aaa_AuthRealm_fsmProgr", "aaa_AuthRealm_fsmRmtInvErrCode", "aaa_AuthRealm_fsmRmtInvErrDescr", "aaa_AuthRealm_fsmRmtInvRslt", "aaa_AuthRealm_fsmStageDescr", "aaa_AuthRealm_fsmStamp", "aaa_AuthRealm_fsmStatus", "aaa_AuthRealm_fsmTry", "aaa_AuthRealm_intId", "aaa_AuthRealm_name", "aaa_AuthRealm_policyLevel", "aaa_AuthRealm_policyOwner", "aaa_Banner_descr", "aaa_Banner_intId", "aaa_Banner_message", "aaa_Banner_name", "aaa_Banner_policyLevel", "aaa_Banner_policyOwner", "aaa_CimcSession_adminState", "aaa_CimcSession_cimcAddr", "aaa_CimcSession_id", "aaa_CimcSession_intDel", "aaa_CimcSession_isDelete", "aaa_CimcSession_lastUpdatedTime", "aaa_CimcSession_loginTime", "aaa_CimcSession_lsDn", "aaa_CimcSession_pid", "aaa_CimcSession_pnDn", "aaa_CimcSession_priv", "aaa_CimcSession_sourceAddr", "aaa_CimcSession_type", "aaa_CimcSession_user", "aaa_Config_descr", "aaa_Config_name", "aaa_Config_operProviderGroup", "aaa_Config_operRealm", "aaa_Config_providerGroup", "aaa_Config_realm", "aaa_Config_use2Factor", "aaa_ConsoleAuth_descr", "aaa_ConsoleAuth_name", "aaa_ConsoleAuth_operProviderGroup", "aaa_ConsoleAuth_operRealm", "aaa_ConsoleAuth_providerGroup", "aaa_ConsoleAuth_realm", "aaa_ConsoleAuth_use2Factor", "aaa_DefaultAuth_descr", "aaa_DefaultAuth_name", "aaa_DefaultAuth_operProviderGroup", "aaa_DefaultAuth_operRealm", "aaa_DefaultAuth_providerGroup", "aaa_DefaultAuth_realm", "aaa_DefaultAuth_refreshPeriod", "aaa_DefaultAuth_sessionTimeout", "aaa_DefaultAuth_use2Factor", "aaa_Definition_descr", "aaa_Definition_intId", "aaa_Definition_name", "aaa_Definition_policyLevel", "aaa_Definition_policyOwner", "aaa_DomainAuth_descr", "aaa_DomainAuth_name", "aaa_DomainAuth_operProviderGroup", "aaa_DomainAuth_operRealm", "aaa_DomainAuth_providerGroup", "aaa_DomainAuth_realm", "aaa_DomainAuth_use2Factor", "aaa_Domain_descr", "aaa_Domain_name", "aaa_Domain_refreshPeriod", "aaa_Domain_sessionTimeout", "aaa_EpAuthProfile_descr", "aaa_EpAuthProfile_intId", "aaa_EpAuthProfile_name", "aaa_EpAuthProfile_policyLevel", "aaa_EpAuthProfile_policyOwner", "aaa_EpFsmStage_descr", "aaa_EpFsmStage_lastUpdateTime", "aaa_EpFsmStage_name", "aaa_EpFsmStage_order", "aaa_EpFsmStage_retry", "aaa_EpFsmStage_stageStatus", "aaa_EpFsmTask_completion", "aaa_EpFsmTask_flags", "aaa_EpFsmTask_item", "aaa_EpFsmTask_seqId", "aaa_EpFsm_completionTime", "aaa_EpFsm_currentFsm", "aaa_EpFsm_descr", "aaa_EpFsm_fsmStatus", "aaa_EpFsm_instanceId", "aaa_EpFsm_progress", "aaa_EpFsm_rmtErrCode", "aaa_EpFsm_rmtErrDescr", "aaa_EpFsm_rmtRslt", "aaa_EpLogin_descr", "aaa_EpLogin_id", "aaa_EpLogin_intId", "aaa_EpLogin_localHost", "aaa_EpLogin_name", "aaa_EpLogin_policyLevel", "aaa_EpLogin_policyOwner", "aaa_EpLogin_remoteHost", "aaa_EpLogin_session", "aaa_EpLogin_switchId", "aaa_EpUser_configState", "aaa_EpUser_configStatusMessage", "aaa_EpUser_descr", "aaa_EpUser_name", "aaa_EpUser_priv", "aaa_EpUser_pwd", "aaa_EpUser_pwdSet", "aaa_Ep_descr", "aaa_Ep_fsmDescr", "aaa_Ep_fsmPrev", "aaa_Ep_fsmProgr", "aaa_Ep_fsmRmtInvErrCode", "aaa_Ep_fsmRmtInvErrDescr", "aaa_Ep_fsmRmtInvRslt", "aaa_Ep_fsmStageDescr", "aaa_Ep_fsmStamp", "aaa_Ep_fsmStatus", "aaa_Ep_fsmTry", "aaa_Ep_intId", "aaa_Ep_name", "aaa_Ep_policyLevel", "aaa_Ep_policyOwner", "aaa_Ep_retries", "aaa_Ep_timeout", "aaa_ExtMgmtCutThruTkn_authDomain", "aaa_ExtMgmtCutThruTkn_authUser", "aaa_ExtMgmtCutThruTkn_creationTime", "aaa_ExtMgmtCutThruTkn_descr", "aaa_ExtMgmtCutThruTkn_intId", "aaa_ExtMgmtCutThruTkn_locales", "aaa_ExtMgmtCutThruTkn_name", "aaa_ExtMgmtCutThruTkn_pnDn", "aaa_ExtMgmtCutThruTkn_policyLevel", "aaa_ExtMgmtCutThruTkn_policyOwner", "aaa_ExtMgmtCutThruTkn_priv", "aaa_ExtMgmtCutThruTkn_remote", "aaa_ExtMgmtCutThruTkn_token", "aaa_ExtMgmtCutThruTkn_type", "aaa_ExtMgmtCutThruTkn_user", "aaa_Item_descr", "aaa_Item_name", "aaa_LdapEpFsmStage_descr", "aaa_LdapEpFsmStage_lastUpdateTime", "aaa_LdapEpFsmStage_name", "aaa_LdapEpFsmStage_order", "aaa_LdapEpFsmStage_retry", "aaa_LdapEpFsmStage_stageStatus", "aaa_LdapEpFsm_completionTime", "aaa_LdapEpFsm_currentFsm", "aaa_LdapEpFsm_descr", "aaa_LdapEpFsm_fsmStatus", "aaa_LdapEpFsm_instanceId", "aaa_LdapEpFsm_progress", "aaa_LdapEpFsm_rmtErrCode", "aaa_LdapEpFsm_rmtErrDescr", "aaa_LdapEpFsm_rmtRslt", "aaa_LdapEp_attribute", "aaa_LdapEp_basedn", "aaa_LdapEp_descr", "aaa_LdapEp_filter", "aaa_LdapEp_fsmDescr", "aaa_LdapEp_fsmPrev", "aaa_LdapEp_fsmProgr", "aaa_LdapEp_fsmRmtInvErrCode", "aaa_LdapEp_fsmRmtInvErrDescr", "aaa_LdapEp_fsmRmtInvRslt", "aaa_LdapEp_fsmStageDescr", "aaa_LdapEp_fsmStamp", "aaa_LdapEp_fsmStatus", "aaa_LdapEp_fsmTry", "aaa_LdapEp_intId", "aaa_LdapEp_name", "aaa_LdapEp_policyLevel", "aaa_LdapEp_policyOwner", "aaa_LdapEp_retries", "aaa_LdapEp_timeout", "aaa_LdapGroupRule_authorization", "aaa_LdapGroupRule_descr", "aaa_LdapGroupRule_name", "aaa_LdapGroupRule_targetAttr", "aaa_LdapGroupRule_traversal", "aaa_LdapGroupRule_usePrimaryGroup", "aaa_LdapGroup_descr", "aaa_LdapGroup_name", "aaa_LdapProvider_attribute", "aaa_LdapProvider_basedn", "aaa_LdapProvider_descr", "aaa_LdapProvider_enableSSL", "aaa_LdapProvider_encKey", "aaa_LdapProvider_filter", "aaa_LdapProvider_key", "aaa_LdapProvider_keySet", "aaa_LdapProvider_name", "aaa_LdapProvider_order", "aaa_LdapProvider_port", "aaa_LdapProvider_retries", "aaa_LdapProvider_rootdn", "aaa_LdapProvider_timeout", "aaa_LdapProvider_vendor", "aaa_Locale_configState", "aaa_Locale_configStatusMessage", "aaa_Locale_descr", "aaa_Locale_intId", "aaa_Locale_name", "aaa_Locale_policyLevel", "aaa_Locale_policyOwner", "aaa_Log_maxSize", "aaa_Log_purgeWindow", "aaa_Log_size", "aaa_ModLR_affected", "aaa_ModLR_cause", "aaa_ModLR_changeSet", "aaa_ModLR_code", "aaa_ModLR_created", "aaa_ModLR_descr", "aaa_ModLR_id", "aaa_ModLR_ind", "aaa_ModLR_sessionId", "aaa_ModLR_severity", "aaa_ModLR_trig", "aaa_ModLR_txId", "aaa_ModLR_user", "aaa_Org_configState", "aaa_Org_configStatusMessage", "aaa_Org_descr", "aaa_Org_name", "aaa_Org_orgDn", "aaa_PreLoginBanner_descr", "aaa_PreLoginBanner_intId", "aaa_PreLoginBanner_message", "aaa_PreLoginBanner_name", "aaa_PreLoginBanner_policyLevel", "aaa_PreLoginBanner_policyOwner", "aaa_ProviderGroup_configState", "aaa_ProviderGroup_descr", "aaa_ProviderGroup_name", "aaa_ProviderGroup_size", "aaa_ProviderRef_descr", "aaa_ProviderRef_name", "aaa_ProviderRef_order", "aaa_Provider_descr", "aaa_Provider_encKey", "aaa_Provider_key", "aaa_Provider_keySet", "aaa_Provider_name", "aaa_Provider_order", "aaa_Provider_retries", "aaa_Provider_timeout", "aaa_PwdProfile_changeCount", "aaa_PwdProfile_changeDuringInterval", "aaa_PwdProfile_changeInterval", "aaa_PwdProfile_descr", "aaa_PwdProfile_expirationWarnTime", "aaa_PwdProfile_historyCount", "aaa_PwdProfile_intId", "aaa_PwdProfile_name", "aaa_PwdProfile_noChangeInterval", "aaa_PwdProfile_policyLevel", "aaa_PwdProfile_policyOwner", "aaa_RadiusEpFsmStage_descr", "aaa_RadiusEpFsmStage_lastUpdateTime", "aaa_RadiusEpFsmStage_name", "aaa_RadiusEpFsmStage_order", "aaa_RadiusEpFsmStage_retry", "aaa_RadiusEpFsmStage_stageStatus", "aaa_RadiusEpFsm_completionTime", "aaa_RadiusEpFsm_currentFsm", "aaa_RadiusEpFsm_descr", "aaa_RadiusEpFsm_fsmStatus", "aaa_RadiusEpFsm_instanceId", "aaa_RadiusEpFsm_progress", "aaa_RadiusEpFsm_rmtErrCode", "aaa_RadiusEpFsm_rmtErrDescr", "aaa_RadiusEpFsm_rmtRslt", "aaa_RadiusEp_descr", "aaa_RadiusEp_fsmDescr", "aaa_RadiusEp_fsmPrev", "aaa_RadiusEp_fsmProgr", "aaa_RadiusEp_fsmRmtInvErrCode", "aaa_RadiusEp_fsmRmtInvErrDescr", "aaa_RadiusEp_fsmRmtInvRslt", "aaa_RadiusEp_fsmStageDescr", "aaa_RadiusEp_fsmStamp", "aaa_RadiusEp_fsmStatus", "aaa_RadiusEp_fsmTry", "aaa_RadiusEp_intId", "aaa_RadiusEp_name", "aaa_RadiusEp_policyLevel", "aaa_RadiusEp_policyOwner", "aaa_RadiusEp_retries", "aaa_RadiusEp_timeout", "aaa_RadiusProvider_authPort", "aaa_RadiusProvider_descr", "aaa_RadiusProvider_encKey", "aaa_RadiusProvider_key", "aaa_RadiusProvider_keySet", "aaa_RadiusProvider_name", "aaa_RadiusProvider_order", "aaa_RadiusProvider_retries", "aaa_RadiusProvider_service", "aaa_RadiusProvider_timeout", "aaa_RealmFsmStage_descr", "aaa_RealmFsmStage_lastUpdateTime", "aaa_RealmFsmStage_name", "aaa_RealmFsmStage_order", "aaa_RealmFsmStage_retry", "aaa_RealmFsmStage_stageStatus", "aaa_RealmFsmTask_completion", "aaa_RealmFsmTask_flags", "aaa_RealmFsmTask_item", "aaa_RealmFsmTask_seqId", "aaa_RealmFsm_completionTime", "aaa_RealmFsm_currentFsm", "aaa_RealmFsm_descr", "aaa_RealmFsm_fsmStatus", "aaa_RealmFsm_instanceId", "aaa_RealmFsm_progress", "aaa_RealmFsm_rmtErrCode", "aaa_RealmFsm_rmtErrDescr", "aaa_RealmFsm_rmtRslt", "aaa_Realm_descr", "aaa_Realm_fsmDescr", "aaa_Realm_fsmPrev", "aaa_Realm_fsmProgr", "aaa_Realm_fsmRmtInvErrCode", "aaa_Realm_fsmRmtInvErrDescr", "aaa_Realm_fsmRmtInvRslt", "aaa_Realm_fsmStageDescr", "aaa_Realm_fsmStamp", "aaa_Realm_fsmStatus", "aaa_Realm_fsmTry", "aaa_Realm_intId", "aaa_Realm_name", "aaa_Realm_policyLevel", "aaa_Realm_policyOwner", "aaa_RemoteUser_configState", "aaa_RemoteUser_configStatusMessage", "aaa_RemoteUser_descr", "aaa_RemoteUser_name", "aaa_RemoteUser_pwd", "aaa_RemoteUser_pwdSet", "aaa_Role_configState", "aaa_Role_configStatusMessage", "aaa_Role_descr", "aaa_Role_intId", "aaa_Role_name", "aaa_Role_policyLevel", "aaa_Role_policyOwner", "aaa_Role_priv", "aaa_SessionInfo_address", "aaa_SessionInfo_destIp", "aaa_SessionInfo_etime", "aaa_SessionInfo_id", "aaa_SessionInfo_priv", "aaa_SessionInfo_type", "aaa_SessionInfo_user", "aaa_SessionInfo_userType", "aaa_SessionLR_affected", "aaa_SessionLR_cause", "aaa_SessionLR_changeSet", "aaa_SessionLR_code", "aaa_SessionLR_created", "aaa_SessionLR_descr", "aaa_SessionLR_id", "aaa_SessionLR_ind", "aaa_SessionLR_sessionId", "aaa_SessionLR_severity", "aaa_SessionLR_trig", "aaa_SessionLR_txId", "aaa_SessionLR_user", "aaa_Session_host", "aaa_Session_id", "aaa_Session_intDel", "aaa_Session_loginTime", "aaa_Session_pid", "aaa_Session_refreshPeriod", "aaa_Session_sessionTimeout", "aaa_Session_switchId", "aaa_Session_term", "aaa_Session_ui", "aaa_Session_user", "aaa_ShellLogin_descr", "aaa_ShellLogin_id", "aaa_ShellLogin_intId", "aaa_ShellLogin_localHost", "aaa_ShellLogin_name", "aaa_ShellLogin_policyLevel", "aaa_ShellLogin_policyOwner", "aaa_ShellLogin_remoteHost", "aaa_ShellLogin_session", "aaa_ShellLogin_switchId", "aaa_SshAuth_data", "aaa_SshAuth_oldStrType", "aaa_SshAuth_strType", "aaa_SystemUser_configState", "aaa_SystemUser_configStatusMessage", "aaa_SystemUser_descr", "aaa_SystemUser_name", "aaa_SystemUser_pwd", "aaa_SystemUser_pwdSet", "aaa_TacacsPlusEpFsmStage_descr", "aaa_TacacsPlusEpFsmStage_lastUpdateTime", "aaa_TacacsPlusEpFsmStage_name", "aaa_TacacsPlusEpFsmStage_order", "aaa_TacacsPlusEpFsmStage_retry", "aaa_TacacsPlusEpFsmStage_stageStatus", "aaa_TacacsPlusEpFsm_completionTime", "aaa_TacacsPlusEpFsm_currentFsm", "aaa_TacacsPlusEpFsm_descr", "aaa_TacacsPlusEpFsm_fsmStatus", "aaa_TacacsPlusEpFsm_instanceId", "aaa_TacacsPlusEpFsm_progress", "aaa_TacacsPlusEpFsm_rmtErrCode", "aaa_TacacsPlusEpFsm_rmtErrDescr", "aaa_TacacsPlusEpFsm_rmtRslt", "aaa_TacacsPlusEp_descr", "aaa_TacacsPlusEp_fsmDescr", "aaa_TacacsPlusEp_fsmPrev", "aaa_TacacsPlusEp_fsmProgr", "aaa_TacacsPlusEp_fsmRmtInvErrCode", "aaa_TacacsPlusEp_fsmRmtInvErrDescr", "aaa_TacacsPlusEp_fsmRmtInvRslt", "aaa_TacacsPlusEp_fsmStageDescr", "aaa_TacacsPlusEp_fsmStamp", "aaa_TacacsPlusEp_fsmStatus", "aaa_TacacsPlusEp_fsmTry", "aaa_TacacsPlusEp_intId", "aaa_TacacsPlusEp_name", "aaa_TacacsPlusEp_policyLevel", "aaa_TacacsPlusEp_policyOwner", "aaa_TacacsPlusEp_retries", "aaa_TacacsPlusEp_timeout", "aaa_TacacsPlusProvider_descr", "aaa_TacacsPlusProvider_encKey", "aaa_TacacsPlusProvider_key", "aaa_TacacsPlusProvider_keySet", "aaa_TacacsPlusProvider_name", "aaa_TacacsPlusProvider_order", "aaa_TacacsPlusProvider_port", "aaa_TacacsPlusProvider_retries", "aaa_TacacsPlusProvider_timeout", "aaa_UserAction_affected", "aaa_UserAction_cause", "aaa_UserAction_changeSet", "aaa_UserAction_code", "aaa_UserAction_created", "aaa_UserAction_descr", "aaa_UserAction_id", "aaa_UserAction_ind", "aaa_UserAction_sessionId", "aaa_UserAction_severity", "aaa_UserAction_trig", "aaa_UserAction_txId", "aaa_UserAction_user", "aaa_UserData_descr", "aaa_UserData_intId", "aaa_UserData_name", "aaa_UserData_policyLevel", "aaa_UserData_policyOwner", "aaa_UserData_pwdChangeCount", "aaa_UserData_pwdChangeIntervalBegin", "aaa_UserData_pwdChangedDate", "aaa_UserData_pwdHistory", "aaa_UserEpFsmStage_descr", "aaa_UserEpFsmStage_lastUpdateTime", "aaa_UserEpFsmStage_name", "aaa_UserEpFsmStage_order", "aaa_UserEpFsmStage_retry", "aaa_UserEpFsmStage_stageStatus", "aaa_UserEpFsmTask_completion", "aaa_UserEpFsmTask_flags", "aaa_UserEpFsmTask_item", "aaa_UserEpFsmTask_seqId", "aaa_UserEpFsm_completionTime", "aaa_UserEpFsm_currentFsm", "aaa_UserEpFsm_descr", "aaa_UserEpFsm_fsmStatus", "aaa_UserEpFsm_instanceId", "aaa_UserEpFsm_progress", "aaa_UserEpFsm_rmtErrCode", "aaa_UserEpFsm_rmtErrDescr", "aaa_UserEpFsm_rmtRslt", "aaa_UserEp_descr", "aaa_UserEp_fsmDescr", "aaa_UserEp_fsmPrev", "aaa_UserEp_fsmProgr", "aaa_UserEp_fsmRmtInvErrCode", "aaa_UserEp_fsmRmtInvErrDescr", "aaa_UserEp_fsmRmtInvRslt", "aaa_UserEp_fsmStageDescr", "aaa_UserEp_fsmStamp", "aaa_UserEp_fsmStatus", "aaa_UserEp_fsmTry", "aaa_UserEp_intId", "aaa_UserEp_name", "aaa_UserEp_policyLevel", "aaa_UserEp_policyOwner", "aaa_UserEp_pwdStrengthCheck", "aaa_UserGroup_descr", "aaa_UserGroup_name", "aaa_UserLocale_configState", "aaa_UserLocale_configStatusMessage", "aaa_UserLocale_descr", "aaa_UserLocale_name", "aaa_UserLogin_descr", "aaa_UserLogin_id", "aaa_UserLogin_intId", "aaa_UserLogin_localHost", "aaa_UserLogin_name", "aaa_UserLogin_policyLevel", "aaa_UserLogin_policyOwner", "aaa_UserLogin_remoteHost", "aaa_UserLogin_session", "aaa_UserLogin_switchId", "aaa_UserRole_configState", "aaa_UserRole_configStatusMessage", "aaa_UserRole_descr", "aaa_UserRole_name", "aaa_User_accountStatus", "aaa_User_clearPwdHistory", "aaa_User_configState", "aaa_User_configStatusMessage", "aaa_User_descr", "aaa_User_email", "aaa_User_encPwd", "aaa_User_encPwdSet", "aaa_User_expiration", "aaa_User_expires", "aaa_User_firstName", "aaa_User_lastName", "aaa_User_name", "aaa_User_phone", "aaa_User_priv", "aaa_User_pwd", "aaa_User_pwdLifeTime", "aaa_User_pwdSet", "aaa_WebLogin_descr", "aaa_WebLogin_id", "aaa_WebLogin_intId", "aaa_WebLogin_localHost", "aaa_WebLogin_name", "aaa_WebLogin_policyLevel", "aaa_WebLogin_policyOwner", "aaa_WebLogin_remoteHost", "aaa_WebLogin_session", "aaa_WebLogin_switchId", "adaptor_CIoEp_epDn", "adaptor_CIoEp_ifRole", "adaptor_CIoEp_ifType", "adaptor_CIoEp_locale", "adaptor_CIoEp_name", "adaptor_CIoEp_peerDn", "adaptor_CIoEp_portId", "adaptor_CIoEp_switchId", "adaptor_CIoEp_transport", "adaptor_CIoEp_type", "adaptor_CapDef_fwVersionHi", "adaptor_CapDef_fwVersionLo", "adaptor_CapDef_fwVersionOpr", "adaptor_CapDef_maximum", "adaptor_CapDef_type", "adaptor_CapQual_fwVersionHi", "adaptor_CapQual_fwVersionLo", "adaptor_CapQual_fwVersionOpr", "adaptor_CapQual_maximum", "adaptor_CapQual_model", "adaptor_CapQual_type", "adaptor_CapSpec_fwVersionHi", "adaptor_CapSpec_fwVersionLo", "adaptor_CapSpec_fwVersionOpr", "adaptor_CapSpec_maximum", "adaptor_CapSpec_type", "adaptor_DiagCap_enableLldpTransmit", "adaptor_EthCompQueueProfile_count", "adaptor_EthCompQueueProfile_ringSize", "adaptor_EthFailoverProfile_timeout", "adaptor_EthInterruptProfile_coalescingTime", "adaptor_EthInterruptProfile_coalescingType", "adaptor_EthInterruptProfile_count", "adaptor_EthInterruptProfile_mode", "adaptor_EthOffloadProfile_largeReceive", "adaptor_EthOffloadProfile_tcpRxChecksum", "adaptor_EthOffloadProfile_tcpSegment", "adaptor_EthOffloadProfile_tcpTxChecksum", "adaptor_EthPortBySizeLargeStatsHist_greaterThanOrEqualTo9216", "adaptor_EthPortBySizeLargeStatsHist_greaterThanOrEqualTo9216Delta", "adaptor_EthPortBySizeLargeStatsHist_greaterThanOrEqualTo9216DeltaAvg", "adaptor_EthPortBySizeLargeStatsHist_greaterThanOrEqualTo9216DeltaMax", "adaptor_EthPortBySizeLargeStatsHist_greaterThanOrEqualTo9216DeltaMin", "adaptor_EthPortBySizeLargeStatsHist_id", "adaptor_EthPortBySizeLargeStatsHist_lessThan2048", "adaptor_EthPortBySizeLargeStatsHist_lessThan2048Delta", "adaptor_EthPortBySizeLargeStatsHist_lessThan2048DeltaAvg", "adaptor_EthPortBySizeLargeStatsHist_lessThan2048DeltaMax", "adaptor_EthPortBySizeLargeStatsHist_lessThan2048DeltaMin", "adaptor_EthPortBySizeLargeStatsHist_lessThan4096", "adaptor_EthPortBySizeLargeStatsHist_lessThan4096Delta", "adaptor_EthPortBySizeLargeStatsHist_lessThan4096DeltaAvg", "adaptor_EthPortBySizeLargeStatsHist_lessThan4096DeltaMax", "adaptor_EthPortBySizeLargeStatsHist_lessThan4096DeltaMin", "adaptor_EthPortBySizeLargeStatsHist_lessThan8192", "adaptor_EthPortBySizeLargeStatsHist_lessThan8192Delta", "adaptor_EthPortBySizeLargeStatsHist_lessThan8192DeltaAvg", "adaptor_EthPortBySizeLargeStatsHist_lessThan8192DeltaMax", "adaptor_EthPortBySizeLargeStatsHist_lessThan8192DeltaMin", "adaptor_EthPortBySizeLargeStatsHist_lessThan9216", "adaptor_EthPortBySizeLargeStatsHist_lessThan9216Delta", "adaptor_EthPortBySizeLargeStatsHist_lessThan9216DeltaAvg", "adaptor_EthPortBySizeLargeStatsHist_lessThan9216DeltaMax", "adaptor_EthPortBySizeLargeStatsHist_lessThan9216DeltaMin", "adaptor_EthPortBySizeLargeStatsHist_lessThanOrEqualTo1518", "adaptor_EthPortBySizeLargeStatsHist_lessThanOrEqualTo1518Delta", "adaptor_EthPortBySizeLargeStatsHist_lessThanOrEqualTo1518DeltaAvg", "adaptor_EthPortBySizeLargeStatsHist_lessThanOrEqualTo1518DeltaMax", "adaptor_EthPortBySizeLargeStatsHist_lessThanOrEqualTo1518DeltaMin", "adaptor_EthPortBySizeLargeStatsHist_mostRecent", "adaptor_EthPortBySizeLargeStatsHist_noBreakdownGreaterThan1518", "adaptor_EthPortBySizeLargeStatsHist_noBreakdownGreaterThan1518Delta", "adaptor_EthPortBySizeLargeStatsHist_noBreakdownGreaterThan1518DeltaAvg", "adaptor_EthPortBySizeLargeStatsHist_noBreakdownGreaterThan1518DeltaMax", "adaptor_EthPortBySizeLargeStatsHist_noBreakdownGreaterThan1518DeltaMin", "adaptor_EthPortBySizeLargeStatsHist_suspect", "adaptor_EthPortBySizeLargeStatsHist_thresholded", "adaptor_EthPortBySizeLargeStatsHist_timeCollected", "adaptor_EthPortBySizeLargeStats_greaterThanOrEqualTo9216", "adaptor_EthPortBySizeLargeStats_greaterThanOrEqualTo9216Delta", "adaptor_EthPortBySizeLargeStats_greaterThanOrEqualTo9216DeltaAvg", "adaptor_EthPortBySizeLargeStats_greaterThanOrEqualTo9216DeltaMax", "adaptor_EthPortBySizeLargeStats_greaterThanOrEqualTo9216DeltaMin", "adaptor_EthPortBySizeLargeStats_intervals", "adaptor_EthPortBySizeLargeStats_lessThan2048", "adaptor_EthPortBySizeLargeStats_lessThan2048Delta", "adaptor_EthPortBySizeLargeStats_lessThan2048DeltaAvg", "adaptor_EthPortBySizeLargeStats_lessThan2048DeltaMax", "adaptor_EthPortBySizeLargeStats_lessThan2048DeltaMin", "adaptor_EthPortBySizeLargeStats_lessThan4096", "adaptor_EthPortBySizeLargeStats_lessThan4096Delta", "adaptor_EthPortBySizeLargeStats_lessThan4096DeltaAvg", "adaptor_EthPortBySizeLargeStats_lessThan4096DeltaMax", "adaptor_EthPortBySizeLargeStats_lessThan4096DeltaMin", "adaptor_EthPortBySizeLargeStats_lessThan8192", "adaptor_EthPortBySizeLargeStats_lessThan8192Delta", "adaptor_EthPortBySizeLargeStats_lessThan8192DeltaAvg", "adaptor_EthPortBySizeLargeStats_lessThan8192DeltaMax", "adaptor_EthPortBySizeLargeStats_lessThan8192DeltaMin", "adaptor_EthPortBySizeLargeStats_lessThan9216", "adaptor_EthPortBySizeLargeStats_lessThan9216Delta", "adaptor_EthPortBySizeLargeStats_lessThan9216DeltaAvg", "adaptor_EthPortBySizeLargeStats_lessThan9216DeltaMax", "adaptor_EthPortBySizeLargeStats_lessThan9216DeltaMin", "adaptor_EthPortBySizeLargeStats_lessThanOrEqualTo1518", "adaptor_EthPortBySizeLargeStats_lessThanOrEqualTo1518Delta", "adaptor_EthPortBySizeLargeStats_lessThanOrEqualTo1518DeltaAvg", "adaptor_EthPortBySizeLargeStats_lessThanOrEqualTo1518DeltaMax", "adaptor_EthPortBySizeLargeStats_lessThanOrEqualTo1518DeltaMin", "adaptor_EthPortBySizeLargeStats_noBreakdownGreaterThan1518", "adaptor_EthPortBySizeLargeStats_noBreakdownGreaterThan1518Delta", "adaptor_EthPortBySizeLargeStats_noBreakdownGreaterThan1518DeltaAvg", "adaptor_EthPortBySizeLargeStats_noBreakdownGreaterThan1518DeltaMax", "adaptor_EthPortBySizeLargeStats_noBreakdownGreaterThan1518DeltaMin", "adaptor_EthPortBySizeLargeStats_suspect", "adaptor_EthPortBySizeLargeStats_thresholded", "adaptor_EthPortBySizeLargeStats_timeCollected", "adaptor_EthPortBySizeLargeStats_trafficDirection", "adaptor_EthPortBySizeLargeStats_update", "adaptor_EthPortBySizeSmallStatsHist_equals64", "adaptor_EthPortBySizeSmallStatsHist_equals64Delta", "adaptor_EthPortBySizeSmallStatsHist_equals64DeltaAvg", "adaptor_EthPortBySizeSmallStatsHist_equals64DeltaMax", "adaptor_EthPortBySizeSmallStatsHist_equals64DeltaMin", "adaptor_EthPortBySizeSmallStatsHist_id", "adaptor_EthPortBySizeSmallStatsHist_lessThan1024", "adaptor_EthPortBySizeSmallStatsHist_lessThan1024Delta", "adaptor_EthPortBySizeSmallStatsHist_lessThan1024DeltaAvg", "adaptor_EthPortBySizeSmallStatsHist_lessThan1024DeltaMax", "adaptor_EthPortBySizeSmallStatsHist_lessThan1024DeltaMin", "adaptor_EthPortBySizeSmallStatsHist_lessThan128", "adaptor_EthPortBySizeSmallStatsHist_lessThan128Delta", "adaptor_EthPortBySizeSmallStatsHist_lessThan128DeltaAvg", "adaptor_EthPortBySizeSmallStatsHist_lessThan128DeltaMax", "adaptor_EthPortBySizeSmallStatsHist_lessThan128DeltaMin", "adaptor_EthPortBySizeSmallStatsHist_lessThan256", "adaptor_EthPortBySizeSmallStatsHist_lessThan256Delta", "adaptor_EthPortBySizeSmallStatsHist_lessThan256DeltaAvg", "adaptor_EthPortBySizeSmallStatsHist_lessThan256DeltaMax", "adaptor_EthPortBySizeSmallStatsHist_lessThan256DeltaMin", "adaptor_EthPortBySizeSmallStatsHist_lessThan512", "adaptor_EthPortBySizeSmallStatsHist_lessThan512Delta", "adaptor_EthPortBySizeSmallStatsHist_lessThan512DeltaAvg", "adaptor_EthPortBySizeSmallStatsHist_lessThan512DeltaMax", "adaptor_EthPortBySizeSmallStatsHist_lessThan512DeltaMin", "adaptor_EthPortBySizeSmallStatsHist_lessThan64", "adaptor_EthPortBySizeSmallStatsHist_lessThan64Delta", "adaptor_EthPortBySizeSmallStatsHist_lessThan64DeltaAvg", "adaptor_EthPortBySizeSmallStatsHist_lessThan64DeltaMax", "adaptor_EthPortBySizeSmallStatsHist_lessThan64DeltaMin", "adaptor_EthPortBySizeSmallStatsHist_mostRecent", "adaptor_EthPortBySizeSmallStatsHist_suspect", "adaptor_EthPortBySizeSmallStatsHist_thresholded", "adaptor_EthPortBySizeSmallStatsHist_timeCollected", "adaptor_EthPortBySizeSmallStats_equals64", "adaptor_EthPortBySizeSmallStats_equals64Delta", "adaptor_EthPortBySizeSmallStats_equals64DeltaAvg", "adaptor_EthPortBySizeSmallStats_equals64DeltaMax", "adaptor_EthPortBySizeSmallStats_equals64DeltaMin", "adaptor_EthPortBySizeSmallStats_intervals", "adaptor_EthPortBySizeSmallStats_lessThan1024", "adaptor_EthPortBySizeSmallStats_lessThan1024Delta", "adaptor_EthPortBySizeSmallStats_lessThan1024DeltaAvg", "adaptor_EthPortBySizeSmallStats_lessThan1024DeltaMax", "adaptor_EthPortBySizeSmallStats_lessThan1024DeltaMin", "adaptor_EthPortBySizeSmallStats_lessThan128", "adaptor_EthPortBySizeSmallStats_lessThan128Delta", "adaptor_EthPortBySizeSmallStats_lessThan128DeltaAvg", "adaptor_EthPortBySizeSmallStats_lessThan128DeltaMax", "adaptor_EthPortBySizeSmallStats_lessThan128DeltaMin", "adaptor_EthPortBySizeSmallStats_lessThan256", "adaptor_EthPortBySizeSmallStats_lessThan256Delta", "adaptor_EthPortBySizeSmallStats_lessThan256DeltaAvg", "adaptor_EthPortBySizeSmallStats_lessThan256DeltaMax", "adaptor_EthPortBySizeSmallStats_lessThan256DeltaMin", "adaptor_EthPortBySizeSmallStats_lessThan512", "adaptor_EthPortBySizeSmallStats_lessThan512Delta", "adaptor_EthPortBySizeSmallStats_lessThan512DeltaAvg", "adaptor_EthPortBySizeSmallStats_lessThan512DeltaMax", "adaptor_EthPortBySizeSmallStats_lessThan512DeltaMin", "adaptor_EthPortBySizeSmallStats_lessThan64", "adaptor_EthPortBySizeSmallStats_lessThan64Delta", "adaptor_EthPortBySizeSmallStats_lessThan64DeltaAvg", "adaptor_EthPortBySizeSmallStats_lessThan64DeltaMax", "adaptor_EthPortBySizeSmallStats_lessThan64DeltaMin", "adaptor_EthPortBySizeSmallStats_suspect", "adaptor_EthPortBySizeSmallStats_thresholded", "adaptor_EthPortBySizeSmallStats_timeCollected", "adaptor_EthPortBySizeSmallStats_trafficDirection", "adaptor_EthPortBySizeSmallStats_update", "adaptor_EthPortErrStatsHist_badCrcPackets", "adaptor_EthPortErrStatsHist_badCrcPacketsDelta", "adaptor_EthPortErrStatsHist_badCrcPacketsDeltaAvg", "adaptor_EthPortErrStatsHist_badCrcPacketsDeltaMax", "adaptor_EthPortErrStatsHist_badCrcPacketsDeltaMin", "adaptor_EthPortErrStatsHist_badLengthPackets", "adaptor_EthPortErrStatsHist_badLengthPacketsDelta", "adaptor_EthPortErrStatsHist_badLengthPacketsDeltaAvg", "adaptor_EthPortErrStatsHist_badLengthPacketsDeltaMax", "adaptor_EthPortErrStatsHist_badLengthPacketsDeltaMin", "adaptor_EthPortErrStatsHist_id", "adaptor_EthPortErrStatsHist_macDiscardedPackets", "adaptor_EthPortErrStatsHist_macDiscardedPacketsDelta", "adaptor_EthPortErrStatsHist_macDiscardedPacketsDeltaAvg", "adaptor_EthPortErrStatsHist_macDiscardedPacketsDeltaMax", "adaptor_EthPortErrStatsHist_macDiscardedPacketsDeltaMin", "adaptor_EthPortErrStatsHist_mostRecent", "adaptor_EthPortErrStatsHist_suspect", "adaptor_EthPortErrStatsHist_thresholded", "adaptor_EthPortErrStatsHist_timeCollected", "adaptor_EthPortErrStats_badCrcPackets", "adaptor_EthPortErrStats_badCrcPacketsDelta", "adaptor_EthPortErrStats_badCrcPacketsDeltaAvg", "adaptor_EthPortErrStats_badCrcPacketsDeltaMax", "adaptor_EthPortErrStats_badCrcPacketsDeltaMin", "adaptor_EthPortErrStats_badLengthPackets", "adaptor_EthPortErrStats_badLengthPacketsDelta", "adaptor_EthPortErrStats_badLengthPacketsDeltaAvg", "adaptor_EthPortErrStats_badLengthPacketsDeltaMax", "adaptor_EthPortErrStats_badLengthPacketsDeltaMin", "adaptor_EthPortErrStats_intervals", "adaptor_EthPortErrStats_macDiscardedPackets", "adaptor_EthPortErrStats_macDiscardedPacketsDelta", "adaptor_EthPortErrStats_macDiscardedPacketsDeltaAvg", "adaptor_EthPortErrStats_macDiscardedPacketsDeltaMax", "adaptor_EthPortErrStats_macDiscardedPacketsDeltaMin", "adaptor_EthPortErrStats_suspect", "adaptor_EthPortErrStats_thresholded", "adaptor_EthPortErrStats_timeCollected", "adaptor_EthPortErrStats_trafficDirection", "adaptor_EthPortErrStats_update", "adaptor_EthPortMcastStatsHist_broadcastPackets", "adaptor_EthPortMcastStatsHist_broadcastPacketsDelta", "adaptor_EthPortMcastStatsHist_broadcastPacketsDeltaAvg", "adaptor_EthPortMcastStatsHist_broadcastPacketsDeltaMax", "adaptor_EthPortMcastStatsHist_broadcastPacketsDeltaMin", "adaptor_EthPortMcastStatsHist_id", "adaptor_EthPortMcastStatsHist_mostRecent", "adaptor_EthPortMcastStatsHist_multicastPackets", "adaptor_EthPortMcastStatsHist_multicastPacketsDelta", "adaptor_EthPortMcastStatsHist_multicastPacketsDeltaAvg", "adaptor_EthPortMcastStatsHist_multicastPacketsDeltaMax", "adaptor_EthPortMcastStatsHist_multicastPacketsDeltaMin", "adaptor_EthPortMcastStatsHist_suspect", "adaptor_EthPortMcastStatsHist_thresholded", "adaptor_EthPortMcastStatsHist_timeCollected", "adaptor_EthPortMcastStatsHist_unicastPackets", "adaptor_EthPortMcastStatsHist_unicastPacketsDelta", "adaptor_EthPortMcastStatsHist_unicastPacketsDeltaAvg", "adaptor_EthPortMcastStatsHist_unicastPacketsDeltaMax", "adaptor_EthPortMcastStatsHist_unicastPacketsDeltaMin", "adaptor_EthPortMcastStats_broadcastPackets", "adaptor_EthPortMcastStats_broadcastPacketsDelta", "adaptor_EthPortMcastStats_broadcastPacketsDeltaAvg", "adaptor_EthPortMcastStats_broadcastPacketsDeltaMax", "adaptor_EthPortMcastStats_broadcastPacketsDeltaMin", "adaptor_EthPortMcastStats_intervals", "adaptor_EthPortMcastStats_multicastPackets", "adaptor_EthPortMcastStats_multicastPacketsDelta", "adaptor_EthPortMcastStats_multicastPacketsDeltaAvg", "adaptor_EthPortMcastStats_multicastPacketsDeltaMax", "adaptor_EthPortMcastStats_multicastPacketsDeltaMin", "adaptor_EthPortMcastStats_suspect", "adaptor_EthPortMcastStats_thresholded", "adaptor_EthPortMcastStats_timeCollected", "adaptor_EthPortMcastStats_trafficDirection", "adaptor_EthPortMcastStats_unicastPackets", "adaptor_EthPortMcastStats_unicastPacketsDelta", "adaptor_EthPortMcastStats_unicastPacketsDeltaAvg", "adaptor_EthPortMcastStats_unicastPacketsDeltaMax", "adaptor_EthPortMcastStats_unicastPacketsDeltaMin", "adaptor_EthPortMcastStats_update", "adaptor_EthPortOutsizedStatsHist_id", "adaptor_EthPortOutsizedStatsHist_mostRecent", "adaptor_EthPortOutsizedStatsHist_oversizedBadCrcPackets", "adaptor_EthPortOutsizedStatsHist_oversizedBadCrcPacketsDelta", "adaptor_EthPortOutsizedStatsHist_oversizedBadCrcPacketsDeltaAvg", "adaptor_EthPortOutsizedStatsHist_oversizedBadCrcPacketsDeltaMax", "adaptor_EthPortOutsizedStatsHist_oversizedBadCrcPacketsDeltaMin", "adaptor_EthPortOutsizedStatsHist_oversizedGoodCrcPackets", "adaptor_EthPortOutsizedStatsHist_oversizedGoodCrcPacketsDelta", "adaptor_EthPortOutsizedStatsHist_oversizedGoodCrcPacketsDeltaAvg", "adaptor_EthPortOutsizedStatsHist_oversizedGoodCrcPacketsDeltaMax", "adaptor_EthPortOutsizedStatsHist_oversizedGoodCrcPacketsDeltaMin", "adaptor_EthPortOutsizedStatsHist_oversizedPackets", "adaptor_EthPortOutsizedStatsHist_oversizedPacketsDelta", "adaptor_EthPortOutsizedStatsHist_oversizedPacketsDeltaAvg", "adaptor_EthPortOutsizedStatsHist_oversizedPacketsDeltaMax", "adaptor_EthPortOutsizedStatsHist_oversizedPacketsDeltaMin", "adaptor_EthPortOutsizedStatsHist_suspect", "adaptor_EthPortOutsizedStatsHist_thresholded", "adaptor_EthPortOutsizedStatsHist_timeCollected", "adaptor_EthPortOutsizedStatsHist_undersizedBadCrcPackets", "adaptor_EthPortOutsizedStatsHist_undersizedBadCrcPacketsDelta", "adaptor_EthPortOutsizedStatsHist_undersizedBadCrcPacketsDeltaAvg", "adaptor_EthPortOutsizedStatsHist_undersizedBadCrcPacketsDeltaMax", "adaptor_EthPortOutsizedStatsHist_undersizedBadCrcPacketsDeltaMin", "adaptor_EthPortOutsizedStatsHist_undersizedGoodCrcPackets", "adaptor_EthPortOutsizedStatsHist_undersizedGoodCrcPacketsDelta", "adaptor_EthPortOutsizedStatsHist_undersizedGoodCrcPacketsDeltaAvg", "adaptor_EthPortOutsizedStatsHist_undersizedGoodCrcPacketsDeltaMax", "adaptor_EthPortOutsizedStatsHist_undersizedGoodCrcPacketsDeltaMin", "adaptor_EthPortOutsizedStats_intervals", "adaptor_EthPortOutsizedStats_oversizedBadCrcPackets", "adaptor_EthPortOutsizedStats_oversizedBadCrcPacketsDelta", "adaptor_EthPortOutsizedStats_oversizedBadCrcPacketsDeltaAvg", "adaptor_EthPortOutsizedStats_oversizedBadCrcPacketsDeltaMax", "adaptor_EthPortOutsizedStats_oversizedBadCrcPacketsDeltaMin", "adaptor_EthPortOutsizedStats_oversizedGoodCrcPackets", "adaptor_EthPortOutsizedStats_oversizedGoodCrcPacketsDelta", "adaptor_EthPortOutsizedStats_oversizedGoodCrcPacketsDeltaAvg", "adaptor_EthPortOutsizedStats_oversizedGoodCrcPacketsDeltaMax", "adaptor_EthPortOutsizedStats_oversizedGoodCrcPacketsDeltaMin", "adaptor_EthPortOutsizedStats_oversizedPackets", "adaptor_EthPortOutsizedStats_oversizedPacketsDelta", "adaptor_EthPortOutsizedStats_oversizedPacketsDeltaAvg", "adaptor_EthPortOutsizedStats_oversizedPacketsDeltaMax", "adaptor_EthPortOutsizedStats_oversizedPacketsDeltaMin", "adaptor_EthPortOutsizedStats_suspect", "adaptor_EthPortOutsizedStats_thresholded", "adaptor_EthPortOutsizedStats_timeCollected", "adaptor_EthPortOutsizedStats_trafficDirection", "adaptor_EthPortOutsizedStats_undersizedBadCrcPackets", "adaptor_EthPortOutsizedStats_undersizedBadCrcPacketsDelta", "adaptor_EthPortOutsizedStats_undersizedBadCrcPacketsDeltaAvg", "adaptor_EthPortOutsizedStats_undersizedBadCrcPacketsDeltaMax", "adaptor_EthPortOutsizedStats_undersizedBadCrcPacketsDeltaMin", "adaptor_EthPortOutsizedStats_undersizedGoodCrcPackets", "adaptor_EthPortOutsizedStats_undersizedGoodCrcPacketsDelta", "adaptor_EthPortOutsizedStats_undersizedGoodCrcPacketsDeltaAvg", "adaptor_EthPortOutsizedStats_undersizedGoodCrcPacketsDeltaMax", "adaptor_EthPortOutsizedStats_undersizedGoodCrcPacketsDeltaMin", "adaptor_EthPortOutsizedStats_update", "adaptor_EthPortStatsHist_goodPackets", "adaptor_EthPortStatsHist_goodPacketsDelta", "adaptor_EthPortStatsHist_goodPacketsDeltaAvg", "adaptor_EthPortStatsHist_goodPacketsDeltaMax", "adaptor_EthPortStatsHist_goodPacketsDeltaMin", "adaptor_EthPortStatsHist_id", "adaptor_EthPortStatsHist_mostRecent", "adaptor_EthPortStatsHist_pausePackets", "adaptor_EthPortStatsHist_pausePacketsDelta", "adaptor_EthPortStatsHist_pausePacketsDeltaAvg", "adaptor_EthPortStatsHist_pausePacketsDeltaMax", "adaptor_EthPortStatsHist_pausePacketsDeltaMin", "adaptor_EthPortStatsHist_perPriorityPausePackets", "adaptor_EthPortStatsHist_perPriorityPausePacketsDelta", "adaptor_EthPortStatsHist_perPriorityPausePacketsDeltaAvg", "adaptor_EthPortStatsHist_perPriorityPausePacketsDeltaMax", "adaptor_EthPortStatsHist_perPriorityPausePacketsDeltaMin", "adaptor_EthPortStatsHist_pppPackets", "adaptor_EthPortStatsHist_pppPacketsDelta", "adaptor_EthPortStatsHist_pppPacketsDeltaAvg", "adaptor_EthPortStatsHist_pppPacketsDeltaMax", "adaptor_EthPortStatsHist_pppPacketsDeltaMin", "adaptor_EthPortStatsHist_suspect", "adaptor_EthPortStatsHist_thresholded", "adaptor_EthPortStatsHist_timeCollected", "adaptor_EthPortStatsHist_totalPackets", "adaptor_EthPortStatsHist_totalPacketsDelta", "adaptor_EthPortStatsHist_totalPacketsDeltaAvg", "adaptor_EthPortStatsHist_totalPacketsDeltaMax", "adaptor_EthPortStatsHist_totalPacketsDeltaMin", "adaptor_EthPortStatsHist_vlanPackets", "adaptor_EthPortStatsHist_vlanPacketsDelta", "adaptor_EthPortStatsHist_vlanPacketsDeltaAvg", "adaptor_EthPortStatsHist_vlanPacketsDeltaMax", "adaptor_EthPortStatsHist_vlanPacketsDeltaMin", "adaptor_EthPortStats_goodPackets", "adaptor_EthPortStats_goodPacketsDelta", "adaptor_EthPortStats_goodPacketsDeltaAvg", "adaptor_EthPortStats_goodPacketsDeltaMax", "adaptor_EthPortStats_goodPacketsDeltaMin", "adaptor_EthPortStats_intervals", "adaptor_EthPortStats_pausePackets", "adaptor_EthPortStats_pausePacketsDelta", "adaptor_EthPortStats_pausePacketsDeltaAvg", "adaptor_EthPortStats_pausePacketsDeltaMax", "adaptor_EthPortStats_pausePacketsDeltaMin", "adaptor_EthPortStats_perPriorityPausePackets", "adaptor_EthPortStats_perPriorityPausePacketsDelta", "adaptor_EthPortStats_perPriorityPausePacketsDeltaAvg", "adaptor_EthPortStats_perPriorityPausePacketsDeltaMax", "adaptor_EthPortStats_perPriorityPausePacketsDeltaMin", "adaptor_EthPortStats_pppPackets", "adaptor_EthPortStats_pppPacketsDelta", "adaptor_EthPortStats_pppPacketsDeltaAvg", "adaptor_EthPortStats_pppPacketsDeltaMax", "adaptor_EthPortStats_pppPacketsDeltaMin", "adaptor_EthPortStats_suspect", "adaptor_EthPortStats_thresholded", "adaptor_EthPortStats_timeCollected", "adaptor_EthPortStats_totalPackets", "adaptor_EthPortStats_totalPacketsDelta", "adaptor_EthPortStats_totalPacketsDeltaAvg", "adaptor_EthPortStats_totalPacketsDeltaMax", "adaptor_EthPortStats_totalPacketsDeltaMin", "adaptor_EthPortStats_trafficDirection", "adaptor_EthPortStats_update", "adaptor_EthPortStats_vlanPackets", "adaptor_EthPortStats_vlanPacketsDelta", "adaptor_EthPortStats_vlanPacketsDeltaAvg", "adaptor_EthPortStats_vlanPacketsDeltaMax", "adaptor_EthPortStats_vlanPacketsDeltaMin", "adaptor_EthQueueProfile_count", "adaptor_EthQueueProfile_ringSize", "adaptor_EthRecvQueueProfile_count", "adaptor_EthRecvQueueProfile_ringSize", "adaptor_EthWorkQueueProfile_count", "adaptor_EthWorkQueueProfile_ringSize", "adaptor_EtherIfStatsHist_id", "adaptor_EtherIfStatsHist_mostRecent", "adaptor_EtherIfStatsHist_rxBytes", "adaptor_EtherIfStatsHist_rxBytesDelta", "adaptor_EtherIfStatsHist_rxBytesDeltaAvg", "adaptor_EtherIfStatsHist_rxBytesDeltaMax", "adaptor_EtherIfStatsHist_rxBytesDeltaMin", "adaptor_EtherIfStatsHist_rxDropped", "adaptor_EtherIfStatsHist_rxDroppedDelta", "adaptor_EtherIfStatsHist_rxDroppedDeltaAvg", "adaptor_EtherIfStatsHist_rxDroppedDeltaMax", "adaptor_EtherIfStatsHist_rxDroppedDeltaMin", "adaptor_EtherIfStatsHist_rxErrors", "adaptor_EtherIfStatsHist_rxErrorsDelta", "adaptor_EtherIfStatsHist_rxErrorsDeltaAvg", "adaptor_EtherIfStatsHist_rxErrorsDeltaMax", "adaptor_EtherIfStatsHist_rxErrorsDeltaMin", "adaptor_EtherIfStatsHist_rxPackets", "adaptor_EtherIfStatsHist_rxPacketsDelta", "adaptor_EtherIfStatsHist_rxPacketsDeltaAvg", "adaptor_EtherIfStatsHist_rxPacketsDeltaMax", "adaptor_EtherIfStatsHist_rxPacketsDeltaMin", "adaptor_EtherIfStatsHist_suspect", "adaptor_EtherIfStatsHist_thresholded", "adaptor_EtherIfStatsHist_timeCollected", "adaptor_EtherIfStatsHist_txBytes", "adaptor_EtherIfStatsHist_txBytesDelta", "adaptor_EtherIfStatsHist_txBytesDeltaAvg", "adaptor_EtherIfStatsHist_txBytesDeltaMax", "adaptor_EtherIfStatsHist_txBytesDeltaMin", "adaptor_EtherIfStatsHist_txDropped", "adaptor_EtherIfStatsHist_txDroppedDelta", "adaptor_EtherIfStatsHist_txDroppedDeltaAvg", "adaptor_EtherIfStatsHist_txDroppedDeltaMax", "adaptor_EtherIfStatsHist_txDroppedDeltaMin", "adaptor_EtherIfStatsHist_txErrors", "adaptor_EtherIfStatsHist_txErrorsDelta", "adaptor_EtherIfStatsHist_txErrorsDeltaAvg", "adaptor_EtherIfStatsHist_txErrorsDeltaMax", "adaptor_EtherIfStatsHist_txErrorsDeltaMin", "adaptor_EtherIfStatsHist_txPackets", "adaptor_EtherIfStatsHist_txPacketsDelta", "adaptor_EtherIfStatsHist_txPacketsDeltaAvg", "adaptor_EtherIfStatsHist_txPacketsDeltaMax", "adaptor_EtherIfStatsHist_txPacketsDeltaMin", "adaptor_EtherIfStats_intervals", "adaptor_EtherIfStats_rxBytes", "adaptor_EtherIfStats_rxBytesDelta", "adaptor_EtherIfStats_rxBytesDeltaAvg", "adaptor_EtherIfStats_rxBytesDeltaMax", "adaptor_EtherIfStats_rxBytesDeltaMin", "adaptor_EtherIfStats_rxDropped", "adaptor_EtherIfStats_rxDroppedDelta", "adaptor_EtherIfStats_rxDroppedDeltaAvg", "adaptor_EtherIfStats_rxDroppedDeltaMax", "adaptor_EtherIfStats_rxDroppedDeltaMin", "adaptor_EtherIfStats_rxErrors", "adaptor_EtherIfStats_rxErrorsDelta", "adaptor_EtherIfStats_rxErrorsDeltaAvg", "adaptor_EtherIfStats_rxErrorsDeltaMax", "adaptor_EtherIfStats_rxErrorsDeltaMin", "adaptor_EtherIfStats_rxPackets", "adaptor_EtherIfStats_rxPacketsDelta", "adaptor_EtherIfStats_rxPacketsDeltaAvg", "adaptor_EtherIfStats_rxPacketsDeltaMax", "adaptor_EtherIfStats_rxPacketsDeltaMin", "adaptor_EtherIfStats_suspect", "adaptor_EtherIfStats_thresholded", "adaptor_EtherIfStats_timeCollected", "adaptor_EtherIfStats_txBytes", "adaptor_EtherIfStats_txBytesDelta", "adaptor_EtherIfStats_txBytesDeltaAvg", "adaptor_EtherIfStats_txBytesDeltaMax", "adaptor_EtherIfStats_txBytesDeltaMin", "adaptor_EtherIfStats_txDropped", "adaptor_EtherIfStats_txDroppedDelta", "adaptor_EtherIfStats_txDroppedDeltaAvg", "adaptor_EtherIfStats_txDroppedDeltaMax", "adaptor_EtherIfStats_txDroppedDeltaMin", "adaptor_EtherIfStats_txErrors", "adaptor_EtherIfStats_txErrorsDelta", "adaptor_EtherIfStats_txErrorsDeltaAvg", "adaptor_EtherIfStats_txErrorsDeltaMax", "adaptor_EtherIfStats_txErrorsDeltaMin", "adaptor_EtherIfStats_txPackets", "adaptor_EtherIfStats_txPacketsDelta", "adaptor_EtherIfStats_txPacketsDeltaAvg", "adaptor_EtherIfStats_txPacketsDeltaMax", "adaptor_EtherIfStats_txPacketsDeltaMin", "adaptor_EtherIfStats_update", "adaptor_ExtEthIfFsmStage_descr", "adaptor_ExtEthIfFsmStage_lastUpdateTime", "adaptor_ExtEthIfFsmStage_name", "adaptor_ExtEthIfFsmStage_order", "adaptor_ExtEthIfFsmStage_retry", "adaptor_ExtEthIfFsmStage_stageStatus", "adaptor_ExtEthIfFsmTask_completion", "adaptor_ExtEthIfFsmTask_flags", "adaptor_ExtEthIfFsmTask_item", "adaptor_ExtEthIfFsmTask_seqId", "adaptor_ExtEthIfFsm_completionTime", "adaptor_ExtEthIfFsm_currentFsm", "adaptor_ExtEthIfFsm_descr", "adaptor_ExtEthIfFsm_fsmStatus", "adaptor_ExtEthIfFsm_instanceId", "adaptor_ExtEthIfFsm_progress", "adaptor_ExtEthIfFsm_rmtErrCode", "adaptor_ExtEthIfFsm_rmtErrDescr", "adaptor_ExtEthIfFsm_rmtRslt", "adaptor_ExtEthIfPcEp_chassisId", "adaptor_ExtEthIfPcEp_epDn", "adaptor_ExtEthIfPcEp_ifRole", "adaptor_ExtEthIfPcEp_ifType", "adaptor_ExtEthIfPcEp_locale", "adaptor_ExtEthIfPcEp_membership", "adaptor_ExtEthIfPcEp_name", "adaptor_ExtEthIfPcEp_peerChassisId", "adaptor_ExtEthIfPcEp_peerDn", "adaptor_ExtEthIfPcEp_peerPortId", "adaptor_ExtEthIfPcEp_peerSlotId", "adaptor_ExtEthIfPcEp_portId", "adaptor_ExtEthIfPcEp_slotId", "adaptor_ExtEthIfPcEp_switchId", "adaptor_ExtEthIfPcEp_transport", "adaptor_ExtEthIfPcEp_type", "adaptor_ExtEthIfPc_epDn", "adaptor_ExtEthIfPc_fltAggr", "adaptor_ExtEthIfPc_ifRole", "adaptor_ExtEthIfPc_ifType", "adaptor_ExtEthIfPc_locale", "adaptor_ExtEthIfPc_mac", "adaptor_ExtEthIfPc_name", "adaptor_ExtEthIfPc_operSpeed", "adaptor_ExtEthIfPc_operState", "adaptor_ExtEthIfPc_peerDn", "adaptor_ExtEthIfPc_portId", "adaptor_ExtEthIfPc_stateQual", "adaptor_ExtEthIfPc_switchId", "adaptor_ExtEthIfPc_transport", "adaptor_ExtEthIfPc_type", "adaptor_ExtEthIf_adapterId", "adaptor_ExtEthIf_adminState", "adaptor_ExtEthIf_chassisId", "adaptor_ExtEthIf_discovery", "adaptor_ExtEthIf_epDn", "adaptor_ExtEthIf_fsmDescr", "adaptor_ExtEthIf_fsmPrev", "adaptor_ExtEthIf_fsmProgr", "adaptor_ExtEthIf_fsmRmtInvErrCode", "adaptor_ExtEthIf_fsmRmtInvErrDescr", "adaptor_ExtEthIf_fsmRmtInvRslt", "adaptor_ExtEthIf_fsmStageDescr", "adaptor_ExtEthIf_fsmStamp", "adaptor_ExtEthIf_fsmStatus", "adaptor_ExtEthIf_fsmTry", "adaptor_ExtEthIf_id", "adaptor_ExtEthIf_ifRole", "adaptor_ExtEthIf_ifType", "adaptor_ExtEthIf_linkState", "adaptor_ExtEthIf_lldpMac", "adaptor_ExtEthIf_locale", "adaptor_ExtEthIf_mac", "adaptor_ExtEthIf_macAddrType", "adaptor_ExtEthIf_name", "adaptor_ExtEthIf_operState", "adaptor_ExtEthIf_operStateDesc", "adaptor_ExtEthIf_peerChassisId", "adaptor_ExtEthIf_peerDn", "adaptor_ExtEthIf_peerPortId", "adaptor_ExtEthIf_peerSlotId", "adaptor_ExtEthIf_physEpDn", "adaptor_ExtEthIf_portId", "adaptor_ExtEthIf_purpose", "adaptor_ExtEthIf_side", "adaptor_ExtEthIf_slotId", "adaptor_ExtEthIf_switchId", "adaptor_ExtEthIf_transport", "adaptor_ExtEthIf_type", "adaptor_ExtIfEp_chassisId", "adaptor_ExtIfEp_epDn", "adaptor_ExtIfEp_ifRole", "adaptor_ExtIfEp_ifType", "adaptor_ExtIfEp_locale", "adaptor_ExtIfEp_name", "adaptor_ExtIfEp_peerChassisId", "adaptor_ExtIfEp_peerDn", "adaptor_ExtIfEp_peerPortId", "adaptor_ExtIfEp_peerSlotId", "adaptor_ExtIfEp_portId", "adaptor_ExtIfEp_slotId", "adaptor_ExtIfEp_switchId", "adaptor_ExtIfEp_transport", "adaptor_ExtIfEp_type", "adaptor_ExtIfPc_epDn", "adaptor_ExtIfPc_fltAggr", "adaptor_ExtIfPc_ifRole", "adaptor_ExtIfPc_ifType", "adaptor_ExtIfPc_locale", "adaptor_ExtIfPc_name", "adaptor_ExtIfPc_operSpeed", "adaptor_ExtIfPc_operState", "adaptor_ExtIfPc_peerDn", "adaptor_ExtIfPc_portId", "adaptor_ExtIfPc_stateQual", "adaptor_ExtIfPc_switchId", "adaptor_ExtIfPc_transport", "adaptor_ExtIfPc_type", "adaptor_ExtIf_adapterId", "adaptor_ExtIf_adminState", "adaptor_ExtIf_chassisId", "adaptor_ExtIf_discovery", "adaptor_ExtIf_epDn", "adaptor_ExtIf_id", "adaptor_ExtIf_ifRole", "adaptor_ExtIf_ifType", "adaptor_ExtIf_linkState", "adaptor_ExtIf_lldpMac", "adaptor_ExtIf_locale", "adaptor_ExtIf_mac", "adaptor_ExtIf_name", "adaptor_ExtIf_operState", "adaptor_ExtIf_operStateDesc", "adaptor_ExtIf_peerChassisId", "adaptor_ExtIf_peerDn", "adaptor_ExtIf_peerPortId", "adaptor_ExtIf_peerSlotId", "adaptor_ExtIf_physEpDn", "adaptor_ExtIf_portId", "adaptor_ExtIf_purpose", "adaptor_ExtIf_side", "adaptor_ExtIf_slotId", "adaptor_ExtIf_switchId", "adaptor_ExtIf_transport", "adaptor_ExtIf_type", "adaptor_ExtIpV6RssHashProfile_ipHash", "adaptor_ExtIpV6RssHashProfile_tcpHash", "adaptor_ExternalEp_chassisId", "adaptor_ExternalEp_epDn", "adaptor_ExternalEp_ifRole", "adaptor_ExternalEp_ifType", "adaptor_ExternalEp_locale", "adaptor_ExternalEp_name", "adaptor_ExternalEp_peerChassisId", "adaptor_ExternalEp_peerDn", "adaptor_ExternalEp_peerPortId", "adaptor_ExternalEp_peerSlotId", "adaptor_ExternalEp_portId", "adaptor_ExternalEp_slotId", "adaptor_ExternalEp_switchId", "adaptor_ExternalEp_transport", "adaptor_ExternalEp_type", "adaptor_ExternalPc_epDn", "adaptor_ExternalPc_ifRole", "adaptor_ExternalPc_ifType", "adaptor_ExternalPc_locale", "adaptor_ExternalPc_name", "adaptor_ExternalPc_operState", "adaptor_ExternalPc_peerDn", "adaptor_ExternalPc_portId", "adaptor_ExternalPc_stateQual", "adaptor_ExternalPc_switchId", "adaptor_ExternalPc_transport", "adaptor_ExternalPc_type", "adaptor_FamilyTypeDef_isPassthrough", "adaptor_FamilyTypeDef_numDcePorts", "adaptor_FamilyTypeDef_portFamily", "adaptor_FamilyTypeDef_type", "adaptor_FcCdbWorkQueueProfile_count", "adaptor_FcCdbWorkQueueProfile_ringSize", "adaptor_FcErrorRecoveryProfile_errorDetectTimeout", "adaptor_FcErrorRecoveryProfile_fcpErrorRecovery", "adaptor_FcErrorRecoveryProfile_linkDownTimeout", "adaptor_FcErrorRecoveryProfile_portDownIoRetryCount", "adaptor_FcErrorRecoveryProfile_portDownTimeout", "adaptor_FcErrorRecoveryProfile_resourceAllocationTimeout", "adaptor_FcIfEventStatsHist_id", "adaptor_FcIfEventStatsHist_invalidCRCCount", "adaptor_FcIfEventStatsHist_invalidCRCCountDelta", "adaptor_FcIfEventStatsHist_invalidCRCCountDeltaAvg", "adaptor_FcIfEventStatsHist_invalidCRCCountDeltaMax", "adaptor_FcIfEventStatsHist_invalidCRCCountDeltaMin", "adaptor_FcIfEventStatsHist_linkFailureCount", "adaptor_FcIfEventStatsHist_linkFailureCountDelta", "adaptor_FcIfEventStatsHist_linkFailureCountDeltaAvg", "adaptor_FcIfEventStatsHist_linkFailureCountDeltaMax", "adaptor_FcIfEventStatsHist_linkFailureCountDeltaMin", "adaptor_FcIfEventStatsHist_lipCount", "adaptor_FcIfEventStatsHist_lipCountDelta", "adaptor_FcIfEventStatsHist_lipCountDeltaAvg", "adaptor_FcIfEventStatsHist_lipCountDeltaMax", "adaptor_FcIfEventStatsHist_lipCountDeltaMin", "adaptor_FcIfEventStatsHist_lossOfSignalCount", "adaptor_FcIfEventStatsHist_lossOfSignalCountDelta", "adaptor_FcIfEventStatsHist_lossOfSignalCountDeltaAvg", "adaptor_FcIfEventStatsHist_lossOfSignalCountDeltaMax", "adaptor_FcIfEventStatsHist_lossOfSignalCountDeltaMin", "adaptor_FcIfEventStatsHist_lossOfSyncCount", "adaptor_FcIfEventStatsHist_lossOfSyncCountDelta", "adaptor_FcIfEventStatsHist_lossOfSyncCountDeltaAvg", "adaptor_FcIfEventStatsHist_lossOfSyncCountDeltaMax", "adaptor_FcIfEventStatsHist_lossOfSyncCountDeltaMin", "adaptor_FcIfEventStatsHist_mostRecent", "adaptor_FcIfEventStatsHist_nOSCount", "adaptor_FcIfEventStatsHist_nOSCountDelta", "adaptor_FcIfEventStatsHist_nOSCountDeltaAvg", "adaptor_FcIfEventStatsHist_nOSCountDeltaMax", "adaptor_FcIfEventStatsHist_nOSCountDeltaMin", "adaptor_FcIfEventStatsHist_secondsSinceLastReset", "adaptor_FcIfEventStatsHist_secondsSinceLastResetDelta", "adaptor_FcIfEventStatsHist_secondsSinceLastResetDeltaAvg", "adaptor_FcIfEventStatsHist_secondsSinceLastResetDeltaMax", "adaptor_FcIfEventStatsHist_secondsSinceLastResetDeltaMin", "adaptor_FcIfEventStatsHist_seqProtocolErrCount", "adaptor_FcIfEventStatsHist_seqProtocolErrCountDelta", "adaptor_FcIfEventStatsHist_seqProtocolErrCountDeltaAvg", "adaptor_FcIfEventStatsHist_seqProtocolErrCountDeltaMax", "adaptor_FcIfEventStatsHist_seqProtocolErrCountDeltaMin", "adaptor_FcIfEventStatsHist_suspect", "adaptor_FcIfEventStatsHist_thresholded", "adaptor_FcIfEventStatsHist_timeCollected", "adaptor_FcIfEventStats_intervals", "adaptor_FcIfEventStats_invalidCRCCount", "adaptor_FcIfEventStats_invalidCRCCountDelta", "adaptor_FcIfEventStats_invalidCRCCountDeltaAvg", "adaptor_FcIfEventStats_invalidCRCCountDeltaMax", "adaptor_FcIfEventStats_invalidCRCCountDeltaMin", "adaptor_FcIfEventStats_linkFailureCount", "adaptor_FcIfEventStats_linkFailureCountDelta", "adaptor_FcIfEventStats_linkFailureCountDeltaAvg", "adaptor_FcIfEventStats_linkFailureCountDeltaMax", "adaptor_FcIfEventStats_linkFailureCountDeltaMin", "adaptor_FcIfEventStats_lipCount", "adaptor_FcIfEventStats_lipCountDelta", "adaptor_FcIfEventStats_lipCountDeltaAvg", "adaptor_FcIfEventStats_lipCountDeltaMax", "adaptor_FcIfEventStats_lipCountDeltaMin", "adaptor_FcIfEventStats_lossOfSignalCount", "adaptor_FcIfEventStats_lossOfSignalCountDelta", "adaptor_FcIfEventStats_lossOfSignalCountDeltaAvg", "adaptor_FcIfEventStats_lossOfSignalCountDeltaMax", "adaptor_FcIfEventStats_lossOfSignalCountDeltaMin", "adaptor_FcIfEventStats_lossOfSyncCount", "adaptor_FcIfEventStats_lossOfSyncCountDelta", "adaptor_FcIfEventStats_lossOfSyncCountDeltaAvg", "adaptor_FcIfEventStats_lossOfSyncCountDeltaMax", "adaptor_FcIfEventStats_lossOfSyncCountDeltaMin", "adaptor_FcIfEventStats_nOSCount", "adaptor_FcIfEventStats_nOSCountDelta", "adaptor_FcIfEventStats_nOSCountDeltaAvg", "adaptor_FcIfEventStats_nOSCountDeltaMax", "adaptor_FcIfEventStats_nOSCountDeltaMin", "adaptor_FcIfEventStats_secondsSinceLastReset", "adaptor_FcIfEventStats_secondsSinceLastResetDelta", "adaptor_FcIfEventStats_secondsSinceLastResetDeltaAvg", "adaptor_FcIfEventStats_secondsSinceLastResetDeltaMax", "adaptor_FcIfEventStats_secondsSinceLastResetDeltaMin", "adaptor_FcIfEventStats_seqProtocolErrCount", "adaptor_FcIfEventStats_seqProtocolErrCountDelta", "adaptor_FcIfEventStats_seqProtocolErrCountDeltaAvg", "adaptor_FcIfEventStats_seqProtocolErrCountDeltaMax", "adaptor_FcIfEventStats_seqProtocolErrCountDeltaMin", "adaptor_FcIfEventStats_suspect", "adaptor_FcIfEventStats_thresholded", "adaptor_FcIfEventStats_timeCollected", "adaptor_FcIfEventStats_update", "adaptor_FcIfFC4StatsHist_controlRequests", "adaptor_FcIfFC4StatsHist_controlRequestsDelta", "adaptor_FcIfFC4StatsHist_controlRequestsDeltaAvg", "adaptor_FcIfFC4StatsHist_controlRequestsDeltaMax", "adaptor_FcIfFC4StatsHist_controlRequestsDeltaMin", "adaptor_FcIfFC4StatsHist_id", "adaptor_FcIfFC4StatsHist_inputMegabytes", "adaptor_FcIfFC4StatsHist_inputMegabytesDelta", "adaptor_FcIfFC4StatsHist_inputMegabytesDeltaAvg", "adaptor_FcIfFC4StatsHist_inputMegabytesDeltaMax", "adaptor_FcIfFC4StatsHist_inputMegabytesDeltaMin", "adaptor_FcIfFC4StatsHist_inputRequests", "adaptor_FcIfFC4StatsHist_inputRequestsDelta", "adaptor_FcIfFC4StatsHist_inputRequestsDeltaAvg", "adaptor_FcIfFC4StatsHist_inputRequestsDeltaMax", "adaptor_FcIfFC4StatsHist_inputRequestsDeltaMin", "adaptor_FcIfFC4StatsHist_mostRecent", "adaptor_FcIfFC4StatsHist_outputMegabytes", "adaptor_FcIfFC4StatsHist_outputMegabytesDelta", "adaptor_FcIfFC4StatsHist_outputMegabytesDeltaAvg", "adaptor_FcIfFC4StatsHist_outputMegabytesDeltaMax", "adaptor_FcIfFC4StatsHist_outputMegabytesDeltaMin", "adaptor_FcIfFC4StatsHist_outputRequests", "adaptor_FcIfFC4StatsHist_outputRequestsDelta", "adaptor_FcIfFC4StatsHist_outputRequestsDeltaAvg", "adaptor_FcIfFC4StatsHist_outputRequestsDeltaMax", "adaptor_FcIfFC4StatsHist_outputRequestsDeltaMin", "adaptor_FcIfFC4StatsHist_suspect", "adaptor_FcIfFC4StatsHist_thresholded", "adaptor_FcIfFC4StatsHist_timeCollected", "adaptor_FcIfFC4Stats_controlRequests", "adaptor_FcIfFC4Stats_controlRequestsDelta", "adaptor_FcIfFC4Stats_controlRequestsDeltaAvg", "adaptor_FcIfFC4Stats_controlRequestsDeltaMax", "adaptor_FcIfFC4Stats_controlRequestsDeltaMin", "adaptor_FcIfFC4Stats_inputMegabytes", "adaptor_FcIfFC4Stats_inputMegabytesDelta", "adaptor_FcIfFC4Stats_inputMegabytesDeltaAvg", "adaptor_FcIfFC4Stats_inputMegabytesDeltaMax", "adaptor_FcIfFC4Stats_inputMegabytesDeltaMin", "adaptor_FcIfFC4Stats_inputRequests", "adaptor_FcIfFC4Stats_inputRequestsDelta", "adaptor_FcIfFC4Stats_inputRequestsDeltaAvg", "adaptor_FcIfFC4Stats_inputRequestsDeltaMax", "adaptor_FcIfFC4Stats_inputRequestsDeltaMin", "adaptor_FcIfFC4Stats_intervals", "adaptor_FcIfFC4Stats_outputMegabytes", "adaptor_FcIfFC4Stats_outputMegabytesDelta", "adaptor_FcIfFC4Stats_outputMegabytesDeltaAvg", "adaptor_FcIfFC4Stats_outputMegabytesDeltaMax", "adaptor_FcIfFC4Stats_outputMegabytesDeltaMin", "adaptor_FcIfFC4Stats_outputRequests", "adaptor_FcIfFC4Stats_outputRequestsDelta", "adaptor_FcIfFC4Stats_outputRequestsDeltaAvg", "adaptor_FcIfFC4Stats_outputRequestsDeltaMax", "adaptor_FcIfFC4Stats_outputRequestsDeltaMin", "adaptor_FcIfFC4Stats_suspect", "adaptor_FcIfFC4Stats_thresholded", "adaptor_FcIfFC4Stats_timeCollected", "adaptor_FcIfFC4Stats_update", "adaptor_FcIfFrameStatsHist_dumpedFrames", "adaptor_FcIfFrameStatsHist_dumpedFramesDelta", "adaptor_FcIfFrameStatsHist_dumpedFramesDeltaAvg", "adaptor_FcIfFrameStatsHist_dumpedFramesDeltaMax", "adaptor_FcIfFrameStatsHist_dumpedFramesDeltaMin", "adaptor_FcIfFrameStatsHist_errorFrames", "adaptor_FcIfFrameStatsHist_errorFramesDelta", "adaptor_FcIfFrameStatsHist_errorFramesDeltaAvg", "adaptor_FcIfFrameStatsHist_errorFramesDeltaMax", "adaptor_FcIfFrameStatsHist_errorFramesDeltaMin", "adaptor_FcIfFrameStatsHist_id", "adaptor_FcIfFrameStatsHist_mostRecent", "adaptor_FcIfFrameStatsHist_rxFrames", "adaptor_FcIfFrameStatsHist_rxFramesDelta", "adaptor_FcIfFrameStatsHist_rxFramesDeltaAvg", "adaptor_FcIfFrameStatsHist_rxFramesDeltaMax", "adaptor_FcIfFrameStatsHist_rxFramesDeltaMin", "adaptor_FcIfFrameStatsHist_suspect", "adaptor_FcIfFrameStatsHist_thresholded", "adaptor_FcIfFrameStatsHist_timeCollected", "adaptor_FcIfFrameStatsHist_txFrames", "adaptor_FcIfFrameStatsHist_txFramesDelta", "adaptor_FcIfFrameStatsHist_txFramesDeltaAvg", "adaptor_FcIfFrameStatsHist_txFramesDeltaMax", "adaptor_FcIfFrameStatsHist_txFramesDeltaMin", "adaptor_FcIfFrameStats_dumpedFrames", "adaptor_FcIfFrameStats_dumpedFramesDelta", "adaptor_FcIfFrameStats_dumpedFramesDeltaAvg", "adaptor_FcIfFrameStats_dumpedFramesDeltaMax", "adaptor_FcIfFrameStats_dumpedFramesDeltaMin", "adaptor_FcIfFrameStats_errorFrames", "adaptor_FcIfFrameStats_errorFramesDelta", "adaptor_FcIfFrameStats_errorFramesDeltaAvg", "adaptor_FcIfFrameStats_errorFramesDeltaMax", "adaptor_FcIfFrameStats_errorFramesDeltaMin", "adaptor_FcIfFrameStats_intervals", "adaptor_FcIfFrameStats_rxFrames", "adaptor_FcIfFrameStats_rxFramesDelta", "adaptor_FcIfFrameStats_rxFramesDeltaAvg", "adaptor_FcIfFrameStats_rxFramesDeltaMax", "adaptor_FcIfFrameStats_rxFramesDeltaMin", "adaptor_FcIfFrameStats_suspect", "adaptor_FcIfFrameStats_thresholded", "adaptor_FcIfFrameStats_timeCollected", "adaptor_FcIfFrameStats_txFrames", "adaptor_FcIfFrameStats_txFramesDelta", "adaptor_FcIfFrameStats_txFramesDeltaAvg", "adaptor_FcIfFrameStats_txFramesDeltaMax", "adaptor_FcIfFrameStats_txFramesDeltaMin", "adaptor_FcIfFrameStats_update", "adaptor_FcInterruptProfile_mode", "adaptor_FcLogiProfile_retries", "adaptor_FcLogiProfile_timeout", "adaptor_FcOEIf_epDn", "adaptor_FcOEIf_fcoeVlan", "adaptor_FcOEIf_id", "adaptor_FcOEIf_ifRole", "adaptor_FcOEIf_ifType", "adaptor_FcOEIf_lc", "adaptor_FcOEIf_locale", "adaptor_FcOEIf_mac", "adaptor_FcOEIf_name", "adaptor_FcOEIf_operState", "adaptor_FcOEIf_peerDn", "adaptor_FcOEIf_policyOwner", "adaptor_FcOEIf_switchId", "adaptor_FcOEIf_transport", "adaptor_FcOEIf_type", "adaptor_FcOEIf_zoningState", "adaptor_FcPortFLogiProfile_retries", "adaptor_FcPortFLogiProfile_timeout", "adaptor_FcPortPLogiProfile_retries", "adaptor_FcPortPLogiProfile_timeout", "adaptor_FcPortProfile_ioThrottleCount", "adaptor_FcPortProfile_lunsPerTarget", "adaptor_FcPortStatsHist_id", "adaptor_FcPortStatsHist_mostRecent", "adaptor_FcPortStatsHist_rxBadFrames", "adaptor_FcPortStatsHist_rxBadFramesDelta", "adaptor_FcPortStatsHist_rxBadFramesDeltaAvg", "adaptor_FcPortStatsHist_rxBadFramesDeltaMax", "adaptor_FcPortStatsHist_rxBadFramesDeltaMin", "adaptor_FcPortStatsHist_rxFrames", "adaptor_FcPortStatsHist_rxFramesDelta", "adaptor_FcPortStatsHist_rxFramesDeltaAvg", "adaptor_FcPortStatsHist_rxFramesDeltaMax", "adaptor_FcPortStatsHist_rxFramesDeltaMin", "adaptor_FcPortStatsHist_suspect", "adaptor_FcPortStatsHist_thresholded", "adaptor_FcPortStatsHist_timeCollected", "adaptor_FcPortStatsHist_txBadFrames", "adaptor_FcPortStatsHist_txBadFramesDelta", "adaptor_FcPortStatsHist_txBadFramesDeltaAvg", "adaptor_FcPortStatsHist_txBadFramesDeltaMax", "adaptor_FcPortStatsHist_txBadFramesDeltaMin", "adaptor_FcPortStatsHist_txFrames", "adaptor_FcPortStatsHist_txFramesDelta", "adaptor_FcPortStatsHist_txFramesDeltaAvg", "adaptor_FcPortStatsHist_txFramesDeltaMax", "adaptor_FcPortStatsHist_txFramesDeltaMin", "adaptor_FcPortStats_intervals", "adaptor_FcPortStats_rxBadFrames", "adaptor_FcPortStats_rxBadFramesDelta", "adaptor_FcPortStats_rxBadFramesDeltaAvg", "adaptor_FcPortStats_rxBadFramesDeltaMax", "adaptor_FcPortStats_rxBadFramesDeltaMin", "adaptor_FcPortStats_rxFrames", "adaptor_FcPortStats_rxFramesDelta", "adaptor_FcPortStats_rxFramesDeltaAvg", "adaptor_FcPortStats_rxFramesDeltaMax", "adaptor_FcPortStats_rxFramesDeltaMin", "adaptor_FcPortStats_suspect", "adaptor_FcPortStats_thresholded", "adaptor_FcPortStats_timeCollected", "adaptor_FcPortStats_txBadFrames", "adaptor_FcPortStats_txBadFramesDelta", "adaptor_FcPortStats_txBadFramesDeltaAvg", "adaptor_FcPortStats_txBadFramesDeltaMax", "adaptor_FcPortStats_txBadFramesDeltaMin", "adaptor_FcPortStats_txFrames", "adaptor_FcPortStats_txFramesDelta", "adaptor_FcPortStats_txFramesDeltaAvg", "adaptor_FcPortStats_txFramesDeltaMax", "adaptor_FcPortStats_txFramesDeltaMin", "adaptor_FcPortStats_update", "adaptor_FcQueueProfile_count", "adaptor_FcQueueProfile_ringSize", "adaptor_FcRecvQueueProfile_count", "adaptor_FcRecvQueueProfile_ringSize", "adaptor_FcWorkQueueProfile_count", "adaptor_FcWorkQueueProfile_ringSize", "adaptor_FruCapProvider_deleted", "adaptor_FruCapProvider_deprecated", "adaptor_FruCapProvider_elementLoadFailures", "adaptor_FruCapProvider_elementsLoaded", "adaptor_FruCapProvider_gencount", "adaptor_FruCapProvider_loadErrors", "adaptor_FruCapProvider_loadWarnings", "adaptor_FruCapProvider_mgmtPlaneVer", "adaptor_FruCapProvider_model", "adaptor_FruCapProvider_promCardType", "adaptor_FruCapProvider_revision", "adaptor_FruCapProvider_vendor", "adaptor_FruCapRef_isSupported", "adaptor_FruCapRef_model", "adaptor_FruCapRef_revision", "adaptor_FruCapRef_vendor", "adaptor_FwCapProvider_deleted", "adaptor_FwCapProvider_deprecated", "adaptor_FwCapProvider_elementLoadFailures", "adaptor_FwCapProvider_elementsLoaded", "adaptor_FwCapProvider_gencount", "adaptor_FwCapProvider_loadErrors", "adaptor_FwCapProvider_loadWarnings", "adaptor_FwCapProvider_mgmtPlaneVer", "adaptor_FwCapProvider_model", "adaptor_FwCapProvider_vendor", "adaptor_FwCapProvider_version", "adaptor_HostEthIfFsmStage_descr", "adaptor_HostEthIfFsmStage_lastUpdateTime", "adaptor_HostEthIfFsmStage_name", "adaptor_HostEthIfFsmStage_order", "adaptor_HostEthIfFsmStage_retry", "adaptor_HostEthIfFsmStage_stageStatus", "adaptor_HostEthIfFsmTask_completion", "adaptor_HostEthIfFsmTask_flags", "adaptor_HostEthIfFsmTask_item", "adaptor_HostEthIfFsmTask_seqId", "adaptor_HostEthIfFsm_completionTime", "adaptor_HostEthIfFsm_currentFsm", "adaptor_HostEthIfFsm_descr", "adaptor_HostEthIfFsm_fsmStatus", "adaptor_HostEthIfFsm_instanceId", "adaptor_HostEthIfFsm_progress", "adaptor_HostEthIfFsm_rmtErrCode", "adaptor_HostEthIfFsm_rmtErrDescr", "adaptor_HostEthIfFsm_rmtRslt", "adaptor_HostEthIfProfile_descr", "adaptor_HostEthIfProfile_intId", "adaptor_HostEthIfProfile_name", "adaptor_HostEthIfProfile_policyLevel", "adaptor_HostEthIfProfile_policyOwner", "adaptor_HostEthIf_adminState", "adaptor_HostEthIf_bootDev", "adaptor_HostEthIf_chassisId", "adaptor_HostEthIf_discovery", "adaptor_HostEthIf_epDn", "adaptor_HostEthIf_fsmDescr", "adaptor_HostEthIf_fsmPrev", "adaptor_HostEthIf_fsmProgr", "adaptor_HostEthIf_fsmRmtInvErrCode", "adaptor_HostEthIf_fsmRmtInvErrDescr", "adaptor_HostEthIf_fsmRmtInvRslt", "adaptor_HostEthIf_fsmStageDescr", "adaptor_HostEthIf_fsmStamp", "adaptor_HostEthIf_fsmStatus", "adaptor_HostEthIf_fsmTry", "adaptor_HostEthIf_id", "adaptor_HostEthIf_ifRole", "adaptor_HostEthIf_ifType", "adaptor_HostEthIf_lc", "adaptor_HostEthIf_linkState", "adaptor_HostEthIf_locale", "adaptor_HostEthIf_mac", "adaptor_HostEthIf_model", "adaptor_HostEthIf_mtu", "adaptor_HostEthIf_name", "adaptor_HostEthIf_operQualifierReason", "adaptor_HostEthIf_operState", "adaptor_HostEthIf_operability", "adaptor_HostEthIf_order", "adaptor_HostEthIf_originalMac", "adaptor_HostEthIf_pciAddr", "adaptor_HostEthIf_pciFunc", "adaptor_HostEthIf_pciSlot", "adaptor_HostEthIf_peerChassisId", "adaptor_HostEthIf_peerDn", "adaptor_HostEthIf_peerPortId", "adaptor_HostEthIf_peerSlotId", "adaptor_HostEthIf_perf", "adaptor_HostEthIf_pfDn", "adaptor_HostEthIf_portId", "adaptor_HostEthIf_power", "adaptor_HostEthIf_presence", "adaptor_HostEthIf_purpose", "adaptor_HostEthIf_revision", "adaptor_HostEthIf_serial", "adaptor_HostEthIf_side", "adaptor_HostEthIf_slotId", "adaptor_HostEthIf_switchId", "adaptor_HostEthIf_thermal", "adaptor_HostEthIf_transport", "adaptor_HostEthIf_type", "adaptor_HostEthIf_vendor", "adaptor_HostEthIf_virtualizationPreference", "adaptor_HostEthIf_vnicDn", "adaptor_HostEthIf_voltage", "adaptor_HostFcIfFsmStage_descr", "adaptor_HostFcIfFsmStage_lastUpdateTime", "adaptor_HostFcIfFsmStage_name", "adaptor_HostFcIfFsmStage_order", "adaptor_HostFcIfFsmStage_retry", "adaptor_HostFcIfFsmStage_stageStatus", "adaptor_HostFcIfFsmTask_completion", "adaptor_HostFcIfFsmTask_flags", "adaptor_HostFcIfFsmTask_item", "adaptor_HostFcIfFsmTask_seqId", "adaptor_HostFcIfFsm_completionTime", "adaptor_HostFcIfFsm_currentFsm", "adaptor_HostFcIfFsm_descr", "adaptor_HostFcIfFsm_fsmStatus", "adaptor_HostFcIfFsm_instanceId", "adaptor_HostFcIfFsm_progress", "adaptor_HostFcIfFsm_rmtErrCode", "adaptor_HostFcIfFsm_rmtErrDescr", "adaptor_HostFcIfFsm_rmtRslt", "adaptor_HostFcIfProfile_descr", "adaptor_HostFcIfProfile_intId", "adaptor_HostFcIfProfile_name", "adaptor_HostFcIfProfile_policyLevel", "adaptor_HostFcIfProfile_policyOwner", "adaptor_HostFcIf_adminState", "adaptor_HostFcIf_bootDev", "adaptor_HostFcIf_chassisId", "adaptor_HostFcIf_discovery", "adaptor_HostFcIf_epDn", "adaptor_HostFcIf_fsmDescr", "adaptor_HostFcIf_fsmPrev", "adaptor_HostFcIf_fsmProgr", "adaptor_HostFcIf_fsmRmtInvErrCode", "adaptor_HostFcIf_fsmRmtInvErrDescr", "adaptor_HostFcIf_fsmRmtInvRslt", "adaptor_HostFcIf_fsmStageDescr", "adaptor_HostFcIf_fsmStamp", "adaptor_HostFcIf_fsmStatus", "adaptor_HostFcIf_fsmTry", "adaptor_HostFcIf_id", "adaptor_HostFcIf_ifRole", "adaptor_HostFcIf_ifType", "adaptor_HostFcIf_lc", "adaptor_HostFcIf_linkState", "adaptor_HostFcIf_locale", "adaptor_HostFcIf_maxDataFieldSize", "adaptor_HostFcIf_model", "adaptor_HostFcIf_name", "adaptor_HostFcIf_nodeWwn", "adaptor_HostFcIf_operQualifierReason", "adaptor_HostFcIf_operState", "adaptor_HostFcIf_operability", "adaptor_HostFcIf_order", "adaptor_HostFcIf_originalNodeWwn", "adaptor_HostFcIf_originalWwn", "adaptor_HostFcIf_pciAddr", "adaptor_HostFcIf_pciFunc", "adaptor_HostFcIf_pciSlot", "adaptor_HostFcIf_peerChassisId", "adaptor_HostFcIf_peerDn", "adaptor_HostFcIf_peerPortId", "adaptor_HostFcIf_peerSlotId", "adaptor_HostFcIf_perf", "adaptor_HostFcIf_persBind", "adaptor_HostFcIf_portId", "adaptor_HostFcIf_power", "adaptor_HostFcIf_presence", "adaptor_HostFcIf_purpose", "adaptor_HostFcIf_revision", "adaptor_HostFcIf_serial", "adaptor_HostFcIf_side", "adaptor_HostFcIf_slotId", "adaptor_HostFcIf_switchId", "adaptor_HostFcIf_thermal", "adaptor_HostFcIf_transport", "adaptor_HostFcIf_type", "adaptor_HostFcIf_vendor", "adaptor_HostFcIf_vnicDn", "adaptor_HostFcIf_voltage", "adaptor_HostFcIf_wwn", "adaptor_HostIfConnDef_conPolicyName", "adaptor_HostIfProfile_descr", "adaptor_HostIfProfile_intId", "adaptor_HostIfProfile_name", "adaptor_HostIfProfile_policyLevel", "adaptor_HostIfProfile_policyOwner", "adaptor_HostIf_adminState", "adaptor_HostIf_bootDev", "adaptor_HostIf_chassisId", "adaptor_HostIf_discovery", "adaptor_HostIf_epDn", "adaptor_HostIf_id", "adaptor_HostIf_ifRole", "adaptor_HostIf_ifType", "adaptor_HostIf_lc", "adaptor_HostIf_linkState", "adaptor_HostIf_locale", "adaptor_HostIf_model", "adaptor_HostIf_name", "adaptor_HostIf_operQualifierReason", "adaptor_HostIf_operState", "adaptor_HostIf_operability", "adaptor_HostIf_order", "adaptor_HostIf_pciAddr", "adaptor_HostIf_pciFunc", "adaptor_HostIf_pciSlot", "adaptor_HostIf_peerChassisId", "adaptor_HostIf_peerDn", "adaptor_HostIf_peerPortId", "adaptor_HostIf_peerSlotId", "adaptor_HostIf_perf", "adaptor_HostIf_portId", "adaptor_HostIf_power", "adaptor_HostIf_presence", "adaptor_HostIf_purpose", "adaptor_HostIf_revision", "adaptor_HostIf_serial", "adaptor_HostIf_side", "adaptor_HostIf_slotId", "adaptor_HostIf_switchId", "adaptor_HostIf_thermal", "adaptor_HostIf_transport", "adaptor_HostIf_type", "adaptor_HostIf_vendor", "adaptor_HostIf_vnicDn", "adaptor_HostIf_voltage", "adaptor_HostIscsiIfProfile_descr", "adaptor_HostIscsiIfProfile_intId", "adaptor_HostIscsiIfProfile_name", "adaptor_HostIscsiIfProfile_policyLevel", "adaptor_HostIscsiIfProfile_policyOwner", "adaptor_HostIscsiIf_adminState", "adaptor_HostIscsiIf_bootDev", "adaptor_HostIscsiIf_chassisId", "adaptor_HostIscsiIf_discovery", "adaptor_HostIscsiIf_epDn", "adaptor_HostIscsiIf_ethEpDn", "adaptor_HostIscsiIf_hostVisible", "adaptor_HostIscsiIf_id", "adaptor_HostIscsiIf_ifRole", "adaptor_HostIscsiIf_ifType", "adaptor_HostIscsiIf_initiatorName", "adaptor_HostIscsiIf_lc", "adaptor_HostIscsiIf_linkState", "adaptor_HostIscsiIf_locale", "adaptor_HostIscsiIf_mac", "adaptor_HostIscsiIf_model", "adaptor_HostIscsiIf_name", "adaptor_HostIscsiIf_operQualifierReason", "adaptor_HostIscsiIf_operState", "adaptor_HostIscsiIf_operability", "adaptor_HostIscsiIf_order", "adaptor_HostIscsiIf_originalMac", "adaptor_HostIscsiIf_pciAddr", "adaptor_HostIscsiIf_pciFunc", "adaptor_HostIscsiIf_pciSlot", "adaptor_HostIscsiIf_peerChassisId", "adaptor_HostIscsiIf_peerDn", "adaptor_HostIscsiIf_peerPortId", "adaptor_HostIscsiIf_peerSlotId", "adaptor_HostIscsiIf_perf", "adaptor_HostIscsiIf_portId", "adaptor_HostIscsiIf_power", "adaptor_HostIscsiIf_presence", "adaptor_HostIscsiIf_purpose", "adaptor_HostIscsiIf_revision", "adaptor_HostIscsiIf_serial", "adaptor_HostIscsiIf_side", "adaptor_HostIscsiIf_slotId", "adaptor_HostIscsiIf_switchId", "adaptor_HostIscsiIf_thermal", "adaptor_HostIscsiIf_transport", "adaptor_HostIscsiIf_type", "adaptor_HostIscsiIf_vendor", "adaptor_HostIscsiIf_vnicDn", "adaptor_HostIscsiIf_vnicName", "adaptor_HostIscsiIf_voltage", "adaptor_HostMgmtCap_mode", "adaptor_HostMgmtCap_operPowerRequirement", "adaptor_HostMgmtCap_preboot", "adaptor_HostMgmtCap_presence", "adaptor_HostMgmtCap_rebootActionOnDestructive", "adaptor_HostServiceEthIf_adminState", "adaptor_HostServiceEthIf_bootDev", "adaptor_HostServiceEthIf_chassisId", "adaptor_HostServiceEthIf_discovery", "adaptor_HostServiceEthIf_epDn", "adaptor_HostServiceEthIf_id", "adaptor_HostServiceEthIf_ifRole", "adaptor_HostServiceEthIf_ifType", "adaptor_HostServiceEthIf_lc", "adaptor_HostServiceEthIf_linkState", "adaptor_HostServiceEthIf_locale", "adaptor_HostServiceEthIf_mac", "adaptor_HostServiceEthIf_model", "adaptor_HostServiceEthIf_mtu", "adaptor_HostServiceEthIf_name", "adaptor_HostServiceEthIf_operQualifierReason", "adaptor_HostServiceEthIf_operState", "adaptor_HostServiceEthIf_operability", "adaptor_HostServiceEthIf_order", "adaptor_HostServiceEthIf_originalMac", "adaptor_HostServiceEthIf_pciAddr", "adaptor_HostServiceEthIf_pciFunc", "adaptor_HostServiceEthIf_pciSlot", "adaptor_HostServiceEthIf_peerChassisId", "adaptor_HostServiceEthIf_peerDn", "adaptor_HostServiceEthIf_peerPortId", "adaptor_HostServiceEthIf_peerSlotId", "adaptor_HostServiceEthIf_perf", "adaptor_HostServiceEthIf_portId", "adaptor_HostServiceEthIf_power", "adaptor_HostServiceEthIf_presence", "adaptor_HostServiceEthIf_purpose", "adaptor_HostServiceEthIf_revision", "adaptor_HostServiceEthIf_serial", "adaptor_HostServiceEthIf_side", "adaptor_HostServiceEthIf_slotId", "adaptor_HostServiceEthIf_switchId", "adaptor_HostServiceEthIf_thermal", "adaptor_HostServiceEthIf_transport", "adaptor_HostServiceEthIf_type", "adaptor_HostServiceEthIf_vendor", "adaptor_HostServiceEthIf_vnicDn", "adaptor_HostServiceEthIf_voltage", "adaptor_HostethHwAddrCap_macOffset1", "adaptor_HostethHwAddrCap_macOffset2", "adaptor_HostfcHwAddrCap_macOffset1", "adaptor_HostfcHwAddrCap_macOffset2", "adaptor_HostfcHwAddrCap_wwnReverseMaskA", "adaptor_HostfcHwAddrCap_wwnReverseMaskB", "adaptor_HostfcHwAddrCap_wwnnReverseMaskA", "adaptor_HostfcHwAddrCap_wwnnReverseMaskB", "adaptor_HwAddrCap_macOffset1", "adaptor_HwAddrCap_macOffset2", "adaptor_IScsiCap_bootOrderType", "adaptor_IScsiCap_macOffset1", "adaptor_IScsiCap_macOffset2", "adaptor_IScsiCap_offloadSupport", "adaptor_IScsiCap_offloadType", "adaptor_IScsiCap_vlanForBoot", "adaptor_IpV4RssHashProfile_ipHash", "adaptor_IpV4RssHashProfile_tcpHash", "adaptor_IpV6RssHashProfile_ipHash", "adaptor_IpV6RssHashProfile_tcpHash", "adaptor_IscsiAuth_password", "adaptor_IscsiAuth_userId", "adaptor_IscsiProt_connectionTimeOut", "adaptor_IscsiProt_dhcpTimeOut", "adaptor_IscsiProt_initiatorName", "adaptor_IscsiProt_lunBusyRetryCount", "adaptor_IscsiProt_tcpTimeStamp", "adaptor_IscsiTargetIf_dhcpVendorId", "adaptor_IscsiTargetIf_ipAddress", "adaptor_IscsiTargetIf_lun", "adaptor_IscsiTargetIf_name", "adaptor_IscsiTargetIf_portNumber", "adaptor_IscsiTargetIf_priority", "adaptor_LanCap_defaultVlan", "adaptor_LinkStateHolder_linkState", "adaptor_LldpCap_support", "adaptor_MenloBaseErrorStatsHist_correctableErrors", "adaptor_MenloBaseErrorStatsHist_correctableErrorsDelta", "adaptor_MenloBaseErrorStatsHist_correctableErrorsDeltaAvg", "adaptor_MenloBaseErrorStatsHist_correctableErrorsDeltaMax", "adaptor_MenloBaseErrorStatsHist_correctableErrorsDeltaMin", "adaptor_MenloBaseErrorStatsHist_id", "adaptor_MenloBaseErrorStatsHist_mostRecent", "adaptor_MenloBaseErrorStatsHist_suspect", "adaptor_MenloBaseErrorStatsHist_thresholded", "adaptor_MenloBaseErrorStatsHist_timeCollected", "adaptor_MenloBaseErrorStatsHist_uncorrectableErrors", "adaptor_MenloBaseErrorStatsHist_uncorrectableErrorsDelta", "adaptor_MenloBaseErrorStatsHist_uncorrectableErrorsDeltaAvg", "adaptor_MenloBaseErrorStatsHist_uncorrectableErrorsDeltaMax", "adaptor_MenloBaseErrorStatsHist_uncorrectableErrorsDeltaMin", "adaptor_MenloBaseErrorStats_correctableErrors", "adaptor_MenloBaseErrorStats_correctableErrorsDelta", "adaptor_MenloBaseErrorStats_correctableErrorsDeltaAvg", "adaptor_MenloBaseErrorStats_correctableErrorsDeltaMax", "adaptor_MenloBaseErrorStats_correctableErrorsDeltaMin", "adaptor_MenloBaseErrorStats_intervals", "adaptor_MenloBaseErrorStats_suspect", "adaptor_MenloBaseErrorStats_thresholded", "adaptor_MenloBaseErrorStats_timeCollected", "adaptor_MenloBaseErrorStats_uncorrectableErrors", "adaptor_MenloBaseErrorStats_uncorrectableErrorsDelta", "adaptor_MenloBaseErrorStats_uncorrectableErrorsDeltaAvg", "adaptor_MenloBaseErrorStats_uncorrectableErrorsDeltaMax", "adaptor_MenloBaseErrorStats_uncorrectableErrorsDeltaMin", "adaptor_MenloBaseErrorStats_update", "adaptor_MenloDcePortStatsHist_id", "adaptor_MenloDcePortStatsHist_mostRecent", "adaptor_MenloDcePortStatsHist_rxPauseCFC", "adaptor_MenloDcePortStatsHist_rxPauseCFCDelta", "adaptor_MenloDcePortStatsHist_rxPauseCFCDeltaAvg", "adaptor_MenloDcePortStatsHist_rxPauseCFCDeltaMax", "adaptor_MenloDcePortStatsHist_rxPauseCFCDeltaMin", "adaptor_MenloDcePortStatsHist_rxPausePFC", "adaptor_MenloDcePortStatsHist_rxPausePFCDelta", "adaptor_MenloDcePortStatsHist_rxPausePFCDeltaAvg", "adaptor_MenloDcePortStatsHist_rxPausePFCDeltaMax", "adaptor_MenloDcePortStatsHist_rxPausePFCDeltaMin", "adaptor_MenloDcePortStatsHist_suspect", "adaptor_MenloDcePortStatsHist_thresholded", "adaptor_MenloDcePortStatsHist_timeCollected", "adaptor_MenloDcePortStatsHist_txPauseCFC", "adaptor_MenloDcePortStatsHist_txPauseCFCDelta", "adaptor_MenloDcePortStatsHist_txPauseCFCDeltaAvg", "adaptor_MenloDcePortStatsHist_txPauseCFCDeltaMax", "adaptor_MenloDcePortStatsHist_txPauseCFCDeltaMin", "adaptor_MenloDcePortStatsHist_txPausePFC", "adaptor_MenloDcePortStatsHist_txPausePFCDelta", "adaptor_MenloDcePortStatsHist_txPausePFCDeltaAvg", "adaptor_MenloDcePortStatsHist_txPausePFCDeltaMax", "adaptor_MenloDcePortStatsHist_txPausePFCDeltaMin", "adaptor_MenloDcePortStats_intervals", "adaptor_MenloDcePortStats_menloPortIndex", "adaptor_MenloDcePortStats_rxPauseCFC", "adaptor_MenloDcePortStats_rxPauseCFCDelta", "adaptor_MenloDcePortStats_rxPauseCFCDeltaAvg", "adaptor_MenloDcePortStats_rxPauseCFCDeltaMax", "adaptor_MenloDcePortStats_rxPauseCFCDeltaMin", "adaptor_MenloDcePortStats_rxPausePFC", "adaptor_MenloDcePortStats_rxPausePFCDelta", "adaptor_MenloDcePortStats_rxPausePFCDeltaAvg", "adaptor_MenloDcePortStats_rxPausePFCDeltaMax", "adaptor_MenloDcePortStats_rxPausePFCDeltaMin", "adaptor_MenloDcePortStats_suspect", "adaptor_MenloDcePortStats_thresholded", "adaptor_MenloDcePortStats_timeCollected", "adaptor_MenloDcePortStats_txPauseCFC", "adaptor_MenloDcePortStats_txPauseCFCDelta", "adaptor_MenloDcePortStats_txPauseCFCDeltaAvg", "adaptor_MenloDcePortStats_txPauseCFCDeltaMax", "adaptor_MenloDcePortStats_txPauseCFCDeltaMin", "adaptor_MenloDcePortStats_txPausePFC", "adaptor_MenloDcePortStats_txPausePFCDelta", "adaptor_MenloDcePortStats_txPausePFCDeltaAvg", "adaptor_MenloDcePortStats_txPausePFCDeltaMax", "adaptor_MenloDcePortStats_txPausePFCDeltaMin", "adaptor_MenloDcePortStats_update", "adaptor_MenloEthErrorStatsHist_correctableErrors", "adaptor_MenloEthErrorStatsHist_correctableErrorsDelta", "adaptor_MenloEthErrorStatsHist_correctableErrorsDeltaAvg", "adaptor_MenloEthErrorStatsHist_correctableErrorsDeltaMax", "adaptor_MenloEthErrorStatsHist_correctableErrorsDeltaMin", "adaptor_MenloEthErrorStatsHist_dropAcl", "adaptor_MenloEthErrorStatsHist_dropAclDelta", "adaptor_MenloEthErrorStatsHist_dropAclDeltaAvg", "adaptor_MenloEthErrorStatsHist_dropAclDeltaMax", "adaptor_MenloEthErrorStatsHist_dropAclDeltaMin", "adaptor_MenloEthErrorStatsHist_id", "adaptor_MenloEthErrorStatsHist_mostRecent", "adaptor_MenloEthErrorStatsHist_popErrors", "adaptor_MenloEthErrorStatsHist_popErrorsDelta", "adaptor_MenloEthErrorStatsHist_popErrorsDeltaAvg", "adaptor_MenloEthErrorStatsHist_popErrorsDeltaMax", "adaptor_MenloEthErrorStatsHist_popErrorsDeltaMin", "adaptor_MenloEthErrorStatsHist_pushErrors", "adaptor_MenloEthErrorStatsHist_pushErrorsDelta", "adaptor_MenloEthErrorStatsHist_pushErrorsDeltaAvg", "adaptor_MenloEthErrorStatsHist_pushErrorsDeltaMax", "adaptor_MenloEthErrorStatsHist_pushErrorsDeltaMin", "adaptor_MenloEthErrorStatsHist_suspect", "adaptor_MenloEthErrorStatsHist_thresholded", "adaptor_MenloEthErrorStatsHist_timeCollected", "adaptor_MenloEthErrorStatsHist_uncorrectableErrors", "adaptor_MenloEthErrorStatsHist_uncorrectableErrorsDelta", "adaptor_MenloEthErrorStatsHist_uncorrectableErrorsDeltaAvg", "adaptor_MenloEthErrorStatsHist_uncorrectableErrorsDeltaMax", "adaptor_MenloEthErrorStatsHist_uncorrectableErrorsDeltaMin", "adaptor_MenloEthErrorStats_correctableErrors", "adaptor_MenloEthErrorStats_correctableErrorsDelta", "adaptor_MenloEthErrorStats_correctableErrorsDeltaAvg", "adaptor_MenloEthErrorStats_correctableErrorsDeltaMax", "adaptor_MenloEthErrorStats_correctableErrorsDeltaMin", "adaptor_MenloEthErrorStats_dropAcl", "adaptor_MenloEthErrorStats_dropAclDelta", "adaptor_MenloEthErrorStats_dropAclDeltaAvg", "adaptor_MenloEthErrorStats_dropAclDeltaMax", "adaptor_MenloEthErrorStats_dropAclDeltaMin", "adaptor_MenloEthErrorStats_intervals", "adaptor_MenloEthErrorStats_menloEthIndex", "adaptor_MenloEthErrorStats_popErrors", "adaptor_MenloEthErrorStats_popErrorsDelta", "adaptor_MenloEthErrorStats_popErrorsDeltaAvg", "adaptor_MenloEthErrorStats_popErrorsDeltaMax", "adaptor_MenloEthErrorStats_popErrorsDeltaMin", "adaptor_MenloEthErrorStats_pushErrors", "adaptor_MenloEthErrorStats_pushErrorsDelta", "adaptor_MenloEthErrorStats_pushErrorsDeltaAvg", "adaptor_MenloEthErrorStats_pushErrorsDeltaMax", "adaptor_MenloEthErrorStats_pushErrorsDeltaMin", "adaptor_MenloEthErrorStats_suspect", "adaptor_MenloEthErrorStats_thresholded", "adaptor_MenloEthErrorStats_timeCollected", "adaptor_MenloEthErrorStats_uncorrectableErrors", "adaptor_MenloEthErrorStats_uncorrectableErrorsDelta", "adaptor_MenloEthErrorStats_uncorrectableErrorsDeltaAvg", "adaptor_MenloEthErrorStats_uncorrectableErrorsDeltaMax", "adaptor_MenloEthErrorStats_uncorrectableErrorsDeltaMin", "adaptor_MenloEthErrorStats_update", "adaptor_MenloEthStatsHist_dropOverrun", "adaptor_MenloEthStatsHist_dropOverrunDelta", "adaptor_MenloEthStatsHist_dropOverrunDeltaAvg", "adaptor_MenloEthStatsHist_dropOverrunDeltaMax", "adaptor_MenloEthStatsHist_dropOverrunDeltaMin", "adaptor_MenloEthStatsHist_dropRunt", "adaptor_MenloEthStatsHist_dropRuntDelta", "adaptor_MenloEthStatsHist_dropRuntDeltaAvg", "adaptor_MenloEthStatsHist_dropRuntDeltaMax", "adaptor_MenloEthStatsHist_dropRuntDeltaMin", "adaptor_MenloEthStatsHist_id", "adaptor_MenloEthStatsHist_mostRecent", "adaptor_MenloEthStatsHist_suspect", "adaptor_MenloEthStatsHist_thresholded", "adaptor_MenloEthStatsHist_timeCollected", "adaptor_MenloEthStatsHist_truncateOverrun", "adaptor_MenloEthStatsHist_truncateOverrunDelta", "adaptor_MenloEthStatsHist_truncateOverrunDeltaAvg", "adaptor_MenloEthStatsHist_truncateOverrunDeltaMax", "adaptor_MenloEthStatsHist_truncateOverrunDeltaMin", "adaptor_MenloEthStats_dropOverrun", "adaptor_MenloEthStats_dropOverrunDelta", "adaptor_MenloEthStats_dropOverrunDeltaAvg", "adaptor_MenloEthStats_dropOverrunDeltaMax", "adaptor_MenloEthStats_dropOverrunDeltaMin", "adaptor_MenloEthStats_dropRunt", "adaptor_MenloEthStats_dropRuntDelta", "adaptor_MenloEthStats_dropRuntDeltaAvg", "adaptor_MenloEthStats_dropRuntDeltaMax", "adaptor_MenloEthStats_dropRuntDeltaMin", "adaptor_MenloEthStats_intervals", "adaptor_MenloEthStats_menloEthIndex", "adaptor_MenloEthStats_suspect", "adaptor_MenloEthStats_thresholded", "adaptor_MenloEthStats_timeCollected", "adaptor_MenloEthStats_truncateOverrun", "adaptor_MenloEthStats_truncateOverrunDelta", "adaptor_MenloEthStats_truncateOverrunDeltaAvg", "adaptor_MenloEthStats_truncateOverrunDeltaMax", "adaptor_MenloEthStats_truncateOverrunDeltaMin", "adaptor_MenloEthStats_update", "adaptor_MenloFcErrorStatsHist_correctableErrors", "adaptor_MenloFcErrorStatsHist_correctableErrorsDelta", "adaptor_MenloFcErrorStatsHist_correctableErrorsDeltaAvg", "adaptor_MenloFcErrorStatsHist_correctableErrorsDeltaMax", "adaptor_MenloFcErrorStatsHist_correctableErrorsDeltaMin", "adaptor_MenloFcErrorStatsHist_id", "adaptor_MenloFcErrorStatsHist_mostRecent", "adaptor_MenloFcErrorStatsHist_popErrors", "adaptor_MenloFcErrorStatsHist_popErrorsDelta", "adaptor_MenloFcErrorStatsHist_popErrorsDeltaAvg", "adaptor_MenloFcErrorStatsHist_popErrorsDeltaMax", "adaptor_MenloFcErrorStatsHist_popErrorsDeltaMin", "adaptor_MenloFcErrorStatsHist_pushErrors", "adaptor_MenloFcErrorStatsHist_pushErrorsDelta", "adaptor_MenloFcErrorStatsHist_pushErrorsDeltaAvg", "adaptor_MenloFcErrorStatsHist_pushErrorsDeltaMax", "adaptor_MenloFcErrorStatsHist_pushErrorsDeltaMin", "adaptor_MenloFcErrorStatsHist_suspect", "adaptor_MenloFcErrorStatsHist_thresholded", "adaptor_MenloFcErrorStatsHist_timeCollected", "adaptor_MenloFcErrorStatsHist_uncorrectableErrors", "adaptor_MenloFcErrorStatsHist_uncorrectableErrorsDelta", "adaptor_MenloFcErrorStatsHist_uncorrectableErrorsDeltaAvg", "adaptor_MenloFcErrorStatsHist_uncorrectableErrorsDeltaMax", "adaptor_MenloFcErrorStatsHist_uncorrectableErrorsDeltaMin", "adaptor_MenloFcErrorStats_correctableErrors", "adaptor_MenloFcErrorStats_correctableErrorsDelta", "adaptor_MenloFcErrorStats_correctableErrorsDeltaAvg", "adaptor_MenloFcErrorStats_correctableErrorsDeltaMax", "adaptor_MenloFcErrorStats_correctableErrorsDeltaMin", "adaptor_MenloFcErrorStats_intervals", "adaptor_MenloFcErrorStats_menloFcIndex", "adaptor_MenloFcErrorStats_popErrors", "adaptor_MenloFcErrorStats_popErrorsDelta", "adaptor_MenloFcErrorStats_popErrorsDeltaAvg", "adaptor_MenloFcErrorStats_popErrorsDeltaMax", "adaptor_MenloFcErrorStats_popErrorsDeltaMin", "adaptor_MenloFcErrorStats_pushErrors", "adaptor_MenloFcErrorStats_pushErrorsDelta", "adaptor_MenloFcErrorStats_pushErrorsDeltaAvg", "adaptor_MenloFcErrorStats_pushErrorsDeltaMax", "adaptor_MenloFcErrorStats_pushErrorsDeltaMin", "adaptor_MenloFcErrorStats_suspect", "adaptor_MenloFcErrorStats_thresholded", "adaptor_MenloFcErrorStats_timeCollected", "adaptor_MenloFcErrorStats_uncorrectableErrors", "adaptor_MenloFcErrorStats_uncorrectableErrorsDelta", "adaptor_MenloFcErrorStats_uncorrectableErrorsDeltaAvg", "adaptor_MenloFcErrorStats_uncorrectableErrorsDeltaMax", "adaptor_MenloFcErrorStats_uncorrectableErrorsDeltaMin", "adaptor_MenloFcErrorStats_update", "adaptor_MenloFcStatsHist_dropAcl", "adaptor_MenloFcStatsHist_dropAclDelta", "adaptor_MenloFcStatsHist_dropAclDeltaAvg", "adaptor_MenloFcStatsHist_dropAclDeltaMax", "adaptor_MenloFcStatsHist_dropAclDeltaMin", "adaptor_MenloFcStatsHist_dropOverrun", "adaptor_MenloFcStatsHist_dropOverrunDelta", "adaptor_MenloFcStatsHist_dropOverrunDeltaAvg", "adaptor_MenloFcStatsHist_dropOverrunDeltaMax", "adaptor_MenloFcStatsHist_dropOverrunDeltaMin", "adaptor_MenloFcStatsHist_dropRunt", "adaptor_MenloFcStatsHist_dropRuntDelta", "adaptor_MenloFcStatsHist_dropRuntDeltaAvg", "adaptor_MenloFcStatsHist_dropRuntDeltaMax", "adaptor_MenloFcStatsHist_dropRuntDeltaMin", "adaptor_MenloFcStatsHist_id", "adaptor_MenloFcStatsHist_mostRecent", "adaptor_MenloFcStatsHist_suspect", "adaptor_MenloFcStatsHist_thresholded", "adaptor_MenloFcStatsHist_timeCollected", "adaptor_MenloFcStatsHist_truncateOverrun", "adaptor_MenloFcStatsHist_truncateOverrunDelta", "adaptor_MenloFcStatsHist_truncateOverrunDeltaAvg", "adaptor_MenloFcStatsHist_truncateOverrunDeltaMax", "adaptor_MenloFcStatsHist_truncateOverrunDeltaMin", "adaptor_MenloFcStats_dropAcl", "adaptor_MenloFcStats_dropAclDelta", "adaptor_MenloFcStats_dropAclDeltaAvg", "adaptor_MenloFcStats_dropAclDeltaMax", "adaptor_MenloFcStats_dropAclDeltaMin", "adaptor_MenloFcStats_dropOverrun", "adaptor_MenloFcStats_dropOverrunDelta", "adaptor_MenloFcStats_dropOverrunDeltaAvg", "adaptor_MenloFcStats_dropOverrunDeltaMax", "adaptor_MenloFcStats_dropOverrunDeltaMin", "adaptor_MenloFcStats_dropRunt", "adaptor_MenloFcStats_dropRuntDelta", "adaptor_MenloFcStats_dropRuntDeltaAvg", "adaptor_MenloFcStats_dropRuntDeltaMax", "adaptor_MenloFcStats_dropRuntDeltaMin", "adaptor_MenloFcStats_intervals", "adaptor_MenloFcStats_menloFcIndex", "adaptor_MenloFcStats_suspect", "adaptor_MenloFcStats_thresholded", "adaptor_MenloFcStats_timeCollected", "adaptor_MenloFcStats_truncateOverrun", "adaptor_MenloFcStats_truncateOverrunDelta", "adaptor_MenloFcStats_truncateOverrunDeltaAvg", "adaptor_MenloFcStats_truncateOverrunDeltaMax", "adaptor_MenloFcStats_truncateOverrunDeltaMin", "adaptor_MenloFcStats_update", "adaptor_MenloHostPortStatsHist_id", "adaptor_MenloHostPortStatsHist_mostRecent", "adaptor_MenloHostPortStatsHist_rxPauseCFC", "adaptor_MenloHostPortStatsHist_rxPauseCFCDelta", "adaptor_MenloHostPortStatsHist_rxPauseCFCDeltaAvg", "adaptor_MenloHostPortStatsHist_rxPauseCFCDeltaMax", "adaptor_MenloHostPortStatsHist_rxPauseCFCDeltaMin", "adaptor_MenloHostPortStatsHist_rxPausePFC", "adaptor_MenloHostPortStatsHist_rxPausePFCDelta", "adaptor_MenloHostPortStatsHist_rxPausePFCDeltaAvg", "adaptor_MenloHostPortStatsHist_rxPausePFCDeltaMax", "adaptor_MenloHostPortStatsHist_rxPausePFCDeltaMin", "adaptor_MenloHostPortStatsHist_suspect", "adaptor_MenloHostPortStatsHist_thresholded", "adaptor_MenloHostPortStatsHist_timeCollected", "adaptor_MenloHostPortStatsHist_txPauseCFC", "adaptor_MenloHostPortStatsHist_txPauseCFCDelta", "adaptor_MenloHostPortStatsHist_txPauseCFCDeltaAvg", "adaptor_MenloHostPortStatsHist_txPauseCFCDeltaMax", "adaptor_MenloHostPortStatsHist_txPauseCFCDeltaMin", "adaptor_MenloHostPortStatsHist_txPausePFC", "adaptor_MenloHostPortStatsHist_txPausePFCDelta", "adaptor_MenloHostPortStatsHist_txPausePFCDeltaAvg", "adaptor_MenloHostPortStatsHist_txPausePFCDeltaMax", "adaptor_MenloHostPortStatsHist_txPausePFCDeltaMin", "adaptor_MenloHostPortStats_intervals", "adaptor_MenloHostPortStats_menloPortIndex", "adaptor_MenloHostPortStats_rxPauseCFC", "adaptor_MenloHostPortStats_rxPauseCFCDelta", "adaptor_MenloHostPortStats_rxPauseCFCDeltaAvg", "adaptor_MenloHostPortStats_rxPauseCFCDeltaMax", "adaptor_MenloHostPortStats_rxPauseCFCDeltaMin", "adaptor_MenloHostPortStats_rxPausePFC", "adaptor_MenloHostPortStats_rxPausePFCDelta", "adaptor_MenloHostPortStats_rxPausePFCDeltaAvg", "adaptor_MenloHostPortStats_rxPausePFCDeltaMax", "adaptor_MenloHostPortStats_rxPausePFCDeltaMin", "adaptor_MenloHostPortStats_suspect", "adaptor_MenloHostPortStats_thresholded", "adaptor_MenloHostPortStats_timeCollected", "adaptor_MenloHostPortStats_txPauseCFC", "adaptor_MenloHostPortStats_txPauseCFCDelta", "adaptor_MenloHostPortStats_txPauseCFCDeltaAvg", "adaptor_MenloHostPortStats_txPauseCFCDeltaMax", "adaptor_MenloHostPortStats_txPauseCFCDeltaMin", "adaptor_MenloHostPortStats_txPausePFC", "adaptor_MenloHostPortStats_txPausePFCDelta", "adaptor_MenloHostPortStats_txPausePFCDeltaAvg", "adaptor_MenloHostPortStats_txPausePFCDeltaMax", "adaptor_MenloHostPortStats_txPausePFCDeltaMin", "adaptor_MenloHostPortStats_update", "adaptor_MenloMcpuErrorStatsHist_correctableErrors", "adaptor_MenloMcpuErrorStatsHist_correctableErrorsDelta", "adaptor_MenloMcpuErrorStatsHist_correctableErrorsDeltaAvg", "adaptor_MenloMcpuErrorStatsHist_correctableErrorsDeltaMax", "adaptor_MenloMcpuErrorStatsHist_correctableErrorsDeltaMin", "adaptor_MenloMcpuErrorStatsHist_id", "adaptor_MenloMcpuErrorStatsHist_mostRecent", "adaptor_MenloMcpuErrorStatsHist_popErrors", "adaptor_MenloMcpuErrorStatsHist_popErrorsDelta", "adaptor_MenloMcpuErrorStatsHist_popErrorsDeltaAvg", "adaptor_MenloMcpuErrorStatsHist_popErrorsDeltaMax", "adaptor_MenloMcpuErrorStatsHist_popErrorsDeltaMin", "adaptor_MenloMcpuErrorStatsHist_pushErrors", "adaptor_MenloMcpuErrorStatsHist_pushErrorsDelta", "adaptor_MenloMcpuErrorStatsHist_pushErrorsDeltaAvg", "adaptor_MenloMcpuErrorStatsHist_pushErrorsDeltaMax", "adaptor_MenloMcpuErrorStatsHist_pushErrorsDeltaMin", "adaptor_MenloMcpuErrorStatsHist_suspect", "adaptor_MenloMcpuErrorStatsHist_thresholded", "adaptor_MenloMcpuErrorStatsHist_timeCollected", "adaptor_MenloMcpuErrorStatsHist_uncorrectableErrors", "adaptor_MenloMcpuErrorStatsHist_uncorrectableErrorsDelta", "adaptor_MenloMcpuErrorStatsHist_uncorrectableErrorsDeltaAvg", "adaptor_MenloMcpuErrorStatsHist_uncorrectableErrorsDeltaMax", "adaptor_MenloMcpuErrorStatsHist_uncorrectableErrorsDeltaMin", "adaptor_MenloMcpuErrorStats_correctableErrors", "adaptor_MenloMcpuErrorStats_correctableErrorsDelta", "adaptor_MenloMcpuErrorStats_correctableErrorsDeltaAvg", "adaptor_MenloMcpuErrorStats_correctableErrorsDeltaMax", "adaptor_MenloMcpuErrorStats_correctableErrorsDeltaMin", "adaptor_MenloMcpuErrorStats_intervals", "adaptor_MenloMcpuErrorStats_menloMcpuIndex", "adaptor_MenloMcpuErrorStats_popErrors", "adaptor_MenloMcpuErrorStats_popErrorsDelta", "adaptor_MenloMcpuErrorStats_popErrorsDeltaAvg", "adaptor_MenloMcpuErrorStats_popErrorsDeltaMax", "adaptor_MenloMcpuErrorStats_popErrorsDeltaMin", "adaptor_MenloMcpuErrorStats_pushErrors", "adaptor_MenloMcpuErrorStats_pushErrorsDelta", "adaptor_MenloMcpuErrorStats_pushErrorsDeltaAvg", "adaptor_MenloMcpuErrorStats_pushErrorsDeltaMax", "adaptor_MenloMcpuErrorStats_pushErrorsDeltaMin", "adaptor_MenloMcpuErrorStats_suspect", "adaptor_MenloMcpuErrorStats_thresholded", "adaptor_MenloMcpuErrorStats_timeCollected", "adaptor_MenloMcpuErrorStats_uncorrectableErrors", "adaptor_MenloMcpuErrorStats_uncorrectableErrorsDelta", "adaptor_MenloMcpuErrorStats_uncorrectableErrorsDeltaAvg", "adaptor_MenloMcpuErrorStats_uncorrectableErrorsDeltaMax", "adaptor_MenloMcpuErrorStats_uncorrectableErrorsDeltaMin", "adaptor_MenloMcpuErrorStats_update", "adaptor_MenloMcpuStatsHist_dropAcl", "adaptor_MenloMcpuStatsHist_dropAclDelta", "adaptor_MenloMcpuStatsHist_dropAclDeltaAvg", "adaptor_MenloMcpuStatsHist_dropAclDeltaMax", "adaptor_MenloMcpuStatsHist_dropAclDeltaMin", "adaptor_MenloMcpuStatsHist_dropOverrun", "adaptor_MenloMcpuStatsHist_dropOverrunDelta", "adaptor_MenloMcpuStatsHist_dropOverrunDeltaAvg", "adaptor_MenloMcpuStatsHist_dropOverrunDeltaMax", "adaptor_MenloMcpuStatsHist_dropOverrunDeltaMin", "adaptor_MenloMcpuStatsHist_dropRunt", "adaptor_MenloMcpuStatsHist_dropRuntDelta", "adaptor_MenloMcpuStatsHist_dropRuntDeltaAvg", "adaptor_MenloMcpuStatsHist_dropRuntDeltaMax", "adaptor_MenloMcpuStatsHist_dropRuntDeltaMin", "adaptor_MenloMcpuStatsHist_id", "adaptor_MenloMcpuStatsHist_mostRecent", "adaptor_MenloMcpuStatsHist_suspect", "adaptor_MenloMcpuStatsHist_thresholded", "adaptor_MenloMcpuStatsHist_timeCollected", "adaptor_MenloMcpuStatsHist_truncateOverrun", "adaptor_MenloMcpuStatsHist_truncateOverrunDelta", "adaptor_MenloMcpuStatsHist_truncateOverrunDeltaAvg", "adaptor_MenloMcpuStatsHist_truncateOverrunDeltaMax", "adaptor_MenloMcpuStatsHist_truncateOverrunDeltaMin", "adaptor_MenloMcpuStats_dropAcl", "adaptor_MenloMcpuStats_dropAclDelta", "adaptor_MenloMcpuStats_dropAclDeltaAvg", "adaptor_MenloMcpuStats_dropAclDeltaMax", "adaptor_MenloMcpuStats_dropAclDeltaMin", "adaptor_MenloMcpuStats_dropOverrun", "adaptor_MenloMcpuStats_dropOverrunDelta", "adaptor_MenloMcpuStats_dropOverrunDeltaAvg", "adaptor_MenloMcpuStats_dropOverrunDeltaMax", "adaptor_MenloMcpuStats_dropOverrunDeltaMin", "adaptor_MenloMcpuStats_dropRunt", "adaptor_MenloMcpuStats_dropRuntDelta", "adaptor_MenloMcpuStats_dropRuntDeltaAvg", "adaptor_MenloMcpuStats_dropRuntDeltaMax", "adaptor_MenloMcpuStats_dropRuntDeltaMin", "adaptor_MenloMcpuStats_intervals", "adaptor_MenloMcpuStats_menloMcpuIndex", "adaptor_MenloMcpuStats_suspect", "adaptor_MenloMcpuStats_thresholded", "adaptor_MenloMcpuStats_timeCollected", "adaptor_MenloMcpuStats_truncateOverrun", "adaptor_MenloMcpuStats_truncateOverrunDelta", "adaptor_MenloMcpuStats_truncateOverrunDeltaAvg", "adaptor_MenloMcpuStats_truncateOverrunDeltaMax", "adaptor_MenloMcpuStats_truncateOverrunDeltaMin", "adaptor_MenloMcpuStats_update", "adaptor_MenloNetEgStatsHist_dropCmd", "adaptor_MenloNetEgStatsHist_dropCmdDelta", "adaptor_MenloNetEgStatsHist_dropCmdDeltaAvg", "adaptor_MenloNetEgStatsHist_dropCmdDeltaMax", "adaptor_MenloNetEgStatsHist_dropCmdDeltaMin", "adaptor_MenloNetEgStatsHist_dropLifCfgInvalid", "adaptor_MenloNetEgStatsHist_dropLifCfgInvalidDelta", "adaptor_MenloNetEgStatsHist_dropLifCfgInvalidDeltaAvg", "adaptor_MenloNetEgStatsHist_dropLifCfgInvalidDeltaMax", "adaptor_MenloNetEgStatsHist_dropLifCfgInvalidDeltaMin", "adaptor_MenloNetEgStatsHist_dropLifMapNoHit", "adaptor_MenloNetEgStatsHist_dropLifMapNoHitDelta", "adaptor_MenloNetEgStatsHist_dropLifMapNoHitDeltaAvg", "adaptor_MenloNetEgStatsHist_dropLifMapNoHitDeltaMax", "adaptor_MenloNetEgStatsHist_dropLifMapNoHitDeltaMin", "adaptor_MenloNetEgStatsHist_dropSrcBind", "adaptor_MenloNetEgStatsHist_dropSrcBindDelta", "adaptor_MenloNetEgStatsHist_dropSrcBindDeltaAvg", "adaptor_MenloNetEgStatsHist_dropSrcBindDeltaMax", "adaptor_MenloNetEgStatsHist_dropSrcBindDeltaMin", "adaptor_MenloNetEgStatsHist_id", "adaptor_MenloNetEgStatsHist_learnReqDrop", "adaptor_MenloNetEgStatsHist_learnReqDropDelta", "adaptor_MenloNetEgStatsHist_learnReqDropDeltaAvg", "adaptor_MenloNetEgStatsHist_learnReqDropDeltaMax", "adaptor_MenloNetEgStatsHist_learnReqDropDeltaMin", "adaptor_MenloNetEgStatsHist_mostRecent", "adaptor_MenloNetEgStatsHist_suspect", "adaptor_MenloNetEgStatsHist_thresholded", "adaptor_MenloNetEgStatsHist_timeCollected", "adaptor_MenloNetEgStats_dropCmd", "adaptor_MenloNetEgStats_dropCmdDelta", "adaptor_MenloNetEgStats_dropCmdDeltaAvg", "adaptor_MenloNetEgStats_dropCmdDeltaMax", "adaptor_MenloNetEgStats_dropCmdDeltaMin", "adaptor_MenloNetEgStats_dropLifCfgInvalid", "adaptor_MenloNetEgStats_dropLifCfgInvalidDelta", "adaptor_MenloNetEgStats_dropLifCfgInvalidDeltaAvg", "adaptor_MenloNetEgStats_dropLifCfgInvalidDeltaMax", "adaptor_MenloNetEgStats_dropLifCfgInvalidDeltaMin", "adaptor_MenloNetEgStats_dropLifMapNoHit", "adaptor_MenloNetEgStats_dropLifMapNoHitDelta", "adaptor_MenloNetEgStats_dropLifMapNoHitDeltaAvg", "adaptor_MenloNetEgStats_dropLifMapNoHitDeltaMax", "adaptor_MenloNetEgStats_dropLifMapNoHitDeltaMin", "adaptor_MenloNetEgStats_dropSrcBind", "adaptor_MenloNetEgStats_dropSrcBindDelta", "adaptor_MenloNetEgStats_dropSrcBindDeltaAvg", "adaptor_MenloNetEgStats_dropSrcBindDeltaMax", "adaptor_MenloNetEgStats_dropSrcBindDeltaMin", "adaptor_MenloNetEgStats_intervals", "adaptor_MenloNetEgStats_learnReqDrop", "adaptor_MenloNetEgStats_learnReqDropDelta", "adaptor_MenloNetEgStats_learnReqDropDeltaAvg", "adaptor_MenloNetEgStats_learnReqDropDeltaMax", "adaptor_MenloNetEgStats_learnReqDropDeltaMin", "adaptor_MenloNetEgStats_menloNetIndex", "adaptor_MenloNetEgStats_suspect", "adaptor_MenloNetEgStats_thresholded", "adaptor_MenloNetEgStats_timeCollected", "adaptor_MenloNetEgStats_update", "adaptor_MenloNetInStatsHist_dropFcLifInvalid", "adaptor_MenloNetInStatsHist_dropFcLifInvalidDelta", "adaptor_MenloNetInStatsHist_dropFcLifInvalidDeltaAvg", "adaptor_MenloNetInStatsHist_dropFcLifInvalidDeltaMax", "adaptor_MenloNetInStatsHist_dropFcLifInvalidDeltaMin", "adaptor_MenloNetInStatsHist_dropFcMulticast", "adaptor_MenloNetInStatsHist_dropFcMulticastDelta", "adaptor_MenloNetInStatsHist_dropFcMulticastDeltaAvg", "adaptor_MenloNetInStatsHist_dropFcMulticastDeltaMax", "adaptor_MenloNetInStatsHist_dropFcMulticastDeltaMin", "adaptor_MenloNetInStatsHist_dropNullPif", "adaptor_MenloNetInStatsHist_dropNullPifDelta", "adaptor_MenloNetInStatsHist_dropNullPifDeltaAvg", "adaptor_MenloNetInStatsHist_dropNullPifDeltaMax", "adaptor_MenloNetInStatsHist_dropNullPifDeltaMin", "adaptor_MenloNetInStatsHist_fwdLookupNoHit", "adaptor_MenloNetInStatsHist_fwdLookupNoHitDelta", "adaptor_MenloNetInStatsHist_fwdLookupNoHitDeltaAvg", "adaptor_MenloNetInStatsHist_fwdLookupNoHitDeltaMax", "adaptor_MenloNetInStatsHist_fwdLookupNoHitDeltaMin", "adaptor_MenloNetInStatsHist_id", "adaptor_MenloNetInStatsHist_mostRecent", "adaptor_MenloNetInStatsHist_suspect", "adaptor_MenloNetInStatsHist_thresholded", "adaptor_MenloNetInStatsHist_timeCollected", "adaptor_MenloNetInStats_dropFcLifInvalid", "adaptor_MenloNetInStats_dropFcLifInvalidDelta", "adaptor_MenloNetInStats_dropFcLifInvalidDeltaAvg", "adaptor_MenloNetInStats_dropFcLifInvalidDeltaMax", "adaptor_MenloNetInStats_dropFcLifInvalidDeltaMin", "adaptor_MenloNetInStats_dropFcMulticast", "adaptor_MenloNetInStats_dropFcMulticastDelta", "adaptor_MenloNetInStats_dropFcMulticastDeltaAvg", "adaptor_MenloNetInStats_dropFcMulticastDeltaMax", "adaptor_MenloNetInStats_dropFcMulticastDeltaMin", "adaptor_MenloNetInStats_dropNullPif", "adaptor_MenloNetInStats_dropNullPifDelta", "adaptor_MenloNetInStats_dropNullPifDeltaAvg", "adaptor_MenloNetInStats_dropNullPifDeltaMax", "adaptor_MenloNetInStats_dropNullPifDeltaMin", "adaptor_MenloNetInStats_fwdLookupNoHit", "adaptor_MenloNetInStats_fwdLookupNoHitDelta", "adaptor_MenloNetInStats_fwdLookupNoHitDeltaAvg", "adaptor_MenloNetInStats_fwdLookupNoHitDeltaMax", "adaptor_MenloNetInStats_fwdLookupNoHitDeltaMin", "adaptor_MenloNetInStats_intervals", "adaptor_MenloNetInStats_menloNetIndex", "adaptor_MenloNetInStats_suspect", "adaptor_MenloNetInStats_thresholded", "adaptor_MenloNetInStats_timeCollected", "adaptor_MenloNetInStats_update", "adaptor_MenloQErrorStatsHist_correctableErrors", "adaptor_MenloQErrorStatsHist_correctableErrorsDelta", "adaptor_MenloQErrorStatsHist_correctableErrorsDeltaAvg", "adaptor_MenloQErrorStatsHist_correctableErrorsDeltaMax", "adaptor_MenloQErrorStatsHist_correctableErrorsDeltaMin", "adaptor_MenloQErrorStatsHist_id", "adaptor_MenloQErrorStatsHist_mostRecent", "adaptor_MenloQErrorStatsHist_popErrors", "adaptor_MenloQErrorStatsHist_popErrorsDelta", "adaptor_MenloQErrorStatsHist_popErrorsDeltaAvg", "adaptor_MenloQErrorStatsHist_popErrorsDeltaMax", "adaptor_MenloQErrorStatsHist_popErrorsDeltaMin", "adaptor_MenloQErrorStatsHist_pushErrors", "adaptor_MenloQErrorStatsHist_pushErrorsDelta", "adaptor_MenloQErrorStatsHist_pushErrorsDeltaAvg", "adaptor_MenloQErrorStatsHist_pushErrorsDeltaMax", "adaptor_MenloQErrorStatsHist_pushErrorsDeltaMin", "adaptor_MenloQErrorStatsHist_suspect", "adaptor_MenloQErrorStatsHist_thresholded", "adaptor_MenloQErrorStatsHist_timeCollected", "adaptor_MenloQErrorStatsHist_uncorrectableErrors", "adaptor_MenloQErrorStatsHist_uncorrectableErrorsDelta", "adaptor_MenloQErrorStatsHist_uncorrectableErrorsDeltaAvg", "adaptor_MenloQErrorStatsHist_uncorrectableErrorsDeltaMax", "adaptor_MenloQErrorStatsHist_uncorrectableErrorsDeltaMin", "adaptor_MenloQErrorStats_correctableErrors", "adaptor_MenloQErrorStats_correctableErrorsDelta", "adaptor_MenloQErrorStats_correctableErrorsDeltaAvg", "adaptor_MenloQErrorStats_correctableErrorsDeltaMax", "adaptor_MenloQErrorStats_correctableErrorsDeltaMin", "adaptor_MenloQErrorStats_intervals", "adaptor_MenloQErrorStats_menloQueueComponent", "adaptor_MenloQErrorStats_menloQueueIndex", "adaptor_MenloQErrorStats_popErrors", "adaptor_MenloQErrorStats_popErrorsDelta", "adaptor_MenloQErrorStats_popErrorsDeltaAvg", "adaptor_MenloQErrorStats_popErrorsDeltaMax", "adaptor_MenloQErrorStats_popErrorsDeltaMin", "adaptor_MenloQErrorStats_pushErrors", "adaptor_MenloQErrorStats_pushErrorsDelta", "adaptor_MenloQErrorStats_pushErrorsDeltaAvg", "adaptor_MenloQErrorStats_pushErrorsDeltaMax", "adaptor_MenloQErrorStats_pushErrorsDeltaMin", "adaptor_MenloQErrorStats_suspect", "adaptor_MenloQErrorStats_thresholded", "adaptor_MenloQErrorStats_timeCollected", "adaptor_MenloQErrorStats_uncorrectableErrors", "adaptor_MenloQErrorStats_uncorrectableErrorsDelta", "adaptor_MenloQErrorStats_uncorrectableErrorsDeltaAvg", "adaptor_MenloQErrorStats_uncorrectableErrorsDeltaMax", "adaptor_MenloQErrorStats_uncorrectableErrorsDeltaMin", "adaptor_MenloQErrorStats_update", "adaptor_MenloQStatsHist_dropOverrunN0", "adaptor_MenloQStatsHist_dropOverrunN0Delta", "adaptor_MenloQStatsHist_dropOverrunN0DeltaAvg", "adaptor_MenloQStatsHist_dropOverrunN0DeltaMax", "adaptor_MenloQStatsHist_dropOverrunN0DeltaMin", "adaptor_MenloQStatsHist_dropOverrunN1", "adaptor_MenloQStatsHist_dropOverrunN1Delta", "adaptor_MenloQStatsHist_dropOverrunN1DeltaAvg", "adaptor_MenloQStatsHist_dropOverrunN1DeltaMax", "adaptor_MenloQStatsHist_dropOverrunN1DeltaMin", "adaptor_MenloQStatsHist_id", "adaptor_MenloQStatsHist_mostRecent", "adaptor_MenloQStatsHist_suspect", "adaptor_MenloQStatsHist_thresholded", "adaptor_MenloQStatsHist_timeCollected", "adaptor_MenloQStatsHist_truncateOverrunN0", "adaptor_MenloQStatsHist_truncateOverrunN0Delta", "adaptor_MenloQStatsHist_truncateOverrunN0DeltaAvg", "adaptor_MenloQStatsHist_truncateOverrunN0DeltaMax", "adaptor_MenloQStatsHist_truncateOverrunN0DeltaMin", "adaptor_MenloQStatsHist_truncateOverrunN1", "adaptor_MenloQStatsHist_truncateOverrunN1Delta", "adaptor_MenloQStatsHist_truncateOverrunN1DeltaAvg", "adaptor_MenloQStatsHist_truncateOverrunN1DeltaMax", "adaptor_MenloQStatsHist_truncateOverrunN1DeltaMin", "adaptor_MenloQStats_dropOverrunN0", "adaptor_MenloQStats_dropOverrunN0Delta", "adaptor_MenloQStats_dropOverrunN0DeltaAvg", "adaptor_MenloQStats_dropOverrunN0DeltaMax", "adaptor_MenloQStats_dropOverrunN0DeltaMin", "adaptor_MenloQStats_dropOverrunN1", "adaptor_MenloQStats_dropOverrunN1Delta", "adaptor_MenloQStats_dropOverrunN1DeltaAvg", "adaptor_MenloQStats_dropOverrunN1DeltaMax", "adaptor_MenloQStats_dropOverrunN1DeltaMin", "adaptor_MenloQStats_intervals", "adaptor_MenloQStats_menloQueueComponent", "adaptor_MenloQStats_menloQueueIndex", "adaptor_MenloQStats_suspect", "adaptor_MenloQStats_thresholded", "adaptor_MenloQStats_timeCollected", "adaptor_MenloQStats_truncateOverrunN0", "adaptor_MenloQStats_truncateOverrunN0Delta", "adaptor_MenloQStats_truncateOverrunN0DeltaAvg", "adaptor_MenloQStats_truncateOverrunN0DeltaMax", "adaptor_MenloQStats_truncateOverrunN0DeltaMin", "adaptor_MenloQStats_truncateOverrunN1", "adaptor_MenloQStats_truncateOverrunN1Delta", "adaptor_MenloQStats_truncateOverrunN1DeltaAvg", "adaptor_MenloQStats_truncateOverrunN1DeltaMax", "adaptor_MenloQStats_truncateOverrunN1DeltaMin", "adaptor_MenloQStats_update", "adaptor_MgmtCap_mode", "adaptor_MgmtCap_operPowerRequirement", "adaptor_MgmtCap_rebootActionOnDestructive", "adaptor_NwMgmtCap_api", "adaptor_NwMgmtCap_mgmtTransport", "adaptor_NwMgmtCap_mode", "adaptor_NwMgmtCap_operPowerRequirement", "adaptor_NwMgmtCap_rebootActionOnDestructive", "adaptor_PIoEp_chassisId", "adaptor_PIoEp_epDn", "adaptor_PIoEp_ifRole", "adaptor_PIoEp_ifType", "adaptor_PIoEp_locale", "adaptor_PIoEp_name", "adaptor_PIoEp_peerChassisId", "adaptor_PIoEp_peerDn", "adaptor_PIoEp_peerPortId", "adaptor_PIoEp_peerSlotId", "adaptor_PIoEp_portId", "adaptor_PIoEp_slotId", "adaptor_PIoEp_switchId", "adaptor_PIoEp_transport", "adaptor_PIoEp_type", "adaptor_ProtocolProfile_bootToTarget", "adaptor_ProtocolProfile_connectionTimeOut", "adaptor_ProtocolProfile_dhcpTimeOut", "adaptor_ProtocolProfile_hbaMode", "adaptor_ProtocolProfile_lunBusyRetryCount", "adaptor_ProtocolProfile_tcpTimeStamp", "adaptor_QueueProfile_count", "adaptor_QueueProfile_ringSize", "adaptor_RssProfile_receiveSideScaling", "adaptor_SanCap_hostNvram", "adaptor_TcpIpRssHashProfile_ipHash", "adaptor_TcpIpRssHashProfile_tcpHash", "adaptor_UnitAssocCtx_fruCapDn", "adaptor_UnitAssocCtx_id", "adaptor_UnitAssocCtx_pciAddr", "adaptor_UnitExtn_adaptorId", "adaptor_UnitExtn_bladeId", "adaptor_UnitExtn_chassisId", "adaptor_UnitExtn_id", "adaptor_UnitExtn_model", "adaptor_UnitExtn_operQualifierReason", "adaptor_UnitExtn_operState", "adaptor_UnitExtn_operability", "adaptor_UnitExtn_partNumber", "adaptor_UnitExtn_perf", "adaptor_UnitExtn_power", "adaptor_UnitExtn_presence", "adaptor_UnitExtn_revision", "adaptor_UnitExtn_serial", "adaptor_UnitExtn_thermal", "adaptor_UnitExtn_vendor", "adaptor_UnitExtn_voltage", "adaptor_Unit_adminPowerState", "adaptor_Unit_baseMac", "adaptor_Unit_bladeId", "adaptor_Unit_chassisId", "adaptor_Unit_connPath", "adaptor_Unit_connStatus", "adaptor_Unit_id", "adaptor_Unit_integrated", "adaptor_Unit_managingInst", "adaptor_Unit_mfgTime", "adaptor_Unit_model", "adaptor_Unit_operQualifierReason", "adaptor_Unit_operState", "adaptor_Unit_operability", "adaptor_Unit_partNumber", "adaptor_Unit_pciAddr", "adaptor_Unit_pciSlot", "adaptor_Unit_perf", "adaptor_Unit_power", "adaptor_Unit_presence", "adaptor_Unit_reachability", "adaptor_Unit_revision", "adaptor_Unit_serial", "adaptor_Unit_thermal", "adaptor_Unit_vendor", "adaptor_Unit_voltage", "adaptor_UplinkHwAddrCap_lldpMacOffset1", "adaptor_UplinkHwAddrCap_lldpMacOffset2", "adaptor_UplinkHwAddrCap_macOffset1", "adaptor_UplinkHwAddrCap_macOffset2", "adaptor_UplinkHwAddrCap_macOffsetSub00", "adaptor_UplinkHwAddrCap_macOffsetSub01", "adaptor_UplinkHwAddrCap_macOffsetSub02", "adaptor_UplinkHwAddrCap_macOffsetSub03", "adaptor_UplinkHwAddrCap_macOffsetSub10", "adaptor_UplinkHwAddrCap_macOffsetSub11", "adaptor_UplinkHwAddrCap_macOffsetSub12", "adaptor_UplinkHwAddrCap_macOffsetSub13", "adaptor_UsnicConnDef_conPolicyName", "adaptor_UsnicConnDef_usnicCount", "adaptor_Vlan_epDn", "adaptor_Vlan_id", "adaptor_Vlan_ifRole", "adaptor_Vlan_ifType", "adaptor_Vlan_lc", "adaptor_Vlan_locale", "adaptor_Vlan_name", "adaptor_Vlan_operState", "adaptor_Vlan_peerDn", "adaptor_Vlan_policyOwner", "adaptor_Vlan_pubNwDn", "adaptor_Vlan_pubNwId", "adaptor_Vlan_pubNwName", "adaptor_Vlan_sharing", "adaptor_Vlan_switchId", "adaptor_Vlan_transport", "adaptor_Vlan_type", "adaptor_Vlan_vlanType", "adaptor_VnicStatsHist_bytesRx", "adaptor_VnicStatsHist_bytesRxDelta", "adaptor_VnicStatsHist_bytesRxDeltaAvg", "adaptor_VnicStatsHist_bytesRxDeltaMax", "adaptor_VnicStatsHist_bytesRxDeltaMin", "adaptor_VnicStatsHist_bytesTx", "adaptor_VnicStatsHist_bytesTxDelta", "adaptor_VnicStatsHist_bytesTxDeltaAvg", "adaptor_VnicStatsHist_bytesTxDeltaMax", "adaptor_VnicStatsHist_bytesTxDeltaMin", "adaptor_VnicStatsHist_droppedRx", "adaptor_VnicStatsHist_droppedRxDelta", "adaptor_VnicStatsHist_droppedRxDeltaAvg", "adaptor_VnicStatsHist_droppedRxDeltaMax", "adaptor_VnicStatsHist_droppedRxDeltaMin", "adaptor_VnicStatsHist_droppedTx", "adaptor_VnicStatsHist_droppedTxDelta", "adaptor_VnicStatsHist_droppedTxDeltaAvg", "adaptor_VnicStatsHist_droppedTxDeltaMax", "adaptor_VnicStatsHist_droppedTxDeltaMin", "adaptor_VnicStatsHist_errorsRx", "adaptor_VnicStatsHist_errorsRxDelta", "adaptor_VnicStatsHist_errorsRxDeltaAvg", "adaptor_VnicStatsHist_errorsRxDeltaMax", "adaptor_VnicStatsHist_errorsRxDeltaMin", "adaptor_VnicStatsHist_errorsTx", "adaptor_VnicStatsHist_errorsTxDelta", "adaptor_VnicStatsHist_errorsTxDeltaAvg", "adaptor_VnicStatsHist_errorsTxDeltaMax", "adaptor_VnicStatsHist_errorsTxDeltaMin", "adaptor_VnicStatsHist_id", "adaptor_VnicStatsHist_mostRecent", "adaptor_VnicStatsHist_packetsRx", "adaptor_VnicStatsHist_packetsRxDelta", "adaptor_VnicStatsHist_packetsRxDeltaAvg", "adaptor_VnicStatsHist_packetsRxDeltaMax", "adaptor_VnicStatsHist_packetsRxDeltaMin", "adaptor_VnicStatsHist_packetsTx", "adaptor_VnicStatsHist_packetsTxDelta", "adaptor_VnicStatsHist_packetsTxDeltaAvg", "adaptor_VnicStatsHist_packetsTxDeltaMax", "adaptor_VnicStatsHist_packetsTxDeltaMin", "adaptor_VnicStatsHist_suspect", "adaptor_VnicStatsHist_thresholded", "adaptor_VnicStatsHist_timeCollected", "adaptor_VnicStats_bytesRx", "adaptor_VnicStats_bytesRxDelta", "adaptor_VnicStats_bytesRxDeltaAvg", "adaptor_VnicStats_bytesRxDeltaMax", "adaptor_VnicStats_bytesRxDeltaMin", "adaptor_VnicStats_bytesTx", "adaptor_VnicStats_bytesTxDelta", "adaptor_VnicStats_bytesTxDeltaAvg", "adaptor_VnicStats_bytesTxDeltaMax", "adaptor_VnicStats_bytesTxDeltaMin", "adaptor_VnicStats_droppedRx", "adaptor_VnicStats_droppedRxDelta", "adaptor_VnicStats_droppedRxDeltaAvg", "adaptor_VnicStats_droppedRxDeltaMax", "adaptor_VnicStats_droppedRxDeltaMin", "adaptor_VnicStats_droppedTx", "adaptor_VnicStats_droppedTxDelta", "adaptor_VnicStats_droppedTxDeltaAvg", "adaptor_VnicStats_droppedTxDeltaMax", "adaptor_VnicStats_droppedTxDeltaMin", "adaptor_VnicStats_errorsRx", "adaptor_VnicStats_errorsRxDelta", "adaptor_VnicStats_errorsRxDeltaAvg", "adaptor_VnicStats_errorsRxDeltaMax", "adaptor_VnicStats_errorsRxDeltaMin", "adaptor_VnicStats_errorsTx", "adaptor_VnicStats_errorsTxDelta", "adaptor_VnicStats_errorsTxDeltaAvg", "adaptor_VnicStats_errorsTxDeltaMax", "adaptor_VnicStats_errorsTxDeltaMin", "adaptor_VnicStats_intervals", "adaptor_VnicStats_packetsRx", "adaptor_VnicStats_packetsRxDelta", "adaptor_VnicStats_packetsRxDeltaAvg", "adaptor_VnicStats_packetsRxDeltaMax", "adaptor_VnicStats_packetsRxDeltaMin", "adaptor_VnicStats_packetsTx", "adaptor_VnicStats_packetsTxDelta", "adaptor_VnicStats_packetsTxDeltaAvg", "adaptor_VnicStats_packetsTxDeltaMax", "adaptor_VnicStats_packetsTxDeltaMin", "adaptor_VnicStats_suspect", "adaptor_VnicStats_thresholded", "adaptor_VnicStats_timeCollected", "adaptor_VnicStats_update", "adaptor_Vsan_epDn", "adaptor_Vsan_fcoeVlan", "adaptor_Vsan_id", "adaptor_Vsan_ifRole", "adaptor_Vsan_ifType", "adaptor_Vsan_lc", "adaptor_Vsan_locale", "adaptor_Vsan_name", "adaptor_Vsan_operState", "adaptor_Vsan_peerDn", "adaptor_Vsan_policyOwner", "adaptor_Vsan_switchId", "adaptor_Vsan_transport", "adaptor_Vsan_type", "adaptor_Vsan_zoningState", "ape_AdapterVnic_cookie", "ape_AdapterVnic_cos", "ape_AdapterVnic_mac", "ape_AdapterVnic_name", "ape_AdapterVnic_nicDn", "ape_AdapterVnic_state", "ape_AdapterVnic_type", "ape_AdapterVnic_uplinkPortId", "ape_AdapterVnic_vifId", "ape_AdapterVnic_vifType", "ape_AdapterVnic_vlanId", "ape_AdapterVnic_vntag", "ape_AdapterVnic_wwnn", "ape_Adapter_description", "ape_Adapter_fruId", "ape_Adapter_hwVersion", "ape_Adapter_mac1", "ape_Adapter_mac2", "ape_Adapter_name", "ape_Adapter_serial", "ape_Adapter_startEvent", "ape_Adapter_swBackupVersion", "ape_Adapter_swStartupVersion", "ape_Adapter_swVersion", "ape_Adapter_type", "ape_BootMethod_hostname", "ape_BootMethod_isHostAgentPresent", "ape_BootMethod_kernelName", "ape_BootMethod_kernelRelease", "ape_BootMethod_kernelVersion", "ape_BootMethod_name", "ape_BootMethod_type", "ape_ControllerChassis_index", "ape_ControllerEeprom_databaseVersion", "ape_ControllerEeprom_heartbeatRequest", "ape_ControllerEeprom_heartbeatResponse", "ape_ControllerEeprom_side", "ape_Fru_boardManufacturer", "ape_Fru_boardMfgTime", "ape_Fru_boardPartNo", "ape_Fru_boardProductName", "ape_Fru_boardSerialNo", "ape_Fru_boardVid", "ape_Fru_chassisPartNo", "ape_Fru_chassisSerialNo", "ape_Fru_controlPlaneMac1", "ape_Fru_controlPlaneMac2", "ape_Fru_dataPlaneMac1", "ape_Fru_dataPlaneMac2", "ape_Fru_dataPlaneWwn1", "ape_Fru_dataPlaneWwn2", "ape_Fru_entityType", "ape_Fru_id", "ape_Fru_instance", "ape_Fru_productAssetTag", "ape_Fru_productManufacturer", "ape_Fru_productName", "ape_Fru_productPartNo", "ape_Fru_productSerialNo", "ape_Fru_productVersionNo", "ape_Fru_type", "ape_HostAgent_chassisId", "ape_HostAgent_serverId", "ape_HostAgent_slotId", "ape_HostAgent_state", "ape_LANBoot_hostname", "ape_LANBoot_isHostAgentPresent", "ape_LANBoot_kernelName", "ape_LANBoot_kernelRelease", "ape_LANBoot_kernelVersion", "ape_LANBoot_name", "ape_LANBoot_type", "ape_LANBoot_vnicName", "ape_LocalDiskBoot_chassisId", "ape_LocalDiskBoot_hostname", "ape_LocalDiskBoot_isHostAgentPresent", "ape_LocalDiskBoot_kernelName", "ape_LocalDiskBoot_kernelRelease", "ape_LocalDiskBoot_kernelVersion", "ape_LocalDiskBoot_name", "ape_LocalDiskBoot_slotId", "ape_LocalDiskBoot_targetLun", "ape_LocalDiskBoot_type", "ape_Manager_statsUpdateId", "ape_McTable_id", "ape_McTable_name", "ape_Mc_ip", "ape_Mc_type", "ape_Mc_updateType", "ape_MenloVnicStats_bytes_eg", "ape_MenloVnicStats_bytes_in", "ape_MenloVnicStats_dropped_pkts_eg", "ape_MenloVnicStats_dropped_pkts_in", "ape_MenloVnicStats_errors_eg", "ape_MenloVnicStats_errors_in", "ape_MenloVnicStats_pkts_eg", "ape_MenloVnicStats_pkts_in", "ape_MenloVnic_cookie", "ape_MenloVnic_cos", "ape_MenloVnic_mac", "ape_MenloVnic_name", "ape_MenloVnic_nicDn", "ape_MenloVnic_pifId", "ape_MenloVnic_state", "ape_MenloVnic_type", "ape_MenloVnic_uplinkPortId", "ape_MenloVnic_vifId", "ape_MenloVnic_vifType", "ape_MenloVnic_vlanId", "ape_MenloVnic_vntag", "ape_MenloVnic_wwnn", "ape_MenloVnic_wwpn", "ape_Menlo_description", "ape_Menlo_fruId", "ape_Menlo_fwUpdateTimeout", "ape_Menlo_hwVersion", "ape_Menlo_mac1", "ape_Menlo_mac2", "ape_Menlo_name", "ape_Menlo_operationTimeout", "ape_Menlo_serial", "ape_Menlo_startEvent", "ape_Menlo_swBackupVersion", "ape_Menlo_swStartupVersion", "ape_Menlo_swVersion", "ape_Menlo_type", "ape_Menlo_uplinkPortType", "ape_PaloVnicStats_bytes_eg", "ape_PaloVnicStats_bytes_in", "ape_PaloVnicStats_dropped_pkts_eg", "ape_PaloVnicStats_dropped_pkts_in", "ape_PaloVnicStats_errors_eg", "ape_PaloVnicStats_errors_in", "ape_PaloVnicStats_pkts_eg", "ape_PaloVnicStats_pkts_in", "ape_PaloVnic_cookie", "ape_PaloVnic_cos", "ape_PaloVnic_failover", "ape_PaloVnic_mac", "ape_PaloVnic_mtu", "ape_PaloVnic_name", "ape_PaloVnic_nicDn", "ape_PaloVnic_passThru", "ape_PaloVnic_state", "ape_PaloVnic_stdbyVifId", "ape_PaloVnic_type", "ape_PaloVnic_uplinkPortId", "ape_PaloVnic_vifId", "ape_PaloVnic_vifType", "ape_PaloVnic_vlanId", "ape_PaloVnic_vmWare", "ape_PaloVnic_vntag", "ape_PaloVnic_wwnn", "ape_Palo_description", "ape_Palo_fruId", "ape_Palo_hwVersion", "ape_Palo_mac1", "ape_Palo_mac2", "ape_Palo_name", "ape_Palo_serial", "ape_Palo_startEvent", "ape_Palo_swBackupVersion", "ape_Palo_swStartupVersion", "ape_Palo_swVersion", "ape_Palo_type", "ape_Param_key", "ape_Param_value", "ape_Reading_id", "ape_Reading_state", "ape_Reading_value", "ape_SANBoot_hostname", "ape_SANBoot_isHostAgentPresent", "ape_SANBoot_kernelName", "ape_SANBoot_kernelRelease", "ape_SANBoot_kernelVersion", "ape_SANBoot_name", "ape_SANBoot_targetLun", "ape_SANBoot_targetWWN", "ape_SANBoot_type", "ape_Sdr_entityType", "ape_Sdr_eventReadingType", "ape_Sdr_hysterisisDown", "ape_Sdr_hysterisisUp", "ape_Sdr_id", "ape_Sdr_instance", "ape_Sdr_name", "ape_Sdr_sensorId", "ape_Sdr_sensorType", "ape_Sdr_thresholdLc", "ape_Sdr_thresholdLnc", "ape_Sdr_thresholdLnr", "ape_Sdr_thresholdUc", "ape_Sdr_thresholdUnc", "ape_Sdr_thresholdUnr", "ape_Sdr_type", "ape_Sdr_units", "ape_SwitchFirmwareInv_biosVersion", "ape_SwitchFirmwareInv_fabric", "ape_SwitchFirmwareInv_ksStartupVersion", "ape_SwitchFirmwareInv_ksVersion", "ape_SwitchFirmwareInv_name", "ape_SwitchFirmwareInv_sysStartupVersion", "ape_SwitchFirmwareInv_sysVersion", "ape_VirtualMediaBoot_chassisId", "ape_VirtualMediaBoot_hostname", "ape_VirtualMediaBoot_isHostAgentPresent", "ape_VirtualMediaBoot_kernelName", "ape_VirtualMediaBoot_kernelRelease", "ape_VirtualMediaBoot_kernelVersion", "ape_VirtualMediaBoot_name", "ape_VirtualMediaBoot_slotId", "ape_VirtualMediaBoot_type", "ape_VnicStats_bytes_eg", "ape_VnicStats_bytes_in", "ape_VnicStats_dropped_pkts_eg", "ape_VnicStats_dropped_pkts_in", "ape_VnicStats_errors_eg", "ape_VnicStats_errors_in", "ape_VnicStats_pkts_eg", "ape_VnicStats_pkts_in", "bios_ARef_isSupported", "bios_ARef_name", "bios_BOT_lastUpdate", "bios_BootDevGrp_descr", "bios_BootDevGrp_deviceName", "bios_BootDevGrp_errVal", "bios_BootDevGrp_order", "bios_BootDevGrp_type", "bios_BootDev_descr", "bios_BootDev_deviceName", "bios_BootDev_errValue", "bios_BootDev_order", "bios_FeatureRef_ftrMoClassName", "bios_FeatureRef_isSupported", "bios_FeatureRef_name", "bios_ParameterRef_isSupported", "bios_ParameterRef_name", "bios_ParameterRef_propertyName", "bios_Ref_isSupported", "bios_SettingRef_constantName", "bios_SettingRef_isDefault", "bios_SettingRef_isSupported", "bios_SettingRef_name", "bios_Unit_initSeq", "bios_Unit_initTs", "bios_Unit_model", "bios_Unit_revision", "bios_Unit_serial", "bios_Unit_vendor", "bios_VIdentityParams_lsServerName", "bios_VIdentityParams_lsServerTmplName", "bios_VIdentityParams_sysName", "bios_VProfile_descr", "bios_VProfile_intId", "bios_VProfile_name", "bios_VProfile_policyLevel", "bios_VProfile_policyOwner", "bios_VProfile_rebootOnUpdate", "bios_VfACPI10Support_vpACPI10Support", "bios_VfAssertNMIOnPERR_vpAssertNMIOnPERR", "bios_VfAssertNMIOnSERR_vpAssertNMIOnSERR", "bios_VfBootOptionRetry_vpBootOptionRetry", "bios_VfCPUPerformance_vpCPUPerformance", "bios_VfConsoleRedirection_vpBaudRate", "bios_VfConsoleRedirection_vpConsoleRedirection", "bios_VfConsoleRedirection_vpFlowControl", "bios_VfConsoleRedirection_vpLegacyOSRedirection", "bios_VfConsoleRedirection_vpTerminalType", "bios_VfCoreMultiProcessing_vpCoreMultiProcessing", "bios_VfDirectCacheAccess_vpDirectCacheAccess", "bios_VfDramRefreshRate_vpDramRefreshRate", "bios_VfEnhancedIntelSpeedStepTech_vpEnhancedIntelSpeedStepTech", "bios_VfExecuteDisableBit_vpExecuteDisableBit", "bios_VfFrontPanelLockout_vpFrontPanelLockout", "bios_VfIntelEntrySASRAIDModule_vpSASRAID", "bios_VfIntelEntrySASRAIDModule_vpSASRAIDModule", "bios_VfIntelHyperThreadingTech_vpIntelHyperThreadingTech", "bios_VfIntelTurboBoostTech_vpIntelTurboBoostTech", "bios_VfIntelVTForDirectedIO_vpIntelVTDATSSupport", "bios_VfIntelVTForDirectedIO_vpIntelVTDCoherencySupport", "bios_VfIntelVTForDirectedIO_vpIntelVTDInterruptRemapping", "bios_VfIntelVTForDirectedIO_vpIntelVTDPassThroughDMASupport", "bios_VfIntelVTForDirectedIO_vpIntelVTForDirectedIO", "bios_VfIntelVirtualizationTechnology_vpIntelVirtualizationTechnology", "bios_VfLocalX2Apic_vpLocalX2Apic", "bios_VfLvDIMMSupport_vpLvDDRMode", "bios_VfMaxVariableMTRRSetting_vpProcessorMtrr", "bios_VfMaximumMemoryBelow4GB_vpMaximumMemoryBelow4GB", "bios_VfMemoryMappedIOAbove4GB_vpMemoryMappedIOAbove4GB", "bios_VfMirroringMode_vpMirroringMode", "bios_VfNUMAOptimized_vpNUMAOptimized", "bios_VfOSBootWatchdogTimerPolicy_vpOSBootWatchdogTimerPolicy", "bios_VfOSBootWatchdogTimerTimeout_vpOSBootWatchdogTimerTimeout", "bios_VfOSBootWatchdogTimer_vpOSBootWatchdogTimer", "bios_VfOnboardSATAController_vpOnboardSATAController", "bios_VfOnboardSATAController_vpSATAMode", "bios_VfOnboardStorage_vpOnboardSCUStorageSupport", "bios_VfOptionROMEnable_vpState", "bios_VfOptionROMLoad_vpLoad", "bios_VfPCISlotOptionROMEnable_vpSlot1State", "bios_VfPCISlotOptionROMEnable_vpSlot2State", "bios_VfPCISlotOptionROMEnable_vpSlot3State", "bios_VfPCISlotOptionROMEnable_vpSlot4State", "bios_VfPCISlotOptionROMEnable_vpSlot5State", "bios_VfPCISlotOptionROMEnable_vpSlot6State", "bios_VfPCISlotOptionROMEnable_vpSlot7State", "bios_VfPCISlotOptionROMEnable_vpSlotMezzState", "bios_VfPOSTErrorPause_vpPOSTErrorPause", "bios_VfPackageCStateLimit_vpPackageCStateLimit", "bios_VfProcessorC1E_vpProcessorC1E", "bios_VfProcessorC3Report_vpProcessorC3Report", "bios_VfProcessorC6Report_vpProcessorC6Report", "bios_VfProcessorC7Report_vpProcessorC7Report", "bios_VfProcessorCState_vpProcessorCState", "bios_VfQuietBoot_vpQuietBoot", "bios_VfResumeOnACPowerLoss_vpResumeOnACPowerLoss", "bios_VfSelectMemoryRASConfiguration_vpSelectMemoryRASConfiguration", "bios_VfSerialPortAEnable_vpSerialPortAEnable", "bios_VfSparingMode_vpSparingMode", "bios_VfSriovConfig_vpSriov", "bios_VfUCSMBootModeControl_vpUEFIBootMode", "bios_VfUCSMBootOrderRuleControl_vpUCSMBootOrderRule", "bios_VfUEFIOSUseLegacyVideo_vpUEFIOSUseLegacyVideo", "bios_VfUSBBootConfig_vpLegacyUSBSupport", "bios_VfUSBBootConfig_vpMakeDeviceNonBootable", "bios_VfUSBFrontPanelAccessLock_vpUSBFrontPanelLock", "bios_VfUSBSystemIdlePowerOptimizingSetting_vpUSBIdlePowerOptimizing", "bmc_SELCounter_bitmask", "bmc_SELCounter_collInterval", "bmc_SELCounter_contClassId", "bmc_SELCounter_contInstId", "bmc_SELCounter_contInstIdPropId", "bmc_SELCounter_eqptClassId", "bmc_SELCounter_eqptInstId", "bmc_SELCounter_eqptInstIdPropId", "bmc_SELCounter_globalId", "bmc_SELCounter_localId", "bmc_SELCounter_pcGlobalId", "bmc_SELCounter_pcLocalId", "bmc_SELCounter_statsClassId", "bmc_SELCounter_statsPropId", "bmc_SELCounter_threshold", "bmc_SELCounter_value", "callhome_Dest_email", "callhome_EpFsmStage_descr", "callhome_EpFsmStage_lastUpdateTime", "callhome_EpFsmStage_name", "callhome_EpFsmStage_order", "callhome_EpFsmStage_retry", "callhome_EpFsmStage_stageStatus", "callhome_EpFsmTask_completion", "callhome_EpFsmTask_flags", "callhome_EpFsmTask_item", "callhome_EpFsmTask_seqId", "callhome_EpFsm_completionTime", "callhome_EpFsm_currentFsm", "callhome_EpFsm_descr", "callhome_EpFsm_fsmStatus", "callhome_EpFsm_instanceId", "callhome_EpFsm_progress", "callhome_EpFsm_rmtErrCode", "callhome_EpFsm_rmtErrDescr", "callhome_EpFsm_rmtRslt", "callhome_Ep_adminState", "callhome_Ep_alertThrottlingAdminState", "callhome_Ep_configState", "callhome_Ep_descr", "callhome_Ep_fsmDescr", "callhome_Ep_fsmPrev", "callhome_Ep_fsmProgr", "callhome_Ep_fsmRmtInvErrCode", "callhome_Ep_fsmRmtInvErrDescr", "callhome_Ep_fsmRmtInvRslt", "callhome_Ep_fsmStageDescr", "callhome_Ep_fsmStamp", "callhome_Ep_fsmStatus", "callhome_Ep_fsmTry", "callhome_Ep_intId", "callhome_Ep_name", "callhome_Ep_policyLevel", "callhome_Ep_policyOwner", "callhome_Item_descr", "callhome_Item_name", "callhome_PeriodicSystemInventory_adminState", "callhome_PeriodicSystemInventory_intervalDays", "callhome_PeriodicSystemInventory_lastDeadline", "callhome_PeriodicSystemInventory_maximumRetryCount", "callhome_PeriodicSystemInventory_minimumSendNowIntervalSeconds", "callhome_PeriodicSystemInventory_nextDeadline", "callhome_PeriodicSystemInventory_pollIntervalSeconds", "callhome_PeriodicSystemInventory_retryCount", "callhome_PeriodicSystemInventory_retryDelayMinutes", "callhome_PeriodicSystemInventory_sendNow", "callhome_PeriodicSystemInventory_timeOfDayHour", "callhome_PeriodicSystemInventory_timeOfDayMinute", "callhome_PeriodicSystemInventory_timeOfLastAttempt", "callhome_PeriodicSystemInventory_timeOfLastSuccess", "callhome_Policy_adminState", "callhome_Policy_cause", "callhome_Policy_descr", "callhome_Policy_name", "callhome_Profile_alertGroups", "callhome_Profile_descr", "callhome_Profile_format", "callhome_Profile_level", "callhome_Profile_maxSize", "callhome_Profile_name", "callhome_Smtp_host", "callhome_Smtp_port", "callhome_Source_addr", "callhome_Source_contact", "callhome_Source_contract", "callhome_Source_customer", "callhome_Source_email", "callhome_Source_from", "callhome_Source_phone", "callhome_Source_replyTo", "callhome_Source_site", "callhome_Source_urgency", "callhome_TestAlert_description", "callhome_TestAlert_group", "callhome_TestAlert_level", "callhome_TestAlert_messageSubtype", "callhome_TestAlert_messageType", "callhome_TestAlert_sendNow", "capability_CatalogueFsmStage_descr", "capability_CatalogueFsmStage_lastUpdateTime", "capability_CatalogueFsmStage_name", "capability_CatalogueFsmStage_order", "capability_CatalogueFsmStage_retry", "capability_CatalogueFsmStage_stageStatus", "capability_CatalogueFsmTask_completion", "capability_CatalogueFsmTask_flags", "capability_CatalogueFsmTask_item", "capability_CatalogueFsmTask_seqId", "capability_CatalogueFsm_completionTime", "capability_CatalogueFsm_currentFsm", "capability_CatalogueFsm_descr", "capability_CatalogueFsm_fsmStatus", "capability_CatalogueFsm_instanceId", "capability_CatalogueFsm_progress", "capability_CatalogueFsm_rmtErrCode", "capability_CatalogueFsm_rmtErrDescr", "capability_CatalogueFsm_rmtRslt", "capability_CatalogueLoadStats_fileParseFailures", "capability_CatalogueLoadStats_filesParsed", "capability_CatalogueLoadStats_providerLoadFailures", "capability_CatalogueLoadStats_providersLoaded", "capability_Catalogue_fileParseFailures", "capability_Catalogue_filesParsed", "capability_Catalogue_fsmDescr", "capability_Catalogue_fsmPrev", "capability_Catalogue_fsmProgr", "capability_Catalogue_fsmRmtInvErrCode", "capability_Catalogue_fsmRmtInvErrDescr", "capability_Catalogue_fsmRmtInvRslt", "capability_Catalogue_fsmStageDescr", "capability_Catalogue_fsmStamp", "capability_Catalogue_fsmStatus", "capability_Catalogue_fsmTry", "capability_Catalogue_loadErrors", "capability_Catalogue_loadWarnings", "capability_Catalogue_providerLoadFailures", "capability_Catalogue_providersLoaded", "capability_Catalogue_version", "capability_Def_descr", "capability_Def_intId", "capability_Def_name", "capability_Def_policyLevel", "capability_Def_policyOwner", "capability_FeatureLimits_descr", "capability_FeatureLimits_featureStatus", "capability_FeatureLimits_limit", "capability_FeatureLimits_name", "capability_FeatureLimits_platform", "capability_LoadStats_loadErrors", "capability_LoadStats_loadWarnings", "capability_MgmtExtensionFsmStage_descr", "capability_MgmtExtensionFsmStage_lastUpdateTime", "capability_MgmtExtensionFsmStage_name", "capability_MgmtExtensionFsmStage_order", "capability_MgmtExtensionFsmStage_retry", "capability_MgmtExtensionFsmStage_stageStatus", "capability_MgmtExtensionFsmTask_completion", "capability_MgmtExtensionFsmTask_flags", "capability_MgmtExtensionFsmTask_item", "capability_MgmtExtensionFsmTask_seqId", "capability_MgmtExtensionFsm_completionTime", "capability_MgmtExtensionFsm_currentFsm", "capability_MgmtExtensionFsm_descr", "capability_MgmtExtensionFsm_fsmStatus", "capability_MgmtExtensionFsm_instanceId", "capability_MgmtExtensionFsm_progress", "capability_MgmtExtensionFsm_rmtErrCode", "capability_MgmtExtensionFsm_rmtErrDescr", "capability_MgmtExtensionFsm_rmtRslt", "capability_MgmtExtension_fsmDescr", "capability_MgmtExtension_fsmPrev", "capability_MgmtExtension_fsmProgr", "capability_MgmtExtension_fsmRmtInvErrCode", "capability_MgmtExtension_fsmRmtInvErrDescr", "capability_MgmtExtension_fsmRmtInvRslt", "capability_MgmtExtension_fsmStageDescr", "capability_MgmtExtension_fsmStamp", "capability_MgmtExtension_fsmStatus", "capability_MgmtExtension_fsmTry", "capability_ProviderLoadStats_elementLoadFailures", "capability_ProviderLoadStats_elementsLoaded", "capability_Provider_deleted", "capability_Provider_deprecated", "capability_Provider_elementLoadFailures", "capability_Provider_elementsLoaded", "capability_Provider_gencount", "capability_Provider_loadErrors", "capability_Provider_loadWarnings", "capability_Provider_mgmtPlaneVer", "capability_Provider_model", "capability_Provider_vendor", "capability_Update_imageName", "capability_Update_updateTs", "capability_Update_version", "capability_UpdaterFsmStage_descr", "capability_UpdaterFsmStage_lastUpdateTime", "capability_UpdaterFsmStage_name", "capability_UpdaterFsmStage_order", "capability_UpdaterFsmStage_retry", "capability_UpdaterFsmStage_stageStatus", "capability_UpdaterFsmTask_completion", "capability_UpdaterFsmTask_flags", "capability_UpdaterFsmTask_item", "capability_UpdaterFsmTask_seqId", "capability_UpdaterFsm_completionTime", "capability_UpdaterFsm_currentFsm", "capability_UpdaterFsm_descr", "capability_UpdaterFsm_fsmStatus", "capability_UpdaterFsm_instanceId", "capability_UpdaterFsm_progress", "capability_UpdaterFsm_rmtErrCode", "capability_UpdaterFsm_rmtErrDescr", "capability_UpdaterFsm_rmtRslt", "capability_Updater_adminState", "capability_Updater_fileName", "capability_Updater_fsmDescr", "capability_Updater_fsmPrev", "capability_Updater_fsmProgr", "capability_Updater_fsmRmtInvErrCode", "capability_Updater_fsmRmtInvErrDescr", "capability_Updater_fsmRmtInvRslt", "capability_Updater_fsmStageDescr", "capability_Updater_fsmStamp", "capability_Updater_fsmStatus", "capability_Updater_fsmTry", "capability_Updater_imageName", "capability_Updater_operState", "capability_Updater_protocol", "capability_Updater_pwd", "capability_Updater_remotePath", "capability_Updater_server", "capability_Updater_user", "capability_Updater_version", "change_ChangedObjectRef_centraleMoDn", "change_ChangedObjectRef_changedMoClassId", "change_ChangedObjectRef_guid", "change_ChangedObjectRef_id", "change_ChangedObjectRef_oldCentraleMoDn", "change_ChangedObjectRef_refObjStatus", "change_ChangedObjectRef_ucsmMoDn", "clitest_TypeTest2_aPartialEnum", "clitest_TypeTest2_abitmask", "clitest_TypeTest2_acharbuf", "clitest_TypeTest2_fileDir", "clitest_TypeTest2_fileHost", "clitest_TypeTest2_fileName", "clitest_TypeTest2_filePasswd", "clitest_TypeTest2_filePath", "clitest_TypeTest2_filePort", "clitest_TypeTest2_fileProto", "clitest_TypeTest2_fileUser", "clitest_TypeTestChild_astring", "clitest_TypeTestChild_descr", "clitest_TypeTestChild_intId", "clitest_TypeTestChild_name", "clitest_TypeTestChild_policyLevel", "clitest_TypeTestChild_policyOwner", "clitest_TypeTestParent_astring", "clitest_TypeTestParent_descr", "clitest_TypeTestParent_intId", "clitest_TypeTestParent_name", "clitest_TypeTestParent_policyLevel", "clitest_TypeTestParent_policyOwner", "clitest_TypeTest_achar", "clitest_TypeTest_adate", "clitest_TypeTest_adatetime", "clitest_TypeTest_afloat", "clitest_TypeTest_amac", "clitest_TypeTest_anenum", "clitest_TypeTest_anipv4", "clitest_TypeTest_anipv6", "clitest_TypeTest_ansbyte", "clitest_TypeTest_ansint16", "clitest_TypeTest_ansint32", "clitest_TypeTest_ansint64", "clitest_TypeTest_apassword", "clitest_TypeTest_arange", "clitest_TypeTest_arcstring", "clitest_TypeTest_arxstring", "clitest_TypeTest_astring", "clitest_TypeTest_atime", "clitest_TypeTest_aubyte", "clitest_TypeTest_auint16", "clitest_TypeTest_auint32", "clitest_TypeTest_auint64", "clitest_TypeTest_awwn", "comm_CimcWebService_adminState", "comm_CimcWebService_descr", "comm_CimcWebService_intId", "comm_CimcWebService_name", "comm_CimcWebService_operPort", "comm_CimcWebService_policyLevel", "comm_CimcWebService_policyOwner", "comm_CimcWebService_port", "comm_CimcWebService_proto", "comm_Cimxml_adminState", "comm_Cimxml_descr", "comm_Cimxml_intId", "comm_Cimxml_name", "comm_Cimxml_operPort", "comm_Cimxml_policyLevel", "comm_Cimxml_policyOwner", "comm_Cimxml_port", "comm_Cimxml_proto", "comm_ClientItem_adminState", "comm_ClientItem_descr", "comm_ClientItem_hostname", "comm_ClientItem_name", "comm_Client_adminState", "comm_Client_descr", "comm_Client_hostname", "comm_Client_intId", "comm_Client_name", "comm_Client_policyLevel", "comm_Client_policyOwner", "comm_DateTime_adminState", "comm_DateTime_configState", "comm_DateTime_date", "comm_DateTime_descr", "comm_DateTime_intId", "comm_DateTime_name", "comm_DateTime_operPort", "comm_DateTime_operTimezone", "comm_DateTime_policyLevel", "comm_DateTime_policyOwner", "comm_DateTime_port", "comm_DateTime_proto", "comm_DateTime_timezone", "comm_Definition_descr", "comm_Definition_intId", "comm_Definition_name", "comm_Definition_policyLevel", "comm_Definition_policyOwner", "comm_DnsProvider_adminState", "comm_DnsProvider_descr", "comm_DnsProvider_hostname", "comm_DnsProvider_name", "comm_Dns_adminState", "comm_Dns_descr", "comm_Dns_domain", "comm_Dns_intId", "comm_Dns_name", "comm_Dns_operPort", "comm_Dns_policyLevel", "comm_Dns_policyOwner", "comm_Dns_port", "comm_Dns_proto", "comm_EvtChannel_channelState", "comm_EvtChannel_descr", "comm_EvtChannel_intId", "comm_EvtChannel_name", "comm_EvtChannel_policyLevel", "comm_EvtChannel_policyOwner", "comm_Http_adminState", "comm_Http_descr", "comm_Http_intId", "comm_Http_name", "comm_Http_operPort", "comm_Http_policyLevel", "comm_Http_policyOwner", "comm_Http_port", "comm_Http_proto", "comm_Http_redirectState", "comm_Https_adminState", "comm_Https_cipherSuite", "comm_Https_cipherSuiteMode", "comm_Https_descr", "comm_Https_intId", "comm_Https_keyRing", "comm_Https_name", "comm_Https_operPort", "comm_Https_policyLevel", "comm_Https_policyOwner", "comm_Https_port", "comm_Https_proto", "comm_Item_descr", "comm_Item_name", "comm_NtpProvider_adminState", "comm_NtpProvider_descr", "comm_NtpProvider_hostname", "comm_NtpProvider_name", "comm_ShellSvcLimits_descr", "comm_ShellSvcLimits_intId", "comm_ShellSvcLimits_name", "comm_ShellSvcLimits_policyLevel", "comm_ShellSvcLimits_policyOwner", "comm_ShellSvcLimits_sessionsPerUser", "comm_ShellSvcLimits_totalSessions", "comm_Shell_adminState", "comm_Shell_descr", "comm_Shell_intId", "comm_Shell_name", "comm_Shell_operPort", "comm_Shell_policyLevel", "comm_Shell_policyOwner", "comm_Shell_port", "comm_Shell_proto", "comm_SmashCLP_adminState", "comm_SmashCLP_descr", "comm_SmashCLP_intId", "comm_SmashCLP_name", "comm_SmashCLP_operPort", "comm_SmashCLP_policyLevel", "comm_SmashCLP_policyOwner", "comm_SmashCLP_port", "comm_SmashCLP_proto", "comm_SnmpTrap_community", "comm_SnmpTrap_hostname", "comm_SnmpTrap_notificationType", "comm_SnmpTrap_port", "comm_SnmpTrap_v3Privilege", "comm_SnmpTrap_version", "comm_SnmpUser_auth", "comm_SnmpUser_configState", "comm_SnmpUser_configStatusMessage", "comm_SnmpUser_descr", "comm_SnmpUser_name", "comm_SnmpUser_privPwdSet", "comm_SnmpUser_privpwd", "comm_SnmpUser_pwd", "comm_SnmpUser_pwdSet", "comm_SnmpUser_useAes", "comm_Snmp_adminState", "comm_Snmp_community", "comm_Snmp_configState", "comm_Snmp_descr", "comm_Snmp_intId", "comm_Snmp_isSetSnmpSecure", "comm_Snmp_name", "comm_Snmp_operPort", "comm_Snmp_policyLevel", "comm_Snmp_policyOwner", "comm_Snmp_port", "comm_Snmp_proto", "comm_Snmp_sysContact", "comm_Snmp_sysLocation", "comm_Ssh_adminState", "comm_Ssh_descr", "comm_Ssh_intId", "comm_Ssh_name", "comm_Ssh_operPort", "comm_Ssh_policyLevel", "comm_Ssh_policyOwner", "comm_Ssh_port", "comm_Ssh_proto", "comm_SvcChannel_channelState", "comm_SvcChannel_descr", "comm_SvcChannel_intId", "comm_SvcChannel_name", "comm_SvcChannel_policyLevel", "comm_SvcChannel_policyOwner", "comm_SvcEpFsmStage_descr", "comm_SvcEpFsmStage_lastUpdateTime", "comm_SvcEpFsmStage_name", "comm_SvcEpFsmStage_order", "comm_SvcEpFsmStage_retry", "comm_SvcEpFsmStage_stageStatus", "comm_SvcEpFsmTask_completion", "comm_SvcEpFsmTask_flags", "comm_SvcEpFsmTask_item", "comm_SvcEpFsmTask_seqId", "comm_SvcEpFsm_completionTime", "comm_SvcEpFsm_currentFsm", "comm_SvcEpFsm_descr", "comm_SvcEpFsm_fsmStatus", "comm_SvcEpFsm_instanceId", "comm_SvcEpFsm_progress", "comm_SvcEpFsm_rmtErrCode", "comm_SvcEpFsm_rmtErrDescr", "comm_SvcEpFsm_rmtRslt", "comm_SvcEp_configState", "comm_SvcEp_configStatusMessage", "comm_SvcEp_descr", "comm_SvcEp_fsmDescr", "comm_SvcEp_fsmFlags", "comm_SvcEp_fsmPrev", "comm_SvcEp_fsmProgr", "comm_SvcEp_fsmRmtInvErrCode", "comm_SvcEp_fsmRmtInvErrDescr", "comm_SvcEp_fsmRmtInvRslt", "comm_SvcEp_fsmStageDescr", "comm_SvcEp_fsmStamp", "comm_SvcEp_fsmStatus", "comm_SvcEp_fsmTry", "comm_SvcEp_intId", "comm_SvcEp_name", "comm_SvcEp_policyLevel", "comm_SvcEp_policyOwner", "comm_SvcLimits_descr", "comm_SvcLimits_intId", "comm_SvcLimits_name", "comm_SvcLimits_policyLevel", "comm_SvcLimits_policyOwner", "comm_SvcLimits_sessionsPerUser", "comm_SvcLimits_totalSessions", "comm_Svc_adminState", "comm_Svc_descr", "comm_Svc_intId", "comm_Svc_name", "comm_Svc_operPort", "comm_Svc_policyLevel", "comm_Svc_policyOwner", "comm_Svc_port", "comm_Svc_proto", "comm_SyslogClient_adminState", "comm_SyslogClient_forwardingFacility", "comm_SyslogClient_hostname", "comm_SyslogClient_name", "comm_SyslogClient_severity", "comm_SyslogConsole_adminState", "comm_SyslogConsole_descr", "comm_SyslogConsole_name", "comm_SyslogConsole_severity", "comm_SyslogFile_adminState", "comm_SyslogFile_descr", "comm_SyslogFile_name", "comm_SyslogFile_severity", "comm_SyslogFile_size", "comm_SyslogMonitor_adminState", "comm_SyslogMonitor_descr", "comm_SyslogMonitor_name", "comm_SyslogMonitor_severity", "comm_SyslogSource_audits", "comm_SyslogSource_descr", "comm_SyslogSource_events", "comm_SyslogSource_faults", "comm_SyslogSource_name", "comm_Syslog_adminState", "comm_Syslog_descr", "comm_Syslog_intId", "comm_Syslog_name", "comm_Syslog_operPort", "comm_Syslog_policyLevel", "comm_Syslog_policyOwner", "comm_Syslog_port", "comm_Syslog_proto", "comm_Syslog_severity", "comm_Telnet_adminState", "comm_Telnet_descr", "comm_Telnet_intId", "comm_Telnet_name", "comm_Telnet_operPort", "comm_Telnet_policyLevel", "comm_Telnet_policyOwner", "comm_Telnet_port", "comm_Telnet_proto", "comm_WebChannel_channelState", "comm_WebChannel_descr", "comm_WebChannel_intId", "comm_WebChannel_name", "comm_WebChannel_policyLevel", "comm_WebChannel_policyOwner", "comm_WebSvcLimits_descr", "comm_WebSvcLimits_intId", "comm_WebSvcLimits_name", "comm_WebSvcLimits_policyLevel", "comm_WebSvcLimits_policyOwner", "comm_WebSvcLimits_sessionsPerUser", "comm_WebSvcLimits_totalSessions", "comm_Web_adminState", "comm_Web_descr", "comm_Web_intId", "comm_Web_name", "comm_Web_operPort", "comm_Web_policyLevel", "comm_Web_policyOwner", "comm_Web_port", "comm_Web_proto", "comm_Wsman_adminState", "comm_Wsman_descr", "comm_Wsman_intId", "comm_Wsman_name", "comm_Wsman_operPort", "comm_Wsman_policyLevel", "comm_Wsman_policyOwner", "comm_Wsman_port", "comm_Wsman_proto", "comm_XmlClConnPolicy_adminState", "comm_XmlClConnPolicy_clientType", "comm_XmlClConnPolicy_descr", "comm_XmlClConnPolicy_intId", "comm_XmlClConnPolicy_name", "comm_XmlClConnPolicy_operPort", "comm_XmlClConnPolicy_policyLevel", "comm_XmlClConnPolicy_policyOwner", "comm_XmlClConnPolicy_port", "comm_XmlClConnPolicy_proto", "compute_AChassisDiscPolicy_action", "compute_AChassisDiscPolicy_descr", "compute_AChassisDiscPolicy_intId", "compute_AChassisDiscPolicy_linkAggregationPref", "compute_AChassisDiscPolicy_name", "compute_AChassisDiscPolicy_policyLevel", "compute_AChassisDiscPolicy_policyOwner", "compute_AChassisDiscPolicy_qualifier", "compute_AutoconfigPolicy_descr", "compute_AutoconfigPolicy_dstDn", "compute_AutoconfigPolicy_intId", "compute_AutoconfigPolicy_name", "compute_AutoconfigPolicy_policyLevel", "compute_AutoconfigPolicy_policyOwner", "compute_AutoconfigPolicy_qualifier", "compute_AutoconfigPolicy_srcTemplName", "compute_BladeDiscPolicy_action", "compute_BladeDiscPolicy_descr", "compute_BladeDiscPolicy_intId", "compute_BladeDiscPolicy_name", "compute_BladeDiscPolicy_policyLevel", "compute_BladeDiscPolicy_policyOwner", "compute_BladeDiscPolicy_qualifier", "compute_BladeDiscPolicy_scrubPolicyName", "compute_BladeFsmStage_descr", "compute_BladeFsmStage_lastUpdateTime", "compute_BladeFsmStage_name", "compute_BladeFsmStage_order", "compute_BladeFsmStage_retry", "compute_BladeFsmStage_stageStatus", "compute_BladeFsmTask_completion", "compute_BladeFsmTask_flags", "compute_BladeFsmTask_item", "compute_BladeFsmTask_seqId", "compute_BladeFsm_completionTime", "compute_BladeFsm_currentFsm", "compute_BladeFsm_descr", "compute_BladeFsm_fsmStatus", "compute_BladeFsm_instanceId", "compute_BladeFsm_progress", "compute_BladeFsm_rmtErrCode", "compute_BladeFsm_rmtErrDescr", "compute_BladeFsm_rmtRslt", "compute_BladeInheritPolicy_descr", "compute_BladeInheritPolicy_dstDn", "compute_BladeInheritPolicy_intId", "compute_BladeInheritPolicy_name", "compute_BladeInheritPolicy_policyLevel", "compute_BladeInheritPolicy_policyOwner", "compute_BladeInheritPolicy_qualifier", "compute_BladePosQual_maxId", "compute_BladePosQual_minId", "compute_Blade_adminPower", "compute_Blade_adminState", "compute_Blade_assignedToDn", "compute_Blade_association", "compute_Blade_availability", "compute_Blade_availableMemory", "compute_Blade_chassisId", "compute_Blade_checkPoint", "compute_Blade_connPath", "compute_Blade_connStatus", "compute_Blade_descr", "compute_Blade_discovery", "compute_Blade_fltAggr", "compute_Blade_fsmDescr", "compute_Blade_fsmFlags", "compute_Blade_fsmPrev", "compute_Blade_fsmProgr", "compute_Blade_fsmRmtInvErrCode", "compute_Blade_fsmRmtInvErrDescr", "compute_Blade_fsmRmtInvRslt", "compute_Blade_fsmStageDescr", "compute_Blade_fsmStamp", "compute_Blade_fsmStatus", "compute_Blade_fsmTry", "compute_Blade_intId", "compute_Blade_lc", "compute_Blade_lcTs", "compute_Blade_localId", "compute_Blade_lowVoltageMemory", "compute_Blade_managingInst", "compute_Blade_memorySpeed", "compute_Blade_mfgTime", "compute_Blade_model", "compute_Blade_name", "compute_Blade_numOfAdaptors", "compute_Blade_numOfCores", "compute_Blade_numOfCoresEnabled", "compute_Blade_numOfCpus", "compute_Blade_numOfEthHostIfs", "compute_Blade_numOfFcHostIfs", "compute_Blade_numOfThreads", "compute_Blade_operPower", "compute_Blade_operQualifier", "compute_Blade_operState", "compute_Blade_operability", "compute_Blade_originalUuid", "compute_Blade_partNumber", "compute_Blade_policyLevel", "compute_Blade_policyOwner", "compute_Blade_presence", "compute_Blade_revision", "compute_Blade_serial", "compute_Blade_serverId", "compute_Blade_slotId", "compute_Blade_totalMemory", "compute_Blade_usrLbl", "compute_Blade_uuid", "compute_Blade_vendor", "compute_Blade_vid", "compute_BoardController_id", "compute_BoardController_model", "compute_BoardController_operQualifierReason", "compute_BoardController_operState", "compute_BoardController_operability", "compute_BoardController_perf", "compute_BoardController_power", "compute_BoardController_presence", "compute_BoardController_revision", "compute_BoardController_serial", "compute_BoardController_thermal", "compute_BoardController_vendor", "compute_BoardController_voltage", "compute_Board_cmosVoltage", "compute_Board_id", "compute_Board_model", "compute_Board_operPower", "compute_Board_operQualifierReason", "compute_Board_operState", "compute_Board_operability", "compute_Board_perf", "compute_Board_power", "compute_Board_powerUsage", "compute_Board_presence", "compute_Board_revision", "compute_Board_serial", "compute_Board_thermal", "compute_Board_vendor", "compute_Board_voltage", "compute_ChassisConnPolicy_adminState", "compute_ChassisConnPolicy_chassisId", "compute_ChassisConnPolicy_descr", "compute_ChassisConnPolicy_intId", "compute_ChassisConnPolicy_name", "compute_ChassisConnPolicy_policyLevel", "compute_ChassisConnPolicy_policyOwner", "compute_ChassisConnPolicy_qualifier", "compute_ChassisConnPolicy_switchId", "compute_ChassisDiscPolicy_action", "compute_ChassisDiscPolicy_descr", "compute_ChassisDiscPolicy_intId", "compute_ChassisDiscPolicy_linkAggregationPref", "compute_ChassisDiscPolicy_name", "compute_ChassisDiscPolicy_policyLevel", "compute_ChassisDiscPolicy_policyOwner", "compute_ChassisDiscPolicy_qualifier", "compute_ChassisDiscPolicy_rebalance", "compute_ChassisQual_maxId", "compute_ChassisQual_minId", "compute_ComputeDiscPolicy_action", "compute_ComputeDiscPolicy_descr", "compute_ComputeDiscPolicy_intId", "compute_ComputeDiscPolicy_name", "compute_ComputeDiscPolicy_policyLevel", "compute_ComputeDiscPolicy_policyOwner", "compute_ComputeDiscPolicy_qualifier", "compute_ComputeDiscPolicy_scrubPolicyName", "compute_ConfigPolicy_descr", "compute_ConfigPolicy_intId", "compute_ConfigPolicy_name", "compute_ConfigPolicy_policyLevel", "compute_ConfigPolicy_policyOwner", "compute_ConfigPolicy_qualifier", "compute_Container_descr", "compute_Container_intId", "compute_Container_name", "compute_Container_policyLevel", "compute_Container_policyOwner", "compute_Container_uuid", "compute_DiscPolicy_descr", "compute_DiscPolicy_intId", "compute_DiscPolicy_name", "compute_DiscPolicy_policyLevel", "compute_DiscPolicy_policyOwner", "compute_DiscPolicy_qualifier", "compute_FwSyncAck_acked", "compute_FwSyncAck_ackedBy", "compute_FwSyncAck_adminState", "compute_FwSyncAck_autoDelete", "compute_FwSyncAck_changeBy", "compute_FwSyncAck_changeDetails", "compute_FwSyncAck_changes", "compute_FwSyncAck_descr", "compute_FwSyncAck_disr", "compute_FwSyncAck_ignoreCap", "compute_FwSyncAck_intId", "compute_FwSyncAck_modified", "compute_FwSyncAck_name", "compute_FwSyncAck_operScheduler", "compute_FwSyncAck_operState", "compute_FwSyncAck_policyLevel", "compute_FwSyncAck_policyOwner", "compute_FwSyncAck_prevOperState", "compute_FwSyncAck_scheduler", "compute_HealthLedSensorAlarm_alarmDesc", "compute_HealthLedSensorAlarm_alarmSeverity", "compute_HealthLedSensorAlarm_sensorId", "compute_HealthLedSensorAlarm_sensorName", "compute_IOHubEnvStatsHist_id", "compute_IOHubEnvStatsHist_mostRecent", "compute_IOHubEnvStatsHist_suspect", "compute_IOHubEnvStatsHist_temperature", "compute_IOHubEnvStatsHist_temperatureAvg", "compute_IOHubEnvStatsHist_temperatureMax", "compute_IOHubEnvStatsHist_temperatureMin", "compute_IOHubEnvStatsHist_thresholded", "compute_IOHubEnvStatsHist_timeCollected", "compute_IOHubEnvStats_intervals", "compute_IOHubEnvStats_suspect", "compute_IOHubEnvStats_temperature", "compute_IOHubEnvStats_temperatureAvg", "compute_IOHubEnvStats_temperatureMax", "compute_IOHubEnvStats_temperatureMin", "compute_IOHubEnvStats_thresholded", "compute_IOHubEnvStats_timeCollected", "compute_IOHubEnvStats_update", "compute_IOHub_id", "compute_IOHub_model", "compute_IOHub_operQualifierReason", "compute_IOHub_operState", "compute_IOHub_operability", "compute_IOHub_perf", "compute_IOHub_power", "compute_IOHub_presence", "compute_IOHub_revision", "compute_IOHub_serial", "compute_IOHub_thermal", "compute_IOHub_vendor", "compute_IOHub_voltage", "compute_InitConfigPolicy_descr", "compute_InitConfigPolicy_dstDn", "compute_InitConfigPolicy_intId", "compute_InitConfigPolicy_name", "compute_InitConfigPolicy_policyLevel", "compute_InitConfigPolicy_policyOwner", "compute_InitConfigPolicy_qualifier", "compute_Item_adminState", "compute_Item_assignedToDn", "compute_Item_association", "compute_Item_availability", "compute_Item_descr", "compute_Item_discovery", "compute_Item_intId", "compute_Item_name", "compute_Item_operState", "compute_Item_policyLevel", "compute_Item_policyOwner", "compute_Item_uuid", "compute_Logical_descr", "compute_Logical_intId", "compute_Logical_name", "compute_Logical_pnDn", "compute_Logical_policyLevel", "compute_Logical_policyOwner", "compute_Logical_uuid", "compute_MbPowerStatsHist_consumedPower", "compute_MbPowerStatsHist_consumedPowerAvg", "compute_MbPowerStatsHist_consumedPowerMax", "compute_MbPowerStatsHist_consumedPowerMin", "compute_MbPowerStatsHist_id", "compute_MbPowerStatsHist_inputCurrent", "compute_MbPowerStatsHist_inputCurrentAvg", "compute_MbPowerStatsHist_inputCurrentMax", "compute_MbPowerStatsHist_inputCurrentMin", "compute_MbPowerStatsHist_inputVoltage", "compute_MbPowerStatsHist_inputVoltageAvg", "compute_MbPowerStatsHist_inputVoltageMax", "compute_MbPowerStatsHist_inputVoltageMin", "compute_MbPowerStatsHist_mostRecent", "compute_MbPowerStatsHist_suspect", "compute_MbPowerStatsHist_thresholded", "compute_MbPowerStatsHist_timeCollected", "compute_MbPowerStats_consumedPower", "compute_MbPowerStats_consumedPowerAvg", "compute_MbPowerStats_consumedPowerMax", "compute_MbPowerStats_consumedPowerMin", "compute_MbPowerStats_inputCurrent", "compute_MbPowerStats_inputCurrentAvg", "compute_MbPowerStats_inputCurrentMax", "compute_MbPowerStats_inputCurrentMin", "compute_MbPowerStats_inputVoltage", "compute_MbPowerStats_inputVoltageAvg", "compute_MbPowerStats_inputVoltageMax", "compute_MbPowerStats_inputVoltageMin", "compute_MbPowerStats_intervals", "compute_MbPowerStats_suspect", "compute_MbPowerStats_thresholded", "compute_MbPowerStats_timeCollected", "compute_MbPowerStats_update", "compute_MbTempStatsHist_fmTempSenIo", "compute_MbTempStatsHist_fmTempSenIoAvg", "compute_MbTempStatsHist_fmTempSenIoMax", "compute_MbTempStatsHist_fmTempSenIoMin", "compute_MbTempStatsHist_fmTempSenRear", "compute_MbTempStatsHist_fmTempSenRearAvg", "compute_MbTempStatsHist_fmTempSenRearL", "compute_MbTempStatsHist_fmTempSenRearLAvg", "compute_MbTempStatsHist_fmTempSenRearLMax", "compute_MbTempStatsHist_fmTempSenRearLMin", "compute_MbTempStatsHist_fmTempSenRearMax", "compute_MbTempStatsHist_fmTempSenRearMin", "compute_MbTempStatsHist_fmTempSenRearR", "compute_MbTempStatsHist_fmTempSenRearRAvg", "compute_MbTempStatsHist_fmTempSenRearRMax", "compute_MbTempStatsHist_fmTempSenRearRMin", "compute_MbTempStatsHist_id", "compute_MbTempStatsHist_mostRecent", "compute_MbTempStatsHist_suspect", "compute_MbTempStatsHist_thresholded", "compute_MbTempStatsHist_timeCollected", "compute_MbTempStats_fmTempSenIo", "compute_MbTempStats_fmTempSenIoAvg", "compute_MbTempStats_fmTempSenIoMax", "compute_MbTempStats_fmTempSenIoMin", "compute_MbTempStats_fmTempSenRear", "compute_MbTempStats_fmTempSenRearAvg", "compute_MbTempStats_fmTempSenRearL", "compute_MbTempStats_fmTempSenRearLAvg", "compute_MbTempStats_fmTempSenRearLMax", "compute_MbTempStats_fmTempSenRearLMin", "compute_MbTempStats_fmTempSenRearMax", "compute_MbTempStats_fmTempSenRearMin", "compute_MbTempStats_fmTempSenRearR", "compute_MbTempStats_fmTempSenRearRAvg", "compute_MbTempStats_fmTempSenRearRMax", "compute_MbTempStats_fmTempSenRearRMin", "compute_MbTempStats_intervals", "compute_MbTempStats_suspect", "compute_MbTempStats_thresholded", "compute_MbTempStats_timeCollected", "compute_MbTempStats_update", "compute_MemoryConfigPolicy_blackListing", "compute_MemoryConfigPolicy_descr", "compute_MemoryConfigPolicy_intId", "compute_MemoryConfigPolicy_name", "compute_MemoryConfigPolicy_policyLevel", "compute_MemoryConfigPolicy_policyOwner", "compute_MemoryConfiguration_adminMemoryState", "compute_MemoryConfiguration_blackListing", "compute_MemoryUnitConstraintDef_descr", "compute_MemoryUnitConstraintDef_intId", "compute_MemoryUnitConstraintDef_name", "compute_MemoryUnitConstraintDef_policyLevel", "compute_MemoryUnitConstraintDef_policyOwner", "compute_MemoryUnitConstraintDef_revisionModifier", "compute_MemoryUnitConstraintDef_type", "compute_PCIeFatalCompletionStats_AbortErrors", "compute_PCIeFatalCompletionStats_AbortErrors15Min", "compute_PCIeFatalCompletionStats_AbortErrors15MinH", "compute_PCIeFatalCompletionStats_AbortErrors1Day", "compute_PCIeFatalCompletionStats_AbortErrors1DayH", "compute_PCIeFatalCompletionStats_AbortErrors1Hour", "compute_PCIeFatalCompletionStats_AbortErrors1HourH", "compute_PCIeFatalCompletionStats_AbortErrors1Week", "compute_PCIeFatalCompletionStats_AbortErrors1WeekH", "compute_PCIeFatalCompletionStats_AbortErrors2Weeks", "compute_PCIeFatalCompletionStats_AbortErrors2WeeksH", "compute_PCIeFatalCompletionStats_TimeoutErrors", "compute_PCIeFatalCompletionStats_TimeoutErrors15Min", "compute_PCIeFatalCompletionStats_TimeoutErrors15MinH", "compute_PCIeFatalCompletionStats_TimeoutErrors1Day", "compute_PCIeFatalCompletionStats_TimeoutErrors1DayH", "compute_PCIeFatalCompletionStats_TimeoutErrors1Hour", "compute_PCIeFatalCompletionStats_TimeoutErrors1HourH", "compute_PCIeFatalCompletionStats_TimeoutErrors1Week", "compute_PCIeFatalCompletionStats_TimeoutErrors1WeekH", "compute_PCIeFatalCompletionStats_TimeoutErrors2Weeks", "compute_PCIeFatalCompletionStats_TimeoutErrors2WeeksH", "compute_PCIeFatalCompletionStats_intervals", "compute_PCIeFatalCompletionStats_suspect", "compute_PCIeFatalCompletionStats_thresholded", "compute_PCIeFatalCompletionStats_timeCollected", "compute_PCIeFatalCompletionStats_unexpectedErrors", "compute_PCIeFatalCompletionStats_unexpectedErrors15Min", "compute_PCIeFatalCompletionStats_unexpectedErrors15MinH", "compute_PCIeFatalCompletionStats_unexpectedErrors1Day", "compute_PCIeFatalCompletionStats_unexpectedErrors1DayH", "compute_PCIeFatalCompletionStats_unexpectedErrors1Hour", "compute_PCIeFatalCompletionStats_unexpectedErrors1HourH", "compute_PCIeFatalCompletionStats_unexpectedErrors1Week", "compute_PCIeFatalCompletionStats_unexpectedErrors1WeekH", "compute_PCIeFatalCompletionStats_unexpectedErrors2Weeks", "compute_PCIeFatalCompletionStats_unexpectedErrors2WeeksH", "compute_PCIeFatalCompletionStats_update", "compute_PCIeFatalProtocolStats_dllpErrors", "compute_PCIeFatalProtocolStats_dllpErrors15Min", "compute_PCIeFatalProtocolStats_dllpErrors15MinH", "compute_PCIeFatalProtocolStats_dllpErrors1Day", "compute_PCIeFatalProtocolStats_dllpErrors1DayH", "compute_PCIeFatalProtocolStats_dllpErrors1Hour", "compute_PCIeFatalProtocolStats_dllpErrors1HourH", "compute_PCIeFatalProtocolStats_dllpErrors1Week", "compute_PCIeFatalProtocolStats_dllpErrors1WeekH", "compute_PCIeFatalProtocolStats_dllpErrors2Weeks", "compute_PCIeFatalProtocolStats_dllpErrors2WeeksH", "compute_PCIeFatalProtocolStats_flowControlErrors", "compute_PCIeFatalProtocolStats_flowControlErrors15Min", "compute_PCIeFatalProtocolStats_flowControlErrors15MinH", "compute_PCIeFatalProtocolStats_flowControlErrors1Day", "compute_PCIeFatalProtocolStats_flowControlErrors1DayH", "compute_PCIeFatalProtocolStats_flowControlErrors1Hour", "compute_PCIeFatalProtocolStats_flowControlErrors1HourH", "compute_PCIeFatalProtocolStats_flowControlErrors1Week", "compute_PCIeFatalProtocolStats_flowControlErrors1WeekH", "compute_PCIeFatalProtocolStats_flowControlErrors2Weeks", "compute_PCIeFatalProtocolStats_flowControlErrors2WeeksH", "compute_PCIeFatalProtocolStats_intervals", "compute_PCIeFatalProtocolStats_suspect", "compute_PCIeFatalProtocolStats_thresholded", "compute_PCIeFatalProtocolStats_timeCollected", "compute_PCIeFatalProtocolStats_update", "compute_PCIeFatalReceiveStats_bufferOverflowErrors", "compute_PCIeFatalReceiveStats_bufferOverflowErrors15Min", "compute_PCIeFatalReceiveStats_bufferOverflowErrors15MinH", "compute_PCIeFatalReceiveStats_bufferOverflowErrors1Day", "compute_PCIeFatalReceiveStats_bufferOverflowErrors1DayH", "compute_PCIeFatalReceiveStats_bufferOverflowErrors1Hour", "compute_PCIeFatalReceiveStats_bufferOverflowErrors1HourH", "compute_PCIeFatalReceiveStats_bufferOverflowErrors1Week", "compute_PCIeFatalReceiveStats_bufferOverflowErrors1WeekH", "compute_PCIeFatalReceiveStats_bufferOverflowErrors2Weeks", "compute_PCIeFatalReceiveStats_bufferOverflowErrors2WeeksH", "compute_PCIeFatalReceiveStats_errFatalErrors", "compute_PCIeFatalReceiveStats_errFatalErrors15Min", "compute_PCIeFatalReceiveStats_errFatalErrors15MinH", "compute_PCIeFatalReceiveStats_errFatalErrors1Day", "compute_PCIeFatalReceiveStats_errFatalErrors1DayH", "compute_PCIeFatalReceiveStats_errFatalErrors1Hour", "compute_PCIeFatalReceiveStats_errFatalErrors1HourH", "compute_PCIeFatalReceiveStats_errFatalErrors1Week", "compute_PCIeFatalReceiveStats_errFatalErrors1WeekH", "compute_PCIeFatalReceiveStats_errFatalErrors2Weeks", "compute_PCIeFatalReceiveStats_errFatalErrors2WeeksH", "compute_PCIeFatalReceiveStats_errNonFatalErrors", "compute_PCIeFatalReceiveStats_errNonFatalErrors15Min", "compute_PCIeFatalReceiveStats_errNonFatalErrors15MinH", "compute_PCIeFatalReceiveStats_errNonFatalErrors1Day", "compute_PCIeFatalReceiveStats_errNonFatalErrors1DayH", "compute_PCIeFatalReceiveStats_errNonFatalErrors1Hour", "compute_PCIeFatalReceiveStats_errNonFatalErrors1HourH", "compute_PCIeFatalReceiveStats_errNonFatalErrors1Week", "compute_PCIeFatalReceiveStats_errNonFatalErrors1WeekH", "compute_PCIeFatalReceiveStats_errNonFatalErrors2Weeks", "compute_PCIeFatalReceiveStats_errNonFatalErrors2WeeksH", "compute_PCIeFatalReceiveStats_intervals", "compute_PCIeFatalReceiveStats_suspect", "compute_PCIeFatalReceiveStats_thresholded", "compute_PCIeFatalReceiveStats_timeCollected", "compute_PCIeFatalReceiveStats_unsupportedRequestErrors", "compute_PCIeFatalReceiveStats_unsupportedRequestErrors15Min", "compute_PCIeFatalReceiveStats_unsupportedRequestErrors15MinH", "compute_PCIeFatalReceiveStats_unsupportedRequestErrors1Day", "compute_PCIeFatalReceiveStats_unsupportedRequestErrors1DayH", "compute_PCIeFatalReceiveStats_unsupportedRequestErrors1Hour", "compute_PCIeFatalReceiveStats_unsupportedRequestErrors1HourH", "compute_PCIeFatalReceiveStats_unsupportedRequestErrors1Week", "compute_PCIeFatalReceiveStats_unsupportedRequestErrors1WeekH", "compute_PCIeFatalReceiveStats_unsupportedRequestErrors2Weeks", "compute_PCIeFatalReceiveStats_unsupportedRequestErrors2WeeksH", "compute_PCIeFatalReceiveStats_update", "compute_PCIeFatalStats_acsViolationErrors", "compute_PCIeFatalStats_acsViolationErrors15Min", "compute_PCIeFatalStats_acsViolationErrors15MinH", "compute_PCIeFatalStats_acsViolationErrors1Day", "compute_PCIeFatalStats_acsViolationErrors1DayH", "compute_PCIeFatalStats_acsViolationErrors1Hour", "compute_PCIeFatalStats_acsViolationErrors1HourH", "compute_PCIeFatalStats_acsViolationErrors1Week", "compute_PCIeFatalStats_acsViolationErrors1WeekH", "compute_PCIeFatalStats_acsViolationErrors2Weeks", "compute_PCIeFatalStats_acsViolationErrors2WeeksH", "compute_PCIeFatalStats_intervals", "compute_PCIeFatalStats_malformedTLPErrors", "compute_PCIeFatalStats_malformedTLPErrors15Min", "compute_PCIeFatalStats_malformedTLPErrors15MinH", "compute_PCIeFatalStats_malformedTLPErrors1Day", "compute_PCIeFatalStats_malformedTLPErrors1DayH", "compute_PCIeFatalStats_malformedTLPErrors1Hour", "compute_PCIeFatalStats_malformedTLPErrors1HourH", "compute_PCIeFatalStats_malformedTLPErrors1Week", "compute_PCIeFatalStats_malformedTLPErrors1WeekH", "compute_PCIeFatalStats_malformedTLPErrors2Weeks", "compute_PCIeFatalStats_malformedTLPErrors2WeeksH", "compute_PCIeFatalStats_poisonedTLPErrors", "compute_PCIeFatalStats_poisonedTLPErrors15Min", "compute_PCIeFatalStats_poisonedTLPErrors15MinH", "compute_PCIeFatalStats_poisonedTLPErrors1Day", "compute_PCIeFatalStats_poisonedTLPErrors1DayH", "compute_PCIeFatalStats_poisonedTLPErrors1Hour", "compute_PCIeFatalStats_poisonedTLPErrors1HourH", "compute_PCIeFatalStats_poisonedTLPErrors1Week", "compute_PCIeFatalStats_poisonedTLPErrors1WeekH", "compute_PCIeFatalStats_poisonedTLPErrors2Weeks", "compute_PCIeFatalStats_poisonedTLPErrors2WeeksH", "compute_PCIeFatalStats_surpriseLinkDownErrors", "compute_PCIeFatalStats_surpriseLinkDownErrors15Min", "compute_PCIeFatalStats_surpriseLinkDownErrors15MinH", "compute_PCIeFatalStats_surpriseLinkDownErrors1Day", "compute_PCIeFatalStats_surpriseLinkDownErrors1DayH", "compute_PCIeFatalStats_surpriseLinkDownErrors1Hour", "compute_PCIeFatalStats_surpriseLinkDownErrors1HourH", "compute_PCIeFatalStats_surpriseLinkDownErrors1Week", "compute_PCIeFatalStats_surpriseLinkDownErrors1WeekH", "compute_PCIeFatalStats_surpriseLinkDownErrors2Weeks", "compute_PCIeFatalStats_surpriseLinkDownErrors2WeeksH", "compute_PCIeFatalStats_suspect", "compute_PCIeFatalStats_thresholded", "compute_PCIeFatalStats_timeCollected", "compute_PCIeFatalStats_update", "compute_Partition_descr", "compute_Partition_intId", "compute_Partition_lsDn", "compute_Partition_name", "compute_Partition_pnDn", "compute_Partition_policyLevel", "compute_Partition_policyOwner", "compute_Partition_uuid", "compute_PciCap_maxBusIdPerSlot", "compute_PciCap_numOfPhysSlots", "compute_PciCap_order", "compute_PciCap_startsWith", "compute_PciSlotScanDef_descr", "compute_PciSlotScanDef_intId", "compute_PciSlotScanDef_name", "compute_PciSlotScanDef_policyLevel", "compute_PciSlotScanDef_policyOwner", "compute_PciSlotScanDef_scanOrder", "compute_PciSlotScanDef_slotId", "compute_PhysicalAssocCtx_fruCapDn", "compute_PhysicalFsmStage_descr", "compute_PhysicalFsmStage_lastUpdateTime", "compute_PhysicalFsmStage_name", "compute_PhysicalFsmStage_order", "compute_PhysicalFsmStage_retry", "compute_PhysicalFsmStage_stageStatus", "compute_PhysicalFsmTask_completion", "compute_PhysicalFsmTask_flags", "compute_PhysicalFsmTask_item", "compute_PhysicalFsmTask_seqId", "compute_PhysicalFsm_completionTime", "compute_PhysicalFsm_currentFsm", "compute_PhysicalFsm_descr", "compute_PhysicalFsm_fsmStatus", "compute_PhysicalFsm_instanceId", "compute_PhysicalFsm_progress", "compute_PhysicalFsm_rmtErrCode", "compute_PhysicalFsm_rmtErrDescr", "compute_PhysicalFsm_rmtRslt", "compute_PhysicalQual_model", "compute_Physical_adminPower", "compute_Physical_adminState", "compute_Physical_assignedToDn", "compute_Physical_association", "compute_Physical_availability", "compute_Physical_availableMemory", "compute_Physical_checkPoint", "compute_Physical_connPath", "compute_Physical_connStatus", "compute_Physical_descr", "compute_Physical_discovery", "compute_Physical_fsmDescr", "compute_Physical_fsmFlags", "compute_Physical_fsmPrev", "compute_Physical_fsmProgr", "compute_Physical_fsmRmtInvErrCode", "compute_Physical_fsmRmtInvErrDescr", "compute_Physical_fsmRmtInvRslt", "compute_Physical_fsmStageDescr", "compute_Physical_fsmStamp", "compute_Physical_fsmStatus", "compute_Physical_fsmTry", "compute_Physical_intId", "compute_Physical_lc", "compute_Physical_lcTs", "compute_Physical_localId", "compute_Physical_lowVoltageMemory", "compute_Physical_managingInst", "compute_Physical_memorySpeed", "compute_Physical_mfgTime", "compute_Physical_model", "compute_Physical_name", "compute_Physical_numOfAdaptors", "compute_Physical_numOfCores", "compute_Physical_numOfCoresEnabled", "compute_Physical_numOfCpus", "compute_Physical_numOfEthHostIfs", "compute_Physical_numOfFcHostIfs", "compute_Physical_numOfThreads", "compute_Physical_operPower", "compute_Physical_operQualifier", "compute_Physical_operState", "compute_Physical_operability", "compute_Physical_originalUuid", "compute_Physical_partNumber", "compute_Physical_policyLevel", "compute_Physical_policyOwner", "compute_Physical_presence", "compute_Physical_revision", "compute_Physical_serial", "compute_Physical_serverId", "compute_Physical_totalMemory", "compute_Physical_usrLbl", "compute_Physical_uuid", "compute_Physical_vendor", "compute_Physical_vid", "compute_Platform_model", "compute_Platform_productName", "compute_Platform_revision", "compute_Platform_vendor", "compute_PnuOSImage_imgLoc", "compute_PnuOSImage_imgName", "compute_PoolPolicyRef_id", "compute_PoolPolicyRef_policyDn", "compute_Pool_assigned", "compute_Pool_assignmentOrder", "compute_Pool_descr", "compute_Pool_intId", "compute_Pool_name", "compute_Pool_policyLevel", "compute_Pool_policyOwner", "compute_Pool_size", "compute_Poolable_id", "compute_Poolable_poolDn", "compute_PooledPhysical_assigned", "compute_PooledPhysical_assignedToDn", "compute_PooledPhysical_owner", "compute_PooledPhysical_poolableDn", "compute_PooledPhysical_prevAssignedToDn", "compute_PooledRackUnit_assigned", "compute_PooledRackUnit_assignedToDn", "compute_PooledRackUnit_id", "compute_PooledRackUnit_owner", "compute_PooledRackUnit_poolableDn", "compute_PooledRackUnit_prevAssignedToDn", "compute_PooledSlot_assigned", "compute_PooledSlot_assignedToDn", "compute_PooledSlot_chassisId", "compute_PooledSlot_owner", "compute_PooledSlot_poolableDn", "compute_PooledSlot_prevAssignedToDn", "compute_PooledSlot_slotId", "compute_Pooled_assigned", "compute_Pooled_assignedToDn", "compute_Pooled_owner", "compute_Pooled_poolableDn", "compute_Pooled_prevAssignedToDn", "compute_PoolingPolicy_descr", "compute_PoolingPolicy_intId", "compute_PoolingPolicy_name", "compute_PoolingPolicy_policyLevel", "compute_PoolingPolicy_policyOwner", "compute_PoolingPolicy_poolDn", "compute_PoolingPolicy_qualifier", "compute_PsuControl_clusterState", "compute_PsuControl_descr", "compute_PsuControl_inputPowerState", "compute_PsuControl_intId", "compute_PsuControl_name", "compute_PsuControl_operQualifier", "compute_PsuControl_operState", "compute_PsuControl_outputPowerState", "compute_PsuControl_policyLevel", "compute_PsuControl_policyOwner", "compute_PsuControl_redundancy", "compute_PsuDef_descr", "compute_PsuDef_intId", "compute_PsuDef_name", "compute_PsuDef_policyLevel", "compute_PsuDef_policyOwner", "compute_PsuDef_redundancy", "compute_PsuPolicy_descr", "compute_PsuPolicy_intId", "compute_PsuPolicy_name", "compute_PsuPolicy_policyLevel", "compute_PsuPolicy_policyOwner", "compute_PsuPolicy_redundancy", "compute_Qual_descr", "compute_Qual_intId", "compute_Qual_name", "compute_Qual_policyLevel", "compute_Qual_policyOwner", "compute_QualifiedPolicy_descr", "compute_QualifiedPolicy_intId", "compute_QualifiedPolicy_name", "compute_QualifiedPolicy_policyLevel", "compute_QualifiedPolicy_policyOwner", "compute_QualifiedPolicy_qualifier", "compute_RackPosQual_maxId", "compute_RackPosQual_minId", "compute_RackQual_maxId", "compute_RackQual_minId", "compute_RackUnitFsmStage_descr", "compute_RackUnitFsmStage_lastUpdateTime", "compute_RackUnitFsmStage_name", "compute_RackUnitFsmStage_order", "compute_RackUnitFsmStage_retry", "compute_RackUnitFsmStage_stageStatus", "compute_RackUnitFsmTask_completion", "compute_RackUnitFsmTask_flags", "compute_RackUnitFsmTask_item", "compute_RackUnitFsmTask_seqId", "compute_RackUnitFsm_completionTime", "compute_RackUnitFsm_currentFsm", "compute_RackUnitFsm_descr", "compute_RackUnitFsm_fsmStatus", "compute_RackUnitFsm_instanceId", "compute_RackUnitFsm_progress", "compute_RackUnitFsm_rmtErrCode", "compute_RackUnitFsm_rmtErrDescr", "compute_RackUnitFsm_rmtRslt", "compute_RackUnitMbTempStatsHist_ambientTemp", "compute_RackUnitMbTempStatsHist_ambientTempAvg", "compute_RackUnitMbTempStatsHist_ambientTempMax", "compute_RackUnitMbTempStatsHist_ambientTempMin", "compute_RackUnitMbTempStatsHist_frontTemp", "compute_RackUnitMbTempStatsHist_frontTempAvg", "compute_RackUnitMbTempStatsHist_frontTempMax", "compute_RackUnitMbTempStatsHist_frontTempMin", "compute_RackUnitMbTempStatsHist_id", "compute_RackUnitMbTempStatsHist_ioh1Temp", "compute_RackUnitMbTempStatsHist_ioh1TempAvg", "compute_RackUnitMbTempStatsHist_ioh1TempMax", "compute_RackUnitMbTempStatsHist_ioh1TempMin", "compute_RackUnitMbTempStatsHist_ioh2Temp", "compute_RackUnitMbTempStatsHist_ioh2TempAvg", "compute_RackUnitMbTempStatsHist_ioh2TempMax", "compute_RackUnitMbTempStatsHist_ioh2TempMin", "compute_RackUnitMbTempStatsHist_mostRecent", "compute_RackUnitMbTempStatsHist_rearTemp", "compute_RackUnitMbTempStatsHist_rearTempAvg", "compute_RackUnitMbTempStatsHist_rearTempMax", "compute_RackUnitMbTempStatsHist_rearTempMin", "compute_RackUnitMbTempStatsHist_suspect", "compute_RackUnitMbTempStatsHist_thresholded", "compute_RackUnitMbTempStatsHist_timeCollected", "compute_RackUnitMbTempStats_ambientTemp", "compute_RackUnitMbTempStats_ambientTempAvg", "compute_RackUnitMbTempStats_ambientTempMax", "compute_RackUnitMbTempStats_ambientTempMin", "compute_RackUnitMbTempStats_frontTemp", "compute_RackUnitMbTempStats_frontTempAvg", "compute_RackUnitMbTempStats_frontTempMax", "compute_RackUnitMbTempStats_frontTempMin", "compute_RackUnitMbTempStats_intervals", "compute_RackUnitMbTempStats_ioh1Temp", "compute_RackUnitMbTempStats_ioh1TempAvg", "compute_RackUnitMbTempStats_ioh1TempMax", "compute_RackUnitMbTempStats_ioh1TempMin", "compute_RackUnitMbTempStats_ioh2Temp", "compute_RackUnitMbTempStats_ioh2TempAvg", "compute_RackUnitMbTempStats_ioh2TempMax", "compute_RackUnitMbTempStats_ioh2TempMin", "compute_RackUnitMbTempStats_rearTemp", "compute_RackUnitMbTempStats_rearTempAvg", "compute_RackUnitMbTempStats_rearTempMax", "compute_RackUnitMbTempStats_rearTempMin", "compute_RackUnitMbTempStats_suspect", "compute_RackUnitMbTempStats_thresholded", "compute_RackUnitMbTempStats_timeCollected", "compute_RackUnitMbTempStats_update", "compute_RackUnit_adminPower", "compute_RackUnit_adminState", "compute_RackUnit_assignedToDn", "compute_RackUnit_association", "compute_RackUnit_availability", "compute_RackUnit_availableMemory", "compute_RackUnit_checkPoint", "compute_RackUnit_connPath", "compute_RackUnit_connStatus", "compute_RackUnit_descr", "compute_RackUnit_discovery", "compute_RackUnit_fltAggr", "compute_RackUnit_fsmDescr", "compute_RackUnit_fsmFlags", "compute_RackUnit_fsmPrev", "compute_RackUnit_fsmProgr", "compute_RackUnit_fsmRmtInvErrCode", "compute_RackUnit_fsmRmtInvErrDescr", "compute_RackUnit_fsmRmtInvRslt", "compute_RackUnit_fsmStageDescr", "compute_RackUnit_fsmStamp", "compute_RackUnit_fsmStatus", "compute_RackUnit_fsmTry", "compute_RackUnit_id", "compute_RackUnit_intId", "compute_RackUnit_lc", "compute_RackUnit_lcTs", "compute_RackUnit_localId", "compute_RackUnit_lowVoltageMemory", "compute_RackUnit_managingInst", "compute_RackUnit_memorySpeed", "compute_RackUnit_mfgTime", "compute_RackUnit_model", "compute_RackUnit_name", "compute_RackUnit_numOfAdaptors", "compute_RackUnit_numOfCores", "compute_RackUnit_numOfCoresEnabled", "compute_RackUnit_numOfCpus", "compute_RackUnit_numOfEthHostIfs", "compute_RackUnit_numOfFcHostIfs", "compute_RackUnit_numOfThreads", "compute_RackUnit_operPower", "compute_RackUnit_operQualifier", "compute_RackUnit_operState", "compute_RackUnit_operability", "compute_RackUnit_originalUuid", "compute_RackUnit_partNumber", "compute_RackUnit_policyLevel", "compute_RackUnit_policyOwner", "compute_RackUnit_presence", "compute_RackUnit_revision", "compute_RackUnit_serial", "compute_RackUnit_serverId", "compute_RackUnit_totalMemory", "compute_RackUnit_usrLbl", "compute_RackUnit_uuid", "compute_RackUnit_vendor", "compute_RackUnit_versionHolder", "compute_RackUnit_vid", "compute_RtcBattery_id", "compute_RtcBattery_model", "compute_RtcBattery_operQualifierReason", "compute_RtcBattery_operState", "compute_RtcBattery_operability", "compute_RtcBattery_perf", "compute_RtcBattery_power", "compute_RtcBattery_presence", "compute_RtcBattery_revision", "compute_RtcBattery_serial", "compute_RtcBattery_thermal", "compute_RtcBattery_vendor", "compute_RtcBattery_voltage", "compute_ScrubPolicy_biosSettingsScrub", "compute_ScrubPolicy_descr", "compute_ScrubPolicy_diskScrub", "compute_ScrubPolicy_flexFlashScrub", "compute_ScrubPolicy_intId", "compute_ScrubPolicy_name", "compute_ScrubPolicy_policyLevel", "compute_ScrubPolicy_policyOwner", "compute_ServerDiscPolicyFsmStage_descr", "compute_ServerDiscPolicyFsmStage_lastUpdateTime", "compute_ServerDiscPolicyFsmStage_name", "compute_ServerDiscPolicyFsmStage_order", "compute_ServerDiscPolicyFsmStage_retry", "compute_ServerDiscPolicyFsmStage_stageStatus", "compute_ServerDiscPolicyFsmTask_completion", "compute_ServerDiscPolicyFsmTask_flags", "compute_ServerDiscPolicyFsmTask_item", "compute_ServerDiscPolicyFsmTask_seqId", "compute_ServerDiscPolicyFsm_completionTime", "compute_ServerDiscPolicyFsm_currentFsm", "compute_ServerDiscPolicyFsm_descr", "compute_ServerDiscPolicyFsm_fsmStatus", "compute_ServerDiscPolicyFsm_instanceId", "compute_ServerDiscPolicyFsm_progress", "compute_ServerDiscPolicyFsm_rmtErrCode", "compute_ServerDiscPolicyFsm_rmtErrDescr", "compute_ServerDiscPolicyFsm_rmtRslt", "compute_ServerDiscPolicy_action", "compute_ServerDiscPolicy_descr", "compute_ServerDiscPolicy_fsmDescr", "compute_ServerDiscPolicy_fsmPrev", "compute_ServerDiscPolicy_fsmProgr", "compute_ServerDiscPolicy_fsmRmtInvErrCode", "compute_ServerDiscPolicy_fsmRmtInvErrDescr", "compute_ServerDiscPolicy_fsmRmtInvRslt", "compute_ServerDiscPolicy_fsmStageDescr", "compute_ServerDiscPolicy_fsmStamp", "compute_ServerDiscPolicy_fsmStatus", "compute_ServerDiscPolicy_fsmTry", "compute_ServerDiscPolicy_intId", "compute_ServerDiscPolicy_name", "compute_ServerDiscPolicy_policyLevel", "compute_ServerDiscPolicy_policyOwner", "compute_ServerDiscPolicy_qualifier", "compute_ServerDiscPolicy_scrubPolicyName", "compute_ServerMgmtPolicy_action", "compute_ServerMgmtPolicy_descr", "compute_ServerMgmtPolicy_intId", "compute_ServerMgmtPolicy_name", "compute_ServerMgmtPolicy_policyLevel", "compute_ServerMgmtPolicy_policyOwner", "compute_ServerMgmtPolicy_qualifier", "compute_SlotQual_maxId", "compute_SlotQual_minId", "compute_VirtualContainer_descr", "compute_VirtualContainer_intId", "compute_VirtualContainer_lsDn", "compute_VirtualContainer_name", "compute_VirtualContainer_pnDn", "compute_VirtualContainer_policyLevel", "compute_VirtualContainer_policyOwner", "compute_VirtualContainer_uuid", "compute_Virtual_descr", "compute_Virtual_intId", "compute_Virtual_lsDn", "compute_Virtual_name", "compute_Virtual_pnDn", "compute_Virtual_policyLevel", "compute_Virtual_policyOwner", "compute_Virtual_uuid", "condition_Immutable_cause", "condition_Immutable_changeSet", "condition_Immutable_code", "condition_Immutable_created", "condition_Immutable_descr", "condition_Immutable_id", "condition_Immutable_rule", "condition_Immutable_severity", "condition_Immutable_tags", "condition_Immutable_type", "condition_Info_cause", "condition_Info_changeSet", "condition_Info_code", "condition_Info_created", "condition_Info_descr", "condition_Info_severity", "condition_Log_maxSize", "condition_Log_purgeWindow", "condition_Log_size", "condition_Loggable_affected", "condition_Loggable_cause", "condition_Loggable_changeSet", "condition_Loggable_code", "condition_Loggable_created", "condition_Loggable_descr", "condition_Loggable_id", "condition_Loggable_ind", "condition_Loggable_sessionId", "condition_Loggable_severity", "condition_Loggable_trig", "condition_Loggable_txId", "condition_Loggable_user", "condition_MultiInstanceImmutable_cause", "condition_MultiInstanceImmutable_changeSet", "condition_MultiInstanceImmutable_code", "condition_MultiInstanceImmutable_created", "condition_MultiInstanceImmutable_descr", "condition_MultiInstanceImmutable_id", "condition_MultiInstanceImmutable_rule", "condition_MultiInstanceImmutable_severity", "condition_MultiInstanceImmutable_tags", "condition_MultiInstanceImmutable_type", "condition_Mutable_cause", "condition_Mutable_changeSet", "condition_Mutable_code", "condition_Mutable_created", "condition_Mutable_descr", "condition_Mutable_highestSeverity", "condition_Mutable_id", "condition_Mutable_lastTransition", "condition_Mutable_origSeverity", "condition_Mutable_prevSeverity", "condition_Mutable_rule", "condition_Mutable_severity", "condition_Mutable_tags", "condition_Mutable_type", "condition_Policy_descr", "condition_Policy_intId", "condition_Policy_name", "condition_Policy_policyLevel", "condition_Policy_policyOwner", "condition_Policy_retentionInterval", "condition_Policy_sizeLimit", "condition_Reportable_cause", "condition_Reportable_changeSet", "condition_Reportable_code", "condition_Reportable_created", "condition_Reportable_descr", "condition_Reportable_id", "condition_Reportable_rule", "condition_Reportable_severity", "condition_Reportable_tags", "condition_Reportable_type", "config_ImpactResponse_appConnectorId", "config_ImpactResponse_impactAnalyzerId", "config_ImpactResponse_sourceConnectorId", "config_ImpactResponse_state", "config_Impact_affectedObj", "config_Impact_affectedServer", "config_Impact_changes", "config_Impact_configIssues", "config_Impact_configQualifier", "config_Impact_configState", "config_Impact_deploymentMode", "config_Impact_name", "config_Impact_rebootRequired", "config_ManagedEpImpactResponse_affectedServers", "config_ManagedEpImpactResponse_appConnectorId", "config_ManagedEpImpactResponse_epName", "config_ManagedEpImpactResponse_impactAnalyzerId", "config_ManagedEpImpactResponse_rebootRequired", "config_ManagedEpImpactResponse_sourceConnectorId", "config_ManagedEpImpactResponse_state", "config_Sorter_direction", "config_Sorter_sortClass", "config_Sorter_sortProp", "dcx_Ns_allocStatus", "dcx_Ns_side", "dcx_Ns_size", "dcx_Ns_switchId", "dcx_Ns_used", "dcx_PathProtection_protPeerId", "dcx_PathProtection_protRole", "dcx_StatefulEndPoint_adminState", "dcx_VIf_adminState", "dcx_VIf_cookie", "dcx_VIf_epDn", "dcx_VIf_id", "dcx_VIf_ifRole", "dcx_VIf_ifType", "dcx_VIf_instType", "dcx_VIf_lc", "dcx_VIf_linkState", "dcx_VIf_locale", "dcx_VIf_name", "dcx_VIf_operState", "dcx_VIf_peerDn", "dcx_VIf_protPeerId", "dcx_VIf_protRole", "dcx_VIf_protState", "dcx_VIf_qosControl", "dcx_VIf_state", "dcx_VIf_switchId", "dcx_VIf_tag", "dcx_VIf_transport", "dcx_VIf_type", "dcx_Vc_adminState", "dcx_Vc_borderPortId", "dcx_Vc_borderSlotId", "dcx_Vc_borderVfcId", "dcx_Vc_cdp", "dcx_Vc_cookie", "dcx_Vc_cos", "dcx_Vc_derivedFromId", "dcx_Vc_encap", "dcx_Vc_fcoeId", "dcx_Vc_forgeMac", "dcx_Vc_id", "dcx_Vc_instType", "dcx_Vc_lc", "dcx_Vc_linkState", "dcx_Vc_locale", "dcx_Vc_macRegisterMode", "dcx_Vc_monTrafDir", "dcx_Vc_name", "dcx_Vc_operBorderPortId", "dcx_Vc_operBorderSlotId", "dcx_Vc_operState", "dcx_Vc_peerId", "dcx_Vc_protState", "dcx_Vc_qosPolicyDn", "dcx_Vc_qosPolicyId", "dcx_Vc_role", "dcx_Vc_state", "dcx_Vc_stateQual", "dcx_Vc_switchId", "dcx_Vc_tag", "dcx_Vc_transport", "dcx_Vc_type", "dcx_Vc_uplinkFailAction", "dcx_Vc_vnic", "dcx_VifEp_id", "dhcp_Acquired_acqts", "dhcp_Acquired_cookie", "dhcp_Acquired_ends", "dhcp_Acquired_ip", "dhcp_Acquired_mac", "dhcp_Acquired_sysId", "dhcp_Lease_cliId", "dhcp_Lease_cookie", "dhcp_Lease_ends", "dhcp_Lease_hostname", "dhcp_Lease_intf", "dhcp_Lease_ip", "dhcp_Lease_mac", "dhcp_Lease_starts", "diag_BladeTest_length", "diag_BladeTest_order", "diag_BladeTest_type", "diag_Ctrl_adminState", "diag_Ctrl_endTs", "diag_Ctrl_endTsM", "diag_Ctrl_errorDescr", "diag_Ctrl_operQualifier", "diag_Ctrl_operState", "diag_Ctrl_startTs", "diag_Ctrl_startTsM", "diag_Ctrl_type", "diag_NetworkTest_length", "diag_NetworkTest_order", "diag_NetworkTest_switchId", "diag_NetworkTest_type", "diag_Rslt_descr", "diag_Rslt_endTs", "diag_Rslt_id", "diag_Rslt_result", "diag_Rslt_rsltStatus", "diag_Rslt_startTs", "diag_RunPolicy_descr", "diag_RunPolicy_failureAction", "diag_RunPolicy_intId", "diag_RunPolicy_name", "diag_RunPolicy_policyLevel", "diag_RunPolicy_policyOwner", "diag_RunPolicy_successAction", "diag_SrvCapProvider_deleted", "diag_SrvCapProvider_deprecated", "diag_SrvCapProvider_elementLoadFailures", "diag_SrvCapProvider_elementsLoaded", "diag_SrvCapProvider_gencount", "diag_SrvCapProvider_loadErrors", "diag_SrvCapProvider_loadWarnings", "diag_SrvCapProvider_mgmtPlaneVer", "diag_SrvCapProvider_model", "diag_SrvCapProvider_promCardType", "diag_SrvCapProvider_revision", "diag_SrvCapProvider_vendor", "diag_SrvCtrl_adminState", "diag_SrvCtrl_endTs", "diag_SrvCtrl_endTsM", "diag_SrvCtrl_errorDescr", "diag_SrvCtrl_imgLoc", "diag_SrvCtrl_imgName", "diag_SrvCtrl_operQualifier", "diag_SrvCtrl_operState", "diag_SrvCtrl_runPolicyName", "diag_SrvCtrl_startTs", "diag_SrvCtrl_startTsM", "diag_SrvCtrl_type", "diag_Test_order", "domain_EnvironmentFeature_functionalState", "domain_EnvironmentFeature_name", "domain_EnvironmentFeature_type", "domain_EnvironmentParam_name", "domain_EnvironmentParam_value", "domain_Feature_functionalState", "domain_Feature_name", "domain_Feature_type", "domain_NetworkFeature_functionalState", "domain_NetworkFeature_name", "domain_NetworkFeature_type", "domain_NetworkParam_name", "domain_NetworkParam_value", "domain_Parameter_name", "domain_Parameter_value", "domain_ServerFeature_functionalState", "domain_ServerFeature_name", "domain_ServerFeature_type", "domain_ServerParam_name", "domain_ServerParam_value", "domain_StorageFeature_functionalState", "domain_StorageFeature_name", "domain_StorageFeature_type", "domain_StorageParam_name", "domain_StorageParam_value", "dpsec_Mac_descr", "dpsec_Mac_forge", "dpsec_Mac_intId", "dpsec_Mac_name", "dpsec_Mac_policyLevel", "dpsec_Mac_policyOwner", "epqos_Conf_cos", "epqos_Conf_qosPolicyDn", "epqos_Conf_qosPolicyId", "epqos_DefinitionDelTaskFsmStage_descr", "epqos_DefinitionDelTaskFsmStage_lastUpdateTime", "epqos_DefinitionDelTaskFsmStage_name", "epqos_DefinitionDelTaskFsmStage_order", "epqos_DefinitionDelTaskFsmStage_retry", "epqos_DefinitionDelTaskFsmStage_stageStatus", "epqos_DefinitionDelTaskFsmTask_completion", "epqos_DefinitionDelTaskFsmTask_flags", "epqos_DefinitionDelTaskFsmTask_item", "epqos_DefinitionDelTaskFsmTask_seqId", "epqos_DefinitionDelTaskFsm_completionTime", "epqos_DefinitionDelTaskFsm_currentFsm", "epqos_DefinitionDelTaskFsm_descr", "epqos_DefinitionDelTaskFsm_fsmStatus", "epqos_DefinitionDelTaskFsm_instanceId", "epqos_DefinitionDelTaskFsm_progress", "epqos_DefinitionDelTaskFsm_rmtErrCode", "epqos_DefinitionDelTaskFsm_rmtErrDescr", "epqos_DefinitionDelTaskFsm_rmtRslt", "epqos_DefinitionDelTask_defDn", "epqos_DefinitionDelTask_defIntId", "epqos_DefinitionDelTask_descr", "epqos_DefinitionDelTask_fsmDescr", "epqos_DefinitionDelTask_fsmPrev", "epqos_DefinitionDelTask_fsmProgr", "epqos_DefinitionDelTask_fsmRmtInvErrCode", "epqos_DefinitionDelTask_fsmRmtInvErrDescr", "epqos_DefinitionDelTask_fsmRmtInvRslt", "epqos_DefinitionDelTask_fsmStageDescr", "epqos_DefinitionDelTask_fsmStamp", "epqos_DefinitionDelTask_fsmStatus", "epqos_DefinitionDelTask_fsmTry", "epqos_DefinitionDelTask_intId", "epqos_DefinitionDelTask_name", "epqos_DefinitionDelTask_policyLevel", "epqos_DefinitionDelTask_policyOwner", "epqos_DefinitionFsmStage_descr", "epqos_DefinitionFsmStage_lastUpdateTime", "epqos_DefinitionFsmStage_name", "epqos_DefinitionFsmStage_order", "epqos_DefinitionFsmStage_retry", "epqos_DefinitionFsmStage_stageStatus", "epqos_DefinitionFsmTask_completion", "epqos_DefinitionFsmTask_flags", "epqos_DefinitionFsmTask_item", "epqos_DefinitionFsmTask_seqId", "epqos_DefinitionFsm_completionTime", "epqos_DefinitionFsm_currentFsm", "epqos_DefinitionFsm_descr", "epqos_DefinitionFsm_fsmStatus", "epqos_DefinitionFsm_instanceId", "epqos_DefinitionFsm_progress", "epqos_DefinitionFsm_rmtErrCode", "epqos_DefinitionFsm_rmtErrDescr", "epqos_DefinitionFsm_rmtRslt", "epqos_Definition_descr", "epqos_Definition_fsmDescr", "epqos_Definition_fsmPrev", "epqos_Definition_fsmProgr", "epqos_Definition_fsmRmtInvErrCode", "epqos_Definition_fsmRmtInvErrDescr", "epqos_Definition_fsmRmtInvRslt", "epqos_Definition_fsmStageDescr", "epqos_Definition_fsmStamp", "epqos_Definition_fsmStatus", "epqos_Definition_fsmTry", "epqos_Definition_intId", "epqos_Definition_name", "epqos_Definition_policyLevel", "epqos_Definition_policyOwner", "epqos_Egress_burst", "epqos_Egress_hostControl", "epqos_Egress_name", "epqos_Egress_operPrio", "epqos_Egress_prio", "epqos_Egress_rate", "epqos_Item_name", "equipment_AdaptorConnDef_adaptorEp", "equipment_AdaptorConnDef_descr", "equipment_AdaptorConnDef_intId", "equipment_AdaptorConnDef_iomEp", "equipment_AdaptorConnDef_name", "equipment_AdaptorConnDef_policyLevel", "equipment_AdaptorConnDef_policyOwner", "equipment_AdaptorDef_descr", "equipment_AdaptorDef_ethernetPortSpeed", "equipment_AdaptorDef_fibreChannelPortSpeed", "equipment_AdaptorDef_intId", "equipment_AdaptorDef_name", "equipment_AdaptorDef_policyLevel", "equipment_AdaptorDef_policyOwner", "equipment_AdvancedBootOrder_isSupported", "equipment_AdvancedBootOrder_minBiosVersion", "equipment_AdvancedBootOrder_minCimcVersion", "equipment_AssocCtx_fruCapDn", "equipment_BaseBoardCapProvider_deleted", "equipment_BaseBoardCapProvider_deprecated", "equipment_BaseBoardCapProvider_elementLoadFailures", "equipment_BaseBoardCapProvider_elementsLoaded", "equipment_BaseBoardCapProvider_gencount", "equipment_BaseBoardCapProvider_loadErrors", "equipment_BaseBoardCapProvider_loadWarnings", "equipment_BaseBoardCapProvider_mgmtPlaneVer", "equipment_BaseBoardCapProvider_model", "equipment_BaseBoardCapProvider_promCardType", "equipment_BaseBoardCapProvider_revision", "equipment_BaseBoardCapProvider_vendor", "equipment_BeaconCapProvider_descr", "equipment_BeaconCapProvider_intId", "equipment_BeaconCapProvider_name", "equipment_BeaconCapProvider_policyLevel", "equipment_BeaconCapProvider_policyOwner", "equipment_BeaconCapProvider_portModeBeacon", "equipment_BeaconLedFsmStage_descr", "equipment_BeaconLedFsmStage_lastUpdateTime", "equipment_BeaconLedFsmStage_name", "equipment_BeaconLedFsmStage_order", "equipment_BeaconLedFsmStage_retry", "equipment_BeaconLedFsmStage_stageStatus", "equipment_BeaconLedFsmTask_completion", "equipment_BeaconLedFsmTask_flags", "equipment_BeaconLedFsmTask_item", "equipment_BeaconLedFsmTask_seqId", "equipment_BeaconLedFsm_completionTime", "equipment_BeaconLedFsm_currentFsm", "equipment_BeaconLedFsm_descr", "equipment_BeaconLedFsm_fsmStatus", "equipment_BeaconLedFsm_instanceId", "equipment_BeaconLedFsm_progress", "equipment_BeaconLedFsm_rmtErrCode", "equipment_BeaconLedFsm_rmtErrDescr", "equipment_BeaconLedFsm_rmtRslt", "equipment_BeaconLed_adminState", "equipment_BeaconLed_color", "equipment_BeaconLed_fsmDescr", "equipment_BeaconLed_fsmPrev", "equipment_BeaconLed_fsmProgr", "equipment_BeaconLed_fsmRmtInvErrCode", "equipment_BeaconLed_fsmRmtInvErrDescr", "equipment_BeaconLed_fsmRmtInvRslt", "equipment_BeaconLed_fsmStageDescr", "equipment_BeaconLed_fsmStamp", "equipment_BeaconLed_fsmStatus", "equipment_BeaconLed_fsmTry", "equipment_BeaconLed_id", "equipment_BeaconLed_name", "equipment_BeaconLed_operState", "equipment_BiosDef_descr", "equipment_BiosDef_intId", "equipment_BiosDef_name", "equipment_BiosDef_policyLevel", "equipment_BiosDef_policyOwner", "equipment_BiosDef_resetOn", "equipment_BiosDef_secureBios", "equipment_BiosDef_storageMethod", "equipment_BiosDef_updateMethod", "equipment_BladeAGLibrary_descr", "equipment_BladeAGLibrary_intId", "equipment_BladeAGLibrary_name", "equipment_BladeAGLibrary_policyLevel", "equipment_BladeAGLibrary_policyOwner", "equipment_BladeBiosCapProvider_deleted", "equipment_BladeBiosCapProvider_deprecated", "equipment_BladeBiosCapProvider_elementLoadFailures", "equipment_BladeBiosCapProvider_elementsLoaded", "equipment_BladeBiosCapProvider_gencount", "equipment_BladeBiosCapProvider_loadErrors", "equipment_BladeBiosCapProvider_loadWarnings", "equipment_BladeBiosCapProvider_mgmtPlaneVer", "equipment_BladeBiosCapProvider_model", "equipment_BladeBiosCapProvider_productName", "equipment_BladeBiosCapProvider_promCardType", "equipment_BladeBiosCapProvider_revision", "equipment_BladeBiosCapProvider_vendor", "equipment_BladeCapProvider_deleted", "equipment_BladeCapProvider_deprecated", "equipment_BladeCapProvider_elementLoadFailures", "equipment_BladeCapProvider_elementsLoaded", "equipment_BladeCapProvider_gencount", "equipment_BladeCapProvider_loadErrors", "equipment_BladeCapProvider_loadWarnings", "equipment_BladeCapProvider_mgmtPlaneVer", "equipment_BladeCapProvider_model", "equipment_BladeCapProvider_promCardType", "equipment_BladeCapProvider_revision", "equipment_BladeCapProvider_vendor", "equipment_BladeConnDef_adaptorFamily", "equipment_BladeConnDef_adaptorSlotNumber", "equipment_BladeConnDef_adaptorSlotSpan", "equipment_BladeConnDef_adaptorType", "equipment_BladeConnDef_descr", "equipment_BladeConnDef_intId", "equipment_BladeConnDef_name", "equipment_BladeConnDef_parentAdaptorSlotNum", "equipment_BladeConnDef_policyLevel", "equipment_BladeConnDef_policyOwner", "equipment_BladeConnDef_switchPortMuxOffset", "equipment_BladeIOMConnDef_descr", "equipment_BladeIOMConnDef_intId", "equipment_BladeIOMConnDef_iocardType", "equipment_BladeIOMConnDef_name", "equipment_BladeIOMConnDef_policyLevel", "equipment_BladeIOMConnDef_policyOwner", "equipment_BladeIOMConnDef_portBandwidth", "equipment_BoardControllerDef_descr", "equipment_BoardControllerDef_intId", "equipment_BoardControllerDef_name", "equipment_BoardControllerDef_policyLevel", "equipment_BoardControllerDef_policyOwner", "equipment_Card_id", "equipment_Card_model", "equipment_Card_operQualifierReason", "equipment_Card_operState", "equipment_Card_operability", "equipment_Card_perf", "equipment_Card_power", "equipment_Card_presence", "equipment_Card_revision", "equipment_Card_serial", "equipment_Card_thermal", "equipment_Card_vendor", "equipment_Card_voltage", "equipment_CatalogCapProvider_deleted", "equipment_CatalogCapProvider_deprecated", "equipment_CatalogCapProvider_elementLoadFailures", "equipment_CatalogCapProvider_elementsLoaded", "equipment_CatalogCapProvider_gencount", "equipment_CatalogCapProvider_loadErrors", "equipment_CatalogCapProvider_loadWarnings", "equipment_CatalogCapProvider_mgmtPlaneVer", "equipment_CatalogCapProvider_model", "equipment_CatalogCapProvider_promCardType", "equipment_CatalogCapProvider_revision", "equipment_CatalogCapProvider_vendor", "equipment_ChassisCapProvider_deleted", "equipment_ChassisCapProvider_deprecated", "equipment_ChassisCapProvider_elementLoadFailures", "equipment_ChassisCapProvider_elementsLoaded", "equipment_ChassisCapProvider_gencount", "equipment_ChassisCapProvider_loadErrors", "equipment_ChassisCapProvider_loadWarnings", "equipment_ChassisCapProvider_mgmtPlaneVer", "equipment_ChassisCapProvider_model", "equipment_ChassisCapProvider_promCardType", "equipment_ChassisCapProvider_revision", "equipment_ChassisCapProvider_vendor", "equipment_ChassisComponent_chassisId", "equipment_ChassisComponent_slotId", "equipment_ChassisFsmStage_descr", "equipment_ChassisFsmStage_lastUpdateTime", "equipment_ChassisFsmStage_name", "equipment_ChassisFsmStage_order", "equipment_ChassisFsmStage_retry", "equipment_ChassisFsmStage_stageStatus", "equipment_ChassisFsmTask_completion", "equipment_ChassisFsmTask_flags", "equipment_ChassisFsmTask_item", "equipment_ChassisFsmTask_seqId", "equipment_ChassisFsm_completionTime", "equipment_ChassisFsm_currentFsm", "equipment_ChassisFsm_descr", "equipment_ChassisFsm_fsmStatus", "equipment_ChassisFsm_instanceId", "equipment_ChassisFsm_progress", "equipment_ChassisFsm_rmtErrCode", "equipment_ChassisFsm_rmtErrDescr", "equipment_ChassisFsm_rmtRslt", "equipment_ChassisStatsHist_id", "equipment_ChassisStatsHist_inputPower", "equipment_ChassisStatsHist_inputPowerAvg", "equipment_ChassisStatsHist_inputPowerMax", "equipment_ChassisStatsHist_inputPowerMin", "equipment_ChassisStatsHist_mostRecent", "equipment_ChassisStatsHist_outputPower", "equipment_ChassisStatsHist_outputPowerAvg", "equipment_ChassisStatsHist_outputPowerMax", "equipment_ChassisStatsHist_outputPowerMin", "equipment_ChassisStatsHist_suspect", "equipment_ChassisStatsHist_thresholded", "equipment_ChassisStatsHist_timeCollected", "equipment_ChassisStats_inputPower", "equipment_ChassisStats_inputPowerAvg", "equipment_ChassisStats_inputPowerMax", "equipment_ChassisStats_inputPowerMin", "equipment_ChassisStats_intervals", "equipment_ChassisStats_outputPower", "equipment_ChassisStats_outputPowerAvg", "equipment_ChassisStats_outputPowerMax", "equipment_ChassisStats_outputPowerMin", "equipment_ChassisStats_suspect", "equipment_ChassisStats_thresholded", "equipment_ChassisStats_timeCollected", "equipment_ChassisStats_update", "equipment_Chassis_ackProgressIndicator", "equipment_Chassis_adminState", "equipment_Chassis_configState", "equipment_Chassis_connPath", "equipment_Chassis_connStatus", "equipment_Chassis_fabricEpDn", "equipment_Chassis_fsmDescr", "equipment_Chassis_fsmPrev", "equipment_Chassis_fsmProgr", "equipment_Chassis_fsmRmtInvErrCode", "equipment_Chassis_fsmRmtInvErrDescr", "equipment_Chassis_fsmRmtInvRslt", "equipment_Chassis_fsmStageDescr", "equipment_Chassis_fsmStamp", "equipment_Chassis_fsmStatus", "equipment_Chassis_fsmTry", "equipment_Chassis_id", "equipment_Chassis_lcTs", "equipment_Chassis_licGP", "equipment_Chassis_licState", "equipment_Chassis_managingInst", "equipment_Chassis_mfgTime", "equipment_Chassis_model", "equipment_Chassis_operQualifier", "equipment_Chassis_operQualifierReason", "equipment_Chassis_operState", "equipment_Chassis_operability", "equipment_Chassis_partNumber", "equipment_Chassis_power", "equipment_Chassis_presence", "equipment_Chassis_revision", "equipment_Chassis_seepromOperState", "equipment_Chassis_serial", "equipment_Chassis_thermal", "equipment_Chassis_thermalStateQualifier", "equipment_Chassis_usrLbl", "equipment_Chassis_vendor", "equipment_Chassis_versionHolder", "equipment_Chassis_vid", "equipment_Connectivity_connPath", "equipment_Connectivity_connStatus", "equipment_Connectivity_managingInst", "equipment_DbgPluginCapProvider_deleted", "equipment_DbgPluginCapProvider_deprecated", "equipment_DbgPluginCapProvider_elementLoadFailures", "equipment_DbgPluginCapProvider_elementsLoaded", "equipment_DbgPluginCapProvider_gencount", "equipment_DbgPluginCapProvider_loadErrors", "equipment_DbgPluginCapProvider_loadWarnings", "equipment_DbgPluginCapProvider_mgmtPlaneVer", "equipment_DbgPluginCapProvider_model", "equipment_DbgPluginCapProvider_promCardType", "equipment_DbgPluginCapProvider_revision", "equipment_DbgPluginCapProvider_vendor", "equipment_DimmEntry_id", "equipment_DimmEntry_smbiosname", "equipment_DimmMapping_descr", "equipment_DimmMapping_intId", "equipment_DimmMapping_name", "equipment_DimmMapping_policyLevel", "equipment_DimmMapping_policyOwner", "equipment_DiscoveryCap_operPowerRequirement", "equipment_DowngradeConstraint_minVer", "equipment_EnvSensor_name", "equipment_EnvSensor_type", "equipment_EnvSensor_value", "equipment_FanModuleCapProvider_deleted", "equipment_FanModuleCapProvider_deprecated", "equipment_FanModuleCapProvider_elementLoadFailures", "equipment_FanModuleCapProvider_elementsLoaded", "equipment_FanModuleCapProvider_gencount", "equipment_FanModuleCapProvider_loadErrors", "equipment_FanModuleCapProvider_loadWarnings", "equipment_FanModuleCapProvider_mgmtPlaneVer", "equipment_FanModuleCapProvider_model", "equipment_FanModuleCapProvider_promCardType", "equipment_FanModuleCapProvider_revision", "equipment_FanModuleCapProvider_vendor", "equipment_FanModuleDef_descr", "equipment_FanModuleDef_fanCapacity", "equipment_FanModuleDef_intId", "equipment_FanModuleDef_name", "equipment_FanModuleDef_policyLevel", "equipment_FanModuleDef_policyOwner", "equipment_FanModuleStatsHist_ambientTemp", "equipment_FanModuleStatsHist_ambientTempAvg", "equipment_FanModuleStatsHist_ambientTempMax", "equipment_FanModuleStatsHist_ambientTempMin", "equipment_FanModuleStatsHist_id", "equipment_FanModuleStatsHist_mostRecent", "equipment_FanModuleStatsHist_suspect", "equipment_FanModuleStatsHist_thresholded", "equipment_FanModuleStatsHist_timeCollected", "equipment_FanModuleStats_ambientTemp", "equipment_FanModuleStats_ambientTempAvg", "equipment_FanModuleStats_ambientTempMax", "equipment_FanModuleStats_ambientTempMin", "equipment_FanModuleStats_intervals", "equipment_FanModuleStats_suspect", "equipment_FanModuleStats_thresholded", "equipment_FanModuleStats_timeCollected", "equipment_FanModuleStats_update", "equipment_FanModule_id", "equipment_FanModule_mfgTime", "equipment_FanModule_model", "equipment_FanModule_operQualifierReason", "equipment_FanModule_operState", "equipment_FanModule_operability", "equipment_FanModule_partNumber", "equipment_FanModule_perf", "equipment_FanModule_power", "equipment_FanModule_presence", "equipment_FanModule_revision", "equipment_FanModule_serial", "equipment_FanModule_thermal", "equipment_FanModule_tray", "equipment_FanModule_vendor", "equipment_FanModule_vid", "equipment_FanModule_voltage", "equipment_FanStatsHist_id", "equipment_FanStatsHist_mostRecent", "equipment_FanStatsHist_speed", "equipment_FanStatsHist_speedAvg", "equipment_FanStatsHist_speedMax", "equipment_FanStatsHist_speedMin", "equipment_FanStatsHist_suspect", "equipment_FanStatsHist_thresholded", "equipment_FanStatsHist_timeCollected", "equipment_FanStats_intervals", "equipment_FanStats_speed", "equipment_FanStats_speedAvg", "equipment_FanStats_speedMax", "equipment_FanStats_speedMin", "equipment_FanStats_suspect", "equipment_FanStats_thresholded", "equipment_FanStats_timeCollected", "equipment_FanStats_update", "equipment_Fan_id", "equipment_Fan_intType", "equipment_Fan_model", "equipment_Fan_module", "equipment_Fan_operQualifierReason", "equipment_Fan_operState", "equipment_Fan_operability", "equipment_Fan_perf", "equipment_Fan_power", "equipment_Fan_presence", "equipment_Fan_revision", "equipment_Fan_serial", "equipment_Fan_thermal", "equipment_Fan_tray", "equipment_Fan_vendor", "equipment_Fan_voltage", "equipment_FexCapProvider_deleted", "equipment_FexCapProvider_deprecated", "equipment_FexCapProvider_elementLoadFailures", "equipment_FexCapProvider_elementsLoaded", "equipment_FexCapProvider_gencount", "equipment_FexCapProvider_loadErrors", "equipment_FexCapProvider_loadWarnings", "equipment_FexCapProvider_mgmtPlaneVer", "equipment_FexCapProvider_model", "equipment_FexCapProvider_promCardType", "equipment_FexCapProvider_revision", "equipment_FexCapProvider_role", "equipment_FexCapProvider_vendor", "equipment_FexEnvStatsHist_die1", "equipment_FexEnvStatsHist_die1Avg", "equipment_FexEnvStatsHist_die1Max", "equipment_FexEnvStatsHist_die1Min", "equipment_FexEnvStatsHist_id", "equipment_FexEnvStatsHist_inlet", "equipment_FexEnvStatsHist_inlet1", "equipment_FexEnvStatsHist_inlet1Avg", "equipment_FexEnvStatsHist_inlet1Max", "equipment_FexEnvStatsHist_inlet1Min", "equipment_FexEnvStatsHist_inletAvg", "equipment_FexEnvStatsHist_inletMax", "equipment_FexEnvStatsHist_inletMin", "equipment_FexEnvStatsHist_mostRecent", "equipment_FexEnvStatsHist_outlet1", "equipment_FexEnvStatsHist_outlet1Avg", "equipment_FexEnvStatsHist_outlet1Max", "equipment_FexEnvStatsHist_outlet1Min", "equipment_FexEnvStatsHist_outlet2", "equipment_FexEnvStatsHist_outlet2Avg", "equipment_FexEnvStatsHist_outlet2Max", "equipment_FexEnvStatsHist_outlet2Min", "equipment_FexEnvStatsHist_suspect", "equipment_FexEnvStatsHist_thresholded", "equipment_FexEnvStatsHist_timeCollected", "equipment_FexEnvStats_die1", "equipment_FexEnvStats_die1Avg", "equipment_FexEnvStats_die1Max", "equipment_FexEnvStats_die1Min", "equipment_FexEnvStats_inlet", "equipment_FexEnvStats_inlet1", "equipment_FexEnvStats_inlet1Avg", "equipment_FexEnvStats_inlet1Max", "equipment_FexEnvStats_inlet1Min", "equipment_FexEnvStats_inletAvg", "equipment_FexEnvStats_inletMax", "equipment_FexEnvStats_inletMin", "equipment_FexEnvStats_inputStatus", "equipment_FexEnvStats_intervals", "equipment_FexEnvStats_outlet1", "equipment_FexEnvStats_outlet1Avg", "equipment_FexEnvStats_outlet1Max", "equipment_FexEnvStats_outlet1Min", "equipment_FexEnvStats_outlet2", "equipment_FexEnvStats_outlet2Avg", "equipment_FexEnvStats_outlet2Max", "equipment_FexEnvStats_outlet2Min", "equipment_FexEnvStats_suspect", "equipment_FexEnvStats_thresholded", "equipment_FexEnvStats_timeCollected", "equipment_FexEnvStats_update", "equipment_FexFsmStage_descr", "equipment_FexFsmStage_lastUpdateTime", "equipment_FexFsmStage_name", "equipment_FexFsmStage_order", "equipment_FexFsmStage_retry", "equipment_FexFsmStage_stageStatus", "equipment_FexFsmTask_completion", "equipment_FexFsmTask_flags", "equipment_FexFsmTask_item", "equipment_FexFsmTask_seqId", "equipment_FexFsm_completionTime", "equipment_FexFsm_currentFsm", "equipment_FexFsm_descr", "equipment_FexFsm_fsmStatus", "equipment_FexFsm_instanceId", "equipment_FexFsm_progress", "equipment_FexFsm_rmtErrCode", "equipment_FexFsm_rmtErrDescr", "equipment_FexFsm_rmtRslt", "equipment_FexPowerSummaryHist_ModulePower", "equipment_FexPowerSummaryHist_ModulePowerAvg", "equipment_FexPowerSummaryHist_ModulePowerMax", "equipment_FexPowerSummaryHist_ModulePowerMin", "equipment_FexPowerSummaryHist_availablePower", "equipment_FexPowerSummaryHist_availablePowerAvg", "equipment_FexPowerSummaryHist_availablePowerMax", "equipment_FexPowerSummaryHist_availablePowerMin", "equipment_FexPowerSummaryHist_id", "equipment_FexPowerSummaryHist_mostRecent", "equipment_FexPowerSummaryHist_reservedPower", "equipment_FexPowerSummaryHist_reservedPowerAvg", "equipment_FexPowerSummaryHist_reservedPowerMax", "equipment_FexPowerSummaryHist_reservedPowerMin", "equipment_FexPowerSummaryHist_suspect", "equipment_FexPowerSummaryHist_thresholded", "equipment_FexPowerSummaryHist_timeCollected", "equipment_FexPowerSummaryHist_totalPower", "equipment_FexPowerSummaryHist_totalPowerAvg", "equipment_FexPowerSummaryHist_totalPowerMax", "equipment_FexPowerSummaryHist_totalPowerMin", "equipment_FexPowerSummary_ModulePower", "equipment_FexPowerSummary_ModulePowerAvg", "equipment_FexPowerSummary_ModulePowerMax", "equipment_FexPowerSummary_ModulePowerMin", "equipment_FexPowerSummary_availablePower", "equipment_FexPowerSummary_availablePowerAvg", "equipment_FexPowerSummary_availablePowerMax", "equipment_FexPowerSummary_availablePowerMin", "equipment_FexPowerSummary_intervals", "equipment_FexPowerSummary_reservedPower", "equipment_FexPowerSummary_reservedPowerAvg", "equipment_FexPowerSummary_reservedPowerMax", "equipment_FexPowerSummary_reservedPowerMin", "equipment_FexPowerSummary_suspect", "equipment_FexPowerSummary_thresholded", "equipment_FexPowerSummary_timeCollected", "equipment_FexPowerSummary_totalPower", "equipment_FexPowerSummary_totalPowerAvg", "equipment_FexPowerSummary_totalPowerMax", "equipment_FexPowerSummary_totalPowerMin", "equipment_FexPowerSummary_update", "equipment_FexPsuInputStatsHist_current", "equipment_FexPsuInputStatsHist_currentAvg", "equipment_FexPsuInputStatsHist_currentMax", "equipment_FexPsuInputStatsHist_currentMin", "equipment_FexPsuInputStatsHist_id", "equipment_FexPsuInputStatsHist_mostRecent", "equipment_FexPsuInputStatsHist_power", "equipment_FexPsuInputStatsHist_powerAvg", "equipment_FexPsuInputStatsHist_powerMax", "equipment_FexPsuInputStatsHist_powerMin", "equipment_FexPsuInputStatsHist_suspect", "equipment_FexPsuInputStatsHist_thresholded", "equipment_FexPsuInputStatsHist_timeCollected", "equipment_FexPsuInputStatsHist_voltage", "equipment_FexPsuInputStatsHist_voltageAvg", "equipment_FexPsuInputStatsHist_voltageMax", "equipment_FexPsuInputStatsHist_voltageMin", "equipment_FexPsuInputStats_current", "equipment_FexPsuInputStats_currentAvg", "equipment_FexPsuInputStats_currentMax", "equipment_FexPsuInputStats_currentMin", "equipment_FexPsuInputStats_inputStatus", "equipment_FexPsuInputStats_intervals", "equipment_FexPsuInputStats_power", "equipment_FexPsuInputStats_powerAvg", "equipment_FexPsuInputStats_powerMax", "equipment_FexPsuInputStats_powerMin", "equipment_FexPsuInputStats_suspect", "equipment_FexPsuInputStats_thresholded", "equipment_FexPsuInputStats_timeCollected", "equipment_FexPsuInputStats_update", "equipment_FexPsuInputStats_voltage", "equipment_FexPsuInputStats_voltageAvg", "equipment_FexPsuInputStats_voltageMax", "equipment_FexPsuInputStats_voltageMin", "equipment_Fex_adminPowerState", "equipment_Fex_adminState", "equipment_Fex_configState", "equipment_Fex_fsmDescr", "equipment_Fex_fsmPrev", "equipment_Fex_fsmProgr", "equipment_Fex_fsmRmtInvErrCode", "equipment_Fex_fsmRmtInvErrDescr", "equipment_Fex_fsmRmtInvRslt", "equipment_Fex_fsmStageDescr", "equipment_Fex_fsmStamp", "equipment_Fex_fsmStatus", "equipment_Fex_fsmTry", "equipment_Fex_id", "equipment_Fex_licGP", "equipment_Fex_licState", "equipment_Fex_model", "equipment_Fex_operQualifier", "equipment_Fex_operQualifierReason", "equipment_Fex_operState", "equipment_Fex_operability", "equipment_Fex_power", "equipment_Fex_presence", "equipment_Fex_revision", "equipment_Fex_serial", "equipment_Fex_switchId", "equipment_Fex_thermal", "equipment_Fex_usrLbl", "equipment_Fex_vendor", "equipment_Fex_voltage", "equipment_FirmwareConstraint_minVer1", "equipment_FirmwareConstraint_minVer2", "equipment_FruCapProvider_deleted", "equipment_FruCapProvider_deprecated", "equipment_FruCapProvider_elementLoadFailures", "equipment_FruCapProvider_elementsLoaded", "equipment_FruCapProvider_gencount", "equipment_FruCapProvider_loadErrors", "equipment_FruCapProvider_loadWarnings", "equipment_FruCapProvider_mgmtPlaneVer", "equipment_FruCapProvider_model", "equipment_FruCapProvider_promCardType", "equipment_FruCapProvider_revision", "equipment_FruCapProvider_vendor", "equipment_FruidInfo_partNumber", "equipment_FruidInfo_vid", "equipment_GemCapProvider_deleted", "equipment_GemCapProvider_deprecated", "equipment_GemCapProvider_elementLoadFailures", "equipment_GemCapProvider_elementsLoaded", "equipment_GemCapProvider_gencount", "equipment_GemCapProvider_loadErrors", "equipment_GemCapProvider_loadWarnings", "equipment_GemCapProvider_mgmtPlaneVer", "equipment_GemCapProvider_model", "equipment_GemCapProvider_promCardType", "equipment_GemCapProvider_revision", "equipment_GemCapProvider_vendor", "equipment_GemPortCap_descr", "equipment_GemPortCap_intId", "equipment_GemPortCap_maxFcSpeed", "equipment_GemPortCap_name", "equipment_GemPortCap_policyLevel", "equipment_GemPortCap_policyOwner", "equipment_GemPortCap_portNumber", "equipment_GraphicsCardCapProvider_deleted", "equipment_GraphicsCardCapProvider_deprecated", "equipment_GraphicsCardCapProvider_elementLoadFailures", "equipment_GraphicsCardCapProvider_elementsLoaded", "equipment_GraphicsCardCapProvider_gencount", "equipment_GraphicsCardCapProvider_loadErrors", "equipment_GraphicsCardCapProvider_loadWarnings", "equipment_GraphicsCardCapProvider_mgmtPlaneVer", "equipment_GraphicsCardCapProvider_model", "equipment_GraphicsCardCapProvider_numGpu", "equipment_GraphicsCardCapProvider_promCardType", "equipment_GraphicsCardCapProvider_revision", "equipment_GraphicsCardCapProvider_vendor", "equipment_GraphicsCardCapRef_model", "equipment_GraphicsCardCapRef_revision", "equipment_GraphicsCardCapRef_vendor", "equipment_HDDFaultMonDef_ControllerFwVersion", "equipment_HDDFaultMonDef_ControllerModel", "equipment_HDDFaultMonDef_HDDMonSupport", "equipment_HDDFaultMonDef_descr", "equipment_HDDFaultMonDef_intId", "equipment_HDDFaultMonDef_name", "equipment_HDDFaultMonDef_policyLevel", "equipment_HDDFaultMonDef_policyOwner", "equipment_HealthLed_color", "equipment_HealthLed_healthLedState", "equipment_HealthLed_healthLedStateQualifier", "equipment_HealthLed_id", "equipment_HealthLed_name", "equipment_HealthLed_operState", "equipment_HolderCapProvider_deleted", "equipment_HolderCapProvider_deprecated", "equipment_HolderCapProvider_elementLoadFailures", "equipment_HolderCapProvider_elementsLoaded", "equipment_HolderCapProvider_gencount", "equipment_HolderCapProvider_loadErrors", "equipment_HolderCapProvider_loadWarnings", "equipment_HolderCapProvider_mgmtPlaneVer", "equipment_HolderCapProvider_model", "equipment_HolderCapProvider_promCardType", "equipment_HolderCapProvider_revision", "equipment_HolderCapProvider_vendor", "equipment_Holder_id", "equipment_Holder_model", "equipment_Holder_operQualifierReason", "equipment_Holder_operability", "equipment_Holder_presence", "equipment_Holder_revision", "equipment_Holder_serial", "equipment_Holder_vendor", "equipment_HostIfCapProvider_deleted", "equipment_HostIfCapProvider_deprecated", "equipment_HostIfCapProvider_elementLoadFailures", "equipment_HostIfCapProvider_elementsLoaded", "equipment_HostIfCapProvider_gencount", "equipment_HostIfCapProvider_loadErrors", "equipment_HostIfCapProvider_loadWarnings", "equipment_HostIfCapProvider_mgmtPlaneVer", "equipment_HostIfCapProvider_model", "equipment_HostIfCapProvider_promCardType", "equipment_HostIfCapProvider_revision", "equipment_HostIfCapProvider_vendor", "equipment_HwCapProvider_deleted", "equipment_HwCapProvider_deprecated", "equipment_HwCapProvider_elementLoadFailures", "equipment_HwCapProvider_elementsLoaded", "equipment_HwCapProvider_gencount", "equipment_HwCapProvider_loadErrors", "equipment_HwCapProvider_loadWarnings", "equipment_HwCapProvider_mgmtPlaneVer", "equipment_HwCapProvider_model", "equipment_HwCapProvider_revision", "equipment_HwCapProvider_vendor", "equipment_IOCardCapProvider_deleted", "equipment_IOCardCapProvider_deprecated", "equipment_IOCardCapProvider_elementLoadFailures", "equipment_IOCardCapProvider_elementsLoaded", "equipment_IOCardCapProvider_gencount", "equipment_IOCardCapProvider_loadErrors", "equipment_IOCardCapProvider_loadWarnings", "equipment_IOCardCapProvider_mgmtPlaneVer", "equipment_IOCardCapProvider_model", "equipment_IOCardCapProvider_promCardType", "equipment_IOCardCapProvider_revision", "equipment_IOCardCapProvider_vendor", "equipment_IOCardFsmStage_descr", "equipment_IOCardFsmStage_lastUpdateTime", "equipment_IOCardFsmStage_name", "equipment_IOCardFsmStage_order", "equipment_IOCardFsmStage_retry", "equipment_IOCardFsmStage_stageStatus", "equipment_IOCardFsmTask_completion", "equipment_IOCardFsmTask_flags", "equipment_IOCardFsmTask_item", "equipment_IOCardFsmTask_seqId", "equipment_IOCardFsm_completionTime", "equipment_IOCardFsm_currentFsm", "equipment_IOCardFsm_descr", "equipment_IOCardFsm_fsmStatus", "equipment_IOCardFsm_instanceId", "equipment_IOCardFsm_progress", "equipment_IOCardFsm_rmtErrCode", "equipment_IOCardFsm_rmtErrDescr", "equipment_IOCardFsm_rmtRslt", "equipment_IOCardStatsHist_ambientTemp", "equipment_IOCardStatsHist_ambientTempAvg", "equipment_IOCardStatsHist_ambientTempMax", "equipment_IOCardStatsHist_ambientTempMin", "equipment_IOCardStatsHist_id", "equipment_IOCardStatsHist_mostRecent", "equipment_IOCardStatsHist_suspect", "equipment_IOCardStatsHist_temp", "equipment_IOCardStatsHist_tempAvg", "equipment_IOCardStatsHist_tempMax", "equipment_IOCardStatsHist_tempMin", "equipment_IOCardStatsHist_thresholded", "equipment_IOCardStatsHist_timeCollected", "equipment_IOCardStats_ambientTemp", "equipment_IOCardStats_ambientTempAvg", "equipment_IOCardStats_ambientTempMax", "equipment_IOCardStats_ambientTempMin", "equipment_IOCardStats_intervals", "equipment_IOCardStats_suspect", "equipment_IOCardStats_temp", "equipment_IOCardStats_tempAvg", "equipment_IOCardStats_tempMax", "equipment_IOCardStats_tempMin", "equipment_IOCardStats_thresholded", "equipment_IOCardStats_timeCollected", "equipment_IOCardStats_update", "equipment_IOCardTypeDef_descr", "equipment_IOCardTypeDef_intId", "equipment_IOCardTypeDef_name", "equipment_IOCardTypeDef_policyLevel", "equipment_IOCardTypeDef_policyOwner", "equipment_IOCardTypeDef_type", "equipment_IOCard_adminPowerState", "equipment_IOCard_baseAddr", "equipment_IOCard_chassisId", "equipment_IOCard_configState", "equipment_IOCard_discovery", "equipment_IOCard_feOfflineTs", "equipment_IOCard_feReadyTs", "equipment_IOCard_fltAggr", "equipment_IOCard_fsmDescr", "equipment_IOCard_fsmPrev", "equipment_IOCard_fsmProgr", "equipment_IOCard_fsmRmtInvErrCode", "equipment_IOCard_fsmRmtInvErrDescr", "equipment_IOCard_fsmRmtInvRslt", "equipment_IOCard_fsmStageDescr", "equipment_IOCard_fsmStamp", "equipment_IOCard_fsmStatus", "equipment_IOCard_fsmTry", "equipment_IOCard_id", "equipment_IOCard_lcName", "equipment_IOCard_lcTs", "equipment_IOCard_mfgTime", "equipment_IOCard_model", "equipment_IOCard_operQualifier", "equipment_IOCard_operQualifierReason", "equipment_IOCard_operState", "equipment_IOCard_operability", "equipment_IOCard_partNumber", "equipment_IOCard_peerCommStatus", "equipment_IOCard_peerDn", "equipment_IOCard_perf", "equipment_IOCard_power", "equipment_IOCard_presence", "equipment_IOCard_revision", "equipment_IOCard_serial", "equipment_IOCard_side", "equipment_IOCard_switchId", "equipment_IOCard_thermal", "equipment_IOCard_upgradeStatus", "equipment_IOCard_usrLbl", "equipment_IOCard_vendor", "equipment_IOCard_vid", "equipment_IOCard_voltage", "equipment_InbandMgmtCap_isSupported", "equipment_InbandMgmtCap_minCimcVersion", "equipment_InbandMgmtCap_minCmcVersion", "equipment_IndicatorLed_color", "equipment_IndicatorLed_id", "equipment_IndicatorLed_name", "equipment_IndicatorLed_operState", "equipment_Info_model", "equipment_Info_revision", "equipment_Info_serial", "equipment_Info_vendor", "equipment_IntegratedComponentCapProvider_deleted", "equipment_IntegratedComponentCapProvider_deprecated", "equipment_IntegratedComponentCapProvider_elementLoadFailures", "equipment_IntegratedComponentCapProvider_elementsLoaded", "equipment_IntegratedComponentCapProvider_gencount", "equipment_IntegratedComponentCapProvider_loadErrors", "equipment_IntegratedComponentCapProvider_loadWarnings", "equipment_IntegratedComponentCapProvider_mgmtPlaneVer", "equipment_IntegratedComponentCapProvider_model", "equipment_IntegratedComponentCapProvider_promCardType", "equipment_IntegratedComponentCapProvider_revision", "equipment_IntegratedComponentCapProvider_vendor", "equipment_ItemIf_id", "equipment_Item_id", "equipment_Item_model", "equipment_Item_revision", "equipment_Item_serial", "equipment_Item_vendor", "equipment_Led_color", "equipment_Led_id", "equipment_Led_name", "equipment_Led_operState", "equipment_LocalDiskCapProvider_deleted", "equipment_LocalDiskCapProvider_deprecated", "equipment_LocalDiskCapProvider_elementLoadFailures", "equipment_LocalDiskCapProvider_elementsLoaded", "equipment_LocalDiskCapProvider_gencount", "equipment_LocalDiskCapProvider_loadErrors", "equipment_LocalDiskCapProvider_loadWarnings", "equipment_LocalDiskCapProvider_mgmtPlaneVer", "equipment_LocalDiskCapProvider_model", "equipment_LocalDiskCapProvider_promCardType", "equipment_LocalDiskCapProvider_revision", "equipment_LocalDiskCapProvider_vendor", "equipment_LocalDiskControllerCapProvider_cardType", "equipment_LocalDiskControllerCapProvider_deleted", "equipment_LocalDiskControllerCapProvider_deprecated", "equipment_LocalDiskControllerCapProvider_elementLoadFailures", "equipment_LocalDiskControllerCapProvider_elementsLoaded", "equipment_LocalDiskControllerCapProvider_form", "equipment_LocalDiskControllerCapProvider_gencount", "equipment_LocalDiskControllerCapProvider_internalports", "equipment_LocalDiskControllerCapProvider_loadErrors", "equipment_LocalDiskControllerCapProvider_loadWarnings", "equipment_LocalDiskControllerCapProvider_mgmtPlaneVer", "equipment_LocalDiskControllerCapProvider_model", "equipment_LocalDiskControllerCapProvider_promCardType", "equipment_LocalDiskControllerCapProvider_revision", "equipment_LocalDiskControllerCapProvider_vendor", "equipment_LocalDiskControllerCapRef_isSupported", "equipment_LocalDiskControllerCapRef_model", "equipment_LocalDiskControllerCapRef_revision", "equipment_LocalDiskControllerCapRef_vendor", "equipment_LocalDiskControllerDef_descr", "equipment_LocalDiskControllerDef_forceUpdateVersion", "equipment_LocalDiskControllerDef_intId", "equipment_LocalDiskControllerDef_name", "equipment_LocalDiskControllerDef_policyLevel", "equipment_LocalDiskControllerDef_policyOwner", "equipment_LocalDiskDef_blockSize", "equipment_LocalDiskDef_cacheSize", "equipment_LocalDiskDef_descr", "equipment_LocalDiskDef_forceUpdateVersion", "equipment_LocalDiskDef_intId", "equipment_LocalDiskDef_name", "equipment_LocalDiskDef_numberOfBlocks", "equipment_LocalDiskDef_policyLevel", "equipment_LocalDiskDef_policyOwner", "equipment_LocalDiskDef_rotationalSpeed", "equipment_LocalDiskDef_seekAverageReadWrite", "equipment_LocalDiskDef_seekTrackToTrackReadWrite", "equipment_LocalDiskDef_technology", "equipment_LocatorLedFsmStage_descr", "equipment_LocatorLedFsmStage_lastUpdateTime", "equipment_LocatorLedFsmStage_name", "equipment_LocatorLedFsmStage_order", "equipment_LocatorLedFsmStage_retry", "equipment_LocatorLedFsmStage_stageStatus", "equipment_LocatorLedFsmTask_completion", "equipment_LocatorLedFsmTask_flags", "equipment_LocatorLedFsmTask_item", "equipment_LocatorLedFsmTask_seqId", "equipment_LocatorLedFsm_completionTime", "equipment_LocatorLedFsm_currentFsm", "equipment_LocatorLedFsm_descr", "equipment_LocatorLedFsm_fsmStatus", "equipment_LocatorLedFsm_instanceId", "equipment_LocatorLedFsm_progress", "equipment_LocatorLedFsm_rmtErrCode", "equipment_LocatorLedFsm_rmtErrDescr", "equipment_LocatorLedFsm_rmtRslt", "equipment_LocatorLed_adminState", "equipment_LocatorLed_color", "equipment_LocatorLed_fsmDescr", "equipment_LocatorLed_fsmPrev", "equipment_LocatorLed_fsmProgr", "equipment_LocatorLed_fsmRmtInvErrCode", "equipment_LocatorLed_fsmRmtInvErrDescr", "equipment_LocatorLed_fsmRmtInvRslt", "equipment_LocatorLed_fsmStageDescr", "equipment_LocatorLed_fsmStamp", "equipment_LocatorLed_fsmStatus", "equipment_LocatorLed_fsmTry", "equipment_LocatorLed_id", "equipment_LocatorLed_name", "equipment_LocatorLed_operState", "equipment_ManufacturingDef_caption", "equipment_ManufacturingDef_clei", "equipment_ManufacturingDef_descr", "equipment_ManufacturingDef_description", "equipment_ManufacturingDef_fruMajorType", "equipment_ManufacturingDef_fruMinorType", "equipment_ManufacturingDef_intId", "equipment_ManufacturingDef_name", "equipment_ManufacturingDef_oemName", "equipment_ManufacturingDef_oemPartNumber", "equipment_ManufacturingDef_partNumber", "equipment_ManufacturingDef_pid", "equipment_ManufacturingDef_policyLevel", "equipment_ManufacturingDef_policyOwner", "equipment_ManufacturingDef_series", "equipment_ManufacturingDef_sku", "equipment_ManufacturingDef_vendorEquipmentType", "equipment_ManufacturingDef_vid", "equipment_MemoryUnitCapProvider_deleted", "equipment_MemoryUnitCapProvider_deprecated", "equipment_MemoryUnitCapProvider_elementLoadFailures", "equipment_MemoryUnitCapProvider_elementsLoaded", "equipment_MemoryUnitCapProvider_gencount", "equipment_MemoryUnitCapProvider_loadErrors", "equipment_MemoryUnitCapProvider_loadWarnings", "equipment_MemoryUnitCapProvider_mgmtPlaneVer", "equipment_MemoryUnitCapProvider_model", "equipment_MemoryUnitCapProvider_promCardType", "equipment_MemoryUnitCapProvider_revision", "equipment_MemoryUnitCapProvider_vendor", "equipment_MemoryUnitDiscoveryModifierDef_action", "equipment_MemoryUnitDiscoveryModifierDef_constraintType", "equipment_MemoryUnitDiscoveryModifierDef_descr", "equipment_MemoryUnitDiscoveryModifierDef_intId", "equipment_MemoryUnitDiscoveryModifierDef_name", "equipment_MemoryUnitDiscoveryModifierDef_policyLevel", "equipment_MemoryUnitDiscoveryModifierDef_policyOwner", "equipment_MfgInfo_mfgTime", "equipment_MgmtCapProvider_deleted", "equipment_MgmtCapProvider_deprecated", "equipment_MgmtCapProvider_elementLoadFailures", "equipment_MgmtCapProvider_elementsLoaded", "equipment_MgmtCapProvider_gencount", "equipment_MgmtCapProvider_loadErrors", "equipment_MgmtCapProvider_loadWarnings", "equipment_MgmtCapProvider_mgmtPlaneVer", "equipment_MgmtCapProvider_model", "equipment_MgmtCapProvider_promCardType", "equipment_MgmtCapProvider_revision", "equipment_MgmtCapProvider_vendor", "equipment_MgmtExtCapProvider_deleted", "equipment_MgmtExtCapProvider_deprecated", "equipment_MgmtExtCapProvider_elementLoadFailures", "equipment_MgmtExtCapProvider_elementsLoaded", "equipment_MgmtExtCapProvider_gencount", "equipment_MgmtExtCapProvider_loadErrors", "equipment_MgmtExtCapProvider_loadWarnings", "equipment_MgmtExtCapProvider_mgmtPlaneVer", "equipment_MgmtExtCapProvider_model", "equipment_MgmtExtCapProvider_promCardType", "equipment_MgmtExtCapProvider_revision", "equipment_MgmtExtCapProvider_vendor", "equipment_NetworkElementFanStatsHist_drivePercentage", "equipment_NetworkElementFanStatsHist_drivePercentageAvg", "equipment_NetworkElementFanStatsHist_drivePercentageMax", "equipment_NetworkElementFanStatsHist_drivePercentageMin", "equipment_NetworkElementFanStatsHist_id", "equipment_NetworkElementFanStatsHist_mostRecent", "equipment_NetworkElementFanStatsHist_speed", "equipment_NetworkElementFanStatsHist_speedAvg", "equipment_NetworkElementFanStatsHist_speedMax", "equipment_NetworkElementFanStatsHist_speedMin", "equipment_NetworkElementFanStatsHist_suspect", "equipment_NetworkElementFanStatsHist_thresholded", "equipment_NetworkElementFanStatsHist_timeCollected", "equipment_NetworkElementFanStats_airflowDirection", "equipment_NetworkElementFanStats_drivePercentage", "equipment_NetworkElementFanStats_drivePercentageAvg", "equipment_NetworkElementFanStats_drivePercentageMax", "equipment_NetworkElementFanStats_drivePercentageMin", "equipment_NetworkElementFanStats_intervals", "equipment_NetworkElementFanStats_speed", "equipment_NetworkElementFanStats_speedAvg", "equipment_NetworkElementFanStats_speedMax", "equipment_NetworkElementFanStats_speedMin", "equipment_NetworkElementFanStats_suspect", "equipment_NetworkElementFanStats_thresholded", "equipment_NetworkElementFanStats_timeCollected", "equipment_NetworkElementFanStats_update", "equipment_POSTCodeContainer_baseContainer", "equipment_POSTCodeContainer_name", "equipment_POSTCodeData_code", "equipment_POSTCodeData_descr", "equipment_POSTCodeData_globalId", "equipment_POSTCodeData_localId", "equipment_POSTCodeData_method", "equipment_POSTCodeData_name", "equipment_POSTCodeData_recoverable", "equipment_POSTCodeData_recoveryAction", "equipment_POSTCodeData_severity", "equipment_POSTCodeReporter_baseContainer", "equipment_POSTCodeReporter_model", "equipment_POSTCodeReporter_name", "equipment_POSTCodeReporter_revision", "equipment_POSTCodeReporter_serial", "equipment_POSTCodeReporter_type", "equipment_POSTCodeReporter_vendor", "equipment_POSTCodeTemplate_baseContainer", "equipment_POSTCodeTemplate_name", "equipment_POSTCode_code", "equipment_POSTCode_descr", "equipment_POSTCode_globalId", "equipment_POSTCode_localId", "equipment_POSTCode_method", "equipment_POSTCode_name", "equipment_POSTCode_recoverable", "equipment_POSTCode_recoveryAction", "equipment_POSTCode_severity", "equipment_POST_code", "equipment_POST_created", "equipment_POST_descr", "equipment_POST_globalId", "equipment_POST_localId", "equipment_POST_method", "equipment_POST_name", "equipment_POST_recoverable", "equipment_POST_recoveryAction", "equipment_POST_severity", "equipment_POST_type", "equipment_POST_value", "equipment_PciDef_descr", "equipment_PciDef_device", "equipment_PciDef_intId", "equipment_PciDef_name", "equipment_PciDef_policyLevel", "equipment_PciDef_policyOwner", "equipment_PciDef_subdevice", "equipment_PciDef_subvendor", "equipment_PciDef_vendor", "equipment_PhysicalDef_depth", "equipment_PhysicalDef_descr", "equipment_PhysicalDef_height", "equipment_PhysicalDef_intId", "equipment_PhysicalDef_maximumPower", "equipment_PhysicalDef_maximumTemperature", "equipment_PhysicalDef_minimumPower", "equipment_PhysicalDef_minimumTemperature", "equipment_PhysicalDef_name", "equipment_PhysicalDef_nominalPower", "equipment_PhysicalDef_nominalTemperature", "equipment_PhysicalDef_operatingVoltages", "equipment_PhysicalDef_policyLevel", "equipment_PhysicalDef_policyOwner", "equipment_PhysicalDef_weight", "equipment_PhysicalDef_width", "equipment_Picture_fileName", "equipment_Picture_type", "equipment_PortGroupAggregationDef_aggregationCap", "equipment_PortGroupAggregationDef_descr", "equipment_PortGroupAggregationDef_intId", "equipment_PortGroupAggregationDef_name", "equipment_PortGroupAggregationDef_policyLevel", "equipment_PortGroupAggregationDef_policyOwner", "equipment_PortGroupAggregationDef_type", "equipment_PortGroupDef_descr", "equipment_PortGroupDef_intId", "equipment_PortGroupDef_name", "equipment_PortGroupDef_numberOfPorts", "equipment_PortGroupDef_policyLevel", "equipment_PortGroupDef_policyOwner", "equipment_PortGroupDef_type", "equipment_PortGroupSwComplexDef_asic", "equipment_PortGroupSwComplexDef_descr", "equipment_PortGroupSwComplexDef_intId", "equipment_PortGroupSwComplexDef_name", "equipment_PortGroupSwComplexDef_policyLevel", "equipment_PortGroupSwComplexDef_policyOwner", "equipment_PortGroupSwComplexDef_portCapacity", "equipment_PortGroupSwComplexDef_swComplexCapacity", "equipment_PortGroupSwComplexDef_vifCapacity", "equipment_PortSwComplexRef_descr", "equipment_PortSwComplexRef_intId", "equipment_PortSwComplexRef_maxPortId", "equipment_PortSwComplexRef_minPortId", "equipment_PortSwComplexRef_name", "equipment_PortSwComplexRef_policyLevel", "equipment_PortSwComplexRef_policyOwner", "equipment_PortSwComplexRef_slotId", "equipment_PortSwComplexRef_swComplexId", "equipment_ProcessorUnitCapProvider_deleted", "equipment_ProcessorUnitCapProvider_deprecated", "equipment_ProcessorUnitCapProvider_elementLoadFailures", "equipment_ProcessorUnitCapProvider_elementsLoaded", "equipment_ProcessorUnitCapProvider_gencount", "equipment_ProcessorUnitCapProvider_loadErrors", "equipment_ProcessorUnitCapProvider_loadWarnings", "equipment_ProcessorUnitCapProvider_mgmtPlaneVer", "equipment_ProcessorUnitCapProvider_model", "equipment_ProcessorUnitCapProvider_promCardType", "equipment_ProcessorUnitCapProvider_revision", "equipment_ProcessorUnitCapProvider_vendor", "equipment_ProcessorUnitDef_addressWidth", "equipment_ProcessorUnitDef_dataWidth", "equipment_ProcessorUnitDef_descr", "equipment_ProcessorUnitDef_intId", "equipment_ProcessorUnitDef_maxSpeed", "equipment_ProcessorUnitDef_name", "equipment_ProcessorUnitDef_policyLevel", "equipment_ProcessorUnitDef_policyOwner", "equipment_PsuCapProvider_deleted", "equipment_PsuCapProvider_deprecated", "equipment_PsuCapProvider_elementLoadFailures", "equipment_PsuCapProvider_elementsLoaded", "equipment_PsuCapProvider_gencount", "equipment_PsuCapProvider_loadErrors", "equipment_PsuCapProvider_loadWarnings", "equipment_PsuCapProvider_mgmtPlaneVer", "equipment_PsuCapProvider_model", "equipment_PsuCapProvider_promCardType", "equipment_PsuCapProvider_revision", "equipment_PsuCapProvider_vendor", "equipment_PsuDef_PsuType", "equipment_PsuDef_descr", "equipment_PsuDef_intId", "equipment_PsuDef_name", "equipment_PsuDef_policyLevel", "equipment_PsuDef_policyOwner", "equipment_PsuInputStatsHist_current", "equipment_PsuInputStatsHist_currentAvg", "equipment_PsuInputStatsHist_currentMax", "equipment_PsuInputStatsHist_currentMin", "equipment_PsuInputStatsHist_id", "equipment_PsuInputStatsHist_mostRecent", "equipment_PsuInputStatsHist_power", "equipment_PsuInputStatsHist_powerAvg", "equipment_PsuInputStatsHist_powerMax", "equipment_PsuInputStatsHist_powerMin", "equipment_PsuInputStatsHist_suspect", "equipment_PsuInputStatsHist_thresholded", "equipment_PsuInputStatsHist_timeCollected", "equipment_PsuInputStatsHist_voltage", "equipment_PsuInputStatsHist_voltageAvg", "equipment_PsuInputStatsHist_voltageMax", "equipment_PsuInputStatsHist_voltageMin", "equipment_PsuInputStats_current", "equipment_PsuInputStats_currentAvg", "equipment_PsuInputStats_currentMax", "equipment_PsuInputStats_currentMin", "equipment_PsuInputStats_inputStatus", "equipment_PsuInputStats_intervals", "equipment_PsuInputStats_power", "equipment_PsuInputStats_powerAvg", "equipment_PsuInputStats_powerMax", "equipment_PsuInputStats_powerMin", "equipment_PsuInputStats_suspect", "equipment_PsuInputStats_thresholded", "equipment_PsuInputStats_timeCollected", "equipment_PsuInputStats_update", "equipment_PsuInputStats_voltage", "equipment_PsuInputStats_voltageAvg", "equipment_PsuInputStats_voltageMax", "equipment_PsuInputStats_voltageMin", "equipment_PsuOutputStatsHist_current", "equipment_PsuOutputStatsHist_currentAvg", "equipment_PsuOutputStatsHist_currentMax", "equipment_PsuOutputStatsHist_currentMin", "equipment_PsuOutputStatsHist_id", "equipment_PsuOutputStatsHist_mostRecent", "equipment_PsuOutputStatsHist_power", "equipment_PsuOutputStatsHist_powerAvg", "equipment_PsuOutputStatsHist_powerMax", "equipment_PsuOutputStatsHist_powerMin", "equipment_PsuOutputStatsHist_suspect", "equipment_PsuOutputStatsHist_thresholded", "equipment_PsuOutputStatsHist_timeCollected", "equipment_PsuOutputStatsHist_voltage", "equipment_PsuOutputStatsHist_voltageAvg", "equipment_PsuOutputStatsHist_voltageMax", "equipment_PsuOutputStatsHist_voltageMin", "equipment_PsuOutputStats_current", "equipment_PsuOutputStats_currentAvg", "equipment_PsuOutputStats_currentMax", "equipment_PsuOutputStats_currentMin", "equipment_PsuOutputStats_intervals", "equipment_PsuOutputStats_outputStatus", "equipment_PsuOutputStats_power", "equipment_PsuOutputStats_powerAvg", "equipment_PsuOutputStats_powerMax", "equipment_PsuOutputStats_powerMin", "equipment_PsuOutputStats_suspect", "equipment_PsuOutputStats_thresholded", "equipment_PsuOutputStats_timeCollected", "equipment_PsuOutputStats_update", "equipment_PsuOutputStats_voltage", "equipment_PsuOutputStats_voltageAvg", "equipment_PsuOutputStats_voltageMax", "equipment_PsuOutputStats_voltageMin", "equipment_PsuStatsHist_ambientTemp", "equipment_PsuStatsHist_ambientTempAvg", "equipment_PsuStatsHist_ambientTempMax", "equipment_PsuStatsHist_ambientTempMin", "equipment_PsuStatsHist_id", "equipment_PsuStatsHist_input210v", "equipment_PsuStatsHist_input210vAvg", "equipment_PsuStatsHist_input210vMax", "equipment_PsuStatsHist_input210vMin", "equipment_PsuStatsHist_mostRecent", "equipment_PsuStatsHist_output12v", "equipment_PsuStatsHist_output12vAvg", "equipment_PsuStatsHist_output12vMax", "equipment_PsuStatsHist_output12vMin", "equipment_PsuStatsHist_output3v3", "equipment_PsuStatsHist_output3v3Avg", "equipment_PsuStatsHist_output3v3Max", "equipment_PsuStatsHist_output3v3Min", "equipment_PsuStatsHist_outputCurrent", "equipment_PsuStatsHist_outputCurrentAvg", "equipment_PsuStatsHist_outputCurrentMax", "equipment_PsuStatsHist_outputCurrentMin", "equipment_PsuStatsHist_outputPower", "equipment_PsuStatsHist_outputPowerAvg", "equipment_PsuStatsHist_outputPowerMax", "equipment_PsuStatsHist_outputPowerMin", "equipment_PsuStatsHist_suspect", "equipment_PsuStatsHist_thresholded", "equipment_PsuStatsHist_timeCollected", "equipment_PsuStats_ambientTemp", "equipment_PsuStats_ambientTempAvg", "equipment_PsuStats_ambientTempMax", "equipment_PsuStats_ambientTempMin", "equipment_PsuStats_input210v", "equipment_PsuStats_input210vAvg", "equipment_PsuStats_input210vMax", "equipment_PsuStats_input210vMin", "equipment_PsuStats_intervals", "equipment_PsuStats_output12v", "equipment_PsuStats_output12vAvg", "equipment_PsuStats_output12vMax", "equipment_PsuStats_output12vMin", "equipment_PsuStats_output3v3", "equipment_PsuStats_output3v3Avg", "equipment_PsuStats_output3v3Max", "equipment_PsuStats_output3v3Min", "equipment_PsuStats_outputCurrent", "equipment_PsuStats_outputCurrentAvg", "equipment_PsuStats_outputCurrentMax", "equipment_PsuStats_outputCurrentMin", "equipment_PsuStats_outputPower", "equipment_PsuStats_outputPowerAvg", "equipment_PsuStats_outputPowerMax", "equipment_PsuStats_outputPowerMin", "equipment_PsuStats_psuTemp1", "equipment_PsuStats_psuTemp2", "equipment_PsuStats_suspect", "equipment_PsuStats_thresholded", "equipment_PsuStats_timeCollected", "equipment_PsuStats_update", "equipment_Psu_Type", "equipment_Psu_id", "equipment_Psu_model", "equipment_Psu_operQualifierReason", "equipment_Psu_operState", "equipment_Psu_operability", "equipment_Psu_partNumber", "equipment_Psu_perf", "equipment_Psu_power", "equipment_Psu_powerStateQualifier", "equipment_Psu_presence", "equipment_Psu_psuFirmwareVersion", "equipment_Psu_revision", "equipment_Psu_serial", "equipment_Psu_thermal", "equipment_Psu_vendor", "equipment_Psu_vid", "equipment_Psu_voltage", "equipment_RackFanModuleDef_descr", "equipment_RackFanModuleDef_fanCapacity", "equipment_RackFanModuleDef_intId", "equipment_RackFanModuleDef_name", "equipment_RackFanModuleDef_policyLevel", "equipment_RackFanModuleDef_policyOwner", "equipment_RackUnitCapProvider_deleted", "equipment_RackUnitCapProvider_deprecated", "equipment_RackUnitCapProvider_elementLoadFailures", "equipment_RackUnitCapProvider_elementsLoaded", "equipment_RackUnitCapProvider_gencount", "equipment_RackUnitCapProvider_loadErrors", "equipment_RackUnitCapProvider_loadWarnings", "equipment_RackUnitCapProvider_maxLocalDisks", "equipment_RackUnitCapProvider_mgmtPlaneVer", "equipment_RackUnitCapProvider_model", "equipment_RackUnitCapProvider_promCardType", "equipment_RackUnitCapProvider_revision", "equipment_RackUnitCapProvider_vendor", "equipment_RackUnitFanStatsHist_id", "equipment_RackUnitFanStatsHist_mostRecent", "equipment_RackUnitFanStatsHist_speed", "equipment_RackUnitFanStatsHist_speedAvg", "equipment_RackUnitFanStatsHist_speedMax", "equipment_RackUnitFanStatsHist_speedMin", "equipment_RackUnitFanStatsHist_suspect", "equipment_RackUnitFanStatsHist_thresholded", "equipment_RackUnitFanStatsHist_timeCollected", "equipment_RackUnitFanStats_intervals", "equipment_RackUnitFanStats_speed", "equipment_RackUnitFanStats_speedAvg", "equipment_RackUnitFanStats_speedMax", "equipment_RackUnitFanStats_speedMin", "equipment_RackUnitFanStats_suspect", "equipment_RackUnitFanStats_thresholded", "equipment_RackUnitFanStats_timeCollected", "equipment_RackUnitFanStats_update", "equipment_RackUnitPsuStatsHist_ambientTemp", "equipment_RackUnitPsuStatsHist_ambientTempAvg", "equipment_RackUnitPsuStatsHist_ambientTempMax", "equipment_RackUnitPsuStatsHist_ambientTempMin", "equipment_RackUnitPsuStatsHist_id", "equipment_RackUnitPsuStatsHist_inputPower", "equipment_RackUnitPsuStatsHist_inputPowerAvg", "equipment_RackUnitPsuStatsHist_inputPowerMax", "equipment_RackUnitPsuStatsHist_inputPowerMin", "equipment_RackUnitPsuStatsHist_inputVoltage", "equipment_RackUnitPsuStatsHist_inputVoltageAvg", "equipment_RackUnitPsuStatsHist_inputVoltageMax", "equipment_RackUnitPsuStatsHist_inputVoltageMin", "equipment_RackUnitPsuStatsHist_mostRecent", "equipment_RackUnitPsuStatsHist_outputCurrent", "equipment_RackUnitPsuStatsHist_outputCurrentAvg", "equipment_RackUnitPsuStatsHist_outputCurrentMax", "equipment_RackUnitPsuStatsHist_outputCurrentMin", "equipment_RackUnitPsuStatsHist_outputPower", "equipment_RackUnitPsuStatsHist_outputPowerAvg", "equipment_RackUnitPsuStatsHist_outputPowerMax", "equipment_RackUnitPsuStatsHist_outputPowerMin", "equipment_RackUnitPsuStatsHist_outputVoltage", "equipment_RackUnitPsuStatsHist_outputVoltageAvg", "equipment_RackUnitPsuStatsHist_outputVoltageMax", "equipment_RackUnitPsuStatsHist_outputVoltageMin", "equipment_RackUnitPsuStatsHist_suspect", "equipment_RackUnitPsuStatsHist_thresholded", "equipment_RackUnitPsuStatsHist_timeCollected", "equipment_RackUnitPsuStats_ambientTemp", "equipment_RackUnitPsuStats_ambientTempAvg", "equipment_RackUnitPsuStats_ambientTempMax", "equipment_RackUnitPsuStats_ambientTempMin", "equipment_RackUnitPsuStats_inputPower", "equipment_RackUnitPsuStats_inputPowerAvg", "equipment_RackUnitPsuStats_inputPowerMax", "equipment_RackUnitPsuStats_inputPowerMin", "equipment_RackUnitPsuStats_inputVoltage", "equipment_RackUnitPsuStats_inputVoltageAvg", "equipment_RackUnitPsuStats_inputVoltageMax", "equipment_RackUnitPsuStats_inputVoltageMin", "equipment_RackUnitPsuStats_intervals", "equipment_RackUnitPsuStats_outputCurrent", "equipment_RackUnitPsuStats_outputCurrentAvg", "equipment_RackUnitPsuStats_outputCurrentMax", "equipment_RackUnitPsuStats_outputCurrentMin", "equipment_RackUnitPsuStats_outputPower", "equipment_RackUnitPsuStats_outputPowerAvg", "equipment_RackUnitPsuStats_outputPowerMax", "equipment_RackUnitPsuStats_outputPowerMin", "equipment_RackUnitPsuStats_outputVoltage", "equipment_RackUnitPsuStats_outputVoltageAvg", "equipment_RackUnitPsuStats_outputVoltageMax", "equipment_RackUnitPsuStats_outputVoltageMin", "equipment_RackUnitPsuStats_suspect", "equipment_RackUnitPsuStats_thresholded", "equipment_RackUnitPsuStats_timeCollected", "equipment_RackUnitPsuStats_update", "equipment_RaidDef_descr", "equipment_RaidDef_intId", "equipment_RaidDef_level", "equipment_RaidDef_name", "equipment_RaidDef_policyLevel", "equipment_RaidDef_policyOwner", "equipment_SecureBoot_minBiosVersion", "equipment_SecureBoot_minCimcVersion", "equipment_SecureController_id", "equipment_SecureController_model", "equipment_SecureController_revision", "equipment_SecureController_serial", "equipment_SecureController_vendor", "equipment_ServerFeatureCap_cmosResetSupported", "equipment_ServiceDef_canBeFRUed", "equipment_ServiceDef_descr", "equipment_ServiceDef_intId", "equipment_ServiceDef_name", "equipment_ServiceDef_policyLevel", "equipment_ServiceDef_policyOwner", "equipment_ServiceDef_removalConditions", "equipment_ServiceDef_servicePhilosophy", "equipment_SlotArrayRef_descr", "equipment_SlotArrayRef_intId", "equipment_SlotArrayRef_name", "equipment_SlotArrayRef_numberOfSlotsSpanned", "equipment_SlotArrayRef_policyLevel", "equipment_SlotArrayRef_policyOwner", "equipment_SlotArrayRef_slotSpanOrientation", "equipment_SlotArrayRef_targetDn", "equipment_SlotArray_descr", "equipment_SlotArray_firstIndex", "equipment_SlotArray_height", "equipment_SlotArray_horizontalStartOffset", "equipment_SlotArray_inlineGroupSeparation", "equipment_SlotArray_inlineGroupSize", "equipment_SlotArray_inlineOffset", "equipment_SlotArray_intId", "equipment_SlotArray_location", "equipment_SlotArray_name", "equipment_SlotArray_numberOfSlots", "equipment_SlotArray_orientation", "equipment_SlotArray_policyLevel", "equipment_SlotArray_policyOwner", "equipment_SlotArray_selector", "equipment_SlotArray_slotsPerLine", "equipment_SlotArray_transverseGroupSeparation", "equipment_SlotArray_transverseGroupSize", "equipment_SlotArray_transverseOffset", "equipment_SlotArray_verticalStartOffset", "equipment_SlotArray_width", "equipment_StatefulBladeCompIf_operQualifierReason", "equipment_StatefulBladeCompIf_operState", "equipment_StatefulBladeCompIf_operability", "equipment_StatefulBladeCompIf_perf", "equipment_StatefulBladeCompIf_power", "equipment_StatefulBladeCompIf_presence", "equipment_StatefulBladeCompIf_thermal", "equipment_StatefulBladeCompIf_voltage", "equipment_StatefulBladeComp_id", "equipment_StatefulBladeComp_model", "equipment_StatefulBladeComp_operQualifierReason", "equipment_StatefulBladeComp_operState", "equipment_StatefulBladeComp_operability", "equipment_StatefulBladeComp_perf", "equipment_StatefulBladeComp_power", "equipment_StatefulBladeComp_presence", "equipment_StatefulBladeComp_revision", "equipment_StatefulBladeComp_serial", "equipment_StatefulBladeComp_thermal", "equipment_StatefulBladeComp_vendor", "equipment_StatefulBladeComp_voltage", "equipment_StatefulChCompIf_operQualifierReason", "equipment_StatefulChCompIf_operState", "equipment_StatefulChCompIf_operability", "equipment_StatefulChCompIf_perf", "equipment_StatefulChCompIf_power", "equipment_StatefulChCompIf_presence", "equipment_StatefulChCompIf_thermal", "equipment_StatefulChCompIf_voltage", "equipment_StatefulChComp_id", "equipment_StatefulChComp_model", "equipment_StatefulChComp_operQualifierReason", "equipment_StatefulChComp_operState", "equipment_StatefulChComp_operability", "equipment_StatefulChComp_perf", "equipment_StatefulChComp_power", "equipment_StatefulChComp_presence", "equipment_StatefulChComp_revision", "equipment_StatefulChComp_serial", "equipment_StatefulChComp_thermal", "equipment_StatefulChComp_vendor", "equipment_StatefulChComp_voltage", "equipment_StatefulIf_operQualifierReason", "equipment_StatefulIf_operability", "equipment_StatefulIf_presence", "equipment_Stateful_id", "equipment_Stateful_model", "equipment_Stateful_operQualifierReason", "equipment_Stateful_operability", "equipment_Stateful_presence", "equipment_Stateful_revision", "equipment_Stateful_serial", "equipment_Stateful_vendor", "equipment_SwitchCapProvider_deleted", "equipment_SwitchCapProvider_deprecated", "equipment_SwitchCapProvider_elementLoadFailures", "equipment_SwitchCapProvider_elementsLoaded", "equipment_SwitchCapProvider_gencount", "equipment_SwitchCapProvider_loadErrors", "equipment_SwitchCapProvider_loadWarnings", "equipment_SwitchCapProvider_mgmtPlaneVer", "equipment_SwitchCapProvider_model", "equipment_SwitchCapProvider_promCardType", "equipment_SwitchCapProvider_revision", "equipment_SwitchCapProvider_vendor", "equipment_SwitchCap_descr", "equipment_SwitchCap_fanModulesSupported", "equipment_SwitchCap_intId", "equipment_SwitchCap_locatorBeaconSupported", "equipment_SwitchCap_maxActiveSpanSessionCount", "equipment_SwitchCap_maxEth1gPort", "equipment_SwitchCap_maxEth1gSlot", "equipment_SwitchCap_maxEthPcMembers", "equipment_SwitchCap_maxEthPcs", "equipment_SwitchCap_maxFcoePcMembers", "equipment_SwitchCap_maxUplinkPorts", "equipment_SwitchCap_mgmtDaughterCardSlotId", "equipment_SwitchCap_name", "equipment_SwitchCap_policyLevel", "equipment_SwitchCap_policyOwner", "equipment_SwitchCap_serenoNetflowSupported", "equipment_SwitchCard_descr", "equipment_SwitchCard_fltAggr", "equipment_SwitchCard_id", "equipment_SwitchCard_model", "equipment_SwitchCard_numPorts", "equipment_SwitchCard_operQualifierReason", "equipment_SwitchCard_operState", "equipment_SwitchCard_operability", "equipment_SwitchCard_perf", "equipment_SwitchCard_power", "equipment_SwitchCard_presence", "equipment_SwitchCard_revision", "equipment_SwitchCard_serial", "equipment_SwitchCard_state", "equipment_SwitchCard_thermal", "equipment_SwitchCard_ts", "equipment_SwitchCard_vendor", "equipment_SwitchCard_voltage", "equipment_TpmCapProvider_deleted", "equipment_TpmCapProvider_deprecated", "equipment_TpmCapProvider_elementLoadFailures", "equipment_TpmCapProvider_elementsLoaded", "equipment_TpmCapProvider_gencount", "equipment_TpmCapProvider_loadErrors", "equipment_TpmCapProvider_loadWarnings", "equipment_TpmCapProvider_mgmtPlaneVer", "equipment_TpmCapProvider_model", "equipment_TpmCapProvider_promCardType", "equipment_TpmCapProvider_revision", "equipment_TpmCapProvider_vendor", "equipment_Tpm_activeStatus", "equipment_Tpm_enabledStatus", "equipment_Tpm_id", "equipment_Tpm_model", "equipment_Tpm_ownership", "equipment_Tpm_passwordState", "equipment_Tpm_presence", "equipment_Tpm_revision", "equipment_Tpm_serial", "equipment_Tpm_tpmRevision", "equipment_Tpm_type", "equipment_Tpm_vendor", "equipment_UnifiedPortCapProvider_descr", "equipment_UnifiedPortCapProvider_intId", "equipment_UnifiedPortCapProvider_name", "equipment_UnifiedPortCapProvider_policyLevel", "equipment_UnifiedPortCapProvider_policyOwner", "equipment_UnifiedPortCapProvider_supportedAlgorithm", "equipment_VersionConstraint_minVer1", "equipment_Xcvr_id", "equipment_Xcvr_model", "equipment_Xcvr_revision", "equipment_Xcvr_serial", "equipment_Xcvr_ts", "equipment_Xcvr_type", "equipment_Xcvr_vendor", "ether_CIoEp_epDn", "ether_CIoEp_ifRole", "ether_CIoEp_ifType", "ether_CIoEp_locale", "ether_CIoEp_name", "ether_CIoEp_peerDn", "ether_CIoEp_portId", "ether_CIoEp_switchId", "ether_CIoEp_transport", "ether_CIoEp_type", "ether_ErrStatsHist_align", "ether_ErrStatsHist_alignDelta", "ether_ErrStatsHist_alignDeltaAvg", "ether_ErrStatsHist_alignDeltaMax", "ether_ErrStatsHist_alignDeltaMin", "ether_ErrStatsHist_deferredTx", "ether_ErrStatsHist_deferredTxDelta", "ether_ErrStatsHist_deferredTxDeltaAvg", "ether_ErrStatsHist_deferredTxDeltaMax", "ether_ErrStatsHist_deferredTxDeltaMin", "ether_ErrStatsHist_fcs", "ether_ErrStatsHist_fcsDelta", "ether_ErrStatsHist_fcsDeltaAvg", "ether_ErrStatsHist_fcsDeltaMax", "ether_ErrStatsHist_fcsDeltaMin", "ether_ErrStatsHist_id", "ether_ErrStatsHist_intMacRx", "ether_ErrStatsHist_intMacRxDelta", "ether_ErrStatsHist_intMacRxDeltaAvg", "ether_ErrStatsHist_intMacRxDeltaMax", "ether_ErrStatsHist_intMacRxDeltaMin", "ether_ErrStatsHist_intMacTx", "ether_ErrStatsHist_intMacTxDelta", "ether_ErrStatsHist_intMacTxDeltaAvg", "ether_ErrStatsHist_intMacTxDeltaMax", "ether_ErrStatsHist_intMacTxDeltaMin", "ether_ErrStatsHist_mostRecent", "ether_ErrStatsHist_outDiscard", "ether_ErrStatsHist_outDiscardDelta", "ether_ErrStatsHist_outDiscardDeltaAvg", "ether_ErrStatsHist_outDiscardDeltaMax", "ether_ErrStatsHist_outDiscardDeltaMin", "ether_ErrStatsHist_rcv", "ether_ErrStatsHist_rcvDelta", "ether_ErrStatsHist_rcvDeltaAvg", "ether_ErrStatsHist_rcvDeltaMax", "ether_ErrStatsHist_rcvDeltaMin", "ether_ErrStatsHist_suspect", "ether_ErrStatsHist_thresholded", "ether_ErrStatsHist_timeCollected", "ether_ErrStatsHist_underSize", "ether_ErrStatsHist_underSizeDelta", "ether_ErrStatsHist_underSizeDeltaAvg", "ether_ErrStatsHist_underSizeDeltaMax", "ether_ErrStatsHist_underSizeDeltaMin", "ether_ErrStatsHist_xmit", "ether_ErrStatsHist_xmitDelta", "ether_ErrStatsHist_xmitDeltaAvg", "ether_ErrStatsHist_xmitDeltaMax", "ether_ErrStatsHist_xmitDeltaMin", "ether_ErrStats_align", "ether_ErrStats_alignDelta", "ether_ErrStats_alignDeltaAvg", "ether_ErrStats_alignDeltaMax", "ether_ErrStats_alignDeltaMin", "ether_ErrStats_deferredTx", "ether_ErrStats_deferredTxDelta", "ether_ErrStats_deferredTxDeltaAvg", "ether_ErrStats_deferredTxDeltaMax", "ether_ErrStats_deferredTxDeltaMin", "ether_ErrStats_fcs", "ether_ErrStats_fcsDelta", "ether_ErrStats_fcsDeltaAvg", "ether_ErrStats_fcsDeltaMax", "ether_ErrStats_fcsDeltaMin", "ether_ErrStats_intMacRx", "ether_ErrStats_intMacRxDelta", "ether_ErrStats_intMacRxDeltaAvg", "ether_ErrStats_intMacRxDeltaMax", "ether_ErrStats_intMacRxDeltaMin", "ether_ErrStats_intMacTx", "ether_ErrStats_intMacTxDelta", "ether_ErrStats_intMacTxDeltaAvg", "ether_ErrStats_intMacTxDeltaMax", "ether_ErrStats_intMacTxDeltaMin", "ether_ErrStats_intervals", "ether_ErrStats_outDiscard", "ether_ErrStats_outDiscardDelta", "ether_ErrStats_outDiscardDeltaAvg", "ether_ErrStats_outDiscardDeltaMax", "ether_ErrStats_outDiscardDeltaMin", "ether_ErrStats_rcv", "ether_ErrStats_rcvDelta", "ether_ErrStats_rcvDeltaAvg", "ether_ErrStats_rcvDeltaMax", "ether_ErrStats_rcvDeltaMin", "ether_ErrStats_suspect", "ether_ErrStats_thresholded", "ether_ErrStats_timeCollected", "ether_ErrStats_underSize", "ether_ErrStats_underSizeDelta", "ether_ErrStats_underSizeDeltaAvg", "ether_ErrStats_underSizeDeltaMax", "ether_ErrStats_underSizeDeltaMin", "ether_ErrStats_update", "ether_ErrStats_xmit", "ether_ErrStats_xmitDelta", "ether_ErrStats_xmitDeltaAvg", "ether_ErrStats_xmitDeltaMax", "ether_ErrStats_xmitDeltaMin", "ether_ExternalEp_adminState", "ether_ExternalEp_chassisId", "ether_ExternalEp_epDn", "ether_ExternalEp_ifRole", "ether_ExternalEp_ifType", "ether_ExternalEp_locale", "ether_ExternalEp_name", "ether_ExternalEp_peerChassisId", "ether_ExternalEp_peerDn", "ether_ExternalEp_peerPortId", "ether_ExternalEp_peerSlotId", "ether_ExternalEp_portId", "ether_ExternalEp_slotId", "ether_ExternalEp_switchId", "ether_ExternalEp_transport", "ether_ExternalEp_type", "ether_ExternalPc_adminState", "ether_ExternalPc_epDn", "ether_ExternalPc_fltAggr", "ether_ExternalPc_ifRole", "ether_ExternalPc_ifType", "ether_ExternalPc_locale", "ether_ExternalPc_name", "ether_ExternalPc_operState", "ether_ExternalPc_peerDn", "ether_ExternalPc_portId", "ether_ExternalPc_stateQual", "ether_ExternalPc_switchId", "ether_ExternalPc_transport", "ether_ExternalPc_type", "ether_FcoeInterfaceStatsHist_bytesRx", "ether_FcoeInterfaceStatsHist_bytesRxDelta", "ether_FcoeInterfaceStatsHist_bytesRxDeltaAvg", "ether_FcoeInterfaceStatsHist_bytesRxDeltaMax", "ether_FcoeInterfaceStatsHist_bytesRxDeltaMin", "ether_FcoeInterfaceStatsHist_bytesTx", "ether_FcoeInterfaceStatsHist_bytesTxDelta", "ether_FcoeInterfaceStatsHist_bytesTxDeltaAvg", "ether_FcoeInterfaceStatsHist_bytesTxDeltaMax", "ether_FcoeInterfaceStatsHist_bytesTxDeltaMin", "ether_FcoeInterfaceStatsHist_droppedRx", "ether_FcoeInterfaceStatsHist_droppedRxDelta", "ether_FcoeInterfaceStatsHist_droppedRxDeltaAvg", "ether_FcoeInterfaceStatsHist_droppedRxDeltaMax", "ether_FcoeInterfaceStatsHist_droppedRxDeltaMin", "ether_FcoeInterfaceStatsHist_droppedTx", "ether_FcoeInterfaceStatsHist_droppedTxDelta", "ether_FcoeInterfaceStatsHist_droppedTxDeltaAvg", "ether_FcoeInterfaceStatsHist_droppedTxDeltaMax", "ether_FcoeInterfaceStatsHist_droppedTxDeltaMin", "ether_FcoeInterfaceStatsHist_errorsRx", "ether_FcoeInterfaceStatsHist_errorsRxDelta", "ether_FcoeInterfaceStatsHist_errorsRxDeltaAvg", "ether_FcoeInterfaceStatsHist_errorsRxDeltaMax", "ether_FcoeInterfaceStatsHist_errorsRxDeltaMin", "ether_FcoeInterfaceStatsHist_errorsTx", "ether_FcoeInterfaceStatsHist_errorsTxDelta", "ether_FcoeInterfaceStatsHist_errorsTxDeltaAvg", "ether_FcoeInterfaceStatsHist_errorsTxDeltaMax", "ether_FcoeInterfaceStatsHist_errorsTxDeltaMin", "ether_FcoeInterfaceStatsHist_id", "ether_FcoeInterfaceStatsHist_mostRecent", "ether_FcoeInterfaceStatsHist_packetsRx", "ether_FcoeInterfaceStatsHist_packetsRxDelta", "ether_FcoeInterfaceStatsHist_packetsRxDeltaAvg", "ether_FcoeInterfaceStatsHist_packetsRxDeltaMax", "ether_FcoeInterfaceStatsHist_packetsRxDeltaMin", "ether_FcoeInterfaceStatsHist_packetsTx", "ether_FcoeInterfaceStatsHist_packetsTxDelta", "ether_FcoeInterfaceStatsHist_packetsTxDeltaAvg", "ether_FcoeInterfaceStatsHist_packetsTxDeltaMax", "ether_FcoeInterfaceStatsHist_packetsTxDeltaMin", "ether_FcoeInterfaceStatsHist_suspect", "ether_FcoeInterfaceStatsHist_thresholded", "ether_FcoeInterfaceStatsHist_timeCollected", "ether_FcoeInterfaceStats_bytesRx", "ether_FcoeInterfaceStats_bytesRxDelta", "ether_FcoeInterfaceStats_bytesRxDeltaAvg", "ether_FcoeInterfaceStats_bytesRxDeltaMax", "ether_FcoeInterfaceStats_bytesRxDeltaMin", "ether_FcoeInterfaceStats_bytesTx", "ether_FcoeInterfaceStats_bytesTxDelta", "ether_FcoeInterfaceStats_bytesTxDeltaAvg", "ether_FcoeInterfaceStats_bytesTxDeltaMax", "ether_FcoeInterfaceStats_bytesTxDeltaMin", "ether_FcoeInterfaceStats_droppedRx", "ether_FcoeInterfaceStats_droppedRxDelta", "ether_FcoeInterfaceStats_droppedRxDeltaAvg", "ether_FcoeInterfaceStats_droppedRxDeltaMax", "ether_FcoeInterfaceStats_droppedRxDeltaMin", "ether_FcoeInterfaceStats_droppedTx", "ether_FcoeInterfaceStats_droppedTxDelta", "ether_FcoeInterfaceStats_droppedTxDeltaAvg", "ether_FcoeInterfaceStats_droppedTxDeltaMax", "ether_FcoeInterfaceStats_droppedTxDeltaMin", "ether_FcoeInterfaceStats_errorsRx", "ether_FcoeInterfaceStats_errorsRxDelta", "ether_FcoeInterfaceStats_errorsRxDeltaAvg", "ether_FcoeInterfaceStats_errorsRxDeltaMax", "ether_FcoeInterfaceStats_errorsRxDeltaMin", "ether_FcoeInterfaceStats_errorsTx", "ether_FcoeInterfaceStats_errorsTxDelta", "ether_FcoeInterfaceStats_errorsTxDeltaAvg", "ether_FcoeInterfaceStats_errorsTxDeltaMax", "ether_FcoeInterfaceStats_errorsTxDeltaMin", "ether_FcoeInterfaceStats_intervals", "ether_FcoeInterfaceStats_packetsRx", "ether_FcoeInterfaceStats_packetsRxDelta", "ether_FcoeInterfaceStats_packetsRxDeltaAvg", "ether_FcoeInterfaceStats_packetsRxDeltaMax", "ether_FcoeInterfaceStats_packetsRxDeltaMin", "ether_FcoeInterfaceStats_packetsTx", "ether_FcoeInterfaceStats_packetsTxDelta", "ether_FcoeInterfaceStats_packetsTxDeltaAvg", "ether_FcoeInterfaceStats_packetsTxDeltaMax", "ether_FcoeInterfaceStats_packetsTxDeltaMin", "ether_FcoeInterfaceStats_suspect", "ether_FcoeInterfaceStats_thresholded", "ether_FcoeInterfaceStats_timeCollected", "ether_FcoeInterfaceStats_update", "ether_IntFIoEp_adminState", "ether_IntFIoEp_chassisId", "ether_IntFIoEp_epDn", "ether_IntFIoEp_ifRole", "ether_IntFIoEp_ifType", "ether_IntFIoEp_locale", "ether_IntFIoEp_name", "ether_IntFIoEp_peerChassisId", "ether_IntFIoEp_peerDn", "ether_IntFIoEp_peerPortId", "ether_IntFIoEp_peerSlotId", "ether_IntFIoEp_portId", "ether_IntFIoEp_slotId", "ether_IntFIoEp_switchId", "ether_IntFIoEp_transport", "ether_IntFIoEp_type", "ether_InternalPc_epDn", "ether_InternalPc_fltAggr", "ether_InternalPc_ifRole", "ether_InternalPc_ifType", "ether_InternalPc_locale", "ether_InternalPc_name", "ether_InternalPc_operState", "ether_InternalPc_peerDn", "ether_InternalPc_portId", "ether_InternalPc_stateQual", "ether_InternalPc_switchId", "ether_InternalPc_transport", "ether_InternalPc_type", "ether_LossStatsHist_SQETest", "ether_LossStatsHist_SQETestDelta", "ether_LossStatsHist_SQETestDeltaAvg", "ether_LossStatsHist_SQETestDeltaMax", "ether_LossStatsHist_SQETestDeltaMin", "ether_LossStatsHist_carrierSense", "ether_LossStatsHist_carrierSenseDelta", "ether_LossStatsHist_carrierSenseDeltaAvg", "ether_LossStatsHist_carrierSenseDeltaMax", "ether_LossStatsHist_carrierSenseDeltaMin", "ether_LossStatsHist_excessCollision", "ether_LossStatsHist_excessCollisionDelta", "ether_LossStatsHist_excessCollisionDeltaAvg", "ether_LossStatsHist_excessCollisionDeltaMax", "ether_LossStatsHist_excessCollisionDeltaMin", "ether_LossStatsHist_giants", "ether_LossStatsHist_giantsDelta", "ether_LossStatsHist_giantsDeltaAvg", "ether_LossStatsHist_giantsDeltaMax", "ether_LossStatsHist_giantsDeltaMin", "ether_LossStatsHist_id", "ether_LossStatsHist_lateCollision", "ether_LossStatsHist_lateCollisionDelta", "ether_LossStatsHist_lateCollisionDeltaAvg", "ether_LossStatsHist_lateCollisionDeltaMax", "ether_LossStatsHist_lateCollisionDeltaMin", "ether_LossStatsHist_mostRecent", "ether_LossStatsHist_multiCollision", "ether_LossStatsHist_multiCollisionDelta", "ether_LossStatsHist_multiCollisionDeltaAvg", "ether_LossStatsHist_multiCollisionDeltaMax", "ether_LossStatsHist_multiCollisionDeltaMin", "ether_LossStatsHist_singleCollision", "ether_LossStatsHist_singleCollisionDelta", "ether_LossStatsHist_singleCollisionDeltaAvg", "ether_LossStatsHist_singleCollisionDeltaMax", "ether_LossStatsHist_singleCollisionDeltaMin", "ether_LossStatsHist_suspect", "ether_LossStatsHist_symbol", "ether_LossStatsHist_symbolDelta", "ether_LossStatsHist_symbolDeltaAvg", "ether_LossStatsHist_symbolDeltaMax", "ether_LossStatsHist_symbolDeltaMin", "ether_LossStatsHist_thresholded", "ether_LossStatsHist_timeCollected", "ether_LossStats_SQETest", "ether_LossStats_SQETestDelta", "ether_LossStats_SQETestDeltaAvg", "ether_LossStats_SQETestDeltaMax", "ether_LossStats_SQETestDeltaMin", "ether_LossStats_carrierSense", "ether_LossStats_carrierSenseDelta", "ether_LossStats_carrierSenseDeltaAvg", "ether_LossStats_carrierSenseDeltaMax", "ether_LossStats_carrierSenseDeltaMin", "ether_LossStats_excessCollision", "ether_LossStats_excessCollisionDelta", "ether_LossStats_excessCollisionDeltaAvg", "ether_LossStats_excessCollisionDeltaMax", "ether_LossStats_excessCollisionDeltaMin", "ether_LossStats_giants", "ether_LossStats_giantsDelta", "ether_LossStats_giantsDeltaAvg", "ether_LossStats_giantsDeltaMax", "ether_LossStats_giantsDeltaMin", "ether_LossStats_intervals", "ether_LossStats_lateCollision", "ether_LossStats_lateCollisionDelta", "ether_LossStats_lateCollisionDeltaAvg", "ether_LossStats_lateCollisionDeltaMax", "ether_LossStats_lateCollisionDeltaMin", "ether_LossStats_multiCollision", "ether_LossStats_multiCollisionDelta", "ether_LossStats_multiCollisionDeltaAvg", "ether_LossStats_multiCollisionDeltaMax", "ether_LossStats_multiCollisionDeltaMin", "ether_LossStats_singleCollision", "ether_LossStats_singleCollisionDelta", "ether_LossStats_singleCollisionDeltaAvg", "ether_LossStats_singleCollisionDeltaMax", "ether_LossStats_singleCollisionDeltaMin", "ether_LossStats_suspect", "ether_LossStats_symbol", "ether_LossStats_symbolDelta", "ether_LossStats_symbolDeltaAvg", "ether_LossStats_symbolDeltaMax", "ether_LossStats_symbolDeltaMin", "ether_LossStats_thresholded", "ether_LossStats_timeCollected", "ether_LossStats_update", "ether_PIoEndPoint_EndPointDn", "ether_PIoEndPoint_epCloudType", "ether_PIoEndPoint_usrLbl", "ether_PIoEp_chassisId", "ether_PIoEp_epDn", "ether_PIoEp_ifRole", "ether_PIoEp_ifType", "ether_PIoEp_locale", "ether_PIoEp_name", "ether_PIoEp_peerChassisId", "ether_PIoEp_peerDn", "ether_PIoEp_peerPortId", "ether_PIoEp_peerSlotId", "ether_PIoEp_portId", "ether_PIoEp_slotId", "ether_PIoEp_switchId", "ether_PIoEp_transport", "ether_PIoEp_type", "ether_PIoFsmStage_descr", "ether_PIoFsmStage_lastUpdateTime", "ether_PIoFsmStage_name", "ether_PIoFsmStage_order", "ether_PIoFsmStage_retry", "ether_PIoFsmStage_stageStatus", "ether_PIoFsm_completionTime", "ether_PIoFsm_currentFsm", "ether_PIoFsm_descr", "ether_PIoFsm_fsmStatus", "ether_PIoFsm_instanceId", "ether_PIoFsm_progress", "ether_PIoFsm_rmtErrCode", "ether_PIoFsm_rmtErrDescr", "ether_PIoFsm_rmtRslt", "ether_PIo_adminState", "ether_PIo_adminTransport", "ether_PIo_chassisId", "ether_PIo_encap", "ether_PIo_epDn", "ether_PIo_fsmDescr", "ether_PIo_fsmPrev", "ether_PIo_fsmProgr", "ether_PIo_fsmRmtInvErrCode", "ether_PIo_fsmRmtInvErrDescr", "ether_PIo_fsmRmtInvRslt", "ether_PIo_fsmStageDescr", "ether_PIo_fsmStamp", "ether_PIo_fsmStatus", "ether_PIo_fsmTry", "ether_PIo_ifRole", "ether_PIo_ifType", "ether_PIo_isPortChannelMember", "ether_PIo_lc", "ether_PIo_licGP", "ether_PIo_licState", "ether_PIo_locale", "ether_PIo_mac", "ether_PIo_mode", "ether_PIo_model", "ether_PIo_name", "ether_PIo_operSpeed", "ether_PIo_operState", "ether_PIo_peerChassisId", "ether_PIo_peerDn", "ether_PIo_peerPortId", "ether_PIo_peerSlotId", "ether_PIo_portId", "ether_PIo_revision", "ether_PIo_serial", "ether_PIo_slotId", "ether_PIo_stateQual", "ether_PIo_switchId", "ether_PIo_transport", "ether_PIo_ts", "ether_PIo_type", "ether_PIo_unifiedPort", "ether_PIo_usrLbl", "ether_PIo_vendor", "ether_PIo_xcvrType", "ether_PauseStatsHist_id", "ether_PauseStatsHist_mostRecent", "ether_PauseStatsHist_recvPause", "ether_PauseStatsHist_recvPauseDelta", "ether_PauseStatsHist_recvPauseDeltaAvg", "ether_PauseStatsHist_recvPauseDeltaMax", "ether_PauseStatsHist_recvPauseDeltaMin", "ether_PauseStatsHist_resets", "ether_PauseStatsHist_resetsDelta", "ether_PauseStatsHist_resetsDeltaAvg", "ether_PauseStatsHist_resetsDeltaMax", "ether_PauseStatsHist_resetsDeltaMin", "ether_PauseStatsHist_suspect", "ether_PauseStatsHist_thresholded", "ether_PauseStatsHist_timeCollected", "ether_PauseStatsHist_xmitPause", "ether_PauseStatsHist_xmitPauseDelta", "ether_PauseStatsHist_xmitPauseDeltaAvg", "ether_PauseStatsHist_xmitPauseDeltaMax", "ether_PauseStatsHist_xmitPauseDeltaMin", "ether_PauseStats_intervals", "ether_PauseStats_recvPause", "ether_PauseStats_recvPauseDelta", "ether_PauseStats_recvPauseDeltaAvg", "ether_PauseStats_recvPauseDeltaMax", "ether_PauseStats_recvPauseDeltaMin", "ether_PauseStats_resets", "ether_PauseStats_resetsDelta", "ether_PauseStats_resetsDeltaAvg", "ether_PauseStats_resetsDeltaMax", "ether_PauseStats_resetsDeltaMin", "ether_PauseStats_suspect", "ether_PauseStats_thresholded", "ether_PauseStats_timeCollected", "ether_PauseStats_update", "ether_PauseStats_xmitPause", "ether_PauseStats_xmitPauseDelta", "ether_PauseStats_xmitPauseDeltaAvg", "ether_PauseStats_xmitPauseDeltaMax", "ether_PauseStats_xmitPauseDeltaMin", "ether_Pc_epDn", "ether_Pc_ifRole", "ether_Pc_ifType", "ether_Pc_locale", "ether_Pc_name", "ether_Pc_operState", "ether_Pc_peerDn", "ether_Pc_portId", "ether_Pc_stateQual", "ether_Pc_switchId", "ether_Pc_transport", "ether_Pc_type", "ether_PortChanIdElem_id", "ether_RxStatsHist_broadcastPackets", "ether_RxStatsHist_broadcastPacketsDelta", "ether_RxStatsHist_broadcastPacketsDeltaAvg", "ether_RxStatsHist_broadcastPacketsDeltaMax", "ether_RxStatsHist_broadcastPacketsDeltaMin", "ether_RxStatsHist_id", "ether_RxStatsHist_jumboPackets", "ether_RxStatsHist_jumboPacketsDelta", "ether_RxStatsHist_jumboPacketsDeltaAvg", "ether_RxStatsHist_jumboPacketsDeltaMax", "ether_RxStatsHist_jumboPacketsDeltaMin", "ether_RxStatsHist_mostRecent", "ether_RxStatsHist_multicastPackets", "ether_RxStatsHist_multicastPacketsDelta", "ether_RxStatsHist_multicastPacketsDeltaAvg", "ether_RxStatsHist_multicastPacketsDeltaMax", "ether_RxStatsHist_multicastPacketsDeltaMin", "ether_RxStatsHist_suspect", "ether_RxStatsHist_thresholded", "ether_RxStatsHist_timeCollected", "ether_RxStatsHist_totalBytes", "ether_RxStatsHist_totalBytesDelta", "ether_RxStatsHist_totalBytesDeltaAvg", "ether_RxStatsHist_totalBytesDeltaMax", "ether_RxStatsHist_totalBytesDeltaMin", "ether_RxStatsHist_totalPackets", "ether_RxStatsHist_totalPacketsDelta", "ether_RxStatsHist_totalPacketsDeltaAvg", "ether_RxStatsHist_totalPacketsDeltaMax", "ether_RxStatsHist_totalPacketsDeltaMin", "ether_RxStatsHist_unicastPackets", "ether_RxStatsHist_unicastPacketsDelta", "ether_RxStatsHist_unicastPacketsDeltaAvg", "ether_RxStatsHist_unicastPacketsDeltaMax", "ether_RxStatsHist_unicastPacketsDeltaMin", "ether_RxStats_broadcastPackets", "ether_RxStats_broadcastPacketsDelta", "ether_RxStats_broadcastPacketsDeltaAvg", "ether_RxStats_broadcastPacketsDeltaMax", "ether_RxStats_broadcastPacketsDeltaMin", "ether_RxStats_intervals", "ether_RxStats_jumboPackets", "ether_RxStats_jumboPacketsDelta", "ether_RxStats_jumboPacketsDeltaAvg", "ether_RxStats_jumboPacketsDeltaMax", "ether_RxStats_jumboPacketsDeltaMin", "ether_RxStats_multicastPackets", "ether_RxStats_multicastPacketsDelta", "ether_RxStats_multicastPacketsDeltaAvg", "ether_RxStats_multicastPacketsDeltaMax", "ether_RxStats_multicastPacketsDeltaMin", "ether_RxStats_suspect", "ether_RxStats_thresholded", "ether_RxStats_timeCollected", "ether_RxStats_totalBytes", "ether_RxStats_totalBytesDelta", "ether_RxStats_totalBytesDeltaAvg", "ether_RxStats_totalBytesDeltaMax", "ether_RxStats_totalBytesDeltaMin", "ether_RxStats_totalPackets", "ether_RxStats_totalPacketsDelta", "ether_RxStats_totalPacketsDeltaAvg", "ether_RxStats_totalPacketsDeltaMax", "ether_RxStats_totalPacketsDeltaMin", "ether_RxStats_unicastPackets", "ether_RxStats_unicastPacketsDelta", "ether_RxStats_unicastPacketsDeltaAvg", "ether_RxStats_unicastPacketsDeltaMax", "ether_RxStats_unicastPacketsDeltaMin", "ether_RxStats_update", "ether_ServerIntFIoFsmStage_descr", "ether_ServerIntFIoFsmStage_lastUpdateTime", "ether_ServerIntFIoFsmStage_name", "ether_ServerIntFIoFsmStage_order", "ether_ServerIntFIoFsmStage_retry", "ether_ServerIntFIoFsmStage_stageStatus", "ether_ServerIntFIoFsmTask_completion", "ether_ServerIntFIoFsmTask_flags", "ether_ServerIntFIoFsmTask_item", "ether_ServerIntFIoFsmTask_seqId", "ether_ServerIntFIoFsm_completionTime", "ether_ServerIntFIoFsm_currentFsm", "ether_ServerIntFIoFsm_descr", "ether_ServerIntFIoFsm_fsmStatus", "ether_ServerIntFIoFsm_instanceId", "ether_ServerIntFIoFsm_progress", "ether_ServerIntFIoFsm_rmtErrCode", "ether_ServerIntFIoFsm_rmtErrDescr", "ether_ServerIntFIoFsm_rmtRslt", "ether_ServerIntFIoPcEp_adminState", "ether_ServerIntFIoPcEp_chassisId", "ether_ServerIntFIoPcEp_epDn", "ether_ServerIntFIoPcEp_ifRole", "ether_ServerIntFIoPcEp_ifType", "ether_ServerIntFIoPcEp_locale", "ether_ServerIntFIoPcEp_membership", "ether_ServerIntFIoPcEp_name", "ether_ServerIntFIoPcEp_peerChassisId", "ether_ServerIntFIoPcEp_peerDn", "ether_ServerIntFIoPcEp_peerPortId", "ether_ServerIntFIoPcEp_peerSlotId", "ether_ServerIntFIoPcEp_portId", "ether_ServerIntFIoPcEp_slotId", "ether_ServerIntFIoPcEp_switchId", "ether_ServerIntFIoPcEp_transport", "ether_ServerIntFIoPcEp_type", "ether_ServerIntFIoPc_chassisId", "ether_ServerIntFIoPc_epDn", "ether_ServerIntFIoPc_fltAggr", "ether_ServerIntFIoPc_ifRole", "ether_ServerIntFIoPc_ifType", "ether_ServerIntFIoPc_locale", "ether_ServerIntFIoPc_name", "ether_ServerIntFIoPc_operSpeed", "ether_ServerIntFIoPc_operState", "ether_ServerIntFIoPc_peerDn", "ether_ServerIntFIoPc_portId", "ether_ServerIntFIoPc_stateQual", "ether_ServerIntFIoPc_switchId", "ether_ServerIntFIoPc_transport", "ether_ServerIntFIoPc_type", "ether_ServerIntFIo_adminSpeed", "ether_ServerIntFIo_adminState", "ether_ServerIntFIo_chassisId", "ether_ServerIntFIo_encap", "ether_ServerIntFIo_epDn", "ether_ServerIntFIo_fsmDescr", "ether_ServerIntFIo_fsmPrev", "ether_ServerIntFIo_fsmProgr", "ether_ServerIntFIo_fsmRmtInvErrCode", "ether_ServerIntFIo_fsmRmtInvErrDescr", "ether_ServerIntFIo_fsmRmtInvRslt", "ether_ServerIntFIo_fsmStageDescr", "ether_ServerIntFIo_fsmStamp", "ether_ServerIntFIo_fsmStatus", "ether_ServerIntFIo_fsmTry", "ether_ServerIntFIo_ifRole", "ether_ServerIntFIo_ifType", "ether_ServerIntFIo_locale", "ether_ServerIntFIo_mac", "ether_ServerIntFIo_mode", "ether_ServerIntFIo_model", "ether_ServerIntFIo_name", "ether_ServerIntFIo_nsSize", "ether_ServerIntFIo_operBorderPortId", "ether_ServerIntFIo_operBorderSlotId", "ether_ServerIntFIo_operState", "ether_ServerIntFIo_peerChassisId", "ether_ServerIntFIo_peerDn", "ether_ServerIntFIo_peerEncap", "ether_ServerIntFIo_peerPortId", "ether_ServerIntFIo_peerSlotId", "ether_ServerIntFIo_portId", "ether_ServerIntFIo_revision", "ether_ServerIntFIo_serial", "ether_ServerIntFIo_slotId", "ether_ServerIntFIo_stateQual", "ether_ServerIntFIo_switchId", "ether_ServerIntFIo_transport", "ether_ServerIntFIo_ts", "ether_ServerIntFIo_type", "ether_ServerIntFIo_vendor", "ether_ServerIntFIo_xcvrType", "ether_SwitchIntFIoPcEp_ackState", "ether_SwitchIntFIoPcEp_adminState", "ether_SwitchIntFIoPcEp_chassisId", "ether_SwitchIntFIoPcEp_epDn", "ether_SwitchIntFIoPcEp_ifRole", "ether_SwitchIntFIoPcEp_ifType", "ether_SwitchIntFIoPcEp_locale", "ether_SwitchIntFIoPcEp_membership", "ether_SwitchIntFIoPcEp_name", "ether_SwitchIntFIoPcEp_peerChassisId", "ether_SwitchIntFIoPcEp_peerDn", "ether_SwitchIntFIoPcEp_peerPortId", "ether_SwitchIntFIoPcEp_peerSlotId", "ether_SwitchIntFIoPcEp_portId", "ether_SwitchIntFIoPcEp_slotId", "ether_SwitchIntFIoPcEp_statusChangeTs", "ether_SwitchIntFIoPcEp_switchId", "ether_SwitchIntFIoPcEp_transport", "ether_SwitchIntFIoPcEp_type", "ether_SwitchIntFIoPc_adminState", "ether_SwitchIntFIoPc_chassisId", "ether_SwitchIntFIoPc_epDn", "ether_SwitchIntFIoPc_fltAggr", "ether_SwitchIntFIoPc_ifRole", "ether_SwitchIntFIoPc_ifType", "ether_SwitchIntFIoPc_locale", "ether_SwitchIntFIoPc_name", "ether_SwitchIntFIoPc_operSpeed", "ether_SwitchIntFIoPc_operState", "ether_SwitchIntFIoPc_peerDn", "ether_SwitchIntFIoPc_portId", "ether_SwitchIntFIoPc_stateQual", "ether_SwitchIntFIoPc_switchId", "ether_SwitchIntFIoPc_transport", "ether_SwitchIntFIoPc_type", "ether_SwitchIntFIo_ack", "ether_SwitchIntFIo_adminState", "ether_SwitchIntFIo_chassisId", "ether_SwitchIntFIo_delFeTs", "ether_SwitchIntFIo_discovery", "ether_SwitchIntFIo_encap", "ether_SwitchIntFIo_epDn", "ether_SwitchIntFIo_ifRole", "ether_SwitchIntFIo_ifType", "ether_SwitchIntFIo_locale", "ether_SwitchIntFIo_mode", "ether_SwitchIntFIo_model", "ether_SwitchIntFIo_name", "ether_SwitchIntFIo_newFeTs", "ether_SwitchIntFIo_operState", "ether_SwitchIntFIo_peerChassisId", "ether_SwitchIntFIo_peerDn", "ether_SwitchIntFIo_peerPortId", "ether_SwitchIntFIo_peerSlotId", "ether_SwitchIntFIo_portId", "ether_SwitchIntFIo_revision", "ether_SwitchIntFIo_serial", "ether_SwitchIntFIo_slotId", "ether_SwitchIntFIo_stateQual", "ether_SwitchIntFIo_switchId", "ether_SwitchIntFIo_transport", "ether_SwitchIntFIo_ts", "ether_SwitchIntFIo_type", "ether_SwitchIntFIo_vendor", "ether_SwitchIntFIo_xcvrType", "ether_TxStatsHist_broadcastPackets", "ether_TxStatsHist_broadcastPacketsDelta", "ether_TxStatsHist_broadcastPacketsDeltaAvg", "ether_TxStatsHist_broadcastPacketsDeltaMax", "ether_TxStatsHist_broadcastPacketsDeltaMin", "ether_TxStatsHist_id", "ether_TxStatsHist_jumboPackets", "ether_TxStatsHist_jumboPacketsDelta", "ether_TxStatsHist_jumboPacketsDeltaAvg", "ether_TxStatsHist_jumboPacketsDeltaMax", "ether_TxStatsHist_jumboPacketsDeltaMin", "ether_TxStatsHist_mostRecent", "ether_TxStatsHist_multicastPackets", "ether_TxStatsHist_multicastPacketsDelta", "ether_TxStatsHist_multicastPacketsDeltaAvg", "ether_TxStatsHist_multicastPacketsDeltaMax", "ether_TxStatsHist_multicastPacketsDeltaMin", "ether_TxStatsHist_suspect", "ether_TxStatsHist_thresholded", "ether_TxStatsHist_timeCollected", "ether_TxStatsHist_totalBytes", "ether_TxStatsHist_totalBytesDelta", "ether_TxStatsHist_totalBytesDeltaAvg", "ether_TxStatsHist_totalBytesDeltaMax", "ether_TxStatsHist_totalBytesDeltaMin", "ether_TxStatsHist_totalPackets", "ether_TxStatsHist_totalPacketsDelta", "ether_TxStatsHist_totalPacketsDeltaAvg", "ether_TxStatsHist_totalPacketsDeltaMax", "ether_TxStatsHist_totalPacketsDeltaMin", "ether_TxStatsHist_unicastPackets", "ether_TxStatsHist_unicastPacketsDelta", "ether_TxStatsHist_unicastPacketsDeltaAvg", "ether_TxStatsHist_unicastPacketsDeltaMax", "ether_TxStatsHist_unicastPacketsDeltaMin", "ether_TxStats_broadcastPackets", "ether_TxStats_broadcastPacketsDelta", "ether_TxStats_broadcastPacketsDeltaAvg", "ether_TxStats_broadcastPacketsDeltaMax", "ether_TxStats_broadcastPacketsDeltaMin", "ether_TxStats_intervals", "ether_TxStats_jumboPackets", "ether_TxStats_jumboPacketsDelta", "ether_TxStats_jumboPacketsDeltaAvg", "ether_TxStats_jumboPacketsDeltaMax", "ether_TxStats_jumboPacketsDeltaMin", "ether_TxStats_multicastPackets", "ether_TxStats_multicastPacketsDelta", "ether_TxStats_multicastPacketsDeltaAvg", "ether_TxStats_multicastPacketsDeltaMax", "ether_TxStats_multicastPacketsDeltaMin", "ether_TxStats_suspect", "ether_TxStats_thresholded", "ether_TxStats_timeCollected", "ether_TxStats_totalBytes", "ether_TxStats_totalBytesDelta", "ether_TxStats_totalBytesDeltaAvg", "ether_TxStats_totalBytesDeltaMax", "ether_TxStats_totalBytesDeltaMin", "ether_TxStats_totalPackets", "ether_TxStats_totalPacketsDelta", "ether_TxStats_totalPacketsDeltaAvg", "ether_TxStats_totalPacketsDeltaMax", "ether_TxStats_totalPacketsDeltaMin", "ether_TxStats_unicastPackets", "ether_TxStats_unicastPacketsDelta", "ether_TxStats_unicastPacketsDeltaAvg", "ether_TxStats_unicastPacketsDeltaMax", "ether_TxStats_unicastPacketsDeltaMin", "ether_TxStats_update", "event_EpCtrl_level", "event_EpCtrl_revertTimeout", "event_Holder_name", "event_Inst_cause", "event_Inst_changeSet", "event_Inst_code", "event_Inst_created", "event_Inst_descr", "event_Inst_id", "event_Inst_rule", "event_Inst_severity", "event_Inst_tags", "event_Inst_type", "event_Log_maxSize", "event_Log_purgeWindow", "event_Log_size", "event_Policy_descr", "event_Policy_intId", "event_Policy_name", "event_Policy_policyLevel", "event_Policy_policyOwner", "event_Policy_retentionInterval", "event_Policy_sizeLimit", "event_Record_affected", "event_Record_cause", "event_Record_changeSet", "event_Record_code", "event_Record_created", "event_Record_descr", "event_Record_id", "event_Record_ind", "event_Record_sessionId", "event_Record_severity", "event_Record_trig", "event_Record_txId", "event_Record_user", "extmgmt_ArpTargets_configState", "extmgmt_ArpTargets_configStatusMessage", "extmgmt_ArpTargets_maxDeadlineTimeout", "extmgmt_ArpTargets_numberOfArpRequests", "extmgmt_ArpTargets_targetIp1", "extmgmt_ArpTargets_targetIp2", "extmgmt_ArpTargets_targetIp3", "extmgmt_GatewayPing_maxDeadlineTimeout", "extmgmt_GatewayPing_numberOfPingRequests", "extmgmt_IfMonPolicy_adminState", "extmgmt_IfMonPolicy_descr", "extmgmt_IfMonPolicy_enableHAFailover", "extmgmt_IfMonPolicy_intId", "extmgmt_IfMonPolicy_maxFailReportCount", "extmgmt_IfMonPolicy_monitorMechanism", "extmgmt_IfMonPolicy_name", "extmgmt_IfMonPolicy_policyLevel", "extmgmt_IfMonPolicy_policyOwner", "extmgmt_IfMonPolicy_pollInterval", "extmgmt_If_epDn", "extmgmt_If_failReportCount", "extmgmt_If_id", "extmgmt_If_ifRole", "extmgmt_If_ifType", "extmgmt_If_lastOperStateReport", "extmgmt_If_locale", "extmgmt_If_name", "extmgmt_If_operState", "extmgmt_If_peerDn", "extmgmt_If_transport", "extmgmt_If_type", "extmgmt_MiiStatus_maxRetryCount", "extmgmt_MiiStatus_retryInterval", "extmgmt_NdiscTargets_configState", "extmgmt_NdiscTargets_configStatusMessage", "extmgmt_NdiscTargets_ipv6Target1", "extmgmt_NdiscTargets_ipv6Target2", "extmgmt_NdiscTargets_ipv6Target3", "extmgmt_NdiscTargets_maxDeadlineTimeout", "extmgmt_NdiscTargets_numberOfNdiscRequests", "extpol_ClientCont_genNum", "extpol_Client_capability", "extpol_Client_connProtocol", "extpol_Client_descr", "extpol_Client_gracePeriodUsed", "extpol_Client_guid", "extpol_Client_host", "extpol_Client_id", "extpol_Client_interest", "extpol_Client_ip", "extpol_Client_ipv6", "extpol_Client_lastPollTs", "extpol_Client_licState", "extpol_Client_name", "extpol_Client_operState", "extpol_Client_owner", "extpol_Client_site", "extpol_Client_suspendState", "extpol_Client_type", "extpol_Client_version", "extpol_Connector_capability", "extpol_Connector_connProtocol", "extpol_Connector_host", "extpol_Connector_id", "extpol_Connector_interest", "extpol_Connector_ip", "extpol_Connector_ipv6", "extpol_Connector_lastPollTs", "extpol_Connector_name", "extpol_Connector_operState", "extpol_Connector_type", "extpol_Connector_version", "extpol_ControllerCont_genNum", "extpol_Controller_capability", "extpol_Controller_connProtocol", "extpol_Controller_host", "extpol_Controller_id", "extpol_Controller_interest", "extpol_Controller_ip", "extpol_Controller_ipv6", "extpol_Controller_lastPollTs", "extpol_Controller_name", "extpol_Controller_operState", "extpol_Controller_type", "extpol_Controller_version", "extpol_EpFsmStage_descr", "extpol_EpFsmStage_lastUpdateTime", "extpol_EpFsmStage_name", "extpol_EpFsmStage_order", "extpol_EpFsmStage_retry", "extpol_EpFsmStage_stageStatus", "extpol_EpFsmTask_completion", "extpol_EpFsmTask_flags", "extpol_EpFsmTask_item", "extpol_EpFsmTask_seqId", "extpol_EpFsm_completionTime", "extpol_EpFsm_currentFsm", "extpol_EpFsm_descr", "extpol_EpFsm_fsmStatus", "extpol_EpFsm_instanceId", "extpol_EpFsm_progress", "extpol_EpFsm_rmtErrCode", "extpol_EpFsm_rmtErrDescr", "extpol_EpFsm_rmtRslt", "extpol_Ep_fsmDescr", "extpol_Ep_fsmPrev", "extpol_Ep_fsmProgr", "extpol_Ep_fsmRmtInvErrCode", "extpol_Ep_fsmRmtInvErrDescr", "extpol_Ep_fsmRmtInvRslt", "extpol_Ep_fsmStageDescr", "extpol_Ep_fsmStamp", "extpol_Ep_fsmStatus", "extpol_Ep_fsmTry", "extpol_ProviderCont_genNum", "extpol_ProviderFsmStage_descr", "extpol_ProviderFsmStage_lastUpdateTime", "extpol_ProviderFsmStage_name", "extpol_ProviderFsmStage_order", "extpol_ProviderFsmStage_retry", "extpol_ProviderFsmStage_stageStatus", "extpol_ProviderFsmTask_completion", "extpol_ProviderFsmTask_flags", "extpol_ProviderFsmTask_item", "extpol_ProviderFsmTask_seqId", "extpol_ProviderFsm_completionTime", "extpol_ProviderFsm_currentFsm", "extpol_ProviderFsm_descr", "extpol_ProviderFsm_fsmStatus", "extpol_ProviderFsm_instanceId", "extpol_ProviderFsm_progress", "extpol_ProviderFsm_rmtErrCode", "extpol_ProviderFsm_rmtErrDescr", "extpol_ProviderFsm_rmtRslt", "extpol_Provider_capability", "extpol_Provider_connProtocol", "extpol_Provider_fsmDescr", "extpol_Provider_fsmPrev", "extpol_Provider_fsmProgr", "extpol_Provider_fsmRmtInvErrCode", "extpol_Provider_fsmRmtInvErrDescr", "extpol_Provider_fsmRmtInvRslt", "extpol_Provider_fsmStageDescr", "extpol_Provider_fsmStamp", "extpol_Provider_fsmStatus", "extpol_Provider_fsmTry", "extpol_Provider_host", "extpol_Provider_id", "extpol_Provider_interest", "extpol_Provider_ip", "extpol_Provider_ipv6", "extpol_Provider_lastPollTs", "extpol_Provider_name", "extpol_Provider_operState", "extpol_Provider_type", "extpol_Provider_version", "extpol_RegistryFsmStage_descr", "extpol_RegistryFsmStage_lastUpdateTime", "extpol_RegistryFsmStage_name", "extpol_RegistryFsmStage_order", "extpol_RegistryFsmStage_retry", "extpol_RegistryFsmStage_stageStatus", "extpol_RegistryFsmTask_completion", "extpol_RegistryFsmTask_flags", "extpol_RegistryFsmTask_item", "extpol_RegistryFsmTask_seqId", "extpol_RegistryFsm_completionTime", "extpol_RegistryFsm_currentFsm", "extpol_RegistryFsm_descr", "extpol_RegistryFsm_fsmStatus", "extpol_RegistryFsm_instanceId", "extpol_RegistryFsm_progress", "extpol_RegistryFsm_rmtErrCode", "extpol_RegistryFsm_rmtErrDescr", "extpol_RegistryFsm_rmtRslt", "extpol_Registry_capability", "extpol_Registry_connProtocol", "extpol_Registry_fsmDescr", "extpol_Registry_fsmPrev", "extpol_Registry_fsmProgr", "extpol_Registry_fsmRmtInvErrCode", "extpol_Registry_fsmRmtInvErrDescr", "extpol_Registry_fsmRmtInvRslt", "extpol_Registry_fsmStageDescr", "extpol_Registry_fsmStamp", "extpol_Registry_fsmStatus", "extpol_Registry_fsmTry", "extpol_Registry_genNum", "extpol_Registry_guid", "extpol_Registry_host", "extpol_Registry_id", "extpol_Registry_idCount", "extpol_Registry_interest", "extpol_Registry_ip", "extpol_Registry_ipv6", "extpol_Registry_lastPollTs", "extpol_Registry_name", "extpol_Registry_operState", "extpol_Registry_type", "extpol_Registry_version", "extpol_Svc_capability", "extpol_Svc_connProtocol", "extpol_Svc_host", "extpol_Svc_id", "extpol_Svc_interest", "extpol_Svc_ip", "extpol_Svc_ipv6", "extpol_Svc_lastPollTs", "extpol_Svc_name", "extpol_Svc_operState", "extpol_Svc_type", "extpol_Svc_version", "extpol_SystemContext_capability", "extpol_SystemContext_descr", "extpol_SystemContext_guid", "extpol_SystemContext_id", "extpol_SystemContext_interest", "extpol_SystemContext_ip", "extpol_SystemContext_ipv6addr", "extpol_SystemContext_name", "extpol_SystemContext_owner", "extpol_SystemContext_site", "extpol_SystemContext_type", "extpol_SystemContext_version", "extvmm_EpFsmStage_descr", "extvmm_EpFsmStage_lastUpdateTime", "extvmm_EpFsmStage_name", "extvmm_EpFsmStage_order", "extvmm_EpFsmStage_retry", "extvmm_EpFsmStage_stageStatus", "extvmm_EpFsmTask_completion", "extvmm_EpFsmTask_flags", "extvmm_EpFsmTask_item", "extvmm_EpFsmTask_seqId", "extvmm_EpFsm_completionTime", "extvmm_EpFsm_currentFsm", "extvmm_EpFsm_descr", "extvmm_EpFsm_fsmStatus", "extvmm_EpFsm_instanceId", "extvmm_EpFsm_progress", "extvmm_EpFsm_rmtErrCode", "extvmm_EpFsm_rmtErrDescr", "extvmm_EpFsm_rmtRslt", "extvmm_Ep_fsmDescr", "extvmm_Ep_fsmPrev", "extvmm_Ep_fsmProgr", "extvmm_Ep_fsmRmtInvErrCode", "extvmm_Ep_fsmRmtInvErrDescr", "extvmm_Ep_fsmRmtInvRslt", "extvmm_Ep_fsmStageDescr", "extvmm_Ep_fsmStamp", "extvmm_Ep_fsmStatus", "extvmm_Ep_fsmTry", "extvmm_Ep_genNum", "extvmm_FNDReference_descr", "extvmm_FNDReference_fnDefName", "extvmm_FNDReference_intId", "extvmm_FNDReference_name", "extvmm_FNDReference_operFnDefName", "extvmm_FNDReference_policyLevel", "extvmm_FNDReference_policyOwner", "extvmm_FabricNetworkDefinition_allowedVnicType", "extvmm_FabricNetworkDefinition_descr", "extvmm_FabricNetworkDefinition_guid", "extvmm_FabricNetworkDefinition_intId", "extvmm_FabricNetworkDefinition_name", "extvmm_FabricNetworkDefinition_policyLevel", "extvmm_FabricNetworkDefinition_policyOwner", "extvmm_FabricNetworkDefinition_primaryVlanId", "extvmm_FabricNetworkDefinition_refOperState", "extvmm_FabricNetwork_descr", "extvmm_FabricNetwork_guid", "extvmm_FabricNetwork_intId", "extvmm_FabricNetwork_name", "extvmm_FabricNetwork_networkType", "extvmm_FabricNetwork_policyLevel", "extvmm_FabricNetwork_policyOwner", "extvmm_FabricNetwork_refOperState", "extvmm_KeyInst_inst", "extvmm_KeyInst_key", "extvmm_KeyRing_certFile", "extvmm_KeyRing_location", "extvmm_KeyRing_name", "extvmm_KeyRing_path", "extvmm_KeyStoreFsmStage_descr", "extvmm_KeyStoreFsmStage_lastUpdateTime", "extvmm_KeyStoreFsmStage_name", "extvmm_KeyStoreFsmStage_order", "extvmm_KeyStoreFsmStage_retry", "extvmm_KeyStoreFsmStage_stageStatus", "extvmm_KeyStoreFsmTask_completion", "extvmm_KeyStoreFsmTask_flags", "extvmm_KeyStoreFsmTask_item", "extvmm_KeyStoreFsmTask_seqId", "extvmm_KeyStoreFsm_completionTime", "extvmm_KeyStoreFsm_currentFsm", "extvmm_KeyStoreFsm_descr", "extvmm_KeyStoreFsm_fsmStatus", "extvmm_KeyStoreFsm_instanceId", "extvmm_KeyStoreFsm_progress", "extvmm_KeyStoreFsm_rmtErrCode", "extvmm_KeyStoreFsm_rmtErrDescr", "extvmm_KeyStoreFsm_rmtRslt", "extvmm_KeyStore_fsmDescr", "extvmm_KeyStore_fsmPrev", "extvmm_KeyStore_fsmProgr", "extvmm_KeyStore_fsmRmtInvErrCode", "extvmm_KeyStore_fsmRmtInvErrDescr", "extvmm_KeyStore_fsmRmtInvRslt", "extvmm_KeyStore_fsmStageDescr", "extvmm_KeyStore_fsmStamp", "extvmm_KeyStore_fsmStatus", "extvmm_KeyStore_fsmTry", "extvmm_MasterExtKeyFsmStage_descr", "extvmm_MasterExtKeyFsmStage_lastUpdateTime", "extvmm_MasterExtKeyFsmStage_name", "extvmm_MasterExtKeyFsmStage_order", "extvmm_MasterExtKeyFsmStage_retry", "extvmm_MasterExtKeyFsmStage_stageStatus", "extvmm_MasterExtKeyFsmTask_completion", "extvmm_MasterExtKeyFsmTask_flags", "extvmm_MasterExtKeyFsmTask_item", "extvmm_MasterExtKeyFsmTask_seqId", "extvmm_MasterExtKeyFsm_completionTime", "extvmm_MasterExtKeyFsm_currentFsm", "extvmm_MasterExtKeyFsm_descr", "extvmm_MasterExtKeyFsm_fsmStatus", "extvmm_MasterExtKeyFsm_instanceId", "extvmm_MasterExtKeyFsm_progress", "extvmm_MasterExtKeyFsm_rmtErrCode", "extvmm_MasterExtKeyFsm_rmtErrDescr", "extvmm_MasterExtKeyFsm_rmtRslt", "extvmm_MasterExtKey_fsmDescr", "extvmm_MasterExtKey_fsmPrev", "extvmm_MasterExtKey_fsmProgr", "extvmm_MasterExtKey_fsmRmtInvErrCode", "extvmm_MasterExtKey_fsmRmtInvErrDescr", "extvmm_MasterExtKey_fsmRmtInvRslt", "extvmm_MasterExtKey_fsmStageDescr", "extvmm_MasterExtKey_fsmStamp", "extvmm_MasterExtKey_fsmStatus", "extvmm_MasterExtKey_fsmTry", "extvmm_MasterExtKey_key", "extvmm_NetworkSetsFsmStage_descr", "extvmm_NetworkSetsFsmStage_lastUpdateTime", "extvmm_NetworkSetsFsmStage_name", "extvmm_NetworkSetsFsmStage_order", "extvmm_NetworkSetsFsmStage_retry", "extvmm_NetworkSetsFsmStage_stageStatus", "extvmm_NetworkSetsFsmTask_completion", "extvmm_NetworkSetsFsmTask_flags", "extvmm_NetworkSetsFsmTask_item", "extvmm_NetworkSetsFsmTask_seqId", "extvmm_NetworkSetsFsm_completionTime", "extvmm_NetworkSetsFsm_currentFsm", "extvmm_NetworkSetsFsm_descr", "extvmm_NetworkSetsFsm_fsmStatus", "extvmm_NetworkSetsFsm_instanceId", "extvmm_NetworkSetsFsm_progress", "extvmm_NetworkSetsFsm_rmtErrCode", "extvmm_NetworkSetsFsm_rmtErrDescr", "extvmm_NetworkSetsFsm_rmtRslt", "extvmm_NetworkSets_fsmDescr", "extvmm_NetworkSets_fsmPrev", "extvmm_NetworkSets_fsmProgr", "extvmm_NetworkSets_fsmRmtInvErrCode", "extvmm_NetworkSets_fsmRmtInvErrDescr", "extvmm_NetworkSets_fsmRmtInvRslt", "extvmm_NetworkSets_fsmStageDescr", "extvmm_NetworkSets_fsmStamp", "extvmm_NetworkSets_fsmStatus", "extvmm_NetworkSets_fsmTry", "extvmm_NetworkSets_genNum", "extvmm_ProviderFsmStage_descr", "extvmm_ProviderFsmStage_lastUpdateTime", "extvmm_ProviderFsmStage_name", "extvmm_ProviderFsmStage_order", "extvmm_ProviderFsmStage_retry", "extvmm_ProviderFsmStage_stageStatus", "extvmm_ProviderFsmTask_completion", "extvmm_ProviderFsmTask_flags", "extvmm_ProviderFsmTask_item", "extvmm_ProviderFsmTask_seqId", "extvmm_ProviderFsm_completionTime", "extvmm_ProviderFsm_currentFsm", "extvmm_ProviderFsm_descr", "extvmm_ProviderFsm_fsmStatus", "extvmm_ProviderFsm_instanceId", "extvmm_ProviderFsm_progress", "extvmm_ProviderFsm_rmtErrCode", "extvmm_ProviderFsm_rmtErrDescr", "extvmm_ProviderFsm_rmtRslt", "extvmm_Provider_cert", "extvmm_Provider_descr", "extvmm_Provider_fsmDescr", "extvmm_Provider_fsmPrev", "extvmm_Provider_fsmProgr", "extvmm_Provider_fsmRmtInvErrCode", "extvmm_Provider_fsmRmtInvErrDescr", "extvmm_Provider_fsmRmtInvRslt", "extvmm_Provider_fsmStageDescr", "extvmm_Provider_fsmStamp", "extvmm_Provider_fsmStatus", "extvmm_Provider_fsmTry", "extvmm_Provider_host", "extvmm_Provider_intId", "extvmm_Provider_key", "extvmm_Provider_name", "extvmm_Provider_policyLevel", "extvmm_Provider_policyOwner", "extvmm_Provider_portValue", "extvmm_Provider_uuid", "extvmm_Provider_vendorType", "extvmm_Provider_ver", "extvmm_Provider_verRaw", "extvmm_SwitchDelTaskFsmStage_descr", "extvmm_SwitchDelTaskFsmStage_lastUpdateTime", "extvmm_SwitchDelTaskFsmStage_name", "extvmm_SwitchDelTaskFsmStage_order", "extvmm_SwitchDelTaskFsmStage_retry", "extvmm_SwitchDelTaskFsmStage_stageStatus", "extvmm_SwitchDelTaskFsmTask_completion", "extvmm_SwitchDelTaskFsmTask_flags", "extvmm_SwitchDelTaskFsmTask_item", "extvmm_SwitchDelTaskFsmTask_seqId", "extvmm_SwitchDelTaskFsm_completionTime", "extvmm_SwitchDelTaskFsm_currentFsm", "extvmm_SwitchDelTaskFsm_descr", "extvmm_SwitchDelTaskFsm_fsmStatus", "extvmm_SwitchDelTaskFsm_instanceId", "extvmm_SwitchDelTaskFsm_progress", "extvmm_SwitchDelTaskFsm_rmtErrCode", "extvmm_SwitchDelTaskFsm_rmtErrDescr", "extvmm_SwitchDelTaskFsm_rmtRslt", "extvmm_SwitchDelTask_certFile", "extvmm_SwitchDelTask_dcName", "extvmm_SwitchDelTask_dcOrg", "extvmm_SwitchDelTask_descr", "extvmm_SwitchDelTask_extKey", "extvmm_SwitchDelTask_fsmDescr", "extvmm_SwitchDelTask_fsmPrev", "extvmm_SwitchDelTask_fsmProgr", "extvmm_SwitchDelTask_fsmRmtInvErrCode", "extvmm_SwitchDelTask_fsmRmtInvErrDescr", "extvmm_SwitchDelTask_fsmRmtInvRslt", "extvmm_SwitchDelTask_fsmStageDescr", "extvmm_SwitchDelTask_fsmStamp", "extvmm_SwitchDelTask_fsmStatus", "extvmm_SwitchDelTask_fsmTry", "extvmm_SwitchDelTask_host", "extvmm_SwitchDelTask_intId", "extvmm_SwitchDelTask_keyInst", "extvmm_SwitchDelTask_name", "extvmm_SwitchDelTask_orgPath", "extvmm_SwitchDelTask_policyLevel", "extvmm_SwitchDelTask_policyOwner", "extvmm_SwitchDelTask_portValue", "extvmm_SwitchDelTask_provIntId", "extvmm_SwitchDelTask_provider", "extvmm_SwitchDelTask_swIntId", "extvmm_SwitchDelTask_swName", "extvmm_UpLinkPP_descr", "extvmm_UpLinkPP_guid", "extvmm_UpLinkPP_intId", "extvmm_UpLinkPP_name", "extvmm_UpLinkPP_policyLevel", "extvmm_UpLinkPP_policyOwner", "extvmm_UpLinkPP_refOperState", "extvmm_VMNDRef_configQualifier", "extvmm_VMNDRef_descr", "extvmm_VMNDRef_fnDefName", "extvmm_VMNDRef_fnName", "extvmm_VMNDRef_intId", "extvmm_VMNDRef_name", "extvmm_VMNDRef_operVmNetworkDefName", "extvmm_VMNDRef_policyLevel", "extvmm_VMNDRef_policyOwner", "extvmm_VMNDRef_vmNetworkDefName", "extvmm_VMNetworkDefinition_descr", "extvmm_VMNetworkDefinition_extIpPoolName", "extvmm_VMNetworkDefinition_guid", "extvmm_VMNetworkDefinition_intId", "extvmm_VMNetworkDefinition_ipPoolGuid", "extvmm_VMNetworkDefinition_maxPorts", "extvmm_VMNetworkDefinition_name", "extvmm_VMNetworkDefinition_operExtIpPoolName", "extvmm_VMNetworkDefinition_policyLevel", "extvmm_VMNetworkDefinition_policyOwner", "extvmm_VMNetworkDefinition_primaryVlanId", "extvmm_VMNetworkDefinition_refOperState", "extvmm_VMNetworkDefinition_vlanName", "extvmm_VMNetworkSets_genNum", "extvmm_VMNetwork_descr", "extvmm_VMNetwork_fabricNetworkName", "extvmm_VMNetwork_guid", "extvmm_VMNetwork_intId", "extvmm_VMNetwork_name", "extvmm_VMNetwork_operFabricNetworkName", "extvmm_VMNetwork_policyLevel", "extvmm_VMNetwork_policyOwner", "fabric_ADceSwSrvEp_adminState", "fabric_ADceSwSrvEp_chassisId", "fabric_ADceSwSrvEp_epDn", "fabric_ADceSwSrvEp_fltAggr", "fabric_ADceSwSrvEp_ifRole", "fabric_ADceSwSrvEp_ifType", "fabric_ADceSwSrvEp_licGP", "fabric_ADceSwSrvEp_licState", "fabric_ADceSwSrvEp_locale", "fabric_ADceSwSrvEp_name", "fabric_ADceSwSrvEp_operState", "fabric_ADceSwSrvEp_operStateReason", "fabric_ADceSwSrvEp_peerChassisId", "fabric_ADceSwSrvEp_peerDn", "fabric_ADceSwSrvEp_peerPortId", "fabric_ADceSwSrvEp_peerSlotId", "fabric_ADceSwSrvEp_portId", "fabric_ADceSwSrvEp_slotId", "fabric_ADceSwSrvEp_switchId", "fabric_ADceSwSrvEp_transport", "fabric_ADceSwSrvEp_type", "fabric_ADceSwSrvEp_usrLbl", "fabric_AEthEstcEp_adminState", "fabric_AEthEstcEp_chassisId", "fabric_AEthEstcEp_configState", "fabric_AEthEstcEp_epDn", "fabric_AEthEstcEp_fltAggr", "fabric_AEthEstcEp_ifRole", "fabric_AEthEstcEp_ifType", "fabric_AEthEstcEp_licGP", "fabric_AEthEstcEp_licState", "fabric_AEthEstcEp_locale", "fabric_AEthEstcEp_name", "fabric_AEthEstcEp_operState", "fabric_AEthEstcEp_operStateReason", "fabric_AEthEstcEp_peerChassisId", "fabric_AEthEstcEp_peerDn", "fabric_AEthEstcEp_peerPortId", "fabric_AEthEstcEp_peerSlotId", "fabric_AEthEstcEp_portId", "fabric_AEthEstcEp_slotId", "fabric_AEthEstcEp_switchId", "fabric_AEthEstcEp_transport", "fabric_AEthEstcEp_type", "fabric_AEthEstcEp_usrLbl", "fabric_AEthEstcEp_warnings", "fabric_AEthLanEp_adminState", "fabric_AEthLanEp_chassisId", "fabric_AEthLanEp_epDn", "fabric_AEthLanEp_fltAggr", "fabric_AEthLanEp_ifRole", "fabric_AEthLanEp_ifType", "fabric_AEthLanEp_licGP", "fabric_AEthLanEp_licState", "fabric_AEthLanEp_locale", "fabric_AEthLanEp_name", "fabric_AEthLanEp_operState", "fabric_AEthLanEp_operStateReason", "fabric_AEthLanEp_peerChassisId", "fabric_AEthLanEp_peerDn", "fabric_AEthLanEp_peerPortId", "fabric_AEthLanEp_peerSlotId", "fabric_AEthLanEp_portId", "fabric_AEthLanEp_slotId", "fabric_AEthLanEp_switchId", "fabric_AEthLanEp_transport", "fabric_AEthLanEp_type", "fabric_AEthLanEp_warnings", "fabric_AFcEstcEp_adminState", "fabric_AFcEstcEp_chassisId", "fabric_AFcEstcEp_configState", "fabric_AFcEstcEp_epDn", "fabric_AFcEstcEp_fltAggr", "fabric_AFcEstcEp_ifRole", "fabric_AFcEstcEp_ifType", "fabric_AFcEstcEp_licGP", "fabric_AFcEstcEp_licState", "fabric_AFcEstcEp_locale", "fabric_AFcEstcEp_name", "fabric_AFcEstcEp_operState", "fabric_AFcEstcEp_operStateReason", "fabric_AFcEstcEp_peerChassisId", "fabric_AFcEstcEp_peerDn", "fabric_AFcEstcEp_peerPortId", "fabric_AFcEstcEp_peerSlotId", "fabric_AFcEstcEp_portId", "fabric_AFcEstcEp_slotId", "fabric_AFcEstcEp_switchId", "fabric_AFcEstcEp_transport", "fabric_AFcEstcEp_type", "fabric_AFcEstcEp_usrLbl", "fabric_AFcEstcEp_warnings", "fabric_AFcSanEp_adminState", "fabric_AFcSanEp_chassisId", "fabric_AFcSanEp_epDn", "fabric_AFcSanEp_fltAggr", "fabric_AFcSanEp_ifRole", "fabric_AFcSanEp_ifType", "fabric_AFcSanEp_licGP", "fabric_AFcSanEp_licState", "fabric_AFcSanEp_locale", "fabric_AFcSanEp_name", "fabric_AFcSanEp_operState", "fabric_AFcSanEp_operStateReason", "fabric_AFcSanEp_peerChassisId", "fabric_AFcSanEp_peerDn", "fabric_AFcSanEp_peerPortId", "fabric_AFcSanEp_peerSlotId", "fabric_AFcSanEp_portId", "fabric_AFcSanEp_slotId", "fabric_AFcSanEp_switchId", "fabric_AFcSanEp_transport", "fabric_AFcSanEp_type", "fabric_AFcSanEp_warnings", "fabric_AFcoeEstcEp_adminState", "fabric_AFcoeEstcEp_chassisId", "fabric_AFcoeEstcEp_configState", "fabric_AFcoeEstcEp_epDn", "fabric_AFcoeEstcEp_fltAggr", "fabric_AFcoeEstcEp_ifRole", "fabric_AFcoeEstcEp_ifType", "fabric_AFcoeEstcEp_licGP", "fabric_AFcoeEstcEp_licState", "fabric_AFcoeEstcEp_locale", "fabric_AFcoeEstcEp_name", "fabric_AFcoeEstcEp_operState", "fabric_AFcoeEstcEp_operStateReason", "fabric_AFcoeEstcEp_peerChassisId", "fabric_AFcoeEstcEp_peerDn", "fabric_AFcoeEstcEp_peerPortId", "fabric_AFcoeEstcEp_peerSlotId", "fabric_AFcoeEstcEp_portId", "fabric_AFcoeEstcEp_slotId", "fabric_AFcoeEstcEp_switchId", "fabric_AFcoeEstcEp_transport", "fabric_AFcoeEstcEp_type", "fabric_AFcoeEstcEp_usrLbl", "fabric_AFcoeEstcEp_warnings", "fabric_AFcoeSanEp_adminState", "fabric_AFcoeSanEp_chassisId", "fabric_AFcoeSanEp_epDn", "fabric_AFcoeSanEp_fltAggr", "fabric_AFcoeSanEp_ifRole", "fabric_AFcoeSanEp_ifType", "fabric_AFcoeSanEp_licGP", "fabric_AFcoeSanEp_licState", "fabric_AFcoeSanEp_locale", "fabric_AFcoeSanEp_name", "fabric_AFcoeSanEp_operState", "fabric_AFcoeSanEp_operStateReason", "fabric_AFcoeSanEp_peerChassisId", "fabric_AFcoeSanEp_peerDn", "fabric_AFcoeSanEp_peerPortId", "fabric_AFcoeSanEp_peerSlotId", "fabric_AFcoeSanEp_portId", "fabric_AFcoeSanEp_slotId", "fabric_AFcoeSanEp_switchId", "fabric_AFcoeSanEp_transport", "fabric_AFcoeSanEp_type", "fabric_AFcoeSanEp_warnings", "fabric_AVlan_epDn", "fabric_AVlan_id", "fabric_AVlan_ifRole", "fabric_AVlan_ifType", "fabric_AVlan_locale", "fabric_AVlan_name", "fabric_AVlan_operState", "fabric_AVlan_peerDn", "fabric_AVlan_policyOwner", "fabric_AVlan_pubNwDn", "fabric_AVlan_pubNwId", "fabric_AVlan_pubNwName", "fabric_AVlan_sharing", "fabric_AVlan_switchId", "fabric_AVlan_transport", "fabric_AVlan_type", "fabric_AVsan_epDn", "fabric_AVsan_fcoeVlan", "fabric_AVsan_id", "fabric_AVsan_ifRole", "fabric_AVsan_ifType", "fabric_AVsan_locale", "fabric_AVsan_name", "fabric_AVsan_operState", "fabric_AVsan_peerDn", "fabric_AVsan_policyOwner", "fabric_AVsan_switchId", "fabric_AVsan_transport", "fabric_AVsan_type", "fabric_AVsan_zoningState", "fabric_BHVlan_epDn", "fabric_BHVlan_id", "fabric_BHVlan_ifRole", "fabric_BHVlan_ifType", "fabric_BHVlan_locale", "fabric_BHVlan_name", "fabric_BHVlan_operState", "fabric_BHVlan_peerDn", "fabric_BHVlan_policyOwner", "fabric_BHVlan_pubNwDn", "fabric_BHVlan_pubNwId", "fabric_BHVlan_pubNwName", "fabric_BHVlan_sharing", "fabric_BHVlan_switchId", "fabric_BHVlan_transport", "fabric_BHVlan_type", "fabric_CIoEp_adminState", "fabric_CIoEp_descr", "fabric_CIoEp_epDn", "fabric_CIoEp_ifRole", "fabric_CIoEp_ifType", "fabric_CIoEp_locale", "fabric_CIoEp_name", "fabric_CIoEp_peerDn", "fabric_CIoEp_portId", "fabric_CIoEp_switchId", "fabric_CIoEp_transport", "fabric_CIoEp_type", "fabric_CdpLinkPolicy_adminState", "fabric_CdpLinkPolicy_descr", "fabric_CdpLinkPolicy_intId", "fabric_CdpLinkPolicy_name", "fabric_CdpLinkPolicy_policyLevel", "fabric_CdpLinkPolicy_policyOwner", "fabric_CdpLinkPolicy_protocol", "fabric_CdpLinkPolicy_type", "fabric_ChangedObjectRef_centraleVnetEpDn", "fabric_ChangedObjectRef_id", "fabric_ChangedObjectRef_oldCentraleVnetEpDn", "fabric_ChangedObjectRef_refObjStatus", "fabric_ChangedObjectRef_ucsmVnetEpDn", "fabric_ChassisEp_adminState", "fabric_ChassisEp_chassisDn", "fabric_ChassisEp_chassisId", "fabric_ChassisEp_epDn", "fabric_ChassisEp_fltAggr", "fabric_ChassisEp_ifRole", "fabric_ChassisEp_ifType", "fabric_ChassisEp_licGP", "fabric_ChassisEp_licState", "fabric_ChassisEp_locale", "fabric_ChassisEp_model", "fabric_ChassisEp_name", "fabric_ChassisEp_operState", "fabric_ChassisEp_operStateReason", "fabric_ChassisEp_peerChassisId", "fabric_ChassisEp_peerDn", "fabric_ChassisEp_peerPortId", "fabric_ChassisEp_peerSlotId", "fabric_ChassisEp_portId", "fabric_ChassisEp_revision", "fabric_ChassisEp_serial", "fabric_ChassisEp_slotId", "fabric_ChassisEp_switchId", "fabric_ChassisEp_transport", "fabric_ChassisEp_type", "fabric_ChassisEp_vendor", "fabric_ComputeEp_adminState", "fabric_ComputeEp_chassisId", "fabric_ComputeEp_epDn", "fabric_ComputeEp_fltAggr", "fabric_ComputeEp_ifRole", "fabric_ComputeEp_ifType", "fabric_ComputeEp_licGP", "fabric_ComputeEp_licState", "fabric_ComputeEp_locale", "fabric_ComputeEp_name", "fabric_ComputeEp_operState", "fabric_ComputeEp_operStateReason", "fabric_ComputeEp_peerChassisId", "fabric_ComputeEp_peerDn", "fabric_ComputeEp_peerPortId", "fabric_ComputeEp_peerSlotId", "fabric_ComputeEp_portId", "fabric_ComputeEp_slotId", "fabric_ComputeEp_switchId", "fabric_ComputeEp_transport", "fabric_ComputeEp_type", "fabric_ComputePhEp_adminState", "fabric_ComputePhEp_chassisId", "fabric_ComputePhEp_checkpointTrigTs", "fabric_ComputePhEp_deepCheckpointTrigTs", "fabric_ComputePhEp_discTrigTs", "fabric_ComputePhEp_epDn", "fabric_ComputePhEp_eqType", "fabric_ComputePhEp_fltAggr", "fabric_ComputePhEp_ifRole", "fabric_ComputePhEp_ifType", "fabric_ComputePhEp_lc", "fabric_ComputePhEp_licGP", "fabric_ComputePhEp_licState", "fabric_ComputePhEp_locale", "fabric_ComputePhEp_model", "fabric_ComputePhEp_name", "fabric_ComputePhEp_operState", "fabric_ComputePhEp_operStateReason", "fabric_ComputePhEp_peerChassisId", "fabric_ComputePhEp_peerDn", "fabric_ComputePhEp_peerPortId", "fabric_ComputePhEp_peerSlotId", "fabric_ComputePhEp_portId", "fabric_ComputePhEp_profileDn", "fabric_ComputePhEp_revision", "fabric_ComputePhEp_serial", "fabric_ComputePhEp_slotId", "fabric_ComputePhEp_switchId", "fabric_ComputePhEp_transport", "fabric_ComputePhEp_type", "fabric_ComputePhEp_vendor", "fabric_ComputeSlotEpFsmStage_descr", "fabric_ComputeSlotEpFsmStage_lastUpdateTime", "fabric_ComputeSlotEpFsmStage_name", "fabric_ComputeSlotEpFsmStage_order", "fabric_ComputeSlotEpFsmStage_retry", "fabric_ComputeSlotEpFsmStage_stageStatus", "fabric_ComputeSlotEpFsmTask_completion", "fabric_ComputeSlotEpFsmTask_flags", "fabric_ComputeSlotEpFsmTask_item", "fabric_ComputeSlotEpFsmTask_seqId", "fabric_ComputeSlotEpFsm_completionTime", "fabric_ComputeSlotEpFsm_currentFsm", "fabric_ComputeSlotEpFsm_descr", "fabric_ComputeSlotEpFsm_fsmStatus", "fabric_ComputeSlotEpFsm_instanceId", "fabric_ComputeSlotEpFsm_progress", "fabric_ComputeSlotEpFsm_rmtErrCode", "fabric_ComputeSlotEpFsm_rmtErrDescr", "fabric_ComputeSlotEpFsm_rmtRslt", "fabric_ComputeSlotEp_adminState", "fabric_ComputeSlotEp_chassisId", "fabric_ComputeSlotEp_connPath", "fabric_ComputeSlotEp_connStatus", "fabric_ComputeSlotEp_discovery", "fabric_ComputeSlotEp_epDn", "fabric_ComputeSlotEp_fltAggr", "fabric_ComputeSlotEp_fruIdentTrigTs", "fabric_ComputeSlotEp_fsmDescr", "fabric_ComputeSlotEp_fsmPrev", "fabric_ComputeSlotEp_fsmProgr", "fabric_ComputeSlotEp_fsmRmtInvErrCode", "fabric_ComputeSlotEp_fsmRmtInvErrDescr", "fabric_ComputeSlotEp_fsmRmtInvRslt", "fabric_ComputeSlotEp_fsmStageDescr", "fabric_ComputeSlotEp_fsmStamp", "fabric_ComputeSlotEp_fsmStatus", "fabric_ComputeSlotEp_fsmTry", "fabric_ComputeSlotEp_ifRole", "fabric_ComputeSlotEp_ifType", "fabric_ComputeSlotEp_lcTs", "fabric_ComputeSlotEp_licGP", "fabric_ComputeSlotEp_licState", "fabric_ComputeSlotEp_locale", "fabric_ComputeSlotEp_managingInst", "fabric_ComputeSlotEp_model", "fabric_ComputeSlotEp_name", "fabric_ComputeSlotEp_operState", "fabric_ComputeSlotEp_operStateReason", "fabric_ComputeSlotEp_peerChassisId", "fabric_ComputeSlotEp_peerDn", "fabric_ComputeSlotEp_peerPortId", "fabric_ComputeSlotEp_peerSlotId", "fabric_ComputeSlotEp_portId", "fabric_ComputeSlotEp_presence", "fabric_ComputeSlotEp_revision", "fabric_ComputeSlotEp_serial", "fabric_ComputeSlotEp_slotId", "fabric_ComputeSlotEp_switchId", "fabric_ComputeSlotEp_transport", "fabric_ComputeSlotEp_type", "fabric_ComputeSlotEp_vendor", "fabric_DceSrv_id", "fabric_DceSrv_locale", "fabric_DceSrv_name", "fabric_DceSrv_transport", "fabric_DceSrv_type", "fabric_DceSwSrvEp_adminState", "fabric_DceSwSrvEp_chassisId", "fabric_DceSwSrvEp_epDn", "fabric_DceSwSrvEp_fltAggr", "fabric_DceSwSrvEp_ifRole", "fabric_DceSwSrvEp_ifType", "fabric_DceSwSrvEp_licGP", "fabric_DceSwSrvEp_licState", "fabric_DceSwSrvEp_locale", "fabric_DceSwSrvEp_name", "fabric_DceSwSrvEp_operState", "fabric_DceSwSrvEp_operStateReason", "fabric_DceSwSrvEp_peerChassisId", "fabric_DceSwSrvEp_peerDn", "fabric_DceSwSrvEp_peerPortId", "fabric_DceSwSrvEp_peerSlotId", "fabric_DceSwSrvEp_portId", "fabric_DceSwSrvEp_slotId", "fabric_DceSwSrvEp_switchId", "fabric_DceSwSrvEp_transport", "fabric_DceSwSrvEp_type", "fabric_DceSwSrvEp_usrLbl", "fabric_DceSwSrvPcEp_adminState", "fabric_DceSwSrvPcEp_chassisId", "fabric_DceSwSrvPcEp_epDn", "fabric_DceSwSrvPcEp_fltAggr", "fabric_DceSwSrvPcEp_ifRole", "fabric_DceSwSrvPcEp_ifType", "fabric_DceSwSrvPcEp_licGP", "fabric_DceSwSrvPcEp_licState", "fabric_DceSwSrvPcEp_locale", "fabric_DceSwSrvPcEp_membership", "fabric_DceSwSrvPcEp_name", "fabric_DceSwSrvPcEp_operState", "fabric_DceSwSrvPcEp_operStateReason", "fabric_DceSwSrvPcEp_peerChassisId", "fabric_DceSwSrvPcEp_peerDn", "fabric_DceSwSrvPcEp_peerPortId", "fabric_DceSwSrvPcEp_peerSlotId", "fabric_DceSwSrvPcEp_portId", "fabric_DceSwSrvPcEp_slotId", "fabric_DceSwSrvPcEp_switchId", "fabric_DceSwSrvPcEp_transport", "fabric_DceSwSrvPcEp_type", "fabric_DceSwSrvPcEp_usrLbl", "fabric_DceSwSrvPc_adminState", "fabric_DceSwSrvPc_chassisId", "fabric_DceSwSrvPc_descr", "fabric_DceSwSrvPc_epDn", "fabric_DceSwSrvPc_fltAggr", "fabric_DceSwSrvPc_ifRole", "fabric_DceSwSrvPc_ifType", "fabric_DceSwSrvPc_locale", "fabric_DceSwSrvPc_name", "fabric_DceSwSrvPc_operSpeed", "fabric_DceSwSrvPc_operState", "fabric_DceSwSrvPc_peerDn", "fabric_DceSwSrvPc_portId", "fabric_DceSwSrvPc_stateQual", "fabric_DceSwSrvPc_switchId", "fabric_DceSwSrvPc_transport", "fabric_DceSwSrvPc_type", "fabric_DceSwSrv_id", "fabric_DceSwSrv_locale", "fabric_DceSwSrv_name", "fabric_DceSwSrv_transport", "fabric_DceSwSrv_type", "fabric_Domain_id", "fabric_Domain_locale", "fabric_Domain_name", "fabric_Domain_transport", "fabric_Domain_type", "fabric_EpMgrFsmStage_descr", "fabric_EpMgrFsmStage_lastUpdateTime", "fabric_EpMgrFsmStage_name", "fabric_EpMgrFsmStage_order", "fabric_EpMgrFsmStage_retry", "fabric_EpMgrFsmStage_stageStatus", "fabric_EpMgrFsmTask_completion", "fabric_EpMgrFsmTask_flags", "fabric_EpMgrFsmTask_item", "fabric_EpMgrFsmTask_seqId", "fabric_EpMgrFsm_completionTime", "fabric_EpMgrFsm_currentFsm", "fabric_EpMgrFsm_descr", "fabric_EpMgrFsm_fsmStatus", "fabric_EpMgrFsm_instanceId", "fabric_EpMgrFsm_progress", "fabric_EpMgrFsm_rmtErrCode", "fabric_EpMgrFsm_rmtErrDescr", "fabric_EpMgrFsm_rmtRslt", "fabric_EpMgr_confMode", "fabric_EpMgr_confQual", "fabric_EpMgr_confState", "fabric_EpMgr_fsmDescr", "fabric_EpMgr_fsmFlags", "fabric_EpMgr_fsmPrev", "fabric_EpMgr_fsmProgr", "fabric_EpMgr_fsmRmtInvErrCode", "fabric_EpMgr_fsmRmtInvErrDescr", "fabric_EpMgr_fsmRmtInvRslt", "fabric_EpMgr_fsmStageDescr", "fabric_EpMgr_fsmStamp", "fabric_EpMgr_fsmStatus", "fabric_EpMgr_fsmTry", "fabric_EpMgr_id", "fabric_EpVlan_epDn", "fabric_EpVlan_id", "fabric_EpVlan_ifRole", "fabric_EpVlan_ifType", "fabric_EpVlan_locale", "fabric_EpVlan_name", "fabric_EpVlan_operState", "fabric_EpVlan_peerDn", "fabric_EpVlan_policyOwner", "fabric_EpVlan_pubNwDn", "fabric_EpVlan_pubNwId", "fabric_EpVlan_pubNwName", "fabric_EpVlan_sharing", "fabric_EpVlan_switchId", "fabric_EpVlan_transport", "fabric_EpVlan_type", "fabric_EpVlan_vlanType", "fabric_EpVsan_epDn", "fabric_EpVsan_fcoeVlan", "fabric_EpVsan_id", "fabric_EpVsan_ifRole", "fabric_EpVsan_ifType", "fabric_EpVsan_locale", "fabric_EpVsan_name", "fabric_EpVsan_operState", "fabric_EpVsan_peerDn", "fabric_EpVsan_policyOwner", "fabric_EpVsan_switchId", "fabric_EpVsan_transport", "fabric_EpVsan_type", "fabric_EpVsan_zoningState", "fabric_EstcEp_adminState", "fabric_EstcEp_chassisId", "fabric_EstcEp_configState", "fabric_EstcEp_epDn", "fabric_EstcEp_fltAggr", "fabric_EstcEp_ifRole", "fabric_EstcEp_ifType", "fabric_EstcEp_licGP", "fabric_EstcEp_licState", "fabric_EstcEp_locale", "fabric_EstcEp_name", "fabric_EstcEp_operState", "fabric_EstcEp_operStateReason", "fabric_EstcEp_peerChassisId", "fabric_EstcEp_peerDn", "fabric_EstcEp_peerPortId", "fabric_EstcEp_peerSlotId", "fabric_EstcEp_portId", "fabric_EstcEp_slotId", "fabric_EstcEp_switchId", "fabric_EstcEp_transport", "fabric_EstcEp_type", "fabric_EstcEp_usrLbl", "fabric_EstcEp_warnings", "fabric_EstcPc_adminSpeed", "fabric_EstcPc_adminState", "fabric_EstcPc_descr", "fabric_EstcPc_epDn", "fabric_EstcPc_fltAggr", "fabric_EstcPc_ifRole", "fabric_EstcPc_ifType", "fabric_EstcPc_locale", "fabric_EstcPc_name", "fabric_EstcPc_operSpeed", "fabric_EstcPc_operState", "fabric_EstcPc_peerDn", "fabric_EstcPc_portId", "fabric_EstcPc_stateQual", "fabric_EstcPc_switchId", "fabric_EstcPc_transport", "fabric_EstcPc_type", "fabric_EstcPc_warnings", "fabric_EthCdpPolicy_descr", "fabric_EthCdpPolicy_intId", "fabric_EthCdpPolicy_name", "fabric_EthCdpPolicy_policyLevel", "fabric_EthCdpPolicy_policyOwner", "fabric_EthCdpPolicy_protocol", "fabric_EthCdpPolicy_type", "fabric_EthEstcEp_adminSpeed", "fabric_EthEstcEp_adminState", "fabric_EthEstcEp_chassisId", "fabric_EthEstcEp_configState", "fabric_EthEstcEp_epDn", "fabric_EthEstcEp_flowCtrlPolicy", "fabric_EthEstcEp_fltAggr", "fabric_EthEstcEp_ifRole", "fabric_EthEstcEp_ifType", "fabric_EthEstcEp_licGP", "fabric_EthEstcEp_licState", "fabric_EthEstcEp_locale", "fabric_EthEstcEp_name", "fabric_EthEstcEp_nwCtrlPolicyName", "fabric_EthEstcEp_operNwCtrlPolicyName", "fabric_EthEstcEp_operState", "fabric_EthEstcEp_operStateReason", "fabric_EthEstcEp_peerChassisId", "fabric_EthEstcEp_peerDn", "fabric_EthEstcEp_peerPortId", "fabric_EthEstcEp_peerSlotId", "fabric_EthEstcEp_pinGroupName", "fabric_EthEstcEp_portId", "fabric_EthEstcEp_portMode", "fabric_EthEstcEp_prio", "fabric_EthEstcEp_slotId", "fabric_EthEstcEp_switchId", "fabric_EthEstcEp_transport", "fabric_EthEstcEp_type", "fabric_EthEstcEp_usrLbl", "fabric_EthEstcEp_warnings", "fabric_EthEstcPcEp_adminSpeed", "fabric_EthEstcPcEp_adminState", "fabric_EthEstcPcEp_chassisId", "fabric_EthEstcPcEp_configState", "fabric_EthEstcPcEp_epDn", "fabric_EthEstcPcEp_fltAggr", "fabric_EthEstcPcEp_ifRole", "fabric_EthEstcPcEp_ifType", "fabric_EthEstcPcEp_licGP", "fabric_EthEstcPcEp_licState", "fabric_EthEstcPcEp_locale", "fabric_EthEstcPcEp_membership", "fabric_EthEstcPcEp_name", "fabric_EthEstcPcEp_operState", "fabric_EthEstcPcEp_operStateReason", "fabric_EthEstcPcEp_peerChassisId", "fabric_EthEstcPcEp_peerDn", "fabric_EthEstcPcEp_peerPortId", "fabric_EthEstcPcEp_peerSlotId", "fabric_EthEstcPcEp_portId", "fabric_EthEstcPcEp_slotId", "fabric_EthEstcPcEp_switchId", "fabric_EthEstcPcEp_transport", "fabric_EthEstcPcEp_type", "fabric_EthEstcPcEp_usrLbl", "fabric_EthEstcPcEp_warnings", "fabric_EthEstcPc_adminSpeed", "fabric_EthEstcPc_adminState", "fabric_EthEstcPc_descr", "fabric_EthEstcPc_epDn", "fabric_EthEstcPc_flowCtrlPolicy", "fabric_EthEstcPc_fltAggr", "fabric_EthEstcPc_ifRole", "fabric_EthEstcPc_ifType", "fabric_EthEstcPc_locale", "fabric_EthEstcPc_name", "fabric_EthEstcPc_nwCtrlPolicyName", "fabric_EthEstcPc_operNwCtrlPolicyName", "fabric_EthEstcPc_operSpeed", "fabric_EthEstcPc_operState", "fabric_EthEstcPc_peerDn", "fabric_EthEstcPc_pinGroupName", "fabric_EthEstcPc_portId", "fabric_EthEstcPc_portMode", "fabric_EthEstcPc_prio", "fabric_EthEstcPc_protocol", "fabric_EthEstcPc_stateQual", "fabric_EthEstcPc_switchId", "fabric_EthEstcPc_transport", "fabric_EthEstcPc_type", "fabric_EthEstcPc_warnings", "fabric_EthEstc_id", "fabric_EthEstc_locale", "fabric_EthEstc_name", "fabric_EthEstc_transport", "fabric_EthEstc_type", "fabric_EthFlowMonLan_exporterSourceMac", "fabric_EthFlowMonLan_id", "fabric_EthFlowMonLan_locale", "fabric_EthFlowMonLan_name", "fabric_EthFlowMonLan_transport", "fabric_EthFlowMonLan_type", "fabric_EthFlowMonSrcRef_id", "fabric_EthFlowMonSrcRef_protocol", "fabric_EthFlowMonSrcRef_sourceDn", "fabric_EthFlowMonSrcRef_sourceType", "fabric_EthFlowMonSrcRef_type", "fabric_EthLanEp_adminSpeed", "fabric_EthLanEp_adminState", "fabric_EthLanEp_chassisId", "fabric_EthLanEp_epDn", "fabric_EthLanEp_ethLinkProfileName", "fabric_EthLanEp_flowCtrlPolicy", "fabric_EthLanEp_fltAggr", "fabric_EthLanEp_ifRole", "fabric_EthLanEp_ifType", "fabric_EthLanEp_licGP", "fabric_EthLanEp_licState", "fabric_EthLanEp_locale", "fabric_EthLanEp_name", "fabric_EthLanEp_operEthLinkProfileName", "fabric_EthLanEp_operState", "fabric_EthLanEp_operStateReason", "fabric_EthLanEp_overlappingVlans", "fabric_EthLanEp_peerChassisId", "fabric_EthLanEp_peerDn", "fabric_EthLanEp_peerPortId", "fabric_EthLanEp_peerSlotId", "fabric_EthLanEp_portId", "fabric_EthLanEp_slotId", "fabric_EthLanEp_switchId", "fabric_EthLanEp_transport", "fabric_EthLanEp_type", "fabric_EthLanEp_udldOperState", "fabric_EthLanEp_usrLbl", "fabric_EthLanEp_vlanStatus", "fabric_EthLanEp_warnings", "fabric_EthLanFlowMonCollector_descr", "fabric_EthLanFlowMonCollector_flowProtocol", "fabric_EthLanFlowMonCollector_id", "fabric_EthLanFlowMonCollector_locale", "fabric_EthLanFlowMonCollector_name", "fabric_EthLanFlowMonCollector_port", "fabric_EthLanFlowMonCollector_transport", "fabric_EthLanFlowMonCollector_type", "fabric_EthLanFlowMonExporter_descr", "fabric_EthLanFlowMonExporter_dscp", "fabric_EthLanFlowMonExporter_flowExpProfile", "fabric_EthLanFlowMonExporter_flowMonCollector", "fabric_EthLanFlowMonExporter_intId", "fabric_EthLanFlowMonExporter_name", "fabric_EthLanFlowMonExporter_operFlowExpProfile", "fabric_EthLanFlowMonExporter_policyLevel", "fabric_EthLanFlowMonExporter_policyOwner", "fabric_EthLanFlowMonExporter_protocol", "fabric_EthLanFlowMonExporter_transport", "fabric_EthLanFlowMonExporter_type", "fabric_EthLanFlowMonSrcEp_name", "fabric_EthLanFlowMonSrcEp_protocol", "fabric_EthLanFlowMonSrcEp_session", "fabric_EthLanFlowMonSrcEp_transport", "fabric_EthLanFlowMonSrcEp_type", "fabric_EthLanFlowMon_adminState", "fabric_EthLanFlowMon_configFailReason", "fabric_EthLanFlowMon_configQualifier", "fabric_EthLanFlowMon_descr", "fabric_EthLanFlowMon_id", "fabric_EthLanFlowMon_isConfigSuccess", "fabric_EthLanFlowMon_locale", "fabric_EthLanFlowMon_name", "fabric_EthLanFlowMon_protocol", "fabric_EthLanFlowMon_session", "fabric_EthLanFlowMon_transport", "fabric_EthLanFlowMon_type", "fabric_EthLanFlowMonitor_descr", "fabric_EthLanFlowMonitor_flowMonProtocol", "fabric_EthLanFlowMonitor_flowMonRecordDef", "fabric_EthLanFlowMonitor_flowTimeoutPolicy", "fabric_EthLanFlowMonitor_intId", "fabric_EthLanFlowMonitor_name", "fabric_EthLanFlowMonitor_operFlowMonRecordDef", "fabric_EthLanFlowMonitor_operFlowTimeoutPolicy", "fabric_EthLanFlowMonitor_policyLevel", "fabric_EthLanFlowMonitor_policyOwner", "fabric_EthLanFlowMonitor_transport", "fabric_EthLanFlowMonitor_type", "fabric_EthLanFlowMonitoring_adminState", "fabric_EthLanFlowMonitoring_type", "fabric_EthLanPcEp_adminState", "fabric_EthLanPcEp_chassisId", "fabric_EthLanPcEp_epDn", "fabric_EthLanPcEp_ethLinkProfileName", "fabric_EthLanPcEp_fltAggr", "fabric_EthLanPcEp_ifRole", "fabric_EthLanPcEp_ifType", "fabric_EthLanPcEp_licGP", "fabric_EthLanPcEp_licState", "fabric_EthLanPcEp_locale", "fabric_EthLanPcEp_membership", "fabric_EthLanPcEp_name", "fabric_EthLanPcEp_operEthLinkProfileName", "fabric_EthLanPcEp_operState", "fabric_EthLanPcEp_operStateReason", "fabric_EthLanPcEp_peerChassisId", "fabric_EthLanPcEp_peerDn", "fabric_EthLanPcEp_peerPortId", "fabric_EthLanPcEp_peerSlotId", "fabric_EthLanPcEp_portId", "fabric_EthLanPcEp_slotId", "fabric_EthLanPcEp_switchId", "fabric_EthLanPcEp_transport", "fabric_EthLanPcEp_type", "fabric_EthLanPcEp_udldOperState", "fabric_EthLanPcEp_warnings", "fabric_EthLanPc_adminSpeed", "fabric_EthLanPc_adminState", "fabric_EthLanPc_bandwidth", "fabric_EthLanPc_descr", "fabric_EthLanPc_epDn", "fabric_EthLanPc_flowCtrlPolicy", "fabric_EthLanPc_fltAggr", "fabric_EthLanPc_ifRole", "fabric_EthLanPc_ifType", "fabric_EthLanPc_locale", "fabric_EthLanPc_name", "fabric_EthLanPc_operSpeed", "fabric_EthLanPc_operState", "fabric_EthLanPc_overlappingVlans", "fabric_EthLanPc_peerDn", "fabric_EthLanPc_portId", "fabric_EthLanPc_stateQual", "fabric_EthLanPc_switchId", "fabric_EthLanPc_transport", "fabric_EthLanPc_type", "fabric_EthLanPc_vlanStatus", "fabric_EthLanPc_warnings", "fabric_EthLan_id", "fabric_EthLan_locale", "fabric_EthLan_name", "fabric_EthLan_transport", "fabric_EthLan_type", "fabric_EthLinkPolicy_descr", "fabric_EthLinkPolicy_intId", "fabric_EthLinkPolicy_name", "fabric_EthLinkPolicy_policyLevel", "fabric_EthLinkPolicy_policyOwner", "fabric_EthLinkPolicy_protocol", "fabric_EthLinkPolicy_type", "fabric_EthLinkProfile_cdpLinkPolicyName", "fabric_EthLinkProfile_descr", "fabric_EthLinkProfile_intId", "fabric_EthLinkProfile_name", "fabric_EthLinkProfile_operCdpLinkPolicyName", "fabric_EthLinkProfile_operUdldLinkPolicyName", "fabric_EthLinkProfile_policyLevel", "fabric_EthLinkProfile_policyOwner", "fabric_EthLinkProfile_udldLinkPolicyName", "fabric_EthMonDestEp_adminSpeed", "fabric_EthMonDestEp_adminState", "fabric_EthMonDestEp_chassisId", "fabric_EthMonDestEp_epDn", "fabric_EthMonDestEp_fltAggr", "fabric_EthMonDestEp_ifRole", "fabric_EthMonDestEp_ifType", "fabric_EthMonDestEp_licGP", "fabric_EthMonDestEp_licState", "fabric_EthMonDestEp_locale", "fabric_EthMonDestEp_name", "fabric_EthMonDestEp_operState", "fabric_EthMonDestEp_operStateReason", "fabric_EthMonDestEp_peerChassisId", "fabric_EthMonDestEp_peerDn", "fabric_EthMonDestEp_peerPortId", "fabric_EthMonDestEp_peerSlotId", "fabric_EthMonDestEp_portId", "fabric_EthMonDestEp_slotId", "fabric_EthMonDestEp_switchId", "fabric_EthMonDestEp_transport", "fabric_EthMonDestEp_type", "fabric_EthMonDestEp_warnings", "fabric_EthMonFiltEp_name", "fabric_EthMonFiltEp_session", "fabric_EthMonFiltEp_type", "fabric_EthMonFiltRef_srcFiltDn", "fabric_EthMonFiltRef_type", "fabric_EthMonLan_id", "fabric_EthMonLan_locale", "fabric_EthMonLan_name", "fabric_EthMonLan_transport", "fabric_EthMonLan_type", "fabric_EthMonSrcEp_direction", "fabric_EthMonSrcEp_name", "fabric_EthMonSrcEp_session", "fabric_EthMonSrcEp_transport", "fabric_EthMonSrcEp_type", "fabric_EthMonSrcRef_id", "fabric_EthMonSrcRef_sourceDn", "fabric_EthMonSrcRef_sourceType", "fabric_EthMonSrcRef_type", "fabric_EthMon_adminState", "fabric_EthMon_configFailReason", "fabric_EthMon_id", "fabric_EthMon_isConfigSuccess", "fabric_EthMon_locale", "fabric_EthMon_name", "fabric_EthMon_operState", "fabric_EthMon_operStateReason", "fabric_EthMon_peerDn", "fabric_EthMon_session", "fabric_EthMon_transport", "fabric_EthMon_type", "fabric_EthTargetEp_adminState", "fabric_EthTargetEp_chassisId", "fabric_EthTargetEp_epDn", "fabric_EthTargetEp_fltAggr", "fabric_EthTargetEp_ifRole", "fabric_EthTargetEp_ifType", "fabric_EthTargetEp_licGP", "fabric_EthTargetEp_licState", "fabric_EthTargetEp_locale", "fabric_EthTargetEp_macAddress", "fabric_EthTargetEp_name", "fabric_EthTargetEp_operState", "fabric_EthTargetEp_operStateReason", "fabric_EthTargetEp_peerChassisId", "fabric_EthTargetEp_peerDn", "fabric_EthTargetEp_peerPortId", "fabric_EthTargetEp_peerSlotId", "fabric_EthTargetEp_portId", "fabric_EthTargetEp_slotId", "fabric_EthTargetEp_switchId", "fabric_EthTargetEp_transport", "fabric_EthTargetEp_type", "fabric_EthTargetEp_warnings", "fabric_EthUdldPolicy_descr", "fabric_EthUdldPolicy_intId", "fabric_EthUdldPolicy_name", "fabric_EthUdldPolicy_policyLevel", "fabric_EthUdldPolicy_policyOwner", "fabric_EthUdldPolicy_protocol", "fabric_EthUdldPolicy_type", "fabric_EthVlanPc_adminSpeed", "fabric_EthVlanPc_adminState", "fabric_EthVlanPc_descr", "fabric_EthVlanPc_epDn", "fabric_EthVlanPc_fltAggr", "fabric_EthVlanPc_ifRole", "fabric_EthVlanPc_ifType", "fabric_EthVlanPc_isNative", "fabric_EthVlanPc_locale", "fabric_EthVlanPc_name", "fabric_EthVlanPc_operSpeed", "fabric_EthVlanPc_operState", "fabric_EthVlanPc_peerDn", "fabric_EthVlanPc_portId", "fabric_EthVlanPc_stateQual", "fabric_EthVlanPc_switchId", "fabric_EthVlanPc_transport", "fabric_EthVlanPc_type", "fabric_EthVlanPc_warnings", "fabric_EthVlanPortEp_adminState", "fabric_EthVlanPortEp_chassisId", "fabric_EthVlanPortEp_epDn", "fabric_EthVlanPortEp_fltAggr", "fabric_EthVlanPortEp_ifRole", "fabric_EthVlanPortEp_ifType", "fabric_EthVlanPortEp_isNative", "fabric_EthVlanPortEp_licGP", "fabric_EthVlanPortEp_licState", "fabric_EthVlanPortEp_locale", "fabric_EthVlanPortEp_name", "fabric_EthVlanPortEp_operState", "fabric_EthVlanPortEp_operStateReason", "fabric_EthVlanPortEp_peerChassisId", "fabric_EthVlanPortEp_peerDn", "fabric_EthVlanPortEp_peerPortId", "fabric_EthVlanPortEp_peerSlotId", "fabric_EthVlanPortEp_portId", "fabric_EthVlanPortEp_slotId", "fabric_EthVlanPortEp_switchId", "fabric_EthVlanPortEp_transport", "fabric_EthVlanPortEp_type", "fabric_EthVlanPortEp_warnings", "fabric_ExternalEp_adminState", "fabric_ExternalEp_chassisId", "fabric_ExternalEp_epDn", "fabric_ExternalEp_fltAggr", "fabric_ExternalEp_ifRole", "fabric_ExternalEp_ifType", "fabric_ExternalEp_licGP", "fabric_ExternalEp_licState", "fabric_ExternalEp_locale", "fabric_ExternalEp_name", "fabric_ExternalEp_operState", "fabric_ExternalEp_operStateReason", "fabric_ExternalEp_peerChassisId", "fabric_ExternalEp_peerDn", "fabric_ExternalEp_peerPortId", "fabric_ExternalEp_peerSlotId", "fabric_ExternalEp_portId", "fabric_ExternalEp_slotId", "fabric_ExternalEp_switchId", "fabric_ExternalEp_transport", "fabric_ExternalEp_type", "fabric_ExternalEp_warnings", "fabric_ExternalEstc_id", "fabric_ExternalEstc_locale", "fabric_ExternalEstc_name", "fabric_ExternalEstc_transport", "fabric_ExternalEstc_type", "fabric_ExternalPc_adminState", "fabric_ExternalPc_descr", "fabric_ExternalPc_epDn", "fabric_ExternalPc_fltAggr", "fabric_ExternalPc_ifRole", "fabric_ExternalPc_ifType", "fabric_ExternalPc_locale", "fabric_ExternalPc_name", "fabric_ExternalPc_operState", "fabric_ExternalPc_peerDn", "fabric_ExternalPc_portId", "fabric_ExternalPc_stateQual", "fabric_ExternalPc_switchId", "fabric_ExternalPc_transport", "fabric_ExternalPc_type", "fabric_ExternalPc_warnings", "fabric_External_id", "fabric_External_locale", "fabric_External_name", "fabric_External_transport", "fabric_External_type", "fabric_FcEstcEp_adminState", "fabric_FcEstcEp_chassisId", "fabric_FcEstcEp_configState", "fabric_FcEstcEp_epDn", "fabric_FcEstcEp_fillPattern", "fabric_FcEstcEp_fltAggr", "fabric_FcEstcEp_ifRole", "fabric_FcEstcEp_ifType", "fabric_FcEstcEp_licGP", "fabric_FcEstcEp_licState", "fabric_FcEstcEp_locale", "fabric_FcEstcEp_name", "fabric_FcEstcEp_operState", "fabric_FcEstcEp_operStateReason", "fabric_FcEstcEp_peerChassisId", "fabric_FcEstcEp_peerDn", "fabric_FcEstcEp_peerPortId", "fabric_FcEstcEp_peerSlotId", "fabric_FcEstcEp_portId", "fabric_FcEstcEp_slotId", "fabric_FcEstcEp_switchId", "fabric_FcEstcEp_transport", "fabric_FcEstcEp_type", "fabric_FcEstcEp_usrLbl", "fabric_FcEstcEp_warnings", "fabric_FcEstc_id", "fabric_FcEstc_locale", "fabric_FcEstc_name", "fabric_FcEstc_transport", "fabric_FcEstc_type", "fabric_FcMonDestEp_adminSpeed", "fabric_FcMonDestEp_adminState", "fabric_FcMonDestEp_chassisId", "fabric_FcMonDestEp_epDn", "fabric_FcMonDestEp_fltAggr", "fabric_FcMonDestEp_ifRole", "fabric_FcMonDestEp_ifType", "fabric_FcMonDestEp_licGP", "fabric_FcMonDestEp_licState", "fabric_FcMonDestEp_locale", "fabric_FcMonDestEp_name", "fabric_FcMonDestEp_operState", "fabric_FcMonDestEp_operStateReason", "fabric_FcMonDestEp_peerChassisId", "fabric_FcMonDestEp_peerDn", "fabric_FcMonDestEp_peerPortId", "fabric_FcMonDestEp_peerSlotId", "fabric_FcMonDestEp_portId", "fabric_FcMonDestEp_slotId", "fabric_FcMonDestEp_switchId", "fabric_FcMonDestEp_transport", "fabric_FcMonDestEp_type", "fabric_FcMonDestEp_warnings", "fabric_FcMonFiltEp_name", "fabric_FcMonFiltEp_session", "fabric_FcMonFiltEp_type", "fabric_FcMonFiltRef_srcFiltDn", "fabric_FcMonFiltRef_type", "fabric_FcMonSan_id", "fabric_FcMonSan_locale", "fabric_FcMonSan_name", "fabric_FcMonSan_transport", "fabric_FcMonSan_type", "fabric_FcMonSrcEp_direction", "fabric_FcMonSrcEp_name", "fabric_FcMonSrcEp_session", "fabric_FcMonSrcEp_transport", "fabric_FcMonSrcEp_type", "fabric_FcMonSrcRef_id", "fabric_FcMonSrcRef_sourceDn", "fabric_FcMonSrcRef_sourceType", "fabric_FcMonSrcRef_type", "fabric_FcMon_adminState", "fabric_FcMon_configFailReason", "fabric_FcMon_id", "fabric_FcMon_isConfigSuccess", "fabric_FcMon_locale", "fabric_FcMon_name", "fabric_FcMon_operState", "fabric_FcMon_operStateReason", "fabric_FcMon_peerDn", "fabric_FcMon_session", "fabric_FcMon_transport", "fabric_FcMon_type", "fabric_FcSanEp_adminState", "fabric_FcSanEp_chassisId", "fabric_FcSanEp_epDn", "fabric_FcSanEp_fillPattern", "fabric_FcSanEp_fltAggr", "fabric_FcSanEp_ifRole", "fabric_FcSanEp_ifType", "fabric_FcSanEp_licGP", "fabric_FcSanEp_licState", "fabric_FcSanEp_locale", "fabric_FcSanEp_name", "fabric_FcSanEp_operState", "fabric_FcSanEp_operStateReason", "fabric_FcSanEp_peerChassisId", "fabric_FcSanEp_peerDn", "fabric_FcSanEp_peerPortId", "fabric_FcSanEp_peerSlotId", "fabric_FcSanEp_portId", "fabric_FcSanEp_slotId", "fabric_FcSanEp_switchId", "fabric_FcSanEp_transport", "fabric_FcSanEp_type", "fabric_FcSanEp_usrLbl", "fabric_FcSanEp_warnings", "fabric_FcSanPcEp_adminSpeed", "fabric_FcSanPcEp_adminState", "fabric_FcSanPcEp_chassisId", "fabric_FcSanPcEp_epDn", "fabric_FcSanPcEp_fltAggr", "fabric_FcSanPcEp_ifRole", "fabric_FcSanPcEp_ifType", "fabric_FcSanPcEp_licGP", "fabric_FcSanPcEp_licState", "fabric_FcSanPcEp_locale", "fabric_FcSanPcEp_membership", "fabric_FcSanPcEp_name", "fabric_FcSanPcEp_operState", "fabric_FcSanPcEp_operStateReason", "fabric_FcSanPcEp_peerChassisId", "fabric_FcSanPcEp_peerDn", "fabric_FcSanPcEp_peerPortId", "fabric_FcSanPcEp_peerSlotId", "fabric_FcSanPcEp_portId", "fabric_FcSanPcEp_slotId", "fabric_FcSanPcEp_switchId", "fabric_FcSanPcEp_transport", "fabric_FcSanPcEp_type", "fabric_FcSanPcEp_warnings", "fabric_FcSanPc_adminSpeed", "fabric_FcSanPc_adminState", "fabric_FcSanPc_configState", "fabric_FcSanPc_configStatus", "fabric_FcSanPc_descr", "fabric_FcSanPc_epDn", "fabric_FcSanPc_fltAggr", "fabric_FcSanPc_ifRole", "fabric_FcSanPc_ifType", "fabric_FcSanPc_locale", "fabric_FcSanPc_name", "fabric_FcSanPc_operSpeed", "fabric_FcSanPc_operState", "fabric_FcSanPc_peerDn", "fabric_FcSanPc_portId", "fabric_FcSanPc_stateQual", "fabric_FcSanPc_switchId", "fabric_FcSanPc_transport", "fabric_FcSanPc_type", "fabric_FcSanPc_warnings", "fabric_FcSan_id", "fabric_FcSan_locale", "fabric_FcSan_name", "fabric_FcSan_transport", "fabric_FcSan_type", "fabric_FcSan_uplinkTrunking", "fabric_FcVsanPc_adminState", "fabric_FcVsanPc_descr", "fabric_FcVsanPc_epDn", "fabric_FcVsanPc_fltAggr", "fabric_FcVsanPc_ifRole", "fabric_FcVsanPc_ifType", "fabric_FcVsanPc_locale", "fabric_FcVsanPc_name", "fabric_FcVsanPc_operState", "fabric_FcVsanPc_peerDn", "fabric_FcVsanPc_portId", "fabric_FcVsanPc_stateQual", "fabric_FcVsanPc_switchId", "fabric_FcVsanPc_transport", "fabric_FcVsanPc_type", "fabric_FcVsanPc_warnings", "fabric_FcVsanPortEp_adminState", "fabric_FcVsanPortEp_chassisId", "fabric_FcVsanPortEp_epDn", "fabric_FcVsanPortEp_fltAggr", "fabric_FcVsanPortEp_ifRole", "fabric_FcVsanPortEp_ifType", "fabric_FcVsanPortEp_licGP", "fabric_FcVsanPortEp_licState", "fabric_FcVsanPortEp_locale", "fabric_FcVsanPortEp_name", "fabric_FcVsanPortEp_operState", "fabric_FcVsanPortEp_operStateReason", "fabric_FcVsanPortEp_peerChassisId", "fabric_FcVsanPortEp_peerDn", "fabric_FcVsanPortEp_peerPortId", "fabric_FcVsanPortEp_peerSlotId", "fabric_FcVsanPortEp_portId", "fabric_FcVsanPortEp_slotId", "fabric_FcVsanPortEp_switchId", "fabric_FcVsanPortEp_transport", "fabric_FcVsanPortEp_type", "fabric_FcVsanPortEp_warnings", "fabric_FcoeEstcEp_adminState", "fabric_FcoeEstcEp_chassisId", "fabric_FcoeEstcEp_configState", "fabric_FcoeEstcEp_epDn", "fabric_FcoeEstcEp_fcoeState", "fabric_FcoeEstcEp_fcoeStateReason", "fabric_FcoeEstcEp_fltAggr", "fabric_FcoeEstcEp_ifRole", "fabric_FcoeEstcEp_ifType", "fabric_FcoeEstcEp_licGP", "fabric_FcoeEstcEp_licState", "fabric_FcoeEstcEp_locale", "fabric_FcoeEstcEp_name", "fabric_FcoeEstcEp_operState", "fabric_FcoeEstcEp_operStateReason", "fabric_FcoeEstcEp_peerChassisId", "fabric_FcoeEstcEp_peerDn", "fabric_FcoeEstcEp_peerPortId", "fabric_FcoeEstcEp_peerSlotId", "fabric_FcoeEstcEp_portId", "fabric_FcoeEstcEp_slotId", "fabric_FcoeEstcEp_switchId", "fabric_FcoeEstcEp_transport", "fabric_FcoeEstcEp_type", "fabric_FcoeEstcEp_usrLbl", "fabric_FcoeEstcEp_warnings", "fabric_FcoeSanEp_adminState", "fabric_FcoeSanEp_chassisId", "fabric_FcoeSanEp_configState", "fabric_FcoeSanEp_epDn", "fabric_FcoeSanEp_ethLinkProfileName", "fabric_FcoeSanEp_fcoeState", "fabric_FcoeSanEp_fcoeStateReason", "fabric_FcoeSanEp_fltAggr", "fabric_FcoeSanEp_ifRole", "fabric_FcoeSanEp_ifType", "fabric_FcoeSanEp_licGP", "fabric_FcoeSanEp_licState", "fabric_FcoeSanEp_locale", "fabric_FcoeSanEp_name", "fabric_FcoeSanEp_operEthLinkProfileName", "fabric_FcoeSanEp_operState", "fabric_FcoeSanEp_operStateReason", "fabric_FcoeSanEp_peerChassisId", "fabric_FcoeSanEp_peerDn", "fabric_FcoeSanEp_peerPortId", "fabric_FcoeSanEp_peerSlotId", "fabric_FcoeSanEp_portId", "fabric_FcoeSanEp_slotId", "fabric_FcoeSanEp_switchId", "fabric_FcoeSanEp_transport", "fabric_FcoeSanEp_type", "fabric_FcoeSanEp_udldOperState", "fabric_FcoeSanEp_usrLbl", "fabric_FcoeSanEp_warnings", "fabric_FcoeSanPcEp_adminState", "fabric_FcoeSanPcEp_chassisId", "fabric_FcoeSanPcEp_epDn", "fabric_FcoeSanPcEp_ethLinkProfileName", "fabric_FcoeSanPcEp_fltAggr", "fabric_FcoeSanPcEp_ifRole", "fabric_FcoeSanPcEp_ifType", "fabric_FcoeSanPcEp_licGP", "fabric_FcoeSanPcEp_licState", "fabric_FcoeSanPcEp_locale", "fabric_FcoeSanPcEp_membership", "fabric_FcoeSanPcEp_name", "fabric_FcoeSanPcEp_operEthLinkProfileName", "fabric_FcoeSanPcEp_operState", "fabric_FcoeSanPcEp_operStateReason", "fabric_FcoeSanPcEp_peerChassisId", "fabric_FcoeSanPcEp_peerDn", "fabric_FcoeSanPcEp_peerPortId", "fabric_FcoeSanPcEp_peerSlotId", "fabric_FcoeSanPcEp_portId", "fabric_FcoeSanPcEp_slotId", "fabric_FcoeSanPcEp_switchId", "fabric_FcoeSanPcEp_transport", "fabric_FcoeSanPcEp_type", "fabric_FcoeSanPcEp_udldOperState", "fabric_FcoeSanPcEp_warnings", "fabric_FcoeSanPc_adminState", "fabric_FcoeSanPc_configState", "fabric_FcoeSanPc_descr", "fabric_FcoeSanPc_epDn", "fabric_FcoeSanPc_fcoeState", "fabric_FcoeSanPc_fcoeStateReason", "fabric_FcoeSanPc_fltAggr", "fabric_FcoeSanPc_ifRole", "fabric_FcoeSanPc_ifType", "fabric_FcoeSanPc_locale", "fabric_FcoeSanPc_name", "fabric_FcoeSanPc_operState", "fabric_FcoeSanPc_peerDn", "fabric_FcoeSanPc_portId", "fabric_FcoeSanPc_stateQual", "fabric_FcoeSanPc_switchId", "fabric_FcoeSanPc_transport", "fabric_FcoeSanPc_type", "fabric_FcoeSanPc_warnings", "fabric_FcoeVsanPc_adminState", "fabric_FcoeVsanPc_descr", "fabric_FcoeVsanPc_epDn", "fabric_FcoeVsanPc_fltAggr", "fabric_FcoeVsanPc_ifRole", "fabric_FcoeVsanPc_ifType", "fabric_FcoeVsanPc_locale", "fabric_FcoeVsanPc_name", "fabric_FcoeVsanPc_operState", "fabric_FcoeVsanPc_peerDn", "fabric_FcoeVsanPc_portId", "fabric_FcoeVsanPc_stateQual", "fabric_FcoeVsanPc_switchId", "fabric_FcoeVsanPc_transport", "fabric_FcoeVsanPc_type", "fabric_FcoeVsanPc_warnings", "fabric_FcoeVsanPortEp_adminState", "fabric_FcoeVsanPortEp_chassisId", "fabric_FcoeVsanPortEp_epDn", "fabric_FcoeVsanPortEp_fltAggr", "fabric_FcoeVsanPortEp_ifRole", "fabric_FcoeVsanPortEp_ifType", "fabric_FcoeVsanPortEp_licGP", "fabric_FcoeVsanPortEp_licState", "fabric_FcoeVsanPortEp_locale", "fabric_FcoeVsanPortEp_name", "fabric_FcoeVsanPortEp_operState", "fabric_FcoeVsanPortEp_operStateReason", "fabric_FcoeVsanPortEp_peerChassisId", "fabric_FcoeVsanPortEp_peerDn", "fabric_FcoeVsanPortEp_peerPortId", "fabric_FcoeVsanPortEp_peerSlotId", "fabric_FcoeVsanPortEp_portId", "fabric_FcoeVsanPortEp_slotId", "fabric_FcoeVsanPortEp_switchId", "fabric_FcoeVsanPortEp_transport", "fabric_FcoeVsanPortEp_type", "fabric_FcoeVsanPortEp_warnings", "fabric_FlowMonCollector_descr", "fabric_FlowMonCollector_flowProtocol", "fabric_FlowMonCollector_id", "fabric_FlowMonCollector_locale", "fabric_FlowMonCollector_name", "fabric_FlowMonCollector_transport", "fabric_FlowMonCollector_type", "fabric_FlowMonDefinition_descr", "fabric_FlowMonDefinition_intId", "fabric_FlowMonDefinition_ipv4keys", "fabric_FlowMonDefinition_ipv6keys", "fabric_FlowMonDefinition_keyType", "fabric_FlowMonDefinition_l2keys", "fabric_FlowMonDefinition_name", "fabric_FlowMonDefinition_nonkeys", "fabric_FlowMonDefinition_policyLevel", "fabric_FlowMonDefinition_policyOwner", "fabric_FlowMonDefinition_recordType", "fabric_FlowMonExporterProfile_descr", "fabric_FlowMonExporterProfile_intId", "fabric_FlowMonExporterProfile_name", "fabric_FlowMonExporterProfile_policyLevel", "fabric_FlowMonExporterProfile_policyOwner", "fabric_FlowMonExporter_descr", "fabric_FlowMonExporter_dscp", "fabric_FlowMonExporter_flowExpProfile", "fabric_FlowMonExporter_flowMonCollector", "fabric_FlowMonExporter_intId", "fabric_FlowMonExporter_name", "fabric_FlowMonExporter_operFlowExpProfile", "fabric_FlowMonExporter_policyLevel", "fabric_FlowMonExporter_policyOwner", "fabric_FlowMonExporter_protocol", "fabric_FlowMonExporter_transport", "fabric_FlowMonExporter_type", "fabric_FlowMonSrcEp_name", "fabric_FlowMonSrcEp_protocol", "fabric_FlowMonSrcEp_session", "fabric_FlowMonSrcEp_transport", "fabric_FlowMonSrcEp_type", "fabric_FlowMonSrcRef_id", "fabric_FlowMonSrcRef_protocol", "fabric_FlowMonSrcRef_sourceDn", "fabric_FlowMonSrcRef_type", "fabric_FlowMon_adminState", "fabric_FlowMon_configFailReason", "fabric_FlowMon_configQualifier", "fabric_FlowMon_descr", "fabric_FlowMon_id", "fabric_FlowMon_isConfigSuccess", "fabric_FlowMon_locale", "fabric_FlowMon_name", "fabric_FlowMon_protocol", "fabric_FlowMon_session", "fabric_FlowMon_transport", "fabric_FlowMon_type", "fabric_FlowMonitor_descr", "fabric_FlowMonitor_flowMonProtocol", "fabric_FlowMonitor_flowMonRecordDef", "fabric_FlowMonitor_flowTimeoutPolicy", "fabric_FlowMonitor_intId", "fabric_FlowMonitor_name", "fabric_FlowMonitor_operFlowMonRecordDef", "fabric_FlowMonitor_operFlowTimeoutPolicy", "fabric_FlowMonitor_policyLevel", "fabric_FlowMonitor_policyOwner", "fabric_FlowMonitor_transport", "fabric_FlowMonitor_type", "fabric_FlowMonitoringCategory_adminState", "fabric_FlowMonitoringCategory_type", "fabric_If_addr", "fabric_If_id", "fabric_InternalDceSrv_id", "fabric_InternalDceSrv_locale", "fabric_InternalDceSrv_name", "fabric_InternalDceSrv_transport", "fabric_InternalDceSrv_type", "fabric_InternalEp_adminState", "fabric_InternalEp_chassisId", "fabric_InternalEp_epDn", "fabric_InternalEp_fltAggr", "fabric_InternalEp_ifRole", "fabric_InternalEp_ifType", "fabric_InternalEp_licGP", "fabric_InternalEp_licState", "fabric_InternalEp_locale", "fabric_InternalEp_name", "fabric_InternalEp_operState", "fabric_InternalEp_operStateReason", "fabric_InternalEp_peerChassisId", "fabric_InternalEp_peerDn", "fabric_InternalEp_peerPortId", "fabric_InternalEp_peerSlotId", "fabric_InternalEp_portId", "fabric_InternalEp_slotId", "fabric_InternalEp_switchId", "fabric_InternalEp_transport", "fabric_InternalEp_type", "fabric_InternalPc_adminState", "fabric_InternalPc_descr", "fabric_InternalPc_epDn", "fabric_InternalPc_fltAggr", "fabric_InternalPc_ifRole", "fabric_InternalPc_ifType", "fabric_InternalPc_locale", "fabric_InternalPc_name", "fabric_InternalPc_operState", "fabric_InternalPc_peerDn", "fabric_InternalPc_portId", "fabric_InternalPc_stateQual", "fabric_InternalPc_switchId", "fabric_InternalPc_transport", "fabric_InternalPc_type", "fabric_Internal_id", "fabric_Internal_locale", "fabric_Internal_name", "fabric_Internal_transport", "fabric_Internal_type", "fabric_LanCloudFsmStage_descr", "fabric_LanCloudFsmStage_lastUpdateTime", "fabric_LanCloudFsmStage_name", "fabric_LanCloudFsmStage_order", "fabric_LanCloudFsmStage_retry", "fabric_LanCloudFsmStage_stageStatus", "fabric_LanCloudFsmTask_completion", "fabric_LanCloudFsmTask_flags", "fabric_LanCloudFsmTask_item", "fabric_LanCloudFsmTask_seqId", "fabric_LanCloudFsm_completionTime", "fabric_LanCloudFsm_currentFsm", "fabric_LanCloudFsm_descr", "fabric_LanCloudFsm_fsmStatus", "fabric_LanCloudFsm_instanceId", "fabric_LanCloudFsm_progress", "fabric_LanCloudFsm_rmtErrCode", "fabric_LanCloudFsm_rmtErrDescr", "fabric_LanCloudFsm_rmtRslt", "fabric_LanCloud_fsmDescr", "fabric_LanCloud_fsmPrev", "fabric_LanCloud_fsmProgr", "fabric_LanCloud_fsmRmtInvErrCode", "fabric_LanCloud_fsmRmtInvErrDescr", "fabric_LanCloud_fsmRmtInvRslt", "fabric_LanCloud_fsmStageDescr", "fabric_LanCloud_fsmStamp", "fabric_LanCloud_fsmStatus", "fabric_LanCloud_fsmTry", "fabric_LanCloud_macAging", "fabric_LanCloud_mode", "fabric_LanCloud_vlanCompression", "fabric_LanEp_adminState", "fabric_LanEp_chassisId", "fabric_LanEp_epDn", "fabric_LanEp_fltAggr", "fabric_LanEp_ifRole", "fabric_LanEp_ifType", "fabric_LanEp_licGP", "fabric_LanEp_licState", "fabric_LanEp_locale", "fabric_LanEp_name", "fabric_LanEp_operState", "fabric_LanEp_operStateReason", "fabric_LanEp_peerChassisId", "fabric_LanEp_peerDn", "fabric_LanEp_peerPortId", "fabric_LanEp_peerSlotId", "fabric_LanEp_portId", "fabric_LanEp_slotId", "fabric_LanEp_switchId", "fabric_LanEp_transport", "fabric_LanEp_type", "fabric_LanEp_warnings", "fabric_LanFlowMonCollector_descr", "fabric_LanFlowMonCollector_flowProtocol", "fabric_LanFlowMonCollector_id", "fabric_LanFlowMonCollector_locale", "fabric_LanFlowMonCollector_name", "fabric_LanFlowMonCollector_transport", "fabric_LanFlowMonCollector_type", "fabric_LanFlowMonExporter_descr", "fabric_LanFlowMonExporter_dscp", "fabric_LanFlowMonExporter_flowExpProfile", "fabric_LanFlowMonExporter_flowMonCollector", "fabric_LanFlowMonExporter_intId", "fabric_LanFlowMonExporter_name", "fabric_LanFlowMonExporter_operFlowExpProfile", "fabric_LanFlowMonExporter_policyLevel", "fabric_LanFlowMonExporter_policyOwner", "fabric_LanFlowMonExporter_protocol", "fabric_LanFlowMonExporter_transport", "fabric_LanFlowMonExporter_type", "fabric_LanFlowMonSrcEp_name", "fabric_LanFlowMonSrcEp_protocol", "fabric_LanFlowMonSrcEp_session", "fabric_LanFlowMonSrcEp_transport", "fabric_LanFlowMonSrcEp_type", "fabric_LanFlowMon_adminState", "fabric_LanFlowMon_configFailReason", "fabric_LanFlowMon_configQualifier", "fabric_LanFlowMon_descr", "fabric_LanFlowMon_id", "fabric_LanFlowMon_isConfigSuccess", "fabric_LanFlowMon_locale", "fabric_LanFlowMon_name", "fabric_LanFlowMon_protocol", "fabric_LanFlowMon_session", "fabric_LanFlowMon_transport", "fabric_LanFlowMon_type", "fabric_LanFlowMonitor_descr", "fabric_LanFlowMonitor_flowMonProtocol", "fabric_LanFlowMonitor_flowMonRecordDef", "fabric_LanFlowMonitor_flowTimeoutPolicy", "fabric_LanFlowMonitor_intId", "fabric_LanFlowMonitor_name", "fabric_LanFlowMonitor_operFlowMonRecordDef", "fabric_LanFlowMonitor_operFlowTimeoutPolicy", "fabric_LanFlowMonitor_policyLevel", "fabric_LanFlowMonitor_policyOwner", "fabric_LanFlowMonitor_transport", "fabric_LanFlowMonitor_type", "fabric_LanMonCloud_mode", "fabric_LanPc_adminSpeed", "fabric_LanPc_adminState", "fabric_LanPc_descr", "fabric_LanPc_epDn", "fabric_LanPc_flowCtrlPolicy", "fabric_LanPc_fltAggr", "fabric_LanPc_ifRole", "fabric_LanPc_ifType", "fabric_LanPc_locale", "fabric_LanPc_name", "fabric_LanPc_operSpeed", "fabric_LanPc_operState", "fabric_LanPc_peerDn", "fabric_LanPc_portId", "fabric_LanPc_stateQual", "fabric_LanPc_switchId", "fabric_LanPc_transport", "fabric_LanPc_type", "fabric_LanPc_warnings", "fabric_LanPinGroup_descr", "fabric_LanPinGroup_intId", "fabric_LanPinGroup_name", "fabric_LanPinGroup_policyLevel", "fabric_LanPinGroup_policyOwner", "fabric_LanPinGroup_size", "fabric_LanPinTarget_epDn", "fabric_LanPinTarget_fabricId", "fabric_LanPinTarget_targetStatus", "fabric_Lan_id", "fabric_Lan_locale", "fabric_Lan_name", "fabric_Lan_transport", "fabric_Lan_type", "fabric_LastAckedSlot_chassisId", "fabric_LastAckedSlot_slotId", "fabric_LastAckedSlot_switchId", "fabric_LinkPolicy_descr", "fabric_LinkPolicy_intId", "fabric_LinkPolicy_name", "fabric_LinkPolicy_policyLevel", "fabric_LinkPolicy_policyOwner", "fabric_LinkPolicy_type", "fabric_Locale_cType", "fabric_Locale_chassisId", "fabric_Locale_locale", "fabric_Locale_name", "fabric_Locale_side", "fabric_Locale_slotId", "fabric_Locale_switchId", "fabric_Locale_transport", "fabric_Locale_type", "fabric_MonDestEp_adminState", "fabric_MonDestEp_chassisId", "fabric_MonDestEp_epDn", "fabric_MonDestEp_fltAggr", "fabric_MonDestEp_ifRole", "fabric_MonDestEp_ifType", "fabric_MonDestEp_licGP", "fabric_MonDestEp_licState", "fabric_MonDestEp_locale", "fabric_MonDestEp_name", "fabric_MonDestEp_operState", "fabric_MonDestEp_operStateReason", "fabric_MonDestEp_peerChassisId", "fabric_MonDestEp_peerDn", "fabric_MonDestEp_peerPortId", "fabric_MonDestEp_peerSlotId", "fabric_MonDestEp_portId", "fabric_MonDestEp_slotId", "fabric_MonDestEp_switchId", "fabric_MonDestEp_transport", "fabric_MonDestEp_type", "fabric_MonDestEp_warnings", "fabric_MonFiltRef_srcFiltDn", "fabric_MonFiltRef_type", "fabric_MonSrcEp_direction", "fabric_MonSrcEp_name", "fabric_MonSrcEp_session", "fabric_MonSrcEp_transport", "fabric_MonSrcEp_type", "fabric_MonSrcFiltEp_name", "fabric_MonSrcFiltEp_session", "fabric_MonSrcFiltEp_type", "fabric_MonSrcRef_id", "fabric_MonSrcRef_sourceDn", "fabric_MonSrcRef_type", "fabric_Mon_adminState", "fabric_Mon_configFailReason", "fabric_Mon_id", "fabric_Mon_isConfigSuccess", "fabric_Mon_locale", "fabric_Mon_name", "fabric_Mon_operState", "fabric_Mon_operStateReason", "fabric_Mon_peerDn", "fabric_Mon_session", "fabric_Mon_transport", "fabric_Mon_type", "fabric_MulticastPolicy_descr", "fabric_MulticastPolicy_intId", "fabric_MulticastPolicy_name", "fabric_MulticastPolicy_policyLevel", "fabric_MulticastPolicy_policyOwner", "fabric_MulticastPolicy_querierIpAddr", "fabric_MulticastPolicy_querierState", "fabric_MulticastPolicy_snoopingState", "fabric_NetGroup_assigned", "fabric_NetGroup_assignmentOrder", "fabric_NetGroup_descr", "fabric_NetGroup_id", "fabric_NetGroup_intId", "fabric_NetGroup_name", "fabric_NetGroup_nativeNet", "fabric_NetGroup_nativeNetDn", "fabric_NetGroup_owner", "fabric_NetGroup_peerDn", "fabric_NetGroup_policyLevel", "fabric_NetGroup_policyOwner", "fabric_NetGroup_size", "fabric_NetGroup_switchId", "fabric_NetGroup_type", "fabric_NetflowCollector_descr", "fabric_NetflowCollector_flowProtocol", "fabric_NetflowCollector_id", "fabric_NetflowCollector_locale", "fabric_NetflowCollector_name", "fabric_NetflowCollector_port", "fabric_NetflowCollector_sourceVlan", "fabric_NetflowCollector_sourceVlanDn", "fabric_NetflowCollector_transport", "fabric_NetflowCollector_type", "fabric_NetflowIPv4Addr_addr", "fabric_NetflowIPv4Addr_defGw", "fabric_NetflowIPv4Addr_fabricId", "fabric_NetflowIPv4Addr_subnet", "fabric_NetflowMonExporterRef_index", "fabric_NetflowMonExporterRef_nfMonExporterName", "fabric_NetflowMonExporterRef_operNfMonExporterName", "fabric_NetflowMonExporterRef_switchId", "fabric_NetflowMonExporter_descr", "fabric_NetflowMonExporter_dscp", "fabric_NetflowMonExporter_exportInternal", "fabric_NetflowMonExporter_exporterStatsTimeout", "fabric_NetflowMonExporter_flowExpProfile", "fabric_NetflowMonExporter_flowMonCollector", "fabric_NetflowMonExporter_intId", "fabric_NetflowMonExporter_interfaceTableTimeout", "fabric_NetflowMonExporter_name", "fabric_NetflowMonExporter_operFlowExpProfile", "fabric_NetflowMonExporter_policyLevel", "fabric_NetflowMonExporter_policyOwner", "fabric_NetflowMonExporter_protocol", "fabric_NetflowMonExporter_templateDataTimeout", "fabric_NetflowMonExporter_transport", "fabric_NetflowMonExporter_transportProtocol", "fabric_NetflowMonExporter_type", "fabric_NetflowMonExporter_version", "fabric_NetflowMonSession_adminState", "fabric_NetflowMonSession_configFailReason", "fabric_NetflowMonSession_configQualifier", "fabric_NetflowMonSession_descr", "fabric_NetflowMonSession_id", "fabric_NetflowMonSession_isConfigSuccess", "fabric_NetflowMonSession_locale", "fabric_NetflowMonSession_name", "fabric_NetflowMonSession_protocol", "fabric_NetflowMonSession_session", "fabric_NetflowMonSession_transport", "fabric_NetflowMonSession_type", "fabric_NetflowMonSrcEp_name", "fabric_NetflowMonSrcEp_protocol", "fabric_NetflowMonSrcEp_session", "fabric_NetflowMonSrcEp_transport", "fabric_NetflowMonSrcEp_type", "fabric_NetflowMonSrcRef_id", "fabric_NetflowMonSrcRef_protocol", "fabric_NetflowMonSrcRef_sourceDn", "fabric_NetflowMonSrcRef_sourceType", "fabric_NetflowMonSrcRef_type", "fabric_NetflowMonitorRef_direction", "fabric_NetflowMonitorRef_index", "fabric_NetflowMonitorRef_nfMonitorName", "fabric_NetflowMonitorRef_operNfMonitorName", "fabric_NetflowMonitorRef_switchId", "fabric_NetflowMonitor_descr", "fabric_NetflowMonitor_flowMonProtocol", "fabric_NetflowMonitor_flowMonRecordDef", "fabric_NetflowMonitor_flowTimeoutPolicy", "fabric_NetflowMonitor_intId", "fabric_NetflowMonitor_name", "fabric_NetflowMonitor_operFlowMonRecordDef", "fabric_NetflowMonitor_operFlowTimeoutPolicy", "fabric_NetflowMonitor_policyLevel", "fabric_NetflowMonitor_policyOwner", "fabric_NetflowMonitor_transport", "fabric_NetflowMonitor_type", "fabric_NetflowTimeoutPolicy_activeTimeout", "fabric_NetflowTimeoutPolicy_descr", "fabric_NetflowTimeoutPolicy_inactiveTimeout", "fabric_NetflowTimeoutPolicy_intId", "fabric_NetflowTimeoutPolicy_name", "fabric_NetflowTimeoutPolicy_policyLevel", "fabric_NetflowTimeoutPolicy_policyOwner", "fabric_OperPinning_operBorderPortId", "fabric_OperPinning_operBorderSlotId", "fabric_OrgVlanPolicy_adminState", "fabric_OrgVlanPolicy_name", "fabric_PIoEp_chassisId", "fabric_PIoEp_epDn", "fabric_PIoEp_ifRole", "fabric_PIoEp_ifType", "fabric_PIoEp_licGP", "fabric_PIoEp_licState", "fabric_PIoEp_locale", "fabric_PIoEp_name", "fabric_PIoEp_operState", "fabric_PIoEp_operStateReason", "fabric_PIoEp_peerChassisId", "fabric_PIoEp_peerDn", "fabric_PIoEp_peerPortId", "fabric_PIoEp_peerSlotId", "fabric_PIoEp_portId", "fabric_PIoEp_slotId", "fabric_PIoEp_switchId", "fabric_PIoEp_transport", "fabric_PIoEp_type", "fabric_PathConn_cType", "fabric_PathConn_locale", "fabric_PathConn_name", "fabric_PathConn_transport", "fabric_PathConn_type", "fabric_PathEp_cType", "fabric_PathEp_chassisId", "fabric_PathEp_diagLldpTransmit", "fabric_PathEp_epDn", "fabric_PathEp_ifRole", "fabric_PathEp_ifType", "fabric_PathEp_locale", "fabric_PathEp_name", "fabric_PathEp_peerChassisId", "fabric_PathEp_peerDn", "fabric_PathEp_peerMac", "fabric_PathEp_peerPortId", "fabric_PathEp_peerSlotId", "fabric_PathEp_portId", "fabric_PathEp_side", "fabric_PathEp_slotId", "fabric_PathEp_switchId", "fabric_PathEp_transport", "fabric_PathEp_type", "fabric_Path_cType", "fabric_Path_chassisId", "fabric_Path_enacp", "fabric_Path_id", "fabric_Path_locale", "fabric_Path_name", "fabric_Path_nsSize", "fabric_Path_side", "fabric_Path_switchId", "fabric_Path_transport", "fabric_Path_type", "fabric_PinGroup_descr", "fabric_PinGroup_intId", "fabric_PinGroup_name", "fabric_PinGroup_policyLevel", "fabric_PinGroup_policyOwner", "fabric_PinGroup_size", "fabric_PinTarget_epDn", "fabric_PinTarget_fabricId", "fabric_PinTarget_targetStatus", "fabric_Pinning_borderPortId", "fabric_Pinning_borderSlotId", "fabric_PoolableVlan_id", "fabric_PoolableVlan_poolDn", "fabric_PooledVlan_assigned", "fabric_PooledVlan_assignedToDn", "fabric_PooledVlan_configIssues", "fabric_PooledVlan_name", "fabric_PooledVlan_peerDn", "fabric_PooledVlan_poolableDn", "fabric_PooledVlan_prevAssignedToDn", "fabric_SanCloudFsmStage_descr", "fabric_SanCloudFsmStage_lastUpdateTime", "fabric_SanCloudFsmStage_name", "fabric_SanCloudFsmStage_order", "fabric_SanCloudFsmStage_retry", "fabric_SanCloudFsmStage_stageStatus", "fabric_SanCloudFsmTask_completion", "fabric_SanCloudFsmTask_flags", "fabric_SanCloudFsmTask_item", "fabric_SanCloudFsmTask_seqId", "fabric_SanCloudFsm_completionTime", "fabric_SanCloudFsm_currentFsm", "fabric_SanCloudFsm_descr", "fabric_SanCloudFsm_fsmStatus", "fabric_SanCloudFsm_instanceId", "fabric_SanCloudFsm_progress", "fabric_SanCloudFsm_rmtErrCode", "fabric_SanCloudFsm_rmtErrDescr", "fabric_SanCloudFsm_rmtRslt", "fabric_SanCloud_fsmDescr", "fabric_SanCloud_fsmPrev", "fabric_SanCloud_fsmProgr", "fabric_SanCloud_fsmRmtInvErrCode", "fabric_SanCloud_fsmRmtInvErrDescr", "fabric_SanCloud_fsmRmtInvRslt", "fabric_SanCloud_fsmStageDescr", "fabric_SanCloud_fsmStamp", "fabric_SanCloud_fsmStatus", "fabric_SanCloud_fsmTry", "fabric_SanCloud_mode", "fabric_SanEp_adminState", "fabric_SanEp_chassisId", "fabric_SanEp_epDn", "fabric_SanEp_fltAggr", "fabric_SanEp_ifRole", "fabric_SanEp_ifType", "fabric_SanEp_licGP", "fabric_SanEp_licState", "fabric_SanEp_locale", "fabric_SanEp_name", "fabric_SanEp_operState", "fabric_SanEp_operStateReason", "fabric_SanEp_peerChassisId", "fabric_SanEp_peerDn", "fabric_SanEp_peerPortId", "fabric_SanEp_peerSlotId", "fabric_SanEp_portId", "fabric_SanEp_slotId", "fabric_SanEp_switchId", "fabric_SanEp_transport", "fabric_SanEp_type", "fabric_SanEp_warnings", "fabric_SanMonCloud_mode", "fabric_SanPc_adminState", "fabric_SanPc_descr", "fabric_SanPc_epDn", "fabric_SanPc_fltAggr", "fabric_SanPc_ifRole", "fabric_SanPc_ifType", "fabric_SanPc_locale", "fabric_SanPc_name", "fabric_SanPc_operState", "fabric_SanPc_peerDn", "fabric_SanPc_portId", "fabric_SanPc_stateQual", "fabric_SanPc_switchId", "fabric_SanPc_transport", "fabric_SanPc_type", "fabric_SanPc_warnings", "fabric_SanPinGroup_descr", "fabric_SanPinGroup_intId", "fabric_SanPinGroup_name", "fabric_SanPinGroup_policyLevel", "fabric_SanPinGroup_policyOwner", "fabric_SanPinGroup_size", "fabric_SanPinTarget_epDn", "fabric_SanPinTarget_fabricId", "fabric_SanPinTarget_targetStatus", "fabric_San_id", "fabric_San_locale", "fabric_San_name", "fabric_San_transport", "fabric_San_type", "fabric_SwChEp_adminState", "fabric_SwChEp_chassisId", "fabric_SwChEp_epDn", "fabric_SwChEp_fltAggr", "fabric_SwChEp_ifRole", "fabric_SwChEp_ifType", "fabric_SwChEp_licGP", "fabric_SwChEp_licState", "fabric_SwChEp_locale", "fabric_SwChEp_name", "fabric_SwChEp_operState", "fabric_SwChEp_operStateReason", "fabric_SwChEp_peerChassisId", "fabric_SwChEp_peerDn", "fabric_SwChEp_peerPortId", "fabric_SwChEp_peerSlotId", "fabric_SwChEp_portId", "fabric_SwChEp_slotId", "fabric_SwChEp_switchId", "fabric_SwChEp_transport", "fabric_SwChEp_type", "fabric_SwChPhEp_adminState", "fabric_SwChPhEp_chassisId", "fabric_SwChPhEp_epDn", "fabric_SwChPhEp_eqType", "fabric_SwChPhEp_fltAggr", "fabric_SwChPhEp_ifRole", "fabric_SwChPhEp_ifType", "fabric_SwChPhEp_lc", "fabric_SwChPhEp_licGP", "fabric_SwChPhEp_licState", "fabric_SwChPhEp_locale", "fabric_SwChPhEp_model", "fabric_SwChPhEp_name", "fabric_SwChPhEp_operState", "fabric_SwChPhEp_operStateReason", "fabric_SwChPhEp_peerChassisId", "fabric_SwChPhEp_peerDn", "fabric_SwChPhEp_peerPortId", "fabric_SwChPhEp_peerSlotId", "fabric_SwChPhEp_portId", "fabric_SwChPhEp_revision", "fabric_SwChPhEp_serial", "fabric_SwChPhEp_slotId", "fabric_SwChPhEp_switchId", "fabric_SwChPhEp_transport", "fabric_SwChPhEp_type", "fabric_SwChPhEp_vendor", "fabric_SwSrvEp_adminState", "fabric_SwSrvEp_chassisId", "fabric_SwSrvEp_epDn", "fabric_SwSrvEp_fltAggr", "fabric_SwSrvEp_ifRole", "fabric_SwSrvEp_ifType", "fabric_SwSrvEp_licGP", "fabric_SwSrvEp_licState", "fabric_SwSrvEp_locale", "fabric_SwSrvEp_name", "fabric_SwSrvEp_operState", "fabric_SwSrvEp_operStateReason", "fabric_SwSrvEp_peerChassisId", "fabric_SwSrvEp_peerDn", "fabric_SwSrvEp_peerPortId", "fabric_SwSrvEp_peerSlotId", "fabric_SwSrvEp_portId", "fabric_SwSrvEp_slotId", "fabric_SwSrvEp_switchId", "fabric_SwSrvEp_transport", "fabric_SwSrvEp_type", "fabric_SwSrvPc_adminState", "fabric_SwSrvPc_chassisId", "fabric_SwSrvPc_descr", "fabric_SwSrvPc_epDn", "fabric_SwSrvPc_fltAggr", "fabric_SwSrvPc_ifRole", "fabric_SwSrvPc_ifType", "fabric_SwSrvPc_locale", "fabric_SwSrvPc_name", "fabric_SwSrvPc_operSpeed", "fabric_SwSrvPc_operState", "fabric_SwSrvPc_peerDn", "fabric_SwSrvPc_portId", "fabric_SwSrvPc_stateQual", "fabric_SwSrvPc_switchId", "fabric_SwSrvPc_transport", "fabric_SwSrvPc_type", "fabric_TargetEp_adminState", "fabric_TargetEp_chassisId", "fabric_TargetEp_epDn", "fabric_TargetEp_fltAggr", "fabric_TargetEp_ifRole", "fabric_TargetEp_ifType", "fabric_TargetEp_licGP", "fabric_TargetEp_licState", "fabric_TargetEp_locale", "fabric_TargetEp_name", "fabric_TargetEp_operState", "fabric_TargetEp_operStateReason", "fabric_TargetEp_peerChassisId", "fabric_TargetEp_peerDn", "fabric_TargetEp_peerPortId", "fabric_TargetEp_peerSlotId", "fabric_TargetEp_portId", "fabric_TargetEp_slotId", "fabric_TargetEp_switchId", "fabric_TargetEp_transport", "fabric_TargetEp_type", "fabric_TargetEp_warnings", "fabric_UdldLinkPolicy_adminState", "fabric_UdldLinkPolicy_descr", "fabric_UdldLinkPolicy_intId", "fabric_UdldLinkPolicy_mode", "fabric_UdldLinkPolicy_name", "fabric_UdldLinkPolicy_policyLevel", "fabric_UdldLinkPolicy_policyOwner", "fabric_UdldLinkPolicy_protocol", "fabric_UdldLinkPolicy_type", "fabric_UdldPolicy_descr", "fabric_UdldPolicy_intId", "fabric_UdldPolicy_msgInterval", "fabric_UdldPolicy_name", "fabric_UdldPolicy_policyLevel", "fabric_UdldPolicy_policyOwner", "fabric_UdldPolicy_recoveryAction", "fabric_VConProfile_descr", "fabric_VConProfile_intId", "fabric_VConProfile_mezzMapping", "fabric_VConProfile_name", "fabric_VConProfile_policyLevel", "fabric_VConProfile_policyOwner", "fabric_VCon_equipmentDn", "fabric_VCon_fabric", "fabric_VCon_id", "fabric_VCon_instType", "fabric_VCon_placement", "fabric_VCon_select", "fabric_VCon_share", "fabric_VCon_transport", "fabric_VlanEp_epDn", "fabric_VlanEp_id", "fabric_VlanEp_ifRole", "fabric_VlanEp_ifType", "fabric_VlanEp_isNative", "fabric_VlanEp_locale", "fabric_VlanEp_name", "fabric_VlanEp_operState", "fabric_VlanEp_peerDn", "fabric_VlanEp_policyOwner", "fabric_VlanEp_pubNwDn", "fabric_VlanEp_pubNwId", "fabric_VlanEp_pubNwName", "fabric_VlanEp_sharing", "fabric_VlanEp_switchId", "fabric_VlanEp_transport", "fabric_VlanEp_type", "fabric_VlanGroupReq_configIssues", "fabric_VlanGroupReq_name", "fabric_VlanGroupReq_type", "fabric_VlanPermit_cloud", "fabric_VlanPermit_name", "fabric_VlanPermit_switchId", "fabric_VlanReq_configIssues", "fabric_VlanReq_name", "fabric_VlanReq_type", "fabric_Vlan_cloud", "fabric_Vlan_compressionType", "fabric_Vlan_configIssues", "fabric_Vlan_defaultNet", "fabric_Vlan_epDn", "fabric_Vlan_global", "fabric_Vlan_id", "fabric_Vlan_ifRole", "fabric_Vlan_ifType", "fabric_Vlan_local", "fabric_Vlan_locale", "fabric_Vlan_mcastPolicyName", "fabric_Vlan_name", "fabric_Vlan_operMcastPolicyName", "fabric_Vlan_operState", "fabric_Vlan_peerDn", "fabric_Vlan_policyOwner", "fabric_Vlan_pubNwDn", "fabric_Vlan_pubNwId", "fabric_Vlan_pubNwName", "fabric_Vlan_sharing", "fabric_Vlan_switchId", "fabric_Vlan_transport", "fabric_Vlan_type", "fabric_VnetEpSyncEpFsmStage_descr", "fabric_VnetEpSyncEpFsmStage_lastUpdateTime", "fabric_VnetEpSyncEpFsmStage_name", "fabric_VnetEpSyncEpFsmStage_order", "fabric_VnetEpSyncEpFsmStage_retry", "fabric_VnetEpSyncEpFsmStage_stageStatus", "fabric_VnetEpSyncEpFsmTask_completion", "fabric_VnetEpSyncEpFsmTask_flags", "fabric_VnetEpSyncEpFsmTask_item", "fabric_VnetEpSyncEpFsmTask_seqId", "fabric_VnetEpSyncEpFsm_completionTime", "fabric_VnetEpSyncEpFsm_currentFsm", "fabric_VnetEpSyncEpFsm_descr", "fabric_VnetEpSyncEpFsm_fsmStatus", "fabric_VnetEpSyncEpFsm_instanceId", "fabric_VnetEpSyncEpFsm_progress", "fabric_VnetEpSyncEpFsm_rmtErrCode", "fabric_VnetEpSyncEpFsm_rmtErrDescr", "fabric_VnetEpSyncEpFsm_rmtRslt", "fabric_VnetEpSyncEp_fsmDescr", "fabric_VnetEpSyncEp_fsmPrev", "fabric_VnetEpSyncEp_fsmProgr", "fabric_VnetEpSyncEp_fsmRmtInvErrCode", "fabric_VnetEpSyncEp_fsmRmtInvErrDescr", "fabric_VnetEpSyncEp_fsmRmtInvRslt", "fabric_VnetEpSyncEp_fsmStageDescr", "fabric_VnetEpSyncEp_fsmStamp", "fabric_VnetEpSyncEp_fsmStatus", "fabric_VnetEpSyncEp_fsmTry", "fabric_VnetEpSyncEp_genNumSync", "fabric_VnetEpSyncEp_id", "fabric_VnetEpSyncEp_isChangedObjectUpdate", "fabric_VnetEp_epDn", "fabric_VnetEp_id", "fabric_VnetEp_ifRole", "fabric_VnetEp_ifType", "fabric_VnetEp_locale", "fabric_VnetEp_name", "fabric_VnetEp_peerDn", "fabric_VnetEp_policyOwner", "fabric_VnetEp_switchId", "fabric_VnetEp_transport", "fabric_VnetEp_type", "fabric_VnetGroupReq_configIssues", "fabric_VnetGroupReq_name", "fabric_VnetGroupReq_type", "fabric_VnetPermit_cloud", "fabric_VnetPermit_name", "fabric_VnetPermit_switchId", "fabric_VnetReq_configIssues", "fabric_VnetReq_name", "fabric_VnetReq_type", "fabric_VnicUsers_global", "fabric_VnicUsers_local", "fabric_VsanEp_epDn", "fabric_VsanEp_fcoeVlan", "fabric_VsanEp_id", "fabric_VsanEp_ifRole", "fabric_VsanEp_ifType", "fabric_VsanEp_locale", "fabric_VsanEp_name", "fabric_VsanEp_operState", "fabric_VsanEp_peerDn", "fabric_VsanEp_policyOwner", "fabric_VsanEp_switchId", "fabric_VsanEp_transport", "fabric_VsanEp_type", "fabric_VsanEp_zoningState", "fabric_VsanMembership_memberStatus", "fabric_VsanMembership_stateQual", "fabric_VsanMembership_vsanId", "fabric_Vsan_defaultZoning", "fabric_Vsan_epDn", "fabric_Vsan_fcZoneSharingMode", "fabric_Vsan_fcoeVlan", "fabric_Vsan_global", "fabric_Vsan_id", "fabric_Vsan_ifRole", "fabric_Vsan_ifType", "fabric_Vsan_local", "fabric_Vsan_locale", "fabric_Vsan_name", "fabric_Vsan_operState", "fabric_Vsan_peerDn", "fabric_Vsan_policyOwner", "fabric_Vsan_switchId", "fabric_Vsan_transport", "fabric_Vsan_type", "fabric_Vsan_zoningState", "fault_AffectedClass_moClassId", "fault_BaseHolder_name", "fault_BaseHolder_totalFaults", "fault_BasePolicy_ackAction", "fault_BasePolicy_clearAction", "fault_BasePolicy_clearInterval", "fault_BasePolicy_descr", "fault_BasePolicy_flapInterval", "fault_BasePolicy_intId", "fault_BasePolicy_name", "fault_BasePolicy_policyLevel", "fault_BasePolicy_policyOwner", "fault_BasePolicy_retentionInterval", "fault_BasePolicy_sizeLimit", "fault_BasePolicy_soakInterval", "fault_BasePolicy_soakingSeverity", "fault_Holder_name", "fault_Holder_totalFaults", "fault_Inst_ack", "fault_Inst_cause", "fault_Inst_changeSet", "fault_Inst_code", "fault_Inst_created", "fault_Inst_descr", "fault_Inst_highestSeverity", "fault_Inst_id", "fault_Inst_lastTransition", "fault_Inst_lc", "fault_Inst_occur", "fault_Inst_origSeverity", "fault_Inst_prevSeverity", "fault_Inst_rule", "fault_Inst_severity", "fault_Inst_tags", "fault_Inst_type", "fault_LocalTypedHolder_name", "fault_LocalTypedHolder_totalFaults", "fault_LocalTypedHolder_type", "fault_Policy_ackAction", "fault_Policy_clearAction", "fault_Policy_clearInterval", "fault_Policy_descr", "fault_Policy_flapInterval", "fault_Policy_intId", "fault_Policy_name", "fault_Policy_policyLevel", "fault_Policy_policyOwner", "fault_Policy_retentionInterval", "fault_Policy_sizeLimit", "fault_Policy_soakInterval", "fault_Policy_soakingSeverity", "fault_SuppressPolicyItem_cause", "fault_SuppressPolicyItem_descr", "fault_SuppressPolicyItem_type", "fault_SuppressPolicy_descr", "fault_SuppressPolicy_intId", "fault_SuppressPolicy_name", "fault_SuppressPolicy_policyLevel", "fault_SuppressPolicy_policyOwner", "fault_SuppressTask_adminState", "fault_SuppressTask_autoDelete", "fault_SuppressTask_descr", "fault_SuppressTask_ignoreCap", "fault_SuppressTask_intId", "fault_SuppressTask_name", "fault_SuppressTask_operScheduler", "fault_SuppressTask_operState", "fault_SuppressTask_operSuppressPolicyName", "fault_SuppressTask_policyLevel", "fault_SuppressTask_policyOwner", "fault_SuppressTask_scheduler", "fault_SuppressTask_suppressPolicyName", "fc_ErrStatsHist_crcRx", "fc_ErrStatsHist_crcRxDelta", "fc_ErrStatsHist_crcRxDeltaAvg", "fc_ErrStatsHist_crcRxDeltaMax", "fc_ErrStatsHist_crcRxDeltaMin", "fc_ErrStatsHist_discardRx", "fc_ErrStatsHist_discardRxDelta", "fc_ErrStatsHist_discardRxDeltaAvg", "fc_ErrStatsHist_discardRxDeltaMax", "fc_ErrStatsHist_discardRxDeltaMin", "fc_ErrStatsHist_discardTx", "fc_ErrStatsHist_discardTxDelta", "fc_ErrStatsHist_discardTxDeltaAvg", "fc_ErrStatsHist_discardTxDeltaMax", "fc_ErrStatsHist_discardTxDeltaMin", "fc_ErrStatsHist_id", "fc_ErrStatsHist_linkFailures", "fc_ErrStatsHist_linkFailuresDelta", "fc_ErrStatsHist_linkFailuresDeltaAvg", "fc_ErrStatsHist_linkFailuresDeltaMax", "fc_ErrStatsHist_linkFailuresDeltaMin", "fc_ErrStatsHist_mostRecent", "fc_ErrStatsHist_rx", "fc_ErrStatsHist_rxDelta", "fc_ErrStatsHist_rxDeltaAvg", "fc_ErrStatsHist_rxDeltaMax", "fc_ErrStatsHist_rxDeltaMin", "fc_ErrStatsHist_signalLosses", "fc_ErrStatsHist_signalLossesDelta", "fc_ErrStatsHist_signalLossesDeltaAvg", "fc_ErrStatsHist_signalLossesDeltaMax", "fc_ErrStatsHist_signalLossesDeltaMin", "fc_ErrStatsHist_suspect", "fc_ErrStatsHist_syncLosses", "fc_ErrStatsHist_syncLossesDelta", "fc_ErrStatsHist_syncLossesDeltaAvg", "fc_ErrStatsHist_syncLossesDeltaMax", "fc_ErrStatsHist_syncLossesDeltaMin", "fc_ErrStatsHist_thresholded", "fc_ErrStatsHist_timeCollected", "fc_ErrStatsHist_tooLongRx", "fc_ErrStatsHist_tooLongRxDelta", "fc_ErrStatsHist_tooLongRxDeltaAvg", "fc_ErrStatsHist_tooLongRxDeltaMax", "fc_ErrStatsHist_tooLongRxDeltaMin", "fc_ErrStatsHist_tooShortRx", "fc_ErrStatsHist_tooShortRxDelta", "fc_ErrStatsHist_tooShortRxDeltaAvg", "fc_ErrStatsHist_tooShortRxDeltaMax", "fc_ErrStatsHist_tooShortRxDeltaMin", "fc_ErrStatsHist_tx", "fc_ErrStatsHist_txDelta", "fc_ErrStatsHist_txDeltaAvg", "fc_ErrStatsHist_txDeltaMax", "fc_ErrStatsHist_txDeltaMin", "fc_ErrStats_crcRx", "fc_ErrStats_crcRxDelta", "fc_ErrStats_crcRxDeltaAvg", "fc_ErrStats_crcRxDeltaMax", "fc_ErrStats_crcRxDeltaMin", "fc_ErrStats_discardRx", "fc_ErrStats_discardRxDelta", "fc_ErrStats_discardRxDeltaAvg", "fc_ErrStats_discardRxDeltaMax", "fc_ErrStats_discardRxDeltaMin", "fc_ErrStats_discardTx", "fc_ErrStats_discardTxDelta", "fc_ErrStats_discardTxDeltaAvg", "fc_ErrStats_discardTxDeltaMax", "fc_ErrStats_discardTxDeltaMin", "fc_ErrStats_intervals", "fc_ErrStats_linkFailures", "fc_ErrStats_linkFailuresDelta", "fc_ErrStats_linkFailuresDeltaAvg", "fc_ErrStats_linkFailuresDeltaMax", "fc_ErrStats_linkFailuresDeltaMin", "fc_ErrStats_rx", "fc_ErrStats_rxDelta", "fc_ErrStats_rxDeltaAvg", "fc_ErrStats_rxDeltaMax", "fc_ErrStats_rxDeltaMin", "fc_ErrStats_signalLosses", "fc_ErrStats_signalLossesDelta", "fc_ErrStats_signalLossesDeltaAvg", "fc_ErrStats_signalLossesDeltaMax", "fc_ErrStats_signalLossesDeltaMin", "fc_ErrStats_suspect", "fc_ErrStats_syncLosses", "fc_ErrStats_syncLossesDelta", "fc_ErrStats_syncLossesDeltaAvg", "fc_ErrStats_syncLossesDeltaMax", "fc_ErrStats_syncLossesDeltaMin", "fc_ErrStats_thresholded", "fc_ErrStats_timeCollected", "fc_ErrStats_tooLongRx", "fc_ErrStats_tooLongRxDelta", "fc_ErrStats_tooLongRxDeltaAvg", "fc_ErrStats_tooLongRxDeltaMax", "fc_ErrStats_tooLongRxDeltaMin", "fc_ErrStats_tooShortRx", "fc_ErrStats_tooShortRxDelta", "fc_ErrStats_tooShortRxDeltaAvg", "fc_ErrStats_tooShortRxDeltaMax", "fc_ErrStats_tooShortRxDeltaMin", "fc_ErrStats_tx", "fc_ErrStats_txDelta", "fc_ErrStats_txDeltaAvg", "fc_ErrStats_txDeltaMax", "fc_ErrStats_txDeltaMin", "fc_ErrStats_update", "fc_PIoFsmStage_descr", "fc_PIoFsmStage_lastUpdateTime", "fc_PIoFsmStage_name", "fc_PIoFsmStage_order", "fc_PIoFsmStage_retry", "fc_PIoFsmStage_stageStatus", "fc_PIoFsm_completionTime", "fc_PIoFsm_currentFsm", "fc_PIoFsm_descr", "fc_PIoFsm_fsmStatus", "fc_PIoFsm_instanceId", "fc_PIoFsm_progress", "fc_PIoFsm_rmtErrCode", "fc_PIoFsm_rmtErrDescr", "fc_PIoFsm_rmtRslt", "fc_PIo_adminState", "fc_PIo_adminTransport", "fc_PIo_chassisId", "fc_PIo_encap", "fc_PIo_epDn", "fc_PIo_fsmDescr", "fc_PIo_fsmPrev", "fc_PIo_fsmProgr", "fc_PIo_fsmRmtInvErrCode", "fc_PIo_fsmRmtInvErrDescr", "fc_PIo_fsmRmtInvRslt", "fc_PIo_fsmStageDescr", "fc_PIo_fsmStamp", "fc_PIo_fsmStatus", "fc_PIo_fsmTry", "fc_PIo_ifRole", "fc_PIo_ifType", "fc_PIo_isPortChannelMember", "fc_PIo_lc", "fc_PIo_licGP", "fc_PIo_licState", "fc_PIo_locale", "fc_PIo_maxSpeed", "fc_PIo_mode", "fc_PIo_model", "fc_PIo_name", "fc_PIo_operSpeed", "fc_PIo_operState", "fc_PIo_peerChassisId", "fc_PIo_peerDn", "fc_PIo_peerPortId", "fc_PIo_peerSlotId", "fc_PIo_portId", "fc_PIo_revision", "fc_PIo_serial", "fc_PIo_slotId", "fc_PIo_stateQual", "fc_PIo_switchId", "fc_PIo_transport", "fc_PIo_ts", "fc_PIo_type", "fc_PIo_unifiedPort", "fc_PIo_usrLbl", "fc_PIo_vendor", "fc_PIo_wwn", "fc_PIo_xcvrType", "fc_StatsHist_bytesRx", "fc_StatsHist_bytesRxDelta", "fc_StatsHist_bytesRxDeltaAvg", "fc_StatsHist_bytesRxDeltaMax", "fc_StatsHist_bytesRxDeltaMin", "fc_StatsHist_bytesTx", "fc_StatsHist_bytesTxDelta", "fc_StatsHist_bytesTxDeltaAvg", "fc_StatsHist_bytesTxDeltaMax", "fc_StatsHist_bytesTxDeltaMin", "fc_StatsHist_id", "fc_StatsHist_mostRecent", "fc_StatsHist_packetsRx", "fc_StatsHist_packetsRxDelta", "fc_StatsHist_packetsRxDeltaAvg", "fc_StatsHist_packetsRxDeltaMax", "fc_StatsHist_packetsRxDeltaMin", "fc_StatsHist_packetsTx", "fc_StatsHist_packetsTxDelta", "fc_StatsHist_packetsTxDeltaAvg", "fc_StatsHist_packetsTxDeltaMax", "fc_StatsHist_packetsTxDeltaMin", "fc_StatsHist_suspect", "fc_StatsHist_thresholded", "fc_StatsHist_timeCollected", "fc_Stats_bytesRx", "fc_Stats_bytesRxDelta", "fc_Stats_bytesRxDeltaAvg", "fc_Stats_bytesRxDeltaMax", "fc_Stats_bytesRxDeltaMin", "fc_Stats_bytesTx", "fc_Stats_bytesTxDelta", "fc_Stats_bytesTxDeltaAvg", "fc_Stats_bytesTxDeltaMax", "fc_Stats_bytesTxDeltaMin", "fc_Stats_intervals", "fc_Stats_packetsRx", "fc_Stats_packetsRxDelta", "fc_Stats_packetsRxDeltaAvg", "fc_Stats_packetsRxDeltaMax", "fc_Stats_packetsRxDeltaMin", "fc_Stats_packetsTx", "fc_Stats_packetsTxDelta", "fc_Stats_packetsTxDeltaAvg", "fc_Stats_packetsTxDeltaMax", "fc_Stats_packetsTxDeltaMin", "fc_Stats_suspect", "fc_Stats_thresholded", "fc_Stats_timeCollected", "fc_Stats_update", "fcpool_Addr_assigned", "fcpool_Addr_assignedToDn", "fcpool_Addr_id", "fcpool_Addr_owner", "fcpool_Block_from", "fcpool_Block_to", "fcpool_BootTarget_lun", "fcpool_BootTarget_type", "fcpool_BootTarget_wwn", "fcpool_Format_format", "fcpool_Format_mask", "fcpool_InitiatorEp_id", "fcpool_InitiatorEp_initiatorDn", "fcpool_InitiatorEp_purpose", "fcpool_Initiator_assigned", "fcpool_Initiator_assignedToDn", "fcpool_Initiator_descr", "fcpool_Initiator_id", "fcpool_Initiator_name", "fcpool_Initiator_poolableDn", "fcpool_Initiator_prevAssignedToDn", "fcpool_Initiator_purpose", "fcpool_Initiators_assigned", "fcpool_Initiators_assignmentOrder", "fcpool_Initiators_descr", "fcpool_Initiators_intId", "fcpool_Initiators_maxPortsPerNode", "fcpool_Initiators_name", "fcpool_Initiators_policyLevel", "fcpool_Initiators_policyOwner", "fcpool_Initiators_purpose", "fcpool_Initiators_size", "fcpool_Poolable_id", "fcpool_Poolable_poolDn", "firmware_Ack_acked", "firmware_Ack_ackedBy", "firmware_Ack_adminState", "firmware_Ack_autoDelete", "firmware_Ack_changeBy", "firmware_Ack_changeDetails", "firmware_Ack_changes", "firmware_Ack_descr", "firmware_Ack_disr", "firmware_Ack_ignoreCap", "firmware_Ack_intId", "firmware_Ack_modified", "firmware_Ack_name", "firmware_Ack_operScheduler", "firmware_Ack_operState", "firmware_Ack_policyLevel", "firmware_Ack_policyOwner", "firmware_Ack_prevOperState", "firmware_Ack_scheduler", "firmware_AutoSyncPolicy_configIssue", "firmware_AutoSyncPolicy_descr", "firmware_AutoSyncPolicy_intId", "firmware_AutoSyncPolicy_name", "firmware_AutoSyncPolicy_policyLevel", "firmware_AutoSyncPolicy_policyOwner", "firmware_AutoSyncPolicy_syncState", "firmware_Blade_operVersion", "firmware_BootDefinition_type", "firmware_BootUnit_adminState", "firmware_BootUnit_ignoreCompCheck", "firmware_BootUnit_image", "firmware_BootUnit_operState", "firmware_BootUnit_prevVersion", "firmware_BootUnit_resetOnActivate", "firmware_BootUnit_skipValidation", "firmware_BootUnit_type", "firmware_BootUnit_version", "firmware_BundleInfoDigest_bundleName", "firmware_BundleInfoDigest_type", "firmware_BundleInfoDigest_version", "firmware_BundleInfo_type", "firmware_BundleInfo_version", "firmware_BundleTypeCapProvider_deleted", "firmware_BundleTypeCapProvider_deprecated", "firmware_BundleTypeCapProvider_elementLoadFailures", "firmware_BundleTypeCapProvider_elementsLoaded", "firmware_BundleTypeCapProvider_gencount", "firmware_BundleTypeCapProvider_loadErrors", "firmware_BundleTypeCapProvider_loadWarnings", "firmware_BundleTypeCapProvider_mgmtPlaneVer", "firmware_BundleTypeCapProvider_model", "firmware_BundleTypeCapProvider_vendor", "firmware_BundleType_invTag", "firmware_BundleType_type", "firmware_CapProvider_deleted", "firmware_CapProvider_deprecated", "firmware_CapProvider_elementLoadFailures", "firmware_CapProvider_elementsLoaded", "firmware_CapProvider_gencount", "firmware_CapProvider_loadErrors", "firmware_CapProvider_loadWarnings", "firmware_CapProvider_mgmtPlaneVer", "firmware_CapProvider_model", "firmware_CapProvider_vendor", "firmware_CapProvider_version", "firmware_CatalogPack_catalogName", "firmware_CatalogPack_catalogVersion", "firmware_CatalogPack_configState", "firmware_CatalogPack_configStatusMessage", "firmware_CatalogPack_descr", "firmware_CatalogPack_intId", "firmware_CatalogPack_mode", "firmware_CatalogPack_name", "firmware_CatalogPack_policyLevel", "firmware_CatalogPack_policyOwner", "firmware_CatalogPack_stageSize", "firmware_CatalogPack_updateTrigger", "firmware_Catalogue_syncTrigger", "firmware_CompItem_descr", "firmware_CompItem_intId", "firmware_CompItem_invTag", "firmware_CompItem_name", "firmware_CompItem_policyLevel", "firmware_CompItem_policyOwner", "firmware_CompItem_version", "firmware_CompSource_descr", "firmware_CompSource_intId", "firmware_CompSource_invTag", "firmware_CompSource_name", "firmware_CompSource_policyLevel", "firmware_CompSource_policyOwner", "firmware_CompSource_version", "firmware_CompTarget_descr", "firmware_CompTarget_intId", "firmware_CompTarget_invTag", "firmware_CompTarget_name", "firmware_CompTarget_policyLevel", "firmware_CompTarget_policyOwner", "firmware_CompTarget_version", "firmware_ComputeHostPack_bladeBundleName", "firmware_ComputeHostPack_bladeBundleVersion", "firmware_ComputeHostPack_configQualifier", "firmware_ComputeHostPack_descr", "firmware_ComputeHostPack_ignoreCompCheck", "firmware_ComputeHostPack_intId", "firmware_ComputeHostPack_mode", "firmware_ComputeHostPack_name", "firmware_ComputeHostPack_policyLevel", "firmware_ComputeHostPack_policyOwner", "firmware_ComputeHostPack_rackBundleName", "firmware_ComputeHostPack_rackBundleVersion", "firmware_ComputeHostPack_stageSize", "firmware_ComputeHostPack_updateTrigger", "firmware_ComputeMgmtPack_descr", "firmware_ComputeMgmtPack_ignoreCompCheck", "firmware_ComputeMgmtPack_intId", "firmware_ComputeMgmtPack_mode", "firmware_ComputeMgmtPack_name", "firmware_ComputeMgmtPack_policyLevel", "firmware_ComputeMgmtPack_policyOwner", "firmware_ComputeMgmtPack_stageSize", "firmware_ComputeMgmtPack_updateTrigger", "firmware_ComputePack_descr", "firmware_ComputePack_ignoreCompCheck", "firmware_ComputePack_intId", "firmware_ComputePack_mode", "firmware_ComputePack_name", "firmware_ComputePack_policyLevel", "firmware_ComputePack_policyOwner", "firmware_ComputePack_stageSize", "firmware_ComputePack_updateTrigger", "firmware_Dependency_ep", "firmware_Dependency_hwModel", "firmware_Dependency_hwRevision", "firmware_Dependency_hwVendor", "firmware_Dependency_invTag", "firmware_Dependency_maxVer", "firmware_Dependency_minVer", "firmware_Dependency_relationship", "firmware_Dependency_scope", "firmware_Dependency_sensitivity", "firmware_DistImage_imageDeleted", "firmware_DistImage_name", "firmware_DistImage_type", "firmware_DistributableFsmStage_descr", "firmware_DistributableFsmStage_lastUpdateTime", "firmware_DistributableFsmStage_name", "firmware_DistributableFsmStage_order", "firmware_DistributableFsmStage_retry", "firmware_DistributableFsmStage_stageStatus", "firmware_DistributableFsmTask_completion", "firmware_DistributableFsmTask_flags", "firmware_DistributableFsmTask_item", "firmware_DistributableFsmTask_seqId", "firmware_DistributableFsm_completionTime", "firmware_DistributableFsm_currentFsm", "firmware_DistributableFsm_descr", "firmware_DistributableFsm_fsmStatus", "firmware_DistributableFsm_instanceId", "firmware_DistributableFsm_progress", "firmware_DistributableFsm_rmtErrCode", "firmware_DistributableFsm_rmtErrDescr", "firmware_DistributableFsm_rmtRslt", "firmware_Distributable_adminState", "firmware_Distributable_completeness", "firmware_Distributable_descr", "firmware_Distributable_fsmDescr", "firmware_Distributable_fsmPrev", "firmware_Distributable_fsmProgr", "firmware_Distributable_fsmRmtInvErrCode", "firmware_Distributable_fsmRmtInvErrDescr", "firmware_Distributable_fsmRmtInvRslt", "firmware_Distributable_fsmStageDescr", "firmware_Distributable_fsmStamp", "firmware_Distributable_fsmStatus", "firmware_Distributable_fsmTry", "firmware_Distributable_imagePresence", "firmware_Distributable_intId", "firmware_Distributable_invTag", "firmware_Distributable_model", "firmware_Distributable_name", "firmware_Distributable_policyLevel", "firmware_Distributable_policyOwner", "firmware_Distributable_transferState", "firmware_Distributable_type", "firmware_Distributable_vendor", "firmware_Distributable_version", "firmware_DownloaderFsmStage_descr", "firmware_DownloaderFsmStage_lastUpdateTime", "firmware_DownloaderFsmStage_name", "firmware_DownloaderFsmStage_order", "firmware_DownloaderFsmStage_retry", "firmware_DownloaderFsmStage_stageStatus", "firmware_DownloaderFsmTask_completion", "firmware_DownloaderFsmTask_flags", "firmware_DownloaderFsmTask_item", "firmware_DownloaderFsmTask_seqId", "firmware_DownloaderFsm_completionTime", "firmware_DownloaderFsm_currentFsm", "firmware_DownloaderFsm_descr", "firmware_DownloaderFsm_fsmStatus", "firmware_DownloaderFsm_instanceId", "firmware_DownloaderFsm_progress", "firmware_DownloaderFsm_rmtErrCode", "firmware_DownloaderFsm_rmtErrDescr", "firmware_DownloaderFsm_rmtRslt", "firmware_Downloader_adminState", "firmware_Downloader_fileName", "firmware_Downloader_fsmDescr", "firmware_Downloader_fsmPrev", "firmware_Downloader_fsmProgr", "firmware_Downloader_fsmRmtInvErrCode", "firmware_Downloader_fsmRmtInvErrDescr", "firmware_Downloader_fsmRmtInvRslt", "firmware_Downloader_fsmStageDescr", "firmware_Downloader_fsmStamp", "firmware_Downloader_fsmStatus", "firmware_Downloader_fsmTry", "firmware_Downloader_imageSize", "firmware_Downloader_protocol", "firmware_Downloader_pwd", "firmware_Downloader_remotePath", "firmware_Downloader_server", "firmware_Downloader_transferState", "firmware_Downloader_user", "firmware_HostPackModImpact_keyDn", "firmware_HostPackModImpact_maintPolicyDn", "firmware_HostPackModImpact_pnDn", "firmware_HostPackModImpact_rebootPolicy", "firmware_HostPackModImpact_serviceProfileDn", "firmware_ImageFsmStage_descr", "firmware_ImageFsmStage_lastUpdateTime", "firmware_ImageFsmStage_name", "firmware_ImageFsmStage_order", "firmware_ImageFsmStage_retry", "firmware_ImageFsmStage_stageStatus", "firmware_ImageFsmTask_completion", "firmware_ImageFsmTask_flags", "firmware_ImageFsmTask_item", "firmware_ImageFsmTask_seqId", "firmware_ImageFsm_completionTime", "firmware_ImageFsm_currentFsm", "firmware_ImageFsm_descr", "firmware_ImageFsm_fsmStatus", "firmware_ImageFsm_instanceId", "firmware_ImageFsm_progress", "firmware_ImageFsm_rmtErrCode", "firmware_ImageFsm_rmtErrDescr", "firmware_ImageFsm_rmtRslt", "firmware_Image_adminState", "firmware_Image_checksum", "firmware_Image_descr", "firmware_Image_downloadDate", "firmware_Image_fsmDescr", "firmware_Image_fsmPrev", "firmware_Image_fsmProgr", "firmware_Image_fsmRmtInvErrCode", "firmware_Image_fsmRmtInvErrDescr", "firmware_Image_fsmRmtInvRslt", "firmware_Image_fsmStageDescr", "firmware_Image_fsmStamp", "firmware_Image_fsmStatus", "firmware_Image_fsmTry", "firmware_Image_imagePresence", "firmware_Image_intId", "firmware_Image_invTag", "firmware_Image_isoname", "firmware_Image_location", "firmware_Image_name", "firmware_Image_policyLevel", "firmware_Image_policyOwner", "firmware_Image_size", "firmware_Image_type", "firmware_Image_version", "firmware_Info_model", "firmware_Info_vendor", "firmware_Info_version", "firmware_InfraPack_descr", "firmware_InfraPack_forceDeploy", "firmware_InfraPack_infraBundleName", "firmware_InfraPack_infraBundleVersion", "firmware_InfraPack_intId", "firmware_InfraPack_mode", "firmware_InfraPack_name", "firmware_InfraPack_policyLevel", "firmware_InfraPack_policyOwner", "firmware_InfraPack_stageSize", "firmware_InfraPack_updateTrigger", "firmware_Infra_adminState", "firmware_Infra_autoDelete", "firmware_Infra_descr", "firmware_Infra_ignoreCap", "firmware_Infra_intId", "firmware_Infra_name", "firmware_Infra_operScheduler", "firmware_Infra_operState", "firmware_Infra_operVersion", "firmware_Infra_policyLevel", "firmware_Infra_policyOwner", "firmware_Infra_scheduler", "firmware_InstallImpact_descr", "firmware_InstallImpact_keyDn", "firmware_InstallImpact_maintPolicyDn", "firmware_InstallImpact_rebootPolicy", "firmware_InstallImpact_subject", "firmware_InstallImpact_type", "firmware_Installable_checksum", "firmware_Installable_inProgress", "firmware_Installable_isoname", "firmware_Installable_location", "firmware_Installable_model", "firmware_Installable_name", "firmware_Installable_size", "firmware_Installable_type", "firmware_Installable_vendor", "firmware_Installable_version", "firmware_PackItem_hwModel", "firmware_PackItem_hwVendor", "firmware_PackItem_presence", "firmware_PackItem_type", "firmware_PackItem_version", "firmware_Pack_descr", "firmware_Pack_intId", "firmware_Pack_mode", "firmware_Pack_name", "firmware_Pack_policyLevel", "firmware_Pack_policyOwner", "firmware_Pack_stageSize", "firmware_Pack_updateTrigger", "firmware_Rack_operVersion", "firmware_Running_deployment", "firmware_Running_packageVersion", "firmware_Running_type", "firmware_Running_version", "firmware_Spec_bundleVersion", "firmware_Spec_ethEFIVersion", "firmware_Spec_ethOptionRomVersion", "firmware_Spec_fcFWVersion", "firmware_Spec_fcOptionRomVersion", "firmware_Status_operState", "firmware_Status_packageVersion", "firmware_SystemCompCheckResult_keyDescr", "firmware_SystemCompCheckResult_keyDn", "firmware_SystemCompCheckResult_nonCompDescr", "firmware_SystemCompCheckResult_nonCompDns", "firmware_SystemCompCheckResult_subject", "firmware_SystemFsmStage_descr", "firmware_SystemFsmStage_lastUpdateTime", "firmware_SystemFsmStage_name", "firmware_SystemFsmStage_order", "firmware_SystemFsmStage_retry", "firmware_SystemFsmStage_stageStatus", "firmware_SystemFsmTask_completion", "firmware_SystemFsmTask_flags", "firmware_SystemFsmTask_item", "firmware_SystemFsmTask_seqId", "firmware_SystemFsm_completionTime", "firmware_SystemFsm_currentFsm", "firmware_SystemFsm_descr", "firmware_SystemFsm_fsmStatus", "firmware_SystemFsm_instanceId", "firmware_SystemFsm_progress", "firmware_SystemFsm_rmtErrCode", "firmware_SystemFsm_rmtErrDescr", "firmware_SystemFsm_rmtRslt", "firmware_System_fsmDescr", "firmware_System_fsmFlags", "firmware_System_fsmPrev", "firmware_System_fsmProgr", "firmware_System_fsmRmtInvErrCode", "firmware_System_fsmRmtInvErrDescr", "firmware_System_fsmRmtInvRslt", "firmware_System_fsmStageDescr", "firmware_System_fsmStamp", "firmware_System_fsmStatus", "firmware_System_fsmTry", "firmware_System_operState", "firmware_System_state", "firmware_Type_ep", "firmware_Type_invTag", "firmware_Type_maxVer", "firmware_Type_minVer", "firmware_Unit_deployment", "firmware_Unit_version", "firmware_Updatable_adminState", "firmware_Updatable_deployment", "firmware_Updatable_operState", "firmware_Updatable_operStateQual", "firmware_Updatable_prevVersion", "firmware_Updatable_version", "firmware_UpgradeConstraint_minVer", "firmware_UpgradeDetail_category", "firmware_UpgradeDetail_description", "firmware_UpgradeDetail_id", "firmware_UpgradeDetail_severity", "firmware_UpgradeInfo_message", "firmware_UpgradeInfo_timeStamp", "firmware_UpgradeInfo_validateStatus", "firmware_UpgradeInfo_version", "flowctrl_Definition_descr", "flowctrl_Definition_intId", "flowctrl_Definition_name", "flowctrl_Definition_policyLevel", "flowctrl_Definition_policyOwner", "flowctrl_Item_name", "flowctrl_Item_prio", "flowctrl_Item_rcv", "flowctrl_Item_snd", "fsm_Fsm_completionTime", "fsm_Fsm_currentFsm", "fsm_Fsm_descr", "fsm_Fsm_fsmStatus", "fsm_Fsm_instanceId", "fsm_Fsm_progress", "fsm_Fsm_rmtErrCode", "fsm_Fsm_rmtErrDescr", "fsm_Fsm_rmtRslt", "fsm_Stage_descr", "fsm_Stage_lastUpdateTime", "fsm_Stage_name", "fsm_Stage_order", "fsm_Stage_retry", "fsm_Stage_stageStatus", "fsm_Status_convertedEpRef", "fsm_Status_descr", "fsm_Status_name", "fsm_Status_objectClassName", "fsm_Status_remoteEpRef", "fsm_Status_state", "fsm_Task_completion", "fsm_Task_flags", "fsm_Task_item", "fsm_Task_seqId", "gmeta_Class_adminPropMask", "gmeta_Class_epClassId", "gmeta_Class_id", "gmeta_Class_name", "gmeta_Class_operPropMask", "gmeta_HolderFsmStage_descr", "gmeta_HolderFsmStage_lastUpdateTime", "gmeta_HolderFsmStage_name", "gmeta_HolderFsmStage_order", "gmeta_HolderFsmStage_retry", "gmeta_HolderFsmStage_stageStatus", "gmeta_HolderFsmTask_completion", "gmeta_HolderFsmTask_flags", "gmeta_HolderFsmTask_item", "gmeta_HolderFsmTask_seqId", "gmeta_HolderFsm_completionTime", "gmeta_HolderFsm_currentFsm", "gmeta_HolderFsm_descr", "gmeta_HolderFsm_fsmStatus", "gmeta_HolderFsm_instanceId", "gmeta_HolderFsm_progress", "gmeta_HolderFsm_rmtErrCode", "gmeta_HolderFsm_rmtErrDescr", "gmeta_HolderFsm_rmtRslt", "gmeta_Holder_category", "gmeta_Holder_fsmDescr", "gmeta_Holder_fsmFlags", "gmeta_Holder_fsmPrev", "gmeta_Holder_fsmProgr", "gmeta_Holder_fsmRmtInvErrCode", "gmeta_Holder_fsmRmtInvErrDescr", "gmeta_Holder_fsmRmtInvRslt", "gmeta_Holder_fsmStageDescr", "gmeta_Holder_fsmStamp", "gmeta_Holder_fsmStatus", "gmeta_Holder_fsmTry", "gmeta_Holder_inventoryStatus", "gmeta_Holder_pollInterval", "gmeta_Holder_provider", "gmeta_PolicyMapElement_name", "gmeta_Prop_name", "gmeta_Prop_order", "gmeta_Prop_propId", "graphics_Card_deviceId", "graphics_Card_id", "graphics_Card_isSupported", "graphics_Card_lc", "graphics_Card_model", "graphics_Card_operQualifierReason", "graphics_Card_operState", "graphics_Card_operability", "graphics_Card_pciAddr", "graphics_Card_pciSlot", "graphics_Card_perf", "graphics_Card_power", "graphics_Card_presence", "graphics_Card_revision", "graphics_Card_serial", "graphics_Card_subDeviceId", "graphics_Card_subVendorId", "graphics_Card_thermal", "graphics_Card_vendor", "graphics_Card_vendorId", "graphics_Card_voltage", "graphics_Controller_id", "graphics_Controller_model", "graphics_Controller_operQualifierReason", "graphics_Controller_operState", "graphics_Controller_operability", "graphics_Controller_pciAddr", "graphics_Controller_pciSlot", "graphics_Controller_perf", "graphics_Controller_power", "graphics_Controller_presence", "graphics_Controller_revision", "graphics_Controller_serial", "graphics_Controller_thermal", "graphics_Controller_vendor", "graphics_Controller_voltage", "hostimg_Policy_comp", "hostimg_Policy_conf", "hostimg_Policy_descr", "hostimg_Policy_distro", "hostimg_Policy_intId", "hostimg_Policy_name", "hostimg_Policy_policyLevel", "hostimg_Policy_policyOwner", "hostimg_Policy_type", "hostimg_Target_name", "hostimg_Target_order", "hostimg_Target_type", "hostimg_Target_uri", "ident_IdentCtx_assigned", "ident_IdentCtx_consDn", "ident_IdentCtx_consType", "ident_IdentCtx_definedInIdm", "ident_IdentCtx_identPoolName", "ident_IdentCtx_identType", "ident_IdentCtx_intent", "ident_IdentCtx_poolDn", "ident_IdentCtx_poolOrgDn", "ident_IdentCtx_pooledId", "ident_IdentCtx_retStatus", "ident_IdentCtx_seqNum", "ident_IdentCtx_supplId1", "ident_IdentCtx_supplId2", "ident_IdentCtx_supplId3", "ident_IdentCtx_supplId4", "ident_IdentRequestFsmStage_descr", "ident_IdentRequestFsmStage_lastUpdateTime", "ident_IdentRequestFsmStage_name", "ident_IdentRequestFsmStage_order", "ident_IdentRequestFsmStage_retry", "ident_IdentRequestFsmStage_stageStatus", "ident_IdentRequestFsmTask_completion", "ident_IdentRequestFsmTask_flags", "ident_IdentRequestFsmTask_item", "ident_IdentRequestFsmTask_seqId", "ident_IdentRequestFsm_completionTime", "ident_IdentRequestFsm_currentFsm", "ident_IdentRequestFsm_descr", "ident_IdentRequestFsm_fsmStatus", "ident_IdentRequestFsm_instanceId", "ident_IdentRequestFsm_progress", "ident_IdentRequestFsm_rmtErrCode", "ident_IdentRequestFsm_rmtErrDescr", "ident_IdentRequestFsm_rmtRslt", "ident_IdentRequest_epDn", "ident_IdentRequest_fsmDescr", "ident_IdentRequest_fsmPrev", "ident_IdentRequest_fsmProgr", "ident_IdentRequest_fsmRmtInvErrCode", "ident_IdentRequest_fsmRmtInvErrDescr", "ident_IdentRequest_fsmRmtInvRslt", "ident_IdentRequest_fsmStageDescr", "ident_IdentRequest_fsmStamp", "ident_IdentRequest_fsmStatus", "ident_IdentRequest_fsmTry", "ident_IdentRequest_id", "ident_IdentRequest_requestSize", "ident_IdentRequest_seqNum", "ident_MetaSystemFsmStage_descr", "ident_MetaSystemFsmStage_lastUpdateTime", "ident_MetaSystemFsmStage_name", "ident_MetaSystemFsmStage_order", "ident_MetaSystemFsmStage_retry", "ident_MetaSystemFsmStage_stageStatus", "ident_MetaSystemFsmTask_completion", "ident_MetaSystemFsmTask_flags", "ident_MetaSystemFsmTask_item", "ident_MetaSystemFsmTask_seqId", "ident_MetaSystemFsm_completionTime", "ident_MetaSystemFsm_currentFsm", "ident_MetaSystemFsm_descr", "ident_MetaSystemFsm_fsmStatus", "ident_MetaSystemFsm_instanceId", "ident_MetaSystemFsm_progress", "ident_MetaSystemFsm_rmtErrCode", "ident_MetaSystemFsm_rmtErrDescr", "ident_MetaSystemFsm_rmtRslt", "ident_MetaSystem_fsmDescr", "ident_MetaSystem_fsmPrev", "ident_MetaSystem_fsmProgr", "ident_MetaSystem_fsmRmtInvErrCode", "ident_MetaSystem_fsmRmtInvErrDescr", "ident_MetaSystem_fsmRmtInvRslt", "ident_MetaSystem_fsmStageDescr", "ident_MetaSystem_fsmStamp", "ident_MetaSystem_fsmStatus", "ident_MetaSystem_fsmTry", "ident_MetaSystem_generation", "ident_MetaSystem_nextReqId", "ident_MetaSystem_sysid", "ident_RequestEp_reqDn", "ident_RequestEp_reqId", "ident_SysInfo_generation", "ident_SysInfo_isSync", "ident_SysInfo_isSyncAllowed", "imgprov_Policy_descr", "imgprov_Policy_intId", "imgprov_Policy_name", "imgprov_Policy_policyLevel", "imgprov_Policy_policyOwner", "imgprov_Target_name", "imgsec_Key_type", "imgsec_Key_value", "imgsec_Policy_descr", "imgsec_Policy_intId", "imgsec_Policy_name", "imgsec_Policy_policyLevel", "imgsec_Policy_policyOwner", "initiator_Ep_epDn", "initiator_FcInitiatorEp_epDn", "initiator_FcInitiatorEp_id", "initiator_FcInitiatorEp_name", "initiator_FcInitiatorEp_pref", "initiator_FcInitiatorEp_prot", "initiator_FcInitiatorEp_wwpn", "initiator_GroupEp_epDn", "initiator_GroupEp_id", "initiator_GroupEp_lc", "initiator_GroupEp_name", "initiator_GroupEp_polName", "initiator_GroupEp_rmtDiskCfgName", "initiator_IScsiInitiatorEp_epDn", "initiator_IScsiInitiatorEp_id", "initiator_IScsiInitiatorEp_iqn", "initiator_IScsiInitiatorEp_name", "initiator_IScsiInitiatorEp_pref", "initiator_IScsiInitiatorEp_prot", "initiator_InitiatorEp_epDn", "initiator_InitiatorEp_id", "initiator_InitiatorEp_name", "initiator_InitiatorEp_pref", "initiator_InitiatorEp_prot", "initiator_LunEp_bootable", "initiator_LunEp_epDn", "initiator_LunEp_id", "initiator_MemberEp_epDn", "initiator_MemberEp_id", "initiator_RequestorEp_allocState", "initiator_RequestorEp_epDn", "initiator_RequestorEp_id", "initiator_RequestorEp_sysId", "initiator_RequestorEp_sysName", "initiator_RequestorGrpEp_allocState", "initiator_RequestorGrpEp_epDn", "initiator_RequestorGrpEp_id", "initiator_RequestorGrpEp_lc", "initiator_RequestorGrpEp_polDn", "initiator_RequestorGrpEp_type", "initiator_StoreEp_epDn", "initiator_StoreEp_id", "initiator_StoreEp_type", "initiator_UnitEp_boot", "initiator_UnitEp_epDn", "initiator_UnitEp_ha", "initiator_UnitEp_id", "initiator_UnitEp_itemDn", "initiator_UnitEp_lc", "initiator_UnitEp_phyId", "initiator_UnitEp_prot", "ip_DnsSuffix_guid", "ip_DnsSuffix_host", "ip_DnsSuffix_name", "ip_IPv4Dns_addr", "ip_IPv4Dns_defGw", "ip_IPv4Dns_pref", "ip_IPv4Dns_subnet", "ip_IPv4WinsServer_IPv4Address", "ip_IPv4WinsServer_guid", "ip_IPv4WinsServer_host", "ip_IPv4WinsServer_name", "ip_IpV4Addr_addr", "ip_IpV4Addr_defGw", "ip_IpV4Addr_subnet", "ip_IpV4StaticAddr_addr", "ip_IpV4StaticAddr_defGw", "ip_IpV4StaticAddr_pref", "ip_IpV4StaticAddr_subnet", "ip_IpV4StaticTargetAddr_addr", "ip_IpV4StaticTargetAddr_defGw", "ip_IpV4StaticTargetAddr_subnet", "ip_ServiceIf_addr", "ip_ServiceIf_defGw", "ip_ServiceIf_port", "ip_ServiceIf_pref", "ip_ServiceIf_subnet", "ippool_Addr_assigned", "ippool_Addr_assignedToDn", "ippool_Addr_id", "ippool_Addr_owner", "ippool_Block_defGw", "ippool_Block_from", "ippool_Block_primDns", "ippool_Block_secDns", "ippool_Block_subnet", "ippool_Block_to", "ippool_IpV6Addr_assigned", "ippool_IpV6Addr_assignedToDn", "ippool_IpV6Addr_id", "ippool_IpV6Addr_owner", "ippool_IpV6Block_defGw", "ippool_IpV6Block_from", "ippool_IpV6Block_prefix", "ippool_IpV6Block_primDns", "ippool_IpV6Block_secDns", "ippool_IpV6Block_to", "ippool_IpV6Pooled_assigned", "ippool_IpV6Pooled_assignedToDn", "ippool_IpV6Pooled_defGw", "ippool_IpV6Pooled_id", "ippool_IpV6Pooled_poolableDn", "ippool_IpV6Pooled_prefix", "ippool_IpV6Pooled_prevAssignedToDn", "ippool_IpV6Pooled_primDns", "ippool_IpV6Pooled_secDns", "ippool_Pool_assigned", "ippool_Pool_assignmentOrder", "ippool_Pool_descr", "ippool_Pool_extManaged", "ippool_Pool_guid", "ippool_Pool_intId", "ippool_Pool_isNetBIOSEnabled", "ippool_Pool_name", "ippool_Pool_policyLevel", "ippool_Pool_policyOwner", "ippool_Pool_size", "ippool_Pool_supportsDHCP", "ippool_Poolable_id", "ippool_Poolable_poolDn", "ippool_Pooled_assigned", "ippool_Pooled_assignedToDn", "ippool_Pooled_defGw", "ippool_Pooled_id", "ippool_Pooled_poolableDn", "ippool_Pooled_prevAssignedToDn", "ippool_Pooled_primDns", "ippool_Pooled_secDns", "ippool_Pooled_subnet", "iqnpool_Addr_assigned", "iqnpool_Addr_assignedToDn", "iqnpool_Addr_name", "iqnpool_Addr_owner", "iqnpool_Block_from", "iqnpool_Block_suffix", "iqnpool_Block_to", "iqnpool_Format_format", "iqnpool_Pool_assigned", "iqnpool_Pool_assignmentOrder", "iqnpool_Pool_descr", "iqnpool_Pool_intId", "iqnpool_Pool_name", "iqnpool_Pool_policyLevel", "iqnpool_Pool_policyOwner", "iqnpool_Pool_prefix", "iqnpool_Pool_size", "iqnpool_Poolable_id", "iqnpool_Poolable_poolDn", "iqnpool_Pooled_assigned", "iqnpool_Pooled_assignedToDn", "iqnpool_Pooled_name", "iqnpool_Pooled_poolableDn", "iqnpool_Pooled_prevAssignedToDn", "iscsi_AuthProfile_ctpassword", "iscsi_AuthProfile_descr", "iscsi_AuthProfile_intId", "iscsi_AuthProfile_name", "iscsi_AuthProfile_password", "iscsi_AuthProfile_policyLevel", "iscsi_AuthProfile_policyOwner", "iscsi_AuthProfile_userId", "license_CapProvider_deleted", "license_CapProvider_deprecated", "license_CapProvider_elementLoadFailures", "license_CapProvider_elementsLoaded", "license_CapProvider_gencount", "license_CapProvider_loadErrors", "license_CapProvider_loadWarnings", "license_CapProvider_mgmtPlaneVer", "license_CapProvider_model", "license_CapProvider_revision", "license_CapProvider_vendor", "license_Contents_featureName", "license_Contents_totalQuant", "license_Contents_vendor", "license_Contents_version", "license_DownloaderFsmStage_descr", "license_DownloaderFsmStage_lastUpdateTime", "license_DownloaderFsmStage_name", "license_DownloaderFsmStage_order", "license_DownloaderFsmStage_retry", "license_DownloaderFsmStage_stageStatus", "license_DownloaderFsmTask_completion", "license_DownloaderFsmTask_flags", "license_DownloaderFsmTask_item", "license_DownloaderFsmTask_seqId", "license_DownloaderFsm_completionTime", "license_DownloaderFsm_currentFsm", "license_DownloaderFsm_descr", "license_DownloaderFsm_fsmStatus", "license_DownloaderFsm_instanceId", "license_DownloaderFsm_progress", "license_DownloaderFsm_rmtErrCode", "license_DownloaderFsm_rmtErrDescr", "license_DownloaderFsm_rmtRslt", "license_Downloader_adminState", "license_Downloader_fileName", "license_Downloader_fsmDescr", "license_Downloader_fsmPrev", "license_Downloader_fsmProgr", "license_Downloader_fsmRmtInvErrCode", "license_Downloader_fsmRmtInvErrDescr", "license_Downloader_fsmRmtInvRslt", "license_Downloader_fsmStageDescr", "license_Downloader_fsmStamp", "license_Downloader_fsmStatus", "license_Downloader_fsmTry", "license_Downloader_prot", "license_Downloader_pwd", "license_Downloader_remotePath", "license_Downloader_server", "license_Downloader_transferState", "license_Downloader_user", "license_FeatureCapProvider_defQuant", "license_FeatureCapProvider_deleted", "license_FeatureCapProvider_deprecated", "license_FeatureCapProvider_elementLoadFailures", "license_FeatureCapProvider_elementsLoaded", "license_FeatureCapProvider_featureName", "license_FeatureCapProvider_gencount", "license_FeatureCapProvider_gracePeriod", "license_FeatureCapProvider_licVendor", "license_FeatureCapProvider_licVersion", "license_FeatureCapProvider_loadErrors", "license_FeatureCapProvider_loadWarnings", "license_FeatureCapProvider_mgmtPlaneVer", "license_FeatureCapProvider_model", "license_FeatureCapProvider_revision", "license_FeatureCapProvider_sku", "license_FeatureCapProvider_type", "license_FeatureCapProvider_vendor", "license_FeatureLine_exp", "license_FeatureLine_id", "license_FeatureLine_pak", "license_FeatureLine_quant", "license_FeatureLine_sig", "license_FeatureLine_sku", "license_FeatureLine_type", "license_Feature_descr", "license_Feature_gracePeriod", "license_Feature_intId", "license_Feature_name", "license_Feature_policyLevel", "license_Feature_policyOwner", "license_Feature_type", "license_Feature_vendor", "license_Feature_version", "license_FileFsmStage_descr", "license_FileFsmStage_lastUpdateTime", "license_FileFsmStage_name", "license_FileFsmStage_order", "license_FileFsmStage_retry", "license_FileFsmStage_stageStatus", "license_FileFsmTask_completion", "license_FileFsmTask_flags", "license_FileFsmTask_item", "license_FileFsmTask_seqId", "license_FileFsm_completionTime", "license_FileFsm_currentFsm", "license_FileFsm_descr", "license_FileFsm_fsmStatus", "license_FileFsm_instanceId", "license_FileFsm_progress", "license_FileFsm_rmtErrCode", "license_FileFsm_rmtErrDescr", "license_FileFsm_rmtRslt", "license_File_adminState", "license_File_fsmDescr", "license_File_fsmPrev", "license_File_fsmProgr", "license_File_fsmRmtInvErrCode", "license_File_fsmRmtInvErrDescr", "license_File_fsmRmtInvRslt", "license_File_fsmStageDescr", "license_File_fsmStamp", "license_File_fsmStatus", "license_File_fsmTry", "license_File_id", "license_File_name", "license_File_operState", "license_File_operStateDescr", "license_File_scope", "license_File_version", "license_InstanceFsmStage_descr", "license_InstanceFsmStage_lastUpdateTime", "license_InstanceFsmStage_name", "license_InstanceFsmStage_order", "license_InstanceFsmStage_retry", "license_InstanceFsmStage_stageStatus", "license_InstanceFsmTask_completion", "license_InstanceFsmTask_flags", "license_InstanceFsmTask_item", "license_InstanceFsmTask_seqId", "license_InstanceFsm_completionTime", "license_InstanceFsm_currentFsm", "license_InstanceFsm_descr", "license_InstanceFsm_fsmStatus", "license_InstanceFsm_instanceId", "license_InstanceFsm_progress", "license_InstanceFsm_rmtErrCode", "license_InstanceFsm_rmtErrDescr", "license_InstanceFsm_rmtRslt", "license_Instance_absQuant", "license_Instance_defQuant", "license_Instance_feature", "license_Instance_fsmDescr", "license_Instance_fsmPrev", "license_Instance_fsmProgr", "license_Instance_fsmRmtInvErrCode", "license_Instance_fsmRmtInvErrDescr", "license_Instance_fsmRmtInvRslt", "license_Instance_fsmStageDescr", "license_Instance_fsmStamp", "license_Instance_fsmStatus", "license_Instance_fsmTry", "license_Instance_gracePeriodUsed", "license_Instance_isPresent", "license_Instance_operState", "license_Instance_peerStatus", "license_Instance_scope", "license_Instance_sku", "license_Instance_usedQuant", "license_Licensable_licGP", "license_Licensable_licState", "license_Prop_name", "license_Prop_value", "license_ServerHostId_hostId", "license_ServerHostId_scope", "license_SourceFile_exp", "license_SourceFile_hostId", "license_SourceFile_id", "license_SourceFile_line", "license_SourceFile_pak", "license_SourceFile_quant", "license_SourceFile_sig", "license_SourceFile_type", "license_Source_alwaysUse", "license_Source_hostId", "license_Source_hostName", "license_Source_sku", "license_Source_vendorDaemonPath", "lldp_Acquired_acqts", "lldp_Acquired_chassisMac", "lldp_Acquired_peerDn", "lldp_Acquired_portMac", "ls_AgentPolicy_capability", "ls_AgentPolicy_descr", "ls_AgentPolicy_intId", "ls_AgentPolicy_mode", "ls_AgentPolicy_name", "ls_AgentPolicy_policyLevel", "ls_AgentPolicy_policyOwner", "ls_Binding_assignedToDn", "ls_Binding_computeEpDn", "ls_Binding_issues", "ls_Binding_name", "ls_Binding_operState", "ls_Binding_pnDn", "ls_Binding_restrictMigration", "ls_ComputeBinding_assignedToDn", "ls_ComputeBinding_computeEpDn", "ls_ComputeBinding_issues", "ls_ComputeBinding_name", "ls_ComputeBinding_operState", "ls_ComputeBinding_pnDn", "ls_ComputeBinding_restrictMigration", "ls_FcLocale_switchId", "ls_FcZoneGroup_id", "ls_FcZoneGroup_name", "ls_FcZoneGroup_switchId", "ls_FcZoneMember_epDn", "ls_FcZoneMember_name", "ls_FcZoneMember_usrLbl", "ls_FcZone_adminState", "ls_FcZone_id", "ls_FcZone_identity", "ls_FcZone_iniName", "ls_FcZone_name", "ls_FcZone_operState", "ls_FcZone_peerDn", "ls_FcZone_switchId", "ls_FcZone_usrLbl", "ls_FcZone_vnetId", "ls_FcZone_zoningType", "ls_Issues_iscsiConfigIssues", "ls_Issues_networkConfigIssues", "ls_Issues_serverConfigIssues", "ls_Issues_storageConfigIssues", "ls_Issues_vnicConfigIssues", "ls_Power_state", "ls_Requirement_assignedToDn", "ls_Requirement_computeEpDn", "ls_Requirement_issues", "ls_Requirement_name", "ls_Requirement_operName", "ls_Requirement_operState", "ls_Requirement_pnDn", "ls_Requirement_pnPoolDn", "ls_Requirement_qualifier", "ls_Requirement_restrictMigration", "ls_ServerExtension_guid", "ls_ServerExtension_version", "ls_ServerFsmStage_descr", "ls_ServerFsmStage_lastUpdateTime", "ls_ServerFsmStage_name", "ls_ServerFsmStage_order", "ls_ServerFsmStage_retry", "ls_ServerFsmStage_stageStatus", "ls_ServerFsmTask_completion", "ls_ServerFsmTask_flags", "ls_ServerFsmTask_item", "ls_ServerFsmTask_seqId", "ls_ServerFsm_completionTime", "ls_ServerFsm_currentFsm", "ls_ServerFsm_descr", "ls_ServerFsm_fsmStatus", "ls_ServerFsm_instanceId", "ls_ServerFsm_progress", "ls_ServerFsm_rmtErrCode", "ls_ServerFsm_rmtErrDescr", "ls_ServerFsm_rmtRslt", "ls_Server_agentPolicyName", "ls_Server_assignState", "ls_Server_assocState", "ls_Server_biosProfileName", "ls_Server_bootPolicyName", "ls_Server_configQualifier", "ls_Server_configState", "ls_Server_descr", "ls_Server_dynamicConPolicyName", "ls_Server_extIPPoolName", "ls_Server_extIPState", "ls_Server_fsmDescr", "ls_Server_fsmFlags", "ls_Server_fsmPrev", "ls_Server_fsmProgr", "ls_Server_fsmRmtInvErrCode", "ls_Server_fsmRmtInvErrDescr", "ls_Server_fsmRmtInvRslt", "ls_Server_fsmStageDescr", "ls_Server_fsmStamp", "ls_Server_fsmStatus", "ls_Server_fsmTry", "ls_Server_hostFwPolicyName", "ls_Server_identPoolName", "ls_Server_intId", "ls_Server_localDiskPolicyName", "ls_Server_maintPolicyName", "ls_Server_mgmtAccessPolicyName", "ls_Server_mgmtFwPolicyName", "ls_Server_name", "ls_Server_operBiosProfileName", "ls_Server_operBootPolicyName", "ls_Server_operDynamicConPolicyName", "ls_Server_operExtIPPoolName", "ls_Server_operHostFwPolicyName", "ls_Server_operIdentPoolName", "ls_Server_operLocalDiskPolicyName", "ls_Server_operMaintPolicyName", "ls_Server_operMgmtAccessPolicyName", "ls_Server_operMgmtFwPolicyName", "ls_Server_operPowerPolicyName", "ls_Server_operScrubPolicyName", "ls_Server_operSolPolicyName", "ls_Server_operSrcTemplName", "ls_Server_operState", "ls_Server_operStatsPolicyName", "ls_Server_operVconProfileName", "ls_Server_owner", "ls_Server_pnDn", "ls_Server_policyLevel", "ls_Server_policyOwner", "ls_Server_powerPolicyName", "ls_Server_resolveRemote", "ls_Server_scrubPolicyName", "ls_Server_solPolicyName", "ls_Server_srcTemplName", "ls_Server_statsPolicyName", "ls_Server_type", "ls_Server_usrLbl", "ls_Server_uuid", "ls_Server_uuidSuffix", "ls_Server_vconProfileName", "ls_Tier_apply", "ls_Tier_descr", "ls_Tier_intId", "ls_Tier_name", "ls_Tier_policyLevel", "ls_Tier_policyOwner", "ls_Tier_srcTemplName", "ls_UuidHistory_olduuid", "ls_VConAssign_adminVcon", "ls_VConAssign_order", "ls_VConAssign_transport", "ls_VConAssign_vnicName", "ls_VersionBeh_pciEnum", "ls_VersionBeh_vconMap", "ls_VersionBeh_vnicMap", "ls_VersionBeh_vnicOrder", "ls_ZoneInitiatorMember_epDn", "ls_ZoneInitiatorMember_name", "ls_ZoneInitiatorMember_usrLbl", "ls_ZoneInitiatorMember_wwpn", "ls_ZoneTargetMember_epDn", "ls_ZoneTargetMember_name", "ls_ZoneTargetMember_usrLbl", "ls_ZoneTargetMember_wwpn", "lsboot_ADef_bootMode", "lsboot_ADef_descr", "lsboot_ADef_enforceVnicName", "lsboot_ADef_intId", "lsboot_ADef_name", "lsboot_ADef_policyLevel", "lsboot_ADef_policyOwner", "lsboot_ADef_purpose", "lsboot_ADef_rebootOnUpdate", "lsboot_BootSecurity_secureBoot", "lsboot_Category_access", "lsboot_Category_order", "lsboot_Category_type", "lsboot_Def_advBootOrderApplicable", "lsboot_Def_bootMode", "lsboot_Def_descr", "lsboot_Def_enforceVnicName", "lsboot_Def_intId", "lsboot_Def_name", "lsboot_Def_policyLevel", "lsboot_Def_policyOwner", "lsboot_Def_purpose", "lsboot_Def_rebootOnUpdate", "lsboot_DefaultLocalImage_order", "lsboot_DefaultLocalImage_type", "lsboot_IScsiImagePath_iSCSIVnicName", "lsboot_IScsiImagePath_type", "lsboot_IScsiImagePath_vnicName", "lsboot_IScsi_access", "lsboot_IScsi_order", "lsboot_IScsi_type", "lsboot_ImagePath_type", "lsboot_ImagePath_vnicName", "lsboot_LanImagePath_bootIpPolicyName", "lsboot_LanImagePath_iSCSIVnicName", "lsboot_LanImagePath_imgPolicyName", "lsboot_LanImagePath_imgSecPolicyName", "lsboot_LanImagePath_provSrvPolicyName", "lsboot_LanImagePath_type", "lsboot_LanImagePath_vnicName", "lsboot_Lan_access", "lsboot_Lan_order", "lsboot_Lan_prot", "lsboot_Lan_type", "lsboot_LocalHddImage_order", "lsboot_LocalHddImage_type", "lsboot_LocalMediaItem_order", "lsboot_LocalMediaItem_type", "lsboot_Policy_bootMode", "lsboot_Policy_descr", "lsboot_Policy_enforceVnicName", "lsboot_Policy_intId", "lsboot_Policy_name", "lsboot_Policy_policyLevel", "lsboot_Policy_policyOwner", "lsboot_Policy_purpose", "lsboot_Policy_rebootOnUpdate", "lsboot_RemoteImage_type", "lsboot_SanCatSanImagePath_lun", "lsboot_SanCatSanImagePath_type", "lsboot_SanCatSanImagePath_vnicName", "lsboot_SanCatSanImagePath_wwn", "lsboot_SanCatSanImage_type", "lsboot_SanCatSanImage_vnicName", "lsboot_SanImagePath_lun", "lsboot_SanImagePath_type", "lsboot_SanImagePath_vnicName", "lsboot_SanImagePath_wwn", "lsboot_SanImage_type", "lsboot_SanImage_vnicName", "lsboot_San_access", "lsboot_San_order", "lsboot_San_type", "lsboot_Storage_access", "lsboot_Storage_order", "lsboot_Storage_type", "lsboot_UsbExternalImage_order", "lsboot_UsbExternalImage_type", "lsboot_UsbFlashStorageImage_order", "lsboot_UsbFlashStorageImage_type", "lsboot_UsbInternalImage_order", "lsboot_UsbInternalImage_type", "lsboot_VirtualMedia_access", "lsboot_VirtualMedia_lunId", "lsboot_VirtualMedia_order", "lsboot_VirtualMedia_type", "lsmaint_Ack_acked", "lsmaint_Ack_ackedBy", "lsmaint_Ack_adminState", "lsmaint_Ack_autoDelete", "lsmaint_Ack_changeBy", "lsmaint_Ack_changeDetails", "lsmaint_Ack_changeMode", "lsmaint_Ack_changes", "lsmaint_Ack_configIssues", "lsmaint_Ack_deploymentMode", "lsmaint_Ack_descr", "lsmaint_Ack_disr", "lsmaint_Ack_ignoreCap", "lsmaint_Ack_intId", "lsmaint_Ack_modified", "lsmaint_Ack_name", "lsmaint_Ack_oldPnDn", "lsmaint_Ack_operScheduler", "lsmaint_Ack_operState", "lsmaint_Ack_policyLevel", "lsmaint_Ack_policyOwner", "lsmaint_Ack_prevOperState", "lsmaint_Ack_scheduler", "lsmaint_MaintPolicy_descr", "lsmaint_MaintPolicy_intId", "lsmaint_MaintPolicy_name", "lsmaint_MaintPolicy_operSchedName", "lsmaint_MaintPolicy_policyLevel", "lsmaint_MaintPolicy_policyOwner", "lsmaint_MaintPolicy_schedName", "lsmaint_MaintPolicy_uptimeDisr", "macpool_Addr_assigned", "macpool_Addr_assignedToDn", "macpool_Addr_id", "macpool_Addr_owner", "macpool_Block_from", "macpool_Block_to", "macpool_Format_format", "macpool_Format_mask", "macpool_Pool_assigned", "macpool_Pool_assignmentOrder", "macpool_Pool_descr", "macpool_Pool_intId", "macpool_Pool_name", "macpool_Pool_policyLevel", "macpool_Pool_policyOwner", "macpool_Pool_size", "macpool_Poolable_id", "macpool_Poolable_poolDn", "macpool_Pooled_assigned", "macpool_Pooled_assignedToDn", "macpool_Pooled_id", "macpool_Pooled_poolableDn", "macpool_Pooled_prevAssignedToDn", "memory_ArrayEnvStatsHist_id", "memory_ArrayEnvStatsHist_inputCurrent", "memory_ArrayEnvStatsHist_inputCurrentAvg", "memory_ArrayEnvStatsHist_inputCurrentMax", "memory_ArrayEnvStatsHist_inputCurrentMin", "memory_ArrayEnvStatsHist_mostRecent", "memory_ArrayEnvStatsHist_suspect", "memory_ArrayEnvStatsHist_thresholded", "memory_ArrayEnvStatsHist_timeCollected", "memory_ArrayEnvStats_inputCurrent", "memory_ArrayEnvStats_inputCurrentAvg", "memory_ArrayEnvStats_inputCurrentMax", "memory_ArrayEnvStats_inputCurrentMin", "memory_ArrayEnvStats_intervals", "memory_ArrayEnvStats_suspect", "memory_ArrayEnvStats_thresholded", "memory_ArrayEnvStats_timeCollected", "memory_ArrayEnvStats_update", "memory_Array_cpuId", "memory_Array_currCapacity", "memory_Array_errorCorrection", "memory_Array_id", "memory_Array_maxCapacity", "memory_Array_maxDevices", "memory_Array_model", "memory_Array_operQualifierReason", "memory_Array_operState", "memory_Array_operability", "memory_Array_perf", "memory_Array_populated", "memory_Array_power", "memory_Array_presence", "memory_Array_revision", "memory_Array_serial", "memory_Array_thermal", "memory_Array_vendor", "memory_Array_voltage", "memory_BufferUnitEnvStatsHist_id", "memory_BufferUnitEnvStatsHist_mostRecent", "memory_BufferUnitEnvStatsHist_suspect", "memory_BufferUnitEnvStatsHist_temperature", "memory_BufferUnitEnvStatsHist_temperatureAvg", "memory_BufferUnitEnvStatsHist_temperatureMax", "memory_BufferUnitEnvStatsHist_temperatureMin", "memory_BufferUnitEnvStatsHist_thresholded", "memory_BufferUnitEnvStatsHist_timeCollected", "memory_BufferUnitEnvStats_intervals", "memory_BufferUnitEnvStats_suspect", "memory_BufferUnitEnvStats_temperature", "memory_BufferUnitEnvStats_temperatureAvg", "memory_BufferUnitEnvStats_temperatureMax", "memory_BufferUnitEnvStats_temperatureMin", "memory_BufferUnitEnvStats_thresholded", "memory_BufferUnitEnvStats_timeCollected", "memory_BufferUnitEnvStats_update", "memory_BufferUnit_id", "memory_BufferUnit_model", "memory_BufferUnit_operQualifierReason", "memory_BufferUnit_operState", "memory_BufferUnit_operability", "memory_BufferUnit_perf", "memory_BufferUnit_power", "memory_BufferUnit_presence", "memory_BufferUnit_revision", "memory_BufferUnit_serial", "memory_BufferUnit_thermal", "memory_BufferUnit_vendor", "memory_BufferUnit_voltage", "memory_ErrorStats_addressParityErrors", "memory_ErrorStats_addressParityErrors15Min", "memory_ErrorStats_addressParityErrors15MinH", "memory_ErrorStats_addressParityErrors1Day", "memory_ErrorStats_addressParityErrors1DayH", "memory_ErrorStats_addressParityErrors1Hour", "memory_ErrorStats_addressParityErrors1HourH", "memory_ErrorStats_addressParityErrors1Week", "memory_ErrorStats_addressParityErrors1WeekH", "memory_ErrorStats_addressParityErrors2Weeks", "memory_ErrorStats_addressParityErrors2WeeksH", "memory_ErrorStats_eccMultibitErrors", "memory_ErrorStats_eccMultibitErrors15Min", "memory_ErrorStats_eccMultibitErrors15MinH", "memory_ErrorStats_eccMultibitErrors1Day", "memory_ErrorStats_eccMultibitErrors1DayH", "memory_ErrorStats_eccMultibitErrors1Hour", "memory_ErrorStats_eccMultibitErrors1HourH", "memory_ErrorStats_eccMultibitErrors1Week", "memory_ErrorStats_eccMultibitErrors1WeekH", "memory_ErrorStats_eccMultibitErrors2Weeks", "memory_ErrorStats_eccMultibitErrors2WeeksH", "memory_ErrorStats_eccSinglebitErrors", "memory_ErrorStats_eccSinglebitErrors15Min", "memory_ErrorStats_eccSinglebitErrors15MinH", "memory_ErrorStats_eccSinglebitErrors1Day", "memory_ErrorStats_eccSinglebitErrors1DayH", "memory_ErrorStats_eccSinglebitErrors1Hour", "memory_ErrorStats_eccSinglebitErrors1HourH", "memory_ErrorStats_eccSinglebitErrors1Week", "memory_ErrorStats_eccSinglebitErrors1WeekH", "memory_ErrorStats_eccSinglebitErrors2Weeks", "memory_ErrorStats_eccSinglebitErrors2WeeksH", "memory_ErrorStats_intervals", "memory_ErrorStats_mismatchErrors", "memory_ErrorStats_mismatchErrors15Min", "memory_ErrorStats_mismatchErrors15MinH", "memory_ErrorStats_mismatchErrors1Day", "memory_ErrorStats_mismatchErrors1DayH", "memory_ErrorStats_mismatchErrors1Hour", "memory_ErrorStats_mismatchErrors1HourH", "memory_ErrorStats_mismatchErrors1Week", "memory_ErrorStats_mismatchErrors1WeekH", "memory_ErrorStats_mismatchErrors2Weeks", "memory_ErrorStats_mismatchErrors2WeeksH", "memory_ErrorStats_suspect", "memory_ErrorStats_thresholded", "memory_ErrorStats_timeCollected", "memory_ErrorStats_update", "memory_Qual_clock", "memory_Qual_latency", "memory_Qual_maxCap", "memory_Qual_minCap", "memory_Qual_speed", "memory_Qual_units", "memory_Qual_width", "memory_RuntimeHist_available", "memory_RuntimeHist_availableAvg", "memory_RuntimeHist_availableMax", "memory_RuntimeHist_availableMin", "memory_RuntimeHist_cached", "memory_RuntimeHist_cachedAvg", "memory_RuntimeHist_cachedMax", "memory_RuntimeHist_cachedMin", "memory_RuntimeHist_id", "memory_RuntimeHist_mostRecent", "memory_RuntimeHist_suspect", "memory_RuntimeHist_thresholded", "memory_RuntimeHist_timeCollected", "memory_RuntimeHist_total", "memory_RuntimeHist_totalAvg", "memory_RuntimeHist_totalMax", "memory_RuntimeHist_totalMin", "memory_Runtime_available", "memory_Runtime_availableAvg", "memory_Runtime_availableMax", "memory_Runtime_availableMin", "memory_Runtime_cached", "memory_Runtime_cachedAvg", "memory_Runtime_cachedMax", "memory_Runtime_cachedMin", "memory_Runtime_intervals", "memory_Runtime_suspect", "memory_Runtime_thresholded", "memory_Runtime_timeCollected", "memory_Runtime_total", "memory_Runtime_totalAvg", "memory_Runtime_totalMax", "memory_Runtime_totalMin", "memory_Runtime_type", "memory_Runtime_update", "memory_UnitEnvStatsHist_id", "memory_UnitEnvStatsHist_mostRecent", "memory_UnitEnvStatsHist_suspect", "memory_UnitEnvStatsHist_temperature", "memory_UnitEnvStatsHist_temperatureAvg", "memory_UnitEnvStatsHist_temperatureMax", "memory_UnitEnvStatsHist_temperatureMin", "memory_UnitEnvStatsHist_thresholded", "memory_UnitEnvStatsHist_timeCollected", "memory_UnitEnvStats_intervals", "memory_UnitEnvStats_suspect", "memory_UnitEnvStats_temperature", "memory_UnitEnvStats_temperatureAvg", "memory_UnitEnvStats_temperatureMax", "memory_UnitEnvStats_temperatureMin", "memory_UnitEnvStats_thresholded", "memory_UnitEnvStats_timeCollected", "memory_UnitEnvStats_update", "memory_Unit_adminState", "memory_Unit_array", "memory_Unit_bank", "memory_Unit_capacity", "memory_Unit_clock", "memory_Unit_formFactor", "memory_Unit_id", "memory_Unit_latency", "memory_Unit_location", "memory_Unit_model", "memory_Unit_operQualifier", "memory_Unit_operQualifierReason", "memory_Unit_operState", "memory_Unit_operability", "memory_Unit_perf", "memory_Unit_power", "memory_Unit_presence", "memory_Unit_revision", "memory_Unit_serial", "memory_Unit_set", "memory_Unit_speed", "memory_Unit_thermal", "memory_Unit_type", "memory_Unit_vendor", "memory_Unit_visibility", "memory_Unit_voltage", "memory_Unit_width", "mgmt_AccessPolicyItem_descr", "mgmt_AccessPolicyItem_intId", "mgmt_AccessPolicyItem_ipPoolName", "mgmt_AccessPolicyItem_name", "mgmt_AccessPolicyItem_policyLevel", "mgmt_AccessPolicyItem_policyOwner", "mgmt_AccessPolicyItem_subject", "mgmt_AccessPort_port", "mgmt_AccessPort_protocol", "mgmt_BackupFsmStage_descr", "mgmt_BackupFsmStage_lastUpdateTime", "mgmt_BackupFsmStage_name", "mgmt_BackupFsmStage_order", "mgmt_BackupFsmStage_retry", "mgmt_BackupFsmStage_stageStatus", "mgmt_BackupFsmTask_completion", "mgmt_BackupFsmTask_flags", "mgmt_BackupFsmTask_item", "mgmt_BackupFsmTask_seqId", "mgmt_BackupFsm_completionTime", "mgmt_BackupFsm_currentFsm", "mgmt_BackupFsm_descr", "mgmt_BackupFsm_fsmStatus", "mgmt_BackupFsm_instanceId", "mgmt_BackupFsm_progress", "mgmt_BackupFsm_rmtErrCode", "mgmt_BackupFsm_rmtErrDescr", "mgmt_BackupFsm_rmtRslt", "mgmt_BackupPolicyFsmStage_descr", "mgmt_BackupPolicyFsmStage_lastUpdateTime", "mgmt_BackupPolicyFsmStage_name", "mgmt_BackupPolicyFsmStage_order", "mgmt_BackupPolicyFsmStage_retry", "mgmt_BackupPolicyFsmStage_stageStatus", "mgmt_BackupPolicyFsm_completionTime", "mgmt_BackupPolicyFsm_currentFsm", "mgmt_BackupPolicyFsm_descr", "mgmt_BackupPolicyFsm_fsmStatus", "mgmt_BackupPolicyFsm_instanceId", "mgmt_BackupPolicyFsm_progress", "mgmt_BackupPolicyFsm_rmtErrCode", "mgmt_BackupPolicyFsm_rmtErrDescr", "mgmt_BackupPolicyFsm_rmtRslt", "mgmt_BackupPolicy_adminState", "mgmt_BackupPolicy_descr", "mgmt_BackupPolicy_fsmDescr", "mgmt_BackupPolicy_fsmPrev", "mgmt_BackupPolicy_fsmProgr", "mgmt_BackupPolicy_fsmRmtInvErrCode", "mgmt_BackupPolicy_fsmRmtInvErrDescr", "mgmt_BackupPolicy_fsmRmtInvRslt", "mgmt_BackupPolicy_fsmStageDescr", "mgmt_BackupPolicy_fsmStamp", "mgmt_BackupPolicy_fsmStatus", "mgmt_BackupPolicy_fsmTry", "mgmt_BackupPolicy_host", "mgmt_BackupPolicy_intId", "mgmt_BackupPolicy_lastBackup", "mgmt_BackupPolicy_maxFiles", "mgmt_BackupPolicy_name", "mgmt_BackupPolicy_policyLevel", "mgmt_BackupPolicy_policyOwner", "mgmt_BackupPolicy_proto", "mgmt_BackupPolicy_pwd", "mgmt_BackupPolicy_remoteFile", "mgmt_BackupPolicy_schedule", "mgmt_BackupPolicy_user", "mgmt_Backup_adminState", "mgmt_Backup_descr", "mgmt_Backup_fsmDescr", "mgmt_Backup_fsmPrev", "mgmt_Backup_fsmProgr", "mgmt_Backup_fsmRmtInvErrCode", "mgmt_Backup_fsmRmtInvErrDescr", "mgmt_Backup_fsmRmtInvRslt", "mgmt_Backup_fsmStageDescr", "mgmt_Backup_fsmStamp", "mgmt_Backup_fsmStatus", "mgmt_Backup_fsmTry", "mgmt_Backup_hostname", "mgmt_Backup_intId", "mgmt_Backup_job", "mgmt_Backup_maxFiles", "mgmt_Backup_name", "mgmt_Backup_ownerPolicy", "mgmt_Backup_policyLevel", "mgmt_Backup_policyOwner", "mgmt_Backup_postAction", "mgmt_Backup_preservePooledValues", "mgmt_Backup_proto", "mgmt_Backup_pwd", "mgmt_Backup_remoteFile", "mgmt_Backup_type", "mgmt_Backup_user", "mgmt_CfgExportPolicyFsmStage_descr", "mgmt_CfgExportPolicyFsmStage_lastUpdateTime", "mgmt_CfgExportPolicyFsmStage_name", "mgmt_CfgExportPolicyFsmStage_order", "mgmt_CfgExportPolicyFsmStage_retry", "mgmt_CfgExportPolicyFsmStage_stageStatus", "mgmt_CfgExportPolicyFsm_completionTime", "mgmt_CfgExportPolicyFsm_currentFsm", "mgmt_CfgExportPolicyFsm_descr", "mgmt_CfgExportPolicyFsm_fsmStatus", "mgmt_CfgExportPolicyFsm_instanceId", "mgmt_CfgExportPolicyFsm_progress", "mgmt_CfgExportPolicyFsm_rmtErrCode", "mgmt_CfgExportPolicyFsm_rmtErrDescr", "mgmt_CfgExportPolicyFsm_rmtRslt", "mgmt_CfgExportPolicy_adminState", "mgmt_CfgExportPolicy_descr", "mgmt_CfgExportPolicy_fsmDescr", "mgmt_CfgExportPolicy_fsmPrev", "mgmt_CfgExportPolicy_fsmProgr", "mgmt_CfgExportPolicy_fsmRmtInvErrCode", "mgmt_CfgExportPolicy_fsmRmtInvErrDescr", "mgmt_CfgExportPolicy_fsmRmtInvRslt", "mgmt_CfgExportPolicy_fsmStageDescr", "mgmt_CfgExportPolicy_fsmStamp", "mgmt_CfgExportPolicy_fsmStatus", "mgmt_CfgExportPolicy_fsmTry", "mgmt_CfgExportPolicy_host", "mgmt_CfgExportPolicy_intId", "mgmt_CfgExportPolicy_lastBackup", "mgmt_CfgExportPolicy_maxFiles", "mgmt_CfgExportPolicy_name", "mgmt_CfgExportPolicy_policyLevel", "mgmt_CfgExportPolicy_policyOwner", "mgmt_CfgExportPolicy_proto", "mgmt_CfgExportPolicy_pwd", "mgmt_CfgExportPolicy_remoteFile", "mgmt_CfgExportPolicy_schedule", "mgmt_CfgExportPolicy_user", "mgmt_CimcInterface_configMessage", "mgmt_CimcInterface_configState", "mgmt_CimcInterface_ipV4State", "mgmt_CimcInterface_ipV6State", "mgmt_CimcInterface_mode", "mgmt_CimcInterface_operState", "mgmt_Connection_ack", "mgmt_Connection_operState", "mgmt_Connection_type", "mgmt_ControllerFsmStage_descr", "mgmt_ControllerFsmStage_lastUpdateTime", "mgmt_ControllerFsmStage_name", "mgmt_ControllerFsmStage_order", "mgmt_ControllerFsmStage_retry", "mgmt_ControllerFsmStage_stageStatus", "mgmt_ControllerFsmTask_completion", "mgmt_ControllerFsmTask_flags", "mgmt_ControllerFsmTask_item", "mgmt_ControllerFsmTask_seqId", "mgmt_ControllerFsm_completionTime", "mgmt_ControllerFsm_currentFsm", "mgmt_ControllerFsm_descr", "mgmt_ControllerFsm_fsmStatus", "mgmt_ControllerFsm_instanceId", "mgmt_ControllerFsm_progress", "mgmt_ControllerFsm_rmtErrCode", "mgmt_ControllerFsm_rmtErrDescr", "mgmt_ControllerFsm_rmtRslt", "mgmt_Controller_dimmBlacklistingOperState", "mgmt_Controller_fsmDescr", "mgmt_Controller_fsmFlags", "mgmt_Controller_fsmPrev", "mgmt_Controller_fsmProgr", "mgmt_Controller_fsmRmtInvErrCode", "mgmt_Controller_fsmRmtInvErrDescr", "mgmt_Controller_fsmRmtInvRslt", "mgmt_Controller_fsmStageDescr", "mgmt_Controller_fsmStamp", "mgmt_Controller_fsmStatus", "mgmt_Controller_fsmTry", "mgmt_Controller_guid", "mgmt_Controller_model", "mgmt_Controller_operConn", "mgmt_Controller_revision", "mgmt_Controller_serial", "mgmt_Controller_storageOobInterfaceSupported", "mgmt_Controller_storageSubsystemState", "mgmt_Controller_subject", "mgmt_Controller_vendor", "mgmt_Entity_chassis1", "mgmt_Entity_chassis2", "mgmt_Entity_chassis3", "mgmt_Entity_chassisDeviceIoState1", "mgmt_Entity_chassisDeviceIoState2", "mgmt_Entity_chassisDeviceIoState3", "mgmt_Entity_haFailureReason", "mgmt_Entity_haReadiness", "mgmt_Entity_haReady", "mgmt_Entity_id", "mgmt_Entity_leadership", "mgmt_Entity_mgmtServicesState", "mgmt_Entity_problems", "mgmt_Entity_sshAuthKeysCsum", "mgmt_Entity_sshAuthKeysSize", "mgmt_Entity_sshKeyStatus", "mgmt_Entity_sshRootPubKeyCsum", "mgmt_Entity_sshRootPubKeySize", "mgmt_Entity_state", "mgmt_Entity_umbilicalState", "mgmt_Entity_versionMismatch", "mgmt_ExportPolicyFsmStage_descr", "mgmt_ExportPolicyFsmStage_lastUpdateTime", "mgmt_ExportPolicyFsmStage_name", "mgmt_ExportPolicyFsmStage_order", "mgmt_ExportPolicyFsmStage_retry", "mgmt_ExportPolicyFsmStage_stageStatus", "mgmt_ExportPolicyFsmTask_completion", "mgmt_ExportPolicyFsmTask_flags", "mgmt_ExportPolicyFsmTask_item", "mgmt_ExportPolicyFsmTask_seqId", "mgmt_ExportPolicyFsm_completionTime", "mgmt_ExportPolicyFsm_currentFsm", "mgmt_ExportPolicyFsm_descr", "mgmt_ExportPolicyFsm_fsmStatus", "mgmt_ExportPolicyFsm_instanceId", "mgmt_ExportPolicyFsm_progress", "mgmt_ExportPolicyFsm_rmtErrCode", "mgmt_ExportPolicyFsm_rmtErrDescr", "mgmt_ExportPolicyFsm_rmtRslt", "mgmt_ExportPolicy_adminState", "mgmt_ExportPolicy_descr", "mgmt_ExportPolicy_fsmDescr", "mgmt_ExportPolicy_fsmPrev", "mgmt_ExportPolicy_fsmProgr", "mgmt_ExportPolicy_fsmRmtInvErrCode", "mgmt_ExportPolicy_fsmRmtInvErrDescr", "mgmt_ExportPolicy_fsmRmtInvRslt", "mgmt_ExportPolicy_fsmStageDescr", "mgmt_ExportPolicy_fsmStamp", "mgmt_ExportPolicy_fsmStatus", "mgmt_ExportPolicy_fsmTry", "mgmt_ExportPolicy_host", "mgmt_ExportPolicy_intId", "mgmt_ExportPolicy_lastBackup", "mgmt_ExportPolicy_maxFiles", "mgmt_ExportPolicy_name", "mgmt_ExportPolicy_policyLevel", "mgmt_ExportPolicy_policyOwner", "mgmt_ExportPolicy_proto", "mgmt_ExportPolicy_pwd", "mgmt_ExportPolicy_remoteFile", "mgmt_ExportPolicy_schedule", "mgmt_ExportPolicy_user", "mgmt_IPv6Addr_addr", "mgmt_IPv6Addr_defGw", "mgmt_IPv6Addr_prefix", "mgmt_IPv6IfAddrFsmStage_descr", "mgmt_IPv6IfAddrFsmStage_lastUpdateTime", "mgmt_IPv6IfAddrFsmStage_name", "mgmt_IPv6IfAddrFsmStage_order", "mgmt_IPv6IfAddrFsmStage_retry", "mgmt_IPv6IfAddrFsmStage_stageStatus", "mgmt_IPv6IfAddrFsmTask_completion", "mgmt_IPv6IfAddrFsmTask_flags", "mgmt_IPv6IfAddrFsmTask_item", "mgmt_IPv6IfAddrFsmTask_seqId", "mgmt_IPv6IfAddrFsm_completionTime", "mgmt_IPv6IfAddrFsm_currentFsm", "mgmt_IPv6IfAddrFsm_descr", "mgmt_IPv6IfAddrFsm_fsmStatus", "mgmt_IPv6IfAddrFsm_instanceId", "mgmt_IPv6IfAddrFsm_progress", "mgmt_IPv6IfAddrFsm_rmtErrCode", "mgmt_IPv6IfAddrFsm_rmtErrDescr", "mgmt_IPv6IfAddrFsm_rmtRslt", "mgmt_IPv6IfAddr_addr", "mgmt_IPv6IfAddr_defGw", "mgmt_IPv6IfAddr_fsmDescr", "mgmt_IPv6IfAddr_fsmPrev", "mgmt_IPv6IfAddr_fsmProgr", "mgmt_IPv6IfAddr_fsmRmtInvErrCode", "mgmt_IPv6IfAddr_fsmRmtInvErrDescr", "mgmt_IPv6IfAddr_fsmRmtInvRslt", "mgmt_IPv6IfAddr_fsmStageDescr", "mgmt_IPv6IfAddr_fsmStamp", "mgmt_IPv6IfAddr_fsmStatus", "mgmt_IPv6IfAddr_fsmTry", "mgmt_IPv6IfAddr_prefix", "mgmt_IfFsmStage_descr", "mgmt_IfFsmStage_lastUpdateTime", "mgmt_IfFsmStage_name", "mgmt_IfFsmStage_order", "mgmt_IfFsmStage_retry", "mgmt_IfFsmStage_stageStatus", "mgmt_IfFsmTask_completion", "mgmt_IfFsmTask_flags", "mgmt_IfFsmTask_item", "mgmt_IfFsmTask_seqId", "mgmt_IfFsm_completionTime", "mgmt_IfFsm_currentFsm", "mgmt_IfFsm_descr", "mgmt_IfFsm_fsmStatus", "mgmt_IfFsm_instanceId", "mgmt_IfFsm_progress", "mgmt_IfFsm_rmtErrCode", "mgmt_IfFsm_rmtErrDescr", "mgmt_IfFsm_rmtRslt", "mgmt_If_access", "mgmt_If_adminState", "mgmt_If_chassisId", "mgmt_If_discovery", "mgmt_If_epDn", "mgmt_If_extBroadcast", "mgmt_If_extGw", "mgmt_If_extIp", "mgmt_If_extMask", "mgmt_If_fsmDescr", "mgmt_If_fsmPrev", "mgmt_If_fsmProgr", "mgmt_If_fsmRmtInvErrCode", "mgmt_If_fsmRmtInvErrDescr", "mgmt_If_fsmRmtInvRslt", "mgmt_If_fsmStageDescr", "mgmt_If_fsmStamp", "mgmt_If_fsmStatus", "mgmt_If_fsmTry", "mgmt_If_id", "mgmt_If_ifRole", "mgmt_If_ifType", "mgmt_If_ip", "mgmt_If_locale", "mgmt_If_mac", "mgmt_If_mask", "mgmt_If_name", "mgmt_If_peerChassisId", "mgmt_If_peerDn", "mgmt_If_peerPortId", "mgmt_If_peerSlotId", "mgmt_If_portId", "mgmt_If_slotId", "mgmt_If_stateQual", "mgmt_If_subject", "mgmt_If_switchId", "mgmt_If_transport", "mgmt_If_type", "mgmt_If_vnet", "mgmt_ImporterFsmStage_descr", "mgmt_ImporterFsmStage_lastUpdateTime", "mgmt_ImporterFsmStage_name", "mgmt_ImporterFsmStage_order", "mgmt_ImporterFsmStage_retry", "mgmt_ImporterFsmStage_stageStatus", "mgmt_ImporterFsmTask_completion", "mgmt_ImporterFsmTask_flags", "mgmt_ImporterFsmTask_item", "mgmt_ImporterFsmTask_seqId", "mgmt_ImporterFsm_completionTime", "mgmt_ImporterFsm_currentFsm", "mgmt_ImporterFsm_descr", "mgmt_ImporterFsm_fsmStatus", "mgmt_ImporterFsm_instanceId", "mgmt_ImporterFsm_progress", "mgmt_ImporterFsm_rmtErrCode", "mgmt_ImporterFsm_rmtErrDescr", "mgmt_ImporterFsm_rmtRslt", "mgmt_Importer_action", "mgmt_Importer_adminState", "mgmt_Importer_descr", "mgmt_Importer_fsmDescr", "mgmt_Importer_fsmPrev", "mgmt_Importer_fsmProgr", "mgmt_Importer_fsmRmtInvErrCode", "mgmt_Importer_fsmRmtInvErrDescr", "mgmt_Importer_fsmRmtInvRslt", "mgmt_Importer_fsmStageDescr", "mgmt_Importer_fsmStamp", "mgmt_Importer_fsmStatus", "mgmt_Importer_fsmTry", "mgmt_Importer_hostname", "mgmt_Importer_intId", "mgmt_Importer_name", "mgmt_Importer_operStatus", "mgmt_Importer_policyLevel", "mgmt_Importer_policyOwner", "mgmt_Importer_postAction", "mgmt_Importer_proto", "mgmt_Importer_pwd", "mgmt_Importer_remoteFile", "mgmt_Importer_user", "mgmt_InbandProfile_defaultVlanName", "mgmt_InbandProfile_name", "mgmt_InbandProfile_poolName", "mgmt_IntAuthPolicy_method", "mgmt_IntAuthPolicy_name", "mgmt_IntAuthPolicy_pwd", "mgmt_Interface_configMessage", "mgmt_Interface_configState", "mgmt_Interface_ipV4State", "mgmt_Interface_ipV6State", "mgmt_Interface_isDefaultDerived", "mgmt_Interface_mode", "mgmt_Interface_operState", "mgmt_PmonEntry_exitSignal", "mgmt_PmonEntry_fullPathname", "mgmt_PmonEntry_heapSize", "mgmt_PmonEntry_heapSize16Gb", "mgmt_PmonEntry_lastExitCode", "mgmt_PmonEntry_maxRetries", "mgmt_PmonEntry_name", "mgmt_PmonEntry_retries", "mgmt_PmonEntry_spuriousRetries", "mgmt_PmonEntry_state", "mgmt_PmonEntry_switchId", "mgmt_PmonEntry_workingDirectory", "mgmt_ProfDerivedInterface_configMessage", "mgmt_ProfDerivedInterface_configState", "mgmt_ProfDerivedInterface_ipV4State", "mgmt_ProfDerivedInterface_ipV6State", "mgmt_ProfDerivedInterface_mode", "mgmt_ProfDerivedInterface_operState", "mgmt_Vnet_configState", "mgmt_Vnet_id", "mgmt_Vnet_name", "naming_Described_descr", "naming_Identified_id", "naming_NamedIdentifiedObject_id", "naming_NamedIdentifiedObject_name", "naming_NamedObject_name", "naming_Named_name", "network_CIoEp_epDn", "network_CIoEp_ifRole", "network_CIoEp_ifType", "network_CIoEp_locale", "network_CIoEp_name", "network_CIoEp_peerDn", "network_CIoEp_portId", "network_CIoEp_switchId", "network_CIoEp_transport", "network_CIoEp_type", "network_Conn_locale", "network_Conn_name", "network_Conn_transport", "network_Conn_type", "network_DomainEp_epDn", "network_DomainEp_ifRole", "network_DomainEp_ifType", "network_DomainEp_locale", "network_DomainEp_name", "network_DomainEp_peerDn", "network_DomainEp_transport", "network_DomainEp_type", "network_Element_adminInbandIfState", "network_Element_id", "network_Element_inbandIfGw", "network_Element_inbandIfIp", "network_Element_inbandIfMask", "network_Element_inbandIfVnet", "network_Element_inventoryStatus", "network_Element_model", "network_Element_oobIfGw", "network_Element_oobIfIp", "network_Element_oobIfMask", "network_Element_operability", "network_Element_revision", "network_Element_serial", "network_Element_thermal", "network_Element_totalMemory", "network_Element_vendor", "network_Ep_epDn", "network_Ep_locale", "network_Ep_name", "network_Ep_transport", "network_Ep_type", "network_IfEp_epDn", "network_IfEp_ifRole", "network_IfEp_ifType", "network_IfEp_locale", "network_IfEp_name", "network_IfEp_peerDn", "network_IfEp_transport", "network_IfEp_type", "network_IfStats_in", "network_IfStats_out", "network_IfStats_type", "network_IfStats_units", "network_OperLevel_id", "network_OperLevel_maxPrimaryVlanCount", "network_OperLevel_primaryVlanCount", "network_OperLevel_primaryVlanCountStatus", "network_PIoEp_chassisId", "network_PIoEp_epDn", "network_PIoEp_ifRole", "network_PIoEp_ifType", "network_PIoEp_locale", "network_PIoEp_name", "network_PIoEp_peerChassisId", "network_PIoEp_peerDn", "network_PIoEp_peerPortId", "network_PIoEp_peerSlotId", "network_PIoEp_portId", "network_PIoEp_slotId", "network_PIoEp_switchId", "network_PIoEp_transport", "network_PIoEp_type", "network_PhysEp_chassisId", "network_PhysEp_epDn", "network_PhysEp_ifRole", "network_PhysEp_ifType", "network_PhysEp_locale", "network_PhysEp_name", "network_PhysEp_peerChassisId", "network_PhysEp_peerDn", "network_PhysEp_peerPortId", "network_PhysEp_peerSlotId", "network_PhysEp_portId", "network_PhysEp_slotId", "network_PhysEp_switchId", "network_PhysEp_transport", "network_PhysEp_type", "network_VnetEp_epDn", "network_VnetEp_id", "network_VnetEp_ifRole", "network_VnetEp_ifType", "network_VnetEp_locale", "network_VnetEp_name", "network_VnetEp_peerDn", "network_VnetEp_transport", "network_VnetEp_type", "networkrule_Definition_descr", "networkrule_Definition_intId", "networkrule_Definition_name", "networkrule_Definition_policyLevel", "networkrule_Definition_policyOwner", "networkrule_Item_name", "nfs_MountDefFsmStage_descr", "nfs_MountDefFsmStage_lastUpdateTime", "nfs_MountDefFsmStage_name", "nfs_MountDefFsmStage_order", "nfs_MountDefFsmStage_retry", "nfs_MountDefFsmStage_stageStatus", "nfs_MountDefFsmTask_completion", "nfs_MountDefFsmTask_flags", "nfs_MountDefFsmTask_item", "nfs_MountDefFsmTask_seqId", "nfs_MountDefFsm_completionTime", "nfs_MountDefFsm_currentFsm", "nfs_MountDefFsm_descr", "nfs_MountDefFsm_fsmStatus", "nfs_MountDefFsm_instanceId", "nfs_MountDefFsm_progress", "nfs_MountDefFsm_rmtErrCode", "nfs_MountDefFsm_rmtErrDescr", "nfs_MountDefFsm_rmtRslt", "nfs_MountDef_adminState", "nfs_MountDef_descr", "nfs_MountDef_fsmDescr", "nfs_MountDef_fsmPrev", "nfs_MountDef_fsmProgr", "nfs_MountDef_fsmRmtInvErrCode", "nfs_MountDef_fsmRmtInvErrDescr", "nfs_MountDef_fsmRmtInvRslt", "nfs_MountDef_fsmStageDescr", "nfs_MountDef_fsmStamp", "nfs_MountDef_fsmStatus", "nfs_MountDef_fsmTry", "nfs_MountDef_intId", "nfs_MountDef_localDir", "nfs_MountDef_name", "nfs_MountDef_policyLevel", "nfs_MountDef_policyOwner", "nfs_MountDef_purpose", "nfs_MountDef_remoteDir", "nfs_MountDef_server", "nfs_MountInstFsmStage_descr", "nfs_MountInstFsmStage_lastUpdateTime", "nfs_MountInstFsmStage_name", "nfs_MountInstFsmStage_order", "nfs_MountInstFsmStage_retry", "nfs_MountInstFsmStage_stageStatus", "nfs_MountInstFsmTask_completion", "nfs_MountInstFsmTask_flags", "nfs_MountInstFsmTask_item", "nfs_MountInstFsmTask_seqId", "nfs_MountInstFsm_completionTime", "nfs_MountInstFsm_currentFsm", "nfs_MountInstFsm_descr", "nfs_MountInstFsm_fsmStatus", "nfs_MountInstFsm_instanceId", "nfs_MountInstFsm_progress", "nfs_MountInstFsm_rmtErrCode", "nfs_MountInstFsm_rmtErrDescr", "nfs_MountInstFsm_rmtRslt", "nfs_MountInst_adminState", "nfs_MountInst_clientConfigState", "nfs_MountInst_defDn", "nfs_MountInst_fsmDescr", "nfs_MountInst_fsmPrev", "nfs_MountInst_fsmProgr", "nfs_MountInst_fsmRmtInvErrCode", "nfs_MountInst_fsmRmtInvErrDescr", "nfs_MountInst_fsmRmtInvRslt", "nfs_MountInst_fsmStageDescr", "nfs_MountInst_fsmStamp", "nfs_MountInst_fsmStatus", "nfs_MountInst_fsmTry", "nfs_MountInst_localDir", "nfs_MountInst_name", "nfs_MountInst_operState", "nfs_MountInst_purpose", "nfs_MountInst_remoteDir", "nfs_MountInst_server", "nwctrl_Definition_cdp", "nwctrl_Definition_descr", "nwctrl_Definition_intId", "nwctrl_Definition_macRegisterMode", "nwctrl_Definition_name", "nwctrl_Definition_policyLevel", "nwctrl_Definition_policyOwner", "nwctrl_Definition_uplinkFailAction", "observe_Filter_andOperation", "observe_Filter_childClassId", "observe_Filter_filterClassId", "observe_Filter_filterPropId1", "observe_Filter_filterPropId2", "observe_Filter_filterPropId3", "observe_Filter_filterPropValue1", "observe_Filter_filterPropValue2", "observe_Filter_filterPropValue3", "observe_Filter_hierarchical", "observe_Filter_replicateIfNoChild", "observe_ObservedCont_idCount", "observe_ObservedFsmStage_descr", "observe_ObservedFsmStage_lastUpdateTime", "observe_ObservedFsmStage_name", "observe_ObservedFsmStage_order", "observe_ObservedFsmStage_retry", "observe_ObservedFsmStage_stageStatus", "observe_ObservedFsmTask_completion", "observe_ObservedFsmTask_flags", "observe_ObservedFsmTask_item", "observe_ObservedFsmTask_seqId", "observe_ObservedFsm_completionTime", "observe_ObservedFsm_currentFsm", "observe_ObservedFsm_descr", "observe_ObservedFsm_fsmStatus", "observe_ObservedFsm_instanceId", "observe_ObservedFsm_progress", "observe_ObservedFsm_rmtErrCode", "observe_ObservedFsm_rmtErrDescr", "observe_ObservedFsm_rmtRslt", "observe_Observed_dataSrcAppType", "observe_Observed_dataSrcSysId", "observe_Observed_fsmDescr", "observe_Observed_fsmPrev", "observe_Observed_fsmProgr", "observe_Observed_fsmRmtInvErrCode", "observe_Observed_fsmRmtInvErrDescr", "observe_Observed_fsmRmtInvRslt", "observe_Observed_fsmStageDescr", "observe_Observed_fsmStamp", "observe_Observed_fsmStatus", "observe_Observed_fsmTry", "observe_Observed_genNum", "observe_Observed_hierarchical", "observe_Observed_id", "observe_Observed_isDeleted", "observe_Observed_observedDn", "org_Org_descr", "org_Org_level", "org_Org_name", "org_Org_permAccess", "org_SourceMask_mask", "os_Agent_lastCmd", "os_Agent_lastEvt", "os_Agent_lastEvtTs", "os_Agent_prevCmd", "os_Agent_prevEvt", "os_Agent_type", "os_Agent_vendor", "os_Agent_version", "os_Instance_hostname", "os_Instance_kernelName", "os_Instance_kernelRelease", "os_Instance_kernelVersion", "os_Instance_name", "os_Instance_type", "pci_Card_id", "pci_Card_model", "pci_Card_operQualifierReason", "pci_Card_operState", "pci_Card_operability", "pci_Card_pciAddr", "pci_Card_pciSlot", "pci_Card_perf", "pci_Card_power", "pci_Card_presence", "pci_Card_revision", "pci_Card_serial", "pci_Card_thermal", "pci_Card_vendor", "pci_Card_voltage", "pci_EquipSlot_controllerReported", "pci_EquipSlot_discoveryState", "pci_EquipSlot_hostReported", "pci_EquipSlot_id", "pci_EquipSlot_macLeft", "pci_EquipSlot_macRight", "pci_EquipSlot_model", "pci_EquipSlot_revision", "pci_EquipSlot_serial", "pci_EquipSlot_smbiosId", "pci_EquipSlot_vendor", "pci_Unit_id", "pci_Unit_model", "pci_Unit_operQualifierReason", "pci_Unit_operState", "pci_Unit_operability", "pci_Unit_pciAddr", "pci_Unit_pciSlot", "pci_Unit_perf", "pci_Unit_power", "pci_Unit_presence", "pci_Unit_revision", "pci_Unit_serial", "pci_Unit_thermal", "pci_Unit_vendor", "pci_Unit_voltage", "pki_CertReq_country", "pki_CertReq_dns", "pki_CertReq_email", "pki_CertReq_ip", "pki_CertReq_ipA", "pki_CertReq_ipB", "pki_CertReq_ipv6", "pki_CertReq_ipv6A", "pki_CertReq_ipv6B", "pki_CertReq_locality", "pki_CertReq_orgName", "pki_CertReq_orgUnitName", "pki_CertReq_pwd", "pki_CertReq_req", "pki_CertReq_state", "pki_CertReq_subjName", "pki_Definition_descr", "pki_Definition_intId", "pki_Definition_name", "pki_Definition_policyLevel", "pki_Definition_policyOwner", "pki_EpFsmStage_descr", "pki_EpFsmStage_lastUpdateTime", "pki_EpFsmStage_name", "pki_EpFsmStage_order", "pki_EpFsmStage_retry", "pki_EpFsmStage_stageStatus", "pki_EpFsmTask_completion", "pki_EpFsmTask_flags", "pki_EpFsmTask_item", "pki_EpFsmTask_seqId", "pki_EpFsm_completionTime", "pki_EpFsm_currentFsm", "pki_EpFsm_descr", "pki_EpFsm_fsmStatus", "pki_EpFsm_instanceId", "pki_EpFsm_progress", "pki_EpFsm_rmtErrCode", "pki_EpFsm_rmtErrDescr", "pki_EpFsm_rmtRslt", "pki_Ep_descr", "pki_Ep_fsmDescr", "pki_Ep_fsmPrev", "pki_Ep_fsmProgr", "pki_Ep_fsmRmtInvErrCode", "pki_Ep_fsmRmtInvErrDescr", "pki_Ep_fsmRmtInvRslt", "pki_Ep_fsmStageDescr", "pki_Ep_fsmStamp", "pki_Ep_fsmStatus", "pki_Ep_fsmTry", "pki_Ep_intId", "pki_Ep_name", "pki_Ep_policyLevel", "pki_Ep_policyOwner", "pki_Item_certStatus", "pki_Item_descr", "pki_Item_intId", "pki_Item_name", "pki_Item_policyLevel", "pki_Item_policyOwner", "pki_KeyRing_adminState", "pki_KeyRing_cert", "pki_KeyRing_certStatus", "pki_KeyRing_configState", "pki_KeyRing_configStatusMessage", "pki_KeyRing_descr", "pki_KeyRing_intId", "pki_KeyRing_key", "pki_KeyRing_modulus", "pki_KeyRing_name", "pki_KeyRing_policyLevel", "pki_KeyRing_policyOwner", "pki_KeyRing_regen", "pki_KeyRing_tp", "pki_TP_certChain", "pki_TP_certStatus", "pki_TP_descr", "pki_TP_fp", "pki_TP_intId", "pki_TP_name", "pki_TP_numCerts", "pki_TP_policyLevel", "pki_TP_policyOwner", "policy_Binding_name", "policy_CentraleSync_leftData", "policy_CentraleSync_rightData", "policy_Communication_source", "policy_ConfigBackup_source", "policy_ControlEpFsmStage_descr", "policy_ControlEpFsmStage_lastUpdateTime", "policy_ControlEpFsmStage_name", "policy_ControlEpFsmStage_order", "policy_ControlEpFsmStage_retry", "policy_ControlEpFsmStage_stageStatus", "policy_ControlEpFsmTask_completion", "policy_ControlEpFsmTask_flags", "policy_ControlEpFsmTask_item", "policy_ControlEpFsmTask_seqId", "policy_ControlEpFsm_completionTime", "policy_ControlEpFsm_currentFsm", "policy_ControlEpFsm_descr", "policy_ControlEpFsm_fsmStatus", "policy_ControlEpFsm_instanceId", "policy_ControlEpFsm_progress", "policy_ControlEpFsm_rmtErrCode", "policy_ControlEpFsm_rmtErrDescr", "policy_ControlEpFsm_rmtRslt", "policy_ControlEp_ackState", "policy_ControlEp_encSecret", "policy_ControlEp_fsmDescr", "policy_ControlEp_fsmPrev", "policy_ControlEp_fsmProgr", "policy_ControlEp_fsmRmtInvErrCode", "policy_ControlEp_fsmRmtInvErrDescr", "policy_ControlEp_fsmRmtInvRslt", "policy_ControlEp_fsmStageDescr", "policy_ControlEp_fsmStamp", "policy_ControlEp_fsmStatus", "policy_ControlEp_fsmTry", "policy_ControlEp_name", "policy_ControlEp_registrationState", "policy_ControlEp_repairState", "policy_ControlEp_secret", "policy_ControlEp_state", "policy_ControlEp_suspendState", "policy_ControlEp_svcRegIP", "policy_ControlEp_svcRegName", "policy_ControlEp_type", "policy_Control_source", "policy_ControlledInstance_defDn", "policy_ControlledInstance_externalResolveName", "policy_ControlledInstance_name", "policy_ControlledInstance_resolveType", "policy_ControlledInstance_type", "policy_ControlledTypeFsmStage_descr", "policy_ControlledTypeFsmStage_lastUpdateTime", "policy_ControlledTypeFsmStage_name", "policy_ControlledTypeFsmStage_order", "policy_ControlledTypeFsmStage_retry", "policy_ControlledTypeFsmStage_stageStatus", "policy_ControlledTypeFsmTask_completion", "policy_ControlledTypeFsmTask_flags", "policy_ControlledTypeFsmTask_item", "policy_ControlledTypeFsmTask_seqId", "policy_ControlledTypeFsm_completionTime", "policy_ControlledTypeFsm_currentFsm", "policy_ControlledTypeFsm_descr", "policy_ControlledTypeFsm_fsmStatus", "policy_ControlledTypeFsm_instanceId", "policy_ControlledTypeFsm_progress", "policy_ControlledTypeFsm_rmtErrCode", "policy_ControlledTypeFsm_rmtErrDescr", "policy_ControlledTypeFsm_rmtRslt", "policy_ControlledType_fsmDescr", "policy_ControlledType_fsmPrev", "policy_ControlledType_fsmProgr", "policy_ControlledType_fsmRmtInvErrCode", "policy_ControlledType_fsmRmtInvErrDescr", "policy_ControlledType_fsmRmtInvRslt", "policy_ControlledType_fsmStageDescr", "policy_ControlledType_fsmStamp", "policy_ControlledType_fsmStatus", "policy_ControlledType_fsmTry", "policy_ControlledType_parentContext", "policy_ControlledType_type", "policy_Controlled_type", "policy_DateTime_source", "policy_Definition_descr", "policy_Definition_intId", "policy_Definition_name", "policy_Definition_policyLevel", "policy_Definition_policyOwner", "policy_Digest_context", "policy_Digest_descr", "policy_Digest_label", "policy_Digest_name", "policy_Digest_onBehalfOfIdent", "policy_Digest_onBehalfOfType", "policy_Digest_requestorOwnership", "policy_Digest_resolveType", "policy_Digest_type", "policy_Digest_usage", "policy_Discovery_source", "policy_Dns_source", "policy_Element_classType", "policy_Element_convertedDn", "policy_Element_ownership", "policy_Element_policyDn", "policy_Fault_source", "policy_Holder_name", "policy_InfraFirmware_source", "policy_MEp_source", "policy_Monitoring_source", "policy_Object_name", "policy_PolicyRequestor_name", "policy_PolicyRequestor_onBehalfOfIdent", "policy_PolicyRequestor_onBehalfOfType", "policy_PolicyRequestor_resolvedClassType", "policy_PolicyScopeCont_appType", "policy_PolicyScopeCont_genNum", "policy_PolicyScopeCont_needRecovery", "policy_PolicyScopeContext_context", "policy_PolicyScopeContext_name", "policy_PolicyScopeFsmStage_descr", "policy_PolicyScopeFsmStage_lastUpdateTime", "policy_PolicyScopeFsmStage_name", "policy_PolicyScopeFsmStage_order", "policy_PolicyScopeFsmStage_retry", "policy_PolicyScopeFsmStage_stageStatus", "policy_PolicyScopeFsmTask_completion", "policy_PolicyScopeFsmTask_flags", "policy_PolicyScopeFsmTask_item", "policy_PolicyScopeFsmTask_seqId", "policy_PolicyScopeFsm_completionTime", "policy_PolicyScopeFsm_currentFsm", "policy_PolicyScopeFsm_descr", "policy_PolicyScopeFsm_fsmStatus", "policy_PolicyScopeFsm_instanceId", "policy_PolicyScopeFsm_progress", "policy_PolicyScopeFsm_rmtErrCode", "policy_PolicyScopeFsm_rmtErrDescr", "policy_PolicyScopeFsm_rmtRslt", "policy_PolicyScope_appType", "policy_PolicyScope_defaultPolicyName", "policy_PolicyScope_fsmDescr", "policy_PolicyScope_fsmPrev", "policy_PolicyScope_fsmProgr", "policy_PolicyScope_fsmRmtInvErrCode", "policy_PolicyScope_fsmRmtInvErrDescr", "policy_PolicyScope_fsmRmtInvRslt", "policy_PolicyScope_fsmStageDescr", "policy_PolicyScope_fsmStamp", "policy_PolicyScope_fsmStatus", "policy_PolicyScope_fsmTry", "policy_PolicyScope_operStatus", "policy_PolicyScope_owner", "policy_PolicyScope_policyName", "policy_PolicyScope_policyType", "policy_PolicyScope_recursive", "policy_PolicyScope_resolveType", "policy_PowerMgmt_source", "policy_Psu_source", "policy_RefReq_policyOwner", "policy_RefReq_refConvertedDn", "policy_RefReq_refPolicyDn", "policy_Security_source", "pool_Element_assigned", "pool_Element_assignedToDn", "pool_Element_owner", "pool_PoolMember_assigned", "pool_PoolMember_assignedToDn", "pool_PoolMember_poolableDn", "pool_PoolMember_prevAssignedToDn", "pool_Pool_assigned", "pool_Pool_assignmentOrder", "pool_Pool_descr", "pool_Pool_intId", "pool_Pool_name", "pool_Pool_policyLevel", "pool_Pool_policyOwner", "pool_Pool_size", "pool_Poolable_poolDn", "port_DomainEp_epDn", "port_DomainEp_ifRole", "port_DomainEp_ifType", "port_DomainEp_locale", "port_DomainEp_name", "port_DomainEp_peerDn", "port_DomainEp_transport", "port_DomainEp_type", "port_Group_locale", "port_Group_name", "port_Group_transport", "port_Group_type", "port_IntFIo_adminState", "port_IntFIo_chassisId", "port_IntFIo_encap", "port_IntFIo_epDn", "port_IntFIo_ifRole", "port_IntFIo_ifType", "port_IntFIo_locale", "port_IntFIo_mode", "port_IntFIo_model", "port_IntFIo_name", "port_IntFIo_operState", "port_IntFIo_peerChassisId", "port_IntFIo_peerDn", "port_IntFIo_peerPortId", "port_IntFIo_peerSlotId", "port_IntFIo_portId", "port_IntFIo_revision", "port_IntFIo_serial", "port_IntFIo_slotId", "port_IntFIo_stateQual", "port_IntFIo_switchId", "port_IntFIo_transport", "port_IntFIo_ts", "port_IntFIo_type", "port_IntFIo_vendor", "port_PIoFsmStage_descr", "port_PIoFsmStage_lastUpdateTime", "port_PIoFsmStage_name", "port_PIoFsmStage_order", "port_PIoFsmStage_retry", "port_PIoFsmStage_stageStatus", "port_PIoFsmTask_completion", "port_PIoFsmTask_flags", "port_PIoFsmTask_item", "port_PIoFsmTask_seqId", "port_PIoFsm_completionTime", "port_PIoFsm_currentFsm", "port_PIoFsm_descr", "port_PIoFsm_fsmStatus", "port_PIoFsm_instanceId", "port_PIoFsm_progress", "port_PIoFsm_rmtErrCode", "port_PIoFsm_rmtErrDescr", "port_PIoFsm_rmtRslt", "port_PIo_adminState", "port_PIo_adminTransport", "port_PIo_chassisId", "port_PIo_encap", "port_PIo_epDn", "port_PIo_fsmDescr", "port_PIo_fsmPrev", "port_PIo_fsmProgr", "port_PIo_fsmRmtInvErrCode", "port_PIo_fsmRmtInvErrDescr", "port_PIo_fsmRmtInvRslt", "port_PIo_fsmStageDescr", "port_PIo_fsmStamp", "port_PIo_fsmStatus", "port_PIo_fsmTry", "port_PIo_ifRole", "port_PIo_ifType", "port_PIo_isPortChannelMember", "port_PIo_lc", "port_PIo_licGP", "port_PIo_licState", "port_PIo_locale", "port_PIo_mode", "port_PIo_model", "port_PIo_name", "port_PIo_operState", "port_PIo_peerChassisId", "port_PIo_peerDn", "port_PIo_peerPortId", "port_PIo_peerSlotId", "port_PIo_portId", "port_PIo_revision", "port_PIo_serial", "port_PIo_slotId", "port_PIo_stateQual", "port_PIo_switchId", "port_PIo_transport", "port_PIo_ts", "port_PIo_type", "port_PIo_unifiedPort", "port_PIo_usrLbl", "port_PIo_vendor", "port_PIo_xcvrType", "port_PhysSwitchIo_adminState", "port_PhysSwitchIo_chassisId", "port_PhysSwitchIo_encap", "port_PhysSwitchIo_epDn", "port_PhysSwitchIo_ifRole", "port_PhysSwitchIo_ifType", "port_PhysSwitchIo_locale", "port_PhysSwitchIo_mode", "port_PhysSwitchIo_model", "port_PhysSwitchIo_name", "port_PhysSwitchIo_operState", "port_PhysSwitchIo_peerChassisId", "port_PhysSwitchIo_peerDn", "port_PhysSwitchIo_peerPortId", "port_PhysSwitchIo_peerSlotId", "port_PhysSwitchIo_portId", "port_PhysSwitchIo_revision", "port_PhysSwitchIo_serial", "port_PhysSwitchIo_slotId", "port_PhysSwitchIo_stateQual", "port_PhysSwitchIo_switchId", "port_PhysSwitchIo_transport", "port_PhysSwitchIo_ts", "port_PhysSwitchIo_type", "port_PhysSwitchIo_vendor", "port_Port_adminState", "port_Port_encap", "port_Port_mode", "port_Port_operState", "port_Port_stateQual", "port_ServerIntFIo_adminState", "port_ServerIntFIo_chassisId", "port_ServerIntFIo_encap", "port_ServerIntFIo_epDn", "port_ServerIntFIo_ifRole", "port_ServerIntFIo_ifType", "port_ServerIntFIo_locale", "port_ServerIntFIo_mode", "port_ServerIntFIo_model", "port_ServerIntFIo_name", "port_ServerIntFIo_operState", "port_ServerIntFIo_peerChassisId", "port_ServerIntFIo_peerDn", "port_ServerIntFIo_peerPortId", "port_ServerIntFIo_peerSlotId", "port_ServerIntFIo_portId", "port_ServerIntFIo_revision", "port_ServerIntFIo_serial", "port_ServerIntFIo_slotId", "port_ServerIntFIo_stateQual", "port_ServerIntFIo_switchId", "port_ServerIntFIo_transport", "port_ServerIntFIo_ts", "port_ServerIntFIo_type", "port_ServerIntFIo_vendor", "port_ServerIntFIo_xcvrType", "port_SwitchIntFIo_adminState", "port_SwitchIntFIo_chassisId", "port_SwitchIntFIo_encap", "port_SwitchIntFIo_epDn", "port_SwitchIntFIo_ifRole", "port_SwitchIntFIo_ifType", "port_SwitchIntFIo_locale", "port_SwitchIntFIo_mode", "port_SwitchIntFIo_model", "port_SwitchIntFIo_name", "port_SwitchIntFIo_operState", "port_SwitchIntFIo_peerChassisId", "port_SwitchIntFIo_peerDn", "port_SwitchIntFIo_peerPortId", "port_SwitchIntFIo_peerSlotId", "port_SwitchIntFIo_portId", "port_SwitchIntFIo_revision", "port_SwitchIntFIo_serial", "port_SwitchIntFIo_slotId", "port_SwitchIntFIo_stateQual", "port_SwitchIntFIo_switchId", "port_SwitchIntFIo_transport", "port_SwitchIntFIo_ts", "port_SwitchIntFIo_type", "port_SwitchIntFIo_vendor", "port_SwitchIntFIo_xcvrType", "port_TrustMode_state", "power_ABudget_adminCommitted", "power_ABudget_adminPeak", "power_ABudget_operCommitted", "power_ABudget_operPeak", "power_AGroup_descr", "power_AGroup_intId", "power_AGroup_name", "power_AGroup_policyLevel", "power_AGroup_policyOwner", "power_AGroup_qualifier", "power_Budget_adminCommitted", "power_Budget_adminPeak", "power_Budget_capAction", "power_Budget_catalogPower", "power_Budget_currentPower", "power_Budget_dynRealloc", "power_Budget_groupName", "power_Budget_idlePower", "power_Budget_maxPower", "power_Budget_minPower", "power_Budget_operCommitted", "power_Budget_operMin", "power_Budget_operPeak", "power_Budget_operState", "power_Budget_prio", "power_Budget_psuCapacity", "power_Budget_psuState", "power_Budget_scaledWt", "power_Budget_style", "power_Budget_updateTime", "power_Budget_weight", "power_ChassisMember_id", "power_ChassisMember_operState", "power_GroupAdditionPolicy_action", "power_GroupAdditionPolicy_descr", "power_GroupAdditionPolicy_intId", "power_GroupAdditionPolicy_name", "power_GroupAdditionPolicy_policyLevel", "power_GroupAdditionPolicy_policyOwner", "power_GroupMember_id", "power_GroupMember_operState", "power_GroupQual_groupName", "power_GroupStatsHist_id", "power_GroupStatsHist_mostRecent", "power_GroupStatsHist_power", "power_GroupStatsHist_powerAvg", "power_GroupStatsHist_powerMax", "power_GroupStatsHist_powerMin", "power_GroupStatsHist_suspect", "power_GroupStatsHist_thresholded", "power_GroupStatsHist_timeCollected", "power_GroupStats_intervals", "power_GroupStats_power", "power_GroupStats_powerAvg", "power_GroupStats_powerMax", "power_GroupStats_powerMin", "power_GroupStats_suspect", "power_GroupStats_thresholded", "power_GroupStats_timeCollected", "power_GroupStats_update", "power_Group_adminCommitted", "power_Group_adminPeak", "power_Group_curReqPower", "power_Group_currentPower", "power_Group_descr", "power_Group_intId", "power_Group_minReqPower", "power_Group_name", "power_Group_operCommitted", "power_Group_operPeak", "power_Group_operState", "power_Group_policyLevel", "power_Group_policyOwner", "power_Group_qualifier", "power_Group_realloc", "power_MgmtPolicy_descr", "power_MgmtPolicy_intId", "power_MgmtPolicy_name", "power_MgmtPolicy_policyLevel", "power_MgmtPolicy_policyOwner", "power_MgmtPolicy_style", "power_Placement_descr", "power_Placement_intId", "power_Placement_name", "power_Placement_peerReqConflict", "power_Placement_pgName", "power_Placement_policyLevel", "power_Placement_policyOwner", "power_Placement_prioShare", "power_Placement_selfReqConflict", "power_Policy_descr", "power_Policy_intId", "power_Policy_name", "power_Policy_operPrio", "power_Policy_policyLevel", "power_Policy_policyOwner", "power_Policy_prio", "power_PrioWght_prio", "power_PrioWght_weight", "power_RackUnitMember_id", "power_RackUnitMember_operState", "proc_Doer_id", "proc_Doer_name", "proc_ProcCounts_adminState", "proc_ProcCounts_bulked", "proc_ProcCounts_failed", "proc_ProcCounts_retried", "proc_ProcCounts_singleton", "proc_ProcCounts_successfull", "proc_ProcCounts_total", "proc_Procs_id", "proc_Procs_name", "proc_PrtCounts_cachenospc", "proc_PrtCounts_dbtxs", "proc_PrtCounts_largetxs", "proc_PrtCounts_persistTime", "proc_PrtCounts_total", "proc_Prt_id", "proc_Prt_name", "proc_StimulusCounts_adminState", "proc_StimulusCounts_bulked", "proc_StimulusCounts_failed", "proc_StimulusCounts_retried", "proc_StimulusCounts_singleton", "proc_StimulusCounts_successfull", "proc_StimulusCounts_total", "proc_Svc_id", "proc_Svc_name", "proc_TxCounts_adminState", "proc_TxCounts_bulked", "proc_TxCounts_failed", "proc_TxCounts_retried", "proc_TxCounts_singleton", "proc_TxCounts_successfull", "proc_TxCounts_total", "processor_Component_id", "processor_Core_id", "processor_EnvStatsHist_id", "processor_EnvStatsHist_inputCurrent", "processor_EnvStatsHist_inputCurrentAvg", "processor_EnvStatsHist_inputCurrentMax", "processor_EnvStatsHist_inputCurrentMin", "processor_EnvStatsHist_mostRecent", "processor_EnvStatsHist_suspect", "processor_EnvStatsHist_temperature", "processor_EnvStatsHist_temperatureAvg", "processor_EnvStatsHist_temperatureMax", "processor_EnvStatsHist_temperatureMin", "processor_EnvStatsHist_thresholded", "processor_EnvStatsHist_timeCollected", "processor_EnvStats_inputCurrent", "processor_EnvStats_inputCurrentAvg", "processor_EnvStats_inputCurrentMax", "processor_EnvStats_inputCurrentMin", "processor_EnvStats_intervals", "processor_EnvStats_suspect", "processor_EnvStats_temperature", "processor_EnvStats_temperatureAvg", "processor_EnvStats_temperatureMax", "processor_EnvStats_temperatureMin", "processor_EnvStats_thresholded", "processor_EnvStats_timeCollected", "processor_EnvStats_update", "processor_ErrorStats_intervals", "processor_ErrorStats_mirroringInterSockErrors", "processor_ErrorStats_mirroringInterSockErrors15Min", "processor_ErrorStats_mirroringInterSockErrors15MinH", "processor_ErrorStats_mirroringInterSockErrors1Day", "processor_ErrorStats_mirroringInterSockErrors1DayH", "processor_ErrorStats_mirroringInterSockErrors1Hour", "processor_ErrorStats_mirroringInterSockErrors1HourH", "processor_ErrorStats_mirroringInterSockErrors1Week", "processor_ErrorStats_mirroringInterSockErrors1WeekH", "processor_ErrorStats_mirroringInterSockErrors2Weeks", "processor_ErrorStats_mirroringInterSockErrors2WeeksH", "processor_ErrorStats_mirroringIntraSockErrors", "processor_ErrorStats_mirroringIntraSockErrors15Min", "processor_ErrorStats_mirroringIntraSockErrors15MinH", "processor_ErrorStats_mirroringIntraSockErrors1Day", "processor_ErrorStats_mirroringIntraSockErrors1DayH", "processor_ErrorStats_mirroringIntraSockErrors1Hour", "processor_ErrorStats_mirroringIntraSockErrors1HourH", "processor_ErrorStats_mirroringIntraSockErrors1Week", "processor_ErrorStats_mirroringIntraSockErrors1WeekH", "processor_ErrorStats_mirroringIntraSockErrors2Weeks", "processor_ErrorStats_mirroringIntraSockErrors2WeeksH", "processor_ErrorStats_smiLinkCorrErrors", "processor_ErrorStats_smiLinkCorrErrors15Min", "processor_ErrorStats_smiLinkCorrErrors15MinH", "processor_ErrorStats_smiLinkCorrErrors1Day", "processor_ErrorStats_smiLinkCorrErrors1DayH", "processor_ErrorStats_smiLinkCorrErrors1Hour", "processor_ErrorStats_smiLinkCorrErrors1HourH", "processor_ErrorStats_smiLinkCorrErrors1Week", "processor_ErrorStats_smiLinkCorrErrors1WeekH", "processor_ErrorStats_smiLinkCorrErrors2Weeks", "processor_ErrorStats_smiLinkCorrErrors2WeeksH", "processor_ErrorStats_smiLinkUncorrErrors", "processor_ErrorStats_smiLinkUncorrErrors15Min", "processor_ErrorStats_smiLinkUncorrErrors15MinH", "processor_ErrorStats_smiLinkUncorrErrors1Day", "processor_ErrorStats_smiLinkUncorrErrors1DayH", "processor_ErrorStats_smiLinkUncorrErrors1Hour", "processor_ErrorStats_smiLinkUncorrErrors1HourH", "processor_ErrorStats_smiLinkUncorrErrors1Week", "processor_ErrorStats_smiLinkUncorrErrors1WeekH", "processor_ErrorStats_smiLinkUncorrErrors2Weeks", "processor_ErrorStats_smiLinkUncorrErrors2WeeksH", "processor_ErrorStats_sparingErrors", "processor_ErrorStats_sparingErrors15Min", "processor_ErrorStats_sparingErrors15MinH", "processor_ErrorStats_sparingErrors1Day", "processor_ErrorStats_sparingErrors1DayH", "processor_ErrorStats_sparingErrors1Hour", "processor_ErrorStats_sparingErrors1HourH", "processor_ErrorStats_sparingErrors1Week", "processor_ErrorStats_sparingErrors1WeekH", "processor_ErrorStats_sparingErrors2Weeks", "processor_ErrorStats_sparingErrors2WeeksH", "processor_ErrorStats_suspect", "processor_ErrorStats_thresholded", "processor_ErrorStats_timeCollected", "processor_ErrorStats_update", "processor_Qual_arch", "processor_Qual_maxCores", "processor_Qual_maxProcs", "processor_Qual_maxThreads", "processor_Qual_minCores", "processor_Qual_minProcs", "processor_Qual_minThreads", "processor_Qual_model", "processor_Qual_speed", "processor_Qual_stepping", "processor_RuntimeHist_id", "processor_RuntimeHist_load", "processor_RuntimeHist_loadAvg", "processor_RuntimeHist_loadMax", "processor_RuntimeHist_loadMin", "processor_RuntimeHist_mostRecent", "processor_RuntimeHist_suspect", "processor_RuntimeHist_thresholded", "processor_RuntimeHist_timeCollected", "processor_Runtime_intervals", "processor_Runtime_load", "processor_Runtime_loadAvg", "processor_Runtime_loadMax", "processor_Runtime_loadMin", "processor_Runtime_suspect", "processor_Runtime_thresholded", "processor_Runtime_timeCollected", "processor_Runtime_update", "processor_Runtime_uptime", "processor_Thread_id", "processor_UnitAssocCtx_fruCapDn", "processor_UnitAssocCtx_stepping", "processor_Unit_arch", "processor_Unit_cores", "processor_Unit_coresEnabled", "processor_Unit_id", "processor_Unit_model", "processor_Unit_operQualifierReason", "processor_Unit_operState", "processor_Unit_operability", "processor_Unit_perf", "processor_Unit_power", "processor_Unit_presence", "processor_Unit_revision", "processor_Unit_serial", "processor_Unit_socketDesignation", "processor_Unit_speed", "processor_Unit_stepping", "processor_Unit_thermal", "processor_Unit_threads", "processor_Unit_vendor", "processor_Unit_visibility", "processor_Unit_voltage", "qos_Definition_descr", "qos_Definition_intId", "qos_Definition_name", "qos_Definition_policyLevel", "qos_Definition_policyOwner", "qos_Item_name", "qosclass_DefinitionFsmStage_descr", "qosclass_DefinitionFsmStage_lastUpdateTime", "qosclass_DefinitionFsmStage_name", "qosclass_DefinitionFsmStage_order", "qosclass_DefinitionFsmStage_retry", "qosclass_DefinitionFsmStage_stageStatus", "qosclass_DefinitionFsmTask_completion", "qosclass_DefinitionFsmTask_flags", "qosclass_DefinitionFsmTask_item", "qosclass_DefinitionFsmTask_seqId", "qosclass_DefinitionFsm_completionTime", "qosclass_DefinitionFsm_currentFsm", "qosclass_DefinitionFsm_descr", "qosclass_DefinitionFsm_fsmStatus", "qosclass_DefinitionFsm_instanceId", "qosclass_DefinitionFsm_progress", "qosclass_DefinitionFsm_rmtErrCode", "qosclass_DefinitionFsm_rmtErrDescr", "qosclass_DefinitionFsm_rmtRslt", "qosclass_Definition_descr", "qosclass_Definition_fsmDescr", "qosclass_Definition_fsmPrev", "qosclass_Definition_fsmProgr", "qosclass_Definition_fsmRmtInvErrCode", "qosclass_Definition_fsmRmtInvErrDescr", "qosclass_Definition_fsmRmtInvRslt", "qosclass_Definition_fsmStageDescr", "qosclass_Definition_fsmStamp", "qosclass_Definition_fsmStatus", "qosclass_Definition_fsmTry", "qosclass_Definition_intId", "qosclass_Definition_name", "qosclass_Definition_policyLevel", "qosclass_Definition_policyOwner", "qosclass_EthBE_adminState", "qosclass_EthBE_bwPercent", "qosclass_EthBE_cos", "qosclass_EthBE_drop", "qosclass_EthBE_mtu", "qosclass_EthBE_multicastOptimize", "qosclass_EthBE_name", "qosclass_EthBE_priority", "qosclass_EthBE_weight", "qosclass_EthClassified_adminState", "qosclass_EthClassified_bwPercent", "qosclass_EthClassified_cos", "qosclass_EthClassified_drop", "qosclass_EthClassified_mtu", "qosclass_EthClassified_multicastOptimize", "qosclass_EthClassified_name", "qosclass_EthClassified_priority", "qosclass_EthClassified_weight", "qosclass_Eth_adminState", "qosclass_Eth_bwPercent", "qosclass_Eth_cos", "qosclass_Eth_drop", "qosclass_Eth_mtu", "qosclass_Eth_multicastOptimize", "qosclass_Eth_name", "qosclass_Eth_priority", "qosclass_Eth_weight", "qosclass_Fc_adminState", "qosclass_Fc_bwPercent", "qosclass_Fc_cos", "qosclass_Fc_drop", "qosclass_Fc_mtu", "qosclass_Fc_name", "qosclass_Fc_priority", "qosclass_Fc_weight", "qosclass_Item_adminState", "qosclass_Item_bwPercent", "qosclass_Item_cos", "qosclass_Item_drop", "qosclass_Item_mtu", "qosclass_Item_name", "qosclass_Item_priority", "qosclass_Item_weight", "queryresult_Dependency_classType", "queryresult_Dependency_isImportable", "queryresult_Dependency_policyOwner", "queryresult_Dependency_refConvertedDn", "queryresult_Dependency_refDn", "queryresult_Dependency_refName", "queryresult_Item_classType", "queryresult_Item_policyOwner", "queryresult_Item_refConvertedDn", "queryresult_Item_refDn", "queryresult_Item_refName", "queryresult_Usage_classType", "queryresult_Usage_isServiceTemplate", "queryresult_Usage_policyOwner", "queryresult_Usage_refConvertedDn", "queryresult_Usage_refDn", "queryresult_Usage_refName", "rule_Definition_descr", "rule_Definition_intId", "rule_Definition_name", "rule_Definition_policyLevel", "rule_Definition_policyOwner", "rule_Item_name", "rule_SizeRequirement_maxSz", "rule_SizeRequirement_minSz", "sol_Config_adminState", "sol_Config_descr", "sol_Config_intId", "sol_Config_name", "sol_Config_policyLevel", "sol_Config_policyOwner", "sol_Config_speed", "sol_Def_adminState", "sol_Def_descr", "sol_Def_intId", "sol_Def_name", "sol_Def_policyLevel", "sol_Def_policyOwner", "sol_Def_speed", "sol_If_adminState", "sol_If_descr", "sol_If_intId", "sol_If_name", "sol_If_policyLevel", "sol_If_policyOwner", "sol_If_speed", "sol_Policy_adminState", "sol_Policy_descr", "sol_Policy_intId", "sol_Policy_name", "sol_Policy_policyLevel", "sol_Policy_policyOwner", "sol_Policy_speed", "stats_CollectionPolicyFsmStage_descr", "stats_CollectionPolicyFsmStage_lastUpdateTime", "stats_CollectionPolicyFsmStage_name", "stats_CollectionPolicyFsmStage_order", "stats_CollectionPolicyFsmStage_retry", "stats_CollectionPolicyFsmStage_stageStatus", "stats_CollectionPolicyFsmTask_completion", "stats_CollectionPolicyFsmTask_flags", "stats_CollectionPolicyFsmTask_item", "stats_CollectionPolicyFsmTask_seqId", "stats_CollectionPolicyFsm_completionTime", "stats_CollectionPolicyFsm_currentFsm", "stats_CollectionPolicyFsm_descr", "stats_CollectionPolicyFsm_fsmStatus", "stats_CollectionPolicyFsm_instanceId", "stats_CollectionPolicyFsm_progress", "stats_CollectionPolicyFsm_rmtErrCode", "stats_CollectionPolicyFsm_rmtErrDescr", "stats_CollectionPolicyFsm_rmtRslt", "stats_CollectionPolicy_collectionInterval", "stats_CollectionPolicy_fsmDescr", "stats_CollectionPolicy_fsmPrev", "stats_CollectionPolicy_fsmProgr", "stats_CollectionPolicy_fsmRmtInvErrCode", "stats_CollectionPolicy_fsmRmtInvErrDescr", "stats_CollectionPolicy_fsmRmtInvRslt", "stats_CollectionPolicy_fsmStageDescr", "stats_CollectionPolicy_fsmStamp", "stats_CollectionPolicy_fsmStatus", "stats_CollectionPolicy_fsmTry", "stats_CollectionPolicy_id", "stats_CollectionPolicy_name", "stats_CollectionPolicy_reportingInterval", "stats_Curr_intervals", "stats_Curr_suspect", "stats_Curr_thresholded", "stats_Curr_timeCollected", "stats_Curr_update", "stats_Hist_id", "stats_Hist_mostRecent", "stats_Hist_suspect", "stats_Hist_thresholded", "stats_Hist_timeCollected", "stats_Holder_name", "stats_Item_suspect", "stats_Item_thresholded", "stats_Item_timeCollected", "stats_Thr32Definition_descr", "stats_Thr32Definition_intId", "stats_Thr32Definition_name", "stats_Thr32Definition_normalValue", "stats_Thr32Definition_policyLevel", "stats_Thr32Definition_policyOwner", "stats_Thr32Definition_propId", "stats_Thr32Definition_propType", "stats_Thr32Value_deescalating", "stats_Thr32Value_descr", "stats_Thr32Value_direction", "stats_Thr32Value_escalating", "stats_Thr32Value_intId", "stats_Thr32Value_name", "stats_Thr32Value_policyLevel", "stats_Thr32Value_policyOwner", "stats_Thr32Value_propType", "stats_Thr32Value_severity", "stats_Thr64Definition_descr", "stats_Thr64Definition_intId", "stats_Thr64Definition_name", "stats_Thr64Definition_normalValue", "stats_Thr64Definition_policyLevel", "stats_Thr64Definition_policyOwner", "stats_Thr64Definition_propId", "stats_Thr64Definition_propType", "stats_Thr64Value_deescalating", "stats_Thr64Value_descr", "stats_Thr64Value_direction", "stats_Thr64Value_escalating", "stats_Thr64Value_intId", "stats_Thr64Value_name", "stats_Thr64Value_policyLevel", "stats_Thr64Value_policyOwner", "stats_Thr64Value_propType", "stats_Thr64Value_severity", "stats_ThrFloatDefinition_descr", "stats_ThrFloatDefinition_intId", "stats_ThrFloatDefinition_name", "stats_ThrFloatDefinition_normalValue", "stats_ThrFloatDefinition_policyLevel", "stats_ThrFloatDefinition_policyOwner", "stats_ThrFloatDefinition_propId", "stats_ThrFloatDefinition_propType", "stats_ThrFloatValue_deescalating", "stats_ThrFloatValue_descr", "stats_ThrFloatValue_direction", "stats_ThrFloatValue_escalating", "stats_ThrFloatValue_intId", "stats_ThrFloatValue_name", "stats_ThrFloatValue_policyLevel", "stats_ThrFloatValue_policyOwner", "stats_ThrFloatValue_propType", "stats_ThrFloatValue_severity", "stats_ThresholdClass_descr", "stats_ThresholdClass_intId", "stats_ThresholdClass_name", "stats_ThresholdClass_policyLevel", "stats_ThresholdClass_policyOwner", "stats_ThresholdClass_statsClassId", "stats_ThresholdDefinition_descr", "stats_ThresholdDefinition_intId", "stats_ThresholdDefinition_name", "stats_ThresholdDefinition_policyLevel", "stats_ThresholdDefinition_policyOwner", "stats_ThresholdDefinition_propId", "stats_ThresholdDefinition_propType", "stats_ThresholdPolicy_descr", "stats_ThresholdPolicy_intId", "stats_ThresholdPolicy_name", "stats_ThresholdPolicy_policyLevel", "stats_ThresholdPolicy_policyOwner", "stats_ThresholdValue_descr", "stats_ThresholdValue_direction", "stats_ThresholdValue_intId", "stats_ThresholdValue_name", "stats_ThresholdValue_policyLevel", "stats_ThresholdValue_policyOwner", "stats_ThresholdValue_propType", "stats_ThresholdValue_severity", "storage_ADef_descr", "storage_ADef_intId", "storage_ADef_name", "storage_ADef_operState", "storage_ADef_policyLevel", "storage_ADef_policyOwner", "storage_AuthKey_descr", "storage_AuthKey_intId", "storage_AuthKey_name", "storage_AuthKey_password", "storage_AuthKey_policyLevel", "storage_AuthKey_policyOwner", "storage_AuthKey_type", "storage_AuthKey_userId", "storage_ConnectionDef_descr", "storage_ConnectionDef_intId", "storage_ConnectionDef_name", "storage_ConnectionDef_operState", "storage_ConnectionDef_policyLevel", "storage_ConnectionDef_policyOwner", "storage_ConnectionDef_zoningType", "storage_ConnectionPolicy_descr", "storage_ConnectionPolicy_intId", "storage_ConnectionPolicy_name", "storage_ConnectionPolicy_operState", "storage_ConnectionPolicy_policyLevel", "storage_ConnectionPolicy_policyOwner", "storage_ConnectionPolicy_zoningType", "storage_ControllerBase_id", "storage_ControllerBase_model", "storage_ControllerBase_operQualifierReason", "storage_ControllerBase_operState", "storage_ControllerBase_operability", "storage_ControllerBase_pciAddr", "storage_ControllerBase_pciSlot", "storage_ControllerBase_perf", "storage_ControllerBase_power", "storage_ControllerBase_presence", "storage_ControllerBase_revision", "storage_ControllerBase_serial", "storage_ControllerBase_thermal", "storage_ControllerBase_type", "storage_ControllerBase_vendor", "storage_ControllerBase_voltage", "storage_Controller_controllerStatus", "storage_Controller_deviceRaidSupport", "storage_Controller_faultMonitoring", "storage_Controller_hwRevision", "storage_Controller_id", "storage_Controller_lc", "storage_Controller_model", "storage_Controller_oobControllerId", "storage_Controller_oobInterfaceSupported", "storage_Controller_operQualifierReason", "storage_Controller_operState", "storage_Controller_operability", "storage_Controller_pciAddr", "storage_Controller_pciSlot", "storage_Controller_perf", "storage_Controller_power", "storage_Controller_presence", "storage_Controller_raidSupport", "storage_Controller_rebuildRate", "storage_Controller_revision", "storage_Controller_serial", "storage_Controller_thermal", "storage_Controller_type", "storage_Controller_vendor", "storage_Controller_voltage", "storage_Drive_id", "storage_Drive_model", "storage_Drive_pciAddr", "storage_Drive_revision", "storage_Drive_serial", "storage_Drive_vendor", "storage_Enclosure_id", "storage_Enclosure_lc", "storage_Enclosure_model", "storage_Enclosure_numSlots", "storage_Enclosure_revision", "storage_Enclosure_serial", "storage_Enclosure_vendor", "storage_EpUser_configState", "storage_EpUser_configStatusMessage", "storage_EpUser_descr", "storage_EpUser_domain", "storage_EpUser_name", "storage_EpUser_priv", "storage_EpUser_pwd", "storage_EpUser_pwdSet", "storage_Ep_epDn", "storage_EtherIf_name", "storage_EtherIf_vlanType", "storage_FcIf_name", "storage_FcTargetEp_descr", "storage_FcTargetEp_path", "storage_FcTargetEp_targetwwpn", "storage_FcTargetIf_id", "storage_FcTargetIf_prot", "storage_FlexFlashCard_blockSize", "storage_FlexFlashCard_cardHealth", "storage_FlexFlashCard_cardMode", "storage_FlexFlashCard_cardType", "storage_FlexFlashCard_connectionProtocol", "storage_FlexFlashCard_controllerIndex", "storage_FlexFlashCard_id", "storage_FlexFlashCard_mfgDate", "storage_FlexFlashCard_mfgId", "storage_FlexFlashCard_model", "storage_FlexFlashCard_numberOfBlocks", "storage_FlexFlashCard_oemId", "storage_FlexFlashCard_operQualifierReason", "storage_FlexFlashCard_operability", "storage_FlexFlashCard_presence", "storage_FlexFlashCard_readIOErrorCount", "storage_FlexFlashCard_revision", "storage_FlexFlashCard_serial", "storage_FlexFlashCard_size", "storage_FlexFlashCard_slotNumber", "storage_FlexFlashCard_vendor", "storage_FlexFlashCard_writeEnable", "storage_FlexFlashCard_writeIOErrorCount", "storage_FlexFlashController_controllerHealth", "storage_FlexFlashController_controllerState", "storage_FlexFlashController_flexFlashType", "storage_FlexFlashController_id", "storage_FlexFlashController_model", "storage_FlexFlashController_operQualifierReason", "storage_FlexFlashController_operState", "storage_FlexFlashController_operability", "storage_FlexFlashController_pciAddr", "storage_FlexFlashController_pciSlot", "storage_FlexFlashController_perf", "storage_FlexFlashController_physicalDriveCount", "storage_FlexFlashController_power", "storage_FlexFlashController_presence", "storage_FlexFlashController_primarySlotNumber", "storage_FlexFlashController_raidSyncSupport", "storage_FlexFlashController_readErrorThreshold", "storage_FlexFlashController_revision", "storage_FlexFlashController_serial", "storage_FlexFlashController_thermal", "storage_FlexFlashController_type", "storage_FlexFlashController_vendor", "storage_FlexFlashController_virtualDriveCount", "storage_FlexFlashController_voltage", "storage_FlexFlashController_writeErrorThreshold", "storage_FlexFlashDrive_blockSize", "storage_FlexFlashDrive_connectionProtocol", "storage_FlexFlashDrive_controllerIndex", "storage_FlexFlashDrive_driveState", "storage_FlexFlashDrive_driveType", "storage_FlexFlashDrive_id", "storage_FlexFlashDrive_model", "storage_FlexFlashDrive_name", "storage_FlexFlashDrive_numberOfBlocks", "storage_FlexFlashDrive_operQualifierReason", "storage_FlexFlashDrive_operability", "storage_FlexFlashDrive_presence", "storage_FlexFlashDrive_removable", "storage_FlexFlashDrive_revision", "storage_FlexFlashDrive_serial", "storage_FlexFlashDrive_size", "storage_FlexFlashDrive_slotNumber", "storage_FlexFlashDrive_vendor", "storage_FlexFlashDrive_visible", "storage_FlexFlashVirtualDrive_blockSize", "storage_FlexFlashVirtualDrive_connectionProtocol", "storage_FlexFlashVirtualDrive_id", "storage_FlexFlashVirtualDrive_model", "storage_FlexFlashVirtualDrive_numberOfBlocks", "storage_FlexFlashVirtualDrive_operQualifierReason", "storage_FlexFlashVirtualDrive_operability", "storage_FlexFlashVirtualDrive_presence", "storage_FlexFlashVirtualDrive_raidHealth", "storage_FlexFlashVirtualDrive_raidState", "storage_FlexFlashVirtualDrive_revision", "storage_FlexFlashVirtualDrive_serial", "storage_FlexFlashVirtualDrive_size", "storage_FlexFlashVirtualDrive_type", "storage_FlexFlashVirtualDrive_vendor", "storage_IScsiTargetIf_name", "storage_IScsiTargetIf_prot", "storage_IniGroup_descr", "storage_IniGroup_groupPolicyName", "storage_IniGroup_intId", "storage_IniGroup_name", "storage_IniGroup_operProtocol", "storage_IniGroup_operState", "storage_IniGroup_owner", "storage_IniGroup_policyLevel", "storage_IniGroup_policyName", "storage_IniGroup_policyOwner", "storage_IniGroup_protocol", "storage_IniGroup_rmtDiskCfgName", "storage_Initiator_descr", "storage_Initiator_duplicateTarget", "storage_Initiator_intId", "storage_Initiator_name", "storage_Initiator_operState", "storage_Initiator_policyLevel", "storage_Initiator_policyOwner", "storage_Item_name", "storage_Item_operState", "storage_Item_size", "storage_Item_used", "storage_LocalDiskBase_blockSize", "storage_LocalDiskBase_connectionProtocol", "storage_LocalDiskBase_id", "storage_LocalDiskBase_model", "storage_LocalDiskBase_numberOfBlocks", "storage_LocalDiskBase_operQualifierReason", "storage_LocalDiskBase_operability", "storage_LocalDiskBase_presence", "storage_LocalDiskBase_revision", "storage_LocalDiskBase_serial", "storage_LocalDiskBase_size", "storage_LocalDiskBase_vendor", "storage_LocalDiskConfigDef_descr", "storage_LocalDiskConfigDef_flexFlashRAIDReportingState", "storage_LocalDiskConfigDef_flexFlashState", "storage_LocalDiskConfigDef_intId", "storage_LocalDiskConfigDef_mode", "storage_LocalDiskConfigDef_name", "storage_LocalDiskConfigDef_policyLevel", "storage_LocalDiskConfigDef_policyOwner", "storage_LocalDiskConfigDef_protectConfig", "storage_LocalDiskConfigPolicy_descr", "storage_LocalDiskConfigPolicy_flexFlashRAIDReportingState", "storage_LocalDiskConfigPolicy_flexFlashState", "storage_LocalDiskConfigPolicy_intId", "storage_LocalDiskConfigPolicy_mode", "storage_LocalDiskConfigPolicy_name", "storage_LocalDiskConfigPolicy_policyLevel", "storage_LocalDiskConfigPolicy_policyOwner", "storage_LocalDiskConfigPolicy_protectConfig", "storage_LocalDiskConfig_descr", "storage_LocalDiskConfig_flexFlashRAIDReportingState", "storage_LocalDiskConfig_flexFlashState", "storage_LocalDiskConfig_intId", "storage_LocalDiskConfig_mode", "storage_LocalDiskConfig_name", "storage_LocalDiskConfig_policyLevel", "storage_LocalDiskConfig_policyOwner", "storage_LocalDiskConfig_protectConfig", "storage_LocalDiskPartition_descr", "storage_LocalDiskPartition_intId", "storage_LocalDiskPartition_name", "storage_LocalDiskPartition_order", "storage_LocalDiskPartition_policyLevel", "storage_LocalDiskPartition_policyOwner", "storage_LocalDiskPartition_size", "storage_LocalDiskPartition_type", "storage_LocalDiskSlotEp_configuration", "storage_LocalDiskSlotEp_id", "storage_LocalDiskSlotEp_operQualifierReason", "storage_LocalDiskSlotEp_operability", "storage_LocalDiskSlotEp_peerDn", "storage_LocalDiskSlotEp_presence", "storage_LocalDisk_blockSize", "storage_LocalDisk_connectionProtocol", "storage_LocalDisk_deviceType", "storage_LocalDisk_diskState", "storage_LocalDisk_id", "storage_LocalDisk_lc", "storage_LocalDisk_linkSpeed", "storage_LocalDisk_model", "storage_LocalDisk_numberOfBlocks", "storage_LocalDisk_operQualifierReason", "storage_LocalDisk_operability", "storage_LocalDisk_powerState", "storage_LocalDisk_presence", "storage_LocalDisk_revision", "storage_LocalDisk_serial", "storage_LocalDisk_size", "storage_LocalDisk_vendor", "storage_LocalLun_blockSize", "storage_LocalLun_connectionProtocol", "storage_LocalLun_id", "storage_LocalLun_lc", "storage_LocalLun_model", "storage_LocalLun_numberOfBlocks", "storage_LocalLun_operQualifierReason", "storage_LocalLun_operability", "storage_LocalLun_presence", "storage_LocalLun_revision", "storage_LocalLun_serial", "storage_LocalLun_size", "storage_LocalLun_type", "storage_LocalLun_vendor", "storage_Logical_blockSize", "storage_Logical_connectionProtocol", "storage_Logical_id", "storage_Logical_model", "storage_Logical_numberOfBlocks", "storage_Logical_operQualifierReason", "storage_Logical_operability", "storage_Logical_presence", "storage_Logical_revision", "storage_Logical_serial", "storage_Logical_size", "storage_Logical_type", "storage_Logical_vendor", "storage_LunDisk_id", "storage_NodeEp_epDn", "storage_NodeEp_id", "storage_Operation_endTime", "storage_Operation_name", "storage_Operation_operState", "storage_Operation_progress", "storage_Operation_startTime", "storage_Operation_statusDescr", "storage_Physical_blockSize", "storage_Physical_connectionProtocol", "storage_Physical_id", "storage_Physical_model", "storage_Physical_numberOfBlocks", "storage_Physical_operQualifierReason", "storage_Physical_operability", "storage_Physical_presence", "storage_Physical_revision", "storage_Physical_serial", "storage_Physical_size", "storage_Physical_vendor", "storage_Qual_blockSize", "storage_Qual_diskless", "storage_Qual_maxCap", "storage_Qual_minCap", "storage_Qual_numberOfBlocks", "storage_Qual_numberOfFlexFlashCards", "storage_Qual_perDiskCap", "storage_Qual_units", "storage_RaidBattery_batteryType", "storage_RaidBattery_bbuStatus", "storage_RaidBattery_blockSize", "storage_RaidBattery_capacityPercentage", "storage_RaidBattery_connectionProtocol", "storage_RaidBattery_id", "storage_RaidBattery_lc", "storage_RaidBattery_learnCycleRequested", "storage_RaidBattery_learnMode", "storage_RaidBattery_model", "storage_RaidBattery_nextLearnCycleTs", "storage_RaidBattery_numberOfBlocks", "storage_RaidBattery_operQualifierReason", "storage_RaidBattery_operability", "storage_RaidBattery_operabilityQualifier", "storage_RaidBattery_operabilityQualifierReason", "storage_RaidBattery_presence", "storage_RaidBattery_revision", "storage_RaidBattery_serial", "storage_RaidBattery_size", "storage_RaidBattery_temperature", "storage_RaidBattery_vendor", "storage_SystemFsmStage_descr", "storage_SystemFsmStage_lastUpdateTime", "storage_SystemFsmStage_name", "storage_SystemFsmStage_order", "storage_SystemFsmStage_retry", "storage_SystemFsmStage_stageStatus", "storage_SystemFsmTask_completion", "storage_SystemFsmTask_flags", "storage_SystemFsmTask_item", "storage_SystemFsmTask_seqId", "storage_SystemFsm_completionTime", "storage_SystemFsm_currentFsm", "storage_SystemFsm_descr", "storage_SystemFsm_fsmStatus", "storage_SystemFsm_instanceId", "storage_SystemFsm_progress", "storage_SystemFsm_rmtErrCode", "storage_SystemFsm_rmtErrDescr", "storage_SystemFsm_rmtRslt", "storage_System_fsmDescr", "storage_System_fsmPrev", "storage_System_fsmProgr", "storage_System_fsmRmtInvErrCode", "storage_System_fsmRmtInvErrDescr", "storage_System_fsmRmtInvRslt", "storage_System_fsmStageDescr", "storage_System_fsmStamp", "storage_System_fsmStatus", "storage_System_fsmTry", "storage_System_id", "storage_System_name", "storage_TargetIf_prot", "storage_Target_descr", "storage_Target_path", "storage_Target_targetwwpn", "storage_TransportIf_prot", "storage_TransportableFlashModule_blockSize", "storage_TransportableFlashModule_connectionProtocol", "storage_TransportableFlashModule_id", "storage_TransportableFlashModule_model", "storage_TransportableFlashModule_numberOfBlocks", "storage_TransportableFlashModule_operQualifierReason", "storage_TransportableFlashModule_operability", "storage_TransportableFlashModule_presence", "storage_TransportableFlashModule_revision", "storage_TransportableFlashModule_serial", "storage_TransportableFlashModule_size", "storage_TransportableFlashModule_vendor", "storage_Unit_blockSize", "storage_Unit_connectionProtocol", "storage_Unit_numberOfBlocks", "storage_Unit_operQualifierReason", "storage_Unit_operability", "storage_Unit_presence", "storage_Unit_size", "storage_VirtualDrive_accessPolicy", "storage_VirtualDrive_actualWriteCachePolicy", "storage_VirtualDrive_blockSize", "storage_VirtualDrive_bootable", "storage_VirtualDrive_configuredWriteCachePolicy", "storage_VirtualDrive_connectionProtocol", "storage_VirtualDrive_driveCache", "storage_VirtualDrive_driveState", "storage_VirtualDrive_id", "storage_VirtualDrive_ioPolicy", "storage_VirtualDrive_lc", "storage_VirtualDrive_model", "storage_VirtualDrive_numberOfBlocks", "storage_VirtualDrive_operQualifierReason", "storage_VirtualDrive_operability", "storage_VirtualDrive_presence", "storage_VirtualDrive_readPolicy", "storage_VirtualDrive_revision", "storage_VirtualDrive_serial", "storage_VirtualDrive_size", "storage_VirtualDrive_stripSize", "storage_VirtualDrive_type", "storage_VirtualDrive_vendor", "storage_VsanRef_configQualifier", "storage_VsanRef_name", "storage_VsanRef_operVnetDn", "storage_VsanRef_operVnetName", "storage_VsanRef_switchId", "storage_VsanRef_vnet", "storage_VsanRef_zoningState", "sw_AccessDomainFsmStage_descr", "sw_AccessDomainFsmStage_lastUpdateTime", "sw_AccessDomainFsmStage_name", "sw_AccessDomainFsmStage_order", "sw_AccessDomainFsmStage_retry", "sw_AccessDomainFsmStage_stageStatus", "sw_AccessDomainFsmTask_completion", "sw_AccessDomainFsmTask_flags", "sw_AccessDomainFsmTask_item", "sw_AccessDomainFsmTask_seqId", "sw_AccessDomainFsm_completionTime", "sw_AccessDomainFsm_currentFsm", "sw_AccessDomainFsm_descr", "sw_AccessDomainFsm_fsmStatus", "sw_AccessDomainFsm_instanceId", "sw_AccessDomainFsm_progress", "sw_AccessDomainFsm_rmtErrCode", "sw_AccessDomainFsm_rmtErrDescr", "sw_AccessDomainFsm_rmtRslt", "sw_AccessDomain_fsmDescr", "sw_AccessDomain_fsmPrev", "sw_AccessDomain_fsmProgr", "sw_AccessDomain_fsmRmtInvErrCode", "sw_AccessDomain_fsmRmtInvErrDescr", "sw_AccessDomain_fsmRmtInvRslt", "sw_AccessDomain_fsmStageDescr", "sw_AccessDomain_fsmStamp", "sw_AccessDomain_fsmStatus", "sw_AccessDomain_fsmTry", "sw_AccessDomain_locale", "sw_AccessDomain_name", "sw_AccessDomain_switchId", "sw_AccessDomain_transport", "sw_AccessDomain_type", "sw_AccessEp_adminState", "sw_AccessEp_chassisId", "sw_AccessEp_encap", "sw_AccessEp_epDn", "sw_AccessEp_ifRole", "sw_AccessEp_ifType", "sw_AccessEp_lc", "sw_AccessEp_locale", "sw_AccessEp_name", "sw_AccessEp_nsSize", "sw_AccessEp_peerChassisId", "sw_AccessEp_peerDn", "sw_AccessEp_peerPortId", "sw_AccessEp_peerSlotId", "sw_AccessEp_portId", "sw_AccessEp_slotId", "sw_AccessEp_switchId", "sw_AccessEp_transport", "sw_AccessEp_type", "sw_BorderDomain_locale", "sw_BorderDomain_name", "sw_BorderDomain_switchId", "sw_BorderDomain_transport", "sw_BorderDomain_type", "sw_BorderEp_adminState", "sw_BorderEp_chassisId", "sw_BorderEp_epDn", "sw_BorderEp_ifRole", "sw_BorderEp_ifType", "sw_BorderEp_lc", "sw_BorderEp_locale", "sw_BorderEp_name", "sw_BorderEp_peerChassisId", "sw_BorderEp_peerDn", "sw_BorderEp_peerPortId", "sw_BorderEp_peerSlotId", "sw_BorderEp_portId", "sw_BorderEp_slotId", "sw_BorderEp_switchId", "sw_BorderEp_transport", "sw_BorderEp_type", "sw_BorderPc_adminState", "sw_BorderPc_epDn", "sw_BorderPc_ifRole", "sw_BorderPc_ifType", "sw_BorderPc_locale", "sw_BorderPc_monTrafDir", "sw_BorderPc_name", "sw_BorderPc_peerDn", "sw_BorderPc_portId", "sw_BorderPc_switchId", "sw_BorderPc_transport", "sw_BorderPc_type", "sw_CIoEp_adminState", "sw_CIoEp_epDn", "sw_CIoEp_ifRole", "sw_CIoEp_ifType", "sw_CIoEp_locale", "sw_CIoEp_name", "sw_CIoEp_peerDn", "sw_CIoEp_portId", "sw_CIoEp_switchId", "sw_CIoEp_transport", "sw_CIoEp_type", "sw_CardEnvStatsHist_SlotOutlet1", "sw_CardEnvStatsHist_SlotOutlet1Avg", "sw_CardEnvStatsHist_SlotOutlet1Max", "sw_CardEnvStatsHist_SlotOutlet1Min", "sw_CardEnvStatsHist_SlotOutlet2", "sw_CardEnvStatsHist_SlotOutlet2Avg", "sw_CardEnvStatsHist_SlotOutlet2Max", "sw_CardEnvStatsHist_SlotOutlet2Min", "sw_CardEnvStatsHist_SlotOutlet3", "sw_CardEnvStatsHist_SlotOutlet3Avg", "sw_CardEnvStatsHist_SlotOutlet3Max", "sw_CardEnvStatsHist_SlotOutlet3Min", "sw_CardEnvStatsHist_id", "sw_CardEnvStatsHist_mostRecent", "sw_CardEnvStatsHist_suspect", "sw_CardEnvStatsHist_thresholded", "sw_CardEnvStatsHist_timeCollected", "sw_CardEnvStats_SlotOutlet1", "sw_CardEnvStats_SlotOutlet1Avg", "sw_CardEnvStats_SlotOutlet1Max", "sw_CardEnvStats_SlotOutlet1Min", "sw_CardEnvStats_SlotOutlet2", "sw_CardEnvStats_SlotOutlet2Avg", "sw_CardEnvStats_SlotOutlet2Max", "sw_CardEnvStats_SlotOutlet2Min", "sw_CardEnvStats_SlotOutlet3", "sw_CardEnvStats_SlotOutlet3Avg", "sw_CardEnvStats_SlotOutlet3Max", "sw_CardEnvStats_SlotOutlet3Min", "sw_CardEnvStats_intervals", "sw_CardEnvStats_suspect", "sw_CardEnvStats_thresholded", "sw_CardEnvStats_timeCollected", "sw_CardEnvStats_update", "sw_Cmclan_cimcIds", "sw_Cmclan_epDn", "sw_Cmclan_id", "sw_Cmclan_ifRole", "sw_Cmclan_ifType", "sw_Cmclan_locale", "sw_Cmclan_name", "sw_Cmclan_peerDn", "sw_Cmclan_transport", "sw_Cmclan_type", "sw_Domain_locale", "sw_Domain_name", "sw_Domain_switchId", "sw_Domain_transport", "sw_Domain_type", "sw_EnvStatsHist_fanCtrlrInlet1", "sw_EnvStatsHist_fanCtrlrInlet1Avg", "sw_EnvStatsHist_fanCtrlrInlet1Max", "sw_EnvStatsHist_fanCtrlrInlet1Min", "sw_EnvStatsHist_fanCtrlrInlet2", "sw_EnvStatsHist_fanCtrlrInlet2Avg", "sw_EnvStatsHist_fanCtrlrInlet2Max", "sw_EnvStatsHist_fanCtrlrInlet2Min", "sw_EnvStatsHist_fanCtrlrInlet3", "sw_EnvStatsHist_fanCtrlrInlet3Avg", "sw_EnvStatsHist_fanCtrlrInlet3Max", "sw_EnvStatsHist_fanCtrlrInlet3Min", "sw_EnvStatsHist_fanCtrlrInlet4", "sw_EnvStatsHist_fanCtrlrInlet4Avg", "sw_EnvStatsHist_fanCtrlrInlet4Max", "sw_EnvStatsHist_fanCtrlrInlet4Min", "sw_EnvStatsHist_id", "sw_EnvStatsHist_mainBoardOutlet1", "sw_EnvStatsHist_mainBoardOutlet1Avg", "sw_EnvStatsHist_mainBoardOutlet1Max", "sw_EnvStatsHist_mainBoardOutlet1Min", "sw_EnvStatsHist_mainBoardOutlet2", "sw_EnvStatsHist_mainBoardOutlet2Avg", "sw_EnvStatsHist_mainBoardOutlet2Max", "sw_EnvStatsHist_mainBoardOutlet2Min", "sw_EnvStatsHist_mostRecent", "sw_EnvStatsHist_psuCtrlrInlet1", "sw_EnvStatsHist_psuCtrlrInlet1Avg", "sw_EnvStatsHist_psuCtrlrInlet1Max", "sw_EnvStatsHist_psuCtrlrInlet1Min", "sw_EnvStatsHist_psuCtrlrInlet2", "sw_EnvStatsHist_psuCtrlrInlet2Avg", "sw_EnvStatsHist_psuCtrlrInlet2Max", "sw_EnvStatsHist_psuCtrlrInlet2Min", "sw_EnvStatsHist_suspect", "sw_EnvStatsHist_thresholded", "sw_EnvStatsHist_timeCollected", "sw_EnvStats_fanCtrlrInlet1", "sw_EnvStats_fanCtrlrInlet1Avg", "sw_EnvStats_fanCtrlrInlet1Max", "sw_EnvStats_fanCtrlrInlet1Min", "sw_EnvStats_fanCtrlrInlet2", "sw_EnvStats_fanCtrlrInlet2Avg", "sw_EnvStats_fanCtrlrInlet2Max", "sw_EnvStats_fanCtrlrInlet2Min", "sw_EnvStats_fanCtrlrInlet3", "sw_EnvStats_fanCtrlrInlet3Avg", "sw_EnvStats_fanCtrlrInlet3Max", "sw_EnvStats_fanCtrlrInlet3Min", "sw_EnvStats_fanCtrlrInlet4", "sw_EnvStats_fanCtrlrInlet4Avg", "sw_EnvStats_fanCtrlrInlet4Max", "sw_EnvStats_fanCtrlrInlet4Min", "sw_EnvStats_intervals", "sw_EnvStats_mainBoardOutlet1", "sw_EnvStats_mainBoardOutlet1Avg", "sw_EnvStats_mainBoardOutlet1Max", "sw_EnvStats_mainBoardOutlet1Min", "sw_EnvStats_mainBoardOutlet2", "sw_EnvStats_mainBoardOutlet2Avg", "sw_EnvStats_mainBoardOutlet2Max", "sw_EnvStats_mainBoardOutlet2Min", "sw_EnvStats_psuCtrlrInlet1", "sw_EnvStats_psuCtrlrInlet1Avg", "sw_EnvStats_psuCtrlrInlet1Max", "sw_EnvStats_psuCtrlrInlet1Min", "sw_EnvStats_psuCtrlrInlet2", "sw_EnvStats_psuCtrlrInlet2Avg", "sw_EnvStats_psuCtrlrInlet2Max", "sw_EnvStats_psuCtrlrInlet2Min", "sw_EnvStats_suspect", "sw_EnvStats_thresholded", "sw_EnvStats_timeCollected", "sw_EnvStats_update", "sw_EstcEp_adminState", "sw_EstcEp_chassisId", "sw_EstcEp_epDn", "sw_EstcEp_ifRole", "sw_EstcEp_ifType", "sw_EstcEp_lc", "sw_EstcEp_locale", "sw_EstcEp_name", "sw_EstcEp_peerChassisId", "sw_EstcEp_peerDn", "sw_EstcEp_peerPortId", "sw_EstcEp_peerSlotId", "sw_EstcEp_portId", "sw_EstcEp_slotId", "sw_EstcEp_switchId", "sw_EstcEp_transport", "sw_EstcEp_type", "sw_EthEstcEp_adminSpeed", "sw_EthEstcEp_adminState", "sw_EthEstcEp_borderPortId", "sw_EthEstcEp_borderSlotId", "sw_EthEstcEp_cdp", "sw_EthEstcEp_chassisId", "sw_EthEstcEp_cosValue", "sw_EthEstcEp_epDn", "sw_EthEstcEp_forgeMac", "sw_EthEstcEp_ifRole", "sw_EthEstcEp_ifType", "sw_EthEstcEp_lc", "sw_EthEstcEp_locale", "sw_EthEstcEp_name", "sw_EthEstcEp_pcId", "sw_EthEstcEp_peerChassisId", "sw_EthEstcEp_peerDn", "sw_EthEstcEp_peerPortId", "sw_EthEstcEp_peerSlotId", "sw_EthEstcEp_pinGroupName", "sw_EthEstcEp_portId", "sw_EthEstcEp_portMode", "sw_EthEstcEp_priorityFlowCtrl", "sw_EthEstcEp_recvFlowCtrl", "sw_EthEstcEp_sendFlowCtrl", "sw_EthEstcEp_slotId", "sw_EthEstcEp_switchId", "sw_EthEstcEp_transport", "sw_EthEstcEp_type", "sw_EthEstcEp_uplinkFailAction", "sw_EthEstcPc_adminSpeed", "sw_EthEstcPc_adminState", "sw_EthEstcPc_borderPortId", "sw_EthEstcPc_borderSlotId", "sw_EthEstcPc_cdp", "sw_EthEstcPc_cosValue", "sw_EthEstcPc_epDn", "sw_EthEstcPc_forgeMac", "sw_EthEstcPc_ifRole", "sw_EthEstcPc_ifType", "sw_EthEstcPc_locale", "sw_EthEstcPc_monTrafDir", "sw_EthEstcPc_name", "sw_EthEstcPc_peerDn", "sw_EthEstcPc_portId", "sw_EthEstcPc_portMode", "sw_EthEstcPc_priorityFlowCtrl", "sw_EthEstcPc_protocol", "sw_EthEstcPc_recvFlowCtrl", "sw_EthEstcPc_sendFlowCtrl", "sw_EthEstcPc_switchId", "sw_EthEstcPc_transport", "sw_EthEstcPc_type", "sw_EthEstcPc_uplinkFailAction", "sw_EthFlowMonSession_adminState", "sw_EthFlowMonSession_hasLastDest", "sw_EthFlowMonSession_lifeCycle", "sw_EthFlowMonSession_name", "sw_EthFlowMonSession_peerDn", "sw_EthFlowMonSession_protocol", "sw_EthFlowMonSession_session", "sw_EthFlowMonSession_switchId", "sw_EthFlowMonSession_transport", "sw_EthFlowMonSession_type", "sw_EthLanBorderFsmStage_descr", "sw_EthLanBorderFsmStage_lastUpdateTime", "sw_EthLanBorderFsmStage_name", "sw_EthLanBorderFsmStage_order", "sw_EthLanBorderFsmStage_retry", "sw_EthLanBorderFsmStage_stageStatus", "sw_EthLanBorderFsmTask_completion", "sw_EthLanBorderFsmTask_flags", "sw_EthLanBorderFsmTask_item", "sw_EthLanBorderFsmTask_seqId", "sw_EthLanBorderFsm_completionTime", "sw_EthLanBorderFsm_currentFsm", "sw_EthLanBorderFsm_descr", "sw_EthLanBorderFsm_fsmStatus", "sw_EthLanBorderFsm_instanceId", "sw_EthLanBorderFsm_progress", "sw_EthLanBorderFsm_rmtErrCode", "sw_EthLanBorderFsm_rmtErrDescr", "sw_EthLanBorderFsm_rmtRslt", "sw_EthLanBorder_deployFlag", "sw_EthLanBorder_fsmDescr", "sw_EthLanBorder_fsmFlags", "sw_EthLanBorder_fsmPrev", "sw_EthLanBorder_fsmProgr", "sw_EthLanBorder_fsmRmtInvErrCode", "sw_EthLanBorder_fsmRmtInvErrDescr", "sw_EthLanBorder_fsmRmtInvRslt", "sw_EthLanBorder_fsmStageDescr", "sw_EthLanBorder_fsmStamp", "sw_EthLanBorder_fsmStatus", "sw_EthLanBorder_fsmTry", "sw_EthLanBorder_locale", "sw_EthLanBorder_name", "sw_EthLanBorder_switchId", "sw_EthLanBorder_transport", "sw_EthLanBorder_type", "sw_EthLanBorder_udldMsgInterval", "sw_EthLanBorder_udldRecoveryAction", "sw_EthLanEp_adminSpeed", "sw_EthLanEp_adminState", "sw_EthLanEp_chassisId", "sw_EthLanEp_epDn", "sw_EthLanEp_ifRole", "sw_EthLanEp_ifType", "sw_EthLanEp_lc", "sw_EthLanEp_locale", "sw_EthLanEp_name", "sw_EthLanEp_pcId", "sw_EthLanEp_peerChassisId", "sw_EthLanEp_peerDn", "sw_EthLanEp_peerPortId", "sw_EthLanEp_peerSlotId", "sw_EthLanEp_portId", "sw_EthLanEp_priorityFlowCtrl", "sw_EthLanEp_recvFlowCtrl", "sw_EthLanEp_sendFlowCtrl", "sw_EthLanEp_slotId", "sw_EthLanEp_switchId", "sw_EthLanEp_transport", "sw_EthLanEp_type", "sw_EthLanEp_udldAdminState", "sw_EthLanEp_udldMode", "sw_EthLanFlowMonExporter_isValidConfig", "sw_EthLanFlowMonExporter_lifeCycle", "sw_EthLanFlowMonExporter_name", "sw_EthLanFlowMonExporter_peerDn", "sw_EthLanFlowMonExporter_protocol", "sw_EthLanFlowMonExporter_switchId", "sw_EthLanFlowMonExporter_transport", "sw_EthLanFlowMonExporter_type", "sw_EthLanFlowMonFsmStage_descr", "sw_EthLanFlowMonFsmStage_lastUpdateTime", "sw_EthLanFlowMonFsmStage_name", "sw_EthLanFlowMonFsmStage_order", "sw_EthLanFlowMonFsmStage_retry", "sw_EthLanFlowMonFsmStage_stageStatus", "sw_EthLanFlowMonFsmTask_completion", "sw_EthLanFlowMonFsmTask_flags", "sw_EthLanFlowMonFsmTask_item", "sw_EthLanFlowMonFsmTask_seqId", "sw_EthLanFlowMonFsm_completionTime", "sw_EthLanFlowMonFsm_currentFsm", "sw_EthLanFlowMonFsm_descr", "sw_EthLanFlowMonFsm_fsmStatus", "sw_EthLanFlowMonFsm_instanceId", "sw_EthLanFlowMonFsm_progress", "sw_EthLanFlowMonFsm_rmtErrCode", "sw_EthLanFlowMonFsm_rmtErrDescr", "sw_EthLanFlowMonFsm_rmtRslt", "sw_EthLanFlowMon_fsmDescr", "sw_EthLanFlowMon_fsmPrev", "sw_EthLanFlowMon_fsmProgr", "sw_EthLanFlowMon_fsmRmtInvErrCode", "sw_EthLanFlowMon_fsmRmtInvErrDescr", "sw_EthLanFlowMon_fsmRmtInvRslt", "sw_EthLanFlowMon_fsmStageDescr", "sw_EthLanFlowMon_fsmStamp", "sw_EthLanFlowMon_fsmStatus", "sw_EthLanFlowMon_fsmTry", "sw_EthLanFlowMon_locale", "sw_EthLanFlowMon_name", "sw_EthLanFlowMon_netflowActiveTimeout", "sw_EthLanFlowMon_netflowInactiveTimeout", "sw_EthLanFlowMon_switchId", "sw_EthLanFlowMon_transport", "sw_EthLanFlowMon_type", "sw_EthLanFlowMonitor_activeTimeout", "sw_EthLanFlowMonitor_adminState", "sw_EthLanFlowMonitor_flowRecordDefName", "sw_EthLanFlowMonitor_inactiveTimeout", "sw_EthLanFlowMonitor_isValidConfig", "sw_EthLanFlowMonitor_lifeCycle", "sw_EthLanFlowMonitor_name", "sw_EthLanFlowMonitor_peerDn", "sw_EthLanFlowMonitor_protocol", "sw_EthLanFlowMonitor_switchId", "sw_EthLanFlowMonitor_transport", "sw_EthLanFlowMonitor_type", "sw_EthLanFlowRecordDef_ipv4keys", "sw_EthLanFlowRecordDef_ipv6keys", "sw_EthLanFlowRecordDef_keyType", "sw_EthLanFlowRecordDef_l2keys", "sw_EthLanFlowRecordDef_lifeCycle", "sw_EthLanFlowRecordDef_name", "sw_EthLanFlowRecordDef_nonkeys", "sw_EthLanFlowRecordDef_peerDn", "sw_EthLanFlowRecordDef_protocol", "sw_EthLanFlowRecordDef_switchId", "sw_EthLanFlowRecordDef_transport", "sw_EthLanFlowRecordDef_type", "sw_EthLanMon_locale", "sw_EthLanMon_name", "sw_EthLanMon_switchId", "sw_EthLanMon_transport", "sw_EthLanMon_type", "sw_EthLanPc_adminSpeed", "sw_EthLanPc_adminState", "sw_EthLanPc_epDn", "sw_EthLanPc_ifRole", "sw_EthLanPc_ifType", "sw_EthLanPc_locale", "sw_EthLanPc_monTrafDir", "sw_EthLanPc_name", "sw_EthLanPc_peerDn", "sw_EthLanPc_portId", "sw_EthLanPc_priorityFlowCtrl", "sw_EthLanPc_recvFlowCtrl", "sw_EthLanPc_sendFlowCtrl", "sw_EthLanPc_switchId", "sw_EthLanPc_transport", "sw_EthLanPc_type", "sw_EthMonDestEp_adminSpeed", "sw_EthMonDestEp_adminState", "sw_EthMonDestEp_chassisId", "sw_EthMonDestEp_epDn", "sw_EthMonDestEp_ifRole", "sw_EthMonDestEp_ifType", "sw_EthMonDestEp_lc", "sw_EthMonDestEp_locale", "sw_EthMonDestEp_name", "sw_EthMonDestEp_peerChassisId", "sw_EthMonDestEp_peerDn", "sw_EthMonDestEp_peerPortId", "sw_EthMonDestEp_peerSlotId", "sw_EthMonDestEp_portId", "sw_EthMonDestEp_slotId", "sw_EthMonDestEp_switchId", "sw_EthMonDestEp_transport", "sw_EthMonDestEp_type", "sw_EthMonFsmStage_descr", "sw_EthMonFsmStage_lastUpdateTime", "sw_EthMonFsmStage_name", "sw_EthMonFsmStage_order", "sw_EthMonFsmStage_retry", "sw_EthMonFsmStage_stageStatus", "sw_EthMonFsmTask_completion", "sw_EthMonFsmTask_flags", "sw_EthMonFsmTask_item", "sw_EthMonFsmTask_seqId", "sw_EthMonFsm_completionTime", "sw_EthMonFsm_currentFsm", "sw_EthMonFsm_descr", "sw_EthMonFsm_fsmStatus", "sw_EthMonFsm_instanceId", "sw_EthMonFsm_progress", "sw_EthMonFsm_rmtErrCode", "sw_EthMonFsm_rmtErrDescr", "sw_EthMonFsm_rmtRslt", "sw_EthMonSrcEp_adminState", "sw_EthMonSrcEp_chassisId", "sw_EthMonSrcEp_epDn", "sw_EthMonSrcEp_ifRole", "sw_EthMonSrcEp_ifType", "sw_EthMonSrcEp_lc", "sw_EthMonSrcEp_locale", "sw_EthMonSrcEp_monTrafDir", "sw_EthMonSrcEp_name", "sw_EthMonSrcEp_peerChassisId", "sw_EthMonSrcEp_peerDn", "sw_EthMonSrcEp_peerPortId", "sw_EthMonSrcEp_peerSlotId", "sw_EthMonSrcEp_portId", "sw_EthMonSrcEp_slotId", "sw_EthMonSrcEp_switchId", "sw_EthMonSrcEp_transport", "sw_EthMonSrcEp_type", "sw_EthMon_adminState", "sw_EthMon_fsmDescr", "sw_EthMon_fsmPrev", "sw_EthMon_fsmProgr", "sw_EthMon_fsmRmtInvErrCode", "sw_EthMon_fsmRmtInvErrDescr", "sw_EthMon_fsmRmtInvRslt", "sw_EthMon_fsmStageDescr", "sw_EthMon_fsmStamp", "sw_EthMon_fsmStatus", "sw_EthMon_fsmTry", "sw_EthMon_hasLastDest", "sw_EthMon_lifeCycle", "sw_EthMon_name", "sw_EthMon_peerDn", "sw_EthMon_session", "sw_EthMon_switchId", "sw_EthMon_transport", "sw_EthMon_type", "sw_EthTargetEp_adminState", "sw_EthTargetEp_chassisId", "sw_EthTargetEp_epDn", "sw_EthTargetEp_fltAggr", "sw_EthTargetEp_ifRole", "sw_EthTargetEp_ifType", "sw_EthTargetEp_licGP", "sw_EthTargetEp_licState", "sw_EthTargetEp_locale", "sw_EthTargetEp_macAddress", "sw_EthTargetEp_name", "sw_EthTargetEp_operState", "sw_EthTargetEp_operStateReason", "sw_EthTargetEp_peerChassisId", "sw_EthTargetEp_peerDn", "sw_EthTargetEp_peerPortId", "sw_EthTargetEp_peerSlotId", "sw_EthTargetEp_portId", "sw_EthTargetEp_slotId", "sw_EthTargetEp_switchId", "sw_EthTargetEp_transport", "sw_EthTargetEp_type", "sw_EthTargetEp_warnings", "sw_FabricZoneNsOverride_limit", "sw_FabricZoneNs_allocStatus", "sw_FabricZoneNs_limit", "sw_FabricZoneNs_switchId", "sw_FabricZoneNs_zoneCount", "sw_FcEstcEp_adminState", "sw_FcEstcEp_chassisId", "sw_FcEstcEp_epDn", "sw_FcEstcEp_fillPattern", "sw_FcEstcEp_ifRole", "sw_FcEstcEp_ifType", "sw_FcEstcEp_lc", "sw_FcEstcEp_locale", "sw_FcEstcEp_name", "sw_FcEstcEp_peerChassisId", "sw_FcEstcEp_peerDn", "sw_FcEstcEp_peerPortId", "sw_FcEstcEp_peerSlotId", "sw_FcEstcEp_portId", "sw_FcEstcEp_portVsanId", "sw_FcEstcEp_slotId", "sw_FcEstcEp_switchId", "sw_FcEstcEp_transport", "sw_FcEstcEp_type", "sw_FcMonDestEp_adminSpeed", "sw_FcMonDestEp_adminState", "sw_FcMonDestEp_chassisId", "sw_FcMonDestEp_epDn", "sw_FcMonDestEp_ifRole", "sw_FcMonDestEp_ifType", "sw_FcMonDestEp_lc", "sw_FcMonDestEp_locale", "sw_FcMonDestEp_name", "sw_FcMonDestEp_peerChassisId", "sw_FcMonDestEp_peerDn", "sw_FcMonDestEp_peerPortId", "sw_FcMonDestEp_peerSlotId", "sw_FcMonDestEp_portId", "sw_FcMonDestEp_slotId", "sw_FcMonDestEp_switchId", "sw_FcMonDestEp_transport", "sw_FcMonDestEp_type", "sw_FcMonFsmStage_descr", "sw_FcMonFsmStage_lastUpdateTime", "sw_FcMonFsmStage_name", "sw_FcMonFsmStage_order", "sw_FcMonFsmStage_retry", "sw_FcMonFsmStage_stageStatus", "sw_FcMonFsmTask_completion", "sw_FcMonFsmTask_flags", "sw_FcMonFsmTask_item", "sw_FcMonFsmTask_seqId", "sw_FcMonFsm_completionTime", "sw_FcMonFsm_currentFsm", "sw_FcMonFsm_descr", "sw_FcMonFsm_fsmStatus", "sw_FcMonFsm_instanceId", "sw_FcMonFsm_progress", "sw_FcMonFsm_rmtErrCode", "sw_FcMonFsm_rmtErrDescr", "sw_FcMonFsm_rmtRslt", "sw_FcMonSrcEp_adminState", "sw_FcMonSrcEp_chassisId", "sw_FcMonSrcEp_epDn", "sw_FcMonSrcEp_ifRole", "sw_FcMonSrcEp_ifType", "sw_FcMonSrcEp_lc", "sw_FcMonSrcEp_locale", "sw_FcMonSrcEp_monTrafDir", "sw_FcMonSrcEp_name", "sw_FcMonSrcEp_peerChassisId", "sw_FcMonSrcEp_peerDn", "sw_FcMonSrcEp_peerPortId", "sw_FcMonSrcEp_peerSlotId", "sw_FcMonSrcEp_portId", "sw_FcMonSrcEp_slotId", "sw_FcMonSrcEp_switchId", "sw_FcMonSrcEp_transport", "sw_FcMonSrcEp_type", "sw_FcMon_adminState", "sw_FcMon_fsmDescr", "sw_FcMon_fsmPrev", "sw_FcMon_fsmProgr", "sw_FcMon_fsmRmtInvErrCode", "sw_FcMon_fsmRmtInvErrDescr", "sw_FcMon_fsmRmtInvRslt", "sw_FcMon_fsmStageDescr", "sw_FcMon_fsmStamp", "sw_FcMon_fsmStatus", "sw_FcMon_fsmTry", "sw_FcMon_hasLastDest", "sw_FcMon_lifeCycle", "sw_FcMon_name", "sw_FcMon_peerDn", "sw_FcMon_session", "sw_FcMon_switchId", "sw_FcMon_transport", "sw_FcMon_type", "sw_FcSanBorderFsmStage_descr", "sw_FcSanBorderFsmStage_lastUpdateTime", "sw_FcSanBorderFsmStage_name", "sw_FcSanBorderFsmStage_order", "sw_FcSanBorderFsmStage_retry", "sw_FcSanBorderFsmStage_stageStatus", "sw_FcSanBorderFsmTask_completion", "sw_FcSanBorderFsmTask_flags", "sw_FcSanBorderFsmTask_item", "sw_FcSanBorderFsmTask_seqId", "sw_FcSanBorderFsm_completionTime", "sw_FcSanBorderFsm_currentFsm", "sw_FcSanBorderFsm_descr", "sw_FcSanBorderFsm_fsmStatus", "sw_FcSanBorderFsm_instanceId", "sw_FcSanBorderFsm_progress", "sw_FcSanBorderFsm_rmtErrCode", "sw_FcSanBorderFsm_rmtErrDescr", "sw_FcSanBorderFsm_rmtRslt", "sw_FcSanBorder_fsmDescr", "sw_FcSanBorder_fsmPrev", "sw_FcSanBorder_fsmProgr", "sw_FcSanBorder_fsmRmtInvErrCode", "sw_FcSanBorder_fsmRmtInvErrDescr", "sw_FcSanBorder_fsmRmtInvRslt", "sw_FcSanBorder_fsmStageDescr", "sw_FcSanBorder_fsmStamp", "sw_FcSanBorder_fsmStatus", "sw_FcSanBorder_fsmTry", "sw_FcSanBorder_locale", "sw_FcSanBorder_name", "sw_FcSanBorder_switchId", "sw_FcSanBorder_transport", "sw_FcSanBorder_type", "sw_FcSanBorder_uplinkTrunking", "sw_FcSanEp_adminSpeed", "sw_FcSanEp_adminState", "sw_FcSanEp_chassisId", "sw_FcSanEp_epDn", "sw_FcSanEp_fillPattern", "sw_FcSanEp_ifRole", "sw_FcSanEp_ifType", "sw_FcSanEp_lc", "sw_FcSanEp_locale", "sw_FcSanEp_name", "sw_FcSanEp_pcId", "sw_FcSanEp_peerChassisId", "sw_FcSanEp_peerDn", "sw_FcSanEp_peerPortId", "sw_FcSanEp_peerSlotId", "sw_FcSanEp_portId", "sw_FcSanEp_portVsanId", "sw_FcSanEp_slotId", "sw_FcSanEp_switchId", "sw_FcSanEp_transport", "sw_FcSanEp_type", "sw_FcSanMon_locale", "sw_FcSanMon_name", "sw_FcSanMon_switchId", "sw_FcSanMon_transport", "sw_FcSanMon_type", "sw_FcSanPc_adminSpeed", "sw_FcSanPc_adminState", "sw_FcSanPc_epDn", "sw_FcSanPc_ifRole", "sw_FcSanPc_ifType", "sw_FcSanPc_locale", "sw_FcSanPc_monTrafDir", "sw_FcSanPc_name", "sw_FcSanPc_pcId", "sw_FcSanPc_peerDn", "sw_FcSanPc_portId", "sw_FcSanPc_portVsanId", "sw_FcSanPc_switchId", "sw_FcSanPc_transport", "sw_FcSanPc_type", "sw_FcServerZoneGroup_epDn", "sw_FcServerZoneGroup_id", "sw_FcServerZoneGroup_lc", "sw_FcServerZoneGroup_name", "sw_FcServerZoneGroup_peerDn", "sw_FcServerZoneGroup_serverDn", "sw_FcZoneMember_epDn", "sw_FcZoneMember_lc", "sw_FcZoneMember_name", "sw_FcZoneMember_peerDn", "sw_FcZoneSet_currentZonePrefix", "sw_FcZoneSet_lc", "sw_FcZoneSet_name", "sw_FcZoneSet_oldZonePrefix", "sw_FcZone_id", "sw_FcZone_identity", "sw_FcZone_lc", "sw_FcZone_name", "sw_FcZone_operState", "sw_FcZone_peerDn", "sw_FcoeEstcEp_adminState", "sw_FcoeEstcEp_chassisId", "sw_FcoeEstcEp_epDn", "sw_FcoeEstcEp_ifRole", "sw_FcoeEstcEp_ifType", "sw_FcoeEstcEp_lc", "sw_FcoeEstcEp_locale", "sw_FcoeEstcEp_name", "sw_FcoeEstcEp_peerChassisId", "sw_FcoeEstcEp_peerDn", "sw_FcoeEstcEp_peerPortId", "sw_FcoeEstcEp_peerSlotId", "sw_FcoeEstcEp_peerState", "sw_FcoeEstcEp_portId", "sw_FcoeEstcEp_slotId", "sw_FcoeEstcEp_switchId", "sw_FcoeEstcEp_transport", "sw_FcoeEstcEp_type", "sw_FcoeSanEp_adminSpeed", "sw_FcoeSanEp_adminState", "sw_FcoeSanEp_chassisId", "sw_FcoeSanEp_epDn", "sw_FcoeSanEp_ifRole", "sw_FcoeSanEp_ifType", "sw_FcoeSanEp_lc", "sw_FcoeSanEp_locale", "sw_FcoeSanEp_name", "sw_FcoeSanEp_pcId", "sw_FcoeSanEp_peerChassisId", "sw_FcoeSanEp_peerDn", "sw_FcoeSanEp_peerPortId", "sw_FcoeSanEp_peerSlotId", "sw_FcoeSanEp_peerState", "sw_FcoeSanEp_portId", "sw_FcoeSanEp_portVsanId", "sw_FcoeSanEp_slotId", "sw_FcoeSanEp_switchId", "sw_FcoeSanEp_transport", "sw_FcoeSanEp_type", "sw_FcoeSanEp_udldAdminState", "sw_FcoeSanEp_udldMode", "sw_FcoeSanPc_adminState", "sw_FcoeSanPc_epDn", "sw_FcoeSanPc_ifRole", "sw_FcoeSanPc_ifType", "sw_FcoeSanPc_locale", "sw_FcoeSanPc_monTrafDir", "sw_FcoeSanPc_name", "sw_FcoeSanPc_pcId", "sw_FcoeSanPc_peerDn", "sw_FcoeSanPc_peerState", "sw_FcoeSanPc_portId", "sw_FcoeSanPc_portVsanId", "sw_FcoeSanPc_switchId", "sw_FcoeSanPc_transport", "sw_FcoeSanPc_type", "sw_FlowMonExporter_isValidConfig", "sw_FlowMonExporter_lifeCycle", "sw_FlowMonExporter_name", "sw_FlowMonExporter_peerDn", "sw_FlowMonExporter_protocol", "sw_FlowMonExporter_switchId", "sw_FlowMonExporter_transport", "sw_FlowMonExporter_type", "sw_FlowMonitor_activeTimeout", "sw_FlowMonitor_adminState", "sw_FlowMonitor_flowRecordDefName", "sw_FlowMonitor_inactiveTimeout", "sw_FlowMonitor_isValidConfig", "sw_FlowMonitor_lifeCycle", "sw_FlowMonitor_name", "sw_FlowMonitor_peerDn", "sw_FlowMonitor_protocol", "sw_FlowMonitor_switchId", "sw_FlowMonitor_transport", "sw_FlowMonitor_type", "sw_FlowRecordDef_lifeCycle", "sw_FlowRecordDef_name", "sw_FlowRecordDef_peerDn", "sw_FlowRecordDef_protocol", "sw_FlowRecordDef_switchId", "sw_FlowRecordDef_transport", "sw_FlowRecordDef_type", "sw_IpRoute_destinationIp", "sw_IpRoute_destinationNetmask", "sw_IpRoute_name", "sw_IpRoute_peerDn", "sw_IpRoute_prefix", "sw_IpRoute_routeIP", "sw_IpRoute_switchId", "sw_LanBorder_locale", "sw_LanBorder_name", "sw_LanBorder_switchId", "sw_LanBorder_transport", "sw_LanBorder_type", "sw_LanEp_adminState", "sw_LanEp_chassisId", "sw_LanEp_epDn", "sw_LanEp_ifRole", "sw_LanEp_ifType", "sw_LanEp_lc", "sw_LanEp_locale", "sw_LanEp_name", "sw_LanEp_peerChassisId", "sw_LanEp_peerDn", "sw_LanEp_peerPortId", "sw_LanEp_peerSlotId", "sw_LanEp_portId", "sw_LanEp_slotId", "sw_LanEp_switchId", "sw_LanEp_transport", "sw_LanEp_type", "sw_LanMon_locale", "sw_LanMon_name", "sw_LanMon_switchId", "sw_LanMon_transport", "sw_LanMon_type", "sw_LanPc_adminState", "sw_LanPc_epDn", "sw_LanPc_ifRole", "sw_LanPc_ifType", "sw_LanPc_locale", "sw_LanPc_monTrafDir", "sw_LanPc_name", "sw_LanPc_peerDn", "sw_LanPc_portId", "sw_LanPc_switchId", "sw_LanPc_transport", "sw_LanPc_type", "sw_MonDestEp_adminState", "sw_MonDestEp_chassisId", "sw_MonDestEp_epDn", "sw_MonDestEp_ifRole", "sw_MonDestEp_ifType", "sw_MonDestEp_lc", "sw_MonDestEp_locale", "sw_MonDestEp_name", "sw_MonDestEp_peerChassisId", "sw_MonDestEp_peerDn", "sw_MonDestEp_peerPortId", "sw_MonDestEp_peerSlotId", "sw_MonDestEp_portId", "sw_MonDestEp_slotId", "sw_MonDestEp_switchId", "sw_MonDestEp_transport", "sw_MonDestEp_type", "sw_MonDomain_locale", "sw_MonDomain_name", "sw_MonDomain_switchId", "sw_MonDomain_transport", "sw_MonDomain_type", "sw_MonSrcEp_adminState", "sw_MonSrcEp_chassisId", "sw_MonSrcEp_epDn", "sw_MonSrcEp_ifRole", "sw_MonSrcEp_ifType", "sw_MonSrcEp_lc", "sw_MonSrcEp_locale", "sw_MonSrcEp_monTrafDir", "sw_MonSrcEp_name", "sw_MonSrcEp_peerChassisId", "sw_MonSrcEp_peerDn", "sw_MonSrcEp_peerPortId", "sw_MonSrcEp_peerSlotId", "sw_MonSrcEp_portId", "sw_MonSrcEp_slotId", "sw_MonSrcEp_switchId", "sw_MonSrcEp_transport", "sw_MonSrcEp_type", "sw_Mon_adminState", "sw_Mon_hasLastDest", "sw_Mon_lifeCycle", "sw_Mon_name", "sw_Mon_peerDn", "sw_Mon_session", "sw_Mon_switchId", "sw_Mon_transport", "sw_Mon_type", "sw_NFExporterRef_name", "sw_NFExporterRef_peerDn", "sw_NetflowExporter_destinationIpAddress", "sw_NetflowExporter_destinationPort", "sw_NetflowExporter_dscp", "sw_NetflowExporter_exportInternal", "sw_NetflowExporter_exporterStatsTimeout", "sw_NetflowExporter_interfaceTableTimeout", "sw_NetflowExporter_isValidConfig", "sw_NetflowExporter_lifeCycle", "sw_NetflowExporter_name", "sw_NetflowExporter_peerDn", "sw_NetflowExporter_protocol", "sw_NetflowExporter_sourceVlan", "sw_NetflowExporter_switchId", "sw_NetflowExporter_templateDataTimeout", "sw_NetflowExporter_transport", "sw_NetflowExporter_transportProtocol", "sw_NetflowExporter_type", "sw_NetflowExporter_version", "sw_NetflowMonSession_adminState", "sw_NetflowMonSession_hasLastDest", "sw_NetflowMonSession_lifeCycle", "sw_NetflowMonSession_name", "sw_NetflowMonSession_peerDn", "sw_NetflowMonSession_protocol", "sw_NetflowMonSession_session", "sw_NetflowMonSession_switchId", "sw_NetflowMonSession_transport", "sw_NetflowMonSession_type", "sw_NetflowMonitorRef_direction", "sw_NetflowMonitorRef_keyType", "sw_NetflowMonitorRef_name", "sw_NetflowMonitorRef_sourceDn", "sw_NetflowMonitor_activeTimeout", "sw_NetflowMonitor_adminState", "sw_NetflowMonitor_flowRecordDefName", "sw_NetflowMonitor_inactiveTimeout", "sw_NetflowMonitor_isValidConfig", "sw_NetflowMonitor_lifeCycle", "sw_NetflowMonitor_name", "sw_NetflowMonitor_peerDn", "sw_NetflowMonitor_protocol", "sw_NetflowMonitor_switchId", "sw_NetflowMonitor_transport", "sw_NetflowMonitor_type", "sw_NetflowRecordDef_ipv4keys", "sw_NetflowRecordDef_ipv6keys", "sw_NetflowRecordDef_keyType", "sw_NetflowRecordDef_l2keys", "sw_NetflowRecordDef_lifeCycle", "sw_NetflowRecordDef_name", "sw_NetflowRecordDef_nonkeys", "sw_NetflowRecordDef_peerDn", "sw_NetflowRecordDef_protocol", "sw_NetflowRecordDef_switchId", "sw_NetflowRecordDef_transport", "sw_NetflowRecordDef_type", "sw_PIoEp_adminState", "sw_PIoEp_chassisId", "sw_PIoEp_epDn", "sw_PIoEp_ifRole", "sw_PIoEp_ifType", "sw_PIoEp_lc", "sw_PIoEp_locale", "sw_PIoEp_name", "sw_PIoEp_peerChassisId", "sw_PIoEp_peerDn", "sw_PIoEp_peerPortId", "sw_PIoEp_peerSlotId", "sw_PIoEp_portId", "sw_PIoEp_slotId", "sw_PIoEp_switchId", "sw_PIoEp_transport", "sw_PIoEp_type", "sw_PhysEtherEp_adminState", "sw_PhysEtherEp_chassisId", "sw_PhysEtherEp_epDn", "sw_PhysEtherEp_ifRole", "sw_PhysEtherEp_ifType", "sw_PhysEtherEp_lc", "sw_PhysEtherEp_locale", "sw_PhysEtherEp_name", "sw_PhysEtherEp_peerChassisId", "sw_PhysEtherEp_peerDn", "sw_PhysEtherEp_peerPortId", "sw_PhysEtherEp_peerSlotId", "sw_PhysEtherEp_portId", "sw_PhysEtherEp_slotId", "sw_PhysEtherEp_switchId", "sw_PhysEtherEp_transport", "sw_PhysEtherEp_type", "sw_PhysFcEp_adminState", "sw_PhysFcEp_chassisId", "sw_PhysFcEp_epDn", "sw_PhysFcEp_ifRole", "sw_PhysFcEp_ifType", "sw_PhysFcEp_lc", "sw_PhysFcEp_locale", "sw_PhysFcEp_name", "sw_PhysFcEp_peerChassisId", "sw_PhysFcEp_peerDn", "sw_PhysFcEp_peerPortId", "sw_PhysFcEp_peerSlotId", "sw_PhysFcEp_portId", "sw_PhysFcEp_slotId", "sw_PhysFcEp_switchId", "sw_PhysFcEp_transport", "sw_PhysFcEp_type", "sw_PhysFsmStage_descr", "sw_PhysFsmStage_lastUpdateTime", "sw_PhysFsmStage_name", "sw_PhysFsmStage_order", "sw_PhysFsmStage_retry", "sw_PhysFsmStage_stageStatus", "sw_PhysFsmTask_completion", "sw_PhysFsmTask_flags", "sw_PhysFsmTask_item", "sw_PhysFsmTask_seqId", "sw_PhysFsm_completionTime", "sw_PhysFsm_currentFsm", "sw_PhysFsm_descr", "sw_PhysFsm_fsmStatus", "sw_PhysFsm_instanceId", "sw_PhysFsm_progress", "sw_PhysFsm_rmtErrCode", "sw_PhysFsm_rmtErrDescr", "sw_PhysFsm_rmtRslt", "sw_Phys_confMode", "sw_Phys_fsmDescr", "sw_Phys_fsmPrev", "sw_Phys_fsmProgr", "sw_Phys_fsmRmtInvErrCode", "sw_Phys_fsmRmtInvErrDescr", "sw_Phys_fsmRmtInvRslt", "sw_Phys_fsmStageDescr", "sw_Phys_fsmStamp", "sw_Phys_fsmStatus", "sw_Phys_fsmTry", "sw_SanBorder_locale", "sw_SanBorder_name", "sw_SanBorder_switchId", "sw_SanBorder_transport", "sw_SanBorder_type", "sw_SanEp_adminState", "sw_SanEp_chassisId", "sw_SanEp_epDn", "sw_SanEp_ifRole", "sw_SanEp_ifType", "sw_SanEp_lc", "sw_SanEp_locale", "sw_SanEp_name", "sw_SanEp_peerChassisId", "sw_SanEp_peerDn", "sw_SanEp_peerPortId", "sw_SanEp_peerSlotId", "sw_SanEp_portId", "sw_SanEp_slotId", "sw_SanEp_switchId", "sw_SanEp_transport", "sw_SanEp_type", "sw_SanMon_locale", "sw_SanMon_name", "sw_SanMon_switchId", "sw_SanMon_transport", "sw_SanMon_type", "sw_SanPc_adminState", "sw_SanPc_epDn", "sw_SanPc_ifRole", "sw_SanPc_ifType", "sw_SanPc_locale", "sw_SanPc_monTrafDir", "sw_SanPc_name", "sw_SanPc_peerDn", "sw_SanPc_portId", "sw_SanPc_switchId", "sw_SanPc_transport", "sw_SanPc_type", "sw_SystemStatsHist_id", "sw_SystemStatsHist_load", "sw_SystemStatsHist_loadAvg", "sw_SystemStatsHist_loadMax", "sw_SystemStatsHist_loadMin", "sw_SystemStatsHist_memAvailable", "sw_SystemStatsHist_memAvailableAvg", "sw_SystemStatsHist_memAvailableMax", "sw_SystemStatsHist_memAvailableMin", "sw_SystemStatsHist_memCached", "sw_SystemStatsHist_memCachedAvg", "sw_SystemStatsHist_memCachedMax", "sw_SystemStatsHist_memCachedMin", "sw_SystemStatsHist_mostRecent", "sw_SystemStatsHist_suspect", "sw_SystemStatsHist_thresholded", "sw_SystemStatsHist_timeCollected", "sw_SystemStats_intervals", "sw_SystemStats_load", "sw_SystemStats_loadAvg", "sw_SystemStats_loadMax", "sw_SystemStats_loadMin", "sw_SystemStats_memAvailable", "sw_SystemStats_memAvailableAvg", "sw_SystemStats_memAvailableMax", "sw_SystemStats_memAvailableMin", "sw_SystemStats_memCached", "sw_SystemStats_memCachedAvg", "sw_SystemStats_memCachedMax", "sw_SystemStats_memCachedMin", "sw_SystemStats_suspect", "sw_SystemStats_thresholded", "sw_SystemStats_timeCollected", "sw_SystemStats_update", "sw_TargetEp_adminState", "sw_TargetEp_chassisId", "sw_TargetEp_epDn", "sw_TargetEp_fltAggr", "sw_TargetEp_ifRole", "sw_TargetEp_ifType", "sw_TargetEp_licGP", "sw_TargetEp_licState", "sw_TargetEp_locale", "sw_TargetEp_name", "sw_TargetEp_operState", "sw_TargetEp_operStateReason", "sw_TargetEp_peerChassisId", "sw_TargetEp_peerDn", "sw_TargetEp_peerPortId", "sw_TargetEp_peerSlotId", "sw_TargetEp_portId", "sw_TargetEp_slotId", "sw_TargetEp_switchId", "sw_TargetEp_transport", "sw_TargetEp_type", "sw_TargetEp_warnings", "sw_Ulan_epDn", "sw_Ulan_id", "sw_Ulan_ifRole", "sw_Ulan_ifType", "sw_Ulan_locale", "sw_Ulan_name", "sw_Ulan_operState", "sw_Ulan_peerDn", "sw_Ulan_policyOwner", "sw_Ulan_pubNwDn", "sw_Ulan_pubNwId", "sw_Ulan_pubNwName", "sw_Ulan_purpose", "sw_Ulan_sharing", "sw_Ulan_switchId", "sw_Ulan_transport", "sw_Ulan_type", "sw_Ulan_vlanType", "sw_UtilityDomainFsmStage_descr", "sw_UtilityDomainFsmStage_lastUpdateTime", "sw_UtilityDomainFsmStage_name", "sw_UtilityDomainFsmStage_order", "sw_UtilityDomainFsmStage_retry", "sw_UtilityDomainFsmStage_stageStatus", "sw_UtilityDomainFsmTask_completion", "sw_UtilityDomainFsmTask_flags", "sw_UtilityDomainFsmTask_item", "sw_UtilityDomainFsmTask_seqId", "sw_UtilityDomainFsm_completionTime", "sw_UtilityDomainFsm_currentFsm", "sw_UtilityDomainFsm_descr", "sw_UtilityDomainFsm_fsmStatus", "sw_UtilityDomainFsm_instanceId", "sw_UtilityDomainFsm_progress", "sw_UtilityDomainFsm_rmtErrCode", "sw_UtilityDomainFsm_rmtErrDescr", "sw_UtilityDomainFsm_rmtRslt", "sw_UtilityDomain_fsmDescr", "sw_UtilityDomain_fsmPrev", "sw_UtilityDomain_fsmProgr", "sw_UtilityDomain_fsmRmtInvErrCode", "sw_UtilityDomain_fsmRmtInvErrDescr", "sw_UtilityDomain_fsmRmtInvRslt", "sw_UtilityDomain_fsmStageDescr", "sw_UtilityDomain_fsmStamp", "sw_UtilityDomain_fsmStatus", "sw_UtilityDomain_fsmTry", "sw_UtilityDomain_locale", "sw_UtilityDomain_name", "sw_UtilityDomain_switchId", "sw_UtilityDomain_transport", "sw_UtilityDomain_type", "sw_VirtL3Intf_ipAddress", "sw_VirtL3Intf_name", "sw_VirtL3Intf_netmask", "sw_VirtL3Intf_vlanId", "sw_VlanGroup_id", "sw_VlanGroup_peerDn", "sw_VlanGroup_switchId", "sw_VlanGroup_type", "sw_VlanPortNsOverride_limit", "sw_VlanPortNs_accessVlanPortCount", "sw_VlanPortNs_allocStatus", "sw_VlanPortNs_borderVlanPortCount", "sw_VlanPortNs_configStatus", "sw_VlanPortNs_limit", "sw_VlanPortNs_switchId", "sw_VlanPortNs_vlanCompOffLimit", "sw_VlanPortNs_vlanCompOnLimit", "sw_VlanRef_compressionType", "sw_VlanRef_configStatus", "sw_VlanRef_id", "sw_VlanRef_peerDn", "sw_Vlan_compressionType", "sw_Vlan_epDn", "sw_Vlan_id", "sw_Vlan_ifRole", "sw_Vlan_ifType", "sw_Vlan_lc", "sw_Vlan_locale", "sw_Vlan_monTrafDir", "sw_Vlan_name", "sw_Vlan_operState", "sw_Vlan_peerDn", "sw_Vlan_policyOwner", "sw_Vlan_pubNwDn", "sw_Vlan_pubNwId", "sw_Vlan_pubNwName", "sw_Vlan_querierIpAddrs", "sw_Vlan_sharing", "sw_Vlan_snoopingEnabled", "sw_Vlan_switchId", "sw_Vlan_transport", "sw_Vlan_type", "sw_Vlan_vlanType", "sw_Vsan_defaultZoning", "sw_Vsan_epDn", "sw_Vsan_fcZoneSharingMode", "sw_Vsan_fcoeVlan", "sw_Vsan_id", "sw_Vsan_ifRole", "sw_Vsan_ifType", "sw_Vsan_lc", "sw_Vsan_locale", "sw_Vsan_monTrafDir", "sw_Vsan_name", "sw_Vsan_operState", "sw_Vsan_peerDn", "sw_Vsan_policyOwner", "sw_Vsan_switchId", "sw_Vsan_transport", "sw_Vsan_type", "sw_Vsan_zoningState", "sw_ZoneInitiatorMember_epDn", "sw_ZoneInitiatorMember_lc", "sw_ZoneInitiatorMember_name", "sw_ZoneInitiatorMember_peerDn", "sw_ZoneInitiatorMember_wwpn", "sw_ZoneTargetMember_epDn", "sw_ZoneTargetMember_lc", "sw_ZoneTargetMember_name", "sw_ZoneTargetMember_peerDn", "sw_ZoneTargetMember_wwpn", "swat_Action_evaluationMethod", "swat_Action_instanceMod", "swat_Action_interval", "swat_Action_maxHits", "swat_Action_name", "swat_Action_sleepDelay", "swat_Action_type", "swat_Condition_operation", "swat_Condition_varName", "swat_Condition_varValue", "swat_Injection_model", "swat_Injection_name", "swat_Injection_poolDn", "swat_Injection_revision", "swat_Injection_serial", "swat_Injection_vendor", "swat_Resultstats_activityName", "swat_Resultstats_falseHits", "swat_Resultstats_label", "swat_Resultstats_totalPasses", "swat_Resultstats_trueHits", "swat_Target_varName", "swat_Target_varValue", "swat_Trigger_name", "swat_Trigger_type", "synthetic_Directory_atime", "synthetic_Directory_blksize", "synthetic_Directory_blocks", "synthetic_Directory_ctime", "synthetic_Directory_dev", "synthetic_Directory_gid", "synthetic_Directory_ino", "synthetic_Directory_mode", "synthetic_Directory_mtime", "synthetic_Directory_name", "synthetic_Directory_nlink", "synthetic_Directory_path", "synthetic_Directory_rdev", "synthetic_Directory_size", "synthetic_Directory_uid", "synthetic_File_atime", "synthetic_File_blksize", "synthetic_File_blocks", "synthetic_File_ctime", "synthetic_File_dev", "synthetic_File_gid", "synthetic_File_ino", "synthetic_File_mode", "synthetic_File_mtime", "synthetic_File_name", "synthetic_File_nlink", "synthetic_File_path", "synthetic_File_rdev", "synthetic_File_size", "synthetic_File_uid", "synthetic_FsObjFsmStage_descr", "synthetic_FsObjFsmStage_lastUpdateTime", "synthetic_FsObjFsmStage_name", "synthetic_FsObjFsmStage_order", "synthetic_FsObjFsmStage_retry", "synthetic_FsObjFsmStage_stageStatus", "synthetic_FsObjFsmTask_completion", "synthetic_FsObjFsmTask_flags", "synthetic_FsObjFsmTask_item", "synthetic_FsObjFsmTask_seqId", "synthetic_FsObjFsm_completionTime", "synthetic_FsObjFsm_currentFsm", "synthetic_FsObjFsm_descr", "synthetic_FsObjFsm_fsmStatus", "synthetic_FsObjFsm_instanceId", "synthetic_FsObjFsm_progress", "synthetic_FsObjFsm_rmtErrCode", "synthetic_FsObjFsm_rmtErrDescr", "synthetic_FsObjFsm_rmtRslt", "synthetic_FsObj_fsmDescr", "synthetic_FsObj_fsmPrev", "synthetic_FsObj_fsmProgr", "synthetic_FsObj_fsmRmtInvErrCode", "synthetic_FsObj_fsmRmtInvErrDescr", "synthetic_FsObj_fsmRmtInvRslt", "synthetic_FsObj_fsmStageDescr", "synthetic_FsObj_fsmStamp", "synthetic_FsObj_fsmStatus", "synthetic_FsObj_fsmTry", "synthetic_FsObj_name", "synthetic_FsObj_path", "synthetic_Time_ts", "sysdebug_AutoCoreFileExportTargetFsmStage_descr", "sysdebug_AutoCoreFileExportTargetFsmStage_lastUpdateTime", "sysdebug_AutoCoreFileExportTargetFsmStage_name", "sysdebug_AutoCoreFileExportTargetFsmStage_order", "sysdebug_AutoCoreFileExportTargetFsmStage_retry", "sysdebug_AutoCoreFileExportTargetFsmStage_stageStatus", "sysdebug_AutoCoreFileExportTargetFsmTask_completion", "sysdebug_AutoCoreFileExportTargetFsmTask_flags", "sysdebug_AutoCoreFileExportTargetFsmTask_item", "sysdebug_AutoCoreFileExportTargetFsmTask_seqId", "sysdebug_AutoCoreFileExportTargetFsm_completionTime", "sysdebug_AutoCoreFileExportTargetFsm_currentFsm", "sysdebug_AutoCoreFileExportTargetFsm_descr", "sysdebug_AutoCoreFileExportTargetFsm_fsmStatus", "sysdebug_AutoCoreFileExportTargetFsm_instanceId", "sysdebug_AutoCoreFileExportTargetFsm_progress", "sysdebug_AutoCoreFileExportTargetFsm_rmtErrCode", "sysdebug_AutoCoreFileExportTargetFsm_rmtErrDescr", "sysdebug_AutoCoreFileExportTargetFsm_rmtRslt", "sysdebug_AutoCoreFileExportTarget_adminState", "sysdebug_AutoCoreFileExportTarget_descr", "sysdebug_AutoCoreFileExportTarget_exportFailureReason", "sysdebug_AutoCoreFileExportTarget_exportStatus", "sysdebug_AutoCoreFileExportTarget_fsmDescr", "sysdebug_AutoCoreFileExportTarget_fsmPrev", "sysdebug_AutoCoreFileExportTarget_fsmProgr", "sysdebug_AutoCoreFileExportTarget_fsmRmtInvErrCode", "sysdebug_AutoCoreFileExportTarget_fsmRmtInvErrDescr", "sysdebug_AutoCoreFileExportTarget_fsmRmtInvRslt", "sysdebug_AutoCoreFileExportTarget_fsmStageDescr", "sysdebug_AutoCoreFileExportTarget_fsmStamp", "sysdebug_AutoCoreFileExportTarget_fsmStatus", "sysdebug_AutoCoreFileExportTarget_fsmTry", "sysdebug_AutoCoreFileExportTarget_hostname", "sysdebug_AutoCoreFileExportTarget_intId", "sysdebug_AutoCoreFileExportTarget_name", "sysdebug_AutoCoreFileExportTarget_path", "sysdebug_AutoCoreFileExportTarget_policyLevel", "sysdebug_AutoCoreFileExportTarget_policyOwner", "sysdebug_AutoCoreFileExportTarget_port", "sysdebug_AutoCoreFileExportTarget_postAction", "sysdebug_AutoCoreFileExportTarget_proto", "sysdebug_BackupBehavior_action", "sysdebug_BackupBehavior_clearOnBackup", "sysdebug_BackupBehavior_format", "sysdebug_BackupBehavior_hostname", "sysdebug_BackupBehavior_interval", "sysdebug_BackupBehavior_proto", "sysdebug_BackupBehavior_pwd", "sysdebug_BackupBehavior_remotePath", "sysdebug_BackupBehavior_user", "sysdebug_CoreFileExportTarget_adminState", "sysdebug_CoreFileExportTarget_descr", "sysdebug_CoreFileExportTarget_exportFailureReason", "sysdebug_CoreFileExportTarget_exportStatus", "sysdebug_CoreFileExportTarget_hostname", "sysdebug_CoreFileExportTarget_intId", "sysdebug_CoreFileExportTarget_name", "sysdebug_CoreFileExportTarget_path", "sysdebug_CoreFileExportTarget_policyLevel", "sysdebug_CoreFileExportTarget_policyOwner", "sysdebug_CoreFileExportTarget_port", "sysdebug_CoreFileExportTarget_postAction", "sysdebug_CoreFileExportTarget_proto", "sysdebug_CoreFsmStage_descr", "sysdebug_CoreFsmStage_lastUpdateTime", "sysdebug_CoreFsmStage_name", "sysdebug_CoreFsmStage_order", "sysdebug_CoreFsmStage_retry", "sysdebug_CoreFsmStage_stageStatus", "sysdebug_CoreFsmTask_completion", "sysdebug_CoreFsmTask_flags", "sysdebug_CoreFsmTask_item", "sysdebug_CoreFsmTask_seqId", "sysdebug_CoreFsm_completionTime", "sysdebug_CoreFsm_currentFsm", "sysdebug_CoreFsm_descr", "sysdebug_CoreFsm_fsmStatus", "sysdebug_CoreFsm_instanceId", "sysdebug_CoreFsm_progress", "sysdebug_CoreFsm_rmtErrCode", "sysdebug_CoreFsm_rmtErrDescr", "sysdebug_CoreFsm_rmtRslt", "sysdebug_Core_adminState", "sysdebug_Core_descr", "sysdebug_Core_fsmDescr", "sysdebug_Core_fsmPrev", "sysdebug_Core_fsmProgr", "sysdebug_Core_fsmRmtInvErrCode", "sysdebug_Core_fsmRmtInvErrDescr", "sysdebug_Core_fsmRmtInvRslt", "sysdebug_Core_fsmStageDescr", "sysdebug_Core_fsmStamp", "sysdebug_Core_fsmStatus", "sysdebug_Core_fsmTry", "sysdebug_Core_name", "sysdebug_Core_operState", "sysdebug_Core_size", "sysdebug_Core_switchId", "sysdebug_Core_ts", "sysdebug_Core_uri", "sysdebug_Exporter_adminState", "sysdebug_Exporter_descr", "sysdebug_Exporter_hostname", "sysdebug_Exporter_intId", "sysdebug_Exporter_name", "sysdebug_Exporter_policyLevel", "sysdebug_Exporter_policyOwner", "sysdebug_Exporter_postAction", "sysdebug_Exporter_proto", "sysdebug_File_descr", "sysdebug_File_name", "sysdebug_File_size", "sysdebug_File_switchId", "sysdebug_File_ts", "sysdebug_File_uri", "sysdebug_LogControlDestinationFile_backupCount", "sysdebug_LogControlDestinationFile_defaultLevel", "sysdebug_LogControlDestinationFile_defaultSize", "sysdebug_LogControlDestinationFile_level", "sysdebug_LogControlDestinationFile_size", "sysdebug_LogControlDestinationSyslog_defaultLevel", "sysdebug_LogControlDestinationSyslog_level", "sysdebug_LogControlDomain_level", "sysdebug_LogControlDomain_levelFlag", "sysdebug_LogControlDomain_name", "sysdebug_LogControlDomain_persist", "sysdebug_LogControlDomain_reset", "sysdebug_LogControlEpFsmStage_descr", "sysdebug_LogControlEpFsmStage_lastUpdateTime", "sysdebug_LogControlEpFsmStage_name", "sysdebug_LogControlEpFsmStage_order", "sysdebug_LogControlEpFsmStage_retry", "sysdebug_LogControlEpFsmStage_stageStatus", "sysdebug_LogControlEpFsmTask_completion", "sysdebug_LogControlEpFsmTask_flags", "sysdebug_LogControlEpFsmTask_item", "sysdebug_LogControlEpFsmTask_seqId", "sysdebug_LogControlEpFsm_completionTime", "sysdebug_LogControlEpFsm_currentFsm", "sysdebug_LogControlEpFsm_descr", "sysdebug_LogControlEpFsm_fsmStatus", "sysdebug_LogControlEpFsm_instanceId", "sysdebug_LogControlEpFsm_progress", "sysdebug_LogControlEpFsm_rmtErrCode", "sysdebug_LogControlEpFsm_rmtErrDescr", "sysdebug_LogControlEpFsm_rmtRslt", "sysdebug_LogControlEp_fsmDescr", "sysdebug_LogControlEp_fsmPrev", "sysdebug_LogControlEp_fsmProgr", "sysdebug_LogControlEp_fsmRmtInvErrCode", "sysdebug_LogControlEp_fsmRmtInvErrDescr", "sysdebug_LogControlEp_fsmRmtInvRslt", "sysdebug_LogControlEp_fsmStageDescr", "sysdebug_LogControlEp_fsmStamp", "sysdebug_LogControlEp_fsmStatus", "sysdebug_LogControlEp_fsmTry", "sysdebug_LogControlEp_level", "sysdebug_LogControlEp_levelFlag", "sysdebug_LogControlEp_persist", "sysdebug_LogControlEp_reset", "sysdebug_LogControlModule_defaultLevel", "sysdebug_LogControlModule_level", "sysdebug_LogControlModule_name", "sysdebug_LogControlModule_reset", "sysdebug_MEpLogDef_descr", "sysdebug_MEpLogDef_intId", "sysdebug_MEpLogDef_name", "sysdebug_MEpLogDef_policyLevel", "sysdebug_MEpLogDef_policyOwner", "sysdebug_MEpLogDef_type", "sysdebug_MEpLogPolicy_descr", "sysdebug_MEpLogPolicy_intId", "sysdebug_MEpLogPolicy_name", "sysdebug_MEpLogPolicy_policyLevel", "sysdebug_MEpLogPolicy_policyOwner", "sysdebug_MEpLogPolicy_type", "sysdebug_MEpLog_adminState", "sysdebug_MEpLog_capacity", "sysdebug_MEpLog_id", "sysdebug_MEpLog_lastUpdate", "sysdebug_MEpLog_operState", "sysdebug_MEpLog_type", "sysdebug_ManualCoreFileExportTargetFsmStage_descr", "sysdebug_ManualCoreFileExportTargetFsmStage_lastUpdateTime", "sysdebug_ManualCoreFileExportTargetFsmStage_name", "sysdebug_ManualCoreFileExportTargetFsmStage_order", "sysdebug_ManualCoreFileExportTargetFsmStage_retry", "sysdebug_ManualCoreFileExportTargetFsmStage_stageStatus", "sysdebug_ManualCoreFileExportTargetFsmTask_completion", "sysdebug_ManualCoreFileExportTargetFsmTask_flags", "sysdebug_ManualCoreFileExportTargetFsmTask_item", "sysdebug_ManualCoreFileExportTargetFsmTask_seqId", "sysdebug_ManualCoreFileExportTargetFsm_completionTime", "sysdebug_ManualCoreFileExportTargetFsm_currentFsm", "sysdebug_ManualCoreFileExportTargetFsm_descr", "sysdebug_ManualCoreFileExportTargetFsm_fsmStatus", "sysdebug_ManualCoreFileExportTargetFsm_instanceId", "sysdebug_ManualCoreFileExportTargetFsm_progress", "sysdebug_ManualCoreFileExportTargetFsm_rmtErrCode", "sysdebug_ManualCoreFileExportTargetFsm_rmtErrDescr", "sysdebug_ManualCoreFileExportTargetFsm_rmtRslt", "sysdebug_ManualCoreFileExportTarget_adminState", "sysdebug_ManualCoreFileExportTarget_descr", "sysdebug_ManualCoreFileExportTarget_exportFailureReason", "sysdebug_ManualCoreFileExportTarget_exportStatus", "sysdebug_ManualCoreFileExportTarget_fsmDescr", "sysdebug_ManualCoreFileExportTarget_fsmPrev", "sysdebug_ManualCoreFileExportTarget_fsmProgr", "sysdebug_ManualCoreFileExportTarget_fsmRmtInvErrCode", "sysdebug_ManualCoreFileExportTarget_fsmRmtInvErrDescr", "sysdebug_ManualCoreFileExportTarget_fsmRmtInvRslt", "sysdebug_ManualCoreFileExportTarget_fsmStageDescr", "sysdebug_ManualCoreFileExportTarget_fsmStamp", "sysdebug_ManualCoreFileExportTarget_fsmStatus", "sysdebug_ManualCoreFileExportTarget_fsmTry", "sysdebug_ManualCoreFileExportTarget_hostname", "sysdebug_ManualCoreFileExportTarget_intId", "sysdebug_ManualCoreFileExportTarget_name", "sysdebug_ManualCoreFileExportTarget_path", "sysdebug_ManualCoreFileExportTarget_policyLevel", "sysdebug_ManualCoreFileExportTarget_policyOwner", "sysdebug_ManualCoreFileExportTarget_port", "sysdebug_ManualCoreFileExportTarget_postAction", "sysdebug_ManualCoreFileExportTarget_proto", "sysdebug_TechSupportCmdOpt_chassisCimcId", "sysdebug_TechSupportCmdOpt_chassisId", "sysdebug_TechSupportCmdOpt_chassisIomId", "sysdebug_TechSupportCmdOpt_cimcAdapterId", "sysdebug_TechSupportCmdOpt_fabExtId", "sysdebug_TechSupportCmdOpt_majorOptType", "sysdebug_TechSupportCmdOpt_rackServerAdapterId", "sysdebug_TechSupportCmdOpt_rackServerId", "sysdebug_TechSupportFsmStage_descr", "sysdebug_TechSupportFsmStage_lastUpdateTime", "sysdebug_TechSupportFsmStage_name", "sysdebug_TechSupportFsmStage_order", "sysdebug_TechSupportFsmStage_retry", "sysdebug_TechSupportFsmStage_stageStatus", "sysdebug_TechSupportFsmTask_completion", "sysdebug_TechSupportFsmTask_flags", "sysdebug_TechSupportFsmTask_item", "sysdebug_TechSupportFsmTask_seqId", "sysdebug_TechSupportFsm_completionTime", "sysdebug_TechSupportFsm_currentFsm", "sysdebug_TechSupportFsm_descr", "sysdebug_TechSupportFsm_fsmStatus", "sysdebug_TechSupportFsm_instanceId", "sysdebug_TechSupportFsm_progress", "sysdebug_TechSupportFsm_rmtErrCode", "sysdebug_TechSupportFsm_rmtErrDescr", "sysdebug_TechSupportFsm_rmtRslt", "sysdebug_TechSupport_adminState", "sysdebug_TechSupport_creationTS", "sysdebug_TechSupport_descr", "sysdebug_TechSupport_fsmDescr", "sysdebug_TechSupport_fsmPrev", "sysdebug_TechSupport_fsmProgr", "sysdebug_TechSupport_fsmRmtInvErrCode", "sysdebug_TechSupport_fsmRmtInvErrDescr", "sysdebug_TechSupport_fsmRmtInvRslt", "sysdebug_TechSupport_fsmStageDescr", "sysdebug_TechSupport_fsmStamp", "sysdebug_TechSupport_fsmStatus", "sysdebug_TechSupport_fsmTry", "sysdebug_TechSupport_name", "sysdebug_TechSupport_operState", "sysdebug_TechSupport_size", "sysdebug_TechSupport_switchId", "sysdebug_TechSupport_ts", "sysdebug_TechSupport_uri", "sysfile_Digest_creationTS", "sysfile_Digest_descr", "sysfile_Digest_name", "sysfile_Digest_size", "sysfile_Digest_source", "sysfile_Digest_switchId", "sysfile_Digest_ts", "sysfile_Digest_uri", "sysfile_Exporter_adminState", "sysfile_Exporter_descr", "sysfile_Exporter_hostname", "sysfile_Exporter_intId", "sysfile_Exporter_name", "sysfile_Exporter_policyLevel", "sysfile_Exporter_policyOwner", "sysfile_Exporter_postAction", "sysfile_Exporter_proto", "sysfile_Importer_adminState", "sysfile_Importer_descr", "sysfile_Importer_hostname", "sysfile_Importer_intId", "sysfile_Importer_name", "sysfile_Importer_policyLevel", "sysfile_Importer_policyOwner", "sysfile_Importer_postAction", "sysfile_Importer_proto", "sysfile_Instance_descr", "sysfile_Instance_name", "sysfile_Instance_size", "sysfile_Instance_switchId", "sysfile_Instance_ts", "sysfile_Instance_uri", "sysfile_MutationFsmStage_descr", "sysfile_MutationFsmStage_lastUpdateTime", "sysfile_MutationFsmStage_name", "sysfile_MutationFsmStage_order", "sysfile_MutationFsmStage_retry", "sysfile_MutationFsmStage_stageStatus", "sysfile_MutationFsmTask_completion", "sysfile_MutationFsmTask_flags", "sysfile_MutationFsmTask_item", "sysfile_MutationFsmTask_seqId", "sysfile_MutationFsm_completionTime", "sysfile_MutationFsm_currentFsm", "sysfile_MutationFsm_descr", "sysfile_MutationFsm_fsmStatus", "sysfile_MutationFsm_instanceId", "sysfile_MutationFsm_progress", "sysfile_MutationFsm_rmtErrCode", "sysfile_MutationFsm_rmtErrDescr", "sysfile_MutationFsm_rmtRslt", "sysfile_Mutation_action", "sysfile_Mutation_descr", "sysfile_Mutation_fsmDescr", "sysfile_Mutation_fsmPrev", "sysfile_Mutation_fsmProgr", "sysfile_Mutation_fsmRmtInvErrCode", "sysfile_Mutation_fsmRmtInvErrDescr", "sysfile_Mutation_fsmRmtInvRslt", "sysfile_Mutation_fsmStageDescr", "sysfile_Mutation_fsmStamp", "sysfile_Mutation_fsmStatus", "sysfile_Mutation_fsmTry", "top_MetaInf_ecode", "top_MetaInf_name", "top_System_address", "top_System_currentTime", "top_System_descr", "top_System_ipv6Addr", "top_System_mode", "top_System_name", "top_System_owner", "top_System_site", "top_System_systemUpTime", "trig_AbsWindow_concurCap", "trig_AbsWindow_date", "trig_AbsWindow_jobCount", "trig_AbsWindow_name", "trig_AbsWindow_procBreak", "trig_AbsWindow_procCap", "trig_AbsWindow_timeCap", "trig_Ack_acked", "trig_Ack_ackedBy", "trig_Ack_adminState", "trig_Ack_autoDelete", "trig_Ack_changeBy", "trig_Ack_changeDetails", "trig_Ack_changes", "trig_Ack_descr", "trig_Ack_disr", "trig_Ack_ignoreCap", "trig_Ack_intId", "trig_Ack_modified", "trig_Ack_name", "trig_Ack_operScheduler", "trig_Ack_operState", "trig_Ack_policyLevel", "trig_Ack_policyOwner", "trig_Ack_prevOperState", "trig_Ack_scheduler", "trig_BaseAbsWindow_concurCap", "trig_BaseAbsWindow_date", "trig_BaseAbsWindow_jobCount", "trig_BaseAbsWindow_name", "trig_BaseAbsWindow_procBreak", "trig_BaseAbsWindow_procCap", "trig_BaseAbsWindow_timeCap", "trig_BaseSched_adminState", "trig_BaseSched_descr", "trig_BaseSched_flgInitialActive", "trig_BaseSched_intId", "trig_BaseSched_name", "trig_BaseSched_operState", "trig_BaseSched_policyLevel", "trig_BaseSched_policyOwner", "trig_ClientToken_activityTs", "trig_ClientToken_id", "trig_ClientToken_operState", "trig_ConfAck_acked", "trig_ConfAck_ackedBy", "trig_ConfAck_adminState", "trig_ConfAck_autoDelete", "trig_ConfAck_changeBy", "trig_ConfAck_changeDetails", "trig_ConfAck_changes", "trig_ConfAck_configIssues", "trig_ConfAck_descr", "trig_ConfAck_disr", "trig_ConfAck_ignoreCap", "trig_ConfAck_intId", "trig_ConfAck_modified", "trig_ConfAck_name", "trig_ConfAck_operScheduler", "trig_ConfAck_operState", "trig_ConfAck_policyLevel", "trig_ConfAck_policyOwner", "trig_ConfAck_prevOperState", "trig_ConfAck_scheduler", "trig_Inst_adminState", "trig_Inst_descr", "trig_Inst_intId", "trig_Inst_name", "trig_Inst_operState", "trig_Inst_policyLevel", "trig_Inst_policyOwner", "trig_LocalAbsWindow_concurCap", "trig_LocalAbsWindow_date", "trig_LocalAbsWindow_jobCount", "trig_LocalAbsWindow_name", "trig_LocalAbsWindow_procBreak", "trig_LocalAbsWindow_procCap", "trig_LocalAbsWindow_timeCap", "trig_LocalSched_adminState", "trig_LocalSched_descr", "trig_LocalSched_flgInitialActive", "trig_LocalSched_intId", "trig_LocalSched_name", "trig_LocalSched_operState", "trig_LocalSched_policyLevel", "trig_LocalSched_policyOwner", "trig_Meta_adminState", "trig_Meta_descr", "trig_Meta_intId", "trig_Meta_jobCount", "trig_Meta_name", "trig_Meta_operState", "trig_Meta_policyLevel", "trig_Meta_policyOwner", "trig_Meta_schedName", "trig_Meta_trigTime", "trig_Meta_windowDn", "trig_RecurrWindow_concurCap", "trig_RecurrWindow_day", "trig_RecurrWindow_hour", "trig_RecurrWindow_jobCount", "trig_RecurrWindow_minute", "trig_RecurrWindow_name", "trig_RecurrWindow_procBreak", "trig_RecurrWindow_procCap", "trig_RecurrWindow_timeCap", "trig_ResAck_acked", "trig_ResAck_ackedBy", "trig_ResAck_adminState", "trig_ResAck_autoDelete", "trig_ResAck_changeBy", "trig_ResAck_changeDetails", "trig_ResAck_changes", "trig_ResAck_configIssues", "trig_ResAck_descr", "trig_ResAck_disr", "trig_ResAck_extDep", "trig_ResAck_ignoreCap", "trig_ResAck_intId", "trig_ResAck_modified", "trig_ResAck_name", "trig_ResAck_operScheduler", "trig_ResAck_operState", "trig_ResAck_policyLevel", "trig_ResAck_policyOwner", "trig_ResAck_prevOperState", "trig_ResAck_resProb", "trig_ResAck_scheduler", "trig_SchedWindow_concurCap", "trig_SchedWindow_jobCount", "trig_SchedWindow_name", "trig_SchedWindow_procBreak", "trig_SchedWindow_procCap", "trig_SchedWindow_timeCap", "trig_Sched_adminState", "trig_Sched_descr", "trig_Sched_flgInitialActive", "trig_Sched_intId", "trig_Sched_name", "trig_Sched_operState", "trig_Sched_policyLevel", "trig_Sched_policyOwner", "trig_Test_adminState", "trig_Test_autoDelete", "trig_Test_creationDate", "trig_Test_descr", "trig_Test_ignoreCap", "trig_Test_intId", "trig_Test_name", "trig_Test_operScheduler", "trig_Test_operState", "trig_Test_policyLevel", "trig_Test_policyOwner", "trig_Test_scheduler", "trig_Token_activityTs", "trig_Token_id", "trig_Token_operState", "trig_Triggerable_adminState", "trig_Triggerable_autoDelete", "trig_Triggerable_descr", "trig_Triggerable_ignoreCap", "trig_Triggerable_intId", "trig_Triggerable_name", "trig_Triggerable_operScheduler", "trig_Triggerable_operState", "trig_Triggerable_policyLevel", "trig_Triggerable_policyOwner", "trig_Triggerable_scheduler", "trig_Triggered_jobCount", "trig_Triggered_operState", "trig_Triggered_order", "trig_Triggered_trDn", "trig_Triggered_trId", "trig_Window_concurCap", "trig_Window_jobCount", "trig_Window_name", "trig_Window_procBreak", "trig_Window_procCap", "trig_Window_timeCap", "unspecified", "uuidpool_Addr_assigned", "uuidpool_Addr_assignedToDn", "uuidpool_Addr_id", "uuidpool_Addr_owner", "uuidpool_Block_from", "uuidpool_Block_to", "uuidpool_Format_format", "uuidpool_Format_mask", "uuidpool_Pool_assigned", "uuidpool_Pool_assignmentOrder", "uuidpool_Pool_descr", "uuidpool_Pool_intId", "uuidpool_Pool_name", "uuidpool_Pool_policyLevel", "uuidpool_Pool_policyOwner", "uuidpool_Pool_prefix", "uuidpool_Pool_size", "uuidpool_Poolable_id", "uuidpool_Poolable_poolDn", "uuidpool_Pooled_assigned", "uuidpool_Pooled_assignedToDn", "uuidpool_Pooled_id", "uuidpool_Pooled_poolableDn", "uuidpool_Pooled_prevAssignedToDn", "version_Application_detail", "version_Application_time", "version_Application_version", "version_Version_detail", "version_Version_time", "version_Version_version", "vm_Adaptor_dvsGenPortId", "vm_Adaptor_dvsPortId", "vm_Adaptor_dvsSwitchId", "vm_Adaptor_hostIfDn", "vm_Adaptor_name", "vm_Adaptor_owner", "vm_Adaptor_phSwitchId", "vm_Adaptor_profileId", "vm_Adaptor_profileName", "vm_Adaptor_statusChangeTs", "vm_Adaptor_switchId", "vm_Adaptor_type", "vm_Adaptor_uuid", "vm_Adaptor_vStatus", "vm_Adaptor_vcDn", "vm_Adaptor_vifId", "vm_Adaptor_vmndGuid", "vm_Adaptor_vmndName", "vm_Adaptor_vnicDn", "vm_ClientContainer_clInstType", "vm_ClientContainer_descr", "vm_ClientContainer_dvsDn", "vm_ClientContainer_dvsName", "vm_ClientContainer_intId", "vm_ClientContainer_lsDn", "vm_ClientContainer_model", "vm_ClientContainer_name", "vm_ClientContainer_pnDn", "vm_ClientContainer_policyLevel", "vm_ClientContainer_policyOwner", "vm_ClientContainer_statusChangeTs", "vm_ClientContainer_uuid", "vm_ClientContainer_vStatus", "vm_ClientContainer_vendor", "vm_ComputeEp_clInstType", "vm_ComputeEp_computeEpVendor", "vm_ComputeEp_descr", "vm_ComputeEp_dvsDn", "vm_ComputeEp_dvsName", "vm_ComputeEp_hostName", "vm_ComputeEp_intId", "vm_ComputeEp_lsDn", "vm_ComputeEp_model", "vm_ComputeEp_name", "vm_ComputeEp_pnDn", "vm_ComputeEp_policyLevel", "vm_ComputeEp_policyOwner", "vm_ComputeEp_statusChangeTs", "vm_ComputeEp_uuid", "vm_ComputeEp_vStatus", "vm_ComputeEp_vendor", "vm_Cont_descr", "vm_Cont_intId", "vm_Cont_name", "vm_Cont_own", "vm_Cont_policyLevel", "vm_Cont_policyOwner", "vm_Cont_uuid", "vm_DCOrg_descr", "vm_DCOrg_intId", "vm_DCOrg_name", "vm_DCOrg_own", "vm_DCOrg_policyLevel", "vm_DCOrg_policyOwner", "vm_DCOrg_uuid", "vm_DC_descr", "vm_DC_intId", "vm_DC_name", "vm_DC_own", "vm_DC_policyLevel", "vm_DC_policyOwner", "vm_DC_uuid", "vm_DirCont_descr", "vm_DirCont_intId", "vm_DirCont_name", "vm_DirCont_own", "vm_DirCont_policyLevel", "vm_DirCont_policyOwner", "vm_DirCont_uuid", "vm_Hba_dvsGenPortId", "vm_Hba_dvsPortId", "vm_Hba_dvsSwitchId", "vm_Hba_hostIfDn", "vm_Hba_name", "vm_Hba_owner", "vm_Hba_phSwitchId", "vm_Hba_profileId", "vm_Hba_profileName", "vm_Hba_statusChangeTs", "vm_Hba_switchId", "vm_Hba_type", "vm_Hba_uuid", "vm_Hba_vStatus", "vm_Hba_vcDn", "vm_Hba_vifId", "vm_Hba_vmndGuid", "vm_Hba_vmndName", "vm_Hba_vnicDn", "vm_Hba_wwnn", "vm_Hba_wwpn", "vm_Hv_clInstType", "vm_Hv_descr", "vm_Hv_dvsDn", "vm_Hv_dvsName", "vm_Hv_hvType", "vm_Hv_intId", "vm_Hv_lsDn", "vm_Hv_model", "vm_Hv_name", "vm_Hv_pnDn", "vm_Hv_policyLevel", "vm_Hv_policyOwner", "vm_Hv_statusChangeTs", "vm_Hv_uuid", "vm_Hv_vStatus", "vm_Hv_vendor", "vm_Instance_clInstType", "vm_Instance_descr", "vm_Instance_dvsDn", "vm_Instance_dvsName", "vm_Instance_hvDn", "vm_Instance_hvType", "vm_Instance_hvUuid", "vm_Instance_intId", "vm_Instance_lsDn", "vm_Instance_model", "vm_Instance_name", "vm_Instance_pnDn", "vm_Instance_policyLevel", "vm_Instance_policyOwner", "vm_Instance_statusChangeTs", "vm_Instance_uuid", "vm_Instance_vStatus", "vm_Instance_vendor", "vm_LifeCyclePolicyFsmStage_descr", "vm_LifeCyclePolicyFsmStage_lastUpdateTime", "vm_LifeCyclePolicyFsmStage_name", "vm_LifeCyclePolicyFsmStage_order", "vm_LifeCyclePolicyFsmStage_retry", "vm_LifeCyclePolicyFsmStage_stageStatus", "vm_LifeCyclePolicyFsmTask_completion", "vm_LifeCyclePolicyFsmTask_flags", "vm_LifeCyclePolicyFsmTask_item", "vm_LifeCyclePolicyFsmTask_seqId", "vm_LifeCyclePolicyFsm_completionTime", "vm_LifeCyclePolicyFsm_currentFsm", "vm_LifeCyclePolicyFsm_descr", "vm_LifeCyclePolicyFsm_fsmStatus", "vm_LifeCyclePolicyFsm_instanceId", "vm_LifeCyclePolicyFsm_progress", "vm_LifeCyclePolicyFsm_rmtErrCode", "vm_LifeCyclePolicyFsm_rmtErrDescr", "vm_LifeCyclePolicyFsm_rmtRslt", "vm_LifeCyclePolicy_descr", "vm_LifeCyclePolicy_fsmDescr", "vm_LifeCyclePolicy_fsmPrev", "vm_LifeCyclePolicy_fsmProgr", "vm_LifeCyclePolicy_fsmRmtInvErrCode", "vm_LifeCyclePolicy_fsmRmtInvErrDescr", "vm_LifeCyclePolicy_fsmRmtInvRslt", "vm_LifeCyclePolicy_fsmStageDescr", "vm_LifeCyclePolicy_fsmStamp", "vm_LifeCyclePolicy_fsmStatus", "vm_LifeCyclePolicy_fsmTry", "vm_LifeCyclePolicy_intId", "vm_LifeCyclePolicy_name", "vm_LifeCyclePolicy_policyLevel", "vm_LifeCyclePolicy_policyOwner", "vm_LifeCyclePolicy_vmRetention", "vm_LifeCyclePolicy_vnicRetention", "vm_Nic_dvsGenPortId", "vm_Nic_dvsPortId", "vm_Nic_dvsSwitchId", "vm_Nic_hostIfDn", "vm_Nic_macAddr", "vm_Nic_name", "vm_Nic_owner", "vm_Nic_phSwitchId", "vm_Nic_profileId", "vm_Nic_profileName", "vm_Nic_statusChangeTs", "vm_Nic_switchId", "vm_Nic_type", "vm_Nic_uuid", "vm_Nic_vStatus", "vm_Nic_vcDn", "vm_Nic_vifId", "vm_Nic_vmndGuid", "vm_Nic_vmndName", "vm_Nic_vnicDn", "vm_Org_descr", "vm_Org_intId", "vm_Org_name", "vm_Org_own", "vm_Org_policyLevel", "vm_Org_policyOwner", "vm_Org_uuid", "vm_Switch_adminState", "vm_Switch_descr", "vm_Switch_extKey", "vm_Switch_id", "vm_Switch_intId", "vm_Switch_keyInst", "vm_Switch_manager", "vm_Switch_name", "vm_Switch_own", "vm_Switch_policyLevel", "vm_Switch_policyOwner", "vm_Switch_uuid", "vm_Switch_vendor", "vm_Vif_adpVifId", "vm_Vif_cookie", "vm_Vif_linkState", "vm_Vif_operState", "vm_Vif_phSwitchId", "vm_Vif_phsAccessCardId", "vm_Vif_phsAccessPortId", "vm_Vif_phsBorderCardId", "vm_Vif_phsBorderPortId", "vm_Vif_stateQual", "vm_Vif_statusChangeTs", "vm_Vif_vStatus", "vm_Vif_vcDn", "vm_Vif_vifId", "vm_Virtual_clInstType", "vm_Virtual_descr", "vm_Virtual_dvsDn", "vm_Virtual_dvsName", "vm_Virtual_hvType", "vm_Virtual_intId", "vm_Virtual_lsDn", "vm_Virtual_model", "vm_Virtual_name", "vm_Virtual_pnDn", "vm_Virtual_policyLevel", "vm_Virtual_policyOwner", "vm_Virtual_statusChangeTs", "vm_Virtual_uuid", "vm_Virtual_vStatus", "vm_Virtual_vendor", "vm_Vlan_epDn", "vm_Vlan_id", "vm_Vlan_ifRole", "vm_Vlan_ifType", "vm_Vlan_locale", "vm_Vlan_name", "vm_Vlan_operState", "vm_Vlan_peerDn", "vm_Vlan_policyOwner", "vm_Vlan_pubNwDn", "vm_Vlan_pubNwId", "vm_Vlan_pubNwName", "vm_Vlan_sharing", "vm_Vlan_switchId", "vm_Vlan_transport", "vm_Vlan_type", "vm_VnicProfCl_dcName", "vm_VnicProfCl_descr", "vm_VnicProfCl_intId", "vm_VnicProfCl_name", "vm_VnicProfCl_orgPath", "vm_VnicProfCl_policyLevel", "vm_VnicProfCl_policyOwner", "vm_VnicProfCl_swName", "vm_VnicProfInst_descr", "vm_VnicProfInst_intId", "vm_VnicProfInst_maxPorts", "vm_VnicProfInst_name", "vm_VnicProfInst_policyLevel", "vm_VnicProfInst_policyOwner", "vm_VnicProfInst_profDn", "vm_VnicProfInst_profileType", "vm_Vsan_epDn", "vm_Vsan_fcoeVlan", "vm_Vsan_id", "vm_Vsan_ifRole", "vm_Vsan_ifType", "vm_Vsan_locale", "vm_Vsan_name", "vm_Vsan_operState", "vm_Vsan_peerDn", "vm_Vsan_policyOwner", "vm_Vsan_switchId", "vm_Vsan_transport", "vm_Vsan_type", "vm_Vsan_zoningState", "vnic_ABeh_action", "vnic_ABeh_descr", "vnic_ABeh_intId", "vnic_ABeh_name", "vnic_ABeh_nwTemplName", "vnic_ABeh_policyLevel", "vnic_ABeh_policyOwner", "vnic_ABeh_type", "vnic_AEtherIf_addr", "vnic_AEtherIf_configQualifier", "vnic_AEtherIf_defaultNet", "vnic_AEtherIf_name", "vnic_AEtherIf_operState", "vnic_AEtherIf_operVnetDn", "vnic_AEtherIf_operVnetName", "vnic_AEtherIf_owner", "vnic_AEtherIf_switchId", "vnic_AEtherIf_type", "vnic_AEtherIf_vnet", "vnic_AFcIf_configQualifier", "vnic_AFcIf_initiator", "vnic_AFcIf_name", "vnic_AFcIf_operState", "vnic_AFcIf_operVnetDn", "vnic_AFcIf_operVnetName", "vnic_AFcIf_owner", "vnic_AFcIf_switchId", "vnic_AFcIf_type", "vnic_AFcIf_vnet", "vnic_AGroup_adaptorProfileName", "vnic_AGroup_descr", "vnic_AGroup_identPoolName", "vnic_AGroup_intId", "vnic_AGroup_name", "vnic_AGroup_nwTemplName", "vnic_AGroup_operStatsPolicyName", "vnic_AGroup_policyLevel", "vnic_AGroup_policyOwner", "vnic_AGroup_qosPolicyName", "vnic_AGroup_statsPolicyName", "vnic_AIpcIf_addr", "vnic_AIpcIf_configQualifier", "vnic_AIpcIf_defaultNet", "vnic_AIpcIf_name", "vnic_AIpcIf_operState", "vnic_AIpcIf_operVnetDn", "vnic_AIpcIf_operVnetName", "vnic_AIpcIf_owner", "vnic_AIpcIf_switchId", "vnic_AIpcIf_type", "vnic_AIpcIf_vnet", "vnic_AScsiIf_addr", "vnic_AScsiIf_configQualifier", "vnic_AScsiIf_name", "vnic_AScsiIf_operState", "vnic_AScsiIf_operVnetDn", "vnic_AScsiIf_operVnetName", "vnic_AScsiIf_owner", "vnic_AScsiIf_switchId", "vnic_AScsiIf_type", "vnic_AScsiIf_vnet", "vnic_BootIpPolicy_descr", "vnic_BootIpPolicy_intId", "vnic_BootIpPolicy_name", "vnic_BootIpPolicy_policyLevel", "vnic_BootIpPolicy_policyOwner", "vnic_BootIpPolicy_poolName", "vnic_BootTarget_lun", "vnic_BootTarget_wwn", "vnic_ConReq_descr", "vnic_ConReq_intId", "vnic_ConReq_name", "vnic_ConReq_policyLevel", "vnic_ConReq_policyOwner", "vnic_ConnDef_lanConnPolicyName", "vnic_ConnDef_operLanConnPolicyName", "vnic_ConnDef_operSanConnPolicyName", "vnic_ConnDef_sanConnPolicyName", "vnic_Connection_name", "vnic_Connection_owner", "vnic_Connection_switchId", "vnic_Connection_type", "vnic_DefBeh_action", "vnic_DefBeh_descr", "vnic_DefBeh_intId", "vnic_DefBeh_name", "vnic_DefBeh_nwTemplName", "vnic_DefBeh_policyLevel", "vnic_DefBeh_policyOwner", "vnic_DefBeh_type", "vnic_DynamicConPolicyRef_conPolicyName", "vnic_DynamicConPolicyRef_operConPolicyName", "vnic_DynamicConPolicy_adaptorProfileName", "vnic_DynamicConPolicy_descr", "vnic_DynamicConPolicy_dynamicEth", "vnic_DynamicConPolicy_intId", "vnic_DynamicConPolicy_mtu", "vnic_DynamicConPolicy_name", "vnic_DynamicConPolicy_namingPrefix", "vnic_DynamicConPolicy_policyLevel", "vnic_DynamicConPolicy_policyOwner", "vnic_DynamicConPolicy_protection", "vnic_DynamicConReq_adaptorProfileName", "vnic_DynamicConReq_descr", "vnic_DynamicConReq_dynamicEth", "vnic_DynamicConReq_intId", "vnic_DynamicConReq_mtu", "vnic_DynamicConReq_name", "vnic_DynamicConReq_namingPrefix", "vnic_DynamicConReq_policyLevel", "vnic_DynamicConReq_policyOwner", "vnic_DynamicConReq_protection", "vnic_DynamicCon_adaptorProfileName", "vnic_DynamicCon_descr", "vnic_DynamicCon_dynamicEth", "vnic_DynamicCon_intId", "vnic_DynamicCon_mtu", "vnic_DynamicCon_name", "vnic_DynamicCon_namingPrefix", "vnic_DynamicCon_policyLevel", "vnic_DynamicCon_policyOwner", "vnic_DynamicCon_protection", "vnic_DynamicIdUniverse_descr", "vnic_DynamicIdUniverse_intId", "vnic_DynamicIdUniverse_name", "vnic_DynamicIdUniverse_policyLevel", "vnic_DynamicIdUniverse_policyOwner", "vnic_DynamicProviderEp_chassisId", "vnic_DynamicProviderEp_portId", "vnic_DynamicProviderEp_slotId", "vnic_DynamicProviderEp_switchId", "vnic_DynamicProvider_name", "vnic_EthLif_addr", "vnic_EthLif_name", "vnic_EthLif_nicDn", "vnic_EthLif_owner", "vnic_EthLif_switchId", "vnic_EthLif_type", "vnic_EthLif_vnicDn", "vnic_EtherBaseIf_addr", "vnic_EtherBaseIf_configQualifier", "vnic_EtherBaseIf_defaultNet", "vnic_EtherBaseIf_name", "vnic_EtherBaseIf_operState", "vnic_EtherBaseIf_operVnetDn", "vnic_EtherBaseIf_operVnetName", "vnic_EtherBaseIf_owner", "vnic_EtherBaseIf_switchId", "vnic_EtherBaseIf_type", "vnic_EtherBaseIf_vnet", "vnic_EtherBase_adaptorProfileName", "vnic_EtherBase_addr", "vnic_EtherBase_adminVcon", "vnic_EtherBase_bootDev", "vnic_EtherBase_configQualifier", "vnic_EtherBase_configState", "vnic_EtherBase_equipmentDn", "vnic_EtherBase_identPoolName", "vnic_EtherBase_instType", "vnic_EtherBase_mtu", "vnic_EtherBase_name", "vnic_EtherBase_nwCtrlPolicyName", "vnic_EtherBase_nwTemplName", "vnic_EtherBase_operAdaptorProfileName", "vnic_EtherBase_operIdentPoolName", "vnic_EtherBase_operNwCtrlPolicyName", "vnic_EtherBase_operNwTemplName", "vnic_EtherBase_operOrder", "vnic_EtherBase_operPinToGroupName", "vnic_EtherBase_operQosPolicyName", "vnic_EtherBase_operSpeed", "vnic_EtherBase_operStatsPolicyName", "vnic_EtherBase_operVcon", "vnic_EtherBase_order", "vnic_EtherBase_owner", "vnic_EtherBase_pinToGroupName", "vnic_EtherBase_qosPolicyName", "vnic_EtherBase_statsPolicyName", "vnic_EtherBase_switchId", "vnic_EtherBase_type", "vnic_EtherIf_addr", "vnic_EtherIf_configQualifier", "vnic_EtherIf_defaultNet", "vnic_EtherIf_name", "vnic_EtherIf_operState", "vnic_EtherIf_operVnetDn", "vnic_EtherIf_operVnetName", "vnic_EtherIf_owner", "vnic_EtherIf_switchId", "vnic_EtherIf_type", "vnic_EtherIf_vnet", "vnic_Ether_adaptorProfileName", "vnic_Ether_addr", "vnic_Ether_adminVcon", "vnic_Ether_bootDev", "vnic_Ether_configQualifier", "vnic_Ether_configState", "vnic_Ether_dynamicId", "vnic_Ether_equipmentDn", "vnic_Ether_identPoolName", "vnic_Ether_instType", "vnic_Ether_mtu", "vnic_Ether_name", "vnic_Ether_nwCtrlPolicyName", "vnic_Ether_nwTemplName", "vnic_Ether_operAdaptorProfileName", "vnic_Ether_operIdentPoolName", "vnic_Ether_operNwCtrlPolicyName", "vnic_Ether_operNwTemplName", "vnic_Ether_operOrder", "vnic_Ether_operPinToGroupName", "vnic_Ether_operQosPolicyName", "vnic_Ether_operSpeed", "vnic_Ether_operStatsPolicyName", "vnic_Ether_operVcon", "vnic_Ether_order", "vnic_Ether_owner", "vnic_Ether_pfDn", "vnic_Ether_pinToGroupName", "vnic_Ether_qosPolicyName", "vnic_Ether_statsPolicyName", "vnic_Ether_switchId", "vnic_Ether_type", "vnic_Ether_virtualizationPreference", "vnic_FcBase_adaptorProfileName", "vnic_FcBase_addr", "vnic_FcBase_adminVcon", "vnic_FcBase_bootDev", "vnic_FcBase_configQualifier", "vnic_FcBase_configState", "vnic_FcBase_equipmentDn", "vnic_FcBase_identPoolName", "vnic_FcBase_instType", "vnic_FcBase_maxDataFieldSize", "vnic_FcBase_name", "vnic_FcBase_nodeAddr", "vnic_FcBase_nwTemplName", "vnic_FcBase_operAdaptorProfileName", "vnic_FcBase_operIdentPoolName", "vnic_FcBase_operNwTemplName", "vnic_FcBase_operOrder", "vnic_FcBase_operPinToGroupName", "vnic_FcBase_operQosPolicyName", "vnic_FcBase_operSpeed", "vnic_FcBase_operStatsPolicyName", "vnic_FcBase_operVcon", "vnic_FcBase_order", "vnic_FcBase_owner", "vnic_FcBase_persBind", "vnic_FcBase_pinToGroupName", "vnic_FcBase_qosPolicyName", "vnic_FcBase_statsPolicyName", "vnic_FcBase_switchId", "vnic_FcBase_type", "vnic_FcGroupDef_adaptorProfileName", "vnic_FcGroupDef_descr", "vnic_FcGroupDef_identPoolName", "vnic_FcGroupDef_intId", "vnic_FcGroupDef_maxDataFieldSize", "vnic_FcGroupDef_name", "vnic_FcGroupDef_nwTemplName", "vnic_FcGroupDef_operStatsPolicyName", "vnic_FcGroupDef_operStorageConnPolicyName", "vnic_FcGroupDef_policyLevel", "vnic_FcGroupDef_policyOwner", "vnic_FcGroupDef_qosPolicyName", "vnic_FcGroupDef_statsPolicyName", "vnic_FcGroupDef_storageConnPolicyName", "vnic_FcGroupTempl_adaptorProfileName", "vnic_FcGroupTempl_descr", "vnic_FcGroupTempl_identPoolName", "vnic_FcGroupTempl_intId", "vnic_FcGroupTempl_maxDataFieldSize", "vnic_FcGroupTempl_name", "vnic_FcGroupTempl_nwTemplName", "vnic_FcGroupTempl_operStatsPolicyName", "vnic_FcGroupTempl_operStorageConnPolicyName", "vnic_FcGroupTempl_policyLevel", "vnic_FcGroupTempl_policyOwner", "vnic_FcGroupTempl_qosPolicyName", "vnic_FcGroupTempl_statsPolicyName", "vnic_FcGroupTempl_storageConnPolicyName", "vnic_FcGroupTempl_templType", "vnic_FcIf_configQualifier", "vnic_FcIf_initiator", "vnic_FcIf_name", "vnic_FcIf_operState", "vnic_FcIf_operVnetDn", "vnic_FcIf_operVnetName", "vnic_FcIf_owner", "vnic_FcIf_switchId", "vnic_FcIf_type", "vnic_FcIf_vnet", "vnic_FcLif_addr", "vnic_FcLif_name", "vnic_FcLif_nicDn", "vnic_FcLif_owner", "vnic_FcLif_switchId", "vnic_FcLif_type", "vnic_FcLif_vnicDn", "vnic_FcNode_addr", "vnic_FcNode_identPoolName", "vnic_FcNode_maxDerivableWWPN", "vnic_FcNode_operIdentPoolName", "vnic_FcNode_owner", "vnic_FcOEIf_configQualifier", "vnic_FcOEIf_initiator", "vnic_FcOEIf_name", "vnic_FcOEIf_operState", "vnic_FcOEIf_operVnetDn", "vnic_FcOEIf_operVnetName", "vnic_FcOEIf_owner", "vnic_FcOEIf_switchId", "vnic_FcOEIf_type", "vnic_FcOEIf_vnet", "vnic_Fc_adaptorProfileName", "vnic_Fc_addr", "vnic_Fc_adminVcon", "vnic_Fc_bootDev", "vnic_Fc_configQualifier", "vnic_Fc_configState", "vnic_Fc_equipmentDn", "vnic_Fc_identPoolName", "vnic_Fc_instType", "vnic_Fc_maxDataFieldSize", "vnic_Fc_name", "vnic_Fc_nodeAddr", "vnic_Fc_nwTemplName", "vnic_Fc_operAdaptorProfileName", "vnic_Fc_operIdentPoolName", "vnic_Fc_operNwTemplName", "vnic_Fc_operOrder", "vnic_Fc_operPinToGroupName", "vnic_Fc_operQosPolicyName", "vnic_Fc_operSpeed", "vnic_Fc_operStatsPolicyName", "vnic_Fc_operVcon", "vnic_Fc_order", "vnic_Fc_owner", "vnic_Fc_persBind", "vnic_Fc_persBindClear", "vnic_Fc_pinToGroupName", "vnic_Fc_qosPolicyName", "vnic_Fc_statsPolicyName", "vnic_Fc_switchId", "vnic_Fc_type", "vnic_IPIf_configQualifier", "vnic_IPIf_name", "vnic_IPIf_operState", "vnic_IPIf_operVnetDn", "vnic_IPIf_operVnetName", "vnic_IPIf_owner", "vnic_IPIf_switchId", "vnic_IPIf_type", "vnic_IPIf_vnet", "vnic_IPv4Dhcp_addr", "vnic_IPv4Dhcp_defGw", "vnic_IPv4Dhcp_subnet", "vnic_IPv4Dns_addr", "vnic_IPv4Dns_defGw", "vnic_IPv4Dns_pref", "vnic_IPv4Dns_subnet", "vnic_IPv4If_addr", "vnic_IPv4If_configQualifier", "vnic_IPv4If_name", "vnic_IPv4If_operState", "vnic_IPv4If_operVnetDn", "vnic_IPv4If_operVnetName", "vnic_IPv4If_owner", "vnic_IPv4If_switchId", "vnic_IPv4If_type", "vnic_IPv4If_vnet", "vnic_IPv4IscsiAddr_addr", "vnic_IPv4IscsiAddr_defGw", "vnic_IPv4IscsiAddr_primDns", "vnic_IPv4IscsiAddr_secDns", "vnic_IPv4IscsiAddr_subnet", "vnic_IPv4PooledIscsiAddr_addr", "vnic_IPv4PooledIscsiAddr_defGw", "vnic_IPv4PooledIscsiAddr_identPoolName", "vnic_IPv4PooledIscsiAddr_operIdentPoolName", "vnic_IPv4PooledIscsiAddr_primDns", "vnic_IPv4PooledIscsiAddr_secDns", "vnic_IPv4PooledIscsiAddr_subnet", "vnic_IPv4StaticRoute_addr", "vnic_IPv4StaticRoute_defGw", "vnic_IPv4StaticRoute_gwAddr", "vnic_IPv4StaticRoute_gwSubnet", "vnic_IPv4StaticRoute_subnet", "vnic_IScsiAutoTargetIf_dhcpVendorId", "vnic_IScsiBase_adaptorProfileName", "vnic_IScsiBase_addr", "vnic_IScsiBase_adminVcon", "vnic_IScsiBase_bootDev", "vnic_IScsiBase_configQualifier", "vnic_IScsiBase_configState", "vnic_IScsiBase_equipmentDn", "vnic_IScsiBase_identPoolName", "vnic_IScsiBase_instType", "vnic_IScsiBase_name", "vnic_IScsiBase_nwTemplName", "vnic_IScsiBase_operAdaptorProfileName", "vnic_IScsiBase_operIdentPoolName", "vnic_IScsiBase_operOrder", "vnic_IScsiBase_operSpeed", "vnic_IScsiBase_operStatsPolicyName", "vnic_IScsiBase_operVcon", "vnic_IScsiBase_order", "vnic_IScsiBase_owner", "vnic_IScsiBase_pinToGroupName", "vnic_IScsiBase_qosPolicyName", "vnic_IScsiBase_statsPolicyName", "vnic_IScsiBase_switchId", "vnic_IScsiBase_type", "vnic_IScsiBase_vnicName", "vnic_IScsiBootParams_descr", "vnic_IScsiBootParams_intId", "vnic_IScsiBootParams_name", "vnic_IScsiBootParams_policyLevel", "vnic_IScsiBootParams_policyOwner", "vnic_IScsiBootVnic_authProfileName", "vnic_IScsiBootVnic_descr", "vnic_IScsiBootVnic_initiatorName", "vnic_IScsiBootVnic_intId", "vnic_IScsiBootVnic_iqnIdentPoolName", "vnic_IScsiBootVnic_name", "vnic_IScsiBootVnic_operAuthProfileName", "vnic_IScsiBootVnic_operIqnIdentPoolName", "vnic_IScsiBootVnic_policyLevel", "vnic_IScsiBootVnic_policyOwner", "vnic_IScsiLCP_adaptorProfileName", "vnic_IScsiLCP_addr", "vnic_IScsiLCP_adminVcon", "vnic_IScsiLCP_bootDev", "vnic_IScsiLCP_configQualifier", "vnic_IScsiLCP_configState", "vnic_IScsiLCP_equipmentDn", "vnic_IScsiLCP_identPoolName", "vnic_IScsiLCP_instType", "vnic_IScsiLCP_name", "vnic_IScsiLCP_nwTemplName", "vnic_IScsiLCP_operAdaptorProfileName", "vnic_IScsiLCP_operIdentPoolName", "vnic_IScsiLCP_operOrder", "vnic_IScsiLCP_operSpeed", "vnic_IScsiLCP_operStatsPolicyName", "vnic_IScsiLCP_operVcon", "vnic_IScsiLCP_order", "vnic_IScsiLCP_owner", "vnic_IScsiLCP_pinToGroupName", "vnic_IScsiLCP_qosPolicyName", "vnic_IScsiLCP_statsPolicyName", "vnic_IScsiLCP_switchId", "vnic_IScsiLCP_type", "vnic_IScsiLCP_vnicName", "vnic_IScsiNode_initNameSuffix", "vnic_IScsiNode_initiatorName", "vnic_IScsiNode_iqnIdentPoolName", "vnic_IScsiNode_operIqnIdentPoolName", "vnic_IScsiNode_owner", "vnic_IScsiStaticTargetIf_authProfileName", "vnic_IScsiStaticTargetIf_ipAddress", "vnic_IScsiStaticTargetIf_name", "vnic_IScsiStaticTargetIf_operAuthProfileName", "vnic_IScsiStaticTargetIf_port", "vnic_IScsiStaticTargetIf_priority", "vnic_IScsi_adaptorProfileName", "vnic_IScsi_addr", "vnic_IScsi_adminVcon", "vnic_IScsi_authProfileName", "vnic_IScsi_bootDev", "vnic_IScsi_configQualifier", "vnic_IScsi_configState", "vnic_IScsi_equipmentDn", "vnic_IScsi_ethEpDn", "vnic_IScsi_extIPState", "vnic_IScsi_identPoolName", "vnic_IScsi_initNameSuffix", "vnic_IScsi_initiatorName", "vnic_IScsi_instType", "vnic_IScsi_iqnIdentPoolName", "vnic_IScsi_name", "vnic_IScsi_nwTemplName", "vnic_IScsi_operAdaptorProfileName", "vnic_IScsi_operAuthProfileName", "vnic_IScsi_operIdentPoolName", "vnic_IScsi_operIqnIdentPoolName", "vnic_IScsi_operOrder", "vnic_IScsi_operSpeed", "vnic_IScsi_operStatsPolicyName", "vnic_IScsi_operVcon", "vnic_IScsi_order", "vnic_IScsi_owner", "vnic_IScsi_pinToGroupName", "vnic_IScsi_qosPolicyName", "vnic_IScsi_statsPolicyName", "vnic_IScsi_switchId", "vnic_IScsi_type", "vnic_IScsi_vnicDefType", "vnic_IScsi_vnicName", "vnic_If_configQualifier", "vnic_If_name", "vnic_If_operState", "vnic_If_operVnetDn", "vnic_If_operVnetName", "vnic_If_owner", "vnic_If_switchId", "vnic_If_type", "vnic_If_vnet", "vnic_InternalProfile_descr", "vnic_InternalProfile_intId", "vnic_InternalProfile_maxPorts", "vnic_InternalProfile_name", "vnic_InternalProfile_policyLevel", "vnic_InternalProfile_policyOwner", "vnic_IpV4AddrConf_addr", "vnic_IpV4AddrConf_defGw", "vnic_IpV4AddrConf_subnet", "vnic_IpV4AddrExplConf_addr", "vnic_IpV4AddrExplConf_defGw", "vnic_IpV4AddrExplConf_subnet", "vnic_IpV4Addr_addr", "vnic_IpV4Addr_defGw", "vnic_IpV4Addr_subnet", "vnic_IpV4History_oldIpV4Addr", "vnic_IpV4MgmtPooledAddr_addr", "vnic_IpV4MgmtPooledAddr_defGw", "vnic_IpV4MgmtPooledAddr_name", "vnic_IpV4MgmtPooledAddr_operName", "vnic_IpV4MgmtPooledAddr_subnet", "vnic_IpV4PooledAddr_addr", "vnic_IpV4PooledAddr_defGw", "vnic_IpV4PooledAddr_name", "vnic_IpV4PooledAddr_operName", "vnic_IpV4PooledAddr_subnet", "vnic_IpV4ProfDerivedAddr_addr", "vnic_IpV4ProfDerivedAddr_defGw", "vnic_IpV4ProfDerivedAddr_subnet", "vnic_IpV4StaticAddr_addr", "vnic_IpV4StaticAddr_defGw", "vnic_IpV4StaticAddr_subnet", "vnic_IpV6AddrConf_addr", "vnic_IpV6AddrConf_defGw", "vnic_IpV6AddrConf_prefix", "vnic_IpV6AddrExplConf_addr", "vnic_IpV6AddrExplConf_defGw", "vnic_IpV6AddrExplConf_prefix", "vnic_IpV6Addr_addr", "vnic_IpV6Addr_defGw", "vnic_IpV6Addr_prefix", "vnic_IpV6History_oldIpV6Addr", "vnic_IpV6MgmtPooledAddr_addr", "vnic_IpV6MgmtPooledAddr_defGw", "vnic_IpV6MgmtPooledAddr_name", "vnic_IpV6MgmtPooledAddr_operName", "vnic_IpV6MgmtPooledAddr_prefix", "vnic_IpV6StaticAddr_addr", "vnic_IpV6StaticAddr_defGw", "vnic_IpV6StaticAddr_prefix", "vnic_IpcIf_addr", "vnic_IpcIf_configQualifier", "vnic_IpcIf_defaultNet", "vnic_IpcIf_name", "vnic_IpcIf_operState", "vnic_IpcIf_operVnetDn", "vnic_IpcIf_operVnetName", "vnic_IpcIf_owner", "vnic_IpcIf_switchId", "vnic_IpcIf_type", "vnic_IpcIf_vnet", "vnic_Ipc_adaptorProfileName", "vnic_Ipc_addr", "vnic_Ipc_adminVcon", "vnic_Ipc_bootDev", "vnic_Ipc_configQualifier", "vnic_Ipc_configState", "vnic_Ipc_equipmentDn", "vnic_Ipc_identPoolName", "vnic_Ipc_instType", "vnic_Ipc_mtu", "vnic_Ipc_name", "vnic_Ipc_nwCtrlPolicyName", "vnic_Ipc_nwTemplName", "vnic_Ipc_operAdaptorProfileName", "vnic_Ipc_operIdentPoolName", "vnic_Ipc_operNwCtrlPolicyName", "vnic_Ipc_operNwTemplName", "vnic_Ipc_operOrder", "vnic_Ipc_operPinToGroupName", "vnic_Ipc_operQosPolicyName", "vnic_Ipc_operSpeed", "vnic_Ipc_operStatsPolicyName", "vnic_Ipc_operVcon", "vnic_Ipc_order", "vnic_Ipc_owner", "vnic_Ipc_pinToGroupName", "vnic_Ipc_qosPolicyName", "vnic_Ipc_statsPolicyName", "vnic_Ipc_switchId", "vnic_Ipc_type", "vnic_IqnHistory_oldInitiatorName", "vnic_L2If_configQualifier", "vnic_L2If_name", "vnic_L2If_operState", "vnic_L2If_operVnetDn", "vnic_L2If_operVnetName", "vnic_L2If_owner", "vnic_L2If_switchId", "vnic_L2If_type", "vnic_L2If_vnet", "vnic_L2Lif_name", "vnic_L2Lif_nicDn", "vnic_L2Lif_owner", "vnic_L2Lif_switchId", "vnic_L2Lif_type", "vnic_L2Lif_vnicDn", "vnic_L3If_configQualifier", "vnic_L3If_name", "vnic_L3If_operState", "vnic_L3If_operVnetDn", "vnic_L3If_operVnetName", "vnic_L3If_owner", "vnic_L3If_switchId", "vnic_L3If_type", "vnic_L3If_vnet", "vnic_LanConnPolicy_descr", "vnic_LanConnPolicy_intId", "vnic_LanConnPolicy_name", "vnic_LanConnPolicy_policyLevel", "vnic_LanConnPolicy_policyOwner", "vnic_LanConnTempl_descr", "vnic_LanConnTempl_identPoolName", "vnic_LanConnTempl_intId", "vnic_LanConnTempl_mtu", "vnic_LanConnTempl_name", "vnic_LanConnTempl_nwCtrlPolicyName", "vnic_LanConnTempl_operIdentPoolName", "vnic_LanConnTempl_operNwCtrlPolicyName", "vnic_LanConnTempl_operQosPolicyName", "vnic_LanConnTempl_operStatsPolicyName", "vnic_LanConnTempl_pinToGroupName", "vnic_LanConnTempl_policyLevel", "vnic_LanConnTempl_policyOwner", "vnic_LanConnTempl_qosPolicyName", "vnic_LanConnTempl_statsPolicyName", "vnic_LanConnTempl_switchId", "vnic_LanConnTempl_target", "vnic_LanConnTempl_templType", "vnic_LifVlan_addr", "vnic_LifVlan_configQualifier", "vnic_LifVlan_defaultNet", "vnic_LifVlan_name", "vnic_LifVlan_operState", "vnic_LifVlan_operVnetDn", "vnic_LifVlan_operVnetName", "vnic_LifVlan_owner", "vnic_LifVlan_switchId", "vnic_LifVlan_type", "vnic_LifVlan_vnet", "vnic_LifVsan_configQualifier", "vnic_LifVsan_initiator", "vnic_LifVsan_name", "vnic_LifVsan_operState", "vnic_LifVsan_operVnetDn", "vnic_LifVsan_operVnetName", "vnic_LifVsan_owner", "vnic_LifVsan_switchId", "vnic_LifVsan_type", "vnic_LifVsan_vnet", "vnic_Lun_bootable", "vnic_Lun_id", "vnic_MacHistory_oldaddr", "vnic_NicConn_name", "vnic_NicConn_owner", "vnic_NicConn_switchId", "vnic_NicConn_type", "vnic_OProfileAlias_alias", "vnic_OProfileAlias_mgmtPlane", "vnic_OProfileAlias_vSwitchId", "vnic_OProfileAlias_vSwitchName", "vnic_ProfileAlias_alias", "vnic_ProfileAlias_swUuid", "vnic_ProfileRef_name", "vnic_ProfileRef_sourceDn", "vnic_ProfileSetFsmStage_descr", "vnic_ProfileSetFsmStage_lastUpdateTime", "vnic_ProfileSetFsmStage_name", "vnic_ProfileSetFsmStage_order", "vnic_ProfileSetFsmStage_retry", "vnic_ProfileSetFsmStage_stageStatus", "vnic_ProfileSetFsmTask_completion", "vnic_ProfileSetFsmTask_flags", "vnic_ProfileSetFsmTask_item", "vnic_ProfileSetFsmTask_seqId", "vnic_ProfileSetFsm_completionTime", "vnic_ProfileSetFsm_currentFsm", "vnic_ProfileSetFsm_descr", "vnic_ProfileSetFsm_fsmStatus", "vnic_ProfileSetFsm_instanceId", "vnic_ProfileSetFsm_progress", "vnic_ProfileSetFsm_rmtErrCode", "vnic_ProfileSetFsm_rmtErrDescr", "vnic_ProfileSetFsm_rmtRslt", "vnic_ProfileSet_fsmDescr", "vnic_ProfileSet_fsmPrev", "vnic_ProfileSet_fsmProgr", "vnic_ProfileSet_fsmRmtInvErrCode", "vnic_ProfileSet_fsmRmtInvErrDescr", "vnic_ProfileSet_fsmRmtInvRslt", "vnic_ProfileSet_fsmStageDescr", "vnic_ProfileSet_fsmStamp", "vnic_ProfileSet_fsmStatus", "vnic_ProfileSet_fsmTry", "vnic_ProfileSet_genNum", "vnic_Profile_cdp", "vnic_Profile_configQualifier", "vnic_Profile_cos", "vnic_Profile_descr", "vnic_Profile_forgeMac", "vnic_Profile_hostNwIOPerf", "vnic_Profile_intId", "vnic_Profile_macRegisterMode", "vnic_Profile_maxPorts", "vnic_Profile_name", "vnic_Profile_nwCtrlPolicyName", "vnic_Profile_operNwCtrlPolicyName", "vnic_Profile_operQosPolicyName", "vnic_Profile_pinToGroupName", "vnic_Profile_policyLevel", "vnic_Profile_policyOwner", "vnic_Profile_portProfileUuid", "vnic_Profile_primaryVlanId", "vnic_Profile_qosPolicyDn", "vnic_Profile_qosPolicyId", "vnic_Profile_qosPolicyName", "vnic_Profile_swABorderPort", "vnic_Profile_swABorderSlot", "vnic_Profile_swBBorderPort", "vnic_Profile_swBBorderSlot", "vnic_Profile_type", "vnic_Profile_uplinkFailAction", "vnic_RackServerDiscoveryProfile_descr", "vnic_RackServerDiscoveryProfile_intId", "vnic_RackServerDiscoveryProfile_maxPorts", "vnic_RackServerDiscoveryProfile_name", "vnic_RackServerDiscoveryProfile_policyLevel", "vnic_RackServerDiscoveryProfile_policyOwner", "vnic_SanConnPolicy_descr", "vnic_SanConnPolicy_intId", "vnic_SanConnPolicy_name", "vnic_SanConnPolicy_policyLevel", "vnic_SanConnPolicy_policyOwner", "vnic_SanConnTempl_descr", "vnic_SanConnTempl_identPoolName", "vnic_SanConnTempl_intId", "vnic_SanConnTempl_maxDataFieldSize", "vnic_SanConnTempl_name", "vnic_SanConnTempl_nwCtrlPolicyName", "vnic_SanConnTempl_operIdentPoolName", "vnic_SanConnTempl_operQosPolicyName", "vnic_SanConnTempl_operStatsPolicyName", "vnic_SanConnTempl_pinToGroupName", "vnic_SanConnTempl_policyLevel", "vnic_SanConnTempl_policyOwner", "vnic_SanConnTempl_qosPolicyName", "vnic_SanConnTempl_statsPolicyName", "vnic_SanConnTempl_switchId", "vnic_SanConnTempl_target", "vnic_SanConnTempl_templType", "vnic_ScsiIf_addr", "vnic_ScsiIf_configQualifier", "vnic_ScsiIf_name", "vnic_ScsiIf_operState", "vnic_ScsiIf_operVnetDn", "vnic_ScsiIf_operVnetName", "vnic_ScsiIf_owner", "vnic_ScsiIf_switchId", "vnic_ScsiIf_type", "vnic_ScsiIf_vnet", "vnic_Scsi_adaptorProfileName", "vnic_Scsi_adminVcon", "vnic_Scsi_bootDev", "vnic_Scsi_configQualifier", "vnic_Scsi_configState", "vnic_Scsi_equipmentDn", "vnic_Scsi_identPoolName", "vnic_Scsi_instType", "vnic_Scsi_name", "vnic_Scsi_nwTemplName", "vnic_Scsi_operOrder", "vnic_Scsi_operSpeed", "vnic_Scsi_operStatsPolicyName", "vnic_Scsi_operVcon", "vnic_Scsi_order", "vnic_Scsi_owner", "vnic_Scsi_pinToGroupName", "vnic_Scsi_qosPolicyName", "vnic_Scsi_statsPolicyName", "vnic_Scsi_switchId", "vnic_Scsi_type", "vnic_Templ_descr", "vnic_Templ_identPoolName", "vnic_Templ_intId", "vnic_Templ_name", "vnic_Templ_nwCtrlPolicyName", "vnic_Templ_operStatsPolicyName", "vnic_Templ_pinToGroupName", "vnic_Templ_policyLevel", "vnic_Templ_policyOwner", "vnic_Templ_qosPolicyName", "vnic_Templ_statsPolicyName", "vnic_Templ_switchId", "vnic_Templ_target", "vnic_Templ_templType", "vnic_Template_templType", "vnic_UsnicConPolicyRef_conPolicyName", "vnic_UsnicConPolicyRef_operConPolicyName", "vnic_UsnicConPolicy_adaptorProfileName", "vnic_UsnicConPolicy_descr", "vnic_UsnicConPolicy_intId", "vnic_UsnicConPolicy_name", "vnic_UsnicConPolicy_policyLevel", "vnic_UsnicConPolicy_policyOwner", "vnic_UsnicConPolicy_usnicCount", "vnic_UsnicConReq_adaptorProfileName", "vnic_UsnicConReq_descr", "vnic_UsnicConReq_intId", "vnic_UsnicConReq_name", "vnic_UsnicConReq_policyLevel", "vnic_UsnicConReq_policyOwner", "vnic_UsnicConReq_usnicCount", "vnic_VProfileAlias_alias", "vnic_VhbaBehPolicy_action", "vnic_VhbaBehPolicy_descr", "vnic_VhbaBehPolicy_intId", "vnic_VhbaBehPolicy_name", "vnic_VhbaBehPolicy_nwTemplName", "vnic_VhbaBehPolicy_policyLevel", "vnic_VhbaBehPolicy_policyOwner", "vnic_VhbaBehPolicy_type", "vnic_Vlan_configQualifier", "vnic_Vlan_name", "vnic_Vlan_operState", "vnic_Vlan_operVnetDn", "vnic_Vlan_operVnetName", "vnic_Vlan_owner", "vnic_Vlan_switchId", "vnic_Vlan_type", "vnic_Vlan_vlanName", "vnic_Vlan_vnet", "vnic_VmqConPolicyRef_conPolicyName", "vnic_VmqConPolicyRef_operConPolicyName", "vnic_VmqConPolicy_descr", "vnic_VmqConPolicy_intId", "vnic_VmqConPolicy_intrCount", "vnic_VmqConPolicy_name", "vnic_VmqConPolicy_policyLevel", "vnic_VmqConPolicy_policyOwner", "vnic_VmqConPolicy_vmqCount", "vnic_VmqConReq_descr", "vnic_VmqConReq_intId", "vnic_VmqConReq_intrCount", "vnic_VmqConReq_name", "vnic_VmqConReq_policyLevel", "vnic_VmqConReq_policyOwner", "vnic_VmqConReq_vmqCount", "vnic_VnicBehPolicy_action", "vnic_VnicBehPolicy_descr", "vnic_VnicBehPolicy_intId", "vnic_VnicBehPolicy_name", "vnic_VnicBehPolicy_nwTemplName", "vnic_VnicBehPolicy_policyLevel", "vnic_VnicBehPolicy_policyOwner", "vnic_VnicBehPolicy_type", "vnic_Vnic_adaptorProfileName", "vnic_Vnic_adminVcon", "vnic_Vnic_bootDev", "vnic_Vnic_configQualifier", "vnic_Vnic_configState", "vnic_Vnic_equipmentDn", "vnic_Vnic_identPoolName", "vnic_Vnic_instType", "vnic_Vnic_name", "vnic_Vnic_nwTemplName", "vnic_Vnic_operOrder", "vnic_Vnic_operSpeed", "vnic_Vnic_operStatsPolicyName", "vnic_Vnic_operVcon", "vnic_Vnic_order", "vnic_Vnic_owner", "vnic_Vnic_pinToGroupName", "vnic_Vnic_qosPolicyName", "vnic_Vnic_statsPolicyName", "vnic_Vnic_switchId", "vnic_Vnic_type", "vnic_WwnnHistory_oldwwnn", "vnic_WwpnHistory_oldaddr"], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version212a, UcsPropertyMeta.ReadOnly, 0x10L, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version212a, UcsPropertyMeta.ReadWrite, 0x20L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Meta":UcsMoMeta("GmetaProp", "gmetaProp", "prop-[Order]", _VersionMeta.Version212a, "InputOutput", 0x3fL, [], [], [None], ["admin"]),
			},

		"SwatTarget": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x2L, 0, 256, None, [], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x4L, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x8L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"VarName":UcsPropertyMeta("VarName", "varName", "string", _VersionMeta.Version101e, UcsPropertyMeta.Naming, 0x10L, None, None, """[\-\.:_a-zA-Z0-9]{1,16}""", [], ["0-4294967295"]),
			"VarValue":UcsPropertyMeta("VarValue", "varValue", "string", _VersionMeta.Version101e, UcsPropertyMeta.Naming, 0x20L, None, None, """[\-\.:_a-zA-Z0-9]{1,16}""", [], ["0-4294967295"]),
			"Meta":UcsMoMeta("SwatTarget", "swatTarget", "target-[VarName]-[VarValue]", _VersionMeta.Version101e, "InputOutput", 0x3fL, [], [], ["Get"], ["admin"]),
			},

		"BiosVfMirroringMode": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version131c, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version131c, UcsPropertyMeta.ReadOnly, 0x2L, 0, 256, None, [], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version131c, UcsPropertyMeta.ReadOnly, 0x4L, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version131c, UcsPropertyMeta.ReadWrite, 0x8L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"VpMirroringMode":UcsPropertyMeta("VpMirroringMode", "vpMirroringMode", "string", _VersionMeta.Version131c, UcsPropertyMeta.ReadWrite, 0x10L, None, None, None, ["inter-socket", "intra-socket", "platform-default", "platform-recommended"], ["0-4294967295"]),
			"Meta":UcsMoMeta("BiosVfMirroringMode", "biosVfMirroringMode", "Mirroring-Mode", _VersionMeta.Version131c, "InputOutput", 0x1fL, [], [], ["Get", "Set"], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"]),
			},

		"FabricLanCloudFsmTask": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version111j, UcsPropertyMeta.Internal, None, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Completion":UcsPropertyMeta("Completion", "completion", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, ["cancelled", "completed", "processing", "scheduled"], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"Flags":UcsPropertyMeta("Flags", "flags", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, """(defaultValue){0,1}""", [], ["0-4294967295"]),
			"Item":UcsPropertyMeta("Item", "item", "string", _VersionMeta.Version111j, UcsPropertyMeta.Naming, None, None, None, None, ["SwitchMode", "nop"], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"SeqId":UcsPropertyMeta("SeqId", "seqId", "uint", _VersionMeta.Version111j, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version111j, UcsPropertyMeta.ReadWrite, None, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Meta":UcsMoMeta("FabricLanCloudFsmTask", "fabricLanCloudFsmTask", "task-[Item]", _VersionMeta.Version111j, "OutputOnly", 0x0L, [], [], [None], [""]),
			},

		"IppoolPoolable": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x2L, 0, 256, None, [], ["0-4294967295"]),
			"Id":UcsPropertyMeta("Id", "id", "ulong", _VersionMeta.Version101e, UcsPropertyMeta.Naming, 0x4L, None, None, None, [], ["0-4294967295"]),
			"PoolDn":UcsPropertyMeta("PoolDn", "poolDn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x8L, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x10L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Meta":UcsMoMeta("IppoolPoolable", "ippoolPoolable", "pool-[Id]", _VersionMeta.Version101e, "InputOutput", 0x1fL, [], [], ["Get"], ["read-only"]),
			},

		"SysfileDigest": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version211a, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"CreationTS":UcsPropertyMeta("CreationTS", "creationTS", "ulong", _VersionMeta.Version211a, UcsPropertyMeta.Naming, 0x2L, None, None, None, [], ["0-4294967295"]),
			"Descr":UcsPropertyMeta("Descr", "descr", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadWrite, 0x4L, None, None, """[ !#$%&\(\)\*\+,\-\./:;\?@\[\]_\{\|\}~a-zA-Z0-9]{0,256}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, 0x8L, 0, 256, None, [], ["0-4294967295"]),
			"Name":UcsPropertyMeta("Name", "name", "string", _VersionMeta.Version211a, UcsPropertyMeta.Naming, 0x10L, 1, 128, None, [], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, 0x20L, 0, 256, None, [], ["0-4294967295"]),
			"Size":UcsPropertyMeta("Size", "size", "uint", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"Source":UcsPropertyMeta("Source", "source", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, 0, 510, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadWrite, 0x40L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"SwitchId":UcsPropertyMeta("SwitchId", "switchId", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, ["A", "B", "NONE"], ["0-4294967295"]),
			"Ts":UcsPropertyMeta("Ts", "ts", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, """([0-9]){4}-([0-9]){2}-([0-9]){2}T([0-9]){2}:([0-9]){2}:([0-9]){2}((\.([0-9]){3})){0,1}""", [], ["0-4294967295"]),
			"Uri":UcsPropertyMeta("Uri", "uri", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, 0, 510, None, [], ["0-4294967295"]),
			"Meta":UcsMoMeta("SysfileDigest", "sysfileDigest", "filedigest-[Name]-[CreationTS]", _VersionMeta.Version211a, "InputOutput", 0x7fL, [], [], [None], ["read-only"]),
			},

		"ComputeServerDiscPolicyFsm": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version211a, UcsPropertyMeta.Internal, None, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"CompletionTime":UcsPropertyMeta("CompletionTime", "completionTime", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, """([0-9]){4}-([0-9]){2}-([0-9]){2}T([0-9]){2}:([0-9]){2}:([0-9]){2}((\.([0-9]){3})){0,1}""", [""], ["0-4294967295"]),
			"CurrentFsm":UcsPropertyMeta("CurrentFsm", "currentFsm", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, ["ResolveScrubPolicy", "nop"], ["0-4294967295"]),
			"Descr":UcsPropertyMeta("Descr", "descr", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, """[ !#$%&\(\)\*\+,\-\./:;\?@\[\]_\{\|\}~a-zA-Z0-9]{0,256}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"FsmStatus":UcsPropertyMeta("FsmStatus", "fsmStatus", "string", _VersionMeta.Version211a, UcsPropertyMeta.Internal, None, None, None, None, ["fail", "inProgress", "nop", "pending", "skip", "success", "throttled"], ["0-4294967295"]),
			"InstanceId":UcsPropertyMeta("InstanceId", "instanceId", "uint", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"Progress":UcsPropertyMeta("Progress", "progress", "byte", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-100"]),
			"RmtErrCode":UcsPropertyMeta("RmtErrCode", "rmtErrCode", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, ["ERR-2fa-auth-retry", "ERR-ACTIVATE-failed", "ERR-ACTIVATE-in-progress", "ERR-ACTIVATE-retry", "ERR-BIOS-TOKENS-OLD-BIOS", "ERR-BIOS-TOKENS-OLD-CIMC", "ERR-BIOS-network-boot-order-not-found", "ERR-BOARDCTRLUPDATE-ignore", "ERR-DIAG-cancelled", "ERR-DIAG-fsm-restarted", "ERR-DIAG-test-failed", "ERR-DNLD-authentication-failure", "ERR-DNLD-hostkey-mismatch", "ERR-DNLD-invalid-image", "ERR-DNLD-no-file", "ERR-DNLD-no-space", "ERR-DNS-delete-error", "ERR-DNS-get-error", "ERR-DNS-set-error", "ERR-Diagnostics-in-progress", "ERR-Diagnostics-memtest-in-progress", "ERR-Diagnostics-network-in-progress", "ERR-FILTER-illegal-format", "ERR-FSM-no-such-state", "ERR-HOST-fru-identity-mismatch", "ERR-HTTP-set-error", "ERR-HTTPS-set-error", "ERR-IBMC-analyze-results", "ERR-IBMC-connect-error", "ERR-IBMC-fru-retrieval-error", "ERR-IBMC-invalid-end-point-config", "ERR-IBMC-results-not-ready", "ERR-MAX-subscriptions-allowed-error", "ERR-MO-CONFIG-child-object-cant-be-configured", "ERR-MO-META-no-such-object-class", "ERR-MO-PROPERTY-no-such-property", "ERR-MO-PROPERTY-value-out-of-range", "ERR-MO-access-denied", "ERR-MO-deletion-rule-violation", "ERR-MO-duplicate-object", "ERR-MO-illegal-containment", "ERR-MO-illegal-creation", "ERR-MO-illegal-iterator-state", "ERR-MO-illegal-object-lifecycle-transition", "ERR-MO-naming-rule-violation", "ERR-MO-object-not-found", "ERR-MO-resource-allocation", "ERR-NTP-delete-error", "ERR-NTP-get-error", "ERR-NTP-set-error", "ERR-POWER-CAP-UNSUPPORTED", "ERR-SERVER-mis-connect", "ERR-SWITCH-invalid-if-config", "ERR-TOKEN-request-denied", "ERR-UNABLE-TO-FETCH-BIOS-SETTINGS", "ERR-UPDATE-failed", "ERR-UPDATE-in-progress", "ERR-UPDATE-retry", "ERR-aaa-config-modify-error", "ERR-acct-realm-set-error", "ERR-admin-passwd-set", "ERR-auth-issue", "ERR-auth-realm-get-error", "ERR-auth-realm-set-error", "ERR-authentication", "ERR-authorization-required", "ERR-cli-session-limit-reached", "ERR-create-keyring", "ERR-create-locale", "ERR-create-role", "ERR-create-user", "ERR-delete-locale", "ERR-delete-role", "ERR-delete-session", "ERR-delete-user", "ERR-efi-Diagnostics--in-progress", "ERR-enable-mgmt-conn", "ERR-ep-set-error", "ERR-get-max-http-user-sessions", "ERR-http-initializing", "ERR-insufficiently-equipped", "ERR-internal-error", "ERR-ldap-delete-error", "ERR-ldap-get-error", "ERR-ldap-group-modify-error", "ERR-ldap-group-set-error", "ERR-ldap-set-error", "ERR-locale-set-error", "ERR-max-userid-sessions-reached", "ERR-missing-method", "ERR-modify-locale", "ERR-modify-role", "ERR-modify-user", "ERR-modify-user-locale", "ERR-modify-user-role", "ERR-provider-group-modify-error", "ERR-provider-group-set-error", "ERR-radius-get-error", "ERR-radius-global-set-error", "ERR-radius-group-set-error", "ERR-radius-set-error", "ERR-request-timeout", "ERR-reset-adapter", "ERR-role-set-error", "ERR-secondary-node", "ERR-service-not-ready", "ERR-session-cache-full", "ERR-session-not-found", "ERR-set-network", "ERR-set-password-strength-check", "ERR-set-port-channel", "ERR-store-pre-login-banner-msg", "ERR-tacacs-enable-error", "ERR-tacacs-global-set-error", "ERR-tacacs-group-set-error", "ERR-tacacs-plus-get-error", "ERR-tacacs-set-error", "ERR-test-error-1", "ERR-test-error-2", "ERR-timezone-set-error", "ERR-user-account-expired", "ERR-user-set-error", "ERR-xml-parse-error", "none"], ["0-4294967295"]),
			"RmtErrDescr":UcsPropertyMeta("RmtErrDescr", "rmtErrDescr", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, 0, 510, None, [], ["0-4294967295"]),
			"RmtRslt":UcsPropertyMeta("RmtRslt", "rmtRslt", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, """((defaultValue|not-applicable|resource-unavailable|service-unavailable|intermittent-error|sw-defect|service-not-implemented-ignore|extend-timeout|capability-not-implemented-failure|illegal-fru|end-point-unavailable|failure|resource-capacity-exceeded|service-protocol-error|fw-defect|service-not-implemented-fail|task-reset|unidentified-fail|capability-not-supported|end-point-failed|fru-state-indeterminate|resource-dependency|fru-identity-indeterminate|internal-error|hw-defect|service-not-supported|fru-not-supported|end-point-protocol-error|capability-unavailable|fru-not-ready|capability-not-implemented-ignore|fru-info-malformed|timeout),){0,32}(defaultValue|not-applicable|resource-unavailable|service-unavailable|intermittent-error|sw-defect|service-not-implemented-ignore|extend-timeout|capability-not-implemented-failure|illegal-fru|end-point-unavailable|failure|resource-capacity-exceeded|service-protocol-error|fw-defect|service-not-implemented-fail|task-reset|unidentified-fail|capability-not-supported|end-point-failed|fru-state-indeterminate|resource-dependency|fru-identity-indeterminate|internal-error|hw-defect|service-not-supported|fru-not-supported|end-point-protocol-error|capability-unavailable|fru-not-ready|capability-not-implemented-ignore|fru-info-malformed|timeout){0,1}""", [], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadWrite, None, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Meta":UcsMoMeta("ComputeServerDiscPolicyFsm", "computeServerDiscPolicyFsm", "fsm", _VersionMeta.Version211a, "OutputOnly", 0x0L, [], [u'computeServerDiscPolicyFsmStage'], [None], [""]),
			},

		"SysdebugLogControlDestinationFile": {
			"BackupCount":UcsPropertyMeta("BackupCount", "backupCount", "ushort", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x1L, None, None, None, [], ["1-9"]),
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, 0x2L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"DefaultLevel":UcsPropertyMeta("DefaultLevel", "defaultLevel", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x4L, None, None, None, ["crit", "debug0", "debug1", "debug2", "debug3", "debug4", "info", "major", "minor", "warn"], ["0-4294967295"]),
			"DefaultSize":UcsPropertyMeta("DefaultSize", "defaultSize", "uint", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x8L, None, None, None, [], ["1000000-20000000"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x10L, 0, 256, None, [], ["0-4294967295"]),
			"Level":UcsPropertyMeta("Level", "level", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x20L, None, None, None, ["crit", "debug0", "debug1", "debug2", "debug3", "debug4", "info", "major", "minor", "warn"], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x40L, 0, 256, None, [], ["0-4294967295"]),
			"Size":UcsPropertyMeta("Size", "size", "uint", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x80L, None, None, None, [], ["1000000-20000000"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x100L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Meta":UcsMoMeta("SysdebugLogControlDestinationFile", "sysdebugLogControlDestinationFile", "file", _VersionMeta.Version101e, "InputOutput", 0x1ffL, [], [], ["Get"], ["admin", "operations"]),
			},

		"StorageEpUser": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version211a, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"ConfigState":UcsPropertyMeta("ConfigState", "configState", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, ["not-applied", "ok"], ["0-4294967295"]),
			"ConfigStatusMessage":UcsPropertyMeta("ConfigStatusMessage", "configStatusMessage", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, 0, 510, None, [], ["0-4294967295"]),
			"Descr":UcsPropertyMeta("Descr", "descr", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadWrite, 0x2L, None, None, """[ !#$%&\(\)\*\+,\-\./:;\?@\[\]_\{\|\}~a-zA-Z0-9]{0,256}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, 0x4L, 0, 256, None, [], ["0-4294967295"]),
			"Domain":UcsPropertyMeta("Domain", "domain", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadWrite, 0x8L, None, None, """[a-zA-Z][a-zA-Z0-9@_.\-\\]{0,47}""", [], ["0-4294967295"]),
			"Name":UcsPropertyMeta("Name", "name", "string", _VersionMeta.Version211a, UcsPropertyMeta.Naming, 0x10L, None, None, """[a-zA-Z][a-zA-Z0-9@_.\-\\]{0,47}""", [], ["0-4294967295"]),
			"Priv":UcsPropertyMeta("Priv", "priv", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadWrite, 0x20L, None, None, None, ["admin", "readonly"], ["0-4294967295"]),
			"Pwd":UcsPropertyMeta("Pwd", "pwd", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadWrite, 0x40L, None, None, """[!""#%&'\(\)\*\+,\-\./:;<>@\[\\\]\^_`\{\|\}~a-zA-Z0-9]{1,20}""", [], ["0-4294967295"]),
			"PwdSet":UcsPropertyMeta("PwdSet", "pwdSet", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, ["false", "no", "true", "yes"], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, 0x80L, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadWrite, 0x100L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Meta":UcsMoMeta("StorageEpUser", "storageEpUser", "user-[Name]", _VersionMeta.Version211a, "InputOutput", 0x1ffL, [], [u'aaaCimcSession'], [None], ["admin"]),
			},

		"MgmtAccessPolicy": {
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x2L, 0, 256, None, [], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x4L, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x8L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Meta":UcsMoMeta("MgmtAccessPolicy", "mgmtAccessPolicy", "ext-access-policy", _VersionMeta.Version101e, "InputOutput", 0xfL, [], [u'mgmtAccessPolicyItem'], ["Get"], ["read-only"]),
			},

		"ExtpolController": {
			"Capability":UcsPropertyMeta("Capability", "capability", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, """((defaultValue|unspecified|vmm|infra-waf|vm-mgr|pcm|infra-fw|org-mgr|virtual-switching-mgr|service-reg|vm-vasw|infra-pasw|vm-admin|infra-aggr|identifier-mgr|infra-slb|policy-mgr|stats-mgr|vm-fw|infra-pdsw|operation-mgr|infra-crypto-offloa|infra-was|boot-mgr|ipam|vm-slb|storage-broker|resource-mgr),){0,27}(defaultValue|unspecified|vmm|infra-waf|vm-mgr|pcm|infra-fw|org-mgr|virtual-switching-mgr|service-reg|vm-vasw|infra-pasw|vm-admin|infra-aggr|identifier-mgr|infra-slb|policy-mgr|stats-mgr|vm-fw|infra-pdsw|operation-mgr|infra-crypto-offloa|infra-was|boot-mgr|ipam|vm-slb|storage-broker|resource-mgr){0,1}""", [], ["0-4294967295"]),
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version211a, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"ConnProtocol":UcsPropertyMeta("ConnProtocol", "connProtocol", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadOnly, None, None, None, None, ["ipv4", "ipv6", "unknown"], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, 0x2L, 0, 256, None, [], ["0-4294967295"]),
			"Host":UcsPropertyMeta("Host", "host", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, """^[A-Za-z]([A-Za-z0-9-]*[A-Za-z0-9])?$|^[A-Za-z0-9]([A-Za-z0-9-]*[A-Za-z0-9])?(\.[A-Za-z0-9]([A-Za-z0-9-]*[A-Za-z0-9])?)*(\.[A-Za-z]([A-Za-z0-9-]*[A-Za-z0-9])?)$|^([1-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\.([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\.([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\.([1-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])$""", [], ["0-4294967295"]),
			"Id":UcsPropertyMeta("Id", "id", "uint", _VersionMeta.Version211a, UcsPropertyMeta.Naming, 0x4L, None, None, None, [], ["0-4294967295"]),
			"Interest":UcsPropertyMeta("Interest", "interest", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, """((defaultValue|unspecified|vmm|infra-waf|vm-mgr|pcm|infra-fw|org-mgr|virtual-switching-mgr|service-reg|vm-vasw|infra-pasw|vm-admin|infra-aggr|identifier-mgr|infra-slb|policy-mgr|stats-mgr|vm-fw|infra-pdsw|operation-mgr|infra-crypto-offloa|infra-was|boot-mgr|ipam|vm-slb|storage-broker|resource-mgr),){0,27}(defaultValue|unspecified|vmm|infra-waf|vm-mgr|pcm|infra-fw|org-mgr|virtual-switching-mgr|service-reg|vm-vasw|infra-pasw|vm-admin|infra-aggr|identifier-mgr|infra-slb|policy-mgr|stats-mgr|vm-fw|infra-pdsw|operation-mgr|infra-crypto-offloa|infra-was|boot-mgr|ipam|vm-slb|storage-broker|resource-mgr){0,1}""", [], ["0-4294967295"]),
			"Ip":UcsPropertyMeta("Ip", "ip", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, 0, 256, """((([0-9]){1,3}\.){3}[0-9]{1,3})""", [], ["0-4294967295"]),
			"Ipv6":UcsPropertyMeta("Ipv6", "ipv6", "string", _VersionMeta.Version221b, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"LastPollTs":UcsPropertyMeta("LastPollTs", "lastPollTs", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, """([0-9]){4}-([0-9]){2}-([0-9]){2}T([0-9]){2}:([0-9]){2}:([0-9]){2}((\.([0-9]){3})){0,1}""", [], ["0-4294967295"]),
			"Name":UcsPropertyMeta("Name", "name", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, 0, 510, None, [], ["0-4294967295"]),
			"OperState":UcsPropertyMeta("OperState", "operState", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, ["lost-visibility", "registered", "registering", "registry-not-reachable", "synchronizing", "unregistered", "version-mismatch"], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, 0x8L, 0, 256, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadWrite, 0x10L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"Type":UcsPropertyMeta("Type", "type", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, ["ape", "boot-mgr", "identifier-mgr", "managed-endpoint", "mgmt-controller", "operation-mgr", "policy-mgr", "resource-aggr", "resource-mgr", "service-reg", "stats-mgr", "storage-broker", "virtual-switching-mgr", "vm-mgr"], ["0-4294967295"]),
			"Version":UcsPropertyMeta("Version", "version", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, 0, 510, None, [], ["0-4294967295"]),
			"Meta":UcsMoMeta("ExtpolController", "extpolController", "contro-[Id]", _VersionMeta.Version211a, "InputOutput", 0x1fL, [], [u'observeObserved', u'policyPolicyScopeCont'], ["Get"], ["admin"]),
			},

		"FabricNetGroup": {
			"Assigned":UcsPropertyMeta("Assigned", "assigned", "uint", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"AssignmentOrder":UcsPropertyMeta("AssignmentOrder", "assignmentOrder", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, ["default", "sequential"], ["0-4294967295"]),
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version211a, UcsPropertyMeta.Internal, 0x1L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Descr":UcsPropertyMeta("Descr", "descr", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadWrite, 0x2L, None, None, """[ !#$%&\(\)\*\+,\-\./:;\?@\[\]_\{\|\}~a-zA-Z0-9]{0,256}""", [], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, 0x4L, 0, 256, None, [], ["0-4294967295"]),
			"Id":UcsPropertyMeta("Id", "id", "uint", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"IntId":UcsPropertyMeta("IntId", "intId", "string", _VersionMeta.Version211a, UcsPropertyMeta.Internal, None, None, None, None, ["none"], ["0-4294967295"]),
			"Name":UcsPropertyMeta("Name", "name", "string", _VersionMeta.Version211a, UcsPropertyMeta.Naming, 0x8L, None, None, """[\-\.:_a-zA-Z0-9]{1,32}""", [], ["0-4294967295"]),
			"NativeNet":UcsPropertyMeta("NativeNet", "nativeNet", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadWrite, 0x10L, 0, 510, None, [], ["0-4294967295"]),
			"NativeNetDn":UcsPropertyMeta("NativeNetDn", "nativeNetDn", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"Owner":UcsPropertyMeta("Owner", "owner", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, ["management", "policy"], ["0-4294967295"]),
			"PeerDn":UcsPropertyMeta("PeerDn", "peerDn", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"PolicyLevel":UcsPropertyMeta("PolicyLevel", "policyLevel", "uint", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"PolicyOwner":UcsPropertyMeta("PolicyOwner", "policyOwner", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadWrite, 0x20L, None, None, None, ["local", "pending-policy", "policy"], ["0-4294967295"]),
			"Rn":UcsPropertyMeta("Rn", "rn", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, 0x40L, 0, 256, None, [], ["0-4294967295"]),
			"Size":UcsPropertyMeta("Size", "size", "uint", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, [], ["0-4294967295"]),
			"Status":UcsPropertyMeta("Status", "status", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadWrite, 0x80L, None, None, """((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], ["0-4294967295"]),
			"SwitchId":UcsPropertyMeta("SwitchId", "switchId", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadOnly, None, None, None, None, ["A", "B", "NONE", "dual"], ["0-4294967295"]),
			"Type":UcsPropertyMeta("Type", "type", "string", _VersionMeta.Version211a, UcsPropertyMeta.ReadWrite, 0x100L, None, None, """((defaultValue|mgmt|vlan-compression|vlan-uncompressed),){0,3}(defaultValue|mgmt|vlan-compression|vlan-uncompressed){0,1}""", [], ["0-4294967295"]),
			"Meta":UcsMoMeta("FabricNetGroup", "fabricNetGroup", "net-group-[Name]", _VersionMeta.Version211a, "InputOutput", 0x1ffL, [], [u'fabricEthVlanPc', u'fabricEthVlanPortEp', u'fabricPooledVlan'], ["Add", "Get", "Remove", "Set"], ["admin", "ext-lan-config", "ext-lan-policy"]),
			},

		"AdaptorHostEthIf": {
			"AdminState":UcsPropertyMeta("AdminState", "adminState", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x1L, None, None, None, ["disabled", "disabled-active", "disabled-passive", "enabled", "enabled-active", "enabled-passive", "reset-connectivity", "reset-connectivity-active", "reset-connectivity-passive"], ["0-4294967295"]),
			"BootDev":UcsPropertyMeta("BootDev", "bootDev", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadWrite, 0x2L, None, None, None, ["disabled", "enabled"], ["0-4294967295"]),
			"ChassisId":UcsPropertyMeta("ChassisId", "chassisId", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, ["N/A"], ["0-255"]),
			"ChildAction":UcsPropertyMeta("ChildAction", "childAction", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, 0x4L, None, None, """((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], ["0-4294967295"]),
			"Discovery":UcsPropertyMeta("Discovery", "discovery", "string", _VersionMeta.Version141i, UcsPropertyMeta.ReadOnly, None, None, None, None, ["absent", "mis-connect", "missing", "new", "present"], ["0-4294967295"]),
			"Dn":UcsPropertyMeta("Dn", "dn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, 0x8L, 0, 256, None, [], ["0-4294967295"]),
			"EpDn":UcsPropertyMeta("EpDn", "epDn", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, 0, 256, None, [], ["0-4294967295"]),
			"FltAggr":UcsPropertyMeta("FltAggr", "fltAggr", "ulong", _VersionMeta.Version111j, UcsPropertyMeta.Internal, None, None, None, None, [], ["0-4294967295"]),
			"FsmDescr":UcsPropertyMeta("FsmDescr", "fsmDescr", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, None, None, None, None, [], ["0-4294967295"]),
			"FsmPrev":UcsPropertyMeta("FsmPrev", "fsmPrev", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, None, None, None, None, ["CircuitResetBegin", "CircuitResetDisableA", "CircuitResetDisableB", "CircuitResetEnableA", "CircuitResetEnableB", "CircuitResetFail", "CircuitResetSuccess", "nop"], ["0-4294967295"]),
			"FsmProgr":UcsPropertyMeta("FsmProgr", "fsmProgr", "byte", _VersionMeta.Version101e, UcsPropertyMeta.Internal, None, None, None, None, [], ["0-100"]),
			"FsmRmtInvErrCode":UcsPropertyMeta("FsmRmtInvErrCode", "fsmRmtInvErrCode", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, None, None, None, None, ["ERR-2fa-auth-retry", "ERR-ACTIVATE-failed", "ERR-ACTIVATE-in-progress", "ERR-ACTIVATE-retry", "ERR-BIOS-TOKENS-OLD-BIOS", "ERR-BIOS-TOKENS-OLD-CIMC", "ERR-BIOS-network-boot-order-not-found", "ERR-BOARDCTRLUPDATE-ignore", "ERR-DIAG-cancelled", "ERR-DIAG-fsm-restarted", "ERR-DIAG-test-failed", "ERR-DNLD-authentication-failure", "ERR-DNLD-hostkey-mismatch", "ERR-DNLD-invalid-image", "ERR-DNLD-no-file", "ERR-DNLD-no-space", "ERR-DNS-delete-error", "ERR-DNS-get-error", "ERR-DNS-set-error", "ERR-Diagnostics-in-progress", "ERR-Diagnostics-memtest-in-progress", "ERR-Diagnostics-network-in-progress", "ERR-FILTER-illegal-format", "ERR-FSM-no-such-state", "ERR-HOST-fru-identity-mismatch", "ERR-HTTP-set-error", "ERR-HTTPS-set-error", "ERR-IBMC-analyze-results", "ERR-IBMC-connect-error", "ERR-IBMC-fru-retrieval-error", "ERR-IBMC-invalid-end-point-config", "ERR-IBMC-results-not-ready", "ERR-MAX-subscriptions-allowed-error", "ERR-MO-CONFIG-child-object-cant-be-configured", "ERR-MO-META-no-such-object-class", "ERR-MO-PROPERTY-no-such-property", "ERR-MO-PROPERTY-value-out-of-range", "ERR-MO-access-denied", "ERR-MO-deletion-rule-violation", "ERR-MO-duplicate-object", "ERR-MO-illegal-containment", "ERR-MO-illegal-creation", "ERR-MO-illegal-iterator-state", "ERR-MO-illegal-object-lifecycle-transition", "ERR-MO-naming-rule-violation", "ERR-MO-object-not-found", "ERR-MO-resource-allocation", "ERR-NTP-delete-error", "ERR-NTP-get-error", "ERR-NTP-set-error", "ERR-POWER-CAP-UNSUPPORTED", "ERR-SERVER-mis-connect", "ERR-SWITCH-invalid-if-config", "ERR-TOKEN-request-denied", "ERR-UNABLE-TO-FETCH-BIOS-SETTINGS", "ERR-UPDATE-failed", "ERR-UPDATE-in-progress", "ERR-UPDATE-retry", "ERR-aaa-config-modify-error", "ERR-acct-realm-set-error", "ERR-admin-passwd-set", "ERR-auth-issue", "ERR-auth-realm-get-error", "ERR-auth-realm-set-error", "ERR-authentication", "ERR-authorization-required", "ERR-cli-session-limit-reached", "ERR-create-keyring", "ERR-create-locale", "ERR-create-role", "ERR-create-user", "ERR-delete-locale", "ERR-delete-role", "ERR-delete-session", "ERR-delete-user", "ERR-efi-Diagnostics--in-progress", "ERR-enable-mgmt-conn", "ERR-ep-set-error", "ERR-get-max-http-user-sessions", "ERR-http-initializing", "ERR-insufficiently-equipped", "ERR-internal-error", "ERR-ldap-delete-error", "ERR-ldap-get-error", "ERR-ldap-group-modify-error", "ERR-ldap-group-set-error", "ERR-ldap-set-error", "ERR-locale-set-error", "ERR-max-userid-sessions-reached", "ERR-missing-method", "ERR-modify-locale", "ERR-modify-role", "ERR-modify-user", "ERR-modify-user-locale", "ERR-modify-user-role", "ERR-provider-group-modify-error", "ERR-provider-group-set-error", "ERR-radius-get-error", "ERR-radius-global-set-error", "ERR-radius-group-set-error", "ERR-radius-set-error", "ERR-request-timeout", "ERR-reset-adapter", "ERR-role-set-error", "ERR-secondary-node", "ERR-service-not-ready", "ERR-session-cache-full", "ERR-session-not-found", "ERR-set-network", "ERR-set-password-strength-check", "ERR-set-port-channel", "ERR-store-pre-login-banner-msg", "ERR-tacacs-enable-error", "ERR-tacacs-global-set-error", "ERR-tacacs-group-set-error", "ERR-tacacs-plus-get-error", "ERR-tacacs-set-error", "ERR-test-error-1", "ERR-test-error-2", "ERR-timezone-set-error", "ERR-user-account-expired", "ERR-user-set-error", "ERR-xml-parse-error", "none"], ["0-4294967295"]),
			"FsmRmtInvErrDescr":UcsPropertyMeta("FsmRmtInvErrDescr", "fsmRmtInvErrDescr", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, None, 0, 510, None, [], ["0-4294967295"]),
			"FsmRmtInvRslt":UcsPropertyMeta("FsmRmtInvRslt", "fsmRmtInvRslt", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, None, None, None, """((defaultValue|not-applicable|resource-unavailable|service-unavailable|intermittent-error|sw-defect|service-not-implemented-ignore|extend-timeout|capability-not-implemented-failure|illegal-fru|end-point-unavailable|failure|resource-capacity-exceeded|service-protocol-error|fw-defect|service-not-implemented-fail|task-reset|unidentified-fail|capability-not-supported|end-point-failed|fru-state-indeterminate|resource-dependency|fru-identity-indeterminate|internal-error|hw-defect|service-not-supported|fru-not-supported|end-point-protocol-error|capability-unavailable|fru-not-ready|capability-not-implemented-ignore|fru-info-malformed|timeout),){0,32}(defaultValue|not-applicable|resource-unavailable|service-unavailable|intermittent-error|sw-defect|service-not-implemented-ignore|extend-timeout|capability-not-implemented-failure|illegal-fru|end-point-unavailable|failure|resource-capacity-exceeded|service-protocol-error|fw-defect|service-not-implemented-fail|task-reset|unidentified-fail|capability-not-supported|end-point-failed|fru-state-indeterminate|resource-dependency|fru-identity-indeterminate|internal-error|hw-defect|service-not-supported|fru-not-supported|end-point-protocol-error|capability-unavailable|fru-not-ready|capability-not-implemented-ignore|fru-info-malformed|timeout){0,1}""", [], ["0-4294967295"]),
			"FsmStageDescr":UcsPropertyMeta("FsmStageDescr", "fsmStageDescr", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, None, None, None, None, [], ["0-4294967295"]),
			"FsmStamp":UcsPropertyMeta("FsmStamp", "fsmStamp", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, None, None, None, """([0-9]){4}-([0-9]){2}-([0-9]){2}T([0-9]){2}:([0-9]){2}:([0-9]){2}((\.([0-9]){3})){0,1}""", ["never"], ["0-4294967295"]),
			"FsmStatus":UcsPropertyMeta("FsmStatus", "fsmStatus", "string", _VersionMeta.Version101e, UcsPropertyMeta.Internal, None, None, None, None, ["CircuitResetBegin", "CircuitResetDisableA", "CircuitResetDisableB", "CircuitResetEnableA", "CircuitResetEnableB", "CircuitResetFail", "CircuitResetSuccess", "nop"], ["0-4294967295"]),
			"FsmTry":UcsPropertyMeta("FsmTry", "fsmTry", "byte", _VersionMeta.Version101e, UcsPropertyMeta.Internal, None, None, None, None, [], ["0-4294967295"]),
			"Id":UcsPropertyMeta("Id", "id", "uint", _VersionMeta.Version101e, UcsPropertyMeta.Naming, 0x10L, None, None, None, [], ["0-4294967295"]),
			"IfRole":UcsPropertyMeta("IfRole", "ifRole", "string", _VersionMeta.Version101e, UcsPropertyMeta.ReadOnly, None, None, None, None, ["diag", "fcoe-nas-storage", "fcoe-storage", "fc