# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['asyncio_socks_server']

package_data = \
{'': ['*']}

entry_points = \
{'console_scripts': ['asyncio_socks_server = '
                     'asyncio_socks_server.__main__:main']}

setup_kwargs = {
    'name': 'asyncio-socks-server',
    'version': '0.3.0',
    'description': 'A socks server implemented with asyncio.',
    'long_description': '# asyncio-socks-server\n\n![Latest version](https://img.shields.io/pypi/v/asyncio-socks-server?color=537CDE&label=Latest&logo=pypi&logoColor=white)\n![Build](https://img.shields.io/github/workflow/status/Amaindex/asyncio-socks-server/Release?color=89E0A3&label=Build&logo=github&logoColor=white)\n![Image](https://img.shields.io/github/workflow/status/Amaindex/asyncio-socks-server/Image?color=89E0A3&label=Image&logo=github&logoColor=white)\n![Tests](https://img.shields.io/github/workflow/status/Amaindex/asyncio-socks-server/Tests?color=89E0A3&label=Tests&logo=github)\n![Build](https://img.shields.io/docker/image-size/amaindex/asyncio-socks-server?color=F29CF2&logo=docker&logoColor=white&sort=semver)\n\nA SOCKS proxy server implemented with the powerful python cooperative concurrency framework **asyncio**. \n\n## Features\n\n- Supports both TCP and UDP with the implementation of SOCKS5 protocol\n- Supports username/password authentication\n- Provides optional strict mode that follows [RFC1928](https://www.ietf.org/rfc/rfc1928.txt) and [RFC1929](https://www.ietf.org/rfc/rfc1929.txt) without compromise\n- Driven by the python standard library, no third-party dependencies\n\n## Installation\nInstall with pip if Python version 3.8.0 or higher is available.\n```shell\npip install asyncio-socks-server\n```\n\nOr pull a docker image from the [Docker Hub registry](https://hub.docker.com/r/amaindex/asyncio-socks-server).\n```shell\ndocker pull amaindex/asyncio-socks-server\n```\n\n## Usage\nWhen installed with pip, you can invoke asyncio-socks-server from the command-line:\n```shell\nasyncio_socks_server [-h] [-v] \n                     [-H HOST] [-P PORT] [-A METHOD] \n                     [--access-log] [--debug] [--strict] \n                     [--env-prefix ENV_PREFIX]\n                     [--config PATH]\n```\nwhere:\n\n- `asyncio_socks_server`: You could use python -m asyncio_socks_server in development.\n- `-h`, `--help`: Show a help message and exit.\n- `-v`, `--version`: Show program\'s version number and exit.\n- `-H HOST`, `--host HOST`: Host address to listen (default 0.0.0.0).\n- `-P PORT`, `--port PORT`: Port to listen (default 1080).\n- `-A METHOD`, `--auth METHOD`: Authentication method (default 0). \n  Possible values: 0 (no auth), 2 (username/password auth)\n- `--access-log`: Display access log.\n- `--debug`: Work in debug mode.\n- `--strict`: Work in strict compliance with RFC1928 and RFC1929.\n\nIf the value of `METHOD` is 2, that is, when the username/password authentication \nis specified, you need to provide a config file containing the usernames and passwords \nin json format with the `--config` option.\nYou can also list other options in the config file instead of the command：\n\n`config.json`:\n```json\n{\n  "LISTEN_HOST": "0.0.0.0",\n  "LISTEN_PORT": 1080,\n  "AUTH_METHOD": 2,\n  "ACCESS_LOG": true,\n  "DEBUG": true,\n  "STRICT": true,\n  "USERS": {\n    "username1": "password1",\n    "username2": "password2",\n    "username3": "password3"\n  }\n}\n\n```\n```shell\nasyncio_socks_server --config ${ENV}/config.json\n```\nIn addition, any environment variable named starting with `AIOSS_` will also be applied \nto the option. \nThe prefix can be changed by specifying the `--env-prefix` option，for example:\n```shell\nexport MY_LISTEN_HOST=127.0.0.1\nexport MY_LISTEN_PORT=9999\nasyncio_socks_server --env-prefix MY_\n```\n\n**NOTE:** The loading order of the options is: config file, environment variables, command options. \nThe latter will overwrite the former if options are given in multiple ways.\n\nAlternatively, if you use the docker image, you can launch the asyncio-socks-server with the following command:\n```shell\ndocker run amaindex/asyncio-socks-server [-h] [-v] \n                                         [-H HOST] [-P PORT] [-A METHOD] \n                                         [--access-log] [--debug] [--strict] \n                                         [--env-prefix ENV_PREFIX]\n                                         [--config PATH]\n```\nThe network mode `host` is recommended since asyncio-socks-server uses multiple ports dynamically. \nIf you also want to provide a config file, it should be mounted manually.\n```shell\ndocker run \\\n    --rm \\\n    --net=host \\\n    -v /host/path/config.json:/config.json \\ \n    amaindex/asyncio-socks-server \\\n    --config /config.json\n```\n\n## Strict Mode\n\nFor various reasons, asyncio-socks-server has made some compromises on the \nImplementation details of the protocols. Therefore, in the following scenes, \nasyncio-socks-server’s behavior will be divergent from that described in RFC1928 \nand RFC1929.\n\n### asyncio-socks-server relays all UDP datagrams by default\n\nIn the SOCKS5 negotiation, a UDP ASSOCIATE request formed as follows is used to \nestablish an association within the UDP relay process to handle UDP datagrams:\n```text\n+----+-----+-------+------+----------+----------+\n|VER | CMD |  RSV  | ATYP | DST.ADDR | DST.PORT |\n+----+-----+-------+------+----------+----------+\n| 1  |  1  | X\'00\' |  1   | Variable |    2     |\n+----+-----+-------+------+----------+----------+\n```\nNormally, the DST.ADDR and DST.PORT fields contain the address and port that the \nclient expects to use to send UDP datagrams on for the association, or use a port number \nand address of all zeros if the client does not possess this information. \nTherefore, when the client is working in a network that uses NAT, the DST.ADDR \nwith all zeros should be used to avoid errors. But in case some clients \ndid not follow this principle correctly, asyncio-socks-server relays all UDP datagrams \nit receives by default instead of using DST.ADDR and DST.PORT to limit the access.\n\n\n### asyncio-socks-server allows "V5" username/password authentication\n\nOnce the client selects the username/password authentication during negotiation, \nit will conduct a sub-negotiation with the server. This sub-negotiation begins with \nthe client producing a request:\n```text\n+----+------+----------+------+----------+\n|VER | ULEN |  UNAME   | PLEN |  PASSWD  |\n+----+------+----------+------+----------+\n| 1  |  1   | 1 to 255 |  1   | 1 to 255 |\n+----+------+----------+------+----------+\n```\nThe VER field contains the current version of the sub-negotiation, which is X\'01\' but\noften considered as X\'05\' since it\'s a bit counter-intuitive. \nSo asyncio-socks-server allows requests with VER X\'05\' in non-strict mode.\n\n### `--strict` option\n\nTo disable the compromise described above, you can specify the `--strict` option:\n```shell\nasyncio_socks_server --strict\n```\n\n## Reference\n\n- [RFC1928](https://www.ietf.org/rfc/rfc1928.txt)\n- [RFC1929](https://www.ietf.org/rfc/rfc1929.txt)\n- [Anorov/PySocks](https://github.com/Anorov/PySocks)\n- [Aber/socks5](https://github.com/Aber-s-practice/socks5)\n- [Ehco1996/aioshadowsocks](https://github.com/Ehco1996/aioshadowsocks)\n',
    'author': 'Amaindex',
    'author_email': 'amaindex@outlook.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/Amaindex/asyncio-socks-server',
    'packages': packages,
    'package_data': package_data,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
