"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GlobalTable = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const dynamodb = require("@aws-cdk/aws-dynamodb");
const cdk = require("@aws-cdk/core");
const global_table_coordinator_1 = require("./global-table-coordinator");
// keep this import separate from other imports to reduce chance for merge conflicts with v2-main
// eslint-disable-next-line no-duplicate-imports, import/order
const core_1 = require("@aws-cdk/core");
/**
 * This class works by deploying an AWS DynamoDB table into each region specified in  GlobalTableProps.regions[],
 * then triggering a CloudFormation Custom Resource Lambda to link them all together to create linked AWS Global DynamoDB tables.
 *
 * @deprecated use `@aws-cdk/aws-dynamodb.Table.replicationRegions` instead
 */
class GlobalTable extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        /**
         * Creates dynamoDB tables across regions that will be able to be globbed together into a global table
         */
        this._regionalTables = new Array();
        try {
            jsiiDeprecationWarnings.print("@aws-cdk/aws-dynamodb-global.GlobalTable", "use `@aws-cdk/aws-dynamodb.Table.replicationRegions` instead");
            jsiiDeprecationWarnings._aws_cdk_aws_dynamodb_global_GlobalTableProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, GlobalTable);
            }
            throw error;
        }
        cdk.Annotations.of(this).addWarning('The @aws-cdk/aws-dynamodb-global module has been deprecated in favor of @aws-cdk/aws-dynamodb.Table.replicationRegions');
        this._regionalTables = [];
        if (props.stream != null && props.stream !== dynamodb.StreamViewType.NEW_AND_OLD_IMAGES) {
            throw new Error('dynamoProps.stream MUST be set to dynamodb.StreamViewType.NEW_AND_OLD_IMAGES');
        }
        // need to set this stream specification, otherwise global tables don't work
        // And no way to set a default value in an interface
        const regionalTableProps = {
            ...props,
            removalPolicy: props.removalPolicy,
            stream: dynamodb.StreamViewType.NEW_AND_OLD_IMAGES,
        };
        this.lambdaGlobalTableCoordinator = new global_table_coordinator_1.GlobalTableCoordinator(scope, id + '-CustomResource', props);
        const scopeStack = cdk.Stack.of(scope);
        // here we loop through the configured regions.
        // in each region we'll deploy a separate stack with a DynamoDB Table with identical properties in the individual stacks
        for (const region of props.regions) {
            const regionalStack = new cdk.Stack(this, id + '-' + region, { env: { region, account: scopeStack.account } });
            const regionalTable = new dynamodb.Table(regionalStack, `${id}-GlobalTable-${region}`, regionalTableProps);
            this._regionalTables.push(regionalTable);
            // deploy the regional stack before the Lambda coordinator stack
            this.lambdaGlobalTableCoordinator.addDependency(regionalStack);
        }
    }
    /**
     * Obtain tables deployed in other each region
     */
    get regionalTables() {
        try {
            jsiiDeprecationWarnings.print("@aws-cdk/aws-dynamodb-global.GlobalTable#regionalTables", "use `@aws-cdk/aws-dynamodb.Table.replicationRegions` instead");
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, jsiiDeprecationWarnings.getPropertyDescriptor(this, "regionalTables").get);
            }
            throw error;
        }
        return this._regionalTables.map(x => x);
    }
}
exports.GlobalTable = GlobalTable;
_a = JSII_RTTI_SYMBOL_1;
GlobalTable[_a] = { fqn: "@aws-cdk/aws-dynamodb-global.GlobalTable", version: "1.184.1" };
//# sourceMappingURL=data:application/json;base64,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