"""Helper functions used by fit_smdpl_hmf_script.py"""

import os
from glob import glob

import numpy as np


def get_scale_from_bn(bn):
    a = float(".".join(bn.split("_")[2].split(".")[:2]))
    return a


def get_z_from_bn(bn):
    a = get_scale_from_bn(bn)
    return 1 / a - 1


def get_loss_data(drn, halotype):
    """Assemble multi-redshift loss data used to fit the HMF model

    Parameters
    ----------
    drn : string
        Location of the output data generated by measure_smdpl_hmf_script.py

    halotype : string
        Should be either `hosthalos` or `subhalos`

    """
    assert halotype in ("hosthalos", "subhalos"), f"Unrecognized halotype={halotype}"

    fn_list = sorted(glob(os.path.join(drn, f"*{halotype}.lgcuml_density*.npy")))
    bn_list = [os.path.basename(fn) for fn in fn_list]
    fn_list_lgmp = [s.replace("lgcuml_density", "logmp_bins") for s in fn_list]

    z_list = np.array([get_z_from_bn(bname) for bname in bn_list])

    loss_data_collector = []
    for iz, (fn, fn_lgmp) in enumerate(zip(fn_list, fn_list_lgmp)):
        lgcuml_density = np.load(fn)
        lgmp_bins = np.load(fn_lgmp)
        loss_data_iz = (z_list[iz], lgmp_bins, lgcuml_density)
        loss_data_collector.append(loss_data_iz)

    return loss_data_collector
