# coding: utf-8

"""
    Antenny API

    This is an api that allows you to interact with the Antenny platform. It allows you to manage your clients and subscriptions.  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: admin@antenny.io
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from antenny.configuration import Configuration


class Resource(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'protocol': 'str',
        'url': 'str',
        'headers': 'list[Header]',
        'messages': 'list[Message]'
    }

    attribute_map = {
        'protocol': 'protocol',
        'url': 'url',
        'headers': 'headers',
        'messages': 'messages'
    }

    def __init__(self, protocol=None, url=None, headers=None, messages=None, local_vars_configuration=None):  # noqa: E501
        """Resource - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._protocol = None
        self._url = None
        self._headers = None
        self._messages = None
        self.discriminator = None

        self.protocol = protocol
        self.url = url
        if headers is not None:
            self.headers = headers
        if messages is not None:
            self.messages = messages

    @property
    def protocol(self):
        """Gets the protocol of this Resource.  # noqa: E501


        :return: The protocol of this Resource.  # noqa: E501
        :rtype: str
        """
        return self._protocol

    @protocol.setter
    def protocol(self, protocol):
        """Sets the protocol of this Resource.


        :param protocol: The protocol of this Resource.  # noqa: E501
        :type protocol: str
        """
        if self.local_vars_configuration.client_side_validation and protocol is None:  # noqa: E501
            raise ValueError("Invalid value for `protocol`, must not be `None`")  # noqa: E501
        allowed_values = ["ws", "http"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and protocol not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `protocol` ({0}), must be one of {1}"  # noqa: E501
                .format(protocol, allowed_values)
            )

        self._protocol = protocol

    @property
    def url(self):
        """Gets the url of this Resource.  # noqa: E501


        :return: The url of this Resource.  # noqa: E501
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """Sets the url of this Resource.


        :param url: The url of this Resource.  # noqa: E501
        :type url: str
        """
        if self.local_vars_configuration.client_side_validation and url is None:  # noqa: E501
            raise ValueError("Invalid value for `url`, must not be `None`")  # noqa: E501

        self._url = url

    @property
    def headers(self):
        """Gets the headers of this Resource.  # noqa: E501


        :return: The headers of this Resource.  # noqa: E501
        :rtype: list[Header]
        """
        return self._headers

    @headers.setter
    def headers(self, headers):
        """Sets the headers of this Resource.


        :param headers: The headers of this Resource.  # noqa: E501
        :type headers: list[Header]
        """

        self._headers = headers

    @property
    def messages(self):
        """Gets the messages of this Resource.  # noqa: E501


        :return: The messages of this Resource.  # noqa: E501
        :rtype: list[Message]
        """
        return self._messages

    @messages.setter
    def messages(self, messages):
        """Sets the messages of this Resource.


        :param messages: The messages of this Resource.  # noqa: E501
        :type messages: list[Message]
        """

        self._messages = messages

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Resource):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Resource):
            return True

        return self.to_dict() != other.to_dict()
