import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GitlabProviderConfig {
    /**
    * This is the target GitLab base API endpoint. Providing a value is a requirement when working with GitLab CE or GitLab Enterprise e.g. `https://my.gitlab.server/api/v4/`. It is optional to provide this value and it can also be sourced from the `GITLAB_BASE_URL` environment variable. The value must end with a slash.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab#base_url GitlabProvider#base_url}
    */
    readonly baseUrl?: string;
    /**
    * This is a file containing the ca cert to verify the gitlab instance. This is available for use when working with GitLab CE or Gitlab Enterprise with a locally-issued or self-signed certificate chain.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab#cacert_file GitlabProvider#cacert_file}
    */
    readonly cacertFile?: string;
    /**
    * File path to client certificate when GitLab instance is behind company proxy. File must contain PEM encoded data.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab#client_cert GitlabProvider#client_cert}
    */
    readonly clientCert?: string;
    /**
    * File path to client key when GitLab instance is behind company proxy. File must contain PEM encoded data. Required when `client_cert` is set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab#client_key GitlabProvider#client_key}
    */
    readonly clientKey?: string;
    /**
    * (Experimental) By default the provider does a dummy request to get the current user in order to verify that the provider configuration is correct and the GitLab API is reachable. Set this to `false` to skip this check. This may be useful if the GitLab instance does not yet exist and is created within the same terraform module. It may be sourced from the `GITLAB_EARLY_AUTH_CHECK`. This is an experimental feature and may change in the future. Please make sure to always keep backups of your state.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab#early_auth_check GitlabProvider#early_auth_check}
    */
    readonly earlyAuthCheck?: boolean | cdktf.IResolvable;
    /**
    * When set to true this disables SSL verification of the connection to the GitLab instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab#insecure GitlabProvider#insecure}
    */
    readonly insecure?: boolean | cdktf.IResolvable;
    /**
    * The OAuth2 Token, Project, Group, Personal Access Token or CI Job Token used to connect to GitLab. The OAuth method is used in this provider for authentication (using Bearer authorization token). See https://docs.gitlab.com/ee/api/#authentication for details. It may be sourced from the `GITLAB_TOKEN` environment variable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab#token GitlabProvider#token}
    */
    readonly token?: string;
    /**
    * Alias name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab#alias GitlabProvider#alias}
    */
    readonly alias?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab gitlab}
*/
export declare class GitlabProvider extends cdktf.TerraformProvider {
    static readonly tfResourceType = "gitlab";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab gitlab} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GitlabProviderConfig = {}
    */
    constructor(scope: Construct, id: string, config?: GitlabProviderConfig);
    private _baseUrl?;
    get baseUrl(): string | undefined;
    set baseUrl(value: string | undefined);
    resetBaseUrl(): void;
    get baseUrlInput(): string | undefined;
    private _cacertFile?;
    get cacertFile(): string | undefined;
    set cacertFile(value: string | undefined);
    resetCacertFile(): void;
    get cacertFileInput(): string | undefined;
    private _clientCert?;
    get clientCert(): string | undefined;
    set clientCert(value: string | undefined);
    resetClientCert(): void;
    get clientCertInput(): string | undefined;
    private _clientKey?;
    get clientKey(): string | undefined;
    set clientKey(value: string | undefined);
    resetClientKey(): void;
    get clientKeyInput(): string | undefined;
    private _earlyAuthCheck?;
    get earlyAuthCheck(): boolean | cdktf.IResolvable | undefined;
    set earlyAuthCheck(value: boolean | cdktf.IResolvable | undefined);
    resetEarlyAuthCheck(): void;
    get earlyAuthCheckInput(): boolean | cdktf.IResolvable | undefined;
    private _insecure?;
    get insecure(): boolean | cdktf.IResolvable | undefined;
    set insecure(value: boolean | cdktf.IResolvable | undefined);
    resetInsecure(): void;
    get insecureInput(): boolean | cdktf.IResolvable | undefined;
    private _token?;
    get token(): string | undefined;
    set token(value: string | undefined);
    resetToken(): void;
    get tokenInput(): string | undefined;
    private _alias?;
    get alias(): string | undefined;
    set alias(value: string | undefined);
    resetAlias(): void;
    get aliasInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
