import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGitlabProjectHookConfig extends cdktf.TerraformMetaArguments {
    /**
    * The id of the project hook.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/project_hook#hook_id DataGitlabProjectHook#hook_id}
    */
    readonly hookId: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/project_hook#id DataGitlabProjectHook#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name or id of the project to add the hook to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/project_hook#project DataGitlabProjectHook#project}
    */
    readonly project: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/d/project_hook gitlab_project_hook}
*/
export declare class DataGitlabProjectHook extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "gitlab_project_hook";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/d/project_hook gitlab_project_hook} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGitlabProjectHookConfig
    */
    constructor(scope: Construct, id: string, config: DataGitlabProjectHookConfig);
    get confidentialIssuesEvents(): cdktf.IResolvable;
    get confidentialNoteEvents(): cdktf.IResolvable;
    get deploymentEvents(): cdktf.IResolvable;
    get enableSslVerification(): cdktf.IResolvable;
    private _hookId?;
    get hookId(): number;
    set hookId(value: number);
    get hookIdInput(): number | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get issuesEvents(): cdktf.IResolvable;
    get jobEvents(): cdktf.IResolvable;
    get mergeRequestsEvents(): cdktf.IResolvable;
    get noteEvents(): cdktf.IResolvable;
    get pipelineEvents(): cdktf.IResolvable;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
    get projectId(): number;
    get pushEvents(): cdktf.IResolvable;
    get pushEventsBranchFilter(): string;
    get releasesEvents(): cdktf.IResolvable;
    get tagPushEvents(): cdktf.IResolvable;
    get token(): string;
    get url(): string;
    get wikiPageEvents(): cdktf.IResolvable;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
