import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * Repositories can have multiple webhooks installed. Each webhook should have a unique config. Multiple webhooks can share the same config as long as those webhooks do not have any events that overlap.
 *
 * @schema CfnWebhookProps
 */
export interface CfnWebhookProps {
    /**
     * The organisation owner
     *
     * @schema CfnWebhookProps#Owner
     */
    readonly owner: string;
    /**
     * Use web to create a webhook. Default: web. This parameter only accepts the value web.
     *
     * @schema CfnWebhookProps#Name
     */
    readonly name?: CfnWebhookPropsName;
    /**
     * Determines if notifications are sent when the webhook is triggered. Set to true to send notifications.
     *
     * @schema CfnWebhookProps#Active
     */
    readonly active?: boolean;
    /**
     * Determines what events the hook is triggered for.
     *
     * @schema CfnWebhookProps#Events
     */
    readonly events?: string[];
    /**
     * The name of the repository. The name is not case sensitive.
     *
     * @schema CfnWebhookProps#Repository
     */
    readonly repository?: string;
    /**
     * The media type used to serialize the payloads. Supported values include json and form. The default is form.
     *
     * @schema CfnWebhookProps#ContentType
     */
    readonly contentType?: CfnWebhookPropsContentType;
    /**
     * The URL to which the payloads will be delivered.
     *
     * @schema CfnWebhookProps#Url
     */
    readonly url?: string;
    /**
     * If provided, the secret will be used as the key to generate the HMAC hex digest value for delivery signature headers.
     *
     * @schema CfnWebhookProps#Secret
     */
    readonly secret?: string;
    /**
     * Determines whether the SSL certificate of the host for url will be verified when delivering payloads. Supported values include 0 (verification is performed) and 1 (verification is not performed). The default is 0. We strongly recommend not setting this to 1 as you are subject to man-in-the-middle and other attacks.
     *
     * @schema CfnWebhookProps#InsecureSsl
     */
    readonly insecureSsl?: CfnWebhookPropsInsecureSsl;
}
/**
 * Converts an object of type 'CfnWebhookProps' to JSON representation.
 */
export declare function toJson_CfnWebhookProps(obj: CfnWebhookProps | undefined): Record<string, any> | undefined;
/**
 * Use web to create a webhook. Default: web. This parameter only accepts the value web.
 *
 * @schema CfnWebhookPropsName
 */
export declare enum CfnWebhookPropsName {
    /** web */
    WEB = "web"
}
/**
 * The media type used to serialize the payloads. Supported values include json and form. The default is form.
 *
 * @schema CfnWebhookPropsContentType
 */
export declare enum CfnWebhookPropsContentType {
    /** form */
    FORM = "form",
    /** json */
    JSON = "json"
}
/**
 * Determines whether the SSL certificate of the host for url will be verified when delivering payloads. Supported values include 0 (verification is performed) and 1 (verification is not performed). The default is 0. We strongly recommend not setting this to 1 as you are subject to man-in-the-middle and other attacks.
 *
 * @schema CfnWebhookPropsInsecureSsl
 */
export declare enum CfnWebhookPropsInsecureSsl {
    /** 0 */
    VALUE_0 = 0,
    /** 1 */
    VALUE_1 = 1
}
/**
 * A CloudFormation `GitHub::Repositories::Webhook`
 *
 * @cloudformationResource GitHub::Repositories::Webhook
 * @stability external
 * @link https://github.com/aws-ia/cloudformation-github-resource-providers.git
 */
export declare class CfnWebhook extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "GitHub::Repositories::Webhook";
    /**
     * Resource props.
     */
    readonly props: CfnWebhookProps;
    /**
     * Attribute `GitHub::Repositories::Webhook.Id`
     * @link https://github.com/aws-ia/cloudformation-github-resource-providers.git
     */
    readonly attrId: number;
    /**
     * Create a new `GitHub::Repositories::Webhook`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnWebhookProps);
}
