"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
/* eslint-disable no-console */
const url_1 = require("url");
const aws_sdk_1 = require("aws-sdk"); // eslint-disable-line import/no-extraneous-dependencies
function base62Encode(int) {
    const characterSet = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
    if (int === 0)
        return '0';
    let s = '';
    while (int > 0) {
        s = characterSet[int % 62] + s;
        int = Math.floor(int / 62);
    }
    return s;
}
;
function getEnv(name) {
    const value = process.env[name];
    if (!value) {
        throw new Error(`The environment variable ${name} is not defined`);
    }
    return value;
}
function isUrlValid(url) {
    if (!url) {
        return false;
    }
    try {
        new url_1.URL(url);
        return true;
    }
    catch (err) {
        return false;
    }
}
const documentClient = new aws_sdk_1.DynamoDB.DocumentClient({ apiVersion: '2012-08-10' });
const s3 = new aws_sdk_1.S3({ apiVersion: '2006-03-01' });
async function handler(event) {
    var _a, _b;
    console.log('Event: %j', event);
    const response = {
        statusCode: 201,
        body: '',
        headers: process.env.CORS_ALLOW_ORIGINS
            ? { 'Access-Control-Allow-Origin': process.env.CORS_ALLOW_ORIGINS }
            : undefined,
    };
    try {
        const body = JSON.parse((_a = event.body) !== null && _a !== void 0 ? _a : '{}');
        if (!isUrlValid(body.url)) {
            return {
                ...response,
                statusCode: 400,
            };
        }
        // Get next counter value
        const update = await documentClient.update({
            TableName: getEnv('TABLE_NAME'),
            Key: { key: 'counter' },
            UpdateExpression: 'ADD #value :incr',
            ExpressionAttributeNames: { '#value': 'value' },
            ExpressionAttributeValues: { ':incr': 1 },
            ReturnValues: 'UPDATED_NEW',
        }).promise();
        const value = (_b = update.Attributes) === null || _b === void 0 ? void 0 : _b.value;
        if (!value) {
            throw new Error('Cannot get next counter value');
        }
        const key = base62Encode(value);
        console.log('Key: %j', key);
        const putObject = await s3.putObject({
            Bucket: getEnv('BUCKET_NAME'),
            Key: key,
            ContentType: 'application/json',
            Body: JSON.stringify({ url: body.url }),
        }).promise();
        console.log('Put object: %j', putObject);
        // Return short url
        return {
            ...response,
            body: JSON.stringify({
                url: body.url,
                shortUrl: `https://${getEnv('DOMAIN_NAME')}/${key}`,
            }),
        };
    }
    catch (err) {
        console.log(err);
        return {
            ...response,
            statusCode: 500,
        };
    }
}
exports.handler = handler;
//# sourceMappingURL=data:application/json;base64,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