"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
const aws_sdk_1 = require("aws-sdk"); // eslint-disable-line import/no-extraneous-dependencies
const s3 = new aws_sdk_1.S3({ apiVersion: '2006-03-01' });
async function handler(event) {
    var _a;
    const request = event.Records[0].cf.request;
    try {
        const s3Origin = (_a = request.origin) === null || _a === void 0 ? void 0 : _a.s3;
        if (!s3Origin) {
            throw new Error('No S3 origin');
        }
        const bucket = s3Origin.domainName.replace(new RegExp(`.s3.${s3Origin.region}.amazonaws.com$`), '');
        const key = request.uri.substring(1); // remove first slash
        const data = await s3.getObject({
            Bucket: bucket,
            Key: key,
        }).promise();
        if (!data.Body) {
            throw new Error('No body');
        }
        const redirect = JSON.parse(data.Body.toString());
        return {
            status: '301',
            statusDescription: 'Moved Permanently',
            headers: {
                location: [{
                        key: 'Location',
                        value: redirect.url,
                    }],
            },
        };
    }
    catch (err) {
        console.log(err);
        return {
            status: '404',
            statusDescription: 'Not Found',
        };
    }
}
exports.handler = handler;
//# sourceMappingURL=data:application/json;base64,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