import { Duration } from 'aws-cdk-lib';
import { Schedule } from 'aws-cdk-lib/aws-events';
import { Construct } from 'constructs';
/**
 * Properties for a ToolkitCleaner
 */
export interface ToolkitCleanerProps {
    /**
     * The schedule for the cleaner.
     *
     * @default - every day
     */
    readonly schedule?: Schedule;
    /**
     * Whether to clean on schedule. If you'd like to run the cleanup manually
     * via the console, set to `false`.
     *
     * @default true
     */
    readonly scheduleEnabled?: boolean;
    /**
     * Only output number of assets and total size that would be deleted
     * but without actually deleting assets.
     */
    readonly dryRun?: boolean;
    /**
     * Retain unused assets that were created recently
     *
     * @default - all unused assets are removed
     */
    readonly retainAssetsNewerThan?: Duration;
}
/**
 * Clean unused S3 and ECR assets from your CDK Toolkit.
 */
export declare class ToolkitCleaner extends Construct {
    constructor(scope: Construct, id: string, props?: ToolkitCleanerProps);
}
//# sourceMappingURL=index.d.ts.map