import { SecretValue } from 'aws-cdk-lib';
import { Construct } from 'constructs';
/**
 * Properties for a SlackTextract
 */
export interface SlackTextractProps {
    /**
     * The signing secret of the Slack app
     */
    readonly signingSecret: SecretValue;
    /**
     * The **bot** token of the Slack app.
     *
     * The following scopes are required: `chat:write` and `files:read`
     */
    readonly botToken: SecretValue;
    /**
     * The application id of the Slack app.
     */
    readonly appId: string;
}
/**
 * Extract text from images posted to Slack using Amazon Textract
 */
export declare class SlackTextract extends Construct {
    constructor(scope: Construct, id: string, props: SlackTextractProps);
}
//# sourceMappingURL=index.d.ts.map