"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SamlFederatedPrincipal = exports.SamlIdentityProvider = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const iam = require("aws-cdk-lib/aws-iam");
const cr = require("aws-cdk-lib/custom-resources");
const constructs_1 = require("constructs");
/**
 * Create a SAML identity provider
 *
 * @deprecated use `SamlProvider` from `aws-cdk-lib/aws-iam`
 */
class SamlIdentityProvider extends constructs_1.Construct {
    constructor(scope, id, props) {
        var _c;
        super(scope, id);
        const name = (_c = props.name) !== null && _c !== void 0 ? _c : `${aws_cdk_lib_1.Names.uniqueId(this)}IdentityProvider`;
        const arn = aws_cdk_lib_1.Stack.of(this).formatArn({
            service: 'iam',
            region: '',
            resource: 'saml-provider',
            resourceName: name,
        });
        const idp = new cr.AwsCustomResource(this, 'Resource', {
            resourceType: 'Custom::SamlIdentityProvider',
            onCreate: {
                service: 'IAM',
                action: 'createSAMLProvider',
                parameters: {
                    Name: name,
                    SAMLMetadataDocument: props.metadataDocument,
                },
                physicalResourceId: cr.PhysicalResourceId.fromResponse('SAMLProviderArn'),
            },
            onUpdate: {
                service: 'IAM',
                action: 'updateSAMLProvider',
                parameters: {
                    SAMLProviderArn: new cr.PhysicalResourceIdReference().toJSON(),
                    SAMLMetadataDocument: props.metadataDocument,
                },
                physicalResourceId: cr.PhysicalResourceId.fromResponse('SAMLProviderArn'),
            },
            onDelete: {
                service: 'IAM',
                action: 'deleteSAMLProvider',
                parameters: {
                    SAMLProviderArn: new cr.PhysicalResourceIdReference().toJSON(),
                },
            },
            policy: cr.AwsCustomResourcePolicy.fromStatements([
                new iam.PolicyStatement({
                    actions: [
                        'iam:createSAMLProvider',
                        'iam:updateSAMLProvider',
                        'iam:deleteSAMLProvider',
                    ],
                    resources: [arn],
                }),
            ]),
        });
        this.samlIdentityProviderArn = idp.getResponseField('SAMLProviderArn');
    }
}
exports.SamlIdentityProvider = SamlIdentityProvider;
_a = JSII_RTTI_SYMBOL_1;
SamlIdentityProvider[_a] = { fqn: "cloudstructs.SamlIdentityProvider", version: "0.5.3" };
/**
 * Principal entity that represents a SAML federated identity provider.
 *
 * @deprecated use `SamlPrincipal` from `aws-cdk-lib/aws-iam`
 */
class SamlFederatedPrincipal extends iam.FederatedPrincipal {
    constructor(identityProvider) {
        super(identityProvider.samlIdentityProviderArn, {
            StringEquals: {
                'SAML:aud': 'https://signin.aws.amazon.com/saml',
            },
        }, 'sts:AssumeRoleWithSAML');
    }
}
exports.SamlFederatedPrincipal = SamlFederatedPrincipal;
_b = JSII_RTTI_SYMBOL_1;
SamlFederatedPrincipal[_b] = { fqn: "cloudstructs.SamlFederatedPrincipal", version: "0.5.3" };
//# sourceMappingURL=data:application/json;base64,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