"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CDKApplication = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const ciStack_1 = require("./ciStack");
const context_1 = require("./util/context");
class CDKApplication extends aws_cdk_lib_1.App {
    constructor(props) {
        super(props);
        const ci = this.node.tryGetContext('ci');
        const env = this.node.tryGetContext('env');
        const projectName = context_1.getProjectName(this);
        if (ci && ci.toLowerCase() === 'true') {
            const environment = context_1.getEnvironmentConfig(this, 'ci');
            new ciStack_1.CIStack(this, 'CI', {
                stackName: `${projectName}-ci`,
                env: environment,
                ...props,
            });
        }
        else if (env) {
            props.stacks.create(this, projectName, env);
        }
        else {
            throw new Error('Either "env" or "ci" context value must be provided');
        }
    }
}
exports.CDKApplication = CDKApplication;
_a = JSII_RTTI_SYMBOL_1;
CDKApplication[_a] = { fqn: "opinionated-ci-pipeline.CDKApplication", version: "1.0.0-beta.2" };
//# sourceMappingURL=data:application/json;base64,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