# coding: utf-8

"""
    Payment Gateway API Specification.

    The documentation here is designed to provide all of the technical guidance required to consume and integrate with our APIs for payment processing. To learn more about our APIs please visit https://docs.firstdata.com/org/gateway.  # noqa: E501

    The version of the OpenAPI document: 6.14.0.20201015.001
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class SharedSecretConfigurationResponse(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'client_request_id': 'str',
        'api_trace_id': 'str',
        'response_type': 'ResponseType',
        'store_id': 'str',
        'shared_secret': 'str',
        'response_message': 'str',
        'response_timestamp': 'int'
    }

    attribute_map = {
        'client_request_id': 'clientRequestId',
        'api_trace_id': 'apiTraceId',
        'response_type': 'responseType',
        'store_id': 'storeId',
        'shared_secret': 'sharedSecret',
        'response_message': 'responseMessage',
        'response_timestamp': 'responseTimestamp'
    }

    def __init__(self, client_request_id=None, api_trace_id=None, response_type=None, store_id=None, shared_secret=None, response_message=None, response_timestamp=None):  # noqa: E501
        """SharedSecretConfigurationResponse - a model defined in OpenAPI"""  # noqa: E501

        self._client_request_id = None
        self._api_trace_id = None
        self._response_type = None
        self._store_id = None
        self._shared_secret = None
        self._response_message = None
        self._response_timestamp = None
        self.discriminator = None

        if client_request_id is not None:
            self.client_request_id = client_request_id
        if api_trace_id is not None:
            self.api_trace_id = api_trace_id
        if response_type is not None:
            self.response_type = response_type
        if store_id is not None:
            self.store_id = store_id
        if shared_secret is not None:
            self.shared_secret = shared_secret
        if response_message is not None:
            self.response_message = response_message
        if response_timestamp is not None:
            self.response_timestamp = response_timestamp

    @property
    def client_request_id(self):
        """Gets the client_request_id of this SharedSecretConfigurationResponse.  # noqa: E501

        Echoes back the value in the request header for tracking.  # noqa: E501

        :return: The client_request_id of this SharedSecretConfigurationResponse.  # noqa: E501
        :rtype: str
        """
        return self._client_request_id

    @client_request_id.setter
    def client_request_id(self, client_request_id):
        """Sets the client_request_id of this SharedSecretConfigurationResponse.

        Echoes back the value in the request header for tracking.  # noqa: E501

        :param client_request_id: The client_request_id of this SharedSecretConfigurationResponse.  # noqa: E501
        :type: str
        """

        self._client_request_id = client_request_id

    @property
    def api_trace_id(self):
        """Gets the api_trace_id of this SharedSecretConfigurationResponse.  # noqa: E501

        Request identifier in API, can be used to request logs from the support team.  # noqa: E501

        :return: The api_trace_id of this SharedSecretConfigurationResponse.  # noqa: E501
        :rtype: str
        """
        return self._api_trace_id

    @api_trace_id.setter
    def api_trace_id(self, api_trace_id):
        """Sets the api_trace_id of this SharedSecretConfigurationResponse.

        Request identifier in API, can be used to request logs from the support team.  # noqa: E501

        :param api_trace_id: The api_trace_id of this SharedSecretConfigurationResponse.  # noqa: E501
        :type: str
        """

        self._api_trace_id = api_trace_id

    @property
    def response_type(self):
        """Gets the response_type of this SharedSecretConfigurationResponse.  # noqa: E501


        :return: The response_type of this SharedSecretConfigurationResponse.  # noqa: E501
        :rtype: ResponseType
        """
        return self._response_type

    @response_type.setter
    def response_type(self, response_type):
        """Sets the response_type of this SharedSecretConfigurationResponse.


        :param response_type: The response_type of this SharedSecretConfigurationResponse.  # noqa: E501
        :type: ResponseType
        """

        self._response_type = response_type

    @property
    def store_id(self):
        """Gets the store_id of this SharedSecretConfigurationResponse.  # noqa: E501

        An optional outlet ID for clients that support multiple stores in the same developer app.  # noqa: E501

        :return: The store_id of this SharedSecretConfigurationResponse.  # noqa: E501
        :rtype: str
        """
        return self._store_id

    @store_id.setter
    def store_id(self, store_id):
        """Sets the store_id of this SharedSecretConfigurationResponse.

        An optional outlet ID for clients that support multiple stores in the same developer app.  # noqa: E501

        :param store_id: The store_id of this SharedSecretConfigurationResponse.  # noqa: E501
        :type: str
        """

        self._store_id = store_id

    @property
    def shared_secret(self):
        """Gets the shared_secret of this SharedSecretConfigurationResponse.  # noqa: E501

        Shared secret/password for Connect.  # noqa: E501

        :return: The shared_secret of this SharedSecretConfigurationResponse.  # noqa: E501
        :rtype: str
        """
        return self._shared_secret

    @shared_secret.setter
    def shared_secret(self, shared_secret):
        """Sets the shared_secret of this SharedSecretConfigurationResponse.

        Shared secret/password for Connect.  # noqa: E501

        :param shared_secret: The shared_secret of this SharedSecretConfigurationResponse.  # noqa: E501
        :type: str
        """

        self._shared_secret = shared_secret

    @property
    def response_message(self):
        """Gets the response_message of this SharedSecretConfigurationResponse.  # noqa: E501

        The message/status received after updating shared secret service config.  # noqa: E501

        :return: The response_message of this SharedSecretConfigurationResponse.  # noqa: E501
        :rtype: str
        """
        return self._response_message

    @response_message.setter
    def response_message(self, response_message):
        """Sets the response_message of this SharedSecretConfigurationResponse.

        The message/status received after updating shared secret service config.  # noqa: E501

        :param response_message: The response_message of this SharedSecretConfigurationResponse.  # noqa: E501
        :type: str
        """

        self._response_message = response_message

    @property
    def response_timestamp(self):
        """Gets the response_timestamp of this SharedSecretConfigurationResponse.  # noqa: E501

        Response timestamp.  # noqa: E501

        :return: The response_timestamp of this SharedSecretConfigurationResponse.  # noqa: E501
        :rtype: int
        """
        return self._response_timestamp

    @response_timestamp.setter
    def response_timestamp(self, response_timestamp):
        """Sets the response_timestamp of this SharedSecretConfigurationResponse.

        Response timestamp.  # noqa: E501

        :param response_timestamp: The response_timestamp of this SharedSecretConfigurationResponse.  # noqa: E501
        :type: int
        """

        self._response_timestamp = response_timestamp

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SharedSecretConfigurationResponse):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
