# coding: utf-8

"""
    Payment Gateway API Specification.

    The documentation here is designed to provide all of the technical guidance required to consume and integrate with our APIs for payment processing. To learn more about our APIs please visit https://docs.firstdata.com/org/gateway.  # noqa: E501

    The version of the OpenAPI document: 6.14.0.20201015.001
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class ClearingDetails(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'clearing_elements': 'list[ClearingElement]',
        'batch_time_stamp': 'str',
        'receipt_number_from': 'int',
        'receipt_number_to': 'int',
        'trace_number': 'int'
    }

    attribute_map = {
        'clearing_elements': 'clearingElements',
        'batch_time_stamp': 'batchTimeStamp',
        'receipt_number_from': 'receiptNumberFrom',
        'receipt_number_to': 'receiptNumberTo',
        'trace_number': 'traceNumber'
    }

    def __init__(self, clearing_elements=None, batch_time_stamp=None, receipt_number_from=None, receipt_number_to=None, trace_number=None):  # noqa: E501
        """ClearingDetails - a model defined in OpenAPI"""  # noqa: E501

        self._clearing_elements = None
        self._batch_time_stamp = None
        self._receipt_number_from = None
        self._receipt_number_to = None
        self._trace_number = None
        self.discriminator = None

        if clearing_elements is not None:
            self.clearing_elements = clearing_elements
        if batch_time_stamp is not None:
            self.batch_time_stamp = batch_time_stamp
        if receipt_number_from is not None:
            self.receipt_number_from = receipt_number_from
        if receipt_number_to is not None:
            self.receipt_number_to = receipt_number_to
        if trace_number is not None:
            self.trace_number = trace_number

    @property
    def clearing_elements(self):
        """Gets the clearing_elements of this ClearingDetails.  # noqa: E501

        The array contains information about the clearing elements.  # noqa: E501

        :return: The clearing_elements of this ClearingDetails.  # noqa: E501
        :rtype: list[ClearingElement]
        """
        return self._clearing_elements

    @clearing_elements.setter
    def clearing_elements(self, clearing_elements):
        """Sets the clearing_elements of this ClearingDetails.

        The array contains information about the clearing elements.  # noqa: E501

        :param clearing_elements: The clearing_elements of this ClearingDetails.  # noqa: E501
        :type: list[ClearingElement]
        """

        self._clearing_elements = clearing_elements

    @property
    def batch_time_stamp(self):
        """Gets the batch_time_stamp of this ClearingDetails.  # noqa: E501

        Timestamp when the clearing has been processed. The used format is \"YYYYMMDDhhmmss\".  # noqa: E501

        :return: The batch_time_stamp of this ClearingDetails.  # noqa: E501
        :rtype: str
        """
        return self._batch_time_stamp

    @batch_time_stamp.setter
    def batch_time_stamp(self, batch_time_stamp):
        """Sets the batch_time_stamp of this ClearingDetails.

        Timestamp when the clearing has been processed. The used format is \"YYYYMMDDhhmmss\".  # noqa: E501

        :param batch_time_stamp: The batch_time_stamp of this ClearingDetails.  # noqa: E501
        :type: str
        """
        if batch_time_stamp is not None and not re.search(r'[0-9]{14}', batch_time_stamp):  # noqa: E501
            raise ValueError(r"Invalid value for `batch_time_stamp`, must be a follow pattern or equal to `/[0-9]{14}/`")  # noqa: E501

        self._batch_time_stamp = batch_time_stamp

    @property
    def receipt_number_from(self):
        """Gets the receipt_number_from of this ClearingDetails.  # noqa: E501

        Start receipt number for the clearing process.  # noqa: E501

        :return: The receipt_number_from of this ClearingDetails.  # noqa: E501
        :rtype: int
        """
        return self._receipt_number_from

    @receipt_number_from.setter
    def receipt_number_from(self, receipt_number_from):
        """Sets the receipt_number_from of this ClearingDetails.

        Start receipt number for the clearing process.  # noqa: E501

        :param receipt_number_from: The receipt_number_from of this ClearingDetails.  # noqa: E501
        :type: int
        """
        if receipt_number_from is not None and receipt_number_from > 9999:  # noqa: E501
            raise ValueError("Invalid value for `receipt_number_from`, must be a value less than or equal to `9999`")  # noqa: E501
        if receipt_number_from is not None and receipt_number_from < 1:  # noqa: E501
            raise ValueError("Invalid value for `receipt_number_from`, must be a value greater than or equal to `1`")  # noqa: E501

        self._receipt_number_from = receipt_number_from

    @property
    def receipt_number_to(self):
        """Gets the receipt_number_to of this ClearingDetails.  # noqa: E501

        End receipt number for the clearing process.  # noqa: E501

        :return: The receipt_number_to of this ClearingDetails.  # noqa: E501
        :rtype: int
        """
        return self._receipt_number_to

    @receipt_number_to.setter
    def receipt_number_to(self, receipt_number_to):
        """Sets the receipt_number_to of this ClearingDetails.

        End receipt number for the clearing process.  # noqa: E501

        :param receipt_number_to: The receipt_number_to of this ClearingDetails.  # noqa: E501
        :type: int
        """
        if receipt_number_to is not None and receipt_number_to > 9999:  # noqa: E501
            raise ValueError("Invalid value for `receipt_number_to`, must be a value less than or equal to `9999`")  # noqa: E501
        if receipt_number_to is not None and receipt_number_to < 1:  # noqa: E501
            raise ValueError("Invalid value for `receipt_number_to`, must be a value greater than or equal to `1`")  # noqa: E501

        self._receipt_number_to = receipt_number_to

    @property
    def trace_number(self):
        """Gets the trace_number of this ClearingDetails.  # noqa: E501

        Trace number for the clearing process.  # noqa: E501

        :return: The trace_number of this ClearingDetails.  # noqa: E501
        :rtype: int
        """
        return self._trace_number

    @trace_number.setter
    def trace_number(self, trace_number):
        """Sets the trace_number of this ClearingDetails.

        Trace number for the clearing process.  # noqa: E501

        :param trace_number: The trace_number of this ClearingDetails.  # noqa: E501
        :type: int
        """
        if trace_number is not None and trace_number > 999999:  # noqa: E501
            raise ValueError("Invalid value for `trace_number`, must be a value less than or equal to `999999`")  # noqa: E501
        if trace_number is not None and trace_number < 0:  # noqa: E501
            raise ValueError("Invalid value for `trace_number`, must be a value greater than or equal to `0`")  # noqa: E501

        self._trace_number = trace_number

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ClearingDetails):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
