"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !exports.hasOwnProperty(p)) __createBinding(exports, m, p);
};
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsExternalDns = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
const k8s = require("./imports/k8s");
__exportStar(require("./policy"), exports);
__exportStar(require("./imports/k8s"), exports);
/**
 * (experimental) Generate external-dns config yaml.
 *
 * see https://github.com/kubernetes-sigs/external-dns/blob/master/docs/tutorials/aws.md
 *
 * @experimental
 */
class AwsExternalDns extends constructs_1.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, options) {
        var _b, _c, _d, _e, _f;
        super(scope, id);
        this.serviceAccountName = (_b = options.serviceAccountName) !== null && _b !== void 0 ? _b : 'external-dns';
        this.deploymentName = 'external-dns';
        this.namespace = (_c = options.namespace) !== null && _c !== void 0 ? _c : 'default';
        this.image = (_d = options.image) !== null && _d !== void 0 ? _d : 'k8s.gcr.io/external-dns/external-dns:v0.7.6';
        this.nodeSelector = (_e = options.nodeSelector) !== null && _e !== void 0 ? _e : {};
        this.kongTCP = (_f = options.kongTCP) !== null && _f !== void 0 ? _f : false;
        if (this.kongTCP) {
            new k8s.KubeClusterRole(this, 'external-dns-cluster-role', {
                metadata: {
                    name: 'external-dns',
                },
                rules: [
                    {
                        apiGroups: [
                            '',
                        ],
                        resources: [
                            'services',
                            'endpoints',
                            'pods',
                        ],
                        verbs: [
                            'get',
                            'watch',
                            'list',
                        ],
                    },
                    {
                        apiGroups: [
                            'extensions',
                            'networking.k8s.io',
                        ],
                        resources: [
                            'ingresses',
                        ],
                        verbs: [
                            'get',
                            'watch',
                            'list',
                        ],
                    },
                    {
                        apiGroups: [
                            '',
                        ],
                        resources: [
                            'nodes',
                        ],
                        verbs: [
                            'list',
                            'watch',
                        ],
                    },
                    {
                        apiGroups: [
                            'configuration.konghq.com',
                        ],
                        resources: [
                            'tcpingresses',
                        ],
                        verbs: [
                            'get',
                            'watch',
                            'list',
                        ],
                    },
                ],
            });
        }
        else {
            new k8s.KubeClusterRole(this, 'external-dns-cluster-role', {
                metadata: {
                    name: 'external-dns',
                },
                rules: [
                    {
                        apiGroups: [
                            '',
                        ],
                        resources: [
                            'services',
                            'endpoints',
                            'pods',
                        ],
                        verbs: [
                            'get',
                            'watch',
                            'list',
                        ],
                    },
                    {
                        apiGroups: [
                            'extensions',
                            'networking.k8s.io',
                        ],
                        resources: [
                            'ingresses',
                        ],
                        verbs: [
                            'get',
                            'watch',
                            'list',
                        ],
                    },
                    {
                        apiGroups: [
                            '',
                        ],
                        resources: [
                            'nodes',
                        ],
                        verbs: [
                            'list',
                            'watch',
                        ],
                    },
                ],
            });
        }
        new k8s.KubeClusterRoleBinding(this, 'external-dns-cluster-role-binding', {
            metadata: {
                name: 'external-dns-viewer',
            },
            roleRef: {
                apiGroup: 'rbac.authorization.k8s.io',
                kind: 'ClusterRole',
                name: 'external-dns',
            },
            subjects: [
                {
                    kind: 'ServiceAccount',
                    name: this.serviceAccountName,
                    namespace: this.namespace,
                },
            ],
        });
        new k8s.KubeDeployment(this, 'external-dns-deploy', {
            metadata: {
                name: this.deploymentName,
                namespace: this.namespace,
            },
            spec: {
                strategy: {
                    type: 'Recreate',
                },
                selector: {
                    matchLabels: {
                        app: this.deploymentName,
                    },
                },
                template: {
                    metadata: {
                        labels: {
                            app: this.deploymentName,
                        },
                    },
                    spec: {
                        serviceAccountName: this.serviceAccountName,
                        containers: [
                            {
                                name: this.deploymentName,
                                image: this.image,
                                args: this.argsFunc(options.args),
                            },
                        ],
                        securityContext: {
                            fsGroup: 65534,
                        },
                        nodeSelector: this.nodeSelector,
                    },
                },
            },
        });
    }
    argsFunc(args) {
        const defaultArgs = ['--source=service', '--source=ingress', '--provider=aws', '--registry=txt'];
        if (args) {
            args.forEach(e => defaultArgs.push(e));
        }
        if (this.kongTCP) {
            defaultArgs.push('--source=kong-tcpingress');
        }
        return defaultArgs;
    }
}
exports.AwsExternalDns = AwsExternalDns;
_a = JSII_RTTI_SYMBOL_1;
AwsExternalDns[_a] = { fqn: "@opencdk8s/cdk8s-external-dns-route53.AwsExternalDns", version: "0.1.4" };
//# sourceMappingURL=data:application/json;base64,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