use pyo3::prelude::*;

#[macro_use]
mod macros;
mod base;
mod geometric;

#[pymodule]
fn oxmpl_py(py: Python<'_>, m: &Bound<'_, PyModule>) -> PyResult<()> {

    let base_module = base::create_module(py)?;
    m.add_submodule(&base_module)?;
    let geometric_module = geometric::create_module(py)?;
    m.add_submodule(&geometric_module)?;
    m.add("__version__", env!("CARGO_PKG_VERSION"))?;
    m.add("__doc__", "A Rust-powered motion planning library for Python, inspired by OMPL.")?;

    Ok(())
}
