from .allocators import Allocator

ALLOCATOR_BUS_START_INDEX = 32
ALLOCATOR_BUS_CAPACITY = 1024

CONTROL_BUS_ALLOCATOR = Allocator("control")
AUDIO_BUS_ALLOCATOR = Allocator("audio")

LAST_NODE_ID = 1000
LAST_BUFFER_ID = 0
RESPONSE_TIMEOUT = 0.25

ADD_TO_HEAD = 0
ADD_TO_TAIL = 1
ADD_AFTER = 2
ADD_BEFORE = 3
ADD_REPLACE = 4

HEADER_FORMAT_WAV = "wav"
HEADER_FORMAT_AIFF = "aiff"
HEADER_FORMAT_RAW = "raw"
HEADER_FORMAT_IRCAM = "ircam"
HEADER_FORMAT_NEXT = "next"

SAMPLE_FORMAT_INT8 = "int8"
SAMPLE_FORMAT_INT16 = "int16"
SAMPLE_FORMAT_INT24 = "int24"
SAMPLE_FORMAT_INT32 = "int32"
SAMPLE_FORMAT_FLOAT = "float"
SAMPLE_FORMAT_DOUBLE = "double"
SAMPLE_FORMAT_MULAW = "mulaw"
SAMPLE_FORMAT_ALAW = "alaw"
