/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.xform.parse;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.javarosa.core.model.DataBinding;
import org.javarosa.core.model.FormDef;
import org.javarosa.core.model.GroupDef;
import org.javarosa.core.model.IDataReference;
import org.javarosa.core.model.IFormElement;
import org.javarosa.core.model.ItemsetBinding;
import org.javarosa.core.model.QuestionDef;
import org.javarosa.core.model.condition.Constraint;
import org.javarosa.core.model.condition.EvaluationContext;
import org.javarosa.core.model.instance.DataInstance;
import org.javarosa.core.model.instance.FormInstance;
import org.javarosa.core.model.instance.InvalidReferenceException;
import org.javarosa.core.model.instance.TreeElement;
import org.javarosa.core.model.instance.TreeReference;
import org.javarosa.xform.parse.XFormParseException;
import org.javarosa.xform.parse.XFormParser;
import org.javarosa.xform.util.XFormUtils;
import org.kxml2.kdom.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FormInstanceParser {
    private static final Logger logger = LoggerFactory.getLogger(FormInstanceParser.class);
    private final FormDef formDef;
    private final String defaultNamespace;
    private final List<DataBinding> bindings;
    private final List<TreeReference> repeats;
    private final List<ItemsetBinding> itemsets;
    private final List<TreeReference> selectOnes;
    private final List<TreeReference> selectMultis;
    private final List<TreeReference> actionTargets;
    private FormInstance repeatTree;

    FormInstanceParser(FormDef formDef, String defaultNamespace, List<DataBinding> bindings, List<TreeReference> repeats, List<ItemsetBinding> itemsets, List<TreeReference> selectOnes, List<TreeReference> selectMultis, List<TreeReference> actionTargets) {
        this.formDef = formDef;
        this.defaultNamespace = defaultNamespace;
        this.bindings = bindings;
        this.repeats = repeats;
        this.itemsets = itemsets;
        this.selectOnes = selectOnes;
        this.selectMultis = selectMultis;
        this.actionTargets = actionTargets;
    }

    FormInstance parseInstance(Element e, boolean isMainInstance, String name, Map<String, String> namespacePrefixesByUri) {
        TreeElement root = XFormParser.buildInstanceStructure(e, null, !isMainInstance ? name : null, e.getNamespace(), namespacePrefixesByUri, null);
        FormInstance instanceModel = new FormInstance(root);
        instanceModel.setName(isMainInstance ? this.formDef.getTitle() : name);
        List<String> usedAtts = Collections.unmodifiableList(Arrays.asList("id", "version", "uiVersion", "name", "prefix", "delimiter"));
        String schema = e.getNamespace();
        if (schema != null && schema.length() > 0 && !schema.equals(this.defaultNamespace)) {
            instanceModel.schema = schema;
        }
        instanceModel.formVersion = e.getAttributeValue(null, "version");
        instanceModel.uiVersion = e.getAttributeValue(null, "uiVersion");
        XFormParser.loadNamespaces(e, instanceModel);
        if (isMainInstance) {
            FormDef.updateItemsetReferences(this.formDef.getChildren());
            this.processRepeats(instanceModel);
            this.verifyBindings(instanceModel, e.getName());
            this.verifyActions(instanceModel);
        }
        this.applyInstanceProperties(instanceModel);
        if (XFormUtils.showUnusedAttributeWarning(e, usedAtts)) {
            String xmlLocation = XFormParser.getVagueLocation(e);
            logger.warn("XForm Parse Warning: {}{}", (Object)XFormUtils.unusedAttWarning(e, usedAtts), (Object)xmlLocation);
        }
        return instanceModel;
    }

    private void processRepeats(FormInstance instance) {
        this.flagRepeatables(instance);
        this.processTemplates(instance);
        FormInstanceParser.checkDuplicateNodesAreRepeatable(instance.getRoot());
        this.checkHomogeneity(instance);
    }

    private void flagRepeatables(FormInstance instance) {
        for (TreeReference ref : this.getRepeatableRefs()) {
            for (TreeReference nref : new EvaluationContext(instance).expandReference(ref, true)) {
                TreeElement node = (TreeElement)instance.resolveReference(nref);
                if (node == null) continue;
                node.setRepeatable(true);
            }
        }
    }

    private void processTemplates(FormInstance instance) {
        this.repeatTree = FormInstanceParser.buildRepeatTree(this.getRepeatableRefs(), instance.getRoot().getName());
        ArrayList<TreeReference> missingTemplates = new ArrayList<TreeReference>();
        FormInstanceParser.checkRepeatsForTemplate(instance, this.repeatTree, missingTemplates);
        this.removeInvalidTemplates(instance, this.repeatTree);
        this.createMissingTemplates(instance, missingTemplates);
    }

    private void verifyBindings(FormInstance instance, String mainInstanceNodeName) {
        for (int i = 0; i < this.bindings.size(); ++i) {
            DataBinding bind = this.bindings.get(i);
            TreeReference ref = FormInstance.unpackReference(bind.getReference());
            if (ref.size() == 0) {
                logger.info("Cannot bind to '/'; ignoring bind...");
                this.bindings.remove(i);
                --i;
                continue;
            }
            List<TreeReference> nodes = new EvaluationContext(instance).expandReference(ref, true);
            if (nodes.size() != 0) continue;
            logger.warn("XForm Parse Warning: <bind> defined for a node that doesn't exist [{}]. The node's name was probably changed and the bind should be updated.", (Object)ref.toString());
        }
        for (TreeReference ref : this.getRepeatableRefs()) {
            if (ref.size() > 1) continue;
            throw new XFormParseException("Cannot bind repeat to '/' or '/" + mainInstanceNodeName + "'");
        }
        ArrayList<String> bindErrors = new ArrayList<String>();
        this.verifyControlBindings(this.formDef, instance, bindErrors);
        if (bindErrors.size() > 0) {
            StringBuilder errorMsg = new StringBuilder();
            for (String bindError : bindErrors) {
                errorMsg.append(bindError).append("\n");
            }
            throw new XFormParseException(errorMsg.toString());
        }
        this.verifyRepeatMemberBindings(this.formDef, null);
        this.verifyItemsetBindings(instance);
        this.verifyItemsetSrcDstCompatibility(instance);
    }

    private void verifyActions(FormInstance instance) {
        for (TreeReference target : this.actionTargets) {
            List<TreeReference> nodes = new EvaluationContext(instance).expandReference(target, true);
            if (nodes.size() != 0) continue;
            throw new XFormParseException("Invalid Action - Targets non-existent node: " + target.toString(true));
        }
    }

    private static void checkDuplicateNodesAreRepeatable(TreeElement node) {
        int mult = node.getMult();
        if (mult > 0 && !node.isRepeatable()) {
            logger.warn("repeated nodes [{}] detected that have no repeat binding in the form; DO NOT bind questions to these nodes or their children!", (Object)node.getName());
        }
        for (int i = 0; i < node.getNumChildren(); ++i) {
            FormInstanceParser.checkDuplicateNodesAreRepeatable(node.getChildAt(i));
        }
    }

    private void checkHomogeneity(FormInstance instance) {
        for (TreeReference ref : this.getRepeatableRefs()) {
            TreeElement template = null;
            for (TreeReference nref : new EvaluationContext(instance).expandReference(ref)) {
                TreeElement node = (TreeElement)instance.resolveReference(nref);
                if (node == null) continue;
                if (template == null) {
                    template = (TreeElement)instance.getTemplate(nref);
                }
                if (FormInstance.isHomogeneous(template, node)) continue;
                logger.warn("XForm Parse Warning: Not all repeated nodes for a given repeat binding [{}] are homogeneous! This will cause serious problems!", (Object)nref.toString());
            }
        }
    }

    private void verifyControlBindings(IFormElement fe, FormInstance instance, List<String> errors) {
        if (fe.getChildren() == null) {
            return;
        }
        for (int i = 0; i < fe.getChildren().size(); ++i) {
            IFormElement child = fe.getChildren().get(i);
            IDataReference ref = null;
            String type = null;
            if (child instanceof GroupDef) {
                ref = child.getBind();
                type = ((GroupDef)child).getRepeat() ? "Repeat" : "Group";
            } else if (child instanceof QuestionDef) {
                ref = child.getBind();
                type = "Question";
            }
            TreeReference tref = FormInstance.unpackReference(ref);
            if (child instanceof QuestionDef && tref.size() == 0) {
                logger.warn("XForm Parse Warning: Cannot bind control to '/'");
            } else {
                List<TreeReference> nodes = new EvaluationContext(instance).expandReference(tref, true);
                if (nodes.size() == 0) {
                    logger.error("XForm Parse Error: {} bound to non-existent node: [{}]", (Object)type, (Object)tref.toString());
                    errors.add(type + " bound to non-existent node: [" + tref.toString() + "]");
                }
            }
            this.verifyControlBindings(child, instance, errors);
        }
    }

    private void verifyRepeatMemberBindings(IFormElement fe, GroupDef parentRepeat) {
        if (fe.getChildren() == null) {
            return;
        }
        for (int i = 0; i < fe.getChildren().size(); ++i) {
            TreeElement repeatNode;
            TreeReference childBind;
            IFormElement child = fe.getChildren().get(i);
            boolean isRepeat = child instanceof GroupDef && ((GroupDef)child).getRepeat();
            TreeReference repeatBind = parentRepeat == null ? TreeReference.rootRef() : FormInstance.unpackReference(parentRepeat.getBind());
            if (!repeatBind.isAncestorOf(childBind = FormInstance.unpackReference(child.getBind()), false)) {
                throw new XFormParseException("<repeat> member's binding [" + childBind.toString() + "] is not a descendant of <repeat> binding [" + repeatBind.toString() + "]!");
            }
            if (repeatBind.equals(childBind) && isRepeat) {
                throw new XFormParseException("child <repeat>s [" + childBind.toString() + "] cannot bind to the same node as their parent <repeat>; only questions/groups can");
            }
            ArrayList<TreeElement> repeatAncestry = new ArrayList<TreeElement>();
            TreeElement treeElement = repeatNode = this.repeatTree == null ? null : this.repeatTree.getRoot();
            if (repeatNode != null) {
                repeatAncestry.add(repeatNode);
                for (int j = 1; j < childBind.size() && (repeatNode = repeatNode.getChild(childBind.getName(j), 0)) != null; ++j) {
                    repeatAncestry.add(repeatNode);
                }
            }
            for (int k = repeatBind.size(); k < childBind.size(); ++k) {
                boolean repeatable;
                TreeElement rChild = k < repeatAncestry.size() ? (TreeElement)repeatAncestry.get(k) : null;
                boolean bl = repeatable = rChild != null && rChild.isRepeatable();
                if (!repeatable || k == childBind.size() - 1 && isRepeat) continue;
                throw new XFormParseException("<repeat> member's binding [" + childBind.toString() + "] is within the scope of a <repeat> that is not its closest containing <repeat>!");
            }
            this.verifyRepeatMemberBindings(child, isRepeat ? (GroupDef)child : parentRepeat);
        }
    }

    private void verifyItemsetBindings(FormInstance instance) {
        for (ItemsetBinding itemset : this.itemsets) {
            if (!itemset.nodesetRef.isAncestorOf(itemset.labelRef, false)) {
                throw new XFormParseException("itemset nodeset ref is not a parent of label ref");
            }
            if (itemset.copyRef != null && !itemset.nodesetRef.isAncestorOf(itemset.copyRef, false)) {
                throw new XFormParseException("itemset nodeset ref is not a parent of copy ref");
            }
            if (itemset.valueRef != null && !itemset.nodesetRef.isAncestorOf(itemset.valueRef, false)) {
                throw new XFormParseException("itemset nodeset ref is not a parent of value ref");
            }
            if (itemset.copyRef != null && itemset.valueRef != null && !itemset.copyRef.isAncestorOf(itemset.valueRef, false)) {
                throw new XFormParseException("itemset <copy> is not a parent of <value>");
            }
            DataInstance fi = null;
            if (itemset.labelRef.getInstanceName() != null) {
                fi = this.formDef.getNonMainInstance(itemset.labelRef.getInstanceName());
                if (fi == null) {
                    throw new XFormParseException("Instance: " + itemset.labelRef.getInstanceName() + " Does not exists");
                }
            } else {
                fi = instance;
            }
            if (fi.getTemplatePath(itemset.labelRef) == null) {
                throw new XFormParseException("<label> node for itemset doesn't exist! [" + itemset.labelRef + "]");
            }
            if (itemset.valueRef == null || fi.getTemplatePath(itemset.valueRef) != null) continue;
            throw new XFormParseException("<value> node for itemset doesn't exist! [" + itemset.valueRef + "]");
        }
    }

    private void verifyItemsetSrcDstCompatibility(FormInstance instance) {
        for (ItemsetBinding itemset : this.itemsets) {
            boolean destRepeatable;
            boolean bl = destRepeatable = instance.getTemplate(itemset.getDestRef()) != null;
            if (itemset.copyMode) {
                TreeElement dstNode;
                if (!destRepeatable) {
                    throw new XFormParseException("itemset copies to node(s) which are not repeatable");
                }
                TreeElement srcNode = (TreeElement)instance.getTemplatePath(itemset.copyRef);
                if (FormInstance.isHomogeneous(srcNode, dstNode = (TreeElement)instance.getTemplate(itemset.getDestRef()))) continue;
                logger.warn("XForm Parse Warning: Your itemset source [{}] and dest [{}] of appear to be incompatible!", (Object)srcNode.getRef().toString(), (Object)dstNode.getRef().toString());
                continue;
            }
            if (!destRepeatable) continue;
            throw new XFormParseException("itemset sets value on repeatable nodes");
        }
    }

    private void applyInstanceProperties(FormInstance instance) {
        for (DataBinding bind : this.bindings) {
            TreeReference ref = FormInstance.unpackReference(bind.getReference());
            EvaluationContext ec = new EvaluationContext(instance);
            List<TreeReference> nodeRefs = ec.expandReference(ref, true);
            if (bind.relevancyCondition != null) {
                bind.relevancyCondition.addTarget(ref);
            }
            if (bind.requiredCondition != null) {
                bind.requiredCondition.addTarget(ref);
            }
            if (bind.readonlyCondition != null) {
                bind.readonlyCondition.addTarget(ref);
            }
            if (bind.calculate != null) {
                bind.calculate.addTarget(ref);
            }
            for (TreeReference nodeRef : nodeRefs) {
                TreeElement node = (TreeElement)instance.resolveReference(nodeRef);
                node.setDataType(bind.getDataType());
                if (bind.relevancyCondition == null) {
                    node.setRelevant(bind.relevantAbsolute);
                }
                if (bind.requiredCondition == null) {
                    node.setRequired(bind.requiredAbsolute);
                }
                if (bind.readonlyCondition == null) {
                    node.setEnabled(!bind.readonlyAbsolute);
                }
                if (bind.constraint != null) {
                    node.setConstraint(new Constraint(bind.constraint, bind.constraintMessage));
                }
                node.setPreloadHandler(bind.getPreload());
                node.setPreloadParams(bind.getPreloadParams());
                node.setBindAttributes(bind.getAdditionalAttributes());
            }
        }
        this.applyControlProperties(instance);
    }

    private static void checkRepeatsForTemplate(FormInstance instance, FormInstance repeatTree, List<TreeReference> missingTemplates) {
        if (repeatTree != null) {
            FormInstanceParser.checkRepeatsForTemplate(repeatTree.getRoot(), TreeReference.rootRef(), instance, missingTemplates);
        }
    }

    private static void checkRepeatsForTemplate(TreeElement repeatTreeNode, TreeReference ref, FormInstance instance, List<TreeReference> missing) {
        TreeElement template;
        String name = repeatTreeNode.getName();
        int mult = repeatTreeNode.isRepeatable() ? -2 : 0;
        ref = ref.extendRef(name, mult);
        if (repeatTreeNode.isRepeatable() && (template = (TreeElement)instance.resolveReference(ref)) == null) {
            missing.add(ref);
        }
        for (int i = 0; i < repeatTreeNode.getNumChildren(); ++i) {
            FormInstanceParser.checkRepeatsForTemplate(repeatTreeNode.getChildAt(i), ref, instance, missing);
        }
    }

    private void removeInvalidTemplates(FormInstance instance, FormInstance repeatTree) {
        this.removeInvalidTemplates(instance.getRoot(), repeatTree == null ? null : repeatTree.getRoot(), true);
    }

    private boolean removeInvalidTemplates(TreeElement instanceNode, TreeElement repeatTreeNode, boolean templateAllowed) {
        boolean repeatable;
        int mult = instanceNode.getMult();
        boolean bl = repeatable = repeatTreeNode != null && repeatTreeNode.isRepeatable();
        if (mult == -2) {
            if (!templateAllowed) {
                logger.warn("XForm Parse Warning: Template nodes for sub-repeats must be located within the template node of the parent repeat; ignoring template... [{}]", (Object)instanceNode.getName());
                return true;
            }
            if (!repeatable) {
                logger.warn("XForm Parse Warning: Warning: template node found for ref that is not repeatable; ignoring... [{}]" + instanceNode.getName());
                return true;
            }
        }
        if (repeatable && mult != -2) {
            templateAllowed = false;
        }
        for (int i = 0; i < instanceNode.getNumChildren(); ++i) {
            TreeElement rchild;
            TreeElement child = instanceNode.getChildAt(i);
            TreeElement treeElement = rchild = repeatTreeNode == null ? null : repeatTreeNode.getChild(child.getName(), 0);
            if (!this.removeInvalidTemplates(child, rchild, templateAllowed)) continue;
            instanceNode.removeChildAt(i);
            --i;
        }
        return false;
    }

    private void createMissingTemplates(FormInstance instance, List<TreeReference> missingTemplates) {
        for (TreeReference templRef : missingTemplates) {
            TreeReference ref = templRef.clone();
            for (int j = 0; j < ref.size(); ++j) {
                ref.setMultiplicity(j, -1);
            }
            List<TreeReference> nodes = new EvaluationContext(instance).expandReference(ref);
            if (nodes.size() == 0) continue;
            TreeReference firstMatch = nodes.get(0);
            try {
                instance.copyNode(firstMatch, templRef);
            }
            catch (InvalidReferenceException e) {
                logger.warn("XForm Parse Warning: Could not create a default repeat template; this is almost certainly a homogeneity error! Your form will not work! (Failed on {})", (Object)templRef.toString());
            }
            FormInstanceParser.trimRepeatChildren((TreeElement)instance.resolveReference(templRef));
        }
    }

    private static void trimRepeatChildren(TreeElement node) {
        for (int i = 0; i < node.getNumChildren(); ++i) {
            TreeElement child = node.getChildAt(i);
            if (child.isRepeatable()) {
                node.removeChildAt(i);
                --i;
                continue;
            }
            FormInstanceParser.trimRepeatChildren(child);
        }
    }

    private void applyControlProperties(FormInstance instance) {
        for (int h = 0; h < 2; ++h) {
            int type = h == 0 ? 7 : 8;
            for (TreeReference ref : h == 0 ? this.selectOnes : this.selectMultis) {
                for (TreeReference treeRef : new EvaluationContext(instance).expandReference(ref, true)) {
                    TreeElement node = (TreeElement)instance.resolveReference(treeRef);
                    if (node.getDataType() == 7 || node.getDataType() == 8) continue;
                    if (node.getDataType() == 0 || node.getDataType() == 1) {
                        node.setDataType(type);
                        continue;
                    }
                    logger.warn("XForm Parse Warning: Select question {} appears to have data type that is incompatible with selection", (Object)ref.toString());
                }
            }
        }
    }

    private List<TreeReference> getRepeatableRefs() {
        ArrayList<TreeReference> refs = new ArrayList<TreeReference>(this.repeats);
        for (ItemsetBinding itemset : this.itemsets) {
            TreeReference destRef;
            TreeReference srcRef = itemset.nodesetRef;
            if (!refs.contains(srcRef)) {
                boolean nonstatic = true;
                for (int j = 0; j < srcRef.size(); ++j) {
                    if (!"*".equals(srcRef.getName(j))) continue;
                    nonstatic = false;
                }
                if (srcRef.getInstanceName() != null) {
                    nonstatic = false;
                }
                if (nonstatic) {
                    refs.add(srcRef);
                }
            }
            if (!itemset.copyMode || refs.contains(destRef = itemset.getDestRef())) continue;
            refs.add(destRef);
        }
        return refs;
    }

    private static FormInstance buildRepeatTree(List<TreeReference> repeatRefs, String topLevelName) {
        TreeElement root = new TreeElement(null, 0);
        for (TreeReference repeatRef : repeatRefs) {
            if (repeatRef.getInstanceName() != null || repeatRef.size() <= 1) continue;
            TreeElement cur = root;
            for (int j = 0; j < repeatRef.size(); ++j) {
                String name = repeatRef.getName(j);
                TreeElement child = cur.getChild(name, 0);
                if (child == null) {
                    child = new TreeElement(name, 0);
                    cur.addChild(child);
                }
                cur = child;
            }
            cur.setRepeatable(true);
        }
        return root.getNumChildren() == 0 ? null : new FormInstance(root.getChild(topLevelName, 0));
    }
}

