/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.model.xform;

import java.io.IOException;
import java.io.OutputStream;
import org.javarosa.core.model.instance.AbstractTreeElement;
import org.javarosa.core.model.instance.DataInstance;
import org.javarosa.core.model.instance.InstanceInitializationFactory;
import org.javarosa.core.model.instance.TreeReference;
import org.kxml2.io.KXmlSerializer;

public class DataModelSerializer {
    KXmlSerializer serializer;
    InstanceInitializationFactory factory;

    public DataModelSerializer(OutputStream stream) throws IOException {
        this(stream, new InstanceInitializationFactory());
    }

    public DataModelSerializer(OutputStream stream, InstanceInitializationFactory factory) throws IOException {
        this.serializer = new KXmlSerializer();
        this.serializer.setOutput(stream, "UTF-8");
        this.factory = factory;
    }

    public DataModelSerializer(KXmlSerializer serializer) {
        this.serializer = serializer;
    }

    public void serialize(DataInstance instance, TreeReference base) throws IOException {
        Object root = base == null ? instance.getRoot() : instance.resolveReference(base);
        this.serializer.startTag(root.getNamespace(), root.getName());
        for (int i = 0; i < root.getNumChildren(); ++i) {
            Object childAt = root.getChildAt(i);
            this.serializeNode((AbstractTreeElement)childAt);
        }
        this.serializer.endTag(root.getNamespace(), root.getName());
        this.serializer.flush();
    }

    public void serializeNode(AbstractTreeElement instanceNode) throws IOException {
        int i;
        if (!instanceNode.isRelevant() || instanceNode.getMult() == -2) {
            return;
        }
        this.serializer.startTag(instanceNode.getNamespace(), instanceNode.getName());
        for (i = 0; i < instanceNode.getAttributeCount(); ++i) {
            String val = instanceNode.getAttributeValue(i);
            val = val == null ? "" : val;
            this.serializer.attribute(instanceNode.getAttributeNamespace(i), instanceNode.getAttributeName(i), val);
        }
        if (instanceNode.getValue() != null) {
            this.serializer.text(instanceNode.getValue().uncast().getString());
        } else {
            for (i = 0; i < instanceNode.getNumChildren(); ++i) {
                this.serializeNode((AbstractTreeElement)instanceNode.getChildAt(i));
            }
        }
        this.serializer.endTag(instanceNode.getNamespace(), instanceNode.getName());
    }
}

