/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.util.externalizable;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.ExtWrapIntEncoding;
import org.javarosa.core.util.externalizable.ExternalizableWrapper;
import org.javarosa.core.util.externalizable.PrototypeFactory;

public class ExtWrapIntEncodingUniform
extends ExtWrapIntEncoding {
    public ExtWrapIntEncodingUniform(long l) {
        this.val = new Long(l);
    }

    public ExtWrapIntEncodingUniform() {
    }

    @Override
    public ExternalizableWrapper clone(Object val) {
        return new ExtWrapIntEncodingUniform(ExtUtil.toLong(val));
    }

    @Override
    public void readExternal(DataInputStream in, PrototypeFactory pf) throws IOException {
        byte b;
        long l = 0L;
        boolean firstByte = true;
        do {
            b = in.readByte();
            if (firstByte) {
                firstByte = false;
                l = (b >> 6 & 1) == 0 ? 0 : -1;
            }
            l = l << 7 | (long)(b & 0x7F);
        } while ((b >> 7 & 1) == 1);
        this.val = new Long(l);
    }

    @Override
    public void writeExternal(DataOutputStream out) throws IOException {
        long k;
        long l = (Long)this.val;
        int sig = -1;
        while ((k = l >> ++sig * 7) < -64L || k > 63L) {
        }
        for (int i = sig; i >= 0; --i) {
            byte chunk = (byte)(l >> i * 7 & 0x7FL);
            out.writeByte((i > 0 ? 128 : 0) | chunk);
        }
    }

    @Override
    public void metaReadExternal(DataInputStream in, PrototypeFactory pf) {
    }

    @Override
    public void metaWriteExternal(DataOutputStream out) {
    }
}

