/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model.actions;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.javarosa.core.model.FormDef;
import org.javarosa.core.model.GroupDef;
import org.javarosa.core.model.IFormElement;
import org.javarosa.core.model.actions.Action;
import org.javarosa.core.model.condition.EvaluationContext;
import org.javarosa.core.model.instance.TreeReference;
import org.javarosa.core.util.externalizable.DeserializationException;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.ExtWrapListPoly;
import org.javarosa.core.util.externalizable.ExtWrapMap;
import org.javarosa.core.util.externalizable.Externalizable;
import org.javarosa.core.util.externalizable.ExternalizableWrapper;
import org.javarosa.core.util.externalizable.PrototypeFactory;
import org.javarosa.xform.parse.XFormParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionController
implements Externalizable {
    private static final Logger log = LoggerFactory.getLogger(ActionController.class);
    private HashMap<String, List<Action>> eventListeners = new HashMap();

    public List<Action> getListenersForEvent(String event) {
        if (this.eventListeners.containsKey(event)) {
            return this.eventListeners.get(event);
        }
        return new ArrayList<Action>();
    }

    public void registerEventListener(String event, Action action) {
        this.registerEventListener(XFormParser.getValidEventNames(event), action);
    }

    public void registerEventListener(List<String> eventList, Action action) {
        for (String event : eventList) {
            List<Object> actions;
            if (this.eventListeners.containsKey(event)) {
                actions = this.eventListeners.get(event);
            } else {
                actions = new ArrayList();
                this.eventListeners.put(event, actions);
            }
            actions.add(action);
        }
    }

    public void triggerActionsFromEvent(String event, Set<IFormElement> nestedElements, FormDef model) {
        this.triggerActionsFromEvent(event, model, null, null);
        for (IFormElement element : nestedElements) {
            TreeReference elementReference = (TreeReference)element.getBind().getReference();
            TreeReference unqualifiedContext = element instanceof GroupDef ? elementReference : elementReference.getParentRef();
            EvaluationContext context = new EvaluationContext(model.getEvaluationContext(), unqualifiedContext);
            List<TreeReference> allContextRefs = context.expandReference(unqualifiedContext);
            for (TreeReference contextRef : allContextRefs) {
                element.getActionController().triggerActionsFromEvent(event, model, contextRef, null);
            }
        }
    }

    public void triggerActionsFromEvent(String event, FormDef model, TreeReference contextForAction, ActionResultProcessor resultProcessor) {
        for (Action action : this.getListenersForEvent(event)) {
            log.info("Event {} triggering action {} in context {}", event, action.getName(), contextForAction);
            TreeReference refSetByAction = action.processAction(model, contextForAction);
            if (resultProcessor == null || refSetByAction == null) continue;
            resultProcessor.processResultOfAction(refSetByAction, event);
        }
    }

    @Override
    public void readExternal(DataInputStream inStream, PrototypeFactory pf) throws IOException, DeserializationException {
        this.eventListeners = (HashMap)ExtUtil.read(inStream, new ExtWrapMap(String.class, (ExternalizableWrapper)new ExtWrapListPoly()), pf);
    }

    @Override
    public void writeExternal(DataOutputStream outStream) throws IOException {
        ExtUtil.write(outStream, new ExtWrapMap(this.eventListeners, (ExternalizableWrapper)new ExtWrapListPoly()));
    }

    public static interface ActionResultProcessor {
        public void processResultOfAction(TreeReference var1, String var2);
    }
}

