"""
[![PiPy Version](https://badge.fury.io/py/labml-nn.svg)](https://badge.fury.io/py/labml-nn)
[![PiPy Downloads](https://pepy.tech/badge/labml-nn)](https://pepy.tech/project/labml-nn)

# [LabML Neural Networks](http://lab-ml.com/labml_nn/index.html)

This is a collection of simple PyTorch implementation of various
neural network architectures and layers.
We will keep adding to this.

## Modules

#### ✨ [Transformers](http://lab-ml.com/labml_nn/transformers)

[Transformers module](http://lab-ml.com/labml_nn/transformers)
contains implementations for
[multi-headed attention](http://lab-ml.com/labml_nn/transformers/mha.html)
and
[relative multi-headed attention](http://lab-ml.com/labml_nn/transformers/relative_mha.html>).

#### ✨ [Recurrent Highway Networks](http://lab-ml.com/labml_nn/recurrent_highway_networks)

#### ✨ [LSTM](http://lab-ml.com/labml_nn/lstm)

#### ✨ [Capsule Networks](http://lab-ml.com/labml_nn/capsule_networks/)

#### ✨ [Generative Adversarial Networks](http://lab-ml.com/labml_nn/gan/)
* [GAN with a multi-layer perceptron](http://lab-ml.com/labml_nn/gan/simple_mnist_experiment.html)
* [GAN with deep convolutional network](http://lab-ml.com/labml_nn/gan/dcgan.html)
* [Cycle GAN](http://lab-ml.com/labml_nn/gan/cycle_gan.html)

#### ✨ [Sketch RNN](http://lab-ml.com/labml_nn/sketch_rnn/)

#### ✨ [Reinforcement Learning](http://lab-ml.com/labml_nn/rl/)
* [Proximal Policy Optimization](http://lab-ml.com/labml_nn/rl/ppo/) with
 [Generalized Advantage Estimation](http://lab-ml.com/labml_nn/rl/ppo/gae.html)

### Installation

```bash
pip install labml_nn
```

### Citing LabML

If you use LabML for academic research, please cite the library using the following BibTeX entry.

```bibtex
@misc{labml,
 author = {Varuna Jayasiri, Nipun Wijerathne},
 title = {LabML: A library to organize machine learning experiments},
 year = {2020},
 url = {https://lab-ml.com/},
}
```
"""
