/**
 * Protocol for use in Connection Rules.
 *
 * https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml
 *
 * @stability stable
 */
export declare enum Protocol {
    /**
     * @stability stable
     */
    ALL = "-1",
    /**
     * @stability stable
     */
    HOPOPT = "0",
    /**
     * @stability stable
     */
    ICMP = "icmp",
    /**
     * @stability stable
     */
    IGMP = "2",
    /**
     * @stability stable
     */
    GGP = "3",
    /**
     * @stability stable
     */
    IPV4 = "4",
    /**
     * @stability stable
     */
    ST = "5",
    /**
     * @stability stable
     */
    TCP = "tcp",
    /**
     * @stability stable
     */
    CBT = "7",
    /**
     * @stability stable
     */
    EGP = "8",
    /**
     * @stability stable
     */
    IGP = "9",
    /**
     * @stability stable
     */
    BBN_RCC_MON = "10",
    /**
     * @stability stable
     */
    NVP_II = "11",
    /**
     * @stability stable
     */
    PUP = "12",
    /**
     * @stability stable
     */
    EMCON = "14",
    /**
     * @stability stable
     */
    XNET = "15",
    /**
     * @stability stable
     */
    CHAOS = "16",
    /**
     * @stability stable
     */
    UDP = "udp",
    /**
     * @stability stable
     */
    MUX = "18",
    /**
     * @stability stable
     */
    DCN_MEAS = "19",
    /**
     * @stability stable
     */
    HMP = "20",
    /**
     * @stability stable
     */
    PRM = "21",
    /**
     * @stability stable
     */
    XNS_IDP = "22",
    /**
     * @stability stable
     */
    TRUNK_1 = "23",
    /**
     * @stability stable
     */
    TRUNK_2 = "24",
    /**
     * @stability stable
     */
    LEAF_1 = "25",
    /**
     * @stability stable
     */
    LEAF_2 = "26",
    /**
     * @stability stable
     */
    RDP = "27",
    /**
     * @stability stable
     */
    IRTP = "28",
    /**
     * @stability stable
     */
    ISO_TP4 = "29",
    /**
     * @stability stable
     */
    NETBLT = "30",
    /**
     * @stability stable
     */
    MFE_NSP = "31",
    /**
     * @stability stable
     */
    MERIT_INP = "32",
    /**
     * @stability stable
     */
    DCCP = "33",
    /**
     * @stability stable
     */
    THREEPC = "34",
    /**
     * @stability stable
     */
    IDPR = "35",
    /**
     * @stability stable
     */
    XTP = "36",
    /**
     * @stability stable
     */
    DDP = "37",
    /**
     * @stability stable
     */
    IDPR_CMTP = "38",
    /**
     * @stability stable
     */
    TPPLUSPLUS = "39",
    /**
     * @stability stable
     */
    IL = "40",
    /**
     * @stability stable
     */
    IPV6 = "41",
    /**
     * @stability stable
     */
    SDRP = "42",
    /**
     * @stability stable
     */
    IPV6_ROUTE = "43",
    /**
     * @stability stable
     */
    IPV6_FRAG = "44",
    /**
     * @stability stable
     */
    IDRP = "45",
    /**
     * @stability stable
     */
    RSVP = "46",
    /**
     * @stability stable
     */
    GRE = "47",
    /**
     * @stability stable
     */
    DSR = "48",
    /**
     * @stability stable
     */
    BNA = "49",
    /**
     * @stability stable
     */
    ESP = "50",
    /**
     * @stability stable
     */
    AH = "51",
    /**
     * @stability stable
     */
    I_NLSP = "52",
    /**
     * @stability stable
     */
    SWIPE = "53",
    /**
     * @stability stable
     */
    NARP = "54",
    /**
     * @stability stable
     */
    MOBILE = "55",
    /**
     * @stability stable
     */
    TLSP = "56",
    /**
     * @stability stable
     */
    SKIP = "57",
    /**
     * @stability stable
     */
    ICMPV6 = "icmpv6",
    /**
     * @stability stable
     */
    IPV6_NONXT = "59",
    /**
     * @stability stable
     */
    IPV6_OPTS = "60",
    /**
     * @stability stable
     */
    CFTP = "62",
    /**
     * @stability stable
     */
    ANY_LOCAL = "63",
    /**
     * @stability stable
     */
    SAT_EXPAK = "64",
    /**
     * @stability stable
     */
    KRYPTOLAN = "65",
    /**
     * @stability stable
     */
    RVD = "66",
    /**
     * @stability stable
     */
    IPPC = "67",
    /**
     * @stability stable
     */
    ANY_DFS = "68",
    /**
     * @stability stable
     */
    SAT_MON = "69",
    /**
     * @stability stable
     */
    VISA = "70",
    /**
     * @stability stable
     */
    IPCV = "71",
    /**
     * @stability stable
     */
    CPNX = "72",
    /**
     * @stability stable
     */
    CPHB = "73",
    /**
     * @stability stable
     */
    WSN = "74",
    /**
     * @stability stable
     */
    PVP = "75",
    /**
     * @stability stable
     */
    BR_SAT_MON = "76",
    /**
     * @stability stable
     */
    SUN_ND = "77",
    /**
     * @stability stable
     */
    WB_MON = "78",
    /**
     * @stability stable
     */
    WB_EXPAK = "79",
    /**
     * @stability stable
     */
    ISO_IP = "80",
    /**
     * @stability stable
     */
    VMTP = "81",
    /**
     * @stability stable
     */
    SECURE_VMTP = "82",
    /**
     * @stability stable
     */
    VINES = "83",
    /**
     * @stability stable
     */
    TTP = "84",
    IPTM = "84",
    /**
     * @stability stable
     */
    NSFNET_IGP = "85",
    /**
     * @stability stable
     */
    DGP = "86",
    /**
     * @stability stable
     */
    TCF = "87",
    /**
     * @stability stable
     */
    EIGRP = "88",
    /**
     * @stability stable
     */
    OSPFIGP = "89",
    /**
     * @stability stable
     */
    SPRITE_RPC = "90",
    /**
     * @stability stable
     */
    LARP = "91",
    /**
     * @stability stable
     */
    MTP = "92",
    /**
     * @stability stable
     */
    AX_25 = "93",
    /**
     * @stability stable
     */
    IPIP = "94",
    /**
     * @stability stable
     */
    MICP = "95",
    /**
     * @stability stable
     */
    SCC_SP = "96",
    /**
     * @stability stable
     */
    ETHERIP = "97",
    /**
     * @stability stable
     */
    ENCAP = "98",
    /**
     * @stability stable
     */
    ANY_ENC = "99",
    /**
     * @stability stable
     */
    GMTP = "100",
    /**
     * @stability stable
     */
    IFMP = "101",
    /**
     * @stability stable
     */
    PNNI = "102",
    /**
     * @stability stable
     */
    PIM = "103",
    /**
     * @stability stable
     */
    ARIS = "104",
    /**
     * @stability stable
     */
    SCPS = "105",
    /**
     * @stability stable
     */
    QNX = "106",
    /**
     * @stability stable
     */
    A_N = "107",
    /**
     * @stability stable
     */
    IPCOMP = "108",
    /**
     * @stability stable
     */
    SNP = "109",
    /**
     * @stability stable
     */
    COMPAQ_PEER = "110",
    /**
     * @stability stable
     */
    IPX_IN_IP = "111",
    /**
     * @stability stable
     */
    VRRP = "112",
    /**
     * @stability stable
     */
    PGM = "113",
    /**
     * @stability stable
     */
    ANY_0_HOP = "114",
    /**
     * @stability stable
     */
    L2_T_P = "115",
    /**
     * @stability stable
     */
    DDX = "116",
    /**
     * @stability stable
     */
    IATP = "117",
    /**
     * @stability stable
     */
    STP = "118",
    /**
     * @stability stable
     */
    SRP = "119",
    /**
     * @stability stable
     */
    UTI = "120",
    /**
     * @stability stable
     */
    SMP = "121",
    /**
     * @stability stable
     */
    SM = "122",
    /**
     * @stability stable
     */
    PTP = "123",
    /**
     * @stability stable
     */
    ISIS_IPV4 = "124",
    /**
     * @stability stable
     */
    FIRE = "125",
    /**
     * @stability stable
     */
    CRTP = "126",
    /**
     * @stability stable
     */
    CRUDP = "127",
    /**
     * @stability stable
     */
    SSCOPMCE = "128",
    /**
     * @stability stable
     */
    IPLT = "129",
    /**
     * @stability stable
     */
    SPS = "130",
    /**
     * @stability stable
     */
    PIPE = "131",
    /**
     * @stability stable
     */
    SCTP = "132",
    /**
     * @stability stable
     */
    FC = "133",
    /**
     * @stability stable
     */
    RSVP_E2E_IGNORE = "134",
    /**
     * @stability stable
     */
    MOBILITY_HEADER = "135",
    /**
     * @stability stable
     */
    UDPLITE = "136",
    /**
     * @stability stable
     */
    MPLS_IN_IP = "137",
    /**
     * @stability stable
     */
    MANET = "138",
    /**
     * @stability stable
     */
    HIP = "139",
    /**
     * @stability stable
     */
    SHIM6 = "140",
    /**
     * @stability stable
     */
    WESP = "141",
    /**
     * @stability stable
     */
    ROHC = "142",
    /**
     * @stability stable
     */
    ETHERNET = "143",
    /**
     * @stability stable
     */
    EXPERIMENT_1 = "253",
    /**
     * @stability stable
     */
    EXPERIMENT_2 = "254",
    /**
     * @stability stable
     */
    RESERVED = "255"
}
/**
 * Properties to create a port range.
 *
 * @stability stable
 */
export interface PortProps {
    /**
     * The protocol for the range.
     *
     * @stability stable
     */
    readonly protocol: Protocol;
    /**
     * The starting port for the range.
     *
     * @default - Not included in the rule
     * @stability stable
     */
    readonly fromPort?: number;
    /**
     * The ending port for the range.
     *
     * @default - Not included in the rule
     * @stability stable
     */
    readonly toPort?: number;
    /**
     * String representation for this object.
     *
     * @stability stable
     */
    readonly stringRepresentation: string;
}
/**
 * Interface for classes that provide the connection-specification parts of a security group rule.
 *
 * @stability stable
 */
export declare class Port {
    private readonly props;
    /**
     * A single TCP port.
     *
     * @stability stable
     */
    static tcp(port: number): Port;
    /**
     * A TCP port range.
     *
     * @stability stable
     */
    static tcpRange(startPort: number, endPort: number): Port;
    /**
     * Any TCP traffic.
     *
     * @stability stable
     */
    static allTcp(): Port;
    /**
     * A single UDP port.
     *
     * @stability stable
     */
    static udp(port: number): Port;
    /**
     * A UDP port range.
     *
     * @stability stable
     */
    static udpRange(startPort: number, endPort: number): Port;
    /**
     * Any UDP traffic.
     *
     * @stability stable
     */
    static allUdp(): Port;
    /**
     * A specific combination of ICMP type and code.
     *
     * @see https://www.iana.org/assignments/icmp-parameters/icmp-parameters.xhtml
     * @stability stable
     */
    static icmpTypeAndCode(type: number, code: number): Port;
    /**
     * All codes for a single ICMP type.
     *
     * @stability stable
     */
    static icmpType(type: number): Port;
    /**
     * ICMP ping (echo) traffic.
     *
     * @stability stable
     */
    static icmpPing(): Port;
    /**
     * All ICMP traffic.
     *
     * @stability stable
     */
    static allIcmp(): Port;
    /**
     * All traffic.
     *
     * @stability stable
     */
    static allTraffic(): Port;
    /**
     * A single ESP port.
     *
     * @stability stable
     */
    static esp(): Port;
    /**
     * A single AH port.
     *
     * @stability stable
     */
    static ah(): Port;
    /**
     * Whether the rule containing this port range can be inlined into a securitygroup or not.
     *
     * @stability stable
     */
    readonly canInlineRule: boolean;
    /**
     * @stability stable
     */
    constructor(props: PortProps);
    /**
     * Produce the ingress/egress rule JSON for the given connection.
     *
     * @stability stable
     */
    toRuleJson(): any;
    /**
     * @stability stable
     */
    toString(): string;
}
