# coding: utf-8

"""
    Twitter OpenAPI

    Twitter OpenAPI(Swagger) specification

    The version of the OpenAPI document: 0.0.1
    Contact: yuki@yuki0311.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic import BaseModel, Field, StrictStr
from twitter_openapi_python_generated.models.content_item_type import ContentItemType
from twitter_openapi_python_generated.models.item_result import ItemResult
from twitter_openapi_python_generated.models.social_context import SocialContext
from twitter_openapi_python_generated.models.type_name import TypeName

class TimelineTweet(BaseModel):
    """
    TimelineTweet
    """
    social_context: Optional[SocialContext] = Field(None, alias="SocialContext")
    typename: TypeName = Field(..., alias="__typename")
    item_type: ContentItemType = Field(..., alias="itemType")
    promoted_metadata: Optional[Dict[str, Any]] = Field(None, alias="promotedMetadata")
    tweet_display_type: StrictStr = Field(..., alias="tweetDisplayType")
    tweet_results: ItemResult = Field(...)
    __properties = ["SocialContext", "__typename", "itemType", "promotedMetadata", "tweetDisplayType", "tweet_results"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TimelineTweet:
        """Create an instance of TimelineTweet from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of social_context
        if self.social_context:
            _dict['SocialContext'] = self.social_context.to_dict()
        # override the default output from pydantic by calling `to_dict()` of tweet_results
        if self.tweet_results:
            _dict['tweet_results'] = self.tweet_results.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TimelineTweet:
        """Create an instance of TimelineTweet from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TimelineTweet.parse_obj(obj)

        _obj = TimelineTweet.parse_obj({
            "social_context": SocialContext.from_dict(obj.get("SocialContext")) if obj.get("SocialContext") is not None else None,
            "typename": obj.get("__typename"),
            "item_type": obj.get("itemType"),
            "promoted_metadata": obj.get("promotedMetadata"),
            "tweet_display_type": obj.get("tweetDisplayType"),
            "tweet_results": ItemResult.from_dict(obj.get("tweet_results")) if obj.get("tweet_results") is not None else None
        })
        return _obj


