# coding: utf-8

"""
    Twitter OpenAPI

    Twitter OpenAPI(Swagger) specification

    The version of the OpenAPI document: 0.0.1
    Contact: yuki@yuki0311.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional
from pydantic import BaseModel, Field, StrictStr, conlist, validator
from twitter_openapi_python_generated.models.content_entry_type import ContentEntryType
from twitter_openapi_python_generated.models.module_item import ModuleItem

class TimelineTimelineModule(BaseModel):
    """
    TimelineTimelineModule
    """
    typename: StrictStr = Field(..., alias="__typename")
    client_event_info: Dict[str, Any] = Field(..., alias="clientEventInfo")
    display_type: StrictStr = Field(..., alias="displayType")
    entry_type: ContentEntryType = Field(..., alias="entryType")
    footer: Optional[Dict[str, Any]] = None
    header: Optional[Dict[str, Any]] = None
    items: Optional[conlist(ModuleItem)] = None
    __properties = ["__typename", "clientEventInfo", "displayType", "entryType", "footer", "header", "items"]

    @validator('display_type')
    def display_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('Vertical', 'VerticalConversation', 'Carousel'):
            raise ValueError("must be one of enum values ('Vertical', 'VerticalConversation', 'Carousel')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TimelineTimelineModule:
        """Create an instance of TimelineTimelineModule from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in items (list)
        _items = []
        if self.items:
            for _item in self.items:
                if _item:
                    _items.append(_item.to_dict())
            _dict['items'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TimelineTimelineModule:
        """Create an instance of TimelineTimelineModule from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TimelineTimelineModule.parse_obj(obj)

        _obj = TimelineTimelineModule.parse_obj({
            "typename": obj.get("__typename"),
            "client_event_info": obj.get("clientEventInfo"),
            "display_type": obj.get("displayType"),
            "entry_type": obj.get("entryType"),
            "footer": obj.get("footer"),
            "header": obj.get("header"),
            "items": [ModuleItem.from_dict(_item) for _item in obj.get("items")] if obj.get("items") is not None else None
        })
        return _obj


