# coding: utf-8

"""
    Twitter OpenAPI

    Twitter OpenAPI(Swagger) specification

    The version of the OpenAPI document: 0.0.1
    Contact: yuki@yuki0311.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json



from pydantic import BaseModel, Field
from twitter_openapi_python_generated.models.client_event_info import ClientEventInfo
from twitter_openapi_python_generated.models.instruction_type import InstructionType
from twitter_openapi_python_generated.models.timeline_half_cover import TimelineHalfCover

class TimelineShowCover(BaseModel):
    """
    TimelineShowCover
    """
    client_event_info: ClientEventInfo = Field(..., alias="clientEventInfo")
    cover: TimelineHalfCover = Field(...)
    type: InstructionType = Field(...)
    __properties = ["clientEventInfo", "cover", "type"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TimelineShowCover:
        """Create an instance of TimelineShowCover from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of client_event_info
        if self.client_event_info:
            _dict['clientEventInfo'] = self.client_event_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of cover
        if self.cover:
            _dict['cover'] = self.cover.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TimelineShowCover:
        """Create an instance of TimelineShowCover from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TimelineShowCover.parse_obj(obj)

        _obj = TimelineShowCover.parse_obj({
            "client_event_info": ClientEventInfo.from_dict(obj.get("clientEventInfo")) if obj.get("clientEventInfo") is not None else None,
            "cover": TimelineHalfCover.from_dict(obj.get("cover")) if obj.get("cover") is not None else None,
            "type": obj.get("type")
        })
        return _obj


