# coding: utf-8

"""
    Twitter OpenAPI

    Twitter OpenAPI(Swagger) specification

    The version of the OpenAPI document: 0.0.1
    Contact: yuki@yuki0311.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr, conlist, constr, validator
from twitter_openapi_python_generated.models.media_original_info import MediaOriginalInfo
from twitter_openapi_python_generated.models.media_sizes import MediaSizes

class Media(BaseModel):
    """
    Media
    """
    display_url: StrictStr = Field(...)
    expanded_url: StrictStr = Field(...)
    features: Optional[Dict[str, Any]] = None
    id_str: constr(strict=True) = Field(...)
    indices: conlist(StrictInt) = Field(...)
    media_url_https: StrictStr = Field(...)
    original_info: MediaOriginalInfo = Field(...)
    sizes: MediaSizes = Field(...)
    type: StrictStr = Field(...)
    url: StrictStr = Field(...)
    __properties = ["display_url", "expanded_url", "features", "id_str", "indices", "media_url_https", "original_info", "sizes", "type", "url"]

    @validator('id_str')
    def id_str_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^[0-9]+$", value):
            raise ValueError(r"must validate the regular expression /^[0-9]+$/")
        return value

    @validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('photo', 'video', 'animated_gif'):
            raise ValueError("must be one of enum values ('photo', 'video', 'animated_gif')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Media:
        """Create an instance of Media from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of original_info
        if self.original_info:
            _dict['original_info'] = self.original_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of sizes
        if self.sizes:
            _dict['sizes'] = self.sizes.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Media:
        """Create an instance of Media from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Media.parse_obj(obj)

        _obj = Media.parse_obj({
            "display_url": obj.get("display_url"),
            "expanded_url": obj.get("expanded_url"),
            "features": obj.get("features"),
            "id_str": obj.get("id_str"),
            "indices": obj.get("indices"),
            "media_url_https": obj.get("media_url_https"),
            "original_info": MediaOriginalInfo.from_dict(obj.get("original_info")) if obj.get("original_info") is not None else None,
            "sizes": MediaSizes.from_dict(obj.get("sizes")) if obj.get("sizes") is not None else None,
            "type": obj.get("type"),
            "url": obj.get("url")
        })
        return _obj


